// Class: ReadSVM
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : SVM::SVM
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:56:04 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
VarTransform: "Norm" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
Gamma: "2.500000e-01" [RBF kernel parameter: Gamma (size of the Kernel)]
Tol: "1.000000e-03" [Tolerance parameter]
# Default:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VerbosityLevel: "Default" [Verbosity level]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
Kernel: "RBF" [Pick which kernel ( RBF or MultiGauss )]
Order: "3" [Polynomial Kernel parameter: polynomial order]
Theta: "1.000000e+00" [Polynomial Kernel parameter: polynomial theta]
GammaList: "" [MultiGauss parameters]
Tune: "All" [Tune Parameters]
KernelList: "None" [Sum or product of kernels]
Loss: "hinge" [Loss function]
C: "1.000000e+00" [Cost parameter]
MaxIter: "1000" [Maximum number of training loops]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadSVM : public IClassifierReader {

 public:

   // constructor
   ReadSVM( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadSVM" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -1;
      fVmax[0] = 1;
      fVmin[1] = -1;
      fVmax[1] = 1;
      fVmin[2] = -1;
      fVmax[2] = 1;
      fVmin[3] = -1;
      fVmax[3] = 0.99999988079071;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadSVM() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   double fOff_1[3][4];
   double fScal_1[3][4];
   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   // not implemented for class: "ReadSVM"
   float        fBparameter;
   int          fNOfSuppVec;
   static float fAllSuppVectors[][1137];
   static float fAlphaTypeCoef[1137];

   // Kernel parameter(s) 
   float fGamma;
};

inline void ReadSVM::Initialize() 
{
   fBparameter = -0.377584457397461;
   fNOfSuppVec = 1137;
   fGamma = 0.25;
}

inline double ReadSVM::GetMvaValue__(const std::vector<double>& inputValues ) const
{
   double mvaval = 0; 
   double temp = 0; 

   for (int ievt = 0; ievt < fNOfSuppVec; ievt++ ){
      temp = 0;
      for ( unsigned int ivar = 0; ivar < GetNvar(); ivar++ ) {
         temp += (fAllSuppVectors[ivar][ievt] - inputValues[ivar])  
               * (fAllSuppVectors[ivar][ievt] - inputValues[ivar]); 
      }
      mvaval += fAlphaTypeCoef[ievt] * exp( -fGamma * temp ); 
   }
   mvaval -= fBparameter;
   return 1./(1. + exp(mvaval));
}
// Clean up
inline void ReadSVM::Clear() 
{
   // nothing to clear 
}

float ReadSVM::fAlphaTypeCoef[] =
{ -1, 0.133726671338081, -1, -1, -1, -1, -1, 0.126401394605637, 0.426829218864441, -1, 2.92765927314758, 0.618688821792603, 3.64293575286865, 1.2542769908905, -1, 0.00113087764475495, -1, -1, -1, -1, -1, 0.0632801577448845, -1, -1, -1, 1.23357939720154, 0.0238649882376194, 0.00495392363518476, -1, 0.514745473861694, -1, -1, -1, 3.06380844116211, 0.00965872965753078, -1, 3.43551206588745, -1, -1, 0.0292115695774555, 0.832218527793884, 0.016337925568223, -1, -1, -1, -1, -1, 0.0413720197975636, 0.135880246758461, 3.59287738800049, 2.36955642700195, -1, 1.29938662052155, -1, 0.6246178150177, -1, -1, 0.574555456638336, 3.64002442359924, -1, 0.0194861870259047, -1, -1, 3.64247679710388, 0.125284940004349, -1, -1, -1, -1, 3.62304401397705, -1, 2.05797743797302, 0.0269990675151348, -1, -1, -1, -1, 1.89832890033722, 1.00835621356964, 0.0244970824569464, -1, -1, -1, -1, 0.0365857481956482, -1, 0.00485378131270409, -1, -1, -1, 0.700072288513184, 0.00988965667784214, -1, 1.64334309101105, -1, -1, 0.000478251400636509, -1, 2.07610583305359, -1, -1, -1, -1, -1, -1, 0.146668583154678, 0.00550595438107848, 2.98777008056641, -1, -1, -1, 0.172167345881462, -1, -1, -1, -1, -1, -1, 0.324837148189545, 1.60194933414459, -1, -1, 0.0162570867687464, -1, -1, 0.695279359817505, 0.13057816028595, -1, -1, -1, -1, 0.00196893373504281, -1, 3.5650417804718, 3.52081203460693, -1, -1, 2.13364338874817, 0.175518542528152, -1, 0.97782838344574, -1, -1, -1, -1, -1, -1, 0.210102319717407, -1, 0.164197340607643, -1, 1.54431593418121, -1, -1, 0.0922280848026276, -1, 3.32894492149353, 0.00872016418725252, -1, -1, -1, 2.14608311653137, -1, 1.17517471313477, 3.04132223129272, 0.0133807631209493, 0.459639936685562, 0.0423094928264618, 0.140617161989212, 1.05984306335449, -1, -1, -1, 2.13326168060303, -1, -1, 1.96043002605438, -1, 0.0213139336556196, -1, 0.00140451523475349, -1, -1, -1, 0.43744695186615, -1, 2.92286133766174, -1, -1, 2.47106647491455, -1, 0.00678165117278695, 0.000251671852311119, 0.000305873749312013, -1, -1, -1, -1, -1, -1, -1, 0.0672483965754509, 1.71006917953491, -1, 1.76375198364258, 0.0030781221576035, -1, -1, 0.316297352313995, -1, -1, 1.34580183029175, -1, -1, -1, -1, 2.41412854194641, 0.051766648888588, -1, 1.71815133094788, 0.0188791211694479, -1, -1, -1, -1, 0.0190124809741974, 0.758541643619537, -1, -1, -1, -1, -1, 0.0410913228988647, -1, -1, 3.47165727615356, -1, 3.07218718528748, -1, 1.02718997001648, -1, -1, -1, 3.00001168251038, -1, 0.000696196337230504, -1, -1, -1, -1, -1, -1, 0.000284771842416376, -1, 0.000873758981470019, -1, -1, 3.64002680778503, -1, -1, 0.107350900769234, 1.49134016036987, -1, -1, -1, -1, -1, 0.00112737144809216, -1, -1, -1, 0.634135663509369, -1, 0.0389666669070721, -1, 0.251727133989334, -1, -1, 0.0116039197891951, -1, 3.49938321113586, -1, -1, -1, 0.00711033120751381, -1, -0.411071002483368, -1, -1, 0.0254419930279255, 3.52980780601501, 0.00449418276548386, -1, -1, 0.0793942213058472, -1, 0.98614090681076, -1, 0.138310790061951, -1, 0.0111416336148977, 0.0203324034810066, -1, 3.12468290328979, -1, 2.61284852027893, -1, 1.46284484863281, -1, -1, 0.190915659070015, -1, -1, -1, -1, -1, 1.99524748325348, -1, -1, 0.0309107545763254, 0.00147599773481488, -1, -1, -1, -1, 0.870078086853027, 0.162341922521591, 3.61451864242554, 0.000825454539153725, 0.0222130063921213, -1, -1, 0.0103851445019245, 0.388339906930923, -1, 0.508967041969299, 1.48919546604156, 3.64561581611633, 1.08198463916779, 0.188782125711441, 0.00117135839536786, -1, 0.0172518361359835, -1, -1, 2.1191041469574, -0.673479437828064, -1, 3.54855942726135, 0.186171561479568, -1, 3.55158281326294, 0.839722752571106, -1, -1, 0.0147547796368599, 0.399722069501877, -1, 3.48434209823608, -1, 0.0879736095666885, -1, -1, -1, 0.599462985992432, -1, -1, 3.32646083831787, -1, 2.12292838096619, 0.0179909504950047, 2.19360160827637, 0.0155289229005575, 1.21900713443756, 3.61135244369507, -1, -1, 1.4876526594162, -1, -1, 1.09159719944, -1, -1, 0.00352430786006153, -1, -1, -1, -1, 0.0613948777318001, 0.00419183634221554, -1, 0.00952736474573612, -1, -1, -1, 0.00203606928698719, 0.119309708476067, 3.19515514373779, 2.37190818786621, 0.0762344151735306, -1, 0.1212502643466, -1, -1, -1, -1, -1, 1.29375386238098, 1.06260228157043, 3.47659373283386, -1, -1, -1, -1, -1, -1, 1.47260797023773, 0.000326689216308296, 0.00764964567497373, -1, -1, -1, 0.179102703928947, 3.20141935348511, -1, -1, -1, -1, -1, -1, -1, 0.0427689366042614, 0.0739718452095985, -1, 0.0824392959475517, -1, 0.110837310552597, 3.644690990448, -1, 0.00878998637199402, -1, -1, 2.94472670555115, -1, -1, 0.0743653252720833, 3.63589835166931, -1, -1, 1.49872517585754, -1, -1, -1, -1, -1, -1, 0.00219605001620948, -1, -1, 0.546183109283447, 3.55517363548279, 0.218282148241997, 2.88460516929626, -1, 0.0650815740227699, -1, 1.30548095703125, -1, 3.63827610015869, 3.35554099082947, 2.39460134506226, -1, 2.90945053100586, 2.35487818717957, -1, 3.28181791305542, 1.86991059780121, 0.813955783843994, -1, -1, -1, 3.59921765327454, 2.01574873924255, 2.37901449203491, 1.36619520187378, 0.00952446740120649, -1, 3.64340901374817, 1.60612070560455, 2.99005818367004, -1, -1, 3.31324911117554, 0.00445850100368261, -1, 0.926852405071259, -1, 2.36222696304321, 3.64427781105042, -1, 3.29261994361877, 0.179591238498688, -1, 2.28585529327393, -1, 0.0958567038178444, 0.00237471051514149, -1, -1, 0.729495286941528, 2.31865501403809, 0.283393204212189, -1, 3.61515402793884, -1, -1, -1, 2.15033388137817, -1, 3.61832022666931, -1, 0.864587247371674, -1, -1, -1, -1, 0.0271334443241358, 3.22483372688293, 0.15094093978405, 0.189739689230919, 2.82014226913452, -1, -1, 1.8183171749115, 0.0524690598249435, -1, -1, 3.5073299407959, 0.00373650132678449, -1, -1, 3.55611324310303, 3.4403190612793, -1, -1, -1, 3.42418241500854, 0.00125404389109462, 0.00771123450249434, 2.12512302398682, -1, 0.104811258614063, -1, 3.36744070053101, -1, -1, 0.3788703083992, 0.0411466062068939, 0.0265416782349348, 0.245029583573341, 1.13647079467773, 3.38596415519714, 2.39312100410461, 1.70718669891357, -1, -1, -1, -1, -1, 0.0686795189976692, -1, -1, 0.0095220198854804, -1, 0.00193839229177684, 2.64945316314697, 0.0307067539542913, 3.46776413917542, -1, -1, -1, 0.393309593200684, -1, -1, 1.91865110397339, -1, -1, -1, 0.229770243167877, 0.0503786355257034, -1, 0.480565130710602, -1, -1, 0.0194073524326086, -1, 0.744468152523041, 0.0178665667772293, 2.94961309432983, 2.66167211532593, 3.52664732933044, -1, -1, 0.0966565832495689, -1, 3.19636058807373, 0.0014958466636017, -1, -1, -1, -1, -1, 0.190519452095032, 0.960515201091766, 0.163770973682404, 0.016380287706852, -1, 0.00167162623256445, -1, 3.56194376945496, 2.63689422607422, -1, 0.0144012104719877, -1, -1, 0.095433846116066, 0.176474466919899, 0.705870926380157, 0.757431745529175, -1, -1, -1, -1, -1, 2.44255685806274, 1.81080269813538, -1, 0.379743278026581, 0.0268651340156794, 0.230167478322983, -1, -1, -1, -1, -1, -1, 0.00256273220293224, 0.00393457245081663, -1, 0.643456757068634, -1, -1, -1, -1, 0.014072516001761, 2.54731011390686, -1, -1, 1.44953227043152, -1, 1.81127750873566, -1, 3.39495491981506, -1, 0.445861548185349, -1, -1, -1, 0.000454550870927051, -1, 0.56809663772583, 0.0227072965353727, -1, -1, -1, -1, 0.0039555998519063, 0.0430860184133053, 0.271579712629318, 0.00207886751741171, 1.66257548332214, 3.6322865486145, 0.485223442316055, 0.355515122413635, -1, -1, 0.195929855108261, 0.0341461263597012, -1, 0.117063976824284, -1, 0.131626412272453, 2.90876841545105, 0.0097231175750494, 0.332423150539398, -1, -1, 0.255388259887695, 0.762789189815521, -1, 0.000874560442753136, 0.269310295581818, 2.31424999237061, 2.05666828155518, 0.203789412975311, -1, -1, -1, -1, 0.00468286592513323, -1, 0.224966987967491, -1, -1, -1, 2.3579432964325, -1, -1, 0.380311489105225, -0.619412660598755, 0.779982089996338, -1, 2.35986256599426, 0.0369885675609112, 0.00799796730279922, 0.00246524251997471, 1.8497748374939, -1, -1, -1, -0.0236737728118896, -1, 0.00722381146624684, -1, -1, 0.0342007465660572, -1, 0.130415096879005, -1, 3.02077507972717, -1, 0.273036926984787, -1, 0.0112575320526958, 3.62639379501343, 0.962886393070221, -1, 3.53263974189758, -1, -1, -1, 0.0127856889739633, -1, 2.9818754196167, -1, 0.0756172761321068, -1, -1, 3.47619700431824, -1, -1, 0.00169155129697174, 2.77818441390991, 2.92466473579407, -1, -1, 1.02225601673126, -1, 2.45270848274231, -1, -1, -1, 0.00435774261131883, -0.51633358001709, 0.921063303947449, -1, -1, -1, 0.141362130641937, 0.111079603433609, 1.53654849529266, 0.0039470843039453, -1, 3.2839686870575, 0.0116755645722151, -1, -1, 3.63634347915649, -1, -1, 0.134518697857857, 0.000310784613247961, 0.274655222892761, 0.643455743789673, -1, -1, 3.30290937423706, -1, 0.0034182162489742, -1, 3.56286239624023, -1, -1, 3.63207840919495, -1, 0.000225676267291419, 3.58021855354309, 0.0298963449895382, -1, -1, -1, -1, 0.749232828617096, -1, 3.51478576660156, -1, -1, 8.99511942407116e-05, 3.08117127418518, 0.00299617974087596, 0.00544270128011703, -1, -1, 0.00845947582274675, 0.0968886837363243, 3.40404963493347, 3.58199167251587, -1, 0.67795991897583, -1, 3.12436556816101, -1, 0.442048668861389, 0.0782788321375847, 0.000659131037537009, -1, 0.000257941748714074, 0.00825241301208735, -1, -1, -1, -1, 0.0388402678072453, 1.17650651931763, -1, -1, 0.00699637550860643, 0.00895746052265167, -1, -1, 0.0224074572324753, 3.15267753601074, -1, 0.000642819970380515, -1, 0.918116867542267, 0.0114674661308527, 2.99003553390503, -1, -1, -1, -1, 0.000160164156113751, -1, -1, 0.00159524451009929, -1, -1, 1.97377693653107, -1, 0.00413825921714306, -1, 0.0246087554842234, 2.73937463760376, -1, -1, 0.00578203797340393, 3.35423135757446, -1, 0.0806830897927284, -1, -1, 2.83903074264526, 0.0028618227224797, -1, 3.6284704208374, -1, -1, -1, -1, -1, -1, 0.00306308432482183, 3.62664413452148, 0.00490721222013235, -1, -1, -1, 0.0175940580666065, 0.0158380921930075, 2.52502012252808, -1, -1, 0.690187931060791, -1, -1, -1, 2.00838875770569, -1, -1, 0.00996353384107351, -1, 3.42640376091003, 0.134538248181343, 0.00142633041832596, 0.000538578780833632, -1, -1, -1, -1, 0.0260970070958138, -1, 0.00145742809399962, 1.46789407730103, -1, 1.33800446987152, -1, -1, -1, -1, 0.204490885138512, -1, -1, 0.0383319668471813, 0.100545637309551, -1, 2.6228985786438, 0.152644917368889, -1, 0.00397829152643681, 0.0205662399530411, -1, -1, -1, 0.000166497309692204, -1, -1, -1, -1, -1, 0.0204053483903408, 0.79142153263092, -1, 0.000978359836153686, 0.29999777674675, -1, 1.31056070327759, 3.6431770324707, 0.565244436264038, -1, -1, 2.42267751693726, 0.00665847864001989, 3.1103663444519, -1, -1, -1, -1, -1, -1, -1, 1.60443460941315, 1.32122957706451, 3.38666892051697, -1, -1, 2.13143563270569, 0.314236491918564, -1, 2.97601342201233, -1, 0.591704249382019, -1, -1, -1, -1, -1, 0.00150822871364653, -1, 0.284074038267136, 0.00543736899271607, 1.19949114322662, -1, -1, -1, 0.199209436774254, 0.00160877441521734, -1, 1.43558156490326, -1, -1, -1, -1, -1, 0.00238708639517426, -1, -1, -1, 1.80675935745239, 0.00328725553117692, 0.00505100516602397, -1, 0.136446729302406, -1, 0.546400308609009, -1, 1.43245804309845, 2.45621824264526, -1, -1, -1, 0.00090864795492962, -1, 1.83820748329163, 0.260926395654678, 0.110464245080948, -1, -1, -1, -1, 3.64360237121582, 2.962069272995, -1, 0.0343642756342888, 0.0916542336344719, -1, 3.53045892715454, -1, 3.28012275695801, -1, -1, 0.520235538482666, 3.26295256614685, 0.00173910765442997, 0.133873373270035, -1, 0.0335995554924011, -1, 0.0113887088373303, 3.19033408164978, -1, 0.326157510280609, 3.49638032913208, 3.63306260108948, 1.86308431625366, -1, 0.281806290149689, 3.09011340141296, -1, 0.00282643875107169, 0.0302982144057751, -1, 1.84431159496307, -0.728269279003143, 0.0759222358465195, -1, -1, 1.35590374469757, 0.231934800744057, 0.0582276061177254, -1, -1, -1, 0.00869357585906982, 3.43628144264221, -1, -1, -1, 0.00494943978264928, 0.205315917730331, -1, -1, -1, -1, 3.10638880729675, 2.96497392654419, 0.644724905490875, 3.25766587257385, -1, -1, -1, -1, -1, -1, 0.00131813739426434, -1, 0.457650482654572, -1, 0.0046938587911427, 0.000720476207789034, 0.00095082848565653, 1.77980613708496, 0.0136011932045221, -1, 3.56316709518433, -1, 3.57698440551758, 3.61971855163574, 0.629659950733185, -1, 0.124663658440113, 0.055941067636013, -1, -1, -1, -1, 0.00344817526638508, -1, -1, 0.123695388436317, -1, -1, -1, 0.866796910762787, 0.0275232773274183, -1, 0.253990352153778, 0.102728627622128, 0.429487884044647, -1, -1, 0.000593035889323801, -1, 0.000962584337685257, -1, 2.11775684356689, -1 };

float ReadSVM::fAllSuppVectors[][1137] =
{
   { 0.0578974485397339, 0.557299494743347, 0.354334831237793, -0.0123570561408997, 0.686615228652954, 0.0829125642776489, -0.0347123742103577, 0.569592952728271, 0.52448582649231, 0.151525020599365, -0.235653579235077, 0.367312788963318, -0.0380650758743286, 0.315667748451233, 0.400094509124756, 0.855074405670166, 0.0818910598754883, 0.0428283214569092, 0.391176819801331, 0.186266660690308, 0.278943419456482, 0.606233596801758, 0.231746792793274, 0.28613007068634, 0.0423107147216797, 0.442943334579468, 0.763052344322205, 0.699632167816162, 0.14637017250061, 0.340697288513184, 0.252795934677124, 0.211516380310059, 0.344614744186401, -0.00822240114212036, 0.740842700004578, 0.14948034286499, 0.0412843227386475, 0.456293940544128, 0.123286962509155, 0.692214250564575, 0.477814674377441, 0.718937516212463, 0.587004780769348, -0.289846122264862, 0.303353309631348, 0.137438893318176, -0.12390661239624, 0.553054094314575, 0.673897385597229, 0.0601277351379395, 0.249362468719482, 0.638322949409485, -0.0447604060173035, -0.23600560426712, 0.568920612335205, 0.458324193954468, 0.319780826568604, 0.493585824966431, 0.04974365234375, -0.500850558280945, 0.591587901115417, 0.0806460380554199, 0.328575611114502, 0.0982339382171631, 0.651450753211975, 0.0818065404891968, 0.064301609992981, 0.245075941085815, 0.201486349105835, 0.0837908983230591, 0.197519659996033, -0.264734268188477, 0.509561657905579, 0.154965996742249, -0.0888713002204895, 0.461416244506836, -0.237965106964111, -0.255084693431854, 0.33318030834198, 0.645800709724426, 0.129934787750244, 0.113258481025696, -0.0725370645523071, 0.645292997360229, 0.632179856300354, 0.286450386047363, 0.782743811607361, 0.128675580024719, 0.271677374839783, -0.100488722324371, 0.301969885826111, 0.62858510017395, 0.227718353271484, 0.446183323860168, -0.00281310081481934, -0.215412020683289, 0.818701267242432, 0.0857037305831909, 0.22062873840332, 0.0114128589630127, -0.141046762466431, -0.1237633228302, 0.0725513696670532, 0.115504264831543, -0.0109228491783142, 0.532586574554443, 0.653508543968201, 0.187797427177429, 0.210667490959167, -0.0878764390945435, 0.249135375022888, 0.524280786514282, 0.185019969940186, 0.153438568115234, 0.158997178077698, 0.220603466033936, -0.0444964170455933, -0.0212097764015198, 0.454125761985779, 0.284398674964905, 0.235544800758362, 0.0463476181030273, 0.631021499633789, 0.127582430839539, 0.0398187637329102, 0.358146190643311, 0.55656373500824, 0.0904090404510498, 0.118151068687439, 0.234381079673767, 0.182274103164673, 0.877999305725098, -0.228645443916321, 0.00392115116119385, 0.0378257036209106, 0.212213754653931, -0.0429645180702209, 0.277410507202148, 0.684147119522095, 0.175665378570557, 0.314284801483154, -0.225879430770874, 0.134494304656982, 0.00826776027679443, -0.0899724364280701, 0.206523537635803, -0.145072281360626, 0.501084327697754, -0.0481954216957092, 0.586932778358459, 0.459284424781799, 0.350903987884521, 0.0338014364242554, 0.305877923965454, 0.697943568229675, 0.105892419815063, -0.00664710998535156, 0.698777198791504, 0.155975461006165, -0.344868063926697, 0.343846917152405, -0.206766843795776, 0.0487054586410522, 0.351384878158569, 0.227291941642761, 0.743173241615295, 0.374848246574402, 0.652965784072876, 0.700635671615601, 0.367855906486511, 0.324776530265808, -0.212891161441803, 0.382942676544189, -0.228223621845245, 0.0772044658660889, 0.215372085571289, -0.301424324512482, 0.421268820762634, 0.641887187957764, 0.615389943122864, 0.838096022605896, -0.0127931833267212, 0.437915682792664, 0.188836574554443, 0.512161254882812, -0.201607346534729, 0.132513046264648, 0.102184295654297, -0.203702569007874, 0.247922420501709, 0.336174607276917, 0.797374248504639, 0.914500117301941, 0.996336221694946, 0.144523143768311, -0.0472192764282227, 0.267593383789062, 0.206069946289062, -0.154007256031036, 0.104836702346802, 0.389792799949646, 0.65522289276123, 0.169402360916138, 0.440011978149414, 0.322592258453369, 0.778490900993347, -0.0237763524055481, 0.0730797052383423, 0.488981962203979, 0.414580106735229, 0.0575802326202393, 0.368518829345703, -0.0531245470046997, 0.0360552072525024, 0.319052457809448, 0.378299474716187, 0.101803064346313, 0.747143387794495, 0.207791686058044, 0.221725821495056, 0.71195650100708, 0.498509407043457, -0.0682920217514038, 0.375423908233643, 0.212551951408386, 0.860155463218689, 0.397563695907593, 0.31932258605957, 0.343666434288025, 0.234971880912781, 0.122417330741882, 0.100135445594788, 0.653606653213501, 0.0182656049728394, -0.0710517168045044, -0.0830039978027344, 0.114200949668884, 0.0612859725952148, 0.463284730911255, 0.326567888259888, 0.0813456773757935, 0.450539469718933, -0.0415909290313721, 0.13382875919342, 0.0915858745574951, 0.9470055103302, 0.155081391334534, 0.0764400959014893, 0.158246278762817, -0.0734749436378479, 0.435619473457336, 0.0362820625305176, 0.980890154838562, 0.0505058765411377, 0.835395336151123, 0.441529631614685, 0.271722555160522, 0.0122743844985962, 0.0991890430450439, -0.292352080345154, 0.69994843006134, 0.418192744255066, 0.243777871131897, -0.0121270418167114, 0.148949503898621, -0.259865999221802, 0.238994479179382, 0.718351602554321, 0.0731079578399658, 0.168477296829224, -0.179261982440948, 0.486328840255737, -0.0407640337944031, 0.617003798484802, 0.246919512748718, 0.528366923332214, 0.0388534069061279, 0.245327115058899, 0.764081001281738, -0.0726392865180969, -0.0587843060493469, 0.364623188972473, -0.011055588722229, 0.274482488632202, 0.71215832233429, 0.130746722221375, 0.296557545661926, 0.177244782447815, -0.0821274518966675, 0.72883939743042, 0.0560077428817749, 0.711718678474426, 0.156073808670044, -0.0368836522102356, 0.580305099487305, 0.160385370254517, 0.223006844520569, 0.154061913490295, 0.640937209129333, 0.11857008934021, 0.767998576164246, 0.620388150215149, -0.0315288901329041, -0.161135375499725, 0.0903712511062622, 0.172030091285706, 0.190499782562256, 0.45160961151123, 0.243427515029907, 0.487789034843445, 0.330741167068481, 0.198355555534363, 0.365233898162842, -0.0674168467521667, -0.0889584422111511, 0.285071849822998, -0.15222293138504, -0.215981245040894, -0.0621432662010193, 0.744043231010437, 0.919861078262329, 0.0100604295730591, 0.0777804851531982, 0.251043319702148, 0.234891772270203, 0.32896888256073, 0.571066975593567, 0.131155848503113, 0.889559030532837, 0.68050217628479, 0.333272695541382, -0.304073750972748, 0.536598682403564, 0.480973720550537, -0.110185503959656, 0.459306359291077, 0.271257519721985, 0.0479848384857178, 0.502709865570068, 0.47693395614624, 0.902845740318298, 0.129560947418213, 0.637909650802612, 0.390410661697388, 0.370060324668884, 0.280689597129822, 0.22935688495636, -0.0390415191650391, -0.00684934854507446, 0.524215579032898, -0.0913400053977966, 0.0878443717956543, 0.425964593887329, -0.111489593982697, -0.0810939073562622, 0.733681917190552, 0.485260605812073, -0.0925989747047424, 0.0290290117263794, 0.227723121643066, 0.589786052703857, 0.193551540374756, 0.165240526199341, 0.238295793533325, 0.547088384628296, 0.26823103427887, 0.166428923606873, 0.135328531265259, 0.119870543479919, 0.16724705696106, 0.596813082695007, 0.384519338607788, 0.665791630744934, 0.259888887405396, -0.0641188621520996, 0.333000898361206, 0.0975124835968018, 0.26798951625824, 0.342930197715759, 0.429647564888, 0.251685619354248, 0.053269624710083, 0.403802394866943, 0.68988311290741, 0.376126646995544, 0.105384111404419, 0.170302152633667, 0.0122789144515991, 0.720144510269165, 0.862374782562256, 0.191394448280334, 0.659639239311218, -0.0653036832809448, 0.452754974365234, 0.0863044261932373, 0.903926610946655, 0.495498418807983, 0.145439028739929, 0.307736277580261, 0.47418999671936, 0.259997725486755, 0.768257975578308, -0.0573796629905701, -0.265232622623444, 0.117692232131958, 0.0943355560302734, 0.127628803253174, 0.287670493125916, 0.457383275032043, 0.137137293815613, 0.0835708379745483, 0.121873140335083, 0.00236999988555908, 0.124838352203369, 0.211514353752136, 0.186163425445557, 0.354033708572388, 1, 0.707384586334229, 0.299282431602478, 0.416340708732605, -0.202280521392822, 0.702512979507446, 0.245713233947754, 0.0961049795150757, 0.103236436843872, 0.0621587038040161, -0.0276621580123901, 0.341430425643921, 0.0972254276275635, 0.486141204833984, 0.653950810432434, 0.613291263580322, 0.249423265457153, 0.678499937057495, 0.156983137130737, 0.574396967887878, -0.0524313449859619, 0.211020827293396, 0.639274835586548, -0.0912778377532959, 0.301529765129089, -0.218741118907928, 0.436995387077332, -0.00970000028610229, 0.450481057167053, 0.061210036277771, 0.423734545707703, -0.0446052551269531, 0.421748161315918, 0.0701168775558472, 0.344589829444885, 0.140477538108826, 0.198192954063416, 0.127448678016663, -0.0264854431152344, 0.796316981315613, 0.108230233192444, 0.138076186180115, 0.394334554672241, 0.158023953437805, 0.0103987455368042, 0.301086664199829, -0.0462306141853333, 0.623328924179077, 0.154061079025269, 0.269489645957947, 0.221148252487183, 0.0039292573928833, 0.203996777534485, 0.274942398071289, 0.0507881641387939, 0.165498733520508, 0.210491299629211, 0.296781778335571, 0.120552539825439, 0.350144624710083, 0.345535278320312, 0.108886957168579, 0.0563399791717529, -0.0813148021697998, -0.0421361327171326, -0.219026923179626, 0.302195310592651, 0.32091748714447, 0.739084482192993, 0.0562138557434082, 0.0937950611114502, 0.371874570846558, 0.251060843467712, 0.0673993825912476, -0.177007973194122, 0.0873994827270508, 0.726470112800598, 0.394399046897888, 0.431607961654663, 0.0787417888641357, 0.281020283699036, -0.0279198884963989, 0.0293823480606079, -0.0727097392082214, 0.531266927719116, -0.184551298618317, 0.419021010398865, -0.0132295489311218, 0.593020915985107, 0.882126212120056, -0.0900941491127014, -0.0474877953529358, 0.415881514549255, 0.371456503868103, 0.384883284568787, 0.185935854911804, -0.0788853764533997, -0.280457139015198, -0.0665990114212036, 0.328355431556702, -0.283863186836243, 0.0148104429244995, 0.0571553707122803, 0.11429238319397, 0.586708664894104, 0.115161895751953, 0.24670398235321, 0.143073201179504, 0.0775871276855469, 0.855012059211731, -0.0278815627098083, 0.4552983045578, 0.517658948898315, 0.0607857704162598, -0.11705756187439, -0.254959344863892, 0.383834838867188, 0.54669451713562, 0.0106748342514038, -0.35590273141861, -0.0205273628234863, 0.757255554199219, -0.113177895545959, 0.0874751806259155, 0.140233874320984, 0.153855919837952, 0.0571871995925903, 0.34919261932373, 0.344050049781799, -0.037714421749115, 0.919077396392822, 0.763051867485046, 0.340475559234619, 0.362123608589172, 0.665386438369751, 0.210956215858459, 0.152874231338501, 0.0414811372756958, -0.108734309673309, 0.359285354614258, 0.583490967750549, 0.668054819107056, 0.525294423103333, 0.2920001745224, 0.118983864784241, -0.137840390205383, 0.321530818939209, 0.2512446641922, 0.160758137702942, 0.0689443349838257, 0.272521376609802, 0.578076004981995, 0.716745018959045, 0.0364605188369751, -0.0934569835662842, 0.811861157417297, -0.100437939167023, 0.765735745429993, -0.0624951720237732, 0.603990197181702, 0.137380003929138, -0.117551147937775, 0.0235297679901123, 0.0604838132858276, 0.521861791610718, 0.307454347610474, 0.221390962600708, 0.240381598472595, -0.143265306949615, -0.0353477597236633, 0.253854155540466, 0.491012096405029, 0.639886617660522, 0.0922815799713135, 0.571411490440369, 0.167642951011658, 0.22874641418457, 0.659148097038269, 0.168309569358826, 0.416650652885437, 0.726116061210632, -0.189256131649017, 0.208260893821716, -0.00206071138381958, 0.0824395418167114, 0.116736054420471, 0.600684404373169, 0.530088305473328, -0.114245653152466, 0.775699019432068, 0.0241347551345825, -0.271007597446442, 0.283830642700195, 0.154769062995911, -0.119768917560577, 0.57082462310791, 0.337223529815674, 0.613365292549133, 0.774738192558289, 0.202178359031677, 0.730755925178528, -0.0166230797767639, 0.0825978517532349, 0.263676047325134, 0.491350293159485, 0.641405940055847, 0.358133316040039, 0.374364614486694, 0.436646342277527, 0.53734290599823, 0.511351704597473, 0.372818470001221, 0.0772948265075684, 0.0240634679794312, 0.153959989547729, 0.294888973236084, 0.39649224281311, -0.223402321338654, 0.11336886882782, 0.025664210319519, 0.393536448478699, 0.591461539268494, 0.575911402702332, 0.122240900993347, 0.360017418861389, 0.0660856962203979, 0.30043625831604, 0.199012160301208, 0.213750839233398, 0.820895552635193, 0.723210215568542, -0.00792205333709717, 0.410352945327759, 0.113182187080383, 0.101201295852661, 0.387325406074524, 0.113336682319641, 0.752177119255066, 0.294082999229431, 0.237648129463196, 0.130246162414551, 0.340427398681641, 0.0990927219390869, 0.394852995872498, 0.053979754447937, 0.00357222557067871, 0.0460507869720459, 0.443665623664856, 0.143842935562134, 0.0819160938262939, -0.0192110538482666, 0.819263696670532, 0.245226263999939, 0.404949903488159, 0.774650573730469, -0.0162063241004944, -0.359458982944489, 0.0995088815689087, 0.108652949333191, 0.683498501777649, 0.667509078979492, 0.565296649932861, 0.898014903068542, 0.237711429595947, 0.0574626922607422, 0.502963066101074, 0.337261199951172, -0.0649466514587402, 0.348249197006226, 0.473251342773438, 0.625324368476868, 0.458640098571777, 0.621440887451172, -0.0282050371170044, 0.527918815612793, 0.245504379272461, 0.628695130348206, 0.608370423316956, 0.0551235675811768, 0.0469585657119751, 0.540019512176514, 0.452021718025208, 0.493925333023071, 0.917067408561707, 0.503940224647522, 0.359387755393982, 0.411401152610779, 0.532093167304993, 0.365924119949341, 0.300123572349548, 0.07375168800354, -0.150019943714142, 0.821077346801758, -0.0987441539764404, 0.638000845909119, 0.190674066543579, 0.22722315788269, -0.0432581305503845, -0.26109367609024, 0.270322799682617, -0.182587265968323, 0.506242036819458, 0.396538615226746, 0.48643970489502, 0.133639216423035, 0.294865846633911, 0.712008953094482, 0.639432191848755, 0.879643678665161, -0.286849319934845, -0.0483418703079224, 0.216004610061646, -0.100887894630432, 0.488312482833862, -0.0591556429862976, 0.72613263130188, -0.0201643109321594, 0.178442716598511, 0.536173462867737, 0.377799987792969, 0.425104022026062, 0.139970898628235, 0.0635600090026855, -0.0312667489051819, 0.548475503921509, 0.332884192466736, 0.738345146179199, 0.0815789699554443, 0.373203158378601, -0.039448618888855, 0.0113096237182617, 0.229724764823914, -0.177732050418854, -0.0796633362770081, 0.797961115837097, 0.382621049880981, -0.0926287174224854, 0.0750757455825806, 0.504950404167175, -0.24726527929306, 0.214943885803223, 0.0484942197799683, -0.0403569936752319, -0.287042260169983, 0.768142461776733, 0.1725914478302, 0.236993432044983, 0.388990044593811, 0.154936552047729, 0.303490161895752, 0.161826491355896, 0.24033784866333, 0.165554881095886, 0.116710782051086, 0.482102036476135, 0.776127338409424, 0.163846731185913, 0.39035427570343, 0.0731557607650757, 0.149740099906921, 0.287724018096924, 0.6487957239151, 0.559621691703796, 0.294833779335022, 0.789835453033447, 0.10997474193573, 0.0154063701629639, 0.712108373641968, 0.0196083784103394, 0.189710736274719, 0.164280533790588, -0.128057658672333, 0.0285451412200928, 0.638707637786865, 0.922074913978577, 0.553795337677002, 0.37769615650177, 0.395597696304321, 0.0156067609786987, -0.000743269920349121, -0.0994030833244324, 0.802749037742615, 0.0173563957214355, -0.0182015299797058, -0.130881667137146, 0.146496057510376, -0.0566632151603699, 0.0142217874526978, 0.890050292015076, -0.00871109962463379, 0.619429588317871, -0.0939279198646545, 0.365672826766968, 0.228094458580017, 0.0456380844116211, 0.360291957855225, -0.0263150334358215, -0.0255362391471863, 0.271622657775879, 0.339693546295166, 0.814358234405518, 0.259908199310303, 0.964081287384033, 0.653620004653931, 0.211522102355957, 0.0287473201751709, 0.686190128326416, 0.587899446487427, 0.066489577293396, -0.0197386741638184, 0.24760913848877, 0.463796377182007, 0.15954852104187, 0.252052664756775, -0.246660351753235, 0.494158625602722, 0.48608660697937, 0.833445429801941, 0.0973342657089233, 0.948284149169922, 0.735976338386536, 0.322078704833984, 0.145686864852905, -0.0993645787239075, -0.474014639854431, 0.643453001976013, 0.337510943412781, 0.39426052570343, 0.288443922996521, 0.802770137786865, 0.819411396980286, -0.11533796787262, -0.13353818655014, 0.669864416122437, 0.204954147338867, 0.181888103485107, 0.885169744491577, 0.116858839988708, 0.285307765007019, 0.765492081642151, -0.130847930908203, -0.00618308782577515, -0.182860553264618, 0.194121956825256, 0.118952631950378, 0.890891432762146, 0.0305325984954834, 0.314556241035461, 0.881901025772095, 0.00863969326019287, 0.282772898674011, 0.208565354347229, 0.236843228340149, 0.89870297908783, 0.0136997699737549, 0.769816517829895, 0.142024517059326, -0.194593608379364, -0.0037381649017334, 0.79279088973999, 0.187962889671326, -0.268780112266541, 0.676175475120544, 0.140758395195007, 0.218877792358398, 0.204655408859253, 0.750754833221436, 0.211201548576355, 0.0839841365814209, 0.21177077293396, 0.0323555469512939, -0.152817070484161, 0.112829804420471, -0.0150827169418335, 0.0872436761856079, 0.818595409393311, 0.027178168296814, 0.73180091381073, 0.00142669677734375, 0.198814272880554, -0.0447537899017334, 0.816173076629639, 0.637278318405151, 0.246802449226379, 0.202999472618103, 0.274443030357361, 0.421416640281677, -0.0297541618347168, -0.0621724128723145, 0.0943430662155151, 0.336976289749146, -0.147619783878326, 0.0102331638336182, 0.791382312774658, 0.0824708938598633, 0.0644129514694214, 0.373713374137878, 0.846747636795044, 0.842586398124695, 0.0964176654815674, 0.451601386070251, -0.223655223846436, 0.302388668060303, 0.655175089836121, 0.26087498664856, 0.797348141670227, 0.415030121803284, 0.265295386314392, 0.324421763420105, -0.00867712497711182, 0.173255205154419, 0.0440057516098022, -0.226567327976227, 0.476397156715393, 0.317450284957886, 0.250980377197266, 0.626752495765686, 0.647552490234375, 0.154282808303833, 0.203954935073853, 0.599640369415283, 0.257436394691467, 0.807535886764526, 0.628497123718262, -0.0262293815612793, 0.319890141487122, 0.0830750465393066, 0.839553833007812, 0.151601552963257, 0.220837712287903, -0.0121747851371765, 0.106391310691833, 0.00628137588500977, 0.632305860519409, 0.376530647277832, 0.208299040794373, 0.952096462249756, 0.460119962692261, -0.135943412780762, 0.31973659992218, -0.209364533424377, 0.354681611061096, 0.399269342422485, -0.076148509979248, 0.334830403327942, 0.779172897338867, 0.207621216773987, -0.0765944719314575, 0.178671360015869, -0.115955412387848, -0.127840399742126, -0.0347341299057007, 0.109196782112122, 0.0700201988220215, 0.377198100090027, 0.415385246276855, -0.00352674722671509, -0.0978615880012512, 0.206470608711243, 0.191151976585388, 0.496109127998352, 0.127763032913208, 0.0341671705245972, 0.446481585502625, 0.354197025299072, 0.235347270965576, 0.203922986984253, 0.106945514678955, -0.0032346248626709, 0.221851348876953, 0.885235786437988, 0.336729407310486, 0.37642228603363, 0.678622841835022, 0.334491610527039, 0.075231671333313, 0.255690455436707, 0.333809733390808, 0.546808242797852, 0.84973406791687, 0.146947860717773, 0.319376468658447, 0.5112384557724, 0.109134435653687, 0.138782739639282, 0.166451215744019, -0.267351388931274, 0.7434401512146, 0.0962295532226562, -0.0232303738594055, -0.00354337692260742, 0.524732112884521, 0.797836899757385, 0.83693265914917, 0.297370433807373, 0.626908898353577, 0.064664363861084, 0.390812993049622, 0.140457034111023, 0.247225165367126, -0.149081587791443, 0.367469310760498, 0.527499675750732, -0.0750826001167297, 0.825920104980469, 0.229316830635071, 0.215497732162476, 0.506382465362549, 0.570645213127136, 0.0491814613342285, 0.277299284934998, 0.212671399116516, 0.282986879348755, 0.0494382381439209, 0.196262121200562, 0.191741585731506, 0.548771500587463, 0.555819630622864, -0.218977928161621, 0.201565623283386, 0.151775598526001, -0.0653113126754761, 0.154184699058533, 0.071280837059021, 0.44502067565918, 0.206806302070618, 0.801146626472473, 0.545352935791016, 0.143512368202209, 0.723142385482788, 0.355946183204651, 0.671813130378723, -0.00585329532623291, 0.0394693613052368, 0.329318165779114, 0.0316159725189209, -0.01138836145401, 0.130576729774475, 0.458450317382812, 0.473251342773438, 0.264370799064636, 0.179141640663147, 0.812104940414429, 0.55476975440979, 0.182725787162781, 0.314527034759521, 0.109812378883362, 0.634584784507751, 0.100783348083496, -0.0934212207794189, 0.356815457344055, 0.419215798377991, 0.657456636428833, 0.192853927612305, -0.141842246055603, 0.00836968421936035, 0.812312364578247, -0.0347849130630493, 0.194279193878174, 0.255944609642029, 0.345347046852112, 0.675123572349548, 0.587964653968811, -0.125492990016937, 0.0922048091888428, 0.0397876501083374, 0.235216021537781, 0.199106812477112, 0.118830680847168, 0.491699934005737, 0.176671385765076, 0.0773502588272095, 0.0606228113174438, -0.00316864252090454, -0.143523395061493, 0.206488728523254, -0.108043670654297, 0.838416218757629, -0.0737157464027405, 0.47040319442749, 0.368613123893738, 0.757405042648315, 0.857798337936401, 0.83357560634613, 0.339082002639771, 0.686285257339478, -0.369132578372955, -0.105695307254791, 0.207289814949036, 0.0192099809646606, 0.0491435527801514, 0.421036124229431, 0.147372245788574, 0.524100661277771, 0.615037083625793, 0.0780651569366455, 0.179075479507446, 0.0121867656707764, -0.0745857357978821, 0.892179131507874, 0.154124736785889, 0.145100355148315, 0.501030325889587, 0.0212407112121582, 0.022081732749939, 0.19761598110199, 0.400034546852112, 0.61758029460907, 0.00127148628234863, 0.413738608360291, 0.676389932632446, 0.494756698608398, -0.0912013053894043, 0.399860978126526, 0.780398845672607, 0.273224592208862, 0.790804982185364, 0.403976678848267, 0.155713438987732, -0.188743233680725 }, 

   { 0.188818454742432, 0.418984532356262, 0.305921792984009, 0.0873888731002808, 0.207610368728638, -0.150702238082886, -0.252373039722443, -0.381447732448578, 0.179673075675964, -0.484567701816559, 0.0554779767990112, 0.0324803590774536, 0.326045274734497, 0.0421093702316284, 0.121210813522339, -0.286268949508667, -0.225168466567993, 0.5272296667099, 0.138510227203369, 0.0664149522781372, -0.393594026565552, -0.300446212291718, -0.425972640514374, 0.195308208465576, -0.084685206413269, -0.404357314109802, 0.552442789077759, 0.669566869735718, -0.356959164142609, 0.316995143890381, 0.0548017024993896, 0.306039333343506, 0.0797196626663208, 0.157936334609985, 0.388963103294373, 0.178925037384033, -0.0526753067970276, -0.058205246925354, 0.116229295730591, -0.118737757205963, 0.557466268539429, -0.0707799792289734, 0.279341101646423, -0.615260481834412, -0.00529438257217407, -0.133019924163818, 0.371980309486389, 0.0281462669372559, -0.203592896461487, 0.140447616577148, -0.0680921077728271, 0.175113320350647, 0.4937424659729, 0.369553565979004, -0.23283725976944, -0.70272958278656, 0.0568923950195312, 0.0319658517837524, 0.216495275497437, -0.453687846660614, -0.321636915206909, -0.228158354759216, -0.0959544777870178, -0.385974943637848, -0.0868593454360962, -0.329146385192871, -0.325186312198639, -0.331756234169006, -0.0143033266067505, 0.208059430122375, 0.496894240379333, 0.0655356645584106, 0.0290948152542114, -0.0643448233604431, -0.449746072292328, -0.0350549221038818, -0.0883088707923889, -0.465987920761108, -0.367025911808014, 0.251118779182434, 0.0707825422286987, 0.300922513008118, 0.029236912727356, 0.0980350971221924, -0.336278319358826, -0.0611351132392883, 0.358006596565247, -0.3514484167099, -0.151668429374695, 0.179400682449341, -0.251347661018372, 0.334624052047729, -0.156125903129578, -0.935644209384918, -0.170831859111786, 0.389096856117249, 0.852336883544922, 0.550603151321411, -0.49866259098053, -0.343015789985657, 0.040528416633606, 0.0505013465881348, 0.0564969778060913, -0.292176723480225, 0.25499951839447, 0.212517619132996, 0.322026491165161, -0.0423644185066223, 0.0523630380630493, -0.0516616702079773, -0.184431612491608, -0.0883387327194214, -0.145358204841614, -0.0387049913406372, -0.195376932621002, 0.136093139648438, 0.178397297859192, 0.0458886623382568, 0.0349875688552856, -0.476230442523956, 0.0643396377563477, -0.0550602674484253, 0.521906733512878, -0.0881908535957336, 0.145476102828979, -0.19209349155426, 0.112335085868835, -0.543357014656067, 0.0316433906555176, -0.458342134952545, -0.0925505757331848, 0.204138875007629, -0.0397092700004578, -0.169837176799774, 0.146652936935425, 0.412890076637268, -0.136078655719757, -0.479442119598389, -0.0711539387702942, -0.461858689785004, -0.327904999256134, 0.0934414863586426, -0.221778929233551, -0.265327394008636, 0.144002795219421, 0.223913192749023, -0.0456943511962891, 0.0157197713851929, 0.0419358015060425, 0.0824352502822876, -0.429388463497162, -0.27874231338501, -0.184545874595642, 0.0394359827041626, -0.198838651180267, -0.137466788291931, -0.256141841411591, 0.327967762947083, 0.190829992294312, -0.247745275497437, 0.149970769882202, -0.220060050487518, -0.650587916374207, -0.0726172924041748, 0.215906262397766, 0.636937022209167, 0.216548085212708, -0.169718623161316, -0.0626387000083923, -0.486770927906036, 0.310203671455383, 0.00956165790557861, -0.183678388595581, -0.681362986564636, 0.100347518920898, -0.139391601085663, -0.181824266910553, -0.219577133655548, 0.182751536369324, -0.259166538715363, -0.161999821662903, -0.146883189678192, -0.44435179233551, -0.190964221954346, -0.322490274906158, -0.145835220813751, -0.39876127243042, -0.275634109973907, -0.13127464056015, -0.242715060710907, 0.167446374893188, -0.212076544761658, -0.0465624928474426, -0.0179979801177979, -0.359736740589142, 0.0741175413131714, 0.0899945497512817, 0.153716802597046, -0.189038276672363, 0.214852094650269, -0.387956082820892, -0.117150783538818, 0.19304633140564, 0.213471293449402, -0.138028740882874, -0.42739725112915, -0.129810094833374, -0.012465238571167, -0.4615837931633, 0.571627020835876, 0.0719461441040039, -0.181517422199249, -0.547114610671997, -0.683479905128479, 0.203297019004822, -0.0913258194923401, -0.275409162044525, -0.154485404491425, 0.0366535186767578, -0.155304372310638, 0.0840600728988647, 0.177772641181946, -0.182431519031525, -0.0950119495391846, 0.283895015716553, -0.436381697654724, 0.0238099098205566, 0.480629920959473, 0.272915720939636, 0.291599631309509, 0.137767314910889, 0.113967061042786, 0.109643459320068, -0.176546156406403, -0.406378149986267, -0.108144581317902, -0.0292224884033203, 0.0301991701126099, -0.239732563495636, 0.310581922531128, 0.0128796100616455, -0.11970043182373, -0.44036877155304, -0.00299549102783203, 0.204545617103577, -0.0229931473731995, -0.20889288187027, -0.217038333415985, 0.254641652107239, 0.311845541000366, -0.167736053466797, 0.385359644889832, -0.00586122274398804, -0.222736954689026, -0.18371570110321, -0.453450500965118, -0.10742449760437, 0.213613986968994, 0.0283845663070679, 0.485286951065063, -0.267908036708832, 0.0522196292877197, 0.099427342414856, 0.228187561035156, -0.272461652755737, -0.241928160190582, -0.392740666866302, 0.412687420845032, -0.31123012304306, -0.0852810144424438, 0.238579988479614, -0.44313508272171, -0.282556772232056, -0.478556931018829, -0.0294663906097412, 0.231095433235168, -0.123713076114655, 0.100367069244385, 0.461634397506714, 0.00703442096710205, -0.186651647090912, -0.548873543739319, -0.300956964492798, 0.00974130630493164, 0.220006227493286, -0.181722342967987, -0.475762605667114, -0.0157365202903748, 0.17009711265564, 0.0188901424407959, -0.166195273399353, 0.257728815078735, -0.15912938117981, -0.25863653421402, 0.170118927955627, -0.734911203384399, 0.423928260803223, -0.356834411621094, 0.266855359077454, 0.127871870994568, -0.129596650600433, 0.521714448928833, -0.439921379089355, -0.564026474952698, -0.0369820594787598, -0.166320085525513, 0.0028151273727417, -0.081976056098938, -0.0565927624702454, -0.152243316173553, 0.363813161849976, -0.000366151332855225, 0.214951157569885, -0.316265285015106, 0.305475950241089, 0.247037768363953, 0.232710719108582, 0.110739946365356, -0.185796141624451, 0.309991955757141, -0.00318533182144165, -0.0276390314102173, -0.596307098865509, -0.0746436715126038, -0.304461777210236, -0.157768189907074, 0.435652136802673, -0.553512334823608, 0.288426518440247, -0.123218595981598, -0.129894375801086, -0.28643000125885, 0.436897277832031, -0.177108645439148, 0.113437533378601, 0.0656700134277344, -0.0620796680450439, -0.0953535437583923, 0.240795731544495, 0.3715900182724, 0.151419878005981, 0.261490225791931, 0.0442373752593994, -0.448997497558594, 0.320910096168518, -0.305983483791351, 0.380645155906677, -0.281081795692444, -0.140780448913574, 0.0112289190292358, -0.141354918479919, 0.324721693992615, -0.0565341711044312, 0.125620007514954, -0.330562114715576, -0.226936876773834, 0.0429716110229492, 0.497828602790833, -0.286324143409729, -0.20938515663147, -0.124585568904877, 0.0247629880905151, 0.00678133964538574, 0.258981823921204, -0.0462919473648071, -0.0349797606468201, -0.548552274703979, 0.090462327003479, -0.103750467300415, 0.165759444236755, 0.124964118003845, 0.124543905258179, -0.0627557635307312, -0.275830864906311, 0.0947978496551514, 0.0444800853729248, 0.091147780418396, -0.315986275672913, 0.313270688056946, -0.193032383918762, -0.31061840057373, -0.526756763458252, -0.329085290431976, 0.231081604957581, -0.143789350986481, -0.425010979175568, -0.526571691036224, -0.20342230796814, -0.0695655941963196, -0.167674005031586, 0.265768766403198, 0.0241507291793823, 0.243719577789307, -0.0119231343269348, 0.17825174331665, -0.154848337173462, 0.298068046569824, 0.0109846591949463, -0.0381193161010742, 0.0817468166351318, -0.552057147026062, 0.110064148902893, -0.46149092912674, -0.329222738742828, -0.467725694179535, 0.217528223991394, 0.0386193990707397, 0.503902554512024, -0.492230415344238, -0.543879508972168, -0.832916498184204, 0.00469613075256348, 0.333067178726196, -0.156898498535156, -0.385473430156708, 0.204002499580383, 0.568563342094421, -0.0606712102890015, 0.206737995147705, -0.0990317463874817, 0.0858819484710693, 0.321657180786133, 0.120906591415405, -0.149995148181915, 0.287416100502014, 0.260794162750244, 0.10347056388855, -0.0235995054244995, -0.225229501724243, -0.460249006748199, -0.242698550224304, 0.303321003913879, 0.237205386161804, -0.283532440662384, -0.289099276065826, 0.222962260246277, -0.0691983699798584, 0.502846479415894, 0.0452611446380615, 0.695395946502686, -0.434823453426361, 0.0601390600204468, 0.422674775123596, 0.240331411361694, 0.0843552350997925, 0.0376849174499512, -0.246939778327942, 0.0152840614318848, 0.0504440069198608, -0.318911492824554, -0.50096607208252, -0.443611025810242, -0.336084604263306, -0.386892080307007, 0.174818634986877, 0.369162917137146, 0.00779414176940918, -0.719860553741455, -0.349077701568604, 0.0510948896408081, 0.0173187255859375, 0.0956133604049683, -0.0316321849822998, 0.147870540618896, 0.337486147880554, 0.344253659248352, -0.116579353809357, 0.6319899559021, 0.114742636680603, -0.329758524894714, -0.129745900630951, 0.160065174102783, -0.0953899621963501, 0.119058132171631, -0.0684826970100403, 0.324880480766296, 0.0358961820602417, 0.246081590652466, 0.061492919921875, -0.172543227672577, 0.197872400283813, 0.0993611812591553, -0.284244060516357, 0.0101513862609863, 0.103049278259277, 0.470256209373474, -0.261408090591431, -0.366586208343506, -0.042927622795105, -0.162515342235565, -0.238610863685608, -0.273645222187042, -0.134326040744781, 0.595396876335144, 0.0186477899551392, 0.113972306251526, 0.0656265020370483, -0.749775350093842, -0.133718013763428, 0.0275957584381104, 0.0266549587249756, 0.213091492652893, -0.473078191280365, 0.10477089881897, -0.704173386096954, -0.272157371044159, -0.44375616312027, -0.226962924003601, -0.513665080070496, -0.0311797857284546, 0.356709003448486, -0.247705221176147, 0.593358874320984, 0.0249708890914917, -0.163864076137543, 0.458260059356689, 0.0697126388549805, -0.0823702216148376, 0.0399014949798584, 0.0117790699005127, -0.232476711273193, -0.226472914218903, -0.116560697555542, 0.0821491479873657, 0.053636908531189, 0.140012145042419, -0.435925900936127, -0.54319441318512, 0.287498950958252, 0.329184412956238, 0.57267963886261, -0.214712083339691, 0.223352551460266, -0.080940842628479, 0.131231427192688, 0.560800313949585, -0.579294919967651, 0.140247464179993, 0.315536975860596, -0.0515352487564087, -0.30299323797226, -0.548365592956543, -0.0813868641853333, 0.14798891544342, -0.198283612728119, 0.0018913745880127, -0.0541340708732605, 0.0468399524688721, 0.0989233255386353, -0.229534566402435, -0.183452785015106, 0.621061563491821, 0.078788161277771, -0.0107664465904236, -0.302442789077759, -0.1247279047966, -0.0181741118431091, 0.290167331695557, -0.0528466701507568, 0.0291032791137695, 0.0680016279220581, -0.0971200466156006, -0.5467848777771, 0.184186816215515, 0.166096210479736, -0.354030132293701, -0.1296426653862, -0.441136181354523, 0.0452620983123779, -0.235077559947968, 0.10959255695343, 0.0759139060974121, 0.0839176177978516, -0.234758138656616, -0.291885495185852, -0.629426121711731, -0.0472580790519714, -0.0226619243621826, -0.054252028465271, -0.131749629974365, 0.20714545249939, -0.207742393016815, -0.218424081802368, -0.0463876724243164, 0.230061888694763, -0.663766741752625, -0.380332946777344, 0.0233404636383057, -0.159072935581207, -0.131225347518921, -0.126636385917664, -0.402496993541718, -0.0142446160316467, -0.266068756580353, 0.377876281738281, -0.340384364128113, 0.235244750976562, 0.304705023765564, 0.0758172273635864, -0.279797852039337, -0.130302309989929, -0.572436809539795, -0.11505663394928, 0.266365170478821, -0.331976175308228, 0.111525177955627, 0.615164160728455, -0.391547024250031, -0.108197391033173, 0.338023900985718, 0.469860315322876, -0.0970540046691895, -0.18542343378067, 0.331022500991821, 0.768223404884338, 0.154394030570984, -0.00100773572921753, 0.0708343982696533, -0.13880056142807, -0.516151010990143, -0.057392954826355, -0.215479552745819, 0.816167950630188, -0.232580780982971, 0.0200396776199341, 0.276117563247681, -0.201750874519348, -0.540184020996094, 0.00547206401824951, -0.0175568461418152, 0.0560793876647949, 0.555725455284119, 0.36536693572998, 0.320476293563843, -0.0281000733375549, 0.0449721813201904, -0.24029952287674, 0.243174195289612, 0.254016280174255, -0.0480557084083557, 0.485734701156616, -0.446884334087372, 0.510100841522217, -0.0565780997276306, 1, -0.0657482743263245, 0.0422909259796143, 0.264489054679871, 0.150392055511475, 0.490045785903931, -0.439476311206818, 0.339522361755371, 0.23992645740509, 0.408455371856689, -0.0109258890151978, -0.336271405220032, 0.137521624565125, -0.356049716472626, 0.364586710929871, 0.289273977279663, 0.241060614585876, -0.0215413570404053, 0.074317455291748, -0.17376172542572, 0.226153612136841, -0.079681932926178, -0.0206350684165955, -0.303285121917725, 0.488679170608521, 0.054964542388916, 0.0440016984939575, 0.157809138298035, -0.440841674804688, -0.0549284219741821, -0.743180871009827, 0.565791249275208, 0.16723358631134, 0.393435955047607, -0.189700961112976, 0.125492215156555, 0.370984792709351, -0.0316135883331299, 0.0880378484725952, 0.0922375917434692, -0.16053181886673, -0.0807506442070007, 0.278618574142456, -0.0981330871582031, -0.16901570558548, 0.0837265253067017, -0.501100540161133, 0.70720100402832, -0.0994832515716553, 0.311014652252197, -0.123780429363251, -0.476983785629272, -0.111439645290375, 0.296144604682922, -0.00411206483840942, -0.0596573352813721, 0.373396039009094, 0.465630412101746, 0.209448218345642, -0.299102425575256, 0.260072708129883, 0.123980045318604, 0.298426508903503, -0.437869250774384, -0.630719423294067, -0.231878757476807, -0.252829909324646, -0.319403529167175, 0.00370919704437256, -0.474441409111023, 0.230122804641724, -0.436255097389221, 0.355630040168762, -0.0117968320846558, -0.262209296226501, 0.242395997047424, -0.61870014667511, -0.285797894001007, -0.399316430091858, 0.236153364181519, 0.0860072374343872, -0.205772340297699, -0.323937952518463, -0.309755444526672, 0.452379941940308, -0.308854639530182, -0.681341409683228, -0.623930692672729, 0.10811460018158, 0.316498637199402, -0.0826368927955627, 0.0647886991500854, -0.337922871112823, 0.195080399513245, 0.136200308799744, 0.0605143308639526, -0.176826000213623, -0.115773916244507, -0.402899324893951, 0.561056137084961, -0.374688446521759, -0.364148080348969, -0.263996064662933, -0.28186422586441, -0.186414182186127, -0.159320592880249, -0.392341375350952, 0.572220921516418, -0.146039545536041, -0.353677213191986, -0.094704270362854, 0.283491611480713, 0.335186004638672, -0.458103775978088, -0.192669272422791, -0.10142993927002, -0.183457732200623, 0.246547818183899, 0.130573272705078, -0.521454751491547, -0.0201734900474548, -0.374898791313171, -0.00866925716400146, -0.195328235626221, 0.293299794197083, -0.434696674346924, 0.209663271903992, -0.0414667725563049, 0.0523209571838379, 0.185076713562012, -0.321585655212402, -0.235812962055206, -0.13155871629715, -0.134260177612305, -0.123371958732605, -0.0268736481666565, 0.00796675682067871, 0.309416890144348, -0.305094659328461, -0.399494647979736, 0.0611038208007812, -0.245033085346222, 0.248233914375305, -0.315864324569702, -0.147557377815247, 0.389539837837219, 0.295898079872131, 0.0325644016265869, 0.258151531219482, 0.243008494377136, -0.148732244968414, 0.15566623210907, -0.0611873865127563, -0.224149286746979, 0.363893151283264, -0.415193021297455, 0.307466149330139, -0.0397158265113831, -0.294362008571625, -0.736369729042053, 0.351934671401978, 0.469263195991516, 0.373578310012817, -0.209372878074646, -0.158295810222626, 0.0150884389877319, 0.284345746040344, -0.663062155246735, -0.632279515266418, 0.105585813522339, 0.540914535522461, 0.091416597366333, -0.145832061767578, -0.51106595993042, 0.0958244800567627, -0.176012754440308, -0.269652366638184, 0.20808732509613, -0.172877669334412, -0.158933460712433, 0.446498036384583, 0.55397367477417, 0.182932615280151, -0.0776176452636719, 0.297176957130432, -0.276195824146271, -0.105487644672394, -0.0494105815887451, -0.341714143753052, 0.261139273643494, 0.21899688243866, -0.00361049175262451, 0.255630135536194, -0.0790333151817322, -0.0469546914100647, 0.0223641395568848, 0.0256882905960083, 0.371737122535706, 0.0663985013961792, 0.0942783355712891, -0.429197430610657, 0.431128025054932, 0.187153100967407, 0.144843578338623, -0.0190508365631104, 0.313346385955811, -0.35991370677948, 0.336696863174438, 0.0614993572235107, -0.203132092952728, -0.166405737400055, -0.00836730003356934, -0.177711427211761, 0.180017352104187, 0.0926797389984131, 0.261035919189453, -0.255123913288116, -0.755858421325684, -0.365543484687805, -0.216008245944977, -0.144044637680054, -0.088762104511261, 0.502126932144165, -0.135886549949646, -0.0272544026374817, 0.188125848770142, -0.164227664470673, -0.389086484909058, -0.202487170696259, 0.240398406982422, -0.0498631596565247, -0.123628437519073, 0.153403282165527, 0.140956401824951, -0.241056084632874, 0.325529217720032, -0.216142892837524, 0.241290807723999, -0.490863919258118, 0.294378280639648, -0.0362738370895386, 0.175307989120483, 0.0278456211090088, 0.11955714225769, 0.21979808807373, 0.0656323432922363, -0.148033678531647, -0.0147057175636292, 0.0642660856246948, -0.0894010066986084, 0.135622262954712, 0.219127416610718, 0.0278644561767578, -0.0366556644439697, -0.161321878433228, 0.254844546318054, 0.0896632671356201, -0.108393788337708, 0.193963766098022, 0.140322804450989, -0.129871666431427, -0.298591554164886, -0.458859741687775, -0.343880116939545, 0.243473052978516, -0.111153423786163, -0.312746047973633, 0.25446605682373, 0.0722697973251343, 0.0911895036697388, -0.194246172904968, -0.137601256370544, 0.300616264343262, -1, -0.295878410339355, -0.438308358192444, -0.418999791145325, 0.100798606872559, -0.0995455980300903, 0.0704445838928223, -0.0224049687385559, 0.162071943283081, 0.216822385787964, 0.215459108352661, -0.183566212654114, -0.0562546849250793, 0.396789908409119, 0.112289071083069, 0.0353960990905762, 0.0371191501617432, 0.288354516029358, -0.516534805297852, -0.0659567713737488, 0.0886019468307495, 0.109115242958069, -0.0652997493743896, 0.176769137382507, -0.153518617153168, -0.206101715564728, 0.0153261423110962, -0.0111088156700134, 0.069202184677124, 0.132337689399719, 0.322334170341492, 0.487139105796814, 0.318748712539673, 0.375190854072571, 0.117027997970581, 0.324048519134521, 0.555887937545776, 0.0810971260070801, 0.211522698402405, -0.0424069762229919, 0.554265379905701, -0.452850878238678, 0.340727806091309, 0.252947330474854, -0.184630632400513, -0.0310300588607788, 0.0965126752853394, -0.0483468770980835, -0.380601823329926, -0.389941692352295, -0.367567598819733, -0.163496196269989, -0.357008934020996, 0.401490807533264, 0.0288554430007935, -0.141908288002014, 0.138246893882751, 0.150182843208313, -0.190102458000183, -0.00466388463973999, -0.331896066665649, -0.236712098121643, 0.343439340591431, -0.545063018798828, -0.114411294460297, 0.646293997764587, 0.286683797836304, -0.217268466949463, 0.331637024879456, -0.244209229946136, 0.621884107589722, -0.312200129032135, 0.268146514892578, 0.223922967910767, -0.0501360893249512, -0.136896371841431, 0.102396368980408, -0.117229759693146, -0.0769894123077393, 0.410432457923889, -0.254104018211365, 0.0994164943695068, -0.091623067855835, -0.295038104057312, -0.0118312239646912, -0.562790632247925, -0.322382569313049, -0.204124212265015, -0.0466511249542236, -0.346067190170288, -0.208615124225616, -0.16657018661499, 0.0821131467819214, 0.036588191986084, -0.154803097248077, -0.122345149517059, -0.235179722309113, 0.271793365478516, -0.347618222236633, -0.385865330696106, -0.228399395942688, 0.0333871841430664, 0.0358662605285645, 0.573506951332092, -0.116567134857178, -0.00714701414108276, -0.178326308727264, 0.0762044191360474, 0.458762526512146, -0.00248026847839355, 0.422502160072327, -0.193847715854645, -0.464322924613953, 0.0873653888702393, 0.126066207885742, -0.354292452335358, -0.084134578704834, 0.152806282043457, 0.281474351882935, -0.233528137207031, -0.188915550708771, 0.199788570404053, -0.125914692878723, -0.27500331401825, -0.270189464092255, 0.0091327428817749, 0.783894419670105, -0.218514442443848, -0.362263262271881, -0.14768648147583, 0.236335158348083, -0.0388614535331726, -0.435166478157043, 0.173388361930847, 0.0258680582046509, -0.15498012304306, -0.200756251811981, -0.202703177928925, -0.310951828956604, 0.130572080612183, -0.151261746883392, -0.133233904838562, -0.129262566566467, 0.0292946100234985, -0.00380790233612061, -0.308607935905457, -0.661298096179962, 0.232768177986145, 0.225903391838074, -0.0909700393676758, 0.317419528961182, 0.0464538335800171, 0.32959771156311, 0.0932660102844238, -0.15096116065979, -0.146319568157196, -0.147388756275177, 0.100417494773865, -0.410148620605469, 0.0200051069259644, -0.128748178482056, 0.00750446319580078, -0.155224740505219, 0.0582526922225952, 0.278360843658447, 0.123517751693726, -0.383642971515656, 0.0392258167266846, 0.185125470161438, 0.0967199802398682, -0.16537469625473, 0.0535365343093872, -0.292070925235748, 0.229077219963074, -0.328175902366638, -0.210595905780792, 0.0771619081497192, 0.245500564575195, 0.228267669677734, 0.302114129066467, 0.19964861869812, -0.0159724354743958, 0.0472376346588135, -0.0368967056274414, 0.436279058456421, -0.151177883148193, 0.160927891731262, -0.53536593914032, -0.131775677204132, -0.487951219081879, -0.150890588760376, -0.342205584049225, -0.285573899745941, 0.51662540435791, -0.163603484630585, 0.438962459564209, -0.834106802940369, 0.292463541030884, 0.214425802230835, 0.118063688278198, 0.137988686561584, 0.0439945459365845, 0.254593372344971, 0.129424691200256, -0.119410932064056, -0.248938381671906, 0.171493411064148, 0.0446782112121582, -0.292247653007507, -0.395035207271576, 0.0533651113510132, 0.159545540809631, -0.126584529876709, -0.438400328159332, 0.0359385013580322, -0.232306659221649, 0.0556001663208008, 0.712094664573669, -0.167909920215607, -0.111444294452667 }, 

   { 0.051000714302063, 0.584989428520203, 0.219264268875122, -0.00541281700134277, 0.424742937088013, 0.0579936504364014, 0.0881085395812988, 0.572504639625549, 0.464755773544312, 0.373650789260864, -0.289896607398987, 0.330952405929565, -0.116097509860992, 0.21294641494751, 0.257225632667542, 0.923729538917542, 0.0495169162750244, 0.0818796157836914, 0.361728429794312, 0.140958428382874, 0.354216456413269, 0.733802199363708, 0.346126317977905, 0.267637372016907, 0.0917278528213501, 0.355583667755127, 0.612764477729797, 0.647635459899902, 0.10555112361908, 0.481912851333618, 0.197453141212463, 0.245841979980469, 0.318036198616028, 0.0141716003417969, 0.83488655090332, 0.147303223609924, 0.0112801790237427, 0.504144906997681, 0.203105211257935, 0.369647264480591, 0.112964272499084, 0.583304166793823, 0.378646492958069, -0.459992349147797, 0.0411542654037476, 0.0328489542007446, -0.168772101402283, 0.56627881526947, 0.508679270744324, 0.183552145957947, 0.213607430458069, 0.432819128036499, -0.211562871932983, -0.0173534154891968, 0.346794128417969, 0.131795525550842, 0.20502495765686, 0.270385026931763, 0.112430095672607, -0.0254330039024353, 0.767999053001404, 0.090099573135376, 0.040419340133667, 0.122727632522583, 0.538693070411682, 0.159080386161804, 0.279999494552612, 0.265467405319214, 0.232538461685181, 0.149523735046387, 0.150533199310303, -0.364126861095428, 0.478826761245728, 0.130502223968506, -0.175064027309418, 0.539207816123962, -0.0175816416740417, -0.260688424110413, 0.249090790748596, 0.352311611175537, 0.307924628257751, 0.113707542419434, -0.116813898086548, 0.424309730529785, 0.587751388549805, 0.239966034889221, 0.861825346946716, 0.222261309623718, 0.378253579139709, 0.0186189413070679, 0.501295924186707, 0.593717694282532, 0.178594350814819, 0.379818797111511, -0.0746591687202454, -0.179758787155151, 0.613099575042725, 0.0130374431610107, 0.378161430358887, 0.254135251045227, 0.0337578058242798, -0.156046271324158, -0.0870845913887024, 0.023922324180603, 0.0138320922851562, 0.390152454376221, 0.761048316955566, 0.290078401565552, 0.147182106971741, 0.0248583555221558, 0.203970074653625, 0.378351807594299, 0.0390088558197021, -0.137580513954163, 0.0626732110977173, -0.0386970043182373, 0.111076235771179, -0.143961429595947, 0.293115973472595, 0.447774291038513, 0.0334125757217407, -0.212618887424469, 0.493308782577515, 0.185428261756897, 0.00126922130584717, 0.539018154144287, 0.509687066078186, 0.271188139915466, 0.077684760093689, 0.244652032852173, -0.0393357872962952, 0.628549456596375, -0.303673624992371, 0.1588214635849, 0.0625749826431274, -0.010084331035614, 0.209782123565674, 0.0679219961166382, 0.457475423812866, 0.261765956878662, 0.272609829902649, -0.219299852848053, -0.036051869392395, -0.126775205135345, 0.0632858276367188, 0.127560377120972, -0.0223871469497681, 0.50114631652832, 0.0963598489761353, 0.458674669265747, 0.62962806224823, 0.273858666419983, 0.225726723670959, 0.0389989614486694, 0.562388062477112, 0.070313572883606, -0.208720445632935, 0.63417375087738, 0.319814085960388, -0.575763583183289, 0.325447201728821, -0.144417405128479, -0.0401756167411804, 0.327820420265198, 0.0980641841888428, 0.547302842140198, 0.503934860229492, 0.56997275352478, 0.563722252845764, 0.309839010238647, 0.308321118354797, -0.00314033031463623, 0.0889937877655029, -0.00437742471694946, 0.0516656637191772, 0.367849826812744, -0.161531150341034, 0.3087557554245, 0.611891508102417, 0.457807302474976, 0.660831689834595, 0.0750086307525635, 0.370697617530823, 0.246417284011841, 0.438859701156616, -0.227381587028503, 0.334977269172668, 0.196012258529663, -0.150224983692169, 0.127256751060486, 0.276514410972595, 0.711378335952759, 1, 0.900490283966064, 0.0953673124313354, -0.0596389770507812, 0.36272668838501, -0.0587016344070435, -0.322555184364319, -0.00706672668457031, 0.284537792205811, 0.479119896888733, 0.126783490180969, 0.291064858436584, 0.0364476442337036, 0.8310227394104, -0.0812774300575256, -0.0600348711013794, 0.454488754272461, 0.523424506187439, 0.262857556343079, 0.176873445510864, -0.145282030105591, 0.111894249916077, 0.285604476928711, 0.271379828453064, 0.053865909576416, 0.674439549446106, 0.00536072254180908, 0.303519010543823, 0.590171694755554, 0.535010457038879, 0.0917845964431763, 0.185087203979492, 0.476517796516418, 0.578719615936279, 0.422291398048401, 0.269593596458435, 0.103283047676086, 0.112829566001892, 0.12138819694519, -0.185069859027863, 0.643388867378235, 0.0827465057373047, 0.0638427734375, 0.0490396022796631, 0.172800183296204, 0.208307147026062, 0.439319014549255, 0.361862659454346, 0.100000619888306, 0.359639167785645, 0.164634346961975, 0.154707670211792, -0.026451587677002, 0.86801278591156, 0.219585418701172, 0.116498470306396, -0.00613230466842651, 0.0955405235290527, 0.306716799736023, 0.166250705718994, 0.849796652793884, 0.225514650344849, 0.741387844085693, 0.14190936088562, 0.228569984436035, -0.128558099269867, 0.109119415283203, -0.28775292634964, 0.53063690662384, 0.342717051506042, 0.374964594841003, 0.0742144584655762, -0.150773584842682, -0.222319066524506, 0.633672714233398, 0.754936099052429, 0.292823195457458, 0.154456853866577, 0.0316523313522339, 0.530712962150574, 0.0277615785598755, 0.715033411979675, 0.106079697608948, 0.451878905296326, 0.057916522026062, 0.223057270050049, 0.664328932762146, -0.158439993858337, 0.179707050323486, 0.248578667640686, 0.175402998924255, 0.259945392608643, 0.687171697616577, -0.166082262992859, 0.210425853729248, 0.138118505477905, -0.220459520816803, 0.442858815193176, -0.0635615587234497, 0.739331483840942, 0.198642253875732, -0.138425409793854, 0.486196279525757, 0.0764617919921875, 0.304391145706177, 0.326021790504456, 0.412438988685608, 0.0472341775894165, 0.594226479530334, 0.510502696037292, 0.0976560115814209, 0.0961878299713135, -0.0613772869110107, 0.0973881483078003, 0.187588810920715, 0.194106578826904, 0.073445200920105, 0.360914826393127, 0.362088561058044, 0.235278844833374, 0.310608386993408, -0.113057255744934, -0.00670790672302246, 0.202391743659973, -0.1050044298172, 0.212109088897705, -0.131368517875671, 0.54928994178772, 0.79662811756134, 0.0218625068664551, 0.334722638130188, 0.10128653049469, 0.163941383361816, 0.417729020118713, 0.436947703361511, 0.0578444004058838, 0.821048736572266, 0.782643795013428, 0.251219034194946, -0.184100031852722, 0.594353556632996, 0.291252732276917, -0.0133301019668579, 0.237813115119934, 0.248616695404053, -0.0565750598907471, 0.244644045829773, 0.452965259552002, 0.72277557849884, 0.276664614677429, 0.746283650398254, 0.257225036621094, 0.166102409362793, 0.372122526168823, 0.149767160415649, -0.016664981842041, 0.304055571556091, 0.536814451217651, 0.256576418876648, -0.0909942984580994, 0.621456265449524, 0.0582122802734375, -0.0920557975769043, 0.606937766075134, 0.310323119163513, -0.328515708446503, -0.104461312294006, 0.179667711257935, 0.311584830284119, 0.422539353370667, -0.165461659431458, 0.171962857246399, 0.311806321144104, -0.144635021686554, 0.180089354515076, 0.00556802749633789, 0.297365427017212, 0.231143951416016, 0.659962773323059, 0.177186012268066, 0.665796041488647, 0.380382180213928, -0.0179991722106934, 0.38001823425293, 0.0871131420135498, 0.414146780967712, 0.300552010536194, 0.347769379615784, 0.285510540008545, 0.0510818958282471, 0.459159851074219, 0.671093940734863, 0.492383122444153, 0.150076746940613, 0.061747670173645, 0.384320139884949, 0.510662198066711, 0.645092010498047, 0.0367488861083984, 0.550977945327759, -0.0023878812789917, 0.258405327796936, 0.184970378875732, 0.687779068946838, 0.530582308769226, 0.00357174873352051, 0.0356746912002563, 0.57274067401886, 0.175243616104126, 0.443802356719971, 0.0900290012359619, 0.0123223066329956, -0.0426356196403503, 0.19349217414856, 0.135740518569946, 0.119815826416016, 0.50580620765686, -0.027920126914978, 0.0779646635055542, 0.251224756240845, -0.0347100496292114, -0.0108875036239624, 0.20469069480896, 0.367657423019409, 0.0390453338623047, 0.788079142570496, 0.582556009292603, 0.141361713409424, 0.330237865447998, -0.209599375724792, 0.36747944355011, 0.239265203475952, 0.10211455821991, 0.0190974473953247, 0.100666761398315, -0.0897936820983887, 0.0818791389465332, 0.10900342464447, 0.373811841011047, 0.6080402135849, 0.358573317527771, 0.203490376472473, 0.562543511390686, 0.302330017089844, 0.49596905708313, -0.0712428092956543, 0.156702637672424, 0.462356686592102, -0.152980983257294, 0.121106624603271, -0.328726768493652, 0.431510448455811, -0.0158525109291077, 0.705649018287659, -0.104947566986084, 0.360950469970703, -0.220680117607117, 0.225530385971069, 0.0391932725906372, 0.122002840042114, 0.201267242431641, 0.233507394790649, 0.170877695083618, 0.143596529960632, 0.585058093070984, 0.173839807510376, 0.0953459739685059, 0.327203154563904, 0.00930726528167725, -0.244280934333801, 0.2511305809021, 0.151639699935913, 0.682223916053772, 0.0905237197875977, 0.276904940605164, 0.354259610176086, -0.160952091217041, 0.0769168138504028, 0.0124855041503906, 0.00785720348358154, 0.180201053619385, 0.191703081130981, 0.226085424423218, -0.0325472950935364, 0.265560865402222, 0.277502059936523, 0.239390134811401, 0.0978362560272217, -0.0502107739448547, 0.19898247718811, -0.0927122831344604, 0.309764623641968, 0.445702195167542, 0.600721478462219, 0.179987192153931, 0.02178955078125, 0.283259153366089, -0.0122668743133545, 0.118587374687195, 0.102543830871582, 0.0599122047424316, 0.430655360221863, 0.283461809158325, 0.0770061016082764, 0.0580180883407593, 0.297819137573242, 0.234634399414062, 0.155302166938782, -0.249973773956299, 0.482966065406799, -0.264378488063812, 0.117592096328735, -0.100707650184631, 0.604843735694885, 0.961111068725586, 0.0714194774627686, -0.0301211476325989, 0.225545644760132, 0.0579578876495361, 0.598661541938782, -0.030811607837677, -0.213071286678314, 0.0372600555419922, -0.0726105570793152, 0.229921936988831, -0.0438836812973022, 0.231922388076782, -0.00237452983856201, 0.373665332794189, 0.230162501335144, 0.162062048912048, 0.1615891456604, 0.318330645561218, 0.167272567749023, 0.805127501487732, -0.0954710841178894, 0.36744749546051, 0.45035982131958, 0.220441341400146, -0.0182030200958252, -0.195626556873322, 0.133647918701172, 0.530848741531372, -0.0888993144035339, -0.288638234138489, -0.25773549079895, 0.659003138542175, -0.120349228382111, 0.181731700897217, 0.134047031402588, 0.0493032932281494, 0.204680562019348, 0.383827209472656, 0.315035104751587, -0.0268929004669189, 0.537826895713806, 0.532252788543701, 0.252598285675049, 0.219093441963196, 0.468894481658936, 0.163302540779114, 0.207510590553284, -0.129239082336426, 0.00165438652038574, 0.49871551990509, 0.372418642044067, 0.587297201156616, 0.491093516349792, 0.339239239692688, 0.357616424560547, 0.0578032732009888, 0.197484016418457, 0.252883553504944, -0.0308843851089478, 0.132110238075256, 0.0957375764846802, 0.428067803382874, 0.618169546127319, 0.129886865615845, -0.117261469364166, 0.41141664981842, 0.0152745246887207, 0.859562635421753, -0.178288280963898, 0.702012062072754, 0.136000633239746, -0.031302273273468, -0.106830894947052, -0.00578302145004272, 0.344219565391541, -0.00295466184616089, 0.18438196182251, 0.227927088737488, -0.0551380515098572, 0.134267807006836, 0.32612133026123, 0.429794549942017, 0.648154854774475, -0.287954568862915, 0.444523334503174, -0.0036584734916687, 0.343305110931396, 0.753766179084778, 0.261027336120605, 0.332228302955627, 0.460767149925232, -0.358687579631805, -0.0128964781761169, -0.0327311158180237, 0.0504497289657593, 0.114261865615845, 0.408078789710999, 0.434412121772766, 0.137498617172241, 0.762331485748291, 0.128744125366211, -0.2428377866745, 0.042676568031311, 0.361421704292297, -0.00242811441421509, 0.394344329833984, 0.34162163734436, 0.551298141479492, 0.424864053726196, 0.283342123031616, 0.633505702018738, -0.0650496482849121, 0.229703426361084, 0.299046397209167, 0.196708083152771, 0.33860170841217, 0.453937172889709, 0.322404742240906, 0.536958694458008, 0.526872873306274, 0.168286800384521, 0.306764245033264, -0.0670554041862488, 0.218931913375854, 0.150623440742493, 0.176790118217468, 0.389000177383423, 0.0480387210845947, 0.445122003555298, -0.195622742176056, 0.211640000343323, 0.729885101318359, 0.576531052589417, 0.10957396030426, 0.0788065195083618, -0.00899875164031982, 0.106378793716431, 0.0768924951553345, 0.130646228790283, 0.896619319915771, 0.690520524978638, 0.0605194568634033, 0.229777932167053, 0.228263258934021, 0.236183881759644, 0.25976824760437, 0.126549005508423, 0.554224371910095, 0.140646457672119, 0.11612069606781, 0.265923023223877, 0.246548771858215, 0.0662751197814941, 0.024277925491333, -0.13105183839798, -0.13890928030014, 0.157037854194641, 0.459246754646301, -0.0708586573600769, 0.0296701192855835, 0.0611371994018555, 0.759267091751099, 0.320447206497192, 0.414825081825256, 0.571800351142883, -0.167010366916656, -0.250498652458191, 0.193043351173401, -0.0630516409873962, 0.770809769630432, 0.52038836479187, 0.419229626655579, 0.707539558410645, 0.297380566596985, 0.0400528907775879, 0.574662923812866, 0.472647547721863, 0.192801713943481, 0.330668568611145, 0.44855523109436, 0.524532794952393, 0.084479808807373, 0.341141819953918, 0.0626212358474731, 0.411489963531494, 0.233258247375488, 0.671998977661133, 0.547807931900024, 0.219596743583679, -0.0395255088806152, 0.40195107460022, 0.20295238494873, 0.431279301643372, 0.776005744934082, 0.403045773506165, 0.0114327669143677, 0.369011282920837, 0.387038469314575, 0.481512904167175, 0.406303524971008, 0.330637097358704, -0.0276151299476624, 0.41815197467804, -0.306846857070923, 0.428608179092407, 0.299882292747498, 0.190047264099121, 0.134445786476135, -0.121558904647827, 0.27388072013855, -0.169453263282776, 0.430616021156311, 0.29443347454071, 0.379186391830444, 0.212179183959961, 0.176499366760254, 0.435864686965942, 0.631444692611694, 0.715261220932007, -0.371357977390289, -0.0950644612312317, 0.276100993156433, 0.0853285789489746, 0.504788637161255, 0.0920262336730957, 0.641462206840515, 0.0377273559570312, 0.0809063911437988, 0.634284973144531, 0.106094837188721, 0.543034315109253, 0.131876111030579, 0.150840282440186, 0.0196467638015747, 0.445788860321045, 0.298346638679504, 0.601911187171936, -0.0948718786239624, 0.329081058502197, 0.1934894323349, -0.00188726186752319, 0.106197357177734, -0.302499651908875, -0.0377152562141418, 0.354759335517883, 0.225637316703796, -0.0582451820373535, -0.132591068744659, 0.613934397697449, -0.356178939342499, 0.31760036945343, 0.0825760364532471, -0.0974385142326355, -0.375501215457916, 0.443301677703857, 0.305594444274902, 0.275130391120911, 0.504419326782227, 0.188172936439514, 0.473764419555664, -0.0353246927261353, 0.327790975570679, 0.18660032749176, 0.0772844552993774, 0.256963133811951, 0.503886461257935, -0.0412381887435913, 0.309740543365479, -0.168707489967346, 0.0285741090774536, -0.085574209690094, 0.203146696090698, 0.525962829589844, 0.185757040977478, 0.623014211654663, 0.290032267570496, -0.0427764058113098, 0.636530518531799, -0.00861400365829468, 0.220378279685974, -0.0110678672790527, -0.00996249914169312, -0.0235751867294312, 0.371444582939148, 0.717992901802063, 0.391206502914429, 0.338674664497375, 0.309098362922668, 0.0788252353668213, -0.265464544296265, 0.0349814891815186, 0.637131810188293, 0.212819576263428, 0.238457083702087, -0.0291849374771118, 0.0608153343200684, 0.156396150588989, -0.0179631114006042, 0.933529138565063, -0.142228841781616, 0.508113861083984, -0.151862323284149, 0.214200258255005, 0.195748805999756, -0.200761675834656, 0.37986159324646, -0.0169776082038879, 0.0666741132736206, 0.0372289419174194, 0.259437203407288, 0.782616138458252, 0.0785588026046753, 0.759303212165833, 0.895891427993774, 0.0421346426010132, 0.0984143018722534, 0.706490635871887, 0.595160603523254, 0.274290919303894, -0.0363386869430542, 0.000153422355651855, 0.437767267227173, 0.0897624492645264, 0.115016102790833, -0.101437866687775, 0.451629281044006, 0.550224661827087, 0.718106627464294, 0.00278234481811523, 0.77832019329071, 0.754675388336182, 0.130301594734192, -0.0329762101173401, -0.389176428318024, -0.256227076053619, 0.384944677352905, -0.0250200033187866, 0.24537456035614, 0.161446809768677, 0.611140608787537, 0.495067358016968, -0.0359634757041931, -0.141731858253479, 0.506493210792542, 0.0727092027664185, 0.128565788269043, 0.747000813484192, 0.000410556793212891, 0.314549803733826, 0.936969995498657, -0.228114783763885, 0.176017045974731, 0.0719708204269409, 0.232436656951904, 0.174324035644531, 0.810500502586365, 0.187294483184814, 0.131831288337708, 0.720375061035156, 0.0501853227615356, 0.228588819503784, 0.307932615280151, 0.025910496711731, 0.714572906494141, 0.0424802303314209, 0.507407426834106, 0.209128499031067, -0.243382155895233, 0.112515091896057, 0.687459230422974, 0.0557522773742676, 0.0809857845306396, 0.364709496498108, -0.00945347547531128, 0.153064727783203, 0.230360388755798, 0.781985640525818, 0.0794345140457153, -0.077502429485321, 0.335227847099304, 0.0205612182617188, -0.135213971138, -0.0732071399688721, 0.216303586959839, -0.020331859588623, 0.680127382278442, -0.159120261669159, 0.984433889389038, -0.0112455487251282, 0.160178065299988, -0.174730896949768, 0.723623752593994, 0.426724433898926, 0.0388683080673218, 0.247565984725952, 0.235471963882446, 0.50982403755188, 0.151254177093506, -0.141997337341309, 0.270917296409607, 0.253825187683105, 0.0176851749420166, 0.0983066558837891, 0.692256569862366, -0.0158806443214417, 0.147410750389099, 0.421649098396301, 0.704157948493958, 0.880879521369934, -0.0408524870872498, 0.33426821231842, -0.238824188709259, 0.399787425994873, 0.590000510215759, 0.40423572063446, 0.79695188999176, 0.33040714263916, 0.237186312675476, 0.209811091423035, 0.127830624580383, -0.0666183829307556, -0.154033958911896, -0.0588763356208801, 0.321271300315857, 0.107420444488525, 0.139620900154114, 0.802371859550476, 0.476931810379028, -0.0154867768287659, 0.216452479362488, 0.415531992912292, 0.170898795127869, 0.851298928260803, 0.669820189476013, -0.00384169816970825, 0.393609285354614, 0.138559103012085, 0.825843453407288, 0.0783035755157471, 0.0622327327728271, 0.165603637695312, -0.132996201515198, -0.0323694348335266, 0.785514354705811, 0.284884691238403, 0.302737474441528, 0.795318484306335, 0.410048723220825, -0.000267624855041504, 0.453141450881958, -0.124668002128601, 0.686711311340332, 0.22030782699585, -0.158663511276245, 0.199024558067322, 0.757801532745361, 0.0346522331237793, 0.061028003692627, 0.243549227714539, -0.242311954498291, -0.011596143245697, -0.00904977321624756, 0.202807188034058, -0.0030401349067688, 0.195554256439209, 0.284684062004089, 0.134694933891296, -0.0571586489677429, -0.0455120205879211, 0.272243738174438, 0.544923663139343, 0.110090017318726, 0.0697427988052368, 0.478049039840698, 0.609017610549927, 0.277175545692444, 0.152396321296692, -0.0603523850440979, -0.080935001373291, 0.228823661804199, 0.614610195159912, 0.273816585540771, 0.286745667457581, 0.557779908180237, 0.216082096099854, 0.300654888153076, -0.115167796611786, 0.0604523420333862, 0.383690237998962, 0.684200048446655, 0.227222323417664, 0.530531406402588, 0.169533610343933, -0.0346204042434692, -0.143416047096252, 0.20530891418457, -0.12345677614212, 0.96644914150238, 0.0934123992919922, 0.0470354557037354, -0.0864036679267883, 0.0230066776275635, 0.779574632644653, 0.646270036697388, 0.0334415435791016, 0.390813708305359, 0.0783379077911377, 0.471977472305298, 0.147904515266418, 0.367055535316467, -0.0650871992111206, 0.40388298034668, 0.428398847579956, -0.302975416183472, 0.711729645729065, 0.282833814620972, 0.383483171463013, 0.646578311920166, 0.414543032646179, -0.155750393867493, 0.163617730140686, 0.184059858322144, 0.138325691223145, -0.0193102359771729, 0.132886052131653, 0.308513402938843, 0.656211018562317, 0.559559226036072, -0.490635335445404, 0.142438769340515, 0.233199954032898, -0.254276037216187, 0.162201404571533, -0.112862884998322, 0.456719756126404, 0.212821006774902, 0.645932912826538, 0.711876153945923, 0.165556311607361, 0.547389507293701, 0.128281116485596, 0.697973847389221, -0.180776536464691, -0.0482214093208313, 0.406981825828552, 0.209258317947388, 0.162663578987122, 0.190721273422241, 0.314893484115601, 0.211045980453491, -0.00399518013000488, 0.0853182077407837, 0.980874180793762, 0.712960362434387, -0.0545270442962646, 0.201872944831848, 0.126740217208862, 0.50303852558136, 0.113638639450073, -0.260610640048981, 0.0946671962738037, 0.505739808082581, 0.65530800819397, 0.343985676765442, -0.153240025043488, 0.189293146133423, 0.557801008224487, -0.0399155616760254, 0.241558074951172, 0.250634074211121, 0.0869168043136597, 0.765678524971008, 0.395154595375061, -0.101485133171082, 0.0970941781997681, 0.193044662475586, 0.155396223068237, 0.133574247360229, 0.0547221899032593, 0.426000952720642, 0.178351879119873, 0.231519103050232, 0.295632481575012, 0.112440466880798, -0.110819041728973, 0.141453981399536, -0.308810770511627, 0.82758629322052, 0.0447762012481689, 0.0494076013565063, 0.414130330085754, 0.664229512214661, 0.801065921783447, 0.726376414299011, 0.202215671539307, 0.732383370399475, -0.410008370876312, -0.0319181680679321, 0.29381537437439, -0.0399903059005737, -0.0634090900421143, 0.429086804389954, 0.140283465385437, 0.385366916656494, 0.66470730304718, -0.0284548997879028, 0.240511894226074, 0.0524083375930786, -0.130750477313995, 0.476273417472839, 0.453227043151855, 0.186245918273926, 0.424437403678894, 0.0636696815490723, 0.0740945339202881, 0.362754344940186, 0.144443154335022, 0.588135838508606, 0.099794864654541, 0.553724527359009, 0.461647987365723, 0.47117805480957, -0.177537143230438, 0.0334198474884033, 0.726215600967407, 0.264901041984558, 0.631638050079346, 0.279787659645081, 0.220217108726501, -0.23878002166748 }, 

   { 0.153670907020569, 0.590579390525818, 0.385374307632446, 0.0532160997390747, 0.68840754032135, 0.212414145469666, 0.124358654022217, 0.594968199729919, 0.489999532699585, 0.238981366157532, -0.0598853230476379, 0.452233910560608, 0.0654721260070801, 0.367215156555176, 0.452204465866089, 0.881929755210876, 0.150786519050598, 0.209548830986023, 0.482665419578552, 0.258556127548218, 0.341725945472717, 0.646134376525879, 0.327667832374573, 0.411848068237305, 0.0758614540100098, 0.369497656822205, 0.711318850517273, 0.804273247718811, 0.259865880012512, 0.471394062042236, 0.320353269577026, 0.379459261894226, 0.409867763519287, 0.0227293968200684, 0.766323089599609, 0.266284942626953, 0.142684459686279, 0.431721925735474, 0.248894810676575, 0.698364853858948, 0.419120192527771, 0.734917402267456, 0.590218424797058, -0.219965994358063, 0.271193504333496, 0.247260808944702, 0.10775363445282, 0.675409555435181, 0.589327812194824, 0.107733726501465, 0.260089159011841, 0.528122663497925, 0.0191296339035034, 0.000333547592163086, 0.451214075088501, 0.335092067718506, 0.363850712776184, 0.460057377815247, 0.0846164226531982, -0.378657817840576, 0.72404944896698, 0.183451175689697, 0.277178287506104, 0.0818585157394409, 0.595656037330627, 0.153973698616028, 0.208246946334839, 0.319988250732422, 0.30993390083313, 0.0958321094512939, 0.296571254730225, -0.14177280664444, 0.703443646430969, 0.255540728569031, -0.0372632741928101, 0.484109044075012, -0.0499470829963684, -0.156460523605347, 0.395870447158813, 0.709658622741699, 0.315970897674561, 0.178860425949097, 0.081684947013855, 0.627362728118896, 0.683617234230042, 0.292139768600464, 0.805402994155884, 0.161923408508301, 0.350315093994141, 0.0430870056152344, 0.438796639442444, 0.764942049980164, 0.323517203330994, 0.327300310134888, 0.147797346115112, -0.0209872722625732, 0.9239102602005, 0.249194025993347, 0.286825180053711, 0.123851776123047, -0.0120692253112793, 0.0187453031539917, 0.105498790740967, 0.153340458869934, 0.0361794233322144, 0.583300828933716, 0.798400640487671, 0.200271129608154, 0.218694806098938, 0.0262306928634644, 0.222484946250916, 0.570418477058411, 0.216318845748901, 0.197317123413086, 0.211159706115723, 0.128045916557312, 0.108314633369446, 0.00152862071990967, 0.51572573184967, 0.331333518028259, 0.34183406829834, -0.0110379457473755, 0.735220670700073, 0.113805890083313, 0.161262035369873, 0.43955671787262, 0.592440128326416, 0.215932130813599, 0.246448636054993, 0.200993776321411, 0.239428520202637, 0.853685975074768, -0.0439994335174561, 0.0307936668395996, 0.126474499702454, 0.266981482505798, 0.167624711990356, 0.281578660011292, 0.568846464157104, 0.2107173204422, 0.399704933166504, -0.126760840415955, 0.239182114601135, 0.0695266723632812, 0.161711573600769, 0.271970987319946, 0.017259955406189, 0.553934097290039, 0.114253997802734, 0.574262261390686, 0.442299842834473, 0.337018251419067, 0.155509948730469, 0.386105060577393, 0.618873000144958, 0.214102745056152, -0.0124180316925049, 0.772266864776611, 0.281102895736694, -0.186237514019012, 0.45439875125885, -0.133737325668335, 0.00535595417022705, 0.376052737236023, 0.194474577903748, 0.74702000617981, 0.482743501663208, 0.673901557922363, 0.586633443832397, 0.389560341835022, 0.418562650680542, 0.0340868234634399, 0.307453751564026, -0.13490492105484, 0.183141708374023, 0.266632437705994, -0.150720953941345, 0.431244134902954, 0.718449711799622, 0.595974802970886, 0.871011137962341, 0.15664005279541, 0.41929304599762, 0.27638828754425, 0.487606167793274, -0.147093415260315, 0.207090973854065, 0.250044703483582, -0.150236308574677, 0.250766396522522, 0.41593611240387, 0.786675095558167, 0.953924775123596, 0.944915413856506, 0.148000955581665, 0.135292291641235, 0.382196664810181, 0.277196168899536, -0.110279560089111, 0.205166101455688, 0.342933297157288, 0.641821265220642, 0.320876836776733, 0.469149231910706, 0.315770864486694, 0.830160021781921, 0.0663938522338867, 0.143558502197266, 0.518156170845032, 0.543608546257019, 0.19258439540863, 0.357351064682007, -0.0165116786956787, 0.107228398323059, 0.352987289428711, 0.4161376953125, 0.256006121635437, 0.66015100479126, 0.246208786964417, 0.320104837417603, 0.726014733314514, 0.484825372695923, 0.114545464515686, 0.369069695472717, 0.344311594963074, 0.72557806968689, 0.429803848266602, 0.441740036010742, 0.366275072097778, 0.326291680335999, 0.103392958641052, 0.123499393463135, 0.675867080688477, 0.0212172269821167, 0.117948174476624, 0.0104286670684814, 0.238619208335876, 0.191052794456482, 0.489949464797974, 0.393540143966675, 0.254066348075867, 0.433841228485107, 0.125520348548889, 0.198960781097412, 0.160360455513, 0.905853986740112, 0.256403088569641, 0.0646427869796753, 0.153521776199341, 0.0435603857040405, 0.424151659011841, 0.213775277137756, 0.948228120803833, 0.2210693359375, 0.894737243652344, 0.382249712944031, 0.284160494804382, 0.0620944499969482, 0.265562295913696, -0.114607870578766, 0.607491135597229, 0.342321991920471, 0.276593327522278, 0.168123006820679, 0.180444240570068, -0.185845375061035, 0.37864077091217, 0.882084965705872, 0.215142369270325, 0.201171040534973, 0.134924530982971, 0.449590921401978, 0.0597747564315796, 0.67942214012146, 0.311057567596436, 0.53846549987793, 0.196218967437744, 0.36659824848175, 0.755524516105652, 0.00704896450042725, 0.0157709121704102, 0.383427739143372, 0.110002756118774, 0.31251585483551, 0.783985137939453, -0.00971764326095581, 0.353164315223694, 0.277990102767944, 0.0746320486068726, 0.707247018814087, 0.124493718147278, 0.809645771980286, 0.267430663108826, 0.0159980058670044, 0.629876852035522, 0.174289345741272, 0.398653507232666, 0.271891355514526, 0.58793568611145, 0.24138355255127, 0.75793182849884, 0.721400380134583, 0.123953461647034, -0.0383673310279846, 0.215716481208801, 0.237548589706421, 0.308447360992432, 0.345209002494812, 0.290327787399292, 0.507785558700562, 0.561931014060974, 0.269925713539124, 0.423248171806335, -0.00374853610992432, 0.102157235145569, 0.318384408950806, -0.059779942035675, 0.0935039520263672, -0.0092279314994812, 0.694693446159363, 0.868488669395447, 0.182742357254028, 0.168447494506836, 0.336950302124023, 0.283272862434387, 0.413873910903931, 0.5751793384552, 0.0469738245010376, 0.897534370422363, 0.715852856636047, 0.356002688407898, -0.129368126392365, 0.762075662612915, 0.49907910823822, 0.145476579666138, 0.472540020942688, 0.342538475990295, 0.074967622756958, 0.386903285980225, 0.56286096572876, 0.880167603492737, 0.332861423492432, 0.731579661369324, 0.416280150413513, 0.4118492603302, 0.28290331363678, 0.39617133140564, 0.103434324264526, 0.120113611221313, 0.564010858535767, 0.163224577903748, 0.119370818138123, 0.418068051338196, 0.0595184564590454, -0.00543993711471558, 0.741122603416443, 0.496324300765991, -0.0574589967727661, 0.0128194093704224, 0.275245308876038, 0.622365117073059, 0.350621104240417, 0.277974009513855, 0.264530777931213, 0.455590724945068, 0.247214436531067, 0.249606132507324, 0.159478068351746, 0.235762119293213, 0.282554745674133, 0.728995680809021, 0.276121258735657, 0.738016486167908, 0.371116995811462, 0.101046085357666, 0.423101186752319, 0.164827585220337, 0.342694163322449, 0.468414068222046, 0.467333197593689, 0.385759592056274, 0.178280472755432, 0.465068936347961, 0.822887301445007, 0.432146549224854, 0.199038505554199, 0.241242527961731, 0.195996642112732, 0.648267388343811, 0.813463449478149, 0.323743939399719, 0.767122387886047, 0.116445660591125, 0.440466642379761, 0.237825036048889, 0.851945281028748, 0.599428415298462, 0.176682353019714, 0.259874105453491, 0.632822155952454, 0.235840797424316, 0.598186016082764, 0.0885655879974365, -0.0190314650535583, 0.152873039245605, 0.141448378562927, 0.291223049163818, 0.362916469573975, 0.389227509498596, 0.135359406471252, 0.127641439437866, 0.278042554855347, 0.159066319465637, 0.0946112871170044, 0.199676871299744, 0.361421465873718, 0.34421706199646, 0.941853284835815, 0.779809594154358, 0.348116993904114, 0.458178520202637, -0.10775238275528, 0.567192912101746, 0.175912499427795, 0.237550735473633, 0.219758987426758, 0.2588951587677, -0.0126600861549377, 0.278873205184937, 0.210017800331116, 0.511295557022095, 0.673173427581787, 0.634997129440308, 0.308943748474121, 0.62713348865509, 0.322182893753052, 0.605064272880554, 0.0781646966934204, 0.29423201084137, 0.771805047988892, -0.0367157459259033, 0.346272349357605, -0.0581080317497253, 0.441696643829346, 0.187369465827942, 0.634614706039429, 0.0585682392120361, 0.462209343910217, 0.0509730577468872, 0.341577768325806, 0.151149988174438, 0.346900582313538, 0.261245369911194, 0.266453504562378, 0.243829607963562, 0.206260919570923, 0.848004102706909, 0.18800950050354, 0.222356081008911, 0.465320944786072, 0.118473410606384, 0.00720047950744629, 0.21101987361908, 0.190083742141724, 0.644147992134094, 0.277435183525085, 0.361652731895447, 0.424251198768616, 0.0604813098907471, 0.155286312103271, 0.25779664516449, 0.203837037086487, 0.208475351333618, 0.261430859565735, 0.344698905944824, 0.165608286857605, 0.305809855461121, 0.421707391738892, 0.279989957809448, 0.200203895568848, 0.121526956558228, 0.105591654777527, -0.145637989044189, 0.259223937988281, 0.355199933052063, 0.767139911651611, 0.212941646575928, 0.0805385112762451, 0.330925226211548, 0.200026750564575, 0.165518164634705, -0.00865483283996582, 0.161327958106995, 0.810083627700806, 0.459761381149292, 0.406277418136597, 0.256094455718994, 0.260759353637695, 0.0790387392044067, 0.188141942024231, -0.0174468755722046, 0.566969633102417, -0.0899840593338013, 0.267726182937622, -0.0155109763145447, 0.616002917289734, 0.843907475471497, -0.0473816394805908, 0.0564918518066406, 0.434209227561951, 0.264737129211426, 0.528039813041687, 0.305947422981262, 0.0472451448440552, -0.105882704257965, 0.113027453422546, 0.380200266838074, -0.133350312709808, 0.197890400886536, 0.0980695486068726, 0.216820478439331, 0.414625406265259, 0.200214147567749, 0.211817622184753, 0.300412535667419, 0.249318718910217, 0.703124642372131, -0.0262871980667114, 0.581017255783081, 0.562442421913147, 0.217510104179382, -0.00621157884597778, -0.147918820381165, 0.310630559921265, 0.659220933914185, 0.22697913646698, -0.376830697059631, 0.0173876285552979, 0.819724202156067, -0.0597913861274719, 0.236362218856812, 0.11823570728302, 0.141863465309143, 0.20301342010498, 0.422246098518372, 0.423107147216797, 0.00212216377258301, 0.876739263534546, 0.779350280761719, 0.282354831695557, 0.310827851295471, 0.609301805496216, 0.303901553153992, 0.153518915176392, 0.151160478591919, 0.0494681596755981, 0.501419186592102, 0.675776720046997, 0.704539895057678, 0.540805816650391, 0.380497097969055, 0.150700211524963, -0.111223816871643, 0.321152448654175, 0.37748396396637, 0.199809074401855, 0.172930121421814, 0.259902358055115, 0.534828662872314, 0.640320301055908, 0.179275155067444, 0.0074763298034668, 0.767155051231384, 0.098807692527771, 0.854496240615845, -0.0873748660087585, 0.695124506950378, 0.136997222900391, 0.0813536643981934, 0.146902322769165, 0.0948519706726074, 0.497868537902832, 0.326490044593811, 0.256856322288513, 0.301286458969116, 0.0110125541687012, 0.0958553552627563, 0.180430054664612, 0.546339273452759, 0.662022352218628, 0.118048310279846, 0.478319048881531, 0.301237463951111, 0.324934840202332, 0.72430145740509, 0.228767514228821, 0.431923627853394, 0.729423642158508, -0.0575966238975525, 0.23292064666748, 0.0215108394622803, 0.116753935813904, 0.202221632003784, 0.61538290977478, 0.46511697769165, -0.0298260450363159, 0.86780858039856, 0.134978294372559, -0.140320062637329, 0.392353296279907, 0.370008826255798, 0.102562785148621, 0.562103152275085, 0.401912450790405, 0.574472188949585, 0.734758973121643, 0.290178656578064, 0.862129092216492, 0.136860370635986, 0.116733431816101, 0.235275149345398, 0.45672070980072, 0.74259078502655, 0.42952299118042, 0.428049921989441, 0.616332650184631, 0.568402767181396, 0.4378821849823, 0.429970026016235, 0.166916728019714, 0.106231570243835, 0.313132405281067, 0.384745955467224, 0.431579232215881, -0.106685280799866, 0.311335682868958, 0.0233540534973145, 0.501201510429382, 0.703762888908386, 0.546191453933716, 0.261401534080505, 0.350997090339661, 0.223031520843506, 0.349809169769287, 0.311429500579834, 0.313671946525574, 0.839895486831665, 0.81691837310791, 0.111897230148315, 0.448018312454224, 0.20632016658783, 0.205694556236267, 0.481759071350098, 0.293148517608643, 0.743985414505005, 0.243694186210632, 0.322945833206177, 0.242385864257812, 0.346566438674927, 0.266394734382629, 0.311291098594666, 0.142950057983398, 0.149300217628479, 0.105567812919617, 0.485740780830383, 0.248970746994019, 0.225297808647156, 0.128538250923157, 0.926324844360352, 0.368915200233459, 0.461238622665405, 0.714465260505676, -0.036135733127594, -0.32632851600647, 0.171504735946655, 0.262329578399658, 0.816628336906433, 0.672674894332886, 0.531813621520996, 0.850863456726074, 0.325439453125, 0.0560610294342041, 0.477353930473328, 0.507392287254333, 0.163952589035034, 0.425254106521606, 0.559779167175293, 0.688176155090332, 0.436258912086487, 0.600888013839722, 0.0680676698684692, 0.591816306114197, 0.208545565605164, 0.765935063362122, 0.513608932495117, 0.110241532325745, 0.0819756984710693, 0.53720760345459, 0.429169416427612, 0.438457846641541, 0.894692182540894, 0.532553672790527, 0.265138864517212, 0.288601040840149, 0.556496024131775, 0.483328342437744, 0.407543540000916, 0.195166349411011, -0.0476106405258179, 0.807381987571716, -0.00607442855834961, 0.548143267631531, 0.320920705795288, 0.269163370132446, 0.166273474693298, -0.114442229270935, 0.390438437461853, 0.00647568702697754, 0.501060247421265, 0.494571566581726, 0.426625370979309, 0.146123647689819, 0.260975360870361, 0.682890772819519, 0.777254581451416, 0.84194004535675, -0.160978436470032, 0.0505697727203369, 0.264785051345825, 0.0773030519485474, 0.502330541610718, 0.101748585700989, 0.783082962036133, 0.140357255935669, 0.238156676292419, 0.688070893287659, 0.347164273262024, 0.592537403106689, 0.229308009147644, 0.196718692779541, 0.161971569061279, 0.531341075897217, 0.356671333312988, 0.757319927215576, 0.0526067018508911, 0.40160870552063, 0.118130803108215, 0.0228532552719116, 0.325806140899658, -0.13932740688324, 0.01741623878479, 0.749747037887573, 0.375456094741821, -0.0541908144950867, 0.10837984085083, 0.633409738540649, -0.130894720554352, 0.312922358512878, 0.135433793067932, 0.120529890060425, -0.231388032436371, 0.861520886421204, 0.221658229827881, 0.206904292106628, 0.429658532142639, 0.270578384399414, 0.394147992134094, 0.179582476615906, 0.252459168434143, 0.272490501403809, 0.229034066200256, 0.458108305931091, 0.811338186264038, 0.320088386535645, 0.40703809261322, 0.172366142272949, 0.221189379692078, 0.297049760818481, 0.586216688156128, 0.60489809513092, 0.337790966033936, 0.816745519638062, 0.233040332794189, -0.0186119079589844, 0.755159497261047, 0.0352984666824341, 0.336923718452454, 0.0878013372421265, -0.0762360095977783, 0.2225421667099, 0.59011709690094, 0.944175720214844, 0.530818462371826, 0.448018431663513, 0.445380449295044, 0.168917298316956, -0.0160456299781799, 0.117250323295593, 0.824535608291626, 0.106482267379761, 0.11649227142334, 0.0374076366424561, 0.0759811401367188, 0.0559275150299072, 0.0955672264099121, 0.958920836448669, 0.0350450277328491, 0.696862936019897, 0.0541567802429199, 0.426381707191467, 0.386339664459229, 0.0511937141418457, 0.43120288848877, 0.0724251270294189, 0.127763867378235, 0.346196413040161, 0.386315822601318, 0.99999988079071, 0.190044522285461, 0.83160138130188, 0.799045085906982, 0.28634512424469, 0.131611347198486, 0.774021983146667, 0.615203738212585, 0.147861003875732, 0.0355716943740845, 0.235775828361511, 0.442333698272705, 0.247259736061096, 0.185112595558167, -0.162731766700745, 0.48658275604248, 0.630904793739319, 0.908508896827698, 0.176951169967651, 0.95279324054718, 0.77545177936554, 0.378518342971802, 0.171499133110046, 0.025547981262207, -0.194619357585907, 0.679639101028442, 0.375901222229004, 0.395152449607849, 0.376129150390625, 0.784904599189758, 0.770710706710815, -0.00738763809204102, 0.0844707489013672, 0.715303659439087, 0.18179714679718, 0.224684596061707, 0.909722328186035, 0.16032612323761, 0.407426357269287, 0.756225824356079, -0.0533207654953003, 0.164331078529358, 0.00322568416595459, 0.262377262115479, 0.140213489532471, 0.974453568458557, 0.10434627532959, 0.317867040634155, 0.864524841308594, 0.163575410842896, 0.332702040672302, 0.296200752258301, 0.321047067642212, 0.81416642665863, 0.0984635353088379, 0.709369301795959, 0.225448369979858, -0.123146295547485, 0.101934909820557, 0.79566478729248, 0.155478954315186, -0.0693331956863403, 0.628704905509949, 0.221017241477966, 0.27877402305603, 0.21562397480011, 0.834045886993408, 0.234266400337219, 0.0929535627365112, 0.354923605918884, 0.157194972038269, -0.0309762954711914, 0.237527370452881, 0.18082058429718, 0.108323812484741, 0.830421805381775, 0.0527417659759521, 0.804797649383545, 0.0864402055740356, 0.276855945587158, 0.0843003988265991, 0.730370879173279, 0.736815214157104, 0.245769381523132, 0.228036761283875, 0.396016716957092, 0.440367817878723, 0.151712417602539, -0.117010056972504, 0.118813753128052, 0.293021321296692, 0.118086457252502, 0.190306067466736, 0.764506459236145, 0.195640206336975, 0.144217014312744, 0.590105772018433, 0.87022876739502, 0.91823947429657, 0.193733096122742, 0.389563083648682, -0.0262758731842041, 0.32202422618866, 0.70562219619751, 0.374368071556091, 0.86913275718689, 0.344695568084717, 0.294518709182739, 0.358177781105042, 0.148821234703064, 0.116033434867859, 0.0941188335418701, -0.00225955247879028, 0.556208252906799, 0.382652640342712, 0.267854332923889, 0.680517673492432, 0.612429976463318, 0.176766991615295, 0.236599683761597, 0.580121517181396, 0.352364778518677, 0.816316723823547, 0.720685839653015, 0.077479362487793, 0.297338128089905, 0.268659591674805, 0.972710251808167, 0.223228454589844, 0.303671598434448, 0.237415194511414, 0.185789108276367, 0.152881383895874, 0.721176743507385, 0.424953699111938, 0.333131313323975, 0.889147639274597, 0.522943615913391, 0.0426226854324341, 0.361107110977173, 0.0808885097503662, 0.461763262748718, 0.41030740737915, 0.14166259765625, 0.255221247673035, 0.787714242935181, 0.186726927757263, 0.109739542007446, 0.253092050552368, -0.0565735697746277, 0.0960959196090698, 0.157149314880371, 0.191680550575256, 0.100093841552734, 0.331090211868286, 0.359964728355408, 0.150591254234314, 0.0718719959259033, 0.181314706802368, 0.281779766082764, 0.518750429153442, 0.212420463562012, 0.2015221118927, 0.476672291755676, 0.45696747303009, 0.417195200920105, 0.325430393218994, 0.110154032707214, 0.124701857566833, 0.23360002040863, 0.867388606071472, 0.397205948829651, 0.527826070785522, 0.799099922180176, 0.373302340507507, 0.228436350822449, 0.354470014572144, 0.384843826293945, 0.558396100997925, 0.864092826843262, 0.258922100067139, 0.347995162010193, 0.434199571609497, 0.175844550132751, 0.158552169799805, 0.263968586921692, -0.0595117211341858, 0.843634486198425, 0.221054434776306, 0.0341264009475708, -0.00932306051254272, 0.311715483665466, 0.826637029647827, 0.803198099136353, 0.281716585159302, 0.589001536369324, 0.0380097627639771, 0.465279817581177, 0.240684151649475, 0.348315834999084, -0.105427324771881, 0.43847131729126, 0.551553726196289, 0.0636050701141357, 0.892806172370911, 0.351647615432739, 0.308767676353455, 0.535332202911377, 0.605320811271667, 0.132538557052612, 0.314213871955872, 0.20184338092804, 0.234999179840088, 0.0664752721786499, 0.202996373176575, 0.276585340499878, 0.687756896018982, 0.619335770606995, -0.185202181339264, 0.124347567558289, 0.294968843460083, -0.0191261172294617, 0.292594432830811, 0.0534361600875854, 0.470314025878906, 0.168103337287903, 0.860096096992493, 0.590493559837341, 0.176163554191589, 0.689237356185913, 0.422480344772339, 0.75663423538208, -0.0305634737014771, 0.0762728452682495, 0.515354633331299, 0.131537795066833, 0.0565683841705322, 0.306445598602295, 0.392462968826294, 0.528539299964905, 0.189035177230835, 0.108861088752747, 0.834707498550415, 0.695995569229126, 0.239157557487488, 0.308197140693665, 0.219542741775513, 0.633118867874146, 0.256662130355835, -0.0979101061820984, 0.35628342628479, 0.545536398887634, 0.651983499526978, 0.319814085960388, -0.0337891578674316, 0.18748939037323, 0.772443771362305, 0.142553687095642, 0.142107129096985, 0.343209743499756, 0.359558343887329, 0.804323434829712, 0.555870652198792, -0.00197899341583252, 0.253115057945251, 0.131855607032776, 0.249944448471069, 0.187182784080505, 0.202690124511719, 0.447805523872375, 0.168793320655823, 0.164913415908813, 0.186214089393616, 0.181946873664856, -0.0587918162345886, 0.262226462364197, 0.0359630584716797, 0.874224543571472, 0.00250053405761719, 0.483172059059143, 0.421064972877502, 0.807252645492554, 0.904186010360718, 0.890562295913696, 0.314253568649292, 0.746037721633911, -0.331572413444519, 0.0302964448928833, 0.311437964439392, 0.0341019630432129, 0.0492799282073975, 0.45035195350647, 0.18815279006958, 0.596041083335876, 0.654778242111206, 0.207086563110352, 0.180450439453125, 0.223850011825562, 0.0376993417739868, 0.824065327644348, 0.34596049785614, 0.216782808303833, 0.596644282341003, 0.216282367706299, 0.192898511886597, 0.322178721427917, 0.4143226146698, 0.702207326889038, 0.164524912834167, 0.537686109542847, 0.610815167427063, 0.489395976066589, 0.0473506450653076, 0.283436298370361, 0.913613319396973, 0.289269328117371, 0.88995373249054, 0.44866144657135, 0.283025979995728, -0.104987561702728 }
};

inline double ReadSVM::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         // normalise variables
         std::vector<double> iV;
         iV.reserve(inputValues.size());
         int ivar = 0;
         for (std::vector<double>::const_iterator varIt = inputValues.begin();
              varIt != inputValues.end(); varIt++, ivar++) {
            iV.push_back(NormVariable( *varIt, fVmin[ivar], fVmax[ivar] ));
         }
         Transform( iV, -1 );
         retval = GetMvaValue__( iV );
   }

   return retval;
}

//_______________________________________________________________________
inline void ReadSVM::InitTransform_1()
{
   double fMin_1[3][4];
   double fMax_1[3][4];
   // Normalization transformation, initialisation
   fMin_1[0][0] = -5.16234207153;
   fMax_1[0][0] = 5.78214550018;
   fScal_1[0][0] = 2.0/(fMax_1[0][0]-fMin_1[0][0]);
   fOff_1[0][0] = fMin_1[0][0]*fScal_1[0][0]+1.;
   fMin_1[1][0] = -9.23118686676;
   fMax_1[1][0] = 7.07192516327;
   fScal_1[1][0] = 2.0/(fMax_1[1][0]-fMin_1[1][0]);
   fOff_1[1][0] = fMin_1[1][0]*fScal_1[1][0]+1.;
   fMin_1[2][0] = -9.23118686676;
   fMax_1[2][0] = 7.07192516327;
   fScal_1[2][0] = 2.0/(fMax_1[2][0]-fMin_1[2][0]);
   fOff_1[2][0] = fMin_1[2][0]*fScal_1[2][0]+1.;
   fMin_1[0][1] = -3.70671987534;
   fMax_1[0][1] = 4.02912044525;
   fScal_1[0][1] = 2.0/(fMax_1[0][1]-fMin_1[0][1]);
   fOff_1[0][1] = fMin_1[0][1]*fScal_1[0][1]+1.;
   fMin_1[1][1] = -3.45779681206;
   fMax_1[1][1] = 3.45797157288;
   fScal_1[1][1] = 2.0/(fMax_1[1][1]-fMin_1[1][1]);
   fOff_1[1][1] = fMin_1[1][1]*fScal_1[1][1]+1.;
   fMin_1[2][1] = -3.70671987534;
   fMax_1[2][1] = 4.02912044525;
   fScal_1[2][1] = 2.0/(fMax_1[2][1]-fMin_1[2][1]);
   fOff_1[2][1] = fMin_1[2][1]*fScal_1[2][1]+1.;
   fMin_1[0][2] = -3.18263268471;
   fMax_1[0][2] = 3.6047577858;
   fScal_1[0][2] = 2.0/(fMax_1[0][2]-fMin_1[0][2]);
   fOff_1[0][2] = fMin_1[0][2]*fScal_1[0][2]+1.;
   fMin_1[1][2] = -5.15695810318;
   fMax_1[1][2] = 4.15070819855;
   fScal_1[1][2] = 2.0/(fMax_1[1][2]-fMin_1[1][2]);
   fOff_1[1][2] = fMin_1[1][2]*fScal_1[1][2]+1.;
   fMin_1[2][2] = -5.15695810318;
   fMax_1[2][2] = 4.15070819855;
   fScal_1[2][2] = 2.0/(fMax_1[2][2]-fMin_1[2][2]);
   fOff_1[2][2] = fMin_1[2][2]*fScal_1[2][2]+1.;
   fMin_1[0][3] = -2.94924092293;
   fMax_1[0][3] = 3.84948801994;
   fScal_1[0][3] = 2.0/(fMax_1[0][3]-fMin_1[0][3]);
   fOff_1[0][3] = fMin_1[0][3]*fScal_1[0][3]+1.;
   fMin_1[1][3] = -6.31600189209;
   fMax_1[1][3] = 4.52105665207;
   fScal_1[1][3] = 2.0/(fMax_1[1][3]-fMin_1[1][3]);
   fOff_1[1][3] = fMin_1[1][3]*fScal_1[1][3]+1.;
   fMin_1[2][3] = -6.31600189209;
   fMax_1[2][3] = 4.52105665207;
   fScal_1[2][3] = 2.0/(fMax_1[2][3]-fMin_1[2][3]);
   fOff_1[2][3] = fMin_1[2][3]*fScal_1[2][3]+1.;
}

//_______________________________________________________________________
inline void ReadSVM::Transform_1( std::vector<double>& iv, int cls) const
{
   // Normalization transformation
   if (cls < 0 || cls > 2) {
   if (2 > 1 ) cls = 2;
      else cls = 2;
   }
   const int nVar = 4;

   // get indices of used variables

   // define the indices of the variables which are transformed by this transformation
   static std::vector<int> indicesGet;
   static std::vector<int> indicesPut;

   if ( indicesGet.empty() ) {
      indicesGet.reserve(fNvars);
      indicesGet.push_back( 0);
      indicesGet.push_back( 1);
      indicesGet.push_back( 2);
      indicesGet.push_back( 3);
   }
   if ( indicesPut.empty() ) {
      indicesPut.reserve(fNvars);
      indicesPut.push_back( 0);
      indicesPut.push_back( 1);
      indicesPut.push_back( 2);
      indicesPut.push_back( 3);
   }

   static std::vector<double> dv;
   dv.resize(nVar);
   for (int ivar=0; ivar<nVar; ivar++) dv[ivar] = iv[indicesGet.at(ivar)];
   for (int ivar=0;ivar<4;ivar++) {
      double offset = fOff_1[cls][ivar];
      double scale  = fScal_1[cls][ivar];
      iv[indicesPut.at(ivar)] = scale*dv[ivar]-offset;
   }
}

//_______________________________________________________________________
inline void ReadSVM::InitTransform()
{
   InitTransform_1();
}

//_______________________________________________________________________
inline void ReadSVM::Transform( std::vector<double>& iv, int sigOrBgd ) const
{
   Transform_1( iv, sigOrBgd );
}
