// Class: ReadLikelihood
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::Likelihood
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:48:58 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 10000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
TransformOutput: "True" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-4.58091497421,4.20716428757]
var2                          var2                          var2                          var2                                                            'F'    [-4.7536816597,4.51537322998]
var3                          var3                          var3                          var3                                                            'F'    [-5.28915071487,4.74734544754]
var4                          var4                          var4                          var4                                                            'F'    [-4.66884231567,5.14146757126]
NSpec 5
eta                           eta                           eta                           eta                                                             'F'    [-2.49881362915,2.49992322922]
abs(eta)<=1.3                 FisherCat_cat1                FisherCat_cat1                FisherCat:Category_Fisher_1   pass                              'C'    [0,1]
abs(eta)>1.3                  FisherCat_cat2                FisherCat_cat2                FisherCat:Category_Fisher_2   pass                              'C'    [0,1]
abs(eta)<=1.3                 LikelihoodCat_cat1            LikelihoodCat_cat1            LikelihoodCat:Category_Likelihood_1pass                              'C'    [0,1]
abs(eta)>1.3                  LikelihoodCat_cat2            LikelihoodCat_cat2            LikelihoodCat:Category_Likelihood_2pass                              'C'    [0,1]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <cmath>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihood : public IClassifierReader {

 public:

   // constructor
   ReadLikelihood( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihood" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadLikelihood() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[4]; 
   int    fNbin[4]; // number of bins (discrete variables may have less bins)
   double    fHistMin[4]; 
   double    fHistMax[4]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihood::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = -4.58091497421265;
   fHistMax[0] = 4.20716428756714;
   fNbin[1] = 10000;
   fHistMin[1] = -4.75368165969849;
   fHistMax[1] = 4.51537322998047;
   fNbin[2] = 10000;
   fHistMin[2] = -5.28915071487427;
   fHistMax[2] = 4.74734544754028;
   fNbin[3] = 10000;
   fHistMin[3] = -4.66884231567383;
   fHistMax[3] = 5.14146757125854;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
}

inline double ReadLikelihood::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihood: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihood::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (true) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihood::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihood::fRefS[][10000] = 
{ 
   { 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.52292871039117e-08, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 2.36524559937834e-08, 2.29825153116978e-15, 2.29825153116978e-15, 2.29825153116978e-15, 3.15366532888106e-09, 5.51890586564241e-08, 1.10378152839985e-07, 1.71874503962499e-07, 2.33370897717577e-07, 3.05905103914483e-07, 3.76862487883045e-07, 4.5885764166087e-07, 5.44006525160512e-07, 6.35462583886692e-07, 7.26918813143129e-07, 8.27835833661084e-07, 9.35060427309509e-07, 1.04070818451873e-06, 1.1573936262721e-06, 1.27407895433862e-06, 1.40022541472717e-06, 1.52321808855049e-06, 1.65882556757424e-06, 1.79127937371959e-06, 1.93792448044405e-06, 2.08930032385979e-06, 2.23909910346265e-06, 2.39835912907438e-06, 2.55761892731243e-06, 2.72476290774648e-06, 2.89190688818053e-06, 3.07324216919369e-06, 3.253001068515e-06, 3.43906685884576e-06, 3.62828677680227e-06, 3.82381358576822e-06, 4.02880186811672e-06, 4.23221263190499e-06, 4.4450848690758e-06, 4.65638004243374e-06, 4.87713623442687e-06, 5.09789242642e-06, 5.33126330992673e-06, 5.56463419343345e-06, 5.80273626837879e-06, 6.05029845246463e-06, 6.29628357273759e-06, 6.55015355732758e-06, 6.80402308717021e-06, 7.07366143615218e-06, 7.33699198463e-06, 7.6113606155559e-06, 7.88257511885604e-06, 8.16640476841712e-06, 8.44865735416533e-06, 8.74510169524001e-06, 9.04942953638965e-06, 9.34429681365145e-06, 9.65335493674502e-06, 9.95926075120224e-06, 1.02777803476783e-05, 1.05947237898363e-05, 1.0925858077826e-05, 1.12554153020028e-05, 1.15912798719364e-05, 1.19366059152526e-05, 1.22740475489991e-05, 1.26272570923902e-05, 1.29820446090889e-05, 1.33415614982368e-05, 1.37010792968795e-05, 1.4073210877541e-05, 1.44453433676972e-05, 1.48253593579284e-05, 1.52053762576543e-05, 1.55980051204097e-05, 1.59922128659673e-05, 1.63879976753378e-05, 1.67948219313985e-05, 1.71953361132182e-05, 1.76131961779902e-05, 1.80263250513235e-05, 1.8450493371347e-05, 1.8874659872381e-05, 1.93082869373029e-05, 1.97466470126528e-05, 2.01850052690133e-05, 2.06359800358769e-05, 2.10822217923123e-05, 2.15410800592508e-05, 2.19983612623764e-05, 2.24666800932027e-05, 2.29334218602162e-05, 2.34127764997538e-05, 2.3887405404821e-05, 2.4374645363423e-05, 2.48666146944743e-05, 2.53554335358785e-05, 2.58552881859941e-05, 2.63582969637355e-05, 2.68676139967283e-05, 2.74463091045618e-05, 2.80202766589355e-05, 2.85847818304319e-05, 2.91745163849555e-05, 2.97516380669549e-05, 3.03445231111255e-05, 3.09563365590293e-05, 3.15492216031998e-05, 3.21799525409006e-05, 3.28075329889543e-05, 3.34445721819066e-05, 3.40753031196073e-05, 3.47407258232124e-05, 3.53998402715661e-05, 3.6055800592294e-05, 3.67401480616536e-05, 3.74244918930344e-05, 3.81088393623941e-05, 3.88121006835718e-05, 3.9531136280857e-05, 4.02438672608696e-05, 4.09629028581548e-05, 4.169770545559e-05, 4.24482750531752e-05, 4.31830740126316e-05, 4.3949421524303e-05, 4.47220663772896e-05, 4.55010158475488e-05, 4.62736607005354e-05, 4.70652375952341e-05, 4.78725705761462e-05, 4.8667294322513e-05, 4.94872438139282e-05, 5.03103510709479e-05, 5.11523758177646e-05, 5.19817913300358e-05, 5.28364362253342e-05, 5.36910774826538e-05, 5.45488692296203e-05, 5.54255893803202e-05, 5.63117646379396e-05, 5.71947966818698e-05, 5.80904306843877e-05, 5.89986848353874e-05, 5.99195554968901e-05, 6.08404261583928e-05, 6.17644473095424e-05, 6.27105473540723e-05, 6.36440308880992e-05, 6.46027401671745e-05, 6.55740732327104e-05, 6.65548577671871e-05, 6.75198753015138e-05, 6.85132763464935e-05, 6.95224516675808e-05, 7.05095444573089e-05, 7.15313362888992e-05, 7.25499703548849e-05, 7.35685971449129e-05, 7.46061559766531e-05, 7.56531662773341e-05, 7.67128003644757e-05, 7.77661189204082e-05, 7.88320539868437e-05, 7.99200715846382e-05, 8.09986231615767e-05, 8.20929417386651e-05, 8.32061778055504e-05, 8.43194284243509e-05, 8.54326717671938e-05, 8.65585316205397e-05, 8.77033089636825e-05, 8.88291688170284e-05, 8.99928636499681e-05, 9.11534152692184e-05, 9.23107945709489e-05, 9.34902709559537e-05, 9.46823565755039e-05, 9.58807504503056e-05, 9.70696710282937e-05, 9.82838391792029e-05, 9.94980000541545e-05, 0.000100724762887694, 0.000101961006294005, 0.000103206701169256, 0.000104461854789406, 0.000105707549664658, 0.00010698163532652, 0.000108258864202071, 0.00010953610035358, 0.000110825938463677, 0.000112128407636192, 0.000113443486043252, 0.000114752256195061, 0.000116083101602271, 0.000117417097499128, 0.000118747935630381, 0.00012010086356895, 0.000121456934721209, 0.000122809855383821, 0.000124185098684393, 0.000125597944133915, 0.000127010789583437, 0.000128423635032959, 0.000129855397972278, 0.000131312379380688, 0.000132750472403131, 0.000134213754790835, 0.000135695983772166, 0.000137190829264, 0.000138673043693416, 0.000140180505695753, 0.000141694268677384, 0.000143226949148811, 0.000144765930599533, 0.000146311242133379, 0.0001478817575844, 0.000149439671076834, 0.000151016502059065, 0.000152618566062301, 0.000154214329086244, 0.000155822694068775, 0.000157443675561808, 0.000159058341523632, 0.00016071718710009, 0.00016236340161413, 0.000164034820045345, 0.000165693665621802, 0.000167396647157148, 0.000169087026733905, 0.000170783678186126, 0.00017249929078389, 0.000174233806319535, 0.000175955690792762, 0.000177709152922034, 0.00017946888692677, 0.00018123495101463, 0.000183013617061079, 0.000184792283107527, 0.000186596167623065, 0.000188412697752938, 0.000190222897799686, 0.00019205201533623, 0.000193900064914487, 0.000195754415472038, 0.000197608766029589, 0.000199475762201473, 0.000201367947738618, 0.000203253846848384, 0.000205152333364822, 0.000207063465495594, 0.000208993515116163, 0.00021092988026794, 0.000212859915336594, 0.00021483410091605, 0.000216795699088834, 0.000218769884668291, 0.00022075668675825, 0.000222756134462543, 0.000224768155021593, 0.000226773889153264, 0.000228798526222818, 0.000230848439969122, 0.000232891994528472, 0.000234948194702156, 0.000237016996834427, 0.00023911104653962, 0.000241192450630479, 0.000243280199356377, 0.000245405768509954, 0.000247531337663531, 0.000249669508775696, 0.000251795077929273, 0.000253958482062444, 0.000256121915299445, 0.000258291664067656, 0.000260473985690624, 0.000262675224803388, 0.000264882808551192, 0.000267090363195166, 0.000269310548901558, 0.000271562254056334, 0.000273795070825145, 0.000276059407042339, 0.000278323743259534, 0.000280619598925114, 0.000282902852632105, 0.000285186106339097, 0.000287513510556892, 0.000289828312816098, 0.000292155687930062, 0.000294489436782897, 0.000296854675980285, 0.000299213657854125, 0.000301578867947683, 0.000303963053738698, 0.000306347210425884, 0.000308769202092662, 0.000311178620904684, 0.000313600670779124, 0.000316218822263181, 0.000318596692522988, 0.000320987164741382, 0.000323396583553404, 0.000325831206282601, 0.000328265887219459, 0.000330719456542283, 0.000333179312292486, 0.000335658085532486, 0.000338143145199865, 0.000340666098054498, 0.000343182735377923, 0.000345705688232556, 0.000348260160535574, 0.00035082723479718, 0.000353394338162616, 0.000355980359017849, 0.0003585790109355, 0.000361202837666497, 0.000363826664397493, 0.000366463151294738, 0.000369137473171577, 0.000371799163985997, 0.000374473456759006, 0.000377166725229472, 0.000379891484044492, 0.000382603640900925, 0.000385334744350985, 0.000388109998311847, 0.000390866305679083, 0.000393635215004906, 0.000396416755393147, 0.000399236159864813, 0.000402055535232648, 0.000404887541662902, 0.000407738436479121, 0.000410595675930381, 0.00041345291538164, 0.000416360591771081, 0.000419255637098104, 0.000422163313487545, 0.000425096281105652, 0.000428048078902066, 0.000430993619374931, 0.000433958106441423, 0.000436935166362673, 0.000439943745732307, 0.000442939752247185, 0.000445960962679237, 0.000449001090601087, 0.000452053878689185, 0.000455106608569622, 0.000458190916106105, 0.000461287825601175, 0.000464397337054834, 0.000467506877612323, 0.000470641592983156, 0.000473795313155279, 0.0004769426304847, 0.000480121554573998, 0.000483300449559465, 0.000486510893097147, 0.000489715079311281, 0.0004929443821311, 0.000496180029585958, 0.000499428366310894, 0.000502708135172725, 0.000505988020449877, 0.000509292993228883, 0.000512585509568453, 0.000515915744472295, 0.000519246037583798, 0.000522601534612477, 0.000525976007338613, 0.000529337790794671, 0.000532718549948186, 0.000536130799446255, 0.000539549335371703, 0.000542974274139851, 0.000546405441127717, 0.000549887132365257, 0.000553349847905338, 0.000556831480935216, 0.000560325745027512, 0.000563851557672024, 0.000567371083889157, 0.000570909527596086, 0.00057447946164757, 0.000578036881051958, 0.000581613043323159, 0.000585195666644722, 0.000588816066738218, 0.000592436466831714, 0.000596063211560249, 0.00059971516020596, 0.000603386084549129, 0.000607050606049597, 0.000610734103247523, 0.000614442804362625, 0.000618170481175184, 0.000622440536972135, 0.000626130378805101, 0.000629813876003027, 0.000633547781035304, 0.000637262826785445, 0.000641028338577598, 0.000644818996079266, 0.000648609711788595, 0.000652413000352681, 0.000656229036394507, 0.000660108053125441, 0.000663968094158918, 0.00066785974195227, 0.000671757676173002, 0.000675699790008366, 0.000679667107760906, 0.000683628080878407, 0.000687608029693365, 0.00069160689599812, 0.000695637310855091, 0.000699705502483994, 0.000703767407685518, 0.000707835657522082, 0.000711967062670738, 0.000716079375706613, 0.000720242271199822, 0.000724379904568195, 0.000728580635040998, 0.000732775020878762, 0.00073700089706108, 0.000741220486816019, 0.000745503231883049, 0.000749798433389515, 0.000754093809518963, 0.000758408044930547, 0.000762747484259307, 0.000767105841077864, 0.000771483115386218, 0.000775891996454448, 0.000780307105742395, 0.000784734846092761, 0.000789181503932923, 0.00079366605496034, 0.000798169523477554, 0.000802679336629808, 0.000807226868346334, 0.000811787089332938, 0.000816347310319543, 0.000820939079858363, 0.000825549708679318, 0.000830185657832772, 0.000834840466268361, 0.000839501561131328, 0.000844213180243969, 0.00084891211008653, 0.000853636360261589, 0.000858379469718784, 0.000863160414155573, 0.000867947703227401, 0.000872747623361647, 0.000877604237757623, 0.000882435764651746, 0.000887286034412682, 0.000892167910933495, 0.000897100253496319, 0.000902007392141968, 0.000906939734704792, 0.00091190985403955, 0.000916911696549505, 0.00092189438873902, 0.00092692143516615, 0.000931986200157553, 0.000937044678721577, 0.000942096929065883, 0.000947212101891637, 0.00095234636683017, 0.000957480457145721, 0.000962614663876593, 0.000967799336649477, 0.000973015499766916, 0.000978225260041654, 0.000983441597782075, 0.000988701940514147, 0.000994000001810491, 0.000999279320240021, 0.00100459018722177, 0.00100993865635246, 0.00101529364474118, 0.00102064223028719, 0.00102604134008288, 0.00103147199843079, 0.00103689637035131, 0.00104233948513865, 0.00104780169203877, 0.00105331430677325, 0.00105881434865296, 0.00106433953624219, 0.00106989638879895, 0.0010754531249404, 0.0010810288367793, 0.00108640047255903, 0.00109206442721188, 0.00109775364398956, 0.00110349338501692, 0.00110924558248371, 0.00111502315849066, 0.00112080073449761, 0.00112665386404842, 0.00113250711001456, 0.00113838550169021, 0.00114427658263594, 0.00115024333354086, 0.0011561973951757, 0.00116217671893537, 0.00116819399408996, 0.00117422395851463, 0.00118029152508825, 0.00118638435378671, 0.00119250244461, 0.00119863322470337, 0.00120481429621577, 0.00121099560055882, 0.00121722719632089, 0.00122347148135304, 0.00122972833923995, 0.00123606098350137, 0.0012423429870978, 0.00124868808779866, 0.00125507125630975, 0.00126147945411503, 0.0012679003411904, 0.0012743464903906, 0.00128083035815507, 0.0012873396044597, 0.00129387388005853, 0.00130042107775807, 0.00130700576119125, 0.00131361582316458, 0.00132025114726275, 0.00132692430634052, 0.00133362272754312, 0.00134032103233039, 0.00134705728851259, 0.0013538314960897, 0.001360630732961, 0.0013674427755177, 0.00137427973095328, 0.00138115487061441, 0.00138806772883981, 0.00139496789779514, 0.00140191859100014, 0.00140890711918473, 0.0014159083366394, 0.00142292201053351, 0.00142997363582253, 0.00143707578536123, 0.00144417770206928, 0.00145129242446274, 0.00145845755469054, 0.00146564783062786, 0.00147285079583526, 0.00148006645031273, 0.00148733251262456, 0.00149464898277074, 0.00150194019079208, 0.0015092819230631, 0.00151664903387427, 0.00152404117397964, 0.00153144600335509, 0.0015388885512948, 0.00154638173989952, 0.00155386212281883, 0.00156138057354838, 0.00156892405357212, 0.00157651805784553, 0.00158411217853427, 0.00159171898849308, 0.00159937597345561, 0.00160703307483345, 0.00161476584617049, 0.00162249873392284, 0.00163024419452995, 0.00163801468443125, 0.00164583569858223, 0.00165365682914853, 0.0016615284839645, 0.00166938756592572, 0.00167732208501548, 0.00168525660410523, 0.00169321661815047, 0.00170118897221982, 0.00170922453980893, 0.00171725999098271, 0.00172533350996673, 0.00173343194182962, 0.00174154317937791, 0.00174967967905104, 0.00175786670297384, 0.0017660662997514, 0.00177429092582315, 0.00178133905865252, 0.0017897782381624, 0.00179824256338179, 0.00180673238355666, 0.00181524711661041, 0.00182379991747439, 0.00183236529119313, 0.00184098107274622, 0.00184960942715406, 0.00185827573295683, 0.0018669671844691, 0.00187568389810622, 0.00188442587386817, 0.00189320556819439, 0.00190199806820601, 0.00191084097605199, 0.0019196963403374, 0.00192858977243304, 0.00193750823382288, 0.00194646476302296, 0.00195543351583183, 0.00196444056928158, 0.00197348510846496, 0.00198254245333374, 0.00199163774959743, 0.00200074538588524, 0.00200990377925336, 0.0020190745126456, 0.00202828319743276, 0.00203752983361483, 0.00204678880982101, 0.00205607316456735, 0.00206539547070861, 0.00207474292255938, 0.00208412832580507, 0.00209352606907487, 0.00210296199657023, 0.00211242283694446, 0.00212190905585885, 0.00213143322616816, 0.00214096973650157, 0.00215055677108467, 0.00216016941703856, 0.00216979440301657, 0.00217945710755885, 0.00218915776349604, 0.00219888356514275, 0.00220862217247486, 0.00221841130405664, 0.0022282253485173, 0.00223803939297795, 0.00224791676737368, 0.00225781928747892, 0.00226773438043892, 0.00227767461910844, 0.00228766561485827, 0.00229766895063221, 0.00230769766494632, 0.00231776386499405, 0.00232785567641258, 0.00233797263354063, 0.00234812754206359, 0.00235832016915083, 0.00236851279623806, 0.00237875571474433, 0.00238901167176664, 0.00239930511452258, 0.00240963627584279, 0.0024199930485338, 0.00243037496693432, 0.00244076945818961, 0.00245121447369456, 0.00246167206205428, 0.00247216736897826, 0.00248268805444241, 0.00249323365278542, 0.00250383000820875, 0.00251443893648684, 0.00252507324330509, 0.00253574503585696, 0.00254642986692488, 0.00255715218372643, 0.00256791221909225, 0.00257868529297411, 0.00258949631825089, 0.00260034459643066, 0.00261120591312647, 0.00262210518121719, 0.00263301655650139, 0.0026439786888659, 0.00265496596693993, 0.00266596605069935, 0.00267701642587781, 0.00268807937391102, 0.00269914255477488, 0.00271028117276728, 0.00272143259644508, 0.00273260939866304, 0.00274382368661463, 0.00275506335310638, 0.0027668762486428, 0.00277827982790768, 0.0027896708343178, 0.00280113774351776, 0.00281260418705642, 0.00282408366911113, 0.00283562601543963, 0.00284714321605861, 0.00285871094092727, 0.00287031638436019, 0.00288194697350264, 0.00289357779547572, 0.00290528428740799, 0.00291696540080011, 0.00292868469841778, 0.00294045405462384, 0.00295223598368466, 0.00296406890265644, 0.00297587597742677, 0.00298774638213217, 0.00299964193254709, 0.00301155028864741, 0.00302347098477185, 0.00303546781651676, 0.00304743880406022, 0.00305944820865989, 0.00307150790467858, 0.00308355502784252, 0.00309563963674009, 0.00310778757557273, 0.00311992294155061, 0.00313212117180228, 0.00314433197490871, 0.00315654324367642, 0.00316881737671793, 0.00318109150975943, 0.0031934033613652, 0.00320575293153524, 0.00321810273453593, 0.00323047791607678, 0.0032428908161819, 0.00325532886199653, 0.00326781719923019, 0.00328028062358499, 0.00329283205792308, 0.00330537115223706, 0.00331793539226055, 0.00333053758367896, 0.00334315211512148, 0.00335580459795892, 0.00336849503219128, 0.00338119803927839, 0.00339392642490566, 0.00340669229626656, 0.00341947097331285, 0.00343226222321391, 0.0034451165702194, 0.00345797091722488, 0.0034708755556494, 0.00348378042690456, 0.00349672324955463, 0.00350970355793834, 0.00352268409915268, 0.0035357023589313, 0.00354874599725008, 0.00356181478127837, 0.00357489613816142, 0.0035880405921489, 0.00360119785182178, 0.00361436745151877, 0.0036275873426348, 0.00364079512655735, 0.00365409115329385, 0.00366736180149019, 0.00368065759539604, 0.00369400391355157, 0.00370737537741661, 0.00372073450125754, 0.00373418163508177, 0.00374760339036584, 0.00376107613556087, 0.00377458659932017, 0.00378809659741819, 0.00380164454691112, 0.0038152183406055, 0.0038288168143481, 0.00384245323948562, 0.00385611481033266, 0.00386977684684098, 0.00388351385481656, 0.00389722618274391, 0.00391097646206617, 0.00392477679997683, 0.00393857667222619, 0.00395240262150764, 0.00396629143506289, 0.00398016767576337, 0.00399406906217337, 0.00400804588571191, 0.00402199756354094, 0.00403685355558991, 0.00405195355415344, 0.00406705914065242, 0.00408218428492546, 0.00409730290994048, 0.00411241548135877, 0.00412755319848657, 0.00414264667779207, 0.00415776530280709, 0.00417289044708014, 0.0041879964992404, 0.0042030899785459, 0.0042182276956737, 0.00423333374783397, 0.0042484775185585, 0.00426358357071877, 0.00427867705002427, 0.00429381476715207, 0.00430890824645758, 0.0043240268714726, 0.00433914549648762, 0.00435425201430917, 0.00436935760080814, 0.00438447669148445, 0.00439960788935423, 0.00441472046077251, 0.00442978832870722, 0.00444493256509304, 0.00446003209799528, 0.00447515118867159, 0.00449026329442859, 0.00450536934658885, 0.00452048191800714, 0.00453560054302216, 0.00455071311444044, 0.00456578750163317, 0.00458093779161572, 0.00459601869806647, 0.00461116898804903, 0.00462624337524176, 0.0046413685195148, 0.0046564806252718, 0.00467159366235137, 0.00468666758388281, 0.00470179319381714, 0.00471690529957414, 0.00473200483247638, 0.00474713603034616, 0.00476223602890968, 0.00477733602747321, 0.0047924485988915, 0.00480755418539047, 0.00482266675680876, 0.00483777280896902, 0.00485286023467779, 0.00486800447106361, 0.00488307885825634, 0.00489818444475532, 0.00491331610828638, 0.00492840306833386, 0.00494349654763937, 0.00495861517265439, 0.00497372122481465, 0.00498881470412016, 0.00500393379479647, 0.00501902727410197, 0.00503415847197175, 0.00504925241693854, 0.00506434543058276, 0.00507943844422698, 0.00509454542770982, 0.00510963844135404, 0.0051247701048851, 0.00513985706493258, 0.00515496311709285, 0.00517008872702718, 0.00518516916781664, 0.00520025612786412, 0.00521537521854043, 0.00523047428578138, 0.00524558126926422, 0.00526066776365042, 0.00527576776221395, 0.00529089896008372, 0.00530598685145378, 0.00532106077298522, 0.00533618638291955, 0.00535127287730575, 0.00536637892946601, 0.00538147892802954, 0.00539658544585109, 0.00541165936738253, 0.00542679661884904, 0.00544187193736434, 0.00545698404312134, 0.00547205889597535, 0.00548716494813561, 0.0055022775195539, 0.00551735144108534, 0.0055324574932456, 0.0055464431643486, 0.00556182581931353, 0.00557722896337509, 0.00559251150116324, 0.00560774374753237, 0.00562296947464347, 0.00563808809965849, 0.00565318809822202, 0.00566821824759245, 0.00568319810554385, 0.00569807691499591, 0.00571298133581877, 0.00572773395106196, 0.00574246188625693, 0.00575720192864537, 0.00577180320397019, 0.00578639283776283, 0.00580088049173355, 0.00581536209210753, 0.00582973659038544, 0.00584407290443778, 0.00585836544632912, 0.00587257603183389, 0.00588679919019341, 0.00590088963508606, 0.00591494841501117, 0.00592896342277527, 0.00594292161986232, 0.00595678528770804, 0.00597059819847345, 0.00598440505564213, 0.00599807966500521, 0.00601179152727127, 0.00602539023384452, 0.00603893771767616, 0.00605242326855659, 0.00606588320806623, 0.00607922347262502, 0.00609252508729696, 0.00610582111403346, 0.00611900351941586, 0.00613219803199172, 0.00614524213597178, 0.00615831697359681, 0.00617128517478704, 0.00618417747318745, 0.00619705021381378, 0.00620986754074693, 0.00622262014076114, 0.00623529218137264, 0.00624799448996782, 0.00626052729785442, 0.00627307267859578, 0.00628553656861186, 0.00629791803658009, 0.00631027342751622, 0.00632257852703333, 0.00633484683930874, 0.00634699501097202, 0.00635915528982878, 0.00637120893225074, 0.00638323044404387, 0.0063951825723052, 0.00640704063698649, 0.00641891732811928, 0.00643070600926876, 0.0064424560405314, 0.00645411852747202, 0.00646573631092906, 0.00647726003080606, 0.00648881494998932, 0.00650022504851222, 0.00651159090921283, 0.00652295025065541, 0.0065342029556632, 0.00654543610289693, 0.00655659986659884, 0.00656771333888173, 0.00657872017472982, 0.00658970745280385, 0.00660066958516836, 0.00661151157692075, 0.00662234798073769, 0.00663310848176479, 0.00664385594427586, 0.00665445206686854, 0.00666503608226776, 0.00667559402063489, 0.00668606441468, 0.00669649709016085, 0.00670684687793255, 0.0067171910777688, 0.00672740861773491, 0.00673764571547508, 0.00674775009974837, 0.00675779767334461, 0.0067678396590054, 0.00677779829129577, 0.00678773876279593, 0.00679755909368396, 0.00680766860023141, 0.00681541441008449, 0.00682310899719596, 0.00683067785575986, 0.00683814566582441, 0.00684561394155025, 0.00685292994603515, 0.00686022080481052, 0.0068673612549901, 0.00687450170516968, 0.00688148941844702, 0.00688837794587016, 0.00689526507630944, 0.00690200086683035, 0.00690871197730303, 0.00691532250493765, 0.00692185619845986, 0.00692826509475708, 0.00693469773977995, 0.00694095529615879, 0.0069470857270062, 0.00695326644927263, 0.00695927161723375, 0.00696522556245327, 0.00697110453620553, 0.00697690714150667, 0.00698255794122815, 0.00698823435232043, 0.00699373474344611, 0.00699915923178196, 0.00700455810874701, 0.00700983125716448, 0.00701507879421115, 0.00702020013704896, 0.00702527118846774, 0.00703019089996815, 0.00703516136854887, 0.0070399297401309, 0.00704464735463262, 0.00704931514337659, 0.00705380598083138, 0.00705832149833441, 0.00706271175295115, 0.00706702563911676, 0.0070712142623961, 0.00707535119727254, 0.00707943877205253, 0.00708337407559156, 0.00708736106753349, 0.00709111988544464, 0.00709485355764627, 0.00709851179271936, 0.00710211927071214, 0.00710557587444782, 0.00710900686681271, 0.00711236288771033, 0.0071155671030283, 0.00711879646405578, 0.00712182419374585, 0.00712487660348415, 0.00712775299325585, 0.00713055348023772, 0.0071333535015583, 0.0071360026486218, 0.00713860150426626, 0.0071411244571209, 0.00714354636147618, 0.00714586721733212, 0.00714813824743032, 0.00715030776336789, 0.00715237623080611, 0.00715441955253482, 0.00715636275708675, 0.00715820444747806, 0.00715994508937001, 0.00716166058555245, 0.00716330064460635, 0.0071648140437901, 0.00716627761721611, 0.00716761546209455, 0.00716892722994089, 0.00717008765786886, 0.0071711977943778, 0.00717225763946772, 0.007173215970397, 0.00717404810711741, 0.00717483088374138, 0.00717556197196245, 0.00717614265158772, 0.00717672286555171, 0.00717715173959732, 0.00717755500227213, 0.00717780692502856, 0.00717805977910757, 0.00717821158468723, 0.00717823673039675, 0.00717823673039675, 0.00717811053618789, 0.00717793358489871, 0.00717760529369116, 0.00717839458957314, 0.0071769873611629, 0.007175556384027, 0.00717406719923019, 0.00717252213507891, 0.00717095797881484, 0.00716930534690619, 0.00716763408854604, 0.00716590555384755, 0.0071641206741333, 0.00716229155659676, 0.00716048758476973, 0.00715853925794363, 0.00715656438842416, 0.00715455878525972, 0.00715248333290219, 0.0071503771468997, 0.00714818853884935, 0.00714600645005703, 0.00714373541995883, 0.00714141456410289, 0.00713907461613417, 0.00713666528463364, 0.00713419262319803, 0.00713171996176243, 0.00712917791679502, 0.0071265478618443, 0.00712391175329685, 0.00712124397978187, 0.00711852498352528, 0.00711573148146272, 0.00711290491744876, 0.00711000431329012, 0.0071070771664381, 0.00710408762097359, 0.00710105942562222, 0.00709800096228719, 0.00709485355764627, 0.00709168752655387, 0.00708847073838115, 0.00708519108593464, 0.00708186067640781, 0.00707851769402623, 0.00707510579377413, 0.00707161752507091, 0.00706811062991619, 0.0070645660161972, 0.00706092035397887, 0.00705728773027658, 0.00705357827246189, 0.00704982550814748, 0.00704605411738157, 0.00704224407672882, 0.00703830877318978, 0.00703437253832817, 0.00703040510416031, 0.00702633755281568, 0.00702224345877767, 0.00701809395104647, 0.00701391836628318, 0.00700969249010086, 0.00700540980324149, 0.00700108893215656, 0.0069966921582818, 0.00699225254356861, 0.00698776775971055, 0.006983264349401, 0.00697869202122092, 0.00697404984384775, 0.00696943886578083, 0.00696472730487585, 0.00695995939895511, 0.00695513375103474, 0.00695028994232416, 0.00694538932293653, 0.00694040628150105, 0.00693540461361408, 0.00693037128075957, 0.00692523084580898, 0.00692009646445513, 0.00691489921882749, 0.00690963258966804, 0.00690433522686362, 0.00689901132136583, 0.00689360639080405, 0.00688817491754889, 0.0068827448412776, 0.00687720719724894, 0.00687161879613996, 0.0068659670650959, 0.00686030322685838, 0.00685455743223429, 0.00684877997264266, 0.00684295175597072, 0.00683709885925055, 0.00683116354048252, 0.00682517746463418, 0.00681919232010841, 0.00681311823427677, 0.00680699339136481, 0.00680044759064913, 0.00679453136399388, 0.00678860303014517, 0.00678266817703843, 0.0067767514847219, 0.00677083525806665, 0.00676490599289536, 0.00675899023190141, 0.00675307353958488, 0.00674715079367161, 0.00674122851341963, 0.00673531228676438, 0.00672939559444785, 0.00672347331419587, 0.00671756314113736, 0.00671162782236934, 0.00670571764931083, 0.00669980235397816, 0.00669388566166162, 0.00668796943500638, 0.00668205926194787, 0.0066761365160346, 0.00667023286223412, 0.00666431710124016, 0.00665840040892363, 0.00665249675512314, 0.00664659310132265, 0.00664066476747394, 0.00663476064801216, 0.00662885699421167, 0.00662293424829841, 0.0066170240752399, 0.00661112042143941, 0.00660519814118743, 0.00659930100664496, 0.00659339688718319, 0.00658748112618923, 0.00658157747238874, 0.00657567381858826, 0.00656976969912648, 0.00656385999172926, 0.00655796239152551, 0.006552052218467, 0.0065461490303278, 0.00654025143012404, 0.00653434777632356, 0.00652843154966831, 0.0065225469879806, 0.00651664286851883, 0.00651072664186358, 0.00650484208017588, 0.00649894494563341, 0.00649304129183292, 0.00648713763803244, 0.00648124609142542, 0.00647534290328622, 0.00646944576874375, 0.00646354816854, 0.00645764404907823, 0.00645174691453576, 0.00644586887210608, 0.00643995869904757, 0.00643407367169857, 0.00642818259075284, 0.00642227893695235, 0.00641638832166791, 0.00641050329431891, 0.00640459964051843, 0.00639871461316943, 0.00639282446354628, 0.00638693291693926, 0.00638102926313877, 0.00637514423578978, 0.00636925315484405, 0.00636336207389832, 0.00635748403146863, 0.00635159248486161, 0.00634570186957717, 0.00633982382714748, 0.00633393228054047, 0.00632804725319147, 0.0063221687451005, 0.00631629722192883, 0.00631039962172508, 0.00630450854077935, 0.00629862351343036, 0.00629273941740394, 0.00628685439005494, 0.0062809819355607, 0.00627509132027626, 0.00626921840012074, 0.00626334687694907, 0.00625745579600334, 0.00625157682225108, 0.00624569924548268, 0.00623982027173042, 0.00623394828289747, 0.00622805766761303, 0.00622217869386077, 0.00621630670502782, 0.00620981026440859, 0.00620304886251688, 0.00619636941701174, 0.00618974678218365, 0.00618319353088737, 0.00617669709026814, 0.0061702630482614, 0.00616394309327006, 0.00615762965753675, 0.00615138513967395, 0.0061451974324882, 0.00613910518586636, 0.00613303715363145, 0.00612704548984766, 0.00612116046249866, 0.00611528195440769, 0.00610949192196131, 0.0061037396080792, 0.00609806925058365, 0.00609246827661991, 0.00608697440475225, 0.00608146190643311, 0.00607604347169399, 0.00607068231329322, 0.00606539053842425, 0.00606015557423234, 0.00605496531352401, 0.0060499063692987, 0.00604485394433141, 0.00603987136855721, 0.00603496422991157, 0.00603009480983019, 0.00602532038465142, 0.00602055201306939, 0.00601594708859921, 0.00601133005693555, 0.00600679591298103, 0.00600233022123575, 0.00599792087450624, 0.00599354365840554, 0.00598925445228815, 0.00598507886752486, 0.00598091632127762, 0.00597681710496545, 0.00597277982160449, 0.00596878118813038, 0.00596486404538155, 0.00596102979034185, 0.00595729565247893, 0.00595356104895473, 0.0059499223716557, 0.00594631396234035, 0.00594276981428266, 0.00593927502632141, 0.00593587569892406, 0.00593259558081627, 0.00592929730191827, 0.00592608703300357, 0.00592291448265314, 0.00591982388868928, 0.0059167961589992, 0.0059138317592442, 0.00591098051518202, 0.00590814184397459, 0.00590533530339599, 0.00590264284983277, 0.00589997414499521, 0.00589738180860877, 0.00589490355923772, 0.00589245604351163, 0.00589004019275308, 0.00588770024478436, 0.00588543619960546, 0.00588321592658758, 0.00588107807561755, 0.00587904592975974, 0.00587701518088579, 0.00587503518909216, 0.00587314320728183, 0.005871313624084, 0.00586953479796648, 0.0058678318746388, 0.00586621090769768, 0.00586462812498212, 0.00586310820654035, 0.00586167629808187, 0.00586028210818768, 0.00585894519463181, 0.00585769582539797, 0.00585653539747, 0.00585538148880005, 0.00585429649800062, 0.00585329392924905, 0.00585232861340046, 0.00585145130753517, 0.00585063174366951, 0.00584989413619041, 0.00584920076653361, 0.00584856932982802, 0.00584797654300928, 0.00584818562492728, 0.0058482363820076, 0.00584858888760209, 0.00584884127601981, 0.00584929576143622, 0.00584990065544844, 0.0058506834320724, 0.00585154118016362, 0.00585255073383451, 0.00585376145318151, 0.00585504807531834, 0.005856410600245, 0.00585794914513826, 0.00585971586406231, 0.00586148118600249, 0.00586342392489314, 0.00586561905220151, 0.00586786493659019, 0.00587021093815565, 0.00587265798822045, 0.00587533228099346, 0.00587808294221759, 0.0058809332549572, 0.00588413747027516, 0.00588731607422233, 0.00589052028954029, 0.00589395128190517, 0.00589763512834907, 0.00590129336342216, 0.00590512808412313, 0.00590924080461264, 0.00591332791373134, 0.00591754168272018, 0.00592190539464355, 0.00592649728059769, 0.00593113992363214, 0.00593593344092369, 0.00594097934663296, 0.00594599964097142, 0.00595119688659906, 0.00595649518072605, 0.00596199510619044, 0.00596759654581547, 0.00597342429682612, 0.0059793028049171, 0.00598530704155564, 0.00599143747240305, 0.0059976945631206, 0.00600417889654636, 0.00601073820143938, 0.00601747492328286, 0.00602433690801263, 0.00603124964982271, 0.00603833934292197, 0.00604552961885929, 0.00605297181755304, 0.00606044009327888, 0.00606808485463262, 0.00607593078166246, 0.00608382793143392, 0.00609182566404343, 0.00609997473657131, 0.00610837573185563, 0.00611682701855898, 0.00612538075074553, 0.00613418547436595, 0.00614299066364765, 0.00615192204713821, 0.00616113049909472, 0.00617041485384107, 0.00617972435429692, 0.0061892862431705, 0.00619902461767197, 0.00620881374925375, 0.00621870346367359, 0.00622887117788196, 0.00623901328071952, 0.00624938309192657, 0.00625985255464911, 0.00627055019140244, 0.00628124689683318, 0.00629209587350488, 0.00630319677293301, 0.00631429767236114, 0.0063256504945457, 0.00633700378239155, 0.00634863460436463, 0.00636034086346626, 0.00637212349101901, 0.0063841319642961, 0.00639624241739511, 0.00640847906470299, 0.00642081536352634, 0.00643337983638048, 0.00644601974636316, 0.0064587858505547, 0.00647172844037414, 0.00648477207869291, 0.00649796752259135, 0.00651128776371479, 0.0065257060341537, 0.00654182815924287, 0.00655802479013801, 0.00657455064356327, 0.00659110071137547, 0.00660780211910605, 0.00662465579807758, 0.00664173578843474, 0.00665886607021093, 0.00667617376893759, 0.00669373292475939, 0.00671136798337102, 0.00672902911901474, 0.00674694171175361, 0.00676508154720068, 0.00678327167406678, 0.006801538169384, 0.00682005658745766, 0.00683870073407888, 0.0068575469776988, 0.00687641836702824, 0.00689556775614619, 0.00691481726244092, 0.00693419389426708, 0.00695372140035033, 0.00697347614914179, 0.0069933058694005, 0.00701323710381985, 0.00703347101807594, 0.00705367978662252, 0.00707411486655474, 0.00709460163488984, 0.00711546605452895, 0.00713628064841032, 0.00715727126225829, 0.0071785394102335, 0.00719980709254742, 0.00722130294889212, 0.00724284816533327, 0.00726469699293375, 0.00728654582053423, 0.00730859627947211, 0.00733089866116643, 0.00735322665423155, 0.00737568084150553, 0.00739841209724545, 0.00742119504138827, 0.00744412746280432, 0.00746723776683211, 0.007490498945117, 0.00751378573477268, 0.00753735052421689, 0.00756111601367593, 0.00758490758016706, 0.0076089003123343, 0.00763312075287104, 0.00765734072774649, 0.00768173765391111, 0.00770631060004234, 0.00773113593459129, 0.00775596173480153, 0.00778096402063966, 0.00780614325776696, 0.00783144775778055, 0.00785692967474461, 0.00788251217454672, 0.00790834706276655, 0.00793425738811493, 0.00796026922762394, 0.00798643194139004, 0.0080128712579608, 0.00803938787430525, 0.00806592870503664, 0.00809287372976542, 0.00811976846307516, 0.00814688950777054, 0.00817408692091703, 0.00820153672248125, 0.00822906196117401, 0.00825668778270483, 0.00828464142978191, 0.008312595076859, 0.00834070052951574, 0.00836893264204264, 0.00839751679450274, 0.00842597614973783, 0.00845468696206808, 0.00848365016281605, 0.00851266365498304, 0.00854180287569761, 0.00857109483331442, 0.00860063824802637, 0.00863020680844784, 0.008659977465868, 0.00868997536599636, 0.00872002355754375, 0.00875017326325178, 0.00878052320331335, 0.00881105102598667, 0.00884170364588499, 0.00887008011341095, 0.00890080910176039, 0.00893163960427046, 0.00896267220377922, 0.00899372901767492, 0.00902488734573126, 0.00905627198517323, 0.00908768270164728, 0.009119245223701, 0.00915085710585117, 0.00918262079358101, 0.00921451114118099, 0.00924652721732855, 0.00927859358489513, 0.00931086111813784, 0.0093431044369936, 0.00937564950436354, 0.00940817128866911, 0.00944086816161871, 0.00947366654872894, 0.00950656458735466, 0.00953959114849567, 0.00957274157553911, 0.00960601959377527, 0.00963934790343046, 0.00967282708734274, 0.00970638263970613, 0.00974018964916468, 0.00977392122149467, 0.00980792939662933, 0.00984193850308657, 0.00987609941512346, 0.00991041213274002, 0.00994477421045303, 0.00997923593968153, 0.010013927705586, 0.0100486185401678, 0.0100835105404258, 0.0101184519007802, 0.0101535217836499, 0.0101887667551637, 0.0102240378037095, 0.0102594336494803, 0.0102949822321534, 0.0103306313976645, 0.0103664323687553, 0.0104023339226842, 0.0104382345452905, 0.0104744136333466, 0.0105105927214026, 0.0105469226837158, 0.0105834538117051, 0.0106199365109205, 0.0106566706672311, 0.0106934551149607, 0.0107303401455283, 0.010767325758934, 0.0108044892549515, 0.0108417021110654, 0.0108791431412101, 0.0109165832400322, 0.0109541993588209, 0.0109918424859643, 0.0110296607017517, 0.0110676307231188, 0.011105677112937, 0.0111438734456897, 0.0111821219325066, 0.011220520362258, 0.0112590463832021, 0.0112976469099522, 0.0113363228738308, 0.0113752512261271, 0.0114141553640366, 0.0114533118903637, 0.0114924171939492, 0.0115317245945334, 0.0115711838006973, 0.0116107175126672, 0.0116503527387977, 0.0116901136934757, 0.0117300022393465, 0.0117699904367328, 0.0118101052939892, 0.0118502946570516, 0.0118906619027257, 0.0119310542941093, 0.0119716227054596, 0.01201231777668, 0.0120531395077705, 0.0120940115302801, 0.0121350325644016, 0.0121761821210384, 0.0122174331918359, 0.0122587829828262, 0.0123002603650093, 0.01234186347574, 0.0123835429549217, 0.0124253984540701, 0.012467279098928, 0.0125075438991189, 0.0125486431643367, 0.0125898169353604, 0.0126311695203185, 0.0126725444570184, 0.012714046984911, 0.0127556510269642, 0.0127973295748234, 0.0128391850739717, 0.0128810657188296, 0.0129231233149767, 0.0129652814939618, 0.013007540255785, 0.0130498250946403, 0.0130923362448812, 0.0131348473951221, 0.0131775112822652, 0.0132202748209238, 0.0132631398737431, 0.0133061818778515, 0.0133492220193148, 0.0133924148976803, 0.0134357083588839, 0.0134791024029255, 0.0135226249694824, 0.0135661950334907, 0.0136099169030786, 0.0136537412181497, 0.0136976651847363, 0.0137416394427419, 0.0137858428061008, 0.0138300443068147, 0.0138744730502367, 0.0139188775792718, 0.0139634320512414, 0.0140081131830812, 0.0140528194606304, 0.0140977026894689, 0.0141426865011454, 0.0141877718269825, 0.0142329828813672, 0.01427829451859, 0.0143236313015223, 0.0143691953271627, 0.0144147602841258, 0.014460476115346, 0.0145063176751137, 0.014552160166204, 0.0145982531830668, 0.0146443480625749, 0.0146905928850174, 0.0147369652986526, 0.0147834122180939, 0.0148299848660827, 0.0148766338825226, 0.0149233592674136, 0.0149702364578843, 0.0150172132998705, 0.0150642665103078, 0.0151115199550986, 0.0151587491855025, 0.0152062308043242, 0.0152536621317267, 0.0153012704104185, 0.0153490053489804, 0.0153968380764127, 0.0154447006061673, 0.0154927354305983, 0.0155408997088671, 0.0155891124159098, 0.0156374778598547, 0.0156858935952187, 0.0157345086336136, 0.0157831273972988, 0.015831895172596, 0.0158807653933764, 0.0159296598285437, 0.0159788057208061, 0.0160279776901007, 0.0160772521048784, 0.0161266755312681, 0.0161761753261089, 0.0162257011979818, 0.0162755027413368, 0.0163252558559179, 0.0163752604275942, 0.0164252389222383, 0.0164753217250109, 0.0165256019681692, 0.0165759101510048, 0.0166263934224844, 0.0166769027709961, 0.0167275629937649, 0.0167783498764038, 0.0168292131274939, 0.0168801508843899, 0.016931239515543, 0.0169824566692114, 0.0170337222516537, 0.0170851144939661, 0.017134428024292, 0.0171863008290529, 0.0172382220625877, 0.0172903202474117, 0.0173424687236547, 0.0173947457224131, 0.0174471717327833, 0.0174996741116047, 0.0175523012876511, 0.0176050830632448, 0.0176579877734184, 0.0177109185606241, 0.017764026299119, 0.017817210406065, 0.0178705453872681, 0.0179239567369223, 0.0179774668067694, 0.0180311296135187, 0.0180848687887192, 0.0181387569755316, 0.0181927233934402, 0.018246890977025, 0.0183010585606098, 0.0183554273098707, 0.0184098463505507, 0.0184643696993589, 0.018519064411521, 0.0185738131403923, 0.0186287127435207, 0.0186837129294872, 0.0187388639897108, 0.0187940653413534, 0.0188494175672531, 0.0189048983156681, 0.018960477784276, 0.0190161596983671, 0.019071914255619, 0.0191278215497732, 0.0191838331520557, 0.0192399695515633, 0.0192961785942316, 0.0193525943905115, 0.0194090064615011, 0.0194656196981668, 0.0195222850888968, 0.0195791255682707, 0.0196360945701599, 0.0196930877864361, 0.0197502579540014, 0.0198075026273727, 0.0198648981750011, 0.0199223477393389, 0.0199799705296755, 0.0200376436114311, 0.0200954936444759, 0.0201533958315849, 0.0202114749699831, 0.0202696770429611, 0.0203279331326485, 0.0203863400965929, 0.0204447936266661, 0.0205034296959639, 0.0205621384084225, 0.0206210222095251, 0.020679933950305, 0.0207389686256647, 0.0207981839776039, 0.0208574198186398, 0.0209168363362551, 0.0209763757884502, 0.0210360456258059, 0.0210957359522581, 0.0211556553840637, 0.0212156008929014, 0.0212756469845772, 0.0213358458131552, 0.0213961414992809, 0.0214565917849541, 0.0215170942246914, 0.0215777438133955, 0.0216384958475828, 0.0216994229704142, 0.0217603798955679, 0.0218215100467205, 0.0218826923519373, 0.021943973377347, 0.0220054313540459, 0.0220669414848089, 0.022128626704216, 0.0221903882920742, 0.0222523007541895, 0.0223142895847559, 0.0223764311522245, 0.0224386677145958, 0.0225009862333536, 0.0225634537637234, 0.0226259715855122, 0.0226886924356222, 0.0227514356374741, 0.0228143595159054, 0.0228845775127411, 0.0229477006942034, 0.0230109263211489, 0.0230743009597063, 0.02313775382936, 0.0232014078646898, 0.0232651345431805, 0.0233289171010256, 0.0233928710222244, 0.0234569534659386, 0.0235210619866848, 0.0235853958874941, 0.0236497558653355, 0.0237142909318209, 0.0237789303064346, 0.0238436684012413, 0.0239085331559181, 0.0239736009389162, 0.0240386389195919, 0.0241038855165243, 0.0241691786795855, 0.0242346208542585, 0.024300217628479, 0.0243658646941185, 0.0244316607713699, 0.0244975853711367, 0.0245635844767094, 0.0246297121047974, 0.0246960148215294, 0.0247623939067125, 0.0248288959264755, 0.0248954519629478, 0.0249621830880642, 0.0250290147960186, 0.0250959489494562, 0.025163009762764, 0.0252302195876837, 0.0252975076436996, 0.0253649186342955, 0.0254324078559875, 0.0255000982433558, 0.025567913427949, 0.0256357304751873, 0.0257037468254566, 0.0257718674838543, 0.0258400626480579, 0.0259084068238735, 0.0259768553078175, 0.0260454025119543, 0.0261141024529934, 0.0261828768998384, 0.0262517798691988, 0.0263208318501711, 0.0263899322599173, 0.026459289714694, 0.0265286453068256, 0.0265981517732143, 0.0266677588224411, 0.0267374441027641, 0.026807326823473, 0.0268773157149553, 0.0269473511725664, 0.0270175375044346, 0.0270878002047539, 0.0271582417190075, 0.027228806167841, 0.0272994749248028, 0.0273702684789896, 0.0274411626160145, 0.0275121089071035, 0.0275832265615463, 0.0276545025408268, 0.0277258008718491, 0.0277972724288702, 0.0278688259422779, 0.0279405508190393, 0.028012353926897, 0.0280842576175928, 0.0281563866883516, 0.0282285455614328, 0.0283007752150297, 0.0283731836825609, 0.028445640578866, 0.0285182762891054, 0.028591014444828, 0.0286638513207436, 0.028736837208271, 0.0288099274039268, 0.0288830921053886, 0.0289564318954945, 0.0290299262851477, 0.0291034188121557, 0.029177088290453, 0.0292508583515882, 0.0293247830122709, 0.0293988045305014, 0.029472878202796, 0.0295471269637346, 0.0296215023845434, 0.0296959280967712, 0.0297715254127979, 0.0298465583473444, 0.029921792447567, 0.0299971010535955, 0.0300724618136883, 0.0301479995250702, 0.030223660171032, 0.0302993506193161, 0.0303752385079861, 0.0304511543363333, 0.0305272433906794, 0.0306034628301859, 0.0306797306984663, 0.0307561494410038, 0.0308326724916697, 0.0309092681854963, 0.0309860408306122, 0.0310629401355982, 0.0311398394405842, 0.0312169659882784, 0.0312940925359726, 0.0313713923096657, 0.0314488485455513, 0.0315263532102108, 0.0316040068864822, 0.0316817127168179, 0.0317595489323139, 0.0318375304341316, 0.0319155640900135, 0.0319937765598297, 0.0320720858871937, 0.0321504510939121, 0.0322289653122425, 0.032307680696249, 0.0323863439261913, 0.0324651896953583, 0.0325441285967827, 0.0326232239603996, 0.0327024459838867, 0.0327817164361477, 0.0328611135482788, 0.0329406335949898, 0.0330202579498291, 0.0331000089645386, 0.0331798568367958, 0.0332598350942135, 0.033339861780405, 0.0334200412034988, 0.0335003472864628, 0.0335807763040066, 0.0336612612009048, 0.0337418913841248, 0.033822625875473, 0.0339034833014011, 0.0339844711124897, 0.0340655334293842, 0.0341467186808586, 0.0342280082404613, 0.0343093760311604, 0.0343909412622452, 0.0344725847244263, 0.0345543026924133, 0.0346361175179482, 0.0347180925309658, 0.0348001606762409, 0.0348823852837086, 0.0349646545946598, 0.0350470319390297, 0.0351295545697212, 0.0352121815085411, 0.0352949351072311, 0.0353777892887592, 0.0354607664048672, 0.0355438217520714, 0.0356269776821136, 0.0357103124260902, 0.0357937179505825, 0.035877201706171, 0.0359608381986618, 0.0360445231199265, 0.0361284129321575, 0.0362123735249043, 0.0362964384257793, 0.0363806039094925, 0.0364649221301079, 0.0365493111312389, 0.0366338305175304, 0.0367184989154339, 0.0368031673133373, 0.0368880406022072, 0.0369729846715927, 0.0370580889284611, 0.0371432863175869, 0.0372285358607769, 0.0373139381408691, 0.0373994633555412, 0.0374850668013096, 0.037570845335722, 0.0376566536724567, 0.0377425812184811, 0.0378184206783772, 0.0379052869975567, 0.0379922799766064, 0.0380793698132038, 0.0381664372980595, 0.0382536798715591, 0.0383410267531872, 0.038428395986557, 0.0385159142315388, 0.038603488355875, 0.0386910326778889, 0.0387787781655788, 0.0388666242361069, 0.0389545299112797, 0.0390425287187099, 0.039130549877882, 0.0392187312245369, 0.0393069535493851, 0.0393952839076519, 0.0394837446510792, 0.0395721681416035, 0.0396607518196106, 0.0397494062781334, 0.0398382171988487, 0.0399270169436932, 0.0400159247219563, 0.0401048846542835, 0.0401939675211906, 0.0402831584215164, 0.0403723977506161, 0.0404617302119732, 0.0405511185526848, 0.0406406112015247, 0.0407302193343639, 0.0408198907971382, 0.04090965539217, 0.0409994460642338, 0.0410893857479095, 0.0411794073879719, 0.0412695035338402, 0.0413597002625465, 0.0414499118924141, 0.0415402427315712, 0.041630707681179, 0.0417211800813675, 0.0418117828667164, 0.0419025085866451, 0.0419932045042515, 0.0420840308070183, 0.0421750359237194, 0.0422660112380981, 0.0423571355640888, 0.0424482971429825, 0.0425395704805851, 0.0426309034228325, 0.0427223369479179, 0.0428138971328735, 0.0429054498672485, 0.042997132986784, 0.0430889204144478, 0.0431807786226273, 0.0432727672159672, 0.0433647781610489, 0.0434568636119366, 0.0435490757226944, 0.0436413437128067, 0.0437337346374989, 0.0438261479139328, 0.0439186654984951, 0.0440112538635731, 0.0441039986908436, 0.0441967658698559, 0.0442896857857704, 0.0443825796246529, 0.0444756262004375, 0.0445687249302864, 0.0446619726717472, 0.044755220413208, 0.044848594814539, 0.0449420399963856, 0.0450355671346188, 0.0451292172074318, 0.0452229455113411, 0.0453167483210564, 0.045410580933094, 0.045504555106163, 0.0455985888838768, 0.045692715793848, 0.0457869507372379, 0.0458812043070793, 0.0459755659103394, 0.0460700206458569, 0.0461646318435669, 0.0462592430412769, 0.046353954821825, 0.046448715031147, 0.0465436279773712, 0.0466386191546917, 0.0467336550354958, 0.0468288213014603, 0.0469327829778194, 0.0470282658934593, 0.0471237823367119, 0.0472193397581577, 0.0473149865865707, 0.0474105998873711, 0.0475062765181065, 0.047602005302906, 0.0476977489888668, 0.0477935485541821, 0.0478893555700779, 0.0479852668941021, 0.0480811484158039, 0.0481771118938923, 0.0482730865478516, 0.0483691208064556, 0.0484651625156403, 0.0485612601041794, 0.04865737631917, 0.0487535744905472, 0.0488497726619244, 0.0489460229873657, 0.0490423142910004, 0.0491386502981186, 0.0492349900305271, 0.0493313930928707, 0.0494278557598591, 0.0495243221521378, 0.0496208071708679, 0.0497173592448235, 0.0498139783740044, 0.049910593777895, 0.0500072464346886, 0.0501039326190948, 0.050200704485178, 0.0502974689006805, 0.0503942929208279, 0.0504911690950394, 0.0505880452692509, 0.0506849847733974, 0.050781924277544, 0.0508789457380772, 0.0509759895503521, 0.0510730557143688, 0.0511701665818691, 0.0512673519551754, 0.0513645336031914, 0.0514617785811424, 0.0515590235590935, 0.0516563728451729, 0.0517536997795105, 0.0518510825932026, 0.0519485287368298, 0.0520459897816181, 0.0521434880793095, 0.0522410273551941, 0.0523385964334011, 0.0524362288415432, 0.052533857524395, 0.0526315234601498, 0.0527292862534523, 0.0528270527720451, 0.0529248416423798, 0.0530226565897465, 0.0531205460429192, 0.0532184839248657, 0.0533164404332638, 0.0534144155681133, 0.0535124540328979, 0.0536105260252953, 0.053708627820015, 0.053806759417057, 0.0539049245417118, 0.0540031678974628, 0.0541014149785042, 0.0541996769607067, 0.0542980246245861, 0.0543964207172394, 0.0544948130846024, 0.0545932576060295, 0.0546917766332626, 0.0547902993857861, 0.0548888444900513, 0.0549874566495419, 0.0550860874354839, 0.0551847591996193, 0.0552834793925285, 0.055382214486599, 0.0554809868335724, 0.0555798374116421, 0.0556786991655827, 0.0557776093482971, 0.0558765605092049, 0.0559755116701126, 0.0560745447874069, 0.0561735965311527, 0.0562727004289627, 0.0563718117773533, 0.0564709901809692, 0.0565702021121979, 0.0566705800592899, 0.0567690618336201, 0.0568675585091114, 0.0569660738110542, 0.0570645704865456, 0.0571630820631981, 0.0572615750133991, 0.0573600791394711, 0.0574585869908333, 0.0575571097433567, 0.057655606418848, 0.0577541254460812, 0.0578526444733143, 0.0579511672258377, 0.0580496825277805, 0.0581482090055943, 0.0582467392086983, 0.0583452731370926, 0.0584437921643257, 0.05854232609272, 0.0586408600211143, 0.0587393939495087, 0.0588379353284836, 0.0589364692568779, 0.0590350031852722, 0.0591335631906986, 0.0592321082949638, 0.0593306422233582, 0.0594292022287846, 0.0595277585089207, 0.0596263110637665, 0.0597248747944832, 0.0598234161734581, 0.0599219873547554, 0.0600205473601818, 0.0601191185414791, 0.0602176785469055, 0.0603162460029125, 0.0604148283600807, 0.0605133883655071, 0.0606119856238365, 0.0607105456292629, 0.0608091317117214, 0.060907706618309, 0.0610062964260578, 0.0611048750579357, 0.0612034574151039, 0.0613020732998848, 0.0614006519317627, 0.0614992454648018, 0.0615978501737118, 0.0616964437067509, 0.0617950111627579, 0.0618936084210873, 0.0619922280311584, 0.0620908252894878, 0.0621894374489784, 0.0622880421578884, 0.0623866617679596, 0.0624852702021599, 0.0625839084386826, 0.0626825019717216, 0.0627811327576637, 0.0628797709941864, 0.0629783943295479, 0.0630770027637482, 0.0631756335496902, 0.0632742792367935, 0.0633729100227356, 0.0634715631604195, 0.0635701790452003, 0.0636688321828842, 0.0637674778699875, 0.0638661235570908, 0.0639647543430328, 0.0640634000301361, 0.0641620606184006, 0.064260721206665, 0.0643593668937683, 0.0644580274820328, 0.0645566880702972, 0.0646553635597229, 0.0647540166974068, 0.0648526698350906, 0.0649513453245163, 0.0650500133633614, 0.0651487037539482, 0.0652473643422127, 0.0653460323810577, 0.065444715321064, 0.0655433982610703, 0.0656420812010765, 0.0657407715916634, 0.0658394545316696, 0.0659381374716759, 0.0660368353128433, 0.0661355182528496, 0.066234216094017, 0.0663329213857651, 0.0664316266775131, 0.0665211454033852, 0.0666186362504959, 0.0667161494493484, 0.066813662648201, 0.0669111683964729, 0.0670086964964867, 0.0671062245965004, 0.0672037452459335, 0.0673012807965279, 0.0673988163471222, 0.0674963817000389, 0.0675939247012138, 0.0676914900541306, 0.0677890703082085, 0.0678866282105446, 0.0679841861128807, 0.0680817738175392, 0.0681793764233589, 0.0682769641280174, 0.0683745443820953, 0.068472146987915, 0.0685697719454765, 0.0686673745512962, 0.0687649995088577, 0.0688626393675804, 0.0689602494239807, 0.069057896733284, 0.0691555365920067, 0.06925318390131, 0.0693508461117744, 0.0694485008716583, 0.0695461556315422, 0.0696438103914261, 0.0697414875030518, 0.0698391571640968, 0.0699368491768837, 0.07003453373909, 0.070132240653038, 0.0702299401164055, 0.0703276619315147, 0.0704253762960434, 0.0705230906605721, 0.0706208124756813, 0.0707185417413712, 0.0708162635564804, 0.0709140300750732, 0.0710117742419243, 0.0711095184087753, 0.0712072849273682, 0.0713050439953804, 0.0714028105139732, 0.0715005993843079, 0.0715983808040619, 0.0716961547732353, 0.0717939585447311, 0.0718917474150658, 0.0719895511865616, 0.0720873698592186, 0.0721851736307144, 0.0722829923033714, 0.0723808333277702, 0.0724786520004272, 0.0725764855742455, 0.0726743265986443, 0.0727721825242043, 0.0728700384497643, 0.0729678794741631, 0.0730657428503036, 0.0731636136770248, 0.0732614919543266, 0.073359377682209, 0.0734572634100914, 0.0735551491379738, 0.0736530423164368, 0.0737509354948997, 0.0738488510251045, 0.0739467740058899, 0.0740446895360947, 0.0741426199674606, 0.074240542948246, 0.074338473379612, 0.0744364187121391, 0.0745343714952469, 0.074632316827774, 0.0747302770614624, 0.074828252196312, 0.0749262049794197, 0.0750241875648499, 0.0751221626996994, 0.0752201601862907, 0.0753181502223015, 0.0754161477088928, 0.0755141451954842, 0.0756121501326561, 0.0757101625204086, 0.075808197259903, 0.0759062170982361, 0.0760042518377304, 0.0761022716760635, 0.0762003138661385, 0.076297827064991, 0.0763949379324913, 0.0764921233057976, 0.0765893161296844, 0.0766865834593773, 0.0767839103937149, 0.0768812671303749, 0.0769787505269051, 0.0770762115716934, 0.0771737843751907, 0.0772713273763657, 0.0773689895868301, 0.0774666666984558, 0.0775644183158875, 0.0776621848344803, 0.0777600854635239, 0.0778579711914062, 0.0779559388756752, 0.0780539661645889, 0.0781520530581474, 0.0782501623034477, 0.0783483013510704, 0.0784465372562408, 0.0785448327660561, 0.0786431580781937, 0.0787415355443954, 0.0788400024175644, 0.0789384692907333, 0.0790370106697083, 0.0791356042027473, 0.0792342647910118, 0.0793329700827599, 0.0794316902756691, 0.0795305296778679, 0.0796293690800667, 0.0797282978892326, 0.079827256500721, 0.0799262821674347, 0.0800253674387932, 0.0801244527101517, 0.0802236720919609, 0.0803228691220284, 0.0804221853613853, 0.0805214941501617, 0.0806209146976471, 0.0807203501462936, 0.0808198153972626, 0.0809193849563599, 0.0810189768671989, 0.0811186581850052, 0.0812183618545532, 0.0813181102275848, 0.0814179256558418, 0.0815178081393242, 0.0816177055239677, 0.0817176848649979, 0.0818177163600922, 0.0819177851080894, 0.0820179209113121, 0.0821180939674377, 0.0822183564305305, 0.0823186263442039, 0.0824190005660057, 0.0825193896889687, 0.0826197788119316, 0.0827203094959259, 0.0828208550810814, 0.082921490073204, 0.0830221399664879, 0.0831228792667389, 0.0832236334681511, 0.0833244472742081, 0.0834252908825874, 0.083526223897934, 0.0836272165179253, 0.0837282314896584, 0.0838293507695198, 0.0839304402470589, 0.0840316638350487, 0.0841328874230385, 0.0842341855168343, 0.0843355506658554, 0.0844369158148766, 0.0845383554697037, 0.0846398547291756, 0.0847414657473564, 0.0848430395126343, 0.0849447101354599, 0.0850463956594467, 0.0851482003927231, 0.08525001257658, 0.0853519141674042, 0.0854538157582283, 0.0855558291077614, 0.0856578648090363, 0.0857599154114723, 0.0858620852231979, 0.0859642773866653, 0.0860665142536163, 0.0861688107252121, 0.0862720534205437, 0.086374543607235, 0.0864771157503128, 0.0865798518061638, 0.0866827368736267, 0.0867857038974762, 0.0868887677788734, 0.086991973221302, 0.0870953127741814, 0.0871987566351891, 0.0873022675514221, 0.0874059945344925, 0.08750981092453, 0.0876137241721153, 0.0877177566289902, 0.087821900844574, 0.0879262015223503, 0.0880305916070938, 0.0881351381540298, 0.0882396921515465, 0.0883445516228676, 0.0884494036436081, 0.0885543972253799, 0.088659480214119, 0.0887647420167923, 0.0888701230287552, 0.0889755412936211, 0.0890811681747437, 0.0891868993639946, 0.0892927721142769, 0.0893986746668816, 0.0895047932863235, 0.0896109789609909, 0.0897172763943672, 0.0898236855864525, 0.0899302586913109, 0.090036928653717, 0.0901437774300575, 0.0902506485581398, 0.0903576761484146, 0.0904648676514626, 0.0905721485614777, 0.0906794741749763, 0.0907870233058929, 0.0908946543931961, 0.0910024121403694, 0.0911102667450905, 0.0912182927131653, 0.0913264006376266, 0.0914345905184746, 0.0915429443120956, 0.0916514322161674, 0.09176005423069, 0.0918687134981155, 0.0919775292277336, 0.092086486518383, 0.0921955853700638, 0.0923047736287117, 0.0924140438437462, 0.092523492872715, 0.092633031308651, 0.0927427262067795, 0.0928524807095528, 0.0929623991250992, 0.0930724292993546, 0.0931825786828995, 0.093292772769928, 0.0934032425284386, 0.0935137420892715, 0.0936243459582329, 0.0937350764870644, 0.0938459634780884, 0.0939569398760796, 0.0940680354833603, 0.0941792652010918, 0.0942905992269516, 0.0944020971655846, 0.0945136323571205, 0.0946253463625908, 0.0947371572256088, 0.0948490798473358, 0.0949611216783524, 0.0950733423233032, 0.0951856821775436, 0.0952980369329453, 0.0954105779528618, 0.0955232530832291, 0.0956360325217247, 0.0957489162683487, 0.0958619266748428, 0.0959750935435295, 0.0960883125662804, 0.0962017029523849, 0.0963152050971985, 0.0964287966489792, 0.0965425595641136, 0.0966564044356346, 0.0967703461647034, 0.0968844816088676, 0.0969986915588379, 0.0971128568053246, 0.0972286090254784, 0.0973445102572441, 0.0974605977535248, 0.0975768864154816, 0.0976931899785995, 0.0978097915649414, 0.0979264825582504, 0.098043367266655, 0.098160408437252, 0.0982775986194611, 0.0983949899673462, 0.0985124260187149, 0.0986302047967911, 0.0987480506300926, 0.0988660529255867, 0.0989841967821121, 0.0991024896502495, 0.0992210060358047, 0.0993396788835526, 0.0994584336876869, 0.0995774418115616, 0.0996965542435646, 0.0998158380389214, 0.099935345351696, 0.100054897367954, 0.100174710154533, 0.10029461234808, 0.100414723157883, 0.100535020232201, 0.100655414164066, 0.100775979459286, 0.100896701216698, 0.101017653942108, 0.101138725876808, 0.101259931921959, 0.10138126462698, 0.101502820849419, 0.101624548435211, 0.101746432483196, 0.101868465542793, 0.101990595459938, 0.102112986147404, 0.102235481142998, 0.102358162403107, 0.102481029927731, 0.102604024112225, 0.102727144956589, 0.102850437164307, 0.102973930537701, 0.10309761017561, 0.103221334517002, 0.103345364332199, 0.10346944630146, 0.103593774139881, 0.10371819883585, 0.103842794895172, 0.103967599570751, 0.104092508554459, 0.104217566549778, 0.104342855513096, 0.104468271136284, 0.10459378361702, 0.104719519615173, 0.104845456779003, 0.104971528053284, 0.105097696185112, 0.105224087834358, 0.105350643396378, 0.105477347970009, 0.10560417920351, 0.105731196701527, 0.105858385562897, 0.105985745787621, 0.106113225221634, 0.106240831315517, 0.106368698179722, 0.106496691703796, 0.106624878942966, 0.10675311088562, 0.106881588697433, 0.107010275125504, 0.10713904350996, 0.107267968356609, 0.107397094368935, 0.107526376843452, 0.107655875384808, 0.107785373926163, 0.107915177941322, 0.10804508626461, 0.10817514359951, 0.108305431902409, 0.108435809612274, 0.108566403388977, 0.108697041869164, 0.108827948570251, 0.108959048986435, 0.109090238809586, 0.109221585094929, 0.109353125095367, 0.10948833823204, 0.109621949493885, 0.109755627810955, 0.109889522194862, 0.11002354323864, 0.110157713294029, 0.110292062163353, 0.110426478087902, 0.110561057925224, 0.110695779323578, 0.110830657184124, 0.110965713858604, 0.11110083758831, 0.111236169934273, 0.111371569335461, 0.111507125198841, 0.111642867326736, 0.111778751015663, 0.11191476136446, 0.112050913274288, 0.112187191843987, 0.112323626875877, 0.112460248172283, 0.112596914172173, 0.11273380368948, 0.112870745360851, 0.113007918000221, 0.113145247101784, 0.113282643258572, 0.113420248031616, 0.113557897508144, 0.113695807754993, 0.113833799958229, 0.113971911370754, 0.114110216498375, 0.114248625934124, 0.114387206733227, 0.1145259141922, 0.114664703607559, 0.114803746342659, 0.114942833781242, 0.115082129836082, 0.115221567451954, 0.115361116826534, 0.115500837564468, 0.115640603005886, 0.115780644118786, 0.115920774638653, 0.116061054170132, 0.116201423108578, 0.116341955959797, 0.116482682526112, 0.116623535752296, 0.116764470934868, 0.116905629634857, 0.11704683303833, 0.11718824505806, 0.117329783737659, 0.117471478879452, 0.117613315582275, 0.117755249142647, 0.117897339165211, 0.118039637804031, 0.118182055652142, 0.1183245703578, 0.118467271327972, 0.118610076606274, 0.118753023445606, 0.118896141648293, 0.119039371609688, 0.119182802736759, 0.119326278567314, 0.119469992816448, 0.119613848626614, 0.119757756590843, 0.119901828467846, 0.120046079158783, 0.120190463960171, 0.12033499777317, 0.120479665696621, 0.120624490082264, 0.120769426226616, 0.120914474129677, 0.12105979770422, 0.121205113828182, 0.121350653469563, 0.121496260166168, 0.121642082929611, 0.121788062155247, 0.12193413823843, 0.122080370783806, 0.122226677834988, 0.122373230755329, 0.122519910335541, 0.122666642069817, 0.122813627123833, 0.122960694134235, 0.123107887804508, 0.123255245387554, 0.123402759432793, 0.123556204140186, 0.123705297708511, 0.123854443430901, 0.124003648757935, 0.12415287643671, 0.124302215874195, 0.124451585114002, 0.124601043760777, 0.124750539660454, 0.124900117516518, 0.125049710273743, 0.125199392437935, 0.125349119305611, 0.125498935580254, 0.12564879655838, 0.125798732042313, 0.125948697328568, 0.12609875202179, 0.126248866319656, 0.126398980617523, 0.126549243927002, 0.12669949233532, 0.126849859952927, 0.127000242471695, 0.127150684595108, 0.127301245927811, 0.127451792359352, 0.127602428197861, 0.127753138542175, 0.127903908491135, 0.128054723143578, 0.128205627202988, 0.128356575965881, 0.128507524728775, 0.128658607602119, 0.128809720277786, 0.128960907459259, 0.129112124443054, 0.129263430833817, 0.129414796829224, 0.129566207528114, 0.129717692732811, 0.129869222640991, 0.1300208568573, 0.130172491073608, 0.130324214696884, 0.130476012825966, 0.130627855658531, 0.130779728293419, 0.130931690335274, 0.131083711981773, 0.131235808134079, 0.131387919187546, 0.131540134549141, 0.13169239461422, 0.131844684481621, 0.131997108459473, 0.132149532437325, 0.132302045822144, 0.132454603910446, 0.132607221603394, 0.132759913802147, 0.132912650704384, 0.133065417408943, 0.133218288421631, 0.133371219038963, 0.133524194359779, 0.133677244186401, 0.133830368518829, 0.133983507752419, 0.134136691689491, 0.134290009737015, 0.134443312883377, 0.134596735239029, 0.134750187397003, 0.134903728961945, 0.135057300329208, 0.135210901498795, 0.135364606976509, 0.135518357157707, 0.135672181844711, 0.135826051235199, 0.135979995131493, 0.136134013533592, 0.136288061738014, 0.136442184448242, 0.136596381664276, 0.13675057888031, 0.136904910206795, 0.137059256434441, 0.137213692069054, 0.13736817240715, 0.13752269744873, 0.137677296996117, 0.137831956148148, 0.137986704707146, 0.138141483068466, 0.138296291232109, 0.13845120370388, 0.138606145977974, 0.138756468892097, 0.13891176879406, 0.139067023992538, 0.139222234487534, 0.139377355575562, 0.139532446861267, 0.139687463641167, 0.139842435717583, 0.139997363090515, 0.140152215957642, 0.140307024121284, 0.140461757779121, 0.140616446733475, 0.140771076083183, 0.140925645828247, 0.141080170869827, 0.141234636306763, 0.141389027237892, 0.141543373465538, 0.141697660088539, 0.141851916909218, 0.142006084322929, 0.142160221934319, 0.142314285039902, 0.142468318343163, 0.142622247338295, 0.142776161432266, 0.142930001020432, 0.143083781003952, 0.143237516283989, 0.143391191959381, 0.143544808030128, 0.143698379397392, 0.14385187625885, 0.144005343317986, 0.144158720970154, 0.144312053918839, 0.14446534216404, 0.144618570804596, 0.144771754741669, 0.144924849271774, 0.145077899098396, 0.145230919122696, 0.14538386464119, 0.145536735653877, 0.14568954706192, 0.145842328667641, 0.145995065569878, 0.146147713065147, 0.146300315856934, 0.146452873945236, 0.146605357527733, 0.146757811307907, 0.146910160779953, 0.14706252515316, 0.147214770317078, 0.147366985678673, 0.147519126534462, 0.147671222686768, 0.147823259234428, 0.147975251078606, 0.148127183318138, 0.148279055953026, 0.148430854082108, 0.148582622408867, 0.14873431622982, 0.148885980248451, 0.149037554860115, 0.149189084768295, 0.149340584874153, 0.149492010474205, 0.149643376469612, 0.149794697761536, 0.149945929646492, 0.150097116827965, 0.150248289108276, 0.15039935708046, 0.15055039525032, 0.150701358914375, 0.150852292776108, 0.151003122329712, 0.151153951883316, 0.151304677128792, 0.151455357670784, 0.151606008410454, 0.151756599545479, 0.151907116174698, 0.152057588100433, 0.152207970619202, 0.152358338236809, 0.15250863134861, 0.152658879756927, 0.152809083461761, 0.152959167957306, 0.153109267354012, 0.153259262442589, 0.153409242630005, 0.153559118509293, 0.153708964586258, 0.153858751058578, 0.154008015990257, 0.154156789183617, 0.154305383563042, 0.154453843832016, 0.154602125287056, 0.154750227928162, 0.154898196458817, 0.155045971274376, 0.155193611979485, 0.155341058969498, 0.155488342046738, 0.155635505914688, 0.155782461166382, 0.155929282307625, 0.156075924634933, 0.156222403049469, 0.15636870265007, 0.156514868140221, 0.156660839915276, 0.156806692481041, 0.156952366232872, 0.15709787607193, 0.157243207097054, 0.157388359308243, 0.157533392310143, 0.157678231596947, 0.157822892069817, 0.157967448234558, 0.158111795783043, 0.158255994319916, 0.158400014042854, 0.15854386985302, 0.158687561750412, 0.158831119537354, 0.158974513411522, 0.159117713570595, 0.159260764718056, 0.159403651952744, 0.159546345472336, 0.159688889980316, 0.159831285476685, 0.159973531961441, 0.160115599632263, 0.160257488489151, 0.160399243235588, 0.160540819168091, 0.160682201385498, 0.160823479294777, 0.160964578390121, 0.16110548377037, 0.161246255040169, 0.161386862397194, 0.161527290940285, 0.161667570471764, 0.161807641386986, 0.16194760799408, 0.162087365984917, 0.162226974964142, 0.162366449832916, 0.162505730986595, 0.162644848227501, 0.162783831357956, 0.162922620773315, 0.163061261177063, 0.163199707865715, 0.163338020443916, 0.163476169109344, 0.163614153862, 0.163751974701881, 0.163889616727829, 0.164027094841003, 0.164164438843727, 0.164301618933678, 0.164438605308533, 0.164575427770615, 0.164712116122246, 0.164848625659943, 0.164984956383705, 0.165121138095856, 0.165257140994072, 0.165393024682999, 0.16552871465683, 0.165664196014404, 0.165799587965012, 0.165934771299362, 0.166069835424423, 0.166204690933228, 0.166339427232742, 0.166473969817162, 0.166608333587646, 0.166742563247681, 0.166876614093781, 0.167010501027107, 0.167144238948822, 0.167277827858925, 0.167411208152771, 0.167544439435005, 0.167677536606789, 0.167810454964638, 0.167943179607391, 0.168077319860458, 0.168208122253418, 0.168338716030121, 0.168469101190567, 0.168599292635918, 0.168729245662689, 0.168858930468559, 0.168988451361656, 0.169117718935013, 0.169246733188629, 0.169375568628311, 0.169504165649414, 0.169632539153099, 0.169760704040527, 0.169888615608215, 0.170016318559647, 0.17014379799366, 0.170271039009094, 0.170398086309433, 0.17052486538887, 0.17065142095089, 0.170777767896652, 0.170903891324997, 0.171029806137085, 0.171155497431755, 0.171280935406685, 0.171406164765358, 0.171531185507774, 0.171655938029289, 0.171780526638031, 0.171904876828194, 0.172028988599777, 0.172152861952782, 0.172276511788368, 0.172399953007698, 0.17252317070961, 0.172646149992943, 0.17276893556118, 0.172891497612, 0.173013776540756, 0.173135846853256, 0.173257753252983, 0.173379391431808, 0.173500806093216, 0.173622012138367, 0.1737429946661, 0.173863738775253, 0.173984244465828, 0.174104556441307, 0.174224629998207, 0.174344450235367, 0.174464076757431, 0.1745835095644, 0.174702703952789, 0.174821630120277, 0.174940377473831, 0.175058871507645, 0.175177156925201, 0.175295203924179, 0.175412997603416, 0.175530642271042, 0.175648018717766, 0.175765186548233, 0.175882145762444, 0.175998851656914, 0.176115334033966, 0.176231563091278, 0.176347628235817, 0.176463440060616, 0.176579028367996, 0.176694393157959, 0.176809549331665, 0.176924452185631, 0.177039161324501, 0.177153617143631, 0.177267879247665, 0.177381902933121, 0.177495688199997, 0.177609264850616, 0.177722603082657, 0.177835732698441, 0.177948608994484, 0.178061291575432, 0.178173750638962, 0.178285986185074, 0.178397998213768, 0.178509756922722, 0.178621307015419, 0.178732648491859, 0.178843766450882, 0.178954645991325, 0.179065316915512, 0.179175704717636, 0.179285928606987, 0.179395899176598, 0.179505676031113, 0.179615214467049, 0.179724529385567, 0.179833620786667, 0.179942473769188, 0.180048942565918, 0.180155664682388, 0.180262088775635, 0.180368334054947, 0.180474370718002, 0.180580168962479, 0.180685758590698, 0.180791109800339, 0.180896237492561, 0.181001156568527, 0.181105881929398, 0.181210353970528, 0.18131460249424, 0.181418612599373, 0.181522458791733, 0.181626081466675, 0.181729465723038, 0.181832641363144, 0.18193556368351, 0.18203829228878, 0.182140782475471, 0.182243078947067, 0.182345137000084, 0.182447001338005, 0.182548627257347, 0.18265001475811, 0.182751223444939, 0.182852178812027, 0.18295294046402, 0.183053448796272, 0.183153763413429, 0.183253854513168, 0.18335372209549, 0.183453366160393, 0.183552801609039, 0.183651998639107, 0.183750987052917, 0.183849781751633, 0.183948323130608, 0.184046655893326, 0.184144735336304, 0.184242621064186, 0.184340313076973, 0.184437781572342, 0.184534996747971, 0.184632018208504, 0.184728816151619, 0.184825405478477, 0.184921726584435, 0.185017853975296, 0.185113772749901, 0.18520949780941, 0.18530498445034, 0.18540021777153, 0.185495227575302, 0.18559005856514, 0.18568466603756, 0.1857790350914, 0.185873210430145, 0.185967147350311, 0.186060845851898, 0.186154365539551, 0.186247631907463, 0.18634070456028, 0.186433523893356, 0.186526134610176, 0.1866185516119, 0.186710745096207, 0.186802685260773, 0.186894446611404, 0.186985954642296, 0.187077254056931, 0.187168344855309, 0.187259212136269, 0.187349855899811, 0.187440276145935, 0.187530472874641, 0.187620475888252, 0.187710225582123, 0.187799766659737, 0.187889114022255, 0.187978193163872, 0.188067093491554, 0.188155740499496, 0.188244178891182, 0.188332423567772, 0.188420444726944, 0.188508212566376, 0.188595801591873, 0.18868313729763, 0.188770264387131, 0.188857182860374, 0.1889438778162, 0.189030349254608, 0.189116582274437, 0.189202606678009, 0.189288452267647, 0.189373999834061, 0.189459383487701, 0.189544528722763, 0.189631566405296, 0.189714506268501, 0.189797312021255, 0.189879953861237, 0.189962461590767, 0.190044835209846, 0.190127044916153, 0.190209120512009, 0.190291047096252, 0.190372839570045, 0.190454497933388, 0.190535977482796, 0.190617337822914, 0.190698578953743, 0.190779641270638, 0.190860584378242, 0.190941378474236, 0.191021993756294, 0.191102519631386, 0.191182851791382, 0.191263064742088, 0.191343143582344, 0.191423073410988, 0.191502839326859, 0.191582500934601, 0.19166199862957, 0.191741362214088, 0.191820561885834, 0.191899627447128, 0.191978558897972, 0.192057326436043, 0.192135944962502, 0.192214474081993, 0.19229282438755, 0.192371025681496, 0.19244909286499, 0.192527040839195, 0.192604809999466, 0.192682445049286, 0.192759931087494, 0.192837283015251, 0.192914485931396, 0.192991554737091, 0.193068474531174, 0.193145260214806, 0.193221881985664, 0.193298369646072, 0.193374708294868, 0.193450927734375, 0.193526983261108, 0.193602904677391, 0.193678691983223, 0.193754315376282, 0.193829789757729, 0.193905144929886, 0.193980351090431, 0.194055393338203, 0.194130331277847, 0.194205075502396, 0.194279730319977, 0.194354191422462, 0.194428518414497, 0.194502726197243, 0.194576784968376, 0.194650694727898, 0.194724470376968, 0.194798097014427, 0.194871589541435, 0.19494491815567, 0.195018112659454, 0.195091173052788, 0.195164084434509, 0.195236846804619, 0.195309475064278, 0.195381939411163, 0.195454269647598, 0.195526480674744, 0.195598527789116, 0.195670440793037, 0.195742204785347, 0.195813834667206, 0.195885300636292, 0.195956632494926, 0.196027815341949, 0.196098864078522, 0.196169778704643, 0.196240544319153, 0.19631116092205, 0.196381628513336, 0.196451976895332, 0.196522146463394, 0.196592211723328, 0.196662098169327, 0.196731850504875, 0.196801468729973, 0.196870937943459, 0.196940273046494, 0.197009459137917, 0.197078511118889, 0.197147399187088, 0.197215586900711, 0.197282463312149, 0.197349384427071, 0.19741627573967, 0.197483196854591, 0.197550117969513, 0.197617039084435, 0.197683960199356, 0.197750926017761, 0.197817891836166, 0.19788484275341, 0.197951823472977, 0.198018804192543, 0.198085784912109, 0.198152765631676, 0.198219776153564, 0.198286771774292, 0.198353782296181, 0.198420807719231, 0.198487848043442, 0.198554888367653, 0.198621913790703, 0.198688983917236, 0.19875605404377, 0.198823094367981, 0.198890179395676, 0.19895726442337, 0.199024364352226, 0.199091464281082, 0.199158564209938, 0.199225679039955, 0.199292808771133, 0.199359923601151, 0.199427053332329, 0.199494212865829, 0.199561342597008, 0.19962851703167, 0.19969567656517, 0.199762865900993, 0.199830040335655, 0.199897229671478, 0.19996440410614, 0.200031608343124, 0.20009882748127, 0.200166046619415, 0.200233280658722, 0.200300514698029, 0.200367763638496, 0.200435027480125, 0.200502261519432, 0.200569525361061, 0.200636804103851, 0.200704097747803, 0.200771391391754, 0.200838685035706, 0.200905993580818, 0.20097328722477, 0.201040625572205, 0.201107949018478, 0.201175287365913, 0.201242610812187, 0.201309964060783, 0.20137731730938, 0.201444700360298, 0.201512068510056, 0.201579451560974, 0.201646819710732, 0.201714217662811, 0.201781615614891, 0.201849058270454, 0.201916456222534, 0.201983883976936, 0.2020513266325, 0.202118754386902, 0.202186211943626, 0.20225365459919, 0.202321112155914, 0.2023885846138, 0.202456071972847, 0.202523559331894, 0.202591061592102, 0.202658548951149, 0.202726051211357, 0.202793583273888, 0.202861100435257, 0.202928647398949, 0.202996179461479, 0.203063726425171, 0.203131288290024, 0.203198850154877, 0.203266426920891, 0.203334003686905, 0.203401580452919, 0.203469187021255, 0.203536778688431, 0.20360441505909, 0.203671991825104, 0.203739643096924, 0.203807279467583, 0.20387490093708, 0.203940093517303, 0.204007774591446, 0.204075634479523, 0.204143702983856, 0.204211935400963, 0.204280391335487, 0.204349055886269, 0.204417899250984, 0.204486981034279, 0.204556241631508, 0.204625710844994, 0.204695329070091, 0.20476521551609, 0.204835280776024, 0.20490550994873, 0.204975977540016, 0.205046638846397, 0.205117493867874, 0.205188527703285, 0.205259799957275, 0.205331280827522, 0.20540289580822, 0.205474764108658, 0.205546826124191, 0.205619052052498, 0.205691516399384, 0.205764174461365, 0.20583701133728, 0.205910056829453, 0.205983325839043, 0.206056773662567, 0.206130430102348, 0.206204295158386, 0.206278324127197, 0.206352561712265, 0.206427022814751, 0.206501677632332, 0.206576511263847, 0.20665155351162, 0.206726804375648, 0.206802263855934, 0.206877887248993, 0.20695373415947, 0.207029804587364, 0.207106024026871, 0.207182466983795, 0.207259118556976, 0.207335978746414, 0.207413002848625, 0.207490250468254, 0.20756770670414, 0.207645326852798, 0.207723170518875, 0.207801222801208, 0.207879483699799, 0.207957893610001, 0.208036556839943, 0.208115383982658, 0.208194389939308, 0.208273649215698, 0.208353072404861, 0.208432719111443, 0.20851257443428, 0.208592593669891, 0.208672821521759, 0.208753287792206, 0.208833903074265, 0.208914756774902, 0.208995774388313, 0.209077000617981, 0.209158450365067, 0.209240064024925, 0.209321916103363, 0.209403961896896, 0.209486171603203, 0.209568589925766, 0.209651231765747, 0.209734082221985, 0.209817081689835, 0.209900319576263, 0.209983766078949, 0.210067361593246, 0.210151225328445, 0.210235238075256, 0.210319474339485, 0.210403889417648, 0.210488542914391, 0.210573375225067, 0.210658386349678, 0.210743606090546, 0.210829019546509, 0.210914671421051, 0.211000472307205, 0.211086496710777, 0.211172729730606, 0.21125915646553, 0.211345791816711, 0.211432620882988, 0.211519613862038, 0.211606845259666, 0.211693748831749, 0.211784467101097, 0.21187549829483, 0.211966931819916, 0.212058663368225, 0.212150707840919, 0.212243124842644, 0.212335884571075, 0.212428957223892, 0.212522342801094, 0.212616086006165, 0.212710201740265, 0.212804615497589, 0.212899386882782, 0.21299447119236, 0.213089898228645, 0.213185667991638, 0.213281750679016, 0.213378176093102, 0.213474974036217, 0.213572070002556, 0.213669538497925, 0.213767275214195, 0.213865399360657, 0.213963866233826, 0.21406264603138, 0.214161798357964, 0.214261248707771, 0.214361041784286, 0.214461177587509, 0.214561611413956, 0.214662432670593, 0.214763551950455, 0.214865043759346, 0.214966833591461, 0.215068981051445, 0.215171501040459, 0.215274274349213, 0.215377449989319, 0.215480953454971, 0.215584740042686, 0.215688958764076, 0.215793445706367, 0.215898290276527, 0.21600341796875, 0.216108947992325, 0.216214805841446, 0.216320961713791, 0.216427490115166, 0.216534346342087, 0.216641545295715, 0.216749027371407, 0.21685691177845, 0.216965109109879, 0.217073634266853, 0.217182457447052, 0.217291697859764, 0.217401221394539, 0.217511117458344, 0.217621311545372, 0.217731863260269, 0.217842742800713, 0.217953950166702, 0.218065515160561, 0.218177422881126, 0.218289643526077, 0.218402191996574, 0.21851509809494, 0.218628332018852, 0.218741893768311, 0.218855783343315, 0.218970060348511, 0.219084605574608, 0.219199568033218, 0.219314768910408, 0.219430357217789, 0.219546288251877, 0.219662502408028, 0.219779148697853, 0.21989606320858, 0.220013335347176, 0.220130950212479, 0.220248848199844, 0.220367133617401, 0.220485746860504, 0.220604687929153, 0.22072397172451, 0.220843613147736, 0.220963507890701, 0.221083834767342, 0.221204459667206, 0.221325427293777, 0.221446722745895, 0.22156834602356, 0.221690312027931, 0.221812635660172, 0.221935227513313, 0.222058206796646, 0.222181543707848, 0.222305178642273, 0.222433522343636, 0.222562611103058, 0.222692042589188, 0.22282175719738, 0.222951799631119, 0.223082140088081, 0.223212838172913, 0.223343819379807, 0.223475128412247, 0.223606780171394, 0.223738700151443, 0.223870977759361, 0.224003568291664, 0.224136456847191, 0.224269673228264, 0.2244031727314, 0.224537074565887, 0.224671229720116, 0.224805697798729, 0.224940493702888, 0.225075617432594, 0.225211054086685, 0.225346803665161, 0.225482866168022, 0.225619286298752, 0.225755944848061, 0.22589299082756, 0.226030319929123, 0.22616796195507, 0.226305961608887, 0.226444229483604, 0.226582884788513, 0.22672176361084, 0.226861000061035, 0.227000564336777, 0.227140411734581, 0.227280616760254, 0.227421134710312, 0.227561995387077, 0.227703124284744, 0.227844551205635, 0.227986335754395, 0.228128477931023, 0.228270843625069, 0.228413581848145, 0.228556618094444, 0.228700011968613, 0.228843688964844, 0.22898767888546, 0.229132026433945, 0.229276612401009, 0.229421585798264, 0.229566842317581, 0.229712426662445, 0.229858338832855, 0.230004534125328, 0.23015108704567, 0.230297923088074, 0.230445116758347, 0.230592593550682, 0.230740383267403, 0.230888545513153, 0.231036946177483, 0.231185674667358, 0.231334790587425, 0.231484174728394, 0.231633886694908, 0.231783911585808, 0.231934249401093, 0.232084900140762, 0.23223589360714, 0.232387199997902, 0.232538819313049, 0.232690677046776, 0.232842952013016, 0.232995495200157, 0.233148396015167, 0.233301609754562, 0.233455136418343, 0.233608946204185, 0.233763068914413, 0.23391754925251, 0.234072327613831, 0.234227448701859, 0.234382838010788, 0.234538555145264, 0.234694629907608, 0.234851002693176, 0.23500768840313, 0.235164687037468, 0.235322013497353, 0.235479637980461, 0.235637590289116, 0.235795855522156, 0.235954433679581, 0.236113324761391, 0.236272573471069, 0.236432105302811, 0.236591979861259, 0.236752152442932, 0.236915588378906, 0.237080484628677, 0.237245485186577, 0.237410619854927, 0.237575858831406, 0.237741246819496, 0.237906739115715, 0.238072350621223, 0.23823806643486, 0.238403871655464, 0.238569840788841, 0.238735914230347, 0.23890209197998, 0.239068388938904, 0.239234775304794, 0.239401325583458, 0.239567965269089, 0.239734753966331, 0.23990161716938, 0.240068644285202, 0.24023574590683, 0.240402981638908, 0.240570336580276, 0.240737780928612, 0.240905374288559, 0.241073071956635, 0.241240918636322, 0.241408839821815, 0.241576910018921, 0.241745069622993, 0.241913348436356, 0.242081731557846, 0.242250248789787, 0.242418900132179, 0.242587625980377, 0.242756515741348, 0.242925494909286, 0.243094593286514, 0.243263840675354, 0.243433147668839, 0.243602618575096, 0.243772193789482, 0.243941858410835, 0.244111657142639, 0.244281589984894, 0.244451627135277, 0.244621798396111, 0.244792059063911, 0.244962453842163, 0.245132923126221, 0.245303556323051, 0.245474293828011, 0.245645135641098, 0.245816096663475, 0.245987191796303, 0.246158391237259, 0.246329709887505, 0.246501162648201, 0.246672719717026, 0.246844381093979, 0.247016176581383, 0.247188061475754, 0.247360095381737, 0.247532218694687, 0.247704461216927, 0.247876867651939, 0.248049348592758, 0.248221933841705, 0.248394653201103, 0.248567476868629, 0.248740464448929, 0.248913526535034, 0.249086692929268, 0.249260023236275, 0.249433442950249, 0.249606966972351, 0.249780625104904, 0.249954387545586, 0.250128269195557, 0.250302284955978, 0.250476390123367, 0.250650644302368, 0.250824987888336, 0.250999480485916, 0.251174062490463, 0.2513487637043, 0.251523584127426, 0.251698553562164, 0.251873582601547, 0.252048760652542, 0.252224057912827, 0.252399414777756, 0.252574950456619, 0.252750605344772, 0.252926349639893, 0.253102213144302, 0.253278225660324, 0.253454297780991, 0.253630548715591, 0.253806889057159, 0.253981947898865, 0.25415912270546, 0.254336088895798, 0.254512876272202, 0.254689455032349, 0.254865884780884, 0.25504207611084, 0.255218148231506, 0.255393981933594, 0.255569636821747, 0.255745083093643, 0.255920380353928, 0.256095498800278, 0.256270378828049, 0.256445109844208, 0.25661963224411, 0.256794005632401, 0.256968140602112, 0.257142096757889, 0.257315874099731, 0.257489502429962, 0.257662922143936, 0.257836163043976, 0.258009165525436, 0.258181989192963, 0.258354663848877, 0.258527129888535, 0.25869944691658, 0.258871555328369, 0.259043455123901, 0.259215176105499, 0.259386718273163, 0.259558081626892, 0.259729206562042, 0.259900212287903, 0.260070979595184, 0.260241568088531, 0.260412007570267, 0.260582238435745, 0.260752260684967, 0.260922104120255, 0.261091768741608, 0.261261254549026, 0.261430531740189, 0.261599659919739, 0.26176854968071, 0.261937320232391, 0.262105852365494, 0.262274175882339, 0.262442380189896, 0.262610346078873, 0.262778133153915, 0.262945741415024, 0.263113170862198, 0.263280391693115, 0.263447403907776, 0.263614267110825, 0.263780921697617, 0.263947427272797, 0.26411372423172, 0.264279812574387, 0.264445751905441, 0.264611452817917, 0.264777034521103, 0.26494237780571, 0.265107542276382, 0.265272498130798, 0.265437334775925, 0.265601933002472, 0.265766352415085, 0.265930593013763, 0.266094624996185, 0.266258478164673, 0.266422152519226, 0.266585648059845, 0.266748934984207, 0.266912013292313, 0.267074942588806, 0.267237722873688, 0.26740026473999, 0.267562597990036, 0.26772478222847, 0.267886757850647, 0.26804855465889, 0.268210172653198, 0.268371611833572, 0.26853284239769, 0.268693894147873, 0.268854767084122, 0.269015401601791, 0.269175887107849, 0.269336223602295, 0.269496321678162, 0.269656240940094, 0.269815981388092, 0.269975543022156, 0.270134896039963, 0.270294070243835, 0.270453065633774, 0.270611852407455, 0.270769149065018, 0.270923733711243, 0.271077841520309, 0.271231532096863, 0.271384805440903, 0.271537631750107, 0.271690011024475, 0.271841913461685, 0.271993458271027, 0.272144496440887, 0.272295147180557, 0.272445321083069, 0.272595107555389, 0.272744417190552, 0.272893309593201, 0.273041754961014, 0.273189753293991, 0.273337364196777, 0.273484498262405, 0.273631155490875, 0.273777425289154, 0.273923248052597, 0.274068653583527, 0.27421361207962, 0.274358123540878, 0.2745021879673, 0.274645864963531, 0.274789065122604, 0.274931848049164, 0.275074154138565, 0.275216042995453, 0.275357514619827, 0.275498569011688, 0.275639146566391, 0.275779277086258, 0.275919020175934, 0.276058256626129, 0.276197075843811, 0.276335507631302, 0.276473492383957, 0.276611000299454, 0.27674812078476, 0.276884764432907, 0.277020990848541, 0.27715677022934, 0.277292132377625, 0.277427017688751, 0.277561485767365, 0.277695536613464, 0.277829140424728, 0.277962297201157, 0.278095006942749, 0.278227299451828, 0.278359144926071, 0.278490573167801, 0.278621554374695, 0.278752088546753, 0.278882205486298, 0.279011875391006, 0.27914109826088, 0.279269903898239, 0.279398262500763, 0.279526174068451, 0.279653668403625, 0.279780685901642, 0.279907315969467, 0.280033469200134, 0.28015923500061, 0.280284523963928, 0.280409395694733, 0.280533790588379, 0.280657798051834, 0.280781358480453, 0.280904471874237, 0.281027138233185, 0.281149387359619, 0.281271189451218, 0.281392574310303, 0.281513512134552, 0.281634002923965, 0.281754076480865, 0.281873673200607, 0.281992852687836, 0.282111614942551, 0.28222993016243, 0.282347798347473, 0.282465249300003, 0.282582253217697, 0.282698810100555, 0.2828149497509, 0.282930642366409, 0.283045917749405, 0.283160716295242, 0.283275067806244, 0.283389031887054, 0.283502578735352, 0.283615618944168, 0.283728241920471, 0.283840447664261, 0.283952206373215, 0.284061074256897, 0.284167736768723, 0.284273892641068, 0.284379512071609, 0.284484595060349, 0.284589171409607, 0.28469318151474, 0.284796684980392, 0.28489962220192, 0.285002052783966, 0.285103976726532, 0.28520530462265, 0.28530615568161, 0.285406470298767, 0.285506248474121, 0.285605490207672, 0.285704165697098, 0.285802334547043, 0.285899996757507, 0.285997122526169, 0.286093682050705, 0.28618973493576, 0.286285251379013, 0.286380231380463, 0.286474704742432, 0.286568611860275, 0.286661982536316, 0.286754846572876, 0.286847203969955, 0.286938965320587, 0.287030249834061, 0.287120968103409, 0.287211179733276, 0.287300825119019, 0.287389993667603, 0.287478595972061, 0.287566632032394, 0.287654191255569, 0.287741184234619, 0.287827670574188, 0.287913620471954, 0.287999033927917, 0.288083910942078, 0.288168251514435, 0.288252085447311, 0.288335382938385, 0.288418114185333, 0.288500338792801, 0.288582056760788, 0.288663178682327, 0.288743853569031, 0.288823932409286, 0.288903474807739, 0.288982510566711, 0.289061039686203, 0.289139002561569, 0.289216458797455, 0.289293318986893, 0.289369702339172, 0.289445549249649, 0.289520859718323, 0.289595663547516, 0.289669901132584, 0.289743602275848, 0.289816796779633, 0.289889454841614, 0.28996154665947, 0.290033161640167, 0.29010421037674, 0.290174752473831, 0.290244728326797, 0.290314197540283, 0.290383130311966, 0.290451526641846, 0.290519386529922, 0.290586739778519, 0.290653556585312, 0.29071980714798, 0.290785521268845, 0.290850758552551, 0.290915429592133, 0.290979593992233, 0.291043221950531, 0.291106253862381, 0.291168838739395, 0.291230827569962, 0.291292309761047, 0.291353285312653, 0.291413724422455, 0.291473597288132, 0.291532963514328, 0.291591793298721, 0.291650086641312, 0.291707873344421, 0.291765093803406, 0.291821777820587, 0.291877955198288, 0.291933596134186, 0.291988700628281, 0.292043268680573, 0.292096555233002, 0.292148888111115, 0.292200684547424, 0.292251914739609, 0.292302668094635, 0.292352914810181, 0.292402654886246, 0.292451798915863, 0.292500495910645, 0.292548626661301, 0.292596250772476, 0.292643368244171, 0.292689919471741, 0.292736023664474, 0.292781561613083, 0.292826592922211, 0.292871087789536, 0.29291507601738, 0.292958557605743, 0.293001502752304, 0.293043911457062, 0.293085813522339, 0.293127208948135, 0.293168067932129, 0.293208420276642, 0.293248265981674, 0.293287545442581, 0.29332634806633, 0.293364614248276, 0.293402343988419, 0.293439567089081, 0.293476283550262, 0.293512463569641, 0.293548136949539, 0.293583273887634, 0.293617904186249, 0.29365199804306, 0.293685585260391, 0.293718636035919, 0.293751180171967, 0.293783217668533, 0.293814718723297, 0.293845683336258, 0.293876141309738, 0.293906092643738, 0.293935537338257, 0.293964445590973, 0.293992817401886, 0.294020682573318, 0.294048011302948, 0.294074833393097, 0.294101148843765, 0.294126898050308, 0.294152170419693, 0.294176936149597, 0.294201135635376, 0.294224888086319, 0.294248014688492, 0.294270664453506, 0.294292837381363, 0.294314444065094, 0.294335544109344, 0.294356137514114, 0.294376164674759, 0.294395744800568, 0.294414728879929, 0.294433265924454, 0.294451206922531, 0.29446867108345, 0.294485658407211, 0.294502049684525, 0.294517904520035, 0.294533342123032, 0.294548213481903, 0.294562518596649, 0.294576346874237, 0.294589638710022, 0.294602423906326, 0.294614672660828, 0.294626414775848, 0.294637620449066, 0.294648289680481, 0.29465851187706, 0.294668138027191, 0.294677287340164, 0.294685930013657, 0.294694036245346, 0.294701606035233, 0.294708639383316, 0.294715166091919, 0.294721156358719, 0.294726699590683, 0.294731676578522, 0.294736117124557, 0.29474002122879, 0.294743478298187, 0.294746339321136, 0.294748723506927, 0.294750601053238, 0.294751942157745, 0.294751107692719, 0.294748038053513, 0.294744580984116, 0.294740736484528, 0.294736444950104, 0.294731765985489, 0.294726580381393, 0.294721066951752, 0.294715106487274, 0.294708758592606, 0.294701963663101, 0.294694721698761, 0.294687151908875, 0.294679075479507, 0.294670641422272, 0.294661819934845, 0.294652491807938, 0.294642835855484, 0.294632732868195, 0.294622212648392, 0.294611275196075, 0.294599890708923, 0.29458811879158, 0.294575899839401, 0.294563353061676, 0.29455029964447, 0.294536888599396, 0.294523060321808, 0.294508785009384, 0.294494122266769, 0.294479012489319, 0.294463515281677, 0.2944475710392, 0.294431269168854, 0.294414490461349, 0.294397354125977, 0.294379740953445, 0.294361740350723, 0.29434335231781, 0.294324517250061, 0.294305264949799, 0.2942855656147, 0.294265508651733, 0.294245004653931, 0.294224113225937, 0.294202774763107, 0.294181048870087, 0.29415887594223, 0.294136315584183, 0.294113337993622, 0.294089943170547, 0.29406613111496, 0.294041901826859, 0.294017225503922, 0.293992191553116, 0.293966710567474, 0.293940812349319, 0.293914496898651, 0.293887794017792, 0.293860644102097, 0.293833076953888, 0.293805152177811, 0.293776750564575, 0.293747931718826, 0.293718725442886, 0.293689072132111, 0.293659031391144, 0.293628603219986, 0.29359769821167, 0.293566405773163, 0.293534696102142, 0.293502569198608, 0.293470025062561, 0.293437093496323, 0.293403714895248, 0.293369948863983, 0.293335735797882, 0.293301105499268, 0.293266087770462, 0.293230652809143, 0.293194770812988, 0.293158501386642, 0.293121784925461, 0.293084681034088, 0.293047159910202, 0.293009221553802, 0.292970895767212, 0.292932122945786, 0.292892932891846, 0.292853325605392, 0.292813301086426, 0.292772859334946, 0.292732030153275, 0.292690753936768, 0.292649120092392, 0.292607009410858, 0.292564511299133, 0.292521566152573, 0.292478263378143, 0.292434483766556, 0.292388439178467, 0.292340189218521, 0.292291760444641, 0.292243182659149, 0.292194485664368, 0.292145550251007, 0.292096495628357, 0.292047262191772, 0.291997909545898, 0.291948348283768, 0.291898608207703, 0.291848748922348, 0.291798681020737, 0.291748493909836, 0.291698127985001, 0.291647583246231, 0.29159688949585, 0.291546016931534, 0.291494995355606, 0.291443824768066, 0.291392475366592, 0.291340947151184, 0.291289269924164, 0.291237413883209, 0.291185408830643, 0.291133284568787, 0.291080921888351, 0.291028439998627, 0.290975749492645, 0.290922939777374, 0.290869981050491, 0.290816813707352, 0.2907634973526, 0.290710031986237, 0.290656358003616, 0.290602564811707, 0.290548592805862, 0.290494471788406, 0.290440201759338, 0.290385723114014, 0.290331125259399, 0.290276318788528, 0.290221363306046, 0.290166258811951, 0.290110975503922, 0.29005554318428, 0.289999932050705, 0.289944171905518, 0.289888232946396, 0.289832144975662, 0.289775878190994, 0.289719462394714, 0.2896628677845, 0.289606153964996, 0.289549231529236, 0.289492160081863, 0.289434909820557, 0.28937754034996, 0.289319932460785, 0.289262235164642, 0.289204329252243, 0.289146274328232, 0.289088040590286, 0.289029657840729, 0.288971126079559, 0.288912415504456, 0.288853526115417, 0.288794487714767, 0.288735330104828, 0.288675934076309, 0.288616389036179, 0.288556724786758, 0.288496851921082, 0.288436830043793, 0.288376659154892, 0.288316309452057, 0.288255840539932, 0.288195133209229, 0.288134306669235, 0.288073301315308, 0.288012146949768, 0.287950813770294, 0.287889331579208, 0.287827670574188, 0.287765860557556, 0.28770387172699, 0.287641733884811, 0.287579417228699, 0.287516921758652, 0.287454336881638, 0.287391513586044, 0.287328571081161, 0.287265449762344, 0.287202149629593, 0.287138670682907, 0.287075072526932, 0.287011295557022, 0.2869473695755, 0.286883264780045, 0.286819010972977, 0.286756664514542, 0.286695897579193, 0.286635190248489, 0.286574631929398, 0.286514103412628, 0.286453753709793, 0.28639343380928, 0.286333233118057, 0.286273121833801, 0.286213099956512, 0.286153197288513, 0.286093354225159, 0.286033630371094, 0.285973995923996, 0.285914450883865, 0.285854995250702, 0.285795658826828, 0.285736441612244, 0.285677284002304, 0.285618185997009, 0.285559237003326, 0.285500347614288, 0.28544157743454, 0.285382896661758, 0.285324305295944, 0.285265803337097, 0.28520742058754, 0.285149127244949, 0.285090923309326, 0.28503280878067, 0.284974783658981, 0.284916877746582, 0.28485906124115, 0.284801334142685, 0.28474372625351, 0.284686177968979, 0.284628719091415, 0.284571379423141, 0.284514129161835, 0.284456968307495, 0.284399926662445, 0.28434294462204, 0.284286081790924, 0.284229308366776, 0.284172624349594, 0.284116059541702, 0.284059554338455, 0.284003168344498, 0.283946871757507, 0.283890664577484, 0.283834546804428, 0.283778548240662, 0.28372260928154, 0.28366681933403, 0.283611088991165, 0.28355547785759, 0.283499926328659, 0.283444494009018, 0.283389151096344, 0.283333897590637, 0.28327876329422, 0.283223688602448, 0.283168703317642, 0.283113867044449, 0.2830590903759, 0.283004432916641, 0.282949805259705, 0.282895356416702, 0.282840967178345, 0.282786667346954, 0.282732486724854, 0.282678365707397, 0.282624334096909, 0.282570451498032, 0.282516628503799, 0.282462894916534, 0.282409280538559, 0.282355755567551, 0.28230232000351, 0.282248973846436, 0.282195717096329, 0.282142579555511, 0.282089501619339, 0.282036572694778, 0.281983703374863, 0.281930893659592, 0.281878262758255, 0.281825691461563, 0.281773179769516, 0.281720817089081, 0.28166851401329, 0.281616300344467, 0.281564205884933, 0.281512200832367, 0.281460285186768, 0.281408488750458, 0.281356751918793, 0.281305134296417, 0.281253606081009, 0.281202167272568, 0.281152904033661, 0.28110608458519, 0.281059443950653, 0.281012982130051, 0.280966728925705, 0.280920684337616, 0.280874848365784, 0.280829191207886, 0.280783742666245, 0.280738472938538, 0.280693411827087, 0.280648559331894, 0.280603885650635, 0.28055939078331, 0.280515104532242, 0.28047102689743, 0.280427157878876, 0.280383467674255, 0.280339986085892, 0.280296683311462, 0.28025358915329, 0.280210703611374, 0.280167996883392, 0.280125498771667, 0.280083179473877, 0.280041068792343, 0.279999136924744, 0.279957443475723, 0.279915928840637, 0.279874593019485, 0.27983346581459, 0.279792547225952, 0.279751807451248, 0.279711276292801, 0.27967095375061, 0.279630839824677, 0.279590874910355, 0.279551118612289, 0.279511570930481, 0.279472202062607, 0.279433041810989, 0.279394090175629, 0.279355317354202, 0.279316753149033, 0.27927839756012, 0.279240220785141, 0.279202252626419, 0.279164463281631, 0.279126882553101, 0.279089510440826, 0.279052287340164, 0.279015302658081, 0.278978526592255, 0.278941929340363, 0.278905540704727, 0.278869330883026, 0.278833329677582, 0.278797537088394, 0.278761893510818, 0.278726488351822, 0.27869126200676, 0.278656244277954, 0.278621405363083, 0.278586804866791, 0.278552353382111, 0.27851814031601, 0.278484106063843, 0.27845025062561, 0.278416603803635, 0.278383165597916, 0.278349906206131, 0.278316885232925, 0.278284013271332, 0.278251320123672, 0.278218895196915, 0.278186619281769, 0.27815455198288, 0.278122663497925, 0.278091013431549, 0.278059542179108, 0.278028249740601, 0.27799716591835, 0.277966260910034, 0.277935564517975, 0.277905106544495, 0.277874797582626, 0.277844727039337, 0.27781480550766, 0.277785092592239, 0.277755588293076, 0.277726292610168, 0.277697175741196, 0.277668237686157, 0.277639538049698, 0.27761098742485, 0.277582675218582, 0.277554571628571, 0.277526617050171, 0.277498871088028, 0.277471333742142, 0.27744397521019, 0.277416855096817, 0.277389913797379, 0.277363151311874, 0.277336657047272, 0.277310371398926, 0.277284264564514, 0.277258396148682, 0.277232736349106, 0.277207285165787, 0.277182072401047, 0.277157008647919, 0.277132213115692, 0.277107626199722, 0.277083247900009, 0.277059078216553, 0.277035117149353, 0.27701136469841, 0.276987820863724, 0.276964515447617, 0.276941388845444, 0.27691850066185, 0.276895821094513, 0.276873379945755, 0.276851087808609, 0.276829063892365, 0.276807218790054, 0.276785612106323, 0.276764214038849, 0.276743024587631, 0.27672204375267, 0.276701271533966, 0.276680707931519, 0.27666038274765, 0.276640236377716, 0.276620328426361, 0.276600629091263, 0.276581138372421, 0.276561886072159, 0.276542782783508, 0.276523977518082, 0.276505321264267, 0.276486903429031, 0.27646866440773, 0.276450663805008, 0.276432901620865, 0.276415318250656, 0.276397943496704, 0.276380807161331, 0.276363879442215, 0.276347160339355, 0.276330649852753, 0.276314318180084, 0.276298254728317, 0.276282370090485, 0.276266723871231, 0.276251286268234, 0.276236057281494, 0.276221036911011, 0.276206195354462, 0.276191622018814, 0.276177257299423, 0.276163071393967, 0.276149123907089, 0.276135355234146, 0.276121824979782, 0.276108533143997, 0.276095420122147, 0.276082545518875, 0.276069849729538, 0.276057362556458, 0.276045143604279, 0.276033073663712, 0.276021242141724, 0.276009649038315, 0.275998264551163, 0.275987058877945, 0.275976091623306, 0.275965332984924, 0.275954753160477, 0.275944411754608, 0.275934278964996, 0.275924384593964, 0.275914669036865, 0.275905221700668, 0.275895923376083, 0.275886863470078, 0.275878012180328, 0.275869369506836, 0.275860965251923, 0.275852739810944, 0.275844752788544, 0.275836974382401, 0.275829404592514, 0.275822043418884, 0.275814890861511, 0.275807976722717, 0.275801241397858, 0.275794714689255, 0.275788426399231, 0.275783866643906, 0.275781005620956, 0.275778323411942, 0.275775820016861, 0.275773465633392, 0.275771290063858, 0.275769263505936, 0.275767415761948, 0.275765746831894, 0.275764226913452, 0.275762915611267, 0.275761723518372, 0.275760740041733, 0.275759875774384, 0.275759220123291, 0.275758683681488, 0.275758385658264, 0.275758236646652, 0.27575820684433, 0.275758385658264, 0.275758743286133, 0.275759220123291, 0.275759875774384, 0.275760740041733, 0.275761753320694, 0.275762915611267, 0.275764286518097, 0.275765776634216, 0.275767475366592, 0.27576932311058, 0.275771349668503, 0.275773525238037, 0.275775879621506, 0.275778383016586, 0.275781065225601, 0.275783956050873, 0.275786966085434, 0.275790154933929, 0.275793522596359, 0.275797069072723, 0.275800734758377, 0.275804609060287, 0.27580863237381, 0.275812834501266, 0.275817185640335, 0.27582174539566, 0.275826454162598, 0.275831311941147, 0.275836378335953, 0.275841563940048, 0.275846928358078, 0.275852501392365, 0.275858193635941, 0.275864064693451, 0.275870114564896, 0.275876343250275, 0.275882720947266, 0.275889277458191, 0.275895982980728, 0.2759028673172, 0.275909930467606, 0.275917172431946, 0.275924533605576, 0.275932103395462, 0.27593982219696, 0.275947749614716, 0.27595579624176, 0.275964021682739, 0.27597239613533, 0.2759810090065, 0.27598974108696, 0.275998592376709, 0.27600771188736, 0.2760169506073, 0.276026338338852, 0.276035904884338, 0.276045650243759, 0.276055544614792, 0.276065647602081, 0.276075899600983, 0.276086300611496, 0.276096850633621, 0.276107639074326, 0.276118546724319, 0.276129603385925, 0.276140868663788, 0.276152312755585, 0.276163905858994, 0.276175647974014, 0.276187598705292, 0.276199668645859, 0.27621191740036, 0.276224344968796, 0.276236951351166, 0.27624973654747, 0.276262640953064, 0.276275753974915, 0.276289016008377, 0.276302427053452, 0.276316046714783, 0.276331186294556, 0.276347875595093, 0.276364535093307, 0.276381224393845, 0.276397883892059, 0.276414573192596, 0.276431262493134, 0.276447981595993, 0.27646467089653, 0.276481360197067, 0.276498049497604, 0.276514768600464, 0.276531487703323, 0.276548206806183, 0.276564925909042, 0.276581645011902, 0.276598364114761, 0.276615083217621, 0.276631832122803, 0.276648551225662, 0.276665329933167, 0.276682078838348, 0.27669882774353, 0.276715576648712, 0.276732325553894, 0.276749104261398, 0.27676585316658, 0.276782631874084, 0.276799380779266, 0.276816189289093, 0.276832938194275, 0.276849746704102, 0.276866555213928, 0.27688330411911, 0.276900142431259, 0.276916950941086, 0.27693372964859, 0.276950567960739, 0.276967346668243, 0.276984184980392, 0.277000993490219, 0.277017831802368, 0.277034670114517, 0.277051508426666, 0.277068346738815, 0.277085155248642, 0.277101993560791, 0.277118861675262, 0.277135699987411, 0.277152568101883, 0.277169436216354, 0.277186274528503, 0.277203172445297, 0.277220040559769, 0.27723690867424, 0.277253776788712, 0.277270674705505, 0.277287542819977, 0.277304470539093, 0.277321338653564, 0.277338266372681, 0.277355164289474, 0.277372062206268, 0.277388989925385, 0.277405887842178, 0.277422815561295, 0.277439713478088, 0.277456670999527, 0.277473598718643, 0.277490526437759, 0.277507454156876, 0.277524411678314, 0.27754133939743, 0.277558296918869, 0.277575254440308, 0.277592182159424, 0.277609169483185, 0.277626127004623, 0.277643114328384, 0.277660071849823, 0.277677059173584, 0.277694046497345, 0.277711033821106, 0.277728021144867, 0.277745008468628, 0.277762025594711, 0.277779012918472, 0.277796000242233, 0.277813047170639, 0.2778300344944, 0.277847051620483, 0.277864068746567, 0.277881115674973, 0.277898132801056, 0.277915179729462, 0.277932196855545, 0.277949243783951, 0.277966290712357, 0.277983337640762, 0.27800041437149, 0.278015226125717, 0.278027981519699, 0.278040617704391, 0.278053104877472, 0.278065472841263, 0.278077721595764, 0.278089821338654, 0.278101742267609, 0.278113573789597, 0.278125256299973, 0.278136849403381, 0.278148263692856, 0.278159528970718, 0.278170675039291, 0.278181701898575, 0.278192579746246, 0.278203338384628, 0.278213948011398, 0.278224408626556, 0.278234750032425, 0.278244942426682, 0.278255015611649, 0.278264969587326, 0.278274774551392, 0.278284430503845, 0.278293967247009, 0.278303354978561, 0.278312623500824, 0.278321743011475, 0.278330743312836, 0.278339594602585, 0.278348326683044, 0.27835687994957, 0.27836537361145, 0.278373658657074, 0.278381854295731, 0.278389900922775, 0.27839782834053, 0.278405606746674, 0.278413236141205, 0.278420746326447, 0.278428107500076, 0.278435349464417, 0.278442472219467, 0.278449416160583, 0.27845624089241, 0.27846297621727, 0.278469502925873, 0.278475940227509, 0.278482228517532, 0.278488397598267, 0.278494417667389, 0.278500318527222, 0.278506070375443, 0.278511673212051, 0.278517156839371, 0.278522521257401, 0.278527736663818, 0.278532803058624, 0.278537780046463, 0.278542548418045, 0.278547257184982, 0.278551757335663, 0.278556197881699, 0.2785604596138, 0.27856457233429, 0.278568595647812, 0.278572469949722, 0.278576165437698, 0.278579771518707, 0.278583228588104, 0.278586566448212, 0.278589755296707, 0.278592795133591, 0.278595745563507, 0.278598517179489, 0.278601169586182, 0.278603672981262, 0.278606057167053, 0.278608322143555, 0.278610408306122, 0.278612405061722, 0.278614223003387, 0.278615951538086, 0.278617531061172, 0.278618961572647, 0.27862024307251, 0.278621405363083, 0.278622478246689, 0.278623342514038, 0.27862411737442, 0.27862474322319, 0.278625220060349, 0.27862560749054, 0.278625816106796, 0.278625905513763, 0.278625875711441, 0.278625667095184, 0.27862536907196, 0.278624892234802, 0.278622508049011, 0.278618901968002, 0.278615146875381, 0.278611272573471, 0.278607279062271, 0.278603136539459, 0.278598845005035, 0.278594434261322, 0.278589934110641, 0.278585225343704, 0.2785804271698, 0.278575479984283, 0.278570413589478, 0.27856519818306, 0.278559863567352, 0.278554409742355, 0.278548777103424, 0.278543055057526, 0.278537184000015, 0.278531193733215, 0.278525054454803, 0.27851876616478, 0.278512358665466, 0.278505861759186, 0.278499156236649, 0.278492361307144, 0.27848544716835, 0.278478354215622, 0.278471171855927, 0.278463840484619, 0.278456389904022, 0.278448760509491, 0.278441041707993, 0.278433203697205, 0.278425186872482, 0.278417080640793, 0.278408795595169, 0.278400421142578, 0.278391867876053, 0.278383195400238, 0.278374433517456, 0.27836549282074, 0.278356432914734, 0.278347253799438, 0.278337925672531, 0.278328448534012, 0.278318852186203, 0.278309136629105, 0.278299272060394, 0.278289288282394, 0.278279185295105, 0.278268933296204, 0.27825853228569, 0.278248012065887, 0.278237372636795, 0.278226584196091, 0.278215646743774, 0.278204590082169, 0.278193414211273, 0.278182089328766, 0.278170645236969, 0.278159081935883, 0.278147339820862, 0.278135508298874, 0.278123527765274, 0.278111398220062, 0.278099149465561, 0.278086751699448, 0.278074264526367, 0.278061598539352, 0.27804884314537, 0.278035908937454, 0.278022855520248, 0.278009682893753, 0.277996391057968, 0.277982950210571, 0.277969360351562, 0.277955651283264, 0.277941793203354, 0.277927815914154, 0.277913719415665, 0.277899473905563, 0.277885109186172, 0.27787059545517, 0.277855962514877, 0.277841180562973, 0.277826279401779, 0.277811229228973, 0.277796059846878, 0.277780771255493, 0.277765333652496, 0.27774977684021, 0.277734041213989, 0.277718216180801, 0.277702271938324, 0.277686148881912, 0.277669906616211, 0.27765354514122, 0.277637034654617, 0.277620404958725, 0.277604043483734, 0.277587085962296, 0.277570128440857, 0.277553081512451, 0.277535945177078, 0.277518719434738, 0.277501463890076, 0.277484118938446, 0.277466714382172, 0.27744922041893, 0.277431666851044, 0.277413994073868, 0.277396321296692, 0.277378559112549, 0.277360707521439, 0.277342766523361, 0.277324795722961, 0.277306735515594, 0.27728858590126, 0.277270406484604, 0.27725213766098, 0.277233779430389, 0.277215361595154, 0.277196884155273, 0.277178317308426, 0.277159690856934, 0.277141004800797, 0.27712219953537, 0.277103364467621, 0.277084469795227, 0.277065485715866, 0.277046412229538, 0.277027279138565, 0.277008086442947, 0.276988804340363, 0.276969462633133, 0.276950031518936, 0.276930540800095, 0.276910990476608, 0.276891350746155, 0.276871651411057, 0.276851892471313, 0.276832044124603, 0.276812106370926, 0.276792138814926, 0.276772081851959, 0.276751935482025, 0.276731729507446, 0.276711463928223, 0.276691138744354, 0.276670694351196, 0.276650220155716, 0.276629656553268, 0.276609033346176, 0.276588320732117, 0.276567548513412, 0.276546716690063, 0.276525795459747, 0.276504814624786, 0.276483744382858, 0.276462614536285, 0.276441425085068, 0.276420146226883, 0.276398807764053, 0.276377379894257, 0.276355892419815, 0.276334345340729, 0.276312708854675, 0.276291012763977, 0.276269227266312, 0.276247382164001, 0.276225477457047, 0.276203483343124, 0.276181399822235, 0.276159286499023, 0.276137083768845, 0.276114821434021, 0.27609246969223, 0.276070058345795, 0.276047557592392, 0.276024997234344, 0.276002377271652, 0.275979667901993, 0.275956898927689, 0.27593407034874, 0.275911152362823, 0.27588814496994, 0.275865107774734, 0.275841951370239, 0.275818765163422, 0.275795489549637, 0.275772124528885, 0.275748729705811, 0.275725245475769, 0.27570167183876, 0.275678038597107, 0.275654345750809, 0.275630563497543, 0.275606721639633, 0.275582790374756, 0.275558978319168, 0.275534570217133, 0.275510162115097, 0.275485783815384, 0.275461375713348, 0.275436967611313, 0.275412559509277, 0.275388211011887, 0.275363802909851, 0.275339394807816, 0.27531498670578, 0.275290578603745, 0.275266200304031, 0.275241792201996, 0.27521738409996, 0.275193005800247, 0.275168567895889, 0.275144189596176, 0.275119781494141, 0.275095373392105, 0.275070995092392, 0.275046586990356, 0.275022178888321, 0.274997770786285, 0.27497336268425, 0.274948954582214, 0.274924576282501, 0.274900197982788, 0.274875789880753, 0.274851381778717, 0.274826973676682, 0.274802565574646, 0.27477815747261, 0.274753749370575, 0.274729341268539, 0.274704962968826, 0.274680554866791, 0.274656146764755, 0.27463173866272, 0.274607330560684, 0.274582922458649, 0.274558544158936, 0.2745341360569, 0.274509727954865, 0.274485319852829, 0.274460911750793, 0.274436503648758, 0.274412095546722, 0.274387687444687, 0.274363279342651, 0.274338871240616, 0.27431446313858, 0.274290055036545, 0.274265646934509, 0.274241238832474, 0.274216830730438, 0.274192422628403, 0.274168014526367, 0.274143606424332, 0.274119198322296, 0.274094790220261, 0.274070382118225, 0.27404597401619, 0.274021565914154, 0.273997157812119, 0.273972749710083, 0.273948341608047, 0.273923933506012, 0.273899525403976, 0.273875117301941, 0.273850679397583, 0.27382630109787, 0.273801863193512, 0.273777455091476, 0.273753046989441, 0.273728638887405, 0.27370423078537, 0.273679822683334, 0.273655414581299, 0.273631006479263, 0.273606598377228, 0.273582190275192, 0.273557782173157, 0.273533344268799, 0.273508936166763, 0.273484528064728, 0.273460119962692, 0.273435711860657, 0.273411303758621, 0.273386865854263, 0.273362457752228, 0.273338049650192, 0.273313641548157, 0.273289233446121, 0.273264795541763, 0.273240387439728, 0.273215979337692, 0.273191571235657, 0.273167163133621, 0.273142755031586, 0.273119151592255, 0.273096352815628, 0.273073583841324, 0.273050874471664, 0.27302822470665, 0.273005604743958, 0.272983014583588, 0.272960513830185, 0.272938072681427, 0.272915631532669, 0.272893249988556, 0.27287095785141, 0.272848635911942, 0.272826433181763, 0.272804230451584, 0.272782117128372, 0.272760033607483, 0.272738009691238, 0.272716015577316, 0.272694051265717, 0.272672176361084, 0.272650331258774, 0.272628515958786, 0.272606760263443, 0.272585064172745, 0.272563427686691, 0.27254182100296, 0.272520244121552, 0.27249875664711, 0.272477298974991, 0.272455900907516, 0.272434502840042, 0.272413223981857, 0.27239191532135, 0.27237069606781, 0.272349536418915, 0.272328436374664, 0.272307366132736, 0.27228632569313, 0.272265315055847, 0.272244423627853, 0.272223502397537, 0.272202670574188, 0.272181868553162, 0.272161155939102, 0.272140473127365, 0.27211982011795, 0.272099226713181, 0.272078663110733, 0.272058188915253, 0.272037744522095, 0.272017329931259, 0.271996974945068, 0.2719766497612, 0.271956413984299, 0.271936178207397, 0.271916031837463, 0.271895915269852, 0.271875828504562, 0.27185583114624, 0.27183586359024, 0.271815955638885, 0.271796047687531, 0.271776258945465, 0.2717564702034, 0.271736711263657, 0.271717041730881, 0.271697402000427, 0.271677851676941, 0.271658301353455, 0.271638780832291, 0.271619379520416, 0.271599948406219, 0.27158060669899, 0.271561294794083, 0.27154204249382, 0.271522879600525, 0.27150371670723, 0.271484613418579, 0.271465539932251, 0.27144655585289, 0.271427601575851, 0.271408677101135, 0.271389812231064, 0.271371006965637, 0.271352231502533, 0.271333515644073, 0.271314799785614, 0.271296203136444, 0.271277636289597, 0.271259099245071, 0.271240621805191, 0.271222174167633, 0.27120378613472, 0.271185457706451, 0.271167188882828, 0.271148949861526, 0.271130740642548, 0.271112591028214, 0.271094471216202, 0.271077841520309, 0.271062463521957, 0.27104714512825, 0.271031767129898, 0.271016418933868, 0.271001130342484, 0.270985811948776, 0.270970493555069, 0.270955204963684, 0.270939946174622, 0.270924687385559, 0.270909428596497, 0.270894199609756, 0.270878970623016, 0.270863711833954, 0.270848542451859, 0.270833343267441, 0.270818173885345, 0.270802974700928, 0.270787835121155, 0.270772695541382, 0.270757585763931, 0.270742416381836, 0.270727336406708, 0.270712226629257, 0.270697116851807, 0.270682066679001, 0.270666986703873, 0.270651936531067, 0.270636916160583, 0.270621865987778, 0.270606845617294, 0.270591825246811, 0.270576864480972, 0.270561903715134, 0.270546913146973, 0.270531952381134, 0.270516991615295, 0.270502060651779, 0.270487129688263, 0.270472228527069, 0.270457327365875, 0.270442456007004, 0.27042755484581, 0.270412683486938, 0.270397841930389, 0.27038300037384, 0.270368158817291, 0.270353347063065, 0.270338535308838, 0.270323753356934, 0.270308941602707, 0.270294189453125, 0.270279407501221, 0.270264655351639, 0.270249933004379, 0.27023521065712, 0.27022048830986, 0.270205795764923, 0.270191103219986, 0.270176410675049, 0.270161747932434, 0.270147114992142, 0.270132482051849, 0.270117819309235, 0.270103216171265, 0.270088613033295, 0.270074009895325, 0.270059436559677, 0.270044833421707, 0.270030289888382, 0.270015746355057, 0.270001173019409, 0.269986659288406, 0.269972145557404, 0.269957661628723, 0.26994314789772, 0.26992866396904, 0.269914209842682, 0.269899755716324, 0.269885301589966, 0.26987087726593, 0.269856452941895, 0.269842028617859, 0.269827663898468, 0.269813269376755, 0.269798874855042, 0.269784480333328, 0.269770175218582, 0.269755810499191, 0.269741505384445, 0.269727200269699, 0.269712895154953, 0.269698590040207, 0.269684314727783, 0.269670039415359, 0.269655764102936, 0.269641518592834, 0.269627273082733, 0.269613087177277, 0.269599825143814, 0.269587516784668, 0.269575089216232, 0.269562512636185, 0.26954984664917, 0.269537061452866, 0.269524157047272, 0.269511103630066, 0.269497960805893, 0.26948469877243, 0.269471287727356, 0.269457787275314, 0.269444197416306, 0.269430428743362, 0.269416570663452, 0.269402623176575, 0.269388496875763, 0.269374281167984, 0.269359946250916, 0.269345492124557, 0.269330948591232, 0.269316256046295, 0.269301444292068, 0.269286513328552, 0.269271492958069, 0.269256353378296, 0.269241064786911, 0.269225627183914, 0.269210129976273, 0.269194513559341, 0.269178748130798, 0.269162893295288, 0.269146919250488, 0.269130825996399, 0.269114583730698, 0.269098222255707, 0.269081801176071, 0.269065201282501, 0.269048511981964, 0.269031673669815, 0.269014745950699, 0.268997699022293, 0.268980503082275, 0.268963247537613, 0.268945813179016, 0.268928319215775, 0.268910676240921, 0.268892914056778, 0.268875032663345, 0.268857032060623, 0.268838912248611, 0.26882067322731, 0.268802344799042, 0.268783867359161, 0.268765270709991, 0.268746584653854, 0.268727749586105, 0.268708795309067, 0.268689751625061, 0.268670588731766, 0.268651276826859, 0.268631845712662, 0.268612295389175, 0.268592655658722, 0.268572896718979, 0.268553018569946, 0.268532991409302, 0.26851287484169, 0.268492639064789, 0.268472284078598, 0.268451780080795, 0.268431186676025, 0.268410474061966, 0.268389642238617, 0.268368691205978, 0.26834762096405, 0.268326431512833, 0.268305122852325, 0.268283694982529, 0.268262177705765, 0.268240481615067, 0.268218725919724, 0.268196791410446, 0.268174797296524, 0.26815265417099, 0.268130421638489, 0.268108010292053, 0.268085539340973, 0.268062949180603, 0.268040210008621, 0.26801735162735, 0.267994403839111, 0.267971307039261, 0.267948120832443, 0.267924815416336, 0.267901360988617, 0.267877817153931, 0.267854154109955, 0.267830371856689, 0.267806440591812, 0.267782986164093, 0.267758220434189, 0.267733126878738, 0.267707765102386, 0.267682135105133, 0.267656266689301, 0.267630070447922, 0.267603605985641, 0.267576843500137, 0.267549812793732, 0.267522543668747, 0.267494946718216, 0.267467081546783, 0.267438977956772, 0.267410516738892, 0.267381846904755, 0.267352879047394, 0.267323613166809, 0.267294108867645, 0.267264276742935, 0.267234206199646, 0.267203837633133, 0.267173171043396, 0.267142295837402, 0.26711106300354, 0.267079591751099, 0.267047852277756, 0.267015784978867, 0.266983509063721, 0.266950905323029, 0.266918033361435, 0.26688489317894, 0.266851454973221, 0.2668177485466, 0.266783773899078, 0.266749531030655, 0.266714930534363, 0.266680151224136, 0.266645014286041, 0.266609668731689, 0.266573995351791, 0.266538053750992, 0.266501873731613, 0.266465365886688, 0.266428560018539, 0.266391545534134, 0.266354203224182, 0.266316622495651, 0.266278713941574, 0.266240566968918, 0.266202092170715, 0.266163408756256, 0.266124397516251, 0.266085118055344, 0.266045570373535, 0.266005724668503, 0.265965610742569, 0.265925228595734, 0.265884548425674, 0.265843629837036, 0.265802383422852, 0.265760868787766, 0.265719085931778, 0.265677005052567, 0.265634685754776, 0.265592098236084, 0.265549182891846, 0.265505999326706, 0.265462547540665, 0.2654187977314, 0.265374809503555, 0.265330523252487, 0.265285938978195, 0.265241086483002, 0.265195965766907, 0.26515057682991, 0.26510488986969, 0.265058934688568, 0.2650126516819, 0.264966189861298, 0.264919370412827, 0.264872312545776, 0.26482492685318, 0.264777302742004, 0.264729380607605, 0.264681190252304, 0.264632701873779, 0.264583975076675, 0.26453498005867, 0.264485657215118, 0.264436066150665, 0.264386206865311, 0.264336079359055, 0.264285653829575, 0.264234960079193, 0.264183968305588, 0.264132738113403, 0.264081180095673, 0.264029383659363, 0.263977289199829, 0.26392388343811, 0.263867974281311, 0.263811737298965, 0.263755112886429, 0.263698130846024, 0.26364079117775, 0.263583064079285, 0.263524979352951, 0.263466507196426, 0.263407707214355, 0.263348549604416, 0.263289004564285, 0.263229072093964, 0.263168811798096, 0.263108134269714, 0.263047158718109, 0.26298576593399, 0.262924045324326, 0.26286193728447, 0.262799471616745, 0.262736588716507, 0.262673407793045, 0.26260980963707, 0.262545883655548, 0.262481600046158, 0.262416929006577, 0.262351870536804, 0.262286484241486, 0.262220710515976, 0.262154549360275, 0.262088060379028, 0.262021243572235, 0.261953979730606, 0.261886388063431, 0.261818438768387, 0.261750102043152, 0.261681407690048, 0.261612325906754, 0.26154288649559, 0.261473119258881, 0.26140296459198, 0.261332422494888, 0.26126155257225, 0.261190295219421, 0.261118650436401, 0.261046648025513, 0.260974317789078, 0.260901600122452, 0.260828524827957, 0.260755062103271, 0.260681241750717, 0.260607063770294, 0.26053249835968, 0.260457634925842, 0.260382294654846, 0.260306656360626, 0.260230660438538, 0.260154277086258, 0.260077506303787, 0.26000040769577, 0.259922951459885, 0.259845077991486, 0.25976687669754, 0.259688287973404, 0.259609341621399, 0.259530067443848, 0.259450376033783, 0.25937032699585, 0.259289920330048, 0.259209185838699, 0.259128034114838, 0.259046494960785, 0.258964657783508, 0.258882403373718, 0.258799821138382, 0.258716851472855, 0.258633494377136, 0.258549839258194, 0.258465766906738, 0.258381307125092, 0.258296489715576, 0.258211374282837, 0.258125811815262, 0.258039921522141, 0.257953673601151, 0.257867038249969, 0.25778004527092, 0.257692694664001, 0.257604956626892, 0.257516860961914, 0.257428407669067, 0.257339626550674, 0.257250428199768, 0.257160842418671, 0.257070928812027, 0.256980627775192, 0.256889998912811, 0.256798952817917, 0.256707578897476, 0.256615847349167, 0.256518989801407, 0.256422400474548, 0.256325513124466, 0.256228297948837, 0.25613084435463, 0.256033033132553, 0.255934923887253, 0.255836516618729, 0.255737781524658, 0.255638748407364, 0.255539417266846, 0.255439728498459, 0.255339801311493, 0.255239546298981, 0.255138963460922, 0.25503808259964, 0.254936903715134, 0.254835397005081, 0.254733592271805, 0.254631519317627, 0.25452908873558, 0.25442636013031, 0.254323333501816, 0.254219979047775, 0.254116356372833, 0.254012405872345, 0.253908157348633, 0.253803580999374, 0.253698706626892, 0.253593534231186, 0.253488063812256, 0.253382235765457, 0.253276139497757, 0.25316971540451, 0.253063052892685, 0.252956002950668, 0.252848654985428, 0.252741038799286, 0.252633064985275, 0.252524822950363, 0.252416253089905, 0.252307385206223, 0.252198219299316, 0.252088725566864, 0.251978904008865, 0.251868814229965, 0.251758426427841, 0.251647710800171, 0.251536697149277, 0.251425355672836, 0.251313716173172, 0.251201778650284, 0.251089513301849, 0.250976949930191, 0.250864118337631, 0.250750929117203, 0.25063744187355, 0.250523656606674, 0.250409543514252, 0.250295162200928, 0.250180453062057, 0.250065416097641, 0.249950096011162, 0.249834463000298, 0.249718517065048, 0.249602228403091, 0.249485701322556, 0.249368831515312, 0.249251648783684, 0.249134168028831, 0.249016374349594, 0.248898297548294, 0.248779892921448, 0.248661205172539, 0.248542174696922, 0.248422846198082, 0.248303219676018, 0.24818329513073, 0.248063027858734, 0.247942477464676, 0.247821629047394, 0.247700467705727, 0.247578993439674, 0.247457221150398, 0.247335121035576, 0.247212737798691, 0.247090026736259, 0.246966987848282, 0.246843665838242, 0.246720060706139, 0.246596127748489, 0.246471881866455, 0.246347352862358, 0.246222466230392, 0.246097311377525, 0.245971813797951, 0.245846047997475, 0.245719954371452, 0.245593577623367, 0.245466887950897, 0.245342254638672, 0.245212912559509, 0.245083495974541, 0.24495393037796, 0.24482424557209, 0.244694441556931, 0.244564533233643, 0.244434460997581, 0.244304284453392, 0.244174003601074, 0.244043588638306, 0.243913069367409, 0.2437824010849, 0.243651613593102, 0.243520677089691, 0.243389666080475, 0.243258535861969, 0.243127256631851, 0.242995843291283, 0.242864325642586, 0.242732688784599, 0.242600947618484, 0.24246908724308, 0.242337048053741, 0.242204949259758, 0.242072701454163, 0.241940319538116, 0.241807788610458, 0.241675198078156, 0.241542473435402, 0.241409599781036, 0.241276606917381, 0.241143509745598, 0.241010308265686, 0.240876942873001, 0.240743443369865, 0.240609854459763, 0.240476131439209, 0.240342304110527, 0.240208312869072, 0.24007423222065, 0.239940047264099, 0.239805713295937, 0.239671260118484, 0.239536687731743, 0.239401996135712, 0.23926717042923, 0.239132225513458, 0.238997161388397, 0.238861963152885, 0.238726675510406, 0.238591238856316, 0.238455668091774, 0.238319978117943, 0.238184198737144, 0.238048285245895, 0.237912222743034, 0.237776070833206, 0.237639799714088, 0.237503379583359, 0.237366855144501, 0.237230196595192, 0.237093433737755, 0.236956536769867, 0.236819505691528, 0.2366823554039, 0.236545100808144, 0.236407712101936, 0.23627020418644, 0.236132547259331, 0.235994800925255, 0.235856935381889, 0.235718935728073, 0.235580801963806, 0.235442563891411, 0.235304191708565, 0.23516571521759, 0.235027104616165, 0.234888359904289, 0.234749510884285, 0.234610542654991, 0.234471425414085, 0.234332203865051, 0.234192863106728, 0.234053388237953, 0.233913794159889, 0.233774080872536, 0.233634263277054, 0.233494311571121, 0.233354240655899, 0.233214005827904, 0.233073681592941, 0.232933223247528, 0.232792690396309, 0.232651978731155, 0.232511162757874, 0.232370227575302, 0.232229173183441, 0.232087984681129, 0.231946691870689, 0.231811046600342, 0.231671586632729, 0.231532156467438, 0.231392785906792, 0.231253504753113, 0.231114283204079, 0.230975136160851, 0.230836048722267, 0.230696991086006, 0.230558097362518, 0.230419218540192, 0.230280414223671, 0.230141684412956, 0.230003029108047, 0.229864433407784, 0.229725882411003, 0.22958742082119, 0.229449048638344, 0.22931070625782, 0.229172483086586, 0.229034304618835, 0.22889618575573, 0.228758126497269, 0.228620201349258, 0.228482276201248, 0.228344425559044, 0.228206679224968, 0.228068992495537, 0.227931380271912, 0.22779381275177, 0.227656349539757, 0.227518916130066, 0.22738154232502, 0.227244287729263, 0.227107062935829, 0.226969942450523, 0.226832866668701, 0.226695880293846, 0.226558938622475, 0.226422071456909, 0.226285308599472, 0.226148575544357, 0.226011916995049, 0.225875347852707, 0.225738868117332, 0.225602403283119, 0.225466027855873, 0.225329741835594, 0.225193500518799, 0.225057303905487, 0.224921241402626, 0.224785208702087, 0.224649235606194, 0.224513322114944, 0.224377557635307, 0.224241822957993, 0.224106103181839, 0.223970502614975, 0.223834961652756, 0.223699495196342, 0.223564088344574, 0.223428755998611, 0.223293483257294, 0.223158314824104, 0.223023161292076, 0.222888141870499, 0.222753137350082, 0.222618222236633, 0.22248338162899, 0.222348600625992, 0.222213879227638, 0.222079247236252, 0.221944689750671, 0.221810176968575, 0.221675753593445, 0.221541404724121, 0.221407100558281, 0.221272885799408, 0.221138745546341, 0.221004649996758, 0.220870614051819, 0.220736712217331, 0.220602840185165, 0.220469042658806, 0.220335319638252, 0.220201656222343, 0.220068037509918, 0.21993450820446, 0.219801068305969, 0.219667658209801, 0.219534337520599, 0.219401106238365, 0.219267934560776, 0.219134792685509, 0.21900175511837, 0.218868806958199, 0.218735888600349, 0.218603044748306, 0.218470320105553, 0.218337595462799, 0.21820555627346, 0.218077167868614, 0.217948913574219, 0.217820823192596, 0.217692866921425, 0.217565059661865, 0.217437371611595, 0.217309832572937, 0.217182472348213, 0.217055231332779, 0.216928109526634, 0.216801136732101, 0.216674312949181, 0.216547638177872, 0.216421127319336, 0.21629473567009, 0.216168463230133, 0.216042384505272, 0.215916410088539, 0.215790584683418, 0.215664863586426, 0.21553935110569, 0.215413972735405, 0.215288683772087, 0.215163603425026, 0.215038612484932, 0.214913800358772, 0.214789122343063, 0.214664578437805, 0.214540183544159, 0.214415907859802, 0.214291796088219, 0.214167833328247, 0.21404393017292, 0.213920280337334, 0.213796734809875, 0.213673323392868, 0.213550060987473, 0.213426932692528, 0.213303968310356, 0.213181123137474, 0.213058412075043, 0.212935864925385, 0.212813451886177, 0.21269117295742, 0.212569087743759, 0.212447062134743, 0.212325215339661, 0.21220351755619, 0.212081953883171, 0.211960539221764, 0.211839273571968, 0.211718156933784, 0.211597129702568, 0.211476281285286, 0.211355596780777, 0.211235046386719, 0.211114585399628, 0.210994333028793, 0.210874184966087, 0.210754185914993, 0.210634306073189, 0.21051461994648, 0.210395082831383, 0.210275635123253, 0.210156351327896, 0.210037186741829, 0.209918200969696, 0.209799364209175, 0.209680631756783, 0.209562048316002, 0.209443643689156, 0.209325358271599, 0.209207206964493, 0.209089159965515, 0.208971321582794, 0.208853617310524, 0.20873598754406, 0.208618581295013, 0.208501279354095, 0.208384111523628, 0.208267107605934, 0.208150237798691, 0.208033546805382, 0.207916915416718, 0.20780049264431, 0.207684218883514, 0.207568004727364, 0.207452028989792, 0.207336127758026, 0.207220420241356, 0.207104817032814, 0.206989362835884, 0.206874057650566, 0.20675890147686, 0.206643879413605, 0.206529021263123, 0.206414237618446, 0.206299677491188, 0.206185236573219, 0.206071853637695, 0.205961301922798, 0.205850765109062, 0.205740317702293, 0.205629959702492, 0.205519586801529, 0.205409318208694, 0.205299094319344, 0.205188930034637, 0.205078840255737, 0.204968795180321, 0.204858809709549, 0.204748868942261, 0.20463901758194, 0.204529240727425, 0.204419478774071, 0.204309821128845, 0.204200193285942, 0.204090610146523, 0.203981101512909, 0.203871637582779, 0.203762277960777, 0.203652948141098, 0.203543663024902, 0.203434452414513, 0.203325301408768, 0.203216210007668, 0.203107178211212, 0.202998176217079, 0.202889293432236, 0.202780440449715, 0.202671661973, 0.202562913298607, 0.202454224228859, 0.202345609664917, 0.202237069606781, 0.202128559350967, 0.20202012360096, 0.201911717653275, 0.201803416013718, 0.201695159077644, 0.201586931943893, 0.201478809118271, 0.201370716094971, 0.201262712478638, 0.201154753565788, 0.201046824455261, 0.200939014554024, 0.200831204652786, 0.200723484158516, 0.200615808367729, 0.200508207082748, 0.200400650501251, 0.200293138623238, 0.200185716152191, 0.200078383088112, 0.199971035122871, 0.199863791465759, 0.199756622314453, 0.199649468064308, 0.199542388319969, 0.199435353279114, 0.199328437447548, 0.199221551418304, 0.199114680290222, 0.199007913470268, 0.198901176452637, 0.198794513940811, 0.198687940835953, 0.198581367731094, 0.198474898934364, 0.198368474841118, 0.198262110352516, 0.19815582036972, 0.198049560189247, 0.19794337451458, 0.197837248444557, 0.197731181979179, 0.197625190019608, 0.197519212961197, 0.197413340210915, 0.197307527065277, 0.197201743721962, 0.19709600508213, 0.19699040055275, 0.196884796023369, 0.196779280900955, 0.196673780679703, 0.19656839966774, 0.196463018655777, 0.196357727050781, 0.196252509951591, 0.196147292852402, 0.196042194962502, 0.195937171578407, 0.195832133293152, 0.195727214217186, 0.195622324943542, 0.195517480373383, 0.195412740111351, 0.195308357477188, 0.195204302668571, 0.19510018825531, 0.194995924830437, 0.194891571998596, 0.194787085056305, 0.194682508707047, 0.194577813148499, 0.1944729834795, 0.194368064403534, 0.194263011217117, 0.194157868623734, 0.194052591919899, 0.193947210907936, 0.193841725587845, 0.193736106157303, 0.193630397319794, 0.193524554371834, 0.193418622016907, 0.19331257045269, 0.193206384778023, 0.193100109696388, 0.192993715405464, 0.192887201905251, 0.192780584096909, 0.192673861980438, 0.192567005753517, 0.192460060119629, 0.192352995276451, 0.192245781421661, 0.192138478159904, 0.192031070590019, 0.191923543810844, 0.191815912723541, 0.19170817732811, 0.191600307822227, 0.191492334008217, 0.191384255886078, 0.191276028752327, 0.19116772711277, 0.191059276461601, 0.190950751304626, 0.190842092037201, 0.190733328461647, 0.190624460577965, 0.190515473484993, 0.190406337380409, 0.19029712677002, 0.190187811851501, 0.190078362822533, 0.189968779683113, 0.189859122037888, 0.189749345183372, 0.189639434218407, 0.189529433846474, 0.189419314265251, 0.189309075474739, 0.189198717474937, 0.189088270068169, 0.188977688550949, 0.188867002725601, 0.188756197690964, 0.188645303249359, 0.188534259796143, 0.188423126935959, 0.188311904668808, 0.188200518488884, 0.188089042901993, 0.187977448105812, 0.187865763902664, 0.187753945589066, 0.187642008066177, 0.187529981136322, 0.187417805194855, 0.187305554747581, 0.187193185091019, 0.187080681324005, 0.186968073248863, 0.186855360865593, 0.186742514371872, 0.186629563570023, 0.186516493558884, 0.186403334140778, 0.186290055513382, 0.186176687479019, 0.186063155531883, 0.18594953417778, 0.185835793614388, 0.185721933841705, 0.185607969760895, 0.185493901371956, 0.185379713773727, 0.185265421867371, 0.185150995850563, 0.18503649532795, 0.184921830892563, 0.184807077050209, 0.184692233800888, 0.184577241539955, 0.184462144970894, 0.184345617890358, 0.184226855635643, 0.184107884764671, 0.183988690376282, 0.183869242668152, 0.183749556541443, 0.183629661798477, 0.183509528636932, 0.183389127254486, 0.183268517255783, 0.18314765393734, 0.18302658200264, 0.182905241847038, 0.182783663272858, 0.182661890983582, 0.182539895176888, 0.18241760134697, 0.182295128703117, 0.182172358036041, 0.18204939365387, 0.18192620575428, 0.18180276453495, 0.181679084897041, 0.181555181741714, 0.181431040167809, 0.181306660175323, 0.181182041764259, 0.181057199835777, 0.180932119488716, 0.180806815624237, 0.180681228637695, 0.180555462837219, 0.180429443717003, 0.180303201079369, 0.180176705121994, 0.18004997074604, 0.179923012852669, 0.179795786738396, 0.179668366909027, 0.179540693759918, 0.179412797093391, 0.179284662008286, 0.179156273603439, 0.179027661681175, 0.178898841142654, 0.178769782185555, 0.178640455007553, 0.178510919213295, 0.178381130099297, 0.17825111746788, 0.178120851516724, 0.17799037694931, 0.177859634160995, 0.177728712558746, 0.177597478032112, 0.177466079592705, 0.177334398031235, 0.177202507853508, 0.177070334553719, 0.176937997341156, 0.176805391907692, 0.176672577857971, 0.176539495587349, 0.176406189799309, 0.176272630691528, 0.176138877868652, 0.176004827022552, 0.175870642066002, 0.175736114382744, 0.175601437687874, 0.175466418266296, 0.175331279635429, 0.175195887684822, 0.175060167908669, 0.174924314022064, 0.174788177013397, 0.174651831388474, 0.174515202641487, 0.174378365278244, 0.174241304397583, 0.174104019999504, 0.173966482281685, 0.173828721046448, 0.173690736293793, 0.173552468419075, 0.173413947224617, 0.173275291919708, 0.173136338591576, 0.172997131943703, 0.172857746481895, 0.172718077898026, 0.172578230500221, 0.172438055276871, 0.172297745943069, 0.172157123684883, 0.17201629281044, 0.171875223517418, 0.171733945608139, 0.17159241437912, 0.171450674533844, 0.171300649642944, 0.171153381466866, 0.171005934476852, 0.170858219265938, 0.170710369944572, 0.170562326908112, 0.170414119958878, 0.170265704393387, 0.170117080211639, 0.169968321919441, 0.169819295406342, 0.169670104980469, 0.169520735740662, 0.169371172785759, 0.169221460819244, 0.169071510434151, 0.1689213514328, 0.168771088123322, 0.168620571494102, 0.168469876050949, 0.168319001793861, 0.168167933821678, 0.168016672134399, 0.167865201830864, 0.167713597416878, 0.167561739683151, 0.167409762740135, 0.16725754737854, 0.167105183005333, 0.166952580213547, 0.166799813508987, 0.166646853089333, 0.166493698954582, 0.166340336203575, 0.166186824440956, 0.166033118963242, 0.16587920486927, 0.165725097060204, 0.165570825338364, 0.165416315197945, 0.165261700749397, 0.165106847882271, 0.164951771497726, 0.164796575903893, 0.164641126990318, 0.164485529065132, 0.164329722523689, 0.164173766970634, 0.164017572999001, 0.16386117041111, 0.163704618811607, 0.163547903299332, 0.16339099407196, 0.16323384642601, 0.163076519966125, 0.162919014692307, 0.162761345505714, 0.162603467702866, 0.16244538128376, 0.162287160754204, 0.162128686904907, 0.161970049142838, 0.161811217665672, 0.161652207374573, 0.1614930331707, 0.161333620548248, 0.161174044013023, 0.161014273762703, 0.160854294896126, 0.160694167017937, 0.160533830523491, 0.160373330116272, 0.160212591290474, 0.160051718354225, 0.159890606999397, 0.159729272127151, 0.159567832946777, 0.159406170248985, 0.159244328737259, 0.159082263708115, 0.158920019865036, 0.158757612109184, 0.158594995737076, 0.158432245254517, 0.158269211649895, 0.158106073737144, 0.157942682504654, 0.157779112458229, 0.15761536359787, 0.157451450824738, 0.15728734433651, 0.157123014330864, 0.156958520412445, 0.156793802976608, 0.156628921627998, 0.156463891267776, 0.156298607587814, 0.15613317489624, 0.155967518687248, 0.155801683664322, 0.155633077025414, 0.155464068055153, 0.155295088887215, 0.155126094818115, 0.154957145452499, 0.154788166284561, 0.15461927652359, 0.154450356960297, 0.154281452298164, 0.154112592339516, 0.153943732380867, 0.153774902224541, 0.153606072068214, 0.153437301516533, 0.153268545866013, 0.153099730610847, 0.15293100476265, 0.152762323617935, 0.15259362757206, 0.152424931526184, 0.152256235480309, 0.1520876288414, 0.151919007301331, 0.151750415563583, 0.151581779122353, 0.151413232088089, 0.151244685053825, 0.151076182723045, 0.150907620787621, 0.150739163160324, 0.150570690631866, 0.150402247905731, 0.150233790278435, 0.150065362453461, 0.14989697933197, 0.149728626012802, 0.149560198187828, 0.149391889572144, 0.14922359585762, 0.149055302143097, 0.148886993527412, 0.148718729615211, 0.148550495505333, 0.148382276296616, 0.148214042186737, 0.148045882582664, 0.147877708077431, 0.147709578275681, 0.147541433572769, 0.147373348474503, 0.147205278277397, 0.147037163376808, 0.146869093179703, 0.146701082587242, 0.146533086895943, 0.14636504650116, 0.146197080612183, 0.146029129624367, 0.145861208438873, 0.145693272352219, 0.145525366067886, 0.145357504487038, 0.145189642906189, 0.145021826028824, 0.144853949546814, 0.14468614757061, 0.144518375396729, 0.144350647926331, 0.144182845950127, 0.144015118479729, 0.143847405910492, 0.143679723143578, 0.143512025475502, 0.14334437251091, 0.143176734447479, 0.143009155988693, 0.142841503024101, 0.142673969268799, 0.142506390810013, 0.142338886857033, 0.142171323299408, 0.142003834247589, 0.141836360096931, 0.141668900847435, 0.141501426696777, 0.141334027051926, 0.141166597604752, 0.140999242663383, 0.140831872820854, 0.140664532780647, 0.14049719274044, 0.140329852700233, 0.140162572264671, 0.139995336532593, 0.139828056097031, 0.13966079056263, 0.139493599534035, 0.139326423406601, 0.139159217476845, 0.138992056250572, 0.138832658529282, 0.138667300343513, 0.138502135872841, 0.138337284326553, 0.138172537088394, 0.13800810277462, 0.137844011187553, 0.137680172920227, 0.137516587972641, 0.137353152036667, 0.137190118432045, 0.13702729344368, 0.136864706873894, 0.136702358722687, 0.136540368199348, 0.136378481984138, 0.136217027902603, 0.136055648326874, 0.135894596576691, 0.135733902454376, 0.135573267936707, 0.135413110256195, 0.135253056883812, 0.135093405842781, 0.134933859109879, 0.134774729609489, 0.13461571931839, 0.134457066655159, 0.134298637509346, 0.134140446782112, 0.133982509374619, 0.133824825286865, 0.133667498826981, 0.133510261774063, 0.133353337645531, 0.133196771144867, 0.13304029405117, 0.132884323596954, 0.132728427648544, 0.132572859525681, 0.132417470216751, 0.132262468338013, 0.132107570767403, 0.131953060626984, 0.131798729300499, 0.131644725799561, 0.131490960717201, 0.131337359547615, 0.131184116005898, 0.131031081080437, 0.130878418684006, 0.130725860595703, 0.13057367503643, 0.130421668291092, 0.130270004272461, 0.130118563771248, 0.129967302083969, 0.129816368222237, 0.129665777087212, 0.129515334963799, 0.129365026950836, 0.129215195775032, 0.129065543413162, 0.128916248679161, 0.128767058253288, 0.128618195652962, 0.128469541668892, 0.128321319818497, 0.128173127770424, 0.128025278449059, 0.127877786755562, 0.127730429172516, 0.127583384513855, 0.127436608076096, 0.127290174365044, 0.127143710851669, 0.126997709274292, 0.126851990818977, 0.126706436276436, 0.126561239361763, 0.126416131854057, 0.126271516084671, 0.126127079129219, 0.125982835888863, 0.125838860869408, 0.12569522857666, 0.125551745295525, 0.125408589839935, 0.125265672802925, 0.125122889876366, 0.124980583786964, 0.124838441610336, 0.12469657510519, 0.124554932117462, 0.124413624405861, 0.124272495508194, 0.124131694436073, 0.123991005122662, 0.123850703239441, 0.123710684478283, 0.123569875955582, 0.123434759676456, 0.123300179839134, 0.123165905475616, 0.123032093048096, 0.122898682951927, 0.122765563428402, 0.12263286113739, 0.122500516474247, 0.122368559241295, 0.122237011790276, 0.122105926275253, 0.121975190937519, 0.12184464931488, 0.121714614331722, 0.121584936976433, 0.12145572155714, 0.121326893568039, 0.121198274195194, 0.12107016146183, 0.120942354202271, 0.120815083384514, 0.120688036084175, 0.120561487972736, 0.120435185730457, 0.120309337973595, 0.120183907449245, 0.120058819651604, 0.119934074580669, 0.119809791445732, 0.119685776531696, 0.119562149047852, 0.119438983500004, 0.119316212832928, 0.11919379979372, 0.119071692228317, 0.118950039148331, 0.118828736245632, 0.11870788782835, 0.118587337434292, 0.118467196822166, 0.118347346782684, 0.118228018283844, 0.118108935654163, 0.117990359663963, 0.117872133851051, 0.117754220962524, 0.1176368445158, 0.117519624531269, 0.117402918636799, 0.117286615073681, 0.117170609533787, 0.117055110633373, 0.116939857602119, 0.116825111210346, 0.116710528731346, 0.116596534848213, 0.11648290604353, 0.116369627416134, 0.116256654262543, 0.116143971681595, 0.116031907498837, 0.115920037031174, 0.115808770060539, 0.115697667002678, 0.115587115287781, 0.11547676473856, 0.115366958081722, 0.115257367491722, 0.115148328244686, 0.115039527416229, 0.114931255578995, 0.114823170006275, 0.114715538918972, 0.114608466625214, 0.114501543343067, 0.114395126700401, 0.114289008080959, 0.114183343946934, 0.114077940583229, 0.113973185420036, 0.113868482410908, 0.113764435052872, 0.113660544157028, 0.113557159900665, 0.113454163074493, 0.113351382315159, 0.113249205052853, 0.113147281110287, 0.113045759499073, 0.112944640219212, 0.112843871116638, 0.112743504345417, 0.112643554806709, 0.112543947994709, 0.11244473606348, 0.112345844507217, 0.112247303128242, 0.112149350345135, 0.1120515614748, 0.111950546503067, 0.111858457326889, 0.111766554415226, 0.111675001680851, 0.111583888530731, 0.111492991447449, 0.111402414739132, 0.111312195658684, 0.111222229897976, 0.111132688820362, 0.111043326556683, 0.110954418778419, 0.110865712165833, 0.11077731102705, 0.110689207911491, 0.110601589083672, 0.11051419377327, 0.110427051782608, 0.110340252518654, 0.110253721475601, 0.110167562961578, 0.110081762075424, 0.109996303915977, 0.109911032021046, 0.109826169908047, 0.109741516411304, 0.109657347202301, 0.10957346111536, 0.109489805996418, 0.109406471252441, 0.109323494136333, 0.109240785241127, 0.109158419072628, 0.109076298773289, 0.108994647860527, 0.108913287520409, 0.108832135796547, 0.108751319348812, 0.10867078602314, 0.108590707182884, 0.108510978519917, 0.108431406319141, 0.108352184295654, 0.10827324539423, 0.108194634318352, 0.108116447925568, 0.108038529753685, 0.107960879802704, 0.107883475720882, 0.107806503772736, 0.107729859650135, 0.107653513550758, 0.10757739841938, 0.107501685619354, 0.107426218688488, 0.107351064682007, 0.107276387512684, 0.107201881706715, 0.10712768137455, 0.107053808867931, 0.10698027163744, 0.106907173991203, 0.106834262609482, 0.10676159709692, 0.106689341366291, 0.106617316603661, 0.106545694172382, 0.106474496424198, 0.106403477489948, 0.106332778930664, 0.106262363493443, 0.106192275881767, 0.10612266510725, 0.106053180992603, 0.105984084308147, 0.105915255844593, 0.105846680700779, 0.105778567492962, 0.105710819363594, 0.105643212795258, 0.105575978755951, 0.105509035289288, 0.105442516505718, 0.105376183986664, 0.105310291051865, 0.105244614183903, 0.105179235339165, 0.105114199221134, 0.105049535632133, 0.104985252022743, 0.104921147227287, 0.104857362806797, 0.104793913662434, 0.104730844497681, 0.104668095707893, 0.104605548083782, 0.104543313384056, 0.104481495916843, 0.104419983923435, 0.104358784854412, 0.104309923946857, 0.104251727461815, 0.104193583130836, 0.104135550558567, 0.104077652096748, 0.104019820690155, 0.10396209359169, 0.103904530405998, 0.103847026824951, 0.103789605200291, 0.10373230278492, 0.103675097227097, 0.103617988526821, 0.103560961782932, 0.103504061698914, 0.103447265923023, 0.103390567004681, 0.103333964943886, 0.103277452290058, 0.103221073746681, 0.10316476225853, 0.103108569979668, 0.103052489459515, 0.102996498346329, 0.102940611541271, 0.1028848066926, 0.10282913595438, 0.102773532271385, 0.10271805524826, 0.102662675082684, 0.102607406675816, 0.102552220225334, 0.102497145533562, 0.102442175149918, 0.10238728672266, 0.102332562208176, 0.102277912199497, 0.102223329246044, 0.102168865501881, 0.102114491164684, 0.102060243487358, 0.10200609266758, 0.101952016353607, 0.101898081600666, 0.101844199001789, 0.101790443062782, 0.101736783981323, 0.101683251559734, 0.101629801094532, 0.101576425135136, 0.10152318328619, 0.101470053195953, 0.101417012512684, 0.101364061236382, 0.101311229169369, 0.101258479058743, 0.101205848157406, 0.101153306663036, 0.101100876927376, 0.101048529148102, 0.100996293127537, 0.100944198668003, 0.100892163813114, 0.100840255618095, 0.100788444280624, 0.100736737251282, 0.100685119628906, 0.100633583962917, 0.10058218985796, 0.100530847907066, 0.100479647517204, 0.100428499281406, 0.10037749260664, 0.100326642394066, 0.100275829434395, 0.100225113332272, 0.100174501538277, 0.100124016404152, 0.100073590874672, 0.100023321807384, 0.0999730825424194, 0.0999230220913887, 0.0998730137944221, 0.0998230949044228, 0.0997733548283577, 0.0997236222028732, 0.0996740385890007, 0.0996245369315147, 0.0995751768350601, 0.0995258912444115, 0.09947669506073, 0.0994276478886604, 0.0993786454200745, 0.0993297547101974, 0.09928098320961, 0.0992323160171509, 0.0991837382316589, 0.0991352647542953, 0.0990869030356407, 0.0990386307239532, 0.0989837497472763, 0.0989336520433426, 0.0988834723830223, 0.0988331362605095, 0.0987827032804489, 0.0987321585416794, 0.0986814051866531, 0.0986306071281433, 0.0985796004533768, 0.0985285043716431, 0.0984772741794586, 0.0984259322285652, 0.0983745008707047, 0.0983228459954262, 0.0982711240649223, 0.0982192382216454, 0.0981672629714012, 0.0981151238083839, 0.0980628728866577, 0.0980105251073837, 0.0979579910635948, 0.0979053676128387, 0.0978525951504707, 0.0977997109293938, 0.0977466776967049, 0.097693532705307, 0.0976402759552002, 0.0975868478417397, 0.0975333228707314, 0.0974796414375305, 0.0974258631467819, 0.0973718911409378, 0.0973178818821907, 0.0972637236118317, 0.0972093790769577, 0.097154974937439, 0.0971003919839859, 0.0970457047224045, 0.0969908386468887, 0.09693593531847, 0.0968808606266975, 0.0968256592750549, 0.0967703312635422, 0.0967148169875145, 0.0966592654585838, 0.0966034978628159, 0.0965476781129837, 0.0964917242527008, 0.0964355915784836, 0.0963793769478798, 0.0963229611515999, 0.0962665155529976, 0.0962098985910416, 0.0961531773209572, 0.0960962697863579, 0.0960392951965332, 0.0959821119904518, 0.095924898982048, 0.0958674848079681, 0.0958099439740181, 0.0957523435354233, 0.09569451212883, 0.0956366583704948, 0.0955785810947418, 0.0955204293131828, 0.0954621583223343, 0.0954037085175514, 0.0953451842069626, 0.0952864810824394, 0.0952277034521103, 0.0951687395572662, 0.0951096713542938, 0.0950505286455154, 0.0949911624193192, 0.0949317514896393, 0.0948721542954445, 0.0948124304413795, 0.0947526097297668, 0.0946926474571228, 0.094632588326931, 0.0945723280310631, 0.0945120379328728, 0.094451516866684, 0.094390906393528, 0.0943301543593407, 0.0942693129181862, 0.0942083597183228, 0.0941472128033638, 0.0940859690308571, 0.094024583697319, 0.0939630791544914, 0.0939014479517937, 0.0938396826386452, 0.0937778428196907, 0.0937157794833183, 0.0936536490917206, 0.0935913473367691, 0.0935289487242699, 0.0934664532542229, 0.0934037491679192, 0.0933307334780693, 0.0932634770870209, 0.0931960344314575, 0.0931282639503479, 0.0930603742599487, 0.0929921865463257, 0.0929237678647041, 0.0928550809621811, 0.0927861854434013, 0.0927170515060425, 0.0926476493477821, 0.0925780683755875, 0.0925082042813301, 0.0924381166696548, 0.0923677384853363, 0.0922971591353416, 0.0922263413667679, 0.0921552702784538, 0.0920840501785278, 0.0920124500989914, 0.091940701007843, 0.0918686911463737, 0.0917964354157448, 0.0917239338159561, 0.091651163995266, 0.0915782526135445, 0.0915050357580185, 0.0914315953850746, 0.0913578793406487, 0.0912839621305466, 0.0912097543478012, 0.0911353603005409, 0.0910608023405075, 0.0909857898950577, 0.0909107625484467, 0.0908353477716446, 0.0907597914338112, 0.0906839519739151, 0.0906078368425369, 0.090531550347805, 0.0904549211263657, 0.0903781726956367, 0.0903010740876198, 0.0902238190174103, 0.0901463404297829, 0.0900685042142868, 0.089990571141243, 0.0899122878909111, 0.0898338779807091, 0.0897550582885742, 0.0896761193871498, 0.0895969420671463, 0.0895175039768219, 0.0894379019737244, 0.089357927441597, 0.0892777964472771, 0.0891973301768303, 0.0891167595982552, 0.0890358909964561, 0.0889547318220139, 0.0888733938336372, 0.0887917950749397, 0.0887100100517273, 0.0886279046535492, 0.088545635342598, 0.0884630903601646, 0.0883802846074104, 0.0882972776889801, 0.0882140025496483, 0.088130459189415, 0.0880467295646667, 0.0879627391695976, 0.0878785252571106, 0.0877940803766251, 0.0877093598246574, 0.0876244157552719, 0.0875392183661461, 0.0874537900090218, 0.0873681083321571, 0.0872822552919388, 0.0871961414813995, 0.087109737098217, 0.0870231240987778, 0.0869362354278564, 0.0868491381406784, 0.0867618173360825, 0.086674228310585, 0.0865864083170891, 0.0864984020590782, 0.0864100977778435, 0.0863215550780296, 0.0862327441573143, 0.0861437544226646, 0.0860545262694359, 0.0859649777412415, 0.0858753398060799, 0.0857853218913078, 0.0856950730085373, 0.0856046304106712, 0.0855139791965485, 0.0854258313775063, 0.0853304415941238, 0.0852349549531937, 0.0851392671465874, 0.0850434303283691, 0.0849473550915718, 0.0848511606454849, 0.0847547799348831, 0.084658108651638, 0.0845613926649094, 0.084464430809021, 0.0843672901391983, 0.0842699632048607, 0.0841724798083305, 0.0840747654438019, 0.0839769244194031, 0.0838788524270058, 0.0837806537747383, 0.0836822092533112, 0.0835836082696915, 0.0834848433732986, 0.0833858922123909, 0.0832866653800011, 0.0831874385476112, 0.0830878540873528, 0.0829882547259331, 0.0828883573412895, 0.0827882587909698, 0.0826880857348442, 0.0825876221060753, 0.0824870690703392, 0.0823862478137016, 0.0822852477431297, 0.0821840986609459, 0.0820828005671501, 0.08198132365942, 0.0818796083331108, 0.0817776918411255, 0.0816756337881088, 0.081573411822319, 0.0814709961414337, 0.0813684016466141, 0.0812655463814735, 0.0811626091599464, 0.0810595005750656, 0.0809561163187027, 0.0808526650071144, 0.0807489305734634, 0.0806450769305229, 0.0805409625172615, 0.0804367288947105, 0.0803322792053223, 0.0802277103066444, 0.0801229625940323, 0.0800179094076157, 0.0799127742648125, 0.0798074454069138, 0.0797019451856613, 0.0795962139964104, 0.0794903412461281, 0.0793842747807503, 0.0792779996991158, 0.0791716128587723, 0.0790649950504303, 0.0789581909775734, 0.0788511633872986, 0.0787440314888954, 0.0786366611719131, 0.0785292014479637, 0.0784214735031128, 0.0783135741949081, 0.0782055333256721, 0.0780972242355347, 0.0779888108372688, 0.0778801664710045, 0.0777713879942894, 0.0776623785495758, 0.0775532275438309, 0.0774439349770546, 0.0773344188928604, 0.0772246494889259, 0.0771147459745407, 0.0770047158002853, 0.0768944472074509, 0.0767840147018433, 0.0766733214259148, 0.0765625908970833, 0.0764515846967697, 0.0763404071331024, 0.0762291103601456, 0.0761174708604813, 0.0760058090090752, 0.07589390873909, 0.0757818520069122, 0.0756695792078972, 0.0755571275949478, 0.0754445567727089, 0.0753317475318909, 0.0752187594771385, 0.0751055851578712, 0.0749917477369308, 0.0748765617609024, 0.074761375784874, 0.0746461674571037, 0.0745309516787529, 0.0744157582521439, 0.0743004977703094, 0.0741853341460228, 0.0740701109170914, 0.0739549100399017, 0.0738396421074867, 0.0737244263291359, 0.0736091881990433, 0.0734939277172089, 0.073378711938858, 0.0732634291052818, 0.0731481611728668, 0.0730329230427742, 0.0729176551103592, 0.0728023573756218, 0.072687104344368, 0.0725718066096306, 0.0724565386772156, 0.07234126329422, 0.0722259655594826, 0.0721106976270676, 0.0719953998923302, 0.0718800723552704, 0.0717647969722748, 0.071649469435215, 0.0715341493487358, 0.0714188292622566, 0.0713035836815834, 0.0711882337927818, 0.0710728839039803, 0.0709575861692429, 0.0708421841263771, 0.0707268863916397, 0.0706115439534187, 0.0704961642622948, 0.0703808143734932, 0.0702654719352722, 0.0701500773429871, 0.0700347274541855, 0.0699193477630615, 0.0698039755225182, 0.0696886032819748, 0.0695732086896896, 0.0694578289985657, 0.0693424046039581, 0.0692270770668983, 0.069111630320549, 0.0689962282776833, 0.0688808336853981, 0.0687654092907906, 0.0686500072479248, 0.0685346126556396, 0.0684191882610321, 0.068303756415844, 0.068188339471817, 0.0680728927254677, 0.0679574683308601, 0.0678420141339302, 0.0677265673875809, 0.0676110684871674, 0.0674956366419792, 0.0673801675438881, 0.0672646909952164, 0.067149244248867, 0.0670337677001953, 0.0669182687997818, 0.0668027922511101, 0.0666873157024384, 0.0665718168020248, 0.0664563626050949, 0.0663408413529396, 0.0662253946065903, 0.066109873354435, 0.0659943968057632, 0.0658788681030273, 0.0657633394002914, 0.0656478404998779, 0.0655322894454002, 0.0654167979955673, 0.0653012171387672, 0.0651856958866119, 0.065070167183876, 0.0649546161293983, 0.0648390129208565, 0.0647234916687012, 0.0646079182624817, 0.0644923895597458, 0.0643767938017845, 0.0642612129449844, 0.064145639538765, 0.0640300884842873, 0.063914492726326, 0.0637988895177841, 0.0636832863092422, 0.0635676831007004, 0.0634586215019226, 0.063345193862915, 0.0632319822907448, 0.0631188601255417, 0.0630059540271759, 0.0628931298851967, 0.0627806559205055, 0.0626681596040726, 0.0625558868050575, 0.0624438226222992, 0.0623318776488304, 0.0622202083468437, 0.0621086210012436, 0.0619971342384815, 0.0618860013782978, 0.0617748908698559, 0.0616640858352184, 0.0615533553063869, 0.0614428482949734, 0.0613324455916882, 0.0612221956253052, 0.061112217605114, 0.0610023178160191, 0.0608926974236965, 0.0607831552624702, 0.0606737844645977, 0.0605646930634975, 0.0604556761682034, 0.0603468604385853, 0.0602382011711597, 0.0601297914981842, 0.0600214041769505, 0.0599131993949413, 0.0598053149878979, 0.059697438031435, 0.0595898851752281, 0.0594824105501175, 0.0593750551342964, 0.0592680089175701, 0.059161014854908, 0.0590542666614056, 0.0589476488530636, 0.0588412545621395, 0.0587349906563759, 0.0586288496851921, 0.0585229881107807, 0.0584172010421753, 0.0583116412162781, 0.0582062341272831, 0.0581009536981583, 0.0579959936439991, 0.0578910410404205, 0.0577863901853561, 0.0576817914843559, 0.0575774945318699, 0.0574732460081577, 0.0573691800236702, 0.0572653859853745, 0.0571616441011429, 0.057058148086071, 0.0569547563791275, 0.0568516217172146, 0.0567486099898815, 0.0566457509994507, 0.0565431229770184, 0.0564405918121338, 0.056338332593441, 0.0562361069023609, 0.0561341010034084, 0.0560323484241962, 0.0559306256473064, 0.0558292306959629, 0.0557279884815216, 0.0556268952786922, 0.0555258989334106, 0.0554250590503216, 0.0553245171904564, 0.0552240274846554, 0.055123794823885, 0.0550236627459526, 0.0549236759543419, 0.0548240169882774, 0.0547243878245354, 0.0546250119805336, 0.0545257069170475, 0.0544267371296883, 0.0543277896940708, 0.0542290359735489, 0.0541305206716061, 0.0540320761501789, 0.0539339110255241, 0.0538358129560947, 0.0537379235029221, 0.0536402873694897, 0.0535426773130894, 0.053445391356945, 0.0533482357859612, 0.0532512292265892, 0.0531543456017971, 0.0530576445162296, 0.0529599115252495, 0.0528667643666267, 0.0527739748358727, 0.052681427448988, 0.0525891408324242, 0.0524970032274723, 0.0524052195250988, 0.0523135848343372, 0.052222203463316, 0.0521312281489372, 0.0520402528345585, 0.0519495271146297, 0.0518592037260532, 0.0517690852284431, 0.0516792684793472, 0.0515895076096058, 0.0515001863241196, 0.0514109805226326, 0.0513219684362411, 0.0512334182858467, 0.0511449128389359, 0.051056656986475, 0.0509687587618828, 0.0508809611201286, 0.050793569535017, 0.0507063753902912, 0.0506193861365318, 0.0505325943231583, 0.0504462122917175, 0.0503598712384701, 0.0502737946808338, 0.0501881167292595, 0.0501025840640068, 0.0500173158943653, 0.0499322898685932, 0.0498475171625614, 0.0497629009187222, 0.0496785826981068, 0.049594521522522, 0.0495106056332588, 0.0494272001087666, 0.0493436865508556, 0.0492605306208134, 0.0491777844727039, 0.0490950830280781, 0.0490127317607403, 0.0489306822419167, 0.0488487891852856, 0.0487670935690403, 0.0486857108771801, 0.0486045703291893, 0.0485235825181007, 0.0484430007636547, 0.0483625195920467, 0.0482822917401791, 0.0482024662196636, 0.0481226928532124, 0.0480431653559208, 0.0479639992117882, 0.0478850305080414, 0.0478062629699707, 0.0477278009057045, 0.0476495400071144, 0.0475714765489101, 0.0474938228726387, 0.0474162697792053, 0.0473388694226742, 0.047261867672205, 0.0471851192414761, 0.0471085719764233, 0.0470322296023369, 0.0469562336802483, 0.0468803457915783, 0.0468047074973583, 0.0467294715344906, 0.0466543436050415, 0.0465794615447521, 0.0465048849582672, 0.0464304611086845, 0.0463563874363899, 0.0462824627757072, 0.0462088920176029, 0.046135425567627, 0.0460624098777771, 0.0459893979132175, 0.045916635543108, 0.0458443239331245, 0.0457720756530762, 0.045700166374445, 0.0456284694373608, 0.0455569140613079, 0.0454857684671879, 0.045414824038744, 0.0453441329300404, 0.0452735908329487, 0.0452034026384354, 0.045133363455534, 0.0450635328888893, 0.0449940972030163, 0.0449247658252716, 0.0448504313826561, 0.0447841808199883, 0.0447179339826107, 0.0446518808603287, 0.0445862337946892, 0.0445207320153713, 0.0444552898406982, 0.0443902537226677, 0.0443252101540565, 0.0442604199051857, 0.0441957786679268, 0.0441315472126007, 0.0440673641860485, 0.0440033338963985, 0.0439397059381008, 0.0438760779798031, 0.0438128001987934, 0.0437496788799763, 0.0436866544187069, 0.0436239838600159, 0.043561365455389, 0.043498944491148, 0.0434368327260017, 0.0433748699724674, 0.0433131568133831, 0.0432515479624271, 0.0431902855634689, 0.0431290306150913, 0.0430680811405182, 0.0430073775351048, 0.0429468750953674, 0.0428864248096943, 0.0428263805806637, 0.042766384780407, 0.0427066422998905, 0.0426471009850502, 0.0425877645611763, 0.042528573423624, 0.0424696877598763, 0.0424109064042568, 0.0423523224890232, 0.042294092476368, 0.0422358624637127, 0.0421778820455074, 0.0421202145516872, 0.0420626848936081, 0.0420053154230118, 0.0419482477009296, 0.0418912284076214, 0.0418345108628273, 0.0417779982089996, 0.0417216382920742, 0.0416654795408249, 0.0416096188127995, 0.0415538139641285, 0.0414981581270695, 0.0414430052042007, 0.0413877554237843, 0.0413328558206558, 0.0412781052291393, 0.0412235595285892, 0.0411691628396511, 0.0411152243614197, 0.0410612300038338, 0.0410074964165688, 0.0409538075327873, 0.0409006215631962, 0.040847435593605, 0.0407944582402706, 0.0407418273389339, 0.0406892523169518, 0.0406368747353554, 0.0405847504734993, 0.0405328273773193, 0.0404810048639774, 0.0404295884072781, 0.0403782203793526, 0.0403271056711674, 0.0402762480080128, 0.0402254872024059, 0.0401749238371849, 0.0401246175169945, 0.040074460208416, 0.0400245562195778, 0.0399749055504799, 0.0399253517389297, 0.0398759581148624, 0.0398269109427929, 0.0397779159247875, 0.039729118347168, 0.0396806783974171, 0.0396323911845684, 0.0395841524004936, 0.0395363196730614, 0.0394886359572411, 0.0394410528242588, 0.039393775165081, 0.0393465906381607, 0.0392997115850449, 0.039253044873476, 0.0392121039330959, 0.0391665995121002, 0.0391212143003941, 0.0390759520232677, 0.0390306934714317, 0.0389854535460472, 0.0389404222369194, 0.0388955138623714, 0.0388506092131138, 0.0388058722019196, 0.0387612171471119, 0.0387165881693363, 0.0386720560491085, 0.0386276170611382, 0.0385832972824574, 0.0385390855371952, 0.0384948998689651, 0.0384508222341537, 0.0384068600833416, 0.0383629985153675, 0.0383192226290703, 0.0382755547761917, 0.0382318831980228, 0.0381883457303047, 0.0381449684500694, 0.0381016470491886, 0.0380584448575974, 0.0380152128636837, 0.0379721224308014, 0.0379291549324989, 0.0378862656652927, 0.0378434732556343, 0.0378008149564266, 0.0377581343054771, 0.0377156510949135, 0.0376731492578983, 0.037630844861269, 0.0375885330140591, 0.0375464521348476, 0.0375043712556362, 0.0374624095857143, 0.0374205224215984, 0.0373786762356758, 0.0373370088636875, 0.0372952930629253, 0.0372538678348064, 0.0372123643755913, 0.0371710136532784, 0.0371298044919968, 0.0370885618031025, 0.0370475277304649, 0.0370065197348595, 0.0369655676186085, 0.0369248352944851, 0.036884069442749, 0.0368435122072697, 0.0368029698729515, 0.036762423813343, 0.036722119897604, 0.0366818159818649, 0.0366417281329632, 0.0366015359759331, 0.0365616343915462, 0.0365216843783855, 0.0364817976951599, 0.0364421866834164, 0.0364024639129639, 0.0363629795610905, 0.0363234840333462, 0.0362840741872787, 0.0362448692321777, 0.0362056382000446, 0.0361666046082973, 0.0361276008188725, 0.0360885970294476, 0.0360498204827309, 0.0360110439360142, 0.0359723940491676, 0.0359339453279972, 0.0358954183757305, 0.0358570963144302, 0.0358187966048717, 0.0357805117964745, 0.0357424914836884, 0.035704467445612, 0.0356665849685669, 0.0356286950409412, 0.0355909243226051, 0.0355533733963966, 0.0355157181620598, 0.035478301346302, 0.0354408845305443, 0.0354035720229149, 0.0353664346039295, 0.0353293195366859, 0.0352923013269901, 0.0352553501725197, 0.0352185294032097, 0.0351817533373833, 0.0351450964808464, 0.0351060852408409, 0.035068217664957, 0.0350302942097187, 0.0349924005568027, 0.0349544808268547, 0.0349165350198746, 0.0348785929381847, 0.0348406359553337, 0.0348026752471924, 0.0347646810114384, 0.0347266979515553, 0.0346886664628983, 0.0346506610512733, 0.034612599760294, 0.0345745645463467, 0.0345365069806576, 0.0344984345138073, 0.0344603545963764, 0.0344222597777843, 0.034384161233902, 0.0343460291624069, 0.0343078933656216, 0.0342697352170944, 0.0342315845191479, 0.0341934151947498, 0.0341552346944809, 0.0341170467436314, 0.0340788476169109, 0.0340406373143196, 0.0340023897588253, 0.0339641571044922, 0.0339259095489979, 0.0338876359164715, 0.0338493511080742, 0.0338110513985157, 0.0337727554142475, 0.0337344445288181, 0.0336961075663567, 0.0336577855050564, 0.033619437366724, 0.0335810631513596, 0.0335426926612854, 0.0335042774677277, 0.0334658920764923, 0.0334274657070637, 0.0333890542387962, 0.0333506055176258, 0.0333121679723263, 0.0332736931741238, 0.0332352332770824, 0.0331967324018478, 0.0331582464277744, 0.0331197194755077, 0.0330811962485313, 0.0330426581203938, 0.0330040939152241, 0.0329655557870865, 0.032926969230175, 0.0328883938491344, 0.0328497923910618, 0.0328111909329891, 0.0327725633978844, 0.0327339395880699, 0.0326952897012234, 0.0326566360890865, 0.0326179452240467, 0.0325792841613293, 0.0325405821204185, 0.0325018912553787, 0.0324631407856941, 0.0324244126677513, 0.0323856733739376, 0.032346922904253, 0.0323081463575363, 0.0322693772614002, 0.0322305783629417, 0.032191775739193, 0.032152958214283, 0.0321141183376312, 0.0320752672851086, 0.0320364125072956, 0.0319975465536118, 0.0319586545228958, 0.0319197773933411, 0.0318808741867542, 0.0318419598042965, 0.0318030156195164, 0.0317640900611877, 0.0317251197993755, 0.0316861681640148, 0.0316471867263317, 0.0316082090139389, 0.0315691903233528, 0.0315301865339279, 0.0314911454916, 0.0314521156251431, 0.031413059681654, 0.031373992562294, 0.0313349366188049, 0.031295832246542, 0.0312511883676052, 0.0312098748981953, 0.0311685372143984, 0.0311271343380213, 0.0310856979340315, 0.0310442205518484, 0.0310026928782463, 0.0309611279517412, 0.0309194978326559, 0.0308778453618288, 0.0308361276984215, 0.0307943746447563, 0.030752569437027, 0.0307107269763947, 0.0306688323616982, 0.0306268911808729, 0.0305849090218544, 0.030542865395546, 0.0305008068680763, 0.0304586738348007, 0.0304165408015251, 0.0303742922842503, 0.0303320605307817, 0.0302897244691849, 0.0302473921328783, 0.0302050057798624, 0.0301625318825245, 0.0301200710237026, 0.0300775337964296, 0.0300349611788988, 0.0299923215061426, 0.0299496743828058, 0.0299069471657276, 0.0298642087727785, 0.0298213828355074, 0.0297785308212042, 0.0297356527298689, 0.0296927001327276, 0.0296497214585543, 0.0296067073941231, 0.0295636262744665, 0.0295204967260361, 0.0294773317873478, 0.0294340997934341, 0.0293908566236496, 0.0293475389480591, 0.0293042194098234, 0.0292607881128788, 0.0292173679918051, 0.0291738584637642, 0.0291303396224976, 0.0290867555886507, 0.0290430951863527, 0.028999449685216, 0.0289557259529829, 0.028911966830492, 0.028868155553937, 0.0288243070244789, 0.0287803970277309, 0.0287364739924669, 0.0286924596875906, 0.0286484342068434, 0.0286043584346771, 0.0285602211952209, 0.0285160560160875, 0.0284718163311481, 0.0284275636076927, 0.0283832624554634, 0.0283389110118151, 0.0282945055514574, 0.0282500647008419, 0.0282055605202913, 0.0281610172241926, 0.0281164478510618, 0.0280718058347702, 0.0280271507799625, 0.0279824081808329, 0.0279376748949289, 0.027892829850316, 0.0278479997068644, 0.0278030764311552, 0.0277581438422203, 0.0277131479233503, 0.0276681017130613, 0.0276230163872242, 0.027577880769968, 0.0275327060371637, 0.0274874828755856, 0.0274422336369753, 0.0273969098925591, 0.0273515731096268, 0.0273061487823725, 0.0272607244551182, 0.0272152088582516, 0.0271696578711271, 0.0271240808069706, 0.0270784422755241, 0.0270327646285295, 0.026987049728632, 0.0269412826746702, 0.0268982462584972, 0.0268512312322855, 0.0268041882663965, 0.0267571490257978, 0.026710094884038, 0.0266630202531815, 0.0266159400343895, 0.0265688393265009, 0.0265217460691929, 0.0264746192842722, 0.0264274906367064, 0.0263803638517857, 0.0263331960886717, 0.0262860283255577, 0.026238864287734, 0.0261916592717171, 0.0261444672942162, 0.0260972511023283, 0.0260500218719244, 0.0260027926415205, 0.0259555522352457, 0.0259082838892937, 0.0258610155433416, 0.0258137229830027, 0.0257664322853088, 0.0257191397249699, 0.0256717968732119, 0.0256244651973248, 0.0255771223455667, 0.0255297664552927, 0.0254823882132769, 0.0254350081086159, 0.0253876261413097, 0.0253402087837458, 0.0252928007394075, 0.0252453703433275, 0.0251979269087315, 0.0251504704356194, 0.0251030139625072, 0.0250555314123631, 0.025008050724864, 0.0249605439603329, 0.0249130260199308, 0.0248655155301094, 0.0248179584741592, 0.0247704274952412, 0.024722857400775, 0.0246752742677927, 0.0246277041733265, 0.0245800986886024, 0.024532500654459, 0.0244848690927029, 0.0244372375309467, 0.0243895929306746, 0.0243419446051121, 0.0242942627519369, 0.0242466051131487, 0.0241988841444254, 0.024151187390089, 0.0241034906357527, 0.0240557435899973, 0.024008022621274, 0.0239602383226156, 0.0239124912768602, 0.0238647218793631, 0.0238169226795435, 0.0237691253423691, 0.0237213149666786, 0.0236734822392464, 0.0236256457865238, 0.0235778000205755, 0.023529939353466, 0.0234820675104856, 0.0234341807663441, 0.0233862847089767, 0.0233383867889643, 0.0232904609292746, 0.0232425276190042, 0.0231945663690567, 0.0231466293334961, 0.0230986662209034, 0.0230506714433432, 0.0230026971548796, 0.0229546837508678, 0.0229066628962755, 0.0228586364537477, 0.0228106006979942, 0.0227625388652086, 0.0227144882082939, 0.0226664040237665, 0.0226183161139488, 0.0225702151656151, 0.0225221030414104, 0.0224739778786898, 0.022425839677453, 0.0223777014762163, 0.0223295390605927, 0.0222813636064529, 0.0222331881523132, 0.0221849754452705, 0.0221383459866047, 0.0220904462039471, 0.0220425128936768, 0.0219947267323732, 0.021946894004941, 0.0218991339206696, 0.0218514502048492, 0.0218037534505129, 0.0217561330646276, 0.0217085126787424, 0.0216609928756952, 0.021613422781229, 0.021565979346633, 0.021518575027585, 0.0214711427688599, 0.0214238110929728, 0.0213764943182468, 0.02132922783494, 0.021281972527504, 0.021234817802906, 0.0211876779794693, 0.0211405623704195, 0.0210935100913048, 0.0210464559495449, 0.0209995042532682, 0.0209525525569916, 0.0209056250751019, 0.0208588000386953, 0.0208119489252567, 0.0207651741802692, 0.0207183863967657, 0.0206717364490032, 0.0206250641494989, 0.0205784495919943, 0.0205318778753281, 0.0204853024333715, 0.0204388331621885, 0.0203923340886831, 0.0203459355980158, 0.0202995911240578, 0.0202532187104225, 0.0202069245278835, 0.0201606918126345, 0.0201144702732563, 0.0200682878494263, 0.0200221445411444, 0.0199760757386684, 0.0199299920350313, 0.0198840126395226, 0.0198380183428526, 0.0197921004146338, 0.0197461843490601, 0.0197003427892923, 0.0196545775979757, 0.0196087844669819, 0.0195630565285683, 0.0195173285901546, 0.01947171241045, 0.0194261502474546, 0.019380547106266, 0.0193350724875927, 0.019289530813694, 0.0192441195249557, 0.0191986821591854, 0.019153319299221, 0.0191080328077078, 0.0190627463161945, 0.0190175361931324, 0.0189722962677479, 0.018927151337266, 0.0188819915056229, 0.0188369546085596, 0.0187919326126575, 0.0187468994408846, 0.0187019892036915, 0.0186570174992085, 0.0186121743172407, 0.0185673031955957, 0.0185225587338209, 0.0184777993708849, 0.0184330698102713, 0.0183884389698505, 0.0183437578380108, 0.0182992033660412, 0.0182546488940716, 0.018210144713521, 0.0181656386703253, 0.0181212481111288, 0.0180768817663193, 0.0180324912071228, 0.0179882124066353, 0.0179439224302769, 0.0178997088223696, 0.0178555063903332, 0.0178113672882318, 0.0177672915160656, 0.0177232157438993, 0.0176791902631521, 0.017635190859437, 0.0175912920385599, 0.0175469275563955, 0.0175039116293192, 0.017460972070694, 0.0174180306494236, 0.0173752438277006, 0.0173325296491385, 0.0172898657619953, 0.0172472037374973, 0.0172047186642885, 0.0171622559428215, 0.0171198956668377, 0.017077611759305, 0.0170353017747402, 0.0169931687414646, 0.016951035708189, 0.0169090796262026, 0.0168671477586031, 0.0168252438306808, 0.0167834367603064, 0.0167416576296091, 0.0167001057416201, 0.0166585016995668, 0.0166169498115778, 0.0165754985064268, 0.0165341217070818, 0.016492897644639, 0.0164515972137451, 0.0164104476571083, 0.0163694247603416, 0.016328351572156, 0.0162875056266785, 0.0162465833127499, 0.0162058118730783, 0.0161650665104389, 0.0161244235932827, 0.0160839054733515, 0.0160433612763882, 0.0160029679536819, 0.0159625262022018, 0.0159222856163979, 0.0158820692449808, 0.0158419292420149, 0.0158018916845322, 0.0157618764787912, 0.0157219395041466, 0.0156821012496948, 0.0156423393636942, 0.0156025793403387, 0.0155629692599177, 0.0155234094709158, 0.0154839251190424, 0.0154445162042975, 0.0154051585122943, 0.0153658511117101, 0.015326670370996, 0.0152875911444426, 0.0152485109865665, 0.0152095053344965, 0.0151706030592322, 0.0151317240670323, 0.0150930220261216, 0.015054295770824, 0.0150156943127513, 0.0149770937860012, 0.0149386189877987, 0.0149002699181437, 0.0148618966341019, 0.0148236742243171, 0.0147854248061776, 0.0147473551332951, 0.0147093087434769, 0.0146713145077229, 0.0146334450691938, 0.0145955746993423, 0.014557832852006, 0.0145201645791531, 0.0144825465977192, 0.0144449817016721, 0.0144075155258179, 0.0143701508641243, 0.0143328113481402, 0.0142955724149942, 0.0142583847045898, 0.0142212733626366, 0.0141842868179083, 0.0141473254188895, 0.0141104152426124, 0.0140735795721412, 0.0140368454158306, 0.0140001373365521, 0.0139635810628533, 0.0139270732179284, 0.0138905663043261, 0.0138542111963034, 0.0138178560882807, 0.013781676068902, 0.0137454718351364, 0.0137093951925635, 0.0136733669787645, 0.0136373899877071, 0.0136017901822925, 0.0135665684938431, 0.013531475327909, 0.0134964063763618, 0.0134614137932658, 0.0134265972301364, 0.013391780667007, 0.0133570143952966, 0.0133223505690694, 0.013287759386003, 0.0132532455027103, 0.0132188592106104, 0.0131844719871879, 0.0131501341238618, 0.013115948997438, 0.0130818393081427, 0.0130478292703629, 0.0130137959495187, 0.0129798864945769, 0.012946080416441, 0.0129123236984015, 0.0128786424174905, 0.0128450626507401, 0.0128114819526672, 0.012778002768755, 0.0127447256818414, 0.0127113973721862, 0.0126781966537237, 0.0126449931412935, 0.0126119190827012, 0.0125789688900113, 0.0125460447743535, 0.0125131700187922, 0.0124804228544235, 0.0124477008357644, 0.0124151045456529, 0.0123826088383794, 0.012350088916719, 0.0123177198693156, 0.0122854001820087, 0.0122531577944756, 0.0122210411354899, 0.0121889486908913, 0.0121569093316793, 0.0121249686926603, 0.0120930774137378, 0.0120613146573305, 0.0120296515524387, 0.0119979893788695, 0.0119664277881384, 0.0119349407032132, 0.0119035802781582, 0.0118721965700388, 0.0118409879505634, 0.0118097783997655, 0.0117786712944508, 0.0117476899176836, 0.0117166824638844, 0.0116858519613743, 0.0116550214588642, 0.0116243176162243, 0.011593715287745, 0.0115630868822336, 0.0115325842052698, 0.0115021578967571, 0.011471857316792, 0.0114416070282459, 0.0114113576710224, 0.0113812340423465, 0.0113512361422181, 0.0113212633877993, 0.0112913670018315, 0.0112615721300244, 0.0112318014726043, 0.0112021053209901, 0.0111725879833102, 0.0111430436372757, 0.0111136017367244, 0.0110842604190111, 0.0110549172386527, 0.0110257780179381, 0.010996637865901, 0.0109675489366055, 0.010938610881567, 0.0109096728265285, 0.0108808865770698, 0.0108521254733205, 0.0108234146609902, 0.0107948044314981, 0.0107662947848439, 0.0107378605753183, 0.0107095036655664, 0.0106811709702015, 0.0106529146432877, 0.0106248082593083, 0.0105967298150063, 0.0105687249451876, 0.0105408215895295, 0.0105129685252905, 0.0104851396754384, 0.0104613956063986, 0.0104339709505439, 0.0104066738858819, 0.0103793991729617, 0.0103521766141057, 0.0103250797837973, 0.0102979587391019, 0.0102709634229541, 0.0102439941838384, 0.0102170994505286, 0.0101902550086379, 0.0101635130122304, 0.0101368185132742, 0.0101101780310273, 0.0100835859775543, 0.0100570693612099, 0.0100306291133165, 0.0100041897967458, 0.00997782498598099, 0.00995161104947329, 0.00992537196725607, 0.00989921018481255, 0.0098731741309166, 0.00984716136008501, 0.00982119981199503, 0.00979529041796923, 0.00976948067545891, 0.00974367093294859, 0.0097179627045989, 0.00969232991337776, 0.00966672040522099, 0.0096412654966116, 0.00961575750261545, 0.00959040317684412, 0.00956502184271812, 0.00953979231417179, 0.00951458793133497, 0.00948938447982073, 0.00946430675685406, 0.00943925324827433, 0.00941435247659683, 0.00938945170491934, 0.00936462543904781, 0.00933977495878935, 0.00931517593562603, 0.00929045118391514, 0.0092658270150423, 0.00924135465174913, 0.00921688228845596, 0.00919248536229134, 0.00916813965886831, 0.00914389360696077, 0.00911967363208532, 0.00909547880291939, 0.00907140970230103, 0.00904739182442427, 0.00902339816093445, 0.00899948086589575, 0.0089756902307272, 0.00895187351852655, 0.00892815738916397, 0.00890451762825251, 0.00888092815876007, 0.00885736383497715, 0.00883392617106438, 0.00881051365286112, 0.00878720171749592, 0.00876391492784023, 0.00874067842960358, 0.00871754344552755, 0.00869440753012896, 0.00867134891450405, 0.00864844024181366, 0.00862550642341375, 0.00860264897346497, 0.00857991725206375, 0.00855716038495302, 0.00853453017771244, 0.00851194933056831, 0.00848939456045628, 0.00846691522747278, 0.00844451133161783, 0.0084221325814724, 0.0083999065682292, 0.00837762840092182, 0.00835547689348459, 0.00833340175449848, 0.0083113256841898, 0.0082894517108798, 0.00826745200902224, 0.00824562832713127, 0.00822385586798191, 0.008202132768929, 0.00818043667823076, 0.00815888959914446, 0.00813731923699379, 0.00811582338064909, 0.00809448026120663, 0.00807305984199047, 0.00805184245109558, 0.00802742317318916, 0.0080060800537467, 0.00798470992594957, 0.00796344224363565, 0.00794226210564375, 0.00792103074491024, 0.00789988879114389, 0.0078788734972477, 0.00785779394209385, 0.00783681590110064, 0.00781587511301041, 0.00779499812051654, 0.00777413323521614, 0.00775336939841509, 0.00773259252309799, 0.0077118668705225, 0.00769125437363982, 0.00767060462385416, 0.00765008060261607, 0.00762954354286194, 0.00760913267731667, 0.00758869759738445, 0.00756836216896772, 0.00754800206050277, 0.0075277304276824, 0.00750752165913582, 0.00748731289058924, 0.00746722985059023, 0.0074471477419138, 0.00742712803184986, 0.00740712136030197, 0.0073872022330761, 0.00736727146431804, 0.00734746642410755, 0.00732768652960658, 0.00730791920796037, 0.00728824036195874, 0.00726857455447316, 0.00724900839850307, 0.00722944317385554, 0.00720989052206278, 0.0071905143558979, 0.00717104971408844, 0.00715172430500388, 0.00713238585740328, 0.00711313588544726, 0.00709389802068472, 0.00707477470859885, 0.00705559970811009, 0.00703653879463673, 0.00701752910390496, 0.00699851848185062, 0.00697962148115039, 0.0069607119075954, 0.00694191642105579, 0.00692312093451619, 0.0069044129922986, 0.00688568037003279, 0.00686703575775027, 0.00684845447540283, 0.00682988576591015, 0.00681141763925552, 0.00679293647408485, 0.0067745572887361, 0.00675620324909687, 0.00673791160807014, 0.00671962043270469, 0.00670141773298383, 0.00668327743187547, 0.00666515016928315, 0.00664709834381938, 0.00662905955687165, 0.00661112135276198, 0.00659317057579756, 0.0065752575173974, 0.00655745854601264, 0.00653965910896659, 0.00652196072041988, 0.00650425022467971, 0.00648661470040679, 0.00646905461326241, 0.00645152013748884, 0.00643399776890874, 0.00641655270010233, 0.00639919470995665, 0.00638182368129492, 0.00636447919532657, 0.00634728511795402, 0.00633004074916244, 0.00631292257457972, 0.00629577925428748, 0.00627874955534935, 0.00626171939074993, 0.00624471483752131, 0.00622783647850156, 0.00621094554662704, 0.00619415566325188, 0.00617735274136066, 0.0061606508679688, 0.00614392384886742, 0.00612666737288237, 0.00610988959670067, 0.00609313743188977, 0.00607646070420742, 0.00605978397652507, 0.00604315800592303, 0.00602659489959478, 0.00601004483178258, 0.00599354412406683, 0.00597712025046349, 0.0059606833383441, 0.00594432186335325, 0.00592799857258797, 0.00591168785467744, 0.00589549029245973, 0.00587926805019379, 0.00586310867220163, 0.00584698701277375, 0.00583090353757143, 0.00581485731527209, 0.00579886185005307, 0.00578290456905961, 0.00576695939525962, 0.00575111620128155, 0.00573527161031961, 0.005719477776438, 0.00570372212678194, 0.00568800466135144, 0.0056723621673882, 0.00565670756623149, 0.00564111582934856, 0.00562557438388467, 0.00561007112264633, 0.00559457996860147, 0.0055792024359107, 0.00556381279602647, 0.00554847344756126, 0.00553319696336985, 0.00551790790632367, 0.00550270732492208, 0.00548751978203654, 0.00547238206490874, 0.00545730767771602, 0.00544224539771676, 0.00542723387479782, 0.00541226100176573, 0.00539732491597533, 0.00538241444155574, 0.0053676045499742, 0.0053527825511992, 0.00533801084384322, 0.00532331457361579, 0.00530861783772707, 0.00529398489743471, 0.00527940271422267, 0.00526484521105886, 0.00525033846497536, 0.00523584429174662, 0.0052214004099369, 0.00520703196525574, 0.00519266445189714, 0.00517833419144154, 0.00516409194096923, 0.00514985015615821, 0.00513565866276622, 0.00512151746079326, 0.00510741444304585, 0.00509333657100797, 0.00507932109758258, 0.00506535731256008, 0.00505143078044057, 0.00503750424832106, 0.00502362800762057, 0.00500986492261291, 0.00499607715755701, 0.00498232711106539, 0.00496867764741182, 0.00495500396937132, 0.00494136707857251, 0.00492781912907958, 0.00491428375244141, 0.0049007860943675, 0.00488735176622868, 0.00487395422533154, 0.00486059533432126, 0.00484726158902049, 0.00483396649360657, 0.00482075894251466, 0.0048075383529067, 0.00479436852037907, 0.00478128716349602, 0.00476819323375821, 0.00475516216829419, 0.00474219443276525, 0.0047292266972363, 0.00471630925312638, 0.00470345467329025, 0.00469061266630888, 0.00467782141640782, 0.00466509396210313, 0.00465486664324999, 0.00464221369475126, 0.0046295989304781, 0.00461700931191444, 0.00460445834323764, 0.00459196977317333, 0.00457949377596378, 0.00456710625439882, 0.00455471873283386, 0.00454236892983317, 0.004530044272542, 0.0045177829451859, 0.00450557190924883, 0.0044933739118278, 0.00448121316730976, 0.00446910317987204, 0.00445700576528907, 0.00444495864212513, 0.00443293713033199, 0.00442097848281264, 0.00440904498100281, 0.004397161770612, 0.00438531674444675, 0.00437349686399102, 0.0043617021292448, 0.00434997025877237, 0.0043382765725255, 0.00432663317769766, 0.00431501492857933, 0.00430340971797705, 0.00429186737164855, 0.00428037578240037, 0.00426889630034566, 0.00425746710970998, 0.00424606399610639, 0.00423471024259925, 0.0042233825661242, 0.00421210471540689, 0.00420085294172168, 0.0041896509937942, 0.00417848723009229, 0.00416733557358384, 0.00415624724701047, 0.00414519663900137, 0.00413418421521783, 0.00412320950999856, 0.00411227252334356, 0.00410137372091413, 0.00409049959853292, 0.00407967669889331, 0.00406889105215669, 0.00405819388106465, 0.00404748367145658, 0.00403681211173534, 0.0040261778049171, 0.00401556864380836, 0.00400499766692519, 0.00399447698146105, 0.00398399448022246, 0.00397356227040291, 0.00396314216777682, 0.0039527858607471, 0.0039424542337656, 0.00393216079100966, 0.003921905066818, 0.00391168752685189, 0.00390150723978877, 0.00389136536978185, 0.00388124794699252, 0.00387118174694479, 0.00386116560548544, 0.00385119998827577, 0.00384128489531577, 0.00383135699667037, 0.00382147962227464, 0.00381165323778987, 0.00380186410620809, 0.00379208801314235, 0.00378237455151975, 0.00377268646843731, 0.00376303633674979, 0.00375342392362654, 0.00374384946189821, 0.0037343252915889, 0.00372483907267451, 0.00371536565944552, 0.00370596791617572, 0.00369659485295415, 0.00368724763393402, 0.00367793790064752, 0.0036687043029815, 0.00365947023965418, 0.00365026155486703, 0.00364115345291793, 0.00363204604946077, 0.00362296332605183, 0.00361391855403781, 0.00360492430627346, 0.00359596800990403, 0.00358704919926822, 0.00357705308124423, 0.00356823555193841, 0.00355946854688227, 0.00355075183324516, 0.0035420476924628, 0.00353338127024472, 0.00352474022656679, 0.00351614947430789, 0.00350759690627456, 0.00349908205680549, 0.0034905921202153, 0.00348210288211703, 0.00347368861548603, 0.00346532510593534, 0.0034569741692394, 0.00344862346537411, 0.00344034796580672, 0.00343208527192473, 0.00342387333512306, 0.0034156737383455, 0.00340751209296286, 0.00339938816614449, 0.00339128961786628, 0.00338325393386185, 0.00337523128837347, 0.00336722075007856, 0.00335928634740412, 0.00335137662477791, 0.00334346760064363, 0.00333562097512186, 0.00332780019380152, 0.00332000409252942, 0.00331225874833763, 0.00330451340414584, 0.00329684349708259, 0.00328919920139015, 0.00328157981857657, 0.00327403633855283, 0.00326645490713418, 0.00325894914567471, 0.00325146852992475, 0.00324402586556971, 0.00323658320121467, 0.00322920386679471, 0.00322186201810837, 0.00321453274227679, 0.00320726702921093, 0.00319998804479837, 0.0031927851960063, 0.00318560772575438, 0.00317846750840545, 0.00317136547528207, 0.00316426367498934, 0.00315722450613976, 0.00315022328868508, 0.00314323487691581, 0.00313627161085606, 0.00312937120907009, 0.00312252156436443, 0.00311565911397338, 0.00310887233354151, 0.00310207321308553, 0.00309532438404858, 0.00308863865211606, 0.0030819654930383, 0.0030753172468394, 0.00306869461201131, 0.00306212226860225, 0.00305557553656399, 0.00304907886311412, 0.00304256984964013, 0.00303613627329469, 0.00302974064834416, 0.00302337016910315, 0.00301703764125705, 0.00301071768626571, 0.0030044480226934, 0.00299820397049189, 0.00299203535541892, 0.00298586674034595, 0.00297971093095839, 0.00297360518015921, 0.00296752527356148, 0.00296150776557624, 0.0029554907232523, 0.00294951163232327, 0.00294358213432133, 0.00293767871335149, 0.00293182558380067, 0.00292597245424986, 0.00292016961611807, 0.0029144047293812, 0.00290867756120861, 0.00290297553874552, 0.00289727398194373, 0.00289166043512523, 0.00288605946116149, 0.00288050924427807, 0.00287498370744288, 0.00286948401480913, 0.00286395172588527, 0.0028585777617991, 0.00285319145768881, 0.00284781772643328, 0.00284251966513693, 0.00283720856532454, 0.00283196102827787, 0.00282671302556992, 0.002821478061378, 0.00281631876714528, 0.00281115924008191, 0.00280601251870394, 0.0028009288944304, 0.00279584503732622, 0.00279081193730235, 0.00278579141013324, 0.00278078322298825, 0.00277582556009293, 0.00277089327573776, 0.00276597356423736, 0.00276111671701074, 0.00275624776259065, 0.00275139068253338, 0.002746622543782, 0.00274184159934521, 0.00273707322776318, 0.00273235538043082, 0.00272767501883209, 0.00272302026860416, 0.00271839066408575, 0.00271378643810749, 0.00270918197929859, 0.00270465342327952, 0.00270012486726046, 0.00269563402980566, 0.00269113038666546, 0.0026867026463151, 0.00268227513879538, 0.00267792283557355, 0.00267354561947286, 0.00266919331625104, 0.00266491714864969, 0.00266061560250819, 0.00265640206634998, 0.00265213847160339, 0.00264795031398535, 0.00264377472922206, 0.00263966247439384, 0.00263553741388023, 0.00263145030476153, 0.0026274009142071, 0.00262335175648332, 0.00261937803588808, 0.00261537916958332, 0.00261143082752824, 0.00260749529115856, 0.00260362238623202, 0.00259974971413612, 0.0025959147606045, 0.00259210518561304, 0.00258832075633109, 0.00258457404561341, 0.00258084037341177, 0.00257711880840361, 0.00257346057333052, 0.00256981491111219, 0.00256619462743402, 0.00256262440234423, 0.00255904207006097, 0.00255551002919674, 0.00255201570689678, 0.00254853395745158, 0.00254506501369178, 0.00254163378849626, 0.002538240281865, 0.00253488472662866, 0.00253154197707772, 0.0025282243732363, 0.00252491934224963, 0.0025216774083674, 0.0025184229016304, 0.00251524359919131, 0.00251203984953463, 0.00250888615846634, 0.00250577018596232, 0.00250267959199846, 0.00249958876520395, 0.00249657407402992, 0.00249354657717049, 0.00249059475027025, 0.00248759239912033, 0.00248467829078436, 0.00248176441527903, 0.00247890083119273, 0.00247601210139692, 0.00247322442010045, 0.0024704490788281, 0.00246766116470098, 0.0024649491533637, 0.00246219919063151, 0.00246005598455667, 0.00245744455605745, 0.00245490274392068, 0.00245232949964702, 0.00244980026036501, 0.00244728988036513, 0.00244479207322001, 0.00244231964461505, 0.00243982812389731, 0.00243741250596941, 0.00243498431518674, 0.00243260618299246, 0.00243019056506455, 0.00242784433066845, 0.00242551695555449, 0.0024231958668679, 0.00242088735103607, 0.002418591408059, 0.00241632736288011, 0.00241408799774945, 0.00241185538470745, 0.00240962859243155, 0.00240745884366333, 0.00240528932772577, 0.00240314495749772, 0.00240101269446313, 0.00239889393560588, 0.0023968059103936, 0.00239473092369735, 0.002392687369138, 0.00239063752815127, 0.00238862540572882, 0.00238665123470128, 0.00238466425798833, 0.00238272175192833, 0.00238076620735228, 0.00237884884700179, 0.00237695034593344, 0.00237507093697786, 0.00237319129519165, 0.00237136846408248, 0.00236953934654593, 0.00236773560754955, 0.00236596935428679, 0.0023641842417419, 0.00236246874555945, 0.0023607152979821, 0.00235901866108179, 0.00235731573775411, 0.00235566962510347, 0.0023540104739368, 0.00235237716697156, 0.00235078763216734, 0.00234918529167771, 0.00234762742184103, 0.00234603811986744, 0.00234453077428043, 0.00234300456941128, 0.00234152842313051, 0.00234003365039825, 0.00233858916908503, 0.00233716401271522, 0.00233573815785348, 0.00233435700647533, 0.00233294419012964, 0.00233160727657378, 0.00233024451881647, 0.00232894532382488, 0.00232763960957527, 0.0023263655602932, 0.00232509151101112, 0.00232385541312397, 0.00232262536883354, 0.00232143327593803, 0.00232023489661515, 0.00231908075511456, 0.00231790752150118, 0.00231679133139551, 0.0023156872484833, 0.00231459620408714, 0.00231353030540049, 0.0023124641738832, 0.00231144251301885, 0.00231043342500925, 0.00230943039059639, 0.00230845273472369, 0.00230750045739114, 0.00230659847147763, 0.00230565876699984, 0.0023047502618283, 0.00230388017371297, 0.00230302847921848, 0.00230218330398202, 0.00230135698802769, 0.00230054976418614, 0.00229978025890887, 0.00229901704005897, 0.00229826639406383, 0.00229756627231836, 0.00229684729129076, 0.00229607475921512, 0.00229540443979204, 0.00229475181549788, 0.0022941161878407, 0.00229348707944155, 0.00229286425746977, 0.00229224446229637, 0.00229164236225188, 0.00229104771278799, 0.00229046284221113, 0.00228987750597298, 0.00228931778110564, 0.00228875502943993, 0.00228821090422571, 0.00228766701184213, 0.00228714500553906, 0.00228661671280861, 0.00228611216880381, 0.00228561391122639, 0.00228511402383447, 0.00228463159874082, 0.00228416174650192, 0.00228370283730328, 0.00228323601186275, 0.00228278827853501, 0.00228235777467489, 0.00228193844668567, 0.00228150794282556, 0.00228109955787659, 0.00228070840239525, 0.00228032516315579, 0.00227994518354535, 0.0022795635741204, 0.00227920711040497, 0.00227885576896369, 0.00227851653471589, 0.00227817753329873, 0.00227785436436534, 0.0022775421384722, 0.00227723619900644, 0.00227693654596806, 0.00227665272541344, 0.00227638171054423, 0.00227611046284437, 0.00227584387175739, 0.00227559939958155, 0.0022753644734621, 0.00227513117715716, 0.00227491674013436, 0.00227469601668417, 0.00227449275553226, 0.00227430649101734, 0.00227412674576044, 0.00227394537068903, 0.0022737814579159, 0.00227363011799753, 0.0022734897211194, 0.0022733414079994, 0.00227321218699217, 0.00227310019545257, 0.00227299286052585, 0.0022729046177119, 0.00227279751561582, 0.002272724872455, 0.0022726571187377, 0.00227260356768966, 0.0022725339513272, 0.00227249623276293, 0.00227246480062604, 0.00227244268171489, 0.00227241427637637, 0.00227241753600538, 0.00227242382243276, 0.00227243639528751, 0.00227246177382767, 0.00227248994633555, 0.00227253092452884, 0.00227258447557688, 0.00227264943532646, 0.00227271066978574, 0.00227279122918844, 0.00227287947200239, 0.0022729835473001, 0.00227307644672692, 0.00227320287376642, 0.00227332417853177, 0.00227346597239375, 0.0022736000828445, 0.00227375142276287, 0.00227391696535051, 0.00227409834042192, 0.00227427179925144, 0.00227447040379047, 0.00227467389777303, 0.00227487576194108, 0.00227509648539126, 0.00227532815188169, 0.00227557099424303, 0.00227580755017698, 0.00227606133557856, 0.0022761132568121, 0.00227612908929586, 0.00227615120820701, 0.00227617006748915, 0.00227620173245668, 0.00227623316459358, 0.00227627111598849, 0.0022763058077544, 0.00227635609917343, 0.00227640336379409, 0.00227645714767277, 0.00227651395834982, 0.00227658008225262, 0.00227664317935705, 0.00227671884931624, 0.00227678823284805, 0.00227687042206526, 0.00227695214562118, 0.00227704364806414, 0.00227712886407971, 0.00227722665295005, 0.00227732746861875, 0.00227742828428745, 0.00227753887884319, 0.00227765226736665, 0.00227777217514813, 0.00227788905613124, 0.00227802130393684, 0.0022781474981457, 0.00227828300558031, 0.00227842177264392, 0.00227856682613492, 0.00227870885282755, 0.0022788664791733, 0.00227901781909168, 0.00227918196469545, 0.00227934587746859, 0.00227951630949974, 0.00227968324907124, 0.00227986625395715, 0.00228004297241569, 0.00228023203089833, 0.00228042132221162, 0.00228061666712165, 0.00228081247769296, 0.00228101736865938, 0.00228122249245644, 0.0022814366966486, 0.00228164810687304, 0.00228187185712159, 0.00228209281340241, 0.00228232285007834, 0.00228255311958492, 0.00228279293514788, 0.00228302925825119, 0.00228328164666891, 0.00228352774865925, 0.00228378316387534, 0.00228403857909143, 0.00228430354036391, 0.00228456524200737, 0.00228484277613461, 0.00228511402383447, 0.00228539458476007, 0.00228567840531468, 0.00228596851229668, 0.0022862555924803, 0.00228655524551868, 0.00228685489855707, 0.0022871638648212, 0.00228746654465795, 0.00228778505697846, 0.00228810054250062, 0.00228842534124851, 0.00228875013999641, 0.00228908122517169, 0.00228941231034696, 0.00228975620120764, 0.0022900968324393, 0.00229044677689672, 0.00229079695418477, 0.00229115644469857, 0.00229151290841401, 0.00229188171215355, 0.00229224748909473, 0.0022926228120923, 0.00229299813508987, 0.00229338300414383, 0.00229376438073814, 0.00229415553621948, 0.00229454971849918, 0.00229495042003691, 0.00229535065591335, 0.00229576393030584, 0.0022961706854403, 0.00229658698663116, 0.00229700654745102, 0.00229743542149663, 0.00229785800911486, 0.00229829619638622, 0.00229872833006084, 0.00229917303659022, 0.00229961751028895, 0.00230007176287472, 0.00230051949620247, 0.00230098329484463, 0.00230144360102713, 0.00230191042646766, 0.00230238330550492, 0.00230285990983248, 0.00230333604849875, 0.00230381521396339, 0.00230431044474244, 0.00230479589663446, 0.00230529741384089, 0.00230579567141831, 0.00230630347505212, 0.00230680801905692, 0.00230732862837613, 0.00230784248560667, 0.00230836612172425, 0.00230889278464019, 0.00230942550115287, 0.00230995542369783, 0.00231050094589591, 0.00231104041449726, 0.00231159222312272, 0.00231214100494981, 0.00231270235963166, 0.00231325742788613, 0.00231382809579372, 0.00231439271010458, 0.00231496966443956, 0.0023155405651778, 0.00231613032519817, 0.00231671053916216, 0.0023173033259809, 0.0023178996052593, 0.00231849867850542, 0.00231909798458219, 0.00231971289031208, 0.00232031848281622, 0.00232093664817512, 0.00232155784033239, 0.00232218531891704, 0.00232280977070332, 0.002323447028175, 0.00232408056035638, 0.00232472410425544, 0.00232537044212222   }, 
   { 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 1.72498675965471e-06, 3.88617263524793e-06, 6.04735851084115e-06, 8.28785414341837e-06, 1.06274856079835e-05, 1.29869458760368e-05, 1.54455410665832e-05, 1.79636208486045e-05, 2.05411815841217e-05, 2.31980520766228e-05, 2.59540574916173e-05, 2.86704107566038e-05, 3.1565210520057e-05, 3.44798354490194e-05, 3.74142873624805e-05, 4.05073624278884e-05, 4.35806032328401e-05, 4.67926474811975e-05, 5.00245078001171e-05, 5.33555103174876e-05, 5.6706336181378e-05, 6.01563006057404e-05, 6.36855766060762e-05, 6.72346723149531e-05, 7.08829174982384e-05, 7.46302903280593e-05, 7.83578361733817e-05, 8.22440124466084e-05, 8.61698281369172e-05, 9.00956511031836e-05, 9.41404359764419e-05, 9.82248820946552e-05, 0.000102408463135362, 0.000106671344838105, 0.000110973887785804, 0.00011533590441104, 0.000119777250802144, 0.000124278056318872, 0.000128818544908427, 0.000133458146592602, 0.000138196890475228, 0.000142935619805939, 0.000147813159856014, 0.000152710534166545, 0.000157667382154614, 0.000162723357789218, 0.000167779333423823, 0.000172954285517335, 0.0001781887258403, 0.00018350244499743, 0.000188836012966931, 0.000194288542843424, 0.000199780741240829, 0.000205312564503402, 0.000210963378776796, 0.000216673666727729, 0.000222403774387203, 0.000228272678214125, 0.000234161416301504, 0.000240109642618336, 0.000246156967477873, 0.000252224155701697, 0.000258390471572056, 0.000264616246568039, 0.000270921387709677, 0.000277246290352196, 0.000283710047369823, 0.000290193594992161, 0.000296736630843952, 0.000303358974633738, 0.00031006065546535, 0.000316782097797841, 0.000323662214213982, 0.000330502633005381, 0.000337481906171888, 0.000344500789651647, 0.000351618800777942, 0.000358736870111898, 0.000365973828593269, 0.000373270304407924, 0.000380586629034951, 0.000387982232496142, 0.0003954769927077, 0.000403051031753421, 0.000410644919611514, 0.000418377603637055, 0.000426050828536972, 0.000433942099334672, 0.00044179375981912, 0.000449724699137732, 0.00045775476610288, 0.000465844350401312, 0.000473973574116826, 0.000482142466353253, 0.00049048982327804, 0.000498797453474253, 0.000507224060129374, 0.00051571021322161, 0.000524216156918555, 0.000535328290425241, 0.00054757168982178, 0.000559775449801236, 0.000572048651520163, 0.000584341527428478, 0.000596624566242099, 0.000608957256190479, 0.000621329469140619, 0.000633652089163661, 0.000646064057946205, 0.000658466073218733, 0.000670878042001277, 0.000683329591993243, 0.000695830734912306, 0.000708272389601916, 0.000720813171938062, 0.000733344058971852, 0.000745884841307998, 0.000758445472456515, 0.000771085382439196, 0.000783665862400085, 0.000796335516497493, 0.00080898537999019, 0.000821635185275227, 0.000834344536997378, 0.0008470737375319, 0.000859783031046391, 0.000872591510415077, 0.000885380140971392, 0.000898158818017691, 0.000910996983293444, 0.000923855055589229, 0.000936693279072642, 0.000949590990785509, 0.000962528341915458, 0.000975435948930681, 0.00098839309066534, 0.00100137002300471, 0.00101436686236411, 0.00102736370172352, 0.00104042992461473, 0.00105346646159887, 0.0010665524750948, 0.00107965839561075, 0.00109274440910667, 0.00110591959673911, 0.00111906521487981, 0.0011322305072099, 0.00114544562529773, 0.00115869997534901, 0.00117191497702152, 0.00118518946692348, 0.00119849352631718, 0.00121176801621914, 0.00122512166853994, 0.00123848533257842, 0.00125182897318155, 0.00126522255595773, 0.00127866538241506, 0.00129204883705825, 0.00130553136114031, 0.00131897442042828, 0.00133249664213508, 0.00134600896853954, 0.0013595410855487, 0.00137310300488025, 0.0013867145171389, 0.00140030600596219, 0.00141391775105149, 0.00142756872810423, 0.00144121004268527, 0.00145489082206041, 0.00146865111310035, 0.00148232188075781, 0.00149610196240246, 0.00150987203232944, 0.00152365199755877, 0.00153747177682817, 0.00155131123028696, 0.00156513089314103, 0.00157902983482927, 0.00159292866010219, 0.00160681770648807, 0.00162078614812344, 0.00163474469445646, 0.0016486932290718, 0.0016627210425213, 0.0016767488559708, 0.00169076677411795, 0.00170484418049455, 0.00171893159858882, 0.00173302879557014, 0.00174715579487383, 0.00176131236366928, 0.00177546928171068, 0.00178963597863913, 0.00180389184970409, 0.00181807822082192, 0.00183236389420927, 0.0018466196488589, 0.00186131545342505, 0.00187380670104176, 0.00188625825103372, 0.00189867010340095, 0.00191102270036936, 0.00192324619274586, 0.00193547958042473, 0.00194760411977768, 0.00195971876382828, 0.00197174400091171, 0.00198370986618102, 0.00199561612680554, 0.00200746301561594, 0.0020192505326122, 0.00203096843324602, 0.0020425773691386, 0.00205421610735357, 0.00206572562456131, 0.00207719602622092, 0.0020885867998004, 0.00209996779449284, 0.00211124960333109, 0.00212247180752456, 0.00213367422111332, 0.00214470806531608, 0.00215578195638955, 0.00216673640534282, 0.00217765127308667, 0.00218853657133877, 0.00219929311424494, 0.00221003941260278, 0.00222069653682411, 0.00223132409155369, 0.0022418424487114, 0.00225230166688561, 0.00226275040768087, 0.00227310042828321, 0.00228340085595846, 0.00229361210949719, 0.00230383314192295, 0.00231392495334148, 0.00232397764921188, 0.00233393092639744, 0.00234385463409126, 0.00235372851602733, 0.00236355280503631, 0.00237327837385237, 0.00238296412862837, 0.00239256047643721, 0.00240214704535902, 0.00241162441670895, 0.00242101261392236, 0.00243042083457112, 0.00243971962481737, 0.00244897929951549, 0.00245814933441579, 0.00246727000921965, 0.00247633084654808, 0.00248531298711896, 0.00249429466202855, 0.0025030979886651, 0.00251195090822875, 0.00252070487476885, 0.00252937944605947, 0.00253803376108408, 0.00254657957702875, 0.00255510513670743, 0.00256354152224958, 0.00257191900163889, 0.00258026644587517, 0.00258845486678183, 0.00259668310172856, 0.00260479259304702, 0.00261288229376078, 0.00262088258750737, 0.00262885331176221, 0.00263672461733222, 0.00264455634169281, 0.00265232869423926, 0.00265999208204448, 0.00266760610975325, 0.0026752392295748, 0.00268272403627634, 0.00269018951803446, 0.00269755511544645, 0.00270493095740676, 0.00271215802058578, 0.00271939486265182, 0.00272651319392025, 0.00273359147831798, 0.00274064997211099, 0.00274756969884038, 0.0027544794138521, 0.00276130018755794, 0.00276808091439307, 0.00277480250224471, 0.00278146448545158, 0.00278802751563489, 0.00279454072006047, 0.00280101434327662, 0.00280355219729245, 0.00280371098779142, 0.00280392868444324, 0.00280410726554692, 0.00280442461371422, 0.00280466256663203, 0.00280476198531687, 0.00280509889125824, 0.00280539598315954, 0.00280567398294806, 0.00280599086545408, 0.00280630821362138, 0.00280664535239339, 0.00280700228177011, 0.00280743837356567, 0.00280775548890233, 0.00280815223231912, 0.00280856853350997, 0.00280894548632205, 0.00280940113589168, 0.00280987727455795, 0.00281037297099829, 0.00281080882996321, 0.00281126517802477, 0.00281185982748866, 0.00281233573332429, 0.00281297042965889, 0.00281346612609923, 0.00281400140374899, 0.00281457649543881, 0.00281517114490271, 0.00281586521305144, 0.00281647988595068, 0.00281707476824522, 0.00281768920831382, 0.00281836348585784, 0.00281905732117593, 0.00281979097053409, 0.00282052461989224, 0.00282119866460562, 0.00282197212800384, 0.00282272533513606, 0.00282349879853427, 0.00282425200566649, 0.00282498565502465, 0.002825818490237, 0.0028266510926187, 0.00282752374187112, 0.00282839592546225, 0.00282924855127931, 0.00283010140992701, 0.00283105298876762, 0.00283188559114933, 0.0028328571934253, 0.00283382902853191, 0.00283468118868768, 0.00283571262843907, 0.00283674360252917, 0.00283769518136978, 0.00283874594606459, 0.00283977692015469, 0.00284072896465659, 0.00284181931056082, 0.00284287007525563, 0.00284400023519993, 0.00284513016231358, 0.00284622120670974, 0.00284731155261397, 0.00284848106093705, 0.00284967082552612, 0.00285084079951048, 0.00285199075005949, 0.00285310088656843, 0.00285437004640698, 0.00285563874058425, 0.00285686808638275, 0.00285815703682601, 0.00285942573100328, 0.00286063528619707, 0.00286198337562382, 0.0028633123729378, 0.00286460062488914, 0.00286594917997718, 0.00286729726940393, 0.00286864535883069, 0.00287005328573287, 0.00287150056101382, 0.00287290825508535, 0.00287437555380166, 0.00287570408545434, 0.00287719094194472, 0.00287867826409638, 0.00288016512058675, 0.0028817115817219, 0.00288313953205943, 0.002884725574404, 0.00288629182614386, 0.00288785807788372, 0.00288938521407545, 0.00289097102358937, 0.00289360247552395, 0.00289998692460358, 0.00290637114085257, 0.00291287479922175, 0.00291961594484746, 0.0029263177420944, 0.0029332572594285, 0.00294035556726158, 0.00294753280468285, 0.00295482948422432, 0.00296224467456341, 0.00296977930702269, 0.00297739286907017, 0.00298528419807553, 0.00299321510829031, 0.00300118559971452, 0.00300927530042827, 0.00301756314001977, 0.00302600953727961, 0.0030345746781677, 0.00304325926117599, 0.00305206258781254, 0.0030608659144491, 0.00306990719400346, 0.00307906768284738, 0.00308838626369834, 0.00309774489142001, 0.00310722226276994, 0.00311689800582826, 0.00312661333009601, 0.00313652702607214, 0.0031466786749661, 0.00315671134740114, 0.00316694215871394, 0.00317737134173512, 0.0031878799200058, 0.00319846789352596, 0.00320925377309322, 0.00322015909478068, 0.00323106395080686, 0.00324220675975084, 0.00325354817323387, 0.00326488935388625, 0.00327634951099753, 0.00328796845860779, 0.00329970638267696, 0.00331156281754375, 0.00332361808978021, 0.00333575229160488, 0.00334788649342954, 0.00336033827625215, 0.00337282940745354, 0.00338539993390441, 0.00339812925085425, 0.00341105670668185, 0.0034239839296788, 0.0034370303619653, 0.00345031474716961, 0.00346371787600219, 0.00347712123766541, 0.00349072273820639, 0.00350452261045575, 0.00351824308745563, 0.00353228091262281, 0.00354639813303947, 0.0035606340970844, 0.00357490964233875, 0.00358938379213214, 0.00360397668555379, 0.00361864897422493, 0.00363355875015259, 0.00364850857295096, 0.00366365676745772, 0.00367872579954565, 0.00369411148130894, 0.00370957679115236, 0.00372512196190655, 0.00374090438708663, 0.00375664699822664, 0.0037726282607764, 0.00378864863887429, 0.00380490696989, 0.00382124446332455, 0.0038376220036298, 0.00385419744998217, 0.00387093191966414, 0.00388766615651548, 0.00390463834628463, 0.00392176955938339, 0.00393882067874074, 0.00395614979788661, 0.00397363770753145, 0.00399124436080456, 0.00400885101407766, 0.0040266951546073, 0.00404457980766892, 0.00406262278556824, 0.0040807849727571, 0.00409910501912236, 0.00411754427477717, 0.00414059218019247, 0.0041658915579319, 0.0041911518201232, 0.00421637250110507, 0.00424163229763508, 0.00426689255982637, 0.00429215282201767, 0.00431741261854768, 0.0043427525088191, 0.00436805188655853, 0.00439331214874983, 0.00441861152648926, 0.00444395141676068, 0.00446921121329069, 0.00449455110356212, 0.00451992964372039, 0.00454522902145982, 0.00457056891173124, 0.00459598749876022, 0.00462132645770907, 0.00464670592918992, 0.0046721245162189, 0.00469750352203846, 0.00472288299351931, 0.00474826199933887, 0.00477375974878669, 0.00479917880147696, 0.00482451776042581, 0.00485005555674434, 0.00487547414377332, 0.00490085361525416, 0.00492631224915385, 0.00495184911414981, 0.0049773077480495, 0.00500276638194919, 0.00502830371260643, 0.00505376188084483, 0.00507926009595394, 0.00510479789227247, 0.005130335688591, 0.00515583390370011, 0.00518137123435736, 0.00520698819309473, 0.00523244682699442, 0.00525802420452237, 0.00528364069759846, 0.00530925812199712, 0.00533475633710623, 0.0053603732958436, 0.00538598978891969, 0.00541156716644764, 0.00543718412518501, 0.00546284066513181, 0.00548841804265976, 0.00551407458260655, 0.00553973112255335, 0.00556538766250014, 0.00559104466810822, 0.00561670167371631, 0.00564243691042066, 0.00566805386915803, 0.00569379050284624, 0.00571944657713175, 0.00574518274515867, 0.00577087886631489, 0.00579665461555123, 0.00582239031791687, 0.00584808690473437, 0.00587382260710001, 0.00589959835633636, 0.00592529494315386, 0.00595110980793834, 0.0059769251383841, 0.00600270088762045, 0.00602847663685679, 0.00605425145477057, 0.00608006725087762, 0.00610588258132339, 0.00613169744610786, 0.00615759240463376, 0.00618344685062766, 0.00620922259986401, 0.00623507751151919, 0.00626093288883567, 0.00628678733482957, 0.00631268182769418, 0.00633865594863892, 0.00636454997584224, 0.00639040535315871, 0.00641629984602332, 0.00644215475767851, 0.00646812841296196, 0.00649410206824541, 0.00652007665485144, 0.00654589151963592, 0.00657186564058065, 0.00659787841141224, 0.00662381295114756, 0.00664978660643101, 0.00667584035545588, 0.00669754995033145, 0.00671454053372145, 0.0067314044572413, 0.00674819108098745, 0.00676497677341104, 0.00678167212754488, 0.00679829018190503, 0.00681482348591089, 0.00683137681335211, 0.00684780394658446, 0.00686416868120432, 0.0068804919719696, 0.00689673004671931, 0.00691292807459831, 0.0069290641695261, 0.00694517651572824, 0.00696112355217338, 0.00697708828374743, 0.00699299294501543, 0.00700879516080022, 0.00702456990256906, 0.00704026594758034, 0.00705587724223733, 0.00707146571949124, 0.00708699272945523, 0.00710247550159693, 0.00711783673614264, 0.00713317608460784, 0.00714844930917025, 0.00716362381353974, 0.007178810890764, 0.0071938787586987, 0.00720888329669833, 0.00722384406253695, 0.00723876198753715, 0.00725355697795749, 0.00726835057139397, 0.00728308083489537, 0.00729772681370378, 0.00731231132522225, 0.00732683390378952, 0.00734129175543785, 0.00735568767413497, 0.00737002026289701, 0.00738431047648191, 0.00739851873368025, 0.00741266319528222, 0.00742680439725518, 0.00744078401476145, 0.00745477993041277, 0.00746869528666139, 0.0074825044721365, 0.0074963103979826, 0.00751003716140985, 0.00752368057146668, 0.00753728020936251, 0.00755083607509732, 0.00756433000788093, 0.00757770193740726, 0.00759106688201427, 0.00760435545817018, 0.00761757744476199, 0.00763075752183795, 0.00764385098591447, 0.00765688810497522, 0.00766987958922982, 0.00768282823264599, 0.00769563298672438, 0.00770843727514148, 0.00772119732573628, 0.00773385399952531, 0.0077464678324759, 0.00775902066379786, 0.00777147151529789, 0.0077838939614594, 0.00779627775773406, 0.00780860055238008, 0.00782081950455904, 0.00783301144838333, 0.00784512329846621, 0.0078571354970336, 0.00786915980279446, 0.00788108352571726, 0.00789294764399529, 0.00790476519614458, 0.00791649892926216, 0.00792817212641239, 0.00793980248272419, 0.00795136764645576, 0.00796287134289742, 0.00797427259385586, 0.0079856738448143, 0.00799698755145073, 0.00800822209566832, 0.00801941007375717, 0.00803050119429827, 0.00804158393293619, 0.00805258564651012, 0.00806356314569712, 0.00807439908385277, 0.00808482151478529, 0.00809208303689957, 0.00809933990240097, 0.00810683146119118, 0.00811455864459276, 0.00812228210270405, 0.00813008192926645, 0.00813803635537624, 0.00814606808125973, 0.00815433263778687, 0.00816275365650654, 0.00817117188125849, 0.00817982293665409, 0.00818847212940454, 0.00819735694676638, 0.00820631626993418, 0.00821535103023052, 0.00822454132139683, 0.00823388621211052, 0.00824323110282421, 0.00825296528637409, 0.00826261937618256, 0.00827234797179699, 0.0082823121920228, 0.00829235278069973, 0.00830262713134289, 0.00831297785043716, 0.00832332577556372, 0.00833374820649624, 0.00834448635578156, 0.00835537817329168, 0.00836626812815666, 0.00837731175124645, 0.00838843174278736, 0.00839970819652081, 0.00841121654957533, 0.00842272490262985, 0.00843430869281292, 0.00844612624496222, 0.00845809653401375, 0.00847006868571043, 0.00848219264298677, 0.00849439576268196, 0.00850674882531166, 0.00851926300674677, 0.00853192992508411, 0.0085447495803237, 0.00855757016688585, 0.0085705453529954, 0.00858367513865232, 0.00859703682363033, 0.00861039943993092, 0.00862383749336004, 0.00863742642104626, 0.00865109451115131, 0.00866508018225431, 0.0086789783090353, 0.00869303103536367, 0.00870724115520716, 0.00872176699340343, 0.00873612985014915, 0.00875072367489338, 0.00876547675579786, 0.00878030527383089, 0.00879528746008873, 0.00881034694612026, 0.00882548186928034, 0.00884085427969694, 0.00885629747062922, 0.0088718980550766, 0.00888757780194283, 0.00890341028571129, 0.00891931634396315, 0.00893538165837526, 0.00895160157233477, 0.00896781589835882, 0.00898426678031683, 0.00900087133049965, 0.00901755597442389, 0.00903439056128263, 0.00905130431056023, 0.00906829163432121, 0.00908543635159731, 0.00910281762480736, 0.00912011135369539, 0.00913772359490395, 0.0091553283855319, 0.00917317066341639, 0.00919108930975199, 0.00920908246189356, 0.00922715291380882, 0.00924553629010916, 0.00926383584737778, 0.00928229279816151, 0.00930098351091146, 0.00931982975453138, 0.009338672272861, 0.00935767032206059, 0.00937682390213013, 0.00939597375690937, 0.00941785797476768, 0.00944909639656544, 0.00948052294552326, 0.00951211713254452, 0.00954382121562958, 0.00957569293677807, 0.00960766524076462, 0.00963982567191124, 0.0096720652654767, 0.00970450229942799, 0.00973703898489475, 0.00976982433348894, 0.00980278663337231, 0.00983578059822321, 0.00986894033849239, 0.00990219134837389, 0.00993563048541546, 0.00996924843639135, 0.0100030535832047, 0.0100368689745665, 0.0100710308179259, 0.0101052047684789, 0.010139555670321, 0.0101739363744855, 0.010208654217422, 0.0102433823049068, 0.0102782882750034, 0.0103133814409375, 0.0103485751897097, 0.0103838285431266, 0.0104193789884448, 0.0104550281539559, 0.0104908468201756, 0.0105267642065883, 0.0105628706514835, 0.0105990739539266, 0.0106354476884007, 0.0106719303876162, 0.0107085816562176, 0.0107454992830753, 0.010782428085804, 0.0108194658532739, 0.0108567513525486, 0.0108941467478871, 0.010931609198451, 0.0109692821279168, 0.0110072018578649, 0.0110450619831681, 0.0110833486542106, 0.0111215757206082, 0.0111599816009402, 0.0111985560506582, 0.011237159371376, 0.0112760905176401, 0.0113150514662266, 0.0113541800528765, 0.0113934986293316, 0.0114329839125276, 0.0114724999293685, 0.0115121649578214, 0.011552038602531, 0.0115920882672071, 0.0116323092952371, 0.0116725591942668, 0.01171297673136, 0.0117535935714841, 0.0117943584918976, 0.0118352528661489, 0.011876305565238, 0.0119174662977457, 0.011958796530962, 0.0120002357289195, 0.0120418537408113, 0.0120837185531855, 0.0121255945414305, 0.0121675794944167, 0.0122097516432405, 0.0122521724551916, 0.0122946323826909, 0.012337252497673, 0.0123800598084927, 0.012422876432538, 0.0124660506844521, 0.0125093040987849, 0.012552666477859, 0.0125961182639003, 0.0126398373395205, 0.0126835675910115, 0.012727465480566, 0.0127716399729252, 0.0128159150481224, 0.0128602776676416, 0.0129048302769661, 0.0129494816064835, 0.0129943024367094, 0.0130392406135798, 0.0130844162777066, 0.013129623606801, 0.0131749985739589, 0.0132206510752439, 0.0132655091583729, 0.0133134126663208, 0.0133612165227532, 0.0134088518097997, 0.0134564572945237, 0.0135038448497653, 0.0135512128472328, 0.0135984309017658, 0.0136455707252026, 0.0136925522238016, 0.0137394834309816, 0.0137861967086792, 0.0138328894972801, 0.0138794351369143, 0.0139259016141295, 0.0139722460880876, 0.0140184247866273, 0.0140645038336515, 0.0141104934737086, 0.0141563843935728, 0.0142021160572767, 0.0142477983608842, 0.014293341897428, 0.0143387857824564, 0.0143840415403247, 0.0144292581826448, 0.0144743546843529, 0.0145193235948682, 0.0145642319694161, 0.0146090025082231, 0.0146535951644182, 0.014698076993227, 0.0147425206378102, 0.0147868245840073, 0.0148309804499149, 0.0148750767111778, 0.0149190342053771, 0.0149628920480609, 0.0150066120550036, 0.0150502705946565, 0.0150937931612134, 0.0151371648535132, 0.0151804182678461, 0.0152236018329859, 0.015266677364707, 0.0153096225112677, 0.015352469868958, 0.0153951980173588, 0.0154377678409219, 0.0154802780598402, 0.0155226485803723, 0.0155649604275823, 0.0156071726232767, 0.0156491678208113, 0.0156910642981529, 0.0157329086214304, 0.0157746747136116, 0.0158162321895361, 0.015857731923461, 0.0158991310745478, 0.0159404315054417, 0.015981474891305, 0.0160225164145231, 0.016063479706645, 0.016104344278574, 0.0161449518054724, 0.016185587272048, 0.0162260644137859, 0.0162664130330086, 0.016306621953845, 0.0163468141108751, 0.0163868647068739, 0.0164267774671316, 0.016466561704874, 0.0165062248706818, 0.0165458116680384, 0.0165852773934603, 0.0166246052831411, 0.0166638344526291, 0.0167029444128275, 0.0167419426143169, 0.0167808439582586, 0.0168196465820074, 0.01685830950737, 0.016896914690733, 0.0169353503733873, 0.0169736258685589, 0.0170118529349566, 0.0170499421656132, 0.0170879699289799, 0.0171258710324764, 0.017163623124361, 0.0172012150287628, 0.0172388069331646, 0.0172762721776962, 0.0173135865479708, 0.0173508021980524, 0.0173878818750381, 0.0174248293042183, 0.0174616985023022, 0.0174935460090637, 0.0175094492733479, 0.0175253916531801, 0.0175412520766258, 0.0175570324063301, 0.0175730157643557, 0.0175888761878014, 0.0176047775894403, 0.0176207181066275, 0.0176365803927183, 0.0176524817943573, 0.0176683459430933, 0.0176842827349901, 0.0177001878619194, 0.0177160482853651, 0.0177319906651974, 0.0177477728575468, 0.0177636742591858, 0.0177795775234699, 0.0177954789251089, 0.017811456695199, 0.0178273189812899, 0.0178431812673807, 0.0178590845316648, 0.0178749449551105, 0.0178908854722977, 0.0179067868739367, 0.0179227702319622, 0.0179385896772146, 0.0179544128477573, 0.0179703533649445, 0.0179862156510353, 0.0180021170526743, 0.0180180594325066, 0.0180339608341455, 0.0180497821420431, 0.0180656835436821, 0.0180815439671278, 0.0180975273251534, 0.0181133896112442, 0.0181293319910765, 0.0181451514363289, 0.0181610938161612, 0.018176956102252, 0.0181927774101496, 0.0182087998837233, 0.018224660307169, 0.0182404816150665, 0.0182563830167055, 0.0182722453027964, 0.0182881467044353, 0.0183041300624609, 0.0183199904859066, 0.0183358900249004, 0.0183517131954432, 0.0183676555752754, 0.0183835551142693, 0.0183994565159082, 0.0184153970330954, 0.0184312611818314, 0.0184471607208252, 0.018463023006916, 0.018478887155652, 0.0184948667883873, 0.0185107681900263, 0.018526591360569, 0.018542492762208, 0.0185583531856537, 0.0185742564499378, 0.0185901578515768, 0.0186061784625053, 0.0186219997704029, 0.0186378601938486, 0.0186537243425846, 0.0186696238815784, 0.0186855662614107, 0.018701545894146, 0.0187173299491405, 0.0187332313507795, 0.0187491327524185, 0.0187650341540575, 0.0187808964401484, 0.0187968760728836, 0.0188128165900707, 0.0188286416232586, 0.0188445020467043, 0.0188604444265366, 0.0188763067126274, 0.0188922844827175, 0.0189080704003572, 0.0189240090548992, 0.0189398732036352, 0.0189557746052742, 0.0189715959131718, 0.0189875774085522, 0.019003476947546, 0.0190194193273783, 0.0190352033823729, 0.019051181152463, 0.019067045301199, 0.0190866310149431, 0.0191067364066839, 0.0191277135163546, 0.0191489290446043, 0.0191706586629152, 0.0191926695406437, 0.019215190783143, 0.0192383117973804, 0.0192618668079376, 0.0192855820059776, 0.0193100087344646, 0.0193349495530128, 0.019360089674592, 0.0193857867270708, 0.0194120388478041, 0.0194387249648571, 0.0194657724350691, 0.0194931738078594, 0.0195212475955486, 0.0195496026426554, 0.0195783898234367, 0.019607812166214, 0.0196376740932465, 0.019667774438858, 0.0196983851492405, 0.0197295546531677, 0.0197613164782524, 0.0197933595627546, 0.0198256373405457, 0.0198586322367191, 0.0198920201510191, 0.0199258029460907, 0.019960343837738, 0.019994804635644, 0.0200300589203835, 0.020065588876605, 0.0201019123196602, 0.0201381966471672, 0.0201751962304115, 0.0202126298099756, 0.0202506966888905, 0.0202888045459986, 0.020327627658844, 0.0203668866306543, 0.020406661555171, 0.0204465519636869, 0.0204872377216816, 0.0205282811075449, 0.0205698385834694, 0.0206118319183588, 0.0206539463251829, 0.0206970125436783, 0.0207402352243662, 0.0207839738577604, 0.0208282675594091, 0.0208729580044746, 0.0209178104996681, 0.0209634136408567, 0.0210094135254622, 0.0210558082908392, 0.0211028382182121, 0.0211499482393265, 0.0211979299783707, 0.0212460309267044, 0.0212948471307755, 0.0213440172374249, 0.0213936269283295, 0.0214435905218124, 0.0214939136058092, 0.0215449873358011, 0.0215964205563068, 0.0216482486575842, 0.0217003151774406, 0.0217534136027098, 0.0218063537031412, 0.0218600071966648, 0.0219141747802496, 0.0219687800854445, 0.0220237802714109, 0.0220791362226009, 0.0221348945051432, 0.0221912413835526, 0.0222481880337, 0.0223054084926844, 0.0223631858825684, 0.0224212016910315, 0.0224799308925867, 0.0225388575345278, 0.0225984193384647, 0.0226584952324629, 0.0227187685668468, 0.022779481485486, 0.0228409469127655, 0.0229026097804308, 0.0229649469256401, 0.0230275597423315, 0.02309057302773, 0.0231542196124792, 0.0232181437313557, 0.0232826601713896, 0.0233533345162868, 0.02344367839396, 0.0235343985259533, 0.0236253775656223, 0.0237167496234179, 0.0238084234297276, 0.0239003524184227, 0.0239926781505346, 0.0240852423012257, 0.024178184568882, 0.02427146025002, 0.0243651363998652, 0.0244588907808065, 0.0245532654225826, 0.0246476456522942, 0.0247424300760031, 0.024837601929903, 0.0249330904334784, 0.0250288285315037, 0.0251249596476555, 0.0252213925123215, 0.0253181681036949, 0.0254153218120337, 0.0255126245319843, 0.0256104338914156, 0.0257083009928465, 0.0258066579699516, 0.0259053185582161, 0.0260042939335108, 0.0261036902666092, 0.0262031424790621, 0.0263030640780926, 0.0264033302664757, 0.0265039745718241, 0.0266047660261393, 0.0267060659825802, 0.0268074218183756, 0.0269093457609415, 0.0270114168524742, 0.0271140430122614, 0.0272168386727571, 0.0273197926580906, 0.0274232029914856, 0.0275269486010075, 0.0276310909539461, 0.0277353841811419, 0.0278401523828506, 0.0279450081288815, 0.0280504990369081, 0.0281560495495796, 0.0282620973885059, 0.0283683836460114, 0.0284749642014503, 0.028581814840436, 0.028689119964838, 0.0287966728210449, 0.0289044566452503, 0.029012793675065, 0.0291211400181055, 0.0292300414294004, 0.0293390825390816, 0.0294487066566944, 0.0295584704726934, 0.0296685453504324, 0.0297789610922337, 0.0298896804451942, 0.0300007220357656, 0.0301120728254318, 0.0302238184958696, 0.0303356647491455, 0.03044811822474, 0.0305606573820114, 0.0306736938655376, 0.0307870265096426, 0.0309005863964558, 0.0310144945979118, 0.0311287008225918, 0.0312432441860437, 0.0313581526279449, 0.0314733125269413, 0.0315888039767742, 0.031704667955637, 0.0318206958472729, 0.0319372229278088, 0.032053966075182, 0.0321711078286171, 0.0322884954512119, 0.0324061922729015, 0.0325242206454277, 0.0326426215469837, 0.0327612683176994, 0.0328804105520248, 0.0329996049404144, 0.0331192016601562, 0.0332391373813152, 0.0333595313131809, 0.0334800034761429, 0.0336010381579399, 0.0337221436202526, 0.0338437259197235, 0.033964853733778, 0.0340824723243713, 0.0341999344527721, 0.0343170762062073, 0.0344340689480305, 0.0345507338643074, 0.034667007625103, 0.0347833521664143, 0.0348993055522442, 0.0350151099264622, 0.0351305827498436, 0.0352458991110325, 0.0353609062731266, 0.0354755967855453, 0.0355901084840298, 0.035704493522644, 0.0358185470104218, 0.0359324216842651, 0.0360460132360458, 0.0361595004796982, 0.0362723730504513, 0.0363853052258492, 0.036497924476862, 0.0366103164851665, 0.0367226302623749, 0.0368344485759735, 0.036946214735508, 0.0370574854314327, 0.0371687412261963, 0.0372797176241875, 0.037390511482954, 0.0375009961426258, 0.0376113243401051, 0.0377213209867477, 0.0378309413790703, 0.0379405580461025, 0.0380498319864273, 0.0381589829921722, 0.0382677912712097, 0.0383764356374741, 0.0384847968816757, 0.0385928116738796, 0.0387006849050522, 0.0388083085417747, 0.0389156900346279, 0.0390228480100632, 0.0391298346221447, 0.0392365083098412, 0.0393428839743137, 0.0394490733742714, 0.0395550280809402, 0.0396607629954815, 0.039766326546669, 0.0398715771734715, 0.0399766638875008, 0.0400811918079853, 0.0401858128607273, 0.040290106087923, 0.0403941608965397, 0.040498074144125, 0.0406015701591969, 0.0407049804925919, 0.040807943791151, 0.040910892188549, 0.0410134233534336, 0.0411159135401249, 0.0412180610001087, 0.0413200519979, 0.0414216592907906, 0.0415230169892311, 0.0416242145001888, 0.0417251959443092, 0.0418259091675282, 0.0419264063239098, 0.0420267395675182, 0.0421266630291939, 0.0422263666987419, 0.0423259064555168, 0.0424252785742283, 0.0425242595374584, 0.0426231659948826, 0.0427216738462448, 0.0428200326859951, 0.0429180487990379, 0.0430158339440823, 0.0431135669350624, 0.0432108677923679, 0.043308112770319, 0.0434050373733044, 0.0435017980635166, 0.0435979999601841, 0.0436942912638187, 0.0437901727855206, 0.0438859015703201, 0.0439813993871212, 0.0440766513347626, 0.0441717617213726, 0.0442663691937923, 0.0443609058856964, 0.0444552265107632, 0.0445456244051456, 0.0446237064898014, 0.0447012297809124, 0.044778399169445, 0.0448550507426262, 0.0449314676225185, 0.0450074076652527, 0.0450830273330212, 0.0451582111418247, 0.0452329628169537, 0.0453073531389236, 0.0453811921179295, 0.0454547479748726, 0.0455279536545277, 0.0456007607281208, 0.0456730090081692, 0.0457449853420258, 0.0458165220916271, 0.0458875000476837, 0.0459582880139351, 0.0460286773741245, 0.0460986234247684, 0.046168178319931, 0.046237301081419, 0.0463060960173607, 0.0463742651045322, 0.0464421547949314, 0.0465097241103649, 0.0465769395232201, 0.046643640846014, 0.046709943562746, 0.0467759296298027, 0.0468412004411221, 0.0469064302742481, 0.0469711497426033, 0.0470354706048965, 0.0470994338393211, 0.0471628792583942, 0.047226008027792, 0.0472885482013226, 0.0473508797585964, 0.0474128238856792, 0.0474743656814098, 0.0475355125963688, 0.0475961454212666, 0.0476563423871994, 0.0477163046598434, 0.047775823622942, 0.0478348657488823, 0.0478936396539211, 0.0479517728090286, 0.0480097867548466, 0.0480670481920242, 0.0481241121888161, 0.0481808595359325, 0.0482371263206005, 0.0482929982244968, 0.0483485572040081, 0.0484036356210709, 0.048458207398653, 0.0485124923288822, 0.0485663823783398, 0.0486197955906391, 0.0486729331314564, 0.0487255565822124, 0.0487777777016163, 0.0488296449184418, 0.0488809607923031, 0.0489320755004883, 0.0489827133715153, 0.0490329973399639, 0.0490829274058342, 0.0491323731839657, 0.049181267619133, 0.0492298826575279, 0.0492781475186348, 0.0493260100483894, 0.0493735149502754, 0.0494205430150032, 0.0494672171771526, 0.0495132580399513, 0.0495591387152672, 0.0496045798063278, 0.0496495887637138, 0.0496942438185215, 0.0497384555637836, 0.0497823134064674, 0.0498255826532841, 0.049868606030941, 0.0499112345278263, 0.0499534644186497, 0.0499953031539917, 0.0500367768108845, 0.0500777401030064, 0.0501184239983559, 0.0501584783196449, 0.0501983314752579, 0.0502377487719059, 0.0502768084406853, 0.0503153912723064, 0.0503442212939262, 0.0503706708550453, 0.0503970831632614, 0.0504235289990902, 0.0504499785602093, 0.0504763908684254, 0.0505027621984482, 0.0505291298031807, 0.0505555011332035, 0.050581831485033, 0.0506081618368626, 0.0506344549357891, 0.0506607443094254, 0.0506869219243526, 0.0507132932543755, 0.0507395416498184, 0.0507657118141651, 0.0507918857038021, 0.0508180148899555, 0.0508441887795925, 0.0508703216910362, 0.0508964583277702, 0.0509225465357304, 0.0509486421942711, 0.0509747341275215, 0.0510006621479988, 0.0510268397629261, 0.05105284973979, 0.0510788261890411, 0.051104836165905, 0.0511307716369629, 0.0511566698551178, 0.0511826388537884, 0.0512086153030396, 0.0512344688177109, 0.0512602850794792, 0.0512860640883446, 0.0513119176030159, 0.0513377338647842, 0.0513636283576488, 0.0513894036412239, 0.0514151751995087, 0.0514408722519875, 0.0514666102826595, 0.0514923445880413, 0.0515180006623268, 0.0515437833964825, 0.0515694729983807, 0.0515950508415699, 0.0516206696629524, 0.0516462847590446, 0.0516717843711376, 0.0516974404454231, 0.0517230182886124, 0.051748514175415, 0.051774013787508, 0.051799550652504, 0.0518249683082104, 0.0518505461513996, 0.0518760047852993, 0.0519013442099094, 0.0519268065690994, 0.0519521832466125, 0.0519775599241257, 0.0520029440522194, 0.0520283207297325, 0.0520536154508591, 0.0520789623260498, 0.0521042160689831, 0.0521293990314007, 0.0521546974778175, 0.0521798804402351, 0.0522051826119423, 0.0522303991019726, 0.0522555410861969, 0.0522807203233242, 0.0523059032857418, 0.0523310042917728, 0.0523561872541904, 0.0523812882602215, 0.0524063482880592, 0.0524314120411873, 0.052456472069025, 0.0524814538657665, 0.052506398409605, 0.0525314994156361, 0.0525564029812813, 0.0525813475251198, 0.052606325596571, 0.0526311919093132, 0.0526560954749584, 0.0526810362935066, 0.0527058616280556, 0.0527307651937008, 0.0527555495500565, 0.0527803339064121, 0.0528051145374775, 0.0528298616409302, 0.0528547242283821, 0.0528794676065445, 0.0529120452702045, 0.052951417863369, 0.0529910735785961, 0.0530310869216919, 0.0530715323984623, 0.0531121417880058, 0.0531531423330307, 0.0531943440437317, 0.0532359033823013, 0.0532778203487396, 0.05332001298666, 0.0533625595271587, 0.0534054301679134, 0.0534484907984734, 0.0534919910132885, 0.0535357743501663, 0.0535798296332359, 0.0536242797970772, 0.0536690503358841, 0.0537139773368835, 0.0537593029439449, 0.0538049452006817, 0.0538509450852871, 0.0538972616195679, 0.0539439357817173, 0.0539907664060593, 0.0540379583835602, 0.0540855452418327, 0.0541333258152008, 0.0541815087199211, 0.0542300827801228, 0.0542787835001945, 0.0543278716504574, 0.0543773211538792, 0.0544270090758801, 0.0544771328568459, 0.0545274540781975, 0.0545781366527081, 0.054629173129797, 0.0546804405748844, 0.0547320358455181, 0.0547839812934399, 0.0548362880945206, 0.0548887513577938, 0.054941650480032, 0.0549948252737522, 0.0550483167171478, 0.0551020540297031, 0.0551561787724495, 0.0552106238901615, 0.0552653893828392, 0.0553205087780952, 0.0553757883608341, 0.0554315447807312, 0.0554875358939171, 0.0555437244474888, 0.0556005127727985, 0.0556574165821075, 0.0557146780192852, 0.0557722561061382, 0.0558300726115704, 0.0558882430195808, 0.0559468939900398, 0.0560056269168854, 0.0560648255050182, 0.0561242289841175, 0.0561839491128922, 0.0562440678477287, 0.0563044212758541, 0.0563651733100414, 0.0564262010157108, 0.0564875043928623, 0.0565490908920765, 0.056611031293869, 0.0566733293235302, 0.0567358620464802, 0.0567988343536854, 0.056862086057663, 0.0569255314767361, 0.0569893382489681, 0.0570535399019718, 0.0571180135011673, 0.057182852178812, 0.0572479665279388, 0.0573132745921612, 0.0573790222406387, 0.0574450492858887, 0.057511355727911, 0.0575781725347042, 0.0576450675725937, 0.0577122829854488, 0.0577799305319786, 0.0578478239476681, 0.0579160265624523, 0.0579846277832985, 0.0580534711480141, 0.058122631162405, 0.0581921003758907, 0.0582618974149227, 0.0583319664001465, 0.0583994388580322, 0.058459036052227, 0.0585192702710629, 0.0585800260305405, 0.0586413666605949, 0.058703389018774, 0.0587660446763039, 0.0588290579617023, 0.0588929802179337, 0.0589571818709373, 0.0590220987796783, 0.059087723493576, 0.0591537095606327, 0.0592201687395573, 0.0592875443398952, 0.0593553930521011, 0.0594238787889481, 0.059492714703083, 0.0595623143017292, 0.0596324615180492, 0.0597033239901066, 0.0597746223211288, 0.0598465576767921, 0.0599190071225166, 0.0599921308457851, 0.0600658841431141, 0.0601400807499886, 0.0602148286998272, 0.0602902956306934, 0.0603664293885231, 0.060443002730608, 0.0605201721191406, 0.0605978928506374, 0.0606762953102589, 0.0607552453875542, 0.0608348660171032, 0.0609148517251015, 0.0609954297542572, 0.0610768459737301, 0.0611586906015873, 0.0612411759793758, 0.0613242909312248, 0.0614078007638454, 0.0614920668303967, 0.0615768507122993, 0.0616622306406498, 0.0617481172084808, 0.0618347227573395, 0.0619218088686466, 0.0620096027851105, 0.0620979145169258, 0.0621868185698986, 0.0622761622071266, 0.0623662956058979, 0.0624569058418274, 0.0625481903553009, 0.0626399144530296, 0.0627323091030121, 0.0628254190087318, 0.0629188790917397, 0.0630130618810654, 0.0631077215075493, 0.0632030516862869, 0.0632990151643753, 0.0633955746889114, 0.0634924918413162, 0.0635900422930717, 0.0636884644627571, 0.0637872889637947, 0.0638867020606995, 0.0639868676662445, 0.0640872269868851, 0.0641885474324226, 0.0642901882529259, 0.0643925741314888, 0.0644954368472099, 0.0645989775657654, 0.064703069627285, 0.0648079216480255, 0.0649130418896675, 0.0650188773870468, 0.0651253163814545, 0.0652323067188263, 0.0653399601578712, 0.0654482245445251, 0.0655569136142731, 0.0656662434339523, 0.0657761245965958, 0.0658867657184601, 0.0659977942705154, 0.0661095827817917, 0.0662218108773232, 0.0663347020745277, 0.0664482787251472, 0.0665622428059578, 0.0666767284274101, 0.0667920783162117, 0.0669078379869461, 0.0670242607593536, 0.0671411678195, 0.067268043756485, 0.0674019157886505, 0.0675361901521683, 0.0676714926958084, 0.0678074285387993, 0.0679442435503006, 0.0680816769599915, 0.0682202354073524, 0.0683591738343239, 0.0684989243745804, 0.0686397776007652, 0.0687812715768814, 0.0689233914017677, 0.0690666288137436, 0.069210097193718, 0.0693547502160072, 0.0694999620318413, 0.0696462169289589, 0.0697930157184601, 0.0699408501386642, 0.0700891613960266, 0.0702384188771248, 0.0703883096575737, 0.0705390051007271, 0.0706907212734222, 0.0708430781960487, 0.07099599391222, 0.0711498409509659, 0.0713046565651894, 0.0714601054787636, 0.0716163441538811, 0.0717732980847359, 0.0719309747219086, 0.0720895007252693, 0.0722488388419151, 0.0724089592695236, 0.072569876909256, 0.0727313533425331, 0.0728937759995461, 0.0730569958686829, 0.0732211768627167, 0.0733858197927475, 0.0735512524843216, 0.0737176463007927, 0.0738845989108086, 0.0740526616573334, 0.0742211863398552, 0.074390597641468, 0.0745607912540436, 0.0747317895293236, 0.0749035626649857, 0.0750759020447731, 0.0752492770552635, 0.0754235163331032, 0.0755983144044876, 0.0757739171385765, 0.0759502202272415, 0.0761273950338364, 0.0763055235147476, 0.076484203338623, 0.0766636878252029, 0.0768439471721649, 0.077024944126606, 0.0772070288658142, 0.0773895233869553, 0.0775728151202202, 0.0777571201324463, 0.0779420733451843, 0.0781278163194656, 0.0783144310116768, 0.0785015225410461, 0.0786896422505379, 0.0788784846663475, 0.0790681168437004, 0.079258531332016, 0.0794496685266495, 0.0796415954828262, 0.0798344016075134, 0.0800279900431633, 0.0802221447229385, 0.0804172456264496, 0.0806130617856979, 0.080809585750103, 0.081007145345211, 0.0812054201960564, 0.0814041718840599, 0.0816038772463799, 0.0818043649196625, 0.082005649805069, 0.0822075828909874, 0.082410529255867, 0.0826141238212585, 0.0828185752034187, 0.0830236747860909, 0.0832294821739197, 0.0834362432360649, 0.08364387601614, 0.0838521420955658, 0.0840613543987274, 0.0842710509896278, 0.084498904645443, 0.084750160574913, 0.0850008577108383, 0.0852517187595367, 0.0855024084448814, 0.0857527926564217, 0.0860030949115753, 0.0862533897161484, 0.0865034535527229, 0.0867533534765244, 0.0870029479265213, 0.0872525349259377, 0.0875018835067749, 0.0877511575818062, 0.0880003422498703, 0.0882492214441299, 0.0884980857372284, 0.0887466445565224, 0.088995449244976, 0.0892438367009163, 0.0894919186830521, 0.0897399932146072, 0.0899880081415176, 0.0902356803417206, 0.0904832109808922, 0.0907306596636772, 0.0909779444336891, 0.0912250727415085, 0.0914722010493279, 0.0917190089821815, 0.0919659063220024, 0.0922122299671173, 0.09245865046978, 0.092705063521862, 0.0929511711001396, 0.0931970998644829, 0.0934429690241814, 0.0936885848641396, 0.0939339697360992, 0.0941794291138649, 0.0944245755672455, 0.0946697220206261, 0.0949147120118141, 0.095159538090229, 0.0954040512442589, 0.0956484749913216, 0.0958927571773529, 0.0961370319128036, 0.0963809788227081, 0.0966247767210007, 0.0968685001134872, 0.0971120595932007, 0.097355529665947, 0.09759870916605, 0.0978420227766037, 0.0980848670005798, 0.0983277186751366, 0.0985703989863396, 0.0988128557801247, 0.0990552231669426, 0.099297508597374, 0.0995394065976143, 0.0997813865542412, 0.100023038685322, 0.100264690816402, 0.100506268441677, 0.100747600197792, 0.100988864898682, 0.101229727268219, 0.101470597088337, 0.101711295545101, 0.101951844990253, 0.102192312479019, 0.102432459592819, 0.102672606706619, 0.102912604808807, 0.103152349591255, 0.10339217633009, 0.10363145917654, 0.103871062397957, 0.10411024838686, 0.104349210858345, 0.10458816587925, 0.104826733469963, 0.105065539479256, 0.105303943157196, 0.10554226487875, 0.105780355632305, 0.10601819306612, 0.106256291270256, 0.106494054198265, 0.106731586158276, 0.10696904361248, 0.107206098735332, 0.107443310320377, 0.107680290937424, 0.107917115092278, 0.108153775334358, 0.108390271663666, 0.108626529574394, 0.108833901584148, 0.109019808471203, 0.10920475423336, 0.109388828277588, 0.109572030603886, 0.109754212200642, 0.109935596585274, 0.110116019845009, 0.110295571386814, 0.110474184155464, 0.110651910305023, 0.110828772187233, 0.111004836857319, 0.11117996275425, 0.11135395616293, 0.111527174711227, 0.111699514091015, 0.111870981752872, 0.112041495740414, 0.112211227416992, 0.11237982660532, 0.112547725439072, 0.112714596092701, 0.112880744040012, 0.113045938313007, 0.113210119307041, 0.113373503088951, 0.11353600025177, 0.113697476685047, 0.1138581559062, 0.114017881453037, 0.114176668226719, 0.114334650337696, 0.114491678774357, 0.114647842943668, 0.114802971482277, 0.114957310259342, 0.115110762417316, 0.115263521671295, 0.115414924919605, 0.115565769374371, 0.115715503692627, 0.11586444824934, 0.116012439131737, 0.116159550845623, 0.116305805742741, 0.116451106965542, 0.116595603525639, 0.116739146411419, 0.116881757974625, 0.117023549973965, 0.117164254188538, 0.117304310202599, 0.117443256080151, 0.117581337690353, 0.117718540132046, 0.117854878306389, 0.117990337312222, 0.118124842643738, 0.118258565664291, 0.118391253054142, 0.118523061275482, 0.118653997778893, 0.118783988058567, 0.118913106620312, 0.11904127150774, 0.119168557226658, 0.119295060634613, 0.119420528411865, 0.119545042514801, 0.119668759405613, 0.119791693985462, 0.119913510978222, 0.120034545660019, 0.120154775679111, 0.120273895561695, 0.120392225682735, 0.12050960958004, 0.120626099407673, 0.120741657912731, 0.12085634469986, 0.120970152318478, 0.12108301371336, 0.121194995939732, 0.121306344866753, 0.121416419744492, 0.121525794267654, 0.121634133160114, 0.121741592884064, 0.121848188340664, 0.121953904628754, 0.122058667242527, 0.122162565588951, 0.122265435755253, 0.122367583215237, 0.122468948364258, 0.122569270431995, 0.122668646275997, 0.122767060995102, 0.122864618897438, 0.122954569756985, 0.123038157820702, 0.123121507465839, 0.12320426851511, 0.123286865651608, 0.123368874192238, 0.123450547456741, 0.123531721532345, 0.123612575232983, 0.123693004250526, 0.123773008584976, 0.123852521181107, 0.123931780457497, 0.124010547995567, 0.124088890850544, 0.124166823923588, 0.124244406819344, 0.124321505427361, 0.12439826130867, 0.124474607408047, 0.124550454318523, 0.124625965952873, 0.124700978398323, 0.124775730073452, 0.124849915504456, 0.124923832714558, 0.124997176229954, 0.12507027387619, 0.125142797827721, 0.12521505355835, 0.125286802649498, 0.125358238816261, 0.125429153442383, 0.125499755144119, 0.125569880008698, 0.125639647245407, 0.125708922743797, 0.125777870416641, 0.125846356153488, 0.125914469361305, 0.125982120633125, 0.126049414277077, 0.126116260886192, 0.1261827647686, 0.126248732209206, 0.126314371824265, 0.126379549503326, 0.126444473862648, 0.126508817076683, 0.126572862267494, 0.126636415719986, 0.126699596643448, 0.126762315630913, 0.126824706792831, 0.126886621117592, 0.126948177814484, 0.127009227871895, 0.127069935202599, 0.12713024020195, 0.127190172672272, 0.127249553799629, 0.127308651804924, 0.127367272973061, 0.127425581216812, 0.127483382821083, 0.127540811896324, 0.127597779035568, 0.127654448151588, 0.127710580825806, 0.127766340970993, 0.127821683883667, 0.127876698970795, 0.127931207418442, 0.127985373139381, 0.128039047122002, 0.128092393279076, 0.128145277500153, 0.128197818994522, 0.128249883651733, 0.128301501274109, 0.128352761268616, 0.128403648734093, 0.128454074263573, 0.128504157066345, 0.128553748130798, 0.128602921962738, 0.128651693463326, 0.128700166940689, 0.128748074173927, 0.12879566848278, 0.128842771053314, 0.128889560699463, 0.128935903310776, 0.128981828689575, 0.129027307033539, 0.129072427749634, 0.129117101430893, 0.129161432385445, 0.129205211997032, 0.129248708486557, 0.129297822713852, 0.129347711801529, 0.129397734999657, 0.129448071122169, 0.129498451948166, 0.12954917550087, 0.129599988460541, 0.129651114344597, 0.12970232963562, 0.129753813147545, 0.12980543076992, 0.129857331514359, 0.129909351468086, 0.129961609840393, 0.130014061927795, 0.130066722631454, 0.130119532346725, 0.130172580480576, 0.130225837230682, 0.130279332399368, 0.130332961678505, 0.130386769771576, 0.130440846085548, 0.130495056509972, 0.130549520254135, 0.130604147911072, 0.130658999085426, 0.130714014172554, 0.130769267678261, 0.13082467019558, 0.130880311131477, 0.130936086177826, 0.13099217414856, 0.131048321723938, 0.131104812026024, 0.131161496043205, 0.131218299269676, 0.131275311112404, 0.131332486867905, 0.131389945745468, 0.131447538733482, 0.131505355238914, 0.131563365459442, 0.131621658802032, 0.131679967045784, 0.131738662719727, 0.13179737329483, 0.131856456398964, 0.131915614008904, 0.131975054740906, 0.132034584879875, 0.13209442794323, 0.132154420018196, 0.132214650511742, 0.132275030016899, 0.132335662841797, 0.132396444678307, 0.132457435131073, 0.132518634200096, 0.132580026984215, 0.13264162838459, 0.1327034085989, 0.132765412330627, 0.132827550172806, 0.132889986038208, 0.132952526211739, 0.133015364408493, 0.133078262209892, 0.13314151763916, 0.13320480287075, 0.133268445730209, 0.133332192897797, 0.133396223187447, 0.13346029818058, 0.133524760603905, 0.133589252829552, 0.133654072880745, 0.133718982338905, 0.13378418982029, 0.133849546313286, 0.133915156126022, 0.133980825543404, 0.134046867489815, 0.134113058447838, 0.134179383516312, 0.134245961904526, 0.134312674403191, 0.134379655122757, 0.134446769952774, 0.134514182806015, 0.134581685066223, 0.13464942574501, 0.134717375040054, 0.134785547852516, 0.134853884577751, 0.134922444820404, 0.134991183876991, 0.135060146450996, 0.135129287838936, 0.13519860804081, 0.135273456573486, 0.135354653000832, 0.135436430573463, 0.135518476366997, 0.135601118206978, 0.135684162378311, 0.135767668485641, 0.135851591825485, 0.13593602180481, 0.136020869016647, 0.136106103658676, 0.13619190454483, 0.136278137564659, 0.136364713311195, 0.136451929807663, 0.136539369821548, 0.136627465486526, 0.136715859174728, 0.136804804205894, 0.136894106864929, 0.136983916163445, 0.137074142694473, 0.137164890766144, 0.137256115674973, 0.137347683310509, 0.137439757585526, 0.13753217458725, 0.137625217437744, 0.137718573212624, 0.137812480330467, 0.137906774878502, 0.138001531362534, 0.138096779584885, 0.138192370533943, 0.138288512825966, 0.13838504254818, 0.138482078909874, 0.138579517602921, 0.138677462935448, 0.138775795698166, 0.138874650001526, 0.138973832130432, 0.139073610305786, 0.139173656702042, 0.139274343848228, 0.139375373721123, 0.139476925134659, 0.139578923583031, 0.139681309461594, 0.139784216880798, 0.139887452125549, 0.139991253614426, 0.140095427632332, 0.14020012319088, 0.140305206179619, 0.140410795807838, 0.140516847372055, 0.140623271465302, 0.140730187296867, 0.140837609767914, 0.140945360064507, 0.141053587198257, 0.141162380576134, 0.141271516680717, 0.141381204128265, 0.141491144895554, 0.141601756215096, 0.141712754964828, 0.141824141144753, 0.141936033964157, 0.142048254609108, 0.142161071300507, 0.142274290323257, 0.142388015985489, 0.142502039670944, 0.142616674304008, 0.142731636762619, 0.142847180366516, 0.142963036894798, 0.143079444766045, 0.14319634437561, 0.1433135420084, 0.143431305885315, 0.143549397587776, 0.143668115139008, 0.143787160515785, 0.143906727433205, 0.144026637077332, 0.144147157669067, 0.144267931580544, 0.144389286637306, 0.144511148333549, 0.144633278250694, 0.14475604891777, 0.144879102706909, 0.145002692937851, 0.14512674510479, 0.145251259207726, 0.14537613093853, 0.145501479506493, 0.145642876625061, 0.145800977945328, 0.145958915352821, 0.146116703748703, 0.146274372935295, 0.146431669592857, 0.146589025855064, 0.146746024489403, 0.146902948617935, 0.147059693932533, 0.147216245532036, 0.147372603416443, 0.14752884209156, 0.147684842348099, 0.147840768098831, 0.147996455430984, 0.148151904344559, 0.148307397961617, 0.148462474346161, 0.148617476224899, 0.148772299289703, 0.148926988244057, 0.149081483483315, 0.14923582971096, 0.149390012025833, 0.149543926119804, 0.14969776570797, 0.149851456284523, 0.150004878640175, 0.150158137083054, 0.150311335921288, 0.150464281439781, 0.150617033243179, 0.150769665837288, 0.150922060012817, 0.151074290275574, 0.151226401329041, 0.151378288865089, 0.151530042290688, 0.151681646704674, 0.151832908391953, 0.151984199881554, 0.152135297656059, 0.152286097407341, 0.1524368673563, 0.152587354183197, 0.152737677097321, 0.152887850999832, 0.153037920594215, 0.153187736868858, 0.153337463736534, 0.153486922383308, 0.153636261820793, 0.153785422444344, 0.153934374451637, 0.154083162546158, 0.154231876134872, 0.154380276799202, 0.154528692364693, 0.15467680990696, 0.15482471883297, 0.154972538352013, 0.155120149254799, 0.15526756644249, 0.155414804816246, 0.155561909079552, 0.155708774924278, 0.15585558116436, 0.156002134084702, 0.15614852309227, 0.156294763088226, 0.156440794467926, 0.156586736440659, 0.156732425093651, 0.156877964735031, 0.157023325562477, 0.157168507575989, 0.157313510775566, 0.157458379864693, 0.157603085041046, 0.157747611403465, 0.157891914248466, 0.158036068081856, 0.158180043101311, 0.158323884010315, 0.158467516303062, 0.15861102938652, 0.158754333853722, 0.158897370100021, 0.159040406346321, 0.159183129668236, 0.159325882792473, 0.159468293190002, 0.15961055457592, 0.15975259244442, 0.159894555807114, 0.160036325454712, 0.160177931189537, 0.160319313406944, 0.160460516810417, 0.160574659705162, 0.160658299922943, 0.160741657018661, 0.160824656486511, 0.160907387733459, 0.160989820957184, 0.161071971058846, 0.161153838038445, 0.161235347390175, 0.161316528916359, 0.161397501826286, 0.161478087306023, 0.16155843436718, 0.161638468503952, 0.161718174815178, 0.16179758310318, 0.161876708269119, 0.161955520510674, 0.162034049630165, 0.162112265825272, 0.162190169095993, 0.162267774343491, 0.162345096468925, 0.162422180175781, 0.162498861551285, 0.162575274705887, 0.162651389837265, 0.162727192044258, 0.162802681326866, 0.162877917289734, 0.162952810525894, 0.163027405738831, 0.163101717829704, 0.163175672292709, 0.163249403238297, 0.163322791457176, 0.163395896553993, 0.163468688726425, 0.16354113817215, 0.163613364100456, 0.163685217499733, 0.163756847381592, 0.163828104734421, 0.163899093866348, 0.163969770073891, 0.16404016315937, 0.164110258221626, 0.164179965853691, 0.164249494671822, 0.164318665862083, 0.164387509226799, 0.164456114172935, 0.164524331688881, 0.164592295885086, 0.164660021662712, 0.164727345108986, 0.164794534444809, 0.164861276745796, 0.164927676320076, 0.164993926882744, 0.165059745311737, 0.165125340223312, 0.16519059240818, 0.165255516767502, 0.165320172905922, 0.165384545922279, 0.165448591113091, 0.165512323379517, 0.16557577252388, 0.16563892364502, 0.165701791644096, 0.165764331817627, 0.165826573967934, 0.165888518095016, 0.165950134396553, 0.166011482477188, 0.16607254743576, 0.166133269667625, 0.16619373857975, 0.166253834962845, 0.166313678026199, 0.166373208165169, 0.166432425379753, 0.166491359472275, 0.166549995541573, 0.166608318686485, 0.166666373610497, 0.166724056005478, 0.16678149998188, 0.166838631033897, 0.166895478963852, 0.166952028870583, 0.167008221149445, 0.167064189910889, 0.167119771242142, 0.167175084352493, 0.167230099439621, 0.167284786701202, 0.167339250445366, 0.1673933416605, 0.167449355125427, 0.167510569095612, 0.167572259902954, 0.167634636163712, 0.167697578668594, 0.167760998010635, 0.167825028300285, 0.167889699339867, 0.167954877018929, 0.168020620942116, 0.168087050318718, 0.168153941631317, 0.168221458792686, 0.168289601802826, 0.168358236551285, 0.168427482247353, 0.168497294187546, 0.168567687273026, 0.168638616800308, 0.168710187077522, 0.168782323598862, 0.168855011463165, 0.168928325176239, 0.169002145528793, 0.169076517224312, 0.169151559472084, 0.169227123260498, 0.169303238391876, 0.169380038976669, 0.169457331299782, 0.169535219669342, 0.169613644480705, 0.169692710042, 0.169772356748581, 0.169852539896965, 0.169933259487152, 0.170014649629593, 0.170096531510353, 0.1701789945364, 0.170262083411217, 0.170345723628998, 0.170429930090904, 0.170514762401581, 0.170600116252899, 0.170686036348343, 0.170772641897202, 0.170859694480896, 0.170947328209877, 0.171035632491112, 0.171124473214149, 0.171213939785957, 0.171303898096085, 0.171394392848015, 0.17148557305336, 0.171577289700508, 0.171669542789459, 0.17176242172718, 0.171855852007866, 0.171949818730354, 0.172044485807419, 0.172139629721642, 0.17223533987999, 0.172331735491753, 0.172428607940674, 0.172526001930237, 0.172624126076698, 0.172722727060318, 0.172821894288063, 0.172921776771545, 0.173022076487541, 0.173123002052307, 0.173224538564682, 0.173326596617699, 0.17342920601368, 0.173532485961914, 0.173636257648468, 0.173740640282631, 0.173845663666725, 0.173951178789139, 0.174057319760323, 0.174163982272148, 0.17427122592926, 0.174379125237465, 0.17448753118515, 0.174596473574638, 0.174706131219864, 0.174816206097603, 0.174926951527596, 0.175038278102875, 0.175150111317635, 0.17526251077652, 0.175375640392303, 0.175489217042923, 0.175603345036507, 0.175718158483505, 0.175833493471146, 0.175949364900589, 0.176065906882286, 0.176182955503464, 0.176300510764122, 0.176444247364998, 0.176612585783005, 0.176781326532364, 0.176950335502625, 0.177119672298431, 0.177289336919785, 0.177459314465523, 0.177629545331001, 0.177800223231316, 0.177971169352531, 0.17814239859581, 0.178314045071602, 0.178485900163651, 0.178658112883568, 0.178830698132515, 0.179003536701202, 0.179176703095436, 0.179350271821022, 0.179524093866348, 0.179698199033737, 0.179872736334801, 0.18004746735096, 0.18022258579731, 0.18039807677269, 0.180573806166649, 0.180749833583832, 0.180926293134689, 0.181102991104126, 0.181280001997948, 0.181457459926605, 0.181635081768036, 0.181813165545464, 0.181991457939148, 0.182170078158379, 0.182349130511284, 0.182528376579285, 0.182707920670509, 0.18288791179657, 0.183068200945854, 0.183248713612556, 0.183429643511772, 0.183610826730728, 0.183792382478714, 0.183974280953407, 0.184156462550163, 0.184338912367821, 0.184521794319153, 0.184704929590225, 0.184888362884521, 0.185072213411331, 0.185256272554398, 0.185440763831139, 0.185625493526459, 0.185810536146164, 0.185995981097221, 0.186181664466858, 0.186367705464363, 0.186554089188576, 0.18674074113369, 0.18692772090435, 0.187115103006363, 0.187302708625793, 0.187490671873093, 0.187679007649422, 0.187867522239685, 0.188056483864784, 0.188245743513107, 0.188435316085815, 0.188625156879425, 0.188815429806709, 0.189005926251411, 0.189196765422821, 0.189388021826744, 0.189579471945763, 0.189771249890327, 0.189963430166245, 0.190155893564224, 0.190348640084267, 0.190541803836823, 0.190735191106796, 0.190928995609283, 0.19112303853035, 0.191317409276962, 0.191512152552605, 0.191707134246826, 0.191902488470078, 0.19209823012352, 0.192294180393219, 0.192490443587303, 0.192687153816223, 0.192884102463722, 0.193081334233284, 0.193278983235359, 0.193476855754852, 0.193675115704536, 0.193873733282089, 0.194072589278221, 0.194271773099899, 0.194471344351768, 0.1946711987257, 0.194861754775047, 0.195041686296463, 0.195221051573753, 0.195399940013885, 0.195578217506409, 0.195756003260612, 0.195933312177658, 0.196110025048256, 0.19628618657589, 0.196461841464043, 0.19663693010807, 0.196811497211456, 0.196985527873039, 0.197158992290497, 0.197331964969635, 0.197504416108131, 0.197676301002502, 0.197847634553909, 0.198018476366997, 0.198188751935959, 0.198358491063118, 0.198527693748474, 0.198696300387383, 0.198864430189133, 0.199032068252563, 0.199199140071869, 0.199365645647049, 0.199531629681587, 0.199697092175484, 0.199862018227577, 0.200026363134384, 0.200190186500549, 0.200353473424911, 0.200516298413277, 0.200678527355194, 0.200840204954147, 0.201001361012459, 0.201161980628967, 0.201322063803673, 0.201481580734253, 0.201640591025352, 0.20179907977581, 0.201957046985626, 0.202114447951317, 0.202271297574043, 0.202427640557289, 0.202583402395248, 0.202738687396049, 0.202893376350403, 0.203047558665276, 0.203201204538345, 0.203354358673096, 0.203506946563721, 0.203658953309059, 0.203810468316078, 0.203961417078972, 0.204111859202385, 0.204261720180511, 0.204411074519157, 0.204559892416, 0.204708188772202, 0.204855963587761, 0.205003157258034, 0.205149844288826, 0.205295950174332, 0.205441564321518, 0.20558662712574, 0.205731138586998, 0.205875128507614, 0.206018596887589, 0.206161543726921, 0.206303894519806, 0.206445753574371, 0.206587076187134, 0.206727832555771, 0.206868022680283, 0.207007735967636, 0.207146897912025, 0.207285553216934, 0.207423657178879, 0.207561194896698, 0.207698240876198, 0.207834720611572, 0.207970649003983, 0.20810604095459, 0.208240911364555, 0.208375215530396, 0.208509057760239, 0.208642333745956, 0.208775028586388, 0.208907246589661, 0.209038868546486, 0.209170028567314, 0.209300577640533, 0.209430620074272, 0.209560111165047, 0.209689110517502, 0.209817543625832, 0.20994545519352, 0.210072815418243, 0.210189908742905, 0.210300877690315, 0.210411101579666, 0.210520654916763, 0.210629492998123, 0.210737705230713, 0.210845187306404, 0.210951939225197, 0.211058020591736, 0.211163401603699, 0.211268097162247, 0.211372062563896, 0.211475402116776, 0.21157793700695, 0.211679846048355, 0.211781084537506, 0.211881563067436, 0.211981400847435, 0.212080538272858, 0.212178900837898, 0.212276607751846, 0.212373673915863, 0.21246999502182, 0.212565615773201, 0.212660551071167, 0.212754756212234, 0.212848350405693, 0.212941214442253, 0.213033318519592, 0.213124766945839, 0.213215529918671, 0.213305622339249, 0.213394939899445, 0.213483616709709, 0.213571548461914, 0.21365886926651, 0.213745459914207, 0.213831305503845, 0.21391649544239, 0.214000999927521, 0.214084789156914, 0.214167863130569, 0.214250281453133, 0.214331954717636, 0.214412972331047, 0.214493304491043, 0.214572906494141, 0.214651837944984, 0.21473003923893, 0.214807584881783, 0.214884385466576, 0.214960515499115, 0.215035945177078, 0.215110674500465, 0.215184733271599, 0.215258046984673, 0.215330734848976, 0.215402662754059, 0.215473920106888, 0.215544462203979, 0.21561436355114, 0.215683475136757, 0.215751990675926, 0.215819776058197, 0.215886801481247, 0.215953186154366, 0.216018855571747, 0.216083869338036, 0.216148123145103, 0.216211766004562, 0.216274619102478, 0.216336846351624, 0.216398373246193, 0.216459155082703, 0.21651928126812, 0.216578662395477, 0.216637432575226, 0.21669539809227, 0.216752737760544, 0.216809347271919, 0.216865256428719, 0.216920524835587, 0.216975048184395, 0.217028945684433, 0.217082053422928, 0.217134535312653, 0.217186242341995, 0.217237338423729, 0.217287644743919, 0.217337340116501, 0.217386305332184, 0.217434570193291, 0.217482149600983, 0.217528998851776, 0.217575192451477, 0.217620685696602, 0.217665508389473, 0.217709556221962, 0.21775296330452, 0.217795670032501, 0.217828422784805, 0.217853382229805, 0.217878118157387, 0.217902630567551, 0.217926934361458, 0.217951014637947, 0.217974901199341, 0.217998564243317, 0.218021988868713, 0.218045204877853, 0.218068242073059, 0.218091011047363, 0.218113586306572, 0.218135952949524, 0.218158081173897, 0.218180030584335, 0.218201711773872, 0.218223199248314, 0.218244478106499, 0.218265563249588, 0.218286380171776, 0.218307018280029, 0.218327432870865, 0.21834759414196, 0.218367576599121, 0.218387350440025, 0.218406900763512, 0.218426242470741, 0.218445330858231, 0.218464240431786, 0.2184828966856, 0.218501389026642, 0.218519642949104, 0.218537658452988, 0.218555495142937, 0.218573063611984, 0.218590453267097, 0.218607604503632, 0.21862456202507, 0.21864128112793, 0.218657806515694, 0.21867410838604, 0.218690186738968, 0.218706056475639, 0.218721717596054, 0.218737155199051, 0.218752354383469, 0.218767359852791, 0.218782141804695, 0.218796730041504, 0.218811079859734, 0.218825191259384, 0.2188391238451, 0.218852832913399, 0.218866318464279, 0.218879595398903, 0.218892633914948, 0.218905478715897, 0.218918114900589, 0.218930497765541, 0.218942701816559, 0.218954667448997, 0.218966424465179, 0.218977972865105, 0.218989282846451, 0.21900038421154, 0.219011276960373, 0.219021990895271, 0.219032436609268, 0.219042643904686, 0.219052702188492, 0.219062507152557, 0.219072088599205, 0.219081461429596, 0.219090640544891, 0.219099581241608, 0.219108298420906, 0.219116792082787, 0.21912507712841, 0.2191331833601, 0.21914105117321, 0.219148695468903, 0.219156116247177, 0.219163328409195, 0.219170346856117, 0.219177111983299, 0.219183668494225, 0.219190016388893, 0.219196155667305, 0.219202071428299, 0.219207763671875, 0.219213232398033, 0.219218537211418, 0.219223573803902, 0.219228386878967, 0.219233021140099, 0.219237416982651, 0.219241604208946, 0.219245567917824, 0.219249323010445, 0.21925351023674, 0.219254702329636, 0.21925650537014, 0.219258978962898, 0.21926212310791, 0.219265937805176, 0.219270393252373, 0.219275504350662, 0.219281330704689, 0.219287768006325, 0.219294875860214, 0.219302639365196, 0.219311058521271, 0.219320133328438, 0.21932989358902, 0.219340309500694, 0.219351440668106, 0.219363138079643, 0.219375550746918, 0.219388589262962, 0.219402298331261, 0.219416692852974, 0.219431698322296, 0.219447463750839, 0.219463810324669, 0.219480857253075, 0.219498500227928, 0.21951687335968, 0.219535857439041, 0.219555526971817, 0.219575881958008, 0.219596892595291, 0.219618543982506, 0.219640851020813, 0.219663828611374, 0.219687446951866, 0.219711735844612, 0.219736754894257, 0.219762340188026, 0.219788625836372, 0.219815582036972, 0.219843149185181, 0.219871431589127, 0.219900354743004, 0.219929918646812, 0.21996021270752, 0.219991132616997, 0.220022693276405, 0.220054924488068, 0.220087796449661, 0.22012135386467, 0.220155566930771, 0.220190435647964, 0.220226019620895, 0.220262199640274, 0.220299080014229, 0.220336586236954, 0.220374748110771, 0.220413595438004, 0.220453098416328, 0.220493301749229, 0.220534101128578, 0.220575630664825, 0.220617741346359, 0.220660537481308, 0.220704033970833, 0.220748141407967, 0.220792964100838, 0.22083842754364, 0.220884546637535, 0.220931306481361, 0.220978751778603, 0.221026837825775, 0.221075594425201, 0.221125066280365, 0.221175119280815, 0.221225887537003, 0.221277266740799, 0.22132933139801, 0.221382081508636, 0.221435472369194, 0.221489489078522, 0.221544221043587, 0.221599608659744, 0.221655622124672, 0.221712306141853, 0.221769690513611, 0.221827685832977, 0.221886366605759, 0.221945732831955, 0.222005754709244, 0.222066402435303, 0.222127690911293, 0.222189694643021, 0.22225233912468, 0.22231562435627, 0.222379639744759, 0.222444251179695, 0.222509548068047, 0.222575515508652, 0.222660958766937, 0.222763285040855, 0.222866535186768, 0.222970694303513, 0.223075732588768, 0.223181664943695, 0.223288550972939, 0.223396271467209, 0.223504915833473, 0.223614484071732, 0.223724961280823, 0.223836332559586, 0.223948612809181, 0.224061787128448, 0.224175840616226, 0.224290832877159, 0.224406704306602, 0.224523469805717, 0.224641159176826, 0.224759802222252, 0.224879279732704, 0.224999666213989, 0.225120961666107, 0.225243166089058, 0.22536626458168, 0.225490257143974, 0.225615203380585, 0.225741028785706, 0.225867733359337, 0.22599533200264, 0.226123839616776, 0.226253241300583, 0.226383596658707, 0.226514846086502, 0.22664700448513, 0.226780012249947, 0.226913958787918, 0.227048799395561, 0.227184519171715, 0.227321147918701, 0.227458745241165, 0.227597206830978, 0.227736547589302, 0.227876797318459, 0.22801798582077, 0.228160038590431, 0.228303000330925, 0.22844685614109, 0.22859163582325, 0.228737324476242, 0.228883907198906, 0.229031354188919, 0.229179754853249, 0.229329019784927, 0.229479223489761, 0.229630321264267, 0.229782357811928, 0.229935243725777, 0.230089038610458, 0.230243742465973, 0.230399340391159, 0.230555847287178, 0.230713278055191, 0.230871617794037, 0.231030836701393, 0.231190964579582, 0.231352001428604, 0.231513887643814, 0.231676712632179, 0.231840431690216, 0.232005104422569, 0.232170641422272, 0.232337087392807, 0.232504427433014, 0.232672661542892, 0.232841834425926, 0.23301188647747, 0.233182862401009, 0.233354717493057, 0.233527481555939, 0.233701169490814, 0.233875721693039, 0.234051153063774, 0.234227523207664, 0.23440483212471, 0.234583050012589, 0.234762087464333, 0.234942063689232, 0.235122963786125, 0.235304743051529, 0.235487446188927, 0.235671043395996, 0.235855594277382, 0.236040979623795, 0.23622727394104, 0.236414462327957, 0.236602559685707, 0.236791625618935, 0.23698154091835, 0.237172335386276, 0.237377285957336, 0.23759651184082, 0.237815603613853, 0.238034635782242, 0.238253518939018, 0.23847234249115, 0.238691046833992, 0.238909602165222, 0.239128097891808, 0.239346489310265, 0.239564791321754, 0.239782974123955, 0.240001052618027, 0.240218997001648, 0.240436866879463, 0.240654647350311, 0.240872278809547, 0.241089835762978, 0.241307303309441, 0.241524651646614, 0.241741880774498, 0.241959035396576, 0.242176070809364, 0.242393031716347, 0.242609813809395, 0.242826536297798, 0.243043169379234, 0.243259698152542, 0.243476122617722, 0.24369241297245, 0.243908628821373, 0.244124740362167, 0.244340762495995, 0.244556620717049, 0.244772404432297, 0.244988113641739, 0.245203673839569, 0.245419174432755, 0.24563455581665, 0.245849803090096, 0.246064990758896, 0.246280059218407, 0.246494993567467, 0.246709853410721, 0.246924623847008, 0.247139275074005, 0.247353836894035, 0.247568279504776, 0.247782617807388, 0.247996851801872, 0.248210996389389, 0.248425006866455, 0.248638913035393, 0.248852759599686, 0.249066472053528, 0.24928006529808, 0.249493584036827, 0.249706998467445, 0.249920278787613, 0.250133514404297, 0.250346571207047, 0.250559568405151, 0.250772476196289, 0.250985234975815, 0.251197904348373, 0.251410484313965, 0.251622974872589, 0.251835346221924, 0.252047598361969, 0.252259761095047, 0.252471834421158, 0.252683758735657, 0.252895593643188, 0.253107339143753, 0.253319025039673, 0.253530561923981, 0.253741979598999, 0.25395330786705, 0.254164546728134, 0.254375666379929, 0.254586666822433, 0.254797577857971, 0.255008399486542, 0.255219131708145, 0.255429714918137, 0.255640208721161, 0.255850613117218, 0.256060928106308, 0.256271094083786, 0.256481170654297, 0.256691157817841, 0.256901055574417, 0.257110804319382, 0.257320463657379, 0.257530033588409, 0.257739514112473, 0.257948875427246, 0.258158147335052, 0.258367270231247, 0.258576303720474, 0.258761346340179, 0.258922725915909, 0.259083449840546, 0.259243428707123, 0.259402632713318, 0.259561151266098, 0.259718924760818, 0.259875982999802, 0.260032325983047, 0.260187923908234, 0.260342806577682, 0.260497003793716, 0.260650396347046, 0.26080310344696, 0.260955095291138, 0.261106312274933, 0.261256873607635, 0.261406660079956, 0.261555731296539, 0.261704087257385, 0.261851698160172, 0.26199859380722, 0.262144774198532, 0.262290179729462, 0.262434929609299, 0.262578904628754, 0.262722194194794, 0.262864679098129, 0.26300647854805, 0.263147562742233, 0.263287961483002, 0.263427585363388, 0.263566493988037, 0.263704657554626, 0.263842105865479, 0.263978838920593, 0.264114797115326, 0.264250099658966, 0.264384657144547, 0.264518469572067, 0.264651566743851, 0.264783918857574, 0.264915555715561, 0.26504647731781, 0.265176653862, 0.265306115150452, 0.265434890985489, 0.265562862157822, 0.26569014787674, 0.26581671833992, 0.265942543745041, 0.266067653894424, 0.266192018985748, 0.266315668821335, 0.266438603401184, 0.266560792922974, 0.266682267189026, 0.266803026199341, 0.266923040151596, 0.267042338848114, 0.267160892486572, 0.267278760671616, 0.267395853996277, 0.267512232065201, 0.26762792468071, 0.267742842435837, 0.267857044935226, 0.267970532178879, 0.268083304166794, 0.268195331096649, 0.268306642770767, 0.268417209386826, 0.268527090549469, 0.26863619685173, 0.268744587898254, 0.268852263689041, 0.268959194421768, 0.269065409898758, 0.26917091012001, 0.269275695085526, 0.269379734992981, 0.269483059644699, 0.269585639238358, 0.269687503576279, 0.269788652658463, 0.269889026880264, 0.269988715648651, 0.270087689161301, 0.270185917615891, 0.270283430814743, 0.270380198955536, 0.270476251840591, 0.27057158946991, 0.270666182041168, 0.270760059356689, 0.270853221416473, 0.270945638418198, 0.271037310361862, 0.271128267049789, 0.271218538284302, 0.271303862333298, 0.27138414978981, 0.271464258432388, 0.271544098854065, 0.27162367105484, 0.271703094244003, 0.271782219409943, 0.271861135959625, 0.271939814090729, 0.272018253803253, 0.272096455097198, 0.272174447774887, 0.272252202033997, 0.272329747676849, 0.272407025098801, 0.27248403429985, 0.272560864686966, 0.272637456655502, 0.272713780403137, 0.272789895534515, 0.272865742444992, 0.272941410541534, 0.273016840219498, 0.273092001676559, 0.273166954517365, 0.273241639137268, 0.273316144943237, 0.273390382528305, 0.273464411497116, 0.273538172245026, 0.273611724376678, 0.273685038089752, 0.273758143186569, 0.273830950260162, 0.273903578519821, 0.273975938558578, 0.274048089981079, 0.274119973182678, 0.274191677570343, 0.274263113737106, 0.274334311485291, 0.27440533041954, 0.274476051330566, 0.274546533823013, 0.274616807699203, 0.274686843156815, 0.274756669998169, 0.274826228618622, 0.274895578622818, 0.274964690208435, 0.275033563375473, 0.275102227926254, 0.275170624256134, 0.275238782167435, 0.275306761264801, 0.275374472141266, 0.275441914796829, 0.275509178638458, 0.275576174259186, 0.275642931461334, 0.275709480047226, 0.275775790214539, 0.275841861963272, 0.275907695293427, 0.275973320007324, 0.276038706302643, 0.276103854179382, 0.27616873383522, 0.276233404874802, 0.276297867298126, 0.276362031698227, 0.276426017284393, 0.276489764451981, 0.276553273200989, 0.276616543531418, 0.27667960524559, 0.276742398738861, 0.276804983615875, 0.276867300271988, 0.276929408311844, 0.276991248130798, 0.277052879333496, 0.27711433172226, 0.277175515890121, 0.277236431837082, 0.277297168970108, 0.27735760807991, 0.277417838573456, 0.277477860450745, 0.277537614107132, 0.277597159147263, 0.277656465768814, 0.277715533971786, 0.27777436375618, 0.277832984924316, 0.277891337871552, 0.27794948220253, 0.278007388114929, 0.278065055608749, 0.27812248468399, 0.278195172548294, 0.278282284736633, 0.278369247913361, 0.278456002473831, 0.278542637825012, 0.278629064559937, 0.278715401887894, 0.278801500797272, 0.27888748049736, 0.278973251581192, 0.279058963060379, 0.279144406318665, 0.279229730367661, 0.279314875602722, 0.279399901628494, 0.27948471903801, 0.279569357633591, 0.279653906822205, 0.279738247394562, 0.279822438955307, 0.279906451702118, 0.279990255832672, 0.280073970556259, 0.280157506465912, 0.280240893363953, 0.280324071645737, 0.280407130718231, 0.280490010976791, 0.280572712421417, 0.280655294656754, 0.280737638473511, 0.280819863080978, 0.280901938676834, 0.280983865261078, 0.281065613031387, 0.281147181987762, 0.281228572130203, 0.281309843063354, 0.281390905380249, 0.281471848487854, 0.281552642583847, 0.281633228063583, 0.281713634729385, 0.281793981790543, 0.281874060630798, 0.281954050064087, 0.282033801078796, 0.282113462686539, 0.282192915678024, 0.282272189855576, 0.282351344823837, 0.282430291175842, 0.28250914812088, 0.282587766647339, 0.282666265964508, 0.282744616270065, 0.282822787761688, 0.282900750637054, 0.282978594303131, 0.283056288957596, 0.283133804798126, 0.283211141824722, 0.283288329839706, 0.283365368843079, 0.283442199230194, 0.28351891040802, 0.283595472574234, 0.283671826124191, 0.283748030662537, 0.28382408618927, 0.283899962902069, 0.283975690603256, 0.284051239490509, 0.28412663936615, 0.284201890230179, 0.284276932477951, 0.284351885318756, 0.284426629543304, 0.284501224756241, 0.284575611352921, 0.284649878740311, 0.284723967313766, 0.284797936677933, 0.284871697425842, 0.284945279359818, 0.285018742084503, 0.285092025995255, 0.285165190696716, 0.285238116979599, 0.28531089425087, 0.285383522510529, 0.285456031560898, 0.28552833199501, 0.285600513219833, 0.2856724858284, 0.285744279623032, 0.285815924406052, 0.285887449979782, 0.285958766937256, 0.286029934883118, 0.286093384027481, 0.286149203777313, 0.286204636096954, 0.286259591579437, 0.286314249038696, 0.286368429660797, 0.286422282457352, 0.286475718021393, 0.286528736352921, 0.28658139705658, 0.286633610725403, 0.286685436964035, 0.286736905574799, 0.286787927150726, 0.286838591098785, 0.286888808012009, 0.286938667297363, 0.286988139152527, 0.287037253379822, 0.287085860967636, 0.287134110927582, 0.287182003259659, 0.2872294485569, 0.287276536226273, 0.287323236465454, 0.287369549274445, 0.287415385246277, 0.28746086359024, 0.287505954504013, 0.287550628185272, 0.28759491443634, 0.28763884305954, 0.287682324647903, 0.287725448608398, 0.287768125534058, 0.287810444831848, 0.287852346897125, 0.287893861532211, 0.287934988737106, 0.28797572851181, 0.288016021251678, 0.288055926561356, 0.288095474243164, 0.288134634494781, 0.288173347711563, 0.288211673498154, 0.288249611854553, 0.288287132978439, 0.288324326276779, 0.288361042737961, 0.288397401571274, 0.288433372974396, 0.288468927145004, 0.288504064083099, 0.288538813591003, 0.288573175668716, 0.288607150316238, 0.288640707731247, 0.288673877716064, 0.288706690073013, 0.288739055395126, 0.288771033287048, 0.288802623748779, 0.288833826780319, 0.288864612579346, 0.288894981145859, 0.288924992084503, 0.288954585790634, 0.288983762264252, 0.289012581110001, 0.289040982723236, 0.289068967103958, 0.289096593856812, 0.289123833179474, 0.2891506254673, 0.289177060127258, 0.289203077554703, 0.289228737354279, 0.289253950119019, 0.289278775453568, 0.289303243160248, 0.28932723402977, 0.289350897073746, 0.289374113082886, 0.289396971464157, 0.289419412612915, 0.289441466331482, 0.289463132619858, 0.28948438167572, 0.289505243301392, 0.289525717496872, 0.289545744657516, 0.289565443992615, 0.2895847260952, 0.289603590965271, 0.289622068405151, 0.289640158414841, 0.289657831192017, 0.289675116539001, 0.289691984653473, 0.289707124233246, 0.289720743894577, 0.289734095335007, 0.28974711894989, 0.289759904146194, 0.289772391319275, 0.289784610271454, 0.289796501398087, 0.28980815410614, 0.289819478988647, 0.289830565452576, 0.289841324090958, 0.289851874113083, 0.289862036705017, 0.289871990680695, 0.289881616830826, 0.289891004562378, 0.289900064468384, 0.289908885955811, 0.289917379617691, 0.28992560505867, 0.289933532476425, 0.289941251277924, 0.289948582649231, 0.289955675601959, 0.289962440729141, 0.289968997240067, 0.289975255727768, 0.289981216192245, 0.289986878633499, 0.289992272853851, 0.28999736905098, 0.290002167224884, 0.290006697177887, 0.290010958909988, 0.290014892816544, 0.29001858830452, 0.290022015571594, 0.290025115013123, 0.290027976036072, 0.290030479431152, 0.290032744407654, 0.290034770965576, 0.29003643989563, 0.290037840604782, 0.290038973093033, 0.29003980755806, 0.290040343999863, 0.290040642023087, 0.290040642023087, 0.29004031419754, 0.290039747953415, 0.290038913488388, 0.290037721395493, 0.29003632068634, 0.290034592151642, 0.290032625198364, 0.290030300617218, 0.290027767419815, 0.290024936199188, 0.290021747350693, 0.290018320083618, 0.290014654397964, 0.290010660886765, 0.290006399154663, 0.290001839399338, 0.289996981620789, 0.28999188542366, 0.289986461400986, 0.28998076915741, 0.289974808692932, 0.289968520402908, 0.289961993694305, 0.289955139160156, 0.289948046207428, 0.289940655231476, 0.2899329662323, 0.289925009012222, 0.289916783571243, 0.28990826010704, 0.289899408817291, 0.289890348911285, 0.289880931377411, 0.28987130522728, 0.289861291646957, 0.289851099252701, 0.289840579032898, 0.289829730987549, 0.289818674325943, 0.289807289838791, 0.28979566693306, 0.28978368639946, 0.289771467447281, 0.2897589802742, 0.289746195077896, 0.289733111858368, 0.289719730615616, 0.289706110954285, 0.28969219326973, 0.289677947759628, 0.289664298295975, 0.289651364088058, 0.289638310670853, 0.28962504863739, 0.289611667394638, 0.289598107337952, 0.289584428071976, 0.289570569992065, 0.289556562900543, 0.289542406797409, 0.289528101682663, 0.289513617753983, 0.28949898481369, 0.289484262466431, 0.289469301700592, 0.289454251527786, 0.289438992738724, 0.289423584938049, 0.289408057928085, 0.289392352104187, 0.289376527070999, 0.289360523223877, 0.289344370365143, 0.289328068494797, 0.289311617612839, 0.289294958114624, 0.289278209209442, 0.289261281490326, 0.289244204759598, 0.289226979017258, 0.289209574460983, 0.289192050695419, 0.289174348115921, 0.289156526327133, 0.289138495922089, 0.289120376110077, 0.289102047681808, 0.28908360004425, 0.289065003395081, 0.289046227931976, 0.28902730345726, 0.289008259773254, 0.28898897767067, 0.28896963596344, 0.288950115442276, 0.288930386304855, 0.288910567760468, 0.288890540599823, 0.288870394229889, 0.288850098848343, 0.288829654455185, 0.288809061050415, 0.288788288831711, 0.288767337799072, 0.288746297359467, 0.288725048303604, 0.288703709840775, 0.288682162761688, 0.28866046667099, 0.288638651371002, 0.288616627454758, 0.288594484329224, 0.288572192192078, 0.288549721240997, 0.288527131080627, 0.288504362106323, 0.288481473922729, 0.288458377122879, 0.288435161113739, 0.288411796092987, 0.288388282060623, 0.288364589214325, 0.288340747356415, 0.288316756486893, 0.288292616605759, 0.288268327713013, 0.288243860006332, 0.28821924328804, 0.288194507360458, 0.288169592618942, 0.288144528865814, 0.288119316101074, 0.288093954324722, 0.288068413734436, 0.288042724132538, 0.28801691532135, 0.287990897893906, 0.287964761257172, 0.287938475608826, 0.287912011146545, 0.287885427474976, 0.287858664989471, 0.287831753492355, 0.28780472278595, 0.28777751326561, 0.287750154733658, 0.287722587585449, 0.287694901227951, 0.287667095661163, 0.287639111280441, 0.287609785795212, 0.287579208612442, 0.287548691034317, 0.287518084049225, 0.287487506866455, 0.287456899881363, 0.287426352500916, 0.287395715713501, 0.287365138530731, 0.287334471940994, 0.287303864955902, 0.287273198366165, 0.287242591381073, 0.287211924791336, 0.287181198596954, 0.28715056180954, 0.28711986541748, 0.287089169025421, 0.287058442831039, 0.28702774643898, 0.286997020244598, 0.286966264247894, 0.28693550825119, 0.286904782056808, 0.286873996257782, 0.286843210458755, 0.286812424659729, 0.286781638860703, 0.286750793457031, 0.286720007658005, 0.286689192056656, 0.286658346652985, 0.286627501249313, 0.286596655845642, 0.286565810441971, 0.286534905433655, 0.286504030227661, 0.286473155021667, 0.286442250013351, 0.286411315202713, 0.286380410194397, 0.286349505186081, 0.286318510770798, 0.286287605762482, 0.286256611347198, 0.28622567653656, 0.286194652318954, 0.286163687705994, 0.28613269329071, 0.286101698875427, 0.286070674657822, 0.286039650440216, 0.286008596420288, 0.285977572202682, 0.285946518182755, 0.285915464162827, 0.285884350538254, 0.285853326320648, 0.285822212696075, 0.285791099071503, 0.28575998544693, 0.285728871822357, 0.285697728395462, 0.285666584968567, 0.285635411739349, 0.285604298114777, 0.285573124885559, 0.285541951656342, 0.285510718822479, 0.285479545593262, 0.285448342561722, 0.285417109727859, 0.28538590669632, 0.285354673862457, 0.285323441028595, 0.285292148590088, 0.285260885953903, 0.285229653120041, 0.285198360681534, 0.285167068243027, 0.285135746002197, 0.285104423761368, 0.285073101520538, 0.285041779279709, 0.285010457038879, 0.284979075193405, 0.284947752952576, 0.284916371107101, 0.284884989261627, 0.284853577613831, 0.284822165966034, 0.28479078412056, 0.284759342670441, 0.284727901220322, 0.284696489572525, 0.284665048122406, 0.284633576869965, 0.284602135419846, 0.284570634365082, 0.28453916311264, 0.284508615732193, 0.28447899222374, 0.284449547529221, 0.284420222043991, 0.284391045570374, 0.28436204791069, 0.284333169460297, 0.284304440021515, 0.284275889396667, 0.28424745798111, 0.284219175577164, 0.28419104218483, 0.284163057804108, 0.284135222434998, 0.284107536077499, 0.284079998731613, 0.284052580595016, 0.284025371074677, 0.283998250961304, 0.283971279859543, 0.283944517374039, 0.283917844295502, 0.283891350030899, 0.283864974975586, 0.283838778734207, 0.283812701702118, 0.283786773681641, 0.283761024475098, 0.283735424280167, 0.283709943294525, 0.283684581518173, 0.283659428358078, 0.283634394407272, 0.283609539270401, 0.283584803342819, 0.283560216426849, 0.283535778522491, 0.283511459827423, 0.283487319946289, 0.283463329076767, 0.283439487218857, 0.283415794372559, 0.28339222073555, 0.283368825912476, 0.283345580101013, 0.283322483301163, 0.283299505710602, 0.283276677131653, 0.283254057168961, 0.283231526613235, 0.283209174871445, 0.283186912536621, 0.283164858818054, 0.283142924308777, 0.283121138811111, 0.283099502325058, 0.283078014850616, 0.283056676387787, 0.283035516738892, 0.283014476299286, 0.28299355506897, 0.28297284245491, 0.282952219247818, 0.28293177485466, 0.282911479473114, 0.28289133310318, 0.282871305942535, 0.282851457595825, 0.282831728458405, 0.282812207937241, 0.282792776823044, 0.282773524522781, 0.282754391431808, 0.282735407352448, 0.282716572284698, 0.282697886228561, 0.282679349184036, 0.282660990953445, 0.282642751932144, 0.282624691724777, 0.282606720924377, 0.282588958740234, 0.282571285963058, 0.282553821802139, 0.282536447048187, 0.28251925110817, 0.282502204179764, 0.282485276460648, 0.282468527555466, 0.282451927661896, 0.282435476779938, 0.282419174909592, 0.282402992248535, 0.282386958599091, 0.282371133565903, 0.282355397939682, 0.282339811325073, 0.282324373722076, 0.282309085130692, 0.282293975353241, 0.282281577587128, 0.282271414995193, 0.282261431217194, 0.282251626253128, 0.282242000102997, 0.2822325527668, 0.282223284244537, 0.282214164733887, 0.282205283641815, 0.282196491956711, 0.282187968492508, 0.282179594039917, 0.282171338796616, 0.282163321971893, 0.282155483961105, 0.282147794961929, 0.282140284776688, 0.282132983207703, 0.282125800848007, 0.282118856906891, 0.282112061977386, 0.282105445861816, 0.282099008560181, 0.282092750072479, 0.282086670398712, 0.282080799341202, 0.282075047492981, 0.282069474458694, 0.282064110040665, 0.282058924436569, 0.282053887844086, 0.282049089670181, 0.282044380903244, 0.282039910554886, 0.28203558921814, 0.28203147649765, 0.282027512788773, 0.282023757696152, 0.28202012181282, 0.282016694545746, 0.282013475894928, 0.282010436058044, 0.28200751543045, 0.282004803419113, 0.28200227022171, 0.281999915838242, 0.28199777007103, 0.281995743513107, 0.281993955373764, 0.281992256641388, 0.281990766525269, 0.281989485025406, 0.281988382339478, 0.281987428665161, 0.281986683607101, 0.281986117362976, 0.281985700130463, 0.281985461711884, 0.281985402107239, 0.281985521316528, 0.281985849142075, 0.28198629617691, 0.281986951828003, 0.28198778629303, 0.281988829374313, 0.281989991664886, 0.281991392374039, 0.281992942094803, 0.281994640827179, 0.281996518373489, 0.281998604536057, 0.282000869512558, 0.282003313302994, 0.282005906105042, 0.282008677721024, 0.282011657953262, 0.282014787197113, 0.28201812505722, 0.28202161192894, 0.282025307416916, 0.282029122114182, 0.282033175230026, 0.282037347555161, 0.282041728496552, 0.282046288251877, 0.282051056623459, 0.282055974006653, 0.282061040401459, 0.282066315412521, 0.282071769237518, 0.282077372074127, 0.282083183526993, 0.28208914399147, 0.282095313072205, 0.282101631164551, 0.282108157873154, 0.282114803791046, 0.28212171792984, 0.282128721475601, 0.282135963439941, 0.282145917415619, 0.28215879201889, 0.282171607017517, 0.282184451818466, 0.282197266817093, 0.28221008181572, 0.282222956418991, 0.282235831022263, 0.282248705625534, 0.282261520624161, 0.282274395227432, 0.282287299633026, 0.282300174236298, 0.282313048839569, 0.282325983047485, 0.282338857650757, 0.282351762056351, 0.282364696264267, 0.282377600669861, 0.282390534877777, 0.282403469085693, 0.28241640329361, 0.282429337501526, 0.282442271709442, 0.282455205917358, 0.282468169927597, 0.282481133937836, 0.282494068145752, 0.282507061958313, 0.282520055770874, 0.282533019781113, 0.282546013593674, 0.282559037208557, 0.282572001218796, 0.282585024833679, 0.282598078250885, 0.282611072063446, 0.282624095678329, 0.282637119293213, 0.282650113105774, 0.282663196325302, 0.282676249742508, 0.282689332962036, 0.282702386379242, 0.282715439796448, 0.282728523015976, 0.282741576433182, 0.282754629850388, 0.282767772674561, 0.282780826091766, 0.282793968915939, 0.282807052135468, 0.282820165157318, 0.282833278179169, 0.282846421003342, 0.282859534025192, 0.282872676849365, 0.282885789871216, 0.282898932695389, 0.282912135124207, 0.282925248146057, 0.282938420772552, 0.282951563596725, 0.282964766025543, 0.282977938652039, 0.282991111278534, 0.283004283905029, 0.283017516136169, 0.283030688762665, 0.283043920993805, 0.283057123422623, 0.283070355653763, 0.283083587884903, 0.283096820116043, 0.283110022544861, 0.283123284578323, 0.283136546611786, 0.283149808645248, 0.283163070678711, 0.283176302909851, 0.283189564943314, 0.283202856779099, 0.283216148614883, 0.283229410648346, 0.283242732286453, 0.283255994319916, 0.283269315958023, 0.28328263759613, 0.283295959234238, 0.283309280872345, 0.283322602510452, 0.28333592414856, 0.283349245786667, 0.283362597227097, 0.283375978469849, 0.283389329910278, 0.283402681350708, 0.28341606259346, 0.28342941403389, 0.283442765474319, 0.283454149961472, 0.283464193344116, 0.283473998308182, 0.283483654260635, 0.283493012189865, 0.283502221107483, 0.283511191606522, 0.283519953489304, 0.283528506755829, 0.28353688120842, 0.283544987440109, 0.283552914857864, 0.28356060385704, 0.283568114042282, 0.283575415611267, 0.283582478761673, 0.283589333295822, 0.283595979213715, 0.28360241651535, 0.283608675003052, 0.283614665269852, 0.283620476722717, 0.283626049757004, 0.283631414175034, 0.283636599779129, 0.283641576766968, 0.283646315336227, 0.28365084528923, 0.283655166625977, 0.283659309148788, 0.283663183450699, 0.283666878938675, 0.283670365810394, 0.283673584461212, 0.283676713705063, 0.283679515123367, 0.283682137727737, 0.283684581518173, 0.28368678689003, 0.28368878364563, 0.283690541982651, 0.28369215130806, 0.28369352221489, 0.28369465470314, 0.283695578575134, 0.283696293830872, 0.283696860074997, 0.283697128295898, 0.283697247505188, 0.283697068691254, 0.28369677066803, 0.283696234226227, 0.283695459365845, 0.283694475889206, 0.283693313598633, 0.283691972494125, 0.283690333366394, 0.283688545227051, 0.283686518669128, 0.283684253692627, 0.283681809902191, 0.283679157495499, 0.283676326274872, 0.283673197031021, 0.283669918775558, 0.283666431903839, 0.283662706613541, 0.283658772706985, 0.283654659986496, 0.283650308847427, 0.28364571928978, 0.28364098072052, 0.283635944128036, 0.283630788326263, 0.283625334501266, 0.283619731664658, 0.28361389040947, 0.28360790014267, 0.283601611852646, 0.283595144748688, 0.283588498830795, 0.283581584692001, 0.283574491739273, 0.283567160367966, 0.283559650182724, 0.283551901578903, 0.283543944358826, 0.283535808324814, 0.283527433872223, 0.283518821001053, 0.283510059118271, 0.28350105881691, 0.283491849899292, 0.283482432365417, 0.283472776412964, 0.283462911844254, 0.283452868461609, 0.283442586660385, 0.283432096242905, 0.28342142701149, 0.283404022455215, 0.283381313085556, 0.283358424901962, 0.283335417509079, 0.283312320709229, 0.283289045095444, 0.283265620470047, 0.283242136240005, 0.28321847319603, 0.283194690942764, 0.283170759677887, 0.28314670920372, 0.283122509717941, 0.283098191022873, 0.283073753118515, 0.283049166202545, 0.283024430274963, 0.282999604940414, 0.282974600791931, 0.282949507236481, 0.282924234867096, 0.282898873090744, 0.28287336230278, 0.282847702503204, 0.282821923494339, 0.282796025276184, 0.282769978046417, 0.282743811607361, 0.282717525959015, 0.282691061496735, 0.282664477825165, 0.282637804746628, 0.282610952854156, 0.28258404135704, 0.282556891441345, 0.282529681921005, 0.282502323389053, 0.282474786043167, 0.282447189092636, 0.282419443130493, 0.282391548156738, 0.282363504171371, 0.282335370779037, 0.282307088375092, 0.282278627157211, 0.282250106334686, 0.282221406698227, 0.282192587852478, 0.28216364979744, 0.282134562730789, 0.282105356454849, 0.282076001167297, 0.282046526670456, 0.282016903162003, 0.28198716044426, 0.281957268714905, 0.28192725777626, 0.281897127628326, 0.281866848468781, 0.281836450099945, 0.28180593252182, 0.281775265932083, 0.281744420528412, 0.281713515520096, 0.281682461500168, 0.281651258468628, 0.281619936227798, 0.281588494777679, 0.281556874513626, 0.281525164842606, 0.281493306159973, 0.281461298465729, 0.281429171562195, 0.281396925449371, 0.281364530324936, 0.281331986188889, 0.281299352645874, 0.281266540288925, 0.281233638525009, 0.281200617551804, 0.281167447566986, 0.281134098768234, 0.281100660562515, 0.281067103147507, 0.281033337116241, 0.280999541282654, 0.280965566635132, 0.280931413173676, 0.280897200107574, 0.280862867832184, 0.280828326940536, 0.280793696641922, 0.280758917331696, 0.280723989009857, 0.280688971281052, 0.280653834342957, 0.280618518590927, 0.280583083629608, 0.280547499656677, 0.280511796474457, 0.280478179454803, 0.280445754528046, 0.280413508415222, 0.280381321907043, 0.280349284410477, 0.280317336320877, 0.280285537242889, 0.280253827571869, 0.28022226691246, 0.280190765857697, 0.280159384012222, 0.28012815117836, 0.280097037553787, 0.280066013336182, 0.280035078525543, 0.280004292726517, 0.279973655939102, 0.27994304895401, 0.279912620782852, 0.279882341623306, 0.279852092266083, 0.279821991920471, 0.279791980981827, 0.279762089252472, 0.279732346534729, 0.279702723026276, 0.279673159122467, 0.279643774032593, 0.279614448547363, 0.279585272073746, 0.279556214809418, 0.279527246952057, 0.279498428106308, 0.279469668865204, 0.279441058635712, 0.279412537813187, 0.279384136199951, 0.279355883598328, 0.279327750205994, 0.279299676418304, 0.27927178144455, 0.279243946075439, 0.279216259717941, 0.27918866276741, 0.279161214828491, 0.279133856296539, 0.279106587171555, 0.279079467058182, 0.279052466154099, 0.279025584459305, 0.278998762369156, 0.278972089290619, 0.278945565223694, 0.278919100761414, 0.278892755508423, 0.278866559267044, 0.278840482234955, 0.278814494609833, 0.278788626194, 0.278762876987457, 0.278737217187881, 0.278711676597595, 0.278686314821243, 0.278660982847214, 0.278635799884796, 0.278610736131668, 0.27858579158783, 0.278560966253281, 0.278536200523376, 0.278511613607407, 0.278487116098404, 0.278462737798691, 0.278438478708267, 0.278414309024811, 0.278390288352966, 0.278366357088089, 0.278342545032501, 0.278318822383881, 0.278295278549194, 0.278271824121475, 0.278248459100723, 0.278225213289261, 0.278202086687088, 0.278179079294205, 0.278156161308289, 0.278133392333984, 0.27811074256897, 0.278088212013245, 0.278065770864487, 0.278043448925018, 0.278021216392517, 0.277999132871628, 0.277977138757706, 0.277955293655396, 0.277933567762375, 0.277911901473999, 0.277890354394913, 0.277868956327438, 0.277847677469254, 0.277826517820358, 0.277811318635941, 0.277799874544144, 0.277788549661636, 0.277777373790741, 0.27776625752449, 0.277755230665207, 0.277744352817535, 0.277733564376831, 0.277722865343094, 0.277712255716324, 0.277701765298843, 0.277691423892975, 0.277681142091751, 0.277670979499817, 0.27766090631485, 0.277650892734528, 0.277641028165817, 0.277631282806396, 0.277621626853943, 0.277612090110779, 0.27760261297226, 0.277593314647675, 0.277584075927734, 0.277574956417084, 0.277565896511078, 0.277556955814362, 0.277548164129257, 0.277539432048798, 0.27753084897995, 0.277522295713425, 0.277513921260834, 0.277505606412888, 0.277497410774231, 0.277489304542542, 0.277481287717819, 0.277473449707031, 0.277465641498566, 0.277457982301712, 0.277450412511826, 0.277442932128906, 0.277435570955276, 0.277428328990936, 0.277421146631241, 0.277414113283157, 0.277407139539719, 0.277400255203247, 0.277393519878387, 0.277386903762817, 0.277380377054214, 0.277373939752579, 0.27736759185791, 0.277361392974854, 0.277355283498764, 0.277349233627319, 0.277343332767487, 0.277337521314621, 0.277331829071045, 0.277326226234436, 0.277320742607117, 0.277315348386765, 0.27731004357338, 0.277304857969284, 0.277299791574478, 0.277294844388962, 0.277289927005768, 0.277285218238831, 0.277280509471893, 0.277275949716568, 0.27727147936821, 0.277267158031464, 0.277262896299362, 0.27725875377655, 0.277254670858383, 0.27725076675415, 0.277246922254562, 0.277243226766586, 0.277239561080933, 0.277236044406891, 0.277232617139816, 0.277229338884354, 0.277226120233536, 0.277223020792007, 0.277220010757446, 0.277217119932175, 0.27721431851387, 0.277211636304855, 0.277209043502808, 0.277206569910049, 0.277204155921936, 0.277201890945435, 0.277199745178223, 0.277197688817978, 0.277195692062378, 0.277193874120712, 0.277192115783691, 0.277190446853638, 0.277188897132874, 0.277187466621399, 0.277186125516891, 0.277184903621674, 0.27718797326088, 0.277196049690247, 0.277203857898712, 0.277211338281631, 0.277218580245972, 0.277225524187088, 0.27723217010498, 0.277238517999649, 0.277244597673416, 0.277250379323959, 0.277255833148956, 0.277261078357697, 0.277265995740891, 0.277270644903183, 0.277274996042252, 0.277279019355774, 0.277282804250717, 0.277286291122437, 0.277289479970932, 0.277292370796204, 0.277295023202896, 0.277297347784042, 0.277299404144287, 0.27730119228363, 0.277302622795105, 0.277303844690323, 0.277304738759995, 0.27730530500412, 0.277305662631989, 0.277305692434311, 0.277305454015732, 0.277304887771606, 0.277304083108902, 0.277302980422974, 0.277301579713821, 0.277299880981445, 0.27729794383049, 0.277295649051666, 0.277293086051941, 0.277290254831314, 0.277287155389786, 0.277283728122711, 0.277280032634735, 0.277276009321213, 0.277271777391434, 0.277267217636108, 0.277262330055237, 0.277257233858109, 0.277251809835434, 0.277246087789536, 0.277240067720413, 0.277233809232712, 0.277227252721786, 0.277220398187637, 0.277213215827942, 0.277205795049667, 0.277198076248169, 0.277190059423447, 0.277181804180145, 0.277173191308975, 0.277164340019226, 0.277155131101608, 0.277145743370056, 0.277135968208313, 0.277125954627991, 0.277115613222122, 0.277105093002319, 0.277094155550003, 0.27708300948143, 0.277071505784988, 0.277059823274612, 0.277047783136368, 0.277035444974899, 0.277022808790207, 0.277009963989258, 0.27699676156044, 0.276983290910721, 0.2769695520401, 0.276955485343933, 0.276941210031509, 0.276926517486572, 0.276911646127701, 0.276896446943283, 0.276880979537964, 0.276865214109421, 0.276849180459976, 0.276832818984985, 0.276816189289093, 0.276799261569977, 0.276782065629959, 0.276764571666718, 0.276746779680252, 0.276728749275208, 0.276710391044617, 0.276691734790802, 0.276672810316086, 0.276653587818146, 0.276634097099304, 0.276614278554916, 0.276594221591949, 0.276564478874207, 0.276527792215347, 0.276490479707718, 0.276452720165253, 0.276414304971695, 0.276375412940979, 0.276335924863815, 0.276295900344849, 0.276255339384079, 0.276214212179184, 0.276172488927841, 0.276130259037018, 0.276087462902069, 0.276044100522995, 0.27600023150444, 0.27595579624176, 0.27591073513031, 0.275865226984024, 0.275819063186646, 0.275772482156754, 0.275725215673447, 0.275677442550659, 0.275629162788391, 0.275580257177353, 0.275530844926834, 0.27548086643219, 0.275430351495743, 0.275379240512848, 0.27532759308815, 0.275275379419327, 0.275222688913345, 0.275169372558594, 0.275115519762039, 0.275061130523682, 0.275006145238876, 0.27495065331459, 0.274894595146179, 0.274838000535965, 0.274780809879303, 0.27472311258316, 0.27466481924057, 0.274606019258499, 0.27454662322998, 0.274486690759659, 0.274426221847534, 0.274365186691284, 0.274303585290909, 0.27424144744873, 0.274178743362427, 0.274115532636642, 0.274051696062088, 0.273987352848053, 0.273922473192215, 0.273857027292252, 0.27379098534584, 0.273724436759949, 0.273657292127609, 0.273589640855789, 0.273521423339844, 0.273452669382095, 0.273383319377899, 0.2733134329319, 0.273243010044098, 0.27317202091217, 0.273100465536118, 0.273028403520584, 0.272955715656281, 0.272882580757141, 0.272808820009232, 0.272734493017197, 0.272659629583359, 0.272584229707718, 0.272508263587952, 0.272431761026382, 0.272354692220688, 0.27227708697319, 0.272198885679245, 0.272120177745819, 0.272040903568268, 0.271961033344269, 0.271880656480789, 0.271799713373184, 0.271718263626099, 0.271636217832565, 0.271553575992584, 0.271470457315445, 0.27138677239418, 0.27130252122879, 0.271217703819275, 0.271132349967957, 0.271046429872513, 0.270959973335266, 0.270872950553894, 0.270785391330719, 0.270697265863419, 0.270608603954315, 0.270519345998764, 0.270429581403732, 0.270339250564575, 0.270248353481293, 0.270148456096649, 0.270043551921844, 0.269938379526138, 0.269832998514175, 0.269727319478989, 0.269621461629868, 0.269515335559845, 0.269408971071243, 0.269302397966385, 0.269195526838303, 0.269088476896286, 0.26898118853569, 0.268873631954193, 0.268765866756439, 0.268657833337784, 0.268549591302872, 0.268441081047058, 0.268332362174988, 0.268223404884338, 0.26811420917511, 0.26800474524498, 0.267895072698593, 0.267785131931305, 0.267675012350082, 0.267564594745636, 0.267453968524933, 0.267343133687973, 0.267232000827789, 0.267120718955994, 0.267009109258652, 0.266897290945053, 0.266785234212875, 0.266672939062119, 0.266560405492783, 0.26644766330719, 0.266334652900696, 0.266221433877945, 0.266107946634293, 0.265994250774384, 0.265880286693573, 0.265766113996506, 0.265651702880859, 0.265537023544312, 0.265422105789185, 0.265306979417801, 0.265191614627838, 0.265076011419296, 0.264960139989853, 0.264844059944153, 0.264727741479874, 0.264611154794693, 0.264494389295578, 0.264377325773239, 0.264260083436966, 0.264142543077469, 0.264024823904037, 0.263906806707382, 0.263788610696793, 0.263670146465302, 0.263551443815231, 0.263432532548904, 0.263313353061676, 0.263193935155869, 0.263074308633804, 0.262954413890839, 0.262834280729294, 0.262713938951492, 0.262593358755112, 0.26247251033783, 0.262351453304291, 0.26223012804985, 0.262108594179153, 0.261986792087555, 0.2618647813797, 0.261742532253265, 0.261620044708252, 0.261497288942337, 0.261374324560165, 0.261251121759415, 0.261127710342407, 0.261004030704498, 0.260880082845688, 0.260755956172943, 0.260631561279297, 0.260506927967072, 0.260382026433945, 0.260256946086884, 0.260131627321243, 0.260006010532379, 0.259880214929581, 0.259754151105881, 0.259627878665924, 0.259501338005066, 0.259374588727951, 0.259247571229935, 0.259120345115662, 0.258992880582809, 0.258865177631378, 0.258737206459045, 0.258608996868134, 0.25849375128746, 0.258386075496674, 0.25827831029892, 0.258170485496521, 0.258062571287155, 0.257954597473145, 0.257846504449844, 0.257738411426544, 0.257630169391632, 0.25752192735672, 0.257413566112518, 0.257305175065994, 0.257196664810181, 0.257088124752045, 0.256979465484619, 0.256870776414871, 0.256761968135834, 0.256653130054474, 0.256544202566147, 0.256435185670853, 0.256326109170914, 0.25621697306633, 0.256107747554779, 0.255998492240906, 0.255889087915421, 0.255779653787613, 0.255670130252838, 0.255560547113419, 0.255450934171677, 0.255341172218323, 0.255231350660324, 0.255121499300003, 0.255011558532715, 0.254901498556137, 0.254791438579559, 0.254681259393692, 0.25457102060318, 0.254460692405701, 0.254350334405899, 0.254239857196808, 0.254129320383072, 0.254018723964691, 0.253908038139343, 0.253797322511673, 0.253686487674713, 0.253575563430786, 0.253464609384537, 0.25335356593132, 0.253242462873459, 0.25313127040863, 0.253020018339157, 0.252908676862717, 0.252797275781631, 0.252685815095901, 0.252574265003204, 0.25246262550354, 0.252350926399231, 0.252239167690277, 0.252127319574356, 0.25201541185379, 0.251903414726257, 0.25179135799408, 0.251679211854935, 0.251567006111145, 0.251454740762711, 0.251342386007309, 0.25122994184494, 0.251117467880249, 0.251004874706268, 0.250892251729965, 0.250779539346695, 0.250666737556458, 0.250553876161575, 0.250440925359726, 0.250327944755554, 0.250214815139771, 0.250101685523987, 0.249988466501236, 0.249875158071518, 0.249761790037155, 0.249648347496986, 0.249534845352173, 0.249421238899231, 0.249307572841644, 0.249193832278252, 0.249080032110214, 0.24896614253521, 0.248852208256721, 0.248738169670105, 0.248624071478844, 0.248509913682938, 0.248395636677742, 0.248281329870224, 0.248166918754578, 0.248052477836609, 0.247937917709351, 0.247823312878609, 0.247708633542061, 0.247593864798546, 0.247479051351547, 0.247363731265068, 0.247246220707893, 0.247128427028656, 0.247010380029678, 0.246892020106316, 0.246773451566696, 0.246654525399208, 0.246535360813141, 0.246415928006172, 0.246296212077141, 0.246176227927208, 0.246055915951729, 0.245935365557671, 0.245814546942711, 0.245693430304527, 0.245572030544281, 0.245450347661972, 0.245328411459923, 0.245206192135811, 0.245083689689636, 0.244960889220238, 0.24483785033226, 0.244714513421059, 0.244590878486633, 0.244466975331306, 0.244342803955078, 0.244218334555626, 0.244093641638756, 0.243968620896339, 0.24384331703186, 0.243717759847641, 0.243591919541359, 0.243465811014175, 0.243339389562607, 0.243212729692459, 0.243085771799088, 0.242958545684814, 0.242831036448479, 0.24270324409008, 0.242575153708458, 0.242446839809418, 0.242318198084831, 0.242189273238182, 0.242060095071793, 0.241930648684502, 0.241800904273987, 0.241670906543732, 0.241540595889091, 0.241410046815872, 0.241279184818268, 0.241148069500923, 0.241016656160355, 0.240884974598885, 0.240752980113029, 0.240620777010918, 0.24048824608326, 0.240355432033539, 0.2402223944664, 0.240089043974876, 0.23995541036129, 0.239821448922157, 0.239687278866768, 0.239552825689316, 0.23941807448864, 0.239283069968224, 0.239147752523422, 0.239012211561203, 0.238876327872276, 0.238740190863609, 0.238603785634041, 0.238467112183571, 0.238330125808716, 0.238192871212959, 0.238055318593979, 0.237917542457581, 0.23777948319912, 0.237641125917435, 0.237502455711365, 0.237363532185555, 0.237224370241165, 0.237084895372391, 0.236945122480392, 0.236805096268654, 0.236664801836014, 0.236524224281311, 0.236383363604546, 0.236242219805717, 0.236100777983665, 0.235959097743034, 0.235817104578018, 0.235674858093262, 0.235532313585281, 0.235389530658722, 0.235246449708939, 0.23510305583477, 0.234959438443184, 0.234815508127213, 0.23467130959034, 0.234526827931404, 0.234382048249245, 0.234221443533897, 0.234054580330849, 0.233887657523155, 0.233720764517784, 0.233553856611252, 0.233386993408203, 0.233220085501671, 0.2330531924963, 0.232886269688606, 0.232719391584396, 0.232552513480186, 0.232385620474815, 0.232218697667122, 0.232051819562912, 0.23188491165638, 0.231718063354492, 0.231551170349121, 0.231384292244911, 0.231217384338379, 0.231050491333008, 0.230883598327637, 0.230716705322266, 0.230549812316895, 0.230382919311523, 0.230216041207314, 0.23004911839962, 0.22988224029541, 0.2297153621912, 0.229548469185829, 0.229381546378136, 0.229214653372765, 0.229047760367393, 0.228880867362022, 0.228713974356651, 0.22854708135128, 0.22838020324707, 0.228213295340538, 0.228046402335167, 0.227879539132118, 0.227712646126747, 0.227545782923698, 0.227378875017166, 0.227211982011795, 0.227045059204102, 0.226878196001053, 0.226711302995682, 0.226544409990311, 0.226377487182617, 0.226210594177246, 0.226043730974197, 0.225876823067665, 0.225709915161133, 0.225543022155762, 0.225376144051552, 0.22520923614502, 0.225042343139648, 0.224875465035439, 0.224708527326584, 0.224541693925858, 0.224374771118164, 0.224207922816277, 0.224041000008583, 0.223874136805534, 0.223707213997841, 0.22354032099247, 0.22337344288826, 0.22320656478405, 0.223039641976357, 0.222872748970985, 0.222705885767937, 0.222538933157921, 0.222372084856033, 0.222205191850662, 0.222038298845291, 0.221871390938759, 0.221704497933388, 0.221537590026855, 0.221370697021484, 0.221203818917274, 0.221036911010742, 0.220870047807693, 0.220703125, 0.22053624689579, 0.220369324088097, 0.220202520489693, 0.220035597681999, 0.219868704676628, 0.219701811671257, 0.219534918665886, 0.219368025660515, 0.219201117753983, 0.219034239649773, 0.218867316842079, 0.218700423836708, 0.218533545732498, 0.218366637825966, 0.218199744820595, 0.218032851815224, 0.217866003513336, 0.217699095606804, 0.217539221048355, 0.217386677861214, 0.217234566807747, 0.217082872986794, 0.216931656002998, 0.2167809009552, 0.216630488634109, 0.216480642557144, 0.216331079602242, 0.216182038187981, 0.216033428907394, 0.215885236859322, 0.215737536549568, 0.215590208768845, 0.215443387627602, 0.215296909213066, 0.21515092253685, 0.215005323290825, 0.214860260486603, 0.214715540409088, 0.214571297168732, 0.214427500963211, 0.21428419649601, 0.214141175150871, 0.21399874985218, 0.213856637477875, 0.213715076446533, 0.213573858141899, 0.213433057069778, 0.213292747735977, 0.213152930140495, 0.213013544678688, 0.212874501943588, 0.212735936045647, 0.212597832083702, 0.21246013045311, 0.212322905659676, 0.212186083197594, 0.212049677968025, 0.211913749575615, 0.211778283119202, 0.211643174290657, 0.211508557200432, 0.211374372243881, 0.211240634322166, 0.211107328534126, 0.2109744399786, 0.21084201335907, 0.21070995926857, 0.210578382015228, 0.210447296500206, 0.210316553711891, 0.210186302661896, 0.210056483745575, 0.209927201271057, 0.209798216819763, 0.209669709205627, 0.209541618824005, 0.20941399037838, 0.209286794066429, 0.209160074591637, 0.209033727645874, 0.208907842636108, 0.208782404661179, 0.208657383918762, 0.20853279531002, 0.208408653736115, 0.208284944295883, 0.208161681890488, 0.208038836717606, 0.207916408777237, 0.20779450237751, 0.207672983407974, 0.207551881670952, 0.207431256771088, 0.20731109380722, 0.2071912586689, 0.20707194507122, 0.206953093409538, 0.206834673881531, 0.206716597080231, 0.206599026918411, 0.206481903791428, 0.206365257501602, 0.206248968839645, 0.206133127212524, 0.206017673015594, 0.20590278506279, 0.205788254737854, 0.205674111843109, 0.205560490489006, 0.205447286367416, 0.205334454774857, 0.205222144722939, 0.205110281705856, 0.204998835921288, 0.204887792468071, 0.204777121543884, 0.204667046666145, 0.204557403922081, 0.204466611146927, 0.204380929470062, 0.204295456409454, 0.204210057854652, 0.204124793410301, 0.20403964817524, 0.203954666852951, 0.20386977493763, 0.203784987330437, 0.203700363636017, 0.203615918755531, 0.203531503677368, 0.203447297215462, 0.203363090753555, 0.203279092907906, 0.203195229172707, 0.203111529350281, 0.203027933835983, 0.202944368124008, 0.202861025929451, 0.202777773141861, 0.202694609761238, 0.202611595392227, 0.202528804540634, 0.202446043491364, 0.202363386750221, 0.202280908823013, 0.202198565006256, 0.20211635529995, 0.202034190297127, 0.201952219009399, 0.201870337128639, 0.201788663864136, 0.201707005500793, 0.201625555753708, 0.201544165611267, 0.201462998986244, 0.201381787657738, 0.201300889253616, 0.201219990849495, 0.201139330863953, 0.201058611273766, 0.200978189706802, 0.200897842645645, 0.2008176445961, 0.200737476348877, 0.20065750181675, 0.200577661395073, 0.200497984886169, 0.200418427586555, 0.200338885188103, 0.200259566307068, 0.200180336833, 0.200101241469383, 0.200022250413895, 0.199943408370018, 0.199864730238914, 0.199786096811295, 0.199707642197609, 0.199629351496696, 0.199551075696945, 0.199473008513451, 0.199395015835762, 0.199317246675491, 0.199239522218704, 0.199161946773529, 0.199084475636482, 0.199007153511047, 0.198929980397224, 0.198852881789207, 0.198775857686996, 0.198699086904526, 0.198622405529022, 0.198545798659325, 0.198469281196594, 0.198393031954765, 0.198316842317581, 0.198240727186203, 0.198164761066437, 0.198088973760605, 0.198013320565224, 0.19793775677681, 0.19786225259304, 0.197786927223206, 0.197711810469627, 0.197636723518372, 0.197561740875244, 0.197486951947212, 0.197412267327309, 0.197337701916695, 0.197263270616531, 0.197188898921013, 0.197114750742912, 0.197040632367134, 0.196966737508774, 0.196892976760864, 0.196819245815277, 0.196745738387108, 0.1966722458601, 0.19659897685051, 0.196521699428558, 0.196433916687965, 0.196345746517181, 0.19625723361969, 0.196168377995491, 0.196079045534134, 0.195989415049553, 0.195899412035942, 0.195809036493301, 0.195718258619308, 0.195627108216286, 0.195535629987717, 0.195443779230118, 0.195351541042328, 0.195258960127831, 0.195166021585464, 0.195072621107101, 0.194978907704353, 0.194884806871414, 0.194790363311768, 0.19469553232193, 0.194600343704224, 0.194504752755165, 0.194408804178238, 0.194312497973442, 0.194215804338455, 0.194118738174438, 0.194021299481392, 0.193923503160477, 0.193825349211693, 0.193726792931557, 0.193627864122391, 0.193528592586517, 0.193428963422775, 0.193328976631165, 0.193228557705879, 0.193127781152725, 0.193026691675186, 0.19292514026165, 0.192823246121407, 0.192721009254456, 0.192618399858475, 0.192515403032303, 0.192411988973618, 0.19230829179287, 0.192204192280769, 0.192099720239639, 0.191994845867157, 0.19188965857029, 0.19178406894207, 0.191678106784821, 0.191571742296219, 0.191465094685555, 0.191358029842377, 0.191250577569008, 0.191142797470093, 0.191034555435181, 0.190926060080528, 0.190817132592201, 0.190707832574844, 0.190598130226135, 0.19048810005188, 0.190377697348595, 0.19026692211628, 0.190155729651451, 0.190044239163399, 0.189932331442833, 0.189820110797882, 0.189707413315773, 0.189594432711601, 0.189481049776077, 0.189367339015007, 0.189253240823746, 0.189138755202293, 0.189023837447166, 0.188908651471138, 0.188793048262596, 0.188677072525024, 0.188560724258423, 0.188444033265114, 0.188326939940453, 0.1882094591856, 0.188091650605202, 0.187973439693451, 0.187854915857315, 0.18773590028286, 0.187616631388664, 0.187496945261955, 0.187376916408539, 0.18725648522377, 0.187135681509972, 0.187014520168304, 0.18689301609993, 0.186771079897881, 0.186648786067963, 0.186526149511337, 0.186403170228004, 0.186279729008675, 0.186156004667282, 0.186031877994537, 0.18589836359024, 0.185760319232941, 0.185621872544289, 0.185483187437057, 0.185344159603119, 0.185204863548279, 0.185065150260925, 0.184925213456154, 0.184784919023514, 0.18464432656765, 0.184503331780434, 0.1843621134758, 0.18422058224678, 0.184078723192215, 0.18393649160862, 0.183793976902962, 0.183651179075241, 0.183508038520813, 0.183364555239677, 0.183220744132996, 0.183076620101929, 0.182932198047638, 0.182787463068962, 0.18264240026474, 0.182497009634972, 0.182351365685463, 0.182205349206924, 0.182058975100517, 0.181912317872047, 0.181765377521515, 0.181618094444275, 0.18147049844265, 0.181322574615479, 0.181174352765083, 0.181025788187981, 0.180876895785332, 0.18072772026062, 0.18057818710804, 0.180428400635719, 0.180278226733208, 0.180127769708633, 0.179976984858513, 0.179825901985168, 0.179674461483955, 0.179522708058357, 0.179370656609535, 0.179218292236328, 0.179065570235252, 0.178912565112114, 0.178759261965752, 0.178605660796165, 0.178451731801033, 0.178297400474548, 0.178142815828323, 0.177987918257713, 0.177832677960396, 0.177677124738693, 0.177521228790283, 0.17736504971981, 0.177208572626114, 0.177051737904549, 0.176894560456276, 0.176737129688263, 0.176579371094704, 0.176421239972115, 0.176262855529785, 0.176104098558426, 0.175945073366165, 0.175785720348358, 0.175626024603844, 0.175466030836105, 0.175305753946304, 0.175145089626312, 0.174984112381935, 0.174822866916656, 0.17466127872467, 0.17449939250946, 0.174337103962898, 0.174174606800079, 0.174011722207069, 0.173848584294319, 0.173685044050217, 0.173521235585213, 0.173357114195824, 0.173192650079727, 0.173027873039246, 0.172862783074379, 0.17269740998745, 0.172531709074974, 0.172365590929985, 0.172199249267578, 0.172032594680786, 0.171865627169609, 0.171698316931725, 0.171530678868294, 0.171362712979317, 0.171194478869438, 0.171025902032852, 0.170856937766075, 0.170687720179558, 0.170511052012444, 0.170333623886108, 0.170156493782997, 0.16997954249382, 0.16980268061161, 0.16962593793869, 0.169449403882027, 0.169273063540459, 0.169096827507019, 0.168920755386353, 0.168744876980782, 0.1685691177845, 0.168393597006798, 0.168218106031418, 0.168042853474617, 0.167867794632912, 0.167692855000496, 0.167518004775047, 0.1673434227705, 0.167168989777565, 0.166994690895081, 0.166820496320724, 0.166646525263786, 0.166472673416138, 0.166299059987068, 0.166125476360321, 0.165952146053314, 0.165778949856758, 0.16560597717762, 0.165433064103127, 0.165260270237923, 0.165087774395943, 0.164915412664413, 0.164743140339851, 0.164571017026901, 0.164399087429047, 0.164227366447449, 0.164055749773979, 0.16388426721096, 0.163712993264198, 0.163541913032532, 0.163370922207832, 0.163200080394745, 0.163029462099075, 0.162858933210373, 0.16268864274025, 0.162518426775932, 0.162348434329033, 0.162178620696068, 0.162008911371231, 0.161839306354523, 0.161669924855232, 0.161500707268715, 0.161331683397293, 0.161162748932838, 0.160994023084641, 0.160825461149216, 0.160657063126564, 0.160488694906235, 0.160320669412613, 0.160152673721313, 0.159984916448593, 0.159817308187485, 0.159649789333344, 0.15948249399662, 0.159315347671509, 0.159148305654526, 0.158981427550316, 0.158814817667007, 0.158648282289505, 0.15848197042942, 0.15831570327282, 0.158149674534798, 0.15798382461071, 0.157818123698235, 0.157652497291565, 0.157487094402313, 0.157321900129318, 0.157156765460968, 0.156991839408875, 0.156827062368393, 0.156662479043007, 0.156498029828072, 0.156333729624748, 0.156169578433037, 0.156005635857582, 0.155841827392578, 0.15567809343338, 0.155514612793922, 0.155351251363754, 0.155188128352165, 0.155025035142899, 0.154862195253372, 0.154699489474297, 0.154536992311478, 0.154374584555626, 0.154212340712547, 0.154050305485725, 0.153888374567032, 0.15372659265995, 0.153567999601364, 0.153422832489014, 0.153278008103371, 0.153133824467659, 0.152989998459816, 0.152846679091454, 0.152703821659088, 0.152561441063881, 0.152419567108154, 0.152278169989586, 0.152137219905853, 0.15199676156044, 0.151856780052185, 0.151717275381088, 0.151578322052956, 0.151439726352692, 0.151301577687263, 0.151164054870605, 0.1510269343853, 0.150890290737152, 0.150754049420357, 0.150618448853493, 0.150483265519142, 0.150348588824272, 0.150214210152626, 0.15008045732975, 0.149947211146355, 0.149814367294312, 0.149681910872459, 0.149550020694733, 0.149418696761131, 0.149287834763527, 0.149157285690308, 0.149027347564697, 0.148897901177406, 0.148768946528435, 0.148640438914299, 0.14851225912571, 0.14838470518589, 0.148257672786713, 0.148131027817726, 0.148004770278931, 0.147879138588905, 0.147753983736038, 0.14762932062149, 0.14750500023365, 0.147381186485291, 0.147257953882217, 0.14713516831398, 0.147012799978256, 0.146890893578529, 0.146769568324089, 0.146648690104485, 0.146528273820877, 0.146408185362816, 0.146288827061653, 0.146169856190681, 0.146051302552223, 0.145933285355568, 0.145815655589104, 0.145698636770248, 0.145581990480423, 0.145465910434723, 0.145350188016891, 0.145235046744347, 0.145120307803154, 0.145006060600281, 0.144892305135727, 0.14477901160717, 0.144666194915771, 0.144553899765015, 0.144442096352577, 0.14433066546917, 0.144219756126404, 0.144109398126602, 0.143999502062798, 0.143889978528023, 0.143781065940857, 0.143672481179237, 0.143564477562904, 0.143456920981407, 0.143349856138229, 0.143243223428726, 0.143137142062187, 0.143031537532806, 0.142926305532455, 0.142821535468102, 0.142717406153679, 0.142613664269447, 0.142510414123535, 0.142407536506653, 0.142305299639702, 0.142203435301781, 0.142102152109146, 0.142001196742058, 0.141900792717934, 0.141800940036774, 0.14170153439045, 0.141602411866188, 0.141504019498825, 0.141414001584053, 0.141321703791618, 0.141229659318924, 0.141137987375259, 0.141046807169914, 0.140955999493599, 0.140865460038185, 0.14077527821064, 0.140685573220253, 0.140596255660057, 0.140507221221924, 0.14041855931282, 0.14033031463623, 0.14024244248867, 0.140154883265495, 0.140067756175995, 0.139980971813202, 0.139894500374794, 0.139808505773544, 0.139722853899002, 0.139637514948845, 0.139552608132362, 0.13946807384491, 0.139383837580681, 0.139300018548965, 0.139216586947441, 0.139133498072624, 0.139050826430321, 0.138968497514725, 0.138886451721191, 0.138804867863655, 0.138723701238632, 0.138642892241478, 0.138562306761742, 0.138482242822647, 0.138402536511421, 0.138323247432709, 0.138244241476059, 0.138165533542633, 0.138087272644043, 0.138009443879128, 0.137931913137436, 0.137854710221291, 0.13777793943882, 0.137701645493507, 0.137625634670258, 0.137549832463264, 0.137474581599236, 0.137399762868881, 0.137325242161751, 0.137251034379005, 0.137177169322968, 0.137103781104088, 0.137030690908432, 0.136958003044128, 0.136885657906532, 0.13681373000145, 0.136742144823074, 0.136670976877213, 0.136600121855736, 0.136529639363289, 0.136459589004517, 0.136389866471291, 0.136320471763611, 0.136251494288445, 0.136182904243469, 0.136114612221718, 0.136046767234802, 0.135979279875755, 0.135912150144577, 0.13584540784359, 0.135779023170471, 0.135713085532188, 0.13564732670784, 0.135582089424133, 0.135517179965973, 0.135452702641487, 0.13538846373558, 0.135324656963348, 0.135261252522469, 0.13519823551178, 0.135135620832443, 0.135073199868202, 0.135011300444603, 0.134949773550034, 0.134888619184494, 0.13482765853405, 0.134767279028893, 0.134707272052765, 0.1346475481987, 0.134588062763214, 0.134529143571854, 0.134470611810684, 0.134412407875061, 0.134354501962662, 0.134296968579292, 0.134239941835403, 0.134183198213577, 0.134126856923103, 0.134070783853531, 0.134016320109367, 0.133970960974693, 0.133925437927246, 0.133879914879799, 0.133834391832352, 0.133788749575615, 0.133743107318878, 0.133697465062141, 0.133651733398438, 0.133605942130089, 0.133560061454773, 0.133514150977135, 0.133468255400658, 0.133422374725342, 0.133376345038414, 0.133330225944519, 0.133284062147141, 0.133237943053246, 0.133191794157028, 0.133145585656166, 0.133099272847176, 0.133052870631218, 0.133006557822227, 0.132960125803947, 0.132913529872894, 0.132867008447647, 0.132820576429367, 0.132773861289024, 0.132727235555649, 0.132680520415306, 0.132633805274963, 0.132586970925331, 0.132540106773376, 0.132493227720261, 0.132446229457855, 0.132399246096611, 0.132352218031883, 0.132305145263672, 0.132258042693138, 0.13221088051796, 0.132163614034653, 0.132116347551346, 0.132069081068039, 0.132021650671959, 0.131974264979362, 0.131926789879799, 0.131879299879074, 0.13183182477951, 0.131784155964851, 0.131736576557159, 0.1316889077425, 0.131641164422035, 0.131593346595764, 0.131545469164848, 0.131497696042061, 0.131449744105339, 0.131401807069778, 0.131353750824928, 0.131305724382401, 0.131257623434067, 0.131209522485733, 0.131161257624626, 0.131113052368164, 0.13106469810009, 0.131016403436661, 0.130967989563942, 0.130919694900513, 0.130871146917343, 0.130822658538818, 0.130774036049843, 0.130725458264351, 0.130676805973053, 0.130628019571304, 0.1305792927742, 0.130530595779419, 0.130481615662575, 0.130432844161987, 0.130383834242821, 0.13033489882946, 0.13028584420681, 0.130236715078354, 0.130187660455704, 0.130138486623764, 0.130089268088341, 0.130039989948273, 0.129990696907043, 0.129941359162331, 0.129891946911812, 0.129842504858971, 0.129792988300323, 0.12974351644516, 0.12969383597374, 0.129644230008125, 0.129594579339027, 0.129544824361801, 0.129495173692703, 0.129445239901543, 0.129395440220833, 0.129345551133156, 0.129295468330383, 0.129239276051521, 0.129187479615211, 0.129135370254517, 0.129082277417183, 0.129028588533401, 0.128974571824074, 0.128919452428818, 0.128864049911499, 0.128807783126831, 0.128750920295715, 0.128693461418152, 0.128635287284851, 0.128576725721359, 0.128517240285873, 0.12845715880394, 0.128396362066269, 0.128334984183311, 0.128272965550423, 0.128210231661797, 0.128146886825562, 0.128083005547523, 0.128018334507942, 0.127952978014946, 0.127887204289436, 0.127820491790771, 0.127753332257271, 0.127685442566872, 0.127616927027702, 0.127547726035118, 0.127477884292603, 0.1274074614048, 0.127336367964745, 0.127264648675919, 0.127192124724388, 0.127119168639183, 0.127045407891273, 0.126971051096916, 0.126896113157272, 0.126820415258408, 0.126744151115417, 0.126666978001595, 0.126589417457581, 0.126511096954346, 0.12643226981163, 0.126352712512016, 0.126272529363632, 0.126191645860672, 0.126110151410103, 0.126028060913086, 0.125945270061493, 0.125861793756485, 0.12577773630619, 0.125692948698997, 0.12560760974884, 0.125521600246429, 0.125434875488281, 0.125347480177879, 0.125259593129158, 0.125170782208443, 0.12508150935173, 0.124991729855537, 0.124900959432125, 0.124809801578522, 0.12471791356802, 0.124625362455845, 0.124532178044319, 0.124438308179379, 0.124343812465668, 0.124248683452606, 0.124153032898903, 0.12405663728714, 0.123959481716156, 0.123861849308014, 0.123763352632523, 0.123664371669292, 0.123564720153809, 0.123464398086071, 0.123363308608532, 0.123261839151382, 0.123159363865852, 0.123056493699551, 0.122952923178673, 0.12284879386425, 0.122743830084801, 0.122638426721096, 0.122532181441784, 0.122425325214863, 0.122318014502525, 0.122209832072258, 0.12210114300251, 0.121991731226444, 0.121881656348705, 0.121770933270454, 0.121659502387047, 0.121547594666481, 0.121434740722179, 0.121321640908718, 0.121207557618618, 0.121092922985554, 0.120977841317654, 0.120848014950752, 0.120686702430248, 0.120525106787682, 0.120363280177116, 0.120200932025909, 0.120038345456123, 0.119875475764275, 0.119712263345718, 0.119548693299294, 0.119384683668613, 0.119220472872257, 0.119055859744549, 0.118891097605228, 0.118725702166557, 0.118560262024403, 0.118394337594509, 0.118227988481522, 0.118061557412148, 0.117894537746906, 0.117727436125278, 0.117559887468815, 0.117391914129257, 0.117223739624023, 0.117055162787437, 0.116886392235756, 0.1167171895504, 0.116547584533691, 0.116377748548985, 0.116207540035248, 0.116036951541901, 0.115866117179394, 0.115695007145405, 0.115523464977741, 0.115351594984531, 0.115179218351841, 0.115006767213345, 0.114833906292915, 0.114660739898682, 0.114487290382385, 0.114313393831253, 0.114139273762703, 0.113964721560478, 0.113789923489094, 0.11361476033926, 0.113439328968525, 0.113263428211212, 0.113087318837643, 0.112910851836205, 0.112733915448189, 0.1125568151474, 0.112379401922226, 0.112201556563377, 0.112023264169693, 0.111844815313816, 0.111665971577168, 0.111486732959747, 0.111307419836521, 0.11112754046917, 0.110947422683239, 0.110767036676407, 0.110586248338223, 0.110405117273331, 0.110223695635796, 0.110041871666908, 0.109859742224216, 0.109677329659462, 0.109494514763355, 0.109311513602734, 0.109127908945084, 0.108944274485111, 0.108760073781013, 0.108575403690338, 0.108390934765339, 0.10820559412241, 0.10802023857832, 0.107834458351135, 0.107648439705372, 0.107461899518967, 0.107275284826756, 0.107088074088097, 0.106900706887245, 0.106713064014912, 0.106524862349033, 0.106336459517479, 0.106147825717926, 0.105958752334118, 0.105769239366055, 0.105579659342766, 0.105389595031738, 0.105198845267296, 0.105008348822594, 0.104817099869251, 0.104625843465328, 0.104433991014957, 0.104242064058781, 0.104049660265446, 0.103856854140759, 0.103663861751556, 0.103470414876938, 0.103276863694191, 0.103091523051262, 0.102912560105324, 0.102734364569187, 0.10255666077137, 0.102379605174065, 0.102203257381916, 0.102027423679829, 0.101851880550385, 0.101677194237709, 0.101503029465675, 0.101329669356346, 0.10115684568882, 0.100984551012516, 0.100812837481499, 0.100641295313835, 0.100470937788486, 0.100301057100296, 0.100131653249264, 0.0999629572033882, 0.0997949466109276, 0.0996271222829819, 0.0994602590799332, 0.0992939472198486, 0.0991281121969223, 0.0989631116390228, 0.0987984612584114, 0.0986346155405045, 0.0984709858894348, 0.0983081981539726, 0.098146066069603, 0.0979845896363258, 0.0978236272931099, 0.0976632609963417, 0.0975034907460213, 0.097343921661377, 0.097185455262661, 0.0970274433493614, 0.0968700870871544, 0.0967132970690727, 0.0965569689869881, 0.0964014902710915, 0.0962462425231934, 0.0960917398333549, 0.095938116312027, 0.0957848578691483, 0.0956323072314262, 0.0954802706837654, 0.0953288227319717, 0.0951777845621109, 0.0950274094939232, 0.0948778688907623, 0.0947288051247597, 0.0945803448557854, 0.0944324284791946, 0.0942848771810532, 0.0941382721066475, 0.0939922630786896, 0.0938468426465988, 0.093702107667923, 0.0935577675700188, 0.0934140086174011, 0.0932706668972969, 0.0931281000375748, 0.0929862186312675, 0.0928450077772141, 0.0927043557167053, 0.0925642848014832, 0.0924247875809669, 0.0922854766249657, 0.0921472832560539, 0.0920096412301064, 0.09187251329422, 0.0917359888553619, 0.0916001722216606, 0.0914647132158279, 0.0913297235965729, 0.0911955311894417, 0.0910619720816612, 0.0909289643168449, 0.0907966047525406, 0.0906649082899094, 0.0905334502458572, 0.0904029533267021, 0.0902729630470276, 0.0901436433196068, 0.0900148153305054, 0.0898866951465607, 0.089759036898613, 0.0896319076418877, 0.0895054489374161, 0.0893796980381012, 0.0892545878887177, 0.0891299173235893, 0.0890059620141983, 0.0888825133442879, 0.0887593775987625, 0.0886371731758118, 0.088515542447567, 0.0883946418762207, 0.0882740914821625, 0.0881698653101921, 0.0880953148007393, 0.088020846247673, 0.0879471302032471, 0.0878736898303032, 0.087800607085228, 0.0877278000116348, 0.0876553803682327, 0.0875830575823784, 0.087510921061039, 0.0874395817518234, 0.0873683243989944, 0.0872975364327431, 0.0872269943356514, 0.0871569216251373, 0.0870868116617203, 0.0870173424482346, 0.0869481489062309, 0.0868791863322258, 0.0868108198046684, 0.0867426916956902, 0.086674764752388, 0.0866070315241814, 0.0865396559238434, 0.0864728763699532, 0.0864064991474152, 0.0863401964306831, 0.0862742960453033, 0.0862089022994041, 0.086143396794796, 0.0860785916447639, 0.0860140323638916, 0.085949718952179, 0.0858859121799469, 0.0858224630355835, 0.0857592150568962, 0.0856959596276283, 0.0856334194540977, 0.0855713337659836, 0.0855093449354172, 0.0854478478431702, 0.0853864997625351, 0.0853253975510597, 0.0852648764848709, 0.0852046832442284, 0.0851447582244873, 0.0850851237773895, 0.0850259512662888, 0.0849670395255089, 0.0849082618951797, 0.08484997600317, 0.0847920775413513, 0.0847344994544983, 0.0846773087978363, 0.0846202522516251, 0.084563747048378, 0.0845071226358414, 0.084451325237751, 0.0843957215547562, 0.0843404084444046, 0.0842856466770172, 0.0842309221625328, 0.0841766372323036, 0.0841223895549774, 0.0840688049793243, 0.0840156301856041, 0.0839625373482704, 0.0839099884033203, 0.0838578045368195, 0.0838058292865753, 0.083753876388073, 0.0837025567889214, 0.083651639521122, 0.0836010053753853, 0.0835507959127426, 0.0835009217262268, 0.0834508761763573, 0.083401545882225, 0.0833526477217674, 0.08330387622118, 0.0832557305693626, 0.0832077488303185, 0.0831600427627563, 0.0831123739480972, 0.0830655470490456, 0.0830188691616058, 0.0829724371433258, 0.0829266384243965, 0.0828807577490807, 0.0828354731202126, 0.0827902629971504, 0.0827455744147301, 0.0827011540532112, 0.0826572254300117, 0.0826135203242302, 0.082570381462574, 0.0825273096561432, 0.0824843272566795, 0.0824418142437935, 0.0823998674750328, 0.082355409860611, 0.0822920054197311, 0.0822282359004021, 0.0821640342473984, 0.0820996388792992, 0.082034558057785, 0.081969253718853, 0.0819034650921822, 0.0818371549248695, 0.0817707031965256, 0.0817036032676697, 0.0816362276673317, 0.081568256020546, 0.0815000608563423, 0.0814314559102058, 0.0813623368740082, 0.0812928974628448, 0.0812229961156845, 0.0811525657773018, 0.0810819417238235, 0.0810107961297035, 0.0809392631053925, 0.0808673277497292, 0.0807949975132942, 0.0807222723960876, 0.0806490257382393, 0.0805754736065865, 0.0805014744400978, 0.0804268419742584, 0.0803521722555161, 0.0802769511938095, 0.0802012905478477, 0.0801251903176308, 0.0800488963723183, 0.0799719169735909, 0.0798947662115097, 0.0798169896006584, 0.0797388032078743, 0.0796603187918663, 0.0795813724398613, 0.0795019790530205, 0.0794223546981812, 0.0793420523405075, 0.0792615860700607, 0.0791806131601334, 0.0790993198752403, 0.0790173932909966, 0.0789351537823677, 0.078852504491806, 0.0787695124745369, 0.078685998916626, 0.0786022171378136, 0.0785179436206818, 0.0784332901239395, 0.0783482268452644, 0.0782627239823341, 0.0781767219305038, 0.0780903846025467, 0.0780037492513657, 0.0779165402054787, 0.0778291523456573, 0.0777410715818405, 0.0776527151465416, 0.0775638967752457, 0.0774745866656303, 0.0773852095007896, 0.0772949978709221, 0.0772048160433769, 0.0771138891577721, 0.0770225301384926, 0.0769310817122459, 0.0768388882279396, 0.0767463743686676, 0.0766534209251404, 0.0765600800514221, 0.0764665305614471, 0.0763723477721214, 0.0762778893113136, 0.0761829167604446, 0.076087512075901, 0.0759918987751007, 0.0758956670761108, 0.0757990553975105, 0.0757019817829132, 0.0756045505404472, 0.0755068138241768, 0.0754085406661034, 0.0753100365400314, 0.0752108320593834, 0.0751115679740906, 0.0750117152929306, 0.0749111622571945, 0.0748106762766838, 0.0747094750404358, 0.0746078714728355, 0.0745060816407204, 0.0744036138057709, 0.0743010640144348, 0.074197806417942, 0.0740943402051926, 0.0739789754152298, 0.0738363787531853, 0.0736943408846855, 0.0735520571470261, 0.0734099224209785, 0.0732676535844803, 0.0731255263090134, 0.072983406484127, 0.0728414356708527, 0.0726993158459663, 0.0725572779774666, 0.0724154710769653, 0.0722732692956924, 0.0721313804388046, 0.0719897374510765, 0.0718479305505753, 0.0717061311006546, 0.0715645626187325, 0.0714226737618446, 0.0712811872363091, 0.0711395367980003, 0.0709980428218842, 0.0708566457033157, 0.070714920759201, 0.0705737471580505, 0.0704320967197418, 0.0702909305691719, 0.0701496005058289, 0.0700081884860992, 0.0698669403791428, 0.0697259977459908, 0.0695848315954208, 0.0694437474012375, 0.069302499294281, 0.0691614747047424, 0.0690204650163651, 0.0688793808221817, 0.0687386021018028, 0.0685975179076195, 0.0684569701552391, 0.0683161169290543, 0.0681756585836411, 0.0680344924330711, 0.067894272506237, 0.0677534192800522, 0.0676128789782524, 0.0674722641706467, 0.0673318058252335, 0.0671910345554352, 0.0670506507158279, 0.0669102743268013, 0.0667699798941612, 0.0666296780109406, 0.0664893835783005, 0.0663492381572723, 0.0662087053060532, 0.0660690441727638, 0.0659285858273506, 0.0657886043190956, 0.065648540854454, 0.065508559346199, 0.0653686597943306, 0.0652287527918816, 0.0650888532400131, 0.0649487152695656, 0.0648092105984688, 0.0646693855524063, 0.064529724419117, 0.0643898993730545, 0.0642505511641502, 0.0641108155250549, 0.0639713034033775, 0.0638314783573151, 0.0636920556426048, 0.063552625477314, 0.0634132027626038, 0.0632738545536995, 0.0631344318389893, 0.0629953965544701, 0.0628559738397598, 0.0627171099185944, 0.0625776797533035, 0.0624386519193649, 0.0622994601726532, 0.0621605888009071, 0.062021479010582, 0.0618826076388359, 0.061743501573801, 0.0616044700145721, 0.0614658370614052, 0.0613267309963703, 0.0611883327364922, 0.0610493049025536, 0.0609108284115791, 0.0607720352709293, 0.0606338046491146, 0.0604949332773685, 0.0603566952049732, 0.0602180622518063, 0.0600795038044453, 0.0599573664367199, 0.0598564110696316, 0.0597560033202171, 0.0596560686826706, 0.0595567747950554, 0.0594581142067909, 0.0593598484992981, 0.0592622198164463, 0.0591651499271393, 0.0590683072805405, 0.0589724220335484, 0.05887645855546, 0.0587816052138805, 0.0586869120597839, 0.058592926710844, 0.0584991052746773, 0.0584060736000538, 0.0583136789500713, 0.0582214370369911, 0.0581299960613251, 0.0580389499664307, 0.0579486936330795, 0.0578585974872112, 0.0577692948281765, 0.0576801560819149, 0.0575918816030025, 0.0575039274990559, 0.0574163720011711, 0.0573296844959259, 0.0572434738278389, 0.057157427072525, 0.0570720061659813, 0.056987464427948, 0.0569028444588184, 0.0568195655941963, 0.0567360520362854, 0.0566534921526909, 0.0565710887312889, 0.0564896389842033, 0.0564083456993103, 0.0563277676701546, 0.0562473461031914, 0.0561677999794483, 0.0560887306928635, 0.0560103692114353, 0.0559323318302631, 0.0558544509112835, 0.0557774379849434, 0.055700745433569, 0.0556249283254147, 0.0555492639541626, 0.0554746352136135, 0.0553998462855816, 0.0553261674940586, 0.0552525669336319, 0.0551797598600388, 0.0551073513925076, 0.0550352595746517, 0.054964117705822, 0.0548933744430542, 0.0548230297863483, 0.054752916097641, 0.0546836853027344, 0.0546149984002113, 0.0545469522476196, 0.0544789023697376, 0.0544118918478489, 0.0543451048433781, 0.0542791225016117, 0.0542132183909416, 0.0541481040418148, 0.0540833100676537, 0.0540190674364567, 0.053955540060997, 0.0538923293352127, 0.0538299903273582, 0.0537675768136978, 0.0537063516676426, 0.0536451190710068, 0.0535848438739777, 0.0535246469080448, 0.0534654073417187, 0.0534062422811985, 0.0533480308949947, 0.0532898157835007, 0.0532323159277439, 0.0531756915152073, 0.0531191416084766, 0.0530633106827736, 0.0530078709125519, 0.052953228354454, 0.0528987385332584, 0.0528452098369598, 0.0527916699647903, 0.0527389347553253, 0.0526865124702454, 0.0526350364089012, 0.0525837242603302, 0.0525331236422062, 0.0524829216301441, 0.0524374581873417, 0.0524027198553085, 0.0523676611483097, 0.0523328483104706, 0.0522980280220509, 0.0522630549967289, 0.0522279217839241, 0.0521927885711193, 0.052157811820507, 0.0521224364638329, 0.0520873032510281, 0.0520520880818367, 0.0520166382193565, 0.0519814230501652, 0.051945973187685, 0.0519104450941086, 0.0518749952316284, 0.0518393814563751, 0.0518036149442196, 0.0517680831253529, 0.0517323948442936, 0.0516965501010418, 0.0516607761383057, 0.0516250878572464, 0.0515890046954155, 0.0515532307326794, 0.0515172258019447, 0.0514812208712101, 0.0514451377093792, 0.0514092110097408, 0.0513729639351368, 0.0513367205858231, 0.0513004772365093, 0.0512642301619053, 0.0512277521193027, 0.0511915050446987, 0.0511550232768059, 0.051118541508913, 0.0510819777846336, 0.0510454177856445, 0.0510086193680763, 0.0509719774127007, 0.050935335457325, 0.0508985333144665, 0.0508616529405117, 0.0508250147104263, 0.0507879815995693, 0.050751019269228, 0.0507140606641769, 0.0506770238280296, 0.0506399087607861, 0.050602950155735, 0.0505655966699123, 0.0505283996462822, 0.0504911243915558, 0.0504539273679256, 0.0504164136946201, 0.0503791347146034, 0.0503417067229748, 0.050304114818573, 0.0502666793763638, 0.0502290837466717, 0.0501912571489811, 0.0501535832881927, 0.0501159131526947, 0.0500780008733273, 0.0500402525067329, 0.0500023402273655, 0.049964427947998, 0.0499265193939209, 0.0498885326087475, 0.0498503036797047, 0.0498123951256275, 0.049774244427681, 0.0497359409928322, 0.0496977120637894, 0.0496594868600368, 0.0496210195124149, 0.0495827123522758, 0.0495443269610405, 0.0495060198009014, 0.0494673177599907, 0.0494288541376591, 0.0493902303278446, 0.0493515282869339, 0.0493127480149269, 0.0492740422487259, 0.0492350235581398, 0.0491962395608425, 0.0491573736071587, 0.0491184368729591, 0.049079418182373, 0.0490405559539795, 0.0490012168884277, 0.0489622764289379, 0.0489231012761593, 0.0488838404417038, 0.0488445833325386, 0.0488053262233734, 0.0487659052014351, 0.0487020798027515, 0.0486368872225285, 0.0485709831118584, 0.0485048368573189, 0.0484385378658772, 0.0483716763556004, 0.048304345458746, 0.0482366122305393, 0.0481686443090439, 0.0481000393629074, 0.0480312034487724, 0.0479618832468987, 0.047892089933157, 0.047822143882513, 0.0477517917752266, 0.04768081381917, 0.0476095080375671, 0.0475379712879658, 0.0474657230079174, 0.047393474727869, 0.0473205856978893, 0.0472471490502357, 0.047173548489809, 0.047099631279707, 0.0470250807702541, 0.0469502881169319, 0.0468750298023224, 0.0467994399368763, 0.0467233844101429, 0.0466469302773476, 0.0465701594948769, 0.046492911875248, 0.0464152656495571, 0.0463374629616737, 0.0462587103247643, 0.046180035918951, 0.0461008846759796, 0.0460212603211403, 0.0459413155913353, 0.0458608157932758, 0.0457799211144447, 0.0456988662481308, 0.0456173345446587, 0.0455351732671261, 0.0454528518021107, 0.045370128005743, 0.0452867746353149, 0.045203261077404, 0.0451192669570446, 0.0450348854064941, 0.0449501052498817, 0.0448650829493999, 0.0447793491184711, 0.0446934625506401, 0.0446071699261665, 0.0445204824209213, 0.0444332435727119, 0.0443456843495369, 0.0442577339708805, 0.0441692993044853, 0.0440807119011879, 0.0439914092421532, 0.0439018718898296, 0.0438119359314442, 0.0437217578291893, 0.0436308719217777, 0.0435399785637856, 0.0434482954442501, 0.0433562994003296, 0.0432639829814434, 0.0431715063750744, 0.0430780053138733, 0.0429846532642841, 0.0428907573223114, 0.0427964515984058, 0.0427015982568264, 0.0426066666841507, 0.0425111725926399, 0.0424152128398418, 0.0423188507556915, 0.0422222539782524, 0.0421250201761723, 0.0420277044177055, 0.0419298410415649, 0.0418314971029758, 0.0417327545583248, 0.0416337735950947, 0.0415341630578041, 0.041434470564127, 0.0413340628147125, 0.0412334203720093, 0.0411323048174381, 0.0410310216248035, 0.0409288704395294, 0.0408267229795456, 0.0407240949571133, 0.0406210720539093, 0.04051773250103, 0.0404139161109924, 0.0403093881905079, 0.0402016825973988, 0.040089063346386, 0.0399763248860836, 0.0398633852601051, 0.0397505313158035, 0.0396375916898251, 0.0395245365798473, 0.0394112057983875, 0.0392980687320232, 0.0391848161816597, 0.0390714034438133, 0.0389578752219677, 0.0388443805277348, 0.0387308485805988, 0.0386171191930771, 0.0385033898055553, 0.038389541208744, 0.0382754169404507, 0.0381614454090595, 0.0380474403500557, 0.0379332304000854, 0.0378189086914062, 0.03770462423563, 0.0375902578234673, 0.0374757759273052, 0.0373610928654671, 0.0372465290129185, 0.0371316932141781, 0.0370169691741467, 0.036902129650116, 0.0367869697511196, 0.0366720110177994, 0.0365568585693836, 0.0364417396485806, 0.0363263450562954, 0.0362110659480095, 0.0360955893993378, 0.0359800793230534, 0.0358644388616085, 0.035748690366745, 0.0356329791247845, 0.0355172269046307, 0.035401314496994, 0.0352852046489716, 0.0351690948009491, 0.0350529477000237, 0.0349367596209049, 0.0348204523324966, 0.0347039476037025, 0.0345874801278114, 0.0344709753990173, 0.0343543477356434, 0.0342375263571739, 0.0341207459568977, 0.0340039618313313, 0.033886980265379, 0.0337700359523296, 0.0336526595056057, 0.0335355214774609, 0.0334183387458324, 0.0333009995520115, 0.0331836231052876, 0.0330659672617912, 0.0329484678804874, 0.0328307747840881, 0.0327131189405918, 0.0325951054692268, 0.0324772112071514, 0.0323592014610767, 0.032241228967905, 0.032122939825058, 0.0320047661662102, 0.0318864770233631, 0.0317681841552258, 0.0316496975719929, 0.0315310098230839, 0.0314124412834644, 0.0312937572598457, 0.0311749894171953, 0.0310561042279005, 0.0309370998293161, 0.0308181364089251, 0.0306990947574377, 0.0305798910558224, 0.0304605700075626, 0.0303412470966578, 0.0302218068391085, 0.0301023293286562, 0.0299826115369797, 0.0298630110919476, 0.029743293300271, 0.0296235363930464, 0.0295036993920803, 0.029383784160018, 0.0292635895311832, 0.0291435141116381, 0.0290232431143522, 0.0289029683917761, 0.0287825372070074, 0.0286620650440454, 0.0285484008491039, 0.0284283645451069, 0.028308529406786, 0.0281893275678158, 0.0280702840536833, 0.0279518365859985, 0.0278336256742477, 0.0277160089462996, 0.0275985915213823, 0.0274817291647196, 0.0273651052266359, 0.0272490363568068, 0.0271331649273634, 0.0270178895443678, 0.0269026923924685, 0.0267882086336613, 0.0266741216182709, 0.02656015381217, 0.0264468602836132, 0.0263338051736355, 0.0262213032692671, 0.0261092018336058, 0.0259974543005228, 0.0258859843015671, 0.025775071233511, 0.0256645511835814, 0.0255544316023588, 0.0254444293677807, 0.0253351014107466, 0.0252257324755192, 0.0251171588897705, 0.0250090211629868, 0.0249012783169746, 0.0247939359396696, 0.0246868263930082, 0.0245802346616983, 0.0244741216301918, 0.0243682414293289, 0.0242627207189798, 0.024157952517271, 0.0240531843155622, 0.0239490102976561, 0.0238450765609741, 0.0237418543547392, 0.0236383974552155, 0.0235357712954283, 0.0234334208071232, 0.0233317483216524, 0.0232301522046328, 0.0231291521340609, 0.0230285469442606, 0.0229283403605223, 0.0228285286575556, 0.022728955373168, 0.0226300973445177, 0.0225313175469637, 0.0224330145865679, 0.0223351866006851, 0.0222377553582191, 0.0221402421593666, 0.0220436044037342, 0.0219473633915186, 0.0218515172600746, 0.0217560678720474, 0.021661015227437, 0.0215662010014057, 0.0214720238000154, 0.0213781613856554, 0.0212846919894218, 0.0211916249245405, 0.021098792552948, 0.0210065152496099, 0.0209146365523338, 0.0208231508731842, 0.0207320656627417, 0.0206410568207502, 0.0205506850033998, 0.0204607900232077, 0.0203711669892073, 0.0202822238206863, 0.0201933570206165, 0.0201050061732531, 0.0200171321630478, 0.0199295729398727, 0.0198424905538559, 0.0197557676583529, 0.0196693576872349, 0.0195834282785654, 0.0194978918880224, 0.0194127522408962, 0.0193277355283499, 0.019243348389864, 0.0191594399511814, 0.0190758872777224, 0.0189927313476801, 0.0189099740236998, 0.0188275296241045, 0.0187455639243126, 0.0186640340834856, 0.018582820892334, 0.0185115579515696, 0.0184497758746147, 0.0183885488659143, 0.0183280371129513, 0.018267285078764, 0.0182078815996647, 0.0181483216583729, 0.0180898699909449, 0.0180314183235168, 0.0179738383740187, 0.0179164987057447, 0.0178599506616592, 0.0178038012236357, 0.01774812489748, 0.0176927670836449, 0.0176381226629019, 0.0175839532166719, 0.0175304189324379, 0.0174770448356867, 0.0174243059009314, 0.0173719599843025, 0.0173202473670244, 0.0172692518681288, 0.0172184947878122, 0.0171684511005878, 0.0171187240630388, 0.0170696321874857, 0.0170208569616079, 0.0169727932661772, 0.0169251281768084, 0.0168781001120806, 0.0168314650654793, 0.0167853068560362, 0.0167392287403345, 0.0166944190859795, 0.0166494492441416, 0.0166055914014578, 0.0165618918836117, 0.01651874743402, 0.0164762381464243, 0.0164339672774076, 0.0163925662636757, 0.016351405531168, 0.0163107980042696, 0.0162706673145294, 0.0162311717867851, 0.0161919929087162, 0.016153447329998, 0.0161150619387627, 0.0160774700343609, 0.0160403531044722, 0.0160039495676756, 0.0159677062183619, 0.0159322544932365, 0.0158971194177866, 0.0158627796918154, 0.0158285964280367, 0.0157949682325125, 0.0157622136175632, 0.0157295390963554, 0.0156974978744984, 0.0156658533960581, 0.01563492231071, 0.0156041504815221, 0.0155739346519113, 0.0155445095151663, 0.0155155621469021, 0.0154870888218284, 0.0154589349403977, 0.0154313361272216, 0.0154045280069113, 0.0153779592365026, 0.0153521047905087, 0.0153264878317714, 0.0153014250099659, 0.0152771575376391, 0.0152529682964087, 0.0152297299355268, 0.0152066517621279, 0.0151839684695005, 0.0151618411764503, 0.0151403481140733, 0.0151194892823696, 0.0150989489629865, 0.0150792002677917, 0.0150595316663384, 0.0150404972955585, 0.0150222573429346, 0.0150041738525033, 0.0149868838489056, 0.0149698322638869, 0.0149536542594433, 0.0149374743923545, 0.014922009781003, 0.0149069409817457, 0.0148924272507429, 0.0148787060752511, 0.0148650640621781, 0.0148522164672613, 0.0148398438468575, 0.014831674285233, 0.0148265194147825, 0.0148213244974613, 0.0148164872080088, 0.0148116089403629, 0.014806691557169, 0.0148021318018436, 0.0147975319996476, 0.0147932088002563, 0.0147887691855431, 0.014784524217248, 0.0147804403677583, 0.0147763956338167, 0.0147725502029061, 0.0147686628624797, 0.0147648174315691, 0.0147613268345594, 0.0147577980533242, 0.0147545458748937, 0.0147510962560773, 0.0147480024024844, 0.0147449504584074, 0.0147419357672334, 0.0147391194477677, 0.0147362658753991, 0.0147337662056088, 0.0147311491891742, 0.014728769659996, 0.0147263510152698, 0.0147241307422519, 0.0147221870720387, 0.0147199677303433, 0.0147180641070008, 0.0147162787616253, 0.0147146536037326, 0.0147131057456136, 0.014711401425302, 0.0147101320326328, 0.0147089017555118, 0.0147077133879066, 0.0147066032513976, 0.0147056905552745, 0.0147048188373446, 0.0147041445598006, 0.0147035103291273, 0.0147028751671314, 0.0147025184705853, 0.0147022809833288, 0.0147019233554602, 0.0147018441930413, 0.0147018441930413, 0.0147019634023309, 0.0147022008895874, 0.0147024793550372, 0.0147029543295503, 0.0147035103291273, 0.0147042237222195, 0.0147047787904739, 0.0147056905552745, 0.0147066423669457, 0.0147077133879066, 0.0147089017555118, 0.014710171148181, 0.014711519703269, 0.0147130666300654, 0.0147144943475723, 0.0147163579240441, 0.0147180641070008, 0.0147200860083103, 0.0147219887003303, 0.0147239714860916, 0.0147263901308179, 0.0147286904975772, 0.0147311491891742, 0.0147336078807712, 0.0147362658753991, 0.0147391194477677, 0.014741855673492, 0.0147448303177953, 0.0147479632869363, 0.0147512936964631, 0.014754387550056, 0.0147576378658414, 0.0147612877190113, 0.0147648956626654, 0.0147687029093504, 0.014772430062294, 0.0147763174027205, 0.0147804012522101, 0.0147844851016998, 0.0147887282073498, 0.0147930905222893, 0.0147976111620665, 0.0148021318018436, 0.0148066123947501, 0.0148115297779441, 0.0148163689300418, 0.0148215228691697, 0.0148264393210411, 0.0148315550759435, 0.0148303378373384, 0.014823516830802, 0.0148165384307504, 0.0148093998432159, 0.0148020638152957, 0.0147944502532482, 0.0147866373881698, 0.0147787863388658, 0.0147707369178534, 0.0147624481469393, 0.0147538436576724, 0.0147452391684055, 0.0147364353761077, 0.0147274332121015, 0.0147181143984199, 0.0147087564691901, 0.0146991591900587, 0.0146893644705415, 0.0146794114261866, 0.0146692609414458, 0.0146589893847704, 0.0146484011784196, 0.0146376956254244, 0.0146268298849463, 0.0146157266572118, 0.014604464173317, 0.014593044295907, 0.0145814642310143, 0.0145696476101875, 0.0145575925707817, 0.0145453792065382, 0.0145330065861344, 0.0145205548033118, 0.0145078664645553, 0.0144947795197368, 0.0144817335531116, 0.0144684482365847, 0.0144550055265427, 0.0144412461668253, 0.0144274458289146, 0.0144133288413286, 0.0143991326913238, 0.0143846981227398, 0.0143701853230596, 0.0143554331734776, 0.0143403643742204, 0.0143251363188028, 0.0143099091947079, 0.014294364489615, 0.0142787415534258, 0.0142627991735935, 0.0142466994002461, 0.0142304413020611, 0.0142140248790383, 0.0141972498968244, 0.0141805158928037, 0.014163464307785, 0.0141462543979287, 0.0141288852319121, 0.0141113586723804, 0.0140936719253659, 0.0140757486224174, 0.0140575068071485, 0.0140391858294606, 0.0140207866206765, 0.0140021489933133, 0.0139832338318229, 0.0139642003923655, 0.0139449276030064, 0.0139254564419389, 0.0139059871435165, 0.0138861993327737, 0.0138662131503224, 0.0138460686430335, 0.013825686648488, 0.0138052254915237, 0.0137843657284975, 0.0137635068967938, 0.0137424906715751, 0.0137211959809065, 0.0136997029185295, 0.0136780515313148, 0.0136562017723918, 0.0136342728510499, 0.0136120272800326, 0.0135895824059844, 0.0135669792070985, 0.0135442968457937, 0.0135213350877166, 0.0134982969611883, 0.013474939391017, 0.0134513862431049, 0.0134277520701289, 0.0134038785472512, 0.0133798075839877, 0.0133555009961128, 0.0133311124518514, 0.013306487351656, 0.013281743042171, 0.0132567603141069, 0.0132288299500942, 0.0131942899897695, 0.0131596708670259, 0.0131251709535718, 0.0130905136466026, 0.013055776245892, 0.0130210779607296, 0.0129862613976002, 0.0129515239968896, 0.0129164289683104, 0.0128814531490207, 0.0128464391455054, 0.0128115825355053, 0.0127762891352177, 0.0127410367131233, 0.0127059416845441, 0.0126706892624497, 0.0126351183280349, 0.0125997858121991, 0.0125645734369755, 0.0125290025025606, 0.0124932732433081, 0.0124577423557639, 0.0124221323058009, 0.0123864039778709, 0.0123507147654891, 0.0123148653656244, 0.0122789787128568, 0.0122430510818958, 0.012207243591547, 0.0121711185202003, 0.0121350316330791, 0.012098946608603, 0.012062662281096, 0.0120264180004597, 0.0119900936260819, 0.0119538884609938, 0.0119174467399716, 0.0118809640407562, 0.0118445213884115, 0.0118079595267773, 0.0117712384089828, 0.0117345582693815, 0.011697918176651, 0.0116611178964376, 0.0116243185475469, 0.0115874400362372, 0.011550560593605, 0.0115134827792645, 0.0114764850586653, 0.0114394081756473, 0.0114022511988878, 0.0113650150597095, 0.0113277798518538, 0.0112905437126756, 0.0112531110644341, 0.0112156765535474, 0.0111782811582088, 0.0111407674849033, 0.0111031755805016, 0.0110655436292291, 0.0110279498621821, 0.010990159586072, 0.0109523674473166, 0.0109146172180772, 0.0108767068013549, 0.0108387172222137, 0.0108007285743952, 0.0107626998797059, 0.0107245910912752, 0.0106864832341671, 0.0106482561677694, 0.0106100281700492, 0.0105718411505222, 0.0105333365499973, 0.0104949902743101, 0.0104564856737852, 0.0104180993512273, 0.0103793563321233, 0.0103407325223088, 0.0103022288531065, 0.0102634858340025, 0.0102245453745127, 0.010185762308538, 0.0101469801738858, 0.0101080387830734, 0.0100690992549062, 0.0100298803299665, 0.0099908197298646, 0.00995180010795593, 0.0099125811830163, 0.0098732840269804, 0.00983394589275122, 0.00979464780539274, 0.00975523050874472, 0.00971557572484016, 0.00967612024396658, 0.009636583738029, 0.00959692895412445, 0.00955727510154247, 0.00952102895826101, 0.00948668830096722, 0.00945258606225252, 0.00941864121705294, 0.00938485562801361, 0.00935118831694126, 0.00931764114648104, 0.0092843696475029, 0.00925117917358875, 0.00921830534934998, 0.00918523222208023, 0.00915259681642056, 0.00912011973559856, 0.00908776186406612, 0.00905560236424208, 0.00902344193309546, 0.00899155903607607, 0.00895991548895836, 0.00892834924161434, 0.0088967839255929, 0.00886561628431082, 0.00883452594280243, 0.00880359578877687, 0.00877278484404087, 0.00874209031462669, 0.0087116751819849, 0.0086814584210515, 0.00865120347589254, 0.00862126331776381, 0.00859144330024719, 0.00856170244514942, 0.00853215903043747, 0.00850285310298204, 0.00847362913191319, 0.008444600738585, 0.00841592997312546, 0.00838702265173197, 0.00835847109556198, 0.00833011791110039, 0.00830192305147648, 0.00827384833246469, 0.00824573263525963, 0.0082181328907609, 0.00819061230868101, 0.00816313177347183, 0.00813592784106731, 0.00810868479311466, 0.00808168109506369, 0.00805487390607595, 0.00802818685770035, 0.0080017764121294, 0.00797544606029987, 0.0079493522644043, 0.00792318023741245, 0.00789732579141855, 0.00787162967026234, 0.00784617103636265, 0.00782087072730064, 0.00779553130269051, 0.00777043029665947, 0.00774564640596509, 0.00772090163081884, 0.00769631564617157, 0.00767180928960443, 0.00764758000150323, 0.007623509503901, 0.00759955774992704, 0.00757568562403321, 0.00755217019468546, 0.00752865523099899, 0.00750537822023034, 0.00748214032500982, 0.00745917996391654, 0.00743626011535525, 0.00741373561322689, 0.00739117246121168, 0.00736880674958229, 0.00734663987532258, 0.00732463132590055, 0.00730258319526911, 0.00728081353008747, 0.00725935958325863, 0.00723802531138062, 0.00721685029566288, 0.00719559518620372, 0.00717481598258018, 0.00715399719774723, 0.00713341636583209, 0.00711303343996406, 0.00709261139854789, 0.00707250693812966, 0.00705252029001713, 0.00703273294493556, 0.00701298471540213, 0.00699347490444779, 0.00697428174316883, 0.0069549698382616, 0.00693593546748161, 0.00691709946841002, 0.00689850142225623, 0.00688217859715223, 0.00687159830704331, 0.00686117773875594, 0.0068509946577251, 0.00684081064537168, 0.0068307863548398, 0.00682068197056651, 0.00681097526103258, 0.00680118752643466, 0.00679155997931957, 0.00678209029138088, 0.00677254144102335, 0.00676323054358363, 0.00675399880856276, 0.0067448471672833, 0.00673585291951895, 0.00672701792791486, 0.00671818293631077, 0.00670942757278681, 0.00670083053410053, 0.00669239088892937, 0.00668419152498245, 0.00667591206729412, 0.00666763074696064, 0.00665958877652884, 0.006651705596596, 0.00664382241666317, 0.00663601839914918, 0.00662837270647287, 0.00662096636369824, 0.00661355815827847, 0.00660630967468023, 0.00659898109734058, 0.00659189140424132, 0.00658487947657704, 0.00657802727073431, 0.00657117553055286, 0.00656448164954782, 0.00655802618712187, 0.00655156979337335, 0.0065451143309474, 0.00653889635577798, 0.0065327575430274, 0.00652677845209837, 0.00652071926742792, 0.006514897570014, 0.00650915503501892, 0.00650365184992552, 0.00649814773350954, 0.00649264361709356, 0.0064873774535954, 0.00648219045251608, 0.00647716270759702, 0.00647221365943551, 0.00646726507693529, 0.0064625539816916, 0.00645792158320546, 0.00645337020978332, 0.00644881743937731, 0.0064445030875504, 0.00644026743248105, 0.00643611280247569, 0.0064320364035666, 0.00642819702625275, 0.00642435858026147, 0.00642067892476916, 0.00641699880361557, 0.00641347700729966, 0.0064101149328053, 0.00640699034556746, 0.0064037861302495, 0.00640058191493154, 0.00639769528061152, 0.00639480864629149, 0.00639207940548658, 0.00638927193358541, 0.00638678297400475, 0.00638437131419778, 0.00638211937621236, 0.00637978687882423, 0.00637769373133779, 0.00637575797736645, 0.0063738226890564, 0.00637188879773021, 0.00637026969343424, 0.00636865198612213, 0.00636719167232513, 0.00636581284925342, 0.00636451179161668, 0.0063633699901402, 0.00636238697916269, 0.00636148219928145, 0.00636049872264266, 0.00635975319892168, 0.00635924562811852, 0.00635873852297664, 0.00635831011459231, 0.00635788263753057, 0.00635769171640277, 0.0063575804233551, 0.00635528098791838, 0.00635128421708941, 0.00634728651493788, 0.0063432096503675, 0.00633915327489376, 0.00633501820266247, 0.00633090175688267, 0.00632672663778067, 0.00632255058735609, 0.00631833542138338, 0.00631412025541067, 0.00630984548479319, 0.00630555115640163, 0.00630121538415551, 0.00629688147455454, 0.00629248889163136, 0.0062881144694984, 0.00628368044272065, 0.00627924688160419, 0.00627475464716554, 0.00627026194706559, 0.00626572920009494, 0.00626119645312428, 0.00625660456717014, 0.00625197263434529, 0.00624732207506895, 0.00624268967658281, 0.00623801816254854, 0.00623328750953078, 0.00622851680964231, 0.00622374704107642, 0.00621897634118795, 0.00621414603665471, 0.00620927754789591, 0.0062044276855886, 0.00619953777641058, 0.00619460828602314, 0.00618966016918421, 0.00618467153981328, 0.00617968384176493, 0.00617461418733001, 0.00616956641897559, 0.00616447953507304, 0.00615937169641256, 0.00615422520786524, 0.00614907732233405, 0.00614387029781938, 0.00613866420462728, 0.00613337894901633, 0.00612813094630837, 0.00612282613292336, 0.00611751992255449, 0.00611215503886342, 0.00610679108649492, 0.00610136426985264, 0.00609595980495214, 0.00609045661985874, 0.00608501117676497, 0.0060794884338975, 0.00607396382838488, 0.00606838008388877, 0.00606281729415059, 0.00605721492320299, 0.00605155015364289, 0.00604586862027645, 0.00604018568992615, 0.006034464109689, 0.00602870294824243, 0.00602291943505406, 0.00601713825017214, 0.00601131748408079, 0.00600545667111874, 0.00599955394864082, 0.0059936554171145, 0.00598773453384638, 0.00598175451159477, 0.0059757549315691, 0.00596975535154343, 0.00596373435109854, 0.00595765607431531, 0.00595159688964486, 0.00594543758779764, 0.00593932019546628, 0.00593312131240964, 0.00592694384977221, 0.00592068675905466, 0.00591446738690138, 0.00590817118063569, 0.00590187450870872, 0.00589553685858846, 0.00588919967412949, 0.00588276423513889, 0.00587638793513179, 0.00586993247270584, 0.00586349610239267, 0.00585702015087008, 0.00585048599168658, 0.00584393041208386, 0.00583737622946501, 0.00583078106865287, 0.00582177564501762, 0.00581118697300553, 0.00580062018707395, 0.00579003151506186, 0.00577940419316292, 0.0057688164524734, 0.00575822917744517, 0.00574764050543308, 0.00573701318353415, 0.00572642544284463, 0.0057158381678164, 0.0057052499614656, 0.00569464219734073, 0.0056840549223125, 0.00567344715818763, 0.00566285895183682, 0.00565223162993789, 0.0056416830047965, 0.00563105614855886, 0.00562048796564341, 0.00560984062030911, 0.00559929199516773, 0.00558866513893008, 0.00557807693257928, 0.00556746916845441, 0.0055569214746356, 0.00554627366364002, 0.00553568592295051, 0.00552507862448692, 0.00551453046500683, 0.00550388311967254, 0.00549329491332173, 0.0054826675914228, 0.0054721194319427, 0.00546151166781783, 0.00545090390369296, 0.00544029660522938, 0.00542972842231393, 0.00541916070505977, 0.00540851335972548, 0.00539794564247131, 0.00538735743612051, 0.00537675013765693, 0.0053661223500967, 0.00535553507506847, 0.00534496689215302, 0.00533437868580222, 0.00532375136390328, 0.00531316315755248, 0.00530257588252425, 0.00529198767617345, 0.00528137991204858, 0.00527081219479442, 0.00526018487289548, 0.00524959713220596, 0.00523896981030703, 0.00522838113829494, 0.00521781342104077, 0.00520720612257719, 0.00519657880067825, 0.00518603017553687, 0.00517540285363793, 0.00516481464728713, 0.00515418779104948, 0.00514365918934345, 0.00513303186744452, 0.00512244366109371, 0.00511185638606548, 0.00510124815627933, 0.00509062130004168, 0.00508003309369087, 0.00506946537643671, 0.00505885761231184, 0.00504824984818697, 0.00503766210749745, 0.00502707390114665, 0.00501648616045713, 0.0050058588385582, 0.00499527109786868, 0.00498468382284045, 0.00497409515082836, 0.00496346782892942, 0.00495288008823991, 0.00494229234755039, 0.00493170414119959, 0.00492109684273601, 0.00491048907861114, 0.00489994138479233, 0.0048893135972321, 0.00487872585654259, 0.00486809806898236, 0.00485756993293762, 0.00484692258760333, 0.00483635440468788, 0.00482570705935359, 0.0048151989467442, 0.00480453157797456, 0.00479394430294633, 0.0047833165153861, 0.00477276835590601, 0.0047649466432631, 0.00475701596587896, 0.0047492035664618, 0.00474143167957664, 0.0047336989082396, 0.00472600571811199, 0.00471837213262916, 0.00471081864088774, 0.00470328377559781, 0.00469576893374324, 0.00468841288238764, 0.00468103773891926, 0.00467372126877308, 0.00466648442670703, 0.00465924665331841, 0.00465210946276784, 0.00464499136433005, 0.0046379528939724, 0.00463095400482416, 0.00462403381243348, 0.00461711408570409, 0.00461029354482889, 0.0046035130508244, 0.00459679123014212, 0.00459012947976589, 0.00458350731059909, 0.00457690423354506, 0.00457040127366781, 0.00456393742933869, 0.00455753318965435, 0.00455118855461478, 0.00454486347734928, 0.00453865760937333, 0.00453241169452667, 0.00452628498896956, 0.00452019833028316, 0.00451415125280619, 0.00450814329087734, 0.00450223498046398, 0.0044963457621634, 0.00449053617194295, 0.00448474660515785, 0.00447903666645288, 0.00447336584329605, 0.00446773553267121, 0.00446214387193322, 0.00445667095482349, 0.00445123855024576, 0.00444580568000674, 0.00444043288007379, 0.00443513877689838, 0.00442990427836776, 0.00442470982670784, 0.00441955449059606, 0.00441449834033847, 0.00440946267917752, 0.00440448615700006, 0.00439960788935423, 0.0043947109952569, 0.00438985321670771, 0.00438505550846457, 0.00438033603131771, 0.00437573622912169, 0.00437109684571624, 0.00436651613563299, 0.00436201505362988, 0.00435761408880353, 0.00435317307710648, 0.0043488503433764, 0.00434454809874296, 0.00434032455086708, 0.0043361010029912, 0.00433199713006616, 0.00432791281491518, 0.00432390719652176, 0.00431990204378963, 0.00431597605347633, 0.00431214971467853, 0.00430832337588072, 0.0043045561760664, 0.00430084858089685, 0.00429721968248487, 0.00429359124973416, 0.00429002242162824, 0.00428655231371522, 0.00428310269489884, 0.00427969265729189, 0.00427636131644249, 0.00427309004589915, 0.00426985789090395, 0.00426668534055352, 0.00426357286050916, 0.00426047947257757, 0.0042574661783874, 0.00425449199974537, 0.00425159698352218, 0.00424870243296027, 0.00424592662602663, 0.00424315081909299, 0.0042404537089169, 0.00423846021294594, 0.00423976872116327, 0.00424101762473583, 0.00424226652830839, 0.00424351589754224, 0.00424470566213131, 0.00424585584551096, 0.00424700556322932, 0.0042480961419642, 0.00424920674413443, 0.00425023725256324, 0.00425128825008869, 0.00425229920074344, 0.00425325147807598, 0.00425422238186002, 0.00425517419353127, 0.00425606640055776, 0.00425689946860075, 0.00425777211785316, 0.00425860472023487, 0.00425941776484251, 0.00426015118137002, 0.00426090462133288, 0.00426163850352168, 0.00426227273419499, 0.00426294701173902, 0.00426360126584768, 0.00426421547308564, 0.0042647710070014, 0.00426534563302994, 0.00426588160917163, 0.00426639663055539, 0.00426685297861695, 0.00426732888445258, 0.00426772516220808, 0.00426810188218951, 0.0042684986256063, 0.00426883576437831, 0.00426917290315032, 0.00426944997161627, 0.00426972797140479, 0.00426994590088725, 0.00427018385380507, 0.00427034264430404, 0.00427050096914172, 0.00427065975964069, 0.00427073892205954, 0.00427081855013967, 0.00427089771255851, 0.00427093775942922, 0.00427089771255851, 0.00427087815478444, 0.00427081855013967, 0.00427075894549489, 0.00427064020186663, 0.00427050096914172, 0.00427036266773939, 0.00427014427259564, 0.00426994590088725, 0.00426970841363072, 0.00426944997161627, 0.0042691333219409, 0.00426883576437831, 0.0042684986256063, 0.00426814146339893, 0.00426772516220808, 0.00426730886101723, 0.00426685297861695, 0.00426635704934597, 0.00426586158573627, 0.00426534563302994, 0.00426479056477547, 0.00426419591531157, 0.00426358124241233, 0.00426296656951308, 0.00426231231540442, 0.00426159892231226, 0.00426088506355882, 0.00426015118137002, 0.00425935862585902, 0.00425858469679952, 0.00425777211785316, 0.00425693904981017, 0.00425602728500962, 0.00425511505454779, 0.00425420282408595, 0.00425327103585005, 0.0042522600851953, 0.00425126869231462, 0.00425025727599859, 0.00424920674413443, 0.00424807611852884, 0.00424698600545526, 0.00424585584551096, 0.00424464605748653, 0.00424347631633282, 0.00424226652830839, 0.00424103764817119, 0.00423976872116327, 0.00423844018951058, 0.00423874612897635, 0.00423343200236559, 0.00422780076041818, 0.00422224914655089, 0.0042164595797658, 0.0042106700129807, 0.00420472165569663, 0.00419869460165501, 0.00419258745387197, 0.00418632198125124, 0.00417997734621167, 0.004173394292593, 0.00416689133271575, 0.00416022911667824, 0.00415340857580304, 0.00414658756926656, 0.00413952907547355, 0.00413247104734182, 0.00412525376304984, 0.00411787768825889, 0.00411058124154806, 0.00410296767950058, 0.0040953541174531, 0.00408766092732549, 0.0040798089466989, 0.00407187826931477, 0.00406378880143166, 0.00405561970546842, 0.00404737144708633, 0.00403904402628541, 0.00403055781498551, 0.00402191281318665, 0.00401326827704906, 0.00400454411283135, 0.00399558246135712, 0.00398654118180275, 0.0039774994365871, 0.00396822020411491, 0.00395886180922389, 0.00394942425191402, 0.00393990660086274, 0.00393038988113403, 0.00392055511474609, 0.00391072081401944, 0.0039008071180433, 0.00389073486439884, 0.0038805038202554, 0.00387019384652376, 0.00385988340713084, 0.00384941464290023, 0.00383870746009052, 0.00382808013819158, 0.00381729402579367, 0.00380634912289679, 0.00379532529041171, 0.00378414266742766, 0.00377296004444361, 0.00376153946854174, 0.00375019805505872, 0.00373869808390737, 0.00372688099741936, 0.00371522270143032, 0.00370324682444334, 0.00369135034270585, 0.00367937446571887, 0.00366708147339523, 0.00365478871390224, 0.00364249548874795, 0.00362988514825702, 0.00361727504059672, 0.00360450614243746, 0.00359173724427819, 0.00357881002128124, 0.00356580293737352, 0.0035527169238776, 0.0035393931902945, 0.00352614838629961, 0.00351258623413742, 0.00349910347722471, 0.00348538300022483, 0.00347150373272598, 0.00345770409330726, 0.00344366603530943, 0.00342954904772341, 0.00341551122255623, 0.0034011562820524, 0.00338680110871792, 0.00337228737771511, 0.00335761508904397, 0.00334294280037284, 0.00332803255878389, 0.00331312231719494, 0.00329813291318715, 0.0032829053234309, 0.00326767796650529, 0.00325237144716084, 0.00323682650923729, 0.0032212024088949, 0.00320557854138315, 0.00318979588337243, 0.00317265279591084, 0.00315147708170116, 0.00313034118153155, 0.00310904672369361, 0.003087910823524, 0.00306669529527426, 0.00304551981389523, 0.00302434409968555, 0.00300312880426645, 0.002981913741678, 0.00296073802746832, 0.00293952273204923, 0.00291838706471026, 0.0028971319552511, 0.00287599605508149, 0.00285478075966239, 0.00283356569707394, 0.00281238998286426, 0.00279125408269465, 0.00276999920606613, 0.0027488237246871, 0.00272764801047742, 0.00270643271505833, 0.00268517760559916, 0.00266400235705078, 0.00264286622405052, 0.00262165092863142, 0.00260051502846181, 0.0025792601518333, 0.00255808467045426, 0.00253690895624459, 0.00251569366082549, 0.0024945973418653, 0.00247342209331691, 0.00245212763547897, 0.00243099150247872, 0.0024097366258502, 0.00238864030689001, 0.00236746459268034, 0.00234620994888246, 0.00232503400184214, 0.0023037395440042, 0.00228268303908408, 0.00226138858124614, 0.00224025244824588, 0.00221911631524563, 0.00219786143861711, 0.00217664637602866, 0.0021555102430284, 0.00213429518043995, 0.00211311946623027, 0.00209190417081118, 0.00207072868943214, 0.00204955297522247, 0.00202829809859395, 0.00200712261721492, 0.00198590732179582, 0.00196473160758615, 0.00194359570741653, 0.00192234083078802, 0.00190120481420308, 0.00187998963519931, 0.00185873464215547, 0.00183759874198586, 0.0018164231441915, 0.00179520773235708, 0.00177395297214389, 0.00175281683914363, 0.00173160166013986, 0.00171050534117967, 0.00168929016217589, 0.00166803516913205, 0.0016468595713377, 0.00162572355475277, 0.00160450837574899, 0.00158337235916406, 0.00156211748253554, 0.00154090218711644, 0.00151972658932209, 0.00149859068915248, 0.00147741509135813, 0.00145623937714845, 0.00143498450051993, 0.00141380878631026, 0.00139263330493122, 0.00137145759072155, 0.00135020271409303, 0.00132902711629868, 0.001307851402089, 0.00128667580429465, 0.00126542081125081, 0.00124424532987177, 0.00122306973207742, 0.00120189401786774, 0.00118063914123923, 0.00115950312465429, 0.00113832764327526, 0.00111703283619136, 0.00109589705243707, 0.00107468164060265, 0.00105195550713688, 0.00103617296554148, 0.00102046981919557, 0.00100484595168382, 0.000989459920674562, 0.000974074006080627, 0.000958806951530278, 0.000943698571063578, 0.000928669527638704, 0.000913680123630911, 0.000898849277291447, 0.000884177163243294, 0.000869504932779819, 0.000854991376399994, 0.000840517517644912, 0.00082624185597524, 0.000812045531347394, 0.000797928543761373, 0.00078397017205134, 0.000770130718592554, 0.000756410299800336, 0.000742650066968054, 0.000729088264051825, 0.000715605681762099, 0.000702321471180767, 0.000689037144184113, 0.000675871910061687, 0.000662865175399929, 0.000650017114821821, 0.000637169054243714, 0.000624439970124513, 0.000611790164839476, 0.000599259336013347, 0.000586847425438464, 0.000574554491322488, 0.000562459928914905, 0.000550365250092, 0.000538349966518581, 0.000526453601196408, 0.000514676212333143, 0.000503097078762949, 0.000491517945192754, 0.000480018119560555, 0.000468716578325257, 0.000457573682069778, 0.000446391088189557, 0.000435367139289156, 0.000424422469222918, 0.000413557136198506, 0.000402969366405159, 0.000392341957194731, 0.000381833524443209, 0.000371444039046764, 0.000361133861588314, 0.000351061607943848, 0.000340949685778469, 0.000331075716530904, 0.000321082741720602, 0.000311288080411032, 0.000301731342915446, 0.000292253913357854, 0.000282816123217344, 0.000273497338639572, 0.000264297472313046, 0.000255176913924515, 0.000246135692577809, 0.000237253087107092, 0.000228410106501542, 0.000219725756323896, 0.000211120743188076, 0.000202634677407332, 0.000194227905012667, 0.000186019417014904, 0.000177850582986139, 0.000169761056895368, 0.000161830146680586, 0.000154097506310791, 0.000146325226523913, 0.000138711562613025, 0.000131137538119219, 0.000123761798022315, 0.00011642570461845, 0.000109208587673493, 0.000102150079328567, 9.50915709836408e-05, 8.81916857906617e-05, 8.14900704426691e-05, 7.47487938497216e-05, 6.81661404087208e-05, 6.17421101196669e-05, 5.53577265236527e-05, 4.91716200485826e-05, 4.29855135735124e-05, 3.68787150364369e-05, 3.09701899823267e-05, 2.51806286541978e-05, 1.95893389900448e-05, 1.39187413878972e-05, 8.40676057123346e-06, 2.97409019367478e-06, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15, 2.11924572908592e-15   }, 
   { 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 5.37614880613546e-07, 1.83079646376427e-06, 3.26927965943469e-06, 4.66417213829118e-06, 6.23342657490866e-06, 7.83174073148984e-06, 9.4736451501376e-06, 1.12608513518353e-05, 1.30480584630277e-05, 1.50096266224864e-05, 1.69566628756002e-05, 1.89908805623418e-05, 2.11413425859064e-05, 2.33063328778371e-05, 2.55585018749116e-05, 2.79559735645307e-05, 3.03534452541498e-05, 3.27799789374694e-05, 3.53954019374214e-05, 3.79962948500179e-05, 4.07279585488141e-05, 4.35322763223667e-05, 4.63511169073172e-05, 4.93152692797594e-05, 5.23520648130216e-05, 5.53598038095515e-05, 5.85854868404567e-05, 6.17530604358763e-05, 6.50514048174955e-05, 6.84659826220013e-05, 7.18515002517961e-05, 7.54113862058148e-05, 7.90729754953645e-05, 8.26764517114498e-05, 8.64252215251327e-05, 9.02611718629487e-05, 9.41261896514334e-05, 9.81219782261178e-05, 0.000102146819699556, 0.00010627337906044, 0.000110501649032813, 0.00011471538891783, 0.000119030832138378, 0.00012352064368315, 0.000127952342154458, 0.00013257292448543, 0.000137178954901174, 0.000141843149322085, 0.000146681675687432, 0.000151505693793297, 0.000156416863319464, 0.000161444288096391, 0.00016648625023663, 0.000171658975887112, 0.00017693341942504, 0.000182164250873029, 0.000187569472473115, 0.000193003725144081, 0.000198525187443011, 0.00020419193606358, 0.000209771489608102, 0.000215510910493322, 0.000221395617700182, 0.000227222190005705, 0.000233194077736698, 0.000239296728977934, 0.000245341274421662, 0.000251516583375633, 0.000257851730566472, 0.00026411420549266, 0.000270551041467115, 0.000277002429356799, 0.000283570057945326, 0.000290195806883276, 0.000296908721793443, 0.00030369427986443, 0.00031053798738867, 0.000317468860885128, 0.000324472348438576, 0.000331534014549106, 0.000338711892254651, 0.000345947919413447, 0.000353183888364583, 0.000360579724656418, 0.000368033710401505, 0.000375560310203582, 0.000383101461920887, 0.000390773348044604, 0.000398517906432971, 0.000406349659897387, 0.000414210488088429, 0.000422173005063087, 0.000430280808359385, 0.00043833046220243, 0.000446510966867208, 0.000454764027381316, 0.000463118893094361, 0.0004715173272416, 0.000480017421068624, 0.000488546618726104, 0.00050086184637621, 0.000513252336531878, 0.000525673793163151, 0.00053812243277207, 0.000550689175724983, 0.00056322681484744, 0.000575849902816117, 0.000588501919992268, 0.000601213949266821, 0.000614013173617423, 0.000626812397968024, 0.000639667850919068, 0.000652610557153821, 0.000665556872263551, 0.000678557669743896, 0.000691645662300289, 0.000704735517501831, 0.000717883405741304, 0.000731116742826998, 0.000744380871765316, 0.000757701345719397, 0.000771050923503935, 0.000784433097578585, 0.000797898857854307, 0.000811393721960485, 0.0008249775855802, 0.000838559586554766, 0.000852230587042868, 0.000865930633153766, 0.000879687024280429, 0.000893472461029887, 0.000907348701730371, 0.000921221333555877, 0.000935122952796519, 0.000949171837419271, 0.000963220663834363, 0.000977267511188984, 0.000991461682133377, 0.0010056538740173, 0.00101984618231654, 0.00103421648964286, 0.00104852509684861, 0.00106294977013022, 0.00107737630605698, 0.00109186104964465, 0.00110643112566322, 0.00112100306432694, 0.00113560212776065, 0.00115031749010086, 0.00116506556514651, 0.00117980991490185, 0.00119467067997903, 0.00120956217870116, 0.0012244536774233, 0.00123948871623725, 0.00125452550128102, 0.00126961874775589, 0.00128474272787571, 0.00129989581182599, 0.00131516333203763, 0.00133043096866459, 0.00134575832635164, 0.00136114389169961, 0.00137655658181757, 0.00139205844607204, 0.00140755844768137, 0.00142308755312115, 0.00143876555375755, 0.00145443982910365, 0.00147011422086507, 0.00148593564517796, 0.00150175718590617, 0.00151757674757391, 0.00153354369103909, 0.00154947955161333, 0.00156556244473904, 0.00158161635044962, 0.00159769773017615, 0.00161389505956322, 0.00163009425159544, 0.00164632266387343, 0.00166269449982792, 0.00167903897818178, 0.00169543991796672, 0.00171192793641239, 0.00172841944731772, 0.00174496578983963, 0.00176159909460694, 0.00177823600824922, 0.0017949566245079, 0.00181173521559685, 0.00182851566933095, 0.00184541055932641, 0.00186230731196702, 0.00187923305202276, 0.00189627322833985, 0.00191328441724181, 0.00193044252227992, 0.00194760086014867, 0.00196475721895695, 0.0019805752672255, 0.00199749902822077, 0.00201433594338596, 0.00203117611818016, 0.00204789661802351, 0.00206464622169733, 0.00208134111016989, 0.00209797476418316, 0.0021145788487047, 0.00213115569204092, 0.00214764382690191, 0.00216413382440805, 0.00218053627759218, 0.00219690822996199, 0.00221327994950116, 0.00222953711636364, 0.00224582361988723, 0.00226205005310476, 0.00227819103747606, 0.00229430315084755, 0.00231038243509829, 0.00232643820345402, 0.00234243227168918, 0.00235839700326324, 0.00237430771812797, 0.0023901853710413, 0.0024059759452939, 0.00242173951119184, 0.00243750074878335, 0.00245317700318992, 0.00246885302476585, 0.00248446920886636, 0.0024999980814755, 0.00251552904956043, 0.00253097270615399, 0.0025464438367635, 0.00256182928569615, 0.00257715675979853, 0.00259248213842511, 0.00260774977505207, 0.00262296083383262, 0.00263814139179885, 0.00265326537191868, 0.0026683600153774, 0.00268339528702199, 0.00269840122200549, 0.00271335081197321, 0.00272830040194094, 0.00274313194677234, 0.00275796535424888, 0.00277276989072561, 0.00278751226142049, 0.00280223111622036, 0.00281685939989984, 0.00283148768357933, 0.00284609012305737, 0.00286057312041521, 0.00287505588494241, 0.00288952607661486, 0.00290390732698143, 0.00291827577166259, 0.0029326151125133, 0.00294685107655823, 0.00296107213944197, 0.00297529529780149, 0.00298938783816993, 0.00300350738689303, 0.00301754148676991, 0.0030315755866468, 0.00304554821923375, 0.00305945379659534, 0.00307334074750543, 0.0030871843919158, 0.003100958885625, 0.00311472965404391, 0.003128427779302, 0.00314209866337478, 0.00315573904663324, 0.00316927931271493, 0.00318283215165138, 0.00319632864557207, 0.00320978183299303, 0.00322318752296269, 0.00323656969703734, 0.00324987573549151, 0.00326316710561514, 0.00327636045403779, 0.00328956311568618, 0.00330272503197193, 0.0033158294390887, 0.00332888844422996, 0.00334193487651646, 0.00335486466065049, 0.00336783635430038, 0.00338069186545908, 0.00339353480376303, 0.00340636307373643, 0.00341911660507321, 0.00343182869255543, 0.00344452611170709, 0.0034545473754406, 0.00346372276544571, 0.0034728697501123, 0.00348190008662641, 0.00349091598764062, 0.00349985924549401, 0.00350870797410607, 0.00351750617846847, 0.0035262678284198, 0.00353494216687977, 0.00354360230267048, 0.00355214579030871, 0.00356066785752773, 0.00356910983100533, 0.00357747892849147, 0.00358580495230854, 0.00359401432797313, 0.00360222393646836, 0.00361037510447204, 0.00361843220889568, 0.00362647464498878, 0.00363442278467119, 0.00364230526611209, 0.00365012977272272, 0.00365788885392249, 0.00366558949463069, 0.00367323239333928, 0.00368078821338713, 0.00368832936510444, 0.00369578320533037, 0.00370314274914563, 0.00371048063971102, 0.00371778174303472, 0.00372498133219779, 0.00373213761486113, 0.00373922078870237, 0.00374624622054398, 0.00375322042964399, 0.0037600789219141, 0.00376692274585366, 0.00377372978255153, 0.00378042832016945, 0.00378709030337632, 0.00379370152950287, 0.00380022544413805, 0.00380667694844306, 0.0038130774628371, 0.00381944165565073, 0.0038257259875536, 0.00383193767629564, 0.00383811281062663, 0.00384422997012734, 0.00385025260038674, 0.00385622470639646, 0.00386214558966458, 0.00386799406260252, 0.0038737989962101, 0.00387951638549566, 0.0038851760327816, 0.00389078469015658, 0.00389630580320954, 0.00390181271359324, 0.00390724698081613, 0.00391260161995888, 0.00391791248694062, 0.00392315769568086, 0.00392832281067967, 0.00393344508484006, 0.00393846491351724, 0.0039434633217752, 0.00394839607179165, 0.00395325664430857, 0.00395808089524508, 0.00396283948794007, 0.00396748865023255, 0.00397211685776711, 0.00397665752097964, 0.00398119073361158, 0.0039856294170022, 0.00398998148739338, 0.00399431167170405, 0.00399857619777322, 0.00400273920968175, 0.00400686543434858, 0.00401095580309629, 0.00401493674144149, 0.00401890417560935, 0.00402276869863272, 0.00402660481631756, 0.0040303603745997, 0.00403403677046299, 0.00403766939416528, 0.00404126523062587, 0.00404476001858711, 0.00404822546988726, 0.00405160384252667, 0.00405494542792439, 0.00405820040032268, 0.00406138272956014, 0.0040645501576364, 0.00406809523701668, 0.00407026056200266, 0.00407243240624666, 0.00407461915165186, 0.00407679891213775, 0.00407898612320423, 0.00408118031919003, 0.00408338103443384, 0.00408558221533895, 0.00408778386190534, 0.00409000692889094, 0.00409223744645715, 0.00409447494894266, 0.00409670500084758, 0.00409894995391369, 0.00410118792206049, 0.00410343240946531, 0.00410569924861193, 0.00410797353833914, 0.00411026179790497, 0.00411254307255149, 0.00411480246111751, 0.00411711260676384, 0.00411940831691027, 0.00412168959155679, 0.00412400765344501, 0.00412633921951056, 0.00412867171689868, 0.00413100328296423, 0.00413332134485245, 0.00413566781207919, 0.00413802126422524, 0.00414034631103277, 0.004142708145082, 0.00414510536938906, 0.00414746627211571, 0.00414985651150346, 0.00415220996364951, 0.00415461510419846, 0.00415701232850552, 0.00415940256789327, 0.00416182214394212, 0.00416424870491028, 0.00416665291413665, 0.004169094376266, 0.00417152093723416, 0.00417396193370223, 0.0041764029301703, 0.00417885836213827, 0.00418130680918694, 0.00418380601331592, 0.00418626191094518, 0.00418872432783246, 0.00419121701270342, 0.00419369386509061, 0.00419619306921959, 0.00419869227334857, 0.00420122034847736, 0.00420372746884823, 0.00420626252889633, 0.00420876173302531, 0.00421130424365401, 0.00421383930370212, 0.00421636085957289, 0.00421891827136278, 0.00422149011865258, 0.00422405451536179, 0.0042266333475709, 0.00422918377444148, 0.00423178495839238, 0.00423434935510159, 0.0042369500733912, 0.00423955079168081, 0.00424215896055102, 0.00424478156492114, 0.00424740463495255, 0.00425001280382276, 0.00425264984369278, 0.0042552868835628, 0.00425791693851352, 0.00426056841388345, 0.00426323479041457, 0.00426590861752629, 0.00426857499405742, 0.00427122693508863, 0.00427391473203897, 0.00427659554407001, 0.00427929079160094, 0.00428200047463179, 0.00428472505882382, 0.00428742775693536, 0.0042901374399662, 0.00429284758865833, 0.00429557217285037, 0.00429830374196172, 0.00430104276165366, 0.00430381763726473, 0.00430657109245658, 0.00430932454764843, 0.00431209290400147, 0.00431422842666507, 0.00431559421122074, 0.00431703263893723, 0.00431864568963647, 0.00432040402665734, 0.00432222057133913, 0.00432419637218118, 0.00432631745934486, 0.00432854052633047, 0.00433089444413781, 0.00433332147076726, 0.00433595152571797, 0.00433868262916803, 0.00434147240594029, 0.0043444512411952, 0.00434753159061074, 0.0043506994843483, 0.00435402663424611, 0.00435747019946575, 0.00436108792200685, 0.00436476385220885, 0.00436857156455517, 0.00437250873073936, 0.00437662098556757, 0.0043807472102344, 0.00438510673120618, 0.00438955286517739, 0.00439411541447043, 0.00439880834892392, 0.00440358882769942, 0.00440852902829647, 0.00441355677321553, 0.00441872933879495, 0.00442401878535748, 0.00442945258691907, 0.00443498883396387, 0.00444065546616912, 0.00444643804803491, 0.00445235194638371, 0.00445836782455444, 0.00446452852338552, 0.00447087781503797, 0.00447721313685179, 0.0044838241301477, 0.00449047889560461, 0.00449723564088345, 0.00450412277132273, 0.00451115565374494, 0.00451829005032778, 0.00452555483207107, 0.00453299423679709, 0.00454046297818422, 0.00454810587689281, 0.00455586472526193, 0.00456375442445278, 0.00457178987562656, 0.00457986863330007, 0.00458815088495612, 0.00459651974961162, 0.00460506370291114, 0.00461366586387157, 0.00462244218215346, 0.0046313046477735, 0.00464031379669905, 0.00464938068762422, 0.00465865107253194, 0.00466802297160029, 0.00467748194932938, 0.00468712998554111, 0.00469686510041356, 0.00470667239278555, 0.00471671344712377, 0.00472681131213903, 0.0047369971871376, 0.00474737212061882, 0.00475780433043838, 0.00476842606440187, 0.00477919261902571, 0.00478995963931084, 0.00480100233107805, 0.00481208926066756, 0.00482327723875642, 0.00483463983982801, 0.00484608951956034, 0.0048576551489532, 0.00486936699599028, 0.00488119432702661, 0.00489315250888467, 0.00490521267056465, 0.00491740368306637, 0.00492972508072853, 0.00494216289371252, 0.00495474552735686, 0.00496744504198432, 0.0049802316352725, 0.00499325059354305, 0.00500624068081379, 0.0050194482319057, 0.00503275822848082, 0.00504616927355528, 0.00506316963583231, 0.00508092530071735, 0.00509885558858514, 0.00511698890477419, 0.00513532664626837, 0.0051537798717618, 0.00517249433323741, 0.00519147096201777, 0.00521050533279777, 0.00522977160289884, 0.00524918455630541, 0.00526891648769379, 0.0052887643687427, 0.00530884461477399, 0.00532904174178839, 0.00534950057044625, 0.00537007534876466, 0.00539096910506487, 0.00541195087134838, 0.00543304858729243, 0.00545443734154105, 0.00547602912411094, 0.00549782440066338, 0.00551976449787617, 0.00554182147607207, 0.00556422676891088, 0.00558677734807134, 0.00560944434255362, 0.00563234370201826, 0.00565547542646527, 0.00567869516089559, 0.00570229208096862, 0.00572588900104165, 0.00574980536475778, 0.00577383814379573, 0.00579801667481661, 0.00582251418381929, 0.00584712810814381, 0.00587194599211216, 0.00589693756774068, 0.00592213310301304, 0.00594756053760648, 0.00597313372418284, 0.00599890993908048, 0.00602480256929994, 0.00605095690116286, 0.00607734359800816, 0.00610390491783619, 0.00613058218732476, 0.0061575504951179, 0.0061846342869103, 0.00621198024600744, 0.00623947102576494, 0.00626713642850518, 0.00629497645422816, 0.00632304791361094, 0.00635132379829884, 0.00637974496930838, 0.00640839850530028, 0.00643719686195254, 0.00646628625690937, 0.00649546273052692, 0.00652481382712722, 0.00655442662537098, 0.00658421311527491, 0.0066142613068223, 0.00664436724036932, 0.00667473580688238, 0.00670530693605542, 0.00673599448055029, 0.00676694372668862, 0.00679809646680951, 0.00682939449325204, 0.00686083734035492, 0.00689257122576237, 0.00692445039749146, 0.00695656193420291, 0.00698878988623619, 0.00702122133225203, 0.00705385580658913, 0.00708675244823098, 0.00711976457387209, 0.00715298065915704, 0.00718642864376307, 0.00721993530169129, 0.00725387735292315, 0.00728779146447778, 0.00732196541503072, 0.00735631491988897, 0.00739083904772997, 0.00742565235123038, 0.0074605830013752, 0.00749571667984128, 0.00753102544695139, 0.00756647903472185, 0.00760225253179669, 0.00763811217620969, 0.00767417624592781, 0.0077104726806283, 0.00774694327265024, 0.00778370536863804, 0.00782748404890299, 0.00787132140249014, 0.00791515875607729, 0.00795908365398645, 0.00800297968089581, 0.00804691761732101, 0.00809093005955219, 0.00813497044146061, 0.00817909836769104, 0.0082232253625989, 0.00826732534915209, 0.00831149611622095, 0.00835572555661201, 0.00840002857148647, 0.00844433065503836, 0.00848866254091263, 0.00853303633630276, 0.00857741199433804, 0.00862190313637257, 0.00866636540740728, 0.00871087051928043, 0.00875540543347597, 0.00880001299083233, 0.00884469319134951, 0.00888935849070549, 0.00893408246338367, 0.00897880550473928, 0.00902357418090105, 0.00906845647841692, 0.00911325216293335, 0.00915813725441694, 0.00920306332409382, 0.00924801919609308, 0.00929307751357555, 0.00933810602873564, 0.00938316434621811, 0.00942829437553883, 0.0094734113663435, 0.00951859913766384, 0.00956381671130657, 0.0096090929582715, 0.00965439807623625, 0.00969970226287842, 0.00974513776600361, 0.00979054532945156, 0.00983593706041574, 0.00988141540437937, 0.00992693938314915, 0.00997253507375717, 0.0100181009620428, 0.0100637404248118, 0.0101094078272581, 0.0101551059633493, 0.0102009186521173, 0.0102466735988855, 0.0102924443781376, 0.0103382859379053, 0.0103842299431562, 0.0104301599785686, 0.0104761039838195, 0.0105220917612314, 0.0105681233108044, 0.0106142563745379, 0.0106603028252721, 0.0107064647600055, 0.0107526406645775, 0.0107988333329558, 0.0108451694250107, 0.0108914766460657, 0.0109377698972821, 0.0109840761870146, 0.0110304858535528, 0.0110769830644131, 0.0111234784126282, 0.011169989593327, 0.0112165156751871, 0.0112631283700466, 0.011309826746583, 0.0113564683124423, 0.0114031406119466, 0.0114498976618052, 0.0114966696128249, 0.0115434573963284, 0.0115903159603477, 0.0116372043266892, 0.0116841373965144, 0.0117311282083392, 0.0117781320586801, 0.0118251228705049, 0.0118721993640065, 0.0119192786514759, 0.0119664864614606, 0.0120136654004455, 0.0120608592405915, 0.0121081117540598, 0.0121553922072053, 0.0122027611359954, 0.0122501431033015, 0.0122975260019302, 0.0123414425179362, 0.0123828537762165, 0.0124241914600134, 0.0124652963131666, 0.0125063881278038, 0.0125472471117973, 0.0125880176201463, 0.0126285571604967, 0.0126690678298473, 0.0127093587070704, 0.0127495778724551, 0.0127895511686802, 0.0128294508904219, 0.0128691894933581, 0.0129088275134563, 0.0129482196643949, 0.0129875959828496, 0.0130268270149827, 0.0130658252164721, 0.0131047368049622, 0.0131434742361307, 0.0131821092218161, 0.0132205560803413, 0.013258901424706, 0.0132970716804266, 0.0133351683616638, 0.0133730210363865, 0.013410828076303, 0.0134484320878983, 0.0134859196841717, 0.0135232759639621, 0.0135604729875922, 0.0135974530130625, 0.0136344023048878, 0.0136711783707142, 0.013707822188735, 0.0137442788109183, 0.0137806478887796, 0.0138168269768357, 0.013852920383215, 0.0138888098299503, 0.0139246108010411, 0.0139602534472942, 0.0139957359060645, 0.0140310721471906, 0.0140663236379623, 0.0141013842076063, 0.0141362994909286, 0.0141710843890905, 0.0142057538032532, 0.0142402481287718, 0.0142745962366462, 0.0143088009208441, 0.01434291806072, 0.014376831240952, 0.0144106419757009, 0.014444250613451, 0.0144778303802013, 0.0145111614838243, 0.0145443920046091, 0.0145774632692337, 0.0146104600280523, 0.0146432397887111, 0.0146758882328868, 0.0147083783522248, 0.0147407948970795, 0.0147730372846127, 0.0148051343858242, 0.0148370712995529, 0.014868906699121, 0.0149005530402064, 0.0149320838972926, 0.0149634536355734, 0.0149947376921773, 0.0150258028879762, 0.0150567665696144, 0.0150875840336084, 0.0151182869449258, 0.0151488138362765, 0.0151792112737894, 0.0152094475924969, 0.0152396121993661, 0.0152695309370756, 0.0152993593364954, 0.0153290452435613, 0.0153585989028215, 0.0153879942372441, 0.0154172582551837, 0.0154463611543179, 0.0154753923416138, 0.0155042055994272, 0.015532873570919, 0.0155614102259278, 0.015589889138937, 0.0156181501224637, 0.0156462229788303, 0.0156742073595524, 0.015702061355114, 0.0157297700643539, 0.0157573334872723, 0.0157835949212313, 0.015806321054697, 0.0158289298415184, 0.0158513579517603, 0.015873771160841, 0.0158959571272135, 0.0159181077033281, 0.0159401297569275, 0.0159620326012373, 0.0159837976098061, 0.0160055365413427, 0.0160270929336548, 0.0160485655069351, 0.0160699039697647, 0.0160911902785301, 0.0161122661083937, 0.0161333288997412, 0.0161542315036058, 0.0161750521510839, 0.016195721924305, 0.0162163097411394, 0.016236737370491, 0.01625713147223, 0.0162773579359055, 0.0162975266575813, 0.0163175109773874, 0.0163374543190002, 0.0163572318851948, 0.0163769405335188, 0.0163965206593275, 0.0164159834384918, 0.0164353288710117, 0.016454603523016, 0.0164737179875374, 0.0164927896112204, 0.0165116563439369, 0.0165304876863956, 0.0165491737425327, 0.0165677554905415, 0.0165861938148737, 0.0166045986115932, 0.0166228339076042, 0.0166409816592932, 0.0166589990258217, 0.0166769213974476, 0.0166947059333324, 0.0167124476283789, 0.0167299844324589, 0.0167474858462811, 0.016764834523201, 0.0167821198701859, 0.0167991984635592, 0.0168162938207388, 0.0168331637978554, 0.016849996522069, 0.0168666690587997, 0.0168832838535309, 0.0168997403234243, 0.0169161166995764, 0.0169323664158583, 0.0169485192745924, 0.0169645305722952, 0.0169804841279984, 0.0169962625950575, 0.0170119721442461, 0.0170275624841452, 0.0170430578291416, 0.0170584041625261, 0.0170736890286207, 0.0170887932181358, 0.0171038825064898, 0.0171187464147806, 0.0171335730701685, 0.0171482693403959, 0.0171628575772047, 0.0171773172914982, 0.0171917378902435, 0.0172059610486031, 0.0172201283276081, 0.0172342024743557, 0.0172480847686529, 0.0172619186341763, 0.0172755979001522, 0.0172892287373543, 0.0173026751726866, 0.0173160787671804, 0.0173293240368366, 0.0173424873501062, 0.0173554942011833, 0.0173684600740671, 0.0173812247812748, 0.0173939596861601, 0.0174065288156271, 0.0174190402030945, 0.0174313895404339, 0.0174436829984188, 0.0174557995051146, 0.0174678526818752, 0.0174797754734755, 0.0174916107207537, 0.0175056047737598, 0.0175215154886246, 0.0175374038517475, 0.0175532065331936, 0.0175689123570919, 0.0175845976918936, 0.017600180581212, 0.0176156405359507, 0.0176311023533344, 0.0176464300602674, 0.017661701887846, 0.0176769364625216, 0.0176920481026173, 0.01770712248981, 0.0177221186459064, 0.0177370049059391, 0.0177518483251333, 0.017766622826457, 0.0177812930196524, 0.0177959315478802, 0.0178104341030121, 0.0178249347954988, 0.017839340493083, 0.0178536232560873, 0.0178678911179304, 0.0178820658475161, 0.0178961381316185, 0.0179101880639791, 0.0179241467267275, 0.0179380010813475, 0.0179518032819033, 0.0179655123502016, 0.0179791990667582, 0.0179927702993155, 0.0180062558501959, 0.0180197171866894, 0.0180330704897642, 0.0180463343858719, 0.0180595647543669, 0.0180726926773787, 0.0180857423692942, 0.0180987548083067, 0.0181116424500942, 0.01812450774014, 0.0181372668594122, 0.0181499440222979, 0.0181625839322805, 0.0181751232594252, 0.0181875750422478, 0.0181999858468771, 0.0182123202830553, 0.01822454854846, 0.0182367470115423, 0.018248813226819, 0.0182608645409346, 0.0182728171348572, 0.018284672871232, 0.0182965006679296, 0.0183082483708858, 0.0183198656886816, 0.0183314830064774, 0.0183430053293705, 0.0183544047176838, 0.0183657892048359, 0.0183770637959242, 0.0183882880955935, 0.0183994248509407, 0.0184104759246111, 0.018421484157443, 0.0184324011206627, 0.0184432473033667, 0.0184540245682001, 0.0184647236019373, 0.0184753313660622, 0.0184858869761229, 0.0184963271021843, 0.0185067597776651, 0.0185170900076628, 0.0185273271054029, 0.0185375120490789, 0.0185476243495941, 0.018557658419013, 0.0185675974935293, 0.0185774993151426, 0.0185873005539179, 0.0185970421880484, 0.0186066776514053, 0.0186162870377302, 0.0186258107423782, 0.0186352133750916, 0.0186445992439985, 0.0186539068818092, 0.0186631046235561, 0.0186722502112389, 0.0186813399195671, 0.0186903197318316, 0.0186992473900318, 0.018708074465394, 0.0187168586999178, 0.018725560978055, 0.0187340565025806, 0.0187377296388149, 0.0187413934618235, 0.0187450032681227, 0.0187486056238413, 0.0187521819025278, 0.0187557209283113, 0.0187592580914497, 0.0187627300620079, 0.0187662243843079, 0.0187696758657694, 0.0187731124460697, 0.0187765061855316, 0.0187798831611872, 0.0187832247465849, 0.0187865514308214, 0.0187898725271225, 0.0187931265681982, 0.0187963955104351, 0.0187996067106724, 0.0188028179109097, 0.0188060067594051, 0.0188091471791267, 0.018812270835042, 0.0188154019415379, 0.0188184678554535, 0.0188215188682079, 0.0188245624303818, 0.018827548250556, 0.0188305415213108, 0.0188334863632917, 0.0188364274799824, 0.0188393332064152, 0.0188422109931707, 0.0188450869172812, 0.0188479050993919, 0.0188507176935673, 0.0188535004854202, 0.0188562832772732, 0.0188589785248041, 0.0188617091625929, 0.0188643746078014, 0.0188670568168163, 0.0188697073608637, 0.018872294574976, 0.0188748929649591, 0.0188774671405554, 0.0188799817115068, 0.0188824944198132, 0.018885001540184, 0.0188874509185553, 0.0188898984342813, 0.0188923086971045, 0.0188947003334761, 0.0188970752060413, 0.0188994016498327, 0.018901726230979, 0.0189040265977383, 0.0189062785357237, 0.0189085174351931, 0.0189107190817595, 0.0189129281789064, 0.0189151018857956, 0.0189172364771366, 0.0189193580299616, 0.018921472132206, 0.018923519179225, 0.0189255774021149, 0.0189275965094566, 0.0189295802265406, 0.0189315564930439, 0.0189334880560637, 0.0189354345202446, 0.0189373381435871, 0.01893918402493, 0.0189410373568535, 0.0189428813755512, 0.0189446490257978, 0.0189464427530766, 0.0189481936395168, 0.018949905410409, 0.0189516209065914, 0.0189532712101936, 0.0189549420028925, 0.0189565699547529, 0.0189581457525492, 0.0189597364515066, 0.0189613066613674, 0.0189627949148417, 0.0189643278717995, 0.0189658254384995, 0.0189672503620386, 0.0189686864614487, 0.0189700741320848, 0.0189714692533016, 0.0189728289842606, 0.0189741495996714, 0.0189754441380501, 0.0189767461270094, 0.01897800154984, 0.0189765766263008, 0.0189748555421829, 0.0189734175801277, 0.018972123041749, 0.0189709849655628, 0.0189700964838266, 0.0189693253487349, 0.0189687740057707, 0.0189683884382248, 0.0189682226628065, 0.0189682655036449, 0.0189684052020311, 0.0189688187092543, 0.0189693551510572, 0.0189701113849878, 0.0189709849655628, 0.0189721081405878, 0.0189734026789665, 0.0189748480916023, 0.0189765635877848, 0.0189783778041601, 0.0189804714173079, 0.0189826227724552, 0.0189850479364395, 0.0189876351505518, 0.0189904328435659, 0.0189933944493532, 0.0189965181052685, 0.0189998261630535, 0.0190033130347729, 0.0190070178359747, 0.0190109331160784, 0.0190149787813425, 0.019019266590476, 0.0190237052738667, 0.0190283171832561, 0.0190331153571606, 0.0190380997955799, 0.0190432630479336, 0.019048610702157, 0.0190541762858629, 0.0190599001944065, 0.0190658271312714, 0.019071888178587, 0.0190782304853201, 0.0190847329795361, 0.0190913584083319, 0.0190981719642878, 0.0191051904112101, 0.0191123746335506, 0.0191198009997606, 0.0191273484379053, 0.0191351380199194, 0.01914307102561, 0.0191512443125248, 0.0191595479846001, 0.0191680621355772, 0.0191767364740372, 0.0191855859011412, 0.0191946215927601, 0.0192038509994745, 0.0192133169621229, 0.0192229282110929, 0.0192327126860619, 0.0192427467554808, 0.0192528814077377, 0.0192632563412189, 0.0192737821489573, 0.0192844998091459, 0.0192954037338495, 0.0193064548075199, 0.019317738711834, 0.0193291716277599, 0.0193408820778131, 0.0193526614457369, 0.0193647369742393, 0.0193768534809351, 0.0193893034011126, 0.0194018464535475, 0.0194146018475294, 0.0194275639951229, 0.0194406770169735, 0.0194539707154036, 0.019467456266284, 0.0194811224937439, 0.0194950271397829, 0.0195090640336275, 0.0195233095437288, 0.0195377450436354, 0.0195523332804441, 0.0195671040564775, 0.0195820461958647, 0.019597202539444, 0.0196125470101833, 0.0196281019598246, 0.019643809646368, 0.0196597333997488, 0.0196757521480322, 0.0196920484304428, 0.0197085179388523, 0.019726624712348, 0.0197473149746656, 0.0197684708982706, 0.0197898596525192, 0.0198116842657328, 0.0198340006172657, 0.0198566094040871, 0.0198796838521957, 0.0199030488729477, 0.0199267026036978, 0.0199509393423796, 0.0199753791093826, 0.020000459626317, 0.0200256817042828, 0.0200513135641813, 0.0200774688273668, 0.0201038271188736, 0.0201306771486998, 0.0201578214764595, 0.0201855134218931, 0.0202135257422924, 0.0202418323606253, 0.0202706009149551, 0.0202996898442507, 0.0203291289508343, 0.0203590616583824, 0.0203892849385738, 0.0204200576990843, 0.0204509776085615, 0.0204823929816484, 0.0205141846090555, 0.0205463524907827, 0.0205790475010872, 0.0206118859350681, 0.0206451285630465, 0.0206789262592793, 0.0207129567861557, 0.0207474809139967, 0.0207822360098362, 0.020817544311285, 0.0208532009273767, 0.0208891779184341, 0.0209255609661341, 0.0209622923284769, 0.0209993459284306, 0.0210369471460581, 0.0210747849196196, 0.0211132038384676, 0.0211517959833145, 0.0211908239871264, 0.0212303437292576, 0.021270040422678, 0.0213102009147406, 0.0213508848100901, 0.021391773596406, 0.0214332137256861, 0.0214749146252871, 0.0215169377624989, 0.0215595085173845, 0.0216022580862045, 0.0216457024216652, 0.0216892343014479, 0.0217332318425179, 0.02177769318223, 0.0218224469572306, 0.0218676049262285, 0.0219131428748369, 0.0219590272754431, 0.0220054090023041, 0.0220520794391632, 0.0220991596579552, 0.0221465826034546, 0.02219432964921, 0.0222426559776068, 0.0222912766039371, 0.0223403591662645, 0.0223896149545908, 0.0224392767995596, 0.0224894359707832, 0.022539971396327, 0.0225908551365137, 0.0226422064006329, 0.0226937606930733, 0.0227459501475096, 0.0227982588112354, 0.0228510908782482, 0.0229042414575815, 0.0229577720165253, 0.0230117924511433, 0.0230661071836948, 0.0231208577752113, 0.023175897076726, 0.0232312846928835, 0.0232872851192951, 0.0233434569090605, 0.0234000962227583, 0.0234571695327759, 0.0235145054757595, 0.0235723070800304, 0.0236303675919771, 0.0236889123916626, 0.0237534828484058, 0.0238183457404375, 0.023883730173111, 0.0239492915570736, 0.0240152571350336, 0.0240818075835705, 0.0241485852748156, 0.0242158882319927, 0.0242834836244583, 0.0243514254689217, 0.0244199484586716, 0.0244886465370655, 0.0245579276233912, 0.0246275532990694, 0.0246974751353264, 0.0247679743915796, 0.0248387064784765, 0.0249099023640156, 0.024981452152133, 0.0250534024089575, 0.0251258201897144, 0.0251985285431147, 0.0252717602998018, 0.0253452248871326, 0.0254190973937511, 0.0254934895783663, 0.0255681741982698, 0.0256433822214603, 0.025718878954649, 0.0257947873324156, 0.0258711576461792, 0.0259476993232965, 0.0260248258709908, 0.0261023007333279, 0.0261801835149527, 0.0262584704905748, 0.0263371057808399, 0.0264161508530378, 0.0264956578612328, 0.0265755150467157, 0.026655837893486, 0.0267363917082548, 0.0268173534423113, 0.0268988981842995, 0.026980672031641, 0.0270629711449146, 0.0271455030888319, 0.0272284988313913, 0.0273119565099478, 0.0273956526070833, 0.0274799279868603, 0.0275645479559898, 0.0276494063436985, 0.0277348421514034, 0.0278205685317516, 0.0279068201780319, 0.0279933027923107, 0.028080191463232, 0.0281676631420851, 0.0282553676515818, 0.0283435340970755, 0.0284320525825024, 0.0285208616405725, 0.0286102499812841, 0.028699928894639, 0.0287900734692812, 0.0288805682212114, 0.0289714094251394, 0.0290627740323544, 0.0291544310748577, 0.0292465519160032, 0.0293389614671469, 0.0294317808002234, 0.0295251794159412, 0.0296187549829483, 0.0297129079699516, 0.0298072379082441, 0.0299020316451788, 0.0299974102526903, 0.0300929583609104, 0.0301890298724174, 0.0302853956818581, 0.0303821638226509, 0.0304794572293758, 0.0305769834667444, 0.0306749753654003, 0.0307733714580536, 0.0308721177279949, 0.0309713892638683, 0.0310709476470947, 0.0311707984656096, 0.0312711708247662, 0.031371895223856, 0.031473197042942, 0.0315746739506721, 0.0316765047609806, 0.0317789725959301, 0.0318816676735878, 0.0319847166538239, 0.0320944935083389, 0.0322052277624607, 0.0323161743581295, 0.0324272140860558, 0.0325383618474007, 0.0326497741043568, 0.0327612906694412, 0.0328729636967182, 0.0329848378896713, 0.0330967716872692, 0.0332088880240917, 0.0333211943507195, 0.0334336571395397, 0.0335462503135204, 0.0336590111255646, 0.0337719321250916, 0.0338849350810051, 0.0339981839060783, 0.0341115407645702, 0.034225095063448, 0.0343387946486473, 0.0344525799155235, 0.0345665998756886, 0.0346806906163692, 0.0347950123250484, 0.0349094942212105, 0.0350240617990494, 0.0351388491690159, 0.0352536700665951, 0.0353687778115273, 0.0354840345680714, 0.0355993285775185, 0.0357148982584476, 0.035830557346344, 0.0359463766217232, 0.03606241568923, 0.0361785404384136, 0.0362948402762413, 0.0364113412797451, 0.0365278758108616, 0.036644633859396, 0.0367615893483162, 0.0368786118924618, 0.0369959026575089, 0.0371132045984268, 0.0372307449579239, 0.0373484306037426, 0.0374662280082703, 0.0375842824578285, 0.0377024412155151, 0.0378207042813301, 0.0379391722381115, 0.0380577333271503, 0.0381765142083168, 0.0382954478263855, 0.0384144932031631, 0.0385336801409721, 0.0386531464755535, 0.0387725904583931, 0.0388922989368439, 0.0390121228992939, 0.0391321629285812, 0.0392522774636745, 0.0393725633621216, 0.0394930504262447, 0.0396136455237865, 0.0397344641387463, 0.0398553013801575, 0.0399763695895672, 0.0400975942611694, 0.0402190126478672, 0.0403405502438545, 0.0404622256755829, 0.040584072470665, 0.0407060757279396, 0.0408282242715359, 0.0409504733979702, 0.0410729348659515, 0.0411956198513508, 0.0413182899355888, 0.0414412654936314, 0.0415643565356731, 0.0416875407099724, 0.0418109409511089, 0.0419344455003738, 0.0420581474900246, 0.0421820171177387, 0.0423059873282909, 0.0424301065504551, 0.042554497718811, 0.0426788739860058, 0.0428035221993923, 0.0429282747209072, 0.0430532284080982, 0.0431783385574818, 0.0433035455644131, 0.0434289164841175, 0.043554499745369, 0.0436801128089428, 0.0438060164451599, 0.043931856751442, 0.0440530776977539, 0.0441742017865181, 0.0442951358854771, 0.0444160103797913, 0.0445367023348808, 0.0446572415530682, 0.0447776801884174, 0.0448979511857033, 0.0450181476771832, 0.0451381653547287, 0.0452580191195011, 0.045377790927887, 0.04549740254879, 0.0456168912351131, 0.0457362458109856, 0.0458554401993752, 0.045974500477314, 0.0460934638977051, 0.0462122522294521, 0.0463309362530708, 0.0464494414627552, 0.0465678386390209, 0.0466861166059971, 0.0468042157590389, 0.0469222292304039, 0.047040056437254, 0.0471577979624271, 0.0472753681242466, 0.047392800450325, 0.0475101210176945, 0.047627292573452, 0.0477443374693394, 0.0478612370789051, 0.047978013753891, 0.0480946376919746, 0.0482111647725105, 0.0483275055885315, 0.0484437122941017, 0.0485598184168339, 0.0486757680773735, 0.0487916022539139, 0.0489072762429714, 0.0490228310227394, 0.0491382256150246, 0.0492535270750523, 0.0493686608970165, 0.0494836680591106, 0.0495985336601734, 0.0497132763266563, 0.0498278737068176, 0.0499423146247864, 0.0500566810369492, 0.0501708425581455, 0.0502849295735359, 0.0503988303244114, 0.0505126416683197, 0.050626277923584, 0.0507397875189781, 0.0508531667292118, 0.0509664006531239, 0.0510795302689075, 0.0511924847960472, 0.0513053275644779, 0.051418025046587, 0.0515306144952774, 0.0516430214047432, 0.0517553240060806, 0.0518674924969673, 0.0519794970750809, 0.052091408520937, 0.0522031374275684, 0.0523147657513618, 0.0524262562394142, 0.0525375865399837, 0.0526488125324249, 0.0527598820626736, 0.052870836108923, 0.0529816262423992, 0.0530923046171665, 0.0532028190791607, 0.0533132180571556, 0.0534234866499901, 0.0535336025059223, 0.0536436215043068, 0.0537534654140472, 0.0538631826639175, 0.0539727695286274, 0.0540822260081768, 0.0541915223002434, 0.0543006844818592, 0.0544097572565079, 0.0545186512172222, 0.0546274334192276, 0.054736066609621, 0.0548445768654346, 0.0549529120326042, 0.0550611652433872, 0.0551692359149456, 0.055277194827795, 0.0553687512874603, 0.0554526783525944, 0.0555367916822433, 0.0556210242211819, 0.0557053722441196, 0.0557899214327335, 0.0558746308088303, 0.0559595450758934, 0.0560444444417953, 0.0561296083033085, 0.0562148578464985, 0.0563003085553646, 0.0563858598470688, 0.0564715713262558, 0.056557435542345, 0.056643407791853, 0.0567295849323273, 0.0568159408867359, 0.0569024384021759, 0.0569889508187771, 0.0570756793022156, 0.0571626126766205, 0.057249590754509, 0.0573368445038795, 0.0574241690337658, 0.0575116574764252, 0.0575993321835995, 0.0576871521770954, 0.0577750578522682, 0.0578631684184074, 0.0579513795673847, 0.0580397509038448, 0.0581282712519169, 0.0582169964909554, 0.0583058595657349, 0.0583948120474815, 0.0584839098155499, 0.0585730820894241, 0.0586625151336193, 0.058752067387104, 0.0588417612016201, 0.0589317306876183, 0.0590216554701328, 0.0591118037700653, 0.0592020750045776, 0.0592925511300564, 0.0593831241130829, 0.0594739504158497, 0.0595648176968098, 0.0596557930111885, 0.0597470849752426, 0.0598383955657482, 0.059929933398962, 0.0600214898586273, 0.0601132623851299, 0.0602052956819534, 0.0602973438799381, 0.0603895373642445, 0.0604819059371948, 0.0605743490159512, 0.0606669895350933, 0.0607598535716534, 0.0608527883887291, 0.0609459094703197, 0.0610391497612, 0.0611326359212399, 0.0612261705100536, 0.0613198019564152, 0.0614137500524521, 0.0615077167749405, 0.0616018585860729, 0.0616961903870106, 0.061790619045496, 0.0618852116167545, 0.0619799345731735, 0.0620748735964298, 0.0621698424220085, 0.0622649416327477, 0.0623603016138077, 0.0624559409916401, 0.0625514760613441, 0.0626472607254982, 0.0627430975437164, 0.0628391578793526, 0.062935434281826, 0.0630317851901054, 0.0631282776594162, 0.0632249563932419, 0.0633217617869377, 0.0634187459945679, 0.0635157823562622, 0.0636130720376968, 0.0637104734778404, 0.0638080164790154, 0.0639057531952858, 0.0640036314725876, 0.0641015991568565, 0.0641997158527374, 0.0642980262637138, 0.0643964558839798, 0.0645058825612068, 0.0646253749728203, 0.0647453367710114, 0.0648657605051994, 0.0649865865707397, 0.0651081204414368, 0.0652299448847771, 0.0653525218367577, 0.0654753893613815, 0.0655988901853561, 0.065722867846489, 0.0658472999930382, 0.065972313284874, 0.0660978555679321, 0.0662238076329231, 0.0663503259420395, 0.0664772689342499, 0.0666047856211662, 0.0667327642440796, 0.0668612718582153, 0.066990353167057, 0.0671197846531868, 0.0672499164938927, 0.0673803985118866, 0.0675114616751671, 0.0676429942250252, 0.0677750408649445, 0.0679076164960861, 0.0680406466126442, 0.06817427277565, 0.0683083012700081, 0.0684428364038467, 0.0685780346393585, 0.0687135085463524, 0.068849690258503, 0.068986214697361, 0.0691233724355698, 0.0692610070109367, 0.0693990513682365, 0.0695377141237259, 0.0696768015623093, 0.069816455245018, 0.069956474006176, 0.0700971856713295, 0.07023835927248, 0.0703799948096275, 0.0705221593379974, 0.0706647336483002, 0.0708079934120178, 0.0709517374634743, 0.071095809340477, 0.0712404698133469, 0.0713856592774391, 0.0715313702821732, 0.071677602827549, 0.0718242973089218, 0.0719715133309364, 0.0721191987395287, 0.0722673982381821, 0.0724161341786385, 0.072565384209156, 0.072715163230896, 0.072865404188633, 0.0730161145329475, 0.0731673315167427, 0.073319099843502, 0.0734712481498718, 0.0736241117119789, 0.0737774297595024, 0.0739311054348946, 0.0740854740142822, 0.0742401853203773, 0.0743954852223396, 0.0745513066649437, 0.0747075378894806, 0.0748643949627876, 0.0750217288732529, 0.0751795247197151, 0.0753378570079803, 0.075496643781662, 0.0756561234593391, 0.0758158341050148, 0.0759761929512024, 0.0761369466781616, 0.0762984678149223, 0.0764602720737457, 0.0766226574778557, 0.0767855122685432, 0.0769488289952278, 0.0771127268671989, 0.0772770941257477, 0.077442042529583, 0.0776074603199959, 0.0777733325958252, 0.0779397264122963, 0.078106589615345, 0.0782739818096161, 0.0784419476985931, 0.0786103755235672, 0.0787793919444084, 0.0789674073457718, 0.0791697278618813, 0.0793717503547668, 0.079573430120945, 0.0797750428318977, 0.0799763724207878, 0.0801775902509689, 0.0803784504532814, 0.0805792585015297, 0.0807798877358437, 0.0809802934527397, 0.0811804533004761, 0.0813803300261497, 0.0815801545977592, 0.0817796736955643, 0.0819790288805962, 0.082178145647049, 0.0823770388960838, 0.0825758054852486, 0.0827744081616402, 0.0829727128148079, 0.0831709131598473, 0.0833687484264374, 0.0835665315389633, 0.083764024078846, 0.0839613378047943, 0.0841584354639053, 0.0843552276492119, 0.0845521464943886, 0.0847485810518265, 0.084944911301136, 0.0851409509778023, 0.0853368788957596, 0.0855325758457184, 0.0857279747724533, 0.0859232544898987, 0.0861183106899261, 0.0863132998347282, 0.0865080058574677, 0.0867024138569832, 0.0868967175483704, 0.0870907828211784, 0.0872845575213432, 0.0874782130122185, 0.0876716896891594, 0.087865062057972, 0.0880580171942711, 0.088250920176506, 0.0884435325860977, 0.0886359140276909, 0.0888282284140587, 0.0890201404690742, 0.0892120078206062, 0.0894035696983337, 0.0895951315760612, 0.0897863507270813, 0.0899773314595222, 0.0901682004332542, 0.0903587713837624, 0.0905491188168526, 0.0907392948865891, 0.0909292846918106, 0.0911190435290337, 0.0913087576627731, 0.0914981663227081, 0.0916872397065163, 0.0918763056397438, 0.0920649543404579, 0.0922536179423332, 0.0924419835209846, 0.0926300585269928, 0.0928180292248726, 0.0930059254169464, 0.0931934863328934, 0.0933808609843254, 0.0935679525136948, 0.0937549248337746, 0.0939415469765663, 0.0941281095147133, 0.0943144485354424, 0.0945006161928177, 0.0946865975856781, 0.0948722884058952, 0.0950578674674034, 0.0952430963516235, 0.0954282060265541, 0.0956132113933563, 0.0957978591322899, 0.0959823355078697, 0.0961666330695152, 0.096350871026516, 0.0965347066521645, 0.096718430519104, 0.0969018563628197, 0.097085103392601, 0.0972681865096092, 0.0974510908126831, 0.0976337045431137, 0.0978162065148354, 0.0979985371232033, 0.0981489196419716, 0.098267488181591, 0.0983857363462448, 0.0985037758946419, 0.0986214056611061, 0.09873878210783, 0.0988558679819107, 0.0989725440740585, 0.0990891084074974, 0.0992052629590034, 0.0993210971355438, 0.0994366034865379, 0.0995518639683723, 0.0996666997671127, 0.099781297147274, 0.0998955518007278, 0.1000095307827, 0.100123293697834, 0.100236691534519, 0.100349776446819, 0.100462444126606, 0.100574865937233, 0.100687071681023, 0.100798860192299, 0.100910343229771, 0.101021580398083, 0.101132564246655, 0.101243138313293, 0.101353421807289, 0.101463414728642, 0.101573094725609, 0.101682409644127, 0.101791478693485, 0.10190013051033, 0.102008551359177, 0.10211680829525, 0.102224677801132, 0.102332144975662, 0.102439351379871, 0.102546192705631, 0.102652817964554, 0.102759070694447, 0.102865047752857, 0.102970704436302, 0.103076137602329, 0.103181160986423, 0.103285931050777, 0.10339031368494, 0.103494435548782, 0.103598296642303, 0.103701747953892, 0.103804968297482, 0.103907786309719, 0.104010514914989, 0.104112811386585, 0.104214690625668, 0.104316368699074, 0.104417733848095, 0.104518800973892, 0.10461949557066, 0.104719877243042, 0.104820013046265, 0.104919955134392, 0.105019427835941, 0.105118609964848, 0.105217471718788, 0.105316050350666, 0.105414271354675, 0.105512320995331, 0.105609931051731, 0.105707250535488, 0.10580437630415, 0.105901151895523, 0.105997510254383, 0.106093615293503, 0.106189422309399, 0.106284938752651, 0.106380090117455, 0.106474965810776, 0.106569536030293, 0.10666386038065, 0.106757842004299, 0.106851473450661, 0.106944844126701, 0.107037834823132, 0.107130505144596, 0.107222981750965, 0.107315011322498, 0.107406869530678, 0.107498466968536, 0.107589669525623, 0.107680447399616, 0.107771053910255, 0.107861317694187, 0.107951253652573, 0.108040906488895, 0.108130246400833, 0.108219251036644, 0.108308032155037, 0.108396492898464, 0.108488716185093, 0.108590312302113, 0.108692549169064, 0.108795419335365, 0.108898878097534, 0.109002850949764, 0.109107449650764, 0.10921261459589, 0.109318450093269, 0.10942480713129, 0.109531752765179, 0.109639272093773, 0.109747439622879, 0.109856240451336, 0.109965473413467, 0.110075525939465, 0.110186010599136, 0.110297076404095, 0.110408797860146, 0.110521018505096, 0.110634014010429, 0.110747396945953, 0.11086143553257, 0.110976099967957, 0.111091300845146, 0.111207127571106, 0.111323609948158, 0.111440628767014, 0.111558243632317, 0.111676432192326, 0.111795164644718, 0.111914582550526, 0.112034514546394, 0.112155184149742, 0.112276315689087, 0.112398065626621, 0.112520411610603, 0.112643323838711, 0.112766891717911, 0.112891003489494, 0.113015681505203, 0.113140985369682, 0.113266803324223, 0.113393239676952, 0.113520435988903, 0.113648101687431, 0.113776318728924, 0.113905176520348, 0.114034533500671, 0.114164590835571, 0.114295281469822, 0.114426471292973, 0.114558227360249, 0.114690631628036, 0.114823646843433, 0.114957235753536, 0.11509146541357, 0.115226209163666, 0.115361534059048, 0.115497455000877, 0.115633979439735, 0.115771234035492, 0.11590887606144, 0.11604717373848, 0.116186089813709, 0.116325505077839, 0.116465620696545, 0.116606265306473, 0.116747625172138, 0.116889454424381, 0.117031864821911, 0.117174886167049, 0.1173185557127, 0.117462784051895, 0.117607705295086, 0.117753066122532, 0.117899022996426, 0.118045657873154, 0.118192747235298, 0.118340633809566, 0.118488982319832, 0.118637904524803, 0.118787452578545, 0.118937574326992, 0.119088269770145, 0.119239643216133, 0.119391597807407, 0.119544066488743, 0.119697153568268, 0.119850814342499, 0.120005056262016, 0.120160095393658, 0.120315469801426, 0.120471492409706, 0.12062818557024, 0.120785385370255, 0.120943188667297, 0.121101699769497, 0.121260687708855, 0.121420294046402, 0.121611461043358, 0.121835634112358, 0.122059799730778, 0.122283972799778, 0.122508145868778, 0.122732140123844, 0.122956074774265, 0.123179957270622, 0.123403839766979, 0.1236277744174, 0.123851537704468, 0.12407524138689, 0.124298952519894, 0.124522484838963, 0.124746069312096, 0.124969780445099, 0.125193193554878, 0.125416606664658, 0.125639900565147, 0.125863328576088, 0.126086726784706, 0.126309856772423, 0.126533046364784, 0.12675616145134, 0.126979231834412, 0.127202287316322, 0.127425312995911, 0.127648264169693, 0.127871096134186, 0.128093868494034, 0.128316700458527, 0.128539443016052, 0.1287622153759, 0.128984853625298, 0.129207521677017, 0.129430025815964, 0.129652470350266, 0.129874885082245, 0.13009737432003, 0.130319759249687, 0.130542084574699, 0.130764245986938, 0.130986467003822, 0.131208628416061, 0.131430700421333, 0.13165283203125, 0.131874769926071, 0.132096707820892, 0.132318675518036, 0.132540479302406, 0.132762357592583, 0.132984086871147, 0.133205831050873, 0.13342747092247, 0.133649051189423, 0.13387057185173, 0.134092196822166, 0.134313702583313, 0.134535074234009, 0.13475638628006, 0.134977668523788, 0.135199069976807, 0.135420292615891, 0.135641381144524, 0.135862499475479, 0.136083588004112, 0.136304646730423, 0.136525511741638, 0.136746615171432, 0.136967346072197, 0.137188270688057, 0.137408971786499, 0.137629672884941, 0.137850284576416, 0.138070985674858, 0.138291627168655, 0.138512149453163, 0.138732567429543, 0.138953000307083, 0.139173418283463, 0.139393776655197, 0.139614090323448, 0.139834240078926, 0.14005434513092, 0.140274569392204, 0.140494614839554, 0.140714749693871, 0.140934705734253, 0.141154631972313, 0.141374483704567, 0.141594350337982, 0.141814142465591, 0.142033904790878, 0.142253562808037, 0.142473116517067, 0.142692759633064, 0.142912298440933, 0.143131822347641, 0.143351227045059, 0.143570706248283, 0.143757820129395, 0.143913671374321, 0.144068703055382, 0.144223019480705, 0.144376680254936, 0.14452962577343, 0.144681811332703, 0.144833356142044, 0.144984111189842, 0.145134165883064, 0.145283475518227, 0.145432129502296, 0.145580053329468, 0.145727261900902, 0.145873740315437, 0.14601956307888, 0.14616459608078, 0.146308973431587, 0.146452605724335, 0.146595507860184, 0.146737739443779, 0.146879196166992, 0.147019982337952, 0.147160068154335, 0.147299394011497, 0.147438049316406, 0.147575959563255, 0.147713154554367, 0.147849678993225, 0.14798541367054, 0.148120492696762, 0.148254856467247, 0.14838844537735, 0.148521408438683, 0.148653566837311, 0.148785099387169, 0.148915827274323, 0.149045899510384, 0.149175271391869, 0.149303898215294, 0.149431779980659, 0.149558961391449, 0.149685472249985, 0.1498112231493, 0.149936258792877, 0.150060623884201, 0.150184273719788, 0.150307193398476, 0.150429368019104, 0.150550827383995, 0.15067158639431, 0.15079165995121, 0.150910958647728, 0.151029601693153, 0.151147469878197, 0.151264682412148, 0.151381194591522, 0.151496931910515, 0.151611939072609, 0.151726290583611, 0.151839926838875, 0.151952832937241, 0.152065008878708, 0.152176514267921, 0.152287200093269, 0.152397274971008, 0.152506619691849, 0.152615204453468, 0.152723118662834, 0.15283028781414, 0.152936726808548, 0.153042539954185, 0.153147578239441, 0.153251856565475, 0.153355479240417, 0.1534583568573, 0.153560563921928, 0.153662011027336, 0.15376278758049, 0.153862819075584, 0.15396212041378, 0.154060751199722, 0.154158636927605, 0.154255822300911, 0.154352307319641, 0.15444803237915, 0.154543057084084, 0.154637411236763, 0.154731005430222, 0.154823899269104, 0.154916048049927, 0.155007541179657, 0.155098304152489, 0.155188322067261, 0.155277594923973, 0.155366197228432, 0.155454099178314, 0.155541300773621, 0.155627712607384, 0.155713453888893, 0.155793502926826, 0.155865699052811, 0.15593808889389, 0.156010568141937, 0.156083181500435, 0.156155943870544, 0.156228840351105, 0.156301900744438, 0.1563750654459, 0.156448423862457, 0.156521841883659, 0.156595408916473, 0.156669124960899, 0.156742975115776, 0.156816929578781, 0.156891092658043, 0.156965330243111, 0.157039746642113, 0.157114252448082, 0.157188922166824, 0.157263696193695, 0.1573386490345, 0.157413676381111, 0.157488957047462, 0.157564252614975, 0.157639771699905, 0.157715305685997, 0.157791122794151, 0.157866969704628, 0.157943025231361, 0.15801914036274, 0.158095449209213, 0.158171877264977, 0.158248469233513, 0.158325061202049, 0.158401966094971, 0.158478885889053, 0.158556059002876, 0.158633351325989, 0.15871062874794, 0.158788219094276, 0.158865809440613, 0.158943623304367, 0.159021496772766, 0.159099593758583, 0.159177765250206, 0.159256100654602, 0.159334525465965, 0.159413188695908, 0.159491866827011, 0.159570723772049, 0.159649699926376, 0.159728899598122, 0.159808158874512, 0.159887582063675, 0.159967079758644, 0.160046800971031, 0.160126566886902, 0.160206541419029, 0.160286605358124, 0.160366833209991, 0.160447150468826, 0.160527721047401, 0.160608321428299, 0.16068908572197, 0.160769954323769, 0.160851031541824, 0.160932183265686, 0.161013498902321, 0.1610948741436, 0.161176517605782, 0.161258235573769, 0.161340057849884, 0.161422103643417, 0.161504179239273, 0.161586448550224, 0.161668807268143, 0.161751374602318, 0.161834001541138, 0.161916822195053, 0.161999717354774, 0.162082821130753, 0.162165984511375, 0.162249356508255, 0.162332803010941, 0.162416458129883, 0.162500157952309, 0.162584096193314, 0.16266804933548, 0.162752270698547, 0.162836492061615, 0.162920936942101, 0.163005456328392, 0.163090214133263, 0.163174986839294, 0.163259983062744, 0.163345053792, 0.163430318236351, 0.163515672087669, 0.163601219654083, 0.163706496357918, 0.163824155926704, 0.163942515850067, 0.164061367511749, 0.164180904626846, 0.164301037788391, 0.164421826601028, 0.164543151855469, 0.16466523706913, 0.164787799119949, 0.164911046624184, 0.165034860372543, 0.165159314870834, 0.165284350514412, 0.165410086512566, 0.1655363291502, 0.165663287043571, 0.16579082608223, 0.165918990969658, 0.166047722101212, 0.166177153587341, 0.16630719602108, 0.166437789797783, 0.166568979620934, 0.166700854897499, 0.166833341121674, 0.166966408491135, 0.167100071907043, 0.167234405875206, 0.167369335889816, 0.167504891753197, 0.167641088366508, 0.167777821421623, 0.167915225028992, 0.168053224682808, 0.168191879987717, 0.16833108663559, 0.168470948934555, 0.168611437082291, 0.168752536177635, 0.168894231319427, 0.169036537408829, 0.169179499149323, 0.169323027133942, 0.169467255473137, 0.169612050056458, 0.169757425785065, 0.169903457164764, 0.170050084590912, 0.170197337865829, 0.170345187187195, 0.170493707060814, 0.170642822980881, 0.170792549848557, 0.170942887663841, 0.171093821525574, 0.171245351433754, 0.171397566795349, 0.171550378203392, 0.171703770756721, 0.171857759356499, 0.172012448310852, 0.172167748212814, 0.17232358455658, 0.172480091452599, 0.172637194395065, 0.172794908285141, 0.172953262925148, 0.173112213611603, 0.173271834850311, 0.173431992530823, 0.173592805862427, 0.173754215240479, 0.173916280269623, 0.174078911542892, 0.174242213368416, 0.174406096339226, 0.174570620059967, 0.174735724925995, 0.174901455640793, 0.1750677973032, 0.175234749913216, 0.175402358174324, 0.17557056248188, 0.175739407539368, 0.175908818840981, 0.176078915596008, 0.176249548792839, 0.176420837640762, 0.176592722535133, 0.176765233278275, 0.176938369870186, 0.177112102508545, 0.177286505699158, 0.177461445331573, 0.177637055516243, 0.17781326174736, 0.17799012362957, 0.178167566657066, 0.178345635533333, 0.17852957546711, 0.178718373179436, 0.178907454013824, 0.179096788167953, 0.179286390542984, 0.179476261138916, 0.179666474461555, 0.179856911301613, 0.180047586560249, 0.180238574743271, 0.180429816246033, 0.180621340870857, 0.180813103914261, 0.181005150079727, 0.181197479367256, 0.18139012157917, 0.181582987308502, 0.181776136159897, 0.181969523429871, 0.182163208723068, 0.182357206940651, 0.18255141377449, 0.182745918631554, 0.182940647006035, 0.183135688304901, 0.183331027626991, 0.183526605367661, 0.18372243642807, 0.183918580412865, 0.1841149777174, 0.184311658143997, 0.184508591890335, 0.184705808758736, 0.184903293848038, 0.185101002454758, 0.185299038887024, 0.18549732863903, 0.185695916414261, 0.18589474260807, 0.186093851923943, 0.186293229460716, 0.186492890119553, 0.18669281899929, 0.186892971396446, 0.187093451619148, 0.187294170260429, 0.187495172023773, 0.18769645690918, 0.187898010015488, 0.188099831342697, 0.188301920890808, 0.188504278659821, 0.188706919550896, 0.188909813761711, 0.189112976193428, 0.189316406846046, 0.189520135521889, 0.189724117517471, 0.189928382635117, 0.190132901072502, 0.190337717533112, 0.190542817115784, 0.190748125314713, 0.190953761339188, 0.191159635782242, 0.191365778446198, 0.191572204232216, 0.191778883337975, 0.191985875368118, 0.192193105816841, 0.192400634288788, 0.192608416080475, 0.192816495895386, 0.193024799227715, 0.193233385682106, 0.193442270159721, 0.193651393055916, 0.193860784173012, 0.194070473313332, 0.194280445575714, 0.194490641355515, 0.194701164960861, 0.194911897182465, 0.195122942328453, 0.195334270596504, 0.195545837283134, 0.195757687091827, 0.195969820022583, 0.196182176470757, 0.196394830942154, 0.196607783436775, 0.196820989251137, 0.197034448385239, 0.197248205542564, 0.197462230920792, 0.19767652451992, 0.197891086339951, 0.198105931282043, 0.198321044445038, 0.198536366224289, 0.198756843805313, 0.198987916111946, 0.199218392372131, 0.19944828748703, 0.19967757165432, 0.199906304478645, 0.200134411454201, 0.20036193728447, 0.200588896870613, 0.200815185904503, 0.201040983200073, 0.201266139745712, 0.201490685343742, 0.201714694499969, 0.201938048005104, 0.202160879969597, 0.202383056282997, 0.202604681253433, 0.20282569527626, 0.203046143054962, 0.203265935182571, 0.203485205769539, 0.203703865408897, 0.203921929001808, 0.204139396548271, 0.204356268048286, 0.204572558403015, 0.204788267612457, 0.20500336587429, 0.205217868089676, 0.205431774258614, 0.205645143985748, 0.20585785806179, 0.20607003569603, 0.206281557679176, 0.206492528319359, 0.206702902913094, 0.206912711262703, 0.207121893763542, 0.207330480217934, 0.207538485527039, 0.207745924592018, 0.207952737808228, 0.208158954977989, 0.208364605903625, 0.208569660782814, 0.208774119615555, 0.208977997303009, 0.209181234240532, 0.209383949637413, 0.209586024284363, 0.20978756248951, 0.209988430142403, 0.210188746452332, 0.210388496518135, 0.21058763563633, 0.210786163806915, 0.210984110832214, 0.211181476712227, 0.211378261446953, 0.211574420332909, 0.211770012974739, 0.211964994668961, 0.212159410119057, 0.212353244423866, 0.212546437978745, 0.212739080190659, 0.212931111454964, 0.21312253177166, 0.213313415646553, 0.213503658771515, 0.213693365454674, 0.21388241648674, 0.21407088637352, 0.214258804917336, 0.214446112513542, 0.214632794260979, 0.214818954467773, 0.215004473924637, 0.215189442038536, 0.215373769402504, 0.215557530522346, 0.215740710496902, 0.215923249721527, 0.216105252504349, 0.216286644339561, 0.216467410326004, 0.216647654771805, 0.216827258467674, 0.21700631082058, 0.217184707522392, 0.21736253798008, 0.217539802193642, 0.217716470360756, 0.217892542481422, 0.21806800365448, 0.218242883682251, 0.218417197465897, 0.218590870499611, 0.2187639772892, 0.218912616372108, 0.219039261341095, 0.219165071845055, 0.219289988279343, 0.219414010643959, 0.219537183642387, 0.219659462571144, 0.219780921936035, 0.219901442527771, 0.220021098852158, 0.220139905810356, 0.220257818698883, 0.220374867320061, 0.220491021871567, 0.220606312155724, 0.22072072327137, 0.220834285020828, 0.220946952700615, 0.221058756113052, 0.221169650554657, 0.221279725432396, 0.221388876438141, 0.221497192978859, 0.221604600548744, 0.221711114048958, 0.221816793084145, 0.221921592950821, 0.222025528550148, 0.222128540277481, 0.222230717539787, 0.222332030534744, 0.22243244946003, 0.222531974315643, 0.222630649805069, 0.222728431224823, 0.22282537817955, 0.222921416163445, 0.223016574978828, 0.223110884428024, 0.223204270005226, 0.223296850919724, 0.223388507962227, 0.223479270935059, 0.223569229245186, 0.223658248782158, 0.223746463656425, 0.223833724856377, 0.223920151591301, 0.224005714058876, 0.224090382456779, 0.224174201488495, 0.224257081747055, 0.224339127540588, 0.224420309066772, 0.224500611424446, 0.224580019712448, 0.224658578634262, 0.224736243486404, 0.224813044071198, 0.224888980388641, 0.224963992834091, 0.225038170814514, 0.225111454725266, 0.225183919072151, 0.225255444645882, 0.225326105952263, 0.225395902991295, 0.225464850664139, 0.225532904267311, 0.225600063800812, 0.225666344165802, 0.225731804966927, 0.225796341896057, 0.225860029459, 0.225922808051109, 0.22598472237587, 0.226045772433281, 0.226105943322182, 0.226165249943733, 0.226223662495613, 0.226281210780144, 0.226337924599648, 0.226393699645996, 0.226448640227318, 0.226502656936646, 0.226555839180946, 0.226608157157898, 0.226659551262856, 0.226710096001625, 0.226759791374207, 0.226808562874794, 0.226856514811516, 0.226903572678566, 0.226949736475945, 0.226995036005974, 0.227039471268654, 0.227083027362823, 0.227125689387321, 0.227167472243309, 0.22720842063427, 0.227246418595314, 0.227280765771866, 0.227314978837967, 0.227349042892456, 0.227382943034172, 0.227416723966599, 0.227450326085091, 0.227483808994293, 0.227517127990723, 0.22755029797554, 0.227583333849907, 0.227616205811501, 0.227648928761482, 0.227681502699852, 0.227713957428932, 0.227746248245239, 0.227778375148773, 0.227810367941856, 0.227842211723328, 0.227873906493187, 0.227905452251434, 0.22793684899807, 0.227968096733093, 0.227999195456505, 0.228030160069466, 0.228060960769653, 0.228091612458229, 0.228122115135193, 0.228152513504028, 0.228182718157768, 0.228212803602219, 0.228242695331573, 0.2282724827528, 0.228302106261253, 0.228331565856934, 0.228360906243324, 0.228390112519264, 0.228419125080109, 0.228448003530502, 0.228476747870445, 0.228505343198776, 0.228533774614334, 0.228562086820602, 0.228590235114098, 0.22861821949482, 0.22864605486393, 0.22867377102375, 0.228701323270798, 0.228728741407394, 0.228755995631218, 0.228783115744591, 0.22881007194519, 0.228836879134178, 0.228863552212715, 0.228890061378479, 0.228916451334953, 0.228942662477493, 0.228968739509583, 0.228994682431221, 0.229020446538925, 0.229046076536179, 0.22907155752182, 0.22909688949585, 0.229122072458267, 0.229147136211395, 0.229172021150589, 0.229196771979332, 0.229221358895302, 0.229245811700821, 0.229270115494728, 0.229294270277023, 0.229318290948868, 0.229342147707939, 0.229365840554237, 0.229389414191246, 0.22941280901432, 0.229436099529266, 0.229459211230278, 0.229482159018517, 0.229504987597466, 0.229527682065964, 0.229550212621689, 0.229572579264641, 0.229594811797142, 0.22961688041687, 0.229638829827309, 0.229660600423813, 0.229682251811028, 0.229703739285469, 0.22972509264946, 0.229746267199516, 0.229767337441444, 0.229788228869438, 0.229808986186981, 0.229829594492912, 0.22985003888607, 0.2298703789711, 0.229890525341034, 0.229910537600517, 0.229930385947227, 0.229968026280403, 0.230022236704826, 0.230076476931572, 0.230130702257156, 0.23018491268158, 0.230239123106003, 0.230293363332748, 0.230347573757172, 0.230401784181595, 0.230456009507179, 0.230510234832764, 0.230564460158348, 0.230618670582771, 0.230672910809517, 0.23072712123394, 0.230781331658363, 0.230835556983948, 0.230889797210693, 0.230944007635117, 0.230998232960701, 0.231052443385124, 0.231106668710709, 0.231160879135132, 0.231215104460716, 0.231269329786301, 0.231323555111885, 0.231377765536308, 0.231431975960732, 0.231486186385155, 0.2315404266119, 0.231594651937485, 0.23164889216423, 0.231703087687492, 0.231757313013077, 0.2318115234375, 0.231865763664246, 0.231919974088669, 0.231974199414253, 0.232028409838676, 0.2320826202631, 0.232136860489845, 0.232191070914268, 0.232245281338692, 0.232299506664276, 0.232353746891022, 0.232407957315445, 0.232462167739868, 0.232516393065453, 0.232570618391037, 0.23262482881546, 0.232679054141045, 0.23273329436779, 0.232787504792213, 0.232841715216637, 0.232895940542221, 0.232950150966644, 0.23300439119339, 0.233058601617813, 0.233112826943398, 0.233167052268982, 0.233221262693405, 0.233275473117828, 0.233329713344574, 0.233383938670158, 0.233438149094582, 0.233492359519005, 0.233546584844589, 0.233600810170174, 0.233655020594597, 0.23370923101902, 0.233763471245766, 0.23381769657135, 0.233871906995773, 0.233926132321358, 0.233980357646942, 0.234034568071365, 0.23408879339695, 0.234143003821373, 0.234197244048119, 0.234251454472542, 0.234305664896965, 0.234359890222549, 0.234414115548134, 0.234468340873718, 0.234522551298141, 0.234576791524887, 0.23463100194931, 0.234685212373734, 0.234739422798157, 0.234793648123741, 0.234847888350487, 0.23490209877491, 0.234956324100494, 0.235010534524918, 0.235064759850502, 0.235118970274925, 0.235173210501671, 0.235227420926094, 0.235281646251678, 0.235335856676102, 0.235373318195343, 0.235393166542053, 0.235413178801537, 0.235433325171471, 0.235453635454178, 0.235474094748497, 0.235494703054428, 0.235515460371971, 0.235536351799965, 0.235557422041893, 0.235578611493111, 0.235599935054779, 0.235621437430382, 0.235643073916435, 0.235664859414101, 0.235686793923378, 0.235708877444267, 0.235731109976768, 0.235753491520882, 0.235776007175446, 0.235798671841621, 0.23582150042057, 0.23584446310997, 0.235867589712143, 0.235890865325928, 0.235914260149002, 0.23593781888485, 0.23596154153347, 0.23598538339138, 0.236009389162064, 0.236033543944359, 0.236057862639427, 0.236082300543785, 0.236106887459755, 0.236131638288498, 0.236156538128853, 0.236181572079659, 0.236206769943237, 0.236232087016106, 0.23625759780407, 0.236283212900162, 0.236308991909027, 0.236334905028343, 0.236360996961594, 0.236387223005295, 0.236413583159447, 0.236440092325211, 0.236466765403748, 0.236493572592735, 0.236520528793335, 0.236547663807869, 0.236574918031693, 0.236602321267128, 0.236629858613014, 0.236657559871674, 0.236685425043106, 0.236713439226151, 0.236741557717323, 0.23676985502243, 0.236798301339149, 0.236826881766319, 0.236855611205101, 0.236884489655495, 0.236913532018661, 0.236942708492279, 0.23697204887867, 0.237001523375511, 0.237031131982803, 0.23706091940403, 0.237090826034546, 0.237120896577835, 0.237151101231575, 0.237181484699249, 0.237212002277374, 0.23724265396595, 0.237273454666138, 0.237304419279099, 0.237335503101349, 0.237366750836372, 0.237398162484169, 0.237429693341255, 0.237461403012276, 0.237493231892586, 0.23752523958683, 0.237557366490364, 0.237589657306671, 0.237622082233429, 0.237654656171799, 0.237687394022942, 0.237720280885696, 0.237753301858902, 0.237786456942558, 0.237819775938988, 0.23785325884819, 0.237886860966682, 0.237920626997948, 0.237954542040825, 0.237988606095314, 0.238022804260254, 0.238057166337967, 0.238093808293343, 0.238133132457733, 0.238173335790634, 0.23821447789669, 0.238256514072418, 0.23829947412014, 0.238343298435211, 0.238388061523438, 0.238433733582497, 0.238480299711227, 0.238527789711952, 0.23857618868351, 0.2386254966259, 0.238675698637962, 0.238726809620857, 0.238778829574585, 0.238831758499146, 0.2388856112957, 0.238940343260765, 0.238995984196663, 0.239052549004555, 0.239110007882118, 0.239168405532837, 0.239227667450905, 0.239287868142128, 0.239348977804184, 0.239410981535912, 0.239473879337311, 0.239537715911865, 0.23960243165493, 0.23966808617115, 0.239734634757042, 0.239802077412605, 0.239870443940163, 0.239939719438553, 0.240009889006615, 0.240080967545509, 0.240152969956398, 0.24022588133812, 0.240299671888351, 0.240374371409416, 0.240450009703636, 0.240526542067528, 0.240603983402252, 0.240682318806648, 0.240761578083038, 0.240841746330261, 0.240922823548317, 0.241004809737206, 0.241087689995766, 0.241171464323997, 0.241256177425385, 0.241341799497604, 0.241428300738335, 0.241515725851059, 0.241604059934616, 0.241693302989006, 0.241783455014229, 0.241874501109123, 0.24196645617485, 0.242059364914894, 0.242153137922287, 0.242247804999352, 0.24234339594841, 0.242439895868301, 0.242537319660187, 0.242635637521744, 0.242734849452972, 0.242835000157356, 0.242936030030251, 0.243037968873978, 0.24314084649086, 0.243244603276253, 0.243349269032478, 0.243454858660698, 0.243561342358589, 0.243668735027313, 0.243777051568031, 0.24388624727726, 0.243996366858482, 0.244107410311699, 0.244219332933426, 0.244332164525986, 0.24444591999054, 0.244560569524765, 0.244676157832146, 0.244792625308037, 0.244910001754761, 0.245028302073479, 0.245147481560707, 0.24526758491993, 0.245388612151146, 0.245510518550873, 0.245633363723755, 0.245757102966309, 0.245881736278534, 0.246007278561592, 0.246133744716644, 0.246261104941368, 0.246389389038086, 0.246547818183899, 0.246736243367195, 0.246925085783005, 0.24711437523365, 0.247304037213326, 0.247494131326675, 0.247684612870216, 0.247875541448593, 0.248066842556, 0.248258590698242, 0.248450741171837, 0.248643338680267, 0.248836293816566, 0.24902968108654, 0.249223470687866, 0.249417677521706, 0.249612331390381, 0.249807372689247, 0.250002831220627, 0.250198692083359, 0.250394970178604, 0.250591665506363, 0.250788778066635, 0.250986307859421, 0.251184195280075, 0.251382559537888, 0.251581341028214, 0.25178050994873, 0.251980066299438, 0.252180099487305, 0.25238049030304, 0.252581268548965, 0.25278252363205, 0.252984166145325, 0.253186225891113, 0.253388702869415, 0.253591567277908, 0.253794878721237, 0.253998607397079, 0.254202723503113, 0.25440725684166, 0.254612237215042, 0.254817575216293, 0.25502336025238, 0.255229532718658, 0.25543612241745, 0.255643159151077, 0.255850553512573, 0.256058394908905, 0.25626665353775, 0.256475329399109, 0.256684392690659, 0.256893903017044, 0.257103770971298, 0.257314115762711, 0.257524847984314, 0.257735967636108, 0.257947534322739, 0.258159518241882, 0.258371829986572, 0.258584678173065, 0.258797913789749, 0.259011507034302, 0.259225517511368, 0.25943997502327, 0.259654849767685, 0.259870111942291, 0.260085761547089, 0.260301828384399, 0.260518342256546, 0.260735303163528, 0.26095262169838, 0.261170387268066, 0.261388540267944, 0.261607080698013, 0.26182609796524, 0.262045472860336, 0.262265294790268, 0.262485533952713, 0.262706130743027, 0.262927204370499, 0.263148665428162, 0.263370543718338, 0.263592809438705, 0.263815551996231, 0.264038622379303, 0.264262169599533, 0.264486074447632, 0.264710456132889, 0.264935225248337, 0.265160381793976, 0.265385955572128, 0.265611976385117, 0.265838414430618, 0.266065210103989, 0.266292482614517, 0.266520112752914, 0.266748189926147, 0.266976654529572, 0.267205536365509, 0.267429530620575, 0.267647624015808, 0.267864644527435, 0.268080621957779, 0.268295526504517, 0.268509387969971, 0.268722176551819, 0.268933922052383, 0.269144624471664, 0.269354254007339, 0.269562870264053, 0.269770383834839, 0.269976824522018, 0.270182251930237, 0.270386606454849, 0.270589917898178, 0.270792186260223, 0.270993381738663, 0.271193504333496, 0.271392613649368, 0.271590620279312, 0.271787583827972, 0.271983474493027, 0.27217835187912, 0.272372156381607, 0.272564888000488, 0.272756606340408, 0.2729472219944, 0.273136794567108, 0.273325324058533, 0.273512810468674, 0.273699194192886, 0.27388459444046, 0.274068892002106, 0.274252146482468, 0.274434298276901, 0.274615436792374, 0.274795562028885, 0.274974554777145, 0.275152534246445, 0.275329440832138, 0.275505304336548, 0.275680094957352, 0.27585381269455, 0.276026517152786, 0.276198148727417, 0.276368737220764, 0.276538282632828, 0.276706755161285, 0.276874125003815, 0.277040511369705, 0.27720582485199, 0.277370005846024, 0.277533233165741, 0.27769535779953, 0.277856439352036, 0.278016477823257, 0.278175443410873, 0.278333336114883, 0.27849018573761, 0.278646022081375, 0.278800755739212, 0.278954446315765, 0.27910703420639, 0.279258638620377, 0.279409170150757, 0.279558628797531, 0.279707044363022, 0.279854416847229, 0.280000686645508, 0.280145943164825, 0.280290156602859, 0.280433237552643, 0.28057536482811, 0.280716359615326, 0.280856311321259, 0.280995219945908, 0.281133055686951, 0.281269907951355, 0.281405627727509, 0.281540334224701, 0.281673938035965, 0.28180655837059, 0.281938046216965, 0.282068520784378, 0.282197922468185, 0.282326281070709, 0.282453566789627, 0.282579809427261, 0.28270497918129, 0.282829135656357, 0.282952189445496, 0.283074259757996, 0.283195197582245, 0.283315122127533, 0.283433943986893, 0.283551752567291, 0.283668488264084, 0.283784180879593, 0.283898800611496, 0.283984005451202, 0.284039735794067, 0.284094244241714, 0.284147560596466, 0.284199714660645, 0.284250676631927, 0.284300416707993, 0.284348994493484, 0.284396409988403, 0.284442633390427, 0.284487634897232, 0.284531444311142, 0.284574091434479, 0.28461554646492, 0.284655809402466, 0.284694910049438, 0.284732818603516, 0.284769535064697, 0.284805029630661, 0.284839391708374, 0.284872531890869, 0.284904479980469, 0.284935235977173, 0.284964829683304, 0.284993231296539, 0.285020440816879, 0.285046488046646, 0.285071343183517, 0.285094946622849, 0.285117417573929, 0.285138726234436, 0.285158783197403, 0.285177707672119, 0.285195410251617, 0.285211950540543, 0.285227298736572, 0.285241425037384, 0.285254418849945, 0.285266160964966, 0.285276770591736, 0.28528618812561, 0.285294413566589, 0.28530141711235, 0.285307258367538, 0.285311937332153, 0.285315424203873, 0.285317659378052, 0.285318821668625, 0.285318702459335, 0.285317420959473, 0.285314947366714, 0.285311311483383, 0.285306483507156, 0.285300463438034, 0.285293251276016, 0.285284817218781, 0.285275250673294, 0.285264492034912, 0.285252511501312, 0.285239368677139, 0.285225003957748, 0.285209476947784, 0.285192787647247, 0.285174876451492, 0.285155802965164, 0.285135537385941, 0.285114079713821, 0.285091429948807, 0.285067617893219, 0.285042583942413, 0.285016357898712, 0.28498899936676, 0.28496041893959, 0.284930616617203, 0.284899711608887, 0.28486755490303, 0.284834206104279, 0.284799695014954, 0.284763991832733, 0.284727096557617, 0.284689009189606, 0.284649789333344, 0.284609287977219, 0.284567654132843, 0.284524857997894, 0.284480839967728, 0.284435659646988, 0.28438925743103, 0.284341663122177, 0.284292936325073, 0.284242987632751, 0.284191846847534, 0.284139513969421, 0.284085988998413, 0.284031301736832, 0.283975422382355, 0.283918380737305, 0.283860087394714, 0.283800661563873, 0.283740013837814, 0.283674627542496, 0.283605366945267, 0.283536076545715, 0.283466726541519, 0.283397436141968, 0.283328026533127, 0.283258587121964, 0.283189117908478, 0.283119589090347, 0.283050060272217, 0.282980442047119, 0.282910823822021, 0.282841205596924, 0.282771468162537, 0.282701760530472, 0.282632023096085, 0.282562226057053, 0.282492369413376, 0.282422512769699, 0.282352596521378, 0.282282590866089, 0.282212615013123, 0.282142579555511, 0.2820725440979, 0.282002449035645, 0.281932294368744, 0.281862139701843, 0.281791925430298, 0.28172168135643, 0.28165140748024, 0.281581103801727, 0.281510680913925, 0.281440287828445, 0.281369894742966, 0.281299442052841, 0.281228929758072, 0.281158357858658, 0.281087756156921, 0.281017184257507, 0.280946522951126, 0.280875831842422, 0.280805110931396, 0.280734330415726, 0.280663549900055, 0.280592679977417, 0.280521810054779, 0.280450910329819, 0.280379980802536, 0.280308991670609, 0.280237972736359, 0.280166894197464, 0.280095785856247, 0.280024617910385, 0.279953479766846, 0.279882282018661, 0.279811024665833, 0.279739737510681, 0.279668420553207, 0.279597073793411, 0.279525697231293, 0.279454261064529, 0.279382765293121, 0.279311269521713, 0.27923971414566, 0.279168158769608, 0.27909654378891, 0.279024928808212, 0.278953194618225, 0.278881460428238, 0.278809756040573, 0.278737902641296, 0.278666079044342, 0.278594225645065, 0.278522282838821, 0.2784503698349, 0.278378337621689, 0.278306305408478, 0.278234302997589, 0.278162181377411, 0.278090059757233, 0.278017848730087, 0.277945667505264, 0.277873426675797, 0.277801126241684, 0.277728796005249, 0.277656495571136, 0.277584105730057, 0.277511656284332, 0.277439206838608, 0.277366697788239, 0.277294158935547, 0.277221590280533, 0.277148962020874, 0.277076333761215, 0.277003645896912, 0.276930898427963, 0.276858150959015, 0.276785343885422, 0.276712477207184, 0.276639610528946, 0.276592820882797, 0.276572167873383, 0.276551783084869, 0.276531547307968, 0.276511579751968, 0.276491850614548, 0.276472330093384, 0.276453047990799, 0.276433944702148, 0.276415079832077, 0.276396423578262, 0.276377975940704, 0.276359766721725, 0.276341795921326, 0.276324033737183, 0.276306450366974, 0.276289135217667, 0.276272058486938, 0.276255130767822, 0.276238471269608, 0.276221990585327, 0.276205807924271, 0.276189774274826, 0.276173979043961, 0.276158422231674, 0.276143044233322, 0.276127934455872, 0.276113033294678, 0.276098340749741, 0.276083827018738, 0.276069581508636, 0.276055544614792, 0.276041716337204, 0.276028156280518, 0.276014775037766, 0.27600160241127, 0.275988698005676, 0.275975972414017, 0.275963485240936, 0.275951206684113, 0.275939136743546, 0.275927275419235, 0.275915652513504, 0.275904297828674, 0.275893092155457, 0.27588215470314, 0.275871396064758, 0.275860905647278, 0.275850623846054, 0.275840520858765, 0.275830686092377, 0.275821059942245, 0.275811642408371, 0.275802433490753, 0.275793433189392, 0.27578467130661, 0.275776118040085, 0.275767832994461, 0.275759696960449, 0.275751829147339, 0.275744169950485, 0.275736749172211, 0.27572950720787, 0.275722533464432, 0.275715708732605, 0.27570915222168, 0.275702804327011, 0.275696694850922, 0.275690823793411, 0.275685101747513, 0.275679647922516, 0.275674372911453, 0.275669395923615, 0.27566459774971, 0.275660008192062, 0.275655657052994, 0.275651484727859, 0.275647550821304, 0.275643885135651, 0.275640398263931, 0.275637120008469, 0.275634080171585, 0.275631248950958, 0.275628656148911, 0.275626242160797, 0.275624096393585, 0.275622129440308, 0.275620400905609, 0.275618880987167, 0.275617599487305, 0.275616556406021, 0.275615692138672, 0.275615066289902, 0.275614649057388, 0.275614470243454, 0.275614500045776, 0.275614768266678, 0.275615245103836, 0.275615900754929, 0.2756167948246, 0.275615185499191, 0.275610238313675, 0.275604784488678, 0.27559894323349, 0.275592625141144, 0.275585830211639, 0.275578588247299, 0.275570899248123, 0.275562763214111, 0.275554239749908, 0.27554515004158, 0.275535702705383, 0.275525748729706, 0.275515347719193, 0.275504529476166, 0.275493204593658, 0.275481462478638, 0.275469273328781, 0.275456637144089, 0.275443524122238, 0.275429934263229, 0.27541595697403, 0.275401473045349, 0.275386601686478, 0.275371193885803, 0.27535542845726, 0.275339156389236, 0.275322437286377, 0.275305241346359, 0.275287657976151, 0.275269567966461, 0.275251030921936, 0.275232046842575, 0.275212645530701, 0.275192737579346, 0.275172412395477, 0.275151640176773, 0.275130391120911, 0.275108695030212, 0.275086551904678, 0.275063961744308, 0.275040954351425, 0.275017470121384, 0.274993509054184, 0.274969100952148, 0.274944216012955, 0.27491894364357, 0.274893194437027, 0.274866968393326, 0.274840325117111, 0.274813205003738, 0.274785667657852, 0.274757653474808, 0.274729192256927, 0.274700254201889, 0.274670869112015, 0.274641036987305, 0.274610787630081, 0.274580091238022, 0.274548888206482, 0.274517267942429, 0.274485200643539, 0.274452656507492, 0.274419665336609, 0.27438622713089, 0.274352341890335, 0.274318009614944, 0.274283200502396, 0.274247974157333, 0.274212270975113, 0.274176150560379, 0.274139523506165, 0.274102479219437, 0.274064987897873, 0.274027049541473, 0.273988634347916, 0.2739497423172, 0.273910462856293, 0.273870676755905, 0.273830503225327, 0.273789823055267, 0.273748695850372, 0.273707151412964, 0.273665130138397, 0.273622632026672, 0.273579716682434, 0.273536324501038, 0.273492515087128, 0.27344822883606, 0.273403525352478, 0.273358345031738, 0.27331268787384, 0.273266583681107, 0.273220062255859, 0.273173093795776, 0.273125618696213, 0.273077726364136, 0.273029386997223, 0.272980600595474, 0.272931337356567, 0.272858768701553, 0.272763162851334, 0.272667437791824, 0.27257165312767, 0.272475779056549, 0.272379815578461, 0.272283762693405, 0.272187560796738, 0.272091329097748, 0.271994978189468, 0.271898508071899, 0.271802008152008, 0.271705359220505, 0.271608620882034, 0.271511822938919, 0.271414875984192, 0.27131786942482, 0.271220773458481, 0.271123558282852, 0.271026283502579, 0.270928889513016, 0.270831376314163, 0.270733833312988, 0.270636141300201, 0.27053838968277, 0.270440518856049, 0.270342528820038, 0.270244479179382, 0.270146369934082, 0.270048141479492, 0.269949793815613, 0.269851386547089, 0.269752830266953, 0.269654214382172, 0.269555509090424, 0.269456684589386, 0.269357800483704, 0.269258767366409, 0.269159734249115, 0.269060522317886, 0.268961220979691, 0.26886186003685, 0.26876237988472, 0.268662840127945, 0.26856318116188, 0.268463462591171, 0.26836359500885, 0.268263638019562, 0.268163621425629, 0.268063485622406, 0.267963260412216, 0.267862915992737, 0.267762511968613, 0.267661988735199, 0.267561376094818, 0.267460733652115, 0.267359912395477, 0.267259031534195, 0.267158031463623, 0.267057001590729, 0.2669557929039, 0.266854554414749, 0.266753196716309, 0.266651719808578, 0.266550183296204, 0.266448557376862, 0.26634681224823, 0.266245007514954, 0.266143053770065, 0.266041040420532, 0.265938937664032, 0.265836715698242, 0.265734404325485, 0.265632003545761, 0.265529543161392, 0.265426933765411, 0.265324264764786, 0.265221476554871, 0.265118598937988, 0.265015631914139, 0.264912575483322, 0.264809429645538, 0.264706164598465, 0.264602869749069, 0.264499396085739, 0.264395892620087, 0.264292240142822, 0.264188528060913, 0.264084726572037, 0.263980835676193, 0.263876795768738, 0.263772696256638, 0.263668537139893, 0.263564229011536, 0.263459861278534, 0.263355374336243, 0.263250797986984, 0.263146162033081, 0.263041377067566, 0.262936532497406, 0.262837439775467, 0.262745559215546, 0.262654572725296, 0.262564599514008, 0.262475520372391, 0.262387335300446, 0.262300133705139, 0.262213826179504, 0.262128531932831, 0.262044101953506, 0.261960655450821, 0.261878103017807, 0.261796504259109, 0.261715888977051, 0.261636137962341, 0.261557340621948, 0.261479526758194, 0.261402636766434, 0.261326640844345, 0.261251598596573, 0.261177480220795, 0.261104345321655, 0.261032104492188, 0.260960817337036, 0.260890483856201, 0.260821044445038, 0.260752558708191, 0.260684996843338, 0.260618388652802, 0.260552734136581, 0.260488003492355, 0.260424196720123, 0.260361343622208, 0.260299444198608, 0.260238409042358, 0.260178357362747, 0.26011922955513, 0.260061055421829, 0.260003805160522, 0.259947508573532, 0.259892135858536, 0.259837716817856, 0.259784191846848, 0.2597316801548, 0.259680032730103, 0.259629309177399, 0.259579598903656, 0.259530752897263, 0.25948292016983, 0.259435951709747, 0.259389966726303, 0.259344875812531, 0.259300738573074, 0.259257525205612, 0.259215295314789, 0.259174019098282, 0.259133577346802, 0.259094178676605, 0.259055644273758, 0.259018063545227, 0.25898140668869, 0.25894570350647, 0.258910924196243, 0.258877098560333, 0.258844196796417, 0.25881227850914, 0.258781224489212, 0.258751153945923, 0.25872203707695, 0.258693814277649, 0.258666545152664, 0.258640199899673, 0.258614778518677, 0.258590310811996, 0.258566796779633, 0.258544236421585, 0.258522570133209, 0.258501797914505, 0.258482038974762, 0.258463174104691, 0.25844532251358, 0.258428335189819, 0.258412271738052, 0.258397161960602, 0.25838303565979, 0.258369773626328, 0.258357524871826, 0.258346140384674, 0.258335739374161, 0.258326262235641, 0.258317679166794, 0.258310109376907, 0.258303433656693, 0.258297711610794, 0.25829291343689, 0.258289039134979, 0.258286088705063, 0.258284121751785, 0.258283078670502, 0.25828292965889, 0.258304089307785, 0.258347302675247, 0.258391410112381, 0.258436381816864, 0.258482247591019, 0.25852906703949, 0.258576720952988, 0.25862529873848, 0.258674800395966, 0.258725166320801, 0.258776426315308, 0.258828550577164, 0.258881598711014, 0.258935570716858, 0.258990406990051, 0.259046167135239, 0.259102791547775, 0.259160310029984, 0.259218722581863, 0.259278059005737, 0.259338289499283, 0.259399354457855, 0.259461432695389, 0.259524255990982, 0.259588122367859, 0.25965279340744, 0.259718388319016, 0.25978484749794, 0.259852260351181, 0.259920507669449, 0.259989678859711, 0.260059773921967, 0.260130703449249, 0.260202556848526, 0.260275304317474, 0.260348945856094, 0.260423511266708, 0.260498940944672, 0.260575264692307, 0.260652512311935, 0.260730654001236, 0.260809659957886, 0.260889559984207, 0.260970383882523, 0.26105210185051, 0.261134713888168, 0.261218190193176, 0.261302590370178, 0.261387884616852, 0.261474043130875, 0.261561125516891, 0.261649161577225, 0.261738032102585, 0.261827737092972, 0.261918395757675, 0.262009978294373, 0.262102425098419, 0.26219579577446, 0.262290000915527, 0.262385129928589, 0.262481182813644, 0.262578099966049, 0.262675940990448, 0.262774646282196, 0.262874245643616, 0.262974768877029, 0.263076186180115, 0.263178467750549, 0.2632817029953, 0.263385772705078, 0.26349076628685, 0.263596653938293, 0.263703465461731, 0.263811111450195, 0.263919711112976, 0.264029145240784, 0.264139503240585, 0.264250755310059, 0.264362901449203, 0.264475971460342, 0.264589935541153, 0.26470473408699, 0.264820486307144, 0.264937102794647, 0.265054613351822, 0.265173047780991, 0.265292376279831, 0.265412569046021, 0.265533685684204, 0.265655696392059, 0.265778601169586, 0.265902400016785, 0.266027063131332, 0.266152650117874, 0.266279131174088, 0.266406506299973, 0.266534775495529, 0.26666396856308, 0.266793996095657, 0.266924917697906, 0.267058670520782, 0.267194300889969, 0.26732987165451, 0.267465353012085, 0.267600804567337, 0.267736196517944, 0.267871499061584, 0.268006831407547, 0.268142074346542, 0.268277287483215, 0.268412381410599, 0.268547475337982, 0.268682539463043, 0.268817484378815, 0.268952459096909, 0.269087314605713, 0.269222110509872, 0.269356906414032, 0.269491642713547, 0.269626319408417, 0.269760936498642, 0.269895523786545, 0.270030051469803, 0.270164519548416, 0.270298928022385, 0.270433336496353, 0.270567625761032, 0.270701915025711, 0.270836114883423, 0.270970284938812, 0.271104365587234, 0.271238446235657, 0.271372467279434, 0.271506398916245, 0.271640300750732, 0.271774142980576, 0.271907955408096, 0.272041708230972, 0.272175431251526, 0.272309064865112, 0.272442668676376, 0.272576212882996, 0.27270969748497, 0.272843182086945, 0.272976577281952, 0.273109912872314, 0.273243188858032, 0.27337646484375, 0.273509621620178, 0.273642718791962, 0.273775815963745, 0.273908823728561, 0.274041831493378, 0.274174749851227, 0.274307638406754, 0.274440497159958, 0.274573266506195, 0.274705976247787, 0.274838626384735, 0.274971276521683, 0.275103837251663, 0.275236338376999, 0.275368839502335, 0.275501281023026, 0.275633603334427, 0.275765955448151, 0.275898218154907, 0.276030421257019, 0.276162564754486, 0.276294678449631, 0.276426732540131, 0.276558756828308, 0.276690691709518, 0.276822596788406, 0.276954472064972, 0.27708625793457, 0.277218043804169, 0.277349680662155, 0.277481317520142, 0.277612924575806, 0.277744442224503, 0.277875989675522, 0.278007417917252, 0.278138846158981, 0.278270155191422, 0.278401434421539, 0.278532683849335, 0.278663873672485, 0.278795003890991, 0.27892604470253, 0.279057115316391, 0.279188096523285, 0.279319018125534, 0.279449880123138, 0.27958071231842, 0.279711484909058, 0.27984219789505, 0.27997288107872, 0.280103474855423, 0.280234068632126, 0.280349940061569, 0.280449122190475, 0.280547797679901, 0.280646026134491, 0.280743807554245, 0.280841141939163, 0.280937999486923, 0.281034380197525, 0.281130403280258, 0.281225889921188, 0.281320929527283, 0.281415522098541, 0.281509667634964, 0.281603366136551, 0.28169658780098, 0.28178933262825, 0.281881630420685, 0.281973510980606, 0.282064914703369, 0.282155901193619, 0.282246351242065, 0.282336384057999, 0.282425999641418, 0.282515108585358, 0.282603770494461, 0.282691955566406, 0.282779723405838, 0.282867014408112, 0.282953858375549, 0.283040255308151, 0.283126175403595, 0.28321161866188, 0.283296704292297, 0.283381223678589, 0.283465325832367, 0.283548980951309, 0.283632159233093, 0.283714950084686, 0.283797174692154, 0.283879011869431, 0.283960402011871, 0.284041345119476, 0.284121781587601, 0.284201771020889, 0.284281313419342, 0.284360438585281, 0.28443905711174, 0.284517228603363, 0.284594982862473, 0.284672230482101, 0.284749060869217, 0.284825384616852, 0.284901291131973, 0.284976720809937, 0.285051733255386, 0.285126239061356, 0.285200327634811, 0.285273998975754, 0.285347104072571, 0.285419821739197, 0.285492032766342, 0.285563886165619, 0.285635232925415, 0.285706073045731, 0.285776525735855, 0.285846501588821, 0.285916030406952, 0.285985052585602, 0.286053657531738, 0.286121815443039, 0.286189526319504, 0.286256730556488, 0.286323517560959, 0.286389887332916, 0.286455720663071, 0.286521136760712, 0.286586076021194, 0.286650598049164, 0.286714613437653, 0.28677824139595, 0.286841332912445, 0.286904036998749, 0.286966234445572, 0.287027984857559, 0.287089318037033, 0.287150174379349, 0.287210583686829, 0.28727051615715, 0.287330031394958, 0.287389069795609, 0.287447601556778, 0.287505745887756, 0.287563353776932, 0.287620604038239, 0.287677347660065, 0.287733644247055, 0.28778949379921, 0.287844866514206, 0.287899762392044, 0.287954270839691, 0.28801241517067, 0.288073122501373, 0.288133472204208, 0.28819340467453, 0.288252979516983, 0.288312166929245, 0.288370966911316, 0.288429379463196, 0.288487374782562, 0.288545042276382, 0.288602322340012, 0.288659185171127, 0.288715660572052, 0.288771748542786, 0.288827538490295, 0.288882851600647, 0.288937777280807, 0.288992375135422, 0.289046555757523, 0.289100348949432, 0.289153754711151, 0.289206802845001, 0.289259493350983, 0.289311766624451, 0.289363622665405, 0.289415091276169, 0.289466232061386, 0.28951695561409, 0.289567321538925, 0.289617240428925, 0.289666831493378, 0.28971603512764, 0.289764851331711, 0.289813280105591, 0.28986132144928, 0.289908975362778, 0.289956241846085, 0.2900031208992, 0.290049642324448, 0.290095776319504, 0.290141522884369, 0.290186852216721, 0.290231823921204, 0.290276437997818, 0.290320605039597, 0.290364444255829, 0.290407866239548, 0.290450930595398, 0.290493547916412, 0.290535867214203, 0.29057776927948, 0.290619313716888, 0.290660411119461, 0.290701150894165, 0.290741503238678, 0.290781497955322, 0.290821045637131, 0.290860295295715, 0.290899127721786, 0.290937572717667, 0.290975630283356, 0.291013270616531, 0.291050553321838, 0.291087478399277, 0.291124016046524, 0.291160106658936, 0.291195899248123, 0.291231244802475, 0.291266262531281, 0.29130083322525, 0.291335046291351, 0.291368901729584, 0.291402339935303, 0.291435390710831, 0.291468113660812, 0.291500359773636, 0.291532307863235, 0.291563838720322, 0.291594952344894, 0.291625738143921, 0.291656106710434, 0.291686087846756, 0.291715711355209, 0.291744917631149, 0.291773766279221, 0.291802227497101, 0.291830271482468, 0.291858017444611, 0.291885286569595, 0.291912227869034, 0.291938692331314, 0.291964888572693, 0.291990667581558, 0.29201602935791, 0.292041063308716, 0.292065650224686, 0.292089909315109, 0.292113721370697, 0.292137205600739, 0.292160272598267, 0.29218652844429, 0.292213141918182, 0.292239159345627, 0.292264640331268, 0.292289614677429, 0.292314022779465, 0.292337864637375, 0.292361199855804, 0.292383968830109, 0.292406171560287, 0.292427867650986, 0.292449027299881, 0.292469650506973, 0.292489677667618, 0.292509227991104, 0.292528241872787, 0.292546659708023, 0.292564511299133, 0.292581856250763, 0.292598694562912, 0.292614936828613, 0.292630672454834, 0.292645871639252, 0.292660504579544, 0.292674630880356, 0.29268816113472, 0.292701184749603, 0.292713642120361, 0.292725592851639, 0.292736977338791, 0.292747855186462, 0.292758107185364, 0.292767912149429, 0.292777091264725, 0.29278576374054, 0.292793959379196, 0.29280149936676, 0.292808562517166, 0.292815059423447, 0.292821049690247, 0.292826473712921, 0.29283133149147, 0.292835712432861, 0.292839497327805, 0.292842745780945, 0.292845457792282, 0.292847633361816, 0.292849242687225, 0.292850315570831, 0.292850941419601, 0.292850941419601, 0.292850315570831, 0.29284930229187, 0.292847633361816, 0.292845457792282, 0.29284280538559, 0.292839556932449, 0.292835742235184, 0.292831361293793, 0.292826533317566, 0.292821109294891, 0.292815178632736, 0.292808622121811, 0.292801588773727, 0.292794018983841, 0.292785853147507, 0.292777180671692, 0.292768031358719, 0.292758256196976, 0.292747914791107, 0.29273709654808, 0.292725712060928, 0.292713731527328, 0.292701363563538, 0.292688310146332, 0.292674750089645, 0.292660683393478, 0.292646020650864, 0.292630881071091, 0.29261514544487, 0.292598873376846, 0.29258206486702, 0.29256471991539, 0.292546838521957, 0.292528361082077, 0.292509406805038, 0.292489916086197, 0.292469829320908, 0.292449235916138, 0.29242804646492, 0.292406409978867, 0.292384207248688, 0.292361378669739, 0.292338103055954, 0.292314261198044, 0.292289823293686, 0.29226490855217, 0.292239427566528, 0.292213439941406, 0.292186886072159, 0.29215931892395, 0.292136549949646, 0.292112827301025, 0.292088270187378, 0.292062908411026, 0.292036533355713, 0.292009323835373, 0.291981160640717, 0.291952133178711, 0.291922271251678, 0.29189145565033, 0.291859745979309, 0.291827142238617, 0.291793644428253, 0.29175928235054, 0.291723966598511, 0.291687846183777, 0.291650801897049, 0.291612863540649, 0.291573971509933, 0.291534215211868, 0.291493594646454, 0.291452020406723, 0.291409701108932, 0.291366338729858, 0.291322112083435, 0.291277080774307, 0.291230976581573, 0.291184186935425, 0.291136384010315, 0.291087657213211, 0.291038155555725, 0.2909876704216, 0.290936291217804, 0.290884047746658, 0.290830940008163, 0.290776878595352, 0.290721952915192, 0.290666133165359, 0.290609449148178, 0.29055181145668, 0.290493339300156, 0.290433913469315, 0.290373563766479, 0.290312498807907, 0.290250360965729, 0.290187418460846, 0.290123581886292, 0.290058761835098, 0.289993137121201, 0.289926588535309, 0.289859116077423, 0.289790838956833, 0.289721578359604, 0.289651483297348, 0.289580494165421, 0.289508521556854, 0.289435803890228, 0.289362072944641, 0.289287507534027, 0.289212018251419, 0.289135634899139, 0.28905838727951, 0.28898024559021, 0.28890123963356, 0.288821280002594, 0.288740396499634, 0.288658678531647, 0.288576036691666, 0.288492560386658, 0.288408160209656, 0.28832283616066, 0.288236677646637, 0.288149535655975, 0.288061499595642, 0.287972688674927, 0.28788286447525, 0.287792265415192, 0.287700682878494, 0.287608236074448, 0.287514895200729, 0.287420600652695, 0.287325531244278, 0.287229478359222, 0.287132561206818, 0.287034779787064, 0.286936104297638, 0.286836534738541, 0.286735981702805, 0.286634594202042, 0.286532372236252, 0.286429166793823, 0.286325037479401, 0.286220103502274, 0.286114245653152, 0.286007523536682, 0.28589990735054, 0.285791307687759, 0.285681933164597, 0.285571575164795, 0.285446256399155, 0.285310417413712, 0.285173684358597, 0.285036146640778, 0.284897685050964, 0.284758388996124, 0.284618258476257, 0.284477174282074, 0.284335225820541, 0.284192442893982, 0.284048706293106, 0.283904165029526, 0.283758670091629, 0.283612459897995, 0.2834652364254, 0.283317148685455, 0.283168256282806, 0.283018410205841, 0.282867819070816, 0.282716184854507, 0.282563716173172, 0.282410472631454, 0.282256245613098, 0.28210124373436, 0.281945258378983, 0.281788438558578, 0.281630784273148, 0.281472235918045, 0.281312793493271, 0.281152546405792, 0.280991315841675, 0.280829280614853, 0.280666321516037, 0.280502498149872, 0.280337810516357, 0.280172228813171, 0.280005842447281, 0.279838562011719, 0.279670357704163, 0.279501289129257, 0.279331356287003, 0.279160588979721, 0.278988867998123, 0.278816312551498, 0.278642892837524, 0.278468579053879, 0.278293401002884, 0.278117328882217, 0.277940392494202, 0.277762621641159, 0.277583926916122, 0.277404338121414, 0.277223914861679, 0.277042597532272, 0.276860475540161, 0.276677399873734, 0.276493459939957, 0.276308625936508, 0.276122987270355, 0.275936454534531, 0.275749057531357, 0.275560677051544, 0.275371491909027, 0.275181442499161, 0.274990558624268, 0.27479875087738, 0.274606019258499, 0.274412512779236, 0.274218112230301, 0.274022728204727, 0.273826599121094, 0.273629516363144, 0.27343162894249, 0.273232817649841, 0.273033082485199, 0.272832542657852, 0.272631138563156, 0.272428840398788, 0.272225648164749, 0.272021561861038, 0.271816700696945, 0.271610856056213, 0.271404236555099, 0.271196693181992, 0.270988166332245, 0.270778894424438, 0.27056872844696, 0.270357668399811, 0.27014571428299, 0.269932895898819, 0.269719302654266, 0.269504725933075, 0.269289284944534, 0.269072949886322, 0.268855810165405, 0.268637776374817, 0.268418818712234, 0.268198996782303, 0.267978340387344, 0.267756819725037, 0.267519325017929, 0.267260551452637, 0.26700222492218, 0.266744166612625, 0.266486406326294, 0.266229122877121, 0.265972197055817, 0.265715509653091, 0.26545923948288, 0.265203356742859, 0.26494774222374, 0.264692515134811, 0.264437705278397, 0.264183223247528, 0.263929009437561, 0.263675183057785, 0.2634217441082, 0.263168513774872, 0.262915819883347, 0.262663453817368, 0.262411326169968, 0.262159675359726, 0.261908352375031, 0.261657297611237, 0.261406600475311, 0.261156350374222, 0.260906338691711, 0.260656714439392, 0.260407567024231, 0.260158628225327, 0.259910047054291, 0.259661883115768, 0.259414106607437, 0.25916650891304, 0.258919417858124, 0.258672624826431, 0.258426189422607, 0.258180022239685, 0.257934361696243, 0.257688879966736, 0.257443875074387, 0.257199257612228, 0.256954938173294, 0.256710857152939, 0.256467312574387, 0.256224095821381, 0.255981087684631, 0.255738466978073, 0.255496352910995, 0.25525438785553, 0.255012899637222, 0.254771798849106, 0.254530817270279, 0.2542904317379, 0.254050374031067, 0.253810465335846, 0.253571093082428, 0.253332078456879, 0.253093302249908, 0.252854973077774, 0.252616971731186, 0.252379298210144, 0.252141982316971, 0.251905083656311, 0.25166842341423, 0.251432120800018, 0.25119623541832, 0.250960767269135, 0.250725507736206, 0.250490665435791, 0.250256180763245, 0.250021934509277, 0.249788239598274, 0.249554798007011, 0.24932174384594, 0.249088928103447, 0.248856544494629, 0.248624578118324, 0.248392790555954, 0.248161420226097, 0.24793054163456, 0.247699812054634, 0.247469574213028, 0.247239604592323, 0.24701002240181, 0.246780782938004, 0.246551930904388, 0.246323347091675, 0.246095225214958, 0.245867386460304, 0.245639860630035, 0.24541275203228, 0.245186030864716, 0.244959637522697, 0.244733467698097, 0.244507849216461, 0.244282484054565, 0.244057342410088, 0.243832737207413, 0.243608459830284, 0.243418172001839, 0.24326503276825, 0.243112936615944, 0.242961511015892, 0.242811143398285, 0.242661744356155, 0.242513224482536, 0.242365449666977, 0.242218747735023, 0.242072954773903, 0.241927981376648, 0.241784065961838, 0.241640940308571, 0.241498649120331, 0.24135747551918, 0.241217166185379, 0.241077646613121, 0.240939140319824, 0.240801513195038, 0.240664780139923, 0.240528985857964, 0.240394175052643, 0.240260079503059, 0.240127056837082, 0.23999497294426, 0.239863753318787, 0.239733353257179, 0.239603966474533, 0.239475473761559, 0.239347830414772, 0.239221215248108, 0.239095479249954, 0.238970503211021, 0.238846600055695, 0.238723635673523, 0.23860140144825, 0.238480240106583, 0.238360002636909, 0.23824068903923, 0.23812210559845, 0.238004609942436, 0.237887963652611, 0.237772181630135, 0.237657397985458, 0.237543508410454, 0.237430438399315, 0.237318381667137, 0.237207219004631, 0.237096920609474, 0.236987560987473, 0.236879140138626, 0.236771523952484, 0.236664935946465, 0.23655940592289, 0.236454576253891, 0.236350610852242, 0.236247628927231, 0.236145690083504, 0.236044436693192, 0.235944181680679, 0.235844925045967, 0.235746398568153, 0.235648989677429, 0.235552445054054, 0.235456675291061, 0.235361933708191, 0.235268130898476, 0.235175147652626, 0.235083162784576, 0.234992042183876, 0.234901949763298, 0.234812557697296, 0.234724208712578, 0.234636768698692, 0.234550133347511, 0.234464526176453, 0.234379842877388, 0.234295949339867, 0.234213098883629, 0.234131142497063, 0.23404997587204, 0.233969807624817, 0.233890563249588, 0.233812153339386, 0.233734741806984, 0.233658239245415, 0.233582705259323, 0.233507946133614, 0.233434170484543, 0.233361303806305, 0.233289241790771, 0.233218282461166, 0.233148187398911, 0.233078837394714, 0.233010515570641, 0.232943192124367, 0.232876643538475, 0.232811093330383, 0.232746452093124, 0.232682555913925, 0.23262919485569, 0.232580870389938, 0.232532367110252, 0.232483625411987, 0.232434764504433, 0.232385590672493, 0.232336163520813, 0.232286527752876, 0.232236742973328, 0.2321867197752, 0.232136428356171, 0.23208586871624, 0.232035145163536, 0.23198427259922, 0.231933102011681, 0.231881678104401, 0.231830045580864, 0.231778249144554, 0.231726169586182, 0.231673941016197, 0.231621414422989, 0.23156875371933, 0.231515794992447, 0.231462627649307, 0.231409266591072, 0.231355652213097, 0.231301844120026, 0.231247738003731, 0.231193512678146, 0.23113901913166, 0.231084331870079, 0.231029391288757, 0.230974197387695, 0.230918854475021, 0.230863243341446, 0.230807453393936, 0.230751395225525, 0.230695083737373, 0.230638608336449, 0.230581909418106, 0.230525016784668, 0.230467855930328, 0.230410426855087, 0.230352893471718, 0.230295047163963, 0.230237022042274, 0.230178728699684, 0.230120316147804, 0.230061560869217, 0.230002626776695, 0.229943484067917, 0.229884117841721, 0.229824542999268, 0.229764685034752, 0.229704663157463, 0.22964446246624, 0.229583919048309, 0.229523226618767, 0.229462310671806, 0.229401186108589, 0.229339808225632, 0.229278221726418, 0.229216367006302, 0.229154363274574, 0.229092136025429, 0.229029685258865, 0.228966951370239, 0.228903993964195, 0.228840872645378, 0.228777587413788, 0.228713974356651, 0.228650137782097, 0.228586122393608, 0.228521853685379, 0.22845746576786, 0.228392690420151, 0.228327825665474, 0.228262647986412, 0.228197306394577, 0.228131726384163, 0.228065922856331, 0.227999955415726, 0.227933689951897, 0.227867156267166, 0.227800503373146, 0.227733641862869, 0.227666407823563, 0.227599114179611, 0.227531492710114, 0.227463692426682, 0.227395713329315, 0.227327436208725, 0.227259024977684, 0.227190271019936, 0.227121412754059, 0.227052286267281, 0.226982921361923, 0.226913347840309, 0.226843550801277, 0.226773574948311, 0.22666834294796, 0.226536065340042, 0.226403325796127, 0.226270228624344, 0.226136729121208, 0.226002857089043, 0.225868418812752, 0.225733578205109, 0.225598439574242, 0.225462824106216, 0.225326806306839, 0.225190281867981, 0.225053369998932, 0.224916145205498, 0.224778413772583, 0.224640235304832, 0.224501699209213, 0.224362716078758, 0.224223360419273, 0.22408352792263, 0.223943263292313, 0.223802670836449, 0.223661541938782, 0.223520040512085, 0.223378151655197, 0.223235890269279, 0.223093152046204, 0.22294993698597, 0.222806364297867, 0.222662359476089, 0.222517982125282, 0.222373023629189, 0.222227811813354, 0.222082138061523, 0.221936017274857, 0.221789553761482, 0.221642538905144, 0.221495226025581, 0.221347451210022, 0.221199303865433, 0.221050694584846, 0.220901593565941, 0.220752149820328, 0.22060239315033, 0.220452025532722, 0.220301330089569, 0.220150262117386, 0.219998672604561, 0.219846665859222, 0.219694256782532, 0.219541549682617, 0.2193883061409, 0.219234570860863, 0.219080626964569, 0.218926101922989, 0.218771234154701, 0.218615815043449, 0.218460187315941, 0.218303993344307, 0.218147426843643, 0.217990383505821, 0.217833012342453, 0.21767520904541, 0.217517033219337, 0.217358335852623, 0.217199191451073, 0.21703964471817, 0.216879814863205, 0.216719463467598, 0.216558650135994, 0.21639746427536, 0.21623595058918, 0.216073870658875, 0.215911418199539, 0.215748533606529, 0.215585321187973, 0.215421631932259, 0.215257525444031, 0.215092986822128, 0.214928030967712, 0.214762613177299, 0.21459686756134, 0.214430645108223, 0.21426397562027, 0.214096918702126, 0.213929519057274, 0.213761627674103, 0.213593304157257, 0.213424667716026, 0.213255509734154, 0.213085860013962, 0.212915882468224, 0.212745532393456, 0.212574705481529, 0.212403416633606, 0.212231829762459, 0.212059751152992, 0.211887195706367, 0.211714386940002, 0.21154098212719, 0.211370393633842, 0.211209312081337, 0.211048647761345, 0.210888266563416, 0.210728392004967, 0.210568740963936, 0.210409581661224, 0.210250675678253, 0.210092231631279, 0.209934160113335, 0.209776401519775, 0.209619015455246, 0.209462091326714, 0.209305450320244, 0.209149181842804, 0.208993226289749, 0.208837777376175, 0.208682641386986, 0.208527818322182, 0.208373486995697, 0.20821937918663, 0.208065718412399, 0.207912415266037, 0.207759514451027, 0.20760689675808, 0.207454741001129, 0.207302927970886, 0.207151502370834, 0.207000359892845, 0.206849679350853, 0.206699371337891, 0.206549406051636, 0.206399753689766, 0.206250533461571, 0.206101730465889, 0.205953270196915, 0.205805063247681, 0.205657362937927, 0.205509901046753, 0.205362975597382, 0.205216318368912, 0.205070003867149, 0.204924091696739, 0.204778656363487, 0.204633444547653, 0.20448862016201, 0.204344168305397, 0.204200133681297, 0.20405650138855, 0.203913167119026, 0.20377017557621, 0.20362763106823, 0.203485444188118, 0.203343570232391, 0.203202083706856, 0.203061044216156, 0.202920243144035, 0.202779918909073, 0.202639997005463, 0.202500313520432, 0.202361032366753, 0.202222257852554, 0.202083721756935, 0.201945558190346, 0.201807722449303, 0.201670259237289, 0.201533377170563, 0.20139667391777, 0.201260387897491, 0.201124414801598, 0.200988963246346, 0.200853750109673, 0.200718998908997, 0.200584471225739, 0.200450360774994, 0.200316786766052, 0.200183361768723, 0.200050443410873, 0.199917763471603, 0.19978554546833, 0.199653744697571, 0.19952218234539, 0.199391141533852, 0.199260383844376, 0.199129894375801, 0.19899994134903, 0.198870241641998, 0.198741093277931, 0.198612153530121, 0.198483631014824, 0.19835552573204, 0.198227614164352, 0.198100313544273, 0.197973176836967, 0.197846561670303, 0.197720229625702, 0.197594210505486, 0.197468787431717, 0.19734351336956, 0.197218656539917, 0.197117000818253, 0.197024762630463, 0.196932941675186, 0.196841433644295, 0.196750000119209, 0.196658968925476, 0.196568235754967, 0.196477681398392, 0.196387425065041, 0.196297466754913, 0.196207702159882, 0.196118339896202, 0.19602906703949, 0.195940300822258, 0.195851624011993, 0.195763170719147, 0.195675194263458, 0.195587307214737, 0.195499867200851, 0.195412516593933, 0.195325508713722, 0.195238843560219, 0.195152327418327, 0.195066228508949, 0.194980293512344, 0.194894552230835, 0.194809213280678, 0.194724068045616, 0.194639354944229, 0.194554686546326, 0.194470435380936, 0.194386377930641, 0.194302618503571, 0.194219276309013, 0.194136008620262, 0.194053068757057, 0.193970441818237, 0.193888083100319, 0.193805888295174, 0.193724080920219, 0.193642497062683, 0.193561196327209, 0.19348019361496, 0.19339944422245, 0.193318963050842, 0.193238630890846, 0.193158730864525, 0.193079099059105, 0.192999601364136, 0.19292052090168, 0.19284163415432, 0.192763030529022, 0.192684814333916, 0.19260661303997, 0.192528858780861, 0.192451417446136, 0.192374125123024, 0.192297160625458, 0.192220374941826, 0.192144110798836, 0.192067921161652, 0.191991910338402, 0.191916331648827, 0.191841021180153, 0.191766038537025, 0.191691175103188, 0.191616654396057, 0.191542372107506, 0.191468328237534, 0.191394731402397, 0.19132125377655, 0.191248118877411, 0.191175162792206, 0.191102638840675, 0.191030248999596, 0.190958186984062, 0.190886318683624, 0.190814763307571, 0.190743550658226, 0.19067245721817, 0.190601781010628, 0.190531313419342, 0.190461069345474, 0.190391182899475, 0.19032147526741, 0.190252184867859, 0.190183028578758, 0.190114170312881, 0.190045699477196, 0.189977332949638, 0.189909383654594, 0.189841598272324, 0.189774110913277, 0.189706921577454, 0.189639925956726, 0.189573287963867, 0.189506888389587, 0.189440831542015, 0.189374923706055, 0.189309254288673, 0.189239203929901, 0.189169779419899, 0.189100012183189, 0.189029723405838, 0.188959270715714, 0.188888236880302, 0.188816785812378, 0.188745096325874, 0.188672930002213, 0.188600301742554, 0.188527464866638, 0.188454046845436, 0.188380360603333, 0.188306257128716, 0.188231647014618, 0.188156753778458, 0.1880813986063, 0.188005715608597, 0.187929570674896, 0.187853142619133, 0.187776252627373, 0.187698915600777, 0.187621295452118, 0.187543153762817, 0.187464684247971, 0.187385812401772, 0.187306597828865, 0.187226876616478, 0.187146931886673, 0.187066465616226, 0.186985597014427, 0.186904281377792, 0.186822801828384, 0.18674074113369, 0.186658218502998, 0.186575546860695, 0.186492294073105, 0.186408653855324, 0.18632461130619, 0.186240330338478, 0.186155468225479, 0.186070367693901, 0.185984775424004, 0.185898795723915, 0.185812413692474, 0.185725718736649, 0.185638546943665, 0.185550943017006, 0.185463100671768, 0.185374736785889, 0.185286045074463, 0.185196995735168, 0.185107424855232, 0.185017392039299, 0.184927180409431, 0.184836477041245, 0.184745371341705, 0.18465393781662, 0.184562012553215, 0.184469759464264, 0.184377014636993, 0.184284061193466, 0.184190571308136, 0.184096813201904, 0.184002459049225, 0.18390779197216, 0.183812782168388, 0.183717414736748, 0.183621555566788, 0.183525294065475, 0.183428779244423, 0.183331727981567, 0.183234244585037, 0.183136567473412, 0.183038368821144, 0.182939723134041, 0.182840839028358, 0.18274137377739, 0.182641640305519, 0.18254154920578, 0.182440921664238, 0.182339921593666, 0.182238712906837, 0.182136937975883, 0.182034760713577, 0.181932285428047, 0.181829363107681, 0.18172599375248, 0.181622222065926, 0.181518211960793, 0.181413725018501, 0.18130886554718, 0.181203559041023, 0.181097850203514, 0.180991753935814, 0.180885300040245, 0.180778473615646, 0.180671155452728, 0.18056358397007, 0.18045549094677, 0.180335760116577, 0.180193826556206, 0.180051445960999, 0.179908707737923, 0.179765775799751, 0.179622486233711, 0.17947880923748, 0.179334938526154, 0.179190590977669, 0.179046019911766, 0.17890103161335, 0.178755879402161, 0.178610295057297, 0.178464472293854, 0.17831826210022, 0.178171694278717, 0.178024798631668, 0.177877768874168, 0.177730292081833, 0.177582398056984, 0.177434399724007, 0.177285879850388, 0.177137076854706, 0.176987960934639, 0.176838636398315, 0.17668890953064, 0.176538944244385, 0.176388546824455, 0.176237851381302, 0.176086917519569, 0.175935551524162, 0.17578387260437, 0.175631880760193, 0.175479680299759, 0.175327017903328, 0.17517414689064, 0.175020948052406, 0.174867302179337, 0.174713373184204, 0.174559235572815, 0.174404680728912, 0.174249798059464, 0.174094662070274, 0.173939138650894, 0.173783361911774, 0.173627182841301, 0.173470810055733, 0.173313975334167, 0.173156976699829, 0.172999560832977, 0.172841757535934, 0.172683715820312, 0.172525361180305, 0.172366693615913, 0.172207593917847, 0.172048404812813, 0.171888679265976, 0.171728789806366, 0.171568438410759, 0.17140781879425, 0.171246841549873, 0.171085670590401, 0.170923992991447, 0.170762151479721, 0.170600026845932, 0.170437410473824, 0.170274525880814, 0.170111432671547, 0.169947907328606, 0.169784009456635, 0.169619932770729, 0.169455498456955, 0.169290632009506, 0.169125527143478, 0.168960183858871, 0.168794423341751, 0.16862840950489, 0.168461978435516, 0.168295308947563, 0.168128222227097, 0.167960986495018, 0.167793229222298, 0.167625233530998, 0.16745699942112, 0.167288348078728, 0.167119488120079, 0.166950240731239, 0.166780546307564, 0.166610658168793, 0.166440442204475, 0.166269898414612, 0.166098982095718, 0.165927886962891, 0.165756285190582, 0.165584415197372, 0.1654122620821, 0.165239855647087, 0.165067091584206, 0.164894059300423, 0.164720579981804, 0.164544567465782, 0.164366275072098, 0.164188519120216, 0.164011672139168, 0.163834869861603, 0.163658812642097, 0.163483187556267, 0.1633081138134, 0.163133606314659, 0.162959486246109, 0.162786170840263, 0.162613183259964, 0.162440627813339, 0.162268683314323, 0.162097260355949, 0.161926418542862, 0.161755830049515, 0.161586090922356, 0.161416754126549, 0.161247834563255, 0.161079585552216, 0.160911813378334, 0.160744294524193, 0.160577714443207, 0.160411417484283, 0.160245701670647, 0.160080596804619, 0.159915640950203, 0.159751623868942, 0.159587875008583, 0.159424751996994, 0.159262210130692, 0.159099936485291, 0.158938258886337, 0.158777296543121, 0.158616840839386, 0.158456742763519, 0.158297151327133, 0.158138051629066, 0.157979667186737, 0.157821789383888, 0.157664373517036, 0.157507210969925, 0.157350793480873, 0.157194957137108, 0.157039642333984, 0.156884789466858, 0.156730189919472, 0.156576454639435, 0.156423211097717, 0.156270429491997, 0.156118243932724, 0.155966192483902, 0.155815035104752, 0.155664354562759, 0.155514121055603, 0.155364543199539, 0.155215427279472, 0.155066475272179, 0.154918447136879, 0.15477092564106, 0.154623776674271, 0.154477328062057, 0.15433095395565, 0.154185473918915, 0.154040530323982, 0.153896063566208, 0.153752073645592, 0.153608366847038, 0.15346547961235, 0.153323084115982, 0.153181180357933, 0.153039768338203, 0.152898833155632, 0.152758404612541, 0.152618572115898, 0.152479350566864, 0.15234050154686, 0.152202129364014, 0.152064263820648, 0.15192699432373, 0.151790469884872, 0.151654168963432, 0.151518225669861, 0.151383176445961, 0.151248455047607, 0.151114240288734, 0.150980770587921, 0.150847405195236, 0.150714784860611, 0.150582745671272, 0.150451198220253, 0.150320291519165, 0.150189474225044, 0.150059431791306, 0.149930089712143, 0.14980112016201, 0.149672657251358, 0.149544760584831, 0.1494170576334, 0.149309709668159, 0.149233862757683, 0.14915831387043, 0.14908342063427, 0.149008601903915, 0.148934423923492, 0.14886075258255, 0.148787409067154, 0.148714601993561, 0.148642107844353, 0.148570105433464, 0.148498639464378, 0.14842763543129, 0.14835698902607, 0.148286566138268, 0.148217007517815, 0.148147627711296, 0.148078918457031, 0.148010477423668, 0.147942364215851, 0.147874891757965, 0.147807821631432, 0.14774115383625, 0.147675171494484, 0.147609114646912, 0.147543832659721, 0.147479087114334, 0.147414639592171, 0.147350817918777, 0.147286966443062, 0.147223889827728, 0.147161453962326, 0.147099182009697, 0.147037476301193, 0.14697627723217, 0.146915137767792, 0.146854668855667, 0.146794810891151, 0.146735310554504, 0.146676197648048, 0.146617501974106, 0.146559193730354, 0.146501556038857, 0.146444231271744, 0.146387428045273, 0.146330818533897, 0.146274834871292, 0.146219283342361, 0.146164268255234, 0.146109640598297, 0.146055206656456, 0.146001547574997, 0.145948186516762, 0.145895466208458, 0.14584293961525, 0.145790711045265, 0.145739361643791, 0.145688205957413, 0.145637542009354, 0.145587459206581, 0.145537406206131, 0.145488023757935, 0.145439296960831, 0.145390823483467, 0.145342811942101, 0.145295202732086, 0.145248010754585, 0.145201459527016, 0.14515520632267, 0.145109504461288, 0.145063951611519, 0.145019099116325, 0.144974619150162, 0.144930794835091, 0.144887179136276, 0.144844055175781, 0.144801259040833, 0.144758984446526, 0.14471735060215, 0.14467591047287, 0.14463497698307, 0.144594490528107, 0.144554406404495, 0.144514873623848, 0.144475862383842, 0.1444371342659, 0.144398719072342, 0.144360959529877, 0.144323617219925, 0.144286692142487, 0.144250378012657, 0.144214168190956, 0.144178584218025, 0.144143536686897, 0.144108816981316, 0.144074708223343, 0.144040569663048, 0.144007205963135, 0.143974468111992, 0.143941909074783, 0.143914982676506, 0.143888369202614, 0.143861040472984, 0.143832951784134, 0.143803983926773, 0.143774285912514, 0.143743842840195, 0.143712505698204, 0.143680438399315, 0.143647760152817, 0.143614202737808, 0.14358001947403, 0.14354495704174, 0.143509164452553, 0.143472641706467, 0.143435344099998, 0.143397301435471, 0.143358185887337, 0.143318772315979, 0.143278241157532, 0.143237128853798, 0.143195241689682, 0.143152460455894, 0.143109127879143, 0.143064856529236, 0.143020004034042, 0.142974257469177, 0.142927542328835, 0.14288055896759, 0.142832219600677, 0.142783507704735, 0.142733931541443, 0.14268371462822, 0.142632514238358, 0.142580792307854, 0.142528235912323, 0.142474800348282, 0.142420500516891, 0.142365694046021, 0.142309874296188, 0.142253592610359, 0.14219619333744, 0.14213839173317, 0.142079725861549, 0.142020091414452, 0.14196003973484, 0.141898930072784, 0.141837030649185, 0.141774505376816, 0.141711041331291, 0.141647145152092, 0.141582161188126, 0.141516655683517, 0.141450390219688, 0.141383185982704, 0.141315430402756, 0.141246631741524, 0.141177043318748, 0.141106948256493, 0.141035974025726, 0.140964269638062, 0.140891924500465, 0.140818491578102, 0.14074470102787, 0.140669882297516, 0.140594303607941, 0.1405179053545, 0.140440955758095, 0.140362948179245, 0.140284389257431, 0.14020511507988, 0.140124946832657, 0.140044048428535, 0.139962524175644, 0.139880135655403, 0.139796897768974, 0.139712765812874, 0.139628350734711, 0.139542654156685, 0.139456391334534, 0.139369532465935, 0.139281779527664, 0.139193192124367, 0.139103949069977, 0.13901399075985, 0.138923153281212, 0.138831317424774, 0.138739258050919, 0.138645932078362, 0.138552099466324, 0.138457521796227, 0.13836207985878, 0.138266026973724, 0.138169080018997, 0.138071417808533, 0.137972995638847, 0.137873589992523, 0.137773543596268, 0.137672901153564, 0.137571379542351, 0.137426167726517, 0.137257784605026, 0.137088656425476, 0.136918768286705, 0.136747971177101, 0.136576533317566, 0.13640396296978, 0.136230856180191, 0.136057004332542, 0.135882347822189, 0.135706916451454, 0.135530635714531, 0.135353550314903, 0.135175809264183, 0.134997203946114, 0.134817570447922, 0.134637534618378, 0.134456381201744, 0.134274691343307, 0.134092107415199, 0.133908733725548, 0.133724585175514, 0.133539691567421, 0.133354038000107, 0.133167445659637, 0.132979989051819, 0.132792115211487, 0.132603004574776, 0.1324133425951, 0.132222935557365, 0.132031738758087, 0.131839692592621, 0.131646946072578, 0.131453305482864, 0.131258904933929, 0.131063506007195, 0.130867719650269, 0.130670875310898, 0.130473271012306, 0.130274802446365, 0.130075886845589, 0.129875883460045, 0.129675284028053, 0.129473716020584, 0.129271388053894, 0.1290682554245, 0.128864377737045, 0.128659605979919, 0.128454297780991, 0.128248006105423, 0.128041118383408, 0.127833262085915, 0.127624645829201, 0.127415359020233, 0.127205103635788, 0.126993909478188, 0.126782312989235, 0.126569718122482, 0.126356557011604, 0.126142203807831, 0.125927299261093, 0.125711813569069, 0.12549515068531, 0.125277906656265, 0.125059902667999, 0.124841138720512, 0.124621339142323, 0.124400816857815, 0.124179728329182, 0.123957857489586, 0.123735025525093, 0.123511366546154, 0.123286969959736, 0.123061798512936, 0.122835606336594, 0.12260913848877, 0.122381411492825, 0.122153162956238, 0.121924117207527, 0.121694296598434, 0.121463499963284, 0.12123216688633, 0.120999790728092, 0.120766930282116, 0.120532773435116, 0.120298370718956, 0.120062686502934, 0.119826696813107, 0.119589745998383, 0.119351983070374, 0.119113475084305, 0.118873946368694, 0.11863386631012, 0.118393041193485, 0.118150964379311, 0.117908827960491, 0.117665223777294, 0.11742128431797, 0.117176368832588, 0.116930671036243, 0.116685792803764, 0.116432748734951, 0.116179846227169, 0.115928053855896, 0.115676879882812, 0.115426316857338, 0.115176148712635, 0.114926844835281, 0.114678166806698, 0.114429853856564, 0.114182405173779, 0.113935835659504, 0.113689869642258, 0.113444089889526, 0.1131991147995, 0.112955018877983, 0.112711116671562, 0.112468495965004, 0.112226255238056, 0.111984215676785, 0.111743234097958, 0.111503124237061, 0.111263394355774, 0.111024059355259, 0.110785581171513, 0.110547959804535, 0.110310524702072, 0.110074117779732, 0.109838359057903, 0.109603248536587, 0.10936825722456, 0.109134376049042, 0.108901128172874, 0.108668021857738, 0.108436264097691, 0.108204871416092, 0.107974335551262, 0.107743747532368, 0.107514426112175, 0.10728557407856, 0.107057049870491, 0.10682962089777, 0.106602869927883, 0.106376215815544, 0.106150671839714, 0.105925768613815, 0.105701677501202, 0.105477571487427, 0.105254493653774, 0.105032078921795, 0.104810051620007, 0.104589082300663, 0.104368768632412, 0.104149080812931, 0.103929296135902, 0.103710867464542, 0.103493005037308, 0.10327535122633, 0.103058993816376, 0.102842785418034, 0.102627709507942, 0.102412521839142, 0.10219869017601, 0.101985223591328, 0.101771906018257, 0.101560153067112, 0.101348556578159, 0.101137809455395, 0.100927248597145, 0.100717514753342, 0.100508898496628, 0.100300192832947, 0.100092560052872, 0.0998857915401459, 0.0996787175536156, 0.0994732081890106, 0.0992680862545967, 0.0990637913346291, 0.0988597050309181, 0.0986564606428146, 0.0984542891383171, 0.0982518047094345, 0.0980506539344788, 0.0978501215577126, 0.0976502150297165, 0.0974504500627518, 0.097251832485199, 0.0970539972186089, 0.0968561321496964, 0.0966593474149704, 0.0964634045958519, 0.0962678790092468, 0.0960727259516716, 0.0958786681294441, 0.0956852212548256, 0.0954919382929802, 0.095299519598484, 0.0951081812381744, 0.0949168130755424, 0.0947264581918716, 0.0945832207798958, 0.0944652110338211, 0.0943476930260658, 0.0942311882972717, 0.0941157341003418, 0.0940005704760551, 0.0938864126801491, 0.0937733352184296, 0.0936609953641891, 0.0935489684343338, 0.0934381857514381, 0.0933282002806664, 0.0932185277342796, 0.0931101590394974, 0.0930027514696121, 0.092895895242691, 0.0927893593907356, 0.0926842838525772, 0.0925800129771233, 0.0924758911132812, 0.0923731699585915, 0.0922712460160255, 0.0921696498990059, 0.0920692831277847, 0.0919697135686874, 0.0918710008263588, 0.0917725116014481, 0.0916753113269806, 0.0915790870785713, 0.0914829596877098, 0.0913883373141289, 0.0912943035364151, 0.0912012159824371, 0.0911084935069084, 0.0910167396068573, 0.0909260213375092, 0.0908356159925461, 0.0907465443015099, 0.0906581431627274, 0.0905705839395523, 0.090483546257019, 0.0903974995017052, 0.0903122946619987, 0.0902276113629341, 0.090144008398056, 0.0900613591074944, 0.089979462325573, 0.0898976922035217, 0.0898173972964287, 0.0897378847002983, 0.0896587297320366, 0.0895807817578316, 0.0895036309957504, 0.0894267708063126, 0.0893511846661568, 0.0892766118049622, 0.0892028585076332, 0.0891289263963699, 0.0890569165349007, 0.0889852568507195, 0.0889141410589218, 0.0888442322611809, 0.0887749791145325, 0.0887068808078766, 0.08863864839077, 0.0885721668601036, 0.088506206870079, 0.0884405523538589, 0.0883762165904045, 0.0883126333355904, 0.0882500037550926, 0.0881877243518829, 0.0881264954805374, 0.0880662575364113, 0.0880061089992523, 0.0879474878311157, 0.0878898277878761, 0.0878324955701828, 0.0877759456634521, 0.0877201482653618, 0.087665393948555, 0.0876112580299377, 0.0875580534338951, 0.0875058844685555, 0.0874538123607635, 0.087403193116188, 0.0873531475663185, 0.0873041823506355, 0.087255448102951, 0.0872079581022263, 0.0871612876653671, 0.0871149376034737, 0.0870698094367981, 0.08702552318573, 0.0869819968938828, 0.0869387462735176, 0.0868969857692719, 0.0868557840585709, 0.0868151560425758, 0.0867755636572838, 0.0867360234260559, 0.0866923704743385, 0.0866485834121704, 0.0866042971611023, 0.0865597426891327, 0.0865147635340691, 0.0864694565534592, 0.0864237993955612, 0.0863777101039886, 0.0863311588764191, 0.0862844586372375, 0.0862371101975441, 0.0861894860863686, 0.0861414223909378, 0.0860933214426041, 0.0860445946455002, 0.0859955102205276, 0.0859462842345238, 0.0858963578939438, 0.085846371948719, 0.0857957452535629, 0.0857448950409889, 0.0856936648488045, 0.0856420248746872, 0.0855899453163147, 0.0855376869440079, 0.0854849219322205, 0.085431881248951, 0.0853783786296844, 0.0853244513273239, 0.0852703675627708, 0.0852158293128014, 0.0851605460047722, 0.0851052477955818, 0.0850494503974915, 0.0849935114383698, 0.0849370211362839, 0.0848803520202637, 0.0848230123519897, 0.0847655981779099, 0.0847076177597046, 0.0846494063735008, 0.0845907106995583, 0.084531806409359, 0.0844723135232925, 0.0844125971198082, 0.0843523815274239, 0.0842920020222664, 0.0842310264706612, 0.0841699689626694, 0.0841082111001015, 0.0840463489294052, 0.0839840695261955, 0.0839211046695709, 0.0838580876588821, 0.0837945118546486, 0.0837308466434479, 0.0836664736270905, 0.0836020484566689, 0.0835370123386383, 0.0834717154502869, 0.0834061205387115, 0.0833400413393974, 0.083273634314537, 0.0832069367170334, 0.0831396356225014, 0.0830721855163574, 0.0830043032765388, 0.0829361006617546, 0.0828673988580704, 0.0827984511852264, 0.0827289894223213, 0.0826593860983849, 0.0825892090797424, 0.0825186222791672, 0.0824476629495621, 0.0823765471577644, 0.0823047980666161, 0.0822329297661781, 0.0821606293320656, 0.0820879861712456, 0.0820148661732674, 0.0819414854049683, 0.0818677023053169, 0.0817934274673462, 0.0817190334200859, 0.0816440805792809, 0.0815689042210579, 0.081493116915226, 0.0814172104001045, 0.0813406631350517, 0.0812639817595482, 0.0811868458986282, 0.0811094343662262, 0.0810312554240227, 0.080953061580658, 0.0808743685483932, 0.0807954072952271, 0.0807160139083862, 0.0806364119052887, 0.0805199965834618, 0.0803869366645813, 0.0802532359957695, 0.0801194086670876, 0.0799849778413773, 0.0798502862453461, 0.0797149166464806, 0.0795795321464539, 0.079443521797657, 0.0793071761727333, 0.0791703015565872, 0.0790331438183784, 0.0788953378796577, 0.078757643699646, 0.0786191448569298, 0.0784803554415703, 0.0783409848809242, 0.0782014951109886, 0.078061543405056, 0.0779211819171906, 0.0777804777026176, 0.0776392146945, 0.0774976536631584, 0.0773556306958199, 0.0772133618593216, 0.0770704969763756, 0.0769273787736893, 0.0767836794257164, 0.076639860868454, 0.0764953121542931, 0.0763505920767784, 0.0762053430080414, 0.0760598108172417, 0.0759135857224464, 0.0757674723863602, 0.0756203606724739, 0.0754733234643936, 0.0753256380558014, 0.0751777216792107, 0.0750292837619781, 0.0748806148767471, 0.0747312754392624, 0.0745817497372627, 0.0744318068027496, 0.0742813274264336, 0.0741304829716682, 0.0739793330430984, 0.0738276392221451, 0.0736758857965469, 0.0735233873128891, 0.0733705833554268, 0.0732174143195152, 0.0730637982487679, 0.0729096308350563, 0.0727554112672806, 0.0726006925106049, 0.0724452212452888, 0.0722896605730057, 0.0721336975693703, 0.0719773173332214, 0.0718204602599144, 0.0716632679104805, 0.0715055614709854, 0.071347750723362, 0.0711892396211624, 0.0710305422544479, 0.0708711966872215, 0.070711687207222, 0.0705515593290329, 0.0703913643956184, 0.0702303946018219, 0.0700693428516388, 0.0699075385928154, 0.0697456076741219, 0.0695830434560776, 0.0694204643368721, 0.0692571401596069, 0.0690934434533119, 0.0689293369650841, 0.0687650293111801, 0.068600058555603, 0.068434938788414, 0.0682692900300026, 0.0681033954024315, 0.0679369047284126, 0.0677701607346535, 0.0676029473543167, 0.0674353763461113, 0.0672674104571342, 0.0670989230275154, 0.0669301971793175, 0.0667608380317688, 0.0665913298726082, 0.066421240568161, 0.0662508904933929, 0.066079780459404, 0.0659088492393494, 0.0657369345426559, 0.0655650123953819, 0.0653925091028214, 0.0652255266904831, 0.0650699958205223, 0.0649147629737854, 0.0647594854235649, 0.0646047964692116, 0.0644504353404045, 0.0642963275313377, 0.0641421973705292, 0.0639888420701027, 0.0638354569673538, 0.0636823102831841, 0.0635295212268829, 0.0633771568536758, 0.0632247924804688, 0.0630728676915169, 0.0629213750362396, 0.0627701506018639, 0.0626188591122627, 0.0624681860208511, 0.0623177103698254, 0.0621672943234444, 0.0620175190269947, 0.0618677996098995, 0.0617184303700924, 0.0615692660212517, 0.0614207684993744, 0.0612719506025314, 0.0611237771809101, 0.0609759725630283, 0.0608283765614033, 0.0606806948781013, 0.0605337060987949, 0.0603869557380676, 0.0602403730154037, 0.0600942000746727, 0.0599480867385864, 0.0598024390637875, 0.059657022356987, 0.0595120675861835, 0.0593672282993793, 0.0592224560678005, 0.0590783469378948, 0.0589344687759876, 0.0587906502187252, 0.0586472377181053, 0.0585041455924511, 0.0583612285554409, 0.0582187175750732, 0.0580763779580593, 0.0579345673322678, 0.0577925220131874, 0.0576513148844242, 0.0575100854039192, 0.0573692321777344, 0.057228609919548, 0.0570885129272938, 0.0569482073187828, 0.0568086877465248, 0.056669257581234, 0.0565299727022648, 0.0563910640776157, 0.0562525950372219, 0.0561142414808273, 0.0559762567281723, 0.0558385439217091, 0.055701058357954, 0.055563896894455, 0.0554267913103104, 0.0552903786301613, 0.0551539771258831, 0.0550179146230221, 0.0548822022974491, 0.0547467544674873, 0.0546114221215248, 0.0544766932725906, 0.0543419755995274, 0.054207805544138, 0.0540735758841038, 0.0539399012923241, 0.0538063682615757, 0.0536730140447617, 0.0535401478409767, 0.0534075759351254, 0.0532751195132732, 0.0531430095434189, 0.053011454641819, 0.0528795532882214, 0.052748579531908, 0.0526176616549492, 0.0524871200323105, 0.0523566417396069, 0.0522265434265137, 0.0520965270698071, 0.0519671812653542, 0.051837831735611, 0.0517090111970901, 0.0515802390873432, 0.0514517687261105, 0.0513238720595837, 0.0511959791183472, 0.0510862283408642, 0.0509763471782207, 0.0508666783571243, 0.0507570840418339, 0.0506479702889919, 0.0505391918122768, 0.0504304803907871, 0.0503221452236176, 0.0502143278717995, 0.0501063130795956, 0.0499990805983543, 0.0498919077217579, 0.0497850254178047, 0.0496783182024956, 0.0495720133185387, 0.0494660623371601, 0.049360103905201, 0.0492547936737537, 0.0491497665643692, 0.0490446276962757, 0.0489400140941143, 0.0488358587026596, 0.0487317107617855, 0.0486279614269733, 0.0485244505107403, 0.0484211705625057, 0.0483183525502682, 0.0482155978679657, 0.0481134504079819, 0.048011127859354, 0.0479095354676247, 0.0478079989552498, 0.0477068722248077, 0.0476056560873985, 0.0475052259862423, 0.0474048480391502, 0.0473046489059925, 0.0472049415111542, 0.047105498611927, 0.0470060519874096, 0.0469072461128235, 0.046808622777462, 0.0467101074755192, 0.0466119982302189, 0.0465142130851746, 0.0464168004691601, 0.0463193617761135, 0.0462225936353207, 0.0461258217692375, 0.0460293404757977, 0.0459332652390003, 0.0458374582231045, 0.0457418188452721, 0.045646708458662, 0.0455517917871475, 0.0454571433365345, 0.0453624650835991, 0.0452685169875622, 0.0451746769249439, 0.0450809597969055, 0.0449877642095089, 0.0448947139084339, 0.0448018945753574, 0.044709600508213, 0.0446175970137119, 0.0445257052779198, 0.0444339923560619, 0.0443426854908466, 0.0442517846822739, 0.0441608838737011, 0.0440705940127373, 0.043980423361063, 0.0438904836773872, 0.0438007712364197, 0.0437115542590618, 0.0436224602162838, 0.0435337387025356, 0.0434453338384628, 0.0433571934700012, 0.0432691164314747, 0.0431815572082996, 0.0430943444371223, 0.0430071391165257, 0.0429204516112804, 0.0428340509533882, 0.0427477173507214, 0.0426618158817291, 0.0425761751830578, 0.0424910262227058, 0.0424057058990002, 0.0423210561275482, 0.0422365479171276, 0.0421522743999958, 0.0420684665441513, 0.0419848300516605, 0.0419013686478138, 0.0418182797729969, 0.0417355485260487, 0.0416529588401318, 0.0415707491338253, 0.041480328887701, 0.0413850992918015, 0.0412899255752563, 0.0411950722336769, 0.0411004237830639, 0.0410059206187725, 0.0409117341041565, 0.0408176369965076, 0.0407238006591797, 0.0406303182244301, 0.0405368022620678, 0.0404436625540257, 0.0403506979346275, 0.040257852524519, 0.0401652939617634, 0.0400729961693287, 0.0399807915091515, 0.0398888736963272, 0.0397971570491791, 0.0397056229412556, 0.03961431235075, 0.0395232923328876, 0.039432305842638, 0.039341613650322, 0.0392512306571007, 0.0391608253121376, 0.0390708893537521, 0.0389810614287853, 0.0388913191854954, 0.0388019606471062, 0.0387127436697483, 0.0386236757040024, 0.0385349243879318, 0.038446381688118, 0.0383579805493355, 0.0382698066532612, 0.0381818450987339, 0.0380940549075603, 0.0380065515637398, 0.0379193462431431, 0.0378320775926113, 0.0377451851963997, 0.0376583822071552, 0.0375720150768757, 0.0374857932329178, 0.0373995713889599, 0.0373137556016445, 0.0372281149029732, 0.0371425896883011, 0.0370574705302715, 0.0369724743068218, 0.0368875302374363, 0.0368029326200485, 0.0367186293005943, 0.036634411662817, 0.0365504622459412, 0.0364667065441608, 0.0363830700516701, 0.0362997278571129, 0.0362166427075863, 0.0361336469650269, 0.0360509976744652, 0.0359684713184834, 0.0358860827982426, 0.0358040742576122, 0.0357222408056259, 0.0356404930353165, 0.0355590395629406, 0.0354777835309505, 0.0353966765105724, 0.03531588986516, 0.0352352783083916, 0.0351548716425896, 0.0350746922194958, 0.0349946022033691, 0.0349148027598858, 0.0348353236913681, 0.0347559303045273, 0.034676767885685, 0.0345978364348412, 0.0345190018415451, 0.0344405397772789, 0.0343621931970119, 0.0342841073870659, 0.0342061966657639, 0.0341285467147827, 0.034050989896059, 0.033973716199398, 0.0338967069983482, 0.0338198393583298, 0.0337431207299232, 0.0336668081581593, 0.0335904359817505, 0.0335144735872746, 0.0334386862814426, 0.0333630442619324, 0.0332877486944199, 0.033212598413229, 0.033137533813715, 0.0330627597868443, 0.0329876989126205, 0.0329143516719341, 0.0328416973352432, 0.0327689908444881, 0.0326970964670181, 0.0326253771781921, 0.0325540043413639, 0.0324831567704678, 0.0324125997722149, 0.0323425009846687, 0.032272644340992, 0.032203420996666, 0.0321343764662743, 0.0320660248398781, 0.0319977328181267, 0.0319297909736633, 0.031862486153841, 0.0317953564226627, 0.0317286923527718, 0.0316626131534576, 0.0315964706242085, 0.0315310247242451, 0.0314661636948586, 0.0314015336334705, 0.0313370190560818, 0.0312730856239796, 0.0312096197158098, 0.0311462674289942, 0.0310836136341095, 0.0310213658958673, 0.0309592932462692, 0.0308976862579584, 0.0308366008102894, 0.030775748193264, 0.0307151880115271, 0.0306552071124315, 0.030595576390624, 0.0305364076048136, 0.0304773580282927, 0.0304188318550587, 0.0303609408438206, 0.0303029380738735, 0.0302458051592112, 0.0301889646798372, 0.0301323551684618, 0.0300760362297297, 0.0300203561782837, 0.0299650244414806, 0.029909985139966, 0.0298554692417383, 0.0298011843115091, 0.0297474227845669, 0.0296938922256231, 0.0296408291906118, 0.0295882299542427, 0.0295358635485172, 0.0294839031994343, 0.0294325836002827, 0.0293815527111292, 0.0293306391686201, 0.0292803067713976, 0.0292305573821068, 0.0291809234768152, 0.0291316919028759, 0.0290829297155142, 0.0290343426167965, 0.0289865080267191, 0.0289389062672853, 0.0288917142897844, 0.0288446936756372, 0.0287983734160662, 0.0287522226572037, 0.0287067163735628, 0.0286612659692764, 0.028616338968277, 0.0285719335079193, 0.0285277049988508, 0.0284839980304241, 0.0284407567232847, 0.0283977463841438, 0.028355086222291, 0.0283130072057247, 0.0282711014151573, 0.0282296631485224, 0.0281886886805296, 0.0281480625271797, 0.0281077269464731, 0.0280679725110531, 0.0280285067856312, 0.0279894508421421, 0.0279505681246519, 0.0279123242944479, 0.0278746038675308, 0.0278370585292578, 0.0277996864169836, 0.0277630127966404, 0.0277268048375845, 0.0276905950158834, 0.027655141428113, 0.0276200361549854, 0.0275883600115776, 0.0275640077888966, 0.0275400634855032, 0.0275164656341076, 0.027493042871356, 0.0274702031165361, 0.0274477079510689, 0.0274252742528915, 0.0274034217000008, 0.0273819174617529, 0.0273608770221472, 0.027339780703187, 0.0273193791508675, 0.0272992104291916, 0.0272793341428041, 0.0272599216550589, 0.0272407438606024, 0.0272220261394978, 0.0272033698856831, 0.0271855872124434, 0.027167858555913, 0.0271504819393158, 0.0271332189440727, 0.0271165389567614, 0.0271003805100918, 0.0270840488374233, 0.0270684752613306, 0.0270533040165901, 0.027038250118494, 0.0270236022770405, 0.0270094219595194, 0.0269954744726419, 0.0269816424697638, 0.0269685052335262, 0.0269556026905775, 0.0269429329782724, 0.0269307848066092, 0.0269190445542336, 0.0269075371325016, 0.0268961451947689, 0.0268853344023228, 0.0268749315291643, 0.0268647596240044, 0.0268548205494881, 0.0268453471362591, 0.026836222037673, 0.0268275029957294, 0.0268190782517195, 0.0268111154437065, 0.0268030930310488, 0.0267958305776119, 0.0267888568341732, 0.026782114058733, 0.0267756041139364, 0.0267697926610708, 0.0267642121762037, 0.0267586316913366, 0.0267536900937557, 0.0267491601407528, 0.0267449729144573, 0.0267407316714525, 0.0267372447997332, 0.0267339888960123, 0.0267310813069344, 0.0267285853624344, 0.0267263166606426, 0.0267243999987841, 0.0267228297889233, 0.0267218425869942, 0.0267208535224199, 0.0267202146351337, 0.0267202723771334, 0.0267205033451319, 0.0267208535224199, 0.0267218425869942, 0.0267231203615665, 0.026724748313427, 0.026726434007287, 0.0267288740724325, 0.0267314314842224, 0.0267345122992992, 0.0267377663403749, 0.0267414283007383, 0.0267454963177443, 0.0267495661973953, 0.0267544463276863, 0.0267593879252672, 0.0267646759748459, 0.026770431548357, 0.0267767664045095, 0.0267831590026617, 0.0267896093428135, 0.026796817779541, 0.0268043726682663, 0.0268119871616364, 0.0268201231956482, 0.0268286094069481, 0.0268376190215349, 0.0268466863781214, 0.0268563330173492, 0.0268773846328259, 0.0268982481211424, 0.0269188210368156, 0.0269395131617785, 0.0269600301980972, 0.026980372145772, 0.0270006563514471, 0.0270206518471241, 0.0270404685288668, 0.0270603448152542, 0.0270799901336432, 0.0270995777100325, 0.0271191634237766, 0.0271385181695223, 0.0271577537059784, 0.0271768774837255, 0.0271959397941828, 0.0272148288786411, 0.0272333119064569, 0.027251910418272, 0.0272703915834427, 0.0272887572646141, 0.027307067066431, 0.0273251999169588, 0.0273431595414877, 0.0273610595613718, 0.0273789037019014, 0.0273964554071426, 0.0274137184023857, 0.0274311527609825, 0.0274484734982252, 0.0274656191468239, 0.0274825897067785, 0.0274995621293783, 0.0275162998586893, 0.0275329798460007, 0.0275494866073132, 0.0275659915059805, 0.0275822076946497, 0.02759825065732, 0.0276141744107008, 0.0276300981640816, 0.0276460256427526, 0.0276616010814905, 0.0276772938668728, 0.0276925787329674, 0.027707863599062, 0.0277230925858021, 0.0277382042258978, 0.0277529079467058, 0.0277677290141582, 0.0277824327349663, 0.0277969632297754, 0.0278113782405853, 0.0278256759047508, 0.0278399139642715, 0.0278539210557938, 0.027867928147316, 0.0278817601501942, 0.0278953034430742, 0.0279088448733091, 0.0279222130775452, 0.0279354657977819, 0.0279487147927284, 0.0279617942869663, 0.0279747527092695, 0.0279876552522182, 0.0280003845691681, 0.0280127059668303, 0.0280252024531364, 0.028037641197443, 0.0280496701598167, 0.02806181833148, 0.0280738472938538, 0.0280857048928738, 0.0280974451452494, 0.0281090121716261, 0.0281205773353577, 0.0281316209584475, 0.0281428396701813, 0.0281538814306259, 0.0281649827957153, 0.0281757339835167, 0.0281865447759628, 0.0281971804797649, 0.028207641094923, 0.0282181035727262, 0.0282283332198858, 0.0282383877784014, 0.0282483845949173, 0.0282579734921455, 0.0282677970826626, 0.0282774455845356, 0.0282869189977646, 0.0282964520156384, 0.0283056925982237, 0.0283148754388094, 0.028323708102107, 0.0283327754586935, 0.0283412616699934, 0.0283442344516516, 0.0283365622162819, 0.0283279605209827, 0.0283193569630384, 0.0283098239451647, 0.0283000618219376, 0.0282895993441343, 0.0282787904143333, 0.0282676313072443, 0.0282555427402258, 0.0282434541732073, 0.0282305497676134, 0.0282172989100218, 0.0282034650444984, 0.0281891692429781, 0.0281742885708809, 0.0281591787934303, 0.0281433705240488, 0.0281272120773792, 0.0281101260334253, 0.0280929207801819, 0.0280753690749407, 0.0280570015311241, 0.0280382875353098, 0.0280191078782082, 0.0279994644224644, 0.027979239821434, 0.0279586650431156, 0.0279372744262218, 0.0279155392199755, 0.0278933364897966, 0.0278706699609756, 0.0278475359082222, 0.0278238262981176, 0.0277996454387903, 0.0277752354741096, 0.0277502443641424, 0.027724439278245, 0.0276985168457031, 0.0276717804372311, 0.0276444647461176, 0.0276167988777161, 0.027588902041316, 0.0275601893663406, 0.0275312457233667, 0.027501605451107, 0.0274716150015593, 0.0274409260600805, 0.0274101234972477, 0.0273783896118402, 0.0273461900651455, 0.0273137576878071, 0.0272807478904724, 0.0272475033998489, 0.0272132121026516, 0.027178805321455, 0.0271438155323267, 0.0271083638072014, 0.0270723290741444, 0.0270359460264444, 0.026998633518815, 0.0269614346325397, 0.0269233081489801, 0.0268849488347769, 0.0268460083752871, 0.0268067196011543, 0.026766499504447, 0.0267262794077396, 0.0266855955123901, 0.0266440976411104, 0.0266020186245441, 0.026559591293335, 0.0265169311314821, 0.0264734551310539, 0.0264296345412731, 0.0263851135969162, 0.0263403616845608, 0.0262949112802744, 0.0262493435293436, 0.0262029636651278, 0.0261560026556253, 0.0261088106781244, 0.0260608028620481, 0.0260126795619726, 0.0259637422859669, 0.0259145721793175, 0.0258647035807371, 0.025814488530159, 0.0257638078182936, 0.0257124304771423, 0.025660702958703, 0.0256085097789764, 0.0255553871393204, 0.0255023818463087, 0.0254485607147217, 0.0253943931311369, 0.0253399927169085, 0.0252846628427505, 0.025229100137949, 0.0251728389412165, 0.0251023285090923, 0.0250228177756071, 0.0249436572194099, 0.0248640328645706, 0.0247845239937305, 0.0247048977762461, 0.0246251579374075, 0.0245454162359238, 0.0244654435664415, 0.0243853535503149, 0.0243054963648319, 0.0242252871394157, 0.0241449661552906, 0.0240646433085203, 0.0239838566631079, 0.0239035338163376, 0.0238227471709251, 0.0237423088401556, 0.0236612893640995, 0.0235802680253983, 0.0234993640333414, 0.0234182290732861, 0.0233367439359426, 0.0232558399438858, 0.0231742393225431, 0.0230929870158434, 0.0230113863945007, 0.02292943559587, 0.022848067805171, 0.0227658841758966, 0.0226841662079096, 0.0226019863039255, 0.0225198026746511, 0.0224375035613775, 0.0223553217947483, 0.0222726762294769, 0.0221906080842018, 0.0221077296882868, 0.0220251996070147, 0.0219422038644552, 0.0218594390898943, 0.0217767916619778, 0.0216934457421303, 0.021610451862216, 0.0215271059423685, 0.0214438773691654, 0.0213600676506758, 0.0212768390774727, 0.0211932621896267, 0.0211096853017807, 0.0210255272686481, 0.0209417156875134, 0.0208579059690237, 0.0207736324518919, 0.0206898227334023, 0.0206053145229816, 0.0205211564898491, 0.0204366520047188, 0.0203520283102989, 0.0202675200998783, 0.0201827809214592, 0.0200979262590408, 0.0200129523873329, 0.0199277475476265, 0.0198427755385637, 0.0197576861828566, 0.019672367721796, 0.0195870473980904, 0.0195017270743847, 0.019416056573391, 0.0193303860723972, 0.0192447174340487, 0.0191589314490557, 0.0190730299800634, 0.0189870111644268, 0.0189008750021458, 0.0188146270811558, 0.0187282580882311, 0.0186418909579515, 0.0185556430369616, 0.018468925729394, 0.0183822102844715, 0.0182953793555498, 0.0182086620479822, 0.0181214828044176, 0.0180347673594952, 0.0179475862532854, 0.0178604051470757, 0.0177732240408659, 0.017685579136014, 0.0175983961671591, 0.0175105202943087, 0.0174231082201004, 0.0173352286219597, 0.0172472354024649, 0.0171591248363256, 0.0170713625848293, 0.0169829037040472, 0.0168951414525509, 0.0168064497411251, 0.0167252272367477, 0.016659202054143, 0.0165931768715382, 0.0165275018662214, 0.0164621733129025, 0.0163975451141596, 0.0163329150527716, 0.0162682831287384, 0.0162043515592813, 0.0161408837884665, 0.0160776507109404, 0.0160142984241247, 0.0159515272825956, 0.0158892218023539, 0.0158273838460445, 0.0157654248178005, 0.0157041661441326, 0.015643022954464, 0.0155822290107608, 0.0155217843130231, 0.0154615705832839, 0.015401822514832, 0.0153423072770238, 0.015283141285181, 0.0152243226766586, 0.0151658533141017, 0.0151073848828673, 0.0150496130809188, 0.0149921895936131, 0.0149349989369512, 0.0148780411109328, 0.0148211997002363, 0.0147649385035038, 0.0147089101374149, 0.0146535793319345, 0.0145981330424547, 0.0145429177209735, 0.0144884008914232, 0.0144340004771948, 0.0143801802769303, 0.0143263610079885, 0.0142730055376887, 0.0142197674140334, 0.0141668785363436, 0.0141144543886185, 0.0140626104548573, 0.014010651037097, 0.0139592718333006, 0.0139078935608268, 0.0138572119176388, 0.013806764036417, 0.0137564316391945, 0.0137065639719367, 0.0136570446193218, 0.0136077580973506, 0.0135589372366667, 0.0135102337226272, 0.0134618757292628, 0.013413985259831, 0.0133663266897202, 0.0133192483335733, 0.0132720544934273, 0.0132252089679241, 0.0131789455190301, 0.0131327984854579, 0.0130874635651708, 0.0130418976768851, 0.0129966791719198, 0.0129520427435637, 0.0129074063152075, 0.0128637002781034, 0.0128196449950337, 0.0127761708572507, 0.0127331614494324, 0.0126900356262922, 0.0126474909484386, 0.0126054119318724, 0.0125633329153061, 0.0125221842899919, 0.0124808019027114, 0.0124397687613964, 0.012399316765368, 0.0123588647693396, 0.0123192267492414, 0.0122793568298221, 0.0122400671243668, 0.0122011257335544, 0.0121623007580638, 0.0121240587905049, 0.012086046859622, 0.0120486179366708, 0.0120110725983977, 0.0119737582281232, 0.0119372587651014, 0.0119007593020797, 0.0118646081537008, 0.0118289217352867, 0.0117932362481952, 0.0117582473903894, 0.0117234913632274, 0.0116924121975899, 0.0116666201502085, 0.0116409314796329, 0.0116156488656998, 0.011590120382607, 0.0115649243816733, 0.0115397870540619, 0.0115146357566118, 0.0114897890016437, 0.0114650297909975, 0.0114404885098338, 0.0114159025251865, 0.0113914348185062, 0.0113671105355024, 0.0113431653007865, 0.0113191474229097, 0.011295085772872, 0.0112712699919939, 0.0112476153299212, 0.0112242065370083, 0.0112008433789015, 0.0111774783581495, 0.0111541720107198, 0.0111311990767717, 0.0111083136871457, 0.0110856192186475, 0.0110626602545381, 0.0110402703285217, 0.0110178356990218, 0.0109956040978432, 0.0109732281416655, 0.0109511855989695, 0.0109293032437563, 0.0109075233340263, 0.0108860908076167, 0.0108641218394041, 0.0108427470549941, 0.0108215492218733, 0.0108002899214625, 0.0107792802155018, 0.0107582109048963, 0.010737375356257, 0.0107168294489384, 0.0106962695717812, 0.0106757814064622, 0.0106553668156266, 0.0106351841241121, 0.0106151774525642, 0.0105951828882098, 0.0105753354728222, 0.0105554722249508, 0.0105359433218837, 0.0105166044086218, 0.0104972496628761, 0.0104780700057745, 0.0104587888345122, 0.0104399006813765, 0.0104210823774338, 0.0104023981839418, 0.0103837698698044, 0.0103651275858283, 0.0103467898443341, 0.0103285266086459, 0.010310610756278, 0.010292636230588, 0.0102745462208986, 0.0102568631991744, 0.0102392677217722, 0.0102218901738524, 0.0102044679224491, 0.0101871471852064, 0.0101700024679303, 0.0101529732346535, 0.0101362336426973, 0.010119466111064, 0.010102697648108, 0.0100862067192793, 0.0100698452442884, 0.010053644888103, 0.010037531144917, 0.0100215328857303, 0.0100054927170277, 0.00998977106064558, 0.00997412204742432, 0.00995869003236294, 0.00994309969246387, 0.0099278287962079, 0.00991275999695063, 0.00989777967333794, 0.00988290086388588, 0.00986784882843494, 0.00985334720462561, 0.00983884558081627, 0.00982438866049051, 0.00980993080884218, 0.00979576446115971, 0.0097818449139595, 0.00976796820759773, 0.00975416507571936, 0.00974037498235703, 0.00972386915236712, 0.00969627685844898, 0.00966853834688663, 0.00964088644832373, 0.00961333885788918, 0.00958573166280985, 0.00955822505056858, 0.0095308655872941, 0.00950334500521421, 0.00947604328393936, 0.00944864004850388, 0.00942139513790607, 0.00939403474330902, 0.00936682056635618, 0.00933962129056454, 0.00931239034980536, 0.00928523298352957, 0.00925817899405956, 0.00923119578510523, 0.00920409709215164, 0.00917712971568108, 0.00915016140788794, 0.00912326574325562, 0.00909634213894606, 0.00906954891979694, 0.00904284231364727, 0.00901600439101458, 0.0089892977848649, 0.00896257720887661, 0.00893585663288832, 0.00890926737338305, 0.00888276379555464, 0.00885624624788761, 0.00882972870022058, 0.00880313757807016, 0.00877679511904716, 0.00875033531337976, 0.00872396305203438, 0.00869773700833321, 0.00867139268666506, 0.0086452541872859, 0.00861892569810152, 0.0085928151383996, 0.00856660213321447, 0.00854057911783457, 0.00851455610245466, 0.0084884874522686, 0.00846246443688869, 0.00843648426234722, 0.00841062143445015, 0.00838472880423069, 0.00835895258933306, 0.00833313260227442, 0.00830729678273201, 0.00828156433999538, 0.00825587473809719, 0.00823028758168221, 0.00820467062294483, 0.00817909836769104, 0.00815351121127605, 0.00812798086553812, 0.00810248032212257, 0.00807716976851225, 0.0080517278984189, 0.00802634377032518, 0.00800095871090889, 0.00797571986913681, 0.00795046612620354, 0.00792522728443146, 0.00790016259998083, 0.00787495356053114, 0.00784988887608051, 0.00782473664730787, 0.00779975997284055, 0.00777476839721203, 0.00774987833574414, 0.00772494403645396, 0.00770006887614727, 0.00767519371584058, 0.00765034649521112, 0.00762565992772579, 0.00760085694491863, 0.00757622858509421, 0.00755155645310879, 0.00752689875662327, 0.00750229926779866, 0.00747774308547378, 0.00745330331847072, 0.00742882071062922, 0.00740442425012589, 0.00737995561212301, 0.00735560292378068, 0.00733123579993844, 0.00730705773457885, 0.00728280702605844, 0.00725854141637683, 0.00723443599417806, 0.00721021462231874, 0.00718605099245906, 0.00716200331225991, 0.00714015029370785, 0.00712390569970012, 0.00710768299177289, 0.0070915762335062, 0.00707561429589987, 0.0070595876313746, 0.00704383011907339, 0.00702813733369112, 0.00701237935572863, 0.00699677411466837, 0.00698121264576912, 0.00696586165577173, 0.00695033557713032, 0.00693517364561558, 0.00691990274935961, 0.0069048348814249, 0.0068897595629096, 0.00687477178871632, 0.00685995165258646, 0.00684510124847293, 0.00683037517592311, 0.00681572128087282, 0.00680120615288615, 0.0067866831086576, 0.006772356107831, 0.006758036557585, 0.0067437388934195, 0.00672955019399524, 0.00671545602381229, 0.00670141261070967, 0.00668751494958997, 0.00667373277246952, 0.00665997294709086, 0.00664627132937312, 0.00663265585899353, 0.00661909254267812, 0.00660561537370086, 0.00659232819452882, 0.00657909130677581, 0.00656589074060321, 0.00655273348093033, 0.00653966329991817, 0.00652677519246936, 0.00651373481377959, 0.00650104228407145, 0.0064883716404438, 0.00647564372047782, 0.00646306062117219, 0.00645058648660779, 0.00643825763836503, 0.00642588501796126, 0.00641362182796001, 0.00640144571661949, 0.00638939253985882, 0.00637735472992063, 0.0063655492849648, 0.00635372148826718, 0.00634187925606966, 0.00633018976077437, 0.00631855148822069, 0.00630699237808585, 0.00629561534151435, 0.00628431839868426, 0.00627291202545166, 0.00626181066036224, 0.0062506590038538, 0.00623957999050617, 0.00622857362031937, 0.00621779961511493, 0.00620700279250741, 0.00619619339704514, 0.00618565874174237, 0.00617504445835948, 0.00616452423855662, 0.00615412089973688, 0.00614385539665818, 0.0061336406506598, 0.0061234044842422, 0.00611327681690454, 0.00610335264354944, 0.00609338516369462, 0.00608353363350034, 0.00607387814670801, 0.00606416491791606, 0.00605453131720424, 0.00604501413181424, 0.00603564269840717, 0.00602620467543602, 0.00601703627035022, 0.00600780267268419, 0.0059986487030983, 0.00598956039175391, 0.00598060945048928, 0.0059718256816268, 0.00596296275034547, 0.00595433916896582, 0.00594565737992525, 0.00593706266954541, 0.00592856993898749, 0.00592012051492929, 0.00591158773750067, 0.00590483844280243, 0.00589786423370242, 0.00589090446010232, 0.00588394422084093, 0.00587678840383887, 0.00586961768567562, 0.00586254196241498, 0.00585523340851068, 0.00584788806736469, 0.00584041932597756, 0.00583297992125154, 0.00582543155178428, 0.00581795582547784, 0.00581037858501077, 0.00580257549881935, 0.00579478731378913, 0.00578694138675928, 0.00577907357364893, 0.00577113265171647, 0.00576317775994539, 0.0057550841011107, 0.00574691081419587, 0.00573874544352293, 0.00573047017678618, 0.00572214415296912, 0.00571378972381353, 0.00570538360625505, 0.00569686200469732, 0.0056883180513978, 0.00567964417859912, 0.00567087531089783, 0.00566223682835698, 0.00565343862399459, 0.00564453192055225, 0.00563558889552951, 0.00562657974660397, 0.00561749143525958, 0.00560846785083413, 0.00559927057474852, 0.00559002161026001, 0.00558074424043298, 0.00557136535644531, 0.00556187005713582, 0.00555244693532586, 0.00554292276501656, 0.00553330359980464, 0.00552361225709319, 0.00551379006356001, 0.00550401164218783, 0.00549415964633226, 0.00548434443771839, 0.00547433318570256, 0.0054642716422677, 0.00545410020276904, 0.00544392922893167, 0.00543368561193347, 0.00542344199493527, 0.00541313225403428, 0.00540274381637573, 0.00539223849773407, 0.0053816381841898, 0.00537103926762938, 0.0053604026325047, 0.00534975994378328, 0.00533898547291756, 0.00532808061689138, 0.00531715387478471, 0.00530617637559772, 0.0052951336838305, 0.00528405467048287, 0.00527299707755446, 0.00526172155514359, 0.00525043904781342, 0.00523906899616122, 0.00522770639508963, 0.0052162422798574, 0.00520471250638366, 0.0051931687630713, 0.00518149323761463, 0.00516978977248073, 0.00515803508460522, 0.00514617841690779, 0.00513432919979095, 0.0051223854534328, 0.00511033274233341, 0.00509829446673393, 0.00508614769205451, 0.00507389102131128, 0.00506172142922878, 0.00504937162622809, 0.00503699900582433, 0.00502449553459883, 0.00501202186569571, 0.00499938055872917, 0.00498681236058474, 0.00497413473203778, 0.00496136303991079, 0.00494852522388101, 0.00493565900251269, 0.00491652265191078, 0.00489472784101963, 0.00487293256446719, 0.0048509631305933, 0.00482899323105812, 0.00480690784752369, 0.00478479312732816, 0.00476254755631089, 0.00474040303379297, 0.00471809972077608, 0.0046957521699369, 0.0046733757480979, 0.00465085403993726, 0.00462830392643809, 0.00460582552477717, 0.00458321627229452, 0.00456050597131252, 0.00453775189816952, 0.00451486697420478, 0.00449198158457875, 0.00446914089843631, 0.00444618333131075, 0.00442316709086299, 0.00440002139657736, 0.00437684543430805, 0.00435359682887793, 0.00433047953993082, 0.00430714432150126, 0.00428375136107206, 0.00426021218299866, 0.00423671724274755, 0.00421312032267451, 0.00418953783810139, 0.00416601356118917, 0.0041422713547945, 0.004118412733078, 0.00409452570602298, 0.00407066708430648, 0.00404669251292944, 0.00402279058471322, 0.00399862695485353, 0.00397453550249338, 0.00395034346729517, 0.00392601964995265, 0.00390175450593233, 0.00387750379741192, 0.00385300605557859, 0.00382855208590627, 0.00380401057191193, 0.00377939664758742, 0.0037547389511019, 0.0037301832344383, 0.00370533647947013, 0.00368051906116307, 0.00365562923252583, 0.00363066629506648, 0.00360565981827676, 0.00358065380714834, 0.0035555602516979, 0.00353036494925618, 0.00350514077581465, 0.0034798439592123, 0.00345453224144876, 0.00342911924235523, 0.00340361893177032, 0.00337820569984615, 0.00335261807776988, 0.00332703068852425, 0.00330131244845688, 0.00327549246139824, 0.00324971601366997, 0.00322398310527205, 0.00319804716855288, 0.00317205279134214, 0.00314605818130076, 0.00311988964676857, 0.00309370644390583, 0.00306763919070363, 0.00304138334468007, 0.00301502575166523, 0.00298868282698095, 0.00296216527931392, 0.00293566239997745, 0.00290923193097115, 0.00288264220580459, 0.00285597937181592, 0.00282917125150561, 0.00280240690335631, 0.00277554057538509, 0.00274870358407497, 0.0027218519244343, 0.00269481143914163, 0.00266771274618804, 0.00264055607840419, 0.00261339941062033, 0.00258611189201474, 0.00255899853073061, 0.00253160926513374, 0.00250410381704569, 0.00247665657661855, 0.00244906800799072, 0.00242239073850214, 0.00239587319083512, 0.00236950116232038, 0.00234324531629682, 0.00231716362759471, 0.00229100929573178, 0.00226504378952086, 0.00223923847079277, 0.00221351999789476, 0.00218784529715776, 0.00216234521940351, 0.0021369606256485, 0.00211160560138524, 0.00208641053177416, 0.00206131697632372, 0.00203622365370393, 0.00201146421022713, 0.0019866032525897, 0.00196191621944308, 0.00193737493827939, 0.00191305147018284, 0.00188859738409519, 0.00186433200724423, 0.00184031366370618, 0.00181615015026182, 0.00179230619687587, 0.00176843313965946, 0.00174473458901048, 0.0017211667727679, 0.00169767148327082, 0.00167426327243447, 0.0016509861452505, 0.00162782508414239, 0.00160470767877996, 0.00158182275481522, 0.00155893771443516, 0.00153609632980078, 0.00151356018614024, 0.00149098038673401, 0.00146861840039492, 0.00144622754305601, 0.00142406905069947, 0.0014018815709278, 0.00137991202063859, 0.00135798600967973, 0.00133619084954262, 0.0013145845150575, 0.00129296374507248, 0.0012714882614091, 0.00125017249956727, 0.00122894393280149, 0.00120777357369661, 0.00118673383258283, 0.00116583949420601, 0.00114501791540533, 0.00112426886335015, 0.00110356346704066, 0.00108309043571353, 0.00106279191095382, 0.00104239152278751, 0.00102218019310385, 0.00100212858524173, 0.000982251367531717, 0.00096230156486854, 0.000942511484026909, 0.000922910345252603, 0.000903469044715166, 0.000883925997186452, 0.000864629982970655, 0.00084531947504729, 0.000826284929644316, 0.00080727954627946, 0.00078837585169822, 0.000769501202739775, 0.000750902632717043, 0.000732347660232335, 0.000713865330908448, 0.000695397553499788, 0.00067720579681918, 0.000659072189591825, 0.000640996731817722, 0.000622993858996779, 0.000605121778789908, 0.000587496731895953, 0.000569857191294432, 0.000552304845768958, 0.000534926715772599, 0.000517723092343658, 0.000500432215631008, 0.000483286683447659, 0.000466373603558168, 0.000449475075583905, 0.000432765431469306, 0.000416055758250877, 0.000399418757297099, 0.000383130478439853, 0.000366769556421787, 0.000350510352291167, 0.000334309239406139, 0.000324834429193288, 0.000315448007313535, 0.000306206871755421, 0.000297081947792321, 0.000288102397462353, 0.000279384286841378, 0.000270608114078641, 0.000262035377090797, 0.000253578880801797, 0.000245267641730607, 0.000236985491937958, 0.000228964869165793, 0.00022097333567217, 0.000213039893424138, 0.000205426142201759, 0.000197783316252753, 0.000190227656275965, 0.000182904492248781, 0.000175755689269863, 0.000168665006640367, 0.000161574309458956, 0.000154861409100704, 0.000148032268043607, 0.000141464683110826, 0.000134868008899502, 0.000128561950987205, 0.000122343073599041, 0.000116182309284341, 0.000110195913293865, 0.000104296705103479, 9.86299710348248e-05, 9.29922971408814e-05, 8.74417964951135e-05, 8.21237917989492e-05, 7.68638929002918e-05, 7.16911745257676e-05, 6.67218919261359e-05, 6.17235418758355e-05, 5.69286166864913e-05, 5.2453346143011e-05, 4.79199625260662e-05, 4.33865752711426e-05, 3.92600304621737e-05, 3.50753616658039e-05, 3.10941213683691e-05, 2.70838208962232e-05, 2.33931805269094e-05, 1.97025383386062e-05, 1.61862590175588e-05, 1.27280991364387e-05, 9.4443012130796e-06, 6.30580643701251e-06, 3.25449218507856e-06, 3.77534803419621e-07, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 1.97162948571965e-15, 2.61518550814799e-07, 9.00841371276329e-07, 1.68546432632866e-06, 2.52820814239385e-06, 3.40001201948326e-06, 4.47523734692368e-06, 5.52140181753202e-06, 6.74192779115401e-06, 7.8752727858955e-06, 9.15391956368694e-06, 1.05197459561168e-05, 1.19436926979688e-05, 1.34548208734486e-05, 1.50821897477726e-05, 1.67386169778183e-05, 1.84241071110591e-05, 2.03130148292985e-05, 2.21438040171051e-05, 2.41489542531781e-05, 2.61541063082404e-05, 2.82464388874359e-05, 3.04259465337964e-05, 3.26926383422688e-05, 3.49593319697306e-05, 3.74294431821909e-05, 3.98414413211867e-05, 4.23987330577802e-05, 4.50722691311967e-05, 4.77458015666343e-05, 5.0564638513606e-05, 5.33253514731769e-05, 5.62313689442817e-05, 5.92826872889418e-05, 6.23049418209121e-05, 6.54725008644164e-05, 6.86981729813851e-05, 7.19529125490226e-05, 7.52948326407932e-05, 7.87239332566969e-05, 8.22692672954872e-05, 8.58727289596573e-05, 8.94761906238273e-05, 9.31377726374194e-05, 9.70027685980313e-05, 0.000100867771834601, 0.000104878083220683, 0.00010888838005485, 0.00011298585741315, 0.000117112409498077, 0.000121413315355312, 0.000125656093587168, 0.000130102300317958, 0.000134606627398171, 0.000139110939926468, 0.000143760567880236, 0.000148410210385919, 0.000153147004311904, 0.00015802911366336, 0.000162911223014817, 0.000167909573065117, 0.000172966043464839, 0.000178109694388695, 0.000183282390935346, 0.000188600402907468, 0.000193918429431506, 0.000199381742277183, 0.000204874100745656, 0.000210424594115466, 0.000216149448533542, 0.000221874288399704, 0.000227628202992491, 0.000233527418458834, 0.000239455694099888, 0.000245529256062582, 0.000251631892751902, 0.000257734558545053, 0.000264040572801605, 0.000270346645265818, 0.000276710808975622, 0.000283191242488101, 0.000289729796350002, 0.000296297366730869, 0.000303039327263832, 0.000309752242174, 0.000316668563755229, 0.00032349769026041, 0.000334570795530453, 0.000345671840477735, 0.000356801872840151, 0.000367902917787433, 0.00037903297925368, 0.000390192115446553, 0.000401264085667208, 0.000412423192756251, 0.000423582387156785, 0.000434712419519201, 0.0004459006304387, 0.000457117945188656, 0.000468364247353747, 0.000479465263197199, 0.000490682490635663, 0.000501899747177958, 0.000513117061927915, 0.000524421455338597, 0.000535609666258097, 0.000546797877177596, 0.00055810232879594, 0.000569319585338235, 0.000580594991333783, 0.000591928488574922, 0.000603174732532352, 0.000614537333603948, 0.0006257836939767, 0.00063711719121784, 0.000648392539005727, 0.000659755081869662, 0.000671117682941258, 0.000682451180182397, 0.000693813781253994, 0.000705176265910268, 0.000716509763151407, 0.000727930513676256, 0.000739293056540191, 0.000750713748857379, 0.000762076233513653, 0.000773496925830841, 0.00078491767635569, 0.000796309264842421, 0.000807817210443318, 0.000819208740722388, 0.000830687524285167, 0.000842166366055608, 0.000853616103995591, 0.000865123991388828, 0.000876573729328811, 0.000888023467268795, 0.000899589445907623, 0.000911097333300859, 0.00092263420810923, 0.00093411304987967, 0.000945620879065245, 0.000957157812081277, 0.000968752836342901, 0.000980347860604525, 0.000991884851828218, 0.00100342172663659, 0.00101498770527542, 0.00102655368391424, 0.00103817775379866, 0.00104983104392886, 0.00106148421764374, 0.0010730791836977, 0.00108464527875185, 0.001096356427297, 0.00110792252235115, 0.00111969187855721, 0.00113128696102649, 0.0011429691221565, 0.00115468050353229, 0.00116633356083184, 0.00117807392962277, 0.0011897562071681, 0.00120146758854389, 0.00121323682833463, 0.00122489000204951, 0.00123665935825557, 0.0012484579347074, 0.00126014009583741, 0.00127193855587393, 0.00128367892466486, 0.00129550648853183, 0.00130730494856834, 0.00131910340860486, 0.00133090186864138, 0.00134272943250835, 0.00135449878871441, 0.00136638444382697, 0.00137818278744817, 0.00139006855897605, 0.00140189612284303, 0.00141381088178605, 0.0014256383292377, 0.00143752398435026, 0.00144940963946283, 0.00146126619074494, 0.00147321005351841, 0.00148660666309297, 0.00149480160325766, 0.00150288047734648, 0.00151090102735907, 0.00151886348612607, 0.00152676785364747, 0.00153449806384742, 0.00154234422370791, 0.00154995801858604, 0.00155768799595535, 0.00156518560834229, 0.00157279928680509, 0.00158012262545526, 0.0015875039389357, 0.00159482704475522, 0.00160197599325329, 0.0016092408914119, 0.00161627354100347, 0.00162330607417971, 0.00163028051611036, 0.00163719686679542, 0.00164405512623489, 0.00165079720318317, 0.00165742286480963, 0.0016641648253426, 0.00167067430447787, 0.00167730008251965, 0.00168363528791815, 0.00169002846814692, 0.0016963635571301, 0.00170258246362209, 0.00170880137011409, 0.0017149040941149, 0.00172089040279388, 0.00172687682788819, 0.00173280516173691, 0.00173867528792471, 0.00174448743928224, 0.00175012508407235, 0.00175587902776897, 0.00176134239882231, 0.00176698004361242, 0.00177238532342017, 0.001777732395567, 0.00178313755895942, 0.00178836833219975, 0.0017935992218554, 0.00179871392901987, 0.00180371210444719, 0.00180876872036606, 0.00181365082971752, 0.00181853293906897, 0.00182335695717484, 0.00182800658512861, 0.00183277239557356, 0.00183724774979055, 0.00184189737774432, 0.0018463145243004, 0.00185084796976298, 0.00185509084258229, 0.00185933359898627, 0.00186357635539025, 0.00186770281288773, 0.00187182950321585, 0.00187583977822214, 0.00187967577949166, 0.00188368605449796, 0.00188740575686097, 0.00189124175813049, 0.00189484527800232, 0.00189839047379792, 0.00190205220133066, 0.00190542312338948, 0.0019089684356004, 0.00191228126641363, 0.00191553612239659, 0.00191879086196423, 0.00192192930262536, 0.00192506785970181, 0.00192809011787176, 0.00193093798588961, 0.00193396024405956, 0.00193669192958623, 0.00193953991401941, 0.00194215530063957, 0.00194477080367506, 0.0019473860738799, 0.00194988527800888, 0.00195238448213786, 0.00195465120486915, 0.00195691781118512, 0.00195918465033174, 0.00196133507415652, 0.00196348549798131, 0.00196551973931491, 0.00196743756532669, 0.00196941383183002, 0.00197121547535062, 0.00197307532653213, 0.00197470281273127, 0.00197644648142159, 0.0019779575522989, 0.00197946862317622, 0.00198092171922326, 0.00198231660760939, 0.00198365352116525, 0.00198487401939929, 0.00198597810231149, 0.00198714062571526, 0.00198818673379719, 0.00198923307470977, 0.00199016276746988, 0.00199091830290854, 0.00199179025366902, 0.00199248781427741, 0.00199324311688542, 0.00199370831251144, 0.00199423125013709, 0.00199475442059338, 0.00199516140855849, 0.00199550995603204, 0.0019957423210144, 0.00199585873633623, 0.0019960911013186, 0.0019960911013186, 0.00199620751664042, 0.00199603312648833, 0.00199585873633623, 0.0019957423210144, 0.00199539377354085, 0.00199521938338876, 0.00199469621293247, 0.00199423125013709, 0.00199376628734171, 0.00199312716722488, 0.00199254578910768, 0.00199179025366902, 0.00199091830290854, 0.00199016276746988, 0.00198917463421822, 0.00198830291628838, 0.00198719883337617, 0.00198603630997241, 0.00198487401939929, 0.00198353710584342, 0.00198237458243966, 0.00198092171922326, 0.00197958503849804, 0.0019779575522989, 0.00197638827376068   }, 
   { 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 2.04257823593109e-15, 1.61183777436236e-06, 4.22301491198596e-06, 6.8986660153314e-06, 9.60655415838119e-06, 1.23789150165976e-05, 1.51835129145184e-05, 1.80203460331541e-05, 2.09216559596825e-05, 2.38874363276409e-05, 2.6949928724207e-05, 2.9980183171574e-05, 3.30749098793603e-05, 3.62663522537332e-05, 3.94577909901273e-05, 4.2745941755129e-05, 4.60663286503404e-05, 4.94189480377827e-05, 5.28682794538327e-05, 5.6285374739673e-05, 5.98314181843307e-05, 6.34097013971768e-05, 6.70202207402326e-05, 7.07274448359385e-05, 7.44346689316444e-05, 7.82063725637272e-05, 8.20747809484601e-05, 8.5943189333193e-05, 8.98760699783452e-05, 9.38411976676434e-05, 9.78707976173609e-05, 0.000101997095043771, 0.000106123407022096, 0.000110314176708926, 0.000114569440484047, 0.000118792449939065, 0.000123176650959067, 0.000127528604934923, 0.000132009517983533, 0.000136458183987997, 0.000141035809065215, 0.000145645666634664, 0.000150255524204113, 0.000154962079250254, 0.000159700895892456, 0.000164504162967205, 0.000169371924130246, 0.000174271903233603, 0.000179204129381105, 0.000184233067557216, 0.000189294223673642, 0.000194387641386129, 0.000199545524083078, 0.000204767871764489, 0.000210054698982276, 0.000215341540751979, 0.000220725079998374, 0.000226108619244769, 0.000231556623475626, 0.000237101354287006, 0.000242678317590617, 0.000248287484282628, 0.000253896694630384, 0.00025966705288738, 0.000265437440248206, 0.000271207827609032, 0.000277107144938782, 0.000283006491372362, 0.000289002520730719, 0.000295030768029392, 0.000301123538520187, 0.000307216279907152, 0.000313405762426555, 0.000319659680826589, 0.00032594584627077, 0.000332264258759096, 0.000338647107128054, 0.000345094478689134, 0.000351574039086699, 0.000358118122676387, 0.000364694424206391, 0.000371335190720856, 0.000378040451323614, 0.000384777929866686, 0.000391579873394221, 0.00039834959898144, 0.000405312748625875, 0.000412243622122332, 0.000419206771766767, 0.00042626666254364, 0.000433358713053167, 0.000440483039710671, 0.000447704078396782, 0.000454957335023209, 0.000462242867797613, 0.000469625083496794, 0.000477007270092145, 0.000484486197819933, 0.000491997401695698, 0.000499540765304118, 0.000507180928252637, 0.000516045023687184, 0.000526280142366886, 0.000536467006895691, 0.000546685943845659, 0.000556905055418611, 0.000567107927054167, 0.00057734310394153, 0.00058751372853294, 0.000597748905420303, 0.000607984082307667, 0.000618154706899077, 0.00062838988378644, 0.000638576690107584, 0.000648795685265213, 0.000659014738630503, 0.000669233733788133, 0.00067943666363135, 0.000689639651682228, 0.000699858588632196, 0.000710093765519559, 0.000720280571840703, 0.000730499566998333, 0.000740734743885696, 0.000750937615521252, 0.000761156727094203, 0.000771359598729759, 0.00078157865209505, 0.000791813712567091, 0.000802000577095896, 0.000812235753983259, 0.000822422560304403, 0.000832609250210226, 0.000842876674141735, 0.000853031233418733, 0.000863266410306096, 0.000873501587193459, 0.000883688335306942, 0.000893907388672233, 0.000904110260307789, 0.000914345437195152, 0.000924564490560442, 0.000934751296881586, 0.000944986357353628, 0.000955189345404506, 0.000965392158832401, 0.000975627393927425, 0.000985830323770642, 0.000996049377135932, 0.00100625224877149, 0.00101645523682237, 0.00102670642081648, 0.00103689322713763, 0.00104711228050292, 0.00105731515213847, 0.00106751802377403, 0.00107776932418346, 0.0010879480978474, 0.00109815900214016, 0.0011083863209933, 0.00111858907621354, 0.00112881616223603, 0.00113903521560133, 0.00114922202192247, 0.00115944910794497, 0.00116965197958052, 0.00117987103294581, 0.0011900900863111, 0.00120028492528945, 0.00121050397865474, 0.00122073118109256, 0.00123094208538532, 0.00124116102233529, 0.00125138007570058, 0.00126159109640867, 0.00127180211711675, 0.00128202105406672, 0.00129219179507345, 0.00130241888109595, 0.00131266214884818, 0.00132282474078238, 0.00133305985946208, 0.00134327088017017, 0.00135347375180572, 0.00136370887048542, 0.0013739038258791, 0.0013841389445588, 0.00139434181619436, 0.00140455272048712, 0.00141478003934026, 0.00142499094363302, 0.00143518578261137, 0.0014454290503636, 0.00145563192199916, 0.00146583479363471, 0.001476053847, 0.00148624880239367, 0.00149649183731526, 0.00150666257832199, 0.0015169057296589, 0.0015271088341251, 0.00153559213504195, 0.00154319207649678, 0.00155075965449214, 0.00155824644025415, 0.00156571727711707, 0.00157311570364982, 0.00158046570140868, 0.00158778333570808, 0.00159502041060477, 0.00160222535487264, 0.00160938187036663, 0.00161645782645792, 0.001623525749892, 0.00163051299750805, 0.00163745996542275, 0.00164435862097889, 0.00165119278244674, 0.00165799481328577, 0.00166473223362118, 0.00167142134159803, 0.00167807820253074, 0.00168463832233101, 0.00169119029305875, 0.00169766193721443, 0.00170409306883812, 0.00171050021890551, 0.00171681062784046, 0.00172308052424341, 0.00172931840643287, 0.00173549156170338, 0.00174163258634508, 0.00174769316799939, 0.00175373756792396, 0.00175971747376025, 0.00176562485285103, 0.00177151605021209, 0.00177733472082764, 0.00178308901377022, 0.00178882700856775, 0.00179448467679322, 0.00180010998155922, 0.00180568685755134, 0.00181117514148355, 0.00181664736010134, 0.00182205496821553, 0.00182741449680179, 0.00183273351285607, 0.00183799595106393, 0.00184320227708668, 0.00184836820699275, 0.0018534695263952, 0.00185850658454001, 0.00186353549361229, 0.00186847581062466, 0.00187338376417756, 0.00187822734005749, 0.00188303063623607, 0.00188776932191104, 0.00189246784429997, 0.00189711805433035, 0.00190171971917152, 0.00190625712275505, 0.00191076216287911, 0.0019152028253302, 0.00191960309166461, 0.00192393898032606, 0.00192822644021362, 0.00193247362039983, 0.00193666433915496, 0.00194078264757991, 0.0019448846578598, 0.00194892229046673, 0.00195289542898536, 0.00195682025514543, 0.00196068058721721, 0.00196452485397458, 0.00196830462664366, 0.00197201990522444, 0.00197571096941829, 0.00197933753952384, 0.0019828996155411, 0.00198644562624395, 0.00198991131037474, 0.001993328332901, 0.00199671322479844, 0.00200001732446253, 0.00200330535881221, 0.00200651306658983, 0.00200965628027916, 0.00201279926113784, 0.00201584561727941, 0.00201885960996151, 0.00202182540670037, 0.002024743007496, 0.0020276119466871, 0.0020304003264755, 0.00203317264094949, 0.00203588069416583, 0.00203852402046323, 0.00204114336520433, 0.00204315385781229, 0.00204441091045737, 0.00204563606530428, 0.00204683700576425, 0.00204801349900663, 0.00204915786162019, 0.00205028615891933, 0.00205139024183154, 0.0020524540450424, 0.00205350969918072, 0.00205451715737581, 0.0020555246155709, 0.00205649971030653, 0.00205743475817144, 0.00205836142413318, 0.00205924781039357, 0.00206012628041208, 0.00206097261980176, 0.00206177844665945, 0.00206257635727525, 0.0020633339881897, 0.00206408347003162, 0.00206480058841407, 0.0020654855761677, 0.00206613843329251, 0.0020667752251029, 0.00206738780252635, 0.00206798384897411, 0.0020685400813818, 0.00206908001564443, 0.00206959573552012, 0.00207007140852511, 0.00207053869962692, 0.00207095802761614, 0.00207137688994408, 0.00207176385447383, 0.00207211845554411, 0.00207244884222746, 0.00207275501452386, 0.00207303720526397, 0.00207330309785903, 0.00207352079451084, 0.00207373034209013, 0.00207390752620995, 0.002074068877846, 0.00207419763319194, 0.00207429425790906, 0.00207437481731176, 0.00207440718077123, 0.00207444746047258, 0.00207443931140006, 0.00207440718077123, 0.00207436690106988, 0.00207428634166718, 0.00207418156787753, 0.00207406049594283, 0.00207389937713742, 0.00207372196018696, 0.00207352871075273, 0.0020732949487865, 0.00207304512150586, 0.00207275501452386, 0.00207245699129999, 0.002072126371786, 0.00207176385447383, 0.0020713850390166, 0.00207097409293056, 0.00207053869962692, 0.00207008747383952, 0.00206959573552012, 0.00206908816471696, 0.00206854823045433, 0.00206799223087728, 0.00206741178408265, 0.0020667752251029, 0.00206613843329251, 0.00206547765992582, 0.00206478429026902, 0.00206407532095909, 0.0020633339881897, 0.00206256797537208, 0.00206177844665945, 0.0020609563216567, 0.00206012628041208, 0.00205924781039357, 0.00205836142413318, 0.00205744244158268, 0.00205649971030653, 0.0020555246155709, 0.00205452530644834, 0.00205350969918072, 0.00205247011035681, 0.00205139024183154, 0.00205029407516122, 0.00204916601069272, 0.00204802956432104, 0.00204685307107866, 0.00204565213061869, 0.00204441091045737, 0.00204317783936858, 0.00204108632169664, 0.00203857175074518, 0.00203615403734148, 0.00203373632393777, 0.00203138310462236, 0.00202907808125019, 0.0020268214866519, 0.00202466151677072, 0.00202248571440578, 0.00202039023861289, 0.00201837555505335, 0.00201636063866317, 0.00201444257982075, 0.0020125568844378, 0.00201068702153862, 0.0020089300815016, 0.00200715707615018, 0.00200549699366093, 0.00200386880896986, 0.00200225715525448, 0.00200075819157064, 0.00199927506037056, 0.00199782475829124, 0.00199647061526775, 0.00199513277038932, 0.00199384335428476, 0.00199261819943786, 0.00199142564088106, 0.00199032947421074, 0.00198924960568547, 0.0019882342312485, 0.00198726705275476, 0.0019863483030349, 0.00198546168394387, 0.00198465585708618, 0.00198391452431679, 0.00198317295871675, 0.00198251218535006, 0.00198193173855543, 0.00198133545927703, 0.00198085187003016, 0.00198038457892835, 0.00197994918562472, 0.0019796269480139, 0.00197928841225803, 0.00197904673404992, 0.00197885325178504, 0.00197867606766522, 0.00197859550826252, 0.00197854707948864, 0.00197851494885981, 0.00197859550826252, 0.00197869213297963, 0.00197883718647063, 0.00197904673404992, 0.00197927234694362, 0.00197961088269949, 0.00197996548376977, 0.0019803682807833, 0.00198083580471575, 0.00198135152459145, 0.00198189960792661, 0.00198251218535006, 0.00198320532217622, 0.00198388216085732, 0.00198467215523124, 0.00198547798208892, 0.0019863483030349, 0.00198728311806917, 0.0019882342312485, 0.00198924960568547, 0.00199034577235579, 0.00199144170619547, 0.00199261819943786, 0.00199387571774423, 0.00199511670507491, 0.00199647061526775, 0.00199782475829124, 0.00199925899505615, 0.00200075819157064, 0.00200225715525448, 0.00200386880896986, 0.00200551305897534, 0.00200715707615018, 0.00200891401618719, 0.00201071915216744, 0.00201254081912339, 0.00201444257982075, 0.00201639300212264, 0.00201837555505335, 0.00202040653675795, 0.00202250177972019, 0.00202464545145631, 0.00202685385011137, 0.00202907808125019, 0.00203138310462236, 0.00203373632393777, 0.00203613797202706, 0.00203858804889023, 0.00204110238701105, 0.00204369379207492, 0.00204765889793634, 0.00205175299197435, 0.00205591134727001, 0.00206024735234678, 0.00206469604745507, 0.00206933822482824, 0.00207407679408789, 0.00207888032309711, 0.00208389293402433, 0.00208898633718491, 0.00209417659789324, 0.00209960853680968, 0.00210508843883872, 0.00211069756187499, 0.00211643590591848, 0.00212233513593674, 0.00212833122350276, 0.0021344400011003, 0.00214069406501949, 0.00214707688428462, 0.00215354026295245, 0.00216024555265903, 0.00216699903830886, 0.00217388174496591, 0.0021808932069689, 0.00218803365714848, 0.00219535129144788, 0.00220274971798062, 0.00221029319800436, 0.00221791700460017, 0.00222571822814643, 0.00223369686864316, 0.0022416755091399, 0.00224987976253033, 0.00225816457532346, 0.00226653018034995, 0.00227512116543949, 0.00228387326933444, 0.00229260930791497, 0.00230155512690544, 0.00231058150529861, 0.00231981719844043, 0.00232914974913001, 0.00233856285922229, 0.00234816945157945, 0.00235785660333931, 0.00236764037981629, 0.00237766583450139, 0.00238775624893606, 0.00239794282242656, 0.0024082746822387, 0.00241871946491301, 0.00242934166453779, 0.00244009238667786, 0.00245093996636569, 0.0024619004689157, 0.00247298995964229, 0.00248419214040041, 0.00249562016688287, 0.0025071285199374, 0.00251870159991086, 0.00253041950054467, 0.00254231481812894, 0.00255435542203486, 0.00256647611968219, 0.00257869414053857, 0.00259107304736972, 0.00260361284017563, 0.00261620152741671, 0.00262901559472084, 0.0026419423520565, 0.00265491753816605, 0.00266808620654047, 0.00268128700554371, 0.00269479444250464, 0.00270831794477999, 0.00272195413708687, 0.00273575121536851, 0.0027496290858835, 0.00276373280212283, 0.00277790077961981, 0.00279219774529338, 0.00280659110285342, 0.00282113021239638, 0.00283581390976906, 0.00285067479126155, 0.0028655685018748, 0.002880654996261, 0.00289579015225172, 0.0029111672192812, 0.00292660854756832, 0.00294217909686267, 0.00295789423398674, 0.00297365803271532, 0.00298964721150696, 0.0030057979747653, 0.00302198086865246, 0.00303832464851439, 0.00305476551875472, 0.00307403737679124, 0.00309459632262588, 0.0031152197625488, 0.00313594797626138, 0.00315675651654601, 0.0031776619143784, 0.00319878500886261, 0.00321993231773376, 0.00324112782254815, 0.00326246861368418, 0.0032839139457792, 0.00330544821918011, 0.00332712731324136, 0.00334887881763279, 0.0033707192633301, 0.00339265610091388, 0.0034147382248193, 0.00343694142065942, 0.00345921679399908, 0.00348153244704008, 0.00350401783362031, 0.0035265430342406, 0.00354928569868207, 0.00357204512692988, 0.00359491677954793, 0.00361786945722997, 0.00364092667587101, 0.00366412894800305, 0.00368745229206979, 0.00371084827929735, 0.0037343162111938, 0.00375790544785559, 0.00378155894577503, 0.0038054222241044, 0.00382928526960313, 0.00385328545235097, 0.00387739855796099, 0.00390155962668359, 0.00392592279240489, 0.00395033415406942, 0.00397483399137855, 0.00399943860247731, 0.00402414798736572, 0.00404896168038249, 0.00407390482723713, 0.00409892061725259, 0.00412403279915452, 0.00414925813674927, 0.00417458033189178, 0.0042000631801784, 0.0042255544103682, 0.00425120675936341, 0.00427688285708427, 0.004302728921175, 0.00432874402031302, 0.0043547423556447, 0.00438088644295931, 0.00440711062401533, 0.00443346425890923, 0.00445997109636664, 0.00448649330064654, 0.0045131528750062, 0.00453992560505867, 0.00456670625135303, 0.00459369644522667, 0.00462080771103501, 0.00464796693995595, 0.00467519881203771, 0.0047025759704411, 0.0047300411388278, 0.00475766789168119, 0.00478531932458282, 0.0048131151124835, 0.0048409840092063, 0.00486892461776733, 0.00489705102518201, 0.00492525054141879, 0.00495353015139699, 0.00498191453516483, 0.00501037901267409, 0.00503899762406945, 0.00506774429231882, 0.00509654032066464, 0.00512539176270366, 0.00515441270545125, 0.00518351420760155, 0.0052127530798316, 0.00524203944951296, 0.00527143944054842, 0.00530096050351858, 0.00533055374398828, 0.00536032440140843, 0.00539015140384436, 0.00542007479816675, 0.00545007921755314, 0.00548020424321294, 0.00551040144637227, 0.00554079236462712, 0.00557119213044643, 0.00560171995311975, 0.00563293555751443, 0.00566358491778374, 0.00569422589614987, 0.00572485057637095, 0.00575550785288215, 0.00578613253310323, 0.00581676559522748, 0.0058474144898355, 0.00587804755195975, 0.00590868014842272, 0.00593933695927262, 0.00596996210515499, 0.00600060308352113, 0.00603124406188726, 0.0060618850402534, 0.00609252601861954, 0.00612316699698567, 0.00615379214286804, 0.00618441728875041, 0.00621507409960032, 0.00624570716172457, 0.00627634022384882, 0.00630698911845684, 0.00633762171491981, 0.00636826315894723, 0.00639891205355525, 0.00642954465001822, 0.00646018562838435, 0.0064908186905086, 0.00652145175263286, 0.00655209273099899, 0.00658272486180067, 0.00661337468773127, 0.0066440156660974, 0.00667464826256037, 0.0067052892409265, 0.00673593068495393, 0.00676657166332006, 0.00679721217602491, 0.00682783732190728, 0.00685847830027342, 0.00688910344615579, 0.00691976025700569, 0.00695040123537183, 0.00698103383183479, 0.0070116831921041, 0.00704230787232518, 0.00707294931635261, 0.00710358982905746, 0.00713421497493982, 0.00716485548764467, 0.0071954969316721, 0.00722613791003823, 0.00725677842274308, 0.00728741986677051, 0.00731805246323347, 0.00734869390726089, 0.00737933488562703, 0.00740998331457376, 0.0074406168423593, 0.00747124943882227, 0.00750188250094652, 0.00753252347931266, 0.00756317237392068, 0.00759379705414176, 0.00762444641441107, 0.00765508692711592, 0.00768571998924017, 0.00771636934950948, 0.00774700241163373, 0.00777763547375798, 0.007808284368366, 0.0078389011323452, 0.00786955002695322, 0.00790018308907747, 0.00793082360178232, 0.00796146504580975, 0.00799210648983717, 0.00802274607121944, 0.0080533716827631, 0.00808402057737112, 0.00811465363949537, 0.00814527831971645, 0.00817593559622765, 0.0082065761089325, 0.00823720172047615, 0.00826785061508417, 0.00829848367720842, 0.0083291232585907, 0.00835977308452129, 0.00839040614664555, 0.0084210317581892, 0.00845167227089405, 0.0084823127835989, 0.00851295422762632, 0.00854358728975058, 0.0085742361843586, 0.00860486831516027, 0.0086355097591877, 0.00866615120321512, 0.00869634933769703, 0.00872687622904778, 0.00875729974359274, 0.00878765061497688, 0.00881787296384573, 0.00884798262268305, 0.00887802615761757, 0.00890795793384314, 0.00893778540194035, 0.00896749179810286, 0.00899711810052395, 0.0090266140177846, 0.009056038223207, 0.00908534973859787, 0.00911457184702158, 0.00914367474615574, 0.00917267147451639, 0.00920158717781305, 0.00923036597669125, 0.0092590656131506, 0.00928768329322338, 0.00931616500020027, 0.00934453401714563, 0.00937282107770443, 0.00940102059394121, 0.00942910648882389, 0.00945710390806198, 0.00948498025536537, 0.00951276067644358, 0.00954044330865145, 0.00956798996776342, 0.00959548819810152, 0.00962284859269857, 0.00965009722858667, 0.00967728905379772, 0.00970435980707407, 0.00973132532089949, 0.00975817907601595, 0.00978493504226208, 0.00981159508228302, 0.00983813405036926, 0.00986460875719786, 0.00989096984267235, 0.00991721916943789, 0.00994335487484932, 0.00996939465403557, 0.00999531988054514, 0.0100211575627327, 0.0100468834862113, 0.0100725116208196, 0.0100980512797832, 0.0101234782487154, 0.0101488083600998, 0.010174049064517, 0.0101991696283221, 0.0102241849526763, 0.0102491285651922, 0.0102739185094833, 0.0102986358106136, 0.0103232571855187, 0.0103477574884892, 0.0103721925988793, 0.0103964824229479, 0.0104207079857588, 0.010444805957377, 0.0104687819257379, 0.0104926927015185, 0.0105164842680097, 0.0105401705950499, 0.0105637516826391, 0.0105872442945838, 0.0106106242164969, 0.0106339063495398, 0.0106571083888412, 0.0106801996007562, 0.0107031753286719, 0.0107260476797819, 0.0107488315552473, 0.0107714841142297, 0.0107940500602126, 0.010816527530551, 0.0108389165252447, 0.01086116861552, 0.0108833219856024, 0.0109053961932659, 0.0109273418784142, 0.0109491981565952, 0.0109709585085511, 0.0109926210716367, 0.0110141634941101, 0.0110356081277132, 0.0110569661483169, 0.0110781854018569, 0.0110993329435587, 0.0111203594133258, 0.0111413057893515, 0.0111621301621199, 0.0111828492954373, 0.0112034976482391, 0.0112240081652999, 0.0112409414723516, 0.0112527403980494, 0.0112645057961345, 0.0112761911004782, 0.0112878615036607, 0.0112995151430368, 0.0113111203536391, 0.0113227088004351, 0.0113342655822635, 0.0113457906991243, 0.0113572832196951, 0.0113687431439757, 0.0113801714032888, 0.0113915670663118, 0.0114029133692384, 0.0114142298698425, 0.0114255286753178, 0.0114367958158255, 0.011448030360043, 0.0114592323079705, 0.0114704184234142, 0.0114815402776003, 0.01149264536798, 0.0115037346258759, 0.0115147763863206, 0.0115257678553462, 0.0115367770195007, 0.0115477228537202, 0.0115586342290044, 0.0115694981068373, 0.0115803619846702, 0.0115911616012454, 0.0116019444540143, 0.0116126788780093, 0.0116234617307782, 0.0116341486573219, 0.0116448188200593, 0.0116554405540228, 0.0116660138592124, 0.0116765890270472, 0.0116870813071728, 0.0116976071149111, 0.0117080509662628, 0.0117184650152922, 0.0117289256304502, 0.0117393052205443, 0.0117496373131871, 0.0117599368095398, 0.0117702204734087, 0.0117804547771811, 0.0117906583473086, 0.0118008460849524, 0.0118109993636608, 0.0118210893124342, 0.0118312276899815, 0.0118412850424647, 0.011851311661303, 0.0118612889200449, 0.0118712019175291, 0.0118811465799809, 0.0118910269811749, 0.0119008915498853, 0.0119107244536281, 0.0119205079972744, 0.011930275708437, 0.011940011754632, 0.0119497468695045, 0.0119594018906355, 0.0119690401479602, 0.0119786625728011, 0.0119882049039006, 0.0119977472350001, 0.0120072569698095, 0.0120167182758451, 0.0120261954143643, 0.0120355924591422, 0.012045037932694, 0.0120543548837304, 0.0120636560022831, 0.0120729552581906, 0.0120822070166469, 0.0120914438739419, 0.0121006146073341, 0.0121097853407264, 0.0121189085766673, 0.0121279833838344, 0.0121370740234852, 0.0121461171656847, 0.0121551100164652, 0.0121640563011169, 0.0121730025857687, 0.0121818827465177, 0.0121907647699118, 0.0121996132656932, 0.0122084142640233, 0.0122171994298697, 0.0122259184718132, 0.0122346710413694, 0.0122433435171843, 0.0122519824653864, 0.0122567303478718, 0.0122600989416242, 0.0122638549655676, 0.012268110178411, 0.0122726559638977, 0.0122773787006736, 0.0122824711725116, 0.0122879203408957, 0.0122937224805355, 0.0122997192665935, 0.0123061491176486, 0.0123128229752183, 0.0123198498040438, 0.0123271849006414, 0.012334824539721, 0.0123427705839276, 0.0123510714620352, 0.0123596945777535, 0.0123686417937279, 0.0123778600245714, 0.0123874992132187, 0.0123973311856389, 0.0124075189232826, 0.0124180922284722, 0.0124289402738214, 0.0124401096254587, 0.0124514894559979, 0.0124635454267263, 0.0124755054712296, 0.0124880783259869, 0.0125008756294847, 0.0125139160081744, 0.0125273251906037, 0.0125410426408052, 0.0125550488010049, 0.0125693790614605, 0.0125841107219458, 0.0125991012901068, 0.0126143814995885, 0.0126301441341639, 0.0126460380852222, 0.0126623008400202, 0.012678855098784, 0.0126957790926099, 0.0127130253240466, 0.0127304969355464, 0.0127484686672688, 0.0127666024491191, 0.0127851059660316, 0.0128039335832, 0.0128231793642044, 0.0128425527364016, 0.0128623303025961, 0.0128825586289167, 0.012902932241559, 0.0129236923530698, 0.0129448072984815, 0.0129661802202463, 0.0129878437146544, 0.0130098927766085, 0.0130322007462382, 0.0130548626184464, 0.0130778485909104, 0.0131011875346303, 0.0131247201934457, 0.0131486393511295, 0.0131729142740369, 0.0131974788382649, 0.0132223656401038, 0.0132476380094886, 0.013273105956614, 0.0132989594712853, 0.0133251352235675, 0.0133515857160091, 0.0133784227073193, 0.013405567035079, 0.0134331285953522, 0.0134608512744308, 0.0134888337925076, 0.0135173639282584, 0.0135460859164596, 0.0135750994086266, 0.0136045310646296, 0.0136341564357281, 0.0136641357094049, 0.0136945033445954, 0.0137251289561391, 0.0137560274451971, 0.0137873459607363, 0.0138189047574997, 0.0138508519157767, 0.0138830235227942, 0.0139156151562929, 0.0139484480023384, 0.0139816347509623, 0.0140151614323258, 0.0140489777550101, 0.0140830846503377, 0.0141176106408238, 0.014152392745018, 0.0141994012519717, 0.0142558785155416, 0.014312744140625, 0.014370028860867, 0.0144276041537523, 0.0144856292754412, 0.0145438807085156, 0.0146025512367487, 0.0146616091951728, 0.0147209893912077, 0.0147807244211435, 0.0148408776149154, 0.0149012887850404, 0.0149620538577437, 0.0150231756269932, 0.0150847481563687, 0.0151465777307749, 0.0152088915929198, 0.0152714615687728, 0.0153344525024295, 0.0153977004811168, 0.015461465343833, 0.0155254220589995, 0.0155897988006473, 0.015654755756259, 0.0157197136431932, 0.015785314142704, 0.0158510450273752, 0.0159172918647528, 0.0159837622195482, 0.0160506851971149, 0.0161179956048727, 0.0161855649203062, 0.0162534546107054, 0.0163218602538109, 0.0163904931396246, 0.0164595432579517, 0.0165289491415024, 0.0165987107902765, 0.0166687909513712, 0.016739197075367, 0.0168101172894239, 0.0168812293559313, 0.0169527307152748, 0.0170246846973896, 0.017096895724535, 0.0171695537865162, 0.0172425396740437, 0.0173157807439566, 0.0173894744366407, 0.0174637138843536, 0.017538083717227, 0.0176127757877111, 0.0176879204809666, 0.0177634507417679, 0.0178392399102449, 0.0179153829813004, 0.0179919768124819, 0.0180688630789518, 0.0181460678577423, 0.018223725259304, 0.0183017048984766, 0.0183800086379051, 0.0184586346149445, 0.018537774682045, 0.0186171103268862, 0.0186968315392733, 0.0187770016491413, 0.0188574977219105, 0.0189382489770651, 0.0190194882452488, 0.019101046025753, 0.019182862713933, 0.0192651953548193, 0.0193479135632515, 0.0194307621568441, 0.019514286890626, 0.0195979736745358, 0.0196820143610239, 0.0197663456201553, 0.019851190969348, 0.0199362318962812, 0.0200216583907604, 0.0201076027005911, 0.020193737000227, 0.0202802922576666, 0.0203672386705875, 0.0204544998705387, 0.0205420888960361, 0.0206300280988216, 0.0207184236496687, 0.0208071358501911, 0.0208961106836796, 0.0209855996072292, 0.0210753474384546, 0.0211654473096132, 0.021255936473608, 0.021346777677536, 0.02143794298172, 0.0215295609086752, 0.0216236691921949, 0.0217224061489105, 0.0218209568411112, 0.021919472143054, 0.0220177620649338, 0.0221158247441053, 0.0222136657685041, 0.0223114360123873, 0.0224091149866581, 0.0225065667182207, 0.0226038563996553, 0.0227009207010269, 0.0227978881448507, 0.0228946637362242, 0.0229912456125021, 0.0230876971036196, 0.0231840182095766, 0.023280119523406, 0.0233760867267847, 0.0234718602150679, 0.0235674418509007, 0.0236628968268633, 0.0237581878900528, 0.0238533187657595, 0.0239483211189508, 0.024043096229434, 0.0241376124322414, 0.024232130497694, 0.0243263933807611, 0.0244205240160227, 0.0245144926011562, 0.0246082693338394, 0.0247018840163946, 0.0247954037040472, 0.0248887278139591, 0.0249818600714207, 0.0250748321413994, 0.025167578831315, 0.0252602268010378, 0.025352681055665, 0.0254450049251318, 0.0255371388047934, 0.0256290771067142, 0.0257208868861198, 0.0258125029504299, 0.0259040240198374, 0.0259952880442142, 0.0260864831507206, 0.0261774249374866, 0.0262682009488344, 0.0263588521629572, 0.0264493077993393, 0.0265396349132061, 0.0266298335045576, 0.0267197079956532, 0.0268095210194588, 0.0268992036581039, 0.0269886273890734, 0.0270779561251402, 0.0271671544760466, 0.0272560641169548, 0.0273449085652828, 0.0274335909634829, 0.0275220796465874, 0.0276104100048542, 0.0276984814554453, 0.0277864206582308, 0.0278743002563715, 0.0279620476067066, 0.0280495379120111, 0.0281368680298328, 0.0282239690423012, 0.028310913592577, 0.0283977575600147, 0.0284844748675823, 0.0285709351301193, 0.0286571979522705, 0.0287433993071318, 0.0288294088095427, 0.0289152227342129, 0.0290008764714003, 0.0290863979607821, 0.0291716959327459, 0.0292568653821945, 0.0293418411165476, 0.0294266883283854, 0.0295113436877728, 0.0295959003269672, 0.0296801347285509, 0.0297643020749092, 0.0298483446240425, 0.0299322232604027, 0.0300158448517323, 0.0300993379205465, 0.0301826391369104, 0.030265873298049, 0.0303488522768021, 0.0304317642003298, 0.0305144507437944, 0.0305968821048737, 0.0306660886853933, 0.0307241473346949, 0.030781852081418, 0.0308392327278852, 0.0308962278068066, 0.030952850356698, 0.0310091357678175, 0.0310650989413261, 0.0311206746846437, 0.0311759449541569, 0.0312308929860592, 0.0312853902578354, 0.0313395634293556, 0.0313934311270714, 0.0314469113945961, 0.0315000377595425, 0.0315528251230717, 0.0316052585840225, 0.0316573344171047, 0.0317090936005116, 0.0317605100572109, 0.0318115241825581, 0.0318621508777142, 0.0319124758243561, 0.0319625213742256, 0.0320121310651302, 0.0320614092051983, 0.0321103110909462, 0.0321589075028896, 0.0322071015834808, 0.0322550386190414, 0.0323025546967983, 0.0323497466742992, 0.0323965102434158, 0.03244299441576, 0.0324891097843647, 0.0325348675251007, 0.0325803235173225, 0.0326252914965153, 0.0326700210571289, 0.0327144451439381, 0.0327584594488144, 0.0328021235764027, 0.0328454561531544, 0.0328883267939091, 0.0329309776425362, 0.032973226159811, 0.033015176653862, 0.0330567322671413, 0.0330979637801647, 0.0331387594342232, 0.0331792794167995, 0.033219400793314, 0.0332592092454433, 0.0332986675202847, 0.0333377756178379, 0.0333764925599098, 0.0334148965775967, 0.0334529541432858, 0.033490639179945, 0.0335279665887356, 0.0335648991167545, 0.0336015969514847, 0.0336378812789917, 0.0336738415062428, 0.0337094441056252, 0.033744677901268, 0.0337795130908489, 0.0338140726089478, 0.0338482223451138, 0.0338820852339268, 0.0339155979454517, 0.0339487232267857, 0.0339814424514771, 0.0340139046311378, 0.0340459644794464, 0.0340777300298214, 0.0341091006994247, 0.0341400653123856, 0.0341707542538643, 0.034201055765152, 0.0342310667037964, 0.0342607051134109, 0.0342899821698666, 0.0343188494443893, 0.0343474261462688, 0.03437564894557, 0.0344035290181637, 0.034431017935276, 0.034458190202713, 0.0344849489629269, 0.0345114469528198, 0.0345375426113605, 0.0345632992684841, 0.034588735550642, 0.0346137136220932, 0.0346384271979332, 0.0346628315746784, 0.0346868000924587, 0.0347105078399181, 0.0347357653081417, 0.0347575545310974, 0.0347793661057949, 0.0348011553287506, 0.034822903573513, 0.0348446108400822, 0.0348663106560707, 0.0348879732191563, 0.0349096171557903, 0.0349312163889408, 0.0349527820944786, 0.034974317997694, 0.0349958650767803, 0.0350173376500607, 0.0350387915968895, 0.0350602082908154, 0.0350816175341606, 0.0351030007004738, 0.0351243428885937, 0.0351456552743912, 0.0351669490337372, 0.0351882055401802, 0.0352094359695911, 0.0352306477725506, 0.0352518111467361, 0.0352729558944702, 0.0352940745651722, 0.0353151597082615, 0.0353362075984478, 0.0353572256863117, 0.0353782251477242, 0.0353991948068142, 0.035420149564743, 0.0354410745203495, 0.0354619584977627, 0.0354828201234341, 0.035503625869751, 0.0355244539678097, 0.0355451963841915, 0.0355659201741219, 0.0355866700410843, 0.0356073677539825, 0.0356280133128166, 0.0356486290693283, 0.0356691963970661, 0.0356898121535778, 0.0357103124260902, 0.035730816423893, 0.0357513502240181, 0.0357717722654343, 0.0357922129333019, 0.0358126163482666, 0.0358329564332962, 0.0358533151447773, 0.0358735881745815, 0.0358938984572887, 0.0359141603112221, 0.0359343886375427, 0.0359545685350895, 0.0359747186303139, 0.0359948500990868, 0.0360150150954723, 0.0360350459814072, 0.0360551476478577, 0.0360751487314701, 0.0360951535403728, 0.0361151397228241, 0.0361350141465664, 0.0361549220979214, 0.0361747965216637, 0.0361946821212769, 0.0362145267426968, 0.0362342745065689, 0.0362540632486343, 0.0362738072872162, 0.0362934917211533, 0.0363131724298, 0.0363328196108341, 0.0363524369895458, 0.0363720878958702, 0.0363916046917439, 0.0364111699163914, 0.0364306718111038, 0.0364501290023327, 0.0364695712924004, 0.0364889875054359, 0.0365083813667297, 0.0365277715027332, 0.036547064781189, 0.0365664213895798, 0.0365856513381004, 0.0366049148142338, 0.0366241298615932, 0.0366433188319206, 0.0366624891757965, 0.0366816222667694, 0.0367007069289684, 0.0367197878658772, 0.0367388240993023, 0.0367578603327274, 0.0367759428918362, 0.0367936305701733, 0.0368116982281208, 0.0368300750851631, 0.0368488319218159, 0.0368679352104664, 0.03688745200634, 0.0369072780013084, 0.0369274616241455, 0.0369479805231094, 0.0369688868522644, 0.0369901433587074, 0.0370117239654064, 0.0370337143540382, 0.0370560213923454, 0.0370786637067795, 0.0371016971766949, 0.0371251180768013, 0.0371488444507122, 0.0371729098260403, 0.0371973775327206, 0.0372221991419792, 0.0372473113238811, 0.0372728444635868, 0.0372987277805805, 0.0373249389231205, 0.0373514853417873, 0.0373784154653549, 0.0374057106673717, 0.0374333821237087, 0.0374613627791405, 0.0374897643923759, 0.0375184752047062, 0.0375475026667118, 0.03757693618536, 0.037606704980135, 0.0376368276774883, 0.0376673229038715, 0.0376981757581234, 0.0377293787896633, 0.0377609245479107, 0.0377928242087364, 0.037825059145689, 0.0378577150404453, 0.0378906913101673, 0.0379240214824677, 0.0379577465355396, 0.037991788238287, 0.0380261652171612, 0.0380608849227428, 0.0380959920585155, 0.0381314717233181, 0.0381672829389572, 0.0382034666836262, 0.0382399633526802, 0.0382768884301186, 0.038314089179039, 0.0383516773581505, 0.0383896231651306, 0.0384279489517212, 0.0384666211903095, 0.0385056436061859, 0.0385449826717377, 0.0385847501456738, 0.0386248007416725, 0.0386652462184429, 0.0387060232460499, 0.0387471877038479, 0.0387887097895145, 0.0388305373489857, 0.0388727523386478, 0.0389153510332108, 0.0389582291245461, 0.0390015058219433, 0.0390451699495316, 0.0390891544520855, 0.0391335152089596, 0.0391782261431217, 0.0392232611775398, 0.039268683642149, 0.0393143929541111, 0.0393605567514896, 0.0394070446491241, 0.0394538529217243, 0.0395010784268379, 0.0395485609769821, 0.0395964980125427, 0.0396447256207466, 0.0396933704614639, 0.0397423356771469, 0.0397916585206985, 0.0398413054645061, 0.039891354739666, 0.0399417206645012, 0.039992444217205, 0.0400435924530029, 0.0400950387120247, 0.0401468425989151, 0.0401990041136742, 0.0402514860033989, 0.0403123162686825, 0.0403789803385735, 0.0404462292790413, 0.0405139923095703, 0.0405822657048702, 0.0406509302556515, 0.040720209479332, 0.040789969265461, 0.0408602766692638, 0.0409310348331928, 0.0410023108124733, 0.0410741381347179, 0.0411463789641857, 0.0412191674113274, 0.0412924699485302, 0.0413662642240524, 0.0414405092597008, 0.0415154211223125, 0.0415907613933086, 0.0416665188968182, 0.0417428836226463, 0.0418197065591812, 0.0418970435857773, 0.0419748649001122, 0.0420532636344433, 0.0421321094036102, 0.042211476713419, 0.0422912985086441, 0.0423716977238655, 0.0424525439739227, 0.0425339117646217, 0.0426157936453819, 0.0426982566714287, 0.0427811667323112, 0.0428645275533199, 0.0429485067725182, 0.0430328361690044, 0.0431177839636803, 0.0432031787931919, 0.0432891882956028, 0.0433755479753017, 0.0434625223278999, 0.0435499474406242, 0.0436379238963127, 0.0437264107167721, 0.0438153520226479, 0.0439048744738102, 0.0439947508275509, 0.0440852679312229, 0.044176246970892, 0.044267762452364, 0.0443597063422203, 0.0444522574543953, 0.0445452891290188, 0.0446387752890587, 0.0447327755391598, 0.0448272973299026, 0.0449223294854164, 0.0450178161263466, 0.0451138839125633, 0.0452103987336159, 0.045307494699955, 0.0454050078988075, 0.0455030761659145, 0.0456016175448895, 0.0457007139921188, 0.0458002649247646, 0.045900359749794, 0.0460010059177876, 0.0461020655930042, 0.0462037101387978, 0.0463057346642017, 0.0464083440601826, 0.0465113446116447, 0.0466150157153606, 0.046719141304493, 0.0468237809836864, 0.0469289049506187, 0.0470345765352249, 0.0471406988799572, 0.0472472757101059, 0.0473545305430889, 0.04746213555336, 0.0475703552365303, 0.0476789884269238, 0.0477881729602814, 0.0478978119790554, 0.0480080284178257, 0.0481187291443348, 0.048229917883873, 0.0483416467905045, 0.0484538599848747, 0.0485665947198868, 0.0486797466874123, 0.048793476074934, 0.0489076897501945, 0.0490224547684193, 0.0491376705467701, 0.0492534637451172, 0.0493696741759777, 0.04949951171875, 0.0496432855725288, 0.0497869960963726, 0.0499304160475731, 0.0500737428665161, 0.0502168759703636, 0.0503599122166634, 0.0505027510225773, 0.0506454259157181, 0.0507879480719566, 0.0509303659200668, 0.0510725975036621, 0.0512145683169365, 0.051356602460146, 0.0514983795583248, 0.0516398958861828, 0.051781352609396, 0.0519226752221584, 0.0520639084279537, 0.0522047467529774, 0.0523456558585167, 0.0524862743914127, 0.0526268556714058, 0.0527671836316586, 0.0529074147343636, 0.0530475117266178, 0.0531873591244221, 0.0533271357417107, 0.0534666888415813, 0.0536061450839043, 0.053745374083519, 0.0538845062255859, 0.054023515433073, 0.054162323474884, 0.0543009713292122, 0.0544394664466381, 0.0545777939260006, 0.05471595749259, 0.0548540577292442, 0.0549919679760933, 0.0551296807825565, 0.0552672035992146, 0.0554046295583248, 0.0555418916046619, 0.0556789636611938, 0.0558159053325653, 0.0559527538716793, 0.0560893341898918, 0.0562258549034595, 0.0563621558248997, 0.0564983561635017, 0.0566343627870083, 0.056770209223032, 0.0569058582186699, 0.057041447609663, 0.0571769066154957, 0.0573120415210724, 0.0574472099542618, 0.0575821213424206, 0.0577169023454189, 0.0578514598309994, 0.0579859502613544, 0.0581203103065491, 0.0582544170320034, 0.0583884231746197, 0.058522205799818, 0.0586559921503067, 0.0587894506752491, 0.0589228123426437, 0.059056106954813, 0.0591891184449196, 0.0593220330774784, 0.0594547837972641, 0.0595874711871147, 0.0597198009490967, 0.059852097183466, 0.0599843002855778, 0.0601162165403366, 0.0602480322122574, 0.060379683971405, 0.0605112463235855, 0.0606425777077675, 0.0607737489044666, 0.0609048195183277, 0.0610357671976089, 0.0611664541065693, 0.0612970441579819, 0.0614274740219116, 0.0615577399730682, 0.0616877861320972, 0.0618177615106106, 0.0619475804269314, 0.0620772987604141, 0.0622067637741566, 0.0623360984027386, 0.0624652691185474, 0.0625943168997765, 0.0627231299877167, 0.0628518536686897, 0.062980480492115, 0.0630916953086853, 0.0631880536675453, 0.0632835999131203, 0.0633784681558609, 0.0634726658463478, 0.0635660290718079, 0.0636586397886276, 0.0637506097555161, 0.0638419017195702, 0.063932329416275, 0.0640220791101456, 0.0641111508011818, 0.0641993507742882, 0.0642869025468826, 0.064373716711998, 0.064459852874279, 0.0645451471209526, 0.0646298080682755, 0.0647136569023132, 0.0647968575358391, 0.0648792162537575, 0.0649609416723251, 0.0650418847799301, 0.065122090280056, 0.0652016177773476, 0.0652803033590317, 0.0653583183884621, 0.0654356479644775, 0.0655121877789497, 0.0655880123376846, 0.0656630843877792, 0.0657374560832977, 0.0658110827207565, 0.0658839717507362, 0.0659561231732368, 0.0660275146365166, 0.0660982802510262, 0.0661681368947029, 0.0662374123930931, 0.0663058906793594, 0.0663736462593079, 0.0664406046271324, 0.066506952047348, 0.0665725767612457, 0.0666373446583748, 0.0667013674974442, 0.0667647793889046, 0.0668274089694023, 0.0668893083930016, 0.0669503957033157, 0.067010834813118, 0.0670705735683441, 0.0671295300126076, 0.0671877786517143, 0.0672452598810196, 0.0673020333051682, 0.0673580318689346, 0.0674133449792862, 0.067467950284481, 0.067521758377552, 0.0675748139619827, 0.0676272064447403, 0.0676788836717606, 0.0677297189831734, 0.0677798092365265, 0.0678293630480766, 0.0678780078887939, 0.067925937473774, 0.0679731965065002, 0.0680197551846504, 0.0680655315518379, 0.0681104958057404, 0.0681548863649368, 0.0681983754038811, 0.0682412162423134, 0.0682832822203636, 0.0683247372508049, 0.0683653578162193, 0.0684052035212517, 0.0684443712234497, 0.0684828609228134, 0.0685205459594727, 0.0685574933886528, 0.0685936883091927, 0.0686293169856071, 0.0686639696359634, 0.0686980411410332, 0.068731278181076, 0.0687639713287354, 0.0687957778573036, 0.068826861679554, 0.0688572898507118, 0.0688869431614876, 0.0689158067107201, 0.0689439177513123, 0.0689715072512627, 0.0689981654286385, 0.0690241530537605, 0.0690493285655975, 0.0690738931298256, 0.0690830796957016, 0.0690792426466942, 0.0690753906965256, 0.069071389734745, 0.0690672323107719, 0.0690629109740257, 0.0690584629774094, 0.0690539255738258, 0.069049172103405, 0.0690443441271782, 0.0690393224358559, 0.0690342858433723, 0.0690289884805679, 0.0690235793590546, 0.0690181404352188, 0.069012463092804, 0.069006659090519, 0.0690007507801056, 0.0689947009086609, 0.0689884796738625, 0.0689821094274521, 0.0689756125211716, 0.0689690560102463, 0.0689622759819031, 0.0689553543925285, 0.0689483284950256, 0.0689412355422974, 0.06893390417099, 0.0689264684915543, 0.0689188614487648, 0.0689112097024918, 0.0689033940434456, 0.0688954144716263, 0.0688872560858727, 0.0688790902495384, 0.0688706859946251, 0.0688621401786804, 0.068853534758091, 0.0688447579741478, 0.0688357725739479, 0.0688266828656197, 0.068817563354969, 0.0688081756234169, 0.0687986984848976, 0.068789079785347, 0.068779394030571, 0.0687694996595383, 0.0687594413757324, 0.068749263882637, 0.0687390565872192, 0.0687285661697388, 0.0687180310487747, 0.0687073245644569, 0.0686965137720108, 0.0686855167150497, 0.0686744153499603, 0.0686632096767426, 0.0686518326401711, 0.0686402842402458, 0.0686286091804504, 0.0686169043183327, 0.0686049237847328, 0.0685928538441658, 0.0685806125402451, 0.0685683488845825, 0.0685558915138245, 0.0685432627797127, 0.0685304924845695, 0.068517655134201, 0.0685046389698982, 0.0684915035963058, 0.0684782043099403, 0.0684648305177689, 0.0684512406587601, 0.0684375315904617, 0.0684236884117126, 0.068409763276577, 0.0683956444263458, 0.0683813914656639, 0.0683670565485954, 0.0683525502681732, 0.0683379024267197, 0.0683230683207512, 0.0683082044124603, 0.0682931169867516, 0.0682779178023338, 0.0682625696063042, 0.0682471841573715, 0.0682315304875374, 0.0682158172130585, 0.068199910223484, 0.0681839659810066, 0.0681677982211113, 0.068151518702507, 0.068135067820549, 0.068118579685688, 0.0681018233299255, 0.0680849924683571, 0.0680680721998215, 0.0680509582161903, 0.0680426061153412, 0.0680451020598412, 0.0680481567978859, 0.0680519416928291, 0.0680562853813171, 0.0680612921714783, 0.0680669173598289, 0.068073183298111, 0.0680800527334213, 0.068087562918663, 0.0680957287549973, 0.0681044608354568, 0.0681138187646866, 0.0681238099932671, 0.0681344866752625, 0.0681456997990608, 0.0681576430797577, 0.068170078098774, 0.0681832730770111, 0.0681970864534378, 0.0682114362716675, 0.0682264864444733, 0.0682420656085014, 0.0682584121823311, 0.0682752355933189, 0.0682928413152695, 0.0683109238743782, 0.0683297365903854, 0.0683491304516792, 0.0683692097663879, 0.0683898255228996, 0.0684111043810844, 0.068433053791523, 0.0684555694460869, 0.0684787854552269, 0.0685025453567505, 0.0685269609093666, 0.0685519948601723, 0.0685776844620705, 0.0686039626598358, 0.0686309188604355, 0.0686584115028381, 0.0686866492033005, 0.0687154680490494, 0.0687449127435684, 0.0687750205397606, 0.0688056275248528, 0.0688369795680046, 0.0688688829541206, 0.0689015090465546, 0.0689346790313721, 0.0689684599637985, 0.0690029188990593, 0.0690380111336708, 0.0690737143158913, 0.0691099762916565, 0.069146953523159, 0.0691845268011093, 0.0692227408289909, 0.0692615583539009, 0.069301076233387, 0.0693410784006119, 0.0693818479776382, 0.0694232359528542, 0.069465197622776, 0.0695077627897263, 0.069550946354866, 0.0695948526263237, 0.0696392878890038, 0.0696843862533569, 0.0697300806641579, 0.0697764605283737, 0.0698234289884567, 0.0698710307478905, 0.0699192211031914, 0.0699681043624878, 0.0700176134705544, 0.0700676813721657, 0.0701184719800949, 0.0701698362827301, 0.0702218189835548, 0.0702743977308273, 0.0703277066349983, 0.0703815370798111, 0.0704360529780388, 0.0704911798238754, 0.0705469250679016, 0.0706033110618591, 0.0706603080034256, 0.0707179605960846, 0.0707761645317078, 0.0708350613713264, 0.0708945691585541, 0.070954717695713, 0.0710154250264168, 0.0710768476128578, 0.0711389034986496, 0.0712015479803085, 0.0712648183107376, 0.071328692138195, 0.0714007988572121, 0.0714816823601723, 0.0715632066130638, 0.0716453120112419, 0.0717282295227051, 0.0718117877840996, 0.0718961134552956, 0.0719810873270035, 0.0720667466521263, 0.0721531435847282, 0.0722401514649391, 0.0723280310630798, 0.0724164173007011, 0.0725055858492851, 0.0725953951478004, 0.0726859867572784, 0.0727771818637848, 0.0728691145777702, 0.072961799800396, 0.073055125772953, 0.0731491595506668, 0.0732438713312149, 0.0733392611145973, 0.0734353885054588, 0.0735321938991547, 0.073629654943943, 0.0737279057502747, 0.0738267377018929, 0.0739263445138931, 0.0740266740322113, 0.0741276443004608, 0.0742293745279312, 0.0743316635489464, 0.0744348242878914, 0.074538491666317, 0.0746429786086082, 0.0747480988502502, 0.0748539641499519, 0.0749605074524879, 0.0750677883625031, 0.0751757472753525, 0.0752843543887138, 0.0753937363624573, 0.0755037218332291, 0.0756144598126411, 0.0757258683443069, 0.0758379921317101, 0.0759507492184639, 0.076064258813858, 0.0761784315109253, 0.0762933641672134, 0.0764089897274971, 0.0765252783894539, 0.0766422301530838, 0.0767598897218704, 0.0768783614039421, 0.0769973546266556, 0.0771171450614929, 0.0772375762462616, 0.0773587822914124, 0.0774805694818497, 0.0776031389832497, 0.0777264088392258, 0.0778503715991974, 0.0779750198125839, 0.0781003013253212, 0.0782263725996017, 0.0783530697226524, 0.0784804970026016, 0.0786085724830627, 0.0787374228239059, 0.0788668841123581, 0.0789970904588699, 0.0791280642151833, 0.0792596191167831, 0.0793919190764427, 0.0795248597860336, 0.0796586200594902, 0.0797929465770721, 0.0799279883503914, 0.0800637602806091, 0.0802002847194672, 0.0803373903036118, 0.0804752707481384, 0.0806138888001442, 0.0807530581951141, 0.0808930620551109, 0.0810336694121361, 0.0811750292778015, 0.0813170000910759, 0.0814597383141518, 0.0816031321883202, 0.08174729347229, 0.0818920731544495, 0.0820376127958298, 0.082183875143528, 0.0823306813836098, 0.0824783593416214, 0.0826265811920166, 0.0827756151556969, 0.0829196497797966, 0.0830575600266457, 0.0831961780786514, 0.0833356007933617, 0.0834756419062614, 0.0836163833737373, 0.0837577655911446, 0.0838999375700951, 0.0840428695082664, 0.084186427295208, 0.0843306556344032, 0.0844755917787552, 0.0846212357282639, 0.0847676172852516, 0.0849147140979767, 0.0850624591112137, 0.0852109119296074, 0.0853601023554802, 0.0855100005865097, 0.0856606066226959, 0.0858118310570717, 0.0859638229012489, 0.0861165076494217, 0.0862699151039124, 0.0864240005612373, 0.0865787193179131, 0.086734227836132, 0.0868904367089272, 0.0870474055409431, 0.0872049778699875, 0.0873632282018661, 0.0875222459435463, 0.0876819789409637, 0.0878423973917961, 0.0880035161972046, 0.0881653353571892, 0.0883278101682663, 0.0884909629821777, 0.088654987514019, 0.0888195782899857, 0.0889848917722702, 0.0891509130597115, 0.0893176048994064, 0.0894851088523865, 0.0896532610058784, 0.0898220464587212, 0.0899915769696236, 0.0901617556810379, 0.0903327688574791, 0.0905043631792068, 0.0906767398118973, 0.090849757194519, 0.0910235419869423, 0.0911979079246521, 0.0913731455802917, 0.0915490016341209, 0.0917255282402039, 0.0919027999043465, 0.0920807421207428, 0.0922594666481018, 0.0924387723207474, 0.0926188379526138, 0.0927995964884758, 0.0929810479283333, 0.0931633189320564, 0.0933461263775826, 0.0935297161340714, 0.0937139913439751, 0.0938989594578743, 0.0940846726298332, 0.0942710638046265, 0.0944581404328346, 0.0946459099650383, 0.0948344469070435, 0.0950236320495605, 0.0952135473489761, 0.0954040884971619, 0.0955953821539879, 0.095787413418293, 0.0959801971912384, 0.0961735472083092, 0.0963676422834396, 0.096562422811985, 0.0967579632997513, 0.0969542264938354, 0.0971511229872704, 0.0973487719893456, 0.0975470542907715, 0.0977460592985153, 0.09794582426548, 0.0981462448835373, 0.0983473658561707, 0.0985492020845413, 0.0987516790628433, 0.0989549979567528, 0.0991588830947876, 0.0993635952472687, 0.0995688736438751, 0.0997749418020248, 0.0999816432595253, 0.100204356014729, 0.100439302623272, 0.100674718618393, 0.100910492241383, 0.101146794855595, 0.101383440196514, 0.101620525121689, 0.10185794532299, 0.102095857262611, 0.102334149181843, 0.102572970092297, 0.102812021970749, 0.103051625192165, 0.103291556239128, 0.103531964123249, 0.103772766888142, 0.104014001786709, 0.104255616664886, 0.104497656226158, 0.10474006831646, 0.104983001947403, 0.105226278305054, 0.105469979345798, 0.105714090168476, 0.105958603322506, 0.106203638017178, 0.106448955833912, 0.106694743037224, 0.106940902769566, 0.107187509536743, 0.107434578239918, 0.107682041823864, 0.107929863035679, 0.108178101480007, 0.10842677205801, 0.108675949275494, 0.10892541706562, 0.109175361692905, 0.10942567884922, 0.109676413238049, 0.109927661716938, 0.110179260373116, 0.110431216657162, 0.110683627426624, 0.110936433076859, 0.111189767718315, 0.111443400382996, 0.111697465181351, 0.111951947212219, 0.112206846475601, 0.112462192773819, 0.112717926502228, 0.112974084913731, 0.113230615854263, 0.113487586379051, 0.113744966685772, 0.114002831280231, 0.114261046051979, 0.114519663155079, 0.114778704941273, 0.115038156509399, 0.115298114717007, 0.11555840075016, 0.115819096565247, 0.116080239415169, 0.116341762244701, 0.116603799164295, 0.116866134107113, 0.117128938436508, 0.117392115294933, 0.11765568703413, 0.11791980266571, 0.118184246122837, 0.118449069559574, 0.118714354932308, 0.118980057537556, 0.119246207177639, 0.119512692093849, 0.119779631495476, 0.120046965777874, 0.120314739644527, 0.120582938194275, 0.120851553976536, 0.121120557188988, 0.121389955282211, 0.12165979295969, 0.121930085122585, 0.122200801968575, 0.122471831738949, 0.122743345797062, 0.12301529943943, 0.123287633061409, 0.123560361564159, 0.123833499848843, 0.124107100069523, 0.124381050467491, 0.124655492603779, 0.124930307269096, 0.125205516815186, 0.125481173396111, 0.125766053795815, 0.126058578491211, 0.126350417733192, 0.126641422510147, 0.12693165242672, 0.127221211791039, 0.127509921789169, 0.127797856926918, 0.128085166215897, 0.128371596336365, 0.128657266497612, 0.128942251205444, 0.129226431250572, 0.129509821534157, 0.12979257106781, 0.130074456334114, 0.130355551838875, 0.130635991692543, 0.130915582180023, 0.131194427609444, 0.131472617387772, 0.13174994289875, 0.132026508450508, 0.132302343845367, 0.132577404379845, 0.132851675152779, 0.133125305175781, 0.133398070931435, 0.133670076727867, 0.133941382169724, 0.134211868047714, 0.134481623768806, 0.134750604629517, 0.135018885135651, 0.135286301374435, 0.135553017258644, 0.135819032788277, 0.136084213852882, 0.136348620057106, 0.136612311005592, 0.136875212192535, 0.137137353420258, 0.137398824095726, 0.137659445405006, 0.137919276952744, 0.138178437948227, 0.138436779379845, 0.13869434595108, 0.138951256871223, 0.139207318425179, 0.13946259021759, 0.139717191457748, 0.139970988035202, 0.140224009752274, 0.140476375818253, 0.140727832913399, 0.140978589653969, 0.141228601336479, 0.141477838158607, 0.141726300120354, 0.141974091529846, 0.142221048474312, 0.142467230558395, 0.142712712287903, 0.142957374453545, 0.143201291561127, 0.143444463610649, 0.143686875700951, 0.143928498029709, 0.144169375300407, 0.144409582018852, 0.144648909568787, 0.144887492060661, 0.145125404000282, 0.145362436771393, 0.145598769187927, 0.145834401249886, 0.146069183945656, 0.146303221583366, 0.146536558866501, 0.146769046783447, 0.147000804543495, 0.147231876850128, 0.147462114691734, 0.14769159257412, 0.147920355200768, 0.148148313164711, 0.148375496268272, 0.148602023720741, 0.1488276720047, 0.149052605032921, 0.149276807904243, 0.149500206112862, 0.149722844362259, 0.149944826960564, 0.150165930390358, 0.150386288762093, 0.150605872273445, 0.150824800133705, 0.151042878627777, 0.151231780648232, 0.151393428444862, 0.151553779840469, 0.151712954044342, 0.151871040463448, 0.152027860283852, 0.152183473110199, 0.152337968349457, 0.152491196990013, 0.152643278241158, 0.152794241905212, 0.152943909168243, 0.153092414140701, 0.153239786624908, 0.153385877609253, 0.153530851006508, 0.153674647212029, 0.153817251324654, 0.153958648443222, 0.154098823666573, 0.15423783659935, 0.154375657439232, 0.154512360692024, 0.154647797346115, 0.154782101511955, 0.154915198683739, 0.155047044157982, 0.155177757143974, 0.155307292938232, 0.155435621738434, 0.15556275844574, 0.155688717961311, 0.155813559889793, 0.155937105417252, 0.15605953335762, 0.156180739402771, 0.156300708651543, 0.156419575214386, 0.156537264585495, 0.156653702259064, 0.156768992543221, 0.156883105635643, 0.156995981931686, 0.157107695937157, 0.157218277454376, 0.157327577471733, 0.157435759902, 0.15754272043705, 0.157648488879204, 0.157753080129623, 0.157856523990631, 0.157958701252937, 0.158059731125832, 0.158159583806992, 0.158258229494095, 0.158355697989464, 0.15845200419426, 0.158547058701515, 0.158640995621681, 0.158733725547791, 0.158825278282166, 0.158915594220161, 0.159004777669907, 0.159092769026756, 0.159179508686066, 0.159265086054802, 0.159349516034126, 0.159432739019394, 0.159514769911766, 0.159595638513565, 0.159675255417824, 0.159753754734993, 0.159831061959267, 0.159907132387161, 0.159982025623322, 0.16005577147007, 0.1601282954216, 0.160199642181396, 0.16026982665062, 0.160338804125786, 0.160406574606895, 0.160473182797432, 0.160538583993912, 0.160602807998657, 0.160665884613991, 0.160727709531784, 0.160788387060165, 0.16084785759449, 0.160906136035919, 0.160963237285614, 0.161019220948219, 0.16107389330864, 0.161127433180809, 0.161179795861244, 0.161230981349945, 0.161280959844589, 0.161329761147499, 0.16137732565403, 0.161423742771149, 0.161468967795372, 0.161496102809906, 0.161507129669189, 0.161518231034279, 0.161529511213303, 0.161540940403938, 0.161552488803864, 0.16156417131424, 0.16157603263855, 0.161587968468666, 0.161600098013878, 0.16161236166954, 0.161624759435654, 0.16163732111454, 0.161649942398071, 0.16166278719902, 0.161675751209259, 0.161688849329948, 0.16170209646225, 0.161715492606163, 0.161728993058205, 0.161742612719536, 0.161756426095963, 0.16177037358284, 0.161784470081329, 0.161798715591431, 0.161813035607338, 0.16182753443718, 0.161842197179794, 0.16185699403286, 0.161871924996376, 0.161886975169182, 0.161902159452438, 0.161917522549629, 0.16193300485611, 0.161948651075363, 0.161964431405067, 0.161980301141739, 0.161996334791183, 0.162012547254562, 0.162028878927231, 0.162045329809189, 0.162061929702759, 0.162078678607941, 0.162095576524734, 0.16211262345314, 0.162129804491997, 0.162147089838982, 0.162164524197578, 0.16218213737011, 0.162199884653091, 0.162217751145363, 0.162235781550407, 0.162253901362419, 0.162272199988365, 0.162290647625923, 0.162309229373932, 0.16232793033123, 0.162346795201302, 0.162365809082985, 0.162384927272797, 0.16240419447422, 0.162423640489578, 0.162443190813065, 0.162462890148163, 0.162482708692551, 0.162502691149712, 0.162522822618484, 0.162543088197708, 0.162563487887383, 0.162584006786346, 0.162604689598083, 0.162625521421432, 0.162646487355232, 0.162667587399483, 0.162688851356506, 0.162710204720497, 0.162731736898422, 0.162753418087959, 0.162775203585625, 0.162797152996063, 0.162819236516953, 0.162841469049454, 0.162863820791245, 0.162886336445808, 0.162909016013145, 0.16293178498745, 0.162954673171043, 0.162977769970894, 0.163000985980034, 0.163024336099625, 0.163047835230827, 0.163071468472481, 0.163095220923424, 0.16311913728714, 0.163143172860146, 0.163167372345924, 0.163191735744476, 0.163216158747673, 0.163240790367126, 0.163265570998192, 0.163314029574394, 0.163387343287468, 0.163461863994598, 0.163537532091141, 0.163614422082901, 0.163692489266396, 0.163771778345108, 0.163852229714394, 0.163933768868446, 0.164016604423523, 0.164100632071495, 0.164185807108879, 0.164272204041481, 0.164359763264656, 0.164448484778404, 0.164538472890854, 0.164629608392715, 0.164721891283989, 0.16481539607048, 0.164910078048706, 0.165005952119827, 0.165102988481522, 0.165201246738434, 0.165300697088242, 0.165401324629784, 0.165503159165382, 0.165606111288071, 0.165710300207138, 0.16581566631794, 0.165922209620476, 0.166030004620552, 0.166138872504234, 0.166249021887779, 0.166360348463058, 0.166472852230072, 0.166586548089981, 0.166701376438141, 0.166817411780357, 0.166934683918953, 0.167053133249283, 0.167172759771347, 0.167293593287468, 0.167415544390678, 0.167538732290268, 0.167663082480431, 0.16778863966465, 0.167915403842926, 0.168043285608292, 0.168172419071198, 0.168302774429321, 0.168434217572212, 0.168566927313805, 0.168700814247131, 0.168835878372192, 0.168972045183182, 0.169109493494034, 0.169248104095459, 0.169387921690941, 0.169528901576996, 0.169671088457108, 0.169814452528954, 0.169958978891373, 0.17010472714901, 0.170251652598381, 0.170399725437164, 0.17054907977581, 0.170699551701546, 0.170851245522499, 0.171004116535187, 0.17115817964077, 0.171313360333443, 0.171469792723656, 0.171627402305603, 0.171786203980446, 0.171946182847023, 0.172107368707657, 0.172269746661186, 0.172433286905289, 0.172598019242287, 0.172763973474503, 0.172931060194969, 0.173099339008331, 0.17326882481575, 0.173439487814903, 0.173611357808113, 0.173784419894218, 0.173958659172058, 0.174134030938148, 0.174310654401779, 0.174488484859467, 0.174667418003082, 0.174847602844238, 0.175028964877129, 0.175211474299431, 0.175395205616951, 0.175580129027367, 0.175766259431839, 0.175953537225723, 0.176142036914825, 0.17633168399334, 0.176550656557083, 0.176797538995743, 0.177044585347176, 0.177291795611382, 0.177539214491844, 0.17778679728508, 0.178034543991089, 0.178282424807549, 0.178530499339104, 0.178778767585754, 0.179027184844017, 0.179275795817375, 0.179524585604668, 0.179773524403572, 0.180022642016411, 0.180271938443184, 0.180521383881569, 0.180771008133888, 0.181020811200142, 0.18127079308033, 0.181520953774452, 0.181771278381348, 0.182021796703339, 0.182272464036942, 0.182523295283318, 0.182774305343628, 0.183025494217873, 0.18327684700489, 0.183528378605843, 0.183780074119568, 0.18403197824955, 0.184284031391144, 0.184536263346672, 0.184788659214973, 0.185041218996048, 0.185293942689896, 0.185546830296516, 0.185799926519394, 0.186053171753883, 0.186306610703468, 0.186560198664665, 0.186813965439796, 0.187067911028862, 0.187322050333023, 0.187576338648796, 0.187830790877342, 0.188085421919823, 0.188340231776237, 0.188595220446587, 0.188850343227386, 0.189105659723282, 0.189361155033112, 0.189616829156876, 0.189872652292252, 0.190128698945045, 0.190384864807129, 0.190641209483147, 0.19089774787426, 0.191154465079308, 0.191411361098289, 0.191668376326561, 0.191925585269928, 0.192182987928391, 0.192440554499626, 0.192698270082474, 0.192956194281578, 0.193214267492294, 0.193472504615784, 0.19373095035553, 0.193989545106888, 0.194248303771019, 0.194507256150246, 0.194766387343407, 0.19502566754818, 0.195285096764565, 0.195544764399529, 0.195804566144943, 0.196064531803131, 0.196324691176414, 0.19658499956131, 0.196845486760139, 0.197106167674065, 0.197366982698441, 0.197627976536751, 0.197889193892479, 0.198150545358658, 0.19841206073761, 0.198673754930496, 0.198935613036156, 0.19919764995575, 0.1994598954916, 0.199722275137901, 0.199984848499298, 0.200247570872307, 0.200510486960411, 0.200773566961288, 0.201036795973778, 0.201300248503685, 0.201563850045204, 0.201827615499496, 0.202069506049156, 0.202288001775742, 0.202505439519882, 0.202721804380417, 0.202937066555023, 0.203151285648346, 0.203364446759224, 0.203576520085335, 0.20378752052784, 0.203997433185577, 0.20420628786087, 0.204414069652557, 0.2046207934618, 0.204826414585114, 0.205030977725983, 0.205234482884407, 0.205436885356903, 0.205638229846954, 0.205838531255722, 0.2060377150774, 0.206235870718956, 0.206432908773422, 0.206628903746605, 0.206823825836182, 0.20701764523983, 0.207210421562195, 0.207402110099792, 0.207592740654945, 0.207782298326492, 0.207970768213272, 0.208158180117607, 0.208344504237175, 0.208529770374298, 0.208713963627815, 0.208897083997726, 0.209079131484032, 0.209260106086731, 0.209439992904663, 0.20961882174015, 0.209796577692032, 0.209973275661469, 0.210148870944977, 0.21032340824604, 0.210496872663498, 0.210669279098511, 0.210840597748756, 0.211010843515396, 0.21118001639843, 0.211348116397858, 0.211515158414841, 0.211681127548218, 0.211846023797989, 0.212009832262993, 0.212172567844391, 0.212334230542183, 0.21249483525753, 0.21265435218811, 0.212812796235085, 0.212970197200775, 0.213126495480537, 0.213281735777855, 0.213435888290405, 0.213588982820511, 0.213741019368172, 0.213891968131065, 0.214041814208031, 0.214190647006035, 0.214338377118111, 0.214485019445419, 0.214630603790283, 0.214775115251541, 0.214918568730354, 0.215060919523239, 0.21520222723484, 0.215342462062836, 0.215481594204903, 0.215619668364525, 0.215756684541702, 0.215892627835274, 0.216027483344078, 0.216161251068115, 0.21629399061203, 0.216425627470016, 0.216556206345558, 0.216685697436333, 0.216814115643501, 0.216941490769386, 0.217067763209343, 0.217192962765694, 0.217317119240761, 0.217440187931061, 0.217562153935432, 0.217683091759682, 0.217802956700325, 0.21792171895504, 0.21803942322731, 0.218156054615974, 0.218271613121033, 0.218386098742485, 0.218499511480331, 0.218590319156647, 0.218659311532974, 0.218727722764015, 0.218795582652092, 0.218862861394882, 0.218929573893547, 0.218995705246925, 0.219061240553856, 0.219126239418983, 0.219190642237663, 0.219254478812218, 0.219317734241486, 0.219380423426628, 0.219442531466484, 0.219504058361053, 0.219565019011497, 0.219625398516655, 0.219685211777687, 0.219744458794594, 0.219803109765053, 0.219861194491386, 0.219918712973595, 0.219975650310516, 0.220032006502151, 0.220087796449661, 0.220142990350723, 0.220197647809982, 0.220251724123955, 0.220305219292641, 0.220358118414879, 0.220410481095314, 0.22046223282814, 0.220513418316841, 0.220564037561417, 0.220614090561867, 0.220663547515869, 0.220712453126907, 0.220760762691498, 0.220808506011963, 0.220855683088303, 0.220902279019356, 0.220948308706284, 0.220993772149086, 0.221038624644279, 0.22108294069767, 0.221126645803452, 0.221169799566269, 0.2212123721838, 0.221254393458366, 0.221295803785324, 0.221336677670479, 0.221376940608025, 0.221416652202606, 0.221455782651901, 0.22149433195591, 0.221532315015793, 0.221569702029228, 0.221606552600861, 0.221642792224884, 0.221678465604782, 0.221713587641716, 0.221748113632202, 0.221782073378563, 0.221815466880798, 0.221848264336586, 0.221880510449409, 0.221912175416946, 0.221943244338036, 0.221973776817322, 0.222003698348999, 0.222033068537712, 0.222061857581139, 0.22209008038044, 0.222117707133293, 0.222144782543182, 0.222171261906624, 0.22219717502594, 0.222222521901131, 0.222247287631035, 0.222271472215652, 0.222295090556145, 0.22231812775135, 0.222340598702431, 0.222362518310547, 0.222383826971054, 0.222404584288597, 0.222424745559692, 0.222444325685501, 0.222463369369507, 0.222481817007065, 0.222499683499336, 0.222516968846321, 0.222533717751503, 0.222549855709076, 0.222565427422523, 0.222580432891846, 0.222594857215881, 0.22260870039463, 0.222621992230415, 0.222634688019753, 0.222655922174454, 0.22268633544445, 0.222717195749283, 0.222748458385468, 0.222780153155327, 0.222812250256538, 0.222844779491425, 0.222877740859985, 0.222911104559898, 0.222944900393486, 0.222979128360748, 0.223013743758202, 0.223048821091652, 0.223084285855293, 0.223120182752609, 0.223156496882439, 0.223193243145943, 0.223230391740799, 0.223267987370491, 0.223305970430374, 0.223344400525093, 0.223383277654648, 0.223422542214394, 0.223462224006653, 0.223502323031425, 0.223542883992195, 0.223583832383156, 0.22362519800663, 0.223666980862617, 0.223709210753441, 0.223751857876778, 0.223794892430305, 0.223838403820992, 0.223882302641869, 0.223926603794098, 0.223971366882324, 0.224016532301903, 0.224062129855156, 0.224108129739761, 0.224154561758041, 0.224201411008835, 0.224248692393303, 0.224296376109123, 0.224344506859779, 0.224393025040627, 0.22444199025631, 0.224491387605667, 0.224541187286377, 0.2245914041996, 0.224642053246498, 0.224693104624748, 0.224744588136673, 0.224796488881111, 0.224848836660385, 0.224901586771011, 0.224954754114151, 0.225008353590965, 0.225062340497971, 0.225116789340973, 0.225171655416489, 0.225226938724518, 0.22528263926506, 0.225338757038116, 0.225395292043686, 0.225452244281769, 0.225509628653526, 0.225567445158958, 0.225625678896904, 0.225684314966202, 0.225743383169174, 0.225802883505821, 0.22586278617382, 0.225923120975494, 0.225983887910843, 0.226045042276382, 0.226106628775597, 0.226168662309647, 0.22623111307621, 0.226293966174126, 0.226357251405716, 0.22642095386982, 0.226485073566437, 0.226549610495567, 0.226614594459534, 0.226679965853691, 0.226745784282684, 0.226812019944191, 0.226878672838211, 0.226945757865906, 0.227013230323792, 0.227081164717674, 0.227149486541748, 0.227218240499496, 0.227287426590919, 0.227357029914856, 0.227427065372467, 0.22749750316143, 0.227568343281746, 0.227639645338058, 0.227711349725723, 0.227800503373146, 0.227906823158264, 0.228013560175896, 0.228120669722557, 0.228228166699409, 0.228336051106453, 0.228444308042526, 0.228552922606468, 0.228661939501762, 0.22877137362957, 0.228881150484085, 0.228991314768791, 0.229101866483688, 0.229212790727615, 0.229324132204056, 0.229435831308365, 0.229547902941704, 0.229660391807556, 0.229773253202438, 0.229886472225189, 0.230000093579292, 0.230114087462425, 0.230228468775749, 0.230343267321587, 0.23045839369297, 0.230573952198029, 0.230689838528633, 0.230806156992912, 0.230922847986221, 0.231039881706238, 0.231157347559929, 0.231275171041489, 0.231393396854401, 0.231511995196342, 0.231630966067314, 0.231750339269638, 0.231870085000992, 0.231990218162537, 0.232110723853111, 0.232231616973877, 0.232352897524834, 0.232474580407143, 0.232596591114998, 0.232719033956528, 0.232841849327087, 0.232965022325516, 0.233088597655296, 0.23321259021759, 0.233336910605431, 0.233461633324623, 0.233586743474007, 0.23371222615242, 0.233838111162186, 0.23396435379982, 0.234090998768806, 0.234218016266823, 0.234345436096191, 0.23447322845459, 0.234601393342018, 0.234729945659637, 0.234858885407448, 0.234988212585449, 0.235117897391319, 0.235247999429703, 0.235378459095955, 0.235509321093559, 0.235640540719032, 0.235772177577019, 0.235904172062874, 0.23603655397892, 0.236169338226318, 0.236302480101585, 0.236436024308205, 0.236569926142693, 0.236704245209694, 0.236838907003403, 0.236973971128464, 0.237109422683716, 0.237245261669159, 0.237381473183632, 0.237518057227135, 0.23765504360199, 0.237792432308197, 0.237930163741112, 0.238068297505379, 0.238206803798676, 0.238345697522163, 0.238484963774681, 0.238624647259712, 0.238764688372612, 0.238905116915703, 0.239045932888985, 0.239187121391296, 0.239328697323799, 0.239470645785332, 0.239612981677055, 0.239755719900131, 0.239898815751076, 0.240042313933372, 0.24018619954586, 0.240332275629044, 0.240479946136475, 0.240627214312553, 0.24077408015728, 0.240920528769493, 0.241066575050354, 0.241212204098701, 0.241357430815697, 0.24150225520134, 0.241646662354469, 0.241790652275085, 0.241934269666672, 0.242077425122261, 0.24222020804882, 0.242362573742867, 0.242504552006721, 0.242646113038063, 0.24278724193573, 0.242927968502045, 0.243068292737007, 0.243208214640617, 0.243347734212875, 0.243486806750298, 0.24362550675869, 0.24376380443573, 0.243901669979095, 0.244039133191109, 0.24417619407177, 0.244312837719917, 0.244449079036713, 0.244584918022156, 0.244720339775085, 0.244855344295502, 0.244989946484566, 0.245124161243439, 0.245257928967476, 0.245391324162483, 0.245524302124977, 0.245656862854958, 0.245789021253586, 0.245920762419701, 0.246052101254463, 0.246183037757874, 0.246313542127609, 0.246443659067154, 0.246573373675346, 0.246702656149864, 0.24683153629303, 0.246960029006004, 0.247088089585304, 0.247215747833252, 0.247343003749847, 0.247469827532768, 0.247596278786659, 0.247722327709198, 0.247847929596901, 0.247973144054413, 0.24809792637825, 0.248222336173058, 0.24834631383419, 0.248469904065132, 0.248593062162399, 0.248715817928314, 0.248838171362877, 0.248960107564926, 0.249081656336784, 0.249202772974968, 0.249323487281799, 0.249443784356117, 0.249563694000244, 0.249683201313019, 0.249802261590958, 0.249920934438705, 0.25003919005394, 0.250157058238983, 0.250274509191513, 0.25039154291153, 0.250508189201355, 0.250624388456345, 0.250740230083466, 0.250855624675751, 0.250970631837845, 0.251085221767426, 0.251199394464493, 0.251313149929047, 0.251426517963409, 0.251539468765259, 0.251652002334595, 0.25176414847374, 0.251875877380371, 0.251987218856812, 0.252098113298416, 0.25220862030983, 0.252318739891052, 0.252428412437439, 0.252537697553635, 0.252646535634995, 0.252755016088486, 0.252863079309464, 0.252970695495605, 0.253056228160858, 0.253119647502899, 0.253182679414749, 0.253245264291763, 0.253307461738586, 0.253369271755219, 0.253430634737015, 0.25349161028862, 0.253552168607712, 0.25361230969429, 0.253672063350677, 0.253731399774551, 0.253790318965912, 0.253848850727081, 0.253906965255737, 0.25396466255188, 0.254021972417831, 0.254078835248947, 0.254135310649872, 0.254191398620605, 0.254247039556503, 0.25430229306221, 0.254357159137726, 0.254411578178406, 0.254465609788895, 0.25451922416687, 0.254572421312332, 0.254625231027603, 0.254677623510361, 0.254729598760605, 0.254781186580658, 0.254832357168198, 0.254883110523224, 0.254933446645737, 0.254983395338058, 0.255032926797867, 0.255082070827484, 0.255130767822266, 0.255179077386856, 0.255226969718933, 0.255274474620819, 0.255321532487869, 0.255368202924728, 0.255414485931396, 0.255460351705551, 0.255505800247192, 0.25555083155632, 0.255595445632935, 0.255639672279358, 0.255683481693268, 0.255726903676987, 0.255769908428192, 0.255812466144562, 0.255854666233063, 0.25589644908905, 0.255937784910202, 0.255978763103485, 0.256019294261932, 0.256059437990189, 0.256099134683609, 0.256138473749161, 0.256177395582199, 0.256215870380402, 0.256253987550735, 0.256291657686234, 0.256328940391541, 0.256365805864334, 0.256402283906937, 0.256438314914703, 0.256473958492279, 0.256509214639664, 0.256544023752213, 0.25657844543457, 0.256612449884415, 0.256646066904068, 0.256679236888885, 0.256712019443512, 0.256744414567947, 0.256776392459869, 0.256807923316956, 0.256839096546173, 0.256869822740555, 0.256900161504745, 0.2569300532341, 0.256959587335587, 0.256988704204559, 0.257017403841019, 0.257045686244965, 0.257073551416397, 0.257101029157639, 0.257128089666367, 0.257154762744904, 0.257180988788605, 0.257206827402115, 0.257232278585434, 0.257257282733917, 0.257281929254532, 0.257306098937988, 0.257329910993576, 0.257353276014328, 0.257381767034531, 0.257415860891342, 0.25745016336441, 0.25748473405838, 0.257519543170929, 0.257554560899734, 0.257589846849442, 0.257625371217728, 0.257661163806915, 0.25769716501236, 0.257733404636383, 0.25776994228363, 0.257806658744812, 0.257843643426895, 0.257880866527557, 0.257918357849121, 0.257956057786942, 0.257993996143341, 0.258032202720642, 0.258070647716522, 0.258109301328659, 0.25814825296402, 0.258187413215637, 0.258226811885834, 0.258266448974609, 0.258306354284286, 0.258346498012543, 0.258386880159378, 0.258427500724792, 0.258468359708786, 0.258509457111359, 0.258550822734833, 0.258592396974564, 0.258634239435196, 0.258676320314407, 0.258718639612198, 0.258761197328568, 0.258803993463516, 0.258847057819366, 0.258890360593796, 0.258933871984482, 0.258977651596069, 0.259021669626236, 0.259065926074982, 0.259110450744629, 0.259155184030533, 0.259200155735016, 0.2592453956604, 0.259290874004364, 0.259336590766907, 0.259382516145706, 0.259428739547729, 0.259475201368332, 0.259521871805191, 0.259568810462952, 0.259615957736969, 0.259663373231888, 0.259711056947708, 0.259758919477463, 0.259807080030441, 0.259855449199677, 0.259904086589813, 0.259952962398529, 0.260002046823502, 0.260051399469376, 0.260100990533829, 0.260150849819183, 0.260200917720795, 0.260251253843307, 0.260301798582077, 0.260352611541748, 0.260403662919998, 0.260454952716827, 0.260506510734558, 0.260558277368546, 0.260610312223434, 0.26066255569458, 0.26071509718895, 0.260767847299576, 0.260820806026459, 0.260874062776566, 0.260927528142929, 0.260981261730194, 0.261035203933716, 0.261089414358139, 0.261143863201141, 0.261198550462723, 0.261253476142883, 0.261308670043945, 0.261364072561264, 0.261419743299484, 0.261475622653961, 0.261531800031662, 0.26158818602562, 0.261644810438156, 0.261701643466949, 0.261758804321289, 0.261816173791885, 0.261873751878738, 0.261931598186493, 0.26200658082962, 0.262098461389542, 0.262190371751785, 0.262282341718674, 0.262374252080917, 0.262466162443161, 0.262558072805405, 0.262650012969971, 0.262741893529892, 0.262833833694458, 0.262925714254379, 0.263017654418945, 0.263109534978867, 0.263201475143433, 0.263293355703354, 0.26338529586792, 0.263477206230164, 0.26356914639473, 0.263661086559296, 0.263752967119217, 0.263844907283783, 0.263936787843704, 0.26402872800827, 0.264120608568192, 0.264212548732758, 0.264304459095001, 0.264396369457245, 0.264488309621811, 0.264580190181732, 0.264672130346298, 0.264764010906219, 0.264855980873108, 0.264947891235352, 0.265039801597595, 0.265131741762161, 0.265223622322083, 0.265315562486649, 0.265407472848892, 0.265499383211136, 0.265591263771057, 0.265683203935623, 0.265775084495544, 0.26586702466011, 0.265958964824677, 0.266050845384598, 0.266142755746841, 0.266234695911407, 0.266326636075974, 0.266418516635895, 0.266510456800461, 0.266602367162704, 0.266694277524948, 0.266786187887192, 0.266878098249435, 0.266970008611679, 0.267061918973923, 0.267153859138489, 0.26724573969841, 0.267337679862976, 0.26742959022522, 0.267521530389786, 0.267613440752029, 0.267705351114273, 0.267797291278839, 0.26788917183876, 0.267981112003326, 0.26807302236557, 0.268164932727814, 0.268256843090057, 0.268348753452301, 0.268440663814545, 0.268532574176788, 0.268624484539032, 0.268716394901276, 0.268808305263519, 0.268900275230408, 0.268992185592651, 0.269084095954895, 0.269176006317139, 0.269267916679382, 0.269359827041626, 0.269451767206192, 0.269543647766113, 0.269635587930679, 0.269727498292923, 0.269819408655167, 0.26991131901741, 0.270003229379654, 0.270095139741898, 0.270187079906464, 0.270278990268707, 0.270370900630951, 0.270462810993195, 0.270554721355438, 0.270646661520004, 0.270738542079926, 0.270830482244492, 0.270922392606735, 0.271014302968979, 0.271106243133545, 0.271186828613281, 0.271255284547806, 0.271323293447495, 0.271390855312347, 0.271457999944687, 0.271524637937546, 0.271590769290924, 0.271656513214111, 0.27172178030014, 0.271786570549011, 0.271850913763046, 0.271914780139923, 0.271978229284286, 0.272041171789169, 0.272103667259216, 0.272165715694427, 0.272227346897125, 0.272288411855698, 0.272349089384079, 0.272409290075302, 0.272469073534012, 0.272528350353241, 0.272587180137634, 0.272645533084869, 0.272703438997269, 0.272760927677155, 0.272817850112915, 0.272874355316162, 0.272930473089218, 0.272986084222794, 0.273041248321533, 0.273095905780792, 0.273150146007538, 0.273203939199448, 0.273257225751877, 0.273310095071793, 0.27336248755455, 0.27341440320015, 0.273465871810913, 0.273516923189163, 0.273567467927933, 0.273617535829544, 0.273667186498642, 0.273716360330582, 0.273765057325363, 0.273813307285309, 0.273861140012741, 0.27390843629837, 0.273955345153809, 0.274001747369766, 0.274047702550888, 0.274093210697174, 0.274138271808624, 0.274182826280594, 0.27422696352005, 0.274270594120026, 0.274313807487488, 0.274356573820114, 0.27439883351326, 0.27444064617157, 0.274482041597366, 0.27452290058136, 0.27456334233284, 0.274603366851807, 0.27464285492897, 0.274681925773621, 0.274720519781113, 0.274758666753769, 0.274796366691589, 0.274833619594574, 0.274870365858078, 0.274906665086746, 0.274942547082901, 0.274977892637253, 0.275012820959091, 0.275047302246094, 0.275081306695938, 0.275114864110947, 0.275147914886475, 0.275180578231812, 0.27521276473999, 0.275244444608688, 0.275275677442551, 0.2753064930439, 0.27533683180809, 0.275366693735123, 0.275396108627319, 0.27542507648468, 0.275453597307205, 0.27548161149025, 0.275509178638458, 0.275536298751831, 0.275562942028046, 0.275589168071747, 0.275614887475967, 0.275640159845352, 0.275664985179901, 0.275689333677292, 0.275713205337524, 0.275736689567566, 0.275754034519196, 0.27576532959938, 0.275776356458664, 0.275787144899368, 0.275797694921494, 0.27580800652504, 0.275818169116974, 0.275828033685684, 0.275837689638138, 0.275847107172012, 0.27585631608963, 0.275865256786346, 0.275873988866806, 0.275882512331009, 0.275890797376633, 0.275898844003677, 0.275906622409821, 0.275914222002029, 0.275921553373337, 0.27592870593071, 0.275935590267181, 0.275942265987396, 0.275948703289032, 0.275954872369766, 0.275960862636566, 0.275966584682465, 0.275972157716751, 0.275977402925491, 0.275982469320297, 0.275987297296524, 0.275991916656494, 0.275996267795563, 0.276000380516052, 0.276004314422607, 0.276007980108261, 0.276011407375336, 0.276014626026154, 0.276017665863037, 0.276020407676697, 0.276022911071777, 0.276025205850601, 0.276027292013168, 0.276029109954834, 0.276030749082565, 0.276032119989395, 0.276033222675323, 0.27603417634964, 0.276034861803055, 0.276035308837891, 0.27603554725647, 0.27603554725647, 0.276035308837891, 0.276034861803055, 0.27603417634964, 0.276033252477646, 0.276032119989395, 0.276030749082565, 0.276029109954834, 0.276027292013168, 0.276025235652924, 0.276022911071777, 0.276020407676697, 0.276017665863037, 0.276014655828476, 0.276011407375336, 0.276007980108261, 0.276004314422607, 0.276000380516052, 0.275996267795563, 0.275991916656494, 0.275987297296524, 0.27598249912262, 0.275977432727814, 0.275972157716751, 0.275966644287109, 0.275960862636566, 0.275954872369766, 0.275948703289032, 0.275942295789719, 0.275935620069504, 0.27592870593071, 0.275921583175659, 0.275914251804352, 0.275906622409821, 0.275898844003677, 0.275890797376633, 0.275882512331009, 0.275874018669128, 0.275865316390991, 0.27585631608963, 0.275847136974335, 0.27583771944046, 0.275828063488007, 0.275818169116974, 0.275808095932007, 0.275797724723816, 0.275787174701691, 0.275776356458664, 0.275765359401703, 0.27575409412384, 0.275740325450897, 0.275725305080414, 0.275710582733154, 0.275696188211441, 0.275682091712952, 0.275668323040009, 0.275654852390289, 0.275641679763794, 0.275628805160522, 0.275616228580475, 0.275604009628296, 0.275592029094696, 0.275580376386642, 0.275569051504135, 0.275558054447174, 0.275547295808792, 0.275536894798279, 0.275526762008667, 0.275516986846924, 0.275507479906082, 0.275498270988464, 0.275489389896393, 0.275480836629868, 0.275472521781921, 0.275464594364166, 0.275456935167313, 0.275449573993683, 0.275442510843277, 0.275435745716095, 0.275429338216782, 0.275423228740692, 0.275417387485504, 0.275411874055862, 0.275406658649445, 0.275401800870895, 0.275397181510925, 0.275392860174179, 0.275388926267624, 0.275385230779648, 0.275381863117218, 0.275378793478012, 0.275376051664352, 0.275373607873917, 0.275371432304382, 0.275369584560394, 0.275368064641953, 0.275366842746735, 0.275365948677063, 0.275365322828293, 0.275364995002747, 0.275364995002747, 0.275365322828293, 0.275365948677063, 0.275366842746735, 0.275368064641953, 0.275369614362717, 0.275371432304382, 0.275373607873917, 0.275376051664352, 0.275378793478012, 0.275381863117218, 0.275385230779648, 0.275388956069946, 0.275392860174179, 0.275397181510925, 0.275401800870895, 0.275406688451767, 0.275411874055862, 0.275417387485504, 0.275423228740692, 0.275429338216782, 0.275435745716095, 0.275442540645599, 0.275449603796005, 0.275456935167313, 0.275464594364166, 0.275472521781921, 0.275480836629868, 0.275489389896393, 0.275498270988464, 0.275507509708405, 0.275516986846924, 0.275526762008667, 0.275536894798279, 0.275547325611115, 0.275558054447174, 0.275569051504135, 0.275580406188965, 0.275592029094696, 0.275604009628296, 0.27561628818512, 0.275628805160522, 0.275641709566116, 0.275654852390289, 0.275668323040009, 0.275682121515274, 0.275696218013763, 0.275710582733154, 0.275725334882736, 0.275740325450897, 0.275760918855667, 0.275788217782974, 0.275816172361374, 0.275844901800156, 0.275874227285385, 0.275904327630997, 0.275935053825378, 0.27596652507782, 0.275998681783676, 0.276031494140625, 0.276065021753311, 0.276099264621735, 0.276134192943573, 0.276169806718826, 0.276206076145172, 0.2762431204319, 0.27628082036972, 0.276319205760956, 0.276358276605606, 0.276398003101349, 0.276438504457474, 0.276479661464691, 0.276521533727646, 0.276564061641693, 0.2766073346138, 0.276651293039322, 0.276695877313614, 0.276741206645966, 0.276787221431732, 0.276833921670914, 0.276881366968155, 0.276929438114166, 0.276978224515915, 0.277027726173401, 0.277077913284302, 0.277128756046295, 0.277180343866348, 0.277232587337494, 0.277285605669022, 0.277339220046997, 0.27739354968071, 0.277448564767838, 0.277504324913025, 0.277560740709305, 0.277617841959, 0.277675628662109, 0.277734160423279, 0.277793377637863, 0.27785325050354, 0.277913838624954, 0.277975082397461, 0.278037041425705, 0.278099745512009, 0.278163075447083, 0.278227150440216, 0.27829185128212, 0.278357326984406, 0.278423458337784, 0.278490275144577, 0.278557807207108, 0.278625965118408, 0.278694927692413, 0.278764545917511, 0.278834819793701, 0.278905808925629, 0.278977483510971, 0.279049843549728, 0.279122978448868, 0.279196679592133, 0.279271125793457, 0.279346287250519, 0.279422134160995, 0.279498666524887, 0.279575914144516, 0.27965384721756, 0.279732435941696, 0.27981173992157, 0.279891818761826, 0.279972463846207, 0.28005388379097, 0.280135959386826, 0.280218750238419, 0.280302226543427, 0.280386358499527, 0.280471205711365, 0.280556797981262, 0.28064301609993, 0.280729949474335, 0.280817598104477, 0.280905932188034, 0.280994951725006, 0.281084626913071, 0.281175076961517, 0.281266152858734, 0.281357973814011, 0.281450480222702, 0.281543642282486, 0.28163754940033, 0.281732112169266, 0.281827360391617, 0.281941622495651, 0.282074630260468, 0.282207787036896, 0.282341063022614, 0.282474517822266, 0.282607972621918, 0.282741606235504, 0.28287535905838, 0.283009231090546, 0.283143162727356, 0.283277273178101, 0.283411473035812, 0.283545792102814, 0.283680260181427, 0.283814758062363, 0.283949434757233, 0.28408420085907, 0.284219086170197, 0.284354120492935, 0.284489214420319, 0.284624487161636, 0.284759879112244, 0.284895330667496, 0.285030901432037, 0.285166680812836, 0.285302460193634, 0.285438388586044, 0.285574465990067, 0.285710602998734, 0.285846948623657, 0.285983353853226, 0.286119848489761, 0.286256462335587, 0.286393225193024, 0.28653010725975, 0.286667078733444, 0.28680419921875, 0.286941409111023, 0.287078738212585, 0.287216186523438, 0.287353754043579, 0.28749144077301, 0.287629246711731, 0.287767142057419, 0.287905156612396, 0.288043290376663, 0.28818154335022, 0.288319975137711, 0.288458466529846, 0.288597077131271, 0.288735777139664, 0.28887465596199, 0.289013564586639, 0.289152652025223, 0.289291828870773, 0.289431154727936, 0.289570540189743, 0.289710104465485, 0.289849758148193, 0.289989501237869, 0.290129393339157, 0.290269404649734, 0.290409505367279, 0.290549755096436, 0.290690094232559, 0.290830552577972, 0.290971159934998, 0.291111826896667, 0.291252642869949, 0.291393548250198, 0.291534602642059, 0.29167577624321, 0.29181706905365, 0.291958421468735, 0.292099952697754, 0.292241543531418, 0.292383342981339, 0.292525142431259, 0.292667150497437, 0.292809218168259, 0.292951464653015, 0.293093770742416, 0.293236196041107, 0.293378710746765, 0.293521374464035, 0.293664187192917, 0.293807059526443, 0.293950110673904, 0.29409322142601, 0.294236481189728, 0.294379830360413, 0.294523328542709, 0.294666886329651, 0.294810593128204, 0.29495444893837, 0.29509836435318, 0.29524239897728, 0.295386612415314, 0.295530915260315, 0.295675277709961, 0.295811802148819, 0.295939207077026, 0.296065747737885, 0.296191424131393, 0.296316206455231, 0.296440124511719, 0.296563178300858, 0.296685308218002, 0.296806633472443, 0.296927034854889, 0.297046542167664, 0.297165215015411, 0.29728302359581, 0.297399908304214, 0.297515898942947, 0.297631025314331, 0.297745317220688, 0.297858744859695, 0.297971248626709, 0.298082888126373, 0.298193663358688, 0.298303544521332, 0.298412591218948, 0.298520743846893, 0.298627942800522, 0.298734307289124, 0.298839807510376, 0.298944473266602, 0.299048244953156, 0.299151122570038, 0.299253106117249, 0.299354195594788, 0.299454480409622, 0.299553871154785, 0.299652338027954, 0.299749970436096, 0.299846708774567, 0.299942553043365, 0.300037562847137, 0.300131678581238, 0.300224900245667, 0.300317287445068, 0.300408720970154, 0.300499349832535, 0.300589084625244, 0.300677895545959, 0.30076590180397, 0.300852984189987, 0.300939232110977, 0.301024556159973, 0.30110901594162, 0.301192611455917, 0.301275342702866, 0.301357179880142, 0.301438122987747, 0.301518201828003, 0.301597446203232, 0.301675736904144, 0.301753222942352, 0.301829755306244, 0.301905453205109, 0.301980316638947, 0.30205425620079, 0.302127331495285, 0.30219954252243, 0.302270829677582, 0.302341282367706, 0.302410840988159, 0.302479535341263, 0.302547365427017, 0.302614271640778, 0.302680343389511, 0.302745580673218, 0.302809834480286, 0.302873253822327, 0.302935838699341, 0.302997469902039, 0.303058326244354, 0.303118258714676, 0.303177237510681, 0.303235411643982, 0.303292721509933, 0.303349167108536, 0.303404688835144, 0.303459346294403, 0.303513139486313, 0.303566068410873, 0.30361807346344, 0.303669184446335, 0.303719490766525, 0.303768903017044, 0.303817421197891, 0.303865104913712, 0.303911864757538, 0.303957730531693, 0.304002791643143, 0.304046928882599, 0.304090201854706, 0.304132580757141, 0.304174095392227, 0.304196983575821, 0.304199397563934, 0.30420109629631, 0.304201930761337, 0.304201990365982, 0.304201245307922, 0.304199725389481, 0.304197371006012, 0.304194241762161, 0.304190337657928, 0.304185599088669, 0.304180085659027, 0.304173767566681, 0.304166615009308, 0.304158747196198, 0.30415004491806, 0.304140567779541, 0.304130226373672, 0.304119110107422, 0.304107248783112, 0.304094523191452, 0.30408102273941, 0.304066747426987, 0.304051667451859, 0.304035782814026, 0.304019123315811, 0.304001659154892, 0.303983390331268, 0.303964346647263, 0.303944438695908, 0.303923785686493, 0.303902387619019, 0.30388006567955, 0.303857058286667, 0.303833186626434, 0.303808569908142, 0.303783118724823, 0.303756833076477, 0.303729832172394, 0.303701996803284, 0.303673386573792, 0.303643971681595, 0.303613722324371, 0.303582668304443, 0.303550869226456, 0.303518265485764, 0.303484827280045, 0.303450644016266, 0.303415685892105, 0.303379863500595, 0.303343266248703, 0.303305834531784, 0.303267687559128, 0.303228676319122, 0.303188890218735, 0.303148359060287, 0.303106933832169, 0.30306476354599, 0.303021788597107, 0.302978038787842, 0.302933514118195, 0.302888065576553, 0.30284196138382, 0.302795022726059, 0.302747249603271, 0.302698701620102, 0.302649348974228, 0.302599221467972, 0.302548259496689, 0.302496552467346, 0.302444010972977, 0.30239063501358, 0.302336573600769, 0.302281618118286, 0.302225947380066, 0.302169352769852, 0.302112072706223, 0.302053987979889, 0.301995068788528, 0.301935344934464, 0.301874846220016, 0.301813513040543, 0.301751434803009, 0.301688581705093, 0.301624894142151, 0.301560372114182, 0.301495105028152, 0.301429003477097, 0.301362186670303, 0.301294535398483, 0.301226019859314, 0.301156789064407, 0.301086664199829, 0.301015794277191, 0.300944119691849, 0.300871670246124, 0.300798445940018, 0.300724416971207, 0.300649583339691, 0.300573974847794, 0.30050253868103, 0.300434976816177, 0.300367206335068, 0.300299316644669, 0.300231248140335, 0.300163060426712, 0.300094753503799, 0.30002623796463, 0.299957603216171, 0.299888789653778, 0.29981991648674, 0.299750804901123, 0.299681574106216, 0.299612164497375, 0.299542635679245, 0.29947292804718, 0.299403131008148, 0.299333125352859, 0.299263000488281, 0.299192726612091, 0.299122333526611, 0.299051702022552, 0.298981010913849, 0.298910140991211, 0.298839122056961, 0.298767894506454, 0.298696607351303, 0.298625141382217, 0.29855352640152, 0.298481732606888, 0.298409849405289, 0.298337787389755, 0.298265546560287, 0.29819318652153, 0.298120677471161, 0.298047989606857, 0.297975212335587, 0.297902256250381, 0.297829121351242, 0.297755897045135, 0.297682493925095, 0.297608911991119, 0.297535210847855, 0.297461360692978, 0.297387331724167, 0.297313183546066, 0.297238916158676, 0.297164469957352, 0.297089844942093, 0.297015100717545, 0.296940237283707, 0.296865195035934, 0.296789944171906, 0.296714633703232, 0.296639174222946, 0.296563476324081, 0.29648768901825, 0.296411752700806, 0.296335697174072, 0.296259492635727, 0.296183049678802, 0.296106517314911, 0.29602986574173, 0.295953005552292, 0.295876055955887, 0.295798897743225, 0.295721590518951, 0.295644193887711, 0.295566618442535, 0.295488893985748, 0.295411020517349, 0.295332998037338, 0.295254826545715, 0.295176535844803, 0.295098036527634, 0.295019388198853, 0.294940650463104, 0.294861733913422, 0.294782668352127, 0.294703423976898, 0.29462406039238, 0.294544577598572, 0.294464915990829, 0.294385105371475, 0.294305115938187, 0.294225066900253, 0.294144779443741, 0.294064372777939, 0.293983846902847, 0.293903112411499, 0.293822258710861, 0.293741226196289, 0.293660134077072, 0.293578773736954, 0.293497383594513, 0.293415784835815, 0.293334007263184, 0.29325208067894, 0.293170064687729, 0.293087899684906, 0.293014973402023, 0.292950004339218, 0.292885005474091, 0.292819947004318, 0.292754918336868, 0.292689830064774, 0.292624682188034, 0.292559564113617, 0.292494356632233, 0.292429149150848, 0.292363911867142, 0.292298674583435, 0.292233347892761, 0.29216805100441, 0.292102694511414, 0.292037308216095, 0.291971921920776, 0.291906476020813, 0.29184103012085, 0.291775524616241, 0.291709989309311, 0.29164445400238, 0.291578888893127, 0.29151326417923, 0.291447639465332, 0.29138195514679, 0.291316270828247, 0.29125052690506, 0.291184812784195, 0.291119009256363, 0.291053205728531, 0.290987342596054, 0.290921539068222, 0.290855646133423, 0.290789693593979, 0.290723741054535, 0.290657728910446, 0.29059174656868, 0.290525704622269, 0.290459632873535, 0.290393561124802, 0.290327429771423, 0.2902612388134, 0.2901950776577, 0.290128856897354, 0.290062606334686, 0.289996355772018, 0.289930075407028, 0.289863705635071, 0.289797395467758, 0.289730995893478, 0.289664596319199, 0.289598166942596, 0.289531707763672, 0.289465129375458, 0.289398640394211, 0.289332091808319, 0.289265513420105, 0.289198905229568, 0.289132237434387, 0.289065569639206, 0.288998872041702, 0.288932174444199, 0.28886541724205, 0.288798600435257, 0.288731783628464, 0.288664966821671, 0.28859806060791, 0.288531184196472, 0.288464248180389, 0.288397312164307, 0.288330316543579, 0.288263261318207, 0.288196265697479, 0.288129180669785, 0.288062065839767, 0.28799495100975, 0.287927776575089, 0.287860602140427, 0.28779336810112, 0.287726134061813, 0.287658870220184, 0.287591546773911, 0.287524223327637, 0.287456840276718, 0.2873894572258, 0.287322074174881, 0.287254601716995, 0.287187159061432, 0.287119626998901, 0.287052124738693, 0.286984533071518, 0.286916971206665, 0.286849349737167, 0.286781698465347, 0.286714017391205, 0.286646276712418, 0.286578595638275, 0.286510795354843, 0.286442995071411, 0.286370426416397, 0.286288142204285, 0.28620582818985, 0.286123633384705, 0.286041408777237, 0.285959243774414, 0.285877108573914, 0.285794973373413, 0.28571292757988, 0.285630881786346, 0.285548895597458, 0.285466939210892, 0.285384982824326, 0.285303056240082, 0.285221219062805, 0.285139411687851, 0.285057604312897, 0.284975826740265, 0.284894108772278, 0.284812420606613, 0.284730762243271, 0.284649103879929, 0.284567564725876, 0.284485995769501, 0.28440448641777, 0.28432297706604, 0.284241497516632, 0.284160107374191, 0.284078687429428, 0.283997356891632, 0.283916056156158, 0.283834785223007, 0.283753484487534, 0.283672273159027, 0.283591121435165, 0.283509939908981, 0.283428847789764, 0.283347755670547, 0.283266723155975, 0.283185690641403, 0.283104717731476, 0.283023804426193, 0.282942891120911, 0.282861977815628, 0.28278112411499, 0.28270035982132, 0.282619565725327, 0.282538831233978, 0.282458126544952, 0.282377451658249, 0.282296806573868, 0.282216221094131, 0.282135665416718, 0.282055079936981, 0.281974583864212, 0.281894117593765, 0.281813710927963, 0.281733304262161, 0.281652957201004, 0.281572580337524, 0.281492292881012, 0.281412094831467, 0.281331866979599, 0.281251639127731, 0.281171470880508, 0.28109136223793, 0.281011253595352, 0.280931174755096, 0.280851155519485, 0.280771166086197, 0.280691236257553, 0.280611336231232, 0.280531406402588, 0.280451565980911, 0.280371725559235, 0.280291974544525, 0.280212163925171, 0.280132472515106, 0.280052781105042, 0.279973149299622, 0.279893487691879, 0.279813945293427, 0.279734373092651, 0.279654860496521, 0.279575407505035, 0.27949595451355, 0.279416501522064, 0.279337137937546, 0.27925780415535, 0.279178500175476, 0.279099225997925, 0.279019981622696, 0.278940767049789, 0.278861612081528, 0.278782427310944, 0.278703331947327, 0.278624296188354, 0.278545260429382, 0.278466284275055, 0.278387278318405, 0.278320282697678, 0.278267681598663, 0.278214871883392, 0.278161972761154, 0.278108865022659, 0.278055667877197, 0.278002321720123, 0.277948826551437, 0.277895241975784, 0.277841448783875, 0.277787506580353, 0.277733474969864, 0.277679234743118, 0.277624934911728, 0.277570456266403, 0.277515798807144, 0.27746108174324, 0.27740615606308, 0.27735111117363, 0.27729594707489, 0.277240604162216, 0.27718511223793, 0.277129471302032, 0.277073711156845, 0.277017861604691, 0.276961833238602, 0.276905596256256, 0.276849329471588, 0.276792854070663, 0.276736229658127, 0.276679515838623, 0.276622593402863, 0.276565581560135, 0.276508450508118, 0.276451110839844, 0.27639365196228, 0.276336044073105, 0.276278346776962, 0.276220470666885, 0.276162415742874, 0.276104301214218, 0.276045948266983, 0.275987505912781, 0.275928944349289, 0.275870233774185, 0.275811344385147, 0.275752365589142, 0.275693148374557, 0.275633901357651, 0.275574505329132, 0.275514870882034, 0.275455147027969, 0.275395303964615, 0.275335282087326, 0.275275111198425, 0.275214850902557, 0.2751544713974, 0.275093913078308, 0.275033205747604, 0.274972319602966, 0.274911373853683, 0.274850219488144, 0.274788975715637, 0.274727553129196, 0.274665981531143, 0.274604290723801, 0.274542450904846, 0.274480491876602, 0.274418354034424, 0.274356067180634, 0.274293661117554, 0.274231135845184, 0.274168431758881, 0.274105608463287, 0.274042636156082, 0.273979544639587, 0.273916304111481, 0.27385288476944, 0.273789346218109, 0.273725658655167, 0.273661851882935, 0.273597896099091, 0.273533761501312, 0.273469507694244, 0.273405134677887, 0.273340612649918, 0.273275971412659, 0.273211151361465, 0.27314618229866, 0.273081123828888, 0.273015856742859, 0.27295047044754, 0.272884964942932, 0.272819340229034, 0.27275350689888, 0.272687584161758, 0.272621482610703, 0.272555202245712, 0.2724888920784, 0.27242237329483, 0.272355407476425, 0.272295534610748, 0.272234737873077, 0.272173076868057, 0.272110283374786, 0.27204641699791, 0.271981596946716, 0.27191573381424, 0.271849095821381, 0.271781235933304, 0.271712392568588, 0.271642565727234, 0.271571725606918, 0.271500021219254, 0.27142721414566, 0.271353304386139, 0.271278411149979, 0.271202564239502, 0.271125793457031, 0.271047979593277, 0.270969063043594, 0.27088925242424, 0.270808458328247, 0.27072662115097, 0.27064374089241, 0.270559817552567, 0.270474940538406, 0.27038910984993, 0.270302355289459, 0.270214468240738, 0.270125538110733, 0.270035594701767, 0.269944697618484, 0.269852757453918, 0.269760012626648, 0.269666135311127, 0.269571214914322, 0.269475221633911, 0.269378513097763, 0.269280463457108, 0.269181609153748, 0.269081741571426, 0.268980771303177, 0.268878847360611, 0.268775999546051, 0.268671989440918, 0.268567115068436, 0.26846107840538, 0.268354117870331, 0.268246412277222, 0.26813742518425, 0.268027395009995, 0.26791650056839, 0.267804443836212, 0.267691552639008, 0.267577618360519, 0.26746267080307, 0.267346769571304, 0.267229676246643, 0.2671118080616, 0.266992807388306, 0.26687279343605, 0.266751796007156, 0.266629844903946, 0.266506910324097, 0.266382932662964, 0.266257882118225, 0.26613187789917, 0.266004830598831, 0.265876919031143, 0.265747934579849, 0.265617966651917, 0.265486896038055, 0.265354871749878, 0.265221923589706, 0.265087842941284, 0.264952898025513, 0.26481682062149, 0.264679759740829, 0.264541804790497, 0.264402717351913, 0.264262676239014, 0.26412159204483, 0.263979494571686, 0.263836592435837, 0.263692528009415, 0.263547509908676, 0.263401359319687, 0.263254284858704, 0.263106286525726, 0.262957185506821, 0.262807160615921, 0.262656062841415, 0.262503921985626, 0.262350976467133, 0.262196838855743, 0.262041717767715, 0.261885523796082, 0.261728525161743, 0.261570572853088, 0.261375308036804, 0.261148363351822, 0.260920822620392, 0.260692536830902, 0.260463714599609, 0.260234236717224, 0.260003954172134, 0.259772926568985, 0.25954133272171, 0.259309053421021, 0.259076088666916, 0.258842289447784, 0.258607983589172, 0.258372932672501, 0.258137375116348, 0.257900923490524, 0.257663875818253, 0.257426053285599, 0.257187604904175, 0.256948560476303, 0.256708830595016, 0.25646835565567, 0.256227135658264, 0.25598531961441, 0.255742847919464, 0.255499631166458, 0.255255669355392, 0.255011141300201, 0.254765927791595, 0.254520118236542, 0.254273444414139, 0.254026174545288, 0.253778100013733, 0.25352942943573, 0.253280252218246, 0.253030270338058, 0.252779483795166, 0.252528160810471, 0.252276033163071, 0.252023428678513, 0.251769989728928, 0.251515865325928, 0.251261085271835, 0.25100564956665, 0.250749528408051, 0.250492751598358, 0.250235199928284, 0.249977007508278, 0.249718144536018, 0.249458745121956, 0.249198526144028, 0.248937532305717, 0.248675942420959, 0.248413622379303, 0.248150810599327, 0.247887134552002, 0.247622802853584, 0.247357875108719, 0.247092217206955, 0.246825903654099, 0.246558874845505, 0.24629108607769, 0.246022656559944, 0.245753616094589, 0.245484009385109, 0.245213508605957, 0.244942367076874, 0.244670540094376, 0.244398012757301, 0.244124919176102, 0.243851214647293, 0.243576601147652, 0.243301436305046, 0.243025451898575, 0.242749020457268, 0.242471724748611, 0.242193803191185, 0.241915166378021, 0.241635948419571, 0.2413559705019, 0.241075366735458, 0.240794017910957, 0.240511953830719, 0.240229249000549, 0.239946022629738, 0.2396619617939, 0.239377215504646, 0.239091753959656, 0.238805681467056, 0.238518983125687, 0.238231495022774, 0.237943306565285, 0.237654522061348, 0.237365007400513, 0.237074911594391, 0.236784040927887, 0.236492410302162, 0.236200153827667, 0.235907346010208, 0.235613867640495, 0.235320955514908, 0.235028102993965, 0.234736368060112, 0.234445989131927, 0.234156057238579, 0.233867526054382, 0.233579635620117, 0.233292803168297, 0.233007073402405, 0.232722148299217, 0.232438325881958, 0.232155427336693, 0.231873571872711, 0.231592446565628, 0.231312438845634, 0.231033518910408, 0.230755358934402, 0.230478405952454, 0.230202168226242, 0.229927107691765, 0.22965282201767, 0.229379788041115, 0.229107454419136, 0.228836238384247, 0.228565901517868, 0.228296384215355, 0.22802822291851, 0.227760672569275, 0.227494388818741, 0.227228745818138, 0.226964548230171, 0.226700752973557, 0.226438254117966, 0.226176664233208, 0.225915983319283, 0.225656524300575, 0.225397765636444, 0.225140139460564, 0.224883213639259, 0.224627658724785, 0.224372804164886, 0.224118813872337, 0.223866075277328, 0.223614022135735, 0.223363384604454, 0.223113283514977, 0.22286431491375, 0.222616314888, 0.222369074821472, 0.222123295068741, 0.221877843141556, 0.221634075045586, 0.221390679478645, 0.221148580312729, 0.220907300710678, 0.220666885375977, 0.220427796244621, 0.220189347863197, 0.219952121376991, 0.219715595245361, 0.219480186700821, 0.219245791435242, 0.219012320041656, 0.218779861927032, 0.218548372387886, 0.218317747116089, 0.218087941408157, 0.217859521508217, 0.217631697654724, 0.217405259609222, 0.217179328203201, 0.216954588890076, 0.216730803251266, 0.216507866978645, 0.216286137700081, 0.216065153479576, 0.215845391154289, 0.215626358985901, 0.215408310294151, 0.21519136428833, 0.214975237846375, 0.214760392904282, 0.214546263217926, 0.21433313190937, 0.214120954275131, 0.213909849524498, 0.213699653744698, 0.21349036693573, 0.213282108306885, 0.213074669241905, 0.212868362665176, 0.212662920355797, 0.212458655238152, 0.212255150079727, 0.212052464485168, 0.211851194500923, 0.211650475859642, 0.211451128125191, 0.211252391338348, 0.211054921150208, 0.210893109440804, 0.210750997066498, 0.210610449314117, 0.210471570491791, 0.210334062576294, 0.210197895765305, 0.210063919425011, 0.209931045770645, 0.209799885749817, 0.209669977426529, 0.209542006254196, 0.209415316581726, 0.209290057420731, 0.209166631102562, 0.209044456481934, 0.208924353122711, 0.20880514383316, 0.208687990903854, 0.208572059869766, 0.208457767963409, 0.208345130085945, 0.208233848214149, 0.208124235272408, 0.208016246557236, 0.207909733057022, 0.207804635167122, 0.207701221108437, 0.207599356770515, 0.207498833537102, 0.207400068640709, 0.207302644848824, 0.207207232713699, 0.207112893462181, 0.207020446658134, 0.206929221749306, 0.206839397549629, 0.20675154030323, 0.206665083765984, 0.206580147147179, 0.206496670842171, 0.206415250897408, 0.2063347697258, 0.206255987286568, 0.2061787545681, 0.20610311627388, 0.20602910220623, 0.205956250429153, 0.205885469913483, 0.205816090106964, 0.205748200416565, 0.205681785941124, 0.205616995692253, 0.20555354654789, 0.205491587519646, 0.205431640148163, 0.205372825264931, 0.20531590282917, 0.205260127782822, 0.205206170678139, 0.205153748393059, 0.205102697014809, 0.205053493380547, 0.205005452036858, 0.204959362745285, 0.204914540052414, 0.204871341586113, 0.204829707741737, 0.204789593815804, 0.204750910401344, 0.204713851213455, 0.204678520560265, 0.204644411802292, 0.20461218059063, 0.20458123087883, 0.20455214381218, 0.204524293541908, 0.204497873783112, 0.204473376274109, 0.204450145363808, 0.204428672790527, 0.204408451914787, 0.204389929771423, 0.20437316596508, 0.204357504844666, 0.204343721270561, 0.204331398010254, 0.20432074368, 0.204311326146126, 0.204303860664368, 0.204297676682472, 0.204293102025986, 0.204290136694908, 0.204288512468338, 0.204288646578789, 0.204290002584457, 0.204293355345726, 0.204297870397568, 0.204304188489914, 0.204311802983284, 0.204321146011353, 0.204343810677528, 0.204367220401764, 0.20439139008522, 0.204416424036026, 0.204442277550697, 0.204468950629234, 0.204496338963509, 0.204524680972099, 0.204554036259651, 0.204584002494812, 0.204614713788033, 0.204646348953247, 0.204678848385811, 0.204712137579918, 0.204746142029762, 0.20478118956089, 0.2048170119524, 0.204853519797325, 0.204891055822372, 0.204929292201996, 0.20496828854084, 0.20500810444355, 0.205048888921738, 0.205090373754501, 0.205132871866226, 0.205176025629044, 0.205220058560371, 0.205264925956726, 0.205310463905334, 0.205357104539871, 0.205404371023178, 0.205452486872673, 0.205501511693001, 0.205551356077194, 0.205601900815964, 0.205653369426727, 0.205705672502518, 0.205758646130562, 0.205812573432922, 0.205867484211922, 0.205922916531563, 0.205979466438293, 0.206036776304245, 0.206094712018967, 0.20615354180336, 0.206213340163231, 0.206273838877678, 0.206335142254829, 0.206397294998169, 0.206460475921631, 0.206524267792702, 0.206588834524155, 0.206654369831085, 0.206720754504204, 0.206787765026093, 0.206855639815331, 0.206924587488174, 0.206994116306305, 0.207064643502235, 0.207135900855064, 0.207208052277565, 0.207280918955803, 0.20735464990139, 0.207429215312004, 0.207504540681839, 0.207580834627151, 0.207657858729362, 0.2077357172966, 0.20781435072422, 0.20789410173893, 0.207974463701248, 0.208055555820465, 0.208137482404709, 0.208220213651657, 0.208303928375244, 0.208388417959213, 0.20847362279892, 0.20855975151062, 0.208646699786186, 0.208734467625618, 0.20882323384285, 0.208912655711174, 0.209002748131752, 0.209093913435936, 0.209185868501663, 0.209278538823128, 0.20937205851078, 0.209466367959976, 0.209561675786972, 0.20965763926506, 0.209754690527916, 0.209852308034897, 0.209950610995293, 0.210050016641617, 0.210150331258774, 0.210251227021217, 0.210353076457977, 0.210455849766731, 0.210558995604515, 0.210663393139839, 0.210768863558769, 0.210869699716568, 0.210970550775528, 0.211071223020554, 0.211171865463257, 0.211272567510605, 0.211373150348663, 0.211473733186722, 0.211574241518974, 0.211674690246582, 0.211775183677673, 0.211875572800636, 0.211975872516632, 0.212076187133789, 0.212176457047462, 0.212276712059975, 0.212376862764359, 0.212477028369904, 0.212577104568481, 0.212677091360092, 0.212777137756348, 0.212877094745636, 0.212977021932602, 0.213076874613762, 0.213176786899567, 0.213276505470276, 0.213376298546791, 0.213475972414017, 0.213575676083565, 0.213675260543823, 0.213774830102921, 0.213874414563179, 0.21397390961647, 0.2140733897686, 0.214172810316086, 0.214272156357765, 0.214371502399445, 0.214470773935318, 0.214570060372353, 0.214669242501259, 0.214768290519714, 0.214867532253265, 0.214966505765915, 0.215065538883209, 0.21516452729702, 0.215263441205025, 0.215362399816513, 0.215461269021034, 0.215560048818588, 0.215658858418465, 0.215757593512535, 0.215856239199638, 0.215954929590225, 0.216053485870361, 0.216152131557465, 0.216250613331795, 0.216349065303802, 0.21644751727581, 0.216545879840851, 0.216644257307053, 0.216742590069771, 0.216840803623199, 0.216939121484756, 0.21703727543354, 0.217135414481163, 0.217233419418335, 0.217331454157829, 0.217429473996162, 0.217527404427528, 0.217625349760056, 0.217723295092583, 0.217821091413498, 0.217918902635574, 0.218016639351845, 0.218114346265793, 0.218212023377419, 0.218309640884399, 0.218407288193703, 0.218504816293716, 0.218602254986763, 0.218699738383293, 0.218797132372856, 0.218894481658936, 0.218991860747337, 0.219089135527611, 0.219186410307884, 0.219283580780029, 0.219380676746368, 0.219477906823158, 0.219574883580208, 0.219671994447708, 0.219768926501274, 0.219865843653679, 0.219962805509567, 0.220059618353844, 0.22015643119812, 0.220253199338913, 0.2203498929739, 0.220446676015854, 0.220543295145035, 0.220650896430016, 0.220766097307205, 0.220879733562469, 0.220992401242256, 0.221103504300117, 0.221213757991791, 0.2213224619627, 0.221430271863937, 0.221536695957184, 0.221641957759857, 0.22174571454525, 0.221848800778389, 0.221950441598892, 0.222050592303276, 0.222149819135666, 0.222247719764709, 0.222344562411308, 0.222439870238304, 0.222534239292145, 0.222627207636833, 0.22271916270256, 0.222809702157974, 0.222899198532104, 0.222987234592438, 0.223074346780777, 0.22316001355648, 0.223244577646255, 0.223327830433846, 0.223409980535507, 0.223490729928017, 0.223570555448532, 0.223648890852928, 0.223726272583008, 0.223802208900452, 0.223877102136612, 0.223950535058975, 0.224023044109344, 0.22409400343895, 0.224164098501205, 0.224232643842697, 0.224300339818001, 0.224366411566734, 0.224431559443474, 0.224495261907578, 0.224558025598526, 0.224619314074516, 0.224679678678513, 0.224738582968712, 0.224796295166016, 0.224852800369263, 0.224908351898193, 0.224962189793587, 0.225015342235565, 0.225066900253296, 0.225117370486259, 0.225166574120522, 0.225214689970016, 0.225261315703392, 0.225307121872902, 0.225351542234421, 0.225394606590271, 0.225436747074127, 0.225477278232574, 0.225516825914383, 0.225555077195168, 0.225592285394669, 0.225627943873405, 0.225662618875504, 0.225696086883545, 0.22572822868824, 0.225759148597717, 0.225789114832878, 0.225817397236824, 0.225844860076904, 0.225870952010155, 0.225895971059799, 0.22591944038868, 0.225942149758339, 0.225963234901428, 0.225983306765556, 0.226002126932144, 0.226019829511642, 0.226036041975021, 0.22605137526989, 0.226065114140511, 0.226077929139137, 0.226089432835579, 0.226099744439125, 0.226108759641647, 0.226116880774498, 0.226123183965683, 0.226128861308098, 0.226132929325104, 0.226136028766632, 0.226137667894363, 0.226138234138489, 0.226137667894363, 0.226135790348053, 0.22613263130188, 0.226128548383713, 0.226083040237427, 0.226027220487595, 0.225969567894936, 0.225910127162933, 0.225848108530045, 0.225785434246063, 0.225720196962357, 0.225653529167175, 0.225584536790848, 0.225514397025108, 0.225442185997963, 0.225368425250053, 0.225291699171066, 0.225214466452599, 0.225135028362274, 0.225053936243057, 0.224970102310181, 0.224885657429695, 0.224798858165741, 0.224710538983345, 0.224619358778, 0.224527701735497, 0.224433556199074, 0.224338263273239, 0.224240273237228, 0.224140971899033, 0.224039629101753, 0.223936721682549, 0.22383151948452, 0.223725110292435, 0.223616555333138, 0.223506420850754, 0.223394244909286, 0.223280385136604, 0.223164603114128, 0.223047256469727, 0.222927734255791, 0.222806379199028, 0.222683623433113, 0.222559049725533, 0.222432434558868, 0.222303748130798, 0.222173765301704, 0.222041726112366, 0.221907868981361, 0.221772089600563, 0.221635028719902, 0.221495628356934, 0.221354946494102, 0.221211314201355, 0.221067145466805, 0.220920532941818, 0.22077251970768, 0.220622017979622, 0.220470249652863, 0.220316290855408, 0.22016142308712, 0.220003589987755, 0.219844356179237, 0.219683542847633, 0.219520822167397, 0.219355508685112, 0.219189435243607, 0.219021528959274, 0.218851700425148, 0.218679174780846, 0.218505755066872, 0.21833036839962, 0.218153193593025, 0.217973724007607, 0.217793181538582, 0.217610597610474, 0.217426210641861, 0.217239111661911, 0.217051237821579, 0.216861799359322, 0.216670051217079, 0.216476127505302, 0.216280519962311, 0.216083735227585, 0.215884640812874, 0.215683862566948, 0.215481176972389, 0.215276658535004, 0.215070471167564, 0.214862108230591, 0.21465228497982, 0.214440688490868, 0.214227676391602, 0.214012458920479, 0.213795065879822, 0.213576108217239, 0.213355481624603, 0.213133037090302, 0.212908536195755, 0.212682247161865, 0.212454408407211, 0.21222460269928, 0.211992770433426, 0.211759373545647, 0.211481109261513, 0.211180657148361, 0.21088020503521, 0.210579261183739, 0.210278436541557, 0.209977462887764, 0.209676370024681, 0.209374770522118, 0.209073409438133, 0.20877206325531, 0.208470329642296, 0.208168461918831, 0.207866743206978, 0.207564607262611, 0.207262352108955, 0.206959992647171, 0.206657722592354, 0.206354975700378, 0.206052467226982, 0.205749437212944, 0.205446779727936, 0.205143660306931, 0.204840496182442, 0.204536691308022, 0.204233542084694, 0.203930243849754, 0.203626066446304, 0.203322276473045, 0.203018352389336, 0.202714413404465, 0.202409967780113, 0.202105402946472, 0.201801091432571, 0.20149664580822, 0.201191812753677, 0.200886741280556, 0.200581640005112, 0.20027694106102, 0.199971348047256, 0.199665725231171, 0.199360251426697, 0.199055045843124, 0.198748931288719, 0.198443308472633, 0.198137208819389, 0.197831213474274, 0.197524562478065, 0.197218328714371, 0.196911573410034, 0.196605071425438, 0.196298167109489, 0.195991143584251, 0.195684000849724, 0.195377230644226, 0.195069551467896, 0.194762289524078, 0.194454491138458, 0.19414709508419, 0.193838909268379, 0.193530976772308, 0.193223178386688, 0.192914739251137, 0.192606031894684, 0.192297860980034, 0.191989421844482, 0.19168047606945, 0.191371634602547, 0.191062688827515, 0.190753474831581, 0.190444260835648, 0.190134644508362, 0.189825311303139, 0.189515575766563, 0.1892059892416, 0.188895732164383, 0.188586011528969, 0.188275903463364, 0.187965646386147, 0.187655135989189, 0.187344238162041, 0.187033876776695, 0.186722993850708, 0.186412215232849, 0.186101078987122, 0.185789808630943, 0.185478776693344, 0.185167372226715, 0.184855565428734, 0.184543788433075, 0.184232130646706, 0.183920070528984, 0.183607891201973, 0.183295711874962, 0.182983294129372, 0.182670831680298, 0.182358399033546, 0.182045578956604, 0.181732624769211, 0.181419670581818, 0.181106850504875, 0.180842578411102, 0.180609568953514, 0.180377602577209, 0.180147171020508, 0.179917767643929, 0.179689943790436, 0.179463222622871, 0.179237574338913, 0.179013729095459, 0.178790658712387, 0.178569376468658, 0.178348615765572, 0.17812967300415, 0.177911877632141, 0.177695631980896, 0.177480548620224, 0.177266493439674, 0.177053868770599, 0.176842778921127, 0.176632598042488, 0.176423698663712, 0.176215976476669, 0.17600990831852, 0.175804749131203, 0.175601407885551, 0.175399228930473, 0.175198063254356, 0.174997955560684, 0.174799621105194, 0.174602329730988, 0.174406081438065, 0.174211502075195, 0.174018070101738, 0.173825815320015, 0.173635110259056, 0.173445299267769, 0.173256888985634, 0.173069790005684, 0.172884121537209, 0.172699704766273, 0.172516494989395, 0.172334685921669, 0.172153890132904, 0.171974390745163, 0.171796455979347, 0.171619549393654, 0.171444043517113, 0.171269834041595, 0.17109677195549, 0.170925155282021, 0.170754805207253, 0.170585379004478, 0.170417755842209, 0.170251026749611, 0.170085713267326, 0.169921547174454, 0.169758960604668, 0.169597655534744, 0.169437363743782, 0.169278264045715, 0.16912068426609, 0.16896453499794, 0.168809399008751, 0.168655693531036, 0.168502882122993, 0.168351501226425, 0.168201670050621, 0.168052852153778, 0.167905747890472, 0.167759642004967, 0.167614951729774, 0.167471185326576, 0.167328849434853, 0.167188033461571, 0.167048111557961, 0.166909605264664, 0.166772291064262, 0.166636526584625, 0.166501760482788, 0.166368559002876, 0.166236400604248, 0.166105508804321, 0.165976300835609, 0.165848150849342, 0.165721103549004, 0.165595263242722, 0.165470957756042, 0.165347814559937, 0.165225952863693, 0.165105402469635, 0.164986252784729, 0.164868146181107, 0.164751306176186, 0.16463603079319, 0.164521798491478, 0.164408966898918, 0.164297297596931, 0.164186775684357, 0.164077952504158, 0.163970410823822, 0.163887664675713, 0.163818627595901, 0.163749903440475, 0.163681551814079, 0.163613587617874, 0.163545966148376, 0.163478717207909, 0.163411930203438, 0.163345381617546, 0.163279175758362, 0.163213476538658, 0.163148283958435, 0.163083359599113, 0.163018763065338, 0.162954360246658, 0.162890404462814, 0.162826761603355, 0.162763640284538, 0.162700787186623, 0.162638425827026, 0.162576407194138, 0.162514716386795, 0.162453323602676, 0.162392199039459, 0.162331610918045, 0.162271395325661, 0.162211552262306, 0.162152305245399, 0.162093117833138, 0.162034377455711, 0.161975771188736, 0.161917731165886, 0.161860108375549, 0.161802917718887, 0.16174578666687, 0.161689311265945, 0.161633089184761, 0.161577075719833, 0.161521568894386, 0.161466494202614, 0.161411836743355, 0.161357596516609, 0.161303773522377, 0.161250188946724, 0.161196812987328, 0.161143809556961, 0.161091268062592, 0.161039099097252, 0.160987392067909, 0.160935938358307, 0.160884752869606, 0.160834014415741, 0.160783648490906, 0.160733878612518, 0.160684376955032, 0.16063517332077, 0.160585984587669, 0.160537764430046, 0.160489529371262, 0.160441681742668, 0.160394430160522, 0.160347312688828, 0.160300493240356, 0.160254344344139, 0.16020855307579, 0.160162895917892, 0.160117700695992, 0.160072833299637, 0.160028338432312, 0.159984305500984, 0.159940794110298, 0.159897476434708, 0.159854456782341, 0.159811660647392, 0.159769356250763, 0.159727513790131, 0.159686073660851, 0.159644931554794, 0.159604042768478, 0.159563630819321, 0.159523397684097, 0.159483686089516, 0.159444347023964, 0.159405410289764, 0.15936703979969, 0.159328952431679, 0.15929102897644, 0.159253567457199, 0.159216374158859, 0.159179762005806, 0.159143254160881, 0.15910741686821, 0.159071639180183, 0.159036368131638, 0.159001410007477, 0.158966854214668, 0.158932819962502, 0.158898904919624, 0.158865451812744, 0.158832237124443, 0.158767133951187, 0.15868753194809, 0.158607706427574, 0.158527478575706, 0.15844689309597, 0.158365935087204, 0.158284604549408, 0.158202916383743, 0.158120915293694, 0.158038526773453, 0.157955974340439, 0.157872885465622, 0.157789438962936, 0.157705664634705, 0.157621458172798, 0.157536923885345, 0.157452091574669, 0.157366842031479, 0.157281205058098, 0.157195299863815, 0.157109037041664, 0.157022371888161, 0.156935214996338, 0.156847909092903, 0.156760156154633, 0.156672030687332, 0.156583607196808, 0.156494855880737, 0.156405717134476, 0.156316161155701, 0.156226217746735, 0.156135991215706, 0.156045347452164, 0.155954539775848, 0.155863240361214, 0.155771642923355, 0.155679538846016, 0.155587196350098, 0.155494406819344, 0.155401289463043, 0.155307829380035, 0.155214041471481, 0.155119955539703, 0.155025348067284, 0.154930502176285, 0.154835283756256, 0.15473960340023, 0.154643684625626, 0.154547393321991, 0.154450714588165, 0.154353693127632, 0.154256299138069, 0.15415857732296, 0.15406046807766, 0.153961911797523, 0.153863146901131, 0.153764128684998, 0.153664484620094, 0.153564691543579, 0.153464421629906, 0.153363883495331, 0.153262838721275, 0.15316154062748, 0.153059929609299, 0.152957767248154, 0.152855440974236, 0.152752757072449, 0.152649655938148, 0.152546107769012, 0.15244223177433, 0.152338102459908, 0.15223354101181, 0.152128636837006, 0.152023419737816, 0.151917845010757, 0.151811838150024, 0.151705533266068, 0.151598855853081, 0.151491805911064, 0.151384502649307, 0.151276811957359, 0.15116873383522, 0.151060208678246, 0.150951370596886, 0.15084220468998, 0.15073262155056, 0.150622680783272, 0.150512486696243, 0.15040186047554, 0.150290876626968, 0.150179535150528, 0.150067910552025, 0.149955824017525, 0.149843409657478, 0.149730682373047, 0.149617582559586, 0.149504080414772, 0.149390280246735, 0.14927613735199, 0.149161592125893, 0.149049699306488, 0.148929640650749, 0.148809567093849, 0.148689419031143, 0.148569196462631, 0.148448958992958, 0.148328676819801, 0.148208245635033, 0.148087829351425, 0.147967323660851, 0.147846862673759, 0.147726312279701, 0.147605806589127, 0.147485017776489, 0.147364348173141, 0.147243559360504, 0.147122740745544, 0.147001922130585, 0.146880865097046, 0.146759912371635, 0.146638959646225, 0.146517917513847, 0.146396741271019, 0.146275520324707, 0.146154284477234, 0.146033003926277, 0.145911693572998, 0.145790323615074, 0.145668923854828, 0.14554750919342, 0.145425900816917, 0.145304277539253, 0.14518266916275, 0.145061016082764, 0.144939243793488, 0.144817501306534, 0.144695609807968, 0.144573748111725, 0.144451797008514, 0.144329786300659, 0.144207775592804, 0.144085600972176, 0.143963441252708, 0.143841326236725, 0.143719032406807, 0.143596738576889, 0.143474444746971, 0.143352016806602, 0.14322954416275, 0.143107011914253, 0.142984479665756, 0.142861917614937, 0.14273926615715, 0.142616525292397, 0.142493665218353, 0.1423709243536, 0.142248079180717, 0.142125174403191, 0.142002135515213, 0.141879171133041, 0.141756132245064, 0.141632989048958, 0.141509786248207, 0.141386672854424, 0.141263321042061, 0.141140013933182, 0.141016617417336, 0.140893265604973, 0.140769794583321, 0.140646263957024, 0.140522643923759, 0.140398994088173, 0.140275344252586, 0.14015157520771, 0.140027865767479, 0.139904052019119, 0.139780089259148, 0.13965617120266, 0.139532163739204, 0.139408141374588, 0.13928410410881, 0.139159888029099, 0.139035761356354, 0.138911545276642, 0.138787224888802, 0.138662934303284, 0.138538524508476, 0.138413995504379, 0.138289481401443, 0.138164967298508, 0.13804042339325, 0.137915745377541, 0.137791097164154, 0.137666210532188, 0.137541443109512, 0.137416586279869, 0.137291699647903, 0.137166798114777, 0.137041836977005, 0.136916726827621, 0.136816993355751, 0.136721059679985, 0.136624991893768, 0.136528447270393, 0.136431828141212, 0.136334925889969, 0.136237695813179, 0.136140465736389, 0.136042892932892, 0.135944992303848, 0.13584703207016, 0.135748758912086, 0.135650217533112, 0.135551497340202, 0.135452583432198, 0.135353356599808, 0.135253876447678, 0.135154291987419, 0.135054379701614, 0.134954169392586, 0.134854078292847, 0.134753435850143, 0.134652525186539, 0.134551629424095, 0.134450361132622, 0.134348824620247, 0.134247094392776, 0.134145215153694, 0.134042993187904, 0.133940488100052, 0.133838057518005, 0.133735105395317, 0.133632004261017, 0.133528724312782, 0.133425146341324, 0.133321389555931, 0.133217319846153, 0.133113190531731, 0.133008658885956, 0.132903844118118, 0.132799088954926, 0.132693871855736, 0.132588431239128, 0.132482841610909, 0.132376879453659, 0.13227079808712, 0.132164523005486, 0.132057964801788, 0.131951183080673, 0.131844267249107, 0.131736949086189, 0.131629541516304, 0.131521791219711, 0.131413877010345, 0.131305783987045, 0.13119737803936, 0.131088837981224, 0.130979940295219, 0.130870848894119, 0.130761593580246, 0.130652025341988, 0.130542263388634, 0.130432412028313, 0.130322024226189, 0.130211606621742, 0.130101099610329, 0.129989922046661, 0.129878893494606, 0.12976761162281, 0.129655793309212, 0.129544124007225, 0.129432156682014, 0.129319787025452, 0.129207253456116, 0.129094392061234, 0.128981560468674, 0.1288683116436, 0.128754898905754, 0.12864126265049, 0.128527268767357, 0.128413066267967, 0.128298878669739, 0.12818418443203, 0.128069385886192, 0.127954378724098, 0.127838999032974, 0.127723529934883, 0.127607882022858, 0.12749183177948, 0.127375692129135, 0.127259343862534, 0.127142623066902, 0.127025797963142, 0.126908585429192, 0.126791268587112, 0.126673802733421, 0.126555725932121, 0.1264378875494, 0.126319646835327, 0.126201048493385, 0.126062631607056, 0.125924408435822, 0.125785142183304, 0.125645488500595, 0.125505328178406, 0.125364005565643, 0.12522266805172, 0.125080704689026, 0.124937579035759, 0.124794438481331, 0.124650411307812, 0.124505609273911, 0.124360665678978, 0.124214567244053, 0.124068081378937, 0.12392134219408, 0.123773440718651, 0.12362515181303, 0.123476222157478, 0.123326644301414, 0.12317667901516, 0.123025685548782, 0.122874423861504, 0.122722528874874, 0.122569851577282, 0.122416913509369, 0.122262962162495, 0.122108481824398, 0.12195336073637, 0.1217977181077, 0.12164156883955, 0.121484637260437, 0.121327199041843, 0.121169105172157, 0.121010489761829, 0.120850995182991, 0.1206910982728, 0.120530687272549, 0.120369508862495, 0.120207548141479, 0.120045199990273, 0.119882345199585, 0.119718708097935, 0.119554437696934, 0.11938963830471, 0.119224205613136, 0.119058109819889, 0.118891388177872, 0.118724405765533, 0.118556261062622, 0.118387721478939, 0.118218936026096, 0.118048720061779, 0.117878511548042, 0.117707915604115, 0.117535904049873, 0.117363885045052, 0.117190837860107, 0.117017529904842, 0.116843707859516, 0.116668857634068, 0.116493746638298, 0.116317607462406, 0.116141214966774, 0.115964293479919, 0.115786477923393, 0.115608148276806, 0.115429170429707, 0.115249797701836, 0.115069657564163, 0.11488888412714, 0.114707328379154, 0.114525504410267, 0.114342920482159, 0.114159554243088, 0.113975808024406, 0.113791279494762, 0.113606370985508, 0.113420560956001, 0.113234229385853, 0.113047517836094, 0.112859904766083, 0.1126718968153, 0.112482987344265, 0.11229382455349, 0.112103760242462, 0.111913047730923, 0.111721821129322, 0.11153020709753, 0.111337810754776, 0.11114464700222, 0.110950976610184, 0.110757037997246, 0.110562071204185, 0.110366590321064, 0.110170595347881, 0.109973557293415, 0.109776400029659, 0.109578721225262, 0.109379880130291, 0.109148763120174, 0.108904145658016, 0.108659401535988, 0.108415305614471, 0.108171217143536, 0.107927888631821, 0.107684180140495, 0.107441104948521, 0.10719920694828, 0.106956779956818, 0.106714360415936, 0.106472723186016, 0.106231458485126, 0.105990327894688, 0.105748943984509, 0.105508707463741, 0.105268478393555, 0.10502889752388, 0.104789316654205, 0.104550123214722, 0.104311056435108, 0.104072242975235, 0.103833690285683, 0.103595659136772, 0.103357739746571, 0.103120222687721, 0.102883733808994, 0.102646864950657, 0.102410115301609, 0.102173879742622, 0.101937778294086, 0.101702064275742, 0.101466737687588, 0.101231932640076, 0.100997112691402, 0.100762814283371, 0.100529029965401, 0.100295260548592, 0.100061602890491, 0.0998282060027122, 0.0995953306555748, 0.0993628427386284, 0.0991304740309715, 0.0988985002040863, 0.0986674278974533, 0.098435714840889, 0.0982048958539963, 0.0979742035269737, 0.0977436527609825, 0.097513347864151, 0.0972838252782822, 0.0970543026924133, 0.0968247726559639, 0.0965964049100876, 0.0963679179549217, 0.0961396843194962, 0.0959113165736198, 0.0956838503479958, 0.0954566448926926, 0.0952291861176491, 0.0950026214122772, 0.094776064157486, 0.0945502743124962, 0.094324491918087, 0.0940989553928375, 0.0938738211989403, 0.0936485528945923, 0.0934239253401756, 0.0931999385356903, 0.0929755792021751, 0.0927519872784615, 0.0925290286540985, 0.0923060849308968, 0.0920833945274353, 0.0918606966733932, 0.0916386619210243, 0.0914163440465927, 0.0911949500441551, 0.090973936021328, 0.0907526537775993, 0.090532548725605, 0.0903123095631599, 0.0900923311710358, 0.0898724645376205, 0.0896528661251068, 0.0894340425729752, 0.0892153531312943, 0.0889966562390327, 0.0887786149978638, 0.0885608121752739, 0.088343545794487, 0.0881261378526688, 0.0879095122218132, 0.0876924842596054, 0.0874761193990707, 0.0872601270675659, 0.0870445296168327, 0.086828924715519, 0.0866141095757484, 0.086399532854557, 0.0862157866358757, 0.0860571786761284, 0.0858998596668243, 0.0857435837388039, 0.085587814450264, 0.0854333341121674, 0.0852801501750946, 0.0851279869675636, 0.0849768593907356, 0.0848267748951912, 0.0846777111291885, 0.0845296680927277, 0.0843824222683907, 0.084236703813076, 0.0840917676687241, 0.0839473530650139, 0.0838044807314873, 0.0836634114384651, 0.0835225954651833, 0.083382822573185, 0.0832440704107285, 0.0831066220998764, 0.0829699337482452, 0.082834281027317, 0.0826999172568321, 0.0825660675764084, 0.0824342891573906, 0.0823030173778534, 0.0821727886795998, 0.0820435732603073, 0.0819151401519775, 0.0817880108952522, 0.0816618949174881, 0.081536553800106, 0.0814130231738091, 0.0812902674078941, 0.0811682790517807, 0.0810473337769508, 0.0809274017810822, 0.0808087810873985, 0.0806909203529358, 0.080574095249176, 0.0804583057761192, 0.0803437978029251, 0.0802308395504951, 0.0801183953881264, 0.0800069868564606, 0.0798963531851768, 0.0797872617840767, 0.0796786919236183, 0.0795714035630226, 0.0794654116034508, 0.0793599337339401, 0.0792562663555145, 0.0791530981659889, 0.0790512263774872, 0.0789501368999481, 0.0788500756025314, 0.078751303255558, 0.0786532983183861, 0.078556589782238, 0.078460656106472, 0.0783665254712105, 0.0782729014754295, 0.0781800672411919, 0.0780887678265572, 0.0779982507228851, 0.0779082477092743, 0.0778200402855873, 0.0777328759431839, 0.0776462256908417, 0.0775616392493248, 0.0774775594472885, 0.0773945152759552, 0.0773122534155846, 0.0772307589650154, 0.0771508142352104, 0.077071376144886, 0.0769937559962273, 0.0769166424870491, 0.0768415927886963, 0.0767665430903435, 0.0766927897930145, 0.0766203254461288, 0.0765481069684029, 0.0764776989817619, 0.0764080733060837, 0.0763394758105278, 0.076271653175354, 0.0762053653597832, 0.0761406421661377, 0.0760764256119728, 0.07601298391819, 0.0759508311748505, 0.075889453291893, 0.0758291035890579, 0.075770303606987, 0.075711764395237, 0.0756555423140526, 0.0755993202328682, 0.0755610689520836, 0.0755257457494736, 0.0754908695816994, 0.0754565075039864, 0.0754218176007271, 0.0753877684473991, 0.0753542482852936, 0.075320728123188, 0.0752870664000511, 0.0752547606825829, 0.0752218812704086, 0.0751896426081657, 0.0751579254865646, 0.0751258805394173, 0.0750949308276176, 0.0750637277960777, 0.0750329717993736, 0.0750026032328606, 0.0749723091721535, 0.0749426484107971, 0.074912928044796, 0.0748837813735008, 0.0748550221323967, 0.0748265311121941, 0.0747982189059258, 0.0747701153159142, 0.0747422575950623, 0.0747146084904671, 0.0746877193450928, 0.0746611580252647, 0.0746344700455666, 0.0746084153652191, 0.0745827555656433, 0.0745569691061974, 0.0745316296815872, 0.0745066106319427, 0.0744819194078445, 0.0744574815034866, 0.0744333788752556, 0.0744098350405693, 0.0743862986564636, 0.0743632912635803, 0.0743401423096657, 0.0743175745010376, 0.0742954015731812, 0.0742734745144844, 0.0742520093917847, 0.0742305442690849, 0.0742097795009613, 0.0741888210177422, 0.0741688385605812, 0.0741484612226486, 0.0741284117102623, 0.0741090029478073, 0.0740895420312881, 0.0740709006786346, 0.0740520805120468, 0.0740341544151306, 0.0740159079432487, 0.0739982426166534, 0.0739805772900581, 0.0739637464284897, 0.0739467218518257, 0.0739308074116707, 0.0739140957593918, 0.0738982409238815, 0.0738829597830772, 0.0738676115870476, 0.0738527849316597, 0.0738382190465927, 0.0738238394260406, 0.0738096609711647, 0.0737957283854485, 0.0737825110554695, 0.0737692341208458, 0.0737562030553818, 0.0737435668706894, 0.0737314522266388, 0.0737196430563927, 0.0737081170082092, 0.0736968964338303, 0.0736854150891304, 0.0736748427152634, 0.0736645311117172, 0.0736544653773308, 0.0736445412039757, 0.0736351236701012, 0.0736256465315819, 0.0736167505383492, 0.073608361184597, 0.0735995322465897, 0.0735918581485748, 0.0735840648412704, 0.0735769718885422, 0.0735700726509094, 0.0735632330179214, 0.0735567286610603, 0.073550283908844, 0.0735445395112038, 0.0735391229391098, 0.0735157206654549, 0.0734870955348015, 0.0734585300087929, 0.0734294503927231, 0.0733999907970428, 0.0733699426054955, 0.0733398348093033, 0.0733092054724693, 0.0732781961560249, 0.073246993124485, 0.0732151418924332, 0.0731833502650261, 0.0731507316231728, 0.0731180384755135, 0.0730848386883736, 0.0730511248111725, 0.0730172768235207, 0.0729829743504524, 0.0729483515024185, 0.0729132816195488, 0.0728778168559074, 0.072842039167881, 0.0728058665990829, 0.0727692469954491, 0.0727324336767197, 0.072694905102253, 0.0726573914289474, 0.0726193487644196, 0.0725809782743454, 0.0725420415401459, 0.0725029706954956, 0.0724637061357498, 0.0724236667156219, 0.0723833069205284, 0.0723428800702095, 0.0723016187548637, 0.0722602233290672, 0.0722185745835304, 0.072176605463028, 0.0721339881420135, 0.072091169655323, 0.0720478519797325, 0.0720041394233704, 0.0719601735472679, 0.0719159319996834, 0.0718709379434586, 0.0718259364366531, 0.0717806071043015, 0.0717347711324692, 0.0716883540153503, 0.0716418027877808, 0.0715949907898903, 0.0715473517775536, 0.0714998245239258, 0.0714518651366234, 0.0714031234383583, 0.071354441344738, 0.0713053196668625, 0.0712554752826691, 0.0712057054042816, 0.0711554065346718, 0.0711047425866127, 0.0710536167025566, 0.0710022896528244, 0.0709503889083862, 0.0708981081843376, 0.0708456188440323, 0.0707927495241165, 0.0707395598292351, 0.070685587823391, 0.0706316977739334, 0.070577085018158, 0.070522353053093, 0.0704673603177071, 0.0704119130969048, 0.0703557506203651, 0.0702996030449867, 0.0702429190278053, 0.0701857283711433, 0.0701285526156425, 0.0700709074735641, 0.0700126886367798, 0.0699542090296745, 0.0698952823877335, 0.0698359087109566, 0.0697762593626976, 0.0697163641452789, 0.0696560889482498, 0.0695954188704491, 0.0695341005921364, 0.0694725885987282, 0.0694108977913857, 0.0693483576178551, 0.0692858844995499, 0.069223016500473, 0.0691597685217857, 0.0690959468483925, 0.0690317898988724, 0.0689671859145164, 0.068902462720871, 0.0688214749097824, 0.0687496513128281, 0.0686767995357513, 0.0686036869883537, 0.0685304552316666, 0.0684561729431152, 0.0683817714452744, 0.0683069825172424, 0.0682316720485687, 0.0681558549404144, 0.0680795237421989, 0.068002924323082, 0.0679254308342934, 0.0678476691246033, 0.067769780755043, 0.0676907449960709, 0.0676117017865181, 0.0675325244665146, 0.0674523189663887, 0.0673718526959419, 0.0672910064458847, 0.0672095119953156, 0.0671273767948151, 0.0670452415943146, 0.0669624581933022, 0.0668791458010674, 0.066795215010643, 0.0667112618684769, 0.06662667542696, 0.0665413066744804, 0.0664558187127113, 0.0663699358701706, 0.0662829056382179, 0.0661962479352951, 0.0661088228225708, 0.066020630300045, 0.0659322962164879, 0.0658437088131905, 0.0657543540000916, 0.06566421687603, 0.0655740797519684, 0.0654835551977158, 0.0653921440243721, 0.0653008446097374, 0.0652086436748505, 0.0651161968708038, 0.0650229677557945, 0.0649293437600136, 0.0648354813456535, 0.0647409558296204, 0.0646460503339767, 0.0645508915185928, 0.0644548237323761, 0.06435876339674, 0.0642619207501411, 0.064164437353611, 0.064067080616951, 0.0639688298106194, 0.0638704374432564, 0.0637711510062218, 0.0636715963482857, 0.063571535050869, 0.0634709596633911, 0.0633701235055923, 0.0632688999176025, 0.0631669014692307, 0.0630645230412483, 0.0629617497324944, 0.0628583356738091, 0.0627546608448029, 0.0626504719257355, 0.0625458955764771, 0.0624406784772873, 0.0623350702226162, 0.062229335308075, 0.0621224381029606, 0.0620156675577164, 0.0619081258773804, 0.0618003234267235, 0.0616917535662651, 0.0615829192101955, 0.0614737085998058, 0.061363972723484, 0.0612534619867802, 0.061143085360527, 0.0610320642590523, 0.0609200038015842, 0.0608079507946968, 0.0606956407427788, 0.0605821684002876, 0.0604690760374069, 0.0603550896048546, 0.0602404586970806, 0.0601256936788559, 0.0600104182958603, 0.0598944909870625, 0.0597781836986542, 0.0596613585948944, 0.0595445297658443, 0.0594265460968018, 0.0593188554048538, 0.0591824278235435, 0.0590458735823631, 0.0589095763862133, 0.0587728917598724, 0.0586362071335316, 0.0584996566176414, 0.0583628378808498, 0.0582264177501202, 0.0580892153084278, 0.0579522736370564, 0.0578153319656849, 0.0576781332492828, 0.0575411915779114, 0.0574038624763489, 0.0572665296494961, 0.0571294650435448, 0.0569918751716614, 0.056854423135519, 0.0567168332636356, 0.0565791167318821, 0.0564417913556099, 0.0563039444386959, 0.0561662279069424, 0.056028388440609, 0.0558904111385345, 0.0557521805167198, 0.0556143373250961, 0.055475976318121, 0.0553378723561764, 0.0551997721195221, 0.0550615414977074, 0.0549230463802814, 0.0547845624387264, 0.0546459443867207, 0.0545074567198753, 0.0543687082827091, 0.0542300902307034, 0.0540912114083767, 0.0539525970816612, 0.0538135915994644, 0.0536745898425579, 0.0535354502499104, 0.0533963181078434, 0.053257055580616, 0.053117923438549, 0.0529786571860313, 0.0528395250439644, 0.0526998788118362, 0.0525602251291275, 0.05242083594203, 0.0522810518741608, 0.0521412752568722, 0.0520016252994537, 0.051861722022295, 0.0517219454050064, 0.0515820346772671, 0.0514417439699173, 0.0513017028570175, 0.0511614084243774, 0.0510213747620583, 0.0508809499442577, 0.0507405251264572, 0.0506003573536873, 0.0504598096013069, 0.0503191277384758, 0.0501784458756447, 0.0500377640128136, 0.0498970858752728, 0.0497562699019909, 0.0496154651045799, 0.0494745261967182, 0.0493331998586655, 0.0491923838853836, 0.0490510649979115, 0.0489097349345684, 0.048768799751997, 0.0486272126436234, 0.048486016690731, 0.0483441762626171, 0.0482027195394039, 0.048061266541481, 0.0479192957282066, 0.0477775819599628, 0.0476359948515892, 0.0474940240383148, 0.0473521836102009, 0.0472102127969265, 0.0470679849386215, 0.0469258837401867, 0.0467836558818817, 0.0466411709785461, 0.0464989393949509, 0.0463564582169056, 0.0462140999734402, 0.0460714809596539, 0.0459287390112877, 0.0457862541079521, 0.0456435084342957, 0.0455005057156086, 0.0453685075044632, 0.0452426597476006, 0.0451173186302185, 0.0449918545782566, 0.0448671616613865, 0.0447426028549671, 0.044618297368288, 0.0444945059716702, 0.044371236115694, 0.0442483462393284, 0.0441255904734135, 0.0440032221376896, 0.043881107121706, 0.0437597669661045, 0.0436385571956635, 0.0435174778103828, 0.0433971732854843, 0.0432769916951656, 0.0431572012603283, 0.0430377945303917, 0.0429189093410969, 0.0428001508116722, 0.0426820330321789, 0.0425639152526855, 0.0424463152885437, 0.0423289723694324, 0.0422122813761234, 0.0420958399772644, 0.0419797860085964, 0.0418639928102493, 0.0417485870420933, 0.041633564978838, 0.0415187999606133, 0.0414045564830303, 0.0412906967103481, 0.0411770939826965, 0.041063878685236, 0.0409510508179665, 0.0408384799957275, 0.04072654992342, 0.0406147539615631, 0.0405034758150578, 0.0403923206031322, 0.0402816869318485, 0.0401714406907558, 0.0400615744292736, 0.0399519726634026, 0.0398426242172718, 0.0397337935864925, 0.0396253503859043, 0.039517417550087, 0.0394098795950413, 0.0393024645745754, 0.0391955673694611, 0.0390887968242168, 0.0389824211597443, 0.0388765521347523, 0.038770817220211, 0.0386658571660519, 0.038561150431633, 0.0384567007422447, 0.0383527688682079, 0.038249097764492, 0.0381455533206463, 0.038042526692152, 0.0379400104284286, 0.0378375016152859, 0.0377360209822655, 0.0376342833042145, 0.0375333167612553, 0.0374326072633266, 0.0373320318758488, 0.0372319668531418, 0.0371320322155952, 0.0370328724384308, 0.0369339697062969, 0.0368355847895145, 0.0367371961474419, 0.0366391986608505, 0.036541972309351, 0.036444615572691, 0.0363477766513824, 0.0362515859305859, 0.0361556448042393, 0.0360597111284733, 0.0359646752476692, 0.0358696430921555, 0.0357749983668327, 0.0356807336211205, 0.0355866067111492, 0.0354935042560101, 0.0354001522064209, 0.0353074371814728, 0.0352149792015553, 0.0351230427622795, 0.035031620413065, 0.03494006767869, 0.034849289804697, 0.034758634865284, 0.0346683748066425, 0.0345669575035572, 0.03448236733675, 0.0343980379402637, 0.0343140959739685, 0.0342307947576046, 0.034147497266531, 0.034064844250679, 0.0339821875095367, 0.0339001789689064, 0.0338188111782074, 0.0337374471127987, 0.0336562097072601, 0.0335757471621037, 0.0334952846169472, 0.0334155969321728, 0.0333359055221081, 0.0332568623125553, 0.0331784635782242, 0.0331000611186028, 0.0330219194293022, 0.0329442955553532, 0.0328667983412743, 0.0327900797128677, 0.0327133536338806, 0.0326372720301151, 0.0325617119669914, 0.0324862748384476, 0.0324111022055149, 0.032336313277483, 0.0322619117796421, 0.0321881547570229, 0.0321142673492432, 0.0320411548018456, 0.0319685563445091, 0.0318960882723331, 0.0318237505853176, 0.0317520573735237, 0.0316804908216, 0.0316096991300583, 0.0315389074385166, 0.0314687639474869, 0.0313988700509071, 0.0313293673098087, 0.0312599949538708, 0.0311913974583149, 0.0311230551451445, 0.0310545843094587, 0.0309867579489946, 0.0309197064489126, 0.0308527816087008, 0.0307862460613251, 0.0307202264666557, 0.0306542050093412, 0.0305886995047331, 0.0305237118154764, 0.0304587222635746, 0.0303942486643791, 0.0303302928805351, 0.0302668511867523, 0.0302034076303244, 0.0301406122744083, 0.0300782006233931, 0.0300159193575382, 0.0299538969993591, 0.0298923887312412, 0.0298313982784748, 0.0297707933932543, 0.029710317030549, 0.029650354757905, 0.0295907817780972, 0.0295315962284803, 0.0294725373387337, 0.0294141266494989, 0.0293559711426497, 0.0292983315885067, 0.029240820556879, 0.0291838273406029, 0.0291272196918726, 0.0290711279958487, 0.029014777392149, 0.0289593320339918, 0.0289040133357048, 0.0288493409752846, 0.0287949256598949, 0.0287408977746964, 0.0286872554570436, 0.0286338701844215, 0.0285806152969599, 0.0285281334072351, 0.0284759104251862, 0.0284240748733282, 0.0283724963665009, 0.0283214338123798, 0.0282706283032894, 0.0282203387469053, 0.0281700491905212, 0.0281204059720039, 0.0280712768435478, 0.0280221477150917, 0.0279737934470177, 0.0279358066618443, 0.0278900936245918, 0.0278443172574043, 0.0277990587055683, 0.0277540553361177, 0.0277092456817627, 0.0276645012199879, 0.0276201441884041, 0.0275759156793356, 0.0275321379303932, 0.0274882297962904, 0.027444776147604, 0.0274016447365284, 0.0273586418479681, 0.0273157637566328, 0.0272732768207788, 0.0272309836000204, 0.0271889474242926, 0.0271469093859196, 0.0271053873002529, 0.0270640589296818, 0.0270228646695614, 0.0269818566739559, 0.0269412398338318, 0.026900751516223, 0.0268606469035149, 0.0268204174935818, 0.0267807003110647, 0.0267411135137081, 0.0267019774764776, 0.0266626495867968, 0.0266238991171122, 0.0265852175652981, 0.026546984910965, 0.0265088807791471, 0.0264707133173943, 0.0264331884682178, 0.0263957940042019, 0.0263585299253464, 0.0263213273137808, 0.0262846425175667, 0.0262482799589634, 0.0262118522077799, 0.0261755529791117, 0.02613983489573, 0.026104373857379, 0.0260689165443182, 0.0260335840284824, 0.0259987656027079, 0.025964081287384, 0.0259296521544456, 0.0258952230215073, 0.025861244648695, 0.0258275922387838, 0.0257941298186779, 0.0257606022059917, 0.0257275272160769, 0.0256948377937078, 0.0256622806191444, 0.0256297215819359, 0.0255976784974337, 0.0255657639354467, 0.0255340430885553, 0.0255023874342442, 0.0254713743925095, 0.0254402998834848, 0.025409609079361, 0.025378854945302, 0.0253488123416901, 0.0253185722976923, 0.025288850069046, 0.0252589359879494, 0.0252297911792994, 0.0252005867660046, 0.0251717045903206, 0.0251428168267012, 0.0251145157963037, 0.0250862743705511, 0.0250583589076996, 0.0250305701047182, 0.0250030402094126, 0.024975573644042, 0.0249486248940229, 0.0249218046665192, 0.0248951110988855, 0.0248687416315079, 0.0248424988240004, 0.0248167123645544, 0.0247909221798182, 0.0247655194252729, 0.024740181863308, 0.024715231731534, 0.0246904734522104, 0.0246659722179174, 0.0246415361762047, 0.0246176179498434, 0.0245937630534172, 0.0245700366795063, 0.0245467610657215, 0.0245234873145819, 0.0245049633085728, 0.0244888439774513, 0.02447266317904, 0.0244564805179834, 0.0244401022791862, 0.0244237277656794, 0.0244072210043669, 0.0243909098207951, 0.0243740826845169, 0.0243573188781738, 0.0243402346968651, 0.0243235994130373, 0.0243063848465681, 0.0242893658578396, 0.0242720860987902, 0.0242548063397408, 0.024237398058176, 0.0242198631167412, 0.0242021959275007, 0.0241847243160009, 0.0241669286042452, 0.0241490714251995, 0.024131016805768, 0.0241133533418179, 0.0240951701998711, 0.0240768603980541, 0.0240586772561073, 0.0240403674542904, 0.0240217987447977, 0.0240031648427248, 0.0239845346659422, 0.0239658355712891, 0.0239470098167658, 0.0239281188696623, 0.0239091645926237, 0.0238901451230049, 0.0238706730306149, 0.0238517187535763, 0.0238322466611862, 0.0238127764314413, 0.0237931758165359, 0.0237738341093063, 0.0237539131194353, 0.0237341169267893, 0.0237143877893686, 0.0236944667994976, 0.0236741565167904, 0.0236539151519537, 0.0236339271068573, 0.0236135553568602, 0.0235930494964123, 0.0235724840313196, 0.0235520452260971, 0.0235312841832638, 0.0235102660953999, 0.0234898291528225, 0.0234687458723783, 0.0234474688768387, 0.0234263204038143, 0.0234053693711758, 0.0233840271830559, 0.0233624279499054, 0.0233410876244307, 0.0233194250613451, 0.0232977624982595, 0.0232758410274982, 0.023254306986928, 0.0232322569936514, 0.0232102070003748, 0.0231881570070982, 0.0231658481061459, 0.023143669590354, 0.023121103644371, 0.0230987966060638, 0.0230762306600809, 0.0230534095317125, 0.023030711337924, 0.0230078883469105, 0.0229850001633167, 0.0229618549346924, 0.022938709706068, 0.0229156278073788, 0.022892352193594, 0.0228690132498741, 0.0228454153984785, 0.0228219460695982, 0.0227982234209776, 0.0227744951844215, 0.0227508321404457, 0.022726783528924, 0.0227028001099825, 0.0226786863058805, 0.0226547010242939, 0.0226302668452263, 0.0226059593260288, 0.0225813332945108, 0.0225570276379585, 0.0225322693586349, 0.0225075744092464, 0.0224827509373426, 0.0224483236670494, 0.0224078334867954, 0.0223670862615108, 0.022326210513711, 0.0222850777208805, 0.0222435537725687, 0.0222019050270319, 0.0221599321812391, 0.0221178326755762, 0.0220756009221077, 0.022032855078578, 0.0219901744276285, 0.0219469126313925, 0.0219033919274807, 0.0218598078936338, 0.0218161623924971, 0.0217718668282032, 0.0217275097966194, 0.0216831509023905, 0.0216382779181004, 0.0215930826961994, 0.021547757089138, 0.0215023029595613, 0.0214565265923738, 0.0214104913175106, 0.0213640071451664, 0.0213177818804979, 0.0212709084153175, 0.0212238430976868, 0.0211767759174109, 0.0211293250322342, 0.021081356331706, 0.0210331920534372, 0.0209853556007147, 0.0209368709474802, 0.0208880007266998, 0.0208393875509501, 0.0207900013774633, 0.0207405481487513, 0.0206907112151384, 0.0206409376114607, 0.0205907765775919, 0.0205404236912727, 0.0204898118972778, 0.020438814535737, 0.0203877501189709, 0.020336365327239, 0.0202849134802818, 0.0202328208833933, 0.0201806612312794, 0.0201283097267151, 0.0200759563595057, 0.0200231522321701, 0.0199699606746435, 0.0199167691171169, 0.0198631938546896, 0.0198092926293612, 0.0197552647441626, 0.0197009798139334, 0.0196464322507381, 0.0195916946977377, 0.0195365697145462, 0.0194815117865801, 0.0194259975105524, 0.0193702951073647, 0.0193140730261803, 0.0192579813301563, 0.0192014388740063, 0.0191447641700506, 0.0190878324210644, 0.0190307106822729, 0.01897307112813, 0.0189154986292124, 0.0188575349748135, 0.0187995079904795, 0.0187410302460194, 0.0186823606491089, 0.0186233669519424, 0.0185645036399364, 0.0185050591826439, 0.0184452924877405, 0.0183855891227722, 0.0183253716677427, 0.0182649586349726, 0.0182044822722673, 0.018143555149436, 0.0180824995040894, 0.0180211216211319, 0.0179595462977886, 0.0178979765623808, 0.0178359523415565, 0.0177734792232513, 0.017711004242301, 0.01764833368361, 0.0175852160900831, 0.0175219010561705, 0.0174586530774832, 0.017394632101059, 0.01733080111444, 0.0172665230929852, 0.0171821266412735, 0.0171093344688416, 0.0170369334518909, 0.0169643349945545, 0.0168918669223785, 0.0168193355202675, 0.0167471244931221, 0.0166747849434614, 0.0166027694940567, 0.0165306217968464, 0.0164587330073118, 0.0163868460804224, 0.0163147635757923, 0.0162432640790939, 0.0161715038120747, 0.0160996802151203, 0.016028244048357, 0.0159568078815937, 0.0158852431923151, 0.0158139988780022, 0.0157428830862045, 0.0156714469194412, 0.0156005918979645, 0.0155295422300696, 0.0154584273695946, 0.0153876999393106, 0.0153170367702842, 0.0152462450787425, 0.0151756461709738, 0.0151051124557853, 0.0150347072631121, 0.0149643020704389, 0.014893832616508, 0.0148235568776727, 0.0147534087300301, 0.0146836489439011, 0.0146134374663234, 0.0145434839650989, 0.0144737875089049, 0.0144037054851651, 0.0143342679366469, 0.0142647000029683, 0.0141948759555817, 0.0141253732144833, 0.0140561927109957, 0.0139866257086396, 0.013917381875217, 0.0138483308255672, 0.0137790208682418, 0.0137102277949452, 0.0136413061991334, 0.0135724479332566, 0.0135035896673799, 0.0134347975254059, 0.0133661972358823, 0.0132977264001966, 0.0132291913032532, 0.0131608489900827, 0.01309257093817, 0.0130241652950644, 0.0129560166969895, 0.0128881260752678, 0.0128201069310308, 0.0127518931403756, 0.012684260495007, 0.0126163708046079, 0.0125484792515635, 0.0124810403212905, 0.0124136013910174, 0.012345839291811, 0.0122784646227956, 0.0122112836688757, 0.0121437795460224, 0.0120767913758755, 0.0120096104219556, 0.0119427507743239, 0.0118756331503391, 0.0118088405579329, 0.0117421094328165, 0.0116751864552498, 0.0116085847839713, 0.0115421125665307, 0.0114755118265748, 0.0114091048017144, 0.0113428253680468, 0.0112766101956367, 0.0112105263397098, 0.0111443111672997, 0.0110782254487276, 0.0110124619677663, 0.0109463129192591, 0.010880614630878, 0.0108149806037545, 0.0107494108378887, 0.0106837125495076, 0.0106183364987373, 0.0105528952553868, 0.0104873264208436, 0.0104222083464265, 0.0103570250794291, 0.0103067355230451, 0.0102538671344519, 0.010201514698565, 0.0101496782153845, 0.010097841732204, 0.0100465212017298, 0.00999545864760876, 0.0099449111148715, 0.00989410560578108, 0.00984407402575016, 0.00979455839842558, 0.009745042771101, 0.00969552714377642, 0.00964704342186451, 0.00959855876863003, 0.00955007411539555, 0.00950236339122057, 0.00945465359836817, 0.0094074597582221, 0.00936052296310663, 0.0093141021206975, 0.00926768127828836, 0.00922177545726299, 0.00917612854391336, 0.00913073867559433, 0.0090861227363348, 0.00904112029820681, 0.00899663381278515, 0.0089527927339077, 0.0089089497923851, 0.00886562373489141, 0.0088225556537509, 0.00877974461764097, 0.00873693451285362, 0.00869541428983212, 0.00865311920642853, 0.00861185509711504, 0.00857097934931517, 0.00852984562516212, 0.00848935637623072, 0.00844912510365248, 0.00840915180742741, 0.00836943555623293, 0.00833049323409796, 0.00829129386693239, 0.00825286656618118, 0.00821469910442829, 0.00817627273499966, 0.0081388782709837, 0.00810148380696774, 0.00806460529565811, 0.00802772678434849, 0.00799136329442263, 0.00795525778084993, 0.00791953969746828, 0.00788433663547039, 0.0078490050509572, 0.00781418941915035, 0.00777963176369667, 0.00774584757164121, 0.00771154789254069, 0.00767828011885285, 0.00764526892453432, 0.00761200068518519, 0.00757976388558745, 0.007547527551651, 0.00751580623909831, 0.00748382741585374, 0.00745262205600739, 0.00742167513817549, 0.00739124370738864, 0.00736055383458734, 0.00733063835650682, 0.00730123883113265, 0.00727158086374402, 0.00724243884906173, 0.00721407029777765, 0.0071854442358017, 0.00715720513835549, 0.00712973903864622, 0.00710240239277482, 0.00707480777055025, 0.00704850256443024, 0.0070216809399426, 0.00699563371017575, 0.00696971546858549, 0.0069440552033484, 0.00691878143697977, 0.00689428206533194, 0.00686952378600836, 0.00684553943574429, 0.0068215555511415, 0.00679757120087743, 0.00677461922168732, 0.00675140833482146, 0.00672871340066195, 0.00670653488487005, 0.00668435590341687, 0.00666295038536191, 0.00664128735661507, 0.00663851527497172, 0.00662564625963569, 0.00661290483549237, 0.00660003675147891, 0.00658781081438065, 0.00657558673992753, 0.00656323321163654, 0.00655152462422848, 0.00653955759480596, 0.00652810838073492, 0.00651639699935913, 0.00650507770478725, 0.00649401312693954, 0.0064829490147531, 0.00647188443690538, 0.00646120682358742, 0.00645091664046049, 0.00644036941230297, 0.00643046433106065, 0.0064201750792563, 0.00641027139499784, 0.00640062522143126, 0.00639097904786468, 0.00638159131631255, 0.00637246388942003, 0.00636320421472192, 0.00635420391336083, 0.00634558871388435, 0.00633684732019901, 0.00632836110889912, 0.00632013427093625, 0.00631203502416611, 0.00630419515073299, 0.00629622582346201, 0.00628851400688291, 0.00628118962049484, 0.00627373764291406, 0.00626641139388084, 0.00625960435718298, 0.0062527940608561, 0.00624585710465908, 0.00623956369236112, 0.00623301276937127, 0.00622697733342648, 0.00622081430628896, 0.00621490646153688, 0.00620913039892912, 0.00620361091569066, 0.00619809189811349, 0.00619295984506607, 0.0061878259293735, 0.00618269527330995, 0.00617807824164629, 0.00617333222180605, 0.00616884510964155, 0.00616461550816894, 0.00616051396355033, 0.00615667132660747, 0.00615269783884287, 0.00614898465573788, 0.00614552805200219, 0.00614220090210438, 0.00613887375220656, 0.00613606395199895, 0.00613312143832445, 0.00613031163811684, 0.00612788600847125, 0.00612533371895552, 0.0061230375431478, 0.00612112833186984, 0.00611922051757574, 0.00611744076013565, 0.00611591804772615, 0.00611426727846265, 0.00611326238140464, 0.00611212570220232, 0.00611099088564515, 0.00611037062481046, 0.00610962463542819, 0.00610900484025478, 0.00610890053212643, 0.00610866816714406, 0.00610869424417615, 0.00610884744673967, 0.00610913150012493, 0.00610954267904162, 0.00611034268513322, 0.00611101230606437, 0.00611194036900997, 0.00611312687397003, 0.0061143129132688, 0.00611601397395134, 0.00611745892092586, 0.00611916044726968, 0.00612124893814325, 0.00612320937216282, 0.00612529646605253, 0.00612790137529373, 0.00613024830818176, 0.00613298127427697, 0.00612547295168042, 0.00612291926518083, 0.00612026918679476, 0.00611749012023211, 0.00611477438360453, 0.00611196411773562, 0.0061091217212379, 0.00610618060454726, 0.00610320875421166, 0.00610020291060209, 0.00609716633334756, 0.0060940645635128, 0.00609086593613029, 0.00608766777440906, 0.00608437322080135, 0.00608104513958097, 0.00607768632471561, 0.00607426231727004, 0.00607080571353436, 0.0060672857798636, 0.00606369925662875, 0.00606008293107152, 0.00605640234425664, 0.0060527203604579, 0.00604887679219246, 0.00604503462091088, 0.00604119105264544, 0.00603725155815482, 0.0060332459397614, 0.00602921098470688, 0.0060251415707171, 0.00602104049175978, 0.00601677829399705, 0.0060125500895083, 0.00600831909105182, 0.00600396143272519, 0.00599953671917319, 0.00599511433392763, 0.00599062768742442, 0.00598610658198595, 0.00598152261227369, 0.00597680918872356, 0.00597216002643108, 0.00596741400659084, 0.00596260512247682, 0.00595772871747613, 0.00595282390713692, 0.00594791490584612, 0.00594291370362043, 0.00593784498050809, 0.00593271246179938, 0.00592758040875196, 0.00592235149815679, 0.00591705739498138, 0.00591176375746727, 0.00590643798932433, 0.00590101489797235, 0.00589556060731411, 0.00589004019275308, 0.00588445737957954, 0.00587884243577719, 0.00587316183373332, 0.00586744910106063, 0.00586170330643654, 0.00585589371621609, 0.00585002033039927, 0.00584404915571213, 0.00583807937800884, 0.00583207700401545, 0.00582604110240936, 0.00581984594464302, 0.00581364938989282, 0.00580745236948133, 0.00580119248479605, 0.00579483387991786, 0.005788445007056, 0.0057820244692266, 0.00577556854113936, 0.00576901854947209, 0.00576237076893449, 0.00575578724965453, 0.00574910873547196, 0.00574233056977391, 0.0057355547323823, 0.00572868157178164, 0.00572184007614851, 0.0057149026542902, 0.00570783717557788, 0.00570083456113935, 0.00569373602047563, 0.00568657135590911, 0.0056793768890202, 0.00567211676388979, 0.00566485617309809, 0.00565750012174249, 0.00565007841214538, 0.00564262457191944, 0.00563510647043586, 0.00562758883461356, 0.00561990961432457, 0.00561328744515777, 0.00560049945488572, 0.00558765325695276, 0.00557470833882689, 0.00556172709912062, 0.00554871745407581, 0.00553564494475722, 0.00552250305190682, 0.00550933228805661, 0.00549612753093243, 0.00548285990953445, 0.00546952802687883, 0.00545612955465913, 0.00544270128011703, 0.00542920781299472, 0.00541571294888854, 0.00540209095925093, 0.00538849690929055, 0.00537481065839529, 0.00536106154322624, 0.00534724211320281, 0.00533342687413096, 0.00531954877078533, 0.00530563062056899, 0.00529165612533689, 0.0052775489166379, 0.00526347290724516, 0.00524933775886893, 0.0052351332269609, 0.00522086443379521, 0.005206567235291, 0.0051922663114965, 0.00517786899581552, 0.0051634106785059, 0.00514888390898705, 0.00513435760512948, 0.00511970231309533, 0.00510505074635148, 0.00509036239236593, 0.00507564237341285, 0.00506082968786359, 0.00504598114639521, 0.00503103528171778, 0.00501608941704035, 0.00500107929110527, 0.00498597603291273, 0.00497086998075247, 0.00495573040097952, 0.00494053028523922, 0.00492526218295097, 0.00490992981940508, 0.00489453738555312, 0.00487913563847542, 0.00486371107399464, 0.00484812445938587, 0.00483256205916405, 0.00481694331392646, 0.00480129243806005, 0.00478553678840399, 0.00476975692436099, 0.00475390860810876, 0.00473809242248535, 0.0047220871783793, 0.00470610987395048, 0.00469010043889284, 0.00467403046786785, 0.00465785572305322, 0.00464168889448047, 0.00462545733898878, 0.00460918620228767, 0.0045928587205708, 0.00457639759406447, 0.00456000119447708, 0.0045435125939548, 0.00452688988298178, 0.00451033236458898, 0.00449371431022882, 0.00447702826932073, 0.00446027750149369, 0.0044434298761189, 0.00442661810666323, 0.00440970622003078, 0.00439276173710823, 0.00437572505325079, 0.00435868371278048, 0.00434161024168134, 0.00432447250932455, 0.00430720578879118, 0.00428997492417693, 0.00427267607301474, 0.00425531296059489, 0.00423785671591759, 0.0042203962802887, 0.00420290417969227, 0.00418535154312849, 0.00416769366711378, 0.00415004417300224, 0.00413232995197177, 0.0041145752184093, 0.00409679720178246, 0.00408112909644842, 0.00406334223225713, 0.00404556374996901, 0.00402784952893853, 0.00401012739166617, 0.00399254215881228, 0.0039749532006681, 0.00395749323070049, 0.0039400365203619, 0.00392263708636165, 0.00390524533577263, 0.00388791807927191, 0.00387071166187525, 0.00385351339355111, 0.00383631093427539, 0.00381923769600689, 0.0038021681830287, 0.00378515920601785, 0.00376815046183765, 0.00375127466395497, 0.00373439444229007, 0.0037175789475441, 0.00370089267380536, 0.00368420989252627, 0.00366758811287582, 0.00365096586756408, 0.00363441207446158, 0.00361798354424536, 0.00360142579302192, 0.00358512625098228, 0.00356883066706359, 0.00355253089219332, 0.00353623111732304, 0.00352006009779871, 0.00350395822897553, 0.00348778744228184, 0.00347174564376473, 0.00345583655871451, 0.00343998847529292, 0.00342394667677581, 0.00340816681273282, 0.00339237856678665, 0.00337672769092023, 0.00336094782687724, 0.00334535329602659, 0.00332983117550611, 0.00331424479372799, 0.00329877925105393, 0.00328338611871004, 0.0032680535223335, 0.00325265666469932, 0.00323739252053201, 0.00322224921546876, 0.00320711405947804, 0.00319184991531074, 0.00317683536559343, 0.00316182943060994, 0.0031469480600208, 0.00313193793408573, 0.00311712501570582, 0.00310230813920498, 0.00308749149553478, 0.00307280733250082, 0.00305818417109549, 0.00304362503811717, 0.00302900583483279, 0.0030145114287734, 0.00300008151680231, 0.00298571586608887, 0.00297129014506936, 0.00295705371536314, 0.00294281705282629, 0.00292851589620113, 0.00291441241279244, 0.00290036923252046, 0.00288632581941783, 0.00287221861071885, 0.00285837263800204, 0.00284452293999493, 0.00283067324198782, 0.0028168277349323, 0.00280310679227114, 0.00278951483778656, 0.0027759273070842, 0.00276220240630209, 0.00274874363094568, 0.00273528485558927, 0.00272188242524862, 0.00270842364989221, 0.00269515789113939, 0.00268182018771768, 0.0026685546617955, 0.0026554143987596, 0.00264233816415071, 0.00262926588766277, 0.00261618592776358, 0.00260324310511351, 0.00259030004963279, 0.00257747760042548, 0.00256466353312135, 0.00255070114508271, 0.00254196510650218, 0.00253309984691441, 0.00252446020022035, 0.00251582101918757, 0.00250727823004127, 0.00249879970215261, 0.00249035400338471, 0.00248210155405104, 0.00247384863905609, 0.00246566068381071, 0.00245760125108063, 0.0024495420511812, 0.00244148285128176, 0.00243361736647785, 0.00242594489827752, 0.00241827266290784, 0.00241047120653093, 0.00240299198776484, 0.00239551346749067, 0.0023882279638201, 0.00238081347197294, 0.00237352773547173, 0.00236643571406603, 0.00235944031737745, 0.00235221930779517, 0.00234525627456605, 0.00233845436014235, 0.00233174907043576, 0.00232491502538323, 0.00231830636039376, 0.00231179455295205, 0.00230525061488152, 0.00229883543215692, 0.0022926137316972, 0.00228639203123748, 0.00228004110977054, 0.00227401312440634, 0.00226798467338085, 0.00226215017028153, 0.00225612171925604, 0.00225028651766479, 0.0022446452639997, 0.00223887502215803, 0.00223342701792717, 0.00222797901369631, 0.00222253100946546, 0.00221714749932289, 0.00221189297735691, 0.00220683170482516, 0.00220167404040694, 0.00219658063724637, 0.00219171261414886, 0.00218678032979369, 0.00218200939707458, 0.002177206100896, 0.00217262841761112, 0.00216805073432624, 0.00216344092041254, 0.0021591535769403, 0.00215476914308965, 0.00215057865716517, 0.00214635534211993, 0.00214226124808192, 0.00213826424442232, 0.00213426677510142, 0.00213026930578053, 0.00212656194344163, 0.00212285481393337, 0.00211924430914223, 0.00211560167372227, 0.00211208779364824, 0.00210876716300845, 0.00210531800985336, 0.00210209446959198, 0.0020989675540477, 0.00209584063850343, 0.00209268135949969, 0.00208984431810677, 0.00208691088482738, 0.00208410643972456, 0.00208123726770282, 0.00207869033329189, 0.00207614386454225, 0.00207369378767908, 0.00207121158018708, 0.00206885859370232, 0.00206660176627338, 0.00206431304104626, 0.0020622496958822, 0.00206028344109654, 0.00205831695348024, 0.00205631833523512, 0.00205457769334316, 0.00205280445516109, 0.0020512246992439, 0.00204951642081141, 0.00204803352244198, 0.00204664724878967, 0.00204522884450853, 0.00204158597625792, 0.00204032869078219, 0.00203910376876593, 0.00203791097737849, 0.00203671818599105, 0.00203559012152255, 0.00203439733013511, 0.00203330116346478, 0.00203226949088275, 0.0020312056876719, 0.00203017424792051, 0.00202917470596731, 0.00202824012376368, 0.00202730507589877, 0.0020263702608645, 0.00202549993991852, 0.0020246293861419, 0.00202379142865539, 0.00202298536896706, 0.00202217954210937, 0.00202137371525168, 0.00202063214965165, 0.00201992294751108, 0.00201924587599933, 0.00201856880448759, 0.00201792432926595, 0.00201734388247132, 0.00201673153787851, 0.00201618345454335, 0.00201566773466766, 0.00201515201479197, 0.0020146684255451, 0.00201415247283876, 0.00201373337768018, 0.00201334664598107, 0.0020129275508225, 0.00201260531321168, 0.00201225071214139, 0.00201196037232876, 0.00201170262880623, 0.00201144465245306, 0.00201121903955936, 0.00201099342666566, 0.00201083207502961, 0.00201070308685303, 0.00201057433150709, 0.00201047770678997, 0.00201031635515392, 0.00201028422452509, 0.00201028422452509, 0.00201025186106563, 0.00201031635515392, 0.00201034848578274, 0.0020104453433305, 0.00201054196804762, 0.0020106709562242, 0.00201083207502961, 0.00201099342666566, 0.00201121903955936, 0.0020114122889936, 0.00201163813471794, 0.00201192824169993, 0.00201225071214139, 0.00201257294975221, 0.00201295968145132, 0.00201334664598107, 0.00201376574113965, 0.00201418483629823, 0.00201463606208563, 0.00201515201479197, 0.00201566773466766, 0.00201621581800282, 0.00201676366850734, 0.00201727938838303, 0.00201792432926595, 0.00201856880448759, 0.00201921374537051, 0.00201992294751108, 0.00202063214965165, 0.00202137371525168, 0.00202214741148055, 0.00202295323833823, 0.00202379142865539, 0.00202459725551307, 0.00202549993991852, 0.00202640239149332, 0.00202724081464112, 0.00202820776030421, 0.00202917470596731, 0.00203017424792051, 0.0020312056876719, 0.00203223736025393, 0.00203333352692425, 0.00203442946076393, 0.00203555775806308, 0.00203671818599105, 0.00203787884674966, 0.00203910376876593, 0.00204032869078219, 0.00204152148216963, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204290798865259, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204252102412283, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204239180311561, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219, 0.00204252079129219   }, 
}; 

// background map
float ReadLikelihood::fRefB[][10000] = 
{ 
   { 2.7976184e-05, 2.6978816e-05, 2.5931578e-05, 2.4909275e-05, 2.3911907e-05, 2.2914539e-05, 2.1967038e-05, 2.1044472e-05, 2.0121908e-05, 1.9224277e-05, 1.835158e-05, 1.7478882e-05, 1.6656051e-05, 1.5808289e-05, 1.5035329e-05, 1.4262368e-05, 1.3489408e-05, 1.2816184e-05, 1.2118026e-05, 1.1394935e-05, 1.072171e-05, 1.0073421e-05, 9.4251318e-06, 8.8267107e-06, 8.2033548e-06, 7.6298684e-06, 7.10625e-06, 6.5327631e-06, 6.034079e-06, 5.5603286e-06, 5.0616445e-06, 4.6128284e-06, 4.1640128e-06, 3.7899999e-06, 3.4159868e-06, 3.0170395e-06, 2.6679604e-06, 2.3438158e-06, 2.019671e-06, 1.7453948e-06, 1.4461842e-06, 1.196842e-06, 9.7243424e-07, 7.4802631e-07, 5.4855263e-07, 3.9894735e-07, 2.2440788e-07, 9.9736837e-08, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 2.2713534e-15, 7.4802628e-08, 2.2440788e-07, 3.7401315e-07, 5.2361838e-07, 7.2309211e-07, 9.4749998e-07, 1.196842e-06, 1.4461842e-06, 1.6955263e-06, 1.9947367e-06, 2.3188816e-06, 2.6430262e-06, 2.9921052e-06, 3.3661183e-06, 3.7401314e-06, 4.1640128e-06, 4.5629604e-06, 5.011776e-06, 5.5104606e-06, 5.9842105e-06, 6.4828946e-06, 7.0314472e-06, 7.6049341e-06, 8.178421e-06, 8.7768422e-06, 9.3752633e-06, 1.0023552e-05, 1.0646907e-05, 1.132013e-05, 1.2018289e-05, 1.2716447e-05, 1.3464473e-05, 1.42125e-05, 1.4960526e-05, 1.5783355e-05, 1.6556316e-05, 1.740408e-05, 1.8251842e-05, 1.9174407e-05, 2.0072041e-05, 2.0994605e-05, 2.1892236e-05, 2.286467e-05, 2.381217e-05, 2.4809538e-05, 2.583184e-05, 2.6854144e-05, 2.790138e-05, 2.8998486e-05, 3.0070658e-05, 3.1192696e-05, 3.2289801e-05, 3.3461711e-05, 3.4683486e-05, 3.5855395e-05, 3.707717e-05, 3.8323884e-05, 3.9570594e-05, 4.0842235e-05, 4.2138818e-05, 4.3435393e-05, 4.4781838e-05, 4.6103352e-05, 4.749967e-05, 4.8895989e-05, 5.0292299e-05, 5.1738483e-05, 5.3209606e-05, 5.4655789e-05, 5.6201709e-05, 5.7697762e-05, 5.9243681e-05, 6.0814538e-05, 6.2360457e-05, 6.395625e-05, 6.5576969e-05, 6.7197696e-05, 6.8868292e-05, 7.0513946e-05, 7.2234405e-05, 7.3954863e-05, 7.5675322e-05, 7.7420715e-05, 7.9215984e-05, 8.0986312e-05, 8.2856379e-05, 8.4701511e-05, 8.654665e-05, 8.8441637e-05, 9.0311703e-05, 9.2231639e-05, 9.3141367e-05, 9.5173498e-05, 9.7230564e-05, 9.928763e-05, 0.00010136962, 0.00010346409, 0.00010558349, 0.00010772782, 0.00010988463, 0.00011205389, 0.00011426055, 0.00011646723, 0.00011872376, 0.00012096783, 0.00012322437, 0.00012550585, 0.00012782472, 0.00013013113, 0.00013248739, 0.00013485613, 0.0001372124, 0.00013963101, 0.00014202468, 0.00014446824, 0.00014694917, 0.0001494052, 0.00015191107, 0.00015440446, 0.00015697267, 0.00015952844, 0.00016208416, 0.00016466486, 0.00016725801, 0.00016988853, 0.00017254404, 0.00017519952, 0.00017787993, 0.00018057281, 0.00018329063, 0.00018602092, 0.00018877615, 0.00019155628, 0.00019433645, 0.000197154, 0.00019999649, 0.00020285144, 0.00020573132, 0.00020859877, 0.00021151605, 0.00021440841, 0.00021736309, 0.00022034273, 0.00022329742, 0.00022630197, 0.00022930653, 0.0002323485, 0.00023539046, 0.0002384823, 0.00024157412, 0.00024466595, 0.00024782013, 0.00025096181, 0.0002541409, 0.00025732, 0.00026052404, 0.000263753, 0.00026696949, 0.00027023585, 0.00027351471, 0.00027680601, 0.00028013473, 0.00028345097, 0.00028681706, 0.00029020809, 0.00029356175, 0.00029699015, 0.00030041859, 0.00030387199, 0.00030732539, 0.00031081613, 0.00031433188, 0.00031784756, 0.00032138822, 0.00032491639, 0.0003285069, 0.00033210983, 0.00033571286, 0.00033935325, 0.00034299362, 0.00034667138, 0.00035037412, 0.00035406434, 0.00035782941, 0.0003615446, 0.00036533459, 0.00036911209, 0.00037290208, 0.00037672944, 0.00038054437, 0.00038442164, 0.00039059127, 0.00039471159, 0.00039883505, 0.00040296162, 0.00040711628, 0.00041126154, 0.00041544734, 0.00041963314, 0.00042381269, 0.00042802966, 0.00043222483, 0.00043646045, 0.00044071482, 0.00044495676, 0.00044922356, 0.00045348416, 0.00045778215, 0.00046206149, 0.00046637817, 0.000470698, 0.00047500845, 0.00047936878, 0.00048369795, 0.000488077, 0.00049245916, 0.00049683196, 0.0005012328, 0.00050563988, 0.00051006564, 0.00051451015, 0.00051893597, 0.00052339915, 0.00052785297, 0.00053233485, 0.00053684477, 0.00054132042, 0.00054584909, 0.00055035594, 0.00055489078, 0.00055942562, 0.00056398858, 0.00056856713, 0.00057313626, 0.00057774596, 0.00058232754, 0.00058695284, 0.00059158116, 0.00059620332, 0.00060086598, 0.00060551619, 0.0006101944, 0.00061487575, 0.00061955716, 0.00062426965, 0.00062898215, 0.0006337103, 0.00063843216, 0.00064319145, 0.00064796943, 0.00065271935, 0.00065751915, 0.00066231267, 0.00066712499, 0.00067194965, 0.00067675265, 0.00068160857, 0.0006864426, 0.0006913172, 0.00069620734, 0.00070107577, 0.00070598151, 0.00071087794, 0.00071580557, 0.00072074559, 0.00072567625, 0.00073064439, 0.00073559379, 0.00074058055, 0.00074555184, 0.0007505698, 0.0007555784, 0.00076059013, 0.00076563616, 0.00077067903, 0.00077574688, 0.0007808209, 0.00078588258, 0.0007909722, 0.00079606811, 0.00080118893, 0.00080632535, 0.0008114524, 0.00081660436, 0.00082175009, 0.00082692079, 0.00083211949, 0.00083729648, 0.00084250147, 0.00084771583, 0.00085295504, 0.00085796049, 0.00086327147, 0.00086859486, 0.0008739027, 0.00087921362, 0.00088452146, 0.00088982622, 0.00089513406, 0.00090042321, 0.00090573414, 0.00091102329, 0.00091632793, 0.0009216108, 0.00092690927, 0.00093220465, 0.00093748758, 0.00094277674, 0.00094805338, 0.00095333625, 0.00095861603, 0.00096389576, 0.00096916617, 0.00097444287, 0.00097970711, 0.00098498061, 0.00099024165, 0.00099550595, 0.0010007669, 0.0010060249, 0.001011286, 0.0010165471, 0.0010218081, 0.0010270505, 0.0010323023, 0.0010375477, 0.0010427994, 0.0010480357, 0.0010532811, 0.0010585141, 0.0010637534, 0.0010689957, 0.0010742225, 0.0010794618, 0.0010846792, 0.0010899123, 0.0010951298, 0.0011003627, 0.0011055771, 0.0011107976, 0.001116012, 0.0011212294, 0.0011264468, 0.0011316518, 0.0011368662, 0.0011420649, 0.001147276, 0.0011524748, 0.0011576735, 0.0011628693, 0.0011680617, 0.0011732574, 0.001178453, 0.0011836423, 0.0011888316, 0.0011940274, 0.001199198, 0.0012043843, 0.0012095612, 0.0012147351, 0.001219912, 0.0012250858, 0.0012302565, 0.0012354241, 0.0012405916, 0.0012457559, 0.0012509174, 0.0012560757, 0.0012612371, 0.0012663921, 0.0012715533, 0.0012767023, 0.0012818574, 0.0012870032, 0.0012921488, 0.0012972915, 0.0013024341, 0.0013075706, 0.00131271, 0.0013178497, 0.0013229798, 0.0013281131, 0.001333237, 0.0013383671, 0.0013434911, 0.0013486183, 0.0013537389, 0.0013588568, 0.0013639745, 0.0013690923, 0.0013742006, 0.0013774793, 0.0013823976, 0.0013873095, 0.0013922091, 0.0013970836, 0.0014019583, 0.0014068141, 0.0014116575, 0.0014164761, 0.0014212885, 0.001426082, 0.001430863, 0.0014356379, 0.0014404003, 0.0014451441, 0.0014498876, 0.0014546065, 0.0014593065, 0.0014639942, 0.0014686692, 0.0014733381, 0.0014779759, 0.0014826198, 0.0014872325, 0.0014918455, 0.0014964393, 0.0015010334, 0.0015056026, 0.0015101532, 0.0015146974, 0.0015192229, 0.0015237359, 0.0015282304, 0.0015327184, 0.0015371941, 0.001541651, 0.0015460893, 0.0015505275, 0.0015549409, 0.0015593541, 0.0015637488, 0.001568131, 0.0015724944, 0.0015768391, 0.0015811777, 0.0015854974, 0.0015898111, 0.0015940997, 0.0015983884, 0.0016026521, 0.0016069034, 0.0016111546, 0.0016153873, 0.001619601, 0.0016237962, 0.0016279912, 0.0016321616, 0.0016363192, 0.0016404645, 0.0016445974, 0.0016487114, 0.0016528193, 0.001656921, 0.0016609976, 0.0016650681, 0.0016691136, 0.001673153, 0.0016771735, 0.001681188, 0.0016851836, 0.0016891669, 0.0016931314, 0.0016970898, 0.0017010355, 0.0017049687, 0.0017088773, 0.0017127856, 0.0017166692, 0.0017205524, 0.0017244112, 0.0017282509, 0.0017320784, 0.0017358995, 0.0017397081, 0.001743498, 0.0017472942, 0.0017510531, 0.0017548057, 0.0017585396, 0.0017622672, 0.0017659761, 0.0017696725, 0.0017733566, 0.0017770281, 0.0017806871, 0.0017843245, 0.0017879679, 0.0017915802, 0.0017951832, 0.0017987737, 0.0018031874, 0.0018064664, 0.0018097326, 0.0018129741, 0.0018162031, 0.0018194071, 0.0018226049, 0.0018258026, 0.0018289692, 0.0018321297, 0.0018352526, 0.0018383694, 0.0018414676, 0.0018445533, 0.0018476262, 0.0018506807, 0.0018537166, 0.0018567458, 0.0018597628, 0.0018627425, 0.001865722, 0.0018686769, 0.001871619, 0.0018745424, 0.0018774472, 0.0018803522, 0.001883232, 0.001886087, 0.0018889294, 0.0018917781, 0.0018945832, 0.0018973822, 0.0019001685, 0.0019029361, 0.001905679, 0.0019084092, 0.0019111333, 0.0019138386, 0.001916519, 0.001919187, 0.0019218549, 0.0019244917, 0.001927116, 0.0019297155, 0.0019323148, 0.0019348769, 0.0019374389, 0.0019399821, 0.0019425127, 0.0019450125, 0.0019475122, 0.0019500055, 0.0019524553, 0.001954905, 0.0019573423, 0.0019597546, 0.0019621484, 0.0019645295, 0.0019668983, 0.001969242, 0.0019715799, 0.0019738986, 0.0019762113, 0.0019784865, 0.0019807681, 0.0019830244, 0.0019852624, 0.0019874752, 0.001989688, 0.0019918759, 0.0019940452, 0.0019961959, 0.0019983526, 0.0020004783, 0.0020025978, 0.0020046921, 0.0020067678, 0.0020088311, 0.0020108633, 0.0020129017, 0.0020149213, 0.0020169222, 0.0020188983, 0.002020868, 0.0020228191, 0.0020247516, 0.0020266715, 0.0020285852, 0.0020304739, 0.0020323377, 0.0020341892, 0.0020360341, 0.0020378421, 0.0020396498, 0.0020414386, 0.0020432153, 0.0020449732, 0.0020467185, 0.0020484389, 0.0020501595, 0.0020513074, 0.002052722, 0.0020541241, 0.002055526, 0.0020569216, 0.0020583046, 0.0020596809, 0.0020610576, 0.0020624339, 0.0020637847, 0.0020651359, 0.0020664681, 0.0020678062, 0.0020691443, 0.0020704695, 0.0020717764, 0.0020730828, 0.0020743827, 0.0020756701, 0.0020769511, 0.0020782258, 0.0020795064, 0.0020807683, 0.0020820175, 0.0020832664, 0.0020845092, 0.002085733, 0.0020869628, 0.00208818, 0.0020894036, 0.0020905954, 0.0020917936, 0.0020929852, 0.0020941582, 0.002095331, 0.002096503, 0.0020976632, 0.0020988104, 0.0020999513, 0.0021010984, 0.0021022328, 0.0021033545, 0.0021044635, 0.0021055725, 0.0021066689, 0.002107759, 0.0021088424, 0.002109932, 0.0021110028, 0.002112061, 0.0021131192, 0.0021141705, 0.0021152033, 0.0021162422, 0.0021172683, 0.0021183009, 0.0021193081, 0.0021203086, 0.0021213095, 0.0021222974, 0.002123273, 0.0021242481, 0.0021252169, 0.0021261857, 0.0021271417, 0.0021280851, 0.0021290223, 0.0021299531, 0.0021308775, 0.002131789, 0.0021327005, 0.0021336118, 0.0021345043, 0.0021353904, 0.0021362638, 0.0021371371, 0.0021380042, 0.0021388647, 0.0021397064, 0.0021405604, 0.0021413956, 0.0021422245, 0.0021430405, 0.0021438566, 0.0021446599, 0.0021454568, 0.0021462599, 0.0021470443, 0.0021478219, 0.002148587, 0.0021493458, 0.0021501046, 0.0021508506, 0.002151584, 0.0021523295, 0.0021530567, 0.0021537708, 0.0021544788, 0.0021551864, 0.0021558814, 0.0021569626, 0.002157483, 0.0021580278, 0.0021585727, 0.0021591238, 0.0021596993, 0.0021602686, 0.0021608628, 0.0021614567, 0.0021620754, 0.0021626877, 0.0021633124, 0.0021639555, 0.0021645986, 0.0021652663, 0.0021659341, 0.0021666137, 0.0021672936, 0.0021679918, 0.0021687024, 0.0021694256, 0.0021701606, 0.002170902, 0.0021716559, 0.0021724028, 0.0021731751, 0.0021739595, 0.0021747497, 0.0021755525, 0.002176374, 0.0021771826, 0.0021780161, 0.0021788618, 0.0021797137, 0.0021805777, 0.002181448, 0.0021823305, 0.0021832129, 0.0021841263, 0.0021850395, 0.002185965, 0.0021868967, 0.0021878406, 0.0021887971, 0.0021897531, 0.0021907275, 0.0021917208, 0.0021927136, 0.0021937189, 0.0021947369, 0.0021957606, 0.0021967844, 0.0021978326, 0.0021988868, 0.0021999599, 0.0022010389, 0.0022021241, 0.0022032091, 0.0022043188, 0.0022054345, 0.0022065628, 0.0022077032, 0.0022088559, 0.002210015, 0.0022111738, 0.0022123507, 0.0022135405, 0.0022147361, 0.0022159503, 0.0022171703, 0.0022184029, 0.0022196292, 0.00222088, 0.0022221433, 0.0022234125, 0.0022246942, 0.0022259818, 0.0022272696, 0.0022285881, 0.0022299066, 0.0022312435, 0.0022325802, 0.0022339358, 0.0022352971, 0.0022366582, 0.002238038, 0.0022394366, 0.002240841, 0.0022422518, 0.0022436744, 0.0022451095, 0.0022465382, 0.0022479917, 0.0022494576, 0.0022509356, 0.0022524202, 0.0022539166, 0.002255419, 0.0022569215, 0.0022584423, 0.0022602913, 0.0022618247, 0.0022634454, 0.0022650536, 0.0022666866, 0.0022683574, 0.0022700466, 0.0022717859, 0.0022735437, 0.0022753512, 0.002277215, 0.0022790602, 0.0022809363, 0.0022828563, 0.0022848202, 0.0022868023, 0.0022888219, 0.0022908729, 0.0022929546, 0.002295068, 0.0022972121, 0.002299394, 0.0023016131, 0.0023038259, 0.0023061014, 0.0023083889, 0.0023107515, 0.0023131203, 0.0023155138, 0.0023179387, 0.0023204011, 0.0023228757, 0.0023254065, 0.0023279495, 0.0023305491, 0.0023331859, 0.0023358229, 0.002338503, 0.0023412146, 0.0023439389, 0.0023467189, 0.0023495301, 0.0023523727, 0.002355265, 0.002358176, 0.0023610746, 0.0023640415, 0.0023670401, 0.0023700634, 0.0023731177, 0.0023762283, 0.0023793576, 0.0023825055, 0.0023856908, 0.0023889013, 0.0023921488, 0.0023954278, 0.0023987377, 0.0024020723, 0.00240547, 0.0024088733, 0.002412308, 0.0024157737, 0.0024192706, 0.0024228115, 0.0024263521, 0.0024299549, 0.0024336081, 0.0024372481, 0.0024409508, 0.0024446722, 0.0024484186, 0.0024521837, 0.0024560047, 0.0024598448, 0.0024637345, 0.0024676677, 0.0024716009, 0.0024755655, 0.0024795739, 0.0024835942, 0.0024876711, 0.0024917603, 0.0024959054, 0.0025000819, 0.0025042586, 0.0025084848, 0.0025127423, 0.0025170248, 0.0025213445, 0.0025257017, 0.0025300777, 0.0025345159, 0.0025389604, 0.0025434298, 0.0025479367, 0.0025524872, 0.00255705, 0.0025616568, 0.0025662882, 0.0025692875, 0.0025739877, 0.0025787251, 0.0025835, 0.0025884369, 0.0025933115, 0.0025982859, 0.0026033346, 0.0026084213, 0.0026135577, 0.002618744, 0.0026239925, 0.0026293036, 0.0026346273, 0.0026400627, 0.0026454984, 0.0026510211, 0.002656569, 0.0026622165, 0.0026678767, 0.0026735866, 0.0026793589, 0.0026852184, 0.0026910652, 0.0026969996, 0.0027030585, 0.0027090926, 0.0027151639, 0.0027212978, 0.0027275311, 0.0027338022, 0.0027400854, 0.0027464936, 0.0027529141, 0.0027593719, 0.0027658921, 0.0027725247, 0.0027791194, 0.0027858021, 0.0027925717, 0.0027993538, 0.0028061732, 0.0028131171, 0.0028200864, 0.0028270928, 0.0028341117, 0.0028412801, 0.0028484238, 0.0028556422, 0.0028628854, 0.002870291, 0.002877634, 0.0028850769, 0.0028925946, 0.0029001245, 0.002907692, 0.0029153465, 0.0029230639, 0.0029308184, 0.0029386349, 0.0029465265, 0.0029544309, 0.0029623969, 0.0029704382, 0.0029785167, 0.0029866456, 0.002994824, 0.0030031144, 0.0030113801, 0.0030197203, 0.0030281232, 0.0030366008, 0.0030450658, 0.0030536307, 0.0030622578, 0.0030709472, 0.0030796491, 0.0030884636, 0.0030972653, 0.0031061538, 0.0031150556, 0.0031240941, 0.0031331079, 0.0031422211, 0.0031513469, 0.0031605975, 0.003169823, 0.003179136, 0.0031885237, 0.0031979361, 0.0032073865, 0.0032169358, 0.0032265231, 0.0032361601, 0.0032458219, 0.0032555962, 0.0032653701, 0.003275207, 0.0032850807, 0.0032950914, 0.0033054582, 0.0033153573, 0.0033254307, 0.0033354789, 0.0033456523, 0.0033559247, 0.0033662727, 0.0033766702, 0.0033871671, 0.0033977893, 0.003408436, 0.003419108, 0.0034299542, 0.0034408255, 0.0034518214, 0.0034628671, 0.0034739873, 0.0034852079, 0.0034964285, 0.0035078481, 0.0035192929, 0.0035308376, 0.0035423818, 0.0035540508, 0.0035658197, 0.0035776882, 0.0035895819, 0.0036015504, 0.0036136184, 0.0036257613, 0.003637929, 0.0036503463, 0.0036626637, 0.0036751307, 0.0036876725, 0.0037003141, 0.0037129805, 0.0037257469, 0.0037386627, 0.0037515287, 0.003764594, 0.0037776844, 0.0037908496, 0.0038040148, 0.0038174042, 0.0038307942, 0.0038442833, 0.0038578475, 0.0038715114, 0.0038852503, 0.0038990139, 0.0039128521, 0.0039268401, 0.0039408528, 0.0039549656, 0.0039691781, 0.0039833905, 0.0039977278, 0.0040121642, 0.0040267007, 0.0040412624, 0.0040558986, 0.0040707346, 0.0040854956, 0.0041003809, 0.0041153664, 0.0041304515, 0.0041455119, 0.0041607711, 0.0041760812, 0.0041914154, 0.0042068246, 0.0042224331, 0.0042380672, 0.0042537255, 0.004269484, 0.0042853416, 0.004301175, 0.0043171579, 0.0043332903, 0.0043494222, 0.0043656295, 0.0043819863, 0.0043983678, 0.0044148243, 0.0044313557, 0.0044479617, 0.0044647423, 0.0044814479, 0.0044983537, 0.0045153336, 0.0045322888, 0.0045493688, 0.0045665232, 0.0045838524, 0.0046011815, 0.0046185353, 0.0046360395, 0.0046535684, 0.0046712463, 0.0046896073, 0.0047075097, 0.0047255121, 0.0047436142, 0.0047617666, 0.0047799186, 0.0047984198, 0.0048169205, 0.0048355716, 0.0048542223, 0.0048730723, 0.004891973, 0.0049110223, 0.004930221, 0.0049493709, 0.00496872, 0.0049880687, 0.0050078165, 0.0050273645, 0.0050470624, 0.0050669606, 0.0050870068, 0.0051071043, 0.0051273005, 0.0051474972, 0.0051678936, 0.0051884889, 0.0052090348, 0.00522978, 0.0052505746, 0.0052714697, 0.0052925642, 0.0053137075, 0.0053349021, 0.0053562955, 0.0053777387, 0.0053992318, 0.0054210243, 0.0054427171, 0.0054646591, 0.0054865507, 0.0055086929, 0.0055309837, 0.0055532749, 0.0055756657, 0.0055981567, 0.0056206966, 0.0056434865, 0.0056663761, 0.0056892158, 0.0057123052, 0.0057354439, 0.0057586818, 0.0057821199, 0.0058055082, 0.0058290963, 0.0058527836, 0.0058765705, 0.0059005073, 0.0059244442, 0.0059485803, 0.0059727165, 0.0059970273, 0.0060215378, 0.0060461229, 0.0060706828, 0.0060953428, 0.0061202017, 0.0061451611, 0.0061702449, 0.0061954032, 0.0062206364, 0.0062459693, 0.0062715514, 0.0062971348, 0.0063227415, 0.0063485731, 0.0063744299, 0.006400561, 0.0064266175, 0.0064528231, 0.0064791031, 0.0065055089, 0.0065320637, 0.0065587428, 0.0065854727, 0.0066123013, 0.0066392054, 0.0066662836, 0.0066935616, 0.0067207897, 0.006748118, 0.0067756698, 0.006803222, 0.0068309237, 0.0068587749, 0.0068866517, 0.006914652, 0.0069427285, 0.0069711031, 0.0070008356, 0.0070298091, 0.0070588817, 0.0070882048, 0.0071175769, 0.0071469988, 0.0071765711, 0.0072062924, 0.0072362134, 0.0072661838, 0.0072962041, 0.0073264246, 0.0073566944, 0.007387164, 0.0074177827, 0.0074483524, 0.0074792206, 0.0075101391, 0.0075411568, 0.0075723743, 0.0076037408, 0.0076351087, 0.0076666246, 0.0076982914, 0.0077301566, 0.0077619725, 0.0077940375, 0.0078261523, 0.007858417, 0.007890882, 0.0079233954, 0.0079560094, 0.0079886233, 0.0080215363, 0.0080545992, 0.0080877114, 0.0081209727, 0.0081542851, 0.0081877969, 0.0082215071, 0.0082551679, 0.0082890289, 0.0083229886, 0.008357049, 0.0083913086, 0.0084257172, 0.0084601762, 0.0084946845, 0.008529393, 0.0085642012, 0.0085991584, 0.0086342162, 0.0086694229, 0.0087046791, 0.0087400861, 0.0087757409, 0.0088113975, 0.0088472022, 0.0088831075, 0.0089191617, 0.0089554163, 0.0089916708, 0.0090280743, 0.0090645775, 0.0091012307, 0.0091379341, 0.0091749355, 0.009211937, 0.0092490902, 0.0092861922, 0.0093235429, 0.0093611926, 0.0093987444, 0.0094364937, 0.0094743446, 0.0095122932, 0.0095505426, 0.0095887417, 0.0096271392, 0.0096655386, 0.0097041363, 0.009742884, 0.0097816819, 0.0098206792, 0.0098597258, 0.0098990211, 0.0099383174, 0.0099777626, 0.010017357, 0.010057004, 0.010096947, 0.010136843, 0.010176786, 0.010216979, 0.010257273, 0.010297767, 0.010338308, 0.010378951, 0.010419695, 0.010460586, 0.0105041, 0.010546088, 0.010588127, 0.010630365, 0.010672653, 0.010715092, 0.010757628, 0.010800267, 0.010843002, 0.010885939, 0.010928926, 0.010971962, 0.011015097, 0.011058432, 0.011101818, 0.011145303, 0.011188937, 0.011232722, 0.011276555, 0.011320588, 0.011364671, 0.011408905, 0.011453139, 0.01149757, 0.011542053, 0.011586734, 0.011631515, 0.011676298, 0.011721279, 0.011766209, 0.011811391, 0.011856669, 0.011902049, 0.011947629, 0.011993309, 0.012038988, 0.012084866, 0.012130794, 0.012176872, 0.012223001, 0.012269278, 0.012315704, 0.012362082, 0.012408759, 0.012455535, 0.01250236, 0.012549288, 0.012596212, 0.012643437, 0.012690712, 0.012738038, 0.012785512, 0.012833185, 0.012880859, 0.012928683, 0.012976656, 0.013024729, 0.013072851, 0.013121122, 0.013169545, 0.013217967, 0.013266589, 0.013315259, 0.013364079, 0.013413001, 0.013462071, 0.01351119, 0.01356046, 0.013609829, 0.01365935, 0.013708917, 0.013758536, 0.013808355, 0.013858222, 0.01390829, 0.013958407, 0.014008624, 0.014058941, 0.014109458, 0.014160024, 0.014210739, 0.014261505, 0.014312521, 0.014363485, 0.014414599, 0.014465814, 0.014517179, 0.014568642, 0.014620205, 0.014671869, 0.014723582, 0.014775544, 0.014827557, 0.014879669, 0.01493193, 0.014984243, 0.015036654, 0.015089214, 0.015141926, 0.015194685, 0.015240214, 0.015293873, 0.01534758, 0.015401438, 0.015455295, 0.015509228, 0.015563235, 0.015617317, 0.015671423, 0.015725655, 0.015779886, 0.015834242, 0.0158886, 0.015943104, 0.01599771, 0.016052365, 0.016107021, 0.016161775, 0.016216556, 0.016271461, 0.01632639, 0.016381444, 0.016436499, 0.016491653, 0.016546857, 0.01660211, 0.016657563, 0.016712917, 0.01676842, 0.016824024, 0.016879676, 0.016935302, 0.016991081, 0.017046958, 0.017102836, 0.017158788, 0.017214814, 0.01727099, 0.017327167, 0.017383369, 0.017439693, 0.017496046, 0.017552495, 0.017608946, 0.017665546, 0.017722195, 0.01777892, 0.017835671, 0.017892594, 0.017949494, 0.018006494, 0.018063543, 0.018120691, 0.018177891, 0.018235113, 0.018292436, 0.018349834, 0.018407281, 0.018464856, 0.018522404, 0.018580075, 0.018637847, 0.018695643, 0.018753517, 0.018811412, 0.018869461, 0.018927557, 0.018985651, 0.019043898, 0.019102143, 0.019160515, 0.01921886, 0.019277405, 0.019335974, 0.019394571, 0.019453263, 0.019512009, 0.019570801, 0.019629721, 0.019688617, 0.019747684, 0.019806754, 0.019865923, 0.01992514, 0.019984482, 0.02004385, 0.020103268, 0.020162787, 0.020222329, 0.020281922, 0.020341614, 0.020401405, 0.020461246, 0.020521162, 0.02058113, 0.02064117, 0.020701261, 0.020761477, 0.020821691, 0.020882033, 0.020941501, 0.021001957, 0.021062417, 0.021122927, 0.021183392, 0.021243906, 0.021304401, 0.021364899, 0.02142545, 0.021485992, 0.021546535, 0.021607105, 0.021667652, 0.021728234, 0.021788834, 0.021849468, 0.021910051, 0.021970665, 0.022031324, 0.022091946, 0.022152614, 0.022213262, 0.022273913, 0.022334613, 0.022395292, 0.022456, 0.022516685, 0.022577405, 0.022638138, 0.022698889, 0.022759659, 0.022820387, 0.02288116, 0.022941969, 0.023002775, 0.023063563, 0.023124397, 0.023185221, 0.023246035, 0.023306888, 0.023367727, 0.023428591, 0.02348946, 0.023550356, 0.023611257, 0.02367215, 0.023733037, 0.02379399, 0.023854924, 0.023915853, 0.023976829, 0.02403779, 0.024098787, 0.024159761, 0.024220739, 0.024281759, 0.024342747, 0.024403775, 0.02446482, 0.024525849, 0.024586927, 0.024647985, 0.024709065, 0.024770137, 0.024831239, 0.024892343, 0.024953455, 0.025014615, 0.02507573, 0.025136892, 0.025198046, 0.025259206, 0.025320387, 0.025381589, 0.025442768, 0.025503971, 0.02556519, 0.025626423, 0.025687641, 0.025748909, 0.025810162, 0.025871426, 0.025932686, 0.02599401, 0.026055321, 0.02611663, 0.026177919, 0.026239252, 0.026300576, 0.026361944, 0.026423303, 0.026484691, 0.026546057, 0.026607459, 0.026668843, 0.026730228, 0.026791675, 0.026853111, 0.026914539, 0.026975978, 0.027040659, 0.027101396, 0.027162097, 0.027222775, 0.0272834, 0.027344003, 0.027404554, 0.027465077, 0.027525574, 0.027586039, 0.027646462, 0.027706852, 0.027767206, 0.027827533, 0.027887799, 0.027948057, 0.028008275, 0.028068442, 0.028128594, 0.028188692, 0.028248744, 0.028308777, 0.028368777, 0.028428752, 0.028488679, 0.02854857, 0.02860843, 0.028668249, 0.02872804, 0.028787795, 0.028847517, 0.028907197, 0.02896685, 0.029026469, 0.029086035, 0.029145556, 0.029205058, 0.029264523, 0.02932396, 0.029383371, 0.029442726, 0.029502057, 0.029561365, 0.029620619, 0.029679839, 0.02973903, 0.029798178, 0.029857296, 0.02991638, 0.029975433, 0.030034406, 0.030093392, 0.030152332, 0.030211242, 0.030270109, 0.030328946, 0.030387748, 0.030446498, 0.030505236, 0.030563926, 0.030622583, 0.030681215, 0.030739805, 0.030798338, 0.030856842, 0.030915329, 0.030973772, 0.031032177, 0.031090556, 0.031148897, 0.031207204, 0.031265479, 0.031323709, 0.031381898, 0.031440068, 0.031498205, 0.03155629, 0.031614348, 0.031672377, 0.031730339, 0.031788282, 0.031846203, 0.031904083, 0.031961929, 0.032019727, 0.032077514, 0.032135248, 0.032192953, 0.032250632, 0.032308232, 0.032365832, 0.032423403, 0.032480929, 0.03253841, 0.032595873, 0.032653291, 0.032710675, 0.03276803, 0.032825354, 0.032882627, 0.032937706, 0.032993931, 0.033050109, 0.033106223, 0.033162326, 0.033218339, 0.033274326, 0.033330269, 0.033386156, 0.033441998, 0.033497788, 0.033553552, 0.033609241, 0.033664893, 0.033720482, 0.033776049, 0.033831567, 0.033887021, 0.033942435, 0.033997815, 0.034053132, 0.034108408, 0.034163613, 0.034218803, 0.034273922, 0.034329001, 0.034384042, 0.034439009, 0.034493968, 0.03454883, 0.034603689, 0.03465848, 0.034713224, 0.034767926, 0.034822572, 0.034877177, 0.034931719, 0.03498625, 0.035040691, 0.035095099, 0.035149481, 0.0352038, 0.03525807, 0.035312288, 0.035366472, 0.035420589, 0.035474658, 0.03552869, 0.035582684, 0.03563663, 0.035690498, 0.035744332, 0.035798129, 0.035851885, 0.035905581, 0.035959225, 0.036012825, 0.036066394, 0.036119889, 0.036173347, 0.036226757, 0.036280129, 0.036333438, 0.03638671, 0.036439929, 0.036493089, 0.036546223, 0.036599293, 0.036652304, 0.036705304, 0.036758229, 0.036811125, 0.036863942, 0.036916755, 0.036969494, 0.037022173, 0.03707483, 0.037127439, 0.037179999, 0.0372325, 0.037284944, 0.037337355, 0.03738974, 0.03744204, 0.037494291, 0.037546519, 0.037598703, 0.037650831, 0.037702892, 0.037754927, 0.037806902, 0.03785884, 0.03791073, 0.037962545, 0.038014356, 0.038066104, 0.038117778, 0.038169418, 0.038221035, 0.038272597, 0.038328595, 0.038379289, 0.038429968, 0.038480613, 0.038531225, 0.0385818, 0.038632385, 0.03868293, 0.038733449, 0.038783945, 0.038834404, 0.038884856, 0.03893527, 0.03898567, 0.039036036, 0.039086375, 0.039136708, 0.039186999, 0.039237265, 0.039287519, 0.039337736, 0.03938793, 0.039438087, 0.039488245, 0.039538361, 0.039588451, 0.039638534, 0.03968858, 0.039738607, 0.039788585, 0.03983856, 0.039888494, 0.039938439, 0.039988343, 0.040038202, 0.040088039, 0.040137868, 0.040187672, 0.040237434, 0.040287185, 0.040336907, 0.040386599, 0.040436268, 0.040485915, 0.040535543, 0.040585138, 0.040634692, 0.040684249, 0.040733773, 0.040783271, 0.040832743, 0.040882185, 0.040931627, 0.040981013, 0.041030385, 0.041079734, 0.041129075, 0.041178357, 0.041227635, 0.041276883, 0.041326094, 0.041375317, 0.041424479, 0.041473623, 0.041522756, 0.041571867, 0.04162094, 0.041669972, 0.041719008, 0.041768003, 0.041816976, 0.041865941, 0.04191485, 0.041963771, 0.042012628, 0.042061482, 0.042110313, 0.042159121, 0.042207886, 0.042256635, 0.042305361, 0.042354058, 0.042402741, 0.042451397, 0.042500004, 0.042548619, 0.04259719, 0.042645745, 0.042694271, 0.042742778, 0.042791259, 0.042839702, 0.042888138, 0.042936519, 0.042984918, 0.043033261, 0.043081589, 0.043129902, 0.043178175, 0.043226436, 0.043268897, 0.043316778, 0.043364715, 0.043412667, 0.043460645, 0.043508638, 0.043556638, 0.043604705, 0.043652743, 0.043700822, 0.043748923, 0.043797038, 0.043845158, 0.043893345, 0.043941516, 0.043989692, 0.044037912, 0.044086158, 0.044134416, 0.044182688, 0.044231009, 0.044279318, 0.044327643, 0.044376027, 0.044424392, 0.044472784, 0.044521213, 0.044569645, 0.044618096, 0.044666585, 0.044715095, 0.044763613, 0.04481215, 0.044860721, 0.044909295, 0.044957902, 0.045006555, 0.045055181, 0.045103829, 0.04515253, 0.045201227, 0.045249946, 0.045298696, 0.045347482, 0.045396257, 0.045445055, 0.045493897, 0.045542732, 0.045591589, 0.045640502, 0.045689397, 0.045738332, 0.04578729, 0.045836259, 0.045885231, 0.045934264, 0.045983292, 0.046032336, 0.046081394, 0.046130497, 0.046179604, 0.046228729, 0.046277907, 0.046327069, 0.046376251, 0.046425484, 0.046474718, 0.046523955, 0.046573255, 0.046622537, 0.046671849, 0.046721168, 0.046770539, 0.046819918, 0.046869297, 0.046918735, 0.046968162, 0.047017615, 0.047067106, 0.0471166, 0.047166098, 0.047215659, 0.047265209, 0.047314774, 0.047364403, 0.047414016, 0.047463652, 0.047513295, 0.047562994, 0.047612682, 0.047662396, 0.047712162, 0.047761906, 0.047811694, 0.047861505, 0.047911327, 0.047961157, 0.048011042, 0.048060924, 0.048110817, 0.048159324, 0.048209418, 0.048259504, 0.048309635, 0.048359931, 0.048410248, 0.048460625, 0.048511107, 0.048561659, 0.048612278, 0.048662931, 0.048713669, 0.048764508, 0.048815399, 0.048866376, 0.048917435, 0.048968531, 0.04901975, 0.049070951, 0.049122281, 0.049173705, 0.049225155, 0.049276695, 0.049328323, 0.049380008, 0.0494317, 0.049483549, 0.04953545, 0.049587421, 0.049639475, 0.04969161, 0.049743786, 0.049796, 0.049848333, 0.049900744, 0.049953181, 0.05000576, 0.05005838, 0.050111063, 0.050163772, 0.050216611, 0.050269496, 0.050322454, 0.050375544, 0.050428614, 0.050481822, 0.05053509, 0.050588366, 0.05064176, 0.050695229, 0.050748803, 0.050802387, 0.05085611, 0.050909866, 0.050963648, 0.051017534, 0.051071502, 0.051125556, 0.051179662, 0.051233862, 0.051288106, 0.051342409, 0.051396791, 0.05145127, 0.051505804, 0.051560447, 0.051615126, 0.051669884, 0.051724739, 0.051779568, 0.051834524, 0.051889572, 0.051944699, 0.0519999, 0.052055135, 0.052110486, 0.052165825, 0.052221287, 0.052276868, 0.052332457, 0.052388161, 0.052443922, 0.052499738, 0.052555606, 0.052611545, 0.052667622, 0.052723721, 0.052779887, 0.052836172, 0.052892487, 0.052948877, 0.05300533, 0.053061865, 0.053118456, 0.053175181, 0.05323191, 0.053288765, 0.053345632, 0.053402577, 0.053459629, 0.053519264, 0.053576734, 0.053634305, 0.05369208, 0.0537499, 0.053807873, 0.053865869, 0.053924091, 0.053982385, 0.054040786, 0.054099351, 0.054157972, 0.054216769, 0.05427561, 0.054334581, 0.054393701, 0.054452941, 0.054512314, 0.054571755, 0.054631345, 0.054691013, 0.054750782, 0.054810744, 0.054870784, 0.054930951, 0.054991245, 0.055051632, 0.05511215, 0.055172741, 0.055233479, 0.055294342, 0.055355359, 0.05541642, 0.05547763, 0.055538993, 0.05560036, 0.055661943, 0.055723634, 0.055785421, 0.055847328, 0.055909369, 0.0559715, 0.056033712, 0.056096122, 0.056158587, 0.056221195, 0.056283955, 0.056346811, 0.056409743, 0.056472778, 0.056535985, 0.056599267, 0.056662723, 0.056726255, 0.056789935, 0.056853693, 0.056917578, 0.056981534, 0.057045687, 0.057109941, 0.057174299, 0.057238728, 0.05730335, 0.057368059, 0.057432838, 0.057497792, 0.057562847, 0.057628021, 0.057693325, 0.057758722, 0.057824228, 0.057889905, 0.057955608, 0.058021482, 0.058087457, 0.058153581, 0.058219779, 0.058286157, 0.058352608, 0.058419105, 0.058485825, 0.058552623, 0.058619548, 0.058686599, 0.058753744, 0.058821015, 0.058888361, 0.058955859, 0.059023481, 0.059091225, 0.059159093, 0.059227068, 0.059295136, 0.059363361, 0.059431627, 0.059500042, 0.05956864, 0.059637278, 0.059706077, 0.059774995, 0.059852395, 0.059922058, 0.059991851, 0.060061764, 0.060131777, 0.060202017, 0.060272329, 0.060342867, 0.060413536, 0.06048432, 0.060555257, 0.060626395, 0.060697604, 0.060768992, 0.060840555, 0.060912214, 0.060984023, 0.061056059, 0.061128143, 0.061200447, 0.061272833, 0.061345387, 0.061418075, 0.061491031, 0.061563987, 0.061637148, 0.061710451, 0.06178388, 0.061857514, 0.061931212, 0.06200517, 0.062079173, 0.062153406, 0.062227756, 0.062302157, 0.062376786, 0.062451586, 0.062526569, 0.062601589, 0.062676862, 0.062752195, 0.062827721, 0.062903389, 0.062979221, 0.063055113, 0.063131213, 0.063207462, 0.063283861, 0.063360386, 0.063437127, 0.063513927, 0.063590944, 0.063668095, 0.063745394, 0.063822806, 0.063900359, 0.063978076, 0.064055942, 0.064134017, 0.064212173, 0.064290494, 0.064368963, 0.064447582, 0.064526297, 0.064605214, 0.064684257, 0.064763449, 0.064842813, 0.064922325, 0.065001912, 0.065081753, 0.06516169, 0.06524168, 0.065321989, 0.065402329, 0.06548284, 0.065563552, 0.065644361, 0.065725319, 0.065806434, 0.065887697, 0.065969057, 0.066050686, 0.066132292, 0.066214204, 0.066296235, 0.066378295, 0.066460684, 0.066543162, 0.06662567, 0.066708446, 0.066791326, 0.066874363, 0.066957541, 0.067040868, 0.0671243, 0.067207925, 0.067291729, 0.067375608, 0.067459658, 0.067546368, 0.067631289, 0.06771642, 0.067801796, 0.067887217, 0.067972839, 0.068058714, 0.068144538, 0.068230703, 0.068316974, 0.068403304, 0.068489872, 0.068576641, 0.068663463, 0.068750478, 0.068837747, 0.068925016, 0.06901259, 0.069100209, 0.069187976, 0.069275938, 0.069364108, 0.069452427, 0.069540791, 0.069629356, 0.069718175, 0.069807038, 0.06989605, 0.069985367, 0.070074677, 0.070164248, 0.070253909, 0.070343718, 0.070433781, 0.070523947, 0.070614152, 0.070704713, 0.070795327, 0.070886038, 0.070976995, 0.071068101, 0.071159407, 0.071250767, 0.071342327, 0.071434081, 0.071525894, 0.071617946, 0.071710102, 0.071802504, 0.071894966, 0.071987666, 0.072080426, 0.072173379, 0.072266579, 0.072359838, 0.072453238, 0.07254684, 0.07264059, 0.072734497, 0.072828598, 0.072922796, 0.073017098, 0.073111698, 0.073206395, 0.073301248, 0.073396191, 0.073491395, 0.073586687, 0.073682137, 0.073777743, 0.073873535, 0.073969483, 0.074065633, 0.07416182, 0.074258216, 0.07435482, 0.074451551, 0.074548349, 0.074645393, 0.07474263, 0.074839979, 0.07493747, 0.075035155, 0.075132951, 0.075230889, 0.075328991, 0.075427227, 0.075525716, 0.075624354, 0.075723045, 0.075821981, 0.075921014, 0.076020263, 0.076119639, 0.076219179, 0.076318868, 0.076418653, 0.076518737, 0.076618873, 0.076719157, 0.076812096, 0.07691355, 0.077015154, 0.07711681, 0.077218719, 0.07732065, 0.077422805, 0.077525012, 0.077627391, 0.077729896, 0.077832595, 0.077935331, 0.078038298, 0.078141339, 0.07824453, 0.078347884, 0.078451455, 0.078555018, 0.078658737, 0.078762636, 0.078866638, 0.07897076, 0.079075083, 0.07917951, 0.079284035, 0.079388782, 0.079493582, 0.079598531, 0.079703704, 0.079808973, 0.079914294, 0.080019787, 0.080125444, 0.080231234, 0.080337204, 0.080443241, 0.080549419, 0.080655709, 0.080762252, 0.080868796, 0.080975592, 0.081082433, 0.081189483, 0.081296563, 0.081403859, 0.081511274, 0.081618793, 0.081726529, 0.081834346, 0.081942238, 0.082050331, 0.082158595, 0.082266986, 0.082375489, 0.082484126, 0.082592912, 0.082701825, 0.082810842, 0.082920045, 0.083029345, 0.083138801, 0.083248407, 0.083358094, 0.083467931, 0.083577991, 0.083688177, 0.083798409, 0.083908789, 0.084019348, 0.084130049, 0.084240831, 0.084351763, 0.084462851, 0.084574081, 0.084685393, 0.084796838, 0.084908471, 0.085020401, 0.085132256, 0.085244238, 0.085356392, 0.085468769, 0.085581169, 0.085693769, 0.085806444, 0.085919246, 0.086032301, 0.086145401, 0.086258627, 0.086372055, 0.08648555, 0.086599253, 0.086713053, 0.08682695, 0.086941049, 0.087055273, 0.087169617, 0.087284088, 0.087398715, 0.087513439, 0.087633647, 0.087749287, 0.087865032, 0.087980926, 0.088096827, 0.088212863, 0.08832895, 0.088445105, 0.088561341, 0.088677675, 0.088794179, 0.088910669, 0.089027256, 0.089143947, 0.08926069, 0.089377582, 0.089494526, 0.08961156, 0.089728683, 0.089845844, 0.089963131, 0.09008047, 0.090197936, 0.090315484, 0.090433091, 0.09055081, 0.090668559, 0.090786502, 0.090904444, 0.091022506, 0.091140635, 0.091258831, 0.091377147, 0.091495499, 0.091613963, 0.091732532, 0.091851138, 0.0919699, 0.092088692, 0.092207626, 0.092326604, 0.092445634, 0.092564851, 0.092684068, 0.092803374, 0.092922755, 0.093042217, 0.093161792, 0.093281448, 0.093401209, 0.093521051, 0.093641013, 0.09376099, 0.093881071, 0.094001248, 0.094121486, 0.094241813, 0.094362244, 0.094482735, 0.094603337, 0.094724014, 0.094844773, 0.094965599, 0.095086582, 0.095207609, 0.095328689, 0.095449872, 0.095571175, 0.09569253, 0.09581396, 0.095935494, 0.096057095, 0.096178748, 0.09630055, 0.096422404, 0.09654437, 0.096666403, 0.096788555, 0.09691076, 0.097033031, 0.097155429, 0.097277895, 0.097400442, 0.097523063, 0.097645789, 0.097768582, 0.097891465, 0.098014414, 0.098137513, 0.098260693, 0.098383889, 0.098507181, 0.098630585, 0.098754086, 0.098877661, 0.099001303, 0.099125035, 0.099248849, 0.099372752, 0.099496722, 0.099623993, 0.099747874, 0.09987174, 0.099995591, 0.10011952, 0.10024343, 0.1003674, 0.10049141, 0.10061542, 0.10073944, 0.1008635, 0.10098759, 0.10111172, 0.10123588, 0.10136003, 0.10148421, 0.10160844, 0.10173267, 0.10185693, 0.10198126, 0.10210556, 0.10222992, 0.10235427, 0.10247865, 0.10260308, 0.10272751, 0.10285201, 0.1029765, 0.10310102, 0.10322556, 0.10335015, 0.10347473, 0.10359938, 0.10372403, 0.1038487, 0.10397338, 0.10409813, 0.10422288, 0.10434766, 0.10447247, 0.10459727, 0.10472214, 0.10484701, 0.10497192, 0.10509685, 0.10522182, 0.10534679, 0.1054718, 0.10559683, 0.10572188, 0.10584697, 0.10597209, 0.10609717, 0.10622235, 0.10634752, 0.10647272, 0.10659797, 0.1067232, 0.1068485, 0.10697381, 0.10709917, 0.10722452, 0.10734992, 0.10747534, 0.10760079, 0.10772624, 0.10785175, 0.10797723, 0.10810278, 0.10822833, 0.10835394, 0.10847956, 0.10860521, 0.10873087, 0.10885657, 0.1089823, 0.10910803, 0.10923378, 0.10935962, 0.10948543, 0.10961128, 0.10973713, 0.10986303, 0.10998895, 0.11011491, 0.11024089, 0.11036689, 0.11049291, 0.11061899, 0.11074504, 0.11087113, 0.11099727, 0.11112344, 0.1112496, 0.11137582, 0.11150203, 0.1116283, 0.11175458, 0.11188088, 0.11200722, 0.11213021, 0.1122556, 0.11238096, 0.11250636, 0.11263173, 0.11275706, 0.11288241, 0.11300775, 0.11313307, 0.1132584, 0.1133837, 0.11350899, 0.11363428, 0.11375954, 0.11388483, 0.11401008, 0.11413532, 0.11426057, 0.1143858, 0.11451103, 0.11463624, 0.11476142, 0.11488663, 0.11501182, 0.11513699, 0.11526214, 0.1153873, 0.11551244, 0.11563757, 0.1157627, 0.11588781, 0.1160129, 0.11613797, 0.11626307, 0.11638815, 0.11651319, 0.11663827, 0.11676331, 0.11688836, 0.11701338, 0.11713839, 0.11726341, 0.11738842, 0.11751339, 0.11763837, 0.11776335, 0.11788832, 0.11801325, 0.1181382, 0.11826313, 0.11838806, 0.11851297, 0.11863787, 0.11876278, 0.11888766, 0.11901253, 0.11913739, 0.11926226, 0.11938711, 0.11951192, 0.11963677, 0.11976158, 0.1198864, 0.1200112, 0.12013597, 0.12026076, 0.12038554, 0.12051029, 0.12063503, 0.12075979, 0.12088453, 0.12100924, 0.12113395, 0.12125865, 0.12138333, 0.12150802, 0.1216327, 0.12175738, 0.12188203, 0.12200667, 0.1221313, 0.12225593, 0.12238056, 0.12250514, 0.12262974, 0.12275434, 0.12287892, 0.12300348, 0.12312805, 0.12325261, 0.12337714, 0.12350167, 0.12362618, 0.12375069, 0.12387522, 0.12399969, 0.12412418, 0.12424865, 0.12437312, 0.12449756, 0.12461936, 0.12474328, 0.12486717, 0.12499105, 0.12511492, 0.12523878, 0.12536262, 0.12548643, 0.12561025, 0.12573406, 0.12585784, 0.1259816, 0.12610534, 0.12622903, 0.12635276, 0.12647647, 0.12660015, 0.12672381, 0.12684749, 0.12697113, 0.12709475, 0.12721835, 0.12734196, 0.12746555, 0.12758911, 0.12771264, 0.12783617, 0.12795971, 0.12808321, 0.1282067, 0.12833019, 0.12845363, 0.12857707, 0.12870051, 0.12882391, 0.1289473, 0.12907068, 0.12919405, 0.12931742, 0.12944075, 0.12956408, 0.12968738, 0.12981068, 0.12993395, 0.1300572, 0.13018045, 0.13030368, 0.13042691, 0.1305501, 0.13067327, 0.13079646, 0.13091962, 0.13104275, 0.13116588, 0.13128898, 0.13141207, 0.13153516, 0.13165823, 0.13178125, 0.13190429, 0.1320273, 0.13215032, 0.13227329, 0.13239628, 0.1325192, 0.13264218, 0.1327651, 0.13288799, 0.13301091, 0.13313378, 0.13325664, 0.13337949, 0.13350232, 0.13362515, 0.13374795, 0.13387075, 0.13399352, 0.13411626, 0.134239, 0.13436173, 0.13448444, 0.13460715, 0.13472982, 0.1348525, 0.13497515, 0.13509777, 0.13522041, 0.13534297, 0.13546558, 0.13558817, 0.13571073, 0.13583326, 0.1359558, 0.1360783, 0.1362008, 0.1363233, 0.13644575, 0.13656822, 0.13669066, 0.13681309, 0.13693324, 0.13705564, 0.137178, 0.13730036, 0.13742271, 0.13754505, 0.13766739, 0.13778973, 0.13791202, 0.13803433, 0.13815661, 0.1382789, 0.13840115, 0.13852341, 0.13864565, 0.13876788, 0.1388901, 0.13901234, 0.13913454, 0.13925673, 0.13937891, 0.13950109, 0.13962327, 0.13974541, 0.13986756, 0.1399897, 0.14011182, 0.14023392, 0.14035605, 0.14047813, 0.1406002, 0.14072229, 0.14084435, 0.1409664, 0.14108846, 0.14121047, 0.14133249, 0.14145452, 0.14157651, 0.14169851, 0.14182049, 0.14194246, 0.14206441, 0.14218636, 0.14230829, 0.14243022, 0.14255214, 0.14267404, 0.14279595, 0.14291783, 0.1430397, 0.14316157, 0.14328343, 0.14340529, 0.14352711, 0.14364892, 0.14377074, 0.14389254, 0.14401433, 0.14413612, 0.14425789, 0.14437968, 0.14450142, 0.14462316, 0.14474487, 0.14486662, 0.14498833, 0.14511003, 0.14523171, 0.14535339, 0.14547506, 0.14559674, 0.14571838, 0.14583999, 0.14596164, 0.14608327, 0.14620487, 0.14632644, 0.14644806, 0.14656964, 0.1466912, 0.14681277, 0.1469343, 0.14705585, 0.14717737, 0.14729887, 0.14742039, 0.14754188, 0.14766335, 0.14778486, 0.14790629, 0.14802778, 0.14814921, 0.14827064, 0.14839207, 0.14851345, 0.14863487, 0.14875625, 0.14887765, 0.14899899, 0.14911726, 0.14923877, 0.14936024, 0.14948174, 0.14960322, 0.14972466, 0.14984614, 0.14996758, 0.15008903, 0.15021048, 0.15033191, 0.15045336, 0.15057476, 0.15069613, 0.15081754, 0.15093893, 0.15106033, 0.15118168, 0.15130307, 0.15142441, 0.15154575, 0.15166707, 0.15178841, 0.15190975, 0.15203108, 0.1521524, 0.1522737, 0.15239497, 0.15251626, 0.15263754, 0.15275881, 0.15288006, 0.15300131, 0.15312254, 0.15324378, 0.15336502, 0.15348625, 0.15360744, 0.15372865, 0.15384984, 0.15397103, 0.15409222, 0.1542134, 0.15433457, 0.15445571, 0.15457687, 0.154698, 0.15481913, 0.15494026, 0.15506139, 0.15518248, 0.1553036, 0.15542467, 0.15554577, 0.15566687, 0.15578793, 0.15590897, 0.15603004, 0.15615107, 0.15627211, 0.15639314, 0.15651417, 0.15663518, 0.15675618, 0.1568772, 0.15699819, 0.15711914, 0.15724014, 0.15736109, 0.15748206, 0.15760301, 0.15772395, 0.15784489, 0.15796579, 0.15808673, 0.15820763, 0.15832853, 0.1584494, 0.1585703, 0.15869117, 0.15881206, 0.15893291, 0.1590538, 0.15917459, 0.15929545, 0.15941627, 0.15953711, 0.15965793, 0.15977873, 0.15989952, 0.16002031, 0.1601411, 0.16026187, 0.16038263, 0.1605034, 0.16062416, 0.16074489, 0.16086562, 0.16098633, 0.16110708, 0.16123079, 0.16135192, 0.16147302, 0.16159411, 0.16171519, 0.16183625, 0.16195729, 0.16207831, 0.16219932, 0.16232032, 0.16244128, 0.16256224, 0.16268316, 0.16280408, 0.162925, 0.16304585, 0.16316673, 0.16328758, 0.16340841, 0.16352923, 0.16365002, 0.16377079, 0.16389158, 0.16401231, 0.16413304, 0.16425376, 0.16437447, 0.16449516, 0.16461581, 0.16473645, 0.16485706, 0.16497768, 0.16509828, 0.16521885, 0.1653394, 0.16545993, 0.16558047, 0.16570096, 0.16582145, 0.16594194, 0.16606238, 0.16618283, 0.16630323, 0.16642363, 0.16654404, 0.16666441, 0.16678473, 0.16690508, 0.16702539, 0.1671457, 0.16726598, 0.16738623, 0.16750649, 0.16762672, 0.16774692, 0.16786712, 0.16798729, 0.16810745, 0.16822758, 0.16834772, 0.16846782, 0.16858791, 0.168708, 0.16882804, 0.16894808, 0.16906811, 0.1691881, 0.16930813, 0.16942808, 0.16954802, 0.16966796, 0.16978788, 0.16990778, 0.17002766, 0.17014754, 0.17026739, 0.17038724, 0.17050703, 0.17062683, 0.17074661, 0.17086639, 0.17098613, 0.17110588, 0.17122556, 0.17134526, 0.17146493, 0.17158461, 0.17170425, 0.17182389, 0.17194349, 0.17206307, 0.17218265, 0.1723022, 0.17242175, 0.17254128, 0.17266077, 0.17278025, 0.17289971, 0.17301917, 0.1731386, 0.17326269, 0.17338239, 0.17350203, 0.17362164, 0.17374118, 0.17386068, 0.17398018, 0.17409959, 0.17421897, 0.17433833, 0.17445764, 0.17457689, 0.17469615, 0.17481531, 0.17493445, 0.17505355, 0.17517263, 0.17529164, 0.17541061, 0.17552955, 0.17564844, 0.1757673, 0.17588611, 0.17600489, 0.1761236, 0.17624231, 0.17636095, 0.17647956, 0.17659813, 0.17671664, 0.17683513, 0.17695358, 0.17707197, 0.17719033, 0.17730866, 0.17742692, 0.17754515, 0.17766334, 0.17778149, 0.17789961, 0.17801768, 0.17813569, 0.1782537, 0.17837164, 0.17848954, 0.17860742, 0.17872521, 0.17884302, 0.17896076, 0.17907844, 0.17919612, 0.17931373, 0.1794313, 0.17954883, 0.17966633, 0.17978378, 0.17990118, 0.18001854, 0.18013589, 0.18025316, 0.18037042, 0.18048762, 0.18060477, 0.18072191, 0.18083897, 0.18095602, 0.18107302, 0.18118995, 0.1813069, 0.18142377, 0.18154059, 0.18165739, 0.18177414, 0.18189085, 0.18200751, 0.18212414, 0.18224074, 0.18235725, 0.18247376, 0.18259022, 0.18270664, 0.18282302, 0.18293935, 0.18305564, 0.18317188, 0.18328813, 0.1834043, 0.18352041, 0.18363652, 0.18375257, 0.18386859, 0.18398453, 0.18410048, 0.18421634, 0.18433221, 0.18444797, 0.18456376, 0.18467946, 0.18479513, 0.18491079, 0.18502481, 0.18513991, 0.18525498, 0.18536997, 0.1854849, 0.18559976, 0.18571456, 0.1858293, 0.18594398, 0.1860586, 0.18617314, 0.18628761, 0.18640205, 0.1865164, 0.1866307, 0.18674493, 0.18685909, 0.1869732, 0.18708724, 0.18720123, 0.18731515, 0.18742901, 0.18754281, 0.18765654, 0.1877702, 0.18788379, 0.18799736, 0.18811081, 0.18822424, 0.18833759, 0.18845089, 0.18856411, 0.18867727, 0.18879038, 0.18890342, 0.18901639, 0.18912929, 0.18924215, 0.18935493, 0.18946765, 0.18958031, 0.18969291, 0.18980545, 0.18991792, 0.19003032, 0.19014269, 0.19025496, 0.19036718, 0.19047934, 0.19059142, 0.19070345, 0.19081542, 0.19092733, 0.19103917, 0.19115095, 0.19126266, 0.19137432, 0.1914859, 0.1915974, 0.19170889, 0.19182028, 0.19193162, 0.1920429, 0.19215412, 0.19226527, 0.19237635, 0.19248736, 0.19259833, 0.19270921, 0.19282004, 0.19293083, 0.19304155, 0.19315217, 0.19326277, 0.19337329, 0.19348373, 0.19359413, 0.19370444, 0.19381472, 0.19392495, 0.19403508, 0.19414514, 0.19425516, 0.19436511, 0.194475, 0.19458483, 0.19469461, 0.19480428, 0.19491394, 0.19502352, 0.19513302, 0.19524246, 0.19535185, 0.19546118, 0.19557044, 0.19567965, 0.19578877, 0.19589783, 0.19600682, 0.19611579, 0.19622689, 0.19633493, 0.19644287, 0.19655077, 0.1966586, 0.19676636, 0.1968741, 0.19698173, 0.19708933, 0.19719687, 0.19730435, 0.19741176, 0.19751909, 0.1976264, 0.19773363, 0.19784079, 0.19794792, 0.19805495, 0.19816196, 0.19826889, 0.19837575, 0.19848257, 0.19858931, 0.19869602, 0.19880264, 0.19890921, 0.19901572, 0.19912216, 0.19922855, 0.19933487, 0.19944115, 0.19954735, 0.19965351, 0.19975959, 0.19986562, 0.19997159, 0.20007749, 0.20018333, 0.2002891, 0.20039485, 0.20050049, 0.20060609, 0.20071164, 0.20081712, 0.20092255, 0.20102793, 0.20113322, 0.20123845, 0.20134364, 0.20144877, 0.20155384, 0.20165884, 0.20176378, 0.20186867, 0.20197348, 0.20207825, 0.20218296, 0.2022876, 0.20239218, 0.20249669, 0.20260116, 0.20270556, 0.2028099, 0.20291418, 0.2030184, 0.20312254, 0.20322666, 0.20333068, 0.20343468, 0.20353858, 0.20364244, 0.20374624, 0.20384999, 0.20395364, 0.20405728, 0.20416082, 0.20426431, 0.20436777, 0.20447113, 0.20457444, 0.2046777, 0.20478091, 0.20488402, 0.20498711, 0.20509012, 0.20519309, 0.20529597, 0.20539878, 0.20550159, 0.2056043, 0.20570692, 0.20580953, 0.20591207, 0.20601454, 0.20611694, 0.2062193, 0.2063216, 0.20642383, 0.20652601, 0.20662811, 0.20672879, 0.20683034, 0.20693184, 0.20703334, 0.2071348, 0.20723622, 0.20733759, 0.20743896, 0.20754029, 0.20764157, 0.20774285, 0.20784409, 0.20794527, 0.20804644, 0.20814759, 0.20824869, 0.20834975, 0.20845078, 0.20855181, 0.20865275, 0.20875369, 0.20885462, 0.20895547, 0.20905632, 0.20915714, 0.20925793, 0.20935866, 0.20945939, 0.20956007, 0.20966072, 0.20976134, 0.20986193, 0.20996249, 0.210063, 0.2101635, 0.21026395, 0.21036439, 0.21046479, 0.21056516, 0.21066549, 0.21076579, 0.21086606, 0.21096629, 0.2110665, 0.21116666, 0.21126682, 0.21136691, 0.211467, 0.21156703, 0.21166706, 0.21176703, 0.21186699, 0.21196689, 0.21206678, 0.21216665, 0.21226646, 0.21236624, 0.21246599, 0.21256573, 0.21266541, 0.21276505, 0.21286465, 0.21296427, 0.21306384, 0.21316338, 0.21326289, 0.21336235, 0.21346177, 0.21356118, 0.21366055, 0.2137599, 0.21385922, 0.21395847, 0.21405773, 0.21415691, 0.21425608, 0.21435523, 0.21445435, 0.21455345, 0.21465249, 0.21475151, 0.2148505, 0.21494943, 0.21504836, 0.21514726, 0.21524613, 0.21534494, 0.21544373, 0.21554248, 0.21564123, 0.21573994, 0.21583858, 0.21593723, 0.21603581, 0.21613438, 0.21623291, 0.21633144, 0.2164299, 0.21652833, 0.21662673, 0.21671557, 0.21681413, 0.21691269, 0.21701126, 0.21710983, 0.21720843, 0.217307, 0.21740556, 0.21750413, 0.21760273, 0.2177013, 0.2177999, 0.21789847, 0.21799706, 0.21809565, 0.21819425, 0.21829285, 0.21839142, 0.21849002, 0.21858862, 0.21868722, 0.21878582, 0.21888442, 0.21898302, 0.21908163, 0.21918027, 0.21927883, 0.21937747, 0.21947607, 0.2195747, 0.21967331, 0.21977194, 0.21987057, 0.21996918, 0.22006781, 0.22016643, 0.22026506, 0.22036369, 0.22046234, 0.22056094, 0.22065958, 0.22075821, 0.22085688, 0.22095551, 0.22105414, 0.2211528, 0.22125143, 0.22135009, 0.22144875, 0.22154738, 0.22164606, 0.22174469, 0.22184336, 0.22194204, 0.22204067, 0.22213934, 0.22223802, 0.22233666, 0.22243533, 0.22253402, 0.22263269, 0.22273135, 0.22283003, 0.22292872, 0.22302741, 0.2231261, 0.22322476, 0.22332343, 0.22342212, 0.22352082, 0.22361949, 0.2237182, 0.2238169, 0.22391559, 0.22401425, 0.22411299, 0.22421165, 0.2243104, 0.22440909, 0.22450781, 0.2246065, 0.22470522, 0.22480391, 0.22490263, 0.22500134, 0.22510004, 0.22519879, 0.2252975, 0.22539622, 0.22549494, 0.22559369, 0.22569242, 0.22579113, 0.22588986, 0.22598861, 0.22608732, 0.22618607, 0.22628482, 0.22638357, 0.22648232, 0.22657765, 0.22667688, 0.22677617, 0.22687544, 0.22697476, 0.2270741, 0.22717343, 0.22727282, 0.22737223, 0.22747165, 0.2275711, 0.22767057, 0.22777003, 0.22786957, 0.2279691, 0.22806865, 0.22816822, 0.22826783, 0.22836745, 0.22846711, 0.22856675, 0.22866647, 0.22876617, 0.22886592, 0.22896568, 0.22906546, 0.22916529, 0.22926509, 0.22936496, 0.22946483, 0.22956471, 0.22966465, 0.22976458, 0.22986457, 0.22996455, 0.23006456, 0.23016459, 0.23026463, 0.23036475, 0.2304648, 0.23056495, 0.2306651, 0.23076525, 0.23086545, 0.23096569, 0.23106591, 0.23116615, 0.23126645, 0.23136675, 0.23146708, 0.2315674, 0.23166779, 0.23176819, 0.23186859, 0.23196904, 0.23206951, 0.23216999, 0.23227049, 0.23237103, 0.23247159, 0.23257214, 0.23267274, 0.23277336, 0.23287401, 0.23297468, 0.23307537, 0.23317607, 0.23327681, 0.23337756, 0.23347832, 0.23357914, 0.23367997, 0.23378083, 0.23388168, 0.23398256, 0.23408349, 0.23418441, 0.23428537, 0.23438637, 0.23448738, 0.2345884, 0.23468946, 0.23479053, 0.23489162, 0.23499273, 0.23509388, 0.23519504, 0.23529625, 0.23539743, 0.23549865, 0.23559992, 0.23570119, 0.2358025, 0.2359038, 0.23600516, 0.23610651, 0.23620792, 0.23630932, 0.23641075, 0.23651221, 0.23661755, 0.23671934, 0.23682117, 0.23692302, 0.2370249, 0.23712683, 0.23722878, 0.23733072, 0.23743275, 0.23753476, 0.23763682, 0.23773891, 0.23784098, 0.23794314, 0.23804529, 0.23814748, 0.2382497, 0.23835199, 0.23845422, 0.23855653, 0.23865888, 0.23876123, 0.23886365, 0.23896603, 0.23906849, 0.23917095, 0.23927347, 0.23937599, 0.23947854, 0.23958114, 0.23968376, 0.2397864, 0.23988907, 0.23999177, 0.2400945, 0.24019726, 0.24030004, 0.24040285, 0.24050571, 0.24060854, 0.24071144, 0.24081434, 0.24091731, 0.24102028, 0.24112329, 0.24122632, 0.24132939, 0.24143249, 0.24153559, 0.24163875, 0.24174191, 0.24184512, 0.24194835, 0.24205163, 0.24215491, 0.24225821, 0.24236158, 0.24246493, 0.24256834, 0.24267177, 0.24277523, 0.24287869, 0.24298222, 0.24308574, 0.24318932, 0.24329291, 0.24339654, 0.2435002, 0.24360389, 0.2437076, 0.24381132, 0.2439151, 0.2440189, 0.2441227, 0.24422655, 0.24433044, 0.24443434, 0.24453828, 0.24464223, 0.24474621, 0.24485026, 0.24495429, 0.24505833, 0.24516244, 0.24526659, 0.24537073, 0.24547492, 0.24557915, 0.24568339, 0.24578765, 0.24589196, 0.24599628, 0.24610063, 0.246205, 0.24630941, 0.24641387, 0.24651833, 0.24662285, 0.24672736, 0.24683192, 0.24693903, 0.24704371, 0.24714845, 0.24725322, 0.24735799, 0.24746282, 0.24756764, 0.2476725, 0.24777737, 0.24788229, 0.24798721, 0.24809219, 0.24819717, 0.24830218, 0.24840723, 0.24851228, 0.24861737, 0.24872251, 0.24882764, 0.24893281, 0.24903798, 0.24914321, 0.24924843, 0.24935372, 0.249459, 0.24956432, 0.24966969, 0.24977505, 0.24988045, 0.24998584, 0.25009131, 0.25019678, 0.25030228, 0.25040781, 0.25051335, 0.25061893, 0.25072455, 0.25083017, 0.25093582, 0.2510415, 0.25114721, 0.25125295, 0.25135869, 0.25146446, 0.25157028, 0.25167611, 0.25178197, 0.25188786, 0.25199378, 0.25209972, 0.25220567, 0.25231165, 0.25241768, 0.25252372, 0.25262976, 0.25273585, 0.25284198, 0.25294811, 0.25305429, 0.25316048, 0.25326669, 0.25337294, 0.25347918, 0.25358552, 0.25369179, 0.25379816, 0.25390452, 0.25401095, 0.25411734, 0.25422379, 0.25433025, 0.25443676, 0.2545433, 0.25464985, 0.25475642, 0.25486305, 0.25496969, 0.25507632, 0.25518301, 0.2552897, 0.25539643, 0.25550318, 0.25560996, 0.25571677, 0.25582361, 0.25593048, 0.25603735, 0.25614426, 0.25625119, 0.25635818, 0.25646517, 0.25657216, 0.25667918, 0.25678626, 0.25689337, 0.25700048, 0.25710762, 0.25721478, 0.25732198, 0.25742918, 0.25753844, 0.25764608, 0.25775376, 0.25786144, 0.25796917, 0.25807688, 0.25818464, 0.25829235, 0.25840014, 0.25850788, 0.25861567, 0.2587235, 0.25883132, 0.25893915, 0.25904697, 0.25915483, 0.25926268, 0.25937057, 0.25947845, 0.25958633, 0.25969428, 0.25980219, 0.25991014, 0.26001811, 0.26012605, 0.26023406, 0.26034203, 0.26045004, 0.26055807, 0.26066613, 0.26077414, 0.26088217, 0.26099026, 0.26109836, 0.26120645, 0.26131454, 0.26142266, 0.26153082, 0.26163897, 0.26174709, 0.2618553, 0.26196349, 0.26207167, 0.26217988, 0.26228812, 0.26239637, 0.26250464, 0.26261288, 0.26272115, 0.26282945, 0.26293775, 0.26304603, 0.26315439, 0.26326272, 0.26337108, 0.26347944, 0.2635878, 0.26369619, 0.26380461, 0.26391304, 0.26402143, 0.26412991, 0.26423836, 0.26434684, 0.26445532, 0.2645638, 0.26467231, 0.26478082, 0.26488939, 0.26499793, 0.26510647, 0.26521507, 0.26532364, 0.26543224, 0.26554084, 0.26564947, 0.2657581, 0.26586673, 0.26597542, 0.26608407, 0.26619279, 0.26630148, 0.2664102, 0.26651895, 0.26662767, 0.26673642, 0.2668452, 0.26695397, 0.26706275, 0.26717156, 0.26728037, 0.26738921, 0.26749808, 0.26760691, 0.26771578, 0.26782465, 0.26793355, 0.26804247, 0.2681514, 0.26826033, 0.26837015, 0.26848027, 0.26859039, 0.26870048, 0.26881051, 0.26892051, 0.26903048, 0.26914039, 0.2692503, 0.26936018, 0.26947004, 0.26957983, 0.26968959, 0.26979935, 0.26990905, 0.27001873, 0.27012837, 0.27023798, 0.27034757, 0.27045709, 0.27056661, 0.27067608, 0.2707856, 0.270895, 0.27100435, 0.27111372, 0.27122304, 0.27133229, 0.27144158, 0.2715508, 0.27165997, 0.27176911, 0.27187827, 0.27198732, 0.27209643, 0.27220544, 0.27231443, 0.27242339, 0.27253231, 0.27264121, 0.27275008, 0.27285892, 0.2729677, 0.27307644, 0.27318522, 0.27329391, 0.27340257, 0.2735112, 0.2736198, 0.27372837, 0.27383694, 0.27394542, 0.27405387, 0.27416232, 0.27427071, 0.2743791, 0.27448747, 0.27459577, 0.27470404, 0.27481228, 0.27492046, 0.27502868, 0.27513683, 0.27524492, 0.27535301, 0.27546108, 0.27556908, 0.27567706, 0.27578503, 0.27589294, 0.27600083, 0.27610868, 0.27621651, 0.27632427, 0.27643204, 0.27653974, 0.27664745, 0.27675509, 0.27686271, 0.27697033, 0.27707788, 0.27718541, 0.27729291, 0.27740037, 0.27750781, 0.27761522, 0.27772254, 0.27782992, 0.27793717, 0.27804446, 0.27815169, 0.27825889, 0.27836609, 0.2784732, 0.27858031, 0.27868739, 0.27879441, 0.2789014, 0.27900839, 0.27911532, 0.27922338, 0.27933136, 0.27943924, 0.27954698, 0.27965459, 0.27976212, 0.27986947, 0.27997673, 0.28008381, 0.2801908, 0.28029767, 0.28040439, 0.28051099, 0.28061748, 0.28072384, 0.28083006, 0.28093615, 0.28104213, 0.28114796, 0.2812537, 0.28135929, 0.28146476, 0.28157008, 0.28167528, 0.28178036, 0.28188533, 0.28199017, 0.28209487, 0.28219941, 0.28230387, 0.28240821, 0.2825124, 0.28261647, 0.28272042, 0.28282422, 0.28292793, 0.28303146, 0.28313491, 0.28323823, 0.28334144, 0.28344446, 0.2835474, 0.28365019, 0.28375286, 0.28385541, 0.28395781, 0.28406012, 0.28416228, 0.28426433, 0.28436622, 0.28446802, 0.28456971, 0.28467122, 0.28477263, 0.2848739, 0.28497505, 0.28507608, 0.28517696, 0.28527772, 0.2853784, 0.28547892, 0.28557932, 0.28567958, 0.28577971, 0.2858797, 0.2859796, 0.28607938, 0.28617901, 0.28627849, 0.28637788, 0.28647712, 0.28657627, 0.28667524, 0.28677413, 0.28687286, 0.28697148, 0.28706995, 0.28716832, 0.28726655, 0.28736466, 0.28746265, 0.28756052, 0.28765824, 0.28775585, 0.28785333, 0.28795066, 0.28804788, 0.28814498, 0.28824195, 0.28833878, 0.28843552, 0.28853211, 0.28862855, 0.2887249, 0.28882107, 0.28891718, 0.28901312, 0.28910896, 0.28920463, 0.28930023, 0.28939626, 0.28949124, 0.28958598, 0.28968051, 0.28977478, 0.2898688, 0.28996259, 0.29005611, 0.29014945, 0.29024246, 0.29033533, 0.29042789, 0.29052022, 0.29061231, 0.29070419, 0.29079577, 0.29088712, 0.29097828, 0.29106915, 0.29115981, 0.29125023, 0.29134038, 0.29143032, 0.29152, 0.29160947, 0.29169866, 0.29178759, 0.29187632, 0.29196486, 0.29205304, 0.29214105, 0.29222879, 0.29231635, 0.29240361, 0.29249063, 0.29257742, 0.29266396, 0.2927503, 0.29283637, 0.29292217, 0.29300779, 0.29309312, 0.29317823, 0.29326308, 0.29334772, 0.29343209, 0.29351622, 0.29360014, 0.29368383, 0.29376721, 0.29385039, 0.2939333, 0.294016, 0.29409847, 0.29418069, 0.29426268, 0.29434437, 0.29442585, 0.29450709, 0.29458812, 0.29466888, 0.29474941, 0.2948297, 0.29490975, 0.29498953, 0.2950691, 0.2951484, 0.2952275, 0.29530632, 0.29538494, 0.29546329, 0.29554144, 0.29561931, 0.29569691, 0.29577428, 0.29585147, 0.29592836, 0.29600504, 0.29608145, 0.29615766, 0.29623362, 0.29630932, 0.29638475, 0.29646, 0.29653493, 0.29660973, 0.29668424, 0.29675847, 0.2968325, 0.29690626, 0.29697981, 0.29705307, 0.29712614, 0.29719895, 0.29727152, 0.29734385, 0.29741594, 0.2974878, 0.29755938, 0.29763076, 0.29769871, 0.29776812, 0.29783717, 0.29790595, 0.29797435, 0.29804242, 0.29811025, 0.29817769, 0.29824483, 0.29831162, 0.29837811, 0.29844424, 0.2985101, 0.29857567, 0.29864082, 0.2987057, 0.29877025, 0.2988345, 0.2988984, 0.29896197, 0.29902521, 0.29908815, 0.29915079, 0.29921311, 0.29927504, 0.2993367, 0.29939801, 0.29945904, 0.29951969, 0.29958007, 0.29964009, 0.29969978, 0.29975918, 0.29981825, 0.29987699, 0.2999354, 0.29999349, 0.30005127, 0.30010873, 0.30016586, 0.30022267, 0.30027914, 0.30033535, 0.30039114, 0.30044666, 0.30050185, 0.30055672, 0.30061129, 0.3006655, 0.30071941, 0.30077299, 0.30082622, 0.30087918, 0.30093181, 0.30098405, 0.30103606, 0.30108768, 0.30113903, 0.30118999, 0.30124068, 0.30129108, 0.30134103, 0.3013908, 0.30144015, 0.30148923, 0.30153796, 0.30158642, 0.30163449, 0.30168226, 0.30172971, 0.30177683, 0.30182362, 0.30187014, 0.3019163, 0.30196211, 0.30200765, 0.30205283, 0.30209771, 0.30214223, 0.30218643, 0.30223036, 0.30227393, 0.30231717, 0.30236012, 0.30240276, 0.30244505, 0.30248699, 0.30252865, 0.30256996, 0.30261096, 0.30265161, 0.30269194, 0.30273202, 0.30277169, 0.30281109, 0.30285013, 0.30288887, 0.30292729, 0.3029654, 0.30300316, 0.30304006, 0.30307597, 0.30311152, 0.30314675, 0.30318168, 0.30321616, 0.30325031, 0.30328414, 0.30331761, 0.30335072, 0.30338344, 0.30341589, 0.3034479, 0.30347958, 0.30351096, 0.3035419, 0.30357257, 0.30360281, 0.3036328, 0.30366236, 0.3036916, 0.30372044, 0.30374902, 0.30377716, 0.30380496, 0.30383247, 0.30385959, 0.30388632, 0.30391273, 0.30393878, 0.30396447, 0.30398983, 0.3040148, 0.30403945, 0.3040638, 0.3040877, 0.30411127, 0.30413449, 0.30415735, 0.30417988, 0.30420208, 0.3042239, 0.30424538, 0.30426645, 0.30428725, 0.30430764, 0.30432773, 0.30434743, 0.30436677, 0.30438575, 0.30440444, 0.30442271, 0.30444065, 0.30445823, 0.30447549, 0.30449235, 0.30450889, 0.30452505, 0.30454087, 0.30455634, 0.30457145, 0.30458623, 0.30460063, 0.30461469, 0.30462843, 0.30464175, 0.30465478, 0.30466741, 0.30467972, 0.30469173, 0.30470327, 0.3047145, 0.30472541, 0.30473593, 0.30474609, 0.30475593, 0.3047654, 0.30477452, 0.30478331, 0.30479172, 0.3047998, 0.30480748, 0.30481485, 0.30482185, 0.30482852, 0.30483478, 0.30484074, 0.30484638, 0.30485156, 0.30485648, 0.30486107, 0.30486521, 0.30486903, 0.30487254, 0.30487564, 0.30487841, 0.3048808, 0.30488288, 0.30488461, 0.30488601, 0.30488622, 0.30488482, 0.30488309, 0.30488101, 0.30487865, 0.30487603, 0.30487302, 0.30486968, 0.30486605, 0.30486208, 0.30485788, 0.30485326, 0.30484837, 0.30484319, 0.30483761, 0.30483174, 0.30482557, 0.30481908, 0.30481228, 0.30480516, 0.30479771, 0.30478993, 0.30478188, 0.30477348, 0.30476478, 0.30475578, 0.30474642, 0.30473673, 0.30472675, 0.30471647, 0.30470586, 0.30469492, 0.30468369, 0.30467209, 0.3046602, 0.30464801, 0.30463549, 0.30462268, 0.30460951, 0.30459604, 0.30458224, 0.30456814, 0.30455372, 0.30453897, 0.30452392, 0.30450851, 0.30449286, 0.30447683, 0.30446047, 0.30444384, 0.30442691, 0.30440959, 0.30439198, 0.3043741, 0.30435589, 0.30433729, 0.30431846, 0.30429924, 0.30427977, 0.30425996, 0.30423978, 0.30421937, 0.30419856, 0.30417749, 0.30415612, 0.30413434, 0.30411232, 0.30408996, 0.30406728, 0.30404431, 0.30402094, 0.30399734, 0.30397341, 0.30394915, 0.30392456, 0.30389965, 0.3038744, 0.30384889, 0.30382305, 0.30379689, 0.30377036, 0.3037436, 0.30371648, 0.30368906, 0.30366129, 0.30363318, 0.30360484, 0.30357611, 0.30354708, 0.30351773, 0.30348811, 0.30345809, 0.30342782, 0.30339721, 0.30336624, 0.30333504, 0.30330345, 0.30327156, 0.30323938, 0.30320683, 0.30317333, 0.30313811, 0.30310264, 0.30306703, 0.30303118, 0.30299515, 0.30295891, 0.30292249, 0.30288589, 0.30284908, 0.30281207, 0.30277485, 0.30273744, 0.30269983, 0.30266207, 0.30262408, 0.3025859, 0.30254757, 0.30250895, 0.30247021, 0.30243123, 0.30239204, 0.30235273, 0.30231312, 0.30227342, 0.30223346, 0.30219328, 0.30215293, 0.30211246, 0.30207169, 0.3020308, 0.30198967, 0.30194837, 0.30190682, 0.30186513, 0.30182323, 0.30178112, 0.30173886, 0.30169636, 0.30165368, 0.30161083, 0.3015677, 0.30152446, 0.30148098, 0.30143732, 0.30139348, 0.30134943, 0.30130517, 0.30126071, 0.30121607, 0.30117124, 0.30112624, 0.30108097, 0.30103555, 0.30098996, 0.30094415, 0.3008981, 0.30085191, 0.30080551, 0.30075893, 0.30071214, 0.30066514, 0.30061793, 0.30057055, 0.30052298, 0.30047521, 0.30042726, 0.30037907, 0.3003307, 0.30028218, 0.30023342, 0.30018449, 0.30013534, 0.30008599, 0.30003643, 0.29998675, 0.2999368, 0.29988664, 0.29983637, 0.29978585, 0.29973516, 0.29968426, 0.29963315, 0.29958186, 0.29953036, 0.29947868, 0.29942679, 0.2993747, 0.29932246, 0.29926994, 0.29921728, 0.29916444, 0.29911143, 0.29905814, 0.2990047, 0.29895109, 0.29889724, 0.2988432, 0.29878896, 0.29873455, 0.29868075, 0.29862711, 0.2985734, 0.29851973, 0.29846594, 0.29841208, 0.29835823, 0.29830429, 0.29825029, 0.29819632, 0.29814216, 0.29808807, 0.29803386, 0.29797962, 0.29792535, 0.29787099, 0.29781666, 0.29776222, 0.29770774, 0.29765317, 0.2975986, 0.29754397, 0.29748926, 0.29743451, 0.29737976, 0.29732487, 0.29727003, 0.29721507, 0.29716009, 0.29710501, 0.29704991, 0.29699481, 0.29693961, 0.29688436, 0.29682904, 0.29677373, 0.29671833, 0.2966629, 0.29660738, 0.29655185, 0.29649621, 0.2964406, 0.29638487, 0.29632914, 0.29627332, 0.2962175, 0.29616159, 0.29610562, 0.29604965, 0.29599357, 0.29593751, 0.2958813, 0.29582512, 0.29576886, 0.29571256, 0.2956562, 0.29559979, 0.29554337, 0.29548684, 0.29543027, 0.29537368, 0.29531702, 0.29526028, 0.29520354, 0.29514673, 0.2950899, 0.29503295, 0.29497603, 0.29491895, 0.29486191, 0.29480481, 0.29474762, 0.29469043, 0.29463318, 0.29457584, 0.2945185, 0.29446107, 0.29440361, 0.29434606, 0.29428855, 0.29423085, 0.29417324, 0.29411551, 0.29405776, 0.29399991, 0.29394203, 0.29388413, 0.29382613, 0.29376811, 0.29371005, 0.29365194, 0.29359373, 0.29353556, 0.29347727, 0.29341891, 0.29336053, 0.29330212, 0.29324365, 0.29318509, 0.29312652, 0.29306892, 0.29301229, 0.29295576, 0.29289922, 0.29284275, 0.29278627, 0.29272985, 0.29267347, 0.29261711, 0.29256076, 0.29250446, 0.29244825, 0.29239202, 0.29233584, 0.29227969, 0.29222354, 0.29216745, 0.29211137, 0.29205537, 0.29199937, 0.29194343, 0.29188749, 0.29183161, 0.29177576, 0.29171994, 0.29166415, 0.29160842, 0.29155269, 0.29149702, 0.29144132, 0.29138574, 0.29133016, 0.29127461, 0.29121912, 0.29116362, 0.29110816, 0.29105279, 0.29099736, 0.29094201, 0.2908867, 0.29083142, 0.29077616, 0.29072097, 0.29066581, 0.29061064, 0.29055554, 0.29050046, 0.29044542, 0.2903904, 0.29033542, 0.29028049, 0.2902256, 0.2901707, 0.29011586, 0.29006106, 0.29000628, 0.28995153, 0.28989685, 0.28984213, 0.28978753, 0.2897329, 0.28967834, 0.2896238, 0.28956929, 0.28951484, 0.28946039, 0.28940597, 0.28935161, 0.28929728, 0.28924298, 0.28918871, 0.28913447, 0.28908026, 0.28902611, 0.28897199, 0.28891787, 0.28886381, 0.28880975, 0.28875577, 0.28870177, 0.28864786, 0.28859398, 0.2885401, 0.28848627, 0.28843248, 0.28837872, 0.28832495, 0.28827125, 0.2882176, 0.28816399, 0.28811038, 0.28805682, 0.2880033, 0.2879498, 0.28789634, 0.28784293, 0.28778952, 0.28773618, 0.28768283, 0.28762954, 0.28757665, 0.28752413, 0.28747171, 0.28741935, 0.28736705, 0.2873148, 0.28726262, 0.28721052, 0.28715849, 0.28710648, 0.28705457, 0.28700271, 0.28695092, 0.28689918, 0.2868475, 0.28679591, 0.28674439, 0.28669292, 0.28664151, 0.28659016, 0.28653887, 0.28648764, 0.2864365, 0.28638542, 0.2863344, 0.28628343, 0.28623253, 0.28618169, 0.28613091, 0.28608021, 0.28602958, 0.28597897, 0.28592849, 0.28587803, 0.28582764, 0.2857773, 0.28572705, 0.28567687, 0.28562671, 0.28557667, 0.28552666, 0.28547671, 0.28542683, 0.28537703, 0.28532726, 0.28527758, 0.28522795, 0.28517842, 0.28512892, 0.28507948, 0.2850301, 0.28498077, 0.28493157, 0.2848824, 0.28483328, 0.28478423, 0.28473526, 0.28468633, 0.28463748, 0.28458869, 0.28453997, 0.2844913, 0.28444269, 0.28439417, 0.28434569, 0.28429726, 0.28424892, 0.28420064, 0.28415245, 0.28410429, 0.28405619, 0.28400818, 0.28396022, 0.2839123, 0.2838645, 0.2838167, 0.28376898, 0.28372136, 0.28367376, 0.28362626, 0.28357881, 0.28353143, 0.2834841, 0.28343683, 0.28338963, 0.28334251, 0.28329542, 0.28324842, 0.28320152, 0.28315461, 0.28310782, 0.28306109, 0.28301439, 0.28296775, 0.2829212, 0.28287473, 0.28282827, 0.2827819, 0.28273562, 0.28268936, 0.28264338, 0.28259763, 0.28255191, 0.28250632, 0.28246075, 0.2824153, 0.28236991, 0.28232458, 0.28227934, 0.28223416, 0.28218907, 0.28214404, 0.2820991, 0.28205422, 0.28200936, 0.28196466, 0.28191999, 0.2818754, 0.28183088, 0.28178644, 0.28174207, 0.28169775, 0.28165355, 0.28160942, 0.28156531, 0.28152132, 0.28147739, 0.28143352, 0.28138977, 0.28134602, 0.28130239, 0.28125882, 0.28121537, 0.28117192, 0.28112859, 0.28108531, 0.2810421, 0.28099898, 0.28095594, 0.28091294, 0.28087005, 0.28082722, 0.28078446, 0.28074178, 0.28069916, 0.28065661, 0.28061414, 0.28057176, 0.28052944, 0.28048718, 0.28044501, 0.28040293, 0.28036088, 0.28031892, 0.28027704, 0.28023523, 0.28019351, 0.28015184, 0.28011024, 0.28006873, 0.2800273, 0.27998593, 0.27994463, 0.27990341, 0.27986225, 0.27982119, 0.27978021, 0.27973926, 0.2796984, 0.27965763, 0.27961692, 0.27957627, 0.27953571, 0.27949521, 0.2794548, 0.27941445, 0.27937418, 0.27933401, 0.27929386, 0.27925381, 0.27921382, 0.27917394, 0.27913409, 0.27909434, 0.27905467, 0.27901503, 0.27897552, 0.27893603, 0.27889666, 0.27885732, 0.2788181, 0.27877894, 0.27873981, 0.2787008, 0.27866185, 0.27862296, 0.27858415, 0.27854541, 0.27850676, 0.27846816, 0.27842978, 0.27839163, 0.27835354, 0.27831551, 0.27827758, 0.2782397, 0.27820188, 0.27816412, 0.27812648, 0.27808887, 0.27805135, 0.27801386, 0.27797648, 0.27793917, 0.27790192, 0.27786472, 0.27782762, 0.27779058, 0.27775359, 0.27771673, 0.27767989, 0.27764314, 0.27760646, 0.27756986, 0.27753326, 0.27749681, 0.2774604, 0.27742407, 0.2773878, 0.27735162, 0.27731547, 0.27727941, 0.27724341, 0.27720749, 0.27717161, 0.27713588, 0.27710015, 0.27706453, 0.27702895, 0.27699345, 0.27695802, 0.27692267, 0.27688739, 0.27685219, 0.27681702, 0.27678195, 0.27674693, 0.276712, 0.27667713, 0.27664235, 0.2766076, 0.27657294, 0.27653837, 0.27650386, 0.27646941, 0.27643505, 0.27640072, 0.27636647, 0.27633232, 0.27629822, 0.27626422, 0.27623025, 0.27619633, 0.27616256, 0.2761288, 0.27609512, 0.27606151, 0.27602798, 0.27599451, 0.27596113, 0.27592778, 0.27589455, 0.27586135, 0.27582824, 0.27579519, 0.27576223, 0.27572933, 0.27569649, 0.27566373, 0.27563104, 0.27559838, 0.27556583, 0.27553338, 0.27550095, 0.27546859, 0.27543634, 0.27540413, 0.275372, 0.27533993, 0.27530792, 0.27527601, 0.27524415, 0.27521238, 0.27518067, 0.27514902, 0.27511743, 0.27508593, 0.27505451, 0.27502313, 0.27499187, 0.27496099, 0.2749306, 0.27490026, 0.27486995, 0.2748397, 0.27480951, 0.27477935, 0.27474922, 0.27471915, 0.27468911, 0.27465916, 0.27462921, 0.27459931, 0.27456948, 0.27453968, 0.27450994, 0.27448022, 0.27445057, 0.27442095, 0.27439138, 0.27436185, 0.27433237, 0.27430293, 0.27427354, 0.27424422, 0.27421492, 0.27418566, 0.27415645, 0.2741273, 0.27409819, 0.27406913, 0.2740401, 0.27401111, 0.27398217, 0.27395332, 0.27392444, 0.27389568, 0.27386689, 0.27383822, 0.27380955, 0.27378094, 0.27375236, 0.27372384, 0.27369538, 0.27366695, 0.27363855, 0.2736102, 0.27358192, 0.27355367, 0.27352548, 0.27349731, 0.27346918, 0.27344114, 0.27341312, 0.27338514, 0.27335718, 0.27332932, 0.27330148, 0.27327371, 0.27324593, 0.27321821, 0.27319056, 0.27316296, 0.27313536, 0.27310789, 0.27308038, 0.27305296, 0.27302557, 0.27299824, 0.27297094, 0.27294371, 0.27291653, 0.27288935, 0.27286223, 0.27283517, 0.27280816, 0.27278116, 0.27275425, 0.27272737, 0.27270055, 0.27267376, 0.27264699, 0.27262029, 0.27259365, 0.272567, 0.27254048, 0.27251396, 0.27248749, 0.27246106, 0.27243465, 0.27240834, 0.27238205, 0.27235582, 0.2723296, 0.27230343, 0.27227733, 0.27225128, 0.27222526, 0.2721993, 0.27217337, 0.2721481, 0.27212378, 0.27209938, 0.27207497, 0.27205053, 0.27202612, 0.27200159, 0.2719771, 0.27195257, 0.27192798, 0.27190343, 0.27187881, 0.27185416, 0.27182952, 0.27180481, 0.2717801, 0.27175537, 0.2717306, 0.27170581, 0.27168098, 0.27165613, 0.27163127, 0.27160636, 0.27158144, 0.2715565, 0.27153155, 0.27150655, 0.27148148, 0.27145648, 0.27143139, 0.27140629, 0.27138117, 0.27135602, 0.27133083, 0.27130562, 0.27128038, 0.27125514, 0.27122983, 0.27120453, 0.2711792, 0.27115384, 0.27112845, 0.27110305, 0.27107763, 0.27105215, 0.27102667, 0.27100116, 0.27097559, 0.27095002, 0.27092442, 0.27089882, 0.27087319, 0.2708475, 0.27082181, 0.27079609, 0.27077034, 0.27074456, 0.27071878, 0.27069294, 0.27066711, 0.27064124, 0.27061534, 0.27058938, 0.27056342, 0.27053747, 0.27051145, 0.27048543, 0.27045938, 0.27043331, 0.2704072, 0.27038103, 0.27035487, 0.2703287, 0.2703025, 0.27027625, 0.27024999, 0.27022368, 0.27019742, 0.27017108, 0.2701447, 0.2701183, 0.27009186, 0.27006543, 0.27003896, 0.27001247, 0.26998594, 0.26995939, 0.26993284, 0.26990622, 0.26987961, 0.26985294, 0.26982626, 0.26979956, 0.26977286, 0.26974609, 0.2697193, 0.26969251, 0.26966569, 0.26963884, 0.26961195, 0.26958546, 0.26955929, 0.26953295, 0.26950651, 0.2694799, 0.26945314, 0.26942626, 0.2693992, 0.26937199, 0.26934469, 0.26931721, 0.26928955, 0.26926178, 0.26923385, 0.26920581, 0.26917759, 0.26914924, 0.26912075, 0.26909208, 0.26906329, 0.26903436, 0.26900524, 0.26897603, 0.26894665, 0.26891714, 0.26888746, 0.26885763, 0.26882768, 0.26879758, 0.2687673, 0.2687369, 0.26870638, 0.26867568, 0.26864484, 0.26861385, 0.26858273, 0.26855147, 0.26852003, 0.26848847, 0.26845673, 0.2684249, 0.26839289, 0.26836073, 0.26832846, 0.268296, 0.2682634, 0.26823068, 0.2681978, 0.26816475, 0.26813161, 0.26809829, 0.26806483, 0.26803121, 0.26799744, 0.26796356, 0.26792949, 0.26789531, 0.26786098, 0.2678265, 0.26779187, 0.26775709, 0.26772216, 0.26768708, 0.26765189, 0.26761651, 0.26758105, 0.26754537, 0.26750958, 0.26747364, 0.26743755, 0.26740131, 0.26736495, 0.26732841, 0.26729175, 0.26725489, 0.26721796, 0.26718083, 0.26714358, 0.26710618, 0.26706862, 0.26703095, 0.26699311, 0.26695514, 0.26691699, 0.26687872, 0.26684028, 0.26680171, 0.266763, 0.26672414, 0.26668516, 0.266646, 0.26660672, 0.26656726, 0.26652768, 0.26648793, 0.26644802, 0.26640803, 0.26636785, 0.26632753, 0.26628706, 0.26624668, 0.26620468, 0.26616246, 0.26611993, 0.26607716, 0.26603413, 0.26599085, 0.26594728, 0.26590347, 0.26585943, 0.26581508, 0.26577047, 0.26572561, 0.26568052, 0.26563513, 0.26558948, 0.26554358, 0.26549742, 0.26545098, 0.26540428, 0.26535738, 0.26531017, 0.26526269, 0.26521495, 0.26516697, 0.26511869, 0.26507017, 0.26502138, 0.26497236, 0.26492307, 0.2648735, 0.26482368, 0.26477358, 0.26472324, 0.26467264, 0.26462176, 0.26457062, 0.26451924, 0.26446757, 0.26441568, 0.26436347, 0.26431105, 0.26425835, 0.2642054, 0.26415217, 0.2640987, 0.26404494, 0.26399094, 0.26393667, 0.26388216, 0.26382732, 0.26377228, 0.26371697, 0.26366138, 0.26360556, 0.26354948, 0.26349309, 0.26343647, 0.2633796, 0.26332244, 0.26326507, 0.26320738, 0.26314947, 0.26309127, 0.26303282, 0.26297411, 0.2629151, 0.26285589, 0.2627964, 0.26273665, 0.26267663, 0.26261634, 0.26255581, 0.26249498, 0.26243392, 0.26237258, 0.26231104, 0.26224917, 0.26218706, 0.26212466, 0.26206204, 0.26199916, 0.26193598, 0.26187256, 0.26180887, 0.26174498, 0.26168075, 0.26161632, 0.26155156, 0.26148659, 0.26142132, 0.26135582, 0.26129007, 0.261224, 0.26115775, 0.26109117, 0.26102436, 0.26095727, 0.26088995, 0.26082233, 0.26075369, 0.26068315, 0.26061231, 0.26054117, 0.26046968, 0.26039794, 0.26032585, 0.26025349, 0.26018077, 0.26010779, 0.26003447, 0.25996086, 0.25988695, 0.25981274, 0.25973818, 0.25966334, 0.25958821, 0.25951272, 0.25943696, 0.25936091, 0.25928456, 0.25920784, 0.25913087, 0.25905356, 0.25897595, 0.25889805, 0.25881982, 0.25874129, 0.25866243, 0.25858331, 0.25850382, 0.25842407, 0.25834402, 0.25826365, 0.25818297, 0.25810197, 0.25802067, 0.25793907, 0.25785714, 0.25777495, 0.2576924, 0.25760958, 0.25752643, 0.25744298, 0.25735924, 0.25727516, 0.25719082, 0.2571061, 0.25702113, 0.25693586, 0.25685024, 0.25676432, 0.2566781, 0.25659162, 0.2565048, 0.25641763, 0.25633019, 0.25624242, 0.25615436, 0.25606602, 0.25597733, 0.25588837, 0.25579906, 0.25570947, 0.25561956, 0.25552934, 0.25543883, 0.255348, 0.25525689, 0.25516543, 0.2550737, 0.25498164, 0.25488928, 0.25479659, 0.25470361, 0.25461033, 0.25451672, 0.25442284, 0.25432864, 0.25423414, 0.2541393, 0.25404418, 0.25394872, 0.25385299, 0.25375694, 0.25366056, 0.25356391, 0.25346693, 0.25336966, 0.25327209, 0.25317419, 0.25307596, 0.25297746, 0.25287864, 0.25277951, 0.25268006, 0.25258034, 0.2524803, 0.25237995, 0.25227928, 0.25217527, 0.25207114, 0.2519668, 0.25186217, 0.25175732, 0.25165221, 0.25154689, 0.25144127, 0.25133544, 0.25122932, 0.25112298, 0.25101638, 0.25090954, 0.25080243, 0.25069508, 0.25058752, 0.25047967, 0.25037158, 0.25026324, 0.25015467, 0.25004584, 0.24993674, 0.24982744, 0.24971786, 0.24960804, 0.24949798, 0.24938765, 0.2492771, 0.24916628, 0.24905521, 0.2489439, 0.24883236, 0.24872054, 0.2486085, 0.24849617, 0.24838361, 0.24827082, 0.24815777, 0.24804448, 0.24793093, 0.24781714, 0.24770309, 0.24758881, 0.24747427, 0.24735948, 0.24724446, 0.24712919, 0.24701366, 0.24689788, 0.24678186, 0.24666557, 0.24654904, 0.24643227, 0.24631526, 0.24619798, 0.2460805, 0.24596271, 0.24584471, 0.24572644, 0.24560794, 0.24548918, 0.24537016, 0.24525093, 0.24513142, 0.24501166, 0.24489169, 0.24477142, 0.24465096, 0.2445302, 0.24440922, 0.24428797, 0.24416649, 0.24404477, 0.24392278, 0.24380055, 0.24367809, 0.24355534, 0.24343237, 0.24330917, 0.24318568, 0.24306194, 0.24293798, 0.24281378, 0.24268931, 0.2425646, 0.24243963, 0.24231444, 0.24218899, 0.24206328, 0.24193732, 0.24181113, 0.24168468, 0.24155799, 0.24143104, 0.24130383, 0.24117641, 0.24104874, 0.24092077, 0.2407926, 0.24066417, 0.24053405, 0.2404031, 0.24027207, 0.24014094, 0.24000971, 0.23987843, 0.23974705, 0.23961554, 0.23948401, 0.23935236, 0.23922062, 0.23908882, 0.23895687, 0.23882487, 0.23869278, 0.23856063, 0.23842837, 0.238296, 0.23816356, 0.23803104, 0.23789844, 0.23776574, 0.23763297, 0.23750006, 0.23736712, 0.23723406, 0.23710093, 0.23696771, 0.23683441, 0.236701, 0.23656753, 0.23643394, 0.23630027, 0.23616654, 0.23603269, 0.23589878, 0.23576476, 0.23563066, 0.23549649, 0.23536222, 0.23522787, 0.23509341, 0.23495889, 0.23482426, 0.23468956, 0.23455477, 0.23441988, 0.23428492, 0.23414986, 0.23401469, 0.23387948, 0.23374416, 0.23360875, 0.23347323, 0.23333769, 0.233202, 0.23306623, 0.23293042, 0.23279445, 0.23265846, 0.23252235, 0.23238614, 0.23224987, 0.2321135, 0.23197705, 0.23184049, 0.23170386, 0.23156714, 0.23143035, 0.23129348, 0.23115648, 0.23101942, 0.23088226, 0.23074502, 0.2306077, 0.23047028, 0.23033276, 0.23019519, 0.23005751, 0.22991973, 0.22978188, 0.22964394, 0.22950593, 0.22936778, 0.22922958, 0.2290913, 0.22895291, 0.22881445, 0.22867589, 0.22853728, 0.22839855, 0.22825971, 0.22812083, 0.22798184, 0.22784276, 0.2277036, 0.22756433, 0.22742501, 0.22728558, 0.22714604, 0.22700797, 0.22686909, 0.22673036, 0.22659168, 0.22645313, 0.22631468, 0.22617635, 0.2260381, 0.22589996, 0.22576195, 0.22562404, 0.22548619, 0.22534847, 0.22521088, 0.22507335, 0.22493593, 0.22479865, 0.22466147, 0.22452438, 0.22438739, 0.22425048, 0.22411369, 0.22397706, 0.22384046, 0.22370401, 0.22356766, 0.22343142, 0.22329526, 0.22315919, 0.22302327, 0.22288744, 0.22275172, 0.22261606, 0.22248055, 0.22234514, 0.22220984, 0.22207461, 0.2219395, 0.22180451, 0.22166958, 0.22153483, 0.22140014, 0.22126555, 0.22113107, 0.22099669, 0.22086243, 0.22072825, 0.22059418, 0.22046027, 0.22032641, 0.22019267, 0.22005902, 0.21992548, 0.21979205, 0.21965872, 0.2195255, 0.21939236, 0.21925934, 0.21912645, 0.21899363, 0.21886092, 0.21872836, 0.21859583, 0.21846347, 0.21833117, 0.21819898, 0.21806693, 0.21793497, 0.21780309, 0.21767135, 0.2175397, 0.21740814, 0.21727669, 0.21714531, 0.2170141, 0.21688297, 0.21675195, 0.21662103, 0.21649021, 0.21635948, 0.21622889, 0.21609837, 0.21596797, 0.21583767, 0.21570747, 0.21557738, 0.2154474, 0.21531752, 0.21518776, 0.21505809, 0.21492854, 0.21479903, 0.21466969, 0.21454045, 0.21441129, 0.21428226, 0.21415332, 0.21402445, 0.21389574, 0.21376713, 0.21364059, 0.21351522, 0.21339011, 0.2132652, 0.21314053, 0.21301609, 0.21289188, 0.2127679, 0.21264413, 0.21252058, 0.21239726, 0.21227419, 0.2121513, 0.21202867, 0.21190624, 0.21178403, 0.21166207, 0.21154034, 0.21141879, 0.21129753, 0.21117643, 0.21105559, 0.21093497, 0.21081458, 0.21069442, 0.21057449, 0.21045475, 0.21033524, 0.21021597, 0.21009691, 0.20997809, 0.20985949, 0.20974112, 0.20962298, 0.20950505, 0.20938735, 0.20926988, 0.20915264, 0.20903559, 0.20891879, 0.20880222, 0.20868586, 0.20856977, 0.20845382, 0.20833817, 0.20822269, 0.20810747, 0.20799246, 0.20787771, 0.20776312, 0.20764883, 0.20753473, 0.20742084, 0.20730717, 0.20719376, 0.20708053, 0.20696755, 0.20685481, 0.20674227, 0.20662995, 0.20651789, 0.20640601, 0.20629439, 0.20618299, 0.20607181, 0.20596084, 0.20585009, 0.20573957, 0.20562929, 0.20551926, 0.20540942, 0.20529982, 0.20519042, 0.20508128, 0.20497231, 0.20486362, 0.20475511, 0.20464687, 0.20453885, 0.20443103, 0.20432344, 0.20421608, 0.20410895, 0.20400201, 0.20389532, 0.20378886, 0.20368263, 0.20357659, 0.20347083, 0.20336525, 0.20325992, 0.20315482, 0.2030499, 0.20294523, 0.20284081, 0.20273659, 0.20263262, 0.20252883, 0.20242529, 0.20232198, 0.20221999, 0.20212051, 0.20202127, 0.20192221, 0.20182338, 0.20172478, 0.20162639, 0.20152821, 0.20143026, 0.20133252, 0.201235, 0.20113771, 0.20104061, 0.20094377, 0.2008471, 0.20075066, 0.20065448, 0.20055847, 0.20046267, 0.20036712, 0.20027177, 0.20017666, 0.20008178, 0.1999871, 0.19989261, 0.19979836, 0.19970432, 0.1996105, 0.19951691, 0.19942352, 0.19933036, 0.19923744, 0.19914469, 0.19905218, 0.19895992, 0.19886784, 0.19877599, 0.19868435, 0.19859293, 0.19850174, 0.19841076, 0.19831997, 0.19822945, 0.19813913, 0.19804901, 0.19795911, 0.19786942, 0.19777997, 0.19769076, 0.19760172, 0.19751292, 0.19742434, 0.19733596, 0.19724782, 0.19715987, 0.19707218, 0.19698466, 0.19689742, 0.19681033, 0.19672352, 0.19663687, 0.19655049, 0.19646429, 0.19637832, 0.19629256, 0.19620702, 0.19612175, 0.19603662, 0.19595173, 0.19586708, 0.19578265, 0.1956984, 0.1956144, 0.19553062, 0.19544704, 0.1953637, 0.19528055, 0.19519764, 0.19511494, 0.19503246, 0.19495019, 0.19486815, 0.19478634, 0.1947047, 0.19462331, 0.19454215, 0.19446117, 0.19438042, 0.19429991, 0.1942196, 0.19413953, 0.19405966, 0.19398001, 0.19390061, 0.19382139, 0.19374236, 0.1936636, 0.19358505, 0.19350669, 0.19342856, 0.19335006, 0.19327475, 0.19319955, 0.19312444, 0.19304942, 0.19297448, 0.19289964, 0.1928249, 0.19275028, 0.19267569, 0.19260125, 0.19252689, 0.19245261, 0.19237839, 0.19230433, 0.19223033, 0.19215642, 0.19208261, 0.1920089, 0.19193527, 0.19186175, 0.19178829, 0.19171493, 0.1916417, 0.19156854, 0.19149548, 0.19142251, 0.19134964, 0.19127682, 0.19120413, 0.19113153, 0.19105902, 0.19098659, 0.19091426, 0.19084205, 0.19076991, 0.19069786, 0.19062591, 0.19055407, 0.19048229, 0.19041061, 0.19033906, 0.19026756, 0.19019616, 0.19012485, 0.19005367, 0.18998253, 0.1899115, 0.18984058, 0.18976974, 0.18969899, 0.18962835, 0.18955779, 0.18948734, 0.18941696, 0.18934667, 0.18927649, 0.18920642, 0.1891364, 0.1890665, 0.18899669, 0.18892696, 0.18885733, 0.1887878, 0.18871836, 0.18864901, 0.18857977, 0.18851058, 0.18844153, 0.18837254, 0.18830363, 0.18823487, 0.18816619, 0.18809757, 0.18802905, 0.18796062, 0.18789232, 0.18782407, 0.18775593, 0.18768789, 0.18761994, 0.18755208, 0.18748432, 0.18741663, 0.18734905, 0.18728158, 0.18721418, 0.18714686, 0.18707965, 0.18701252, 0.18694553, 0.18687859, 0.18681175, 0.186745, 0.18667835, 0.18661179, 0.1865453, 0.18647894, 0.18641266, 0.18634646, 0.18628059, 0.18621467, 0.18614866, 0.18608254, 0.18601638, 0.1859501, 0.18588375, 0.18581729, 0.18575075, 0.18568414, 0.18561743, 0.18555063, 0.18548372, 0.18541676, 0.1853497, 0.18528256, 0.18521532, 0.18514799, 0.18508059, 0.1850131, 0.18494551, 0.18487783, 0.18481009, 0.18474224, 0.18467431, 0.18460628, 0.18453817, 0.18446997, 0.18440169, 0.18433331, 0.18426487, 0.18419631, 0.18412769, 0.18405896, 0.18399015, 0.18392125, 0.18385226, 0.18378319, 0.18371405, 0.1836448, 0.18357544, 0.18350603, 0.18343653, 0.18336694, 0.18329725, 0.18322748, 0.18315761, 0.18308766, 0.18301763, 0.1829475, 0.18287729, 0.182807, 0.18273662, 0.18266615, 0.1825956, 0.18252495, 0.18245421, 0.18238337, 0.18231247, 0.18224148, 0.18217041, 0.18209924, 0.182028, 0.18195665, 0.1818852, 0.18181367, 0.18174206, 0.1816704, 0.18159862, 0.18152674, 0.18145476, 0.18138273, 0.18131056, 0.18123838, 0.18116607, 0.18109366, 0.1810212, 0.1809486, 0.18087594, 0.18080321, 0.18073037, 0.18065746, 0.18058445, 0.18051136, 0.18043816, 0.18036489, 0.18029153, 0.18021807, 0.18014456, 0.18007092, 0.17999724, 0.17992344, 0.17984957, 0.17977558, 0.17970154, 0.1796274, 0.17955315, 0.17947882, 0.17940442, 0.17932993, 0.17925473, 0.17917792, 0.17910092, 0.17902362, 0.17894614, 0.1788684, 0.17879048, 0.17871226, 0.17863384, 0.17855518, 0.17847626, 0.17839718, 0.17831782, 0.1782382, 0.17815839, 0.17807829, 0.17799801, 0.17791748, 0.17783672, 0.17775573, 0.1776745, 0.17759301, 0.17751133, 0.17742938, 0.17734724, 0.17726485, 0.1771822, 0.17709933, 0.17701624, 0.1769329, 0.17684935, 0.17676555, 0.17668153, 0.17659728, 0.17651275, 0.17642801, 0.17634302, 0.17625783, 0.17617241, 0.17608678, 0.17600085, 0.17591472, 0.17582834, 0.17574175, 0.17565489, 0.17556787, 0.17548056, 0.17539302, 0.17530522, 0.17521723, 0.17512898, 0.17504054, 0.17495185, 0.17486288, 0.17477371, 0.1746843, 0.17459469, 0.17450482, 0.17441469, 0.17432436, 0.17423381, 0.174143, 0.17405197, 0.1739607, 0.17386916, 0.1737774, 0.17368546, 0.17359325, 0.17350082, 0.17340814, 0.17331523, 0.17322209, 0.17312869, 0.17303512, 0.17294127, 0.1728472, 0.17275287, 0.17265835, 0.17256352, 0.17246854, 0.17237332, 0.17227784, 0.17218213, 0.17208618, 0.17199001, 0.17189358, 0.17179699, 0.17170009, 0.17160298, 0.17150562, 0.17140804, 0.17131022, 0.17121218, 0.17111394, 0.17101541, 0.17091665, 0.17081769, 0.17071845, 0.170619, 0.17051932, 0.17041826, 0.17031527, 0.170212, 0.17010847, 0.17000459, 0.16990046, 0.16979608, 0.16969137, 0.16958639, 0.16948117, 0.16937558, 0.16926977, 0.16916363, 0.16905724, 0.16895057, 0.1688436, 0.16873634, 0.16862883, 0.16852097, 0.16841286, 0.16830446, 0.16819578, 0.16808687, 0.16797763, 0.16786808, 0.1677583, 0.16764817, 0.16753781, 0.16742718, 0.1673162, 0.16720496, 0.16709347, 0.16698165, 0.16686957, 0.1667572, 0.16664454, 0.16653162, 0.16641839, 0.16630486, 0.1661911, 0.16607699, 0.16596262, 0.16584803, 0.16573307, 0.16561787, 0.16550235, 0.16538656, 0.16527052, 0.16515414, 0.16503756, 0.16492064, 0.1648034, 0.16468593, 0.16456817, 0.16445009, 0.16433178, 0.16421314, 0.16409422, 0.16397507, 0.16385554, 0.16373579, 0.16361578, 0.16349541, 0.16337481, 0.16325395, 0.16313273, 0.16301127, 0.16288953, 0.16276747, 0.16264518, 0.16252255, 0.16239966, 0.16227652, 0.16215302, 0.16202927, 0.16190526, 0.16178097, 0.16165638, 0.16153151, 0.16140632, 0.16128089, 0.16115513, 0.1610291, 0.16090286, 0.16077623, 0.16064939, 0.16052222, 0.16039479, 0.16026704, 0.16013907, 0.16001077, 0.15988219, 0.15975334, 0.1596242, 0.15949477, 0.15936503, 0.15923503, 0.15910481, 0.15897422, 0.15884337, 0.15870591, 0.15857176, 0.15843743, 0.15830286, 0.15816811, 0.1580331, 0.15789782, 0.15776236, 0.15762672, 0.15749076, 0.15735462, 0.15721829, 0.15708168, 0.15694489, 0.15680784, 0.15667059, 0.15653312, 0.15639538, 0.15625748, 0.15611933, 0.15598094, 0.15584235, 0.15570353, 0.15556446, 0.15542519, 0.1552857, 0.15514597, 0.15500604, 0.15486585, 0.15472546, 0.15458487, 0.15444399, 0.15430294, 0.15416166, 0.15402015, 0.15387841, 0.15373643, 0.15359424, 0.15345183, 0.15330921, 0.15316635, 0.15302329, 0.15287994, 0.15273643, 0.15259269, 0.15244868, 0.1523045, 0.15216011, 0.15201543, 0.15187056, 0.15172544, 0.15158013, 0.1514346, 0.15128881, 0.15114282, 0.15099663, 0.15085015, 0.15070352, 0.15055662, 0.15040949, 0.15026216, 0.15011458, 0.14996679, 0.14981879, 0.14967053, 0.1495221, 0.14937344, 0.14922452, 0.14907539, 0.14892603, 0.14877644, 0.14862667, 0.1484766, 0.14832635, 0.1481759, 0.14802517, 0.14787425, 0.14772312, 0.14757173, 0.14742017, 0.14726831, 0.14711627, 0.14696403, 0.14681152, 0.14665881, 0.14650589, 0.14635271, 0.14619933, 0.14604574, 0.14589186, 0.14573781, 0.14558354, 0.14542903, 0.14527431, 0.14511937, 0.14496416, 0.14480877, 0.14465313, 0.14449728, 0.1443412, 0.14418441, 0.14402623, 0.14386795, 0.1437096, 0.14355119, 0.1433927, 0.14323413, 0.14307551, 0.14291681, 0.14275801, 0.14259918, 0.14244026, 0.14228126, 0.14212219, 0.14196306, 0.14180385, 0.14164458, 0.14148523, 0.14132577, 0.14116631, 0.14100671, 0.14084709, 0.14068736, 0.14052761, 0.14036775, 0.14020781, 0.14004782, 0.13988775, 0.13972761, 0.13956738, 0.13940708, 0.13924673, 0.13908631, 0.13892579, 0.13876522, 0.13860457, 0.13844386, 0.13828306, 0.1381222, 0.13796125, 0.13780023, 0.13763916, 0.13747799, 0.13731678, 0.13715549, 0.13699411, 0.13683267, 0.13667117, 0.13650957, 0.1363479, 0.13618618, 0.13602439, 0.13586251, 0.13570055, 0.13553855, 0.13537645, 0.13521431, 0.13505206, 0.13488977, 0.13472737, 0.13456494, 0.13440241, 0.13423982, 0.13407716, 0.13391441, 0.13375163, 0.13358873, 0.13342579, 0.13326277, 0.13309966, 0.13293649, 0.13277324, 0.13260993, 0.13244654, 0.13228309, 0.13211957, 0.13195597, 0.13179229, 0.13162854, 0.13146472, 0.13130084, 0.13113688, 0.13097283, 0.13080874, 0.13064454, 0.13048029, 0.13031599, 0.13015158, 0.12998712, 0.12982258, 0.12965798, 0.12949328, 0.12932853, 0.1291637, 0.12899882, 0.12883383, 0.1286688, 0.12850368, 0.1283385, 0.12817323, 0.12801276, 0.12784798, 0.12768337, 0.12751883, 0.12735444, 0.12719011, 0.12702593, 0.12686186, 0.12669785, 0.12653401, 0.12637021, 0.12620653, 0.12604298, 0.1258795, 0.12571618, 0.12555294, 0.12538981, 0.12522678, 0.12506388, 0.12490103, 0.12473836, 0.12457575, 0.12441327, 0.12425089, 0.12408856, 0.12392644, 0.12376433, 0.12360241, 0.12344053, 0.12327882, 0.12311716, 0.12295566, 0.12279417, 0.1226329, 0.12247167, 0.12231059, 0.12214959, 0.12198867, 0.12182791, 0.12166721, 0.12150667, 0.12134618, 0.12118585, 0.12102561, 0.12086547, 0.12070543, 0.1205455, 0.12038574, 0.12022597, 0.12006637, 0.11990689, 0.1197475, 0.1195882, 0.11942898, 0.11926995, 0.11911096, 0.11895213, 0.11879335, 0.11863472, 0.11847618, 0.11831775, 0.11815941, 0.11800122, 0.11784308, 0.11768512, 0.11752716, 0.11736937, 0.11721171, 0.1170541, 0.11689667, 0.1167393, 0.11658204, 0.1164249, 0.11626785, 0.11611091, 0.11595412, 0.11579736, 0.11564072, 0.11548423, 0.11532782, 0.11517154, 0.11501535, 0.11485928, 0.11470328, 0.11454745, 0.11439165, 0.11423602, 0.1140805, 0.11392505, 0.11376975, 0.11361449, 0.1134594, 0.11330435, 0.11314946, 0.11299464, 0.11283992, 0.11268538, 0.11253087, 0.11237654, 0.11222225, 0.11206912, 0.11191739, 0.11176591, 0.11161467, 0.11146364, 0.11131285, 0.1111623, 0.11101198, 0.11086181, 0.11071195, 0.1105623, 0.11041292, 0.11026376, 0.11011483, 0.10996611, 0.10981765, 0.10966934, 0.1095214, 0.10937357, 0.10922603, 0.1090787, 0.10893165, 0.10878477, 0.10863815, 0.10849179, 0.10834556, 0.10819972, 0.108054, 0.10790854, 0.10776336, 0.10761829, 0.10747361, 0.10732898, 0.10718476, 0.10704061, 0.10689687, 0.1067532, 0.10660975, 0.10646671, 0.10632373, 0.10618114, 0.10603862, 0.10589647, 0.10575442, 0.10561274, 0.10547116, 0.10532989, 0.10518887, 0.10504803, 0.10490743, 0.10476702, 0.10462697, 0.10448704, 0.10434736, 0.10420793, 0.10406873, 0.10392979, 0.10379109, 0.10365255, 0.10351429, 0.1033762, 0.1032384, 0.10310085, 0.10296351, 0.10282639, 0.1026895, 0.10255288, 0.10241644, 0.10228028, 0.10214435, 0.10200862, 0.10187314, 0.10173789, 0.10160287, 0.10146803, 0.10133351, 0.10119916, 0.10106509, 0.1009312, 0.10079755, 0.10066418, 0.100531, 0.10039806, 0.10026535, 0.1001329, 0.10000063, 0.099868655, 0.099736854, 0.099605359, 0.099473968, 0.09934292, 0.099212095, 0.099081412, 0.098951086, 0.09882091, 0.098691024, 0.098561317, 0.098431885, 0.098302625, 0.098173633, 0.098047391, 0.097920939, 0.097794741, 0.097668774, 0.097543158, 0.09741769, 0.097292542, 0.097167723, 0.097043157, 0.096918836, 0.096794829, 0.096671015, 0.096547589, 0.096424319, 0.096301436, 0.09617874, 0.096056372, 0.09593422, 0.09581241, 0.095690832, 0.095569454, 0.095448501, 0.09532769, 0.095207267, 0.095086999, 0.094967119, 0.094847433, 0.094728, 0.09460894, 0.094490051, 0.094371542, 0.09425316, 0.094135217, 0.094017409, 0.093899965, 0.093782701, 0.093665794, 0.093549192, 0.093432754, 0.093316682, 0.093200795, 0.093085296, 0.092969924, 0.092854902, 0.092740133, 0.092625663, 0.092511468, 0.092397563, 0.092283942, 0.092170537, 0.092057437, 0.091944583, 0.091832034, 0.091719739, 0.091607727, 0.091495968, 0.091384493, 0.091273263, 0.091162384, 0.091051705, 0.09094137, 0.090831235, 0.090721399, 0.09061186, 0.090502553, 0.090393566, 0.090284809, 0.090176359, 0.090068124, 0.089960232, 0.089852542, 0.089745209, 0.089638136, 0.089531273, 0.089424729, 0.089318402, 0.08921247, 0.089106694, 0.089001246, 0.088896006, 0.088791102, 0.088686451, 0.088582084, 0.088478029, 0.08837416, 0.088270649, 0.088167354, 0.08806432, 0.087961622, 0.087859176, 0.087756969, 0.087655053, 0.087553427, 0.087452047, 0.087350912, 0.087250158, 0.08714959, 0.087049335, 0.086949319, 0.086849563, 0.08674898, 0.086651139, 0.086553648, 0.086456299, 0.086359203, 0.08626239, 0.086165845, 0.086069554, 0.085973464, 0.085877657, 0.085782059, 0.085686684, 0.085591562, 0.085496768, 0.085402139, 0.085307814, 0.085213684, 0.085119829, 0.085026205, 0.084932834, 0.084839754, 0.084746823, 0.084654242, 0.084561817, 0.084469706, 0.084377803, 0.084286146, 0.084194712, 0.084103622, 0.084012717, 0.083922081, 0.083831646, 0.083741464, 0.083651543, 0.08356183, 0.083472393, 0.083383203, 0.083294287, 0.083205529, 0.083117113, 0.08302889, 0.082940981, 0.082853302, 0.082765788, 0.082678594, 0.082591549, 0.082504876, 0.082418352, 0.082332186, 0.082246162, 0.082160436, 0.082074948, 0.081989631, 0.081904672, 0.081819892, 0.081735417, 0.081651114, 0.081567131, 0.081483349, 0.081399851, 0.081316523, 0.081233487, 0.081150666, 0.081068151, 0.080985866, 0.080903813, 0.080822051, 0.080740415, 0.080659136, 0.080578044, 0.080497287, 0.08041665, 0.08033631, 0.080256201, 0.080176391, 0.080096774, 0.080017447, 0.079938397, 0.079859532, 0.079780906, 0.079702497, 0.079624392, 0.079546496, 0.079468936, 0.079391509, 0.07931444, 0.079237521, 0.079160877, 0.079084508, 0.079008326, 0.078932449, 0.078856774, 0.078781404, 0.078706197, 0.078631274, 0.07855659, 0.078482188, 0.078407988, 0.078334086, 0.078260407, 0.078187525, 0.078115068, 0.078042835, 0.077970773, 0.077898882, 0.077827163, 0.077755615, 0.077684283, 0.077613041, 0.077542014, 0.077471167, 0.077400535, 0.077330016, 0.077259637, 0.077189483, 0.077119492, 0.07704971, 0.076980099, 0.07691063, 0.076841339, 0.076772273, 0.076703228, 0.076634452, 0.076565921, 0.076497495, 0.076429226, 0.076361172, 0.076293282, 0.076225512, 0.076157965, 0.076090567, 0.07602337, 0.075956352, 0.075889498, 0.07582283, 0.075756252, 0.075689949, 0.075623758, 0.075557798, 0.075491987, 0.075426348, 0.075360872, 0.075295545, 0.07523042, 0.075165525, 0.075100698, 0.075036108, 0.074971654, 0.074907452, 0.07484334, 0.074779414, 0.074715711, 0.07465215, 0.074588761, 0.074525528, 0.074462473, 0.074399613, 0.074336901, 0.074274391, 0.074212059, 0.074149847, 0.074087888, 0.074026033, 0.073964365, 0.073902912, 0.073841617, 0.073780447, 0.073719516, 0.073658749, 0.073598109, 0.073537663, 0.073477402, 0.073417291, 0.073357426, 0.073297679, 0.073238067, 0.073178641, 0.073119432, 0.073060356, 0.073001489, 0.072942808, 0.072884277, 0.072825953, 0.072767757, 0.072709687, 0.072651863, 0.072594211, 0.072536714, 0.072479412, 0.072422288, 0.072365291, 0.072308518, 0.072251916, 0.072195448, 0.072139218, 0.072083116, 0.072027117, 0.071971387, 0.071915805, 0.071860403, 0.071807697, 0.071752474, 0.071697332, 0.07164228, 0.071587324, 0.071532443, 0.071477666, 0.071422935, 0.071368322, 0.071313754, 0.071259312, 0.07120496, 0.071150653, 0.071096465, 0.071042381, 0.070988335, 0.070934378, 0.070880517, 0.070826761, 0.070773073, 0.070719466, 0.070665948, 0.070612505, 0.070559189, 0.070505932, 0.07045275, 0.070399679, 0.070346676, 0.070293769, 0.070240885, 0.07018818, 0.070135519, 0.070082948, 0.070030458, 0.069978051, 0.069925748, 0.069873504, 0.06982135, 0.069769278, 0.069717333, 0.069665454, 0.069613591, 0.069561876, 0.069510236, 0.069458731, 0.069407262, 0.069355868, 0.069304571, 0.06925337, 0.069202259, 0.0691512, 0.069100261, 0.069049411, 0.068998612, 0.068947904, 0.068897307, 0.068846785, 0.068796352, 0.068745986, 0.068695731, 0.068645552, 0.068595432, 0.068545416, 0.068495505, 0.06844569, 0.068395905, 0.068346247, 0.068296649, 0.068247162, 0.068197764, 0.068148442, 0.068099171, 0.068050027, 0.068000957, 0.067951947, 0.067903042, 0.067854218, 0.067805536, 0.067756869, 0.067708306, 0.06765981, 0.067611434, 0.067563139, 0.067514919, 0.067466773, 0.067418747, 0.067370772, 0.067322895, 0.067275114, 0.067227423, 0.067179829, 0.067132279, 0.067084804, 0.067037456, 0.066990182, 0.066942975, 0.066895865, 0.066848852, 0.066801928, 0.066755079, 0.066710316, 0.066662923, 0.066615522, 0.066568144, 0.066520795, 0.066473447, 0.066426091, 0.066378772, 0.066331446, 0.066284165, 0.066236861, 0.06618958, 0.066142313, 0.066095054, 0.066047803, 0.066000573, 0.065953344, 0.065906137, 0.065858953, 0.065811746, 0.065764576, 0.065717414, 0.065670259, 0.065623112, 0.065575995, 0.065528877, 0.065481775, 0.065434687, 0.065387607, 0.065340534, 0.065293476, 0.065246433, 0.065199405, 0.065152362, 0.065105356, 0.06505838, 0.065011375, 0.064964406, 0.064917453, 0.064870477, 0.064823546, 0.064776629, 0.064729705, 0.064682797, 0.064635903, 0.064589024, 0.064542137, 0.064495295, 0.064448446, 0.064401612, 0.0643548, 0.064307995, 0.064261198, 0.064214393, 0.064167634, 0.064120866, 0.064074107, 0.064027369, 0.063980639, 0.063933924, 0.063887224, 0.063840538, 0.063793845, 0.063747182, 0.063700527, 0.063653886, 0.063607238, 0.063560605, 0.063514017, 0.063467398, 0.063420825, 0.063374266, 0.063327692, 0.063281149, 0.06323459, 0.063188069, 0.063141562, 0.06309507, 0.063048549, 0.06300208, 0.062955618, 0.062909149, 0.062862717, 0.062816285, 0.062769838, 0.062723443, 0.062677048, 0.062630653, 0.062584274, 0.062537909, 0.062491566, 0.06244522, 0.062398888, 0.06235259, 0.062306274, 0.06225998, 0.062213704, 0.062167436, 0.062121175, 0.062074926, 0.062022794, 0.06197587, 0.061928935, 0.061881956, 0.061834931, 0.061787877, 0.06174079, 0.061693657, 0.061646491, 0.061599292, 0.061552055, 0.061504781, 0.061457478, 0.061410125, 0.061362751, 0.061315332, 0.061267875, 0.061220385, 0.061172869, 0.061125301, 0.061077695, 0.06103006, 0.060982391, 0.060934689, 0.060886946, 0.060839161, 0.060791343, 0.060743488, 0.060695603, 0.060647685, 0.060599722, 0.060551725, 0.06050368, 0.06045562, 0.060407512, 0.060359374, 0.060311191, 0.060262971, 0.060214728, 0.060166441, 0.060118109, 0.060069762, 0.060021359, 0.05997292, 0.05992445, 0.059875958, 0.059827417, 0.059778832, 0.059730228, 0.059681572, 0.059632886, 0.059584167, 0.059535429, 0.059486631, 0.059437796, 0.059388921, 0.059340026, 0.059291091, 0.059242118, 0.059193101, 0.059144061, 0.059094969, 0.059045848, 0.058996685, 0.058947507, 0.058898274, 0.058849011, 0.058799699, 0.058750372, 0.05870099, 0.058651581, 0.058602139, 0.058552656, 0.058503129, 0.058453575, 0.058403987, 0.058354363, 0.058304697, 0.058255002, 0.058205258, 0.058155492, 0.058105685, 0.058055837, 0.058005959, 0.057956051, 0.057906076, 0.05785609, 0.057806067, 0.05775601, 0.057705913, 0.057655782, 0.057605594, 0.057555404, 0.057505157, 0.057454877, 0.057404559, 0.057354204, 0.05730382, 0.057253391, 0.057202928, 0.0571483, 0.057097219, 0.057046082, 0.056994889, 0.056943644, 0.056892335, 0.056840952, 0.056789514, 0.056738012, 0.056686465, 0.056634832, 0.056583166, 0.056531414, 0.056479603, 0.056427743, 0.056375813, 0.056323834, 0.05627178, 0.056219678, 0.056167502, 0.056115255, 0.056062974, 0.056010619, 0.0559582, 0.055905718, 0.055853188, 0.055800576, 0.055747919, 0.055695198, 0.055642415, 0.055589568, 0.055536672, 0.055483706, 0.055430669, 0.055377591, 0.055324435, 0.055271231, 0.055217955, 0.055164617, 0.055111218, 0.055057757, 0.055004247, 0.054950666, 0.054897022, 0.05484331, 0.054789562, 0.054735731, 0.054681849, 0.054627903, 0.054573905, 0.054519821, 0.054465678, 0.054411497, 0.054357227, 0.054302938, 0.054248542, 0.054194104, 0.054139603, 0.054085061, 0.054030441, 0.053975757, 0.053920999, 0.053866196, 0.053811349, 0.053756408, 0.053701423, 0.053646374, 0.053591263, 0.053536084, 0.053480852, 0.05342555, 0.053370219, 0.053314783, 0.053259298, 0.053203765, 0.053148158, 0.05309251, 0.053036783, 0.052981008, 0.052925151, 0.052869238, 0.052813273, 0.052757252, 0.052701157, 0.052645009, 0.052588791, 0.052532516, 0.052476183, 0.052419789, 0.052363332, 0.052306797, 0.052250236, 0.052193578, 0.052136887, 0.052080121, 0.052023306, 0.051966395, 0.05190945, 0.05185245, 0.051795375, 0.051743835, 0.051686164, 0.051628441, 0.051570594, 0.051512748, 0.051454786, 0.051396791, 0.05133871, 0.051280562, 0.051222354, 0.051164068, 0.051105738, 0.051047314, 0.050988872, 0.050930336, 0.050871719, 0.050813049, 0.050754305, 0.050695494, 0.050636623, 0.050577696, 0.050518673, 0.050459594, 0.050400488, 0.05034126, 0.050282001, 0.050222665, 0.050163239, 0.050103772, 0.050044242, 0.049984626, 0.049924981, 0.049865238, 0.049805421, 0.049745567, 0.049685612, 0.04962562, 0.049565557, 0.049505427, 0.049445223, 0.049384959, 0.049324632, 0.049264215, 0.04920375, 0.049143236, 0.049082622, 0.049021956, 0.048961241, 0.048900399, 0.048839565, 0.048778638, 0.048717622, 0.048656572, 0.048595443, 0.048534233, 0.048472978, 0.048411641, 0.048350245, 0.048288792, 0.048227243, 0.048165664, 0.048104007, 0.04804229, 0.047980495, 0.047918621, 0.047856685, 0.047794711, 0.047732636, 0.047670513, 0.047608327, 0.047546044, 0.047483731, 0.047421347, 0.047358885, 0.047296379, 0.047233783, 0.047171097, 0.047108397, 0.047045603, 0.046982739, 0.046919838, 0.046856828, 0.046793766, 0.046730645, 0.046667479, 0.046604205, 0.046540882, 0.046477504, 0.046414047, 0.046350524, 0.046286944, 0.046223287, 0.046159558, 0.046095788, 0.046031956, 0.04596803, 0.045904059, 0.045839988, 0.045775883, 0.045711689, 0.045648716, 0.045583893, 0.045518998, 0.045454063, 0.045389075, 0.045324046, 0.045258936, 0.04519381, 0.045128621, 0.045063376, 0.04499808, 0.044932738, 0.044867322, 0.044801887, 0.044736393, 0.044670828, 0.044605237, 0.044539578, 0.044473872, 0.04440812, 0.044342313, 0.04427645, 0.044210542, 0.044144589, 0.044078559, 0.044012498, 0.043946393, 0.043880224, 0.043814011, 0.043747734, 0.043681428, 0.043615054, 0.043548625, 0.043482143, 0.043415625, 0.043349054, 0.043282434, 0.043215733, 0.043149009, 0.04308223, 0.043015394, 0.042948522, 0.042881582, 0.042814583, 0.042747546, 0.042680465, 0.042613324, 0.042546127, 0.042478893, 0.042411596, 0.042344246, 0.042276863, 0.042209394, 0.042141899, 0.04207436, 0.042006746, 0.041939087, 0.041871391, 0.041803632, 0.041735832, 0.041667972, 0.041600052, 0.041532096, 0.041464079, 0.041396022, 0.041327912, 0.04125974, 0.041191515, 0.04112326, 0.041054938, 0.040986557, 0.040918145, 0.040849667, 0.040781148, 0.04071258, 0.040643957, 0.040575273, 0.040506553, 0.040437769, 0.040368922, 0.040300049, 0.040231116, 0.04016212, 0.040093083, 0.04002399, 0.039954856, 0.039885662, 0.039816421, 0.039747115, 0.039677769, 0.039608389, 0.039538935, 0.039469428, 0.039399888, 0.039330274, 0.03926063, 0.039190933, 0.039121151, 0.039051369, 0.038981508, 0.038912948, 0.038842514, 0.038772047, 0.038701575, 0.0386311, 0.038560599, 0.038490083, 0.038419545, 0.038349003, 0.038278446, 0.038207859, 0.038137279, 0.038066667, 0.037996043, 0.037925407, 0.037854757, 0.037784081, 0.037713405, 0.037642699, 0.037571993, 0.037501253, 0.03743051, 0.037359748, 0.037288986, 0.037218176, 0.037147388, 0.037076563, 0.03700573, 0.036934871, 0.036864005, 0.03679312, 0.036722235, 0.036651313, 0.036580388, 0.036509451, 0.03643848, 0.036367521, 0.036296524, 0.036225516, 0.036154512, 0.036083467, 0.036012426, 0.035941359, 0.035870269, 0.035799176, 0.035728071, 0.035656955, 0.035585813, 0.035514642, 0.035443481, 0.035372291, 0.035301078, 0.035229869, 0.035158634, 0.035087388, 0.035016149, 0.034944862, 0.034873575, 0.034802273, 0.034730949, 0.034659605, 0.03458824, 0.034516878, 0.034445487, 0.034374088, 0.034302685, 0.034231246, 0.034159798, 0.034088336, 0.034016851, 0.033945374, 0.033873875, 0.033802349, 0.033730809, 0.033659242, 0.033587676, 0.033516087, 0.033444498, 0.033372879, 0.033301249, 0.033229597, 0.033157948, 0.033086274, 0.033014577, 0.032942872, 0.032871153, 0.032799423, 0.03272767, 0.032655902, 0.03258412, 0.032512333, 0.03244051, 0.03236869, 0.032296855, 0.032224983, 0.032153122, 0.032081228, 0.032009326, 0.031937413, 0.031865466, 0.031791151, 0.031719003, 0.031646855, 0.031574771, 0.031502739, 0.031430691, 0.031358741, 0.031286795, 0.031214885, 0.031143013, 0.031071192, 0.030999407, 0.030927608, 0.030855911, 0.030784212, 0.030712577, 0.030640917, 0.030569356, 0.030497832, 0.030426282, 0.030354822, 0.030283375, 0.030211987, 0.030140614, 0.030069305, 0.029998004, 0.029926706, 0.029855518, 0.029784333, 0.029713195, 0.029642057, 0.029570984, 0.029499959, 0.029428924, 0.029357985, 0.029287022, 0.029216148, 0.029145323, 0.029074458, 0.029003672, 0.028932935, 0.028862219, 0.028791508, 0.028720884, 0.028650254, 0.02857968, 0.028509153, 0.028438641, 0.028368177, 0.028297726, 0.02822735, 0.028156996, 0.028086683, 0.028016385, 0.027946142, 0.027875941, 0.02780574, 0.027735611, 0.027665487, 0.027595419, 0.027525406, 0.027455391, 0.027385438, 0.027315486, 0.027245609, 0.027175743, 0.027105929, 0.027036136, 0.026966408, 0.026896706, 0.026827028, 0.026757412, 0.026687782, 0.026618229, 0.026548665, 0.026479211, 0.026409756, 0.026340304, 0.026270911, 0.026201569, 0.026132239, 0.026062949, 0.02599372, 0.02592455, 0.025855334, 0.02578623, 0.025717137, 0.025648046, 0.025579017, 0.025510048, 0.025441069, 0.025372151, 0.025303284, 0.025234452, 0.025165621, 0.025096841, 0.02502811, 0.024959393, 0.024890723, 0.024822118, 0.024747526, 0.024679281, 0.02461114, 0.024543019, 0.024475049, 0.02440705, 0.024339255, 0.024271484, 0.024203863, 0.024136243, 0.024068795, 0.024001399, 0.023934102, 0.02386683, 0.023799758, 0.02373266, 0.023665735, 0.023598889, 0.023532063, 0.023465415, 0.023398766, 0.023332294, 0.02326582, 0.023199493, 0.023133194, 0.023067018, 0.023000943, 0.02293497, 0.022868993, 0.022803191, 0.022737466, 0.022671837, 0.022606211, 0.022540785, 0.022475356, 0.02241008, 0.022344926, 0.022279775, 0.022214722, 0.022149768, 0.022084938, 0.022020109, 0.021955431, 0.021890827, 0.021826347, 0.021761868, 0.021697562, 0.021633307, 0.021569125, 0.021505019, 0.021441091, 0.021377161, 0.021313353, 0.021249644, 0.021185989, 0.021122456, 0.021058951, 0.020995619, 0.020932285, 0.020869078, 0.02080597, 0.020742984, 0.020680001, 0.020617144, 0.020554382, 0.020491725, 0.020429088, 0.020366604, 0.020304168, 0.020241883, 0.020179598, 0.020117439, 0.0200554, 0.019993391, 0.019931529, 0.019869717, 0.019808007, 0.019746343, 0.019684833, 0.019623345, 0.019561982, 0.019500693, 0.01943953, 0.019378414, 0.019317403, 0.019256415, 0.019195598, 0.01913481, 0.01907417, 0.01901363, 0.018953115, 0.018892726, 0.018832359, 0.018772144, 0.018711952, 0.01865196, 0.018591944, 0.018532103, 0.018472284, 0.018412543, 0.018358674, 0.018299755, 0.018240934, 0.018182265, 0.01812377, 0.018065274, 0.018006979, 0.017948782, 0.017890686, 0.017832713, 0.017774943, 0.01771722, 0.017659647, 0.017602148, 0.017544851, 0.017487653, 0.017430553, 0.017373579, 0.017316729, 0.017260004, 0.017203478, 0.017146952, 0.017090552, 0.017034374, 0.016978225, 0.016922273, 0.016866345, 0.016810669, 0.016754964, 0.016699536, 0.016644133, 0.016588904, 0.016533799, 0.016478796, 0.016423864, 0.016369084, 0.016314454, 0.016259948, 0.016205518, 0.016151262, 0.016097229, 0.016043123, 0.01598919, 0.015935406, 0.015881797, 0.015828265, 0.015774807, 0.015721522, 0.015668362, 0.01561528, 0.01556242, 0.015509534, 0.015456897, 0.015404336, 0.015351876, 0.015299588, 0.015247401, 0.015195364, 0.015143401, 0.015091564, 0.015039901, 0.014988286, 0.014936873, 0.014885534, 0.014834269, 0.014783253, 0.014732265, 0.014681473, 0.014630633, 0.014580116, 0.014529649, 0.014479283, 0.014429041, 0.0143789, 0.014328956, 0.014279087, 0.014229369, 0.014179724, 0.014130305, 0.014080887, 0.014031666, 0.013982471, 0.013933551, 0.013884655, 0.013835859, 0.013787238, 0.013738692, 0.013690295, 0.013642096, 0.013593874, 0.013545902, 0.013498003, 0.013450204, 0.013402604, 0.013355006, 0.013307656, 0.013260332, 0.013213157, 0.01316608, 0.013119205, 0.013073349, 0.013027322, 0.012981293, 0.012935514, 0.012889736, 0.012844256, 0.012798825, 0.012753546, 0.012708466, 0.012663385, 0.012618504, 0.012573772, 0.01252919, 0.012484757, 0.012440375, 0.012396191, 0.012352109, 0.012308176, 0.012264341, 0.012220707, 0.012177172, 0.012133786, 0.0120905, 0.012047415, 0.012004378, 0.011961542, 0.011918854, 0.011876268, 0.011833831, 0.011791492, 0.011749305, 0.011707264, 0.011665326, 0.011623637, 0.011581947, 0.011540458, 0.011499116, 0.011457826, 0.011416834, 0.011375842, 0.01133495, 0.011294209, 0.011253715, 0.011213272, 0.01117293, 0.011132834, 0.011092891, 0.011052848, 0.011013151, 0.010973457, 0.010934161, 0.010894766, 0.01085557, 0.010816474, 0.010777377, 0.010738679, 0.01070003, 0.010661482, 0.010623085, 0.010584786, 0.010546636, 0.010508687, 0.010470787, 0.010433087, 0.010395488, 0.010358036, 0.010320635, 0.010283533, 0.010246431, 0.01020948, 0.010172677, 0.010136074, 0.010099521, 0.010063167, 0.010026912, 0.0099908588, 0.009954853, 0.0099189971, 0.0098832436, 0.009847736, 0.0098123308, 0.0097769741, 0.0097418167, 0.0097067598, 0.0096719526, 0.0096371444, 0.0096024862, 0.0095680282, 0.0095336689, 0.0094994586, 0.0094653489, 0.0094314376, 0.0093975784, 0.009363818, 0.0093303053, 0.0092968941, 0.0092635825, 0.0092304712, 0.0091975573, 0.0091646444, 0.0091294879, 0.0090973964, 0.009065357, 0.0090335663, 0.0090018008, 0.0089701843, 0.0089386925, 0.0089072753, 0.0088760834, 0.0088449409, 0.0088139726, 0.0087831048, 0.0087523358, 0.0087217912, 0.0086912978, 0.0086609526, 0.0086306827, 0.0086006131, 0.0085705919, 0.0085407449, 0.0085109994, 0.0084813535, 0.0084519805, 0.0084226085, 0.0083933361, 0.0083642881, 0.0083353147, 0.0083064409, 0.0082776928, 0.008249118, 0.0082206428, 0.0081922924, 0.0081640929, 0.0081359418, 0.0081080161, 0.0080801155, 0.0080524627, 0.008024836, 0.0079973834, 0.0079700062, 0.0079428777, 0.0079157501, 0.0078887716, 0.007861943, 0.0078352382, 0.0078086583, 0.0077821538, 0.0077558234, 0.0077295932, 0.0077035367, 0.0076775798, 0.0076517737, 0.0076260669, 0.007600484, 0.0075750514, 0.0075496938, 0.0075244606, 0.0074993521, 0.007474368, 0.0074495836, 0.0074248994, 0.0074003139, 0.0073758541, 0.0073515428, 0.0073274076, 0.0073032463, 0.0072793593, 0.0072554974, 0.0072318101, 0.0072081727, 0.0071847597, 0.0071614957, 0.0071382825, 0.0071151936, 0.0070922296, 0.0070694145, 0.0070467, 0.0070242095, 0.0070017683, 0.0069794282, 0.0069573121, 0.0069351951, 0.006913228, 0.0068914359, 0.0068696928, 0.0068482007, 0.0068267323, 0.0068054134, 0.0067841946, 0.0067632007, 0.0067423559, 0.0067214607, 0.0067008403, 0.0066802199, 0.0066597993, 0.0066394527, 0.0066192569, 0.0065992093, 0.0065792874, 0.0065595889, 0.0065417993, 0.0065225754, 0.0065035508, 0.0064845006, 0.0064656758, 0.0064468756, 0.0064281998, 0.0064096488, 0.0063911979, 0.0063728462, 0.0063545448, 0.0063363677, 0.0063182907, 0.0063002887, 0.0062824353, 0.0062645827, 0.0062469044, 0.0062293261, 0.0062118974, 0.0061944425, 0.0061771632, 0.0061600339, 0.0061428794, 0.0061258744, 0.0061089196, 0.0060921884, 0.0060754325, 0.0060589015, 0.0060423706, 0.0060259136, 0.0060096565, 0.0059934244, 0.0059772925, 0.0059613097, 0.0059453268, 0.0059295688, 0.0059138355, 0.0058982265, 0.0058826427, 0.0058672833, 0.0058519742, 0.0058366894, 0.0058215787, 0.005806494, 0.0057916082, 0.0057767723, 0.0057620369, 0.0057474258, 0.005732839, 0.0057184268, 0.0057040402, 0.005689803, 0.0056756651, 0.0056616273, 0.0056476644, 0.0056338012, 0.0056200619, 0.0056064231, 0.005592884, 0.0055794194, 0.0055660051, 0.0055527654, 0.0055395751, 0.0055265096, 0.0055135689, 0.0055006528, 0.0054879617, 0.0054752696, 0.0054627033, 0.0054502115, 0.0054378193, 0.0054255268, 0.0054133586, 0.0054012658, 0.0053892471, 0.0053774286, 0.0053656353, 0.0053539411, 0.0053423718, 0.0053308266, 0.005319457, 0.0053081871, 0.005296967, 0.0052858461, 0.0052748001, 0.0052639786, 0.005253158, 0.0052424604, 0.0052318638, 0.0052212919, 0.0052108946, 0.0052005965, 0.0051903734, 0.0051802751, 0.0051702266, 0.005160403, 0.0051505286, 0.0051408042, 0.0051311548, 0.0051216302, 0.0051120161, 0.0051028649, 0.005093764, 0.0050846762, 0.0050756619, 0.005066711, 0.0050578592, 0.0050490447, 0.0050402558, 0.005031541, 0.0050228639, 0.0050143246, 0.005005734, 0.0049973312, 0.0049889041, 0.0049805259, 0.004972273, 0.0049639824, 0.0049558412, 0.0049477378, 0.004939659, 0.0049316925, 0.004923726, 0.004915847, 0.0049079806, 0.004900238, 0.0048925704, 0.0048848912, 0.0048773238, 0.0048697311, 0.0048623132, 0.0048549329, 0.0048475526, 0.0048402846, 0.004833003, 0.0048258598, 0.0048187166, 0.0048116473, 0.0048047029, 0.0047977213, 0.0047908775, 0.0047840327, 0.004777276, 0.0047705686, 0.0047638863, 0.0047573405, 0.0047507584, 0.0047443248, 0.0047379173, 0.0047315471, 0.0047252877, 0.004719005, 0.0047128703, 0.0047067492, 0.0047006905, 0.0046947314, 0.0046887342, 0.0046828878, 0.0046770656, 0.0046713059, 0.0046655829, 0.0046599358, 0.0046543754, 0.0046488149, 0.0046433797, 0.0046379566, 0.0046325959, 0.0046273591, 0.0046221232, 0.004616912, 0.0046117879, 0.0046067513, 0.0046017142, 0.004596815, 0.0045919651, 0.0045871278, 0.0045823534, 0.0045776279, 0.0045730155, 0.0045684525, 0.004563902, 0.0045594638, 0.0045550256, 0.004550687, 0.0045463862, 0.0045421841, 0.0045379708, 0.0045338813, 0.0045298417, 0.004525803, 0.0045218882, 0.0045179981, 0.004514196, 0.0045104683, 0.0045067281, 0.0045031128, 0.0044994848, 0.0044960063, 0.0044924906, 0.0044891248, 0.0044854656, 0.0044819377, 0.0044784253, 0.0044749142, 0.0044714278, 0.0044679544, 0.0044645215, 0.0044611148, 0.0044576954, 0.0044543264, 0.0044509475, 0.0044476222, 0.0044443058, 0.0044409945, 0.0044377199, 0.0044344477, 0.0044312156, 0.0044279946, 0.004424789, 0.0044216067, 0.004418429, 0.004415289, 0.0044121752, 0.0044090617, 0.0044059902, 0.0044029169, 0.0043998826, 0.0043968754, 0.0043938565, 0.0043908753, 0.004387897, 0.0043849689, 0.0043820548, 0.0043791439, 0.0043762685, 0.0043733842, 0.0043705492, 0.0043677301, 0.0043649096, 0.0043621417, 0.0043593631, 0.0043566222, 0.0043539088, 0.0043511959, 0.0043485216, 0.0043458366, 0.0043432047, 0.0043405709, 0.0043379776, 0.0043353969, 0.0043328162, 0.0043302886, 0.0043277377, 0.0043252488, 0.0043227742, 0.0043202899, 0.0043178559, 0.0043154219, 0.0043130158, 0.0043106484, 0.0043082689, 0.0043059406, 0.0043036016, 0.0043013012, 0.0042990022, 0.0042967414, 0.0042945053, 0.0042922753, 0.0042900792, 0.0042878632, 0.0042857081, 0.0042835809, 0.0042814272, 0.0042793392, 0.0042772414, 0.0042751799, 0.0042731459, 0.0042710998, 0.0042691054, 0.0042670998, 0.0042651454, 0.0042632162, 0.004261265, 0.0042593763, 0.0042574764, 0.0042556035, 0.0042537693, 0.0042519239, 0.0042501288, 0.0042483243, 0.0042465697, 0.0042448039, 0.0042430898, 0.0042413892, 0.0042396877, 0.0042380407, 0.004236368, 0.0042347601, 0.0042331517, 0.0042315596, 0.0042292196, 0.0042271405, 0.0042250585, 0.0042229672, 0.0042208759, 0.0042187781, 0.0042166715, 0.0042145643, 0.0042124512, 0.0042103352, 0.0042082141, 0.004206093, 0.0042039612, 0.004201828, 0.0041996879, 0.0041975374, 0.0041953917, 0.0041932366, 0.004191081, 0.0041889152, 0.0041867504, 0.0041845813, 0.0041824025, 0.0041802209, 0.004178036, 0.0041758385, 0.0041736416, 0.0041714422, 0.0041692378, 0.0041670292, 0.0041648177, 0.0041625989, 0.0041603749, 0.0041581481, 0.0041559101, 0.004153674, 0.0041514332, 0.0041491841, 0.004146934, 0.0041446807, 0.0041424176, 0.0041401549, 0.0041378862, 0.0041356105, 0.0041333232, 0.0041310415, 0.0041287541, 0.0041264631, 0.0041241646, 0.0041218596, 0.0041195564, 0.0041172439, 0.0041149282, 0.0041126092, 0.0041102776, 0.0041079498, 0.0041056122, 0.0041032746, 0.0041009276, 0.0040985839, 0.0040962277, 0.0040938715, 0.0040915087, 0.0040891338, 0.004086765, 0.0040843869, 0.0040820059, 0.004079618, 0.0040772292, 0.004074831, 0.0040724343, 0.004070031, 0.0040676221, 0.0040652007, 0.0040627816, 0.0040603601, 0.0040579322, 0.004055501, 0.0040530618, 0.0040506218, 0.0040481766, 0.0040457253, 0.0040432629, 0.0040408024, 0.0040383399, 0.0040358687, 0.0040333937, 0.0040309126, 0.0040284321, 0.0040259431, 0.0040234514, 0.0040209549, 0.004018446, 0.0040159398, 0.004013428, 0.0040109097, 0.0040083881, 0.0040058638, 0.0040033357, 0.0040008002, 0.0039983448, 0.0039953841, 0.0039924164, 0.0039894306, 0.003986442, 0.0039834436, 0.0039804261, 0.0039774063, 0.0039743735, 0.0039713318, 0.0039682677, 0.0039652009, 0.0039621219, 0.0039590299, 0.0039559319, 0.0039528213, 0.0039497046, 0.0039465632, 0.0039434242, 0.0039402703, 0.003937094, 0.0039339182, 0.0039307331, 0.0039275354, 0.0039243186, 0.0039211023, 0.0039178701, 0.0039146282, 0.0039113713, 0.0039081117, 0.003904839, 0.0039015412, 0.0038982437, 0.0038949368, 0.0038916143, 0.0038882887, 0.0038849448, 0.003881597, 0.0038782309, 0.0038748558, 0.0038714677, 0.0038680674, 0.0038646606, 0.0038612478, 0.0038578131, 0.0038543723, 0.003850922, 0.0038474656, 0.0038439874, 0.0038405058, 0.0038370027, 0.0038334965, 0.0038299807, 0.0038264554, 0.0038229115, 0.0038193618, 0.0038158023, 0.0038122337, 0.0038086493, 0.0038050497, 0.0038014466, 0.0037978282, 0.0037942, 0.003790563, 0.0037869192, 0.0037832542, 0.003779589, 0.0037759079, 0.0037722085, 0.0037684995, 0.0037647905, 0.0037610692, 0.0037573257, 0.0037535795, 0.0037498237, 0.0037460492, 0.003742272, 0.0037384818, 0.0037346701, 0.0037308612, 0.003727037, 0.0037231974, 0.0037193513, 0.0037154958, 0.0037116311, 0.0037077507, 0.003703861, 0.003699962, 0.0036960382, 0.0036921201, 0.0036881804, 0.0036842411, 0.0036802827, 0.0036763214, 0.0036723476, 0.0036683457, 0.0036643497, 0.0036603354, 0.0036563177, 0.0036522755, 0.0036474501, 0.0036431889, 0.003638915, 0.0036346489, 0.003630372, 0.0036260958, 0.0036218043, 0.0036175139, 0.0036132198, 0.0036089185, 0.0036046088, 0.0036003015, 0.0035959887, 0.0035916637, 0.0035873405, 0.0035830128, 0.0035786689, 0.0035743318, 0.0035699888, 0.0035656423, 0.0035612835, 0.0035569249, 0.0035525628, 0.003548186, 0.0035438149, 0.0035394391, 0.0035350495, 0.0035306637, 0.003526272, 0.0035218729, 0.0035174657, 0.0035130584, 0.0035086456, 0.0035042234, 0.0034998045, 0.0034953759, 0.0034909465, 0.0034865031, 0.0034820591, 0.0034776132, 0.0034731578, 0.0034687014, 0.0034642431, 0.0034597712, 0.0034553001, 0.0034508239, 0.0034463438, 0.0034418516, 0.0034373624, 0.0034328674, 0.003428363, 0.0034238552, 0.0034193445, 0.0034148314, 0.0034103058, 0.0034057803, 0.0034012524, 0.0033967115, 0.0033921734, 0.0033876258, 0.0033830733, 0.0033785172, 0.0033739619, 0.0033693968, 0.0033648231, 0.0033602514, 0.0033556675, 0.0033510819, 0.0033464928, 0.0033419, 0.003337302, 0.0033326945, 0.0033280866, 0.0033234726, 0.0033188469, 0.0033142276, 0.0033095987, 0.0033049609, 0.0033003262, 0.0032956814, 0.0032910344, 0.0032863754, 0.00328172, 0.0032770573, 0.003272393, 0.0032677155, 0.0032630381, 0.0032583545, 0.003253662, 0.0032489728, 0.0032442776, 0.0032395758, 0.0032348649, 0.0032301547, 0.0032254369, 0.0032207109, 0.0032159849, 0.0032112563, 0.0032065157, 0.0032017773, 0.0031972858, 0.0031925228, 0.0031877665, 0.0031830163, 0.0031782791, 0.0031735422, 0.003168812, 0.0031640816, 0.0031593628, 0.0031546571, 0.0031499455, 0.0031452407, 0.0031405413, 0.0031358493, 0.0031311696, 0.0031264895, 0.0031218159, 0.0031171546, 0.0031124882, 0.0031078339, 0.0031031801, 0.0030985384, 0.0030938974, 0.0030892678, 0.0030846454, 0.0030800232, 0.0030754074, 0.0030707978, 0.0030661949, 0.0030615977, 0.0030570007, 0.0030524165, 0.0030478451, 0.0030432674, 0.0030387028, 0.0030341314, 0.003029573, 0.0030250265, 0.0030204807, 0.003015941, 0.003011415, 0.0030068818, 0.0030023616, 0.0029978415, 0.0029933332, 0.0029888253, 0.0029843247, 0.0029798364, 0.0029753477, 0.002970872, 0.0029663902, 0.002961921, 0.0029574577, 0.0029529952, 0.0029485505, 0.0029441079, 0.0029396641, 0.0029352265, 0.0029308023, 0.0029263764, 0.0029219585, 0.0029175468, 0.0029131414, 0.0029087418, 0.0029043434, 0.0028999571, 0.0028955829, 0.0028912029, 0.0028868357, 0.0028824629, 0.0028781143, 0.0028737599, 0.0028694056, 0.002865063, 0.0028607345, 0.0028564055, 0.002852076, 0.0028477605, 0.0028434445, 0.0028391408, 0.0028348365, 0.0028305457, 0.0028262553, 0.0028219651, 0.0028176876, 0.0028134158, 0.0028091443, 0.0028048845, 0.002800639, 0.0027963982, 0.0027921526, 0.0027879195, 0.0027836799, 0.0027794533, 0.0027752379, 0.0027710176, 0.0027668164, 0.0027626087, 0.0027584136, 0.0027542193, 0.0027512247, 0.0027472351, 0.0027432584, 0.0027393063, 0.0027353545, 0.0027314273, 0.0027275311, 0.0027236226, 0.0027197269, 0.0027158496, 0.0027119848, 0.002708151, 0.0027043051, 0.0027004716, 0.0026966569, 0.0026928545, 0.0026890708, 0.0026853054, 0.0026815466, 0.0026778004, 0.0026740665, 0.0026703388, 0.0026666299, 0.0026629586, 0.002659268, 0.0026555967, 0.0026519501, 0.0026483035, 0.0026446879, 0.0026410662, 0.0026374632, 0.0026338729, 0.0026302887, 0.0026267292, 0.0026231885, 0.0026196479, 0.0026161263, 0.0026126166, 0.0026091135, 0.0026056226, 0.0026021693, 0.0025987222, 0.0025952752, 0.0025918405, 0.0025884181, 0.0025850085, 0.0025816173, 0.0025782574, 0.0025748853, 0.0025715439, 0.0025681967, 0.002564868, 0.0025615518, 0.0025582791, 0.0025549817, 0.0025517091, 0.0025484427, 0.0025451952, 0.0025419537, 0.0025387434, 0.0025355332, 0.0025323413, 0.0025291627, 0.0025259897, 0.0025228418, 0.0025196939, 0.0025165584, 0.0025134603, 0.0025103621, 0.002507264, 0.0025041974, 0.0025011306, 0.0024980824, 0.0024950465, 0.0024920171, 0.0024890064, 0.0024860203, 0.0024830347, 0.0024800547, 0.0024771001, 0.0024741455, 0.0024712221, 0.002468311, 0.0024654123, 0.0024625263, 0.0024596464, 0.0024567728, 0.0024539302, 0.0024510878, 0.0024482517, 0.0024454403, 0.0024426538, 0.0024398612, 0.0024370935, 0.0024343322, 0.0024315831, 0.0024288404, 0.0024261165, 0.0024234175, 0.0024207244, 0.0024176312, 0.0024151255, 0.0024126321, 0.002410145, 0.0024076886, 0.0024052393, 0.0024028081, 0.0024003831, 0.0023979708, 0.0023955833, 0.0023931961, 0.0023908273, 0.0023884773, 0.0023861269, 0.0023838021, 0.0023814833, 0.0023791953, 0.0023768889, 0.0023746265, 0.0023723633, 0.0023701133, 0.0023678816, 0.002365669, 0.0023634622, 0.0023612492, 0.0023590736, 0.0023569232, 0.0023547662, 0.0023526093, 0.0023504964, 0.0023483767, 0.0023462761, 0.002344188, 0.0023421184, 0.002340049, 0.0023380106, 0.0023359847, 0.0023339589, 0.0023319516, 0.002329957, 0.0023279935, 0.0023260235, 0.0023240601, 0.002322115, 0.0023201953, 0.0023182877, 0.0023163927, 0.002314504, 0.0023126339, 0.002310764, 0.0023089126, 0.0023070863, 0.0023052783, 0.0023034706, 0.0023016878, 0.0022999053, 0.0022981288, 0.0022963958, 0.0022946501, 0.0022929236, 0.0022912158, 0.0022895201, 0.0022878246, 0.0022861664, 0.0022845084, 0.0022828567, 0.0022812292, 0.002279615, 0.0022780066, 0.0022764236, 0.0022748404, 0.0022732755, 0.0022717232, 0.0022701963, 0.002268669, 0.0022671607, 0.0022656708, 0.0022641746, 0.0022627036, 0.0022612449, 0.0022598174, 0.00225839, 0.0022569748, 0.0022555722, 0.0022541697, 0.0022527922, 0.0022514458, 0.002250093, 0.0022487591, 0.0022474315, 0.0022461286, 0.0022448259, 0.002243554, 0.0022422825, 0.0022410359, 0.0022397891, 0.0022385612, 0.0022373518, 0.0022361425, 0.0022349518, 0.0022334883, 0.0022323164, 0.0022311604, 0.00223001, 0.0022288756, 0.0022277348, 0.0022266286, 0.0022255252, 0.0022244372, 0.0022233403, 0.0022222712, 0.0022212053, 0.0022201517, 0.0022191107, 0.002218076, 0.00221706, 0.0022160378, 0.0022150374, 0.0022140522, 0.0022130767, 0.0022121044, 0.0022111444, 0.0022102001, 0.0022092494, 0.0022083363, 0.0022074135, 0.0022065097, 0.0022056184, 0.0022047362, 0.002203851, 0.0022029816, 0.0022021339, 0.0022012892, 0.0022004601, 0.0021996372, 0.002198827, 0.0021980291, 0.0021972279, 0.0021964456, 0.0021956759, 0.0021949185, 0.0021941736, 0.0021934411, 0.002192715, 0.0021919855, 0.0021912812, 0.0021905829, 0.0021898942, 0.0021892211, 0.0021885633, 0.0021879058, 0.0021872483, 0.0021866278, 0.0021860013, 0.0021853875, 0.0021847889, 0.0021841968, 0.0021836171, 0.0021830406, 0.0021824795, 0.0021819309, 0.002181398, 0.0021808681, 0.0021803477, 0.002179849, 0.0021793346, 0.0021788485, 0.002178381, 0.0021779102, 0.0021774615, 0.0021770252, 0.0021765763, 0.0021761493, 0.0021757379, 0.0021753358, 0.0021749495, 0.0021745691, 0.0021741982, 0.0021738242, 0.0021734845, 0.0021731385, 0.0021728112, 0.0021724901, 0.0021721879, 0.0021718917, 0.0021715958, 0.0021713183, 0.0021710659, 0.0021708009, 0.0021705455, 0.0021703148, 0.0021700934, 0.0021698815, 0.0021696729, 0.0021694889, 0.002169305, 0.0021691208, 0.002168962, 0.0021688093, 0.0021686752, 0.002168674, 0.0021685744, 0.0021684808, 0.0021683874, 0.0021683031, 0.0021682254, 0.0021681597, 0.0021680975, 0.0021680477, 0.0021680039, 0.0021679604, 0.0021679322, 0.0021679106, 0.002167898, 0.0021678761, 0.0021678791, 0.0021678824, 0.002167895, 0.0021679136, 0.0021679448, 0.002167982, 0.0021680165, 0.0021680633, 0.0021681224, 0.0021681879, 0.0021682563, 0.0021683376, 0.0021684216, 0.002168515, 0.0021686149, 0.0021687241, 0.002168833, 0.0021689516, 0.0021690854, 0.0021692226, 0.0021693723, 0.0021695187, 0.0021696775, 0.0021698461, 0.0021700079, 0.0021701918, 0.0021703788, 0.0021705753, 0.0021707779, 0.0021709835, 0.0021712049, 0.0021714324, 0.0021716598, 0.0021718938, 0.002172143, 0.0021723954, 0.002172651, 0.0021729222, 0.0021731996, 0.0021734834, 0.00217377, 0.0021740661, 0.0021743684, 0.0021746801, 0.0021749979, 0.0021753253, 0.0021756617, 0.0021759984, 0.0021763477, 0.002176706, 0.0021770613, 0.0021774292, 0.0021778061, 0.0021781893, 0.0021785854, 0.0021789842, 0.0021793896, 0.002179804, 0.0021802215, 0.002180655, 0.0021810851, 0.0021815274, 0.0021819796, 0.0021824439, 0.0021829021, 0.0021833726, 0.0021838495, 0.0021843358, 0.002184825, 0.0021853331, 0.0021858411, 0.0021863522, 0.002186879, 0.002187412, 0.0021879512, 0.0021884872, 0.0021890358, 0.0021895969, 0.0021901673, 0.0021907375, 0.0021913203, 0.0021919126, 0.0021925049, 0.0021931033, 0.002193714, 0.0021946572, 0.0021953103, 0.0021959757, 0.0021966384, 0.0021973045, 0.0021979706, 0.0021986463, 0.0021993222, 0.0021999984, 0.0022006813, 0.0022013672, 0.0022020563, 0.0022027427, 0.0022034387, 0.0022041351, 0.0022048345, 0.0022055339, 0.0022062403, 0.0022069497, 0.0022076624, 0.0022083723, 0.002209092, 0.0022098147, 0.0022105316, 0.0022112611, 0.0022119905, 0.0022127205, 0.0022134539, 0.0022141933, 0.0022149363, 0.0022156797, 0.0022164229, 0.0022171759, 0.0022179291, 0.0022186793, 0.0022194423, 0.0022202057, 0.002220972, 0.0022217291, 0.0022225024, 0.0022232791, 0.0022240558, 0.0022248325, 0.0022256158, 0.0022264028, 0.0022271862, 0.0022279799, 0.0022287765, 0.0022295762, 0.0022303674, 0.0022311739, 0.0022319807, 0.0022327912, 0.0022335986, 0.0022344149, 0.0022352349, 0.0022360589, 0.0022368764, 0.0022377064, 0.0022385367, 0.0022393642, 0.0022402012, 0.002241042, 0.0022418853, 0.002242723, 0.0022435735, 0.0022444271, 0.0022452809, 0.0022461321, 0.0022469957, 0.0022478595, 0.0022487203, 0.0022495845, 0.0022504588, 0.0022513357, 0.0022522069, 0.0022530907, 0.0022539748, 0.0022548623, 0.0022557469, 0.0022566407, 0.0022575383, 0.0022584328, 0.0022593339, 0.0022602347, 0.0022611455, 0.0022620501, 0.0022629641, 0.002263882, 0.0022648028, 0.0022657209, 0.002266645, 0.0022675761, 0.0022685071, 0.002269435, 0.0022703698, 0.0022713109, 0.002272255, 0.0022731968, 0.0022741482, 0.002275082, 0.002275907, 0.0022767317, 0.0022775573, 0.0022783831, 0.002279209, 0.002280036, 0.0022808632, 0.0022816905, 0.0022825187, 0.0022833473, 0.0022841762, 0.0022850055, 0.0022858349, 0.0022866647, 0.0022874956, 0.0022883266, 0.0022891574, 0.0022899895, 0.0022908221, 0.0022916542, 0.0022924873, 0.0022933211, 0.0022941546, 0.0022949891, 0.0022958245, 0.0022966589, 0.0022974946, 0.0022983311, 0.002299167, 0.002300004, 0.0023008413, 0.0023016792, 0.0023025179, 0.0023033558, 0.002304195, 0.0023050345, 0.0023058741, 0.0023067142, 0.0023075552, 0.0023083959, 0.0023092381, 0.00231008, 0.0023109221, 0.0023117648, 0.0023126083, 0.0023134521, 0.0023142959, 0.0023151406, 0.0023159853, 0.0023168311, 0.0023176763, 0.0023185229, 0.0023193697, 0.0023202167, 0.002321064, 0.0023219117, 0.0023227604, 0.0023236088, 0.0023244584, 0.002325308, 0.0023261576, 0.0023270084, 0.0023278589, 0.0023287102, 0.0023295623, 0.0023304143, 0.0023312673, 0.0023321204, 0.0023329731, 0.0023338271, 0.0023346816, 0.0023355365, 0.0023363912, 0.0023372471, 0.0023381026, 0.0023389594, 0.0023398162, 0.0023406732, 0.002341531, 0.0023423892, 0.0023432476, 0.0023441061, 0.0023449662, 0.0023458255, 0.0023466861, 0.0023475462, 0.0023484074, 0.0023492691, 0.0023501313, 0.0023509932, 0.0023518561, 0.0023527194, 0.0023535828, 0.002354447, 0.0023553111, 0.0023561758, 0.0023570415, 0.0023579074, 0.002358773, 0.0023596399, 0.0023605067, 0.0023613742, 0.0023622417, 0.0023631104, 0.0023639791, 0.0023648483, 0.0023657179, 0.0023665873, 0.0023674581, 0.0023683289, 0.0023692006, 0.0023700716, 0.0023709435, 0.0023718167, 0.0023726895, 0.0023735624, 0.0023744362, 0.002375311, 0.0023761853, 0.00237706, 0.0023779359, 0.0023788118, 0.0023796884, 0.0023805655, 0.0023814419, 0.0023823197, 0.0023831974, 0.0023840759, 0.0023849551, 0.002385834, 0.0023867141, 0.0023875944, 0.0023884743, 0.0023893553, 0.0023902373, 0.0023911188, 0.0023920012, 0.0023928839, 0.002393767, 0.0023946504, 0.0023955347, 0.0023964185, 0.0023973037, 0.0023981892, 0.0023990748, 0.0023999608, 0.0024008474, 0.002401734, 0.0024026216   }, 
   { 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 2.1629829e-15, 6.8803985e-07, 8.0945858e-07, 9.1064084e-07, 1.0624143e-06, 1.2445424e-06, 1.4367888e-06, 1.699863e-06, 1.9325821e-06, 2.2260108e-06, 2.5700306e-06, 2.8938141e-06, 3.2681887e-06, 3.672918e-06, 4.0776472e-06, 4.6037949e-06, 5.1097068e-06, 5.5751452e-06, 6.1417663e-06, 6.7286242e-06, 7.3255992e-06, 7.9428119e-06, 8.5701422e-06, 9.2986547e-06, 1.0017049e-05, 1.0715207e-05, 1.1514548e-05, 1.2324006e-05, 1.3123346e-05, 1.4003633e-05, 1.4853564e-05, 1.5774323e-05, 1.6745673e-05, 1.7676552e-05, 1.8678256e-05, 1.9730551e-05, 2.0792966e-05, 2.1855381e-05, 2.2968385e-05, 2.4091511e-05, 2.5275343e-05, 2.6489532e-05, 2.7653128e-05, 2.8928025e-05, 3.020292e-05, 3.1528412e-05, 3.2864016e-05, 3.4209741e-05, 3.5616173e-05, 3.7052967e-05, 3.8459399e-05, 3.9967017e-05, 4.1464515e-05, 4.3012602e-05, 4.4570814e-05, 4.6169491e-05, 4.7768171e-05, 4.943768e-05, 5.1086954e-05, 5.2796935e-05, 5.4537268e-05, 5.6287725e-05, 5.8068534e-05, 5.9910049e-05, 6.1721214e-05, 6.362344e-05, 6.5495311e-05, 6.7417786e-05, 6.940095e-05, 7.1374001e-05, 7.3387535e-05, 7.5431417e-05, 7.748542e-05, 7.9600133e-05, 8.1745202e-05, 8.3859908e-05, 8.606568e-05, 8.8301815e-05, 9.05177e-05, 9.278419e-05, 9.5050673e-05, 9.738798e-05, 9.976577e-05, 0.00010209296, 0.00010452134, 0.00010699018, 0.0001094388, 0.00011191776, 0.00011443721, 0.00011699711, 0.00011957727, 0.00012216753, 0.00012480839, 0.00012747961, 0.00013018117, 0.00013291309, 0.00013566525, 0.00013842754, 0.00014123028, 0.00014407351, 0.00014691673, 0.00014730179, 0.00015070151, 0.00015416197, 0.00015766289, 0.0001611031, 0.00016468497, 0.00016830732, 0.00017194988, 0.00017573412, 0.00017945765, 0.00018324189, 0.00018710706, 0.00019103294, 0.00019495883, 0.00019896566, 0.0002029725, 0.00020704005, 0.0002111683, 0.00021533703, 0.00021956647, 0.00022383638, 0.00022812652, 0.00023247738, 0.0002368687, 0.000241341, 0.00024583351, 0.00025036649, 0.00025496018, 0.00025961458, 0.00026426898, 0.00026900435, 0.0002738004, 0.00027859648, 0.00028347346, 0.00028841119, 0.00029334889, 0.00029836758, 0.00030336599, 0.00030848585, 0.0003136259, 0.00031878625, 0.00032404772, 0.00032932949, 0.00033463148, 0.00034005483, 0.00034541753, 0.00035088143, 0.00035640594, 0.00036195075, 0.00036755629, 0.00037322252, 0.00037892925, 0.00038467642, 0.00039046406, 0.00039629219, 0.00040218103, 0.00040809007, 0.00041403965, 0.00042007014, 0.00042612085, 0.00043225253, 0.0004384247, 0.00044461706, 0.00045087017, 0.00045718395, 0.00046347751, 0.00046989249, 0.00047628724, 0.00048278319, 0.00048931962, 0.0004959167, 0.00050249358, 0.00050917163, 0.00051589019, 0.00052264915, 0.00052946887, 0.00053628866, 0.00054318929, 0.00055015064, 0.00055711198, 0.0005641543, 0.00057121686, 0.0005783604, 0.00058552407, 0.00059270806, 0.00059997302, 0.00060731889, 0.00061464449, 0.00062205107, 0.0006294981, 0.0006369857, 0.00064453389, 0.00065214286, 0.00065975176, 0.00066746189, 0.00067517202, 0.00068294286, 0.00069079461, 0.0006985857, 0.00070649822, 0.00071445398, 0.00072315568, 0.00073193834, 0.0007406603, 0.00074950379, 0.00075836736, 0.0007672513, 0.00077619584, 0.00078518095, 0.00079418626, 0.0008032117, 0.00081233849, 0.00082148542, 0.00083067286, 0.00083988049, 0.0008491691, 0.0008584375, 0.00086776656, 0.00087719684, 0.00088660687, 0.0008960776, 0.00090560905, 0.00091520126, 0.00092477311, 0.00093436526, 0.0009440789, 0.00095375191, 0.00096352631, 0.00097336125, 0.0009831558, 0.00099307171, 0.0010029675, 0.0010129238, 0.001022941, 0.0010330188, 0.0010431169, 0.001053215, 0.001063394, 0.0010736337, 0.0010838329, 0.0010941335, 0.0011044946, 0.0011148355, 0.0011252573, 0.0011357197, 0.0011462629, 0.0011567861, 0.00116739, 0.0011780345, 0.0011886385, 0.0011993235, 0.0012100892, 0.0012208552, 0.0012317223, 0.0012426297, 0.0012534766, 0.0012644448, 0.0012754333, 0.0012865028, 0.0012975519, 0.001308682, 0.0013198324, 0.0013310031, 0.0013422546, 0.0013535669, 0.0013648792, 0.0013762319, 0.0013876454, 0.0013990588, 0.0014105532, 0.0014221084, 0.0014337039, 0.0014452793, 0.0014569355, 0.0014686325, 0.0014803493, 0.001492127, 0.0015039452, 0.0015157837, 0.001527703, 0.0015396427, 0.0015516228, 0.001563623, 0.0015757246, 0.0015878262, 0.0015999478, 0.0016121708, 0.0016243935, 0.0016366367, 0.0016489811, 0.0016613457, 0.00167369, 0.0016861354, 0.0016986215, 0.001711148, 0.0017236745, 0.0017363224, 0.0017489702, 0.0017616182, 0.0017743673, 0.0017925422, 0.0018056909, 0.0018188827, 0.0018320669, 0.0018452966, 0.0018584809, 0.0018717281, 0.0018849933, 0.0018982167, 0.0019114994, 0.0019248177, 0.0019380967, 0.0019514378, 0.0019647761, 0.0019781147, 0.0019914706, 0.0020048674, 0.0020182817, 0.0020316506, 0.0020451052, 0.0020585551, 0.0020719669, 0.0020854545, 0.002098945, 0.0021124301, 0.0021259354, 0.0021394789, 0.0021530045, 0.0021665681, 0.0021801519, 0.0021937508, 0.0022073323, 0.0022209275, 0.0022345858, 0.0022482027, 0.0022618801, 0.0022755552, 0.0022892288, 0.0023029414, 0.0023166502, 0.0023304014, 0.0023441317, 0.0023579004, 0.0023716888, 0.002385475, 0.002399283, 0.0024131262, 0.002426907, 0.0024407695, 0.0024546732, 0.0024684935, 0.0024824135, 0.0024963315, 0.0025102694, 0.0025241619, 0.0025381404, 0.0025521137, 0.0025660871, 0.0025801009, 0.0025941124, 0.0026081032, 0.0026221704, 0.0026362194, 0.0026502649, 0.0026643537, 0.0026784786, 0.0026926037, 0.0027067063, 0.0027208466, 0.0027350478, 0.0027491676, 0.0027633675, 0.0027776053, 0.0027917824, 0.00280602, 0.0028202718, 0.0028345461, 0.0028487789, 0.0028630923, 0.0028774226, 0.0028917133, 0.0029060622, 0.0029204101, 0.002934753, 0.0029491407, 0.0029635457, 0.00297793, 0.0029923725, 0.0030067966, 0.003021277, 0.0030357132, 0.0030501927, 0.0030647113, 0.0030792069, 0.0030937444, 0.0031082779, 0.0031228114, 0.003137382, 0.0031519751, 0.0031665657, 0.0031786079, 0.0031929151, 0.0032072479, 0.0032215398, 0.0032358195, 0.0032500683, 0.0032643264, 0.0032785751, 0.0032927904, 0.003307004, 0.0033211973, 0.0033353807, 0.0033495463, 0.0033637057, 0.0033778322, 0.0033919699, 0.0034060834, 0.0034201785, 0.0034342692, 0.0034483387, 0.0034623868, 0.0034764362, 0.0034904713, 0.0035044674, 0.0035184813, 0.0035324851, 0.0035464407, 0.003560394, 0.0035743508, 0.0035882671, 0.0036021848, 0.0036160988, 0.0036299825, 0.0036438494, 0.0036577217, 0.0036715812, 0.0036853978, 0.0036992242, 0.0037130408, 0.0037268144, 0.0037406082, 0.0037543641, 0.0037681046, 0.0037818525, 0.0037955809, 0.0038092746, 0.0038229686, 0.0038366714, 0.0038503003, 0.0038639703, 0.0038776197, 0.0038912264, 0.0039048435, 0.0039184485, 0.0039320211, 0.0039455793, 0.0039591417, 0.0039727003, 0.0039862194, 0.0039997348, 0.0040132212, 0.0040267156, 0.004040183, 0.0040536453, 0.004067075, 0.0040805223, 0.0040939413, 0.0041073263, 0.0041207219, 0.0041340906, 0.0041474421, 0.004160793, 0.0041741417, 0.0041874396, 0.0042007565, 0.004214053, 0.0042273155, 0.0042405729, 0.0042538256, 0.0042670448, 0.0042802827, 0.0042935009, 0.0043066759, 0.0043198601, 0.0043330188, 0.0043461816, 0.0043593012, 0.0043724398, 0.0043855566, 0.0043986333, 0.0044117165, 0.0044247867, 0.0044378294, 0.0044508702, 0.0044638989, 0.0044769077, 0.0044899145, 0.0045028999, 0.0045158691, 0.0045288117, 0.0045414343, 0.0045536878, 0.004565971, 0.0045782141, 0.0045904266, 0.0046025994, 0.0046147718, 0.0046269032, 0.0046389946, 0.0046510962, 0.004663147, 0.0046752081, 0.0046872185, 0.0046992088, 0.0047111581, 0.0047230977, 0.0047350475, 0.004746926, 0.0047588055, 0.0047706533, 0.0047824616, 0.0047942493, 0.0048060273, 0.0048177741, 0.0048294812, 0.0048412085, 0.0048528644, 0.0048645209, 0.0048761466, 0.004887722, 0.0048993276, 0.0049108728, 0.0049224179, 0.0049339118, 0.004945416, 0.0049568601, 0.0049682632, 0.0049796868, 0.0049910704, 0.0050024125, 0.0050137755, 0.0050250776, 0.0050363392, 0.0050476212, 0.0050588725, 0.0050700535, 0.0050812643, 0.0050924346, 0.0051035653, 0.0051146746, 0.0051257843, 0.0051368233, 0.0051478622, 0.0051589021, 0.0051698801, 0.0051808781, 0.0051918062, 0.0052027539, 0.0052136215, 0.0052244887, 0.0052353353, 0.0052461615, 0.0052569783, 0.0052677542, 0.0052784993, 0.0052892151, 0.0052999202, 0.0053106053, 0.0053212494, 0.0053318739, 0.005342498, 0.0053530508, 0.0053636343, 0.0053741373, 0.0053846603, 0.0053951526, 0.0054056053, 0.0054160678, 0.0054264492, 0.0054368302, 0.0054471917, 0.0054575428, 0.0054678433, 0.0054781437, 0.0054884027, 0.0054986528, 0.0055088624, 0.0055190413, 0.0055292305, 0.0055393483, 0.0055494872, 0.0055595855, 0.0055696429, 0.0055796904, 0.0055897073, 0.0055997148, 0.0056096809, 0.0056196474, 0.0056295735, 0.005639479, 0.0056501259, 0.0056595267, 0.0056688967, 0.0056782654, 0.0056876433, 0.0056969891, 0.0057063149, 0.0057156482, 0.0057249418, 0.005734242, 0.0057435227, 0.0057528014, 0.0057620686, 0.005771304, 0.0057805497, 0.0057897638, 0.0057989662, 0.0058081574, 0.0058173472, 0.0058265156, 0.005835664, 0.0058448194, 0.0058539556, 0.0058630686, 0.0058721607, 0.0058812718, 0.0058903429, 0.0058994107, 0.0059084785, 0.0059175151, 0.005926549, 0.005935553, 0.0059445756, 0.0059535578, 0.0059625264, 0.0059715053, 0.0059804628, 0.00598939, 0.0059983144, 0.0060072481, 0.0060161408, 0.0060250307, 0.0060339207, 0.0060427799, 0.0060516382, 0.0060604624, 0.0060693086, 0.0060781129, 0.0060869046, 0.0060957158, 0.0061044861, 0.0061132554, 0.0061220014, 0.0061307377, 0.0061394633, 0.0061481874, 0.006156879, 0.0061655594, 0.0061742398, 0.006182909, 0.0061915461, 0.0062001827, 0.0062088175, 0.0062174308, 0.0062260237, 0.0062346151, 0.0062431833, 0.0062517421, 0.00626028, 0.0062688268, 0.0062773507, 0.0062858444, 0.0062943576, 0.0063028382, 0.0063113077, 0.0063197557, 0.0063282149, 0.0063366494, 0.0063450644, 0.0063534891, 0.0063618706, 0.0063702613, 0.0063786213, 0.0063869907, 0.0063953283, 0.0064036539, 0.0064119888, 0.006420292, 0.0064285742, 0.0064368551, 0.0064451359, 0.0064533842, 0.0064616301, 0.0064698677, 0.0064780717, 0.0064862845, 0.0064944676, 0.0065026595, 0.0065108193, 0.0065189768, 0.0065250401, 0.0065332474, 0.0065414435, 0.0065496666, 0.0065578911, 0.0065661245, 0.0065743662, 0.0065826061, 0.0065908665, 0.0065991259, 0.0066073933, 0.0066156602, 0.0066239452, 0.0066322293, 0.0066405344, 0.0066488371, 0.006657138, 0.006665458, 0.0066737882, 0.006682117, 0.0066904547, 0.0066988105, 0.0067071561, 0.0067155217, 0.0067238831, 0.0067322557, 0.0067406381, 0.0067490283, 0.0067574275, 0.0067658257, 0.0067742337, 0.0067826598, 0.0067910845, 0.0067995088, 0.0068079527, 0.0068163937, 0.0068248552, 0.0068333158, 0.006841775, 0.0068502519, 0.0068587395, 0.0068672267, 0.0068757203, 0.0068842247, 0.0068927375, 0.0069012605, 0.0069097797, 0.0069183214, 0.0069268495, 0.0069353986, 0.0069439434, 0.0069525009, 0.0069610751, 0.0069696377, 0.006978231, 0.0069868248, 0.0069954256, 0.0070040133, 0.007012622, 0.00702124, 0.007029877, 0.0070385127, 0.0070471466, 0.0070558009, 0.0070644435, 0.0070731058, 0.0070817755, 0.0070904456, 0.0070991335, 0.0071078213, 0.0071165184, 0.0071252119, 0.0071339374, 0.0071426514, 0.0071513839, 0.0071601034, 0.0071688443, 0.007177595, 0.007186343, 0.00719511, 0.007203877, 0.0072126519, 0.0072214454, 0.0072302287, 0.0072390204, 0.0072478224, 0.0072566317, 0.0072654611, 0.0072742896, 0.0072831158, 0.0072919521, 0.0073008081, 0.0073096519, 0.0073185139, 0.0073273862, 0.007336258, 0.0073451474, 0.0073540369, 0.0073629348, 0.0073718317, 0.0073821228, 0.0073914523, 0.0074008014, 0.0074101612, 0.0074195303, 0.0074289301, 0.0074383402, 0.0074477908, 0.0074572512, 0.0074667227, 0.0074762134, 0.0074857245, 0.0074952561, 0.0075048078, 0.0075143692, 0.0075239409, 0.0075335535, 0.0075431662, 0.0075527881, 0.0075624413, 0.0075721042, 0.0075817979, 0.0075915209, 0.0076012346, 0.007610979, 0.0076207328, 0.007630527, 0.0076403012, 0.007650116, 0.0076599307, 0.007669786, 0.0076796613, 0.007689537, 0.0076994528, 0.0077093686, 0.0077193151, 0.0077292714, 0.0077392478, 0.0077492348, 0.0077592516, 0.0077692694, 0.0077793067, 0.0077893939, 0.007799482, 0.0078095701, 0.0078196879, 0.007829817, 0.0078399861, 0.0078501552, 0.0078603541, 0.0078705531, 0.0078807827, 0.0078910226, 0.0079012932, 0.0079115527, 0.0079218522, 0.007932174, 0.0079424949, 0.0079528652, 0.0079632271, 0.0079736076, 0.0079840198, 0.0079944525, 0.0080048935, 0.0080153458, 0.0080258083, 0.0080363108, 0.0080468133, 0.0080573773, 0.0080679208, 0.0080784643, 0.0080890581, 0.0080996621, 0.008110296, 0.0081209308, 0.0081315748, 0.0081422394, 0.0081529645, 0.0081636598, 0.0081743859, 0.0081851305, 0.0081958864, 0.008206673, 0.0082174893, 0.0082282955, 0.0082391324, 0.0082499692, 0.0082608666, 0.0082717435, 0.0082826614, 0.0082935793, 0.0083045065, 0.0083154747, 0.0083264429, 0.0083374614, 0.0083484603, 0.008359489, 0.0083705587, 0.0083816275, 0.0083927177, 0.0084020365, 0.008413096, 0.0084241852, 0.0084353052, 0.0084464252, 0.0084575759, 0.0084687565, 0.0084799472, 0.0084911687, 0.0085024098, 0.0085136816, 0.0085249636, 0.0085362755, 0.0085476087, 0.0085589504, 0.0085703339, 0.0085817268, 0.0085931402, 0.0086045545, 0.0086160386, 0.0086275125, 0.0086390171, 0.008650532, 0.0086620869, 0.0086736623, 0.0086852582, 0.0086968737, 0.0087084891, 0.0087201353, 0.008731842, 0.0087435292, 0.0087552564, 0.0087669939, 0.0087787611, 0.0087905591, 0.0088023767, 0.0088142045, 0.0088260528, 0.0088379225, 0.0088498322, 0.0088617513, 0.0088736806, 0.0088856304, 0.0088976296, 0.0089096511, 0.0089216921, 0.0089337323, 0.0089457938, 0.0089578955, 0.0089700166, 0.0089821685, 0.0089942999, 0.0090064825, 0.0090186857, 0.0090309391, 0.0090432018, 0.009055445, 0.0090677179, 0.0090800431, 0.0090923868, 0.0091047511, 0.0091171153, 0.0091295317, 0.0091419565, 0.0091544129, 0.0091668889, 0.0091793435, 0.0091918502, 0.0092043765, 0.0092169428, 0.0092295306, 0.0092421379, 0.009254735, 0.0092673935, 0.0092800716, 0.0092927702, 0.0093054576, 0.0093181562, 0.0093309265, 0.0093436958, 0.0093565155, 0.0093693351, 0.0093821539, 0.0093950154, 0.0094079161, 0.0094208168, 0.009433738, 0.0094466889, 0.0094596408, 0.0094726728, 0.0094856955, 0.009498708, 0.0095117697, 0.0095248427, 0.0095379557, 0.009551079, 0.0095642135, 0.009577387, 0.009590582, 0.0096037956, 0.009617608, 0.0096300244, 0.0096424595, 0.0096549448, 0.0096674822, 0.0096800895, 0.0096927071, 0.0097053954, 0.0097181341, 0.0097309034, 0.0097437128, 0.0097565735, 0.0097694742, 0.0097823953, 0.009795377, 0.0098083988, 0.0098214922, 0.009834595, 0.0098477798, 0.0098610148, 0.0098742489, 0.0098875435, 0.0099009108, 0.0099142566, 0.0099276835, 0.0099411914, 0.0099546993, 0.009968278, 0.0099818977, 0.0099955369, 0.010009257, 0.010022997, 0.010036768, 0.010050621, 0.010064483, 0.010078395, 0.010092358, 0.010106361, 0.010120437, 0.010134541, 0.010148686, 0.010162872, 0.010177108, 0.010191386, 0.010205693, 0.010220061, 0.010234449, 0.010248918, 0.010263438, 0.010277979, 0.010292579, 0.01030721, 0.010321912, 0.010336613, 0.010351396, 0.010366159, 0.010381023, 0.010395916, 0.010410882, 0.010425867, 0.010440893, 0.010455988, 0.010471125, 0.010486293, 0.010501511, 0.010516729, 0.010532017, 0.010547377, 0.010562766, 0.010578218, 0.010593697, 0.010609189, 0.010624782, 0.010640414, 0.010656006, 0.010671761, 0.010687475, 0.010703279, 0.010719125, 0.010735011, 0.010750916, 0.010766893, 0.010782911, 0.010798978, 0.010815077, 0.010831204, 0.010847374, 0.010863633, 0.010879914, 0.010896225, 0.010912595, 0.010929017, 0.01094547, 0.010962003, 0.010978516, 0.010995141, 0.011011745, 0.011028421, 0.011045156, 0.011061922, 0.011079832, 0.011096102, 0.011112494, 0.011129007, 0.011145581, 0.011162216, 0.011178931, 0.011195849, 0.011212848, 0.011229907, 0.011247027, 0.011264329, 0.011281692, 0.011299136, 0.011316662, 0.011334267, 0.011352075, 0.011369904, 0.011387813, 0.011405843, 0.011423996, 0.011442209, 0.011460523, 0.011478918, 0.011497435, 0.011516093, 0.011534772, 0.011553551, 0.011572451, 0.011591494, 0.011610597, 0.011629782, 0.011649027, 0.011668475, 0.011687941, 0.01170753, 0.011727161, 0.011747012, 0.011766863, 0.011786837, 0.011806852, 0.011827088, 0.011847325, 0.011867682, 0.01188808, 0.011908622, 0.011929344, 0.011950065, 0.011970869, 0.011991793, 0.012012901, 0.012033988, 0.012055195, 0.012076545, 0.012097915, 0.012119488, 0.012141079, 0.012162793, 0.012184708, 0.012206504, 0.012228542, 0.01225064, 0.012272779, 0.01229514, 0.012317521, 0.012339964, 0.012362549, 0.012385314, 0.012408019, 0.012430908, 0.012453856, 0.012476905, 0.012500158, 0.012523348, 0.012546702, 0.012570135, 0.012593752, 0.012617408, 0.012641105, 0.012664924, 0.012688925, 0.012712965, 0.012737086, 0.01276127, 0.012785675, 0.012810061, 0.012834587, 0.012859174, 0.012883985, 0.012908754, 0.012933644, 0.012958617, 0.012983711, 0.013008965, 0.013034201, 0.013059618, 0.013085096, 0.013110776, 0.013136457, 0.013162176, 0.013188949, 0.0132155, 0.013242172, 0.013269045, 0.013296042, 0.01332324, 0.013350518, 0.01337796, 0.013405602, 0.013433245, 0.013461294, 0.0134893, 0.013517469, 0.013545801, 0.013574456, 0.01360299, 0.013631888, 0.013660745, 0.013689926, 0.013719189, 0.013748612, 0.013778158, 0.013807905, 0.013837774, 0.013867847, 0.013897957, 0.013928273, 0.01395887, 0.013989386, 0.014020227, 0.014051068, 0.014082273, 0.014113477, 0.014144925, 0.014176332, 0.014208145, 0.014239875, 0.01427193, 0.014304066, 0.014336323, 0.014368783, 0.014401404, 0.014434106, 0.014467051, 0.014500199, 0.014533306, 0.014566696, 0.014600127, 0.014633841, 0.014667637, 0.014701593, 0.014735712, 0.014770034, 0.014804354, 0.014838959, 0.014873603, 0.014908492, 0.014943542, 0.014978754, 0.015013966, 0.015049501, 0.015085117, 0.015120936, 0.015156876, 0.015192898, 0.01522912, 0.015265587, 0.015302093, 0.015338762, 0.015375593, 0.015412586, 0.015449699, 0.015486975, 0.015524413, 0.015562012, 0.015599774, 0.015637618, 0.01567574, 0.015713908, 0.015752317, 0.015790807, 0.015829379, 0.015868273, 0.015907208, 0.015946306, 0.015985483, 0.016024904, 0.016064567, 0.016104231, 0.016144017, 0.016184045, 0.016224274, 0.016264627, 0.016305018, 0.016345654, 0.01638633, 0.01642737, 0.016468368, 0.016509652, 0.016551096, 0.016590727, 0.016633386, 0.016676206, 0.016719269, 0.016762454, 0.016805802, 0.016849391, 0.016893143, 0.016937096, 0.01698117, 0.017025366, 0.017069928, 0.017114449, 0.017159212, 0.017204219, 0.017249385, 0.017294755, 0.017340207, 0.017385861, 0.017431719, 0.017477777, 0.017523875, 0.017570378, 0.017616883, 0.017663587, 0.017710496, 0.017757569, 0.017804839, 0.017852275, 0.01789983, 0.01794767, 0.017995548, 0.01804371, 0.018091993, 0.018140562, 0.01818925, 0.018238103, 0.018287076, 0.018336289, 0.018385626, 0.018435126, 0.018484909, 0.018534729, 0.018584797, 0.018635022, 0.018685533, 0.018736044, 0.018786879, 0.018837793, 0.01888895, 0.01894019, 0.018991711, 0.019043436, 0.019095242, 0.019147249, 0.019199381, 0.019251753, 0.019304285, 0.019357024, 0.019409798, 0.019462939, 0.019516122, 0.019569507, 0.019623131, 0.019676922, 0.019730872, 0.019784985, 0.01983922, 0.019893734, 0.019948332, 0.020003174, 0.020058217, 0.020113384, 0.02016875, 0.020224238, 0.020279929, 0.02033578, 0.02039188, 0.020448053, 0.020504516, 0.020561015, 0.02061788, 0.020674745, 0.020731853, 0.020789163, 0.020846592, 0.020904146, 0.020962022, 0.02102006, 0.021078138, 0.021136584, 0.021195026, 0.021253753, 0.021312602, 0.021371569, 0.021430861, 0.021490237, 0.021549731, 0.021609593, 0.02166941, 0.021734698, 0.021795647, 0.021856723, 0.021918042, 0.021979397, 0.022040997, 0.022102758, 0.022164684, 0.022226728, 0.022289056, 0.022351468, 0.02241412, 0.022476811, 0.022539746, 0.022602925, 0.022666104, 0.022729527, 0.022793232, 0.022856936, 0.022920843, 0.022984995, 0.023049265, 0.023113739, 0.023178333, 0.023243049, 0.023308091, 0.023373211, 0.023438456, 0.023503982, 0.023569549, 0.023635397, 0.023701286, 0.023767421, 0.023833755, 0.023900172, 0.02396675, 0.024033573, 0.024100555, 0.0241677, 0.024234965, 0.024302395, 0.024370065, 0.024437858, 0.024505733, 0.024573971, 0.024642207, 0.024710648, 0.02477929, 0.024848135, 0.024917142, 0.02498623, 0.025055477, 0.025125053, 0.025194665, 0.025264401, 0.025334461, 0.025404561, 0.025474945, 0.025545368, 0.025615951, 0.02568686, 0.025757769, 0.025828922, 0.025900235, 0.025971711, 0.02604343, 0.026115309, 0.026187273, 0.026259476, 0.026331762, 0.026404249, 0.026476936, 0.026549747, 0.026622679, 0.026695896, 0.026769195, 0.026842652, 0.026916396, 0.026990177, 0.027064243, 0.027138392, 0.027212698, 0.027287211, 0.027361881, 0.027436677, 0.027511714, 0.027586874, 0.027662234, 0.027737757, 0.027813401, 0.027889289, 0.027965257, 0.028041428, 0.028117841, 0.028194254, 0.028271073, 0.02834785, 0.02842487, 0.028502053, 0.028579397, 0.028653219, 0.028731452, 0.028809769, 0.028888244, 0.028966846, 0.029045686, 0.029124569, 0.029203612, 0.029282698, 0.029362025, 0.029441433, 0.029521003, 0.029600656, 0.029680468, 0.029760484, 0.029840579, 0.029920716, 0.030001136, 0.03008168, 0.030162342, 0.030243045, 0.030323992, 0.030405059, 0.030486248, 0.030567558, 0.030648911, 0.030730544, 0.030812219, 0.030894097, 0.030976133, 0.031058256, 0.031140538, 0.0312229, 0.031305425, 0.031388111, 0.031470921, 0.03155385, 0.031636979, 0.031720154, 0.031803407, 0.031886905, 0.031970561, 0.032054301, 0.032138161, 0.032222304, 0.032306448, 0.032390751, 0.032475222, 0.03255973, 0.032644439, 0.032729313, 0.032814268, 0.032899339, 0.032984614, 0.033069894, 0.033155456, 0.033241056, 0.033326857, 0.033412781, 0.033498786, 0.033584997, 0.033671323, 0.033757858, 0.033844389, 0.033931162, 0.034018017, 0.034105036, 0.034192134, 0.034279473, 0.034366734, 0.034454316, 0.034541942, 0.03462977, 0.034717754, 0.034805786, 0.034894016, 0.034982409, 0.035070889, 0.03515948, 0.035248235, 0.035337158, 0.035426158, 0.035515405, 0.035604727, 0.035694133, 0.035783701, 0.03587335, 0.035963196, 0.036053166, 0.036143262, 0.036233518, 0.036323935, 0.036414474, 0.036505092, 0.036595877, 0.036686819, 0.03677788, 0.036869109, 0.036960378, 0.037051883, 0.037150647, 0.037243452, 0.037336461, 0.037429389, 0.037522554, 0.037615724, 0.037708897, 0.037802264, 0.037895661, 0.037989046, 0.038082521, 0.038176116, 0.038269773, 0.038363464, 0.038457222, 0.0385511, 0.038644917, 0.038738932, 0.038832895, 0.038927015, 0.039021239, 0.039115455, 0.039209779, 0.03930416, 0.039398607, 0.039493091, 0.039587691, 0.039682321, 0.039777033, 0.039871857, 0.039966684, 0.040061556, 0.040156543, 0.040251575, 0.04034669, 0.040441822, 0.040537111, 0.040632427, 0.040727843, 0.040823277, 0.040918816, 0.041014411, 0.04111011, 0.04120579, 0.041301593, 0.041397449, 0.041493349, 0.041589335, 0.041685335, 0.0417815, 0.041877661, 0.041973948, 0.042070296, 0.042166661, 0.042263109, 0.042359676, 0.042456266, 0.042552918, 0.042649727, 0.042746481, 0.042843372, 0.04294024, 0.043037299, 0.043134332, 0.043231446, 0.04332858, 0.043425918, 0.043523256, 0.043620653, 0.043718137, 0.043815695, 0.043913316, 0.044010956, 0.044108722, 0.044206567, 0.04430443, 0.044402372, 0.044500399, 0.044598427, 0.044696592, 0.044794764, 0.044893067, 0.044991359, 0.045089833, 0.045188323, 0.045286894, 0.045385461, 0.045484137, 0.045582935, 0.045681808, 0.045780603, 0.045879602, 0.045978639, 0.046077713, 0.046176918, 0.046276014, 0.046375357, 0.046474677, 0.046574097, 0.046673603, 0.046769653, 0.04687031, 0.046970949, 0.047071546, 0.04717204, 0.047272515, 0.047372926, 0.047473323, 0.047573633, 0.04767397, 0.047774177, 0.047874387, 0.047974542, 0.048074633, 0.048174679, 0.048274651, 0.048374601, 0.048474483, 0.048574399, 0.048674136, 0.048773907, 0.048873633, 0.0489733, 0.049072906, 0.049172465, 0.049271971, 0.049371392, 0.049470816, 0.049570195, 0.049669519, 0.049768824, 0.04986804, 0.049967196, 0.050066337, 0.050165411, 0.050264433, 0.050363433, 0.050462324, 0.050561223, 0.050660118, 0.050758876, 0.050857607, 0.050956298, 0.051054955, 0.051153548, 0.051252119, 0.051350594, 0.051449023, 0.051547434, 0.051645778, 0.051744133, 0.051842362, 0.051940568, 0.052038737, 0.052136846, 0.052234888, 0.052332953, 0.052430898, 0.052528784, 0.052626669, 0.052724533, 0.052822318, 0.052920017, 0.053017702, 0.053115323, 0.053212903, 0.053310402, 0.053407904, 0.05350538, 0.053602722, 0.053700078, 0.053797398, 0.053894658, 0.053991832, 0.054088987, 0.05418608, 0.054283094, 0.054380111, 0.054477062, 0.054573976, 0.054670826, 0.054767702, 0.054864448, 0.05496116, 0.055057794, 0.055154424, 0.055250991, 0.05534748, 0.055443961, 0.055540372, 0.05563676, 0.055733066, 0.055829413, 0.055925619, 0.056021798, 0.056117948, 0.056214008, 0.05631005, 0.05640601, 0.056501955, 0.05658818, 0.056683067, 0.056777738, 0.056872223, 0.056966648, 0.057060745, 0.057154741, 0.057248581, 0.057342194, 0.057435669, 0.057528954, 0.057622086, 0.057715114, 0.057807919, 0.057900544, 0.057993107, 0.058085345, 0.058177482, 0.058269411, 0.058361169, 0.058452819, 0.058544248, 0.058635514, 0.058726624, 0.058817584, 0.058908306, 0.058999006, 0.059089482, 0.05917966, 0.059269771, 0.059359662, 0.059449412, 0.059538998, 0.059628423, 0.059717685, 0.059806745, 0.059895683, 0.059984487, 0.06007304, 0.060161438, 0.060249664, 0.06033767, 0.060425583, 0.060513329, 0.060600914, 0.060688253, 0.060775477, 0.060862508, 0.060949467, 0.061036181, 0.061122712, 0.06120906, 0.06129523, 0.061381254, 0.06146716, 0.061552882, 0.061638363, 0.06172372, 0.061808895, 0.061893966, 0.061978821, 0.062063511, 0.062148001, 0.062232304, 0.062316511, 0.062400512, 0.062484309, 0.062567949, 0.062651441, 0.062734738, 0.062817976, 0.06290096, 0.062983789, 0.063066415, 0.063148901, 0.0632312, 0.063313343, 0.063395344, 0.063477099, 0.063558728, 0.063640185, 0.06372153, 0.063802682, 0.063883588, 0.063964434, 0.064045019, 0.064125478, 0.064205736, 0.06428577, 0.06436573, 0.064445496, 0.06452509, 0.064604603, 0.064683862, 0.064762987, 0.064841896, 0.064920612, 0.064999208, 0.065077633, 0.065155804, 0.065239534, 0.065314412, 0.065389045, 0.065463513, 0.065537706, 0.065611728, 0.065685429, 0.065758966, 0.065832347, 0.065905437, 0.065978415, 0.066051185, 0.06612359, 0.066195913, 0.066268116, 0.06633988, 0.066411518, 0.066483028, 0.066554226, 0.066625215, 0.06669604, 0.066766627, 0.06683705, 0.06690719, 0.066977173, 0.067046903, 0.067116432, 0.067185812, 0.067254856, 0.067323782, 0.067392461, 0.067460939, 0.067529224, 0.067597218, 0.067665011, 0.067732677, 0.067800149, 0.067867368, 0.067934401, 0.068001136, 0.068067715, 0.068134055, 0.068200223, 0.068266071, 0.068331756, 0.068397291, 0.068462573, 0.068527773, 0.068592653, 0.068657286, 0.068721637, 0.068785869, 0.068849899, 0.068913721, 0.068977311, 0.069040686, 0.069103867, 0.069166847, 0.069229692, 0.069292188, 0.069354475, 0.069416568, 0.069478482, 0.069540165, 0.069601648, 0.069662929, 0.069723956, 0.069784783, 0.069845378, 0.069905885, 0.069966063, 0.07002604, 0.070085824, 0.070145406, 0.070204727, 0.070263863, 0.070322797, 0.070381433, 0.070439972, 0.070498288, 0.070556439, 0.070614286, 0.070671961, 0.07072939, 0.070786655, 0.070843637, 0.070900381, 0.070957005, 0.071013391, 0.071069479, 0.0711255, 0.071181349, 0.071236879, 0.071292214, 0.071347326, 0.071402133, 0.071456775, 0.071511291, 0.071565554, 0.071619593, 0.071673274, 0.071722195, 0.071771048, 0.07181979, 0.071868353, 0.071916908, 0.071965344, 0.072013691, 0.072061956, 0.072110094, 0.072158173, 0.072206125, 0.072253913, 0.072301671, 0.07234931, 0.072396904, 0.072444342, 0.072491713, 0.072539002, 0.072586164, 0.072633252, 0.072680235, 0.072727002, 0.072773777, 0.072820477, 0.072867058, 0.072913527, 0.0729599, 0.073006161, 0.073052391, 0.073098384, 0.073144376, 0.07319025, 0.073236078, 0.073281765, 0.07332737, 0.073372863, 0.07341826, 0.073463544, 0.073508762, 0.073553801, 0.073598824, 0.073643714, 0.073688507, 0.07373324, 0.073777862, 0.073822357, 0.073866785, 0.073910974, 0.073955216, 0.073999368, 0.074043348, 0.07408727, 0.074131109, 0.074174844, 0.074218474, 0.074262008, 0.074305378, 0.074348703, 0.074391954, 0.0744351, 0.074478112, 0.074521042, 0.074563913, 0.074606657, 0.074649274, 0.07469178, 0.074734204, 0.07477656, 0.07481879, 0.07486099, 0.074903026, 0.074944988, 0.074986815, 0.075028501, 0.075070202, 0.075111762, 0.075153209, 0.07519459, 0.075235851, 0.075277016, 0.075318083, 0.075359069, 0.075399935, 0.07544063, 0.07548134, 0.075521886, 0.075562403, 0.075602785, 0.075643063, 0.075683229, 0.075723335, 0.075763263, 0.075803153, 0.075842924, 0.075882643, 0.075922213, 0.075961754, 0.076001123, 0.076040424, 0.076076485, 0.076112799, 0.07614927, 0.076185904, 0.07622271, 0.076259837, 0.076296978, 0.076334268, 0.076371737, 0.076409444, 0.076447316, 0.076485366, 0.076523572, 0.076562025, 0.076600485, 0.076639265, 0.076678209, 0.076717243, 0.076756522, 0.076795891, 0.076835498, 0.076875269, 0.076915219, 0.076955318, 0.076995589, 0.077036023, 0.077076696, 0.077117391, 0.077158473, 0.077199571, 0.077240832, 0.077282421, 0.077324018, 0.077365942, 0.077407941, 0.077450112, 0.077492438, 0.077534944, 0.077577688, 0.077620596, 0.0776636, 0.077706918, 0.077750236, 0.077793725, 0.077837549, 0.077881448, 0.077925436, 0.077969819, 0.078014225, 0.078058779, 0.07810358, 0.078148566, 0.07819362, 0.078239009, 0.078284398, 0.078330107, 0.078375898, 0.078421876, 0.078468084, 0.078514308, 0.078560844, 0.078607552, 0.078654341, 0.078701295, 0.078748666, 0.078795947, 0.078843556, 0.078891262, 0.07893911, 0.078987144, 0.079035334, 0.079083689, 0.079132378, 0.079181068, 0.079230003, 0.079279102, 0.079328373, 0.0793778, 0.079427473, 0.079477161, 0.079527162, 0.079577342, 0.079627596, 0.079678096, 0.079728693, 0.079779521, 0.079830512, 0.079881683, 0.07993301, 0.079984508, 0.080036245, 0.080088057, 0.080140144, 0.08019229, 0.080244616, 0.080297261, 0.0803499, 0.080402888, 0.080455944, 0.080509163, 0.080560945, 0.080618337, 0.080676213, 0.080734663, 0.080793343, 0.080852434, 0.080912091, 0.08097215, 0.081032529, 0.08109349, 0.081154764, 0.081216618, 0.081278861, 0.081341431, 0.081404485, 0.081468195, 0.081532054, 0.08159633, 0.081661172, 0.081726409, 0.081792139, 0.081858188, 0.081924811, 0.081991836, 0.0820591, 0.08212693, 0.082195334, 0.082263969, 0.082333103, 0.082402632, 0.082472734, 0.082543239, 0.082614064, 0.082685217, 0.082757182, 0.082829297, 0.082901828, 0.082974851, 0.083048426, 0.083122328, 0.083196558, 0.083271429, 0.083346628, 0.083422154, 0.083498158, 0.083574735, 0.08365164, 0.083729014, 0.083806641, 0.083885081, 0.083963677, 0.084042691, 0.084122173, 0.08420223, 0.084282607, 0.084363475, 0.084444828, 0.084526502, 0.084608659, 0.084691145, 0.084774196, 0.084857658, 0.084941357, 0.085025698, 0.085110448, 0.085195608, 0.085281245, 0.085367128, 0.085453659, 0.085540593, 0.085627846, 0.085715599, 0.085803911, 0.085892461, 0.085981429, 0.086070947, 0.086160891, 0.086251386, 0.086342044, 0.08643318, 0.08652506, 0.086617008, 0.086709619, 0.08680246, 0.086895965, 0.086989686, 0.087083824, 0.087178543, 0.08727365, 0.087369166, 0.087465174, 0.087561741, 0.087658465, 0.08775568, 0.08785338, 0.087951578, 0.088050246, 0.088149242, 0.088248566, 0.088348612, 0.08844924, 0.088557392, 0.088666096, 0.088775218, 0.088884659, 0.088994734, 0.089105316, 0.089216299, 0.089327835, 0.089439705, 0.089552216, 0.089665055, 0.089778379, 0.089892194, 0.090006657, 0.090121351, 0.090236619, 0.090352379, 0.090468608, 0.090585254, 0.090702392, 0.090820245, 0.090938345, 0.091056921, 0.091175921, 0.091295481, 0.091415361, 0.091535814, 0.091656663, 0.091778249, 0.091900073, 0.092022382, 0.092145175, 0.092268616, 0.092392385, 0.092516631, 0.092641294, 0.092766598, 0.09289223, 0.093018264, 0.093144938, 0.093272105, 0.093399599, 0.09352766, 0.093656279, 0.09378539, 0.093914732, 0.094044656, 0.09417522, 0.094306119, 0.094437413, 0.094569199, 0.094701625, 0.09483429, 0.094967529, 0.095101252, 0.095235623, 0.095370233, 0.095505252, 0.09564092, 0.095776998, 0.095913552, 0.09605059, 0.096188031, 0.096326217, 0.096464545, 0.096603453, 0.096743003, 0.09688288, 0.097023249, 0.097164012, 0.097305417, 0.097447075, 0.097589299, 0.097732008, 0.097875282, 0.098018959, 0.098163128, 0.098307699, 0.098452836, 0.098598294, 0.098744243, 0.098890759, 0.099037915, 0.099185236, 0.099333122, 0.099481657, 0.09963052, 0.099779792, 0.099929623, 0.10008018, 0.10023082, 0.10038203, 0.10053372, 0.10068598, 0.10083865, 0.1009918, 0.10114535, 0.10129947, 0.10145392, 0.10161553, 0.1017754, 0.10193554, 0.10209586, 0.10225662, 0.10241758, 0.10257874, 0.10274024, 0.10290209, 0.10306419, 0.10322645, 0.10338911, 0.10355197, 0.10371523, 0.10387874, 0.10404249, 0.10420641, 0.10437074, 0.10453522, 0.10470011, 0.10486507, 0.10503048, 0.10519615, 0.105362, 0.10552827, 0.1056947, 0.10586145, 0.10602836, 0.10619567, 0.10636319, 0.10653107, 0.10669916, 0.10686752, 0.1070363, 0.10720512, 0.10737453, 0.10754399, 0.10771378, 0.10788377, 0.10805404, 0.10822463, 0.10839559, 0.10856663, 0.10873808, 0.1089098, 0.10908169, 0.10925391, 0.10942636, 0.10959923, 0.10977229, 0.1099456, 0.11011919, 0.11029309, 0.11046721, 0.11064173, 0.11081641, 0.11099134, 0.11116663, 0.11134236, 0.11151821, 0.11169419, 0.11187056, 0.11204713, 0.11222407, 0.11240126, 0.11257878, 0.11275645, 0.11293437, 0.11311278, 0.11329131, 0.11347011, 0.11364917, 0.11382858, 0.11400829, 0.11418814, 0.11436842, 0.11454888, 0.1147296, 0.11491068, 0.11509199, 0.11527357, 0.11545544, 0.11563757, 0.11582003, 0.11600272, 0.11618558, 0.11636885, 0.11655247, 0.11673614, 0.11692021, 0.11710457, 0.1172892, 0.11747404, 0.11765917, 0.11784466, 0.1180304, 0.11821619, 0.11840258, 0.11858904, 0.11877582, 0.1189656, 0.11915143, 0.11933726, 0.11952311, 0.1197089, 0.11989481, 0.12008063, 0.12026649, 0.12045241, 0.1206383, 0.12082421, 0.12101007, 0.12119605, 0.12138197, 0.1215679, 0.12175388, 0.12193988, 0.12212584, 0.12231177, 0.12249787, 0.12268385, 0.12286985, 0.12305589, 0.12324195, 0.12342802, 0.12361408, 0.12380009, 0.12398622, 0.12417229, 0.1243584, 0.12454454, 0.12473071, 0.12491681, 0.12510298, 0.12528916, 0.12547533, 0.12566148, 0.12584768, 0.12603395, 0.12622009, 0.1264063, 0.12659256, 0.12677886, 0.12696508, 0.12715133, 0.12733766, 0.12752387, 0.12771022, 0.12789656, 0.12808289, 0.1282692, 0.12845556, 0.12864189, 0.1288283, 0.12901464, 0.12920105, 0.12938747, 0.12957381, 0.12976025, 0.12994669, 0.13013317, 0.13031957, 0.13050605, 0.1306925, 0.13087904, 0.13106552, 0.13125202, 0.13143857, 0.131625, 0.1318116, 0.13199814, 0.13218474, 0.13237123, 0.13255784, 0.13274446, 0.13293099, 0.13311768, 0.13330425, 0.13349093, 0.13367754, 0.13386421, 0.13405089, 0.1342376, 0.13442424, 0.13461094, 0.13479763, 0.13498434, 0.13517112, 0.13535783, 0.1355446, 0.13573134, 0.13591817, 0.13610491, 0.13629168, 0.13647853, 0.13666533, 0.13685217, 0.13703898, 0.13722584, 0.13741273, 0.13759688, 0.13777968, 0.13796242, 0.13814498, 0.13832738, 0.13850962, 0.13869174, 0.1388737, 0.13905549, 0.13923714, 0.13941865, 0.13959999, 0.13978121, 0.13996226, 0.14014314, 0.14032388, 0.14050448, 0.14068493, 0.14086525, 0.14104536, 0.14122538, 0.14140524, 0.1415849, 0.14176446, 0.14194387, 0.14212313, 0.14230217, 0.14248115, 0.14265998, 0.14283863, 0.14301708, 0.14319544, 0.14337362, 0.14355165, 0.14372955, 0.14390731, 0.1440849, 0.14426231, 0.14443961, 0.14461674, 0.14479373, 0.14497055, 0.14514728, 0.1453238, 0.14550015, 0.14567642, 0.14585248, 0.14602846, 0.14620419, 0.14637986, 0.14655536, 0.14673065, 0.14690584, 0.14708087, 0.14725576, 0.14743046, 0.14760503, 0.14777949, 0.14795379, 0.1481279, 0.1483019, 0.14847569, 0.14864936, 0.14882289, 0.14899628, 0.14916952, 0.14934255, 0.14951546, 0.14968827, 0.14986086, 0.15003334, 0.15020567, 0.15037787, 0.15054984, 0.15072174, 0.15089345, 0.15106502, 0.15123646, 0.1514077, 0.15157884, 0.1517498, 0.1519206, 0.15209126, 0.15226179, 0.15243213, 0.15260236, 0.15277244, 0.15294231, 0.1531121, 0.1532817, 0.15345119, 0.15362047, 0.15378964, 0.15395863, 0.15412752, 0.1542962, 0.15446475, 0.15463321, 0.1548014, 0.15496953, 0.15513511, 0.15530135, 0.15546733, 0.15563315, 0.15579879, 0.15596418, 0.15612936, 0.15629435, 0.15645912, 0.15662371, 0.15678811, 0.15695231, 0.15711625, 0.15728001, 0.15744358, 0.15760696, 0.1577701, 0.15793307, 0.15809581, 0.15825836, 0.15842068, 0.15858282, 0.15874481, 0.15890652, 0.15906803, 0.15922938, 0.15939051, 0.15955141, 0.15971214, 0.15987267, 0.16003294, 0.16019306, 0.16035296, 0.16051267, 0.16067211, 0.16083142, 0.16099049, 0.16114935, 0.16130807, 0.16146649, 0.16162479, 0.16178288, 0.16194075, 0.16209836, 0.16225584, 0.16241311, 0.16257012, 0.16272698, 0.16288364, 0.16304006, 0.16319628, 0.16335231, 0.16350812, 0.16366374, 0.16381915, 0.16397434, 0.16412938, 0.16428417, 0.16443881, 0.16459318, 0.16474737, 0.16490135, 0.16505514, 0.16520871, 0.16536209, 0.16551526, 0.16566823, 0.165821, 0.16597354, 0.16612592, 0.16627806, 0.16643006, 0.16658181, 0.16673332, 0.16688465, 0.1670358, 0.16718674, 0.16733745, 0.16748796, 0.16763827, 0.16778842, 0.16793832, 0.16808802, 0.16823754, 0.16838683, 0.16853596, 0.1686848, 0.16883351, 0.16898201, 0.16913031, 0.16927837, 0.16942626, 0.16957389, 0.16972138, 0.16986863, 0.17001568, 0.17016256, 0.1703092, 0.17045566, 0.17060187, 0.17075023, 0.17089629, 0.17104213, 0.17118774, 0.17133309, 0.17147824, 0.17162314, 0.1717678, 0.17191225, 0.17205648, 0.17220049, 0.17234419, 0.17248774, 0.17263103, 0.17277411, 0.17291687, 0.17305952, 0.17320183, 0.17334403, 0.17348588, 0.17362756, 0.17376897, 0.17391022, 0.17405115, 0.17419191, 0.17433241, 0.17447267, 0.17461275, 0.17475256, 0.17489208, 0.17503148, 0.17517056, 0.17530948, 0.1754481, 0.17558657, 0.17572477, 0.1758627, 0.17600045, 0.17613795, 0.17627522, 0.17641225, 0.17654909, 0.17668563, 0.17682198, 0.1769581, 0.177094, 0.17722963, 0.17736503, 0.1775002, 0.17763515, 0.1777699, 0.17790438, 0.17803863, 0.17817266, 0.17830642, 0.17843999, 0.17857333, 0.17870644, 0.17883931, 0.17897199, 0.17910434, 0.17923655, 0.17936847, 0.17950022, 0.17963168, 0.17976296, 0.17989393, 0.1800247, 0.18015528, 0.1802856, 0.1804157, 0.18054555, 0.18067519, 0.18080458, 0.18093377, 0.1810627, 0.18119134, 0.18131989, 0.18144809, 0.18157609, 0.18170387, 0.18183139, 0.18195872, 0.18208581, 0.18221267, 0.18233924, 0.18246564, 0.18259183, 0.18271777, 0.18284345, 0.18296893, 0.18309414, 0.18321915, 0.18334393, 0.18346843, 0.18359271, 0.18371679, 0.18384068, 0.18396424, 0.18408763, 0.18420954, 0.18433201, 0.18445423, 0.18457617, 0.18469787, 0.18481933, 0.18494052, 0.18506144, 0.18518214, 0.18530251, 0.18542272, 0.18554258, 0.1856623, 0.18578164, 0.18590078, 0.18601969, 0.18613832, 0.18625671, 0.1863748, 0.18649268, 0.18661031, 0.18672766, 0.18684478, 0.18696158, 0.18707819, 0.18719447, 0.18731061, 0.18742637, 0.18754192, 0.18765722, 0.18777227, 0.18788706, 0.18800162, 0.18811588, 0.18822989, 0.18834367, 0.18845719, 0.1885705, 0.18868349, 0.18879622, 0.18890873, 0.18902093, 0.1891329, 0.18924463, 0.18935609, 0.18946731, 0.18957828, 0.18968898, 0.18979941, 0.18990961, 0.19001955, 0.19012922, 0.19023865, 0.19034779, 0.19045672, 0.19056538, 0.19067374, 0.19078194, 0.19088978, 0.19099744, 0.1911048, 0.19121189, 0.19131875, 0.19142535, 0.19153172, 0.19163783, 0.19174364, 0.19184922, 0.19195457, 0.19205962, 0.19216441, 0.192269, 0.19237328, 0.19247739, 0.19258113, 0.19268468, 0.19278798, 0.19289097, 0.19299373, 0.19309627, 0.19319852, 0.19330053, 0.19340226, 0.19350377, 0.19360498, 0.19370598, 0.19380668, 0.19390719, 0.19400735, 0.19410729, 0.194207, 0.19430646, 0.19440562, 0.19450459, 0.19460326, 0.19470167, 0.19479986, 0.19489777, 0.1949954, 0.19509278, 0.19518231, 0.19527718, 0.19537182, 0.19546624, 0.19556041, 0.19565433, 0.19574811, 0.19584155, 0.19593483, 0.19602789, 0.19612065, 0.19621322, 0.19630556, 0.19639768, 0.19648953, 0.19658118, 0.19667259, 0.19676375, 0.19685471, 0.19694544, 0.19703591, 0.19712614, 0.19721618, 0.19730598, 0.19739559, 0.19748487, 0.19757394, 0.19766286, 0.19775148, 0.1978399, 0.19792806, 0.198016, 0.19810374, 0.1981912, 0.19827846, 0.19836549, 0.19845226, 0.19853884, 0.19862515, 0.19871122, 0.19879711, 0.19888274, 0.19896814, 0.19905332, 0.19913822, 0.199223, 0.19930743, 0.19939171, 0.19947574, 0.19955952, 0.19964306, 0.1997264, 0.19980948, 0.19989233, 0.19997495, 0.20005737, 0.20013952, 0.20022148, 0.20030317, 0.20038465, 0.2004659, 0.20054692, 0.20062771, 0.20070827, 0.20078856, 0.20086868, 0.20094855, 0.20102815, 0.20110755, 0.20118672, 0.20126565, 0.20134436, 0.20142284, 0.20150106, 0.20157908, 0.20165686, 0.20173439, 0.20181169, 0.20188878, 0.20196566, 0.2020423, 0.20211865, 0.20219481, 0.20227079, 0.2023465, 0.20242195, 0.2024972, 0.20257221, 0.20264697, 0.20272149, 0.20279582, 0.20286992, 0.20294374, 0.20301738, 0.20309074, 0.20316392, 0.20323683, 0.20330954, 0.20338202, 0.20345424, 0.20352815, 0.20359734, 0.20366637, 0.20373531, 0.20380414, 0.20387286, 0.20394148, 0.20400999, 0.20407838, 0.20414662, 0.20421478, 0.20428284, 0.2043508, 0.20441861, 0.20448634, 0.20455393, 0.20462146, 0.20468883, 0.20475613, 0.20482329, 0.20489033, 0.20495729, 0.20502411, 0.20509082, 0.20515743, 0.20522395, 0.20529033, 0.20535663, 0.20542277, 0.20548885, 0.20555477, 0.20562062, 0.20568632, 0.20575191, 0.20581745, 0.20588285, 0.20594811, 0.20601329, 0.20607835, 0.20614327, 0.20620812, 0.20627284, 0.20633747, 0.20640197, 0.20646636, 0.20653065, 0.20659481, 0.20665887, 0.20672281, 0.20678666, 0.20685041, 0.20691399, 0.20697752, 0.20704092, 0.20710418, 0.20716734, 0.20723042, 0.20729335, 0.20735618, 0.20741895, 0.20748153, 0.20754404, 0.20760646, 0.20766874, 0.2077309, 0.20779297, 0.2078549, 0.20791674, 0.2079785, 0.2080401, 0.20810163, 0.20816301, 0.20822428, 0.20828547, 0.20834652, 0.20840748, 0.2084683, 0.20852907, 0.20858966, 0.20865019, 0.2087106, 0.20877086, 0.20883104, 0.20889111, 0.20895104, 0.2090109, 0.20907064, 0.20913024, 0.20918979, 0.20924915, 0.20930845, 0.2093676, 0.20942669, 0.20948565, 0.20954451, 0.20960325, 0.20966184, 0.20972036, 0.20977874, 0.20983703, 0.20989965, 0.20995745, 0.21001531, 0.21007326, 0.21013127, 0.21018939, 0.21024755, 0.2103058, 0.2103641, 0.21042249, 0.21048096, 0.21053948, 0.21059808, 0.21065673, 0.2107155, 0.21077432, 0.21083321, 0.21089219, 0.21095124, 0.21101034, 0.21106952, 0.21112876, 0.21118811, 0.21124747, 0.21130696, 0.2113665, 0.21142614, 0.21148583, 0.21154562, 0.21160544, 0.21166535, 0.21172532, 0.21178539, 0.21184552, 0.21190569, 0.21196598, 0.21202633, 0.21208675, 0.21214722, 0.21220781, 0.21226844, 0.21232913, 0.21238993, 0.21245077, 0.21251172, 0.21257269, 0.21263377, 0.21269491, 0.21275613, 0.21281742, 0.21287879, 0.21294023, 0.21300174, 0.21306333, 0.21312496, 0.21318667, 0.21324848, 0.21331035, 0.21337228, 0.21343429, 0.2134964, 0.21355855, 0.2136208, 0.2136831, 0.21374549, 0.21380794, 0.21387045, 0.21393302, 0.2139957, 0.21405844, 0.21412127, 0.21418415, 0.21424712, 0.21431017, 0.21437326, 0.21443644, 0.21449968, 0.21456301, 0.21462639, 0.21468985, 0.2147534, 0.21481702, 0.2148807, 0.21494445, 0.21500829, 0.21507221, 0.21513617, 0.2152002, 0.21526432, 0.21532851, 0.21539278, 0.21545714, 0.21552154, 0.21558602, 0.21565057, 0.21571523, 0.21577992, 0.21584471, 0.21590953, 0.21597445, 0.21604311, 0.21611112, 0.2161793, 0.21624772, 0.21631631, 0.21638514, 0.21645419, 0.21652344, 0.21659289, 0.21666253, 0.21673241, 0.21680248, 0.21687278, 0.21694326, 0.217014, 0.21708488, 0.21715605, 0.21722734, 0.21729894, 0.21737064, 0.21744262, 0.21751477, 0.21758719, 0.21765982, 0.21773256, 0.21780561, 0.21787877, 0.21795227, 0.21802588, 0.21809974, 0.21817374, 0.21824807, 0.21832249, 0.21839722, 0.21847209, 0.21854725, 0.21862251, 0.21869805, 0.2187738, 0.21884972, 0.21892585, 0.21900222, 0.21907884, 0.21915558, 0.21923259, 0.21930978, 0.21938719, 0.21946481, 0.21954264, 0.21962066, 0.21969891, 0.21977733, 0.21985601, 0.2199349, 0.22001398, 0.22009331, 0.22017278, 0.2202525, 0.2203324, 0.22041255, 0.22049288, 0.22057343, 0.22065417, 0.22073513, 0.22081631, 0.22089773, 0.22097929, 0.22106114, 0.22114316, 0.22122537, 0.22130781, 0.22139046, 0.22147329, 0.22155634, 0.2216396, 0.22172308, 0.22180681, 0.22189067, 0.22197482, 0.2220591, 0.22214365, 0.22222836, 0.22231333, 0.22239845, 0.22248383, 0.22256938, 0.22265518, 0.22274117, 0.22282737, 0.22291385, 0.22300042, 0.22308727, 0.2231743, 0.22326155, 0.22334898, 0.22343667, 0.22352453, 0.22361262, 0.22370091, 0.22378945, 0.22388196, 0.22397487, 0.22406799, 0.22416131, 0.22425486, 0.22434859, 0.22444259, 0.22453675, 0.22463112, 0.22472572, 0.22482054, 0.22491553, 0.22501078, 0.22510621, 0.22520187, 0.2252977, 0.22539377, 0.22549005, 0.22558655, 0.22568326, 0.22578019, 0.22587729, 0.22597463, 0.22607218, 0.22616994, 0.22626789, 0.22636609, 0.22646448, 0.22656308, 0.22666191, 0.22676091, 0.22686015, 0.22695957, 0.22705922, 0.2271591, 0.22725917, 0.22735947, 0.22745995, 0.22756065, 0.22766158, 0.2277627, 0.22786404, 0.22796559, 0.22806737, 0.22816931, 0.22827153, 0.2283739, 0.22847649, 0.22857933, 0.22868234, 0.22878556, 0.22888902, 0.22899269, 0.22909656, 0.22920065, 0.22930494, 0.22940941, 0.22951415, 0.22961904, 0.2297242, 0.22982951, 0.22993509, 0.23004083, 0.23014687, 0.23025303, 0.23035944, 0.23046601, 0.23057283, 0.23067987, 0.23078713, 0.23089457, 0.23100223, 0.23111011, 0.23121817, 0.23132649, 0.23143502, 0.23154372, 0.23165262, 0.23176174, 0.23187113, 0.23198068, 0.23209044, 0.23220041, 0.23231059, 0.23242101, 0.23253164, 0.23264249, 0.2327535, 0.23286474, 0.2329762, 0.23308787, 0.23319976, 0.23331185, 0.23342413, 0.23353665, 0.23364936, 0.23376229, 0.23387544, 0.23398881, 0.23410237, 0.23421513, 0.23433171, 0.23444839, 0.23456515, 0.23468198, 0.23479889, 0.23491587, 0.23503292, 0.2351501, 0.2352673, 0.2353846, 0.23550197, 0.23561943, 0.23573697, 0.23585455, 0.23597224, 0.23609, 0.23620786, 0.23632576, 0.23644377, 0.23656183, 0.23667999, 0.2367982, 0.2369165, 0.23703489, 0.23715334, 0.23727189, 0.2373905, 0.23750919, 0.23762794, 0.23774685, 0.23786576, 0.23798476, 0.23810384, 0.23822299, 0.23834223, 0.23846154, 0.23858094, 0.2387004, 0.23881994, 0.23893955, 0.23905928, 0.23917906, 0.23929891, 0.23941885, 0.23953883, 0.23965894, 0.23977911, 0.23989937, 0.24001968, 0.24014008, 0.24026054, 0.24038108, 0.24050175, 0.24062248, 0.24074328, 0.2408641, 0.24098505, 0.24110606, 0.24122718, 0.24134834, 0.24146961, 0.24159093, 0.24171235, 0.24183384, 0.24195541, 0.24207705, 0.24219875, 0.24232055, 0.24244243, 0.24256438, 0.24268641, 0.24280854, 0.24293071, 0.24305294, 0.24317531, 0.24329773, 0.24342023, 0.24354278, 0.24366546, 0.24378817, 0.24391098, 0.24403389, 0.24415682, 0.24427988, 0.24440297, 0.24452616, 0.24464945, 0.24477281, 0.24489623, 0.24501973, 0.24514329, 0.24526697, 0.2453907, 0.24551451, 0.2456384, 0.24576236, 0.24588643, 0.24601056, 0.24613476, 0.24625309, 0.24637681, 0.24650043, 0.24662395, 0.24674734, 0.24687067, 0.24699388, 0.247117, 0.24723999, 0.24736291, 0.2474857, 0.24760841, 0.24773102, 0.24785353, 0.24797593, 0.24809822, 0.24822041, 0.24834253, 0.24846451, 0.2485864, 0.24870822, 0.24882987, 0.24895149, 0.24907298, 0.24919437, 0.24931566, 0.24943686, 0.24955793, 0.24967891, 0.2497998, 0.24992059, 0.25004128, 0.25016186, 0.25028232, 0.25040269, 0.25052297, 0.25064316, 0.25076324, 0.25088322, 0.25100309, 0.25112286, 0.25124252, 0.25136212, 0.25148156, 0.25160095, 0.25172022, 0.25183934, 0.25195843, 0.25207737, 0.25219625, 0.25231501, 0.25243369, 0.25255224, 0.25267071, 0.25278905, 0.25290731, 0.25302547, 0.25314352, 0.25326148, 0.25337932, 0.25349706, 0.25361472, 0.25373226, 0.25384969, 0.25396705, 0.25408429, 0.25420144, 0.25431848, 0.25443542, 0.25455227, 0.25466898, 0.25478566, 0.25490218, 0.25501865, 0.25513494, 0.2552512, 0.25536731, 0.25548333, 0.25559929, 0.2557151, 0.25583082, 0.25594646, 0.25606197, 0.25617743, 0.2562927, 0.25640798, 0.25652307, 0.25663808, 0.256753, 0.25686783, 0.25698254, 0.25709715, 0.25721169, 0.2573261, 0.25744042, 0.25755462, 0.25766873, 0.25778273, 0.25789663, 0.25801045, 0.25812349, 0.25823435, 0.25834504, 0.25845546, 0.25856569, 0.25867569, 0.25878552, 0.2588951, 0.25900444, 0.25911358, 0.25922248, 0.2593312, 0.25943968, 0.25954795, 0.25965598, 0.25976381, 0.25987142, 0.2599788, 0.260086, 0.26019293, 0.26029965, 0.2604062, 0.26051247, 0.26061857, 0.26072443, 0.26083007, 0.26093549, 0.26104069, 0.26114568, 0.26125047, 0.26135501, 0.26145932, 0.26156342, 0.26166734, 0.26177099, 0.26187447, 0.2619777, 0.26208073, 0.26218355, 0.26228613, 0.26238847, 0.2624906, 0.26259255, 0.26269427, 0.26279575, 0.26289701, 0.26299807, 0.2630989, 0.26319954, 0.26329994, 0.26340011, 0.26350006, 0.26359984, 0.26369935, 0.26379865, 0.26389775, 0.2639966, 0.26409528, 0.26419368, 0.26429191, 0.26438987, 0.26448765, 0.26458523, 0.26468259, 0.26477969, 0.2648766, 0.26497328, 0.26506975, 0.26516598, 0.26526201, 0.26535785, 0.26545346, 0.26554883, 0.26564398, 0.2657389, 0.26583362, 0.26592812, 0.26602241, 0.26611647, 0.26621035, 0.26630393, 0.26639733, 0.26649052, 0.26658353, 0.26667625, 0.26676878, 0.26686111, 0.2669532, 0.26704508, 0.26713675, 0.26722819, 0.26731941, 0.26741043, 0.26750121, 0.2675918, 0.26768214, 0.26777226, 0.26786217, 0.26795185, 0.26804137, 0.26813099, 0.26821807, 0.26830494, 0.26839155, 0.26847792, 0.26856402, 0.26864988, 0.2687355, 0.26882085, 0.268906, 0.26899087, 0.26907551, 0.26915991, 0.26924407, 0.26932797, 0.26941162, 0.26949504, 0.26957822, 0.26966113, 0.2697438, 0.26982623, 0.26990843, 0.26999035, 0.27007204, 0.27015349, 0.2702347, 0.27031565, 0.27039635, 0.27047682, 0.27055705, 0.27063704, 0.27071676, 0.27079624, 0.27087548, 0.27095446, 0.27103323, 0.27111173, 0.27118999, 0.27126798, 0.27134576, 0.27142331, 0.27150056, 0.27157757, 0.27165437, 0.27173093, 0.27180719, 0.27188325, 0.27195904, 0.27203462, 0.2721099, 0.272185, 0.2722598, 0.2723344, 0.27240869, 0.27248278, 0.27255663, 0.27263024, 0.27270359, 0.27277669, 0.27284953, 0.27292216, 0.27299452, 0.27306664, 0.27313852, 0.27321014, 0.27328151, 0.27335268, 0.27342355, 0.27349418, 0.27356461, 0.27363476, 0.27370468, 0.27377436, 0.27384377, 0.27391294, 0.27398187, 0.27405056, 0.27411896, 0.27418715, 0.27425513, 0.27432284, 0.27439028, 0.27445748, 0.27452448, 0.27459118, 0.27465764, 0.27472389, 0.27478987, 0.27485561, 0.27492109, 0.27498633, 0.27505136, 0.27511612, 0.27518061, 0.27524489, 0.27530891, 0.27537268, 0.27543619, 0.27549949, 0.27556252, 0.27562606, 0.27568808, 0.2757498, 0.27581134, 0.27587265, 0.27593371, 0.2759946, 0.27605522, 0.27611566, 0.27617583, 0.27623579, 0.27629554, 0.27635509, 0.27641436, 0.27647349, 0.27653232, 0.27659097, 0.27664939, 0.27670759, 0.27676553, 0.27682328, 0.27688083, 0.27693811, 0.27699521, 0.27705207, 0.2771087, 0.27716511, 0.27722132, 0.27727732, 0.27733305, 0.27738857, 0.27744389, 0.27749899, 0.27755386, 0.27760848, 0.2776629, 0.27771708, 0.27777109, 0.27782482, 0.27787834, 0.27793166, 0.27798477, 0.27803764, 0.27809024, 0.27814266, 0.27819487, 0.27824682, 0.27829856, 0.27835011, 0.2784014, 0.27845249, 0.27850339, 0.27855402, 0.27860445, 0.27865461, 0.27870458, 0.27875435, 0.27880394, 0.27885324, 0.27890229, 0.27895117, 0.27899978, 0.27904823, 0.27909642, 0.27914441, 0.27919215, 0.27923968, 0.27928698, 0.27933407, 0.27938095, 0.27942759, 0.27947399, 0.27952018, 0.2795662, 0.27961195, 0.27965748, 0.27970278, 0.27974784, 0.27979276, 0.27983737, 0.27988181, 0.279926, 0.27996999, 0.28001374, 0.28005725, 0.28010058, 0.28014368, 0.28018656, 0.28022921, 0.28027165, 0.28031382, 0.28035581, 0.28039756, 0.28043908, 0.28048038, 0.28052148, 0.28056234, 0.28060299, 0.2806434, 0.28068361, 0.28072327, 0.28076309, 0.28080276, 0.28084216, 0.28088143, 0.28092048, 0.28095937, 0.28099802, 0.28103653, 0.28107485, 0.281113, 0.28115091, 0.28118864, 0.28122622, 0.28126359, 0.28130078, 0.28133783, 0.28137466, 0.28141123, 0.28144771, 0.28148395, 0.28152001, 0.28155589, 0.28159159, 0.28162706, 0.2816624, 0.28169754, 0.2817325, 0.28176722, 0.28180179, 0.28183618, 0.28187037, 0.28190437, 0.28193823, 0.28197184, 0.28200531, 0.28203854, 0.28207165, 0.28210452, 0.28213722, 0.28216973, 0.28220206, 0.28223419, 0.28226617, 0.28229791, 0.28232947, 0.28236088, 0.28239205, 0.28242311, 0.28245389, 0.28248453, 0.28251502, 0.2825453, 0.28257537, 0.28260526, 0.28263497, 0.28266448, 0.2826938, 0.28272295, 0.28275189, 0.28278065, 0.28280923, 0.2828376, 0.28286585, 0.28289384, 0.2829217, 0.28294936, 0.28297678, 0.28300408, 0.28303114, 0.28305808, 0.28308478, 0.28311127, 0.28313762, 0.28316376, 0.28318977, 0.28321552, 0.28324112, 0.28326654, 0.28329173, 0.28331676, 0.28334159, 0.28336623, 0.2833907, 0.28341499, 0.28343907, 0.28346297, 0.28348669, 0.28351024, 0.28353354, 0.2835567, 0.28357968, 0.28360248, 0.28362507, 0.28364748, 0.28366971, 0.28369173, 0.28371355, 0.28373528, 0.2837567, 0.28377718, 0.28379777, 0.2838183, 0.28383866, 0.28385884, 0.28387889, 0.28389883, 0.28391865, 0.28393829, 0.28395778, 0.28397712, 0.28399634, 0.28401542, 0.28403431, 0.28405312, 0.28407174, 0.28409025, 0.28410861, 0.28412682, 0.28414491, 0.28416285, 0.28418064, 0.28419825, 0.28421578, 0.28423318, 0.28425038, 0.28426743, 0.28428438, 0.28430116, 0.28431782, 0.28433433, 0.28435069, 0.28436691, 0.284383, 0.28439894, 0.28441477, 0.28443041, 0.28444591, 0.28446126, 0.28447649, 0.2844916, 0.2845065, 0.28452134, 0.28453597, 0.28455052, 0.28456485, 0.28457913, 0.28459319, 0.28460714, 0.28462097, 0.28463465, 0.28464815, 0.2846615, 0.28467473, 0.28468785, 0.28470078, 0.2847136, 0.28472626, 0.28473872, 0.28475115, 0.28476343, 0.2847755, 0.28478745, 0.28479928, 0.2848109, 0.28482243, 0.28483385, 0.28484508, 0.28485617, 0.28486711, 0.28487796, 0.2848886, 0.28489915, 0.28490958, 0.28491977, 0.2849299, 0.28493986, 0.28494966, 0.28495935, 0.28496888, 0.28497827, 0.28498751, 0.28499663, 0.2850056, 0.28501439, 0.28502306, 0.28503162, 0.28503999, 0.28504825, 0.28505638, 0.28506437, 0.28507218, 0.28507987, 0.28508741, 0.2850948, 0.28510204, 0.28510916, 0.28511614, 0.28512296, 0.28512964, 0.28513533, 0.28514093, 0.28514647, 0.28515193, 0.28515729, 0.28516266, 0.28516784, 0.28517306, 0.28517815, 0.28518319, 0.2851882, 0.28519309, 0.28519788, 0.28520265, 0.28520733, 0.28521195, 0.28521651, 0.28522098, 0.28522539, 0.28522974, 0.285234, 0.28523824, 0.28524235, 0.2852464, 0.2852504, 0.28525433, 0.28525814, 0.28526193, 0.28526568, 0.28526929, 0.28527287, 0.28527638, 0.28527981, 0.28528315, 0.28528646, 0.28528965, 0.2852928, 0.2852959, 0.28529891, 0.28530186, 0.2853047, 0.28530753, 0.28531024, 0.28531292, 0.28531551, 0.28531802, 0.28532046, 0.28532284, 0.28532517, 0.28532743, 0.28532958, 0.2853317, 0.28533375, 0.28533572, 0.2853376, 0.28533942, 0.28534117, 0.28534284, 0.28534445, 0.285346, 0.28534746, 0.28534889, 0.28535023, 0.28535149, 0.28535268, 0.28535381, 0.28535485, 0.28535587, 0.28535679, 0.28535762, 0.28535837, 0.28535908, 0.28535974, 0.28536031, 0.28536081, 0.28536123, 0.28536159, 0.28536186, 0.28536206, 0.28536221, 0.28536233, 0.28536233, 0.28536224, 0.28536212, 0.28536189, 0.28536165, 0.28536129, 0.28536087, 0.2853604, 0.28535986, 0.2853592, 0.28535855, 0.28535777, 0.28535694, 0.28535604, 0.28535506, 0.28535399, 0.28535292, 0.28535172, 0.28535047, 0.28534958, 0.28534839, 0.28534719, 0.285346, 0.28534484, 0.28534371, 0.28534257, 0.28534147, 0.28534037, 0.28533936, 0.28533825, 0.28533724, 0.28533623, 0.28533521, 0.28533426, 0.28533328, 0.28533235, 0.28533143, 0.2853305, 0.28532961, 0.28532878, 0.28532794, 0.28532708, 0.28532627, 0.2853255, 0.28532469, 0.28532395, 0.2853232, 0.28532249, 0.2853218, 0.28532112, 0.28532043, 0.28531981, 0.28531915, 0.28531855, 0.28531796, 0.28531739, 0.28531685, 0.28531632, 0.28531578, 0.28531528, 0.2853148, 0.28531432, 0.2853139, 0.28531349, 0.28531307, 0.28531268, 0.28531229, 0.28531197, 0.28531164, 0.28531128, 0.28531104, 0.28531072, 0.28531048, 0.28531024, 0.28530997, 0.28530979, 0.28530958, 0.28530943, 0.28530928, 0.28530914, 0.28530905, 0.28530896, 0.28530884, 0.28530878, 0.28530875, 0.28530872, 0.28530875, 0.28530875, 0.28530878, 0.28530884, 0.28530893, 0.28530902, 0.28530911, 0.28530926, 0.28530937, 0.28530952, 0.2853097, 0.28530991, 0.28531015, 0.28531036, 0.28531063, 0.28531089, 0.28531116, 0.28531149, 0.28531182, 0.28531215, 0.28531256, 0.28531295, 0.28531334, 0.28531373, 0.2853142, 0.28531465, 0.28531513, 0.28531557, 0.28531611, 0.28531665, 0.28531718, 0.28531778, 0.28531834, 0.28532025, 0.28532222, 0.28532428, 0.28532642, 0.28532866, 0.28533092, 0.28533331, 0.28533578, 0.28533828, 0.28534093, 0.28534362, 0.28534639, 0.28534922, 0.28535214, 0.28535515, 0.28535825, 0.28536141, 0.28536466, 0.285368, 0.28537136, 0.28537485, 0.28537843, 0.28538206, 0.28538579, 0.28538957, 0.28539345, 0.28539741, 0.28540146, 0.28540555, 0.28540972, 0.28541401, 0.28541836, 0.28542277, 0.28542727, 0.28543189, 0.28543654, 0.28544128, 0.28544608, 0.28545102, 0.28545597, 0.28546107, 0.28546619, 0.28547138, 0.28547668, 0.28548205, 0.2854875, 0.28549305, 0.28549865, 0.28550437, 0.28551012, 0.28551596, 0.28552186, 0.28552788, 0.28553396, 0.28554013, 0.28554636, 0.28555268, 0.28555909, 0.28556556, 0.28557214, 0.28557876, 0.28558549, 0.28559229, 0.28559917, 0.28560609, 0.28561315, 0.28562024, 0.28562742, 0.2856347, 0.28564203, 0.28564945, 0.28565696, 0.28566453, 0.28567219, 0.28567997, 0.28568774, 0.28569567, 0.28570366, 0.28571171, 0.28571981, 0.28572801, 0.28573632, 0.2857447, 0.28575316, 0.28576168, 0.28577033, 0.28577897, 0.28578776, 0.28579658, 0.28580549, 0.28581449, 0.28582358, 0.28583276, 0.28584197, 0.28585133, 0.28586069, 0.28587016, 0.28587973, 0.28588933, 0.28589907, 0.28591019, 0.28592253, 0.28593493, 0.28594735, 0.2859599, 0.28597248, 0.28598511, 0.28599781, 0.28601059, 0.28602341, 0.28603634, 0.28604928, 0.28606236, 0.28607541, 0.28608856, 0.28610182, 0.28611508, 0.28612843, 0.28614181, 0.28615528, 0.28616884, 0.28618249, 0.28619611, 0.28620985, 0.28622365, 0.28623751, 0.28625143, 0.28626543, 0.28627944, 0.28629357, 0.28630775, 0.286322, 0.28633627, 0.28635067, 0.28636512, 0.28637961, 0.28639418, 0.28640875, 0.28642347, 0.28643823, 0.28645304, 0.28646794, 0.2864829, 0.28649786, 0.28651294, 0.28652811, 0.28654328, 0.28655854, 0.28657392, 0.28658929, 0.28660473, 0.28662026, 0.28663585, 0.28665146, 0.2866672, 0.28668296, 0.28669882, 0.2867147, 0.28673068, 0.28674668, 0.2867628, 0.28677893, 0.28679517, 0.28681147, 0.28682783, 0.28684422, 0.28686073, 0.28687721, 0.28689387, 0.2869105, 0.28692725, 0.28694403, 0.2869609, 0.28697783, 0.28699481, 0.28701186, 0.28702897, 0.28704613, 0.28706342, 0.28708073, 0.28709808, 0.28711551, 0.28713301, 0.28715056, 0.2871682, 0.28718588, 0.28720364, 0.28722146, 0.28723934, 0.28725731, 0.28727531, 0.2872934, 0.28731149, 0.2873297, 0.287348, 0.28736633, 0.28738472, 0.2874032, 0.2874217, 0.28744027, 0.28745946, 0.28747937, 0.28749925, 0.28751913, 0.28753898, 0.28755876, 0.28757858, 0.28759831, 0.28761804, 0.28763771, 0.28765738, 0.28767705, 0.28769666, 0.28771627, 0.28773585, 0.2877554, 0.28777489, 0.28779441, 0.28781387, 0.2878333, 0.2878527, 0.28787211, 0.28789145, 0.28791079, 0.28793007, 0.28794935, 0.28796861, 0.28798783, 0.28800705, 0.28802624, 0.28804538, 0.28806451, 0.28808361, 0.28810269, 0.2881217, 0.28814074, 0.28815973, 0.28817865, 0.28819761, 0.2882165, 0.28823543, 0.28825423, 0.28827313, 0.2882919, 0.28831068, 0.28832942, 0.28834817, 0.28836685, 0.28838554, 0.28840417, 0.28842282, 0.28844139, 0.28845999, 0.28847846, 0.28849703, 0.28851551, 0.28853399, 0.2885524, 0.28857082, 0.28858921, 0.2886076, 0.28862587, 0.28864422, 0.28866249, 0.28868073, 0.28869894, 0.28871715, 0.2887353, 0.28875348, 0.28877163, 0.28878972, 0.28880775, 0.28882581, 0.28884384, 0.28886178, 0.28887975, 0.28889769, 0.28891557, 0.28893349, 0.28895137, 0.28896919, 0.28898701, 0.28900477, 0.28902251, 0.28904024, 0.28905797, 0.28907558, 0.28909329, 0.2891109, 0.28912845, 0.28914604, 0.28916359, 0.28918108, 0.28919858, 0.28921607, 0.28923348, 0.28925091, 0.28926829, 0.28928563, 0.28930295, 0.2893194, 0.28933513, 0.28935078, 0.28936628, 0.28938168, 0.28939694, 0.28941211, 0.28942719, 0.28944215, 0.28945699, 0.28947169, 0.28948629, 0.28950074, 0.28951514, 0.28952941, 0.28954357, 0.28955758, 0.28957152, 0.28958532, 0.28959903, 0.28961262, 0.28962609, 0.28963944, 0.28965271, 0.28966585, 0.28967884, 0.28969172, 0.28970453, 0.28971723, 0.2897298, 0.28974226, 0.28975457, 0.28976682,