// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:48:43 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "850" [Number of trees in the forest]
MaxDepth: "3" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.661009007550664);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.873515,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377877,-99) , 
0, 0.829465, 1, 0, 0.687384,-99) , 
3, 1.03138, 0, 0, 0.789641,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350593,-99) , 
1, -0.654311, 1, 0, 0.436816,-99) , 
NN(
0, 
0, 
-1, -2.09196, 1, -1, 0.107634,-99) , 
3, -0.997806, 0, 0, 0.306162,-99) , 
3, 0.254861, 0, 0, 0.523411,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.50924);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.577244, 1, 1, 0.679153,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.111148,-99) , 
0, -1.24543, 1, 0, 0.255644,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.0716449,-99) , 
3, -1.13161, 0, 0, 0.178643,-99) , 
3, -0.38184, 0, 0, 0.493322,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.554886);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.35878, 1, 1, 0.746511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224131,-99) , 
0, 0.365448, 1, 0, 0.478887,-99) , 
3, 0.637533, 0, 0, 0.687014,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337418,-99) , 
0, -1.80266, 1, 0, 0.381777,-99) , 
NN(
0, 
0, 
-1, -2.12486, 1, -1, 0.122723,-99) , 
3, -1.07132, 0, 0, 0.28942,-99) , 
3, 0.240737, 0, 0, 0.468531,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.502015);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.502882, 0, 1, 0.773162,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180426,-99) , 
3, 0.888321, 0, 0, 0.456538,-99) , 
0, 0.611453, 1, 0, 0.572281,-99) , 
NN(
0, 
0, 
-1, -1.75061, 0, -1, 0.263184,-99) , 
3, -0.28269, 0, 0, 0.455259,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.319323);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0638625, 0, 1, 0.808415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417287,-99) , 
3, 1.86068, 0, 0, 0.532126,-99) , 
0, 1.42951, 1, 0, 0.628806,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257312,-99) , 
3, -1.19734, 0, 0, 0.441034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0604983,-99) , 
0, 0.508341, 1, 0, 0.391822,-99) , 
3, 0.569166, 0, 0, 0.476063,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.362784);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.188591, 1, 1, 0.708111,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383562,-99) , 
0, 0.0851782, 1, 0, 0.460703,-99) , 
1, 0.107402, 1, 0, 0.584302,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397602,-99) , 
2, -1.61935, 0, 0, 0.541245,-99) , 
NN(
0, 
0, 
-1, -1.20954, 0, -1, 0.306659,-99) , 
0, -2.71174, 1, 0, 0.352136,-99) , 
3, -0.28269, 0, 0, 0.50134,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.362708);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.865005, 0, 1, 0.74326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265106,-99) , 
3, 1.29603, 0, 0, 0.490515,-99) , 
0, 1.10667, 1, 0, 0.597574,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307702,-99) , 
1, 0.332735, 1, 0, 0.454408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.109776,-99) , 
2, 0.111886, 1, 0, 0.39559,-99) , 
3, 0.10264, 0, 0, 0.495152,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.252322);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.916924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494453,-99) , 
1, -1.37246, 1, 0, 0.520721,-99) , 
0, -1.24899, 1, 0, 0.540995,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220902,-99) , 
3, -1.55799, 0, 0, 0.387035,-99) , 
NN(
0, 
0, 
-1, -0.964419, 0, -1, 0.164296,-99) , 
0, -1.76249, 1, 0, 0.261322,-99) , 
3, -0.38184, 0, 0, 0.456826,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.317411);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.59614, 1, 1, 0.879463,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460177,-99) , 
3, 1.53543, 0, 0, 0.588653,-99) , 
2, 0.755739, 1, 0, 0.661595,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371665,-99) , 
0, -0.1837, 1, 0, 0.486882,-99) , 
NN(
0, 
0, 
-1, -2.3633, 1, -1, 0.307704,-99) , 
3, -0.852959, 0, 0, 0.441739,-99) , 
3, 1.05097, 0, 0, 0.488464,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.381041);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.386918, 0, 1, 0.635786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0810417,-99) , 
3, 1.55116, 0, 0, 0.416678,-99) , 
0, 2.07144, 1, 0, 0.596953,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309388,-99) , 
3, -1.43494, 0, 0, 0.426011,-99) , 
NN(
0, 
0, 
-1, -0.926716, 0, -1, 0.13172,-99) , 
0, -1.73561, 1, 0, 0.289416,-99) , 
3, -0.673088, 0, 0, 0.513994,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.372989);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.918611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493098,-99) , 
2, 0.852009, 1, 0, 0.767379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26551,-99) , 
3, 1.32987, 0, 0, 0.449576,-99) , 
0, 1.20233, 1, 0, 0.573649,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335247,-99) , 
3, -0.959868, 0, 0, 0.48775,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.135828,-99) , 
0, -0.0327079, 1, 0, 0.408397,-99) , 
3, 0.306962, 0, 0, 0.47668,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.226032);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25034, 0, 1, 0.823077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256398,-99) , 
1, 0.800227, 1, 0, 0.464496,-99) , 
0, 1.48336, 1, 0, 0.590601,-99) , 
NN(
NN(
0, 
0, 
-1, -2.19195, 1, 1, 0.549301,-99) , 
NN(
0, 
0, 
-1, -0.559879, 0, -1, 0.409835,-99) , 
0, -1.17375, 1, 0, 0.463357,-99) , 
3, 0.816421, 0, 0, 0.504698,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.247401);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428703,-99) , 
3, -0.451613, 0, 0, 0.534526,-99) , 
NN(
0, 
0, 
-1, 0.434466, 0, -1, 0.398545,-99) , 
2, 0.451684, 1, 0, 0.475532,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327646,-99) , 
3, -1.99056, 0, 0, 0.50678,-99) , 
NN(
0, 
0, 
-1, 0.0916261, 1, -1, 0.105375,-99) , 
0, -2.4918, 1, 0, 0.32064,-99) , 
3, -1.09659, 0, 0, 0.451266,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.278151);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.25864, 1, 1, 0.782204,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372323,-99) , 
1, 0.494071, 1, 0, 0.485391,-99) , 
2, 0.423007, 1, 0, 0.566204,-99) , 
NN(
0, 
0, 
-1, -1.80384, 0, -1, 0.362434,-99) , 
3, 0.183842, 0, 0, 0.456145,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.297753);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.05793, 1, 1, 0.743908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406933,-99) , 
1, 0.0325634, 1, 0, 0.462561,-99) , 
3, -1.77306, 0, 0, 0.663944,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430984,-99) , 
0, 1.51859, 1, 0, 0.580651,-99) , 
NN(
0, 
0, 
-1, -0.403501, 1, -1, 0.391058,-99) , 
3, 0.368767, 0, 0, 0.494628,-99) , 
0, -1.54198, 1, 0, 0.528142,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.291662);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.87443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389347,-99) , 
3, 0.388615, 0, 0, 0.514113,-99) , 
0, -0.834311, 1, 0, 0.530889,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15875,-99) , 
3, -1.82754, 0, 0, 0.454036,-99) , 
NN(
0, 
0, 
-1, -0.117, 1, -1, 0.19095,-99) , 
0, -1.52311, 1, 0, 0.312647,-99) , 
3, -0.304384, 0, 0, 0.459297,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.251575);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.582637, 0, 1, 0.610135,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.795364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433486,-99) , 
1, -1.16338, 1, 0, 0.490117,-99) , 
2, 0.363001, 1, 0, 0.545749,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346391,-99) , 
2, -0.908768, 1, 0, 0.464745,-99) , 
NN(
0, 
0, 
-1, -1.85666, 1, -1, 0.242026,-99) , 
1, -0.236536, 1, 0, 0.359623,-99) , 
3, -0.632115, 0, 0, 0.502095,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.147172);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.81, 0, 1, 0.71849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366843,-99) , 
1, 1.06539, 1, 0, 0.629649,-99) , 
NN(
0, 
0, 
-1, -1.22144, 0, -1, 0.445014,-99) , 
0, -2.22754, 1, 0, 0.468523,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.272406);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.302787, 1, 1, 0.919892,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466561,-99) , 
2, 0.835394, 1, 0, 0.545996,-99) , 
0, -0.104444, 1, 0, 0.589835,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403806,-99) , 
3, -1.3655, 0, 0, 0.553963,-99) , 
NN(
0, 
0, 
-1, -0.596066, 0, -1, 0.351452,-99) , 
2, -1.04382, 1, 0, 0.412074,-99) , 
3, 0.0509667, 0, 0, 0.514083,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.306373);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.609455, 1, 1, 0.676895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391099,-99) , 
0, 2.79783, 1, 0, 0.655472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403863,-99) , 
0, 1.36422, 1, 0, 0.548331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289655,-99) , 
2, -0.296731, 1, 0, 0.432258,-99) , 
3, 0.234307, 0, 0, 0.482292,-99) , 
1, -0.0246959, 1, 0, 0.567031,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.194385);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.84129, 1, 1, 0.690502,-99) , 
NN(
NN(
0, 
0, 
-1, 0.481097, 0, 1, 0.629203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362811,-99) , 
0, 0.00748777, 1, 0, 0.438808,-99) , 
1, 0.940586, 0, 0, 0.465214,-99) , 
3, 1.42475, 0, 0, 0.503856,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.138547);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.822292,-99) , 
NN(
NN(
0, 
0, 
-1, -1.42486, 1, 1, 0.544208,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308423,-99) , 
1, -0.375106, 1, 0, 0.396627,-99) , 
3, -0.802192, 0, 0, 0.515312,-99) , 
1, -1.86927, 1, 0, 0.524695,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.331693);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.324531, 1, 1, 0.701277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35677,-99) , 
1, 0.618578, 0, 0, 0.462974,-99) , 
1, -0.269474, 1, 0, 0.554568,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112654,-99) , 
0, -2.27251, 1, 0, 0.349854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.95593, 0, 0, 0.275619,-99) , 
3, -1.1241, 0, 0, 0.510905,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.27108);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.62788, 1, 1, 0.9678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358388,-99) , 
0, 2.88318, 1, 0, 0.535489,-99) , 
0, 1.85268, 1, 0, 0.678675,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484565,-99) , 
2, -0.687732, 0, 0, 0.571098,-99) , 
NN(
0, 
0, 
-1, -0.136134, 0, -1, 0.397089,-99) , 
0, -0.945227, 1, 0, 0.460081,-99) , 
3, 1.32588, 0, 0, 0.505496,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.26123);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0509412, 1, 1, 0.593085,-99) , 
NN(
NN(
0, 
0, 
-1, -3.26184, 1, 1, 0.613712,-99) , 
NN(
0, 
0, 
-1, -0.0856359, 0, -1, 0.298941,-99) , 
0, -1.70283, 1, 0, 0.410451,-99) , 
2, -0.155261, 0, 0, 0.510962,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.205387);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842142,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462814,-99) , 
0, 0.176886, 1, 0, 0.520436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248542,-99) , 
0, -1.46284, 1, 0, 0.392601,-99) , 
3, -0.196581, 0, 0, 0.474646,-99) , 
0, -3.86298, 1, 0, 0.487575,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.18569);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.47325, 0, 1, 0.707848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335747,-99) , 
1, 1.17696, 1, 0, 0.489441,-99) , 
0, -0.898674, 1, 0, 0.523064,-99) , 
NN(
0, 
0, 
-1, 0.050908, 1, -1, 0.228118,-99) , 
3, -1.09659, 0, 0, 0.48257,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.241188);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475039,-99) , 
3, 0.527179, 0, 0, 0.528568,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30797,-99) , 
3, 1.92557, 0, 0, 0.385504,-99) , 
0, 1.35651, 1, 0, 0.48172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.134385,-99) , 
1, 2.00118, 1, 0, 0.464292,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.330128);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.977607, 0, 1, 0.631255,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164208,-99) , 
3, 1.53259, 0, 0, 0.412992,-99) , 
0, 1.95036, 1, 0, 0.553301,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403557,-99) , 
1, -1.18273, 0, 0, 0.539245,-99) , 
NN(
0, 
0, 
-1, -1.03872, 0, -1, 0.321137,-99) , 
1, -0.594345, 1, 0, 0.381117,-99) , 
3, 0.28719, 0, 0, 0.453345,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.189982);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494564,-99) , 
2, -0.0888424, 1, 0, 0.556251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187488,-99) , 
1, 2.00221, 1, 0, 0.5397,-99) , 
NN(
0, 
0, 
-1, -3.39302, 1, -1, 0.242983,-99) , 
3, -1.26947, 0, 0, 0.508087,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.253564);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.910591,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0434842,-99) , 
2, -1.40935, 1, 0, 0.555847,-99) , 
3, -1.22401, 0, 0, 0.661027,-99) , 
NN(
NN(
0, 
0, 
-1, -0.368114, 1, 1, 0.556077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314407,-99) , 
0, -1.37634, 1, 0, 0.369228,-99) , 
3, -0.071404, 0, 0, 0.500394,-99) , 
0, -1.6888, 1, 0, 0.52633,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.253144);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.325167, 0, 1, 0.718224,-99) , 
NN(
0, 
0, 
-1, 0.54888, 0, -1, 0.394096,-99) , 
0, 0.161986, 1, 0, 0.564964,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244465,-99) , 
0, 2.4801, 1, 0, 0.455928,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280614,-99) , 
1, -0.237048, 1, 0, 0.32646,-99) , 
0, -0.882766, 0, 0, 0.41387,-99) , 
1, -0.411712, 1, 0, 0.470479,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.342709);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3215,-99) , 
3, -1.48495, 0, 0, 0.676692,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272385,-99) , 
2, 1.81687, 1, 0, 0.519157,-99) , 
0, 0.510979, 1, 0, 0.598687,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344087,-99) , 
2, -0.652636, 0, 0, 0.531081,-99) , 
NN(
0, 
0, 
-1, 0.708919, 0, -1, 0.361543,-99) , 
0, -0.296719, 1, 0, 0.42703,-99) , 
1, 0.463922, 1, 0, 0.543601,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.275379);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.582096, 0, 1, 0.803297,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17597,-99) , 
3, -1.84075, 0, 0, 0.56657,-99) , 
2, -2.1927, 1, 0, 0.585995,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298569,-99) , 
0, 2.93634, 1, 0, 0.476149,-99) , 
NN(
0, 
0, 
-1, 1.39158, 1, -1, 0.15974,-99) , 
3, 1.11889, 0, 0, 0.37741,-99) , 
0, 0.861216, 1, 0, 0.512186,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.252456);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68171, 0, 1, 0.729915,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280669,-99) , 
3, 2.61487, 0, 0, 0.414119,-99) , 
0, 2.62158, 1, 0, 0.562961,-99) , 
NN(
0, 
0, 
-1, 0.732871, 1, -1, 0.405376,-99) , 
3, 1.42475, 0, 0, 0.437654,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.18401);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.32852, 1, 1, 0.695199,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44813,-99) , 
3, 1.31895, 0, 0, 0.466387,-99) , 
NN(
0, 
0, 
-1, 2.80725, 1, -1, 0.305948,-99) , 
0, 1.81308, 1, 0, 0.443868,-99) , 
3, 2.10834, 0, 0, 0.460572,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.265238);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.079204, 1, 1, 0.862849,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420819,-99) , 
0, -2.88881, 1, 0, 0.51453,-99) , 
3, -0.597821, 0, 0, 0.628479,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487106,-99) , 
0, 2.21483, 1, 0, 0.568388,-99) , 
NN(
0, 
0, 
-1, -0.51055, 0, -1, 0.397086,-99) , 
3, 1.43912, 0, 0, 0.432393,-99) , 
0, -0.838864, 1, 0, 0.491631,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.209475);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.296475, 1, 1, 0.590671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420763,-99) , 
3, 1.07429, 0, 0, 0.460674,-99) , 
1, 0.524261, 1, 0, 0.550559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194266,-99) , 
3, 2.25705, 0, 0, 0.315073,-99) , 
0, 2.77346, 1, 0, 0.528596,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.264619);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466001,-99) , 
1, 0.286895, 1, 0, 0.651941,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293341,-99) , 
3, 0.494478, 0, 0, 0.4954,-99) , 
0, 0.389863, 1, 0, 0.562399,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296922,-99) , 
3, -1.76396, 0, 0, 0.486358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197667,-99) , 
2, -1.09515, 1, 0, 0.394554,-99) , 
3, -0.852844, 0, 0, 0.530751,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.277112);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.18885, 1, 1, 0.594211,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
0, -2.18226, 1, 0, 0.424706,-99) , 
3, -1.19189, 0, 0, 0.552727,-99) , 
NN(
NN(
0, 
0, 
-1, 2.59489, 0, 1, 0.639368,-99) , 
NN(
0, 
0, 
-1, -0.771965, 0, -1, 0.331727,-99) , 
3, 1.82122, 0, 0, 0.392944,-99) , 
0, 0.421965, 1, 0, 0.469579,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.352793);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.366426, 1, 1, 0.769434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.336007,-99) , 
3, -0.918146, 0, 0, 0.448483,-99) , 
3, -0.348923, 0, 0, 0.556394,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414465,-99) , 
3, 1.15356, 0, 0, 0.498019,-99) , 
NN(
0, 
0, 
-1, -1.26099, 0, -1, 0.286432,-99) , 
2, 1.2026, 1, 0, 0.425246,-99) , 
2, 0.0724854, 1, 0, 0.486526,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.216214);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.644485, 0, 1, 0.590188,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407978,-99) , 
0, 2.94232, 1, 0, 0.531171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211,-99) , 
1, -0.160061, 1, 0, 0.345281,-99) , 
3, 1.80814, 0, 0, 0.427103,-99) , 
0, 1.63755, 1, 0, 0.552115,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.266823);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.977371, 0, 1, 0.61366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287048,-99) , 
1, 1.47688, 1, 0, 0.584425,-99) , 
NN(
NN(
0, 
0, 
-1, 0.940507, 1, 1, 0.560372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156348,-99) , 
1, -0.0126223, 0, 0, 0.261988,-99) , 
3, 0.610291, 0, 0, 0.445012,-99) , 
0, -0.0824338, 1, 0, 0.512569,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.225814);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806505,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340504,-99) , 
0, 1.3721, 1, 0, 0.471068,-99) , 
NN(
0, 
0, 
-1, -0.256745, 1, -1, 0.225653,-99) , 
3, -1.06553, 0, 0, 0.442651,-99) , 
0, -3.69079, 1, 0, 0.457314,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.204148);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.26559, 1, 1, 0.768572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384913,-99) , 
0, 3.38394, 1, 0, 0.680852,-99) , 
NN(
0, 
0, 
-1, -1.2578, 0, -1, 0.424103,-99) , 
3, 1.42542, 0, 0, 0.464481,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.296846);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.24068, 1, 1, 0.742373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351708,-99) , 
2, -1.78732, 0, 0, 0.64365,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434658,-99) , 
0, 1.23662, 1, 0, 0.525314,-99) , 
NN(
0, 
0, 
-1, -1.04857, 1, -1, 0.309967,-99) , 
3, 0.0156544, 0, 0, 0.449592,-99) , 
2, -1.11404, 1, 0, 0.477388,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.263611);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831273,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37577,-99) , 
3, 0.441548, 0, 0, 0.545111,-99) , 
1, -1.36512, 1, 0, 0.576235,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49266,-99) , 
2, -1.3443, 1, 0, 0.626049,-99) , 
NN(
0, 
0, 
-1, -0.993642, 0, -1, 0.357832,-99) , 
1, -1.14032, 1, 0, 0.390578,-99) , 
0, -0.00413718, 0, 0, 0.480723,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.187994);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448977,-99) , 
2, 1.31521, 0, 0, 0.481531,-99) , 
0, -2.0397, 1, 0, 0.502197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152551,-99) , 
3, -1.67155, 0, 0, 0.48804,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.299949);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384365,-99) , 
2, 1.18965, 1, 0, 0.602281,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268307,-99) , 
0, -1.59136, 1, 0, 0.4373,-99) , 
3, -0.351079, 0, 0, 0.53417,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599871,-99) , 
NN(
0, 
0, 
-1, 1.71067, 0, -1, 0.210005,-99) , 
3, 2.2218, 0, 0, 0.340043,-99) , 
2, 1.4556, 1, 0, 0.512695,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.238494);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424843,-99) , 
3, 0.983057, 1, 0, 0.716238,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319195,-99) , 
1, -0.707398, 0, 0, 0.496175,-99) , 
1, -1.15254, 1, 0, 0.522628,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334554,-99) , 
3, -1.42502, 0, 0, 0.470904,-99) , 
NN(
0, 
0, 
-1, -0.742533, 0, -1, 0.255487,-99) , 
0, -1.89209, 1, 0, 0.345797,-99) , 
3, -0.376892, 0, 0, 0.471467,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.176365);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38658,-99) , 
2, 1.54775, 1, 0, 0.53787,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355331,-99) , 
0, -0.00913291, 1, 0, 0.44165,-99) , 
3, 1.16585, 0, 0, 0.465479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136059,-99) , 
3, -1.80475, 0, 0, 0.454115,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.216292);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.926331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422494,-99) , 
2, -0.993642, 0, 0, 0.528256,-99) , 
3, 0.929719, 0, 0, 0.548635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663684,-99) , 
NN(
0, 
0, 
-1, 2.64902, 1, -1, 0.381936,-99) , 
1, -1.36512, 1, 0, 0.421778,-99) , 
0, 0.861216, 1, 0, 0.501318,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.267321);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295491,-99) , 
3, -0.951789, 0, 0, 0.692205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262019,-99) , 
0, 1.26111, 1, 0, 0.455114,-99) , 
1, 1.05393, 1, 0, 0.604239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411213,-99) , 
3, 1.5996, 0, 0, 0.434308,-99) , 
1, -1.97073, 1, 0, 0.449764,-99) , 
1, 0.345387, 0, 0, 0.504817,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.224143);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897553,-99) , 
NN(
0, 
0, 
-1, 2.67628, 1, -1, 0.43241,-99) , 
3, 2.51252, 0, 0, 0.451059,-99) , 
NN(
0, 
0, 
-1, -2.65144, 1, -1, 0.142946,-99) , 
3, -1.2198, 0, 0, 0.418252,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.287022);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.138438, 0, 1, 0.632161,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387688,-99) , 
1, -0.794862, 1, 0, 0.444669,-99) , 
2, 0.120313, 1, 0, 0.528997,-99) , 
NN(
0, 
0, 
-1, 1.58684, 0, -1, 0.265804,-99) , 
1, 1.32833, 1, 0, 0.493979,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.409457);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225363,-99) , 
0, 3.4335, 1, 0, 0.620609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218624,-99) , 
1, -0.590512, 0, 0, 0.418373,-99) , 
3, -0.639447, 0, 0, 0.578083,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131899,-99) , 
1, 1.62435, 1, 0, 0.598376,-99) , 
NN(
0, 
0, 
-1, 0.492928, 0, -1, 0.248955,-99) , 
0, -0.0886532, 1, 0, 0.390109,-99) , 
1, 0.823393, 1, 0, 0.531393,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.293099);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.493142, 1, 1, 0.618261,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215905,-99) , 
1, -0.937822, 0, 0, 0.476527,-99) , 
3, -0.376892, 0, 0, 0.57559,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.957177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420892,-99) , 
1, 1.72607, 0, 0, 0.498329,-99) , 
NN(
0, 
0, 
-1, 1.26644, 1, -1, 0.16901,-99) , 
3, -0.186452, 0, 0, 0.398094,-99) , 
1, 0.51493, 1, 0, 0.523543,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.273011);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.393393, 0, 1, 0.591733,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334441,-99) , 
3, 2.46241, 0, 0, 0.423221,-99) , 
0, 2.30263, 1, 0, 0.568741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424871,-99) , 
3, -0.585537, 0, 0, 0.605884,-99) , 
NN(
0, 
0, 
-1, -1.1793, 1, -1, 0.264448,-99) , 
3, 0.264658, 1, 0, 0.411301,-99) , 
1, -0.749593, 0, 0, 0.524433,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.17261);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.985731,-99) , 
NN(
NN(
0, 
0, 
-1, -0.492092, 0, 1, 0.62789,-99) , 
NN(
0, 
0, 
-1, -0.716903, 0, -1, 0.4415,-99) , 
1, 0.844038, 0, 0, 0.480152,-99) , 
1, -2.0516, 1, 0, 0.495544,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.245816);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435751,-99) , 
0, 2.83278, 1, 0, 0.618967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259123,-99) , 
2, 2.13013, 1, 0, 0.584771,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358902,-99) , 
0, -0.353372, 1, 0, 0.444933,-99) , 
NN(
0, 
0, 
-1, 0.0536862, 1, -1, 0.240831,-99) , 
1, 0.821233, 1, 0, 0.411584,-99) , 
3, 0.908704, 0, 0, 0.465495,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.341172);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0161435, 0, 1, 0.710488,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480568,-99) , 
1, -0.860215, 0, 0, 0.530478,-99) , 
3, 0.262941, 1, 0, 0.620225,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360911,-99) , 
0, 2.04265, 1, 0, 0.557385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319594,-99) , 
1, -0.388745, 1, 0, 0.371165,-99) , 
3, 0.287233, 0, 0, 0.46357,-99) , 
1, -0.572275, 1, 0, 0.510008,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.223087);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.22963, 0, 1, 0.81084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439773,-99) , 
2, 0.744915, 1, 0, 0.680058,-99) , 
NN(
NN(
0, 
0, 
-1, 1.50473, 1, 1, 0.573674,-99) , 
NN(
0, 
0, 
-1, 0.171943, 1, -1, 0.404564,-99) , 
3, 1.1206, 0, 0, 0.44269,-99) , 
1, -1.03486, 1, 0, 0.47722,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.15833);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.07537, 1, 1, 0.684086,-99) , 
NN(
0, 
0, 
-1, 1.18251, 1, -1, 0.4286,-99) , 
1, 1.64097, 0, 0, 0.44472,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.245722);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245178,-99) , 
3, -1.15643, 0, 0, 0.582755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383332,-99) , 
1, 0.704249, 0, 0, 0.461022,-99) , 
1, -0.118452, 1, 0, 0.50968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171463,-99) , 
1, -1.84449, 0, 0, 0.487891,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.149308);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764479,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495056,-99) , 
3, 0.069168, 0, 0, 0.546349,-99) , 
NN(
0, 
0, 
-1, 1.15118, 0, -1, 0.407924,-99) , 
0, 1.04773, 1, 0, 0.504223,-99) , 
3, 2.52728, 0, 0, 0.516461,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.265863);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496306,-99) , 
1, 0.548737, 0, 0, 0.583276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299801,-99) , 
2, -0.327583, 1, 0, 0.404379,-99) , 
1, 1.14184, 1, 0, 0.548924,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28936,-99) , 
2, 1.3783, 1, 0, 0.511359,-99) , 
NN(
0, 
0, 
-1, -0.838086, 1, -1, 0.224671,-99) , 
2, -0.15663, 0, 0, 0.417938,-99) , 
1, -0.411712, 0, 0, 0.504316,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.287731);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21402, 0, 1, 0.671814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222831,-99) , 
1, 1.06974, 1, 0, 0.44288,-99) , 
0, 2.04799, 1, 0, 0.57506,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327516,-99) , 
1, 0.846826, 1, 0, 0.511594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302571,-99) , 
1, -1.04951, 1, 0, 0.343798,-99) , 
2, -0.353132, 1, 0, 0.412522,-99) , 
3, 0.816421, 0, 0, 0.470289,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.232611);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0736931, 1, 1, 0.651799,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334942,-99) , 
2, 0.587256, 0, 0, 0.524446,-99) , 
2, 0.402853, 1, 0, 0.568597,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470868,-99) , 
3, -0.322818, 0, 0, 0.512968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245169,-99) , 
0, -0.310134, 1, 0, 0.445624,-99) , 
2, -0.224534, 0, 0, 0.520081,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.180642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.277067, 1, 1, 0.723641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448314,-99) , 
1, -1.40673, 1, 0, 0.469265,-99) , 
0, -1.7931, 1, 0, 0.496904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.218274,-99) , 
3, -1.59453, 0, 0, 0.486901,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.206619);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.418374, 0, 1, 0.606592,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209017,-99) , 
3, -0.634944, 0, 0, 0.488339,-99) , 
1, -0.0315654, 1, 0, 0.546535,-99) , 
NN(
0, 
0, 
-1, -2.01929, 1, -1, 0.316792,-99) , 
1, -1.6752, 0, 0, 0.528573,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.199416);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456477,-99) , 
2, 0.482457, 1, 0, 0.542456,-99) , 
NN(
0, 
0, 
-1, 0.173901, 0, -1, 0.316314,-99) , 
1, -1.49648, 0, 0, 0.525234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0319662,-99) , 
3, -2.06496, 0, 0, 0.5087,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.36941);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466417,-99) , 
3, -0.978741, 0, 0, 0.648482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.106769,-99) , 
3, -1.75097, 0, 0, 0.620881,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341165,-99) , 
0, 2.76714, 1, 0, 0.531539,-99) , 
NN(
0, 
0, 
-1, 0.911398, 1, -1, 0.273139,-99) , 
3, 1.11556, 0, 0, 0.435446,-99) , 
2, 0.650515, 1, 0, 0.560789,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.287014);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133948,-99) , 
3, -1.77267, 0, 0, 0.535829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334057,-99) , 
3, 1.08356, 0, 0, 0.378244,-99) , 
2, -0.812478, 1, 0, 0.40492,-99) , 
3, 2.3448, 0, 0, 0.419262,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.212559);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.73265, 0, 1, 0.68952,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444973,-99) , 
2, -0.620148, 1, 0, 0.491339,-99) , 
NN(
0, 
0, 
-1, 2.69876, 1, -1, 0.222898,-99) , 
0, 1.81962, 1, 0, 0.453897,-99) , 
3, 2.06344, 0, 0, 0.476685,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.221671);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351816,-99) , 
3, -1.55878, 0, 0, 0.553405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309246,-99) , 
3, 1.67902, 0, 0, 0.406285,-99) , 
2, 1.0287, 1, 0, 0.525946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715554,-99) , 
NN(
0, 
0, 
-1, 1.28467, 0, -1, 0.282163,-99) , 
1, 1.05815, 1, 0, 0.379519,-99) , 
1, 0.886931, 1, 0, 0.49742,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.131548);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833183,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489626,-99) , 
2, 0.527383, 0, 0, 0.53343,-99) , 
NN(
0, 
0, 
-1, 1.99866, 0, -1, 0.374893,-99) , 
0, 2.298, 1, 0, 0.515744,-99) , 
3, 2.85426, 0, 0, 0.524766,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.155012);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.469491, 1, 1, 0.759449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486642,-99) , 
1, 0.170998, 0, 0, 0.540047,-99) , 
0, -3.02103, 1, 0, 0.55635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318096,-99) , 
0, 3.4051, 1, 0, 0.543606,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.224047);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.977007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49374,-99) , 
2, -0.150791, 0, 0, 0.735359,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451243,-99) , 
3, 1.76633, 0, 0, 0.50271,-99) , 
0, 0.205625, 1, 0, 0.556946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434518,-99) , 
2, -0.827624, 0, 0, 0.502956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210683,-99) , 
2, -0.0872687, 1, 0, 0.453793,-99) , 
3, -0.202496, 0, 0, 0.520124,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.249732);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.463349, 0, 1, 0.845922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43205,-99) , 
3, -0.997442, 0, 0, 0.536425,-99) , 
3, -0.222179, 0, 0, 0.617273,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360967,-99) , 
3, 0.523055, 0, 0, 0.521383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189004,-99) , 
3, 0.116206, 0, 0, 0.475114,-99) , 
0, -0.106773, 1, 0, 0.534076,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.219558);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.612854, 0, 1, 0.686954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322888,-99) , 
1, 0.821233, 1, 0, 0.479464,-99) , 
3, 0.563237, 0, 0, 0.524557,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393717,-99) , 
1, -0.700548, 1, 0, 0.444429,-99) , 
NN(
0, 
0, 
-1, -0.21535, 1, -1, 0.251635,-99) , 
3, 1.57481, 0, 0, 0.355715,-99) , 
0, 1.5337, 1, 0, 0.474547,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.170582);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.217974, 1, 1, 0.717387,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333762,-99) , 
3, -0.15846, 0, 0, 0.641225,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374897,-99) , 
2, -1.53743, 1, 0, 0.607097,-99) , 
NN(
0, 
0, 
-1, -0.344423, 0, -1, 0.449362,-99) , 
0, -2.22754, 1, 0, 0.466696,-99) , 
1, 1.12171, 0, 0, 0.490083,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.0959296);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807649,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196266,-99) , 
0, 3.7032, 1, 0, 0.490511,-99) , 
0, -1.7931, 1, 0, 0.513419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262061,-99) , 
3, -1.57994, 0, 0, 0.500279,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.234381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.909452, 0, 1, 0.672809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427344,-99) , 
2, -0.221282, 1, 0, 0.639134,-99) , 
NN(
NN(
0, 
0, 
-1, 1.17441, 1, 1, 0.65728,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410975,-99) , 
1, -0.799065, 1, 0, 0.451998,-99) , 
1, 1.30759, 0, 0, 0.469054,-99) , 
0, -0.947009, 1, 0, 0.52343,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.274482);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.508636, 1, 1, 0.649532,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301932,-99) , 
2, -0.926576, 1, 0, 0.434794,-99) , 
3, -0.361096, 0, 0, 0.558795,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479462,-99) , 
0, 2.51972, 1, 0, 0.562834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153377,-99) , 
1, -0.0440867, 1, 0, 0.314004,-99) , 
3, 1.64845, 0, 0, 0.424351,-99) , 
0, 1.14771, 1, 0, 0.51853,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.201333);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465765,-99) , 
2, -0.499911, 0, 0, 0.55189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33287,-99) , 
1, 1.37772, 0, 0, 0.386381,-99) , 
1, 0.593151, 1, 0, 0.51005,-99) , 
1, 1.86131, 0, 0, 0.520016,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.158031);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767956,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409042,-99) , 
3, -0.753721, 0, 0, 0.519773,-99) , 
NN(
0, 
0, 
-1, 0.12002, 1, -1, 0.283493,-99) , 
1, 1.28581, 1, 0, 0.501806,-99) , 
1, 1.81888, 0, 0, 0.512821,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.244989);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.35752, 1, 1, 0.811637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431341,-99) , 
3, -1.61284, 0, 0, 0.724751,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489616,-99) , 
2, 0.325345, 1, 0, 0.545163,-99) , 
NN(
0, 
0, 
-1, -0.287043, 1, -1, 0.311264,-99) , 
3, -0.0203103, 0, 0, 0.474761,-99) , 
0, -1.72338, 1, 0, 0.508194,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.191218);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835209,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310064,-99) , 
2, 1.81972, 1, 0, 0.510108,-99) , 
0, -0.981859, 1, 0, 0.532928,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655996,-99) , 
NN(
0, 
0, 
-1, -1.80475, 1, -1, 0.299711,-99) , 
1, -1.3358, 1, 0, 0.346121,-99) , 
3, -0.62845, 0, 0, 0.490895,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.260408);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426214,-99) , 
0, -0.532474, 0, 0, 0.538264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306298,-99) , 
0, 3.84047, 1, 0, 0.52757,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81846,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452179,-99) , 
2, 0.276916, 0, 0, 0.597789,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213887,-99) , 
0, -1.22038, 1, 0, 0.294785,-99) , 
1, -1.46292, 1, 0, 0.383511,-99) , 
1, -0.759733, 0, 0, 0.497345,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.295683);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.62933, 0, 1, 0.726364,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361109,-99) , 
2, -0.64239, 0, 0, 0.533894,-99) , 
2, -1.42431, 1, 0, 0.586547,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456458,-99) , 
2, 1.05193, 0, 0, 0.535204,-99) , 
NN(
0, 
0, 
-1, 0.273471, 1, -1, 0.290313,-99) , 
2, 0.534799, 0, 0, 0.421266,-99) , 
0, -0.233659, 1, 0, 0.489426,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.160541);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0672474, 0, 1, 0.55408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297899,-99) , 
3, 0.695249, 0, 0, 0.454262,-99) , 
0, -0.0248499, 1, 0, 0.493463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318827,-99) , 
3, -1.66217, 0, 0, 0.485352,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.245831);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.11097, 0, 1, 0.711379,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.793275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464018,-99) , 
2, 0.22274, 1, 0, 0.495803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257751,-99) , 
0, -0.877206, 1, 0, 0.347041,-99) , 
3, 0.462227, 0, 0, 0.418561,-99) , 
0, -2.41637, 1, 0, 0.450771,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.241313);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.925295,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482821,-99) , 
1, 1.09951, 0, 0, 0.512415,-99) , 
3, 0.114708, 0, 0, 0.563627,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425115,-99) , 
0, 1.1799, 1, 0, 0.501995,-99) , 
NN(
0, 
0, 
-1, 0.612685, 0, -1, 0.233238,-99) , 
2, 0.175256, 0, 0, 0.44291,-99) , 
0, 0.264129, 1, 0, 0.493483,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.28401);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.760156, 1, 1, 0.765487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445419,-99) , 
3, 2.56887, 0, 0, 0.505106,-99) , 
0, 1.51158, 1, 0, 0.572898,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393147,-99) , 
2, 0.181677, 0, 0, 0.418505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222049,-99) , 
2, 0.43797, 1, 0, 0.384385,-99) , 
3, 0.638168, 0, 0, 0.462139,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.161049);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.87934, 0, 1, 0.759078,-99) , 
NN(
NN(
0, 
0, 
-1, 2.79004, 1, 1, 0.661249,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241496,-99) , 
2, 1.33011, 1, 0, 0.494437,-99) , 
3, 1.6754, 0, 0, 0.52489,-99) , 
0, -2.405, 1, 0, 0.54472,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.187894);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.236536, 1, 1, 0.722376,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436717,-99) , 
2, 1.37267, 1, 0, 0.548939,-99) , 
NN(
0, 
0, 
-1, -1.1757, 1, -1, 0.28417,-99) , 
3, -0.971048, 0, 0, 0.522723,-99) , 
0, -2.96777, 1, 0, 0.535223,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.304632);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238379,-99) , 
3, 0.126244, 0, 0, 0.614404,-99) , 
NN(
0, 
0, 
-1, -1.31849, 0, -1, 0.449923,-99) , 
2, 0.777837, 1, 0, 0.518095,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324737,-99) , 
3, -1.04528, 0, 0, 0.48174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249717,-99) , 
0, -0.934264, 1, 0, 0.294926,-99) , 
2, -0.540289, 1, 0, 0.38712,-99) , 
2, 0.21299, 0, 0, 0.450358,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.283885);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731476,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452486,-99) , 
2, -0.899737, 1, 0, 0.633414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338719,-99) , 
3, -1.99367, 0, 0, 0.589772,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38804,-99) , 
0, 3.0766, 1, 0, 0.578452,-99) , 
NN(
0, 
0, 
-1, 1.3388, 1, -1, 0.37784,-99) , 
3, 1.57734, 0, 0, 0.415388,-99) , 
3, -0.639447, 1, 0, 0.452808,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.180195);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.382668, 1, 1, 0.606064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250664,-99) , 
2, -1.61118, 0, 0, 0.584015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47767,-99) , 
3, 1.39201, 0, 0, 0.501271,-99) , 
NN(
0, 
0, 
-1, -1.49736, 0, -1, 0.312253,-99) , 
2, 1.12247, 1, 0, 0.470003,-99) , 
1, -0.0229864, 0, 0, 0.523224,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.300817);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.0436, 1, 1, 0.739267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477471,-99) , 
1, 0.618725, 0, 0, 0.547389,-99) , 
1, -0.231192, 1, 0, 0.626075,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379316,-99) , 
2, -0.879831, 1, 0, 0.467436,-99) , 
NN(
0, 
0, 
-1, -1.44256, 0, -1, 0.226513,-99) , 
1, 0.050908, 1, 0, 0.388021,-99) , 
3, -0.43837, 0, 0, 0.567313,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.186012);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.119274, 1, 1, 0.558186,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618913,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388674,-99) , 
2, -1.45386, 1, 0, 0.453969,-99) , 
3, -0.0522943, 0, 0, 0.514848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.113425,-99) , 
3, 2.5016, 0, 0, 0.317906,-99) , 
0, 3.16748, 1, 0, 0.502416,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.240257);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422642,-99) , 
2, -0.866087, 0, 0, 0.648691,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302727,-99) , 
1, 0.0302751, 1, 0, 0.462534,-99) , 
3, -0.776089, 0, 0, 0.576117,-99) , 
NN(
NN(
0, 
0, 
-1, 0.952773, 1, 1, 0.626285,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398782,-99) , 
1, 0.453112, 0, 0, 0.455229,-99) , 
1, -0.924068, 1, 0, 0.488214,-99) , 
2, 0.224475, 1, 0, 0.528014,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.234223);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200042,-99) , 
2, 2.26638, 1, 0, 0.605376,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411054,-99) , 
0, -0.0917164, 1, 0, 0.478666,-99) , 
1, 0.345387, 1, 0, 0.551161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0940061,-99) , 
3, -1.73087, 0, 0, 0.537854,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.222168);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.913684, 1, 1, 0.601965,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271213,-99) , 
3, -1.96202, 0, 0, 0.548545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257599,-99) , 
2, 0.111886, 1, 0, 0.485019,-99) , 
3, 0.178444, 0, 0, 0.546199,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.257038);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.848723, 1, 1, 0.735361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214824,-99) , 
1, 1.24965, 1, 0, 0.468772,-99) , 
0, 0.205625, 1, 0, 0.538669,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352171,-99) , 
2, -1.69637, 0, 0, 0.583927,-99) , 
NN(
0, 
0, 
-1, -0.874247, 1, -1, 0.296153,-99) , 
0, -1.90047, 1, 0, 0.42425,-99) , 
3, -0.420978, 0, 0, 0.500172,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.209216);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636957,-99) , 
NN(
NN(
0, 
0, 
-1, -0.786003, 0, -1, 0.41791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221515,-99) , 
2, -0.427834, 1, 0, 0.288275,-99) , 
1, 1.02305, 1, 0, 0.399037,-99) , 
1, 1.81888, 0, 0, 0.406845,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.208485);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.78902, 0, 1, 0.682435,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.148978,-99) , 
3, -1.03697, 0, 0, 0.481208,-99) , 
2, -1.15149, 1, 0, 0.509661,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826631,-99) , 
NN(
0, 
0, 
-1, -0.782644, 0, -1, 0.319516,-99) , 
0, -2.41149, 1, 0, 0.364141,-99) , 
1, 0.463922, 1, 0, 0.461107,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.238311);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.360537, 0, 1, 0.761924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493359,-99) , 
1, -0.31741, 1, 0, 0.554831,-99) , 
3, 0.426454, 0, 0, 0.599726,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485411,-99) , 
1, 0.143069, 1, 0, 0.557828,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136203,-99) , 
3, 1.05943, 0, 0, 0.465356,-99) , 
0, 1.37226, 1, 0, 0.55317,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.165491);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.876587,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231598,-99) , 
3, -1.76668, 0, 0, 0.618076,-99) , 
NN(
0, 
0, 
-1, -0.0805524, 0, -1, 0.460535,-99) , 
0, -0.815132, 1, 0, 0.50297,-99) , 
3, 3.10168, 0, 0, 0.512654,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.198464);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0463838, 1, 1, 0.652368,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324433,-99) , 
0, -0.748551, 0, 0, 0.470669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181496,-99) , 
2, 1.9346, 1, 0, 0.454067,-99) , 
1, 0.988758, 0, 0, 0.480956,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.281686);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.10019, 1, 1, 0.66312,-99) , 
NN(
0, 
0, 
-1, 3.66372, 0, -1, 0.322227,-99) , 
0, 2.83027, 1, 0, 0.627369,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343525,-99) , 
3, -0.925092, 0, 0, 0.498484,-99) , 
NN(
0, 
0, 
-1, 1.27433, 0, -1, 0.354955,-99) , 
3, 0.760312, 1, 0, 0.428662,-99) , 
1, -0.0270664, 1, 0, 0.532929,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.131378);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69508,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468254,-99) , 
2, 0.934829, 0, 0, 0.49164,-99) , 
NN(
0, 
0, 
-1, 1.43588, 0, -1, 0.238826,-99) , 
0, 2.80639, 1, 0, 0.474205,-99) , 
3, 2.59088, 0, 0, 0.485054,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.153358);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347259,-99) , 
1, -0.463372, 0, 0, 0.603255,-99) , 
3, -0.949735, 0, 0, 0.667929,-99) , 
NN(
NN(
0, 
0, 
-1, 2.5723, 0, 1, 0.519233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165022,-99) , 
3, -0.601696, 0, 0, 0.497528,-99) , 
0, -1.60501, 1, 0, 0.526635,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.324818);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268396,-99) , 
1, 1.34242, 1, 0, 0.634716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0360562,-99) , 
2, -1.32429, 1, 0, 0.361716,-99) , 
3, -1.33539, 0, 0, 0.583192,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46322,-99) , 
1, 0.444424, 0, 0, 0.5376,-99) , 
NN(
0, 
0, 
-1, 1.41227, 1, -1, 0.320925,-99) , 
3, 1.29083, 0, 0, 0.434199,-99) , 
0, 0.515594, 1, 0, 0.50835,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.283822);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.76227, 1, 1, 0.640849,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280795,-99) , 
2, 1.49469, 1, 0, 0.397808,-99) , 
1, -0.27916, 0, 0, 0.541648,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405874,-99) , 
1, -1.29744, 0, 0, 0.580895,-99) , 
NN(
0, 
0, 
-1, -1.36897, 0, -1, 0.380131,-99) , 
1, -0.605638, 1, 0, 0.428238,-99) , 
3, 1.14325, 0, 0, 0.459737,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.281067);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.59355, 0, 1, 0.828116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370625,-99) , 
1, -0.530862, 0, 0, 0.665025,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327222,-99) , 
2, 0.887477, 0, 0, 0.572508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348641,-99) , 
2, -0.0265322, 1, 0, 0.451505,-99) , 
2, 0.71953, 0, 0, 0.498343,-99) , 
0, -2.25694, 1, 0, 0.523122,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.18325);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292502,-99) , 
0, -3.25177, 1, 0, 0.555384,-99) , 
2, -1.59355, 0, 0, 0.655124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391908,-99) , 
0, 0.457876, 0, 0, 0.453735,-99) , 
NN(
0, 
0, 
-1, -1.09272, 1, -1, 0.149534,-99) , 
3, -0.990257, 0, 0, 0.433702,-99) , 
0, -2.52411, 1, 0, 0.455097,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.0990194);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779644,-99) , 
NN(
0, 
0, 
-1, -0.985619, 0, -1, 0.476147,-99) , 
0, -2.39596, 1, 0, 0.489605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186848,-99) , 
2, -1.63878, 0, 0, 0.47419,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.342823);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.520716, 0, 1, 0.750253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342711,-99) , 
0, 2.68245, 1, 0, 0.475704,-99) , 
0, 1.31059, 1, 0, 0.569682,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.234125,-99) , 
1, -1.15556, 0, 0, 0.519838,-99) , 
NN(
0, 
0, 
-1, -0.610613, 1, -1, 0.255864,-99) , 
0, -0.887757, 1, 0, 0.388486,-99) , 
3, 0.234307, 0, 0, 0.471938,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.1749);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759281,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421189,-99) , 
1, 0.0462137, 0, 0, 0.483149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12396,-99) , 
2, -1.76267, 0, 0, 0.471932,-99) , 
2, -2.07855, 1, 0, 0.482594,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.26375);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488964,-99) , 
0, 0.134795, 1, 0, 0.610178,-99) , 
NN(
0, 
0, 
-1, -0.827699, 1, -1, 0.38468,-99) , 
3, -0.772213, 0, 0, 0.547018,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222477,-99) , 
0, 3.762, 1, 0, 0.452137,-99) , 
NN(
0, 
0, 
-1, -0.382734, 0, -1, 0.247727,-99) , 
3, 1.39872, 0, 0, 0.368529,-99) , 
0, 1.23997, 1, 0, 0.483023,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.151575);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.64121, 0, 1, 0.541341,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410648,-99) , 
3, 2.40591, 0, 0, 0.442793,-99) , 
0, 1.03879, 1, 0, 0.503416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16068,-99) , 
0, 3.88576, 1, 0, 0.492348,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.192967);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560707,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408263,-99) , 
0, 1.63755, 1, 0, 0.52183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382427,-99) , 
3, 1.2441, 0, 0, 0.436393,-99) , 
1, -0.368379, 0, 0, 0.485581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239509,-99) , 
1, 2.10224, 1, 0, 0.477896,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.324514);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.04095, 1, 1, 0.680992,-99) , 
NN(
0, 
0, 
-1, 1.56593, 0, -1, 0.382642,-99) , 
2, 1.13903, 1, 0, 0.621062,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243925,-99) , 
2, -0.749743, 0, 0, 0.46753,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263361,-99) , 
3, 1.97992, 0, 0, 0.335477,-99) , 
0, 1.23253, 1, 0, 0.414651,-99) , 
1, 0.0804066, 1, 0, 0.533101,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.263215);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307433,-99) , 
1, -1.71505, 0, 0, 0.611177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209258,-99) , 
0, 1.71457, 0, 0, 0.379685,-99) , 
2, 0.702607, 1, 0, 0.536898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753901,-99) , 
NN(
0, 
0, 
-1, 1.52238, 1, -1, 0.406102,-99) , 
3, 2.75366, 0, 0, 0.419854,-99) , 
1, -0.493896, 1, 0, 0.457998,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.301588);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96913, 1, 1, 0.774762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348005,-99) , 
3, 1.32661, 0, 0, 0.57616,-99) , 
2, 0.661169, 1, 0, 0.625757,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426367,-99) , 
3, -0.560561, 0, 0, 0.529247,-99) , 
NN(
0, 
0, 
-1, -0.0169235, 1, -1, 0.362437,-99) , 
0, -0.537057, 1, 0, 0.447371,-99) , 
3, 0.816421, 0, 0, 0.503663,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.204966);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39288,-99) , 
2, -0.379864, 0, 0, 0.49622,-99) , 
NN(
0, 
0, 
-1, 2.278, 0, -1, 0.215769,-99) , 
2, 1.96309, 1, 0, 0.478298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0490436,-99) , 
1, 2.14068, 1, 0, 0.463516,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.206808);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754695,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396263,-99) , 
1, 0.205428, 1, 0, 0.467774,-99) , 
NN(
0, 
0, 
-1, 1.1122, 1, -1, 0.34226,-99) , 
1, -0.811584, 0, 0, 0.443486,-99) , 
1, -1.82258, 1, 0, 0.453387,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.308149);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.58792, 1, 1, 0.826335,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333846,-99) , 
3, -1.56505, 0, 0, 0.539113,-99) , 
1, 0.315854, 0, 0, 0.66626,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.745759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480495,-99) , 
0, 0.803071, 1, 0, 0.596489,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324589,-99) , 
1, 0.728667, 0, 0, 0.373695,-99) , 
1, -0.636138, 1, 0, 0.42798,-99) , 
0, -1.74276, 1, 0, 0.465987,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.349869);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471958,-99) , 
1, 0.71376, 1, 0, 0.632755,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341412,-99) , 
1, 0.621989, 0, 0, 0.420619,-99) , 
2, 1.1812, 1, 0, 0.577053,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394113,-99) , 
0, -3.30949, 1, 0, 0.563048,-99) , 
NN(
0, 
0, 
-1, -1.54127, 1, -1, 0.221717,-99) , 
0, -2.48686, 1, 0, 0.347744,-99) , 
3, -0.632115, 0, 0, 0.529583,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.156828);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.4299, 1, 1, 0.721294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348255,-99) , 
1, 0.9069, 1, 0, 0.589438,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472682,-99) , 
1, 0.906291, 0, 0, 0.495375,-99) , 
NN(
0, 
0, 
-1, 1.76989, 1, -1, 0.249063,-99) , 
2, 1.22033, 1, 0, 0.471659,-99) , 
3, 1.9417, 0, 0, 0.485699,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.127967);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.345128, 1, 1, 0.75489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411072,-99) , 
3, -1.90132, 0, 0, 0.672326,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206298,-99) , 
3, -0.57216, 0, 0, 0.480054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.121794,-99) , 
1, -0.0908984, 0, 0, 0.340604,-99) , 
0, 3.03037, 1, 0, 0.46574,-99) , 
0, -1.84335, 1, 0, 0.493377,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.168614);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.138996, 1, 1, 0.565876,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432345,-99) , 
0, -3.21813, 1, 0, 0.455418,-99) , 
1, -0.290982, 0, 0, 0.512473,-99) , 
NN(
0, 
0, 
-1, -0.179675, 1, -1, 0.315939,-99) , 
1, 1.29295, 1, 0, 0.494951,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.194586);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.231283, 0, 1, 0.639076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387686,-99) , 
3, 0.790049, 0, 0, 0.461376,-99) , 
2, -0.275296, 1, 0, 0.514995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142802,-99) , 
2, -1.63878, 0, 0, 0.503049,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.222762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.764809, 1, 1, 0.65267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549811,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374128,-99) , 
2, 0.419243, 1, 0, 0.518501,-99) , 
3, 0.794939, 0, 0, 0.548184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291915,-99) , 
0, 2.09919, 1, 0, 0.357002,-99) , 
3, 2.81454, 0, 0, 0.392372,-99) , 
0, 1.77377, 1, 0, 0.502339,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.176172);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424876,-99) , 
2, 0.334821, 0, 0, 0.460082,-99) , 
3, 1.63785, 0, 0, 0.471934,-99) , 
NN(
0, 
0, 
-1, 0.555659, 0, -1, 0.345235,-99) , 
0, 2.02942, 1, 0, 0.447198,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.223636);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.836406,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456313,-99) , 
0, 1.78598, 1, 0, 0.563722,-99) , 
NN(
0, 
0, 
-1, -1.55003, 1, -1, 0.224538,-99) , 
3, -1.32305, 0, 0, 0.542936,-99) , 
2, -2.13325, 1, 0, 0.55418,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.321592);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398524,-99) , 
3, 0.744548, 1, 0, 0.688245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671008,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411395,-99) , 
1, -0.511518, 1, 0, 0.491875,-99) , 
3, -1.00319, 0, 0, 0.616797,-99) , 
NN(
NN(
0, 
0, 
-1, 1.12179, 1, 1, 0.539292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.746352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266327,-99) , 
1, -0.443347, 1, 0, 0.370192,-99) , 
2, 0.966163, 0, 0, 0.459087,-99) , 
2, 0.21299, 1, 0, 0.532448,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.307408);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477824,-99) , 
2, -0.37087, 0, 0, 0.624899,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188867,-99) , 
3, 2.03867, 0, 0, 0.332448,-99) , 
2, 1.21219, 1, 0, 0.537991,-99) , 
NN(
NN(
0, 
0, 
-1, 1.42929, 1, 1, 0.592845,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308819,-99) , 
0, -1.5197, 1, 0, 0.347135,-99) , 
3, 1.26576, 0, 0, 0.405285,-99) , 
1, -0.636138, 1, 0, 0.43832,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.258637);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.39799, 0, 1, 0.662471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343683,-99) , 
3, 0.0950131, 0, 0, 0.479469,-99) , 
2, -0.871865, 1, 0, 0.513667,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273637,-99) , 
3, -0.258503, 0, 0, 0.404773,-99) , 
NN(
0, 
0, 
-1, 2.14907, 0, -1, 0.233972,-99) , 
0, 1.26111, 1, 0, 0.334113,-99) , 
1, 0.494071, 1, 0, 0.452235,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.205724);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.40466, 0, 1, 0.849018,-99) , 
NN(
0, 
0, 
-1, -1.27093, 0, -1, 0.41647,-99) , 
0, -3.02048, 1, 0, 0.445643,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.169097);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813629,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436078,-99) , 
3, 1.5444, 0, 0, 0.463125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249966,-99) , 
0, 3.86928, 1, 0, 0.454546,-99) , 
1, -2.00084, 1, 0, 0.467168,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.274216);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.872859, 1, 1, 0.603929,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36709,-99) , 
2, -0.52761, 1, 0, 0.498105,-99) , 
3, 0.383783, 0, 0, 0.533874,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352453,-99) , 
1, -0.00989829, 1, 0, 0.463509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12809,-99) , 
3, 1.12022, 0, 0, 0.368479,-99) , 
2, 0.999858, 1, 0, 0.492817,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.279433);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.18725, 1, 1, 0.556962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131728,-99) , 
1, 1.87703, 1, 0, 0.521837,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34276,-99) , 
2, -0.0351261, 0, 0, 0.524556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298904,-99) , 
3, 2.73428, 0, 0, 0.321033,-99) , 
2, 0.325054, 1, 0, 0.35484,-99) , 
0, 0.600248, 1, 0, 0.441944,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.164396);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.85127, 1, 1, 0.548461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0812222,-99) , 
0, -3.66522, 1, 0, 0.315267,-99) , 
3, -1.62105, 0, 0, 0.530495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32724,-99) , 
3, 1.61062, 1, 0, 0.440152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171236,-99) , 
3, -0.315901, 0, 0, 0.373258,-99) , 
1, 0.906291, 1, 0, 0.499984,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.166124);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48175,-99) , 
0, -0.808099, 1, 0, 0.513351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184121,-99) , 
1, -1.52075, 1, 0, 0.311993,-99) , 
3, -1.3288, 0, 0, 0.493287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0978551,-99) , 
1, 1.94221, 1, 0, 0.475168,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.236958);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0566666, 1, 1, 0.575086,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339583,-99) , 
3, 2.62389, 0, 0, 0.380301,-99) , 
0, 1.59033, 1, 0, 0.513209,-99) , 
NN(
0, 
0, 
-1, 0.301203, 0, -1, 0.217983,-99) , 
3, -1.53958, 0, 0, 0.483661,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.275376);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382108,-99) , 
0, 0.356429, 0, 0, 0.659294,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401353,-99) , 
3, 1.94919, 0, 0, 0.465228,-99) , 
0, 1.16242, 1, 0, 0.533442,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440589,-99) , 
2, -1.38479, 1, 0, 0.637303,-99) , 
NN(
0, 
0, 
-1, -1.08814, 0, -1, 0.391771,-99) , 
1, 1.22072, 0, 0, 0.425519,-99) , 
3, 0.228725, 0, 0, 0.483818,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.175499);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.4282, 1, 1, 0.648764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39275,-99) , 
2, 0.415081, 1, 0, 0.491252,-99) , 
3, 1.11038, 0, 0, 0.528597,-99) , 
NN(
0, 
0, 
-1, 1.7381, 1, -1, 0.183191,-99) , 
0, 3.28655, 1, 0, 0.505863,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.191069);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.885482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496846,-99) , 
2, -1.09981, 1, 0, 0.523765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285476,-99) , 
3, -1.7014, 0, 0, 0.505195,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345512,-99) , 
1, 0.787714, 0, 0, 0.436545,-99) , 
NN(
0, 
0, 
-1, 0.237931, 1, -1, 0.254241,-99) , 
1, 1.02843, 1, 0, 0.373493,-99) , 
1, 0.307447, 1, 0, 0.45725,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.243488);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.583227, 0, 1, 0.707715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370299,-99) , 
3, 0.610291, 0, 0, 0.479263,-99) , 
0, -0.350287, 1, 0, 0.52933,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296167,-99) , 
3, -1.49781, 0, 0, 0.428266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193025,-99) , 
0, -1.76683, 1, 0, 0.353469,-99) , 
3, -0.639447, 0, 0, 0.491666,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.264969);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426517,-99) , 
1, -0.618935, 0, 0, 0.702055,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188962,-99) , 
3, -0.531285, 0, 0, 0.528872,-99) , 
0, -1.42828, 1, 0, 0.561907,-99) , 
NN(
0, 
0, 
-1, 1.81769, 1, -1, 0.235041,-99) , 
0, 3.49521, 1, 0, 0.538534,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.350575);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3406,-99) , 
0, -2.79185, 0, 0, 0.638727,-99) , 
NN(
0, 
0, 
-1, 1.4999, 0, -1, 0.398726,-99) , 
3, 0.976809, 1, 0, 0.561656,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356328,-99) , 
2, 1.03566, 1, 0, 0.527191,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26528,-99) , 
2, -1.86319, 1, 0, 0.308784,-99) , 
3, 0.504621, 0, 0, 0.416213,-99) , 
1, 0.345387, 1, 0, 0.500946,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.181661);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.914083, 0, 1, 0.570819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341836,-99) , 
3, 1.4543, 0, 0, 0.474024,-99) , 
0, 1.53954, 1, 0, 0.531704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.149999,-99) , 
3, -1.80475, 0, 0, 0.520805,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.264878);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343914,-99) , 
0, -3.38168, 0, 0, 0.655992,-99) , 
NN(
0, 
0, 
-1, 1.19046, 1, -1, 0.280711,-99) , 
1, 0.582096, 1, 0, 0.581526,-99) , 
NN(
0, 
0, 
-1, 2.87617, 1, -1, 0.395742,-99) , 
0, -0.947009, 1, 0, 0.44528,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.290203);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702658,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491176,-99) , 
1, 1.05489, 1, 0, 0.650696,-99) , 
NN(
0, 
0, 
-1, 2.47494, 0, -1, 0.345794,-99) , 
2, 1.93437, 1, 0, 0.588377,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408525,-99) , 
2, -0.555247, 0, 0, 0.520939,-99) , 
NN(
0, 
0, 
-1, 0.630875, 0, -1, 0.336517,-99) , 
0, 0.00632581, 1, 0, 0.455227,-99) , 
3, 0.908704, 0, 0, 0.498152,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.183466);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393299,-99) , 
3, 0.0330906, 0, 0, 0.482272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0989138,-99) , 
2, 2.82104, 1, 0, 0.469883,-99) , 
1, -2.0516, 1, 0, 0.485432,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.257648);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.183128, 0, 1, 0.692245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4445,-99) , 
1, -0.259045, 1, 0, 0.514827,-99) , 
0, 0.174965, 0, 0, 0.56596,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406297,-99) , 
2, 1.16235, 1, 0, 0.490234,-99) , 
NN(
0, 
0, 
-1, 0.655322, 1, -1, 0.25219,-99) , 
3, 1.31099, 0, 0, 0.420428,-99) , 
0, 1.068, 1, 0, 0.501826,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.23689);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38286,-99) , 
0, -1.3234, 0, 0, 0.581842,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298626,-99) , 
1, -0.523043, 1, 0, 0.508755,-99) , 
1, -0.36158, 0, 0, 0.554681,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417332,-99) , 
1, -0.182405, 0, 0, 0.525444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151178,-99) , 
0, -2.91449, 1, 0, 0.34608,-99) , 
0, -2.24414, 0, 0, 0.533396,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.230218);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.426454, 0, 1, 0.582184,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391742,-99) , 
0, 3.52334, 0, 0, 0.434153,-99) , 
0, 1.33181, 1, 0, 0.519176,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457877,-99) , 
1, -1.29093, 0, 0, 0.527908,-99) , 
NN(
0, 
0, 
-1, -0.631524, 1, -1, 0.322446,-99) , 
1, -1.02431, 1, 0, 0.410338,-99) , 
1, -0.39136, 0, 0, 0.47622,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.179635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487875,-99) , 
0, 0.853276, 1, 0, 0.5409,-99) , 
0, -0.189145, 1, 0, 0.563128,-99) , 
NN(
NN(
0, 
0, 
-1, 0.343333, 0, 1, 0.536037,-99) , 
NN(
0, 
0, 
-1, 0.907374, 1, -1, 0.288408,-99) , 
1, 0.522288, 1, 0, 0.447286,-99) , 
3, 0.0990605, 0, 0, 0.513484,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.218405);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370964,-99) , 
1, -0.863434, 0, 0, 0.566886,-99) , 
3, -0.0715217, 0, 0, 0.600706,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696536,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498981,-99) , 
0, 2.89653, 1, 0, 0.616326,-99) , 
NN(
0, 
0, 
-1, 1.90234, 1, -1, 0.421277,-99) , 
3, 1.43621, 0, 0, 0.47229,-99) , 
0, -0.691462, 1, 0, 0.510546,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.215267);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491734,-99) , 
2, 1.04451, 1, 0, 0.588847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421809,-99) , 
1, -1.15459, 1, 0, 0.449588,-99) , 
0, 1.05162, 0, 0, 0.495065,-99) , 
NN(
0, 
0, 
-1, 3.82254, 1, -1, 0.228794,-99) , 
2, 1.9346, 1, 0, 0.477023,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.278149);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.249118, 0, 1, 0.607707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.744417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325987,-99) , 
0, -1.75521, 1, 0, 0.417392,-99) , 
3, -0.22014, 0, 0, 0.560678,-99) , 
NN(
0, 
0, 
-1, -1.65416, 1, -1, 0.288657,-99) , 
3, -1.3288, 0, 0, 0.535569,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.252375);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862525,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403464,-99) , 
0, 0.00274808, 0, 0, 0.562223,-99) , 
NN(
0, 
0, 
-1, -0.274032, 0, -1, 0.391196,-99) , 
1, -0.506831, 1, 0, 0.442706,-99) , 
1, 1.89479, 0, 0, 0.455088,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.281632);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419834,-99) , 
0, 1.00599, 1, 0, 0.661272,-99) , 
1, -1.38165, 0, 0, 0.730601,-99) , 
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.605849,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324899,-99) , 
3, 1.1543, 0, 0, 0.472212,-99) , 
2, 0.161708, 1, 0, 0.536009,-99) , 
1, -1.15254, 1, 0, 0.555363,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.241779);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409013,-99) , 
2, 0.121621, 1, 0, 0.479799,-99) , 
NN(
0, 
0, 
-1, -2.74077, 1, -1, 0.291745,-99) , 
3, -1.47336, 0, 0, 0.464726,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660696,-99) , 
NN(
0, 
0, 
-1, -0.437345, 0, -1, 0.123264,-99) , 
3, 2.9215, 0, 0, 0.245489,-99) , 
0, 3.20387, 1, 0, 0.437306,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.296821);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.917451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376247,-99) , 
3, -1.53226, 0, 0, 0.548846,-99) , 
1, -0.81389, 1, 0, 0.632065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381314,-99) , 
0, 0.835684, 1, 0, 0.451912,-99) , 
NN(
0, 
0, 
-1, -0.313701, 0, -1, 0.295328,-99) , 
2, -0.329464, 0, 0, 0.411878,-99) , 
0, -1.676, 1, 0, 0.44463,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.324884);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359714,-99) , 
0, -0.0267238, 1, 0, 0.689906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313222,-99) , 
0, -2.56068, 1, 0, 0.525403,-99) , 
3, -1.06333, 0, 0, 0.624068,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440202,-99) , 
1, 0.0462137, 1, 0, 0.582923,-99) , 
NN(
0, 
0, 
-1, 0.384363, 1, -1, 0.379911,-99) , 
0, 1.53037, 0, 0, 0.469469,-99) , 
2, -0.370265, 1, 0, 0.514301,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.149352);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176136,-99) , 
0, 4.17192, 1, 0, 0.505144,-99) , 
2, -0.879114, 1, 0, 0.527801,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355699,-99) , 
1, -0.0103543, 1, 0, 0.508836,-99) , 
NN(
0, 
0, 
-1, -2.13241, 1, -1, 0.145364,-99) , 
0, -2.71041, 1, 0, 0.338073,-99) , 
3, -1.04489, 0, 0, 0.501523,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.221017);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358803,-99) , 
1, 1.12229, 1, 0, 0.591465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307008,-99) , 
1, -1.81465, 0, 0, 0.572,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391886,-99) , 
1, -0.31741, 0, 0, 0.46306,-99) , 
NN(
0, 
0, 
-1, 0.699652, 0, -1, 0.232282,-99) , 
0, 0.489643, 1, 0, 0.419338,-99) , 
2, 0.161708, 0, 0, 0.50053,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.199879);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.238595, 1, 1, 0.567351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365456,-99) , 
1, 0.651998, 0, 0, 0.409218,-99) , 
3, -0.0185302, 0, 0, 0.499135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142801,-99) , 
0, 3.94239, 1, 0, 0.48575,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.187032);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.969068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455157,-99) , 
3, -0.748168, 1, 0, 0.638582,-99) , 
3, 0.821235, 0, 0, 0.770213,-99) , 
NN(
NN(
0, 
0, 
-1, -1.03594, 0, 1, 0.687455,-99) , 
NN(
0, 
0, 
-1, 2.02693, 1, -1, 0.441424,-99) , 
1, -0.904265, 1, 0, 0.464321,-99) , 
1, -1.36371, 1, 0, 0.493701,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.174691);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.94624, 1, 1, 0.783291,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415827,-99) , 
2, -0.336348, 0, 0, 0.514638,-99) , 
0, -1.51268, 1, 0, 0.536043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677,-99) , 
NN(
0, 
0, 
-1, -2.80619, 1, -1, 0.214368,-99) , 
0, -3.77493, 1, 0, 0.347797,-99) , 
3, -1.1555, 0, 0, 0.516445,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.230694);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.76404, 1, 1, 0.593079,-99) , 
NN(
0, 
0, 
-1, -3.02484, 1, -1, 0.341505,-99) , 
3, -1.48552, 0, 0, 0.561804,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443329,-99) , 
3, 1.33526, 0, 0, 0.533039,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261075,-99) , 
2, 1.52151, 0, 0, 0.378418,-99) , 
0, 2.03125, 1, 0, 0.438759,-99) , 
0, 0.842728, 1, 0, 0.503835,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.183786);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497628,-99) , 
3, 0.778628, 0, 0, 0.558335,-99) , 
NN(
0, 
0, 
-1, 1.60273, 0, -1, 0.418326,-99) , 
2, 1.3386, 1, 0, 0.5236,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462301,-99) , 
1, -0.668865, 0, 0, 0.589987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0159189,-99) , 
1, 0.0302751, 1, 0, 0.372774,-99) , 
3, -1.03236, 0, 0, 0.504454,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.285944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5231, 1, 1, 0.623283,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397026,-99) , 
3, 0.453818, 1, 0, 0.455454,-99) , 
1, 0.414129, 0, 0, 0.515855,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381945,-99) , 
0, -1.9077, 0, 0, 0.50816,-99) , 
NN(
0, 
0, 
-1, -0.776986, 0, -1, 0.274817,-99) , 
0, -1.48902, 1, 0, 0.389688,-99) , 
3, -0.202496, 0, 0, 0.481938,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.21625);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.8459, 0, 1, 0.776144,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.123783,-99) , 
3, -1.00967, 0, 0, 0.543444,-99) , 
NN(
0, 
0, 
-1, 1.36262, 0, -1, 0.333492,-99) , 
1, 0.922646, 1, 0, 0.511258,-99) , 
0, -2.25694, 1, 0, 0.537161,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.201692);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.953994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490353,-99) , 
0, 1.73098, 1, 0, 0.649923,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434092,-99) , 
3, 0.0927307, 1, 0, 0.522196,-99) , 
3, 1.04565, 0, 0, 0.541218,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715067,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440686,-99) , 
2, 1.37625, 1, 0, 0.501459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246148,-99) , 
1, -0.962313, 0, 0, 0.450108,-99) , 
2, 1.08824, 1, 0, 0.517419,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.160471);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.850306,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366074,-99) , 
3, -0.756041, 0, 0, 0.487623,-99) , 
NN(
0, 
0, 
-1, -0.319045, 0, -1, 0.299477,-99) , 
1, -0.917174, 0, 0, 0.450457,-99) , 
1, -2.34202, 1, 0, 0.46558,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.172794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0543557, 0, 1, 0.750678,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.802099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344464,-99) , 
0, -2.75678, 1, 0, 0.567463,-99) , 
1, 0.375253, 1, 0, 0.684334,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184238,-99) , 
3, -0.696533, 0, 0, 0.511675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.102876,-99) , 
0, 4.08242, 1, 0, 0.498176,-99) , 
2, -0.864765, 1, 0, 0.530108,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.151356);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.954113,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49271,-99) , 
0, 2.19696, 1, 0, 0.652466,-99) , 
NN(
0, 
0, 
-1, 0.126826, 1, -1, 0.448524,-99) , 
3, 1.53047, 0, 0, 0.476083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169604,-99) , 
0, 3.94239, 1, 0, 0.46599,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.198047);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366958,-99) , 
3, -1.93529, 0, 0, 0.595494,-99) , 
3, -0.180746, 0, 0, 0.641263,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449892,-99) , 
3, 2.18232, 0, 0, 0.467991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307884,-99) , 
0, 3.72325, 1, 0, 0.458031,-99) , 
0, -0.707105, 1, 0, 0.509261,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.202456);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.265679, 1, 1, 0.697801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494439,-99) , 
1, -0.969371, 1, 0, 0.519702,-99) , 
0, -0.000425134, 0, 0, 0.557918,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332124,-99) , 
3, 1.77814, 1, 0, 0.437826,-99) , 
NN(
0, 
0, 
-1, 0.0858092, 1, -1, 0.183682,-99) , 
3, 0.397274, 0, 0, 0.375509,-99) , 
2, 0.162129, 1, 0, 0.453768,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.233327);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311261,-99) , 
1, 2.0434, 1, 0, 0.634941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426399,-99) , 
2, -0.991464, 0, 0, 0.58894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429252,-99) , 
2, 0.412388, 1, 0, 0.504014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260024,-99) , 
3, 1.00206, 0, 0, 0.351367,-99) , 
1, 0.206934, 1, 0, 0.462834,-99) , 
1, 0.820442, 0, 0, 0.490443,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.196182);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.43334, 1, 1, 0.556417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285446,-99) , 
3, -0.528441, 0, 0, 0.535809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385127,-99) , 
1, 0.301203, 0, 0, 0.583487,-99) , 
NN(
0, 
0, 
-1, -1.18472, 0, -1, 0.239274,-99) , 
0, -2.67701, 1, 0, 0.389719,-99) , 
3, -0.786928, 0, 0, 0.510931,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.146943);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.580852, 1, 1, 0.699704,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383508,-99) , 
3, -0.988878, 0, 0, 0.52241,-99) , 
1, -1.37597, 1, 0, 0.537106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133386,-99) , 
2, -2.07855, 0, 0, 0.525082,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.238257);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.933716, 0, 1, 0.59732,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372766,-99) , 
1, -0.641355, 1, 0, 0.447755,-99) , 
3, 1.62579, 1, 0, 0.571907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65971,-99) , 
NN(
0, 
0, 
-1, 1.24615, 0, -1, 0.317455,-99) , 
3, -0.619964, 1, 0, 0.390972,-99) , 
1, 1.08213, 1, 0, 0.544994,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.315351);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781614,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353271,-99) , 
1, -0.930942, 1, 0, 0.516076,-99) , 
3, 1.69293, 0, 0, 0.559207,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434805,-99) , 
2, 0.30114, 1, 0, 0.47911,-99) , 
NN(
0, 
0, 
-1, -2.07681, 1, -1, 0.278705,-99) , 
3, 0.254861, 0, 0, 0.385267,-99) , 
1, -0.636138, 1, 0, 0.431603,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.298538);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.977371, 0, 1, 0.605724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272932,-99) , 
1, -1.18078, 0, 0, 0.559319,-99) , 
NN(
NN(
0, 
0, 
-1, 1.33167, 0, 1, 0.717122,-99) , 
NN(
0, 
0, 
-1, 0.12062, 1, -1, 0.347142,-99) , 
1, 1.24965, 0, 0, 0.378345,-99) , 
0, 0.0848771, 1, 0, 0.445847,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.299493);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.23021, 1, 1, 0.806194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442023,-99) , 
0, 3.86159, 1, 0, 0.684343,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419559,-99) , 
1, -0.568523, 0, 0, 0.51996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321614,-99) , 
2, 1.02789, 0, 0, 0.351577,-99) , 
1, 0.11003, 1, 0, 0.443557,-99) , 
3, 2.00287, 0, 0, 0.469897,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.242976);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187369,-99) , 
2, -1.60891, 0, 0, 0.562649,-99) , 
NN(
0, 
0, 
-1, -0.823359, 1, -1, 0.402107,-99) , 
1, -0.342565, 0, 0, 0.494347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.105083,-99) , 
1, 2.18725, 1, 0, 0.478548,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.226033);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265961,-99) , 
0, 4.01344, 1, 0, 0.623003,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441273,-99) , 
0, -1.64383, 1, 0, 0.466392,-99) , 
3, 1.9863, 0, 0, 0.495366,-99) , 
NN(
0, 
0, 
-1, -2.56068, 1, -1, 0.296198,-99) , 
3, -1.21576, 0, 0, 0.474297,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.255118);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.635039, 1, 1, 0.629278,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44554,-99) , 
3, 2.93183, 0, 0, 0.479474,-99) , 
2, 0.694561, 1, 0, 0.565981,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402494,-99) , 
2, -1.62208, 0, 0, 0.535487,-99) , 
NN(
0, 
0, 
-1, -0.784223, 1, -1, 0.276604,-99) , 
2, -0.806406, 1, 0, 0.425261,-99) , 
3, -0.304384, 0, 0, 0.522636,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.227425);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.880382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490439,-99) , 
3, 0.399415, 0, 0, 0.690157,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480144,-99) , 
1, -0.636138, 1, 0, 0.515188,-99) , 
0, 0.636078, 1, 0, 0.552287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455439,-99) , 
1, -0.610343, 1, 0, 0.539428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260668,-99) , 
3, -0.0751255, 0, 0, 0.333812,-99) , 
0, -1.26906, 1, 0, 0.42474,-99) , 
3, 0.0990605, 0, 0, 0.505963,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.26659);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.641462, 1, 1, 0.83022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362633,-99) , 
3, 1.26038, 0, 0, 0.525202,-99) , 
0, 1.16902, 1, 0, 0.575168,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558927,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180226,-99) , 
1, 1.48945, 1, 0, 0.517299,-99) , 
NN(
0, 
0, 
-1, -0.221614, 1, -1, 0.305178,-99) , 
0, 0.13276, 1, 0, 0.455263,-99) , 
3, 0.738177, 0, 0, 0.504844,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.224518);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868382,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479378,-99) , 
0, 2.54906, 1, 0, 0.74082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467887,-99) , 
2, -0.703564, 1, 0, 0.518546,-99) , 
0, 1.54353, 0, 0, 0.562914,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476581,-99) , 
2, 1.86924, 1, 0, 0.612843,-99) , 
NN(
0, 
0, 
-1, 1.85567, 0, -1, 0.340101,-99) , 
1, 0.425951, 0, 0, 0.439309,-99) , 
2, 1.47382, 1, 0, 0.539982,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.193007);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.40598, 0, 1, 0.787913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459105,-99) , 
1, 0.225534, 0, 0, 0.503602,-99) , 
3, 1.3634, 0, 0, 0.529322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704703,-99) , 
NN(
0, 
0, 
-1, 1.52759, 0, -1, 0.360114,-99) , 
1, 1.41092, 0, 0, 0.410515,-99) , 
0, 1.96067, 1, 0, 0.497491,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.291327);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394344,-99) , 
2, -0.164983, 0, 0, 0.634696,-99) , 
NN(
0, 
0, 
-1, 2.81647, 0, -1, 0.328677,-99) , 
0, 3.92019, 1, 0, 0.600232,-99) , 
NN(
NN(
0, 
0, 
-1, -1.47444, 1, 1, 0.723953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530223,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33364,-99) , 
0, -0.887757, 1, 0, 0.416603,-99) , 
1, -0.97244, 1, 0, 0.461848,-99) , 
3, 0.392653, 0, 0, 0.535777,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.106691);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47701,-99) , 
0, 3.73618, 1, 0, 0.68774,-99) , 
NN(
NN(
0, 
0, 
-1, -2.02965, 0, 1, 0.710894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319732,-99) , 
3, -0.731123, 0, 0, 0.476774,-99) , 
0, -2.816, 1, 0, 0.496341,-99) , 
2, 1.90789, 0, 0, 0.511,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.243548);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466055,-99) , 
1, 0.420603, 1, 0, 0.54346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.122074,-99) , 
1, -0.496792, 0, 0, 0.383987,-99) , 
0, 2.75797, 1, 0, 0.515163,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303782,-99) , 
0, -3.44855, 0, 0, 0.596537,-99) , 
NN(
0, 
0, 
-1, -1.20208, 1, -1, 0.220669,-99) , 
0, -2.41898, 1, 0, 0.38433,-99) , 
3, -0.716903, 0, 0, 0.488736,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.201223);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.37324, 1, 1, 0.6493,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444616,-99) , 
0, 0.453877, 1, 0, 0.514912,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581191,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217015,-99) , 
0, -2.48686, 1, 0, 0.376629,-99) , 
3, -0.795801, 0, 0, 0.494573,-99) , 
1, -1.15254, 1, 0, 0.511656,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.106151);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.975599,-99) , 
NN(
NN(
0, 
0, 
-1, -1.81389, 1, 1, 0.529432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.166074,-99) , 
3, -1.73763, 0, 0, 0.51489,-99) , 
3, 3.43073, 0, 0, 0.526842,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.206869);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922989,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450388,-99) , 
0, 1.89207, 1, 0, 0.529406,-99) , 
NN(
0, 
0, 
-1, -0.15637, 1, -1, 0.381586,-99) , 
3, 0.17816, 0, 0, 0.464982,-99) , 
1, -2.03415, 1, 0, 0.476772,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.321684);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3406,-99) , 
2, -0.558031, 0, 0, 0.630925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406097,-99) , 
0, 0.548075, 1, 0, 0.474068,-99) , 
1, -0.994277, 0, 0, 0.567934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673409,-99) , 
NN(
0, 
0, 
-1, 1.70213, 1, -1, 0.335717,-99) , 
0, 3.48258, 0, 0, 0.365149,-99) , 
1, -0.237385, 1, 0, 0.445717,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.243694);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.538436, 0, 1, 0.719319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.848415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455298,-99) , 
3, 3.069, 0, 0, 0.531031,-99) , 
3, 1.80372, 1, 0, 0.610198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355865,-99) , 
2, 0.058989, 1, 0, 0.49477,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249543,-99) , 
1, -0.249118, 0, 0, 0.368293,-99) , 
0, 0.530826, 1, 0, 0.457088,-99) , 
3, 1.04759, 0, 0, 0.50417,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.158548);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469665,-99) , 
0, 1.56444, 1, 0, 0.538143,-99) , 
3, 3.15903, 0, 0, 0.549279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20363,-99) , 
2, -1.79575, 0, 0, 0.538262,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.148171);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689926,-99) , 
NN(
0, 
0, 
-1, -1.9557, 0, -1, 0.431093,-99) , 
3, 2.84616, 0, 0, 0.44102,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.257845);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.728565, 0, 1, 0.605803,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355602,-99) , 
0, -1.81045, 1, 0, 0.447069,-99) , 
NN(
0, 
0, 
-1, -2.06798, 1, -1, 0.266159,-99) , 
3, -1.60193, 0, 0, 0.418027,-99) , 
3, -0.123397, 0, 0, 0.544088,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.207909);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455748,-99) , 
0, 2.24554, 1, 0, 0.566549,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225119,-99) , 
0, 4.06202, 1, 0, 0.552475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0767341,-99) , 
3, -1.87204, 0, 0, 0.538016,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.215526);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374194,-99) , 
2, -0.130667, 0, 0, 0.521529,-99) , 
3, -0.331758, 1, 0, 0.553041,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334751,-99) , 
1, -0.339497, 1, 0, 0.435061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112138,-99) , 
1, -1.0491, 0, 0, 0.367752,-99) , 
3, -0.852844, 0, 0, 0.527408,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.267224);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45121, 0, 1, 0.653741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314902,-99) , 
3, 2.37722, 1, 0, 0.392534,-99) , 
2, 1.81702, 1, 0, 0.580693,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455299,-99) , 
0, 0.625993, 0, 0, 0.482511,-99) , 
NN(
0, 
0, 
-1, 0.288597, 0, -1, 0.283477,-99) , 
2, 0.141573, 1, 0, 0.401538,-99) , 
3, 1.06161, 0, 0, 0.460625,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.238114);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0492841, 0, 1, 0.685028,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265136,-99) , 
2, 0.41478, 1, 0, 0.489771,-99) , 
3, 0.661204, 0, 0, 0.516298,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451092,-99) , 
1, 0.163133, 1, 0, 0.537057,-99) , 
NN(
0, 
0, 
-1, 1.03321, 1, -1, 0.290746,-99) , 
3, 1.62484, 0, 0, 0.398336,-99) , 
0, 1.34917, 1, 0, 0.468829,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.247753);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.34892, 0, 1, 0.757757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346947,-99) , 
0, 3.70759, 1, 0, 0.646287,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324029,-99) , 
3, -1.3554, 0, 0, 0.567387,-99) , 
NN(
0, 
0, 
-1, -0.472981, 0, -1, 0.425122,-99) , 
0, -1.07361, 1, 0, 0.458747,-99) , 
3, 1.99567, 0, 0, 0.487925,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.148222);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.10199, 0, 1, 0.7518,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309518,-99) , 
0, 2.7218, 1, 0, 0.501046,-99) , 
3, 2.71158, 0, 0, 0.51818,-99) , 
NN(
0, 
0, 
-1, -0.301872, 0, -1, 0.161498,-99) , 
3, -1.26149, 0, 0, 0.495487,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.171512);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.11586, 1, 1, 0.760174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475985,-99) , 
0, -0.196644, 1, 0, 0.509167,-99) , 
NN(
0, 
0, 
-1, -0.325584, 1, -1, 0.239973,-99) , 
3, -1.15643, 0, 0, 0.480028,-99) , 
1, 1.66439, 0, 0, 0.500611,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.299477);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.852167, 1, 1, 0.7878,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289827,-99) , 
2, 0.536835, 0, 0, 0.548344,-99) , 
2, 0.336434, 1, 0, 0.585185,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79305,-99) , 
NN(
0, 
0, 
-1, -0.313683, 0, -1, 0.3598,-99) , 
0, -3.97992, 1, 0, 0.3893,-99) , 
3, 0.28719, 0, 0, 0.507945,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.215497);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.568294, 0, 1, 0.670943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462187,-99) , 
1, 0.494071, 0, 0, 0.508641,-99) , 
2, 0.760061, 1, 0, 0.568996,-99) , 
NN(
0, 
0, 
-1, 1.05883, 1, -1, 0.387212,-99) , 
2, -0.0385962, 0, 0, 0.50616,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.243496);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447213,-99) , 
1, -0.585885, 0, 0, 0.563851,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252099,-99) , 
1, 1.71807, 1, 0, 0.549203,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356133,-99) , 
2, 1.54331, 1, 0, 0.425413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187332,-99) , 
2, 1.04107, 0, 0, 0.332423,-99) , 
0, 2.20475, 1, 0, 0.50404,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.203505);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.852457, 1, 1, 0.852027,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471581,-99) , 
2, -1.14527, 1, 0, 0.533626,-99) , 
3, 0.527179, 0, 0, 0.579442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656328,-99) , 
NN(
0, 
0, 
-1, -0.920071, 0, -1, 0.423657,-99) , 
1, -1.15254, 1, 0, 0.447546,-99) , 
0, 0.861216, 1, 0, 0.521141,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.211341);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.901499,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464208,-99) , 
3, -0.366581, 0, 0, 0.566876,-99) , 
1, 1.40458, 0, 0, 0.593606,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373552,-99) , 
1, 0.907623, 1, 0, 0.488067,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236932,-99) , 
3, 0.911966, 1, 0, 0.395297,-99) , 
3, 1.11889, 0, 0, 0.457464,-99) , 
0, 0.861216, 1, 0, 0.52315,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.140413);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0106809, 0, 1, 0.615775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255799,-99) , 
1, -1.81119, 0, 0, 0.494838,-99) , 
2, -0.190477, 1, 0, 0.52837,-99) , 
NN(
0, 
0, 
-1, -1.60276, 0, -1, 0.276523,-99) , 
2, -1.199, 0, 0, 0.506418,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.174572);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.162732, 0, 1, 0.609953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515203,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.270359,-99) , 
3, 0.482668, 0, 0, 0.474433,-99) , 
0, 0.174486, 1, 0, 0.531049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.105167,-99) , 
0, 3.94239, 1, 0, 0.516597,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.246367);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489508,-99) , 
2, -0.490473, 1, 0, 0.543702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.150709,-99) , 
1, 0.608915, 0, 0, 0.336224,-99) , 
3, -1.27416, 0, 0, 0.519796,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261525,-99) , 
3, 2.61175, 0, 0, 0.340122,-99) , 
0, 1.56394, 1, 0, 0.409064,-99) , 
2, 1.2182, 1, 0, 0.48852,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.217496);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41431,-99) , 
0, 2.60073, 1, 0, 0.594935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434018,-99) , 
3, 1.5579, 0, 0, 0.463085,-99) , 
1, 0.351767, 0, 0, 0.504616,-99) , 
NN(
0, 
0, 
-1, -2.84474, 1, -1, 0.194334,-99) , 
3, -1.1555, 0, 0, 0.478811,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.266993);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473998,-99) , 
0, -0.523137, 0, 0, 0.597497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328506,-99) , 
3, 2.09496, 0, 0, 0.417279,-99) , 
2, 0.979295, 1, 0, 0.525602,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385836,-99) , 
1, 0.207887, 1, 0, 0.422788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190554,-99) , 
2, -1.72903, 0, 0, 0.409662,-99) , 
1, -0.290636, 1, 0, 0.457066,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.259215);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434646,-99) , 
1, 0.820442, 1, 0, 0.599857,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387933,-99) , 
1, -0.572275, 1, 0, 0.432156,-99) , 
3, 0.724595, 0, 0, 0.497967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57643,-99) , 
NN(
0, 
0, 
-1, 2.81849, 1, -1, 0.225036,-99) , 
3, 2.6232, 0, 0, 0.312162,-99) , 
2, 1.52556, 1, 0, 0.466706,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.148405);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44966, 1, 1, 0.738449,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491154,-99) , 
1, 1.32833, 0, 0, 0.517542,-99) , 
2, 1.0939, 0, 0, 0.550859,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -1, 0.482764,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176918,-99) , 
3, 2.26879, 0, 0, 0.306501,-99) , 
0, 3.93835, 0, 0, 0.363479,-99) , 
0, 2.67663, 1, 0, 0.527917,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.193906);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470106,-99) , 
1, 0.509578, 0, 0, 0.653324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451699,-99) , 
0, -0.431281, 1, 0, 0.50607,-99) , 
3, 1.59556, 0, 0, 0.523955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648643,-99) , 
NN(
0, 
0, 
-1, 1.67843, 0, -1, 0.216334,-99) , 
1, 0.835568, 0, 0, 0.368366,-99) , 
0, 3.19023, 1, 0, 0.506715,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.18131);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.994876, 1, 1, 0.628466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366604,-99) , 
1, 1.56713, 1, 0, 0.57988,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725627,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484549,-99) , 
3, 1.36587, 0, 0, 0.52695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357029,-99) , 
1, 0.330435, 0, 0, 0.410823,-99) , 
1, -0.252462, 1, 0, 0.481006,-99) , 
1, 0.564685, 0, 0, 0.507804,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.279238);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.87123, 1, 1, 0.668314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164085,-99) , 
3, -1.78853, 0, 0, 0.629764,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381078,-99) , 
1, 0.728565, 1, 0, 0.600745,-99) , 
NN(
0, 
0, 
-1, -1.03382, 0, -1, 0.432767,-99) , 
2, 1.02928, 0, 0, 0.498692,-99) , 
2, 0.109572, 1, 0, 0.553161,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.322602);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0345419, 0, 1, 0.683737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225867,-99) , 
0, 1.96513, 0, 0, 0.48503,-99) , 
0, 1.72608, 1, 0, 0.607233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412003,-99) , 
1, 0.412194, 0, 0, 0.636432,-99) , 
NN(
0, 
0, 
-1, -2.09258, 1, -1, 0.209029,-99) , 
0, -2.85873, 1, 0, 0.393949,-99) , 
2, -1.44705, 0, 0, 0.57956,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.182681);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.789581, 1, 1, 0.554938,-99) , 
NN(
0, 
0, 
-1, -1.32723, 1, -1, 0.402474,-99) , 
3, -0.55217, 0, 0, 0.515394,-99) , 
NN(
0, 
0, 
-1, 2.5434, 1, -1, 0.206796,-99) , 
2, 1.81563, 1, 0, 0.482318,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.227312);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468622,-99) , 
3, -0.49624, 0, 0, 0.64628,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330058,-99) , 
0, 1.83455, 1, 0, 0.51131,-99) , 
1, -0.541305, 1, 0, 0.550333,-99) , 
NN(
0, 
0, 
-1, 0.163133, 1, -1, 0.273013,-99) , 
0, 2.39256, 1, 0, 0.510684,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.301483);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430185,-99) , 
0, 1.47319, 1, 0, 0.61753,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33693,-99) , 
2, 1.83351, 0, 0, 0.427523,-99) , 
2, 0.895828, 1, 0, 0.54638,-99) , 
NN(
0, 
0, 
-1, -0.824351, 0, -1, 0.35709,-99) , 
1, 0.494071, 1, 0, 0.487017,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.248812);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825667,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368987,-99) , 
3, -1.77545, 0, 0, 0.615414,-99) , 
3, -1.15197, 0, 0, 0.676707,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.928079,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445046,-99) , 
1, -1.39701, 1, 0, 0.470478,-99) , 
NN(
0, 
0, 
-1, -0.610028, 0, -1, 0.223518,-99) , 
0, -0.72404, 0, 0, 0.433996,-99) , 
0, -1.55531, 1, 0, 0.468835,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.181035);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.324373, 0, 1, 0.775123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494014,-99) , 
1, -0.876513, 1, 0, 0.532428,-99) , 
2, -0.487843, 1, 0, 0.566489,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187377,-99) , 
1, -0.281116, 0, 0, 0.372185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.138613,-99) , 
0, -1.74145, 1, 0, 0.301359,-99) , 
3, -0.786928, 0, 0, 0.536993,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.22254);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427619,-99) , 
3, 1.74598, 1, 0, 0.576891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365942,-99) , 
1, 1.56529, 1, 0, 0.565019,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567115,-99) , 
NN(
0, 
0, 
-1, 2.49787, 0, -1, 0.246398,-99) , 
1, -0.720272, 1, 0, 0.331435,-99) , 
2, 1.51538, 1, 0, 0.531588,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.38978);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.263306, 1, 1, 0.689,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630722,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.192865,-99) , 
1, -0.126927, 0, 0, 0.393321,-99) , 
2, 1.27514, 1, 0, 0.577404,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440814,-99) , 
2, -0.822142, 0, 0, 0.54774,-99) , 
NN(
0, 
0, 
-1, -0.529435, 0, -1, 0.265631,-99) , 
0, -0.755119, 1, 0, 0.441725,-99) , 
3, 0.228725, 0, 0, 0.521764,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.256693);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0454527, 1, 1, 0.639632,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314532,-99) , 
2, 0.424909, 1, 0, 0.489863,-99) , 
3, 1.28993, 0, 0, 0.522518,-99) , 
NN(
0, 
0, 
-1, 2.62392, 0, -1, 0.281592,-99) , 
0, 3.19023, 1, 0, 0.503293,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.138643);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388486,-99) , 
1, -0.93943, 0, 0, 0.51178,-99) , 
NN(
0, 
0, 
-1, 0.194772, 1, -1, 0.372828,-99) , 
3, -0.770221, 0, 0, 0.488077,-99) , 
1, -2.00084, 1, 0, 0.497383,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.160957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386914,-99) , 
1, -0.131259, 0, 0, 0.458873,-99) , 
1, -1.21016, 1, 0, 0.479024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.128777,-99) , 
0, -0.142359, 0, 0, 0.282329,-99) , 
1, -1.69964, 0, 0, 0.465618,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.264699);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.203191, 0, 1, 0.640715,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440868,-99) , 
0, 3.21646, 0, 0, 0.465129,-99) , 
1, 0.154858, 1, 0, 0.53272,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.974923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360638,-99) , 
3, -0.584245, 0, 0, 0.559244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154982,-99) , 
0, 1.75954, 0, 0, 0.294056,-99) , 
0, 0.68939, 1, 0, 0.431962,-99) , 
1, -0.759733, 0, 0, 0.50959,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.24796);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.165021, 1, 1, 0.792534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364223,-99) , 
3, 1.27768, 0, 0, 0.528284,-99) , 
0, 0.717554, 1, 0, 0.566687,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448392,-99) , 
0, -0.725461, 0, 0, 0.515457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320391,-99) , 
1, -0.542253, 1, 0, 0.379461,-99) , 
2, -0.225821, 1, 0, 0.449774,-99) , 
2, 0.604931, 0, 0, 0.497854,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.33275);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.8759, 0, 1, 0.691689,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357711,-99) , 
3, 2.3801, 0, 0, 0.494928,-99) , 
0, 2.27263, 1, 0, 0.589367,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355859,-99) , 
3, 1.15798, 0, 0, 0.373469,-99) , 
2, -1.79777, 1, 0, 0.403181,-99) , 
2, 0.524348, 0, 0, 0.480315,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.205587);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.282105, 0, 1, 0.670975,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324243,-99) , 
3, 0.458173, 0, 0, 0.512945,-99) , 
0, 0.0999626, 1, 0, 0.546015,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632358,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394059,-99) , 
3, -1.1231, 0, 0, 0.509088,-99) , 
NN(
0, 
0, 
-1, -0.287561, 0, -1, 0.310088,-99) , 
0, -1.17657, 1, 0, 0.422802,-99) , 
3, -0.202496, 0, 0, 0.510148,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.236719);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.38645, 1, 1, 0.604217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297709,-99) , 
3, -1.53193, 0, 0, 0.563966,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548542,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39805,-99) , 
0, 1.65653, 1, 0, 0.463669,-99) , 
NN(
0, 
0, 
-1, 1.0924, 0, -1, 0.296014,-99) , 
1, -0.636138, 0, 0, 0.414308,-99) , 
0, 0.443786, 1, 0, 0.476354,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.272437);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -2.77104, 1, 1, 0.702813,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378739,-99) , 
3, -0.174396, 0, 0, 0.487114,-99) , 
NN(
0, 
0, 
-1, 1.75885, 0, -1, 0.354507,-99) , 
0, 1.63755, 1, 0, 0.434292,-99) , 
1, -0.759733, 1, 0, 0.491139,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.190256);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.407771, 0, 1, 0.565979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276355,-99) , 
3, 1.08593, 0, 0, 0.449597,-99) , 
0, 0.764784, 1, 0, 0.510769,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655303,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12994,-99) , 
2, -0.438192, 1, 0, 0.241161,-99) , 
0, 1.93865, 0, 0, 0.325033,-99) , 
1, 1.33813, 1, 0, 0.484668,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.179539);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273265,-99) , 
1, -1.6528, 0, 0, 0.526186,-99) , 
1, -2.02699, 1, 0, 0.649378,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47704,-99) , 
1, -0.211539, 1, 0, 0.50374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.150375,-99) , 
2, 0.0693903, 0, 0, 0.293835,-99) , 
1, -0.80161, 0, 0, 0.474017,-99) , 
1, -1.24131, 1, 0, 0.491987,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.249881);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.787796, 1, 1, 0.700249,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389827,-99) , 
0, 1.33807, 1, 0, 0.486913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29433,-99) , 
1, -1.39147, 1, 0, 0.331667,-99) , 
1, -0.359664, 0, 0, 0.433602,-99) , 
0, -2.24141, 1, 0, 0.464834,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.246957);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.10726, 0, 1, 0.662836,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399378,-99) , 
1, -0.233935, 0, 0, 0.537731,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266132,-99) , 
0, 0.504435, 1, 0, 0.391985,-99) , 
3, 1.27757, 0, 0, 0.447571,-99) , 
0, -1.4678, 1, 0, 0.485192,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.317919);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485764,-99) , 
3, 1.68021, 0, 0, 0.623143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278863,-99) , 
0, 3.97687, 1, 0, 0.575919,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342845,-99) , 
3, -1.94991, 0, 0, 0.63241,-99) , 
NN(
0, 
0, 
-1, -0.150971, 0, -1, 0.35373,-99) , 
0, -1.57998, 1, 0, 0.419382,-99) , 
3, 1.13577, 0, 0, 0.467804,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.281293);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43352,-99) , 
2, 0.82309, 1, 0, 0.600867,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344726,-99) , 
3, 1.60241, 0, 0, 0.445515,-99) , 
0, 1.2808, 1, 0, 0.515776,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259952,-99) , 
1, 0.338353, 1, 0, 0.516155,-99) , 
NN(
0, 
0, 
-1, -0.691982, 1, -1, 0.209239,-99) , 
0, -1.96918, 1, 0, 0.35343,-99) , 
3, -0.451327, 0, 0, 0.474838,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.189425);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45853,-99) , 
3, 1.41302, 0, 0, 0.490296,-99) , 
NN(
0, 
0, 
-1, 1.56761, 1, -1, 0.341402,-99) , 
0, 2.80879, 1, 0, 0.471174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197022,-99) , 
2, -1.80314, 0, 0, 0.409764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
0, -2.51191, 1, 0, 0.278634,-99) , 
3, -1.22141, 0, 0, 0.454847,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.110991);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715771,-99) , 
NN(
NN(
0, 
0, 
-1, -1.29686, 1, 1, 0.538862,-99) , 
NN(
0, 
0, 
-1, 0.0952414, 1, -1, 0.37775,-99) , 
3, -1.22141, 0, 0, 0.523574,-99) , 
1, 1.89479, 0, 0, 0.533235,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.200152);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480779,-99) , 
2, 0.421109, 1, 0, 0.549129,-99) , 
NN(
0, 
0, 
-1, -1.38631, 0, -1, 0.370383,-99) , 
3, -0.405423, 0, 0, 0.507835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0448266,-99) , 
0, 3.96657, 1, 0, 0.491657,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.197503);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.27852, 0, 1, 0.760887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417667,-99) , 
0, 2.49454, 1, 0, 0.693299,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441325,-99) , 
3, 0.800662, 0, 0, 0.487007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112505,-99) , 
3, -1.79177, 0, 0, 0.469962,-99) , 
1, 0.988758, 0, 0, 0.510362,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.24204);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.695326, 1, 1, 0.559848,-99) , 
NN(
0, 
0, 
-1, 1.38868, 1, -1, 0.319208,-99) , 
3, 2.09752, 1, 0, 0.520488,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38507,-99) , 
2, -0.50561, 0, 0, 0.477551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142577,-99) , 
0, -0.83579, 1, 0, 0.395251,-99) , 
3, -0.123397, 0, 0, 0.48111,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.185642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204616,-99) , 
3, -1.86557, 0, 0, 0.539507,-99) , 
3, -0.0854323, 0, 0, 0.579496,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.930934,-99) , 
NN(
0, 
0, 
-1, 0.784833, 0, -1, 0.443071,-99) , 
0, -0.0194754, 1, 0, 0.467417,-99) , 
3, 0.183842, 1, 0, 0.509153,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.242497);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469424,-99) , 
1, 0.307447, 1, 0, 0.563087,-99) , 
NN(
0, 
0, 
-1, 0.698887, 1, -1, 0.380035,-99) , 
0, 0.19225, 0, 0, 0.466456,-99) , 
NN(
0, 
0, 
-1, 2.49602, 0, -1, 0.293268,-99) , 
2, 1.51538, 1, 0, 0.440908,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.168556);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.791085, 0, 1, 0.574871,-99) , 
NN(
0, 
0, 
-1, 1.39446, 1, -1, 0.434786,-99) , 
0, 0.0885771, 0, 0, 0.514418,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313823,-99) , 
1, 0.930811, 1, 0, 0.451165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.14727,-99) , 
1, -0.392595, 0, 0, 0.37054,-99) , 
0, 2.65344, 1, 0, 0.489506,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.231294);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.963676, 0, 1, 0.763575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401951,-99) , 
3, 2.25903, 0, 0, 0.488257,-99) , 
0, 1.53685, 1, 0, 0.565929,-99) , 
NN(
NN(
0, 
0, 
-1, -0.837685, 1, 1, 0.590362,-99) , 
NN(
0, 
0, 
-1, 2.01433, 1, -1, 0.405264,-99) , 
2, -0.674312, 1, 0, 0.463666,-99) , 
2, 0.661088, 0, 0, 0.49925,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.182104);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397932,-99) , 
2, 1.32256, 1, 0, 0.525172,-99) , 
NN(
0, 
0, 
-1, 0.250474, 0, -1, 0.272768,-99) , 
1, -1.6752, 0, 0, 0.510289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0119539,-99) , 
2, 2.85892, 1, 0, 0.497506,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.221068);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.945738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17209,-99) , 
1, -0.11153, 0, 0, 0.423664,-99) , 
3, -1.34621, 0, 0, 0.648522,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356542,-99) , 
1, 0.973008, 1, 0, 0.513124,-99) , 
NN(
0, 
0, 
-1, -1.05071, 0, -1, 0.258263,-99) , 
3, -0.547376, 0, 0, 0.485637,-99) , 
0, -1.6888, 1, 0, 0.502857,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.149676);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.784071,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452385,-99) , 
1, -0.322526, 1, 0, 0.489023,-99) , 
NN(
0, 
0, 
-1, 0.932024, 1, -1, 0.309141,-99) , 
1, -1.21497, 0, 0, 0.469735,-99) , 
1, -2.00084, 1, 0, 0.479518,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.178328);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.867987,-99) , 
NN(
NN(
0, 
0, 
-1, 1.90027, 0, 1, 0.755647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513085,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410674,-99) , 
1, -0.511864, 1, 0, 0.441418,-99) , 
1, 1.46436, 0, 0, 0.458603,-99) , 
1, -2.00423, 1, 0, 0.474694,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.302973);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.327595, 1, 1, 0.776882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361279,-99) , 
2, -0.542758, 1, 0, 0.573296,-99) , 
3, -0.287486, 0, 0, 0.613548,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46975,-99) , 
1, 0.501034, 1, 0, 0.52779,-99) , 
NN(
0, 
0, 
-1, 0.406275, 1, -1, 0.343219,-99) , 
1, 0.381048, 0, 0, 0.399835,-99) , 
0, -0.371383, 1, 0, 0.46881,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.230409);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.00933, 1, 1, 0.734215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331384,-99) , 
1, 2.04878, 1, 0, 0.664634,-99) , 
NN(
NN(
0, 
0, 
-1, 1.20655, 1, 1, 0.71431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337782,-99) , 
1, -0.420217, 0, 0, 0.454482,-99) , 
1, -1.13058, 1, 0, 0.490855,-99) , 
1, 0.989266, 0, 0, 0.527603,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.254832);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333258,-99) , 
2, 1.96004, 1, 0, 0.658241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.106679,-99) , 
0, 1.893, 1, 0, 0.503184,-99) , 
2, 0.682241, 0, 0, 0.558947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207392,-99) , 
3, 2.86932, 1, 0, 0.53911,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.228688);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477202,-99) , 
0, -0.661143, 0, 0, 0.676089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414377,-99) , 
1, 1.21541, 0, 0, 0.598475,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407541,-99) , 
3, 1.5444, 0, 0, 0.426959,-99) , 
NN(
0, 
0, 
-1, 2.71747, 0, -1, 0.25586,-99) , 
0, 3.4042, 1, 0, 0.412031,-99) , 
1, 0.973008, 0, 0, 0.443534,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.0977287);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.0326, 0, 1, 0.795829,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729712,-99) , 
NN(
0, 
0, 
-1, -1.54684, 0, -1, 0.477538,-99) , 
0, -2.97825, 1, 0, 0.489115,-99) , 
1, 1.49432, 0, 0, 0.508565,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.199306);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.579032, 0, 1, 0.726581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443004,-99) , 
3, 3.06103, 0, 0, 0.459318,-99) , 
2, -0.812179, 1, 0, 0.481865,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310827,-99) , 
2, -1.71744, 0, 0, 0.441453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0693724,-99) , 
2, -1.35278, 1, 0, 0.32721,-99) , 
3, -1.22141, 0, 0, 0.46634,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.205863);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.9388, 0, 1, 0.800558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328359,-99) , 
3, -1.18251, 0, 0, 0.547827,-99) , 
0, -3.3553, 1, 0, 0.564166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557373,-99) , 
NN(
0, 
0, 
-1, 0.282776, 0, -1, 0.242678,-99) , 
2, 2.43974, 0, 0, 0.340956,-99) , 
2, 1.81563, 1, 0, 0.536923,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.287697);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.28946, 0, 1, 0.690381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.115934,-99) , 
3, -0.674697, 0, 0, 0.474964,-99) , 
1, 0.246493, 1, 0, 0.600891,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454208,-99) , 
2, 0.468238, 1, 0, 0.507641,-99) , 
NN(
0, 
0, 
-1, 0.392467, 1, -1, 0.329531,-99) , 
3, 0.570998, 0, 0, 0.431823,-99) , 
0, -0.947009, 1, 0, 0.467969,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.227997);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.353132, 0, 1, 0.629149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31525,-99) , 
3, -0.152037, 0, 0, 0.371518,-99) , 
1, 0.524261, 1, 0, 0.555461,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466097,-99) , 
3, 1.31827, 0, 0, 0.51381,-99) , 
NN(
0, 
0, 
-1, 0.938558, 0, -1, 0.375816,-99) , 
2, 0.835394, 1, 0, 0.440817,-99) , 
0, 0.0848771, 1, 0, 0.486407,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.294099);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393576,-99) , 
0, 3.11787, 1, 0, 0.601297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201186,-99) , 
2, -1.57101, 0, 0, 0.583192,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245655,-99) , 
1, 2.14713, 1, 0, 0.465159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254275,-99) , 
1, 1.61156, 0, 0, 0.375832,-99) , 
1, 1.41092, 1, 0, 0.558966,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.241101);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468821,-99) , 
1, -0.16641, 0, 0, 0.565457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282039,-99) , 
1, 1.89, 1, 0, 0.552223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715672,-99) , 
NN(
0, 
0, 
-1, 0.0142257, 1, -1, 0.288963,-99) , 
1, 1.18756, 0, 0, 0.384223,-99) , 
3, -0.639447, 0, 0, 0.521139,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.22329);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.33466, 1, 1, 0.698897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344846,-99) , 
2, 0.928498, 1, 0, 0.510103,-99) , 
3, 1.52692, 0, 0, 0.537705,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397743,-99) , 
0, 1.60147, 1, 0, 0.508723,-99) , 
NN(
0, 
0, 
-1, 0.60567, 0, -1, 0.329992,-99) , 
1, 0.749974, 0, 0, 0.412322,-99) , 
1, -0.0229864, 1, 0, 0.469482,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.228386);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.139574, 1, 1, 0.660069,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.80876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444938,-99) , 
0, -2.62795, 1, 0, 0.474163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0793276,-99) , 
3, -2.20119, 0, 0, 0.459622,-99) , 
0, 1.14354, 0, 0, 0.526778,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.301863);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45575,-99) , 
2, 1.58457, 1, 0, 0.596468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393792,-99) , 
0, -1.41332, 1, 0, 0.430214,-99) , 
3, 0.986409, 0, 0, 0.511714,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290678,-99) , 
3, -1.25461, 0, 0, 0.372744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0548363,-99) , 
0, -1.53423, 1, 0, 0.286965,-99) , 
3, -0.786928, 0, 0, 0.474814,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.221623);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394988,-99) , 
3, 0.239248, 0, 0, 0.528716,-99) , 
0, -0.709882, 1, 0, 0.541011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191161,-99) , 
3, -1.97527, 0, 0, 0.544456,-99) , 
NN(
0, 
0, 
-1, -0.567882, 0, -1, 0.32229,-99) , 
0, -1.67341, 1, 0, 0.416902,-99) , 
3, -0.207894, 0, 0, 0.505161,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.243246);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43318,-99) , 
2, -1.1103, 0, 0, 0.5761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381427,-99) , 
3, 1.47263, 0, 0, 0.476399,-99) , 
0, 0.309438, 1, 0, 0.522938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13506,-99) , 
2, 2.32856, 1, 0, 0.509884,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.258528);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.093056, 1, 1, 0.64068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374374,-99) , 
2, -0.590316, 1, 0, 0.511882,-99) , 
2, -0.137049, 0, 0, 0.570378,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423353,-99) , 
2, 1.51514, 1, 0, 0.623283,-99) , 
NN(
0, 
0, 
-1, 0.493179, 1, -1, 0.359889,-99) , 
1, 0.822095, 0, 0, 0.428873,-99) , 
0, 1.33181, 1, 0, 0.518619,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.105236);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.29765, 0, 1, 0.799104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334734,-99) , 
1, 1.46189, 1, 0, 0.500147,-99) , 
2, 2.48923, 0, 0, 0.514472,-99) , 
1, -1.38631, 1, 0, 0.531559,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.261464);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.780734, 1, 1, 0.629562,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411745,-99) , 
1, 1.10863, 0, 0, 0.459136,-99) , 
1, -0.656252, 1, 0, 0.500445,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548662,-99) , 
NN(
0, 
0, 
-1, -0.386487, 0, -1, 0.273712,-99) , 
1, -0.546181, 1, 0, 0.339284,-99) , 
2, -0.585857, 0, 0, 0.462444,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.27727);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89102, 1, 1, 0.601782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30752,-99) , 
1, 1.4007, 1, 0, 0.576297,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350577,-99) , 
3, -0.986033, 0, 0, 0.488494,-99) , 
NN(
0, 
0, 
-1, -0.0734012, 0, -1, 0.279731,-99) , 
3, -0.255942, 1, 0, 0.415051,-99) , 
3, 0.28719, 0, 0, 0.497866,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.235364);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471682,-99) , 
2, -0.0420922, 0, 0, 0.774307,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476197,-99) , 
1, -0.969371, 1, 0, 0.510577,-99) , 
3, 0.0167532, 0, 0, 0.580167,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590738,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220513,-99) , 
0, 3.6422, 1, 0, 0.526089,-99) , 
NN(
0, 
0, 
-1, 0.186954, 1, -1, 0.382142,-99) , 
1, 0.336676, 0, 0, 0.431654,-99) , 
0, 0.764784, 1, 0, 0.511836,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.380566);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.285396, 1, 1, 0.680151,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365205,-99) , 
1, 0.310265, 0, 0, 0.529874,-99) , 
1, -0.374549, 1, 0, 0.583096,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.830742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418448,-99) , 
1, -0.117555, 1, 0, 0.587695,-99) , 
NN(
0, 
0, 
-1, -0.740904, 0, -1, 0.253266,-99) , 
3, 2.00665, 0, 0, 0.4018,-99) , 
2, 1.01587, 1, 0, 0.520622,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.182807);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48478,-99) , 
1, 1.91718, 1, 0, 0.677585,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432712,-99) , 
1, -0.130212, 1, 0, 0.483578,-99) , 
1, 1.49163, 0, 0, 0.502886,-99) , 
NN(
0, 
0, 
-1, -1.40807, 1, -1, 0.218576,-99) , 
3, -1.13675, 0, 0, 0.479818,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.268702);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.957784,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41757,-99) , 
0, 1.51689, 1, 0, 0.530897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304525,-99) , 
0, -2.48686, 1, 0, 0.379552,-99) , 
3, -0.373909, 0, 0, 0.484943,-99) , 
3, 3.55597, 0, 0, 0.502089,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.228673);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.223894, 1, 1, 0.575109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195963,-99) , 
2, 0.108815, 1, 0, 0.468517,-99) , 
3, 0.19804, 0, 0, 0.531854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.627312,-99) , 
NN(
0, 
0, 
-1, 0.474512, 1, -1, 0.320884,-99) , 
3, 1.74619, 0, 0, 0.354907,-99) , 
1, -0.673494, 0, 0, 0.487242,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.245355);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445389,-99) , 
2, 0.154758, 1, 0, 0.507346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315472,-99) , 
2, -1.8011, 1, 0, 0.370511,-99) , 
3, -0.683307, 0, 0, 0.475241,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452351,-99) , 
3, -1.12775, 1, 0, 0.473943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213543,-99) , 
3, 1.84906, 0, 0, 0.264619,-99) , 
1, 0.847919, 0, 0, 0.379893,-99) , 
1, 0.315534, 1, 0, 0.433102,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.152055);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.163133, 1, 1, 0.780401,-99) , 
NN(
NN(
0, 
0, 
-1, -0.860899, 1, 1, 0.526693,-99) , 
NN(
0, 
0, 
-1, 0.0325634, 1, -1, 0.38038,-99) , 
3, -0.303757, 0, 0, 0.484176,-99) , 
3, 2.36379, 0, 0, 0.512596,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.0993801);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710386,-99) , 
NN(
0, 
0, 
-1, 2.36281, 1, -1, 0.467235,-99) , 
0, -1.94242, 1, 0, 0.475833,-99) , 
NN(
0, 
0, 
-1, -3.25392, 1, -1, 0.312462,-99) , 
0, -2.405, 0, 0, 0.464302,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.172576);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361934,-99) , 
2, 1.65607, 1, 0, 0.530329,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609578,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389942,-99) , 
0, -0.863727, 1, 0, 0.430534,-99) , 
1, -0.775571, 0, 0, 0.506021,-99) , 
3, 3.07342, 0, 0, 0.520087,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.202167);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.823959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439654,-99) , 
1, -1.19117, 1, 0, 0.461255,-99) , 
3, 2.87057, 0, 0, 0.480649,-99) , 
NN(
0, 
0, 
-1, -1.68022, 1, -1, 0.0997073,-99) , 
3, -1.26947, 0, 0, 0.459958,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.304021);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.265498, 1, 1, 0.619306,-99) , 
NN(
0, 
0, 
-1, 0.219347, 1, -1, 0.431819,-99) , 
0, -1.03121, 0, 0, 0.55791,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386048,-99) , 
3, 1.74186, 1, 0, 0.504319,-99) , 
NN(
0, 
0, 
-1, 0.899942, 0, -1, 0.204739,-99) , 
3, 1.27669, 0, 0, 0.397317,-99) , 
0, 1.14771, 1, 0, 0.485912,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.258762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.32058, 1, 1, 0.72148,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224828,-99) , 
1, -0.234174, 1, 0, 0.514744,-99) , 
3, -1.04414, 0, 0, 0.658207,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563993,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343007,-99) , 
1, -0.977314, 0, 0, 0.530075,-99) , 
NN(
0, 
0, 
-1, -0.207566, 0, -1, 0.343405,-99) , 
2, 0.14237, 0, 0, 0.493359,-99) , 
2, -0.281514, 1, 0, 0.540975,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.214192);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43724, 0, 1, 0.759324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454618,-99) , 
0, 2.27644, 1, 0, 0.541107,-99) , 
1, -1.22772, 1, 0, 0.560755,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208544,-99) , 
1, -1.20968, 0, 0, 0.51142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201762,-99) , 
1, 0.610427, 1, 0, 0.429195,-99) , 
3, -0.376892, 0, 0, 0.528558,-99)    );
  // itree = 300
  fBoostWeights.push_back(0.31515);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.825084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292889,-99) , 
3, 1.32023, 0, 0, 0.519522,-99) , 
0, 1.17756, 1, 0, 0.550133,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329767,-99) , 
2, -1.3947, 0, 0, 0.53038,-99) , 
NN(
0, 
0, 
-1, 0.763394, 1, -1, 0.349335,-99) , 
0, -1.18829, 1, 0, 0.404186,-99) , 
3, 0.736065, 0, 0, 0.463485,-99)    );
  // itree = 301
  fBoostWeights.push_back(0.131291);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494054,-99) , 
3, 0.378994, 1, 0, 0.538215,-99) , 
NN(
0, 
0, 
-1, -3.13892, 1, -1, 0.303567,-99) , 
3, -1.22591, 0, 0, 0.524209,-99) , 
NN(
0, 
0, 
-1, -1.06686, 0, -1, 0.302191,-99) , 
1, -1.72972, 0, 0, 0.507688,-99)    );
  // itree = 302
  fBoostWeights.push_back(0.295666);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.83159, 0, 1, 0.611354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160688,-99) , 
0, 3.75458, 1, 0, 0.580347,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321727,-99) , 
2, -1.01571, 1, 0, 0.406264,-99) , 
NN(
0, 
0, 
-1, 1.4795, 0, -1, 0.148768,-99) , 
1, 0.821661, 1, 0, 0.349787,-99) , 
2, -0.155261, 0, 0, 0.494419,-99)    );
  // itree = 303
  fBoostWeights.push_back(0.247293);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394939,-99) , 
3, -1.4352, 0, 0, 0.558515,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261051,-99) , 
1, 1.74345, 1, 0, 0.398735,-99) , 
1, 1.32658, 1, 0, 0.538545,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319913,-99) , 
2, 1.36118, 0, 0, 0.50923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196505,-99) , 
3, 1.71937, 0, 0, 0.386508,-99) , 
0, 1.94299, 1, 0, 0.492917,-99)    );
  // itree = 304
  fBoostWeights.push_back(0.271533);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.15197, 1, 1, 0.701725,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411065,-99) , 
0, 0.196182, 1, 0, 0.496585,-99) , 
NN(
0, 
0, 
-1, -1.45057, 1, -1, 0.275376,-99) , 
3, -1.15643, 0, 0, 0.474044,-99) , 
1, 1.81888, 0, 0, 0.490728,-99)    );
  // itree = 305
  fBoostWeights.push_back(0.299396);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843727,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344834,-99) , 
1, 1.46569, 0, 0, 0.580962,-99) , 
0, 1.79673, 0, 0, 0.686955,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418755,-99) , 
3, 1.06161, 0, 0, 0.501063,-99) , 
NN(
0, 
0, 
-1, 2.02187, 1, -1, 0.323117,-99) , 
1, 0.247449, 1, 0, 0.443862,-99) , 
1, 1.28363, 0, 0, 0.467932,-99)    );
  // itree = 306
  fBoostWeights.push_back(0.106082);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753486,-99) , 
NN(
0, 
0, 
-1, 1.20252, 1, -1, 0.4552,-99) , 
1, 1.66439, 0, 0, 0.466696,-99)    );
  // itree = 307
  fBoostWeights.push_back(0.235293);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.67916, 0, 1, 0.756127,-99) , 
NN(
NN(
0, 
0, 
-1, 0.489599, 0, 1, 0.593087,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364863,-99) , 
3, 2.32942, 0, 0, 0.495169,-99) , 
2, 1.43963, 1, 0, 0.572518,-99) , 
1, -1.48186, 1, 0, 0.588388,-99)    );
  // itree = 308
  fBoostWeights.push_back(0.222816);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.702693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559609,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318075,-99) , 
3, -0.0500636, 0, 0, 0.489868,-99) , 
2, -1.57101, 1, 0, 0.503233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173677,-99) , 
1, 2.09327, 1, 0, 0.491633,-99)    );
  // itree = 309
  fBoostWeights.push_back(0.257503);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708887,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326763,-99) , 
1, 0.22994, 1, 0, 0.592776,-99) , 
0, -1.97201, 0, 0, 0.663467,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729947,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369207,-99) , 
3, -0.127283, 0, 0, 0.534677,-99) , 
NN(
0, 
0, 
-1, 0.577275, 0, -1, 0.413061,-99) , 
3, 0.368767, 1, 0, 0.444627,-99) , 
0, -1.60723, 1, 0, 0.470489,-99)    );
  // itree = 310
  fBoostWeights.push_back(0.219922);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.492576, 1, 1, 0.60067,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233068,-99) , 
0, -2.56068, 1, 0, 0.411845,-99) , 
3, -1.15643, 0, 0, 0.584794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221246,-99) , 
1, 2.10224, 1, 0, 0.572818,-99)    );
  // itree = 311
  fBoostWeights.push_back(0.264877);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819782,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469166,-99) , 
3, -1.39058, 0, 0, 0.746668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224792,-99) , 
1, -0.354032, 0, 0, 0.466086,-99) , 
1, -0.591326, 1, 0, 0.548576,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461422,-99) , 
1, 1.3811, 0, 0, 0.489383,-99) , 
NN(
0, 
0, 
-1, 0.203621, 1, -1, 0.242764,-99) , 
3, 1.34007, 0, 0, 0.384357,-99) , 
0, 0.861216, 1, 0, 0.4588,-99)    );
  // itree = 312
  fBoostWeights.push_back(0.284751);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449094,-99) , 
1, 0.478351, 1, 0, 0.596225,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.121459,-99) , 
0, -2.93187, 1, 0, 0.330203,-99) , 
3, -1.1046, 0, 0, 0.50753,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398891,-99) , 
2, 0.291611, 1, 0, 0.425882,-99) , 
NN(
0, 
0, 
-1, 0.141922, 1, -1, 0.265133,-99) , 
3, 0.320126, 0, 0, 0.381896,-99) , 
2, -0.535301, 1, 0, 0.405447,-99)    );
  // itree = 313
  fBoostWeights.push_back(0.23068);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.16686, 0, 1, 0.671627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.757557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471689,-99) , 
2, 2.70379, 0, 0, 0.543505,-99) , 
2, 1.60476, 1, 0, 0.598289,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426366,-99) , 
3, -0.958261, 0, 0, 0.522699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350452,-99) , 
3, 1.39421, 0, 0, 0.405238,-99) , 
2, 0.0761576, 1, 0, 0.461569,-99) , 
3, 1.75059, 0, 0, 0.48598,-99)    );
  // itree = 314
  fBoostWeights.push_back(0.276639);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483304,-99) , 
3, -0.861389, 0, 0, 0.642561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194607,-99) , 
0, 2.80701, 1, 0, 0.487556,-99) , 
1, 0.628824, 1, 0, 0.593261,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313347,-99) , 
3, -0.399833, 0, 0, 0.488621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277764,-99) , 
0, 1.3945, 1, 0, 0.403872,-99) , 
1, -1.03061, 0, 0, 0.568168,-99)    );
  // itree = 315
  fBoostWeights.push_back(0.255847);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.925695, 1, 1, 0.582717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329384,-99) , 
1, -1.75262, 0, 0, 0.565318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379913,-99) , 
2, -1.0683, 1, 0, 0.577133,-99) , 
NN(
0, 
0, 
-1, 0.625544, 0, -1, 0.0817613,-99) , 
1, 0.0100439, 1, 0, 0.400531,-99) , 
3, -0.724084, 0, 0, 0.532227,-99)    );
  // itree = 316
  fBoostWeights.push_back(0.221102);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844428,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38148,-99) , 
3, -0.846976, 0, 0, 0.525254,-99) , 
2, -2.37201, 1, 0, 0.551233,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463869,-99) , 
0, 0.709428, 1, 0, 0.494958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18639,-99) , 
3, 0.362067, 0, 0, 0.436568,-99) , 
2, 0.161708, 1, 0, 0.484888,-99)    );
  // itree = 317
  fBoostWeights.push_back(0.217718);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.977314, 1, 1, 0.593816,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383984,-99) , 
1, 0.505611, 1, 0, 0.557904,-99) , 
NN(
0, 
0, 
-1, -0.170704, 0, -1, 0.38577,-99) , 
2, -0.524369, 1, 0, 0.447955,-99) , 
3, 0.816421, 0, 0, 0.510922,-99)    );
  // itree = 318
  fBoostWeights.push_back(0.231301);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.74224, 0, 1, 0.681942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278319,-99) , 
3, 3.07812, 0, 0, 0.480585,-99) , 
2, 2.13194, 1, 0, 0.603234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48227,-99) , 
2, -1.92156, 0, 0, 0.642421,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325124,-99) , 
3, 0.236449, 0, 0, 0.409989,-99) , 
2, -1.37266, 1, 0, 0.433538,-99) , 
2, 1.49137, 0, 0, 0.463071,-99)    );
  // itree = 319
  fBoostWeights.push_back(0.250462);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.59175, 0, 1, 0.578678,-99) , 
NN(
NN(
0, 
0, 
-1, -2.3917, 1, 1, 0.748981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309382,-99) , 
3, 1.43854, 0, 0, 0.381984,-99) , 
0, -1.65375, 1, 0, 0.422025,-99) , 
1, 0.043558, 1, 0, 0.493014,-99)    );
  // itree = 320
  fBoostWeights.push_back(0.216911);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290092,-99) , 
1, 0.608915, 1, 0, 0.448316,-99) , 
3, -0.418437, 0, 0, 0.50851,-99) , 
NN(
NN(
0, 
0, 
-1, 2.65786, 1, -1, 0.458905,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26302,-99) , 
3, 0.581772, 0, 0, 0.335965,-99) , 
2, 0.358323, 0, 0, 0.421286,-99) , 
0, -0.707105, 1, 0, 0.444932,-99)    );
  // itree = 321
  fBoostWeights.push_back(0.214083);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13348, 0, 1, 0.574486,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193825,-99) , 
3, 1.83418, 0, 0, 0.421318,-99) , 
2, 1.28527, 1, 0, 0.52993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523775,-99) , 
NN(
0, 
0, 
-1, 0.680573, 1, -1, 0.265328,-99) , 
2, -2.13653, 1, 0, 0.308578,-99) , 
2, -0.876457, 0, 0, 0.492604,-99)    );
  // itree = 322
  fBoostWeights.push_back(0.36945);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328175,-99) , 
2, 1.68793, 1, 0, 0.660348,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212998,-99) , 
3, 1.89322, 0, 0, 0.470744,-99) , 
0, 2.54616, 1, 0, 0.548467,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305755,-99) , 
2, 0.0905401, 0, 0, 0.366717,-99) , 
NN(
0, 
0, 
-1, 0.815817, 1, -1, 0.19717,-99) , 
2, 0.631941, 1, 0, 0.339946,-99) , 
3, 1.14325, 0, 0, 0.41082,-99)    );
  // itree = 323
  fBoostWeights.push_back(0.350763);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469118,-99) , 
1, -0.820952, 0, 0, 0.627308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170136,-99) , 
3, -0.0796918, 0, 0, 0.493639,-99) , 
3, -0.248935, 1, 0, 0.577276,-99) , 
NN(
NN(
0, 
0, 
-1, -1.63071, 0, 1, 0.72647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.855208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343102,-99) , 
3, 3.42552, 0, 0, 0.368329,-99) , 
1, -0.977314, 1, 0, 0.422146,-99) , 
3, 0.392653, 1, 0, 0.48365,-99)    );
  // itree = 324
  fBoostWeights.push_back(0.178173);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.10368, 1, 1, 0.540615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35743,-99) , 
1, -0.654307, 1, 0, 0.40574,-99) , 
3, 0.650374, 0, 0, 0.470808,-99) , 
NN(
0, 
0, 
-1, 0.38636, 1, -1, 0.251666,-99) , 
1, 1.55039, 1, 0, 0.455347,-99)    );
  // itree = 325
  fBoostWeights.push_back(0.220223);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426069,-99) , 
0, -0.0245345, 1, 0, 0.60913,-99) , 
NN(
0, 
0, 
-1, -1.71325, 1, -1, 0.38835,-99) , 
0, -1.33929, 0, 0, 0.52537,-99) , 
NN(
0, 
0, 
-1, 4.5537, 1, -1, 0.406844,-99) , 
0, 0.287843, 1, 0, 0.457353,-99)    );
  // itree = 326
  fBoostWeights.push_back(0.264547);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.956327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430526,-99) , 
0, 3.27387, 1, 0, 0.613698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55326,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356564,-99) , 
0, 0.667585, 1, 0, 0.455586,-99) , 
3, 1.99016, 0, 0, 0.481889,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23086,-99) , 
3, 0.423009, 0, 0, 0.394422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0794478,-99) , 
2, 1.29967, 1, 0, 0.287577,-99) , 
1, 1.30691, 1, 0, 0.463957,-99)    );
  // itree = 327
  fBoostWeights.push_back(0.239877);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.57618, 1, 1, 0.751572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443505,-99) , 
3, 1.12916, 0, 0, 0.460307,-99) , 
3, 1.4526, 0, 0, 0.497872,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262172,-99) , 
2, 1.7197, 1, 0, 0.395463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131607,-99) , 
3, 2.15572, 0, 0, 0.309387,-99) , 
0, 2.56433, 1, 0, 0.462679,-99)    );
  // itree = 328
  fBoostWeights.push_back(0.162285);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832269,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47988,-99) , 
1, -0.605638, 1, 0, 0.529908,-99) , 
0, -2.58309, 1, 0, 0.545025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170683,-99) , 
3, -1.78662, 0, 0, 0.533019,-99)    );
  // itree = 329
  fBoostWeights.push_back(0.335898);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398691,-99) , 
0, 1.89981, 1, 0, 0.705971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241355,-99) , 
1, 1.06974, 1, 0, 0.470186,-99) , 
2, 0.75917, 1, 0, 0.535281,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821934,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429763,-99) , 
2, -1.61935, 0, 0, 0.642357,-99) , 
NN(
0, 
0, 
-1, 0.389406, 1, -1, 0.26558,-99) , 
0, -2.80235, 1, 0, 0.327574,-99) , 
3, 0.195693, 0, 0, 0.449967,-99)    );
  // itree = 330
  fBoostWeights.push_back(0.247556);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.194013, 0, 1, 0.682081,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406756,-99) , 
0, -0.00413718, 1, 0, 0.483688,-99) , 
1, -0.0104624, 1, 0, 0.526356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543667,-99) , 
NN(
0, 
0, 
-1, -0.547158, 0, -1, 0.348707,-99) , 
0, -1.60305, 1, 0, 0.37656,-99) , 
1, -0.36158, 0, 0, 0.473347,-99)    );
  // itree = 331
  fBoostWeights.push_back(0.128791);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.76472, 1, 1, 0.533956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273298,-99) , 
3, -1.68892, 0, 0, 0.521693,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589598,-99) , 
NN(
0, 
0, 
-1, 3.22183, 1, -1, 0.302192,-99) , 
3, 2.93814, 0, 0, 0.369231,-99) , 
0, 2.74551, 1, 0, 0.496956,-99)    );
  // itree = 332
  fBoostWeights.push_back(0.13227);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.696122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499357,-99) , 
3, 2.0185, 0, 0, 0.529736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0647675,-99) , 
0, 4.6163, 1, 0, 0.512427,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567836,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298015,-99) , 
2, -1.82889, 0, 0, 0.430886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0359026,-99) , 
2, -1.4467, 1, 0, 0.27593,-99) , 
3, -1.22141, 0, 0, 0.490946,-99)    );
  // itree = 333
  fBoostWeights.push_back(0.19166);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.50796, 1, 1, 0.55826,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384532,-99) , 
0, 1.54417, 0, 0, 0.439045,-99) , 
1, -0.328909, 0, 0, 0.514695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564409,-99) , 
NN(
0, 
0, 
-1, 2.75852, 1, -1, 0.273794,-99) , 
3, 3.1003, 0, 0, 0.339988,-99) , 
0, 3.19023, 1, 0, 0.491712,-99)    );
  // itree = 334
  fBoostWeights.push_back(0.166972);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.793786, 0, 1, 0.724036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352167,-99) , 
3, -0.94711, 0, 0, 0.516851,-99) , 
0, 3.65046, 0, 0, 0.540881,-99) , 
NN(
0, 
0, 
-1, 1.70472, 1, -1, 0.405154,-99) , 
1, -0.0246959, 0, 0, 0.470587,-99)    );
  // itree = 335
  fBoostWeights.push_back(0.150431);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838902,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377975,-99) , 
3, -2.19191, 0, 0, 0.642711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32987,-99) , 
3, -0.0144944, 0, 0, 0.472008,-99) , 
0, -1.48202, 1, 0, 0.498903,-99) , 
1, -1.75827, 1, 0, 0.511105,-99)    );
  // itree = 336
  fBoostWeights.push_back(0.346418);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694167,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394539,-99) , 
0, 2.79444, 1, 0, 0.635593,-99) , 
NN(
0, 
0, 
-1, 1.57403, 1, -1, 0.400287,-99) , 
1, 0.191326, 1, 0, 0.522299,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296227,-99) , 
2, -1.70893, 0, 0, 0.441436,-99) , 
NN(
0, 
0, 
-1, -1.10348, 0, -1, 0.123056,-99) , 
0, -2.54298, 1, 0, 0.241665,-99) , 
3, -0.639447, 0, 0, 0.476318,-99)    );
  // itree = 337
  fBoostWeights.push_back(0.275996);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.110933, 0, 1, 0.63571,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435884,-99) , 
0, 2.71511, 1, 0, 0.583942,-99) , 
NN(
0, 
0, 
-1, 0.864454, 1, -1, 0.387571,-99) , 
3, 1.34356, 0, 0, 0.492437,-99) , 
0, 0.443786, 1, 0, 0.554866,-99)    );
  // itree = 338
  fBoostWeights.push_back(0.166259);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452119,-99) , 
2, 2.445, 1, 0, 0.687501,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412212,-99) , 
2, 0.906339, 1, 0, 0.51194,-99) , 
3, 2.39728, 0, 0, 0.529613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247602,-99) , 
0, 4.71731, 1, 0, 0.521479,-99)    );
  // itree = 339
  fBoostWeights.push_back(0.197736);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.774085, 0, 1, 0.662679,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406493,-99) , 
2, -0.092116, 1, 0, 0.490659,-99) , 
1, 0.977463, 1, 0, 0.57916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373313,-99) , 
2, -0.15663, 0, 0, 0.47094,-99) , 
1, -1.95539, 1, 0, 0.493128,-99) , 
1, 0.38739, 0, 0, 0.527273,-99)    );
  // itree = 340
  fBoostWeights.push_back(0.292349);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495504,-99) , 
2, 1.76406, 1, 0, 0.670964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379419,-99) , 
1, -0.977314, 0, 0, 0.616255,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447009,-99) , 
0, 0.860123, 1, 0, 0.615349,-99) , 
NN(
0, 
0, 
-1, -0.989935, 0, -1, 0.394402,-99) , 
1, 0.0100439, 1, 0, 0.511971,-99) , 
2, 1.03974, 0, 0, 0.546444,-99)    );
  // itree = 341
  fBoostWeights.push_back(0.186129);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860085,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396104,-99) , 
3, 2.76793, 0, 0, 0.478166,-99) , 
0, 2.65988, 1, 0, 0.571883,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511906,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388196,-99) , 
3, -0.00793153, 0, 0, 0.452806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211817,-99) , 
2, 1.36072, 1, 0, 0.437809,-99) , 
3, 1.68231, 0, 0, 0.463616,-99)    );
  // itree = 342
  fBoostWeights.push_back(0.194856);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.366142, 0, 1, 0.646251,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28487,-99) , 
3, 0.236562, 0, 0, 0.486911,-99) , 
2, 0.0282599, 1, 0, 0.542292,-99) , 
NN(
0, 
0, 
-1, -1.33794, 1, -1, 0.216822,-99) , 
3, -1.22141, 0, 0, 0.517457,-99)    );
  // itree = 343
  fBoostWeights.push_back(0.264861);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.55671, 0, 1, 0.693554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277003,-99) , 
0, 3.99021, 1, 0, 0.602565,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344291,-99) , 
2, -0.673434, 0, 0, 0.535773,-99) , 
NN(
0, 
0, 
-1, -0.284399, 1, -1, 0.386249,-99) , 
1, 0.463922, 0, 0, 0.428243,-99) , 
3, 1.93875, 0, 0, 0.460412,-99)    );
  // itree = 344
  fBoostWeights.push_back(0.194713);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.402374, 1, 1, 0.591874,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431255,-99) , 
1, -1.93128, 1, 0, 0.456697,-99) , 
1, 0.341602, 0, 0, 0.507894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.10447,-99) , 
0, 4.20187, 1, 0, 0.496466,-99)    );
  // itree = 345
  fBoostWeights.push_back(0.25181);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.316189, 0, 1, 0.672907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296046,-99) , 
2, 1.76881, 1, 0, 0.644173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.944469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413152,-99) , 
2, -0.312568, 1, 0, 0.447905,-99) , 
3, 3.35722, 0, 0, 0.470791,-99) , 
1, -0.39136, 1, 0, 0.534874,-99)    );
  // itree = 346
  fBoostWeights.push_back(0.306105);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436082,-99) , 
0, 3.11176, 1, 0, 0.670523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418783,-99) , 
1, 0.557083, 0, 0, 0.512967,-99) , 
1, -0.0229864, 1, 0, 0.583042,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651849,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350837,-99) , 
2, 0.0399858, 1, 0, 0.497638,-99) , 
NN(
0, 
0, 
-1, -0.801552, 1, -1, 0.320817,-99) , 
3, -0.552992, 0, 0, 0.431393,-99) , 
3, 0.660704, 0, 0, 0.505253,-99)    );
  // itree = 347
  fBoostWeights.push_back(0.193387);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.46999, 0, 1, 0.863022,-99) , 
NN(
NN(
0, 
0, 
-1, -0.376683, 1, 1, 0.552446,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182346,-99) , 
0, -1.43669, 1, 0, 0.426244,-99) , 
3, -0.426146, 0, 0, 0.520362,-99) , 
2, 2.35627, 0, 0, 0.544303,-99)    );
  // itree = 348
  fBoostWeights.push_back(0.184377);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354838,-99) , 
3, -1.98171, 0, 0, 0.699412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45824,-99) , 
0, 3.3963, 0, 0, 0.474913,-99) , 
0, -2.16332, 1, 0, 0.498699,-99) , 
NN(
0, 
0, 
-1, 2.76126, 0, -1, 0.218815,-99) , 
2, 1.96309, 1, 0, 0.47902,-99)    );
  // itree = 349
  fBoostWeights.push_back(0.242383);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.540297, 0, 1, 0.792002,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376467,-99) , 
2, 1.3745, 0, 0, 0.44794,-99) , 
0, 0.798591, 1, 0, 0.628234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460946,-99) , 
0, 1.17756, 1, 0, 0.509935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344222,-99) , 
0, -1.432, 1, 0, 0.417307,-99) , 
3, 0.684423, 0, 0, 0.464945,-99) , 
1, -0.962158, 1, 0, 0.496178,-99)    );
  // itree = 350
  fBoostWeights.push_back(0.209232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.755855, 0, 1, 0.697517,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443,-99) , 
2, 1.3027, 0, 0, 0.501276,-99) , 
2, -0.467145, 1, 0, 0.535453,-99) , 
NN(
0, 
0, 
-1, -1.83371, 1, -1, 0.283881,-99) , 
3, -1.59231, 0, 0, 0.521871,-99)    );
  // itree = 351
  fBoostWeights.push_back(0.241981);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.63755, 1, 1, 0.665244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288725,-99) , 
2, -0.892068, 0, 0, 0.530203,-99) , 
1, 0.866258, 1, 0, 0.62472,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207348,-99) , 
0, 3.42922, 1, 0, 0.492109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25144,-99) , 
3, -1.3463, 0, 0, 0.469192,-99) , 
1, -0.36158, 0, 0, 0.562556,-99)    );
  // itree = 352
  fBoostWeights.push_back(0.298962);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.336694, 0, 1, 0.619479,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348763,-99) , 
2, 1.70617, 0, 0, 0.437529,-99) , 
2, 0.968648, 1, 0, 0.547004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692275,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289817,-99) , 
0, -2.8873, 1, 0, 0.366608,-99) , 
3, -0.385564, 0, 0, 0.403789,-99) , 
0, -0.824643, 0, 0, 0.515282,-99)    );
  // itree = 353
  fBoostWeights.push_back(0.180965);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485433,-99) , 
0, 1.79187, 1, 0, 0.55433,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.272722,-99) , 
0, -1.80475, 1, 0, 0.421226,-99) , 
3, -0.719586, 0, 0, 0.5314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.1971,-99) , 
1, -1.6752, 0, 0, 0.511854,-99)    );
  // itree = 354
  fBoostWeights.push_back(0.1908);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785331,-99) , 
NN(
0, 
0, 
-1, 4.40821, 1, -1, 0.415099,-99) , 
1, -1.72972, 1, 0, 0.432385,-99)    );
  // itree = 355
  fBoostWeights.push_back(0.281615);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726436,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244558,-99) , 
0, 1.94272, 1, 0, 0.634041,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440124,-99) , 
3, 0.262941, 0, 0, 0.530346,-99) , 
1, 0.0769229, 0, 0, 0.563899,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448635,-99) , 
0, 1.31795, 1, 0, 0.526821,-99) , 
NN(
0, 
0, 
-1, -0.32509, 0, -1, 0.226944,-99) , 
3, 0.47649, 0, 0, 0.421428,-99) , 
1, 0.70811, 1, 0, 0.529502,-99)    );
  // itree = 356
  fBoostWeights.push_back(0.113097);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.752236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478385,-99) , 
2, 1.94346, 1, 0, 0.641934,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.796394,-99) , 
NN(
0, 
0, 
-1, -1.6254, 0, -1, 0.46355,-99) , 
1, 2.00353, 0, 0, 0.474847,-99) , 
0, 3.84047, 0, 0, 0.491012,-99)    );
  // itree = 357
  fBoostWeights.push_back(0.144067);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.54615, 0, 1, 0.751997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360592,-99) , 
0, -2.70971, 1, 0, 0.530707,-99) , 
1, 0.032123, 1, 0, 0.66405,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497248,-99) , 
2, -0.220206, 1, 0, 0.516257,-99) , 
NN(
0, 
0, 
-1, -0.325213, 0, -1, 0.306255,-99) , 
2, -0.448068, 0, 0, 0.485606,-99) , 
3, -0.852844, 1, 0, 0.511774,-99)    );
  // itree = 358
  fBoostWeights.push_back(0.266756);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.43624, 1, 1, 0.590384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307591,-99) , 
1, -1.98828, 0, 0, 0.575701,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311833,-99) , 
1, 0.883433, 0, 0, 0.432924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
2, -1.64145, 0, 0, 0.393615,-99) , 
1, 0.307447, 1, 0, 0.500526,-99)    );
  // itree = 359
  fBoostWeights.push_back(0.173816);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551955,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394138,-99) , 
1, -1.12811, 0, 0, 0.527325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216099,-99) , 
0, 4.06202, 1, 0, 0.511003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.68589, 0, 0, 0.494341,-99)    );
  // itree = 360
  fBoostWeights.push_back(0.276013);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0638519, 0, 1, 0.697746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34386,-99) , 
2, 1.19768, 0, 0, 0.494544,-99) , 
0, 1.31332, 1, 0, 0.589973,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444136,-99) , 
0, 1.85142, 0, 0, 0.491453,-99) , 
NN(
0, 
0, 
-1, -0.626011, 1, -1, 0.270004,-99) , 
0, 2.89852, 1, 0, 0.454397,-99) , 
1, -0.0229864, 0, 0, 0.520163,-99)    );
  // itree = 361
  fBoostWeights.push_back(0.221171);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.648799, 1, 1, 0.757853,-99) , 
NN(
0, 
0, 
-1, 2.96358, 0, -1, 0.416548,-99) , 
0, 3.7556, 1, 0, 0.64299,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298628,-99) , 
3, 1.11563, 1, 0, 0.50734,-99) , 
NN(
0, 
0, 
-1, -0.316605, 0, -1, 0.411461,-99) , 
1, -0.359664, 1, 0, 0.446628,-99) , 
0, 2.69796, 0, 0, 0.476669,-99)    );
  // itree = 362
  fBoostWeights.push_back(0.216997);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.35428, 0, 1, 0.660528,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438517,-99) , 
3, -0.907531, 0, 0, 0.583284,-99) , 
NN(
0, 
0, 
-1, 0.488852, 0, -1, 0.425584,-99) , 
0, -0.071207, 1, 0, 0.483994,-99) , 
3, 1.99567, 0, 0, 0.518793,-99)    );
  // itree = 363
  fBoostWeights.push_back(0.207165);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759812,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466204,-99) , 
1, 0.965373, 1, 0, 0.580463,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425282,-99) , 
0, -0.0924363, 1, 0, 0.490083,-99) , 
1, -0.0316737, 0, 0, 0.538939,-99) , 
1, -1.81119, 1, 0, 0.546841,-99)    );
  // itree = 364
  fBoostWeights.push_back(0.235916);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.920618,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342383,-99) , 
2, 1.83095, 1, 0, 0.564106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17849,-99) , 
3, -1.76245, 0, 0, 0.549668,-99) , 
3, 3.43073, 0, 0, 0.565273,-99)    );
  // itree = 365
  fBoostWeights.push_back(0.226892);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.805522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475521,-99) , 
3, 2.73181, 1, 0, 0.690711,-99) , 
NN(
0, 
0, 
-1, -0.815701, 1, 1, 0.550007,-99) , 
3, 1.90618, 0, 0, 0.583202,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367967,-99) , 
3, -1.92424, 0, 0, 0.551839,-99) , 
NN(
0, 
0, 
-1, -0.967798, 0, -1, 0.279085,-99) , 
0, -2.00647, 1, 0, 0.388448,-99) , 
3, -0.376892, 0, 0, 0.533112,-99)    );
  // itree = 366
  fBoostWeights.push_back(0.307342);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471935,-99) , 
0, 2.74939, 1, 0, 0.600578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.347429,-99) , 
2, -0.891683, 1, 0, 0.452561,-99) , 
3, 0.17816, 0, 0, 0.547614,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372559,-99) , 
2, 0.201886, 0, 0, 0.506302,-99) , 
NN(
0, 
0, 
-1, 1.91712, 0, -1, 0.345925,-99) , 
0, 1.23253, 1, 0, 0.414806,-99) , 
1, -0.0220652, 1, 0, 0.478244,-99)    );
  // itree = 367
  fBoostWeights.push_back(0.185828);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.88618, 0, 1, 0.715667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436253,-99) , 
1, 0.712272, 1, 0, 0.64737,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313898,-99) , 
1, -0.800271, 0, 0, 0.475865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.170418,-99) , 
1, 1.47688, 1, 0, 0.458034,-99) , 
3, 2.15544, 0, 0, 0.480047,-99)    );
  // itree = 368
  fBoostWeights.push_back(0.228919);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.3287, 0, 1, 0.593959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580033,-99) , 
NN(
0, 
0, 
-1, -0.322449, 1, -1, 0.315729,-99) , 
2, 1.50785, 0, 0, 0.369897,-99) , 
1, -0.700332, 0, 0, 0.533704,-99)    );
  // itree = 369
  fBoostWeights.push_back(0.270388);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.70789, 0, 1, 0.597248,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263685,-99) , 
3, -1.68585, 0, 0, 0.542647,-99) , 
NN(
0, 
0, 
-1, 0.287566, 1, -1, 0.349464,-99) , 
2, -1.04166, 1, 0, 0.389991,-99) , 
3, 1.11691, 0, 0, 0.473771,-99)    );
  // itree = 370
  fBoostWeights.push_back(0.265842);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843974,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451982,-99) , 
3, 0.447444, 1, 0, 0.590912,-99) , 
2, 1.60613, 0, 0, 0.629616,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294237,-99) , 
1, 1.54018, 1, 0, 0.598898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558845,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349497,-99) , 
2, 0.725608, 0, 0, 0.454451,-99) , 
0, -0.707105, 1, 0, 0.496637,-99) , 
1, -0.700332, 1, 0, 0.525352,-99)    );
  // itree = 371
  fBoostWeights.push_back(0.273361);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.420344, 0, 1, 0.612319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397564,-99) , 
3, 1.8412, 0, 0, 0.488854,-99) , 
2, 0.48406, 1, 0, 0.547375,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384145,-99) , 
2, 1.44595, 1, 0, 0.528183,-99) , 
NN(
0, 
0, 
-1, 1.89574, 1, -1, 0.233705,-99) , 
1, 0.83155, 0, 0, 0.403563,-99) , 
1, 0.38739, 1, 0, 0.499049,-99)    );
  // itree = 372
  fBoostWeights.push_back(0.234793);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.61769, 0, 1, 0.756203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.237727,-99) , 
3, -0.465296, 0, 0, 0.539454,-99) , 
0, -1.19006, 1, 0, 0.585947,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486098,-99) , 
0, -1.44905, 1, 0, 0.537325,-99) , 
NN(
0, 
0, 
-1, -0.293955, 0, -1, 0.372881,-99) , 
1, 0.663795, 0, 0, 0.439879,-99) , 
1, -0.39136, 1, 0, 0.486989,-99)    );
  // itree = 373
  fBoostWeights.push_back(0.237872);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384124,-99) , 
2, -0.618356, 0, 0, 0.540893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291016,-99) , 
0, -3.00329, 1, 0, 0.380517,-99) , 
0, -1.36554, 0, 0, 0.504488,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26134,-99) , 
1, -0.142768, 0, 0, 0.381904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178585,-99) , 
1, 0.618044, 1, 0, 0.318237,-99) , 
2, 1.7396, 1, 0, 0.474343,-99)    );
  // itree = 374
  fBoostWeights.push_back(0.210402);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484613,-99) , 
2, 0.593062, 1, 0, 0.518125,-99) , 
NN(
0, 
0, 
-1, 1.32074, 0, -1, 0.316905,-99) , 
1, 0.976475, 1, 0, 0.473945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674662,-99) , 
NN(
0, 
0, 
-1, 0.116782, 1, -1, 0.366244,-99) , 
1, 1.12018, 0, 0, 0.3857,-99) , 
3, 0.644527, 0, 0, 0.432574,-99)    );
  // itree = 375
  fBoostWeights.push_back(0.115015);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.788577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650182,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479764,-99) , 
1, -0.226488, 1, 0, 0.540152,-99) , 
1, 0.831333, 0, 0, 0.623914,-99) , 
NN(
0, 
0, 
-1, 2.65124, 1, -1, 0.452815,-99) , 
3, 2.45686, 0, 0, 0.471134,-99)    );
  // itree = 376
  fBoostWeights.push_back(0.177728);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.778231, 0, 1, 0.75707,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295601,-99) , 
3, -1.2198, 0, 0, 0.528509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227879,-99) , 
1, -1.18396, 0, 0, 0.511322,-99) , 
1, -1.40673, 1, 0, 0.530366,-99)    );
  // itree = 377
  fBoostWeights.push_back(0.27057);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415123,-99) , 
0, 0.768943, 1, 0, 0.515322,-99) , 
NN(
0, 
0, 
-1, -0.291975, 1, -1, 0.28396,-99) , 
2, -1.25328, 0, 0, 0.482432,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448536,-99) , 
2, 2.24247, 0, 0, 0.526176,-99) , 
NN(
0, 
0, 
-1, 2.06221, 0, -1, 0.255118,-99) , 
0, 3.61428, 0, 0, 0.319911,-99) , 
2, 1.24313, 1, 0, 0.438898,-99)    );
  // itree = 378
  fBoostWeights.push_back(0.253252);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.68433, 1, 1, 0.600795,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38332,-99) , 
0, -1.22434, 1, 0, 0.452781,-99) , 
3, 1.40574, 0, 0, 0.496052,-99) , 
NN(
0, 
0, 
-1, 2.95265, 0, -1, 0.174011,-99) , 
0, 3.96657, 1, 0, 0.477589,-99)    );
  // itree = 379
  fBoostWeights.push_back(0.24773);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.574924, 0, 1, 0.703232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311182,-99) , 
0, 2.08256, 0, 0, 0.420996,-99) , 
0, 0.50865, 1, 0, 0.561302,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.840157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410004,-99) , 
3, 0.60451, 1, 0, 0.603396,-99) , 
NN(
0, 
0, 
-1, -0.307034, 0, -1, 0.406716,-99) , 
1, -0.526597, 1, 0, 0.42791,-99) , 
1, -0.759733, 1, 0, 0.457309,-99)    );
  // itree = 380
  fBoostWeights.push_back(0.283553);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474714,-99) , 
3, 0.500518, 0, 0, 0.594431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37174,-99) , 
1, -0.36158, 1, 0, 0.418366,-99) , 
2, 0.26419, 1, 0, 0.454402,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249286,-99) , 
3, -1.13746, 0, 0, 0.362491,-99) , 
NN(
0, 
0, 
-1, -0.108097, 1, -1, 0.169115,-99) , 
3, -0.67706, 1, 0, 0.288905,-99) , 
3, -0.18324, 0, 0, 0.403726,-99)    );
  // itree = 381
  fBoostWeights.push_back(0.286684);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.19006, 1, 1, 0.85405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467935,-99) , 
3, 0.227993, 0, 0, 0.742276,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633996,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435371,-99) , 
0, 0.336732, 0, 0, 0.508984,-99) , 
NN(
0, 
0, 
-1, 0.357756, 0, -1, 0.33323,-99) , 
0, 1.77377, 1, 0, 0.445056,-99) , 
1, 1.3388, 0, 0, 0.489631,-99)    );
  // itree = 382
  fBoostWeights.push_back(0.172002);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.111981, 1, 1, 0.565223,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226087,-99) , 
2, -1.62053, 1, 0, 0.36548,-99) , 
3, -1.32334, 0, 0, 0.544856,-99) , 
NN(
0, 
0, 
-1, 4.0232, 1, -1, 0.307385,-99) , 
0, 3.48987, 1, 0, 0.521683,-99)    );
  // itree = 383
  fBoostWeights.push_back(0.251548);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.284641, 0, 1, 0.618133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168337,-99) , 
1, 1.14782, 1, 0, 0.447767,-99) , 
2, 0.850984, 1, 0, 0.55173,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434774,-99) , 
1, -2.06501, 1, 0, 0.468593,-99) , 
NN(
0, 
0, 
-1, 0.395534, 0, -1, 0.150745,-99) , 
1, -0.570876, 1, 0, 0.381554,-99) , 
1, -0.411712, 0, 0, 0.491884,-99)    );
  // itree = 384
  fBoostWeights.push_back(0.179077);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471025,-99) , 
2, 0.299251, 1, 0, 0.535807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0918456,-99) , 
3, -2.04546, 0, 0, 0.521501,-99) , 
NN(
0, 
0, 
-1, 1.07999, 1, -1, 0.354294,-99) , 
0, 2.39256, 1, 0, 0.489773,-99)    );
  // itree = 385
  fBoostWeights.push_back(0.215445);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499492,-99) , 
1, 0.841661, 1, 0, 0.641746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577967,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470623,-99) , 
1, 0.296869, 0, 0, 0.506508,-99) , 
3, 0.955884, 0, 0, 0.556568,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0670213,-99) , 
2, 2.16582, 0, 0, 0.340803,-99) , 
0, 3.72955, 1, 0, 0.536462,-99)    );
  // itree = 386
  fBoostWeights.push_back(0.299304);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427143,-99) , 
1, -0.262788, 0, 0, 0.630655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403952,-99) , 
2, -1.2061, 0, 0, 0.616518,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.800125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308141,-99) , 
0, 0.982032, 0, 0, 0.419921,-99) , 
2, -1.00217, 1, 0, 0.46696,-99) , 
1, -0.422881, 0, 0, 0.569633,-99)    );
  // itree = 387
  fBoostWeights.push_back(0.221379);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688449,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480875,-99) , 
3, 0.342039, 0, 0, 0.540003,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371416,-99) , 
3, 3.36803, 0, 0, 0.400294,-99) , 
0, 1.53013, 1, 0, 0.477285,-99) , 
NN(
0, 
0, 
-1, -0.0173103, 1, -1, 0.287648,-99) , 
3, -1.1241, 0, 0, 0.463036,-99)    );
  // itree = 388
  fBoostWeights.push_back(0.197556);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.04621, 0, 1, 0.738994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299844,-99) , 
1, 1.777, 1, 0, 0.53515,-99) , 
1, -0.700332, 1, 0, 0.58066,-99) , 
NN(
NN(
0, 
0, 
-1, 1.92544, 1, 1, 0.604629,-99) , 
NN(
0, 
0, 
-1, 3.02535, 1, -1, 0.419277,-99) , 
3, 2.62389, 0, 0, 0.456064,-99) , 
0, 1.44236, 1, 0, 0.5242,-99)    );
  // itree = 389
  fBoostWeights.push_back(0.215235);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.6973, 0, 1, 0.587386,-99) , 
NN(
0, 
0, 
-1, 3.38894, 1, -1, 0.27104,-99) , 
2, 1.92651, 1, 0, 0.539164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415749,-99) , 
0, -1.98498, 1, 0, 0.441711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195839,-99) , 
3, -1.71356, 0, 0, 0.42573,-99) , 
3, 0.581514, 0, 0, 0.484005,-99)    );
  // itree = 390
  fBoostWeights.push_back(0.151875);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.88363, 0, 1, 0.708375,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.725552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488992,-99) , 
0, -1.55394, 1, 0, 0.511211,-99) , 
NN(
0, 
0, 
-1, -1.59054, 0, -1, 0.288444,-99) , 
3, -1.22591, 0, 0, 0.496391,-99) , 
1, -0.759733, 1, 0, 0.537706,-99)    );
  // itree = 391
  fBoostWeights.push_back(0.145078);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.798369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323028,-99) , 
0, 4.48837, 1, 0, 0.519487,-99) , 
0, -0.684994, 1, 0, 0.529995,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43812,-99) , 
2, -1.01889, 1, 0, 0.546228,-99) , 
NN(
0, 
0, 
-1, 0.81054, 0, -1, 0.320961,-99) , 
1, 0.032123, 1, 0, 0.434168,-99) , 
3, -0.210183, 0, 0, 0.501858,-99)    );
  // itree = 392
  fBoostWeights.push_back(0.2649);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42049,-99) , 
3, 0.614924, 1, 0, 0.60962,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390064,-99) , 
1, 0.721712, 0, 0, 0.45166,-99) , 
3, 0.92126, 1, 0, 0.524286,-99) , 
NN(
0, 
0, 
-1, -1.44085, 1, -1, 0.264098,-99) , 
3, -1.22141, 0, 0, 0.503585,-99)    );
  // itree = 393
  fBoostWeights.push_back(0.22862);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.65168, 1, 1, 0.593277,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492767,-99) , 
1, -0.164732, 0, 0, 0.669372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392697,-99) , 
1, -1.44973, 1, 0, 0.415662,-99) , 
3, 2.64366, 0, 0, 0.455104,-99) , 
0, 0.270085, 1, 0, 0.509225,-99)    );
  // itree = 394
  fBoostWeights.push_back(0.231741);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.96888, 0, 1, 0.588734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158641,-99) , 
0, 3.42696, 1, 0, 0.563232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319479,-99) , 
2, -0.319459, 0, 0, 0.468677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247875,-99) , 
1, 0.159305, 0, 0, 0.433862,-99) , 
1, 0.000731922, 1, 0, 0.498245,-99)    );
  // itree = 395
  fBoostWeights.push_back(0.188886);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.39083, 0, 1, 0.55225,-99) , 
NN(
0, 
0, 
-1, 2.00056, 0, -1, 0.294615,-99) , 
0, 3.55189, 1, 0, 0.527946,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299108,-99) , 
0, -2.75167, 0, 0, 0.446417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210788,-99) , 
0, -1.65122, 1, 0, 0.364041,-99) , 
3, -0.639447, 0, 0, 0.497294,-99)    );
  // itree = 396
  fBoostWeights.push_back(0.265809);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.941189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431011,-99) , 
0, -2.6153, 1, 0, 0.513041,-99) , 
3, -0.615263, 0, 0, 0.587373,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189269,-99) , 
1, 0.97732, 1, 0, 0.554175,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384763,-99) , 
1, 0.783372, 0, 0, 0.428654,-99) , 
2, 0.951351, 0, 0, 0.472538,-99) , 
0, -1.37685, 1, 0, 0.491269,-99)    );
  // itree = 397
  fBoostWeights.push_back(0.231447);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.900636, 1, 1, 0.559494,-99) , 
NN(
0, 
0, 
-1, -0.590321, 0, -1, 0.320542,-99) , 
1, -1.57628, 0, 0, 0.537526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649302,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327553,-99) , 
3, 2.0695, 1, 0, 0.501308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223676,-99) , 
0, -1.51465, 1, 0, 0.290419,-99) , 
3, 1.04128, 0, 0, 0.39789,-99) , 
1, 0.494071, 1, 0, 0.489232,-99)    );
  // itree = 398
  fBoostWeights.push_back(0.183856);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.889865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484463,-99) , 
1, 0.331068, 0, 0, 0.693548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434157,-99) , 
0, -1.79165, 1, 0, 0.451161,-99) , 
2, 2.36172, 0, 0, 0.466905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.105217,-99) , 
0, -3.18592, 0, 0, 0.454178,-99)    );
  // itree = 399
  fBoostWeights.push_back(0.191449);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.51018, 1, 1, 0.907699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202846,-99) , 
3, 3.13206, 0, 0, 0.403808,-99) , 
0, 3.43799, 1, 0, 0.724157,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.839206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488226,-99) , 
0, -1.65019, 1, 0, 0.506787,-99) , 
NN(
0, 
0, 
-1, -0.0809365, 1, -1, 0.367734,-99) , 
3, -1.14424, 0, 0, 0.485247,-99) , 
2, 1.61025, 0, 0, 0.524907,-99)    );
  // itree = 400
  fBoostWeights.push_back(0.258125);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.630084, 1, 1, 0.651431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311632,-99) , 
2, 1.45302, 0, 0, 0.465703,-99) , 
2, 1.15406, 1, 0, 0.552917,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418244,-99) , 
3, 0.0261349, 0, 0, 0.459036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188481,-99) , 
3, 0.500409, 0, 0, 0.330684,-99) , 
0, 0.0100771, 1, 0, 0.427418,-99) , 
3, 0.660704, 0, 0, 0.491444,-99)    );
  // itree = 401
  fBoostWeights.push_back(0.246214);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427187,-99) , 
3, -1.28629, 0, 0, 0.693264,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437865,-99) , 
1, 0.993239, 0, 0, 0.476197,-99) , 
1, -0.673494, 1, 0, 0.522284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688018,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323587,-99) , 
2, 1.02323, 1, 0, 0.388979,-99) , 
1, 1.82989, 0, 0, 0.421761,-99) , 
0, 1.23997, 1, 0, 0.479843,-99)    );
  // itree = 402
  fBoostWeights.push_back(0.296025);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.313188, 0, 1, 0.846662,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437245,-99) , 
2, -0.435625, 0, 0, 0.489595,-99) , 
2, 0.081106, 0, 0, 0.58617,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350166,-99) , 
3, 1.75785, 1, 0, 0.491706,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203373,-99) , 
2, 1.70827, 0, 0, 0.311481,-99) , 
1, -0.749593, 0, 0, 0.449544,-99) , 
0, 0.522083, 1, 0, 0.508304,-99)    );
  // itree = 403
  fBoostWeights.push_back(0.262811);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436136,-99) , 
1, 0.119353, 1, 0, 0.596193,-99) , 
NN(
0, 
0, 
-1, -0.950942, 1, -1, 0.375261,-99) , 
1, -0.823353, 0, 0, 0.534097,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.729866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485764,-99) , 
1, 1.54935, 0, 0, 0.564046,-99) , 
NN(
0, 
0, 
-1, -0.173046, 0, -1, 0.362153,-99) , 
3, -0.240776, 1, 0, 0.408174,-99) , 
1, 0.494071, 1, 0, 0.491622,-99)    );
  // itree = 404
  fBoostWeights.push_back(0.182554);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.894128,-99) , 
NN(
NN(
0, 
0, 
-1, 3.72885, 1, 1, 0.673127,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446211,-99) , 
0, 0.426463, 1, 0, 0.511886,-99) , 
3, 2.47882, 0, 0, 0.529382,-99) , 
1, -2.0516, 1, 0, 0.541197,-99)    );
  // itree = 405
  fBoostWeights.push_back(0.198925);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.42032, 1, 1, 0.562632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311466,-99) , 
1, 1.67189, 1, 0, 0.533909,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422008,-99) , 
3, 0.264658, 1, 0, 0.49136,-99) , 
NN(
0, 
0, 
-1, -0.0304758, 0, -1, 0.20394,-99) , 
1, -0.135376, 1, 0, 0.442491,-99) , 
1, 0.0462137, 0, 0, 0.48174,-99)    );
  // itree = 406
  fBoostWeights.push_back(0.306951);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.176272, 1, 1, 0.673333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.322755,-99) , 
3, -1.58131, 0, 0, 0.638467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727453,-99) , 
NN(
0, 
0, 
-1, -0.946702, 0, -1, 0.389554,-99) , 
1, -1.39701, 1, 0, 0.421169,-99) , 
0, 1.23997, 1, 0, 0.535104,-99)    );
  // itree = 407
  fBoostWeights.push_back(0.245967);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483008,-99) , 
2, 1.10259, 0, 0, 0.564146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222658,-99) , 
0, 4.30407, 1, 0, 0.552145,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286645,-99) , 
1, -0.345412, 1, 0, 0.379832,-99) , 
NN(
0, 
0, 
-1, -1.51343, 1, -1, 0.221889,-99) , 
1, -0.866019, 0, 0, 0.330998,-99) , 
3, -0.18324, 0, 0, 0.498767,-99)    );
  // itree = 408
  fBoostWeights.push_back(0.1202);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.61353, 1, 1, 0.53162,-99) , 
NN(
0, 
0, 
-1, 0.308936, 0, -1, 0.440018,-99) , 
1, -0.231192, 1, 0, 0.474037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194346,-99) , 
2, 2.34272, 1, 0, 0.462724,-99)    );
  // itree = 409
  fBoostWeights.push_back(0.213979);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.661822, 1, 1, 0.842189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323009,-99) , 
1, -0.179142, 1, 0, 0.494024,-99) , 
2, 1.87992, 1, 0, 0.69009,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470915,-99) , 
2, -1.45309, 0, 0, 0.636757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361364,-99) , 
3, -0.0304765, 0, 0, 0.492581,-99) , 
2, -1.04522, 1, 0, 0.513148,-99) , 
3, 2.25475, 0, 0, 0.541609,-99)    );
  // itree = 410
  fBoostWeights.push_back(0.230086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.45568, 0, 1, 0.812642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39414,-99) , 
2, 2.35944, 0, 0, 0.536632,-99) , 
2, 1.93715, 1, 0, 0.676158,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366104,-99) , 
2, 1.56568, 1, 0, 0.560377,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427899,-99) , 
0, -1.41415, 1, 0, 0.455173,-99) , 
2, 1.03299, 0, 0, 0.477668,-99) , 
3, 2.15544, 0, 0, 0.51162,-99)    );
  // itree = 411
  fBoostWeights.push_back(0.273684);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493272,-99) , 
3, 0.958031, 0, 0, 0.676036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328966,-99) , 
3, 2.50191, 0, 0, 0.44291,-99) , 
0, 2.15953, 1, 0, 0.570782,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475766,-99) , 
3, -0.537409, 0, 0, 0.587177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39204,-99) , 
3, 0.370101, 0, 0, 0.417071,-99) , 
1, -0.673494, 1, 0, 0.459887,-99) , 
3, 0.660704, 0, 0, 0.516886,-99)    );
  // itree = 412
  fBoostWeights.push_back(0.277401);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716398,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497769,-99) , 
3, -1.12418, 0, 0, 0.651361,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.323028,-99) , 
2, 0.0897293, 0, 0, 0.490316,-99) , 
0, 0.0603933, 1, 0, 0.580891,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39973,-99) , 
2, 1.2513, 1, 0, 0.459283,-99) , 
NN(
0, 
0, 
-1, 1.02435, 1, -1, 0.247459,-99) , 
3, 1.3426, 0, 0, 0.399446,-99) , 
2, 0.772657, 1, 0, 0.511493,-99)    );
  // itree = 413
  fBoostWeights.push_back(0.265243);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42047,-99) , 
3, -0.677586, 0, 0, 0.567777,-99) , 
1, -1.95602, 1, 0, 0.583206,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438277,-99) , 
1, 1.30599, 1, 0, 0.580757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250141,-99) , 
1, 1.78079, 0, 0, 0.349955,-99) , 
2, 0.465034, 1, 0, 0.441529,-99) , 
1, 0.893255, 1, 0, 0.553712,-99)    );
  // itree = 414
  fBoostWeights.push_back(0.138487);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.75966, 1, 1, 0.762677,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378584,-99) , 
3, -0.875733, 0, 0, 0.508185,-99) , 
NN(
0, 
0, 
-1, 2.23257, 0, -1, 0.32151,-99) , 
2, 1.89527, 1, 0, 0.493978,-99) , 
1, -1.38738, 1, 0, 0.51511,-99)    );
  // itree = 415
  fBoostWeights.push_back(0.288774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.267251, 0, 1, 0.779603,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46967,-99) , 
1, -0.38645, 1, 0, 0.569929,-99) , 
3, -1.4607, 1, 0, 0.62165,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257025,-99) , 
0, 3.0608, 1, 0, 0.488257,-99) , 
NN(
0, 
0, 
-1, 0.595627, 0, -1, 0.166407,-99) , 
0, 0.767627, 0, 0, 0.441898,-99) , 
0, 0.456922, 1, 0, 0.512295,-99)    );
  // itree = 416
  fBoostWeights.push_back(0.276634);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.82006, 1, 1, 0.773328,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358251,-99) , 
2, 0.159127, 1, 0, 0.524699,-99) , 
3, 1.20919, 0, 0, 0.596218,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244574,-99) , 
2, 1.99644, 1, 0, 0.53625,-99) , 
NN(
0, 
0, 
-1, 0.911279, 1, -1, 0.389027,-99) , 
3, 1.26576, 0, 0, 0.446771,-99) , 
1, -0.39136, 1, 0, 0.495592,-99)    );
  // itree = 417
  fBoostWeights.push_back(0.298232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.13743, 0, 1, 0.760406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191042,-99) , 
2, 0.544727, 0, 0, 0.488781,-99) , 
2, 0.161708, 1, 0, 0.614738,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352562,-99) , 
3, -0.210183, 0, 0, 0.534769,-99) , 
NN(
0, 
0, 
-1, 0.410075, 1, -1, 0.39708,-99) , 
1, -0.748338, 1, 0, 0.449613,-99) , 
1, -0.0220652, 0, 0, 0.530108,-99)    );
  // itree = 418
  fBoostWeights.push_back(0.263554);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.921768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45149,-99) , 
0, 2.49832, 1, 0, 0.720021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533563,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368508,-99) , 
0, 0.623399, 1, 0, 0.47898,-99) , 
3, 1.34932, 0, 0, 0.515234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287078,-99) , 
0, 3.67224, 1, 0, 0.531449,-99) , 
NN(
0, 
0, 
-1, 1.72236, 1, -1, 0.226352,-99) , 
3, 2.05631, 0, 0, 0.357183,-99) , 
2, 1.43963, 1, 0, 0.484139,-99)    );
  // itree = 419
  fBoostWeights.push_back(0.17317);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38411,-99) , 
3, -0.55217, 0, 0, 0.508946,-99) , 
NN(
0, 
0, 
-1, 3.925, 1, -1, 0.280254,-99) , 
2, 1.9346, 1, 0, 0.494426,-99) , 
NN(
0, 
0, 
-1, 0.565738, 1, -1, 0.213351,-99) , 
1, -1.69021, 0, 0, 0.472745,-99)    );
  // itree = 420
  fBoostWeights.push_back(0.178789);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498774,-99) , 
0, 1.78684, 0, 0, 0.524854,-99) , 
NN(
0, 
0, 
-1, -0.28837, 0, -1, 0.305695,-99) , 
0, 2.96715, 1, 0, 0.506429,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387068,-99) , 
3, 0.375896, 0, 0, 0.574647,-99) , 
NN(
0, 
0, 
-1, 1.15598, 1, -1, 0.29135,-99) , 
1, 1.38192, 0, 0, 0.396268,-99) , 
1, 0.728565, 1, 0, 0.473468,-99)    );
  // itree = 421
  fBoostWeights.push_back(0.208785);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417743,-99) , 
3, -1.57965, 0, 0, 0.673149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295022,-99) , 
0, 0.277897, 0, 0, 0.502114,-99) , 
0, -0.0682969, 1, 0, 0.565158,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295228,-99) , 
2, -0.809008, 0, 0, 0.468671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173911,-99) , 
2, 1.69214, 1, 0, 0.430616,-99) , 
1, 0.24729, 1, 0, 0.510862,-99)    );
  // itree = 422
  fBoostWeights.push_back(0.25293);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.674912, 1, 1, 0.69272,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406552,-99) , 
3, 1.94919, 0, 0, 0.488857,-99) , 
0, 1.54644, 1, 0, 0.540351,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740671,-99) , 
NN(
0, 
0, 
-1, -1.49903, 0, -1, 0.382553,-99) , 
2, -1.76245, 1, 0, 0.420754,-99) , 
3, 0.306962, 0, 0, 0.494073,-99)    );
  // itree = 423
  fBoostWeights.push_back(0.291419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.10488, 1, 1, 0.572226,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.23244,-99) , 
1, -0.610343, 1, 0, 0.368648,-99) , 
3, -0.883969, 0, 0, 0.52765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706186,-99) , 
NN(
0, 
0, 
-1, 0.996883, 0, -1, 0.32258,-99) , 
2, 0.435554, 1, 0, 0.352195,-99) , 
3, 0.816421, 1, 0, 0.44045,-99)    );
  // itree = 424
  fBoostWeights.push_back(0.229132);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.582096, 0, 1, 0.771577,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13176,-99) , 
3, -0.960005, 0, 0, 0.553349,-99) , 
NN(
0, 
0, 
-1, 0.441553, 0, -1, 0.424669,-99) , 
2, 0.0472263, 1, 0, 0.463246,-99) , 
0, -2.41149, 1, 0, 0.487039,-99)    );
  // itree = 425
  fBoostWeights.push_back(0.219537);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.875704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357586,-99) , 
3, -1.8378, 0, 0, 0.672162,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224955,-99) , 
0, 4.65568, 1, 0, 0.532818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291788,-99) , 
0, 0.0388833, 1, 0, 0.398733,-99) , 
3, 1.08612, 0, 0, 0.455884,-99) , 
0, -2.27176, 1, 0, 0.472221,-99)    );
  // itree = 426
  fBoostWeights.push_back(0.280932);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.90039, 1, 1, 0.622363,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402158,-99) , 
0, -0.911031, 1, 0, 0.482746,-99) , 
2, 0.560086, 0, 0, 0.540382,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411045,-99) , 
2, 0.514435, 1, 0, 0.603609,-99) , 
NN(
0, 
0, 
-1, 0.33047, 1, -1, 0.196754,-99) , 
1, 1.49049, 0, 0, 0.34427,-99) , 
1, 1.05945, 1, 0, 0.508245,-99)    );
  // itree = 427
  fBoostWeights.push_back(0.219977);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.3086, 0, 1, 0.609717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71663,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375408,-99) , 
3, 3.06115, 0, 0, 0.450108,-99) , 
0, 2.84111, 1, 0, 0.545807,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415148,-99) , 
1, -0.00254372, 1, 0, 0.497475,-99) , 
NN(
0, 
0, 
-1, 0.547803, 0, -1, 0.279593,-99) , 
0, 0.683581, 1, 0, 0.450718,-99) , 
3, 0.908704, 0, 0, 0.488764,-99)    );
  // itree = 428
  fBoostWeights.push_back(0.252354);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416502,-99) , 
2, 1.36632, 1, 0, 0.566234,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417188,-99) , 
1, -0.921358, 1, 0, 0.45705,-99) , 
2, 0.919385, 0, 0, 0.479955,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367068,-99) , 
1, 0.411144, 1, 0, 0.537721,-99) , 
NN(
0, 
0, 
-1, -0.530747, 1, -1, 0.181015,-99) , 
1, -0.111437, 0, 0, 0.388634,-99) , 
0, 2.76471, 1, 0, 0.465431,-99)    );
  // itree = 429
  fBoostWeights.push_back(0.248498);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.521342, 1, 1, 0.617022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649852,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405612,-99) , 
0, 1.97742, 0, 0, 0.461863,-99) , 
1, -0.759733, 0, 0, 0.586769,-99) , 
NN(
0, 
0, 
-1, -0.139842, 1, -1, 0.309943,-99) , 
2, 1.9346, 1, 0, 0.562196,-99)    );
  // itree = 430
  fBoostWeights.push_back(0.180541);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.978948, 1, 1, 0.766969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379143,-99) , 
3, -1.92311, 0, 0, 0.693111,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484243,-99) , 
1, -0.557811, 1, 0, 0.512273,-99) , 
NN(
0, 
0, 
-1, 1.2663, 1, -1, 0.361935,-99) , 
1, -0.947159, 0, 0, 0.47986,-99) , 
0, -1.53824, 1, 0, 0.512943,-99)    );
  // itree = 431
  fBoostWeights.push_back(0.190927);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.69453, 1, 1, 0.863005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485734,-99) , 
0, 1.4038, 1, 0, 0.545299,-99) , 
2, -1.15678, 1, 0, 0.57383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248142,-99) , 
3, -1.62955, 0, 0, 0.560085,-99)    );
  // itree = 432
  fBoostWeights.push_back(0.254779);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.970697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417936,-99) , 
0, 0.860123, 1, 0, 0.551086,-99) , 
3, 1.57271, 0, 0, 0.569382,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4738,-99) , 
0, 3.11591, 1, 0, 0.560306,-99) , 
NN(
0, 
0, 
-1, 1.50502, 0, -1, 0.286804,-99) , 
0, 2.45829, 0, 0, 0.422693,-99) , 
2, 1.0287, 1, 0, 0.519062,-99)    );
  // itree = 433
  fBoostWeights.push_back(0.339712);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252565,-99) , 
3, -1.42237, 0, 0, 0.619345,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396965,-99) , 
0, -1.63436, 1, 0, 0.440475,-99) , 
1, 0.0687374, 1, 0, 0.532076,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393569,-99) , 
0, 2.56148, 1, 0, 0.553657,-99) , 
NN(
0, 
0, 
-1, 1.99162, 0, -1, 0.284865,-99) , 
1, 0.164749, 0, 0, 0.400726,-99) , 
2, 1.08804, 1, 0, 0.492329,-99)    );
  // itree = 434
  fBoostWeights.push_back(0.199935);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8561,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489094,-99) , 
3, -0.0142382, 1, 0, 0.536226,-99) , 
3, 2.5157, 0, 0, 0.602754,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256996,-99) , 
1, -1.71625, 0, 0, 0.518627,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326011,-99) , 
2, 1.9002, 0, 0, 0.395404,-99) , 
2, 1.0287, 1, 0, 0.476911,-99) , 
1, 0.974762, 0, 0, 0.501044,-99)    );
  // itree = 435
  fBoostWeights.push_back(0.276582);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.670556, 0, 1, 0.759398,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439733,-99) , 
3, 1.98777, 0, 0, 0.499634,-99) , 
2, 0.345751, 1, 0, 0.533613,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337924,-99) , 
3, -1.95704, 0, 0, 0.465202,-99) , 
NN(
0, 
0, 
-1, -1.06461, 0, -1, 0.267036,-99) , 
2, -1.2833, 1, 0, 0.31972,-99) , 
3, 0.183842, 0, 0, 0.453381,-99)    );
  // itree = 436
  fBoostWeights.push_back(0.227297);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.63314, 0, 1, 0.629079,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.786556,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490603,-99) , 
3, 0.481372, 0, 0, 0.575915,-99) , 
NN(
0, 
0, 
-1, -0.225426, 0, -1, 0.396595,-99) , 
1, 0.988758, 0, 0, 0.423098,-99) , 
0, 1.61764, 0, 0, 0.500356,-99)    );
  // itree = 437
  fBoostWeights.push_back(0.281694);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219606,-99) , 
3, -0.11441, 0, 0, 0.589534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341012,-99) , 
1, 0.0260806, 1, 0, 0.423326,-99) , 
2, 1.23528, 1, 0, 0.531232,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223879,-99) , 
1, 0.496826, 1, 0, 0.407203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0179279,-99) , 
2, -1.524, 1, 0, 0.23751,-99) , 
3, -1.27468, 0, 0, 0.357773,-99) , 
3, -0.287638, 0, 0, 0.484366,-99)    );
  // itree = 438
  fBoostWeights.push_back(0.327871);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415012,-99) , 
1, 0.97572, 1, 0, 0.709706,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243469,-99) , 
1, 0.955061, 0, 0, 0.543896,-99) , 
2, 0.661088, 0, 0, 0.612014,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394821,-99) , 
1, 0.101778, 1, 0, 0.501629,-99) , 
NN(
0, 
0, 
-1, 1.44687, 1, -1, 0.38686,-99) , 
1, -0.0436185, 0, 0, 0.422932,-99) , 
1, 0.576791, 0, 0, 0.480917,-99)    );
  // itree = 439
  fBoostWeights.push_back(0.332272);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904053,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48319,-99) , 
0, -2.53228, 1, 0, 0.623274,-99) , 
3, -0.597821, 0, 0, 0.683733,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368557,-99) , 
3, 1.77195, 1, 0, 0.527316,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350113,-99) , 
0, -0.12275, 1, 0, 0.392173,-99) , 
2, 0.951351, 0, 0, 0.45668,-99) , 
0, -0.765111, 1, 0, 0.501715,-99)    );
  // itree = 440
  fBoostWeights.push_back(0.304991);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688307,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418255,-99) , 
3, -1.45289, 0, 0, 0.656645,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418784,-99) , 
1, -1.70565, 0, 0, 0.630121,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.144466,-99) , 
2, 2.54223, 1, 0, 0.554792,-99) , 
NN(
0, 
0, 
-1, 0.608295, 1, -1, 0.307318,-99) , 
3, 1.01257, 0, 0, 0.483749,-99) , 
2, 0.380334, 1, 0, 0.553909,-99)    );
  // itree = 441
  fBoostWeights.push_back(0.0989184);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811359,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489858,-99) , 
3, 1.35914, 0, 0, 0.51498,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285961,-99) , 
2, 1.74682, 0, 0, 0.42105,-99) , 
2, 1.49137, 1, 0, 0.500702,-99) , 
1, -1.81465, 1, 0, 0.509946,-99)    );
  // itree = 442
  fBoostWeights.push_back(0.162746);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.99451, 0, 1, 0.652231,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306951,-99) , 
2, 0.789512, 1, 0, 0.479739,-99) , 
NN(
0, 
0, 
-1, 1.5696, 1, -1, 0.347963,-99) , 
0, 1.26222, 1, 0, 0.43038,-99) , 
3, 2.62856, 0, 0, 0.445575,-99)    );
  // itree = 443
  fBoostWeights.push_back(0.218976);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.682991, 1, 1, 0.60254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419168,-99) , 
2, -0.231324, 0, 0, 0.46267,-99) , 
3, 0.0805779, 0, 0, 0.537748,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492641,-99) , 
0, 2.77408, 1, 0, 0.54567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206702,-99) , 
3, 1.71937, 0, 0, 0.433273,-99) , 
0, 2.04933, 1, 0, 0.506903,-99)    );
  // itree = 444
  fBoostWeights.push_back(0.217631);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574043,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181097,-99) , 
3, -1.03501, 0, 0, 0.555776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.107279,-99) , 
3, 2.76252, 0, 0, 0.352389,-99) , 
0, 3.47057, 1, 0, 0.537486,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15524,-99) , 
0, -2.39856, 1, 0, 0.366371,-99) , 
2, -1.199, 0, 0, 0.52122,-99)    );
  // itree = 445
  fBoostWeights.push_back(0.235348);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700737,-99) , 
NN(
0, 
0, 
-1, 0.763358, 0, -1, 0.450124,-99) , 
2, -0.0982128, 1, 0, 0.469428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738875,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214171,-99) , 
1, -0.357808, 0, 0, 0.459784,-99) , 
NN(
0, 
0, 
-1, 0.219347, 1, -1, 0.266013,-99) , 
3, -0.233084, 0, 0, 0.310938,-99) , 
2, -0.319459, 0, 0, 0.421679,-99)    );
  // itree = 446
  fBoostWeights.push_back(0.240483);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.20904, 1, 1, 0.596577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268302,-99) , 
2, 0.341112, 1, 0, 0.426441,-99) , 
1, 1.10868, 1, 0, 0.575065,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360563,-99) , 
3, -1.59066, 0, 0, 0.495467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240152,-99) , 
0, -1.54851, 1, 0, 0.430403,-99) , 
3, -0.773433, 0, 0, 0.554617,-99)    );
  // itree = 447
  fBoostWeights.push_back(0.207906);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.61465, 0, 1, 0.680792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153826,-99) , 
0, 3.40989, 1, 0, 0.406321,-99) , 
1, -0.309855, 0, 0, 0.595364,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461683,-99) , 
1, 1.12171, 0, 0, 0.488034,-99) , 
NN(
0, 
0, 
-1, -0.36158, 1, -1, 0.270957,-99) , 
2, 0.937915, 1, 0, 0.460282,-99) , 
2, 1.2182, 0, 0, 0.500344,-99)    );
  // itree = 448
  fBoostWeights.push_back(0.370321);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.2056, 1, 1, 0.695791,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219801,-99) , 
1, 0.0100439, 1, 0, 0.505782,-99) , 
3, -1.04533, 0, 0, 0.654911,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.84437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388758,-99) , 
0, 3.89898, 1, 0, 0.65931,-99) , 
NN(
0, 
0, 
-1, 1.02346, 1, -1, 0.381255,-99) , 
3, 2.16807, 0, 0, 0.46098,-99) , 
0, 1.23997, 1, 0, 0.566122,-99)    );
  // itree = 449
  fBoostWeights.push_back(0.191947);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295045,-99) , 
2, -1.83111, 0, 0, 0.685468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526661,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329048,-99) , 
3, -0.0990853, 0, 0, 0.482503,-99) , 
0, -1.99641, 1, 0, 0.50409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0524299,-99) , 
0, 4.60939, 1, 0, 0.490958,-99)    );
  // itree = 450
  fBoostWeights.push_back(0.284818);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0565847, 0, 1, 0.687961,-99) , 
NN(
0, 
0, 
-1, 1.07682, 1, -1, 0.370456,-99) , 
1, 0.566038, 1, 0, 0.583388,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447451,-99) , 
3, 3.24579, 0, 0, 0.479028,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284254,-99) , 
1, -0.923199, 1, 0, 0.325662,-99) , 
3, 1.16424, 0, 0, 0.394922,-99) , 
0, -0.912281, 1, 0, 0.430935,-99)    );
  // itree = 451
  fBoostWeights.push_back(0.202066);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845191,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429746,-99) , 
1, -0.233935, 1, 0, 0.522728,-99) , 
2, 1.16235, 1, 0, 0.58704,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467865,-99) , 
3, 0.285833, 0, 0, 0.510838,-99) , 
NN(
0, 
0, 
-1, 1.34952, 0, -1, 0.261104,-99) , 
2, 0.979851, 1, 0, 0.474068,-99) , 
3, 1.60661, 0, 0, 0.501738,-99)    );
  // itree = 452
  fBoostWeights.push_back(0.246465);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386834,-99) , 
3, 0.431588, 0, 0, 0.626552,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.344734,-99) , 
2, -0.0516398, 1, 0, 0.488007,-99) , 
2, 0.474887, 0, 0, 0.549064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290605,-99) , 
0, 4.15595, 1, 0, 0.537445,-99)    );
  // itree = 453
  fBoostWeights.push_back(0.2124);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8356,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446097,-99) , 
0, 1.06457, 1, 0, 0.532985,-99) , 
3, 2.78212, 0, 0, 0.562045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79358,-99) , 
NN(
0, 
0, 
-1, -0.834637, 0, -1, 0.409423,-99) , 
1, -2.16421, 1, 0, 0.428508,-99) , 
1, 0.345387, 0, 0, 0.48252,-99)    );
  // itree = 454
  fBoostWeights.push_back(0.237959);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.318377, 1, 1, 0.746381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249491,-99) , 
3, -1.36752, 1, 0, 0.48046,-99) , 
3, -0.946248, 0, 0, 0.586346,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425157,-99) , 
0, 0.146531, 1, 0, 0.454778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178054,-99) , 
3, -0.355824, 0, 0, 0.432878,-99) , 
0, -0.960156, 1, 0, 0.464779,-99)    );
  // itree = 455
  fBoostWeights.push_back(0.210155);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314853,-99) , 
2, 1.39334, 0, 0, 0.527633,-99) , 
2, 0.90302, 1, 0, 0.592837,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466279,-99) , 
2, -1.07559, 1, 0, 0.495921,-99) , 
NN(
0, 
0, 
-1, 1.39872, 0, -1, 0.237129,-99) , 
1, 1.10806, 1, 0, 0.46193,-99) , 
0, 1.96897, 0, 0, 0.500522,-99)    );
  // itree = 456
  fBoostWeights.push_back(0.229356);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.277897, 1, 1, 0.600139,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371721,-99) , 
1, -0.676942, 1, 0, 0.428258,-99) , 
0, -0.11886, 0, 0, 0.549001,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541767,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227859,-99) , 
3, 2.2603, 0, 0, 0.300796,-99) , 
3, -0.250976, 1, 0, 0.343067,-99) , 
1, 0.976475, 1, 0, 0.518688,-99)    );
  // itree = 457
  fBoostWeights.push_back(0.309464);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.631499, 1, 1, 0.656369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249799,-99) , 
3, 1.37839, 0, 0, 0.488521,-99) , 
3, 1.05446, 1, 0, 0.570197,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329471,-99) , 
3, -1.51992, 0, 0, 0.490451,-99) , 
NN(
0, 
0, 
-1, -0.78395, 0, -1, 0.280873,-99) , 
0, -1.59136, 1, 0, 0.375315,-99) , 
3, -0.28269, 0, 0, 0.516843,-99)    );
  // itree = 458
  fBoostWeights.push_back(0.222909);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.343118, 0, 1, 0.614621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448324,-99) , 
2, 0.87215, 1, 0, 0.486245,-99) , 
0, 1.82867, 1, 0, 0.563511,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321418,-99) , 
1, 0.032123, 1, 0, 0.490657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247934,-99) , 
2, -1.16454, 1, 0, 0.388963,-99) , 
2, -0.74824, 0, 0, 0.536297,-99)    );
  // itree = 459
  fBoostWeights.push_back(0.237917);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.463687, 0, 1, 0.648738,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307981,-99) , 
1, -0.823218, 0, 0, 0.452847,-99) , 
2, 1.20473, 1, 0, 0.556373,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448735,-99) , 
0, -0.50401, 0, 0, 0.529446,-99) , 
NN(
0, 
0, 
-1, 0.197999, 0, -1, 0.306858,-99) , 
0, 0.322139, 1, 0, 0.458557,-99) , 
3, 0.660704, 0, 0, 0.510589,-99)    );
  // itree = 460
  fBoostWeights.push_back(0.273147);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.934802, 0, 1, 0.625013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507442,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241236,-99) , 
1, -0.36158, 0, 0, 0.413386,-99) , 
0, 2.27026, 1, 0, 0.571643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626428,-99) , 
NN(
0, 
0, 
-1, -1.42115, 0, -1, 0.283184,-99) , 
0, -3.08407, 1, 0, 0.37166,-99) , 
3, -0.639447, 0, 0, 0.530679,-99)    );
  // itree = 461
  fBoostWeights.push_back(0.22251);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00933, 1, 1, 0.633039,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414135,-99) , 
0, 0.00632581, 1, 0, 0.513393,-99) , 
3, 0.943928, 0, 0, 0.543685,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355843,-99) , 
3, 2.36101, 0, 0, 0.426419,-99) , 
NN(
0, 
0, 
-1, 3.15326, 0, -1, 0.290151,-99) , 
3, 2.82055, 1, 0, 0.391229,-99) , 
0, 2.30263, 1, 0, 0.51057,-99)    );
  // itree = 462
  fBoostWeights.push_back(0.245852);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314149,-99) , 
1, 1.29766, 1, 0, 0.570999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373648,-99) , 
3, 2.06477, 0, 0, 0.462491,-99) , 
0, 1.94237, 1, 0, 0.518275,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3835,-99) , 
2, -0.901867, 1, 0, 0.485295,-99) , 
NN(
0, 
0, 
-1, -0.336695, 0, -1, 0.138204,-99) , 
2, -0.461889, 1, 0, 0.394054,-99) , 
2, -0.224534, 0, 0, 0.47839,-99)    );
  // itree = 463
  fBoostWeights.push_back(0.244005);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.54422, 0, 1, 0.679643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245956,-99) , 
2, 1.35408, 0, 0, 0.533219,-99) , 
0, 2.93865, 1, 0, 0.599313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790241,-99) , 
NN(
0, 
0, 
-1, -0.874799, 0, -1, 0.423541,-99) , 
1, -1.29994, 1, 0, 0.452384,-99) , 
0, 1.63755, 0, 0, 0.506702,-99)    );
  // itree = 464
  fBoostWeights.push_back(0.276694);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408618,-99) , 
0, -1.73891, 0, 0, 0.716855,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296284,-99) , 
0, 1.52006, 0, 0, 0.456966,-99) , 
0, 0.75436, 1, 0, 0.578175,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310585,-99) , 
0, -3.23242, 0, 0, 0.566744,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381353,-99) , 
1, 1.33304, 0, 0, 0.399239,-99) , 
0, -0.922824, 1, 0, 0.435997,-99) , 
1, -0.700332, 1, 0, 0.469139,-99)    );
  // itree = 465
  fBoostWeights.push_back(0.227757);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895289,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343228,-99) , 
0, 3.19023, 1, 0, 0.529073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247949,-99) , 
2, 0.276916, 1, 0, 0.325636,-99) , 
1, -0.955954, 0, 0, 0.491988,-99) , 
1, 1.81136, 0, 0, 0.507526,-99)    );
  // itree = 466
  fBoostWeights.push_back(0.248467);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41385,-99) , 
3, -0.770221, 0, 0, 0.589526,-99) , 
NN(
0, 
0, 
-1, 2.03666, 0, -1, 0.293373,-99) , 
1, 1.60132, 1, 0, 0.565133,-99) , 
NN(
0, 
0, 
-1, 1.12247, 1, -1, 0.372109,-99) , 
1, -0.414745, 0, 0, 0.494686,-99)    );
  // itree = 467
  fBoostWeights.push_back(0.22893);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372374,-99) , 
3, -1.4735, 0, 0, 0.59248,-99) , 
NN(
0, 
0, 
-1, -0.130667, 0, -1, 0.446238,-99) , 
0, -0.824643, 1, 0, 0.471588,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415016,-99) , 
1, -1.63645, 0, 0, 0.471313,-99) , 
NN(
0, 
0, 
-1, 1.37603, 0, -1, 0.190836,-99) , 
1, -1.44239, 1, 0, 0.313605,-99) , 
1, -0.962158, 0, 0, 0.432928,-99)    );
  // itree = 468
  fBoostWeights.push_back(0.20626);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251864,-99) , 
3, -1.4352, 0, 0, 0.541043,-99) , 
NN(
0, 
0, 
-1, -0.368685, 0, -1, 0.286491,-99) , 
0, 3.42696, 1, 0, 0.52048,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325597,-99) , 
0, -1.08575, 0, 0, 0.435442,-99) , 
NN(
0, 
0, 
-1, 1.40734, 1, -1, 0.203398,-99) , 
0, 0.999105, 1, 0, 0.303312,-99) , 
1, 1.17696, 1, 0, 0.490784,-99)    );
  // itree = 469
  fBoostWeights.push_back(0.217974);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.07542, 1, 1, 0.679765,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480916,-99) , 
1, 0.297635, 1, 0, 0.610285,-99) , 
NN(
0, 
0, 
-1, -0.386039, 0, -1, 0.425744,-99) , 
3, 1.31913, 0, 0, 0.493215,-99) , 
1, -0.977314, 1, 0, 0.521621,-99)    );
  // itree = 470
  fBoostWeights.push_back(0.144596);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.44192, 0, 1, 0.827869,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639413,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379391,-99) , 
2, 2.07418, 1, 0, 0.494337,-99) , 
2, 1.75717, 1, 0, 0.626981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643316,-99) , 
NN(
0, 
0, 
-1, -1.81841, 0, -1, 0.454769,-99) , 
1, -1.71379, 1, 0, 0.465026,-99) , 
3, 2.15544, 0, 0, 0.486861,-99)    );
  // itree = 471
  fBoostWeights.push_back(0.172985);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.02031, 1, 1, 0.633946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312694,-99) , 
3, 2.92029, 1, 0, 0.592314,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258562,-99) , 
2, -1.8986, 0, 0, 0.5144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225364,-99) , 
0, 1.42219, 1, 0, 0.484535,-99) , 
3, 1.31913, 0, 0, 0.517452,-99)    );
  // itree = 472
  fBoostWeights.push_back(0.13488);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427436,-99) , 
1, 1.02282, 1, 0, 0.52023,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0758433,-99) , 
3, 3.09058, 0, 0, 0.292788,-99) , 
2, 2.37782, 1, 0, 0.506454,-99) , 
NN(
0, 
0, 
-1, -2.06524, 1, -1, 0.322329,-99) , 
1, -1.65967, 0, 0, 0.492637,-99)    );
  // itree = 473
  fBoostWeights.push_back(0.218114);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.99408, 1, 1, 0.764535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422292,-99) , 
2, -1.61935, 0, 0, 0.623985,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349682,-99) , 
2, 0.871352, 1, 0, 0.433465,-99) , 
NN(
0, 
0, 
-1, -1.08474, 1, -1, 0.227597,-99) , 
3, -0.44022, 0, 0, 0.405911,-99) , 
0, -2.15666, 1, 0, 0.428428,-99)    );
  // itree = 474
  fBoostWeights.push_back(0.180407);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.73512, 1, 1, 0.68887,-99) , 
NN(
NN(
0, 
0, 
-1, 1.62431, 1, 1, 0.693843,-99) , 
NN(
0, 
0, 
-1, 1.09629, 1, -1, 0.434269,-99) , 
1, 1.23023, 0, 0, 0.459292,-99) , 
1, -1.31868, 1, 0, 0.48241,-99)    );
  // itree = 475
  fBoostWeights.push_back(0.29209);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.88895, 0, 1, 0.723393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199939,-99) , 
1, -0.3884, 0, 0, 0.408387,-99) , 
2, 1.77638, 1, 0, 0.617792,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436095,-99) , 
1, -0.551278, 1, 0, 0.481548,-99) , 
NN(
0, 
0, 
-1, -1.32885, 1, -1, 0.273493,-99) , 
1, -1.03486, 0, 0, 0.445148,-99) , 
2, 0.940976, 0, 0, 0.499172,-99)    );
  // itree = 476
  fBoostWeights.push_back(0.305218);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.43772, 0, 1, 0.601147,-99) , 
NN(
0, 
0, 
-1, -0.532972, 1, -1, 0.32626,-99) , 
3, 2.13703, 1, 0, 0.51939,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705137,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2419,-99) , 
3, -1.53829, 0, 0, 0.573744,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305728,-99) , 
3, 0.371791, 0, 0, 0.348699,-99) , 
3, -0.837919, 1, 0, 0.40119,-99) , 
3, 0.660704, 0, 0, 0.459644,-99)    );
  // itree = 477
  fBoostWeights.push_back(0.206202);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.628048, 0, 1, 0.585548,-99) , 
NN(
0, 
0, 
-1, 1.93896, 1, -1, 0.423106,-99) , 
0, 2.04933, 1, 0, 0.53781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618572,-99) , 
NN(
0, 
0, 
-1, -1.72641, 1, -1, 0.241545,-99) , 
3, 1.14489, 0, 0, 0.331769,-99) , 
1, -1.03061, 0, 0, 0.51073,-99)    );
  // itree = 478
  fBoostWeights.push_back(0.18741);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.539664, 0, 1, 0.68956,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202583,-99) , 
3, -1.81241, 0, 0, 0.518256,-99) , 
NN(
0, 
0, 
-1, 0.550848, 0, -1, 0.400764,-99) , 
0, 0.421965, 1, 0, 0.447163,-99) , 
1, 1.40516, 0, 0, 0.469038,-99)    );
  // itree = 479
  fBoostWeights.push_back(0.221271);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -3.46526, 0, 1, 0.761939,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428167,-99) , 
2, 0.473963, 1, 0, 0.487928,-99) , 
NN(
0, 
0, 
-1, -1.31943, 1, -1, 0.334391,-99) , 
3, -0.390366, 0, 0, 0.462418,-99) , 
0, -2.97327, 1, 0, 0.482518,-99)    );
  // itree = 480
  fBoostWeights.push_back(0.139153);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.21281, 0, 1, 0.549413,-99) , 
NN(
NN(
0, 
0, 
-1, 2.11612, 1, 1, 0.626717,-99) , 
NN(
0, 
0, 
-1, 0.561714, 0, -1, 0.278469,-99) , 
1, -0.0633974, 1, 0, 0.412075,-99) , 
2, 1.52556, 1, 0, 0.529464,-99)    );
  // itree = 481
  fBoostWeights.push_back(0.255716);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.24699, 1, 1, 0.864068,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328682,-99) , 
3, 2.23311, 0, 0, 0.517304,-99) , 
0, 2.79004, 1, 0, 0.64372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388708,-99) , 
3, 0.860319, 0, 0, 0.43129,-99) , 
2, -2.18656, 1, 0, 0.442119,-99) , 
3, 1.63873, 0, 0, 0.484377,-99)    );
  // itree = 482
  fBoostWeights.push_back(0.284714);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.55407, 0, 1, 0.716026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472785,-99) , 
1, 1.19811, 1, 0, 0.675986,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0756397,-99) , 
3, -1.75143, 0, 0, 0.539884,-99) , 
NN(
0, 
0, 
-1, -1.09055, 1, -1, 0.298117,-99) , 
1, 0.592363, 1, 0, 0.476009,-99) , 
3, 1.58344, 0, 0, 0.538713,-99)    );
  // itree = 483
  fBoostWeights.push_back(0.247644);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.817695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325367,-99) , 
1, -0.807946, 0, 0, 0.682735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339427,-99) , 
1, 0.490898, 1, 0, 0.602607,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370374,-99) , 
0, -1.27769, 0, 0, 0.572116,-99) , 
NN(
0, 
0, 
-1, 0.30304, 0, -1, 0.418469,-99) , 
0, -0.411953, 1, 0, 0.440919,-99) , 
2, -0.817151, 1, 0, 0.465807,-99)    );
  // itree = 484
  fBoostWeights.push_back(0.230913);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488043,-99) , 
2, 1.76264, 1, 0, 0.647061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328795,-99) , 
1, 0.982607, 1, 0, 0.582299,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441935,-99) , 
3, 0.549704, 0, 0, 0.482562,-99) , 
NN(
0, 
0, 
-1, 1.31224, 0, -1, 0.319053,-99) , 
0, 1.47319, 1, 0, 0.446666,-99) , 
3, 1.5996, 0, 0, 0.47951,-99)    );
  // itree = 485
  fBoostWeights.push_back(0.26757);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425042,-99) , 
3, -0.757204, 0, 0, 0.664992,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71741,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425262,-99) , 
1, -1.93583, 1, 0, 0.455911,-99) , 
1, -0.435098, 0, 0, 0.52996,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433534,-99) , 
1, 0.890798, 1, 0, 0.555801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330706,-99) , 
2, -0.300338, 1, 0, 0.380407,-99) , 
0, 2.86801, 0, 0, 0.408616,-99) , 
1, 0.183541, 1, 0, 0.473424,-99)    );
  // itree = 486
  fBoostWeights.push_back(0.295405);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376041,-99) , 
3, -1.8552, 0, 0, 0.685368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233198,-99) , 
1, 1.32842, 1, 0, 0.649833,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480461,-99) , 
0, 1.97563, 0, 0, 0.57254,-99) , 
NN(
0, 
0, 
-1, 0.877732, 1, -1, 0.36721,-99) , 
2, 0.544727, 0, 0, 0.518844,-99) , 
2, 0.161708, 1, 0, 0.568718,-99)    );
  // itree = 487
  fBoostWeights.push_back(0.245596);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433158,-99) , 
2, 1.55659, 1, 0, 0.565036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25667,-99) , 
0, -0.957876, 0, 0, 0.541673,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.712759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442215,-99) , 
3, -0.617354, 0, 0, 0.48914,-99) , 
NN(
0, 
0, 
-1, -0.176667, 0, -1, 0.223006,-99) , 
0, -0.945227, 1, 0, 0.390704,-99) , 
2, -0.328137, 0, 0, 0.502764,-99)    );
  // itree = 488
  fBoostWeights.push_back(0.210059);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.789384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398736,-99) , 
1, -1.13027, 0, 0, 0.689929,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154556,-99) , 
2, -1.04012, 0, 0, 0.362363,-99) , 
1, 0.198467, 1, 0, 0.590316,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487906,-99) , 
1, 1.4007, 0, 0, 0.52073,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321297,-99) , 
1, -0.733056, 1, 0, 0.373708,-99) , 
3, 0.383101, 0, 0, 0.481253,-99) , 
3, -0.266059, 1, 0, 0.506752,-99)    );
  // itree = 489
  fBoostWeights.push_back(0.155221);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.08051, 0, 1, 0.707606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461472,-99) , 
3, 1.03304, 0, 0, 0.512875,-99) , 
0, -2.3074, 1, 0, 0.525617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236278,-99) , 
0, 3.96484, 1, 0, 0.513899,-99)    );
  // itree = 490
  fBoostWeights.push_back(0.288621);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.71946, 0, 1, 0.735866,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429173,-99) , 
3, 2.82185, 0, 0, 0.561016,-99) , 
0, 2.89653, 1, 0, 0.652128,-99) , 
NN(
NN(
0, 
0, 
-1, 1.40358, 0, 1, 0.590608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228562,-99) , 
0, 0.642846, 1, 0, 0.296722,-99) , 
2, 0.635683, 1, 0, 0.523209,-99) , 
3, 1.42475, 0, 0, 0.556431,-99)    );
  // itree = 491
  fBoostWeights.push_back(0.206145);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.209183, 0, 1, 0.655253,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560077,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426895,-99) , 
1, -0.158286, 1, 0, 0.477376,-99) , 
0, 0.669405, 1, 0, 0.5252,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332622,-99) , 
1, 0.478166, 1, 0, 0.436247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230195,-99) , 
1, -0.844735, 0, 0, 0.391534,-99) , 
2, -0.224534, 0, 0, 0.487681,-99)    );
  // itree = 492
  fBoostWeights.push_back(0.234739);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.428969, 1, 1, 0.944551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424939,-99) , 
3, 1.01807, 0, 0, 0.559532,-99) , 
0, 0.726513, 1, 0, 0.59831,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494168,-99) , 
1, -1.53843, 1, 0, 0.535009,-99) , 
NN(
0, 
0, 
-1, 0.00742748, 0, -1, 0.322265,-99) , 
2, -0.219497, 1, 0, 0.451672,-99) , 
3, 0.392653, 0, 0, 0.53191,-99)    );
  // itree = 493
  fBoostWeights.push_back(0.251704);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378785,-99) , 
2, 1.07598, 1, 0, 0.511907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360364,-99) , 
2, -0.958768, 1, 0, 0.420929,-99) , 
0, 0.31713, 0, 0, 0.471443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0110942,-99) , 
2, 2.31918, 1, 0, 0.452308,-99)    );
  // itree = 494
  fBoostWeights.push_back(0.186251);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.620494, 0, 1, 0.733754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35303,-99) , 
3, 0.0156544, 0, 0, 0.506567,-99) , 
2, -0.939256, 1, 0, 0.54144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688553,-99) , 
NN(
0, 
0, 
-1, 2.10123, 1, -1, 0.421103,-99) , 
0, 3.85918, 0, 0, 0.439011,-99) , 
1, 0.107402, 1, 0, 0.492686,-99)    );
  // itree = 495
  fBoostWeights.push_back(0.194728);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.924707, 0, 1, 0.733921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325852,-99) , 
2, 1.30422, 0, 0, 0.484339,-99) , 
0, 0.401097, 1, 0, 0.580367,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.907103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461619,-99) , 
0, 1.42245, 0, 0, 0.640037,-99) , 
NN(
0, 
0, 
-1, -1.12505, 0, -1, 0.460487,-99) , 
1, -1.4357, 1, 0, 0.481538,-99) , 
1, 0.641961, 0, 0, 0.507189,-99)    );
  // itree = 496
  fBoostWeights.push_back(0.206058);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878528,-99) , 
NN(
NN(
0, 
0, 
-1, 0.170216, 0, 1, 0.609092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581538,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436386,-99) , 
1, -0.11939, 0, 0, 0.51979,-99) , 
0, 0.751386, 1, 0, 0.565718,-99) , 
3, 3.48896, 0, 0, 0.576188,-99)    );
  // itree = 497
  fBoostWeights.push_back(0.20728);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.221929, 1, 1, 0.723607,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452104,-99) , 
1, -0.0229864, 0, 0, 0.526415,-99) , 
2, -0.596664, 1, 0, 0.549546,-99) , 
NN(
0, 
0, 
-1, -1.87959, 1, -1, 0.236438,-99) , 
0, -2.41637, 0, 0, 0.530572,-99)    );
  // itree = 498
  fBoostWeights.push_back(0.191827);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.922744,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499136,-99) , 
1, 0.761126, 0, 0, 0.561714,-99) , 
2, 0.470922, 0, 0, 0.592068,-99) , 
NN(
NN(
0, 
0, 
-1, 2.16582, 1, 1, 0.642959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531308,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387427,-99) , 
0, 1.04133, 1, 0, 0.441432,-99) , 
3, 2.17253, 0, 0, 0.486505,-99) , 
0, 0.0678113, 1, 0, 0.526105,-99)    );
  // itree = 499
  fBoostWeights.push_back(0.195225);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.25882, 0, 1, 0.700682,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328073,-99) , 
3, 0.396017, 0, 0, 0.509091,-99) , 
0, -0.556215, 1, 0, 0.532799,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143036,-99) , 
3, -1.99255, 0, 0, 0.448862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16511,-99) , 
3, -0.626585, 1, 0, 0.36711,-99) , 
2, -0.767121, 0, 0, 0.50588,-99)    );
  // itree = 500
  fBoostWeights.push_back(0.132701);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.88716, 0, 1, 0.719196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477336,-99) , 
0, -1.0796, 1, 0, 0.502404,-99) , 
1, 1.47962, 0, 0, 0.515199,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.117133,-99) , 
0, 3.96657, 1, 0, 0.496517,-99)    );
  // itree = 501
  fBoostWeights.push_back(0.191055);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42386,-99) , 
1, -1.66234, 0, 0, 0.590646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424002,-99) , 
2, 0.834427, 0, 0, 0.47003,-99) , 
1, -0.553853, 1, 0, 0.504473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191112,-99) , 
0, 4.49194, 1, 0, 0.495334,-99)    );
  // itree = 502
  fBoostWeights.push_back(0.270849);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479879,-99) , 
3, -0.332539, 0, 0, 0.590816,-99) , 
NN(
0, 
0, 
-1, -2.01506, 0, -1, 0.270292,-99) , 
3, -1.14453, 0, 0, 0.549004,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319415,-99) , 
2, 1.48564, 1, 0, 0.514061,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300407,-99) , 
1, 1.18868, 0, 0, 0.342542,-99) , 
1, -0.11939, 1, 0, 0.40256,-99) , 
0, 1.32216, 1, 0, 0.488108,-99)    );
  // itree = 503
  fBoostWeights.push_back(0.122177);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304493,-99) , 
1, 0.2359, 1, 0, 0.63169,-99) , 
NN(
0, 
0, 
-1, 2.37288, 1, -1, 0.469293,-99) , 
2, -1.01355, 1, 0, 0.486459,-99) , 
0, -3.02048, 1, 0, 0.496313,-99)    );
  // itree = 504
  fBoostWeights.push_back(0.195825);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485083,-99) , 
0, -1.26508, 1, 0, 0.700149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427677,-99) , 
3, -2.03402, 0, 0, 0.657329,-99) , 
NN(
NN(
0, 
0, 
-1, -1.72431, 0, 1, 0.782477,-99) , 
NN(
0, 
0, 
-1, 0.903316, 0, -1, 0.441564,-99) , 
1, -1.40319, 1, 0, 0.466104,-99) , 
0, -0.822809, 1, 0, 0.503832,-99)    );
  // itree = 505
  fBoostWeights.push_back(0.335653);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.739257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474243,-99) , 
2, 1.13092, 1, 0, 0.691969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275085,-99) , 
1, 0.821661, 1, 0, 0.509222,-99) , 
2, -0.39086, 0, 0, 0.631989,-99) , 
NN(
NN(
0, 
0, 
-1, 2.05792, 0, 1, 0.746717,-99) , 
NN(
0, 
0, 
-1, 0.681906, 0, -1, 0.390294,-99) , 
1, -0.422881, 1, 0, 0.489984,-99) , 
0, 1.94906, 1, 0, 0.585133,-99)    );
  // itree = 506
  fBoostWeights.push_back(0.205636);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363991,-99) , 
1, -1.71379, 0, 0, 0.564463,-99) , 
2, -1.1623, 1, 0, 0.580666,-99) , 
NN(
0, 
0, 
-1, -3.10718, 1, -1, 0.316135,-99) , 
3, -1.3791, 0, 0, 0.557121,-99)    );
  // itree = 507
  fBoostWeights.push_back(0.241533);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.911672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470932,-99) , 
0, 2.14909, 0, 0, 0.5948,-99) , 
2, 0.702604, 1, 0, 0.640846,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833312,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423991,-99) , 
3, -0.590227, 0, 0, 0.688875,-99) , 
NN(
0, 
0, 
-1, -0.416975, 0, -1, 0.4231,-99) , 
1, -1.27139, 1, 0, 0.460714,-99) , 
3, 1.22805, 0, 0, 0.517424,-99)    );
  // itree = 508
  fBoostWeights.push_back(0.259372);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.358092, 0, 1, 0.683358,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342097,-99) , 
2, 1.13475, 1, 0, 0.444085,-99) , 
1, 0.164749, 1, 0, 0.566314,-99) , 
NN(
NN(
0, 
0, 
-1, -1.19903, 0, 1, 0.655906,-99) , 
NN(
0, 
0, 
-1, 0.383477, 1, -1, 0.404808,-99) , 
0, -1.46866, 1, 0, 0.453732,-99) , 
0, 1.23997, 0, 0, 0.501497,-99)    );
  // itree = 509
  fBoostWeights.push_back(0.165363);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.75827, 1, 1, 0.568288,-99) , 
NN(
0, 
0, 
-1, 1.61054, 1, -1, 0.301791,-99) , 
0, 3.30827, 1, 0, 0.540294,-99)    );
  // itree = 510
  fBoostWeights.push_back(0.203898);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474841,-99) , 
0, 0.492494, 0, 0, 0.653552,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267568,-99) , 
0, 3.19023, 1, 0, 0.486815,-99) , 
1, -0.129459, 1, 0, 0.538796,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615425,-99) , 
NN(
0, 
0, 
-1, -1.16258, 0, -1, 0.273446,-99) , 
1, -1.89632, 1, 0, 0.334452,-99) , 
1, -0.977314, 0, 0, 0.50597,-99)    );
  // itree = 511
  fBoostWeights.push_back(0.237263);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96561, 1, 1, 0.651053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436029,-99) , 
1, -1.703, 0, 0, 0.594298,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342453,-99) , 
3, -0.990743, 0, 0, 0.567158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410621,-99) , 
3, 2.70212, 0, 0, 0.438197,-99) , 
2, -0.319459, 1, 0, 0.4727,-99) , 
1, -0.823218, 1, 0, 0.494189,-99)    );
  // itree = 512
  fBoostWeights.push_back(0.310089);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0333563, 0, 1, 0.637457,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355747,-99) , 
3, 1.16872, 0, 0, 0.653241,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378002,-99) , 
1, -0.63333, 1, 0, 0.440262,-99) , 
2, 0.94638, 1, 0, 0.505373,-99) , 
0, 1.14354, 1, 0, 0.578747,-99)    );
  // itree = 513
  fBoostWeights.push_back(0.277252);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864999,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28889,-99) , 
0, 2.74756, 1, 0, 0.522066,-99) , 
3, 3.33492, 0, 0, 0.534356,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379904,-99) , 
2, -0.210125, 1, 0, 0.560838,-99) , 
NN(
0, 
0, 
-1, -1.62234, 1, -1, 0.268222,-99) , 
2, -0.553733, 0, 0, 0.362548,-99) , 
0, -0.773058, 0, 0, 0.494129,-99)    );
  // itree = 514
  fBoostWeights.push_back(0.197769);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447919,-99) , 
3, 1.84717, 0, 0, 0.488264,-99) , 
0, -1.76832, 1, 0, 0.503907,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.179772,-99) , 
0, -2.27423, 1, 0, 0.372136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0603289,-99) , 
3, -1.73052, 0, 0, 0.276205,-99) , 
3, -1.1241, 0, 0, 0.481713,-99)    );
  // itree = 515
  fBoostWeights.push_back(0.195134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.85197, 0, 1, 0.575593,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.264694,-99) , 
3, 1.67531, 0, 0, 0.447472,-99) , 
0, 1.83341, 1, 0, 0.537142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245555,-99) , 
3, -2.1876, 0, 0, 0.52898,-99)    );
  // itree = 516
  fBoostWeights.push_back(0.17257);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.468544, 1, 1, 0.558492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378868,-99) , 
1, 0.551813, 0, 0, 0.426074,-99) , 
2, -0.300529, 0, 0, 0.51762,-99) , 
NN(
0, 
0, 
-1, 4.43535, 1, -1, 0.291461,-99) , 
2, 1.99772, 1, 0, 0.498356,-99)    );
  // itree = 517
  fBoostWeights.push_back(0.16676);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906158,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418743,-99) , 
1, 0.107402, 1, 0, 0.478912,-99) , 
NN(
0, 
0, 
-1, 3.97551, 1, -1, 0.27776,-99) , 
0, 3.00981, 1, 0, 0.460057,-99) , 
3, 3.48896, 0, 0, 0.471978,-99)    );
  // itree = 518
  fBoostWeights.push_back(0.206986);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457467,-99) , 
1, 0.72599, 0, 0, 0.510353,-99) , 
2, 2.02572, 0, 0, 0.53186,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428643,-99) , 
3, 0.815579, 0, 0, 0.453169,-99) , 
NN(
0, 
0, 
-1, -0.493195, 1, -1, 0.26271,-99) , 
3, 1.13577, 1, 0, 0.392135,-99) , 
1, -0.269474, 0, 0, 0.473859,-99)    );
  // itree = 519
  fBoostWeights.push_back(0.29773);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47102,-99) , 
2, -0.243078, 0, 0, 0.626983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268692,-99) , 
3, 2.75891, 1, 0, 0.597609,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.799831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427853,-99) , 
2, -0.615403, 0, 0, 0.56123,-99) , 
NN(
0, 
0, 
-1, 0.590674, 0, -1, 0.375905,-99) , 
3, 0.00766277, 1, 0, 0.44491,-99) , 
1, -0.39136, 0, 0, 0.542212,-99)    );
  // itree = 520
  fBoostWeights.push_back(0.27287);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.72973, 1, 1, 0.600007,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232313,-99) , 
3, 1.44538, 1, 0, 0.362857,-99) , 
1, 1.07215, 1, 0, 0.55344,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277831,-99) , 
2, -1.57682, 0, 0, 0.493354,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591939,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269472,-99) , 
1, -0.6543, 1, 0, 0.329733,-99) , 
2, -0.4939, 1, 0, 0.42014,-99) , 
3, 0.569166, 0, 0, 0.489556,-99)    );
  // itree = 521
  fBoostWeights.push_back(0.172177);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480329,-99) , 
0, -0.798302, 1, 0, 0.513378,-99) , 
NN(
0, 
0, 
-1, -0.304542, 1, -1, 0.365345,-99) , 
3, -0.719586, 0, 0, 0.492442,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146323,-99) , 
0, -1.11749, 0, 0, 0.348698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.207019,-99) , 
0, 1.38502, 1, 0, 0.277531,-99) , 
1, 1.28516, 1, 0, 0.462445,-99)    );
  // itree = 522
  fBoostWeights.push_back(0.241264);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824165,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499401,-99) , 
3, -0.158209, 0, 0, 0.672205,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220254,-99) , 
2, 1.63223, 0, 0, 0.421814,-99) , 
3, 1.11691, 1, 0, 0.579328,-99) , 
NN(
0, 
0, 
-1, 1.43729, 1, -1, 0.408551,-99) , 
1, -0.633389, 1, 0, 0.447987,-99)    );
  // itree = 523
  fBoostWeights.push_back(0.213558);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.2508, 0, 1, 0.83654,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423221,-99) , 
2, 0.818259, 1, 0, 0.689656,-99) , 
NN(
NN(
0, 
0, 
-1, 1.84414, 1, 1, 0.587105,-99) , 
NN(
0, 
0, 
-1, 0.87911, 1, -1, 0.410474,-99) , 
3, 1.07062, 0, 0, 0.473687,-99) , 
1, -1.38738, 1, 0, 0.496628,-99)    );
  // itree = 524
  fBoostWeights.push_back(0.243499);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467533,-99) , 
1, 0.389648, 1, 0, 0.589243,-99) , 
NN(
0, 
0, 
-1, -0.463416, 0, -1, 0.387247,-99) , 
0, 3.49521, 1, 0, 0.566895,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261219,-99) , 
2, -0.676503, 0, 0, 0.435429,-99) , 
NN(
0, 
0, 
-1, 1.90742, 0, -1, 0.312135,-99) , 
2, 0.0985686, 1, 0, 0.365307,-99) , 
1, 1.08213, 1, 0, 0.523057,-99)    );
  // itree = 525
  fBoostWeights.push_back(0.24492);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -3.92086, 1, 1, 0.850131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464254,-99) , 
3, -1.05839, 0, 0, 0.636267,-99) , 
0, -3.21912, 1, 0, 0.691738,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320646,-99) , 
0, 3.70515, 1, 0, 0.538702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.191172,-99) , 
3, -0.31111, 1, 0, 0.341138,-99) , 
3, 0.0307885, 0, 0, 0.499982,-99) , 
0, -0.82073, 1, 0, 0.544763,-99)    );
  // itree = 526
  fBoostWeights.push_back(0.24593);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.133552, 1, 1, 0.602857,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300245,-99) , 
0, -2.1098, 1, 0, 0.448873,-99) , 
3, -0.566199, 0, 0, 0.5699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.25153,-99) , 
0, 1.22501, 1, 0, 0.370663,-99) , 
1, 1.46584, 1, 0, 0.549839,-99)    );
  // itree = 527
  fBoostWeights.push_back(0.190639);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477659,-99) , 
0, -1.90881, 0, 0, 0.659754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449789,-99) , 
1, 0.705761, 0, 0, 0.497986,-99) , 
3, -0.787254, 1, 0, 0.521519,-99) , 
NN(
0, 
0, 
-1, -1.7821, 1, -1, 0.322331,-99) , 
1, -1.37597, 0, 0, 0.501805,-99)    );
  // itree = 528
  fBoostWeights.push_back(0.257998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.335328, 0, 1, 0.731472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410019,-99) , 
2, 0.424326, 1, 0, 0.476029,-99) , 
1, 0.27491, 0, 0, 0.4967,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418957,-99) , 
1, 1.93461, 1, 0, 0.6343,-99) , 
NN(
0, 
0, 
-1, -0.687514, 0, -1, 0.311247,-99) , 
1, 1.65977, 0, 0, 0.371957,-99) , 
1, 0.463922, 1, 0, 0.453333,-99)    );
  // itree = 529
  fBoostWeights.push_back(0.336971);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.792091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434846,-99) , 
1, 0.695133, 1, 0, 0.681319,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422045,-99) , 
3, 1.49298, 0, 0, 0.53544,-99) , 
0, 1.03877, 1, 0, 0.586971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430046,-99) , 
1, -0.281116, 1, 0, 0.567475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230311,-99) , 
2, -0.181688, 0, 0, 0.374657,-99) , 
0, -1.41328, 1, 0, 0.459934,-99) , 
3, -0.123397, 0, 0, 0.547733,-99)    );
  // itree = 530
  fBoostWeights.push_back(0.31239);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.154774, 1, 1, 0.655847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378974,-99) , 
1, 1.12094, 0, 0, 0.448684,-99) , 
3, -0.783995, 0, 0, 0.598651,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276111,-99) , 
3, 1.29496, 0, 0, 0.485369,-99) , 
NN(
0, 
0, 
-1, 3.52041, 0, -1, 0.280357,-99) , 
0, 2.91529, 1, 0, 0.407039,-99) , 
2, 0.988814, 1, 0, 0.541637,-99)    );
  // itree = 531
  fBoostWeights.push_back(0.179213);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809751,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.748883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480734,-99) , 
0, -1.54198, 1, 0, 0.510528,-99) , 
NN(
0, 
0, 
-1, 0.38298, 1, -1, 0.34015,-99) , 
1, -0.426109, 0, 0, 0.457293,-99) , 
1, -2.00084, 1, 0, 0.46949,-99)    );
  // itree = 532
  fBoostWeights.push_back(0.141855);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.927066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492287,-99) , 
1, -1.94005, 0, 0, 0.674109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453139,-99) , 
1, -0.0896913, 0, 0, 0.508362,-99) , 
1, -1.56056, 1, 0, 0.523098,-99) , 
NN(
0, 
0, 
-1, 2.01486, 0, -1, 0.314426,-99) , 
1, 1.53348, 1, 0, 0.508228,-99)    );
  // itree = 533
  fBoostWeights.push_back(0.0660937);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.699421, 1, 1, 0.771127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263225,-99) , 
0, 4.40831, 1, 0, 0.493592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236866,-99) , 
0, -2.2612, 0, 0, 0.483796,-99) , 
2, -1.71432, 1, 0, 0.501498,-99)    );
  // itree = 534
  fBoostWeights.push_back(0.154635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.0222, 0, 1, 0.703313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.814622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494664,-99) , 
1, -1.25907, 1, 0, 0.518241,-99) , 
2, -0.73641, 1, 0, 0.548029,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348974,-99) , 
3, 1.05417, 0, 0, 0.436674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13821,-99) , 
2, 1.50779, 1, 0, 0.356584,-99) , 
1, 0.976475, 1, 0, 0.514054,-99)    );
  // itree = 535
  fBoostWeights.push_back(0.22921);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.519877, 1, 1, 0.765841,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445531,-99) , 
2, 1.62387, 0, 0, 0.501245,-99) , 
1, -0.599375, 0, 0, 0.585722,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476717,-99) , 
1, 0.676394, 0, 0, 0.656814,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389652,-99) , 
0, 0.195823, 1, 0, 0.44378,-99) , 
0, 3.46712, 0, 0, 0.464133,-99) , 
1, -0.271757, 1, 0, 0.511096,-99)    );
  // itree = 536
  fBoostWeights.push_back(0.1738);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.760433,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451467,-99) , 
0, 1.66114, 1, 0, 0.53107,-99) , 
NN(
0, 
0, 
-1, -1.81595, 1, -1, 0.351002,-99) , 
3, -0.590632, 0, 0, 0.505068,-99) , 
2, -2.17786, 1, 0, 0.51492,-99)    );
  // itree = 537
  fBoostWeights.push_back(0.104991);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.387089, 1, 1, 0.776033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669502,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498199,-99) , 
3, 2.47732, 0, 0, 0.515928,-99) , 
0, -1.28288, 1, 0, 0.537865,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0579499,-99) , 
2, -1.60567, 1, 0, 0.336943,-99) , 
3, -1.25183, 0, 0, 0.523623,-99)    );
  // itree = 538
  fBoostWeights.push_back(0.275799);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 3.44354, 0, 1, 0.619673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.123027,-99) , 
2, -1.524, 1, 0, 0.346429,-99) , 
3, -1.15643, 0, 0, 0.59972,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.824324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459484,-99) , 
1, 1.09239, 1, 0, 0.605819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.15471,-99) , 
0, -0.0440438, 1, 0, 0.379447,-99) , 
2, 0.64748, 0, 0, 0.474406,-99) , 
1, 0.71376, 1, 0, 0.566101,-99)    );
  // itree = 539
  fBoostWeights.push_back(0.126883);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.175824, 0, 1, 0.750312,-99) , 
NN(
NN(
0, 
0, 
-1, 1.46102, 0, 1, 0.542756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267636,-99) , 
0, -3.02048, 0, 0, 0.531275,-99) , 
1, -1.54527, 1, 0, 0.544918,-99)    );
  // itree = 540
  fBoostWeights.push_back(0.146505);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.718542,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377132,-99) , 
1, -0.370481, 0, 0, 0.46895,-99) , 
NN(
0, 
0, 
-1, 1.82829, 0, -1, 0.281514,-99) , 
1, 1.50752, 1, 0, 0.451145,-99) , 
1, -1.75262, 1, 0, 0.464685,-99)    );
  // itree = 541
  fBoostWeights.push_back(0.275813);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.068905, 0, 1, 0.630436,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254979,-99) , 
1, 0.223137, 1, 0, 0.394319,-99) , 
1, 0.113751, 1, 0, 0.596062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738899,-99) , 
NN(
0, 
0, 
-1, 3.16868, 1, -1, 0.375897,-99) , 
1, 0.458514, 1, 0, 0.416656,-99) , 
1, 0.307447, 1, 0, 0.531955,-99)    );
  // itree = 542
  fBoostWeights.push_back(0.22941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834817,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233521,-99) , 
3, -0.257638, 0, 0, 0.572995,-99) , 
0, -1.70567, 1, 0, 0.604928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674641,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479324,-99) , 
2, 1.69573, 1, 0, 0.582637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51774,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.186079,-99) , 
3, 0.950306, 1, 0, 0.453528,-99) , 
3, 1.25051, 0, 0, 0.493017,-99) , 
1, 0.467158, 0, 0, 0.529467,-99)    );
  // itree = 543
  fBoostWeights.push_back(0.259963);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467546,-99) , 
0, 0.94291, 0, 0, 0.6756,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553518,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254174,-99) , 
3, 1.3379, 0, 0, 0.495014,-99) , 
2, 0.72811, 1, 0, 0.523961,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67049,-99) , 
NN(
0, 
0, 
-1, -0.754503, 0, -1, 0.360768,-99) , 
1, -1.56786, 1, 0, 0.380701,-99) , 
2, 0.560086, 0, 0, 0.443082,-99)    );
  // itree = 544
  fBoostWeights.push_back(0.145192);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.430408, 0, 1, 0.759371,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494315,-99) , 
1, 0.817881, 0, 0, 0.52133,-99) , 
NN(
0, 
0, 
-1, -1.40996, 0, -1, 0.3884,-99) , 
3, -0.160313, 0, 0, 0.483352,-99) , 
1, 1.41858, 0, 0, 0.507779,-99)    );
  // itree = 545
  fBoostWeights.push_back(0.207914);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.103108, 1, 1, 0.722187,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479352,-99) , 
1, -0.966048, 1, 0, 0.513103,-99) , 
2, 1.24706, 1, 0, 0.584593,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42446,-99) , 
2, -0.815726, 1, 0, 0.545327,-99) , 
NN(
0, 
0, 
-1, -0.783046, 0, -1, 0.404959,-99) , 
0, -1.15832, 1, 0, 0.444336,-99) , 
3, 1.14325, 0, 0, 0.489766,-99)    );
  // itree = 546
  fBoostWeights.push_back(0.231738);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333371,-99) , 
2, 1.47382, 1, 0, 0.642942,-99) , 
NN(
0, 
0, 
-1, 0.0678113, 0, -1, 0.440199,-99) , 
1, 0.593889, 0, 0, 0.481637,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239611,-99) , 
0, 0.416366, 1, 0, 0.366184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0794118,-99) , 
0, -2.12659, 0, 0, 0.308139,-99) , 
1, 1.31099, 1, 0, 0.457132,-99)    );
  // itree = 547
  fBoostWeights.push_back(0.263405);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.596192, 0, 1, 0.689041,-99) , 
NN(
0, 
0, 
-1, 0.832776, 1, -1, 0.44054,-99) , 
3, -0.404067, 0, 0, 0.587684,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587016,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392054,-99) , 
1, 0.0914683, 1, 0, 0.4829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217417,-99) , 
3, 0.427893, 0, 0, 0.449397,-99) , 
2, 0.553856, 1, 0, 0.517728,-99)    );
  // itree = 548
  fBoostWeights.push_back(0.235636);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.847263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484162,-99) , 
3, -2.06791, 0, 0, 0.731155,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334032,-99) , 
3, -0.857119, 0, 0, 0.575898,-99) , 
2, -1.11637, 1, 0, 0.603267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726301,-99) , 
NN(
0, 
0, 
-1, 0.897252, 1, -1, 0.419915,-99) , 
3, 2.70778, 0, 0, 0.46319,-99) , 
1, 0.312617, 1, 0, 0.547364,-99)    );
  // itree = 549
  fBoostWeights.push_back(0.151913);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83042,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482442,-99) , 
2, -0.332275, 1, 0, 0.518477,-99) , 
3, 2.20708, 0, 0, 0.542004,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510993,-99) , 
NN(
0, 
0, 
-1, 3.18394, 1, -1, 0.333882,-99) , 
0, 3.97446, 0, 0, 0.383002,-99) , 
2, 1.50355, 1, 0, 0.512263,-99)    );
  // itree = 550
  fBoostWeights.push_back(0.238);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.75718, 1, 1, 0.73888,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496018,-99) , 
3, -0.683307, 0, 0, 0.693164,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383421,-99) , 
3, 0.252861, 0, 0, 0.470936,-99) , 
NN(
0, 
0, 
-1, 1.45366, 0, -1, 0.311971,-99) , 
0, 2.5577, 1, 0, 0.436664,-99) , 
1, -0.977314, 1, 0, 0.4773,-99)    );
  // itree = 551
  fBoostWeights.push_back(0.232806);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.151522, 0, 1, 0.798792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.650116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415585,-99) , 
2, -0.257756, 1, 0, 0.554082,-99) , 
3, 0.451595, 0, 0, 0.589845,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49733,-99) , 
2, 2.35675, 1, 0, 0.70077,-99) , 
NN(
0, 
0, 
-1, 3.0106, 1, -1, 0.43036,-99) , 
3, 3.03261, 0, 0, 0.461168,-99) , 
0, 0.846748, 1, 0, 0.520446,-99)    );
  // itree = 552
  fBoostWeights.push_back(0.193181);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.782412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340043,-99) , 
2, 1.57133, 1, 0, 0.542627,-99) , 
3, 2.21659, 0, 0, 0.560759,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198274,-99) , 
3, 3.29732, 0, 0, 0.388829,-99) , 
0, 3.72955, 1, 0, 0.549133,-99)    );
  // itree = 553
  fBoostWeights.push_back(0.183337);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465464,-99) , 
2, 0.450303, 1, 0, 0.524148,-99) , 
NN(
0, 
0, 
-1, 3.04096, 1, -1, 0.175909,-99) , 
0, 3.77328, 1, 0, 0.502454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0324294,-99) , 
2, -2.0043, 0, 0, 0.487488,-99)    );
  // itree = 554
  fBoostWeights.push_back(0.211887);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83022,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383288,-99) , 
1, -1.66237, 0, 0, 0.520254,-99) , 
1, -1.9138, 1, 0, 0.605075,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379656,-99) , 
0, 2.14816, 1, 0, 0.463821,-99) , 
NN(
0, 
0, 
-1, -0.278377, 1, -1, 0.385791,-99) , 
3, 0.756786, 0, 0, 0.424584,-99) , 
1, -1.19805, 1, 0, 0.443717,-99)    );
  // itree = 555
  fBoostWeights.push_back(0.311935);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.663997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472022,-99) , 
1, -0.413024, 0, 0, 0.621892,-99) , 
NN(
0, 
0, 
-1, 2.26968, 1, -1, 0.237963,-99) , 
1, -1.26099, 0, 0, 0.570706,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.195319,-99) , 
3, -1.33328, 0, 0, 0.431432,-99) , 
NN(
0, 
0, 
-1, 0.386589, 1, -1, 0.276261,-99) , 
0, -0.117909, 1, 0, 0.363886,-99) , 
2, 0.54983, 0, 0, 0.469286,-99)    );
  // itree = 556
  fBoostWeights.push_back(0.337136);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.854517, 0, 1, 0.68071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407953,-99) , 
3, 1.74808, 0, 0, 0.550956,-99) , 
0, 1.03931, 1, 0, 0.609147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208333,-99) , 
3, -1.80475, 0, 0, 0.598611,-99)    );
  // itree = 557
  fBoostWeights.push_back(0.253021);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430132,-99) , 
3, 1.39043, 1, 0, 0.585469,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40358,-99) , 
2, -1.13063, 1, 0, 0.425626,-99) , 
1, -0.0568535, 1, 0, 0.484444,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515433,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293236,-99) , 
3, 0.442818, 0, 0, 0.407604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.136053,-99) , 
1, -1.09805, 1, 0, 0.331598,-99) , 
1, -0.887646, 0, 0, 0.457929,-99)    );
  // itree = 558
  fBoostWeights.push_back(0.234616);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.228576,-99) , 
3, -2.14818, 0, 0, 0.566139,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330722,-99) , 
1, 1.66315, 1, 0, 0.549171,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308419,-99) , 
3, -0.316848, 0, 0, 0.514132,-99) , 
NN(
0, 
0, 
-1, 0.783998, 1, -1, 0.196953,-99) , 
1, -1.41451, 1, 0, 0.352452,-99) , 
1, -1.03061, 0, 0, 0.516608,-99)    );
  // itree = 559
  fBoostWeights.push_back(0.177249);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436449,-99) , 
0, 1.68258, 1, 0, 0.511942,-99) , 
NN(
0, 
0, 
-1, -1.91432, 1, -1, 0.349823,-99) , 
3, -0.936597, 0, 0, 0.492033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0706753,-99) , 
0, 4.20187, 1, 0, 0.478402,-99)    );
  // itree = 560
  fBoostWeights.push_back(0.246069);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.566, 1, 1, 0.714825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278458,-99) , 
0, 4.70531, 1, 0, 0.676364,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442981,-99) , 
2, -0.812478, 1, 0, 0.474424,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526994,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.314853,-99) , 
0, 0.411401, 0, 0, 0.365971,-99) , 
1, 0.769523, 1, 0, 0.454912,-99) , 
3, 1.32588, 0, 0, 0.523118,-99)    );
  // itree = 561
  fBoostWeights.push_back(0.212313);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.920877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48067,-99) , 
1, 0.539507, 0, 0, 0.550081,-99) , 
2, 0.530301, 1, 0, 0.591277,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432597,-99) , 
1, -0.742444, 0, 0, 0.522274,-99) , 
NN(
0, 
0, 
-1, 0.299468, 0, -1, 0.384111,-99) , 
1, 0.107402, 1, 0, 0.461962,-99) , 
3, 1.14325, 0, 0, 0.516982,-99)    );
  // itree = 562
  fBoostWeights.push_back(0.245923);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.466905, 0, 1, 0.6587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292981,-99) , 
2, 1.92588, 1, 0, 0.622751,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351126,-99) , 
1, 0.244517, 0, 0, 0.516372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.211976,-99) , 
3, 1.36758, 0, 0, 0.429845,-99) , 
0, 1.5337, 1, 0, 0.47975,-99) , 
1, -0.39136, 1, 0, 0.529703,-99)    );
  // itree = 563
  fBoostWeights.push_back(0.151146);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476397,-99) , 
2, -0.0942259, 1, 0, 0.525431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183546,-99) , 
3, 1.98407, 0, 0, 0.371197,-99) , 
2, 1.46199, 1, 0, 0.500285,-99) , 
1, -2.00084, 1, 0, 0.511963,-99)    );
  // itree = 564
  fBoostWeights.push_back(0.0927347);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740055,-99) , 
NN(
0, 
0, 
-1, 2.14036, 1, -1, 0.459951,-99) , 
3, 3.48896, 0, 0, 0.468615,-99)    );
  // itree = 565
  fBoostWeights.push_back(0.182528);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.65186, 0, 1, 0.68596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41382,-99) , 
2, -0.513641, 0, 0, 0.623996,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41844,-99) , 
2, -0.230529, 0, 0, 0.511374,-99) , 
NN(
0, 
0, 
-1, -0.0350231, 0, -1, 0.321903,-99) , 
0, 3.19023, 1, 0, 0.489253,-99) , 
1, -1.09441, 1, 0, 0.50696,-99)    );
  // itree = 566
  fBoostWeights.push_back(0.193573);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450414,-99) , 
0, 0.609636, 0, 0, 0.521138,-99) , 
NN(
0, 
0, 
-1, -1.14609, 0, -1, 0.42527,-99) , 
0, 1.54273, 1, 0, 0.490127,-99) , 
NN(
0, 
0, 
-1, 2.09868, 0, -1, 0.29882,-99) , 
0, 3.91893, 1, 0, 0.476314,-99)    );
  // itree = 567
  fBoostWeights.push_back(0.257478);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478981,-99) , 
0, -0.120333, 1, 0, 0.563542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187682,-99) , 
2, -1.37572, 1, 0, 0.349364,-99) , 
3, -1.01132, 0, 0, 0.520738,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260209,-99) , 
0, 4.12683, 1, 0, 0.527707,-99) , 
NN(
0, 
0, 
-1, 0.79167, 0, -1, 0.310764,-99) , 
1, 0.0170071, 1, 0, 0.39876,-99) , 
0, 0.861216, 1, 0, 0.460251,-99)    );
  // itree = 568
  fBoostWeights.push_back(0.292715);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694787,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490441,-99) , 
1, -0.835449, 0, 0, 0.64251,-99) , 
NN(
0, 
0, 
-1, 4.01119, 1, -1, 0.36663,-99) , 
0, 3.2593, 1, 0, 0.583779,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601365,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392925,-99) , 
0, -0.699768, 1, 0, 0.461938,-99) , 
NN(
0, 
0, 
-1, -1.98023, 0, -1, 0.266521,-99) , 
2, -0.970171, 0, 0, 0.408758,-99) , 
2, 0.442698, 0, 0, 0.498698,-99)    );
  // itree = 569
  fBoostWeights.push_back(0.171301);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0582205, 1, 1, 0.797475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467969,-99) , 
1, -1.46878, 1, 0, 0.483963,-99) , 
0, -0.252128, 1, 0, 0.506227,-99) , 
NN(
NN(
0, 
0, 
-1, -1.66494, 0, 1, 0.600124,-99) , 
NN(
0, 
0, 
-1, -0.515663, 1, -1, 0.324271,-99) , 
0, -2.29078, 1, 0, 0.403143,-99) , 
3, -0.266059, 0, 0, 0.480358,-99)    );
  // itree = 570
  fBoostWeights.push_back(0.255847);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.47416, 1, 1, 0.634686,-99) , 
NN(
0, 
0, 
-1, -0.688591, 1, -1, 0.351347,-99) , 
3, -1.17717, 0, 0, 0.606198,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380838,-99) , 
1, 1.74047, 1, 0, 0.549473,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214897,-99) , 
0, 0.175789, 1, 0, 0.349541,-99) , 
1, 0.552944, 0, 0, 0.51149,-99) , 
1, 0.414129, 1, 0, 0.566963,-99)    );
  // itree = 571
  fBoostWeights.push_back(0.314161);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453745,-99) , 
0, 2.7477, 1, 0, 0.66372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418573,-99) , 
0, -1.27234, 1, 0, 0.504894,-99) , 
0, 0.0848771, 0, 0, 0.60091,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63828,-99) , 
NN(
0, 
0, 
-1, 1.33374, 1, -1, 0.325794,-99) , 
1, 1.82183, 0, 0, 0.386194,-99) , 
1, 0.71376, 1, 0, 0.551151,-99)    );
  // itree = 572
  fBoostWeights.push_back(0.19715);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438297,-99) , 
0, 4.16891, 1, 0, 0.668989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360039,-99) , 
1, 0.146055, 1, 0, 0.517038,-99) , 
2, 1.24313, 0, 0, 0.553468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661314,-99) , 
NN(
0, 
0, 
-1, 2.25336, 1, -1, 0.410236,-99) , 
2, -1.25845, 1, 0, 0.439713,-99) , 
1, 0.345387, 1, 0, 0.508867,-99)    );
  // itree = 573
  fBoostWeights.push_back(0.19651);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62653,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49897,-99) , 
1, 0.0774203, 0, 0, 0.56724,-99) , 
NN(
0, 
0, 
-1, -0.323942, 1, -1, 0.328225,-99) , 
3, -0.475757, 0, 0, 0.525494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0262833,-99) , 
0, 4.21055, 1, 0, 0.51168,-99)    );
  // itree = 574
  fBoostWeights.push_back(0.170743);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.22204, 0, 1, 0.551854,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38258,-99) , 
1, 0.635622, 1, 0, 0.434508,-99) , 
1, 0.463922, 1, 0, 0.515569,-99) , 
NN(
0, 
0, 
-1, 3.0839, 0, -1, 0.232668,-99) , 
2, 2.05606, 1, 0, 0.495407,-99)    );
  // itree = 575
  fBoostWeights.push_back(0.256317);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.17565, 1, 1, 0.634246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335411,-99) , 
2, 1.46592, 1, 0, 0.45452,-99) , 
1, -0.39136, 0, 0, 0.579057,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570947,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303871,-99) , 
1, -1.46955, 1, 0, 0.349687,-99) , 
0, -0.610895, 0, 0, 0.41512,-99) , 
3, -0.123397, 0, 0, 0.524721,-99)    );
  // itree = 576
  fBoostWeights.push_back(0.227744);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.515896, 1, 1, 0.675602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.178629,-99) , 
1, -0.213943, 0, 0, 0.433755,-99) , 
2, -1.22242, 0, 0, 0.586381,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640358,-99) , 
NN(
0, 
0, 
-1, 2.3759, 1, -1, 0.405999,-99) , 
1, -1.40673, 1, 0, 0.419285,-99) , 
0, -0.733992, 1, 0, 0.453841,-99)    );
  // itree = 577
  fBoostWeights.push_back(0.154985);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.286828, 0, 1, 0.592231,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459276,-99) , 
3, 2.92626, 0, 0, 0.480045,-99) , 
1, -0.160588, 1, 0, 0.519851,-99) , 
NN(
0, 
0, 
-1, -1.81471, 0, -1, 0.294424,-99) , 
3, -1.39739, 0, 0, 0.506688,-99)    );
  // itree = 578
  fBoostWeights.push_back(0.275738);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.311399, 1, 1, 0.58013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.298895,-99) , 
3, 2.45066, 0, 0, 0.423447,-99) , 
2, 1.52278, 1, 0, 0.531444,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.864712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305652,-99) , 
1, 1.18432, 1, 0, 0.598461,-99) , 
NN(
0, 
0, 
-1, -1.68904, 0, -1, 0.320721,-99) , 
1, 0.779808, 0, 0, 0.369849,-99) , 
3, -0.123397, 0, 0, 0.480727,-99)    );
  // itree = 579
  fBoostWeights.push_back(0.233833);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.258343, 1, 1, 0.638406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432275,-99) , 
2, -0.733164, 0, 0, 0.599691,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304667,-99) , 
2, -1.22491, 0, 0, 0.532372,-99) , 
NN(
0, 
0, 
-1, 0.0334873, 0, -1, 0.406454,-99) , 
0, -0.811078, 1, 0, 0.431452,-99) , 
1, 0.71376, 0, 0, 0.465558,-99)    );
  // itree = 580
  fBoostWeights.push_back(0.317479);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415486,-99) , 
1, -0.665982, 0, 0, 0.61528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391023,-99) , 
1, -0.512935, 1, 0, 0.472573,-99) , 
0, 2.10158, 1, 0, 0.567693,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297756,-99) , 
3, -1.92199, 0, 0, 0.537278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265001,-99) , 
0, -1.23351, 1, 0, 0.443023,-99) , 
2, -0.767121, 0, 0, 0.54941,-99)    );
  // itree = 581
  fBoostWeights.push_back(0.220146);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837325,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361726,-99) , 
3, -1.34579, 0, 0, 0.543208,-99) , 
1, 0.778006, 0, 0, 0.633762,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466331,-99) , 
2, 0.534799, 1, 0, 0.509996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273191,-99) , 
1, -0.65168, 1, 0, 0.342422,-99) , 
0, 0.122484, 0, 0, 0.466358,-99) , 
0, -1.525, 1, 0, 0.48244,-99)    );
  // itree = 582
  fBoostWeights.push_back(0.18648);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.779517, 1, 1, 0.583825,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7156,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442797,-99) , 
1, 1.05543, 0, 0, 0.484326,-99) , 
2, 0.604931, 0, 0, 0.526408,-99) , 
NN(
0, 
0, 
-1, 0.17816, 1, -1, 0.278975,-99) , 
1, -1.6752, 0, 0, 0.508926,-99)    );
  // itree = 583
  fBoostWeights.push_back(0.252292);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.81647, 1, 1, 0.677112,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437762,-99) , 
3, 0.943126, 0, 0, 0.458205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260854,-99) , 
0, 1.42219, 1, 0, 0.428457,-99) , 
3, 1.31913, 0, 0, 0.508741,-99)    );
  // itree = 584
  fBoostWeights.push_back(0.186148);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.10682, 0, 1, 0.636055,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461244,-99) , 
2, 0.32459, 1, 0, 0.505357,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.230679,-99) , 
2, -0.365653, 0, 0, 0.364325,-99) , 
3, 0.0334873, 0, 0, 0.484101,-99) , 
0, -0.691462, 1, 0, 0.520037,-99)    );
  // itree = 585
  fBoostWeights.push_back(0.175343);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.56224, 1, 1, 0.718675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386883,-99) , 
2, -1.58626, 0, 0, 0.547891,-99) , 
2, 1.66691, 0, 0, 0.569869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290558,-99) , 
1, -1.6752, 0, 0, 0.555789,-99)    );
  // itree = 586
  fBoostWeights.push_back(0.228934);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319669,-99) , 
3, -1.16492, 0, 0, 0.515545,-99) , 
0, -3.65989, 1, 0, 0.534841,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790523,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471336,-99) , 
0, 3.5434, 1, 0, 0.572747,-99) , 
NN(
0, 
0, 
-1, 1.24871, 0, -1, 0.336521,-99) , 
3, 2.2113, 0, 0, 0.39658,-99) , 
0, 1.09891, 1, 0, 0.469337,-99)    );
  // itree = 587
  fBoostWeights.push_back(0.159597);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892595,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406458,-99) , 
0, 2.87144, 1, 0, 0.525976,-99) , 
0, -1.78208, 1, 0, 0.544438,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0651882,-99) , 
0, -2.6262, 1, 0, 0.366532,-99) , 
3, -1.22591, 0, 0, 0.532273,-99)    );
  // itree = 588
  fBoostWeights.push_back(0.192332);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.184134, 0, 1, 0.703698,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413151,-99) , 
2, -0.45958, 0, 0, 0.524913,-99) , 
2, -1.24909, 1, 0, 0.545804,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408472,-99) , 
3, 1.97472, 1, 0, 0.591943,-99) , 
NN(
0, 
0, 
-1, 1.01917, 1, -1, 0.38395,-99) , 
1, 1.20139, 0, 0, 0.439747,-99) , 
1, 0.313122, 1, 0, 0.50787,-99)    );
  // itree = 589
  fBoostWeights.push_back(0.252083);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.81769, 1, 1, 0.714372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403878,-99) , 
1, 1.22722, 0, 0, 0.490365,-99) , 
1, 0.274005, 1, 0, 0.606135,-99) , 
NN(
NN(
0, 
0, 
-1, 0.279268, 0, 1, 0.677437,-99) , 
NN(
0, 
0, 
-1, 0.416246, 1, -1, 0.415055,-99) , 
1, -1.27139, 1, 0, 0.447437,-99) , 
3, 1.12947, 0, 0, 0.508126,-99)    );
  // itree = 590
  fBoostWeights.push_back(0.156297);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4177,-99) , 
3, -1.22591, 0, 0, 0.544475,-99) , 
NN(
0, 
0, 
-1, -0.38796, 0, -1, 0.355385,-99) , 
1, -1.69752, 0, 0, 0.531595,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546951,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37001,-99) , 
3, 0.812654, 1, 0, 0.46433,-99) , 
NN(
0, 
0, 
-1, 0.312709, 0, -1, 0.309883,-99) , 
1, 1.45499, 1, 0, 0.367773,-99) , 
1, 1.17696, 1, 0, 0.508561,-99)    );
  // itree = 591
  fBoostWeights.push_back(0.247122);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428351,-99) , 
1, 0.499068, 1, 0, 0.591714,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349264,-99) , 
3, -0.830341, 1, 0, 0.44366,-99) , 
3, -0.0320456, 0, 0, 0.519925,-99) , 
NN(
0, 
0, 
-1, -0.823218, 0, -1, 0.39886,-99) , 
2, 0.661088, 1, 0, 0.471491,-99)    );
  // itree = 592
  fBoostWeights.push_back(0.289794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.25724, 1, 1, 0.704575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421614,-99) , 
2, 1.27618, 1, 0, 0.563667,-99) , 
2, 1.5027, 0, 0, 0.644146,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405499,-99) , 
2, -0.976678, 0, 0, 0.528825,-99) , 
NN(
0, 
0, 
-1, -0.496612, 0, -1, 0.337589,-99) , 
0, 0.530826, 1, 0, 0.441461,-99) , 
3, 1.30886, 0, 0, 0.517174,-99)    );
  // itree = 593
  fBoostWeights.push_back(0.197219);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.281116, 0, 1, 0.712625,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159537,-99) , 
2, -1.19767, 0, 0, 0.532646,-99) , 
NN(
0, 
0, 
-1, -0.253837, 0, -1, 0.423997,-99) , 
0, 0.235728, 1, 0, 0.457426,-99) , 
0, -2.46434, 1, 0, 0.480417,-99)    );
  // itree = 594
  fBoostWeights.push_back(0.275966);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390232,-99) , 
2, 0.266687, 0, 0, 0.646611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271018,-99) , 
1, -0.212287, 0, 0, 0.432899,-99) , 
2, 2.19267, 1, 0, 0.621017,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481846,-99) , 
2, -0.131627, 0, 0, 0.547511,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198388,-99) , 
1, -0.230846, 1, 0, 0.371799,-99) , 
2, 0.397686, 1, 0, 0.499278,-99) , 
3, 0.810124, 0, 0, 0.564872,-99)    );
  // itree = 595
  fBoostWeights.push_back(0.199718);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482815,-99) , 
3, 2.22539, 1, 0, 0.631882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457687,-99) , 
2, 0.345751, 1, 0, 0.488752,-99) , 
1, 0.433814, 0, 0, 0.536809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.79622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440578,-99) , 
0, -0.0455722, 0, 0, 0.48477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.134124,-99) , 
3, 0.551511, 1, 0, 0.453694,-99) , 
0, 0.370203, 0, 0, 0.503716,-99)    );
  // itree = 596
  fBoostWeights.push_back(0.281104);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.11975, 0, 1, 0.6702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252975,-99) , 
1, -0.172415, 0, 0, 0.496052,-99) , 
0, 2.78434, 1, 0, 0.604597,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491038,-99) , 
3, 0.198206, 0, 0, 0.528815,-99) , 
NN(
0, 
0, 
-1, -0.569833, 1, -1, 0.279031,-99) , 
2, 0.297371, 1, 0, 0.427742,-99) , 
3, 0.908704, 0, 0, 0.51047,-99)    );
  // itree = 597
  fBoostWeights.push_back(0.269541);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897767,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.708567,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453618,-99) , 
3, 2.40648, 0, 0, 0.601379,-99) , 
0, 2.65928, 1, 0, 0.6524,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367565,-99) , 
1, -0.281116, 0, 0, 0.648096,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419748,-99) , 
1, 0.354391, 0, 0, 0.470498,-99) , 
2, -0.609485, 1, 0, 0.519039,-99) , 
0, 2.41389, 0, 0, 0.550866,-99)    );
  // itree = 598
  fBoostWeights.push_back(0.279019);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1125, 1, 1, 0.84962,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.740948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463685,-99) , 
1, -0.371918, 1, 0, 0.563403,-99) , 
0, 0.489643, 0, 0, 0.612399,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306987,-99) , 
0, 3.95248, 1, 0, 0.507326,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.755579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308634,-99) , 
1, -1.04068, 1, 0, 0.348711,-99) , 
2, 0.924304, 0, 0, 0.42914,-99) , 
2, 0.161708, 1, 0, 0.503747,-99)    );
  // itree = 599
  fBoostWeights.push_back(0.167087);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.05411, 0, 1, 0.61509,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.831207,-99) , 
NN(
0, 
0, 
-1, 1.09111, 1, -1, 0.464106,-99) , 
1, 1.60186, 0, 0, 0.487045,-99) , 
0, 0.842728, 1, 0, 0.54697,-99)    );
  // itree = 600
  fBoostWeights.push_back(0.263712);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.230426, 0, 1, 0.739622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41598,-99) , 
2, 1.88791, 1, 0, 0.706481,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710151,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494218,-99) , 
1, 0.500724, 0, 0, 0.557035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651417,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363917,-99) , 
0, -0.866362, 1, 0, 0.425153,-99) , 
1, 0.874128, 1, 0, 0.514789,-99) , 
1, -0.39136, 1, 0, 0.571574,-99)    );
  // itree = 601
  fBoostWeights.push_back(0.0919951);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.39057, 0, 1, 0.720781,-99) , 
NN(
0, 
0, 
-1, -1.06798, 0, -1, 0.475793,-99) , 
2, -1.199, 1, 0, 0.502788,-99)    );
  // itree = 602
  fBoostWeights.push_back(0.225689);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.353142, 1, 1, 0.614489,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16031,-99) , 
2, -0.281121, 1, 0, 0.429603,-99) , 
0, -0.964069, 0, 0, 0.582395,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694807,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450502,-99) , 
3, -0.848688, 1, 0, 0.478222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193826,-99) , 
0, 2.55033, 1, 0, 0.435123,-99) , 
1, 0.307447, 1, 0, 0.527869,-99)    );
  // itree = 603
  fBoostWeights.push_back(0.270379);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.93013, 1, 1, 0.601011,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.180559,-99) , 
3, 0.445262, 0, 0, 0.390438,-99) , 
1, 1.32658, 1, 0, 0.574711,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651552,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.190621,-99) , 
0, 4.57071, 1, 0, 0.577644,-99) , 
NN(
0, 
0, 
-1, 2.23023, 1, -1, 0.339727,-99) , 
3, 1.99841, 0, 0, 0.454495,-99) , 
0, 1.78348, 1, 0, 0.534054,-99)    );
  // itree = 604
  fBoostWeights.push_back(0.400335);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.792193, 0, 1, 0.70646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277172,-99) , 
1, 1.30363, 0, 0, 0.413059,-99) , 
0, 1.84821, 1, 0, 0.612741,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399629,-99) , 
0, 2.60788, 1, 0, 0.535572,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28098,-99) , 
0, -1.9686, 1, 0, 0.338164,-99) , 
3, 0.941591, 0, 0, 0.40403,-99) , 
1, 0.345387, 0, 0, 0.479237,-99)    );
  // itree = 605
  fBoostWeights.push_back(0.255298);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437782,-99) , 
2, -0.0268094, 0, 0, 0.569411,-99) , 
2, -0.985024, 1, 0, 0.583208,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567847,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.213394,-99) , 
0, -2.59609, 1, 0, 0.383625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.118037,-99) , 
2, -1.79998, 0, 0, 0.302154,-99) , 
2, -1.23488, 0, 0, 0.553953,-99)    );
  // itree = 606
  fBoostWeights.push_back(0.153907);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.63314, 1, 1, 0.658809,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390749,-99) , 
2, -0.632974, 0, 0, 0.610386,-99) , 
NN(
0, 
0, 
-1, -3.46128, 0, -1, 0.453383,-99) , 
1, 0.988758, 0, 0, 0.47735,-99) , 
0, 2.89272, 0, 0, 0.50211,-99)    );
  // itree = 607
  fBoostWeights.push_back(0.278633);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.551278, 1, 1, 0.607959,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.150556,-99) , 
2, -0.923648, 1, 0, 0.406866,-99) , 
3, -0.756041, 0, 0, 0.577175,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345596,-99) , 
2, 0.175824, 0, 0, 0.579811,-99) , 
NN(
0, 
0, 
-1, 0.835261, 1, -1, 0.176088,-99) , 
1, -1.52234, 1, 0, 0.334861,-99) , 
1, -1.03815, 0, 0, 0.538736,-99)    );
  // itree = 608
  fBoostWeights.push_back(0.167215);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742345,-99) , 
NN(
0, 
0, 
-1, 0.988814, 1, -1, 0.446424,-99) , 
1, -0.71899, 1, 0, 0.460073,-99) , 
NN(
0, 
0, 
-1, -0.543709, 0, -1, 0.328086,-99) , 
1, -0.916618, 0, 0, 0.435327,-99)    );
  // itree = 609
  fBoostWeights.push_back(0.196436);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.47988, 1, 1, 0.641832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436934,-99) , 
2, 1.72803, 0, 0, 0.474296,-99) , 
2, -0.416576, 1, 0, 0.508411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172393,-99) , 
3, -2.24033, 0, 0, 0.49897,-99)    );
  // itree = 610
  fBoostWeights.push_back(0.287228);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.39136, 0, 1, 0.655118,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420507,-99) , 
1, -0.866019, 1, 0, 0.471276,-99) , 
3, 0.222659, 0, 0, 0.56879,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278001,-99) , 
1, 0.179125, 1, 0, 0.423087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0176147,-99) , 
0, 3.97385, 1, 0, 0.342212,-99) , 
2, 1.58176, 1, 0, 0.535326,-99)    );
  // itree = 611
  fBoostWeights.push_back(0.173802);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.730352, 1, 1, 0.570933,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278677,-99) , 
3, -2.02452, 0, 0, 0.559843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194889,-99) , 
2, 2.31918, 1, 0, 0.544834,-99)    );
  // itree = 612
  fBoostWeights.push_back(0.243209);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.945528, 0, 1, 0.583066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380526,-99) , 
3, 2.55702, 0, 0, 0.425464,-99) , 
3, 1.18116, 1, 0, 0.5132,-99) , 
NN(
0, 
0, 
-1, -0.572275, 0, -1, 0.168759,-99) , 
3, -1.22141, 0, 0, 0.483272,-99)    );
  // itree = 613
  fBoostWeights.push_back(0.219711);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.699522,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472761,-99) , 
2, 0.40048, 0, 0, 0.618625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452865,-99) , 
3, 1.53683, 0, 0, 0.503725,-99) , 
1, -0.63333, 1, 0, 0.531611,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60047,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31481,-99) , 
2, -0.704039, 1, 0, 0.506095,-99) , 
NN(
0, 
0, 
-1, -1.73, 1, -1, 0.19732,-99) , 
1, -0.478841, 0, 0, 0.40197,-99) , 
2, -0.457527, 0, 0, 0.498244,-99)    );
  // itree = 614
  fBoostWeights.push_back(0.171719);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.57271, 0, 1, 0.562126,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365244,-99) , 
3, 2.61326, 0, 0, 0.423388,-99) , 
1, -1.20857, 1, 0, 0.44731,-99) , 
2, 0.838979, 1, 0, 0.51932,-99)    );
  // itree = 615
  fBoostWeights.push_back(0.251054);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475766,-99) , 
2, 1.49387, 1, 0, 0.633084,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425502,-99) , 
2, -0.546369, 1, 0, 0.492635,-99) , 
2, 0.71572, 0, 0, 0.547581,-99) , 
NN(
0, 
0, 
-1, 1.30979, 1, -1, 0.249951,-99) , 
1, 1.53348, 1, 0, 0.526065,-99)    );
  // itree = 616
  fBoostWeights.push_back(0.25078);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402284,-99) , 
2, 0.864834, 1, 0, 0.661891,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13432,-99) , 
1, 1.05886, 1, 0, 0.437499,-99) , 
2, 0.973793, 1, 0, 0.537204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373983,-99) , 
1, -0.546307, 1, 0, 0.436126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143602,-99) , 
1, 1.34775, 1, 0, 0.408991,-99) , 
3, 0.246134, 0, 0, 0.484374,-99)    );
  // itree = 617
  fBoostWeights.push_back(0.223766);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436723,-99) , 
0, 0.89272, 1, 0, 0.510971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214334,-99) , 
3, -1.89734, 1, 0, 0.319836,-99) , 
2, -1.23888, 0, 0, 0.486081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139648,-99) , 
0, 3.94239, 1, 0, 0.470588,-99)    );
  // itree = 618
  fBoostWeights.push_back(0.134865);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.22577, 1, 1, 0.781541,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656634,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484167,-99) , 
3, 2.19353, 0, 0, 0.508407,-99) , 
0, -1.46184, 1, 0, 0.529495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0904003,-99) , 
3, -1.67155, 0, 0, 0.514136,-99)    );
  // itree = 619
  fBoostWeights.push_back(0.273834);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.267897, 1, 1, 0.709747,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366081,-99) , 
1, 0.522288, 1, 0, 0.507063,-99) , 
3, 0.420904, 0, 0, 0.566748,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387392,-99) , 
1, 0.207989, 1, 0, 0.520676,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248462,-99) , 
1, 0.435809, 0, 0, 0.335524,-99) , 
2, 1.47879, 0, 0, 0.416887,-99) , 
3, 1.03866, 1, 0, 0.504527,-99)    );
  // itree = 620
  fBoostWeights.push_back(0.182066);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424315,-99) , 
3, -0.571818, 0, 0, 0.590405,-99) , 
NN(
0, 
0, 
-1, -0.252267, 0, -1, 0.442857,-99) , 
3, -0.307909, 1, 0, 0.473986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220003,-99) , 
3, -2.14818, 0, 0, 0.465234,-99)    );
  // itree = 621
  fBoostWeights.push_back(0.227055);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.240465, 0, 1, 0.59173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291412,-99) , 
2, 1.9346, 1, 0, 0.569217,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409925,-99) , 
1, -0.501168, 1, 0, 0.511898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.352281,-99) , 
2, 1.91816, 0, 0, 0.391843,-99) , 
1, -0.783291, 0, 0, 0.44699,-99) , 
1, -0.294962, 0, 0, 0.524033,-99)    );
  // itree = 622
  fBoostWeights.push_back(0.193585);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369993,-99) , 
1, 1.09458, 1, 0, 0.51476,-99) , 
NN(
0, 
0, 
-1, 1.9833, 0, -1, 0.378228,-99) , 
2, 1.54259, 1, 0, 0.485369,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629404,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329845,-99) , 
2, -1.55104, 0, 0, 0.500013,-99) , 
NN(
0, 
0, 
-1, -1.4193, 1, -1, 0.208412,-99) , 
1, -0.281116, 0, 0, 0.321036,-99) , 
2, -0.876457, 0, 0, 0.458608,-99)    );
  // itree = 623
  fBoostWeights.push_back(0.228007);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.71376, 0, 1, 0.560545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.130661,-99) , 
0, -2.57594, 1, 0, 0.321568,-99) , 
3, -0.899633, 0, 0, 0.523928,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172174,-99) , 
0, 3.70664, 1, 0, 0.424813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0816558,-99) , 
1, 1.05624, 1, 0, 0.349522,-99) , 
3, 2.00287, 1, 0, 0.490517,-99)    );
  // itree = 624
  fBoostWeights.push_back(0.203868);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794844,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553489,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411147,-99) , 
1, -0.465418, 0, 0, 0.507051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.292521,-99) , 
3, 2.60899, 0, 0, 0.366265,-99) , 
3, 1.42475, 1, 0, 0.46866,-99) , 
1, 1.73177, 0, 0, 0.479416,-99)    );
  // itree = 625
  fBoostWeights.push_back(0.184588);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479504,-99) , 
2, 0.243879, 1, 0, 0.512617,-99) , 
NN(
0, 
0, 
-1, -0.690132, 1, -1, 0.39802,-99) , 
3, 0.563752, 0, 0, 0.456439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0814957,-99) , 
1, 0.541854, 0, 0, 0.266093,-99) , 
0, 3.43617, 1, 0, 0.442846,-99)    );
  // itree = 626
  fBoostWeights.push_back(0.148426);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.916662,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580786,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465655,-99) , 
0, 1.60202, 0, 0, 0.493701,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209655,-99) , 
3, 2.97587, 0, 0, 0.345424,-99) , 
0, 3.19769, 1, 0, 0.475574,-99) , 
1, -2.03415, 1, 0, 0.487641,-99)    );
  // itree = 627
  fBoostWeights.push_back(0.219901);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.699469, 0, 1, 0.583743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183559,-99) , 
0, 3.82345, 1, 0, 0.459781,-99) , 
2, 0.744165, 1, 0, 0.541943,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402851,-99) , 
3, 1.60651, 0, 0, 0.46486,-99) , 
NN(
0, 
0, 
-1, 0.441096, 1, -1, 0.299114,-99) , 
1, 0.534476, 0, 0, 0.40217,-99) , 
1, 0.0411464, 1, 0, 0.468083,-99)    );
  // itree = 628
  fBoostWeights.push_back(0.170586);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.235511, 1, 1, 0.562491,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.112801,-99) , 
1, 0.287205, 1, 0, 0.434046,-99) , 
3, -0.713166, 0, 0, 0.545378,-99) , 
NN(
0, 
0, 
-1, -1.1037, 1, -1, 0.377671,-99) , 
1, -0.890715, 0, 0, 0.505584,-99)    );
  // itree = 629
  fBoostWeights.push_back(0.244864);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.118238, 1, 1, 0.645087,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406752,-99) , 
3, 1.34777, 0, 0, 0.477105,-99) , 
1, -0.493896, 1, 0, 0.515374,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62459,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288706,-99) , 
3, -1.46038, 0, 0, 0.38989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143765,-99) , 
2, -0.910852, 1, 0, 0.312713,-99) , 
3, -0.803702, 0, 0, 0.48796,-99)    );
  // itree = 630
  fBoostWeights.push_back(0.220008);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449625,-99) , 
0, 1.14252, 1, 0, 0.52797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379472,-99) , 
1, -1.18813, 1, 0, 0.421913,-99) , 
1, 0.0774203, 0, 0, 0.473043,-99) , 
NN(
0, 
0, 
-1, 1.87949, 1, -1, 0.218558,-99) , 
0, 3.45982, 1, 0, 0.456285,-99)    );
  // itree = 631
  fBoostWeights.push_back(0.158389);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, -1.71949, 0, -1, 0.473534,-99) , 
3, 1.86505, 0, 0, 0.501918,-99) , 
NN(
0, 
0, 
-1, 1.80339, 0, -1, 0.333262,-99) , 
0, 2.23135, 1, 0, 0.462904,-99)    );
  // itree = 632
  fBoostWeights.push_back(0.344269);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441867,-99) , 
2, 1.56654, 1, 0, 0.618512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260333,-99) , 
2, 1.32647, 0, 0, 0.404317,-99) , 
1, -0.823218, 0, 0, 0.583179,-99) , 
NN(
NN(
0, 
0, 
-1, -0.771336, 0, 1, 0.623964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262048,-99) , 
0, -1.61327, 1, 0, 0.379987,-99) , 
1, -0.371918, 1, 0, 0.4545,-99) , 
0, -0.106773, 0, 0, 0.541871,-99)    );
  // itree = 633
  fBoostWeights.push_back(0.285438);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.551242, 1, 1, 0.633567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155902,-99) , 
0, 0.195704, 1, 0, 0.502126,-99) , 
2, -0.30107, 0, 0, 0.587481,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635712,-99) , 
NN(
0, 
0, 
-1, 0.910153, 1, -1, 0.255595,-99) , 
1, -0.6917, 1, 0, 0.343844,-99) , 
0, 2.58669, 1, 0, 0.547108,-99)    );
  // itree = 634
  fBoostWeights.push_back(0.266656);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.775434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414999,-99) , 
3, -0.304384, 0, 0, 0.667957,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605773,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279882,-99) , 
1, -0.798136, 0, 0, 0.508209,-99) , 
1, -1.10812, 1, 0, 0.554184,-99) , 
NN(
NN(
0, 
0, 
-1, 3.71161, 1, -1, 0.446392,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204021,-99) , 
0, -2.58941, 1, 0, 0.288793,-99) , 
3, -0.147314, 0, 0, 0.406404,-99) , 
1, -0.294962, 1, 0, 0.460923,-99)    );
  // itree = 635
  fBoostWeights.push_back(0.180805);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832249,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425058,-99) , 
1, -0.359664, 0, 0, 0.511548,-99) , 
0, -1.4026, 1, 0, 0.524067,-99) , 
NN(
0, 
0, 
-1, -3.37083, 0, -1, 0.261146,-99) , 
3, -1.1555, 0, 0, 0.501556,-99)    );
  // itree = 636
  fBoostWeights.push_back(0.23893);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.09917, 1, 1, 0.604021,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392857,-99) , 
3, 2.00287, 0, 0, 0.420529,-99) , 
1, -0.235441, 0, 0, 0.503923,-99) , 
NN(
0, 
0, 
-1, 3.03979, 1, -1, 0.35568,-99) , 
1, 0.65094, 1, 0, 0.468399,-99)    );
  // itree = 637
  fBoostWeights.push_back(0.214799);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.276699, 1, 1, 0.808668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224452,-99) , 
0, 4.02428, 1, 0, 0.51908,-99) , 
0, -0.055608, 1, 0, 0.55349,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359582,-99) , 
2, -0.885708, 0, 0, 0.513147,-99) , 
NN(
0, 
0, 
-1, 0.8994, 1, -1, 0.281025,-99) , 
1, -0.259045, 1, 0, 0.371593,-99) , 
3, -0.304384, 0, 0, 0.514754,-99)    );
  // itree = 638
  fBoostWeights.push_back(0.0654473);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747038,-99) , 
NN(
0, 
0, 
-1, 4.49194, 1, -1, 0.474112,-99) , 
1, 1.89, 0, 0, 0.482491,-99)    );
  // itree = 639
  fBoostWeights.push_back(0.168217);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.627785, 0, 1, 0.556099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.247108,-99) , 
1, 1.79828, 1, 0, 0.535974,-99) , 
NN(
0, 
0, 
-1, -0.562049, 1, -1, 0.260361,-99) , 
3, -1.10827, 0, 0, 0.512715,-99)    );
  // itree = 640
  fBoostWeights.push_back(0.198822);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461162,-99) , 
3, 0.913881, 0, 0, 0.498635,-99) , 
NN(
0, 
0, 
-1, 1.08504, 0, -1, 0.378963,-99) , 
0, 1.60455, 1, 0, 0.447366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.138491,-99) , 
3, -1.68589, 0, 0, 0.436266,-99)    );
  // itree = 641
  fBoostWeights.push_back(0.200072);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.81062, 0, 1, 0.699815,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709728,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483452,-99) , 
3, 1.89796, 0, 0, 0.515401,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326907,-99) , 
1, 1.27032, 0, 0, 0.39372,-99) , 
1, 0.38739, 1, 0, 0.466741,-99) , 
2, -1.16796, 1, 0, 0.49354,-99)    );
  // itree = 642
  fBoostWeights.push_back(0.123016);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.785618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278534,-99) , 
1, 1.65949, 1, 0, 0.513821,-99) , 
3, 2.9635, 0, 0, 0.525042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.123703,-99) , 
3, -2.03286, 0, 0, 0.511169,-99)    );
  // itree = 643
  fBoostWeights.push_back(0.161854);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327687,-99) , 
0, 3.32812, 1, 0, 0.536923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232543,-99) , 
2, 2.32837, 1, 0, 0.52138,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248143,-99) , 
2, -0.896462, 1, 0, 0.430194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.049804,-99) , 
1, -1.15556, 0, 0, 0.356111,-99) , 
3, -0.566199, 0, 0, 0.496361,-99)    );
  // itree = 644
  fBoostWeights.push_back(0.265656);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.675737, 0, 1, 0.616114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288962,-99) , 
3, 0.773561, 0, 0, 0.488473,-99) , 
0, 0.5473, 1, 0, 0.554247,-99) , 
NN(
0, 
0, 
-1, -0.496792, 0, -1, 0.290045,-99) , 
0, 2.5577, 1, 0, 0.501811,-99)    );
  // itree = 645
  fBoostWeights.push_back(0.316444);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.787523, 1, 1, 0.652835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27284,-99) , 
0, -1.42073, 1, 0, 0.460914,-99) , 
3, -0.393359, 0, 0, 0.533291,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369319,-99) , 
0, 1.34652, 1, 0, 0.406203,-99) , 
NN(
0, 
0, 
-1, 1.0733, 0, -1, 0.294104,-99) , 
3, 0.82431, 0, 0, 0.367463,-99) , 
0, -0.0815128, 1, 0, 0.415777,-99)    );
  // itree = 646
  fBoostWeights.push_back(0.387875);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67649,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353181,-99) , 
3, 0.5231, 0, 0, 0.606461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316788,-99) , 
3, 3.0188, 0, 0, 0.379895,-99) , 
3, 1.5275, 1, 0, 0.496367,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387875,-99) , 
0, -1.02735, 0, 0, 0.51797,-99) , 
NN(
0, 
0, 
-1, -0.0169813, 1, -1, 0.297645,-99) , 
1, 0.65094, 0, 0, 0.348365,-99) , 
0, 0.544817, 0, 0, 0.435623,-99)    );
  // itree = 647
  fBoostWeights.push_back(0.217898);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809631,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437093,-99) , 
3, 1.89386, 0, 0, 0.461121,-99) , 
NN(
0, 
0, 
-1, 3.39581, 0, -1, 0.301567,-99) , 
0, 2.76684, 1, 0, 0.436795,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146795,-99) , 
1, 2.01701, 1, 0, 0.425248,-99)    );
  // itree = 648
  fBoostWeights.push_back(0.166101);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.528759, 1, 1, 0.577141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400886,-99) , 
1, 0.534476, 0, 0, 0.47193,-99) , 
1, 0.0462137, 1, 0, 0.523625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157334,-99) , 
2, -1.73847, 0, 0, 0.510004,-99)    );
  // itree = 649
  fBoostWeights.push_back(0.200522);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.684172, 1, 1, 0.667581,-99) , 
NN(
NN(
0, 
0, 
-1, 1.39222, 1, 1, 0.613308,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288513,-99) , 
0, 0.685013, 1, 0, 0.425109,-99) , 
3, 1.32588, 0, 0, 0.497027,-99) , 
1, -1.31849, 1, 0, 0.515741,-99)    );
  // itree = 650
  fBoostWeights.push_back(0.245919);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436086,-99) , 
0, 0.597847, 0, 0, 0.516482,-99) , 
NN(
0, 
0, 
-1, 0.307364, 1, -1, 0.265266,-99) , 
1, 1.48706, 1, 0, 0.487984,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.86014,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308008,-99) , 
0, 3.67699, 1, 0, 0.510555,-99) , 
NN(
0, 
0, 
-1, 0.546576, 1, -1, 0.345398,-99) , 
3, 2.00287, 0, 0, 0.372488,-99) , 
1, -0.0822111, 0, 0, 0.439974,-99)    );
  // itree = 651
  fBoostWeights.push_back(0.234092);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490462,-99) , 
2, -0.504532, 0, 0, 0.667262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389125,-99) , 
1, -1.66058, 0, 0, 0.621435,-99) , 
NN(
0, 
0, 
-1, 1.8434, 1, -1, 0.403519,-99) , 
1, -0.553853, 1, 0, 0.464706,-99)    );
  // itree = 652
  fBoostWeights.push_back(0.339108);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402961,-99) , 
3, 1.62465, 1, 0, 0.651162,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545583,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284404,-99) , 
0, -1.35253, 1, 0, 0.459895,-99) , 
2, -0.873951, 0, 0, 0.614548,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692555,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278502,-99) , 
3, 2.8744, 0, 0, 0.352113,-99) , 
0, 1.4956, 1, 0, 0.3883,-99) , 
2, 1.13653, 1, 0, 0.553251,-99)    );
  // itree = 653
  fBoostWeights.push_back(0.304418);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.617148, 1, 1, 0.621766,-99) , 
NN(
0, 
0, 
-1, -1.59665, 0, -1, 0.416635,-99) , 
3, -0.304384, 0, 0, 0.565248,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27531,-99) , 
1, 1.51827, 1, 0, 0.447714,-99) , 
NN(
0, 
0, 
-1, 0.613261, 1, -1, 0.174058,-99) , 
1, 0.796112, 0, 0, 0.326072,-99) , 
1, 0.37474, 1, 0, 0.476607,-99)    );
  // itree = 654
  fBoostWeights.push_back(0.229972);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.02612, 1, 1, 0.636548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304097,-99) , 
3, -1.56884, 0, 0, 0.604799,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443706,-99) , 
0, -0.166745, 1, 0, 0.502823,-99) , 
NN(
0, 
0, 
-1, -0.122417, 0, -1, 0.375341,-99) , 
1, 0.420679, 0, 0, 0.455824,-99) , 
1, -0.294962, 1, 0, 0.51217,-99)    );
  // itree = 655
  fBoostWeights.push_back(0.139543);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4962,-99) , 
3, -0.10532, 0, 0, 0.58601,-99) , 
NN(
0, 
0, 
-1, 0.787936, 0, -1, 0.468908,-99) , 
0, 0.717523, 1, 0, 0.524131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197923,-99) , 
0, 4.18637, 1, 0, 0.510505,-99)    );
  // itree = 656
  fBoostWeights.push_back(0.260012);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.687186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349431,-99) , 
3, -2.03883, 0, 0, 0.650625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431935,-99) , 
1, 1.55025, 0, 0, 0.454613,-99) , 
1, 0.0302751, 1, 0, 0.559948,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424058,-99) , 
2, 0.701962, 1, 0, 0.456702,-99) , 
NN(
0, 
0, 
-1, 0.734716, 1, -1, 0.257691,-99) , 
3, 1.26136, 0, 0, 0.416752,-99) , 
3, 0.908704, 1, 0, 0.495385,-99)    );
  // itree = 657
  fBoostWeights.push_back(0.281486);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.69672, 1, 1, 0.628374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296435,-99) , 
3, -1.70043, 0, 0, 0.613255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258569,-99) , 
0, 3.96657, 1, 0, 0.595975,-99)    );
  // itree = 658
  fBoostWeights.push_back(0.270548);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.59788, 1, 1, 0.683276,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359981,-99) , 
2, 2.43707, 1, 0, 0.635264,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526235,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177805,-99) , 
3, -2.11851, 0, 0, 0.501339,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294344,-99) , 
3, 1.39328, 0, 0, 0.369868,-99) , 
0, 0.358301, 1, 0, 0.434245,-99) , 
3, 1.69848, 0, 0, 0.478662,-99)    );
  // itree = 659
  fBoostWeights.push_back(0.284658);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.310978, 0, 1, 0.720132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391353,-99) , 
0, 3.66462, 1, 0, 0.524105,-99) , 
0, 1.09443, 1, 0, 0.579118,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427225,-99) , 
3, -1.14868, 0, 0, 0.618928,-99) , 
NN(
0, 
0, 
-1, 0.0735329, 0, -1, 0.325442,-99) , 
0, -1.26065, 1, 0, 0.435166,-99) , 
0, 0.0678113, 0, 0, 0.522219,-99)    );
  // itree = 660
  fBoostWeights.push_back(0.226238);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83231,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619314,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.315217,-99) , 
1, 0.0100439, 1, 0, 0.531689,-99) , 
3, -1.01875, 0, 0, 0.602318,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415371,-99) , 
2, 1.88514, 1, 0, 0.563367,-99) , 
NN(
0, 
0, 
-1, 3.12775, 1, -1, 0.416015,-99) , 
2, 1.3463, 0, 0, 0.455398,-99) , 
0, -1.47757, 1, 0, 0.476291,-99)    );
  // itree = 661
  fBoostWeights.push_back(0.270486);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.03142, 1, 1, 0.734199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0858293,-99) , 
1, 0.338012, 1, 0, 0.50661,-99) , 
1, 0.486363, 0, 0, 0.587971,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777554,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434076,-99) , 
0, -1.46593, 0, 0, 0.615792,-99) , 
NN(
0, 
0, 
-1, 0.723183, 1, -1, 0.397521,-99) , 
1, -1.03486, 1, 0, 0.438907,-99) , 
3, 1.13577, 0, 0, 0.498584,-99)    );
  // itree = 662
  fBoostWeights.push_back(0.222563);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389363,-99) , 
1, -0.260611, 0, 0, 0.628887,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362187,-99) , 
2, 0.515999, 1, 0, 0.479799,-99) , 
3, 1.39333, 0, 0, 0.518298,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160856,-99) , 
2, 2.37782, 1, 0, 0.509221,-99)    );
  // itree = 663
  fBoostWeights.push_back(0.256675);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453943,-99) , 
0, -0.173945, 1, 0, 0.514356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182119,-99) , 
3, -1.70801, 0, 0, 0.497862,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338044,-99) , 
0, 4.32854, 1, 0, 0.527829,-99) , 
NN(
0, 
0, 
-1, 2.52924, 1, -1, 0.246146,-99) , 
3, 2.51075, 0, 0, 0.312588,-99) , 
0, 1.86512, 1, 0, 0.441077,-99)    );
  // itree = 664
  fBoostWeights.push_back(0.181584);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.145758, 0, 1, 0.85402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.188269,-99) , 
1, 0.0518602, 0, 0, 0.468614,-99) , 
1, -0.149192, 1, 0, 0.502324,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391238,-99) , 
2, 1.109, 0, 0, 0.447808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139704,-99) , 
0, 3.4875, 1, 0, 0.424297,-99) , 
1, -0.359664, 0, 0, 0.473981,-99)    );
  // itree = 665
  fBoostWeights.push_back(0.21815);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487201,-99) , 
2, -0.351203, 0, 0, 0.547271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18967,-99) , 
2, 0.630373, 0, 0, 0.360917,-99) , 
3, 1.05393, 1, 0, 0.531209,-99) , 
NN(
0, 
0, 
-1, 0.780737, 0, -1, 0.318984,-99) , 
0, 1.63755, 1, 0, 0.457813,-99)    );
  // itree = 666
  fBoostWeights.push_back(0.201125);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.217024, 1, 1, 0.615675,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31,-99) , 
1, 0.84565, 0, 0, 0.403421,-99) , 
2, -1.29707, 0, 0, 0.575027,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484323,-99) , 
1, -0.597481, 1, 0, 0.522101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168799,-99) , 
0, 0.193557, 0, 0, 0.480681,-99) , 
2, 0.380334, 1, 0, 0.526074,-99)    );
  // itree = 667
  fBoostWeights.push_back(0.149077);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.537867, 0, 1, 0.549585,-99) , 
NN(
0, 
0, 
-1, -0.262729, 0, -1, 0.379203,-99) , 
1, 0.923532, 1, 0, 0.517217,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157816,-99) , 
2, -1.64885, 0, 0, 0.503207,-99)    );
  // itree = 668
  fBoostWeights.push_back(0.105695);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.849947,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764273,-99) , 
NN(
0, 
0, 
-1, 1.04769, 1, -1, 0.468701,-99) , 
3, 3.10977, 0, 0, 0.481069,-99) , 
1, -2.23323, 1, 0, 0.494925,-99)    );
  // itree = 669
  fBoostWeights.push_back(0.240032);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.670502, 0, 1, 0.696733,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.120647,-99) , 
2, 1.73058, 0, 0, 0.403075,-99) , 
0, 2.95112, 1, 0, 0.609522,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640028,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467876,-99) , 
2, 0.656717, 0, 0, 0.498103,-99) , 
NN(
0, 
0, 
-1, -0.435187, 1, -1, 0.226649,-99) , 
1, 1.17696, 1, 0, 0.468987,-99) , 
3, 1.18513, 0, 0, 0.518644,-99)    );
  // itree = 670
  fBoostWeights.push_back(0.168579);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797428,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420897,-99) , 
3, -1.19022, 0, 0, 0.54722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381957,-99) , 
3, 2.38458, 0, 0, 0.475215,-99) , 
2, 1.30195, 1, 0, 0.528986,-99) , 
3, -2.55726, 1, 0, 0.537003,-99)    );
  // itree = 671
  fBoostWeights.push_back(0.15084);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48165,-99) , 
1, -1.05661, 0, 0, 0.591775,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.265703,-99) , 
2, -0.854983, 0, 0, 0.470058,-99) , 
1, 0.181348, 1, 0, 0.527239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249846,-99) , 
0, 4.18211, 1, 0, 0.517604,-99)    );
  // itree = 672
  fBoostWeights.push_back(0.226882);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.15597, 1, 1, 0.594995,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32418,-99) , 
1, -1.71379, 0, 0, 0.58072,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690177,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360937,-99) , 
2, 1.80535, 1, 0, 0.507628,-99) , 
NN(
0, 
0, 
-1, 2.75264, 1, -1, 0.367801,-99) , 
3, 2.19439, 0, 0, 0.428042,-99) , 
0, 2.04684, 1, 0, 0.539711,-99)    );
  // itree = 673
  fBoostWeights.push_back(0.266158);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.58933, 0, 1, 0.673803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423939,-99) , 
3, -0.0320456, 1, 0, 0.621671,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299782,-99) , 
1, 1.17853, 1, 0, 0.522017,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308989,-99) , 
2, 0.408842, 1, 0, 0.364697,-99) , 
0, 2.35186, 0, 0, 0.418846,-99) , 
2, -0.15663, 1, 0, 0.47454,-99)    );
  // itree = 674
  fBoostWeights.push_back(0.162391);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.07078, 1, 1, 0.736156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70411,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386481,-99) , 
3, 2.69372, 0, 0, 0.539306,-99) , 
1, 0.306404, 0, 0, 0.633597,-99) , 
NN(
NN(
0, 
0, 
-1, -1.36976, 0, 1, 0.635167,-99) , 
NN(
0, 
0, 
-1, -0.0451059, 0, -1, 0.453167,-99) , 
2, -1.17452, 1, 0, 0.475354,-99) , 
3, 1.82814, 0, 0, 0.50172,-99)    );
  // itree = 675
  fBoostWeights.push_back(0.153335);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.00575, 1, 1, 0.5431,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34437,-99) , 
1, 0.873709, 0, 0, 0.401747,-99) , 
2, 1.35661, 1, 0, 0.511336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253208,-99) , 
3, -1.80475, 0, 0, 0.499766,-99)    );
  // itree = 676
  fBoostWeights.push_back(0.236229);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37545,-99) , 
3, 0.0639689, 1, 0, 0.475824,-99) , 
0, 2.52648, 0, 0, 0.518703,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660639,-99) , 
NN(
0, 
0, 
-1, 0.0599743, 0, -1, 0.394261,-99) , 
0, -3.07585, 1, 0, 0.40839,-99) , 
1, -0.876513, 1, 0, 0.431515,-99)    );
  // itree = 677
  fBoostWeights.push_back(0.140744);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491864,-99) , 
1, 0.539507, 0, 0, 0.5245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318439,-99) , 
2, -0.793889, 0, 0, 0.512112,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326951,-99) , 
0, -2.64915, 1, 0, 0.484986,-99) , 
NN(
0, 
0, 
-1, -0.629441, 1, -1, 0.241345,-99) , 
1, -0.219554, 0, 0, 0.355984,-99) , 
3, -0.711955, 0, 0, 0.488154,-99)    );
  // itree = 678
  fBoostWeights.push_back(0.232448);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.809103,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400946,-99) , 
1, 0.24729, 1, 0, 0.489329,-99) , 
3, 1.82724, 0, 0, 0.506616,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252851,-99) , 
2, 1.71567, 1, 0, 0.408848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139279,-99) , 
2, 1.32531, 0, 0, 0.339354,-99) , 
0, 2.69796, 1, 0, 0.479813,-99)    );
  // itree = 679
  fBoostWeights.push_back(0.150807);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756114,-99) , 
NN(
0, 
0, 
-1, 1.81941, 1, -1, 0.4461,-99) , 
0, -1.7931, 1, 0, 0.46213,-99) , 
NN(
0, 
0, 
-1, -1.59821, 0, -1, 0.269895,-99) , 
3, -1.48742, 0, 0, 0.449975,-99)    );
  // itree = 680
  fBoostWeights.push_back(0.167421);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489947,-99) , 
0, -0.251394, 1, 0, 0.616133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324719,-99) , 
3, -1.77128, 0, 0, 0.580023,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473288,-99) , 
0, 0.0435627, 1, 0, 0.496479,-99) , 
NN(
0, 
0, 
-1, -1.09448, 1, -1, 0.282648,-99) , 
3, -0.001622, 0, 0, 0.470965,-99) , 
2, -0.237048, 1, 0, 0.499872,-99)    );
  // itree = 681
  fBoostWeights.push_back(0.26893);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.392765, 1, 1, 0.690637,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442272,-99) , 
3, 2.62091, 0, 0, 0.524742,-99) , 
2, 1.23276, 1, 0, 0.608678,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581901,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389583,-99) , 
1, 0.299998, 1, 0, 0.506429,-99) , 
NN(
0, 
0, 
-1, -1.30088, 1, -1, 0.287975,-99) , 
3, -1.06455, 0, 0, 0.463751,-99) , 
3, 0.638168, 0, 0, 0.538919,-99)    );
  // itree = 682
  fBoostWeights.push_back(0.222217);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.291554, 0, 1, 0.678297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.335017,-99) , 
1, 0.224596, 1, 0, 0.568968,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374187,-99) , 
0, -0.117909, 1, 0, 0.489596,-99) , 
NN(
0, 
0, 
-1, 0.510365, 0, -1, 0.370773,-99) , 
2, -0.093347, 1, 0, 0.417465,-99) , 
2, 1.49137, 0, 0, 0.438568,-99)    );
  // itree = 683
  fBoostWeights.push_back(0.239629);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.95417, 0, 1, 0.644781,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426519,-99) , 
2, 1.08254, 0, 0, 0.520222,-99) , 
2, 0.389508, 1, 0, 0.561436,-99) , 
NN(
0, 
0, 
-1, 0.0100439, 1, -1, 0.296872,-99) , 
3, -0.786928, 0, 0, 0.530447,-99)    );
  // itree = 684
  fBoostWeights.push_back(0.295237);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.304229, 1, 1, 0.824687,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441711,-99) , 
3, 1.52392, 0, 0, 0.547624,-99) , 
0, 0.785602, 1, 0, 0.584833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737556,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353454,-99) , 
1, -0.866499, 1, 0, 0.37748,-99) , 
1, -1.30237, 1, 0, 0.411711,-99) , 
3, 0.306962, 0, 0, 0.51264,-99)    );
  // itree = 685
  fBoostWeights.push_back(0.273492);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.00617, 1, 1, 0.589172,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282148,-99) , 
0, -2.20845, 1, 0, 0.450115,-99) , 
3, -0.770221, 0, 0, 0.570494,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37741,-99) , 
2, 1.47894, 1, 0, 0.611099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154344,-99) , 
0, -1.05822, 1, 0, 0.290372,-99) , 
3, 0.00766277, 0, 0, 0.468762,-99) , 
1, -0.570613, 0, 0, 0.539635,-99)    );
  // itree = 686
  fBoostWeights.push_back(0.307076);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.31048, 1, 1, 0.741868,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590097,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181349,-99) , 
2, -1.02797, 0, 0, 0.520705,-99) , 
1, 0.398183, 1, 0, 0.60081,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451373,-99) , 
2, 0.555203, 1, 0, 0.52294,-99) , 
NN(
0, 
0, 
-1, -1.02171, 0, -1, 0.29262,-99) , 
3, -0.410969, 0, 0, 0.461742,-99) , 
1, -0.0756034, 0, 0, 0.537377,-99)    );
  // itree = 687
  fBoostWeights.push_back(0.178562);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392887,-99) , 
3, -0.672561, 0, 0, 0.538526,-99) , 
NN(
0, 
0, 
-1, 1.05945, 1, -1, 0.39483,-99) , 
0, 2.05541, 1, 0, 0.497617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156385,-99) , 
3, -1.77855, 0, 0, 0.48852,-99)    );
  // itree = 688
  fBoostWeights.push_back(0.156584);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.74383, 0, 1, 0.750049,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473722,-99) , 
0, 0.557161, 1, 0, 0.502237,-99) , 
NN(
0, 
0, 
-1, 0.0953147, 1, -1, 0.392398,-99) , 
3, 0.0712579, 0, 0, 0.467312,-99) , 
0, -3.00687, 1, 0, 0.482419,-99)    );
  // itree = 689
  fBoostWeights.push_back(0.268941);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.721253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466516,-99) , 
0, 1.81768, 1, 0, 0.606963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367074,-99) , 
0, -0.262888, 1, 0, 0.48332,-99) , 
0, 0.681763, 0, 0, 0.53558,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341019,-99) , 
0, 2.41704, 0, 0, 0.487496,-99) , 
NN(
0, 
0, 
-1, 2.52634, 0, -1, 0.232325,-99) , 
0, 2.87521, 1, 0, 0.373443,-99) , 
2, 1.3621, 1, 0, 0.501044,-99)    );
  // itree = 690
  fBoostWeights.push_back(0.19838);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.577039, 0, 1, 0.687013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426977,-99) , 
3, 1.30596, 0, 0, 0.487749,-99) , 
2, -0.467145, 1, 0, 0.512152,-99) , 
NN(
0, 
0, 
-1, -1.69405, 0, -1, 0.30604,-99) , 
3, -1.1555, 0, 0, 0.491675,-99)    );
  // itree = 691
  fBoostWeights.push_back(0.18639);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.343221,-99) , 
0, 0.0242759, 0, 0, 0.523152,-99) , 
NN(
0, 
0, 
-1, 2.21581, 0, -1, 0.250356,-99) , 
3, 2.69733, 1, 0, 0.502654,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377452,-99) , 
2, -1.64717, 0, 0, 0.494343,-99) , 
NN(
0, 
0, 
-1, -1.15123, 1, -1, 0.319826,-99) , 
0, -2.14912, 1, 0, 0.364277,-99) , 
0, -0.233659, 0, 0, 0.462505,-99)    );
  // itree = 692
  fBoostWeights.push_back(0.181583);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.96539, 0, 1, 0.553765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169682,-99) , 
0, 3.45982, 1, 0, 0.520618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612424,-99) , 
NN(
0, 
0, 
-1, 2.47271, 1, -1, 0.393048,-99) , 
0, 3.6144, 0, 0, 0.415759,-99) , 
1, 0.398769, 1, 0, 0.477903,-99)    );
  // itree = 693
  fBoostWeights.push_back(0.119393);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.83112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456203,-99) , 
1, 0.2776, 1, 0, 0.69404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217367,-99) , 
0, 2.74854, 1, 0, 0.506832,-99) , 
3, 2.12889, 0, 0, 0.521603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232735,-99) , 
0, 4.20187, 1, 0, 0.512827,-99)    );
  // itree = 694
  fBoostWeights.push_back(0.17981);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.714687, 1, 1, 0.563036,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.126502,-99) , 
2, 0.0812972, 1, 0, 0.455445,-99) , 
0, -0.292063, 0, 0, 0.533132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.131797,-99) , 
2, 2.55589, 1, 0, 0.520631,-99)    );
  // itree = 695
  fBoostWeights.push_back(0.193743);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337154,-99) , 
0, 3.27738, 1, 0, 0.502545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330115,-99) , 
2, -0.10744, 0, 0, 0.483261,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274807,-99) , 
3, -0.952107, 0, 0, 0.436723,-99) , 
NN(
0, 
0, 
-1, 0.311386, 1, -1, 0.23072,-99) , 
3, -0.367601, 1, 0, 0.354253,-99) , 
2, -0.319459, 0, 0, 0.447725,-99)    );
  // itree = 696
  fBoostWeights.push_back(0.257512);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.48089, 0, 1, 0.637109,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.861758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430132,-99) , 
2, 0.175379, 1, 0, 0.480406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288343,-99) , 
2, 0.254457, 0, 0, 0.344451,-99) , 
3, 0.206169, 0, 0, 0.443187,-99) , 
2, -1.13773, 1, 0, 0.461789,-99)    );
  // itree = 697
  fBoostWeights.push_back(0.228499);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.935888,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240945,-99) , 
2, -1.30094, 1, 0, 0.465392,-99) , 
3, -1.17691, 0, 0, 0.579321,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439996,-99) , 
0, 2.20548, 1, 0, 0.504159,-99) , 
NN(
0, 
0, 
-1, 1.31576, 1, -1, 0.388352,-99) , 
3, 1.15325, 0, 0, 0.436215,-99) , 
0, -1.74276, 1, 0, 0.453327,-99)    );
  // itree = 698
  fBoostWeights.push_back(0.280339);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432638,-99) , 
1, 1.36592, 1, 0, 0.578848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221585,-99) , 
3, 1.78181, 0, 0, 0.403927,-99) , 
0, 1.88771, 1, 0, 0.514984,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397777,-99) , 
2, 1.46489, 1, 0, 0.562737,-99) , 
NN(
0, 
0, 
-1, -0.0361952, 1, -1, 0.359309,-99) , 
0, 2.20737, 0, 0, 0.416966,-99) , 
1, -0.0270664, 0, 0, 0.464315,-99)    );
  // itree = 699
  fBoostWeights.push_back(0.23531);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.520124, 0, 1, 0.613536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393483,-99) , 
3, 1.91432, 0, 0, 0.467497,-99) , 
3, 0.868352, 1, 0, 0.534261,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464879,-99) , 
1, 1.38228, 1, 0, 0.549254,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268475,-99) , 
1, -0.752485, 1, 0, 0.336909,-99) , 
1, 0.620065, 0, 0, 0.392471,-99) , 
0, -0.691462, 0, 0, 0.500733,-99)    );
  // itree = 700
  fBoostWeights.push_back(0.126868);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388981,-99) , 
1, 1.05514, 1, 0, 0.52154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268019,-99) , 
1, 1.79938, 1, 0, 0.509462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0822798,-99) , 
0, 4.74291, 1, 0, 0.497733,-99)    );
  // itree = 701
  fBoostWeights.push_back(0.199177);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.4713, 1, 1, 0.746566,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466513,-99) , 
3, 0.461735, 0, 0, 0.527822,-99) , 
2, 2.07386, 0, 0, 0.5489,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383791,-99) , 
3, 1.4461, 0, 0, 0.417541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.121506,-99) , 
3, 2.27666, 1, 0, 0.380842,-99) , 
1, 0.463922, 1, 0, 0.496301,-99)    );
  // itree = 702
  fBoostWeights.push_back(0.180971);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.12554, 0, 1, 0.569625,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363016,-99) , 
3, -0.383188, 1, 0, 0.448492,-99) , 
3, 0.439463, 0, 0, 0.512493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200315,-99) , 
0, 4.20187, 1, 0, 0.500093,-99)    );
  // itree = 703
  fBoostWeights.push_back(0.244776);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493634,-99) , 
3, 1.05865, 0, 0, 0.563808,-99) , 
NN(
0, 
0, 
-1, 1.9757, 1, -1, 0.412182,-99) , 
1, 0.293529, 1, 0, 0.476405,-99) , 
NN(
NN(
0, 
0, 
-1, 0.304025, 0, 1, 0.645728,-99) , 
NN(
0, 
0, 
-1, 0.844311, 1, -1, 0.28368,-99) , 
1, -1.55786, 1, 0, 0.344941,-99) , 
1, -0.605638, 0, 0, 0.434816,-99)    );
  // itree = 704
  fBoostWeights.push_back(0.246843);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399384,-99) , 
2, -0.390809, 0, 0, 0.700725,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443791,-99) , 
2, 1.21777, 1, 0, 0.632155,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643263,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452297,-99) , 
3, 0.388481, 0, 0, 0.522833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383171,-99) , 
0, 1.90533, 1, 0, 0.440859,-99) , 
0, 1.63755, 1, 0, 0.488288,-99) , 
1, -0.977314, 1, 0, 0.509745,-99)    );
  // itree = 705
  fBoostWeights.push_back(0.27318);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434753,-99) , 
0, 1.44074, 0, 0, 0.598907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280852,-99) , 
2, 2.64006, 0, 0, 0.393658,-99) , 
3, 2.1719, 1, 0, 0.547522,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65057,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306122,-99) , 
3, -1.63254, 0, 0, 0.568567,-99) , 
NN(
0, 
0, 
-1, -0.610064, 0, -1, 0.404113,-99) , 
2, -0.993642, 1, 0, 0.438936,-99) , 
3, 0.810124, 0, 0, 0.489399,-99)    );
  // itree = 706
  fBoostWeights.push_back(0.238753);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490709,-99) , 
1, -0.528843, 1, 0, 0.758077,-99) , 
NN(
0, 
0, 
-1, 0.650374, 0, 1, 0.595113,-99) , 
1, -0.749745, 0, 0, 0.65617,-99) , 
NN(
NN(
0, 
0, 
-1, -0.351632, 0, 1, 0.634647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.838444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437544,-99) , 
3, 3.24137, 0, 0, 0.464006,-99) , 
0, -0.460883, 1, 0, 0.512789,-99) , 
1, -0.362514, 1, 0, 0.560736,-99)    );
  // itree = 707
  fBoostWeights.push_back(0.206225);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.0532472, 0, 1, 0.720374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.196768,-99) , 
3, -1.99087, 0, 0, 0.497365,-99) , 
3, 0.177214, 0, 0, 0.580672,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449796,-99) , 
3, 2.60977, 0, 0, 0.484033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157336,-99) , 
1, 1.55039, 1, 0, 0.458879,-99) , 
0, 1.35651, 1, 0, 0.531349,-99)    );
  // itree = 708
  fBoostWeights.push_back(0.313683);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.12811, 1, 1, 0.674383,-99) , 
NN(
0, 
0, 
-1, -0.761308, 1, -1, 0.353514,-99) , 
3, -0.504541, 0, 0, 0.580765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580444,-99) , 
NN(
0, 
0, 
-1, 1.8261, 0, -1, 0.377004,-99) , 
0, 1.39525, 1, 0, 0.409442,-99) , 
2, 1.07719, 1, 0, 0.531621,-99)    );
  // itree = 709
  fBoostWeights.push_back(0.200744);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.836315, 1, 1, 0.596866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404036,-99) , 
3, -1.3288, 0, 0, 0.581358,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44001,-99) , 
0, -0.431674, 1, 0, 0.478242,-99) , 
NN(
0, 
0, 
-1, 0.0542897, 1, -1, 0.236125,-99) , 
1, 0.778832, 0, 0, 0.428956,-99) , 
1, 0.522288, 1, 0, 0.532135,-99)    );
  // itree = 710
  fBoostWeights.push_back(0.233247);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.01829, 0, 1, 0.570203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26296,-99) , 
0, 4.07622, 0, 0, 0.380116,-99) , 
0, 3.4479, 1, 0, 0.527127,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414265,-99) , 
3, -0.148354, 0, 0, 0.506839,-99) , 
NN(
0, 
0, 
-1, -0.291543, 0, -1, 0.328328,-99) , 
0, 0.312002, 1, 0, 0.441572,-99) , 
3, 0.908704, 0, 0, 0.477469,-99)    );
  // itree = 711
  fBoostWeights.push_back(0.2381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.206983, 0, 1, 0.616035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353813,-99) , 
0, -0.998241, 1, 0, 0.493857,-99) , 
0, -0.58368, 0, 0, 0.552506,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447822,-99) , 
0, 2.63578, 1, 0, 0.552649,-99) , 
NN(
0, 
0, 
-1, -0.198852, 1, -1, 0.317178,-99) , 
3, 1.27669, 0, 0, 0.460353,-99) , 
0, 0.861216, 1, 0, 0.508445,-99)    );
  // itree = 712
  fBoostWeights.push_back(0.25854);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.613209, 1, 1, 0.5985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.212587,-99) , 
2, -1.7165, 0, 0, 0.578105,-99) , 
NN(
0, 
0, 
-1, 0.151616, 0, -1, 0.358816,-99) , 
1, -0.0246959, 1, 0, 0.457525,-99)    );
  // itree = 713
  fBoostWeights.push_back(0.187976);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.60156, 0, 1, 0.735599,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400331,-99) , 
3, 0.0785405, 0, 0, 0.518702,-99) , 
0, -2.08275, 1, 0, 0.534124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0796238,-99) , 
3, -2.1876, 0, 0, 0.522444,-99)    );
  // itree = 714
  fBoostWeights.push_back(0.23544);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561355,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412011,-99) , 
1, 0.867662, 1, 0, 0.531824,-99) , 
1, 1.55044, 0, 0, 0.544042,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157988,-99) , 
1, -1.67665, 0, 0, 0.411841,-99) , 
NN(
0, 
0, 
-1, -1.30135, 1, -1, 0.236919,-99) , 
3, 0.716737, 1, 0, 0.305501,-99) , 
1, -0.807628, 0, 0, 0.479377,-99)    );
  // itree = 715
  fBoostWeights.push_back(0.243253);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872709,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496564,-99) , 
2, 0.793847, 1, 0, 0.681886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454802,-99) , 
3, -0.203844, 0, 0, 0.627187,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401113,-99) , 
0, -0.898493, 1, 0, 0.432568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145261,-99) , 
2, -1.64509, 0, 0, 0.421671,-99) , 
1, 0.728565, 0, 0, 0.45901,-99)    );
  // itree = 716
  fBoostWeights.push_back(0.239993);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33944,-99) , 
1, -1.29665, 0, 0, 0.61411,-99) , 
NN(
0, 
0, 
-1, 1.20143, 0, -1, 0.444284,-99) , 
0, 0.928217, 1, 0, 0.522985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.124259,-99) , 
2, -1.66446, 0, 0, 0.507153,-99)    );
  // itree = 717
  fBoostWeights.push_back(0.19491);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566331,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457073,-99) , 
0, 1.31845, 1, 0, 0.520311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355631,-99) , 
1, -1.31896, 1, 0, 0.42615,-99) , 
1, -0.36158, 0, 0, 0.486293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.150241,-99) , 
2, 2.37782, 1, 0, 0.473327,-99)    );
  // itree = 718
  fBoostWeights.push_back(0.276591);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.51832, 0, 1, 0.758604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401465,-99) , 
0, 4.02783, 1, 0, 0.721362,-99) , 
NN(
NN(
0, 
0, 
-1, 0.380984, 1, 1, 0.731902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459529,-99) , 
3, 1.38392, 0, 0, 0.489844,-99) , 
1, 0.988758, 0, 0, 0.522922,-99) , 
2, 1.1699, 0, 0, 0.587401,-99)    );
  // itree = 719
  fBoostWeights.push_back(0.257478);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.151344, 0, 1, 0.718584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60455,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400924,-99) , 
1, 1.45638, 1, 0, 0.519143,-99) , 
2, 0.38636, 1, 0, 0.600972,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670855,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416878,-99) , 
2, 0.445699, 0, 0, 0.548215,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632957,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384497,-99) , 
2, -0.381304, 1, 0, 0.427629,-99) , 
1, -0.565827, 1, 0, 0.464815,-99) , 
1, 0.973008, 0, 0, 0.48575,-99)    );
  // itree = 720
  fBoostWeights.push_back(0.318299);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.97563, 0, 1, 0.639425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.00467217,-99) , 
1, 1.31785, 0, 0, 0.340224,-99) , 
1, 1.06974, 1, 0, 0.596431,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381889,-99) , 
0, -1.04551, 1, 0, 0.509647,-99) , 
NN(
0, 
0, 
-1, -0.596528, 0, -1, 0.353311,-99) , 
1, -0.563226, 1, 0, 0.391523,-99) , 
2, 0.553856, 0, 0, 0.501052,-99)    );
  // itree = 721
  fBoostWeights.push_back(0.171268);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.927543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494076,-99) , 
1, -1.63613, 0, 0, 0.697124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488544,-99) , 
3, 1.26576, 0, 0, 0.533392,-99) , 
NN(
0, 
0, 
-1, 0.736679, 1, -1, 0.297039,-99) , 
1, -0.737388, 0, 0, 0.495063,-99) , 
1, -1.42069, 1, 0, 0.514043,-99)    );
  // itree = 722
  fBoostWeights.push_back(0.306841);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0576853, 1, 1, 0.628803,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251701,-99) , 
1, -0.0126254, 1, 0, 0.404766,-99) , 
3, -0.989606, 0, 0, 0.586861,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277237,-99) , 
2, 2.57107, 1, 0, 0.615521,-99) , 
NN(
0, 
0, 
-1, 0.0606595, 1, -1, 0.327571,-99) , 
3, 1.90481, 0, 0, 0.464139,-99) , 
2, 0.827757, 1, 0, 0.536785,-99)    );
  // itree = 723
  fBoostWeights.push_back(0.196708);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.459321, 1, 1, 0.578173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.174569,-99) , 
1, -0.431023, 1, 0, 0.314209,-99) , 
3, -1.59105, 0, 0, 0.555873,-99) , 
NN(
0, 
0, 
-1, 2.83872, 0, -1, 0.328865,-99) , 
2, 1.87571, 1, 0, 0.537788,-99)    );
  // itree = 724
  fBoostWeights.push_back(0.20917);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 4.07334, 1, 1, 0.735878,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459856,-99) , 
1, 0.345387, 0, 0, 0.511409,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551376,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.215567,-99) , 
3, 2.27055, 0, 0, 0.304371,-99) , 
0, 2.62671, 1, 0, 0.484432,-99) , 
3, 2.62856, 0, 0, 0.515223,-99)    );
  // itree = 725
  fBoostWeights.push_back(0.246788);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337286,-99) , 
3, -1.97529, 0, 0, 0.61155,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.656372,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.21143,-99) , 
2, 0.662933, 0, 0, 0.435416,-99) , 
0, 1.8384, 1, 0, 0.590323,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259432,-99) , 
0, 1.59308, 0, 0, 0.485815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.202215,-99) , 
2, 1.16011, 0, 0, 0.45242,-99) , 
2, 1.01587, 1, 0, 0.54631,-99)    );
  // itree = 726
  fBoostWeights.push_back(0.250678);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.142189, 1, 1, 0.824647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287194,-99) , 
0, 3.75236, 1, 0, 0.484112,-99) , 
0, 1.47292, 1, 0, 0.558713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742623,-99) , 
NN(
0, 
0, 
-1, -1.05347, 0, -1, 0.382878,-99) , 
2, -2.00837, 1, 0, 0.406836,-99) , 
3, 0.660704, 0, 0, 0.477912,-99)    );
  // itree = 727
  fBoostWeights.push_back(0.20812);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451686,-99) , 
0, 1.51502, 1, 0, 0.543459,-99) , 
NN(
0, 
0, 
-1, 0.273926, 0, -1, 0.336832,-99) , 
1, -1.44973, 0, 0, 0.525509,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55671,-99) , 
NN(
0, 
0, 
-1, -1.53237, 0, -1, 0.245829,-99) , 
0, -3.37736, 1, 0, 0.344258,-99) , 
2, -1.25845, 0, 0, 0.507457,-99)    );
  // itree = 728
  fBoostWeights.push_back(0.139793);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.661915, 0, 1, 0.748246,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243063,-99) , 
1, 0.948793, 0, 0, 0.500035,-99) , 
1, 0.0302751, 1, 0, 0.632853,-99) , 
NN(
0, 
0, 
-1, 4.22737, 1, -1, 0.456098,-99) , 
2, -1.13773, 1, 0, 0.478569,-99)    );
  // itree = 729
  fBoostWeights.push_back(0.323855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20765, 1, 1, 0.606586,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.310737,-99) , 
3, -1.58626, 0, 0, 0.583797,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.853683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415328,-99) , 
0, 1.99894, 1, 0, 0.606697,-99) , 
NN(
0, 
0, 
-1, -0.586346, 0, -1, 0.243167,-99) , 
3, 0.738177, 0, 0, 0.404609,-99) , 
1, 0.356348, 1, 0, 0.518552,-99)    );
  // itree = 730
  fBoostWeights.push_back(0.198614);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452658,-99) , 
2, -0.526824, 1, 0, 0.477342,-99) , 
NN(
0, 
0, 
-1, -0.847294, 1, -1, 0.323566,-99) , 
0, -0.908887, 0, 0, 0.451357,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
3, -1.67155, 0, 0, 0.43568,-99)    );
  // itree = 731
  fBoostWeights.push_back(0.264189);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.73389, 1, 1, 0.727123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309194,-99) , 
3, 1.2435, 0, 0, 0.494907,-99) , 
1, 1.49701, 1, 0, 0.665492,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32516,-99) , 
1, -0.423456, 0, 0, 0.624418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374248,-99) , 
0, 0.258655, 1, 0, 0.436971,-99) , 
0, 2.81258, 0, 0, 0.466337,-99) , 
1, 0.839672, 0, 0, 0.508178,-99)    );
  // itree = 732
  fBoostWeights.push_back(0.158155);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872273,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44998,-99) , 
0, -2.55353, 1, 0, 0.465974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242872,-99) , 
0, -3.47072, 0, 0, 0.45714,-99) , 
3, 3.35517, 0, 0, 0.470138,-99)    );
  // itree = 733
  fBoostWeights.push_back(0.192977);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.111041, 0, 1, 0.588608,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312386,-99) , 
0, 3.29203, 1, 0, 0.431545,-99) , 
2, 1.70123, 1, 0, 0.561465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.255424,-99) , 
2, -1.61118, 0, 0, 0.544461,-99)    );
  // itree = 734
  fBoostWeights.push_back(0.254158);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.233195, 0, 1, 0.726931,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61451,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453859,-99) , 
3, 2.05809, 0, 0, 0.500823,-99) , 
0, 0.824299, 1, 0, 0.584093,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465612,-99) , 
2, -1.19934, 0, 0, 0.513837,-99) , 
NN(
0, 
0, 
-1, -1.02277, 0, -1, 0.316631,-99) , 
0, -1.97532, 1, 0, 0.413758,-99) , 
3, -0.639447, 0, 0, 0.552974,-99)    );
  // itree = 735
  fBoostWeights.push_back(0.241928);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464694,-99) , 
2, -0.052187, 1, 0, 0.701875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585463,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359475,-99) , 
2, -0.175279, 0, 0, 0.553281,-99) , 
0, -0.623827, 1, 0, 0.574346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510408,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.034991,-99) , 
1, -0.323942, 1, 0, 0.254841,-99) , 
3, -1.22591, 0, 0, 0.556747,-99)    );
  // itree = 736
  fBoostWeights.push_back(0.279671);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.915725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480167,-99) , 
1, -0.493896, 1, 0, 0.544388,-99) , 
3, 0.387291, 1, 0, 0.572017,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.321606,-99) , 
2, -0.353382, 0, 0, 0.549415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.241439,-99) , 
0, -2.98793, 1, 0, 0.331534,-99) , 
3, -0.376357, 0, 0, 0.408426,-99) , 
3, 0.17816, 0, 0, 0.516239,-99)    );
  // itree = 737
  fBoostWeights.push_back(0.139368);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.59355, 1, 1, 0.726037,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47958,-99) , 
2, 0.396909, 1, 0, 0.516692,-99) , 
NN(
0, 
0, 
-1, -1.05767, 0, -1, 0.36591,-99) , 
3, -0.593922, 0, 0, 0.502328,-99) , 
0, -2.24414, 1, 0, 0.521793,-99)    );
  // itree = 738
  fBoostWeights.push_back(0.185446);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887935,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355134,-99) , 
0, 4.17351, 1, 0, 0.704621,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.163787,-99) , 
2, 1.78754, 1, 0, 0.49495,-99) , 
3, 2.53654, 0, 0, 0.516071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577956,-99) , 
NN(
0, 
0, 
-1, -1.5578, 0, -1, 0.291173,-99) , 
1, -1.7581, 1, 0, 0.353622,-99) , 
1, -0.977314, 0, 0, 0.482281,-99)    );
  // itree = 739
  fBoostWeights.push_back(0.225261);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484467,-99) , 
1, 0.363744, 1, 0, 0.560763,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358547,-99) , 
1, -1.441, 1, 0, 0.428908,-99) , 
1, -0.431895, 0, 0, 0.513938,-99) , 
NN(
0, 
0, 
-1, 4.25895, 1, -1, 0.228323,-99) , 
0, 3.85074, 1, 0, 0.498274,-99)    );
  // itree = 740
  fBoostWeights.push_back(0.254116);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.232726,-99) , 
2, 2.74311, 1, 0, 0.591071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.305462,-99) , 
3, 1.08829, 1, 0, 0.447921,-99) , 
3, 1.32511, 0, 0, 0.549991,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.92731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451519,-99) , 
3, 0.501484, 0, 0, 0.494594,-99) , 
NN(
0, 
0, 
-1, -0.252733, 1, -1, 0.313385,-99) , 
2, 0.155481, 1, 0, 0.430303,-99) , 
3, 0.791436, 0, 0, 0.484269,-99)    );
  // itree = 741
  fBoostWeights.push_back(0.206366);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810912,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345989,-99) , 
0, 4.61731, 1, 0, 0.692184,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369919,-99) , 
2, 1.39671, 1, 0, 0.531808,-99) , 
NN(
0, 
0, 
-1, 1.54482, 1, -1, 0.285748,-99) , 
0, 2.67705, 1, 0, 0.500926,-99) , 
3, 2.64851, 0, 0, 0.520334,-99)    );
  // itree = 742
  fBoostWeights.push_back(0.259014);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.1122, 1, 1, 0.673094,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429235,-99) , 
1, -0.636768, 1, 0, 0.630803,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415287,-99) , 
2, 0.108155, 1, 0, 0.481149,-99) , 
NN(
0, 
0, 
-1, -1.79745, 1, -1, 0.254496,-99) , 
3, -0.68846, 0, 0, 0.45696,-99) , 
1, -0.493896, 1, 0, 0.509309,-99)    );
  // itree = 743
  fBoostWeights.push_back(0.214628);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.925495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275662,-99) , 
3, -0.0705452, 0, 0, 0.55091,-99) , 
2, -0.533571, 1, 0, 0.565785,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380085,-99) , 
2, -0.972504, 1, 0, 0.494031,-99) , 
NN(
0, 
0, 
-1, -1.02927, 0, -1, 0.274171,-99) , 
1, 0.122417, 1, 0, 0.4035,-99) , 
3, -0.304384, 0, 0, 0.526702,-99)    );
  // itree = 744
  fBoostWeights.push_back(0.292615);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354934,-99) , 
0, 3.43493, 1, 0, 0.683144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46175,-99) , 
2, 0.0182404, 1, 0, 0.489606,-99) , 
1, -0.218242, 1, 0, 0.563952,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354683,-99) , 
3, -1.68154, 0, 0, 0.56635,-99) , 
NN(
0, 
0, 
-1, -0.375783, 1, -1, 0.344036,-99) , 
0, -1.95095, 1, 0, 0.401806,-99) , 
3, 0.0354976, 0, 0, 0.499511,-99)    );
  // itree = 745
  fBoostWeights.push_back(0.281234);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.760345, 0, 1, 0.801866,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277583,-99) , 
0, -1.99978, 1, 0, 0.497945,-99) , 
1, 0.301203, 0, 0, 0.604811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771425,-99) , 
NN(
0, 
0, 
-1, -0.756682, 0, -1, 0.386697,-99) , 
3, 3.12087, 0, 0, 0.398904,-99) , 
0, -0.947009, 1, 0, 0.437823,-99)    );
  // itree = 746
  fBoostWeights.push_back(0.308088);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0267238, 1, 1, 0.642258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.300154,-99) , 
0, -2.3633, 1, 0, 0.419004,-99) , 
3, -0.776089, 0, 0, 0.588124,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.841017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485473,-99) , 
1, 1.06182, 1, 0, 0.627705,-99) , 
NN(
0, 
0, 
-1, 0.215945, 1, -1, 0.325184,-99) , 
1, 0.641961, 0, 0, 0.413439,-99) , 
2, 0.60567, 1, 0, 0.514246,-99)    );
  // itree = 747
  fBoostWeights.push_back(0.223849);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.759198, 1, 1, 0.604512,-99) , 
NN(
0, 
0, 
-1, -0.0968879, 1, -1, 0.422741,-99) , 
3, -0.787254, 0, 0, 0.585508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24068,-99) , 
1, -1.71006, 0, 0, 0.567072,-99)    );
  // itree = 748
  fBoostWeights.push_back(0.216615);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.682227, 0, 1, 0.61464,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338874,-99) , 
0, 1.93468, 1, 0, 0.475729,-99) , 
1, -0.36158, 1, 0, 0.528227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.104831,-99) , 
3, -2.15197, 0, 0, 0.512151,-99)    );
  // itree = 749
  fBoostWeights.push_back(0.346762);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390449,-99) , 
1, 1.13972, 1, 0, 0.603404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189973,-99) , 
0, 2.01299, 0, 0, 0.358436,-99) , 
1, -0.968344, 0, 0, 0.546811,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286154,-99) , 
1, -1.04772, 0, 0, 0.458104,-99) , 
NN(
0, 
0, 
-1, -0.0707448, 0, -1, 0.31505,-99) , 
1, -0.414745, 1, 0, 0.365783,-99) , 
2, 0.508272, 0, 0, 0.456568,-99)    );
  // itree = 750
  fBoostWeights.push_back(0.12142);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.988888, 0, 1, 0.521533,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156147,-99) , 
3, -1.9067, 0, 0, 0.507825,-99) , 
NN(
0, 
0, 
-1, 2.42094, 1, -1, 0.324502,-99) , 
0, 2.74551, 1, 0, 0.473211,-99)    );
  // itree = 751
  fBoostWeights.push_back(0.291599);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309436,-99) , 
1, 1.16165, 1, 0, 0.672145,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.235646,-99) , 
0, 1.37998, 1, 0, 0.462102,-99) , 
2, 1.08824, 0, 0, 0.5205,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399094,-99) , 
3, 1.39484, 0, 0, 0.442071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214809,-99) , 
2, 1.93709, 1, 0, 0.415967,-99) , 
1, -0.0220652, 0, 0, 0.46787,-99)    );
  // itree = 752
  fBoostWeights.push_back(0.21861);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.21233, 1, 1, 0.698599,-99) , 
NN(
0, 
0, 
-1, 4.17113, 1, -1, 0.456886,-99) , 
2, 1.06313, 1, 0, 0.557642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.859402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463183,-99) , 
2, 0.314831, 0, 0, 0.527453,-99) , 
NN(
0, 
0, 
-1, 0.285488, 1, -1, 0.381353,-99) , 
1, -0.359664, 1, 0, 0.437511,-99) , 
2, 0.560086, 0, 0, 0.493654,-99)    );
  // itree = 753
  fBoostWeights.push_back(0.174067);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356598,-99) , 
2, 1.26441, 0, 0, 0.511612,-99) , 
0, 1.09891, 1, 0, 0.662628,-99) , 
NN(
NN(
0, 
0, 
-1, 1.50405, 1, 1, 0.560115,-99) , 
NN(
0, 
0, 
-1, 0.76289, 1, -1, 0.440268,-99) , 
0, 1.22149, 0, 0, 0.488737,-99) , 
1, 1.08213, 0, 0, 0.510309,-99)    );
  // itree = 754
  fBoostWeights.push_back(0.0980947);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732949,-99) , 
NN(
0, 
0, 
-1, 2.25901, 1, -1, 0.484094,-99) , 
2, 1.54433, 0, 0, 0.502899,-99) , 
NN(
0, 
0, 
-1, 2.22577, 1, -1, 0.229163,-99) , 
2, 1.90789, 1, 0, 0.483867,-99)    );
  // itree = 755
  fBoostWeights.push_back(0.202864);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.255748, 1, 1, 0.569173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.137241,-99) , 
2, 0.00645701, 0, 0, 0.346172,-99) , 
1, -1.60453, 0, 0, 0.543514,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339764,-99) , 
3, 0.228801, 0, 0, 0.527781,-99) , 
NN(
0, 
0, 
-1, 1.3986, 1, -1, 0.377024,-99) , 
1, 0.859797, 0, 0, 0.449695,-99) , 
1, 0.0914683, 1, 0, 0.494976,-99)    );
  // itree = 756
  fBoostWeights.push_back(0.261281);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.00448, 1, 1, 0.750571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440042,-99) , 
0, -1.15832, 1, 0, 0.496756,-99) , 
3, 0.817849, 0, 0, 0.535274,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31026,-99) , 
0, 2.8673, 1, 0, 0.46737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.128655,-99) , 
3, 1.33323, 0, 0, 0.413899,-99) , 
3, 1.14325, 1, 0, 0.492014,-99)    );
  // itree = 757
  fBoostWeights.push_back(0.263582);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.89783, 1, 1, 0.691602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.683545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390674,-99) , 
0, -1.68846, 1, 0, 0.488044,-99) , 
0, -0.417356, 0, 0, 0.642106,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287659,-99) , 
1, -0.102661, 0, 0, 0.597717,-99) , 
NN(
0, 
0, 
-1, 2.07167, 1, -1, 0.419699,-99) , 
3, 2.47882, 0, 0, 0.441002,-99) , 
1, 0.463922, 0, 0, 0.515212,-99)    );
  // itree = 758
  fBoostWeights.push_back(0.176336);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.277513, 0, 1, 0.569633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155412,-99) , 
0, 4.4506, 1, 0, 0.557032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233223,-99) , 
0, -3.05542, 0, 0, 0.541135,-99)    );
  // itree = 759
  fBoostWeights.push_back(0.278416);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.0681195, 1, 1, 0.74189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438045,-99) , 
3, 1.59088, 0, 0, 0.507982,-99) , 
3, 0.741647, 1, 0, 0.583141,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444955,-99) , 
1, -0.546517, 0, 0, 0.546583,-99) , 
NN(
0, 
0, 
-1, -1.04719, 0, -1, 0.193774,-99) , 
1, 0.0100439, 1, 0, 0.432002,-99) , 
3, -0.366527, 0, 0, 0.547258,-99)    );
  // itree = 760
  fBoostWeights.push_back(0.272826);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.596907, 0, 1, 0.530942,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165091,-99) , 
1, -0.0386249, 0, 0, 0.334087,-99) , 
2, 0.635683, 1, 0, 0.502132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548393,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.239995,-99) , 
3, 2.71241, 0, 0, 0.274659,-99) , 
1, -1.39701, 1, 0, 0.302403,-99) , 
0, 1.37723, 1, 0, 0.417327,-99)    );
  // itree = 761
  fBoostWeights.push_back(0.219649);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.942355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.243462,-99) , 
0, 3.72744, 1, 0, 0.541442,-99) , 
0, -1.67537, 1, 0, 0.555636,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.189307,-99) , 
2, -1.82265, 0, 0, 0.434771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204913,-99) , 
0, -1.35457, 1, 0, 0.333118,-99) , 
2, -0.724736, 0, 0, 0.518224,-99)    );
  // itree = 762
  fBoostWeights.push_back(0.205472);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.86431, 1, 1, 0.839883,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652477,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486166,-99) , 
2, -0.187039, 0, 0, 0.556001,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281934,-99) , 
3, 1.4242, 0, 0, 0.419044,-99) , 
3, 0.727241, 1, 0, 0.493068,-99) , 
1, -1.37597, 1, 0, 0.52372,-99)    );
  // itree = 763
  fBoostWeights.push_back(0.199207);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.31541, 1, 1, 0.730997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470807,-99) , 
0, -3.71633, 1, 0, 0.511409,-99) , 
0, -0.954417, 0, 0, 0.569794,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431903,-99) , 
3, 2.14693, 0, 0, 0.450829,-99) , 
NN(
0, 
0, 
-1, 0.416083, 0, -1, 0.247354,-99) , 
0, 3.51205, 1, 0, 0.431565,-99) , 
0, -0.0824338, 1, 0, 0.475906,-99)    );
  // itree = 764
  fBoostWeights.push_back(0.200992);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393205,-99) , 
1, 0.479653, 1, 0, 0.500136,-99) , 
NN(
0, 
0, 
-1, 2.70856, 0, -1, 0.308824,-99) , 
0, 2.87156, 1, 0, 0.467023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185137,-99) , 
3, -2.06496, 0, 0, 0.454688,-99)    );
  // itree = 765
  fBoostWeights.push_back(0.228658);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.2937, 0, 1, 0.593362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.231547,-99) , 
2, 2.33683, 0, 0, 0.385779,-99) , 
2, 1.88093, 1, 0, 0.558982,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.647458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48785,-99) , 
0, -1.24949, 1, 0, 0.560484,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340497,-99) , 
1, 1.13614, 0, 0, 0.37642,-99) , 
1, -0.591714, 1, 0, 0.427578,-99) , 
2, 0.161708, 0, 0, 0.507168,-99)    );
  // itree = 766
  fBoostWeights.push_back(0.239072);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49019,-99) , 
2, 0.907143, 1, 0, 0.591708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50697,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.128059,-99) , 
2, 0.397686, 1, 0, 0.45706,-99) , 
3, 0.301283, 0, 0, 0.513973,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.820621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355903,-99) , 
0, 4.12554, 1, 0, 0.59534,-99) , 
NN(
0, 
0, 
-1, 1.47312, 1, -1, 0.275612,-99) , 
3, 2.63161, 0, 0, 0.356439,-99) , 
0, 2.30263, 1, 0, 0.469131,-99)    );
  // itree = 767
  fBoostWeights.push_back(0.281827);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.364138, 0, 1, 0.788571,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383298,-99) , 
1, 0.592363, 0, 0, 0.453661,-99) , 
3, 0.29217, 0, 0, 0.518954,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355326,-99) , 
3, 1.30222, 0, 0, 0.461657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197664,-99) , 
1, -1.15254, 0, 0, 0.430057,-99) , 
0, 0.766877, 1, 0, 0.474902,-99)    );
  // itree = 768
  fBoostWeights.push_back(0.179307);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.560561, 0, 1, 0.596754,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425335,-99) , 
2, 0.352246, 1, 0, 0.456495,-99) , 
0, -0.691462, 1, 0, 0.492974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193589,-99) , 
1, 1.73295, 1, 0, 0.47693,-99)    );
  // itree = 769
  fBoostWeights.push_back(0.157515);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.04165, 1, 1, 0.666977,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459199,-99) , 
0, -1.67731, 1, 0, 0.480834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.204094,-99) , 
3, 2.97147, 0, 0, 0.322402,-99) , 
2, 1.63713, 1, 0, 0.463361,-99) , 
1, 1.59425, 0, 0, 0.474444,-99)    );
  // itree = 770
  fBoostWeights.push_back(0.18405);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.82482,-99) , 
NN(
0, 
0, 
-1, 1.08364, 1, -1, 0.4174,-99) , 
1, -2.1332, 1, 0, 0.431528,-99)    );
  // itree = 771
  fBoostWeights.push_back(0.209435);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.50524, 0, 1, 0.581885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199487,-99) , 
3, 2.85611, 1, 0, 0.565321,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0370262,-99) , 
0, -3.16923, 0, 0, 0.548464,-99)    );
  // itree = 772
  fBoostWeights.push_back(0.193795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407253,-99) , 
3, 1.45837, 0, 0, 0.442592,-99) , 
0, -1.78635, 1, 0, 0.454595,-99) , 
NN(
0, 
0, 
-1, -0.46091, 0, -1, 0.223169,-99) , 
3, -1.22591, 0, 0, 0.433862,-99)    );
  // itree = 773
  fBoostWeights.push_back(0.158484);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.634314,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284698,-99) , 
1, 1.08213, 1, 0, 0.477363,-99) , 
2, -0.414005, 1, 0, 0.513048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.142656,-99) , 
3, 2.85426, 1, 0, 0.496623,-99)    );
  // itree = 774
  fBoostWeights.push_back(0.221034);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.661562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488792,-99) , 
1, 0.295788, 1, 0, 0.581063,-99) , 
NN(
0, 
0, 
-1, -3.20228, 0, -1, 0.41747,-99) , 
3, 0.305709, 0, 0, 0.494196,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.312128,-99) , 
0, 3.54833, 1, 0, 0.386178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.173543,-99) , 
3, 2.11722, 0, 0, 0.306565,-99) , 
0, 2.69796, 1, 0, 0.464297,-99)    );
  // itree = 775
  fBoostWeights.push_back(0.171207);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.511476, 1, 1, 0.72058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459006,-99) , 
1, -0.863434, 0, 0, 0.666483,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483116,-99) , 
2, 0.301787, 1, 0, 0.515437,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.172638,-99) , 
2, 2.74755, 1, 0, 0.499848,-99) , 
0, -0.691462, 1, 0, 0.539828,-99)    );
  // itree = 776
  fBoostWeights.push_back(0.24566);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365201,-99) , 
1, -1.6752, 0, 0, 0.587185,-99) , 
NN(
0, 
0, 
-1, 0.103176, 0, -1, 0.349238,-99) , 
0, 3.16605, 1, 0, 0.55104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.141892,-99) , 
0, -3.14395, 0, 0, 0.537184,-99)    );
  // itree = 777
  fBoostWeights.push_back(0.196357);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -1.39632, 0, 1, 0.731666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369986,-99) , 
1, -0.552932, 0, 0, 0.609359,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458128,-99) , 
0, -0.164459, 1, 0, 0.491387,-99) , 
NN(
0, 
0, 
-1, 0.700207, 1, -1, 0.306723,-99) , 
0, -0.925343, 0, 0, 0.462474,-99) , 
0, -2.25694, 1, 0, 0.478826,-99)    );
  // itree = 778
  fBoostWeights.push_back(0.281746);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.574857, 0, 1, 0.606578,-99) , 
NN(
0, 
0, 
-1, -0.725198, 0, -1, 0.373996,-99) , 
1, 1.12171, 1, 0, 0.58327,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.274441,-99) , 
2, 2.42714, 1, 0, 0.606642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33048,-99) , 
0, 1.33817, 1, 0, 0.391222,-99) , 
3, 2.09754, 0, 0, 0.477157,-99) , 
3, 1.18513, 1, 0, 0.544478,-99)    );
  // itree = 779
  fBoostWeights.push_back(0.215117);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.30757, 1, 1, 0.757594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368214,-99) , 
1, 1.31432, 1, 0, 0.527853,-99) , 
3, -0.440661, 1, 0, 0.582316,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546236,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404081,-99) , 
0, 2.35643, 1, 0, 0.483603,-99) , 
NN(
0, 
0, 
-1, -0.300334, 1, -1, 0.399181,-99) , 
3, 0.736065, 0, 0, 0.438857,-99) , 
1, 0.463922, 0, 0, 0.489766,-99)    );
  // itree = 780
  fBoostWeights.push_back(0.289391);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675891,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464341,-99) , 
3, 1.58932, 1, 0, 0.582206,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.154782,-99) , 
1, -1.05032, 1, 0, 0.383101,-99) , 
1, -0.79687, 0, 0, 0.527535,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.749252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33851,-99) , 
1, 0.998092, 0, 0, 0.377174,-99) , 
1, -1.27354, 1, 0, 0.412468,-99) , 
3, 0.502357, 0, 0, 0.479628,-99)    );
  // itree = 781
  fBoostWeights.push_back(0.145359);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771677,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.833536,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429385,-99) , 
0, 0.318936, 1, 0, 0.466176,-99) , 
3, 3.21558, 0, 0, 0.477398,-99) , 
0, -3.89441, 1, 0, 0.486926,-99)    );
  // itree = 782
  fBoostWeights.push_back(0.23851);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.14951, 1, 1, 0.747422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64253,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385933,-99) , 
1, -0.714544, 1, 0, 0.54847,-99) , 
3, 0.736065, 0, 0, 0.641672,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476149,-99) , 
1, 1.13565, 0, 0, 0.51114,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19453,-99) , 
0, -2.24803, 1, 0, 0.283618,-99) , 
2, -0.816886, 0, 0, 0.476671,-99) , 
1, -0.294962, 1, 0, 0.538698,-99)    );
  // itree = 783
  fBoostWeights.push_back(0.173522);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.896104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465049,-99) , 
3, -0.353472, 0, 0, 0.717882,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475397,-99) , 
3, 2.96049, 0, 0, 0.493599,-99) , 
2, -0.490545, 1, 0, 0.516931,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722176,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341087,-99) , 
1, -0.548608, 0, 0, 0.475146,-99) , 
NN(
0, 
0, 
-1, -1.47675, 0, -1, 0.249015,-99) , 
1, -0.244539, 1, 0, 0.360475,-99) , 
3, -0.711955, 0, 0, 0.491869,-99)    );
  // itree = 784
  fBoostWeights.push_back(0.21473);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.738781,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469641,-99) , 
3, -1.03116, 0, 0, 0.633559,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429895,-99) , 
1, -0.244565, 0, 0, 0.508311,-99) , 
3, -0.28269, 1, 0, 0.538974,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69051,-99) , 
NN(
0, 
0, 
-1, -0.238882, 0, -1, 0.135496,-99) , 
3, 0.660704, 0, 0, 0.27478,-99) , 
1, -1.36512, 0, 0, 0.511117,-99)    );
  // itree = 785
  fBoostWeights.push_back(0.235331);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.389508, 1, 1, 0.599788,-99) , 
NN(
0, 
0, 
-1, 0.127805, 1, -1, 0.338533,-99) , 
3, -0.795792, 0, 0, 0.562032,-99) , 
NN(
0, 
0, 
-1, 2.0527, 1, -1, 0.346706,-99) , 
1, 1.06673, 1, 0, 0.529007,-99)    );
  // itree = 786
  fBoostWeights.push_back(0.290577);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480085,-99) , 
0, -0.498503, 0, 0, 0.743905,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422214,-99) , 
2, 1.6823, 1, 0, 0.586543,-99) , 
1, 0.137943, 0, 0, 0.61339,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.787931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388017,-99) , 
1, 1.78769, 1, 0, 0.635811,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.309266,-99) , 
0, 0.149184, 1, 0, 0.406276,-99) , 
1, 1.36449, 0, 0, 0.454845,-99) , 
1, 0.476476, 1, 0, 0.552256,-99)    );
  // itree = 787
  fBoostWeights.push_back(0.254703);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.22485, 1, 1, 0.561878,-99) , 
NN(
0, 
0, 
-1, -1.14866, 0, -1, 0.330377,-99) , 
2, -0.620353, 0, 0, 0.527925,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66019,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377099,-99) , 
3, 1.13577, 0, 0, 0.4624,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223378,-99) , 
2, 0.323798, 1, 0, 0.319174,-99) , 
1, -0.168292, 1, 0, 0.41636,-99) , 
1, 0.315534, 0, 0, 0.460417,-99)    );
  // itree = 788
  fBoostWeights.push_back(0.070748);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.763475,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494475,-99) , 
0, -2.02546, 1, 0, 0.501684,-99) , 
1, 1.75209, 0, 0, 0.512698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132626,-99) , 
3, -1.73087, 0, 0, 0.498901,-99)    );
  // itree = 789
  fBoostWeights.push_back(0.241069);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449155,-99) , 
3, 1.54769, 0, 0, 0.744414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.208082,-99) , 
0, 4.20555, 1, 0, 0.491026,-99) , 
0, 2.81933, 1, 0, 0.601024,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441205,-99) , 
3, -0.0641188, 0, 0, 0.493702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628246,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.288693,-99) , 
2, 0.0571657, 1, 0, 0.350887,-99) , 
0, 0.959076, 1, 0, 0.45406,-99) , 
3, 1.42475, 0, 0, 0.494365,-99)    );
  // itree = 790
  fBoostWeights.push_back(0.173838);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.02734, 0, 1, 0.695658,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473292,-99) , 
3, 1.09674, 0, 0, 0.512953,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.254882,-99) , 
3, 1.88994, 0, 0, 0.351607,-99) , 
2, 1.41124, 1, 0, 0.487865,-99) , 
3, 2.33715, 0, 0, 0.51209,-99)    );
  // itree = 791
  fBoostWeights.push_back(0.23175);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890979,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443011,-99) , 
2, -1.84734, 1, 0, 0.572402,-99) , 
3, -1.51374, 0, 0, 0.730221,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550415,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.155884,-99) , 
3, -0.740216, 0, 0, 0.520916,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393952,-99) , 
3, 3.05059, 0, 0, 0.412769,-99) , 
3, 0.884169, 1, 0, 0.459583,-99) , 
0, -1.4678, 1, 0, 0.493849,-99)    );
  // itree = 792
  fBoostWeights.push_back(0.21925);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76197,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41025,-99) , 
3, -1.40261, 0, 0, 0.667042,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574242,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37091,-99) , 
0, -1.51304, 1, 0, 0.485033,-99) , 
1, -0.323942, 1, 0, 0.571576,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.652553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439234,-99) , 
2, 1.45645, 1, 0, 0.536799,-99) , 
NN(
0, 
0, 
-1, 0.512056, 1, -1, 0.414856,-99) , 
2, 0.661343, 0, 0, 0.474223,-99) , 
0, -0.691462, 1, 0, 0.497125,-99)    );
  // itree = 793
  fBoostWeights.push_back(0.179565);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.742945, 0, 1, 0.649036,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181447,-99) , 
0, 2.45179, 1, 0, 0.545436,-99) , 
NN(
0, 
0, 
-1, -0.0548221, 0, -1, 0.436676,-99) , 
1, -0.823218, 1, 0, 0.457749,-99) , 
0, -2.52411, 1, 0, 0.471513,-99)    );
  // itree = 794
  fBoostWeights.push_back(0.236643);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.264997, 0, 1, 0.691805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26979,-99) , 
1, 0.902037, 1, 0, 0.495358,-99) , 
0, 1.96347, 1, 0, 0.593344,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376133,-99) , 
3, -1.84553, 0, 0, 0.530587,-99) , 
NN(
0, 
0, 
-1, 0.27458, 0, -1, 0.355328,-99) , 
0, -0.0327079, 1, 0, 0.47992,-99) , 
3, 0.392653, 0, 0, 0.541506,-99)    );
  // itree = 795
  fBoostWeights.push_back(0.228724);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.940214, 1, 1, 0.712958,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.251933,-99) , 
2, 0.618214, 1, 0, 0.510721,-99) , 
3, 0.943928, 0, 0, 0.561311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705081,-99) , 
NN(
0, 
0, 
-1, 0.852845, 1, -1, 0.378376,-99) , 
3, 2.9589, 0, 0, 0.437833,-99) , 
0, 2.30263, 1, 0, 0.534483,-99)    );
  // itree = 796
  fBoostWeights.push_back(0.26699);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.17274, 0, 1, 0.6873,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164594,-99) , 
0, 4.40722, 0, 0, 0.370367,-99) , 
0, 3.80144, 1, 0, 0.629875,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422552,-99) , 
3, -1.16603, 0, 0, 0.52371,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390095,-99) , 
3, 1.36053, 0, 0, 0.415237,-99) , 
3, -0.149094, 1, 0, 0.454806,-99) , 
0, 1.86512, 0, 0, 0.517881,-99)    );
  // itree = 797
  fBoostWeights.push_back(0.231941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.00366272, 0, 1, 0.637203,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.655383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442902,-99) , 
2, 1.53264, 0, 0, 0.511039,-99) , 
2, 0.000320877, 1, 0, 0.560578,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.635205,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325512,-99) , 
3, -0.15846, 0, 0, 0.574881,-99) , 
NN(
0, 
0, 
-1, 1.76473, 1, -1, 0.388996,-99) , 
1, 1.047, 0, 0, 0.447332,-99) , 
1, 0.107402, 1, 0, 0.507465,-99)    );
  // itree = 798
  fBoostWeights.push_back(0.215256);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.580685, 0, 1, 0.774451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550799,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273983,-99) , 
0, -1.91777, 1, 0, 0.419242,-99) , 
1, 0.837718, 1, 0, 0.690414,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442166,-99) , 
0, 1.70786, 1, 0, 0.501547,-99) , 
NN(
0, 
0, 
-1, 0.100208, 1, -1, 0.283203,-99) , 
0, -0.446015, 0, 0, 0.484005,-99) , 
0, -0.824643, 1, 0, 0.528535,-99)    );
  // itree = 799
  fBoostWeights.push_back(0.231691);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.295313, 1, 1, 0.596792,-99) , 
NN(
0, 
0, 
-1, -1.01563, 1, -1, 0.389824,-99) , 
3, -0.10173, 0, 0, 0.57101,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398087,-99) , 
2, -1.24744, 0, 0, 0.513747,-99) , 
NN(
0, 
0, 
-1, -0.613906, 1, -1, 0.320385,-99) , 
0, -1.08044, 1, 0, 0.413941,-99) , 
2, -0.319459, 0, 0, 0.525586,-99)    );
  // itree = 800
  fBoostWeights.push_back(0.303269);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.387455, 1, 1, 0.774837,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65593,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457294,-99) , 
1, -0.0229864, 1, 0, 0.547724,-99) , 
0, 0.254496, 1, 0, 0.580643,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.777145,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268367,-99) , 
2, -0.244074, 0, 0, 0.353746,-99) , 
1, 0.761126, 0, 0, 0.405923,-99) , 
3, -0.123397, 0, 0, 0.526636,-99)    );
  // itree = 801
  fBoostWeights.push_back(0.248243);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.44088, 0, 1, 0.721493,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601055,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33685,-99) , 
3, 2.84272, 0, 0, 0.406386,-99) , 
3, 1.78729, 1, 0, 0.559169,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.73859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467417,-99) , 
1, -0.291975, 1, 0, 0.613476,-99) , 
NN(
0, 
0, 
-1, -1.47724, 0, -1, 0.414001,-99) , 
2, -1.67682, 1, 0, 0.42906,-99) , 
3, 1.14325, 0, 0, 0.472988,-99)    );
  // itree = 802
  fBoostWeights.push_back(0.178097);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.694544, 0, 1, 0.545595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365456,-99) , 
1, 1.49288, 1, 0, 0.528384,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679738,-99) , 
NN(
0, 
0, 
-1, -0.297166, 1, -1, 0.349124,-99) , 
1, 0.822987, 0, 0, 0.398014,-99) , 
0, -0.0824338, 0, 0, 0.484486,-99)    );
  // itree = 803
  fBoostWeights.push_back(0.186843);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.175279, 1, 1, 0.555041,-99) , 
NN(
0, 
0, 
-1, 0.262598, 0, -1, 0.334251,-99) , 
1, -0.728951, 0, 0, 0.508439,-99) , 
NN(
0, 
0, 
-1, -1.13151, 1, -1, 0.348567,-99) , 
3, -0.376892, 0, 0, 0.477917,-99)    );
  // itree = 804
  fBoostWeights.push_back(0.250532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.336664, 1, 1, 0.592441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.171349,-99) , 
2, 2.60433, 1, 0, 0.570642,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409681,-99) , 
1, -0.414745, 1, 0, 0.498424,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156762,-99) , 
0, 0.251134, 1, 0, 0.447518,-99) , 
3, 0.487045, 0, 0, 0.510745,-99)    );
  // itree = 805
  fBoostWeights.push_back(0.143021);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.637445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462225,-99) , 
0, 2.85144, 1, 0, 0.555792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361623,-99) , 
2, 0.543013, 1, 0, 0.474831,-99) , 
0, 1.88371, 0, 0, 0.499547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.246675,-99) , 
2, 2.40061, 1, 0, 0.490535,-99)    );
  // itree = 806
  fBoostWeights.push_back(0.22666);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429127,-99) , 
1, 0.986857, 1, 0, 0.668645,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538367,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250003,-99) , 
1, -0.166166, 0, 0, 0.424932,-99) , 
0, 3.37161, 1, 0, 0.590045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669258,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367958,-99) , 
1, -0.0160202, 0, 0, 0.426851,-99) , 
0, -3.07207, 1, 0, 0.445009,-99) , 
3, 1.42475, 0, 0, 0.491976,-99)    );
  // itree = 807
  fBoostWeights.push_back(0.104976);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.63278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489468,-99) , 
1, 0.784977, 0, 0, 0.512801,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.302929,-99) , 
1, 1.652, 1, 0, 0.501666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.177609,-99) , 
2, 2.48923, 1, 0, 0.486763,-99)    );
  // itree = 808
  fBoostWeights.push_back(0.229378);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439833,-99) , 
1, -0.434668, 0, 0, 0.55076,-99) , 
NN(
0, 
0, 
-1, 0.0880123, 0, -1, 0.352675,-99) , 
1, 1.19036, 1, 0, 0.526515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.126964,-99) , 
0, 4.60939, 1, 0, 0.515801,-99)    );
  // itree = 809
  fBoostWeights.push_back(0.282577);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.209186, 0, 1, 0.868647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621753,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.290289,-99) , 
0, -0.118775, 1, 0, 0.536404,-99) , 
2, 0.170216, 0, 0, 0.613085,-99) , 
NN(
NN(
0, 
0, 
-1, 1.42027, 0, 1, 0.529665,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209398,-99) , 
2, 0.214379, 1, 0, 0.314552,-99) , 
3, 1.17723, 0, 0, 0.468055,-99) , 
0, 0.842728, 1, 0, 0.5388,-99)    );
  // itree = 810
  fBoostWeights.push_back(0.160137);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.819794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481018,-99) , 
0, 0.300793, 1, 0, 0.514537,-99) , 
NN(
0, 
0, 
-1, -0.356209, 1, -1, 0.396681,-99) , 
3, -0.020803, 0, 0, 0.475651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
2, 2.31918, 1, 0, 0.461774,-99)    );
  // itree = 811
  fBoostWeights.push_back(0.308466);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598315,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356932,-99) , 
1, -1.05528, 0, 0, 0.553542,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35686,-99) , 
3, 1.46196, 0, 0, 0.411944,-99) , 
3, -0.26895, 1, 0, 0.45817,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.293882,-99) , 
2, 1.24316, 0, 0, 0.431735,-99) , 
NN(
0, 
0, 
-1, 0.669574, 0, -1, 0.155417,-99) , 
2, 1.53573, 1, 0, 0.27191,-99) , 
0, 2.76684, 1, 0, 0.428246,-99)    );
  // itree = 812
  fBoostWeights.push_back(0.114469);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.872528,-99) , 
NN(
0, 
0, 
-1, 0.133065, 0, -1, 0.461304,-99) , 
3, -1.64378, 1, 0, 0.472909,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.124483,-99) , 
3, -2.00578, 0, 0, 0.46347,-99)    );
  // itree = 813
  fBoostWeights.push_back(0.194411);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.7856,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245426,-99) , 
2, -1.70245, 0, 0, 0.533834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287839,-99) , 
1, 0.167557, 1, 0, 0.409522,-99) , 
3, 1.14325, 1, 0, 0.483232,-99) , 
1, 1.89, 0, 0, 0.494332,-99)    );
  // itree = 814
  fBoostWeights.push_back(0.280862);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.597762, 0, 1, 0.65126,-99) , 
NN(
0, 
0, 
-1, 1.26039, 0, -1, 0.4355,-99) , 
2, 0.906949, 1, 0, 0.57695,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609454,-99) , 
NN(
0, 
0, 
-1, -1.62855, 1, -1, 0.269172,-99) , 
0, -0.728693, 0, 0, 0.323448,-99) , 
2, -0.724736, 0, 0, 0.533412,-99)    );
  // itree = 815
  fBoostWeights.push_back(0.244912);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.352782, 0, 1, 0.597109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361638,-99) , 
1, -0.870995, 1, 0, 0.421022,-99) , 
3, 0.062629, 0, 0, 0.53834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.165062,-99) , 
2, 2.34197, 1, 0, 0.520939,-99)    );
  // itree = 816
  fBoostWeights.push_back(0.322144);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.70778, 1, 1, 0.66533,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.168892,-99) , 
1, -1.20525, 1, 0, 0.383545,-99) , 
1, -0.421024, 0, 0, 0.573473,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614414,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318203,-99) , 
1, 0.846736, 1, 0, 0.560145,-99) , 
NN(
0, 
0, 
-1, 0.65094, 1, -1, 0.346447,-99) , 
2, -0.63692, 1, 0, 0.418429,-99) , 
2, 0.617679, 0, 0, 0.481025,-99)    );
  // itree = 817
  fBoostWeights.push_back(0.166449);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.263742, 1, 1, 0.547061,-99) , 
NN(
0, 
0, 
-1, -0.71283, 1, -1, 0.410368,-99) , 
1, -0.422881, 0, 0, 0.492906,-99) , 
NN(
0, 
0, 
-1, 4.30165, 1, -1, 0.280186,-99) , 
0, 3.19023, 1, 0, 0.467611,-99)    );
  // itree = 818
  fBoostWeights.push_back(0.240196);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648259,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413862,-99) , 
1, -0.489388, 1, 0, 0.619633,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371233,-99) , 
1, 0.268421, 0, 0, 0.456852,-99) , 
1, -0.359664, 1, 0, 0.515526,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364817,-99) , 
0, 3.28744, 0, 0, 0.407189,-99) , 
NN(
0, 
0, 
-1, 2.96047, 0, -1, 0.258091,-99) , 
2, 1.72669, 1, 0, 0.349457,-99) , 
0, 1.96897, 1, 0, 0.459858,-99)    );
  // itree = 819
  fBoostWeights.push_back(0.255571);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.374687, 0, 1, 0.701883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431749,-99) , 
2, 0.0157854, 0, 0, 0.478016,-99) , 
1, -0.969371, 1, 0, 0.525111,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61879,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377705,-99) , 
1, 0.240588, 1, 0, 0.459352,-99) , 
NN(
0, 
0, 
-1, 2.18035, 0, -1, 0.184784,-99) , 
1, -1.06235, 0, 0, 0.396048,-99) , 
0, 1.23253, 1, 0, 0.465742,-99)    );
  // itree = 820
  fBoostWeights.push_back(0.0922311);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770406,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226287,-99) , 
1, 1.64193, 1, 0, 0.501401,-99) , 
3, 2.32254, 0, 0, 0.517983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283327,-99) , 
0, 3.94239, 1, 0, 0.505268,-99)    );
  // itree = 821
  fBoostWeights.push_back(0.291602);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.67368, 1, 1, 0.638136,-99) , 
NN(
0, 
0, 
-1, -1.8412, 1, -1, 0.292098,-99) , 
3, -1.42593, 0, 0, 0.572761,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.737555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459268,-99) , 
2, 1.20164, 1, 0, 0.541236,-99) , 
NN(
0, 
0, 
-1, 0.76275, 1, -1, 0.325971,-99) , 
3, 1.32122, 0, 0, 0.435658,-99) , 
2, 0.275336, 1, 0, 0.489526,-99)    );
  // itree = 822
  fBoostWeights.push_back(0.160397);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776894,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.900149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411281,-99) , 
0, 3.62055, 1, 0, 0.590743,-99) , 
NN(
0, 
0, 
-1, 3.12372, 1, -1, 0.435524,-99) , 
3, 2.42553, 0, 0, 0.446498,-99) , 
3, 3.35517, 0, 0, 0.455051,-99)    );
  // itree = 823
  fBoostWeights.push_back(0.170197);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485245,-99) , 
2, 0.620418, 1, 0, 0.598509,-99) , 
NN(
0, 
0, 
-1, -1.30112, 0, -1, 0.459314,-99) , 
3, 0.295986, 0, 0, 0.522492,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51629,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.248326,-99) , 
3, 1.8973, 0, 0, 0.447353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.109425,-99) , 
2, 2.63512, 1, 0, 0.407848,-99) , 
0, 2.30263, 1, 0, 0.494483,-99)    );
  // itree = 824
  fBoostWeights.push_back(0.208948);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.692244, 1, 1, 0.647859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328847,-99) , 
0, -2.51654, 0, 0, 0.619635,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.754934,-99) , 
NN(
0, 
0, 
-1, -0.525391, 0, -1, 0.436729,-99) , 
0, -2.26714, 1, 0, 0.457735,-99) , 
1, -0.411712, 1, 0, 0.516933,-99)    );
  // itree = 825
  fBoostWeights.push_back(0.270776);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.39322, 1, 1, 0.617922,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42454,-99) , 
1, -1.00687, 0, 0, 0.470011,-99) , 
1, -0.868615, 0, 0, 0.583174,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183149,-99) , 
2, 1.94346, 1, 0, 0.462665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181622,-99) , 
0, 3.83645, 0, 0, 0.353854,-99) , 
0, 3.16316, 1, 0, 0.555082,-99)    );
  // itree = 826
  fBoostWeights.push_back(0.265764);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660519,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443594,-99) , 
0, 2.92579, 1, 0, 0.634578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.144888,-99) , 
3, -0.490936, 0, 0, 0.434778,-99) , 
1, -1.38907, 0, 0, 0.568662,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346422,-99) , 
0, 3.7885, 1, 0, 0.591712,-99) , 
NN(
0, 
0, 
-1, -0.898255, 0, -1, 0.409048,-99) , 
2, 1.49137, 0, 0, 0.443274,-99) , 
1, -0.359664, 1, 0, 0.491294,-99)    );
  // itree = 827
  fBoostWeights.push_back(0.216071);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.924961, 0, 1, 0.601434,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427437,-99) , 
1, -1.38867, 1, 0, 0.465089,-99) , 
1, 0.2359, 0, 0, 0.514204,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64178,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431576,-99) , 
3, 2.61065, 0, 0, 0.519778,-99) , 
NN(
0, 
0, 
-1, 0.02062, 1, -1, 0.271083,-99) , 
3, 1.9579, 0, 0, 0.421449,-99) , 
0, 1.94548, 1, 0, 0.49032,-99)    );
  // itree = 828
  fBoostWeights.push_back(0.325121);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.802952, 0, 1, 0.787243,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394582,-99) , 
2, 1.08653, 1, 0, 0.518259,-99) , 
2, -0.587373, 1, 0, 0.586965,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.198569,-99) , 
1, 1.25728, 1, 0, 0.513801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286754,-99) , 
1, 0.82648, 0, 0, 0.372287,-99) , 
2, 0.110847, 1, 0, 0.425253,-99) , 
1, -0.459297, 1, 0, 0.477326,-99)    );
  // itree = 829
  fBoostWeights.push_back(0.193903);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.9078,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640401,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447209,-99) , 
1, -1.51491, 0, 0, 0.5545,-99) , 
2, 1.80343, 0, 0, 0.594983,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526726,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397068,-99) , 
1, 0.681121, 1, 0, 0.470838,-99) , 
NN(
0, 
0, 
-1, -0.555592, 0, -1, 0.160294,-99) , 
1, -0.43375, 0, 0, 0.442476,-99) , 
1, -0.636138, 1, 0, 0.473921,-99)    );
  // itree = 830
  fBoostWeights.push_back(0.188139);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.9266,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194188,-99) , 
0, 3.60378, 1, 0, 0.561821,-99) , 
3, 3.40708, 0, 0, 0.581465,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227672,-99) , 
0, 3.4875, 1, 0, 0.514868,-99) , 
NN(
0, 
0, 
-1, -0.0436733, 1, -1, 0.308084,-99) , 
1, -0.137293, 1, 0, 0.485261,-99) , 
1, 0.0462137, 0, 0, 0.534067,-99)    );
  // itree = 831
  fBoostWeights.push_back(0.13056);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.667852, 1, 1, 0.692547,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.620621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482479,-99) , 
3, 1.7186, 0, 0, 0.512589,-99) , 
1, -1.31868, 1, 0, 0.529034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.132323,-99) , 
3, 2.9109, 1, 0, 0.515153,-99)    );
  // itree = 832
  fBoostWeights.push_back(0.282122);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.791528, 0, 1, 0.597802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392926,-99) , 
1, -0.0626338, 1, 0, 0.477333,-99) , 
0, 1.15056, 1, 0, 0.540735,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281703,-99) , 
2, -0.0379001, 0, 0, 0.457022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133151,-99) , 
1, -1.82805, 0, 0, 0.400185,-99) , 
1, -0.605638, 0, 0, 0.50125,-99)    );
  // itree = 833
  fBoostWeights.push_back(0.315917);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0.280684, 0, 1, 0.735416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539127,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236463,-99) , 
3, 0.714651, 0, 0, 0.475262,-99) , 
0, 0.611453, 1, 0, 0.534652,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713058,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334165,-99) , 
3, -1.06766, 0, 0, 0.547039,-99) , 
NN(
0, 
0, 
-1, -1.89681, 1, -1, 0.142974,-99) , 
1, -0.0109455, 1, 0, 0.383214,-99) , 
3, -0.304384, 0, 0, 0.499236,-99)    );
  // itree = 834
  fBoostWeights.push_back(0.208407);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -2.22776, 0, 1, 0.750048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396559,-99) , 
0, -2.49393, 1, 0, 0.63399,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488511,-99) , 
3, 0.619101, 1, 0, 0.536403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369747,-99) , 
1, -1.48425, 1, 0, 0.391096,-99) , 
2, 0.538068, 0, 0, 0.471428,-99) , 
2, -1.2329, 1, 0, 0.489058,-99)    );
  // itree = 835
  fBoostWeights.push_back(0.283579);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.17756, 1, 1, 0.617786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319929,-99) , 
2, -1.70547, 1, 0, 0.345743,-99) , 
1, 1.09951, 0, 0, 0.382952,-99) , 
3, 0.307824, 0, 0, 0.532039,-99)    );
  // itree = 836
  fBoostWeights.push_back(0.293609);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.810251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362522,-99) , 
3, 0.427855, 0, 0, 0.693387,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379958,-99) , 
0, 0.660517, 1, 0, 0.473288,-99) , 
1, 0.0437567, 0, 0, 0.511609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561503,-99) , 
NN(
0, 
0, 
-1, 2.67691, 1, -1, 0.316322,-99) , 
0, 3.23367, 0, 0, 0.346872,-99) , 
1, 0.414129, 1, 0, 0.45954,-99)    );
  // itree = 837
  fBoostWeights.push_back(0.201635);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495944,-99) , 
2, 2.54329, 1, 0, 0.697168,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40045,-99) , 
2, -0.0243696, 0, 0, 0.479003,-99) , 
NN(
0, 
0, 
-1, 3.25211, 0, -1, 0.276554,-99) , 
0, 2.62671, 1, 0, 0.449151,-99) , 
3, 2.62856, 0, 0, 0.465806,-99)    );
  // itree = 838
  fBoostWeights.push_back(0.228746);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.84452, 0, 1, 0.760833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.412242,-99) , 
3, 0.886569, 1, 0, 0.525032,-99) , 
0, 2.30345, 0, 0, 0.559808,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.216167,-99) , 
2, 2.39183, 0, 0, 0.377826,-99) , 
0, 3.42696, 1, 0, 0.54563,-99)    );
  // itree = 839
  fBoostWeights.push_back(0.300991);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413054,-99) , 
2, 0.829562, 1, 0, 0.526363,-99) , 
NN(
0, 
0, 
-1, -2.83981, 1, -1, 0.295581,-99) , 
3, -0.795792, 0, 0, 0.500969,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201964,-99) , 
0, -2.62764, 0, 0, 0.532697,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303353,-99) , 
3, 2.19506, 0, 0, 0.335863,-99) , 
0, -0.491733, 1, 0, 0.384238,-99) , 
1, -0.39136, 0, 0, 0.455308,-99)    );
  // itree = 840
  fBoostWeights.push_back(0.225294);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570889,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389052,-99) , 
1, -0.574113, 0, 0, 0.506076,-99) , 
1, 0.84565, 0, 0, 0.545234,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453056,-99) , 
0, 3.0766, 1, 0, 0.557844,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349392,-99) , 
0, 0.12449, 1, 0, 0.409416,-99) , 
3, 1.5483, 0, 0, 0.463307,-99) , 
2, -0.363302, 1, 0, 0.484103,-99)    );
  // itree = 841
  fBoostWeights.push_back(0.307231);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.60203, 0, 1, 0.609664,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359862,-99) , 
3, 2.57403, 0, 0, 0.445716,-99) , 
2, 1.12925, 1, 0, 0.531333,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.892118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390727,-99) , 
3, -0.08264, 0, 0, 0.468107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193706,-99) , 
0, -0.0327079, 1, 0, 0.407367,-99) , 
3, 0.234307, 0, 0, 0.482827,-99)    );
  // itree = 842
  fBoostWeights.push_back(0.365162);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297563,-99) , 
0, 3.62001, 1, 0, 0.668271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.622594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372925,-99) , 
0, 1.26943, 1, 0, 0.448584,-99) , 
1, 0.0914683, 1, 0, 0.5498,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358685,-99) , 
0, -3.07956, 1, 0, 0.552653,-99) , 
NN(
0, 
0, 
-1, -0.834294, 1, -1, 0.27151,-99) , 
0, -1.86171, 1, 0, 0.386992,-99) , 
3, -0.326776, 0, 0, 0.502756,-99)    );
  // itree = 843
  fBoostWeights.push_back(0.330998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.20415, 0, 1, 0.633761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.158756,-99) , 
0, 3.95248, 1, 0, 0.589495,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563815,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.206058,-99) , 
1, -1.04675, 0, 0, 0.48192,-99) , 
NN(
0, 
0, 
-1, 1.0316, 0, -1, 0.300485,-99) , 
2, -0.531675, 1, 0, 0.374865,-99) , 
2, 0.560086, 0, 0, 0.474895,-99)    );
  // itree = 844
  fBoostWeights.push_back(0.265714);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 2.4219, 1, 1, 0.696459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542422,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.249528,-99) , 
2, 1.44878, 1, 0, 0.494297,-99) , 
3, 2.0134, 0, 0, 0.561011,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427171,-99) , 
0, -0.566679, 0, 0, 0.473177,-99) , 
NN(
0, 
0, 
-1, -0.213052, 1, -1, 0.254268,-99) , 
0, -0.181337, 1, 0, 0.398895,-99) , 
3, 0.736065, 0, 0, 0.47584,-99)    );
  // itree = 845
  fBoostWeights.push_back(0.21272);
  fForest.push_back( 
NN(
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327475,-99) , 
0, -2.33826, 0, 0, 0.679944,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756856,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477172,-99) , 
1, 1.44532, 0, 0, 0.507002,-99) , 
1, -0.49856, 1, 0, 0.550237,-99) , 
NN(
0, 
0, 
-1, 0.778466, 1, -1, 0.384128,-99) , 
2, 0.75442, 1, 0, 0.486217,-99)    );
  // itree = 846
  fBoostWeights.push_back(0.262377);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.959444,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.756039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341869,-99) , 
0, -3.06324, 0, 0, 0.58678,-99) , 
1, 1.17468, 0, 0, 0.661307,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398676,-99) , 
3, 0.630682, 0, 0, 0.503045,-99) , 
NN(
0, 
0, 
-1, 0.771792, 1, -1, 0.205665,-99) , 
1, 1.45051, 1, 0, 0.47248,-99) , 
0, -1.60723, 1, 0, 0.498652,-99)    );
  // itree = 847
  fBoostWeights.push_back(0.251869);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 1.5441, 1, 1, 0.607952,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.194998,-99) , 
2, 2.52793, 1, 0, 0.558808,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372552,-99) , 
1, 0.419001, 1, 0, 0.477322,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502772,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225307,-99) , 
0, 0.587162, 1, 0, 0.268259,-99) , 
2, 0.452564, 1, 0, 0.403582,-99) , 
2, 1.04815, 0, 0, 0.450561,-99)    );
  // itree = 848
  fBoostWeights.push_back(0.249612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, -0.603672, 0, 1, 0.710128,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.278048,-99) , 
3, 1.08011, 0, 0, 0.496154,-99) , 
2, -0.371803, 1, 0, 0.555853,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402444,-99) , 
2, -0.862268, 1, 0, 0.420813,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185672,-99) , 
2, -1.6886, 0, 0, 0.406729,-99) , 
1, 0.736789, 0, 0, 0.442493,-99)    );
  // itree = 849
  fBoostWeights.push_back(0.22536);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.860135,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495528,-99) , 
1, -1.30927, 0, 0, 0.618758,-99) , 
1, -1.93128, 1, 0, 0.674358,-99) , 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359246,-99) , 
0, 2.87035, 1, 0, 0.535253,-99) , 
NN(
0, 
0, 
-1, -1.74087, 1, -1, 0.34271,-99) , 
2, -1.0546, 0, 0, 0.507217,-99) , 
1, -1.15254, 1, 0, 0.53206,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
