// Class: ReadCutsD
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Cuts::CutsD
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:48:37 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VarTransform: "Decorrelate" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
FitMethod: "MC" [Minimisation Method (GA, SA, and MC are the primary methods to be used; the others have been introduced for testing purposes and are depreciated)]
EffMethod: "EffSel" [Selection Method]
# Default:
VerbosityLevel: "Default" [Verbosity level]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
CutRangeMin[0]: "-1.000000e+00" [Minimum of allowed cut range (set per variable)]
    CutRangeMin[1]: "-1.000000e+00"
    CutRangeMin[2]: "-1.000000e+00"
    CutRangeMin[3]: "-1.000000e+00"
CutRangeMax[0]: "-1.000000e+00" [Maximum of allowed cut range (set per variable)]
    CutRangeMax[1]: "-1.000000e+00"
    CutRangeMax[2]: "-1.000000e+00"
    CutRangeMax[3]: "-1.000000e+00"
VarProp[0]: "FSmart" [Categorisation of cuts]
    VarProp[1]: "FSmart"
    VarProp[2]: "FSmart"
    VarProp[3]: "FSmart"
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadCutsD : public IClassifierReader {

 public:

   // constructor
   ReadCutsD( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadCutsD" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -4.41626024246216;
      fVmax[0] = 3.9983229637146;
      fVmin[1] = -3.44414329528809;
      fVmax[1] = 3.75072455406189;
      fVmin[2] = -3.77993965148926;
      fVmax[2] = 3.61461210250854;
      fVmin[3] = -3.38605976104736;
      fVmax[3] = 3.31522989273071;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadCutsD() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   double fDecTF_1[3][4][4];
   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   // not implemented for class: "ReadCutsD"
};
inline double ReadCutsD::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         std::vector<double> iV(inputValues);
         Transform( iV, -1 );
         retval = GetMvaValue__( iV );
   }

   return retval;
}

//_______________________________________________________________________
inline void ReadCutsD::InitTransform_1()
{
   // Decorrelation transformation, initialisation
   fDecTF_1[0][0][0] = 1.21489522811;
   fDecTF_1[0][0][1] = 0.0781716666657;
   fDecTF_1[0][0][2] = -0.141289027263;
   fDecTF_1[0][0][3] = -1.04311345347;
   fDecTF_1[0][1][0] = 0.0781716666657;
   fDecTF_1[0][1][1] = 0.955046635506;
   fDecTF_1[0][1][2] = 0.129245500657;
   fDecTF_1[0][1][3] = -0.228375934399;
   fDecTF_1[0][2][0] = -0.141289027263;
   fDecTF_1[0][2][1] = 0.129245500657;
   fDecTF_1[0][2][2] = 1.76933965197;
   fDecTF_1[0][2][3] = -0.810924100049;
   fDecTF_1[0][3][0] = -1.04311345347;
   fDecTF_1[0][3][1] = -0.228375934399;
   fDecTF_1[0][3][2] = -0.810924100049;
   fDecTF_1[0][3][3] = 2.75283058119;
   fDecTF_1[1][0][0] = 1.19931563977;
   fDecTF_1[1][0][1] = 0.0898657474542;
   fDecTF_1[1][0][2] = -0.198099534239;
   fDecTF_1[1][0][3] = -0.997356757609;
   fDecTF_1[1][1][0] = 0.0898657474542;
   fDecTF_1[1][1][1] = 0.983567573815;
   fDecTF_1[1][1][2] = 0.157368363165;
   fDecTF_1[1][1][3] = -0.229933202579;
   fDecTF_1[1][2][0] = -0.198099534239;
   fDecTF_1[1][2][1] = 0.157368363165;
   fDecTF_1[1][2][2] = 1.70771499731;
   fDecTF_1[1][2][3] = -0.73840740653;
   fDecTF_1[1][3][0] = -0.997356757609;
   fDecTF_1[1][3][1] = -0.229933202579;
   fDecTF_1[1][3][2] = -0.73840740653;
   fDecTF_1[1][3][3] = 2.629352105;
   fDecTF_1[2][0][0] = 1.11130577847;
   fDecTF_1[2][0][1] = 0.0549337705385;
   fDecTF_1[2][0][2] = -0.205578443911;
   fDecTF_1[2][0][3] = -0.799151588716;
   fDecTF_1[2][1][0] = 0.0549337705385;
   fDecTF_1[2][1][1] = 0.95764173867;
   fDecTF_1[2][1][2] = 0.136318851438;
   fDecTF_1[2][1][3] = -0.149026393072;
   fDecTF_1[2][2][0] = -0.205578443911;
   fDecTF_1[2][2][1] = 0.136318851438;
   fDecTF_1[2][2][2] = 1.71501571705;
   fDecTF_1[2][2][3] = -0.712828114941;
   fDecTF_1[2][3][0] = -0.799151588716;
   fDecTF_1[2][3][1] = -0.149026393072;
   fDecTF_1[2][3][2] = -0.712828114941;
   fDecTF_1[2][3][3] = 2.09615415622;
}

//_______________________________________________________________________
inline void ReadCutsD::Transform_1( std::vector<double>& iv, int cls) const
{
   // Decorrelation transformation
   if (cls < 0 || cls > 2) {
       if (2 > 1 ) cls = 2;
       else cls = 2;
   }

   // define the indices of the variables which are transformed by this transformation
   static std::vector<int> indicesGet;
   static std::vector<int> indicesPut;

   if ( indicesGet.empty() ) {
      indicesGet.reserve(fNvars);
      indicesGet.push_back( 0);
      indicesGet.push_back( 1);
      indicesGet.push_back( 2);
      indicesGet.push_back( 3);
   }
   if ( indicesPut.empty() ) {
      indicesPut.reserve(fNvars);
      indicesPut.push_back( 0);
      indicesPut.push_back( 1);
      indicesPut.push_back( 2);
      indicesPut.push_back( 3);
   }

   std::vector<double> tv;
   for (int i=0; i<4;i++) {
      double v = 0;
      for (int j=0; j<4; j++)
         v += iv[indicesGet.at(j)] * fDecTF_1[cls][i][j];
      tv.push_back(v);
   }
   for (int i=0; i<4;i++) iv[indicesPut.at(i)] = tv[i];
}

//_______________________________________________________________________
inline void ReadCutsD::InitTransform()
{
   InitTransform_1();
}

//_______________________________________________________________________
inline void ReadCutsD::Transform( std::vector<double>& iv, int sigOrBgd ) const
{
   Transform_1( iv, sigOrBgd );
}
