// Class: ReadLikelihood
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::Likelihood
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:48:37 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "True" [Print method-specific help message]
TransformOutput: "True" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <cmath>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihood : public IClassifierReader {

 public:

   // constructor
   ReadLikelihood( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihood" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadLikelihood() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[4]; 
   int    fNbin[4]; // number of bins (discrete variables may have less bins)
   double    fHistMin[4]; 
   double    fHistMax[4]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihood::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = -9.23118686676025;
   fHistMax[0] = 7.07192516326904;
   fNbin[1] = 10000;
   fHistMin[1] = -3.70671987533569;
   fHistMax[1] = 4.02912044525146;
   fNbin[2] = 10000;
   fHistMin[2] = -5.15695810317993;
   fHistMax[2] = 4.15070819854736;
   fNbin[3] = 10000;
   fHistMin[3] = -6.31600189208984;
   fHistMax[3] = 4.52105665206909;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
}

inline double ReadLikelihood::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihood: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihood::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (true) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihood::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihood::fRefS[][10000] = 
{ 
   { 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 5.30355646333192e-06, 2.01437933355919e-06, 8.52498851600103e-06, 1.50185996972141e-05, 2.15292093344033e-05, 2.80228196061216e-05, 3.45079315593466e-05, 4.09760432376061e-05, 4.74441585538443e-05, 5.39207721885759e-05, 6.03718835918698e-05, 6.68059947201982e-05, 7.32486078049988e-05, 7.96997192082927e-05, 8.61253429320641e-05, 9.25254498724826e-05, 9.89425752777606e-05, 0.000105359686131123, 0.000111751302029006, 0.000118134419608396, 0.000124517537187785, 0.000130892149172723, 0.000137266775709577, 0.000143615892739035, 0.000149965009768493, 0.000156322625116445, 0.000162654745508917, 0.000168986865901388, 0.000175310487975366, 0.000181625611730851, 0.000187940735486336, 0.000194238862604834, 0.000200528476852924, 0.000206818105652928, 0.000213099221582524, 0.000219371868297458, 0.000225635973038152, 0.000231900106882676, 0.000238147229538299, 0.000244385853875428, 0.000250624492764473, 0.000256854604231194, 0.000263076246483251, 0.000269280862994492, 0.000275493977824226, 0.000281698623439297, 0.000287886243313551, 0.000294065364869311, 0.000300236017210409, 0.000306423637084663, 0.00031256879447028, 0.000318730919389054, 0.000324876018567011, 0.000331029645167291, 0.000337149307597429, 0.000343277439242229, 0.000349397043464705, 0.000355525204213336, 0.000361610815161839, 0.000367713451851159, 0.000373799121007323, 0.000379884731955826, 0.000385953375371173, 0.000392021989682689, 0.000398090633098036, 0.000404142279876396, 0.000410176930017769, 0.000416228576796129, 0.000422254699515179, 0.000428280851338059, 0.000434281479101628, 0.000440307601820678, 0.000446308229584247, 0.000452308915555477, 0.000458275550045073, 0.000464267650386319, 0.000470242841402069, 0.000476217974210158, 0.000482159113744274, 0.000488108751596883, 0.000494066916871816, 0.000499999558087438, 0.000505915202666074, 0.000511839345563203, 0.000517754990141839, 0.000523679133038968, 0.00052956078434363, 0.000535459432285279, 0.00054134102538228, 0.000547231233213097, 0.000553087331354618, 0.000558952044229954, 0.000564825139008462, 0.000570672797039151, 0.00057649496011436, 0.000582334061618894, 0.000588164723012596, 0.000593995384406298, 0.000599792052526027, 0.000605597160756588, 0.000611393828876317, 0.000617190496996045, 0.000622970168478787, 0.000628741341643035, 0.000634512456599623, 0.000640275131445378, 0.00064602930797264, 0.000651774986181408, 0.000657512049656361, 0.000663249229546636, 0.000668969354592264, 0.00067468109773472, 0.000680401222780347, 0.000686104351188987, 0.000691782042849809, 0.000697476731147617, 0.000703162862919271, 0.000708840496372432, 0.000714492634870112, 0.000720153329893947, 0.00072581396671012, 0.000731457665096968, 0.00073708436684683, 0.00074271101038903, 0.000748346152249724, 0.000753964297473431, 0.000759557005949318, 0.000765158154536039, 0.00077075936133042, 0.000776343455072492, 0.0007819106685929, 0.00078748632222414, 0.000793053419329226, 0.000798620632849634, 0.000804153794888407, 0.000809695455245674, 0.000815228617284447, 0.000820770277641714, 0.000826278002932668, 0.0008317856118083, 0.000837293337099254, 0.000842792505864054, 0.0008482831181027, 0.000853765290230513, 0.000859247462358326, 0.000864712696056813, 0.000870169373229146, 0.000875625992193818, 0.000881074229255319, 0.000886513851583004, 0.000891945033799857, 0.000897367717698216, 0.000902790401596576, 0.000908196088857949, 0.000913593277800828, 0.000918998965062201, 0.000924387597478926, 0.000929767789784819, 0.000935130985453725, 0.000940494181122631, 0.000945865816902369, 0.000951220514252782, 0.000956549716647714, 0.000961887359153479, 0.000967233558185399, 0.000972554262261838, 0.000977857853285968, 0.000983161618933082, 0.000988473766483366, 0.000993768917396665, 0.000999038689769804, 0.00100431684404612, 0.00100959499832243, 0.00101487315259874, 0.00102010881528258, 0.00102536159101874, 0.00103060575202107, 0.00103584141470492, 0.00104106857907027, 0.00104628736153245, 0.00105150602757931, 0.00105669070035219, 0.00106190086808056, 0.00106709403917193, 0.00107227871194482, 0.00107745488639921, 0.00108262256253511, 0.00108779035508633, 0.00109294091816992, 0.00109807471744716, 0.00110322539694607, 0.001108359079808, 0.00111348426435143, 0.00111859245225787, 0.00112370064016432, 0.00112881732638925, 0.0011339170159772, 0.00113899121060967, 0.00114407390356064, 0.00114915671292692, 0.00115422229282558, 0.00115927099250257, 0.00116432819049805, 0.00116938538849354, 0.00117441709153354, 0.00117944029625505, 0.00118446350097656, 0.00118947820737958, 0.0011944929137826, 0.00119948212523013, 0.00120447983499616, 0.0012094690464437, 0.00121444964315742, 0.00121941335964948, 0.00122437707614154, 0.00122934090904891, 0.00123428751248866, 0.00123922573402524, 0.00124416383914649, 0.0012490936787799, 0.00125401478726417, 0.00125892751384526, 0.00126383185852319, 0.00126873597037047, 0.00127362320199609, 0.00127849343698472, 0.00128338066861033, 0.00128825090359896, 0.00129312090575695, 0.00129795726388693, 0.00130281050223857, 0.0013076551258564, 0.00131249136757106, 0.00131730199791491, 0.0013221213594079, 0.00132694898638874, 0.0013317511184141, 0.00133653648663312, 0.0013413216220215, 0.00134611537214369, 0.00135089212562889, 0.00135564326774329, 0.00136040290817618, 0.00136517116334289, 0.00136991392355412, 0.00137463968712837, 0.00137937383260578, 0.00138409959618002, 0.00138882524333894, 0.00139351701363921, 0.00139821716584265, 0.00140291743446141, 0.00140760920476168, 0.00141228397842497, 0.00141695013735443, 0.00142161641269922, 0.00142628257162869, 0.00143092323560268, 0.00143556389957666, 0.00144020467996597, 0.00144483696203679, 0.0014494521310553, 0.00145406741648912, 0.00145867408718914, 0.00146327225957066, 0.00146785355173051, 0.00147244322579354, 0.0014770245179534, 0.00148159719537944, 0.00148614437785, 0.00149070017505437, 0.00149526435416192, 0.00149980315472931, 0.00150432484224439, 0.00150884652975947, 0.00151337683200836, 0.00151789002120495, 0.00152238621376455, 0.00152688252273947, 0.00153137871529907, 0.00153586640954018, 0.00154032872524112, 0.00154479942284524, 0.0015492532402277, 0.00155370694119483, 0.00155815214384347, 0.00156258884817362, 0.00156702566891909, 0.00157144526019692, 0.00157585658598691, 0.0015802679117769, 0.00158467050641775, 0.00158906483557075, 0.00159345054998994, 0.0015978361479938, 0.00160220498219132, 0.00160656520165503, 0.00161092542111874, 0.00161527714226395, 0.00161962036509067, 0.00162394670769572, 0.00162828143220395, 0.00163260765839368, 0.00163692550268024, 0.00164121761918068, 0.00164551835041493, 0.00164981919806451, 0.00165410281624645, 0.00165836955420673, 0.00166263640858233, 0.0016669116448611, 0.00167116976808757, 0.00167540251277387, 0.00167964375577867, 0.00168389361351728, 0.00168811774346977, 0.0016923249932006, 0.00169654085766524, 0.00170074810739607, 0.00170495535712689, 0.00170912861358374, 0.00171331036835909, 0.00171749200671911, 0.00172165688127279, 0.00172581314109266, 0.0017299692844972, 0.00173411704599857, 0.00173825642559677, 0.00174237845931202, 0.00174650945700705, 0.00175062299240381, 0.0017547367606312, 0.00175883353222162, 0.00176293042022735, 0.00176701869349927, 0.00177109835203737, 0.00177516113035381, 0.00177923240698874, 0.00178329518530518, 0.0017873493488878, 0.00179137813393027, 0.00179541541729122, 0.00179945258423686, 0.00180348148569465, 0.00180747616104782, 0.00181148794945329, 0.00181549962144345, 0.00181949441321194, 0.00182346371002495, 0.00182744138874114, 0.00183142768219113, 0.00183538859710097, 0.00183933228254318, 0.00184327596798539, 0.00184722838457674, 0.00185116357170045, 0.00185508176218718, 0.00185900006908923, 0.00186291837599128, 0.00186682806815952, 0.0018707123817876, 0.00187460519373417, 0.00187848950736225, 0.00188236532267183, 0.00188623240683228, 0.00189009122550488, 0.00189394992776215, 0.00189779186621308, 0.00190162507351488, 0.00190545828081667, 0.00190929160453379, 0.00191310793161392, 0.00191690714564174, 0.00192071485798806, 0.0019245141884312, 0.00192830502055585, 0.0019320702413097, 0.00193585245870054, 0.00193961779586971, 0.00194336613640189, 0.00194711424410343, 0.00195087108295411, 0.0019546109251678, 0.00195832503959537, 0.00196204800158739, 0.00196577073074877, 0.00196948484517634, 0.00197316519916058, 0.0019768625497818, 0.00198055128566921, 0.00198424002155662, 0.00198789476417005, 0.0019915581215173, 0.00199522147886455, 0.00199886760674417, 0.00200250558555126, 0.00200614333152771, 0.00200977269560099, 0.00201339344494045, 0.00201699719764292, 0.0020206009503454, 0.00202420470304787, 0.00202780007384717, 0.00203137821517885, 0.00203494820743799, 0.00203852634876966, 0.00204208749346435, 0.00204563187435269, 0.00204918463714421, 0.00205272040329874, 0.00205625616945326, 0.00205976655706763, 0.00206329394131899, 0.00206680409610271, 0.00207031448371708, 0.00207379087805748, 0.00207728403620422, 0.0020807774271816, 0.00208424520678818, 0.00208770437166095, 0.00209116376936436, 0.00209462293423712, 0.00209806533530354, 0.00210149050690234, 0.00210492429323494, 0.00210835807956755, 0.00211177510209382, 0.00211516628041863, 0.00211856607347727, 0.0021219658665359, 0.00212535727769136, 0.00212872307747602, 0.00213209725916386, 0.00213546305894852, 0.00213882024399936, 0.00214216066524386, 0.00214550946839154, 0.00214884127490222, 0.00215217308141291, 0.00215548765845597, 0.00215880270116031, 0.0021621088963002, 0.00216540670953691, 0.00216869590803981, 0.00217197672463953, 0.00217525777406991, 0.00217852997593582, 0.00218177679926157, 0.00218504061922431, 0.00218828744255006, 0.00219153426587582, 0.00219474686309695, 0.00219798530451953, 0.00220120651647449, 0.00220441934652627, 0.00220760679803789, 0.00221080239862204, 0.00221399846486747, 0.00221718568354845, 0.00222034752368927, 0.00222350913099945, 0.00222667958587408, 0.00222983304411173, 0.0022329690400511, 0.00223610550165176, 0.00223924173042178, 0.00224236957728863, 0.00224547204561532, 0.00224858266301453, 0.00225168513134122, 0.00225478736683726, 0.00225785584188998, 0.00226094108074903, 0.00226400932297111, 0.00226708617992699, 0.0022701290436089, 0.00227318028919399, 0.0022762231528759, 0.002279257401824, 0.00228228326886892, 0.00228530913591385, 0.00228831777349114, 0.0022913096472621, 0.00229431851767004, 0.00229731877334416, 0.00230030226521194, 0.00230325991287827, 0.00230623479001224, 0.00230920966714621, 0.00231215893290937, 0.00231509981676936, 0.00231804046779871, 0.0023209813516587, 0.00232390523888171, 0.00232681212946773, 0.00232972740195692, 0.00233264267444611, 0.00233553256839514, 0.00233841384761035, 0.00234129512682557, 0.00234417640604079, 0.00234704930335283, 0.00235022488050163, 0.00235371408052742, 0.00235719443298876, 0.00236067525111139, 0.00236414303071797, 0.00236760219559073, 0.00237104878760874, 0.00237447838298976, 0.00237790774554014, 0.00238132895901799, 0.00238473317585886, 0.00238812435418367, 0.00239151576533914, 0.00239488575607538, 0.00239825574681163, 0.0024016173556447, 0.00240497034974396, 0.00240829796530306, 0.00241162977181375, 0.00241494434885681, 0.00241825077682734, 0.00242155720479786, 0.00242483359761536, 0.00242811441421509, 0.00243138242512941, 0.00243464205414057, 0.00243788468651474, 0.0024411273188889, 0.00244435714557767, 0.00244757393375039, 0.00245077814906836, 0.00245397840626538, 0.00245715724304318, 0.00246034446172416, 0.00246351910755038, 0.0024666681420058, 0.0024698085617274, 0.00247296621091664, 0.00247608567588031, 0.00247920071706176, 0.00248231994919479, 0.00248542660847306, 0.00248851603828371, 0.00249158870428801, 0.00249465694651008, 0.00249772518873215, 0.00250076386146247, 0.00250380695797503, 0.0025068367831409, 0.00250986684113741, 0.00251287152059376, 0.00251587596721947, 0.00251886341720819, 0.00252184667624533, 0.00252481736242771, 0.00252777966670692, 0.00253072893247008, 0.00253367400728166, 0.00253660627640784, 0.00253952597267926, 0.00254243263043463, 0.00254533928819001, 0.0025482252240181, 0.00255111465230584, 0.00255397078581154, 0.00255684368312359, 0.00255969492718577, 0.00256252544932067, 0.00256536435335875, 0.00256819883361459, 0.0025710123591125, 0.00257380842231214, 0.0025765965692699, 0.00257938820868731, 0.00258215516805649, 0.00258492142893374, 0.00258767558261752, 0.00259042927064002, 0.00259315338917077, 0.00259587331674993, 0.00259858905337751, 0.00260129594244063, 0.00260399025864899, 0.0026066720020026, 0.00260934908874333, 0.0026120136026293, 0.00261466996744275, 0.00261731306090951, 0.00261993962340057, 0.00262257014401257, 0.00262519251555204, 0.00262780161574483, 0.00263038952834904, 0.0026329776737839, 0.00263554067350924, 0.00263810320757329, 0.00264065293595195, 0.002643215470016, 0.00264574843458831, 0.00264826836064458, 0.00265077990479767, 0.00265329563990235, 0.00265578622929752, 0.0026582763530314, 0.00266074971295893, 0.00266323168762028, 0.00266567524522543, 0.00266811903566122, 0.00267056282609701, 0.00267298496328294, 0.00267540733329952, 0.00267781247384846, 0.00268020946532488, 0.00268260226584971, 0.0026849820278585, 0.00268733641132712, 0.00268970755860209, 0.00269204913638532, 0.00269437814131379, 0.00269671576097608, 0.00269903591834009, 0.00270133931189775, 0.00270364270545542, 0.00270592886954546, 0.00270821107551455, 0.00271047186106443, 0.00271273287944496, 0.00271498085930943, 0.00271721230819821, 0.00271944748237729, 0.00272166589275002, 0.00272387568838894, 0.00272607291117311, 0.00272826571017504, 0.00273044593632221, 0.00273260450921953, 0.00273477635346353, 0.00273693073540926, 0.00273906881920993, 0.00274118897505105, 0.00274332263506949, 0.00274543464183807, 0.0027475212700665, 0.00274961185641587, 0.00275170314125717, 0.00275377696380019, 0.00275582540780306, 0.00275787804275751, 0.00275993067771196, 0.00276194885373116, 0.00276397191919386, 0.00276599056087434, 0.00276800058782101, 0.00276998104527593, 0.00277196569368243, 0.00277394172735512, 0.0027759054210037, 0.002777851652354, 0.00277979369275272, 0.00278172339312732, 0.00278363958932459, 0.0027855564840138, 0.00278746034018695, 0.00278934719972312, 0.0027912340592593, 0.00279310857877135, 0.00279497425071895, 0.00279681826941669, 0.00279867090284824, 0.0028005070053041, 0.00280232192017138, 0.00280413217842579, 0.00280594662763178, 0.00280774454586208, 0.00280952104367316, 0.00281129288487136, 0.00281306519173086, 0.00281481584534049, 0.00281655415892601, 0.00281829223968089, 0.00282002612948418, 0.00282173440791667, 0.00282343872822821, 0.0028251342009753, 0.00282682129181921, 0.00282850000075996, 0.00283016171306372, 0.0028318150434643, 0.0028334641829133, 0.00283510005101562, 0.00283672357909381, 0.0028383256867528, 0.00283994036726654, 0.00284153851680458, 0.00284312339499593, 0.00284469616599381, 0.00284626823849976, 0.00284782378003001, 0.00284936209209263, 0.0028509006369859, 0.00285243475809693, 0.00285395607352257, 0.00285545224323869, 0.00285695237107575, 0.002858443884179, 0.00285991420969367, 0.00286138476803899, 0.0028628425206989, 0.00286429165862501, 0.00286572799086571, 0.00286716036498547, 0.00286857550963759, 0.00286998646333814, 0.00287138018757105, 0.00287276995368302, 0.00287415110506117, 0.00287551945075393, 0.00287687079980969, 0.00287822657264769, 0.00287956930696964, 0.00288089970126748, 0.00288220425136387, 0.00288352579809725, 0.00288481777533889, 0.00288609671406448, 0.00288737611845136, 0.00288865529000759, 0.00288991746492684, 0.00289115868508816, 0.00289240339770913, 0.00289364042691886, 0.00289485137909651, 0.00289605814032257, 0.00289726094342768, 0.0028984637465328, 0.00289963255636394, 0.00290080974809825, 0.00290196971036494, 0.00290312152355909, 0.00290426053106785, 0.00290539534762502, 0.00290651712566614, 0.00290761771611869, 0.00290872692130506, 0.00290982355363667, 0.00291089410893619, 0.002911965129897, 0.00291304034180939, 0.00291409017518163, 0.00291512720286846, 0.00291615538299084, 0.00291718821972609, 0.00291819521225989, 0.00291919405572116, 0.00292018847540021, 0.00292117008939385, 0.00292213936336339, 0.00292309978976846, 0.00292405160143971, 0.00292500341311097, 0.00292592984624207, 0.00292685208842158, 0.00292776571586728, 0.00292867538519204, 0.00292956340126693, 0.00293044745922089, 0.00293132290244102, 0.00293219392187893, 0.0029330481775105, 0.00293388520367444, 0.00293471850454807, 0.00293555110692978, 0.00293636322021484, 0.00293716625310481, 0.0029379609040916, 0.0029387513641268, 0.00293952482752502, 0.00294028129428625, 0.00294104218482971, 0.00294178980402648, 0.00294252531602979, 0.0029432475566864, 0.00294396583922207, 0.00294467131607234, 0.00294536422006786, 0.0029460524674505, 0.0029467239510268, 0.00294739101082087, 0.00294804549776018, 0.00294869160279632, 0.00294932490214705, 0.00294995354488492, 0.0029505742713809, 0.00295117753557861, 0.00295177265070379, 0.00295236334204674, 0.00295294541865587, 0.00295350654050708, 0.00295406323857605, 0.00295462016947567, 0.00295514683239162, 0.00295567815192044, 0.00295619224198163, 0.00295671517960727, 0.00295719923451543, 0.0029576881788671, 0.00295816850848496, 0.00295864441432059, 0.00295909494161606, 0.00295954965986311, 0.00295998761430383, 0.00296041229739785, 0.00296082883141935, 0.00296124955639243, 0.00296164024621248, 0.00296203163452446, 0.00296240975148976, 0.00296278367750347, 0.00296314479783177, 0.00296348473057151, 0.0029638207051903, 0.00296415225602686, 0.00296447495929897, 0.00296478113159537, 0.00296507845632732, 0.00296537601388991, 0.00296565657481551, 0.00296592875383794, 0.00296617927961051, 0.00296643865294755, 0.00296667614020407, 0.00296690594404936, 0.00296712690033019, 0.00296734366565943, 0.00296754343435168, 0.00296773039735854, 0.00296791316941381, 0.00296809151768684, 0.00296824891120195, 0.00296840211376548, 0.00296853785403073, 0.00296867801807821, 0.00296879722736776, 0.00296891201287508, 0.00296900980174541, 0.00296911154873669, 0.00296918815001845, 0.0029692561365664, 0.0029693238902837, 0.00296937930397689, 0.00296942191198468, 0.00296945567242801, 0.00296946428716183, 0.00296948570758104, 0.00296948570758104, 0.00296948128379881, 0.00296946428716183, 0.00296944309957325, 0.00296940049156547, 0.00296935392543674, 0.00296929874457419, 0.00296923471614718, 0.00296916253864765, 0.00296907336451113, 0.0029689755756408, 0.00296887801960111, 0.00296875881031156, 0.00296863564290106, 0.002968491287902, 0.00296835508197546, 0.00296819768846035, 0.0029680363368243, 0.00296785798855126, 0.00296767521649599, 0.00296748382970691, 0.00296727591194212, 0.00296705891378224, 0.00296683399938047, 0.00296660838648677, 0.00296635762788355, 0.00296610267832875, 0.00296583957970142, 0.00296557159163058, 0.00296528683975339, 0.00296498090028763, 0.00296467472799122, 0.00296436878852546, 0.00296404166147113, 0.00296371430158615, 0.00296336621977389, 0.0029630174394697, 0.00296265631914139, 0.00296227796934545, 0.00296189542859793, 0.00296150869689882, 0.00296110496856272, 0.0029606930911541, 0.00296026770956814, 0.00295984279364347, 0.00295940088108182, 0.00295894616283476, 0.00295848282985389, 0.00295801972970366, 0.00295753520913422, 0.00295704649761319, 0.00295654498040676, 0.00295602646656334, 0.00295550795271993, 0.00295498548075557, 0.00295444135554135, 0.00295388884842396, 0.00295332819223404, 0.0029527626466006, 0.00295217637903988, 0.00295158964581788, 0.00295098661445081, 0.0029503870755434, 0.00294974981807172, 0.00294912094250321, 0.0029484792612493, 0.00294783734716475, 0.00294717471115291, 0.00294650299474597, 0.00294582708738744, 0.00294513860717416, 0.0029444417450577, 0.00294372788630426, 0.00294300960376859, 0.00294228317216039, 0.00294154370203614, 0.00294079980812967, 0.00294003472663462, 0.00293927383609116, 0.00293849222362041, 0.00293770176358521, 0.00293690268881619, 0.00293609965592623, 0.00293528358452022, 0.00293445494025946, 0.00293361349031329, 0.00293277204036713, 0.00293191359378397, 0.00293104629963636, 0.00293016247451305, 0.00292928726412356, 0.00292838597670197, 0.00292748096399009, 0.00292656314559281, 0.0029256409034133, 0.00292469724081457, 0.00292374147102237, 0.00292278500273824, 0.00292182876728475, 0.00292085576802492, 0.00291986134834588, 0.0029188625048846, 0.00291786808520555, 0.00291684828698635, 0.00291582406498492, 0.00291478307917714, 0.00291374605149031, 0.00291268760338426, 0.00291162077337503, 0.00291054579429328, 0.00290946220047772, 0.00290836999192834, 0.00290726497769356, 0.00290614273399115, 0.00290502537973225, 0.00290389079600573, 0.00290274759754539, 0.002901591360569, 0.0029004355892539, 0.00289925839751959, 0.00289807305671275, 0.0028968786355108, 0.00289567606523633, 0.00289446488022804, 0.00289324508048594, 0.00289200409315526, 0.00289076729677618, 0.00288950535468757, 0.00288824294693768, 0.00288696819916368, 0.00288569345138967, 0.00288439681753516, 0.00288309226743877, 0.00288177491165698, 0.00288046174682677, 0.00287913158535957, 0.00287778466008604, 0.00287642888724804, 0.00287507730536163, 0.0028737005777657, 0.00287231476977468, 0.00287092523649335, 0.00286953127942979, 0.00286811217665672, 0.00286669237539172, 0.00286526465788484, 0.0028621656820178, 0.0028573467861861, 0.00285252742469311, 0.00284770829603076, 0.00284288497641683, 0.00283806561492383, 0.00283323787152767, 0.00282840174622834, 0.00282357400283217, 0.00281874625943601, 0.00281391409225762, 0.00280907819978893, 0.00280424626544118, 0.00279940129257739, 0.00279456959106028, 0.00278971600346267, 0.00278487568721175, 0.00278003537096083, 0.00277519063092768, 0.00277034565806389, 0.00276550138369203, 0.00276065221987665, 0.00275580328889191, 0.00275093736127019, 0.00274608843028545, 0.00274122669361532, 0.00273637776263058, 0.00273152021691203, 0.00272666267119348, 0.00272180116735399, 0.00271692220121622, 0.00271206465549767, 0.00270719453692436, 0.00270233722403646, 0.00269746268168092, 0.00269259233027697, 0.00268772221170366, 0.00268284790217876, 0.00267796474508941, 0.00267308624461293, 0.00266820727847517, 0.00266332877799869, 0.00265844981186092, 0.00265356712043285, 0.00264868373051286, 0.00264378823339939, 0.00263889273628592, 0.00263400515541434, 0.00262911827303469, 0.00262421811930835, 0.00261933100409806, 0.00261443108320236, 0.00260953954420984, 0.00260462681762874, 0.00259973527863622, 0.00259483116678894, 0.00258992286399007, 0.00258502271026373, 0.00258011464029551, 0.00257521006278694, 0.00257029756903648, 0.0025653806515038, 0.00256046769209206, 0.00255555519834161, 0.00255063828080893, 0.0025457211304456, 0.00254080421291292, 0.00253588287159801, 0.00253096595406532, 0.0025260322727263, 0.00252111069858074, 0.0025161812081933, 0.00251125544309616, 0.00250632595270872, 0.00250139180570841, 0.00249646231532097, 0.00249151955358684, 0.00248657306656241, 0.00248163915239275, 0.00247669662348926, 0.00247175851836801, 0.00246681598946452, 0.00246187322773039, 0.0024569311644882, 0.00245197163894773, 0.00244702911004424, 0.00244207819923759, 0.00243712705560029, 0.00243217195384204, 0.00242722104303539, 0.00242226175032556, 0.00241730641573668, 0.00241233827546239, 0.00240737898275256, 0.00240241945721209, 0.00239745154976845, 0.00239248364232481, 0.00238751573488116, 0.00238254340365529, 0.00237757549621165, 0.00237260782159865, 0.00236763106659055, 0.00236265896819532, 0.00235768663696945, 0.00235269730910659, 0.00234771682880819, 0.00234274030663073, 0.00233775959350169, 0.00233277026563883, 0.0023277853615582, 0.00232278788462281, 0.00231780274771154, 0.00231280084699392, 0.00230781571008265, 0.00230281823314726, 0.00229782471433282, 0.00229282700456679, 0.00228782929480076, 0.00228283158503473, 0.0022778210695833, 0.00227282335981727, 0.00226781726814806, 0.00226281536743045, 0.00225780461914837, 0.00225279433652759, 0.00224778382107615, 0.00224277353845537, 0.00223775021731853, 0.0022327397018671, 0.00222772103734314, 0.00222270633094013, 0.0022176830098033, 0.00221266411244869, 0.00220764079131186, 0.00220261770300567, 0.00219758157618344, 0.00219255406409502, 0.00218752678483725, 0.00218249508179724, 0.00217746337875724, 0.00217243144288659, 0.00216739997267723, 0.0021623382344842, 0.00215730676427484, 0.00215226202271879, 0.00214722217060626, 0.00214218208566308, 0.00213713315315545, 0.00213209283538163, 0.00212703994475305, 0.00212198705412447, 0.00211692973971367, 0.00211188546381891, 0.0021068281494081, 0.00210177106782794, 0.00209671794436872, 0.00209166086278856, 0.00208659516647458, 0.0020815294701606, 0.00207646377384663, 0.00207140226848423, 0.00206633238121867, 0.00206127087585628, 0.00205619679763913, 0.00205112691037357, 0.00204605679027736, 0.00204096990637481, 0.00203590001910925, 0.00203081732615829, 0.00202574301511049, 0.00202066032215953, 0.00201557762920856, 0.00201049912720919, 0.00200539943762124, 0.00200031255371869, 0.00199521705508232, 0.00199013436213136, 0.00198503886349499, 0.00197994778864086, 0.00197485229000449, 0.00196975679136813, 0.00196465291082859, 0.00195955322124064, 0.00195445353165269, 0.00194934953469783, 0.00194424553774297, 0.00193914584815502, 0.00193403335288167, 0.00192892947234213, 0.00192380836233497, 0.00191869598347694, 0.00191358779557049, 0.00190846261102706, 0.0019033543067053, 0.00189823354594409, 0.00189311266876757, 0.00188799586612731, 0.00188287068158388, 0.00187774549704045, 0.0018726116977632, 0.00186749501153827, 0.00186236144509166, 0.00185723195318133, 0.00185209396295249, 0.00184696458745748, 0.00184182648081332, 0.00183668872341514, 0.0018315379275009, 0.00182640017010272, 0.00182126206345856, 0.00181611557491124, 0.0018109775846824, 0.00180582702159882, 0.00180068053305149, 0.00179552554618567, 0.00179037917405367, 0.00178522418718785, 0.00178006920032203, 0.00177491002250463, 0.00176975503563881, 0.00176459597423673, 0.00175944098737091, 0.00175427319481969, 0.00174911401700228, 0.00174394634086639, 0.0017387829720974, 0.00173361087217927, 0.00172843900509179, 0.00172327551990747, 0.00171809934545308, 0.00171292328741401, 0.00170774280559272, 0.00170257512945682, 0.0016973860329017, 0.00169220566749573, 0.00168702937662601, 0.00168184051290154, 0.00167665584012866, 0.00167146685998887, 0.00166627368889749, 0.00166108051780611, 0.00165589153766632, 0.00165069825015962, 0.00164550519548357, 0.0016403078334406, 0.00163510604761541, 0.00162990437820554, 0.00162471109069884, 0.00161950511392206, 0.00161430344451219, 0.00160909758415073, 0.00160388730000705, 0.00159868563059717, 0.00159346277359873, 0.00158826098777354, 0.00158304651267827, 0.00157783215399832, 0.00157261348795146, 0.00156739901285619, 0.00156217615585774, 0.00155695318244398, 0.0015517259016633, 0.00154650711920112, 0.001541284378618, 0.00153605290688574, 0.00153082981705666, 0.00152559415437281, 0.00152036710642278, 0.00151512713637203, 0.00150989554822445, 0.00150465569458902, 0.00149941153358668, 0.00149416737258434, 0.00148892740253359, 0.00148368312511593, 0.0014784432714805, 0.00147319480311126, 0.0014679505256936, 0.00146270205732435, 0.00145744951441884, 0.0014521925477311, 0.00144693988841027, 0.00144168711267412, 0.00143642583861947, 0.00143116910476238, 0.00142590783070773, 0.00142065086401999, 0.00141538109164685, 0.00141011585947126, 0.00140485458541662, 0.0013995849294588, 0.00139431934803724, 0.00138904131017625, 0.00138377584517002, 0.00137849769089371, 0.00137322372756898, 0.00136794126592577, 0.00136266311164945, 0.00135738914832473, 0.0013521023793146, 0.00134682422503829, 0.00134153326507658, 0.00133625091984868, 0.00133094715420157, 0.00132566050160676, 0.00132037384901196, 0.00131508288905025, 0.00130978343077004, 0.00130448827985674, 0.00129918882157654, 0.00129389786161482, 0.00128858990501612, 0.00128329056315124, 0.00127798691391945, 0.00127268314827234, 0.00126737519167364, 0.00126206292770803, 0.00125675927847624, 0.00125144713092595, 0.00124613067600876, 0.00124081852845848, 0.00123550218995661, 0.00123018131125718, 0.00122486066538841, 0.00121954421047121, 0.00121422368101776, 0.00120889861136675, 0.00120356946717948, 0.00119824451394379, 0.00119291536975652, 0.00118758610915393, 0.00118225265759975, 0.00117692351341248, 0.0011715900618583, 0.00116624822840095, 0.00116090197116137, 0.00115556421224028, 0.00115022226236761, 0.00114488042891026, 0.00113953847903758, 0.001134192221798, 0.00112885038834065, 0.00112349144183099, 0.00111814949195832, 0.00111279485281557, 0.00110744009725749, 0.00110208545811474, 0.00109673070255667, 0.00109137175604701, 0.00108600861858577, 0.00108064967207611, 0.00107528653461486, 0.0010699275881052, 0.00106455583591014, 0.0010591926984489, 0.00105382094625384, 0.00104844942688942, 0.00104307767469436, 0.0010377059224993, 0.00103233009576797, 0.00102695415262133, 0.00102157390210778, 0.00101619795896113, 0.0010108093265444, 0.00100543338339776, 0.00100004044361413, 0.000994660309515893, 0.000989271560683846, 0.000983878620900214, 0.000978485681116581, 0.000973088492173702, 0.000967699859756976, 0.000962298363447189, 0.000956905481871217, 0.000951504043769091, 0.000946106854826212, 0.000940701167564839, 0.000935299787670374, 0.000929898233152926, 0.000924492720514536, 0.000919082667678595, 0.000913672789465636, 0.000908262853045017, 0.000902852916624397, 0.000897434481885284, 0.000892016047146171, 0.000886601861566305, 0.000881183485034853, 0.000875756493769586, 0.00087034230818972, 0.000864915433339775, 0.000859492691233754, 0.000854065758176148, 0.000848634634166956, 0.00084320770110935, 0.000837776460684836, 0.00083233678014949, 0.00082691409625113, 0.000821470224764198, 0.000816038984339684, 0.00081058667274192, 0.000805146933998913, 0.000799707253463566, 0.000794263323768973, 0.00078881939407438, 0.000783371215220541, 0.000777927285525948, 0.000772470608353615, 0.000767022371292114, 0.000761565752327442, 0.000756113324314356, 0.000750656647142023, 0.00074519996996969, 0.000739743292797357, 0.000734282366465777, 0.000728821440134197, 0.00072335620643571, 0.000717891030944884, 0.000712421664502472, 0.000706952239852399, 0.000701482815202326, 0.000696013332344592, 0.000690543907694519, 0.000685065984725952, 0.000679588061757386, 0.000674114387948066, 0.000668632215820253, 0.00066315004369244, 0.000657663564197719, 0.000652185641229153, 0.000646699219942093, 0.000641208549495786, 0.000635717937257141, 0.000630223017651588, 0.000624736538156867, 0.000619237369392067, 0.0006137466407381, 0.000608243281021714, 0.000602748361416161, 0.000597244885284454, 0.000591750023886561, 0.000586242298595607, 0.000580738938879222, 0.000575235462747514, 0.000569727795664221, 0.000564220128580928, 0.00055870390497148, 0.000553196296095848, 0.000547684321645647, 0.000542168214451522, 0.00053664343431592, 0.000531131576281041, 0.000525611161720008, 0.000520090688951313, 0.000514566025231034, 0.00050904561067, 0.000503520888742059, 0.000497987784910947, 0.00049245887203142, 0.000486929959151894, 0.000481400988064706, 0.00047585932770744, 0.000470330414827913, 0.000464788725366816, 0.000459242815850303, 0.000453701155493036, 0.000448163744295016, 0.000442617776570842, 0.000437076116213575, 0.000431525957537815, 0.000425984268076718, 0.000420429831137881, 0.000414883950725198, 0.000409325235523283, 0.000403775076847523, 0.000398220639908686, 0.00039266623207368, 0.000387103325920179, 0.000381536112399772, 0.000375981704564765, 0.000370418798411265, 0.000364851613994688, 0.000359284429578111, 0.000353717274265364, 0.000348150118952617, 0.0003425701870583, 0.000337003031745553, 0.000331427349010482, 0.000325855944538489, 0.000320271763484925, 0.000314696080749854, 0.000309116148855537, 0.00030353624606505, 0.000297952065011486, 0.000292363634798676, 0.000286779482848942, 0.000281186803476885, 0.000275594124104828, 0.000269997224677354, 0.000264408794464543, 0.000260497850831598, 0.000258228479651734, 0.000255965511314571, 0.000253712059929967, 0.000251457560807467, 0.000249220058321953, 0.00024698578636162, 0.000244755734456703, 0.000242536276346073, 0.000240318971918896, 0.000238115491811186, 0.000235915169469081, 0.000233722297707573, 0.00023153581423685, 0.000229358891374432, 0.000227187265409157, 0.000225020936341025, 0.000222862086957321, 0.000220713831367902, 0.000218573011807166, 0.00021643222135026, 0.00021430519700516, 0.000212180340895429, 0.000210068217711523, 0.000207956079975702, 0.000205854579689912, 0.000203758390853181, 0.000201670700334944, 0.000199589398107491, 0.000197516579646617, 0.000195450120372698, 0.000193389001651667, 0.000191335318959318, 0.000189292244613171, 0.00018725662084762, 0.00018522099708207, 0.000183200230821967, 0.000181181603693403, 0.000179173599462956, 0.000177164532942697, 0.000175173525349237, 0.000173181455465965, 0.000171201070770621, 0.000169222810654901, 0.000167257312568836, 0.000165292862220667, 0.000163340097060427, 0.000161392643349245, 0.000159450515639037, 0.000157521135406569, 0.000155588568304665, 0.000153672983287834, 0.000151760599692352, 0.000149856714415364, 0.000147954953717999, 0.000146065940498374, 0.000144180114148185, 0.000142307035275735, 0.00014043076953385, 0.000138572562718764, 0.000136717557325028, 0.000134867848828435, 0.000133025576360524, 0.000131188644445501, 0.000129364430904388, 0.000127541279653087, 0.000125724531244487, 0.00012391731434036, 0.000122118610306643, 0.000120326280011795, 0.000118540323455818, 0.000116760747914668, 0.000114990718429908, 0.000113220696221106, 0.000111465553345624, 0.000109718901512679, 0.000107972264231648, 0.000106236235296819, 0.000104503400507383, 0.000102782258181833, 0.000101065357739571, 9.93580179056153e-05, 9.7655996796675e-05, 9.59614117164165e-05, 9.42742626648396e-05, 9.25945423659869e-05, 9.09201407921501e-05, 8.92521202331409e-05, 8.75915284268558e-05, 8.5935193055775e-05, 8.42937297420576e-05, 8.2654383732006e-05, 8.10246128821746e-05, 7.93948274804279e-05, 7.77809909777716e-05, 7.6172458648216e-05, 7.45671131880954e-05, 7.29692110326141e-05, 7.13808694854379e-05, 6.9801026256755e-05, 6.82233003317378e-05, 6.66540872771293e-05, 6.50912406854331e-05, 6.35400792816654e-05, 6.19910497334786e-05, 6.04505148658063e-05, 5.89163537370041e-05, 5.73896359128412e-05, 5.58714127691928e-05, 5.43563764949795e-05, 5.28551536262967e-05, 5.13549930474255e-05, 4.98665212944616e-05, 4.837804226554e-05, 4.69033802801277e-05, 4.543083923636e-05, 4.3967866076855e-05, 4.25102043664083e-05, 4.10652901337016e-05, 3.96193136111833e-05, 3.81839599867817e-05, 3.67549837392289e-05, 3.53376890416257e-05, 3.39257094310597e-05, 3.25147957482841e-05, 3.11166295432486e-05, 2.97227106784703e-05, 2.83383560599759e-05, 2.69529373326804e-05, 2.55855829891516e-05, 2.42182268266333e-05, 2.28636199608445e-05, 2.15068848774536e-05, 2.01682141778292e-05, 1.88274207175709e-05, 1.75004370248644e-05, 1.61766383826034e-05, 1.48624030771316e-05, 1.35534837681917e-05, 1.22477467812132e-05, 1.0956885489577e-05, 9.66815059655346e-06, 8.38791220303392e-06, 7.11086204319145e-06, 5.84550116400351e-06, 4.58545173387392e-06, 3.33389994011668e-06, 2.08235019272252e-06, 8.46736099902046e-07, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 0.000261615583440289, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 0.000904638727661222, 2.41919724430772e-06, 6.36296545053483e-06, 1.03173624665942e-05, 1.42993631015997e-05, 1.83004995051306e-05, 2.23462520807516e-05, 2.63782112597255e-05, 3.04717650578823e-05, 3.45504449796863e-05, 3.86822684959043e-05, 4.28172897954937e-05, 4.6996894525364e-05, 5.1187162171118e-05, 5.53965110157151e-05, 5.96420068177395e-05, 6.38821948086843e-05, 6.81755118421279e-05, 7.24698693375103e-05, 7.68099198467098e-05, 8.11436111689545e-05, 8.55229736771435e-05, 8.99023361853324e-05, 9.43369523156434e-05, 9.87651583272964e-05, 0.0001032380387187, 0.000107721512904391, 0.000112233683466911, 0.000116764975246042, 0.000121322824270464, 0.000125910417409614, 0.000130499072838575, 0.000135133421281353, 0.000139769894303754, 0.000144451012602076, 0.000149142724694684, 0.000153853558003902, 0.000158593073138036, 0.00016335173859261, 0.000168138009030372, 0.000172943415236659, 0.000177767942659557, 0.000182627511094324, 0.000187498779268935, 0.000192408318980597, 0.000197310393559746, 0.000202274080947973, 0.000207239951123483, 0.000212227023439482, 0.000217239576159045, 0.000222273418330587, 0.000227333803195506, 0.000232413309277035, 0.000237529966398142, 0.000242648791754618, 0.000247803749516606, 0.000252969301072881, 0.000258172076428309, 0.000263375870417804, 0.000268633884843439, 0.000273885496426374, 0.000279180676443502, 0.000284487556200475, 0.000289823074126616, 0.000295176752842963, 0.000300560088362545, 0.000305978493997827, 0.000311383133521304, 0.000316848279908299, 0.000322299660183489, 0.000327812653267756, 0.000333310716086999, 0.000338863057550043, 0.000344424886861816, 0.000350006914231926, 0.000355616619344801, 0.000361245387466624, 0.000366894382750615, 0.000372578419046476, 0.00037827409687452, 0.000383997452445328, 0.000389737804653123, 0.000395517476135865, 0.000401306664571166, 0.000407124578487128, 0.00041296158451587, 0.000418817769968882, 0.000424701516749337, 0.00043060549069196, 0.000436537084169686, 0.000442479271441698, 0.0004484660748858, 0.000454446562798694, 0.000460481183836237, 0.00046650946023874, 0.00047258980339393, 0.000478665868286043, 0.00048478547250852, 0.000490908336360008, 0.000497083179652691, 0.000503269722685218, 0.00050945847760886, 0.000515700259711593, 0.000521928246598691, 0.000528215721715242, 0.00053449795814231, 0.000540826877113432, 0.000547165342140943, 0.000553531514015049, 0.000559909327421337, 0.000566323229577392, 0.000572747783735394, 0.000579208426643163, 0.000585696776397526, 0.000592179712839425, 0.000598715909291059, 0.000605262583121657, 0.000611836963798851, 0.000618422927800566, 0.00062503555091098, 0.000631676870398223, 0.000638337281998247, 0.000645016843918711, 0.000651725044008344, 0.000658449251204729, 0.000665212690364569, 0.000671978283207864, 0.000678788521327078, 0.000685592356603593, 0.000692450383212417, 0.000699302065186203, 0.00070620677433908, 0.000713122135493904, 0.000720048206858337, 0.000727011414710432, 0.000733985216356814, 0.000741002673748881, 0.00074801582377404, 0.000755081011448056, 0.000762140902224928, 0.000769244332332164, 0.000776350905653089, 0.000783502182457596, 0.000790656660683453, 0.00079785258276388, 0.000805062241852283, 0.000812290061730891, 0.000819547509308904, 0.000826831557787955, 0.000834143196698278, 0.000841449713334441, 0.000848809140734375, 0.000856170721817762, 0.000863576948177069, 0.000870986375957727, 0.000878430844750255, 0.000885887129697949, 0.000893370830453932, 0.000900874845683575, 0.00090948841534555, 0.000919339363463223, 0.000929283793084323, 0.000939236662816256, 0.000949257577303797, 0.000959312485065311, 0.000969435379374772, 0.000979626318439841, 0.000989834195934236, 0.00100010156165808, 0.0010104114189744, 0.00102078076452017, 0.00103120121639222, 0.0010416810400784, 0.00105218647513539, 0.001062759780325, 0.00107335869688541, 0.00108405959326774, 0.00109476037323475, 0.00110553775448352, 0.00111634063068777, 0.00112721999175847, 0.00113815034274012, 0.00114912318531424, 0.00116013002116233, 0.00117119634523988, 0.00118233077228069, 0.00119350745808333, 0.00120472686830908, 0.0012159887701273, 0.00122731854207814, 0.00123867392539978, 0.00125012267380953, 0.00126158853527158, 0.00127310527022928, 0.00128467311151326, 0.00129630044102669, 0.00130797026213259, 0.00131968257483095, 0.00133148825261742, 0.0013433025451377, 0.00135517644230276, 0.00136710121296346, 0.00137906847521663, 0.00139109534211457, 0.00140317308250815, 0.00141529331449419, 0.00142745615448803, 0.00143968674819916, 0.00145198579411954, 0.00146428449079394, 0.0014766767853871, 0.00148908596020192, 0.0015015717362985, 0.00151409150566906, 0.00152667926158756, 0.00153930950909853, 0.00155197374988347, 0.00156470597721636, 0.00157748919446021, 0.00159032340161502, 0.00160317472182214, 0.00161612790543586, 0.00162907259073108, 0.00164213636890054, 0.00165520014706999, 0.00166833191178739, 0.00168149755336344, 0.00169473106507212, 0.00170801591593772, 0.00172134325839579, 0.00173472124151886, 0.00174814206548035, 0.00176163064315915, 0.00177517044357955, 0.00178874400444329, 0.00180237728636712, 0.00181605294346809, 0.00182977120857686, 0.00184356584213674, 0.0018573944689706, 0.00187127420213073, 0.00188519642688334, 0.0018991781398654, 0.0019132022280246, 0.00192730291746557, 0.00194142910186201, 0.00195561465807259, 0.00196983432397246, 0.00198412197642028, 0.00199846061877906, 0.00201284186914563, 0.00202729110606015, 0.00204175710678101, 0.00205629132688046, 0.00207087653689086, 0.00208551250398159, 0.00210018269717693, 0.00211492925882339, 0.00212970119901001, 0.00214455835521221, 0.0021594325080514, 0.00217437464743853, 0.00218934216536582, 0.00220438651740551, 0.00221947301179171, 0.00223461049608886, 0.00224978220649064, 0.00226502190344036, 0.00228031235747039, 0.00229566241614521, 0.00231104646809399, 0.00232646451331675, 0.00234196777455509, 0.00235748779959977, 0.00237309280782938, 0.0023887234274298, 0.00240441341884434, 0.00242014601826668, 0.00243593822233379, 0.0024517725687474, 0.00246766651980579, 0.00248359492979944, 0.00249959086067975, 0.00251560402102768, 0.00253173569217324, 0.00254786782898009, 0.00256405118852854, 0.00258029345422983, 0.00259657017886639, 0.00261293142102659, 0.00262931850738823, 0.0026457563508302, 0.00266222865320742, 0.00267877709120512, 0.00269537651911378, 0.00271201017312706, 0.00272871158085763, 0.002745455596596, 0.00276225060224533, 0.00277907121926546, 0.00279597658663988, 0.00281291618011892, 0.00282991514541209, 0.00284695671871305, 0.00286404928192496, 0.00288117560558021, 0.00289839552715421, 0.00291562429629266, 0.00293292081914842, 0.00295025971718132, 0.00296764937229455, 0.00298509048298001, 0.0030026079621166, 0.00302013382315636, 0.00303772790357471, 0.003055389970541, 0.00307307718321681, 0.0030908240005374, 0.00310861365869641, 0.00312646245583892, 0.00314433663152158, 0.00316229648888111, 0.0031802982557565, 0.00319835124537349, 0.00321643822826445, 0.00323458458296955, 0.00325276493094862, 0.00327104749158025, 0.00328932143747807, 0.00330767198465765, 0.00332605605944991, 0.00334451720118523, 0.00336302048526704, 0.00338156637735665, 0.00340016302652657, 0.00341881136409938, 0.00343751022592187, 0.00345626031048596, 0.00347507791593671, 0.00349390413612127, 0.00351280719041824, 0.00353175238706172, 0.00355076580308378, 0.003569804597646, 0.00358891184441745, 0.00360805261880159, 0.00362725276499987, 0.00364651251584291, 0.00366581510752439, 0.00368515122681856, 0.00370456394739449, 0.00372401950880885, 0.00374351721256971, 0.00376308313570917, 0.00378267467021942, 0.00380232534371316, 0.0038220186252147, 0.00384177989326417, 0.00386156677268445, 0.00388143863528967, 0.00390132726170123, 0.00392128434032202, 0.00394129194319248, 0.00396135076880455, 0.00398143520578742, 0.00400160439312458, 0.00402179080992937, 0.00404206197708845, 0.00406238436698914, 0.00408272398635745, 0.00410313112661242, 0.00412357226014137, 0.0041440986096859, 0.00416463334113359, 0.00418525328859687, 0.00420588999986649, 0.00422660307958722, 0.00424737576395273, 0.00426818244159222, 0.00428902311250567, 0.00430994061753154, 0.0043308837339282, 0.0043519027531147, 0.00437295576557517, 0.00439406046643853, 0.00441520707681775, 0.00443642167374492, 0.00445770425722003, 0.00447899522259831, 0.00450037186965346, 0.00452177366241813, 0.00454323505982757, 0.00456472206860781, 0.00458629336208105, 0.00460790749639273, 0.00462956400588155, 0.00465127173811197, 0.00467303022742271, 0.00469482364133, 0.00471670925617218, 0.0047386297956109, 0.00476056709885597, 0.00478258915245533, 0.00480464519932866, 0.0048267524689436, 0.00484892772510648, 0.00487113697454333, 0.00489338021725416, 0.00491569982841611, 0.00493805343285203, 0.00496048387140036, 0.00498293898999691, 0.00500545464456081, 0.0050280038267374, 0.00505062052980065, 0.00507328892126679, 0.00509600806981325, 0.00511877844110131, 0.00514158187434077, 0.00516443746164441, 0.00518736010417342, 0.00521032605320215, 0.00523333437740803, 0.00525641022250056, 0.0052795116789639, 0.00530269043520093, 0.00532589387148619, 0.00534916529431939, 0.0053724623285234, 0.00539583619683981, 0.00541925244033337, 0.00544272782281041, 0.00546623766422272, 0.0054898071102798, 0.00551342638209462, 0.00553709827363491, 0.00556081999093294, 0.00558457570150495, 0.00560839101672173, 0.00563224963843822, 0.00565619254484773, 0.00568015268072486, 0.00570417288690805, 0.00572822568938136, 0.00575234787538648, 0.00577651988714933, 0.00580074405297637, 0.0058250012807548, 0.00584932649508119, 0.00587367778643966, 0.00589813105762005, 0.00592258432880044, 0.00594711303710938, 0.0059716859832406, 0.00599628267809749, 0.00602098274976015, 0.00604569027200341, 0.00607045786455274, 0.00609527667984366, 0.00612015416845679, 0.00614506658166647, 0.00617005489766598, 0.00619506929069757, 0.00622013444080949, 0.00624524988234043, 0.00627044262364507, 0.00629565212875605, 0.00632093008607626, 0.00634624157100916, 0.00637162104249001, 0.0063970685005188, 0.00642253318801522, 0.00644804816693068, 0.00647362368181348, 0.00649924017488956, 0.00652491766959429, 0.00655065383762121, 0.00657640770077705, 0.00660223746672273, 0.00662811007350683, 0.00665405904874206, 0.00668000755831599, 0.00670605013146996, 0.0067321015521884, 0.00675822887569666, 0.00678441533818841, 0.00681065348908305, 0.00683692516759038, 0.00686325691640377, 0.00688964780420065, 0.00691605592146516, 0.00694252317771316, 0.00696905003860593, 0.00699564535170794, 0.00702226534485817, 0.00704895425587893, 0.00707565946504474, 0.00710244150832295, 0.00712928269058466, 0.00715616624802351, 0.00718309264630079, 0.00721005350351334, 0.00723709026351571, 0.0072641777805984, 0.00729131745174527, 0.00731847248971462, 0.00734571367502213, 0.00737298047170043, 0.00740033155307174, 0.00742769986391068, 0.00745514500886202, 0.00748259807005525, 0.00751013681292534, 0.00753772584721446, 0.00756535725668073, 0.00759303197264671, 0.00762076629325747, 0.00764853367581964, 0.00767638674005866, 0.00770427333191037, 0.00773219438269734, 0.0077601745724678, 0.00778820645064116, 0.00781630538403988, 0.00784443039447069, 0.00787262246012688, 0.00790084153413773, 0.00792912766337395, 0.00795746501535177, 0.00798585265874863, 0.00801426731050014, 0.00804276578128338, 0.00807128194719553, 0.00809989124536514, 0.0081285173073411, 0.00815720297396183, 0.00818594824522734, 0.0082147279754281, 0.00824357476085424, 0.0082724392414093, 0.00830138847231865, 0.00833036284893751, 0.0083594061434269, 0.00838849972933531, 0.00841763615608215, 0.00844680611044168, 0.00847605336457491, 0.00850532483309507, 0.0085346819832921, 0.00856406521052122, 0.00859351642429829, 0.00862297508865595, 0.00865253712981939, 0.00868213176727295, 0.00871176086366177, 0.00874144956469536, 0.00877118110656738, 0.00880096293985844, 0.00883082207292318, 0.00886070635169744, 0.00889063253998756, 0.00892063602805138, 0.00895065627992153, 0.00898077804595232, 0.00901090074330568, 0.00904109980911016, 0.00907132402062416, 0.0091016162186861, 0.00913196802139282, 0.00916237011551857, 0.00919279828667641, 0.00922328606247902, 0.00925384182482958, 0.00928443111479282, 0.00931508094072342, 0.0093457642942667, 0.00937650725245476, 0.00940728280693293, 0.00943816173821688, 0.00946904066950083, 0.00949998758733273, 0.00953096803277731, 0.00956202577799559, 0.0095931077376008, 0.00962425023317337, 0.00965546071529388, 0.00968670379370451, 0.00971799902617931, 0.00974933709949255, 0.00978074315935373, 0.00981216505169868, 0.00984369032084942, 0.00987521465867758, 0.00990680698305368, 0.00993845053017139, 0.00997015368193388, 0.0100019089877605, 0.0100337043404579, 0.0100655443966389, 0.0100974421948195, 0.0101293828338385, 0.0101613933220506, 0.010193444788456, 0.0102255307137966, 0.0102576920762658, 0.0102898702025414, 0.0103221349418163, 0.0103544248268008, 0.0103867826983333, 0.0104191731661558, 0.0104516167193651, 0.0104841096326709, 0.0105166807770729, 0.0105492658913136, 0.0105819134041667, 0.0106146028265357, 0.0106473853811622, 0.0106801586225629, 0.0107130268588662, 0.0107459276914597, 0.0107788639143109, 0.0108118839561939, 0.0108449207618833, 0.0108780283480883, 0.0109111666679382, 0.0109443832188845, 0.0109776249155402, 0.0110109420493245, 0.0110442787408829, 0.011077681556344, 0.0111111253499985, 0.0111446473747492, 0.0111781861633062, 0.0112118031829596, 0.0112454434856772, 0.0112791433930397, 0.0113129047676921, 0.0113467145711184, 0.0113805690780282, 0.0114144729450345, 0.0114484205842018, 0.0114824259653687, 0.0115164928138256, 0.0115505838766694, 0.0115847438573837, 0.0116189364343882, 0.011653215624392, 0.0116875106468797, 0.0117218745872378, 0.0117562552914023, 0.0117907207459211, 0.0118252458050847, 0.0118597960099578, 0.0118943890556693, 0.01192906498909, 0.0119637530297041, 0.0119985248893499, 0.0120333386585116, 0.0120681943371892, 0.0121039412915707, 0.0121405310928822, 0.012177181430161, 0.0122138988226652, 0.0122506860643625, 0.0122875301167369, 0.0123244440183043, 0.0123613998293877, 0.0123984329402447, 0.0124355321750045, 0.0124726658686996, 0.0125098852440715, 0.0125471735373139, 0.0125845028087497, 0.0126219261437654, 0.0126593746244907, 0.012696891091764, 0.0127344680950046, 0.0127721298485994, 0.0128098493441939, 0.012847613543272, 0.0128854364156723, 0.0129233272746205, 0.0129612861201167, 0.0129993297159672, 0.0130373984575272, 0.0130755361169577, 0.0131137408316135, 0.0131519883871078, 0.0131903383880854, 0.0132287396118045, 0.0132671743631363, 0.0133056854829192, 0.0133442562073469, 0.0133829023689032, 0.013421593233943, 0.0134603511542082, 0.0134991854429245, 0.0135380616411567, 0.0135770235210657, 0.0136160189285874, 0.0136550907045603, 0.0136942155659199, 0.0137334140017629, 0.0137726729735732, 0.0138120008632541, 0.0138513697311282, 0.0138908084481955, 0.0139303049072623, 0.0139698619022965, 0.014009521342814, 0.0140492049977183, 0.0140889482572675, 0.014128752052784, 0.0141686145216227, 0.0142085608094931, 0.0142485676333308, 0.0142886275425553, 0.0143287451937795, 0.0143689131364226, 0.0144091751426458, 0.0144494790583849, 0.0144898425787687, 0.0145302759483457, 0.014570758678019, 0.0146113187074661, 0.0146519374102354, 0.014692616648972, 0.0147333545610309, 0.0147741520777345, 0.0148150268942118, 0.0148559426888824, 0.0148969180881977, 0.0149379717186093, 0.0149790849536657, 0.0150202633813024, 0.0150615032762289, 0.0151027860119939, 0.0151441264897585, 0.0151855535805225, 0.0152270393446088, 0.015268593095243, 0.0153101989999413, 0.0153518626466393, 0.0153935793787241, 0.015435378998518, 0.0154772233217955, 0.0155191421508789, 0.0155611289665103, 0.0156031595543027, 0.0156452562659979, 0.0156874153763056, 0.0157296489924192, 0.0157719347625971, 0.0158142857253551, 0.0158566832542419, 0.0158991627395153, 0.0159416943788528, 0.0159842763096094, 0.0160269290208817, 0.0160696543753147, 0.016112431883812, 0.0161552857607603, 0.0161981843411922, 0.0162411406636238, 0.016284154728055, 0.016327265650034, 0.0163704175502062, 0.0164136290550232, 0.0164569076150656, 0.0165002215653658, 0.0165436193346977, 0.0165871120989323, 0.0166306216269732, 0.0166741982102394, 0.0167178437113762, 0.016761539503932, 0.0168053191155195, 0.0168491676449776, 0.0168930441141129, 0.0169370025396347, 0.0169810131192207, 0.0170251000672579, 0.0170692373067141, 0.0171134192496538, 0.0171577017754316, 0.0172020252794027, 0.0172464195638895, 0.0172908529639244, 0.0173353664577007, 0.0173799283802509, 0.017424575984478, 0.0174692831933498, 0.0175140351057053, 0.0175588596612215, 0.0176037289202213, 0.0176486577838659, 0.0176937039941549, 0.0177387613803148, 0.017783910036087, 0.0178290847688913, 0.0178743284195662, 0.0179196391254663, 0.0179650261998177, 0.018010463565588, 0.0180559698492289, 0.0181015189737082, 0.0181471351534128, 0.0181928463280201, 0.0182385817170143, 0.0182843953371048, 0.0183302666991949, 0.0183761902153492, 0.0184221975505352, 0.0184682458639145, 0.0185143649578094, 0.0185605511069298, 0.0186067800968885, 0.0186531115323305, 0.0186994597315788, 0.0187458824366331, 0.0187923759222031, 0.0188389271497726, 0.0188855472952127, 0.0189322177320719, 0.0189789477735758, 0.0190257467329502, 0.0190726034343243, 0.0191195290535688, 0.0191665329039097, 0.0192135758697987, 0.0192606635391712, 0.0193078368902206, 0.019355084747076, 0.0194023586809635, 0.0194497331976891, 0.0194971431046724, 0.0195446163415909, 0.0195921696722507, 0.0196397602558136, 0.0196874160319567, 0.0197351574897766, 0.0197829324752092, 0.0198307745158672, 0.0198787041008472, 0.0199266672134399, 0.0199746992439032, 0.0200228057801723, 0.0200709719210863, 0.0201191976666451, 0.020167475566268, 0.0202158223837614, 0.0202642250806093, 0.0203126799315214, 0.0203612297773361, 0.0204098299145699, 0.020458472892642, 0.0205071903765202, 0.0205559618771076, 0.020604781806469, 0.0206537246704102, 0.0207026805728674, 0.0207516886293888, 0.0208007730543613, 0.0208499263972044, 0.0208991374820471, 0.0209484100341797, 0.0209977477788925, 0.0210471302270889, 0.0210965797305107, 0.0211461242288351, 0.0211956948041916, 0.0212453212589025, 0.021295053884387, 0.0213447995483875, 0.0213946420699358, 0.0214445348829031, 0.0214944761246443, 0.0215444713830948, 0.0215945765376091, 0.0216447152197361, 0.021694902330637, 0.0217451695352793, 0.0217954851686954, 0.021845854818821, 0.0218963399529457, 0.0219468381255865, 0.0219973921775818, 0.0220480393618345, 0.0220987219363451, 0.0221494808793068, 0.0222003180533648, 0.0222511850297451, 0.0223021171987057, 0.0223531220108271, 0.0224041976034641, 0.0224553272128105, 0.022506520152092, 0.0225577726960182, 0.0226090736687183, 0.0226604472845793, 0.0227118954062462, 0.0227633845061064, 0.0228149425238371, 0.0228665769100189, 0.0229182466864586, 0.0229700058698654, 0.0230218097567558, 0.0230736657977104, 0.0231256000697613, 0.0231775809079409, 0.0232296660542488, 0.0232817698270082, 0.0233339536935091, 0.0233861841261387, 0.0234384723007679, 0.0234908480197191, 0.0235432870686054, 0.0235957652330399, 0.0236483085900545, 0.0237009208649397, 0.0237535927444696, 0.023806331679225, 0.0238591395318508, 0.0239119809120893, 0.0239649061113596, 0.0240178778767586, 0.0240709222853184, 0.0241240337491035, 0.0241772066801786, 0.0242304224520922, 0.0242837220430374, 0.0243370831012726, 0.024390485137701, 0.0244439635425806, 0.0244975034147501, 0.0245511010289192, 0.0246047750115395, 0.0246584936976433, 0.0247122682631016, 0.0247661117464304, 0.0248200334608555, 0.0248740129172802, 0.0249280538409948, 0.0249821357429028, 0.0250363126397133, 0.0250905025750399, 0.0251447819173336, 0.0251991525292397, 0.0252535510808229, 0.0253080073744059, 0.0253625307232141, 0.0254171136766672, 0.0254717748612165, 0.0255264863371849, 0.0255812667310238, 0.0256360974162817, 0.0256909932941198, 0.0257459599524736, 0.0258009862154722, 0.0258560553193092, 0.0259112156927586, 0.0259664095938206, 0.0260217003524303, 0.0260770246386528, 0.02613240852952, 0.0261878557503223, 0.0262433849275112, 0.0262989699840546, 0.026354618370533, 0.0264103058725595, 0.0264660622924566, 0.0265218876302242, 0.0265778061002493, 0.0266337413340807, 0.0266897510737181, 0.0267458166927099, 0.0268019456416368, 0.02685815282166, 0.0269144289195538, 0.0269707478582859, 0.0270271170884371, 0.0270835440605879, 0.0271400660276413, 0.0271966364234686, 0.027253270149231, 0.0273099634796381, 0.0273667145520449, 0.027423532679677, 0.0274804029613733, 0.027537340298295, 0.0275943465530872, 0.02765142172575, 0.0277085360139608, 0.0277657303959131, 0.0278229750692844, 0.0278802793473005, 0.0279376413673162, 0.0279950704425573, 0.0280525963753462, 0.028110146522522, 0.0281677637249231, 0.0282254349440336, 0.0282831620424986, 0.0283409841358662, 0.0283988676965237, 0.0284567810595036, 0.0285147819668055, 0.0285728182643652, 0.0286309197545052, 0.0286891236901283, 0.0287473630160093, 0.0288056544959545, 0.0288640186190605, 0.0289224348962307, 0.0289809200912714, 0.0290394760668278, 0.0290980767458677, 0.0291567500680685, 0.0292154792696238, 0.0292742718011141, 0.0293331313878298, 0.0293920412659645, 0.0294510256499052, 0.0295100640505552, 0.0295691788196564, 0.0296283364295959, 0.0296875592321157, 0.0297468435019255, 0.0298062060028315, 0.0298656243830919, 0.0299250949174166, 0.0299846269190311, 0.0300442166626453, 0.0301038641482592, 0.0301636178046465, 0.0302234012633562, 0.0302832312881947, 0.0303431358188391, 0.0304031055420637, 0.0304631385952234, 0.0305232387036085, 0.030583381652832, 0.030643617734313, 0.0307038966566324, 0.0307642184197903, 0.0308246333152056, 0.0308850966393948, 0.0309456065297127, 0.0310062058269978, 0.0310668516904116, 0.0311275608837605, 0.0311883501708508, 0.0312491655349731, 0.0313100479543209, 0.0313710309565067, 0.0314320661127567, 0.0314931347966194, 0.0315542742609978, 0.0316154733300209, 0.0316767320036888, 0.0317380838096142, 0.0317994840443134, 0.031860925257206, 0.0319224260747433, 0.0319840088486671, 0.0320456437766552, 0.0321073532104492, 0.0321691259741783, 0.0322309322655201, 0.032292801886797, 0.0323547795414925, 0.0324167758226395, 0.0324788466095924, 0.0325409770011902, 0.0326031781733036, 0.0326654277741909, 0.0327277518808842, 0.0327901169657707, 0.032852578908205, 0.0329150855541229, 0.0329776555299759, 0.0330402664840221, 0.0331029482185841, 0.0331657007336617, 0.033228512853384, 0.033291406929493, 0.0333543457090855, 0.0334173440933228, 0.0334804132580757, 0.0335435308516026, 0.0336067043244839, 0.0336699485778809, 0.0337332710623741, 0.0337966419756413, 0.0338600687682629, 0.0339235402643681, 0.0339870899915695, 0.0340507291257381, 0.0341144129633904, 0.034178152680397, 0.0342419482767582, 0.034305814653635, 0.0343697369098663, 0.0344337224960327, 0.0344977751374245, 0.034561887383461, 0.0346260666847229, 0.0346903055906296, 0.0347545966506004, 0.0348189398646355, 0.0348833799362183, 0.0349478498101234, 0.0350124016404152, 0.035077016800642, 0.0351416729390621, 0.035206388682127, 0.035271193832159, 0.0353360623121262, 0.0354009568691254, 0.035465944558382, 0.035530973225832, 0.0355960689485073, 0.0356612652540207, 0.0357264801859856, 0.0357917472720146, 0.0358571112155914, 0.0359225049614906, 0.0359879843890667, 0.0360535159707069, 0.0361191295087337, 0.0361847728490829, 0.0362504906952381, 0.0363162867724895, 0.0363821052014828, 0.0364480167627335, 0.0365139842033386, 0.0365800261497498, 0.0366461165249348, 0.0367122702300549, 0.0367784798145294, 0.0368447601795197, 0.0369110815227032, 0.0369774959981441, 0.0370439626276493, 0.0371104888617992, 0.0371770560741425, 0.0372437089681625, 0.0373104028403759, 0.0373772010207176, 0.037444032728672, 0.0375109165906906, 0.0375778637826443, 0.0376448780298233, 0.0377119742333889, 0.037779126316309, 0.0378463268280029, 0.0379135794937611, 0.0379808954894543, 0.0380483046174049, 0.0381180755794048, 0.0381901971995831, 0.0382623374462128, 0.0383345521986485, 0.0384067967534065, 0.0384790934622288, 0.0385514348745346, 0.0386238396167755, 0.0386962890625, 0.0387687832117081, 0.0388413183391094, 0.038913905620575, 0.038986548781395, 0.039059229195118, 0.0391319766640663, 0.0392047539353371, 0.0392775870859623, 0.0393504723906517, 0.0394233949482441, 0.0394963659346104, 0.0395694002509117, 0.0396424829959869, 0.0397156067192554, 0.0397887788712978, 0.0398620069026947, 0.039935264736414, 0.0400085933506489, 0.0400819629430771, 0.0401553809642792, 0.0402288511395454, 0.0403023548424244, 0.0403759181499481, 0.0404495149850845, 0.0405231900513172, 0.0405968874692917, 0.0406706482172012, 0.0407444462180138, 0.0408182963728905, 0.0408921875059605, 0.040966160595417, 0.0410401523113251, 0.0411141999065876, 0.0411882922053337, 0.0412624217569828, 0.0413366071879864, 0.0414108783006668, 0.0414851643145084, 0.0415594950318336, 0.0416338741779327, 0.0417083278298378, 0.0417827889323235, 0.0418573319911957, 0.0419319234788418, 0.0420065447688103, 0.0420812256634235, 0.0421559512615204, 0.0422307141125202, 0.0423055402934551, 0.0423804223537445, 0.0424553379416466, 0.0425303056836128, 0.0426053293049335, 0.0426803790032864, 0.0427554845809937, 0.0428306721150875, 0.0429058894515038, 0.0429811328649521, 0.0430564470589161, 0.0431318059563637, 0.0432072058320045, 0.0432826764881611, 0.0433581694960594, 0.043433740735054, 0.0435093343257904, 0.0435849763453007, 0.043660681694746, 0.0437364019453526, 0.0438122302293777, 0.0438880696892738, 0.0439639687538147, 0.0440398901700974, 0.0441158749163151, 0.044191911816597, 0.0442680157721043, 0.0443441495299339, 0.0444203168153763, 0.0444965623319149, 0.0445728302001953, 0.0446491576731205, 0.0447255447506905, 0.0448019579052925, 0.0448784418404102, 0.0449549593031406, 0.0450315289199352, 0.0451081395149231, 0.0451848171651363, 0.0452615395188332, 0.0453383177518845, 0.0454151183366776, 0.0454919710755348, 0.0455688834190369, 0.0456458441913128, 0.0457228608429432, 0.0457999147474766, 0.0458770245313644, 0.0459541641175747, 0.0460313707590103, 0.0461086183786392, 0.0461859293282032, 0.0462632700800896, 0.0463406778872013, 0.0464181154966354, 0.0464956052601337, 0.0465731471776962, 0.0466507486999035, 0.046728391200304, 0.0468060672283173, 0.0468838065862656, 0.0469615831971169, 0.0470394231379032, 0.0471173115074635, 0.0471952520310879, 0.0472732298076153, 0.0473512597382069, 0.047429334372282, 0.0475074537098408, 0.0475856252014637, 0.0476638525724411, 0.047742135822773, 0.0478204451501369, 0.0478987954556942, 0.0479772128164768, 0.0480556786060333, 0.0481342114508152, 0.0482127703726292, 0.0482913814485073, 0.048370037227869, 0.048448733985424, 0.0485274866223335, 0.0486062914133072, 0.0486851558089256, 0.0487640649080276, 0.0488430112600327, 0.0489220023155212, 0.0490010492503643, 0.0490801408886909, 0.0491592884063721, 0.0492384880781174, 0.049317728728056, 0.0493970029056072, 0.0494763441383839, 0.0495557300746441, 0.0496351830661297, 0.0497146621346474, 0.0497941933572292, 0.0498737767338753, 0.0499533973634243, 0.0500330775976181, 0.0501128137111664, 0.0501925908029079, 0.0502724200487137, 0.0503522865474224, 0.0504322089254856, 0.0505121648311615, 0.050592202693224, 0.0506722591817379, 0.0507523715496063, 0.0508325323462486, 0.0509127601981163, 0.0509930141270161, 0.0510733239352703, 0.0511537045240402, 0.0512341037392616, 0.0513145588338375, 0.0513950511813164, 0.0514756068587303, 0.0515562035143375, 0.0516368597745895, 0.0517175570130348, 0.0517982952296734, 0.0518791116774082, 0.0519599430263042, 0.0520408228039742, 0.0521217621862888, 0.0522027723491192, 0.0522838085889816, 0.052364893257618, 0.0524460226297379, 0.0525272004306316, 0.0526084341108799, 0.0526897273957729, 0.0527710467576981, 0.0528524331748486, 0.0529338456690311, 0.0530153252184391, 0.0530968494713306, 0.0531784258782864, 0.0532600544393063, 0.0533417128026485, 0.0534234270453453, 0.0535052046179771, 0.0535870045423508, 0.0536688789725304, 0.0537508055567741, 0.0538327544927597, 0.0539147555828094, 0.0539968125522137, 0.0540789104998112, 0.054161075502634, 0.0542432814836502, 0.0543255247175694, 0.0544078312814236, 0.0544901639223099, 0.0545725673437119, 0.054655022919178, 0.0547375082969666, 0.0548200719058514, 0.0549026541411877, 0.0549852959811687, 0.0550679862499237, 0.0551507137715816, 0.0552335232496262, 0.0553163588047028, 0.0553992353379726, 0.0554821603000164, 0.0555651374161243, 0.0556481629610062, 0.0557312369346619, 0.0558143779635429, 0.0558975413441658, 0.0559807680547237, 0.0560640394687653, 0.0561473555862904, 0.056230716407299, 0.0563141517341137, 0.0563976019620895, 0.056481134146452, 0.0565646849572659, 0.0566482879221439, 0.0567319355905056, 0.0568156726658344, 0.0568994246423244, 0.0569832324981689, 0.0570670776069164, 0.0571509748697281, 0.0572349242866039, 0.0573189333081245, 0.0574029870331287, 0.0574870705604553, 0.057571217417717, 0.0576554127037525, 0.0577396526932716, 0.0578239485621452, 0.0579082779586315, 0.0579926744103432, 0.0580771192908287, 0.0581615827977657, 0.058246124535799, 0.0583307035267353, 0.0584153458476067, 0.0585000216960907, 0.0585847496986389, 0.0586695224046707, 0.0587543360888958, 0.0588392280042171, 0.0589241497218609, 0.0590091273188591, 0.0590941496193409, 0.0591792091727257, 0.0592643246054649, 0.0593494847416878, 0.0594347082078457, 0.0595199652016163, 0.0596052780747414, 0.0596906319260597, 0.0597760416567326, 0.0598614849150181, 0.0599470101296902, 0.0600325614213943, 0.0601181574165821, 0.060203805565834, 0.0602895021438599, 0.0603752508759499, 0.0604610443115234, 0.0605469085276127, 0.0606327876448631, 0.060718722641468, 0.060804720968008, 0.060890756547451, 0.060976829379797, 0.0610629916191101, 0.0611491650342941, 0.0612353943288326, 0.0613216795027256, 0.0614080093801022, 0.0614943727850914, 0.0615808181464672, 0.0616673044860363, 0.0617538094520569, 0.0618403889238834, 0.0619269981980324, 0.0620136745274067, 0.0621004104614258, 0.0621871575713158, 0.0622739791870117, 0.0623608343303204, 0.0624477602541447, 0.0625347122550011, 0.0626217275857925, 0.062708780169487, 0.0627958849072456, 0.0628830417990685, 0.062970258295536, 0.063057504594326, 0.0631448030471802, 0.0632321685552597, 0.0633195713162422, 0.0634070113301277, 0.0634944885969162, 0.0635820403695107, 0.0636696293950081, 0.0637572780251503, 0.0638449564576149, 0.0639327093958855, 0.0640204921364784, 0.0641083270311356, 0.0641962066292763, 0.0642841309309006, 0.0643721222877502, 0.0644601508975029, 0.0645482316613197, 0.0646363571286201, 0.0647245198488235, 0.0648127421736717, 0.0649010390043259, 0.0649893432855606, 0.0650777220726013, 0.0651661306619644, 0.0652545914053917, 0.0653431043028831, 0.0654316768050194, 0.0655202940106392, 0.0656089335680008, 0.0656976625323296, 0.0657864138484001, 0.0658752024173737, 0.0659640803933144, 0.0660529658198357, 0.0661419332027435, 0.0662309229373932, 0.0663199797272682, 0.066409058868885, 0.066498227417469, 0.0665874183177948, 0.0666766613721848, 0.0667659342288971, 0.066855289041996, 0.0669446736574173, 0.0670341029763222, 0.0671235918998718, 0.0672131255269051, 0.0673027336597443, 0.0673923566937447, 0.0674820393323898, 0.067571759223938, 0.0676615312695503, 0.0677513778209686, 0.0678412392735481, 0.067931167781353, 0.0680211260914803, 0.0681111514568329, 0.0682012140750885, 0.0682913511991501, 0.0683815032243729, 0.0684717074036598, 0.0685619711875916, 0.0686522796750069, 0.0687426403164864, 0.0688330680131912, 0.0689235180616379, 0.0690140277147293, 0.0691045746207237, 0.0691951736807823, 0.0692858174443245, 0.0693765357136726, 0.0694672837853432, 0.0695580765604973, 0.069648914039135, 0.0697397962212563, 0.0698307454586029, 0.0699217468500137, 0.0700127929449081, 0.0701038688421249, 0.0701950043439865, 0.0702861845493317, 0.070377416908741, 0.0704686939716339, 0.0705600455403328, 0.0706514194607735, 0.0707428455352783, 0.0708343163132668, 0.0709258466959, 0.0710174143314362, 0.0711090415716171, 0.0712007135152817, 0.0712924301624298, 0.0713841915130615, 0.0714759901165962, 0.0715678706765175, 0.0716597959399223, 0.0717517659068108, 0.0718437805771828, 0.0719358325004578, 0.0720279440283775, 0.0721201002597809, 0.0722122862935066, 0.0723045617341995, 0.0723968669772148, 0.0724892020225525, 0.0725815966725349, 0.0726740509271622, 0.0727665424346924, 0.072859100997448, 0.0729516819119453, 0.0730443224310875, 0.0731370151042938, 0.0732297450304031, 0.0733225420117378, 0.0734153762459755, 0.0735082477331161, 0.0736011862754822, 0.0736941769719124, 0.0737871900200844, 0.0738802775740623, 0.0739734023809433, 0.0740665793418884, 0.0741598084568977, 0.07425307482481, 0.0743463933467865, 0.0744397714734077, 0.0745331794023514, 0.074626661837101, 0.074720174074173, 0.0748137310147285, 0.0749073401093483, 0.0750010088086128, 0.0750947222113609, 0.075188472867012, 0.0752822756767273, 0.0753761306405067, 0.0754700377583504, 0.0755639970302582, 0.075657993555069, 0.0757520422339439, 0.0758461430668831, 0.0759402886033058, 0.0760344788432121, 0.0761287286877632, 0.0762230306863785, 0.0763173773884773, 0.0764117538928986, 0.0765061900019646, 0.0766006782650948, 0.0766952112317085, 0.0767897963523865, 0.0768844336271286, 0.0769791007041931, 0.0770738422870636, 0.0771686136722565, 0.0772634446620941, 0.0773583203554153, 0.0774532482028008, 0.0775482133030891, 0.0776432380080223, 0.0777383148670197, 0.07783342897892, 0.0779285803437233, 0.0780238062143326, 0.0781190618872643, 0.0782143697142601, 0.0783097445964813, 0.0784051418304443, 0.0785005912184715, 0.0785961151123047, 0.0786916613578796, 0.0787872597575188, 0.0788829177618027, 0.0789786204695702, 0.0790743678808212, 0.0791701599955559, 0.0792660042643547, 0.0793619006872177, 0.0794578641653061, 0.0795538425445557, 0.0796498730778694, 0.0797459632158279, 0.0798420906066895, 0.0799382776021957, 0.0800345167517662, 0.0801308080554008, 0.0802289247512817, 0.0803288966417313, 0.0804288759827614, 0.0805288478732109, 0.080628827214241, 0.0807288214564323, 0.0808288007974625, 0.0809287875890732, 0.0810287669301033, 0.0811287611722946, 0.0812287628650665, 0.0813287496566772, 0.0814287438988686, 0.0815287381410599, 0.0816287323832512, 0.0817287415266037, 0.0818287506699562, 0.0819287449121475, 0.0820287615060806, 0.0821287631988525, 0.0822287872433662, 0.0823287963867188, 0.0824288204312325, 0.0825288444757462, 0.0826288759708405, 0.0827289074659348, 0.0828289240598679, 0.0829289481043816, 0.0830289795994759, 0.0831290259957314, 0.0832290574908257, 0.08332908898592, 0.083429142832756, 0.0835291817784309, 0.0836292281746864, 0.0837292745709419, 0.083829328417778, 0.0839293897151947, 0.0840294361114502, 0.0841294974088669, 0.084229551255703, 0.0843296200037003, 0.0844296887516975, 0.0845297500491142, 0.0846298262476921, 0.0847298949956894, 0.0848299562931061, 0.0849300473928452, 0.085030123591423, 0.0851301997900009, 0.0852302834391594, 0.0853303745388985, 0.0854304507374763, 0.0855305641889572, 0.0856306478381157, 0.0857307463884354, 0.0858308374881744, 0.0859309434890747, 0.086031049489975, 0.0861311480402946, 0.0862312614917755, 0.0863313600420952, 0.0864314883947372, 0.0865315943956375, 0.0866317078471184, 0.0867318212985992, 0.0868319422006607, 0.0869320631027222, 0.0870321840047836, 0.0871323049068451, 0.0872324407100677, 0.087332583963871, 0.0874327197670937, 0.0875328481197357, 0.0876329839229584, 0.0877331122756004, 0.0878332629799843, 0.0879334062337875, 0.0880335569381714, 0.0881337076425552, 0.0882338583469391, 0.0883340165019035, 0.0884341672062874, 0.0885343253612518, 0.0886344909667969, 0.0887346565723419, 0.088834822177887, 0.088934987783432, 0.0890351533889771, 0.0891353264451027, 0.0892354995012283, 0.0893356800079346, 0.0894358605146408, 0.0895360335707664, 0.0896362215280533, 0.0897364094853401, 0.0898366123437881, 0.0899367853999138, 0.0900369808077812, 0.0901371985673904, 0.0902373865246773, 0.0903375893831253, 0.0904377996921539, 0.090538002550602, 0.0906382203102112, 0.0907384157180786, 0.0908386334776878, 0.0909388437867165, 0.0910390615463257, 0.0911392867565155, 0.0912395119667053, 0.0913397222757339, 0.0914399474859238, 0.0915401726961136, 0.091640405356884, 0.0917406380176544, 0.0918408706784248, 0.0919411107897758, 0.0920413509011269, 0.0921415835618973, 0.0922418460249901, 0.0923420786857605, 0.0924423336982727, 0.0925425812602043, 0.0926428362727165, 0.0927430838346481, 0.0928433462977409, 0.0929436087608337, 0.0930438786745071, 0.0931441485881805, 0.0932444036006927, 0.0933446735143661, 0.0934449434280396, 0.093545213341713, 0.0936454981565475, 0.0937457680702209, 0.0938460603356361, 0.0939463302493095, 0.0940466225147247, 0.0941469073295593, 0.0942471995949745, 0.0943474844098091, 0.0944477841258049, 0.0945480838418007, 0.0946483686566353, 0.0947486758232117, 0.0948489829897881, 0.0949492901563644, 0.0950495973229408, 0.095149926841259, 0.0952502340078354, 0.0953505486249924, 0.0954508632421494, 0.0955511927604675, 0.0956514999270439, 0.0957518443465233, 0.0958521664142609, 0.095952495932579, 0.0960528180003166, 0.096153162419796, 0.0962534993886948, 0.0963538289070129, 0.0964541658759117, 0.0965545102953911, 0.096654862165451, 0.0967552065849304, 0.0968555510044098, 0.0969559028744698, 0.0970562621951103, 0.0971566215157509, 0.0972569808363914, 0.097357340157032, 0.097457692027092, 0.0975580736994743, 0.0976584404706955, 0.0977588072419167, 0.0978591740131378, 0.0979595556855202, 0.0980599299073219, 0.0981603115797043, 0.0982606932520866, 0.098361074924469, 0.0984614640474319, 0.0985618606209755, 0.0986622422933578, 0.0987626388669014, 0.0988630428910255, 0.0989634394645691, 0.0990638360381126, 0.0991642400622368, 0.0992646366357803, 0.0993650555610657, 0.0994654521346092, 0.0995658710598946, 0.0996662899851799, 0.0997667089104652, 0.0998671278357506, 0.0999675393104553, 0.100067958235741, 0.100168399512768, 0.100268825888634, 0.1003692522645, 0.100469678640366, 0.100570105016232, 0.10067056119442, 0.100770995020866, 0.100871428847313, 0.100971885025501, 0.101072318851948, 0.101172775030136, 0.101273231208324, 0.101373687386513, 0.10147413611412, 0.101574592292309, 0.101675048470497, 0.101775519549847, 0.101875975728035, 0.101976446807384, 0.102076925337315, 0.102177396416664, 0.102277867496014, 0.102378338575363, 0.102478817105293, 0.102579303085804, 0.102679781615734, 0.102780267596245, 0.102880761027336, 0.102981232106686, 0.103081732988358, 0.103182226419449, 0.103282734751701, 0.103383228182793, 0.103483729064465, 0.103584237396717, 0.10368474572897, 0.103785254061222, 0.103885769844055, 0.103986278176308, 0.10408678650856, 0.104187302291393, 0.104287825524807, 0.104388348758221, 0.104488879442215, 0.104589402675629, 0.104689933359623, 0.104790456593037, 0.104890994727612, 0.104991532862186, 0.105092070996761, 0.105192601680756, 0.105293139815331, 0.105393700301647, 0.105494245886803, 0.105594791471958, 0.105695344507694, 0.105795912444592, 0.105896458029747, 0.105997025966644, 0.106097586452961, 0.106198146939278, 0.106298707425594, 0.106399275362492, 0.10649985820055, 0.106600411236286, 0.106700994074345, 0.106801576912403, 0.1069021448493, 0.107002727687359, 0.107103310525417, 0.107203908264637, 0.107304498553276, 0.107405096292496, 0.107505679130554, 0.107606276869774, 0.107706867158413, 0.107807472348213, 0.107908077538013, 0.108008682727814, 0.108109287917614, 0.108209893107414, 0.108310505747795, 0.108411125838757, 0.108511738479137, 0.108612366020679, 0.10871297866106, 0.108813598752022, 0.108914233744144, 0.109014861285686, 0.109115496277809, 0.109216116368771, 0.109316758811474, 0.109417393803596, 0.109518028795719, 0.109618671238422, 0.109719321131706, 0.109819963574409, 0.109920606017113, 0.110021263360977, 0.110121920704842, 0.110222578048706, 0.11032323539257, 0.110423892736435, 0.110524550080299, 0.110625222325325, 0.110725879669189, 0.110826559364796, 0.110927231609821, 0.111027903854847, 0.111128583550453, 0.111229255795479, 0.111329942941666, 0.111430607736111, 0.111531302332878, 0.111631996929646, 0.111732684075832, 0.1118333786726, 0.111934058368206, 0.112034775316715, 0.112135469913483, 0.112236171960831, 0.112336866557598, 0.112437576055527, 0.112538278102875, 0.112638987600803, 0.112739704549313, 0.112840421497822, 0.11294113099575, 0.11304185539484, 0.113142587244511, 0.113243319094181, 0.11334403604269, 0.11344476044178, 0.113545499742031, 0.113646224141121, 0.113746970891953, 0.113847702741623, 0.113948442041874, 0.114049181342125, 0.114149935543537, 0.114250682294369, 0.1143514290452, 0.114452183246613, 0.114552929997444, 0.114653691649437, 0.114754445850849, 0.114855214953423, 0.114955984055996, 0.115056730806828, 0.115157514810562, 0.115258276462555, 0.115359053015709, 0.115459822118282, 0.115560598671436, 0.115661390125751, 0.115762166678905, 0.115862965583801, 0.115963749587536, 0.11606452614069, 0.116165325045586, 0.11626610904932, 0.116366915404797, 0.116467706859112, 0.116568505764008, 0.116669304668903, 0.11677011102438, 0.116870924830437, 0.116971738636494, 0.11707254499197, 0.117173351347446, 0.117274180054665, 0.117374993860722, 0.117475807666779, 0.117576636373997, 0.117677465081215, 0.117778286337852, 0.117879115045071, 0.117979951202869, 0.118080787360668, 0.118181630969048, 0.118282459676266, 0.118383310735226, 0.118484154343605, 0.118584997951984, 0.118685849010944, 0.118786700069904, 0.118887558579445, 0.118988409638405, 0.119089260697365, 0.119190119206905, 0.119290985167027, 0.119391843676567, 0.119492717087269, 0.119593590497971, 0.119694449007511, 0.119795329868793, 0.119896210730076, 0.119997084140778, 0.12009796500206, 0.120198853313923, 0.120299741625786, 0.120400615036488, 0.120501510798931, 0.120602406561375, 0.120703309774399, 0.120804205536842, 0.120905101299286, 0.121005997061729, 0.121106900274754, 0.121207810938358, 0.121308721601963, 0.121409624814987, 0.121510542929173, 0.121611468493938, 0.121712379157543, 0.121813297271729, 0.121914207935333, 0.122015133500099, 0.122116066515446, 0.122216992080212, 0.122317925095558, 0.122418858110905, 0.122519791126251, 0.122620739042759, 0.122721672058105, 0.122822612524033, 0.12292356044054, 0.123024515807629, 0.123125463724136, 0.123226419091225, 0.123327367007732, 0.123428322374821, 0.12352928519249, 0.123630240559578, 0.123731210827827, 0.123832173645496, 0.123933136463165, 0.124034106731415, 0.124135076999664, 0.124236054718494, 0.124337032437325, 0.124438010156155, 0.124538995325565, 0.124639980494976, 0.124740973114967, 0.124841950833797, 0.124942950904369, 0.125043928623199, 0.125144928693771, 0.125245928764343, 0.125346928834915, 0.125447943806648, 0.12554894387722, 0.125649958848953, 0.125750958919525, 0.125851973891258, 0.12595297396183, 0.126054003834724, 0.126155018806458, 0.126256033778191, 0.126357063651085, 0.126458093523979, 0.126559108495712, 0.126660138368607, 0.126761183142662, 0.126862213015556, 0.126963257789612, 0.127064302563667, 0.127165332436562, 0.127266377210617, 0.127367421984673, 0.127468466758728, 0.127569526433945, 0.127670571208, 0.127771630883217, 0.127872690558434, 0.12797375023365, 0.128074809908867, 0.128175884485245, 0.128276944160461, 0.128378018736839, 0.128479093313217, 0.128580152988434, 0.128681242465973, 0.128782317042351, 0.128883391618729, 0.128984481096268, 0.129085555672646, 0.129186645150185, 0.129287734627724, 0.129388839006424, 0.129489913582802, 0.129591017961502, 0.129692122340202, 0.129793211817741, 0.129894331097603, 0.129995420575142, 0.130096539855003, 0.130197644233704, 0.130298763513565, 0.130399882793427, 0.130500555038452, 0.130600720643997, 0.130700841546059, 0.130800887942314, 0.130900889635086, 0.131000846624374, 0.131100744009018, 0.131200566887856, 0.131300359964371, 0.13140007853508, 0.131499767303467, 0.131599396467209, 0.131698936223984, 0.131798461079597, 0.131897911429405, 0.131997302174568, 0.132096648216248, 0.132195949554443, 0.132295191287994, 0.132394358515739, 0.132493481040001, 0.132592558860779, 0.132691577076912, 0.1327905356884, 0.132889449596405, 0.132988288998604, 0.133087083697319, 0.133185818791389, 0.133284509181976, 0.133383139967918, 0.133481711149216, 0.133580237627029, 0.133678704500198, 0.133777111768723, 0.133875459432602, 0.133973762392998, 0.13407202064991, 0.134170219302177, 0.134268343448639, 0.134366422891617, 0.134464457631111, 0.134562417864799, 0.134660333395004, 0.134758204221725, 0.134856015443802, 0.134953767061234, 0.13505145907402, 0.135149091482162, 0.135246694087982, 0.135344222187996, 0.135441705584526, 0.13553911447525, 0.135636478662491, 0.135733813047409, 0.13583105802536, 0.135928258299828, 0.136025413870811, 0.136122494935989, 0.136219546198845, 0.136316522955894, 0.136413440108299, 0.13651031255722, 0.136607140302658, 0.13670389354229, 0.136800616979599, 0.136897251009941, 0.136993855237961, 0.137090399861336, 0.137186884880066, 0.137283325195312, 0.137379705905914, 0.137476027011871, 0.137572303414345, 0.137668520212173, 0.137764662504196, 0.137860774993896, 0.137956827878952, 0.138052806258202, 0.13814876973629, 0.138244643807411, 0.138340473175049, 0.138436242938042, 0.138531967997551, 0.138627633452415, 0.138723239302635, 0.13881878554821, 0.138914287090302, 0.139009743928909, 0.139105141162872, 0.139200448989868, 0.139295741915703, 0.139390960335732, 0.139486134052277, 0.139581248164177, 0.139676317572594, 0.139771327376366, 0.139866277575493, 0.139961168169975, 0.140055999159813, 0.140150785446167, 0.140245527029037, 0.140340209007263, 0.140434816479683, 0.140529379248619, 0.140623897314072, 0.140718355774879, 0.140812754631042, 0.140907093882561, 0.141001388430595, 0.141095623373985, 0.14118979871273, 0.141283929347992, 0.141378000378609, 0.141472026705742, 0.14156599342823, 0.141659885644913, 0.141753748059273, 0.141847535967827, 0.141941294074059, 0.142034977674484, 0.142128601670265, 0.142222180962563, 0.142315700650215, 0.142409175634384, 0.142502576112747, 0.142595946788788, 0.142689242959023, 0.142782494425774, 0.14287568628788, 0.142968818545341, 0.143061906099319, 0.143154934048653, 0.143247917294502, 0.143340826034546, 0.143433690071106, 0.143526494503021, 0.143619254231453, 0.14371195435524, 0.143804594874382, 0.143897190690041, 0.143989711999893, 0.144082188606262, 0.144174620509148, 0.144266992807388, 0.144359305500984, 0.144451558589935, 0.144543752074242, 0.144635915756226, 0.144728004932404, 0.144820049405098, 0.144912034273148, 0.145003959536552, 0.145095840096474, 0.145187646150589, 0.145279422402382, 0.14537113904953, 0.145462796092033, 0.145554393529892, 0.145645931363106, 0.145737424492836, 0.14582884311676, 0.145920231938362, 0.146011561155319, 0.146102830767632, 0.14619405567646, 0.146285206079483, 0.146376311779022, 0.146467372775078, 0.146558359265327, 0.146649301052094, 0.146740183234215, 0.146831020712852, 0.146921798586845, 0.147012516856194, 0.147103190422058, 0.147193789482117, 0.147284358739853, 0.147374853491783, 0.14746530354023, 0.147555693984032, 0.147646009922028, 0.147736310958862, 0.14782652258873, 0.147916704416275, 0.148006826639175, 0.148096889257431, 0.148186892271042, 0.148276850581169, 0.148366749286652, 0.148456588387489, 0.148546382784843, 0.148636102676392, 0.148725792765617, 0.148815408349037, 0.148904979228973, 0.148994475603104, 0.149083942174911, 0.149173349142075, 0.149262696504593, 0.149351999163628, 0.149441227316856, 0.149530425667763, 0.149619534611702, 0.149708598852158, 0.149797633290291, 0.149886593222618, 0.149975508451462, 0.1500643491745, 0.150153145194054, 0.150241911411285, 0.15033058822155, 0.150419220328331, 0.150507792830467, 0.15059632062912, 0.150684788823128, 0.150773197412491, 0.150861576199532, 0.150949880480766, 0.151038125157356, 0.151126310229301, 0.151214450597763, 0.151302546262741, 0.151390567421913, 0.15147852897644, 0.151566460728645, 0.151654332876205, 0.15174213051796, 0.151829898357391, 0.151917606592178, 0.152005225419998, 0.152092829346657, 0.152180358767509, 0.152267843484879, 0.152355268597603, 0.152442649006844, 0.152529954910278, 0.152617216110229, 0.152704432606697, 0.152791574597359, 0.152878671884537, 0.152965724468231, 0.15305270254612, 0.153139635920525, 0.153226494789124, 0.1533133238554, 0.153400093317032, 0.153486803174019, 0.153573453426361, 0.15366005897522, 0.153746604919434, 0.153833091259003, 0.153919532895088, 0.154005914926529, 0.154092252254486, 0.154178500175476, 0.154264733195305, 0.154350891709328, 0.154436990618706, 0.154523059725761, 0.154609054327011, 0.154694989323616, 0.154780864715576, 0.154866710305214, 0.154952496290207, 0.155038237571716, 0.155123889446259, 0.155209496617317, 0.155295059084892, 0.155380547046661, 0.155466020107269, 0.15555140376091, 0.155636742711067, 0.15572202205658, 0.155807256698608, 0.155892416834831, 0.155977547168732, 0.156062617897987, 0.156147599220276, 0.156232565641403, 0.156317457556725, 0.156402319669724, 0.156487107276917, 0.156571850180626, 0.156656518578529, 0.15674115717411, 0.156825721263885, 0.156910225749016, 0.156994700431824, 0.157079085707664, 0.157163426280022, 0.157247722148895, 0.157331988215446, 0.157416149973869, 0.15750028192997, 0.157584354281425, 0.157668381929398, 0.157752335071564, 0.157836243510246, 0.157920107245445, 0.158003911375999, 0.15808767080307, 0.158171340823174, 0.158254966139793, 0.158338561654091, 0.158422082662582, 0.158505544066429, 0.158588960766792, 0.158672347664833, 0.158755645155907, 0.158838897943497, 0.158922091126442, 0.159005224704742, 0.159088313579559, 0.15917132794857, 0.159254342317581, 0.159337252378464, 0.159420117735863, 0.159502923488617, 0.159585684537888, 0.159668385982513, 0.159751027822495, 0.159833624958992, 0.159916162490845, 0.159998640418053, 0.160081073641777, 0.160163417458534, 0.160245761275291, 0.160328015685081, 0.160410225391388, 0.160492390394211, 0.160574480891228, 0.1606565117836, 0.160738483071327, 0.160820439457893, 0.160902306437492, 0.160984143614769, 0.16106590628624, 0.161147624254227, 0.16122929751873, 0.161310866475105, 0.16139243543148, 0.161473914980888, 0.161555364727974, 0.161636739969254, 0.16171807050705, 0.161799341440201, 0.16188058257103, 0.161961734294891, 0.162042826414108, 0.162123903632164, 0.162204891443253, 0.162285819649696, 0.162366718053818, 0.162447556853294, 0.162528336048126, 0.162609055638313, 0.162689715623856, 0.162770345807076, 0.162850901484489, 0.16293141245842, 0.163011878728867, 0.163092240691185, 0.163172602653503, 0.163252890110016, 0.163333103060722, 0.163413286209106, 0.163493409752846, 0.16357347369194, 0.16365347802639, 0.163733452558517, 0.163813337683678, 0.163893178105354, 0.163972973823547, 0.164052709937096, 0.16413240134716, 0.164212003350258, 0.164291575551033, 0.164371088147163, 0.164450570940971, 0.164529979228973, 0.164609313011169, 0.164688631892204, 0.164767861366272, 0.164847046136856, 0.164926156401634, 0.165005251765251, 0.165084272623062, 0.165163233876228, 0.165242165327072, 0.16532102227211, 0.165399834513664, 0.165478557348251, 0.165557250380516, 0.165635883808136, 0.165714472532272, 0.165793001651764, 0.165871471166611, 0.165949895977974, 0.16602823138237, 0.166106551885605, 0.166184812784195, 0.166263028979301, 0.166341170668602, 0.166419237852097, 0.166497275233269, 0.166575253009796, 0.166653171181679, 0.166731044650078, 0.166808858513832, 0.166886612772942, 0.166964307427406, 0.167041972279549, 0.167119547724724, 0.167197093367577, 0.167274564504623, 0.167352020740509, 0.167429402470589, 0.167506709694862, 0.167583957314491, 0.167661175131798, 0.16773833334446, 0.167815417051315, 0.167892470955849, 0.167969465255737, 0.16804638504982, 0.16812327504158, 0.168200090527534, 0.168276876211166, 0.168353587388992, 0.168430253863335, 0.16850683093071, 0.168583407998085, 0.168659910559654, 0.168736323714256, 0.168812707066536, 0.168889060616493, 0.168965339660645, 0.169041559100151, 0.169117704033852, 0.169193834066391, 0.169269889593124, 0.169345885515213, 0.169421836733818, 0.169497713446617, 0.169573545455933, 0.169649332761765, 0.169725075364113, 0.169800713658333, 0.169876337051392, 0.169951915740967, 0.170027405023575, 0.170102879405022, 0.17017824947834, 0.170253604650497, 0.17032890021801, 0.170404106378555, 0.170479297637939, 0.170554414391518, 0.170629471540451, 0.170704498887062, 0.170779451727867, 0.170854359865189, 0.170929193496704, 0.171003997325897, 0.171078726649284, 0.171153426170349, 0.171228036284447, 0.171302616596222, 0.171377122402191, 0.171451598405838, 0.171525999903679, 0.171600356698036, 0.17167466878891, 0.171748891472816, 0.171823069453239, 0.171897202730179, 0.171971306204796, 0.172045320272446, 0.172119289636612, 0.172193214297295, 0.172267064452171, 0.172340869903564, 0.172414615750313, 0.172488301992416, 0.172561943531036, 0.172635540366173, 0.172709062695503, 0.17278254032135, 0.172855958342552, 0.172929301857948, 0.173002630472183, 0.173075884580612, 0.173149093985558, 0.173222213983536, 0.173295304179192, 0.173368349671364, 0.17344132065773, 0.173514246940613, 0.173587128520012, 0.173659935593605, 0.173730477690697, 0.173798680305481, 0.17386682331562, 0.173934876918793, 0.174002826213837, 0.174070715904236, 0.174138471484184, 0.174206167459488, 0.174273759126663, 0.174341261386871, 0.174408689141273, 0.174475982785225, 0.174543246626854, 0.174610376358032, 0.174677416682243, 0.174744367599487, 0.174811258912086, 0.174878031015396, 0.1749447286129, 0.175011321902275, 0.175077840685844, 0.175144240260124, 0.175210565328598, 0.175276786088943, 0.175342932343483, 0.175408989191055, 0.175474941730499, 0.175540804862976, 0.175606593489647, 0.175672277808189, 0.175737872719765, 0.175803393125534, 0.175868794322014, 0.175934106111526, 0.175999358296394, 0.176064491271973, 0.176129564642906, 0.176194503903389, 0.176259383559227, 0.176324173808098, 0.176388844847679, 0.176453441381454, 0.176517963409424, 0.176582381129265, 0.176646694540977, 0.176710918545723, 0.176775082945824, 0.176839128136635, 0.17690309882164, 0.176966965198517, 0.177030742168427, 0.177094429731369, 0.177158027887344, 0.177221536636353, 0.177284955978394, 0.177348271012306, 0.177411511540413, 0.177474677562714, 0.177537709474564, 0.177600666880608, 0.177663549780846, 0.177726328372955, 0.177789017558098, 0.177851617336273, 0.177914127707481, 0.177976533770561, 0.178038880228996, 0.178101122379303, 0.17816324532032, 0.178225308656693, 0.178287282586098, 0.178349152207375, 0.178410932421684, 0.178472623229027, 0.178534239530563, 0.17859573662281, 0.17865714430809, 0.178718492388725, 0.178779736161232, 0.178840860724449, 0.178901925683022, 0.178962886333466, 0.179023772478104, 0.179084539413452, 0.179145231842995, 0.17920583486557, 0.179266348481178, 0.179326772689819, 0.179387077689171, 0.179447337985039, 0.179507479071617, 0.17956754565239, 0.179627507925034, 0.179687395691872, 0.179747179150581, 0.179806858301163, 0.179866462945938, 0.179925978183746, 0.179985389113426, 0.1800447255373, 0.180103972554207, 0.180163100361824, 0.180222168564796, 0.180281132459641, 0.180340006947517, 0.180398806929588, 0.180457517504692, 0.180516093969345, 0.180574595928192, 0.180633038282394, 0.180691346526146, 0.180749595165253, 0.180807754397392, 0.180865824222565, 0.180923789739609, 0.180981650948524, 0.181039437651634, 0.181097149848938, 0.181154757738113, 0.181212246417999, 0.18126967549324, 0.181327000260353, 0.181384235620499, 0.181441396474838, 0.181498467922211, 0.181555420160294, 0.181612312793732, 0.18166908621788, 0.181725800037384, 0.181782394647598, 0.181838914752007, 0.181895330548286, 0.181951686739922, 0.182007923722267, 0.182064056396484, 0.182120129466057, 0.182176098227501, 0.182231962680817, 0.182287767529488, 0.182343453168869, 0.182399064302444, 0.182454586029053, 0.182509988546371, 0.182565331459045, 0.182620570063591, 0.182675734162331, 0.182730793952942, 0.182785764336586, 0.182840660214424, 0.182895436882973, 0.182950139045715, 0.18300473690033, 0.183059245347977, 0.183113679289818, 0.183168008923531, 0.183222249150276, 0.183276414871216, 0.183330476284027, 0.183384448289871, 0.183438315987587, 0.183492109179497, 0.183545812964439, 0.183599427342415, 0.183652952313423, 0.183706372976303, 0.183759704232216, 0.183812960982323, 0.18386609852314, 0.183919161558151, 0.183972135186195, 0.184025019407272, 0.184077799320221, 0.184130504727364, 0.184183120727539, 0.184235632419586, 0.184288069605827, 0.18434040248394, 0.184392645955086, 0.184444800019264, 0.184496879577637, 0.18454883992672, 0.184600740671158, 0.184652522206306, 0.184704214334488, 0.184755831956863, 0.184807360172272, 0.184858769178391, 0.184910103678703, 0.18496136367321, 0.185012519359589, 0.185063585639, 0.185114562511444, 0.18516543507576, 0.185216248035431, 0.185266926884651, 0.185317531228065, 0.185368061065674, 0.185418501496315, 0.185468822717667, 0.185519084334373, 0.185569226741791, 0.185619294643402, 0.185669273138046, 0.185719162225723, 0.185768961906433, 0.185818657279015, 0.185868248343468, 0.185917779803276, 0.185967206954956, 0.18601655960083, 0.186065807938576, 0.186114981770515, 0.186164036393166, 0.18621301651001, 0.186261892318726, 0.186310693621635, 0.186359375715256, 0.186407998204231, 0.186456546187401, 0.18650496006012, 0.186553299427032, 0.186601534485817, 0.186649709939957, 0.186697781085968, 0.186745747923851, 0.186793640255928, 0.186841428279877, 0.186889141798019, 0.186936765909195, 0.186984285712242, 0.187031716108322, 0.187079042196274, 0.187126293778419, 0.187173470854759, 0.187220528721809, 0.187267512083054, 0.187314391136169, 0.187361195683479, 0.187407895922661, 0.187454521656036, 0.187501043081284, 0.187547475099564, 0.187593817710876, 0.187640056014061, 0.187686234712601, 0.187732309103012, 0.187778264284134, 0.187824159860611, 0.18786995112896, 0.187915682792664, 0.187961280345917, 0.188006803393364, 0.188052251935005, 0.188097581267357, 0.188142850995064, 0.188188001513481, 0.188233077526093, 0.188278049230576, 0.188322946429253, 0.188367739319801, 0.188412442803383, 0.188457071781158, 0.188501581549644, 0.188546031713486, 0.188590377569199, 0.188634604215622, 0.188678771257401, 0.188722848892212, 0.188766822218895, 0.188810735940933, 0.188854515552521, 0.188898220658302, 0.188941851258278, 0.188985377550125, 0.189028799533844, 0.189072147011757, 0.189115405082703, 0.189158573746681, 0.189201653003693, 0.189244627952576, 0.189287528395653, 0.18933030962944, 0.189373016357422, 0.189415648579597, 0.189458161592484, 0.189500615000725, 0.189542949199677, 0.189585208892822, 0.18962736427784, 0.189669460058212, 0.189711406826973, 0.189753323793411, 0.18979512155056, 0.18983681499958, 0.189878463745117, 0.189919978380203, 0.189961418509483, 0.190002784132957, 0.190044030547142, 0.190085187554359, 0.190126270055771, 0.190167248249054, 0.19020813703537, 0.19024895131588, 0.1902896463871, 0.190330266952515, 0.190370798110962, 0.190411224961281, 0.190451592206955, 0.19049184024334, 0.190532028675079, 0.19057209789753, 0.190612092614174, 0.190651968121529, 0.190691754221916, 0.190731480717659, 0.190771088004112, 0.190810650587082, 0.190850079059601, 0.190889433026314, 0.190928682684898, 0.190967842936516, 0.191006913781166, 0.191045925021172, 0.191084817051888, 0.191123619675636, 0.191162303090096, 0.191200941801071, 0.191239476203918, 0.191277921199799, 0.19131626188755, 0.191354528069496, 0.191392689943314, 0.191430762410164, 0.191468775272369, 0.191506668925285, 0.191544458270073, 0.191582173109055, 0.191619798541069, 0.191657334566116, 0.191694781184196, 0.191732108592987, 0.191769376397133, 0.191806554794312, 0.191843628883362, 0.191880628466606, 0.191917508840561, 0.191954299807549, 0.19199101626873, 0.192027673125267, 0.192064180970192, 0.192100629210472, 0.192136973142624, 0.192173257470131, 0.192209422588348, 0.192245483398438, 0.192281484603882, 0.192317381501198, 0.192353174090385, 0.192388892173767, 0.192424535751343, 0.192460060119629, 0.192495509982109, 0.1925308406353, 0.192566126585007, 0.192601293325424, 0.192636355757713, 0.192671373486519, 0.192706272006035, 0.192741066217422, 0.192775785923004, 0.192810401320457, 0.192844942212105, 0.192879378795624, 0.192913725972176, 0.192947998642921, 0.192982167005539, 0.19301626086235, 0.193050235509872, 0.19308415055275, 0.193117946386337, 0.193151667714119, 0.193185299634933, 0.19321882724762, 0.1932522803545, 0.193285629153252, 0.193318903446198, 0.193352058529854, 0.193385154008865, 0.19341816008091, 0.193451046943665, 0.193483859300613, 0.193516582250595, 0.193549200892448, 0.193581759929657, 0.193614184856415, 0.193646535277367, 0.193678811192513, 0.19371098279953, 0.193743079900742, 0.193775042891502, 0.19380696117878, 0.193838760256767, 0.193870469927788, 0.193902105093002, 0.193933635950089, 0.193965092301369, 0.193996459245682, 0.194027721881866, 0.194058895111084, 0.194089978933334, 0.194120973348618, 0.194151893258095, 0.194182679057121, 0.194213420152664, 0.194244042038918, 0.194274574518204, 0.194305032491684, 0.194335371255875, 0.194365650415421, 0.194395810365677, 0.194425910711288, 0.19445589184761, 0.194485813379288, 0.194515600800514, 0.194545328617096, 0.194574952125549, 0.194604516029358, 0.194633960723877, 0.194663316011429, 0.194692581892014, 0.194721758365631, 0.194750845432281, 0.194779843091965, 0.19480873644352, 0.194837555289268, 0.19486628472805, 0.194894909858704, 0.19492344558239, 0.194951921701431, 0.194980278611183, 0.195008531212807, 0.195036694407463, 0.195064797997475, 0.195092797279358, 0.195120692253113, 0.195148512721062, 0.195176228880882, 0.195203870534897, 0.195231407880783, 0.195258855819702, 0.195286229252815, 0.195313483476639, 0.195340678095818, 0.195367768406868, 0.195394769310951, 0.195421651005745, 0.195448458194733, 0.195475205779076, 0.195501834154129, 0.195528358221054, 0.195554822683334, 0.195581197738647, 0.195607453584671, 0.19563364982605, 0.195659726858139, 0.195685729384422, 0.195711612701416, 0.195737451314926, 0.195763155817986, 0.195788815617561, 0.195814326405525, 0.195839777588844, 0.195865154266357, 0.195890426635742, 0.19591560959816, 0.19594070315361, 0.195965707302094, 0.195990607142448, 0.196015432476997, 0.196040138602257, 0.196064785122871, 0.196089312434196, 0.196113780140877, 0.196138143539429, 0.196162417531013, 0.196186617016792, 0.196210697293282, 0.196234688162804, 0.19625860452652, 0.196282401680946, 0.196306139230728, 0.196329772472382, 0.19635334610939, 0.196376770734787, 0.1964001506567, 0.196423411369324, 0.196446597576141, 0.196469694375992, 0.196492671966553, 0.196514368057251, 0.196534812450409, 0.196555122733116, 0.196575313806534, 0.196595445275307, 0.19661545753479, 0.196635395288467, 0.196655228734016, 0.196674942970276, 0.196694582700729, 0.196714103221893, 0.196733519434929, 0.196752846240997, 0.196772068738937, 0.19679120182991, 0.196810230612755, 0.196829155087471, 0.196847975254059, 0.196866720914841, 0.196885362267494, 0.196903884410858, 0.196922302246094, 0.196940645575523, 0.196958869695663, 0.196977004408836, 0.196995034813881, 0.197012975811958, 0.197030797600746, 0.197048529982567, 0.19706617295742, 0.197083726525307, 0.197101145982742, 0.197118490934372, 0.197135731577873, 0.197152853012085, 0.197169914841652, 0.197186842560768, 0.197203680872917, 0.197220414876938, 0.197237074375153, 0.197253599762917, 0.197270050644875, 0.197286397218704, 0.197302639484406, 0.197318777441978, 0.197334825992584, 0.197350785136223, 0.197366625070572, 0.197382375597954, 0.197398021817207, 0.197413578629494, 0.197429001331329, 0.19744436442852, 0.197459608316422, 0.197474762797356, 0.197489812970161, 0.197504773736, 0.197519615292549, 0.197534382343292, 0.197549045085907, 0.197563588619232, 0.19757804274559, 0.19759239256382, 0.197606652975082, 0.197620823979378, 0.197634845972061, 0.197648823261261, 0.197662681341171, 0.197676435112953, 0.197690099477768, 0.197703644633293, 0.197717130184174, 0.197730496525764, 0.197743743658066, 0.1977569013834, 0.197769984602928, 0.197782948613167, 0.197795793414116, 0.19780857861042, 0.197821229696274, 0.197833806276321, 0.197846263647079, 0.19785863161087, 0.197870895266533, 0.197883069515228, 0.197895139455795, 0.197907105088234, 0.197918981313705, 0.197930753231049, 0.197942420840263, 0.19795398414135, 0.19796547293663, 0.197976842522621, 0.197988107800484, 0.197999283671379, 0.198010370135307, 0.198021352291107, 0.198032215237617, 0.198043003678322, 0.198053687810898, 0.198064252734184, 0.198074728250504, 0.198085099458694, 0.198095396161079, 0.198105558753014, 0.198115631937981, 0.198125615715981, 0.198135524988174, 0.198145285248756, 0.198154971003532, 0.198164567351341, 0.198174044489861, 0.198183432221413, 0.198192715644836, 0.198201909661293, 0.19821098446846, 0.198219999670982, 0.198228880763054, 0.198237657546997, 0.198246344923973, 0.198254942893982, 0.198263436555862, 0.198271825909615, 0.1982801258564, 0.198288306593895, 0.198296397924423, 0.198304384946823, 0.198312282562256, 0.19832007586956, 0.198327779769897, 0.198335364460945, 0.198342874646187, 0.1983502805233, 0.198357567191124, 0.198364779353142, 0.198371857404709, 0.19837886095047, 0.198385745286942, 0.198392555117607, 0.198399260640144, 0.198405861854553, 0.198412373661995, 0.198418781161308, 0.198425084352493, 0.19843128323555, 0.198437377810478, 0.198443382978439, 0.198449313640594, 0.198455095291138, 0.198460802435875, 0.198466420173645, 0.198471933603287, 0.1984773427248, 0.198482647538185, 0.198487862944603, 0.198492974042892, 0.198497965931892, 0.198502898216248, 0.198507711291313, 0.19851242005825, 0.198517054319382, 0.198521539568901, 0.198525980114937, 0.198530271649361, 0.19853450357914, 0.19853863120079, 0.19854262471199, 0.198546543717384, 0.19855035841465, 0.19855409860611, 0.198557704687119, 0.19856122136116, 0.198564663529396, 0.198567986488342, 0.198571190237999, 0.19857431948185, 0.198577344417572, 0.198580265045166, 0.198583081364632, 0.198585823178291, 0.198588445782661, 0.198590964078903, 0.198593392968178, 0.198595717549324, 0.198597967624664, 0.198600083589554, 0.198602110147476, 0.198604047298431, 0.198605880141258, 0.198607608675957, 0.198609232902527, 0.198610782623291, 0.198612213134766, 0.198613539338112, 0.19861476123333, 0.198615893721581, 0.198616936802864, 0.198617875576019, 0.198618695139885, 0.198619440197945, 0.198620095849037, 0.198620617389679, 0.198621049523354, 0.198621407151222, 0.198621645569801, 0.198621794581413, 0.198621824383736, 0.198621794581413, 0.198621615767479, 0.198621347546577, 0.198621019721031, 0.198620542883873, 0.198619991540909, 0.198619320988655, 0.198618590831757, 0.198617741465569, 0.198616787791252, 0.198615714907646, 0.198614567518234, 0.198613315820694, 0.198611974716187, 0.198610529303551, 0.198608979582787, 0.198607325553894, 0.198605582118034, 0.198603749275208, 0.198601797223091, 0.198599725961685, 0.198597595095634, 0.198595345020294, 0.198593005537987, 0.198590561747551, 0.198588013648987, 0.198585361242294, 0.198582649230957, 0.198579788208008, 0.198576852679253, 0.198573797941208, 0.198570668697357, 0.198567435145378, 0.198564097285271, 0.198560655117035, 0.198557123541832, 0.198553487658501, 0.198549747467041, 0.198545917868614, 0.198541983962059, 0.198537930846214, 0.198533803224564, 0.198529571294785, 0.198525220155716, 0.198520809412003, 0.198516279459, 0.198511645197868, 0.19850692152977, 0.198502093553543, 0.198497161269188, 0.198492124676704, 0.198486998677254, 0.198481783270836, 0.19847646355629, 0.198471039533615, 0.198465526103973, 0.198459893465042, 0.198454141616821, 0.198448315262794, 0.198442399501801, 0.198436394333839, 0.198430269956589, 0.198424056172371, 0.198417723178864, 0.198411300778389, 0.198404788970947, 0.198398172855377, 0.198391452431679, 0.198384642601013, 0.198377713561058, 0.198370710015297, 0.198363572359085, 0.198356360197067, 0.198349043726921, 0.198341637849808, 0.198334127664566, 0.198326528072357, 0.198318794369698, 0.198310986161232, 0.198303088545799, 0.198295071721077, 0.198286965489388, 0.19827875494957, 0.198270425200462, 0.19826203584671, 0.198253527283669, 0.19824492931366, 0.198236212134361, 0.198227420449257, 0.198218494653702, 0.19820947945118, 0.19820037484169, 0.198191180825233, 0.19818189740181, 0.198172479867935, 0.198163002729416, 0.198153391480446, 0.198143675923347, 0.198133885860443, 0.19812399148941, 0.198113977909088, 0.19810388982296, 0.198093697428703, 0.19808341562748, 0.198072984814644, 0.198062494397163, 0.198051914572716, 0.198041215538979, 0.198030412197113, 0.198019549250603, 0.19800853729248, 0.197997450828552, 0.197986245155334, 0.197974964976311, 0.197963580489159, 0.197952091693878, 0.197940513491631, 0.197928801178932, 0.197917029261589, 0.197905138134956, 0.197893142700195, 0.197881057858467, 0.197868883609772, 0.197856590151787, 0.197844207286835, 0.197831705212593, 0.197819128632545, 0.197806462645531, 0.197793677449226, 0.197780787944794, 0.197767809033394, 0.197754740715027, 0.19774155318737, 0.197728291153908, 0.197714880108833, 0.197701424360275, 0.197687849402428, 0.197674170136452, 0.19766041636467, 0.197646528482437, 0.197632536292076, 0.197618469595909, 0.197604298591614, 0.19759002327919, 0.19757567346096, 0.197561174631119, 0.197546601295471, 0.197531953454018, 0.197517156600952, 0.197502300143242, 0.197487324476242, 0.197472259402275, 0.197457104921341, 0.197441831231117, 0.197426468133926, 0.197411000728607, 0.197395414113998, 0.197379767894745, 0.197364002466202, 0.19734813272953, 0.197332188487053, 0.197316125035286, 0.197299957275391, 0.197283700108528, 0.197267323732376, 0.197250872850418, 0.197234317660332, 0.197217658162117, 0.197200894355774, 0.197184056043625, 0.197167068719864, 0.197150021791458, 0.197132900357246, 0.197115615010262, 0.197098270058632, 0.197080820798874, 0.197063252329826, 0.197045609354973, 0.19702784717083, 0.19700999557972, 0.196992054581642, 0.196974009275436, 0.196955844759941, 0.196937620639801, 0.19691926240921, 0.196900829672813, 0.196882262825966, 0.196863606572151, 0.196844875812531, 0.19682602584362, 0.196807086467743, 0.196788057684898, 0.196768894791603, 0.196749642491341, 0.196730300784111, 0.196710869669914, 0.196691334247589, 0.196671679615974, 0.196651950478554, 0.196632117033005, 0.196612149477005, 0.196592137217522, 0.196572005748749, 0.196551769971848, 0.196531414985657, 0.196510970592499, 0.196490451693535, 0.196469813585281, 0.1964490711689, 0.196428254246712, 0.196407303214073, 0.196386277675629, 0.196365132927895, 0.196343913674355, 0.196322590112686, 0.196301162242889, 0.196279630064964, 0.196257993578911, 0.196236282587051, 0.196214452385902, 0.196192502975464, 0.196170479059219, 0.196148365736008, 0.196126133203506, 0.196103826165199, 0.196081385016441, 0.196058854460716, 0.196036234498024, 0.196013510227203, 0.195990711450577, 0.195967763662338, 0.195944786071777, 0.195921659469604, 0.195898413658142, 0.195875108242035, 0.195851683616638, 0.195828184485435, 0.195804536342621, 0.195780843496323, 0.195757031440735, 0.195733100175858, 0.195709094405174, 0.195684984326363, 0.195660769939423, 0.195636436343193, 0.19561205804348, 0.195587530732155, 0.195562928915024, 0.195538222789764, 0.195513397455215, 0.195488497614861, 0.195463493466377, 0.195438370108604, 0.195413172245026, 0.195387870073318, 0.195362463593483, 0.195336937904358, 0.195311337709427, 0.195285633206367, 0.195259839296341, 0.195233926177025, 0.195207923650742, 0.195181846618652, 0.195155620574951, 0.195129320025444, 0.195102915167809, 0.195076435804367, 0.195049852132797, 0.195023149251938, 0.194996327161789, 0.194969445466995, 0.194942444562912, 0.1949153393507, 0.194888159632683, 0.194860860705376, 0.194833472371101, 0.194805964827538, 0.194778367877007, 0.194750681519508, 0.194722890853882, 0.194694980978966, 0.194666996598244, 0.194638937711716, 0.194610744714737, 0.194582432508469, 0.194554075598717, 0.194525569677353, 0.194496989250183, 0.194468304514885, 0.194439500570297, 0.194410622119904, 0.194381639361382, 0.194352552294731, 0.194322094321251, 0.194290339946747, 0.194258481264114, 0.194226503372192, 0.194194480776787, 0.194162353873253, 0.194130122661591, 0.194097816944122, 0.194065436720848, 0.194032922387123, 0.194000363349915, 0.193967700004578, 0.193934962153435, 0.193902119994164, 0.193869218230247, 0.193836182355881, 0.193803071975708, 0.193769887089729, 0.193736627697945, 0.193703263998032, 0.193669781088829, 0.193636253476143, 0.193602621555328, 0.193568885326385, 0.193535089492798, 0.193501174449921, 0.193467184901237, 0.19343313574791, 0.193398967385292, 0.193364709615707, 0.193330377340317, 0.193295955657959, 0.193261414766312, 0.193226829171181, 0.19319212436676, 0.193157345056534, 0.193122461438179, 0.193087518215179, 0.193052470684052, 0.193017333745956, 0.192982122302055, 0.192946806550026, 0.192911386489868, 0.192875906825066, 0.192840322852135, 0.192804679274559, 0.192768916487694, 0.192733079195023, 0.192697137594223, 0.192661106586456, 0.192625015974045, 0.192588806152344, 0.192552536725998, 0.192516148090363, 0.192479684948921, 0.192443147301674, 0.192406505346298, 0.192369788885117, 0.192332968115807, 0.192296072840691, 0.192259073257446, 0.192221984267235, 0.192184820771217, 0.192147552967072, 0.192110225558281, 0.192072778940201, 0.192035257816315, 0.191997647285461, 0.19195993244648, 0.191922172904015, 0.19188429415226, 0.191846311092377, 0.191808268427849, 0.191770136356354, 0.191731914877892, 0.19169357419014, 0.191655173897743, 0.19161668419838, 0.191578105092049, 0.191539421677589, 0.191500663757324, 0.191461831331253, 0.191422879695892, 0.191383868455887, 0.191344767808914, 0.191305533051491, 0.191266238689423, 0.191226869821548, 0.191187396645546, 0.191147863864899, 0.191108196973801, 0.191068485379219, 0.191028654575348, 0.19098873436451, 0.190948739647865, 0.190908655524254, 0.190868496894836, 0.190828219056129, 0.190787866711617, 0.190747454762459, 0.190706893801689, 0.190666273236275, 0.190625578165054, 0.190584808588028, 0.190543919801712, 0.190502926707268, 0.19046188890934, 0.190420731902122, 0.19037951529026, 0.190338164567947, 0.19029675424099, 0.190255269408226, 0.190213680267334, 0.190172016620636, 0.190130233764648, 0.190088376402855, 0.190046444535255, 0.190004393458366, 0.189962282776833, 0.18992006778717, 0.189877778291702, 0.189835399389267, 0.189792916178703, 0.189750373363495, 0.189707711338997, 0.189664989709854, 0.189622148871422, 0.189579233527184, 0.189536243677139, 0.189493134617805, 0.189449951052666, 0.18940669298172, 0.189363330602646, 0.189319893717766, 0.189276367425919, 0.189232736825943, 0.189189016819, 0.189145222306252, 0.189101338386536, 0.189057365059853, 0.189013302326202, 0.188969135284424, 0.188924908638, 0.188880577683449, 0.18883615732193, 0.188791647553444, 0.188747048377991, 0.188702374696732, 0.188657626509666, 0.188612744212151, 0.18856780230999, 0.188522756099701, 0.188477635383606, 0.188432425260544, 0.188387125730515, 0.188341736793518, 0.188296243548393, 0.188250690698624, 0.188205033540726, 0.188159286975861, 0.18811346590519, 0.188067525625229, 0.188021525740623, 0.187975436449051, 0.187929227948189, 0.187882974743843, 0.187836602330208, 0.187790170311928, 0.187743604183197, 0.187696978449821, 0.18765027821064, 0.18760347366333, 0.187556579709053, 0.187509596347809, 0.187462523579597, 0.18741537630558, 0.187368124723434, 0.187320798635483, 0.187273368239403, 0.187225848436356, 0.187178254127502, 0.187130570411682, 0.187082782387733, 0.187034919857979, 0.186986967921257, 0.186938941478729, 0.186890780925751, 0.186842560768127, 0.186794266104698, 0.186745882034302, 0.186697393655777, 0.186648830771446, 0.186600163578987, 0.186551406979561, 0.186502575874329, 0.186453655362129, 0.186404630541801, 0.186355516314507, 0.186306327581406, 0.186257064342499, 0.186207681894302, 0.186158239841461, 0.18610867857933, 0.186059042811394, 0.186009332537651, 0.18595951795578, 0.185909613966942, 0.185859635472298, 0.185809567570686, 0.185759395360947, 0.185709148645401, 0.185658797621727, 0.185608372092247, 0.1855578571558, 0.185507237911224, 0.185456559062004, 0.185405775904655, 0.18535490334034, 0.185303941369057, 0.185252889990807, 0.18520176410675, 0.185150533914566, 0.185099229216576, 0.185047820210457, 0.184996336698532, 0.184944748878479, 0.184893101453781, 0.184841349720955, 0.18478949368, 0.18473756313324, 0.184685543179512, 0.184633448719978, 0.184581235051155, 0.184528961777687, 0.184476584196091, 0.184424102306366, 0.184371560811996, 0.18431892991066, 0.184266194701195, 0.184213399887085, 0.184160470962524, 0.184107467532158, 0.184054389595985, 0.184001237154007, 0.1839479804039, 0.183894634246826, 0.183841198682785, 0.183787673711777, 0.183734059333801, 0.18368037045002, 0.18362657725811, 0.183572694659233, 0.18351873755455, 0.183464676141739, 0.18341052532196, 0.183356314897537, 0.183301985263824, 0.183247596025467, 0.18319308757782, 0.183138504624367, 0.183083832263947, 0.18302908539772, 0.182974219322205, 0.182919293642044, 0.182864263653755, 0.182809129357338, 0.182753935456276, 0.182698637247086, 0.18264327943325, 0.182587802410126, 0.182532235980034, 0.182476595044136, 0.182420864701271, 0.182365044951439, 0.18230913579464, 0.182253137230873, 0.182197049260139, 0.1821408867836, 0.182084605097771, 0.182028248906136, 0.181971833109856, 0.181915298104286, 0.181858688592911, 0.181801974773407, 0.181745171546936, 0.18168830871582, 0.181631341576576, 0.181574270129204, 0.181517124176025, 0.18145988881588, 0.181402549147606, 0.181345149874687, 0.18128764629364, 0.181230068206787, 0.181172370910645, 0.181114599108696, 0.181056752800941, 0.18099881708622, 0.180940791964531, 0.180882662534714, 0.180824458599091, 0.180766150355339, 0.180707782506943, 0.180649295449257, 0.180590733885765, 0.180532082915306, 0.180473357439041, 0.180414542555809, 0.180355608463287, 0.18029659986496, 0.180237516760826, 0.180178314447403, 0.180119067430496, 0.1800597012043, 0.180000275373459, 0.179940715432167, 0.179881080985069, 0.179821386933327, 0.179761573672295, 0.179701700806618, 0.179641723632812, 0.17958165705204, 0.179521515965462, 0.179461270570755, 0.179400935769081, 0.179340526461601, 0.179280012845993, 0.179219424724579, 0.179158732295036, 0.179097965359688, 0.17903707921505, 0.178976148366928, 0.178915098309517, 0.178854003548622, 0.178792789578438, 0.178731471300125, 0.178670078516006, 0.178608596324921, 0.178547024726868, 0.17848539352417, 0.178423643112183, 0.178361803293228, 0.178299888968468, 0.178237870335579, 0.178175777196884, 0.178113579750061, 0.178051322698593, 0.177988976240158, 0.177926510572433, 0.177863970398903, 0.177801325917244, 0.177738592028618, 0.177675798535347, 0.177612915635109, 0.177549928426743, 0.17748686671257, 0.177423700690269, 0.177360460162163, 0.177297130227089, 0.177233695983887, 0.17717020213604, 0.177106589078903, 0.177042916417122, 0.176979124546051, 0.176915258169174, 0.17685130238533, 0.176787257194519, 0.176723137497902, 0.176658913493156, 0.176594614982605, 0.176530197262764, 0.176465719938278, 0.176401138305664, 0.176336482167244, 0.176271721720695, 0.176206901669502, 0.176141962409019, 0.176076948642731, 0.176011845469475, 0.175946652889252, 0.175881370902061, 0.175815999507904, 0.175750538706779, 0.17568501830101, 0.175619378685951, 0.175553649663925, 0.175487831234932, 0.175421938300133, 0.175355941057205, 0.175289869308472, 0.175223723053932, 0.175157457590103, 0.175091117620468, 0.175024688243866, 0.174958169460297, 0.17489156126976, 0.174824878573418, 0.174758076667786, 0.17469123005867, 0.174624249339104, 0.174557194113731, 0.174490079283714, 0.174422845244408, 0.174355521798134, 0.174288123846054, 0.174220651388168, 0.174153059720993, 0.174085393548012, 0.174017637968063, 0.173949792981148, 0.173881843686104, 0.173813834786415, 0.173745721578598, 0.173677533864975, 0.173609241843224, 0.173540875315666, 0.17347240447998, 0.173403859138489, 0.173335209488869, 0.173266485333443, 0.173197671771049, 0.17312878370285, 0.1730597615242, 0.172990694642067, 0.172921508550644, 0.172852247953415, 0.172782927751541, 0.172713473439217, 0.172643944621086, 0.172574356198311, 0.172504648566246, 0.172434851527214, 0.172364994883537, 0.172295019030571, 0.172224968671799, 0.172154814004898, 0.172084584832191, 0.172014281153679, 0.171943873167038, 0.17187337577343, 0.171802774071693, 0.171732112765312, 0.171661347150803, 0.171590492129326, 0.171519547700882, 0.171448528766632, 0.171377405524254, 0.17130620777607, 0.171234920620918, 0.1711635440588, 0.171092078089714, 0.171020522713661, 0.17094886302948, 0.170877143740654, 0.1708053201437, 0.170733407139778, 0.170661404728889, 0.170589312911034, 0.170517146587372, 0.170444875955582, 0.170372530817986, 0.170300096273422, 0.170227572321892, 0.170154929161072, 0.170082226395607, 0.170009434223175, 0.169936552643776, 0.169863596558571, 0.169790521264076, 0.169717371463776, 0.169644132256508, 0.169570833444595, 0.169497385621071, 0.169423893094063, 0.169350326061249, 0.169276624917984, 0.169202849268913, 0.169129014015198, 0.169055059552193, 0.168981030583382, 0.168906927108765, 0.168832704424858, 0.168758407235146, 0.168684020638466, 0.16860955953598, 0.168534979224205, 0.168460339307785, 0.168385595083237, 0.168310776352882, 0.1682358533144, 0.168160855770111, 0.168085753917694, 0.168010592460632, 0.167935311794281, 0.167859956622124, 0.167784482240677, 0.167708948254585, 0.167633339762688, 0.167557612061501, 0.167481809854507, 0.167403772473335, 0.167323291301727, 0.167242780327797, 0.167162239551544, 0.167081639170647, 0.167000979185104, 0.16692028939724, 0.166839525103569, 0.166758731007576, 0.166677877306938, 0.166596964001656, 0.166516035795212, 0.166435018181801, 0.166353985667229, 0.166272878646851, 0.166191756725311, 0.166110545396805, 0.166029304265976, 0.165948018431664, 0.165866658091545, 0.165785267949104, 0.16570383310318, 0.16562232375145, 0.165540784597397, 0.165459200739861, 0.165377557277679, 0.165295869112015, 0.165214136242867, 0.165132343769073, 0.165050506591797, 0.164968624711037, 0.164886683225632, 0.164804697036743, 0.164722681045532, 0.164640575647354, 0.164558455348015, 0.164476275444031, 0.164394035935402, 0.164311766624451, 0.164229422807693, 0.164147049188614, 0.164064630866051, 0.16398212313652, 0.163899600505829, 0.163817033171654, 0.163734406232834, 0.163651719689369, 0.163569003343582, 0.163486242294312, 0.163403421640396, 0.163320541381836, 0.163237646222115, 0.163154661655426, 0.163071647286415, 0.162988558411598, 0.16290545463562, 0.162822276353836, 0.16273906826973, 0.162655800580978, 0.162572488188744, 0.162489101290703, 0.162405699491501, 0.162322223186493, 0.162238731980324, 0.162155166268349, 0.162071526050568, 0.161987885832787, 0.1619041711092, 0.161820411682129, 0.161736592650414, 0.161652743816376, 0.161568835377693, 0.161484867334366, 0.161400884389877, 0.161316812038422, 0.161232709884644, 0.161148563027382, 0.161064371466637, 0.160980090498924, 0.160895824432373, 0.160811454057693, 0.16072703897953, 0.160642623901367, 0.160558089613914, 0.160473540425301, 0.160388976335526, 0.160304322838783, 0.160219624638557, 0.160134881734848, 0.160050064325333, 0.159965217113495, 0.159880340099335, 0.159795373678207, 0.159710377454758, 0.159625366330147, 0.159540250897408, 0.159455120563507, 0.159369930624962, 0.159284695982933, 0.159199416637421, 0.159114077687263, 0.159028679132462, 0.158943235874176, 0.158857747912407, 0.158772230148315, 0.158686637878418, 0.158601015806198, 0.158515319228172, 0.158429607748985, 0.158343821763992, 0.158257976174355, 0.158172085881233, 0.158086165785789, 0.158000200986862, 0.157914161682129, 0.157828092575073, 0.157741963863373, 0.157655775547028, 0.157569542527199, 0.157483279705048, 0.157396957278252, 0.157310590147972, 0.157224148511887, 0.157137706875801, 0.157051160931587, 0.156964600086212, 0.156877979636192, 0.156791314482689, 0.156704589724541, 0.15661783516407, 0.156531006097794, 0.156444162130356, 0.156357243657112, 0.156270265579224, 0.156183257699013, 0.156096190214157, 0.156009078025818, 0.155921906232834, 0.155834704637527, 0.155747443437576, 0.155660137534142, 0.155572757124901, 0.155485361814499, 0.155397906899452, 0.155310407280922, 0.155222833156586, 0.155135229229927, 0.155047595500946, 0.154959872364998, 0.154872119426727, 0.154784321784973, 0.154696464538574, 0.154608562588692, 0.154520601034164, 0.154432594776154, 0.15434455871582, 0.154256463050842, 0.154168307781219, 0.154080107808113, 0.153991863131523, 0.15390357375145, 0.153815224766731, 0.153726816177368, 0.153638392686844, 0.153549894690514, 0.1534613519907, 0.153372764587402, 0.15328411757946, 0.153195440769196, 0.153106689453125, 0.153017908334732, 0.152929052710533, 0.152840167284012, 0.152751237154007, 0.152662247419357, 0.152573198080063, 0.152484133839607, 0.152394995093346, 0.1523058116436, 0.152216583490372, 0.152127295732498, 0.152037963271141, 0.1519485861063, 0.151859149336815, 0.151769682765007, 0.151680141687393, 0.151590570807457, 0.151500940322876, 0.151411265134811, 0.151321545243263, 0.151231750845909, 0.151141941547394, 0.151052057743073, 0.150962144136429, 0.150872156023979, 0.150782153010368, 0.150692075490952, 0.150601953268051, 0.150511771440506, 0.150421559810638, 0.150331273674965, 0.15024097263813, 0.15015059709549, 0.150060191750526, 0.149969726800919, 0.149879202246666, 0.149788647890091, 0.14969801902771, 0.149607360363007, 0.14951665699482, 0.149425879120827, 0.149335086345673, 0.149244233965874, 0.149153307080269, 0.149062365293503, 0.148971349000931, 0.148880288004875, 0.148789182305336, 0.148698031902313, 0.148606821894646, 0.148515567183495, 0.148424282670021, 0.14833290874958, 0.148241505026817, 0.148150056600571, 0.148058548569679, 0.147967010736465, 0.147875413298607, 0.147783756256104, 0.147692054510117, 0.147600308060646, 0.147508516907692, 0.147416681051254, 0.147324785590172, 0.147232830524445, 0.147140830755234, 0.147048786282539, 0.146956697106361, 0.146864548325539, 0.146772369742393, 0.146680131554604, 0.146587833762169, 0.146495491266251, 0.146403104066849, 0.146310657262802, 0.146218165755272, 0.146125629544258, 0.1460330337286, 0.145940408110619, 0.145847722887993, 0.145754992961884, 0.145662203431129, 0.145569384098053, 0.145476505160332, 0.145383566617966, 0.145290583372116, 0.145197555422783, 0.145104482769966, 0.145011350512505, 0.144918188452721, 0.144824951887131, 0.144731670618057, 0.1446383446455, 0.14454497396946, 0.144451543688774, 0.144358068704605, 0.144264563918114, 0.144170984625816, 0.144077360630035, 0.143983691930771, 0.143889978528023, 0.143796190619469, 0.143702387809753, 0.143608525395393, 0.143514588475227, 0.1434206366539, 0.143326625227928, 0.14323253929615, 0.143138438463211, 0.143044278025627, 0.142950043082237, 0.142855808138847, 0.14276148378849, 0.14266711473465, 0.142572715878487, 0.142478257417679, 0.142383754253387, 0.142289191484451, 0.142194584012032, 0.142099916934967, 0.14200522005558, 0.141910463571548, 0.141815662384033, 0.141720786690712, 0.141625881195068, 0.141530930995941, 0.14143593609333, 0.141340881586075, 0.141245782375336, 0.141150638461113, 0.141055434942245, 0.140960186719894, 0.140864878892899, 0.14076954126358, 0.140674144029617, 0.140578702092171, 0.140483200550079, 0.140387654304504, 0.140292063355446, 0.140196412801743, 0.140100717544556, 0.140004992485046, 0.139909192919731, 0.139813348650932, 0.13971745967865, 0.139621526002884, 0.139525547623634, 0.139429494738579, 0.139333412051201, 0.139237284660339, 0.139141097664833, 0.139044865965843, 0.138948574662209, 0.13885223865509, 0.138755857944489, 0.138659432530403, 0.138562947511673, 0.138466417789459, 0.138369843363762, 0.13827320933342, 0.138176530599594, 0.138079807162285, 0.137983024120331, 0.137886196374893, 0.137789323925972, 0.137692406773567, 0.137595430016518, 0.137498393654823, 0.137401327490807, 0.137304216623306, 0.13720703125, 0.13710980117321, 0.137012526392937, 0.136915221810341, 0.136817842721939, 0.136720418930054, 0.136622965335846, 0.136525437235832, 0.136427879333496, 0.136330261826515, 0.136232599616051, 0.136134892702103, 0.13603712618351, 0.135939300060272, 0.135841444134712, 0.135743528604507, 0.13564558327198, 0.135547563433647, 0.135449513792992, 0.135351404547691, 0.135253250598907, 0.135155037045479, 0.135056778788567, 0.134958475828171, 0.13486011326313, 0.134761705994606, 0.134663254022598, 0.134564757347107, 0.134466201066971, 0.134367600083351, 0.134268954396248, 0.1341702491045, 0.134071514010429, 0.133972704410553, 0.133873865008354, 0.133774951100349, 0.133676007390022, 0.13357700407505, 0.133477970957756, 0.133378878235817, 0.133279725909233, 0.133180543780327, 0.133081302046776, 0.13298200070858, 0.132882669568062, 0.132783278822899, 0.132683843374252, 0.1325843334198, 0.132484808564186, 0.132385209202766, 0.132285580039024, 0.132185876369476, 0.132086157798767, 0.131986364722252, 0.131886541843414, 0.131786644458771, 0.131686717271805, 0.131586745381355, 0.131486713886261, 0.131386622786522, 0.13128650188446, 0.131186306476593, 0.131086081266403, 0.130985796451569, 0.13088546693325, 0.130785092711449, 0.130684673786163, 0.130584195256233, 0.130483686923981, 0.130383104085922, 0.13028247654438, 0.130181804299355, 0.130081087350845, 0.129980325698853, 0.129879489541054, 0.129778623580933, 0.129677712917328, 0.129576742649078, 0.129475712776184, 0.129374653100967, 0.129273533821106, 0.129172369837761, 0.129071161150932, 0.128969892859459, 0.128868579864502, 0.128767222166061, 0.128665819764137, 0.128564357757568, 0.128462836146355, 0.128361269831657, 0.128259658813477, 0.128158003091812, 0.128056302666664, 0.127954542636871, 0.127852737903595, 0.127750873565674, 0.12764897942543, 0.127547010779381, 0.127444997429848, 0.127342954277992, 0.127240851521492, 0.127138689160347, 0.12703649699688, 0.126934245228767, 0.126831948757172, 0.126729607582092, 0.126627191901207, 0.126524746417999, 0.126422256231308, 0.126319721341133, 0.126217111945152, 0.126114457845688, 0.126011773943901, 0.125909045338631, 0.125806242227554, 0.125703394412994, 0.125600501894951, 0.125497549772263, 0.125394582748413, 0.125291541218758, 0.125188454985619, 0.125085309147835, 0.124982126057148, 0.124878883361816, 0.124775603413582, 0.124672263860703, 0.12456887960434, 0.124465443193913, 0.124361969530582, 0.124258428812027, 0.124154850840569, 0.124051220715046, 0.12394754588604, 0.123843811452389, 0.123740032315254, 0.123636208474636, 0.123532332479954, 0.123428396880627, 0.123324424028397, 0.123220399022102, 0.123116321861744, 0.123012207448483, 0.122908033430576, 0.122803807258606, 0.122699536383152, 0.122595220804214, 0.12249082326889, 0.122386410832405, 0.122281946241856, 0.122177422046661, 0.122072845697403, 0.121968239545822, 0.121863566339016, 0.121758863329887, 0.121654085814953, 0.121549278497696, 0.121444411575794, 0.121339492499828, 0.121234536170959, 0.121129527688026, 0.121024265885353, 0.120918467640877, 0.120812676846981, 0.120706900954247, 0.120601117610931, 0.120495341718197, 0.120389595627785, 0.120283849537373, 0.120178140699863, 0.120072424411774, 0.119966723024845, 0.119861006736755, 0.119755320250988, 0.119649648666382, 0.119543984532356, 0.119438350200653, 0.119332708418369, 0.119227066636086, 0.119121447205544, 0.119015835225582, 0.118910223245621, 0.118804648518562, 0.118699081242085, 0.118593513965607, 0.118487954139709, 0.118382409214973, 0.118276871740818, 0.118171356618404, 0.11806583404541, 0.1179603561759, 0.117854855954647, 0.117749370634556, 0.117643907666206, 0.117538444697857, 0.117432989180088, 0.117327563464642, 0.117222130298615, 0.117116719484329, 0.117011316120625, 0.1169059202075, 0.116800531744957, 0.116695180535316, 0.116589829325676, 0.116484463214874, 0.116379134356976, 0.116273805499077, 0.116168476641178, 0.116063170135021, 0.115957893431187, 0.115852616727352, 0.115747332572937, 0.115642078220844, 0.115536823868752, 0.115431569516659, 0.115326344966888, 0.11522114276886, 0.115115933120251, 0.115010730922222, 0.114905543625355, 0.114800371229649, 0.114695206284523, 0.114590056240559, 0.114484921097755, 0.114379793405533, 0.114274680614471, 0.11416956782341, 0.11406446993351, 0.11395937204361, 0.113854289054871, 0.113749250769615, 0.113644182682037, 0.113539144396782, 0.113434113562107, 0.113329082727432, 0.113224066793919, 0.113119058310986, 0.113014072179794, 0.112909100949764, 0.112804137170315, 0.112699188292027, 0.112594239413738, 0.112489297986031, 0.112384371459484, 0.112279452383518, 0.112174555659294, 0.11206965893507, 0.111964777112007, 0.111859902739525, 0.111755043268204, 0.111650206148624, 0.111545369029045, 0.111440546810627, 0.111335724592209, 0.111230917274952, 0.111126117408276, 0.11102133244276, 0.110916569828987, 0.110811822116375, 0.110707059502602, 0.110602326691151, 0.110497586429119, 0.110392883419991, 0.110288165509701, 0.110183484852314, 0.110078804194927, 0.10997412353754, 0.109869450330734, 0.109764814376831, 0.109660163521767, 0.109555527567863, 0.109450921416283, 0.109346307814121, 0.109241716563702, 0.109137132763863, 0.109032548964024, 0.108927972614765, 0.108823426067829, 0.108718886971474, 0.108614355325699, 0.108509838581085, 0.108405314385891, 0.108300812542439, 0.108196325600147, 0.108091853559017, 0.107987403869629, 0.107882931828499, 0.107778482139111, 0.107674054801464, 0.107569620013237, 0.107465207576752, 0.107360810041428, 0.107256405055523, 0.107152037322521, 0.107047662138939, 0.106943301856518, 0.106838941574097, 0.106734603643417, 0.106630302965641, 0.106525987386703, 0.106421679258347, 0.10631737112999, 0.106213107705116, 0.106108821928501, 0.106004565954208, 0.105900324881077, 0.105796098709106, 0.105691850185394, 0.105587638914585, 0.105483427643776, 0.105379231274128, 0.105275042355061, 0.105170883238316, 0.105066731572151, 0.104962572455406, 0.104858435690403, 0.1047542989254, 0.104650177061558, 0.104546062648296, 0.104441978037357, 0.104337885975838, 0.104233808815479, 0.104129746556282, 0.104025691747665, 0.103921644389629, 0.103817611932755, 0.103713601827621, 0.103609591722488, 0.103505589067936, 0.103401593863964, 0.103297613561153, 0.103193663060665, 0.103089697659016, 0.102985769510269, 0.102881841361523, 0.102777890861034, 0.10267399251461, 0.102570079267025, 0.102466195821762, 0.102362304925919, 0.102258428931236, 0.102154575288296, 0.102050736546516, 0.101946890354156, 0.101843066513538, 0.10173924267292, 0.101635456085205, 0.101531662046909, 0.101427882909775, 0.10132410377264, 0.101220339536667, 0.101116590201855, 0.101012855768204, 0.100909136235714, 0.100805424153805, 0.100701719522476, 0.100598014891148, 0.10049432516098, 0.100390650331974, 0.10028700530529, 0.100183360278606, 0.100079707801342, 0.0999760851264, 0.099872462451458, 0.0997688621282578, 0.0996652618050575, 0.0995616614818573, 0.0994581058621407, 0.0993545204401016, 0.0992509722709656, 0.0991474464535713, 0.0990439131855965, 0.0989403873682022, 0.0988368690013885, 0.0987333878874779, 0.0986299067735672, 0.0985264331102371, 0.098422959446907, 0.0983195006847382, 0.0982160419225693, 0.0981126055121422, 0.0980091989040375, 0.0979057848453522, 0.0978023856878281, 0.097698986530304, 0.0975956097245216, 0.0974922403693199, 0.0973888710141182, 0.0972855240106583, 0.0971821844577789, 0.0970788523554802, 0.0969755575060844, 0.0968722477555275, 0.0967689678072929, 0.0966656729578972, 0.0965624079108238, 0.0964591503143311, 0.0963558927178383, 0.0962526574730873, 0.0961494222283363, 0.0960462242364883, 0.0959430187940598, 0.0958398133516312, 0.0957366302609444, 0.0956334620714188, 0.0955302864313126, 0.0954271405935287, 0.0953240245580673, 0.0952208936214447, 0.0951177701354027, 0.0950146690011024, 0.0949115604162216, 0.0948084816336632, 0.0947054028511047, 0.0946023315191269, 0.094499297440052, 0.094396248459816, 0.0942932143807411, 0.0941901952028275, 0.094087190926075, 0.0939841717481613, 0.0938811898231506, 0.0937782377004623, 0.0936752632260323, 0.0935723036527634, 0.0934693589806557, 0.0933664366602898, 0.0932634994387627, 0.093160592019558, 0.093057706952095, 0.0929548069834709, 0.092851921916008, 0.0927490517497063, 0.0926462039351463, 0.0925433486700058, 0.0924405157566071, 0.0923376977443695, 0.0922348648309708, 0.092132069170475, 0.0920292586088181, 0.0919264853000641, 0.0918237417936325, 0.0917209759354591, 0.0916182175278664, 0.0915154814720154, 0.0914127603173256, 0.0913100391626358, 0.091207318007946, 0.0911046490073204, 0.0910019651055336, 0.0908992812037468, 0.0907966271042824, 0.0906939581036568, 0.0905913189053535, 0.0904887095093727, 0.0903861001133919, 0.090283490717411, 0.0901808887720108, 0.0900783091783524, 0.0899757146835327, 0.0898731648921967, 0.08977060765028, 0.0896680951118469, 0.0895655453205109, 0.0894630178809166, 0.0893605127930641, 0.0892580077052116, 0.089155524969101, 0.0890530422329903, 0.0889506042003632, 0.0888481363654137, 0.0887456983327866, 0.0886432603001595, 0.0885408297181129, 0.0884384214878082, 0.0883360281586647, 0.0882336422801018, 0.0881312564015388, 0.0880288854241371, 0.0879265367984772, 0.0878242030739784, 0.0877218544483185, 0.0876195281744003, 0.0875172168016434, 0.087414912879467, 0.0873126015067101, 0.0872103199362755, 0.0871080681681633, 0.0870057865977287, 0.0869035571813583, 0.0868013277649879, 0.0866990983486176, 0.0865968838334084, 0.0864946693181992, 0.0863924771547318, 0.0862902998924255, 0.0861881300806999, 0.0860859602689743, 0.0859838128089905, 0.0858816877007484, 0.0857795551419258, 0.085677444934845, 0.0855753272771835, 0.0854732394218445, 0.085371159017086, 0.0852690786123276, 0.0851670131087303, 0.0850649550557137, 0.0849629193544388, 0.0848608985543251, 0.0847588777542114, 0.0846568793058395, 0.0845548659563065, 0.0844528824090958, 0.0843508914113045, 0.0842489451169968, 0.0841469764709473, 0.0840450525283813, 0.0839431211352348, 0.0838411971926689, 0.0837392881512642, 0.0836373791098595, 0.0835354849696159, 0.0834336057305336, 0.0833317488431931, 0.0832298845052719, 0.0831280499696732, 0.0830262154340744, 0.0829243808984756, 0.0828225612640381, 0.0827207639813423, 0.0826189666986465, 0.0825172066688538, 0.0824154242873192, 0.0823136642575264, 0.082211896777153, 0.0821101740002632, 0.0820084512233734, 0.0819067433476448, 0.0818050354719162, 0.0817033499479294, 0.0816016718745232, 0.0814999863505363, 0.0813983157277107, 0.0812966898083687, 0.081195056438446, 0.0810934230685234, 0.080991804599762, 0.0808901935815811, 0.0807885974645615, 0.080687016248703, 0.0805854573845863, 0.0804838761687279, 0.080382339656353, 0.0802807807922363, 0.0801792591810226, 0.0800777301192284, 0.0799762308597565, 0.0798747465014458, 0.0797732472419739, 0.0796717703342438, 0.0795703083276749, 0.0794688537716866, 0.0793674141168594, 0.0792659744620323, 0.0791645646095276, 0.0790631547570229, 0.0789617598056793, 0.0788603648543358, 0.078758992254734, 0.0786576122045517, 0.0785562694072723, 0.0784549191594124, 0.0783535987138748, 0.0782522633671761, 0.0781509578227997, 0.0780496448278427, 0.0779483541846275, 0.077847070991993, 0.0777458101511002, 0.0776445269584656, 0.0775432959198952, 0.0774420574307442, 0.077340841293335, 0.077239602804184, 0.0771384164690971, 0.0770372301340103, 0.0769360512495041, 0.0768348649144173, 0.0767337083816528, 0.076632559299469, 0.0765314251184464, 0.0764302983880043, 0.0763291865587234, 0.076228067278862, 0.0761269778013229, 0.0760258957743645, 0.0759248211979866, 0.0758237540721893, 0.075722724199295, 0.0756216794252396, 0.0755206421017647, 0.0754196271300316, 0.0753186196088791, 0.0752176195383072, 0.0751166269183159, 0.0750156715512276, 0.0749147012829781, 0.0748137459158897, 0.074712797999382, 0.0746118724346161, 0.0745109394192696, 0.0744100362062454, 0.0743091553449631, 0.0742082595825195, 0.0741073861718178, 0.074006512761116, 0.0739056617021561, 0.0738048106431961, 0.0737039744853973, 0.0736031755805016, 0.0735023617744446, 0.0734015479683876, 0.0733007565140724, 0.0731999799609184, 0.073099210858345, 0.0729984492063522, 0.0728977024555206, 0.0727969631552696, 0.0726962313055992, 0.07259551435709, 0.0724948048591614, 0.0723941326141357, 0.0722934454679489, 0.0721927806735039, 0.0720921158790588, 0.0719914734363556, 0.0718908309936523, 0.0717902109026909, 0.07168959826231, 0.0715889930725098, 0.0714883878827095, 0.0713878124952316, 0.0712872296571732, 0.0711866691708565, 0.0710861161351204, 0.0709855929017067, 0.0708850622177124, 0.0707845464348793, 0.0706840232014656, 0.0705835297703743, 0.0704830512404442, 0.0703825578093529, 0.0702821090817451, 0.0701816603541374, 0.0700812190771103, 0.0699807778000832, 0.0698803663253784, 0.0697799474000931, 0.0696795657277107, 0.0695791766047478, 0.0694807022809982, 0.0693842843174934, 0.0692879557609558, 0.0691916719079018, 0.0690954253077507, 0.0689992606639862, 0.0689031258225441, 0.0688070952892303, 0.0687111243605614, 0.0686151683330536, 0.0685192868113518, 0.0684234648942947, 0.0683276951313019, 0.0682320222258568, 0.0681363716721535, 0.0680407881736755, 0.067945271730423, 0.0678497850894928, 0.0677543878555298, 0.0676590353250504, 0.0675637423992157, 0.0674684941768646, 0.0673733204603195, 0.067278191447258, 0.0671831667423248, 0.0670881420373917, 0.0669932216405869, 0.0668983310461044, 0.0668034926056862, 0.0667087435722351, 0.0666140466928482, 0.0665193796157837, 0.0664247944951057, 0.0663302838802338, 0.0662358030676842, 0.06614138931036, 0.0660470202565193, 0.0659527182579041, 0.0658584758639336, 0.0657643154263496, 0.0656701922416687, 0.0655761137604713, 0.0654821172356606, 0.0653881430625916, 0.0652942731976509, 0.0652004405856133, 0.065106675028801, 0.0650129616260529, 0.0649192929267883, 0.064825713634491, 0.0647321492433548, 0.0646386966109276, 0.0645452439785004, 0.0644518882036209, 0.0643585994839668, 0.0642653629183769, 0.0641721710562706, 0.0640790164470673, 0.0639859437942505, 0.0638929158449173, 0.0637999773025513, 0.06370709836483, 0.0636142492294312, 0.0635214522480965, 0.0634287223219872, 0.0633360669016838, 0.0632434636354446, 0.0631509274244308, 0.0630584359169006, 0.0629659965634346, 0.0628736540675163, 0.0627813339233398, 0.0626890733838081, 0.0625968724489212, 0.0625047385692596, 0.0624126568436623, 0.0623206458985806, 0.0622286796569824, 0.0621367804706097, 0.0620449185371399, 0.0619531236588955, 0.0618614293634892, 0.0617697387933731, 0.0616781488060951, 0.0615865774452686, 0.0614950843155384, 0.061403650790453, 0.0613122768700123, 0.0612209774553776, 0.0611296929419041, 0.0610384903848171, 0.060947347432375, 0.0608562640845776, 0.0607652328908443, 0.0606742575764656, 0.0605833604931831, 0.0604925192892551, 0.0604017116129398, 0.0603109747171402, 0.0602202974259853, 0.060129676014185, 0.0600391216576099, 0.0599486380815506, 0.0598581843078136, 0.0597678013145924, 0.059677466750145, 0.0595872029662132, 0.0594969876110554, 0.0594068467617035, 0.0593167692422867, 0.0592267252504826, 0.0591367334127426, 0.0590468235313892, 0.0589569658041, 0.0588671453297138, 0.0587774217128754, 0.0586877353489399, 0.0585981197655201, 0.0585085488855839, 0.0584190301597118, 0.0583295859396458, 0.0582401901483536, 0.0581508576869965, 0.058061596006155, 0.0579723864793777, 0.0578832067549229, 0.0577941127121449, 0.0577050596475601, 0.0576160661876202, 0.057527169585228, 0.0574383102357388, 0.0573494918644428, 0.0572607405483723, 0.0571720749139786, 0.0570834204554558, 0.0569948442280293, 0.0569063611328602, 0.0568178817629814, 0.0567294918000698, 0.0566411428153515, 0.0565528906881809, 0.0564646609127522, 0.0563764870166779, 0.0562883801758289, 0.0562003403902054, 0.0561123192310333, 0.0560244023799896, 0.0559365525841713, 0.0558487176895142, 0.0557609684765339, 0.0556732714176178, 0.0555856451392174, 0.0554980598390102, 0.0554105341434479, 0.0553230755031109, 0.0552356503903866, 0.0551483295857906, 0.0550610534846783, 0.0549737997353077, 0.0548866093158722, 0.0547995120286942, 0.0547124333679676, 0.0546254701912403, 0.0545385405421257, 0.0544516406953335, 0.0543648079037666, 0.0542780496180058, 0.0541913509368896, 0.0541047267615795, 0.0540181286633015, 0.0539316050708294, 0.0538451187312603, 0.0537587068974972, 0.0536723732948303, 0.0535860508680344, 0.0534998327493668, 0.0534136295318604, 0.0533275306224823, 0.0532414801418781, 0.0531554669141769, 0.0530695207417011, 0.0529836229979992, 0.0528978146612644, 0.0528120547533035, 0.0527263283729553, 0.0526407063007355, 0.0525550656020641, 0.0524695552885532, 0.0523841045796871, 0.0522986352443695, 0.0522133000195026, 0.0521280094981194, 0.0520427674055099, 0.051957581192255, 0.0518724359571934, 0.0517873875796795, 0.0517023280262947, 0.0516174137592316, 0.0515325590968132, 0.051447682082653, 0.0513629205524921, 0.051278181374073, 0.0511935316026211, 0.0511089600622654, 0.0510243885219097, 0.0509399212896824, 0.0508554875850677, 0.050771102309227, 0.0506867878139019, 0.0506025552749634, 0.0505183637142181, 0.0504342317581177, 0.0503501407802105, 0.0502661317586899, 0.0501821748912334, 0.0500982664525509, 0.0500144436955452, 0.049930639564991, 0.0498469397425652, 0.0497632883489132, 0.0496796444058418, 0.0495960973203182, 0.0495126023888588, 0.0494291856884956, 0.0493458062410355, 0.049262497574091, 0.0491792522370815, 0.0490960255265236, 0.0490128993988037, 0.0489298105239868, 0.048846784979105, 0.0487638600170612, 0.0486809238791466, 0.0485980696976185, 0.0485152862966061, 0.0484325550496578, 0.0483499020338058, 0.0482672527432442, 0.048184722661972, 0.0481022149324417, 0.0480197817087173, 0.0479374043643475, 0.0478550456464291, 0.0477728061378002, 0.0476905815303326, 0.0476084798574448, 0.0475263893604279, 0.0474443547427654, 0.0473623648285866, 0.0472804456949234, 0.0471985936164856, 0.0471168123185635, 0.0470350831747055, 0.0469534210860729, 0.0468717701733112, 0.0467901788651943, 0.0467086881399155, 0.0466272607445717, 0.0465458706021309, 0.0464645475149155, 0.0463832542300224, 0.0463020540773869, 0.0462208986282349, 0.0461397804319859, 0.0460587628185749, 0.0459777824580669, 0.045896865427494, 0.0458160154521465, 0.0457351841032505, 0.0456544756889343, 0.0455737449228764, 0.0454931370913982, 0.0454125925898552, 0.0453320555388927, 0.0452516190707684, 0.0451712086796761, 0.0450908727943897, 0.0450106002390385, 0.0449303723871708, 0.0448502339422703, 0.0447701178491116, 0.04469009116292, 0.044610109180212, 0.0445301607251167, 0.0444503016769886, 0.0443704538047314, 0.044290728867054, 0.0442110747098923, 0.0441313982009888, 0.0440518632531166, 0.043972309678793, 0.0438928529620171, 0.0438134707510471, 0.0437341332435608, 0.0436548329889774, 0.0435755848884583, 0.0434964373707771, 0.0434173047542572, 0.0433382764458656, 0.043259285390377, 0.043180339038372, 0.0431014820933342, 0.043022658675909, 0.042943898588419, 0.0428651832044125, 0.0427865423262119, 0.0427079722285271, 0.0426294505596161, 0.0425509847700596, 0.0424725748598576, 0.0423942394554615, 0.0423159077763557, 0.0422376990318298, 0.042159516364336, 0.0420814082026482, 0.0420033633708954, 0.0419253408908844, 0.0418474152684212, 0.0417695119976997, 0.0416917055845261, 0.0416139662265778, 0.0415362156927586, 0.0414585992693901, 0.0413809791207314, 0.0413034595549107, 0.0412259995937347, 0.0411485731601715, 0.0410712286829948, 0.0409939102828503, 0.040916670113802, 0.0408394932746887, 0.0407623685896397, 0.040685310959816, 0.0406082719564438, 0.0405313707888126, 0.040454488247633, 0.0403776504099369, 0.0403008833527565, 0.0402241311967373, 0.0401474833488464, 0.0400708988308907, 0.0399943701922894, 0.0399178937077522, 0.0398414470255375, 0.0397650897502899, 0.0396888144314289, 0.0396125577390194, 0.0395363681018353, 0.0394602455198765, 0.0393841750919819, 0.0393081717193127, 0.0392322055995464, 0.0391562730073929, 0.0390804558992386, 0.0390046909451485, 0.038928959518671, 0.038853332400322, 0.0387776866555214, 0.0387021601200104, 0.0386266522109509, 0.0385512262582779, 0.0384758859872818, 0.0384005643427372, 0.0383253134787083, 0.0382500886917114, 0.0381749719381332, 0.0380999036133289, 0.0380248352885246, 0.0379499234259129, 0.0378750078380108, 0.0378001593053341, 0.0377253964543343, 0.0376506373286247, 0.0375759787857533, 0.0375013686716557, 0.0374268293380737, 0.0373523384332657, 0.0372778996825218, 0.0372035317122936, 0.0371291749179363, 0.0370549410581589, 0.0369807593524456, 0.0369065925478935, 0.0368325263261795, 0.036758478730917, 0.0366845168173313, 0.0366106256842613, 0.0365367606282234, 0.03646295145154, 0.0363892279565334, 0.0363155528903008, 0.0362419150769711, 0.0361683592200279, 0.0360948704183102, 0.0360214039683342, 0.035948034375906, 0.0358747355639935, 0.0358014702796936, 0.0357282385230064, 0.0356550924479961, 0.0355820134282112, 0.0355089530348778, 0.0354359932243824, 0.0353631004691124, 0.0352902263402939, 0.0352174378931522, 0.0351446643471718, 0.0350719913840294, 0.0349993892014027, 0.0349268056452274, 0.0348543189466, 0.0347818695008755, 0.0347094759345055, 0.0346371419727802, 0.034564845263958, 0.0344926491379738, 0.0344204530119896, 0.0343484133481979, 0.0342763885855675, 0.034204363822937, 0.0341324768960476, 0.0340605713427067, 0.0339887663722038, 0.033916998654604, 0.0338453315198421, 0.0337737128138542, 0.0337021127343178, 0.0336306132376194, 0.033559150993824, 0.033487755805254, 0.0334164276719093, 0.0333451144397259, 0.0332739241421223, 0.0332027152180672, 0.0331316441297531, 0.0330606028437614, 0.0329895988106728, 0.0329186990857124, 0.0328477919101715, 0.0327769927680492, 0.0327062457799911, 0.0326355434954166, 0.0325649119913578, 0.032494317740202, 0.0324238203465939, 0.0323533602058887, 0.0322829373180866, 0.0322125926613808, 0.0321422852575779, 0.0320720970630646, 0.0320019237697124, 0.0319318026304245, 0.0318617485463619, 0.0317917317152023, 0.0317217968404293, 0.0316519476473331, 0.0315821170806885, 0.0315123684704304, 0.0314426384866238, 0.0313730128109455, 0.0313034355640411, 0.0312338937073946, 0.0311644170433283, 0.0310950111597776, 0.0310256704688072, 0.0309563837945461, 0.0308871287852526, 0.0308179780840874, 0.0307488273829222, 0.030679777264595, 0.0306107942014933, 0.030541829764843, 0.0304729677736759, 0.0304041057825089, 0.0303353611379862, 0.0302666500210762, 0.0301979891955853, 0.0301294159144163, 0.0300608798861504, 0.0299924071878195, 0.0299239996820688, 0.0298555959016085, 0.0297873131930828, 0.0297190621495247, 0.0296508949249983, 0.0295827630907297, 0.0295147001743317, 0.0294466856867075, 0.0293787233531475, 0.0293108504265547, 0.0292429905384779, 0.0291752312332392, 0.0291075389832258, 0.0290398672223091, 0.0289722625166178, 0.0289047081023455, 0.0288372226059437, 0.0287698227912188, 0.0287024546414614, 0.0286351554095745, 0.028570294380188, 0.0285083837807178, 0.0284465402364731, 0.0283846985548735, 0.0283230077475309, 0.0282613206654787, 0.0281997323036194, 0.0281382128596306, 0.028076745569706, 0.0280154123902321, 0.0279540810734034, 0.0278928168118, 0.0278316680341959, 0.0277705416083336, 0.027709549292922, 0.0276485402137041, 0.0275876317173243, 0.027526842430234, 0.0274660736322403, 0.0274053514003754, 0.0273447334766388, 0.0272842012345791, 0.0272237025201321, 0.0271632689982653, 0.0271029584109783, 0.0270426962524652, 0.0269824881106615, 0.0269223432987928, 0.0268622692674398, 0.0268022958189249, 0.0267423577606678, 0.0266824867576361, 0.0266227014362812, 0.0265629999339581, 0.0265033524483442, 0.0264437366276979, 0.0263842586427927, 0.026324812322855, 0.0262653976678848, 0.0262061432003975, 0.0261469017714262, 0.0260877422988415, 0.0260286387056112, 0.0259696003049612, 0.0259106643497944, 0.0258517805486917, 0.0257929489016533, 0.0257341992110014, 0.0256755333393812, 0.0256169382482767, 0.0255583450198174, 0.0254998989403248, 0.0254415087401867, 0.0253832023590803, 0.0253249295055866, 0.0252667088061571, 0.0252086073160172, 0.0251505728811026, 0.0250925552099943, 0.0250346548855305, 0.0249767899513245, 0.024919044226408, 0.0248612836003304, 0.0248036738485098, 0.0247461311519146, 0.0246886070817709, 0.0246311686933041, 0.0245737973600626, 0.0245165079832077, 0.0244593247771263, 0.0244021229445934, 0.0243450570851564, 0.0242880247533321, 0.0242311134934425, 0.0241742171347141, 0.0241174064576626, 0.0240606963634491, 0.0240040067583323, 0.0239474158734083, 0.0238908622413874, 0.0238344427198172, 0.0237780380994081, 0.0237216893583536, 0.0236654710024595, 0.0236092545092106, 0.0235531758517027, 0.0234971307218075, 0.0234411358833313, 0.0233852602541447, 0.0233293995261192, 0.023273628205061, 0.0232179574668407, 0.0231623202562332, 0.0231067482382059, 0.0230512302368879, 0.0229958463460207, 0.0229405146092176, 0.0228851847350597, 0.0228299722075462, 0.0227748434990644, 0.0227197837084532, 0.0226647760719061, 0.0226098336279392, 0.0225549805909395, 0.0225001554936171, 0.0224454384297132, 0.0223908182233572, 0.0223362166434526, 0.0222817026078701, 0.0222272053360939, 0.0221728421747684, 0.0221185646951199, 0.022064320743084, 0.0220101270824671, 0.0219560004770756, 0.0219019800424576, 0.0218480061739683, 0.0217941030859947, 0.0217403024435043, 0.0216865334659815, 0.0216328836977482, 0.0215792171657085, 0.0215256717056036, 0.0214722435921431, 0.0214187987148762, 0.0213654730468988, 0.0213121827691793, 0.0212589930742979, 0.0212058536708355, 0.0211527645587921, 0.0210998114198446, 0.0210468620061874, 0.0209940131753683, 0.0209412481635809, 0.0208884980529547, 0.0208358857780695, 0.0207832921296358, 0.0207307636737823, 0.0206783581525087, 0.0206259675323963, 0.0205736942589283, 0.0205214396119118, 0.0204692874103785, 0.0204172022640705, 0.0203651860356331, 0.0203132033348083, 0.0202613212168217, 0.0202095229178667, 0.0201577953994274, 0.0201060529798269, 0.0200544781982899, 0.0200029518455267, 0.0199514981359243, 0.0199000760912895, 0.0198487397283316, 0.0197975039482117, 0.0197463016957045, 0.0196951515972614, 0.0196441207081079, 0.0195931419730186, 0.0195422656834126, 0.019491370767355, 0.0194406099617481, 0.019389919936657, 0.019339244812727, 0.0192886907607317, 0.0192382037639618, 0.0191877670586109, 0.0191373825073242, 0.0190871153026819, 0.019036902114749, 0.0189867541193962, 0.0189366582781076, 0.0188866481184959, 0.0188367031514645, 0.018786845728755, 0.0187370032072067, 0.0186872985213995, 0.0186376105993986, 0.0185880418866873, 0.0185385067015886, 0.0184890404343605, 0.0184396579861641, 0.0183903276920319, 0.0183410812169313, 0.0182919204235077, 0.0182427763938904, 0.0181937851011753, 0.0181447602808475, 0.0180958714336157, 0.0180470664054155, 0.0179982781410217, 0.0179495774209499, 0.0179009437561035, 0.0178523939102888, 0.017803929746151, 0.0177554823458195, 0.0177071373909712, 0.0176588613539934, 0.0176106672734022, 0.0175625272095203, 0.0175144374370575, 0.0174664314836264, 0.0174185112118721, 0.017370643094182, 0.0173228736966848, 0.0172751266509295, 0.0172274950891733, 0.0171798467636108, 0.0171323679387569, 0.0170849226415157, 0.017037546262145, 0.0169902220368385, 0.0169429648667574, 0.0168958082795143, 0.0168486889451742, 0.016801668331027, 0.0167547352612019, 0.0167078003287315, 0.0166610032320023, 0.0166142042726278, 0.0165675599128008, 0.0165209826081991, 0.0164744034409523, 0.0164279136806726, 0.0163815040141344, 0.0163351651281118, 0.0162889454513788, 0.0162426922470331, 0.0161965731531382, 0.0161505043506622, 0.0161045417189598, 0.0160586088895798, 0.0160127468407154, 0.0159669686108828, 0.0159212239086628, 0.0158755965530872, 0.0158300399780273, 0.0157845336943865, 0.0157390795648098, 0.0156936924904585, 0.0156484246253967, 0.0156032051891088, 0.0155579894781113, 0.0155129414051771, 0.0154678942635655, 0.0154229830950499, 0.0153780886903405, 0.0153332622721791, 0.0152885382995009, 0.0152438478544354, 0.0151992253959179, 0.0151547053828835, 0.0151102533563972, 0.0150658683851361, 0.015021501109004, 0.0149772521108389, 0.014933087863028, 0.014888959005475, 0.0148449139669538, 0.0148009043186903, 0.0147570129483938, 0.0147131560370326, 0.0146693671122193, 0.0146256955340505, 0.0145820425823331, 0.0145384911447763, 0.0144949574023485, 0.0144515577703714, 0.0144082112237811, 0.0143649308010936, 0.0143217034637928, 0.0142785245552659, 0.0142354676499963, 0.0141924768686295, 0.0141494851559401, 0.0141066499054432, 0.0140638453885913, 0.0140211274847388, 0.0139784421771765, 0.0139358611777425, 0.0138933444395661, 0.0138508817180991, 0.0138084692880511, 0.013766192831099, 0.0137239163741469, 0.0136817414313555, 0.0136396186426282, 0.0135975796729326, 0.0135556431487203, 0.0135137401521206, 0.0134718893095851, 0.013430105522275, 0.0133884409442544, 0.0133468275889754, 0.0133052142336965, 0.0132637703791261, 0.0132223619148135, 0.0131809692829847, 0.0131397284567356, 0.013098506256938, 0.013057385571301, 0.0130162825807929, 0.0129753137007356, 0.012934397906065, 0.0128935165703297, 0.0128527171909809, 0.0128119718283415, 0.0127713438123465, 0.0127307493239641, 0.0126902246847749, 0.0126497838646173, 0.0126094110310078, 0.0125691238790751, 0.0125288525596261, 0.0124887013807893, 0.0124486181885004, 0.0124085675925016, 0.0123686036095023, 0.0123287066817284, 0.0122888954356313, 0.0122491689398885, 0.012209459207952, 0.0121698509901762, 0.0121302781626582, 0.0120908571407199, 0.0120514361187816, 0.0120120672509074, 0.0119728334248066, 0.0119336163625121, 0.0118944840505719, 0.0118554374203086, 0.0118164429441094, 0.011777532286942, 0.0117386383935809, 0.0116998972371221, 0.0116611896082759, 0.0116225527599454, 0.0115839475765824, 0.0115454439073801, 0.0115070268511772, 0.0114686945453286, 0.0114303603768349, 0.0113921472802758, 0.0113539677113295, 0.0113159064203501, 0.0112778814509511, 0.0112399207428098, 0.0112020643427968, 0.0111642414703965, 0.0111264875158668, 0.0110888173803687, 0.0110512161627412, 0.0110137164592743, 0.0109761813655496, 0.0109388353303075, 0.0109014715999365, 0.0108642429113388, 0.0108270505443215, 0.0107899066060781, 0.0107529005035758, 0.0107159279286861, 0.0106789888814092, 0.0106421681120992, 0.010605382733047, 0.0105686653405428, 0.0105320317670703, 0.0104955015704036, 0.010459003970027, 0.0104225240647793, 0.0103861978277564, 0.0103499060496688, 0.0103137148544192, 0.0102775581181049, 0.010241468437016, 0.0102054812014103, 0.0101695293560624, 0.0101336436346173, 0.0100978780537844, 0.0100621292367578, 0.0100264828652143, 0.00999085232615471, 0.00995534099638462, 0.0099199153482914, 0.00988452415913343, 0.0098491832613945, 0.00981394294649363, 0.00977877248078585, 0.00974368676543236, 0.00970861781388521, 0.00967368576675653, 0.00963875185698271, 0.00960393808782101, 0.00956917554140091, 0.00953446328639984, 0.00949988793581724, 0.00946529395878315, 0.00943080428987741, 0.00939641520380974, 0.00936206057667732, 0.00932782422751188, 0.0092935711145401, 0.00925943627953529, 0.00922538805752993, 0.00919137243181467, 0.00915742572396994, 0.00912358053028584, 0.00908980425447226, 0.00905606057494879, 0.00902240257710218, 0.00898882932960987, 0.00895530823618174, 0.008921904489398, 0.0088884849101305, 0.00885518360882998, 0.00882198475301266, 0.00878880266100168, 0.008755705319345, 0.00872265920042992, 0.00868971552699804, 0.00865685660392046, 0.00862399768084288, 0.00859127473086119, 0.00855856761336327, 0.00852598156780005, 0.00849342811852694, 0.00846092589199543, 0.00842857640236616, 0.00839621108025312, 0.00836394634097815, 0.00833175145089626, 0.00829962268471718, 0.00826756283640862, 0.00823557004332542, 0.00820366386324167, 0.00817184150218964, 0.00814000237733126, 0.00810831598937511, 0.00807668082416058, 0.00804513040930033, 0.008013597689569, 0.0079821664839983, 0.00795082002878189, 0.00791950803250074, 0.00788826402276754, 0.00785712152719498, 0.00782603025436401, 0.00779504096135497, 0.00776405213400722, 0.00773319927975535, 0.00770237948745489, 0.00767167937010527, 0.00764097971841693, 0.00761036388576031, 0.00757985096424818, 0.00754938926547766, 0.00751897785812616, 0.00748866889625788, 0.00745841022580862, 0.00742823723703623, 0.00739808101207018, 0.00736807798966765, 0.0073381089605391, 0.00730817345902324, 0.00727834040299058, 0.0072485413402319, 0.00721886055544019, 0.00718926498666406, 0.00715966988354921, 0.00713017676025629, 0.00710076885297894, 0.0070714452303946, 0.00704213883727789, 0.00701291719451547, 0.00698378123342991, 0.00695469602942467, 0.00692567927762866, 0.00689676403999329, 0.0068678823299706, 0.00683911982923746, 0.00681032380089164, 0.00678169680759311, 0.00675313919782639, 0.00672459742054343, 0.00669612409546971, 0.00666773598641157, 0.00663943309336901, 0.00661121448501945, 0.00658301264047623, 0.0065549137070775, 0.0065268655307591, 0.00649893609806895, 0.00647102389484644, 0.00644317967817187, 0.00641543744131923, 0.00638769520446658, 0.00636010570451617, 0.00633258419111371, 0.00630507944151759, 0.00627765990793705, 0.00625197682529688, 0.00622802507132292, 0.00620412407442927, 0.00618023239076138, 0.0061564426869154, 0.00613269442692399, 0.0061089638620615, 0.0060852668248117, 0.0060616391710937, 0.00603806087747216, 0.00601453427225351, 0.00599102536216378, 0.00596757465973496, 0.00594419240951538, 0.0059208357706666, 0.00589749636128545, 0.00587425893172622, 0.00585102150216699, 0.00582786835730076, 0.00580471567809582, 0.00578164821490645, 0.00575863150879741, 0.00573565764352679, 0.00571266608312726, 0.00568978581577539, 0.00566693907603621, 0.00564414355903864, 0.00562136434018612, 0.00559865403920412, 0.00557597680017352, 0.00555337686091661, 0.00553078530356288, 0.00550825288519263, 0.00548577215522528, 0.00546335941180587, 0.00544092059135437, 0.00541860098019242, 0.00539631443098187, 0.00537404604256153, 0.00535182887688279, 0.00532967923209071, 0.00530756311491132, 0.00528550706803799, 0.00526345102116466, 0.00524147087708116, 0.00521955918520689, 0.00519768195226789, 0.00517580378800631, 0.00515401130542159, 0.00513228634372354, 0.00511057861149311, 0.00508890487253666, 0.00506729958578944, 0.00504574459046125, 0.00502422405406833, 0.00500273704528809, 0.00498129287734628, 0.00495992554351687, 0.00493859965354204, 0.00491728307679296, 0.00489605125039816, 0.00487483665347099, 0.00485370680689812, 0.00483257742598653, 0.00481153232976794, 0.00479052169248462, 0.00476952781900764, 0.0047486019320786, 0.00472774403169751, 0.00470692059025168, 0.00468609714880586, 0.00466535799205303, 0.00464468728750944, 0.00462403334677219, 0.00460342224687338, 0.00458287913352251, 0.00456234393641353, 0.00454190280288458, 0.00452146120369434, 0.0045010969042778, 0.00448077451437712, 0.00446050334721804, 0.00444024009630084, 0.00442006252706051, 0.00439992733299732, 0.00437982613220811, 0.00435975845903158, 0.00433975923806429, 0.0043197856284678, 0.0042998967692256, 0.00428002467378974, 0.00426018703728914, 0.00424041692167521, 0.00422069849446416, 0.00420097960159183, 0.00418136268854141, 0.00416177976876497, 0.00414221407845616, 0.00412269914522767, 0.00410325219854712, 0.00408385647460818, 0.00406449474394321, 0.0040451493114233, 0.00402588164433837, 0.00400667218491435, 0.00398750603199005, 0.00396833987906575, 0.00394925801083446, 0.00393023667857051, 0.00391123164445162, 0.00389226083643734, 0.00387335754930973, 0.00385451433248818, 0.00383572210557759, 0.00381693826057017, 0.00379818817600608, 0.00377952330745757, 0.0037609008140862, 0.0037423123139888, 0.00372378365136683, 0.00370527151972055, 0.00368684460408986, 0.00366842607036233, 0.00365007598884404, 0.00363177643157542, 0.00361353624612093, 0.00359527138061821, 0.00357711617834866, 0.00355899520218372, 0.00354092544876039, 0.00352287222631276, 0.00350488745607436, 0.00348693644627929, 0.00346901966258883, 0.00345119601115584, 0.0034333982039243, 0.00341565138660371, 0.00339791271835566, 0.00338023388758302, 0.00336264842189848, 0.00334508833475411, 0.00332752009853721, 0.00331003637984395, 0.00329262111335993, 0.00327523960731924, 0.00325786648318172, 0.00324059557169676, 0.00322330766357481, 0.00320612988434732, 0.00318895257078111, 0.00317183462902904, 0.00315477605909109, 0.00313776032999158, 0.00312073552049696, 0.00310383015312254, 0.00308696692809463, 0.00307011255063117, 0.00305330031551421, 0.0030365651473403, 0.00301986373960972, 0.00300322170369327, 0.00298657943494618, 0.00297001400031149, 0.0029535077046603, 0.00293703586794436, 0.00292058079503477, 0.00290421093814075, 0.00288789160549641, 0.00287161534652114, 0.00285533862188458, 0.00283913873136044, 0.00282300659455359, 0.00280690868385136, 0.00279082730412483, 0.00277479761280119, 0.00275886105373502, 0.00274293264374137, 0.00272703869268298, 0.00271122134290636, 0.00269542075693607, 0.00267969653941691, 0.00266399793326855, 0.00264834193512797, 0.00263276230543852, 0.00261721666902304, 0.0026016712654382, 0.00258621922694147, 0.00257081771269441, 0.00255544227547944, 0.00254008383490145, 0.00252481014467776, 0.00250958767719567, 0.00249439897015691, 0.00247922725975513, 0.00246414938010275, 0.00244911364279687, 0.00243412051349878, 0.00241911062039435, 0.00240421923808753, 0.00238935369998217, 0.00237453891895711, 0.00235975836403668, 0.0023450287990272, 0.00233034160919487, 0.00231568864546716, 0.00230111181735992, 0.00228656083345413, 0.00227206060662866, 0.00225759437307715, 0.00224317936226726, 0.00222884048707783, 0.00221452745608985, 0.00220022280700505, 0.00218601152300835, 0.00217185146175325, 0.00215770839713514, 0.00214360770769417, 0.00212957500480115, 0.00211558490991592, 0.00210163719020784, 0.00208768947049975, 0.00207386096008122, 0.00206006621010602, 0.00204629683867097, 0.00203253631480038, 0.00201888591982424, 0.00200526136904955, 0.00199167896062136, 0.0019781393930316, 0.00196463358588517, 0.00195119599811733, 0.00193781778216362, 0.00192442268598825, 0.00191112945321947, 0.00189788709394634, 0.00188466184772551, 0.00187147920951247, 0.00185838143806905, 0.00184528366662562, 0.00183227111119777, 0.00181925820652395, 0.00180632201954722, 0.00179343670606613, 0.00178060261532664, 0.00176776840817183, 0.00175501906778663, 0.00174232083372772, 0.00172965659294277, 0.00171701773069799, 0.00170445558615029, 0.0016919441986829, 0.00167945004068315, 0.00166700687259436, 0.00165461446158588, 0.00164228165522218, 0.00162999995518476, 0.00161770125851035, 0.00160550430882722, 0.0015933585818857, 0.00158126384485513, 0.00156916899140924, 0.00155715073924512, 0.00154517497867346, 0.00153326708823442, 0.00152133381925523, 0.00150951952673495, 0.00149773072917014, 0.00148595042992383, 0.00147426361218095, 0.00146261078771204, 0.00145100895315409, 0.00143942411523312, 0.0014279157621786, 0.0014164331369102, 0.00140502664726228, 0.00139362039044499, 0.00138229911681265, 0.00137100322172046, 0.00135977531317621, 0.00134853890631348, 0.0013374132104218, 0.00132632988970727, 0.00131527206394821, 0.00130423111841083, 0.00129327527247369, 0.00128234492149204, 0.00127149955369532, 0.0012606541858986, 0.00124984281137586, 0.00123912503477186, 0.0012284325202927, 0.00121775723528117, 0.00120718393009156, 0.00119663600344211, 0.00118611357174814, 0.00117563374806195, 0.00116523029282689, 0.00115485244896263, 0.00114455097354949, 0.00113425811287016, 0.0011240077437833, 0.00111383385956287, 0.00110371096525341, 0.00109357107430696, 0.00108355865813792, 0.00107356323860586, 0.00106358481571078, 0.00105365738272667, 0.001043806434609, 0.00103399809449911, 0.00102422351483256, 0.00101446616463363, 0.00100477680098265, 0.000995172304101288, 0.000985593418590724, 0.000976005918346345, 0.000966512074228376, 0.000957077543716878, 0.000947677122894675, 0.000938285200390965, 0.000928969762753695, 0.000919713755138218, 0.000910500297322869, 0.000901286897715181, 0.000892166863195598, 0.000883097935002297, 0.000874054443556815, 0.000865036563482136, 0.0008561119902879, 0.000847187591716647, 0.000838365114759654, 0.000829525582958013, 0.000820762594230473, 0.000812050653621554, 0.000803355651441962, 0.000794737134128809, 0.000786161166615784, 0.000777644687332213, 0.000769102713093162, 0.000760671158786863, 0.000752299092710018, 0.000743944197893143, 0.000735614681616426, 0.000727353151887655, 0.000719142612069845, 0.00071099161868915, 0.000702857621945441, 0.000694766000378877, 0.000686742539983243, 0.000678787007927895, 0.00067081447923556, 0.000662926933728158, 0.000655098876450211, 0.000647296372335404, 0.000639510806649923, 0.00063181872246787, 0.000624143751338124, 0.000616553646977991, 0.000608955102507025, 0.000601424544584006, 0.000593953474890441, 0.000586533453315496, 0.000579113373532891, 0.000571786775253713, 0.000564485730137676, 0.000557235616724938, 0.000550019554793835, 0.000542854482773691, 0.000535765953827649, 0.000528711301740259, 0.00052163127111271, 0.000514678657054901, 0.00050776859279722, 0.000500883965287358, 0.000494016392622143, 0.000487233774038032, 0.000480493705254048, 0.000473804568173364, 0.000467123987618834, 0.000460519862826914, 0.000453975226264447, 0.000447456113761291, 0.000440953997895122, 0.00043454539263621, 0.000428179220762104, 0.000421847129473463, 0.000415540474932641, 0.000409310392569751, 0.000403105746954679, 0.000396977615309879, 0.000390840985346586, 0.000384789309464395, 0.000378797150915489, 0.000372830516425893, 0.00036687235115096, 0.000361024722224101, 0.000355211057467386, 0.000349414418451488, 0.00034364327439107, 0.000337974110152572, 0.000332330411765724, 0.000326754758134484, 0.00032117057708092, 0.000315671408316121, 0.000310223229462281, 0.000304783548926935, 0.000299403356621042, 0.00029409967828542, 0.000288838462438434, 0.000283560279058293, 0.000278392602922395, 0.00027325889095664, 0.000268167670583352, 0.000263093475950882, 0.000258104293607175, 0.000253140577115119, 0.000248244876274839, 0.000243366157519631, 0.000238546941545792, 0.000233795726671815, 0.000229069992201403, 0.000224344272282906, 0.000219737557927147, 0.00021513931278605, 0.000210609083296731, 0.000206070355488919, 0.000201625109184533, 0.000197239380213432, 0.000192896128282882, 0.000188544378033839, 0.000184286138392054, 0.000180078874109313, 0.000175897133885883, 0.000171749372384511, 0.000167686608619988, 0.000163640856044367, 0.000159654577146284, 0.000155693807755597, 0.000151775559061207, 0.000147942278999835, 0.000144142992212437, 0.000140335236210376, 0.000136629460030235, 0.000132974673761055, 0.000129345367895439, 0.000125750084407628, 0.000122214303701185, 0.000118729491077829, 0.000115312715934124, 0.000111887398816179, 0.00010853010462597, 0.000105249295302201, 0.000101993980933912, 9.8738688393496e-05, 9.55938739934936e-05, 9.24915511859581e-05, 8.94147378858179e-05, 8.63549066707492e-05, 8.33800877444446e-05, 8.04392548161559e-05, 7.75664229877293e-05, 7.47021040297113e-05, 7.18887604307383e-05, 6.91519308020361e-05, 6.64575782138854e-05, 6.376324017765e-05, 6.11538998782635e-05, 5.85870438953862e-05, 5.60456974199042e-05, 5.35723411303479e-05, 5.11329890287016e-05, 4.87616271129809e-05, 4.64072691102047e-05, 4.40954026998952e-05, 4.18600357079413e-05, 3.96756622649264e-05, 3.74742921849247e-05, 3.53919131157454e-05, 3.33180360030383e-05, 3.12951524392702e-05, 2.93147750198841e-05, 2.73853856924688e-05, 2.55069971899502e-05, 2.36881060118321e-05, 2.18777095142286e-05, 2.0109813704039e-05, 1.84354139491916e-05, 1.67950111062964e-05, 1.51461072164238e-05, 1.3616196156363e-05, 1.21117873277399e-05, 1.06328743640915e-05, 9.19645844987826e-06, 7.81104063207749e-06, 6.49361709292862e-06, 5.21019319421612e-06, 3.95226697946782e-06, 2.74533795163734e-06, 1.61490481787041e-06, 5.26968904068781e-07, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 1.20685370791823e-15, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 0.000603426829911768, 2.00588169718685e-06, 7.7005461207591e-06, 1.3429208593152e-05, 1.91408707905794e-05, 2.49205331783742e-05, 3.07341906591319e-05, 3.6530847864924e-05, 4.23954988946207e-05, 4.82771538372617e-05, 5.41588087799028e-05, 6.01084611844271e-05, 6.60751029499806e-05, 7.2024755354505e-05, 7.80593982199207e-05, 8.41110449982807e-05, 9.01626845006831e-05, 9.62823251029477e-05, 0.000102367965155281, 0.000108538602944463, 0.000114726237370633, 0.000120913871796802, 0.000127152510685846, 0.000133425128296949, 0.000139697760459967, 0.00014602139708586, 0.000152379012433812, 0.000158719645696692, 0.000165128280059434, 0.000171570893144235, 0.000178013506229036, 0.000184490127139725, 0.000191017752513289, 0.000197528352146037, 0.000204106967430562, 0.00021071957598906, 0.0002172982058255, 0.000223961789743043, 0.000230642399401404, 0.000237323009059764, 0.000244071619817987, 0.000250837212661281, 0.000257585808867589, 0.00026441941736266, 0.000271270022494718, 0.00027810360188596, 0.000285005196928978, 0.0002919408143498, 0.000298876373562962, 0.000305862980894744, 0.000312866555759683, 0.000319870159728453, 0.000326941721141338, 0.000334047334035859, 0.000341135892085731, 0.000348275469150394, 0.000355466065229848, 0.000362639606464654, 0.000369881192455068, 0.000377122778445482, 0.000384381331969053, 0.000391707930248231, 0.000399051466956735, 0.000406395032769069, 0.000413789617596194, 0.000421218166593462, 0.000428629748057574, 0.000436126283602789, 0.000443622877355665, 0.00045111941290088, 0.000458683964097872, 0.000466282537672669, 0.000473881082143635, 0.000481513619888574, 0.000489146157633513, 0.000496863736771047, 0.00050458125770092, 0.000512298836838454, 0.000520084344316274, 0.000527903903275728, 0.000535706407390535, 0.000543576956260949, 0.000551464501768351, 0.000559352047275752, 0.0005673075793311, 0.000575280108023435, 0.000583235640078783, 0.000591276155319065, 0.000599333667196333, 0.000607391237281263, 0.000615499680861831, 0.000623642292339355, 0.00063176779076457, 0.000639978272374719, 0.000648205808829516, 0.000656399352010339, 0.000664677878376096, 0.000672990339808166, 0.000681302859447896, 0.000689666310790926, 0.000698029878549278, 0.000706427381373942, 0.000714875815901905, 0.000723341421689838, 0.000731789856217802, 0.00074032339034602, 0.000748873804695904, 0.00075742433546111, 0.000766042852774262, 0.000774661311879754, 0.000783296825829893, 0.000791983329690993, 0.000800703768618405, 0.000809407327324152, 0.000818178814370185, 0.000826984236482531, 0.000835789775010198, 0.000844646245241165, 0.000853485718835145, 0.000862393178977072, 0.000871334632392973, 0.000880276144016534, 0.000889251590706408, 0.000898278027307242, 0.00090728752547875, 0.000916365010198206, 0.000925476488191634, 0.000934553914703429, 0.000943716382607818, 0.00095291284378618, 0.000962092308327556, 0.000971322704572231, 0.000980587210506201, 0.00098985165823251, 0.00099916709586978, 0.00100853363983333, 0.00101786607410759, 0.00102726649492979, 0.00103670090902597, 0.00104613532312214, 0.00105562072712928, 0.00106512324418873, 0.00107462564483285, 0.00108421314507723, 0.00109380052890629, 0.00110338791273534, 0.00111304339952767, 0.00112271588295698, 0.00113238824997097, 0.00114212871994823, 0.00115188618656248, 0.0011616435367614, 0.00117145199328661, 0.00118131132330745, 0.00119115377310663, 0.00120103021617979, 0.0012109576491639, 0.00122088496573269, 0.00123086338862777, 0.00124087592121214, 0.0012508713407442, 0.0012609347468242, 0.00127103214617819, 0.00128112954553217, 0.0012912608217448, 0.00130142632406205, 0.00131160870660096, 0.00132184207905084, 0.00133207556791604, 0.00134232582058758, 0.00135264429263771, 0.00136299675796181, 0.00137333199381828, 0.00138370145577937, 0.00139413878787309, 0.00140454224310815, 0.00141503068152815, 0.00142548501025885, 0.00143602432217449, 0.00144658074714243, 0.00145713717211038, 0.00146774458698928, 0.00147838587872684, 0.00148901029024273, 0.00149971968494356, 0.00151044607628137, 0.00152115535456687, 0.00153193273581564, 0.00154274399392307, 0.00155353848822415, 0.00156440073624253, 0.00157528009731323, 0.00158615957479924, 0.00159710692241788, 0.00160808826331049, 0.00161903561092913, 0.0016300679417327, 0.00164111738558859, 0.00165216671302915, 0.00166328391060233, 0.00167440134100616, 0.00168553565163165, 0.00169672095216811, 0.00170794036239386, 0.0017191426595673, 0.00173042993992567, 0.00174171733669937, 0.00175302173011005, 0.00176437699701637, 0.00177574926055968, 0.00178712164051831, 0.00179856200702488, 0.00181003625039011, 0.00182147661689669, 0.0018330019665882, 0.00184456130955368, 0.00185610353946686, 0.0018677138723433, 0.00187932420521975, 0.0018909516511485, 0.00190264685079455, 0.00191432517021894, 0.0019260544795543, 0.00193781778216362, 0.00194958108477294, 0.00196141237393022, 0.00197326065972447, 0.00198509194888175, 0.00199699145741761, 0.0020089247263968, 0.00202085799537599, 0.00203284225426614, 0.00204486050643027, 0.00205686176195741, 0.00206891400739551, 0.0020810344722122, 0.00209312071092427, 0.00210527493618429, 0.00211744615808129, 0.00212961761280894, 0.0021418568212539, 0.00215411302633584, 0.00216638646088541, 0.00217869365587831, 0.00219103484414518, 0.00220335926860571, 0.00221576844342053, 0.00222819461487234, 0.0022406040225178, 0.00225309818051755, 0.00226559257134795, 0.00227812072262168, 0.00229066610336304, 0.00230324524454772, 0.00231584161520004, 0.00232848874293268, 0.00234117009676993, 0.00235383422113955, 0.00236654956825078, 0.00237931567244232, 0.00239206501282752, 0.00240488233976066, 0.00241771643050015, 0.0024305337574333, 0.00244343606755137, 0.0024563551414758, 0.00246925745159388, 0.00248224474489689, 0.0024952320381999, 0.00250825332477689, 0.0025213083717972, 0.00253438064828515, 0.00254746992141008, 0.00256059295497835, 0.00257378444075584, 0.00258694170042872, 0.00260014971718192, 0.0026133747305721, 0.00262665119953454, 0.00263997842557728, 0.00265325442887843, 0.0026665988843888, 0.00268001109361649, 0.00269337208010256, 0.00270681828260422, 0.00272029847837985, 0.0027337446808815, 0.00274729309603572, 0.00276084104552865, 0.00277437246404588, 0.00278798886574805, 0.00280162179842591, 0.00281527196057141, 0.00282893911935389, 0.00284264050424099, 0.00285637564957142, 0.00287014478817582, 0.0028839479200542, 0.00289773428812623, 0.00291157118044794, 0.00292547675780952, 0.00293934787623584, 0.00295326998457313, 0.00296724308282137, 0.00298119941726327, 0.00299524050205946, 0.00300926459021866, 0.0030233059078455, 0.00303741497918963, 0.0030515412800014, 0.00306568434461951, 0.00307984440587461, 0.00309405568987131, 0.00310826674103737, 0.00312252901494503, 0.00313684204593301, 0.00315112131647766, 0.00316545134410262, 0.00317984982393682, 0.00319419684819877, 0.00320862885564566, 0.00322306109592319, 0.00323754432611167, 0.00325207854621112, 0.00326656131073833, 0.00328112975694239, 0.00329574872739613, 0.00331031694076955, 0.0033249871339649, 0.0033396570943296, 0.00335431029088795, 0.00336906546726823, 0.00338382064364851, 0.00339859258383512, 0.00341339875012636, 0.00342822191305459, 0.00344307906925678, 0.00345797021873295, 0.00347287836484611   }, 
   { 0.00389450415968895, 0.00388483074493706, 0.00387515733018517, 0.00386561150662601, 0.00385598046705127, 0.00384656293317676, 0.00383710255846381, 0.00382759934291244, 0.00381822418421507, 0.00380880618467927, 0.00379947363398969, 0.0037901836913079, 0.00378085114061832, 0.00377168878912926, 0.0037624416872859, 0.00375332217663527, 0.00374420266598463, 0.003735083155334, 0.00372604862786829, 0.00371697195805609, 0.00370802287943661, 0.0036990309599787, 0.00369020993821323, 0.00368126085959375, 0.00367248221300542, 0.00366357574239373, 0.00365488254465163, 0.00364614650607109, 0.0036374528426677, 0.00362875964492559, 0.00362006621435285, 0.00361150084063411, 0.00360289285890758, 0.00359445507638156, 0.0035860170610249, 0.00357749429531395, 0.00356905674561858, 0.00356070417910814, 0.00355235184542835, 0.00354408449493349, 0.00353573192842305, 0.00352755025960505, 0.00351928290911019, 0.00351118622347713, 0.00350304646417499, 0.00349494977854192, 0.00348685309290886, 0.00347884162329137, 0.00347082992084324, 0.00346286129206419, 0.00345502002164721, 0.00344705116003752, 0.00343929533846676, 0.003431411460042, 0.00342369824647903, 0.00341594242490828, 0.00340818660333753, 0.00340055860579014, 0.00339284539222717, 0.00338530261069536, 0.0033778022043407, 0.0033702168148011, 0.00336275948211551, 0.00335525907576084, 0.00334784435108304, 0.00334047223441303, 0.00333309988491237, 0.00332585535943508, 0.00331848300993443, 0.00331132370047271, 0.00330407917499542, 0.00329691986553371, 0.00328976078890264, 0.00328264385461807, 0.00327556999400258, 0.00326853874139488, 0.00326154986396432, 0.00325456098653376, 0.003247742773965, 0.00324075389653444, 0.00323397829197347, 0.00322711723856628, 0.0032203842420131, 0.00321360840462148, 0.00320683280006051, 0.00320022762753069, 0.00319353700615466, 0.00318697444163263, 0.00318045448511839, 0.00317389145493507, 0.00316737173125148, 0.00316089414991438, 0.00315445940941572, 0.00314810988493264, 0.00314171775244176, 0.00313545321114361, 0.00312910368666053, 0.0031229245942086, 0.00311670289374888, 0.00311052356846631, 0.00310434447601438, 0.00309825083240867, 0.0030921995639801, 0.00308614829555154, 0.00308018224313855, 0.00307417358271778, 0.00306829274632037, 0.00306236906908453, 0.0030565308406949, 0.00305069307796657, 0.00304493983276188, 0.00303914421238005, 0.00303339143283665, 0.00302776601165533, 0.00302214128896594, 0.00301651610061526, 0.00301097612828016, 0.00300539354793727, 0.00299989618360996, 0.00299444166012108, 0.00298898690380156, 0.00298366020433605, 0.00297820544801652, 0.00297296396456659, 0.00296763703227043, 0.00296239531598985, 0.0029571964405477, 0.00295199756510556, 0.00294684106484056, 0.00294172717258334, 0.0029366563539952, 0.00293158506974578, 0.00292664184235036, 0.00292161316610873, 0.00291675515472889, 0.00291181169450283, 0.00290699629113078, 0.00290213827975094, 0.00289728026837111, 0.00289259292185307, 0.00288781989365816, 0.00288317492231727, 0.00287857255898416, 0.00287392758764327, 0.00286941044032574, 0.00286480784416199, 0.0028602909296751, 0.00285581639036536, 0.00285134185105562, 0.00284703774377704, 0.00284260581247509, 0.00283834454603493, 0.00283404043875635, 0.00282977893948555, 0.00282551744021475, 0.00282134115695953, 0.00281720771454275, 0.00281307403929532, 0.00280898297205567, 0.00280493451282382, 0.00280097126960754, 0.00279692304320633, 0.00279308785684407, 0.00278912438079715, 0.00278528919443488, 0.00278145400807261, 0.00277757598087192, 0.00277386861853302, 0.00277011841535568, 0.00276649626903236, 0.00276287388987839, 0.00275920913554728, 0.00275562959723175, 0.00275209243409336, 0.00274855550378561, 0.00274510378949344, 0.00274160923436284, 0.00273828534409404, 0.00273483362980187, 0.002731594722718, 0.00272827106527984, 0.00272498955018818, 0.00272175087593496, 0.00271855457685888, 0.00271540135145187, 0.00271229050122201, 0.00270926463417709, 0.00270615378394723, 0.00270321336574852, 0.00270014512352645, 0.00269724754616618, 0.00269434973597527, 0.00269149453379214, 0.00268863956443965, 0.00268578412942588, 0.00268305675126612, 0.00268037198111415, 0.00267764483578503, 0.00267504551447928, 0.00267236051149666, 0.00266976119019091, 0.0026672042440623, 0.00266468990594149, 0.00266226078383625, 0.00265974667854607, 0.00265740277245641, 0.0026550164911896, 0.00265271542593837, 0.0026503715198487, 0.00264811282977462, 0.00264589698053896, 0.00264368089847267, 0.0026415076572448, 0.00263937679119408, 0.00263737421482801, 0.00263524311594665, 0.00263328314758837, 0.00263123749755323, 0.0026293199043721, 0.00262740231119096, 0.00262548471800983, 0.00262369471602142, 0.00262181973084807, 0.00262011494487524, 0.00261845323257148, 0.0026167060714215, 0.00261508650146425, 0.00261338194832206, 0.00261180521920323, 0.00261022849008441, 0.00260869436897337, 0.0026072880718857, 0.00260575395077467, 0.00260443286970258, 0.00260302657261491, 0.00260170549154282, 0.00260038464330137, 0.00259910593740642, 0.00259787030518055, 0.00259663444012403, 0.00259552639909089, 0.00259433314204216, 0.00259331078268588, 0.00259220250882208, 0.0025912222918123, 0.00259019946679473, 0.00258930469863117, 0.00258836732245982, 0.00258742971345782, 0.00258662016130984, 0.002585852984339, 0.00258504319936037, 0.00258436147123575, 0.00258359429426491, 0.00258291256614029, 0.00258231582120061, 0.00258167670108378, 0.00258116540499032, 0.00258061150088906, 0.00258018542081118, 0.00257963128387928, 0.00257929041981697, 0.00257890694774687, 0.00257856585085392, 0.00257822498679161, 0.00257792673073709, 0.00257771369069815, 0.00257750041782856, 0.00257741520181298, 0.00257720216177404, 0.00257715955376625, 0.00257703172974288, 0.00257707433775067, 0.00257703172974288, 0.00257711694575846, 0.00257715955376625, 0.00257724476978183, 0.00257741520181298, 0.00257762847468257, 0.00257784128189087, 0.00257813977077603, 0.00257839541882277, 0.00257869367487729, 0.00257907737977803, 0.00257946085184813, 0.00257997214794159, 0.00258035585284233, 0.00258095213212073, 0.00258146366104484, 0.00258206017315388, 0.00258265691809356, 0.00258329603821039, 0.00258397799916565, 0.00258470233529806, 0.00258542667143047, 0.0025862364564091, 0.0025871314574033, 0.0025878984015435, 0.00258887861855328, 0.0025897310115397, 0.00259075383655727, 0.00259173358790576, 0.00259275641292334, 0.00259386468678713, 0.00259501487016678, 0.00259612314403057, 0.00259735877625644, 0.00259850965812802, 0.00259983050636947, 0.00260106660425663, 0.00260234484449029, 0.00260370853357017, 0.00260511483065784, 0.00260660634376109, 0.00260801264084876, 0.00260958936996758, 0.00261112349107862, 0.00261265761218965, 0.00261427671648562, 0.00261589628644288, 0.00261760083958507, 0.0026193056255579, 0.00262109516188502, 0.00262279994785786, 0.00262471754103899, 0.00262650707736611, 0.00262846751138568, 0.00263034272938967, 0.00263234530575573, 0.0026343057397753, 0.00263630854897201, 0.00263839680701494, 0.00264057004824281, 0.00264270091429353, 0.00264491676352918, 0.00264709000475705, 0.00264930608682334, 0.00265160715207458, 0.00265390845015645, 0.00265633757226169, 0.00265863863751292, 0.00266115297563374, 0.00266353948973119, 0.00266605359502137, 0.00266861054114997, 0.00267112487927079, 0.00267376680858433, 0.00267645157873631, 0.00267909374088049, 0.00268182111904025, 0.00268454849720001, 0.00268731825053692, 0.00269021629355848, 0.00269298604689538, 0.00269592646509409, 0.00269882427528501, 0.0027018073014915, 0.00270479009486735, 0.00270777335390449, 0.00271092681214213, 0.00271395244635642, 0.00271714851260185, 0.00272030220367014, 0.00272349803708494, 0.00272673671133816, 0.00273001822642982, 0.00273334188386798, 0.00273666600696743, 0.00274007511325181, 0.00274348421953619, 0.00274697877466679, 0.0027504307217896, 0.0027539674192667, 0.00275758956559002, 0.00276112672872841, 0.00276479148305953, 0.00276845647022128, 0.00277220644056797, 0.0027759566437453, 0.00277970684692264, 0.0027835420332849, 0.00278733461163938, 0.00279125524684787, 0.00279513304121792, 0.00279913912527263, 0.00280310213565826, 0.00280715036205947, 0.00281119905412197, 0.00281533249653876, 0.0028194235637784, 0.00282359984703362, 0.0028277758974582, 0.00283203739672899, 0.00283629889599979, 0.00284064561128616, 0.00284499232657254, 0.00284933880902827, 0.00285377074033022, 0.00285824527963996, 0.0028627198189497, 0.00286723696626723, 0.00287183932960033, 0.0028763993177563, 0.00288104428909719, 0.00288564641959965, 0.00289041944779456, 0.00289519224315882, 0.00289992243051529, 0.00290473783388734, 0.00290955323725939, 0.00291445408947766, 0.00291939754970372, 0.00292434054426849, 0.00292936898767948, 0.00293431244790554, 0.00293942610733211, 0.00294449715875089, 0.00294961105100811, 0.00295476731844246, 0.00295996642671525, 0.00296525051817298, 0.00297049200162292, 0.00297581893391907, 0.00298110325820744, 0.00298651540651917, 0.00299192732200027, 0.00299738207831979, 0.0030028794426471, 0.00300837680697441, 0.00301395915448666, 0.00301954173482955, 0.00302516669034958, 0.00303087686188519, 0.00303650228306651, 0.00304229790344834, 0.00304800807498395, 0.00305384630337358, 0.00305964215658605, 0.00306556536816061, 0.00307144620455801, 0.003077412256971, 0.00308342091739178, 0.00308938673697412, 0.00309548084624112, 0.00310153211466968, 0.00310766859911382, 0.0031138479243964, 0.00312002655118704, 0.00312624871730804, 0.0031325554009527, 0.00313886255025864, 0.00314516946673393, 0.00315156159922481, 0.00315795373171568, 0.00316443131305277, 0.00317090866155922, 0.00317738601006567, 0.0031839485745877, 0.00319051137194037, 0.00319715938530862, 0.00320384977385402, 0.00321053992956877, 0.00321727339178324, 0.00322400638833642, 0.00323082460090518, 0.00323764304630458, 0.00324450409971178, 0.00325140752829611, 0.00325835356488824, 0.0032653424423188, 0.00327233155258, 0.00327940541319549, 0.00328647950664163, 0.00329359597526491, 0.00330079789273441, 0.00330795720219612, 0.00331520172767341, 0.00332244602032006, 0.00332973315380514, 0.003337062895298, 0.00334443524479866, 0.00335185020230711, 0.00335926515981555, 0.00336676510050893, 0.00337426550686359, 0.00338185089640319, 0.00338943605311215, 0.00339702144265175, 0.00340469228103757, 0.0034123626537621, 0.00342011847533286, 0.00342783192172647, 0.00343567319214344, 0.00344347138889134, 0.00345131265930831, 0.00345928152091801, 0.00346716516651213, 0.00347517663612962, 0.00348318833857775, 0.00349119957536459, 0.00349929672665894, 0.003507393412292, 0.00351557531394064, 0.00352375744841993, 0.00353198172524571, 0.00354020646773279, 0.00354855903424323, 0.00355682638473809, 0.00356522155925632, 0.00357361626811326, 0.00358205405063927, 0.00359057704918087, 0.00359901459887624, 0.00360762281343341, 0.00361623102799058, 0.00362475402653217, 0.00363344722427428, 0.00364205543883145, 0.00365083408541977, 0.00365952751599252, 0.00366839114576578, 0.00367716979235411, 0.00368603388778865, 0.00369498296640813, 0.00370384659618139, 0.00371288089081645, 0.00372187257744372, 0.00373090663924813, 0.00373998377472162, 0.00374910328537226, 0.00375826517120004, 0.00376742775551975, 0.00377663224935532, 0.00378587958402932, 0.00379521213471889, 0.00380450207740068, 0.00381387746892869, 0.00382329523563385, 0.00383271300233901, 0.00384217360988259, 0.00385163398459554, 0.00386122241616249, 0.0038708106148988, 0.00388039881363511, 0.003890072228387, 0.0038997030351311, 0.00390946213155985, 0.00391917815431952, 0.00392893655225635, 0.00393882347270846, 0.00394862471148372, 0.00395855400711298, 0.00396848330274224, 0.00397845497354865, 0.00398846948519349, 0.00399848353117704, 0.00400854088366032, 0.00401864061132073, 0.00402882555499673, 0.00403896765783429, 0.00404919497668743, 0.00405942276120186, 0.00406973576173186, 0.00408004783093929, 0.00409040367230773, 0.00410084379836917, 0.00411119917407632, 0.00412172544747591, 0.00413220841437578, 0.00414269138127565, 0.00415334524586797, 0.00416387105360627, 0.00417456729337573, 0.00418517831712961, 0.00419595977291465, 0.00420665601268411, 0.00421743746846914, 0.00422830414026976, 0.00423908606171608, 0.00424999510869384, 0.00426094699651003, 0.00427189888432622, 0.00428289361298084, 0.00429388787597418, 0.00430501066148281, 0.00431609014049172, 0.00432721292600036, 0.00433837762102485, 0.0043496279977262, 0.00436087790876627, 0.00437212875112891, 0.00438346387818456, 0.00439479947090149, 0.004406220279634, 0.00441759824752808, 0.00442906189709902, 0.00444061029702425, 0.0044520734809339, 0.00446366472169757, 0.00447525596246123, 0.00448693241924047, 0.00449852319434285, 0.00451028486713767, 0.00452204653993249, 0.00453380821272731, 0.00454561226069927, 0.00455741677433252, 0.0045693488791585, 0.00458128098398447, 0.00459321308881044, 0.00460522994399071, 0.00461724773049355, 0.00462930742651224, 0.00464136712253094, 0.00465355534106493, 0.00466565787792206, 0.00467793084681034, 0.00469016097486019, 0.00470239156857133, 0.00471474975347519, 0.00472706509754062, 0.0047394665889442, 0.00475190952420235, 0.00476435292512178, 0.00477688200771809, 0.00478932540863752, 0.00480193924158812, 0.00481446785852313, 0.0048271669074893, 0.00483978120610118, 0.00485247978940606, 0.0048652645200491, 0.0048780064098537, 0.00489083305001259, 0.0049037029966712, 0.00491657247766852, 0.00492948479950428, 0.00494239712134004, 0.00495543703436852, 0.00496843457221985, 0.00498151686042547, 0.00499455723911524, 0.00500768236815929, 0.00502089271321893, 0.00503410352393985, 0.00504731433466077, 0.00506056705489755, 0.00507390545681119, 0.0050872010178864, 0.00510062463581562, 0.00511404825374484, 0.00512747187167406, 0.00514098070561886, 0.00515444716438651, 0.00516808358952403, 0.00518159242346883, 0.00519527215510607, 0.00520895095542073, 0.00522258784621954, 0.00523635232821107, 0.00525007443502545, 0.00526392366737127, 0.00527777336537838, 0.00529162352904677, 0.00530555844306946, 0.005319450981915, 0.0053335134871304, 0.00534749124199152, 0.00536155421286821, 0.00537561671808362, 0.00538976490497589, 0.00540391309186816, 0.00541814602911472, 0.00543237943202257, 0.00544661283493042, 0.00546093145385385, 0.00547524960711598, 0.00548965344205499, 0.00550405727699399, 0.00551846111193299, 0.00553299253806472, 0.00554743874818087, 0.00556205539032817, 0.00557658728212118, 0.00559124629944563, 0.00560590624809265, 0.0056205652654171, 0.00563530996441841, 0.00565005466341972, 0.00566488457843661, 0.00567971402779222, 0.00569458724930882, 0.00570954475551844, 0.00572441704571247, 0.00573941739276052, 0.00575441773980856, 0.00576946046203375, 0.0057845888659358, 0.00579971726983786, 0.00581488804891706, 0.00583005836233497, 0.00584531435742974, 0.00586048560217023, 0.00587582681328058, 0.00589116802439094, 0.00590650923550129, 0.00592193566262722, 0.00593736208975315, 0.00595287373289466, 0.00596830062568188, 0.00598389701917768, 0.00599949387833476, 0.00601509120315313, 0.0060307732783258, 0.00604645535349846, 0.00606218073517084, 0.00607790471985936, 0.00609371485188603, 0.00610961019992828, 0.00612542033195496, 0.00614131567999721, 0.0061572534032166, 0.00617323350161314, 0.00618921453133225, 0.00620527984574437, 0.00622138846665621, 0.00623749662190676, 0.00625364761799574, 0.00626984098926187, 0.00628607720136642, 0.00630231341347098, 0.00631859246641397, 0.00633495626971126, 0.00635132053866982, 0.00636772671714425, 0.00638413336127996, 0.00640062522143126, 0.0064170747064054, 0.00643365178257227, 0.00645027123391628, 0.00646680546924472, 0.0064835106022656, 0.0065001305192709, 0.00651692040264606, 0.00653362507000566, 0.00655041541904211, 0.00656729098409414, 0.00658412370830774, 0.00660104164853692, 0.00661796005442739, 0.00663378788158298, 0.00664942711591721, 0.00666506635025144, 0.00668083410710096, 0.00669655902311206, 0.00671239010989666, 0.00672820070758462, 0.00674407416954637, 0.00675996951758862, 0.00677599245682359, 0.00679199444130063, 0.00680803833529353, 0.00682414742186666, 0.00684023415669799, 0.00685644894838333, 0.00687262089923024, 0.0068888571113348, 0.00690519995987415, 0.00692149996757507, 0.00693788472563028, 0.00695429183542728, 0.00697074085474014, 0.00698725413531065, 0.0070038097910583, 0.00702036544680595, 0.00703698536381125, 0.00705366861075163, 0.00707035232335329, 0.00708712125197053, 0.00710389064624906, 0.00712072243914008, 0.00713761942461133, 0.00715449498966336, 0.00717143435031176, 0.00718843750655651, 0.00720546254888177, 0.00722252950072289, 0.00723966024816036, 0.00725683383643627, 0.0072740288451314, 0.00729126669466496, 0.00730850361287594, 0.00732584809884429, 0.00734321353957057, 0.00736057898029685, 0.00737805059179664, 0.00739552360028028, 0.00741303758695722, 0.00743063725531101, 0.00744821550324559, 0.00746587943285704, 0.00748358620330691, 0.00750129204243422, 0.00751904072239995, 0.00753687554970384, 0.00755473133176565, 0.00757262902334332, 0.00759057002142072, 0.00760851055383682, 0.00762657867744565, 0.00764460535719991, 0.00766271678730845, 0.00768082728609443, 0.00769902346655726, 0.00771724153310061, 0.00773552292957902, 0.00775382621213794, 0.007772171869874, 0.00779055990278721, 0.00780899031087756, 0.00782746449112892, 0.00784595869481564, 0.00786449573934078, 0.00788311939686537, 0.00790169928222895, 0.00792040675878525, 0.00793913472443819, 0.00795788690447807, 0.0079767219722271, 0.00799549371004105, 0.0080143716186285, 0.00803333520889282, 0.00805226713418961, 0.00807128380984068, 0.00809034332633018, 0.00810942333191633, 0.00812852568924427, 0.00814773421734571, 0.00816687848418951, 0.00818619318306446, 0.00820543337613344, 0.00822478160262108, 0.00824418105185032, 0.00826357118785381, 0.00828302372246981, 0.0083025312051177, 0.00832204800099134, 0.00834160856902599, 0.00836125388741493, 0.00838091038167477, 0.00840060878545046, 0.00842036120593548, 0.00844010151922703, 0.00845998153090477, 0.00847985036671162, 0.00849970895797014, 0.00851969420909882, 0.00853962823748589, 0.00855965726077557, 0.00857979152351618, 0.00859986338764429, 0.00862005259841681, 0.00864023063331842, 0.0086604505777359, 0.00868075713515282, 0.00870107300579548, 0.00872135814279318, 0.00874180253595114, 0.0087622469291091, 0.00878269039094448, 0.00880327355116606, 0.00882379245012999, 0.00884443894028664, 0.00886505469679832, 0.00888573285192251, 0.00890648644417524, 0.0089272279292345, 0.00894802529364824, 0.00896890554577112, 0.00898978672921658, 0.00901068933308125, 0.00903167761862278, 0.00905270781368017, 0.00907372683286667, 0.00909487437456846, 0.0091159800067544, 0.00913717970252037, 0.00915840175002813, 0.00917964521795511, 0.00920095294713974, 0.00922228116542101, 0.00924367364495993, 0.00926510896533728, 0.00928659737110138, 0.00930801127105951, 0.00932961702346802, 0.00935120135545731, 0.00937283970415592, 0.00939451903104782, 0.00941619835793972, 0.00943799689412117, 0.00945977307856083, 0.00948161259293556, 0.00950347352772951, 0.00952538847923279, 0.00954732391983271, 0.00956935621798038, 0.00959137734025717, 0.00961350463330746, 0.00963558908551931, 0.00965774897485971, 0.00967995077371597, 0.00970218516886234, 0.00972447264939547, 0.00974682439118624, 0.00976920779794455, 0.00979158002883196, 0.00981405936181545, 0.00983653776347637, 0.00985907111316919, 0.00988164637237787, 0.00990425329655409, 0.00992693472653627, 0.00994960591197014, 0.0099723506718874, 0.00999514944851398, 0.0100179482251406, 0.0100408215075731, 0.0100637376308441, 0.0100866751745343, 0.0101096453145146, 0.0101326676085591, 0.0101557103917003, 0.0101788183674216, 0.0102019803598523, 0.0102251833304763, 0.010248408652842, 0.010271686129272, 0.0102950064465404, 0.0103183491155505, 0.0103417234495282, 0.0103651620447636, 0.010388663969934, 0.0104121752083302, 0.0104356994852424, 0.0104593392461538, 0.0104829799383879, 0.0105066522955894, 0.0105303563177586, 0.0105541041120887, 0.0105779254809022, 0.0106017682701349, 0.0106256539002061, 0.0106496354565024, 0.0106735741719604, 0.0106975873932242, 0.0107216527685523, 0.0107457516714931, 0.0107698393985629, 0.0107940351590514, 0.0108182393014431, 0.0108424769714475, 0.0108668208122253, 0.0108911423012614, 0.0109155708923936, 0.0109399678185582, 0.010964397341013, 0.0109889218583703, 0.0110134454444051, 0.011038045398891, 0.0110626770183444, 0.0110873393714428, 0.0111120343208313, 0.0111367944628, 0.0111615750938654, 0.0111864395439625, 0.0112112946808338, 0.0112361805513501, 0.0112611753866076, 0.0112861581146717, 0.0113111836835742, 0.0113363144919276, 0.0113613940775394, 0.0113865584135056, 0.0114117544144392, 0.0114369811490178, 0.0114622842520475, 0.0114876078441739, 0.0115129426121712, 0.0115383826196194, 0.0115638244897127, 0.0115892849862576, 0.0116148553788662, 0.0116403913125396, 0.0116660017520189, 0.0116916876286268, 0.0117173539474607, 0.0117431133985519, 0.0117688858881593, 0.011794688180089, 0.0118205649778247, 0.0118464753031731, 0.0118723632767797, 0.0118983909487724, 0.0119244074448943, 0.0119504230096936, 0.0119765782728791, 0.0120026795193553, 0.0120289186015725, 0.012055148370564, 0.0120813678950071, 0.0121077140793204, 0.0121340490877628, 0.0121604269370437, 0.0121868699789047, 0.0122133446857333, 0.0122398296371102, 0.0122664207592607, 0.012293023057282, 0.0123196570202708, 0.0123463338240981, 0.0123730516061187, 0.0123998150229454, 0.0124266082420945, 0.0124534238129854, 0.0124803567305207, 0.0125072570517659, 0.0125342113897204, 0.0125612383708358, 0.0125882877036929, 0.0126154124736786, 0.0126424944028258, 0.0126696610823274, 0.012696891091764, 0.0127241536974907, 0.0127514377236366, 0.0127787962555885, 0.012806155718863, 0.0128335561603308, 0.012861043214798, 0.0128885190933943, 0.0129160694777966, 0.0129436291754246, 0.0129712652415037, 0.0129989646375179, 0.013026631437242, 0.0130543960258365, 0.0130821708589792, 0.0131100192666054, 0.0131378993391991, 0.0131657803431153, 0.0131937339901924, 0.0132217006757855, 0.0132497735321522, 0.013277824036777, 0.0133059602230787, 0.0133340861648321, 0.0133622968569398, 0.0133905615657568, 0.013418803922832, 0.0134471217170358, 0.0134754916653037, 0.0135038839653134, 0.0135323498398066, 0.0135608483105898, 0.0135893682017922, 0.0136179206892848, 0.0136465458199382, 0.0136751625686884, 0.013703852891922, 0.0137325963005424, 0.0137613611295819, 0.0137901995331049, 0.0138190295547247, 0.0138479433953762, 0.0138768786564469, 0.0139058455824852, 0.0139348553493619, 0.0139639182016253, 0.0139930341392756, 0.0140221510082483, 0.0140513638034463, 0.0140805644914508, 0.0141098303720355, 0.0141391595825553, 0.0141685018315911, 0.0141978831961751, 0.0142273092642426, 0.0142567660659552, 0.0142862871289253, 0.0143158407881856, 0.01434544660151, 0.0143750859424472, 0.0144047550857067, 0.0144344484433532, 0.0144642246887088, 0.014494001865387, 0.0145238311961293, 0.0145537471398711, 0.0145836304873228, 0.0146136516705155, 0.0146436206996441, 0.014673663303256, 0.0147037832066417, 0.0147338779643178, 0.0147640286013484, 0.0147942621260881, 0.014824497513473, 0.0148547859862447, 0.0148851294070482, 0.0149154802784324, 0.0149459391832352, 0.0149763766676188, 0.0150068560615182, 0.0150374220684171, 0.0150679768994451, 0.0150985736399889, 0.015129298903048, 0.0151599701493979, 0.0151907065883279, 0.015221506357193, 0.0152523163706064, 0.0152831906452775, 0.0153140751644969, 0.0153450127691031, 0.015376047231257, 0.0154070612043142, 0.0154381049796939, 0.0154692782089114, 0.0155003862455487, 0.0155315697193146, 0.0155628593638539, 0.0155940754339099, 0.0156254284083843, 0.0156567934900522, 0.015688156709075, 0.0157196391373873, 0.0157511197030544, 0.0157826226204634, 0.0158142000436783, 0.0158457774668932, 0.0158773977309465, 0.0159091353416443, 0.0159408301115036, 0.0159726515412331, 0.0160044524818659, 0.0160362757742405, 0.0160681921988726, 0.016100101172924, 0.0161320529878139, 0.0161640886217356, 0.0161961652338505, 0.0162282325327396, 0.0162603743374348, 0.0162925478070974, 0.0163247976452112, 0.0163570679724216, 0.016389325261116, 0.016421714797616, 0.0164541006088257, 0.0164864771068096, 0.0165189821273088, 0.0165514647960663, 0.0165840014815331, 0.0166166331619024, 0.01664924249053, 0.0166819710284472, 0.0167146362364292, 0.0167474057525396, 0.0167801976203918, 0.0168130323290825, 0.0168458670377731, 0.0168788190931082, 0.0169117916375399, 0.0169447641819715, 0.016977833583951, 0.0170109029859304, 0.017044035717845, 0.0170771684497595, 0.01711037568748, 0.0171436574310064, 0.0171769298613071, 0.0172102525830269, 0.017243642359972, 0.0172770414501429, 0.0173105150461197, 0.0173439886420965, 0.0173775143921375, 0.017411096021533, 0.017444709315896, 0.0174783524125814, 0.017512071877718, 0.0175458118319511, 0.0175795834511518, 0.0176134184002876, 0.0176472552120686, 0.0176811553537846, 0.0177151076495647, 0.0177490916103125, 0.0177831314504147, 0.0178172010928392, 0.0178513154387474, 0.0178854167461395, 0.0179196577519178, 0.0179538670927286, 0.0179881509393454, 0.0180224757641554, 0.0180568024516106, 0.0180912036448717, 0.0181256458163261, 0.0181601103395224, 0.0181946605443954, 0.0182291995733976, 0.0182638019323349, 0.0182984378188848, 0.018333125859499, 0.0183678139001131, 0.0184026192873716, 0.0184374134987593, 0.0184722505509853, 0.0185071751475334, 0.0185420736670494, 0.0185770727694035, 0.0186120495200157, 0.0186471212655306, 0.0186822135001421, 0.0187173373997211, 0.0187525171786547, 0.0187877379357815, 0.0188230127096176, 0.0188582763075829, 0.0188936442136765, 0.0189290158450603, 0.0189644601196051, 0.0189999043941498, 0.0190354026854038, 0.0190709959715605, 0.0191065389662981, 0.0191421527415514, 0.0191778317093849, 0.0192135516554117, 0.0192493181675673, 0.0192850604653358, 0.0193209089338779, 0.0193568244576454, 0.0193926934152842, 0.0194286815822124, 0.0194646902382374, 0.0195007007569075, 0.0195367522537708, 0.0195712614804506, 0.0196036901324987, 0.0196361839771271, 0.0196688268333673, 0.0197014901787043, 0.0197342596948147, 0.019767053425312, 0.0197998881340027, 0.0198328495025635, 0.0198658555746078, 0.0198989231139421, 0.0199320558458567, 0.0199652537703514, 0.0199985355138779, 0.0200318805873394, 0.0200652685016394, 0.0200987234711647, 0.0201323237270117, 0.0201659258455038, 0.020199591293931, 0.0202333200722933, 0.0202671121805906, 0.0203010346740484, 0.0203349348157644, 0.0203689411282539, 0.0204030107706785, 0.0204371884465218, 0.0204713866114616, 0.0205056704580784, 0.0205399952828884, 0.0205744504928589, 0.0206089038401842, 0.0206434186547995, 0.020678024739027, 0.0207127556204796, 0.0207474865019321, 0.0207822602242231, 0.0208171177655458, 0.0208520609885454, 0.0208871327340603, 0.0209221839904785, 0.0209573190659285, 0.0209925416857004, 0.0210278462618589, 0.0210631936788559, 0.0210985857993364, 0.021134041249752, 0.0211696047335863, 0.0212052501738071, 0.0212409198284149, 0.0212766714394093, 0.021312490105629, 0.0213483925908804, 0.0213843174278736, 0.0214203037321568, 0.0214563999325037, 0.0214925594627857, 0.0215287581086159, 0.0215650461614132, 0.0216013733297586, 0.0216378085315228, 0.0216743294149637, 0.0217108502984047, 0.0217474550008774, 0.0217841491103172, 0.0218209251761436, 0.0218577217310667, 0.0218946058303118, 0.0219315513968468, 0.0219686049968004, 0.0220056790858507, 0.022042840719223, 0.0220800433307886, 0.022117393091321, 0.0221547223627567, 0.0221921168267727, 0.0222295988351107, 0.0222671423107386, 0.0223047900944948, 0.0223424825817347, 0.0223801974207163, 0.0224180407822132, 0.0224559456110001, 0.0224938709288836, 0.0225319061428308, 0.0225700028240681, 0.0226081218570471, 0.0226464103907347, 0.0226846784353256, 0.0227230098098516, 0.0227614939212799, 0.0227999538183212, 0.0228384751826525, 0.0228771045804024, 0.0229158010333776, 0.0229545999318361, 0.0229934193193913, 0.0230323076248169, 0.0230712778866291, 0.0231103114783764, 0.0231493916362524, 0.0231885313987732, 0.0232277568429708, 0.023267051205039, 0.0233064256608486, 0.0233458429574966, 0.0233853682875633, 0.02342489361763, 0.0234645456075668, 0.0235042404383421, 0.0235440004616976, 0.0235838014632463, 0.0236237328499556, 0.0236637033522129, 0.0237037427723408, 0.023743798956275, 0.0237839855253696, 0.0238242354243994, 0.0238645263016224, 0.0239048823714256, 0.0239452794194221, 0.0239858068525791, 0.024026395753026, 0.024066986516118, 0.0241076853126287, 0.0241484679281712, 0.0241892896592617, 0.0242302250117064, 0.0242711752653122, 0.0243121702224016, 0.024353314191103, 0.0243944600224495, 0.0244356878101826, 0.0244769807904959, 0.0245183818042278, 0.0245598033070564, 0.0246013104915619, 0.0246428586542606, 0.0246845576912165, 0.0247262138873339, 0.0247679743915796, 0.0248098243027925, 0.024851692840457, 0.0248937327414751, 0.0249357484281063, 0.024977833032608, 0.0250199772417545, 0.0250622723251581, 0.0251045450568199, 0.0251469258219004, 0.0251893494278193, 0.0252318568527699, 0.0252744518220425, 0.0253170840442181, 0.025359783321619, 0.0254025682806969, 0.0254453979432583, 0.0254883319139481, 0.0255312640219927, 0.0255743060261011, 0.025617454200983, 0.0256606005132198, 0.0257038529962301, 0.025747150182724, 0.0257905554026365, 0.0258339792490005, 0.0258774682879448, 0.0259210616350174, 0.0259646773338318, 0.0260083992034197, 0.0260521862655878, 0.026096036657691, 0.026139909401536, 0.0261839292943478, 0.0262279938906431, 0.0262720566242933, 0.0263162460178137, 0.0263605229556561, 0.0264048222452402, 0.0264492277055979, 0.0264936294406652, 0.0265382044017315, 0.0265827570110559, 0.0266273990273476, 0.0266721230000257, 0.0267168655991554, 0.0267617404460907, 0.0268066767603159, 0.0268516149371862, 0.0268966555595398, 0.0269417650997639, 0.0269869565963745, 0.0270322356373072, 0.0270775128155947, 0.027122875675559, 0.0271683894097805, 0.027213878929615, 0.0272594355046749, 0.0273050963878632, 0.0273508653044701, 0.02739661000669, 0.0274424646049738, 0.0274883583188057, 0.027534406632185, 0.027580451220274, 0.0276265162974596, 0.0276727098971605, 0.027718948200345, 0.0277653131633997, 0.027811698615551, 0.0278581250458956, 0.027904661372304, 0.0279512610286474, 0.0279978811740875, 0.0280446298420429, 0.0280913766473532, 0.0281382091343403, 0.0281852167099714, 0.0282321535050869, 0.028279222548008, 0.0283263735473156, 0.0283735282719135, 0.0284208096563816, 0.0284681096673012, 0.0285154767334461, 0.028562992811203, 0.0286104846745729, 0.0286580640822649, 0.0287057291716337, 0.0287534575909376, 0.0288012716919184, 0.0288491044193506, 0.0288970284163952, 0.028945030644536, 0.0289930999279022, 0.0290412344038486, 0.0290894322097301, 0.0291376486420631, 0.0291859731078148, 0.0292343851178885, 0.0292828362435102, 0.0293313972651958, 0.0293799955397844, 0.0294286645948887, 0.0294773932546377, 0.0295261237770319, 0.0295750647783279, 0.0296239666640759, 0.0296729300171137, 0.0297220014035702, 0.0297711156308651, 0.0298203323036432, 0.0298696178942919, 0.0299189034849405, 0.0299683138728142, 0.0300177894532681, 0.0300673060119152, 0.0301169510930777, 0.030166557058692, 0.0302162654697895, 0.0302661266177893, 0.0303159859031439, 0.0303658880293369, 0.0304158926010132, 0.0304659865796566, 0.0305161438882351, 0.0305663030594587, 0.0306165441870689, 0.0306669343262911, 0.0307173058390617, 0.0307677611708641, 0.0308183245360851, 0.030868886038661, 0.030919574201107, 0.0309703294187784, 0.0310211051255465, 0.0310719683766365, 0.0311229098588228, 0.0311739221215248, 0.0312249939888716, 0.0312761105597019, 0.0313273370265961, 0.0313786417245865, 0.0314299277961254, 0.0314813405275345, 0.0315328426659107, 0.0315843410789967, 0.0316359922289848, 0.0316876173019409, 0.0317393317818642, 0.0317912138998508, 0.0318430587649345, 0.0318949818611145, 0.0319469943642616, 0.0319990664720535, 0.0320512242615223, 0.0321034304797649, 0.0321556739509106, 0.0322080478072166, 0.032260462641716, 0.0323129445314407, 0.0323654673993587, 0.0324180498719215, 0.0324707441031933, 0.0325235016644001, 0.0325762592256069, 0.0326291434466839, 0.0326821357011795, 0.0327351279556751, 0.0327882245182991, 0.0328413210809231, 0.0328945890069008, 0.0329478569328785, 0.0330011658370495, 0.0330546051263809, 0.0331080444157124, 0.0331616140902042, 0.0332152433693409, 0.0332689136266708, 0.0333226546645164, 0.0333764553070068, 0.0334303416311741, 0.0334842875599861, 0.0335383042693138, 0.033592339605093, 0.0336465649306774, 0.0337007716298103, 0.033755000680685, 0.0338093750178814, 0.0338638126850128, 0.0339182987809181, 0.0339728221297264, 0.0340274311602116, 0.0340821705758572, 0.034136887639761, 0.0341916903853416, 0.0342465788125992, 0.03430150821805, 0.0343565680086613, 0.034411646425724, 0.0344667471945286, 0.0345219746232033, 0.0345772877335548, 0.0346326231956482, 0.0346880443394184, 0.0347435288131237, 0.0347990766167641, 0.0348547287285328, 0.0349104069173336, 0.0349661484360695, 0.0350219942629337, 0.0350778587162495, 0.0351338163018227, 0.0351898297667503, 0.0352458916604519, 0.0353021211922169, 0.0353582836687565, 0.0354145765304565, 0.0354709178209305, 0.0355273559689522, 0.0355838648974895, 0.0356404148042202, 0.0356969870626926, 0.0357537046074867, 0.0358104892075062, 0.0358673371374607, 0.0359242297708988, 0.0359811186790466, 0.0360382199287415, 0.0360952839255333, 0.0361524075269699, 0.0362096168100834, 0.0362669751048088, 0.0363242961466312, 0.0363817177712917, 0.0364392027258873, 0.0364967957139015, 0.0365544110536575, 0.0366120897233486, 0.0366698764264584, 0.0367276817560196, 0.0367856174707413, 0.0368435718119144, 0.0369015708565712, 0.0369596555829048, 0.0370178669691086, 0.0370760783553123, 0.0371343530714512, 0.0371927134692669, 0.0372511148452759, 0.0373096689581871, 0.037368219345808, 0.0374268181622028, 0.0374855399131775, 0.0375443026423454, 0.0376031138002872, 0.0376620292663574, 0.0377209857106209, 0.037780050188303, 0.0378391332924366, 0.0378982834517956, 0.0379575379192829, 0.0380168594419956, 0.0380761995911598, 0.0381356254220009, 0.038195114582777, 0.0382546447217464, 0.0383143275976181, 0.038374051451683, 0.0384337976574898, 0.0384936071932316, 0.0385535471141338, 0.0386135242879391, 0.0386735275387764, 0.0387335903942585, 0.0387938246130943, 0.0388540402054787, 0.0389143414795399, 0.0389747023582458, 0.039035152643919, 0.0390956662595272, 0.0391562432050705, 0.0392168425023556, 0.0392775423824787, 0.0393383540213108, 0.0393991656601429, 0.0394600853323936, 0.0395210236310959, 0.0395820699632168, 0.039643220603466, 0.0397043712437153, 0.0397655889391899, 0.0398269109427929, 0.0398883409798145, 0.0399497486650944, 0.0400112383067608, 0.0400727950036526, 0.0401344783604145, 0.0401961654424667, 0.0402579344809055, 0.0403197482228279, 0.0403817072510719, 0.0404436513781548, 0.0405056960880756, 0.0405678264796734, 0.0406299792230129, 0.0406922399997711, 0.0407545641064644, 0.0408169291913509, 0.0408793613314629, 0.0409418977797031, 0.041004478931427, 0.0410670787096024, 0.0411297865211964, 0.0411925800144672, 0.0412554554641247, 0.0413183532655239, 0.0413813143968582, 0.0414444319903851, 0.041507501155138, 0.0415706560015678, 0.0416339114308357, 0.0416972190141678, 0.04176065325737, 0.0418240576982498, 0.0418875776231289, 0.0419511348009109, 0.0420148260891438, 0.0420785136520863, 0.0421423092484474, 0.0422061495482922, 0.0422700457274914, 0.042334072291851, 0.042398102581501, 0.0424621924757957, 0.0425264127552509, 0.0425906740128994, 0.0426549576222897, 0.0427193492650986, 0.042783759534359, 0.0428483448922634, 0.0429129302501678, 0.042977549135685, 0.0430422648787498, 0.0431070812046528, 0.043171938508749, 0.0432368405163288, 0.0433018058538437, 0.0433668382465839, 0.0434319898486137, 0.0434971898794174, 0.0435624346137047, 0.0436277464032173, 0.0436931177973747, 0.0437586158514023, 0.0438241325318813, 0.0438896976411343, 0.0439553670585155, 0.0440210923552513, 0.0440868698060513, 0.0441553108394146, 0.0442265011370182, 0.044297818094492, 0.0443691723048687, 0.0444406382739544, 0.0445121712982655, 0.0445838235318661, 0.0446555018424988, 0.0447273068130016, 0.0447992011904716, 0.0448711477220058, 0.0449432358145714, 0.0450154021382332, 0.0450876541435719, 0.0451599322259426, 0.0452323779463768, 0.0453048348426819, 0.0453774146735668, 0.045450072735548, 0.0455228164792061, 0.0455957055091858, 0.0456686206161976, 0.0457416176795959, 0.045814786106348, 0.0458879321813583, 0.0459611937403679, 0.0460345521569252, 0.0461079999804497, 0.0461815521121025, 0.0462551675736904, 0.046328891068697, 0.0464026741683483, 0.0464765951037407, 0.0465504862368107, 0.0466245524585247, 0.0466987006366253, 0.0467729121446609, 0.0468472503125668, 0.0469216592609882, 0.0469961278140545, 0.0470707304775715, 0.0471454076468945, 0.0472200885415077, 0.0472949407994747, 0.047369834035635, 0.0474449023604393, 0.0475199669599533, 0.0475951656699181, 0.047670416533947, 0.0477457828819752, 0.0478211864829063, 0.0478967241942883, 0.0479723215103149, 0.0480480268597603, 0.048123836517334, 0.0481997169554234, 0.0482756718993187, 0.0483517199754715, 0.0484278313815594, 0.0485040694475174, 0.0485803671181202, 0.0486567318439484, 0.048733226954937, 0.048809826374054, 0.0488864630460739, 0.0489631965756416, 0.0490400269627571, 0.0491169430315495, 0.049193911254406, 0.049270998686552, 0.0493481755256653, 0.0494254790246487, 0.049502819776535, 0.0495802536606789, 0.0496577695012093, 0.0497353486716747, 0.0498130321502686, 0.0498908311128616, 0.0499686859548092, 0.0500466302037239, 0.0501246973872185, 0.0502028055489063, 0.0502810478210449, 0.0503593310713768, 0.0504377000033855, 0.0505161732435226, 0.0505947172641754, 0.0506733544170856, 0.050752155482769, 0.0508309528231621, 0.0509098470211029, 0.0509888343513012, 0.051067903637886, 0.0511470809578896, 0.0512263290584087, 0.0513056553900242, 0.0513850674033165, 0.0514646023511887, 0.051544189453125, 0.0516238734126091, 0.0517036728560925, 0.0517835132777691, 0.0518634356558323, 0.0519434660673141, 0.0520236007869244, 0.0521037802100182, 0.0521841086447239, 0.0522644780576229, 0.0523449406027794, 0.0524254962801933, 0.0525061264634132, 0.05258684232831, 0.0526676587760448, 0.0527485609054565, 0.0528295934200287, 0.0529106259346008, 0.0529917851090431, 0.0530730076134205, 0.0531543344259262, 0.0532357506453991, 0.0533172562718391, 0.0533988624811172, 0.0534805096685886, 0.053562268614769, 0.0536441467702389, 0.0537260994315147, 0.0538081079721451, 0.0538901835680008, 0.0539724119007587, 0.0540546737611294, 0.0541370287537575, 0.0542195104062557, 0.0543020963668823, 0.0543847046792507, 0.0544674210250378, 0.0545502193272114, 0.0546331070363522, 0.0547160729765892, 0.0547991320490837, 0.0548822693526745, 0.054965503513813, 0.0550488531589508, 0.055132269859314, 0.0552157685160637, 0.0552992969751358, 0.0553829930722713, 0.055466752499342, 0.0555505976080894, 0.0556345246732235, 0.0557185597717762, 0.055802658200264, 0.0558868423104286, 0.0559711195528507, 0.0560554973781109, 0.056139912456274, 0.0562244355678558, 0.0563090704381466, 0.0563937723636627, 0.0564786121249199, 0.0565634816884995, 0.0566484332084656, 0.0567334890365601, 0.0568186342716217, 0.0569038651883602, 0.0569891594350338, 0.0570745542645454, 0.0571600422263145, 0.0572456791996956, 0.0573313497006893, 0.0574170760810375, 0.0575028322637081, 0.0575887858867645, 0.057674802839756, 0.0577609017491341, 0.0578470751643181, 0.0579333901405334, 0.0580197237432003, 0.0581061504781246, 0.058192677795887, 0.0582792945206165, 0.0583659932017326, 0.0584527738392353, 0.0585396662354469, 0.0586266033351421, 0.0587137043476105, 0.0588008090853691, 0.0588880404829979, 0.05897531285882, 0.059062696993351, 0.0591501854360104, 0.0592377819120884, 0.0593254119157791, 0.0594131648540497, 0.0595010109245777, 0.0595889203250408, 0.0596769191324711, 0.0597649663686752, 0.0598531737923622, 0.0599414296448231, 0.0600297674536705, 0.0601181946694851, 0.0602067671716213, 0.0602953433990479, 0.0603840462863445, 0.0604727938771248, 0.0605616420507431, 0.0606506243348122, 0.0607396475970745, 0.0608287714421749, 0.0609180070459843, 0.0610073246061802, 0.0610967092216015, 0.0611861757934093, 0.0612756907939911, 0.0613653734326363, 0.0614550970494747, 0.0615449286997318, 0.0616348087787628, 0.0617248453199863, 0.061814934015274, 0.0619050897657871, 0.0619953274726868, 0.0620856024324894, 0.0621760934591293, 0.0622665882110596, 0.0623571835458279, 0.0624478682875633, 0.0625386610627174, 0.0626295357942581, 0.0627204924821854, 0.062811441719532, 0.062902569770813, 0.0629938244819641, 0.0630851313471794, 0.0631764754652977, 0.0632679238915443, 0.0633595213294029, 0.0634511634707451, 0.0635428950190544, 0.0636346638202667, 0.0637265890836716, 0.0638185665011406, 0.0639106184244156, 0.0640027895569801, 0.0640950724482536, 0.0641874000430107, 0.0642798021435738, 0.064372256398201, 0.064464844763279, 0.0645575672388077, 0.0646503120660782, 0.0647431910037994, 0.0648360997438431, 0.0649291202425957, 0.0650222525000572, 0.0651154816150665, 0.0652086958289146, 0.0653020441532135, 0.0653955861926079, 0.0654890760779381, 0.0655827224254608, 0.0656765028834343, 0.0657702684402466, 0.0658641681075096, 0.065958134829998, 0.06605214625597, 0.0661463439464569, 0.0662405714392662, 0.0663348957896233, 0.0664293020963669, 0.0665237829089165, 0.0666184276342392, 0.0667130798101425, 0.06680778414011, 0.0669026300311089, 0.066997617483139, 0.0670926049351692, 0.0671876966953278, 0.0672829002141953, 0.0673782080411911, 0.0674735531210899, 0.0675690174102783, 0.0676645115017891, 0.0677601769566536, 0.0678558647632599, 0.0679516494274139, 0.0680475309491158, 0.0681435018777847, 0.0682395920157433, 0.068335734307766, 0.0684319138526917, 0.0685281977057457, 0.0686246752738953, 0.0687211602926254, 0.0688177049160004, 0.0689143463969231, 0.0690111070871353, 0.0691079944372177, 0.0692049190402031, 0.0693018659949303, 0.0693989619612694, 0.0694961920380592, 0.0695934593677521, 0.0696907863020897, 0.0697882473468781, 0.0698857977986336, 0.0699834227561951, 0.0700810551643372, 0.070178858935833, 0.0702767670154572, 0.0703747123479843, 0.0704727694392204, 0.0705708861351013, 0.0706690922379494, 0.0707674846053123, 0.0708658620715141, 0.0709642842411995, 0.0710628554224968, 0.0711615011096001, 0.0712602809071541, 0.0713591054081917, 0.0714579895138741, 0.0715569853782654, 0.0716561302542686, 0.0717552527785301, 0.0718545019626617, 0.0719539001584053, 0.0720533207058907, 0.0721528679132462, 0.0722524598240852, 0.0723521262407303, 0.0724519789218903, 0.0725518465042114, 0.0726517364382744, 0.0727517530322075, 0.072851873934269, 0.0729521661996841, 0.0730524361133575, 0.0731528177857399, 0.0732533037662506, 0.0733538940548897, 0.0734544917941093, 0.0735552236437798, 0.0736560299992561, 0.0737569853663445, 0.0738579854369164, 0.0739590227603912, 0.0740602090954781, 0.0741614997386932, 0.0742628201842308, 0.0743642225861549, 0.0744657069444656, 0.0745673254132271, 0.0746690183877945, 0.0747708082199097, 0.0748726800084114, 0.0749745666980743, 0.0750766694545746, 0.0751787573099136, 0.0752809718251228, 0.0753832459449768, 0.0754856020212173, 0.0755881145596504, 0.0756906643509865, 0.0757933035492897, 0.0758960247039795, 0.0759988948702812, 0.07610172778368, 0.0762047246098518, 0.0763077661395073, 0.0764109790325165, 0.0765142068266869, 0.076617531478405, 0.0767209604382515, 0.0768244862556458, 0.0769280418753624, 0.0770317241549492, 0.0771354883909225, 0.0772393196821213, 0.0773433223366737, 0.0774473175406456, 0.077551431953907, 0.077655628323555, 0.0777599662542343, 0.0778642594814301, 0.0779687538743019, 0.0780732482671738, 0.0781779289245605, 0.0782826542854309, 0.078387439250946, 0.0784923359751701, 0.0785973593592644, 0.0787023678421974, 0.078807532787323, 0.0789127945899963, 0.0790180712938309, 0.0791235193610191, 0.079229012131691, 0.07933459430933, 0.0794402807950974, 0.0795460864901543, 0.0796518623828888, 0.0797577798366547, 0.0798637792468071, 0.0799698904156685, 0.0800761282444, 0.0801824107766151, 0.0802887752652168, 0.0803952068090439, 0.0805017426609993, 0.0806083679199219, 0.0807150676846504, 0.0808218643069267, 0.0809287652373314, 0.0810357183218002, 0.0811427757143974, 0.0812499448657036, 0.0813572257757187, 0.0814644694328308, 0.0815718546509743, 0.0816793367266655, 0.0817869529128075, 0.0818946436047554, 0.0820023715496063, 0.0821102112531662, 0.0822181329131126, 0.0823260769248009, 0.0824342519044876, 0.0825424045324326, 0.0826506689190865, 0.0827590227127075, 0.0828675255179405, 0.0829760283231735, 0.0830846503376961, 0.0831932723522186, 0.0833021327853203, 0.0834110155701637, 0.0835199430584908, 0.0836289897561073, 0.0837381929159164, 0.083847388625145, 0.083956703543663, 0.0840660929679871, 0.0841755419969559, 0.084285132586956, 0.0843947976827621, 0.0845045074820518, 0.0846143290400505, 0.0847243145108223, 0.0848342925310135, 0.084944374859333, 0.0850545093417168, 0.0851648151874542, 0.0852751433849335, 0.0853855833411217, 0.0854961052536964, 0.0856067091226578, 0.0857174023985863, 0.0858282297849655, 0.0859390869736671, 0.0860500484704971, 0.0861610621213913, 0.0862722024321556, 0.0863834097981453, 0.0864946916699409, 0.0866060853004456, 0.0867176055908203, 0.0868291482329369, 0.0869407802820206, 0.0870524793863297, 0.0871643573045731, 0.0872762650251389, 0.0873882248997688, 0.0875003039836884, 0.087612472474575, 0.0877247676253319, 0.0878371000289917, 0.0879495590925217, 0.0880620554089546, 0.0881746411323547, 0.088287316262722, 0.0884000882506371, 0.0885129347443581, 0.0886259153485298, 0.0887389406561852, 0.08885208517313, 0.0889652445912361, 0.0890785902738571, 0.0891919359564781, 0.0893054008483887, 0.0894189476966858, 0.0895325988531113, 0.0896463394165039, 0.0897601246833801, 0.0898740664124489, 0.0899879783391953, 0.0901021137833595, 0.0902162790298462, 0.0903305113315582, 0.0904448255896568, 0.0905617475509644, 0.0906816571950912, 0.0908016040921211, 0.0909216031432152, 0.09104173630476, 0.091161884367466, 0.0912820622324944, 0.0914023369550705, 0.0915227010846138, 0.0916431397199631, 0.0917635560035706, 0.0918841138482094, 0.09200469404459, 0.0921254083514214, 0.0922461003065109, 0.09236691147089, 0.0924877300858498, 0.0926086232066154, 0.0927296504378319, 0.0928507000207901, 0.0929717719554901, 0.0930929630994797, 0.0932142287492752, 0.0933354943990707, 0.0934568420052528, 0.0935782566666603, 0.0936997905373573, 0.0938213318586349, 0.0939429551362991, 0.0940646380186081, 0.0941863879561424, 0.0943081602454185, 0.094430036842823, 0.0945519581437111, 0.0946740284562111, 0.0947960987687111, 0.0949181616306305, 0.0950403586030006, 0.0951626002788544, 0.0952849462628365, 0.0954073145985603, 0.0955297276377678, 0.0956522673368454, 0.095774844288826, 0.0958974957466125, 0.0960201993584633, 0.0961429476737976, 0.0962657630443573, 0.0963886380195618, 0.0965116024017334, 0.096634641289711, 0.0967577323317528, 0.0968809127807617, 0.0970040634274483, 0.0971273332834244, 0.0972506701946259, 0.0973740890622139, 0.0974975451827049, 0.0976210609078407, 0.0977446734905243, 0.0978683531284332, 0.0979920253157616, 0.0981158390641212, 0.0982396304607391, 0.0983635783195496, 0.0984875708818436, 0.0986116006970406, 0.0987356901168823, 0.098859891295433, 0.098984107375145, 0.0991083681583405, 0.0992327183485031, 0.0993571579456329, 0.0994816347956657, 0.0996062010526657, 0.0997307822108269, 0.0998554527759552, 0.0999802201986313, 0.100105002522469, 0.100229874253273, 0.100354760885239, 0.100479789078236, 0.100604824721813, 0.10072997957468, 0.100855141878128, 0.100980386137962, 0.101105712354183, 0.101231068372726, 0.101356476545334, 0.101482026278973, 0.101607613265514, 0.101733200252056, 0.101858869194984, 0.101984642446041, 0.102110490202904, 0.102236323058605, 0.102362275123596, 0.102488301694393, 0.102614402770996, 0.10274051874876, 0.102866746485233, 0.102992981672287, 0.103119343519211, 0.103245757520199, 0.103372171521187, 0.103498689830303, 0.103625304996967, 0.103751957416534, 0.103878647089005, 0.104005381464958, 0.104132249951363, 0.10425915569067, 0.104386128485203, 0.104513116180897, 0.104640230536461, 0.104767419397831, 0.10489459335804, 0.105021916329861, 0.10514922440052, 0.105276666581631, 0.105404168367386, 0.105531685054302, 0.105659253895283, 0.105786941945553, 0.105914682149887, 0.106042489409447, 0.106170289218426, 0.106298230588436, 0.106426253914833, 0.10655427724123, 0.106682397425175, 0.106810562312603, 0.106938816606998, 0.107067085802555, 0.107195489108562, 0.107323907315731, 0.107452429831028, 0.107580997049809, 0.107709616422653, 0.107838243246078, 0.107967026531696, 0.10809587687254, 0.10822469741106, 0.108353644609451, 0.108482658863068, 0.108611740171909, 0.108740858733654, 0.108870029449463, 0.10899929702282, 0.109128631651402, 0.109257988631725, 0.1093874797225, 0.109516978263855, 0.109646566212177, 0.109776176512241, 0.109905913472176, 0.110035642981529, 0.110165491700172, 0.11029540002346, 0.110425353050232, 0.110555350780487, 0.110685475170612, 0.110815644264221, 0.110945805907249, 0.111076079308987, 0.11120643466711, 0.111336834728718, 0.111467301845551, 0.111597873270512, 0.111728422343731, 0.111859120428562, 0.111989803612232, 0.112120598554611, 0.112251453101635, 0.112382389605045, 0.112513400614262, 0.112644374370575, 0.112775467336178, 0.112906657159328, 0.113037906587124, 0.113169178366661, 0.113300517201424, 0.113431945443153, 0.113563492894173, 0.113695025444031, 0.113826632499695, 0.113958291709423, 0.11409005522728, 0.114221841096878, 0.114353716373444, 0.114485651254654, 0.114617668092251, 0.114749737083912, 0.114881813526154, 0.115013979375362, 0.115146286785603, 0.115278623998165, 0.115410938858986, 0.115543387830257, 0.115675918757915, 0.115808509290218, 0.115941099822521, 0.116073809564114, 0.11620656400919, 0.116339407861233, 0.116472274065018, 0.116605259478092, 0.116738229990005, 0.116871312260628, 0.11700451374054, 0.117137677967548, 0.117270924150944, 0.117404282093048, 0.117537684738636, 0.117671146988869, 0.117804661393166, 0.117938235402107, 0.118071921169758, 0.11820562928915, 0.118339389562607, 0.118473216891289, 0.11860715597868, 0.118741124868393, 0.118875160813332, 0.119009241461754, 0.119143418967724, 0.119277663528919, 0.119411915540695, 0.119546234607697, 0.119680680334568, 0.119815193116665, 0.119949713349342, 0.120084315538406, 0.120218999683857, 0.120353758335114, 0.120488509535789, 0.120623394846916, 0.120758317410946, 0.120893321931362, 0.121028371155262, 0.121163479983807, 0.121298626065254, 0.121433891355991, 0.121569208800793, 0.121704556047916, 0.121840007603168, 0.121975511312485, 0.122111074626446, 0.122246704995632, 0.12238235771656, 0.122518144547939, 0.122653946280479, 0.122789822518826, 0.122925817966461, 0.123061761260033, 0.123197861015797, 0.123333990573883, 0.123470187187195, 0.123606450855732, 0.123742789030075, 0.123879201710224, 0.124015629291534, 0.12415212392807, 0.124288730323315, 0.124425396323204, 0.124562047421932, 0.124698825180531, 0.124835684895515, 0.124972604215145, 0.125109553337097, 0.125246569514275, 0.125383660197258, 0.125520825386047, 0.125658020377159, 0.125795319676399, 0.125932663679123, 0.126070082187653, 0.126207575201988, 0.126345083117485, 0.126482680439949, 0.126620322465897, 0.126758083701134, 0.126895874738693, 0.127033695578575, 0.127171620726585, 0.127309635281563, 0.127447664737701, 0.127585753798485, 0.127723932266235, 0.127862170338631, 0.12800045311451, 0.128138870000839, 0.128277257084846, 0.128415778279305, 0.128554344177246, 0.128692924976349, 0.128831595182419, 0.128970369696617, 0.129109159111977, 0.129248037934303, 0.129386961460114, 0.129525974392891, 0.129665046930313, 0.129804164171219, 0.129943341016769, 0.130082607269287, 0.130221948027611, 0.130361303687096, 0.13050077855587, 0.130640283226967, 0.130779847502708, 0.130919516086578, 0.131059184670448, 0.131198942661285, 0.13133879005909, 0.1314787119627, 0.131618618965149, 0.131758615374565, 0.131898730993271, 0.13203889131546, 0.132179066538811, 0.132319405674934, 0.132459715008736, 0.132600113749504, 0.132740557193756, 0.132881119847298, 0.133021667599678, 0.133162334561348, 0.133303076028824, 0.133443832397461, 0.133584693074226, 0.133725613355637, 0.133866608142853, 0.13400761783123, 0.134148672223091, 0.134289845824242, 0.134431123733521, 0.134572416543961, 0.134713783860207, 0.134855180978775, 0.134996697306633, 0.135138228535652, 0.135279834270477, 0.135421484708786, 0.135563239455223, 0.135705068707466, 0.13584691286087, 0.135988816618919, 0.136130824685097, 0.136272877454758, 0.136415019631386, 0.136557221412659, 0.136699438095093, 0.136841773986816, 0.136984124779701, 0.137126579880714, 0.137269079685211, 0.137411653995514, 0.137554243206978, 0.137696951627731, 0.137839689850807, 0.137982547283173, 0.138125419616699, 0.138268351554871, 0.138411357998848, 0.138554468750954, 0.138697609305382, 0.138840794563293, 0.138984099030495, 0.139127403497696, 0.139270827174187, 0.139414250850677, 0.139557778835297, 0.139701351523399, 0.139844998717308, 0.139988675713539, 0.140132501721382, 0.140276327729225, 0.140420243144035, 0.140564188361168, 0.140708222985268, 0.140852361917496, 0.140996471047401, 0.141140729188919, 0.141284987330437, 0.141429364681244, 0.141573771834373, 0.141718238592148, 0.141862764954567, 0.142007380723953, 0.142152026295662, 0.14229679107666, 0.14244157075882, 0.142586469650269, 0.142731368541718, 0.142876371741295, 0.143021374940872, 0.143166482448578, 0.143311679363251, 0.143456935882568, 0.143602252006531, 0.143747612833977, 0.143893003463745, 0.144038543105125, 0.144184112548828, 0.144329711794853, 0.144475370645523, 0.14462111890316, 0.144766956567764, 0.144912824034691, 0.145058780908585, 0.145204797387123, 0.145350843667984, 0.14549694955349, 0.145643174648285, 0.145789444446564, 0.145935758948326, 0.146082177758217, 0.146228596568108, 0.146375104784966, 0.146521672606468, 0.146668344736099, 0.14681501686573, 0.146961823105812, 0.147108629345894, 0.147255539894104, 0.147402480244637, 0.147549524903297, 0.147696614265442, 0.147843718528748, 0.147990956902504, 0.148138269782066, 0.148285582661629, 0.148432999849319, 0.148580476641655, 0.148727998137474, 0.148875594139099, 0.149023249745369, 0.149170964956284, 0.149318754673004, 0.14946660399437, 0.149614572525024, 0.149762526154518, 0.149910524487495, 0.150058656930923, 0.150206834077835, 0.150355085730553, 0.15050333738327, 0.150651723146439, 0.150800153613091, 0.150948613882065, 0.151097223162651, 0.151245787739754, 0.151394471526146, 0.151543214917183, 0.151692032814026, 0.151840895414352, 0.151989817619324, 0.152138844132423, 0.152287915349007, 0.152437001466751, 0.152586206793785, 0.152735471725464, 0.152884796261787, 0.153034135699272, 0.153183594346046, 0.153333097696304, 0.153482675552368, 0.153632313013077, 0.153781980276108, 0.153931751847267, 0.154081597924232, 0.154231488704681, 0.154381409287453, 0.154531434178352, 0.154681533575058, 0.154831692576408, 0.15498186647892, 0.155132129788399, 0.155282482504845, 0.155432894825935, 0.155583336949348, 0.155733868479729, 0.155884444713593, 0.156035080552101, 0.15618585050106, 0.156336605548859, 0.156487450003624, 0.156638368964195, 0.156789347529411, 0.15694035589695, 0.157091438770294, 0.157242611050606, 0.157393887639046, 0.157545134425163, 0.157696485519409, 0.157847926020622, 0.157999411225319, 0.158150926232338, 0.158302530646324, 0.158453643321991, 0.158604294061661, 0.158754989504814, 0.158905684947968, 0.159056380391121, 0.159207090735435, 0.159357890486717, 0.159508660435677, 0.15965947508812, 0.159810319542885, 0.159961178898811, 0.160112023353577, 0.160262912511826, 0.160413846373558, 0.160564795136452, 0.160715743899345, 0.160866767168045, 0.161017790436745, 0.161168828606606, 0.16131991147995, 0.161470979452133, 0.1616220921278, 0.161773204803467, 0.161924377083778, 0.162075564265251, 0.162226736545563, 0.162377998232841, 0.162529230117798, 0.162680506706238, 0.162831798195839, 0.162983134388924, 0.163134455680847, 0.163285836577415, 0.163437217473984, 0.163588628172874, 0.163740053772926, 0.163891524076462, 0.16404302418232, 0.164194509387016, 0.164346054196358, 0.16449761390686, 0.164649173617363, 0.164800778031349, 0.164952412247658, 0.165104046463966, 0.165255695581436, 0.165407374501228, 0.165559113025665, 0.165710866451263, 0.1658626049757, 0.166014418005943, 0.166166201233864, 0.166318044066429, 0.166469871997833, 0.166621759533882, 0.166773676872253, 0.166925594210625, 0.16707755625248, 0.167229518294334, 0.16738149523735, 0.16753351688385, 0.167685583233833, 0.167837634682655, 0.1679897159338, 0.168141856789589, 0.168293952941895, 0.168446108698845, 0.168598309159279, 0.168750509619713, 0.168902739882469, 0.169054970145226, 0.169207274913788, 0.169359549880028, 0.169511869549751, 0.169664233922958, 0.169816568493843, 0.169968962669373, 0.170121386647224, 0.170273825526237, 0.170426294207573, 0.17057877779007, 0.170731291174889, 0.170883804559708, 0.171036332845688, 0.171188935637474, 0.17134153842926, 0.171494171023369, 0.171646818518639, 0.17179948091507, 0.171952173113823, 0.172104865312576, 0.172257602214813, 0.172410368919373, 0.172563150525093, 0.172715976834297, 0.172868803143501, 0.173021674156189, 0.173174545168877, 0.173327445983887, 0.173480376601219, 0.173633322119713, 0.173786297440529, 0.173939287662506, 0.174092292785645, 0.174245342612267, 0.174398437142372, 0.174551516771317, 0.174704611301422, 0.17485773563385, 0.175010904669762, 0.175164088606834, 0.175317272543907, 0.175470516085625, 0.175623774528503, 0.175777018070221, 0.175930336117744, 0.176083639264107, 0.176237031817436, 0.176390394568443, 0.17654375731945, 0.176697164773941, 0.176850602030754, 0.177004083991051, 0.177157551050186, 0.177311062812805, 0.177464619278908, 0.17761817574501, 0.177771747112274, 0.177925303578377, 0.178078964352608, 0.178232580423355, 0.178386241197586, 0.178539946675301, 0.178693681955338, 0.178847402334213, 0.179001182317734, 0.179154962301254, 0.179308786988258, 0.179462596774101, 0.17961648106575, 0.17977038025856, 0.179924249649048, 0.180078193545341, 0.180232122540474, 0.180386126041412, 0.180540069937706, 0.180694118142128, 0.180848151445389, 0.181002214550972, 0.1811563372612, 0.181310430169106, 0.181464567780495, 0.181618720293045, 0.181772872805595, 0.181927084922791, 0.182081311941147, 0.182235613465309, 0.182389855384827, 0.182544156908989, 0.182698488235474, 0.182852819561958, 0.183007180690765, 0.183161556720734, 0.183315992355347, 0.183470457792282, 0.183624908328056, 0.183779388666153, 0.183933883905411, 0.184088408946991, 0.184242963790894, 0.184397548437119, 0.184552147984505, 0.184706762433052, 0.184861451387405, 0.185016095638275, 0.185170784592628, 0.185325503349304, 0.185480251908302, 0.1856350004673, 0.185789808630943, 0.185944631695747, 0.186099454760551, 0.186254292726517, 0.186409205198288, 0.186564087867737, 0.186719000339508, 0.186873942613602, 0.187028974294662, 0.187183946371078, 0.187338933348656, 0.1874940097332, 0.187649056315422, 0.187804132699966, 0.187959283590317, 0.188114374876022, 0.188269555568695, 0.188424721360207, 0.188579961657524, 0.188735201954842, 0.188890412449837, 0.189045712351799, 0.189201012253761, 0.189356327056885, 0.189511686563492, 0.18966706097126, 0.189822435379028, 0.189977839589119, 0.190133273601532, 0.190288752317429, 0.190444216132164, 0.190599739551544, 0.190755292773247, 0.190910831093788, 0.191066399216652, 0.191222012042999, 0.191377624869347, 0.191533267498016, 0.19168895483017, 0.191844671964645, 0.19200037419796, 0.192156091332436, 0.192311868071556, 0.192467674612999, 0.192623436450958, 0.192779287695885, 0.192935138940811, 0.193091034889221, 0.193246960639954, 0.193402886390686, 0.19355882704258, 0.193714797496796, 0.193870797753334, 0.194026812911034, 0.194182857871056, 0.194338947534561, 0.194495022296906, 0.194651111960411, 0.1948072463274, 0.194963440299034, 0.195119619369507, 0.195275813341141, 0.195432066917419, 0.195588305592537, 0.195744574069977, 0.195900872349739, 0.196057200431824, 0.196213528513908, 0.196369886398315, 0.196526303887367, 0.196682706475258, 0.196839153766632, 0.196995660662651, 0.197152093052864, 0.197308614850044, 0.197465136647224, 0.197621718049049, 0.197778254747391, 0.197934880852699, 0.198091521859169, 0.1982481777668, 0.19840481877327, 0.198561519384384, 0.198718249797821, 0.198874980211258, 0.19903177022934, 0.199188560247421, 0.199345365166664, 0.199502199888229, 0.199659079313278, 0.199815928936005, 0.199972823262215, 0.200129747390747, 0.200286716222763, 0.20044369995594, 0.200600683689117, 0.200757727026939, 0.2009147554636, 0.201071828603745, 0.201228886842728, 0.201386034488678, 0.201543167233467, 0.201700314879417, 0.201857537031174, 0.202014744281769, 0.202171936631203, 0.202329203486443, 0.202486470341682, 0.202643766999245, 0.202801093459129, 0.202958464622498, 0.203115835785866, 0.203273221850395, 0.203430637717247, 0.203588083386421, 0.203745529055595, 0.203903019428253, 0.204060539603233, 0.204218074679375, 0.204375624656677, 0.204533204436302, 0.204690799117088, 0.204848423600197, 0.205006048083305, 0.20516374707222, 0.205321446061134, 0.20547915995121, 0.205636918544769, 0.20579469203949, 0.205952450633049, 0.206110298633575, 0.206268116831779, 0.206425979733467, 0.206583857536316, 0.206741780042648, 0.20689968764782, 0.207057625055313, 0.207215622067451, 0.207373633980751, 0.207531601190567, 0.207689672708511, 0.207847788929939, 0.208005845546722, 0.20816396176815, 0.208322107791901, 0.208480268716812, 0.208638414740562, 0.208796635270119, 0.208954900503159, 0.209113150835037, 0.209271416068077, 0.209429726004601, 0.209588021039963, 0.20974637567997, 0.209904760122299, 0.210063144564629, 0.210221588611603, 0.210380002856255, 0.210538491606712, 0.210696965456009, 0.210855439305305, 0.21101401746273, 0.211172565817833, 0.211331158876419, 0.211489766836166, 0.211648389697075, 0.211807027459145, 0.211965680122375, 0.212124392390251, 0.212283104658127, 0.212441831827164, 0.212600603699684, 0.212759420275688, 0.212918221950531, 0.213077053427696, 0.213235929608345, 0.213394820690155, 0.213553696870804, 0.213712647557259, 0.213871598243713, 0.214030563831329, 0.214189544320107, 0.21434859931469, 0.21450762450695, 0.214666709303856, 0.214825794100761, 0.214984923601151, 0.215144068002701, 0.215303242206573, 0.215462416410446, 0.215621620416641, 0.215780824422836, 0.215940102934837, 0.216099381446838, 0.216258674860001, 0.216418027877808, 0.216577351093292, 0.21673671901226, 0.216896116733551, 0.217055544257164, 0.217214956879616, 0.217374414205551, 0.21753391623497, 0.21769343316555, 0.217852979898453, 0.218012541532516, 0.218172118067741, 0.218331709504128, 0.218491315841675, 0.218650996685028, 0.21881066262722, 0.218970373272896, 0.219130098819733, 0.219289839267731, 0.219449609518051, 0.219609379768372, 0.219769209623337, 0.219929039478302, 0.220088914036751, 0.220248818397522, 0.220408707857132, 0.220568627119064, 0.220728576183319, 0.220888569951057, 0.221048548817635, 0.221208572387695, 0.221368625760078, 0.221528694033623, 0.221688792109489, 0.221848919987679, 0.222009032964706, 0.222169190645218, 0.222329378128052, 0.222489610314369, 0.222649827599525, 0.222810104489326, 0.222970366477966, 0.223130688071251, 0.223290994763374, 0.22345133125782, 0.22361171245575, 0.22377210855484, 0.223932534456253, 0.224092975258827, 0.224253460764885, 0.22441391646862, 0.224574446678162, 0.224734947085381, 0.224895536899567, 0.225056126713753, 0.225216746330261, 0.225377351045609, 0.225538000464439, 0.225698679685593, 0.225859388709068, 0.226020067930222, 0.226180851459503, 0.226341634988785, 0.226502418518066, 0.226663216948509, 0.226824060082436, 0.226984918117523, 0.227145776152611, 0.227306723594666, 0.227467626333237, 0.227628603577614, 0.22778956592083, 0.227950602769852, 0.228111580014229, 0.228272631764412, 0.228433728218079, 0.228594794869423, 0.228755936026573, 0.228917047381401, 0.229078248143196, 0.229239419102669, 0.229400590062141, 0.229561850428581, 0.229723110795021, 0.229884371161461, 0.230045720934868, 0.230207040905952, 0.230368360877037, 0.230529740452766, 0.230691134929657, 0.230852544307709, 0.231013983488083, 0.231175482273102, 0.23133696615696, 0.231498464941978, 0.23165999352932, 0.231821566820145, 0.23198314011097, 0.232144743204117, 0.232306391000748, 0.23246805369854, 0.232629716396332, 0.232791423797607, 0.232953131198883, 0.233114883303642, 0.233276635408401, 0.233438462018967, 0.233600229024887, 0.233762100338936, 0.233923956751823, 0.234085828065872, 0.234247758984566, 0.234409660100937, 0.234571635723114, 0.234733611345291, 0.234895601868629, 0.235057651996613, 0.235219687223434, 0.235381752252579, 0.235543847084045, 0.235705986618996, 0.235868111252785, 0.236030265688896, 0.236192479729652, 0.236354678869247, 0.236516922712326, 0.236684739589691, 0.236858248710632, 0.237031698226929, 0.237205103039742, 0.237378433346748, 0.23755170404911, 0.237724930047989, 0.237898111343384, 0.238071203231812, 0.238244235515594, 0.238417223095894, 0.23859016597271, 0.238763049244881, 0.238935858011246, 0.239108607172966, 0.239281311631203, 0.239453926682472, 0.239626541733742, 0.239799052476883, 0.239971503615379, 0.240143924951553, 0.240316286683083, 0.240488559007645, 0.240660801529884, 0.240832984447479, 0.241005092859268, 0.241177141666412, 0.241349145770073, 0.241521090269089, 0.241692960262299, 0.241864770650864, 0.242036581039429, 0.242208257317543, 0.242379888892174, 0.242551520466805, 0.242723032832146, 0.242894515395164, 0.243065908551216, 0.243237301707268, 0.243408590555191, 0.243579834699631, 0.243751034140587, 0.243922159075737, 0.244093209505081, 0.244264215230942, 0.244435176253319, 0.24460606276989, 0.244776904582977, 0.244947701692581, 0.24511843919754, 0.245289072394371, 0.245459645986557, 0.245630219578743, 0.245800703763962, 0.245971113443375, 0.246141523122787, 0.246311813592911, 0.24648205935955, 0.246652275323868, 0.246822401881218, 0.246992483735085, 0.247162476181984, 0.247332453727722, 0.247502371668816, 0.247672200202942, 0.247842028737068, 0.248011723160744, 0.248181387782097, 0.248351007699966, 0.248520582914352, 0.248690083622932, 0.248859509825706, 0.249028891324997, 0.249198198318481, 0.249367460608482, 0.249536693096161, 0.249705836176872, 0.249874919652939, 0.250043958425522, 0.250212967395782, 0.250381857156754, 0.250550717115402, 0.250719547271729, 0.250888258218765, 0.25105693936348, 0.251225560903549, 0.251394122838974, 0.251562625169754, 0.251731067895889, 0.251899510622025, 0.252067804336548, 0.252236098051071, 0.25240433216095, 0.252572476863861, 0.252740561962128, 0.252908617258072, 0.253076612949371, 0.253244519233704, 0.253412395715714, 0.253580212593079, 0.253747969865799, 0.253915637731552, 0.254083275794983, 0.254250854253769, 0.25441837310791, 0.254585832357407, 0.254753232002258, 0.254920572042465, 0.255087852478027, 0.255255103111267, 0.25542226433754, 0.25558939576149, 0.255756407976151, 0.255923420190811, 0.256090372800827, 0.256257236003876, 0.256424099206924, 0.256590843200684, 0.256757527589798, 0.25692418217659, 0.257090777158737, 0.25725731253624, 0.257423758506775, 0.25759020447731, 0.257756561040878, 0.257922857999802, 0.25808909535408, 0.258255273103714, 0.258421391248703, 0.258587449789047, 0.258753478527069, 0.258919417858124, 0.259085297584534, 0.259251147508621, 0.259416937828064, 0.259582608938217, 0.25974828004837, 0.259913891553879, 0.26007941365242, 0.260244905948639, 0.260410338640213, 0.260575711727142, 0.260740995407104, 0.260906249284744, 0.261071473360062, 0.261236578226089, 0.261401683092117, 0.261566668748856, 0.261731624603271, 0.261896520853043, 0.262061417102814, 0.262226164340973, 0.262390911579132, 0.262555539608002, 0.262720197439194, 0.262884736061096, 0.263049215078354, 0.263213664293289, 0.26337805390358, 0.263542354106903, 0.263706594705582, 0.263870805501938, 0.264034956693649, 0.264199048280716, 0.26436311006546, 0.264527052640915, 0.264690965414047, 0.264854818582535, 0.265018612146378, 0.265182346105576, 0.265346020460129, 0.265509694814682, 0.265673220157623, 0.265836715698242, 0.266000181436539, 0.266163557767868, 0.266326904296875, 0.266490131616592, 0.266653388738632, 0.266816526651382, 0.266979604959488, 0.267142683267593, 0.267305642366409, 0.267468571662903, 0.267631411552429, 0.267794251441956, 0.267957001924515, 0.268119692802429, 0.268282294273376, 0.268444895744324, 0.268607407808304, 0.268769890069962, 0.268932282924652, 0.269094586372375, 0.269256889820099, 0.269419133663177, 0.269581288099289, 0.269743382930756, 0.2699054479599, 0.270067423582077, 0.270229369401932, 0.270391225814819, 0.270553052425385, 0.270714819431305, 0.270876526832581, 0.271038174629211, 0.271199733018875, 0.271361261606216, 0.271522760391235, 0.271684169769287, 0.271845489740372, 0.272006779909134, 0.272168010473251, 0.272329211235046, 0.272490352392197, 0.27265140414238, 0.272812396287918, 0.272973328828812, 0.273134231567383, 0.273295044898987, 0.273455828428268, 0.273616552352905, 0.273777216672897, 0.273937791585922, 0.274098336696625, 0.27425879240036, 0.274419218301773, 0.274579584598541, 0.274739891290665, 0.274900168180466, 0.2750603556633, 0.275220453739166, 0.275380551815033, 0.27554053068161, 0.275700509548187, 0.275860399007797, 0.276020258665085, 0.276180028915405, 0.276339739561081, 0.276499450206757, 0.276659041643143, 0.276818573474884, 0.276978105306625, 0.277137488126755, 0.277296870946884, 0.277456194162369, 0.277615457773209, 0.277774661779404, 0.277933776378632, 0.278092890977859, 0.27825191617012, 0.278410851955414, 0.278569787740707, 0.278728634119034, 0.278887391090393, 0.279046148061752, 0.279204815626144, 0.279363423585892, 0.279522001743317, 0.279680490493774, 0.27983894944191, 0.2799973487854, 0.280155658721924, 0.280313909053802, 0.280472129583359, 0.28063029050827, 0.280788391828537, 0.280946433544159, 0.281104385852814, 0.281262308359146, 0.281420171260834, 0.281577974557877, 0.281735748052597, 0.28189343214035, 0.282051056623459, 0.282208621501923, 0.282366126775742, 0.282523602247238, 0.282680988311768, 0.282838314771652, 0.282995581626892, 0.28315281867981, 0.283309996128082, 0.28346711397171, 0.283624142408371, 0.283781141042709, 0.283938050270081, 0.284094929695129, 0.284251719713211, 0.284408509731293, 0.284565210342407, 0.284721851348877, 0.284878432750702, 0.285034954547882, 0.285191416740417, 0.285347819328308, 0.285504162311554, 0.285660445690155, 0.285816699266434, 0.285972863435745, 0.286128968000412, 0.286285042762756, 0.286441028118134, 0.286596983671188, 0.286752879619598, 0.286908686161041, 0.287064462900162, 0.287220150232315, 0.287375837564468, 0.287531405687332, 0.287686944007874, 0.28784242272377, 0.287997841835022, 0.288153201341629, 0.288308501243591, 0.288463741540909, 0.288618922233582, 0.288774043321609, 0.288929134607315, 0.289084136486053, 0.289239078760147, 0.289393991231918, 0.289548814296722, 0.289703607559204, 0.289858311414719, 0.290012985467911, 0.290167570114136, 0.290322124958038, 0.290476620197296, 0.290631055831909, 0.290785402059555, 0.290939748287201, 0.291093975305557, 0.291248172521591, 0.29140231013298, 0.291556417942047, 0.291710406541824, 0.291864395141602, 0.292018294334412, 0.292172163724899, 0.292325913906097, 0.292479664087296, 0.292633354663849, 0.292786955833435, 0.292940497398376, 0.293094009160995, 0.293247431516647, 0.293400794267654, 0.293554127216339, 0.293707430362701, 0.293860614299774, 0.294013768434525, 0.29416686296463, 0.294319897890091, 0.294472873210907, 0.294625759124756, 0.294778645038605, 0.294931441545486, 0.295084178447723, 0.295236885547638, 0.295389503240585, 0.295542061328888, 0.295694559812546, 0.295847028493881, 0.29599940776825, 0.296151757240295, 0.296304017305374, 0.296456217765808, 0.296608418226242, 0.296760499477386, 0.296912550926208, 0.297064512968063, 0.297216445207596, 0.297368317842484, 0.297520160675049, 0.297671884298325, 0.297823578119278, 0.297975242137909, 0.29812678694725, 0.298278301954269, 0.298429787158966, 0.298581182956696, 0.29873251914978, 0.298883825540543, 0.299035042524338, 0.299186199903488, 0.299337327480316, 0.299488395452499, 0.299639403820038, 0.299790322780609, 0.299941182136536, 0.300091981887817, 0.300242781639099, 0.300393491983414, 0.300544142723083, 0.300694733858109, 0.300845235586166, 0.300995737314224, 0.301146119832993, 0.301296502351761, 0.301446825265884, 0.301597028970718, 0.30174720287323, 0.301897317171097, 0.302047401666641, 0.302197426557541, 0.302347362041473, 0.302497267723083, 0.302647083997726, 0.302796870470047, 0.3029465675354, 0.303096234798431, 0.303245842456818, 0.303395390510559, 0.303544878959656, 0.303694278001785, 0.303843647241592, 0.303992986679077, 0.304142206907272, 0.304291397333145, 0.304440528154373, 0.304589629173279, 0.304738640785217, 0.304887592792511, 0.305036514997482, 0.305185347795486, 0.305334150791168, 0.30548283457756, 0.305631518363953, 0.3057801425457, 0.30592867732048, 0.306077182292938, 0.306225627660751, 0.30637401342392, 0.306522339582443, 0.306670606136322, 0.306818783283234, 0.306966930627823, 0.307115018367767, 0.307263046503067, 0.307411015033722, 0.307558923959732, 0.307706773281097, 0.30785459280014, 0.308002322912216, 0.308149993419647, 0.308297604322433, 0.308445185422897, 0.308592706918716, 0.308740139007568, 0.308887541294098, 0.30903485417366, 0.3091821372509, 0.309329330921173, 0.309476494789124, 0.309623599052429, 0.30977064371109, 0.309917628765106, 0.310064554214478, 0.310211420059204, 0.310358226299286, 0.310504972934723, 0.310651659965515, 0.310798287391663, 0.310944855213165, 0.311091393232346, 0.311237841844559, 0.311384260654449, 0.311530590057373, 0.311676889657974, 0.311823099851608, 0.311969250440598, 0.312115371227264, 0.312261402606964, 0.312407433986664, 0.312553346157074, 0.312699228525162, 0.312845051288605, 0.312990784645081, 0.313136518001556, 0.313282161951065, 0.313427746295929, 0.313573271036148, 0.3137187063694, 0.313864141702652, 0.314009487628937, 0.314154773950577, 0.314300000667572, 0.314445197582245, 0.314590334892273, 0.314735412597656, 0.314880400896072, 0.315025359392166, 0.315170228481293, 0.315315067768097, 0.315459817647934, 0.315604537725449, 0.315749198198318, 0.315893799066544, 0.316038340330124, 0.316180884838104, 0.316320985555649, 0.316460907459259, 0.316600680351257, 0.316740304231644, 0.316879749298096, 0.317019015550613, 0.317158102989197, 0.317297041416168, 0.317435801029205, 0.317574381828308, 0.317712813615799, 0.317851066589355, 0.3179891705513, 0.31812709569931, 0.318264842033386, 0.318402469158173, 0.31853985786438, 0.318677127361298, 0.318814218044281, 0.31895112991333, 0.319087862968445, 0.319224447011948, 0.319360852241516, 0.319497108459473, 0.319633185863495, 0.319769084453583, 0.319904834032059, 0.3200404047966, 0.320175796747208, 0.320311069488525, 0.320446103811264, 0.320581018924713, 0.320715755224228, 0.320850312709808, 0.320984721183777, 0.321118921041489, 0.321253001689911, 0.321386873722076, 0.32152059674263, 0.321654170751572, 0.321787536144257, 0.32192075252533, 0.322053819894791, 0.322186708450317, 0.32231941819191, 0.322451949119568, 0.322584331035614, 0.322716563940048, 0.322848588228226, 0.322980463504791, 0.323112189769745, 0.323243737220764, 0.323375076055527, 0.323506295681, 0.323637336492538, 0.32376816868782, 0.323898881673813, 0.324029415845871, 0.324159771203995, 0.324289977550507, 0.324419975280762, 0.324549853801727, 0.324679523706436, 0.324809044599533, 0.324938416481018, 0.325067579746246, 0.325196623802185, 0.325325459241867, 0.325454145669937, 0.325582653284073, 0.325711011886597, 0.325839191675186, 0.325967192649841, 0.326095044612885, 0.326222687959671, 0.326350212097168, 0.326477557420731, 0.326604694128036, 0.326731711626053, 0.326858550310135, 0.326985210180283, 0.327111691236496, 0.327238023281097, 0.327364206314087, 0.327490210533142, 0.327616006135941, 0.327741652727127, 0.327867150306702, 0.327992469072342, 0.328117609024048, 0.328242629766464, 0.328367412090302, 0.328492045402527, 0.32861652970314, 0.328740864992142, 0.328864991664886, 0.328988969326019, 0.329112768173218, 0.329236418008804, 0.329359889030457, 0.329483181238174, 0.32960632443428, 0.329729318618774, 0.329852104187012, 0.329974710941315, 0.330097198486328, 0.330219477415085, 0.330341637134552, 0.330463588237762, 0.330585360527039, 0.330706983804703, 0.330828428268433, 0.330949723720551, 0.331070840358734, 0.331191778182983, 0.331312566995621, 0.331433176994324, 0.331553637981415, 0.331673890352249, 0.331793993711472, 0.331913948059082, 0.332033723592758, 0.3321533203125, 0.332272797822952, 0.332392036914825, 0.332511126995087, 0.332630068063736, 0.332748830318451, 0.332867413759232, 0.332985818386078, 0.333104133605957, 0.333222210407257, 0.333340138196945, 0.333457887172699, 0.333575457334518, 0.333692878484726, 0.333810150623322, 0.333927243947983, 0.33404415845871, 0.334160894155502, 0.334277451038361, 0.334393888711929, 0.334510087966919, 0.334626197814941, 0.334742099046707, 0.334857851266861, 0.33497342467308, 0.335088819265366, 0.335204035043716, 0.335319131612778, 0.335434019565582, 0.335548728704453, 0.335663288831711, 0.33577772974968, 0.335891932249069, 0.336006015539169, 0.336119890213013, 0.336233586072922, 0.336347132921219, 0.336460530757904, 0.336573779582977, 0.336686819791794, 0.336799710988998, 0.336912393569946, 0.337024956941605, 0.337137371301651, 0.337249577045441, 0.337361544370651, 0.337473452091217, 0.337585151195526, 0.337696701288223, 0.337808042764664, 0.337919294834137, 0.338030338287354, 0.338141202926636, 0.338251888751984, 0.338362395763397, 0.338472783565521, 0.338582932949066, 0.338692992925644, 0.33880278468132, 0.338912546634674, 0.339022010564804, 0.339131385087967, 0.339240610599518, 0.339349567890167, 0.339458435773849, 0.339567124843597, 0.339675635099411, 0.33978396654129, 0.33989217877388, 0.340000152587891, 0.340107977390289, 0.340215712785721, 0.340323179960251, 0.340430498123169, 0.340537667274475, 0.340644657611847, 0.340751528739929, 0.340858191251755, 0.340964645147324, 0.341070979833603, 0.34117716550827, 0.341283142566681, 0.34138897061348, 0.341494619846344, 0.341600120067596, 0.341705441474915, 0.341810584068298, 0.341915547847748, 0.342020362615585, 0.342125058174133, 0.34222948551178, 0.342333763837814, 0.342437922954559, 0.342541933059692, 0.342645704746246, 0.342749357223511, 0.342852860689163, 0.342956155538559, 0.34305927157402, 0.343162208795547, 0.343264997005463, 0.343367666006088, 0.343470096588135, 0.343572407960892, 0.343674570322037, 0.343776524066925, 0.343878298997879, 0.343979865312576, 0.344081342220306, 0.344182640314102, 0.344283759593964, 0.344384729862213, 0.344485491514206, 0.344586104154587, 0.344686508178711, 0.344786822795868, 0.344886958599091, 0.344986855983734, 0.345086634159088, 0.34518626332283, 0.345285683870316, 0.345384955406189, 0.34548407793045, 0.345582991838455, 0.345681756734848, 0.345780313014984, 0.345878779888153, 0.345977038145065, 0.346075117588043, 0.346173048019409, 0.346270829439163, 0.346368372440338, 0.346465826034546, 0.346563041210175, 0.346660166978836, 0.346757024526596, 0.346853822469711, 0.34695041179657, 0.347046762704849, 0.347143024206161, 0.347239106893539, 0.347335040569305, 0.347430735826492, 0.34752631187439, 0.347621709108353, 0.347716957330704, 0.347812056541443, 0.347906887531281, 0.348001658916473, 0.348096191883087, 0.348190575838089, 0.348284810781479, 0.348378896713257, 0.348472774028778, 0.34856653213501, 0.34866002202034, 0.348753452301025, 0.348846644163132, 0.348939687013626, 0.349032580852509, 0.349125295877457, 0.349217861890793, 0.34931018948555, 0.34940242767334, 0.349494427442551, 0.349586337804794, 0.349678069353104, 0.349769562482834, 0.349860936403275, 0.349952131509781, 0.350043177604675, 0.350134044885635, 0.350224763154984, 0.350315272808075, 0.350405633449554, 0.3504958152771, 0.350585877895355, 0.350675702095032, 0.350765377283096, 0.350854873657227, 0.35094428062439, 0.351033449172974, 0.351122468709946, 0.351211309432983, 0.351299941539764, 0.351388484239578, 0.351476848125458, 0.351565003395081, 0.351652979850769, 0.351740807294846, 0.351828515529633, 0.35191598534584, 0.352003365755081, 0.352090537548065, 0.352177500724792, 0.35226434469223, 0.352351039648056, 0.352437525987625, 0.352523863315582, 0.352609992027283, 0.352696001529694, 0.352781802415848, 0.352867424488068, 0.352952986955643, 0.353038281202316, 0.353123426437378, 0.353208422660828, 0.353293210268021, 0.353377848863602, 0.353462338447571, 0.353546619415283, 0.353630781173706, 0.353714793920517, 0.353798538446426, 0.353882163763046, 0.353965640068054, 0.35404896736145, 0.354132115840912, 0.354215055704117, 0.354297876358032, 0.354380488395691, 0.354462951421738, 0.354545265436172, 0.354627370834351, 0.354709297418594, 0.354791104793549, 0.354872733354568, 0.354954183101654, 0.355035454034805, 0.355116575956345, 0.355197548866272, 0.355278342962265, 0.355358898639679, 0.355439394712448, 0.355519652366638, 0.355599761009216, 0.35567969083786, 0.355759471654892, 0.35583907365799, 0.35591846704483, 0.355997741222382, 0.356076836585999, 0.356155782938004, 0.356234550476074, 0.356313139200211, 0.356391578912735, 0.356469810009003, 0.356547921895981, 0.356625825166702, 0.356703609228134, 0.356781214475632, 0.35685858130455, 0.356935828924179, 0.357012927532196, 0.357089847326279, 0.357166618108749, 0.357243150472641, 0.357319533824921, 0.357395857572556, 0.357471883296967, 0.357547789812088, 0.357623517513275, 0.35769909620285, 0.357774496078491, 0.35784974694252, 0.357924789190292, 0.357999682426453, 0.358074426651001, 0.358148992061615, 0.358223408460617, 0.358297616243362, 0.358371675014496, 0.358445525169373, 0.358519226312637, 0.358592867851257, 0.358666211366653, 0.358739405870438, 0.358812481164932, 0.35888534784317, 0.358958065509796, 0.359030574560165, 0.359102994203568, 0.359175175428391, 0.359247267246246, 0.359319090843201, 0.359390825033188, 0.359462350606918, 0.359533727169037, 0.359604895114899, 0.359675914049149, 0.359746783971786, 0.35981747508049, 0.359888046979904, 0.359958380460739, 0.360028564929962, 0.360098570585251, 0.360168486833572, 0.360238134860992, 0.360307693481445, 0.360377013683319, 0.360446184873581, 0.360515236854553, 0.360584020614624, 0.360652714967728, 0.360721230506897, 0.360789597034454, 0.360857725143433, 0.360925763845444, 0.360993593931198, 0.361061245203018, 0.361128747463226, 0.3611960709095, 0.361263275146484, 0.361330300569534, 0.361397087574005, 0.361463755369186, 0.361530274152756, 0.361596554517746, 0.361662715673447, 0.361728727817535, 0.361794531345367, 0.361860185861588, 0.361925691366196, 0.36199101805687, 0.362056136131287, 0.362121164798737, 0.362185925245285, 0.362250566482544, 0.362315028905869, 0.362379342317581, 0.362443506717682, 0.362507492303848, 0.362571269273758, 0.362634867429733, 0.362698376178741, 0.362761676311493, 0.36282479763031, 0.362887769937515, 0.362950593233109, 0.363013178110123, 0.36307567358017, 0.363137930631638, 0.363200038671494, 0.363262057304382, 0.363323837518692, 0.363385409116745, 0.363446861505508, 0.363508194684982, 0.363569289445877, 0.363630205392838, 0.363691031932831, 0.363751620054245, 0.363812059164047, 0.363872349262238, 0.363932400941849, 0.363992393016815, 0.364052146673203, 0.3641117811203, 0.364171206951141, 0.364230453968048, 0.364289551973343, 0.364348500967026, 0.364407271146774, 0.364465862512589, 0.364524245262146, 0.364582508802414, 0.364640653133392, 0.364698559045792, 0.364756256341934, 0.36481386423111, 0.364871293306351, 0.364928543567657, 0.36498561501503, 0.36504253745079, 0.365099281072617, 0.365155845880508, 0.365212261676788, 0.3652603328228, 0.36530002951622, 0.365339487791061, 0.365378707647324, 0.365417748689651, 0.365456610918045, 0.365495294332504, 0.365533769130707, 0.365572035312653, 0.365610063076019, 0.365647971630096, 0.365685671567917, 0.365723162889481, 0.36576047539711, 0.36579754948616, 0.365834444761276, 0.36587119102478, 0.365907728672028, 0.365943968296051, 0.365980088710785, 0.366016060113907, 0.366051763296127, 0.366087317466736, 0.366122633218765, 0.366157799959183, 0.366192758083344, 0.366227477788925, 0.366262048482895, 0.366296350955963, 0.366330623626709, 0.366364538669586, 0.366398304700851, 0.366431921720505, 0.366465270519257, 0.366498440504074, 0.366531431674957, 0.366564273834229, 0.366596847772598, 0.366629302501678, 0.366661489009857, 0.366693496704102, 0.366725325584412, 0.366756916046143, 0.366788387298584, 0.366819620132446, 0.366850644350052, 0.366881489753723, 0.366912096738815, 0.366942554712296, 0.366972833871841, 0.367002904415131, 0.367032766342163, 0.367062449455261, 0.367091864347458, 0.367121189832687, 0.367150276899338, 0.367179155349731, 0.367207854986191, 0.367236316204071, 0.367264598608017, 0.367292791604996, 0.367320626974106, 0.367348372936249, 0.367375880479813, 0.36740317940712, 0.367430329322815, 0.367457240819931, 0.367483973503113, 0.367510497570038, 0.367536842823029, 0.367563009262085, 0.367588967084885, 0.36761474609375, 0.367640316486359, 0.367665648460388, 0.367690861225128, 0.367715835571289, 0.367740601301193, 0.367765188217163, 0.367789566516876, 0.367813766002655, 0.367837727069855, 0.367861539125443, 0.367885172367096, 0.367908537387848, 0.367931813001633, 0.367954760789871, 0.367977648973465, 0.368000209331512, 0.368022710084915, 0.368044883012772, 0.368066966533661, 0.368088811635971, 0.368110448122025, 0.368131935596466, 0.368153154850006, 0.368174225091934, 0.368195116519928, 0.368215799331665, 0.368236273527145, 0.368256539106369, 0.368276655673981, 0.368296533823013, 0.368316233158112, 0.368335664272308, 0.368355005979538, 0.368374109268188, 0.368393033742905, 0.368411749601364, 0.368430286645889, 0.368448585271835, 0.368466734886169, 0.368484646081924, 0.368502408266068, 0.368519961833954, 0.368537276983261, 0.368554443120956, 0.368571430444717, 0.368588179349899, 0.368604749441147, 0.368621081113815, 0.368637263774872, 0.368653297424316, 0.368669062852859, 0.368684619665146, 0.368699997663498, 0.368715226650238, 0.368730217218399, 0.368745058774948, 0.368759661912918, 0.368774056434631, 0.368788301944733, 0.3688023686409, 0.368816137313843, 0.368829786777496, 0.368843227624893, 0.368856489658356, 0.368869513273239, 0.368882358074188, 0.368894994258881, 0.368907451629639, 0.368919730186462, 0.368931800127029, 0.368943691253662, 0.368955373764038, 0.368966847658157, 0.368978083133698, 0.368989229202271, 0.369000107049942, 0.369010835886002, 0.369021326303482, 0.369031637907028, 0.369041740894318, 0.369051665067673, 0.369061350822449, 0.369070887565613, 0.369080245494843, 0.369089365005493, 0.369098275899887, 0.369107067584991, 0.369115591049194, 0.369123965501785, 0.36913213133812, 0.369140088558197, 0.369147837162018, 0.369155436754227, 0.369162797927856, 0.369169950485229, 0.369176954030991, 0.369183778762817, 0.369190365076065, 0.369196742773056, 0.369202941656113, 0.369208961725235, 0.369214743375778, 0.369220346212387, 0.369225800037384, 0.369231015443802, 0.369236052036285, 0.369240880012512, 0.369245529174805, 0.36924996972084, 0.369254231452942, 0.369258314371109, 0.369262129068375, 0.369265794754028, 0.369269281625748, 0.369272500276566, 0.369275599718094, 0.369278430938721, 0.369281142950058, 0.369283646345139, 0.36928591132164, 0.36928802728653, 0.369289964437485, 0.369291603565216, 0.36929315328598, 0.369294434785843, 0.369295567274094, 0.369296491146088, 0.369297206401825, 0.36929777264595, 0.369298070669174, 0.369298249483109, 0.369298160076141, 0.369297921657562, 0.369297444820404, 0.369296848773956, 0.369296014308929, 0.369294971227646, 0.369293749332428, 0.369292318820953, 0.3692906498909, 0.369288831949234, 0.369286864995956, 0.3692846596241, 0.369282305240631, 0.369279682636261, 0.369276881217957, 0.369273841381073, 0.3692706823349, 0.36926731467247, 0.369263738393784, 0.36925995349884, 0.369256019592285, 0.369251847267151, 0.369247496128082, 0.369242906570435, 0.369238197803497, 0.369233220815659, 0.369228094816208, 0.369222790002823, 0.369217246770859, 0.36921152472496, 0.369205594062805, 0.369199514389038, 0.369193196296692, 0.369186669588089, 0.369179934263229, 0.36917307972908, 0.369165986776352, 0.369158685207367, 0.36915123462677, 0.369143486022949, 0.369135588407516, 0.369127541780472, 0.369119256734848, 0.369110822677612, 0.369102150201797, 0.369093298912048, 0.369084268808365, 0.369075000286102, 0.36906561255455, 0.369055896997452, 0.369046121835709, 0.369036078453064, 0.369025826454163, 0.369015425443649, 0.369004815816879, 0.368994027376175, 0.368983030319214, 0.368971765041351, 0.368960410356522, 0.368948817253113, 0.368937015533447, 0.36892506480217, 0.368912875652313, 0.3689004778862, 0.368887901306152, 0.36887514591217, 0.368862181901932, 0.368849039077759, 0.368835657835007, 0.368822127580643, 0.368808388710022, 0.368794471025467, 0.368780344724655, 0.368765980005264, 0.368751466274261, 0.368736743927002, 0.368721812963486, 0.368706703186035, 0.36869141459465, 0.368675947189331, 0.368660181760788, 0.368644297122955, 0.368628203868866, 0.368611931800842, 0.368595451116562, 0.368578761816025, 0.368561923503876, 0.368544816970825, 0.368527591228485, 0.368510097265244, 0.368492484092712, 0.36847460269928, 0.368456572294235, 0.368438333272934, 0.368419885635376, 0.368401259183884, 0.368382424116135, 0.368363380432129, 0.368344187736511, 0.368324786424637, 0.368305146694183, 0.368285328149796, 0.368265360593796, 0.368245154619217, 0.368224799633026, 0.368204176425934, 0.368183374404907, 0.368162393569946, 0.368141233921051, 0.368119835853577, 0.368098318576813, 0.368076533079147, 0.36805459856987, 0.368032425642014, 0.368010073900223, 0.367987513542175, 0.367964774370193, 0.367941856384277, 0.367918729782104, 0.367895424365997, 0.367871910333633, 0.36784815788269, 0.367824256420135, 0.367800176143646, 0.3677758872509, 0.367751330137253, 0.367726683616638, 0.367701768875122, 0.367676675319672, 0.367651432752609, 0.367625951766968, 0.36760026216507, 0.367574363946915, 0.36754834651947, 0.367522090673447, 0.367495626211166, 0.367468953132629, 0.367442160844803, 0.367415100336075, 0.367387861013412, 0.367360413074493, 0.36733278632164, 0.367304980754852, 0.367276906967163, 0.367248743772507, 0.367220342159271, 0.367191702127457, 0.367162942886353, 0.367133915424347, 0.367104738950729, 0.36707529425621, 0.367045789957047, 0.367015957832336, 0.366986006498337, 0.366955816745758, 0.366925448179245, 0.366894900798798, 0.366864144802094, 0.366833209991455, 0.36680206656456, 0.366770684719086, 0.366739124059677, 0.366707414388657, 0.366675496101379, 0.36664342880249, 0.366611063480377, 0.366578549146652, 0.366545796394348, 0.366512924432755, 0.366479843854904, 0.366446524858475, 0.366413027048111, 0.366379350423813, 0.366345435380936, 0.366311341524124, 0.366277098655701, 0.366242617368698, 0.366207987070084, 0.366173088550568, 0.366138011217117, 0.366102784872055, 0.366067349910736, 0.36603170633316, 0.365995854139328, 0.365959793329239, 0.365923583507538, 0.365887135267258, 0.365850508213043, 0.365813732147217, 0.365776687860489, 0.365739494562149, 0.365702092647552, 0.365664482116699, 0.365626692771912, 0.365588694810867, 0.365550518035889, 0.365512132644653, 0.365473538637161, 0.365434795618057, 0.365395814180374, 0.365356653928757, 0.365317314863205, 0.365277767181396, 0.365238010883331, 0.365198045969009, 0.365157902240753, 0.36511754989624, 0.365077018737793, 0.365036308765411, 0.364995360374451, 0.364954233169556, 0.364912956953049, 0.36487141251564, 0.36482971906662, 0.364787817001343, 0.364745676517487, 0.364703416824341, 0.364660918712616, 0.364618241786957, 0.364575386047363, 0.364532291889191, 0.364489018917084, 0.36444553732872, 0.364401906728745, 0.364358067512512, 0.364313960075378, 0.364269703626633, 0.36422523856163, 0.364180624485016, 0.364135801792145, 0.364090770483017, 0.364045530557632, 0.364000111818314, 0.36395451426506, 0.363908648490906, 0.363862693309784, 0.363816499710083, 0.363770097494125, 0.363723486661911, 0.363676697015762, 0.363629698753357, 0.363582521677017, 0.363535165786743, 0.36348757147789, 0.363439798355103, 0.363391876220703, 0.36334365606308, 0.363295346498489, 0.363246738910675, 0.363198012113571, 0.363149046897888, 0.363099962472916, 0.363050639629364, 0.363001108169556, 0.362951338291168, 0.362901419401169, 0.362851321697235, 0.362800985574722, 0.362750500440598, 0.362699806690216, 0.362648904323578, 0.362597793340683, 0.362546473741531, 0.36249503493309, 0.36244335770607, 0.362391471862793, 0.362339437007904, 0.362287133932114, 0.362234711647034, 0.362182021141052, 0.362129151821136, 0.362076133489609, 0.362022906541824, 0.361969411373138, 0.361915826797485, 0.361861974000931, 0.361807942390442, 0.361753731966019, 0.361699283123016, 0.361644685268402, 0.361589878797531, 0.361534893512726, 0.361479669809341, 0.361424297094345, 0.36136868596077, 0.36131289601326, 0.361256927251816, 0.361200720071793, 0.36114439368248, 0.361087799072266, 0.361031055450439, 0.360974103212357, 0.360916972160339, 0.360859602689743, 0.36080202460289, 0.360744297504425, 0.360681802034378, 0.360614627599716, 0.360547304153442, 0.360479861497879, 0.360412329435349, 0.360344618558884, 0.360276818275452, 0.360208928585052, 0.360140860080719, 0.360072731971741, 0.360004425048828, 0.359936058521271, 0.359867572784424, 0.35979887843132, 0.359730124473572, 0.359661251306534, 0.359592288732529, 0.359523147344589, 0.359453856945038, 0.359384506940842, 0.359315067529678, 0.359245419502258, 0.359175711870193, 0.359105855226517, 0.35903587937355, 0.358965784311295, 0.358895570039749, 0.358825266361237, 0.35875478386879, 0.358684211969376, 0.358613520860672, 0.358542710542679, 0.358471810817719, 0.358400702476501, 0.35832953453064, 0.358258247375488, 0.358186781406403, 0.358115285634995, 0.358043640851974, 0.35797181725502, 0.357899934053421, 0.35782790184021, 0.357755780220032, 0.357683479785919, 0.357611119747162, 0.357538610696793, 0.357465952634811, 0.357393205165863, 0.357320338487625, 0.357247352600098, 0.357174277305603, 0.357100993394852, 0.357027649879456, 0.35695418715477, 0.35688054561615, 0.356806844472885, 0.356733024120331, 0.356659054756165, 0.356584966182709, 0.356510788202286, 0.356436431407928, 0.356362044811249, 0.356287449598312, 0.356212764978409, 0.356137961149216, 0.356063038110733, 0.355987995862961, 0.355912834405899, 0.355837494134903, 0.355762153863907, 0.355686575174332, 0.355610936880112, 0.35553514957428, 0.355459272861481, 0.355383276939392, 0.355307132005692, 0.355230867862701, 0.355154484510422, 0.355077981948853, 0.355001360177994, 0.354924649000168, 0.35484778881073, 0.35477077960968, 0.354693681001663, 0.354616463184357, 0.354539126157761, 0.354461669921875, 0.354384064674377, 0.354306399822235, 0.354228585958481, 0.354150623083115, 0.354072570800781, 0.353994339704514, 0.353916019201279, 0.353837579488754, 0.353759050369263, 0.353680372238159, 0.353601545095444, 0.353522628545761, 0.353443652391434, 0.353364497423172, 0.353285193443298, 0.353205800056458, 0.353126257658005, 0.353046655654907, 0.352966874837875, 0.352887004613876, 0.352806985378265, 0.35272690653801, 0.35264664888382, 0.352566242218018, 0.352485746145248, 0.352405160665512, 0.352324455976486, 0.352243572473526, 0.352162599563599, 0.352081507444382, 0.352000325918198, 0.351918965578079, 0.351837545633316, 0.351755976676941, 0.351674199104309, 0.351592421531677, 0.351510465145111, 0.3514284491539, 0.351346254348755, 0.35126394033432, 0.351181536912918, 0.351098984479904, 0.351016312837601, 0.35093355178833, 0.350850641727448, 0.350767612457275, 0.350684463977814, 0.350601226091385, 0.350517809391022, 0.350434303283691, 0.350350677967072, 0.35026690363884, 0.350183069705963, 0.350099056959152, 0.350014954805374, 0.349930733442307, 0.349846333265305, 0.349761873483658, 0.349677264690399, 0.349592596292496, 0.349507749080658, 0.349422782659531, 0.349337667226791, 0.349252492189407, 0.349167168140411, 0.349081724882126, 0.348996162414551, 0.348910480737686, 0.34882465004921, 0.348738789558411, 0.348652690649033, 0.34856653213501, 0.348480254411697, 0.348393827676773, 0.348307281732559, 0.348220646381378, 0.348133862018585, 0.348046958446503, 0.347959965467453, 0.347872793674469, 0.34778556227684, 0.347698181867599, 0.347610712051392, 0.347523063421249, 0.34743532538414, 0.347347497940063, 0.347259521484375, 0.347171396017075, 0.347083151340485, 0.34699484705925, 0.346906363964081, 0.346817761659622, 0.346729069948196, 0.346640259027481, 0.346551269292831, 0.346462190151215, 0.346373021602631, 0.346283674240112, 0.346194267272949, 0.346104711294174, 0.346015065908432, 0.345925271511078, 0.345835357904434, 0.345745325088501, 0.345655143260956, 0.345564872026443, 0.345474481582642, 0.345383942127228, 0.345293313264847, 0.345202565193176, 0.345111668109894, 0.345020681619644, 0.344929575920105, 0.344838261604309, 0.344746977090836, 0.344655424356461, 0.344563812017441, 0.344472110271454, 0.344380259513855, 0.344288259744644, 0.344196170568466, 0.344103991985321, 0.344011664390564, 0.343919187784195, 0.343826621770859, 0.343733936548233, 0.343641102313995, 0.343548178672791, 0.343455106019974, 0.343361914157867, 0.343268632888794, 0.343175202608109, 0.343081682920456, 0.342988014221191, 0.342894196510315, 0.342800289392471, 0.342706322669983, 0.34261217713356, 0.342517882585526, 0.342423498630524, 0.34232896566391, 0.342234343290329, 0.342139571905136, 0.342044711112976, 0.341949701309204, 0.341854631900787, 0.341759383678436, 0.341664046049118, 0.341568559408188, 0.341472953557968, 0.341377198696136, 0.341281414031982, 0.341185450553894, 0.341089338064194, 0.340993136167526, 0.340896844863892, 0.340800374746323, 0.340703845024109, 0.340607106685638, 0.340510308742523, 0.340413391590118, 0.340316355228424, 0.340219169855118, 0.340121895074844, 0.340024501085281, 0.339926958084106, 0.33982926607132, 0.339731514453888, 0.339633643627167, 0.339535593986511, 0.339437484741211, 0.339339226484299, 0.339240819215775, 0.339142352342606, 0.339043706655502, 0.338945001363754, 0.338846117258072, 0.338747173547745, 0.338648051023483, 0.338548809289932, 0.338449478149414, 0.338349997997284, 0.338250428438187, 0.3381507396698, 0.338050872087479, 0.337950944900513, 0.337850898504257, 0.337750673294067, 0.33765035867691, 0.337549924850464, 0.337449371814728, 0.337348699569702, 0.337247908115387, 0.337146997451782, 0.337045937776566, 0.336944818496704, 0.336843490600586, 0.336742103099823, 0.336640566587448, 0.336538970470428, 0.336437195539474, 0.336335301399231, 0.336233288049698, 0.336131155490875, 0.336028903722763, 0.335926562547684, 0.33582404255867, 0.335721462965012, 0.335618704557419, 0.335515886545181, 0.335412919521332, 0.33530980348587, 0.335206627845764, 0.335103273391724, 0.334999799728394, 0.334896236658096, 0.33479255437851, 0.334688752889633, 0.334584802389145, 0.334480732679367, 0.334376573562622, 0.334272235631943, 0.334167838096619, 0.334063291549683, 0.333958655595779, 0.333853870630264, 0.333748936653137, 0.333643913269043, 0.333538770675659, 0.333433508872986, 0.333328098058701, 0.333222568035126, 0.333116978406906, 0.333011239767075, 0.332905352115631, 0.33279937505722, 0.332693219184875, 0.332587003707886, 0.332480639219284, 0.332374155521393, 0.332267582416534, 0.332160860300064, 0.332054018974304, 0.331947028636932, 0.331839948892593, 0.331732749938965, 0.331625431776047, 0.331517994403839, 0.331410437822342, 0.331302732229233, 0.331194937229156, 0.331087023019791, 0.330978959798813, 0.330870777368546, 0.330762475728989, 0.330654084682465, 0.330545574426651, 0.330436885356903, 0.33032813668251, 0.330219238996506, 0.330110222101212, 0.330001085996628, 0.329891830682755, 0.329782456159592, 0.329672932624817, 0.329563349485397, 0.329453587532043, 0.329343736171722, 0.329233735799789, 0.329123616218567, 0.3290134370327, 0.328903079032898, 0.328792631626129, 0.328682005405426, 0.328571289777756, 0.328460484743118, 0.328349530696869, 0.32823845744133, 0.328127294778824, 0.328015953302383, 0.327904522418976, 0.327792972326279, 0.32768127322197, 0.327569514513016, 0.327457576990128, 0.327345550060272, 0.327233374118805, 0.327121078968048, 0.327008724212646, 0.326896190643311, 0.326783537864685, 0.32667076587677, 0.326557904481888, 0.326444894075394, 0.32633176445961, 0.326218515634537, 0.326105147600174, 0.325991660356522, 0.32587805390358, 0.325764328241348, 0.325650483369827, 0.325536489486694, 0.325422406196594, 0.325308203697205, 0.325193881988525, 0.325079411268234, 0.324964821338654, 0.324850142002106, 0.324735313653946, 0.324620366096497, 0.32450532913208, 0.324390143156052, 0.324274837970734, 0.324159413576126, 0.324043869972229, 0.323928207159042, 0.323812395334244, 0.3236965239048, 0.323580473661423, 0.323464334011078, 0.323348075151443, 0.32323169708252, 0.323115170001984, 0.322998523712158, 0.322881788015366, 0.322764903306961, 0.322647899389267, 0.322530806064606, 0.322413593530655, 0.32229620218277, 0.32217875123024, 0.322061121463776, 0.321943402290344, 0.321825563907623, 0.321707606315613, 0.321589559316635, 0.321471333503723, 0.321353018283844, 0.321234554052353, 0.321115970611572, 0.320997297763824, 0.320878505706787, 0.320759564638138, 0.320640504360199, 0.320521354675293, 0.320402055978775, 0.32028266787529, 0.32016310095787, 0.320043474435806, 0.31992369890213, 0.319803774356842, 0.319683760404587, 0.319563657045364, 0.319443374872208, 0.319323003292084, 0.31920251250267, 0.319081902503967, 0.31896111369133, 0.318840265274048, 0.318719297647476, 0.318598181009293, 0.318476974964142, 0.318355619907379, 0.318234145641327, 0.318112552165985, 0.317990869283676, 0.317869037389755, 0.317747056484222, 0.317624986171722, 0.317502796649933, 0.317380517721176, 0.317258059978485, 0.317135512828827, 0.317012846469879, 0.316890060901642, 0.316767156124115, 0.316644072532654, 0.316520929336548, 0.31639763712883, 0.316274255514145, 0.316150724887848, 0.316027075052261, 0.315903306007385, 0.315779447555542, 0.315655440092087, 0.315531313419342, 0.315407037734985, 0.315282702445984, 0.31515821814537, 0.315033584833145, 0.314908862113953, 0.314783990383148, 0.314659029245377, 0.314533948898315, 0.314408719539642, 0.314283400774002, 0.31415793299675, 0.314032346010208, 0.313906669616699, 0.313780844211578, 0.313654899597168, 0.313528835773468, 0.313402682542801, 0.313276350498199, 0.313149929046631, 0.313023388385773, 0.312896728515625, 0.312769949436188, 0.312643021345139, 0.312516033649445, 0.312388867139816, 0.312261581420898, 0.312134176492691, 0.312009066343307, 0.311886191368103, 0.311763316392899, 0.311640411615372, 0.311517477035522, 0.311394482851028, 0.311271518468857, 0.31114849448204, 0.311025410890579, 0.31090235710144, 0.310779273509979, 0.310656130313873, 0.310532927513123, 0.310409754514694, 0.310286521911621, 0.310163289308548, 0.310039967298508, 0.30991667509079, 0.30979335308075, 0.309670001268387, 0.309546589851379, 0.309423178434372, 0.309299737215042, 0.309176236391068, 0.309052765369415, 0.308929204940796, 0.308805644512177, 0.308682054281235, 0.308558404445648, 0.308434784412384, 0.308311104774475, 0.308187365531921, 0.30806365609169, 0.307939916849136, 0.307816088199615, 0.307692289352417, 0.307568430900574, 0.307444542646408, 0.307320654392242, 0.307196706533432, 0.307072758674622, 0.306948781013489, 0.306824773550034, 0.306700706481934, 0.306576639413834, 0.306452512741089, 0.306328386068344, 0.306204199790955, 0.306080043315887, 0.305955827236176, 0.305831581354141, 0.305707305669785, 0.305583000183105, 0.305458664894104, 0.305334329605103, 0.305209904909134, 0.305085510015488, 0.304961055517197, 0.304836601018906, 0.30471208691597, 0.304587543010712, 0.304462969303131, 0.304338425397873, 0.304213792085648, 0.3040891289711, 0.303964465856552, 0.303839772939682, 0.303715020418167, 0.303590267896652, 0.303465515375137, 0.303340673446655, 0.303215831518173, 0.303090959787369, 0.302966058254242, 0.302841126918793, 0.302716165781021, 0.30259120464325, 0.302466183900833, 0.302341133356094, 0.302216053009033, 0.30209094285965, 0.301965832710266, 0.301840662956238, 0.301715493202209, 0.301590293645859, 0.301465004682541, 0.301339775323868, 0.301214456558228, 0.301089107990265, 0.300963759422302, 0.300838381052017, 0.300713002681732, 0.30058753490448, 0.300462067127228, 0.300336569547653, 0.300211042165756, 0.300085484981537, 0.299959897994995, 0.299834281206131, 0.299708664417267, 0.299582988023758, 0.299457311630249, 0.299331575632095, 0.299205809831619, 0.299080044031143, 0.298954218626022, 0.298828393220901, 0.298702508211136, 0.29857662320137, 0.298450708389282, 0.298324733972549, 0.298198759555817, 0.298072725534439, 0.297946691513062, 0.297820657491684, 0.297694534063339, 0.297568410634995, 0.297442257404327, 0.297316074371338, 0.297189891338348, 0.297063618898392, 0.296937376260757, 0.296811074018478, 0.296684741973877, 0.296558409929276, 0.296432048082352, 0.296305626630783, 0.296179175376892, 0.296052724123001, 0.295926213264465, 0.295799732208252, 0.295673131942749, 0.295546561479568, 0.295419961214066, 0.29529333114624, 0.29516664147377, 0.295039981603622, 0.29491326212883, 0.294786483049393, 0.294659733772278, 0.294532924890518, 0.294406086206436, 0.294279217720032, 0.294152319431305, 0.294025391340256, 0.293898463249207, 0.293771505355835, 0.293644487857819, 0.29351744055748, 0.293390363454819, 0.293263286352158, 0.293136179447174, 0.293009042739868, 0.292881846427917, 0.292754650115967, 0.292627394199371, 0.292500138282776, 0.29237288236618, 0.292245537042618, 0.292118191719055, 0.29199081659317, 0.291863411664963, 0.291735976934433, 0.291608542203903, 0.291481018066406, 0.291353523731232, 0.291225969791412, 0.291098415851593, 0.290970802307129, 0.290843158960342, 0.290715515613556, 0.290587812662125, 0.290460079908371, 0.290332347154617, 0.290204584598541, 0.290076792240143, 0.2899489402771, 0.289821088314056, 0.289693176746368, 0.28956526517868, 0.28943732380867, 0.289309352636337, 0.289181381464005, 0.289053320884705, 0.288925290107727, 0.288797199726105, 0.28866907954216, 0.288540929555893, 0.288412779569626, 0.288284569978714, 0.288156360387802, 0.288028091192245, 0.287899792194366, 0.287771463394165, 0.287643134593964, 0.287514746189117, 0.287386357784271, 0.287257939577103, 0.287129461765289, 0.287001013755798, 0.286872506141663, 0.286743938922882, 0.286615371704102, 0.286486774682999, 0.286358147859573, 0.286229521036148, 0.286100804805756, 0.285972088575363, 0.285843372344971, 0.285714596509933, 0.285585790872574, 0.285456955432892, 0.28532811999321, 0.285199224948883, 0.285070329904556, 0.284941375255585, 0.284812420606613, 0.284683406352997, 0.28455439209938, 0.284425318241119, 0.284296274185181, 0.284167140722275, 0.284038007259369, 0.283908843994141, 0.28377965092659, 0.283650428056717, 0.283521175384521, 0.283391892910004, 0.283262580633163, 0.283133238554001, 0.283003866672516, 0.282874494791031, 0.282745033502579, 0.282615602016449, 0.282486110925674, 0.2823566198349, 0.282227069139481, 0.282097488641739, 0.28196793794632, 0.281838297843933, 0.281708627939224, 0.281578958034515, 0.281449258327484, 0.28131952881813, 0.281189769506454, 0.281059950590134, 0.280930131673813, 0.28080028295517, 0.280670404434204, 0.280540525913239, 0.280410587787628, 0.280280619859695, 0.28015062212944, 0.280020594596863, 0.279890537261963, 0.279760450124741, 0.279630362987518, 0.279500216245651, 0.279370069503784, 0.279239863157272, 0.27910965681076, 0.278979420661926, 0.278849124908447, 0.278718829154968, 0.278588473796844, 0.278458118438721, 0.278327733278275, 0.278197318315506, 0.278066873550415, 0.277936398983002, 0.277805894613266, 0.27767539024353, 0.277544796466827, 0.277414202690125, 0.277283608913422, 0.277152955532074, 0.277022272348404, 0.276891559362411, 0.276760846376419, 0.276630103588104, 0.276499271392822, 0.276368468999863, 0.276237636804581, 0.276106745004654, 0.275975853204727, 0.275844931602478, 0.275713950395584, 0.27558296918869, 0.275451958179474, 0.275320917367935, 0.275189846754074, 0.275058716535568, 0.274927586317062, 0.274796456098557, 0.274665266275406, 0.274534046649933, 0.27440282702446, 0.274271547794342, 0.274140238761902, 0.274008899927139, 0.273877531290054, 0.273746162652969, 0.27361473441124, 0.27348330616951, 0.273351848125458, 0.273220330476761, 0.273088783025742, 0.272957235574722, 0.272825658321381, 0.272694081068039, 0.27256241440773, 0.272430747747421, 0.27229905128479, 0.272167325019836, 0.272035539150238, 0.271903783082962, 0.271771967411041, 0.271640121936798, 0.271508246660233, 0.271376371383667, 0.271244406700134, 0.271112471818924, 0.270980477333069, 0.270848482847214, 0.270716428756714, 0.270584374666214, 0.270452260971069, 0.270320147275925, 0.270188003778458, 0.270055830478668, 0.269923597574234, 0.269791334867477, 0.269659101963043, 0.269526809453964, 0.26939445734024, 0.269262135028839, 0.269129753112793, 0.268997311592102, 0.268864899873734, 0.26873242855072, 0.268599927425385, 0.268467396497726, 0.268334865570068, 0.268202275037766, 0.26806965470314, 0.267937034368515, 0.267804354429245, 0.267671674489975, 0.26753893494606, 0.267406165599823, 0.267273426055908, 0.267140597105026, 0.267007768154144, 0.26687490940094, 0.266742020845413, 0.266609072685242, 0.26647612452507, 0.266343146562576, 0.26621013879776, 0.266077131032944, 0.265944063663483, 0.265810936689377, 0.265677839517593, 0.265544682741165, 0.265411525964737, 0.265278309583664, 0.265145063400269, 0.265011787414551, 0.264878511428833, 0.26474517583847, 0.264611840248108, 0.264478474855423, 0.264345079660416, 0.264211624860764, 0.264078170061111, 0.263944685459137, 0.263811141252518, 0.263677626848221, 0.263544052839279, 0.263410449028015, 0.263276815414429, 0.26314315199852, 0.263009458780289, 0.262875735759735, 0.262741982936859, 0.262608200311661, 0.262474417686462, 0.262340575456619, 0.262206733226776, 0.262072801589966, 0.2619389295578, 0.261804968118668, 0.261671006679535, 0.261536985635757, 0.26140296459198, 0.26126891374588, 0.261134803295135, 0.261000692844391, 0.260866522789001, 0.260732382535934, 0.260598182678223, 0.260463923215866, 0.26032966375351, 0.260195374488831, 0.260061085224152, 0.259926736354828, 0.259792357683182, 0.259657949209213, 0.259523540735245, 0.259389072656631, 0.259254604578018, 0.25912007689476, 0.25898551940918, 0.258850961923599, 0.258716344833374, 0.258581727743149, 0.258447051048279, 0.258312404155731, 0.258177667856216, 0.258042931556702, 0.257908165454865, 0.257773369550705, 0.257638543844223, 0.257503688335419, 0.25736877322197, 0.257233887910843, 0.257098942995071, 0.256963968276978, 0.256828993558884, 0.256693959236145, 0.256558895111084, 0.256423801183701, 0.256288707256317, 0.256153553724289, 0.256018370389938, 0.25588321685791, 0.255747973918915, 0.255612730979919, 0.255477428436279, 0.255342125892639, 0.255206763744354, 0.255071431398392, 0.254936009645462, 0.254800587892532, 0.25466513633728, 0.254529654979706, 0.254394143819809, 0.25425860285759, 0.254123032093048, 0.253987461328506, 0.253851801156998, 0.253716170787811, 0.25358048081398, 0.253444790840149, 0.253309041261673, 0.253173261880875, 0.253037482500076, 0.252901643514633, 0.25276580452919, 0.252629935741425, 0.252494007349014, 0.252358078956604, 0.252222120761871, 0.252086132764816, 0.251950085163116, 0.251814037561417, 0.251677960157394, 0.251541882753372, 0.251405715942383, 0.251269578933716, 0.251133352518082, 0.25099715590477, 0.250860869884491, 0.250724613666534, 0.250588297843933, 0.250451982021332, 0.250315636396408, 0.25017923116684, 0.250042825937271, 0.249906346201897, 0.249769866466522, 0.249633371829987, 0.249496832489967, 0.249360278248787, 0.249223694205284, 0.249087050557137, 0.24895042181015, 0.24881374835968, 0.248677030205727, 0.248540297150612, 0.248403564095497, 0.248266741633415, 0.248129934072495, 0.247993096709251, 0.247856229543686, 0.247719317674637, 0.247582361102104, 0.247445419430733, 0.247308418154716, 0.247171401977539, 0.247039571404457, 0.246912717819214, 0.246785879135132, 0.246659025549889, 0.246532171964645, 0.246405318379402, 0.246278509497643, 0.246151655912399, 0.24602484703064, 0.24589803814888, 0.245771184563637, 0.245644375681877, 0.245517566800117, 0.245390757918358, 0.245263963937759, 0.245137169957161, 0.245010375976562, 0.244883596897125, 0.244756817817688, 0.24463002383709, 0.244503244757652, 0.244376480579376, 0.2442497164011, 0.244122937321663, 0.24399621784687, 0.243869453668594, 0.243742704391479, 0.243615955114365, 0.243489220738411, 0.243362486362457, 0.243235766887665, 0.243109062314034, 0.242982342839241, 0.242855608463287, 0.242728888988495, 0.242602184414864, 0.242475509643555, 0.242348790168762, 0.242222100496292, 0.242095410823822, 0.241968721151352, 0.241842031478882, 0.241715371608734, 0.241588681936264, 0.241462022066116, 0.24133537709713, 0.241208747029305, 0.241082072257996, 0.24095544219017, 0.240828782320023, 0.240702152252197, 0.240575522184372, 0.240448877215385, 0.24032224714756, 0.240195631980896, 0.240069016814232, 0.239942401647568, 0.239815816283226, 0.239689216017723, 0.239562600851059, 0.239436015486717, 0.239309415221214, 0.239182829856873, 0.239056244492531, 0.23892967402935, 0.23880310356617, 0.23867654800415, 0.238549992442131, 0.238423421978951, 0.238296881318092, 0.238170310854912, 0.238043770194054, 0.237917244434357, 0.237790703773499, 0.237664192914963, 0.237537652254105, 0.237411126494408, 0.237284630537033, 0.237158089876175, 0.2370315939188, 0.236905097961426, 0.23677858710289, 0.236652106046677, 0.236525624990463, 0.23639914393425, 0.236272647976875, 0.236146196722984, 0.236019715666771, 0.235893234610558, 0.235766783356667, 0.235640332102776, 0.235513880848885, 0.235387444496155, 0.235260963439941, 0.235134541988373, 0.235008105635643, 0.234881669282913, 0.234755262732506, 0.234628841280937, 0.234502419829369, 0.234376013278961, 0.234249606728554, 0.234123170375824, 0.233996793627739, 0.233870387077332, 0.233744010329247, 0.233617633581161, 0.233491256833076, 0.233364880084991, 0.233238503336906, 0.233112126588821, 0.232985779643059, 0.232859402894974, 0.232733070850372, 0.232606694102287, 0.232480362057686, 0.232354015111923, 0.232227697968483, 0.23210135102272, 0.231975048780441, 0.231848701834679, 0.231722414493561, 0.231596067547798, 0.23146978020668, 0.231343477964401, 0.231217160820961, 0.231090888381004, 0.230964586138725, 0.230838283896446, 0.230712026357651, 0.230585768818855, 0.230459466576576, 0.230333209037781, 0.230206951498985, 0.23008069396019, 0.229954436421394, 0.229828178882599, 0.229701936244965, 0.229575708508492, 0.229449436068535, 0.229323238134384, 0.229197010397911, 0.229070782661438, 0.228944569826126, 0.228818342089653, 0.228692129254341, 0.228565946221352, 0.228439748287201, 0.22831355035305, 0.228187367320061, 0.22806116938591, 0.227934971451759, 0.227808833122253, 0.227682650089264, 0.227556467056274, 0.227430298924446, 0.22730416059494, 0.227178007364273, 0.227051854133606, 0.2269257158041, 0.226799547672272, 0.226673409342766, 0.226547300815582, 0.226421177387238, 0.226295053958893, 0.226168930530548, 0.226042836904526, 0.225916713476181, 0.225790590047836, 0.225664511322975, 0.225538417696953, 0.22541232407093, 0.225286230444908, 0.225160121917725, 0.225034087896347, 0.224907979369164, 0.224781945347786, 0.224655881524086, 0.224529817700386, 0.224403753876686, 0.224277704954147, 0.22415167093277, 0.224025622010231, 0.223899587988853, 0.223773553967476, 0.223647519946098, 0.223521530628204, 0.223395466804504, 0.223269462585449, 0.223143458366394, 0.223017439246178, 0.222891464829445, 0.22276546061039, 0.222639501094818, 0.222513481974602, 0.222387492656708, 0.222261533141136, 0.222135528922081, 0.222009584307671, 0.221883624792099, 0.221757665276527, 0.221631720662117, 0.221505761146545, 0.221379786729813, 0.221253871917725, 0.221127942204475, 0.221001997590065, 0.220876097679138, 0.220750153064728, 0.22062423825264, 0.220498308539391, 0.220372408628464, 0.220246508717537, 0.220120593905449, 0.219994693994522, 0.219868838787079, 0.21974290907383, 0.219617053866386, 0.219491168856621, 0.219365298748016, 0.219239428639412, 0.219113573431969, 0.218987703323364, 0.218861848115921, 0.218735978007317, 0.218610152602196, 0.218484297394753, 0.218358471989632, 0.218232616782188, 0.21810682117939, 0.217980980873108, 0.217855170369148, 0.217729344964027, 0.217603519558907, 0.217477738857269, 0.21735192835331, 0.217226147651672, 0.217100337147713, 0.216974556446075, 0.216848775744438, 0.21672298014164, 0.216597214341164, 0.216471448540688, 0.21634566783905, 0.216219931840897, 0.216094180941582, 0.215968430042267, 0.215842694044113, 0.215716928243637, 0.215591192245483, 0.21546545624733, 0.215339750051498, 0.215213999152184, 0.215088292956352, 0.214962586760521, 0.214836835861206, 0.214711159467697, 0.214585468173027, 0.214459761977196, 0.214334055781364, 0.214208349585533, 0.214082688093185, 0.213957011699677, 0.213831350207329, 0.213705658912659, 0.213579997420311, 0.213454350829124, 0.213328704237938, 0.21320304274559, 0.213077396154404, 0.212951764464378, 0.212826102972031, 0.212700471282005, 0.21257483959198, 0.212449222803116, 0.212323635816574, 0.212198004126549, 0.212072357535362, 0.211946785449982, 0.211821153759956, 0.211695566773415, 0.211569979786873, 0.211444392800331, 0.211318805813789, 0.211193218827248, 0.211067646741867, 0.210942089557648, 0.210816532373428, 0.210690945386887, 0.210565403103828, 0.210439845919609, 0.210314303636551, 0.210188761353493, 0.210063204169273, 0.209937706589699, 0.209812149405479, 0.209686636924744, 0.209561109542847, 0.209435611963272, 0.209310069680214, 0.209184572100639, 0.209059059619904, 0.208933591842651, 0.208808079361916, 0.208682611584663, 0.208557099103928, 0.208431631326675, 0.208306163549423, 0.20818068087101, 0.208055227994919, 0.207929760217667, 0.207804307341576, 0.207678854465485, 0.207553386688232, 0.207427963614464, 0.207302510738373, 0.207177102565765, 0.207051634788513, 0.206926211714745, 0.206800803542137, 0.206675380468369, 0.206549942493439, 0.206424564123154, 0.206299170851707, 0.206173777580261, 0.206048339605331, 0.205922991037369, 0.205797612667084, 0.205672219395638, 0.205546826124191, 0.205421477556229, 0.205296084284782, 0.20517073571682, 0.205045387148857, 0.204920023679733, 0.204794675111771, 0.204669341444969, 0.204544022679329, 0.204418659210205, 0.204293340444565, 0.204168006777763, 0.204042688012123, 0.203917384147644, 0.203792065382004, 0.203666761517525, 0.203541442751884, 0.203416138887405, 0.203290864825249, 0.203165546059608, 0.203040271997452, 0.202915012836456, 0.2027897387743, 0.202664449810982, 0.202539190649986, 0.20241391658783, 0.202288642525673, 0.202163413167, 0.202038168907166, 0.20191290974617, 0.201787680387497, 0.201662451028824, 0.20153720676899, 0.201411962509155, 0.201286762952805, 0.201161548495293, 0.20103631913662, 0.20091113448143, 0.200785934925079, 0.200660735368729, 0.200535506010056, 0.200410336256027, 0.200285166501999, 0.200159966945648, 0.200034782290459, 0.199909627437592, 0.199784472584724, 0.199659273028374, 0.199534118175507, 0.199408963322639, 0.199283808469772, 0.199158698320389, 0.199033543467522, 0.198908388614655, 0.198783278465271, 0.198658138513565, 0.19853301346302, 0.198407888412476, 0.198282778263092, 0.198157712817192, 0.198032557964325, 0.197907477617264, 0.197782397270203, 0.19765730202198, 0.197532221674919, 0.197407141327858, 0.197282060980797, 0.197156995534897, 0.197031915187836, 0.196906834840775, 0.196781769394875, 0.196656733751297, 0.196531668305397, 0.196406662464142, 0.196281582117081, 0.196156546473503, 0.196031540632248, 0.195906475186348, 0.195781484246254, 0.195656463503838, 0.195531457662582, 0.195406436920166, 0.19528141617775, 0.195156440138817, 0.195031434297562, 0.194906428456306, 0.194781482219696, 0.194656476378441, 0.194531500339508, 0.194406524300575, 0.194281578063965, 0.19415657222271, 0.19403164088726, 0.193906709551811, 0.19378174841404, 0.193656787276268, 0.19353187084198, 0.193406909704208, 0.193281963467598, 0.19315704703331, 0.193032130599022, 0.192907184362411, 0.192782297730446, 0.192657381296158, 0.192532479763031, 0.192407578229904, 0.1922827064991, 0.192157790064812, 0.192032903432846, 0.191908031702042, 0.191783159971237, 0.191658273339272, 0.191533401608467, 0.191408544778824, 0.191283687949181, 0.191158831119537, 0.191033974289894, 0.190909132361412, 0.190784275531769, 0.190659448504448, 0.190534621477127, 0.190409779548645, 0.190284937620163, 0.190160140395164, 0.190035328269005, 0.189910501241684, 0.189785704016685, 0.189660951495171, 0.189536109566689, 0.18941131234169, 0.189286544919014, 0.189161747694016, 0.189036950469017, 0.188912197947502, 0.188787430524826, 0.18866266310215, 0.188537910580635, 0.18841315805912, 0.188288420438766, 0.188163638114929, 0.188038900494576, 0.187914162874222, 0.187789425253868, 0.187664702534676, 0.187540009617805, 0.187415242195129, 0.18729056417942, 0.187165841460228, 0.187041163444519, 0.186916425824165, 0.186791718006134, 0.186667039990425, 0.186542361974716, 0.186417683959007, 0.186293005943298, 0.186168342828751, 0.186043635010719, 0.185919001698494, 0.185794323682785, 0.185669660568237, 0.185545042157173, 0.185420393943787, 0.185295715928078, 0.185171082615852, 0.185046479105949, 0.184921830892563, 0.184797197580338, 0.184672594070435, 0.18454797565937, 0.184423357248306, 0.184298753738403, 0.184170991182327, 0.184040352702141, 0.183909729123116, 0.183779120445251, 0.183648556470871, 0.18351799249649, 0.183387443423271, 0.183256939053535, 0.183126464486122, 0.182995960116386, 0.182865515351295, 0.182735115289688, 0.182604670524597, 0.18247427046299, 0.182343930006027, 0.182213559746742, 0.182083249092102, 0.181952953338623, 0.181822657585144, 0.181692376732826, 0.181562170386314, 0.18143193423748, 0.181301712989807, 0.18117156624794, 0.181041404604912, 0.180911272764206, 0.180781155824661, 0.180651038885117, 0.180520981550217, 0.180390939116478, 0.180260881781578, 0.180130884051323, 0.180000871419907, 0.179870903491974, 0.179740980267525, 0.179611057043076, 0.179481118917465, 0.179351255297661, 0.179221391677856, 0.179091542959213, 0.178961724042892, 0.178831934928894, 0.178702145814896, 0.178572371602058, 0.178442642092705, 0.178312942385674, 0.178183227777481, 0.178053572773933, 0.177923917770386, 0.177794277667999, 0.177664652466774, 0.177535086870193, 0.177405491471291, 0.177275940775871, 0.177146449685097, 0.177016913890839, 0.176887422800064, 0.176757961511612, 0.176628515124321, 0.176499128341675, 0.176369696855545, 0.176240310072899, 0.176110967993736, 0.175981625914574, 0.175852298736572, 0.175723001360893, 0.175593748688698, 0.175464481115341, 0.175335273146629, 0.175206050276756, 0.175076827406883, 0.174947679042816, 0.174818515777588, 0.174689382314682, 0.174560278654099, 0.174431204795837, 0.174302145838737, 0.174173101782799, 0.174044072628021, 0.173915058374405, 0.173786073923111, 0.173657119274139, 0.17352819442749, 0.17339925467968, 0.173270344734192, 0.173141494393349, 0.173012629151344, 0.172883808612823, 0.172754973173141, 0.172626197338104, 0.172497406601906, 0.172368675470352, 0.172239944338799, 0.172111213207245, 0.171982541680336, 0.171853885054588, 0.171725228428841, 0.171596601605415, 0.171468004584312, 0.171339422464371, 0.171210885047913, 0.17108228802681, 0.170953810214996, 0.170825317502022, 0.170696809887886, 0.170568361878395, 0.170439958572388, 0.170311510562897, 0.170183122158051, 0.170054748654366, 0.169926390051842, 0.169798046350479, 0.169669777154922, 0.169541478157043, 0.169413194060326, 0.169284969568253, 0.169156730175018, 0.169028535485268, 0.168900355696678, 0.168772175908089, 0.168644040822983, 0.168515905737877, 0.168387815356255, 0.168259739875793, 0.168131694197655, 0.168003633618355, 0.167875647544861, 0.167747646570206, 0.167619675397873, 0.167491719126701, 0.167363777756691, 0.167235866189003, 0.167107984423637, 0.166980117559433, 0.166852280497551, 0.166724443435669, 0.166596651077271, 0.166468873620033, 0.166341096162796, 0.16621333360672, 0.166085660457611, 0.165957927703857, 0.165830254554749, 0.165702611207962, 0.165574952960014, 0.165447354316711, 0.165319755673409, 0.165192171931267, 0.165064617991447, 0.164937093853951, 0.164809569716454, 0.164682105183601, 0.164554625749588, 0.164427176117897, 0.164299741387367, 0.164172351360321, 0.164044946432114, 0.163917601108551, 0.16379027068615, 0.163662925362587, 0.163535624742508, 0.163408353924751, 0.163281098008156, 0.163153856992722, 0.16302664577961, 0.162899434566498, 0.16277226805687, 0.162645116448402, 0.162517994642258, 0.162390857934952, 0.162263765931129, 0.162136718630791, 0.16200964152813, 0.161882624030113, 0.161755636334419, 0.161628648638725, 0.161501675844193, 0.161374732851982, 0.161247819662094, 0.161120891571045, 0.160994023084641, 0.160867169499397, 0.160740301012993, 0.160613492131233, 0.160486713051796, 0.160359933972359, 0.160233184695244, 0.16010645031929, 0.159979730844498, 0.159853041172028, 0.159726366400719, 0.159599736332893, 0.159473106265068, 0.159346476197243, 0.159219890832901, 0.159093335270882, 0.158966794610023, 0.158840268850327, 0.158713772892952, 0.158587276935577, 0.158460825681686, 0.158334404230118, 0.158207952976227, 0.158081561326981, 0.157955184578896, 0.157828837633133, 0.15770249068737, 0.157576188445091, 0.157449886202812, 0.157323628664017, 0.157197371125221, 0.157071143388748, 0.156944960355759, 0.156818747520447, 0.15669259428978, 0.156566441059113, 0.156440332531929, 0.156314209103584, 0.156188130378723, 0.156062081456184, 0.155936032533646, 0.155810013413429, 0.155684024095535, 0.155558049678802, 0.155432090163231, 0.15530614554882, 0.155180245637894, 0.155054330825806, 0.154928460717201, 0.154802620410919, 0.154676780104637, 0.154550984501839, 0.15442518889904, 0.154299423098564, 0.154173672199249, 0.154047951102257, 0.153922244906425, 0.153796553611755, 0.153670907020569, 0.153545245528221, 0.153419628739357, 0.153294041752815, 0.153168469667435, 0.153042912483215, 0.152917370200157, 0.15279184281826, 0.152666375041008, 0.152540877461433, 0.152415439486504, 0.152290016412735, 0.152164608240128, 0.15203920006752, 0.151913851499557, 0.151788502931595, 0.151663154363632, 0.151537865400314, 0.151412576436996, 0.151287317276001, 0.151162058115005, 0.151036858558655, 0.150911644101143, 0.150786459445953, 0.150661304593086, 0.150536194443703, 0.150411054491997, 0.150285974144936, 0.150160893797874, 0.150035858154297, 0.149910807609558, 0.149785801768303, 0.149660810828209, 0.149535834789276, 0.149410903453827, 0.149285987019539, 0.149161070585251, 0.149036169052124, 0.148911312222481, 0.148786470293999, 0.148661643266678, 0.148536846041679, 0.148412078619003, 0.148287296295166, 0.148162558674812, 0.148037850856781, 0.147913172841072, 0.147788479924202, 0.147663831710815, 0.14753919839859, 0.147414579987526, 0.147289991378784, 0.147165447473526, 0.147040888667107, 0.146916344761848, 0.146791845560074, 0.14666736125946, 0.146542876958847, 0.14641846716404, 0.14629402756691, 0.146169617772102, 0.146045237779617, 0.145920887589455, 0.145796567201614, 0.145672231912613, 0.145547926425934, 0.1454236805439, 0.145299389958382, 0.14517517387867, 0.145050972700119, 0.144926786422729, 0.144802585244179, 0.144678458571434, 0.144554331898689, 0.144430205225945, 0.144306123256683, 0.144182056188583, 0.144058018922806, 0.143933996558189, 0.143809989094734, 0.143686026334763, 0.143562033772469, 0.143438100814819, 0.143314212560654, 0.143190279603004, 0.14306640625, 0.142942577600479, 0.142818734049797, 0.142694920301437, 0.142571121454239, 0.142447352409363, 0.142323583364487, 0.142199888825417, 0.142076164484024, 0.141952499747276, 0.141828820109367, 0.141705140471458, 0.141581550240517, 0.141457930207253, 0.141334354877472, 0.141210809350014, 0.141087263822556, 0.140963718295097, 0.140840262174606, 0.140716776251793, 0.140593305230141, 0.140469878911972, 0.140346482396126, 0.140223056077957, 0.140099689364433, 0.139976352453232, 0.13985301554203, 0.139729708433151, 0.139606416225433, 0.139483138918877, 0.139359891414642, 0.139236658811569, 0.13911347091198, 0.138990268111229, 0.138867139816284, 0.138743996620178, 0.138620868325233, 0.138497769832611, 0.13837468624115, 0.138251647353172, 0.138128593564034, 0.138005569577217, 0.137882590293884, 0.137759625911713, 0.137636661529541, 0.137513726949692, 0.137390822172165, 0.137267932295799, 0.137145057320595, 0.137022241950035, 0.136899396777153, 0.136776566505432, 0.136653795838356, 0.136531054973602, 0.136408284306526, 0.136285603046417, 0.136162877082825, 0.136040180921555, 0.135917544364929, 0.135794922709465, 0.135672315955162, 0.135549709200859, 0.135427117347717, 0.135304570198059, 0.135182023048401, 0.135059535503387, 0.134937047958374, 0.134814575314522, 0.134692117571831, 0.134569689631462, 0.134447291493416, 0.134324908256531, 0.134202554821968, 0.134080201387405, 0.133957862854004, 0.133835598826408, 0.13371330499649, 0.133591055870056, 0.133468821644783, 0.13334658741951, 0.133224412798882, 0.133102208375931, 0.132980078458786, 0.13285793364048, 0.132735833525658, 0.132613733410835, 0.132491648197174, 0.132369637489319, 0.13224758207798, 0.132125586271286, 0.132003590464592, 0.131881609559059, 0.131759688258171, 0.131637766957283, 0.131515875458717, 0.131393998861313, 0.131272122263908, 0.131150290369987, 0.131028458476067, 0.13090668618679, 0.130784913897514, 0.130663141608238, 0.130541399121284, 0.130419686436653, 0.130298018455505, 0.130176335573196, 0.13005468249321, 0.129933059215546, 0.129811435937881, 0.129689857363701, 0.129568293690681, 0.129446759819984, 0.129325225949287, 0.129203721880913, 0.129082247614861, 0.128960773348808, 0.12883934378624, 0.128717929124832, 0.128596544265747, 0.12847512960434, 0.128353804349899, 0.128232479095459, 0.128111153841019, 0.12798984348774, 0.127868577837944, 0.12774732708931, 0.127626121044159, 0.127504914999008, 0.127383723855019, 0.12726254761219, 0.127141416072845, 0.127020284533501, 0.126899167895317, 0.126778110861778, 0.126657038927078, 0.126535996794701, 0.126414969563484, 0.126293987035751, 0.12617301940918, 0.126052036881447, 0.125931099057198, 0.125810205936432, 0.125689327716827, 0.125568434596062, 0.12544758617878, 0.12532676756382, 0.125205919146538, 0.125085160136223, 0.124964393675327, 0.124843649566174, 0.124722927808762, 0.12460221350193, 0.124481543898582, 0.124360866844654, 0.12424024939537, 0.124119609594345, 0.123999014496803, 0.123878419399261, 0.123757861554623, 0.123637348413467, 0.123516827821732, 0.123396337032318, 0.123275853693485, 0.123155392706394, 0.123034976422787, 0.12291457504034, 0.122794173657894, 0.122673809528351, 0.122553452849388, 0.12243315577507, 0.122312821447849, 0.122192554175854, 0.122072301805019, 0.121952049434185, 0.121831811964512, 0.121711626648903, 0.121591448783875, 0.121472112834454, 0.121353968977928, 0.121235847473145, 0.121117770671844, 0.120999805629253, 0.120881840586662, 0.120763950049877, 0.120646104216576, 0.120528310537338, 0.120410613715649, 0.120292887091637, 0.120175272226334, 0.120057739317417, 0.119940191507339, 0.119822725653648, 0.119705304503441, 0.119588002562523, 0.119470678269863, 0.11935343593359, 0.11923623085022, 0.119119077920914, 0.119001984596252, 0.11888499557972, 0.118767999112606, 0.118651084601879, 0.118534214794636, 0.118417397141457, 0.11830061674118, 0.118183940649033, 0.118067264556885, 0.117950648069382, 0.117834128439426, 0.117717646062374, 0.117601208388805, 0.11748480796814, 0.117368474602699, 0.117252208292484, 0.117135971784592, 0.117019824683666, 0.116903722286224, 0.116787634789944, 0.116671644151211, 0.116555705666542, 0.116439804434776, 0.116323962807655, 0.116208180785179, 0.116092413663864, 0.115976728498936, 0.115861110389233, 0.115745544433594, 0.11563004553318, 0.115514568984509, 0.11539913713932, 0.115283772349358, 0.115168482065201, 0.115053243935108, 0.114938035607338, 0.114822909235954, 0.114707805216312, 0.114592783153057, 0.114477805793285, 0.114362880587578, 0.114248000085354, 0.114133179187775, 0.114018402993679, 0.113903693854809, 0.113789066672325, 0.113674491643906, 0.113559909164906, 0.113445430994034, 0.113330967724323, 0.113216586410999, 0.113102272152901, 0.112987995147705, 0.112873755395412, 0.112759567797184, 0.112645469605923, 0.112531416118145, 0.112417377531528, 0.112303450703621, 0.112189538776875, 0.112075701355934, 0.111961908638477, 0.111848190426826, 0.111734479665756, 0.111620858311653, 0.111507281661034, 0.111393749713898, 0.111280284821987, 0.111166879534721, 0.111053518950939, 0.110940180718899, 0.110826939344406, 0.110713757574558, 0.110600605607033, 0.110487505793571, 0.110374487936497, 0.110261484980583, 0.110148586332798, 0.110035680234432, 0.109922878444195, 0.109810128808022, 0.109697394073009, 0.109584718942642, 0.109472133219242, 0.109359584748745, 0.109247088432312, 0.109134666621685, 0.109022282063961, 0.108909904956818, 0.108797639608383, 0.108685426414013, 0.108573235571384, 0.108461081981659, 0.108349047601223, 0.108237072825432, 0.108125075697899, 0.108013205230236, 0.107901342213154, 0.107789523899555, 0.107677802443504, 0.107566110789776, 0.107454463839531, 0.107342921197414, 0.107231363654137, 0.107119917869568, 0.107008501887321, 0.106897130608559, 0.106785826385021, 0.106674559414387, 0.106563352048397, 0.106452219188213, 0.106341101229191, 0.106230095028877, 0.106119103729725, 0.106008157134056, 0.105897262692451, 0.105786450207233, 0.10567569732666, 0.105564974248409, 0.105454310774803, 0.105343699455261, 0.105233170092106, 0.105122655630112, 0.105012208223343, 0.104901850223541, 0.104791484773159, 0.104681193828583, 0.104570955038071, 0.104460820555687, 0.104350678622723, 0.104240596294403, 0.104130610823631, 0.104020617902279, 0.103910706937313, 0.103800877928734, 0.103691071271896, 0.103581331670284, 0.103471644222736, 0.103362016379833, 0.103252403438091, 0.103142894804478, 0.103033445775509, 0.102924004197121, 0.102814637124538, 0.102705329656601, 0.102596081793308, 0.102486863732338, 0.102377712726593, 0.102268606424332, 0.102159537374973, 0.102050580084324, 0.101941667497158, 0.101832799613476, 0.101723961532116, 0.10161516815424, 0.101506449282169, 0.101397790014744, 0.101289182901382, 0.101180642843246, 0.101072117686272, 0.100963674485683, 0.10085529088974, 0.1007469445467, 0.100638657808304, 0.100530430674553, 0.100422203540802, 0.100314117968082, 0.100206024944782, 0.10009802877903, 0.0999900847673416, 0.0998821705579758, 0.0997742787003517, 0.0996664986014366, 0.0995587557554245, 0.0994510725140572, 0.0993434265255928, 0.0992358475923538, 0.099128283560276, 0.0990208312869072, 0.0989134162664413, 0.0988060384988785, 0.0986987203359604, 0.0985914766788483, 0.0984842330217361, 0.0983771160244942, 0.0982700288295746, 0.0981629565358162, 0.0980559438467026, 0.0979490205645561, 0.0978421494364738, 0.0977353230118752, 0.097628578543663, 0.0975218266248703, 0.0974151641130447, 0.0973085388541222, 0.0972020030021667, 0.0970954895019531, 0.0969890356063843, 0.096882626414299, 0.0967762768268585, 0.096670001745224, 0.0965637564659119, 0.0964575931429863, 0.0963514372706413, 0.0962453708052635, 0.0961393564939499, 0.096033401787281, 0.0959274843335152, 0.0958216413855553, 0.0957158207893372, 0.0956100821495056, 0.0955043658614159, 0.0953987315297127, 0.0952931717038155, 0.0951876267790794, 0.0950821414589882, 0.0949767157435417, 0.09487134963274, 0.0947660207748413, 0.0946607738733292, 0.09455556422472, 0.0944503769278526, 0.0943453088402748, 0.0942402780056, 0.0941352620720863, 0.0940303206443787, 0.093925416469574, 0.0938206017017365, 0.0937158092856407, 0.0936111137270927, 0.093506433069706, 0.0934017971158028, 0.0932972431182861, 0.0931927412748337, 0.093088261783123, 0.0929839015007019, 0.0928795412182808, 0.0927752330899239, 0.0926710069179535, 0.0925668179988861, 0.0924627110362053, 0.0923586487770081, 0.092254601418972, 0.0921506211161613, 0.092046707868576, 0.0919428542256355, 0.0918390452861786, 0.0917353257536888, 0.091631606221199, 0.091527946293354, 0.0914243683218956, 0.0913208276033401, 0.0912173390388489, 0.091113917529583, 0.0910105556249619, 0.0909072086215019, 0.0908039510250092, 0.0907007679343224, 0.090597577393055, 0.0904944986104965, 0.0903914272785187, 0.0902884230017662, 0.0901854932308197, 0.0900826007127762, 0.0899797528982162, 0.0898769870400429, 0.0897742360830307, 0.0896716117858887, 0.0895689874887466, 0.089466392993927, 0.0893638879060745, 0.0892614275217056, 0.0891590192914009, 0.0890566930174828, 0.0889543890953064, 0.0888521373271942, 0.0887499675154686, 0.088647834956646, 0.0885457545518875, 0.0884437263011932, 0.0883417651057243, 0.0882398411631584, 0.0881379842758179, 0.0880361720919609, 0.0879344046115875, 0.0878326967358589, 0.0877310708165169, 0.0876294821500778, 0.0875279307365417, 0.0874264389276505, 0.0873250216245651, 0.087223656475544, 0.0871223360300064, 0.08702103048563, 0.086919829249382, 0.08681870251894, 0.0867175683379173, 0.0866165012121201, 0.086515486240387, 0.086414560675621, 0.0863136723637581, 0.0862128287553787, 0.0861120522022247, 0.0860113129019737, 0.0859106406569481, 0.0858100354671478, 0.0857094526290894, 0.0856089442968369, 0.0855084955692291, 0.0854080840945244, 0.0853076949715614, 0.0852074325084686, 0.0851071923971176, 0.0850069969892502, 0.0849068909883499, 0.084806777536869, 0.0847067385911942, 0.0846067741513252, 0.0845068544149399, 0.0844070315361023, 0.0843071863055229, 0.0842074006795883, 0.0841077193617821, 0.084008052945137, 0.0839084759354591, 0.0838089361786842, 0.0837094485759735, 0.0836100056767464, 0.083510622382164, 0.0834112912416458, 0.083312027156353, 0.083212822675705, 0.0831136330962181, 0.083014540374279, 0.0829154700040817, 0.082816481590271, 0.0827175453305244, 0.0826186463236809, 0.0825197845697403, 0.0824209973216057, 0.0823222622275352, 0.0822236090898514, 0.0821249634027481, 0.082026407122612, 0.0819278806447983, 0.0818294286727905, 0.0817310437560081, 0.0816326662898064, 0.08153435587883, 0.0814361274242401, 0.0813379138708115, 0.0812397599220276, 0.0811417028307915, 0.0810436606407166, 0.0809457004070282, 0.0808477774262428, 0.0807499215006828, 0.0806520655751228, 0.0805543139576912, 0.0804566144943237, 0.0803589671850204, 0.0802613496780396, 0.0801638290286064, 0.0800663530826569, 0.0799688845872879, 0.0798715204000473, 0.0797741860151291, 0.0796768963336945, 0.079579696059227, 0.0794825479388237, 0.0793853998184204, 0.0792883336544037, 0.0791913345456123, 0.0790944024920464, 0.078997515141964, 0.0789006724953651, 0.0788038596510887, 0.0787071362137794, 0.0786104425787926, 0.0785138309001923, 0.0784172490239143, 0.0783207342028618, 0.0782242491841316, 0.0781278312206268, 0.0780315026640892, 0.0779351964592934, 0.0778389498591423, 0.0777427479624748, 0.0776465907692909, 0.0775504931807518, 0.0774545148015022, 0.0773584917187691, 0.0772625878453255, 0.0771667063236237, 0.0770708918571472, 0.0769751146435738, 0.0768794193863869, 0.0767837911844254, 0.0766881704330444, 0.0765926018357277, 0.0764971226453781, 0.0764016881585121, 0.0763062983751297, 0.0762109681963921, 0.076115682721138, 0.0760204419493675, 0.0759253054857254, 0.0758301913738251, 0.0757350921630859, 0.0756401270627975, 0.0755451545119286, 0.0754502564668655, 0.0753553956747055, 0.0752606242895126, 0.0751658901572227, 0.0750712230801582, 0.0749765634536743, 0.0748819932341576, 0.0747874900698662, 0.0746930167078972, 0.0745985954999924, 0.0745042115449905, 0.0744099020957947, 0.0743156522512436, 0.0742214620113373, 0.0741273164749146, 0.0740332528948784, 0.073939174413681, 0.0738452225923538, 0.0737512782216072, 0.0736574232578278, 0.0735636055469513, 0.0734698548913002, 0.0733760893344879, 0.073282465338707, 0.0731888562440872, 0.0730952993035316, 0.0730017945170403, 0.0729083642363548, 0.0728149637579918, 0.0727216303348541, 0.0726283863186836, 0.0725351348519325, 0.0724419355392456, 0.0723488330841064, 0.0722557902336121, 0.0721627622842789, 0.0720698162913322, 0.0719769150018692, 0.0718840360641479, 0.0717912688851357, 0.0716985240578651, 0.07160584628582, 0.0715131983160973, 0.0714206248521805, 0.0713280811905861, 0.0712356120347977, 0.071143202483654, 0.071050837635994, 0.0709585249423981, 0.070866271853447, 0.0707740560173988, 0.0706819444894791, 0.0705898553133011, 0.0704978257417679, 0.0704058036208153, 0.070313885807991, 0.0702220052480698, 0.0701301917433739, 0.0700384452939034, 0.0699466913938522, 0.0698550343513489, 0.0697634294629097, 0.0696718692779541, 0.0695803835988045, 0.0694889351725578, 0.069397546350956, 0.0693061947822571, 0.0692149177193642, 0.0691264197230339, 0.0690404251217842, 0.0689544752240181, 0.0688686072826385, 0.0687827542424202, 0.0686970129609108, 0.0686113014817238, 0.068525642156601, 0.0684400722384453, 0.0683545395731926, 0.0682690814137459, 0.0681836381554604, 0.0680982768535614, 0.0680130124092102, 0.0679277405142784, 0.0678425505757332, 0.0677574425935745, 0.0676724091172218, 0.0675873756408691, 0.0675024464726448, 0.0674175545573235, 0.0673327073454857, 0.0672479495406151, 0.0671632289886475, 0.0670785829424858, 0.0669940039515495, 0.0669094398617744, 0.0668249800801277, 0.066740557551384, 0.0666562095284462, 0.066571868956089, 0.0664876624941826, 0.0664034560322762, 0.0663193315267563, 0.0662352293729782, 0.0661512613296509, 0.066067285835743, 0.065983384847641, 0.0658995807170868, 0.0658157765865326, 0.0657320991158485, 0.0656484588980675, 0.0655648410320282, 0.0654812753200531, 0.0653977915644646, 0.0653143748641014, 0.06523098051548, 0.0651477128267288, 0.0650644600391388, 0.0649812370538712, 0.0648981183767319, 0.0648150593042374, 0.0647320076823235, 0.0646490827202797, 0.0645661950111389, 0.0644833296537399, 0.0644005462527275, 0.0643178299069405, 0.064235158264637, 0.0641525313258171, 0.0640700086951256, 0.0639875531196594, 0.0639050900936127, 0.0638227388262749, 0.0637404024600983, 0.0636581405997276, 0.0635759606957436, 0.0634938180446625, 0.0634117349982262, 0.0633297488093376, 0.0632477626204491, 0.0631658583879471, 0.0630840137600899, 0.0630022138357162, 0.0629204884171486, 0.0628388077020645, 0.0627572238445282, 0.0626756623387337, 0.0625941380858421, 0.0625127032399178, 0.0624313056468964, 0.0623500235378742, 0.0622687786817551, 0.0621875561773777, 0.0621063932776451, 0.062025360763073, 0.0619442909955978, 0.0618633218109608, 0.0617824383080006, 0.0617015957832336, 0.0616207830607891, 0.0615400448441505, 0.0614593774080276, 0.0613787323236465, 0.0612981878221035, 0.061217688024044, 0.0611372701823711, 0.0610568597912788, 0.0609765537083149, 0.0608962848782539, 0.0608160682022572, 0.0607359781861305, 0.0606558583676815, 0.0605758056044579, 0.0604958385229111, 0.0604159161448479, 0.0603360794484615, 0.0602562837302685, 0.0601765289902687, 0.0600968413054943, 0.060017216950655, 0.0599376522004604, 0.0598581358790398, 0.0597787201404572, 0.0596993342041969, 0.0596199817955494, 0.059540718793869, 0.0594614967703819, 0.0593823380768299, 0.0593032501637936, 0.0592242181301117, 0.0591452345252037, 0.0590663366019726, 0.0589874759316444, 0.0589086636900902, 0.0588298887014389, 0.0587512217462063, 0.0586725994944572, 0.0585940405726433, 0.0585154965519905, 0.0584370456635952, 0.0583586767315865, 0.0582802891731262, 0.0582020878791809, 0.0581238269805908, 0.0580456517636776, 0.0579675808548927, 0.05788953602314, 0.057811550796032, 0.0577336512506008, 0.0576557479798794, 0.0575779378414154, 0.0575002282857895, 0.0574225001037121, 0.057344876229763, 0.0572672970592976, 0.0571897625923157, 0.0571123287081718, 0.0570349171757698, 0.0569575726985931, 0.056880310177803, 0.056803073734045, 0.0567259378731251, 0.0566488094627857, 0.0565717220306396, 0.0564947761595249, 0.0564178377389908, 0.0563409402966499, 0.0562641285359859, 0.0561873987317085, 0.0561106763780117, 0.0560340732336044, 0.0559574700891972, 0.0558809153735638, 0.0558044649660587, 0.0557280778884888, 0.0556517131626606, 0.0555754601955414, 0.0554992184042931, 0.0554230660200119, 0.0553469322621822, 0.0552708879113197, 0.0551948882639408, 0.0551189258694649, 0.0550430528819561, 0.0549672767519951, 0.0548914931714535, 0.0548157878220081, 0.0547401458024979, 0.0546645447611809, 0.0545890331268311, 0.0545135848224163, 0.0544381178915501, 0.0543627962470055, 0.0542875155806541, 0.0542122572660446, 0.0541371069848537, 0.0540619753301144, 0.0539869107306004, 0.0539119094610214, 0.0538369938731194, 0.0537620559334755, 0.0536872670054436, 0.0536125041544437, 0.0535377934575081, 0.0534631349146366, 0.053388562053442, 0.0533140078186989, 0.0532395578920841, 0.0531651340425014, 0.0530907921493053, 0.053016472607851, 0.0529422350227833, 0.0528680421411991, 0.0527939349412918, 0.0527198761701584, 0.0526458732783794, 0.0525719188153744, 0.0524980016052723, 0.0524241961538792, 0.0523504242300987, 0.0522766821086407, 0.0522030666470528, 0.0521294698119164, 0.0520558953285217, 0.0519824475049973, 0.0519090034067631, 0.0518356449902058, 0.0517623461782932, 0.0516891144216061, 0.0516159236431122, 0.0515427924692631, 0.0514697097241879, 0.0513967089354992, 0.0513237789273262, 0.0512508414685726, 0.051178015768528, 0.0511052496731281, 0.0510325320065022, 0.050959873944521, 0.050887256860733, 0.050814725458622, 0.0507422536611557, 0.0506698153913021, 0.0505974516272545, 0.050525140017271, 0.0504528619349003, 0.0503806732594967, 0.0503085665404797, 0.0502364672720432, 0.0501644685864449, 0.0500924922525883, 0.0500205978751183, 0.0499487556517124, 0.0498769916594028, 0.0498052313923836, 0.0497335679829121, 0.0496619567275047, 0.0495904088020325, 0.0495189428329468, 0.0494474992156029, 0.0493761636316776, 0.0493048280477524, 0.0492335967719555, 0.0491623692214489, 0.0490912199020386, 0.0490201376378536, 0.048949122428894, 0.0488781668245792, 0.0488072596490383, 0.0487364120781422, 0.0486656092107296, 0.0485948920249939, 0.0485242530703545, 0.0484535843133926, 0.0483830310404301, 0.0483125448226929, 0.0482421070337296, 0.048171728849411, 0.0481013916432858, 0.0480311401188374, 0.0479609556496143, 0.0478908084332943, 0.0478207133710384, 0.0477506741881371, 0.0476807244122028, 0.0476108081638813, 0.0475409664213657, 0.0474711656570435, 0.0474014058709145, 0.0473317690193653, 0.047262117266655, 0.0471925474703312, 0.0471230670809746, 0.047053586691618, 0.046984251588583, 0.046914916485548, 0.0468456484377384, 0.0467764623463154, 0.0467072986066341, 0.046638198196888, 0.046569187194109, 0.0465001948177814, 0.0464312583208084, 0.0463624186813831, 0.0462935976684093, 0.0462248809635639, 0.04615618288517, 0.0460875555872917, 0.0460189841687679, 0.0459505096077919, 0.0458820648491383, 0.0458136685192585, 0.0457452908158302, 0.0456770472228527, 0.0456088446080685, 0.0455406829714775, 0.0454725623130798, 0.0454045720398426, 0.0453365594148636, 0.0452686510980129, 0.0452007912099361, 0.0451329462230206, 0.0450652129948139, 0.0449975356459618, 0.0449299290776253, 0.0448623448610306, 0.0447948426008224, 0.0447273626923561, 0.0446599684655666, 0.044592659920454, 0.0445253476500511, 0.0444581471383572, 0.0443910025060177, 0.0443238690495491, 0.0442568510770798, 0.0441898852586746, 0.044122938066721, 0.0440560728311539, 0.0439892522990704, 0.0439225248992443, 0.0438558273017406, 0.0437891818583012, 0.0437226146459579, 0.0436560995876789, 0.0435896366834641, 0.0435232222080231, 0.0434568710625172, 0.0433906093239784, 0.0433243624866009, 0.0432581827044487, 0.0431920625269413, 0.0431260094046593, 0.0430600270628929, 0.0429941192269325, 0.042928259819746, 0.0428624153137207, 0.0427966639399529, 0.0427309758961201, 0.0426653064787388, 0.0425997190177441, 0.0425342246890068, 0.0424687452614307, 0.0424033589661121, 0.042338028550148, 0.0422727018594742, 0.0422074981033802, 0.0421422980725765, 0.0420771837234497, 0.0420121550559998, 0.041947141289711, 0.0418822206556797, 0.0418173223733902, 0.041752502322197, 0.0416877306997776, 0.0416230373084545, 0.0415583737194538, 0.0414938107132912, 0.0414292700588703, 0.0413647927343845, 0.0413004457950592, 0.0412360541522503, 0.0411717519164085, 0.0411075279116631, 0.0410433523356915, 0.0409791991114616, 0.0409151278436184, 0.0408511608839035, 0.0407871976494789, 0.0407233163714409, 0.0406595021486282, 0.0405957289040089, 0.0405320189893246, 0.0404683761298656, 0.0404047742486, 0.0403412356972694, 0.0402777381241322, 0.0402143709361553, 0.0401510260999203, 0.0400876589119434, 0.04002445936203, 0.0399612821638584, 0.0398981273174286, 0.0398351028561592, 0.0397720970213413, 0.0397091098129749, 0.0396462343633175, 0.0395834185183048, 0.0395206063985825, 0.0394579395651817, 0.0393952541053295, 0.0393326543271542, 0.0392701178789139, 0.0392076671123505, 0.039145216345787, 0.039082869887352, 0.0390205681324005, 0.0389583073556423, 0.0388961099088192, 0.0388339571654797, 0.038771890103817, 0.0387099049985409, 0.0386479422450066, 0.0385860465466976, 0.0385242141783237, 0.0384624041616917, 0.0384006947278976, 0.0383390560746193, 0.0382774360477924, 0.0382158756256104, 0.0381544046103954, 0.038092952221632, 0.0380316115915775, 0.0379702895879745, 0.0379090085625648, 0.0378478541970253, 0.0377867482602596, 0.0377256385982037, 0.0376646146178246, 0.037603672593832, 0.0375427566468716, 0.037481926381588, 0.0374211370944977, 0.0373604074120522, 0.0372997485101223, 0.0372391492128372, 0.0371785722672939, 0.037118062376976, 0.0370576754212379, 0.0369972698390484, 0.0369369685649872, 0.0368766896426678, 0.0368164964020252, 0.0367563478648663, 0.0366962626576424, 0.0366362631320953, 0.0365762785077095, 0.0365163870155811, 0.0364565327763557, 0.0363967455923557, 0.036336999386549, 0.0362773388624191, 0.0362177640199661, 0.0361581668257713, 0.0360986590385437, 0.0360392704606056, 0.0359798446297646, 0.0359205268323421, 0.0358612909913063, 0.0358020588755608, 0.0357429087162018, 0.0356838442385197, 0.0356247797608376, 0.0355658233165741, 0.0355069302022457, 0.0354480370879173, 0.0353892706334591, 0.0353305265307426, 0.0352718457579613, 0.0352132543921471, 0.0351547040045261, 0.0350961461663246, 0.0350377671420574, 0.0349793434143066, 0.0349210016429424, 0.0348627679049969, 0.0348045788705349, 0.0347463674843311, 0.0346883051097393, 0.0346302874386311, 0.034572284668684, 0.0345143936574459, 0.0344564616680145, 0.0343986973166466, 0.0343409776687622, 0.0342832542955875, 0.0342256613075733, 0.0341680869460106, 0.0341105572879314, 0.0340531133115292, 0.0339957550168037, 0.0339383520185947, 0.0338811241090298, 0.0338239334523678, 0.0337667241692543, 0.0337096601724625, 0.0336526222527027, 0.0335956215858459, 0.0335387140512466, 0.0334818437695503, 0.033423475921154, 0.0333635583519936, 0.0333037301898003, 0.0332439392805099, 0.033184215426445, 0.0331245101988316, 0.0330649167299271, 0.0330053195357323, 0.0329457856714725, 0.0328863598406315, 0.0328269340097904, 0.0327675491571426, 0.0327082760632038, 0.0326490215957165, 0.0325898267328739, 0.0325307212769985, 0.0324716158211231, 0.0324126146733761, 0.032353613525629, 0.0322947204113007, 0.0322358720004559, 0.0321770645678043, 0.0321183167397976, 0.0320596396923065, 0.0320009998977184, 0.0319424048066139, 0.0318838730454445, 0.0318254083395004, 0.0317669808864594, 0.0317086018621922, 0.0316503047943115, 0.0315920487046242, 0.0315338596701622, 0.0314757153391838, 0.0314176306128502, 0.0313595458865166, 0.0313015691936016, 0.0312436744570732, 0.0311858057975769, 0.0311280004680157, 0.0310702566057444, 0.0310125127434731, 0.030954897403717, 0.0308973044157028, 0.0308397319167852, 0.0307822450995445, 0.0307248216122389, 0.0306674633175135, 0.0306101031601429, 0.0305528920143843, 0.0304956417530775, 0.0304384957998991, 0.030381390824914, 0.0303243510425091, 0.0302673950791359, 0.0302104018628597, 0.030153576284647, 0.0300967283546925, 0.0300399623811245, 0.0299832001328468, 0.0299265868961811, 0.0298699531704187, 0.0298134032636881, 0.0297569390386343, 0.0297004766762257, 0.0296440962702036, 0.0295877605676651, 0.0295315086841583, 0.02947529964149, 0.0294191110879183, 0.029362965375185, 0.0293069519102573, 0.0292509347200394, 0.0291949808597565, 0.0291390921920538, 0.0290832445025444, 0.0290274638682604, 0.0289717670530081, 0.0289160702377558, 0.0288604348897934, 0.0288048889487982, 0.0287493821233511, 0.0286939386278391, 0.0286385640501976, 0.0285832062363625, 0.0285279136151075, 0.0284727066755295, 0.0284174773842096, 0.0283623971045017, 0.0283072981983423, 0.0282523259520531, 0.028197331354022, 0.0281424652785063, 0.0280875787138939, 0.0280328188091516, 0.0279780589044094, 0.0279233828186989, 0.0278687514364719, 0.0278141852468252, 0.0277596563100815, 0.0277051776647568, 0.0276508219540119, 0.0275964457541704, 0.0275421533733606, 0.0274878852069378, 0.0274337418377399, 0.0273795984685421, 0.0273254811763763, 0.0272714458405972, 0.0272175148129463, 0.0271635446697474, 0.0271097663789988, 0.027055898681283, 0.0270021855831146, 0.0269484911113977, 0.0268948804587126, 0.0268412493169308, 0.0267877466976643, 0.0267342682927847, 0.0266808718442917, 0.0266275182366371, 0.0265741851180792, 0.0265209600329399, 0.0264677125960588, 0.0264145731925964, 0.0263614971190691, 0.0263084825128317, 0.0262554492801428, 0.0262025445699692, 0.0261496584862471, 0.0260968375951052, 0.0260441023856401, 0.0259913876652718, 0.0259387381374836, 0.0258861742913723, 0.0258336495608091, 0.0257811490446329, 0.0257287137210369, 0.0256763398647308, 0.0256240516901016, 0.0255717411637306, 0.0255195386707783, 0.0254673585295677, 0.0254153031855822, 0.0253632292151451, 0.0253112576901913, 0.025259293615818, 0.0252074301242828, 0.0251556113362312, 0.0251038540154696, 0.02505212277174, 0.0250004511326551, 0.0249488670378923, 0.0248973034322262, 0.0248458236455917, 0.0247943233698606, 0.0247430168092251, 0.0246916227042675, 0.0246404018253088, 0.0245891343802214, 0.0245380196720362, 0.0244868602603674, 0.0244358088821173, 0.0243848189711571, 0.0243338532745838, 0.0242829713970423, 0.0242321528494358, 0.0241813790053129, 0.0241306647658348, 0.0240799766033888, 0.0240293703973293, 0.0239788070321083, 0.0239282697439194, 0.0238778553903103, 0.0238274410367012, 0.0237770918756723, 0.0237267855554819, 0.0236765872687101, 0.0236263647675514, 0.0235762950032949, 0.0235262010246515, 0.023476192727685, 0.0234262254089117, 0.0233763232827187, 0.0233264863491058, 0.0232766922563314, 0.0232269838452339, 0.0231772717088461, 0.0231276676058769, 0.0230780672281981, 0.0230285692960024, 0.0229790918529034, 0.0229297038167715, 0.0228803548961878, 0.0228310488164425, 0.0227817893028259, 0.0227326322346926, 0.0226834546774626, 0.0226343851536512, 0.022585378959775, 0.022536413744092, 0.0224874690175056, 0.0224386546760798, 0.0223898403346539, 0.0223410688340664, 0.0222924016416073, 0.0222437363117933, 0.0221951995044947, 0.0221466179937124, 0.0220981650054455, 0.0220497343689203, 0.0220013875514269, 0.0219530630856752, 0.0219048224389553, 0.0218565836548805, 0.0218084696680307, 0.0217603612691164, 0.0217123739421368, 0.0216643717139959, 0.0216164477169514, 0.0215685926377773, 0.0215207803994417, 0.0214730314910412, 0.0214252807199955, 0.0213776808232069, 0.021330077201128, 0.0212825443595648, 0.0212350487709045, 0.0211876183748245, 0.0211402121931314, 0.0210929289460182, 0.0210456717759371, 0.0209984518587589, 0.0209512785077095, 0.0209041908383369, 0.0208571217954159, 0.0208101626485586, 0.0207631997764111, 0.0207163654267788, 0.0206695348024368, 0.0206227190792561, 0.0205760579556227, 0.0205293744802475, 0.020482774823904, 0.0204361975193024, 0.0203897468745708, 0.020343255251646, 0.0202968884259462, 0.0202505681663752, 0.020204309374094, 0.0201580729335546, 0.0201119016855955, 0.0200657919049263, 0.0200197249650955, 0.0199737008661032, 0.0199277829378843, 0.0198818668723106, 0.0198360551148653, 0.0197902880609035, 0.0197445210069418, 0.0196988806128502, 0.0196532402187586, 0.0196077283471823, 0.0195621717721224, 0.0195167660713196, 0.0194713175296783, 0.0194260198622942, 0.0193807184696198, 0.0193354841321707, 0.0192902907729149, 0.0192452054470778, 0.0192000977694988, 0.0191551391035318, 0.0191101171076298, 0.0190652646124363, 0.0190203711390495, 0.0189756043255329, 0.0189308803528547, 0.0188861787319183, 0.0188415814191103, 0.0187969636172056, 0.0187525171786547, 0.0187080055475235, 0.018663601949811, 0.0186192393302917, 0.0185749623924494, 0.0185307282954454, 0.0184865389019251, 0.0184423681348562, 0.0183983258903027, 0.0183542836457491, 0.0183103065937757, 0.0182663928717375, 0.0182225424796343, 0.0181787759065628, 0.0181350111961365, 0.0180913098156452, 0.018047671765089, 0.0180041193962097, 0.0179605465382338, 0.0179171003401279, 0.0178736560046673, 0.0178303178399801, 0.0177870001643896, 0.0177437886595726, 0.0177005119621754, 0.0176573861390352, 0.0176143031567335, 0.0175712835043669, 0.0175283085554838, 0.0174853522330523, 0.0174425020813942, 0.0173996966332197, 0.0173569545149803, 0.0173142105340958, 0.0172715969383717, 0.0172289609909058, 0.0171864740550518, 0.0171439237892628, 0.0171015430241823, 0.0170591417700052, 0.0170168485492468, 0.0169745516031981, 0.0169323850423098, 0.0168901979923248, 0.0168480928987265, 0.0168060325086117, 0.0167640578001738, 0.0167221669107676, 0.0166802778840065, 0.0166384521871805, 0.016596669331193, 0.0165549498051405, 0.0165132917463779, 0.0164717212319374, 0.0164301302284002, 0.0163886453956366, 0.016347223892808, 0.016305822879076, 0.0162644442170858, 0.0162231922149658, 0.0161819867789745, 0.0161408185958862, 0.0160997174680233, 0.016058636829257, 0.016017684713006, 0.0159767102450132, 0.0159358438104391, 0.0158949755132198, 0.0158542152494192, 0.0158134549856186, 0.0157728213816881, 0.0157321877777576, 0.0156916193664074, 0.0156511347740889, 0.0156106734648347, 0.0155702736228704, 0.0155299603939056, 0.0154896480962634, 0.0154494196176529, 0.0154092125594616, 0.0153691554442048, 0.0153290973976254, 0.0152890598401427, 0.0152490884065628, 0.0152091793715954, 0.0151693355292082, 0.0151295326650143, 0.015089837834239, 0.0150501001626253, 0.0150104900822043, 0.0149709219112992, 0.0149314403533936, 0.0148919159546494, 0.0148525387048721, 0.01481316331774, 0.0147738931700587, 0.0147346239537001, 0.0146954618394375, 0.0146563425660133, 0.0146172642707825, 0.01457822881639, 0.014539279974997, 0.0145003721117973, 0.0144614651799202, 0.0144227286800742, 0.0143839493393898, 0.0143452333286405, 0.0143066039308906, 0.0142680387943983, 0.0142294922843575, 0.0141910333186388, 0.0141525948420167, 0.0141142196953297, 0.0140759097412229, 0.0140376836061478, 0.0139995012432337, 0.0139613607898355, 0.0139232641085982, 0.0138852093368769, 0.0138472616672516, 0.0138093130663037, 0.0137714929878712, 0.0137336077168584, 0.0136958938091993, 0.0136581584811211, 0.0136205516755581, 0.0135829010978341, 0.0135454218834639, 0.0135078998282552, 0.0134704848751426, 0.0134330904111266, 0.0133957816287875, 0.0133585361763835, 0.0133213121443987, 0.0132841942831874, 0.013247056864202, 0.0132100246846676, 0.0131730129942298, 0.0131360869854689, 0.0130992056801915, 0.0130623858422041, 0.0130256097763777, 0.0129888970404863, 0.012952228076756, 0.0129156429320574, 0.0128790372982621, 0.0128425806760788, 0.0128061026334763, 0.0127697726711631, 0.0127334436401725, 0.0126971788704395, 0.012660956941545, 0.0126247769221663, 0.0125886825844646, 0.0125526087358594, 0.0125166429206729, 0.0124806556850672, 0.0124447727575898, 0.0124089559540153, 0.0123731596395373, 0.0123374275863171, 0.0123017579317093, 0.0122661329805851, 0.0122305918484926, 0.0121950730681419, 0.0121596185490489, 0.0121242683380842, 0.0120888985693455, 0.0120536349713802, 0.012018371373415, 0.0119832139462233, 0.0119480788707733, 0.0119130713865161, 0.0118780005723238, 0.0118430340662599, 0.0118081122636795, 0.0117733171209693, 0.0117385005578399, 0.0117037910968065, 0.011669060215354, 0.0116344569250941, 0.0115998545661569, 0.0115653788670897, 0.0115308836102486, 0.0114965345710516, 0.0114621659740806, 0.0114278616383672, 0.0113936215639114, 0.0113594010472298, 0.0113253314048052, 0.0112912189215422, 0.0112571911886334, 0.0112232053652406, 0.011189348064363, 0.011155447922647, 0.0111216763034463, 0.0110878823325038, 0.0110542168840766, 0.011020552366972, 0.0109870145097375, 0.0109534561634064, 0.0109200021252036, 0.0108865723013878, 0.0108532048761845, 0.0108199222013354, 0.0107866618782282, 0.0107534443959594, 0.0107202688232064, 0.0106872208416462, 0.0106541933491826, 0.0106212114915252, 0.0105882268399, 0.0105554135516286, 0.0105226011946797, 0.0104898307472467, 0.0104571441188455, 0.0104244602844119, 0.0103918807581067, 0.0103593654930592, 0.0103290192782879, 0.010300999507308, 0.0102730765938759, 0.0102451210841537, 0.0102173052728176, 0.0101894671097398, 0.0101617351174355, 0.0101340040564537, 0.0101063689216971, 0.0100787011906505, 0.0100511508062482, 0.010023589245975, 0.00999612454324961, 0.0099686598405242, 0.00994130037724972, 0.00991393160074949, 0.00988663733005524, 0.00985941756516695, 0.00983219686895609, 0.00980504136532545, 0.00977790635079145, 0.00975086726248264, 0.00972382817417383, 0.00969683192670345, 0.00966991018503904, 0.00964304246008396, 0.0096161738038063, 0.00958941131830215, 0.0095626600086689, 0.00953595153987408, 0.00950927473604679, 0.00948268361389637, 0.00945611298084259, 0.00942963920533657, 0.00940312165766954, 0.00937675405293703, 0.00935036595910788, 0.009324018843472, 0.009297757409513, 0.00927150715142488, 0.00924530997872353, 0.00921916589140892, 0.00919309630990028, 0.00916699506342411, 0.00914102140814066, 0.00911504775285721, 0.00908913835883141, 0.00906326062977314, 0.00903745740652084, 0.00901165418326855, 0.00898594688624144, 0.00896023958921432, 0.00893462914973497, 0.00890901684761047, 0.00888348091393709, 0.00885802879929543, 0.0088325347751379, 0.0088071571663022, 0.00878176931291819, 0.00875648949295282, 0.0087311863899231, 0.00870600063353777, 0.00868077389895916, 0.00865568406879902, 0.00863057374954224, 0.00860557053238153, 0.008580575697124, 0.00855566840618849, 0.00853071734309196, 0.00850588362663984, 0.00848106108605862, 0.00845631211996078, 0.00843163765966892, 0.00840695388615131, 0.00838234461843967, 0.00835775583982468, 0.00833325181156397, 0.00830872729420662, 0.00828434061259031, 0.00825992319732904, 0.00823558028787374, 0.00821128953248262, 0.00818705186247826, 0.00816282629966736, 0.00813868548721075, 0.00811455398797989, 0.00809053052216768, 0.00806647446006536, 0.00804250407963991, 0.0080185541883111, 0.00799470115453005, 0.00797089003026485, 0.00794709008187056, 0.00792336370795965, 0.00789964944124222, 0.00787599850445986, 0.00785237923264503, 0.0078288558870554, 0.00780532229691744, 0.00778187299147248, 0.00775846699252725, 0.00773507170379162, 0.00771172950044274, 0.00768848368898034, 0.00766522623598576, 0.00764206517487764, 0.00761890457943082, 0.0075958389788866, 0.00757279573008418, 0.00754977343603969, 0.00752684706822038, 0.00750388810411096, 0.00748107815161347, 0.00745822582393885, 0.00743549130856991, 0.00741271395236254, 0.00739008607342839, 0.00736741488799453, 0.00734486104920506, 0.00732229650020599, 0.0072998283430934, 0.00727733876556158, 0.00725495489314198, 0.00723258219659328, 0.00721031613647938, 0.00718806125223637, 0.00716584781184793, 0.00714368838816881, 0.0071215289644897, 0.00709946593269706, 0.00707742292433977, 0.00705546606332064, 0.00703349849209189, 0.00701162638142705, 0.00698976451531053, 0.00696796737611294, 0.00694619119167328, 0.00692451139912009, 0.00690283067524433, 0.00688123609870672, 0.00685965176671743, 0.0068381424061954, 0.00681666424497962, 0.00679522985592484, 0.00677386904135346, 0.00675250869244337, 0.00673123309388757, 0.00670995749533176, 0.00668878946453333, 0.00666760932654142, 0.00664651487022638, 0.00662545301020145, 0.00660445494577289, 0.00658347830176353, 0.00656255427747965, 0.00654165120795369, 0.00652084453031421, 0.00650006020441651, 0.006479328032583, 0.00645865965634584, 0.00643798150122166, 0.0064174085855484, 0.00639683613553643, 0.00637636007741094, 0.00635587330907583, 0.00633550342172384, 0.00631509115919471, 0.00629478506743908, 0.00627449015155435, 0.0062542911618948, 0.00623405957594514, 0.00621397746726871, 0.00619386369362473, 0.00617382442578673, 0.00615381728857756, 0.00613387348130345, 0.00611399346962571, 0.00609413534402847, 0.0060743298381567, 0.00605454575270414, 0.00603481568396091, 0.00601512752473354, 0.00599552504718304, 0.00597593281418085, 0.00595641508698463, 0.00593691878020763, 0.00591748720034957, 0.00589804397895932, 0.00587872928008437, 0.00585940340533853, 0.00584016274660826, 0.0058209546841681, 0.0058017885312438, 0.00578268617391586, 0.0057635847479105, 0.00574457831680775, 0.0057255825959146, 0.00570667302235961, 0.00568777322769165, 0.00566893769428134, 0.00565011240541935, 0.00563137279823422, 0.00561267556622624, 0.0055940211750567, 0.00557539891451597, 0.00555685069411993, 0.00553830293938518, 0.00551983993500471, 0.00550140952691436, 0.00548304244875908, 0.00546473963186145, 0.00544644659385085, 0.00542822945863008, 0.00540997972711921, 0.00539185805246234, 0.00537372566759586, 0.00535569991916418, 0.00533767323940992, 0.00531974341720343, 0.00530177121981978, 0.0052839363925159, 0.00526608107611537, 0.00524834310635924, 0.00523058325052261, 0.00521291932091117, 0.00519525585696101, 0.00517767714336514, 0.00516013102605939, 0.00514261657372117, 0.00512519758194685, 0.00510776834562421, 0.00509043503552675, 0.00507306959480047, 0.00505582103505731, 0.00503858365118504, 0.00502142077311873, 0.00500428956001997, 0.00498719047755003, 0.00497015519067645, 0.00495317345485091, 0.00493619125336409, 0.00491930544376373, 0.00490246200934052, 0.00488567166030407, 0.00486893532797694, 0.00485219806432724, 0.00483552506193519, 0.00481887394562364, 0.0048023178242147, 0.00478577241301537, 0.00476931314915419, 0.00475286366418004, 0.00473647844046354, 0.00472010392695665, 0.00470381416380405, 0.00468755699694157, 0.00467136316001415, 0.00465519120916724, 0.00463909329846501, 0.00462298514321446, 0.00460698362439871, 0.00459104590117931, 0.00457507558166981, 0.0045592337846756, 0.00454337010160089, 0.00452759210020304, 0.00451181409880519, 0.00449615344405174, 0.00448047183454037, 0.00446489593014121, 0.00444932002574205, 0.00443381909281015, 0.00441830744966865, 0.00440291315317154, 0.00438751839101315, 0.00437222002074122, 0.00435691047459841, 0.00434170803055167, 0.00432650512084365, 0.00431135576218367, 0.00429628090932965, 0.00428122701123357, 0.00426622666418552, 0.0042512477375567, 0.00423636473715305, 0.00422146031633019, 0.00420665182173252, 0.00419186428189278, 0.00417715171352029, 0.00416246056556702, 0.00414783321321011, 0.0041332165710628, 0.00411868467926979, 0.0041041849181056, 0.00408973870798945, 0.00407536700367928, 0.00406097387894988, 0.00404669810086489, 0.00403239019215107, 0.00401819963008165, 0.00400398764759302, 0.0039899037219584, 0.00397580908611417, 0.00396179920062423, 0.00394775765016675, 0.00393383344635367, 0.00391991995275021, 0.00390610191971064, 0.00389227364212275, 0.003878551768139, 0.00386480847373605, 0.0038511399179697, 0.00383750326000154, 0.00382396252825856, 0.00381046440452337, 0.00379694486036897, 0.00378355337306857, 0.00377011927776039, 0.00375681277364492, 0.0037434957921505, 0.00373027450405061, 0.00371704273857176, 0.00370391737669706, 0.00369077059440315, 0.00367771997116506, 0.00366466934792697, 0.00365173583850265, 0.0036387809086591, 0.00362592190504074, 0.00361306313425303, 0.00360032147727907, 0.00358751555904746, 0.0035748805385083, 0.00356223457492888, 0.0035496314521879, 0.00353708118200302, 0.00352456327527761, 0.00351209891960025, 0.00349966599605978, 0.00348730781115592, 0.00347497081384063, 0.00346271903254092, 0.00345046725124121, 0.00343829044140875, 0.00342612387612462, 0.00341403181664646, 0.00340199330821633, 0.00339000788517296, 0.0033780331723392, 0.00336614390835166, 0.00335428630933166, 0.00334246060810983, 0.00333072082139552, 0.00331895891577005, 0.00330732529982924, 0.00329564884305, 0.00328411092050374, 0.00327253015711904, 0.0032610350754112, 0.00324958236888051, 0.0032382148783654, 0.00322684738785028, 0.00321553344838321, 0.00320426188409328, 0.00319305411539972, 0.0031818572897464, 0.00317075639031827, 0.00315966573543847, 0.00314864958636463, 0.00313770864158869, 0.00312671414576471, 0.0031158474739641, 0.00310500198975205, 0.00309422053396702, 0.00308342836797237, 0.0030727747362107, 0.00306204659864306, 0.00305146723985672, 0.00304087740369141, 0.00303038395941257, 0.00301989004947245, 0.0030094813555479, 0.002999072894454, 0.00298876012675464, 0.00297842617146671, 0.00296822004020214, 0.00295800319872797, 0.00294787157326937, 0.00293779303319752, 0.00292770424857736, 0.00291768973693252, 0.0029077073559165, 0.00289782066829503, 0.00288793398067355, 0.00287810084410012, 0.00286831031553447, 0.0028585831169039, 0.00284886709414423, 0.00283924699760973, 0.00282963737845421, 0.0028201024979353, 0.00281057809479535, 0.00280113890767097, 0.00279168924316764, 0.00278234598226845, 0.00277305603958666, 0.00276375561952591, 0.00275456113740802, 0.0027453457005322, 0.00273623713292181, 0.00272709620185196, 0.0027181045152247, 0.00270908093079925, 0.00270014232955873, 0.00269122538156807, 0.00268238293938339, 0.00267352955415845, 0.00266478327102959, 0.00265605770982802, 0.00264740688726306, 0.00263876700773835, 0.00263020140118897, 0.00262166792526841, 0.00261316611431539, 0.00260474998503923, 0.00259632291272283, 0.00258800224401057, 0.00257968180812895, 0.00257145729847252, 0.0025631794705987, 0.00255506113171577, 0.00254692183807492, 0.00253886776044965, 0.00253081368282437, 0.00252288742922246, 0.00251487572677433, 0.00250702421180904, 0.00249916175380349, 0.00249139522202313, 0.00248366058804095, 0.00247595808468759, 0.00246829818934202, 0.00246067019179463, 0.00245312741026282, 0.00244558462873101, 0.00243813754059374, 0.00243070139549673, 0.00242333975620568, 0.00241597811691463, 0.00240870169363916, 0.00240144645795226, 0.00239427667111158, 0.00238710688427091, 0.00238002208061516, 0.00237296940758824, 0.00236595934256911, 0.00235900259576738, 0.00235206703655422, 0.00234523811377585, 0.00233837706036866, 0.00233163335360587, 0.00232486822642386, 0.00231818831525743, 0.00231154030188918, 0.00230497773736715, 0.00229840469546616, 0.00229193782433867, 0.00228544976562262, 0.00227903621271253, 0.00227265479043126, 0.00226637977175415, 0.00226008356548846, 0.00225388305261731, 0.0022477253805846, 0.00224157818593085, 0.00223548407666385, 0.00222942233085632, 0.00222347769886255, 0.00221747974865139, 0.00221163057722151, 0.00220573926344514, 0.00219994387589395, 0.00219416944310069, 0.00218846974894404, 0.00218278076499701, 0.00217718747444451, 0.00217158370651305, 0.00216607586480677, 0.00216056779026985, 0.00215515587478876, 0.00214977585710585, 0.00214441679418087, 0.00213914341293275, 0.00213386979885399, 0.00212867092341185, 0.00212349323555827, 0.00211839005351067, 0.00211330829188228, 0.00210830103605986, 0.00210331520065665, 0.00209872191771865, 0.00209436845034361, 0.00209003640338778, 0.0020857285708189, 0.00208144122734666, 0.00207717623561621, 0.00207291287370026, 0.00206864951178432, 0.00206443038769066, 0.00206022360362113, 0.00205603754147887, 0.00205187452957034, 0.00204772432334721, 0.00204359483905137, 0.00203945720568299, 0.00203535007312894, 0.0020312771666795, 0.00202721660025418, 0.00202315580099821, 0.00201913923956454, 0.00201510218903422, 0.00201110844500363, 0.00200713728554547, 0.00200317823328078, 0.00199924083426595, 0.00199530529789627, 0.00199140119366348, 0.0019874987192452, 0.00198361929506063, 0.00197977130301297, 0.00197592470794916, 0.00197211210615933, 0.00196830998174846, 0.00196452019736171, 0.00196073134429753, 0.00195698533207178, 0.00195325235836208, 0.00194954057224095, 0.00194584031123668, 0.00194217404350638, 0.0019384752959013, 0.00193483103066683, 0.00193121004849672, 0.00192759989295155, 0.00192400219384581, 0.00192043662536889, 0.00191687175538391, 0.00191332015674561, 0.00190979964099824, 0.00190628063865006, 0.00190279562957585, 0.0018993312260136, 0.00189586810301989, 0.00189241755288094, 0.00188899901695549, 0.00188559317030013, 0.00188221945427358, 0.00187885679770261, 0.00187550764530897, 0.00187217898201197, 0.00186884112190455, 0.00186554784886539, 0.00186226447112858, 0.00185900367796421, 0.00185575627256185, 0.00185253971721977, 0.00184930500108749, 0.00184611219447106, 0.00184294092468917, 0.00183978315908462, 0.00183664646465331, 0.00183352164458483, 0.00183042022399604, 0.00182731857057661, 0.00182424962986261, 0.00182119337841868, 0.00181816914118826, 0.00181514676660299, 0.00181214569602162, 0.00180914555676281, 0.00180617964360863, 0.00180323468521237, 0.00180031161289662, 0.00179739168379456, 0.00179450283758342, 0.00179162621498108, 0.00178874039556831, 0.00178590789437294, 0.00178307725582272, 0.00178026815410703, 0.00177748070564121, 0.00177470699418336, 0.00177193223498762, 0.00176920101512223, 0.00176648364868015, 0.00176377571187913, 0.00176109082531184, 0.00175842887256294, 0.00175576680339873, 0.00175311742350459, 0.00175051053520292, 0.00174790434539318, 0.00174532213713974, 0.00174276053439826, 0.00174021045677364, 0.00173769542016089, 0.00173515791539103, 0.00173266499768943, 0.00173019466456026, 0.00172773434314877, 0.00172529940027744, 0.0017228729557246, 0.00172044802457094, 0.00171805755235255, 0.00171568768564612, 0.00171332992613316, 0.00171100604347885, 0.00170868157874793, 0.00170637993142009, 0.00170408061239868, 0.00170180213171989, 0.00169955822639167, 0.00169733422808349, 0.00169511151034385, 0.00169292418286204, 0.00169072486460209, 0.00168855825904757, 0.00168641621712595, 0.00168429419863969, 0.00168217346072197, 0.00168008718173951, 0.00167802185751498, 0.00167593755759299, 0.00167389481794089, 0.00167187477927655, 0.00166986847762018, 0.00166788150090724, 0.00166591804008931, 0.00166394643019885, 0.00166200543753803, 0.00166009762324393, 0.00165819271933287, 0.00165630772244185, 0.00165444728918374, 0.0016526075778529, 0.00165074726101011, 0.0016489434055984, 0.00164714828133583, 0.00164536572992802, 0.00164360727649182, 0.00164186873007566, 0.00164012087043375, 0.00163841829635203, 0.00163672503549606, 0.0016350457444787, 0.00163339776918292, 0.00163176096975803, 0.0016301377909258, 0.00162851437926292, 0.00162693369202316, 0.0016253562644124, 0.00162380945403129, 0.00162228534463793, 0.00162076391279697, 0.00161924166604877, 0.00161776482127607, 0.00161629740614444, 0.0016148523427546, 0.00161343230865896, 0.00161201064474881, 0.00161062169354409, 0.00160922529175878, 0.00160787021741271, 0.00160652725026011, 0.00160520826466382, 0.00160389905795455, 0.0016026139492169, 0.00160133896861225, 0.00160007528029382, 0.00159882474690676, 0.00159761623945087, 0.00159640901256353, 0.00159522576723248, 0.00159406254533678, 0.00159289001021534, 0.00159175205044448, 0.00159064528997988, 0.0015895520336926, 0.00158846797421575, 0.00158740731421858, 0.00158636993728578, 0.00158531044144183, 0.00158430589362979, 0.00158332427963614, 0.00158234301488847, 0.00158138340339065, 0.00158044788986444, 0.0015795009676367, 0.00157859863247722, 0.00157771783415228, 0.00157683831639588, 0.00157599255908281, 0.00157515692990273, 0.00157433329150081, 0.00157352234236896, 0.00157273269724101, 0.00157196482177824, 0.00157122104428709, 0.0015704978723079, 0.00156977691221982, 0.00156906642951071, 0.00156838924158365, 0.00156772462651134, 0.00156708084978163, 0.00156645954120904, 0.00156586233060807, 0.00156526372302324, 0.00156466651242226, 0.00156411435455084, 0.00156357255764306, 0.00156305369455367, 0.00156255718320608, 0.0015620602061972, 0.00156157766468823, 0.00156112550757825, 0.0015606846427545, 0.00156027916818857, 0.00155988312326372, 0.00155949941836298, 0.00155913922935724, 0.00155876704957336, 0.0015584408538416, 0.0015581245534122, 0.00155784073285758, 0.00155755982268602, 0.00155730010010302, 0.00155704119242728, 0.0015568167436868, 0.00155661231838167, 0.00155641068704426, 0.00155624083708972, 0.00155610369984061, 0.00155595852993429, 0.00155582325533032, 0.00155570998322219, 0.00155563151929528, 0.00155556364916265, 0.00155552825890481, 0.0015554849524051, 0.00155547237955034, 0.00155545165762305, 0.0015554737765342, 0.00155550707131624, 0.00155557424295694, 0.00155563151929528, 0.00155573128722608, 0.00155581324361265, 0.00155594712123275, 0.00155608227942139, 0.001556251430884, 0.00155642058234662, 0.00155662372708321, 0.00155683746561408, 0.00155704119242728, 0.00155727891251445, 0.00155754922889173, 0.00155784073285758, 0.00155813572928309, 0.00155846145935357, 0.00155876704957336, 0.00155911804176867, 0.00155948882456869, 0.00155988370534033, 0.00156027858611196, 0.00156070676166564, 0.00156114692799747, 0.00156156555749476, 0.00156204961240292, 0.00156255718320608, 0.00156305369455367, 0.00156358256936073, 0.00156412518117577, 0.00156466709449887, 0.00156524311751127, 0.00156585103832185, 0.00156644894741476, 0.00156709144357592, 0.00156773475464433, 0.00156839925330132, 0.00156905583571643, 0.00156977633014321, 0.00157047598622739, 0.00157123187091202, 0.00157197553198785, 0.00157274398952723, 0.00157351163215935, 0.00157432269770652, 0.00157513562589884, 0.0015759919770062, 0.00157684832811356, 0.00157771783415228, 0.00157860887702554, 0.00157950026914477, 0.00158043706323951, 0.00158138340339065, 0.00158234301488847, 0.00158332427963614, 0.00158431637100875, 0.00158531044144183, 0.00158635852858424, 0.00158739613834769, 0.00158846797421575, 0.00158955075312406, 0.00159065530169755, 0.00159177253954113, 0.00159290060400963, 0.00159404193982482, 0.00159522518515587, 0.00159640901256353, 0.00159761623945087, 0.00159883475862443, 0.00160008517559618, 0.00160131684970111, 0.00160260207485408, 0.00160388788208365, 0.00160520756617188, 0.00160652794875205, 0.00160789233632386, 0.00160921399947256, 0.00161061086691916, 0.00161201064474881, 0.00161342089995742, 0.0016148523427546, 0.0016163078835234, 0.00161777425091714, 0.00161925167776644, 0.00162075250409544, 0.00162227463442832, 0.00162380945403129, 0.00162536627613008, 0.00162695499602705, 0.00162851356435567, 0.00163012638222426, 0.00163174979388714, 0.00163338636048138, 0.00163504504598677, 0.00163673504721373, 0.0016384175978601, 0.00164012087043375, 0.00164184730965644, 0.00164360587950796, 0.00164536572992802, 0.00164715899154544, 0.00164894212502986, 0.00165075715631247, 0.0016525856917724, 0.00165443529840559, 0.00165630714036524, 0.00165820273105055, 0.00166009762324393, 0.0016620266251266, 0.00166395574342459, 0.0016659073298797, 0.00166787090711296, 0.00166986708063632, 0.0016718739643693, 0.00167391553986818, 0.00167593639343977, 0.00167799915652722, 0.00168007600586861, 0.00168217346072197, 0.00168429419863969, 0.00168642634525895, 0.00168857967946678, 0.00169071368873119, 0.00169290171470493, 0.00169510091654956, 0.00169733422808349, 0.00169955682940781, 0.00170182273723185, 0.00170406920369714, 0.0017063592094928, 0.00170866097323596, 0.00171099486760795, 0.00171332934405655, 0.00171569851227105, 0.0017180674476549, 0.00172044720966369, 0.00172285106964409, 0.00172528659459203, 0.00172772293444723, 0.0017301932675764, 0.0017326750094071, 0.00173517921939492, 0.0017376629402861, 0.00174019963014871, 0.00174274994060397, 0.00174533145036548, 0.00174791447352618, 0.00175052043050528, 0.00175310531631112, 0.00175575481262058, 0.00175840617157519, 0.00176109024323523, 0.0017637861892581, 0.00176648225169629, 0.00176920101512223, 0.00177193165291101, 0.0017747055971995, 0.00177746964618564, 0.00178027804940939, 0.0017830760916695, 0.00178591720759869, 0.00178873911499977, 0.00179161480627954, 0.00179448141716421, 0.00179739051964134, 0.00180030090268701, 0.00180324469693005, 0.0018061890732497, 0.00180915533564985, 0.00181212380994111, 0.00181514560244977, 0.00181815843097866, 0.00182120269164443, 0.001824249047786, 0.0018273179885, 0.00183039752300829, 0.00183352082967758, 0.00183664646465331, 0.00183979258872569, 0.00184294010978192, 0.00184613221790642, 0.00184929301030934, 0.00185252900701016, 0.00185575510840863, 0.0018590030958876, 0.00186226447112858, 0.00186554645188153, 0.00186882971320301, 0.00187215697951615, 0.00187549495603889, 0.00187884562183172, 0.00188220804557204, 0.00188560259994119, 0.00188902043737471, 0.00189240544568747, 0.00189586740452796, 0.00189931981731206, 0.00190279341768473, 0.00190627947449684, 0.00190980965271592, 0.00191329675726593, 0.00191685976460576, 0.00192041415721178, 0.00192400091327727, 0.00192758929915726, 0.00193121947813779, 0.00193484104238451, 0.00193848519120365, 0.00194214005023241, 0.00194582832045853, 0.00194952916353941, 0.00195325049571693, 0.00195698393508792, 0.00196075136773288, 0.00196450809016824, 0.0019682995043695, 0.0019721002317965, 0.00197592400945723, 0.00197976012714207, 0.00198362814262509, 0.00198749732226133, 0.00199137930758297, 0.0019952931907028, 0.00199921848252416, 0.00200318801216781, 0.00200713658705354, 0.0020111296325922, 0.00201510079205036, 0.0020191166549921, 0.00202315580099821, 0.00202721473760903, 0.00203126575797796, 0.00203537079505622, 0.00203944370150566, 0.00204357202164829, 0.00204770150594413, 0.00205187406390905, 0.00205603754147887, 0.00206024362705648, 0.00206444063223898, 0.00206864951178432, 0.00207289028912783, 0.00207715365104377, 0.00208142981864512, 0.00208573718555272, 0.00209005735814571, 0.00209435727447271, 0.00209870003163815, 0.00210116524249315, 0.0021016513928771, 0.00210213754326105, 0.00210263021290302, 0.00210312311537564, 0.00210361694917083, 0.00210411520674825, 0.00210461299866438, 0.00210511242039502, 0.00210561603307724, 0.00210611801594496, 0.00210662535391748, 0.00210713269189, 0.00210764282383025, 0.00210815691389143, 0.00210866937413812, 0.0021091834641993, 0.0021097029093653, 0.00211022235453129, 0.00211074575781822, 0.00211126776412129, 0.00211179372854531, 0.00211232108995318, 0.00211285101249814, 0.00211337977088988, 0.0021139164455235, 0.0021144503261894, 0.00211498723365366, 0.00211552786640823, 0.00211606849916279, 0.00211661169305444, 0.00211715791374445, 0.00211770110763609, 0.00211825245060027, 0.00211880262941122, 0.00211935513652861, 0.00211990904062986, 0.0021204671356827, 0.00212102243676782, 0.00212158565409482, 0.00212214631028473, 0.00212271371856332, 0.00212327972985804, 0.00212384690530598, 0.00212441687472165, 0.00212498963810503, 0.00212556077167392, 0.00212614028714597, 0.00212671677581966, 0.00212729605846107, 0.00212787929922342, 0.00212846277281642, 0.00212904857471585, 0.00212963600642979, 0.00213022320531309, 0.00213081715628505, 0.00213141110725701, 0.00213200505822897, 0.00213260157033801, 0.00213320087641478, 0.00213380134664476, 0.00213440600782633, 0.0021350106690079, 0.00213561928831041, 0.00213622790761292, 0.00213683792389929, 0.0021374502684921, 0.00213806563988328, 0.00213868077844381, 0.00213930127210915, 0.00213992199860513, 0.00214054249227047, 0.00214116717688739, 0.00214179418981075, 0.00214242306537926, 0.00214305403642356, 0.00214368547312915, 0.00214432063512504, 0.00214495719410479, 0.00214559375308454, 0.00214623287320137, 0.00214687478728592, 0.00214751809835434, 0.00214816653169692, 0.00214881380088627, 0.00214946502819657, 0.00215011625550687, 0.00215076748281717, 0.00215142406523228, 0.00215208041481674, 0.00215273979119956, 0.00215340266004205, 0.00215406599454582, 0.00215472793206573, 0.00215539638884366, 0.00215606484562159, 0.0021567374933511, 0.00215740990824997, 0.00215808511711657, 0.00215876288712025, 0.00215944205410779, 0.00216012005694211, 0.00216080318205059, 0.00216148770414293, 0.00216217478737235, 0.0021628646645695, 0.00216355454176664, 0.00216424698010087, 0.0021649394184351, 0.00216563581489027, 0.00216633500531316, 0.00216703559271991, 0.00216773594729602, 0.00216844165697694, 0.0021691475994885, 0.00216985330916941, 0.00217056437395513, 0.00217127567157149, 0.00217199209146202, 0.00217270595021546, 0.0021734235342592, 0.00217414274811745, 0.00217486335895956, 0.00217558653093874, 0.00217631342820823, 0.0021770391613245, 0.00217776768840849, 0.00217850157059729, 0.00217923405580223, 0.0021799688693136, 0.00218070414848626, 0.00218144315294921, 0.00218218634836376, 0.00218292814679444, 0.0021836725063622, 0.00218441826291382, 0.00218516797758639, 0.00218591652810574, 0.00218667159788311, 0.00218742387369275, 0.00218818313442171, 0.00218893797136843, 0.00218969979323447, 0.0021904616151005, 0.00219122460111976, 0.00219199038110673, 0.00219276151619852, 0.00219352985732257, 0.00219430075958371, 0.00219507445581257, 0.00219585234299302, 0.00219662999734282, 0.00219740904867649, 0.00219818926416337, 0.00219897506758571, 0.00219975970685482, 0.00220054644159973, 0.00220133480615914, 0.00220212596468627, 0.00220291828736663, 0.00220371596515179, 0.00220451108179986, 0.00220531271770597, 0.00220611179247499, 0.00220691482536495, 0.00220772041939199, 0.00220852624624968, 0.00220933463424444, 0.00221014674752951, 0.00221095909364522, 0.00221177283674479, 0.00221258914098144, 0.00221340684220195, 0.0022142285015434, 0.00221505016088486, 0.00221587461419404, 0.00221670279279351, 0.00221752724610269, 0.00221835798583925, 0.00221919058822095, 0.00222002412192523, 0.00222085905261338, 0.00222169933840632, 0.00222253846004605, 0.00222338130697608, 0.00222422298975289, 0.00222506723366678, 0.00222591683268547, 0.00222676643170416, 0.00222761742770672, 0.00222847098484635, 0.00222932593896985, 0.00223018368706107, 0.00223104120232165, 0.00223190290853381, 0.00223276717588305, 0.0022336314432323, 0.00223449850454926, 0.00223536789417267, 0.0022362363524735, 0.00223710853606462, 0.00223798491060734, 0.00223886105231941, 0.00223974254913628, 0.00224062148481607, 0.00224150321446359, 0.00224238727241755, 0.002243272960186, 0.00224416004493833, 0.00224505341611803, 0.00224594445899129, 0.00224683806300163, 0.00224773539230227, 0.00224863039329648, 0.00224953191354871, 0.00225043226964772, 0.00225133635103703, 0.00225224462337792, 0.00225315033458173, 0.00225405977107584, 0.00225497200153768, 0.00225588423199952, 0.00225679902359843, 0.00225771800614893, 0.00225863675586879, 0.00225955969654024, 0.0022604800760746, 0.00226140697486699, 0.00226233364082873, 0.00226326053962111, 0.00226419139653444, 0.00226512760855258, 0.00226605986244977, 0.00226699723862112, 0.00226793624460697, 0.00226887501776218, 0.0022698191460222, 0.00227076350711286, 0.0022717087995261, 0.00227265991270542, 0.00227360799908638, 0.00227456027641892, 0.00227551488205791, 0.00227646972052753, 0.00227742712013423, 0.00227839010767639, 0.00227935030125082, 0.00228031701408327, 0.00228127976879478, 0.00228224671445787, 0.00228321738541126, 0.00228418968617916, 0.00228516175411642, 0.00228613917715847, 0.00228711403906345, 0.00228809425607324, 0.00228907563723624, 0.00229005981236696, 0.00229104538448155, 0.00229203212074935, 0.00229302025400102, 0.00229401374235749, 0.00229500443674624, 0.00229599932208657, 0.00229699653573334, 0.00229799561202526, 0.00229899422265589, 0.00229999981820583, 0.00230100098997355, 0.00230201194062829, 0.00230301730334759, 0.00230402802117169, 0.00230504153296351, 0.00230605504475534, 0.0023070708848536, 0.00230809114873409, 0.00230910838581622, 0.00231013121083379, 0.00231115543283522, 0.00231218081898987, 0.00231321016326547, 0.00231423950754106, 0.00231527164578438, 0.00231630634516478, 0.00231733848340809, 0.00231837597675622, 0.00231941719539464, 0.0023204586468637, 0.00232150149531662, 0.00232254806905985, 0.00232359208166599, 0.00232464424334466, 0.00232569361105561, 0.0023267469368875, 0.00232780305668712, 0.00232886034063995, 0.00232991902157664, 0.00233098049648106, 0.00233204034157097, 0.00233310600742698, 0.00233417260460556, 0.00233524199575186, 0.00233631394803524, 0.00233738590031862, 0.00233845668844879, 0.0023395367898047, 0.00234061270020902, 0.00234169280156493, 0.002342778025195, 0.00234386068768799, 0.00234494591131806, 0.00234603532589972, 0.0023471221793443, 0.00234821671620011, 0.00234930892474949, 0.00235040485858917, 0.00235150475054979, 0.0023526034783572, 0.00235370476730168, 0.00235480745323002, 0.00235591130331159, 0.00235701934434474, 0.00235813134349883, 0.00235924054868519, 0.00236035650596023, 0.00236146850511432, 0.00236258446238935, 0.00236370577476919, 0.00236482569016516, 0.00236594839952886, 0.0023670750670135, 0.00236820033751428, 0.002369329566136, 0.00237046019174159, 0.00237159081734717, 0.00237272819504142, 0.00237386394292116, 0.00237500132061541, 0.00237614405341446, 0.00237728399224579, 0.0023784264922142, 0.00237957458011806, 0.00238072243519127, 0.00238187029026449, 0.00238302629441023, 0.0023841792717576, 0.00238533806987107, 0.00238649128004909, 0.00238764984533191, 0.00238881376571953, 0.00238997768610716, 0.00239114160649478, 0.00239231088198721, 0.00239347736351192, 0.00239465199410915, 0.00239582383073866, 0.0023969984613359, 0.00239817821420729, 0.00239935563877225, 0.00240053539164364, 0.00240172073245049, 0.0024029032792896, 0.00240408862009645, 0.00240528164431453, 0.00240647210739553, 0.00240766280330718, 0.00240885862149298, 0.00241005443967879, 0.00241125584580004, 0.00241245422512293, 0.00241365539841354, 0.00241486192680895, 0.00241606845520437, 0.00241727498359978, 0.0024184868671, 0.00241969595663249, 0.00242090784013271, 0.00242212787270546, 0.00242334487847984, 0.00242456491105258, 0.00242578727193177, 0.00242700986564159, 0.00242823758162558, 0.00242946273647249, 0.0024306932464242, 0.00243192375637591, 0.00243315962143242, 0.00243439548648894, 0.00243563135154545, 0.00243686977773905, 0.00243811355903745, 0.00243935477919877, 0.00244059856049716, 0.00244184769690037, 0.00244309660047293, 0.00244434317573905, 0.00244560046121478, 0.00244685215875506, 0.00244811200536788, 0.00244936905801296, 0.00245062890462577, 0.00245189387351274, 0.00245315651409328, 0.00245442148298025, 0.00245569203980267, 0.00245695980265737, 0.00245823292061687, 0.00245950883254409, 0.00246078451164067, 0.00246206298470497, 0.00246334401890635, 0.00246462249197066, 0.00246590888127685, 0.00246719270944595, 0.00246848165988922, 0.00246977363713086, 0.00247106258757412, 0.00247235433198512, 0.00247365143150091, 0.00247494853101671, 0.00247624842450023, 0.00247755064629018, 0.00247885310091078, 0.00248016067780554, 0.00248146336525679, 0.00248277094215155, 0.00248408666811883, 0.00248539703898132, 0.00248671276494861, 0.00248803105205297, 0.00248934957198799, 0.002490668091923, 0.00249199173413217, 0.00249331537634134, 0.00249464437365532, 0.00249597080983222, 0.00249729980714619, 0.0024986369535327, 0.00249996595084667, 0.00250130286440253, 0.00250264280475676, 0.0025039822794497, 0.00250532478094101, 0.0025066698435694, 0.00250801467336714, 0.00250936252996325, 0.00251071015372872, 0.00251206057146192, 0.00251341890543699, 0.00251477467827499, 0.00251613021828234, 0.0025174911133945, 0.00251884944736958, 0.00252021593041718, 0.00252157938666642, 0.00252294586971402, 0.00252431747503579, 0.00252568908035755, 0.00252705812454224, 0.00252843787893653, 0.00252981204539537, 0.00253118900582194, 0.00253257155418396, 0.00253395386971533, 0.00253534130752087, 0.00253672641701996, 0.00253811408765614, 0.0025395043194294, 0.00254089711233974, 0.00254229013808072, 0.0025436885189265, 0.00254508666694164, 0.00254648784175515, 0.0025478913448751, 0.00254929228685796, 0.00255070114508271, 0.00255210767500103, 0.00255351653322577, 0.0025549279525876, 0.0025563423987478, 0.00255775661207736, 0.00255917361937463, 0.00256059318780899, 0.00256201811134815, 0.00256344024091959, 0.00256486516445875, 0.00256629288196564, 0.0025677231606096, 0.00256915087811649, 0.00257058627903461, 0.00257202191278338, 0.00257345754653215, 0.00257489830255508, 0.00257633929140866, 0.00257778284139931, 0.00257922639138997, 0.00258067273534834, 0.00258212420158088, 0.00258357310667634, 0.00258502457290888, 0.00258647906593978, 0.00258793565444648, 0.00258939247578382, 0.00259085488505661, 0.0025923172943294, 0.00259378203190863, 0.00259524956345558, 0.00259671430103481, 0.00259818462654948, 0.00259965751320124, 0.00260113039985299, 0.00260260840877891, 0.00260408385656774, 0.00260556465946138, 0.00260704825632274, 0.00260852929204702, 0.00261001545004547, 0.00261150160804391, 0.00261299056001008, 0.0026144846342504, 0.00261597894132137, 0.00261747022159398, 0.00261896708980203, 0.0026204667519778, 0.00262196594849229, 0.00262347375974059, 0.0026249757502228, 0.00262648588977754, 0.0026279934681952, 0.00262950360774994, 0.0026310165412724, 0.00263252947479486, 0.00263404473662376, 0.00263556558638811, 0.00263708620332181, 0.00263860705308616, 0.00264013325795531, 0.00264165946282446, 0.0026431882288307, 0.00264471699483693, 0.00264624855481088, 0.002647785237059, 0.00264931935817003, 0.00265085627324879, 0.00265239574946463, 0.00265393778681755, 0.00265548005700111, 0.00265702977776527, 0.002658577170223, 0.00266012735664845, 0.00266167754307389, 0.00266322772949934, 0.00266478559933603, 0.00266634114086628, 0.00266790203750134, 0.00266946270130575, 0.00267102615907788, 0.00267258961685002, 0.00267415819689631, 0.0026757272426039, 0.00267729838378727, 0.00267886999063194, 0.00268044648692012, 0.00268202368170023, 0.00268360273912549, 0.00268517970107496, 0.00268676434643567, 0.00268834643065929, 0.00268993386998773, 0.00269152387045324, 0.00269311410374939, 0.00269470666535199, 0.00269629945978522, 0.0026978945825249, 0.00269949529320002, 0.00270109344273806, 0.00270269415341318, 0.00270430045202374, 0.00270590628497303, 0.00270750955678523, 0.00270912097766995, 0.00271073216572404, 0.00271234894171357, 0.00271396292373538, 0.00271557969972491, 0.00271719903685153, 0.00271882093511522, 0.00272044306620955, 0.0027220705524087, 0.00272369524464011, 0.00272532505914569, 0.00272695510648191, 0.00272859050892293, 0.00273022311739624, 0.0027318587526679, 0.00273349927738309, 0.00273514236323535, 0.00273678335361183, 0.00273842643946409, 0.00274007255211473, 0.00274172378703952, 0.00274336989969015, 0.00274502648971975, 0.00274667772464454, 0.00274833710864186, 0.00274999625980854, 0.00275165308266878, 0.00275331479497254, 0.00275497976690531, 0.00275664427317679, 0.00275831413455307, 0.00275998143479228, 0.00276165432296693, 0.0027633267454803, 0.00276500452309847, 0.00276668276637793, 0.0027683605439961, 0.00277004111558199, 0.00277172727510333, 0.00277341296896338, 0.00277509912848473, 0.0027767876163125, 0.00277847866527736, 0.00278017017990351, 0.00278186658397317, 0.00278356322087348, 0.0027852626517415, 0.00278696161694825, 0.00278866640292108, 0.00279037095606327, 0.00279207550920546, 0.00279378285631537, 0.00279549811966717, 0.00279720779508352, 0.00279892329126596, 0.00280063832178712, 0.002802356146276, 0.00280407699756324, 0.00280580040998757, 0.00280752335675061, 0.00280925212427974, 0.0028109778650105, 0.00281270639970899, 0.0028144377283752, 0.00281617161817849, 0.00281790806911886, 0.00281964708119631, 0.00282138655893505, 0.00282312813214958, 0.0028248701710254, 0.00282661477103829, 0.002828364726156, 0.00283011188730597, 0.00283186417073011, 0.00283361948095262, 0.0028353719972074, 0.00283712963573635, 0.00283888773992658, 0.00284064840525389, 0.00284241163171828, 0.00284417718648911, 0.00284594320692122, 0.00284771434962749, 0.00284947990439832, 0.00285125407390296, 0.0028530303388834, 0.00285480683669448, 0.00285658612847328, 0.00285836518742144, 0.00286014704033732, 0.00286193168722093, 0.00286371610127389, 0.00286550307646394, 0.00286729587242007, 0.00286908820271492, 0.00287088076584041, 0.00287267845124006, 0.00287447613663971, 0.00287627661600709, 0.00287807453423738, 0.00287988036870956, 0.0028816859703511, 0.00288349180482328, 0.00288530299440026, 0.0028871139511466, 0.00288892537355423, 0.00289074168540537, 0.00289256079122424, 0.00289437733590603, 0.0028962017968297, 0.00289802066981792, 0.00289984769187868, 0.00290167494677007, 0.00290350196883082, 0.0029053317848593, 0.00290716672316194, 0.00290899933315814, 0.0029108370654285, 0.00291267479769886, 0.00291451532393694, 0.0029163584113121, 0.00291820429265499, 0.00292004714719951, 0.0029218983836472, 0.00292374659329653, 0.0029256003908813, 0.00292745418846607, 0.00292931031435728, 0.00293116690590978, 0.00293302885256708, 0.00293488777242601, 0.00293675484135747, 0.00293861632235348, 0.00294048339128494, 0.00294235581532121, 0.00294422847218812, 0.00294609786942601, 0.00294797588139772, 0.00294985086657107, 0.00295173120684922, 0.00295361434109509, 0.00295549444854259, 0.00295738293789327, 0.00295926607213914, 0.0029611571226269, 0.00296305073425174, 0.00296494178473949, 0.00296683539636433, 0.00296873156912625, 0.00297062797471881, 0.00297253229655325, 0.00297443405725062, 0.00297633837908506, 0.00297824549488723, 0.00298015214502811, 0.00298205949366093, 0.00298397708684206, 0.00298588932491839, 0.00298780458979309, 0.00298972451128066, 0.00299164257012308, 0.00299356528557837, 0.00299549102783203, 0.00299741374328732, 0.00299934227950871, 0.00300127058289945, 0.003003204241395, 0.00300513789989054, 0.00300707411952317, 0.00300900777801871   }, 
   { 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 0.000138359551783651, 2.25469463543959e-07, 8.51551362757164e-07, 1.48057733895257e-06, 2.11222595680738e-06, 2.74976264336146e-06, 3.38991776516195e-06, 4.03530975745525e-06, 4.67906465928536e-06, 5.33329739482724e-06, 5.98490714764921e-06, 6.64731260258122e-06, 7.30481497157598e-06, 7.96853510109941e-06, 8.63945570017677e-06, 9.31365138967521e-06, 9.99046187644126e-06, 1.06649804365588e-05, 1.13506266643526e-05, 1.20392223834642e-05, 1.27301054817508e-05, 1.34216415972332e-05, 1.41210339279496e-05, 1.48210838233354e-05, 1.55240759340813e-05, 1.62349260790506e-05, 1.69431550602894e-05, 1.76625126186991e-05, 1.83825213753153e-05, 1.91048238775693e-05, 1.98277812160086e-05, 2.05608812393621e-05, 2.12946433748584e-05, 2.2029051251593e-05, 2.2771317162551e-05, 2.35162042372394e-05, 2.42643618548755e-05, 2.50177563430043e-05, 2.57714782492258e-05, 2.65284725173842e-05, 2.72929919447051e-05, 2.80607873719418e-05, 2.88233422907069e-05, 2.95996469503734e-05, 3.03788929159055e-05, 3.11581461573951e-05, 3.19377213600092e-05, 3.27277703036088e-05, 3.35210934281349e-05, 3.43147403327748e-05, 3.5116245271638e-05, 3.59102232323494e-05, 3.67176107829437e-05, 3.75302479369566e-05, 3.8343856431311e-05, 3.91548564948607e-05, 3.99789460061584e-05, 4.0803355659591e-05, 4.16307120758574e-05, 4.24587269662879e-05, 4.32942688348703e-05, 4.41301344835665e-05, 4.49745130026713e-05, 4.58215072285384e-05, 4.66639212390874e-05, 4.75194246973842e-05, 4.83752519357949e-05, 4.92389408464078e-05, 5.00951064168476e-05, 5.09653364133555e-05, 5.18352426297497e-05, 5.27107113157399e-05, 5.35838844371028e-05, 5.44675349374302e-05, 5.53492245671805e-05, 5.62417080800515e-05, 5.71341952309012e-05, 5.80243940930814e-05, 5.89253904763609e-05, 5.98290025664028e-05, 6.07388392381836e-05, 6.16434335825033e-05, 6.25585016678087e-05, 6.34765165159479e-05, 6.43974781269208e-05, 6.53187671559863e-05, 6.62482343614101e-05, 6.71780289849266e-05, 6.81156816426665e-05, 6.905628106324e-05, 6.99922966305166e-05, 7.09414016455412e-05, 7.18931260053068e-05, 7.28481245459989e-05, 7.37978771212511e-05, 7.47617159504443e-05, 7.57278394303285e-05, 7.66942903283052e-05, 7.76663073338568e-05, 7.86357049946673e-05, 7.96162275946699e-05, 8.05993695394136e-05, 8.15857856650837e-05, 8.25695897219703e-05, 8.3563856605906e-05, 8.45620525069535e-05, 8.55648395372555e-05, 8.65627080202103e-05, 8.75713740242645e-05, 8.85829940671101e-05, 8.95949342520908e-05, 9.061538730748e-05, 9.16358476388268e-05, 9.26589127629995e-05, 9.36904980335385e-05, 9.47246880969033e-05, 9.57543088588864e-05, 9.67970117926598e-05, 9.78397292783484e-05, 9.88883184618317e-05, 9.99343028524891e-05, 0.000100988800113555, 0.000102048521512188, 0.000103108570328914, 0.000104173865111079, 0.000105239800177515, 0.000106311643321533, 0.000107388383185025, 0.000108470689156093, 0.000109545471786987, 0.00011063367855968, 0.000111727436888032, 0.000112816298496909, 0.000113912996312138, 0.000115015274786856, 0.000116118193545844, 0.000117228984890971, 0.000118343035865109, 0.000119453812658321, 0.000120570810395293, 0.000121695666166488, 0.000122824116260745, 0.000123946680105291, 0.000125082995509729, 0.000126219645608217, 0.000127356266602874, 0.000128501080325805, 0.000129649182781577, 0.00013080021017231, 0.000131956490804441, 0.000133115710923448, 0.000134274931042455, 0.000135440030135214, 0.000136610382469371, 0.000137778770294972, 0.000138943913043477, 0.000140064541483298, 0.000141192969749682, 0.000142326651257463, 0.000143473444040865, 0.00014462809485849, 0.000145790574606508, 0.000146971389767714, 0.000148157458170317, 0.000149351355503313, 0.00015055836411193, 0.000151778454892337, 0.000153003784362227, 0.000154234337969683, 0.000155488480231725, 0.000156745212734677, 0.000158009832375683, 0.000159287534188479, 0.000160580922965892, 0.000161874326295219, 0.000163183431141078, 0.000164495169883594, 0.000165822610142641, 0.000167160527780652, 0.000168508922797628, 0.000169859922607429, 0.000171224004589021, 0.000172603817190975, 0.000173991473275237, 0.000175379129359499, 0.000176785120856948, 0.000178204194526188, 0.000179625902092084, 0.000181065901415423, 0.000182511168532073, 0.000183964279131033, 0.000185427867108956, 0.000186909790500067, 0.000188394318684004, 0.000189884085557424, 0.000191392173292115, 0.000192905514268205, 0.000194431937416084, 0.000195963613805361, 0.000197510977159254, 0.000199060974409804, 0.000200629277969711, 0.000202208073460497, 0.000203786854399368, 0.000205383985303342, 0.00020699156448245, 0.000208609635592438, 0.000210227692150511, 0.000211874561500736, 0.000213516192161478, 0.000215176129131578, 0.000216833475860767, 0.000218511748244055, 0.000220197878661565, 0.000221891881665215, 0.000223596332943998, 0.00022530865680892, 0.000227034062845632, 0.00022877256560605, 0.000230516321607865, 0.000232265287195332, 0.000234029983403161, 0.000235805127886124, 0.000237590749748051, 0.000239381624851376, 0.000241188186919317, 0.000242997382883914, 0.000244824914261699, 0.000246662908466533, 0.000248500902671367, 0.000250357203185558, 0.000252224010182545, 0.000254096026765183, 0.000255975930485874, 0.000257874140515924, 0.000259774969890714, 0.000261686276644468, 0.000263610651018098, 0.000265548151219264, 0.000267485622316599, 0.000269446696620435, 0.000271405122475699, 0.00027338188374415, 0.000275363854598254, 0.000277358980383724, 0.000279356667306274, 0.00028136745095253, 0.000283393979771063, 0.000285425718175247, 0.000287470524199307, 0.000289520598016679, 0.00029159162659198, 0.000293662655167282, 0.000295744132017717, 0.000297838734695688, 0.00029993592761457, 0.000302051426842809, 0.000304187909932807, 0.000306313915643841, 0.000308458227664232, 0.000310615636408329, 0.000312775664497167, 0.000314940960379317, 0.000317129772156477, 0.00031932644196786, 0.000321523169986904, 0.000323738204315305, 0.000325961067574099, 0.000328197027556598, 0.000330430368194357, 0.000332684663590044, 0.000334944168571383, 0.000337219418724999, 0.000339502526912838, 0.000341796083375812, 0.000344094878528267, 0.000346409389749169, 0.000348734378349036, 0.000351061957189813, 0.000353402661858127, 0.000355759053491056, 0.000358120712917298, 0.000360487581929192, 0.000362867547664791, 0.000365260610124096, 0.000367661501513794, 0.000370078138075769, 0.000372497393982485, 0.000374929688405246, 0.00037736986996606, 0.000379825767595321, 0.000382289523258805, 0.0003847558691632, 0.000387243198929355, 0.00038973314804025, 0.000392238755011931, 0.000394749658880755, 0.000397257943404838, 0.000399792363168672, 0.000402334640966728, 0.00040488742524758, 0.000407445419114083, 0.000410019158152863, 0.000412603316362947, 0.000415190123021603, 0.000417790055507794, 0.000420405645854771, 0.000423029094235972, 0.000425665639340878, 0.000428310042480007, 0.000430949236033484, 0.000433614564826712, 0.000436290370998904, 0.000438968825619668, 0.000441657786723226, 0.000444359786342829, 0.000447069643996656, 0.000449789979029447, 0.000452520762337372, 0.000455254223197699, 0.000458008551504463, 0.000460770796053112, 0.000463535659946501, 0.000466316181700677, 0.00046911247773096, 0.000471916602691635, 0.000474720698548481, 0.000477543158922344, 0.000480376038467512, 0.000483214214909822, 0.000486060220282525, 0.000488924561068416, 0.000491786282509565, 0.000494666281156242, 0.000497562112286687, 0.00050045782700181, 0.000503364077303559, 0.000506291282363236, 0.000509223667904735, 0.000512161292135715, 0.000515109451953322, 0.000518073269631714, 0.000521039706654847, 0.00052402971778065, 0.000527019728906453, 0.000530012359376997, 0.00053302594460547, 0.000536047329660505, 0.000539071392267942, 0.000542113790288568, 0.000545166607480496, 0.000548224721569568, 0.000551288074348122, 0.000554372323676944, 0.000557461811695248, 0.000560553977265954, 0.000563669600524008, 0.000566787959542125, 0.000569911499042064, 0.000573055993299931, 0.00057620566803962, 0.000579358020331711, 0.000582528649829328, 0.000585712492465973, 0.000588901457376778, 0.000592090480495244, 0.000595305638853461, 0.000598518236074597, 0.000601749052293599, 0.000604990404099226, 0.000608239613939077, 0.000611491443123668, 0.00061476428527385, 0.000618047546595335, 0.00062133080791682, 0.000624629727099091, 0.000627939181867987, 0.000631264294497669, 0.000634584226645529, 0.000637922435998917, 0.000641268561594188, 0.000644627725705504, 0.000647994747851044, 0.000651372305583209, 0.000654760282486677, 0.000658163975458592, 0.000661572848912328, 0.000664984458126128, 0.000668411725200713, 0.000671852030791342, 0.000675308052450418, 0.000678753654938191, 0.000682230689562857, 0.000685710343532264, 0.000689195119775832, 0.000692700908984989, 0.000696206756401807, 0.000699720403645188, 0.000703252444509417, 0.000706792226992548, 0.000710329448338598, 0.000713890243787318, 0.000717461458407342, 0.000721043266821653, 0.000724624958820641, 0.000728217186406255, 0.000731830310542136, 0.00073544611223042, 0.000739072333090007, 0.000742709031328559, 0.000746356265153736, 0.000750011240597814, 0.000753681990318, 0.000757352740038186, 0.00076104438630864, 0.000764744007028639, 0.000768443569540977, 0.000772161467466503, 0.000775889842770994, 0.000779623340349644, 0.000783372728619725, 0.000787132477853447, 0.000790897407568991, 0.00079467031173408, 0.000798461434897035, 0.000802260532509536, 0.000806057010777295, 0.000809879624284804, 0.000813712598755956, 0.000817548425402492, 0.000821394554805011, 0.000825251161586493, 0.00082911568460986, 0.000832993246149272, 0.00083688396262005, 0.000840774620883167, 0.000844670576043427, 0.000848592666443437, 0.00085251999553293, 0.000856449885759503, 0.000860400847159326, 0.000864362169522792, 0.00086832616943866, 0.000872305885422975, 0.000876288220752031, 0.00088027841411531, 0.000884289445821196, 0.000888311129529029, 0.000892335257958621, 0.000896364741493016, 0.0009004125604406, 0.000904470740351826, 0.000908534217160195, 0.000912605610210449, 0.000916695280466229, 0.000920784892514348, 0.000924892956390977, 0.000929008761886507, 0.00093312980607152, 0.00093726662453264, 0.000941411242820323, 0.000945571635384113, 0.000949732027947903, 0.000953913317061961, 0.000958094606176019, 0.000962286430876702, 0.000966491235885769, 0.000970709254033864, 0.000974927213974297, 0.000979166128672659, 0.000983412959612906, 0.000987662235274911, 0.000991929904557765, 0.000996202928945422, 0.0010004915529862, 0.00100479065440595, 0.00100909767206758, 0.00101340457331389, 0.00101773254573345, 0.00102206051815301, 0.00102641724515706, 0.00103076081722975, 0.00103512546047568, 0.00103950046468526, 0.00104388862382621, 0.00104828458279371, 0.0010526884580031, 0.00105710804928094, 0.00106152752414346, 0.00106596283148974, 0.00107040593866259, 0.00107485696207732, 0.00107932358514518, 0.00108379824087024, 0.00108828058000654, 0.00109277339652181, 0.00109727936796844, 0.00110179593320936, 0.00110632018186152, 0.00111084966920316, 0.00111539487261325, 0.00111994531471282, 0.00112451158929616, 0.00112907774746418, 0.00113366218283772, 0.00113825721200556, 0.00114286527968943, 0.00114747334737331, 0.00115209724754095, 0.00115673139225692, 0.00116137880831957, 0.00116603134665638, 0.00117069180123508, 0.00117536797188222, 0.00118004670366645, 0.00118474650662392, 0.00118944875430316, 0.00119416147936136, 0.00119887967593968, 0.00120362127199769, 0.00120836275164038, 0.00121310702525079, 0.00121787481475621, 0.00122264795936644, 0.00122743402607739, 0.00123222533147782, 0.00123702187556773, 0.0012418394908309, 0.0012466674670577, 0.00125149288214743, 0.0012563286582008, 0.00126118818297982, 0.00126605026889592, 0.00127092259936035, 0.00127580820117146, 0.00128069904167205, 0.00128560047596693, 0.00129051215481013, 0.0012954396661371, 0.00130036461632699, 0.00130531052127481, 0.00131026410963386, 0.00131522817537189, 0.00132019247394055, 0.0013251774944365, 0.00133017578627914, 0.00133517652284354, 0.00134018529206514, 0.00134520698338747, 0.00135023915208876, 0.00135528191458434, 0.00136033771559596, 0.00136538816150278, 0.00137046747840941, 0.00137554958928376, 0.00138064450584352, 0.00138573965523392, 0.00139085820410401, 0.0013959847856313, 0.00140111125074327, 0.00140624295454472, 0.0014113956131041, 0.00141655351035297, 0.00142173236235976, 0.00142691121436656, 0.00143209518864751, 0.00143730035051703, 0.00144252111203969, 0.00144773663487285, 0.00145296519622207, 0.00145820947363973, 0.00146346155088395, 0.00146871630568057, 0.00147399213165045, 0.00147927575744689, 0.00148455938324332, 0.00148986896965653, 0.00149518402758986, 0.00150049652438611, 0.00150582974310964, 0.00151117343921214, 0.00151651736814529, 0.00152187957428396, 0.00152725458610803, 0.00153263506945223, 0.00153802079148591, 0.00154342222958803, 0.00154882622882724, 0.00155424850527197, 0.00155968137551099, 0.00156512204557657, 0.00157056795433164, 0.00157602957915515, 0.0015815069200471, 0.00158697902224958, 0.0015924668405205, 0.00159797025844455, 0.00160348683129996, 0.00160900084301829, 0.00161453313194215, 0.00162007077597082, 0.0016256186645478, 0.00163118506316096, 0.00163675413932651, 0.00164232822135091, 0.00164792605210096, 0.001653523882851, 0.00165913195814937, 0.00166474806610495, 0.00167038524523377, 0.00167602743022144, 0.0016816696152091, 0.00168732227757573, 0.00169299612753093, 0.00169867242220789, 0.0017043644329533, 0.00171006692107767, 0.00171577464789152, 0.00172149809077382, 0.00172722165007144, 0.00173295801505446, 0.00173871021252126, 0.00174447300378233, 0.00175024371128529, 0.00175602210219949, 0.00176180829294026, 0.00176760496105999, 0.00177341757807881, 0.00177923787850887, 0.00178506597876549, 0.00179090199526399, 0.00179675105027854, 0.00180261593777686, 0.0018084755865857, 0.00181435607373714, 0.00182024971581995, 0.00182614324148744, 0.00183205516077578, 0.00183796719647944, 0.00184389494825155, 0.00184983562212437, 0.00185578677337617, 0.00186174060218036, 0.00186771026346833, 0.00187369028571993, 0.0018796807853505, 0.00188567652367055, 0.00189168273936957, 0.00189770199358463, 0.00190372916404158, 0.00190977461170405, 0.00191581738181412, 0.00192187598440796, 0.00192794518079609, 0.00193402462173253, 0.00193953851703554, 0.00194467033725232, 0.00194979156367481, 0.00195495970547199, 0.00196012295782566, 0.00196532811969519, 0.001970554003492, 0.00197579059749842, 0.00198105326853693, 0.00198632618412375, 0.00199163076467812, 0.00199696677736938, 0.00200230255723, 0.00200766464695334, 0.00201304792426527, 0.00201845169067383, 0.00202388199977577, 0.00202931230887771, 0.00203478964976966, 0.00204026186838746, 0.00204578600823879, 0.00205131573602557, 0.00205686129629612, 0.00206242757849395, 0.00206802529282868, 0.00207363348454237, 0.00207926263101399, 0.00208490760996938, 0.00209058402106166, 0.00209628650918603, 0.00210199411958456, 0.00210772803984582, 0.00211347755976021, 0.00211925851181149, 0.00212506600655615, 0.00213087303563952, 0.00213670660741627, 0.00214255577884614, 0.00214844150468707, 0.00215434795245528, 0.00216025486588478, 0.00216619833372533, 0.00217215204611421, 0.00217813206836581, 0.00218414864502847, 0.00219015497714281, 0.00219620321877301, 0.00220226706005633, 0.00220835162326694, 0.00221445737406611, 0.00222057336941361, 0.00222672102972865, 0.00223289499990642, 0.00223907385952771, 0.00224529486149549, 0.00225151050835848, 0.00225775758735836, 0.00226403097622097, 0.0022703199647367, 0.00227663503028452, 0.00228295009583235, 0.00228930730372667, 0.00229569035582244, 0.00230207364074886, 0.00230848835781217, 0.00231491844169796, 0.00232137530110776, 0.00232785241678357, 0.00233433535322547, 0.00234085484407842, 0.00234738457947969, 0.0023539406247437, 0.0023605281021446, 0.00236712070181966, 0.00237373961135745, 0.00238038483075798, 0.00238704029470682, 0.00239372719079256, 0.0024004140868783, 0.00240714801475406, 0.00241389288567007, 0.00242064753547311, 0.00242743920534849, 0.00243423623032868, 0.0024410542100668, 0.00244790874421597, 0.00245476816780865, 0.00246165972203016, 0.00246855593286455, 0.00247548380866647, 0.00248244288377464, 0.00248940219171345, 0.00249639293178916, 0.00250339391641319, 0.00251042167656124, 0.00251748529262841, 0.00252454914152622, 0.00253163976594806, 0.00253875600174069, 0.00254588783718646, 0.00255304621532559, 0.00256020412780344, 0.00256740441545844, 0.0025746151804924, 0.00258186226710677, 0.00258912006393075, 0.00259639322757721, 0.00260369293391705, 0.00261100823991001, 0.0026183498557657, 0.00262570730410516, 0.00263307988643646, 0.0026404841337353, 0.00264791469089687, 0.00265534548088908, 0.00266281259246171, 0.00267028505913913, 0.00267778872512281, 0.00268532382324338, 0.00269285938702524, 0.0027004259172827, 0.0027080187574029, 0.00271561159752309, 0.00272324634715915, 0.00273088645190001, 0.00273855240084231, 0.00274625001475215, 0.00275394762866199, 0.00276168715208769, 0.00276942667551339, 0.00277720275335014, 0.00278499466367066, 0.0027928021736443, 0.00280064134858549, 0.00280848541297019, 0.00281636067666113, 0.0028242573607713, 0.00283216987736523, 0.00284010800532997, 0.00284806778654456, 0.00285603757947683, 0.002864038804546, 0.00287205050699413, 0.00288009364157915, 0.00288814725354314, 0.0028962274082005, 0.00290433340705931, 0.00291244452819228, 0.00292058708146214, 0.00292875105515122, 0.00293693016283214, 0.00294514070264995, 0.00295335170812905, 0.0029615939129144, 0.00296986196190119, 0.00297814095392823, 0.00298645626753569, 0.00299477181397378, 0.00300312391482294, 0.0030114867258817, 0.00301987561397254, 0.00302829034626484, 0.00303670554421842, 0.00304515729658306, 0.0030536400154233, 0.00306212296709418, 0.00307063781656325, 0.00307915732264519, 0.00308771361596882, 0.00309629621915519, 0.00310488394461572, 0.00311349774710834, 0.00312213809229434, 0.0031307830940932, 0.0031394655816257, 0.00314815249294043, 0.00315687130205333, 0.00316560594365001, 0.00317436107434332, 0.00318314787000418, 0.00319193978793919, 0.00320075801573694, 0.00320960255339742, 0.00321846245788038, 0.00322734354995191, 0.00323624024167657, 0.00324516324326396, 0.0032541174441576, 0.00326306675560772, 0.00327206286601722, 0.00328105897642672, 0.0032900869846344, 0.00329913524910808, 0.00330819934606552, 0.00331728998571634, 0.00332639110274613, 0.00333551806397736, 0.00334468204528093, 0.00335383508354425, 0.00336303049698472, 0.00337224127724767, 0.00338145741261542, 0.00339072593487799, 0.00339998910203576, 0.00340927881188691, 0.0034185997210443, 0.00342792575247586, 0.00343728344887495, 0.00344665138982236, 0.00345605099573731, 0.00346547109074891, 0.00347490701824427, 0.0034843641333282, 0.0034938370808959, 0.00350334099493921, 0.00351286097429693, 0.00352240167558193, 0.00353196333162487, 0.0035415303427726, 0.00355113390833139, 0.00356076378375292, 0.00357040390372276, 0.00358007056638598, 0.00358975282870233, 0.00359945092350245, 0.00360918510705233, 0.0036189251113683, 0.00362869095988572, 0.00363846751861274, 0.00364827550947666, 0.00365811469964683, 0.00366794876754284, 0.00367781962268054, 0.00368771119974554, 0.0036976186092943, 0.0037075518630445, 0.00371749605983496, 0.00372747145593166, 0.00373746803961694, 0.0037474799901247, 0.00375751289539039, 0.00376755674369633, 0.00377763668075204, 0.00378773245029151, 0.00379784917458892, 0.00380798731930554, 0.00381813035346568, 0.00382830970920622, 0.00383852072991431, 0.00384873175062239, 0.00385897420346737, 0.00386922201141715, 0.00387950660660863, 0.00388981704600155, 0.00390013284049928, 0.00391047494485974, 0.00392083777114749, 0.003931216429919, 0.00394162628799677, 0.00395204685628414, 0.00396248325705528, 0.00397295644506812, 0.00398343428969383, 0.00399394892156124, 0.00400446401908994, 0.00401501543819904, 0.00402558781206608, 0.00403617555275559, 0.00404679030179977, 0.00405740411952138, 0.00406806077808142, 0.0040787379257381, 0.00408942019566894, 0.00410013925284147, 0.00411086343228817, 0.0041216192767024, 0.00413239561021328, 0.00414318824186921, 0.00415400648489594, 0.00416484056040645, 0.00417569046840072, 0.00418658228591084, 0.00419746898114681, 0.00420838687568903, 0.00421932572498918, 0.00423028552904725, 0.00424126675352454, 0.00425225775688887, 0.00426327530294657, 0.00427432404831052, 0.00428538396954536, 0.00429646903648973, 0.00430756015703082, 0.00431868759915233, 0.0043298308737576, 0.00434099463745952, 0.00435219006612897, 0.00436339108273387, 0.00437460793182254, 0.00438586063683033, 0.00439712963998318, 0.00440841913223267, 0.00441971980035305, 0.00443104607984424, 0.00444240914657712, 0.00445376709103584, 0.00446516647934914, 0.00447657704353333, 0.00448800297454, 0.00449946569278836, 0.00451092794537544, 0.00452241627499461, 0.00453393720090389, 0.00454546231776476, 0.00455702980980277, 0.00456860195845366, 0.0045801904052496, 0.00459182076156139, 0.0046034506522119, 0.00461511220782995, 0.00462678447365761, 0.00463848281651735, 0.0046502179466188, 0.0046619470231235, 0.00467371335253119, 0.00468548433855176, 0.00469728838652372, 0.00470911711454391, 0.004720957018435, 0.00473282299935818, 0.00474470900371671, 0.00475661177188158, 0.00476854527369142, 0.00478047924116254, 0.00479244953021407, 0.00480444123968482, 0.00481643807142973, 0.00482847634702921, 0.00484051508828998, 0.00485259061679244, 0.00486467638984323, 0.0048767882399261, 0.00488892057910562, 0.00490106409415603, 0.00491323927417397, 0.00492544006556273, 0.00493764597922564, 0.00494988355785608, 0.00496213184669614, 0.00497440621256828, 0.00498671131208539, 0.00499902805313468, 0.00501136481761932, 0.00502371229231358, 0.00503609655424953, 0.00504849664866924, 0.00506091210991144, 0.00507335411384702, 0.00508581660687923, 0.00509828981012106, 0.00511079980060458, 0.00512331491336226, 0.0051358612254262, 0.0051484233699739, 0.00516100693494081, 0.00517361098900437, 0.0051862308755517, 0.00519888708367944, 0.00521154887974262, 0.00522422650828958, 0.00523694045841694, 0.00524966511875391, 0.00526241585612297, 0.00527519313618541, 0.00528796995058656, 0.00530077796429396, 0.00531360739842057, 0.00532646290957928, 0.00533933378756046, 0.00535222142934799, 0.00536513980478048, 0.00537807866930962, 0.00539102824404836, 0.00540400436148047, 0.00541699584573507, 0.00543001340702176, 0.00544304167851806, 0.00545610720291734, 0.00546918204054236, 0.00548227829858661, 0.00549540109932423, 0.00550854485481977, 0.00552169885486364, 0.0055348789319396, 0.00554807437583804, 0.00556130148470402, 0.00557455001398921, 0.00558779295533895, 0.00560108292847872, 0.00561437848955393, 0.00562770524993539, 0.00564106367528439, 0.00565441604703665, 0.00566781125962734, 0.0056812115944922, 0.0056946431286633, 0.00570809002965689, 0.0057215578854084, 0.00573504716157913, 0.00574855227023363, 0.00576208299025893, 0.00577563466504216, 0.005789197050035, 0.00580279668793082, 0.00581641122698784, 0.00583004672080278, 0.00584369851276278, 0.00585736567154527, 0.005871064029634, 0.00588478846475482, 0.00589851336553693, 0.00591226434335113, 0.00592603627592325, 0.00593984499573708, 0.00595366396009922, 0.00596749829128385, 0.00598135450854897, 0.00599523074924946, 0.00600913353264332, 0.00602305680513382, 0.00603699125349522, 0.00605096202343702, 0.00606494350358844, 0.00607894035056233, 0.00609297445043921, 0.00610700761899352, 0.00612107804045081, 0.00613516941666603, 0.00614927103742957, 0.00616339361295104, 0.00617754273116589, 0.00619171280413866, 0.00620590336620808, 0.00622010976076126, 0.00623433711007237, 0.00624858029186726, 0.00626285513862967, 0.00627714022994041, 0.0062914565205574, 0.00630578864365816, 0.0063201361335814, 0.0063345106318593, 0.00634891074150801, 0.00636331597343087, 0.00637775845825672, 0.00639221118763089, 0.00640668952837586, 0.00642118928954005, 0.00643569510430098, 0.00645023584365845, 0.00646479381248355, 0.00647937133908272, 0.006493981461972, 0.00650859111919999, 0.00652323244139552, 0.00653789984062314, 0.00655257701873779, 0.00656728586181998, 0.00658200634643435, 0.00659674685448408, 0.00661151856184006, 0.00662629632279277, 0.00664110435172915, 0.0066559286788106, 0.00667077442631125, 0.006685646250844, 0.00670052273198962, 0.00671543087810278, 0.00673035485669971, 0.00674530956894159, 0.00676028663292527, 0.00677526742219925, 0.00679028034210205, 0.00680530909448862, 0.00682036392390728, 0.00683543970808387, 0.00685052620247006, 0.00686564389616251, 0.0068807820789516, 0.00689593097195029, 0.00691111152991652, 0.00692630279809237, 0.00694152433425188, 0.00695676309987903, 0.00697201676666737, 0.00698729651048779, 0.00700258649885654, 0.00701790861785412, 0.00703325727954507, 0.0070486101321876, 0.00706144468858838, 0.00707179168239236, 0.00708221783861518, 0.00709269056096673, 0.00710322102531791, 0.00711382459849119, 0.00712443934753537, 0.00713513186201453, 0.00714590353891253, 0.00715669570490718, 0.00716755632311106, 0.00717846397310495, 0.00718945544213057, 0.00720049347728491, 0.00721155852079391, 0.00722270645201206, 0.0072339023463428, 0.00724515505135059, 0.00725645013153553, 0.00726782390847802, 0.00727923400700092, 0.00729072792455554, 0.00730222696438432, 0.00731382053345442, 0.00732544623315334, 0.00733714969828725, 0.00734888389706612, 0.00736069213598967, 0.00737257860600948, 0.0073844762519002, 0.00739644141867757, 0.00740847457200289, 0.00742054497823119, 0.00743269873782992, 0.00744488928467035, 0.00745713198557496, 0.00746944779530168, 0.00748178968206048, 0.00749421631917357, 0.00750667368993163, 0.00751920975744724, 0.00753178773447871, 0.0075444127433002, 0.00755710108205676, 0.00756986206397414, 0.00758265471085906, 0.00759551534429193, 0.00760841788724065, 0.00762140471488237, 0.00763444835320115, 0.00764750316739082, 0.00766064645722508, 0.00767382653430104, 0.00768708484247327, 0.00770037015900016, 0.00771372811868787, 0.00772714940831065, 0.00774062285199761, 0.00775413773953915, 0.00776772666722536, 0.00778134679421782, 0.007795050740242, 0.00780877517536283, 0.00782257877290249, 0.00783645454794168, 0.00785035267472267, 0.00786431785672903, 0.00787834171205759, 0.00789240654557943, 0.00790656078606844, 0.00792073551565409, 0.00793498381972313, 0.00794929452240467, 0.00796364340931177, 0.00797804817557335, 0.00799250137060881, 0.00800704210996628, 0.00802161078900099, 0.00803623627871275, 0.00805093441158533, 0.0080656697973609, 0.00808046292513609, 0.00809534452855587, 0.00811021588742733, 0.00812519807368517, 0.00814021565020084, 0.0081552816554904, 0.00817043054848909, 0.00818560551851988, 0.00820086430758238, 0.00821615010499954, 0.00823149736970663, 0.00824691355228424, 0.00826238747686148, 0.00827789213508368, 0.00829347595572472, 0.00830908678472042, 0.00832479540258646, 0.00834051053971052, 0.00835631880909204, 0.0083721587434411, 0.00838808342814445, 0.00840404443442822, 0.00842004641890526, 0.00843614339828491, 0.00845226179808378, 0.00846844166517258, 0.00848468579351902, 0.00850098114460707, 0.00851732958108187, 0.00853375066071749, 0.008550182916224, 0.00856671389192343, 0.00858328305184841, 0.00859990809112787, 0.00861658621579409, 0.00863333232700825, 0.00865012034773827, 0.00866698194295168, 0.00868386402726173, 0.00870084576308727, 0.00871784798800945, 0.00873494055122137, 0.00875206384807825, 0.00876923929899931, 0.00878648273646832, 0.00880374666303396, 0.00882111676037312, 0.00883851200342178, 0.00885595940053463, 0.00887349620461464, 0.00889106001704931, 0.00890868064016104, 0.00892637483775616, 0.00894410535693169, 0.00896189920604229, 0.0089797293767333, 0.0089976480230689, 0.00901562441140413, 0.00903361197561026, 0.00905169826000929, 0.00906980596482754, 0.00908798165619373, 0.00910622533410788, 0.00912450160831213, 0.00914286449551582, 0.00916128698736429, 0.00917970947921276, 0.00919824000447989, 0.00921678822487593, 0.00923542957752943, 0.0092540867626667, 0.00927283428609371, 0.00929162185639143, 0.00931047927588224, 0.00932936184108257, 0.00934832729399204, 0.0093673299998045, 0.00938641279935837, 0.00940550398081541, 0.00942469574511051, 0.00944395549595356, 0.0094632264226675, 0.00948257464915514, 0.00950196944177151, 0.00952142849564552, 0.00954093970358372, 0.00956050306558609, 0.00958011951297522, 0.00959979277104139, 0.0096195237711072, 0.0096393171697855, 0.00965914782136679, 0.00967906694859266, 0.00969900749623775, 0.00971901509910822, 0.00973909813910723, 0.0097592007368803, 0.00977938156574965, 0.00979961548000574, 0.00981987547129393, 0.00984024442732334, 0.00986064039170742, 0.00988108292222023, 0.00990160647779703, 0.0099221533164382, 0.0099427904933691, 0.00996344350278378, 0.00998418498784304, 0.0100049618631601, 0.0100258197635412, 0.0100466962903738, 0.0100676529109478, 0.0100886560976505, 0.0101097384467721, 0.0101308254525065, 0.0101520176976919, 0.010173263028264, 0.0101945316419005, 0.0102158710360527, 0.0102372504770756, 0.0102587258443236, 0.0102802161127329, 0.0103017641231418, 0.0103233959525824, 0.0103450743481517, 0.0103668067604303, 0.0103885848075151, 0.0104104159399867, 0.0104323197156191, 0.010454255156219, 0.0104762678965926, 0.0104983458295465, 0.0105204386636615, 0.0105426358059049, 0.0105648329481483, 0.0105871083214879, 0.0106094684451818, 0.0106318490579724, 0.010654297657311, 0.010676808655262, 0.0106993624940515, 0.0107219945639372, 0.0107446415349841, 0.0107673835009336, 0.0107901515439153, 0.0108129978179932, 0.0108358776196837, 0.01085882820189, 0.0108818272128701, 0.0109049091115594, 0.0109279863536358, 0.0109511781483889, 0.0109743801876903, 0.0109976828098297, 0.0110210170969367, 0.0110444026067853, 0.0110678570345044, 0.0110913636162877, 0.0111148916184902, 0.0111385220661759, 0.0111621972173452, 0.0111859114840627, 0.0112096862867475, 0.0112335216253996, 0.0112574324011803, 0.0112813571467996, 0.0113053610548377, 0.0113294124603271, 0.011353530921042, 0.0113777182996273, 0.0114019112661481, 0.011426187120378, 0.0114505356177688, 0.0114749120548368, 0.0114993555471301, 0.0115238623693585, 0.0115484157577157, 0.0115730492398143, 0.0115976799279451, 0.0116224233061075, 0.0116471815854311, 0.0116720320656896, 0.0116969104856253, 0.011721852235496, 0.011746846139431, 0.0117719070985913, 0.0117970006540418, 0.0118221770972013, 0.0118473907932639, 0.0118726827204227, 0.01189801748842, 0.0119233876466751, 0.0119488462805748, 0.0119743272662163, 0.011999886482954, 0.0120254876092076, 0.0120511464774609, 0.0120768835768104, 0.0121026476845145, 0.0121284676715732, 0.0121543724089861, 0.0121803032234311, 0.0122063076123595, 0.012232331559062, 0.0122584626078606, 0.0122846458107233, 0.0123108327388763, 0.0123371044173837, 0.0123634431511164, 0.0123898247256875, 0.0124162575230002, 0.0124427489936352, 0.0124693140387535, 0.0124959303066134, 0.012522573582828, 0.0125493053346872, 0.0125760585069656, 0.0126029057428241, 0.0126297790557146, 0.0126567212864757, 0.01268370449543, 0.0127107659354806, 0.0127378487959504, 0.0127650322392583, 0.0127922343090177, 0.0128195220604539, 0.0128468200564384, 0.0128742270171642, 0.0129016768187284, 0.0129291526973248, 0.0129567068070173, 0.0129842972382903, 0.0130119565874338, 0.0130396829918027, 0.01306745223701, 0.013095268048346, 0.0131231565028429, 0.0131510877981782, 0.0131790926679969, 0.0132071189582348, 0.0132352383807302, 0.0132633997127414, 0.0132916029542685, 0.0133198909461498, 0.0133482040837407, 0.0133765740320086, 0.0134050035849214, 0.0134334899485111, 0.0134620545431972, 0.0134906619787216, 0.0135193048045039, 0.0135480333119631, 0.0135767860338092, 0.0136056281626225, 0.0136344870552421, 0.0136634334921837, 0.0136924227699637, 0.0137214735150337, 0.0137505577877164, 0.0137797249481082, 0.013808922842145, 0.0138382101431489, 0.0138675030320883, 0.013896900229156, 0.0139263346791267, 0.0139558259397745, 0.013985370285809, 0.0140149611979723, 0.0140446042641997, 0.014074326492846, 0.0141040813177824, 0.0141339171677828, 0.0141637958586216, 0.0141937229782343, 0.0142237180843949, 0.0142537541687489, 0.014283868484199, 0.0143140098080039, 0.0143442125990987, 0.0143744898959994, 0.0144048100337386, 0.0144351804628968, 0.0144656049087644, 0.0144960815086961, 0.0145266456529498, 0.0145572321489453, 0.0145878866314888, 0.0146186035126448, 0.0146493576467037, 0.0146801946684718, 0.0147110372781754, 0.0147419944405556, 0.0147729637101293, 0.014804020524025, 0.0148350987583399, 0.014866266399622, 0.0148974657058716, 0.0149287255480886, 0.01496004126966, 0.0149914287030697, 0.015022836625576, 0.0150543376803398, 0.0150858834385872, 0.0151174636557698, 0.0151491286233068, 0.0151808196678758, 0.0152125684544444, 0.0152444010600448, 0.0152762802317739, 0.0153082115575671, 0.0153401857241988, 0.0153722167015076, 0.0154043324291706, 0.0154364695772529, 0.0154686728492379, 0.0155009347945452, 0.0155332591384649, 0.0155656151473522, 0.0155980437994003, 0.0156305208802223, 0.0156630650162697, 0.0156956575810909, 0.0157283004373312, 0.0157610233873129, 0.0157937780022621, 0.015826603397727, 0.0158594436943531, 0.0158924013376236, 0.0159253589808941, 0.0159583911299706, 0.0159914903342724, 0.0160246416926384, 0.0160578414797783, 0.0160911027342081, 0.0161244068294764, 0.0161577947437763, 0.0161912031471729, 0.016224704682827, 0.0162582285702229, 0.0162918157875538, 0.016325481235981, 0.0163591671735048, 0.0163929220288992, 0.0164267271757126, 0.0164605863392353, 0.0164945293217897, 0.0165285039693117, 0.0165625400841236, 0.0165966413915157, 0.016630781814456, 0.0166649874299765, 0.0166992209851742, 0.0167335420846939, 0.0167679358273745, 0.0168023426085711, 0.0168368052691221, 0.0168713442981243, 0.0169059261679649, 0.0169405750930309, 0.0169752575457096, 0.0170100368559361, 0.01704484783113, 0.0170797016471624, 0.0171146411448717, 0.0171496085822582, 0.0171846561133862, 0.0172197297215462, 0.0172548722475767, 0.0172900725156069, 0.017325334250927, 0.0173606369644403, 0.017395993694663, 0.0174314137548208, 0.0174669064581394, 0.0175024103373289, 0.0175380185246468, 0.0175736770033836, 0.0176093485206366, 0.017645101994276, 0.0176809094846249, 0.0177167635411024, 0.0177527125924826, 0.0177886858582497, 0.0178247019648552, 0.0178607925772667, 0.0178969278931618, 0.0179331339895725, 0.0179693661630154, 0.018005695194006, 0.0180420409888029, 0.018078476190567, 0.0181149374693632, 0.0181514676660299, 0.0181880500167608, 0.0182246938347816, 0.01826136931777, 0.018298139795661, 0.0183349624276161, 0.0183718074113131, 0.018408739939332, 0.0184456948190928, 0.0184827465564013, 0.0185198001563549, 0.0185569357126951, 0.0185941252857447, 0.0186314042657614, 0.0186687037348747, 0.0187060609459877, 0.0187434628605843, 0.0187809523195028, 0.0188184771686792, 0.0188560634851456, 0.0188937038183212, 0.0189313944429159, 0.0189691502600908, 0.0190069358795881, 0.0190447941422462, 0.0190827194601297, 0.0191206708550453, 0.0191580336540937, 0.019194545224309, 0.0192311573773623, 0.0192678868770599, 0.0193047616630793, 0.019341729581356, 0.0193788148462772, 0.0194160249084234, 0.0194533187896013, 0.0194908324629068, 0.0195283573120832, 0.0195660404860973, 0.0196038037538528, 0.0196417272090912, 0.0196797829121351, 0.0197179149836302, 0.0197561644017696, 0.0197945479303598, 0.0198330860584974, 0.0198716782033443, 0.0199103876948357, 0.0199492517858744, 0.0199882201850414, 0.0200273152440786, 0.0200665090233088, 0.0201058108359575, 0.0201452616602182, 0.0201848074793816, 0.0202244818210602, 0.0202642660588026, 0.0203041583299637, 0.0203441642224789, 0.0203843172639608, 0.0204245839267969, 0.0204649493098259, 0.0205054059624672, 0.0205460079014301, 0.0205868016928434, 0.0206276010721922, 0.020668551325798, 0.0207096058875322, 0.0207508485764265, 0.0207921322435141, 0.0208335723727942, 0.0208750758320093, 0.020916759967804, 0.0209585446864367, 0.021000437438488, 0.0210424233227968, 0.0210845675319433, 0.0211268346756697, 0.0211691875010729, 0.0212116539478302, 0.0212542582303286, 0.0212970077991486, 0.0213398225605488, 0.0213827397674322, 0.0214258041232824, 0.0214689746499062, 0.0215122997760773, 0.0215557310730219, 0.021599255502224, 0.0216428991407156, 0.021686652675271, 0.0217305775731802, 0.0217745620757341, 0.0218186862766743, 0.0218629110604525, 0.0219073072075844, 0.0219517443329096, 0.0219963267445564, 0.0220410134643316, 0.0220858491957188, 0.0221308097243309, 0.0221758745610714, 0.0222210418432951, 0.0222663078457117, 0.0223117712885141, 0.0223572738468647, 0.0224029049277306, 0.0224486496299505, 0.0224945303052664, 0.0225405506789684, 0.0225866641849279, 0.0226328689604998, 0.0226792115718126, 0.022725647315383, 0.0227722842246294, 0.0228189639747143, 0.0228657647967339, 0.0229127053171396, 0.0229597594588995, 0.0230069402605295, 0.0230542048811913, 0.0231015849858522, 0.023149099200964, 0.0231967829167843, 0.023244496434927, 0.0232923775911331, 0.0233403239399195, 0.0233884993940592, 0.0234366953372955, 0.0234850160777569, 0.0235334653407335, 0.0235820263624191, 0.0236307699233294, 0.0236795507371426, 0.0237284600734711, 0.0237775016576052, 0.0238266345113516, 0.0238759387284517, 0.0239253286272287, 0.023974834010005, 0.0240244455635548, 0.0240742117166519, 0.0241240933537483, 0.0241740401834249, 0.0242241434752941, 0.0242743175476789, 0.0243247132748365, 0.0243751276284456, 0.0244256835430861, 0.0244763493537903, 0.024527195841074, 0.0245780739933252, 0.0246291067451239, 0.0246802568435669, 0.0247315224260092, 0.0247829221189022, 0.0248343981802464, 0.024886017665267, 0.0249377433210611, 0.0249896049499512, 0.0250415820628405, 0.0250936858355999, 0.0251458510756493, 0.0251981746405363, 0.0252506211400032, 0.0253031849861145, 0.0253558307886124, 0.0254086367785931, 0.0254615675657988, 0.0255145486444235, 0.0255676973611116, 0.0256209839135408, 0.0256743133068085, 0.0257278494536877, 0.0257814321666956, 0.0258351787924767, 0.0258890055119991, 0.0259429849684238, 0.0259970780462027, 0.0260512325912714, 0.0261055659502745, 0.0261599943041801, 0.0262145139276981, 0.0262691844254732, 0.0263239983469248, 0.0263788662850857, 0.0264338701963425, 0.02648900821805, 0.0265442654490471, 0.0265996139496565, 0.0266551226377487, 0.0267107225954533, 0.0267664268612862, 0.0268222354352474, 0.0268782451748848, 0.0269342847168446, 0.0269904844462872, 0.027046786621213, 0.0271031949669123, 0.0271597262471914, 0.0272164046764374, 0.0272731799632311, 0.0273300465196371, 0.0273870695382357, 0.0274441912770271, 0.0275013912469149, 0.0275587737560272, 0.0276162698864937, 0.0276738591492176, 0.0277315136045218, 0.0277893766760826, 0.0278473235666752, 0.0279053952544928, 0.027963550761342, 0.0280218943953514, 0.0280802622437477, 0.0281388163566589, 0.0281974654644728, 0.0282562058418989, 0.0283150859177113, 0.0283740554004908, 0.0284331776201725, 0.0284924227744341, 0.0285517815500498, 0.0286112483590841, 0.0286708287894726, 0.0287305023521185, 0.0287903342396021, 0.0288502499461174, 0.0289102923125029, 0.0289705116301775, 0.0290307831019163, 0.0290911886841059, 0.0291516687721014, 0.029212350025773, 0.0292730834335089, 0.0293339285999537, 0.0293949767947197, 0.0294560752809048, 0.0295172892510891, 0.0295786298811436, 0.0296400748193264, 0.0297016333788633, 0.0297633390873671, 0.0298251919448376, 0.0298871193081141, 0.0299491491168737, 0.0300112869590521, 0.0300735663622618, 0.030135964974761, 0.0301985088735819, 0.0302610956132412, 0.0303238183259964, 0.0303867291659117, 0.030449690297246, 0.0305127892643213, 0.0305759739130735, 0.0306393634527922, 0.030702780932188, 0.0307663269340992, 0.030830055475235, 0.0308938268572092, 0.030957754701376, 0.0310217831283808, 0.0310859214514494, 0.0311501808464527, 0.0312145687639713, 0.0312791019678116, 0.0313437394797802, 0.0314084440469742, 0.0314733125269413, 0.0315382853150368, 0.0316033437848091, 0.0316686108708382, 0.0317338965833187, 0.031799353659153, 0.0318649150431156, 0.0319305807352066, 0.0319963507354259, 0.0320622362196445, 0.0321283079683781, 0.0321944244205952, 0.0322607047855854, 0.0323270857334137, 0.0323935560882092, 0.0324601717293262, 0.0325269065797329, 0.0325937755405903, 0.0326607190072536, 0.0327278189361095, 0.0327949896454811, 0.0328623130917549, 0.0329297371208668, 0.0329972878098488, 0.0330649837851524, 0.0331327207386494, 0.0332006700336933, 0.0332686603069305, 0.0333368182182312, 0.0334050171077251, 0.033473402261734, 0.0335418991744518, 0.0336104929447174, 0.0336792394518852, 0.0337480865418911, 0.0338170193135738, 0.0338860973715782, 0.0339552834630013, 0.0340245924890041, 0.0340939983725548, 0.0341635681688786, 0.0342332050204277, 0.0343029648065567, 0.0343728587031364, 0.0344429016113281, 0.0345129854977131, 0.0345832407474518, 0.03465361520648, 0.0347241088747978, 0.034794706851244, 0.0348653979599476, 0.0349362269043922, 0.035007182508707, 0.0350782498717308, 0.0351494327187538, 0.0352206900715828, 0.035292137414217, 0.0353636778891087, 0.0354353114962578, 0.0355070494115353, 0.0355789698660374, 0.0356509499251842, 0.0357230566442013, 0.0357953310012817, 0.0358676761388779, 0.0359401293098927, 0.0360127054154873, 0.0360854528844357, 0.0361582152545452, 0.0362311713397503, 0.0363042317330837, 0.0363773927092552, 0.0364507026970387, 0.0365240722894669, 0.0365976020693779, 0.03667126968503, 0.0367450416088104, 0.0368189066648483, 0.0368928872048855, 0.0369669944047928, 0.0370412357151508, 0.0371155627071857, 0.0371900275349617, 0.0372646376490593, 0.037339311093092, 0.0374141149222851, 0.0374890491366386, 0.0375641100108624, 0.0376392267644405, 0.0377145111560822, 0.0377899669110775, 0.0378654450178146, 0.0379410907626152, 0.0380168408155441, 0.0380926877260208, 0.0381686724722385, 0.0382447503507137, 0.0383210033178329, 0.0383973307907581, 0.0384737923741341, 0.0385503619909286, 0.0386270321905613, 0.0387038290500641, 0.0387807339429855, 0.0388577952980995, 0.0389349348843098, 0.039012249559164, 0.0390896201133728, 0.0391671322286129, 0.0392447337508202, 0.0393224842846394, 0.0394003540277481, 0.0394782908260822, 0.0395564399659634, 0.0396345965564251, 0.0397129468619823, 0.0397913977503777, 0.0398699268698692, 0.039948608726263, 0.0400273837149143, 0.0401063486933708, 0.0401853583753109, 0.0402645021677017, 0.0403437726199627, 0.0404231324791908, 0.0405026450753212, 0.0405822582542896, 0.04066202044487, 0.0407418645918369, 0.0408218093216419, 0.0409019030630589, 0.0409820899367332, 0.0410623997449875, 0.0411428697407246, 0.0412234105169773, 0.0413040332496166, 0.0413848832249641, 0.0414657481014729, 0.0415467694401741, 0.0416278801858425, 0.0417091958224773, 0.0417905263602734, 0.041872002184391, 0.0419536419212818, 0.0420353747904301, 0.0421171970665455, 0.0421991460025311, 0.0422812141478062, 0.0423634052276611, 0.0424457564949989, 0.0425281636416912, 0.0426107197999954, 0.042693343013525, 0.0427761450409889, 0.0428590476512909, 0.0429420359432697, 0.0430252067744732, 0.0431084260344505, 0.0431917905807495, 0.0432752929627895, 0.0433588735759258, 0.0434425547719002, 0.0435263961553574, 0.0436103716492653, 0.0436944365501404, 0.043778583407402, 0.0438629239797592, 0.0439473353326321, 0.0440318435430527, 0.0441165044903755, 0.0442012809216976, 0.0442861691117287, 0.0443711839616299, 0.0444562882184982, 0.0445415452122688, 0.0446268916130066, 0.0447123683989048, 0.0447979345917702, 0.0448836535215378, 0.0449694916605949, 0.0450554117560387, 0.0451414734125137, 0.0452276691794395, 0.0453139655292034, 0.045400358736515, 0.0454868823289871, 0.0455735176801682, 0.0456602983176708, 0.0457471758127213, 0.0458341762423515, 0.0459212772548199, 0.0460084974765778, 0.0460958555340767, 0.0461832918226719, 0.0462709069252014, 0.046358585357666, 0.0464463904500008, 0.0465343408286572, 0.0466223657131195, 0.0467105396091938, 0.0467988252639771, 0.046887245029211, 0.0469757504761219, 0.0470643751323223, 0.0471531413495541, 0.0472420156002045, 0.0473309941589832, 0.0474201291799545, 0.0475093126296997, 0.0475986562669277, 0.0476881079375744, 0.0477776601910591, 0.0478673875331879, 0.0479571670293808, 0.0480470880866051, 0.0481371283531189, 0.0482272692024708, 0.0483175776898861, 0.0484079420566559, 0.0484984777867794, 0.048589076846838, 0.0486798509955406, 0.0487706996500492, 0.0488616675138474, 0.0489527694880962, 0.0490439906716347, 0.0491353273391724, 0.0492267534136772, 0.0493183508515358, 0.0494100116193295, 0.0495018362998962, 0.0495937205851078, 0.0496857613325119, 0.0497779101133347, 0.0498701669275761, 0.0499625653028488, 0.0500550530850887, 0.0501476675271988, 0.0502404235303402, 0.0503332391381264, 0.0504262372851372, 0.0505193173885345, 0.0506125278770924, 0.05070586130023, 0.0507993027567863, 0.0508928261697292, 0.050986535847187, 0.051080297678709, 0.0511742010712624, 0.0512682162225246, 0.0513623654842377, 0.0514566451311111, 0.0515510067343712, 0.051645502448082, 0.0517401024699211, 0.0518348403275013, 0.051929697394371, 0.0520323105156422, 0.0521426908671856, 0.0522532016038895, 0.0523638613522053, 0.0524745807051659, 0.0525854863226414, 0.0526964589953423, 0.052807591855526, 0.0529188625514507, 0.0530302263796329, 0.0531417652964592, 0.0532533638179302, 0.0533651299774647, 0.0534770041704178, 0.0535889975726604, 0.0537011437118053, 0.0538133680820465, 0.0539257414638996, 0.0540382452309132, 0.0541508905589581, 0.0542636029422283, 0.0543764755129814, 0.0544894561171532, 0.0546025857329369, 0.0547158196568489, 0.0548291988670826, 0.0549426823854446, 0.0550562925636768, 0.0551700294017792, 0.0552839115262032, 0.0553978979587555, 0.0555119886994362, 0.0556262284517288, 0.0557405911386013, 0.0558550618588924, 0.0559696741402149, 0.0560844354331493, 0.0561992861330509, 0.0563142336905003, 0.0564293712377548, 0.0565445944666862, 0.056659922003746, 0.0567754171788692, 0.0568910129368305, 0.0570067428052425, 0.0571225956082344, 0.0572385936975479, 0.0573546774685383, 0.0574708841741085, 0.0575872547924519, 0.0577036961913109, 0.0578203164041042, 0.0579370073974133, 0.0580538883805275, 0.0581708289682865, 0.0582879148423672, 0.0584051497280598, 0.0585224665701389, 0.0586399734020233, 0.0587575174868107, 0.0588752552866936, 0.058993075042963, 0.0591110214591026, 0.0592291131615639, 0.0593473315238953, 0.0594656728208065, 0.0595841035246849, 0.0597027167677879, 0.0598214194178581, 0.0599402599036694, 0.0600592158734798, 0.0601782910525799, 0.0602975152432919, 0.0604168027639389, 0.0605362951755524, 0.0606558360159397, 0.0607755370438099, 0.0608953945338726, 0.0610153265297413, 0.0611353851854801, 0.0612555742263794, 0.0613759122788906, 0.0614963509142399, 0.0616169348359108, 0.0617376193404198, 0.0618584603071213, 0.0619793608784676, 0.0621004439890385, 0.062221635133028, 0.0623429529368877, 0.0624643974006176, 0.0625859498977661, 0.0627076402306557, 0.0628294423222542, 0.0629514083266258, 0.063073456287384, 0.0631956160068512, 0.0633179396390915, 0.0634403675794601, 0.0635629445314407, 0.0636856034398079, 0.0638084262609482, 0.0639313384890556, 0.0640544146299362, 0.0641775950789452, 0.0643008649349213, 0.0644242987036705, 0.0645478367805481, 0.0646715387701988, 0.0647953301668167, 0.0649192482233047, 0.0650433078408241, 0.0651674717664719, 0.0652917549014091, 0.0654161646962166, 0.0655407458543777, 0.0656653940677643, 0.0657901912927628, 0.0659151151776314, 0.0660401582717896, 0.0661653280258179, 0.0662905871868134, 0.0664160177111626, 0.0665415376424789, 0.0666672140359879, 0.0667929947376251, 0.0669189170002937, 0.0670449584722519, 0.0671711042523384, 0.0672973841428757, 0.0674237832427025, 0.0675503313541412, 0.0676769837737083, 0.0678037703037262, 0.0679306536912918, 0.0680577009916306, 0.0681848600506783, 0.0683121010661125, 0.0684395208954811, 0.0685670599341393, 0.0686947032809258, 0.0688224583864212, 0.0689503848552704, 0.0690783858299255, 0.0692065209150314, 0.0693347826600075, 0.0694632008671761, 0.069591723382473, 0.0697203353047371, 0.0698491334915161, 0.0699780136346817, 0.0701070502400398, 0.0702361837029457, 0.0703654140233994, 0.0704948231577873, 0.0706243216991425, 0.0707539841532707, 0.0708837285637856, 0.0710136294364929, 0.0711436122655869, 0.0712737590074539, 0.0714040026068687, 0.0715343728661537, 0.0716649144887924, 0.0717955306172371, 0.0719262734055519, 0.0720571503043175, 0.0721881613135338, 0.0723193138837814, 0.0724505260586739, 0.072581946849823, 0.0727133974432945, 0.0728450268507004, 0.0729767978191376, 0.0731086730957031, 0.0732406452298164, 0.0733727738261223, 0.0735050141811371, 0.073637381196022, 0.0737698748707771, 0.0739024877548218, 0.0740352794528008, 0.0741680860519409, 0.0743011012673378, 0.0744342058897018, 0.074567437171936, 0.0747008100152016, 0.0748343020677567, 0.0749679207801819, 0.0751016363501549, 0.0752355009317398, 0.0753694698214531, 0.0755035877227783, 0.0756378173828125, 0.0757721811532974, 0.0759066790342331, 0.0760412514209747, 0.0761760175228119, 0.0763108357787132, 0.0764458104968071, 0.0765809118747711, 0.0767161771655083, 0.076851487159729, 0.0769869536161423, 0.0771225765347481, 0.0772582814097404, 0.0773941352963448, 0.0775301232933998, 0.077666200697422, 0.0778024345636368, 0.0779387503862381, 0.0780752375721931, 0.0782118067145348, 0.0783485546708107, 0.0784853920340538, 0.0786223560571671, 0.0787594243884087, 0.078896626830101, 0.0790339857339859, 0.079171434044838, 0.0793090090155602, 0.0794467329978943, 0.0795845687389374, 0.0797225385904312, 0.0798606276512146, 0.0799988210201263, 0.0801371335983276, 0.0802755951881409, 0.0804141759872437, 0.0805528834462166, 0.0806917026638985, 0.0808306857943535, 0.0809697285294533, 0.0811089351773262, 0.0812482684850693, 0.0813877061009407, 0.0815273001790047, 0.0816669762134552, 0.0818068012595177, 0.0819467157125473, 0.0820868164300919, 0.082226999104023, 0.082367330789566, 0.0825077742338181, 0.0826482996344566, 0.0827890187501907, 0.0829298123717308, 0.0830707773566246, 0.0832118391990662, 0.0833530575037003, 0.0834943279623985, 0.0836357250809669, 0.0837773457169533, 0.0839190185070038, 0.0840608403086662, 0.084202729165554, 0.0843448266386986, 0.0844869911670685, 0.0846292823553085, 0.0847717225551605, 0.0849142670631409, 0.0850569382309914, 0.085199773311615, 0.0853426903486252, 0.0854857265949249, 0.0856288820505142, 0.0857722237706184, 0.0859156176447868, 0.086059182882309, 0.0862028449773788, 0.0863466411828995, 0.0864905342459679, 0.08663459867239, 0.0867787823081017, 0.0869230702519417, 0.0870674699544907, 0.087212011218071, 0.0873566865921021, 0.0875014662742615, 0.0876463800668716, 0.0877914279699326, 0.0879365652799606, 0.0880818441510201, 0.088227279484272, 0.0883728265762329, 0.088518463075161, 0.0886642634868622, 0.0888101607561111, 0.0889561846852303, 0.0891023427248001, 0.0892486125230789, 0.0893950238823891, 0.0895415619015694, 0.0896881967782974, 0.0898349657654762, 0.0899818912148476, 0.0901288986206055, 0.0902760624885559, 0.0904233306646347, 0.0905707105994225, 0.0907182395458221, 0.0908658728003502, 0.0910136550664902, 0.0911615267395973, 0.0913095995783806, 0.0914577022194862, 0.0916059613227844, 0.0917543768882751, 0.0919028595089912, 0.0920515134930611, 0.0922002866864204, 0.0923492014408112, 0.0924981608986855, 0.0926473066210747, 0.0927966013550758, 0.0929459556937218, 0.0930954962968826, 0.0932451114058495, 0.0933948531746864, 0.0935447439551353, 0.0936947464942932, 0.093844898045063, 0.0939951166510582, 0.0941455215215683, 0.0942960008978844, 0.094446636736393, 0.0945973694324493, 0.0947482660412788, 0.0948992595076561, 0.0950503945350647, 0.0952016040682793, 0.0953529998660088, 0.0955044999718666, 0.0956561043858528, 0.0958078727126122, 0.0959597527980804, 0.0961117297410965, 0.0962638258934021, 0.096416100859642, 0.0965684354305267, 0.0967209190130234, 0.0968735739588737, 0.0970262885093689, 0.0971791371703148, 0.0973321199417114, 0.0974852442741394, 0.0976384803652763, 0.0977918207645416, 0.09794532507658, 0.0980989262461662, 0.0982526615262032, 0.0984065011143684, 0.0985605120658875, 0.0987145900726318, 0.0988688394427299, 0.0990231782197952, 0.0991776511073112, 0.099332258105278, 0.0994869843125343, 0.099641852080822, 0.0997968018054962, 0.0999518856406212, 0.100107133388519, 0.100262470543385, 0.10041793435812, 0.100573532283306, 0.100729264318943, 0.100885070860386, 0.101041041314602, 0.101197153329849, 0.101353377103806, 0.101509712636471, 0.101666174829006, 0.10182274132967, 0.101979464292526, 0.102136306464672, 0.102293275296688, 0.102450355887413, 0.102607555687428, 0.10276485979557, 0.102922350168228, 0.103079907596111, 0.103237621486187, 0.103395484387875, 0.103553421795368, 0.103711470961571, 0.103869676589966, 0.104028016328812, 0.104186460375786, 0.104345068335533, 0.104503750801086, 0.10466255992651, 0.104821510612965, 0.104980610311031, 0.105139791965485, 0.10529912263155, 0.105458550155163, 0.105618126690388, 0.105777814984322, 0.105937607586384, 0.1060975715518, 0.106257639825344, 0.106417827308178, 0.106578126549721, 0.106738552451134, 0.106899134814739, 0.107059814035892, 0.107220642268658, 0.107381567358971, 0.107542648911476, 0.107703819870949, 0.10786509513855, 0.108026549220085, 0.108188085258007, 0.108349785208702, 0.108511596918106, 0.108673498034477, 0.108835570514202, 0.108997747302055, 0.109160058200359, 0.109322465956211, 0.109485045075417, 0.109647676348686, 0.10981048643589, 0.109973423182964, 0.110136479139328, 0.110299646854401, 0.110462948679924, 0.110626354813576, 0.110789880156517, 0.110953561961651, 0.111117377877235, 0.111281260848045, 0.111445300281048, 0.111609451472759, 0.111773751676083, 0.111938156187534, 0.112102717161179, 0.112267389893532, 0.112432159483433, 0.112597048282623, 0.112762100994587, 0.11292726546526, 0.11309252679348, 0.113257981836796, 0.113423459231853, 0.113589122891426, 0.113754890859127, 0.113920830190182, 0.114086821675301, 0.114252991974354, 0.114419274032116, 0.114585645496845, 0.114752180874348, 0.114918828010559, 0.115085616707802, 0.115252509713173, 0.115419536828995, 0.115586675703526, 0.115753911435604, 0.115921333432198, 0.116088829934597, 0.116256505250931, 0.116424262523651, 0.116592146456242, 0.116760157048702, 0.116928309202194, 0.117096558213234, 0.117264963686466, 0.117433473467827, 0.117602102458477, 0.117770835757256, 0.117939740419388, 0.118108756840229, 0.118277885019779, 0.118447169661522, 0.118616528809071, 0.118785992264748, 0.11895564943552, 0.11912540346384, 0.119295291602612, 0.119465261697769, 0.119635418057442, 0.11980564892292, 0.119976006448269, 0.120146505534649, 0.120317161083221, 0.1204878911376, 0.12065876275301, 0.12082976847887, 0.121000893414021, 0.12117213010788, 0.121343486011028, 0.121514990925789, 0.121686615049839, 0.121858328580856, 0.122030220925808, 0.122202180325985, 0.122374318540096, 0.122546568512917, 0.12272223085165, 0.122901439666748, 0.123080715537071, 0.123260080814362, 0.123439460992813, 0.123618885874748, 0.123798370361328, 0.123977817595005, 0.124157376587391, 0.124336957931519, 0.124516613781452, 0.124696284532547, 0.124875999987125, 0.125055760145187, 0.125235542654991, 0.125415399670601, 0.125595271587372, 0.12577523291111, 0.125955209136009, 0.126135215163231, 0.126315250992775, 0.126495361328125, 0.126675486564636, 0.126855701208115, 0.127035930752754, 0.127216190099716, 0.127396494150162, 0.127576872706413, 0.127757266163826, 0.127937704324722, 0.128118216991425, 0.128298729658127, 0.128479287028313, 0.128659889101982, 0.128840565681458, 0.129021272063255, 0.129201993346214, 0.12938280403614, 0.129563599824905, 0.129744470119476, 0.129925385117531, 0.13010635972023, 0.130287364125252, 0.130468383431435, 0.130649462342262, 0.130830571055412, 0.131011739373207, 0.131192967295647, 0.131374225020409, 0.131555527448654, 0.1317368298769, 0.131918236613274, 0.132099658250809, 0.132281109690666, 0.132462650537491, 0.132644191384315, 0.132825776934624, 0.133007407188416, 0.133189097046852, 0.133370816707611, 0.133552581071854, 0.133734419941902, 0.133916229009628, 0.134098142385483, 0.134280070662498, 0.134462058544159, 0.134644076228142, 0.134826138615608, 0.135008245706558, 0.135190397500992, 0.135372593998909, 0.135554805397987, 0.135737106204033, 0.135919436812401, 0.13610178232193, 0.136284187436104, 0.136466637253761, 0.136649131774902, 0.136831685900688, 0.137014240026474, 0.137196868658066, 0.137379497289658, 0.137562215328217, 0.137744963169098, 0.137927755713463, 0.138110607862473, 0.138293489813805, 0.138476371765137, 0.138659343123436, 0.138842344284058, 0.139025405049324, 0.139208495616913, 0.139391630887985, 0.139574781060219, 0.139758005738258, 0.139941275119781, 0.140124589204788, 0.140307933092117, 0.14049132168293, 0.140674725174904, 0.140858203172684, 0.141041725873947, 0.141225293278694, 0.141408905386925, 0.141592532396317, 0.141776204109192, 0.141959935426712, 0.142143711447716, 0.142327532172203, 0.142511397600174, 0.142695307731628, 0.142879232764244, 0.143063217401505, 0.143247246742249, 0.143431305885315, 0.143615439534187, 0.143799588084221, 0.143983781337738, 0.144168004393578, 0.144352316856384, 0.144536629319191, 0.144721016287804, 0.144905418157578, 0.145089849829674, 0.145274341106415, 0.145458877086639, 0.14564348757267, 0.145828127861023, 0.146012797951698, 0.146197497844696, 0.146382242441177, 0.146567046642303, 0.146751880645752, 0.146936759352684, 0.147121697664261, 0.14730666577816, 0.147491648793221, 0.147676691412926, 0.147861793637276, 0.148046940565109, 0.148232117295265, 0.148417368531227, 0.148602589964867, 0.148787915706635, 0.148973271250725, 0.14915868639946, 0.149344101548195, 0.149529576301575, 0.149715095758438, 0.149900659918785, 0.150086253881454, 0.15027192234993, 0.150457620620728, 0.150643348693848, 0.150829121470451, 0.1510149538517, 0.151200801134109, 0.151386708021164, 0.151572674512863, 0.151758670806885, 0.151944667100906, 0.152130737900734, 0.152316868305206, 0.152503043413162, 0.152689248323441, 0.152875512838364, 0.153061762452126, 0.153248116374016, 0.153434485197067, 0.153620913624763, 0.153807371854782, 0.153993889689445, 0.15418042242527, 0.154366999864578, 0.154553636908531, 0.154740318655968, 0.154927030205727, 0.155113816261292, 0.155300587415695, 0.155487418174744, 0.155674323439598, 0.155861273407936, 0.156048253178596, 0.156235247850418, 0.156422317028046, 0.156609386205673, 0.156796559691429, 0.156983748078346, 0.157170966267586, 0.15735824406147, 0.157545566558838, 0.157732903957367, 0.157920315861702, 0.158107772469521, 0.1582952439785, 0.158482789993286, 0.158670365810394, 0.158857941627502, 0.159045621752739, 0.159233331680298, 0.159421056509018, 0.159608855843544, 0.159796684980392, 0.159984529018402, 0.160172417759895, 0.160360395908356, 0.160548403859138, 0.160736426711082, 0.160924524068832, 0.161112636327744, 0.161300808191299, 0.161488994956017, 0.161677286028862, 0.161865562200546, 0.162053927779198, 0.162242278456688, 0.162430703639984, 0.162619188427925, 0.162807703018188, 0.162996262311935, 0.163184851408005, 0.163373470306396, 0.163562163710594, 0.163750857114792, 0.163939639925957, 0.164128467440605, 0.164317294955254, 0.164506182074547, 0.164695143699646, 0.164884105324745, 0.16507314145565, 0.165262207388878, 0.165451318025589, 0.165640458464622, 0.165829658508301, 0.16601887345314, 0.166208148002625, 0.166397482156754, 0.166586846113205, 0.16677625477314, 0.166965678334236, 0.167155191302299, 0.167344719171524, 0.167534291744232, 0.167723923921585, 0.167913600802422, 0.168103277683258, 0.168293014168739, 0.168482810258865, 0.168672665953636, 0.168862521648407, 0.169052466750145, 0.169242396950722, 0.169432416558266, 0.169622451066971, 0.169812560081482, 0.170002669095993, 0.17019285261631, 0.170383095741272, 0.170573309063911, 0.170763611793518, 0.170953959226608, 0.171144366264343, 0.171334788203239, 0.17152526974678, 0.171715795993805, 0.171906337141991, 0.172096952795982, 0.172287598252296, 0.172478273510933, 0.172668993473053, 0.172859787940979, 0.173050597310066, 0.173241451382637, 0.173432350158691, 0.173623293638229, 0.17381426692009, 0.174005299806595, 0.174196392297745, 0.174387484788895, 0.174578651785851, 0.174769818782806, 0.174961090087891, 0.175152376294136, 0.175343707203865, 0.175535053014755, 0.175726488232613, 0.175917908549309, 0.176109418272972, 0.176300972700119, 0.176492527127266, 0.17668417096138, 0.176875859498978, 0.177067548036575, 0.177259311079979, 0.177451103925705, 0.177642941474915, 0.177834823727608, 0.178026750683784, 0.178218707442284, 0.178410708904266, 0.178602784872055, 0.178794875741005, 0.178987011313438, 0.179179191589355, 0.179371401667595, 0.17956368625164, 0.179755985736847, 0.179948344826698, 0.180140733718872, 0.180333167314529, 0.18052564561367, 0.180718168616295, 0.180910751223564, 0.181103333830833, 0.181295990943909, 0.181488707661629, 0.181681424379349, 0.181874200701714, 0.182067006826401, 0.182259887456894, 0.182452797889709, 0.182645753026009, 0.18283873796463, 0.183031752705574, 0.183224841952324, 0.183417975902557, 0.183611124753952, 0.183804333209991, 0.183997571468353, 0.18419086933136, 0.184384196996689, 0.184577584266663, 0.184771001338959, 0.184964448213577, 0.185157969594002, 0.185351490974426, 0.185545101761818, 0.185738742351532, 0.185932397842407, 0.186126112937927, 0.186319872736931, 0.186513662338257, 0.186707526445389, 0.186901420354843, 0.18709534406662, 0.187289297580719, 0.187483325600624, 0.187677398324013, 0.187871485948563, 0.188065633177757, 0.188259810209274, 0.188454061746597, 0.18864831328392, 0.188842639327049, 0.189036995172501, 0.189231410622597, 0.189425840973854, 0.189620316028595, 0.189814835786819, 0.190009400248528, 0.190204039216042, 0.190398678183556, 0.190593376755714, 0.190788134932518, 0.190982893109322, 0.191177725791931, 0.191372603178024, 0.19156751036644, 0.191762447357178, 0.191957473754883, 0.19215252995491, 0.192347601056099, 0.192542716860771, 0.192737892270088, 0.192933097481728, 0.193128332495689, 0.193323627114296, 0.193518996238708, 0.193714365363121, 0.19390980899334, 0.194105267524719, 0.194300785660744, 0.194496333599091, 0.19469191133976, 0.194887563586235, 0.195083245635033, 0.195278957486153, 0.195474743843079, 0.195670530200005, 0.195866391062737, 0.196062281727791, 0.196258217096329, 0.196454212069511, 0.196650221943855, 0.196846276521683, 0.197042390704155, 0.197238519787788, 0.197434708476067, 0.197630971670151, 0.197827249765396, 0.198023557662964, 0.198219925165176, 0.198416322469711, 0.19861276447773, 0.198809266090393, 0.199005797505379, 0.199202373623848, 0.199399009346962, 0.199595674872398, 0.199792370200157, 0.199989125132561, 0.200185909867287, 0.200382754206657, 0.200579628348351, 0.200776517391205, 0.200973480939865, 0.20117050409317, 0.201367542147636, 0.201564624905586, 0.20176175236702, 0.201958924531937, 0.20215617120266, 0.202353417873383, 0.20255072414875, 0.20274806022644, 0.202945455908775, 0.203142896294594, 0.203340366482735, 0.203537866473198, 0.203735440969467, 0.203933045268059, 0.204130679368973, 0.204328373074532, 0.204526081681252, 0.204723879694939, 0.204921662807465, 0.205119550228119, 0.205317437648773, 0.205515384674072, 0.205713346600533, 0.20591139793396, 0.20610947906971, 0.206307575106621, 0.206505745649338, 0.206703960895538, 0.206902176141739, 0.207100450992584, 0.207298770546913, 0.207497164607048, 0.207695558667183, 0.207894027233124, 0.208092525601387, 0.208291068673134, 0.208489641547203, 0.208688288927078, 0.208886936306953, 0.209085643291473, 0.209284380078316, 0.209483206272125, 0.209682032465935, 0.209880918264389, 0.210079848766327, 0.210278809070587, 0.21047779917717, 0.210676863789558, 0.210875988006592, 0.211075127124786, 0.211274281144142, 0.211473524570465, 0.211672767996788, 0.211872085928917, 0.212071433663368, 0.212270841002464, 0.212470263242722, 0.212669730186462, 0.212869271636009, 0.213068827986717, 0.213268458843231, 0.213468104600906, 0.213667795062065, 0.213867530226707, 0.214067310094833, 0.214267119765282, 0.214466989040375, 0.21466688811779, 0.214866831898689, 0.215066835284233, 0.21526688337326, 0.215466931462288, 0.215667068958282, 0.215867236256599, 0.216067418456078, 0.216267690062523, 0.216467961668968, 0.216668292880058, 0.216868653893471, 0.21706910431385, 0.217269539833069, 0.217470064759254, 0.217669263482094, 0.217867121100426, 0.218064934015274, 0.218262687325478, 0.218460395932198, 0.218658030033112, 0.218855619430542, 0.219053134322166, 0.21925063431263, 0.219448029994965, 0.219645395874977, 0.219842717051506, 0.22003997862339, 0.220237150788307, 0.220434308052063, 0.220631390810013, 0.220828399062157, 0.221025392413139, 0.221222281455994, 0.221419155597687, 0.221615955233574, 0.221812710165977, 0.222009405493736, 0.22220604121685, 0.222402632236481, 0.222599163651466, 0.222795620560646, 0.222992047667503, 0.223188385367393, 0.223384708166122, 0.223580956459045, 0.223777145147324, 0.223973304033279, 0.224169373512268, 0.224365398287773, 0.224561363458633, 0.22475728392601, 0.224953129887581, 0.225148946046829, 0.225344687700272, 0.22554038465023, 0.225736007094383, 0.225931599736214, 0.226127102971077, 0.226322576403618, 0.226518005132675, 0.226713359355927, 0.226908639073372, 0.227103903889656, 0.227299094200134, 0.227494224905968, 0.227689310908318, 0.227884337306023, 0.228079289197922, 0.22827422618866, 0.22846907377243, 0.228663861751556, 0.228858605027199, 0.229053318500519, 0.229247957468033, 0.229442521929741, 0.229637056589127, 0.229831486940384, 0.23002590239048, 0.230220288038254, 0.230414554476738, 0.230608806014061, 0.2308030128479, 0.230997145175934, 0.231191202998161, 0.231385245919228, 0.231579169631004, 0.231773108243942, 0.231966957449913, 0.2321607619524, 0.232354491949081, 0.232548177242279, 0.232741802930832, 0.232935383915901, 0.233128905296326, 0.233322367072105, 0.233515784144402, 0.233709126710892, 0.233902424573898, 0.23409566283226, 0.234288856387138, 0.234481960535049, 0.234675049781799, 0.234868064522743, 0.235061049461365, 0.23525395989418, 0.23544679582119, 0.235639616847038, 0.235832318663597, 0.236025005578995, 0.236217647790909, 0.236410215497017, 0.23660272359848, 0.236795201897621, 0.236987590789795, 0.237179949879646, 0.237372249364853, 0.237564489245415, 0.237756669521332, 0.237948790192604, 0.238140866160393, 0.238332897424698, 0.238524824380875, 0.238716751337051, 0.238908588886261, 0.239100396633148, 0.239292100071907, 0.239483803510666, 0.23967544734478, 0.239867016673088, 0.24005851149559, 0.240249961614609, 0.240441381931305, 0.240632712841034, 0.240824028849602, 0.241015240550041, 0.241206437349319, 0.241397559642792, 0.24158863723278, 0.241779625415802, 0.241970598697662, 0.242161497473717, 0.242352336645126, 0.242543131113052, 0.242733865976334, 0.24292454123497, 0.243115171790123, 0.24330572783947, 0.243496254086494, 0.243686690926552, 0.243877097964287, 0.244067460298538, 0.244257748126984, 0.244447961449623, 0.244638159871101, 0.244828268885612, 0.24501833319664, 0.245208352804184, 0.245398283004761, 0.245588228106499, 0.245778024196625, 0.245967835187912, 0.246157571673393, 0.24634724855423, 0.246536865830421, 0.246726408600807, 0.246915936470032, 0.24710538983345, 0.247294783592224, 0.247484117746353, 0.24767342209816, 0.24786265194416, 0.248051822185516, 0.248240932822227, 0.248430013656616, 0.248619019985199, 0.248807951807976, 0.24899685382843, 0.249185711145401, 0.249374493956566, 0.249563202261925, 0.249751880764961, 0.249940499663353, 0.250129073858261, 0.250317573547363, 0.250506043434143, 0.250694423913956, 0.250882774591446, 0.251071035861969, 0.25125926733017, 0.251447439193726, 0.251635551452637, 0.251823633909225, 0.252011626958847, 0.252199560403824, 0.252387493848801, 0.252575308084488, 0.252763092517853, 0.252950817346573, 0.253138482570648, 0.253326117992401, 0.253513664007187, 0.25370118021965, 0.253888607025146, 0.254076033830643, 0.254263341426849, 0.254450649023056, 0.254637867212296, 0.25482502579689, 0.255012154579163, 0.25519922375679, 0.255386203527451, 0.255573153495789, 0.255760043859482, 0.25594687461853, 0.256133675575256, 0.256320416927338, 0.256507068872452, 0.256693661212921, 0.256880223751068, 0.25706672668457, 0.257253170013428, 0.25743955373764, 0.257625907659531, 0.257812172174454, 0.257998406887054, 0.25818458199501, 0.258370667695999, 0.258556723594666, 0.25874274969101, 0.258928686380386, 0.259114563465118, 0.259300410747528, 0.259486168622971, 0.259671896696091, 0.259857565164566, 0.260043174028397, 0.260228723287582, 0.260414242744446, 0.260599672794342, 0.260785073041916, 0.260970413684845, 0.261155664920807, 0.261340886354446, 0.261526048183441, 0.261711180210114, 0.261896222829819, 0.262081205844879, 0.262266159057617, 0.26245105266571, 0.262635886669159, 0.26282063126564, 0.263005375862122, 0.263190060853958, 0.263374626636505, 0.263559192419052, 0.263743698596954, 0.263928115367889, 0.264112502336502, 0.264296859502792, 0.264481097459793, 0.264665335416794, 0.264849483966827, 0.265033602714539, 0.265217661857605, 0.265401661396027, 0.265585601329803, 0.265769451856613, 0.265953302383423, 0.266137093305588, 0.266320794820786, 0.266504466533661, 0.266688048839569, 0.266871601343155, 0.267055094242096, 0.267238557338715, 0.267421931028366, 0.267605245113373, 0.267788529396057, 0.267971754074097, 0.268154889345169, 0.268337994813919, 0.268521040678024, 0.268704026937485, 0.268886983394623, 0.269069850444794, 0.269252687692642, 0.269435465335846, 0.269618153572083, 0.269800812005997, 0.269983410835266, 0.270166009664536, 0.270348459482193, 0.27053090929985, 0.270713299512863, 0.270895600318909, 0.271077871322632, 0.271260112524033, 0.271442264318466, 0.271624356508255, 0.271806418895721, 0.271988391876221, 0.272170305252075, 0.272352188825607, 0.272534012794495, 0.272715777158737, 0.272897511720657, 0.27307915687561, 0.273260772228241, 0.273442298173904, 0.273623794317245, 0.273805230855942, 0.273986607789993, 0.2741679251194, 0.274349182844162, 0.274530380964279, 0.274711549282074, 0.274892657995224, 0.275073707103729, 0.275254666805267, 0.275435626506805, 0.275616496801376, 0.275797307491302, 0.275978088378906, 0.276158779859543, 0.276339441537857, 0.276520043611526, 0.276700586080551, 0.276881068944931, 0.277061522006989, 0.277241855859756, 0.277422189712524, 0.277602463960648, 0.277782648801804, 0.277962803840637, 0.278142929077148, 0.27832293510437, 0.278502941131592, 0.278682857751846, 0.278862744569778, 0.279042571783066, 0.279222309589386, 0.279402047395706, 0.279581665992737, 0.279761284589767, 0.279940813779831, 0.28012028336525, 0.280299723148346, 0.280479073524475, 0.280658423900604, 0.280837684869766, 0.281016886234283, 0.281196027994156, 0.281375110149384, 0.281554162502289, 0.281733125448227, 0.281912058591843, 0.282090932130814, 0.28226974606514, 0.282448500394821, 0.282627195119858, 0.282805860042572, 0.282984465360641, 0.283162981271744, 0.283341467380524, 0.283519893884659, 0.283698260784149, 0.283876568078995, 0.284054845571518, 0.284233063459396, 0.284411191940308, 0.284589260816574, 0.284767329692841, 0.28494530916214, 0.285123229026794, 0.285301089286804, 0.285478919744492, 0.285656660795212, 0.285834342241287, 0.286012023687363, 0.286189585924149, 0.286367148160934, 0.286544620990753, 0.28672206401825, 0.286899387836456, 0.287076741456985, 0.287253946065903, 0.28743115067482, 0.287608295679092, 0.28778538107872, 0.287962436676025, 0.288139432668686, 0.288316369056702, 0.288493186235428, 0.288670033216476, 0.288846760988235, 0.289023458957672, 0.289200097322464, 0.289376705884933, 0.289553225040436, 0.289729684591293, 0.289906144142151, 0.290082484483719, 0.290258795022964, 0.290435045957565, 0.290611267089844, 0.290787369012833, 0.290963470935822, 0.291139483451843, 0.291315495967865, 0.291491389274597, 0.291667252779007, 0.291843086481094, 0.292018830776215, 0.29219451546669, 0.292370170354843, 0.292545765638351, 0.292721301317215, 0.292896747589111, 0.293072164058685, 0.293247520923615, 0.293422818183899, 0.293598085641861, 0.293773293495178, 0.293948441743851, 0.294123500585556, 0.294298529624939, 0.294473499059677, 0.294648408889771, 0.294823288917542, 0.294998079538345, 0.295172840356827, 0.295347541570663, 0.295522183179855, 0.295696765184402, 0.295871287584305, 0.296045750379562, 0.296220153570175, 0.296394526958466, 0.296568810939789, 0.29674306511879, 0.296917289495468, 0.297091394662857, 0.297265470027924, 0.297439515590668, 0.297613471746445, 0.297787368297577, 0.297961264848709, 0.298135012388229, 0.298308789730072, 0.298482477664948, 0.298656105995178, 0.298829734325409, 0.299003213644028, 0.299176722764969, 0.299350142478943, 0.29952347278595, 0.299696773290634, 0.299869984388351, 0.300043225288391, 0.300216376781464, 0.300389409065247, 0.300562471151352, 0.300735414028168, 0.300908327102661, 0.30108118057251, 0.301254004240036, 0.301426708698273, 0.301599413156509, 0.301772028207779, 0.301944643259048, 0.302117139101028, 0.302289605140686, 0.302462011575699, 0.302634358406067, 0.30280664563179, 0.302978903055191, 0.303151100873947, 0.303323239088058, 0.303495317697525, 0.303667306900024, 0.303839296102524, 0.304011195898056, 0.304183065891266, 0.304354846477509, 0.304526597261429, 0.304698258638382, 0.304869920015335, 0.305041491985321, 0.30521297454834, 0.305384457111359, 0.305555880069733, 0.305727243423462, 0.305898517370224, 0.306069761514664, 0.306240946054459, 0.306412070989609, 0.306583136320114, 0.306754171848297, 0.306925117969513, 0.307096034288406, 0.307266891002655, 0.307437688112259, 0.307608425617218, 0.307779133319855, 0.307949751615524, 0.308120280504227, 0.308290809392929, 0.308461248874664, 0.308631718158722, 0.308802008628845, 0.308972328901291, 0.309142589569092, 0.309312760829926, 0.309482872486115, 0.309655725955963, 0.309831142425537, 0.310006409883499, 0.310181498527527, 0.310356438159943, 0.310531169176102, 0.310705810785294, 0.310880243778229, 0.311054527759552, 0.311228603124619, 0.311402559280396, 0.311576336622238, 0.311749935150146, 0.311923384666443, 0.312096625566483, 0.312269747257233, 0.312442719936371, 0.312615483999252, 0.312788099050522, 0.312960535287857, 0.313132852315903, 0.313304960727692, 0.313476920127869, 0.313648670911789, 0.313820332288742, 0.313991755247116, 0.314163058996201, 0.314334183931351, 0.314505130052567, 0.31467592716217, 0.31484654545784, 0.315016984939575, 0.315187305212021, 0.31535741686821, 0.315527379512787, 0.315697193145752, 0.31586679816246, 0.316036283969879, 0.316205620765686, 0.316374719142914, 0.31654366850853, 0.316712498664856, 0.316881120204926, 0.317049622535706, 0.317217916250229, 0.31738606095314, 0.317553997039795, 0.31772181391716, 0.317889422178268, 0.318056970834732, 0.318224251270294, 0.318391382694244, 0.318558394908905, 0.318725198507309, 0.318891853094101, 0.319058328866959, 0.319224655628204, 0.319390773773193, 0.319556772708893, 0.31972262263298, 0.319888293743134, 0.320053726434708, 0.320219129323959, 0.320384234189987, 0.320549249649048, 0.320714056491852, 0.320878714323044, 0.321043223142624, 0.32120755314827, 0.321371734142303, 0.321535706520081, 0.321699529886246, 0.321863204240799, 0.322026699781418, 0.322190076112747, 0.322353214025497, 0.322516232728958, 0.322679042816162, 0.322841733694077, 0.323004275560379, 0.323166579008102, 0.323328763246536, 0.323490768671036, 0.323652625083923, 0.323814302682877, 0.323975831270218, 0.324137151241302, 0.324298352003098, 0.324459344148636, 0.324620217084885, 0.324780881404877, 0.324941396713257, 0.325101763010025, 0.325261950492859, 0.325421988964081, 0.325581818819046, 0.325741529464722, 0.325901031494141, 0.32606041431427, 0.326219618320465, 0.326378643512726, 0.326537519693375, 0.326696217060089, 0.326854735612869, 0.327013045549393, 0.327171266078949, 0.327329307794571, 0.327487170696259, 0.327644914388657, 0.327802419662476, 0.327959805727005, 0.3281170129776, 0.328274041414261, 0.328430891036987, 0.328587651252747, 0.328744173049927, 0.328900575637817, 0.329056769609451, 0.329212814569473, 0.329368680715561, 0.329524397850037, 0.329679995775223, 0.329835325479507, 0.329990565776825, 0.330145597457886, 0.330300509929657, 0.330455213785172, 0.330609798431396, 0.330764174461365, 0.330918401479721, 0.331072419881821, 0.331226319074631, 0.331380099058151, 0.331533670425415, 0.3316870033741, 0.33184027671814, 0.3319933116436, 0.332146197557449, 0.332298964262009, 0.332451492547989, 0.33260390162468, 0.332756161689758, 0.332908242940903, 0.333060145378113, 0.333211869001389, 0.333363473415375, 0.333514869213104, 0.333666115999222, 0.333817183971405, 0.333968073129654, 0.334118843078613, 0.334269404411316, 0.334419816732407, 0.334570080041885, 0.334720134735107, 0.334870100021362, 0.335019797086716, 0.33516937494278, 0.335318803787231, 0.335468083620071, 0.335617184638977, 0.335766077041626, 0.335914850234985, 0.33606344461441, 0.336211860179901, 0.336360156536102, 0.336508214473724, 0.336656123399734, 0.336803913116455, 0.336951494216919, 0.337098956108093, 0.337246179580688, 0.337393343448639, 0.337540239095688, 0.337687015533447, 0.337833613157272, 0.337980031967163, 0.338126331567764, 0.338272392749786, 0.338418394327164, 0.33856412768364, 0.338709771633148, 0.3388552069664, 0.339000463485718, 0.339145600795746, 0.339290529489517, 0.339435309171677, 0.339579939842224, 0.339724361896515, 0.339868664741516, 0.340012758970261, 0.340156733989716, 0.340300530195236, 0.3404441177845, 0.340587586164474, 0.340730875730515, 0.340874016284943, 0.341016948223114, 0.341159790754318, 0.341302394866943, 0.341444879770279, 0.341587156057358, 0.341729283332825, 0.341871231794357, 0.342013031244278, 0.342154681682587, 0.342296153306961, 0.342437446117401, 0.342578560113907, 0.342719554901123, 0.342860370874405, 0.343001008033752, 0.343141466379166, 0.343281775712967, 0.343421936035156, 0.343561887741089, 0.34370169043541, 0.343841373920441, 0.343980818986893, 0.344120144844055, 0.344259291887283, 0.344398260116577, 0.344537079334259, 0.344675749540329, 0.344814211130142, 0.344952523708344, 0.345090717077255, 0.345228672027588, 0.345366507768631, 0.34550416469574, 0.345641672611237, 0.345779001712799, 0.345916152000427, 0.346053153276443, 0.346189975738525, 0.346326649188995, 0.346463114023209, 0.34659942984581, 0.346735626459122, 0.346871644258499, 0.34700745344162, 0.347143143415451, 0.347278654575348, 0.347413957118988, 0.347549140453339, 0.347684174776077, 0.347819000482559, 0.347953647375107, 0.348088145256042, 0.348222523927689, 0.348356693983078, 0.348490715026855, 0.348624587059021, 0.34875825047493, 0.348891764879227, 0.349025100469589, 0.34915828704834, 0.349291294813156, 0.34942415356636, 0.349556803703308, 0.349689364433289, 0.349821716547012, 0.349953919649124, 0.350085914134979, 0.350217789411545, 0.350349485874176, 0.350481003522873, 0.35061240196228, 0.350743561983109, 0.350874602794647, 0.351005464792252, 0.351136147975922, 0.351266711950302, 0.351397067308426, 0.351527273654938, 0.351657301187515, 0.351787179708481, 0.351916909217834, 0.352046400308609, 0.352175772190094, 0.352305024862289, 0.352434039115906, 0.352562934160233, 0.352691650390625, 0.352820187807083, 0.352948576211929, 0.353076756000519, 0.353204816579819, 0.353332728147507, 0.353460401296616, 0.353587955236435, 0.353715360164642, 0.353842586278915, 0.353969633579254, 0.354096531867981, 0.354223221540451, 0.354349792003632, 0.354476183652878, 0.35460239648819, 0.35472846031189, 0.354854375123978, 0.354980081319809, 0.355105638504028, 0.355231046676636, 0.355356305837631, 0.35548135638237, 0.355606257915497, 0.355730980634689, 0.35585555434227, 0.355979949235916, 0.35610419511795, 0.35622826218605, 0.356352180242538, 0.356475949287415, 0.356599509716034, 0.356722891330719, 0.356846153736115, 0.356969237327576, 0.357092142105103, 0.357214897871017, 0.357337445020676, 0.357459902763367, 0.357582151889801, 0.357704252004623, 0.357826113700867, 0.357947885990143, 0.358069509267807, 0.358190894126892, 0.358312159776688, 0.358433246612549, 0.358554154634476, 0.358674913644791, 0.358795553445816, 0.358915954828262, 0.359036237001419, 0.359156310558319, 0.359276235103607, 0.359396010637283, 0.359515577554703, 0.359635025262833, 0.359754294157028, 0.359873384237289, 0.359992355108261, 0.360111117362976, 0.360229730606079, 0.360348165035248, 0.360466420650482, 0.360584527254105, 0.360702455043793, 0.360820263624191, 0.360937893390656, 0.361055314540863, 0.361172586679459, 0.361289709806442, 0.361406683921814, 0.361523419618607, 0.36164003610611, 0.361756503582001, 0.361872762441635, 0.36198890209198, 0.362104862928391, 0.362220615148544, 0.362336277961731, 0.362451732158661, 0.362567067146301, 0.362682163715363, 0.362797111272812, 0.362911880016327, 0.363026529550552, 0.363140970468521, 0.3632552921772, 0.363369435071945, 0.363483399152756, 0.363597184419632, 0.363710820674896, 0.363824337720871, 0.363937616348267, 0.364050716161728, 0.3641636967659, 0.364276528358459, 0.364389181137085, 0.364501625299454, 0.364613950252533, 0.364726096391678, 0.364838063716888, 0.364949911832809, 0.365061521530151, 0.365172982215881, 0.365284323692322, 0.365395456552505, 0.3655064702034, 0.365617245435715, 0.365727961063385, 0.365838408470154, 0.365948736667633, 0.366058886051178, 0.366168886423111, 0.366278737783432, 0.366388380527496, 0.366497874259949, 0.366607189178467, 0.366716355085373, 0.366825342178345, 0.366934180259705, 0.367042809724808, 0.367151349782944, 0.367259681224823, 0.367367833852768, 0.367475867271423, 0.367583692073822, 0.367691338062286, 0.367798864841461, 0.367906212806702, 0.368013352155685, 0.36812037229538, 0.368227243423462, 0.368333905935287, 0.368440389633179, 0.368546724319458, 0.368652939796448, 0.368758916854858, 0.368864804506302, 0.368970483541489, 0.369075983762741, 0.369181334972382, 0.369286566972733, 0.369391530752182, 0.369496405124664, 0.369601100683212, 0.369705617427826, 0.369809985160828, 0.369914174079895, 0.370018184185028, 0.370122045278549, 0.370225757360458, 0.370329290628433, 0.370432615280151, 0.370535850524902, 0.370638877153397, 0.370741724967957, 0.370844453573227, 0.370946973562241, 0.371049344539642, 0.37115153670311, 0.371253579854965, 0.371355473995209, 0.371457159519196, 0.371558725833893, 0.371660083532333, 0.371761292219162, 0.371862351894379, 0.371963232755661, 0.372063905000687, 0.372164487838745, 0.372264862060547, 0.372365087270737, 0.37246510386467, 0.372564971446991, 0.372664749622345, 0.372764259576797, 0.37286365032196, 0.372962892055511, 0.373061925172806, 0.373160839080811, 0.373259544372559, 0.373358100652695, 0.373456507921219, 0.373554766178131, 0.373652786016464, 0.373750686645508, 0.373848438262939, 0.373945981264114, 0.374043375253677, 0.374140620231628, 0.374237716197968, 0.374334573745728, 0.37443134188652, 0.374527901411057, 0.374624311923981, 0.374720543622971, 0.374816626310349, 0.374912559986115, 0.375008285045624, 0.375103831291199, 0.375199258327484, 0.375294476747513, 0.375389575958252, 0.375484496355057, 0.375579208135605, 0.375673830509186, 0.37576824426651, 0.3758624792099, 0.375956594944, 0.376050502061844, 0.376144260168076, 0.376237839460373, 0.376331269741058, 0.376424491405487, 0.376517593860626, 0.376610547304153, 0.376699864864349, 0.376785457134247, 0.37687075138092, 0.376955777406693, 0.377040565013885, 0.377125084400177, 0.377209335565567, 0.377293318510056, 0.377376943826675, 0.377460390329361, 0.3775435090065, 0.37762638926506, 0.377709001302719, 0.377791345119476, 0.377873420715332, 0.377955228090286, 0.378036737442017, 0.37811803817749, 0.378198981285095, 0.378279715776443, 0.37836018204689, 0.378440350294113, 0.378520280122757, 0.378599882125854, 0.378679275512695, 0.378758370876312, 0.37883722782135, 0.378915786743164, 0.378994077444077, 0.379072070121765, 0.379149794578552, 0.379227310419083, 0.379304528236389, 0.379381477832794, 0.379458099603653, 0.379534512758255, 0.379610627889633, 0.379686504602432, 0.379762083292007, 0.379837423563004, 0.379912436008453, 0.379987239837646, 0.380061715841293, 0.380135953426361, 0.380209922790527, 0.380283653736115, 0.380357086658478, 0.38043025135994, 0.3805031478405, 0.380575776100159, 0.380648046731949, 0.380720138549805, 0.380791962146759, 0.38086348772049, 0.380934774875641, 0.381005764007568, 0.381076514720917, 0.381146967411041, 0.381217122077942, 0.381287008523941, 0.381356716156006, 0.381426066160202, 0.381495177745819, 0.381564021110535, 0.381632566452026, 0.381700873374939, 0.381768882274628, 0.381836593151093, 0.381904095411301, 0.38197135925293, 0.382038295269012, 0.382104933261871, 0.382171362638474, 0.382237493991852, 0.382303357124329, 0.382368952035904, 0.3824343085289, 0.382499366998672, 0.382564097642899, 0.382628619670868, 0.382692873477936, 0.382756859064102, 0.382820546627045, 0.382883965969086, 0.38294717669487, 0.383010059595108, 0.383072644472122, 0.38313502073288, 0.383197098970413, 0.383258908987045, 0.383320450782776, 0.383381724357605, 0.383442729711533, 0.383503466844559, 0.383563935756683, 0.383624106645584, 0.383684068918228, 0.383743673563004, 0.383803069591522, 0.383862167596817, 0.383921027183533, 0.383979588747025, 0.38403794169426, 0.384095937013626, 0.384153664112091, 0.384211212396622, 0.384268432855606, 0.384325355291367, 0.384382039308548, 0.384438425302505, 0.384494602680206, 0.384550452232361, 0.384606063365936, 0.384661346673965, 0.38471645116806, 0.384771198034286, 0.384825736284256, 0.384880006313324, 0.384933948516846, 0.384987652301788, 0.385041087865829, 0.385094285011292, 0.385147213935852, 0.385199785232544, 0.385252177715302, 0.385304272174835, 0.385356098413467, 0.385407626628876, 0.385458916425705, 0.385509938001633, 0.385560661554337, 0.385611116886139, 0.385661333799362, 0.385711252689362, 0.385760903358459, 0.385810315608978, 0.385859429836273, 0.385908275842667, 0.385956853628159, 0.386005163192749, 0.386053204536438, 0.386100947856903, 0.386148452758789, 0.386195689439774, 0.386242628097534, 0.386289298534393, 0.386335730552673, 0.386381864547729, 0.386427730321884, 0.386473417282104, 0.386518746614456, 0.386563777923584, 0.386608511209488, 0.386653065681458, 0.386697322130203, 0.38674134016037, 0.386785060167313, 0.386828482151031, 0.386871665716171, 0.386914551258087, 0.386957198381424, 0.386999547481537, 0.387041687965393, 0.387083470821381, 0.387125074863434, 0.387166291475296, 0.387207329273224, 0.387248069047928, 0.38728854060173, 0.387328773736954, 0.387368679046631, 0.387408345937729, 0.387447744607925, 0.387486845254898, 0.387525767087936, 0.387564301490784, 0.387602657079697, 0.387640684843063, 0.387678444385529, 0.387715935707092, 0.387753158807755, 0.387790113687515, 0.387826830148697, 0.387863218784332, 0.387899428606033, 0.387935280799866, 0.387970894575119, 0.388006240129471, 0.388041287660599, 0.388076096773148, 0.388110607862473, 0.388144880533218, 0.388178884983063, 0.388212621212006, 0.388246059417725, 0.388279229402542, 0.388312131166458, 0.388344794511795, 0.38837718963623, 0.388409286737442, 0.38844108581543, 0.388472676277161, 0.388503938913345, 0.388534963130951, 0.388565719127655, 0.388596206903458, 0.388626426458359, 0.388656347990036, 0.388686001300812, 0.388715386390686, 0.388744562864304, 0.388773441314697, 0.388802021741867, 0.388830304145813, 0.38885834813118, 0.388886123895645, 0.388913661241531, 0.388940900564194, 0.388967871665955, 0.388994544744492, 0.389021009206772, 0.389047116041183, 0.389073044061661, 0.389098644256592, 0.389124006032944, 0.389149069786072, 0.389173924922943, 0.389198422431946, 0.389222681522369, 0.389246672391891, 0.389270424842834, 0.389293879270554, 0.389317035675049, 0.389339983463287, 0.38936260342598, 0.389384984970093, 0.389407098293304, 0.389428943395615, 0.389450490474701, 0.389471828937531, 0.389492839574814, 0.389513611793518, 0.389534085988998, 0.389554262161255, 0.389574229717255, 0.389593929052353, 0.389613330364227, 0.389632433652878, 0.389651298522949, 0.389669895172119, 0.38968825340271, 0.389706283807755, 0.389724105596542, 0.389741599559784, 0.389758825302124, 0.389775782823563, 0.389792501926422, 0.38980895280838, 0.389825105667114, 0.389840990304947, 0.3898566365242, 0.389871954917908, 0.389887094497681, 0.389901846647263, 0.389916449785233, 0.389930695295334, 0.389944702386856, 0.389958411455154, 0.389971882104874, 0.389985084533691, 0.389997988939285, 0.3900106549263, 0.390023052692413, 0.390035152435303, 0.390046983957291, 0.390058547258377, 0.390069872140884, 0.39008092880249, 0.39009165763855, 0.390102177858353, 0.390112370252609, 0.390122294425964, 0.390132039785385, 0.390141427516937, 0.39015057682991, 0.390159398317337, 0.390168040990829, 0.390176385641098, 0.390184432268143, 0.390192180871964, 0.390199720859528, 0.39020699262619, 0.390213966369629, 0.390220671892166, 0.390227109193802, 0.390233308076859, 0.390239179134369, 0.3902448117733, 0.39025017619133, 0.390255302190781, 0.39026004076004, 0.39026466012001, 0.390268892049789, 0.390272915363312, 0.390276670455933, 0.39028012752533, 0.39028337597847, 0.390286266803741, 0.390288889408112, 0.390291333198547, 0.390293419361115, 0.390295296907425, 0.390296876430511, 0.390298157930374, 0.39029923081398, 0.39029997587204, 0.390300452709198, 0.390300691127777, 0.390300661325455, 0.390300303697586, 0.390299767255783, 0.390298902988434, 0.390297740697861, 0.390296399593353, 0.390294700860977, 0.390292823314667, 0.390290588140488, 0.390288144350052, 0.390285402536392, 0.390282362699509, 0.390279114246368, 0.390275537967682, 0.390271663665771, 0.390267610549927, 0.390263229608536, 0.390258640050888, 0.390253692865372, 0.390248507261276, 0.390243083238602, 0.390237361192703, 0.390231370925903, 0.390225112438202, 0.390218645334244, 0.390211820602417, 0.390204757452011, 0.390197426080704, 0.390189796686172, 0.390181958675385, 0.39017379283905, 0.390165358781815, 0.390156686306, 0.390147715806961, 0.390138506889343, 0.390128999948502, 0.390119224786758, 0.390109181404114, 0.39009889960289, 0.390088319778442, 0.390077471733093, 0.390066355466843, 0.390054941177368, 0.390043318271637, 0.390031367540359, 0.390019178390503, 0.390006721019745, 0.389993995428085, 0.389980971813202, 0.389967709779739, 0.389954149723053, 0.389940321445465, 0.389926254749298, 0.389911890029907, 0.389897227287292, 0.389882326126099, 0.389867216348648, 0.389851719141006, 0.389836043119431, 0.389820039272308, 0.389803826808929, 0.389787286520004, 0.389770537614822, 0.389753431081772, 0.389736145734787, 0.389718502759933, 0.389700651168823, 0.389682501554489, 0.389664083719254, 0.389645397663116, 0.389626443386078, 0.38960725069046, 0.389587759971619, 0.389567971229553, 0.389547973871231, 0.389527648687363, 0.389507085084915, 0.389486253261566, 0.389465153217316, 0.389443755149841, 0.389422118663788, 0.38940018415451, 0.389378011226654, 0.389355540275574, 0.389332801103592, 0.389309853315353, 0.389286547899246, 0.38926300406456, 0.389239192008972, 0.389215052127838, 0.38919073343277, 0.3891661465168, 0.389141231775284, 0.389116078615189, 0.38909062743187, 0.389064937829971, 0.389038980007172, 0.389012724161148, 0.388986200094223, 0.388959407806396, 0.388932377099991, 0.388905048370361, 0.388877481222153, 0.388849556446075, 0.388821452856064, 0.388793021440506, 0.388764381408691, 0.388735473155975, 0.388706207275391, 0.388676762580872, 0.388646960258484, 0.388616979122162, 0.388586670160294, 0.388556092977524, 0.38852521777153, 0.38849413394928, 0.38846281170845, 0.38843110203743, 0.388399213552475, 0.388366997241974, 0.388334572315216, 0.388301879167557, 0.388268828392029, 0.388235598802567, 0.38820207118988, 0.38816824555397, 0.388134151697159, 0.388099819421768, 0.388065218925476, 0.38803032040596, 0.387995153665543, 0.387959718704224, 0.387924075126648, 0.387888073921204, 0.387851804494858, 0.387815326452255, 0.387778580188751, 0.387741535902023, 0.387704193592072, 0.387666583061218, 0.387628763914108, 0.387590616941452, 0.387552201747894, 0.387513548135757, 0.387474626302719, 0.387435406446457, 0.387395948171616, 0.38735619187355, 0.387316167354584, 0.387275874614716, 0.387235343456268, 0.387194514274597, 0.387153387069702, 0.38711205124855, 0.38707035779953, 0.387028455734253, 0.386986285448074, 0.386943817138672, 0.38690111041069, 0.38685816526413, 0.386814892292023, 0.386771351099014, 0.386727571487427, 0.386683523654938, 0.38663911819458, 0.386594533920288, 0.38654962182045, 0.386504471302032, 0.386459082365036, 0.386413335800171, 0.386367410421371, 0.386321187019348, 0.386274695396423, 0.386227905750275, 0.386180877685547, 0.386133581399918, 0.386085957288742, 0.38603812456131, 0.385989993810654, 0.385941654443741, 0.385892957448959, 0.385844022035599, 0.38578337430954, 0.385710746049881, 0.385637909173965, 0.385564804077148, 0.385491520166397, 0.385417908430099, 0.3853440284729, 0.385269910097122, 0.385195583105087, 0.385120958089828, 0.385046094655991, 0.384970963001251, 0.384895592927933, 0.384819954633713, 0.384744107723236, 0.384667962789536, 0.384591579437256, 0.384514898061752, 0.384438008069992, 0.38436084985733, 0.384283423423767, 0.384205788373947, 0.384127855300903, 0.384049654006958, 0.383971244096756, 0.38389253616333, 0.383813619613647, 0.383734434843063, 0.383654981851578, 0.383575290441513, 0.383495330810547, 0.383415102958679, 0.383334636688232, 0.383253902196884, 0.383172929286957, 0.38309171795845, 0.383010238409042, 0.382928490638733, 0.382846504449844, 0.382764250040054, 0.382681757211685, 0.382598996162415, 0.382515996694565, 0.382432729005814, 0.382349252700806, 0.382265418767929, 0.382181435823441, 0.382097154855728, 0.382012605667114, 0.381927818059921, 0.381842762231827, 0.381757467985153, 0.381671905517578, 0.381586104631424, 0.381500035524368, 0.381413698196411, 0.381327152252197, 0.381240338087082, 0.381153255701065, 0.381065905094147, 0.380978345870972, 0.380890488624573, 0.380802363157272, 0.380714058876038, 0.380625426769257, 0.380536556243896, 0.380447417497635, 0.380358070135117, 0.380268454551697, 0.380178540945053, 0.380088418722153, 0.379997998476028, 0.37990739941597, 0.37981653213501, 0.379725337028503, 0.37963393330574, 0.379542320966721, 0.379450380802155, 0.379358202219009, 0.37926572561264, 0.379173070192337, 0.379080146551132, 0.378986984491348, 0.37889352440834, 0.378799855709076, 0.378705888986588, 0.378611713647842, 0.378517240285873, 0.378422498703003, 0.378327548503876, 0.378232330083847, 0.378136843442917, 0.37804114818573, 0.377945184707642, 0.377848893404007, 0.377752393484116, 0.377655684947968, 0.377558648586273, 0.377461403608322, 0.37736389040947, 0.377266108989716, 0.377168118953705, 0.37706983089447, 0.376971274614334, 0.376872479915619, 0.376773476600647, 0.376674205064774, 0.376574605703354, 0.376474827528, 0.376374781131744, 0.376274466514587, 0.376173883676529, 0.376073062419891, 0.375972002744675, 0.375870674848557, 0.375769048929214, 0.375667244195938, 0.37556517124176, 0.375462800264359, 0.3753602206707, 0.37525737285614, 0.375154286623001, 0.375050872564316, 0.374947279691696, 0.374843388795853, 0.37473925948143, 0.374634891748428, 0.374530225992203, 0.374425381422043, 0.374320209026337, 0.374214798212051, 0.374109148979187, 0.374003231525421, 0.373897075653076, 0.373790681362152, 0.373683989048004, 0.373577058315277, 0.373469918966293, 0.373362421989441, 0.373254776000977, 0.373146831989288, 0.373038619756699, 0.37293016910553, 0.372821480035782, 0.372712522745132, 0.372603297233582, 0.372493863105774, 0.37238410115242, 0.372274130582809, 0.372163861989975, 0.372053414583206, 0.371942639350891, 0.371831685304642, 0.371720403432846, 0.371608912944794, 0.371497124433517, 0.371385127305984, 0.37127286195755, 0.371160328388214, 0.371047616004944, 0.370934516191483, 0.370821207761765, 0.370707720518112, 0.370593875646591, 0.370479851961136, 0.370365560054779, 0.370250940322876, 0.370136171579361, 0.370021104812622, 0.369905799627304, 0.369790196418762, 0.369674384593964, 0.369558274745941, 0.369441956281662, 0.369325369596481, 0.369208514690399, 0.369091421365738, 0.368974030017853, 0.368856459856033, 0.36873859167099, 0.368620455265045, 0.368502080440521, 0.368383467197418, 0.368264615535736, 0.368145436048508, 0.368026047945023, 0.367906421422958, 0.36778649687767, 0.367666333913803, 0.367545962333679, 0.367425262928009, 0.36730432510376, 0.367183208465576, 0.367061734199524, 0.366940051317215, 0.366818100214005, 0.366695940494537, 0.366573482751846, 0.366450786590576, 0.366327792406082, 0.366204619407654, 0.366081118583679, 0.365957409143448, 0.365833431482315, 0.365709245204926, 0.365584760904312, 0.365460008382797, 0.365335047245026, 0.36520978808403, 0.365084290504456, 0.364958524703979, 0.364832580089569, 0.364706307649612, 0.364579766988754, 0.364452958106995, 0.364325940608978, 0.36419865489006, 0.364071130752563, 0.363943368196487, 0.363815307617188, 0.363687038421631, 0.36355847120285, 0.363429665565491, 0.363300621509552, 0.363171249628067, 0.363041698932648, 0.362911880016327, 0.362781792879105, 0.362651467323303, 0.362520843744278, 0.362390041351318, 0.362258940935135, 0.362127602100372, 0.361995995044708, 0.361864119768143, 0.361732006072998, 0.361599624156952, 0.361467003822327, 0.361334174871445, 0.361201047897339, 0.361067622900009, 0.360933989286423, 0.360800087451935, 0.36066597700119, 0.360531538724899, 0.360396891832352, 0.360261976718903, 0.360126793384552, 0.359991371631622, 0.359855681657791, 0.359719753265381, 0.359583556652069, 0.359447151422501, 0.359310418367386, 0.359173476696014, 0.359036296606064, 0.358898848295212, 0.358761131763458, 0.358623147010803, 0.358484953641891, 0.358346492052078, 0.358207732439041, 0.358068764209747, 0.357929527759552, 0.357790023088455, 0.357650309801102, 0.357510268688202, 0.357370048761368, 0.357229560613632, 0.35708874464035, 0.356947720050812, 0.356806486845016, 0.356664955615997, 0.356523156166077, 0.356381118297577, 0.356238812208176, 0.356096267700195, 0.355953484773636, 0.355810433626175, 0.355667114257812, 0.355523556470871, 0.355379730463028, 0.355235636234283, 0.355091333389282, 0.35494676232338, 0.354801893234253, 0.354656785726547, 0.354511469602585, 0.354365885257721, 0.354220032691956, 0.354073911905289, 0.353927552700043, 0.353780925273895, 0.353634089231491, 0.353486955165863, 0.353339582681656, 0.353191912174225, 0.353044033050537, 0.352895885705948, 0.35274749994278, 0.352598816156387, 0.352449923753738, 0.352300763130188, 0.352151364088058, 0.35200172662735, 0.351851761341095, 0.351701587438583, 0.351551175117493, 0.351400464773178, 0.351249545812607, 0.351098358631134, 0.35094690322876, 0.350795149803162, 0.350643217563629, 0.350491017103195, 0.350338518619537, 0.350185811519623, 0.350032866001129, 0.349879592657089, 0.349726110696793, 0.349572420120239, 0.349418371915817, 0.349264144897461, 0.349109649658203, 0.348954856395721, 0.348799884319305, 0.348644584417343, 0.348489046096802, 0.348333299160004, 0.348177254199982, 0.348021000623703, 0.3478644490242, 0.347707659006119, 0.347550600767136, 0.347393333911896, 0.34723573923111, 0.347077965736389, 0.346919864416122, 0.346761554479599, 0.346602946519852, 0.34644415974617, 0.346285104751587, 0.346125721931458, 0.345966160297394, 0.345806300640106, 0.34564620256424, 0.345485806465149, 0.345325231552124, 0.345164358615875, 0.345003217458725, 0.344841837882996, 0.344680219888687, 0.3445183634758, 0.34435623884201, 0.344193816184998, 0.344031155109406, 0.343868255615234, 0.343705117702484, 0.34354168176651, 0.343378067016602, 0.343214154243469, 0.343049913644791, 0.342885553836823, 0.342720836400986, 0.342555910348892, 0.342390716075897, 0.342225283384323, 0.342059582471848, 0.341893643140793, 0.341727405786514, 0.341560930013657, 0.34139421582222, 0.341227263212204, 0.341060072183609, 0.34089258313179, 0.34072482585907, 0.340556859970093, 0.340388596057892, 0.340220093727112, 0.340051352977753, 0.339882344007492, 0.339713096618652, 0.339543581008911, 0.339373797178268, 0.339203774929047, 0.339033514261246, 0.338862985372543, 0.338692188262939, 0.338521152734756, 0.33834981918335, 0.338178277015686, 0.338006496429443, 0.337834417819977, 0.337662160396576, 0.337489575147629, 0.33731672167778, 0.337143629789352, 0.33697035908699, 0.33679673075676, 0.336622893810272, 0.336448788642883, 0.336274415254593, 0.336099863052368, 0.335924983024597, 0.335749864578247, 0.33557453751564, 0.335398882627487, 0.335223019123077, 0.335046887397766, 0.334870487451553, 0.334693908691406, 0.334516972303391, 0.334339827299118, 0.334162414073944, 0.333984732627869, 0.333806812763214, 0.333628714084625, 0.333450257778168, 0.333271592855453, 0.333092629909515, 0.332913458347321, 0.332734018564224, 0.332554340362549, 0.332374393939972, 0.332194209098816, 0.332013726234436, 0.331833004951477, 0.331652075052261, 0.331470847129822, 0.331289350986481, 0.331107646226883, 0.330925703048706, 0.330743432044983, 0.330560952425003, 0.330378204584122, 0.330195188522339, 0.330011934041977, 0.329828411340714, 0.329644650220871, 0.329460620880127, 0.329276382923126, 0.329091846942902, 0.328907042741776, 0.328722059726715, 0.328536778688431, 0.3283511698246, 0.328165411949158, 0.327979356050491, 0.327793002128601, 0.327606499195099, 0.327419698238373, 0.327232629060745, 0.327045291662216, 0.326857715845108, 0.326669871807098, 0.32648178935051, 0.326293408870697, 0.326104789972305, 0.325916022062302, 0.325726866722107, 0.325537502765656, 0.325347870588303, 0.325158029794693, 0.324967920780182, 0.324777513742447, 0.324586898088455, 0.324396044015884, 0.32420489192009, 0.324013471603394, 0.323821812868118, 0.323629885911942, 0.323437750339508, 0.323245316743851, 0.323052674531937, 0.322859764099121, 0.322666555643082, 0.322473138570786, 0.322279512882233, 0.322085559368134, 0.321891307830811, 0.321696877479553, 0.321502178907394, 0.321307212114334, 0.321112036705017, 0.320916533470154, 0.320720791816711, 0.320524841547012, 0.320328593254089, 0.320132106542587, 0.319935381412506, 0.319738417863846, 0.319541156291962, 0.319343626499176, 0.319145888090134, 0.31894788146019, 0.318749666213989, 0.31855109333992, 0.318352341651917, 0.318153291940689, 0.317954003810883, 0.31774628162384, 0.317530691623688, 0.317314982414246, 0.317099153995514, 0.31688329577446, 0.316667288541794, 0.316451251506805, 0.316235184669495, 0.316018968820572, 0.315802693367004, 0.315586298704147, 0.315369844436646, 0.315153270959854, 0.314936727285385, 0.314720004796982, 0.314503192901611, 0.314286351203918, 0.314069390296936, 0.313852339982986, 0.313635259866714, 0.313418090343475, 0.313200801610947, 0.312983453273773, 0.312766015529633, 0.312548458576202, 0.31233087182045, 0.31211319565773, 0.311895370483398, 0.311677575111389, 0.311459630727768, 0.311241626739502, 0.311023503541946, 0.310805320739746, 0.310587078332901, 0.310368746519089, 0.310150295495987, 0.30993178486824, 0.309713184833527, 0.30949455499649, 0.309275805950165, 0.309056907892227, 0.308838039636612, 0.308618992567062, 0.30839991569519, 0.308180749416351, 0.307961523532867, 0.307742178440094, 0.307522803544998, 0.307303309440613, 0.307083666324615, 0.306864053010941, 0.306644350290298, 0.3064244389534, 0.306204527616501, 0.305984556674957, 0.305764496326447, 0.305544346570969, 0.305324107408524, 0.305103808641434, 0.304883420467377, 0.30466291308403, 0.304442346096039, 0.304221719503403, 0.304000973701477, 0.303780168294907, 0.303559273481369, 0.303338259458542, 0.303117245435715, 0.30289614200592, 0.302674889564514, 0.302453607320786, 0.302232205867767, 0.302010715007782, 0.301789164543152, 0.301567524671555, 0.301345825195312, 0.301124036312103, 0.300902158021927, 0.300680160522461, 0.300458163022995, 0.300236016511917, 0.300013810396194, 0.299791514873505, 0.29956915974617, 0.299346685409546, 0.299124151468277, 0.298901498317719, 0.29867884516716, 0.298456072807312, 0.298233181238174, 0.298010259866714, 0.297787189483643, 0.297564089298248, 0.297340899705887, 0.297117620706558, 0.296894252300262, 0.296670794487, 0.296447277069092, 0.296223670244217, 0.296000003814697, 0.29577624797821, 0.295552343130112, 0.295328438282013, 0.295104414224625, 0.294880300760269, 0.294656127691269, 0.294431895017624, 0.294207513332367, 0.293983101844788, 0.293758600950241, 0.293533951044083, 0.293309330940247, 0.293084561824799, 0.292859733104706, 0.292634814977646, 0.292409777641296, 0.292184680700302, 0.291959583759308, 0.291734278202057, 0.291508972644806, 0.291283547878265, 0.291058003902435, 0.290832459926605, 0.290606826543808, 0.290381073951721, 0.290155231952667, 0.289929360151291, 0.289703339338303, 0.289477288722992, 0.289251089096069, 0.289024889469147, 0.288798570632935, 0.288572162389755, 0.288345694541931, 0.288119077682495, 0.287892460823059, 0.287665754556656, 0.287438929080963, 0.287212044000626, 0.286985069513321, 0.286758005619049, 0.286530822515488, 0.286303639411926, 0.286076337099075, 0.285848915576935, 0.285621464252472, 0.285393893718719, 0.285166263580322, 0.28493857383728, 0.284710764884949, 0.28448286652565, 0.284254878759384, 0.284026831388474, 0.283798724412918, 0.283570528030396, 0.283342272043228, 0.283113867044449, 0.282885402441025, 0.282656848430634, 0.282428205013275, 0.282199531793594, 0.281970769166946, 0.281741887331009, 0.281512916088104, 0.281283915042877, 0.281054794788361, 0.280825614929199, 0.280596345663071, 0.280366957187653, 0.280137479305267, 0.27990797162056, 0.279678374528885, 0.279448717832565, 0.279218912124634, 0.278989046812057, 0.278759121894836, 0.278529077768326, 0.27829897403717, 0.278068840503693, 0.277838557958603, 0.277608215808868, 0.277377784252167, 0.277147263288498, 0.276916652917862, 0.276685982942581, 0.276455253362656, 0.276224404573441, 0.275993466377258, 0.275762468576431, 0.275531351566315, 0.275300204753876, 0.27506896853447, 0.274837613105774, 0.274606198072433, 0.274374723434448, 0.274143129587173, 0.273911476135254, 0.273679703474045, 0.273447871208191, 0.273215979337692, 0.272983998060226, 0.272751897573471, 0.272519737482071, 0.272287517786026, 0.272055208683014, 0.271822780370712, 0.271590292453766, 0.271357744932175, 0.271125048398972, 0.270892351865768, 0.270659536123276, 0.270426630973816, 0.270193666219711, 0.26996061205864, 0.269727438688278, 0.269494265317917, 0.269260942935944, 0.269027531147003, 0.268794059753418, 0.268560498952866, 0.268326848745346, 0.268093168735504, 0.267859369516373, 0.267625451087952, 0.267391502857208, 0.26715749502182, 0.266923308372498, 0.266689151525497, 0.266454815864563, 0.266220450401306, 0.265985995531082, 0.265751451253891, 0.265516817569733, 0.26528212428093, 0.265047341585159, 0.264812469482422, 0.26457753777504, 0.264342457056046, 0.264107346534729, 0.263872116804123, 0.263636887073517, 0.263401508331299, 0.263166099786758, 0.262930542230606, 0.262694954872131, 0.262459248304367, 0.262223452329636, 0.261987626552582, 0.261751681566238, 0.261515647172928, 0.26127952337265, 0.26104336977005, 0.26080709695816, 0.260570734739304, 0.260334312915802, 0.260097801685333, 0.259861201047897, 0.259624511003494, 0.259387791156769, 0.259150922298431, 0.258913993835449, 0.258677005767822, 0.258439898490906, 0.258202731609344, 0.257965475320816, 0.257728159427643, 0.25749072432518, 0.25725319981575, 0.257015645503998, 0.256777942180634, 0.256540238857269, 0.256302416324615, 0.256064474582672, 0.255826503038406, 0.255588412284851, 0.255350232124329, 0.255112022161484, 0.254873722791672, 0.254635274410248, 0.254396796226501, 0.254158228635788, 0.253919571638107, 0.253680855035782, 0.253442049026489, 0.253203123807907, 0.25296413898468, 0.252725064754486, 0.252485930919647, 0.252246707677841, 0.25200742483139, 0.25176802277565, 0.251528561115265, 0.25128898024559, 0.251049309968948, 0.250809609889984, 0.250569820404053, 0.250329941511154, 0.250089973211288, 0.249849915504456, 0.249609768390656, 0.249369576573372, 0.249129295349121, 0.248888909816742, 0.248648449778557, 0.248407900333405, 0.248167261481285, 0.247926563024521, 0.247685775160789, 0.247444897890091, 0.24720399081707, 0.246962904930115, 0.246721789240837, 0.246480599045753, 0.246239319443703, 0.245997965335846, 0.2457564920187, 0.24551497399807, 0.245273366570473, 0.245031639933586, 0.244789898395538, 0.244548052549362, 0.244306087493896, 0.244064077734947, 0.243821978569031, 0.243579745292664, 0.243337541818619, 0.243095189332962, 0.242852717638016, 0.242610201239586, 0.24236761033535, 0.242124915122986, 0.241882190108299, 0.241639330983162, 0.241396397352219, 0.241153389215469, 0.240910276770592, 0.240667104721069, 0.240423887968063, 0.240180537104607, 0.239937126636505, 0.239693626761436, 0.239449992775917, 0.239206343889236, 0.238962590694427, 0.238718792796135, 0.238474875688553, 0.238230884075165, 0.237986773252487, 0.237742602825165, 0.237498387694359, 0.237254068255424, 0.237009659409523, 0.236765176057816, 0.23652058839798, 0.236275926232338, 0.23603118956089, 0.235786408185959, 0.235541507601738, 0.23529651761055, 0.235051423311234, 0.234806314110756, 0.234561055898666, 0.234315767884254, 0.234070375561714, 0.233824893832207, 0.233579322695732, 0.233333677053452, 0.233087971806526, 0.232842177152634, 0.232596278190613, 0.232350304722786, 0.232104256749153, 0.231858134269714, 0.231611892580986, 0.231365635991096, 0.231119230389595, 0.230872765183449, 0.230626210570335, 0.230379581451416, 0.230132877826691, 0.229886099696159, 0.229639247059822, 0.229392260313034, 0.229145228862762, 0.228898093104362, 0.228650867938995, 0.228403642773628, 0.228156268596649, 0.227908805012703, 0.227661281824112, 0.227413669228554, 0.227165952324867, 0.226918205618858, 0.226670324802399, 0.226422384381294, 0.226174369454384, 0.225926235318184, 0.225678041577339, 0.22542978823185, 0.225181445479393, 0.22493302822113, 0.224684521555901, 0.224435865879059, 0.224187180399895, 0.223938435316086, 0.22368960082531, 0.223440662026405, 0.223191678524017, 0.222942560911179, 0.222693368792534, 0.222444117069244, 0.222194790840149, 0.221945390105247, 0.221695870161057, 0.22144627571106, 0.221196606755257, 0.220946848392487, 0.220697015523911, 0.22044712305069, 0.220197141170502, 0.219947025179863, 0.219696864485741, 0.219446629285812, 0.219196304678917, 0.218945905566216, 0.218695402145386, 0.21844482421875, 0.218194156885147, 0.217943385243416, 0.217692658305168, 0.217441737651825, 0.217190727591515, 0.216939672827721, 0.21668852865696, 0.216437265276909, 0.216185972094536, 0.215934589505196, 0.215683087706566, 0.215431556105614, 0.215179905295372, 0.214928165078163, 0.214676380157471, 0.21442449092865, 0.214172497391701, 0.213920444250107, 0.213668316602707, 0.213416084647179, 0.213163837790489, 0.212911427021027, 0.212658956646919, 0.212406426668167, 0.212153807282448, 0.211901053786278, 0.211648270487785, 0.211395412683487, 0.211142480373383, 0.210889413952827, 0.210636273026466, 0.210383087396622, 0.21012981235981, 0.20987643301487, 0.209622979164124, 0.20936943590641, 0.209115833044052, 0.208862125873566, 0.208608359098434, 0.208354517817497, 0.208100542426109, 0.207846537232399, 0.207592412829399, 0.207338228821754, 0.207083940505981, 0.206829622387886, 0.20657517015934, 0.206320643424988, 0.20606604218483, 0.205811336636543, 0.205556586384773, 0.205301746726036, 0.205046817660332, 0.204791784286499, 0.204536691308022, 0.204281523823738, 0.204026252031326, 0.203770950436592, 0.203515499830246, 0.203260004520416, 0.203004434704781, 0.202748730778694, 0.202492982149124, 0.202237173914909, 0.201981246471405, 0.201725229620934, 0.201469123363495, 0.201212987303734, 0.200956732034683, 0.20070044696331, 0.200444027781487, 0.200187519192696, 0.19993095099926, 0.199679240584373, 0.199432343244553, 0.199185624718666, 0.198938965797424, 0.198692366480827, 0.198445931077003, 0.19819962978363, 0.197953432798386, 0.197707340121269, 0.197461366653442, 0.197215527296066, 0.196969777345657, 0.196724131703377, 0.196478590369225, 0.196233257651329, 0.195987984538078, 0.195742845535278, 0.195497751235962, 0.195252776145935, 0.195007994771004, 0.194763287901878, 0.194518685340881, 0.194274231791496, 0.194029912352562, 0.193785667419434, 0.19354148209095, 0.193297520279884, 0.193053647875786, 0.192809909582138, 0.192566156387329, 0.192322626709938, 0.192079216241837, 0.191835910081863, 0.191592708230019, 0.191349640488625, 0.191106662154198, 0.190863788127899, 0.190621048212051, 0.190378442406654, 0.190135911107063, 0.189893543720245, 0.189651250839233, 0.189409077167511, 0.189167022705078, 0.188925132155418, 0.188683301210403, 0.188441589474678, 0.188200011849403, 0.187958538532257, 0.187717214226723, 0.187475934624672, 0.187234818935394, 0.186993837356567, 0.186752945184708, 0.186512187123299, 0.186271488666534, 0.186030924320221, 0.185790568590164, 0.18555024266243, 0.185309991240501, 0.18506994843483, 0.184829980134964, 0.184590056538582, 0.18435038626194, 0.184110790491104, 0.183871254324913, 0.183631807565689, 0.183392539620399, 0.183153420686722, 0.182914420962334, 0.182675421237946, 0.182436615228653, 0.18219792842865, 0.181959390640259, 0.181720912456512, 0.181482523679733, 0.181244313716888, 0.181006208062172, 0.180768236517906, 0.180530250072479, 0.180292516946793, 0.180054843425751, 0.179817333817482, 0.179579898715019, 0.179342582821846, 0.179105371236801, 0.178868308663368, 0.178631290793419, 0.178394481539726, 0.17815774679184, 0.177921146154404, 0.177684590220451, 0.177448213100433, 0.177211955189705, 0.176975831389427, 0.176739767193794, 0.176503852009773, 0.176267996430397, 0.176032334566116, 0.175796717405319, 0.175561308860779, 0.175325930118561, 0.175090730190277, 0.174855560064316, 0.17462058365345, 0.174385651946068, 0.174150928854942, 0.173916265368462, 0.173681691288948, 0.173447325825691, 0.173212990164757, 0.172978803515434, 0.172744736075401, 0.172510743141174, 0.17227691411972, 0.172043174505234, 0.171809554100037, 0.171576038002968, 0.171342641115189, 0.171109393239021, 0.17087621986866, 0.170643195509911, 0.170410260558128, 0.170177474617958, 0.169944733381271, 0.169712170958519, 0.169479757547379, 0.169247403740883, 0.169015139341354, 0.168782994151115, 0.168551027774811, 0.168319180607796, 0.168087318539619, 0.167855694890022, 0.167624160647392, 0.167392760515213, 0.167161419987679, 0.166930243372917, 0.166699200868607, 0.166468247771263, 0.166237309575081, 0.166006594896317, 0.165776014328003, 0.165545538067818, 0.165315136313438, 0.165084853768349, 0.164854690432549, 0.164624691009521, 0.164394751191139, 0.164164945483208, 0.163935258984566, 0.163705691695213, 0.163476228713989, 0.163246840238571, 0.163017600774765, 0.162788555026054, 0.162559524178505, 0.162330642342567, 0.162101849913597, 0.161873236298561, 0.161644652485847, 0.161416232585907, 0.161187961697578, 0.160959750413895, 0.160731732845306, 0.160503730177879, 0.160275846719742, 0.160048186779022, 0.159820541739464, 0.159592986106873, 0.159365639090538, 0.159138381481171, 0.158911228179932, 0.15868416428566, 0.158457249403, 0.15823045372963, 0.158003762364388, 0.157777175307274, 0.157550677657127, 0.157324358820915, 0.157098174095154, 0.156872019171715, 0.15664604306221, 0.156420156359673, 0.156194373965263, 0.155968770384789, 0.155743226408958, 0.155517786741257, 0.155292481184006, 0.155067309737206, 0.15484219789505, 0.154617264866829, 0.154392451047897, 0.154167726635933, 0.153943061828613, 0.15371860563755, 0.153494209051132, 0.153269976377487, 0.153045788407326, 0.152821764349937, 0.152597844600677, 0.152374029159546, 0.152150303125381, 0.151926785707474, 0.151703372597694, 0.151479989290237, 0.151256710290909, 0.151033595204353, 0.150810614228249, 0.150587752461433, 0.150365009903908, 0.150142312049866, 0.149919807910919, 0.14969739317894, 0.149475127458572, 0.149252876639366, 0.149030864238739, 0.148808881640434, 0.14858703315258, 0.148365274071693, 0.148143723607063, 0.147922202944756, 0.147700846195221, 0.14747953414917, 0.147258400917053, 0.147037357091904, 0.14681650698185, 0.146595656871796, 0.146374925971031, 0.146154388785362, 0.145933926105499, 0.145713612437248, 0.145493373274803, 0.145273238420486, 0.145053267478943, 0.144833400845528, 0.144613608717918, 0.144394025206566, 0.144174441695213, 0.143955022096634, 0.143735706806183, 0.143516540527344, 0.143297508358955, 0.143078491091728, 0.142859637737274, 0.142640992999077, 0.142422333359718, 0.142203852534294, 0.141985505819321, 0.141767263412476, 0.141549080610275, 0.141331031918526, 0.141113057732582, 0.140895336866379, 0.140677630901337, 0.140460059046745, 0.140242606401443, 0.14002525806427, 0.139808058738708, 0.139590978622437, 0.139373928308487, 0.13915704190731, 0.138940319418907, 0.138723701238632, 0.13850711286068, 0.138290748000145, 0.138074487447739, 0.137858271598816, 0.137642115354538, 0.137426227331161, 0.137210339307785, 0.136994674801826, 0.136778995394707, 0.136563524603844, 0.136348217725754, 0.136132955551147, 0.135917752981186, 0.135702729225159, 0.135487839579582, 0.135273039340973, 0.135058298707008, 0.134843781590462, 0.13462932407856, 0.13441501557827, 0.134200751781464, 0.133986666798592, 0.133772656321526, 0.13355877995491, 0.133345037698746, 0.133131355047226, 0.132917851209641, 0.132704466581345, 0.132491171360016, 0.132277950644493, 0.132064864039421, 0.131851971149445, 0.131639152765274, 0.131426364183426, 0.131213769316673, 0.131001278758049, 0.130788922309875, 0.130576610565186, 0.130364522337914, 0.130152508616447, 0.12994059920311, 0.129728779196739, 0.129517078399658, 0.12930554151535, 0.129094138741493, 0.128882735967636, 0.128671526908875, 0.128460422158241, 0.12824946641922, 0.128038555383682, 0.12782783806324, 0.127617210149765, 0.127406686544418, 0.1271962672472, 0.126985937356949, 0.126775726675987, 0.126565709710121, 0.126355767250061, 0.12614594399929, 0.125936195254326, 0.125726580619812, 0.125517085194588, 0.125307723879814, 0.125098496675491, 0.124889351427555, 0.124680317938328, 0.124471381306648, 0.124262556433678, 0.124053910374641, 0.123845390975475, 0.12363688647747, 0.123428553342819, 0.12322036921978, 0.123012259602547, 0.1228042319417, 0.122596405446529, 0.122388646006584, 0.122181005775928, 0.121973402798176, 0.121766045689583, 0.121558792889118, 0.121351592242718, 0.121144525706768, 0.120937556028366, 0.120730698108673, 0.120524048805237, 0.12031739205122, 0.12011095136404, 0.119904592633247, 0.119698338210583, 0.119492165744305, 0.119286127388477, 0.11908020824194, 0.118874497711658, 0.118668794631958, 0.118463180959225, 0.118257701396942, 0.118052437901497, 0.117847196757793, 0.117642126977444, 0.117437154054642, 0.117232300341129, 0.117027513682842, 0.116822853684425, 0.116618297994137, 0.116413950920105, 0.116209656000137, 0.116005472838879, 0.115801401436329, 0.115597426891327, 0.11539364606142, 0.115189880132675, 0.114986307919025, 0.114782825112343, 0.114579476416111, 0.114376187324524, 0.114173077046871, 0.113970041275024, 0.113767132163048, 0.113564319908619, 0.113361649215221, 0.113159127533436, 0.112956665456295, 0.112754330039024, 0.112552113831043, 0.112350009381771, 0.112148031592369, 0.11194621771574, 0.11174438148737, 0.111542753875256, 0.111341260373592, 0.111139871180058, 0.110938556492329, 0.110737375915051, 0.110536359250546, 0.110335364937782, 0.110134571790695, 0.109933830797672, 0.109733276069164, 0.109532758593559, 0.109332367777824, 0.109132170677185, 0.108932010829449, 0.108731999993324, 0.108532048761845, 0.108332231640816, 0.108132638037205, 0.107933029532433, 0.107733622193336, 0.107534296810627, 0.107335105538368, 0.107135973870754, 0.10693696141243, 0.106738105416298, 0.106539398431778, 0.106340773403645, 0.106142222881317, 0.105943776667118, 0.105745501816273, 0.105547353625298, 0.105349272489548, 0.105151362717152, 0.104953549802303, 0.104755841195583, 0.104558236896992, 0.104360722005367, 0.104163385927677, 0.103966161608696, 0.103769019246101, 0.103571943938732, 0.10337507724762, 0.103178270161152, 0.102981604635715, 0.102785028517246, 0.102588623762131, 0.102392293512821, 0.102196075022221, 0.101999931037426, 0.101803995668888, 0.101608142256737, 0.101412385702133, 0.1012167558074, 0.101021267473698, 0.10082583874464, 0.100630566477776, 0.100435376167297, 0.100240260362625, 0.10004536062479, 0.0998505651950836, 0.0996558591723442, 0.0994612276554108, 0.0992667227983475, 0.0990723669528961, 0.0988781601190567, 0.0986840352416039, 0.0984900370240211, 0.0982961356639862, 0.0981023088097572, 0.0979086607694626, 0.0977150946855545, 0.0975216254591942, 0.0973283424973488, 0.0971350744366646, 0.0969419479370117, 0.0967490375041962, 0.0965561866760254, 0.0963634550571442, 0.0961708277463913, 0.095978356897831, 0.0957858860492706, 0.095593623816967, 0.0954014733433723, 0.0952093675732613, 0.0950174480676651, 0.0948256030678749, 0.0946338772773743, 0.094442293047905, 0.0942508354783058, 0.0940594747662544, 0.0938682332634926, 0.0936771109700203, 0.0934861227869987, 0.0932951644062996, 0.0931043699383736, 0.0929137393832207, 0.0927232131361961, 0.0925327092409134, 0.0923423767089844, 0.0921521708369255, 0.091962069272995, 0.0917721539735794, 0.0915823131799698, 0.0913925245404243, 0.0912029221653938, 0.0910134539008141, 0.0908239558339119, 0.0906466990709305, 0.0904810950160027, 0.090315617620945, 0.0901503637433052, 0.0899853557348251, 0.089820422232151, 0.0896557047963142, 0.0894912406802177, 0.0893268957734108, 0.0891627296805382, 0.0889987125992775, 0.0888349190354347, 0.0886713340878487, 0.0885078310966492, 0.08834458142519, 0.0881814956665039, 0.0880186259746552, 0.0878559127449989, 0.087693378329277, 0.0875310078263283, 0.0873688459396362, 0.0872068479657173, 0.0870450586080551, 0.0868833586573601, 0.0867219120264053, 0.0865606293082237, 0.0863995552062988, 0.0862386524677277, 0.0860779136419296, 0.0859173014760017, 0.0857570245862007, 0.0855967402458191, 0.0854367688298225, 0.0852769911289215, 0.085117295384407, 0.0849578604102135, 0.0847985446453094, 0.0846393927931786, 0.0844805464148521, 0.0843217745423317, 0.0841631293296814, 0.0840047374367714, 0.0838465616106987, 0.0836886242032051, 0.0835307314991951, 0.0833730548620224, 0.0832155495882034, 0.0830582901835442, 0.0829011499881744, 0.0827441737055779, 0.0825874581933022, 0.0824308767914772, 0.0822744518518448, 0.0821182280778885, 0.0819621905684471, 0.0818063169717789, 0.0816506743431091, 0.0814951807260513, 0.0813398882746696, 0.0811847597360611, 0.0810297653079033, 0.0808750241994858, 0.0807203575968742, 0.080565981566906, 0.0804117396473885, 0.0802577063441277, 0.0801037922501564, 0.0799501314759254, 0.0797966495156288, 0.0796432793140411, 0.0794901698827744, 0.0793371722102165, 0.0791844427585602, 0.0790317431092262, 0.0788793787360191, 0.0787270739674568, 0.0785750821232796, 0.0784231051802635, 0.0782714113593102, 0.0781198889017105, 0.0779685750603676, 0.0778174325823784, 0.0776664242148399, 0.0775156468153, 0.0773650407791138, 0.0772145763039589, 0.0770643055438995, 0.0769141763448715, 0.0767643228173256, 0.0766145512461662, 0.0764650478959084, 0.0763157084584236, 0.0761664882302284, 0.0760175213217735, 0.0758687257766724, 0.0757200866937637, 0.075571671128273, 0.0754233747720718, 0.0752751976251602, 0.0751273632049561, 0.0749796181917191, 0.0748320668935776, 0.0746846124529839, 0.0745374858379364, 0.0743904486298561, 0.0742436572909355, 0.0740970000624657, 0.0739505961537361, 0.0738042593002319, 0.0736581459641457, 0.0735121592879295, 0.0733665004372597, 0.0732208788394928, 0.0730755180120468, 0.0729302763938904, 0.0727852508425713, 0.0726403817534447, 0.072495773434639, 0.0723512470722198, 0.0722070187330246, 0.0720628648996353, 0.0719189271330833, 0.0717751607298851, 0.07163155823946, 0.071488156914711, 0.0713449344038963, 0.0712019130587578, 0.07105902582407, 0.0709163770079613, 0.0707738623023033, 0.0706315562129021, 0.0704894661903381, 0.0703474953770638, 0.0702056959271431, 0.0700641348958015, 0.0699227154254913, 0.0697814524173737, 0.0696404054760933, 0.0694994851946831, 0.069358766078949, 0.0692183077335358, 0.0690780133008957, 0.0689378827810287, 0.0687979236245155, 0.068658135831356, 0.0685185045003891, 0.0683790519833565, 0.068239763379097, 0.0681007206439972, 0.0679618492722511, 0.0678231939673424, 0.0676846131682396, 0.0675463303923607, 0.0674080848693848, 0.0672701448202133, 0.0671323165297508, 0.066994696855545, 0.0668573006987572, 0.0667200535535812, 0.0665829479694366, 0.0664460510015488, 0.066309355199337, 0.0661727041006088, 0.0660363510251045, 0.0659001991152763, 0.0657642185688019, 0.0656284093856812, 0.0654928013682365, 0.0653573721647263, 0.0652220994234085, 0.0650869160890579, 0.0649520307779312, 0.0648173391819, 0.0646827444434166, 0.0645484030246735, 0.0644142255187035, 0.0642802119255066, 0.0641463696956635, 0.0640126466751099, 0.0638792291283607, 0.0637459233403206, 0.0636128336191177, 0.063479870557785, 0.0633471980690956, 0.0632146522402763, 0.0630822330713272, 0.0629499480128288, 0.0628179460763931, 0.0626861080527306, 0.0625544413924217, 0.0624230317771435, 0.0622917823493481, 0.0621606223285198, 0.062029667198658, 0.0618988797068596, 0.0617682635784149, 0.0616378970444202, 0.0615076161921024, 0.0613776668906212, 0.0612477622926235, 0.0611180663108826, 0.0609886199235916, 0.0608592145144939, 0.0607301481068134, 0.0606011636555195, 0.0604723952710629, 0.0603438653051853, 0.0602154284715652, 0.0600871592760086, 0.0599591359496117, 0.0598313249647617, 0.0597035102546215, 0.0595760382711887, 0.0594486854970455, 0.0593215450644493, 0.0591946132481098, 0.0590678490698338, 0.0589412078261375, 0.0588147826492786, 0.0586884804069996, 0.0585624687373638, 0.0584365837275982, 0.058310866355896, 0.0581853613257408, 0.0580600202083588, 0.0579348504543304, 0.057809840887785, 0.0576850958168507, 0.057560421526432, 0.0574360080063343, 0.0573117546737194, 0.0571876280009747, 0.0570637583732605, 0.0569400973618031, 0.0568165555596352, 0.0566931404173374, 0.0565699338912964, 0.0564469434320927, 0.0563241168856621, 0.0562015436589718, 0.0560790523886681, 0.0559568554162979, 0.0558346956968307, 0.0557127967476845, 0.0555910132825375, 0.0554694905877113, 0.0553480871021748, 0.0552269332110882, 0.055105909705162, 0.0549851395189762, 0.0548644475638866, 0.0547440089285374, 0.0546236969530582, 0.0545035526156425, 0.0543836578726768, 0.0542639307677746, 0.0541443713009357, 0.0540249422192574, 0.0539057590067387, 0.0537867471575737, 0.0536679401993752, 0.0535492226481438, 0.0534307509660721, 0.0533124059438705, 0.0531943552196026, 0.0530763491988182, 0.0529586300253868, 0.0528410859405994, 0.0527237020432949, 0.0526063665747643, 0.0524893589317799, 0.0523724816739559, 0.0522558614611626, 0.0521393120288849, 0.0520230680704117, 0.0519068613648415, 0.0517909489572048, 0.051675159484148, 0.0515595786273479, 0.051444124430418, 0.0513288825750351, 0.0512138493359089, 0.0510990656912327, 0.0509843230247498, 0.0508698336780071, 0.0507554672658443, 0.0506412722170353, 0.0505273267626762, 0.0504135936498642, 0.0502999387681484, 0.0501865372061729, 0.0500733479857445, 0.0499601997435093, 0.0498473010957241, 0.0497346147894859, 0.0496220514178276, 0.049509696662426, 0.0493976324796677, 0.0492856614291668, 0.0491738133132458, 0.0490622520446777, 0.0489507764577866, 0.0488394312560558, 0.0487284176051617, 0.0486174896359444, 0.0485068112611771, 0.0483962148427963, 0.0482859201729298, 0.0481757447123528, 0.0480657368898392, 0.0479558557271957, 0.0478462241590023, 0.0477368049323559, 0.0476275980472565, 0.047518465667963, 0.0474095493555069, 0.0473008379340172, 0.0471922531723976, 0.0470838360488415, 0.0469756759703159, 0.0468676798045635, 0.0467598512768745, 0.046652190387249, 0.0465447381138802, 0.0464374534785748, 0.0463303737342358, 0.046223346143961, 0.0461166016757488, 0.046010073274374, 0.0459037087857723, 0.0457974746823311, 0.0456914864480495, 0.0455856695771217, 0.0454800166189671, 0.0453745387494564, 0.045269139111042, 0.0451640300452709, 0.0450591370463371, 0.0449544042348862, 0.0448498427867889, 0.0447453670203686, 0.0446411855518818, 0.0445371270179749, 0.044433232396841, 0.0443295538425446, 0.0442260801792145, 0.0441228151321411, 0.0440196804702282, 0.0439167097210884, 0.0438139922916889, 0.0437113977968693, 0.0436088927090168, 0.043506633490324, 0.0434045866131783, 0.0433027446269989, 0.0432011187076569, 0.0430995710194111, 0.0429982356727123, 0.0428971089422703, 0.0427961498498917, 0.0426952764391899, 0.0425947345793247, 0.0424943268299103, 0.0423940755426884, 0.0422940403223038, 0.0421941690146923, 0.0420944690704346, 0.04199493303895, 0.0418954789638519, 0.0417963638901711, 0.0416973792016506, 0.0415985994040966, 0.0414999835193157, 0.0414015389978886, 0.0413032621145248, 0.0412052348256111, 0.0411072075366974, 0.0410096049308777, 0.0409120358526707, 0.0408146791160107, 0.0407174490392208, 0.0406205505132675, 0.0405236966907978, 0.0404270142316818, 0.0403305403888226, 0.0402342714369297, 0.0401382148265839, 0.0400422848761082, 0.0399465188384056, 0.0398510433733463, 0.0397556610405445, 0.0396604798734188, 0.0395654700696468, 0.0394705906510353, 0.0393759533762932, 0.0392815321683884, 0.0391872748732567, 0.0390931032598019, 0.0389992222189903, 0.0389055162668228, 0.0388118401169777, 0.0387184247374535, 0.0386252589523792, 0.0385321751236916, 0.0384393893182278, 0.0383467637002468, 0.038254264742136, 0.0381620191037655, 0.0380699038505554, 0.0379778668284416, 0.0378861241042614, 0.0377945490181446, 0.0377031825482845, 0.0376119837164879, 0.0375209115445614, 0.0374300926923752, 0.0373393930494785, 0.0372488647699356, 0.0371585488319397, 0.0370684005320072, 0.0369784571230412, 0.0368886850774288, 0.0367991216480732, 0.036709725856781, 0.0366205759346485, 0.036531388759613, 0.0364424549043179, 0.036353811621666, 0.0362653397023678, 0.0361770316958427, 0.0360888876020908, 0.036000918596983, 0.0359131097793579, 0.0358255617320538, 0.035738006234169, 0.0356508754193783, 0.0355637781322002, 0.0354768522083759, 0.0353902205824852, 0.0353036746382713, 0.0352173335850239, 0.035131249576807, 0.0350451208651066, 0.0349593237042427, 0.0348736979067326, 0.0347883217036724, 0.0347030349075794, 0.0346179492771626, 0.0345331206917763, 0.0344483740627766, 0.0343637503683567, 0.0342794246971607, 0.0341952666640282, 0.0341112725436687, 0.034027487039566, 0.0339438728988171, 0.0338603816926479, 0.0337771438062191, 0.0336940735578537, 0.0336110889911652, 0.0335283912718296, 0.0334458239376545, 0.0333634652197361, 0.0332812741398811, 0.0331992506980896, 0.0331174358725548, 0.033035833388567, 0.0329542681574821, 0.0328730009496212, 0.0327919386327267, 0.032710961997509, 0.0326302796602249, 0.0325497202575207, 0.0324692875146866, 0.0323891937732697, 0.0323090106248856, 0.0322292074561119, 0.0321494862437248, 0.032070018351078, 0.0319908000528812, 0.031911626458168, 0.0318327061831951, 0.0317540317773819, 0.0316753163933754, 0.0315969400107861, 0.0315186865627766, 0.0314406827092171, 0.0313628911972046, 0.0312851816415787, 0.0312077235430479, 0.0311304330825806, 0.0310531444847584, 0.0309762731194496, 0.0308994855731726, 0.0308228228241205, 0.0307464990764856, 0.0306702554225922, 0.0305942222476006, 0.0305183995515108, 0.0304425749927759, 0.0303722061216831, 0.0303076840937138, 0.0302431806921959, 0.0301789194345474, 0.0301146879792213, 0.0300505626946688, 0.0299866273999214, 0.0299227647483349, 0.0298589300364256, 0.0297952778637409, 0.0297316964715719, 0.029668303206563, 0.0296049416065216, 0.0295416843146086, 0.0294785443693399, 0.0294155906885862, 0.0293526072055101, 0.0292898342013359, 0.0292270798236132, 0.0291645247489214, 0.029102073982358, 0.0290396586060524, 0.0289774145931005, 0.0289152190089226, 0.0288531966507435, 0.0287912916392088, 0.0287294164299965, 0.0286677218973637, 0.0286061428487301, 0.0285445917397738, 0.0284832324832678, 0.028421975672245, 0.0283607505261898, 0.0282997135072947, 0.0282387118786573, 0.0281778518110514, 0.0281171388924122, 0.0280564595013857, 0.027995927259326, 0.0279355514794588, 0.0278751961886883, 0.0278150290250778, 0.0277549754828215, 0.0276948623359203, 0.0276350304484367, 0.0275752414017916, 0.027515621855855, 0.0274560917168856, 0.0273965615779161, 0.0273372754454613, 0.0272780526429415, 0.0272188913077116, 0.0271599292755127, 0.0271009877324104, 0.0270421598106623, 0.0269835237413645, 0.0269248224794865, 0.0268664676696062, 0.0268081109970808, 0.0267498306930065, 0.0266916956752539, 0.0266336649656296, 0.0265757087618113, 0.0265179090201855, 0.0264601185917854, 0.0264025721698999, 0.0263450536876917, 0.0262876413762569, 0.026230376213789, 0.0261732153594494, 0.0261161271482706, 0.0260591525584459, 0.0260022841393948, 0.025945607572794, 0.0258889589458704, 0.0258324164897203, 0.0257759764790535, 0.0257197376340628, 0.0256634447723627, 0.0256073754280806, 0.0255514159798622, 0.025495532900095, 0.0254397969692945, 0.0253840815275908, 0.0253285225480795, 0.0252731516957283, 0.0252177622169256, 0.0251625701785088, 0.0251074396073818, 0.0250524263828993, 0.0249975174665451, 0.0249427631497383, 0.0248880311846733, 0.0248334482312202, 0.0247789788991213, 0.0247246138751507, 0.0246704053133726, 0.0246162079274654, 0.0245621670037508, 0.0245083272457123, 0.0244544241577387, 0.0244007185101509, 0.0243471171706915, 0.0242936238646507, 0.0242402423173189, 0.0241868831217289, 0.0241338051855564, 0.0240807514637709, 0.0240277145057917, 0.0239749625325203, 0.023922149091959, 0.0238695330917835, 0.0238170530647039, 0.0237645730376244, 0.0237123128026724, 0.0236601289361715, 0.0236079730093479, 0.0235560052096844, 0.0235041547566652, 0.0234524067491293, 0.023400766775012, 0.0233491435647011, 0.0232977662235498, 0.0232464168220758, 0.0231951717287302, 0.0231441166251898, 0.0230931229889393, 0.0230421628803015, 0.0229913908988237, 0.0229407325387001, 0.0228901486843824, 0.0228396616876125, 0.0227892845869064, 0.0227391086518764, 0.0226889420300722, 0.02263886295259, 0.0225889608263969, 0.0225391704589128, 0.0224894564598799, 0.0224398467689753, 0.0223902985453606, 0.0223409831523895, 0.0222917385399342, 0.0222425255924463, 0.0221934616565704, 0.0221445430070162, 0.022095687687397, 0.0220469012856483, 0.0219982769340277, 0.0219497568905354, 0.0219013802707195, 0.0218530390411615, 0.0218048840761185, 0.0217568352818489, 0.0217088162899017, 0.0216609872877598, 0.0216131899505854, 0.0215654950588942, 0.0215179920196533, 0.0214705150574446, 0.0214232318103313, 0.0213760621845722, 0.0213288273662329, 0.0212818793952465, 0.0212350338697433, 0.0211882088333368, 0.021141542121768, 0.0210948865860701, 0.0210484806448221, 0.0210021790117025, 0.0209558568894863, 0.0209097769111395, 0.0208637584000826, 0.0208178032189608, 0.0207720063626766, 0.0207263212651014, 0.0206806939095259, 0.0206352323293686, 0.0205898620188236, 0.0205445662140846, 0.0204994175583124, 0.0204543005675077, 0.0204094126820564, 0.0203645881265402, 0.0203197970986366, 0.0202752444893122, 0.0202307049185038, 0.0201862901449203, 0.0201419666409492, 0.0200977623462677, 0.0200537443161011, 0.0200097672641277, 0.0199658870697021, 0.0199221111834049, 0.0198784470558167, 0.0198349338024855, 0.0197915323078632, 0.0197481550276279, 0.0197049658745527, 0.0196618884801865, 0.019618846476078, 0.0195759367197752, 0.0195331983268261, 0.019490510225296, 0.0194479897618294, 0.0194054823368788, 0.0193631295114756, 0.0193209126591682, 0.0192787367850542, 0.0192367527633905, 0.0191948711872101, 0.0191530212759972, 0.0191113166511059, 0.0190697740763426, 0.0190282054245472, 0.0189868677407503, 0.0189455840736628, 0.0189044792205095, 0.0188634674996138, 0.0188224464654922, 0.0187816638499498, 0.0187409464269876, 0.0187002383172512, 0.0186597798019648, 0.0186194088310003, 0.0185790341347456, 0.0185389015823603, 0.0184987485408783, 0.0184588581323624, 0.0184190515428782, 0.0183792319148779, 0.0183396022766829, 0.0183000769466162, 0.0182606168091297, 0.0182213522493839, 0.0181820802390575, 0.0181429944932461, 0.0181040447205305, 0.0180650986731052, 0.0180263388901949, 0.0179876089096069, 0.0179491117596626, 0.0179106742143631, 0.0178722701966763, 0.0178340971469879, 0.0177959427237511, 0.0177579056471586, 0.017720015719533, 0.0176822394132614, 0.0176444854587317, 0.0176069289445877, 0.0175694674253464, 0.0175320897251368, 0.0174948070198298, 0.0174576379358768, 0.0174206271767616, 0.0173836797475815, 0.0173468347638845, 0.017310107126832, 0.0172735247761011, 0.017236964777112, 0.0172006022185087, 0.0171643551439047, 0.0171281173825264, 0.0170920826494694, 0.0170560758560896, 0.017020259052515, 0.0169845465570688, 0.0169488657265902, 0.016913328319788, 0.0168779417872429, 0.0168425440788269, 0.0168073754757643, 0.0167722404003143, 0.0167372487485409, 0.0167024154216051, 0.0166676044464111, 0.0166329815983772, 0.0165984742343426, 0.0165639445185661, 0.016529643908143, 0.0164953358471394, 0.0164612270891666, 0.0164272505789995, 0.0163932777941227, 0.0163595229387283, 0.0163258835673332, 0.0162922255694866, 0.0162587631493807, 0.016225365921855, 0.0161921661347151, 0.0161590296775103, 0.0161259155720472, 0.0160930398851633, 0.0160602293908596, 0.0160274486988783, 0.0159948989748955, 0.0159623697400093, 0.0159299559891224, 0.0158976893872023, 0.0158655382692814, 0.0158334486186504, 0.0158015061169863, 0.0157695841044188, 0.0157379154115915, 0.0157062560319901, 0.0156747121363878, 0.0156433247029781, 0.0156120304018259, 0.0155807808041573, 0.0155497062951326, 0.0155186643823981, 0.0154878217726946, 0.0154570853337646, 0.0154264094308019, 0.015395849943161, 0.0153654357418418, 0.0153350429609418, 0.015304840169847, 0.0152746774256229, 0.0152446944266558, 0.0152148250490427, 0.0151849873363972, 0.015155297704041, 0.0151257533580065, 0.0150962416082621, 0.0150669161230326, 0.0150376129895449, 0.0150084681808949, 0.0149794789031148, 0.0149504998698831, 0.014921679161489, 0.0148930046707392, 0.0148643599823117, 0.0148358624428511, 0.0148075241595507, 0.0147792045027018, 0.0147510329261422, 0.0147229870781302, 0.0146950352936983, 0.0146672390401363, 0.0146394241601229, 0.0146117955446243, 0.014584326185286, 0.0145568335428834, 0.0145295839756727, 0.0145024377852678, 0.014475230127573, 0.0144483037292957, 0.0144214406609535, 0.0143946502357721, 0.0143680507317185, 0.0143414391204715, 0.0143150147050619, 0.0142886973917484, 0.0142624517902732, 0.0142363542690873, 0.014210369437933, 0.014184407889843, 0.0141586754471064, 0.014132933691144, 0.0141073679551482, 0.0140819307416677, 0.0140565540641546, 0.0140313245356083, 0.0140061276033521, 0.0139811187982559, 0.0139562245458364, 0.0139313507825136, 0.013906667008996, 0.0138820968568325, 0.0138575481250882, 0.0138331884518266, 0.0138089442625642, 0.0137847308069468, 0.0137606943026185, 0.0137366913259029, 0.0137128867208958, 0.013689186424017, 0.0136655066162348, 0.0136419851332903, 0.0136186089366674, 0.0135952653363347, 0.013572109863162, 0.0135490596294403, 0.013526039198041, 0.0135031659156084, 0.0134803783148527, 0.0134577667340636, 0.0134352697059512, 0.0134127959609032, 0.0133904684334993, 0.0133682861924171, 0.0133460937067866, 0.0133241424337029, 0.0133022964000702, 0.0132804280146956, 0.0132587915286422, 0.0132371447980404, 0.0132157383486629, 0.0131944250315428, 0.0131731135770679, 0.0131519790738821, 0.0131310019642115, 0.0131100146099925, 0.0130892572924495, 0.0130684785544872, 0.0130478879436851, 0.0130274556577206, 0.0130070131272078, 0.012986758723855, 0.0129665667191148, 0.0129465321078897, 0.0129266334697604, 0.0129067357629538, 0.0128870252519846, 0.0128674609586596, 0.0128478454425931, 0.0128285028040409, 0.0128092216327786, 0.0127899721264839, 0.0127709116786718, 0.012751966714859, 0.0127330431714654, 0.0127143170684576, 0.0126956533640623, 0.012677138671279, 0.0126587375998497, 0.0126403467729688, 0.0126221645623446, 0.0126040782779455, 0.0125860339030623, 0.0125681664794683, 0.0125504266470671, 0.012532695196569, 0.0125151220709085, 0.0124976634979248, 0.0124802989885211, 0.0124630928039551, 0.0124459592625499, 0.0124289309605956, 0.012412047944963, 0.012395185418427, 0.0123784821480513, 0.0123618515208364, 0.0123454080894589, 0.0123290717601776, 0.0123127223923802, 0.0122966049239039, 0.0122806020081043, 0.0122645786032081, 0.0122487852349877, 0.0122330244630575, 0.0122174089774489, 0.0122019406408072, 0.0121865030378103, 0.0121712237596512, 0.0121560795232654, 0.0121409259736538, 0.012125969864428, 0.0121111199259758, 0.0120963742956519, 0.0120817432180047, 0.0120671326294541, 0.012052764184773, 0.0120385009795427, 0.0120242154225707, 0.0120101291686296, 0.0119961900636554, 0.0119822407141328, 0.0119684785604477, 0.0119548225775361, 0.0119412280619144, 0.0119277918711305, 0.0119143864139915, 0.0119012119248509, 0.0118880569934845, 0.0118750175461173, 0.0118621373549104, 0.0118493502959609, 0.0118365939706564, 0.0118240788578987, 0.0118114901706576, 0.011799193918705, 0.0117869097739458, 0.0117747401818633, 0.0117627177387476, 0.0117508098483086, 0.0117389233782887, 0.0117272362112999, 0.0117155686020851, 0.0117040909826756, 0.0116926860064268, 0.0116813853383064, 0.0116702420637012, 0.0116591611877084, 0.0116481548175216, 0.0116373263299465, 0.0116265276446939, 0.0116159291937947, 0.0116010690107942, 0.0115819629281759, 0.0115628894418478, 0.011543839238584, 0.0115248207002878, 0.0115058282390237, 0.0114868674427271, 0.0114679262042046, 0.011449009180069, 0.0114301163703203, 0.0114112552255392, 0.0113924276083708, 0.0113736130297184, 0.0113548403605819, 0.0113360807299614, 0.0113173630088568, 0.0112986583262682, 0.0112799853086472, 0.0112613383680582, 0.0112427221611142, 0.0112241273745894, 0.0112055689096451, 0.0111870327964425, 0.0111685059964657, 0.0111500238999724, 0.0111315650865436, 0.0111131388694048, 0.0110947359353304, 0.0110763534903526, 0.0110580073669553, 0.0110396798700094, 0.0110213775187731, 0.0110031077638268, 0.0109848594292998, 0.0109666474163532, 0.010948465205729, 0.0109302951022983, 0.0109121613204479, 0.0108940480276942, 0.0108759561553597, 0.0108579099178314, 0.0108398823067546, 0.0108218817040324, 0.010803903453052, 0.0107859577983618, 0.0107680335640907, 0.0107501540333033, 0.0107322838157415, 0.0107144387438893, 0.0106966271996498, 0.0106788361445069, 0.0106610786169767, 0.0106433220207691, 0.0106256119906902, 0.0106079308316112, 0.0105902776122093, 0.0105726541951299, 0.0105550521984696, 0.0105374958366156, 0.0105199506506324, 0.0105024306103587, 0.0104849301278591, 0.0104674613103271, 0.0104500288143754, 0.010432617738843, 0.0104152271524072, 0.0103978645056486, 0.0103805307298899, 0.0103632295504212, 0.0103459544479847, 0.010328690521419, 0.0103114675730467, 0.010294271633029, 0.0102770933881402, 0.0102599486708641, 0.0102428290992975, 0.0102257421240211, 0.0102086756378412, 0.0101916417479515, 0.0101746236905456, 0.0101576456800103, 0.0101406807079911, 0.0101237511262298, 0.010106842033565, 0.0100899683311582, 0.0100731151178479, 0.0100562954321504, 0.010039497166872, 0.0100227231159806, 0.0100059816613793, 0.00998927373439074, 0.00997257418930531, 0.00995591282844543, 0.00993928126990795, 0.00992267206311226, 0.00990607775747776, 0.00988952815532684, 0.00987299624830484, 0.00985649786889553, 0.00984002463519573, 0.00982357375323772, 0.00980715546756983, 0.00979075953364372, 0.00977438502013683, 0.0097580486908555, 0.00974172912538052, 0.00972544588148594, 0.00970918498933315, 0.00969294365495443, 0.0096767395734787, 0.00966055411845446, 0.00964440125972033, 0.00962827540934086, 0.00961217936128378, 0.00959610939025879, 0.00958005618304014, 0.00956404209136963, 0.00954804569482803, 0.00953207444399595, 0.00951613672077656, 0.00950022041797638, 0.00948433857411146, 0.00946847815066576, 0.00945264101028442, 0.00943683367222548, 0.00942106358706951, 0.00940530560910702, 0.00938958767801523, 0.00937388464808464, 0.00935821421444416, 0.0093425652012229, 0.00932695250958204, 0.00931135844439268, 0.00929578766226768, 0.00928025040775537, 0.00926474574953318, 0.00924925412982702, 0.00923380628228188, 0.00921836961060762, 0.00920296646654606, 0.00918758660554886, 0.0091722384095192, 0.00915691442787647, 0.00914162397384644, 0.00912634655833244, 0.00911110546439886, 0.00909589417278767, 0.00908070337027311, 0.0090655330568552, 0.00905039999634027, 0.00903529487550259, 0.00902021676301956, 0.00900515913963318, 0.00899012573063374, 0.00897512305527925, 0.00896015483886003, 0.00894520245492458, 0.00893027801066637, 0.00891538802534342, 0.00890051946043968, 0.00888567417860031, 0.00887086242437363, 0.00885607488453388, 0.00884131621569395, 0.00882658362388611, 0.0088118826970458, 0.00879719108343124, 0.00878254696726799, 0.00876791682094336, 0.00875331461429596, 0.00873873755335808, 0.00872419495135546, 0.0087096719071269, 0.00869518611580133, 0.00868071708828211, 0.00866627506911755, 0.00865186378359795, 0.00863748788833618, 0.00862312130630016, 0.00860878918319941, 0.00859450176358223, 0.00858020316809416, 0.00856594927608967, 0.00855172798037529, 0.00853753183037043, 0.00852335430681705, 0.00850921310484409, 0.00849510077387094, 0.00848100427538157, 0.00846693851053715, 0.00845290813595057, 0.00843889731913805, 0.00842491071671247, 0.0084109716117382, 0.00839703995734453, 0.0083831325173378, 0.00836924463510513, 0.00835539493709803, 0.00834157317876816, 0.00832777749747038, 0.00831400323659182, 0.00830026250332594, 0.0082865534350276, 0.00827285833656788, 0.00825919397175312, 0.00824557617306709, 0.00823196955025196, 0.00821838341653347, 0.00820483360439539, 0.0081913024187088, 0.0081778084859252, 0.00816431455314159, 0.00815086159855127, 0.00813744310289621, 0.00812404789030552, 0.00811068713665009, 0.00809734500944614, 0.00808406341820955, 0.00807078089565039, 0.00805751699954271, 0.00804428942501545, 0.00803107302635908, 0.00801790039986372, 0.00800474919378757, 0.00799162127077579, 0.00797850638628006, 0.00796543434262276, 0.00795238465070724, 0.00793936941772699, 0.007926388643682, 0.00791342556476593, 0.00790048949420452, 0.00788757298141718, 0.00787469185888767, 0.00786183122545481, 0.00784900411963463, 0.00783620122820139, 0.00782341882586479, 0.00781067041680217, 0.00779794342815876, 0.0077852294780314, 0.00777257047593594, 0.00775992451235652, 0.00774730974808335, 0.00773471593856812, 0.00772215891629457, 0.00770962052047253, 0.00769710773602128, 0.00768462661653757, 0.00767217995598912, 0.00765974260866642, 0.00764734065160155, 0.00763497222214937, 0.00762261403724551, 0.00761029031127691, 0.00759799778461456, 0.00758572854101658, 0.00757348351180553, 0.0075612710788846, 0.00754907913506031, 0.00753692211583257, 0.00752478651702404, 0.00751267466694117, 0.00750059681013227, 0.0074885506182909, 0.00747651699930429, 0.00746451504528522, 0.0074525373056531, 0.00744059262797236, 0.00742866890504956, 0.00741677964106202, 0.00740491366013885, 0.0073930686339736, 0.00738125573843718, 0.00736947869881988, 0.00735771236941218, 0.00734597770497203, 0.00733427703380585, 0.00732259172946215, 0.00731093576177955, 0.00729931565001607, 0.00728771416470408, 0.0072761494666338, 0.007264603395015, 0.00725308293476701, 0.00724159460514784, 0.00723012909293175, 0.00721868732944131, 0.00720727490261197, 0.00719590066000819, 0.00718453852459788, 0.00717320386320353, 0.00716189574450254, 0.00715061882510781, 0.00713936612010002, 0.00712814694270492, 0.00711694592610002, 0.0071057821623981, 0.00709463888779283, 0.00708352169021964, 0.00707243382930756, 0.00706136878579855, 0.0070503382012248, 0.0070393206551671, 0.00702833477407694, 0.00701738288626075, 0.00700645195320249, 0.00699555454775691, 0.00698468089103699, 0.00697382912039757, 0.00696301041170955, 0.00695221498608589, 0.00694145169109106, 0.00693071214482188, 0.00691999262198806, 0.00690929964184761, 0.00689863879233599, 0.00688800821080804, 0.00687740230932832, 0.00686681875959039, 0.00685626501217484, 0.00684574013575912, 0.00683524087071419, 0.00682476768270135, 0.00681431591510773, 0.0068039009347558, 0.00679350644350052, 0.00678313570097089, 0.00677279569208622, 0.00676247989758849, 0.00675219856202602, 0.00674193818122149, 0.00673171086236835, 0.00672150496393442, 0.00671132048591971, 0.00670117186382413, 0.00669105490669608, 0.00668095145374537, 0.0066708792001009, 0.0066608302295208, 0.00665081571787596, 0.00664082216098905, 0.00663086213171482, 0.00662092631682754, 0.00661101099103689, 0.00660112965852022, 0.00659126928076148, 0.006581443361938, 0.0065716402605176, 0.0065618590451777, 0.00655211135745049, 0.00654238695278764, 0.00653268396854401, 0.00652302242815495, 0.00651337718591094, 0.00650376314297318, 0.00649417238309979, 0.00648461328819394, 0.00647507794201374, 0.00646556308493018, 0.00645608268678188, 0.00644663628190756, 0.00643720291554928, 0.00642780074849725, 0.00641841953620315, 0.00640907464548945, 0.00639975164085627, 0.00639046216383576, 0.00638119131326675, 0.00637195678427815, 0.00636273482814431, 0.0063535557128489, 0.00634438684210181, 0.00633526220917702, 0.00632615340873599, 0.00631707301363349, 0.00630804011598229, 0.00629900489002466, 0.00629000645130873, 0.00628103595227003, 0.00627207104116678, 0.00626314850524068, 0.00625426229089499, 0.0062453942373395, 0.00623656017705798, 0.00622775033116341, 0.00621896050870419, 0.00621020514518023, 0.00620148377493024, 0.0061927861534059, 0.00618410669267178, 0.00617545377463102, 0.00616683159023523, 0.00615823362022638, 0.00614965613931417, 0.00614111311733723, 0.00613260362297297, 0.0061241053044796, 0.00611565075814724, 0.00610720692202449, 0.00609880965203047, 0.00609042402356863, 0.00608206167817116, 0.00607372773811221, 0.00606542034074664, 0.00605714414268732, 0.00604890426620841, 0.00604068301618099, 0.00603248551487923, 0.00602431083098054, 0.00601616874337196, 0.00600805971771479, 0.00599997490644455, 0.00599192129448056, 0.00598388072103262, 0.00597587414085865, 0.00596789922565222, 0.00595992663875222, 0.00595199596136808, 0.00594409927725792, 0.00593622634187341, 0.00592837436124682, 0.00592055590823293, 0.00591276166960597, 0.00590499863028526, 0.00589726958423853, 0.00588955404236913, 0.00588186690583825, 0.00587420584633946, 0.00586657645180821, 0.00585897034034133, 0.00585137726739049, 0.00584381585940719, 0.00583629915490746, 0.00582879269495606, 0.00582132022827864, 0.00581388175487518, 0.0058064772747457, 0.00579908117651939, 0.00579172093421221, 0.00578438257798553, 0.00577706750482321, 0.00576978316530585, 0.00576252304017544, 0.00575529644265771, 0.0057480912655592, 0.00574089912697673, 0.00573374889791012, 0.00572662428021431, 0.00571954250335693, 0.00571247283369303, 0.0057054222561419, 0.00569840846583247, 0.00569141702726483, 0.00568445725366473, 0.00567751936614513, 0.00567061547189951, 0.00566373486071825, 0.00565687473863363, 0.00565004907548428, 0.00564322574064136, 0.0056364550255239, 0.00562971085309982, 0.00562299508601427, 0.00561629189178348, 0.00560962408781052, 0.00560298934578896, 0.00559637602418661, 0.00558978272601962, 0.0055832271464169, 0.00557669159024954, 0.005570188164711, 0.00556371035054326, 0.00555725116282701, 0.00555082131177187, 0.00554441940039396, 0.00553805194795132, 0.00553169008344412, 0.00552537944167852, 0.00551909068599343, 0.00551282009109855, 0.00550657557323575, 0.00550036504864693, 0.00549418665468693, 0.00548801757395267, 0.00548189645633101, 0.00547577766701579, 0.00546970078721642, 0.00546365231275558, 0.0054576201364398, 0.00545163219794631, 0.0054456521756947, 0.00543971126899123, 0.00543379690498114, 0.00542790070176125, 0.00542204361408949, 0.0054162023589015, 0.0054103871807456, 0.0054046013392508, 0.00539884902536869, 0.00539019564166665, 0.00537859695032239, 0.00536698289215565, 0.00535538885742426, 0.00534378504380584, 0.00533219706267118, 0.00532059790566564, 0.00530901504680514, 0.0052974266000092, 0.00528584886342287, 0.0052742762491107, 0.00526269339025021, 0.00525113102048635, 0.00523955887183547, 0.00522799650207162, 0.00521642947569489, 0.00520487269386649, 0.00519331078976393, 0.00518176937475801, 0.0051702125929296, 0.00515867630019784, 0.00514712510630488, 0.00513559440150857, 0.0051240585744381, 0.00511252274736762, 0.00510099716484547, 0.00508946646004915, 0.00507795158773661, 0.00506642088294029, 0.00505491113290191, 0.00504339626058936, 0.00503189163282514, 0.00502038188278675, 0.00500888284295797, 0.00499737821519375, 0.00498588429763913, 0.00497439596801996, 0.00496290111914277, 0.00495141791179776, 0.00493992958217859, 0.00492845615372062, 0.00491697248071432, 0.00490550464019179, 0.00489403167739511, 0.00488256895914674, 0.00487110111862421, 0.00485964398831129, 0.00484819198027253, 0.00483673438429832, 0.00482528749853373, 0.00481383549049497, 0.00480239884927869, 0.00479095196351409, 0.0047795157879591, 0.00476807914674282, 0.00475665368139744, 0.00474521704018116, 0.0047338018193841, 0.00472237542271614, 0.00471097091212869, 0.00469954963773489, 0.00468814512714744, 0.00467673456296325, 0.00466533517464995, 0.00465392461046576, 0.00464252009987831, 0.0046311360783875, 0.00461973575875163, 0.00460835685953498, 0.00459696305915713, 0.00458558928221464, 0.00457420526072383, 0.00456284219399095, 0.00455146329477429, 0.00454010022804141, 0.00452873157337308, 0.0045173685066402, 0.00450600543990731, 0.00449465867131948, 0.00448330026119947, 0.00447195814922452, 0.00446060579270124, 0.00444926880300045, 0.0044379266910255, 0.0044265897013247, 0.00441526854410768, 0.00440392643213272, 0.00439261039718986, 0.00438128411769867, 0.00436996296048164, 0.00435864692553878, 0.00434734113514423, 0.00433601997792721, 0.00432471977546811, 0.00431341445073485, 0.00430211937054992, 0.00429082429036498, 0.00427952921018004, 0.00426823925226927, 0.00425694976001978, 0.00424567051231861, 0.004234385676682, 0.00422311201691628, 0.00421183230355382, 0.00420056888833642, 0.00418930035084486, 0.00417803646996617, 0.00416677817702293, 0.00415551988407969, 0.00414427183568478, 0.00413301354274154, 0.00412177620455623, 0.00411052303388715, 0.00409928569570184, 0.00408804276958108, 0.00407681614160538, 0.00406557880342007, 0.00405435683205724, 0.00404312461614609, 0.00403190823271871, 0.00402069184929132, 0.00400947500020266, 0.00399826932698488, 0.0039870529435575, 0.00397585704922676, 0.00396465137600899, 0.00395345594733953, 0.00394225493073463, 0.00393106462433934, 0.00391987944021821, 0.00390869472175837, 0.00389750953763723, 0.00388633483089507, 0.00387516035698354, 0.00386398565024137, 0.00385282142087817, 0.00384164694696665, 0.00383049342781305, 0.00381932919844985, 0.00380817567929626, 0.00379702192731202, 0.00378587888553739, 0.00377472536638379, 0.00376358721405268, 0.00375243905000389, 0.00374130601994693, 0.00373018393293023, 0.0037190462462604, 0.00370792369358242, 0.00369679648429155, 0.00368568464182317, 0.00367456232197583, 0.00366345071233809, 0.00365233886986971, 0.00364123773761094, 0.00363012589514256, 0.00361903524026275, 0.00360793899744749, 0.00359684298746288, 0.00358575745485723, 0.00357466144487262, 0.00356358103454113, 0.00355250085704029, 0.00354142556898296, 0.00353035051375628, 0.0035192808136344, 0.00350821088068187, 0.00349715142510831, 0.00348608172498643, 0.00347503274679184, 0.00346398400142789, 0.00345292454585433, 0.0034418860450387, 0.0034308317117393, 0.00341979879885912, 0.00340875494293869, 0.00339772179722786, 0.00338668865151703, 0.00337566598318517, 0.00336463819257915, 0.00335362041369081, 0.00334259262308478, 0.0033315853215754, 0.00332057848572731, 0.00330956117250025, 0.00329856434836984, 0.00328755751252174, 0.00327656092122197, 0.00326556456275284, 0.00325457844883204, 0.00324358162470162, 0.00323260109871626, 0.00322160962969065, 0.00321063934825361, 0.00319966906681657, 0.00318868807516992, 0.0031777280382812, 0.00316675240173936, 0.00315579795278609, 0.00314483302645385, 0.00313387811183929, 0.00312292343005538, 0.00311197922565043, 0.00310103013180196, 0.00309009081684053, 0.00307914684526622, 0.00306821311824024, 0.00305728474631906, 0.00304634589701891, 0.00303542241454124, 0.00302449939772487, 0.00301358662545681, 0.00300266314297915, 0.00299175037071109, 0.00298083759844303, 0.00296993553638458, 0.00295902788639069, 0.0029481309466064, 0.00293723912909627, 0.00292634731158614, 0.00291545549407601, 0.00290456367656589, 0.00289368233643472, 0.00288280099630356, 0.00287192477844656, 0.0028610487934202, 0.002850177930668, 0.0028393070679158, 0.00282844644971192, 0.00281758094206452, 0.00280673638917506, 0.00279587600380182, 0.00278503121808171, 0.00277417595498264, 0.00276333675719798, 0.00275249197147787, 0.00274165789596736, 0.00273081846535206, 0.00271998927928507, 0.00270916032604873, 0.00269834185019135, 0.00268751289695501, 0.00267668371088803, 0.00266588642261922, 0.0026550677139312, 0.00264426507055759, 0.00263345171697438, 0.00262265955097973, 0.00261185644194484, 0.00260106427595019, 0.00259026698768139, 0.00257948506623507, 0.00256869243457913, 0.00255791074596345, 0.00254712905734777, 0.00253635761328042, 0.00252559129148722, 0.0025148147251457, 0.00250405399128795, 0.00249328254722059, 0.00248253205791116, 0.00247177109122276, 0.00246102618984878, 0.00245027034543455, 0.00243952521122992, 0.00242877984419465, 0.00241804518736899, 0.00240731053054333, 0.00239657051861286, 0.00238584098406136, 0.0023751116823405, 0.00236439262516797, 0.00235366821289062, 0.00234295474365354, 0.00233224080875516, 0.00232153735123575, 0.00231082388199866, 0.0023001201916486, 0.00228941696695983, 0.00227872445248067, 0.00226803147234023, 0.00225733872503042, 0.00224665622226894, 0.00223596324212849, 0.00222529144957662, 0.00221460917964578, 0.0022039373870939, 0.00219326023943722, 0.00218259892426431, 0.00217193202115595, 0.00216127070598304, 0.00215060939081013, 0.00213995832018554, 0.0021293074823916, 0.00211865641176701, 0.00210801605135202, 0.00209737033583224, 0.00208673509769142, 0.00207609450444579, 0.00206547509878874, 0.00205483473837376, 0.00204421509988606, 0.0020335903391242, 0.00202297628857195, 0.00201236177235842, 0.00200174748897552, 0.00199113856069744, 0.0019805293995887, 0.00196993094868958, 0.00195933226495981, 0.00194873905275017, 0.0019381403690204, 0.00192755763418972, 0.00191696942783892, 0.00190638669300824, 0.00189580372534692, 0.00188523135147989, 0.00187465909402817, 0.00186408660374582, 0.00185352459084243, 0.00184295757208019, 0.00183240091428161, 0.0018218441400677, 0.00181129795964807, 0.00180074118543416, 0.00179019512142986, 0.00177964882459491, 0.00176911312155426, 0.0017585774185136, 0.00174804171547294, 0.00173751637339592, 0.00172698067035526, 0.00171646580565721, 0.00170594057999551, 0.00169542571529746, 0.00168491108343005, 0.00167440669611096, 0.00166389194782823, 0.00165338756050915, 0.00164288328960538, 0.00163238949608058, 0.00162190082482994, 0.00161140179261565, 0.00160091847646981, 0.00159042980521917, 0.00157995685003698, 0.00156946829520166, 0.00155900593381375, 0.00154852773994207, 0.00153806013986468, 0.00152759766206145, 0.00151713530067354, 0.00150667282287031, 0.00149622082244605, 0.00148577417712659, 0.00147531693801284, 0.00146488065365702, 0.00145443400833756, 0.00144400307908654, 0.00143356143962592, 0.0014231305103749, 0.00141269946470857, 0.00140227901283652, 0.00139185308944434, 0.00138143799267709, 0.00137102790176868, 0.00136060721706599, 0.00135020248126239, 0.0013397871516645, 0.00132939801551402, 0.00131898804102093, 0.00130859890487045, 0.00129819929134101, 0.00128781551029533, 0.00127742625772953, 0.00126704771537334, 0.00125666381791234, 0.00124629039783031, 0.0012359170941636, 0.00122554355766624, 0.00121518061496317, 0.00120481254998595, 0.001194465206936, 0.00118409714195877, 0.00117374991532415, 0.00116339221131057, 0.00115305546205491, 0.00114270823542029, 0.00113237148616463, 0.00112203473690897, 0.0011117032263428, 0.00110137171577662, 0.00109104544389993, 0.00108071917202324, 0.00107040337752551, 0.0010600823443383, 0.00104977167211473, 0.00103945599403232, 0.0010291401995346, 0.00101884524337947, 0.00100853992626071, 0.00099824508652091, 0.000987950246781111, 0.000977665884420276, 0.000967370986472815, 0.000957091862801462, 0.000946807500440627, 0.000936533557251096, 0.000926254375372082, 0.000915990967769176, 0.000905711785890162, 0.000895453616976738, 0.000885190151166171, 0.000874937162734568, 0.000864678993821144, 0.00085442082490772, 0.000844178313855082, 0.000833930564112961, 0.000823693291749805, 0.000813450838904828, 0.000803218805231154, 0.000792976352386177, 0.000782754796091467, 0.000772522704210132, 0.000762311683502048, 0.000752079649828374, 0.000741868570912629, 0.000731657491996884, 0.000721446413081139, 0.000711245811544359, 0.000701040029525757, 0.000690844666678458, 0.000680644006934017, 0.000670453882776201, 0.000660258519928902, 0.000650078873150051, 0.000639888748992234, 0.000629714340902865, 0.000619539874605834, 0.000609365466516465, 0.000599196297116578, 0.00058902712771669, 0.000578868435695767, 0.00056869926629588, 0.000558550993446261, 0.000548392301425338, 0.000538244028575718, 0.00052809581393376, 0.000517958076670766, 0.000507809803821146, 0.000497672066558152, 0.000487544748466462, 0.000477407011203468, 0.00046728493180126, 0.000457157642813399, 0.000447040831204504, 0.000436918780906126, 0.000426812417572364, 0.000416695605963469, 0.000406589271733537, 0.000396482937503606, 0.000386387051548809, 0.000376280688215047, 0.000366184860467911, 0.000356099422788247, 0.000346008804626763, 0.000335928634740412, 0.000325843226164579, 0.000315768324071541, 0.000305693392874673, 0.000295618432573974, 0.000285543530480936, 0.000275489554041997, 0.00026541986153461, 0.000255371094681323, 0.000245311908656731, 0.000235257903113961, 0.000225209165364504, 0.000215165666304529, 0.000205122152692638, 0.000195078639080748, 0.000185050841537304, 0.000175012581166811, 0.000164990007760935, 0.000154956986079924, 0.000144939651363529, 0.000134911853820086, 0.000124899772345088, 0.000114887676318176, 0.000104875587567221, 9.48739761952311e-05, 8.48723575472832e-05, 7.48707388993353e-05, 6.48743589408696e-05, 5.48832140339073e-05, 4.48868340754416e-05, 3.49061665474437e-05, 2.49150216404814e-05, 1.49448242154904e-05, 4.96415259476635e-06, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15, 2.21375279490111e-15   }, 
   { 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.96144071651361e-07, 6.02053319198603e-07, 1.00796262358926e-06, 1.42068233799364e-06, 1.83340216608485e-06, 2.25701887757168e-06, 2.68472194875358e-06, 3.11378721562505e-06, 3.54966300619708e-06, 3.99098735215375e-06, 4.43775979874772e-06, 4.88861860503675e-06, 5.34356377102085e-06, 5.80259575144737e-06, 6.2657136368216e-06, 6.73564181852271e-06, 7.20829484635033e-06, 7.68775862525217e-06, 8.17130785435438e-06, 8.65894344315166e-06, 9.15475266083376e-06, 9.65056005952647e-06, 1.01531795735355e-05, 1.06612478703028e-05, 1.11747640403337e-05, 1.1692365660565e-05, 1.22140554594807e-05, 1.27398297991022e-05, 1.32683280753554e-05, 1.38050008899882e-05, 1.4345760064316e-05, 1.48906037793495e-05, 1.54422596096992e-05, 1.59966384671861e-05, 1.6556467016926e-05, 1.71217416209402e-05, 1.76911053131334e-05, 1.82672793016536e-05, 1.8844815713237e-05, 1.94305212062318e-05, 2.00162303372053e-05, 2.06087497645058e-05, 2.12053546420066e-05, 2.18101304199081e-05, 2.24176328629255e-05, 2.30305831792066e-05, 2.36476207646774e-05, 2.42714650084963e-05, 2.4895312890294e-05, 2.55286977335345e-05, 2.616343954287e-05, 2.68063558905851e-05, 2.74506346613634e-05, 2.81003613054054e-05, 2.87555376417004e-05, 2.94161636702484e-05, 3.00808715110179e-05, 3.07523951050825e-05, 3.14266399072949e-05, 3.21049701597076e-05, 3.27901107084472e-05, 3.34793403453659e-05, 3.4172655432485e-05, 3.48700559698045e-05, 3.55742704414297e-05, 3.62798455171287e-05, 3.69922272511758e-05, 3.77100623154547e-05, 3.84319791919552e-05, 3.91579851566348e-05, 3.98908014176413e-05, 4.06277031288482e-05, 4.13686939282343e-05, 4.21137701778207e-05, 4.2867013689829e-05, 4.36216250818688e-05, 4.43816825281829e-05, 4.51431042165495e-05, 4.59154216514435e-05, 4.66904602944851e-05, 4.74709522677585e-05, 4.82541654491797e-05, 4.90428283228539e-05, 4.98369408887811e-05, 5.06351352669299e-05, 5.14401472173631e-05, 5.22478767379653e-05, 5.30610559508204e-05, 5.38783242518548e-05, 5.46983137610368e-05, 5.55237566004507e-05, 5.63573703402653e-05, 5.71937052882276e-05, 5.80368541704956e-05, 5.88827242609113e-05, 5.97340476815589e-05, 6.05880850343965e-05, 6.14489399595186e-05, 6.23152445768937e-05, 6.31856310064904e-05, 6.40614671283402e-05, 6.49400317342952e-05, 6.58226854284294e-05, 6.67107742629014e-05, 6.76056879456155e-05, 6.85046761645935e-05, 6.94091213517822e-05, 7.03176483511925e-05, 7.12329856469296e-05, 7.21483302186243e-05, 7.30704778106883e-05, 7.39980750950053e-05, 7.49311220715754e-05, 7.58655296522193e-05, 7.68067548051476e-05, 7.77534150984138e-05, 7.87068929639645e-05, 7.9661731433589e-05, 8.06220268714242e-05, 8.15863968455233e-05, 8.25589522719383e-05, 8.35342216305435e-05, 8.4514933405444e-05, 8.54983809404075e-05, 8.6487278167624e-05, 8.74816178111359e-05, 8.84786859387532e-05, 8.94825570867397e-05, 9.04918852029368e-05, 9.15052951313555e-05, 9.25227941479534e-05, 9.35457355808467e-05, 9.45727733778767e-05, 9.56066141952761e-05, 9.66431834967807e-05, 9.76865630946122e-05, 9.87326566246338e-05, 9.97828537947498e-05, 0.000100839846709277, 0.00010189956810791, 0.000102964739198796, 0.000104035367257893, 0.000105111430457328, 0.000106191582744941, 0.000107275824120734, 0.00010836551518878, 0.000109459288069047, 0.000110559878521599, 0.000111663182906341, 0.000112771944259293, 0.000113886148028541, 0.000115001726953778, 0.000116124101623427, 0.00011725329386536, 0.000118386575195473, 0.000119522563181818, 0.000120665383292362, 0.000121812285215128, 0.00012296462955419, 0.000124121070257388, 0.00012528158549685, 0.000126447543152608, 0.000127620325656608, 0.000128791740280576, 0.000129972700960934, 0.000131157721625641, 0.000132348213810474, 0.000133541427203454, 0.000134741436340846, 0.000135945549118333, 0.000137156472192146, 0.000138368748594075, 0.0001395864674123, 0.000140811011078767, 0.000142039643833414, 0.000143269629916176, 0.000144506426295266, 0.000145750032970682, 0.000146996360854246, 0.000148246777825989, 0.00014950537297409, 0.000150765321450308, 0.000152033448102884, 0.000153304295963608, 0.000154580600792542, 0.00015586098015774, 0.000157145448611118, 0.000158432638272643, 0.000159728020662442, 0.000161028830916621, 0.000162333744810894, 0.000163642733241431, 0.000164955796208233, 0.000166275684023276, 0.000167599660926498, 0.000168926359037869, 0.000170259867445566, 0.000171598803717643, 0.00017294185818173, 0.000174287633853965, 0.000175637484062463, 0.00017699551244732, 0.000178357615368441, 0.000179722454049625, 0.000181094103027135, 0.000182471194420941, 0.00018385102157481, 0.000185236262041144, 0.000186628356459551, 0.000188023172086105, 0.000189422047697008, 0.000190826380276121, 0.000192234801943414, 0.000193647327250801, 0.0001950666483026, 0.000196490043890662, 0.000197920278878883, 0.00019935320597142, 0.000200791590032168, 0.00020223407773301, 0.000203682007850148, 0.000205134012503549, 0.00020659010624513, 0.000208053010283038, 0.000209517267649062, 0.000210989732295275, 0.000212463535717689, 0.000213944134884514, 0.000215431558899581, 0.000216921733226627, 0.000218415967538022, 0.000219918365473859, 0.000221424867049791, 0.000222931354073808, 0.000224446019274183, 0.000225966141442768, 0.000227487631491385, 0.000229014563956298, 0.000230548277613707, 0.000232088816119358, 0.000233630751608871, 0.000235178114962764, 0.000236730920732953, 0.000238290536799468, 0.000239851520746015, 0.000241417932556942, 0.00024298980133608, 0.000244567141635343, 0.00024614718859084, 0.000247729971306399, 0.000249320903094485, 0.000250917306402698, 0.000252519152127206, 0.000254120968747884, 0.000255733699304983, 0.000257346458965912, 0.0002589673968032, 0.00026059101219289, 0.000262220099102706, 0.000263854628428817, 0.00026549186441116, 0.000267131894361228, 0.000268781383056194, 0.000270433636615053, 0.000272089993814006, 0.000273753103101626, 0.000275421713013202, 0.000277094368357211, 0.000278767052805051, 0.000280450592981651, 0.000282136898022145, 0.000283828645478934, 0.000285523099591956, 0.00028722028946504, 0.000288925686618313, 0.000290636497084051, 0.000292351382086053, 0.000294071709504351, 0.000295796140562743, 0.00029752470436506, 0.000299258623272181, 0.000300995336147025, 0.000302741565974429, 0.000304489163681865, 0.000306242203805596, 0.000307996582705528, 0.00030976053676568, 0.000311527168378234, 0.000313298602122813, 0.00031507684616372, 0.00031685849535279, 0.000318643549690023, 0.000320434686727822, 0.000322231993777677, 0.000324033404467627, 0.00032583755091764, 0.000327647081576288, 0.000329462112858891, 0.000331279850797728, 0.000333105737809092, 0.000334933691192418, 0.000336769851855934, 0.000338606623699889, 0.000340450962539762, 0.000342299346812069, 0.000344153842888772, 0.000346010434441268, 0.000347875116858631, 0.000349743291735649, 0.000351613445673138, 0.000353487732354552, 0.000355368771124631, 0.00035725737689063, 0.0003591493004933, 0.000361044687451795, 0.000362946215318516, 0.000364849780453369, 0.000366762164048851, 0.000368675944628194, 0.000370595837011933, 0.0003725232090801, 0.000374451978132129, 0.000376386160496622, 0.000378320371964946, 0.000380266807042062, 0.000382215308491141, 0.000384167913580313, 0.000386125931981951, 0.000388090818887576, 0.000390056986361742, 0.000392029352951795, 0.000394006434362382, 0.000395988317904994, 0.000397975643863901, 0.000399967044359073, 0.000401961151510477, 0.000403962098062038, 0.000405967817641795, 0.000407977611757815, 0.000409994885558262, 0.000412015593610704, 0.000414039706811309, 0.00041606993181631, 0.000418104260461405, 0.000420143303927034, 0.000422187178628519, 0.000424236466642469, 0.000426287791924551, 0.000428347324486822, 0.000430410233093426, 0.000432475906563923, 0.000434550369391218, 0.000436627597082406, 0.000438709568697959, 0.000440796342445537, 0.00044288786011748, 0.00044498618808575, 0.000447085913037881, 0.000449193787062541, 0.000451301602879539, 0.000453415617812425, 0.000455537112429738, 0.000457663350971416, 0.000459792296169326, 0.000461926800198853, 0.000464065989945084, 0.000466211960883811, 0.000468360696686432, 0.000470514234621078, 0.000472673156764358, 0.000474836851935834, 0.00047700124559924, 0.000479174515930936, 0.000481351133203134, 0.000483534589875489, 0.000485722877783701, 0.000487914512632415, 0.000490108854137361, 0.000492312072310597, 0.000494518724735826, 0.000496728753205389, 0.000498946232255548, 0.000501166505273432, 0.000503391493111849, 0.000505617819726467, 0.000507853750605136, 0.000510092417243868, 0.000512337894178927, 0.000514586688950658, 0.000516843050718307, 0.000519100052770227, 0.000521362526342273, 0.000523631810210645, 0.000525906507391483, 0.000528184638824314, 0.000530466146301478, 0.000532751146238297, 0.000535044237039983, 0.000537339423317462, 0.000539641361683607, 0.000541947432793677, 0.000544260255992413, 0.000546577270142734, 0.000548897602129728, 0.000551224104128778, 0.00055355328368023, 0.00055588799295947, 0.000558227358851582, 0.00056057091569528, 0.000562919885851443, 0.000565274967812002, 0.000567632727324963, 0.000569997355341911, 0.000572365475818515, 0.000574738893192261, 0.000577117141801864, 0.000579500163439661, 0.000581887958105654, 0.000584280525799841, 0.000586676469538361, 0.000589075789321214, 0.000591481977608055, 0.000593894917983562, 0.000596311350818723, 0.000598733138758689, 0.000601158477365971, 0.000603587774094194, 0.000606023881118745, 0.00060846476117149, 0.00061090977396816, 0.000613359559793025, 0.000615814002230763, 0.000618269259575754, 0.000620733306277543, 0.000623202126007527, 0.000625677115749568, 0.000628155481535941, 0.000630637921858579, 0.000633125833701342, 0.00063561782008037, 0.000638115918263793, 0.000640618149191141, 0.000643124396447092, 0.000645636755507439, 0.000648153305519372, 0.000650673231575638, 0.000653197173960507, 0.000655728683341295, 0.000658264267258346, 0.000660803925711662, 0.000663350394461304, 0.000665899598971009, 0.00066845491528511, 0.000671013607643545, 0.000673577189445496, 0.000676148105412722, 0.000678721175063401, 0.000681299599818885, 0.000683880760334432, 0.000686468789353967, 0.000689059554133564, 0.00069165846798569, 0.00069426151458174, 0.000696868577506393, 0.000699481053743511, 0.000702096382156014, 0.000704719743225724, 0.000707343860995024, 0.000709975429344922, 0.000712610490154475, 0.000715249567292631, 0.000717895454727113, 0.000720545474905521, 0.0007231988129206, 0.000725858379155397, 0.00072852335870266, 0.000731192412786186, 0.000733866239897907, 0.000736546819098294, 0.000739229551982135, 0.000741916941478848, 0.00074461055919528, 0.000747306155972183, 0.000750007980968803, 0.000752715859562159, 0.000755429093260318, 0.000758145877625793, 0.00076086597982794, 0.000763591611757874, 0.000766323995776474, 0.000769060454331338, 0.000771801045630127, 0.000774546409957111, 0.00077729718759656, 0.000780048605520278, 0.000782808929216117, 0.00078557402594015, 0.000788343895692378, 0.00079111778177321, 0.000793896557297558, 0.000796262989751995, 0.000798209453932941, 0.000800165405962616, 0.00080212828470394, 0.000804106006398797, 0.000806093332357705, 0.000808092940133065, 0.000810103374533355, 0.000812126090750098, 0.000814159750007093, 0.000816204294096678, 0.000818259723018855, 0.000820331450086087, 0.000822404632344842, 0.000824496790301055, 0.000826598552521318, 0.000828713935334235, 0.000830841541755944, 0.000832971883937716, 0.000835118582472205, 0.000837277504615486, 0.000839447369799018, 0.000841633591335267, 0.000843819754663855, 0.000846027687657624, 0.000848242489155382, 0.00085046817548573, 0.000852712953928858, 0.000854956335388124, 0.00085721880896017, 0.000859490828588605, 0.00086177239427343, 0.000864071596879512, 0.000866372196469456, 0.000868694623932242, 0.000871021067723632, 0.000873363926075399, 0.000875717727467418, 0.000878075428772718, 0.000880455074366182, 0.000882837455719709, 0.000885237415786833, 0.000887648377101868, 0.000890059280209243, 0.000892496143933386, 0.000894938420969993, 0.000897391641046852, 0.000899859704077244, 0.000902333355043083, 0.000904826039914042, 0.000907321344129741, 0.000909833062905818, 0.000912359857466072, 0.000914890610147268, 0.000917433644644916, 0.000919984886422753, 0.000922557956073433, 0.000925137719605118, 0.000927723071072251, 0.000930327456444502, 0.000932939990889281, 0.000935566145926714, 0.000938204466365278, 0.00094084843294695, 0.000943508639466017, 0.000946175656281412, 0.000948861707001925, 0.000951555965002626, 0.000954251561779529, 0.000956971663981676, 0.000959695898927748, 0.000962435093242675, 0.000965186511166394, 0.000967943458817899, 0.000970718101598322, 0.000973502232227474, 0.000976298644673079, 0.000979105941951275, 0.000981921562924981, 0.000984751968644559, 0.000987585168331861, 0.000990440021269023, 0.000993304769508541, 0.00099617603700608, 0.000999066280201077, 0.00100195943377912, 0.0010048703989014, 0.00100779207423329, 0.00101071933750063, 0.00101366557646543, 0.00101661717053503, 0.0010195825016126, 0.00102255458477885, 0.00102554587647319, 0.00102854648139328, 0.00103155558463186, 0.00103457807563245, 0.00103760731872171, 0.00104065716732293, 0.00104371504858136, 0.00104677840135992, 0.00104986084625125, 0.00105294608511031, 0.00105605309363455, 0.00105916534084827, 0.00106228876393288, 0.00106542301364243, 0.00106856948696077, 0.00107172958087176, 0.00107490189839154, 0.00107808108441532, 0.0010812726104632, 0.00108447624370456, 0.00108769361395389, 0.00109092169441283, 0.00109415815677494, 0.00109740812331438, 0.00110066356137395, 0.00110393797513098, 0.00110722484532744, 0.0011105143930763, 0.00111382559407502, 0.00111713830847293, 0.00112046860158443, 0.00112381402868778, 0.0011271620169282, 0.00113052653614432, 0.00113389769103378, 0.00113728665746748, 0.00114068225957453, 0.00114408636000007, 0.00114750920329243, 0.00115093914791942, 0.00115438248030841, 0.00115783815272152, 0.0011613005772233, 0.00116478081326932, 0.00116826500743628, 0.0011717671295628, 0.00117528135888278, 0.0011787983821705, 0.00118233298417181, 0.0011858744546771, 0.00118943233974278, 0.00119300105143338, 0.00119657523464411, 0.00120016990695149, 0.0012037685373798, 0.00120738497935236, 0.00121101085096598, 0.00121464231051505, 0.00121829414274544, 0.00122194865252823, 0.0012256222544238, 0.00122929865028709, 0.00123299122788012, 0.00123669486492872, 0.00124040932860225, 0.00124413741286844, 0.00124787644017488, 0.0012516250135377, 0.00125538581050932, 0.00125915743410587, 0.00126294000074267, 0.00126673758495599, 0.00127053924370557, 0.00127435871399939, 0.00127818342298269, 0.00128202466294169, 0.00128587940707803, 0.00128973950631917, 0.00129361753351986, 0.00129749951884151, 0.00130139652173966, 0.0013053099391982, 0.00130922591779381, 0.00131315970793366, 0.00131709757260978, 0.00132105173543096, 0.00132501963526011, 0.0013289914932102, 0.00133298384025693, 0.00133697898127139, 0.00134099030401558, 0.00134501687716693, 0.00134904857259244, 0.00135309400502592, 0.0013571463059634, 0.00136121769901365, 0.00136529724113643, 0.00136938353534788, 0.0013734862441197, 0.00137759291101247, 0.00138172297738492, 0.00138585967943072, 0.00139000464696437, 0.00139416300226003, 0.00139832973945886, 0.00140251417178661, 0.00140670954715461, 0.00141091016121209, 0.00141512602567673, 0.00141934992279857, 0.00142358604352921, 0.00142783985938877, 0.00143209798261523, 0.00143637077417225, 0.00144064915366471, 0.001444949535653, 0.00144925503991544, 0.0014535702066496, 0.00145790039096028, 0.00146224012132734, 0.0014665920753032, 0.00147095753345639, 0.00147532718256116, 0.00147971464321017, 0.00148410606198013, 0.00148851925041527, 0.00149293662980199, 0.00149736891034991, 0.00150181213393807, 0.00150626362301409, 0.00151073129381984, 0.0015152043197304, 0.00151969259604812, 0.0015241956571117, 0.00152870151214302, 0.0015332237817347, 0.00153775559738278, 0.00154230080079287, 0.00154686125461012, 0.00155142298899591, 0.00155600509606302, 0.00156058999709785, 0.001565195270814, 0.00156981276813895, 0.00157443166244775, 0.00157906964886934, 0.00158371042925864, 0.00158836890477687, 0.00159304216504097, 0.00159771973267198, 0.00160241639241576, 0.00160711549688131, 0.00161183124873787, 0.00161656050477177, 0.00162129651289433, 0.00162604893557727, 0.00163080403581262, 0.0016355769475922, 0.00164036336354911, 0.00164515397045761, 0.00164996215607971, 0.00165477581322193, 0.00165960716549307, 0.00166444818023592, 0.00166929722763598, 0.00167416140902787, 0.0016790337394923, 0.00168392097111791, 0.0016888176323846, 0.00169372546952218, 0.00169864541385323, 0.00170357071328908, 0.00170851673465222, 0.00171347323339432, 0.00171843415591866, 0.00172341265715659, 0.00172839791048318, 0.00173339829780161, 0.00173841218929738, 0.00174342887476087, 0.00174846453592181, 0.00175350706558675, 0.00175856600981206, 0.00176363298669457, 0.00176870834548026, 0.00177379848901182, 0.00177889689803123, 0.00178401300217956, 0.00178913993295282, 0.00179427093826234, 0.00179941987153143, 0.00180457264650613, 0.0018097487045452, 0.00181493011768907, 0.00182011991273612, 0.00182532041799277, 0.00183053314685822, 0.00183576357085258, 0.00184100377373397, 0.00184624793473631, 0.00185151083860546, 0.00185678096022457, 0.00186206609942019, 0.00186736043542624, 0.00187266594730318, 0.00187798496335745, 0.00188330817036331, 0.00188864895608276, 0.00189400056842715, 0.0018993605626747, 0.00190473697148263, 0.00191011989954859, 0.00191551796160638, 0.00192092848010361, 0.00192634400445968, 0.00193178025074303, 0.00193721905816346, 0.00194267311599106, 0.0019481391645968, 0.00195361347869039, 0.00195910152979195, 0.0019645974971354, 0.00197010859847069, 0.00197563320398331, 0.00198116363026202, 0.001986711518839, 0.00199226336553693, 0.00199783174321055, 0.00200341222807765, 0.00200899969786406, 0.00201460346579552, 0.002020213752985, 0.0020258380100131, 0.00203147297725081, 0.00203711772337556, 0.00204277876764536, 0.00204844493418932, 0.0020541250705719, 0.00205982150509953, 0.00206552189774811, 0.00207123998552561, 0.00207695947028697, 0.00208270060829818, 0.00208845152519643, 0.00209420919418335, 0.00209998060017824, 0.00210576131939888, 0.00211155577562749, 0.00211736653000116, 0.00212318124249578, 0.00212900992482901, 0.00213484652340412, 0.00214069918729365, 0.00214656628668308, 0.00215243687853217, 0.00215832376852632, 0.00216421624645591, 0.00217012246139348, 0.00217604078352451, 0.00218197423964739, 0.00218791700899601, 0.00219386932440102, 0.00219983560964465, 0.00220580981113017, 0.00221179914660752, 0.00221780175343156, 0.0022238059900701, 0.00222982931882143, 0.00223585916683078, 0.00224190438166261, 0.00224795867688954, 0.00225402577780187, 0.00226010615006089, 0.00226619490422308, 0.00227229716256261, 0.00227840896695852, 0.00228453008458018, 0.0022906691301614, 0.00229681516066194, 0.00230297190137208, 0.00230914377607405, 0.00231531937606633, 0.00232151290401816, 0.00232771318405867, 0.00233393139205873, 0.0023401603102684, 0.00234639458358288, 0.00235264515504241, 0.00235890294425189, 0.00236517400480807, 0.00237145903520286, 0.00237775314599276, 0.00238406099379063, 0.00239037466235459, 0.00239669997245073, 0.00240304204635322, 0.0024093936663121, 0.00241575739346445, 0.00242212787270546, 0.00242851232178509, 0.00243491143919528, 0.00244132010266185, 0.00244774110615253, 0.00245416769757867, 0.00246061035431921, 0.00246706535108387, 0.0024735233746469, 0.00248000561259687, 0.00248648622073233, 0.00249298755079508, 0.00249950005672872, 0.00250601908192039, 0.00251255719922483, 0.00251909391954541, 0.00252565531991422, 0.0025322234723717, 0.0025387997739017, 0.00254538818262517, 0.0025519821792841, 0.00255860202014446, 0.00256522721610963, 0.0025718582328409, 0.00257850647903979, 0.00258516054600477, 0.00259183207526803, 0.00259851454757154, 0.0026052026078105, 0.00261190952733159, 0.00261862063780427, 0.002625348046422, 0.0026320880278945, 0.00263883289881051, 0.00264559336937964, 0.00265236012637615, 0.00265914760529995, 0.00266594463028014, 0.00267274701036513, 0.00267956568859518, 0.00268638995476067, 0.00269323168322444, 0.00270008714869618, 0.00270694401115179, 0.00271381717175245, 0.00272070127539337, 0.00272759911604226, 0.00273450883105397, 0.00274142459966242, 0.00274835783056915, 0.00275529641658068, 0.00276225106790662, 0.00276921968907118, 0.0027761897072196, 0.00278317858465016, 0.00279017724096775, 0.00279718963429332, 0.00280420971103013, 0.0028112381696701, 0.00281828292645514, 0.00282533862628043, 0.00283240806311369, 0.00283948821015656, 0.00284657417796552, 0.00285367597825825, 0.0028607863932848, 0.00286791287362576, 0.00287504773586988, 0.00288219307549298, 0.00288935238495469, 0.00289651448838413, 0.00290370103903115, 0.00291089178062975, 0.00291809323243797, 0.00292530958540738, 0.00293253269046545, 0.00293977395631373, 0.00294702174142003, 0.00295428023673594, 0.00296155270189047, 0.00296883168630302, 0.00297612720169127, 0.0029834252782166, 0.00299074803479016, 0.00299807777628303, 0.003005416598171, 0.00301276659592986, 0.00302012474276125, 0.00302750314585865, 0.00303488876670599, 0.00304228207096457, 0.0030496921390295, 0.00305710593238473, 0.0030645418446511, 0.00307198148220778, 0.00307943252846599, 0.00308689684607089, 0.00309437210671604, 0.00310186087153852, 0.00310936337336898, 0.00311687006615102, 0.00312439305707812, 0.00313192140311003, 0.00313947023823857, 0.00314702582545578, 0.00315458839759231, 0.00316216703504324, 0.00316975126042962, 0.00317735737189651, 0.0031841981690377, 0.00319026783108711, 0.00319637008942664, 0.00320247816853225, 0.00320864003151655, 0.003214824013412, 0.00322101870551705, 0.00322726555168629, 0.00323350680992007, 0.00323980231769383, 0.00324613065458834, 0.00325246737338603, 0.00325883668847382, 0.00326523836702108, 0.00327167310751975, 0.00327812670730054, 0.00328461034223437, 0.0032911105081439, 0.00329764862544835, 0.00330422469414771, 0.00331081473268569, 0.00331743457354605, 0.00332408165559173, 0.00333075341768563, 0.00333746848627925, 0.00334420287981629, 0.00335094518959522, 0.00335774198174477, 0.00336455530487001, 0.00337140145711601, 0.00337827461771667, 0.0033851561602205, 0.00339208636432886, 0.00339904380962253, 0.00340602896176279, 0.00341303576715291, 0.00342006143182516, 0.00342713063582778, 0.00343421660363674, 0.0034413430839777, 0.00344849680550396, 0.00345565611496568, 0.00346286431886256, 0.00347008905373514, 0.00347734917886555, 0.00348463095724583, 0.00349194020964205, 0.00349928438663483, 0.00350665091536939, 0.00351405004039407, 0.00352146523073316, 0.003528913250193, 0.0035363994538784, 0.00354390195570886, 0.00355143961496651, 0.00355899939313531, 0.00356658129021525, 0.00357420626096427, 0.0035818419419229, 0.0035895137116313, 0.00359721761196852, 0.00360494083724916, 0.00361269665881991, 0.0036204825155437, 0.0036282844375819, 0.00363612780347466, 0.00364399258978665, 0.00365188741125166, 0.0036598090082407, 0.00366774760186672, 0.00367572996765375, 0.00368372816592455, 0.00369176431559026, 0.00369982281699777, 0.00370790273882449, 0.00371602061204612, 0.003724166424945, 0.00373233901336789, 0.00374052231200039, 0.00374874961562455, 0.00375700974836946, 0.00376528594642878, 0.00377359753474593, 0.00378191960044205, 0.00379028869792819, 0.00379867409355938, 0.00380709976889193, 0.00381554779596627, 0.00382401468232274, 0.00383251416496933, 0.00384104647673666, 0.00384960602968931, 0.00385818164795637, 0.00386679032817483, 0.0038754369597882, 0.00388410268351436, 0.00389280100353062, 0.00390151329338551, 0.00391026353463531, 0.00391904916614294, 0.00392785063013434, 0.00393669120967388, 0.00394554203376174, 0.00395443104207516, 0.00396335031837225, 0.00397229148074985, 0.00398127036169171, 0.00399025995284319, 0.00399928260594606, 0.00400834623724222, 0.00401742057874799, 0.00402652751654387, 0.00403566705062985, 0.00404482940211892, 0.00405403133481741, 0.00406324490904808, 0.00407248781993985, 0.00408176425844431, 0.00409106444567442, 0.00410040561109781, 0.00410975841805339, 0.00411913497373462, 0.00412855530157685, 0.00413799472153187, 0.00414747279137373, 0.00415695551782846, 0.00416648201644421, 0.00417603552341461, 0.00418561929836869, 0.00419522542506456, 0.00420484645292163, 0.00421451544389129, 0.00422421330586076, 0.00423392839729786, 0.00424367561936378, 0.00425343355163932, 0.00426324084401131, 0.00427307793870568, 0.00428292853757739, 0.00429280661046505, 0.00430271215736866, 0.00431265542283654, 0.00432262616232038, 0.00433262111619115, 0.00434263236820698, 0.00435268273577094, 0.00436276709660888, 0.00437287706881762, 0.00438300892710686, 0.0043931589461863, 0.00440334482118487, 0.00441356562077999, 0.00442380923777819, 0.00443407939746976, 0.00444437190890312, 0.00445469887927175, 0.00446505658328533, 0.00447544129565358, 0.00448583718389273, 0.00449627637863159, 0.0045067397877574, 0.00451723393052816, 0.00452776020392776, 0.00453829439356923, 0.00454886723309755, 0.00455947266891599, 0.00457010790705681, 0.00458076829090714, 0.00459144450724125, 0.00460215844213963, 0.00461290264502168, 0.00462367199361324, 0.00463445670902729, 0.00464528007432818, 0.00465613882988691, 0.00466701667755842, 0.00467792479321361, 0.00468884827569127, 0.00469981133937836, 0.00471080839633942, 0.00472182547673583, 0.00473287189379334, 0.0047439350746572, 0.00475503643974662, 0.00476616760715842, 0.00477732298895717, 0.00478849513456225, 0.00479971105232835, 0.0048109507188201, 0.0048222211189568, 0.00483350735157728, 0.00484482711181045, 0.00485617620870471, 0.00486755464226007, 0.00487896427512169, 0.00489038927480578, 0.00490184174850583, 0.00491333566606045, 0.00492484774440527, 0.0049363961443305, 0.00494796270504594, 0.00495955161750317, 0.0049711843021214, 0.00498283561319113, 0.00499452278017998, 0.00500621786341071, 0.00501795904710889, 0.00502972258254886, 0.00504151498898864, 0.00505333300679922, 0.00506516732275486, 0.00507704773917794, 0.00508895236998796, 0.00510087888687849, 0.0051128463819623, 0.00512481667101383, 0.00513683073222637, 0.00514886854216456, 0.00516094267368317, 0.0051730303093791, 0.00518515286967158, 0.00519730243831873, 0.0052094804123044, 0.00522169563919306, 0.00523391924798489, 0.00524618104100227, 0.00525847217068076, 0.00527078844606876, 0.00528313498944044, 0.00529550528153777, 0.00530790071934462, 0.00532033108174801, 0.00533277820795774, 0.00534526072442532, 0.005357775837183, 0.00537030724808574, 0.00538287637755275, 0.00539547391235828, 0.00540808402001858, 0.00542073836550117, 0.00543341133743525, 0.00544611690565944, 0.00545884668827057, 0.00547159928828478, 0.00548439240083098, 0.00549720181152225, 0.00551004335284233, 0.00552291795611382, 0.00553580885753036, 0.00554873282089829, 0.00556168332695961, 0.00557467294856906, 0.00558766769245267, 0.005600705742836, 0.00561377080157399, 0.00562685774639249, 0.00563998334109783, 0.00565311405807734, 0.00566629413515329, 0.00567950122058392, 0.00569272972643375, 0.00570598617196083, 0.00571925844997168, 0.00573257124051452, 0.00574591476470232, 0.00575928250327706, 0.00577266933396459, 0.00578609155490994, 0.00579954357817769, 0.00581302586942911, 0.00582653237506747, 0.00584005564451218, 0.00585361663252115, 0.00586720509454608, 0.00588082661852241, 0.00589447468519211, 0.00590813392773271, 0.00592183088883758, 0.00593556091189384, 0.00594931887462735, 0.00596310338005424, 0.00597690138965845, 0.00599074037745595, 0.00600460963323712, 0.00601850310340524, 0.00603241287171841, 0.00604636641219258, 0.00606033625081182, 0.00607433868572116, 0.00608837697654963, 0.00610242551192641, 0.00611650990322232, 0.0061306213028729, 0.00614477088674903, 0.00615894235670567, 0.00617312965914607, 0.00618735561147332, 0.00620160344988108, 0.00621588947251439, 0.00623018853366375, 0.00624452345073223, 0.00625888863578439, 0.00627327244728804, 0.0062876995652914, 0.00630213832482696, 0.00631661247462034, 0.00633111549541354, 0.0063456385396421, 0.00636020256206393, 0.00637477682903409, 0.00638938415795565, 0.00640402408316731, 0.00641869148239493, 0.00643339147791266, 0.00644810730591416, 0.0064628510735929, 0.00647763768211007, 0.00649243593215942, 0.00650726398453116, 0.00652212975546718, 0.00653701508417726, 0.00655193580314517, 0.00656687514856458, 0.00658183684572577, 0.00659683905541897, 0.00661186035722494, 0.00662691984325647, 0.00664199888706207, 0.00665710447356105, 0.0066722403280437, 0.00668740319088101, 0.00670260423794389, 0.00671781087294221, 0.00673305802047253, 0.00674833543598652, 0.00676363799721003, 0.00677897222340107, 0.0067943180911243, 0.00680970400571823, 0.00682512298226357, 0.00684056431055069, 0.00685603497549891, 0.00687151914462447, 0.0068870447576046, 0.00690259458497167, 0.00691817700862885, 0.00693378737196326, 0.00694941310212016, 0.00696507189422846, 0.00698076374828815, 0.00699648261070251, 0.00701222289353609, 0.00702799065038562, 0.00704379426315427, 0.00705962441861629, 0.00707548204809427, 0.00709135597571731, 0.0071072680875659, 0.00712320767343044, 0.00713917193934321, 0.00715516787022352, 0.00717118103057146, 0.00718723237514496, 0.0072033079341054, 0.00721941655501723, 0.00723554054275155, 0.00725170085206628, 0.00726788537576795, 0.00728410528972745, 0.00730034755542874, 0.00731660565361381, 0.00733291311189532, 0.00734923640266061, 0.00736558949574828, 0.00738197099417448, 0.00739837344735861, 0.00741481129080057, 0.00743127334862947, 0.00744776614010334, 0.00746428640559316, 0.00748082203790545, 0.00749740656465292, 0.00751400319859385, 0.00753063429147005, 0.0075472816824913, 0.0075639677233994, 0.00758068636059761, 0.0075974240899086, 0.00761419674381614, 0.00763097545132041, 0.0076478086411953, 0.00766465812921524, 0.00768153741955757, 0.00769844418391585, 0.00771536584943533, 0.00773233221843839, 0.00774932140484452, 0.00776634179055691, 0.00778337987139821, 0.00780044682323933, 0.00781754869967699, 0.00783467665314674, 0.00785183440893888, 0.00786900706589222, 0.00788621604442596, 0.00790345761924982, 0.00792072340846062, 0.00793801713734865, 0.0079553322866559, 0.00797268003225327, 0.00799006037414074, 0.00800746772438288, 0.00802488625049591, 0.00804234854876995, 0.00805983413010836, 0.00807734951376915, 0.00809489376842976, 0.00811245199292898, 0.00813005305826664, 0.00814767554402351, 0.00816533155739307, 0.00818301364779472, 0.00820071063935757, 0.00821845047175884, 0.00823621638119221, 0.00825400464236736, 0.00827182922512293, 0.00828965939581394, 0.00830754172056913, 0.00832543428987265, 0.00834336783736944, 0.00836131721735001, 0.00837929639965296, 0.00839731562882662, 0.00841534975916147, 0.00843342300504446, 0.00845151394605637, 0.00846963748335838, 0.00848778616636992, 0.00850596278905869, 0.00852417107671499, 0.00854240171611309, 0.00856065470725298, 0.0085789505392313, 0.00859726313501596, 0.00861559621989727, 0.00863397680222988, 0.00865236856043339, 0.00867079943418503, 0.00868925359100103, 0.00870772358030081, 0.00872624386101961, 0.00874477438628674, 0.00876334775239229, 0.00878193136304617, 0.00880054850131273, 0.00881920196115971, 0.0088378768414259, 0.00885658152401447, 0.00887531228363514, 0.00889405515044928, 0.00891285482794046, 0.0089316638186574, 0.00895050633698702, 0.00896936561912298, 0.00898825842887163, 0.00900719780474901, 0.00902614183723927, 0.00904512219130993, 0.00906412024050951, 0.00908316019922495, 0.00910222437232733, 0.00912130996584892, 0.00914042815566063, 0.00915956869721413, 0.00917874183505774, 0.00919794198125601, 0.00921717565506697, 0.00923641864210367, 0.00925570633262396, 0.00927501544356346, 0.00929435156285763, 0.00931372120976448, 0.00933311320841312, 0.00935253314673901, 0.0093719819560647, 0.00939145684242249, 0.0094109708443284, 0.00943049043416977, 0.00945005565881729, 0.00946964602917433, 0.00948925409466028, 0.00950890593230724, 0.00952856708317995, 0.00954826548695564, 0.0095679946243763, 0.00958774611353874, 0.00960751809179783, 0.00962732918560505, 0.00964716635644436, 0.00966609455645084, 0.00968415569514036, 0.00970227736979723, 0.00972045864909887, 0.00973870605230331, 0.00975698977708817, 0.00977535732090473, 0.00979375746101141, 0.00981223303824663, 0.00983074586838484, 0.00984935276210308, 0.00986797455698252, 0.00988668575882912, 0.00990542769432068, 0.00992424692958593, 0.00994313135743141, 0.0099620595574379, 0.00998104177415371, 0.0100000835955143, 0.0100191915407777, 0.0100383535027504, 0.0100575592368841, 0.0100768525153399, 0.0100961774587631, 0.0101155573502183, 0.0101350089535117, 0.0101545201614499, 0.0101740909740329, 0.0101937111467123, 0.0102133853361011, 0.0102331088855863, 0.0102529190480709, 0.0102727739140391, 0.0102926921099424, 0.0103126559406519, 0.0103326737880707, 0.0103527614846826, 0.0103728882968426, 0.0103931073099375, 0.0104133589193225, 0.0104336654767394, 0.0104540204629302, 0.0104744685813785, 0.0104949492961168, 0.0105154905468225, 0.0105360904708505, 0.0105567565187812, 0.0105774709954858, 0.0105982515960932, 0.0106190657243133, 0.0106399655342102, 0.0106609091162682, 0.0106819188222289, 0.0107029872015119, 0.0107241002842784, 0.0107452729716897, 0.0107665155082941, 0.0107878083363175, 0.0108091505244374, 0.0108305737376213, 0.0108520295470953, 0.0108735514804721, 0.0108951376751065, 0.0109167732298374, 0.0109384739771485, 0.0109602138400078, 0.0109820403158665, 0.0110039105638862, 0.0110258301720023, 0.011047825217247, 0.0110698584467173, 0.0110919578000903, 0.0111141046509147, 0.0111363288015127, 0.0111586079001427, 0.0111809363588691, 0.0112033234909177, 0.0112257599830627, 0.0112482681870461, 0.0112708350643516, 0.011293456889689, 0.0113161336630583, 0.011338859796524, 0.0113616548478603, 0.0113845225423574, 0.0114074107259512, 0.011430392973125, 0.0114534068852663, 0.0114764869213104, 0.0114996209740639, 0.0115228155627847, 0.0115460585802794, 0.0115693714469671, 0.0115927355363965, 0.011616162955761, 0.0116396564990282, 0.0116632049903274, 0.0116867860779166, 0.0117104426026344, 0.011734165251255, 0.0117579372599721, 0.0117817623540759, 0.0118056423962116, 0.0118296006694436, 0.0118535906076431, 0.0118776559829712, 0.0119017707183957, 0.0119259506464005, 0.0119501855224371, 0.0119744800031185, 0.0119988173246384, 0.0120232217013836, 0.0120476949959993, 0.0120722036808729, 0.0120967980474234, 0.0121214184910059, 0.0121461115777493, 0.0121708689257503, 0.0121956700459123, 0.0122205587103963, 0.0122454585507512, 0.0122704496607184, 0.0122954919934273, 0.0123205818235874, 0.0123457312583923, 0.0123709468171, 0.0123962163925171, 0.0124215567484498, 0.0124469418078661, 0.0124723799526691, 0.0124978739768267, 0.0125234480947256, 0.0125490566715598, 0.0125747509300709, 0.0126004563644528, 0.0126262493431568, 0.0126520972698927, 0.0126780103892088, 0.0127039663493633, 0.0127299772575498, 0.0127560589462519, 0.0127821955829859, 0.012808402068913, 0.0128346420824528, 0.0128609472885728, 0.0128873065114021, 0.0129137318581343, 0.0129402223974466, 0.0129667446017265, 0.0129933329299092, 0.0130200032144785, 0.0130467070266604, 0.0130734797567129, 0.0131003027781844, 0.013127195648849, 0.0131541332229972, 0.0131811294704676, 0.0132081871852279, 0.0132353091612458, 0.0132624758407474, 0.013289705850184, 0.0133170029148459, 0.0133443335071206, 0.0133717497810721, 0.0133992042392492, 0.0134267350658774, 0.0134542929008603, 0.0134819336235523, 0.0135096274316311, 0.0135373771190643, 0.0135651864111423, 0.0135930329561234, 0.0136209605261683, 0.0136489495635033, 0.0136769711971283, 0.0137050747871399, 0.0137332212179899, 0.0137614337727427, 0.0137897003442049, 0.0138180200010538, 0.013846417888999, 0.0138748595491052, 0.0139033440500498, 0.0139319151639938, 0.0139605300500989, 0.0139891775324941, 0.0140179134905338, 0.0140467034652829, 0.0140755567699671, 0.0141044612973928, 0.0141333984211087, 0.0141624268144369, 0.0141915017738938, 0.0142206391319633, 0.0142498314380646, 0.014279056340456, 0.0143083753064275, 0.0143377315253019, 0.0143671529367566, 0.0143966460600495, 0.0144261652603745, 0.0144557617604733, 0.0144854001700878, 0.0145151261240244, 0.0145448800176382, 0.0145747046917677, 0.0146045917645097, 0.0146345347166061, 0.0146645344793797, 0.0146945770829916, 0.0147246951237321, 0.0147548699751496, 0.0147850969806314, 0.0148153686895967, 0.0148457167670131, 0.0148761188611388, 0.0149065870791674, 0.0149370925500989, 0.0149676529690623, 0.0149982906877995, 0.0150289852172136, 0.0150597374886274, 0.01509053632617, 0.0151213807985187, 0.0151523109525442, 0.0151832923293114, 0.0152143202722073, 0.0152454143390059, 0.0152765475213528, 0.015307767316699, 0.0153390346094966, 0.0153703577816486, 0.0154017526656389, 0.0154331792145967, 0.0154646821320057, 0.0154962278902531, 0.0155278295278549, 0.0155594954267144, 0.0155912274494767, 0.0156230144202709, 0.015654843300581, 0.0156867559999228, 0.0157187059521675, 0.0157507192343473, 0.0157827939838171, 0.0158149190247059, 0.0158471092581749, 0.0158793572336435, 0.0159116499125957, 0.0159440096467733, 0.0159764420241117, 0.0160089042037725, 0.0160414315760136, 0.0160740185528994, 0.0161066725850105, 0.0161393862217665, 0.0161721389740705, 0.0162049736827612, 0.0162378530949354, 0.0162707902491093, 0.0163037963211536, 0.0163368340581656, 0.0163699388504028, 0.0164031088352203, 0.016436330974102, 0.0164696145802736, 0.0165029540657997, 0.01653634570539, 0.0165698174387217, 0.0166033133864403, 0.0166368801146746, 0.0166705194860697, 0.0167042035609484, 0.0167379397898912, 0.0167717467993498, 0.0168055985122919, 0.0168395098298788, 0.0168734844774008, 0.0169075280427933, 0.0169416125863791, 0.0169757734984159, 0.0170099698007107, 0.0170442294329405, 0.0170785542577505, 0.0171129181981087, 0.017147358506918, 0.0171818565577269, 0.0172163993120193, 0.0172510202974081, 0.0172856785356998, 0.0173204112797976, 0.0173551831394434, 0.0173900183290243, 0.0174249019473791, 0.0174598582088947, 0.0174948759377003, 0.0175299476832151, 0.0175650678575039, 0.0176002588123083, 0.0176354944705963, 0.0176707953214645, 0.0177061595022678, 0.0177415758371353, 0.0177770331501961, 0.0178125686943531, 0.0178481508046389, 0.0178838018327951, 0.017919510602951, 0.0179552733898163, 0.0179910976439714, 0.0180269535630941, 0.0180629026144743, 0.0180988907814026, 0.0181349329650402, 0.0181710440665483, 0.0182072166353464, 0.0182434264570475, 0.0182797070592642, 0.0183160472661257, 0.0183524508029222, 0.018388893455267, 0.0184253994375467, 0.018461974337697, 0.0184985809028149, 0.0185352712869644, 0.0185720268636942, 0.0186088103801012, 0.0186456702649593, 0.0186825767159462, 0.0187195483595133, 0.0187565889209509, 0.0187936648726463, 0.0188308283686638, 0.0188680198043585, 0.0189052876085043, 0.0189425982534885, 0.018979974091053, 0.0190174039453268, 0.019054900854826, 0.0190924294292927, 0.0191300455480814, 0.0191677119582891, 0.0192054286599159, 0.0192432105541229, 0.0192810334265232, 0.0193189326673746, 0.019356882199645, 0.0193948820233345, 0.019432969391346, 0.0194710809737444, 0.0195092689245939, 0.0195474941283464, 0.0195858031511307, 0.0196241531521082, 0.0196625553071499, 0.0197010207921267, 0.0197395514696836, 0.019778149202466, 0.0198167897760868, 0.0198554936796427, 0.0198942497372627, 0.0199330635368824, 0.0199719406664371, 0.0200108699500561, 0.0200498569756746, 0.0200889017432928, 0.0201280042529106, 0.0201671626418829, 0.0202063806355, 0.0202456582337618, 0.0202849898487329, 0.0203243885189295, 0.0203638281673193, 0.0204033367335796, 0.020442908629775, 0.0204825233668089, 0.020522216334939, 0.0205619391053915, 0.0206017419695854, 0.0206415913999081, 0.0206815022975206, 0.0207214746624231, 0.020761501044035, 0.0208015907555819, 0.0208417233079672, 0.0208819322288036, 0.0209221802651882, 0.020962493494153, 0.0210028719156981, 0.0210432931780815, 0.0210837852209806, 0.0211243238300085, 0.0211649239063263, 0.0212055984884501, 0.0212463084608316, 0.0212870799005032, 0.0213279090821743, 0.0213688053190708, 0.0214097630232573, 0.0214507561177015, 0.0214918255805969, 0.0215329341590405, 0.0215741246938705, 0.0216153580695391, 0.0216566473245621, 0.0216979999095201, 0.0217394195497036, 0.0217808932065964, 0.0218224059790373, 0.021863991394639, 0.0219056289643049, 0.0219473280012608, 0.0219890847802162, 0.022030895575881, 0.0220727659761906, 0.0221146866679192, 0.0221566781401634, 0.022198723629117, 0.0222408194094896, 0.0222829785197973, 0.0223251935094595, 0.0223674681037664, 0.0224098060280085, 0.0224521849304438, 0.0224946271628141, 0.0225371420383453, 0.0225797053426504, 0.0226223133504391, 0.0226649958640337, 0.0227077268064022, 0.0227505266666412, 0.0227933768182993, 0.0228362828493118, 0.0228792559355497, 0.0229222774505615, 0.0229653641581535, 0.0230084992945194, 0.0230516921728849, 0.0230949446558952, 0.0231382548809052, 0.0231816209852695, 0.0232250485569239, 0.0232685301452875, 0.0233120750635862, 0.0233556665480137, 0.0233993362635374, 0.0234430432319641, 0.0234868172556162, 0.0235306434333324, 0.0235745366662741, 0.023618483915925, 0.0236624795943499, 0.0237065423280001, 0.0237506628036499, 0.0237948391586542, 0.0238390751183033, 0.0238833706825972, 0.0239277165383101, 0.023972125723958, 0.0240165907889605, 0.0240611117333174, 0.0241056885570288, 0.0241503249853849, 0.024195022881031, 0.0242397636175156, 0.0242845844477415, 0.0243294518440962, 0.0243743788450956, 0.0244193617254496, 0.0244643930345774, 0.0245094951242208, 0.0245546530932188, 0.0245998632162809, 0.0246451329439878, 0.0246904548257589, 0.0247358456254005, 0.0247812923043966, 0.0248267967253923, 0.0248723514378071, 0.0249179657548666, 0.0249636452645063, 0.0250093750655651, 0.025055168196559, 0.0251010153442621, 0.0251469314098358, 0.0251928828656673, 0.0252389051020145, 0.0252849888056517, 0.0253311209380627, 0.0253773126751184, 0.0254235584288836, 0.025469871237874, 0.0255162380635738, 0.0255626570433378, 0.0256091486662626, 0.025655684992671, 0.025702279061079, 0.0257489252835512, 0.0257956441491842, 0.0258424133062363, 0.0258838050067425, 0.0259198192507029, 0.0259560123085976, 0.0259923208504915, 0.0260287821292877, 0.0260653644800186, 0.0261021200567484, 0.0261390041559935, 0.0261760056018829, 0.0262131579220295, 0.0262504424899817, 0.0262878630310297, 0.0263254418969154, 0.0263631325215101, 0.0264010056853294, 0.0264389645308256, 0.0264770928770304, 0.0265153385698795, 0.0265537444502115, 0.0265922993421555, 0.0266309510916471, 0.0266697816550732, 0.0267087202519178, 0.0267478246241808, 0.0267870593816042, 0.0268264133483171, 0.0268659424036741, 0.0269055739045143, 0.026945386081934, 0.0269852839410305, 0.0270253531634808, 0.0270655769854784, 0.0271058976650238, 0.0271464008837938, 0.0271870009601116, 0.0272277686744928, 0.0272686574608088, 0.0273097064346075, 0.0273508839309216, 0.0273921862244606, 0.027433643117547, 0.0274752248078585, 0.0275169666856527, 0.0275588352233171, 0.0276008397340775, 0.0276429802179337, 0.0276852641254663, 0.0277276951819658, 0.0277702379971743, 0.0278129521757364, 0.0278557986021042, 0.0278987661004066, 0.027941882610321, 0.0279851220548153, 0.028028529137373, 0.0280720517039299, 0.0281157325953245, 0.0281595550477505, 0.0282035060226917, 0.028247594833374, 0.0282918084412813, 0.0283361747860909, 0.0283807013183832, 0.0284253358840942, 0.0284701213240623, 0.0285150390118361, 0.0285600963979959, 0.028605280444026, 0.0286506284028292, 0.0286961123347282, 0.0287417210638523, 0.0287874713540077, 0.028833357617259, 0.0288794077932835, 0.028925558552146, 0.0289718694984913, 0.0290183275938034, 0.0290649011731148, 0.0291116312146187, 0.0291584860533476, 0.0292054954916239, 0.0292526483535767, 0.029299920424819, 0.0293473545461893, 0.029394892975688, 0.0294425915926695, 0.0294904205948114, 0.0295384060591459, 0.029586523771286, 0.0296347588300705, 0.0296831615269184, 0.0297316741198301, 0.0297803543508053, 0.0298291444778442, 0.0298780966550112, 0.0299271997064352, 0.0299764014780521, 0.0300257820636034, 0.030075253918767, 0.0301249008625746, 0.0301746837794781, 0.030224597081542, 0.0302746631205082, 0.030324837192893, 0.0303751826286316, 0.0304256454110146, 0.0304762590676546, 0.0305270180106163, 0.0305778961628675, 0.0306289363652468, 0.0306800939142704, 0.0307314023375511, 0.0307828448712826, 0.030834412202239, 0.0308861490339041, 0.0309379938989878, 0.0309900045394897, 0.0310421232134104, 0.0310944151133299, 0.0311468262225389, 0.0311993677169085, 0.0312520749866962, 0.0313048809766769, 0.0313578620553017, 0.0314109548926353, 0.0314642265439034, 0.0315175987780094, 0.0315711200237274, 0.0316247902810574, 0.0316785797476768, 0.0317325294017792, 0.0317866317927837, 0.0318408310413361, 0.0318951979279518, 0.0319496802985668, 0.0320043154060841, 0.0320590771734715, 0.032114002853632, 0.0321690775454044, 0.0322242453694344, 0.0322795733809471, 0.03233502805233, 0.0323906466364861, 0.0324463732540607, 0.0325022637844086, 0.0325582809746265, 0.0326144434511662, 0.0326707512140274, 0.0327271819114685, 0.0327837578952312, 0.0328404828906059, 0.0328973270952702, 0.0329543277621269, 0.0330114476382732, 0.0330687277019024, 0.0331261232495308, 0.033183678984642, 0.0332413725554943, 0.0332991816103458, 0.0333571583032608, 0.0334152579307556, 0.033473514020443, 0.033531878143549, 0.0335904061794281, 0.0336490757763386, 0.0337078534066677, 0.0337668024003506, 0.033825870603323, 0.0338850878179073, 0.033944446593523, 0.034003920853138, 0.0340635664761066, 0.0341233052313328, 0.0341832190752029, 0.0342432595789433, 0.0343034602701664, 0.0343637764453888, 0.0344242341816425, 0.0344848409295082, 0.0345455668866634, 0.0346064567565918, 0.0346674658358097, 0.0347286313772202, 0.0347899459302425, 0.0348513647913933, 0.0349129475653172, 0.0349746234714985, 0.0350364968180656, 0.0350984930992126, 0.0351606011390686, 0.0352228879928589, 0.0352852754294872, 0.0353478230535984, 0.03541050106287, 0.035473320633173, 0.0355362892150879, 0.0355993658304214, 0.0356626324355602, 0.0357259921729565, 0.0357895158231258, 0.035853173583746, 0.0359169468283653, 0.0359808914363384, 0.0360449478030205, 0.0361091680824757, 0.0361734963953495, 0.0362379960715771, 0.0363026075065136, 0.0363673903048038, 0.0364322923123837, 0.0364973247051239, 0.0365625135600567, 0.0366278365254402, 0.0366932936012745, 0.0367588922381401, 0.0368246100842953, 0.0368904955685139, 0.0369564965367317, 0.0370226614177227, 0.0370889380574226, 0.0371553786098957, 0.0372219458222389, 0.0372886434197426, 0.0373554937541485, 0.0374224595725536, 0.0374895930290222, 0.0375568494200706, 0.0376242473721504, 0.0376917980611324, 0.0377594642341137, 0.0378272905945778, 0.0378952249884605, 0.0379633344709873, 0.0380315780639648, 0.0380999445915222, 0.0381684713065624, 0.0382370948791504, 0.0383058935403824, 0.038374800235033, 0.0384438782930374, 0.0385130830109119, 0.0385824367403984, 0.0386519096791744, 0.0387215204536915, 0.0387912914156914, 0.0388611704111099, 0.0389312095940113, 0.0390013940632343, 0.0390717014670372, 0.0391421653330326, 0.039212740957737, 0.0392834730446339, 0.0393543541431427, 0.0394253619015217, 0.0394965074956417, 0.0395677797496319, 0.0396392121911049, 0.0397107750177383, 0.0397824831306934, 0.0398543365299702, 0.0399262793362141, 0.0399984195828438, 0.0400706641376019, 0.0401430800557137, 0.0402155928313732, 0.0402882657945156, 0.0403610840439796, 0.0404340326786041, 0.0405071265995502, 0.0405803322792053, 0.0406537018716335, 0.040727224200964, 0.0408008694648743, 0.0408746600151062, 0.0409485585987568, 0.0410226285457611, 0.0410968214273453, 0.0411711595952511, 0.0412456579506397, 0.0413202419877052, 0.041395016014576, 0.0414699018001556, 0.041544932872057, 0.0416201129555702, 0.0416954085230827, 0.0417708717286587, 0.0418464466929436, 0.0419221855700016, 0.041998028755188, 0.0420740470290184, 0.0421502031385899, 0.0422264635562897, 0.0423029027879238, 0.0423794314265251, 0.0424561388790607, 0.0425329655408859, 0.0426099486649036, 0.0426870733499527, 0.0427642986178398, 0.0428416952490807, 0.0429192185401917, 0.0429969131946564, 0.0430747047066689, 0.0431526452302933, 0.0432307422161102, 0.0433089584112167, 0.0433873198926449, 0.0434658154845238, 0.0435444675385952, 0.0436232537031174, 0.0437021590769291, 0.0437812171876431, 0.0438603945076466, 0.0439397320151329, 0.0440192148089409, 0.0440988317131996, 0.0441785715520382, 0.0442584566771984, 0.04433848336339, 0.0444186516106129, 0.0444989539682865, 0.0445794053375721, 0.0446599833667278, 0.0447407104074955, 0.044821560382843, 0.0449025593698025, 0.0449836850166321, 0.0450649708509445, 0.045146394520998, 0.0452279336750507, 0.0453096367418766, 0.0453914478421211, 0.0454734340310097, 0.0455555282533169, 0.0456377826631069, 0.0457201898097992, 0.0458027049899101, 0.0458853803575039, 0.0459681674838066, 0.0460511036217213, 0.0461341962218285, 0.0462174005806446, 0.0463007725775242, 0.0463842488825321, 0.0464678965508938, 0.0465516522526741, 0.0466355718672276, 0.0467196404933929, 0.0468038059771061, 0.0468881465494633, 0.0469725951552391, 0.0470572263002396, 0.0471419580280781, 0.0472268350422382, 0.0473118722438812, 0.0473970212042332, 0.0474823266267776, 0.0475677624344826, 0.0476533398032188, 0.0477390773594379, 0.0478249229490757, 0.0479109324514866, 0.0479970350861549, 0.0480833128094673, 0.0481697209179401, 0.0482562780380249, 0.0483429692685604, 0.0484297871589661, 0.0485167466104031, 0.0486038476228714, 0.048691101372242, 0.0487784780561924, 0.0488659888505936, 0.0489536672830582, 0.049041461199522, 0.0491294115781784, 0.0492174550890923, 0.0493056736886501, 0.0493940412998199, 0.0494825132191181, 0.0495711490511894, 0.0496599078178406, 0.0497488304972649, 0.0498378686606884, 0.0499270707368851, 0.0500163920223713, 0.050105843693018, 0.0501954630017281, 0.0502851940691471, 0.0503750778734684, 0.0504650883376598, 0.0505552403628826, 0.050645537674427, 0.0507359579205513, 0.0508265346288681, 0.0509172379970551, 0.0510081090033054, 0.0510990954935551, 0.0511902160942554, 0.0512814894318581, 0.0513728819787502, 0.0514644384384155, 0.0515561252832413, 0.0516479313373566, 0.051739901304245, 0.051831990480423, 0.0519242435693741, 0.0520166046917439, 0.052109133452177, 0.0522018000483513, 0.0522945858538151, 0.0523875206708908, 0.0524805784225464, 0.0525737851858139, 0.0526671260595322, 0.052760623395443, 0.0528542436659336, 0.0529479905962944, 0.0530419237911701, 0.0531359538435936, 0.0532301366329193, 0.0533244498074055, 0.053418904542923, 0.0535134971141815, 0.053608238697052, 0.0537031255662441, 0.0537981390953064, 0.0538932718336582, 0.0539885796606541, 0.0540839955210686, 0.0541795715689659, 0.0542752593755722, 0.0543711222708225, 0.0544671081006527, 0.0545632466673851, 0.0546594895422459, 0.0547558851540089, 0.0548524335026741, 0.0549490973353386, 0.0550459399819374, 0.055142879486084, 0.0552399717271328, 0.0553372129797935, 0.0554345846176147, 0.0555320903658867, 0.0556297302246094, 0.055727519094944, 0.05582544952631, 0.0559235289692879, 0.0560217313468456, 0.0561200566589832, 0.056218545883894, 0.0563171580433846, 0.0564159341156483, 0.0565148293972015, 0.056613851338625, 0.0567130446434021, 0.056812334805727, 0.0569118000566959, 0.0570113882422447, 0.0571111366152763, 0.0572110190987587, 0.05731101334095, 0.0574111565947533, 0.0575114265084267, 0.0576118677854538, 0.0577124245464802, 0.0578131303191185, 0.0579139702022076, 0.0580149404704571, 0.0581160709261894, 0.0582173205912113, 0.0583187192678452, 0.0584202520549297, 0.0585219264030457, 0.0586237423121929, 0.0587256848812103, 0.0588277876377106, 0.0589299984276295, 0.0590323768556118, 0.0591348893940449, 0.0592375248670578, 0.0593403205275536, 0.059443224221468, 0.0595462992787361, 0.0596494860947132, 0.0597528293728828, 0.0598563179373741, 0.0599599108099937, 0.0600636787712574, 0.0601675696671009, 0.0602716058492661, 0.0603757873177528, 0.0604800879955292, 0.0605845525860786, 0.0606891214847565, 0.0607938319444656, 0.0608987063169479, 0.061003714799881, 0.0611088611185551, 0.0612247958779335, 0.0613516308367252, 0.0614786483347416, 0.0616058260202408, 0.0617332011461258, 0.0618607103824615, 0.0619884356856346, 0.0621163547039032, 0.0622444301843643, 0.0623726807534695, 0.0625011026859283, 0.0626296922564507, 0.0627584904432297, 0.062887467443943, 0.0630166009068489, 0.0631459355354309, 0.063275434076786, 0.0634051039814949, 0.0635349601507187, 0.0636649876832962, 0.0637952014803886, 0.0639256089925766, 0.0640561729669571, 0.0641869157552719, 0.0643178373575211, 0.0644489377737045, 0.0645802170038223, 0.0647116899490356, 0.0648433044552803, 0.0649751201272011, 0.0651071146130562, 0.0652392879128456, 0.06537164747715, 0.0655041486024857, 0.0656368732452393, 0.0657697692513466, 0.0659028291702271, 0.0660360530018806, 0.0661694630980492, 0.0663030743598938, 0.0664368495345116, 0.0665708109736443, 0.0667049288749695, 0.066839225590229, 0.0669737160205841, 0.0671083927154541, 0.0672432407736778, 0.0673782378435135, 0.0675134509801865, 0.0676488280296326, 0.0677843913435936, 0.0679201111197472, 0.0680560246109962, 0.0681921169161797, 0.0683283731341362, 0.0684648230671883, 0.0686014443635941, 0.0687382519245148, 0.0688752382993698, 0.0690124034881592, 0.0691497400403023, 0.0692872256040573, 0.0694249272346497, 0.0695627927780151, 0.0697008594870567, 0.0698390603065491, 0.0699774846434593, 0.0701160728931427, 0.0702548325061798, 0.0703937634825706, 0.0705328732728958, 0.0706721767783165, 0.0708116590976715, 0.0709513127803802, 0.0710911303758621, 0.0712311342358589, 0.07137131690979, 0.0715117007493973, 0.0716522410511971, 0.0717929527163506, 0.0719338431954384, 0.0720749199390411, 0.0722161829471588, 0.0723576322197914, 0.0724992230534554, 0.0726410150527954, 0.0727829858660698, 0.0729251280426979, 0.0730674415826797, 0.0732099488377571, 0.0733526274561882, 0.0734954923391342, 0.0736385360360146, 0.0737817287445068, 0.0739251226186752, 0.0740686878561974, 0.0742124319076538, 0.0743563994765282, 0.0745004713535309, 0.0746447518467903, 0.0747892111539841, 0.0749338641762733, 0.0750786662101746, 0.0752236768603325, 0.075368843972683, 0.0755141973495483, 0.0756597369909286, 0.0758054256439209, 0.0759513303637505, 0.0760973766446114, 0.0762436240911484, 0.0763900205492973, 0.0765366405248642, 0.076683409512043, 0.0768303573131561, 0.0769774913787842, 0.0771248042583466, 0.0772722885012627, 0.0774199664592743, 0.0775678083300591, 0.0777158290147781, 0.077864021062851, 0.0780124068260193, 0.0781609639525414, 0.0783097073435783, 0.0784585997462273, 0.0786077007651329, 0.0787569731473923, 0.078906424343586, 0.0790560618042946, 0.0792058482766151, 0.0793558359146118, 0.0795059874653816, 0.0796563327312469, 0.0798068344593048, 0.0799575299024582, 0.0801084041595459, 0.0802594795823097, 0.0804107040166855, 0.0805621072649956, 0.08071368932724, 0.0808654353022575, 0.0810173898935318, 0.0811695232987404, 0.0813217759132385, 0.0814742892980576, 0.0816269293427467, 0.081779770553112, 0.0819327756762505, 0.0820859596133232, 0.0822393298149109, 0.0823928788304329, 0.0825466066598892, 0.0827004909515381, 0.0828545689582825, 0.0830088257789612, 0.0831632539629936, 0.083317868411541, 0.0834726467728615, 0.0836276337504387, 0.0837827920913696, 0.0839380994439125, 0.0840936079621315, 0.084249272942543, 0.0844051539897919, 0.0845611914992332, 0.0847174078226089, 0.0848737955093384, 0.0850303545594215, 0.085187129676342, 0.0853440314531326, 0.08550114184618, 0.0856584459543228, 0.0858158767223358, 0.0859735235571861, 0.0861313492059708, 0.0862893462181091, 0.0864475145936012, 0.0866058766841888, 0.0867644175887108, 0.0869231149554253, 0.0870820209383965, 0.087241068482399, 0.087400309741497, 0.0875597298145294, 0.0877193361520767, 0.0878790989518166, 0.0880390629172325, 0.0881992056965828, 0.0883595123887062, 0.0885200053453445, 0.0886806771159172, 0.0888415202498436, 0.0890025272965431, 0.0891637355089188, 0.0893251299858093, 0.0894866734743118, 0.0896484181284904, 0.0898103266954422, 0.0899724289774895, 0.0901346877217293, 0.090297132730484, 0.0904597789049149, 0.0906225815415382, 0.0907855555415154, 0.0909487381577492, 0.0911120697855949, 0.091275580227375, 0.09143927693367, 0.0916031524538994, 0.0917672142386436, 0.0919314324855804, 0.0920958518981934, 0.0922604352235794, 0.0924251899123192, 0.0925901457667351, 0.0927552506327629, 0.0929205492138863, 0.0930860340595245, 0.0932516828179359, 0.0934175103902817, 0.0935835242271423, 0.0937497243285179, 0.0939160883426666, 0.0940826311707497, 0.0942493602633476, 0.0944162532687187, 0.0945833325386047, 0.0947505906224251, 0.0949180424213409, 0.0950856432318687, 0.0952534526586533, 0.0954214259982109, 0.0955895483493805, 0.0957578867673874, 0.095926396548748, 0.0960950702428818, 0.0962639302015305, 0.0964329764246941, 0.0966021865606308, 0.0967715829610825, 0.0969411507248878, 0.0971109196543694, 0.0972808375954628, 0.0974509418010712, 0.0976212322711945, 0.0977917090058327, 0.0979623273015022, 0.0981331691145897, 0.0983041599392891, 0.098475344479084, 0.0986466854810715, 0.098818227648735, 0.0989899262785912, 0.0991618260741234, 0.0993338823318481, 0.0995061323046684, 0.0996785536408424, 0.0998511612415314, 0.100023932754993, 0.100196897983551, 0.100370042026043, 0.100543349981308, 0.100716821849346, 0.100890509784222, 0.101064331829548, 0.101238369941711, 0.101412579417229, 0.101586952805519, 0.101761527359486, 0.101936265826225, 0.102111183106899, 0.102286279201508, 0.102461561560631, 0.102637007832527, 0.102812632918358, 0.102988436818123, 0.103164426982403, 0.103340588510036, 0.103516913950443, 0.103693462908268, 0.103870138525963, 0.104047022759914, 0.104224070906639, 0.104401297867298, 0.104578711092472, 0.104756310582161, 0.104934066534042, 0.105112016201019, 0.105290144681931, 0.105468422174454, 0.105646915733814, 0.105825573205948, 0.106004416942596, 0.106183424592018, 0.106362611055374, 0.106541991233826, 0.106721520423889, 0.106901250779629, 0.107081174850464, 0.10726123303175, 0.107441507279873, 0.107621930539608, 0.107802547514439, 0.107983350753784, 0.108164332807064, 0.108345471322536, 0.108526803553104, 0.108708314597607, 0.108889989554882, 0.109071858227253, 0.109253898262978, 0.109436117112637, 0.10961851477623, 0.109801076352596, 0.109983846545219, 0.110166765749454, 0.110349878668785, 0.110533162951469, 0.110716640949249, 0.110900282859802, 0.111084096133709, 0.111268095672131, 0.111452281475067, 0.111636653542519, 0.111821167171001, 0.112005889415741, 0.112190768122673, 0.112375840544701, 0.112561099231243, 0.112746514379978, 0.112932108342648, 0.113117888569832, 0.11330384761095, 0.113489985466003, 0.113676302134991, 0.113862797617912, 0.114049479365349, 0.114236332476139, 0.114423356950283, 0.114610552787781, 0.114797927439213, 0.114985510706902, 0.115173250436783, 0.115361161530018, 0.115549273788929, 0.115737535059452, 0.11592598259449, 0.116114616394043, 0.11630342900753, 0.116492427885532, 0.116681583225727, 0.116870924830437, 0.1170604377985, 0.117250137031078, 0.117440022528172, 0.117630079388618, 0.117820307612419, 0.118010722100735, 0.118201307952404, 0.118392057716846, 0.118583030998707, 0.118774153292179, 0.118965446949005, 0.119156934320927, 0.119348585605621, 0.119540430605412, 0.119732439517975, 0.119924634695053, 0.120117008686066, 0.120309576392174, 0.120502285659313, 0.120695181190968, 0.120888292789459, 0.121081553399563, 0.121274992823601, 0.121468588709831, 0.121662385761738, 0.121856354176998, 0.122050501406193, 0.122244849801064, 0.122439369559288, 0.122634060680866, 0.122828915715218, 0.123023934662342, 0.123219154775143, 0.123414561152458, 0.123610138893127, 0.123805910348892, 0.12400184571743, 0.124197937548161, 0.124394252896309, 0.124590687453747, 0.124787345528603, 0.124984167516232, 0.125181183218956, 0.125378355383873, 0.125575706362724, 0.125773251056671, 0.125970959663391, 0.126168861985207, 0.126366928219795, 0.126565173268318, 0.126763612031937, 0.126962214708328, 0.127160981297493, 0.127359941601753, 0.127559095621109, 0.127758398652077, 0.127957910299301, 0.128157585859299, 0.128357425332069, 0.128557458519936, 0.128757655620575, 0.12895804643631, 0.129158616065979, 0.129359364509583, 0.129560261964798, 0.129761382937431, 0.129962652921677, 0.130164116621017, 0.130365744233131, 0.130567535758018, 0.130769535899162, 0.130971685051918, 0.13117404282093, 0.131376579403877, 0.131579279899597, 0.13178214430809, 0.131985202431679, 0.132188454270363, 0.132391855120659, 0.13259544968605, 0.132799223065376, 0.133003175258636, 0.133207306265831, 0.133411601185799, 0.133616089820862, 0.133820742368698, 0.13402558863163, 0.134230598807335, 0.134435787796974, 0.134641170501709, 0.134846717119217, 0.13505245745182, 0.135258346796036, 0.135464444756508, 0.135670706629753, 0.135877147316933, 0.136083766818047, 0.136290565133095, 0.136497542262077, 0.136704683303833, 0.136912032961845, 0.13711953163147, 0.137327209115028, 0.137535110116005, 0.137743130326271, 0.137951359152794, 0.138159736990929, 0.13836832344532, 0.138577073812485, 0.138786047697067, 0.138995140790939, 0.139204427599907, 0.13941390812397, 0.139623552560806, 0.139833375811577, 0.140043377876282, 0.140253558754921, 0.140463918447495, 0.140674442052841, 0.140885174274445, 0.14109605550766, 0.141307145357132, 0.141518384218216, 0.141729816794395, 0.14194144308567, 0.142153218388557, 0.14236518740654, 0.142577305436134, 0.142789617180824, 0.14300212264061, 0.14321480691433, 0.143427670001984, 0.143640697002411, 0.143853917717934, 0.144067287445068, 0.14428086578846, 0.144494593143463, 0.144708529114723, 0.144922614097595, 0.145136892795563, 0.145351365208626, 0.145565986633301, 0.145780801773071, 0.145995795726776, 0.146210968494415, 0.146426305174828, 0.146641835570335, 0.146875143051147, 0.147126123309135, 0.147377118468285, 0.147628113627434, 0.147879093885422, 0.148130029439926, 0.148380994796753, 0.148631945252419, 0.148882880806923, 0.149133801460266, 0.149384707212448, 0.14963561296463, 0.149886503815651, 0.150137409567833, 0.150388285517693, 0.150639161467552, 0.150890022516251, 0.151140868663788, 0.151391699910164, 0.15164253115654, 0.151893362402916, 0.15214416384697, 0.152394995093346, 0.152645781636238, 0.152896568179131, 0.153147339820862, 0.153398111462593, 0.153648868203163, 0.153899610042572, 0.154150366783142, 0.154401108622551, 0.154651805758476, 0.154902532696724, 0.155153229832649, 0.155403926968575, 0.155654594302177, 0.155905276536942, 0.156155943870544, 0.156406611204147, 0.156657263636589, 0.156907886266708, 0.157158523797989, 0.157409146428108, 0.157659754157066, 0.157910361886024, 0.158160954713821, 0.158411532640457, 0.158662110567093, 0.158912688493729, 0.159163221716881, 0.159413769841194, 0.159664317965508, 0.15991485118866, 0.160165369510651, 0.16041587293148, 0.160666361451149, 0.160916864871979, 0.161167323589325, 0.161417797207832, 0.16166827082634, 0.161918729543686, 0.162169173359871, 0.162419617176056, 0.162670031189919, 0.162920460104942, 0.163170844316483, 0.163421258330345, 0.163671657443047, 0.163922026753426, 0.164172410964966, 0.164422750473022, 0.164673119783401, 0.164923459291458, 0.165173783898354, 0.165424108505249, 0.165674433112144, 0.165924727916718, 0.166175022721291, 0.166425332427025, 0.166675582528114, 0.166925862431526, 0.167176127433777, 0.167426377534866, 0.167676627635956, 0.167926833033562, 0.168177083134651, 0.168427273631096, 0.168677493929863, 0.168927669525146, 0.169177860021591, 0.169428065419197, 0.169678226113319, 0.169928371906281, 0.170178517699242, 0.170428678393364, 0.170678779482841, 0.170928910374641, 0.17117902636528, 0.171429142355919, 0.171679213643074, 0.17192929983139, 0.172179386019707, 0.172429442405701, 0.172679513692856, 0.17292957007885, 0.173179596662521, 0.173429623246193, 0.173679649829865, 0.173929661512375, 0.174179643392563, 0.174429640173912, 0.174679636955261, 0.174929603934288, 0.175179570913315, 0.17542952299118, 0.175679460167885, 0.175929397344589, 0.176179334521294, 0.176429256796837, 0.176679164171219, 0.176929041743279, 0.177178949117661, 0.17742882668972, 0.177678689360619, 0.177928552031517, 0.178178429603577, 0.178428262472153, 0.178678095340729, 0.178927913308144, 0.179177731275558, 0.179427534341812, 0.179677337408066, 0.179927110671997, 0.180176913738251, 0.180426672101021, 0.180676430463791, 0.180926159024239, 0.181175947189331, 0.181425660848618, 0.181675389409065, 0.181925103068352, 0.182174801826477, 0.182424485683441, 0.182674184441566, 0.182923868298531, 0.183173537254333, 0.183423206210136, 0.183672860264778, 0.183922469615936, 0.184172108769417, 0.184421718120575, 0.184671357274055, 0.184920966625214, 0.185170546174049, 0.185420140624046, 0.185669720172882, 0.185919269919395, 0.18616883456707, 0.186418384313583, 0.186667934060097, 0.186917454004288, 0.187166973948479, 0.187416478991508, 0.187665984034538, 0.187915489077568, 0.188164979219437, 0.188414439558983, 0.188663884997368, 0.188913345336914, 0.18916280567646, 0.189412251114845, 0.189661681652069, 0.189911097288132, 0.190160498023033, 0.190409898757935, 0.190659299492836, 0.190908685326576, 0.191158041357994, 0.191407397389412, 0.191656768321991, 0.191906094551086, 0.192155420780182, 0.192404761910439, 0.192654088139534, 0.192903414368629, 0.193152695894241, 0.193401977419853, 0.193651273846626, 0.193900525569916, 0.194149807095528, 0.194399058818817, 0.194648295640945, 0.194897517561913, 0.19514673948288, 0.195395961403847, 0.195645183324814, 0.195894375443459, 0.196143567562103, 0.196392744779587, 0.196641936898232, 0.196891069412231, 0.197140216827393, 0.197389364242554, 0.197638496756554, 0.197887629270554, 0.198136731982231, 0.19838584959507, 0.198634922504425, 0.198884010314941, 0.199133098125458, 0.199382171034813, 0.199631229043007, 0.199880257248878, 0.200129315257072, 0.200378343462944, 0.200627356767654, 0.200876370072365, 0.201125368475914, 0.201374366879463, 0.201623365283012, 0.2018723487854, 0.202121287584305, 0.20237024128437, 0.202619209885597, 0.20286813378334, 0.203117072582245, 0.203365996479988, 0.203614890575409, 0.203863814473152, 0.204112693667412, 0.204361572861671, 0.204610466957092, 0.20485931634903, 0.205108165740967, 0.205357015132904, 0.20560584962368, 0.205854684114456, 0.20610348880291, 0.206352323293686, 0.206601098179817, 0.206849902868271, 0.207098692655563, 0.207347452640533, 0.207596212625504, 0.207844972610474, 0.208093732595444, 0.208342432975769, 0.208591163158417, 0.208839893341064, 0.20908859372139, 0.209337294101715, 0.209585979580879, 0.209834665060043, 0.210083320736885, 0.210331976413727, 0.210580661892891, 0.210829302668571, 0.211077943444252, 0.21132655441761, 0.21157518029213, 0.211823791265488, 0.212072372436523, 0.212320953607559, 0.212569534778595, 0.21281810104847, 0.213066652417183, 0.213315203785896, 0.21356375515461, 0.213812276721001, 0.214060813188553, 0.214309304952621, 0.214557826519012, 0.214806333184242, 0.21505481004715, 0.215303286910057, 0.215551748871803, 0.215800210833549, 0.216048657894135, 0.21629710495472, 0.216545537114143, 0.216793954372406, 0.217042371630669, 0.217290759086609, 0.217539146542549, 0.217787533998489, 0.21803592145443, 0.218284279108047, 0.218532636761665, 0.218780994415283, 0.219029307365417, 0.219277650117874, 0.21952597796917, 0.219774276018143, 0.220022588968277, 0.220270872116089, 0.22051914036274, 0.220767423510551, 0.221015706658363, 0.221263945102692, 0.221512168645859, 0.221760421991348, 0.222008660435677, 0.222256869077682, 0.222505062818527, 0.222753286361694, 0.223001480102539, 0.223249644041061, 0.223497822880745, 0.223745986819267, 0.223994135856628, 0.224242269992828, 0.224490404129028, 0.224738538265228, 0.224986657500267, 0.225234761834145, 0.225482881069183, 0.225730955600739, 0.225979030132294, 0.226227104663849, 0.226475149393082, 0.226723209023476, 0.226971253752708, 0.227219268679619, 0.227467313408852, 0.227715328335762, 0.227963328361511, 0.228211313486099, 0.228459298610687, 0.228707268834114, 0.228955239057541, 0.229203224182129, 0.229451164603233, 0.229699105024338, 0.229947030544281, 0.230194956064224, 0.230442881584167, 0.230690762400627, 0.230938673019409, 0.231186553835869, 0.231434419751167, 0.231682300567627, 0.231930151581764, 0.232178002595901, 0.232425838708878, 0.232673659920692, 0.23292151093483, 0.233169287443161, 0.233417093753815, 0.233664870262146, 0.2339126765728, 0.234160453081131, 0.234408214688301, 0.234655991196632, 0.234903708100319, 0.235151454806328, 0.235399186611176, 0.235646903514862, 0.235894605517387, 0.236142292618752, 0.236390024423599, 0.236637696623802, 0.236885353922844, 0.237132996320724, 0.237380668520927, 0.237628325819969, 0.23787596821785, 0.238123580813408, 0.238371193408966, 0.238618806004524, 0.238866418600082, 0.239114001393318, 0.239361569285393, 0.239609152078629, 0.239856705069542, 0.240104287862778, 0.24035182595253, 0.240599349141121, 0.240846872329712, 0.241094350814819, 0.24134187400341, 0.24158938229084, 0.241836875677109, 0.242084354162216, 0.242331802845001, 0.242579281330109, 0.242826715111732, 0.243074133992195, 0.243321612477303, 0.243569001555443, 0.243816450238228, 0.244063839316368, 0.244311228394508, 0.244558587670326, 0.244806006550789, 0.245053380727768, 0.245300740003586, 0.245548069477081, 0.245795413851738, 0.246042773127556, 0.246290072798729, 0.246537387371063, 0.246784687042236, 0.247031971812248, 0.24727925658226, 0.247526526451111, 0.247773811221123, 0.248021066188812, 0.248268291354179, 0.248515531420708, 0.248762756586075, 0.249009981751442, 0.249257206916809, 0.249504402279854, 0.249751597642899, 0.249998763203621, 0.250245928764343, 0.250493109226227, 0.25074028968811, 0.250987410545349, 0.25123456120491, 0.251481682062149, 0.251728773117065, 0.251975923776627, 0.252223014831543, 0.252470105886459, 0.252717167139053, 0.25296425819397, 0.253211289644241, 0.253458380699158, 0.253705412149429, 0.253952443599701, 0.254199475049973, 0.254446476697922, 0.254693478345871, 0.25494047999382, 0.255187481641769, 0.255434453487396, 0.255681425333023, 0.25592839717865, 0.256175309419632, 0.256422281265259, 0.256669223308563, 0.256916135549545, 0.257163047790527, 0.257409960031509, 0.257656872272491, 0.257903754711151, 0.258150607347488, 0.258397489786148, 0.258644342422485, 0.258891195058823, 0.25913804769516, 0.259384870529175, 0.25963169336319, 0.259878486394882, 0.260125309228897, 0.26037210226059, 0.26061886548996, 0.260865658521652, 0.261112421751022, 0.261359184980392, 0.26160591840744, 0.26185268163681, 0.262099415063858, 0.262346118688583, 0.262592822313309, 0.262839525938034, 0.263086229562759, 0.263332903385162, 0.263579607009888, 0.263826251029968, 0.264072895050049, 0.264319568872452, 0.264566212892532, 0.264812827110291, 0.265059471130371, 0.265306055545807, 0.265552669763565, 0.265799283981323, 0.266045838594437, 0.26629239320755, 0.266538977622986, 0.266785502433777, 0.26703205704689, 0.267278611660004, 0.267525136470795, 0.267771661281586, 0.268018156290054, 0.268264651298523, 0.268511146306992, 0.268757611513138, 0.269004076719284, 0.269250571727753, 0.269497007131577, 0.2697434425354, 0.269989907741547, 0.270236313343048, 0.270482748746872, 0.270729124546051, 0.270975530147552, 0.271210342645645, 0.271433472633362, 0.271656334400177, 0.271878927946091, 0.27210134267807, 0.272323459386826, 0.27254530787468, 0.272766947746277, 0.272988319396973, 0.273209512233734, 0.273430407047272, 0.273651033639908, 0.273871421813965, 0.274091601371765, 0.274311512708664, 0.274531185626984, 0.274750590324402, 0.274969786405563, 0.275188714265823, 0.275407403707504, 0.275625824928284, 0.275844007730484, 0.276061981916428, 0.27627968788147, 0.27649712562561, 0.276714354753494, 0.276931315660477, 0.27714803814888, 0.277364522218704, 0.277580738067627, 0.277796715497971, 0.278012454509735, 0.278227925300598, 0.278443187475204, 0.278658211231232, 0.278872936964035, 0.279087454080582, 0.279301702976227, 0.279515713453293, 0.279729515314102, 0.27994304895401, 0.280156284570694, 0.280369311571121, 0.280582129955292, 0.280794680118561, 0.281006991863251, 0.281219035387039, 0.281430840492249, 0.281642407178879, 0.281853705644608, 0.282064765691757, 0.28227561712265, 0.282486200332642, 0.282696515321732, 0.282906591892242, 0.283116430044174, 0.283326029777527, 0.2835353910923, 0.283744484186172, 0.283953338861465, 0.284161984920502, 0.284370332956314, 0.284578442573547, 0.284786343574524, 0.284993946552277, 0.285201340913773, 0.285408496856689, 0.285615384578705, 0.285822033882141, 0.286028414964676, 0.286234587430954, 0.286440491676331, 0.286646127700806, 0.286851555109024, 0.287056773900986, 0.287261694669724, 0.287466377019882, 0.287670791149139, 0.28787499666214, 0.288078933954239, 0.288282632827759, 0.2884860932827, 0.288689315319061, 0.288892269134521, 0.289094984531403, 0.289297461509705, 0.289499670267105, 0.289701640605927, 0.289903402328491, 0.290104895830154, 0.290306121110916, 0.290507107973099, 0.290707856416702, 0.290908366441727, 0.291108638048172, 0.291308641433716, 0.291508406400681, 0.291707962751389, 0.291907221078873, 0.2921062707901, 0.292305022478104, 0.29250356554985, 0.292701870203018, 0.292899936437607, 0.293097704648972, 0.293295294046402, 0.293492585420609, 0.293689668178558, 0.293886482715607, 0.294083058834076, 0.294279366731644, 0.294475495815277, 0.294671297073364, 0.294866919517517, 0.295062243938446, 0.295257359743118, 0.295452207326889, 0.295646816492081, 0.295841157436371, 0.296035289764404, 0.296229153871536, 0.296422809362411, 0.296616166830063, 0.296809315681458, 0.297002196311951, 0.297194868326187, 0.2973872423172, 0.297579407691956, 0.29777130484581, 0.297962963581085, 0.298154383897781, 0.298345595598221, 0.298536479473114, 0.29872715473175, 0.298917591571808, 0.299107789993286, 0.299297690391541, 0.299487411975861, 0.299676865339279, 0.299866080284119, 0.300055027008057, 0.300243735313416, 0.300432205200195, 0.300620436668396, 0.300808399915695, 0.30099618434906, 0.301183611154556, 0.301370859146118, 0.301557868719101, 0.30174458026886, 0.301931083202362, 0.302117377519608, 0.302303373813629, 0.302489131689072, 0.302674680948257, 0.302859961986542, 0.303044974803925, 0.303229749202728, 0.30341425538063, 0.303598582744598, 0.303782612085342, 0.30396643280983, 0.304149985313416, 0.304333299398422, 0.30451637506485, 0.304699182510376, 0.304881751537323, 0.305064052343369, 0.30524617433548, 0.305427998304367, 0.305609583854675, 0.305790930986404, 0.305972009897232, 0.306152880191803, 0.306333482265472, 0.30651381611824, 0.306693941354752, 0.306873828172684, 0.307053446769714, 0.307232826948166, 0.307411968708038, 0.307590872049332, 0.307769507169724, 0.307947874069214, 0.308126032352448, 0.308303952217102, 0.308481574058533, 0.308658987283707, 0.308836162090302, 0.309013068675995, 0.309189766645432, 0.309366226196289, 0.309542417526245, 0.3097183406353, 0.309894025325775, 0.310069471597672, 0.310244679450989, 0.310419619083405, 0.310594320297241, 0.310768812894821, 0.310943007469177, 0.311116993427277, 0.311290711164474, 0.311464190483093, 0.311637461185455, 0.311810463666916, 0.311983168125153, 0.312155663967133, 0.312327921390533, 0.312499940395355, 0.312671691179276, 0.312843233346939, 0.313014477491379, 0.313185513019562, 0.313356310129166, 0.313526839017868, 0.313697129487991, 0.313867151737213, 0.314036965370178, 0.314206540584564, 0.314375847578049, 0.314544856548309, 0.314713686704636, 0.314882278442383, 0.315050572156906, 0.315218657255173, 0.315386474132538, 0.315554082393646, 0.315721422433853, 0.315888524055481, 0.316055357456207, 0.316221982240677, 0.316388338804245, 0.316554456949234, 0.316720306873322, 0.316885948181152, 0.317051321268082, 0.317216426134109, 0.317381292581558, 0.31754595041275, 0.317710340023041, 0.317874491214752, 0.318038403987885, 0.318202048540115, 0.318365454673767, 0.31852862238884, 0.318691551685333, 0.318854212760925, 0.319016635417938, 0.319178819656372, 0.319340765476227, 0.31950244307518, 0.319663912057877, 0.319825083017349, 0.319986075162888, 0.320146769285202, 0.320307224988937, 0.320467442274094, 0.320627421140671, 0.320787131786346, 0.320946633815765, 0.32110583782196, 0.321264833211899, 0.321423590183258, 0.321582049131393, 0.321740329265594, 0.321898311376572, 0.322056084871292, 0.322213619947433, 0.322370857000351, 0.322527885437012, 0.322684645652771, 0.322841197252274, 0.322997480630875, 0.323153525590897, 0.323309332132339, 0.323464870452881, 0.323620170354843, 0.323775231838226, 0.323930025100708, 0.324084609746933, 0.324238926172256, 0.324393004179001, 0.324546843767166, 0.324700385332108, 0.324853777885437, 0.32500684261322, 0.325159668922424, 0.325312286615372, 0.32546466588974, 0.325616747140884, 0.325768619775772, 0.325920224189758, 0.326071590185165, 0.326222717761993, 0.326373606920242, 0.32652422785759, 0.32667464017868, 0.32682478427887, 0.326974660158157, 0.327124327421188, 0.327273726463318, 0.327422887086868, 0.32757180929184, 0.327720493078232, 0.3278688788414, 0.328017085790634, 0.328165024518967, 0.328312695026398, 0.328460156917572, 0.328607320785522, 0.328754305839539, 0.328900992870331, 0.329047471284866, 0.3291936814785, 0.329339653253555, 0.329485386610031, 0.329630821943283, 0.329776078462601, 0.329921007156372, 0.330065786838531, 0.330210268497467, 0.330354511737823, 0.330498516559601, 0.330642282962799, 0.330785751342773, 0.330929040908813, 0.331072062253952, 0.331214874982834, 0.331357389688492, 0.331499665975571, 0.331641674041748, 0.331783473491669, 0.331925064325333, 0.332066357135773, 0.332207411527634, 0.332348197698593, 0.332488745450974, 0.332629084587097, 0.332769155502319, 0.33290895819664, 0.333048552274704, 0.333187878131866, 0.33332696557045, 0.333465814590454, 0.333604454994202, 0.333742767572403, 0.333880871534348, 0.334018737077713, 0.334156364202499, 0.334293723106384, 0.33443084359169, 0.334567725658417, 0.334704339504242, 0.33484074473381, 0.334976851940155, 0.335112780332565, 0.335248410701752, 0.335383832454681, 0.33551898598671, 0.335653901100159, 0.335788577795029, 0.335922986268997, 0.336057156324387, 0.336191087961197, 0.336324781179428, 0.336458206176758, 0.336591422557831, 0.33672434091568, 0.336857050657272, 0.336989521980286, 0.337121725082397, 0.33725368976593, 0.337385386228561, 0.337516874074936, 0.337648093700409, 0.337779104709625, 0.337909817695618, 0.338040322065353, 0.338170558214188, 0.33830052614212, 0.338430315256119, 0.338559806346893, 0.338689088821411, 0.338818103075027, 0.338946849107742, 0.3390753865242, 0.339203655719757, 0.339331716299057, 0.339459478855133, 0.339587032794952, 0.339714348316193, 0.339841365814209, 0.339968204498291, 0.340094774961472, 0.340221047401428, 0.340347141027451, 0.340472966432571, 0.340598523616791, 0.340723872184753, 0.340848952531815, 0.340973794460297, 0.3410983979702, 0.341222733259201, 0.341346830129623, 0.341470688581467, 0.341594308614731, 0.341717660427094, 0.341840773820877, 0.341963648796082, 0.342086285352707, 0.342208653688431, 0.342330813407898, 0.342452704906464, 0.34257435798645, 0.342695772647858, 0.342816889286041, 0.342937827110291, 0.343058466911316, 0.343178898096085, 0.343299061059952, 0.34341898560524, 0.343538671731949, 0.343658119440079, 0.343777298927307, 0.343896269798279, 0.344014942646027, 0.344133406877518, 0.344251573085785, 0.344369560480118, 0.344487279653549, 0.344604760408401, 0.34472194314003, 0.344838947057724, 0.344955682754517, 0.345072150230408, 0.34518837928772, 0.345304399728775, 0.345420151948929, 0.345535665750504, 0.345650941133499, 0.345765948295593, 0.345880717039108, 0.345995217561722, 0.346109479665756, 0.346223533153534, 0.34633731842041, 0.346450865268707, 0.346564143896103, 0.346677154302597, 0.346790015697479, 0.346902549266815, 0.347014874219894, 0.347126930952072, 0.347238749265671, 0.347350299358368, 0.347461640834808, 0.34757274389267, 0.347683548927307, 0.347794145345688, 0.34790450334549, 0.348014622926712, 0.348124444484711, 0.348234057426453, 0.348343431949615, 0.348452568054199, 0.348561435937881, 0.348670035600662, 0.348778456449509, 0.348886579275131, 0.348994433879852, 0.349102079868317, 0.349209487438202, 0.349316656589508, 0.349423557519913, 0.349530220031738, 0.349636644124985, 0.34974279999733, 0.349848717451096, 0.349954396486282, 0.35005983710289, 0.350165009498596, 0.350269943475723, 0.350374639034271, 0.35047909617424, 0.35058331489563, 0.350687265396118, 0.350790977478027, 0.350894421339035, 0.350997656583786, 0.351100623607635, 0.351203352212906, 0.351305812597275, 0.351408094167709, 0.35151007771492, 0.351611822843552, 0.351713359355927, 0.351814597845078, 0.351915597915649, 0.352016359567642, 0.352103769779205, 0.352177768945694, 0.352251470088959, 0.352324962615967, 0.352398067712784, 0.352470934391022, 0.352543532848358, 0.352615803480148, 0.352687805891037, 0.352759510278702, 0.352830946445465, 0.352902114391327, 0.352972954511642, 0.353043526411057, 0.353113830089569, 0.353183805942535, 0.353253543376923, 0.353323012590408, 0.353392153978348, 0.353461027145386, 0.3535296022892, 0.353597909212112, 0.353665888309479, 0.353733628988266, 0.353801101446152, 0.353868275880814, 0.353935122489929, 0.354001700878143, 0.354068040847778, 0.354134052991867, 0.354199796915054, 0.354265242815018, 0.354330360889435, 0.354395240545273, 0.354459851980209, 0.3545241355896, 0.354588180780411, 0.354651898145676, 0.354715377092361, 0.354778558015823, 0.354841411113739, 0.354904055595398, 0.354966342449188, 0.355028361082077, 0.355090111494064, 0.355151563882828, 0.35521274805069, 0.355273604393005, 0.355334252119064, 0.355394542217255, 0.355454564094543, 0.355514317750931, 0.355573803186417, 0.355632990598679, 0.355691850185394, 0.355750471353531, 0.355808794498444, 0.355866849422455, 0.355924606323242, 0.355982035398483, 0.356039226055145, 0.356096148490906, 0.35615274310112, 0.356209099292755, 0.356265127658844, 0.356320858001709, 0.356376349925995, 0.356431543827057, 0.356486439704895, 0.356541037559509, 0.356595396995544, 0.356649458408356, 0.356703191995621, 0.356756687164307, 0.356809884309769, 0.356862783432007, 0.356915384531021, 0.356967717409134, 0.357019811868668, 0.357071548700333, 0.357123047113419, 0.357174247503281, 0.357225179672241, 0.357275784015656, 0.357326120138168, 0.357376158237457, 0.357425957918167, 0.357475399971008, 0.357524663209915, 0.357573539018631, 0.35762220621109, 0.357670545578003, 0.357718616724014, 0.357766389846802, 0.357813864946365, 0.357861071825027, 0.357908010482788, 0.357954651117325, 0.358000993728638, 0.358047097921371, 0.358092844486237, 0.358138352632523, 0.358183562755585, 0.358228474855423, 0.358273148536682, 0.358317464590073, 0.358361542224884, 0.358405351638794, 0.358448833227158, 0.35849204659462, 0.35853499174118, 0.358577638864517, 0.35861998796463, 0.358662068843842, 0.358703851699829, 0.358745366334915, 0.358786582946777, 0.358827531337738, 0.358868181705475, 0.35890856385231, 0.358948618173599, 0.358988434076309, 0.359027922153473, 0.359067142009735, 0.359106093645096, 0.359144777059555, 0.359183132648468, 0.359221220016479, 0.359259039163589, 0.359296560287476, 0.359333783388138, 0.359370708465576, 0.359407395124435, 0.359443783760071, 0.35947984457016, 0.35951566696167, 0.359551161527634, 0.359586417675018, 0.359621345996857, 0.359656035900116, 0.359690427780151, 0.359724521636963, 0.359758317470551, 0.359791845083237, 0.359825104475021, 0.359858065843582, 0.359890729188919, 0.35992306470871, 0.359955191612244, 0.359987050294876, 0.36001855134964, 0.360049813985825, 0.360080778598785, 0.360111474990845, 0.360141843557358, 0.360171943902969, 0.360201776027679, 0.360231310129166, 0.360260546207428, 0.360289514064789, 0.360318213701248, 0.360346585512161, 0.360374689102173, 0.360402554273605, 0.360430061817169, 0.360457330942154, 0.360484331846237, 0.360511004924774, 0.360537379980087, 0.360563486814499, 0.360589325428009, 0.360614866018295, 0.36064013838768, 0.360665112733841, 0.360689789056778, 0.360714197158813, 0.360738337039948, 0.360762178897858, 0.360785722732544, 0.360808998346329, 0.36083197593689, 0.360854655504227, 0.360877066850662, 0.360899209976196, 0.360921055078506, 0.360942602157593, 0.360963881015778, 0.360984861850739, 0.361005574464798, 0.361025989055634, 0.361046105623245, 0.361065983772278, 0.361085504293442, 0.361104756593704, 0.361123770475388, 0.361142486333847, 0.361160904169083, 0.361179023981094, 0.361196905374527, 0.361214458942413, 0.361231744289398, 0.361248731613159, 0.361265450716019, 0.361281871795654, 0.361298024654388, 0.361313849687576, 0.361329436302185, 0.36134472489357, 0.361359715461731, 0.36137443780899, 0.361388891935349, 0.36140301823616, 0.361416876316071, 0.361430436372757, 0.361443758010864, 0.361456751823425, 0.361469477415085, 0.361481934785843, 0.361494034528732, 0.361505895853043, 0.361517488956451, 0.361528813838959, 0.361539781093597, 0.361550509929657, 0.361560970544815, 0.361571133136749, 0.36158099770546, 0.361590594053268, 0.361599892377853, 0.361608892679214, 0.361617624759674, 0.36162605881691, 0.361634224653244, 0.361642092466354, 0.361649692058563, 0.361656993627548, 0.361664026975632, 0.361670762300491, 0.361677199602127, 0.361683368682861, 0.361689239740372, 0.361694842576981, 0.361700177192688, 0.361705183982849, 0.361709922552109, 0.361714363098145, 0.361718535423279, 0.361722439527512, 0.361726015806198, 0.361729353666306, 0.361732393503189, 0.361735105514526, 0.361737579107285, 0.361739754676819, 0.361741662025452, 0.361743271350861, 0.361744582653046, 0.361745595932007, 0.361746340990067, 0.361746817827225, 0.361747026443481, 0.36174687743187, 0.361746490001678, 0.361745804548264, 0.36174488067627, 0.361743599176407, 0.361742109060287, 0.361740261316299, 0.361738175153732, 0.361735790967941, 0.361733108758926, 0.361730188131332, 0.36172690987587, 0.361723393201828, 0.361719578504562, 0.361715495586395, 0.361711084842682, 0.361706435680389, 0.361701488494873, 0.36169621348381, 0.361690729856491, 0.361684948205948, 0.361678838729858, 0.361672461032867, 0.361665785312653, 0.361658841371536, 0.361651629209518, 0.361644119024277, 0.361636310815811, 0.361628204584122, 0.361619859933853, 0.361611187458038, 0.361602246761322, 0.361593037843704, 0.361583530902863, 0.361573725938797, 0.36156365275383, 0.361553251743317, 0.361542612314224, 0.361531674861908, 0.36152046918869, 0.361508935689926, 0.361497193574905, 0.361485093832016, 0.361472725868225, 0.36146005988121, 0.361447155475616, 0.361433953046799, 0.361420452594757, 0.361406654119492, 0.361392587423325, 0.361378252506256, 0.361363589763641, 0.361348688602448, 0.361333459615707, 0.361317932605743, 0.361302196979523, 0.361286103725433, 0.361269742250443, 0.361253142356873, 0.361236184835434, 0.361218988895416, 0.361201494932175, 0.361183732748032, 0.361165672540665, 0.361147314310074, 0.361128658056259, 0.361109763383865, 0.361090540885925, 0.361071079969406, 0.361051291227341, 0.361031234264374, 0.361010909080505, 0.360990315675735, 0.360969364643097, 0.360948145389557, 0.360926687717438, 0.360904932022095, 0.360882848501205, 0.360860556364059, 0.360837906599045, 0.360815018415451, 0.360791802406311, 0.360768347978592, 0.360744565725327, 0.360720545053482, 0.360696166753769, 0.360671609640121, 0.360646694898605, 0.360621511936188, 0.360596030950546, 0.360570251941681, 0.360544234514236, 0.360517889261246, 0.360491275787354, 0.360464364290237, 0.360437214374542, 0.360409736633301, 0.360381990671158, 0.360353946685791, 0.3603256046772, 0.360297024250031, 0.360268145799637, 0.360238939523697, 0.360209494829178, 0.360179752111435, 0.360149681568146, 0.3601194024086, 0.360088795423508, 0.360057890415192, 0.360026746988297, 0.359995305538177, 0.35996350646019, 0.359931498765945, 0.359899193048477, 0.359866619110107, 0.359833717346191, 0.359800547361374, 0.359767079353333, 0.35973334312439, 0.359699338674545, 0.359665036201477, 0.359630435705185, 0.359595566987991, 0.359560370445251, 0.359524935483932, 0.35948920249939, 0.359453201293945, 0.359416902065277, 0.359380304813385, 0.359343409538269, 0.359306246042252, 0.359268844127655, 0.35923108458519, 0.359193086624146, 0.3591548204422, 0.359116196632385, 0.359077364206314, 0.359038203954697, 0.358998745679855, 0.358959048986435, 0.358919024467468, 0.358878761529922, 0.35883817076683, 0.358797311782837, 0.35875615477562, 0.358714729547501, 0.358673006296158, 0.358630985021591, 0.358588695526123, 0.358546137809753, 0.35850328207016, 0.358460128307343, 0.358416706323624, 0.358372986316681, 0.358328968286514, 0.358284711837769, 0.358240127563477, 0.358195275068283, 0.358150154352188, 0.358104735612869, 0.358059048652649, 0.358013033866882, 0.357966750860214, 0.357920199632645, 0.357873350381851, 0.357826173305511, 0.357778817415237, 0.357731074094772, 0.357683122158051, 0.357634842395782, 0.357586264610291, 0.357537448406219, 0.35748827457428, 0.357438892126083, 0.357389211654663, 0.357339203357697, 0.357288897037506, 0.357238382101059, 0.357187569141388, 0.357136398553848, 0.357085019350052, 0.357033312320709, 0.356981337070465, 0.356929063796997, 0.356876522302628, 0.356823682785034, 0.356770545244217, 0.356717169284821, 0.3566634953022, 0.356609493494034, 0.356555253267288, 0.356500685214996, 0.356445878744125, 0.356390774250031, 0.356335371732712, 0.356279700994492, 0.356223702430725, 0.356167495250702, 0.356110960245132, 0.356054097414017, 0.355996966362, 0.355939596891403, 0.355881929397583, 0.355823993682861, 0.355765730142593, 0.355707168579102, 0.355648338794708, 0.355589240789413, 0.355529844760895, 0.355470180511475, 0.355410248041153, 0.355349987745285, 0.355289459228516, 0.355228632688522, 0.355167537927628, 0.355106204748154, 0.355044513940811, 0.354982525110245, 0.354920297861099, 0.35485777258873, 0.354794979095459, 0.354731887578964, 0.354668498039246, 0.354604840278625, 0.354540914297104, 0.354476660490036, 0.354412138462067, 0.354347318410873, 0.354282230138779, 0.354216873645782, 0.35415118932724, 0.354085266590118, 0.354019045829773, 0.353952497243881, 0.35388571023941, 0.353818625211716, 0.35375127196312, 0.353683590888977, 0.353615701198578, 0.353545784950256, 0.353473961353302, 0.353401958942413, 0.353329688310623, 0.353257238864899, 0.353184580802917, 0.353111743927002, 0.353038668632507, 0.352965414524078, 0.35289192199707, 0.352818250656128, 0.352744340896606, 0.352670252323151, 0.352595955133438, 0.352521449327469, 0.352446764707565, 0.352371841669083, 0.352296710014343, 0.352221369743347, 0.352145820856094, 0.352070093154907, 0.351994156837463, 0.35191798210144, 0.351841658353806, 0.351765096187592, 0.351688325405121, 0.351611316204071, 0.351534157991409, 0.351456761360168, 0.351379185914993, 0.351301401853561, 0.35122337937355, 0.351145178079605, 0.351066738367081, 0.350988149642944, 0.350909322500229, 0.350830286741257, 0.350751012563705, 0.350671589374542, 0.350591957569122, 0.350512087345123, 0.35043203830719, 0.350351780653, 0.350271284580231, 0.350190609693527, 0.350109726190567, 0.35002863407135, 0.349947303533554, 0.349865794181824, 0.349784106016159, 0.349702179431915, 0.349620074033737, 0.349537760019302, 0.349455207586288, 0.349372506141663, 0.349289536476135, 0.349206387996674, 0.349123030900955, 0.34903946518898, 0.348955690860748, 0.348871737718582, 0.348787546157837, 0.348703175783157, 0.348618566989899, 0.348533779382706, 0.348448783159256, 0.348363548517227, 0.348278164863586, 0.348192542791367, 0.34810671210289, 0.348020672798157, 0.347934454679489, 0.347847998142242, 0.347761362791061, 0.347674489021301, 0.347587466239929, 0.347500175237656, 0.347412705421448, 0.347324997186661, 0.347237139940262, 0.347149044275284, 0.347060739994049, 0.346972227096558, 0.346883535385132, 0.346794635057449, 0.34670552611351, 0.346616208553314, 0.346526652574539, 0.34643691778183, 0.346346974372864, 0.346256822347641, 0.346166461706161, 0.346075892448425, 0.345985174179077, 0.345894187688828, 0.345802992582321, 0.34571161866188, 0.345620036125183, 0.345528215169907, 0.345436245203018, 0.345344036817551, 0.345251619815826, 0.345158994197845, 0.345066159963608, 0.344973146915436, 0.344879895448685, 0.344786465167999, 0.344692826271057, 0.344598948955536, 0.344504922628403, 0.34441065788269, 0.344316184520721, 0.344221502542496, 0.344126641750336, 0.344031542539597, 0.343936234712601, 0.343840718269348, 0.343745052814484, 0.343649119138718, 0.343553006649017, 0.34345668554306, 0.343360155820847, 0.343263447284698, 0.343166500329971, 0.343069344758987, 0.342971980571747, 0.34287440776825, 0.342776656150818, 0.34267869591713, 0.342580497264862, 0.34248211979866, 0.342383533716202, 0.342284768819809, 0.342185735702515, 0.342086553573608, 0.341987162828445, 0.341887503862381, 0.341787725687027, 0.341687709093094, 0.341587454080582, 0.341486990451813, 0.341386348009109, 0.34128549695015, 0.341184467077255, 0.341083198785782, 0.340981721878052, 0.340880036354065, 0.340778142213821, 0.340676069259644, 0.340573817491531, 0.340471297502518, 0.34036859869957, 0.340265661478043, 0.340162545442581, 0.340059220790863, 0.339955717325211, 0.339851975440979, 0.339748054742813, 0.339643895626068, 0.339539527893066, 0.339435011148453, 0.339330226182938, 0.339225262403488, 0.339120090007782, 0.339014708995819, 0.338909119367599, 0.338803321123123, 0.33869731426239, 0.338591128587723, 0.338484734296799, 0.338378131389618, 0.338271290063858, 0.338164269924164, 0.338057041168213, 0.337949603796005, 0.337841957807541, 0.33773410320282, 0.337626069784164, 0.33751779794693, 0.337409317493439, 0.337300658226013, 0.337191790342331, 0.33708268404007, 0.336973369121552, 0.336863934993744, 0.336754202842712, 0.336644291877747, 0.336534172296524, 0.336423873901367, 0.336313337087631, 0.336202621459961, 0.336091697216034, 0.335980504751205, 0.335869193077087, 0.335757613182068, 0.335645854473114, 0.335533916950226, 0.335421741008759, 0.335309356451035, 0.335196763277054, 0.335083991289139, 0.334971010684967, 0.334857791662216, 0.334744364023209, 0.334630757570267, 0.334516942501068, 0.334402948617935, 0.334288686513901, 0.334174245595932, 0.334059625864029, 0.333944797515869, 0.33382973074913, 0.333714455366135, 0.333599001169205, 0.333483338356018, 0.333367466926575, 0.333251357078552, 0.333135068416595, 0.333018571138382, 0.332901895046234, 0.332784980535507, 0.332667857408524, 0.332550555467606, 0.332433044910431, 0.332315325737, 0.332197368144989, 0.332079201936722, 0.33196085691452, 0.331842333078384, 0.331723570823669, 0.331604599952698, 0.331485420465469, 0.331366062164307, 0.331246495246887, 0.331126719713211, 0.331006705760956, 0.330886512994766, 0.33076611161232, 0.330645471811295, 0.330524682998657, 0.330403625965118, 0.33028244972229, 0.330160975456238, 0.330039352178574, 0.32991749048233, 0.32979542016983, 0.329673200845718, 0.329550713300705, 0.32942807674408, 0.329305201768875, 0.329182088375092, 0.329058796167374, 0.328935325145721, 0.328811645507812, 0.328687727451324, 0.328563630580902, 0.328439295291901, 0.328314810991287, 0.32819002866745, 0.328065097332001, 0.327939987182617, 0.327814638614655, 0.327689111232758, 0.327563315629959, 0.327437341213226, 0.327311187982559, 0.327184826135635, 0.327058225870132, 0.326931446790695, 0.326804488897324, 0.326677292585373, 0.326549887657166, 0.326422274112701, 0.326294422149658, 0.326166421175003, 0.326038211584091, 0.3259097635746, 0.325781106948853, 0.325652271509171, 0.325523257255554, 0.325393974781036, 0.325264513492584, 0.325134873390198, 0.325004994869232, 0.32487490773201, 0.324744641780853, 0.324614137411118, 0.324483424425125, 0.324352532625198, 0.324221402406693, 0.324090093374252, 0.323958575725555, 0.323826879262924, 0.323694944381714, 0.323562830686569, 0.323430448770523, 0.323297888040543, 0.32316517829895, 0.323032200336456, 0.322899043560028, 0.322765648365021, 0.322632044553757, 0.322498321533203, 0.322364300489426, 0.322230100631714, 0.322095721960068, 0.321961104869843, 0.321826279163361, 0.321691274642944, 0.321556031703949, 0.321420609951019, 0.32128494977951, 0.321149170398712, 0.32101309299469, 0.320876836776733, 0.32074037194252, 0.320603728294373, 0.320466846227646, 0.320329755544662, 0.320192486047745, 0.32005500793457, 0.319917321205139, 0.319779396057129, 0.319641292095184, 0.319502979516983, 0.319364488124847, 0.31922572851181, 0.319086819887161, 0.318947702646255, 0.318808346986771, 0.318668812513351, 0.318529039621353, 0.318389087915421, 0.318248927593231, 0.318108588457108, 0.31796795129776, 0.317827194929123, 0.317686200141907, 0.317544996738434, 0.317403614521027, 0.317262023687363, 0.31712019443512, 0.31697815656662, 0.316835969686508, 0.316693514585495, 0.31655091047287, 0.316408038139343, 0.316265016794205, 0.316121757030487, 0.315978288650513, 0.315834641456604, 0.315690755844116, 0.315546691417694, 0.315402388572693, 0.31525793671608, 0.315113216638565, 0.314968347549438, 0.314823240041733, 0.314677894115448, 0.314532399177551, 0.314386665821075, 0.314240753650665, 0.314094632863998, 0.313948303461075, 0.313801765441895, 0.313654989004135, 0.313508033752441, 0.313360869884491, 0.313213497400284, 0.31306591629982, 0.312918156385422, 0.312770158052444, 0.312621980905533, 0.312473565340042, 0.312324970960617, 0.312176138162613, 0.312027126550674, 0.311877906322479, 0.31172850728035, 0.311578840017319, 0.311429023742676, 0.311278998851776, 0.311128735542297, 0.310978263616562, 0.310827612876892, 0.310676783323288, 0.310525685548782, 0.310374408960342, 0.310222893953323, 0.31007120013237, 0.309919327497482, 0.309767216444016, 0.309614926576614, 0.309462398290634, 0.30930969119072, 0.309156745672226, 0.30900365114212, 0.308850318193436, 0.308696746826172, 0.308542996644974, 0.308389037847519, 0.308234870433807, 0.308080494403839, 0.307925939559937, 0.307771176099777, 0.307616204023361, 0.307460993528366, 0.307305574417114, 0.30715000629425, 0.306994169950485, 0.306838184595108, 0.306681960821152, 0.306525528430939, 0.306368917226791, 0.306212097406387, 0.306055009365082, 0.305897772312164, 0.30574032664299, 0.305582672357559, 0.305424779653549, 0.305266708135605, 0.305108457803726, 0.304949969053268, 0.304791301488876, 0.304632395505905, 0.304473280906677, 0.304313957691193, 0.304154485464096, 0.303994745016098, 0.303834825754166, 0.303674697875977, 0.303514331579208, 0.303353816270828, 0.303193062543869, 0.303032100200653, 0.302870959043503, 0.302709609270096, 0.30254802107811, 0.302386224269867, 0.302224278450012, 0.302062064409256, 0.301899701356888, 0.301737099885941, 0.301574289798737, 0.301411241292953, 0.301248043775558, 0.301084667444229, 0.300920993089676, 0.300757169723511, 0.300593078136444, 0.30042889714241, 0.300264418125153, 0.300099760293961, 0.299934893846512, 0.299769848585129, 0.299604564905167, 0.29943910241127, 0.299273401498795, 0.29910746216774, 0.298941403627396, 0.298775106668472, 0.298608601093292, 0.298441857099533, 0.298274964094162, 0.298107802867889, 0.297940492630005, 0.297772943973541, 0.297605216503143, 0.297437250614166, 0.297269076108932, 0.297100722789764, 0.29693216085434, 0.296763390302658, 0.29659441113472, 0.296425223350525, 0.296255826950073, 0.296086221933365, 0.295916438102722, 0.2957464158535, 0.295576214790344, 0.295405805110931, 0.295235157012939, 0.295064359903336, 0.294893264770508, 0.294722080230713, 0.294550597667694, 0.294378906488419, 0.294207066297531, 0.294035017490387, 0.293862730264664, 0.293690234422684, 0.293517589569092, 0.293344676494598, 0.293171584606171, 0.292998284101486, 0.292824774980545, 0.29265108704567, 0.292477130889893, 0.292303025722504, 0.292128682136536, 0.291949212551117, 0.291765123605728, 0.29158091545105, 0.291396677494049, 0.291212350130081, 0.291027933359146, 0.290843456983566, 0.290658861398697, 0.290474236011505, 0.290289521217346, 0.290104746818542, 0.289919883012772, 0.289734959602356, 0.289549916982651, 0.289364844560623, 0.289179712533951, 0.288994491100311, 0.288809150457382, 0.288623780012131, 0.288438320159912, 0.288252800703049, 0.288067191839218, 0.28788149356842, 0.287695735692978, 0.287509888410568, 0.287323981523514, 0.287138015031815, 0.286951929330826, 0.286765813827515, 0.286579579114914, 0.286393314599991, 0.286206960678101, 0.286020487546921, 0.285833984613419, 0.285647422075272, 0.285460740327835, 0.285274028778076, 0.28508722782135, 0.284900337457657, 0.284713357686996, 0.284526348114014, 0.284339219331741, 0.284152030944824, 0.28396475315094, 0.283777415752411, 0.283589988946915, 0.283402532339096, 0.283214956521988, 0.283027321100235, 0.282839626073837, 0.28265181183815, 0.282463997602463, 0.282276064157486, 0.28208801150322, 0.281899929046631, 0.281711757183075, 0.281523525714874, 0.281335204839706, 0.281146824359894, 0.280958354473114, 0.280769854784012, 0.28058123588562, 0.280392557382584, 0.28020378947258, 0.280014932155609, 0.279826015233994, 0.279637038707733, 0.279447972774506, 0.279258817434311, 0.279069602489471, 0.27888035774231, 0.278690993785858, 0.27850154042244, 0.278311967849731, 0.278122454881668, 0.277932792901993, 0.27774304151535, 0.277553230524063, 0.277363330125809, 0.277173340320587, 0.276983320713043, 0.276793211698532, 0.276603013277054, 0.276412725448608, 0.276222467422485, 0.276032000780106, 0.275841504335403, 0.275650948286057, 0.275460332632065, 0.275269597768784, 0.275078773498535, 0.274887949228287, 0.274697005748749, 0.274506002664566, 0.274314910173416, 0.274123728275299, 0.27393251657486, 0.273741185665131, 0.273549795150757, 0.273358345031738, 0.27316677570343, 0.2729751765728, 0.272783517837524, 0.27259173989296, 0.27239990234375, 0.272207975387573, 0.272015959024429, 0.271823912858963, 0.27163177728653, 0.271439582109451, 0.271247237920761, 0.271054923534393, 0.270862460136414, 0.270669966936111, 0.270477324724197, 0.270284712314606, 0.270091950893402, 0.269899159669876, 0.269706249237061, 0.2695132791996, 0.269320219755173, 0.269127130508423, 0.268933922052383, 0.268740653991699, 0.26854732632637, 0.268353909254074, 0.268160432577133, 0.267966836690903, 0.26777321100235, 0.26757949590683, 0.267385721206665, 0.267191857099533, 0.266997903585434, 0.266803860664368, 0.266609787940979, 0.266415596008301, 0.2662213742733, 0.266027063131332, 0.265832662582397, 0.265638202428818, 0.265443652868271, 0.265249013900757, 0.26505434513092, 0.264859557151794, 0.264664769172668, 0.264469832181931, 0.264274835586548, 0.264079749584198, 0.263884603977203, 0.263689398765564, 0.26349413394928, 0.263298749923706, 0.263103276491165, 0.262907803058624, 0.262712210416794, 0.262516528367996, 0.262320786714554, 0.262124955654144, 0.26192906498909, 0.261733084917068, 0.26153701543808, 0.261340945959091, 0.261144757270813, 0.260948479175568, 0.260752111673355, 0.260555744171143, 0.260359197854996, 0.260162621736526, 0.259966045618057, 0.259769260883331, 0.259572505950928, 0.259375661611557, 0.259178668260574, 0.258981674909592, 0.258784592151642, 0.25858736038208, 0.258390158414841, 0.258192837238312, 0.257995456457138, 0.257797956466675, 0.257600426673889, 0.257402807474136, 0.257205098867416, 0.257007330656052, 0.25680947303772, 0.256611585617065, 0.256413578987122, 0.256215542554855, 0.256017357110977, 0.255819112062454, 0.255620837211609, 0.255422472953796, 0.255224049091339, 0.255025506019592, 0.254826903343201, 0.254628241062164, 0.254429489374161, 0.254230678081512, 0.254031807184219, 0.253832846879959, 0.253633767366409, 0.253434628248215, 0.253235459327698, 0.253036171197891, 0.252836853265762, 0.252637416124344, 0.252437919378281, 0.25223833322525, 0.252038717269897, 0.251839011907578, 0.251639187335968, 0.251439303159714, 0.251239359378815, 0.251039326190948, 0.250839233398438, 0.250639081001282, 0.250438809394836, 0.250238507986069, 0.250038117170334, 0.249837636947632, 0.249637097120285, 0.24943645298481, 0.249235793948174, 0.249035030603409, 0.248834162950516, 0.248633220791817, 0.248432233929634, 0.248231202363968, 0.24803002178669, 0.247828781604767, 0.24762749671936, 0.247426122426987, 0.247224658727646, 0.247023180127144, 0.24682155251503, 0.246619880199432, 0.246418163180351, 0.246216326951981, 0.246014416217804, 0.245812430977821, 0.245610401034355, 0.245408296585083, 0.245206072926521, 0.245003774762154, 0.244801461696625, 0.244599029421806, 0.244396552443504, 0.244193956255913, 0.243991300463676, 0.243788540363312, 0.243585780262947, 0.243382915854454, 0.243179991841316, 0.242976948618889, 0.242773860692978, 0.2425706833601, 0.242367416620255, 0.242164105176926, 0.24196070432663, 0.241757214069366, 0.24155367910862, 0.241350039839745, 0.241146355867386, 0.240942537784576, 0.240738734602928, 0.240534797310829, 0.240330800414085, 0.240126699209213, 0.239922612905502, 0.239718347787857, 0.239514037966728, 0.239309668540955, 0.239105209708214, 0.238900706171989, 0.238696113228798, 0.238491415977478, 0.238286659121513, 0.238081842660904, 0.23787696659565, 0.237671971321106, 0.237466901540756, 0.237261787056923, 0.237056612968445, 0.236851349473, 0.236645951867104, 0.236440524458885, 0.236235022544861, 0.236029490828514, 0.235823795199394, 0.235618084669113, 0.235412269830704, 0.235206380486488, 0.235000461339951, 0.234794422984123, 0.234588339924812, 0.234382167458534, 0.234175905585289, 0.23396959900856, 0.233763173222542, 0.23355670273304, 0.233350157737732, 0.233143523335457, 0.232936814427376, 0.232730031013489, 0.232523202896118, 0.232316270470619, 0.232109278440475, 0.231902182102203, 0.231695026159286, 0.231487810611725, 0.231280505657196, 0.231073141098022, 0.230865672230721, 0.230658143758774, 0.23045052587986, 0.230242863297462, 0.230035126209259, 0.22982731461525, 0.229619383811951, 0.229411408305168, 0.22920335829258, 0.228995218873024, 0.228787019848824, 0.228578731417656, 0.228370398283005, 0.228161975741386, 0.22795344889164, 0.227744892239571, 0.227536216378212, 0.22732749581337, 0.227118700742722, 0.226909816265106, 0.226700827479362, 0.226491823792458, 0.226282745599747, 0.226073563098907, 0.22586427628994, 0.22565495967865, 0.225445583462715, 0.225236088037491, 0.225026533007622, 0.224816903471947, 0.224607199430466, 0.22439743578434, 0.224187567830086, 0.223977625370026, 0.223767638206482, 0.223557591438293, 0.223347410559654, 0.223137155175209, 0.222926825284958, 0.222716450691223, 0.222506061196327, 0.222295507788658, 0.222084864974022, 0.221874192357063, 0.221663475036621, 0.221452608704567, 0.221241727471352, 0.221030727028847, 0.220819681882858, 0.220608562231064, 0.220397353172302, 0.220186054706573, 0.219974711537361, 0.219763278961182, 0.219551771879196, 0.219340190291405, 0.219128534197807, 0.218916803598404, 0.218704983592033, 0.218493148684502, 0.218281164765358, 0.21806912124157, 0.217857018113136, 0.217644870281219, 0.217432603240013, 0.217220261693001, 0.217007860541344, 0.216795369982719, 0.216582804918289, 0.216370180249214, 0.216157481074333, 0.215944692492485, 0.215731859207153, 0.215518906712532, 0.215305894613266, 0.215092837810516, 0.214879676699638, 0.214666455984116, 0.214453130960464, 0.214239746332169, 0.214026272296906, 0.213812753558159, 0.213599145412445, 0.213385477662086, 0.213171720504761, 0.212957844138145, 0.21274396777153, 0.212529987096786, 0.212315931916237, 0.212101802229881, 0.211887612938881, 0.211673304438591, 0.211458936333656, 0.211244508624077, 0.211029961705208, 0.2108154296875, 0.21060074865818, 0.210386037826538, 0.210171192884445, 0.209956333041191, 0.209741398692131, 0.209526345133781, 0.209311231970787, 0.209096029400826, 0.208880811929703, 0.208665490150452, 0.208450049161911, 0.208234563469887, 0.208018973469734, 0.207803383469582, 0.207587629556656, 0.207371860742569, 0.207156047224998, 0.206940069794655, 0.206724092364311, 0.206507980823517, 0.206291809678078, 0.206075608730316, 0.205859288573265, 0.20564292371273, 0.205426409840584, 0.20520992577076, 0.204993307590485, 0.204776614904404, 0.204559862613678, 0.204343050718307, 0.204126104712486, 0.203909128904343, 0.203692078590393, 0.203474923968315, 0.203257739543915, 0.203040435910225, 0.202823087573051, 0.202605620026588, 0.202388122677803, 0.20217053592205, 0.201952874660492, 0.201735138893127, 0.201517298817635, 0.201299443840981, 0.201081514358521, 0.200863465666771, 0.200645342469215, 0.200427129864693, 0.200208902359009, 0.199990585446358, 0.199772134423256, 0.199553653597832, 0.199335128068924, 0.199116483330727, 0.198897778987885, 0.198678955435753, 0.198460131883621, 0.198241174221039, 0.198022156953812, 0.19780308008194, 0.197583884000778, 0.197364687919617, 0.197145402431488, 0.196925953030586, 0.196706533432007, 0.196486964821815, 0.196267366409302, 0.196047708392143, 0.195827901363373, 0.195608079433441, 0.19538813829422, 0.195168152451515, 0.194948151707649, 0.194727972149849, 0.194507792592049, 0.19428750872612, 0.194067090749741, 0.193846687674522, 0.193626120686531, 0.19340555369854, 0.193184942007065, 0.192964166402817, 0.192743375897408, 0.192522466182709, 0.192301511764526, 0.192080497741699, 0.19185933470726, 0.191638171672821, 0.191416874527931, 0.19119556248188, 0.190974175930023, 0.190752640366554, 0.190532058477402, 0.190312266349792, 0.19009256362915, 0.189872995018959, 0.189653411507607, 0.189433991909027, 0.189214736223221, 0.188995361328125, 0.188776224851608, 0.188557118177414, 0.18833814561367, 0.188119262456894, 0.187900424003601, 0.187681674957275, 0.187463000416756, 0.187244459986687, 0.187025994062424, 0.186807557940483, 0.186589315533638, 0.186371058225632, 0.186152905225754, 0.185934871435165, 0.185716927051544, 0.18549907207489, 0.185281246900558, 0.185063600540161, 0.184845998883247, 0.18462847173214, 0.184411019086838, 0.18419361114502, 0.183976367115974, 0.18375925719738, 0.183542117476463, 0.183325096964836, 0.18310821056366, 0.182891398668289, 0.182674676179886, 0.182457998394966, 0.182241454720497, 0.182024985551834, 0.181808575987816, 0.18159231543541, 0.181375980377197, 0.181159943342209, 0.180943921208382, 0.180727854371071, 0.180512025952339, 0.18029622733593, 0.180080533027649, 0.179864972829819, 0.179649382829666, 0.17943400144577, 0.179218664765358, 0.179003372788429, 0.178788214921951, 0.178573057055473, 0.178358152508736, 0.178143233060837, 0.177928358316422, 0.177713617682457, 0.177498951554298, 0.177284419536591, 0.177069932222366, 0.176855519413948, 0.176641225814819, 0.176427006721497, 0.17621286213398, 0.175998851656914, 0.175784885883331, 0.175570994615555, 0.175357192754745, 0.175143510103226, 0.174929887056351, 0.174716383218765, 0.174502938985825, 0.174289599061012, 0.174076318740845, 0.173863157629967, 0.173650085926056, 0.173437044024467, 0.173224195837975, 0.17301133275032, 0.172798603773117, 0.172585904598236, 0.172373339533806, 0.172160908579826, 0.171948492527008, 0.171736165881157, 0.171523943543434, 0.171311840415001, 0.171099781990051, 0.170887812972069, 0.170675918459892, 0.170464143157005, 0.170252487063408, 0.170040890574455, 0.169829294085503, 0.169617891311646, 0.16940650343895, 0.169195249676704, 0.168984085321426, 0.168772965669632, 0.168561965227127, 0.168351054191589, 0.168140277266502, 0.167929530143738, 0.167718827724457, 0.16750830411911, 0.167297810316086, 0.167087376117706, 0.166877090930939, 0.166666835546494, 0.166456758975983, 0.166246667504311, 0.166036710143089, 0.165826827287674, 0.165617078542709, 0.165407404303551, 0.165197774767876, 0.164988249540329, 0.164778813719749, 0.16456937789917, 0.164360150694847, 0.164151012897491, 0.163941875100136, 0.163732886314392, 0.163523957133293, 0.163315102458, 0.163106426596642, 0.162897735834122, 0.162689179182053, 0.162480726838112, 0.162272304296494, 0.162064000964165, 0.16185574233532, 0.161647602915764, 0.161439627408981, 0.161231592297554, 0.161023765802383, 0.160815924406052, 0.160608246922493, 0.16040064394474, 0.160193130373955, 0.159985676407814, 0.159778326749802, 0.159571036696434, 0.159363895654678, 0.159156784415245, 0.158949807286263, 0.158742845058441, 0.158536016941071, 0.158329293131828, 0.15812261402607, 0.157916024327278, 0.157709583640099, 0.15750315785408, 0.157296866178513, 0.157090663909912, 0.156884551048279, 0.15667849779129, 0.156472474336624, 0.156266674399376, 0.156060785055161, 0.155855104327202, 0.155649542808533, 0.155443981289864, 0.155238553881645, 0.155033126473427, 0.154827937483788, 0.154622763395309, 0.154417634010315, 0.154212638735771, 0.154007658362389, 0.153802901506424, 0.153598174452782, 0.153393432497978, 0.153188899159431, 0.152984440326691, 0.152780041098595, 0.152575716376305, 0.152371481060982, 0.152167350053787, 0.151963323354721, 0.1517593562603, 0.151555463671684, 0.151351630687714, 0.151147991418839, 0.150944411754608, 0.150740772485733, 0.150537341833115, 0.150333970785141, 0.150130718946457, 0.14992755651474, 0.14972448348999, 0.149521514773369, 0.149318516254425, 0.149115741252899, 0.148912996053696, 0.148710310459137, 0.148507729172707, 0.148305252194405, 0.148102849721909, 0.147900521755219, 0.147698268294334, 0.147496163845062, 0.14729417860508, 0.147092178463936, 0.146890312433243, 0.146688520908356, 0.146486774086952, 0.146285206079483, 0.146083638072014, 0.145882219076157, 0.145680814981461, 0.145479559898376, 0.14527839422226, 0.145077303051949, 0.14487624168396, 0.144675388932228, 0.144474521279335, 0.14427375793457, 0.144073113799095, 0.143872573971748, 0.143672078847885, 0.143471673130989, 0.143271371722221, 0.143071055412292, 0.14287094771862, 0.142670959234238, 0.142470970749855, 0.14227107167244, 0.142071276903152, 0.141871601343155, 0.141671940684319, 0.141472473740578, 0.141272991895676, 0.141073673963547, 0.14087438583374, 0.140675187110901, 0.140476077795029, 0.140277057886124, 0.140078097581863, 0.139879301190376, 0.139680549502373, 0.139481872320175, 0.139283329248428, 0.139084845781326, 0.13888643682003, 0.138688117265701, 0.138489902019501, 0.138291776180267, 0.138093739748001, 0.137895688414574, 0.137697890400887, 0.137500062584877, 0.137302368879318, 0.137104719877243, 0.136907204985619, 0.136709809303284, 0.13651242852211, 0.136315152049065, 0.136117994785309, 0.135920867323875, 0.135723859071732, 0.135526895523071, 0.135330051183701, 0.135133385658264, 0.134936660528183, 0.134740114212036, 0.134543612599373, 0.134347200393677, 0.134150922298431, 0.133954629302025, 0.133758515119553, 0.133562505245209, 0.133366510272026, 0.133170664310455, 0.132974833250046, 0.132779121398926, 0.132583528757095, 0.132387951016426, 0.132192492485046, 0.131997138261795, 0.131801903247833, 0.131606742739677, 0.131411597132683, 0.131216585636139, 0.131021648645401, 0.130826890468597, 0.130632102489471, 0.130437403917313, 0.130242884159088, 0.130048304796219, 0.129853919148445, 0.129659608006477, 0.129465386271477, 0.129271239042282, 0.129077166318893, 0.128883257508278, 0.128689333796501, 0.128495573997498, 0.128301873803139, 0.128108263015747, 0.127914682030678, 0.127721279859543, 0.127527862787247, 0.127334609627724, 0.127141401171684, 0.126948311924934, 0.126755312085152, 0.126562371850014, 0.126369535923004, 0.126176834106445, 0.125984087586403, 0.125791549682617, 0.125599041581154, 0.125406697392464, 0.125214383006096, 0.125022068619728, 0.124829977750778, 0.124637894332409, 0.124445922672749, 0.12425409257412, 0.124062247574329, 0.123870566487312, 0.123678959906101, 0.123487405478954, 0.123295985162258, 0.12310454249382, 0.122913375496864, 0.122722178697586, 0.122530989348888, 0.122339986264706, 0.12214907258749, 0.12195823341608, 0.12176751345396, 0.121576815843582, 0.121386259794235, 0.121195785701275, 0.121005311608315, 0.120815061032772, 0.120624825358391, 0.120434701442719, 0.120244570076466, 0.120054610073566, 0.119864746928215, 0.119674913585186, 0.119485229253769, 0.119295619428158, 0.119106076657772, 0.118916630744934, 0.11872723698616, 0.118537984788418, 0.118348874151707, 0.118159756064415, 0.117970697581768, 0.117781765758991, 0.117592930793762, 0.1174041852355, 0.117215491831303, 0.117026887834072, 0.116838410496712, 0.11665003746748, 0.116461709141731, 0.116273455321789, 0.116085357964039, 0.115897230803967, 0.115709275007248, 0.115521423518658, 0.115333586931229, 0.11514588445425, 0.114958226680756, 0.114770740270615, 0.114583291113377, 0.114395901560783, 0.114208690822124, 0.114021465182304, 0.113834403455257, 0.113647371530533, 0.113460384309292, 0.113273598253727, 0.113086879253387, 0.112900108098984, 0.112713575363159, 0.112527064979076, 0.112340644001961, 0.112154327332973, 0.111968077719212, 0.111781984567642, 0.111595921218395, 0.111409954726696, 0.111224062740803, 0.111038245260715, 0.110852554440498, 0.110666885972023, 0.110481344163418, 0.110295921564102, 0.110110528767109, 0.109925307333469, 0.109740145504475, 0.109555006027222, 0.109370015561581, 0.109185047447681, 0.109000220894814, 0.108815498650074, 0.108630791306496, 0.108446203172207, 0.108261674642563, 0.108077257871628, 0.107893034815788, 0.10770870000124, 0.107524588704109, 0.10734049975872, 0.107156574726105, 0.106972686946392, 0.106788851320744, 0.106605149805546, 0.106421560049057, 0.106238037347794, 0.106054604053497, 0.105871118605137, 0.105687938630581, 0.105504788458347, 0.10532158613205, 0.105138599872589, 0.104955643415451, 0.104772798717022, 0.104590095579624, 0.104407384991646, 0.104224838316441, 0.104042313992977, 0.103859916329384, 0.103677608072758, 0.103495359420776, 0.103313185274601, 0.103131093084812, 0.102949135005474, 0.102767243981361, 0.102585464715958, 0.102403737604618, 0.102222114801407, 0.102040618658066, 0.101859144866467, 0.101677775382996, 0.101496540009975, 0.101315319538116, 0.101134240627289, 0.100953213870525, 0.100772179663181, 0.100591376423836, 0.100410640239716, 0.100229948759079, 0.100049413740635, 0.0998688712716103, 0.0996885299682617, 0.0995082035660744, 0.0993279069662094, 0.0991477966308594, 0.0989676937460899, 0.098787747323513, 0.0986078828573227, 0.0984280183911324, 0.0982483476400375, 0.0980686619877815, 0.0978891626000404, 0.0977096855640411, 0.097530335187912, 0.0973510816693306, 0.0971718430519104, 0.0969927757978439, 0.096813753247261, 0.0966348499059677, 0.0964560136198997, 0.0962772592902184, 0.0960984826087952, 0.0959199219942093, 0.0957414358854294, 0.0955630540847778, 0.0953847318887711, 0.0952064692974091, 0.0950283631682396, 0.0948502868413925, 0.0946723222732544, 0.094494417309761, 0.0943166464567184, 0.094138890504837, 0.0939612537622452, 0.0937836989760399, 0.093606248497963, 0.0934288576245308, 0.0932516232132912, 0.0930743739008904, 0.0928972810506821, 0.0927202776074409, 0.0925433710217476, 0.0923664942383766, 0.09218979626894, 0.0920130833983421, 0.0918364897370338, 0.0916600003838539, 0.0914943590760231, 0.0913396179676056, 0.0911848843097687, 0.0910303667187691, 0.0908760204911232, 0.0907218977808952, 0.0905678644776344, 0.0904140025377274, 0.0902602672576904, 0.0901067033410072, 0.0899533629417419, 0.0898001194000244, 0.0896469429135323, 0.0894940346479416, 0.0893412604928017, 0.0891885757446289, 0.08903618901968, 0.0888838097453117, 0.0887316986918449, 0.0885796993970871, 0.0884278044104576, 0.0882761552929878, 0.088124692440033, 0.0879732742905617, 0.0878220573067665, 0.0876709893345833, 0.0875200405716896, 0.0873692706227303, 0.0872187688946724, 0.0870683118700981, 0.0869180113077164, 0.0867678970098495, 0.0866179540753365, 0.0864681974053383, 0.0863185077905655, 0.086168959736824, 0.0860196799039841, 0.0858704745769501, 0.0857214033603668, 0.0855726450681686, 0.0854238346219063, 0.0852752476930618, 0.0851269140839577, 0.0849786326289177, 0.084830604493618, 0.0846826657652855, 0.0845349058508873, 0.0843873172998428, 0.0842397287487984, 0.0840924978256226, 0.0839452594518661, 0.0837983265519142, 0.0836514756083488, 0.0835048481822014, 0.0833582133054733, 0.0832118988037109, 0.0830657035112381, 0.082919642329216, 0.0827737078070641, 0.0826280415058136, 0.0824824571609497, 0.08233692497015, 0.0821917280554771, 0.0820465385913849, 0.0819015651941299, 0.0817568153142929, 0.0816121399402618, 0.0814676955342293, 0.0813233405351639, 0.0811791494488716, 0.0810351744294167, 0.0808912962675095, 0.0807475447654724, 0.0806039646267891, 0.0804606080055237, 0.0803173780441284, 0.0801743194460869, 0.0800313577055931, 0.0798885673284531, 0.0797459483146667, 0.0796035081148148, 0.0794611424207687, 0.0793190002441406, 0.0791770443320274, 0.0790352076292038, 0.0788935422897339, 0.0787519738078117, 0.0786106139421463, 0.0784694403409958, 0.0783283859491348, 0.0781875625252724, 0.0780467242002487, 0.07790607213974, 0.0777657628059387, 0.0776254534721375, 0.0774853229522705, 0.0773453190922737, 0.0772055760025978, 0.0770659148693085, 0.0769264400005341, 0.0767870843410492, 0.0766478702425957, 0.0765088722109795, 0.0763700976967812, 0.0762313082814217, 0.0760927423834801, 0.0759543478488922, 0.0758160948753357, 0.0756780952215195, 0.0755400955677032, 0.0754023119807243, 0.0752647966146469, 0.0751272737979889, 0.0749900192022324, 0.074852854013443, 0.0747158601880074, 0.074579082429409, 0.0744422972202301, 0.0743057802319527, 0.0741694495081902, 0.0740332305431366, 0.0738971456885338, 0.0737612918019295, 0.0736255124211311, 0.0734900012612343, 0.073354534804821, 0.0732192769646645, 0.0730841532349586, 0.0729492083191872, 0.0728143900632858, 0.0726797059178352, 0.0725452750921249, 0.0724109038710594, 0.072276696562767, 0.0721427127718925, 0.0720088928937912, 0.0718752518296242, 0.0717416554689407, 0.071608193218708, 0.0714749842882156, 0.0713419169187546, 0.0712089687585831, 0.0710761621594429, 0.0709435269236565, 0.0708111524581909, 0.0706787779927254, 0.0705467015504837, 0.0704146400094032, 0.070282869040966, 0.0701512396335602, 0.0700197368860245, 0.0698883607983589, 0.0697571262717247, 0.0696260929107666, 0.0694952011108398, 0.0693643912672997, 0.0692338570952415, 0.069103479385376, 0.068973109126091, 0.0688430443406105, 0.0687131136655807, 0.068583257496357, 0.0684536322951317, 0.0683241784572601, 0.0681948512792587, 0.0680657029151917, 0.0679366439580917, 0.0678078383207321, 0.0676790401339531, 0.0675505846738815, 0.06742212921381, 0.0672939419746399, 0.067165844142437, 0.0670379102230072, 0.0669101998209953, 0.0667825266718864, 0.0666550323367119, 0.0665278062224388, 0.0664006546139717, 0.0662736892700195, 0.0661467984318733, 0.0660201385617256, 0.0658936575055122, 0.0657672807574272, 0.0656411051750183, 0.0655150040984154, 0.0653891637921333, 0.065263420343399, 0.0651378333568573, 0.0650124326348305, 0.064887173473835, 0.0647620260715485, 0.0646371468901634, 0.064512275159359, 0.0643877014517784, 0.0642632097005844, 0.0641388595104218, 0.0640146806836128, 0.0638906732201576, 0.063766747713089, 0.0636430904269218, 0.0635195672512054, 0.0633962154388428, 0.0632729902863503, 0.0631498619914055, 0.0630269348621368, 0.0629041567444801, 0.0627815797924995, 0.0626591071486473, 0.0625367984175682, 0.062414713203907, 0.0622926652431488, 0.0621709264814854, 0.0620491802692413, 0.0619277097284794, 0.0618062689900398, 0.0616850927472115, 0.0615641437470913, 0.0614432282745838, 0.061322495341301, 0.0612019747495651, 0.0610814951360226, 0.0609612427651882, 0.06084119156003, 0.0607211999595165, 0.0606013759970665, 0.0604816861450672, 0.0603622160851955, 0.0602429583668709, 0.0601237900555134, 0.0600047558546066, 0.059885885566473, 0.0597672387957573, 0.0596486888825893, 0.0595302581787109, 0.0594120882451534, 0.0592940114438534, 0.0591760724782944, 0.0590583384037018, 0.0589406490325928, 0.058823224157095, 0.058706060051918, 0.0585888139903545, 0.0584719143807888, 0.0583550482988358, 0.0582383647561073, 0.0581219010055065, 0.0580055229365826, 0.0578892342746258, 0.0577732026576996, 0.0576574318110943, 0.0575416199862957, 0.0574260652065277, 0.0573106929659843, 0.0571953170001507, 0.0570802912116051, 0.056965347379446, 0.056850541383028, 0.0567359030246735, 0.0566214434802532, 0.0565070696175098, 0.0563930459320545, 0.0562789365649223, 0.0561649985611439, 0.0560514479875565, 0.0559378154575825, 0.055824488401413, 0.0557112470269203, 0.0555980950593948, 0.0554852895438671, 0.0553725324571133, 0.0552598536014557, 0.055147398263216, 0.0550352036952972, 0.0549229681491852, 0.0548110343515873, 0.0546992756426334, 0.0545875206589699, 0.0544760227203369, 0.0543647408485413, 0.0542534627020359, 0.0541424937546253, 0.054031603038311, 0.0539207607507706, 0.0538103096187115, 0.0536999441683292, 0.0535895377397537, 0.0534795261919498, 0.0533695966005325, 0.0532597973942757, 0.0531501732766628, 0.053040724247694, 0.0529313236474991, 0.0528222247958183, 0.0527131259441376, 0.0526042841374874, 0.0524957068264484, 0.0523870848119259, 0.0522786863148212, 0.0521705448627472, 0.0520624443888664, 0.0519545264542103, 0.0518467761576176, 0.0517391599714756, 0.0516317598521709, 0.0515244901180267, 0.0514172203838825, 0.0513103455305099, 0.051203515380621, 0.0510967671871185, 0.0509903691709042, 0.0508840121328831, 0.0507777519524097, 0.05067178606987, 0.0505659133195877, 0.0504601262509823, 0.0503546446561813, 0.0502492487430573, 0.0501438975334167, 0.0500388517975807, 0.0499338507652283, 0.0498290657997131, 0.0497244969010353, 0.0496199764311314, 0.0495157167315483, 0.0494115836918354, 0.0493075400590897, 0.0492036715149879, 0.0491000227630138, 0.0489964596927166, 0.0488931089639664, 0.0487898923456669, 0.048686720430851, 0.0485839024186134, 0.0484811253845692, 0.0483785159885883, 0.0482761301100254, 0.048173826187849, 0.0480717048048973, 0.047969751060009, 0.0478678867220879, 0.0477662868797779, 0.0476647689938545, 0.0475634299218655, 0.0474621318280697, 0.047361183911562, 0.0472602806985378, 0.0471595451235771, 0.0470589883625507, 0.0469586066901684, 0.0468583591282368, 0.046758234500885, 0.0466582886874676, 0.0465584732592106, 0.0464589223265648, 0.046359408646822, 0.0462600737810135, 0.0461609549820423, 0.0460620149970055, 0.045963067561388, 0.0458644293248653, 0.0457658767700195, 0.0456674546003342, 0.0455693006515503, 0.045471228659153, 0.0453733280301094, 0.0452756024897099, 0.0451779700815678, 0.0450805090367794, 0.0449832640588284, 0.0448861047625542, 0.0447891689836979, 0.0446923598647118, 0.04459572955966, 0.0444991812109947, 0.0444028489291668, 0.0443066582083702, 0.0442106761038303, 0.044114738702774, 0.0440191105008125, 0.0439234785735607, 0.0438281036913395, 0.043732825666666, 0.0436377599835396, 0.0435429140925407, 0.043447982519865, 0.0433533973991871, 0.0432589836418629, 0.0431646145880222, 0.0430704653263092, 0.0429764911532402, 0.0428826063871384, 0.0427888892591, 0.0426954850554466, 0.0426020286977291, 0.0425087548792362, 0.0424158275127411, 0.0423228107392788, 0.0422300584614277, 0.0421375185251236, 0.0420450679957867, 0.0419527515769005, 0.0418606959283352, 0.0417686365544796, 0.0416769757866859, 0.0415853075683117, 0.0414937324821949, 0.0414023697376251, 0.0413111858069897, 0.0412201769649982, 0.041129294782877, 0.04103859141469, 0.0409480594098568, 0.040857657790184, 0.0407673455774784, 0.0406772941350937, 0.040587417781353, 0.0404976233839989, 0.0404079221189022, 0.0403185673058033, 0.0402291230857372, 0.0401400774717331, 0.0400511622428894, 0.0399621985852718, 0.0398734956979752, 0.0397850126028061, 0.0396966189146042, 0.0396084412932396, 0.0395203903317451, 0.0394324362277985, 0.0393446870148182, 0.0392571687698364, 0.0391696840524673, 0.0390823818743229, 0.0389953330159187, 0.0389083363115788, 0.0388215519487858, 0.0387348607182503, 0.0386483818292618, 0.038562074303627, 0.0384758599102497, 0.0383898206055164, 0.0383040383458138, 0.0382182151079178, 0.0381326973438263, 0.0380473509430885, 0.0379620529711246, 0.0378770083189011, 0.0377920605242252, 0.0377071499824524, 0.0376227200031281, 0.0375382043421268, 0.0374538637697697, 0.0373697392642498, 0.0372857004404068, 0.037201926112175, 0.0371181964874268, 0.0370346829295158, 0.0369513891637325, 0.0368680916726589, 0.0367850549519062, 0.0367021076381207, 0.0366193801164627, 0.0365367829799652, 0.0364543572068214, 0.0363721512258053, 0.036290030926466, 0.0362080447375774, 0.0361262299120426, 0.0360446386039257, 0.0359631255269051, 0.0358817502856255, 0.0358006320893764, 0.0357195623219013, 0.0356387495994568, 0.0355579368770123, 0.0354774743318558, 0.0353971011936665, 0.0353168100118637, 0.035236693918705, 0.0351568460464478, 0.0350769460201263, 0.0349973998963833, 0.0349179841578007, 0.0348386131227016, 0.0347594991326332, 0.0346805155277252, 0.0346016697585583, 0.0345230810344219, 0.0344444066286087, 0.0343660786747932, 0.0342879258096218, 0.034209817647934, 0.034131970256567, 0.0340541675686836, 0.0339765809476376, 0.0338992550969124, 0.0338218435645103, 0.0337447784841061, 0.0336677618324757, 0.0335970222949982, 0.0335327759385109, 0.0334684364497662, 0.0334042981266975, 0.0333402678370476, 0.0332762785255909, 0.0332124270498753, 0.033148605376482, 0.0330849513411522, 0.0330213159322739, 0.0329578071832657, 0.0328944213688374, 0.0328310988843441, 0.0327678769826889, 0.0327046737074852, 0.0326416455209255, 0.0325786396861076, 0.0325157679617405, 0.0324530191719532, 0.0323902405798435, 0.03232766315341, 0.0322651788592339, 0.0322027429938316, 0.032140389084816, 0.0320781655609608, 0.0320160016417503, 0.0319539457559586, 0.0318918749690056, 0.0318300798535347, 0.0317682847380638, 0.0317065045237541, 0.0316449739038944, 0.031583447009325, 0.031521987169981, 0.0314606614410877, 0.0313993319869041, 0.031338281929493, 0.0312771797180176, 0.0312161147594452, 0.031155314296484, 0.0310943946242332, 0.0310337264090776, 0.0309731476008892, 0.0309126041829586, 0.0308521576225758, 0.0307917930185795, 0.0307315550744534, 0.0306714475154877, 0.0306112710386515, 0.0305512957274914, 0.0304914303123951, 0.030431630089879, 0.0303719099611044, 0.0303122960031033, 0.030252743512392, 0.0301933027803898, 0.0301339440047741, 0.0300746764987707, 0.0300155077129602, 0.029956478625536, 0.0298974197357893, 0.0298385545611382, 0.0297797434031963, 0.0297210309654474, 0.0296623930335045, 0.0296038463711739, 0.0295454245060682, 0.0294870510697365, 0.0294287633150816, 0.0293706394731998, 0.0293125361204147, 0.0292545240372419, 0.0291966143995523, 0.0291387438774109, 0.0290810894221067, 0.0290234666317701, 0.028965787962079, 0.02890844643116, 0.0288509894162416, 0.02879380248487, 0.0287365932017565, 0.028679471462965, 0.0286225266754627, 0.0285656210035086, 0.0285087395459414, 0.0284520983695984, 0.0283953249454498, 0.0283388141542673, 0.0282824337482452, 0.0282259881496429, 0.0281696952879429, 0.0281135309487581, 0.0280574448406696, 0.028001369908452, 0.0279455129057169, 0.0278896875679493, 0.027833940461278, 0.0277782771736383, 0.0277227256447077, 0.0276672504842281, 0.0276119038462639, 0.0275566037744284, 0.0275014098733664, 0.0274462942034006, 0.0273913182318211, 0.027336398139596, 0.0272815320640802, 0.0272268075495958, 0.0271721724420786, 0.0271175988018513, 0.0270631462335587, 0.0270087197422981, 0.0269544962793589, 0.0269002728164196, 0.0268461909145117, 0.0267921760678291, 0.0267382152378559, 0.026684395968914, 0.0266306512057781, 0.0265769306570292, 0.0265234690159559, 0.0264699533581734, 0.0264165177941322, 0.0263632852584124, 0.0263099670410156, 0.0262568555772305, 0.0262039415538311, 0.0261509586125612, 0.0260981637984514, 0.0260454099625349, 0.0259926822036505, 0.0259401928633451, 0.0258876252919436, 0.0258352551609278, 0.0257829837501049, 0.0257307533174753, 0.0256785992532969, 0.0256265886127949, 0.025574654340744, 0.0255227740854025, 0.0254710800945759, 0.0254194065928459, 0.0253677982836962, 0.0253163762390614, 0.0252649337053299, 0.0252136625349522, 0.0251624155789614, 0.0251112654805183, 0.0250602792948484, 0.0250092912465334, 0.024958536028862, 0.0249077100306749, 0.0248570181429386, 0.0248064789921045, 0.0247559826821089, 0.0247056186199188, 0.0246552750468254, 0.0246050488203764, 0.0245549343526363, 0.0245048962533474, 0.0244549680501223, 0.0244050584733486, 0.0243553053587675, 0.0243056379258633, 0.0242560319602489, 0.0242065172642469, 0.0241571664810181, 0.0241078361868858, 0.0240585599094629, 0.0240094810724258, 0.0239603575319052, 0.0239114090800285, 0.0238626562058926, 0.0238138176500797, 0.0237651728093624, 0.0237165186554193, 0.0236679948866367, 0.0236196555197239, 0.0235713161528111, 0.0235230438411236, 0.0234750118106604, 0.0234269015491009, 0.0233789123594761, 0.0233310498297215, 0.0232832692563534, 0.0232355408370495, 0.0231880079954863, 0.0231404975056648, 0.0230931080877781, 0.0230457596480846, 0.0229984894394875, 0.0229513719677925, 0.0229042954742908, 0.0228573307394981, 0.0228105187416077, 0.022763704881072, 0.0227170120924711, 0.0226704068481922, 0.0226239208132029, 0.0225774776190519, 0.022531121969223, 0.0224849190562963, 0.0224387384951115, 0.0223926659673452, 0.022346768528223, 0.0223008506000042, 0.0222550164908171, 0.022209357470274, 0.0221637431532145, 0.0221182610839605, 0.0220727995038033, 0.0220274478197098, 0.0219822246581316, 0.0219370909035206, 0.0218919552862644, 0.0218470375984907, 0.0218021422624588, 0.0217573344707489, 0.0217126794159412, 0.0216680224984884, 0.0216234773397446, 0.0215790830552578, 0.021534688770771, 0.0214905142784119, 0.0214463137090206, 0.0214022044092417, 0.0213582888245583, 0.02131437510252, 0.0212705265730619, 0.0212268736213446, 0.0211832318454981, 0.0211396552622318, 0.0210962854325771, 0.0210529174655676, 0.0210096891969442, 0.0209664795547724, 0.0209234282374382, 0.0208804607391357, 0.0208375286310911, 0.020794790238142, 0.0207520518451929, 0.0207093916833401, 0.0206669047474861, 0.0206244401633739, 0.0205821059644222, 0.0205398574471474, 0.0204976554960012, 0.020455613732338, 0.0204135961830616, 0.0203716438263655, 0.0203299075365067, 0.0202881507575512, 0.0202464703470469, 0.020205007866025, 0.0201635453850031, 0.0201222561299801, 0.0200809575617313, 0.0200397130101919, 0.0199986752122641, 0.0199576914310455, 0.0199167188256979, 0.0198759436607361, 0.0198352001607418, 0.0197945423424244, 0.0197540726512671, 0.0197135787457228, 0.0196731965988874, 0.0196329429745674, 0.0195927210152149, 0.0195526871830225, 0.0195126831531525, 0.019472723826766, 0.0194329414516687, 0.0193932019174099, 0.0193535685539246, 0.0193140115588903, 0.0192745644599199, 0.0192351415753365, 0.0191959217190742, 0.0191567037254572, 0.0191176719963551, 0.019078616052866, 0.019039673730731, 0.0190009009093046, 0.018962174654007, 0.018923532217741, 0.0188849568367004, 0.0188464932143688, 0.0188081450760365, 0.0187698435038328, 0.0187316611409187, 0.0186935551464558, 0.0186555124819279, 0.0186176784336567, 0.0185798015445471, 0.0185420103371143, 0.0185044165700674, 0.0184668470174074, 0.0184293277561665, 0.0183920152485371, 0.0183547046035528, 0.0183174703270197, 0.0182804204523563, 0.0182433277368546, 0.0182064957916737, 0.0181696228682995, 0.018132833763957, 0.018096262589097, 0.0180596709251404, 0.0180231686681509, 0.0179868601262569, 0.0179505068808794, 0.0179142747074366, 0.0178781747817993, 0.0178421474993229, 0.0178061779588461, 0.01777040399611, 0.0177346169948578, 0.017698984593153, 0.0176633950322866, 0.0176278930157423, 0.0175925437361002, 0.0175572168081999, 0.0175219867378473, 0.017486909404397, 0.0174518879503012, 0.0174169726669788, 0.017382113263011, 0.0173473209142685, 0.0173127111047506, 0.0172781031578779, 0.0172436907887459, 0.0172092579305172, 0.0171749331057072, 0.0171407591551542, 0.0171065870672464, 0.0170726217329502, 0.0170386545360088, 0.0170047767460346, 0.0169710833579302, 0.0169373583048582, 0.016903730109334, 0.016870329156518, 0.016836866736412, 0.0168035458773375, 0.0167703740298748, 0.0167372040450573, 0.0167041420936584, 0.0166712570935488, 0.0166383571922779, 0.0166056677699089, 0.0165729429572821, 0.0165403205901384, 0.0165078900754452, 0.016475448384881, 0.0164431072771549, 0.0164109524339437, 0.0163787845522165, 0.0163467116653919, 0.0163148082792759, 0.0162828918546438, 0.0162511374801397, 0.0162195041775703, 0.0161878503859043, 0.0161564219743013, 0.0161249842494726, 0.0160936322063208, 0.0160624235868454, 0.0160312820225954, 0.0160002801567316, 0.0159693211317062, 0.0159383956342936, 0.0159076657146215, 0.0158769711852074, 0.0158463176339865, 0.0158158931881189, 0.0157854482531548, 0.0157551430165768, 0.015724916011095, 0.0156947541981936, 0.0156647209078074, 0.0156347434967756, 0.0156048219650984, 0.0155751053243876, 0.0155454119667411, 0.0155158592388034, 0.0154862739145756, 0.0154568431898952, 0.0154275503009558, 0.0153983030468225, 0.0153690986335278, 0.0153401251882315, 0.0153111172839999, 0.0152821866795421, 0.015253484249115, 0.0152247389778495, 0.0151960998773575, 0.0151676377281547, 0.0151391755789518, 0.0151109099388123, 0.0150826433673501, 0.0150544410571456, 0.0150264371186495, 0.0149984313175082, 0.014970513060689, 0.0149427810683846, 0.0149150490760803, 0.0148874362930655, 0.0148599529638886, 0.0148324929177761, 0.0148051856085658, 0.0147778782993555, 0.0147507023066282, 0.0147237107157707, 0.014696697704494, 0.0146698458120227, 0.0146430190652609, 0.0146163105964661, 0.0145897334441543, 0.0145631870254874, 0.014536795206368, 0.0145103922113776, 0.0144841633737087, 0.0144580118358135, 0.0144319348037243, 0.0144059136509895, 0.0143800331279635, 0.0143542289733887, 0.0143284909427166, 0.0143029373139143, 0.0142773855477571, 0.0142519827932119, 0.0142266051843762, 0.0142012694850564, 0.0141761852428317, 0.0141510674729943, 0.014126037247479, 0.0141012137755752, 0.0140763577073812, 0.0140516217797995, 0.0140270618721843, 0.0140024777501822, 0.0139780035242438, 0.0139536811038852, 0.0139294248074293, 0.013905287720263, 0.0138811403885484, 0.0138571346178651, 0.0138332927599549, 0.0138094387948513, 0.0137856956571341, 0.013762135989964, 0.0137385558336973, 0.0137150501832366, 0.0136917643249035, 0.0136684561148286, 0.0136452997103333, 0.01362219825387, 0.0135991629213095, 0.013576322235167, 0.0135534601286054, 0.0135307619348168, 0.0135081401094794, 0.0134855294600129, 0.0134631032124162, 0.0134407542645931, 0.0134185133501887, 0.0133963171392679, 0.0133741851896048, 0.0133522385731339, 0.0133302705362439, 0.0133084449917078, 0.0132867153733969, 0.0132650630548596, 0.0132434768602252, 0.0132221188396215, 0.0132006742060184, 0.013179468922317, 0.0131582412868738, 0.0131370685994625, 0.0131161352619529, 0.0130952140316367, 0.0130743244662881, 0.0130536640062928, 0.0130329597741365, 0.0130123756825924, 0.0129919657483697, 0.0129715343937278, 0.0129512557759881, 0.0129310851916671, 0.0129109807312489, 0.0128909191116691, 0.0128710428252816, 0.0128511991351843, 0.0128314979374409, 0.0128118069842458, 0.0127922147512436, 0.012772785499692, 0.0127533776685596, 0.0127340694889426, 0.0127078844234347, 0.0126742776483297, 0.0126406941562891, 0.0126071749255061, 0.0125736771151423, 0.0125402463600039, 0.0125067932531238, 0.012473382987082, 0.0124400164932013, 0.0124066937714815, 0.0123733710497618, 0.012340092100203, 0.0123069006949663, 0.0122736860066652, 0.0122405169531703, 0.0122073674574494, 0.0121742412447929, 0.0121411802247167, 0.0121081192046404, 0.0120751233771443, 0.0120421713218093, 0.0120092192664742, 0.0119763324037194, 0.0119434231892228, 0.0119106024503708, 0.011877759359777, 0.0118449814617634, 0.011812224984169, 0.0117795569822192, 0.0117468656972051, 0.0117141967639327, 0.0116815930232406, 0.0116490116342902, 0.0116164302453399, 0.011583935469389, 0.0115514630451798, 0.0115190334618092, 0.011486604809761, 0.0114541966468096, 0.0114218555390835, 0.0113895135000348, 0.0113572366535664, 0.0113250249996781, 0.0112927714362741, 0.0112606035545468, 0.0112284356728196, 0.0111963115632534, 0.0111642088741064, 0.0111321285367012, 0.0111001133918762, 0.0110681420192122, 0.0110361929982901, 0.0110042421147227, 0.0109723368659616, 0.0109404744580388, 0.0109086334705353, 0.0108768362551928, 0.010845105163753, 0.0108133517205715, 0.0107816634699702, 0.0107499966397882, 0.0107183521613479, 0.010686750523746, 0.0106551721692085, 0.0106236804276705, 0.0105921877548099, 0.0105606960132718, 0.0105292480438948, 0.0104978643357754, 0.0104664601385593, 0.0104351416230202, 0.0104038463905454, 0.0103725716471672, 0.0103413416072726, 0.0103101106360555, 0.0102789457887411, 0.0102477809414268, 0.0102166598662734, 0.0101856030523777, 0.0101545685902238, 0.0101235779002309, 0.0100925657898188, 0.0100616188719869, 0.0100307147949934, 0.00999981164932251, 0.00996897276490927, 0.00993817858397961, 0.00990738347172737, 0.00987665448337793, 0.0098459254950285, 0.00981523934751749, 0.00978457555174828, 0.00975393410772085, 0.00972335785627365, 0.00969282351434231, 0.00966231245547533, 0.00963182281702757, 0.00960135646164417, 0.00957093201577663, 0.00954052992165089, 0.00951017066836357, 0.00947983376681805, 0.00944958347827196, 0.00941933412104845, 0.00938908476382494, 0.00935890059918165, 0.00932871643453836, 0.00929857511073351, 0.00926849991083145, 0.00923844613134861, 0.00920843612402678, 0.00917842611670494, 0.00914845988154411, 0.0091185150668025, 0.00908859167248011, 0.00905873440206051, 0.0090288994833827, 0.00899915024638176, 0.00896935816854239, 0.00893963128328323, 0.00890990439802408, 0.00888024363666773, 0.00885060336440802, 0.00882098637521267, 0.00879141222685575, 0.00876190327107906, 0.00873239431530237, 0.00870290771126747, 0.00867346487939358, 0.00864406488835812, 0.00861466489732265, 0.0085853086784482, 0.00855604000389576, 0.00852677039802074, 0.00849752314388752, 0.00846829731017351, 0.00843909382820129, 0.0084099555388093, 0.0083808396011591, 0.00835176650434732, 0.00832273717969656, 0.00829372927546501, 0.00826474372297525, 0.00823577959090471, 0.00820685923099518, 0.00817796029150486, 0.00814910605549812, 0.00812029466032982, 0.00809152610599995, 0.00806278083473444, 0.00803403463214636, 0.0080053536221385, 0.00797669496387243, 0.00794805865734816, 0.00791946519166231, 0.00789093691855669, 0.00786243099719286, 0.00783392414450645, 0.00780543964356184, 0.00777702080085874, 0.00774860195815563, 0.00772024830803275, 0.00769191607832909, 0.00766364997252822, 0.00763538293540478, 0.00760716013610363, 0.0075789587572217, 0.00755077926442027, 0.00752262258902192, 0.00749452970921993, 0.00746648199856281, 0.00743847666308284, 0.00741044944152236, 0.00738246692344546, 0.0073545491322875, 0.00732665276154876, 0.0072987568564713, 0.00727090425789356, 0.00724313873797655, 0.00721537368372083, 0.00718763004988432, 0.00715990830212831, 0.00713223032653332, 0.00710457377135754, 0.00707696098834276, 0.00704939244315028, 0.00702188862487674, 0.00699436292052269, 0.00696685910224915, 0.00693942047655582, 0.0069120260886848, 0.00688463123515248, 0.00685725826770067, 0.00682997237890959, 0.00680270837619901, 0.00677546625956893, 0.00674822414293885, 0.00672102533280849, 0.00669389218091965, 0.00666675856336951, 0.00663969106972218, 0.00661264499649405, 0.00658562080934644, 0.00655863992869854, 0.00653168139979243, 0.00650476571172476, 0.00647785048931837, 0.0064509785734117, 0.00642417231574655, 0.0063974098302424, 0.00637064687907696, 0.00634390581399202, 0.0063172085210681, 0.00629055453464389, 0.00626390101388097, 0.00623733410611749, 0.00621074577793479, 0.00618424499407411, 0.00615776563063264, 0.00613128580152988, 0.00610485021024942, 0.0060784574598074, 0.00605208752676845, 0.00602573854848742, 0.00599947711452842, 0.00597321568056941, 0.0059469542466104, 0.00592075800523162, 0.00589458364993334, 0.00586843118071556, 0.00584234436973929, 0.00581630039960146, 0.00579025689512491, 0.00576423527672887, 0.00573825696483254, 0.00571232242509723, 0.00568640930578113, 0.00566051853820682, 0.00563471438363194, 0.00560891069471836, 0.00558312889188528, 0.00555736850947142, 0.00553165189921856, 0.00550597906112671, 0.00548032764345407, 0.00545474188402295, 0.00542915565893054, 0.00540361320599914, 0.00537809310480952, 0.00535261631011963, 0.00532713904976845, 0.00530172744765878, 0.00527633773162961, 0.00525101367384195, 0.00522571103647351, 0.00520040839910507, 0.00517514953389764, 0.00514991208910942, 0.0051247188821435, 0.00509956898167729, 0.00507448427379131, 0.00504939956590533, 0.00502433674409986, 0.00499929580837488, 0.00497429817914963, 0.00494932243600488, 0.00492441188544035, 0.00489950180053711, 0.0048746787942946, 0.00484985578805208, 0.00482505420222878, 0.00480029685422778, 0.00477553904056549, 0.00475086830556393, 0.00472617568448186, 0.00470157107338309, 0.00467694411054254, 0.00465240422636271, 0.00462784245610237, 0.00460334587842226, 0.00457891542464495, 0.00455444073304534, 0.00453007547184825, 0.00450568832457066, 0.00448136683553457, 0.0044570448808372, 0.00443278811872005, 0.00440853135660291, 0.00438429741188884, 0.00436017103493214, 0.004336001817137, 0.0043119196780026, 0.00428783753886819, 0.00426382105797529, 0.0042397822253406, 0.00421578716486692, 0.00419185822829604, 0.00416792836040258, 0.00414408603683114, 0.00412019994109869, 0.00409644469618797, 0.00407262425869703, 0.00404886901378632, 0.00402517896145582, 0.00400146748870611, 0.00397784309461713, 0.00395419728010893, 0.00393063807860017, 0.00390710076317191, 0.00388358486816287, 0.00386009132489562, 0.00383661920204759, 0.00381321273744106, 0.00378980627283454, 0.00376646523363888, 0.00374312419444323, 0.00371984834782779, 0.003696572734043, 0.00367336231283844, 0.00365019543096423, 0.00362700689584017, 0.00360390543937683, 0.00358080421574414, 0.00355774629861116, 0.00353471026755869, 0.00351169612258673, 0.00348874740302563, 0.00346582010388374, 0.00344293680973351, 0.00342005328275263, 0.00339725706726313, 0.00337443873286247, 0.00335168628953397, 0.00332893361337483, 0.00330620259046555, 0.00328355887904763, 0.00326089328154922, 0.00323833664879203, 0.00321575836278498, 0.00319324526935816, 0.00317071075551212, 0.0031482195481658, 0.00312579376623034, 0.00310336798429489, 0.00308102928102016, 0.00305869081057608, 0.00303637399338186, 0.003014100715518, 0.00299184932373464, 0.002969641238451, 0.00294745527207851, 0.00292533473111689, 0.00290319207124412, 0.00288113672286272, 0.00285908160731196, 0.00283707003109157, 0.0028151017613709, 0.00279313349165022, 0.00277125253342092, 0.00274932803586125, 0.00272751250304282, 0.00270567508414388, 0.00268390332348645, 0.00266213132999837, 0.00264040287584066, 0.00261871796101332, 0.00259707681834698, 0.002575479215011, 0.00255388161167502, 0.00253232754766941, 0.0025107953697443, 0.00248928484506905, 0.00246783974580467, 0.00244639464654028, 0.00242505851201713, 0.00240365718491375, 0.00238236458972096, 0.00236105034127831, 0.00233980128541589, 0.00231855222955346, 0.00229734694585204, 0.00227620708756149, 0.00225504534319043, 0.00223397091031075, 0.00221291789785028, 0.00219190865755081, 0.00217087776400149, 0.00214989040978253, 0.0021289901342243, 0.0021080682054162, 0.00208721146918833, 0.00206635496579111, 0.00204558530822396, 0.0020247942302376, 0.00200404645875096, 0.00198336411267519, 0.00196268176659942, 0.00194206507876515, 0.00192146981135011, 0.00190087466035038, 0.00188032316509634, 0.00185983709525317, 0.00183932913932949, 0.00181888649240136, 0.00179850938729942, 0.00177815393544734, 0.00175777683034539, 0.00173744314815849, 0.00171719677746296, 0.00169692863710225, 0.00167668226640671, 0.00165652297437191, 0.00163636368233711, 0.00161629158537835, 0.00159617594908923, 0.00157614750787616, 0.00155611906666309, 0.00153611227869987, 0.00151617103256285, 0.00149622978642583, 0.00147637561894953, 0.00145654333755374, 0.00143668917007744, 0.0014169221976772, 0.00139717699494213, 0.00137743179220706, 0.001357730361633, 0.00133809400722384, 0.00131847965531051, 0.00129886530339718, 0.00127929449081421, 0.00125978898722678, 0.00124028360005468, 0.00122082175221294, 0.00120140356011689, 0.0011820289073512, 0.00116265413817018, 0.00114330137148499, 0.00112401379738003, 0.00110472633969039, 0.00108548253774643, 0.00106630392838269, 0.00104716909117997, 0.00102803413756192, 0.00100894272327423, 0.000989851425401866, 0.000970803666859865, 0.000951799505855888, 0.000932817114517093, 0.000913900090381503, 0.000894983124453574, 0.000876131525728852, 0.00085730169666931, 0.000838471809402108, 0.000819707405753434, 0.000800943002104759, 0.000782265735324472, 0.000763566640671343, 0.00074493297142908, 0.000726321071851999, 0.00070773100014776, 0.000689206295646727, 0.000670681591145694, 0.000652222253847867, 0.000633741146884859, 0.000615368946455419, 0.000596953264903277, 0.000578624662011862, 0.000560296117328107, 0.000541989342309535, 0.000523747934494168, 0.000505550182424486, 0.000487374141812325, 0.000469198130303994, 0.000451109313871711, 0.000432998669566587, 0.000414931651903316, 0.000396929972339422, 0.000378906552214175, 0.000360970268957317, 0.000343033985700458, 0.000325184897519648, 0.000307314010569826, 0.000289464893285185, 0.000271681172307581, 0.000253919250098988, 0.00023620092542842, 0.000218482586205937, 0.000200851412955672, 0.000183220254257321, 0.000165654477314092, 0.000148066887049936, 0.000130501110106707, 0.000113044305180665, 9.55439027165994e-05, 7.81306807766668e-05, 6.07174515607767e-05, 4.33696113759652e-05, 2.60217657341855e-05, 8.71750944497762e-06, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15, 1.81780237326764e-15   }, 
}; 

// background map
float ReadLikelihood::fRefB[][10000] = 
{ 
   { 0.00018208259, 0.00018177574, 0.00018146948, 0.00018116356, 0.00018085731, 0.00018055257, 0.00018024724, 0.00017994252, 0.00017963749, 0.00017933306, 0.00017902892, 0.00017872571, 0.0001784216, 0.00017811808, 0.00017781487, 0.00017751196, 0.00017720903, 0.00017690675, 0.00017660504, 0.00017630303, 0.00017600165, 0.00017570026, 0.00017539886, 0.00017509806, 0.00017479788, 0.00017449769, 0.00017419722, 0.00017389763, 0.00017359806, 0.0001732985, 0.00017299983, 0.00017270117, 0.00017240251, 0.00017210413, 0.00017180608, 0.00017150863, 0.00017121117, 0.00017091402, 0.00017061718, 0.00017032033, 0.00017002349, 0.00016972754, 0.00016943221, 0.00016913627, 0.00016884065, 0.00016854561, 0.00016825058, 0.00016795586, 0.00016766174, 0.00016736763, 0.00016707351, 0.00016678001, 0.0001664865, 0.00016619299, 0.00016590099, 0.00016560838, 0.00016531609, 0.00016502348, 0.00016473178, 0.00016444011, 0.00016414962, 0.00016385823, 0.00016356746, 0.00016327697, 0.00016298619, 0.00016269632, 0.00016240706, 0.00016211718, 0.00016182821, 0.00016153895, 0.00016125059, 0.00016096164, 0.00016067419, 0.00016038613, 0.00016009838, 0.00015981063, 0.00015952349, 0.00015923665, 0.00015895012, 0.00015866388, 0.00015837765, 0.00015809172, 0.00015780579, 0.00015752047, 0.00015723544, 0.00015695071, 0.00015666631, 0.0001563819, 0.00015609778, 0.00015581367, 0.00015553017, 0.00015524727, 0.00015496436, 0.00015468117, 0.00015439857, 0.00015411628, 0.00015383399, 0.00015355292, 0.00015327122, 0.00015298954, 0.00015270876, 0.00015242798, 0.00015214752, 0.00015186764, 0.00015158778, 0.00015130792, 0.00015102865, 0.00015074878, 0.00015047014, 0.00015019179, 0.00014991313, 0.00014963507, 0.00014935734, 0.00014907899, 0.00014880185, 0.00014852532, 0.00014824849, 0.00014797135, 0.00014769513, 0.00014741889, 0.00014714326, 0.00014686795, 0.00014659263, 0.00014631732, 0.00014604231, 0.0001457676, 0.00014549348, 0.00014521969, 0.00014494588, 0.00014467239, 0.00014439919, 0.00014412569, 0.0001438531, 0.00014358111, 0.00014330883, 0.00014303655, 0.00014276487, 0.00014249349, 0.0001422218, 0.00014195165, 0.00014168087, 0.0001414104, 0.00014113994, 0.00014087009, 0.00014060023, 0.00014033126, 0.00014006202, 0.00013979306, 0.00013952411, 0.00013925578, 0.00013898773, 0.00013871999, 0.00013845257, 0.00013818512, 0.00013791799, 0.00013765116, 0.00013738434, 0.00013711811, 0.0001368525, 0.00013658659, 0.00013632096, 0.00013605566, 0.00013579034, 0.00013552564, 0.00013526154, 0.00013499743, 0.00013473304, 0.00013446924, 0.00013420575, 0.00013394255, 0.00013367998, 0.0001334171, 0.00013315481, 0.00013289222, 0.00013263024, 0.00013236857, 0.00013210782, 0.00013184643, 0.00013158537, 0.00013132492, 0.00013106385, 0.00013080399, 0.00013054474, 0.00013028519, 0.00013002534, 0.00012976638, 0.00012950745, 0.0001292488, 0.00012899077, 0.00012873273, 0.00012847471, 0.00012821697, 0.00012795955, 0.00012770272, 0.00012744621, 0.00012718969, 0.00012693316, 0.00012667725, 0.00012642134, 0.00012616573, 0.00012591103, 0.00012565604, 0.00012540103, 0.00012514663, 0.00012489223, 0.00012463814, 0.00012438495, 0.00012413177, 0.00012387798, 0.0001236251, 0.00012337252, 0.00012312025, 0.00012286828, 0.0001226163, 0.00012236464, 0.00012211328, 0.00012186191, 0.00012161116, 0.000121361, 0.00012111024, 0.0001208601, 0.00012061055, 0.00012036071, 0.00012011116, 0.00011986222, 0.00011961389, 0.00011936495, 0.00011911692, 0.00011886859, 0.00011862116, 0.00011837314, 0.00011812663, 0.00011787951, 0.00011763269, 0.00011738588, 0.00011713967, 0.00011689376, 0.00011664846, 0.00011640286, 0.00011615756, 0.00011591226, 0.00011566756, 0.00011542317, 0.00011517938, 0.0001149356, 0.00011469181, 0.00011444833, 0.00011420485, 0.00011396199, 0.00011372002, 0.00011347776, 0.00011323518, 0.00011299353, 0.00011275186, 0.00011251019, 0.00011226975, 0.00011202899, 0.00011178824, 0.0001115478, 0.00011130765, 0.00011106781, 0.00011082857, 0.00011058934, 0.0001103501, 0.00011011148, 0.00010987254, 0.00010963452, 0.00010939711, 0.00010915938, 0.00010892136, 0.00010868425, 0.00010844744, 0.00010821032, 0.00010797443, 0.00010773822, 0.00010750202, 0.00010726642, 0.00010703082, 0.00010679583, 0.00010656114, 0.00010632676, 0.00010609208, 0.00010585799, 0.00010562391, 0.00010539043, 0.00010515757, 0.00010492409, 0.00010469122, 0.00010445865, 0.0001042261, 0.00010399413, 0.00010376218, 0.00010353143, 0.00010329947, 0.00010306873, 0.00010283768, 0.00010260724, 0.00010237679, 0.00010214726, 0.00010191742, 0.00010168789, 0.00010145835, 0.00010122974, 0.00010100051, 0.00010077279, 0.00010054447, 0.00010031646, 0.00010008844, 9.9861027e-05, 9.9633922e-05, 9.9407727e-05, 9.9180616e-05, 9.8954115e-05, 9.872792e-05, 9.8502016e-05, 9.8276134e-05, 9.8051445e-05, 9.7826465e-05, 9.7601172e-05, 9.7376491e-05, 9.715242e-05, 9.6927739e-05, 9.6703967e-05, 9.6481104e-05, 9.6257936e-05, 9.603447e-05, 9.5811607e-05, 9.558905e-05, 9.5366791e-05, 9.5145144e-05, 9.4923198e-05, 9.4701842e-05, 9.4480194e-05, 9.4259158e-05, 9.4038412e-05, 9.3818278e-05, 9.3598144e-05, 9.337801e-05, 9.3157883e-05, 9.2938659e-05, 9.2720038e-05, 9.2501119e-05, 9.2282207e-05, 9.2063587e-05, 9.184557e-05, 9.1627553e-05, 9.1410155e-05, 9.1192749e-05, 9.0975649e-05, 9.0758549e-05, 9.0541755e-05, 9.0325557e-05, 9.0109977e-05, 8.9894085e-05, 8.96782e-05, 8.9462912e-05, 8.9247638e-05, 8.9032961e-05, 8.8818284e-05, 8.8604516e-05, 8.8390152e-05, 8.8176384e-05, 8.7962915e-05, 8.7749759e-05, 8.7536304e-05, 8.732405e-05, 8.7111803e-05, 8.689925e-05, 8.6686989e-05, 8.6475353e-05, 8.626371e-05, 8.6052976e-05, 8.5841937e-05, 8.5631509e-05, 8.5420477e-05, 8.5210646e-05, 8.5000524e-05, 8.4791609e-05, 8.4581785e-05, 8.4372565e-05, 8.416365e-05, 8.3954736e-05, 8.3746425e-05, 8.3539031e-05, 8.3330728e-05, 8.3123021e-05, 8.291562e-05, 8.270883e-05, 8.2501429e-05, 8.2295548e-05, 8.2089362e-05, 8.1883183e-05, 8.1676997e-05, 8.1471713e-05, 8.1266138e-05, 8.1060862e-05, 8.08568e-05, 8.0652433e-05, 8.0448066e-05, 8.0243699e-05, 8.0039943e-05, 7.9836485e-05, 7.9633639e-05, 7.943048e-05, 7.9227939e-05, 7.9025391e-05, 7.8822843e-05, 7.8620906e-05, 7.8419871e-05, 7.8218538e-05, 7.8016899e-05, 7.781617e-05, 7.7615441e-05, 7.7414719e-05, 7.7215205e-05, 7.7015386e-05, 7.6815268e-05, 7.6616052e-05, 7.6416844e-05, 7.6218232e-05, 7.6019634e-05, 7.5821634e-05, 7.5623335e-05, 7.542564e-05, 7.5227639e-05, 7.5030548e-05, 7.4834068e-05, 7.4636977e-05, 7.4440191e-05, 7.424401e-05, 7.4047835e-05, 7.3851959e-05, 7.3656993e-05, 7.3461721e-05, 7.3266448e-05, 7.3071787e-05, 7.2877425e-05, 7.2682764e-05, 7.2489311e-05, 7.2295559e-05, 7.2102412e-05, 7.190866e-05, 7.1715811e-05, 7.1523275e-05, 7.1331342e-05, 7.1138798e-05, 7.0947171e-05, 7.0755232e-05, 7.0563605e-05, 7.0372575e-05, 7.0182461e-05, 6.9991438e-05, 6.9801019e-05, 6.9610905e-05, 6.9421098e-05, 6.9231282e-05, 6.9042682e-05, 6.8853478e-05, 6.8664573e-05, 6.8475674e-05, 6.8287685e-05, 6.8099383e-05, 6.7911395e-05, 6.7724613e-05, 6.7537228e-05, 6.7349843e-05, 6.7163361e-05, 6.6976587e-05, 6.679041e-05, 6.6604844e-05, 6.6418972e-05, 6.6233712e-05, 6.6048444e-05, 6.5863183e-05, 6.5678527e-05, 6.549478e-05, 6.5310123e-05, 6.5126376e-05, 6.4942629e-05, 6.4758875e-05, 6.4575739e-05, 6.4393505e-05, 6.4210974e-05, 6.4028136e-05, 6.3846208e-05, 6.366428e-05, 6.3482657e-05, 6.3301632e-05, 6.3120613e-05, 6.2939594e-05, 6.2758882e-05, 6.2578467e-05, 6.2398663e-05, 6.2219158e-05, 6.2039355e-05, 6.1860155e-05, 6.1681261e-05, 6.1502062e-05, 6.1323772e-05, 6.1145787e-05, 6.0968101e-05, 6.0789811e-05, 6.061243e-05, 6.0435352e-05, 6.025828e-05, 6.0081806e-05, 5.9905338e-05, 5.9729169e-05, 5.9553004e-05, 5.9377442e-05, 5.9201881e-05, 5.902693e-05, 5.8852278e-05, 5.8677622e-05, 5.8503276e-05, 5.8328624e-05, 5.8154881e-05, 5.798175e-05, 5.7808615e-05, 5.7635174e-05, 5.7462341e-05, 5.7289511e-05, 5.711698e-05, 5.6945668e-05, 5.6773748e-05, 5.6601821e-05, 5.6430508e-05, 5.6259494e-05, 5.6088786e-05, 5.5918077e-05, 5.5748278e-05, 5.5578173e-05, 5.5408073e-05, 5.5238877e-05, 5.506938e-05, 5.4900491e-05, 5.4731903e-05, 5.4563621e-05, 5.4395336e-05, 5.4227356e-05, 5.4059372e-05, 5.3891999e-05, 5.3725536e-05, 5.3558164e-05, 5.3391697e-05, 5.3225234e-05, 5.3058771e-05, 5.2892912e-05, 5.2727657e-05, 5.2562409e-05, 5.2397158e-05, 5.2232208e-05, 5.2067564e-05, 5.1903218e-05, 5.1739487e-05, 5.1575753e-05, 5.1412018e-05, 5.1248582e-05, 5.1085455e-05, 5.0922627e-05, 5.0760409e-05, 5.0598188e-05, 5.043597e-05, 5.0274361e-05, 5.0112441e-05, 4.995113e-05, 4.9790735e-05, 4.9630027e-05, 4.9469327e-05, 4.9309227e-05, 4.914913e-05, 4.8989037e-05, 4.8830152e-05, 4.8671271e-05, 4.8512076e-05, 4.8353195e-05, 4.8194612e-05, 4.8036643e-05, 4.787897e-05, 4.7721296e-05, 4.7563932e-05, 4.7406866e-05, 4.7249498e-05, 4.7093039e-05, 4.6937188e-05, 4.6781333e-05, 4.6624878e-05, 4.6469631e-05, 4.6314086e-05, 4.6158839e-05, 4.6004505e-05, 4.5850167e-05, 4.5695226e-05, 4.5541492e-05, 4.538746e-05, 4.5234035e-05, 4.5080305e-05, 4.4928096e-05, 4.4775272e-05, 4.4622757e-05, 4.4470238e-05, 4.4318331e-05, 4.416642e-05, 4.4015422e-05, 4.3864118e-05, 4.3713419e-05, 4.3562115e-05, 4.3411721e-05, 4.3261629e-05, 4.311245e-05, 4.2962358e-05, 4.2812873e-05, 4.2663691e-05, 4.2514817e-05, 4.2365937e-05, 4.2218271e-05, 4.2070002e-05, 4.1922031e-05, 4.1774365e-05, 4.1627005e-05, 4.1479947e-05, 4.1333493e-05, 4.1186737e-05, 4.1040588e-05, 4.0894138e-05, 4.0748291e-05, 4.060275e-05, 4.0457813e-05, 4.0312876e-05, 4.0167939e-05, 4.0023613e-05, 3.9878978e-05, 3.973495e-05, 3.9591832e-05, 3.9448412e-05, 3.930469e-05, 3.9161878e-05, 3.9019065e-05, 3.8876249e-05, 3.8734648e-05, 3.8592745e-05, 3.8450842e-05, 3.8309543e-05, 3.8168244e-05, 3.802725e-05, 3.7886864e-05, 3.7746475e-05, 3.7606391e-05, 3.7466609e-05, 3.7326525e-05, 3.7187347e-05, 3.704878e-05, 3.6909605e-05, 3.6771035e-05, 3.6632773e-05, 3.6494203e-05, 3.6356541e-05, 3.6219491e-05, 3.6082132e-05, 3.5944777e-05, 3.5808029e-05, 3.5671583e-05, 3.5535442e-05, 3.5398993e-05, 3.5263758e-05, 3.5128221e-05, 3.4992685e-05, 3.485776e-05, 3.4723129e-05, 3.4588506e-05, 3.4454784e-05, 3.4320765e-05, 3.4187047e-05, 3.405333e-05, 3.392022e-05, 3.378711e-05, 3.3655211e-05, 3.3522403e-05, 3.3390203e-05, 3.3258304e-05, 3.3126707e-05, 3.2995114e-05, 3.2864431e-05, 3.2733744e-05, 3.2602758e-05, 3.2472373e-05, 3.2342297e-05, 3.2212218e-05, 3.208335e-05, 3.1953878e-05, 3.1825013e-05, 3.1695843e-05, 3.1567284e-05, 3.143902e-05, 3.1311367e-05, 3.1183412e-05, 3.1056064e-05, 3.0928713e-05, 3.0801362e-05, 3.0674622e-05, 3.0548181e-05, 3.0422043e-05, 3.0296209e-05, 3.0170377e-05, 3.0045148e-05, 2.9919616e-05, 2.9794694e-05, 2.9670377e-05, 2.9546058e-05, 2.9421741e-05, 2.9297726e-05, 2.9174014e-05, 2.9050303e-05, 2.8927805e-05, 2.8805005e-05, 2.8682201e-05, 2.8559705e-05, 2.8437509e-05, 2.8315619e-05, 2.8194332e-05, 2.8073046e-05, 2.7952065e-05, 2.7830778e-05, 2.7710403e-05, 2.7590633e-05, 2.747056e-05, 2.7350487e-05, 2.7231021e-05, 2.7111557e-05, 2.6992695e-05, 2.6874139e-05, 2.6755582e-05, 2.663733e-05, 2.6519077e-05, 2.6401429e-05, 2.6283782e-05, 2.6166437e-05, 2.6050004e-05, 2.5933266e-05, 2.5816833e-05, 2.5700399e-05, 2.5584572e-05, 2.5468744e-05, 2.5354129e-05, 2.5238603e-05, 2.5123687e-05, 2.5009072e-05, 2.4894456e-05, 2.4780144e-05, 2.4667046e-05, 2.4454961e-05, 2.4134919e-05, 2.3818817e-05, 2.3502869e-05, 2.3188131e-05, 2.2872639e-05, 2.2560478e-05, 2.2248925e-05, 2.1938587e-05, 2.1629157e-05, 2.1321395e-05, 2.1013935e-05, 2.0706173e-05, 2.040129e-05, 2.0097774e-05, 1.979532e-05, 1.9493318e-05, 1.9192224e-05, 1.8891589e-05, 1.8594743e-05, 1.8296683e-05, 1.8000141e-05, 1.7704657e-05, 1.7410845e-05, 1.7117029e-05, 1.682549e-05, 1.6534404e-05, 1.624347e-05, 1.5953598e-05, 1.5666606e-05, 1.5379614e-05, 1.5093683e-05, 1.4809419e-05, 1.452546e-05, 1.4242409e-05, 1.3962087e-05, 1.368207e-05, 1.3401899e-05, 1.312446e-05, 1.284717e-05, 1.256973e-05, 1.2295018e-05, 1.2021974e-05, 1.1749687e-05, 1.1477856e-05, 1.1207389e-05, 1.0936922e-05, 1.0667971e-05, 1.0401597e-05, 1.0134921e-05, 9.869912e-06, 9.6064186e-06, 9.3426224e-06, 9.0804942e-06, 8.8197303e-06, 8.5600277e-06, 8.3007799e-06, 8.0439568e-06, 7.7869827e-06, 7.5304642e-06, 7.2766738e-06, 7.0260676e-06, 6.7736414e-06, 6.5224294e-06, 6.2722775e-06, 6.0227321e-06, 5.7756133e-06, 5.5283422e-06, 5.2827386e-06, 5.0383478e-06, 4.7939579e-06, 4.5522956e-06, 4.3095729e-06, 4.0691243e-06, 3.8304952e-06, 3.5929268e-06, 3.3553588e-06, 3.1193063e-06, 2.8834056e-06, 2.6499315e-06, 2.4167593e-06, 2.1860135e-06, 1.9552679e-06, 1.7261893e-06, 1.4955957e-06, 1.2690944e-06, 1.0427451e-06, 8.1745702e-07, 5.9383694e-07, 3.703683e-07, 1.4902189e-07, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 2.4608247e-05, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 0.00045098047, 1.9666443e-06, 4.9023683e-06, 7.8483981e-06, 1.0814424e-05, 1.3791988e-05, 1.6798673e-05, 1.9787753e-05, 2.2815646e-05, 2.5854459e-05, 2.8913884e-05, 3.1983625e-05, 3.507399e-05, 3.8175254e-05, 4.1266827e-05, 4.4408731e-05, 4.7561556e-05, 5.0724069e-05, 5.3897518e-05, 5.709218e-05, 6.0286231e-05, 6.3511819e-05, 6.6747722e-05, 7.0003036e-05, 7.3269868e-05, 7.6557299e-05, 7.9845362e-05, 8.3163133e-05, 8.6491818e-05, 8.9841124e-05, 9.3200128e-05, 9.6580348e-05, 9.997149e-05, 0.00010335294, 0.00010677622, 0.00011021831, 0.00011368041, 0.00011714371, 0.00012062764, 0.00012411218, 0.00012762705, 0.0001311528, 0.00013469861, 0.00013825469, 0.00014183141, 0.00014542873, 0.00014901698, 0.00015263552, 0.00015627411, 0.00015992358, 0.0001635931, 0.00016727411, 0.00017095511, 0.00017466646, 0.00017838871, 0.00018214068, 0.00018590355, 0.00018967739, 0.00019344207, 0.00019724621, 0.00020107157, 0.00020490721, 0.00020875318, 0.00021261977, 0.00021649725, 0.00022038445, 0.0002242929, 0.00022822134, 0.00023216133, 0.00023612128, 0.00024009157, 0.00024406247, 0.00024806368, 0.00025207581, 0.00025610792, 0.00026017037, 0.00026423347, 0.00026830746, 0.00027238205, 0.00027649666, 0.00028062219, 0.00028475802, 0.00028891448, 0.00029308128, 0.00029724924, 0.00030145663, 0.00030567494, 0.00030990358, 0.00031415341, 0.00031841357, 0.00032267373, 0.0003269648, 0.00033127653, 0.00033559854, 0.00033993088, 0.00034429409, 0.00034866709, 0.00035303156, 0.0003574263, 0.0003618417, 0.00036627776, 0.0003707241, 0.00037518071, 0.00037963857, 0.00038413584, 0.00038864402, 0.00039316251, 0.0003977016, 0.00040225167, 0.00040680173, 0.00041138264, 0.00041598364, 0.00042059549, 0.00042522736, 0.00042987018, 0.00043451367, 0.00043918801, 0.00044388173, 0.00044858703, 0.00045385057, 0.0004595074, 0.00046520296, 0.00047089852, 0.00047666201, 0.00048247405, 0.00048832479, 0.00049419503, 0.00050011376, 0.00050605193, 0.00051205803, 0.00051808346, 0.00052415743, 0.00053027028, 0.00053642184, 0.00054262194, 0.00054882211, 0.00055509014, 0.00056139694, 0.00056774262, 0.00057411741, 0.00058054068, 0.00058696402, 0.00059345516, 0.00060000457, 0.00060657342, 0.00061319076, 0.0006198372, 0.00062650308, 0.00063323684, 0.00063999003, 0.00064679171, 0.00065369043, 0.00066056009, 0.00066748785, 0.00067443511, 0.0006814212, 0.00068844605, 0.0006955291, 0.00070264132, 0.00070978259, 0.00071694329, 0.00072417193, 0.00073143933, 0.00073874556, 0.000746081, 0.00075347454, 0.00076088752, 0.0007683296, 0.00077581051, 0.00078335928, 0.00079090812, 0.00079851516, 0.00080618041, 0.000813836, 0.00082157878, 0.00082934112, 0.00083713251, 0.00084498205, 0.00085285114, 0.00086074928, 0.00086871529, 0.00087672006, 0.00088475406, 0.00089283648, 0.00090093841, 0.0009090791, 0.00091724889, 0.00092547695, 0.000933734, 0.00094202993, 0.00095037441, 0.00095875765, 0.00096715067, 0.00097560178, 0.00098411122, 0.00099264004, 0.0010012173, 0.0010098334, 0.0010184495, 0.0010271335, 0.0010358565, 0.0010446182, 0.0010534284, 0.0010622676, 0.001071136, 0.0010800433, 0.0010890086, 0.0010979838, 0.0011070172, 0.0011160991, 0.0011252002, 0.0011343306, 0.0011435095, 0.0011527371, 0.0011619935, 0.0011712986, 0.0011806326, 0.0011899862, 0.0011994174, 0.0012088582, 0.0012183865, 0.0012279147, 0.001237501, 0.0012470972, 0.0012567322, 0.0012664058, 0.0012761474, 0.0012858891, 0.0012956987, 0.0013055276, 0.0013153858, 0.0013253021, 0.0013352572, 0.0013452609, 0.0013553032, 0.0013653554, 0.0013754463, 0.0013855956, 0.0013957738, 0.0014060007, 0.0014162663, 0.0014265513, 0.0014369043, 0.0014472571, 0.0014576779, 0.0014681281, 0.0014786168, 0.0014891346, 0.0014997107, 0.0015102965, 0.0015209407, 0.0015316332, 0.0015423354, 0.0015531055, 0.0015639047, 0.0015747526, 0.0015855908, 0.0015965065, 0.0016074609, 0.0016184446, 0.0016294767, 0.0016405475, 0.001651638, 0.0016627768, 0.0016739641, 0.001685171, 0.001696436, 0.0017077398, 0.0017190728, 0.0017304252, 0.0017418357, 0.0017532849, 0.0017647926, 0.0017763486, 0.0017879143, 0.00179949, 0.001811143, 0.0018228348, 0.001834556, 0.0018463061, 0.0018580951, 0.0018699227, 0.0018817991, 0.0018937143, 0.0019056487, 0.0019176512, 0.0019296827, 0.0019417433, 0.0019538235, 0.0019659714, 0.0019781289, 0.0019903742, 0.0020026481, 0.0020149513, 0.0020272739, 0.0020396451, 0.002052055, 0.002064494, 0.0020769816, 0.0020895079, 0.0021020537, 0.0021146578, 0.00212732, 0.0021399918, 0.0021527123, 0.0021654617, 0.0021782403, 0.0021910775, 0.0022039434, 0.0022168483, 0.0022298014, 0.0022427838, 0.0022558146, 0.0022688748, 0.0022819638, 0.0022951113, 0.0023082877, 0.0023215127, 0.0023347572, 0.0023480402, 0.0023613621, 0.0023747326, 0.0023881616, 0.0024016097, 0.0024150966, 0.0024286127, 0.0024421676, 0.0024557516, 0.0024693939, 0.0024830843, 0.0024967946, 0.0025105535, 0.0025243312, 0.0025381579, 0.0025520425, 0.0025659369, 0.00257989, 0.0025938717, 0.0026078825, 0.0026219517, 0.0026360303, 0.0026502355, 0.0026644017, 0.002678626, 0.0026928892, 0.0027071524, 0.0027214834, 0.0027358532, 0.0027502719, 0.0027647095, 0.0027792153, 0.0027937116, 0.0028082754, 0.0028228781, 0.0028375294, 0.0028521903, 0.0028669096, 0.0028816676, 0.0028964356, 0.0029112517, 0.0029261457, 0.0029410587, 0.0029559818, 0.0029709823, 0.0029859929, 0.0030010515, 0.0030161492, 0.0030312953, 0.0030464609, 0.0030616748, 0.003076918, 0.0030922098, 0.0031075499, 0.0031229001, 0.0031383082, 0.0031537649, 0.0031692309, 0.003184736, 0.0032003187, 0.0032159113, 0.0032315524, 0.0032472222, 0.003262931, 0.0032786787, 0.0032944561, 0.0033102911, 0.003326165, 0.0033420776, 0.0033580386, 0.0033739901, 0.0033900097, 0.0034060872, 0.0034221746, 0.00343832, 0.0034544754, 0.0034706888, 0.0034869311, 0.0035032223, 0.0035195523, 0.003535921, 0.0035523186, 0.0035687748, 0.0035852599, 0.0036017741, 0.0036183272, 0.003634929, 0.0036515691, 0.0036682389, 0.003684947, 0.0037016841, 0.0037185189, 0.0037353532, 0.0037522262, 0.003769119, 0.00378607, 0.0038030306, 0.0038200687, 0.0038371163, 0.0038542128, 0.0038713482, 0.0038885223, 0.0039057254, 0.0039229579, 0.0039402479, 0.0039575775, 0.0039749453, 0.0039923424, 0.0040097693, 0.0040272633, 0.004044767, 0.0040623392, 0.0040799398, 0.0040975697, 0.0041152393, 0.0041329367, 0.0041506835, 0.004168469, 0.0041862931, 0.0042041657, 0.0042220675, 0.0042399978, 0.0042579677, 0.0042759958, 0.0042940625, 0.0043121586, 0.004330283, 0.0043484662, 0.00436664, 0.0043848907, 0.0044031902, 0.0044215093, 0.0044398769, 0.0044583022, 0.0044767186, 0.0044951928, 0.0045137154, 0.0045322673, 0.0045508579, 0.0045695067, 0.0045881462, 0.004606863, 0.0046256087, 0.0046444032, 0.0046632555, 0.0046821181, 0.0047010384, 0.0047199591, 0.0047389381, 0.004757965, 0.0047770217, 0.0047961073, 0.0048152511, 0.0048344042, 0.004853616, 0.0048728567, 0.0048921457, 0.004911474, 0.0049308408, 0.0049502365, 0.0049696518, 0.0049891355, 0.0050086672, 0.0050282185, 0.0050478182, 0.0050674276, 0.0050870953, 0.0051068212, 0.0051265568, 0.0051463507, 0.0051661734, 0.0051860549, 0.0052059167, 0.0052258754, 0.0052458532, 0.005265851, 0.0052859164, 0.0053060013, 0.0053261346, 0.0053462973, 0.0053665079, 0.0053867577, 0.0054070465, 0.0054273447, 0.0054477211, 0.005468097, 0.0054885508, 0.0055090333, 0.0055295452, 0.0055501051, 0.0055706855, 0.0055912938, 0.0056119612, 0.0056326771, 0.0056534116, 0.0056741955, 0.0056950273, 0.0057158591, 0.0057367692, 0.0057577076, 0.0057787048, 0.0057997112, 0.0058207661, 0.0058418601, 0.0058629927, 0.0058841552, 0.0059053656, 0.0059265951, 0.005947873, 0.005969211, 0.0059905471, 0.0060119415, 0.0060334331, 0.0060549057, 0.0060764267, 0.0060979673, 0.0061195558, 0.0061411732, 0.0061628302, 0.0061845449, 0.0062063085, 0.0062280917, 0.0062499037, 0.0062717441, 0.0062936442, 0.0063155731, 0.0063375593, 0.0063595749, 0.0063816095, 0.0064036846, 0.0064258263, 0.0064479969, 0.0064702071, 0.0064924457, 0.0065147136, 0.00653705, 0.0065593864, 0.00658178, 0.0066042133, 0.006626714, 0.0066492148, 0.0066717635, 0.0066943234, 0.0067169606, 0.0067396257, 0.00676235, 0.0067850738, 0.0068078563, 0.0068306872, 0.0068535279, 0.006876416, 0.0068993638, 0.0069223405, 0.0069453549, 0.006968399, 0.0069914539, 0.0070145852, 0.0070377747, 0.0070609744, 0.0070842123, 0.0071074991, 0.0071308059, 0.0071541802, 0.0071775829, 0.0072010057, 0.0072245062, 0.0072480068, 0.0072715357, 0.0072951233, 0.0073187598, 0.0073424242, 0.007366119, 0.0073898719, 0.0074136532, 0.0074374545, 0.0074613043, 0.0074852025, 0.0075091394, 0.0075330953, 0.0075571295, 0.0075811432, 0.0076052942, 0.007629416, 0.0076535759, 0.007677794, 0.0077020125, 0.0077262786, 0.0077505945, 0.0077749589, 0.0077993418, 0.0078237737, 0.0078482637, 0.0078727631, 0.0078973016, 0.0079218885, 0.0079465136, 0.0079711694, 0.0079958923, 0.0080206152, 0.0080453763, 0.008071444, 0.0080983788, 0.0081253918, 0.008152443, 0.0081795529, 0.0082067018, 0.0082339086, 0.0082611535, 0.0082884189, 0.0083158007, 0.0083431816, 0.0083706211, 0.0083981389, 0.0084256753, 0.00845329, 0.0084809037, 0.0085086152, 0.0085363844, 0.0085641546, 0.0085920207, 0.0086199259, 0.0086478703, 0.0086758928, 0.0087038754, 0.0087320134, 0.0087601515, 0.0087883482, 0.0088165831, 0.0088448571, 0.0088732094, 0.0089016194, 0.0089300284, 0.0089585362, 0.0089870822, 0.0090156663, 0.0090443091, 0.0090729715, 0.0091017308, 0.0091305291, 0.0091593452, 0.0091882404, 0.0092171552, 0.0092461668, 0.0092752175, 0.0093042869, 0.0093334336, 0.0093626212, 0.0093918266, 0.0094211865, 0.0094504505, 0.0094798692, 0.0095093083, 0.0095387856, 0.0095683206, 0.0095978947, 0.009627508, 0.0096572181, 0.0096869282, 0.0097167352, 0.0097465422, 0.0097764265, 0.0098063508, 0.0098363524, 0.0098664118, 0.0098964712, 0.0099265883, 0.0099567836, 0.009986979, 0.01001729, 0.010047602, 0.010077952, 0.01010842, 0.010138887, 0.010169432, 0.010199975, 0.010230598, 0.010261318, 0.010292017, 0.010322794, 0.01035363, 0.010384485, 0.010415417, 0.01044635, 0.010477399, 0.010508487, 0.010539575, 0.010570779, 0.010601964, 0.010633266, 0.010664625, 0.010695945, 0.010727403, 0.010758859, 0.010790374, 0.010821947, 0.01085356, 0.01088521, 0.010916958, 0.010948685, 0.01098055, 0.011012375, 0.011044317, 0.011076278, 0.011108279, 0.011140357, 0.011172434, 0.011204627, 0.011236841, 0.011269113, 0.011301422, 0.011333792, 0.011366179, 0.011398665, 0.011431131, 0.011463711, 0.011496354, 0.011529012, 0.011561731, 0.011594468, 0.011627283, 0.011660175, 0.011693049, 0.011726, 0.011759047, 0.011792056, 0.011825201, 0.011858308, 0.011891532, 0.011924811, 0.011958091, 0.011991469, 0.012024847, 0.012058341, 0.012091836, 0.012125388, 0.012158998, 0.012192668, 0.012226317, 0.012260103, 0.012293888, 0.012327771, 0.01236169, 0.012395613, 0.01242963, 0.012463649, 0.012497784, 0.012531918, 0.01256613, 0.01260038, 0.01263469, 0.012669018, 0.012703425, 0.012737851, 0.012772375, 0.012806877, 0.012841517, 0.012876174, 0.012910852, 0.012945628, 0.012980383, 0.013015256, 0.013050146, 0.013085096, 0.013120065, 0.013155092, 0.013190197, 0.013225361, 0.013260524, 0.013295804, 0.013331103, 0.013366421, 0.013401835, 0.01343725, 0.013472743, 0.013508277, 0.013543886, 0.013579514, 0.013615182, 0.013650926, 0.01368673, 0.013722533, 0.013758453, 0.013794374, 0.013830352, 0.013866408, 0.013902503, 0.013938655, 0.013974808, 0.014011057, 0.014047366, 0.014083693, 0.014120079, 0.014156484, 0.014192966, 0.014229526, 0.014266087, 0.014302726, 0.014339402, 0.014376157, 0.014412949, 0.014449743, 0.014486632, 0.014523582, 0.014560549, 0.014597574, 0.01463464, 0.014671802, 0.014708964, 0.014746164, 0.014783462, 0.014820779, 0.014858194, 0.014895608, 0.01493308, 0.014970592, 0.015008198, 0.015045808, 0.015083474, 0.015121217, 0.015158962, 0.015196823, 0.015234664, 0.015272583, 0.015310559, 0.015348576, 0.015386648, 0.0154248, 0.015462952, 0.015501161, 0.015539448, 0.015577756, 0.01561614, 0.015654525, 0.015693028, 0.015731527, 0.015770106, 0.015808702, 0.0158474, 0.015886113, 0.015924884, 0.015963698, 0.016002564, 0.016041474, 0.016080441, 0.016119465, 0.01615849, 0.016197652, 0.016236812, 0.016276011, 0.016315268, 0.016354604, 0.016393939, 0.016433392, 0.016472863, 0.016512372, 0.016551921, 0.016591547, 0.016631192, 0.016670916, 0.016710659, 0.01675046, 0.01679034, 0.016830238, 0.016870175, 0.016910208, 0.016950242, 0.016990354, 0.017030524, 0.017070713, 0.017110961, 0.017151285, 0.017191648, 0.017232053, 0.017272493, 0.017313013, 0.01735357, 0.017394166, 0.017434802, 0.017475497, 0.017516287, 0.017557098, 0.017597925, 0.017638832, 0.017679799, 0.017720804, 0.017761827, 0.017802928, 0.017844068, 0.017885286, 0.017926542, 0.017967818, 0.018009171, 0.018050583, 0.018092034, 0.018133504, 0.018175051, 0.018216657, 0.018258302, 0.018300023, 0.018341746, 0.018383527, 0.018425385, 0.018467281, 0.018509217, 0.01855123, 0.018593263, 0.018635392, 0.018677523, 0.018719692, 0.018761918, 0.018804261, 0.018846564, 0.018888948, 0.018931407, 0.018973906, 0.019016443, 0.019059019, 0.019101653, 0.019144366, 0.019187097, 0.019229867, 0.019272713, 0.0193156, 0.019358544, 0.01940153, 0.01944457, 0.019487632, 0.019530792, 0.019573968, 0.019617185, 0.019660478, 0.019703791, 0.019747203, 0.019790651, 0.01983414, 0.019877667, 0.019921253, 0.019964876, 0.02000854, 0.020052278, 0.020096058, 0.020139916, 0.020183792, 0.020227708, 0.020271681, 0.020315731, 0.020359781, 0.02040395, 0.020448117, 0.020492341, 0.020536607, 0.020580947, 0.020625329, 0.020669729, 0.020714207, 0.020758724, 0.020803317, 0.02084795, 0.020892603, 0.020937335, 0.020982141, 0.02102695, 0.021071814, 0.021116739, 0.02116172, 0.021206742, 0.021251783, 0.02129692, 0.021342076, 0.021387313, 0.021432567, 0.021477899, 0.021523269, 0.021568697, 0.021614185, 0.021659689, 0.021705236, 0.021750858, 0.021796539, 0.02184226, 0.02188802, 0.021933816, 0.021979729, 0.022025643, 0.022071557, 0.022117587, 0.022163676, 0.022209765, 0.022255931, 0.022302134, 0.0223484, 0.022394702, 0.02244108, 0.022487478, 0.022533953, 0.022580471, 0.022627024, 0.022673637, 0.022720268, 0.022767017, 0.022813747, 0.022860592, 0.022907456, 0.022954341, 0.023001302, 0.023048323, 0.023095362, 0.023142481, 0.023189634, 0.02323685, 0.023284104, 0.023331393, 0.023378761, 0.023426171, 0.023473617, 0.023521125, 0.023568645, 0.023616269, 0.023663908, 0.023711609, 0.023759386, 0.023807181, 0.023855053, 0.023902947, 0.023950879, 0.023998873, 0.024046941, 0.024095027, 0.02414321, 0.024191394, 0.024239657, 0.024287956, 0.024336297, 0.024384674, 0.02443313, 0.024481645, 0.02453018, 0.024578771, 0.024627421, 0.024676127, 0.024724877, 0.024773642, 0.024822528, 0.024871409, 0.02492035, 0.024969351, 0.025018407, 0.025067464, 0.025116619, 0.025165796, 0.025215063, 0.025264353, 0.025313703, 0.025363069, 0.025412519, 0.025462, 0.025511524, 0.025561126, 0.025610764, 0.025660446, 0.025710201, 0.025759976, 0.02580981, 0.025859701, 0.025909634, 0.025959618, 0.026009647, 0.026059736, 0.02610988, 0.026160061, 0.026210302, 0.026260585, 0.026310923, 0.026361298, 0.026411736, 0.026462227, 0.026512779, 0.026563352, 0.02661396, 0.026664669, 0.026715377, 0.026766181, 0.026816983, 0.026867883, 0.026918786, 0.026969783, 0.027020799, 0.027071878, 0.027122989, 0.027174205, 0.027225433, 0.027276704, 0.027328031, 0.027379399, 0.027430825, 0.027482288, 0.027533829, 0.027585411, 0.027637027, 0.027688688, 0.027741734, 0.027796108, 0.027850552, 0.027905032, 0.027959563, 0.028014123, 0.02806871, 0.028123368, 0.028178053, 0.028232787, 0.028287539, 0.028342379, 0.028397199, 0.0284521, 0.028507035, 0.028562034, 0.028617077, 0.028672121, 0.028727213, 0.028782366, 0.028837554, 0.0288928, 0.02894808, 0.029003376, 0.02905873, 0.029114155, 0.029169597, 0.029225066, 0.02928059, 0.029336171, 0.02939178, 0.029447418, 0.02950312, 0.029558845, 0.029614655, 0.029670484, 0.029726325, 0.029782241, 0.029838212, 0.029894186, 0.029950218, 0.030006301, 0.030062394, 0.030118562, 0.030174764, 0.030231008, 0.030287284, 0.03034359, 0.030399986, 0.030456396, 0.030512849, 0.030569335, 0.030625876, 0.030682463, 0.03073906, 0.030795725, 0.030852418, 0.030909188, 0.030965969, 0.031022809, 0.031079648, 0.031136587, 0.031193541, 0.031250544, 0.031307589, 0.031364661, 0.031421769, 0.03147896, 0.031536158, 0.031593397, 0.031650674, 0.031708024, 0.031765405, 0.03182283, 0.031880282, 0.031937789, 0.031995345, 0.032052904, 0.032110557, 0.032168232, 0.032225944, 0.032283675, 0.032341477, 0.032399315, 0.032457221, 0.032515109, 0.032573074, 0.032631077, 0.032689139, 0.032747239, 0.032805372, 0.032863535, 0.032921754, 0.032980029, 0.033038314, 0.03309666, 0.033155028, 0.033213463, 0.033271927, 0.033330441, 0.033388983, 0.033447608, 0.033506222, 0.033564907, 0.033623621, 0.03368238, 0.033741198, 0.033800036, 0.033858921, 0.033917848, 0.033976842, 0.034035865, 0.034094896, 0.034153983, 0.034213144, 0.034272332, 0.03433156, 0.034390807, 0.03445011, 0.034509487, 0.034568891, 0.034628317, 0.034687787, 0.034747306, 0.034806851, 0.034866467, 0.034926102, 0.034985799, 0.035045516, 0.035105292, 0.035165109, 0.035224978, 0.035284881, 0.035344787, 0.03540479, 0.035464831, 0.03552489, 0.035585001, 0.035645157, 0.035705324, 0.035765581, 0.035825837, 0.035886165, 0.035946537, 0.03600695, 0.036067355, 0.036127847, 0.036188394, 0.036248967, 0.036309581, 0.036370203, 0.036430895, 0.036491655, 0.036552422, 0.036613259, 0.036674116, 0.036735009, 0.036795992, 0.036856964, 0.036917988, 0.036979076, 0.037040185, 0.037101336, 0.037162539, 0.037223782, 0.037285086, 0.037346385, 0.037407767, 0.037469167, 0.037530646, 0.037592143, 0.037653636, 0.037715212, 0.037776846, 0.037838534, 0.037900236, 0.037961956, 0.03802374, 0.038085587, 0.038147453, 0.038209379, 0.0382713, 0.038333341, 0.038395364, 0.03845745, 0.038519591, 0.038581744, 0.038643949, 0.038706202, 0.038768474, 0.038830813, 0.038893215, 0.038955625, 0.039018061, 0.039080575, 0.039143123, 0.039205723, 0.039268337, 0.039331, 0.039393708, 0.039456483, 0.039519303, 0.039582096, 0.039645001, 0.039707925, 0.039770897, 0.039833903, 0.039896965, 0.039960001, 0.040023178, 0.040086336, 0.040149562, 0.040212821, 0.040276121, 0.040339462, 0.040402845, 0.040466279, 0.040529743, 0.040593259, 0.040656801, 0.040720396, 0.040784046, 0.040847719, 0.040911436, 0.040975194, 0.041038997, 0.041102853, 0.041166745, 0.04123069, 0.041294631, 0.041358639, 0.041422747, 0.041486822, 0.041550998, 0.041615184, 0.041679386, 0.04174364, 0.041807968, 0.04187233, 0.041936725, 0.042001132, 0.04206562, 0.042130161, 0.042194713, 0.042259328, 0.042323947, 0.042388652, 0.042453382, 0.042518161, 0.042582955, 0.042647839, 0.042712711, 0.042777661, 0.042842641, 0.04290767, 0.042972736, 0.043037832, 0.043102987, 0.043168172, 0.043233436, 0.043298703, 0.043364014, 0.043429364, 0.043494768, 0.043560226, 0.043625701, 0.04369121, 0.043756798, 0.043822415, 0.043888077, 0.043953769, 0.044019479, 0.044085305, 0.044151101, 0.044216968, 0.044282854, 0.044348832, 0.044414815, 0.044480849, 0.044546932, 0.044613037, 0.044679198, 0.044745397, 0.044811644, 0.044877928, 0.044944275, 0.045010641, 0.045077041, 0.045143481, 0.045209959, 0.045276511, 0.04534312, 0.045409713, 0.045476366, 0.045543078, 0.045609821, 0.045676619, 0.045743465, 0.045810297, 0.045877233, 0.045944192, 0.046011198, 0.046078227, 0.046145305, 0.046212431, 0.046279613, 0.046346813, 0.046414081, 0.046481352, 0.046548683, 0.046616059, 0.046683494, 0.046750963, 0.046818461, 0.046886001, 0.046953581, 0.047021233, 0.047088899, 0.047156606, 0.04722435, 0.047292151, 0.047359992, 0.047427882, 0.047495816, 0.047563754, 0.047631793, 0.047699828, 0.04776796, 0.047836073, 0.04790426, 0.047972456, 0.048040714, 0.048109028, 0.04817738, 0.048245747, 0.048314173, 0.048382644, 0.048451174, 0.048519708, 0.048588306, 0.048656937, 0.048725631, 0.048794348, 0.048863102, 0.048931915, 0.049000785, 0.049069654, 0.049138606, 0.049207568, 0.049276605, 0.049345665, 0.049414735, 0.049483869, 0.04955307, 0.049622308, 0.049691573, 0.049760845, 0.049830209, 0.049899623, 0.049969051, 0.050038524, 0.050108045, 0.050177623, 0.050247211, 0.050316874, 0.050386563, 0.050456289, 0.050526056, 0.050595872, 0.050665714, 0.050735634, 0.050805572, 0.050875548, 0.050945558, 0.051015619, 0.051085763, 0.051155925, 0.051226091, 0.051296327, 0.051366609, 0.05143692, 0.051507302, 0.051577669, 0.051648118, 0.051718622, 0.051789153, 0.05185971, 0.051930349, 0.052000962, 0.052071687, 0.052142423, 0.052213203, 0.052284013, 0.052354883, 0.052425802, 0.052496742, 0.052567746, 0.052638792, 0.052709837, 0.052780975, 0.052852124, 0.052923318, 0.052994572, 0.053065859, 0.053137176, 0.053208549, 0.05327997, 0.053351425, 0.053422913, 0.053494453, 0.053566024, 0.053637635, 0.053709298, 0.053781029, 0.053852737, 0.053924568, 0.053996392, 0.054068271, 0.054140188, 0.054212142, 0.054284122, 0.054356176, 0.054428264, 0.054500416, 0.054572586, 0.054644763, 0.054717042, 0.054789338, 0.05486165, 0.05493404, 0.055006459, 0.055078916, 0.055151422, 0.055223979, 0.055296555, 0.055369213, 0.055441864, 0.055514582, 0.055587329, 0.055660151, 0.055732988, 0.055805847, 0.055878781, 0.055951752, 0.056024771, 0.056097813, 0.056170899, 0.056244019, 0.056317192, 0.056390423, 0.056463685, 0.056536976, 0.056610327, 0.056683712, 0.056757152, 0.056830611, 0.056904119, 0.056977671, 0.057051294, 0.057124924, 0.057198584, 0.057272341, 0.057346087, 0.057419889, 0.057493743, 0.057567641, 0.057641599, 0.057715535, 0.057789542, 0.057863604, 0.05793773, 0.058011863, 0.058086023, 0.058160271, 0.058234543, 0.058308858, 0.058383204, 0.058457606, 0.058532048, 0.058606513, 0.058681041, 0.05875561, 0.058830213, 0.058904845, 0.058979545, 0.059054274, 0.059129033, 0.059203874, 0.059278719, 0.059353605, 0.05942855, 0.059503537, 0.059578575, 0.059653625, 0.059728738, 0.059803914, 0.059879072, 0.059954327, 0.060029596, 0.060104936, 0.060181264, 0.060258824, 0.060336366, 0.060413927, 0.060491521, 0.060569137, 0.060646761, 0.060724374, 0.06080202, 0.0608797, 0.060957376, 0.061035078, 0.061112773, 0.061190508, 0.061268236, 0.061345994, 0.061423786, 0.061501555, 0.061579354, 0.061657179, 0.061735012, 0.061812859, 0.061890725, 0.061968591, 0.062046483, 0.062124398, 0.062202334, 0.062280267, 0.062358197, 0.062436182, 0.062514171, 0.062592179, 0.062670186, 0.062748216, 0.062826246, 0.062904306, 0.062982395, 0.063060477, 0.063138567, 0.063216701, 0.063294835, 0.063372999, 0.063451171, 0.063529365, 0.063607559, 0.063685767, 0.063764006, 0.06384223, 0.063920505, 0.063998781, 0.064077064, 0.064155377, 0.064233683, 0.064312011, 0.064390361, 0.064468741, 0.064547129, 0.064625502, 0.064703919, 0.064782344, 0.064860798, 0.064939253, 0.065017723, 0.065096185, 0.065174699, 0.065253228, 0.065331765, 0.065410309, 0.06548886, 0.065567434, 0.06564603, 0.065724649, 0.065803282, 0.065881908, 0.065960556, 0.066039242, 0.06611792, 0.06619662, 0.066275336, 0.066354066, 0.066432811, 0.066511564, 0.066590361, 0.066669144, 0.066747934, 0.066826768, 0.066905603, 0.06698446, 0.067063339, 0.067142203, 0.06722109, 0.067300044, 0.067378946, 0.067457899, 0.067536861, 0.067615837, 0.067694828, 0.067773834, 0.067852847, 0.067931883, 0.068010941, 0.068090014, 0.068169072, 0.068248183, 0.0683273, 0.068406433, 0.068485558, 0.06856472, 0.06864389, 0.068723075, 0.06880229, 0.068881512, 0.068960734, 0.069039978, 0.069119237, 0.069198512, 0.069277816, 0.069357127, 0.069436438, 0.069515787, 0.069595151, 0.069674522, 0.0697539, 0.069833286, 0.069912717, 0.069992147, 0.0700716, 0.070151061, 0.070230536, 0.070310026, 0.070389539, 0.070469052, 0.070548601, 0.070628151, 0.070707716, 0.070787296, 0.070866898, 0.070946522, 0.071026146, 0.071105801, 0.071185447, 0.071265124, 0.071344808, 0.071424522, 0.071504243, 0.071583994, 0.071663745, 0.071743496, 0.071823277, 0.07190308, 0.07198289, 0.072062731, 0.072142579, 0.072222419, 0.072302282, 0.072382189, 0.072462089, 0.072542012, 0.072621919, 0.072701894, 0.072781853, 0.07286182, 0.072941825, 0.073021822, 0.073101856, 0.073181905, 0.073261954, 0.073342033, 0.073422112, 0.073502213, 0.073582329, 0.073662467, 0.073742613, 0.073822781, 0.073902942, 0.073983133, 0.074063346, 0.074143581, 0.074223831, 0.074304067, 0.074384324, 0.074464619, 0.074544922, 0.074625239, 0.074705563, 0.074785903, 0.07486628, 0.074946649, 0.075027041, 0.075107455, 0.075187869, 0.075268321, 0.07534875, 0.075429223, 0.075509712, 0.075590208, 0.075670719, 0.075751267, 0.075831793, 0.075912349, 0.075992927, 0.076073527, 0.076154128, 0.076234728, 0.076315381, 0.076396033, 0.076476693, 0.076557368, 0.07663805, 0.07671877, 0.07679949, 0.076880254, 0.076961011, 0.077041753, 0.077122554, 0.077203363, 0.077284187, 0.077365004, 0.077445865, 0.077526711, 0.077607594, 0.077688493, 0.077769414, 0.077850334, 0.077931248, 0.078012221, 0.078093193, 0.078174174, 0.078255184, 0.078336172, 0.078417212, 0.078498267, 0.078579329, 0.078660414, 0.078741483, 0.078822598, 0.078903757, 0.078984857, 0.079066016, 0.079147182, 0.079228379, 0.079309575, 0.079390794, 0.079472005, 0.079553261, 0.07963451, 0.079715803, 0.079797089, 0.079878375, 0.079959705, 0.080041051, 0.080122389, 0.080203757, 0.080285139, 0.080366522, 0.080447949, 0.080529377, 0.080610819, 0.080692261, 0.080773734, 0.080855235, 0.08093673, 0.081018254, 0.081099801, 0.081181325, 0.081262887, 0.081344478, 0.081426077, 0.081507698, 0.081589311, 0.081670932, 0.081752591, 0.081834286, 0.08191596, 0.081997648, 0.082079373, 0.082161091, 0.082242846, 0.082324617, 0.082406379, 0.082488187, 0.082569987, 0.082651809, 0.082733646, 0.082815513, 0.082897373, 0.082979254, 0.083061159, 0.083143085, 0.083225004, 0.083306953, 0.083388917, 0.083470896, 0.083552875, 0.083634883, 0.083716907, 0.083798952, 0.083880983, 0.083963059, 0.084045149, 0.084127232, 0.084209345, 0.084291473, 0.084373616, 0.084455781, 0.084537946, 0.08462014, 0.084702328, 0.08478456, 0.084866807, 0.084949031, 0.085031301, 0.085113592, 0.085195869, 0.085278198, 0.085360505, 0.085442856, 0.085525207, 0.085607581, 0.085689962, 0.085772365, 0.085854784, 0.085937224, 0.086019665, 0.086102135, 0.086184606, 0.086267099, 0.086349599, 0.086432122, 0.086514667, 0.086597227, 0.086679786, 0.086762384, 0.086844988, 0.086927593, 0.087010235, 0.087092876, 0.087175533, 0.087258212, 0.087340899, 0.087423608, 0.087506332, 0.08758907, 0.087671816, 0.087754585, 0.087837368, 0.087920167, 0.08800298, 0.088085808, 0.088168651, 0.088251509, 0.088334382, 0.088417269, 0.088500172, 0.088583097, 0.088666014, 0.088748977, 0.088831946, 0.088914931, 0.088997915, 0.08908093, 0.089163952, 0.089246996, 0.089330047, 0.089413129, 0.089496218, 0.089579307, 0.089662433, 0.089745551, 0.089828715, 0.089911886, 0.089995049, 0.090078242, 0.090161458, 0.090244673, 0.090327911, 0.090411164, 0.090494439, 0.090577722, 0.090661027, 0.090744346, 0.090827689, 0.090911031, 0.090994388, 0.09107776, 0.091161169, 0.091244571, 0.091327988, 0.091411427, 0.091494888, 0.091578342, 0.091661841, 0.091745324, 0.091828845, 0.091912366, 0.09199591, 0.092079476, 0.092163034, 0.092246629, 0.092330247, 0.092413858, 0.092497483, 0.092581153, 0.092664808, 0.092748486, 0.092832185, 0.092915885, 0.09299963, 0.093083359, 0.093167126, 0.093250901, 0.093334675, 0.093418486, 0.093502305, 0.093586139, 0.093669988, 0.093753837, 0.093837738, 0.093921617, 0.094005525, 0.094089456, 0.094173402, 0.094257355, 0.09434133, 0.094425313, 0.094509304, 0.094593324, 0.094677351, 0.094761416, 0.094845474, 0.094929554, 0.095013641, 0.09509775, 0.095181875, 0.095266014, 0.095350169, 0.095434338, 0.095518515, 0.095602706, 0.095686942, 0.095771149, 0.0958554, 0.095939659, 0.096023932, 0.096108235, 0.096192531, 0.09627685, 0.096361198, 0.096445538, 0.096529908, 0.096614279, 0.096698686, 0.096783109, 0.096867517, 0.096951976, 0.097036429, 0.097120896, 0.0972054, 0.09728989, 0.097374409, 0.097458951, 0.097543493, 0.097628064, 0.097712636, 0.09779723, 0.097881846, 0.097966462, 0.098051108, 0.098135762, 0.09822043, 0.098305121, 0.098389819, 0.098474525, 0.098559268, 0.098644018, 0.098728769, 0.098813571, 0.098898359, 0.098983169, 0.099068001, 0.099152833, 0.099237703, 0.099322543, 0.099407434, 0.099492341, 0.099577256, 0.099662185, 0.099747114, 0.099832088, 0.099917069, 0.10000205, 0.10008706, 0.10017209, 0.10025713, 0.10034217, 0.10042723, 0.10051233, 0.10059743, 0.10068253, 0.10076766, 0.10085314, 0.10093891, 0.10102466, 0.10111041, 0.10119612, 0.10128179, 0.10136746, 0.1014531, 0.10153872, 0.10162431, 0.10170988, 0.10179544, 0.10188096, 0.10196647, 0.10205194, 0.10213742, 0.10222284, 0.10230825, 0.10239364, 0.102479, 0.10256436, 0.10264969, 0.10273498, 0.10282024, 0.1029055, 0.10299074, 0.10307596, 0.10316114, 0.1032463, 0.10333143, 0.10341654, 0.10350163, 0.1035867, 0.10367175, 0.10375679, 0.10384177, 0.10392676, 0.10401171, 0.10409665, 0.10418155, 0.10426645, 0.1043513, 0.10443614, 0.10452097, 0.10460576, 0.10469053, 0.10477529, 0.10486002, 0.10494471, 0.10502939, 0.10511405, 0.10519868, 0.1052833, 0.10536789, 0.10545246, 0.10553702, 0.10562152, 0.10570601, 0.1057905, 0.10587495, 0.10595938, 0.10604378, 0.10612816, 0.10621254, 0.10629687, 0.10638119, 0.10646547, 0.10654975, 0.10663401, 0.10671822, 0.10680241, 0.10688659, 0.10697076, 0.10705491, 0.10713901, 0.10722309, 0.10730716, 0.10739121, 0.10747522, 0.10755922, 0.10764318, 0.10772713, 0.10781106, 0.10789496, 0.10797884, 0.1080627, 0.10814654, 0.10823035, 0.10831414, 0.10839792, 0.10848165, 0.10856538, 0.10864908, 0.10873275, 0.10881641, 0.10890004, 0.10898364, 0.10906723, 0.10915079, 0.10923433, 0.10931784, 0.10940134, 0.1094848, 0.10956825, 0.10965168, 0.10973508, 0.10981844, 0.10990182, 0.10998514, 0.11006846, 0.11015173, 0.11023501, 0.11031825, 0.11040146, 0.11048466, 0.11056783, 0.11065099, 0.11073411, 0.11081722, 0.1109003, 0.11098336, 0.11106639, 0.11114942, 0.11123239, 0.11131537, 0.11139832, 0.11148125, 0.11156414, 0.11164701, 0.11172986, 0.11181269, 0.1118955, 0.11197829, 0.11206105, 0.11214378, 0.1122265, 0.11230919, 0.11239187, 0.11247451, 0.11255714, 0.11263973, 0.11272232, 0.11280487, 0.11288741, 0.11296992, 0.11305239, 0.11313486, 0.11321732, 0.11329973, 0.11338213, 0.1134645, 0.11354684, 0.11362917, 0.11371148, 0.11379377, 0.11387603, 0.11395825, 0.11404046, 0.11412266, 0.11420484, 0.11428697, 0.11436909, 0.11445118, 0.11453327, 0.11461532, 0.11469734, 0.11477935, 0.11486133, 0.11494331, 0.11502525, 0.11510718, 0.11518906, 0.11527092, 0.11535278, 0.1154346, 0.11551641, 0.11559817, 0.11567993, 0.11576167, 0.11584338, 0.11592507, 0.11600675, 0.11608838, 0.11617, 0.11625159, 0.11633316, 0.11641471, 0.11649625, 0.11657775, 0.11665923, 0.1167407, 0.11682212, 0.11690354, 0.11698493, 0.11706629, 0.11714764, 0.11722896, 0.11731026, 0.11739155, 0.11747278, 0.11755403, 0.11763523, 0.11771642, 0.11779758, 0.11787872, 0.11795982, 0.11804093, 0.11812199, 0.11820304, 0.11828406, 0.11836507, 0.11844604, 0.118527, 0.11860794, 0.11868884, 0.11876973, 0.1188506, 0.11893145, 0.11901227, 0.11909306, 0.11917384, 0.11925459, 0.11933532, 0.11941602, 0.1194967, 0.11957736, 0.11965799, 0.11973861, 0.1198192, 0.11989976, 0.11998032, 0.12006085, 0.12014134, 0.12022182, 0.12030227, 0.12038269, 0.1204631, 0.12054349, 0.12062386, 0.12070418, 0.12078451, 0.12086479, 0.12094507, 0.12102532, 0.12110554, 0.12118574, 0.12126592, 0.12134608, 0.12142622, 0.12150633, 0.1215864, 0.12166648, 0.12174651, 0.12182654, 0.12190653, 0.1219865, 0.12206645, 0.12214638, 0.12222628, 0.12230617, 0.12238603, 0.12246586, 0.12254567, 0.12262548, 0.12270524, 0.122785, 0.12286471, 0.12294441, 0.12302409, 0.12310375, 0.12318338, 0.12326298, 0.12334257, 0.12342214, 0.12350167, 0.12358119, 0.12366068, 0.12374015, 0.1238196, 0.12389902, 0.12397843, 0.12405781, 0.12413717, 0.1242165, 0.1242958, 0.1243751, 0.12445436, 0.12453361, 0.12461282, 0.12469201, 0.12477119, 0.12485033, 0.12492948, 0.12500857, 0.12508765, 0.12516671, 0.12524575, 0.12532476, 0.12540375, 0.12548272, 0.12556167, 0.12564059, 0.12571949, 0.12579836, 0.12587722, 0.12595604, 0.12603486, 0.12611364, 0.12619241, 0.12627114, 0.12634985, 0.12642856, 0.12650725, 0.12658589, 0.12666452, 0.12674312, 0.12682168, 0.12690026, 0.12697877, 0.1270573, 0.12713577, 0.12721425, 0.12729268, 0.1273711, 0.12744951, 0.12752788, 0.12760623, 0.12768456, 0.12776287, 0.12784113, 0.12791941, 0.12799765, 0.12807585, 0.12815405, 0.12823221, 0.12831035, 0.12838846, 0.12846658, 0.12854466, 0.12862271, 0.12870073, 0.12877876, 0.12885673, 0.1289347, 0.12901264, 0.12909055, 0.12916845, 0.12924632, 0.12932417, 0.129402, 0.1294798, 0.12955758, 0.12963532, 0.12971307, 0.12979077, 0.12986846, 0.12994611, 0.13002376, 0.1301014, 0.13017899, 0.13025656, 0.13033412, 0.13041165, 0.13048914, 0.13056664, 0.1306441, 0.13072155, 0.13079894, 0.13087633, 0.13095371, 0.13103105, 0.13110839, 0.13118568, 0.13126296, 0.13134021, 0.13141744, 0.13149464, 0.13157183, 0.13164899, 0.13172613, 0.13180326, 0.13188034, 0.13195741, 0.13203445, 0.13211147, 0.13218848, 0.13226546, 0.13234243, 0.13241935, 0.13249627, 0.13257316, 0.13265003, 0.13272686, 0.13280368, 0.13288048, 0.13295725, 0.13303402, 0.13311073, 0.13318744, 0.13326412, 0.13334079, 0.13341743, 0.13349403, 0.13357063, 0.13364719, 0.13372375, 0.13380027, 0.13387677, 0.13395324, 0.1340297, 0.13410614, 0.13418254, 0.13425894, 0.13433529, 0.13441163, 0.13448796, 0.13456427, 0.13464051, 0.13471678, 0.13479298, 0.13486919, 0.13494538, 0.13502152, 0.13509767, 0.13517378, 0.13524987, 0.13532592, 0.13540198, 0.13547799, 0.13555399, 0.13562997, 0.1357059, 0.13578185, 0.13585775, 0.13593364, 0.1360095, 0.13608533, 0.13616113, 0.13623695, 0.13631271, 0.13638845, 0.13646418, 0.13653988, 0.13661556, 0.13669121, 0.13676684, 0.13684244, 0.13691802, 0.13699359, 0.13706914, 0.13714464, 0.13722014, 0.13729562, 0.13737106, 0.13744648, 0.13752189, 0.13759728, 0.13767265, 0.13774797, 0.13782328, 0.13789856, 0.13797385, 0.1380491, 0.1381243, 0.13819951, 0.13827467, 0.13834983, 0.13842495, 0.13850006, 0.13857514, 0.13865021, 0.13872524, 0.13880026, 0.13887525, 0.13895021, 0.13902515, 0.13910007, 0.13917498, 0.13924986, 0.13932472, 0.13939954, 0.13947435, 0.13954914, 0.13962391, 0.13969865, 0.13977337, 0.13984805, 0.13992272, 0.13999738, 0.140072, 0.14014661, 0.14022119, 0.14029574, 0.14037026, 0.1404448, 0.14051928, 0.14059374, 0.14066818, 0.1407426, 0.140817, 0.1408906, 0.14096335, 0.14103602, 0.14110866, 0.14118123, 0.14125375, 0.14132622, 0.14139862, 0.14147095, 0.14154324, 0.14161548, 0.14168763, 0.14175974, 0.1418318, 0.1419038, 0.14197575, 0.14204763, 0.14211945, 0.14219122, 0.14226294, 0.1423346, 0.1424062, 0.14247772, 0.14254922, 0.14262064, 0.142692, 0.14276332, 0.14283457, 0.14290577, 0.14297689, 0.14304799, 0.14311901, 0.14318997, 0.14326088, 0.14333174, 0.14340255, 0.14347327, 0.14354394, 0.14361458, 0.14368513, 0.14375566, 0.14382611, 0.14389651, 0.14396684, 0.14403711, 0.14410733, 0.14417751, 0.14424761, 0.14431767, 0.14438766, 0.14445759, 0.14452748, 0.14459729, 0.14466706, 0.14473677, 0.14480641, 0.14487603, 0.14494556, 0.14501503, 0.14508446, 0.14515382, 0.14522313, 0.14529237, 0.14536157, 0.1454307, 0.14549978, 0.14556879, 0.14563777, 0.14570665, 0.14577551, 0.1458443, 0.14591303, 0.14598171, 0.14605033, 0.14611889, 0.14618739, 0.14625585, 0.14632423, 0.14639257, 0.14646085, 0.14652908, 0.14659722, 0.14666532, 0.14673337, 0.14680137, 0.1468693, 0.14693718, 0.14700499, 0.14707275, 0.14714044, 0.14720809, 0.14727569, 0.14734323, 0.14741069, 0.1474781, 0.14754546, 0.14761278, 0.14768001, 0.14774719, 0.14781433, 0.1478814, 0.14794843, 0.14801538, 0.14808229, 0.14814913, 0.14821592, 0.14828265, 0.14834933, 0.14841594, 0.1484825, 0.14854899, 0.14861543, 0.14868182, 0.14874814, 0.14881442, 0.14888063, 0.14894679, 0.14901289, 0.14907894, 0.14914492, 0.14921084, 0.14927672, 0.14934252, 0.1494083, 0.14947398, 0.14953962, 0.14960521, 0.14967074, 0.1497362, 0.14980161, 0.14986698, 0.14993227, 0.14999752, 0.1500627, 0.15012783, 0.15019289, 0.15025789, 0.15032284, 0.15038775, 0.15045258, 0.15051736, 0.15058209, 0.15064676, 0.15071136, 0.15077592, 0.15084042, 0.15090486, 0.15096924, 0.15103357, 0.15109783, 0.15116204, 0.15122619, 0.1512903, 0.15135433, 0.15141831, 0.15148224, 0.15154609, 0.15160991, 0.15167366, 0.15173735, 0.15180099, 0.15186459, 0.1519281, 0.15199156, 0.15205497, 0.15211833, 0.15218161, 0.15224485, 0.15230803, 0.15237115, 0.1524342, 0.15249723, 0.15256017, 0.15262304, 0.1526859, 0.15274867, 0.15281138, 0.15287405, 0.15293665, 0.15299921, 0.1530617, 0.15312414, 0.1531865, 0.15324883, 0.15331109, 0.1533733, 0.15343545, 0.15349755, 0.15355957, 0.15362155, 0.15368347, 0.15374532, 0.15380713, 0.15386887, 0.15393057, 0.15399221, 0.15405378, 0.15411529, 0.15417676, 0.15423815, 0.1542995, 0.15436079, 0.15442201, 0.1544832, 0.15454432, 0.15460539, 0.15466638, 0.15472731, 0.15478821, 0.15484904, 0.15490982, 0.15497054, 0.15503119, 0.15509179, 0.15515235, 0.15521283, 0.15527326, 0.15533362, 0.15539394, 0.1554542, 0.15551439, 0.15557453, 0.15563463, 0.15569466, 0.15575463, 0.15581454, 0.1558744, 0.1559342, 0.15599394, 0.15605362, 0.15611325, 0.15617283, 0.15623234, 0.1562918, 0.15635119, 0.15641053, 0.15646982, 0.15652905, 0.15658821, 0.15664732, 0.15670638, 0.15676539, 0.15682432, 0.1568832, 0.15694204, 0.1570008, 0.15705951, 0.15711817, 0.15717676, 0.15723529, 0.15729378, 0.15735221, 0.15741059, 0.15746889, 0.15752715, 0.15758534, 0.15764348, 0.15770157, 0.15775959, 0.15781756, 0.15787546, 0.15793332, 0.15799111, 0.15804885, 0.15810654, 0.15816416, 0.15822172, 0.15827923, 0.15833668, 0.15839407, 0.15845141, 0.15850869, 0.15856592, 0.15862308, 0.15868019, 0.15873724, 0.15879424, 0.15885116, 0.15890805, 0.15896487, 0.15902163, 0.15907834, 0.159135, 0.15919158, 0.15924813, 0.15930459, 0.15936102, 0.15941739, 0.1594737, 0.15952994, 0.15958612, 0.15964228, 0.15969834, 0.15975437, 0.15981032, 0.15986623, 0.15992208, 0.15997787, 0.1600336, 0.16008928, 0.1601449, 0.16020046, 0.16025595, 0.16031142, 0.1603668, 0.16042213, 0.1604774, 0.16053264, 0.16058779, 0.16064289, 0.16069794, 0.16075292, 0.16080786, 0.16086273, 0.16091755, 0.16097231, 0.16102701, 0.16108167, 0.16113625, 0.16119078, 0.16124524, 0.16129968, 0.16135402, 0.16140833, 0.16146258, 0.16151676, 0.16157089, 0.16162497, 0.16167898, 0.16173294, 0.16178684, 0.16184068, 0.16189449, 0.1619482, 0.16200188, 0.16205549, 0.16210905, 0.16216254, 0.16221598, 0.16226937, 0.1623227, 0.16237597, 0.16242918, 0.16248235, 0.16253543, 0.16258849, 0.16264145, 0.16269439, 0.16274726, 0.16280007, 0.16285282, 0.16290553, 0.16295816, 0.16301076, 0.16306329, 0.16311575, 0.16316816, 0.16322051, 0.16327283, 0.16332504, 0.16337724, 0.16342936, 0.16348143, 0.16353345, 0.16358541, 0.1636373, 0.16368914, 0.16374092, 0.16379263, 0.1638443, 0.16389591, 0.16394745, 0.16399896, 0.1640504, 0.16410178, 0.1641531, 0.16420437, 0.16425557, 0.16430673, 0.16435783, 0.16440886, 0.16445985, 0.16451077, 0.16456164, 0.16461244, 0.1646632, 0.16471389, 0.16476452, 0.16481511, 0.16486563, 0.1649161, 0.16496651, 0.16501684, 0.16506715, 0.16511738, 0.16516756, 0.16521768, 0.16526774, 0.16531776, 0.16536771, 0.16541758, 0.16546743, 0.16551721, 0.16556694, 0.1656166, 0.16566619, 0.16571574, 0.16576524, 0.16581465, 0.16586404, 0.16591336, 0.16596261, 0.16601183, 0.16606097, 0.16611007, 0.16615909, 0.16620807, 0.16625699, 0.16630585, 0.16635466, 0.1664034, 0.16645209, 0.16650072, 0.16654931, 0.16659781, 0.16664629, 0.16669467, 0.16674304, 0.16679132, 0.16683954, 0.16688772, 0.16693585, 0.1669839, 0.1670319, 0.16707985, 0.16712773, 0.16717556, 0.16722335, 0.16727105, 0.16731872, 0.16736631, 0.16741385, 0.16746134, 0.16750877, 0.16755614, 0.16760345, 0.1676507, 0.16769791, 0.16774505, 0.16779214, 0.16783917, 0.16788615, 0.16793306, 0.16797991, 0.16802672, 0.16807346, 0.16812015, 0.16816677, 0.16821335, 0.16825984, 0.16830631, 0.16835271, 0.16839904, 0.16844533, 0.16849156, 0.16853774, 0.16858384, 0.16862988, 0.16867588, 0.16872184, 0.16876771, 0.16881354, 0.16885932, 0.16890502, 0.16895068, 0.16899627, 0.16904181, 0.16908731, 0.16913271, 0.16917808, 0.16922341, 0.16926865, 0.16931385, 0.16935898, 0.16940407, 0.16944909, 0.16949405, 0.16953897, 0.16958381, 0.16962861, 0.16967335, 0.16971804, 0.16976266, 0.16980721, 0.16985174, 0.16989619, 0.16994058, 0.16998491, 0.17002919, 0.17007342, 0.17011632, 0.17015794, 0.17019951, 0.17024098, 0.17028238, 0.17032373, 0.17036498, 0.17040615, 0.17044725, 0.17048828, 0.17052925, 0.17057011, 0.1706109, 0.17065161, 0.17069229, 0.17073286, 0.17077334, 0.17081377, 0.17085414, 0.1708944, 0.17093459, 0.17097472, 0.17101476, 0.17105472, 0.17109463, 0.17113444, 0.17117417, 0.17121384, 0.17125344, 0.17129295, 0.1713324, 0.17137176, 0.17141105, 0.17145026, 0.1714894, 0.17152846, 0.17156744, 0.17160638, 0.17164519, 0.17168395, 0.17172265, 0.17176126, 0.17179978, 0.17183825, 0.17187661, 0.17191494, 0.17195316, 0.1719913, 0.17202941, 0.17206742, 0.17210534, 0.17214319, 0.17218098, 0.17221867, 0.17225629, 0.17229384, 0.17233132, 0.17236872, 0.17240606, 0.1724433, 0.17248048, 0.17251757, 0.1725546, 0.17259154, 0.17262842, 0.17266521, 0.17270193, 0.17273857, 0.17277513, 0.17281163, 0.17284806, 0.1728844, 0.17292066, 0.17295685, 0.17299297, 0.17302902, 0.17306498, 0.17310087, 0.17313667, 0.17317241, 0.17320807, 0.17324366, 0.17327918, 0.1733146, 0.17334996, 0.17338526, 0.17342047, 0.1734556, 0.17349064, 0.17352563, 0.17356054, 0.17359538, 0.17363013, 0.17366481, 0.17369942, 0.17373395, 0.1737684, 0.17380278, 0.17383707, 0.17387131, 0.17390546, 0.17393953, 0.17397355, 0.17400746, 0.1740413, 0.17407508, 0.17410877, 0.17414241, 0.17417595, 0.17420942, 0.17424282, 0.17427614, 0.17430937, 0.17434256, 0.17437564, 0.17440867, 0.17444161, 0.17447448, 0.17450726, 0.17453998, 0.17457262, 0.17460519, 0.17463766, 0.17467009, 0.17470244, 0.17473468, 0.17476687, 0.174799, 0.17483102, 0.17486298, 0.17489485, 0.17492668, 0.17495841, 0.17499006, 0.17502166, 0.17505315, 0.17508459, 0.17511594, 0.17514721, 0.17517842, 0.17520955, 0.17524062, 0.17527159, 0.17530249, 0.17533331, 0.17536406, 0.17539474, 0.17542535, 0.17545585, 0.17548631, 0.17551669, 0.17554699, 0.17557721, 0.17560735, 0.17563744, 0.17566743, 0.17569734, 0.17572719, 0.17575696, 0.17578664, 0.17581625, 0.1758458, 0.17587528, 0.17590466, 0.17593399, 0.17596322, 0.17599238, 0.17602147, 0.17605048, 0.17607944, 0.17610829, 0.17613707, 0.17616577, 0.17619441, 0.17622299, 0.17625146, 0.17627989, 0.1763082, 0.17633645, 0.17636465, 0.17639275, 0.17642079, 0.17644876, 0.17647663, 0.17650442, 0.17653218, 0.17655979, 0.17658737, 0.1766149, 0.17664233, 0.17666966, 0.17669694, 0.17672415, 0.17675127, 0.17677833, 0.1768053, 0.1768322, 0.17685904, 0.17688577, 0.17691243, 0.17693904, 0.17696555, 0.17699197, 0.17701836, 0.17704466, 0.17707087, 0.17709702, 0.17712307, 0.17714907, 0.177175, 0.17720082, 0.17722659, 0.17725228, 0.17727789, 0.17730345, 0.17732888, 0.17735428, 0.17737958, 0.17740484, 0.17742999, 0.17745505, 0.17748007, 0.177505, 0.17752987, 0.17755465, 0.17757936, 0.17760399, 0.17762853, 0.17765304, 0.17767742, 0.17770177, 0.17772603, 0.17775019, 0.1777743, 0.1777983, 0.17782228, 0.17784615, 0.17786995, 0.17789367, 0.17791733, 0.17794088, 0.17796439, 0.17798783, 0.17801116, 0.17803442, 0.17805764, 0.17808074, 0.1781038, 0.17812675, 0.17814966, 0.17817247, 0.17819521, 0.17821789, 0.17824045, 0.17826298, 0.17828543, 0.1783078, 0.17833009, 0.17835228, 0.17837444, 0.17839649, 0.17841849, 0.17844039, 0.17846224, 0.17848398, 0.17850566, 0.17852728, 0.1785488, 0.17857024, 0.17859165, 0.17861296, 0.1786342, 0.17865534, 0.17867643, 0.17869744, 0.17871837, 0.17873922, 0.17875999, 0.17878067, 0.17880133, 0.17882186, 0.17884234, 0.17886275, 0.17888306, 0.1789033, 0.17892349, 0.1789436, 0.17896362, 0.17898354, 0.17900343, 0.17902324, 0.17904295, 0.17906259, 0.17908214, 0.17910165, 0.17912108, 0.17914042, 0.17915967, 0.17917886, 0.17919797, 0.17921703, 0.17923598, 0.17925486, 0.17927369, 0.17929241, 0.17931107, 0.17932968, 0.17934817, 0.17936662, 0.17938499, 0.17940328, 0.17942148, 0.1794396, 0.17945766, 0.17947564, 0.17949355, 0.17951137, 0.17952913, 0.17954682, 0.17956442, 0.17958197, 0.17959942, 0.17961678, 0.17963408, 0.17965131, 0.17966846, 0.17968555, 0.17970254, 0.17971945, 0.17973632, 0.17975309, 0.17976978, 0.17978638, 0.17980295, 0.17981942, 0.17983581, 0.17985213, 0.17986837, 0.17988454, 0.17990062, 0.17991664, 0.17993259, 0.17994845, 0.17996423, 0.17997997, 0.1799956, 0.18001115, 0.18002667, 0.18004209, 0.18005741, 0.18007267, 0.18008786, 0.18010296, 0.18011799, 0.18013296, 0.18014784, 0.18016267, 0.18017741, 0.18019204, 0.18020663, 0.18022113, 0.18023556, 0.18024993, 0.1802642, 0.18027839, 0.18029252, 0.1803066, 0.18032056, 0.18033446, 0.18034831, 0.18036202, 0.18037573, 0.18038931, 0.18040285, 0.1804163, 0.18042967, 0.18044296, 0.18045621, 0.18046932, 0.18048239, 0.18049541, 0.18050832, 0.18052116, 0.18053395, 0.18054664, 0.18055925, 0.18057178, 0.18058427, 0.18059663, 0.18060894, 0.18062118, 0.18063335, 0.18064545, 0.18065746, 0.18066941, 0.18068124, 0.18069305, 0.18070474, 0.1807164, 0.18072796, 0.18073943, 0.18075085, 0.18076219, 0.18077342, 0.18078461, 0.18079573, 0.18080674, 0.18081769, 0.18082859, 0.18083939, 0.18085012, 0.18086077, 0.18087135, 0.18088186, 0.18089229, 0.18090263, 0.1809129, 0.1809231, 0.18093322, 0.1809433, 0.18095325, 0.18096313, 0.18097298, 0.18098272, 0.18099239, 0.18100198, 0.1810115, 0.18102095, 0.18103032, 0.18103962, 0.18104883, 0.18105796, 0.18106702, 0.18107602, 0.18108493, 0.18109377, 0.18110253, 0.18111122, 0.18111983, 0.18112837, 0.18113682, 0.18114522, 0.18115355, 0.18116178, 0.18116991, 0.181178, 0.18118601, 0.18119396, 0.18120182, 0.18120959, 0.1812173, 0.18122493, 0.1812325, 0.18123998, 0.18124735, 0.18125471, 0.18126194, 0.18126914, 0.18127625, 0.18128327, 0.18129019, 0.18129709, 0.18130389, 0.18131061, 0.18131725, 0.18132384, 0.18133031, 0.18133675, 0.18134309, 0.18134935, 0.18135554, 0.18136168, 0.18136773, 0.1813737, 0.18137959, 0.18138538, 0.18139115, 0.18139683, 0.1814024, 0.1814079, 0.18141335, 0.1814187, 0.18142401, 0.18142922, 0.18143436, 0.18143941, 0.18144439, 0.18144931, 0.18145414, 0.18145892, 0.18146358, 0.18146822, 0.18147273, 0.18147719, 0.18148158, 0.18148588, 0.18149012, 0.18149424, 0.18149836, 0.18150236, 0.18150529, 0.18150727, 0.18150917, 0.18151101, 0.18151274, 0.1815144, 0.18151598, 0.1815175, 0.18151894, 0.18152031, 0.18152161, 0.18152282, 0.18152395, 0.18152499, 0.18152599, 0.18152687, 0.1815277, 0.18152846, 0.18152912, 0.18152973, 0.18153025, 0.1815307, 0.18153107, 0.18153134, 0.18153158, 0.1815317, 0.18153177, 0.18153174, 0.18153167, 0.18153149, 0.18153124, 0.18153091, 0.18153052, 0.18153004, 0.18152948, 0.18152887, 0.18152817, 0.18152738, 0.18152653, 0.1815256, 0.1815246, 0.1815235, 0.18152232, 0.1815211, 0.18151976, 0.18151839, 0.18151693, 0.1815154, 0.18151376, 0.18151204, 0.18151028, 0.18150844, 0.1815065, 0.18150447, 0.1815024, 0.18150026, 0.18149802, 0.18149571, 0.18149331, 0.18149085, 0.18148831, 0.18148571, 0.18148302, 0.18148024, 0.1814774, 0.18147448, 0.18147147, 0.1814684, 0.18146525, 0.18146203, 0.18145871, 0.18145533, 0.18145189, 0.18144833, 0.18144473, 0.18144105, 0.18143727, 0.18143344, 0.18142954, 0.18142554, 0.18142146, 0.1814173, 0.1814131, 0.18140881, 0.18140443, 0.18139997, 0.18139544, 0.18139081, 0.18138614, 0.18138139, 0.18137656, 0.18137164, 0.18136665, 0.18136159, 0.18135646, 0.18135124, 0.18134595, 0.18134058, 0.18133512, 0.18132959, 0.18132401, 0.18131833, 0.18131256, 0.18130676, 0.18130083, 0.18129486, 0.18128881, 0.18128267, 0.18127646, 0.18127014, 0.18126379, 0.18125737, 0.18125084, 0.18124424, 0.18123756, 0.18123083, 0.181224, 0.18121709, 0.18121013, 0.18120307, 0.18119593, 0.18118875, 0.18118145, 0.1811741, 0.18116665, 0.18115914, 0.18115154, 0.18114388, 0.18113615, 0.18112832, 0.18112043, 0.18111245, 0.18110441, 0.18109629, 0.18108809, 0.1810798, 0.18107145, 0.18106303, 0.18105452, 0.18104592, 0.18103726, 0.18102856, 0.18101972, 0.18101083, 0.18100186, 0.18099281, 0.18098371, 0.18097453, 0.18096523, 0.1809559, 0.18094648, 0.18093698, 0.1809274, 0.18091772, 0.18090801, 0.18089817, 0.18088831, 0.18087836, 0.18086833, 0.18085821, 0.18084802, 0.18083774, 0.18082741, 0.18081699, 0.18080647, 0.18079592, 0.18078528, 0.18077454, 0.18076374, 0.18075287, 0.18074189, 0.18073088, 0.18071976, 0.1807086, 0.18069732, 0.18068598, 0.18067455, 0.18066308, 0.18065152, 0.18063988, 0.18062814, 0.18061635, 0.18060449, 0.18059255, 0.18058051, 0.1805684, 0.18055622, 0.18054397, 0.18053164, 0.18051922, 0.18050674, 0.18049417, 0.18048155, 0.18046881, 0.18045603, 0.18044317, 0.18043022, 0.18041721, 0.18040411, 0.18039095, 0.18037766, 0.18036437, 0.18035096, 0.18033747, 0.18032393, 0.18031028, 0.18029658, 0.18028279, 0.18026893, 0.18025498, 0.18024097, 0.18022689, 0.18021272, 0.18019846, 0.18018417, 0.18016975, 0.18015529, 0.18014072, 0.18012612, 0.18011139, 0.18009661, 0.18008175, 0.18006682, 0.18005182, 0.18003674, 0.18002158, 0.18000634, 0.17999102, 0.17997563, 0.17996016, 0.1799446, 0.179929, 0.17991328, 0.17989752, 0.17988166, 0.17986573, 0.17984974, 0.17983365, 0.1798175, 0.17980127, 0.17978495, 0.17976856, 0.17975213, 0.17973556, 0.17971894, 0.17970225, 0.17968547, 0.17966864, 0.17965172, 0.17963473, 0.17961766, 0.17960051, 0.17958327, 0.17956595, 0.17954858, 0.17953113, 0.1795136, 0.17949599, 0.17947829, 0.17946054, 0.17944269, 0.17942476, 0.17940676, 0.17938873, 0.17937057, 0.17935234, 0.17933403, 0.17931566, 0.17929719, 0.1792787, 0.17926008, 0.1792414, 0.17922266, 0.17920382, 0.1791849, 0.17916591, 0.17914684, 0.17912772, 0.17910849, 0.17908919, 0.17906982, 0.17905037, 0.17903085, 0.17901126, 0.17899157, 0.17897181, 0.17895199, 0.17893209, 0.17891212, 0.17889206, 0.17887191, 0.17885169, 0.17883143, 0.17881106, 0.1787906, 0.17877008, 0.1787495, 0.17872882, 0.17870806, 0.17868726, 0.17866635, 0.17864539, 0.17862432, 0.1786032, 0.178582, 0.1785607, 0.17853935, 0.17851791, 0.17849642, 0.1784748, 0.17845315, 0.17843142, 0.17840959, 0.17838769, 0.17836572, 0.17834367, 0.17832156, 0.17829935, 0.17827708, 0.17825469, 0.1782323, 0.1782098, 0.17818719, 0.17816454, 0.17814182, 0.17811897, 0.17809612, 0.17807314, 0.17805009, 0.17802696, 0.17800377, 0.17798051, 0.17795718, 0.17793374, 0.17791022, 0.17788666, 0.17786299, 0.17783928, 0.17781547, 0.17779158, 0.17776762, 0.17774357, 0.17771947, 0.17769527, 0.17767103, 0.17764667, 0.17762224, 0.17759775, 0.1775732, 0.17754854, 0.17752382, 0.17749901, 0.17747414, 0.17744917, 0.17742415, 0.17739905, 0.17737387, 0.1773486, 0.17732324, 0.17729785, 0.17727235, 0.17724678, 0.17722116, 0.17719543, 0.17716964, 0.17714375, 0.17711781, 0.17709179, 0.17706569, 0.1770395, 0.17701325, 0.17698693, 0.17696053, 0.17693402, 0.17690746, 0.17688081, 0.1768541, 0.17682733, 0.17680044, 0.1767735, 0.17674647, 0.1767194, 0.17669222, 0.17666495, 0.17663762, 0.17661025, 0.17658275, 0.17655522, 0.17652757, 0.17649984, 0.1764721, 0.17644422, 0.17641626, 0.17638828, 0.17636018, 0.176332, 0.17630374, 0.17627543, 0.17624705, 0.17621857, 0.17619002, 0.17616139, 0.17613269, 0.1761039, 0.17607504, 0.17604612, 0.17601711, 0.17598803, 0.17595887, 0.17592962, 0.17590031, 0.17587091, 0.17584145, 0.1758119, 0.17578228, 0.17575258, 0.17572281, 0.17569296, 0.17566304, 0.17563303, 0.17560294, 0.17557278, 0.17554255, 0.17551224, 0.17548186, 0.1754514, 0.17542087, 0.17539024, 0.17535955, 0.17532878, 0.17529793, 0.17526701, 0.17523602, 0.17520495, 0.17517379, 0.17514257, 0.17511125, 0.17507988, 0.17504843, 0.17501688, 0.17498529, 0.17495358, 0.17492183, 0.17489, 0.17485808, 0.17482607, 0.174794, 0.17476186, 0.17472963, 0.17469734, 0.17466497, 0.17463252, 0.17459998, 0.17456739, 0.17453469, 0.17450193, 0.17446911, 0.17443618, 0.17440321, 0.17437014, 0.174337, 0.17430378, 0.17427048, 0.17423713, 0.17420368, 0.17417015, 0.17413658, 0.17410287, 0.17406914, 0.1740353, 0.1740014, 0.17396742, 0.17393336, 0.17389923, 0.17386501, 0.17383072, 0.17379636, 0.17376192, 0.17372739, 0.17369281, 0.17365813, 0.17362338, 0.17358856, 0.17355368, 0.17351869, 0.17348364, 0.17344852, 0.17341331, 0.17337802, 0.17334266, 0.17330723, 0.17327172, 0.17323613, 0.17320046, 0.17316471, 0.17312889, 0.17309301, 0.17305703, 0.17302099, 0.17298487, 0.17294753, 0.17290902, 0.17287043, 0.17283179, 0.17279309, 0.17275433, 0.17271551, 0.17267664, 0.1726377, 0.17259869, 0.17255963, 0.1725205, 0.17248133, 0.17244208, 0.17240275, 0.1723634, 0.17232397, 0.17228448, 0.17224495, 0.17220531, 0.17216565, 0.17212592, 0.17208613, 0.17204627, 0.17200635, 0.17196637, 0.17192635, 0.17188624, 0.17184609, 0.17180587, 0.17176557, 0.17172524, 0.17168485, 0.17164437, 0.17160384, 0.17156327, 0.17152262, 0.17148191, 0.17144115, 0.17140031, 0.17135942, 0.17131847, 0.17127745, 0.17123638, 0.17119525, 0.17115404, 0.17111281, 0.17107148, 0.1710301, 0.17098866, 0.17094716, 0.17090562, 0.17086397, 0.17082231, 0.17078055, 0.17073876, 0.17069688, 0.17065497, 0.17061298, 0.17057092, 0.17052883, 0.17048664, 0.17044443, 0.17040212, 0.17035978, 0.17031737, 0.17027488, 0.17023236, 0.17018975, 0.17014709, 0.17010438, 0.1700616, 0.17001876, 0.16997586, 0.16993289, 0.16988988, 0.16984679, 0.16980365, 0.16976044, 0.16971718, 0.16967385, 0.16963047, 0.16958702, 0.16954352, 0.16949992, 0.1694563, 0.16941261, 0.16936886, 0.16932505, 0.16928117, 0.16923723, 0.16919322, 0.16914918, 0.16910505, 0.16906086, 0.16901663, 0.16897234, 0.16892798, 0.16888353, 0.16883907, 0.16879451, 0.1687499, 0.16870525, 0.16866051, 0.16861573, 0.16857088, 0.16852596, 0.16848099, 0.16843596, 0.16839087, 0.1683457, 0.16830049, 0.16825522, 0.16820988, 0.16816448, 0.16811901, 0.16807351, 0.16802794, 0.16798227, 0.16793658, 0.1678908, 0.167845, 0.1677991, 0.16775315, 0.16770715, 0.16766109, 0.16761495, 0.16756876, 0.1675225, 0.16747619, 0.16742982, 0.16738339, 0.1673369, 0.16729034, 0.16724372, 0.16719705, 0.1671503, 0.1671035, 0.16705665, 0.16700971, 0.16696273, 0.1669157, 0.1668686, 0.16682142, 0.1667742, 0.16672692, 0.16667958, 0.16663216, 0.16658469, 0.16653715, 0.16648957, 0.16644192, 0.1663942, 0.16634643, 0.1662986, 0.16625071, 0.16620272, 0.16615473, 0.16610664, 0.16605851, 0.16601032, 0.16596204, 0.16591372, 0.16586535, 0.16581689, 0.16576838, 0.16571982, 0.16567118, 0.16562249, 0.16557375, 0.16552494, 0.16547607, 0.16542715, 0.16537815, 0.16532908, 0.16527997, 0.16523081, 0.16518158, 0.16513227, 0.16508292, 0.16503349, 0.164984, 0.16493447, 0.16488488, 0.1648352, 0.16478549, 0.1647357, 0.16468586, 0.16463596, 0.16458599, 0.16453595, 0.16448587, 0.16443571, 0.1643855, 0.16433524, 0.1642849, 0.16423452, 0.16418403, 0.16413353, 0.16408294, 0.16403233, 0.16398162, 0.16393086, 0.16388005, 0.16382916, 0.16377822, 0.16372722, 0.16367616, 0.16362503, 0.16357383, 0.1635226, 0.16347128, 0.16341992, 0.16336849, 0.16331699, 0.16326545, 0.16321383, 0.16316217, 0.16311044, 0.16305864, 0.1630068, 0.16295485, 0.16290289, 0.16285084, 0.16279875, 0.16274659, 0.16269435, 0.16264209, 0.16258973, 0.16253734, 0.16248487, 0.16243233, 0.16237976, 0.1623271, 0.16227439, 0.16222163, 0.1621688, 0.1621159, 0.16206296, 0.16200994, 0.16195688, 0.16190372, 0.16185054, 0.16179727, 0.16174395, 0.16169058, 0.16163714, 0.16158365, 0.16153008, 0.16147646, 0.16142277, 0.16136903, 0.16131523, 0.16126135, 0.16120742, 0.16115344, 0.16109939, 0.16104528, 0.1609911, 0.16093688, 0.16088259, 0.16082823, 0.16077381, 0.16071934, 0.1606648, 0.1606102, 0.16055554, 0.16050082, 0.16044605, 0.16039121, 0.16033632, 0.16028135, 0.16022633, 0.16017124, 0.16011609, 0.1600609, 0.16000563, 0.15995029, 0.1598949, 0.15983945, 0.15978394, 0.15972836, 0.15967274, 0.15961705, 0.15956129, 0.15950547, 0.15944961, 0.15939367, 0.15933765, 0.1592816, 0.15922548, 0.15916929, 0.15911306, 0.15905675, 0.15900038, 0.15894397, 0.15888749, 0.15883093, 0.15877433, 0.15871766, 0.15866093, 0.15860413, 0.15854728, 0.15849037, 0.15843341, 0.15837637, 0.15831928, 0.15826212, 0.1582049, 0.15814763, 0.15809028, 0.15803289, 0.15797542, 0.1579179, 0.15786031, 0.15780267, 0.15774496, 0.1576872, 0.15762937, 0.15757149, 0.15751356, 0.15745553, 0.15739746, 0.15733933, 0.15728115, 0.1572229, 0.15716459, 0.15710621, 0.15704776, 0.15698928, 0.15693071, 0.15687209, 0.15681341, 0.15675469, 0.15669587, 0.15663701, 0.15657809, 0.15651911, 0.15646006, 0.15640096, 0.15634179, 0.15628257, 0.15622328, 0.15616395, 0.15610452, 0.15604506, 0.15598552, 0.15592593, 0.15586627, 0.15580656, 0.15574677, 0.15568694, 0.15562706, 0.15556709, 0.15550707, 0.15544699, 0.15538685, 0.15532665, 0.15526639, 0.15520605, 0.15514569, 0.15508522, 0.15502472, 0.15496415, 0.15490353, 0.15484284, 0.15478209, 0.15472129, 0.15466042, 0.15459949, 0.15453847, 0.15447742, 0.15441631, 0.15435514, 0.15429389, 0.15423261, 0.15417123, 0.15410981, 0.15404834, 0.15398678, 0.1539252, 0.15386353, 0.15380181, 0.15374002, 0.15367816, 0.15361626, 0.15355429, 0.15349227, 0.15343016, 0.15336803, 0.15330581, 0.15324354, 0.15318121, 0.15311882, 0.15305635, 0.15299384, 0.15293126, 0.15286863, 0.15280592, 0.15274316, 0.15268034, 0.15261745, 0.15255451, 0.15249151, 0.15242845, 0.15236531, 0.15230213, 0.15223889, 0.15217556, 0.1521122, 0.15204877, 0.15198529, 0.15192173, 0.15185812, 0.15179443, 0.15173072, 0.15166691, 0.15160306, 0.15153913, 0.15147516, 0.15141112, 0.15134701, 0.15128285, 0.15121862, 0.15115435, 0.15109, 0.15102561, 0.15096113, 0.15089661, 0.15083201, 0.15076737, 0.15070266, 0.15063788, 0.15057306, 0.15050817, 0.15044321, 0.1503782, 0.15031311, 0.15024799, 0.15018278, 0.15011752, 0.1500522, 0.14998682, 0.14992139, 0.1498559, 0.14979033, 0.14972469, 0.14965901, 0.14959326, 0.14952746, 0.1494616, 0.14939566, 0.14932969, 0.14926362, 0.14919752, 0.14913134, 0.14906511, 0.14899881, 0.14893246, 0.14886604, 0.14879957, 0.14873303, 0.14866644, 0.14859977, 0.14853305, 0.14846627, 0.14839943, 0.14833254, 0.14826556, 0.14819854, 0.14813145, 0.1480643, 0.14799711, 0.14792983, 0.14786249, 0.14779511, 0.14772767, 0.14766017, 0.14759257, 0.14752494, 0.14745726, 0.1473895, 0.14732167, 0.1472538, 0.14718585, 0.14711785, 0.1470498, 0.14698169, 0.14691348, 0.14684525, 0.14677694, 0.14670858, 0.14664015, 0.14657167, 0.14650311, 0.14643452, 0.14636584, 0.14629711, 0.14622831, 0.14615946, 0.14608954, 0.14601862, 0.14594769, 0.14587675, 0.14580576, 0.14573474, 0.14566369, 0.14559263, 0.14552152, 0.1454504, 0.14537923, 0.14530806, 0.14523683, 0.14516559, 0.14509432, 0.14502302, 0.14495169, 0.14488034, 0.14480895, 0.14473753, 0.14466608, 0.14459459, 0.1445231, 0.14445159, 0.14438002, 0.14430845, 0.14423682, 0.14416517, 0.14409351, 0.14402181, 0.14395009, 0.14387833, 0.14380653, 0.14373472, 0.14366288, 0.14359102, 0.14351912, 0.14344718, 0.14337522, 0.14330325, 0.14323124, 0.14315918, 0.1430871, 0.14301503, 0.14294289, 0.14287074, 0.14279856, 0.14272635, 0.14265411, 0.14258184, 0.14250953, 0.1424372, 0.14236484, 0.14229247, 0.14222005, 0.14214762, 0.14207517, 0.14200266, 0.14193013, 0.14185756, 0.14178498, 0.14171238, 0.14163972, 0.14156707, 0.14149438, 0.14142165, 0.1413489, 0.14127611, 0.1412033, 0.14113046, 0.1410576, 0.1409847, 0.14091177, 0.14083882, 0.14076583, 0.14069283, 0.14061978, 0.14054672, 0.14047363, 0.1404005, 0.14032735, 0.14025417, 0.14018096, 0.14010772, 0.14003445, 0.13996115, 0.13988782, 0.13981448, 0.13974111, 0.1396677, 0.13959426, 0.13952079, 0.13944729, 0.13937376, 0.13930023, 0.13922666, 0.13915303, 0.13907941, 0.13900574, 0.13893203, 0.13885832, 0.13878457, 0.13871078, 0.13863698, 0.13856316, 0.13848929, 0.1384154, 0.13834147, 0.13826752, 0.13819353, 0.13811952, 0.13804549, 0.13797143, 0.13789734, 0.13782322, 0.13774908, 0.1376749, 0.13760069, 0.13752645, 0.13745219, 0.13737789, 0.13730358, 0.13722922, 0.13715485, 0.13708045, 0.137006, 0.13693154, 0.13685706, 0.13678254, 0.13670799, 0.13663341, 0.1365588, 0.13648416, 0.13640951, 0.13633482, 0.13626009, 0.13618536, 0.13611057, 0.13603576, 0.13596094, 0.13588607, 0.13581119, 0.13573627, 0.13566132, 0.13558635, 0.13551134, 0.13543631, 0.13536125, 0.13528615, 0.13521105, 0.1351359, 0.13506073, 0.13498552, 0.13491029, 0.13483503, 0.13475975, 0.13468443, 0.13460909, 0.13453369, 0.13445829, 0.13438287, 0.13430741, 0.13423193, 0.13415641, 0.13408086, 0.13400528, 0.13392968, 0.13385406, 0.13377839, 0.13370271, 0.13362698, 0.13355124, 0.13347547, 0.13339967, 0.13332383, 0.13324799, 0.13317209, 0.13309619, 0.13302024, 0.13294426, 0.13286826, 0.13279223, 0.13271616, 0.13264009, 0.13256398, 0.13248783, 0.13241166, 0.13233545, 0.13225922, 0.13218299, 0.13210669, 0.13203038, 0.13195403, 0.13187765, 0.13180126, 0.13172483, 0.13164838, 0.13157189, 0.13149539, 0.13141884, 0.13134228, 0.13126567, 0.13118905, 0.13111238, 0.1310357, 0.13095899, 0.13088225, 0.13080548, 0.13072868, 0.13065185, 0.13057499, 0.13049811, 0.13042121, 0.13034426, 0.13026729, 0.1301903, 0.13011327, 0.13003621, 0.12995912, 0.12988201, 0.12980488, 0.12972771, 0.1296505, 0.12957329, 0.12949604, 0.12941876, 0.12934144, 0.1292641, 0.12918673, 0.12910932, 0.1290319, 0.12895446, 0.12887697, 0.12879945, 0.12872192, 0.12864436, 0.12856676, 0.12848914, 0.12841149, 0.12833379, 0.1282561, 0.12817836, 0.12810059, 0.12802279, 0.12794496, 0.12786712, 0.12778924, 0.12771133, 0.12763339, 0.12755542, 0.12747742, 0.12739941, 0.12732135, 0.12724328, 0.12716515, 0.12708703, 0.12700886, 0.12693067, 0.12685244, 0.12677419, 0.12669592, 0.12661761, 0.12653926, 0.12646091, 0.12638251, 0.12630409, 0.12622564, 0.12614717, 0.12606865, 0.12599012, 0.12591156, 0.12583296, 0.12575434, 0.12567569, 0.12559702, 0.12551831, 0.12543957, 0.12536082, 0.12528202, 0.12520319, 0.12512435, 0.12504546, 0.12496656, 0.12488762, 0.12480866, 0.12472967, 0.12465065, 0.12457161, 0.12449252, 0.12441342, 0.1243343, 0.12425513, 0.12417594, 0.12409672, 0.12401747, 0.1239382, 0.1238589, 0.12377955, 0.1237002, 0.1236208, 0.12354138, 0.12346193, 0.12338246, 0.12330296, 0.12322341, 0.12314387, 0.12306427, 0.12298466, 0.12290501, 0.12282533, 0.12274562, 0.1226659, 0.12258613, 0.12250634, 0.12242652, 0.12234668, 0.1222668, 0.12218691, 0.12210697, 0.12202701, 0.12194702, 0.12186701, 0.12178696, 0.1217069, 0.12162679, 0.12154665, 0.1214665, 0.1213863, 0.12130609, 0.12122585, 0.12114557, 0.12106526, 0.12098493, 0.12090458, 0.1208242, 0.12074377, 0.12066334, 0.12058286, 0.12050237, 0.12042183, 0.12034127, 0.12026069, 0.12018007, 0.12009943, 0.12001875, 0.11993807, 0.11985733, 0.11977657, 0.11969578, 0.11961497, 0.11953412, 0.11945325, 0.11937235, 0.11929143, 0.11921047, 0.11912949, 0.11904848, 0.11896742, 0.11888636, 0.11880526, 0.11872413, 0.11864297, 0.1185618, 0.11848058, 0.11839934, 0.11831807, 0.11823677, 0.11815543, 0.11807408, 0.1179927, 0.11791128, 0.11782984, 0.11774838, 0.11766688, 0.11758535, 0.1175038, 0.11742222, 0.1173406, 0.11725896, 0.11717729, 0.1170956, 0.11701386, 0.1169321, 0.11685032, 0.11676851, 0.11668667, 0.1166048, 0.11652292, 0.11644098, 0.11635903, 0.11627705, 0.11619504, 0.11611301, 0.11603093, 0.11594884, 0.11586671, 0.11578457, 0.11570238, 0.11562017, 0.11553793, 0.11545566, 0.11537337, 0.11529104, 0.11520869, 0.1151263, 0.1150439, 0.11496145, 0.114879, 0.1147965, 0.11471397, 0.11463142, 0.11454885, 0.11446624, 0.1143836, 0.11430093, 0.11421825, 0.11413553, 0.11405276, 0.11396997, 0.11388718, 0.11380434, 0.11372147, 0.11363858, 0.11355565, 0.1134727, 0.11338972, 0.11330672, 0.11322368, 0.11314061, 0.11305752, 0.1129744, 0.11289126, 0.11280807, 0.11272486, 0.11264164, 0.11255836, 0.11247507, 0.11239175, 0.11230841, 0.11222503, 0.11214162, 0.11205819, 0.11197472, 0.11189122, 0.1118077, 0.11172416, 0.11164057, 0.11155697, 0.11147334, 0.11138967, 0.11130598, 0.11122227, 0.11113852, 0.11105475, 0.11097094, 0.1108871, 0.11080325, 0.11071935, 0.11063544, 0.11055149, 0.11046751, 0.1103835, 0.11029948, 0.11021541, 0.11013132, 0.11004721, 0.10996306, 0.10987888, 0.10979469, 0.10971044, 0.10962617, 0.10954189, 0.10945757, 0.10937323, 0.10928885, 0.10920445, 0.10912002, 0.10903555, 0.10895106, 0.10886656, 0.108782, 0.10869743, 0.10861284, 0.1085282, 0.10844354, 0.10835885, 0.10827413, 0.1081894, 0.10810461, 0.10801981, 0.10793498, 0.10785013, 0.10776524, 0.10768032, 0.10759538, 0.1075104, 0.1074254, 0.10734037, 0.10725532, 0.10717022, 0.10708528, 0.10700053, 0.10691576, 0.10683103, 0.10674631, 0.10666159, 0.10657687, 0.10649219, 0.1064075, 0.10632283, 0.10623816, 0.1061535, 0.10606886, 0.10598423, 0.10589959, 0.10581498, 0.10573038, 0.10564579, 0.1055612, 0.10547662, 0.10539207, 0.10530752, 0.10522298, 0.10513844, 0.10505392, 0.10496941, 0.10488492, 0.10480043, 0.10471595, 0.10463149, 0.10454702, 0.10446258, 0.10437815, 0.10429372, 0.10420931, 0.1041249, 0.1040405, 0.10395612, 0.10387175, 0.10378738, 0.10370303, 0.10361868, 0.10353435, 0.10345003, 0.10336572, 0.10328141, 0.10319712, 0.10311285, 0.10302857, 0.10294431, 0.10286006, 0.10277582, 0.10269161, 0.10260739, 0.10252317, 0.10243897, 0.10235479, 0.10227061, 0.10218645, 0.10210229, 0.10201814, 0.10193402, 0.10184989, 0.10176577, 0.10168167, 0.10159757, 0.10151349, 0.10142943, 0.10134535, 0.10126131, 0.10117726, 0.10109323, 0.10100922, 0.10092521, 0.1008412, 0.10075721, 0.10067324, 0.10058927, 0.10050531, 0.10042136, 0.10033743, 0.1002535, 0.10016959, 0.10008569, 0.1000018, 0.099917896, 0.099834032, 0.099750169, 0.099666305, 0.099582464, 0.09949863, 0.099414811, 0.099330999, 0.099247202, 0.099163406, 0.099079631, 0.098995857, 0.098912083, 0.098828353, 0.098744608, 0.098660879, 0.098577157, 0.098493457, 0.098409757, 0.098326065, 0.098242395, 0.098158732, 0.098075084, 0.097991422, 0.097907789, 0.097824171, 0.097740553, 0.09765695, 0.097573355, 0.097489782, 0.097406194, 0.097322628, 0.097239085, 0.097155541, 0.09707202, 0.096988499, 0.096904978, 0.096821487, 0.096737996, 0.096654519, 0.096571058, 0.096487604, 0.096404143, 0.096320704, 0.096237279, 0.09615387, 0.096070468, 0.095987059, 0.095903687, 0.0958203, 0.095736936, 0.095653586, 0.095570229, 0.095486909, 0.095403589, 0.095320277, 0.095236987, 0.095153697, 0.095070399, 0.094987132, 0.094903871, 0.094820626, 0.094737388, 0.094654158, 0.09457092, 0.094487727, 0.094404519, 0.094321325, 0.094238147, 0.094154984, 0.094071843, 0.093988702, 0.093905553, 0.093822435, 0.093739323, 0.09365622, 0.093573131, 0.093490027, 0.093406968, 0.093323901, 0.09324085, 0.093157813, 0.093074776, 0.092991754, 0.09290874, 0.092825748, 0.092742771, 0.092659786, 0.092576817, 0.092493847, 0.092410915, 0.092327975, 0.092245042, 0.092162132, 0.092079222, 0.091996327, 0.091913439, 0.091830567, 0.091747709, 0.091664851, 0.091582, 0.091499172, 0.091416359, 0.091333546, 0.09125074, 0.091167942, 0.091085158, 0.091002397, 0.090919629, 0.090836883, 0.090754144, 0.09067142, 0.090588674, 0.090505987, 0.090423279, 0.090340599, 0.09025792, 0.090175249, 0.090092592, 0.09000995, 0.089927316, 0.089844696, 0.089762077, 0.089679472, 0.089596882, 0.089514285, 0.089431725, 0.089349166, 0.089266613, 0.089184068, 0.089101538, 0.089019015, 0.088936508, 0.088854, 0.088771515, 0.088689037, 0.088606574, 0.088524118, 0.088441662, 0.088359229, 0.088276796, 0.088194378, 0.088111974, 0.088029578, 0.087947197, 0.087864816, 0.087782457, 0.087700106, 0.087617755, 0.087535426, 0.087453105, 0.087370791, 0.087288484, 0.087206192, 0.087123916, 0.087041639, 0.086959392, 0.08687713, 0.08679489, 0.086712666, 0.086630434, 0.086548224, 0.086466029, 0.086383842, 0.086301669, 0.086219497, 0.086137347, 0.086055204, 0.085973054, 0.085890941, 0.085808828, 0.085726716, 0.085644625, 0.085562542, 0.085480474, 0.085398398, 0.085316353, 0.085234299, 0.085152283, 0.08507026, 0.084988259, 0.08490625, 0.084824257, 0.084742278, 0.084660307, 0.08457835, 0.084496409, 0.084414475, 0.084332541, 0.084250621, 0.08416871, 0.08408682, 0.084004939, 0.083923057, 0.083841197, 0.083759345, 0.0836775, 0.083595671, 0.083513841, 0.083432026, 0.083350226, 0.083268426, 0.083186656, 0.083104886, 0.083023131, 0.082941368, 0.082859628, 0.082777902, 0.08269617, 0.082614467, 0.082532771, 0.082451083, 0.082369402, 0.082287736, 0.082206078, 0.082124427, 0.082042783, 0.08196117, 0.081879556, 0.08179795, 0.081716359, 0.081634775, 0.081553198, 0.081471637, 0.081390083, 0.081308536, 0.081227012, 0.081145495, 0.081063978, 0.080982484, 0.080900982, 0.08081951, 0.080738038, 0.080656581, 0.080575131, 0.080493703, 0.080412276, 0.080330856, 0.080249459, 0.080168046, 0.080086656, 0.080005281, 0.079923913, 0.079842567, 0.079761229, 0.079679899, 0.079598576, 0.07951726, 0.079435952, 0.079354659, 0.079273373, 0.079192117, 0.079110853, 0.079029605, 0.078948364, 0.07886713, 0.078785896, 0.078704685, 0.078623489, 0.078542307, 0.078461118, 0.078379959, 0.078298807, 0.078217648, 0.078136519, 0.078055389, 0.077974275, 0.077893183, 0.077812083, 0.077731006, 0.077649921, 0.077568859, 0.077487804, 0.077406764, 0.077325732, 0.077244714, 0.077163696, 0.077082701, 0.077001721, 0.076920725, 0.07683976, 0.076758802, 0.076677844, 0.076596908, 0.076515995, 0.076435074, 0.076354168, 0.076273263, 0.076192379, 0.076111495, 0.076030642, 0.075949781, 0.075868942, 0.07578811, 0.075707279, 0.07562647, 0.075545669, 0.075464867, 0.075384095, 0.075303324, 0.075222559, 0.075141817, 0.075061075, 0.074980341, 0.074899614, 0.074818902, 0.074738197, 0.074657515, 0.074576832, 0.074496172, 0.074415512, 0.07433486, 0.074254222, 0.074173607, 0.074092992, 0.074012384, 0.073931798, 0.073851205, 0.073770635, 0.073690072, 0.073609516, 0.073528968, 0.073448442, 0.073367916, 0.073287413, 0.073206916, 0.07312642, 0.073045939, 0.072965465, 0.072885007, 0.072804555, 0.072724119, 0.07264369, 0.072563283, 0.072482876, 0.07240247, 0.072322093, 0.072241709, 0.072161347, 0.072080992, 0.072000638, 0.07192032, 0.071839988, 0.071759678, 0.071679369, 0.071599074, 0.071518794, 0.071438514, 0.071358256, 0.071278013, 0.071197778, 0.07111755, 0.071037322, 0.070957094, 0.070876904, 0.070796713, 0.07071653, 0.070636377, 0.070556208, 0.070476063, 0.070395939, 0.070315801, 0.070235685, 0.070155583, 0.070075475, 0.069995411, 0.069915339, 0.069835268, 0.069755211, 0.069675162, 0.069595136, 0.069515109, 0.069435105, 0.069355108, 0.069275118, 0.069195129, 0.069115162, 0.069035202, 0.068955258, 0.06887532, 0.068795383, 0.068715475, 0.068635561, 0.068555668, 0.06847579, 0.068395905, 0.068316035, 0.06823618, 0.068156339, 0.068076499, 0.067996688, 0.06791687, 0.067837059, 0.067757271, 0.06767749, 0.067597717, 0.067517951, 0.0674382, 0.067358471, 0.067278735, 0.067199022, 0.067119293, 0.067039594, 0.066959903, 0.066880226, 0.06680055, 0.06672091, 0.066641256, 0.066561624, 0.066481993, 0.066402368, 0.066322759, 0.066243179, 0.066163585, 0.066084012, 0.066005655, 0.06592837, 0.065851107, 0.065773897, 0.065696724, 0.06561958, 0.065542482, 0.065465428, 0.065388411, 0.065311417, 0.065234497, 0.065157585, 0.065080717, 0.065003887, 0.064927109, 0.06485036, 0.064773656, 0.064696983, 0.064620353, 0.064543761, 0.064467214, 0.064390689, 0.064314209, 0.064237781, 0.064161398, 0.064085022, 0.064008713, 0.063932426, 0.063856184, 0.063779987, 0.063703813, 0.063627705, 0.06355162, 0.063475579, 0.063399553, 0.063323595, 0.063247651, 0.063171774, 0.06309592, 0.06302011, 0.062944338, 0.06286861, 0.062792912, 0.062717251, 0.062641636, 0.062566049, 0.062490523, 0.062415011, 0.062339563, 0.062264133, 0.062188759, 0.062113415, 0.062038112, 0.061962835, 0.061887614, 0.061812416, 0.061737284, 0.061662171, 0.061587099, 0.06151206, 0.06143707, 0.061362114, 0.061287206, 0.061212324, 0.061137494, 0.061062697, 0.060987938, 0.060913209, 0.060838532, 0.060763888, 0.060689278, 0.060614716, 0.060540192, 0.060465716, 0.060391277, 0.060316857, 0.060242493, 0.060168155, 0.060093865, 0.060019616, 0.059945405, 0.05987123, 0.059797097, 0.059722986, 0.059648935, 0.059574917, 0.05950094, 0.059426993, 0.059353106, 0.059279237, 0.059205417, 0.05913163, 0.059057888, 0.058984179, 0.058910508, 0.058836881, 0.058763288, 0.058689754, 0.058616236, 0.058542769, 0.058469333, 0.058395945, 0.058322579, 0.058249269, 0.058175985, 0.058102757, 0.058029555, 0.057956398, 0.05788327, 0.057810202, 0.057737138, 0.057664145, 0.057591166, 0.057518262, 0.057445377, 0.057372525, 0.057299715, 0.057226945, 0.057154212, 0.057081517, 0.057008862, 0.056936257, 0.056863688, 0.056791153, 0.056718662, 0.056646202, 0.056573782, 0.056501389, 0.056429062, 0.056356758, 0.056284484, 0.05621225, 0.056140069, 0.056067921, 0.055995815, 0.055923749, 0.05585172, 0.055779725, 0.055707775, 0.05563587, 0.055564005, 0.05549217, 0.055420369, 0.05534862, 0.055276904, 0.055205222, 0.055133585, 0.055061985, 0.054990433, 0.054918896, 0.054847416, 0.054775979, 0.054704566, 0.0546332, 0.054561879, 0.054490585, 0.054419339, 0.054348126, 0.054276954, 0.054205827, 0.054134734, 0.054063685, 0.05399267, 0.0539217, 0.053850748, 0.053779863, 0.053709004, 0.053638171, 0.053567398, 0.053496655, 0.05342596, 0.053355295, 0.053284671, 0.053214077, 0.053143531, 0.053073019, 0.053002551, 0.052932125, 0.052861731, 0.052791376, 0.052721072, 0.052650791, 0.052580558, 0.052510355, 0.052440204, 0.052370083, 0.052300017, 0.052229971, 0.052159965, 0.052090004, 0.052020077, 0.051950205, 0.051880348, 0.051810533, 0.05174078, 0.051671058, 0.051601361, 0.051531725, 0.051462099, 0.051392525, 0.051322982, 0.051253505, 0.05118404, 0.051114634, 0.051045261, 0.050975915, 0.050906613, 0.050837357, 0.050768141, 0.050698955, 0.050629802, 0.050560724, 0.050491646, 0.050422616, 0.050353624, 0.050284684, 0.050215777, 0.0501469, 0.050078072, 0.050009288, 0.049940534, 0.049871817, 0.049803153, 0.049734503, 0.049665909, 0.049597345, 0.049528822, 0.049460351, 0.049391903, 0.049323507, 0.049255133, 0.049186811, 0.04911853, 0.049050279, 0.048982061, 0.048913915, 0.048845779, 0.048777685, 0.048709638, 0.048641626, 0.04857365, 0.04850572, 0.048437826, 0.04836997, 0.048302159, 0.048234373, 0.04816664, 0.048098948, 0.048031274, 0.047963645, 0.047896065, 0.047828525, 0.047761023, 0.047693558, 0.047626145, 0.047558758, 0.047491401, 0.047424089, 0.04735681, 0.04728958, 0.047222398, 0.047155242, 0.047088131, 0.047021054, 0.04695401, 0.046887022, 0.046820048, 0.046753131, 0.046686258, 0.046619415, 0.046552606, 0.046485834, 0.046419125, 0.046352435, 0.046285771, 0.046219163, 0.046152618, 0.046086069, 0.046019576, 0.045953121, 0.045886725, 0.045820337, 0.045753997, 0.045687709, 0.045621455, 0.045555245, 0.045489062, 0.045422919, 0.045356821, 0.045290753, 0.045224726, 0.045158744, 0.045092806, 0.045026902, 0.044961028, 0.044895198, 0.044829417, 0.044763666, 0.044697952, 0.044632282, 0.044566639, 0.044501051, 0.044435497, 0.044369992, 0.044304512, 0.044239063, 0.044173665, 0.044108305, 0.044042978, 0.043977708, 0.043912467, 0.043847259, 0.043782096, 0.043716963, 0.043651886, 0.04358682, 0.043521818, 0.043456856, 0.043391928, 0.043327034, 0.043262169, 0.043197367, 0.043132581, 0.043067843, 0.043003142, 0.042938493, 0.042873874, 0.0428093, 0.042744748, 0.042680252, 0.042615786, 0.042551368, 0.042486969, 0.04242263, 0.042358324, 0.04229407, 0.04222982, 0.042165633, 0.042101488, 0.042037379, 0.041973293, 0.041909274, 0.041845273, 0.041781321, 0.041717399, 0.041653525, 0.041589681, 0.041525878, 0.041462108, 0.041398406, 0.041334718, 0.041271079, 0.041207466, 0.041143902, 0.041080371, 0.041016884, 0.040953428, 0.040890019, 0.04082666, 0.04076333, 0.040700026, 0.040636763, 0.04057356, 0.040510386, 0.040447246, 0.040384144, 0.040321093, 0.040258083, 0.0401951, 0.040132158, 0.040069245, 0.040006373, 0.039943546, 0.03988076, 0.039818019, 0.039755311, 0.039692637, 0.039630018, 0.039567415, 0.039504852, 0.039442342, 0.039379865, 0.039317451, 0.039255049, 0.03919271, 0.039130379, 0.039068103, 0.039005861, 0.038943656, 0.038881499, 0.038819373, 0.038757294, 0.038695246, 0.038633242, 0.038571272, 0.038509347, 0.038447451, 0.038385607, 0.038323801, 0.038262032, 0.038200293, 0.038138602, 0.038076937, 0.038015328, 0.037953731, 0.037892208, 0.037830703, 0.037769254, 0.037707835, 0.037646454, 0.037585091, 0.037523799, 0.037462525, 0.037401311, 0.037340116, 0.03727898, 0.03721787, 0.037156798, 0.037095752, 0.037034769, 0.036973804, 0.036912892, 0.036852024, 0.036791187, 0.03673039, 0.036669631, 0.036608908, 0.036548227, 0.036487587, 0.03642698, 0.036366414, 0.036305908, 0.036245409, 0.036184963, 0.036124554, 0.0360642, 0.036003858, 0.035943568, 0.035883322, 0.035823114, 0.035762947, 0.03570281, 0.03564271, 0.03558265, 0.035522625, 0.035462644, 0.035402711, 0.035342824, 0.035282966, 0.035223141, 0.03516335, 0.035103608, 0.03504391, 0.034984235, 0.0349246, 0.034865025, 0.03480548, 0.034745961, 0.034686495, 0.034627065, 0.034567662, 0.034508299, 0.034448989, 0.034389723, 0.034330498, 0.034271289, 0.034212109, 0.034153, 0.034093924, 0.034034871, 0.033975866, 0.033916902, 0.033857986, 0.033799101, 0.033740252, 0.033681445, 0.033622675, 0.033563934, 0.033505239, 0.033446595, 0.033387981, 0.033329416, 0.033270869, 0.033212401, 0.033153921, 0.033095509, 0.033037115, 0.032978784, 0.03292048, 0.032862231, 0.032803997, 0.032745827, 0.032687668, 0.032629564, 0.032571487, 0.032513484, 0.032455482, 0.032397531, 0.032339614, 0.03228176, 0.032225151, 0.032169841, 0.032114536, 0.032059308, 0.032004125, 0.031948984, 0.031893902, 0.03183886, 0.031783871, 0.031728953, 0.031674035, 0.031619214, 0.031564411, 0.031509671, 0.031454965, 0.031400315, 0.031345721, 0.031291172, 0.03123668, 0.031182218, 0.031127825, 0.031073457, 0.031019161, 0.030964904, 0.030910702, 0.030856544, 0.030802447, 0.030748358, 0.030694369, 0.03064038, 0.030586483, 0.030532613, 0.03047879, 0.030425029, 0.030371312, 0.030317647, 0.03026404, 0.030210437, 0.030156936, 0.030103445, 0.030050032, 0.029996656, 0.029943321, 0.029890042, 0.02983683, 0.029783633, 0.029730508, 0.029677404, 0.029624388, 0.029571408, 0.029518463, 0.029465569, 0.029412752, 0.029359939, 0.029307211, 0.029254517, 0.029201869, 0.029149299, 0.029096717, 0.029044246, 0.028991772, 0.028939396, 0.02888702, 0.028834732, 0.028782452, 0.028730281, 0.028678108, 0.028626004, 0.028573947, 0.02852192, 0.028469989, 0.02841807, 0.02836621, 0.028314399, 0.02826263, 0.028210904, 0.028159259, 0.028107628, 0.028056068, 0.028004544, 0.027953072, 0.027901646, 0.027850272, 0.027798941, 0.027747683, 0.027696442, 0.027645279, 0.027594127, 0.027543057, 0.027492022, 0.027441042, 0.027390094, 0.027339222, 0.02728837, 0.027237603, 0.02718685, 0.027136171, 0.027085533, 0.02703494, 0.02698439, 0.026933894, 0.026883451, 0.026833063, 0.026782695, 0.026732415, 0.026682135, 0.026631942, 0.026581807, 0.026531694, 0.026481636, 0.026431639, 0.026381686, 0.026331745, 0.026281912, 0.02623209, 0.026182333, 0.026132625, 0.026082946, 0.026033334, 0.025983753, 0.025934251, 0.025884805, 0.025835356, 0.025786009, 0.025736673, 0.025687391, 0.025638167, 0.025588993, 0.025539869, 0.025490811, 0.025441753, 0.025392795, 0.025343832, 0.025294967, 0.025246143, 0.025197348, 0.02514861, 0.025099933, 0.025051281, 0.025002699, 0.024954148, 0.02490567, 0.024857225, 0.024808826, 0.024760477, 0.024712175, 0.024663934, 0.02461574, 0.024567574, 0.024519488, 0.024471449, 0.024423419, 0.024375478, 0.024327574, 0.024279702, 0.024231926, 0.024184147, 0.024136448, 0.02408877, 0.024041148, 0.023993604, 0.02394608, 0.023898613, 0.023851186, 0.023803843, 0.023756504, 0.023709243, 0.023661997, 0.023614842, 0.023567716, 0.023520639, 0.023473609, 0.02342663, 0.023379695, 0.023332838, 0.023285974, 0.023239216, 0.023192499, 0.023145787, 0.023099156, 0.023052564, 0.023006029, 0.02295956, 0.022913096, 0.022866737, 0.022820374, 0.02277408, 0.022727847, 0.022681633, 0.022635514, 0.022589389, 0.022543339, 0.022497348, 0.022451393, 0.022405481, 0.022359643, 0.022313818, 0.022268089, 0.022222361, 0.022176705, 0.022131091, 0.02208554, 0.022040023, 0.021994583, 0.021949137, 0.021903794, 0.021858444, 0.021813178, 0.021767983, 0.021722788, 0.021677669, 0.021632601, 0.021587588, 0.021542598, 0.021497691, 0.021452796, 0.021407969, 0.021363202, 0.021318471, 0.021273779, 0.021229146, 0.021184562, 0.021140045, 0.021095537, 0.021051109, 0.0210067, 0.020962376, 0.020918082, 0.020873837, 0.020829652, 0.020785514, 0.020741394, 0.020697372, 0.02065336, 0.020609425, 0.02056551, 0.020521663, 0.020477854, 0.020434095, 0.020390403, 0.02034675, 0.020303126, 0.02025958, 0.020216063, 0.020172613, 0.020129194, 0.02008583, 0.020042509, 0.019999271, 0.019956036, 0.019912876, 0.019869728, 0.019826677, 0.019783655, 0.01974068, 0.019697756, 0.019654877, 0.01961207, 0.01956928, 0.019526551, 0.019483857, 0.019441241, 0.019398656, 0.019356128, 0.019313648, 0.019271199, 0.019228818, 0.019186493, 0.019144179, 0.019101953, 0.019059755, 0.019017626, 0.018975526, 0.018933482, 0.018891487, 0.018849563, 0.018807637, 0.018765807, 0.018723978, 0.018682245, 0.018640542, 0.018598879, 0.018557284, 0.018515725, 0.018474208, 0.018432777, 0.018391345, 0.018350001, 0.018308688, 0.018267421, 0.018226193, 0.018185034, 0.018143915, 0.01810286, 0.018061828, 0.018020881, 0.017979935, 0.017939076, 0.017898256, 0.017857485, 0.017816762, 0.017776089, 0.017735461, 0.017694857, 0.017654346, 0.017613836, 0.017573424, 0.017533042, 0.017492699, 0.017452421, 0.017412173, 0.017371975, 0.017331863, 0.017291751, 0.017251726, 0.01721175, 0.017171783, 0.017131908, 0.017092047, 0.017052256, 0.017012503, 0.01697281, 0.016933152, 0.016893556, 0.016853997, 0.016814508, 0.016775018, 0.016735623, 0.016696287, 0.016656961, 0.016617695, 0.016578486, 0.016539333, 0.016500231, 0.01646114, 0.016422143, 0.016383156, 0.016344259, 0.01630538, 0.016266558, 0.016227785, 0.016189082, 0.016150376, 0.016111778, 0.01607318, 0.01603467, 0.015996188, 0.015957756, 0.01591938, 0.015881045, 0.015842756, 0.015804499, 0.015766347, 0.015728196, 0.015690122, 0.015652068, 0.01561409, 0.015576143, 0.015538253, 0.015500391, 0.015462629, 0.015424866, 0.015387179, 0.015349504, 0.015311924, 0.015274375, 0.015236863, 0.01519942, 0.015162026, 0.015124641, 0.015087351, 0.015050082, 0.015012883, 0.01497573, 0.014938617, 0.014901541, 0.014864536, 0.014827559, 0.014790677, 0.014753778, 0.014716984, 0.014680211, 0.014643485, 0.014606808, 0.014570191, 0.01453362, 0.014497099, 0.014460607, 0.014424201, 0.014387806, 0.014351478, 0.0143152, 0.014278968, 0.014242779, 0.014206643, 0.014170558, 0.014134542, 0.014098526, 0.014062614, 0.014026714, 0.013990873, 0.01395507, 0.013919333, 0.013883646, 0.013848008, 0.013812388, 0.013776866, 0.013741334, 0.0137059, 0.013670513, 0.013635146, 0.013599837, 0.013564598, 0.013529397, 0.013494231, 0.013459126, 0.013424061, 0.013389072, 0.013354084, 0.013319192, 0.013284302, 0.013249508, 0.013214732, 0.013179996, 0.013145337, 0.013110708, 0.013076147, 0.013041634, 0.013007149, 0.012972724, 0.012938356, 0.012904017, 0.012869757, 0.012835505, 0.012801351, 0.012767207, 0.01273312, 0.012699104, 0.012665104, 0.012631165, 0.012597301, 0.012563439, 0.012529663, 0.012495897, 0.012462238, 0.012428588, 0.012394977, 0.012361454, 0.01232794, 0.012294504, 0.012261107, 0.012227759, 0.012194457, 0.012161216, 0.012127995, 0.012094849, 0.012061734, 0.012028686, 0.011995676, 0.011962716, 0.011929804, 0.01189695, 0.011864134, 0.011831379, 0.011798649, 0.01176599, 0.011733379, 0.011700806, 0.011668283, 0.011635818, 0.01160339, 0.01157103, 0.011538692, 0.011506429, 0.011474178, 0.011442021, 0.011409906, 0.011377809, 0.011345779, 0.011313809, 0.011281857, 0.011249993, 0.011218129, 0.011186372, 0.011154624, 0.011122935, 0.011091284, 0.011059691, 0.011028158, 0.010996681, 0.010965205, 0.010933826, 0.010902476, 0.010871175, 0.010839932, 0.010808727, 0.010777571, 0.010746493, 0.010715405, 0.010684424, 0.010654454, 0.010625617, 0.010596829, 0.01056805, 0.010539358, 0.010510677, 0.010482035, 0.01045344, 0.010424875, 0.010396387, 0.010367909, 0.010339461, 0.01031108, 0.010282719, 0.010254416, 0.010226151, 0.010197916, 0.01016973, 0.010141551, 0.010113472, 0.010085401, 0.01005736, 0.010029377, 0.010001443, 0.0099735372, 0.0099456804, 0.0099178338, 0.0098900637, 0.009862314, 0.009834622, 0.009806959, 0.0097793257, 0.0097517492, 0.0097242231, 0.0096967155, 0.0096692564, 0.0096418262, 0.0096144546, 0.0095871314, 0.0095598176, 0.0095325718, 0.0095053455, 0.0094781686, 0.0094510391, 0.0094239591, 0.0093969069, 0.0093698949, 0.0093429005, 0.0093159853, 0.0092890887, 0.0092622507, 0.0092354314, 0.0092086615, 0.0091819307, 0.009155238, 0.0091286041, 0.0091019981, 0.0090754125, 0.0090489052, 0.0090224259, 0.0089959754, 0.0089695742, 0.0089431917, 0.0089168679, 0.0088906027, 0.0088643562, 0.008838159, 0.0088119805, 0.0087858699, 0.0087597985, 0.0087337457, 0.0087077525, 0.0086817881, 0.0086558815, 0.0086300038, 0.0086041549, 0.0085783843, 0.008552623, 0.0085268915, 0.008501227, 0.0084755924, 0.0084500061, 0.0084244581, 0.0083989399, 0.00837347, 0.0083480291, 0.0083226468, 0.0082973028, 0.0082719782, 0.0082467217, 0.0082215043, 0.0081963055, 0.0081711756, 0.0081460448, 0.008120982, 0.0080959685, 0.0080709839, 0.0080460478, 0.0080211209, 0.0079962714, 0.0079714516, 0.007946671, 0.0079219285, 0.0078972345, 0.0078725601, 0.0078479443, 0.0078233667, 0.0077988282, 0.0077743386, 0.0077498686, 0.0077254656, 0.0077010719, 0.0076767369, 0.0076524708, 0.0076282043, 0.0076039853, 0.0075798058, 0.0075556748, 0.0075315833, 0.0075075207, 0.0074835247, 0.0074595488, 0.0074356315, 0.0074117337, 0.007387884, 0.0073640733, 0.0073403013, 0.0073165772, 0.0072929026, 0.007269247, 0.0072456496, 0.0072220913, 0.0071985619, 0.0071750814, 0.0071516191, 0.0071282261, 0.0071048811, 0.0070815454, 0.0070582684, 0.007035011, 0.0070118308, 0.0069886791, 0.006965538, 0.0069424747, 0.006919459, 0.0068964441, 0.0068734973, 0.006850569, 0.0068276995, 0.006804869, 0.0067820572, 0.0067593046, 0.0067365901, 0.0067139338, 0.0066913064, 0.0066686892, 0.0066461493, 0.0066236686, 0.0066011772, 0.0065787635, 0.0065563596, 0.0065340134, 0.0065117269, 0.0064894292, 0.0064672199, 0.0064450195, 0.0064228871, 0.0064007938, 0.0063787098, 0.0063566943, 0.0063347272, 0.0063127601, 0.00629086, 0.0062690093, 0.0062471982, 0.0062254244, 0.0062036519, 0.0061819749, 0.0061603184, 0.0061387098, 0.0061171311, 0.0060955812, 0.0060740989, 0.0060526459, 0.0060312124, 0.0060098562, 0.0059885001, 0.0059672217, 0.0059459824, 0.0059247622, 0.0059035909, 0.0058824485, 0.0058613638, 0.0058403281, 0.0058193118, 0.0057983538, 0.0057774056, 0.0057565146, 0.005735673, 0.0057148603, 0.005694116, 0.0056734006, 0.0056527038, 0.0056320662, 0.0056114476, 0.0055908971, 0.0055703758, 0.005549883, 0.0055294489, 0.0055090534, 0.0054886872, 0.0054683699, 0.0054480713, 0.0054278602, 0.0054076398, 0.0053874962, 0.0053673824, 0.0053472975, 0.0053272704, 0.0053072632, 0.0052873148, 0.0052674138, 0.0052475231, 0.0052277097, 0.0052079158, 0.0051881513, 0.0051684449, 0.0051487675, 0.005129158, 0.0051095681, 0.0050900071, 0.005070495, 0.005051021, 0.005031615, 0.0050122384, 0.0049928715, 0.0049735727, 0.0049543222, 0.0049350723, 0.0049159089, 0.0048967558, 0.0048776604, 0.0048586037, 0.004839567, 0.0048206076, 0.0048016482, 0.0047827568, 0.0047638942, 0.0047450708, 0.0047263154, 0.0047075693, 0.0046888818, 0.0046702134, 0.0046515837, 0.0046330225, 0.0046144994, 0.0045959968, 0.0045775608, 0.0045591155, 0.0045407484, 0.0045224386, 0.0045041298, 0.0044858786, 0.0044676666, 0.0044495026, 0.0044313874, 0.004413282, 0.0043952442, 0.0043772454, 0.0043592663, 0.0043413551, 0.0043234625, 0.0043056193, 0.0042878049, 0.004270039, 0.0042523309, 0.0042346334, 0.004217003, 0.0041994117, 0.00418184, 0.0041643167, 0.0041468414, 0.0041293963, 0.0041120183, 0.0040946407, 0.0040773209, 0.0040600691, 0.0040428177, 0.0040256241, 0.0040084501, 0.0039913538, 0.0039742864, 0.0039572385, 0.0039402586, 0.0039233076, 0.0039063762, 0.0038895225, 0.0038726784, 0.0038559118, 0.0038391645, 0.003822437, 0.0038057675, 0.0037891462, 0.003772564, 0.0037560209, 0.0037395065, 0.0037230407, 0.0037066336, 0.0036902255, 0.0036738957, 0.0036575757, 0.0036413237, 0.0036251005, 0.0036089257, 0.0035927799, 0.0035766736, 0.003560615, 0.0035445862, 0.0035286152, 0.0035126926, 0.0034967801, 0.0034809161, 0.0034651197, 0.0034493236, 0.0034336047, 0.0034178863, 0.0034022648, 0.0033866528, 0.0033710601, 0.0033555259, 0.0033400306, 0.0033245934, 0.0033091854, 0.0032938062, 0.0032784857, 0.0032631939, 0.0032479409, 0.0032327464, 0.0032175609, 0.0032024439, 0.0031873661, 0.0031723171, 0.0031573065, 0.0031423448, 0.003127422, 0.0031125373, 0.0030976825, 0.0030828952, 0.0030681472, 0.003053399, 0.0030387379, 0.0030240866, 0.0030094932, 0.002994949, 0.0029804239, 0.0029659471, 0.0029514802, 0.0029371006, 0.0029227596, 0.0029084382, 0.0028941554, 0.0028799409, 0.0028657359, 0.00285157, 0.0028374619, 0.0028234024, 0.0028093723, 0.0027953808, 0.0027814184, 0.0027675142, 0.0027536585, 0.0027398223, 0.0027260345, 0.0027122856, 0.0026985754, 0.0026849138, 0.0026712911, 0.0026576973, 0.0026441521, 0.002630665, 0.0026171783, 0.0026037691, 0.002590379, 0.0025770473, 0.0025637543, 0.0025504616, 0.0025372559, 0.0025240793, 0.002510932, 0.0024978525, 0.0024847635, 0.0024717713, 0.0024587987, 0.0024458454, 0.0024329694, 0.0024200841, 0.0024072861, 0.0023945365, 0.0023817774, 0.0023690958, 0.0023564335, 0.0023438295, 0.0023312741, 0.0023187282, 0.0023062406, 0.0022937823, 0.0022813722, 0.0022690208, 0.0022566689, 0.0022444045, 0.0022321595, 0.0022199436, 0.0022077858, 0.0021956477, 0.0021835773, 0.0021715555, 0.0021595142, 0.0021475796, 0.0021356356, 0.0021237591, 0.002111912, 0.0021001133, 0.0020883728, 0.0020766228, 0.0020649699, 0.002053336, 0.0020417217, 0.0020301752, 0.0020186387, 0.0020071797, 0.0019957495, 0.001984349, 0.0019730059, 0.0019616829, 0.0019503984, 0.0019391723, 0.0019279752, 0.0019168364, 0.0019057267, 0.0018946556, 0.0018836234, 0.0018726205, 0.0018616951, 0.0018507892, 0.001839912, 0.0018290839, 0.0018183234, 0.001807563, 0.0017968606, 0.0017861875, 0.0017755532, 0.0017649963, 0.0017544494, 0.0017439412, 0.001733472, 0.0017230511, 0.0017126884, 0.0017023354, 0.0016920407, 0.0016818042, 0.0016715581, 0.0016613895, 0.0016512501, 0.0016411592, 0.0016311068, 0.0016210742, 0.0016111189, 0.0016011639, 0.0015912767, 0.001581438, 0.0015715993, 0.0015618576, 0.001552116, 0.0015424229, 0.0015327685, 0.0015231433, 0.0015135957, 0.0015040578, 0.0014945685, 0.0014851469, 0.0014757158, 0.0014663525, 0.0014570282, 0.0014477328, 0.0014385151, 0.001429307, 0.0014201381, 0.0014110173, 0.0014019159, 0.0013928922, 0.001383888, 0.0013749226, 0.0013660056, 0.0013571276, 0.001348298, 0.0013394878, 0.0013307359, 0.001322013, 0.0013133483, 0.0013047128, 0.001296781, 0.0012895161, 0.0012822644, 0.0012750152, 0.0012678071, 0.0012605895, 0.0012534165, 0.001246245, 0.0012391157, 0.0012319878, 0.0012248636, 0.0012177901, 0.0012107106, 0.0012036713, 0.0011966453, 0.0011896215, 0.0011826392, 0.0011756507, 0.0011687023, 0.0011617757, 0.0011548429, 0.0011479515, 0.0011410527, 0.0011342026, 0.0011273681, 0.0011205263, 0.0011137355, 0.0011069375, 0.001100171, 0.0010934264, 0.0010866841, 0.0010799841, 0.0010732771, 0.0010666113, 0.0010599685, 0.0010533172, 0.001046707, 0.0010400909, 0.001033516, 0.001026963, 0.0010204099, 0.0010138908, 0.0010073754, 0.0010008914, 0.00099443912, 0.00098796969, 0.00098155241, 0.00097512675, 0.00096874341, 0.00096237112, 0.00095600239, 0.00094967493, 0.00094335107, 0.00093706854, 0.00093076774, 0.00092450943, 0.0009182826, 0.00091203762, 0.00090584479, 0.00089964585, 0.00089348695, 0.00088734139, 0.00088119827, 0.0008750977, 0.00086899695, 0.00086293026, 0.00085688534, 0.00085083325, 0.00084482355, 0.00083881378, 0.00083284773, 0.0008268829, 0.00082094234, 0.00081502122, 0.00080910244, 0.0008032262, 0.00079737289, 0.00079150277, 0.00078568218, 0.00077985687, 0.00077407999, 0.00076830806, 0.00076253724, 0.00075681985, 0.00075108308, 0.0007453984, 0.00073971739, 0.00073404727, 0.00072841957, 0.0007227835, 0.00071719097, 0.00071160583, 0.00070602784, 0.00070048997, 0.00069494609, 0.00068944448, 0.00068395271, 0.00067847426, 0.0006730188, 0.00066757551, 0.00066217221, 0.0006567823, 0.00065138505, 0.0006460303, 0.00064068526, 0.000635362, 0.00063006306, 0.00062476652, 0.00061951246, 0.00061424862, 0.0006090285, 0.00060382899, 0.00059862464, 0.00059345906, 0.00058829837, 0.00058316678, 0.00057805941, 0.00057295326, 0.0005678811, 0.00056281139, 0.00055778044, 0.0005527641, 0.00054773677, 0.00054276409, 0.00053779257, 0.00053284538, 0.00052792841, 0.00052300544, 0.00051812368, 0.00051324314, 0.00050839537, 0.00050355977, 0.00049873744, 0.00049394422, 0.00048915704, 0.00048440875, 0.00047965432, 0.00047494238, 0.00047024139, 0.0004655415, 0.00046089388, 0.00045623042, 0.00045160824, 0.00044700905, 0.00044240992, 0.00043784472, 0.0004332735, 0.00042875076, 0.00042424258, 0.00041973434, 0.00041526012, 0.00041078712, 0.00040636628, 0.00040194782, 0.00039753187, 0.00039314854, 0.0003887738, 0.00038443421, 0.00038011643, 0.00037579137, 0.00037150757, 0.00036723711, 0.00036298603, 0.00035876047, 0.00035452517, 0.00035034202, 0.00034615281, 0.00034200362, 0.00033786779, 0.00033374288, 0.00032964218, 0.00032554154, 0.00032148455, 0.00031745541, 0.00031341295, 0.00030941176, 0.00030540329, 0.00030144572, 0.00029750029, 0.00029355852, 0.00028964705, 0.00028573922, 0.00028187266, 0.00027799999, 0.00027416856, 0.0002703566, 0.00026654094, 0.00026276408, 0.00025899211, 0.00025524924, 0.0002515282, 0.00024781079, 0.00024412734, 0.0002404633, 0.00023679443, 0.00023317405, 0.00022954881, 0.00022595633, 0.00022239296, 0.00021881382, 0.00021529535, 0.00021176106, 0.00020825591, 0.00020478593, 0.00020130382, 0.00019786657, 0.000194433, 0.00019102971, 0.00018764948, 0.00018427047, 0.00018092542, 0.00017758035, 0.00017426925, 0.00017098848, 0.00016770164, 0.0001644451, 0.00016119225, 0.00015799151, 0.000154792, 0.0001515961, 0.00014844026, 0.00014528562, 0.00014216373, 0.00013904668, 0.00013595997, 0.000132906, 0.00012983507, 0.00012681383, 0.00012378774, 0.00012080169, 0.00011782898, 0.00011486596, 0.00011192843, 0.0001090006, 0.00010610673, 0.00010323468, 0.00010035295, 9.7524557e-05, 9.4686467e-05, 9.188235e-05, 8.910006e-05, 8.6320193e-05, 8.3571867e-05, 8.0827165e-05, 7.8124911e-05, 7.5442069e-05, 7.2754396e-05, 7.0106733e-05, 6.7452995e-05, 6.4848995e-05, 6.2248633e-05, 5.9650694e-05, 5.7093999e-05, 5.4550626e-05, 5.2027885e-05, 4.9526989e-05, 4.7018806e-05, 4.4563978e-05, 4.2099458e-05, 3.9678605e-05, 3.7268634e-05, 3.4873239e-05, 3.2498476e-05, 3.0135827e-05, 2.779504e-05, 2.5495438e-05, 2.3181319e-05, 2.0906002e-05, 1.8624627e-05, 1.6394168e-05, 1.4157672e-05, 1.1961188e-05, 9.7756265e-06, 7.5948888e-06, 5.4554362e-06, 3.3098866e-06, 1.2031584e-06, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.3777189e-15, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 1.8214132e-05, 3.9053973e-07, 1.6810188e-06, 2.9666462e-06, 4.2619768e-06, 5.5718615e-06, 6.8720437e-06, 8.1916314e-06, 9.5015157e-06, 1.0835657e-05, 1.2155246e-05, 1.3494239e-05, 1.4828381e-05, 1.6181928e-05, 1.7525772e-05, 1.8884171e-05, 2.0242571e-05, 2.1610673e-05, 2.2978773e-05, 2.4356579e-05, 2.5739237e-05, 2.7117039e-05, 2.8514249e-05, 2.9911462e-05, 3.1318374e-05, 3.2720436e-05, 3.4137051e-05, 3.5553669e-05, 3.6979985e-05, 3.8406306e-05, 3.9842329e-05, 4.1278352e-05, 4.2728927e-05, 4.4174652e-05, 4.563493e-05, 4.7090354e-05, 4.8565191e-05, 5.0025468e-05, 5.1500301e-05, 5.2984837e-05, 5.4469376e-05, 5.5963614e-05, 5.7457852e-05, 5.8971498e-05, 6.0470586e-05, 6.1989085e-05, 6.3502725e-05, 6.5035776e-05, 6.6554276e-05, 6.8097026e-05, 6.9630078e-05, 7.1182534e-05, 7.2730138e-05, 7.4287447e-05, 7.5844757e-05, 7.7406912e-05, 7.8983627e-05, 8.0555488e-05, 8.2141902e-05, 8.3723469e-05, 8.5324435e-05, 8.6915701e-05, 8.8521527e-05, 9.0127345e-05, 9.174287e-05, 9.3363255e-05, 9.4988478e-05, 9.6613709e-05, 9.8253491e-05, 9.9888413e-05, 0.00010154276, 0.00010318738, 0.00010483687, 0.00010650091, 0.00010817464, 0.00010983869, 0.00011152214, 0.00011319587, 0.00011488902, 0.00011657731, 0.00011828016, 0.00011997817, 0.00012169557, 0.00012340327, 0.00012512553, 0.00012684779, 0.00012857004, 0.0001303117, 0.00013204366, 0.00013379987, 0.00013554153, 0.0001373026, 0.00013905881, 0.00014083444, 0.00014260036, 0.00014438083, 0.00014616131, 0.00014795148, 0.00014974167, 0.00015154154, 0.00015334142, 0.00015515585, 0.00015696544, 0.00015878472, 0.00016060885, 0.00016243783, 0.00016427653, 0.00016611522, 0.0001679636, 0.000169812, 0.00017167009, 0.0001735282, 0.00017540086, 0.00017726864, 0.000179151, 0.00018102849, 0.00018292056, 0.00018480777, 0.00018671437, 0.00018861127, 0.00019051789, 0.00019243905, 0.0001943505, 0.00019628137, 0.00019820254, 0.00020014796, 0.00020207884, 0.00020403395, 0.00020597938, 0.00020793936, 0.00020989933, 0.00021186902, 0.00021383869, 0.00021581807, 0.00021779745, 0.0002197914, 0.00022178047, 0.0002237744, 0.0002257829, 0.00022779139, 0.00022980958, 0.00023182292, 0.00023385081, 0.0002358787, 0.00023791631, 0.00023995392, 0.00024200606, 0.00024405337, 0.00024611523, 0.00024817223, 0.00025024865, 0.00025231048, 0.00025439661, 0.00025647299, 0.00025855913, 0.00026065492, 0.00026275075, 0.00026485627, 0.00026696664, 0.00026908671, 0.00027119709, 0.00027333171, 0.00027545664, 0.00027759612, 0.00027973074, 0.00028188477, 0.00028402911, 0.00028619284, 0.0002883517, 0.00029052031, 0.0002926889, 0.00029487204, 0.00029705034, 0.00029924317, 0.00030143603, 0.00030363855, 0.00030583626, 0.0003080485, 0.00031026074, 0.00031248757, 0.00031470953, 0.00031694601, 0.00031917283, 0.0003214239, 0.00032366038, 0.00032591145, 0.00032817223, 0.00033043299, 0.00033270346, 0.00033497391, 0.00033725894, 0.00033953425, 0.00034182897, 0.000344114, 0.00034642327, 0.00034871799, 0.00035103699, 0.00035334626, 0.00035567008, 0.00035798908, 0.00036032745, 0.000362661, 0.00036499937, 0.0003673523, 0.00036969557, 0.00037205822, 0.00037441601, 0.00037678835, 0.00037915586, 0.00038154275, 0.00038392481, 0.00038631653, 0.00038870831, 0.00039110976, 0.00039351123, 0.00039592237, 0.00039833839, 0.00040075925, 0.00040318494, 0.00040561068, 0.00040805095, 0.00041049119, 0.00041294118, 0.00041538631, 0.0004178508, 0.00042031051, 0.00042277988, 0.00042524922, 0.00042773804, 0.00043021224, 0.00043271072, 0.00043519467, 0.00043770284, 0.00044020134, 0.00044271923, 0.0004452274, 0.00044774529, 0.00045027773, 0.00045280048, 0.00045534747, 0.00045787994, 0.0004604366, 0.00046297879, 0.00046554516, 0.00046810188, 0.00047067797, 0.00047324438, 0.00047583019, 0.00047841115, 0.0004810018, 0.00048359734, 0.00048619771, 0.00048879808, 0.00049140328, 0.00049402792, 0.00049664278, 0.00049927225, 0.00050190173, 0.00050454092, 0.00050718011, 0.00050983386, 0.00051248271, 0.00051514129, 0.0005178047, 0.000520473   }, 
   { 0.004673996, 0.0046697096, 0.0046654232, 0.0046611363, 0.0046569146, 0.004652692, 0.0046485127, 0.0046443548, 0.0046401755, 0.0046360604, 0.0046319454, 0.0046278303, 0.0046237796, 0.0046197292, 0.0046157427, 0.0046117348, 0.0046077697, 0.0046037831, 0.0045998609, 0.0045959605, 0.0045920811, 0.0045882231, 0.0045843655, 0.0045805289, 0.0045767357, 0.0045729205, 0.0045691696, 0.0045654406, 0.0045617325, 0.0045580463, 0.0045543811, 0.004550695, 0.004547073, 0.0045434721, 0.0045399144, 0.0045363354, 0.0045327991, 0.0045292624, 0.004525769, 0.0045222971, 0.0045188251, 0.0045153955, 0.0045119878, 0.0045086015, 0.0045052366, 0.0045018718, 0.0044985497, 0.0044952491, 0.0044919914, 0.0044887336, 0.0044854973, 0.0044822614, 0.0044790674, 0.0044758958, 0.0044727237, 0.0044696373, 0.0044665509, 0.0044634221, 0.0044603785, 0.0044573136, 0.0044542914, 0.0044512912, 0.0044483333, 0.0044453973, 0.0044424608, 0.0044395248, 0.0044366312, 0.0044337809, 0.0044309516, 0.0044281227, 0.0044253152, 0.0044225287, 0.004419764, 0.0044170208, 0.0044142986, 0.0044115982, 0.0044089407, 0.0044063046, 0.0044036685, 0.0044010533, 0.00439846, 0.0043959096, 0.0043933806, 0.004390873, 0.0043883654, 0.0043858793, 0.0043834145, 0.0043809926, 0.0043785493, 0.0043761702, 0.0043738126, 0.0043714768, 0.0043691616, 0.0043668258, 0.0043645538, 0.0043623038, 0.0043600746, 0.0043578669, 0.0043556807, 0.0043534734, 0.00435133, 0.004349208, 0.0043470864, 0.0043449863, 0.0043429285, 0.0043409136, 0.0043388992, 0.0043369061, 0.0043349126, 0.0043329624, 0.0043310332, 0.0043291259, 0.0043272399, 0.004325354, 0.0043235109, 0.0043216888, 0.0043198671, 0.0043180883, 0.0043163737, 0.0043146163, 0.0043129013, 0.0043112081, 0.0043095155, 0.0043078647, 0.0043062363, 0.0043046502, 0.0043030856, 0.0043014782, 0.0042999564, 0.0042984346, 0.0042969128, 0.0042954772, 0.0042940411, 0.0042925836, 0.0042911693, 0.0042897761, 0.0042883828, 0.0042870538, 0.0042857253, 0.0042844391, 0.0042831744, 0.0042818887, 0.0042806459, 0.0042794454, 0.004278224, 0.0042770877, 0.004275952, 0.0042747944, 0.0042737015, 0.0042726086, 0.0042715366, 0.0042704865, 0.0042694793, 0.0042684935, 0.0042675291, 0.0042665647, 0.0042656213, 0.0042646998, 0.0042638425, 0.0042629638, 0.0042621279, 0.0042612921, 0.0042604776, 0.004259706, 0.0042589344, 0.0042581842, 0.0042574774, 0.0042568129, 0.0042561484, 0.0042554839, 0.0042548412, 0.0042542405, 0.0042536622, 0.0042531048, 0.0042525693, 0.0042520333, 0.0042515406, 0.0042510689, 0.0042505758, 0.0042501474, 0.0042497399, 0.0042493758, 0.0042490112, 0.0042486684, 0.0042483252, 0.0042480254, 0.0042477469, 0.0042475108, 0.0042472752, 0.004247061, 0.0042468468, 0.0042466754, 0.004246504, 0.0042463751, 0.0042463322, 0.0042462251, 0.0042461609, 0.004246118, 0.0042460752, 0.0042460752, 0.004246118, 0.0042461823, 0.0042462465, 0.0042463322, 0.0042464179, 0.0042465678, 0.0042467183, 0.0042468682, 0.0042471252, 0.004247318, 0.0042475541, 0.0042478326, 0.0042480896, 0.00424839, 0.0042487327, 0.0042490973, 0.0042494829, 0.0042498684, 0.0042502545, 0.0042507043, 0.004251176, 0.0042516687, 0.0042521618, 0.0042526978, 0.0042532119, 0.0042537907, 0.0042543695, 0.0042549698, 0.0042556124, 0.0042562769, 0.0042569628, 0.0042576701, 0.0042583561, 0.0042591058, 0.0042598778, 0.0042606704, 0.0042614848, 0.0042623207, 0.004263157, 0.0042640143, 0.0042649144, 0.0042658146, 0.0042667575, 0.0042677219, 0.0042687077, 0.0042697154, 0.0042707226, 0.0042717727, 0.0042728442, 0.0042739585, 0.0042750733, 0.004276209, 0.0042773453, 0.0042785238, 0.0042797243, 0.0042809243, 0.0042821676, 0.0042834319, 0.0042847395, 0.0042860466, 0.0042873542, 0.0042887041, 0.004290076, 0.0042914907, 0.0042929053, 0.004294341, 0.0042957771, 0.0042972774, 0.0042987778, 0.0043002777, 0.0043018209, 0.0043034498, 0.0043050144, 0.0043066218, 0.0043082293, 0.0043098796, 0.0043115728, 0.0043132873, 0.0043150019, 0.0043167598, 0.0043184957, 0.004320296, 0.0043220958, 0.0043238965, 0.0043258038, 0.0043276688, 0.0043295543, 0.0043314621, 0.0043334127, 0.0043353415, 0.0043373345, 0.0043393495, 0.0043413853, 0.0043434217, 0.004345479, 0.0043475577, 0.0043496797, 0.0043518231, 0.0043539875, 0.0043561738, 0.0043583387, 0.0043605673, 0.0043628179, 0.004365047, 0.0043673404, 0.0043696333, 0.0043720123, 0.0043743486, 0.0043767062, 0.0043791067, 0.0043815286, 0.0043839719, 0.0043864362, 0.0043889224, 0.004391409, 0.0043939375, 0.0043964884, 0.0043990389, 0.0044016321, 0.0044042468, 0.0044068829, 0.0044095409, 0.0044122199, 0.0044148988, 0.0044176206, 0.0044203852, 0.0044231503, 0.0044259578, 0.0044287224, 0.0044315732, 0.0044344235, 0.0044372743, 0.0044401679, 0.0044430825, 0.0044460399, 0.0044489978, 0.0044519985, 0.0044549773, 0.0044579995, 0.0044610216, 0.004464129, 0.0044672368, 0.0044703232, 0.0044734525, 0.0044766027, 0.0044797747, 0.0044829682, 0.004486226, 0.0044894624, 0.0044927201, 0.0044960207, 0.0044992999, 0.0045026219, 0.0045059654, 0.0045093731, 0.0045127808, 0.0045161676, 0.0045195962, 0.0045230682, 0.0045265192, 0.0045300769, 0.0045336131, 0.0045371284, 0.0045407075, 0.0045442865, 0.0045478875, 0.0045515094, 0.0045551741, 0.0045588822, 0.0045625689, 0.0045662764, 0.0045700273, 0.0045737778, 0.0045775496, 0.0045814076, 0.0045852442, 0.0045890594, 0.0045929383, 0.0045968392, 0.0046007396, 0.0046046833, 0.0046086269, 0.0046126349, 0.0046166428, 0.0046206503, 0.0046247016, 0.0046287733, 0.004632846, 0.0046369825, 0.0046411403, 0.0046452549, 0.0046494347, 0.0046536354, 0.0046578362, 0.0046620797, 0.0046663661, 0.0046706526, 0.0046749818, 0.0046793111, 0.0046836408, 0.0046880129, 0.0046923854, 0.0046968427, 0.0047012796, 0.0047057378, 0.004710217, 0.0047147181, 0.0047192187, 0.0047237622, 0.0047283485, 0.0047329566, 0.0047375648, 0.004742194, 0.0047468236, 0.0047515174, 0.0047562108, 0.0047609475, 0.0047657057, 0.0047704638, 0.0047752429, 0.0047800438, 0.0047848662, 0.00478971, 0.0047946181, 0.0047995048, 0.0048044128, 0.0048093633, 0.0048142932, 0.004819287, 0.0048242807, 0.0048293388, 0.0048343753, 0.0048394334, 0.0048445128, 0.0048496351, 0.0048547578, 0.0048599443, 0.0048651309, 0.0048703179, 0.0048755258, 0.0048807766, 0.0048860274, 0.0048913001, 0.0048966152, 0.0049019735, 0.0049073314, 0.0049127112, 0.0049180691, 0.0049234917, 0.0049289139, 0.0049344222, 0.0049399091, 0.0049453955, 0.0049509038, 0.0049564545, 0.0049620057, 0.0049675996, 0.0049732151, 0.0049788733, 0.0049845311, 0.0049902108, 0.0049958904, 0.0050016129, 0.0050073569, 0.0050131436, 0.0050189304, 0.0050247172, 0.0050305468, 0.0050363978, 0.0050422703, 0.0050481427, 0.0050540795, 0.0050599948, 0.0050659962, 0.0050719758, 0.0050779553, 0.0050839782, 0.0050900434, 0.0050961301, 0.0051022167, 0.0051083253, 0.0051144548, 0.0051206062, 0.0051267785, 0.0051329727, 0.0051391879, 0.0051454678, 0.0051517258, 0.0051580057, 0.0051643071, 0.0051706298, 0.0051769735, 0.005183382, 0.0051897685, 0.0051961984, 0.0052026068, 0.005209079, 0.0052155522, 0.0052220458, 0.0052286042, 0.0052351416, 0.0052417, 0.0052483012, 0.0052549024, 0.0052615246, 0.0052681901, 0.005274856, 0.0052815853, 0.0052883155, 0.0052950238, 0.0053017964, 0.0053085904, 0.0053153844, 0.0053222426, 0.0053291013, 0.0053359596, 0.0053428612, 0.0053497623, 0.0053566848, 0.0053636506, 0.0053706164, 0.005377667, 0.0053846976, 0.0053917272, 0.0053987997, 0.0054058935, 0.0054130093, 0.0054201465, 0.0054273051, 0.0054344633, 0.0054416647, 0.0054488876, 0.0054561105, 0.0054633971, 0.0054706633, 0.0054780142, 0.0054853437, 0.0054926742, 0.005500047, 0.0055074412, 0.0055148783, 0.0055223154, 0.0055297953, 0.0055372533, 0.0055447551, 0.0055522565, 0.0055598007, 0.0055673872, 0.0055749533, 0.0055826046, 0.0055902344, 0.0055978862, 0.0056055589, 0.0056132535, 0.005620969, 0.0056287488, 0.0056365286, 0.0056442879, 0.0056520887, 0.0056599332, 0.0056677563, 0.0056756432, 0.0056835515, 0.0056914603, 0.005699412, 0.0057073631, 0.0057153357, 0.0057233516, 0.0057313461, 0.0057394472, 0.0057475064, 0.0057555865, 0.0057636877, 0.0057718325, 0.0057799765, 0.0057881423, 0.0057963724, 0.0058046025, 0.0058128322, 0.0058210841, 0.005829378, 0.0058376938, 0.0058460096, 0.0058543901, 0.0058627701, 0.0058711502, 0.0058795521, 0.0058879959, 0.0058964621, 0.0059049707, 0.0059134793, 0.0059219878, 0.0059305392, 0.0059390916, 0.0059476639, 0.00595628, 0.0059649176, 0.0059735975, 0.0059822779, 0.0059909793, 0.0059996806, 0.0060084253, 0.0060171909, 0.0060259998, 0.0060348301, 0.006043639, 0.0060524908, 0.0060613635, 0.0060702367, 0.0060791527, 0.0060880897, 0.0060970704, 0.0061060721, 0.0061150519, 0.0061240755, 0.0061331196, 0.0061421851, 0.0061513158, 0.006160425, 0.0061695548, 0.0061787064, 0.0061878795, 0.006197074, 0.0062062899, 0.0062155062, 0.0062248078, 0.0062341089, 0.006243411, 0.0062527345, 0.0062620789, 0.0062714447, 0.0062808748, 0.0062903054, 0.0062997141, 0.0063091875, 0.0063186605, 0.0063281553, 0.0063376715, 0.0063472302, 0.0063568316, 0.0063664122, 0.0063760141, 0.006385637, 0.0063953032, 0.0064049694, 0.0064146994, 0.0064244298, 0.0064341598, 0.0064439122, 0.0064537069, 0.0064635016, 0.0064733173, 0.0064832186, 0.0064930781, 0.0065029804, 0.0065129031, 0.006522805, 0.0065327715, 0.0065427581, 0.0065527889, 0.0065628192, 0.0065728496, 0.0065829232, 0.0065930178, 0.0066031124, 0.0066132932, 0.0066234521, 0.0066336105, 0.0066438126, 0.0066540362, 0.0066642594, 0.0066745253, 0.0066847913, 0.0066951439, 0.0067054741, 0.0067158043, 0.0067261774, 0.0067365728, 0.0067469887, 0.0067574694, 0.0067679281, 0.0067783874, 0.0067888889, 0.0067994338, 0.0068099573, 0.0068205236, 0.0068311109, 0.0068417205, 0.0068523935, 0.0068630241, 0.0068736975, 0.0068844138, 0.0068951086, 0.0069058891, 0.0069166701, 0.0069274502, 0.0069382521, 0.0069490755, 0.0069599207, 0.0069707865, 0.0069816955, 0.0069925836, 0.0070035574, 0.0070145302, 0.007025504, 0.0070364987, 0.0070475149, 0.0070585958, 0.0070696762, 0.0070807571, 0.0070918589, 0.007103004, 0.0071141487, 0.0071253153, 0.0071365242, 0.0071477764, 0.0071590068, 0.0071702804, 0.0071815536, 0.0071928483, 0.0072041652, 0.0072155246, 0.0072269477, 0.0072383285, 0.0072497306, 0.0072611757, 0.0072726207, 0.0072840867, 0.0072956602, 0.00730717, 0.0073187212, 0.0073302952, 0.0073418687, 0.0073534637, 0.0073651015, 0.0073767607, 0.0073884628, 0.0074001653, 0.0074118674, 0.0074236118, 0.0074353572, 0.0074471883, 0.0074590188, 0.0074708275, 0.00748268, 0.0074945535, 0.0075064274, 0.0075183436, 0.0075303032, 0.0075422414, 0.0075527392, 0.0075621265, 0.0075715138, 0.0075809658, 0.0075905137, 0.0076000406, 0.0076095778, 0.0076191584, 0.0076287384, 0.0076384372, 0.0076481346, 0.0076578446, 0.0076675643, 0.0076773581, 0.0076872283, 0.0076970658, 0.0077069355, 0.007716815, 0.0077267704, 0.0077367369, 0.0077467887, 0.007756819, 0.0077668494, 0.0077769654, 0.0077871033, 0.0077972836, 0.0078074853, 0.0078177089, 0.0078279637, 0.0078382632, 0.0078486037, 0.0078589553, 0.0078693721, 0.0078797881, 0.0078902794, 0.0079007596, 0.0079112835, 0.0079218494, 0.0079324152, 0.0079430249, 0.0079536978, 0.0079643922, 0.0079750987, 0.0079858461, 0.007996616, 0.0080074286, 0.0080182953, 0.008029161, 0.0080400705, 0.0080510443, 0.0080619957, 0.0080729919, 0.0080840504, 0.0080951089, 0.0081062326, 0.0081173349, 0.0081285229, 0.0081397211, 0.0081509408, 0.0081622032, 0.0081735086, 0.0081848251, 0.0081962068, 0.0082075866, 0.0082190111, 0.0082304655, 0.0082419645, 0.0082534952, 0.0082650688, 0.0082766423, 0.0082882587, 0.0082999077, 0.0083115771, 0.0083233006, 0.0083350465, 0.0083468333, 0.0083586425, 0.0083704954, 0.0083823903, 0.0083942637, 0.008406234, 0.0084182043, 0.0084302276, 0.008442251, 0.0084543284, 0.0084664272, 0.0084785791, 0.0084907208, 0.0085029155, 0.0085151428, 0.0085274456, 0.008539726, 0.0085520493, 0.0085643949, 0.0085768038, 0.0085891914, 0.0086016869, 0.0086141825, 0.008626678, 0.0086392369, 0.0086518172, 0.0086644515, 0.0086771082, 0.0086897537, 0.0087025268, 0.008715258, 0.0087280106, 0.0087408265, 0.008753676, 0.0087665459, 0.0087794699, 0.0087924143, 0.0088053597, 0.0088183694, 0.0088314004, 0.0088444743, 0.0088575697, 0.0088707292, 0.0088838991, 0.0088970698, 0.0089103151, 0.0089235818, 0.0089368587, 0.0089502009, 0.0089635635, 0.0089769596, 0.0089903865, 0.0090038357, 0.0090173269, 0.0090308515, 0.0090443753, 0.0090580061, 0.0090716053, 0.0090852575, 0.0090989424, 0.0091126589, 0.0091263968, 0.0091401786, 0.0091539808, 0.009167837, 0.0091817137, 0.0091956239, 0.0092095658, 0.0092235291, 0.0092375353, 0.0092515741, 0.0092656221, 0.0092797251, 0.0092938598, 0.0093080159, 0.0093222251, 0.0093364352, 0.0093507096, 0.0093650259, 0.0093793431, 0.0093936818, 0.0094081052, 0.0094225081, 0.0094369855, 0.0094514852, 0.0094659738, 0.0094805257, 0.0094950991, 0.0095097171, 0.0095243445, 0.0095390258, 0.0095537277, 0.0095684957, 0.009583273, 0.0095981145, 0.0096129356, 0.0096277883, 0.0096427277, 0.0096576652, 0.0096726678, 0.0096876277, 0.0097026955, 0.0097177615, 0.0097328182, 0.0097479718, 0.0097631449, 0.0097783506, 0.009793547, 0.0098088291, 0.009824099, 0.0098394342, 0.0098547796, 0.0098701892, 0.0098856101, 0.0099010523, 0.0099165691, 0.0099320645, 0.009947625, 0.0099632069, 0.0099788308, 0.0099944761, 0.010010144, 0.010025875, 0.010041595, 0.01005738, 0.010073177, 0.010089037, 0.010104897, 0.01012081, 0.010136724, 0.010152712, 0.010168691, 0.010184754, 0.010200807, 0.010216903, 0.01023302, 0.010249201, 0.010265404, 0.010281607, 0.010297853, 0.010314185, 0.010330484, 0.010346849, 0.010363222, 0.010379662, 0.01039612, 0.010412613, 0.010429127, 0.010445673, 0.01046224, 0.010478883, 0.010495492, 0.010512199, 0.010528916, 0.010545678, 0.010562438, 0.010579229, 0.010596085, 0.010612931, 0.010629831, 0.010646796, 0.010663748, 0.010680766, 0.010697784, 0.010714854, 0.010731946, 0.010749071, 0.010766238, 0.010783426, 0.01080066, 0.010817934, 0.010835218, 0.010852527, 0.010869896, 0.010887289, 0.010904692, 0.010922139, 0.010939638, 0.010957139, 0.01097468, 0.010992265, 0.011009873, 0.011027543, 0.011045204, 0.011062918, 0.011080673, 0.011098441, 0.011116252, 0.011134105, 0.011151959, 0.011169855, 0.011187794, 0.011205753, 0.011223779, 0.011241793, 0.01125987, 0.011277983, 0.011296093, 0.011314267, 0.011332421, 0.01135066, 0.011368919, 0.011387213, 0.01140557, 0.011423894, 0.011442294, 0.011460694, 0.011479147, 0.011497664, 0.01151616, 0.011534689, 0.011553282, 0.011571884, 0.01159051, 0.011609199, 0.011627911, 0.011646663, 0.011665428, 0.011684234, 0.011703052, 0.011721934, 0.011740836, 0.011759805, 0.011778762, 0.011797741, 0.011816773, 0.011835827, 0.011854922, 0.011874062, 0.011893222, 0.011912426, 0.01193163, 0.011950897, 0.011970164, 0.011989475, 0.012008829, 0.012028237, 0.012047644, 0.012067114, 0.012086585, 0.012106111, 0.012125657, 0.012145204, 0.012164814, 0.012184468, 0.012204165, 0.012223883, 0.012243601, 0.01226336, 0.012283186, 0.012303011, 0.0123229, 0.0123428, 0.012362721, 0.012382686, 0.012402683, 0.012422712, 0.012442783, 0.012462898, 0.012483022, 0.012503169, 0.01252336, 0.01254357, 0.012563823, 0.012584129, 0.012604437, 0.012624798, 0.01264518, 0.012665585, 0.012686031, 0.01270651, 0.012727021, 0.012747584, 0.01276816, 0.012788777, 0.012809408, 0.012830079, 0.012850782, 0.012871519, 0.012892297, 0.012913109, 0.01293394, 0.012954793, 0.01297568, 0.01299663, 0.013017613, 0.013038583, 0.01305961, 0.013080688, 0.013101757, 0.013122888, 0.013144043, 0.013165262, 0.0131865, 0.013207719, 0.013229033, 0.013250327, 0.013271695, 0.013293073, 0.013314494, 0.01333596, 0.013357392, 0.013378921, 0.013400471, 0.013422042, 0.013443626, 0.013465295, 0.013486984, 0.013508673, 0.013530406, 0.013552192, 0.013573999, 0.013595817, 0.0136177, 0.013639582, 0.013661508, 0.013683497, 0.013705467, 0.013727498, 0.013749552, 0.013771628, 0.013793767, 0.013815929, 0.013838132, 0.013860337, 0.013882595, 0.013904874, 0.013927196, 0.013949582, 0.013971936, 0.013994355, 0.014016793, 0.014039257, 0.01406177, 0.014084317, 0.014106897, 0.014129507, 0.01415214, 0.014174815, 0.014197523, 0.014220274, 0.014243035, 0.014265819, 0.014288698, 0.014311512, 0.014334445, 0.014357356, 0.014380311, 0.014403328, 0.014426347, 0.014449431, 0.014472502, 0.014495628, 0.014518787, 0.014541955, 0.014565198, 0.014588431, 0.014611717, 0.014635036, 0.014658376, 0.014681759, 0.014705162, 0.014728642, 0.0147521, 0.014775611, 0.014799165, 0.014822731, 0.014846338, 0.014869967, 0.01489364, 0.014917354, 0.01494108, 0.014964849, 0.014988628, 0.015012472, 0.015036338, 0.015060255, 0.015084174, 0.015108136, 0.015132139, 0.015156155, 0.015180212, 0.015204303, 0.015228435, 0.01525257, 0.015276766, 0.015300965, 0.015325225, 0.015349507, 0.015373814, 0.01539816, 0.015422572, 0.01544694, 0.015471427, 0.015495912, 0.01552039, 0.015544961, 0.015569513, 0.01559414, 0.015618785, 0.015643444, 0.015668167, 0.015692877, 0.015717655, 0.01574244, 0.015767282, 0.015792131, 0.015817037, 0.015841963, 0.015866932, 0.015891921, 0.015916934, 0.015941989, 0.015967073, 0.015992204, 0.016017344, 0.016042549, 0.016067775, 0.016093012, 0.016118292, 0.016143614, 0.016168946, 0.016194334, 0.016219743, 0.016245194, 0.01627099, 0.01629688, 0.016322792, 0.016348766, 0.016374808, 0.016400827, 0.016426954, 0.016453143, 0.016479399, 0.016505674, 0.016532015, 0.016558355, 0.016584825, 0.016611293, 0.016637849, 0.016664447, 0.016691087, 0.016717812, 0.016744476, 0.01677133, 0.016798185, 0.016825104, 0.016852064, 0.016879028, 0.016906098, 0.016933231, 0.016960364, 0.016987605, 0.017014867, 0.017042171, 0.017069563, 0.017096996, 0.017124429, 0.01715197, 0.017179532, 0.017207159, 0.017234849, 0.017262563, 0.017290382, 0.01731818, 0.017346084, 0.017374011, 0.017402023, 0.017430058, 0.017458176, 0.017486317, 0.017514478, 0.017542727, 0.01757106, 0.017599395, 0.017627813, 0.017656276, 0.017684782, 0.017713286, 0.01774192, 0.017770598, 0.017799316, 0.017828101, 0.017856905, 0.017885797, 0.017914666, 0.017943665, 0.017972726, 0.018001789, 0.018030938, 0.018060127, 0.018089363, 0.01811864, 0.018147958, 0.018177342, 0.018206812, 0.018236281, 0.018265858, 0.018295413, 0.018325076, 0.018354781, 0.018384552, 0.018414365, 0.01844422, 0.018474139, 0.018504102, 0.018534064, 0.018564155, 0.018594269, 0.018624444, 0.018654685, 0.018684948, 0.018715233, 0.018745601, 0.018776037, 0.018806534, 0.018837055, 0.01886766, 0.018898308, 0.018928958, 0.018959669, 0.018990489, 0.019021332, 0.019052237, 0.019083185, 0.019114176, 0.019145189, 0.019176308, 0.019207451, 0.019238656, 0.019269926, 0.019301239, 0.019332595, 0.019364037, 0.019395456, 0.019426962, 0.019458532, 0.019490166, 0.019521909, 0.019553564, 0.019585326, 0.019617196, 0.019649023, 0.019680979, 0.019712979, 0.019744998, 0.019777104, 0.019809209, 0.01984138, 0.019873656, 0.019905936, 0.019938298, 0.019970704, 0.020003131, 0.0200356, 0.020068178, 0.020100776, 0.020133419, 0.020166146, 0.020198938, 0.02023175, 0.020264564, 0.020297483, 0.020330448, 0.020363497, 0.020396566, 0.020429701, 0.020462835, 0.020496035, 0.020529341, 0.020562667, 0.020596059, 0.020629495, 0.020662971, 0.020696534, 0.020730099, 0.020763747, 0.020797439, 0.020831171, 0.020864971, 0.020898815, 0.020932721, 0.020966671, 0.021000663, 0.021034697, 0.021068817, 0.021103023, 0.02113723, 0.021171458, 0.021205749, 0.021240128, 0.021274567, 0.021309054, 0.021343581, 0.021378152, 0.021412764, 0.021447401, 0.021482162, 0.021516949, 0.021551775, 0.021586668, 0.021621605, 0.02165658, 0.021691602, 0.021726685, 0.021761836, 0.021797072, 0.021832306, 0.021867603, 0.021902926, 0.021938331, 0.021973804, 0.022009274, 0.022044893, 0.022080492, 0.022116138, 0.022151841, 0.022187591, 0.022223428, 0.022259284, 0.022295225, 0.022331189, 0.022367217, 0.022403266, 0.022439381, 0.022475578, 0.022511842, 0.022548126, 0.022584477, 0.022620827, 0.022657262, 0.02269374, 0.022730306, 0.02276687, 0.022803562, 0.022840232, 0.022876987, 0.022913808, 0.022950608, 0.022987537, 0.023024529, 0.023061521, 0.023098599, 0.023135742, 0.023172842, 0.023210071, 0.023247343, 0.023284698, 0.023322055, 0.023359476, 0.02339696, 0.023434469, 0.023472039, 0.023509672, 0.023547374, 0.023585116, 0.023622902, 0.023660731, 0.023698581, 0.023736527, 0.023774538, 0.023812588, 0.023850698, 0.023888849, 0.023927037, 0.023965264, 0.024003575, 0.024041928, 0.024080366, 0.024118828, 0.02415733, 0.024195855, 0.024234468, 0.024273163, 0.024311868, 0.024350643, 0.024389496, 0.024428366, 0.024467297, 0.02450623, 0.024545271, 0.024584383, 0.024623509, 0.0246627, 0.024701942, 0.024741216, 0.024780553, 0.024819959, 0.024859393, 0.024898883, 0.024938481, 0.024978079, 0.025017736, 0.025057387, 0.025097156, 0.025136966, 0.025176842, 0.025216751, 0.025256721, 0.025296701, 0.02533677, 0.025376892, 0.025417088, 0.025457306, 0.025497576, 0.025537927, 0.025578294, 0.025618693, 0.025659168, 0.025699709, 0.025740301, 0.025780946, 0.025821658, 0.025862347, 0.025903134, 0.025943995, 0.025984908, 0.026025856, 0.026066868, 0.02610792, 0.026149029, 0.026190147, 0.026231362, 0.026272608, 0.026313929, 0.026355328, 0.026396712, 0.026438151, 0.026479667, 0.026521236, 0.026562888, 0.026604556, 0.026646292, 0.026688088, 0.026729913, 0.02677175, 0.026813714, 0.026855668, 0.026897751, 0.026939841, 0.02698197, 0.027024128, 0.02706637, 0.027108688, 0.027151039, 0.02719342, 0.027235901, 0.02727841, 0.027320912, 0.027363531, 0.027406203, 0.027448919, 0.027491687, 0.027534511, 0.027577372, 0.02762025, 0.027663222, 0.027706267, 0.027749326, 0.027792489, 0.027835635, 0.027878894, 0.027922124, 0.027965464, 0.028008875, 0.028052285, 0.028095782, 0.028139332, 0.028182916, 0.028226553, 0.028270254, 0.028313974, 0.028357804, 0.028401664, 0.028445559, 0.028489517, 0.028533477, 0.028577551, 0.028621683, 0.028665833, 0.028710047, 0.028754326, 0.028798627, 0.02884298, 0.02888741, 0.028931886, 0.028976399, 0.029020999, 0.029065622, 0.029110266, 0.029155038, 0.029199788, 0.029244658, 0.029289549, 0.029334482, 0.02937948, 0.02942452, 0.029469579, 0.029514739, 0.029559942, 0.029605195, 0.029650504, 0.029695876, 0.029741228, 0.029786706, 0.029832209, 0.029877784, 0.029923404, 0.029969066, 0.030014791, 0.030060517, 0.03010634, 0.030152226, 0.030198133, 0.030244129, 0.030290166, 0.030336246, 0.030382348, 0.030428534, 0.030474765, 0.030521069, 0.030567406, 0.030613806, 0.030660231, 0.030706704, 0.030753259, 0.030799851, 0.030846508, 0.030893212, 0.030939978, 0.030986784, 0.031033605, 0.031080542, 0.031127477, 0.031174492, 0.031221598, 0.031268686, 0.0313159, 0.031363063, 0.031410322, 0.031457689, 0.031505045, 0.031552471, 0.031599969, 0.031647474, 0.031695053, 0.031742696, 0.031790383, 0.031838123, 0.031885918, 0.03193377, 0.031981647, 0.032029573, 0.03207757, 0.032125618, 0.032173757, 0.032221884, 0.032270085, 0.03231832, 0.03236663, 0.032414991, 0.032463405, 0.032511886, 0.032560401, 0.032608964, 0.032657582, 0.032706223, 0.032754943, 0.032803733, 0.032852557, 0.032901432, 0.032950383, 0.032999337, 0.033048388, 0.033097453, 0.033146597, 0.033195797, 0.033245038, 0.033294331, 0.03334368, 0.033393059, 0.033442505, 0.033492003, 0.033541568, 0.033591148, 0.033640854, 0.033690546, 0.033740256, 0.033790089, 0.033839971, 0.033889886, 0.033939861, 0.033989891, 0.034039944, 0.034090057, 0.034140218, 0.034190446, 0.034240745, 0.034291059, 0.034341458, 0.034391858, 0.034442328, 0.034492899, 0.03454347, 0.034594104, 0.034644816, 0.034695577, 0.03474636, 0.034797166, 0.034848079, 0.034899045, 0.034950066, 0.035001107, 0.035052214, 0.03510334, 0.035154551, 0.035205819, 0.035257161, 0.035308521, 0.03535993, 0.035411421, 0.03546289, 0.03551447, 0.035566106, 0.035617772, 0.035669956, 0.035722788, 0.035775684, 0.03582862, 0.035881642, 0.035934757, 0.035987929, 0.036041167, 0.036094449, 0.036147859, 0.036201201, 0.036254697, 0.0363083, 0.036361884, 0.036415637, 0.036469366, 0.036523182, 0.036577046, 0.03663101, 0.036685042, 0.036739137, 0.036793254, 0.036847502, 0.036901787, 0.036956094, 0.037010517, 0.037065018, 0.037119582, 0.03717415, 0.03722889, 0.037283588, 0.03733841, 0.03739332, 0.037448209, 0.03750325, 0.037558332, 0.037613478, 0.03766866, 0.037723918, 0.037779298, 0.037834659, 0.037890147, 0.037945703, 0.038001273, 0.038056955, 0.038112681, 0.03816849, 0.038224343, 0.038280237, 0.038336288, 0.038392331, 0.038448483, 0.03850466, 0.038560875, 0.038617264, 0.038673609, 0.038730107, 0.038786627, 0.038843207, 0.038899876, 0.038956583, 0.039013378, 0.039070219, 0.039127123, 0.039184131, 0.039241187, 0.039298322, 0.039355464, 0.039412729, 0.039470062, 0.039527439, 0.039584897, 0.039642379, 0.039700013, 0.039757643, 0.039815318, 0.039873101, 0.039930969, 0.039988879, 0.040046852, 0.040104896, 0.040162995, 0.040221144, 0.040279441, 0.040337715, 0.040396053, 0.040454499, 0.040513013, 0.040571585, 0.040630203, 0.040688906, 0.040747721, 0.040806483, 0.040865421, 0.040924363, 0.040983368, 0.041042499, 0.041101653, 0.041160937, 0.041220177, 0.041279543, 0.041338976, 0.041398428, 0.041457988, 0.04151766, 0.041577328, 0.041637037, 0.041696899, 0.041756783, 0.041816723, 0.041876778, 0.041936852, 0.041996952, 0.04205722, 0.042117488, 0.04217786, 0.042238262, 0.042298719, 0.04235927, 0.042419877, 0.042480573, 0.042541314, 0.042602096, 0.042662989, 0.042723916, 0.042785004, 0.042845976, 0.042907126, 0.042968374, 0.043029632, 0.043090969, 0.043152377, 0.043213803, 0.043275379, 0.043336973, 0.043398656, 0.043460362, 0.043522194, 0.043584026, 0.043645944, 0.043707952, 0.043770038, 0.043832194, 0.043894343, 0.043956585, 0.044018954, 0.044081323, 0.044143777, 0.044206299, 0.044268858, 0.044331547, 0.044394258, 0.044457056, 0.044519901, 0.044582754, 0.04464579, 0.044708867, 0.044771966, 0.04483515, 0.044898417, 0.044961728, 0.045025084, 0.045088563, 0.045152046, 0.045215596, 0.045279313, 0.045342967, 0.045406748, 0.045470618, 0.045534488, 0.045598488, 0.045662481, 0.045726649, 0.045790821, 0.045855075, 0.045919348, 0.045983713, 0.046048179, 0.046112627, 0.046177223, 0.046241846, 0.046306528, 0.046371337, 0.04643615, 0.046501074, 0.046565995, 0.046630993, 0.046696149, 0.046761286, 0.046826523, 0.046891809, 0.046957135, 0.047022566, 0.047088083, 0.047153648, 0.047219232, 0.04728492, 0.047350697, 0.047416519, 0.047482401, 0.047548328, 0.047614343, 0.047680456, 0.04774658, 0.047812801, 0.047879066, 0.047945388, 0.048011843, 0.04807831, 0.048144855, 0.048211493, 0.048278168, 0.04834491, 0.048411693, 0.048478559, 0.048545491, 0.048612554, 0.048679598, 0.048746701, 0.048813958, 0.048881188, 0.048948575, 0.049015939, 0.049083363, 0.049150962, 0.049218513, 0.049286202, 0.049353927, 0.049421716, 0.049489614, 0.049557514, 0.049625542, 0.049693584, 0.049761698, 0.049829878, 0.04989814, 0.049966488, 0.050034858, 0.050103288, 0.050171856, 0.05024042, 0.050309129, 0.050377797, 0.050446596, 0.050515436, 0.050584324, 0.050653335, 0.050722387, 0.050791532, 0.050860692, 0.050929941, 0.050999258, 0.051068649, 0.051138073, 0.051207557, 0.051277149, 0.051346801, 0.051416501, 0.051486287, 0.051556114, 0.051626023, 0.051696021, 0.051766019, 0.051836148, 0.051906295, 0.051976535, 0.05204685, 0.052117217, 0.052187663, 0.052258156, 0.052328713, 0.052399397, 0.05247004, 0.052540805, 0.052611664, 0.052682515, 0.05275346, 0.052824508, 0.052895639, 0.052966759, 0.053037979, 0.053109281, 0.053180631, 0.05325209, 0.053323559, 0.053395107, 0.053466734, 0.053538378, 0.053610183, 0.053681999, 0.053753883, 0.053825811, 0.053897824, 0.053969901, 0.054042064, 0.054114297, 0.054186538, 0.054258879, 0.054331336, 0.054403778, 0.054476351, 0.054548945, 0.054621596, 0.054694358, 0.054767128, 0.054840039, 0.054912973, 0.054985955, 0.055059079, 0.055132184, 0.055205416, 0.055278655, 0.055351973, 0.055425387, 0.055498853, 0.055572428, 0.055645969, 0.055719629, 0.055793379, 0.055867169, 0.055941068, 0.056014944, 0.056088973, 0.056162998, 0.056237116, 0.056311335, 0.056385577, 0.056459907, 0.056534298, 0.056608774, 0.056683272, 0.056757838, 0.056832548, 0.056907222, 0.056982003, 0.057056889, 0.057131775, 0.057206783, 0.057281796, 0.05735692, 0.05743213, 0.057507332, 0.057582688, 0.057658065, 0.057733446, 0.057808973, 0.057884589, 0.057960223, 0.058035947, 0.058111709, 0.058187533, 0.058263443, 0.058339361, 0.058415446, 0.058491535, 0.058567699, 0.058643941, 0.058720239, 0.058796559, 0.05887305, 0.058949545, 0.059026141, 0.059102744, 0.059179429, 0.0592562, 0.059333015, 0.059409935, 0.059486873, 0.059563909, 0.059640955, 0.059718154, 0.059795395, 0.059872661, 0.059950013, 0.06002745, 0.060104929, 0.060182467, 0.060260117, 0.060337789, 0.060415525, 0.060493372, 0.060571235, 0.060649205, 0.060727201, 0.060805276, 0.06088344, 0.060961604, 0.061039921, 0.061118271, 0.061196655, 0.061275136, 0.06135371, 0.061432324, 0.06151098, 0.061589703, 0.061668511, 0.061747361, 0.061826319, 0.061905317, 0.061984386, 0.062063552, 0.062142704, 0.062222004, 0.062301323, 0.062380716, 0.062460184, 0.062539741, 0.062619314, 0.062699005, 0.062778711, 0.062858485, 0.062938385, 0.063018262, 0.063098274, 0.063178368, 0.063258432, 0.063338652, 0.063418925, 0.063499227, 0.063579649, 0.063660085, 0.063740604, 0.063821189, 0.063901842, 0.063982539, 0.064063333, 0.064144172, 0.064225063, 0.06430608, 0.064387128, 0.06446825, 0.064549424, 0.06463065, 0.064711966, 0.064793341, 0.064874768, 0.064956293, 0.065037847, 0.065119505, 0.065201223, 0.065282986, 0.065364823, 0.065446757, 0.065528668, 0.065610737, 0.06569282, 0.065774992, 0.065857232, 0.065939531, 0.066021875, 0.066104323, 0.066186793, 0.066269375, 0.066352017, 0.066434711, 0.066517435, 0.066600293, 0.066683218, 0.066766135, 0.066849142, 0.066932268, 0.067015402, 0.06709864, 0.06718193, 0.067265302, 0.067348674, 0.06743215, 0.067515738, 0.067599341, 0.067683019, 0.067766793, 0.06785062, 0.067934468, 0.068018414, 0.068102457, 0.068186514, 0.068270631, 0.06835489, 0.068439178, 0.068523474, 0.068607874, 0.068692379, 0.068776935, 0.068861507, 0.068946205, 0.069030926, 0.069115736, 0.069200613, 0.069285549, 0.069370575, 0.069455594, 0.069540739, 0.069625959, 0.069711193, 0.069796562, 0.069881946, 0.069967397, 0.070052914, 0.070138559, 0.070224203, 0.070310488, 0.07039804, 0.070485674, 0.070573315, 0.070661083, 0.070748895, 0.070836782, 0.070924722, 0.071012788, 0.071100868, 0.071189009, 0.071277283, 0.071365565, 0.071453929, 0.07154236, 0.071630903, 0.07171946, 0.071808107, 0.071896836, 0.07198561, 0.072074451, 0.072163388, 0.072252356, 0.072341435, 0.072430544, 0.072519772, 0.072609037, 0.07269837, 0.072787784, 0.072877221, 0.072966762, 0.073056392, 0.073146045, 0.07323581, 0.073325627, 0.07341554, 0.073505491, 0.073595487, 0.073685564, 0.073775753, 0.073865987, 0.073956281, 0.074046642, 0.074137084, 0.074227616, 0.074318185, 0.074408799, 0.074499525, 0.074590296, 0.074681148, 0.07477206, 0.074863046, 0.074954107, 0.075045221, 0.075136416, 0.075227693, 0.075319044, 0.075410426, 0.075501882, 0.075593449, 0.075685069, 0.075776711, 0.075868465, 0.075960279, 0.076052159, 0.076144084, 0.076236136, 0.076328233, 0.076420389, 0.076512642, 0.076604925, 0.076697275, 0.076789699, 0.076882206, 0.076974764, 0.077067412, 0.077160113, 0.077252917, 0.077345744, 0.077438675, 0.077531673, 0.077624708, 0.077717811, 0.077811018, 0.077904314, 0.077997595, 0.07809101, 0.078184478, 0.078278013, 0.078371607, 0.07846529, 0.078559034, 0.078652844, 0.078746744, 0.078840673, 0.078934707, 0.079028793, 0.079122923, 0.079217143, 0.07931146, 0.079405852, 0.079500221, 0.079594739, 0.079689339, 0.079783969, 0.079878658, 0.079973407, 0.080068268, 0.080163188, 0.080258161, 0.080353208, 0.080448329, 0.080543533, 0.080638751, 0.080734111, 0.080829509, 0.080924988, 0.081020467, 0.081116103, 0.081211776, 0.081307516, 0.081403315, 0.081499211, 0.08159516, 0.081691176, 0.081787258, 0.081883401, 0.081979617, 0.082075886, 0.082172252, 0.08226867, 0.082365185, 0.082461759, 0.082558401, 0.08265508, 0.082751893, 0.082848705, 0.082945615, 0.083042577, 0.083139643, 0.083236761, 0.083333939, 0.083431192, 0.083528504, 0.08362589, 0.083723389, 0.083820924, 0.083918527, 0.084016144, 0.084113874, 0.084211729, 0.084309578, 0.084407523, 0.084505513, 0.084603593, 0.084701747, 0.084799998, 0.084898241, 0.08499667, 0.085095033, 0.085193537, 0.085292131, 0.085390724, 0.085489452, 0.08558818, 0.085687026, 0.085785933, 0.085884959, 0.085983977, 0.086083077, 0.086182274, 0.086281516, 0.086380854, 0.086480223, 0.086579703, 0.086679205, 0.086778797, 0.086878471, 0.086978227, 0.087078042, 0.087177865, 0.087277807, 0.087377831, 0.087477893, 0.087578028, 0.087678261, 0.087778546, 0.087878898, 0.087979332, 0.08807984, 0.088180393, 0.088280991, 0.088381708, 0.088482469, 0.088583305, 0.088684231, 0.088785186, 0.088886186, 0.088987321, 0.089088514, 0.089189783, 0.089291081, 0.089392468, 0.089493923, 0.08959543, 0.089697018, 0.089798696, 0.089900404, 0.090002194, 0.090104066, 0.090206005, 0.09030804, 0.090410113, 0.090512231, 0.090614468, 0.090716742, 0.090819098, 0.090921499, 0.091023959, 0.091126546, 0.091229171, 0.091331869, 0.091434643, 0.091537468, 0.091640353, 0.091743357, 0.091846377, 0.091949485, 0.092052646, 0.092155881, 0.092259228, 0.092362583, 0.092466034, 0.092569575, 0.09267316, 0.092776828, 0.092880569, 0.092984349, 0.093088172, 0.093192093, 0.093296133, 0.093400195, 0.093504354, 0.093608573, 0.093712829, 0.093817174, 0.093921572, 0.094026081, 0.094130665, 0.094235264, 0.094339959, 0.094444692, 0.094549552, 0.094654463, 0.094759397, 0.094864428, 0.094969541, 0.095074736, 0.09517999, 0.095285282, 0.095390648, 0.095496096, 0.095601626, 0.095707178, 0.095812865, 0.095918573, 0.096024357, 0.096130289, 0.096236192, 0.096342206, 0.09644825, 0.096554369, 0.096660562, 0.096766829, 0.096873216, 0.096979611, 0.097086065, 0.097192623, 0.097299293, 0.097405963, 0.097512722, 0.097619541, 0.09772642, 0.097833388, 0.097940415, 0.098047517, 0.098154694, 0.098261908, 0.098369226, 0.098476619, 0.098584071, 0.098691583, 0.098799154, 0.098906793, 0.09901455, 0.099122345, 0.099230185, 0.099338092, 0.099446103, 0.099554166, 0.099662304, 0.099770524, 0.099878781, 0.099987097, 0.1000955, 0.10020402, 0.10031257, 0.10042115, 0.10052986, 0.1006386, 0.10074741, 0.10085636, 0.10096531, 0.10107433, 0.10118341, 0.10129259, 0.10140183, 0.10151112, 0.10162049, 0.10172994, 0.10183945, 0.10194902, 0.1020587, 0.1021684, 0.10227817, 0.10238805, 0.10249797, 0.10260794, 0.10271803, 0.10282815, 0.10293835, 0.1030486, 0.10315893, 0.10326937, 0.10337982, 0.10349039, 0.10360102, 0.10371168, 0.10382242, 0.10393324, 0.10404411, 0.10415508, 0.10426611, 0.10437722, 0.10448837, 0.10459962, 0.10471092, 0.10482229, 0.10493371, 0.10504525, 0.1051568, 0.10526843, 0.10538017, 0.10549197, 0.10560379, 0.10571571, 0.10582773, 0.1059398, 0.10605188, 0.10616411, 0.10627638, 0.1063887, 0.10650111, 0.10661356, 0.10672612, 0.10683871, 0.10695139, 0.10706417, 0.10717699, 0.1072899, 0.10740282, 0.10751581, 0.10762891, 0.10774207, 0.10785533, 0.10796862, 0.10808197, 0.10819541, 0.10830894, 0.1084225, 0.10853615, 0.10864987, 0.10876362, 0.1088775, 0.10899141, 0.10910537, 0.10921945, 0.10933357, 0.10944775, 0.10956203, 0.10967635, 0.10979079, 0.10990521, 0.11001979, 0.11013437, 0.11024903, 0.11036378, 0.1104786, 0.11059348, 0.11070843, 0.11082348, 0.11093856, 0.11105374, 0.11116896, 0.11128424, 0.11139961, 0.11151503, 0.11163055, 0.11174608, 0.11186172, 0.11197746, 0.11209323, 0.1122091, 0.11232498, 0.11244097, 0.11255701, 0.11267315, 0.11278934, 0.11290558, 0.1130219, 0.11313833, 0.11325481, 0.11337134, 0.11348795, 0.11360461, 0.11372136, 0.11383815, 0.11395505, 0.11407202, 0.11418899, 0.11430609, 0.11442325, 0.11454046, 0.11465776, 0.11477512, 0.11489257, 0.11501007, 0.1151276, 0.11524526, 0.11536297, 0.11548072, 0.11559857, 0.11571648, 0.11583446, 0.11595251, 0.11607063, 0.11618883, 0.11630707, 0.11642545, 0.11654381, 0.11666226, 0.11678079, 0.1168994, 0.11701807, 0.11713681, 0.11725564, 0.11737452, 0.11749342, 0.11761247, 0.11773153, 0.11785071, 0.11796989, 0.11808921, 0.11820854, 0.11832796, 0.11844749, 0.11856707, 0.11868668, 0.1188064, 0.11892616, 0.11904599, 0.1191659, 0.11928589, 0.11940593, 0.11952604, 0.11964624, 0.11976649, 0.1198868, 0.12000722, 0.12012766, 0.12024821, 0.12036879, 0.12048947, 0.12061021, 0.12073097, 0.12085187, 0.12097281, 0.1210938, 0.1212149, 0.12133605, 0.12145728, 0.12157857, 0.12169993, 0.12182134, 0.12194283, 0.12206437, 0.12218602, 0.12230772, 0.12242945, 0.12255131, 0.12267535, 0.12280127, 0.12292728, 0.12305328, 0.12317936, 0.12330551, 0.1234317, 0.12355793, 0.12368419, 0.12381054, 0.1239369, 0.12406334, 0.12418983, 0.12431633, 0.12444291, 0.12456952, 0.12469622, 0.12482292, 0.12494969, 0.1250765, 0.12520337, 0.12533028, 0.12545726, 0.12558427, 0.12571134, 0.12583846, 0.12596563, 0.12609284, 0.12622006, 0.12634738, 0.12647472, 0.12660214, 0.12672959, 0.12685712, 0.12698467, 0.12711224, 0.1272399, 0.1273676, 0.12749533, 0.12762314, 0.12775096, 0.12787884, 0.1280068, 0.1281348, 0.12826285, 0.12839095, 0.12851907, 0.12864727, 0.12877549, 0.12890378, 0.12903211, 0.12916049, 0.12928891, 0.12941737, 0.12954593, 0.12967454, 0.12980314, 0.12993181, 0.13006052, 0.1301893, 0.13031815, 0.130447, 0.13057593, 0.13070488, 0.13083389, 0.13096297, 0.1310921, 0.13122128, 0.13135046, 0.13147973, 0.13160901, 0.13173841, 0.13186781, 0.13199727, 0.13212675, 0.1322563, 0.13238589, 0.13251559, 0.13264531, 0.13277505, 0.13290481, 0.13303469, 0.13316458, 0.13329452, 0.13342451, 0.13355455, 0.13368464, 0.13381477, 0.13394497, 0.13407524, 0.13420554, 0.13433585, 0.13446626, 0.13459665, 0.13472718, 0.13485771, 0.13498825, 0.13511887, 0.13524957, 0.1353803, 0.13551109, 0.1356419, 0.13577276, 0.1359037, 0.13603467, 0.13616569, 0.13629676, 0.13642789, 0.13655905, 0.13669027, 0.13682152, 0.13695286, 0.13708423, 0.13721561, 0.13734707, 0.1374786, 0.13761015, 0.13774177, 0.13787341, 0.13800514, 0.13813686, 0.13826866, 0.13840054, 0.13853244, 0.13866441, 0.1387964, 0.13892843, 0.13906053, 0.13919266, 0.13932486, 0.13945709, 0.13958938, 0.13972175, 0.13985416, 0.13998657, 0.14011906, 0.14025161, 0.14038417, 0.14051682, 0.14064953, 0.14078224, 0.14091498, 0.14104782, 0.14118072, 0.14131367, 0.14144662, 0.14157966, 0.14171271, 0.14184582, 0.14197902, 0.14211224, 0.1422455, 0.14237884, 0.14251217, 0.14264558, 0.14277908, 0.14291261, 0.14304614, 0.14317976, 0.14331344, 0.14344715, 0.14358088, 0.14371468, 0.14384854, 0.14398244, 0.14411639, 0.14425041, 0.14438446, 0.14451857, 0.14465271, 0.14478691, 0.14492117, 0.14505546, 0.14518981, 0.14532417, 0.14545861, 0.14559311, 0.14572765, 0.14586227, 0.1459969, 0.14613159, 0.14626631, 0.14640109, 0.14653593, 0.1466708, 0.14680575, 0.14694072, 0.14707577, 0.14721085, 0.14734598, 0.14748116, 0.14761636, 0.14775163, 0.14788696, 0.14802234, 0.14815773, 0.1482932, 0.14842872, 0.14856428, 0.14869991, 0.14883558, 0.1489713, 0.14910707, 0.14924286, 0.14937873, 0.14951465, 0.14965057, 0.14978662, 0.14992267, 0.15005873, 0.1501949, 0.15033112, 0.15046738, 0.15060367, 0.15074003, 0.1508764, 0.15101285, 0.15114935, 0.1512859, 0.15142247, 0.15155911, 0.1516958, 0.15183255, 0.15196934, 0.1521062, 0.15224308, 0.15238, 0.15251699, 0.15265402, 0.1527911, 0.15292823, 0.15306541, 0.15320262, 0.15333992, 0.15347725, 0.15361463, 0.15375204, 0.15388951, 0.15402706, 0.1541646, 0.15430221, 0.15443988, 0.1545776, 0.15471536, 0.15485319, 0.15499108, 0.15512897, 0.15526694, 0.15540496, 0.155543, 0.1556811, 0.15581927, 0.15595748, 0.15609571, 0.156234, 0.1563724, 0.15651077, 0.15664923, 0.15678775, 0.15692627, 0.15706488, 0.15720351, 0.15734223, 0.15748096, 0.15761974, 0.15775859, 0.15789749, 0.15803643, 0.15817542, 0.15831445, 0.15845354, 0.15859266, 0.15873186, 0.15887107, 0.15901034, 0.15914971, 0.15928906, 0.15942849, 0.15956798, 0.1597075, 0.15984708, 0.1599867, 0.16012639, 0.1602661, 0.16040584, 0.16054571, 0.16068554, 0.16082545, 0.16096544, 0.16110545, 0.16124551, 0.16138561, 0.16152579, 0.16166599, 0.16180624, 0.16194654, 0.16208692, 0.1622273, 0.16236776, 0.16250828, 0.16264884, 0.16278943, 0.16293007, 0.16307078, 0.16321152, 0.16335231, 0.16349316, 0.16363405, 0.16377498, 0.16391599, 0.16405703, 0.16419812, 0.16433926, 0.16448045, 0.1646217, 0.16476297, 0.16490431, 0.16504568, 0.16518711, 0.16532858, 0.16547012, 0.1656117, 0.16575333, 0.16589503, 0.16603674, 0.16617851, 0.16632034, 0.16646221, 0.16660412, 0.16674605, 0.1668881, 0.16703019, 0.16717227, 0.16731447, 0.16745669, 0.16759895, 0.16774124, 0.1678836, 0.168026, 0.16816846, 0.16831098, 0.16845353, 0.16859613, 0.16873881, 0.16888151, 0.16902424, 0.16916704, 0.16930987, 0.16945279, 0.16959575, 0.16973874, 0.16988178, 0.17002484, 0.170168, 0.17031121, 0.17045447, 0.17059773, 0.1707411, 0.17088446, 0.17102788, 0.17117137, 0.17131491, 0.17145848, 0.17160212, 0.17174578, 0.17188951, 0.17203331, 0.17217715, 0.17232101, 0.17246492, 0.17260891, 0.17275293, 0.172897, 0.17304111, 0.17318529, 0.17332952, 0.17347375, 0.17361808, 0.17376244, 0.17390685, 0.17405131, 0.17419586, 0.1743404, 0.17448498, 0.17462967, 0.17477438, 0.17491911, 0.17506392, 0.17520876, 0.17535371, 0.17549862, 0.17564365, 0.17578867, 0.17593378, 0.17607892, 0.17622413, 0.17636934, 0.17651464, 0.17665997, 0.17680535, 0.17695083, 0.17709634, 0.17724186, 0.17738745, 0.17753306, 0.17767876, 0.1778245, 0.17797026, 0.17811607, 0.17826197, 0.17840789, 0.17855386, 0.17869993, 0.17884599, 0.17899209, 0.17913829, 0.1792845, 0.17943077, 0.1795771, 0.17972346, 0.17986988, 0.18001634, 0.18016288, 0.18030943, 0.18045604, 0.1806027, 0.18074939, 0.18089615, 0.18104295, 0.18118982, 0.18133672, 0.18148367, 0.18163069, 0.18177775, 0.18192485, 0.18207197, 0.18221922, 0.18236642, 0.18251374, 0.18266107, 0.18280846, 0.18295589, 0.1831034, 0.18325093, 0.18339853, 0.18354617, 0.18369389, 0.1838416, 0.18398938, 0.18413724, 0.18428512, 0.18443303, 0.18458098, 0.18472904, 0.1848771, 0.18502524, 0.18517344, 0.18532163, 0.18546991, 0.18561827, 0.18576661, 0.18591504, 0.1860635, 0.18621203, 0.1863606, 0.18650921, 0.18665789, 0.18680659, 0.18695533, 0.18710417, 0.18725303, 0.18740192, 0.18755089, 0.18769991, 0.18784894, 0.18799804, 0.18814722, 0.18829644, 0.18844569, 0.18859495, 0.18874434, 0.18889372, 0.18904313, 0.18919268, 0.18934219, 0.18949179, 0.18964143, 0.18979113, 0.18994087, 0.19009066, 0.19024052, 0.19039039, 0.19054031, 0.19069029, 0.19084035, 0.19099042, 0.19114055, 0.19129075, 0.19144094, 0.19159125, 0.19174485, 0.19190116, 0.19205745, 0.1922137, 0.19237, 0.19252624, 0.19268249, 0.19283874, 0.19299495, 0.19315116, 0.19330736, 0.19346358, 0.19361973, 0.19377591, 0.19393206, 0.19408821, 0.19424435, 0.19440049, 0.19455658, 0.19471268, 0.19486879, 0.19502488, 0.19518094, 0.195337, 0.19549307, 0.1956491, 0.19580512, 0.19596112, 0.19611713, 0.19627313, 0.1964291, 0.19658509, 0.19674104, 0.196897, 0.19705293, 0.19720887, 0.19736479, 0.19752069, 0.19767658, 0.19783245, 0.19798833, 0.19814421, 0.19830005, 0.19845589, 0.19861169, 0.19876753, 0.19892332, 0.19907913, 0.19923493, 0.19939068, 0.19954646, 0.19970219, 0.19985795, 0.20001368, 0.2001694, 0.20032513, 0.20048082, 0.20063648, 0.20079218, 0.20094784, 0.20110348, 0.20125912, 0.20141475, 0.20157036, 0.20172599, 0.2018816, 0.20203717, 0.20219275, 0.20234831, 0.20250387, 0.20265944, 0.20281494, 0.20297049, 0.20312597, 0.20328146, 0.20343697, 0.20359245, 0.20374791, 0.20390336, 0.20405883, 0.20421426, 0.20436965, 0.20452508, 0.20468049, 0.20483586, 0.20499124, 0.20514661, 0.20530196, 0.20545729, 0.20561264, 0.20576796, 0.20592326, 0.2060786, 0.20623387, 0.20638916, 0.20654441, 0.2066997, 0.20685492, 0.20701015, 0.20716541, 0.20732063, 0.2074758, 0.20763098, 0.20778616, 0.20794134, 0.20809649, 0.20825166, 0.20840679, 0.20856191, 0.20871703, 0.20887212, 0.20902723, 0.20918232, 0.20933738, 0.20949244, 0.20964749, 0.20980255, 0.20995758, 0.21011257, 0.21026759, 0.21042256, 0.21057755, 0.21073252, 0.21088751, 0.21104245, 0.21119736, 0.21135229, 0.21150723, 0.21166213, 0.21181703, 0.21197192, 0.21212679, 0.21228163, 0.21243651, 0.21259134, 0.21274616, 0.21290098, 0.2130558, 0.21321058, 0.21336536, 0.21352017, 0.21367492, 0.21382967, 0.21398439, 0.21413915, 0.21429385, 0.21444856, 0.21460326, 0.21475793, 0.21491262, 0.21506728, 0.21522194, 0.21537657, 0.21553119, 0.21568586, 0.21584044, 0.21599503, 0.21614964, 0.21630421, 0.21645877, 0.21661331, 0.21676788, 0.21692239, 0.2170769, 0.21723145, 0.21738595, 0.21754041, 0.21769492, 0.21784936, 0.21800381, 0.21815826, 0.21831271, 0.21846712, 0.21862152, 0.21877593, 0.21893033, 0.21908469, 0.21923907, 0.21939343, 0.21954778, 0.21970212, 0.21985643, 0.22001073, 0.22016503, 0.22031935, 0.2204736, 0.22062787, 0.22078213, 0.2209364, 0.22109063, 0.22124486, 0.22139908, 0.22155327, 0.22170745, 0.22186165, 0.22201583, 0.22216998, 0.22232412, 0.22247827, 0.22263238, 0.2227865, 0.22294059, 0.2230947, 0.22324878, 0.22340283, 0.22355692, 0.22371098, 0.22386499, 0.22401907, 0.22417304, 0.22432703, 0.22448102, 0.224635, 0.22478899, 0.22494295, 0.22509693, 0.22525084, 0.22540477, 0.22555868, 0.22571261, 0.2258665, 0.22602038, 0.22617425, 0.2263281, 0.22648194, 0.22663581, 0.22678962, 0.22694343, 0.22709727, 0.22725105, 0.22740485, 0.22755861, 0.22771238, 0.22786613, 0.22801988, 0.2281736, 0.22832732, 0.22848104, 0.22863473, 0.22878842, 0.22894211, 0.22909574, 0.2292494, 0.22940306, 0.22955666, 0.2297103, 0.22986393, 0.23001751, 0.23017111, 0.23032469, 0.23047826, 0.2306318, 0.23078535, 0.23093887, 0.23109242, 0.23124593, 0.2313994, 0.2315529, 0.23170638, 0.23185986, 0.23201331, 0.23216677, 0.23232019, 0.23247361, 0.23262702, 0.23278041, 0.2329338, 0.2330872, 0.23324054, 0.23339391, 0.23354726, 0.23370059, 0.23385392, 0.23400724, 0.23416053, 0.23431382, 0.23446709, 0.23462039, 0.23477364, 0.23492688, 0.23508011, 0.23523334, 0.23538654, 0.23553975, 0.23569295, 0.23584612, 0.23599932, 0.23615247, 0.23630562, 0.23645875, 0.23661186, 0.23676498, 0.23691808, 0.23707116, 0.23722424, 0.23737735, 0.2375304, 0.23768346, 0.23783647, 0.23798949, 0.23814252, 0.23829551, 0.23844852, 0.23860151, 0.23875447, 0.23890746, 0.2390604, 0.23921332, 0.23936626, 0.23951918, 0.23967208, 0.23982498, 0.23997788, 0.24013075, 0.24028361, 0.24043646, 0.24058928, 0.24074212, 0.24089493, 0.24104775, 0.24120055, 0.24135333, 0.24150613, 0.24165888, 0.2418116, 0.24196436, 0.24211709, 0.24226983, 0.24242251, 0.24257523, 0.24272791, 0.24288058, 0.24303326, 0.24318591, 0.24333854, 0.24349117, 0.24364378, 0.24379642, 0.24394901, 0.24410161, 0.24425417, 0.24440673, 0.24455929, 0.24471182, 0.24486437, 0.24501689, 0.2451694, 0.24532188, 0.24547441, 0.24562688, 0.24577932, 0.24593176, 0.24608424, 0.24623668, 0.24638909, 0.2465415, 0.24669392, 0.24684629, 0.24699867, 0.24715105, 0.2473034, 0.24745578, 0.2476081, 0.24776042, 0.24791273, 0.24806501, 0.24821731, 0.24836957, 0.24852186, 0.24867412, 0.24882638, 0.24897863, 0.24913083, 0.24928305, 0.24943523, 0.24958743, 0.24973963, 0.24989179, 0.25004396, 0.25019613, 0.25034824, 0.25050035, 0.25065249, 0.2508046, 0.25095668, 0.25110877, 0.25126082, 0.2514129, 0.25156495, 0.251717, 0.25186902, 0.25202101, 0.25217304, 0.25232503, 0.25247699, 0.25262898, 0.25278094, 0.25293291, 0.25308481, 0.25323674, 0.25338867, 0.25354061, 0.25369248, 0.25384435, 0.25399625, 0.2541481, 0.25429997, 0.25445178, 0.25460362, 0.25475544, 0.25490722, 0.25505903, 0.25521085, 0.2553626, 0.25551438, 0.25566614, 0.25581786, 0.25596958, 0.25612131, 0.25627303, 0.25642473, 0.25657642, 0.25672811, 0.25687975, 0.25703141, 0.25718305, 0.25733468, 0.25748628, 0.25763792, 0.25778949, 0.2579411, 0.25809267, 0.25824425, 0.25839582, 0.25854737, 0.25869888, 0.25885043, 0.25900191, 0.2591534, 0.25930491, 0.2594564, 0.25960782, 0.25975931, 0.25991076, 0.26006219, 0.26021361, 0.26036504, 0.26051641, 0.2606678, 0.26081917, 0.26097053, 0.2611219, 0.26127324, 0.2614246, 0.26157591, 0.26172724, 0.26187852, 0.26202983, 0.2621811, 0.26233238, 0.26248363, 0.26263487, 0.26278612, 0.26293734, 0.26308855, 0.26323977, 0.26339096, 0.26354215, 0.2636933, 0.26384449, 0.26399562, 0.26414675, 0.26429787, 0.264449, 0.2646001, 0.2647512, 0.26490226, 0.26505336, 0.26520443, 0.26535547, 0.26550651, 0.26565754, 0.26580855, 0.26595953, 0.26611057, 0.26626155, 0.2664125, 0.26656348, 0.26671442, 0.26686534, 0.26701626, 0.26716721, 0.26731813, 0.26746899, 0.26761988, 0.26777077, 0.26792163, 0.26807249, 0.26822335, 0.26837415, 0.26852494, 0.26867568, 0.26882631, 0.26897687, 0.26912734, 0.26927766, 0.26942793, 0.26957807, 0.26972815, 0.26987812, 0.270028, 0.27017778, 0.27032745, 0.27047703, 0.27062657, 0.27077597, 0.27092525, 0.27107447, 0.2712236, 0.27137262, 0.27152154, 0.27167037, 0.27181911, 0.27196774, 0.2721163, 0.27226475, 0.2724131, 0.27256137, 0.27270955, 0.27285761, 0.2730056, 0.27315348, 0.27330127, 0.27344897, 0.27359658, 0.27374408, 0.27389148, 0.27403882, 0.27418604, 0.27433315, 0.27448019, 0.27462712, 0.27477396, 0.27492073, 0.27506739, 0.27521396, 0.27536041, 0.27550676, 0.275653, 0.27579921, 0.27594528, 0.27609128, 0.27623719, 0.27638298, 0.27652869, 0.2766743, 0.2768198, 0.27696523, 0.27711055, 0.2772558, 0.27740091, 0.27754596, 0.27769092, 0.27783576, 0.27798054, 0.27812514, 0.27826974, 0.27841419, 0.27855858, 0.27870288, 0.27884704, 0.27899116, 0.27913517, 0.27927905, 0.27942285, 0.27956656, 0.2797102, 0.2798537, 0.27999714, 0.28014046, 0.28028372, 0.28042686, 0.28056991, 0.28071287, 0.28085575, 0.2809985, 0.28114116, 0.28128374, 0.28142619, 0.28156859, 0.28171089, 0.28185308, 0.28199518, 0.28213722, 0.2822791, 0.28242093, 0.28256264, 0.28270426, 0.2828458, 0.28298724, 0.28312859, 0.28326985, 0.28341097, 0.28355205, 0.28369299, 0.28383389, 0.28397465, 0.28411531, 0.28425592, 0.28439641, 0.28453681, 0.28467709, 0.28481731, 0.28495744, 0.28509742, 0.28523737, 0.28537717, 0.28551692, 0.28565654, 0.28579608, 0.28593555, 0.28607488, 0.28621414, 0.28635329, 0.28649238, 0.28663135, 0.28677022, 0.28690901, 0.28704768, 0.28718629, 0.28732479, 0.28746319, 0.2876015, 0.28773969, 0.28787783, 0.28801584, 0.2881538, 0.28829163, 0.28842938, 0.28856701, 0.28870454, 0.28884202, 0.28897938, 0.28911662, 0.28925383, 0.28939092, 0.28952786, 0.28966475, 0.28980157, 0.28993824, 0.29007486, 0.29021135, 0.29034775, 0.2904841, 0.2906203, 0.29075643, 0.29089248, 0.29102841, 0.29116428, 0.2913, 0.29143566, 0.29157123, 0.29170668, 0.29184204, 0.29197732, 0.29211247, 0.29224762, 0.29238257, 0.29251748, 0.29265228, 0.29278699, 0.2929216, 0.2930561, 0.29319054, 0.29332486, 0.29345912, 0.29359323, 0.29372728, 0.29386124, 0.29399505, 0.29412884, 0.2942625, 0.29439607, 0.29452953, 0.29466289, 0.2947962, 0.29492939, 0.29506248, 0.29519546, 0.29532838, 0.29546121, 0.29559392, 0.29572651, 0.29585904, 0.29599148, 0.29612383, 0.29625607, 0.29638824, 0.29652026, 0.29665223, 0.29678407, 0.29691583, 0.29704753, 0.2971791, 0.29731056, 0.29744196, 0.29757327, 0.29770446, 0.29783556, 0.29796657, 0.29809746, 0.29822829, 0.29835904, 0.29848963, 0.29862016, 0.29875064, 0.29888096, 0.29901123, 0.29914141, 0.29927146, 0.29940137, 0.29953128, 0.29966104, 0.29979071, 0.29992029, 0.30004981, 0.30017918, 0.3003085, 0.30043772, 0.30056682, 0.30069584, 0.30082476, 0.30095357, 0.30108231, 0.30121097, 0.30133948, 0.30146796, 0.30159631, 0.30172458, 0.30185273, 0.30198079, 0.30210876, 0.30223665, 0.30236441, 0.30249211, 0.30261973, 0.30274722, 0.30287462, 0.30300191, 0.30312917, 0.30325627, 0.30338329, 0.30351025, 0.30363706, 0.30376381, 0.30389044, 0.30401701, 0.30414346, 0.30426982, 0.30439609, 0.30452228, 0.30464834, 0.30477434, 0.30490023, 0.305026