// Class: ReadLikelihoodPCA
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::LikelihoodPCA
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:48:37 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
VarTransform: "PCA" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
TransformOutput: "False" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <cmath>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihoodPCA : public IClassifierReader {

 public:

   // constructor
   ReadLikelihoodPCA( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihoodPCA" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = -12.2913999557495;
      fVmax[0] = 8.98888778686523;
      fVmin[1] = -4.06073760986328;
      fVmax[1] = 3.7533814907074;
      fVmin[2] = -2.0543258190155;
      fVmax[2] = 1.94801652431488;
      fVmin[3] = -1.11983454227448;
      fVmax[3] = 1.0790308713913;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

      // initialize transformation
      InitTransform();
   }

   // destructor
   virtual ~ReadLikelihoodPCA() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // input variable transformation

   void X2P_1( const double*, double*, int ) const;
   double fMeanValues_1[3][4];
   double fEigenVectors_1[3][4][4];

   void InitTransform_1();
   void Transform_1( std::vector<double> & iv, int sigOrBgd ) const;
   void InitTransform();
   void Transform( std::vector<double> & iv, int sigOrBgd ) const;

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[4]; 
   int    fNbin[4]; // number of bins (discrete variables may have less bins)
   double    fHistMin[4]; 
   double    fHistMax[4]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihoodPCA::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = -13.2135343551636;
   fHistMax[0] = 9.91688251495361;
   fNbin[1] = 10000;
   fHistMin[1] = -3.94512987136841;
   fHistMax[1] = 4.18769359588623;
   fNbin[2] = 10000;
   fHistMin[2] = -2.02666306495667;
   fHistMax[2] = 2.209801197052;
   fNbin[3] = 10000;
   fHistMin[3] = -1.32731580734253;
   fHistMax[3] = 1.28500306606293;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
}

inline double ReadLikelihoodPCA::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   Transform(inputValuesSig,0);
   Transform(inputValuesBgd,1);
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihoodPCA: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihoodPCA::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (false) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihoodPCA::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihoodPCA::fRefS[][10000] = 
{ 
   { 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 2.7787498311227e-06, 8.18999887997052e-06, 1.36012486109394e-05, 1.90211012522923e-05, 2.4415145162493e-05, 2.98005870718043e-05, 3.51860253431369e-05, 4.05886748922057e-05, 4.59569055237807e-05, 5.13251397933345e-05, 5.67019778827671e-05, 6.20616119704209e-05, 6.7404042056296e-05, 7.27464648662135e-05, 7.8088887676131e-05, 8.34313177620061e-05, 8.8756532932166e-05, 9.4064547738526e-05, 9.94069705484435e-05, 0.000104706385172904, 0.000110005807073321, 0.000115296599688008, 0.000120587414130569, 0.000125886828755029, 0.000131160428281873, 0.000136451228172518, 0.000141716242069378, 0.000146964026498608, 0.000152220425661653, 0.000157468210090883, 0.000162724609253928, 0.000167955207871273, 0.000173177191754803, 0.000178424976184033, 0.000183638359885663, 0.000188843143405393, 0.000194039312191308, 0.000199261310626753, 0.000204448879230767, 0.000209636447834782, 0.000214815416256897, 0.000220002999412827, 0.000225173353101127, 0.000230326535529457, 0.000235488274483941, 0.000240650057094172, 0.000245794595684856, 0.000250921963015571, 0.000256057915976271, 0.000261202454566956, 0.000266312621533871, 0.000271422788500786, 0.000276541511993855, 0.00028165167896077, 0.000286744616460055, 0.000291837524855509, 0.000296913291094825, 0.000302006228594109, 0.000307073350995779, 0.000312140473397449, 0.000317216210532933, 0.000322266161674634, 0.000327307468978688, 0.000332348776282743, 0.000337381527060643, 0.000342422834364697, 0.000347446941304952, 0.000352479662979022, 0.000357486569555476, 0.000362493505235761, 0.000367491797078401, 0.000372481503291056, 0.000377479795133695, 0.000382460915716365, 0.00038743342156522, 0.000392414513044059, 0.000397378433262929, 0.000402325124014169, 0.000407280400395393, 0.000412227091146633, 0.000417173781897873, 0.000422103243181482, 0.000427032733568922, 0.000431962223956361, 0.000436874513980001, 0.000441786804003641, 0.00044668186455965, 0.00045159415458329, 0.000456480629509315, 0.00046136710443534, 0.000466236378997564, 0.000471122824819759, 0.000475983484648168, 0.000480844144476578, 0.000485696218675002, 0.000490556820295751, 0.000495391723234206, 0.000500235182698816, 0.000505078583955765, 0.00050989625742659, 0.000514713930897415, 0.000519522931426764, 0.000524323375429958, 0.000529132434166968, 0.000533932878170162, 0.000538716150913388, 0.000543507980182767, 0.000548274023458362, 0.000553048623260111, 0.000557814608328044, 0.000562580651603639, 0.000567329523619264, 0.000572078337427229, 0.000576809979975224, 0.000581550120841712, 0.000586281821597368, 0.000590996176470071, 0.000595727819018066, 0.000600433617364615, 0.000605139415711164, 0.000609828042797744, 0.000614516669884324, 0.000619213853497058, 0.000623893865849823, 0.000628556648734957, 0.000633236602880061, 0.000637890829239041, 0.000642545055598021, 0.000647190609015524, 0.000651827605906874, 0.000656481774058193, 0.000661110156215727, 0.000665729923639446, 0.000670358305796981, 0.0006749780732207, 0.000679572054650635, 0.000684174650814384, 0.000688777246978134, 0.000693362613674253, 0.000697947922162712, 0.000702533288858831, 0.000707101484294981, 0.000711661006789654, 0.000716211972758174, 0.000720762938726693, 0.000725322519429028, 0.000729864812456071, 0.000734389992430806, 0.00073893234366551, 0.00074344890890643, 0.000747956859413534, 0.000752464751712978, 0.000756964087486267, 0.000761480652727187, 0.000765971373766661, 0.000770444923546165, 0.000774935644585639, 0.000779409194365144, 0.000783874129410833, 0.000788330449722707, 0.000792803999502212, 0.000797251705080271, 0.000801690795924515, 0.000806112715508789, 0.000810569035820663, 0.000814982340671122, 0.000819395645521581, 0.000823817565105855, 0.000828230869956315, 0.000832627003546804, 0.000837014464195818, 0.000841419212520123, 0.000845798116642982, 0.000850168347824365, 0.000854538637213409, 0.000858917541336268, 0.000863270659465343, 0.000867615162860602, 0.000871959608048201, 0.000876321282703429, 0.000880640000104904, 0.000884967332240194, 0.000889285933226347, 0.000893621880095452, 0.000897923309821635, 0.000902216124814004, 0.000906517670955509, 0.000910819100681692, 0.000915103300940245, 0.000919379061087966, 0.000923671876080334, 0.000927930406760424, 0.000932188821025193, 0.000936438678763807, 0.000940688536502421, 0.000944938336033374, 0.00094917108071968, 0.000953412323724478, 0.000957644893787801, 0.000961860409006476, 0.000966058578342199, 0.000970274035353214, 0.000974472262896597, 0.00097867043223232, 0.00098286010324955, 0.000987058389000595, 0.000991230714134872, 0.000995394540950656, 0.000999549869447947, 0.00100371357984841, 0.00100787752307951, 0.00101201550569385, 0.00101615348830819, 0.00102030020207167, 0.00102442956995219, 0.0010285418247804, 0.00103266257792711, 0.00103677471634001, 0.0010408783564344, 0.00104497326537967, 0.00104905979242176, 0.00105316331610084, 0.00105724111199379, 0.00106130167841911, 0.00106537085957825, 0.00106944004073739, 0.00107349210884422, 0.00107753544580191, 0.00108158751390874, 0.00108563085086644, 0.00108965707477182, 0.00109368318226188, 0.00109770079143345, 0.0011017182841897, 0.00110572727862746, 0.00110972765833139, 0.00111371953971684, 0.00111771118827164, 0.00112169445492327, 0.00112566887401044, 0.00112965202424675, 0.00113360944669694, 0.00113756686914712, 0.00114151556044817, 0.00114548159763217, 0.00114941305946559, 0.00115334463771433, 0.00115727609954774, 0.00116119044832885, 0.00116511341184378, 0.00116902776062489, 0.00117293349467218, 0.00117682199925184, 0.00118071911856532, 0.00118460773956031, 0.00118848751299083, 0.00119235890451819, 0.0011962215648964, 0.00120010157115757, 0.00120394711848348, 0.00120780116412789, 0.0012116467114538, 0.00121547502931207, 0.00121931196190417, 0.00122313154861331, 0.00122695998288691, 0.00123077968601137, 0.00123458215966821, 0.00123838463332504, 0.00124217849224806, 0.00124596385285258, 0.00124974909704179, 0.0012535258429125, 0.00125729397404939, 0.00126107060350478, 0.00126483011990786, 0.00126858102157712, 0.00127233192324638, 0.00127606559544802, 0.00127979926764965, 0.00128353293985128, 0.0012872579973191, 0.00129096582531929, 0.00129468226805329, 0.0012983902124688, 0.00130208942573518, 0.00130577152594924, 0.0013094621244818, 0.00131314422469586, 0.00131681771017611, 0.00132048258092254, 0.00132415594998747, 0.00132780359126627, 0.00133145984727889, 0.00133509887382388, 0.00133873801678419, 0.00134236842859536, 0.00134599022567272, 0.00134962063748389, 0.00135323393624276, 0.00135683850385249, 0.00136043457314372, 0.00136403052601963, 0.00136762659531087, 0.00137120543513447, 0.00137478427495807, 0.00137836311478168, 0.00138191611040384, 0.00138548633549362, 0.00138903083279729, 0.00139258371200413, 0.00139611959457397, 0.0013996553607285, 0.00140318262856454, 0.00140671839471906, 0.00141022843308747, 0.00141373847145587, 0.00141723977867514, 0.00142074120230973, 0.00142423389479518, 0.00142771820537746, 0.00143120239954442, 0.00143467797897756, 0.00143814494367689, 0.0014416032936424, 0.00144507025834173, 0.00144851149525493, 0.00145196123048663, 0.00145539385266602, 0.00145882635843009, 0.00146225036587566, 0.00146567437332124, 0.00146908964961767, 0.00147249642759562, 0.00147589459083974, 0.00147929287049919, 0.00148268230259418, 0.0014860718511045, 0.0014894442865625, 0.00149281660560519, 0.00149618892464787, 0.00149954413063824, 0.00150289060547948, 0.00150623719673604, 0.00150958367157727, 0.0015129130333662, 0.00151624239515513, 0.00151956314221025, 0.00152289250399917, 0.00152619602158666, 0.00152949953917414, 0.00153280305676162, 0.00153608934488147, 0.00153937574941665, 0.0015426620375365, 0.00154593982733786, 0.00154920888599008, 0.00155246932990849, 0.00155572139192373, 0.00155897322110832, 0.00156221655197442, 0.0015654512681067, 0.00156868598423898, 0.00157191196922213, 0.0015751380706206, 0.00157834705896676, 0.00158156454563141, 0.00158476491924375, 0.00158795656170696, 0.00159113958943635, 0.00159433134831488, 0.00159751437604427, 0.00160068029072136, 0.00160384608898312, 0.00160700338892639, 0.00161016068886966, 0.00161330075934529, 0.00161644082982093, 0.00161958101671189, 0.00162271235603839, 0.0016258351970464, 0.00162895815446973, 0.00163206376601011, 0.00163516937755048, 0.00163825787603855, 0.00164136360399425, 0.00164444337133318, 0.00164752325508744, 0.00165060313884169, 0.00165367440786213, 0.00165673706214875, 0.00165978248696774, 0.00166283652652055, 0.00166588195133954, 0.00166891876142472, 0.0016719470731914, 0.00167498388327658, 0.00167800346389413, 0.00168101454619318, 0.00168401701375842, 0.00168702797964215, 0.00169002183247358, 0.00169300707057118, 0.00169598357751966, 0.00169897743035108, 0.00170194555539638, 0.00170490483287722, 0.0017078643431887, 0.00171082373708487, 0.0017137659015134, 0.00171670818235725, 0.00171964173205197, 0.00172257539816201, 0.00172550044953823, 0.00172841676976532, 0.00173133320640773, 0.00173423229716718, 0.00173713150434196, 0.00174002209678292, 0.00174290407449007, 0.00174578605219722, 0.00174866802990437, 0.00175153277814388, 0.0017543975263834, 0.0017572536598891, 0.00176010141149163, 0.0017629488138482, 0.00176578795071691, 0.00176861824002117, 0.00177144864574075, 0.00177427043672651, 0.00177708361297846, 0.00177988805808127, 0.00178268412128091, 0.00178548856638372, 0.00178827589843422, 0.00179105473216623, 0.00179383344948292, 0.00179661228321493, 0.00179937388747931, 0.00180213537532836, 0.0018048882484436, 0.00180763262324035, 0.00181037688162178, 0.00181311275810003, 0.00181583978701383, 0.00181856704875827, 0.00182128534652293, 0.00182399537879974, 0.00182669667992741, 0.00182939798105508, 0.00183208216913044, 0.00183477497193962, 0.00183746765833348, 0.00184013450052589, 0.00184280145913363, 0.00184546841774136, 0.00184812664519995, 0.00185076787602156, 0.00185340887401253, 0.00185605860315263, 0.00185869098640978, 0.00186131498776376, 0.00186393037438393, 0.00186655402649194, 0.00186916091479361, 0.0018717588391155, 0.00187434849794954, 0.00187694642227143, 0.00187952734995633, 0.00188210816122591, 0.00188468059059232, 0.00188724417239428, 0.00188979925587773, 0.00189235445577651, 0.00189490953925997, 0.0018974473932758, 0.00189997663255781, 0.00190251448657364, 0.00190503511112183, 0.00190755573567003, 0.00191005924716592, 0.00191256275866181, 0.00191506615374237, 0.00191755231935531, 0.00192003860138357, 0.00192253349814564, 0.00192501116544008, 0.00192747148685157, 0.00192993204109371, 0.00193239247892052, 0.00193484418559819, 0.00193727889563888, 0.00193972222041339, 0.00194216542877257, 0.00194459140766412, 0.00194700888823718, 0.00194941775407642, 0.00195182650350034, 0.00195422675460577, 0.00195688521489501, 0.00195981864817441, 0.0019627392757684, 0.00196563848294318, 0.00196854188106954, 0.00197142385877669, 0.00197431887499988, 0.00197718781419098, 0.00198004418052733, 0.00198291311971843, 0.00198576063849032, 0.00198860839009285, 0.00199143867939711, 0.00199426058679819, 0.00199708645232022, 0.00199988693930209, 0.00200269161723554, 0.00200547860004008, 0.00200825743377209, 0.0020110490731895, 0.00201381067745388, 0.0020165725145489, 0.00201932084746659, 0.00202206103131175, 0.00202480517327785, 0.0020275239367038, 0.00203025084920228, 0.00203295238316059, 0.00203565787523985, 0.00203835917636752, 0.00204103463329375, 0.00204372312873602, 0.00204638577997684, 0.00204904400743544, 0.00205170665867627, 0.00205433927476406, 0.0020569886546582, 0.00205960846506059, 0.00206222804263234, 0.00206484319642186, 0.00206744577735662, 0.00207004370167851, 0.00207263324409723, 0.00207520974799991, 0.00207779067568481, 0.00208034552633762, 0.00208290526643395, 0.00208543869666755, 0.00208798516541719, 0.00209051440469921, 0.00209303083829582, 0.00209555146284401, 0.0020980634726584, 0.00210054987110198, 0.00210304907523096, 0.00210551801137626, 0.00210799998603761, 0.00211045611649752, 0.00211291247978806, 0.00211536861024797, 0.00211779889650643, 0.00212024617940187, 0.00212266365997493, 0.00212506833486259, 0.00212748139165342, 0.00212988164275885, 0.00213227327913046, 0.0021346474532038, 0.00213702628389001, 0.00213940488174558, 0.00214175367727876, 0.00214410643093288, 0.00214644242078066, 0.00214877794496715, 0.00215110508725047, 0.00215341476723552, 0.00215573329478502, 0.00215802597813308, 0.00216031866148114, 0.00216260715387762, 0.00216487399302423, 0.00216714944690466, 0.00216941419057548, 0.00217165099456906, 0.00217390921898186, 0.00217613531276584, 0.00217836117371917, 0.00218058074824512, 0.00218278774991632, 0.00218499638140202, 0.00218718568794429, 0.00218936870805919, 0.00219155615195632, 0.00219371542334557, 0.00219588540494442, 0.00219803396612406, 0.00220017391256988, 0.00220231199637055, 0.00220443680882454, 0.00220657046884298, 0.00220866920426488, 0.00221077282913029, 0.00221288041211665, 0.0022149623837322, 0.0022170424927026, 0.00221910467371345, 0.00222116755321622, 0.00222322763875127, 0.00222527072764933, 0.00222731428220868, 0.00222934014163911, 0.00223136623390019, 0.00223338371142745, 0.00223537930287421, 0.00223738187924027, 0.00223936256952584, 0.00224134535528719, 0.00224331533536315, 0.00224528578110039, 0.00224724714644253, 0.00224918709136546, 0.00225112494081259, 0.00225306046195328, 0.0022549747955054, 0.00225690612569451, 0.00225880742073059, 0.00226070010103285, 0.00226259068585932, 0.00226447242312133, 0.00226635625585914, 0.00226821471005678, 0.00227006850764155, 0.00227193115279078, 0.00227376585826278, 0.00227560033090413, 0.00227741757407784, 0.00227924156934023, 0.00228104810230434, 0.00228284602053463, 0.00228463998064399, 0.00228641834110022, 0.00228819949552417, 0.00228997133672237, 0.00229172012768686, 0.00229347730055451, 0.00229522143490613, 0.00229695066809654, 0.00229867547750473, 0.00230038980953395, 0.0023021143861115, 0.0023038093931973, 0.00230550207197666, 0.00230719242244959, 0.00230886368080974, 0.00231053913012147, 0.00231219083070755, 0.00231384020298719, 0.00231548794545233, 0.00231712451204658, 0.00231876340694726, 0.0023203743621707, 0.00232197879813612, 0.00232359627261758, 0.00232518347911537, 0.00232677278108895, 0.00232834508642554, 0.00232992367818952, 0.00233148271217942, 0.00233303569257259, 0.00233457563444972, 0.00233612186275423, 0.00233764667063951, 0.00233917823061347, 0.00234067719429731, 0.00234219338744879, 0.00234368606470525, 0.00234517036005855, 0.00234665395691991, 0.00234812754206359, 0.00234958995133638, 0.00235104165039957, 0.00235248915851116, 0.00235394085757434, 0.00235536438412964, 0.00235678628087044, 0.00235819933004677, 0.00235960143618286, 0.00236100819893181, 0.00236239098012447, 0.0023637805134058, 0.00236514606513083, 0.00236651627346873, 0.00236787972971797, 0.00236922176554799, 0.00237055751495063, 0.00237189535982907, 0.00237321993336082, 0.0023745340295136, 0.00237584393471479, 0.00237714732065797, 0.00237843976356089, 0.00237971940077841, 0.00238099927082658, 0.00238225748762488, 0.00238351989537477, 0.00238477159291506, 0.00238601490855217, 0.0023872428573668, 0.00238847965374589, 0.00238969037309289, 0.0023908989969641, 0.00239209900610149, 0.00239330134354532, 0.0023944778367877, 0.00239565433003008, 0.00239682872779667, 0.00239798775874078, 0.00239914050325751, 0.00240028277039528, 0.00240141618996859, 0.00240254541859031, 0.00240366579964757, 0.00240478198975325, 0.0024058788549155, 0.00240696943365037, 0.0024080618750304, 0.00240913941524923, 0.00241020857356489, 0.00241126865148544, 0.00241232267580926, 0.00241337204352021, 0.00241440651006997, 0.00241544097661972, 0.00241645844653249, 0.00241746916435659, 0.0024184756912291, 0.00241946964524686, 0.00242045661434531, 0.00242144148796797, 0.00242241378873587, 0.00242337514646351, 0.00242433440871537, 0.0024252871517092, 0.00242621847428381, 0.00242714327760041, 0.00242806598544121, 0.00242898659780622, 0.00242989184334874, 0.0024307887069881, 0.00243167695589364, 0.00243256310932338, 0.00243343412876129, 0.0024342923425138, 0.0024351526517421, 0.00243600411340594, 0.00243684323504567, 0.00243767956271768, 0.00243850355036557, 0.002439318690449, 0.00244012079201639, 0.00244092498905957, 0.0024417145177722, 0.0024424996227026, 0.00244326936081052, 0.00244403956457973, 0.00244480068795383, 0.00244554714299738, 0.00244629359804094, 0.00244702468626201, 0.00244774506427348, 0.00244846567511559, 0.00244918395765126, 0.00244987872429192, 0.00245057116262615, 0.00245125079527497, 0.00245193694718182, 0.0024526035413146, 0.00245326175354421, 0.00245390925556421, 0.0024545609485358, 0.00245519308373332, 0.00245581916533411, 0.002456434071064, 0.00245704501867294, 0.00245765130966902, 0.00245824502781034, 0.00245882989838719, 0.00245940871536732, 0.00245998264290392, 0.00246053980663419, 0.00246109697036445, 0.00246163667179644, 0.00246217637322843, 0.00246270559728146, 0.00246322411112487, 0.00246373587287962, 0.00246424553915858, 0.00246474030427635, 0.00246523064561188, 0.00246570585295558, 0.00246617686934769, 0.00246664369478822, 0.00246709329076111, 0.00246754055842757, 0.00246798363514245, 0.00246842042542994, 0.00246883532963693, 0.00246924837119877, 0.00246965046972036, 0.00247005466371775, 0.00247044186107814, 0.00247082021087408, 0.00247119250707328, 0.00247156689874828, 0.00247191730886698, 0.00247226562350988, 0.00247260555624962, 0.00247294316068292, 0.00247326144017279, 0.00247357343323529, 0.00247388100251555, 0.00247418624348938, 0.00247447658330202, 0.00247475621290505, 0.00247502932325006, 0.00247529824264348, 0.00247555854730308, 0.00247580371797085, 0.00247604888863862, 0.00247627892531455, 0.00247651129029691, 0.0024767282884568, 0.00247693271376193, 0.00247713481076062, 0.0024773261975497, 0.0024775133933872, 0.00247768755070865, 0.0024778509978205, 0.00247801910154521, 0.00247816951014102, 0.002478311304003, 0.00247844494879246, 0.00247856951318681, 0.00247869198210537, 0.00247880374081433, 0.00247890059836209, 0.00247899536043406, 0.00247908988967538, 0.00247916299849749, 0.00247922982089221, 0.00247929198667407, 0.00247934809885919, 0.00247939093969762, 0.0024794212076813, 0.00247945333831012, 0.00247948127798736, 0.00247948779724538, 0.00247949198819697, 0.00247948570176959, 0.00247947499155998, 0.00247945543378592, 0.00247942749410868, 0.00247938674874604, 0.0024793460033834, 0.00247928989119828, 0.00247922958806157, 0.0024791588075459, 0.00247907708398998, 0.00247899326495826, 0.00247890269383788, 0.00247879954986274, 0.0024786836002022, 0.00247856718488038, 0.00247844029217958, 0.00247830059379339, 0.00247815670445561, 0.00247801025398076, 0.0024778509978205, 0.00247768126428127, 0.00247750268317759, 0.00247732410207391, 0.00247712410055101, 0.00247692200355232, 0.00247671129181981, 0.00247649825178087, 0.00247627031058073, 0.0024760402739048, 0.00247579719871283, 0.00247554550878704, 0.00247528962790966, 0.0024750204756856, 0.002474743174389, 0.00247445493005216, 0.00247416901402175, 0.00247387238778174, 0.00247356691397727, 0.0024732444435358, 0.00247292593121529, 0.00247258809395134, 0.00247224839404225, 0.00247189775109291, 0.00247154524549842, 0.00247117970138788, 0.00247080950066447, 0.00247042020782828, 0.00247003091499209, 0.00246963975951076, 0.00246923323720694, 0.00246881577186286, 0.00246839434839785, 0.00246796617284417, 0.00246752542443573, 0.00246707373298705, 0.00246661994606256, 0.00246615963988006, 0.00246568885631859, 0.00246520270593464, 0.0024647144600749, 0.00246422202326357, 0.00246371864341199, 0.00246320688165724, 0.0024626818485558, 0.00246215285733342, 0.00246161757968366, 0.00246106903068721, 0.00246051838621497, 0.00245995912700891, 0.00245938496664166, 0.00245880847796798, 0.00245821685530245, 0.00245762150734663, 0.00245702126994729, 0.0024564063642174, 0.00245578656904399, 0.0024551609531045, 0.0024545241612941, 0.002453887835145, 0.00245323171839118, 0.00245256721973419, 0.00245190039277077, 0.00245122704654932, 0.00245053693652153, 0.00244984426535666, 0.0024491474032402, 0.00244843983091414, 0.00244772154837847, 0.00244699022732675, 0.00244625238701701, 0.00244551920332015, 0.00244475994259119, 0.00244400068186224, 0.00244324142113328, 0.00244246516376734, 0.00244168005883694, 0.00244088633917272, 0.00244008866138756, 0.00243927980773151, 0.00243846490047872, 0.00243763672187924, 0.00243680435232818, 0.00243596779182553, 0.00243511819280684, 0.00243425788357854, 0.00243339338339865, 0.00243252003565431, 0.00243163830600679, 0.00243074796162546, 0.00242985086515546, 0.00242894142866135, 0.00242802733555436, 0.00242710672318935, 0.00242617097683251, 0.0024252375587821, 0.00242428691126406, 0.00242333207279444, 0.00242236442863941, 0.00242139655165374, 0.00242041796445847, 0.00241942843422294, 0.00241843075491488, 0.00241742399521172, 0.00241641537286341, 0.00241538952104747, 0.00241435714997351, 0.00241332268342376, 0.00241227960214019, 0.00241122581064701, 0.00241016107611358, 0.00240908563137054, 0.0024080122821033, 0.0024069263599813, 0.00240582739934325, 0.00240472401492298, 0.00240361411124468, 0.00240249582566321, 0.00240136869251728, 0.00240023108199239, 0.00239908252842724, 0.00239793630316854, 0.00239677494391799, 0.00239416817203164, 0.00239021936431527, 0.00238627940416336, 0.00238232617266476, 0.00237837317399681, 0.00237441994249821, 0.00237047136761248, 0.00236650975421071, 0.00236255675554276, 0.00235859490931034, 0.00235463329590857, 0.00235068029724061, 0.00234671426005661, 0.00234274822287261, 0.00233878241851926, 0.00233482080511749, 0.00233085476793349, 0.00232688477262855, 0.00232290988788009, 0.0023189396597445, 0.00231496943160892, 0.00231099082157016, 0.00230701174587011, 0.00230304128490388, 0.00229906267486513, 0.00229507964104414, 0.00229109637439251, 0.00228710891678929, 0.00228313007391989, 0.00227914680726826, 0.00227515515871346, 0.00227116327732801, 0.00226718001067638, 0.00226319278590381, 0.00225919671356678, 0.00225520064122975, 0.00225120456889272, 0.00224720849655569, 0.00224321219138801, 0.00223921192809939, 0.00223521189764142, 0.00223120697773993, 0.00222720229066908, 0.00222319341264665, 0.00221919734030962, 0.00221518380567431, 0.00221117492765188, 0.00220716185867786, 0.00220315717160702, 0.0021991350222379, 0.00219512195326388, 0.00219110888428986, 0.00218709534965456, 0.00218307343311608, 0.0021790515165776, 0.00217502960003912, 0.00217100349254906, 0.00216698599979281, 0.00216295570135117, 0.00215892912819982, 0.00215489906258881, 0.00215087248943746, 0.00214683776721358, 0.00214280327782035, 0.00213877274654806, 0.00213473802432418, 0.0021307033021003, 0.00212666392326355, 0.00212261639535427, 0.00211858144029975, 0.00211454252712429, 0.00211049919016659, 0.00210644723847508, 0.00210239947773516, 0.00209835614077747, 0.00209430838003755, 0.00209025642834604, 0.00208620447665453, 0.00208215252496302, 0.00207809614948928, 0.00207403977401555, 0.00206997920759022, 0.00206592725589871, 0.00206185807473958, 0.00205780169926584, 0.00205373275093734, 0.0020496763754636, 0.00204560719430447, 0.00204153801314533, 0.00203746859915555, 0.00203339965082705, 0.00202932604588568, 0.00202525709755719, 0.00202117906883359, 0.00201710988767445, 0.0020130320917815, 0.00200894987210631, 0.00200486788526177, 0.00200079008936882, 0.00199670600704849, 0.0019926237873733, 0.00198853947222233, 0.00198444677516818, 0.00198036897927523, 0.001976273721084, 0.00197217869572341, 0.00196808623149991, 0.00196399306878448, 0.00195990479551256, 0.00195580301806331, 0.00195170589722693, 0.00194761122111231, 0.00194351153913885, 0.00193941232282668, 0.00193530227988958, 0.00193119433242828, 0.00192709302064031, 0.00192298507317901, 0.00191887503024191, 0.00191476498730481, 0.0019106570398435, 0.00190654490143061, 0.00190242403186858, 0.00189830549061298, 0.00189419754315168, 0.00189007667358965, 0.00188595813233405, 0.00188183307182044, 0.0018777142977342, 0.00187358912080526, 0.00186946184840053, 0.00186533678788692, 0.00186120951548219, 0.00185707805212587, 0.00185294635593891, 0.00184881698805839, 0.00184467679355294, 0.00184054742567241, 0.00183640932664275, 0.00183227146044374, 0.00182813557330519, 0.00182399537879974, 0.00181984878145158, 0.00181570649147034, 0.00181155989412218, 0.00180741969961673, 0.00180326867848635, 0.0017991199856624, 0.00179496919736266, 0.00179082457907498, 0.00178666738793254, 0.00178250984754413, 0.00177835242357105, 0.00177419523242861, 0.00177004211582243, 0.00176587817259133, 0.00176171667408198, 0.00175755505915731, 0.001753393211402, 0.0017492271726951, 0.00174505682662129, 0.00174089113716036, 0.00173672288656235, 0.00173255265690386, 0.00172837369609624, 0.00172420346643776, 0.00172003312036395, 0.00171585427597165, 0.00171167543157935, 0.00170749216340482, 0.00170330901164562, 0.00169913447462022, 0.0016949491109699, 0.00169076176825911, 0.00168658059556037, 0.00168239092454314, 0.00167820358183235, 0.00167401181533933, 0.00166981352958828, 0.00166563037782907, 0.00166143418755382, 0.00165724032558501, 0.00165303342510015, 0.00164883956313133, 0.00164464127738029, 0.00164043449331075, 0.00163623411208391, 0.00163203582633287, 0.00162782904226333, 0.00162362214177847, 0.00161940895486623, 0.00161520193796605, 0.00161098875105381, 0.00160677754320204, 0.0016025643562898, 0.0015983444172889, 0.00159412925131619, 0.00158991361968219, 0.00158569181803614, 0.00158147199545056, 0.00157725450117141, 0.00157302815932781, 0.00156880205031484, 0.001564578153193, 0.00156035181134939, 0.0015561212785542, 0.00155188865028322, 0.00154765613842756, 0.00154342548921704, 0.00153918657451868, 0.00153494952246547, 0.00153071468230337, 0.00152648205403239, 0.00152223859913647, 0.00151799316518009, 0.00151375192217529, 0.00150950625538826, 0.00150526280049235, 0.00150101515464485, 0.00149676750879735, 0.00149251765105873, 0.00148827221710235, 0.00148401584010571, 0.00147976377047598, 0.00147550320252776, 0.00147124903742224, 0.00146699277684093, 0.00146272999700159, 0.00145846512168646, 0.00145421084016562, 0.00144994386937469, 0.00144567678216845, 0.00144140981137753, 0.00143714691512287, 0.00143287982791662, 0.00142860435880721, 0.00142433075234294, 0.00142005947418511, 0.00141578807961196, 0.0014115123776719, 0.00140723236836493, 0.00140295037999749, 0.00139867456164211, 0.00139439024496824, 0.001390106161125, 0.00138581963256001, 0.00138153764419258, 0.00137724902015179, 0.00137296039611101, 0.00136866979300976, 0.00136438326444477, 0.00136008835397661, 0.0013557932106778, 0.00135149830020964, 0.00134720536880195, 0.001342908362858, 0.00133860681671649, 0.00133429875131696, 0.0013299974380061, 0.0013257022947073, 0.00132139667402953, 0.00131708430126309, 0.0013127721613273, 0.0013084706151858, 0.00130415637977421, 0.00129984400700778, 0.00129552977159619, 0.00129121739882976, 0.00128690525889397, 0.00128258438780904, 0.00127826363313943, 0.0012739448575303, 0.00126962619833648, 0.00126530113629997, 0.00126097386237234, 0.00125664449296892, 0.00125232571735978, 0.00124799413606524, 0.00124366476666182, 0.00123933318536729, 0.00123499718029052, 0.00123066571541131, 0.00122632551938295, 0.0012219917261973, 0.00121765583753586, 0.00121331575792283, 0.00120897335000336, 0.00120463105849922, 0.00120028655510396, 0.0011959420517087, 0.00119159533642232, 0.00118724664207548, 0.0011828999267891, 0.00117854692507535, 0.00117419601883739, 0.00116984080523252, 0.00116549408994615, 0.00116113235708326, 0.00115677062422037, 0.00115241331513971, 0.00114805379416794, 0.00114369427319616, 0.00113932823296636, 0.00113496230915189, 0.00113059626892209, 0.0011262345360592, 0.0011218620929867, 0.00111748964991421, 0.00111311720684171, 0.00110875116661191, 0.00110437453258783, 0.00109999778214842, 0.0010956188198179, 0.00109124416485429, 0.00108686531893909, 0.00108248216565698, 0.00107809901237488, 0.00107371364720166, 0.00106933258939534, 0.00106494291685522, 0.00106055336073041, 0.00105616147629917, 0.00105177832301706, 0.00104738643858582, 0.00104298605583608, 0.00103859207592905, 0.00103419821243733, 0.00102980411611497, 0.00102540163788944, 0.00102099915966392, 0.00101660296786577, 0.00101219827774912, 0.00100779137574136, 0.00100338249467313, 0.000998977804556489, 0.000994568690657616, 0.000990161905065179, 0.000985746504738927, 0.000981328776106238, 0.000976919778622687, 0.000972506415564567, 0.000968086766079068, 0.000963666941970587, 0.00095924932975322, 0.000954825314693153, 0.000950403395108879, 0.000945981417316943, 0.000941557402256876, 0.000937126926146448, 0.000932700640987605, 0.000928270164877176, 0.000923841784242541, 0.000919404847081751, 0.000914974370971322, 0.000910537375602871, 0.00090610038023442, 0.000901665538549423, 0.000897224235814065, 0.000892785261385143, 0.000888348207809031, 0.000883902714122087, 0.000879452796652913, 0.000875007244758308, 0.000870559480972588, 0.000866113929077983, 0.00086166406981647, 0.000857207749504596, 0.000852753524668515, 0.000848305819090456, 0.000843847345095128, 0.000839386717416346, 0.000834928301628679, 0.000830476288683712, 0.000826013507321477, 0.000821542053017765, 0.00081707927165553, 0.000812622951343656, 0.000808151613455266, 0.000803684524726123, 0.000799208821263164, 0.000794737425167114, 0.000790274702012539, 0.000785796844866127, 0.000781321199610829, 0.000776839093305171, 0.000772367639001459, 0.000767887686379254, 0.000763405580073595, 0.000758921320084482, 0.00075444346293807, 0.00074995489558205, 0.000745466270018369, 0.000740975548978895, 0.00073649559635669, 0.000732002721633762, 0.000727509788703173, 0.000723014760296792, 0.000718524039257318, 0.000714029010850936, 0.000709529616869986, 0.000705030339304358, 0.000700531003531069, 0.000696029455866665, 0.000691525870934129, 0.000687022227793932, 0.000682516430970281, 0.000678010634146631, 0.000673500529956073, 0.000668990425765514, 0.000664480321574956, 0.000659970217384398, 0.000655455864034593, 0.000650941510684788, 0.000646422733552754, 0.000641906226519495, 0.000637387565802783, 0.000632862385828048, 0.000628337264060974, 0.000623818545136601, 0.000619297730736434, 0.0006147725507617, 0.000610240967944264, 0.000605713692493737, 0.000601182051468641, 0.000596643949393183, 0.000592112424783409, 0.000587576534599066, 0.000583042739890516, 0.000578506849706173, 0.000573966710362583, 0.000569426454603672, 0.000564884103368968, 0.000560346059501171, 0.000555801554583013, 0.000551254895981401, 0.000546703930012882, 0.000542159483302385, 0.000537608517333865, 0.000533064012415707, 0.000528504431713372, 0.000523949158377945, 0.000519393943250179, 0.000514838669914752, 0.000510281242895871, 0.000505721720401198, 0.000501157832331955, 0.000496600405313075, 0.000492036575451493, 0.00048746625543572, 0.000482902396470308, 0.000478336412925273, 0.000473768246592954, 0.000469193619210273, 0.00046462332829833, 0.00046004870091565, 0.000455476256320253, 0.000450899446150288, 0.000446320569608361, 0.000441743759438396, 0.000437164882896468, 0.000432581669883803, 0.000427998456871137, 0.000423413061071187, 0.000418827694375068, 0.000414242327678949, 0.000409652653615922, 0.000405060825869441, 0.00040046899812296, 0.000395879353163764, 0.000391287554521114, 0.000386691390303895, 0.00038209100603126, 0.000377492717234418, 0.000372894457541406, 0.000368296168744564, 0.000363689294317737, 0.000359086727257818, 0.000354482006514445, 0.000349877285771072, 0.000345268257660791, 0.00034065279760398, 0.000336048047756776, 0.000331436865963042, 0.000326823559589684, 0.000322205945849419, 0.00031759261037223, 0.000312974967528135, 0.000308355200104415, 0.000303735403576866, 0.000299111328786239, 0.000294487253995612, 0.000289867457468063, 0.000285243411781266, 0.000280615000519902, 0.000275980157312006, 0.000271351804258302, 0.000266721239313483, 0.000262086425209418, 0.000257449428318068, 0.000252818921580911, 0.000249480974161997, 0.000247495830990374, 0.000245510716922581, 0.000243533126194961, 0.000241567337070592, 0.00023960585531313, 0.000237648695474491, 0.000235696890740655, 0.000233748331083916, 0.000231814847211353, 0.000229879180551507, 0.000227953190915287, 0.000226028278120793, 0.000224114133743569, 0.00022220857499633, 0.000220303001697175, 0.000218403933104128, 0.000216513421037234, 0.000214627230889164, 0.000212752856896259, 0.000210876358323731, 0.000209006291697733, 0.000207145902095363, 0.000205291973543353, 0.000203443414648063, 0.000201599148567766, 0.000199759189854376, 0.00019792678358499, 0.000196100794710219, 0.00019428449741099, 0.000192471445188858, 0.000190659440704621, 0.000188859266927466, 0.000187062338227406, 0.000185271856025793, 0.000183485666639172, 0.000181711307959631, 0.000179935872438364, 0.000178172282176092, 0.000176411893335171, 0.000174656888702884, 0.00017291157564614, 0.00017116624803748, 0.000169431688846089, 0.00016770142246969, 0.000165974372066557, 0.000164257013238966, 0.00016254503862001, 0.000160841649631038, 0.00015913718380034, 0.000157440255861729, 0.0001557551586302, 0.000154072215082124, 0.00015239356434904, 0.000150725667481311, 0.000149057770613581, 0.000147403858136386, 0.000145752084790729, 0.000144102479680441, 0.000142463613883592, 0.000140826916322112, 0.000139200958074071, 0.000137573922984302, 0.000135957656311803, 0.000134346744744107, 0.000132742294226773, 0.000131146458443254, 0.000129553824081086, 0.000127962295664474, 0.000126380429719575, 0.00012480714940466, 0.000123237128718756, 0.000121676755952649, 0.000120117481856141, 0.000118566807941534, 0.000117020419565961, 0.000115481576358434, 0.000113943788164761, 0.00011241999163758, 0.000110901572043076, 0.000109386390249711, 0.000107872278022114, 0.00010637105879141, 0.000104874146927614, 0.000103383688838221, 0.000101898607681505, 0.000100414596090559, 9.89402687991969e-05, 9.74756185314618e-05, 9.6012037829496e-05, 9.45549181778915e-05, 9.31053218664601e-05, 9.16643257369287e-05, 9.02276369743049e-05, 8.87931018951349e-05, 8.73650060384534e-05, 8.59455321915448e-05, 8.45324902911671e-05, 8.31280631246045e-05, 8.17225518403575e-05, 8.03256625658832e-05, 7.8938428487163e-05, 7.7555509051308e-05, 7.61790361138992e-05, 7.48004167689942e-05, 7.34346976969391e-05, 7.20765092410147e-05, 7.07236977177672e-05, 6.93708861945197e-05, 6.80298981023952e-05, 6.66942942189053e-05, 6.53651368338615e-05, 6.40392099739984e-05, 6.27186600468121e-05, 6.14077871432528e-05, 6.01022911723703e-05, 5.88021721341647e-05, 5.75074336666148e-05, 5.62137647648342e-05, 5.49362266610842e-05, 5.36597653990611e-05, 5.23908311151899e-05, 5.11229736730456e-05, 4.98626395710744e-05, 4.86119897686876e-05, 4.73667132609989e-05, 4.6120367187541e-05, 4.48869141109753e-05, 4.36577684013173e-05, 4.24372301495168e-05, 4.12199115089606e-05, 4.00047465518583e-05, 3.88014123018365e-05, 3.76013013010379e-05, 3.64108709618449e-05, 3.52247370756231e-05, 3.40386068273801e-05, 3.28653804899659e-05, 3.16964578814805e-05, 3.053828550037e-05, 2.93736648018239e-05, 2.82240962405922e-05, 2.70788277703105e-05, 2.59400167124113e-05, 2.48033520620083e-05, 2.36774412769591e-05, 2.25569110625656e-05, 2.14417541428702e-05, 2.03308973141247e-05, 1.9225421056035e-05, 1.81274699571077e-05, 1.70381226780592e-05, 1.59541505126981e-05, 1.48734061440337e-05, 1.37980405270355e-05, 1.27280482047354e-05, 1.1669886589516e-05, 1.06128027255181e-05, 9.55894211074337e-06, 8.51798540679738e-06, 7.48025740904268e-06, 6.45005366095575e-06, 5.41877625437337e-06, 4.39932864537695e-06, 3.38740869665344e-06, 2.37871336139506e-06, 1.37754580009641e-06, 3.81755455691746e-07, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 0.000250500335823745, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 0.000838144915178418, 8.42019289848395e-07, 3.97779422200983e-06, 7.1264612415689e-06, 1.03095544545795e-05, 1.34990805236157e-05, 1.67036814673338e-05, 1.99297919607488e-05, 2.31903140957002e-05, 2.64550999418134e-05, 2.97382230201038e-05, 3.30503389704973e-05, 3.63818326150067e-05, 3.97230069211219e-05, 4.30846012022812e-05, 4.6464479964925e-05, 4.98744557262398e-05, 5.32930716872215e-05, 5.67320821573958e-05, 6.01893880229909e-05, 6.36671247775666e-05, 6.71728266752325e-05, 7.06882055965252e-05, 7.42240299587138e-05, 7.77877867221832e-05, 8.13708975329064e-05, 8.49561911309138e-05, 8.85608169483021e-05, 9.22020044527017e-05, 9.58625678322278e-05, 9.9524186225608e-05, 0.000103207334177569, 0.000106934552604798, 0.000110655324533582, 0.000114404057967477, 0.000118171068606898, 0.00012195957970107, 0.000125767444842495, 0.000129583946545608, 0.000133429464767687, 0.000137285722303204, 0.000141180702485144, 0.000145084297400899, 0.000148998617078178, 0.00015293231990654, 0.000156902591697872, 0.000160876050358638, 0.000164867829880677, 0.000168880025739782, 0.000172935222508386, 0.000176986141013913, 0.000181047813384794, 0.000185163225978613, 0.000189271144336089, 0.000193390864296816, 0.000197546105482616, 0.000201719594770111, 0.000205908145289868, 0.000210112833883613, 0.000214337967918254, 0.000218581350054592, 0.000222852700971998, 0.000227136988542043, 0.000231439524213783, 0.000235761428484693, 0.000240102672250941, 0.000244469731114805, 0.000248851894866675, 0.0002532426151447, 0.000257677398622036, 0.000262115470832214, 0.000266563176410273, 0.000271031341981143, 0.000275545724434778, 0.000280062260571867, 0.000284596026176587, 0.000289140531094745, 0.000293722667265683, 0.000298309081699699, 0.00030292134033516, 0.000307552982121706, 0.000312203919747844, 0.000316864548949525, 0.000321557483403012, 0.000326265435433015, 0.000330986309563741, 0.000335741555318236, 0.000340500060701743, 0.000345277949236333, 0.000350085931131616, 0.000354920775862411, 0.00035974700585939, 0.000364603358320892, 0.000369486602721736, 0.000374399969587103, 0.000379313336452469, 0.000384237413527444, 0.00038921635132283, 0.000394187780329958, 0.00039918182301335, 0.000404191960114986, 0.00040923006599769, 0.000414278911193833, 0.000419348158175126, 0.00042443789425306, 0.000429545907536522, 0.000434680783655494, 0.000439826399087906, 0.000444992503616959, 0.000450176827143878, 0.000455402012448758, 0.000460615410702303, 0.000465850287582725, 0.000471113162348047, 0.000476411456475034, 0.000481707655126229, 0.000487017794512212, 0.000492359162308276, 0.000497734930831939, 0.000503106450196356, 0.000508505792822689, 0.000513913866598159, 0.000519360532052815, 0.000524815928656608, 0.000530284130945802, 0.000535769562702626, 0.000541294808499515, 0.00054682872723788, 0.00055237440392375, 0.000557937193661928, 0.000563530251383781, 0.000569151190575212, 0.000574773177504539, 0.000580415711738169, 0.000586076348554343, 0.00059177476214245, 0.000597475271206349, 0.000603195163421333, 0.000608950562309474, 0.000614709162618965, 0.000620494654867798, 0.000626283348537982, 0.000632117153145373, 0.000637960736639798, 0.000643807463347912, 0.000649681140203029, 0.000655586016364396, 0.000661506957840174, 0.000667431158944964, 0.000673382251989096, 0.000679354881867766, 0.000685354287270457, 0.000691364577505738, 0.000697394134476781, 0.000703442026861012, 0.000709518906660378, 0.000715599046088755, 0.000721707125194371, 0.000727832433767617, 0.000733987835701555, 0.000740151794161648, 0.000746328732930124, 0.000752523890696466, 0.000758764275815338, 0.00076500786235556, 0.000771260063629597, 0.000777552020736039, 0.000783852650783956, 0.000790163991041481, 0.00079649465624243, 0.000802854367066175, 0.000809239863883704, 0.000815630774013698, 0.000822039961349219, 0.000828474992886186, 0.000834922888316214, 0.000842399895191193, 0.000850822194479406, 0.000859296065755188, 0.000867787224706262, 0.000876355683431029, 0.000884932815097272, 0.000893552962224931, 0.000902250641956925, 0.000910956761799753, 0.000919697340577841, 0.000928489549551159, 0.000937333330512047, 0.000946211628615856, 0.000955124211031944, 0.000964088481850922, 0.000973104441072792, 0.000982128782197833, 0.000991204986348748, 0.00100033264607191, 0.00100949476473033, 0.00101870857179165, 0.00102794810663909, 0.0010372307151556, 0.0010465735103935, 0.00105595926288515, 0.00106534513179213, 0.0010748083004728, 0.00108428881503642, 0.00109385524410754, 0.00110343040432781, 0.00111301394645125, 0.00112269225064665, 0.00113240501377732, 0.00114213488996029, 0.00115192518569529, 0.00116175832226872, 0.0011716258013621, 0.00118151924107224, 0.00119146413635463, 0.00120146083645523, 0.00121149176266044, 0.00122156587895006, 0.00123167433775961, 0.00124180864077061, 0.00125201162882149, 0.00126225792337209, 0.00127252971287817, 0.00128284469246864, 0.00129321974236518, 0.00130361213814467, 0.00131406460423023, 0.00132452580146492, 0.00133508164435625, 0.00134563748724759, 0.00135622767265886, 0.00136687827762216, 0.00137758022174239, 0.0013883167412132, 0.00139908760320395, 0.00140988430939615, 0.00142075831536204, 0.0014316497836262, 0.00144257547799498, 0.00145356997381896, 0.00146456458605826, 0.00147564522922039, 0.00148673437070101, 0.00149787508416921, 0.00150906760245562, 0.00152030296158046, 0.00153156428132206, 0.00154285994358361, 0.00155420717783272, 0.00156561471521854, 0.001577039482072, 0.00158848997671157, 0.00160003500059247, 0.00161158014088869, 0.00162319419905543, 0.00163481675554067, 0.00164649949874729, 0.00165821681730449, 0.00166996836196631, 0.00168176298029721, 0.00169361778534949, 0.00170549855101854, 0.00171743938699365, 0.00172938883770257, 0.00174138997681439, 0.00175345118623227, 0.00176553847268224, 0.00177766859997064, 0.00178985041566193, 0.00180205784272403, 0.00181433430407196, 0.00182660203427076, 0.00183893006760627, 0.00185134401544929, 0.00186374108307064, 0.00187622383236885, 0.00188869808334857, 0.00190125836525112, 0.00191384449135512, 0.00192646507639438, 0.00193912850227207, 0.00195185223128647, 0.00196459330618382, 0.00197739456780255, 0.00199020421132445, 0.00200308277271688, 0.00201600440777838, 0.0020289602689445, 0.00204195966944098, 0.00205498421564698, 0.00206807814538479, 0.00208119745366275, 0.00209434283897281, 0.00210754852741957, 0.0021208138205111, 0.00213408842682838, 0.00214742287062109, 0.00216079200617969, 0.0021741867531091, 0.00218765041790903, 0.00220113107934594, 0.00221467204391956, 0.00222824770025909, 0.00224184896796942, 0.00225551892071962, 0.00226919748820364, 0.00228294520638883, 0.00229672691784799, 0.00231054332107306, 0.00232438556849957, 0.00233831349760294, 0.00235224165953696, 0.0023662387393415, 0.00238026143051684, 0.00239433604292572, 0.00240845326334238, 0.00242258817888796, 0.00243679131381214, 0.00245102937333286, 0.0024653016589582, 0.00247961678542197, 0.00249394937418401, 0.00250835926271975, 0.00252280361019075, 0.00253727380186319, 0.00255181267857552, 0.00256637763231993, 0.0025809679646045, 0.00259561045095325, 0.00261029554530978, 0.00262500648386776, 0.00263979495503008, 0.00265460065566003, 0.00266945804469287, 0.00268434104509652, 0.00269928434863687, 0.00271425349637866, 0.00272926548495889, 0.00274434662424028, 0.0027594359125942, 0.00277455989271402, 0.00278974417597055, 0.00280497153289616, 0.00282022450119257, 0.00283553777262568, 0.00285087688826025, 0.00286628468893468, 0.00288169248960912, 0.00289716059342027, 0.00291268015280366, 0.00292821717448533, 0.00294381426647305, 0.00295945443212986, 0.00297512044198811, 0.00299083790741861, 0.003006607061252, 0.00302239367738366, 0.00303824036382139, 0.0030541040468961, 0.0030700711067766, 0.00308601232245564, 0.00310199661180377, 0.00311804958619177, 0.0031341458670795, 0.00315025914460421, 0.00316644133999944, 0.00318264914676547, 0.00319891748949885, 0.00321519421413541, 0.00323152262717485, 0.00324791111052036, 0.0032643168233335, 0.00328078283928335, 0.00329727469943464, 0.00331381824798882, 0.00333039602264762, 0.00334701687097549, 0.00336366356350482, 0.00338038778863847, 0.0033971203956753, 0.00341393938288093, 0.00343074090778828, 0.00344760227017105, 0.00346455024555326, 0.00348148937337101, 0.00349847180768847, 0.00351549685001373, 0.00353258242830634, 0.00354971084743738, 0.00356686511076987, 0.00358405383303761, 0.00360130239278078, 0.00361857726238668, 0.00363590358756483, 0.0036532727535814, 0.00367066822946072, 0.00368811469525099, 0.00370560493320227, 0.0037231205496937, 0.00374070438556373, 0.00375833222642541, 0.00377596798352897, 0.00379365589469671, 0.00381138641387224, 0.00382917746901512, 0.0038469941355288, 0.00386483641341329, 0.00388274807482958, 0.00390069372951984, 0.00391868269070983, 0.00393669679760933, 0.00395475421100855, 0.00397287216037512, 0.00399101572111249, 0.00400919420644641, 0.0040274322964251, 0.0040456959977746, 0.00406402070075274, 0.00408237054944038, 0.00410074600949883, 0.00411919970065355, 0.00413767015561461, 0.00415620068088174, 0.00417474843561649, 0.00419334834441543, 0.00421199947595596, 0.00423065945506096, 0.00424937950447202, 0.00426817685365677, 0.00428696535527706, 0.00430582324042916, 0.00432468950748444, 0.00434362469241023, 0.00436261110007763, 0.00438161520287395, 0.00440066214650869, 0.00441976077854633, 0.00443889340385795, 0.00445807818323374, 0.00447728810831904, 0.00449654180556536, 0.00451585557311773, 0.00453518610447645, 0.00455457717180252, 0.00457400269806385, 0.00459347106516361, 0.00461296550929546, 0.00463251955807209, 0.00465208292007446, 0.00467174965888262, 0.00469140661880374, 0.00471111666411161, 0.00473087700083852, 0.00475067226216197, 0.00477051082998514, 0.00479038385674357, 0.00481032580137253, 0.00483026728034019, 0.00485026882961392, 0.0048703053034842, 0.00489039300009608, 0.00491050677374005, 0.00493068061769009, 0.00495088053867221, 0.00497113168239594, 0.00499141775071621, 0.00501173734664917, 0.00503212632611394, 0.00505253206938505, 0.00507299043238163, 0.00509350001811981, 0.00511400960385799, 0.00513460487127304, 0.00515521736815572, 0.00517588155344129, 0.00519658019766212, 0.0052173133008182, 0.00523810647428036, 0.00525893410667777, 0.00527979666367173, 0.00530070997774601, 0.00532165821641684, 0.00534263206645846, 0.0053636753000319, 0.00538474414497614, 0.00540583860129118, 0.00542700989171863, 0.00544819887727499, 0.00546944001689553, 0.00549071468412876, 0.00551204150542617, 0.00553341116756201, 0.00555478967726231, 0.0055762454867363, 0.00559774413704872, 0.00561926001682878, 0.00564081920310855, 0.0056624379940331, 0.00568408286198974, 0.00570577988401055, 0.00572750205174088, 0.00574928475543857, 0.00577109307050705, 0.00579293584451079, 0.00581484800204635, 0.0058367676101625, 0.00585876544937491, 0.0058807716704905, 0.00590283004567027, 0.00592493079602718, 0.00594709208235145, 0.00596925290301442, 0.00599148310720921, 0.00601374777033925, 0.00603608973324299, 0.00605841400101781, 0.00608079042285681, 0.00610322738066316, 0.00612571509554982, 0.00614822003990412, 0.00617077713832259, 0.00619335100054741, 0.00621602032333612, 0.00623869756236672, 0.00626140926033258, 0.00628417264670134, 0.00630697002634406, 0.00632981956005096, 0.00635270355269313, 0.00637562200427055, 0.00639858283102512, 0.00642159581184387, 0.00644464278593659, 0.00646774191409349, 0.00649086711928248, 0.00651406915858388, 0.00653725396841764, 0.00656050769612193, 0.00658382149413228, 0.00660714413970709, 0.00663052685558796, 0.00665395287796855, 0.00667740451171994, 0.0067009162157774, 0.0067244628444314, 0.00674804346635938, 0.00677166692912579, 0.00679533369839191, 0.00681906053796411, 0.00684280460700393, 0.00686659198254347, 0.00689043058082461, 0.00691429525613785, 0.00693820277228951, 0.00696217035874724, 0.00698616448789835, 0.00701020937412977, 0.00703428080305457, 0.0070584025233984, 0.00708257732912898, 0.00710676843300462, 0.00713101169094443, 0.00715529685840011, 0.0071796178817749, 0.00720400689169765, 0.00722840521484613, 0.0072528375312686, 0.00727733923122287, 0.00730187445878983, 0.00732644414529204, 0.00735106598585844, 0.00737570459023118, 0.00740042980760336, 0.00742516340687871, 0.00744993099942803, 0.00747476797550917, 0.00749961286783218, 0.0075245276093483, 0.0075494758784771, 0.00757445069029927, 0.0075994934886694, 0.00762454513460398, 0.00764965731650591, 0.0076748114079237, 0.00770000135526061, 0.00772525137290359, 0.0077505181543529, 0.00777581986039877, 0.00780119746923447, 0.00782658532261848, 0.00785201508551836, 0.00787748768925667, 0.00790303107351065, 0.00792859029024839, 0.00795418489724398, 0.00797983817756176, 0.0080055259168148, 0.00803123973309994, 0.00805702432990074, 0.00808283314108849, 0.00810867547988892, 0.00813457928597927, 0.00816050823777914, 0.00818648096174002, 0.00821249652653933, 0.00823856331408024, 0.00826465524733067, 0.0082907909527421, 0.00831696111708879, 0.00834320858120918, 0.0083694476634264, 0.00839577335864305, 0.00842211488634348, 0.00844850018620491, 0.0084749199450016, 0.0085013909265399, 0.00852789636701345, 0.00855446234345436, 0.00858104601502419, 0.00860769767314196, 0.00863436702638865, 0.00866106152534485, 0.00868782494217157, 0.00871463213115931, 0.00874146539717913, 0.00876835733652115, 0.00879526790231466, 0.00882224645465612, 0.0088492427021265, 0.00887628179043531, 0.0089033804833889, 0.00893049687147141, 0.00895767379552126, 0.00898488517850637, 0.00901212263852358, 0.00903942715376616, 0.00906675960868597, 0.00909413304179907, 0.00912155117839575, 0.00914901122450829, 0.00917650759220123, 0.00920405331999063, 0.00923161767423153, 0.00925925839692354, 0.00928692519664764, 0.00931461900472641, 0.00934236310422421, 0.00937015935778618, 0.00939798913896084, 0.0094258626922965, 0.00945377070456743, 0.00948172248899937, 0.00950970686972141, 0.00953774526715279, 0.00956583302468061, 0.00959393940865993, 0.00962209608405828, 0.00965028814971447, 0.00967853982001543, 0.00970682594925165, 0.00973515678197145, 0.00976352021098137, 0.00979190971702337, 0.00982035975903273, 0.00984886102378368, 0.00987737998366356, 0.00990594178438187, 0.00993456318974495, 0.0099632116034627, 0.00999191962182522, 0.0100206444039941, 0.0100494045764208, 0.0100782411172986, 0.0101070953533053, 0.0101360017433763, 0.0101649416610599, 0.0101945698261261, 0.0102251274511218, 0.0102557372301817, 0.01028638985008, 0.0103171011433005, 0.010347849689424, 0.0103786466643214, 0.0104095060378313, 0.0104403905570507, 0.0104713700711727, 0.0105023412033916, 0.0105333887040615, 0.0105645060539246, 0.0105956476181746, 0.010626851581037, 0.010658104903996, 0.0106893852353096, 0.0107207344844937, 0.0107521275058389, 0.0107835875824094, 0.0108150653541088, 0.0108465952798724, 0.0108782118186355, 0.0109098628163338, 0.0109415464103222, 0.0109732989221811, 0.0110050793737173, 0.011036935262382, 0.0110688097774982, 0.0111007606610656, 0.0111327469348907, 0.0111647751182318, 0.0111968731507659, 0.0112290140241385, 0.0112611884251237, 0.0112934494391084, 0.0113257272168994, 0.011358049698174, 0.0113904559984803, 0.0114228809252381, 0.0114553654566407, 0.0114878844469786, 0.0115204807370901, 0.0115531207993627, 0.0115857943892479, 0.0116185201331973, 0.0116513147950172, 0.0116841355338693, 0.0117170242592692, 0.0117499642074108, 0.0117829227820039, 0.0118159661069512, 0.0118490438908339, 0.0118821654468775, 0.0119153391569853, 0.0119485715404153, 0.0119818486273289, 0.0120151676237583, 0.0120485471561551, 0.0120819862931967, 0.0121154440566897, 0.0121489688754082, 0.0121825467795134, 0.0122161665931344, 0.0122498469427228, 0.0122835617512465, 0.0123173203319311, 0.0123511385172606, 0.0123850256204605, 0.01241893786937, 0.0124529022723436, 0.0124869188293815, 0.0125210117548704, 0.0125551139935851, 0.0125892758369446, 0.0126234982162714, 0.0126577550545335, 0.0126920817419887, 0.0127264494076371, 0.0127608524635434, 0.0127953253686428, 0.0128298401832581, 0.0128643894568086, 0.0128990169614553, 0.0129336696118116, 0.0129683995619416, 0.0130031378939748, 0.0130379367619753, 0.0130728296935558, 0.0131077244877815, 0.0131426770240068, 0.0131777003407478, 0.0132127478718758, 0.0132478652521968, 0.0132830170914531, 0.0133182210847735, 0.013353475369513, 0.0133887650445104, 0.0134241487830877, 0.0134595409035683, 0.0134949767962098, 0.0135305067524314, 0.0135660460218787, 0.0136016439646482, 0.0136373210698366, 0.0136729879304767, 0.0137087600305676, 0.0137445479631424, 0.0137804048135877, 0.0138163045048714, 0.0138522386550903, 0.0138882519677281, 0.0139242978766561, 0.0139603950083256, 0.0139965545386076, 0.0140327196568251, 0.0140689639374614, 0.0141052873805165, 0.0141416247934103, 0.0141779985278845, 0.0142144421115518, 0.0142509518191218, 0.0142874969169497, 0.0143240764737129, 0.0143607249483466, 0.0143974246457219, 0.0144341420382261, 0.0144709637388587, 0.0145077928900719, 0.014544665813446, 0.0145816216245294, 0.0146185886114836, 0.0146556263789535, 0.014692721888423, 0.0147298602387309, 0.0147670423611999, 0.0148042663931847, 0.0148415602743626, 0.014878898859024, 0.0149162765592337, 0.0149537185207009, 0.0149911995977163, 0.0150287263095379, 0.0150663023814559, 0.0151039408519864, 0.0151415970176458, 0.0151793463155627, 0.0152171198278666, 0.0152549659833312, 0.015292844735086, 0.015330757945776, 0.0153687400743365, 0.0154067631810904, 0.0154448337852955, 0.0154829872772098, 0.0155211323872209, 0.0155593724921346, 0.0155976479873061, 0.0156359635293484, 0.0156743340194225, 0.0157127529382706, 0.0157512538135052, 0.0157897602766752, 0.0158283356577158, 0.0158669613301754, 0.015905624255538, 0.0159443207085133, 0.015983110293746, 0.0160219185054302, 0.0160607863217592, 0.0160997156053782, 0.0161386784166098, 0.0161776915192604, 0.0162167642265558, 0.0162558741867542, 0.0162950344383717, 0.0163342393934727, 0.0163735207170248, 0.016412828117609, 0.0164521858096123, 0.0164916049689054, 0.0165310576558113, 0.0165705792605877, 0.0166101437062025, 0.0166497454047203, 0.0166894029825926, 0.0167291313409805, 0.0167688764631748, 0.016808683052659, 0.0168485250324011, 0.0168884582817554, 0.0169284101575613, 0.016968397423625, 0.0170084778219461, 0.0170485749840736, 0.0170887168496847, 0.0171289276331663, 0.0171691738069057, 0.0172095019370317, 0.0172498244792223, 0.0172902327030897, 0.0173306837677956, 0.0173711851239204, 0.0174117423593998, 0.0174523461610079, 0.0174929685890675, 0.0175336953252554, 0.0175744388252497, 0.0176152344793081, 0.0176560822874308, 0.0176969785243273, 0.0177379306405783, 0.0177789144217968, 0.0178199671208858, 0.0178610719740391, 0.0179021954536438, 0.0179433934390545, 0.0179846435785294, 0.0180259216576815, 0.018067292869091, 0.0181086640805006, 0.0181500967592001, 0.018191596493125, 0.0182331409305334, 0.0182747282087803, 0.0183163564652205, 0.018358064815402, 0.0183998048305511, 0.0184415820986032, 0.0184834245592356, 0.0185253042727709, 0.0185672361403704, 0.0186092276126146, 0.0186512693762779, 0.0186933390796185, 0.0187354665249586, 0.0187776647508144, 0.0188198871910572, 0.0188621785491705, 0.018904522061348, 0.0189468935132027, 0.0189893133938313, 0.0190318040549755, 0.019074335694313, 0.0191169120371342, 0.019159521907568, 0.0192022193223238, 0.0192449409514666, 0.0192877240478992, 0.019330557435751, 0.0193734094500542, 0.0194163471460342, 0.0194593258202076, 0.0195023585110903, 0.0195454154163599, 0.0195885505527258, 0.0196317285299301, 0.0196749325841665, 0.0197181981056929, 0.0197615493088961, 0.019804896786809, 0.0198483262211084, 0.0198917966336012, 0.0199353192001581, 0.0199788846075535, 0.020022502169013, 0.0200661681592464, 0.0201098900288343, 0.0201536528766155, 0.0201974771916866, 0.0202413331717253, 0.0202852413058281, 0.0203292313963175, 0.0203732158988714, 0.0204172991216183, 0.0204614065587521, 0.0205055624246597, 0.0205497834831476, 0.0205940287560225, 0.0206383522599936, 0.0206827074289322, 0.0207271091639996, 0.0207715928554535, 0.0208160970360041, 0.0208606421947479, 0.0209052562713623, 0.0209499057382345, 0.0209946073591709, 0.0210393760353327, 0.0210841968655586, 0.0211290363222361, 0.0211739353835583, 0.0212188940495253, 0.0212639048695564, 0.021308958530426, 0.0213540643453598, 0.0213992204517126, 0.0214444044977427, 0.021489679813385, 0.0215349663048983, 0.0215803030878305, 0.0216257013380527, 0.0216711591929197, 0.0217166692018509, 0.0217622052878141, 0.0218077916651964, 0.0218534469604492, 0.0218991450965405, 0.0219449046999216, 0.0219906903803349, 0.0220365263521671, 0.0220824405550957, 0.0221283808350563, 0.0221743620932102, 0.0222204048186541, 0.0222664978355169, 0.02231265604496, 0.0223588272929192, 0.0224050842225552, 0.0224513784050941, 0.0224976949393749, 0.0225440841168165, 0.0225905384868383, 0.0226370207965374, 0.0226835627108812, 0.0227301474660635, 0.0227767750620842, 0.0228234622627497, 0.0228702202439308, 0.0229170024394989, 0.0229638181626797, 0.0230107065290213, 0.0230576600879431, 0.0231046322733164, 0.0231516491621733, 0.0231987480074167, 0.023245869204402, 0.023293063044548, 0.0233403015881777, 0.0233875662088394, 0.0234348904341459, 0.0234822761267424, 0.0235296953469515, 0.0235771927982569, 0.0236247051507235, 0.0236722882837057, 0.0237199068069458, 0.0237675756216049, 0.0238153208047152, 0.023863086476922, 0.0239109005779028, 0.0239587929099798, 0.0240067038685083, 0.0240546818822622, 0.0241027195006609, 0.0241507571190596, 0.024198891595006, 0.0242470521479845, 0.0242953058332205, 0.0243435576558113, 0.0243918560445309, 0.0244402475655079, 0.024488665163517, 0.0245371181517839, 0.0245856624096632, 0.0246342103928328, 0.024682842195034, 0.0247315019369125, 0.0247802119702101, 0.024828989058733, 0.0248777773231268, 0.0249266494065523, 0.0249755661934614, 0.0250245165079832, 0.0250735525041819, 0.0251225903630257, 0.0251716952770948, 0.0252208784222603, 0.0252700857818127, 0.0253193378448486, 0.0253686513751745, 0.0254180058836937, 0.0254674144089222, 0.0255168695002794, 0.0255663823336363, 0.0256159342825413, 0.0256655309349298, 0.0257152132689953, 0.0257649030536413, 0.0258146468549967, 0.0258644632995129, 0.0259143095463514, 0.0259642079472542, 0.0260141640901566, 0.0260641723871231, 0.0261142253875732, 0.0261643119156361, 0.02621447481215, 0.0262646824121475, 0.0263149235397577, 0.0263652242720127, 0.0264155622571707, 0.0264659561216831, 0.0265164040029049, 0.0265669114887714, 0.0266174282878637, 0.0266680475324392, 0.026718694716692, 0.0267693996429443, 0.0268201231956482, 0.0268709138035774, 0.0269217658787966, 0.0269726533442736, 0.027023583650589, 0.0270745977759361, 0.027125621214509, 0.0271767135709524, 0.0272278673946857, 0.0272790547460318, 0.027330294251442, 0.0273815672844648, 0.027432918548584, 0.0274843033403158, 0.0275357495993376, 0.027587229385972, 0.0276387613266706, 0.027690326794982, 0.0277419798076153, 0.0277936570346355, 0.0278454050421715, 0.0278971847146749, 0.0279489997774363, 0.0280008930712938, 0.0280528366565704, 0.0281048007309437, 0.0281568318605423, 0.0282089188694954, 0.0282610449939966, 0.0283132307231426, 0.0283654518425465, 0.0284177307039499, 0.0284700449556112, 0.0285224374383688, 0.0285748634487391, 0.0286273434758186, 0.0286798551678658, 0.0287324357777834, 0.0287850499153137, 0.0288377366960049, 0.0288904458284378, 0.0289432443678379, 0.0289960559457541, 0.0290489122271538, 0.0291018541902304, 0.0291548259556293, 0.029207818210125, 0.0292609054595232, 0.0293140131980181, 0.0293671861290932, 0.0294204130768776, 0.0294736754149199, 0.0295269917696714, 0.0295803509652615, 0.0296337809413671, 0.0296872388571501, 0.0297407358884811, 0.0297943204641342, 0.0298479367047548, 0.0299015808850527, 0.0299553088843822, 0.0300090759992599, 0.0300628915429115, 0.0301167424768209, 0.0301706586033106, 0.0302246324717999, 0.0302786082029343, 0.030332688242197, 0.0303867906332016, 0.0304409451782703, 0.0304951779544353, 0.0305494125932455, 0.0306037124246359, 0.0306580848991871, 0.0307124871760607, 0.0307669434696436, 0.0308214258402586, 0.0308759938925505, 0.0309306159615517, 0.0309852510690689, 0.0310399662703276, 0.0310947075486183, 0.0311494991183281, 0.0312043782323599, 0.0312592647969723, 0.031314205378294, 0.0313692018389702, 0.0314242616295815, 0.0314793437719345, 0.0315345078706741, 0.031589712947607, 0.0316468551754951, 0.0317061096429825, 0.0317654013633728, 0.031824704259634, 0.0318840704858303, 0.0319434404373169, 0.032002866268158, 0.0320623330771923, 0.032121829688549, 0.03218137845397, 0.0322409309446812, 0.0323005244135857, 0.0323601849377155, 0.0324198640882969, 0.0324795581400394, 0.0325393117964268, 0.0325991064310074, 0.0326589122414589, 0.0327187813818455, 0.0327786728739738, 0.032838586717844, 0.0328985452651978, 0.0329585634171963, 0.0330185815691948, 0.0330786593258381, 0.0331387668848038, 0.0331989042460918, 0.0332590825855732, 0.0333192907273769, 0.0333795584738255, 0.033439826220274, 0.0335001423954964, 0.0335605181753635, 0.0336209125816822, 0.0336813293397427, 0.0337417982518673, 0.033802293241024, 0.0338628254830837, 0.0339233987033367, 0.0339840054512024, 0.0340446420013905, 0.0341053158044815, 0.0341660529375076, 0.0342268012464046, 0.0342875830829144, 0.0343484058976173, 0.0344092659652233, 0.034470159560442, 0.0345310941338539, 0.0345920585095882, 0.0346530415117741, 0.0347140692174435, 0.0347751751542091, 0.0348362736403942, 0.0348974205553532, 0.0349585972726345, 0.0350198149681091, 0.0350810624659061, 0.0351423658430576, 0.03520368039608, 0.0352650284767151, 0.035326424986124, 0.0353878624737263, 0.0354493372142315, 0.0355108194053173, 0.0355723686516285, 0.0356339477002621, 0.0356955453753471, 0.0357572063803673, 0.0358188934624195, 0.0358805917203426, 0.0359423533082008, 0.0360041409730911, 0.0360659696161747, 0.036127831786871, 0.0361897312104702, 0.0362516529858112, 0.0363136194646358, 0.0363756418228149, 0.0364376716315746, 0.0364997386932373, 0.0365618690848351, 0.036624014377594, 0.0366862006485462, 0.0367484092712402, 0.0368106663227081, 0.036872960627079, 0.0369352772831917, 0.0369976572692394, 0.0370600558817387, 0.0371224768459797, 0.0371849462389946, 0.0372474640607834, 0.0373099967837334, 0.0373725667595863, 0.0374351963400841, 0.0374978259205818, 0.0375605262815952, 0.0376232378184795, 0.0376860052347183, 0.0377487912774086, 0.0378116182982922, 0.0378744788467884, 0.0379373840987682, 0.0380003154277802, 0.0380632802844048, 0.0381262935698032, 0.0381893403828144, 0.0382524244487286, 0.0383155457675457, 0.038378681987524, 0.0384418703615665, 0.038505095988512, 0.0385683588683605, 0.0386316515505314, 0.038694966584444, 0.0387583300471306, 0.0388217493891716, 0.0388851873576641, 0.0389486588537693, 0.0390121564269066, 0.0390757024288177, 0.0391392931342125, 0.0392029024660587, 0.0392665565013885, 0.0393302254378796, 0.0393939763307571, 0.0394577234983444, 0.0395215190947056, 0.03958535566926, 0.0396492145955563, 0.0397131331264973, 0.0397770628333092, 0.0398410335183144, 0.0399050451815128, 0.039969090372324, 0.0400331728160381, 0.040097288787365, 0.0401614494621754, 0.0402256362140179, 0.0402898490428925, 0.0403541103005409, 0.0404184199869633, 0.0404827520251274, 0.0405471213161945, 0.0406115129590034, 0.0406759679317474, 0.0407404378056526, 0.0408049523830414, 0.0408694893121719, 0.0409340746700764, 0.0409987047314644, 0.0410633459687233, 0.0411280579864979, 0.0411927774548531, 0.0412575267255306, 0.0413223393261433, 0.0413871556520462, 0.0414520390331745, 0.041516937315464, 0.0415818840265274, 0.0416468605399132, 0.0417118817567825, 0.0417769253253937, 0.0418420284986496, 0.0419071242213249, 0.0419722832739353, 0.0420374646782875, 0.0421027131378651, 0.0421679839491844, 0.0422332659363747, 0.0422986075282097, 0.0423639751970768, 0.0424293912947178, 0.0424948371946812, 0.0425602942705154, 0.0426258146762848, 0.0426913611590862, 0.0427569560706615, 0.0428225994110107, 0.0428882278501987, 0.0429539307951927, 0.0430196635425091, 0.0430854186415672, 0.0431512370705605, 0.043217059224844, 0.0432829335331917, 0.0433488562703133, 0.0434147901833057, 0.0434807799756527, 0.0435467883944511, 0.043612826615572, 0.0436789281666279, 0.0437450520694256, 0.0438112206757069, 0.0438773930072784, 0.043943639844656, 0.0440098978579044, 0.0440762080252171, 0.0441425554454327, 0.0442089177668095, 0.0442753247916698, 0.0443417765200138, 0.0444082580506802, 0.0444747805595398, 0.0445413291454315, 0.0446079149842262, 0.0446745529770851, 0.0447412095963955, 0.0448079071938992, 0.0448746308684349, 0.0449414029717445, 0.0450082011520863, 0.0450750440359116, 0.0451419353485107, 0.0452088303864002, 0.0452757887542248, 0.0453427694737911, 0.0454097874462605, 0.0454768538475037, 0.0455439239740372, 0.0456110499799252, 0.0456782169640064, 0.0457454212009907, 0.045812651515007, 0.0458799190819263, 0.0459472201764584, 0.0460145696997643, 0.0460819415748119, 0.0461493618786335, 0.0462168119847775, 0.0462842918932438, 0.0463518239557743, 0.046419370919466, 0.046486958861351, 0.0465545952320099, 0.04662224650383, 0.0466899573802948, 0.0467577055096626, 0.0468254499137402, 0.0468932762742043, 0.0469611100852489, 0.0470289885997772, 0.0470968969166279, 0.0471648536622524, 0.0472328439354897, 0.0473008491098881, 0.0473689250648022, 0.0474370196461678, 0.0475051403045654, 0.0475733131170273, 0.0476415008306503, 0.0477097555994987, 0.047778032720089, 0.0478463284671307, 0.0479146763682365, 0.0479830615222454, 0.0480514764785767, 0.0481199286878109, 0.0481884144246578, 0.0482569374144077, 0.0483255013823509, 0.0483940839767456, 0.0484627261757851, 0.0485313832759857, 0.0486000999808311, 0.0486688315868378, 0.0487376004457474, 0.0488064140081406, 0.0488752573728561, 0.0489441528916359, 0.0490130521357059, 0.0490820147097111, 0.0491510070860386, 0.0492200292646885, 0.0492890924215317, 0.0493581853806973, 0.0494273193180561, 0.0494964942336082, 0.0495656952261925, 0.0496349334716797, 0.0497042089700699, 0.0497735068202019, 0.0498428717255592, 0.0499122478067875, 0.0499816723167896, 0.0500511229038239, 0.0501206107437611, 0.0501901358366013, 0.0502597019076347, 0.0503293015062809, 0.0503989234566689, 0.050468597561121, 0.0505383089184761, 0.0506080538034439, 0.0506778284907341, 0.050747636705637, 0.0508174896240234, 0.0508873797953129, 0.0509573072195053, 0.0510272532701492, 0.0510972440242767, 0.0511672720313072, 0.051237341016531, 0.0513074360787868, 0.0513775758445263, 0.0514477454125881, 0.0515179559588432, 0.0515882037580013, 0.0516584701836109, 0.0517287813127041, 0.0517991296947002, 0.0518695265054703, 0.0519399456679821, 0.0520104020833969, 0.0520808883011341, 0.0521514192223549, 0.0522219948470592, 0.0522925928235054, 0.0523632280528545, 0.052433904260397, 0.0525046065449715, 0.0525753535330296, 0.0526461414992809, 0.052716962993145, 0.0527877993881702, 0.0528586842119694, 0.0529296137392521, 0.0530005805194378, 0.0530715696513653, 0.0531425997614861, 0.0532136633992195, 0.0532847717404366, 0.0533559024333954, 0.0534270815551281, 0.0534983053803444, 0.053569532930851, 0.0536408238112926, 0.0537121407687664, 0.0537834875285625, 0.0538548827171326, 0.0539262965321541, 0.0539977811276913, 0.0540692619979382, 0.0541407912969589, 0.0542123690247536, 0.0542839653789997, 0.0543556064367294, 0.0544272921979427, 0.0544989928603172, 0.0545707494020462, 0.0546425245702267, 0.054714348167181, 0.0547861978411674, 0.0548580810427666, 0.0549300275743008, 0.0550019703805447, 0.0550739802420139, 0.055146012455225, 0.0552180781960487, 0.0552901886403561, 0.0553623177111149, 0.0554345063865185, 0.0555067248642445, 0.0555789694190025, 0.0556512512266636, 0.0557235665619373, 0.055795930325985, 0.0558683276176453, 0.0559407509863377, 0.056013211607933, 0.0560857057571411, 0.0561582483351231, 0.0562308356165886, 0.0563034154474735, 0.056376077234745, 0.0564487427473068, 0.0565214641392231, 0.0565942190587521, 0.0566669926047325, 0.0567398332059383, 0.0568126812577248, 0.0568855665624142, 0.0569585151970387, 0.0570314601063728, 0.0571044720709324, 0.0571775063872337, 0.0572505742311478, 0.057323694229126, 0.0573968254029751, 0.0574700124561787, 0.0575432330369949, 0.0576164796948433, 0.0576897859573364, 0.057763084769249, 0.0578364506363869, 0.0579098500311375, 0.0579832755029202, 0.0580567494034767, 0.0581302344799042, 0.058203786611557, 0.0582773610949516, 0.0583509653806686, 0.0584246180951595, 0.0584982968866825, 0.0585720166563988, 0.0586457587778568, 0.0587195605039597, 0.0587933920323849, 0.0588672421872616, 0.0589411407709122, 0.0590150728821754, 0.0590890385210514, 0.0591630414128304, 0.0592370927333832, 0.0593111589550972, 0.0593852698802948, 0.0594594068825245, 0.0595336109399796, 0.0596078187227249, 0.0596820749342442, 0.0597563572227955, 0.0598306953907013, 0.0599050596356392, 0.0599794499576092, 0.0600538812577724, 0.060128353536129, 0.0602028630673885, 0.0602773986756802, 0.0603519827127457, 0.0604265928268433, 0.0605012439191341, 0.0605759210884571, 0.0606506504118443, 0.0607254095375538, 0.0608001910150051, 0.0608750283718109, 0.0609498918056488, 0.06102479621768, 0.0610997192561626, 0.0611746944487095, 0.0612497106194496, 0.0613247454166412, 0.0613998211920261, 0.0614749304950237, 0.0615500956773758, 0.0616252720355988, 0.0617005005478859, 0.0617757551372051, 0.061851043254137, 0.0619263723492622, 0.0620017349720001, 0.0620771571993828, 0.062152586877346, 0.062228050082922, 0.0623035579919815, 0.0623790994286537, 0.0624546818435192, 0.0625303015112877, 0.0626059472560883, 0.062681645154953, 0.0627573654055595, 0.0628331229090691, 0.0629089176654816, 0.0629847422242165, 0.0630606263875961, 0.0631365105509758, 0.0632124543190002, 0.0632884278893471, 0.0633644461631775, 0.0634404867887497, 0.0635165646672249, 0.0635926946997643, 0.0636688321828842, 0.0637450367212296, 0.0638212487101555, 0.0638975203037262, 0.0639738142490387, 0.0640501454472542, 0.0641265213489532, 0.0642029196023941, 0.0642793551087379, 0.0643558278679848, 0.0644323453307152, 0.0645088776946068, 0.0645854771137238, 0.0646620839834213, 0.0647387504577637, 0.0648154243826866, 0.0648921579122543, 0.0649689361453056, 0.0650457143783569, 0.0651225596666336, 0.0651994347572327, 0.0652763247489929, 0.0653532743453979, 0.0654302462935448, 0.0655072629451752, 0.0655843243002892, 0.0656614005565643, 0.0657399967312813, 0.0658200606703758, 0.0659001022577286, 0.0659801736474037, 0.0660602003335953, 0.0661402493715286, 0.0662202760577202, 0.0663003101944923, 0.0663803294301033, 0.0664603561162949, 0.0665403753519058, 0.0666203647851944, 0.0667003691196442, 0.0667803660035133, 0.0668603628873825, 0.0669403374195099, 0.0670203045010567, 0.0671003013849258, 0.0671802684664726, 0.0672602206468582, 0.0673401728272438, 0.0674201250076294, 0.067500077188015, 0.0675800368189812, 0.0676599591970444, 0.0677398890256882, 0.0678198114037514, 0.067899726331234, 0.0679796487092972, 0.068059541285038, 0.0681394562125206, 0.0682193413376808, 0.0682992413640022, 0.0683791264891624, 0.0684590041637421, 0.0685388743877411, 0.0686187446117401, 0.0686986148357391, 0.068778470158577, 0.0688583180308342, 0.0689381659030914, 0.0690180137753487, 0.0690978467464447, 0.0691776797175407, 0.0692575126886368, 0.0693373307585716, 0.0694171413779259, 0.0694969445466995, 0.069576770067215, 0.0696565508842468, 0.0697363391518593, 0.0698161348700523, 0.0698959156870842, 0.0699756890535355, 0.0700554549694061, 0.0701352283358574, 0.0702149793505669, 0.0702947378158569, 0.0703744888305664, 0.0704542323946953, 0.0705339685082436, 0.0706136971712112, 0.0706934332847595, 0.0707731544971466, 0.0708528682589531, 0.070932574570179, 0.0710122734308243, 0.0710919797420502, 0.0711716860532761, 0.071251355111599, 0.0713310539722443, 0.0714107230305672, 0.0714903920888901, 0.0715700536966324, 0.0716497227549553, 0.0717293843626976, 0.0718090236186981, 0.0718886703252792, 0.0719683021306992, 0.0720479413866997, 0.0721275731921196, 0.0722071900963783, 0.0722868144512177, 0.0723664313554764, 0.0724460259079933, 0.0725256279110909, 0.0726052150130272, 0.0726848170161247, 0.0727644041180611, 0.0728439763188362, 0.072923555970192, 0.0730031207203865, 0.0730826780200005, 0.073162242770195, 0.073241800069809, 0.0733213350176811, 0.0734008774161339, 0.073480412364006, 0.0735599473118782, 0.0736394599080086, 0.0737189874053001, 0.0737984925508499, 0.0738780051469803, 0.0739575028419495, 0.0740370079874992, 0.0741164982318878, 0.0741959661245346, 0.0742754563689232, 0.0743549466133118, 0.0744343996047974, 0.0745138674974442, 0.0745933279395103, 0.0746727734804153, 0.0747522264719009, 0.0748316645622253, 0.0749111026525497, 0.074990525841713, 0.0750699639320374, 0.0751493871212006, 0.075228787958622, 0.0753082036972046, 0.075387604534626, 0.075467012822628, 0.0755463913083076, 0.0756257846951485, 0.0757051706314087, 0.0757845416665077, 0.0758639052510262, 0.0759432837367058, 0.0760226398706436, 0.0761019885540009, 0.0761813372373581, 0.0762606933712959, 0.0763400197029114, 0.0764193460345268, 0.0764986798167229, 0.0765779912471771, 0.0766573175787926, 0.0767366290092468, 0.0768159329891205, 0.0768952220678329, 0.0769745260477066, 0.0770538151264191, 0.0771331042051315, 0.0772123709321022, 0.0772916525602341, 0.0773709043860435, 0.0774501711130142, 0.0775294378399849, 0.0776086822152138, 0.0776879191398621, 0.0777671560645103, 0.0778463929891586, 0.0779256224632263, 0.0780048370361328, 0.0780840665102005, 0.0781632736325264, 0.0782424658536911, 0.078321672976017, 0.0784008726477623, 0.078480064868927, 0.0785592496395111, 0.078638419508934, 0.0787176042795181, 0.0787967666983604, 0.0788759365677834, 0.0789550915360451, 0.0790342390537262, 0.0791133865714073, 0.0791925117373466, 0.0792716592550278, 0.0793507844209671, 0.0794299095869064, 0.0795090347528458, 0.0795881375670433, 0.079667255282402, 0.0797463431954384, 0.0798254460096359, 0.0799045339226723, 0.0799836218357086, 0.080062709748745, 0.0801417753100395, 0.0802208483219147, 0.0802999138832092, 0.0803789645433426, 0.0804580226540565, 0.0805370733141899, 0.0806161090731621, 0.0806951448321342, 0.0807741805911064, 0.080853208899498, 0.0809322223067284, 0.0810112357139587, 0.0810902491211891, 0.0811692476272583, 0.0812482386827469, 0.0813272297382355, 0.0814062282443047, 0.0814852118492126, 0.0815641731023788, 0.0816431492567062, 0.0817221105098724, 0.0818010792136192, 0.0818800330162048, 0.0819589719176292, 0.0820379182696342, 0.0821168571710587, 0.0821957886219025, 0.0822747275233269, 0.0823536291718483, 0.0824325531721115, 0.0825114622712135, 0.082590363919735, 0.0826692655682564, 0.0827481523156166, 0.082827053964138, 0.0829059258103371, 0.0829848051071167, 0.0830636844038963, 0.0831425487995148, 0.0832214057445526, 0.0833002552390099, 0.0833791121840477, 0.0834579616785049, 0.0835367888212204, 0.0836156234145164, 0.0836944505572319, 0.0837732776999474, 0.0838520899415016, 0.0839309021830559, 0.0840097069740295, 0.0840885043144226, 0.0841673091053963, 0.0842460989952087, 0.0843248814344406, 0.0844036638736725, 0.0844824314117432, 0.0845611989498138, 0.0846399590373039, 0.0847187265753746, 0.0847974643111229, 0.0848762094974518, 0.0849549546837807, 0.0850336849689484, 0.0851124078035355, 0.0851911380887032, 0.0852698534727097, 0.0853485688567162, 0.0854272767901421, 0.085505984723568, 0.0855846777558327, 0.0856633633375168, 0.0857420563697815, 0.085820734500885, 0.0858994051814079, 0.0859780684113503, 0.0860567316412926, 0.0861353874206543, 0.086214043200016, 0.0862926989793777, 0.0863713398575783, 0.0864499658346176, 0.0865286067128181, 0.0866072252392769, 0.0866858437657356, 0.0867644622921944, 0.0868430659174919, 0.0869216695427895, 0.087000273168087, 0.0870788618922234, 0.0871574506163597, 0.0872360244393349, 0.0873146057128906, 0.0873931795358658, 0.0874717310070992, 0.0875503048300743, 0.0876288563013077, 0.087707407772541, 0.0877859443426132, 0.0878644734621048, 0.087943010032177, 0.0880215391516685, 0.0881000608205795, 0.0881785824894905, 0.0882570743560791, 0.0883355960249901, 0.0884140804409981, 0.0884925872087479, 0.0885710790753365, 0.0886495560407639, 0.0887280330061913, 0.0888064950704575, 0.0888849645853043, 0.0889634341001511, 0.0890418812632561, 0.0891203284263611, 0.0891987755894661, 0.0892772153019905, 0.0893556401133537, 0.0894340723752975, 0.0895124897360802, 0.0895909070968628, 0.0896693170070648, 0.0897477269172668, 0.0898261293768883, 0.0899045243859291, 0.0899829119443893, 0.0900612995028496, 0.0901396870613098, 0.0902180373668671, 0.0902964100241661, 0.0903747752308846, 0.0904531329870224, 0.0905314832925797, 0.0906098261475563, 0.090688169002533, 0.0907665118575096, 0.0908448323607445, 0.0909231677651405, 0.0910014733672142, 0.0910797864198685, 0.0911580920219421, 0.0912363976240158, 0.0913146957755089, 0.0913929864764214, 0.0914712622761726, 0.0915495455265045, 0.0916278213262558, 0.0917060971260071, 0.091784343123436, 0.0918626114726067, 0.0919408574700356, 0.092019110918045, 0.0920973420143127, 0.0921755880117416, 0.0922538191080093, 0.0923320427536964, 0.0924102589488029, 0.0924884751439095, 0.0925666764378548, 0.0926448851823807, 0.0927230790257454, 0.0928012803196907, 0.0928794592618942, 0.0929576456546783, 0.0930358171463013, 0.0931139811873436, 0.0931921452283859, 0.0932703092694283, 0.09334846585989, 0.0934266149997711, 0.0935047492384911, 0.0935828909277916, 0.0936610326170921, 0.0937391445040703, 0.0938172712922096, 0.0938953831791878, 0.0939734876155853, 0.0940515995025635, 0.0941296964883804, 0.0942077860236168, 0.0942858755588531, 0.0943639650940895, 0.0944420397281647, 0.0945200994610786, 0.0945981815457344, 0.0946762338280678, 0.0947542861104012, 0.0948323458433151, 0.0949103757739067, 0.0949884206056595, 0.0950664430856705, 0.0951444804668427, 0.0952225029468536, 0.095300517976284, 0.095378540456295, 0.0954565331339836, 0.0955345332622528, 0.095612533390522, 0.0956905111670494, 0.095768503844738, 0.0958464816212654, 0.0959244519472122, 0.096002422273159, 0.0960803776979446, 0.0961583405733109, 0.0962362810969353, 0.0963142365217209, 0.0963921770453453, 0.0964701026678085, 0.0965480357408524, 0.096625953912735, 0.0967038795351982, 0.0967817977070808, 0.0968596860766411, 0.0969375967979431, 0.0970154851675034, 0.0970933809876442, 0.0971712619066238, 0.0972491428256035, 0.0973270237445831, 0.097404882311821, 0.09748275578022, 0.0975606068968773, 0.0976384580135345, 0.0977163091301918, 0.0977941527962685, 0.0978719890117645, 0.0979498103260994, 0.0980276316404343, 0.0981054604053497, 0.0981832668185234, 0.0982610806822777, 0.0983388870954514, 0.0984166786074638, 0.0984944775700569, 0.0985722616314888, 0.0986500382423401, 0.098727822303772, 0.0988055765628815, 0.0988833457231522, 0.0989610999822617, 0.0990388542413712, 0.0991166085004807, 0.0991943627595901, 0.0992720872163773, 0.0993498116731644, 0.0994275361299515, 0.0995052680373192, 0.0995829775929451, 0.099660687148571, 0.0997383892536163, 0.0998160913586617, 0.0998937860131264, 0.0999714732170105, 0.100049160420895, 0.100126825273037, 0.10020450502634, 0.100282169878483, 0.100359819829464, 0.100437484681606, 0.100515127182007, 0.100592769682407, 0.100670412182808, 0.100748039782047, 0.100825674831867, 0.100903287529945, 0.100980907678604, 0.101058520376682, 0.101136118173599, 0.101213730871677, 0.101291313767433, 0.10136891156435, 0.101446487009525, 0.101524069905281, 0.101601637899876, 0.10167920589447, 0.101756766438484, 0.101834326982498, 0.101911872625351, 0.101989418268204, 0.102066963911057, 0.102144502103329, 0.10222202539444, 0.10229954123497, 0.102377064526081, 0.10245456546545, 0.102532081305981, 0.10260958969593, 0.102687083184719, 0.102764569222927, 0.102842047810555, 0.102919533848763, 0.102997004985809, 0.103074468672276, 0.103151932358742, 0.103229403495789, 0.103306852281094, 0.103384293615818, 0.103461727499962, 0.103539176285267, 0.10361660271883, 0.103694029152393, 0.103771440684795, 0.103848852217197, 0.103926263749599, 0.10400366038084, 0.104081064462662, 0.104158461093903, 0.104235842823982, 0.104313224554062, 0.10439059138298, 0.104467965662479, 0.104545332491398, 0.104622684419155, 0.104700043797493, 0.10477738827467, 0.104854725301266, 0.104932069778442, 0.105009399354458, 0.105086229741573, 0.105162486433983, 0.105238698422909, 0.105314843356609, 0.105390928685665, 0.105466976761818, 0.105542950332165, 0.105618886649609, 0.105694770812988, 0.105770595371723, 0.105846360325813, 0.105922065675259, 0.10599771887064, 0.106073334813118, 0.106148883700371, 0.106224380433559, 0.106299810111523, 0.106375202536583, 0.106450542807579, 0.10652581602335, 0.106601029634476, 0.106676205992699, 0.106751315295696, 0.10682637244463, 0.106901384890079, 0.106976330280304, 0.107051216065884, 0.10712606459856, 0.107200853526592, 0.10727559030056, 0.107350267469883, 0.107424877583981, 0.107499450445175, 0.107573971152306, 0.10764841735363, 0.107722833752632, 0.107797175645828, 0.107871480286121, 0.107945717871189, 0.108019903302193, 0.108094036579132, 0.108168110251427, 0.108242131769657, 0.108316108584404, 0.108390018343925, 0.108463875949383, 0.108537673950195, 0.108611427247524, 0.10868513584137, 0.108758762478828, 0.108832359313965, 0.108905881643295, 0.108979366719723, 0.109052784740925, 0.109126150608063, 0.109199471771717, 0.109272725880146, 0.109345935285091, 0.109419085085392, 0.109492182731628, 0.109565235674381, 0.109638206660748, 0.109711155295372, 0.109784029424191, 0.109856843948364, 0.109929613769054, 0.11000233143568, 0.110074989497662, 0.110147595405579, 0.110220141708851, 0.11029264330864, 0.110365085303783, 0.110437467694283, 0.110509812831879, 0.110582083463669, 0.110654309391975, 0.110726475715637, 0.110798589885235, 0.110870651900768, 0.110942654311657, 0.111014612019062, 0.111086502671242, 0.111158348619938, 0.111230134963989, 0.111301861703396, 0.111373551189899, 0.111445173621178, 0.111516736447811, 0.111588254570961, 0.111659713089466, 0.111731119453907, 0.111802481114864, 0.111873768270016, 0.111945018172264, 0.112016201019287, 0.112087346613407, 0.112158410251141, 0.112229444086552, 0.112300403416157, 0.112371325492859, 0.112442187964916, 0.112512983381748, 0.112583741545677, 0.112654447555542, 0.112725086510181, 0.112795665860176, 0.112866200506687, 0.112936675548553, 0.113007105886936, 0.113077476620674, 0.113147795200348, 0.113218061625957, 0.113288268446922, 0.113358415663242, 0.113428510725498, 0.11349856108427, 0.113568551838398, 0.113638482987881, 0.113708361983299, 0.113778188824654, 0.113847956061363, 0.113917678594589, 0.11398733407259, 0.114056929945946, 0.114126496016979, 0.114196002483368, 0.114265441894531, 0.11433482915163, 0.114404156804085, 0.114473439753056, 0.114542670547962, 0.114611841738224, 0.114680953323841, 0.114750005304813, 0.114819020032883, 0.114887982606888, 0.114956878125668, 0.115025714039803, 0.115094505250454, 0.115163236856461, 0.115231923758984, 0.115300551056862, 0.115369111299515, 0.115437634289265, 0.11550610512495, 0.11557450145483, 0.115642853081226, 0.115711152553558, 0.115779392421246, 0.115847580134869, 0.115915715694427, 0.115983799099922, 0.116051830351353, 0.116119809448719, 0.116187714040279, 0.116255588829517, 0.116323389112949, 0.116391137242317, 0.116458848118782, 0.11652647703886, 0.116594068706036, 0.116661623120308, 0.116729095578194, 0.116796523332596, 0.116863898932934, 0.116931214928627, 0.116998471319675, 0.11706567555666, 0.11713282763958, 0.117199920117855, 0.117266982793808, 0.117333956062794, 0.117400914430618, 0.117467783391476, 0.11753461509943, 0.11760139465332, 0.117668092250824, 0.117734767496586, 0.117801368236542, 0.117867924273014, 0.117934420704842, 0.118000864982605, 0.118067249655724, 0.118133589625359, 0.118199869990349, 0.118266120553017, 0.118332289159298, 0.118398398160934, 0.118464462459087, 0.118530467152596, 0.118596419692039, 0.118662320077419, 0.118728168308735, 0.118793964385986, 0.118859685957432, 0.118925377726555, 0.118991009891033, 0.119056575000286, 0.119122095406055, 0.11918755620718, 0.119252972304821, 0.119318313896656, 0.119383633136749, 0.119448870420456, 0.119514048099518, 0.119579203426838, 0.119644276797771, 0.119709298014641, 0.119774267077446, 0.119839198887348, 0.119904063642025, 0.119968868792057, 0.120033629238605, 0.120098330080509, 0.120162963867188, 0.120227575302124, 0.120292104780674, 0.120356597006321, 0.120421007275581, 0.120485387742519, 0.120549701154232, 0.120613969862461, 0.120678178966045, 0.120742335915565, 0.12080642580986, 0.120870485901833, 0.120934471487999, 0.120998404920101, 0.12106229364872, 0.121126107871532, 0.121189907193184, 0.121253624558449, 0.12131728976965, 0.121380887925625, 0.121444441378117, 0.121507950127125, 0.121571384370327, 0.121634781360626, 0.121698118746281, 0.121761411428452, 0.121824637055397, 0.121887817978859, 0.121950924396515, 0.122013993561268, 0.122077003121376, 0.122139953076839, 0.1222028657794, 0.122265711426735, 0.122328497469425, 0.122391231358051, 0.122453905642033, 0.122516550123692, 0.122579120099545, 0.122641645371914, 0.122704111039639, 0.122766524553299, 0.122828871011734, 0.122891180217266, 0.122953429818153, 0.123015604913235, 0.123077750205994, 0.123139835894108, 0.123201861977577, 0.123263835906982, 0.123325757682323, 0.1233876273036, 0.123449437320232, 0.123511202633381, 0.123572900891304, 0.123634554445744, 0.123696140944958, 0.123757675290108, 0.123819157481194, 0.123880587518215, 0.123941965401173, 0.124003283679485, 0.124064557254314, 0.124125771224499, 0.124186918139458, 0.124248020350933, 0.124309070408344, 0.124370075762272, 0.124430999159813, 0.124491892755032, 0.124552711844444, 0.124613493680954, 0.124674215912819, 0.124734871089458, 0.124795489013195, 0.124856054782867, 0.124916546046734, 0.124976992607117, 0.125037387013435, 0.125097721815109, 0.1251580119133, 0.125218257308006, 0.125278413295746, 0.125338539481163, 0.125398606061935, 0.125458613038063, 0.125518575310707, 0.125578477978706, 0.125638335943222, 0.125698119401932, 0.125757873058319, 0.125817537307739, 0.125877186655998, 0.125936761498451, 0.125996261835098, 0.126055732369423, 0.126115158200264, 0.126174509525299, 0.126233816146851, 0.126293063163757, 0.126352250576019, 0.126411393284798, 0.126470476388931, 0.126529514789581, 0.126588493585587, 0.126647412776947, 0.126706272363663, 0.126765087246895, 0.126823857426643, 0.126882538199425, 0.126941204071045, 0.126999795436859, 0.12705834209919, 0.127116829156876, 0.127175241708755, 0.127233624458313, 0.127291947603226, 0.127350226044655, 0.127408429980278, 0.127466589212418, 0.127524703741074, 0.127582743763924, 0.12764073908329, 0.127698689699173, 0.12775656580925, 0.127814397215843, 0.127872169017792, 0.127929896116257, 0.127987578511238, 0.128045171499252, 0.128102734684944, 0.128160238265991, 0.128217697143555, 0.128275066614151, 0.128332436084747, 0.128389701247215, 0.128446951508522, 0.128504127264023, 0.128561243414879, 0.128618314862251, 0.128675326704979, 0.128732278943062, 0.128789201378822, 0.128846034407616, 0.128902837634087, 0.128959581255913, 0.129016265273094, 0.129072889685631, 0.129129469394684, 0.129185989499092, 0.129242449998856, 0.129298865795135, 0.129355236887932, 0.129411533474922, 0.129467785358429, 0.129523992538452, 0.129580125212669, 0.129636198282242, 0.129692256450653, 0.129748225212097, 0.129804149270058, 0.129860013723373, 0.129915818572044, 0.129971578717232, 0.130027294158936, 0.130082949995995, 0.130138546228409, 0.130194082856178, 0.130249559879303, 0.130304992198944, 0.13036036491394, 0.130415707826614, 0.130470976233482, 0.130526185035706, 0.130581349134445, 0.130636438727379, 0.130691513419151, 0.130746498703957, 0.130801439285278, 0.130856320261955, 0.130911156535149, 0.130965948104858, 0.131020665168762, 0.131075337529182, 0.131129950284958, 0.13118451833725, 0.131239026784897, 0.131293475627899, 0.131347864866257, 0.131402194499969, 0.13145649433136, 0.131510719656944, 0.131564900279045, 0.131619021296501, 0.131673097610474, 0.131727114319801, 0.131781071424484, 0.131834968924522, 0.131888821721077, 0.131942629814148, 0.131996363401413, 0.132050052285194, 0.132103681564331, 0.132157266139984, 0.132210791110992, 0.132264256477356, 0.132317677140236, 0.132371038198471, 0.132424354553223, 0.132477596402168, 0.132530778646469, 0.132583931088448, 0.132637038826942, 0.13269005715847, 0.132743045687675, 0.132795959711075, 0.132848843932152, 0.132901653647423, 0.132954403758049, 0.133007124066353, 0.133059769868851, 0.133112370967865, 0.133164897561073, 0.133217394351959, 0.133269816637039, 0.133322209119797, 0.133374527096748, 0.133426800370216, 0.133479028940201, 0.133531183004379, 0.133583307266235, 0.133635342121124, 0.133687347173691, 0.133739277720451, 0.133791163563728, 0.133843004703522, 0.133894801139832, 0.133946523070335, 0.133998185396194, 0.13404980301857, 0.134101361036301, 0.134152874350548, 0.13420432806015, 0.134255722165108, 0.134307056665421, 0.13435834646225, 0.134409591555595, 0.134460762143135, 0.134511902928352, 0.134562969207764, 0.13461397588253, 0.134664952754974, 0.134715855121613, 0.134766712784767, 0.134817495942116, 0.134868249297142, 0.134918928146362, 0.13496957719326, 0.135020151734352, 0.13507068157196, 0.135121151804924, 0.135171562433243, 0.135221928358078, 0.135272219777107, 0.135322496294975, 0.135372698307037, 0.135422840714455, 0.135472938418388, 0.135522976517677, 0.13557294011116, 0.13562285900116, 0.135672733187675, 0.135722562670708, 0.135772317647934, 0.135822027921677, 0.135871693491936, 0.135921269655228, 0.135970830917358, 0.136020317673683, 0.136069744825363, 0.136119142174721, 0.136168450117111, 0.136217728257179, 0.136266961693764, 0.136316120624542, 0.136365219950676, 0.136412382125854, 0.136457577347755, 0.13650269806385, 0.136547699570656, 0.136592656373978, 0.136637508869171, 0.136682271957397, 0.136726960539818, 0.136771559715271, 0.136816084384918, 0.136860519647598, 0.13690485060215, 0.136949121952057, 0.136993303894997, 0.137037396430969, 0.137081414461136, 0.137125343084335, 0.137169182300568, 0.137212932109833, 0.137256607413292, 0.137300208210945, 0.137343689799309, 0.137387126684189, 0.137430444359779, 0.137473717331886, 0.137516885995865, 0.137559950351715, 0.137602955102921, 0.137645870447159, 0.13768869638443, 0.137731432914734, 0.137774094939232, 0.137816682457924, 0.137859180569649, 0.137901589274406, 0.137943908572197, 0.13798613846302, 0.138028308749199, 0.138070359826088, 0.138112351298332, 0.138154253363609, 0.138196066021919, 0.138237789273262, 0.13827945291996, 0.138321027159691, 0.138362497091293, 0.13840389251709, 0.138445198535919, 0.138486415147781, 0.138527557253838, 0.138568624854088, 0.13860958814621, 0.138650491833687, 0.138691291213036, 0.138732001185417, 0.138772636651993, 0.138813197612762, 0.138853654265404, 0.1388940513134, 0.138934344053268, 0.138974547386169, 0.139014676213264, 0.139054715633392, 0.139094680547714, 0.139134556055069, 0.139174342155457, 0.139214053750038, 0.139253690838814, 0.1392932087183, 0.139332666993141, 0.139372050762177, 0.139411330223083, 0.139450520277023, 0.139489635825157, 0.139528676867485, 0.139567613601685, 0.139606475830078, 0.139645263552666, 0.139683961868286, 0.139722570776939, 0.139761090278625, 0.139799535274506, 0.139837890863419, 0.139876157045364, 0.139914348721504, 0.139952450990677, 0.139990478754044, 0.140028417110443, 0.140066266059875, 0.140104040503502, 0.140141710639, 0.140179306268692, 0.140216797590256, 0.140254259109497, 0.140291586518288, 0.140328839421272, 0.140366017818451, 0.140403106808662, 0.140440121293068, 0.140477046370506, 0.140513882040977, 0.140550643205643, 0.14058730006218, 0.140623897314072, 0.140660375356674, 0.140696808695793, 0.140733137726784, 0.140769392251968, 0.140805542469025, 0.140841618180275, 0.140877619385719, 0.140913516283035, 0.140949353575706, 0.140985086560249, 0.141020759940147, 0.141056314110756, 0.14109180867672, 0.141127198934555, 0.141162529587746, 0.141197770833969, 0.141232907772064, 0.141267970204353, 0.141302958130836, 0.141337856650352, 0.141372665762901, 0.141407400369644, 0.14144204556942, 0.141476601362228, 0.14151106774807, 0.141545459628105, 0.141579762101173, 0.141613990068436, 0.141648128628731, 0.141682177782059, 0.141716137528419, 0.141750022768974, 0.141783833503723, 0.141817554831505, 0.141851171851158, 0.141884729266167, 0.141918182373047, 0.141951560974121, 0.141984850168228, 0.142018064856529, 0.142051190137863, 0.14208422601223, 0.142117187380791, 0.142150059342384, 0.142182856798172, 0.142215549945831, 0.142248168587685, 0.14228068292141, 0.14231313765049, 0.142345502972603, 0.142377778887749, 0.142409980297089, 0.142442092299461, 0.142474129796028, 0.142506062984467, 0.14253793656826, 0.142569705843925, 0.142601400613785, 0.142633005976677, 0.142664507031441, 0.14269594848156, 0.142727300524712, 0.142758578062057, 0.142789766192436, 0.142820850014687, 0.142851874232292, 0.142882809042931, 0.142913639545441, 0.142944410443306, 0.142975077033043, 0.143005669116974, 0.143036186695099, 0.143066599965096, 0.143096938729286, 0.143127202987671, 0.143157377839088, 0.143187463283539, 0.143217474222183, 0.143247380852699, 0.143277212977409, 0.143306955695152, 0.143336623907089, 0.143366202712059, 0.143395692110062, 0.143425107002258, 0.143454432487488, 0.143483683466911, 0.143512830138206, 0.143541902303696, 0.143570899963379, 0.143599808216095, 0.143628641963005, 0.143657356500626, 0.143686011433601, 0.14371457695961, 0.143743053078651, 0.143771454691887, 0.143799781799316, 0.143828004598618, 0.143856152892113, 0.14388419687748, 0.143912196159363, 0.143940076231956, 0.143967881798744, 0.143995612859726, 0.144023239612579, 0.144050806760788, 0.144078284502029, 0.144105657935143, 0.14413295686245, 0.144160181283951, 0.144187316298485, 0.144214361906052, 0.144241333007812, 0.144268199801445, 0.144294992089272, 0.144321709871292, 0.144348323345184, 0.144374877214432, 0.144401326775551, 0.144427701830864, 0.14445398747921, 0.144480213522911, 0.144506320357323, 0.144532352685928, 0.144558310508728, 0.144584164023399, 0.144609943032265, 0.144635662436485, 0.144661277532578, 0.144686788320541, 0.14471223950386, 0.144737601280212, 0.144762858748436, 0.144788071513176, 0.144813165068626, 0.144838184118271, 0.144863128662109, 0.144887983798981, 0.144912764430046, 0.144937440752983, 0.144962042570114, 0.144986554980278, 0.145010992884636, 0.145035341382027, 0.14505960047245, 0.145083785057068, 0.145107865333557, 0.145131886005402, 0.145155817270279, 0.145179659128189, 0.145203411579132, 0.145227089524269, 0.145250663161278, 0.145274177193642, 0.145297601819038, 0.145320937037468, 0.14534418284893, 0.145367354154587, 0.145390436053276, 0.145413398742676, 0.145436346530914, 0.145459160208702, 0.145481899380684, 0.14550456404686, 0.145527139306068, 0.145549640059471, 0.145572036504745, 0.145594358444214, 0.145616590976715, 0.145638763904572, 0.145660817623138, 0.145682811737061, 0.145704716444016, 0.145726531744003, 0.145748257637024, 0.145769894123077, 0.145791471004486, 0.145812943577766, 0.145834341645241, 0.145855650305748, 0.145876869559288, 0.145898029208183, 0.145919069647789, 0.14594005048275, 0.145960912108421, 0.145981729030609, 0.14600245654583, 0.146023094654083, 0.14604364335537, 0.146064087748528, 0.146084487438202, 0.146104782819748, 0.146124988794327, 0.1461451202631, 0.146165162324905, 0.146185129880905, 0.146204993128777, 0.146224781870842, 0.146244496107101, 0.146264106035233, 0.146283656358719, 0.146303102374077, 0.146322458982468, 0.146341755986214, 0.146360948681831, 0.146380066871643, 0.146399095654488, 0.146418049931526, 0.146436914801598, 0.146455690264702, 0.146474391222, 0.14649298787117, 0.146511510014534, 0.146529957652092, 0.146548300981522, 0.146566584706306, 0.146584779024124, 0.146602869033813, 0.146620884537697, 0.146638810634613, 0.146656677126884, 0.146674424409866, 0.146692112088203, 0.146709725260735, 0.146727234125137, 0.146744653582573, 0.146761998534203, 0.146779254078865, 0.146796435117722, 0.14681351184845, 0.146830528974533, 0.146847456693649, 0.146864280104637, 0.146881029009819, 0.146897703409195, 0.146914288401604, 0.146930783987045, 0.146947205066681, 0.146963521838188, 0.146979764103889, 0.146995931863785, 0.147012025117874, 0.147028014063835, 0.147043913602829, 0.147059738636017, 0.147075474262238, 0.147091135382652, 0.1471067070961, 0.147122204303741, 0.147137597203255, 0.147152915596962, 0.147168144583702, 0.147183299064636, 0.147198364138603, 0.147213339805603, 0.147228240966797, 0.147243052721024, 0.147257775068283, 0.147272408008575, 0.147286981344223, 0.147301435470581, 0.147315844893456, 0.14733013510704, 0.147344365715981, 0.147358492016792, 0.147372558712959, 0.147386521100998, 0.147400394082069, 0.147414177656174, 0.147427901625633, 0.147441551089287, 0.147455096244812, 0.14746855199337, 0.147481918334961, 0.147495210170746, 0.147508427500725, 0.147521555423737, 0.14753457903862, 0.147547543048859, 0.14756041765213, 0.147573187947273, 0.147585913538933, 0.147598519921303, 0.147611051797867, 0.147623494267464, 0.147635862231255, 0.14764815568924, 0.147660329937935, 0.147672429680824, 0.147684469819069, 0.147696420550346, 0.147708266973495, 0.147720053792, 0.147731736302376, 0.147743344306946, 0.147754848003387, 0.147766292095184, 0.147777646780014, 0.147788926959038, 0.147800087928772, 0.147811204195023, 0.147822201251984, 0.1478331387043, 0.147843986749649, 0.147854745388031, 0.147865429520607, 0.147876024246216, 0.147886499762535, 0.147896945476532, 0.147907271981239, 0.147917538881302, 0.147927701473236, 0.147937774658203, 0.147947788238525, 0.147957697510719, 0.147967532277107, 0.147977292537689, 0.147986933588982, 0.14799652993679, 0.14800600707531, 0.148015439510345, 0.148024752736092, 0.148034006357193, 0.148043170571327, 0.148052245378494, 0.148061215877533, 0.148070111870766, 0.148078933358192, 0.148087665438652, 0.148096323013306, 0.148104891180992, 0.148113384842873, 0.148121759295464, 0.14813007414341, 0.14813831448555, 0.148146450519562, 0.148154526948929, 0.148162499070168, 0.1481703966856, 0.148178189992905, 0.148185908794403, 0.148193538188934, 0.148201107978821, 0.148208573460579, 0.14821594953537, 0.148223266005516, 0.148230493068695, 0.148237600922585, 0.148244649171829, 0.148251622915268, 0.148258492350578, 0.148265302181244, 0.148272007703781, 0.148278638720512, 0.148285150527954, 0.148291617631912, 0.148297995328903, 0.148304283618927, 0.148310497403145, 0.148316621780396, 0.148322641849518, 0.148328587412834, 0.148334443569183, 0.148340255022049, 0.148345932364464, 0.148351535201073, 0.148357078433037, 0.148362517356873, 0.148367881774902, 0.148373141884804, 0.14837834239006, 0.14838345348835, 0.148388475179672, 0.148393407464027, 0.148398265242577, 0.148403018712997, 0.148407727479935, 0.148412331938744, 0.148416817188263, 0.14842127263546, 0.148425608873367, 0.148429870605469, 0.148434042930603, 0.148438140749931, 0.148442134261131, 0.148446068167686, 0.148449912667274, 0.148453667759895, 0.148457333445549, 0.148460924625397, 0.148464441299438, 0.148467838764191, 0.14847120642662, 0.1484744399786, 0.148477584123611, 0.148478865623474, 0.148478254675865, 0.148477554321289, 0.148476764559746, 0.148475915193558, 0.14847494661808, 0.148473918437958, 0.148472785949707, 0.14847157895565, 0.148470267653465, 0.148468911647797, 0.148467451334, 0.148465886712074, 0.148464262485504, 0.148462548851967, 0.148460745811462, 0.148458853363991, 0.148456886410713, 0.148454830050468, 0.148452669382095, 0.148450464010239, 0.148448154330254, 0.148445755243301, 0.148443281650543, 0.148440718650818, 0.148438066244125, 0.148435339331627, 0.148432493209839, 0.148429602384567, 0.148426622152328, 0.148423537611961, 0.148420393466949, 0.148417145013809, 0.148413822054863, 0.14841040968895, 0.14840692281723, 0.148403331637383, 0.148399665951729, 0.148395910859108, 0.148392081260681, 0.148388162255287, 0.148384168744087, 0.148380070924759, 0.148375883698463, 0.148371636867523, 0.148367285728455, 0.148362874984741, 0.148358345031738, 0.148353755474091, 0.148349091410637, 0.148344308137894, 0.148339450359344, 0.148334532976151, 0.148329496383667, 0.148324385285378, 0.148319214582443, 0.148313924670219, 0.148308575153351, 0.148303136229515, 0.148297592997551, 0.148291990160942, 0.148286268115044, 0.148280501365662, 0.148274645209312, 0.148268684744835, 0.14826263487339, 0.148256525397301, 0.148250311613083, 0.14824403822422, 0.148237645626068, 0.148231193423271, 0.148224651813507, 0.148218020796776, 0.148211300373077, 0.148204490542412, 0.148197621107101, 0.148190647363663, 0.148183584213257, 0.148176461458206, 0.148169219493866, 0.148161932826042, 0.148154526948929, 0.14814704656601, 0.148139491677284, 0.148131847381592, 0.148124098777771, 0.148116305470467, 0.148108407855034, 0.148100420832634, 0.148092344403267, 0.148084178566933, 0.148075923323631, 0.148067623376846, 0.148059219121933, 0.148050725460052, 0.148042127490044, 0.148033484816551, 0.148024722933769, 0.148015916347504, 0.148006975650787, 0.147997975349426, 0.147988900542259, 0.147979721426964, 0.147970467805862, 0.147961109876633, 0.147951692342758, 0.147942185401917, 0.147932589054108, 0.147922918200493, 0.14791314303875, 0.147903308272362, 0.147893354296684, 0.147883340716362, 0.147873237729073, 0.147863060235977, 0.147852778434753, 0.147842422127724, 0.147831976413727, 0.147821456193924, 0.147810831665993, 0.147800132632256, 0.147789373993874, 0.147778496146202, 0.147767543792725, 0.147756516933441, 0.147745385766029, 0.147734180092812, 0.147722899913788, 0.147711515426636, 0.147700071334839, 0.147688522934914, 0.147676900029182, 0.147665187716484, 0.147653385996819, 0.147641509771347, 0.147629529237747, 0.147617489099503, 0.14760534465313, 0.147593125700951, 0.147580832242966, 0.147568419575691, 0.147555947303772, 0.147543370723724, 0.147530749440193, 0.147518008947372, 0.147505208849907, 0.147492304444313, 0.147479310631752, 0.147466257214546, 0.147453114390373, 0.147439852356911, 0.147426545619965, 0.147413149476051, 0.147399634122849, 0.147386074066162, 0.147372409701347, 0.147358655929565, 0.147344827651978, 0.147330924868584, 0.147316917777061, 0.147302821278572, 0.147288665175438, 0.147274404764175, 0.147260069847107, 0.147245645523071, 0.14723114669323, 0.14721654355526, 0.147201865911484, 0.147187098860741, 0.14717224240303, 0.147157311439514, 0.147142305970192, 0.147127196192741, 0.147112011909485, 0.147096753120422, 0.147081390023232, 0.147065952420235, 0.147050425410271, 0.147034823894501, 0.147019132971764, 0.147003352642059, 0.146987482905388, 0.14697153866291, 0.146955505013466, 0.146939381957054, 0.146923184394836, 0.146906897425652, 0.1468905210495, 0.14687405526638, 0.146857514977455, 0.146840900182724, 0.146824195981026, 0.14680740237236, 0.146790504455566, 0.146773546934128, 0.146756500005722, 0.14673937857151, 0.146722137928009, 0.146704837679863, 0.14668744802475, 0.146669983863831, 0.146652415394783, 0.14663477241993, 0.146617040038109, 0.146599233150482, 0.14658135175705, 0.146563366055489, 0.146545305848122, 0.146527156233788, 0.146508902311325, 0.146490588784218, 0.146472170948982, 0.146453693509102, 0.146435126662254, 0.146416455507278, 0.146397709846497, 0.146378889679909, 0.146359965205193, 0.146340981125832, 0.146321892738342, 0.146302729845047, 0.146283477544785, 0.146264120936394, 0.146244719624519, 0.146225214004517, 0.146205604076385, 0.146185949444771, 0.146166175603867, 0.146146327257156, 0.146126419305801, 0.146106392145157, 0.146086290478706, 0.146066099405289, 0.146045848727226, 0.146025478839874, 0.146005049347878, 0.145984530448914, 0.145963922142982, 0.145943224430084, 0.145922437310219, 0.145901590585709, 0.14588063955307, 0.145859614014626, 0.145838499069214, 0.145817294716835, 0.145796000957489, 0.145774632692337, 0.145753175020218, 0.145731642842293, 0.145710021257401, 0.145688325166702, 0.145666524767876, 0.145644649863243, 0.145622685551643, 0.145600631833076, 0.145578488707542, 0.145556285977364, 0.145533978939056, 0.145511597394943, 0.145489126443863, 0.145466551184654, 0.145443916320801, 0.145421206951141, 0.145398393273354, 0.14537550508976, 0.145352527499199, 0.145329460501671, 0.145306304097176, 0.145283073186874, 0.145259752869606, 0.145236358046532, 0.145212858915329, 0.14518928527832, 0.145165637135506, 0.145141899585724, 0.145118057727814, 0.145094156265259, 0.145070165395737, 0.145046085119247, 0.145021915435791, 0.144997671246529, 0.144973322749138, 0.144948914647102, 0.144924402236938, 0.144899815320969, 0.144875138998032, 0.144850373268127, 0.144825533032417, 0.14480060338974, 0.144775584340096, 0.144750505685806, 0.144725307822227, 0.144700050354004, 0.144674703478813, 0.144649267196655, 0.14462374150753, 0.144598141312599, 0.144572451710701, 0.144546672701836, 0.144520804286003, 0.144494876265526, 0.14446884393692, 0.144442737102509, 0.14441654086113, 0.144390240311623, 0.14436386525631, 0.144337445497513, 0.144310891628265, 0.144284263253212, 0.144257560372353, 0.144230768084526, 0.144203901290894, 0.144176930189133, 0.144149884581566, 0.144122764468193, 0.144095540046692, 0.144068256020546, 0.144040867686272, 0.14401338994503, 0.143985837697983, 0.143958196043968, 0.143930464982986, 0.143902659416199, 0.143874779343605, 0.143846794962883, 0.143818721175194, 0.143790602684021, 0.143762350082397, 0.143734037876129, 0.143705636262894, 0.143677160143852, 0.143648594617844, 0.143619939684868, 0.143591195344925, 0.143562361598015, 0.14353346824646, 0.143504470586777, 0.143475383520126, 0.14344622194767, 0.143416970968246, 0.143387630581856, 0.14335823059082, 0.143328726291656, 0.143299132585526, 0.143269464373589, 0.143239706754684, 0.143209874629974, 0.143179938197136, 0.143149927258492, 0.14311982691288, 0.143089652061462, 0.143059402704239, 0.143029034137726, 0.142998605966568, 0.142968088388443, 0.142937481403351, 0.142906799912453, 0.142876029014587, 0.142845183610916, 0.142814218997955, 0.14278319478035, 0.142752081155777, 0.142720878124237, 0.142689615488052, 0.142658248543739, 0.142626792192459, 0.142595261335373, 0.14256364107132, 0.14253194630146, 0.142500147223473, 0.142468273639679, 0.142436310648918, 0.14240425825119, 0.142372146248817, 0.142339929938316, 0.142307624220848, 0.142275243997574, 0.142242789268494, 0.142210230231285, 0.142177596688271, 0.142144873738289, 0.14211206138134, 0.142079174518585, 0.142046198248863, 0.142013147473335, 0.141979992389679, 0.141946762800217, 0.141913458704948, 0.141880050301552, 0.141846567392349, 0.14181299507618, 0.141779363155365, 0.141745612025261, 0.141711786389351, 0.141677886247635, 0.141643881797791, 0.141609817743301, 0.141575649380684, 0.14154140651226, 0.14150707423687, 0.141472667455673, 0.141438171267509, 0.141403570771217, 0.14136891067028, 0.141334161162376, 0.141299322247505, 0.141264393925667, 0.141229376196861, 0.14119428396225, 0.141159102320671, 0.141123846173286, 0.141088500618935, 0.141053065657616, 0.141017556190491, 0.140981957316399, 0.140946254134178, 0.140910506248474, 0.140874639153481, 0.140838712453842, 0.140802681446075, 0.140766561031342, 0.140730381011963, 0.140694096684456, 0.140657737851143, 0.140621274709702, 0.140584751963615, 0.140548139810562, 0.140511438250542, 0.140474647283554, 0.140437766909599, 0.140400812029839, 0.140363782644272, 0.140326648950577, 0.140289440751076, 0.140252143144608, 0.140214756131172, 0.140177294611931, 0.140139758586884, 0.140102118253708, 0.140064403414726, 0.140026584267616, 0.139988705515862, 0.139950722455978, 0.139912664890289, 0.139874532818794, 0.139836311340332, 0.139797985553741, 0.139759585261345, 0.139721110463142, 0.139682546257973, 0.139643907546997, 0.139605149626732, 0.139566347002983, 0.139527425169945, 0.139488443732262, 0.139449372887611, 0.139410212635994, 0.139370962977409, 0.13933165371418, 0.139292225241661, 0.139252737164497, 0.139213144779205, 0.139173462986946, 0.139133736491203, 0.139093890786171, 0.139053970575333, 0.139013960957527, 0.138973861932755, 0.138933688402176, 0.138893440365791, 0.138853088021278, 0.138812661170959, 0.138772144913673, 0.13873153924942, 0.138690859079361, 0.138650104403496, 0.138609245419502, 0.138568297028542, 0.138527274131775, 0.138486176729202, 0.138444975018501, 0.138403698801994, 0.13836233317852, 0.13832089304924, 0.138279363512993, 0.138237744569778, 0.138196036219597, 0.138154253363609, 0.138112396001816, 0.138070434331894, 0.138028398156166, 0.137986272573471, 0.13794407248497, 0.137901768088341, 0.137859389185905, 0.137816920876503, 0.137774392962456, 0.137731745839119, 0.137689039111137, 0.137646242976189, 0.137601494789124, 0.137554854154587, 0.137508153915405, 0.137461394071579, 0.137414589524269, 0.137367710471153, 0.137320801615715, 0.137273818254471, 0.137226775288582, 0.137179687619209, 0.137132555246353, 0.137085348367691, 0.137038096785545, 0.136990770697594, 0.136943399906158, 0.13689598441124, 0.136848494410515, 0.136800959706306, 0.136753380298615, 0.136705711483955, 0.136658027768135, 0.136610254645348, 0.136562451720238, 0.136514574289322, 0.136466637253761, 0.136418670415878, 0.136370614171028, 0.136322528123856, 0.136274382472038, 0.136226177215576, 0.136177897453308, 0.136129602789879, 0.136081218719482, 0.136032789945602, 0.135984301567078, 0.135935768485069, 0.135887175798416, 0.135838523507118, 0.135789826512337, 0.135741055011749, 0.135692223906517, 0.135643348097801, 0.135594427585602, 0.135545432567596, 0.135496392846107, 0.135447308421135, 0.135398149490356, 0.135348930954933, 0.135299667716026, 0.135250344872475, 0.135200977325439, 0.135151550173759, 0.135102048516273, 0.135052517056465, 0.13500289618969, 0.134953230619431, 0.13490355014801, 0.134853780269623, 0.134803950786591, 0.134754076600075, 0.134704142808914, 0.134654149413109, 0.134604096412659, 0.134553998708725, 0.134503841400146, 0.134453624486923, 0.134403362870216, 0.134353026747704, 0.134302645921707, 0.134252205491066, 0.134201720356941, 0.134151175618172, 0.134100571274757, 0.134049907326698, 0.133999183773994, 0.133948415517807, 0.133897572755814, 0.133846715092659, 0.133795768022537, 0.133744776248932, 0.133693724870682, 0.133642628788948, 0.133591458201408, 0.133540242910385, 0.133488982915878, 0.133437633514404, 0.133386254310608, 0.133334815502167, 0.133283317089081, 0.13323175907135, 0.133180156350136, 0.133128494024277, 0.133076772093773, 0.133024990558624, 0.132973164319992, 0.132921278476715, 0.132869333028793, 0.132817327976227, 0.132765278220177, 0.132713183760643, 0.132660999894142, 0.132608786225319, 0.132556512951851, 0.132504165172577, 0.132451787590981, 0.132399350404739, 0.132346838712692, 0.132294282317162, 0.132241666316986, 0.132189020514488, 0.132136285305023, 0.132083505392075, 0.132030680775642, 0.131977781653404, 0.131924822926521, 0.131871834397316, 0.131818756461143, 0.13176566362381, 0.131712481379509, 0.131659254431725, 0.131605967879295, 0.131552651524544, 0.131499260663986, 0.131445795297623, 0.131392300128937, 0.131338745355606, 0.131285116076469, 0.13123145699501, 0.131177723407745, 0.131123930215836, 0.131070092320442, 0.131016209721565, 0.130962252616882, 0.130908250808716, 0.130854189395905, 0.130800068378448, 0.130745887756348, 0.130691662430763, 0.130637392401695, 0.130583047866821, 0.130528643727303, 0.1304741948843, 0.130419686436653, 0.130365118384361, 0.130310505628586, 0.130255818367004, 0.130201086401939, 0.130146309733391, 0.130091458559036, 0.130036577582359, 0.129981622099876, 0.129926607012749, 0.129871532320976, 0.12981641292572, 0.129761233925819, 0.129706010222435, 0.129650712013245, 0.129595369100571, 0.129539966583252, 0.12948451936245, 0.129428997635841, 0.12937343120575, 0.129317820072174, 0.129262149333954, 0.129206389188766, 0.129150599241257, 0.129094749689102, 0.129038870334625, 0.12898288667202, 0.128926888108253, 0.128870815038681, 0.128814682364464, 0.128758504986763, 0.128702282905579, 0.128645971417427, 0.128589615225792, 0.128533214330673, 0.128476768732071, 0.128420248627663, 0.128363683819771, 0.128307044506073, 0.128250360488892, 0.128193631768227, 0.128136828541756, 0.128079980611801, 0.128023073077202, 0.127966120839119, 0.12790909409523, 0.127852022647858, 0.12779489159584, 0.127737700939178, 0.127680450677872, 0.127623155713081, 0.127565816044807, 0.127508416771889, 0.127450942993164, 0.127393409609795, 0.127335846424103, 0.127278208732605, 0.127220541238785, 0.127162784337997, 0.127104982733727, 0.127047136425972, 0.126989215612411, 0.126931250095367, 0.126873224973679, 0.126815155148506, 0.126757025718689, 0.126698821783066, 0.126640573143959, 0.12658229470253, 0.126523926854134, 0.126465514302254, 0.12640705704689, 0.126348525285721, 0.126289948821068, 0.12623131275177, 0.126172617077827, 0.126113876700401, 0.126055061817169, 0.125996217131615, 0.125937283039093, 0.12587833404541, 0.12581929564476, 0.125760212540627, 0.125701069831848, 0.125641882419586, 0.125582635402679, 0.125523328781128, 0.125463977456093, 0.125404551625252, 0.125345081090927, 0.125285550951958, 0.125225976109505, 0.125166341662407, 0.125106632709503, 0.125046879053116, 0.124987080693245, 0.124927222728729, 0.124867312610149, 0.124807320535183, 0.124747298657894, 0.124687202274799, 0.124627076089382, 0.124566875398159, 0.124506615102291, 0.124446302652359, 0.124385938048363, 0.124325521290302, 0.124265052378178, 0.124204523861408, 0.124143920838833, 0.124083280563354, 0.124022580683231, 0.123961843550205, 0.123901031911373, 0.123840160667896, 0.123779237270355, 0.12371826171875, 0.1236572265625, 0.123596116900444, 0.123534984886646, 0.123473793268204, 0.123412527143955, 0.123351216316223, 0.123289853334427, 0.123228423297405, 0.123166941106319, 0.123105406761169, 0.123043820261955, 0.122982174158096, 0.122920453548431, 0.122858703136444, 0.122796908020973, 0.122735023498535, 0.122673086822033, 0.122611112892628, 0.122549071907997, 0.122486993670464, 0.122424840927124, 0.12236262857914, 0.122300364077091, 0.122238054871559, 0.122175678610802, 0.122113257646561, 0.122050762176514, 0.121988244354725, 0.121925637125969, 0.121862985193729, 0.121800281107426, 0.121737524867058, 0.121674679219723, 0.121611826121807, 0.121548898518085, 0.121485896408558, 0.121422871947289, 0.121359765529633, 0.121296621859074, 0.121233396232128, 0.121170125901699, 0.121106810867786, 0.121043436229229, 0.120980009436607, 0.120916523039341, 0.12085297703743, 0.120789378881454, 0.120725728571415, 0.12066201120615, 0.12059823423624, 0.120534427464008, 0.12047053873539, 0.120406605303288, 0.120342619717121, 0.120278581976891, 0.120214469730854, 0.120150320231915, 0.120086096227169, 0.120021834969521, 0.119957521557808, 0.119893133640289, 0.119828701019287, 0.11976420879364, 0.119699664413929, 0.119635045528412, 0.119570396840572, 0.119505688548088, 0.119440905749798, 0.119376085698605, 0.119311213493347, 0.119246266782284, 0.119181275367737, 0.119116224348545, 0.119051121175289, 0.118985950946808, 0.118920728564262, 0.118855454027653, 0.118790127336979, 0.118724763393402, 0.118659310042858, 0.118593811988831, 0.118528254330158, 0.118462666869164, 0.118396990001202, 0.118331275880337, 0.118265509605408, 0.118199676275253, 0.118133783340454, 0.118067845702171, 0.118001855909824, 0.117935791611671, 0.117869682610035, 0.117803528904915, 0.117737293243408, 0.117671020328999, 0.117604695260525, 0.117538303136826, 0.117471858859062, 0.117405369877815, 0.117338806390762, 0.117272183299065, 0.117205522954464, 0.117138803005219, 0.117072038352489, 0.117005191743374, 0.116938292980194, 0.116871349513531, 0.116804361343384, 0.11673729121685, 0.116670176386833, 0.116603016853333, 0.116535782814026, 0.116468511521816, 0.116401173174381, 0.116333782672882, 0.116266325116158, 0.11619883030653, 0.116131275892258, 0.116063661873341, 0.115995988249779, 0.115928255021572, 0.115860477089882, 0.115792647004128, 0.115724734961987, 0.115656785666943, 0.115588784217834, 0.115520730614662, 0.115452602505684, 0.115384444594383, 0.115316197276115, 0.115247927606106, 0.11517958343029, 0.11511117964983, 0.115042738616467, 0.114974230527878, 0.114905662834644, 0.114837035536766, 0.114768370985985, 0.114699646830559, 0.114630855619907, 0.114562019705772, 0.114493109285831, 0.114424161612988, 0.114355161786079, 0.114286080002785, 0.114216975867748, 0.114147797226906, 0.114078558981419, 0.114009261131287, 0.113939933478832, 0.113870531320572, 0.113801062107086, 0.113731555640697, 0.113661997020245, 0.113592371344566, 0.113522686064243, 0.113452941179276, 0.113383159041405, 0.113313317298889, 0.113243423402309, 0.113173462450504, 0.113103449344635, 0.113033376634121, 0.112963244318962, 0.11289306730032, 0.112822845578194, 0.112752549350262, 0.112682208418846, 0.112611778080463, 0.112541332840919, 0.112470827996731, 0.112400241196156, 0.112329632043839, 0.112258940935135, 0.112188190221786, 0.112117394804955, 0.112046547234058, 0.111975640058517, 0.111904680728912, 0.111833669245243, 0.111762598156929, 0.11169146746397, 0.111620284616947, 0.111549042165279, 0.111477740108967, 0.111406400799751, 0.11133498698473, 0.111263528466225, 0.111191995441914, 0.1111204251647, 0.111048802733421, 0.110977113246918, 0.11090537160635, 0.110833577811718, 0.110761716961861, 0.11068981140852, 0.110617846250534, 0.110545821487904, 0.110473744571209, 0.11040160804987, 0.110329419374466, 0.110257171094418, 0.110184885561466, 0.110112518072128, 0.110040113329887, 0.109967641532421, 0.109895117580891, 0.109822548925877, 0.109749905765057, 0.109677202999592, 0.109604470431805, 0.109531663358212, 0.109458811581135, 0.109385900199413, 0.109312929213047, 0.109239906072617, 0.109166823327541, 0.109093680977821, 0.109020486474037, 0.108947247266769, 0.108873941004276, 0.108800575137138, 0.108727172017097, 0.108653701841831, 0.10858016461134, 0.108506582677364, 0.108432941138744, 0.10835924744606, 0.108285501599312, 0.108211696147919, 0.108137838542461, 0.108063913881779, 0.107989944517612, 0.107915915548801, 0.107841826975346, 0.107767693698406, 0.107693493366241, 0.107619240880013, 0.107544928789139, 0.107470564544201, 0.107396148145199, 0.107321202754974, 0.10724575817585, 0.107170291244984, 0.107094809412956, 0.107019335031509, 0.106943845748901, 0.106868349015713, 0.106792829930782, 0.106717318296432, 0.106641799211502, 0.106566272675991, 0.106490738689899, 0.106415189802647, 0.106339626014233, 0.106264062225819, 0.106188498437405, 0.106112912297249, 0.106037326157093, 0.105961725115776, 0.10588613152504, 0.105810515582561, 0.105734907090664, 0.105659268796444, 0.105583630502224, 0.105507992208004, 0.105432339012623, 0.10535667091608, 0.105281002819538, 0.105205327272415, 0.105129644274712, 0.105053953826427, 0.104978248476982, 0.104902543127537, 0.10482682287693, 0.104751095175743, 0.104675360023975, 0.104599624872208, 0.104523867368698, 0.104448102414608, 0.104372344911098, 0.104296572506428, 0.104220792651176, 0.104145005345345, 0.104069195687771, 0.103993393480778, 0.103917576372623, 0.103841744363308, 0.103765927255154, 0.103690087795258, 0.1036142334342, 0.103538371622562, 0.103462517261505, 0.103386647999287, 0.103310763835907, 0.103234887123108, 0.103158973157406, 0.103083081543446, 0.103007160127163, 0.1029312312603, 0.102855302393436, 0.102779366075993, 0.102703429758549, 0.102627471089363, 0.102551504969597, 0.102475553750992, 0.102399565279484, 0.102323584258556, 0.102247588336468, 0.102171577513218, 0.102095574140549, 0.102019555866718, 0.101943530142307, 0.101867489516735, 0.101791441440582, 0.10171540081501, 0.101639337837696, 0.101563274860382, 0.101487196981907, 0.101411111652851, 0.101335018873215, 0.101258911192417, 0.101182818412781, 0.101106703281403, 0.101030573248863, 0.100954443216324, 0.100878290832043, 0.100802160799503, 0.100726000964642, 0.100649833679199, 0.100573666393757, 0.100497476756573, 0.100421287119389, 0.100345090031624, 0.100268870592117, 0.100192673504353, 0.100116446614265, 0.100040219724178, 0.09996397793293, 0.0998877286911011, 0.0998114868998528, 0.099735215306282, 0.0996589511632919, 0.0995826721191406, 0.0995063781738281, 0.0994300842285156, 0.0993537753820419, 0.0992774814367294, 0.0992011576890945, 0.0991248264908791, 0.099048487842083, 0.0989721417427063, 0.0988957956433296, 0.0988194271922112, 0.0987430661916733, 0.0986666902899742, 0.0985903069376945, 0.0985139161348343, 0.0984375029802322, 0.0983611047267914, 0.0982846915721893, 0.0982082635164261, 0.0981318354606628, 0.0980553850531578, 0.0979789271950722, 0.0979024767875671, 0.0978260114789009, 0.0977495387196541, 0.0976730585098267, 0.0975965708494186, 0.0975200682878494, 0.097443550825119, 0.0973670482635498, 0.0972905233502388, 0.0972139909863472, 0.097137451171875, 0.0970609039068222, 0.0969843566417694, 0.0969077795743942, 0.0968312099575996, 0.0967546328902245, 0.0966780483722687, 0.0966014489531517, 0.0965248495340347, 0.0964482352137566, 0.0963716134428978, 0.0962949842214584, 0.0962183475494385, 0.0961417034268379, 0.0960650518536568, 0.095988392829895, 0.0959117189049721, 0.0958350449800491, 0.095758356153965, 0.0956816673278809, 0.0956049636006355, 0.0955282524228096, 0.0954515337944031, 0.0953748002648354, 0.0952980667352676, 0.0952213332056999, 0.095144584774971, 0.0950678288936615, 0.0949910506606102, 0.0949142724275589, 0.0948374941945076, 0.0947606936097145, 0.0946839079260826, 0.0946070998907089, 0.0945302844047546, 0.0944534614682198, 0.0943766310811043, 0.0942997932434082, 0.0942229405045509, 0.0941460877656937, 0.0940692201256752, 0.0939923375844955, 0.0939154699444771, 0.0938385725021362, 0.0937616750597954, 0.0936847776174545, 0.0936078652739525, 0.0935309454798698, 0.093454010784626, 0.0933770760893822, 0.0933001264929771, 0.0932231768965721, 0.0931462123990059, 0.0930692404508591, 0.0929922610521317, 0.0929152816534042, 0.092838279902935, 0.0927612856030464, 0.0926842764019966, 0.092607244849205, 0.092530220746994, 0.0924531817436218, 0.0923761427402496, 0.0922990888357162, 0.0922220274806023, 0.0921449735760689, 0.0920678898692131, 0.0919908061623573, 0.0919137075543404, 0.0918366089463234, 0.0917595028877258, 0.0916823893785477, 0.0916052684187889, 0.091528132557869, 0.0914509892463684, 0.0913738384842873, 0.0912966802716255, 0.0912195220589638, 0.0911423489451408, 0.0910651609301567, 0.0909879803657532, 0.0909107774496078, 0.0908335745334625, 0.090756356716156, 0.0906791314482689, 0.0906019061803818, 0.0905246660113335, 0.0904474183917046, 0.0903701633214951, 0.0902928933501244, 0.0902156308293343, 0.090138353407383, 0.0900610685348511, 0.089983768761158, 0.0899064615368843, 0.08982914686203, 0.0897518247365952, 0.0896745100617409, 0.0895971730351448, 0.0895198211073875, 0.0894424766302109, 0.0893651023507118, 0.089287742972374, 0.0892103612422943, 0.0891329720616341, 0.0890555903315544, 0.088978186249733, 0.0889007747173309, 0.0888233557343483, 0.0887459293007851, 0.0886685028672218, 0.0885910615324974, 0.0885136127471924, 0.0884361490607262, 0.0883586853742599, 0.0882812142372131, 0.0882037281990051, 0.0881262421607971, 0.0880487412214279, 0.0879712253808975, 0.0878937244415283, 0.0878161862492561, 0.0877386555075645, 0.0876611098647118, 0.0875835716724396, 0.0875060260295868, 0.0874284505844116, 0.087350882589817, 0.0872732996940613, 0.0871957018971443, 0.0871181264519691, 0.087040513753891, 0.0869629010558128, 0.0868852809071541, 0.0868076384067535, 0.0867300182580948, 0.0866523683071136, 0.0865747258067131, 0.0864970535039902, 0.0864193812012672, 0.0863417088985443, 0.0862640142440796, 0.0861863270401955, 0.0861086249351501, 0.0860309079289436, 0.0859531983733177, 0.08587546646595, 0.0857977345585823, 0.085719995200634, 0.0856422334909439, 0.0855644792318344, 0.0854867175221443, 0.0854089334607124, 0.0853311493992805, 0.0852533504366875, 0.085175558924675, 0.0850977525115013, 0.085019938647747, 0.0849421173334122, 0.0848642885684967, 0.08478644490242, 0.0847085937857628, 0.0846307352185249, 0.0845528692007065, 0.0844749882817268, 0.0843971148133278, 0.0843192264437675, 0.0842413306236267, 0.0841634273529053, 0.0840855091810226, 0.08400759100914, 0.0839296653866768, 0.0838517174124718, 0.0837737768888474, 0.0836958214640617, 0.0836178585886955, 0.0835398882627487, 0.0834619104862213, 0.0833839252591133, 0.0833059251308441, 0.0832279250025749, 0.0831499099731445, 0.0830719023942947, 0.0829938724637032, 0.082915835082531, 0.0828377902507782, 0.0827597305178642, 0.0826816782355309, 0.0826036036014557, 0.0825255289673805, 0.0824474468827248, 0.0823693573474884, 0.0822912529110909, 0.0822131410241127, 0.082135021686554, 0.0820569023489952, 0.0819787755608559, 0.0819006413221359, 0.0818224847316742, 0.0817443206906319, 0.0816661641001701, 0.081587977707386, 0.0815098062157631, 0.0814316123723984, 0.0813534110784531, 0.0812752023339272, 0.0811969861388206, 0.0811187699437141, 0.0810405313968658, 0.0809622928500175, 0.0808840617537498, 0.0808057934045792, 0.0807275325059891, 0.0806492567062378, 0.0805709809064865, 0.0804927051067352, 0.0804143995046616, 0.0803360939025879, 0.0802577808499336, 0.0801794528961182, 0.0801011323928833, 0.0800227895379066, 0.0799444615840912, 0.0798661038279533, 0.0797877311706543, 0.0797093734145164, 0.0796309858560562, 0.0795526131987572, 0.0794742181897163, 0.0793958157300949, 0.0793173983693123, 0.0792389884591103, 0.079160563647747, 0.0790821239352226, 0.0790036767721176, 0.0789252296090126, 0.0788467600941658, 0.0787683129310608, 0.0786898285150528, 0.0786113440990448, 0.0785328596830368, 0.078454352915287, 0.0783758610486984, 0.0782973393797874, 0.0782188102602959, 0.0781402811408043, 0.0780617371201515, 0.0779831930994987, 0.0779046341776848, 0.0778260752558708, 0.0777474939823151, 0.0776689127087593, 0.0775903314352036, 0.0775117352604866, 0.0774331241846085, 0.0773545131087303, 0.0772758945822716, 0.0771972686052322, 0.0771186277270317, 0.07703997194767, 0.0769613310694695, 0.0768826603889465, 0.0768039971590042, 0.0767253190279007, 0.0766466334462166, 0.0765679404139519, 0.0764892250299454, 0.0764105245471001, 0.0763318091630936, 0.0762530788779259, 0.0761743411421776, 0.0760955959558487, 0.0760168507695198, 0.0759380832314491, 0.0758593156933784, 0.0757805481553078, 0.0757017582654953, 0.0756229683756828, 0.0755441710352898, 0.0754653662443161, 0.0753865391016006, 0.0753077119588852, 0.0752288997173309, 0.0751500502228737, 0.0750712007284164, 0.0749923512339592, 0.0749134719371796, 0.0748346000909805, 0.0747557207942009, 0.0746768191456795, 0.0745979323983192, 0.0745190158486366, 0.0744401142001152, 0.074361190199852, 0.0742822587490082, 0.0742033272981644, 0.0741243660449982, 0.0740454345941544, 0.0739664658904076, 0.0738874822854996, 0.0738085135817528, 0.0737295150756836, 0.0736505314707756, 0.0735715180635452, 0.0734925046563148, 0.0734134986996651, 0.0733344629406929, 0.0732554271817207, 0.0731763914227486, 0.073097325861454, 0.0730182677507401, 0.0729392021894455, 0.0728601291775703, 0.0727810338139534, 0.0727019459009171, 0.0726228505373001, 0.0725437328219414, 0.0724646225571632, 0.0723855048418045, 0.072306364774704, 0.0722272247076035, 0.0721480697393417, 0.07206891477108, 0.0719897523522377, 0.071910560131073, 0.0718313902616501, 0.0717521980404854, 0.0716730058193207, 0.0715937912464142, 0.0715145766735077, 0.0714353621006012, 0.0713561326265335, 0.071276880800724, 0.0711976364254951, 0.0711183696985245, 0.0710391104221344, 0.0709598362445831, 0.0708805620670319, 0.0708012729883194, 0.0707219764590263, 0.0706426799297333, 0.0705633535981178, 0.070484034717083, 0.0704047158360481, 0.0703253746032715, 0.0702460333704948, 0.070166677236557, 0.0700873211026192, 0.0700079575181007, 0.0699285715818405, 0.0698491930961609, 0.0697697922587395, 0.0696903914213181, 0.0696109756827354, 0.0695315599441528, 0.0694521367549896, 0.0693726912140846, 0.0692932605743408, 0.0692138075828552, 0.069134347140789, 0.0690548717975616, 0.0689753964543343, 0.0688959211111069, 0.0688164234161377, 0.0687369257211685, 0.0686574205756187, 0.0685792863368988, 0.0685026124119759, 0.0684259757399559, 0.0683493614196777, 0.0682727843523026, 0.0681962370872498, 0.0681197345256805, 0.0680432394146919, 0.0679667964577675, 0.0678903758525848, 0.0678139850497246, 0.0677376389503479, 0.067661315202713, 0.0675850212574005, 0.0675087720155716, 0.0674325451254845, 0.0673563629388809, 0.0672801956534386, 0.0672040730714798, 0.0671279653906822, 0.0670519098639488, 0.0669758915901184, 0.0668998807668686, 0.0668239146471024, 0.0667479708790779, 0.0666720643639565, 0.066596195101738, 0.0665203705430031, 0.0664445534348488, 0.0663687810301781, 0.0662930458784103, 0.0662173479795456, 0.066141664981842, 0.0660660117864609, 0.0659904032945633, 0.0659148246049881, 0.0658392906188965, 0.0657637566328049, 0.0656882598996162, 0.065612830221653, 0.0655374005436897, 0.0654620155692101, 0.0653866529464722, 0.0653113275766373, 0.0652360469102859, 0.0651607811450958, 0.0650855600833893, 0.0650103613734245, 0.0649351924657822, 0.064860075712204, 0.0647849813103676, 0.064709909260273, 0.0646348670125008, 0.0645598620176315, 0.0644849017262459, 0.064409963786602, 0.0643350630998611, 0.0642601847648621, 0.0641853362321854, 0.0641105324029922, 0.0640357434749603, 0.0639610216021538, 0.0638862997293472, 0.0638116300106049, 0.0637369751930237, 0.0636623576283455, 0.0635877624154091, 0.0635132119059563, 0.0634386911988258, 0.063364215195179, 0.0632897615432739, 0.0632153302431107, 0.063140943646431, 0.0630665868520737, 0.0629922673106194, 0.0629179701209068, 0.0628437101840973, 0.0627694725990295, 0.0626952722668648, 0.062621109187603, 0.0625469833612442, 0.0624728798866272, 0.0623988024890423, 0.0623247697949409, 0.062250766903162, 0.0621767938137054, 0.0621028691530228, 0.0620289519429207, 0.0619550719857216, 0.0618812330067158, 0.0618074201047421, 0.0617336444556713, 0.0616598911583424, 0.0615861602127552, 0.0615124925971031, 0.0614388398826122, 0.0613652281463146, 0.0612916313111782, 0.0612180791795254, 0.0611445605754852, 0.0610710680484772, 0.0609976202249527, 0.0609241873025894, 0.0608507804572582, 0.0607774406671524, 0.0607041046023369, 0.060630802065134, 0.0605575293302536, 0.0604842975735664, 0.060411099344492, 0.0603379383683205, 0.0602648034691811, 0.0601916909217834, 0.0601186230778694, 0.0600455775856972, 0.0599725730717182, 0.0598996058106422, 0.0598266646265984, 0.0597537495195866, 0.0596808753907681, 0.0596080310642719, 0.0595351941883564, 0.0594624169170856, 0.0593896619975567, 0.0593169592320919, 0.0592442601919174, 0.0591716207563877, 0.0590989924967289, 0.0590263977646828, 0.0589538551867008, 0.0588813275098801, 0.0588088408112526, 0.058736365288496, 0.0586639381945133, 0.0585915520787239, 0.058519184589386, 0.058446854352951, 0.0583745464682579, 0.058302279561758, 0.0582300424575806, 0.0581578351557255, 0.0580856800079346, 0.0580135323107243, 0.0579414218664169, 0.0578693598508835, 0.0577973127365112, 0.057725302875042, 0.0576533228158951, 0.05758136510849, 0.0575094521045685, 0.05743757635355, 0.0573657341301441, 0.0572939105331898, 0.0572221204638481, 0.0571503713726997, 0.0570786483585835, 0.057006973773241, 0.0569353103637695, 0.0568636804819107, 0.0567920915782452, 0.0567205362021923, 0.0566490069031715, 0.0565775036811829, 0.0565060414373875, 0.0564346052706242, 0.0563632138073444, 0.0562918446958065, 0.0562205091118813, 0.0561492033302784, 0.0560779422521591, 0.056006696075201, 0.0559354946017265, 0.0558643229305744, 0.0557931736111641, 0.0557220689952374, 0.055650994181633, 0.0555799417197704, 0.0555089265108109, 0.0554379411041737, 0.0553669892251492, 0.0552960783243179, 0.05522520840168, 0.0551543459296227, 0.055083516985178, 0.0550127476453781, 0.0549419820308685, 0.0548712573945522, 0.0548005700111389, 0.0547299049794674, 0.0546592734754086, 0.0545886754989624, 0.0545181222259998, 0.0544475987553596, 0.0543770864605904, 0.054306622594595, 0.0542361959815025, 0.0541657879948616, 0.054095420986414, 0.0540250726044178, 0.0539547689259052, 0.0538845062255859, 0.0538142658770084, 0.0537440553307533, 0.0536738820374012, 0.0536037273705006, 0.0535336248576641, 0.0534635409712791, 0.0533934868872166, 0.0533234663307667, 0.0532534793019295, 0.0531835407018661, 0.0531136207282543, 0.0530437342822552, 0.0529738701879978, 0.052904050797224, 0.0528342761099339, 0.0527645163238049, 0.0526947751641273, 0.0526250712573528, 0.0525554046034813, 0.0524857901036739, 0.0524161830544472, 0.052346620708704, 0.0522770844399929, 0.0522075816988945, 0.0521381162106991, 0.0520686842501163, 0.0519992709159851, 0.051929909735918, 0.0518605634570122, 0.0517912469804287, 0.0517219789326191, 0.0516527257859707, 0.0515835136175156, 0.0515143387019634, 0.051445197314024, 0.0513760894536972, 0.051306989043951, 0.051237940788269, 0.0511689223349094, 0.0510999523103237, 0.0510309934616089, 0.050962071865797, 0.0508931688964367, 0.0508243031799793, 0.0507554896175861, 0.0506866909563541, 0.0506179369986057, 0.0505492016673088, 0.0504805035889149, 0.0504118464887142, 0.0503432117402554, 0.0502746030688286, 0.0502060279250145, 0.0501374900341034, 0.0500690005719662, 0.0500005297362804, 0.0499320924282074, 0.0498636774718761, 0.0497952997684479, 0.0497269593179226, 0.0496586486697197, 0.0495903603732586, 0.0495221205055714, 0.049453891813755, 0.0493857227265835, 0.0493175759911537, 0.0492494590580463, 0.0491813570261002, 0.0491133183240891, 0.04904530569911, 0.0489773154258728, 0.0489093400537968, 0.0488414131104946, 0.0487735122442245, 0.0487056598067284, 0.048637829720974, 0.0485700331628323, 0.0485022589564323, 0.048434529453516, 0.0483668558299541, 0.048299178481102, 0.0482315421104431, 0.0481639318168163, 0.0480963625013828, 0.0480288118124008, 0.047961313277483, 0.0478938333690166, 0.047826386988163, 0.047758974134922, 0.0476916059851646, 0.047624260187149, 0.0475569441914558, 0.047489657998085, 0.0474224090576172, 0.0473552010953426, 0.0472880154848099, 0.0472208596765995, 0.0471537299454212, 0.0470866449177265, 0.0470195859670639, 0.0469525679945946, 0.0468855686485767, 0.0468186028301716, 0.0467516779899597, 0.0466848015785217, 0.0466179326176643, 0.0465510971844196, 0.0464842915534973, 0.0464175269007683, 0.0463507995009422, 0.046284094452858, 0.0462174229323864, 0.0461507737636566, 0.0460841730237007, 0.0460175909101963, 0.0459510460495949, 0.0458845421671867, 0.0458180531859398, 0.045751616358757, 0.0456852167844772, 0.0456188358366489, 0.045552484691143, 0.0454861633479595, 0.0454198606312275, 0.0453536249697208, 0.0452874079346657, 0.0452212169766426, 0.0451550520956516, 0.0450889207422733, 0.0450228303670883, 0.044956773519516, 0.0448907464742661, 0.0448247529566288, 0.0447587929666042, 0.0446928702294827, 0.0446269698441029, 0.0445610955357552, 0.0444952584803104, 0.0444294549524784, 0.0443636849522591, 0.0442979410290718, 0.0442322418093681, 0.044166561216116, 0.0441009178757668, 0.0440353192389011, 0.0439697504043579, 0.0439041964709759, 0.0438386797904968, 0.0437732078135014, 0.0437077656388283, 0.0436423383653164, 0.0435769557952881, 0.0435115993022919, 0.0434462800621986, 0.0433809868991375, 0.0433157347142696, 0.0432505086064339, 0.0431853048503399, 0.0431201569736004, 0.0430550575256348, 0.0429899618029594, 0.0429248698055744, 0.0428598411381245, 0.0427948348224163, 0.0427298843860626, 0.0426649451255798, 0.0426000468432903, 0.0425351671874523, 0.0424703247845173, 0.0424055345356464, 0.0423407629132271, 0.0422760285437107, 0.0422113165259361, 0.0421466305851936, 0.0420820079743862, 0.0420173779129982, 0.0419527962803841, 0.041888240724802, 0.0418237298727036, 0.041759267449379, 0.0416948013007641, 0.0416303873062134, 0.0415659919381142, 0.0415016338229179, 0.0414373241364956, 0.0413730405271053, 0.0413087755441666, 0.0412445515394211, 0.0411803498864174, 0.041116189211607, 0.0410520546138287, 0.0409879498183727, 0.0409238785505295, 0.0408598370850086, 0.0407958589494228, 0.0407318845391273, 0.0406679399311543, 0.0406040400266647, 0.040540162473917, 0.0404763370752335, 0.0404125340282917, 0.0403487458825111, 0.0402849987149239, 0.0402212850749493, 0.0401576161384583, 0.040093969553709, 0.0400303527712822, 0.0399667583405972, 0.0399032160639763, 0.0398397110402584, 0.039776224642992, 0.0397127643227577, 0.0396493412554264, 0.0395859517157078, 0.0395226068794727, 0.0394592806696892, 0.0393959619104862, 0.0393326841294765, 0.0392694622278214, 0.0392062738537788, 0.0391431115567684, 0.0390799716114998, 0.0390168726444244, 0.0389537960290909, 0.0388907790184021, 0.0388277694582939, 0.0387647971510887, 0.0387018583714962, 0.0386389456689358, 0.0385760851204395, 0.0385132394731045, 0.0384504124522209, 0.0383876375854015, 0.0383249036967754, 0.0382621884346008, 0.0381995067000389, 0.0381368547677994, 0.0380742400884628, 0.0380116552114487, 0.0379491113126278, 0.0378865860402584, 0.0378240831196308, 0.0377616249024868, 0.0376992039382458, 0.0376367978751659, 0.0375744365155697, 0.0375120975077152, 0.0374498106539249, 0.0373875349760056, 0.0373253338038921, 0.0372631289064884, 0.0372009538114071, 0.0371388159692287, 0.0370767116546631, 0.037014652043581, 0.0369526036083698, 0.0368905961513519, 0.0368286222219467, 0.0367666706442833, 0.0367047712206841, 0.0366429015994072, 0.0365810543298721, 0.0365192219614983, 0.0364574380218983, 0.0363957211375237, 0.0363339968025684, 0.0362723134458065, 0.0362106524407864, 0.0361490286886692, 0.036087442189455, 0.0360258966684341, 0.0359643585979939, 0.0359028540551662, 0.035841379314661, 0.0357799716293812, 0.0357185676693916, 0.0356572084128857, 0.0355958752334118, 0.0355345755815506, 0.035473320633173, 0.0354120843112469, 0.0353508740663528, 0.0352897085249424, 0.0352285616099834, 0.035167470574379, 0.0351063869893551, 0.0350453406572342, 0.034984327852726, 0.0349233523011208, 0.0348624363541603, 0.034801509231329, 0.0347406268119812, 0.0346797779202461, 0.0346189551055431, 0.0345581844449043, 0.0344974286854267, 0.0344367027282715, 0.0343760140240192, 0.0343153551220894, 0.0342562980949879, 0.0341988913714886, 0.0341415330767632, 0.0340842455625534, 0.0340269953012466, 0.0339698195457458, 0.0339126624166965, 0.033855564892292, 0.0337985083460808, 0.033741507679224, 0.0336845628917217, 0.0336276367306709, 0.033570796251297, 0.0335139743983746, 0.0334572196006775, 0.033400509506464, 0.0333438627421856, 0.033287238329649, 0.0332306548953056, 0.0331741496920586, 0.0331176705658436, 0.0330612622201443, 0.0330048874020576, 0.0329485610127449, 0.0328922756016254, 0.0328360721468925, 0.0327798873186111, 0.032723743468523, 0.0326676443219185, 0.0326116159558296, 0.0325556434690952, 0.0324997082352638, 0.0324438214302063, 0.0323879718780518, 0.0323321744799614, 0.0322764441370964, 0.0322207361459732, 0.0321651101112366, 0.0321094952523708, 0.0320539623498917, 0.0319984629750252, 0.0319430194795132, 0.0318876095116138, 0.0318322479724884, 0.0317769423127174, 0.0317216813564301, 0.0316664911806583, 0.0316113047301769, 0.0315562039613724, 0.0315011367201805, 0.0314461477100849, 0.0313911661505699, 0.0313362441956997, 0.0312813781201839, 0.0312265548855066, 0.0311717800796032, 0.0311170518398285, 0.0310623608529568, 0.0310077350586653, 0.0309531725943089, 0.0308986380696297, 0.0308441482484341, 0.0307897161692381, 0.0307353194802999, 0.0306810010224581, 0.030626717954874, 0.0305724926292896, 0.0305182859301567, 0.0304641295224428, 0.0304100438952446, 0.0303560104221106, 0.0303020067512989, 0.0302480570971966, 0.0301941707730293, 0.0301402974873781, 0.0300865303725004, 0.0300327632576227, 0.029979046434164, 0.0299253892153502, 0.0298717748373747, 0.0298182219266891, 0.0297647099941969, 0.029711252078414, 0.0296578351408243, 0.0296044368296862, 0.0295511335134506, 0.0294978488236666, 0.0294446460902691, 0.0293914657086134, 0.0293383505195379, 0.0292852688580751, 0.029232257977128, 0.0291792713105679, 0.0291263405233622, 0.02907345443964, 0.0290206260979176, 0.0289678443223238, 0.0289151053875685, 0.0288624186068773, 0.028809767216444, 0.0287572015076876, 0.0287046488374472, 0.0286521445959806, 0.0285997167229652, 0.0285473093390465, 0.0284949708729982, 0.0284426640719175, 0.0283904261887074, 0.0283382143825293, 0.0282860640436411, 0.0282339565455914, 0.0281818732619286, 0.0281298756599426, 0.0280779153108597, 0.0280260052531958, 0.0279741380363703, 0.0279223397374153, 0.0278705507516861, 0.0278188455849886, 0.0277671776711941, 0.0277155600488186, 0.0276639945805073, 0.0276124551892281, 0.0275609903037548, 0.0275095533579588, 0.0274581927806139, 0.0274068601429462, 0.027355570346117, 0.0273043382912874, 0.0272531434893608, 0.0272020250558853, 0.0271509326994419, 0.0270998980849981, 0.0270489007234573, 0.0269979611039162, 0.0269470848143101, 0.0268962234258652, 0.0268454328179359, 0.0267946664243937, 0.0267439596354961, 0.0266933050006628, 0.0266427211463451, 0.0265921521931887, 0.0265416633337736, 0.0264911893755198, 0.0264407936483622, 0.0263904500752687, 0.0263401232659817, 0.0262898616492748, 0.0262396298348904, 0.0261894930154085, 0.0261393636465073, 0.0260892864316702, 0.0260392688214779, 0.0259892847388983, 0.0259393863379955, 0.0258894991129637, 0.0258396789431572, 0.0257899034768343, 0.0257401689887047, 0.0256904866546392, 0.0256408397108316, 0.0255912709981203, 0.0255417339503765, 0.025492250919342, 0.0254427921026945, 0.0253934096544981, 0.0253440551459789, 0.025294778868556, 0.0252455268055201, 0.0251963343471289, 0.025147195905447, 0.0250980816781521, 0.0250490363687277, 0.025000024586916, 0.0249510910362005, 0.0249021742492914, 0.024853328242898, 0.0248045139014721, 0.0247557517141104, 0.0247070416808128, 0.0246583744883537, 0.0246097594499588, 0.0245611984282732, 0.0245126839727163, 0.0244642160832882, 0.0244157798588276, 0.0243674218654633, 0.0243190918117762, 0.0242708213627338, 0.02422259375453, 0.0241744350641966, 0.024126285687089, 0.0240782182663679, 0.0240301620215178, 0.0239821765571833, 0.0239342488348484, 0.0238863565027714, 0.0238385237753391, 0.023790717124939, 0.0237429961562157, 0.0236952938139439, 0.0236476678401232, 0.023600060492754, 0.0235524941235781, 0.023505013436079, 0.023457570001483, 0.0234101563692093, 0.0233628079295158, 0.0233155004680157, 0.0232682432979345, 0.0232210233807564, 0.0231738872826099, 0.0231267604976892, 0.0230797100812197, 0.0230326931923628, 0.0229857303202152, 0.0229388102889061, 0.0228919591754675, 0.0228451173752546, 0.0227983258664608, 0.0227516125887632, 0.0227049309760332, 0.0226583052426577, 0.022611727938056, 0.0225652195513248, 0.0225187223404646, 0.0224722903221846, 0.0224259030073881, 0.0223795678466558, 0.0223332941532135, 0.0222870428115129, 0.0222408641129732, 0.022194717079401, 0.0221486315131187, 0.0221025887876749, 0.0220565982162952, 0.0220106393098831, 0.0219647269695997, 0.021918898448348, 0.0218730866909027, 0.021827345713973, 0.0217816308140755, 0.0217359811067581, 0.0216903686523438, 0.0216448102146387, 0.0215992983430624, 0.0215538237243891, 0.0215084254741669, 0.0214630551636219, 0.0214177425950766, 0.0213724561035633, 0.0213272478431463, 0.0212820563465357, 0.0212369430810213, 0.0211918819695711, 0.0211468450725079, 0.0211018677800894, 0.0210569351911545, 0.0210120622068644, 0.0209672320634127, 0.0209224540740252, 0.0208777096122503, 0.0208330191671848, 0.020788386464119, 0.0207437966018915, 0.0206992588937283, 0.0206547565758228, 0.0206103231757879, 0.02056591399014, 0.0205215737223625, 0.0204772874712944, 0.0204330328851938, 0.0203888304531574, 0.0203446820378304, 0.0203005652874708, 0.0202564913779497, 0.0202125050127506, 0.0201685279607773, 0.0201246105134487, 0.0200807675719261, 0.0200369544327259, 0.019993182271719, 0.0199494622647762, 0.0199057925492525, 0.019862174987793, 0.0198186188936234, 0.0197750795632601, 0.0197316091507673, 0.0196881890296936, 0.0196448061615229, 0.0196014828979969, 0.0195581912994385, 0.0195149779319763, 0.0194717738777399, 0.0194286573678255, 0.019385565072298, 0.019342515617609, 0.0192995276302099, 0.0192565973848104, 0.0192137118428946, 0.0191708710044622, 0.0191280692815781, 0.0190853141248226, 0.019042607396841, 0.0189999639987946, 0.0189573634415865, 0.0189148038625717, 0.0188722964376211, 0.0188298411667347, 0.018787445500493, 0.0187450926750898, 0.0187027733772993, 0.0186604913324118, 0.0186182856559753, 0.0185761302709579, 0.0185340270400047, 0.0184919349849224, 0.0184499360620975, 0.0184079427272081, 0.0183660462498665, 0.0183241590857506, 0.0182823333889246, 0.0182405561208725, 0.018198823556304, 0.0181571505963802, 0.0181155204772949, 0.0180739350616932, 0.0180323980748653, 0.017990916967392, 0.0179494749754667, 0.0179080609232187, 0.0178667418658733, 0.0178254395723343, 0.01778419688344, 0.0177430063486099, 0.0177018567919731, 0.0176607519388199, 0.0176196992397308, 0.0175787061452866, 0.017537746578455, 0.0174968577921391, 0.0174559857696295, 0.0174151975661516, 0.0173744205385447, 0.0173337385058403, 0.0172930620610714, 0.0172524396330118, 0.0172118786722422, 0.0171713568270206, 0.0171309057623148, 0.0170904714614153, 0.0170501079410315, 0.0170097853988409, 0.0169695150107145, 0.0169292874634266, 0.0168891027569771, 0.0168489869683981, 0.0168088991194963, 0.0167688690125942, 0.0167288742959499, 0.0166889559477568, 0.0166490562260151, 0.0166091974824667, 0.0165694262832403, 0.016529681161046, 0.0164900049567223, 0.0164503436535597, 0.0164107624441385, 0.0163711979985237, 0.0163317359983921, 0.0162922646850348, 0.0162528548389673, 0.0162135064601898, 0.0161741990596056, 0.0161349605768919, 0.0160957481712103, 0.0160565879195929, 0.0160174705088139, 0.0159784127026796, 0.0159394070506096, 0.0159004367887974, 0.0158615261316299, 0.0158226396888494, 0.0157838314771652, 0.0157450661063194, 0.0157063361257315, 0.0156676564365625, 0.0156290233135223, 0.0155904470011592, 0.0155519219115376, 0.0155134424567223, 0.0154750123620033, 0.0154366325587034, 0.0153982900083065, 0.0153600266203284, 0.0153217762708664, 0.0152835799381137, 0.0152454422786832, 0.0152073493227363, 0.0151693150401115, 0.0151313142850995, 0.0150933777913451, 0.0150554729625583, 0.015017619356513, 0.0149798262864351, 0.0149420686066151, 0.0149043696001172, 0.0148666985332966, 0.0148291038349271, 0.014791551977396, 0.0147540429607034, 0.0147165758535266, 0.0146791711449623, 0.0146417990326881, 0.014604464173317, 0.0145672122016549, 0.0145299704745412, 0.0144928153604269, 0.0144556928426027, 0.0144186299294233, 0.0143815949559212, 0.0143446121364832, 0.0143076796084642, 0.0142708066850901, 0.0142339877784252, 0.0141971912235022, 0.0141604570671916, 0.0141237741336226, 0.0140871424227953, 0.0140505619347095, 0.0140140010043979, 0.0139775238931179, 0.0139410644769669, 0.0139046823605895, 0.0138683440163732, 0.0138320568948984, 0.0137957874685526, 0.0137595944106579, 0.0137234358116984, 0.0136873302981257, 0.013651292771101, 0.0136152552440763, 0.0135793024674058, 0.01354337669909, 0.0135075366124511, 0.0134717142209411, 0.0134359514340758, 0.013400231488049, 0.0133645655587316, 0.0133289564400911, 0.0132933752611279, 0.0132578620687127, 0.0132223926484585, 0.0131869651377201, 0.0131515981629491, 0.0131162498146296, 0.0130809852853417, 0.0130457393825054, 0.0130105698481202, 0.0129754357039928, 0.0129403527826071, 0.0129053052514791, 0.0128703340888023, 0.0128353890031576, 0.0128004960715771, 0.0127656618133187, 0.0127308461815119, 0.0126961162313819, 0.0126614030450583, 0.0126267671585083, 0.0125921498984098, 0.0125575913116336, 0.0125230941921473, 0.0124886389821768, 0.0124542359262705, 0.0124198757112026, 0.0123855667188764, 0.0123512931168079, 0.0123170958831906, 0.0122829349711537, 0.012248806655407, 0.0122147472575307, 0.0121807139366865, 0.0121467588469386, 0.0121128456667066, 0.0120789753273129, 0.012045131996274, 0.0120113734155893, 0.011977625079453, 0.0119439605623484, 0.0119103314355016, 0.0118767460808158, 0.0118432203307748, 0.0118097215890884, 0.0117763066664338, 0.0117429010570049, 0.011709556914866, 0.0116762546822429, 0.0116430046036839, 0.0116111468523741, 0.0115804439410567, 0.0115497997030616, 0.0115191917866468, 0.0114886164665222, 0.0114581016823649, 0.0114276213571429, 0.0113971922546625, 0.0113667631521821, 0.0113364299759269, 0.0113061126321554, 0.0112758567556739, 0.0112456260249019, 0.0112154297530651, 0.01118528470397, 0.011155191808939, 0.0111251333728433, 0.011095117777586, 0.0110651282593608, 0.0110351983457804, 0.0110053373500705, 0.0109754763543606, 0.0109456749632955, 0.0109158838167787, 0.0108861615881324, 0.0108564980328083, 0.0108268605545163, 0.0107972826808691, 0.010767706669867, 0.0107382163405418, 0.010708742775023, 0.01067931111902, 0.0106499399989843, 0.0106205884367228, 0.0105912946164608, 0.0105620361864567, 0.0105328382924199, 0.0105036562308669, 0.0104745179414749, 0.0104454234242439, 0.0104163875803351, 0.0103873964399099, 0.0103584043681622, 0.0103294998407364, 0.0103006269782782, 0.0102718072012067, 0.0102430135011673, 0.0102142533287406, 0.0101855453103781, 0.0101568633690476, 0.0101282754912972, 0.0100996801629663, 0.0100711351260543, 0.0100426422432065, 0.0100141922011971, 0.00998579524457455, 0.00995743088424206, 0.00992907490581274, 0.00990078877657652, 0.0098725538700819, 0.00984435342252254, 0.00981621351093054, 0.0097880819812417, 0.00976001936942339, 0.00973197259008884, 0.0097039882093668, 0.00967605412006378, 0.00964812003076077, 0.00962027162313461, 0.00959244184195995, 0.00956469774246216, 0.00953693594783545, 0.0095092598348856, 0.00948160048574209, 0.00945396907627583, 0.0094264317303896, 0.00939888413995504, 0.00937141571193933, 0.00934396311640739, 0.00931658037006855, 0.00928923115134239, 0.0092619089409709, 0.00923463795334101, 0.00920739956200123, 0.00918022356927395, 0.00915308110415936, 0.00912597309798002, 0.00909889955073595, 0.00907190330326557, 0.00904492475092411, 0.00901799742132425, 0.00899109710007906, 0.00896423775702715, 0.00893744826316833, 0.00891067646443844, 0.00888397265225649, 0.00885726884007454, 0.00883064325898886, 0.00880403444170952, 0.00877747684717178, 0.008750987239182, 0.00872449111193419, 0.00869808066636324, 0.00867169443517923, 0.00864536967128515, 0.00861905422061682, 0.0085928151383996, 0.00856658443808556, 0.00854040496051311, 0.00851428601890802, 0.00848818570375443, 0.0084621524438262, 0.00843613781034946, 0.00841018278151751, 0.00838426221162081, 0.00835837610065937, 0.00833254959434271, 0.00830675009638071, 0.00828101020306349, 0.00825530383735895, 0.00822963379323483, 0.00820400379598141, 0.00817843619734049, 0.00815289560705423, 0.00812738761305809, 0.00810193084180355, 0.00807651784271002, 0.00805116537958384, 0.00802582874894142, 0.00800055358558893, 0.00797529611736536, 0.00795010663568974, 0.00792493391782045, 0.00789981335401535, 0.00787474494427443, 0.00784970168024302, 0.00782472640275955, 0.00779976975172758, 0.00777488155290484, 0.00775001058354974, 0.00772519083693624, 0.00770040601491928, 0.00767566310241818, 0.0076509821228683, 0.00762631697580218, 0.00760171329602599, 0.0075771426782012, 0.00755262421444058, 0.00752814114093781, 0.0075036995112896, 0.00747930118814111, 0.00745493778958917, 0.00743062607944012, 0.00740634929388762, 0.0073821316473186, 0.00735793216153979, 0.00733379181474447, 0.0073096863925457, 0.00728561542928219, 0.00726162176579237, 0.00723762763664126, 0.00721370335668325, 0.00718980422243476, 0.00716596515849233, 0.00714215217158198, 0.00711839087307453, 0.00709466403350234, 0.00707098050042987, 0.007047348190099, 0.00702373264357448, 0.00700019486248493, 0.00697666592895985, 0.0069532236084342, 0.00692977989092469, 0.00690640602260828, 0.00688305730000138, 0.00685975234955549, 0.00683650700375438, 0.00681327888742089, 0.00679011130705476, 0.00676696933805943, 0.00674389628693461, 0.00672084931284189, 0.00669782795011997, 0.00667487503960729, 0.00665193982422352, 0.00662908144295216, 0.00660624075680971, 0.00658345175907016, 0.00656069722026587, 0.00653799390420318, 0.00651530735194683, 0.00649269111454487, 0.00647011678665876, 0.00644755968824029, 0.00642507150769234, 0.00640260940417647, 0.00638020737096667, 0.00635783094912767, 0.00633552391082048, 0.00631320755928755, 0.00629096012562513, 0.00626877322793007, 0.00624661240726709, 0.00622450234368443, 0.00620241044089198, 0.00618038699030876, 0.00615838076919317, 0.00613643461838365, 0.00611453130841255, 0.00609266245737672, 0.00607084576040506, 0.00604905420914292, 0.00602733995765448, 0.00600561778992414, 0.00598398968577385, 0.0059623708948493, 0.00594079494476318, 0.00591927068307996, 0.00589777156710625, 0.00587635859847069, 0.00585495447739959, 0.00583360204473138, 0.00581228453665972, 0.00579100055620074, 0.00576976872980595, 0.00574858812615275, 0.00572744198143482, 0.00570633029565215, 0.00568526145070791, 0.00566424522548914, 0.00564328813925385, 0.00562233105301857, 0.00560145219787955, 0.00558058125898242, 0.00555978761985898, 0.00553902937099338, 0.005518295802176, 0.00549760600551963, 0.00547695904970169, 0.00545638939365745, 0.00543583650141954, 0.00541531853377819, 0.0053948350250721, 0.00537438597530127, 0.00535403983667493, 0.00533367693424225, 0.00531339086592197, 0.00529310526326299, 0.00527290580794215, 0.00525272265076637, 0.00523258373141289, 0.00521251279860735, 0.00519245071336627, 0.00517244916409254, 0.00515248998999596, 0.00513257412239909, 0.00511269271373749, 0.00509284576401114, 0.00507305096834898, 0.00505329808220267, 0.00503359781578183, 0.00501393107697368, 0.00499429041519761, 0.00497470237314701, 0.00495519069954753, 0.00493567856028676, 0.00491621950641274, 0.00489679351449013, 0.00487741129472852, 0.00485809752717614, 0.00483880983665586, 0.004819564986974, 0.00480035459622741, 0.00478120474144816, 0.00476208003237844, 0.00474300747737288, 0.0047239693813026, 0.00470496481284499, 0.00468603055924177, 0.00466712098568678, 0.00464827194809914, 0.00462942291051149, 0.00461065163835883, 0.00459191389381886, 0.00457321992143989, 0.00455456878989935, 0.00453594280406833, 0.00451737828552723, 0.00449883891269565, 0.00448038522154093, 0.00446194084361196, 0.0044435216113925, 0.00442516338080168, 0.00440683867782354, 0.00438859220594168, 0.00437035411596298, 0.00435215001925826, 0.00433399807661772, 0.00431589735671878, 0.00429783947765827, 0.00427982490509748, 0.00426182802766562, 0.00424389075487852, 0.00422600517049432, 0.00420815404504538, 0.00419035460799932, 0.00417256355285645, 0.00415485911071301, 0.00413716258481145, 0.00411952659487724, 0.00410193344578147, 0.00408436637371778, 0.00406687706708908, 0.0040493868291378, 0.00403198273852468, 0.00401456234976649, 0.00399724440649152, 0.00397992692887783, 0.00396265136078, 0.00394546380266547, 0.00392825761809945, 0.00391113758087158, 0.00389403477311134, 0.00387700996361673, 0.00386000168509781, 0.00384301086887717, 0.00382609735243022, 0.003809227142483, 0.00379239115864038, 0.00377559848129749, 0.0037588314153254, 0.00374211580492556, 0.00372546864673495, 0.00370883080177009, 0.00369223556481302, 0.00367570109665394, 0.00365919177420437, 0.00364274298772216, 0.0036263286601752, 0.0036099657882005, 0.00359362037852407, 0.0035773350391537, 0.00356108392588794, 0.00354487588629127, 0.00352871976792812, 0.00351259764283895, 0.00349652720615268, 0.00348048307932913, 0.00346449878998101, 0.0034485487267375, 0.00343262474052608, 0.00341676943935454, 0.00340093998238444, 0.0033851710613817, 0.0033694189041853, 0.00335373589769006, 0.00333807850256562, 0.00332246418111026, 0.00330689270049334, 0.00329133891500533, 0.00327587057836354, 0.00326041970402002, 0.00324503751471639, 0.00322966417297721, 0.00321435090154409, 0.00319907232187688, 0.00318385357968509, 0.00316866068169475, 0.0031535024754703, 0.00313839572481811, 0.00312332320027053, 0.00310832005925477, 0.0030933334492147, 0.00307839876040816, 0.00306348991580307, 0.00304865837097168, 0.00303383567370474, 0.00301906443201005, 0.00300434464588761, 0.00298965070396662, 0.00297501706518233, 0.0029604178853333, 0.00294587039388716, 0.00293134874664247, 0.0029168613255024, 0.00290244282223284, 0.00288804993033409, 0.00287371757440269, 0.00285941082984209, 0.00284514715895057, 0.00283092656172812, 0.00281675742007792, 0.00280262273736298, 0.00278851413168013, 0.00277447397820652, 0.00276045990176499, 0.00274649751372635, 0.00273256911896169, 0.00271870102733374, 0.00270484178327024, 0.00269105983898044, 0.00267730373889208, 0.00266358209773898, 0.00264992914162576, 0.00263628480024636, 0.00262270960956812, 0.00260916003026068, 0.00259567890316248, 0.00258220685645938, 0.00256878626532853, 0.00255541736260056, 0.00254207407124341, 0.0025287913158536, 0.0025155427865684, 0.00250234571285546, 0.0024891747161746, 0.00247605517506599, 0.00246297894045711, 0.00244993646629155, 0.00243693776428699, 0.00242399028502405, 0.00241108611226082, 0.00239821593277156, 0.0023853974416852, 0.00237259641289711, 0.00235988129861653, 0.00234717479906976, 0.00233451114036143, 0.0023219077847898, 0.00230932189151645, 0.00229679583571851, 0.00228432146832347, 0.00227187294512987, 0.00225946772843599, 0.00224708789028227, 0.00223477720282972, 0.0022225093562156, 0.00221028458327055, 0.0021980598103255, 0.00218592979945242, 0.00217382539995015, 0.00216177245602012, 0.002149737207219, 0.00213774456642568, 0.00212582107633352, 0.00211391435004771, 0.0021020770072937, 0.00209025642834604, 0.00207848753780127, 0.00206675310619175, 0.00205508759245276, 0.00204343046061695, 0.00203182525001466, 0.00202027149498463, 0.00200875196605921, 0.00199728435836732, 0.00198585097678006, 0.00197447813116014, 0.00196311366744339, 0.00195182650350034, 0.00194055668544024, 0.0019293298246339, 0.00191816303413361, 0.00190700532402843, 0.00189593317918479, 0.00188487826380879, 0.00187388376798481, 0.00186290650162846, 0.00185196369420737, 0.00184109807014465, 0.00183024990838021, 0.00181945308577269, 0.00180867349263281, 0.00179797154851258, 0.0017873125616461, 0.00177669641561806, 0.00176610611379147, 0.00175554177258164, 0.00174503773450851, 0.00173458503559232, 0.00172418414149433, 0.00171380897518247, 0.00170345965307206, 0.00169316190294921, 0.00168294156901538, 0.00167272984981537, 0.00166256120428443, 0.00165241840295494, 0.00164233578834683, 0.0016323218587786, 0.0016223166603595, 0.00161238026339561, 0.00160244386643171, 0.00159258488565683, 0.00158276036381721, 0.00157297018449754, 0.00156324892304838, 0.00155352766159922, 0.00154388358350843, 0.00153496884740889, 0.00152687565423548, 0.00151877594180405, 0.0015107193030417, 0.00150267546996474, 0.00149466190487146, 0.0014866697601974, 0.00147867773193866, 0.00147070712409914, 0.00146277504973114, 0.0014548689359799, 0.00144696293864399, 0.00143906974699348, 0.00143121101427823, 0.00142337800934911, 0.00141556863673031, 0.00140777009073645, 0.00139997364021838, 0.00139222235884517, 0.00138448411598802, 0.00137677369639277, 0.00136907398700714, 0.00136138952802867, 0.00135373289231211, 0.00134609348606318, 0.0013384863268584, 0.00133089639712125, 0.00132329575717449, 0.00131573795806617, 0.00130821042694151, 0.00130069791339338, 0.00129320903215557, 0.00128571805544198, 0.00127826363313943, 0.00127082853578031, 0.00126342358998954, 0.00125601212494075, 0.00124863942619413, 0.00124128384049982, 0.00123395421542227, 0.00122664810623974, 0.00121933768969029, 0.00121206825133413, 0.0012048160424456, 0.00119758525397629, 0.00119038019329309, 0.00118317315354943, 0.00117599184159189, 0.00116884266026318, 0.00116171094123274, 0.00115461146924645, 0.00114750536158681, 0.00114043592475355, 0.00113338581286371, 0.00112635712139308, 0.00111935008317232, 0.00111234292853624, 0.00110537454020232, 0.00109842780511826, 0.0010915023740381, 0.00108459417242557, 0.00107769027817994, 0.00107082084286958, 0.00106397515628487, 0.00105714215897024, 0.00105032650753856, 0.00104353239294142, 0.0010367619106546, 0.00103001715615392, 0.00102328963112086, 0.00101657072082162, 0.00100988626945764, 0.00100321893114597, 0.000996568822301924, 0.000989946769550443, 0.000983324716798961, 0.000976743409410119, 0.000970183697063476, 0.000963632483035326, 0.000957107171416283, 0.000950594781897962, 0.000944108178373426, 0.000937638804316521, 0.00093119079247117, 0.000924764492083341, 0.000918355188332498, 0.000911967654246837, 0.000905610038898885, 0.00089925667271018, 0.000892940035555512, 0.00088662764756009, 0.000880336679983884, 0.0008740802295506, 0.000867834489326924, 0.000861608190461993, 0.000855394639074802, 0.000849217700306326, 0.000843053800053895, 0.000836913415696472, 0.000830790202599019, 0.000824675720650703, 0.000818591273855418, 0.000812530517578125, 0.000806486990768462, 0.000800464884378016, 0.000794451392721385, 0.000788470264524221, 0.000782514864113182, 0.000776572444010526, 0.000770651386119425, 0.000764741154853255, 0.000758861016947776, 0.000753000320401043, 0.000747169717215002, 0.000741345458664, 0.000735529873054475, 0.000729761610273272, 0.000723997654858977, 0.000718259485438466, 0.000712534238118678, 0.000706834776792675, 0.00070115685230121, 0.000695491791702807, 0.000689848209731281, 0.000684232683852315, 0.000678630021866411, 0.000673050992190838, 0.000667493499349803, 0.000661957543343306, 0.000656443065963686, 0.000650928530376405, 0.000645452819298953, 0.000639998528640717, 0.000634561525657773, 0.000629148096777499, 0.000623734667897224, 0.000618362159002572, 0.000613008975051343, 0.000607677269726992, 0.00060235639102757, 0.000597052683588117, 0.000591772608458996, 0.00058651837753132, 0.000581285625230521, 0.00057607440976426, 0.000570865347981453, 0.000565694936085492, 0.00056054606102407, 0.000555405858904123, 0.000550291384570301, 0.000545189890544862, 0.000540118373464793, 0.000535066297743469, 0.000530029356013983, 0.000525020237546414, 0.000520013330969959, 0.000515047286171466, 0.000510098470840603, 0.000505156058352441, 0.00050024373922497, 0.000495353015139699, 0.000490473001264036, 0.000485618773382157, 0.000480792543385178, 0.000475979206385091, 0.000471174396807328, 0.000466410565422848, 0.000461657444247976, 0.000456927955383435, 0.000452198524726555, 0.000447516358690336, 0.000442849268438295, 0.000438199378550053, 0.000433575274655595, 0.000428946921601892, 0.000424363679485396, 0.000419802003307268, 0.000415251037338749, 0.000410708657000214, 0.000406192120863125, 0.000401707831770182, 0.000397240772144869, 0.000392790912883356, 0.000388371117878705, 0.000383944949135184, 0.000379563891328871, 0.000375195726519451, 0.00037084479117766, 0.000366517546353862, 0.000362203136319295, 0.000357914570486173, 0.000353658280801028, 0.000349410547642037, 0.000345184409525245, 0.000340949598466977, 0.00033678361796774, 0.000332615483785048, 0.000328462396282703, 0.00032433946034871, 0.000320225080940872, 0.000316140853101388, 0.000312075950205326, 0.000308032584143803, 0.000303989188978449, 0.000299984531011432, 0.000296014273772016, 0.000292048323899508, 0.000288108189124614, 0.00028416802524589, 0.000280266598565504, 0.000276384525932372, 0.000272523961029947, 0.000268682721070945, 0.000264841510215774, 0.000261034729192033, 0.000257270934525877, 0.000253502832492813, 0.000249756267294288, 0.000246018287725747, 0.000242321169935167, 0.000238649881794117, 0.000234984996495768, 0.000231341691687703, 0.000227706943405792, 0.000224110888666473, 0.000220532063394785, 0.000216974760405719, 0.000213438950595446, 0.000209898833418265, 0.000206399592570961, 0.000202926166821271, 0.00019947208056692, 0.000196015840629116, 0.000192594015970826, 0.000189191574463621, 0.0001858235191321, 0.000182459756615572, 0.00017911106988322, 0.000175788183696568, 0.00017249325173907, 0.000169221981195733, 0.000165957171702757, 0.000162707423442043, 0.000159496354172006, 0.000156298221554607, 0.000153123721247539, 0.000149975065141916, 0.000146817779750563, 0.00014370352437254, 0.000140606454806402, 0.000137533061206341, 0.000134485468151979, 0.000131429289467633, 0.000128411789773963, 0.000125415826914832, 0.00012244563549757, 0.0001194905344164, 0.000116539740702137, 0.000113623325887602, 0.000110728440631647, 0.000107859355921391, 0.000105013939901255, 0.000102164216514211, 9.93489084066823e-05, 9.6559408120811e-05, 9.3787100922782e-05, 9.10255694179796e-05, 8.8287670223508e-05, 8.55734397191554e-05, 8.28721313155256e-05, 8.02159775048494e-05, 7.75468943174928e-05, 7.4905801739078e-05, 7.23034172551706e-05, 6.97096329531632e-05, 6.71395100653172e-05, 6.45758118480444e-05, 6.2044411606621e-05, 5.95344972680323e-05, 5.70461015740875e-05, 5.45727416465525e-05, 5.21166039106902e-05, 4.96862739964854e-05, 4.72731626359746e-05, 4.48858481831849e-05, 4.25200305471662e-05, 4.01499237341341e-05, 3.78228360204957e-05, 3.55172414856497e-05, 3.32202471327037e-05, 3.09684437524993e-05, 2.87037073576357e-05, 2.64712543867063e-05, 2.42602818616433e-05, 2.20751335291425e-05, 1.99072037503356e-05, 1.77457077370491e-05, 1.56207952386467e-05, 1.35152213260881e-05, 1.14247086457908e-05, 9.3492462838185e-06, 7.29743578631314e-06, 5.26929079569527e-06, 3.26696886077116e-06, 1.28399790355616e-06, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 8.72142074305352e-16, 7.57058785438858e-07, 2.3012864858174e-06, 3.85411703973659e-06, 5.40694827577681e-06, 6.97268296789844e-06, 8.54702102515148e-06, 1.01213590824045e-05, 1.16999981401023e-05, 1.32958439280628e-05, 1.48830868056393e-05, 1.64832326845499e-05, 1.80876813828945e-05, 1.97093359020073e-05, 2.13223884202307e-05, 2.29483430302935e-05, 2.4582901460235e-05, 2.62217636191053e-05, 2.78606221399968e-05, 2.95080844807671e-05, 3.11684525513556e-05, 3.28331225318834e-05, 3.44934887834825e-05, 3.6175362765789e-05, 3.78529366571456e-05, 3.9539114368381e-05, 4.12295921705663e-05, 4.29372739745304e-05, 4.46363555965945e-05, 4.63483411294874e-05, 4.8068930482259e-05, 4.97895161970519e-05, 5.15187093697023e-05, 5.32565027242526e-05, 5.49985998077318e-05, 5.67406932532322e-05, 5.84956942475401e-05, 6.0259295423748e-05, 6.20272039668635e-05, 6.37951015960425e-05, 6.55845142318867e-05, 6.7365326685831e-05, 6.91547320457175e-05, 7.09484447725117e-05, 7.27593724150211e-05, 7.45659854146652e-05, 7.63812058721669e-05, 7.82093338784762e-05, 8.00374546088278e-05, 8.18655826151371e-05, 8.37066108942963e-05, 8.55562393553555e-05, 8.74101751833223e-05, 8.92641110112891e-05, 9.11395472940058e-05, 9.30020833038725e-05, 9.48818269534968e-05, 9.67615706031211e-05, 9.86585146165453e-05, 0.000100551165814977, 0.000102452409919351, 0.000104366568848491, 0.000106280720501672, 0.000108194879430812, 0.000110121938632801, 0.00011205759801669, 0.000113997572043445, 0.000115937524242327, 0.000117886091175023, 0.00011985185847152, 0.000121809032862075, 0.000123779114801437, 0.000125757782370783, 0.000127740757307038, 0.000129723732243292, 0.000131728229462169, 0.000133724097395316, 0.0001357329019811, 0.000137741677463055, 0.000139767667860724, 0.000141789365443401, 0.000143819648656063, 0.00014585854660254, 0.000147901751915924, 0.000149949250044301, 0.000152005348354578, 0.000154074368765578, 0.000156139067257755, 0.000158212380483747, 0.000160298586706631, 0.000162380500114523, 0.000164475321071222, 0.000166570127476007, 0.000168682148796506, 0.000170789877302013, 0.000172906191437505, 0.00017503542767372, 0.000177164649358019, 0.000179298178409226, 0.000181440307642333, 0.000183591051609255, 0.00018574608839117, 0.000187901125173084, 0.000190069069503807, 0.000192245614016429, 0.000194417851162143, 0.000196602995856665, 0.000198801048099995, 0.000200999100343324, 0.000203197152586654, 0.000205412405193783, 0.000207627672352828, 0.00020984721777495, 0.000212079685297795, 0.000214316445635632, 0.000216548913158476, 0.000218798595597036, 0.000221056849113666, 0.00022331511718221, 0.00022557339980267, 0.000227853175601922, 0.000230128658586182, 0.000232412741752341, 0.000234696824918501, 0.000237002401263453, 0.00023929939197842, 0.000241609290242195, 0.000243927759584039, 0.000246246258029714, 0.000248569034738466, 0.000250900455284864, 0.000253244739724323, 0.000255589053267613, 0.00025793764507398, 0.000260294851614162, 0.00026266067288816, 0.000265035108895972, 0.000267405179329216, 0.000269796815700829, 0.000272179808234796, 0.000274567137239501, 0.000276971666608006, 0.000279380503343418, 0.000281793618341908, 0.000284206733340397, 0.000286641385173425, 0.000289067393168807, 0.000291506323264912, 0.000293945282464847, 0.000296405720291659, 0.000298853236017749, 0.000301317981211469, 0.000303791312035173, 0.000306264671962708, 0.000308742339257151, 0.000311237177811563, 0.000313727738102898, 0.00031622257665731, 0.000318726029945537, 0.000321246712701395, 0.000323758751619607, 0.000326283712638542, 0.000328817288391292, 0.000331350864144042, 0.000333888718159869, 0.000336439494276419, 0.000338998856022954, 0.000341558217769489, 0.000344121915986761, 0.000346702785464004, 0.000349275069311261, 0.000351864582626149, 0.000354449759470299, 0.000357056444045156, 0.000359654513886198, 0.000362265534931794, 0.000364885112503543, 0.000367500411812216, 0.000370132882380858, 0.000372761103790253, 0.000375410803826526, 0.000378051918232813, 0.000380705925635993, 0.000383368518669158, 0.000386035448173061, 0.000388702348573133, 0.000391382171073928, 0.000394066271837801, 0.000396759016439319, 0.000399447424570099, 0.000402157340431586, 0.000404862978029996, 0.000407577201258391, 0.000410300039220601, 0.000413031462812796, 0.000415758579038084, 0.000418498617364094, 0.000421247270423919, 0.000424000230850652, 0.000426753162173554, 0.000429514708230272, 0.000432289147283882, 0.000435067893704399, 0.000437842332758009, 0.000440642586909235, 0.000443429977167398, 0.00044623448047787, 0.000449034734629095, 0.000451856525614858, 0.000454669672762975, 0.000457495771115646, 0.000460334704257548, 0.000463169388240203, 0.000466008379589766, 0.000468855927465484, 0.000471720704808831, 0.000474576896522194, 0.000477445981232449, 0.000480323651572689, 0.000483205687487498, 0.000486087665194646, 0.000488982535898685, 0.00049188599223271, 0.000494789506774396, 0.000497697270475328, 0.000500622321851552, 0.000503543007653207, 0.000506472308188677, 0.000509405857883394, 0.000512356695253402, 0.000515298917889595, 0.000518254062626511, 0.00052121770568192, 0.000524185714311898, 0.000527153722941875, 0.000530143268406391, 0.000533124257344753, 0.000536118051968515, 0.000539111904799938, 0.00054212287068367, 0.000545125280041248, 0.000548144918866456, 0.000551168865058571, 0.000554197118617594, 0.000557229679543525, 0.00056027079699561, 0.00056332052918151, 0.000566374568734318, 0.000569428608287126, 0.000572504184674472, 0.000575571146328002   }, 
   { 0.00158567319158465, 0.00157701829448342, 0.00156839867122471, 0.00155984924640507, 0.00155124720185995, 0.00154268019832671, 0.00153414846863598, 0.00152563431765884, 0.00151712028309703, 0.00150860613211989, 0.00150014471728355, 0.00149171845987439, 0.00148325716145337, 0.00147484848275781, 0.00146645749919116, 0.00145804882049561, 0.00144972815178335, 0.0014413723256439, 0.00143303407821804, 0.00142476626206189, 0.00141642801463604, 0.00140819523949176, 0.00139994500204921, 0.00139169476460665, 0.00138351472560316, 0.00137529976200312, 0.00136711983941495, 0.00135895737912506, 0.0013508127303794, 0.00134272070135921, 0.00133461121004075, 0.00132650160230696, 0.00131844484712929, 0.00131038809195161, 0.00130238418933004, 0.00129436247516423, 0.00128635845612735, 0.00127840728964657, 0.00127045600675046, 0.00126250472385436, 0.00125457113608718, 0.00124667270574719, 0.00123880943283439, 0.00123092846479267, 0.00122306530829519, 0.00121523719280958, 0.00120742665603757, 0.00119965127669275, 0.00119187601376325, 0.00118411821313202, 0.00117641326505691, 0.0011686907382682, 0.00116098579019308, 0.00115328084211797, 0.00114562863018364, 0.0011379939969629, 0.00113035948015749, 0.00112276012077928, 0.00111514306627214, 0.00110757886432111, 0.00110004981979728, 0.00109250319655985, 0.00108497415203601, 0.00107748026493937, 0.00107002165168524, 0.00106256292201579, 0.00105512177105993, 0.0010476631578058, 0.00104029243811965, 0.00103288644459099, 0.00102551572490484, 0.00101816258393228, 0.00101080955937505, 0.00100354431197047, 0.000996243907138705, 0.00098894361872226, 0.000981678487733006, 0.000974448397755623, 0.000967236061114818, 0.000960023608058691, 0.000952828850131482, 0.000945651612710208, 0.000938527111429721, 0.0009313850896433, 0.000924260704778135, 0.000917171419132501, 0.000910117290914059, 0.000903063220903277, 0.0008959915721789, 0.000888972659595311, 0.00088200654136017, 0.000875005265697837, 0.000868039031047374, 0.00086109054973349, 0.000854142010211945, 0.000847263843752444, 0.000840350519865751, 0.00083347235340625, 0.000826611765660346, 0.000819768814835697, 0.000812978541944176, 0.00080617074854672, 0.00079938059207052, 0.000792643113527447, 0.000785905693192035, 0.000779150635935366, 0.000772430736105889, 0.00076572853140533, 0.000759096641559154, 0.000752429536078125, 0.000745780067518353, 0.000739165814593434, 0.000732569023966789, 0.000725989928469062, 0.00071942841168493, 0.000712866836693138, 0.000706375751178712, 0.000699831754900515, 0.000693375826813281, 0.000686884624883533, 0.000680428696796298, 0.00067402544664219, 0.000667604675982147, 0.00066120142582804, 0.000654815812595189, 0.000648447778075933, 0.000642132537905127, 0.000635799660813063, 0.000629484420642257, 0.00062316918047145, 0.000616906734649092, 0.000610697024967521, 0.000604434579145163, 0.000598224869463593, 0.00059206789592281, 0.0005858582444489, 0.000579701329115778, 0.000573561934288591, 0.000567422597669065, 0.000561353634111583, 0.000555249454919249, 0.000549180491361767, 0.000543129106517881, 0.000537077779881656, 0.000531114346813411, 0.000525115698110312, 0.000519117107614875, 0.000513153674546629, 0.000507225398905575, 0.000501314760185778, 0.000495404121465981, 0.00048951106145978, 0.000483670766698197, 0.000477830471936613, 0.000471972627565265, 0.000466167519334704, 0.000460380018921569, 0.000454627646831796, 0.000448857754236087, 0.000443105411250144, 0.000437388254795223, 0.000431723863584921, 0.000426024344051257, 0.000420359952840954, 0.000414713169448078, 0.000409066386055201, 0.000403489975724369, 0.000397878378862515, 0.000392301968531683, 0.000386760715628043, 0.000381254649255425, 0.000375713425455615, 0.000370207359082997, 0.000364718900527805, 0.000359283207217231, 0.000353847513906658, 0.000348394241882488, 0.000342993764206767, 0.000337593228323385, 0.000332245515892282, 0.000326897774357349, 0.000321532454108819, 0.00031625508563593, 0.000310924922814593, 0.00030566516215913, 0.000300405401503667, 0.00029516319045797, 0.000289956195047125, 0.000284749199636281, 0.000279559782939032, 0.000274370366241783, 0.000269216136075556, 0.000264114671153948, 0.000258995627518743, 0.000253894162597135, 0.000248792726779357, 0.000243744041654281, 0.000238730543060228, 0.000233699451200664, 0.000228685952606611, 0.000223725219257176, 0.000218746907194145, 0.000213803767110221, 0.000208860641578212, 0.000203952688025311, 0.000199079906451516, 0.00019418956071604, 0.000189334372407757, 0.000184479198651388, 0.000179659196874127, 0.000174891974893399, 0.000170089580933563, 0.000165322358952835, 0.000160572715685703, 0.000155858258949593, 0.000151161410030909, 0.000146464561112225, 0.000141767697641626, 0.000137141207233071, 0.000132497123559006, 0.000127870633150451, 0.000123261721455492, 0.000118688010843471, 0.000114149472210556, 0.000109593347588088, 0.000105054808955174, 0.000100533863587771, 9.6065690740943e-05, 9.15975178941153e-05, 8.71469383127987e-05, 8.27139519969933e-05, 7.82633724156767e-05, 7.39007446100004e-05, 6.95029375492595e-05, 6.51403097435832e-05, 6.08128721069079e-05, 5.65030204597861e-05, 5.21931688126642e-05, 4.79009104310535e-05, 4.36086484114639e-05, 3.938675581594e-05, 3.5164863220416e-05, 3.09253773593809e-05, 2.67210725723999e-05, 2.25343610509299e-05, 1.8400423869025e-05, 1.42664857776253e-05, 1.0114956239704e-05, 6.01619967710576e-06, 1.93503501577652e-06, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 2.48062026581247e-15, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 0.000259455002378672, 1.9350349589331e-07, 4.30985073762713e-06, 8.39101539895637e-06, 1.24897715068073e-05, 1.66237095982069e-05, 2.07752382266335e-05, 2.49619497481035e-05, 2.91486649075523e-05, 3.33353746100329e-05, 3.75572708435357e-05, 4.1814346332103e-05, 4.60890150861815e-05, 5.03636802022811e-05, 5.46383525943384e-05, 5.89482006034814e-05, 6.33284143987112e-05, 6.76558556733653e-05, 7.20184834790416e-05, 7.64162905397825e-05, 8.0849276855588e-05, 8.52646771818399e-05, 8.96976634976454e-05, 9.41482503549196e-05, 9.86691884463653e-05, 0.000103154954558704, 0.000107658313936554, 0.000112196852569468, 0.000116735376650468, 0.000121344288345426, 0.000125917998957448, 0.000130509317386895, 0.000135153401060961, 0.000139779891469516, 0.000144476754940115, 0.000149156010593288, 0.000153835280798376, 0.000158584924065508, 0.000163334552780725, 0.000168066588230431, 0.000172833810211159, 0.000177636204170994, 0.000182456205948256, 0.000187276193173602, 0.000192113788216375, 0.000196986555238254, 0.000201859336812049, 0.000206784883630462, 0.00021171041589696, 0.000216635962715372, 0.000221614274778403, 0.000226557414862327, 0.000231588506721891, 0.000236584412050433, 0.000241615503909998, 0.000246681767748669, 0.000251748046139255, 0.000256814324529842, 0.000260517379501835, 0.000262584333540872, 0.000264660106040537, 0.000266762246610597, 0.000268925999989733, 0.000271072116447613, 0.000273279816610739, 0.000275522703304887, 0.000277791958069429, 0.000280087610008195, 0.00028239208040759, 0.000284775655018166, 0.000287150469375774, 0.000289569288725033, 0.000291988078970462, 0.000294503610348329, 0.00029700159211643, 0.000299525912851095, 0.000302120606647804, 0.000304706540191546, 0.000307345209876075, 0.000309983908664435, 0.000312692980514839, 0.000315419601975009, 0.000318172591505572, 0.00032095200731419, 0.000323740241583437, 0.000326625187881291, 0.000329501373926178, 0.000332403928041458, 0.000335341668687761, 0.000338305777404457, 0.000341313891112804, 0.000344330794177949, 0.000347426830558106, 0.000350478861946613, 0.000353592535248026, 0.000356776552507654, 0.000359951780410483, 0.000363162194844335, 0.00036639894824475, 0.000369688525097445, 0.000373013288481161, 0.000376320414943621, 0.000379706732928753, 0.000383119448088109, 0.000386532134143636, 0.000389980006730184, 0.000393498252378777, 0.000396998890209943, 0.000400552322389558, 0.000404140941100195, 0.000407764717238024, 0.000411414919653907, 0.000415056303609163, 0.000418759271269664, 0.000422523793531582, 0.000426261918619275, 0.000430070387665182, 0.000433878914918751, 0.000437784183304757, 0.000441645446699113, 0.000445559504441917, 0.000449543906142935, 0.000453528336947784, 0.0004575215280056, 0.000461567513411865, 0.000465648656245321, 0.000469747465103865, 0.000473881373181939, 0.000478059286251664, 0.000482254836242646, 0.000486467877635732, 0.00049072498222813, 0.000495026062708348, 0.000499353453051299, 0.000503680959809572, 0.000508087512571365, 0.000512502912897617, 0.000516927160788327, 0.000521386507898569, 0.000525933864992112, 0.000530446006450802, 0.000535002094693482, 0.000539593398571014, 0.000544202281162143, 0.000548899173736572, 0.000553560850676149, 0.000558284053113312, 0.000563060108106583, 0.000567818584386259, 0.000572629738599062, 0.000577449740376323, 0.000582340115215629, 0.000587248068768531, 0.000592191179748625, 0.000597160717006773, 0.000602147832978517, 0.000607161317020655, 0.000612218806054443, 0.00061732908943668, 0.000622412888333201, 0.000627567118499428, 0.000632774201221764, 0.000637981167528778, 0.00064319692319259, 0.000648483110126108, 0.000653795665130019, 0.000659134646411985, 0.00066447356948629, 0.000669865286909044, 0.000675318529829383, 0.000680745462886989, 0.000686233921442181, 0.000691739958710968, 0.000697298848535866, 0.000702892837580293, 0.000708504405338317, 0.000714116031304002, 0.000719815609045327, 0.000725479971151799, 0.000731214706320316, 0.00073700217762962, 0.000742772128432989, 0.000748603604733944, 0.000754470354877412, 0.000760363356675953, 0.000766256416682154, 0.000772193539887667, 0.000778218440245837, 0.000784234667662531, 0.000790233258157969, 0.000796293490566313, 0.000802423979621381, 0.000808528158813715, 0.000814702711068094, 0.000820894783828408, 0.000827122130431235, 0.000833366997539997, 0.000839647080283612, 0.000845979899168015, 0.000852312718052417, 0.000858680752571672, 0.000865101581439376, 0.00087155750952661, 0.00087799591710791, 0.000884487119037658, 0.000891013420186937, 0.000897601421456784, 0.000904171727597713, 0.000910803617443889, 0.000917435565497726, 0.000924155348911881, 0.000930848764255643, 0.000937595032155514, 0.000944402767345309, 0.000951193040236831, 0.000958018470555544, 0.000964861421380192, 0.000971783592831343, 0.00097872328478843, 0.000985663151368499, 0.00099267321638763, 0.000999692012555897, 0.00100671104155481, 0.00101381784770638, 0.00102094234898686, 0.00102805800270289, 0.00103522639255971, 0.00104243005625904, 0.00104972161352634, 0.00105695147067308, 0.00106423429679126, 0.00107155228033662, 0.00107895815744996, 0.00108631129842252, 0.00109375244937837, 0.00110117578878999, 0.00110869621858001, 0.00111619883682579, 0.00112369272392243, 0.00113130081444979, 0.00113890913780779, 0.0011465436546132, 0.00115419598296285, 0.00116191850975156, 0.00116962345782667, 0.00117738102562726, 0.00118519156239927, 0.00119301967788488, 0.00120084779337049, 0.00120871118269861, 0.00121666234917939, 0.00122456962708384, 0.00123252964112908, 0.00124053366016597, 0.0012486168416217, 0.00125666486565024, 0.00126473908312619, 0.00127286638598889, 0.0012810374610126, 0.00128920865245163, 0.001297423732467, 0.00130569166503847, 0.00131395948119462, 0.00132226257119328, 0.00133059185463935, 0.00133899180218577, 0.00134738278575242, 0.00135584420058876, 0.0013642703415826, 0.00137280207127333, 0.00138129864353687, 0.00138984806835651, 0.00139845896046609, 0.00140706973616034, 0.00141570705454797, 0.00142436206806451, 0.00143312243744731, 0.00144184764940292, 0.00145059055648744, 0.00145940389484167, 0.00146825215779245, 0.00147710938472301, 0.00148598407395184, 0.00149492046330124, 0.00150389201007783, 0.00151286344043911, 0.00152187026105821, 0.00153093843255192, 0.00153998925816268, 0.0015491102822125, 0.00155823130626231, 0.00156742276158184, 0.00157663179561496, 0.00158584956079721, 0.00159510259982198, 0.00160441710613668, 0.00161371403373778, 0.00162307254504412, 0.00163247506134212, 0.00164187769405544, 0.0016513328300789, 0.00166078831534833, 0.00167034019250423, 0.00167985702864826, 0.00168938282877207, 0.00169900513719767, 0.00170865387190133, 0.00171831157058477, 0.00172798661515117, 0.00173773220740259, 0.00174746895208955, 0.00175724097061902, 0.00176705687772483, 0.00177694309968501, 0.00178679428063333, 0.00179669808130711, 0.00180665473453701, 0.0018165938090533, 0.00182660319842398, 0.00183661270420998, 0.00184671010356396, 0.00185677199624479, 0.00186690466944128, 0.001877028378658, 0.00188724021427333, 0.00189745193347335, 0.00190769881010056, 0.0019179368391633, 0.00192826299462467, 0.00193860661238432, 0.00194895907770842, 0.00195934670045972, 0.00196979590691626, 0.00198026257567108, 0.00199072062969208, 0.00200128415599465, 0.00201180367730558, 0.00202237605117261, 0.00203300104476511, 0.00204366142861545, 0.00205432157963514, 0.00206501735374331, 0.00207577412948012, 0.00208653137087822, 0.0020973146893084, 0.00210813339799643, 0.00211902218870819, 0.00212990236468613, 0.00214080023579299, 0.00215174187906086, 0.00216275383718312, 0.00217376626096666, 0.00218479591421783, 0.00219585211016238, 0.00220697838813066, 0.00221813120879233, 0.00222926656715572, 0.00224048085510731, 0.00225169537588954, 0.00226295366883278, 0.00227422965690494, 0.0022855584975332, 0.00229690480045974, 0.0023082687985152, 0.00231968564912677, 0.00233115488663316, 0.00234261550940573, 0.00235409382730722, 0.00236566900275648, 0.00237719994038343, 0.00238878396339715, 0.00240042060613632, 0.00241207447834313, 0.00242377282120287, 0.00243547093123198, 0.00244725705124438, 0.00245899916626513, 0.00247082929126918, 0.00248265941627324, 0.00249455985613167, 0.00250643398612738, 0.00251837866380811, 0.00253032310865819, 0.00254232017323375, 0.00255435239523649, 0.00256639393046498, 0.00257846992462873, 0.00259060808457434, 0.00260276370681822, 0.00261490140110254, 0.00262710987590253, 0.00263938866555691, 0.00265164091251791, 0.00266392831690609, 0.00267629511654377, 0.00268864398822188, 0.00270101078785956, 0.00271343882195652, 0.00272591970860958, 0.00273840106092393, 0.00275089079514146, 0.00276345969177783, 0.00277601974084973, 0.00278864149004221, 0.00280128070153296, 0.00281394645571709, 0.00282664736732841, 0.002839365741238, 0.00285215466283262, 0.00286492588929832, 0.00287776743061841, 0.00289057358168066, 0.00290348567068577, 0.00291640660725534, 0.00292934500612319, 0.00294229201972485, 0.00295530934818089, 0.00296837999485433, 0.00298143271356821, 0.00299451150931418, 0.00300766131840646, 0.00302081927657127, 0.00303399516269565, 0.0030472322832793, 0.00306048733182251, 0.00307375122793019, 0.00308706774376333, 0.0031004196498543, 0.00311378901824355, 0.00312719354405999, 0.00314063322730362, 0.00315412553027272, 0.00316760945133865, 0.00318111060187221, 0.00319472630508244, 0.00320827146060765, 0.00322190462611616, 0.00323553802445531, 0.00324923265725374, 0.00326294498518109, 0.00327667477540672, 0.00329044042155147, 0.00330426660366356, 0.00331811117939651, 0.00333195552229881, 0.00334584387019277, 0.00335979368537664, 0.00337375211529434, 0.00338772847317159, 0.00340173998847604, 0.00341581297107041, 0.00342987733893096, 0.00344398524612188, 0.00345814623869956, 0.00347230723127723, 0.00348651222884655, 0.0035007344558835, 0.00351502746343613, 0.00352930277585983, 0.00354362209327519, 0.00355800264514983, 0.00357237481512129, 0.00358679983764887, 0.00360124232247472, 0.00361571996472776, 0.00363024999387562, 0.00364478048868477, 0.00365938129834831, 0.00367396418005228, 0.00368858245201409, 0.00370325380936265, 0.00371794262900949, 0.00373267498798668, 0.00374739896506071, 0.0037622107192874, 0.00377701362594962, 0.00379189592786133, 0.00380674283951521, 0.00382166029885411, 0.00383661268278956, 0.00385158299468458, 0.00386657076887786, 0.00388159370049834, 0.00389668671414256, 0.00391174526885152, 0.00392686482518911, 0.00394203700125217, 0.00395722687244415, 0.00397243490442634, 0.00398768670856953, 0.00400297297164798, 0.00401827739551663, 0.00403360836207867, 0.00404900079593062, 0.00406440161168575, 0.00407982943579555, 0.00409528287127614, 0.00411080708727241, 0.00412630522623658, 0.00414183828979731, 0.00415741559118032, 0.00417305389419198, 0.00418871035799384, 0.00420436589047313, 0.00422006659209728, 0.00423581060022116, 0.00425159046426415, 0.00426736939698458, 0.00428320141509175, 0.00429908651858568, 0.00431495392695069, 0.00433088280260563, 0.00434684660285711, 0.00436282809823751, 0.00437885383144021, 0.00439488794654608, 0.00441098446026444, 0.00442706281319261, 0.00444319378584623, 0.00445939507335424, 0.00447556143626571, 0.00449179857969284, 0.00450805248692632, 0.00452435109764338, 0.00454068416729569, 0.00455701816827059, 0.00457343086600304, 0.00458983471617103, 0.00460629072040319, 0.00462272996082902, 0.00463922135531902, 0.00465578399598598, 0.00467234617099166, 0.00468894327059388, 0.00470554921776056, 0.00472224364057183, 0.0047389199025929, 0.00475563202053308, 0.00477240467444062, 0.00478916941210628, 0.00480599515140057, 0.00482281250879169, 0.00483970902860165, 0.00485660554841161, 0.00487352814525366, 0.00489052152261138, 0.00490752328187227, 0.00492454273626208, 0.00494159758090973, 0.00495869619771838, 0.00497580366209149, 0.00499293720349669, 0.00501015968620777, 0.00502736307680607, 0.00504458555951715, 0.00506185973063111, 0.00507917860522866, 0.00509651517495513, 0.00511310528963804, 0.00512913102284074, 0.00514526152983308, 0.00516139343380928, 0.00517759472131729, 0.00519384909421206, 0.00521020824089646, 0.00522660370916128, 0.00524303363636136, 0.00525953434407711, 0.005276158452034, 0.0052927820943296, 0.00530945835635066, 0.00532624032348394, 0.00534305814653635, 0.00535992765799165, 0.00537686794996262, 0.00539387948811054, 0.00541094271466136, 0.00542807625606656, 0.00544528057798743, 0.00546253798529506, 0.00547979446128011, 0.00549717480316758, 0.00551462499424815, 0.00553212873637676, 0.00554964924231172, 0.00556727591902018, 0.00558495474979281, 0.00560268713161349, 0.0056204367429018, 0.00563830928876996, 0.0056562521494925, 0.00567423040047288, 0.00569229666143656, 0.00571036292240024, 0.0057285875082016, 0.0057467594742775, 0.00576501898467541, 0.00578338420018554, 0.00580178434029222, 0.00582029018551111, 0.00583881419152021, 0.00585744343698025, 0.00587605452165008, 0.0058947722427547, 0.00591355934739113, 0.0059324000030756, 0.0059512397274375, 0.00597020331770182, 0.00598925491794944, 0.00600832374766469, 0.00602742796763778, 0.00604665512219071, 0.00606593443080783, 0.00608523236587644, 0.00610461831092834, 0.00612405594438314, 0.0061435648240149, 0.00616312632337213, 0.0061827409081161, 0.00620247796177864, 0.00622217962518334, 0.00624198745936155, 0.00626183114945889, 0.00628181407228112, 0.00630176300182939, 0.0063218348659575, 0.00634194118902087, 0.00636215368285775, 0.00638234848156571, 0.00640263082459569, 0.00642303749918938, 0.0064434427767992, 0.0064639369957149, 0.00648443028330803, 0.00650508236140013, 0.0065257172100246, 0.00654643960297108, 0.00656723231077194, 0.00658807810395956, 0.00660895928740501, 0.00662994524464011, 0.00665100198239088, 0.00667205825448036, 0.00669320300221443, 0.00671440083533525, 0.00673572113737464, 0.00675702374428511, 0.00677841529250145, 0.00679989391937852, 0.00682140747085214, 0.00684295734390616, 0.00686463015154004, 0.00688631972298026, 0.00690811546519399, 0.00692991074174643, 0.0069517414085567, 0.00697373040020466, 0.00699577247723937, 0.007017832249403, 0.00703994417563081, 0.00706214411184192, 0.00708439713343978, 0.00710668554529548, 0.00712906150147319, 0.00715149007737637, 0.00717397220432758, 0.00719652371481061, 0.00721918139606714, 0.00724182091653347, 0.0072645666077733, 0.00728734722360969, 0.007310233078897, 0.00733315479010344, 0.00735611096024513, 0.00737917330116034, 0.00740225287154317, 0.00742543861269951, 0.00744864158332348, 0.00747193256393075, 0.00749527616426349, 0.00751868961378932, 0.00754212122410536, 0.00756569346413016, 0.00758924847468734, 0.00761292595416307, 0.00763662159442902, 0.00766038754954934, 0.00768424058333039, 0.00770811270922422, 0.00773210683837533, 0.00775611866265535, 0.00778016587719321, 0.00780430063605309, 0.00782854203134775, 0.00785280019044876, 0.00787707604467869, 0.0079015102237463, 0.00792594440281391, 0.00795043166726828, 0.00797497108578682, 0.00799963437020779, 0.0080243144184351, 0.008049082942307, 0.00807386916130781, 0.00809876155108213, 0.00812366977334023, 0.00814866740256548, 0.00817373488098383, 0.0081988200545311, 0.00822399277240038, 0.00824927166104317, 0.00827458500862122, 0.00829991698265076, 0.00832531880587339, 0.00835077278316021, 0.00837635062634945, 0.00840199925005436, 0.00842762924730778, 0.00845336448401213, 0.0084791537374258, 0.00850501284003258, 0.00853088963776827, 0.00855688937008381, 0.00858290679752827, 0.0086089950054884, 0.0086351353675127, 0.0086613642051816, 0.00868762750178576, 0.00871396157890558, 0.00874034874141216, 0.00876685883849859, 0.00879333261400461, 0.00881989672780037, 0.00884656514972448, 0.00887326803058386, 0.00890000630170107, 0.00892681535333395, 0.00895372964441776, 0.00898068025708199, 0.00900766532868147, 0.00903470255434513, 0.0090618459507823, 0.00908906012773514, 0.00911629106849432, 0.00914357509464025, 0.00917098205536604, 0.00919840671122074, 0.0092258844524622, 0.00925344973802567, 0.00928106810897589, 0.00930873956531286, 0.00933646317571402, 0.0093642920255661, 0.00939212180674076, 0.00942002050578594, 0.0094480263069272, 0.00947608426213264, 0.00950416084378958, 0.00953232403844595, 0.00956057570874691, 0.00958886276930571, 0.00961720105260611, 0.00964559335261583, 0.00967409182339907, 0.00970260705798864, 0.00973119307309389, 0.00975986570119858, 0.00978857558220625, 0.00981737207621336, 0.00984620396047831, 0.00987508893013, 0.00990400929003954, 0.00993303488940001, 0.00996209494769573, 0.00999126117676497, 0.010020480491221, 0.0100497519597411, 0.0100790597498417, 0.0101084727793932, 0.0101379016414285, 0.010167402215302, 0.0101969558745623, 0.0102266147732735, 0.0102562913671136, 0.0102860210463405, 0.0103158550336957, 0.0103457421064377, 0.0103756478056312, 0.0104056410491467, 0.0104357041418552, 0.0104658203199506, 0.0104959728196263, 0.0105262640863657, 0.0105565208941698, 0.0105868838727474, 0.0106172813102603, 0.0106478026136756, 0.0106783397495747, 0.0107089309021831, 0.0107395928353071, 0.0107703423127532, 0.0108011271804571, 0.0108319474384189, 0.010862872004509, 0.0108938505873084, 0.0109248636290431, 0.010955948382616, 0.0109871020540595, 0.0110183274373412, 0.011049585416913, 0.0110809504985809, 0.0111122988164425, 0.0111437877640128, 0.0111753102391958, 0.0112068867310882, 0.0112384986132383, 0.0112702157348394, 0.0113019840791821, 0.0113338083028793, 0.0113656837493181, 0.01139762904495, 0.0114296274259686, 0.0114616956561804, 0.0114938523620367, 0.011526009067893, 0.0115582542493939, 0.0115905860438943, 0.0116229895502329, 0.0116554107517004, 0.0116879194974899, 0.0117204459384084, 0.0117530599236488, 0.0117857092991471, 0.0118184816092253, 0.0118513060733676, 0.011884150095284, 0.0119170984253287, 0.0119500290602446, 0.0119831003248692, 0.0120162069797516, 0.0120493834838271, 0.0120825953781605, 0.0121158789843321, 0.0121492315083742, 0.0121826203539968, 0.0122161135077477, 0.0122496075928211, 0.0122832236811519, 0.012316876091063, 0.0123506160452962, 0.0123843550682068, 0.0124182011932135, 0.0124520836398005, 0.0124860685318708, 0.0125200739130378, 0.0125541305169463, 0.0125882914289832, 0.0126224895939231, 0.0126567566767335, 0.0126910954713821, 0.012725468724966, 0.0127598941326141, 0.0127944266423583, 0.0128289917483926, 0.0128635950386524, 0.0128983026370406, 0.0129330446943641, 0.0129678752273321, 0.0130027243867517, 0.0130376778542995, 0.0130726667121053, 0.0131077086552978, 0.0131428204476833, 0.0131780030205846, 0.0132132386788726, 0.0132485432550311, 0.0132839195430279, 0.0133193135261536, 0.0133547959849238, 0.0133903287351131, 0.0134259508922696, 0.0134616261348128, 0.0134973367676139, 0.013533117249608, 0.0135689862072468, 0.0136048896238208, 0.0136408992111683, 0.0136768911033869, 0.0137130059301853, 0.0137491375207901, 0.0137853408232331, 0.0138216139748693, 0.0138579746708274, 0.0138943893834949, 0.0139308553189039, 0.0139673566445708, 0.0140039278194308, 0.0140405893325806, 0.0140773029997945, 0.0141140501946211, 0.014150851406157, 0.0141877578571439, 0.0142247173935175, 0.0142617113888264, 0.0142987761646509, 0.0143358930945396, 0.014373098500073, 0.0144103392958641, 0.0144476322457194, 0.0144850499927998, 0.014522448182106, 0.0145599534735084, 0.0145975109189749, 0.0146351205185056, 0.0146727999672294, 0.014710552059114, 0.0147483367472887, 0.0147861940786242, 0.0148241203278303, 0.0148621005937457, 0.014900148846209, 0.0149382529780269, 0.0149764083325863, 0.0150146512314677, 0.0150529472157359, 0.0150912953540683, 0.0151296984404325, 0.0151681527495384, 0.0152066946029663, 0.015245271846652, 0.0152839384973049, 0.0153226386755705, 0.0153614282608032, 0.015400268137455, 0.0154391806572676, 0.0154781090095639, 0.0155171267688274, 0.0155562153086066, 0.01559535600245, 0.0156346019357443, 0.0156738124787807, 0.0157131645828485, 0.0157525334507227, 0.0157919563353062, 0.0158315002918243, 0.0158710815012455, 0.0159107130020857, 0.0159504003822803, 0.015990138053894, 0.0160299129784107, 0.0160698257386684, 0.0161097757518291, 0.0161497965455055, 0.0161898173391819, 0.0162299424409866, 0.0162701215595007, 0.0163103528320789, 0.0163506716489792, 0.0163910090923309, 0.0164314322173595, 0.016471927985549, 0.0165124572813511, 0.0165530759841204, 0.0165937468409538, 0.0166344698518515, 0.0166752636432648, 0.0167160760611296, 0.0167569927871227, 0.016797998920083, 0.0168390199542046, 0.0168800968676805, 0.0169212613254786, 0.0169624593108892, 0.0170037467032671, 0.0170451030135155, 0.0170864779502153, 0.0171279236674309, 0.0171694383025169, 0.0172110423445702, 0.0172526612877846, 0.0172943882644176, 0.0173361506313086, 0.0173779651522636, 0.0174198672175407, 0.0174617860466242, 0.0175038110464811, 0.0175458732992411, 0.0175880212336779, 0.0176301691681147, 0.0176724418997765, 0.0177147667855024, 0.0177571270614862, 0.0177995562553406, 0.0178420562297106, 0.0178846269845963, 0.0179272163659334, 0.0179699100553989, 0.0180126391351223, 0.0180554557591677, 0.0180983077734709, 0.0181412491947412, 0.0181842055171728, 0.0182272344827652, 0.0182704031467438, 0.0183135718107224, 0.0183568112552166, 0.0184000860899687, 0.0184433963149786, 0.0184868108481169, 0.0185303147882223, 0.0185738690197468, 0.0186174251139164, 0.0186611041426659, 0.0187048185616732, 0.0187485869973898, 0.0187924057245255, 0.0188363138586283, 0.0188802741467953, 0.0189243052154779, 0.0189683698117733, 0.019012525677681, 0.0190567299723625, 0.0191009901463985, 0.0191453211009502, 0.0191896855831146, 0.0192341394722462, 0.0192786622792482, 0.0193232391029596, 0.0193678326904774, 0.0194125324487686, 0.0194573011249304, 0.0195021238178015, 0.0195469819009304, 0.0195918921381235, 0.0196369085460901, 0.0196819584816694, 0.0197270978242159, 0.0197722539305687, 0.0198174994438887, 0.0198627971112728, 0.0199081674218178, 0.0199535675346851, 0.0199990589171648, 0.0200446043163538, 0.0200902167707682, 0.0201359018683434, 0.0201816018670797, 0.0202273931354284, 0.0202732533216476, 0.0203191488981247, 0.0203651525080204, 0.0204111505299807, 0.0204572584480047, 0.0205034371465445, 0.0205496288836002, 0.0205958932638168, 0.0206422302871943, 0.0206886362284422, 0.020735876634717, 0.0207843780517578, 0.0208330880850554, 0.0208818316459656, 0.0209307186305523, 0.0209796577692032, 0.0210286658257246, 0.0210777446627617, 0.0211269315332174, 0.0211762376129627, 0.0212256349623203, 0.0212751012295485, 0.0213246215134859, 0.0213743336498737, 0.0214239936321974, 0.0214738305658102, 0.0215237177908421, 0.0215737279504538, 0.0216238293796778, 0.0216739661991596, 0.0217242259532213, 0.0217746049165726, 0.0218250043690205, 0.0218755975365639, 0.0219261702150106, 0.0219769068062305, 0.0220276545733213, 0.0220785811543465, 0.0221295263618231, 0.0221805926412344, 0.0222317297011614, 0.0222829934209585, 0.0223343204706907, 0.0223857071250677, 0.0224372316151857, 0.0224887914955616, 0.0225405246019363, 0.0225922800600529, 0.0226441584527493, 0.0226960871368647, 0.0227481201291084, 0.0228002443909645, 0.0228524394333363, 0.0229047872126102, 0.0229571592062712, 0.0230096336454153, 0.0230622123926878, 0.0231148637831211, 0.0231676027178764, 0.0232204478234053, 0.0232733972370625, 0.0233263783156872, 0.0233794897794724, 0.0234327204525471, 0.0234859511256218, 0.0235393401235342, 0.0235927812755108, 0.023646330460906, 0.0236999671906233, 0.0237536728382111, 0.023807518184185, 0.0238614026457071, 0.023915458470583, 0.0239695142954588, 0.0240236613899469, 0.0240779109299183, 0.0241323057562113, 0.0241866633296013, 0.0242411773651838, 0.0242958515882492, 0.0243505593389273, 0.0244053397327662, 0.0244601909071207, 0.0245151445269585, 0.0245702378451824, 0.0246253702789545, 0.0246806237846613, 0.0247359126806259, 0.0247913263738155, 0.0248468462377787, 0.0249024163931608, 0.0249581094831228, 0.0250138733536005, 0.025069709867239, 0.025125665590167, 0.0251817107200623, 0.0252378080040216, 0.0252940133213997, 0.0253503397107124, 0.0254067201167345, 0.0254631545394659, 0.0255197267979383, 0.025576388463378, 0.0256331339478493, 0.0256899725645781, 0.0257468819618225, 0.0258038956671953, 0.0258609969168901, 0.0259182024747133, 0.0259754452854395, 0.026032792404294, 0.0260902624577284, 0.0261477679014206, 0.026205450296402, 0.026263166218996, 0.0263209342956543, 0.0263788793236017, 0.0264368448406458, 0.0264949481934309, 0.0265530366450548, 0.026611315086484, 0.0266696643084288, 0.0267280489206314, 0.0267866272479296, 0.0268451888114214, 0.0269038919359446, 0.0269626844674349, 0.0270215775817633, 0.0270804911851883, 0.0271395798772573, 0.0271987020969391, 0.0272579323500395, 0.0273172501474619, 0.0273766741156578, 0.0274361502379179, 0.0274957474321127, 0.027555400505662, 0.0276152119040489, 0.0276750046759844, 0.0277349725365639, 0.0277949590235949, 0.027855122461915, 0.0279153194278479, 0.0279755499213934, 0.0280359759926796, 0.0280964374542236, 0.0281570367515087, 0.0282176230102777, 0.0282783657312393, 0.0283391959965229, 0.02840013243258, 0.0284611396491528, 0.0285221990197897, 0.0285833980888128, 0.0286446325480938, 0.0287060085684061, 0.0287674721330404, 0.0288289897143841, 0.0288906283676624, 0.0289523024111986, 0.0290141366422176, 0.0290760230273008, 0.0291379783302546, 0.0292000938206911, 0.0292622093111277, 0.0293244794011116, 0.0293867904692888, 0.0294492375105619, 0.0295117050409317, 0.0295743476599455, 0.0296370275318623, 0.0296997893601656, 0.0297626592218876, 0.0298256389796734, 0.0298886857926846, 0.0299517661333084, 0.0300150234252214, 0.0300783179700375, 0.0301417522132397, 0.030205188319087, 0.0302687603980303, 0.0303324237465858, 0.0303961765021086, 0.0304600484669209, 0.0305239763110876, 0.0305879879742861, 0.030652092769742, 0.0307162813842297, 0.0307805798947811, 0.0308449268341064, 0.0309094861149788, 0.0309739764779806, 0.0310386400669813, 0.0311033930629492, 0.0311681665480137, 0.0312330573797226, 0.0312980785965919, 0.0313632190227509, 0.0314283408224583, 0.0314936377108097, 0.0315589718520641, 0.0316243767738342, 0.0316899381577969, 0.0317555889487267, 0.0318212397396564, 0.0318870656192303, 0.0319529622793198, 0.0320189297199249, 0.0320849679410458, 0.032151110470295, 0.0322173424065113, 0.032283678650856, 0.0323501192033291, 0.0324165970087051, 0.032483197748661, 0.0325498320162296, 0.0326166450977325, 0.0326834917068481, 0.0327504649758339, 0.0328174643218517, 0.0328846126794815, 0.0329518653452396, 0.033019132912159, 0.0330865085124969, 0.033153984695673, 0.033221572637558, 0.0332892276346684, 0.0333570092916489, 0.0334247872233391, 0.0334927588701248, 0.033560749143362, 0.0336288623511791, 0.0336970463395119, 0.033765334635973, 0.0338336937129498, 0.0339021794497967, 0.0339707136154175, 0.034039318561554, 0.0341080315411091, 0.0341768823564053, 0.0342458039522171, 0.0343147292733192, 0.0343838259577751, 0.0344530120491982, 0.0345223061740398, 0.0345915965735912, 0.0346610806882381, 0.0347305685281754, 0.0348001755774021, 0.0348699055612087, 0.0349396914243698, 0.0350095629692078, 0.0350795239210129, 0.0351495556533337, 0.0352196916937828, 0.0352899841964245, 0.0353603139519691, 0.0354306809604168, 0.035501204431057, 0.0355718173086643, 0.0356424786150455, 0.0357132144272327, 0.035784088075161, 0.0358550511300564, 0.0359260477125645, 0.0359971895813942, 0.0360683612525463, 0.0361396931111813, 0.0362110808491707, 0.0362825691699982, 0.0363541133701801, 0.0364257656037807, 0.0364974997937679, 0.0365693047642708, 0.0366412550210953, 0.0367132574319839, 0.036785326898098, 0.0368575565516949, 0.0369298234581947, 0.0370021760463715, 0.0370746143162251, 0.0371471606194973, 0.0372198149561882, 0.0372925214469433, 0.0373653098940849, 0.037438191473484, 0.0375111773610115, 0.0375842861831188, 0.0376574471592903, 0.0377306640148163, 0.0378040187060833, 0.037877444177866, 0.0379509553313255, 0.038024578243494, 0.0380982682108879, 0.0381720289587975, 0.0382459089159966, 0.0383198969066143, 0.038393922150135, 0.0384680517017841, 0.0385423041880131, 0.0386166274547577, 0.038691021502018, 0.0387655198574066, 0.0388400889933109, 0.0389147810637951, 0.0389895103871822, 0.0390644334256649, 0.0391393341124058, 0.0392143949866295, 0.039289478212595, 0.0393646955490112, 0.039439931511879, 0.0395153649151325, 0.0395908318459988, 0.0396663658320904, 0.0397420264780521, 0.0398177392780781, 0.0398935936391354, 0.0399695187807083, 0.0400455072522163, 0.0401216074824333, 0.040197778493166, 0.0402740277349949, 0.040350366383791, 0.040426854044199, 0.0405033752322197, 0.0405799858272076, 0.0406567007303238, 0.0407335385680199, 0.0408103987574577, 0.0408873967826366, 0.0409644059836864, 0.0410416163504124, 0.0411188565194607, 0.0411962047219276, 0.0412735939025879, 0.0413510836660862, 0.0414286926388741, 0.0415063761174679, 0.0415841825306416, 0.0416620410978794, 0.0417400225996971, 0.0418180413544178, 0.0418961606919765, 0.041974350810051, 0.0420526713132858, 0.0421311147511005, 0.0422096028923988, 0.0422881655395031, 0.0423668175935745, 0.042445570230484, 0.0425243973731995, 0.0426033437252045, 0.0426824018359184, 0.0427614785730839, 0.0428406931459904, 0.0429199524223804, 0.0429993085563183, 0.0430787838995457, 0.0431583300232887, 0.0432380028069019, 0.0433177277445793, 0.0433975420892239, 0.0434774197638035, 0.0435574240982533, 0.0436375550925732, 0.0437177531421185, 0.0437980145215988, 0.0438783206045628, 0.0439587309956551, 0.0440392456948757, 0.0441199205815792, 0.0442006289958954, 0.0442814230918884, 0.0443623140454292, 0.0444433055818081, 0.0445243269205093, 0.0446054935455322, 0.0446867644786835, 0.0447680726647377, 0.0448494851589203, 0.0449309982359409, 0.045012541115284, 0.0450942516326904, 0.0451760478317738, 0.0452578999102116, 0.0453398004174232, 0.0454218499362469, 0.0455040000379086, 0.0455862060189247, 0.0456684939563274, 0.0457509271800518, 0.0458333641290665, 0.0459159351885319, 0.0459986142814159, 0.0460813604295254, 0.0461642183363438, 0.0462471432983875, 0.046330139040947, 0.0464132353663445, 0.0464964099228382, 0.04657968506217, 0.0466631054878235, 0.046746551990509, 0.0468301139771938, 0.0469137094914913, 0.0469974614679813, 0.0470812506973743, 0.0471651591360569, 0.0472491383552551, 0.047333225607872, 0.0474174022674561, 0.0475016422569752, 0.0475860089063644, 0.0476703979074955, 0.0477549396455288, 0.0478395558893681, 0.0479242913424969, 0.0480090267956257, 0.0480939261615276, 0.0481788702309132, 0.0482639446854591, 0.0483490824699402, 0.0484343692660332, 0.0485196821391582, 0.0486050881445408, 0.0486905984580517, 0.0487761795520782, 0.0488618537783623, 0.0489475727081299, 0.0490334518253803, 0.0491194203495979, 0.0492054559290409, 0.0492915511131287, 0.049377765506506, 0.0494640693068504, 0.0495504811406136, 0.0496369190514088, 0.0497234910726547, 0.0498101413249969, 0.0498968847095966, 0.0499837324023247, 0.0500706136226654, 0.0501576401293278, 0.0502447299659252, 0.0503319464623928, 0.0504192039370537, 0.0505065470933914, 0.0505940057337284, 0.0506815426051617, 0.0507691763341427, 0.0508569069206715, 0.0509446896612644, 0.0510326288640499, 0.0511205978691578, 0.0512086451053619, 0.0512967966496944, 0.0513850823044777, 0.0514733716845512, 0.0515618212521076, 0.0516503602266312, 0.0517389327287674, 0.0518276616930962, 0.0519164316356182, 0.0520053319633007, 0.0520942360162735, 0.0521833188831806, 0.0522724390029907, 0.0523616671562195, 0.0524510219693184, 0.05254041031003, 0.0526298955082893, 0.0527194701135159, 0.0528091304004192, 0.0528988987207413, 0.0529887564480305, 0.0530786998569965, 0.0531686916947365, 0.0532588176429272, 0.0533490441739559, 0.0534393005073071, 0.0535296984016895, 0.0536202117800713, 0.0537107884883881, 0.0538013949990273, 0.0538921542465687, 0.0539829395711422, 0.0540738664567471, 0.0541649051010609, 0.0542559735476971, 0.0543471500277519, 0.0544383935630322, 0.054529782384634, 0.0546212010085583, 0.054712750017643, 0.0548043958842754, 0.0548961199820042, 0.054987907409668, 0.055079773068428, 0.0551717579364777, 0.0552638098597527, 0.0553559884428978, 0.0554482750594616, 0.0555405579507351, 0.0556329973042011, 0.055725459009409, 0.0558180920779705, 0.055910762399435, 0.0560035780072212, 0.0560993291437626, 0.0561980046331882, 0.0562967956066132, 0.0563955865800381, 0.0564945563673973, 0.0565935224294662, 0.0566927008330822, 0.0567918829619884, 0.0568911507725716, 0.0569905191659927, 0.0570899322628975, 0.0571894980967045, 0.0572891160845757, 0.0573888048529625, 0.057488601654768, 0.0575884804129601, 0.0576884150505066, 0.0577884577214718, 0.0578885562717915, 0.0579888038337231, 0.0580891110002995, 0.0581895187497139, 0.0582899302244186, 0.0583905391395092, 0.0584911443293095, 0.0585919357836246, 0.0586927384138107, 0.0587936230003834, 0.0588946118950844, 0.0589956566691399, 0.0590968616306782, 0.059198047965765, 0.059299424290657, 0.0594007968902588, 0.0595023334026337, 0.05960388854146, 0.0597055666148663, 0.0598072819411755, 0.0599091500043869, 0.0600110925734043, 0.0601131208240986, 0.0602151677012444, 0.060317374765873, 0.0604196488857269, 0.0605220012366772, 0.0606244616210461, 0.0607269890606403, 0.0608295612037182, 0.0609322786331177, 0.0610350780189037, 0.0611378997564316, 0.0612409003078938, 0.0613439120352268, 0.0614470653235912, 0.0615502186119556, 0.0616535730659962, 0.0617569014430046, 0.0618603713810444, 0.0619639344513416, 0.0620675981044769, 0.0621712803840637, 0.0622750855982304, 0.0623789764940739, 0.0624829418957233, 0.0625870525836945, 0.0626912117004395, 0.062795415520668, 0.0628997310996056, 0.0630041509866714, 0.0631086155772209, 0.0632132068276405, 0.0633178725838661, 0.0634226873517036, 0.0635274574160576, 0.0636324062943459, 0.0637373626232147, 0.0638425052165985, 0.0639476403594017, 0.0640529468655586, 0.0641582608222961, 0.0642637014389038, 0.0643692165613174, 0.0644747987389565, 0.0645804852247238, 0.0646862834692001, 0.064792163670063, 0.0648980960249901, 0.0650041550397873, 0.0651102289557457, 0.0652164444327354, 0.0653227344155312, 0.0654291436076164, 0.0655355527997017, 0.0656421184539795, 0.0657486990094185, 0.0658554583787918, 0.0659622251987457, 0.0660691782832146, 0.066176101565361, 0.0662831813097, 0.0663903057575226, 0.0664975419640541, 0.0666048526763916, 0.0667122602462769, 0.0668197423219681, 0.0669272914528847, 0.0670349895954132, 0.0671427026391029, 0.067250557243824, 0.0673584565520287, 0.0674664676189423, 0.06757453083992, 0.0676826983690262, 0.0677909180521965, 0.06789930164814, 0.0680077150464058, 0.068116270005703, 0.068224810063839, 0.0683335289359093, 0.0684422701597214, 0.068551130592823, 0.0686600655317307, 0.0687690675258636, 0.0688782557845116, 0.0689874067902565, 0.0690967217087746, 0.069206029176712, 0.0693155229091644, 0.0694250613451004, 0.0695347040891647, 0.0696443915367126, 0.0697541907429695, 0.06986403465271, 0.0699740052223206, 0.0700840577483177, 0.0701941773295403, 0.0703044161200523, 0.070414736866951, 0.070525124669075, 0.0706356018781662, 0.070746123790741, 0.0708567947149277, 0.0709675475955009, 0.0710783377289772, 0.071189321577549, 0.0713002532720566, 0.0714113563299179, 0.0715225115418434, 0.0716337412595749, 0.0717451199889183, 0.0718564838171005, 0.0719680339097977, 0.0720796063542366, 0.0721912756562233, 0.0723030567169189, 0.0724148973822594, 0.0725267976522446, 0.0726388320326805, 0.072750948369503, 0.0728631019592285, 0.0729753896594048, 0.0730877816677094, 0.0732001736760139, 0.0733127370476723, 0.0734253376722336, 0.0735380798578262, 0.0736508592963219, 0.0737637057900429, 0.0738766938447952, 0.0739897042512894, 0.0741028636693954, 0.0742160677909851, 0.0743293538689613, 0.0744427442550659, 0.0745562463998795, 0.0746697634458542, 0.0747834369540215, 0.0748971253633499, 0.0750109627842903, 0.0751248449087143, 0.0752388536930084, 0.0753528997302055, 0.0754670798778534, 0.075581319630146, 0.0756956785917282, 0.0758100748062134, 0.0759245604276657, 0.0760391652584076, 0.0761537924408913, 0.0762685909867287, 0.0763834118843079, 0.0764983519911766, 0.0766133442521095, 0.0767284780740738, 0.0768435969948769, 0.0769588947296143, 0.0770742371678352, 0.0771896690130234, 0.0773052275180817, 0.0774208381772041, 0.0775364860892296, 0.077652283012867, 0.0777681618928909, 0.0778841376304626, 0.0780001729726791, 0.0781162679195404, 0.0782324895262718, 0.0783487558364868, 0.0784651711583138, 0.0785816311836243, 0.0786981657147408, 0.078814797103405, 0.0789315178990364, 0.0790483057498932, 0.0791652202606201, 0.0792822018265724, 0.0793992504477501, 0.0795164257287979, 0.0796336382627487, 0.0797509402036667, 0.0798683762550354, 0.0799858495593071, 0.0801034569740295, 0.0802211090922356, 0.0803388506174088, 0.0804566591978073, 0.0805745869874954, 0.0806926265358925, 0.0808106660842896, 0.0809288769960403, 0.0810471400618553, 0.0811654627323151, 0.0812838971614838, 0.0814024284482002, 0.0815210193395615, 0.0816396996378899, 0.081758514046669, 0.0818773284554482, 0.081996314227581, 0.0821153372526169, 0.0822344273328781, 0.0823536515235901, 0.0824729427695274, 0.0825923234224319, 0.0827117636799812, 0.0828312933444977, 0.0829509571194649, 0.0830706134438515, 0.0831904485821724, 0.0833103433251381, 0.083430290222168, 0.0835503786802292, 0.0836705416440964, 0.0837907493114471, 0.0839110314846039, 0.0840314850211143, 0.0841519236564636, 0.0842725187540054, 0.0843931511044502, 0.0845139026641846, 0.0846347212791443, 0.084755651652813, 0.084876649081707, 0.0849977359175682, 0.0851188823580742, 0.0852401703596115, 0.0853615030646324, 0.0854829326272011, 0.0856044292449951, 0.0857260078191757, 0.0858477205038071, 0.0859694704413414, 0.0860913097858429, 0.0862132534384727, 0.086335301399231, 0.0864573642611504, 0.0865795910358429, 0.0867018550634384, 0.0868242233991623, 0.0869466662406921, 0.0870691984891891, 0.0871918573975563, 0.0873145684599876, 0.0874373912811279, 0.0875602439045906, 0.0876832008361816, 0.0878062397241592, 0.0879293754696846, 0.0880526155233383, 0.0881759151816368, 0.0882992893457413, 0.0884227827191353, 0.0885463431477547, 0.0886699706315994, 0.0887937024235725, 0.0889175534248352, 0.0890413895249367, 0.0891654416918755, 0.089289516210556, 0.0894136428833008, 0.0895379334688187, 0.0896622538566589, 0.0897866934537888, 0.0899111703038216, 0.0900357738137245, 0.0901604518294334, 0.0902851969003677, 0.0904100462794304, 0.0905350297689438, 0.090659998357296, 0.0907851234078407, 0.0909102857112885, 0.0910355597734451, 0.0911609381437302, 0.0912863686680794, 0.0914118736982346, 0.0915375202894211, 0.0916632041335106, 0.0917890071868896, 0.0919148772954941, 0.0920408293604851, 0.0921669155359268, 0.092292994260788, 0.0924192517995834, 0.0925455316901207, 0.0926719084382057, 0.0927983671426773, 0.0929249823093414, 0.0930515378713608, 0.0931783020496368, 0.0933051183819771, 0.0934320092201233, 0.0935589894652367, 0.0936860740184784, 0.0938132256269455, 0.0939404591917992, 0.09406778216362, 0.0941951796412468, 0.0943227112293243, 0.0944502502679825, 0.0945779830217361, 0.0947056710720062, 0.0948335379362106, 0.0949614718556404, 0.0950894877314568, 0.0952175706624985, 0.0953458100557327, 0.095474012196064, 0.095602385699749, 0.0957308262586594, 0.0958593338727951, 0.0959879606962204, 0.0961166173219681, 0.0962454453110695, 0.0963742807507515, 0.0965032353997231, 0.09663225710392, 0.0967614129185677, 0.0968905612826347, 0.0970199480652809, 0.0971492528915405, 0.0972787290811539, 0.0974083095788956, 0.0975379198789597, 0.0976676493883133, 0.0977974608540535, 0.0979273244738579, 0.0980573371052742, 0.0981873795390129, 0.0983175411820412, 0.0984477996826172, 0.0985780656337738, 0.0987085178494453, 0.0988389700651169, 0.0989695489406586, 0.0991002023220062, 0.0992309898138046, 0.099361777305603, 0.0994927287101746, 0.0996237248182297, 0.0997548028826714, 0.0998860001564026, 0.100017242133617, 0.100148588418961, 0.10028000921011, 0.100411526858807, 0.100543148815632, 0.100674837827682, 0.100806593894958, 0.100938506424427, 0.101070381700993, 0.101202450692654, 0.101334542036057, 0.10146676003933, 0.101599030196667, 0.101731441915035, 0.101863853633404, 0.101996414363384, 0.102129064500332, 0.102261766791344, 0.102394558489323, 0.102527409791946, 0.102660454809666, 0.102793462574482, 0.102926626801491, 0.103059865534306, 0.103193163871765, 0.103326559066772, 0.10346008092165, 0.103593602776527, 0.103727273643017, 0.103861019015312, 0.103994823992252, 0.10412872582674, 0.104262717068195, 0.104396797716618, 0.104530997574329, 0.104665219783783, 0.104799583554268, 0.104934014379978, 0.105068475008011, 0.105203121900558, 0.105337806046009, 0.105472587049007, 0.105607442557812, 0.1057423427701, 0.105877362191677, 0.106012471020222, 0.106147676706314, 0.106282964348793, 0.106418274343014, 0.10655377805233, 0.106689304113388, 0.106824912130833, 0.106960602104664, 0.107096433639526, 0.107232302427292, 0.107368297874928, 0.107504338026047, 0.10764042288065, 0.107776671648026, 0.107912965118885, 0.108049400150776, 0.108185850083828, 0.10832241922617, 0.10845909267664, 0.108595795929432, 0.108732610940933, 0.108869522809982, 0.109006486833096, 0.10914358496666, 0.10928075760603, 0.109417982399464, 0.109555326402187, 0.109692759811878, 0.109830245375633, 0.109967812895775, 0.110105536878109, 0.110243238508701, 0.110381111502647, 0.110519036650658, 0.110657073557377, 0.110795147716999, 0.110933363437653, 0.11107163131237, 0.111209988594055, 0.111348457634449, 0.111486956477165, 0.111625581979752, 0.111764274537563, 0.111903078854084, 0.112041927874088, 0.112180918455124, 0.112319938838482, 0.112459070980549, 0.112598270177841, 0.112737543880939, 0.112876906991005, 0.113016426563263, 0.113155946135521, 0.113295659422874, 0.113435328006744, 0.113575160503387, 0.113715067505836, 0.113855063915253, 0.113995127379894, 0.114135280251503, 0.114275522530079, 0.1144158244133, 0.114556230604649, 0.114696741104126, 0.114837341010571, 0.114977978169918, 0.115118741989136, 0.115259572863579, 0.115400493144989, 0.115541502833366, 0.115682646632195, 0.1158237606287, 0.115965090692043, 0.116109669208527, 0.116257101297379, 0.11640453338623, 0.116552017629147, 0.116699554026127, 0.116847068071365, 0.116994693875313, 0.117142349481583, 0.117289967834949, 0.117437660694122, 0.117585435509682, 0.117733165621758, 0.11788097769022, 0.118028834462166, 0.11817666888237, 0.118324592709541, 0.118472576141357, 0.11862051486969, 0.118768535554409, 0.118916608393192, 0.119064711034298, 0.119212791323662, 0.119360983371735, 0.119509167969227, 0.1196573600173, 0.119805656373501, 0.119953952729702, 0.120102278888226, 0.120250649750233, 0.120399065315723, 0.120547503232956, 0.12069596350193, 0.120844483375549, 0.120993033051491, 0.121141597628593, 0.12129021435976, 0.12143886089325, 0.121587559580803, 0.121736280620098, 0.121885046362877, 0.122033827006817, 0.122182667255402, 0.122331544756889, 0.122480414807796, 0.122629337012768, 0.122778303921223, 0.122927308082581, 0.123076364398003, 0.123225465416908, 0.123374529182911, 0.123523689806461, 0.123672880232334, 0.123822085559368, 0.123971320688725, 0.124120585620403, 0.124269939959049, 0.124419271945953, 0.124568656086922, 0.124718107283115, 0.124867580831051, 0.125017076730728, 0.12516662478447, 0.12531615793705, 0.125465780496597, 0.125615388154984, 0.125765070319176, 0.125914812088013, 0.126064538955688, 0.126214325428009, 0.126364141702652, 0.126513972878456, 0.126663878560066, 0.126813814043999, 0.126963749527931, 0.127113729715347, 0.127263754606247, 0.12741382420063, 0.127563893795013, 0.127714052796364, 0.127864226698875, 0.128014415502548, 0.128164678812027, 0.128314942121506, 0.128465205430984, 0.128615573048592, 0.12876595556736, 0.128916352987289, 0.129066839814186, 0.129217341542244, 0.129367828369141, 0.129518374800682, 0.129668995738029, 0.129819601774216, 0.129970252513885, 0.1301209628582, 0.130271703004837, 0.130422458052635, 0.130573272705078, 0.130724102258682, 0.13087497651577, 0.131025865674019, 0.131176814436913, 0.131327793002129, 0.131478816270828, 0.131629854440689, 0.131780952215195, 0.1319320499897, 0.132083237171173, 0.132234424352646, 0.132385656237602, 0.132536932826042, 0.132688209414482, 0.132839545607567, 0.132990911602974, 0.133142307400703, 0.133293733000755, 0.133445203304291, 0.133596733212471, 0.133748278021812, 0.133899822831154, 0.134051457047462, 0.134203091263771, 0.134354770183563, 0.134506508708, 0.134658247232437, 0.134810030460358, 0.134961903095245, 0.135113745927811, 0.13526563346386, 0.135417565703392, 0.135569527745247, 0.135721519589424, 0.135873556137085, 0.136025622487068, 0.136177733540535, 0.136329874396324, 0.136482059955597, 0.136634275317192, 0.136786535382271, 0.136938825249672, 0.137091115117073, 0.13724347949028, 0.137395858764648, 0.1375482827425, 0.137700751423836, 0.137853249907494, 0.138005793094635, 0.138158366084099, 0.138310968875885, 0.138463601469994, 0.138616263866425, 0.138768970966339, 0.138921692967415, 0.139074489474297, 0.139227271080017, 0.139380127191544, 0.139533057808876, 0.139685958623886, 0.139838889241219, 0.139991909265518, 0.140144899487495, 0.140297949314117, 0.140451073646545, 0.140604183077812, 0.140757352113724, 0.140910550951958, 0.141063794493675, 0.141217082738876, 0.141370385885239, 0.141523748636246, 0.14167708158493, 0.141830489039421, 0.141983956098557, 0.142137423157692, 0.142290949821472, 0.142444521188736, 0.142598107457161, 0.142751723527908, 0.142905354499817, 0.143059089779854, 0.143212795257568, 0.143366545438766, 0.143520370125771, 0.143674194812775, 0.143828079104424, 0.143981993198395, 0.144135922193527, 0.144289910793304, 0.144443929195404, 0.144597962498665, 0.144752040505409, 0.144906148314476, 0.145060300827026, 0.14521449804306, 0.145368710160255, 0.145522996783257, 0.145677283406258, 0.145831599831581, 0.145985975861549, 0.146140366792679, 0.146294802427292, 0.146449267864227, 0.146603792905807, 0.146758317947388, 0.146912902593613, 0.147067531943321, 0.14722216129303, 0.147376835346222, 0.147531554102898, 0.147686317563057, 0.147841081023216, 0.147995933890343, 0.148150786757469, 0.148305684328079, 0.14846059679985, 0.148615583777428, 0.148770555853844, 0.148925587534904, 0.14908067882061, 0.149235755205154, 0.149390891194344, 0.149546086788177, 0.149701282382011, 0.14985653758049, 0.150011852383614, 0.150167152285576, 0.150322511792183, 0.150477886199951, 0.150633320212364, 0.150788769125938, 0.150944247841835, 0.151099801063538, 0.151255369186401, 0.151410952210426, 0.151566594839096, 0.151722252368927, 0.151877954602242, 0.15203370153904, 0.15218947827816, 0.152345284819603, 0.152501121163368, 0.152657017111778, 0.152812927961349, 0.152968868613243, 0.153124898672104, 0.153280913829803, 0.153436943888664, 0.153593063354492, 0.153749167919159, 0.15390533208847, 0.154061555862427, 0.154217779636383, 0.154374033212662, 0.154530331492424, 0.15468667447567, 0.154843032360077, 0.15499946475029, 0.155155912041664, 0.1553123742342, 0.15546889603138, 0.155625462532043, 0.155782029032707, 0.155938655138016, 0.156095340847969, 0.156252026557922, 0.156408756971359, 0.156565502285957, 0.156722322106361, 0.156879156827927, 0.157036006450653, 0.157192915678024, 0.157349854707718, 0.157506823539734, 0.157663837075233, 0.157820880413055, 0.1579779535532, 0.15813510119915, 0.158292219042778, 0.158449411392212, 0.158606633543968, 0.158763900399208, 0.158921167254448, 0.159078493714333, 0.159235879778862, 0.159393295645714, 0.159550711512566, 0.159708216786385, 0.159865692257881, 0.160023212432861, 0.160180777311325, 0.160338401794434, 0.160496041178703, 0.160653710365295, 0.160811468958855, 0.16096918284893, 0.161126971244812, 0.161284789443016, 0.161442637443542, 0.161600545048714, 0.161758482456207, 0.161916434764862, 0.162074446678162, 0.162232473492622, 0.162390559911728, 0.162548646330833, 0.162706762552261, 0.162864968180656, 0.163023144006729, 0.163181409239769, 0.163339704275131, 0.163497999310493, 0.163656368851662, 0.16381473839283, 0.16397313773632, 0.164131626486778, 0.164290070533752, 0.164448603987694, 0.164607182145119, 0.164765790104866, 0.164924412965775, 0.165083095431328, 0.16524176299572, 0.165400549769402, 0.1655592918396, 0.165718108415604, 0.165876969695091, 0.16603584587574, 0.166194751858711, 0.166353687644005, 0.166512683033943, 0.166671708226204, 0.166830763220787, 0.166989848017693, 0.167148977518082, 0.167308121919632, 0.167467325925827, 0.167626544833183, 0.167785823345184, 0.167945131659508, 0.168104454874992, 0.168263807892799, 0.168423250317574, 0.168582707643509, 0.168742164969444, 0.168901681900024, 0.169061243534088, 0.169220805168152, 0.169380456209183, 0.169540122151375, 0.169699788093567, 0.169859498739243, 0.170019268989563, 0.170179083943367, 0.170338913798332, 0.170498758554459, 0.17065866291523, 0.170818611979485, 0.170978575944901, 0.171138569712639, 0.171298608183861, 0.171458676457405, 0.171618849039078, 0.171778976917267, 0.171939164400101, 0.172099396586418, 0.172259628772736, 0.172419920563698, 0.172580257058144, 0.172740623354912, 0.172901004552841, 0.173061415553093, 0.173221901059151, 0.17338240146637, 0.17354291677475, 0.173703521490097, 0.173864126205444, 0.174024745821953, 0.174185454845428, 0.174346163868904, 0.174506887793541, 0.174667671322823, 0.174828499555588, 0.174989372491837, 0.175150245428085, 0.175311177968979, 0.175472125411034, 0.175633102655411, 0.175794169306755, 0.175955221056938, 0.176116317510605, 0.176277473568916, 0.176438644528389, 0.176599845290184, 0.176761075854301, 0.176922366023064, 0.177083656191826, 0.177245005965233, 0.177406400442123, 0.177567794919014, 0.177729278802872, 0.177890777587891, 0.178052291274071, 0.178213849663734, 0.178375437855721, 0.178537100553513, 0.178698733448982, 0.178860440850258, 0.179022192955017, 0.179183959960938, 0.179345741868019, 0.179507598280907, 0.179669469594955, 0.179831385612488, 0.179993346333504, 0.18015530705452, 0.180317312479019, 0.180479392409325, 0.180641487240791, 0.180803596973419, 0.180965751409531, 0.181127980351448, 0.181290209293365, 0.181452453136444, 0.181614741683006, 0.181777089834213, 0.181939467787743, 0.182101875543594, 0.182264313101768, 0.182426780462265, 0.182589292526245, 0.182751834392548, 0.182914420962334, 0.18307700753212, 0.183239698410034, 0.183402389287949, 0.183565080165863, 0.183727860450745, 0.183890670537949, 0.184053465723991, 0.184216380119324, 0.184379279613495, 0.184542194008827, 0.184705153107643, 0.184868171811104, 0.185031235218048, 0.185194253921509, 0.18535740673542, 0.18552054464817, 0.185683712363243, 0.185846954584122, 0.186010196805, 0.186173468828201, 0.186336800456047, 0.186500161886215, 0.186663538217545, 0.186826974153519, 0.186990454792976, 0.187153950333595, 0.187317490577698, 0.187481060624123, 0.187644675374031, 0.187808305025101, 0.187972009181976, 0.188135698437691, 0.188299432396889, 0.18846321105957, 0.188627049326897, 0.188790887594223, 0.188954770565033, 0.189118698239326, 0.189282655715942, 0.189446657896042, 0.189610689878464, 0.189774736762047, 0.189938828349113, 0.190102994441986, 0.190267130732536, 0.190431341528893, 0.190595611929893, 0.190759867429733, 0.190924182534218, 0.191088497638702, 0.191252917051315, 0.191417306661606, 0.191581770777702, 0.191746279597282, 0.191910773515701, 0.192075312137604, 0.192239925265312, 0.192404553294182, 0.192569226026535, 0.192733913660049, 0.192898660898209, 0.193063423037529, 0.193228229880333, 0.193393066525459, 0.193557947874069, 0.193722829222679, 0.193887829780579, 0.194052785634995, 0.194218531250954, 0.194384902715683, 0.194551199674606, 0.194717451930046, 0.19488362967968, 0.195049822330475, 0.195215925574303, 0.195381999015808, 0.195548057556152, 0.195714041590691, 0.195879980921745, 0.196045875549316, 0.196211740374565, 0.196377530694008, 0.196543321013451, 0.196709036827087, 0.196874707937241, 0.197040304541588, 0.197205916047096, 0.19737146794796, 0.197536945343018, 0.197702392935753, 0.197867810726166, 0.198033183813095, 0.198198512196541, 0.198363780975342, 0.198528990149498, 0.198694214224815, 0.198859319090843, 0.199024423956871, 0.199189469218254, 0.199354499578476, 0.199519455432892, 0.199684366583824, 0.199849247932434, 0.200014069676399, 0.200178816914558, 0.200343579053879, 0.200508281588554, 0.200672924518585, 0.200837537646294, 0.20100212097168, 0.201166599988937, 0.201331079006195, 0.201495513319969, 0.20165990293026, 0.201824232935905, 0.201988518238068, 0.202152758836746, 0.202316984534264, 0.202481165528297, 0.202645242214203, 0.20280933380127, 0.202973335981369, 0.20313735306263, 0.203301250934601, 0.203465133905411, 0.203629016876221, 0.203792795538902, 0.203956544399261, 0.204120308160782, 0.204283937811852, 0.204447567462921, 0.204611167311668, 0.204774677753448, 0.204938158392906, 0.205101639032364, 0.205265030264854, 0.205428376793861, 0.205591678619385, 0.205754965543747, 0.205918192863464, 0.206081360578537, 0.206244498491287, 0.206407576799393, 0.206570610404015, 0.206733629107475, 0.206896588206291, 0.207059502601624, 0.207222372293472, 0.207385182380676, 0.207547962665558, 0.207710683345795, 0.207873374223709, 0.20803602039814, 0.208198592066765, 0.208361178636551, 0.208523690700531, 0.208686158061028, 0.20884858071804, 0.20901095867157, 0.209173277020454, 0.209335565567017, 0.209497794508934, 0.209659993648529, 0.209822148084641, 0.209984287619591, 0.210146337747574, 0.210308343172073, 0.210470348596573, 0.210632279515266, 0.210794135928154, 0.210955992341042, 0.211117789149284, 0.211279526352882, 0.211441233754158, 0.21160289645195, 0.211764514446259, 0.211926072835922, 0.212087616324425, 0.212249100208282, 0.212410524487495, 0.21257196366787, 0.212733283638954, 0.212894588708878, 0.21305587887764, 0.213217079639435, 0.213378235697746, 0.213539361953735, 0.213700458407402, 0.213861495256424, 0.21402245759964, 0.214183449745178, 0.214344352483749, 0.214505180716515, 0.21466600894928, 0.214826807379723, 0.214987516403198, 0.215148195624352, 0.215308845043182, 0.215469405055046, 0.21562996506691, 0.215790495276451, 0.215950921177864, 0.216111347079277, 0.216271743178368, 0.21643203496933, 0.216592311859131, 0.216752558946609, 0.216912746429443, 0.217072889208794, 0.217233002185822, 0.217393040657043, 0.217553079128265, 0.217713043093681, 0.217872962355614, 0.218032822012901, 0.218192666769028, 0.218352451920509, 0.218512207269669, 0.218671903014183, 0.218831583857536, 0.218991160392761, 0.219150736927986, 0.219310283660889, 0.219469755887985, 0.219629183411598, 0.219788551330566, 0.219947904348373, 0.220107197761536, 0.220266446471214, 0.220425680279732, 0.220584824681282, 0.22074393928051, 0.220903024077415, 0.221062079071999, 0.221221059560776, 0.221379995346069, 0.221538886427879, 0.221697747707367, 0.221856534481049, 0.22201532125473, 0.222174033522606, 0.222332701086998, 0.222491338849068, 0.222649931907654, 0.222808465361595, 0.222966983914375, 0.223125427961349, 0.223283812403679, 0.223442167043686, 0.223600521683693, 0.223758772015572, 0.223917007446289, 0.224075213074684, 0.224233329296112, 0.224391400814056, 0.224549502134323, 0.224707499146461, 0.224865451455116, 0.225023359060287, 0.225181236863136, 0.225339069962502, 0.225496843457222, 0.22565458714962, 0.225812256336212, 0.225969910621643, 0.226127564907074, 0.226285099983215, 0.226442590355873, 0.226600095629692, 0.226757526397705, 0.226914867758751, 0.227072209119797, 0.22722952067852, 0.227386757731438, 0.227543979883194, 0.227701127529144, 0.227858230471611, 0.228015303611755, 0.228172317147255, 0.228329330682755, 0.228486239910126, 0.228643149137497, 0.228799998760223, 0.228956788778305, 0.229113578796387, 0.229270279407501, 0.229426935315132, 0.229583531618118, 0.229740157723427, 0.229896664619446, 0.230053156614304, 0.230209618806839, 0.230365991592407, 0.230522364377975, 0.230678707361221, 0.230834931135178, 0.230991140007973, 0.231147363781929, 0.231303498148918, 0.231459558010101, 0.231615602970123, 0.231771603226662, 0.231927543878555, 0.232083469629288, 0.232239350676537, 0.232395157217979, 0.2325509339571, 0.232706680893898, 0.23286235332489, 0.233018010854721, 0.233173578977585, 0.233329147100449, 0.233484655618668, 0.233640104532242, 0.233795568346977, 0.233950927853584, 0.234106227755547, 0.234261527657509, 0.234416797757149, 0.234571948647499, 0.234727144241333, 0.2348822504282, 0.235037297010422, 0.235192328691483, 0.235347300767899, 0.235502228140831, 0.23565711081028, 0.235811963677406, 0.235966756939888, 0.236121505498886, 0.236276209354401, 0.236430868506432, 0.236585482954979, 0.236740052700043, 0.236894577741623, 0.237049043178558, 0.237203508615494, 0.237357914447784, 0.237512230873108, 0.237666562199593, 0.237820833921432, 0.237975031137466, 0.238129213452339, 0.238283336162567, 0.238437414169312, 0.238591447472572, 0.238745450973511, 0.238899394869804, 0.239053308963776, 0.23920713365078, 0.239360973238945, 0.239514753222466, 0.23966845870018, 0.239822149276733, 0.239975780248642, 0.240129366517067, 0.24028292298317, 0.240436434745789, 0.240589886903763, 0.240743294358253, 0.240896672010422, 0.241049990057945, 0.241203263401985, 0.241356506943703, 0.241509690880775, 0.241662830114365, 0.241815939545631, 0.241968989372253, 0.242121994495392, 0.242274984717369, 0.24242790043354, 0.242580771446228, 0.242733627557755, 0.242886394262314, 0.243039131164551, 0.243191838264465, 0.243344515562057, 0.243497103452682, 0.243649661540985, 0.243802204728127, 0.243954673409462, 0.244107112288475, 0.244259521365166, 0.244411841034889, 0.24456413090229, 0.244716390967369, 0.244868636131287, 0.245020776987076, 0.245172873139381, 0.245324969291687, 0.245477005839348, 0.245628982782364, 0.245780915021896, 0.245932817459106, 0.246084675192833, 0.246236503124237, 0.246388241648674, 0.246539950370789, 0.24669161438942, 0.246843248605728, 0.246994853019714, 0.247146368026733, 0.247297883033752, 0.247449353337288, 0.247600734233856, 0.247752115130424, 0.247903436422348, 0.248054698109627, 0.248205929994583, 0.248357117176056, 0.248508259654045, 0.248659357428551, 0.248810395598412, 0.24896140396595, 0.249112367630005, 0.249263286590576, 0.249414145946503, 0.249564990401268, 0.24971579015255, 0.249866515398026, 0.250017195940018, 0.25016787648201, 0.250318467617035, 0.250469028949738, 0.250619530677795, 0.250770032405853, 0.250920414924622, 0.25107079744339, 0.251221120357513, 0.251371443271637, 0.251521676778793, 0.25167191028595, 0.251822024583817, 0.251972168684006, 0.252122223377228, 0.252272248268127, 0.252422213554382, 0.252572149038315, 0.252722054719925, 0.25287190079689, 0.253021717071533, 0.253171443939209, 0.253321200609207, 0.253470867872238, 0.253620475530624, 0.253770023584366, 0.253919571638107, 0.254069060087204, 0.254218548536301, 0.254367887973785, 0.254517257213593, 0.254666566848755, 0.254815816879272, 0.25496506690979, 0.255114257335663, 0.255263388156891, 0.255412489175797, 0.255561530590057, 0.255710512399673, 0.255859464406967, 0.256008386611938, 0.256157249212265, 0.256306082010269, 0.256454855203629, 0.256603568792343, 0.256752252578735, 0.256900906562805, 0.25704950094223, 0.25719803571701, 0.257346570491791, 0.257495015859604, 0.257643431425095, 0.257791817188263, 0.257940143346786, 0.258088439702988, 0.258236676454544, 0.258384853601456, 0.258533000946045, 0.258681118488312, 0.258829206228256, 0.258977204561234, 0.259125202894211, 0.259273111820221, 0.259420990943909, 0.259568840265274, 0.259716629981995, 0.25986436009407, 0.260012090206146, 0.260159730911255, 0.260307371616364, 0.260454952716827, 0.260602444410324, 0.260749965906143, 0.260897397994995, 0.261044770479202, 0.261192142963409, 0.261339426040649, 0.261486709117889, 0.261633902788162, 0.261781096458435, 0.261928230524063, 0.262075275182724, 0.262222319841385, 0.262369304895401, 0.262516289949417, 0.262663155794144, 0.26281002163887, 0.262956827878952, 0.263103634119034, 0.263250350952148, 0.263397008180618, 0.263543635606766, 0.263690233230591, 0.263836801052094, 0.263983279466629, 0.264129787683487, 0.264276176691055, 0.264422535896301, 0.264568865299225, 0.264715135097504, 0.26486137509346, 0.265007555484772, 0.265153735876083, 0.265299797058105, 0.265445858240128, 0.265591889619827, 0.26573783159256, 0.265883773565292, 0.26602965593338, 0.266175478696823, 0.266321271657944, 0.26646700501442, 0.266612708568573, 0.266758352518082, 0.266903966665268, 0.267049551010132, 0.267195075750351, 0.267340511083603, 0.267485976219177, 0.267631351947784, 0.267776697874069, 0.267921984195709, 0.268067240715027, 0.2682124376297, 0.268357634544373, 0.268502742052078, 0.268647819757462, 0.268792867660522, 0.268937826156616, 0.26908278465271, 0.269227683544159, 0.269372522830963, 0.269517332315445, 0.269662082195282, 0.269806832075119, 0.269951492547989, 0.270096123218536, 0.270240694284439, 0.270385235548019, 0.270529747009277, 0.270674198865891, 0.270818591117859, 0.270962953567505, 0.271107286214828, 0.271251559257507, 0.271395772695541, 0.271539956331253, 0.271684110164642, 0.271825611591339, 0.271964937448502, 0.272104114294052, 0.272243142127991, 0.272382140159607, 0.272520989179611, 0.272659718990326, 0.272798359394073, 0.272936880588531, 0.2730752825737, 0.273213535547256, 0.273351728916168, 0.273489832878113, 0.273627787828445, 0.273765623569489, 0.273903399705887, 0.274040997028351, 0.274178504943848, 0.274315893650055, 0.274453222751617, 0.274590373039246, 0.274727433919907, 0.274864435195923, 0.275001257658005, 0.27513799071312, 0.275274634361267, 0.275411128997803, 0.275547564029694, 0.27568382024765, 0.275820016860962, 0.275956094264984, 0.276092052459717, 0.276227921247482, 0.276363641023636, 0.276499271392822, 0.276634782552719, 0.276770174503326, 0.276905477046967, 0.277040660381317, 0.277175694704056, 0.27731066942215, 0.277445495128632, 0.277580261230469, 0.277714908123016, 0.27784937620163, 0.277983784675598, 0.278118073940277, 0.278252273797989, 0.278386324644089, 0.278520286083221, 0.278654128313065, 0.278787851333618, 0.278921514749527, 0.279055029153824, 0.279188394546509, 0.279321670532227, 0.2794548869133, 0.279587954282761, 0.279720902442932, 0.279853761196136, 0.279986470937729, 0.280119121074677, 0.280251622200012, 0.280384004116058, 0.28051632642746, 0.280648469924927, 0.280780583620071, 0.280912518501282, 0.281044363975525, 0.281176090240479, 0.281307697296143, 0.281439244747162, 0.281570613384247, 0.281701922416687, 0.281833082437515, 0.281964153051376, 0.282095104455948, 0.282225966453552, 0.282356679439545, 0.282487332820892, 0.282617837190628, 0.282748252153397, 0.282878518104553, 0.283008694648743, 0.283138751983643, 0.283268690109253, 0.283398568630219, 0.28352826833725, 0.283657908439636, 0.283787429332733, 0.283916831016541, 0.284046113491058, 0.284175276756287, 0.284304350614548, 0.284433305263519, 0.284562140703201, 0.284690886735916, 0.284819513559341, 0.284947991371155, 0.285076409578323, 0.285204708576202, 0.285332888364792, 0.285460919141769, 0.285588890314102, 0.285716712474823, 0.285844475030899, 0.285972058773041, 0.286099582910538, 0.286226987838745, 0.286354273557663, 0.286481469869614, 0.28660848736763, 0.286735445261002, 0.286862283945084, 0.286989033222198, 0.287115663290024, 0.28724217414856, 0.287368565797806, 0.287494868040085, 0.287621021270752, 0.287747085094452, 0.287873029708862, 0.287998884916306, 0.288124620914459, 0.288250237703323, 0.288375735282898, 0.288501143455505, 0.288626432418823, 0.288751602172852, 0.28887665271759, 0.289001613855362, 0.289126455783844, 0.289251148700714, 0.289375811815262, 0.289500296115875, 0.289624691009521, 0.289748996496201, 0.289873152971268, 0.289997220039368, 0.290121167898178, 0.290244996547699, 0.290368735790253, 0.290492355823517, 0.290615856647491, 0.290739268064499, 0.290862530469894, 0.290985703468323, 0.291108787059784, 0.291231721639633, 0.291354566812515, 0.291477292776108, 0.291599899530411, 0.291722416877747, 0.291844815015793, 0.29196709394455, 0.292089253664017, 0.292211323976517, 0.292333275079727, 0.292455106973648, 0.292576849460602, 0.292698442935944, 0.292819976806641, 0.292941361665726, 0.293062627315521, 0.29318380355835, 0.293304860591888, 0.29342582821846, 0.29354664683342, 0.293667376041412, 0.293787986040115, 0.293908506631851, 0.294028908014297, 0.294149190187454, 0.294269323348999, 0.294389396905899, 0.29450935125351, 0.29462918639183, 0.294748902320862, 0.294868528842926, 0.294988065958023, 0.295107424259186, 0.295226693153381, 0.295345902442932, 0.295464932918549, 0.295583873987198, 0.29570272564888, 0.295821458101273, 0.295940071344376, 0.296058595180511, 0.296176970005035, 0.296295255422592, 0.296413421630859, 0.296531468629837, 0.296649426221848, 0.296767264604568, 0.296884983778, 0.297002583742142, 0.297120094299316, 0.297237485647202, 0.29735478758812, 0.297471940517426, 0.297589004039764, 0.297705918550491, 0.297822773456573, 0.297939509153366, 0.298056125640869, 0.29817259311676, 0.298288971185684, 0.298405259847641, 0.298521429300308, 0.298637509346008, 0.298753470182419, 0.298869282007217, 0.298985004425049, 0.299100607633591, 0.299216121435165, 0.299331516027451, 0.299446791410446, 0.299561947584152, 0.299677014350891, 0.299791932106018, 0.2999067902565, 0.300021529197693, 0.300136119127274, 0.300250649452209, 0.300365000963211, 0.300479292869568, 0.300593465566635, 0.300707519054413, 0.300821483135223, 0.300935298204422, 0.301049023866653, 0.301162600517273, 0.301276117563248, 0.301389515399933, 0.301502794027328, 0.301615953445435, 0.301729023456573, 0.3018419444561, 0.301954805850983, 0.302067518234253, 0.302180141210556, 0.302292615175247, 0.302404999732971, 0.302517294883728, 0.302629470825195, 0.302741497755051, 0.302853435277939, 0.30296528339386, 0.303076982498169, 0.303188621997833, 0.303300112485886, 0.303411513566971, 0.303522795438766, 0.30363392829895, 0.303745001554489, 0.303855925798416, 0.303966790437698, 0.304077506065369, 0.304188102483749, 0.304298579692841, 0.304408997297287, 0.304519265890121, 0.304629415273666, 0.304739475250244, 0.304849416017532, 0.304959237575531, 0.30506893992424, 0.305178582668304, 0.305288076400757, 0.305397480726242, 0.305506736040115, 0.305615901947021, 0.305724948644638, 0.305833876132965, 0.305942684412003, 0.306051433086395, 0.306160032749176, 0.306268513202667, 0.306376934051514, 0.306485176086426, 0.306593358516693, 0.306701421737671, 0.306809335947037, 0.306917190551758, 0.307024896144867, 0.307132512331009, 0.307240009307861, 0.307347387075424, 0.30745467543602, 0.307561814785004, 0.307668894529343, 0.30777582526207, 0.307882636785507, 0.3079893887043, 0.308095961809158, 0.308202475309372, 0.308308869600296, 0.308415114879608, 0.308521270751953, 0.308627337217331, 0.308733284473419, 0.308839112520218, 0.308944821357727, 0.309050410985947, 0.309155941009521, 0.309261322021484, 0.309366583824158, 0.309471726417542, 0.309576809406281, 0.309681713581085, 0.309786558151245, 0.309891283512115, 0.309995889663696, 0.310100346803665, 0.310204744338989, 0.310309022665024, 0.310413181781769, 0.310517221689224, 0.310621172189713, 0.310724973678589, 0.310828685760498, 0.310932278633118, 0.311035811901093, 0.311139196157455, 0.311242491006851, 0.311345607042313, 0.311448663473129, 0.311551600694656, 0.311654448509216, 0.311757147312164, 0.311859726905823, 0.311962246894836, 0.312064617872238, 0.312166899442673, 0.312269061803818, 0.312371104955673, 0.312473028898239, 0.31257489323616, 0.312676578760147, 0.312778174877167, 0.312879681587219, 0.312981069087982, 0.313082337379456, 0.313183486461639, 0.313284546136856, 0.313385456800461, 0.313486278057098, 0.313586980104446, 0.313687592744827, 0.313788115978241, 0.31388846039772, 0.313988775014877, 0.3140889108181, 0.314188987016678, 0.314288914203644, 0.31438872218132, 0.314488410949707, 0.314588010311127, 0.314687520265579, 0.31478688120842, 0.314886182546616, 0.314985334873199, 0.315084397792816, 0.315183311700821, 0.315282106399536, 0.315380841493607, 0.315479427576065, 0.315577924251556, 0.315676331520081, 0.31577455997467, 0.315872728824615, 0.315970778465271, 0.316068708896637, 0.316166549921036, 0.316264241933823, 0.316361874341965, 0.316459327936172, 0.316556721925735, 0.316653966903687, 0.31675112247467, 0.31684821844101, 0.316945135593414, 0.31704193353653, 0.317138642072678, 0.317235231399536, 0.31733176112175, 0.317428082227707, 0.317524403333664, 0.317620545625687, 0.317716598510742, 0.317812502384186, 0.317908346652985, 0.318004041910172, 0.318099647760391, 0.318195104598999, 0.318290501832962, 0.318385779857635, 0.318480968475342, 0.318575978279114, 0.318670898675919, 0.318765729665756, 0.318860471248627, 0.318955063819885, 0.319049537181854, 0.319143891334534, 0.319238156080246, 0.319332331418991, 0.319426387548447, 0.31952029466629, 0.319614112377167, 0.319707840681076, 0.319801449775696, 0.319894850254059, 0.319988280534744, 0.320081532001495, 0.320174723863602, 0.320267766714096, 0.320360660552979, 0.320453464984894, 0.320546209812164, 0.320638805627823, 0.320731312036514, 0.320823669433594, 0.320915937423706, 0.321008056402206, 0.321100115776062, 0.321192026138306, 0.321283847093582, 0.321375578641891, 0.321467161178589, 0.321558654308319, 0.32165002822876, 0.321741312742233, 0.321832478046417, 0.321923464536667, 0.322014421224594, 0.322105228900909, 0.322195917367935, 0.322286546230316, 0.322376996278763, 0.322467386722565, 0.322557687759399, 0.322647780179977, 0.322737872600555, 0.322827756404877, 0.322917580604553, 0.32300728559494, 0.323096930980682, 0.32318639755249, 0.323275744915009, 0.323365032672882, 0.323454171419144, 0.323543190956116, 0.323632150888443, 0.323720932006836, 0.323809653520584, 0.32389822602272, 0.323986738920212, 0.324075132608414, 0.324163347482681, 0.324251532554626, 0.324339538812637, 0.324427485466003, 0.324515283107758, 0.324603021144867, 0.324690610170364, 0.324778079986572, 0.324865490198135, 0.324952691793442, 0.325039863586426, 0.325126886367798, 0.325213849544525, 0.325300633907318, 0.325387388467789, 0.325473994016647, 0.325560450553894, 0.325646817684174, 0.325733065605164, 0.325819194316864, 0.32590526342392, 0.325991183519363, 0.326076954603195, 0.326162695884705, 0.326248288154602, 0.326333791017532, 0.326419144868851, 0.32650437951088, 0.326589554548264, 0.326674580574036, 0.326759487390518, 0.326844304800034, 0.326929003000259, 0.327013611793518, 0.327098101377487, 0.327182471752167, 0.327266693115234, 0.32735088467598, 0.327434897422791, 0.327518820762634, 0.327600240707397, 0.327679246664047, 0.327758073806763, 0.327836811542511, 0.327915400266647, 0.327993810176849, 0.328072100877762, 0.328150302171707, 0.328228265047073, 0.328306138515472, 0.328383892774582, 0.328461468219757, 0.32853889465332, 0.328616261482239, 0.328693389892578, 0.328770458698273, 0.328847318887711, 0.328924059867859, 0.329000651836395, 0.329077154397964, 0.329153478145599, 0.329229652881622, 0.329305708408356, 0.329381614923477, 0.329457402229309, 0.329533010721207, 0.329608470201492, 0.329683870077133, 0.329759061336517, 0.329834163188934, 0.329909056425095, 0.329983860254288, 0.330058455467224, 0.330132961273193, 0.330207377672195, 0.330281555652618, 0.330355674028397, 0.33042961359024, 0.330503404140472, 0.330577105283737, 0.330650597810745, 0.330723971128464, 0.33079719543457, 0.330870300531387, 0.330943256616592, 0.331016093492508, 0.331088781356812, 0.331161320209503, 0.331233739852905, 0.331305950880051, 0.331378102302551, 0.33145010471344, 0.331521928310394, 0.331593632698059, 0.33166515827179, 0.33173656463623, 0.331807851791382, 0.331878989934921, 0.331950008869171, 0.332020848989487, 0.332091569900513, 0.332162141799927, 0.332232564687729, 0.332302898168564, 0.332373023033142, 0.332443058490753, 0.332512974739075, 0.33258268237114, 0.332652240991592, 0.332721710205078, 0.33279100060463, 0.332860171794891, 0.332929223775864, 0.332998096942902, 0.333066880702972, 0.333135455846786, 0.333203941583633, 0.333272308111191, 0.333340466022491, 0.333408534526825, 0.333476424217224, 0.333544164896011, 0.333611816167831, 0.33367931842804, 0.333746671676636, 0.333813905715942, 0.333880931138992, 0.333947896957397, 0.334014683961868, 0.334081321954727, 0.334147840738297, 0.334214180707932, 0.334280431270599, 0.33434647321701, 0.334412455558777, 0.334478229284286, 0.334543913602829, 0.334609478712082, 0.334674805402756, 0.334740042686462, 0.33480516076088, 0.334870100021362, 0.3349349796772, 0.334999650716782, 0.335064202547073, 0.335128545761108, 0.335192829370499, 0.335256993770599, 0.335320919752121, 0.33538481593132, 0.335448503494263, 0.335512071847916, 0.335575461387634, 0.335638791322708, 0.335701942443848, 0.335764914751053, 0.335827738046646, 0.335890501737595, 0.335953027009964, 0.336015492677689, 0.336077779531479, 0.33613994717598, 0.336201936006546, 0.336263865232468, 0.33632555603981, 0.336387187242508, 0.336448669433594, 0.336509972810745, 0.336571097373962, 0.336632162332535, 0.336693078279495, 0.336753815412521, 0.33681446313858, 0.336874902248383, 0.336935192346573, 0.336995452642441, 0.337055504322052, 0.337115406990051, 0.337175160646439, 0.337234795093536, 0.337294280529022, 0.337353676557541, 0.33741283416748, 0.337471932172775, 0.337530851364136, 0.337589651346207, 0.337648302316666, 0.337706834077835, 0.337765157222748, 0.337823420763016, 0.337881475687027, 0.337939471006393, 0.337997227907181, 0.338054925203323, 0.338112443685532, 0.33816984295845, 0.338227063417435, 0.338284224271774, 0.338341146707535, 0.338398009538651, 0.338454693555832, 0.338511198759079, 0.338567614555359, 0.338623881340027, 0.338679999113083, 0.338735997676849, 0.338791817426682, 0.338847517967224, 0.338903099298477, 0.338958531618118, 0.339013814926147, 0.339068949222565, 0.339123994112015, 0.339178800582886, 0.33923351764679, 0.339288115501404, 0.339342564344406, 0.339396864175797, 0.339451014995575, 0.339505076408386, 0.339558899402618, 0.339612632989883, 0.339666247367859, 0.3397196829319, 0.339773058891296, 0.339826196432114, 0.339879274368286, 0.339932143688202, 0.339984923601151, 0.340037524700165, 0.340090036392212, 0.340142339468002, 0.340194582939148, 0.340246587991714, 0.340298503637314, 0.340350300073624, 0.340401917695999, 0.340453445911407, 0.340504765510559, 0.340555965900421, 0.340607076883316, 0.340658009052277, 0.340708792209625, 0.340759426355362, 0.340809971094131, 0.340860307216644, 0.34091055393219, 0.340960651636124, 0.341010600328445, 0.341060429811478, 0.341110050678253, 0.341159611940384, 0.34120899438858, 0.341258257627487, 0.341307371854782, 0.341356307268143, 0.341405153274536, 0.34145388007164, 0.341502398252487, 0.341550827026367, 0.341599076986313, 0.341647177934647, 0.341695189476013, 0.341743022203445, 0.341790765523911, 0.341838300228119, 0.341885715723038, 0.341933012008667, 0.341980159282684, 0.342027187347412, 0.342074036598206, 0.342120736837387, 0.342167347669601, 0.342213779687881, 0.342260122299194, 0.34230625629425, 0.342352271080017, 0.342398166656494, 0.342443883419037, 0.34248948097229, 0.342534959316254, 0.342580258846283, 0.342625468969345, 0.342670500278473, 0.342715382575989, 0.342760175466537, 0.342804789543152, 0.342849254608154, 0.342893600463867, 0.342937797307968, 0.34298187494278, 0.343025773763657, 0.343069523572922, 0.343113213777542, 0.343156695365906, 0.343200027942657, 0.343243271112442, 0.343286335468292, 0.343329250812531, 0.343372076749802, 0.343414723873138, 0.343457221984863, 0.343499600887299, 0.343541860580444, 0.343583911657333, 0.3436259329319, 0.343667715787888, 0.343709409236908, 0.343750923871994, 0.343792319297791, 0.343833595514297, 0.343874663114548, 0.343915641307831, 0.343956500291824, 0.343997180461884, 0.344037771224976, 0.344078153371811, 0.344118386507034, 0.344158530235291, 0.344198524951935, 0.344238370656967, 0.344278126955032, 0.344317644834518, 0.344357073307037, 0.344396352767944, 0.344435513019562, 0.34447455406189, 0.344513386487961, 0.344552129507065, 0.344590693712234, 0.344629138708115, 0.344667464494705, 0.344705611467361, 0.344743639230728, 0.344781547784805, 0.344819307327271, 0.344856858253479, 0.34489431977272, 0.344931662082672, 0.34496882557869, 0.345005929470062, 0.345042794942856, 0.345079571008682, 0.345116227865219, 0.345152676105499, 0.345189034938812, 0.345225244760513, 0.34526127576828, 0.34529721736908, 0.345332950353622, 0.345368623733521, 0.345404118299484, 0.345439463853836, 0.345474660396576, 0.345509797334671, 0.345544695854187, 0.345579504966736, 0.345614194869995, 0.34564870595932, 0.345683068037033, 0.345717310905457, 0.345751404762268, 0.345785349607468, 0.3458192050457, 0.345852851867676, 0.345886379480362, 0.345919787883759, 0.345953047275543, 0.345986187458038, 0.346019119024277, 0.34605199098587, 0.34608468413353, 0.346117198467255, 0.346149623394012, 0.346181869506836, 0.346214056015015, 0.346246033906937, 0.346277862787247, 0.34630960226059, 0.346341162919998, 0.346372574567795, 0.346403867006302, 0.346435040235519, 0.346466034650803, 0.346496909856796, 0.346527606248856, 0.346558213233948, 0.346588671207428, 0.346618980169296, 0.346649169921875, 0.346679180860519, 0.346709072589874, 0.346738815307617, 0.346768438816071, 0.34679788351059, 0.346827238798141, 0.346856385469437, 0.346885472536087, 0.346914380788803, 0.346943140029907, 0.346971750259399, 0.347000241279602, 0.347028583288193, 0.347056776285172, 0.347084850072861, 0.34711280465126, 0.347140580415726, 0.347168207168579, 0.347195684909821, 0.347223103046417, 0.347250282764435, 0.347277373075485, 0.347304314374924, 0.347331136465073, 0.347357779741287, 0.347384303808212, 0.347410678863525, 0.347436904907227, 0.347463011741638, 0.347488969564438, 0.347514778375626, 0.347540467977524, 0.347566038370132, 0.347591400146484, 0.347616672515869, 0.34764176607132, 0.347666800022125, 0.347691625356674, 0.347716301679611, 0.347740828990936, 0.347765266895294, 0.347789585590363, 0.347813695669174, 0.347837656736374, 0.347861528396606, 0.347885221242905, 0.347908794879913, 0.347932279109955, 0.347955524921417, 0.347978681325912, 0.348001688718796, 0.348024547100067, 0.348047316074371, 0.348069906234741, 0.348092377185822, 0.348114639520645, 0.348136812448502, 0.348158866167068, 0.348180741071701, 0.348202526569366, 0.348224103450775, 0.348245620727539, 0.348266929388046, 0.348288148641586, 0.34830915927887, 0.348330080509186, 0.348350822925568, 0.348371475934982, 0.348391950130463, 0.348412305116653, 0.348432511091232, 0.348452568054199, 0.348472476005554, 0.348492294549942, 0.348511934280396, 0.348531424999237, 0.348550796508789, 0.348569989204407, 0.34858912229538, 0.348608076572418, 0.348626852035522, 0.34864553809166, 0.34866401553154, 0.348682403564453, 0.348700642585754, 0.348718762397766, 0.348736733198166, 0.348754554986954, 0.34877222776413, 0.348789751529694, 0.348807156085968, 0.348824441432953, 0.348841577768326, 0.348858565092087, 0.348875373601913, 0.348892122507095, 0.348908603191376, 0.348925054073334, 0.348941326141357, 0.348957449197769, 0.348973482847214, 0.348989337682724, 0.3490050137043, 0.349020600318909, 0.349036067724228, 0.349051356315613, 0.349066525697708, 0.349081516265869, 0.349096387624741, 0.349111139774323, 0.34912571310997, 0.349140197038651, 0.349154502153397, 0.349168688058853, 0.349182695150375, 0.349196583032608, 0.349210351705551, 0.349224001169205, 0.349237471818924, 0.349250793457031, 0.349263966083527, 0.34927698969841, 0.349289923906326, 0.349302679300308, 0.349315315485001, 0.349327802658081, 0.349340200424194, 0.349352389574051, 0.349364429712296, 0.349376380443573, 0.349388182163239, 0.349399834871292, 0.349411308765411, 0.349422693252563, 0.349433898925781, 0.349445015192032, 0.349455952644348, 0.349466770887375, 0.34947744011879, 0.349487960338593, 0.349498331546783, 0.349508553743362, 0.349518686532974, 0.349528640508652, 0.349538445472717, 0.349548161029816, 0.34955769777298, 0.349567085504532, 0.349576383829117, 0.349585473537445, 0.349593013525009, 0.349598854780197, 0.349604547023773, 0.349610060453415, 0.349615484476089, 0.349620759487152, 0.349625885486603, 0.349630892276764, 0.349635720252991, 0.349640429019928, 0.349645018577576, 0.349649429321289, 0.349653750658035, 0.34965792298317, 0.34966191649437, 0.349665820598602, 0.349669575691223, 0.349673211574554, 0.349676698446274, 0.349679946899414, 0.349683195352554, 0.349686235189438, 0.349689096212387, 0.349691897630692, 0.349694550037384, 0.349697053432465, 0.349699407815933, 0.349701642990112, 0.349703729152679, 0.349705696105957, 0.349707424640656, 0.349709123373032, 0.349710673093796, 0.349712044000626, 0.349713295698166, 0.349714398384094, 0.349715381860733, 0.34971621632576, 0.349716901779175, 0.349717408418655, 0.349717885255814, 0.349718123674393, 0.349718332290649, 0.349718302488327, 0.349718183279037, 0.349717885255814, 0.349717497825623, 0.349716931581497, 0.34971621632576, 0.349715381860733, 0.349714428186417, 0.349713325500488, 0.349712044000626, 0.349710673093796, 0.349709153175354, 0.349707514047623, 0.349705725908279, 0.349703788757324, 0.349701672792435, 0.349699467420578, 0.349697142839432, 0.349694639444351, 0.349691987037659, 0.349689215421677, 0.349686294794083, 0.349683284759521, 0.349680095911026, 0.349676758050919, 0.349673271179199, 0.349669694900513, 0.349665939807892, 0.349662065505981, 0.349658071994781, 0.349653899669647, 0.349649578332901, 0.34964519739151, 0.34964057803154, 0.349635899066925, 0.349631041288376, 0.349626034498215, 0.349620908498764, 0.349615663290024, 0.349610209465027, 0.349604696035385, 0.349599033594131, 0.349593192338943, 0.349587261676788, 0.349581152200699, 0.349574893712997, 0.349568516016006, 0.349561989307404, 0.349555373191833, 0.349548608064651, 0.349541634321213, 0.349534600973129, 0.349527418613434, 0.349520057439804, 0.349512577056885, 0.349504917860031, 0.349497199058533, 0.349489241838455, 0.349481225013733, 0.349473059177399, 0.34946471452713, 0.349456280469894, 0.349447697401047, 0.349438935518265, 0.349430084228516, 0.349421054124832, 0.349411934614182, 0.349402636289597, 0.349393218755722, 0.349383652210236, 0.34937396645546, 0.349364101886749, 0.349354118108749, 0.34934401512146, 0.349333763122559, 0.349323391914368, 0.34931281208992, 0.349302142858505, 0.349291354417801, 0.349280387163162, 0.349269300699234, 0.349258065223694, 0.349246710538864, 0.349235206842422, 0.349223583936691, 0.349211812019348, 0.349199831485748, 0.349187791347504, 0.349175602197647, 0.349163264036179, 0.349150776863098, 0.349138230085373, 0.349125415086746, 0.349112540483475, 0.349099546670914, 0.349086374044418, 0.349073052406311, 0.349059611558914, 0.349046021699905, 0.349032312631607, 0.349018454551697, 0.349004447460175, 0.34899029135704, 0.348975986242294, 0.348961591720581, 0.348947077989578, 0.348932385444641, 0.348917543888092, 0.348902553319931, 0.348887413740158, 0.348872184753418, 0.348856836557388, 0.348841309547424, 0.348825603723526, 0.348809808492661, 0.348793894052505, 0.348777800798416, 0.348761588335037, 0.348745256662369, 0.348728746175766, 0.348712086677551, 0.348695307970047, 0.348678410053253, 0.348661363124847, 0.348644196987152, 0.348626852035522, 0.348609358072281, 0.348591804504395, 0.348574042320251, 0.348556131124496, 0.348538130521774, 0.34851998090744, 0.348501682281494, 0.348483234643936, 0.348464697599411, 0.348445922136307, 0.34842711687088, 0.348408102989197, 0.348388999700546, 0.348369717597961, 0.348350316286087, 0.348330765962601, 0.348311096429825, 0.348291248083115, 0.348271280527115, 0.348251223564148, 0.348230957984924, 0.348210602998734, 0.348190069198608, 0.348169445991516, 0.34814864397049, 0.348127692937851, 0.348106622695923, 0.348085433244705, 0.348064064979553, 0.348042577505112, 0.348020911216736, 0.347999185323715, 0.347977310419083, 0.347955256700516, 0.347933113574982, 0.347910791635513, 0.347888290882111, 0.347865730524063, 0.347842991352081, 0.34782013297081, 0.347797065973282, 0.347773969173431, 0.347750663757324, 0.347727239131927, 0.347703665494919, 0.347679972648621, 0.347656100988388, 0.347632139921188, 0.347608029842377, 0.347583770751953, 0.347559362649918, 0.347534835338593, 0.347510159015656, 0.347485333681107, 0.34746041893959, 0.347435295581818, 0.347410082817078, 0.347384721040726, 0.347359210252762, 0.347333550453186, 0.347307771444321, 0.347281843423843, 0.347255796194077, 0.347229599952698, 0.347203254699707, 0.347176760435104, 0.347150206565857, 0.347123384475708, 0.347096532583237, 0.347069501876831, 0.347042322158813, 0.347014993429184, 0.346987575292587, 0.346959948539734, 0.346932291984558, 0.346904397010803, 0.346876412630081, 0.346848249435425, 0.346819967031479, 0.346791595220566, 0.346763014793396, 0.346734285354614, 0.346705466508865, 0.346676528453827, 0.346647411584854, 0.346618145704269, 0.346588760614395, 0.346559256315231, 0.346529573202133, 0.346499770879745, 0.346469849348068, 0.346439719200134, 0.346409529447556, 0.346379160881042, 0.346348643302917, 0.346318036317825, 0.346287250518799, 0.346256375312805, 0.3462253510952, 0.346194118261337, 0.346162766218185, 0.346131324768066, 0.346099704504013, 0.34606796503067, 0.346036076545715, 0.346004068851471, 0.345971912145615, 0.345939606428146, 0.345907151699066, 0.345874607563019, 0.345841854810715, 0.345809012651443, 0.345776051282883, 0.345742881298065, 0.345709651708603, 0.345676213502884, 0.345642685890198, 0.3456090092659, 0.345575153827667, 0.345541208982468, 0.345507085323334, 0.34547284245491, 0.345438480377197, 0.345403969287872, 0.345369279384613, 0.345334500074387, 0.345299571752548, 0.34526452422142, 0.34522932767868, 0.345193952322006, 0.345158457756042, 0.345122814178467, 0.345087081193924, 0.345051199197769, 0.345015108585358, 0.344978958368301, 0.344942629337311, 0.344906181097031, 0.344869583845139, 0.344832867383957, 0.344796001911163, 0.344758987426758, 0.344721794128418, 0.344684511423111, 0.344647079706192, 0.344609528779984, 0.344571828842163, 0.344533979892731, 0.344495981931686, 0.344457864761353, 0.344419598579407, 0.344381213188171, 0.344342678785324, 0.344303995370865, 0.344265222549438, 0.344226270914078, 0.34418711066246, 0.344147920608521, 0.344108551740646, 0.34406903386116, 0.344029396772385, 0.343989610671997, 0.343949675559998, 0.343909591436386, 0.34386944770813, 0.343829125165939, 0.343788623809814, 0.343747973442078, 0.343707233667374, 0.34366637468338, 0.343625336885452, 0.343584150075912, 0.343542814254761, 0.343501418828964, 0.343459814786911, 0.343418061733246, 0.343376189470291, 0.343334168195724, 0.343292027711868, 0.343249768018723, 0.343207389116287, 0.343164771795273, 0.343122094869614, 0.343079298734665, 0.343036293983459, 0.342993170022964, 0.34294992685318, 0.342906534671783, 0.342863023281097, 0.342819333076477, 0.342775583267212, 0.342731595039368, 0.342687517404556, 0.342643320560455, 0.34259894490242, 0.342554450035095, 0.342509806156158, 0.342465043067932, 0.342420101165771, 0.342375040054321, 0.342329859733582, 0.342284560203552, 0.342239081859589, 0.342193484306335, 0.342147707939148, 0.342101812362671, 0.342055797576904, 0.342009693384171, 0.341963350772858, 0.341916918754578, 0.341870367527008, 0.341823607683182, 0.341776758432388, 0.341729789972305, 0.341682642698288, 0.341635346412659, 0.341587960720062, 0.341540396213531, 0.341492712497711, 0.341444909572601, 0.34139695763588, 0.341348797082901, 0.341300576925278, 0.341252207756042, 0.341203689575195, 0.341155022382736, 0.34110626578331, 0.341057270765305, 0.341008216142654, 0.340959012508392, 0.340909659862518, 0.340860158205032, 0.340810567140579, 0.340760827064514, 0.34071084856987, 0.340660810470581, 0.340610682964325, 0.340560376644135, 0.340509861707687, 0.340459316968918, 0.340408533811569, 0.340357631444931, 0.340306639671326, 0.340255498886108, 0.340204209089279, 0.340152770280838, 0.34010124206543, 0.340049535036087, 0.339997678995132, 0.339945673942566, 0.339893579483032, 0.339841306209564, 0.339788883924484, 0.339736342430115, 0.339683681726456, 0.339630842208862, 0.339577883481979, 0.339524835348129, 0.3394715487957, 0.339418232440948, 0.33936470746994, 0.33931103348732, 0.339257299900055, 0.339203327894211, 0.3391492664814, 0.339095056056976, 0.339040756225586, 0.338986247777939, 0.338931620121002, 0.338876903057098, 0.33882200717926, 0.338766932487488, 0.338711798191071, 0.338656455278397, 0.338601022958755, 0.338545441627502, 0.338489681482315, 0.338433831930161, 0.338377863168716, 0.338321685791016, 0.338265419006348, 0.338208973407745, 0.338152408599854, 0.338095724582672, 0.338038891553879, 0.337981939315796, 0.337924778461456, 0.337867558002472, 0.337810158729553, 0.337752640247345, 0.337694942951202, 0.337637156248093, 0.337579190731049, 0.337521135807037, 0.337462931871414, 0.337404549121857, 0.33734604716301, 0.337287396192551, 0.337228626012802, 0.337169736623764, 0.337110668420792, 0.33705148100853, 0.336992114782333, 0.33693265914917, 0.336873054504395, 0.33681333065033, 0.33675342798233, 0.336693406105042, 0.336633235216141, 0.336572974920273, 0.336512476205826, 0.336451917886734, 0.33639121055603, 0.336330324411392, 0.336269319057465, 0.33620822429657, 0.336146950721741, 0.3360855281353, 0.336023956537247, 0.335962265729904, 0.335900485515594, 0.335838496685028, 0.335776388645172, 0.335714131593704, 0.335651785135269, 0.335589200258255, 0.335526615381241, 0.335463792085648, 0.335400849580765, 0.335337787866592, 0.335274577140808, 0.335209459066391, 0.335142344236374, 0.335075199604034, 0.335007876157761, 0.33494046330452, 0.334872990846634, 0.334805339574814, 0.334737598896027, 0.33466973900795, 0.334601819515228, 0.334533721208572, 0.334465563297272, 0.334397286176682, 0.334328830242157, 0.334260314702988, 0.334191739559174, 0.334123015403748, 0.33405414223671, 0.333985209465027, 0.333916157484055, 0.333846986293793, 0.333777725696564, 0.333708316087723, 0.333638817071915, 0.333569169044495, 0.333499431610107, 0.333429634571075, 0.333359688520432, 0.33328965306282, 0.333219468593597, 0.333149164915085, 0.333078771829605, 0.333008289337158, 0.332937687635422, 0.332866996526718, 0.332796156406403, 0.332725197076797, 0.332654148340225, 0.332582980394363, 0.332511723041534, 0.332440316677094, 0.332368850708008, 0.33229723572731, 0.332225531339645, 0.332153737545013, 0.33208179473877, 0.332009732723236, 0.331937581300735, 0.331865310668945, 0.331792950630188, 0.331720471382141, 0.331647872924805, 0.331575155258179, 0.331502318382263, 0.331429421901703, 0.331356376409531, 0.331283241510391, 0.33120995759964, 0.331136614084244, 0.331063151359558, 0.330989509820938, 0.330915868282318, 0.330842047929764, 0.330768078565598, 0.330694049596786, 0.330619931221008, 0.330545663833618, 0.330471307039261, 0.330396860837936, 0.330322265625, 0.330247551202774, 0.330172777175903, 0.330097854137421, 0.330022841691971, 0.329947710037231, 0.329872459173203, 0.329797118902206, 0.329721659421921, 0.329646021127701, 0.329570353031158, 0.329494535923004, 0.329418659210205, 0.329342603683472, 0.329266518354416, 0.329190254211426, 0.329113930463791, 0.329037457704544, 0.328960925340652, 0.328884154558182, 0.328807383775711, 0.328730523586273, 0.328653484582901, 0.328576356172562, 0.328499138355255, 0.328421801328659, 0.328344315290451, 0.328266799449921, 0.328189134597778, 0.328111320734024, 0.328033417463303, 0.327955394983292, 0.327877312898636, 0.327799081802368, 0.327720731496811, 0.327642261981964, 0.327563762664795, 0.327485054731369, 0.327406287193298, 0.327327400445938, 0.327248364686966, 0.327169269323349, 0.327090054750443, 0.327010750770569, 0.326931267976761, 0.326851695775986, 0.326772063970566, 0.326692312955856, 0.326612412929535, 0.326532423496246, 0.326452285051346, 0.326372087001801, 0.326291739940643, 0.326211333274841, 0.326130777597427, 0.326050132513046, 0.325969398021698, 0.325888484716415, 0.325807482004166, 0.325726389884949, 0.325645178556442, 0.325563848018646, 0.325482428073883, 0.32540088891983, 0.32531926035881, 0.325237482786179, 0.32515561580658, 0.325073629617691, 0.324991524219513, 0.324909329414368, 0.324827045202255, 0.324744582176208, 0.324662089347839, 0.324579417705536, 0.324496656656265, 0.324413776397705, 0.324330806732178, 0.324247747659683, 0.324164569377899, 0.324081212282181, 0.323997795581818, 0.323914289474487, 0.323830634355545, 0.323746919631958, 0.323663026094437, 0.323579072952271, 0.323494970798492, 0.323410779237747, 0.323326498270035, 0.323242098093033, 0.323157578706741, 0.32307294011116, 0.32298818230629, 0.322903364896774, 0.322818338871002, 0.322733283042908, 0.322648078203201, 0.322562843561172, 0.322477430105209, 0.322391897439957, 0.322306245565414, 0.322220534086227, 0.322134673595428, 0.322048753499985, 0.321962684392929, 0.321876466274261, 0.321790188550949, 0.321703761816025, 0.321617275476456, 0.321530640125275, 0.321443885564804, 0.321357071399689, 0.321270108222961, 0.321183085441589, 0.321095883846283, 0.321008592844009, 0.320921242237091, 0.320833712816238, 0.320746093988419, 0.320658385753632, 0.32057049870491, 0.320482581853867, 0.320394486188889, 0.320306390523911, 0.320218116044998, 0.320129692554474, 0.320041209459305, 0.319952636957169, 0.31986391544342, 0.319775074720383, 0.319686114788055, 0.319597035646439, 0.319507867097855, 0.319418609142303, 0.319329261779785, 0.319239735603333, 0.319150179624557, 0.319060474634171, 0.318970620632172, 0.318880677223206, 0.318790674209595, 0.31870049238205, 0.318610191345215, 0.318519830703735, 0.318429380655289, 0.318338811397552, 0.318248063325882, 0.318157225847244, 0.318066298961639, 0.317975282669067, 0.317884117364883, 0.317792862653732, 0.317701488733292, 0.317609995603561, 0.317518442869186, 0.317426741123199, 0.317334920167923, 0.317243009805679, 0.317150980234146, 0.317058831453323, 0.316966563463211, 0.316874206066132, 0.316781759262085, 0.316689133644104, 0.316596448421478, 0.316503643989563, 0.316410720348358, 0.316317677497864, 0.316224575042725, 0.316131323575974, 0.316037982702255, 0.315944522619247, 0.315850913524628, 0.315757244825363, 0.315663427114487, 0.315569519996643, 0.31547549366951, 0.31538137793541, 0.31528714299202, 0.31519278883934, 0.315098315477371, 0.315003752708435, 0.314909100532532, 0.314814269542694, 0.314719378948212, 0.31462436914444, 0.314529240131378, 0.314434021711349, 0.314338684082031, 0.314243227243423, 0.314147651195526, 0.314051955938339, 0.313956171274185, 0.313860267400742, 0.313764274120331, 0.313668191432953, 0.313571929931641, 0.313475579023361, 0.313379138708115, 0.313282579183578, 0.313185900449753, 0.31308913230896, 0.312992244958878, 0.312895208597183, 0.312798112630844, 0.312700897455215, 0.312603563070297, 0.312506109476089, 0.312408596277237, 0.31231090426445, 0.312213152647018, 0.312115252017975, 0.312017261981964, 0.311919152736664, 0.311820954084396, 0.311722606420517, 0.31162416934967, 0.311525613069534, 0.311426967382431, 0.311328202486038, 0.311229318380356, 0.311130315065384, 0.311031222343445, 0.310932040214539, 0.31083270907402, 0.310733258724213, 0.310633718967438, 0.310534089803696, 0.310434341430664, 0.310334444046021, 0.31023445725441, 0.31013435125351, 0.310034155845642, 0.309933841228485, 0.309833437204361, 0.309732884168625, 0.309632241725922, 0.309531480073929, 0.309430629014969, 0.309329628944397, 0.30922856926918, 0.309127360582352, 0.309026032686234, 0.308924615383148, 0.308823108673096, 0.308721482753754, 0.3086197078228, 0.308517873287201, 0.30841588973999, 0.308313816785812, 0.308211624622345, 0.308109313249588, 0.308006912469864, 0.307904362678528, 0.307801723480225, 0.307698994874954, 0.307596147060394, 0.307493150234222, 0.307390093803406, 0.3072869181633, 0.307183623313904, 0.307080209255219, 0.306976705789566, 0.306873083114624, 0.306769341230392, 0.306665480136871, 0.306561529636383, 0.306457459926605, 0.306353271007538, 0.306248962879181, 0.306144595146179, 0.306040078401566, 0.305935442447662, 0.305830717086792, 0.305725872516632, 0.305620908737183, 0.305515855550766, 0.305410712957382, 0.305305391550064, 0.305200010538101, 0.305094540119171, 0.304988890886307, 0.304883152246475, 0.304777324199677, 0.304671376943588, 0.304565340280533, 0.304459154605865, 0.304352879524231, 0.304246485233307, 0.304140001535416, 0.304033398628235, 0.303926676511765, 0.303819835186005, 0.303712904453278, 0.303605854511261, 0.303498685359955, 0.303391396999359, 0.303284019231796, 0.303176522254944, 0.303068906068802, 0.302961230278015, 0.302853405475616, 0.302745431661606, 0.302637428045273, 0.302529245615005, 0.302421003580093, 0.302312612533569, 0.302204132080078, 0.302095502614975, 0.301986813545227, 0.30187800526619, 0.301769077777863, 0.301660031080246, 0.301550894975662, 0.301441639661789, 0.301332265138626, 0.301222771406174, 0.301113188266754, 0.301003485918045, 0.300893694162369, 0.300783753395081, 0.300673723220825, 0.30056357383728, 0.300453305244446, 0.300342977046967, 0.300232499837875, 0.300121903419495, 0.300011217594147, 0.299900412559509, 0.299789488315582, 0.299678474664688, 0.299567341804504, 0.299456089735031, 0.299344718456268, 0.299233227968216, 0.299121648073196, 0.29900997877121, 0.298898190259933, 0.298786282539368, 0.298674255609512, 0.298562109470367, 0.298449903726578, 0.298337519168854, 0.298225045204163, 0.298112481832504, 0.297999799251556, 0.297886997461319, 0.297774106264114, 0.29766109585762, 0.297547966241837, 0.297434747219086, 0.297321379184723, 0.297207921743393, 0.297094374895096, 0.296980679035187, 0.296866923570633, 0.296753019094467, 0.296638965606689, 0.296524882316589, 0.296410650014877, 0.296296328306198, 0.296181857585907, 0.296067297458649, 0.295952618122101, 0.295837879180908, 0.295722961425781, 0.29560798406601, 0.295492827892303, 0.295377612113953, 0.295262277126312, 0.295146852731705, 0.295031309127808, 0.294915616512299, 0.294799864292145, 0.294683963060379, 0.294567972421646, 0.294451862573624, 0.294335633516312, 0.294219344854355, 0.294102877378464, 0.293986350297928, 0.29386967420578, 0.293752938508987, 0.29363602399826, 0.293519049882889, 0.293401926755905, 0.293284714221954, 0.293167412281036, 0.293049991130829, 0.292932420969009, 0.292814791202545, 0.292697012424469, 0.292579114437103, 0.292461186647415, 0.29234305024147, 0.292224884033203, 0.292106539011002, 0.291988104581833, 0.291869610548019, 0.291750937700272, 0.291632175445557, 0.291513293981552, 0.291394352912903, 0.291275262832642, 0.291156053543091, 0.291036754846573, 0.290917307138443, 0.290797799825668, 0.290678143501282, 0.290558397769928, 0.290438532829285, 0.290318578481674, 0.290198475122452, 0.290078312158585, 0.289958000183105, 0.289837568998337, 0.289717078208923, 0.289596408605576, 0.289475649595261, 0.289354830980301, 0.289233833551407, 0.289112776517868, 0.288991570472717, 0.288870275020599, 0.288748890161514, 0.28862738609314, 0.288505733013153, 0.288383990526199, 0.288262158632278, 0.288140177726746, 0.288018107414246, 0.28789433836937, 0.287769138813019, 0.287643849849701, 0.287518471479416, 0.287393093109131, 0.287267595529556, 0.287142097949982, 0.287016540765762, 0.286890894174576, 0.286765217781067, 0.286639451980591, 0.286513686180115, 0.286387830972672, 0.286261916160583, 0.286135941743851, 0.286009907722473, 0.285883843898773, 0.285757720470428, 0.285631537437439, 0.285505294799805, 0.285378992557526, 0.285252630710602, 0.285126239061356, 0.284999758005142, 0.284873247146606, 0.284746646881104, 0.284620016813278, 0.284493327140808, 0.284366607666016, 0.284239798784256, 0.284112930297852, 0.283986002206802, 0.283859074115753, 0.283732026815414, 0.283604979515076, 0.283477813005447, 0.283350616693497, 0.283223360776901, 0.283096045255661, 0.282968729734421, 0.282841295003891, 0.282713830471039, 0.282586306333542, 0.2824587225914, 0.282331079244614, 0.282203376293182, 0.282075613737106, 0.281947821378708, 0.281819969415665, 0.281692028045654, 0.281564086675644, 0.281436055898666, 0.281307995319366, 0.281179845333099, 0.281051635742188, 0.280923396348953, 0.280795067548752, 0.28066673874855, 0.280538290739059, 0.280409842729568, 0.280281275510788, 0.280152708292007, 0.28002405166626, 0.27989536523819, 0.279766589403152, 0.279637813568115, 0.279508918523788, 0.279380023479462, 0.279251039028168, 0.279121994972229, 0.278992921113968, 0.278863787651062, 0.278734564781189, 0.278605312108994, 0.278475999832153, 0.278346627950668, 0.278217226266861, 0.278087735176086, 0.27795821428299, 0.277828603982925, 0.277698963880539, 0.27756929397583, 0.277439504861832, 0.277309685945511, 0.277179837226868, 0.277049899101257, 0.276919931173325, 0.276789873838425, 0.276659786701202, 0.276529669761658, 0.276399463415146, 0.276269197463989, 0.276138871908188, 0.276008516550064, 0.275878071784973, 0.275747567415237, 0.275617033243179, 0.275486469268799, 0.275355815887451, 0.275225102901459, 0.275094330310822, 0.274963527917862, 0.274832665920258, 0.274701714515686, 0.274570733308792, 0.274439692497253, 0.27430859208107, 0.274177461862564, 0.274046242237091, 0.273914963006973, 0.273783653974533, 0.273652285337448, 0.273520857095718, 0.273389369249344, 0.273257821798325, 0.273126214742661, 0.272994577884674, 0.27286285161972, 0.272731095552444, 0.272599279880524, 0.272467404603958, 0.272335469722748, 0.272203475236893, 0.272071421146393, 0.271939337253571, 0.271807193756104, 0.271674960851669, 0.271542727947235, 0.271410375833511, 0.271277993917465, 0.271145552396774, 0.271013051271439, 0.270880520343781, 0.270747929811478, 0.27061527967453, 0.270482569932938, 0.270349770784378, 0.270216941833496, 0.270084083080292, 0.26995113492012, 0.269818127155304, 0.269685089588165, 0.269551992416382, 0.269418835639954, 0.269285619258881, 0.269152343273163, 0.2690190076828, 0.268885642290115, 0.268752187490463, 0.268618702888489, 0.268485128879547, 0.268351554870605, 0.268217861652374, 0.268084168434143, 0.267950385808945, 0.267816543579102, 0.267682671546936, 0.267548739910126, 0.267414718866348, 0.267280668020248, 0.267146557569504, 0.267012417316437, 0.26687815785408, 0.266743928194046, 0.266609579324722, 0.266475200653076, 0.266340792179108, 0.26620626449585, 0.266071707010269, 0.265937089920044, 0.265802413225174, 0.265667706727982, 0.265532910823822, 0.26539808511734, 0.265263199806213, 0.265128254890442, 0.264993250370026, 0.264858186244965, 0.264723062515259, 0.264587938785553, 0.264452695846558, 0.264317393302917, 0.264182090759277, 0.26404669880867, 0.263911247253418, 0.263775736093521, 0.263640165328979, 0.263504564762115, 0.263368874788284, 0.263233155012131, 0.263097375631332, 0.262961536645889, 0.262825667858124, 0.262689709663391, 0.262553691864014, 0.262417644262314, 0.262281507253647, 0.262145340442657, 0.262009114027023, 0.261872828006744, 0.261736512184143, 0.261600106954575, 0.261463671922684, 0.261327147483826, 0.261190593242645, 0.261053949594498, 0.26091730594635, 0.260780543088913, 0.260643780231476, 0.260506927967072, 0.260370045900345, 0.260233074426651, 0.260096073150635, 0.259959012269974, 0.259821891784668, 0.259684711694717, 0.259547472000122, 0.259410172700882, 0.259272843599319, 0.259135454893112, 0.25899800658226, 0.258860468864441, 0.258722901344299, 0.258585304021835, 0.258447617292404, 0.258309870958328, 0.25817209482193, 0.258034229278564, 0.257896333932877, 0.257758378982544, 0.257620364427567, 0.257482290267944, 0.257344186306, 0.257205992937088, 0.257067739963531, 0.256929486989975, 0.256791144609451, 0.25665271282196, 0.256514251232147, 0.256375759840012, 0.256237149238586, 0.256098538637161, 0.255959868431091, 0.255821108818054, 0.255682319402695, 0.25554347038269, 0.255404591560364, 0.25526562333107, 0.255126595497131, 0.254987508058548, 0.254848420619965, 0.254709213972092, 0.254569977521896, 0.254430681467056, 0.254291355609894, 0.254151910543442, 0.25401246547699, 0.253872931003571, 0.253733366727829, 0.253593742847443, 0.253454059362411, 0.253314316272736, 0.253174513578415, 0.253034651279449, 0.252894729375839, 0.252754777669907, 0.252614736557007, 0.252474695444107, 0.252334535121918, 0.252194374799728, 0.25205409526825, 0.251913815736771, 0.251773446798325, 0.251633048057556, 0.251492559909821, 0.251352071762085, 0.25121146440506, 0.251070857048035, 0.250930160284042, 0.250789403915405, 0.250648587942123, 0.250507742166519, 0.25036683678627, 0.250225871801376, 0.250084847211838, 0.249943763017654, 0.249802619218826, 0.249661430716515, 0.249520167708397, 0.249378874897957, 0.24923749268055, 0.249096110463142, 0.248954638838768, 0.248813092708588, 0.248671501874924, 0.248529866337776, 0.248388186097145, 0.248246431350708, 0.248104631900787, 0.247962757945061, 0.247820839285851, 0.247678875923157, 0.247536838054657, 0.247394770383835, 0.247252613306046, 0.247110411524773, 0.246968165040016, 0.246825858950615, 0.24668350815773, 0.246541082859039, 0.246398612856865, 0.246256068348885, 0.246113479137421, 0.245970845222473, 0.245828151702881, 0.245685383677483, 0.245542570948601, 0.245399713516235, 0.245256781578064, 0.245113804936409, 0.244970768690109, 0.244827687740326, 0.244684532284737, 0.244541332125664, 0.244398102164268, 0.244254752993584, 0.24411141872406, 0.243967995047569, 0.243824496865273, 0.243680968880653, 0.243537396192551, 0.243393734097481, 0.243250027298927, 0.24310627579689, 0.242962434887886, 0.242818579077721, 0.24267466366291, 0.242530673742294, 0.242386639118195, 0.24224254488945, 0.2420983761549, 0.241954192519188, 0.241809949278831, 0.241665616631508, 0.241521254181862, 0.24137681722641, 0.241232335567474, 0.241087794303894, 0.240943193435669, 0.240798562765121, 0.240653827786446, 0.240509077906609, 0.240364268422127, 0.240219384431839, 0.240074470639229, 0.239929467439651, 0.239784449338913, 0.239639326930046, 0.239494189620018, 0.239348962903023, 0.239203691482544, 0.239058390259743, 0.238913014531136, 0.238767579197884, 0.238622099161148, 0.238476574420929, 0.238330945372581, 0.238185286521912, 0.238039582967758, 0.23789381980896, 0.237747967243195, 0.237602114677429, 0.237456172704697, 0.237310186028481, 0.23716413974762, 0.237018048763275, 0.236871868371964, 0.236725687980652, 0.236579433083534, 0.236433058977127, 0.23628668487072, 0.23614028096199, 0.235993802547455, 0.235847234725952, 0.235700622200966, 0.235553964972496, 0.235407248139381, 0.235260471701622, 0.23511366546154, 0.234966740012169, 0.23481984436512, 0.234672859311104, 0.234525769948959, 0.234378680586815, 0.234231516718864, 0.23408430814743, 0.233937039971352, 0.233789697289467, 0.23364232480526, 0.233494877815247, 0.23334738612175, 0.23319984972477, 0.233052223920822, 0.232904568314552, 0.232756838202477, 0.232609063386917, 0.232461228966713, 0.232313364744186, 0.232165411114693, 0.232017412781715, 0.231869369745255, 0.231721252202988, 0.231573075056076, 0.23142483830452, 0.231276601552963, 0.231128245592117, 0.230979844927788, 0.230831414461136, 0.230682924389839, 0.230534359812737, 0.23038575053215, 0.230237111449242, 0.230088353157043, 0.229939594864845, 0.229790732264519, 0.229641854763031, 0.229492917656898, 0.229343920946121, 0.229194834828377, 0.229045748710632, 0.228896573185921, 0.228747367858887, 0.228598073124886, 0.228448748588562, 0.228299349546432, 0.228149875998497, 0.2280003875494, 0.227850809693336, 0.22770120203495, 0.227551519870758, 0.227401822805405, 0.227252006530762, 0.227102190256119, 0.22695229947567, 0.226802334189415, 0.226652324199677, 0.226502284407616, 0.226352170109749, 0.226201981306076, 0.22605174779892, 0.22590146958828, 0.225751131772995, 0.225600749254227, 0.225450292229652, 0.225299760699272, 0.225149214267731, 0.224998593330383, 0.224847927689552, 0.224697157740593, 0.224546402692795, 0.224395558238029, 0.224244654178619, 0.224093705415726, 0.223942711949348, 0.223791614174843, 0.223640501499176, 0.223489329218864, 0.223338067531586, 0.223186805844307, 0.223035469651222, 0.222884073853493, 0.222732603549957, 0.222581088542938, 0.222429528832436, 0.222277894616127, 0.222126230597496, 0.22197450697422, 0.221822693943977, 0.221670866012573, 0.221518948674202, 0.221366971731186, 0.221214979887009, 0.221062913537025, 0.220910787582397, 0.220758602023125, 0.220606341958046, 0.220454066991806, 0.22030171751976, 0.220149308443069, 0.219996869564056, 0.219844326376915, 0.219691768288612, 0.219539135694504, 0.21938644349575, 0.219233706593513, 0.219080924987793, 0.218928083777428, 0.218775168061256, 0.21862219274044, 0.218469187617302, 0.218315914273262, 0.218162715435028, 0.218009531497955, 0.217856347560883, 0.21770316362381, 0.217550009489059, 0.21739687025547, 0.21724371612072, 0.217090606689453, 0.216937482357025, 0.21678438782692, 0.216631323099136, 0.216478228569031, 0.216325148940086, 0.216172114014626, 0.216019079089165, 0.215866014361382, 0.215712994337082, 0.215560019016266, 0.215407028794289, 0.21525402367115, 0.215101048350334, 0.214948073029518, 0.214795127511024, 0.214642181992531, 0.214489281177521, 0.214336320757866, 0.214183449745178, 0.214030563831329, 0.213877648115158, 0.21372477710247, 0.213571950793266, 0.21341909468174, 0.213266238570213, 0.21311342716217, 0.212960615754128, 0.212807804346085, 0.212655007839203, 0.212502241134644, 0.212349474430084, 0.212196707725525, 0.212043970823288, 0.211891233921051, 0.211738482117653, 0.211585804820061, 0.211433097720146, 0.211280405521393, 0.211127728223801, 0.210975050926208, 0.210822403430939, 0.21066977083683, 0.210517138242722, 0.210364520549774, 0.210211902856827, 0.210059314966202, 0.209906712174416, 0.209754139184952, 0.209601581096649, 0.20944906771183, 0.209296509623528, 0.209143966436386, 0.208991467952728, 0.208838954567909, 0.208686456084251, 0.208533972501755, 0.208381488919258, 0.208229050040245, 0.208076596260071, 0.207924157381058, 0.207771718502045, 0.207619339227676, 0.207466930150986, 0.207314535975456, 0.207162171602249, 0.207009792327881, 0.206857442855835, 0.206705093383789, 0.206552758812904, 0.20640042424202, 0.206248119473457, 0.206095844507217, 0.205943524837494, 0.205791249871254, 0.205639019608498, 0.205486744642258, 0.20533449947834, 0.205182269215584, 0.20503006875515, 0.204877823591232, 0.204725667834282, 0.204573467373848, 0.204421281814575, 0.204269126057625, 0.204116970300674, 0.203964829444885, 0.203812688589096, 0.203660607337952, 0.203508496284485, 0.203356400132179, 0.203204303979874, 0.20305223762989, 0.202900171279907, 0.202748119831085, 0.202596113085747, 0.202444061636925, 0.202292054891586, 0.20214007794857, 0.201988071203232, 0.201836094260216, 0.201684132218361, 0.201532185077667, 0.201380223035812, 0.201228305697441, 0.201076373457909, 0.200924456119537, 0.200772553682327, 0.200620695948601, 0.200468793511391, 0.200316935777664, 0.200165122747421, 0.200013250112534, 0.199861392378807, 0.199709609150887, 0.199557811021805, 0.199405983090401, 0.19925419986248, 0.199102446436882, 0.198950693011284, 0.198798909783363, 0.198647201061249, 0.198495462536812, 0.198343753814697, 0.198192059993744, 0.198040366172791, 0.197888672351837, 0.197736993432045, 0.197585359215736, 0.197433695197105, 0.197282060980797, 0.197130441665649, 0.196978837251663, 0.196827217936516, 0.196675643324852, 0.196524068713188, 0.196372494101524, 0.196220934391022, 0.196069404482841, 0.1959178596735, 0.195766344666481, 0.195614829659462, 0.195463344454765, 0.195311844348907, 0.195160388946533, 0.195008903741837, 0.194857463240623, 0.194706037640572, 0.194554582238197, 0.194403171539307, 0.194251760840416, 0.194100379943848, 0.193948999047279, 0.193797618150711, 0.193646252155304, 0.193494915962219, 0.193343564867973, 0.193192228674889, 0.193040937185287, 0.192889630794525, 0.192738354206085, 0.192587062716484, 0.192435771226883, 0.192284524440765, 0.19213330745697, 0.191982045769691, 0.191830828785896, 0.191679626703262, 0.191528409719467, 0.191377222537994, 0.191226050257683, 0.191074877977371, 0.190923735499382, 0.190772593021393, 0.190621465444565, 0.190470322966576, 0.19031922519207, 0.190168142318726, 0.19001704454422, 0.189865976572037, 0.189714908599854, 0.189563870429993, 0.189412817358971, 0.189261794090271, 0.189110770821571, 0.188959777355194, 0.188808798789978, 0.188657805323601, 0.188506811857224, 0.18835586309433, 0.188204914331436, 0.188053965568542, 0.187903046607971, 0.187752142548561, 0.18760122358799, 0.187450349330902, 0.187299475073814, 0.187148600816727, 0.186997726559639, 0.186846897006035, 0.186696067452431, 0.186545222997665, 0.186394453048706, 0.186243653297424, 0.186092853546143, 0.185942053794861, 0.185791283845901, 0.185640528798103, 0.185489803552628, 0.185339078307152, 0.185188338160515, 0.1850376278162, 0.184886947274208, 0.184736266732216, 0.184585571289062, 0.184434920549393, 0.184284299612045, 0.184133633971214, 0.183983027935028, 0.183832392096519, 0.183681800961494, 0.183531194925308, 0.183380603790283, 0.183230027556419, 0.183079466223717, 0.182928934693336, 0.182778403162956, 0.182627871632576, 0.182477369904518, 0.182326883077621, 0.182176381349564, 0.182025879621506, 0.181875422596931, 0.181724965572357, 0.181574523448944, 0.181424081325531, 0.18127366900444, 0.18112325668335, 0.180972903966904, 0.180822476744652, 0.180672094225883, 0.180521756410599, 0.180371403694153, 0.180221065878868, 0.180070698261261, 0.17992040514946, 0.179770082235336, 0.179619789123535, 0.179469481110573, 0.179319232702255, 0.179168939590454, 0.17901873588562, 0.178868487477303, 0.178718253970146, 0.178568050265312, 0.178417831659317, 0.178267657756805, 0.178117468953133, 0.17796728014946, 0.177817121148109, 0.17766697704792, 0.177516847848892, 0.177366733551025, 0.177216619253159, 0.177066534757614, 0.176916435360909, 0.176766335964203, 0.176616296172142, 0.176466211676598, 0.176316171884537, 0.176166146993637, 0.176016122102737, 0.17586612701416, 0.175716117024422, 0.175566107034683, 0.175416186451912, 0.175266176462173, 0.175116255879402, 0.17496632039547, 0.174816355109215, 0.174666464328766, 0.174516573548317, 0.174366667866707, 0.174216747283936, 0.17406690120697, 0.173917040228844, 0.173767179250717, 0.173617333173752, 0.173467516899109, 0.173317715525627, 0.173167914152145, 0.173018112778664, 0.172868326306343, 0.172718554735184, 0.172568798065186, 0.172419056296349, 0.172269344329834, 0.172119602560997, 0.171969905495644, 0.171820178627968, 0.171670496463776, 0.171520829200745, 0.171371132135391, 0.171221509575844, 0.171071887016296, 0.170922219753265, 0.170772582292557, 0.170623019337654, 0.170473411679268, 0.170323818922043, 0.170174241065979, 0.170024663209915, 0.169875115156174, 0.169725582003593, 0.169576078653336, 0.169426545500755, 0.169277042150497, 0.16912753880024, 0.168978065252304, 0.168828591704369, 0.168679133057594, 0.16852967441082, 0.168380245566368, 0.168230801820755, 0.168081402778625, 0.167932003736496, 0.167782604694366, 0.167633250355721, 0.167483851313591, 0.167334526777267, 0.16718515753746, 0.167035818099976, 0.166886508464813, 0.16673718392849, 0.16658790409565, 0.166438594460487, 0.166289329528809, 0.166140094399452, 0.165990799665451, 0.165841549634933, 0.165692344307899, 0.165543094277382, 0.16539391875267, 0.165244713425636, 0.165095508098602, 0.164946332573891, 0.164797201752663, 0.164648026227951, 0.164498895406723, 0.164349764585495, 0.164200663566589, 0.164051532745361, 0.163902431726456, 0.163753375411034, 0.163604274392128, 0.16345526278019, 0.163306206464767, 0.163157150149345, 0.163008123636246, 0.162859126925468, 0.16271011531353, 0.162561118602753, 0.162412136793137, 0.162263184785843, 0.162114202976227, 0.161965265870094, 0.161816343665123, 0.161667391657829, 0.16151849925518, 0.161369621753693, 0.161220714449883, 0.161071836948395, 0.160922974348068, 0.160774126648903, 0.160625278949738, 0.160476446151733, 0.160327643156052, 0.160178810358047, 0.160030022263527, 0.159881249070168, 0.159732475876808, 0.15958371758461, 0.159434959292412, 0.159286201000214, 0.15913750231266, 0.158988773822784, 0.158840075135231, 0.158691376447678, 0.158542692661285, 0.158394053578377, 0.158245369791985, 0.158096730709076, 0.157948106527328, 0.157799452543259, 0.157650858163834, 0.157502263784409, 0.157353639602661, 0.157205075025558, 0.157056525349617, 0.156907945871353, 0.156759411096573, 0.156610876321793, 0.156462371349335, 0.156313836574554, 0.156165346503258, 0.156016886234283, 0.155868366360664, 0.155719935894012, 0.155571490526199, 0.155423015356064, 0.155274599790573, 0.155126184225082, 0.154977768659592, 0.154829382896423, 0.154680982232094, 0.15453265607357, 0.154384270310402, 0.154235899448395, 0.154087603092194, 0.153939232230186, 0.153790935873985, 0.153642639517784, 0.153494313359261, 0.153346061706543, 0.153197795152664, 0.153049543499947, 0.152901276946068, 0.152753040194511, 0.152604848146439, 0.152456596493721, 0.152308419346809, 0.152160242199898, 0.152012035250664, 0.151863887906075, 0.151715710759163, 0.151567563414574, 0.151419445872307, 0.15127132833004, 0.151123225688934, 0.150975108146667, 0.150827035307884, 0.150678977370262, 0.150530889630318, 0.150382846593857, 0.150234818458557, 0.150086745619774, 0.149938762187958, 0.14979076385498, 0.149642735719681, 0.149494767189026, 0.149346813559532, 0.149198859930038, 0.149050876498222, 0.148902967572212, 0.148755043745041, 0.14860711991787, 0.148459210991859, 0.148311331868172, 0.148163422942162, 0.148015573620796, 0.14786770939827, 0.147719845175743, 0.147572040557861, 0.147424206137657, 0.147276416420937, 0.147128582000732, 0.146980822086334, 0.146833047270775, 0.146685257554054, 0.146537512540817, 0.146389797329903, 0.146242022514343, 0.14609432220459, 0.145946606993675, 0.145798891782761, 0.14565122127533, 0.145503535866737, 0.14535591006279, 0.145208224654198, 0.145060583949089, 0.144912987947464, 0.144765347242355, 0.14461775124073, 0.144470140337944, 0.14432255923748, 0.144174993038177, 0.144027441740036, 0.143879860639572, 0.143732354044914, 0.143584817647934, 0.143437340855598, 0.143289804458618, 0.143144384026527, 0.143000960350037, 0.142857611179352, 0.142714306712151, 0.142571076750755, 0.142427906394005, 0.142284795641899, 0.142141759395599, 0.141998767852783, 0.141855865716934, 0.141713008284569, 0.141570240259171, 0.141427487134933, 0.141284853219986, 0.141142264008522, 0.140999719500542, 0.140857249498367, 0.140714839100838, 0.140572488307953, 0.140430226922035, 0.14028799533844, 0.140145868062973, 0.140003755688667, 0.139861717820168, 0.139719754457474, 0.139577835798264, 0.139436006546021, 0.139294251799583, 0.139152511954308, 0.139010891318321, 0.138869300484657, 0.138727754354477, 0.138586297631264, 0.138444900512695, 0.138303592801094, 0.138162285089493, 0.138021111488342, 0.137879952788353, 0.13773886859417, 0.137597858905792, 0.13745690882206, 0.137316018342972, 0.13717520236969, 0.137034460902214, 0.136893719434738, 0.136753097176552, 0.136612504720688, 0.13647198677063, 0.136331558227539, 0.136191159486771, 0.136050850152969, 0.135910540819168, 0.135770380496979, 0.135630279779434, 0.135490164160728, 0.135350182652473, 0.135210245847702, 0.135070338845253, 0.134930536150932, 0.134790793061256, 0.134651079773903, 0.134511455893517, 0.134371906518936, 0.134232416749001, 0.134092971682549, 0.13395357131958, 0.133814305067062, 0.133675023913383, 0.133535847067833, 0.133396700024605, 0.133257627487183, 0.13311867415905, 0.132979765534401, 0.132840871810913, 0.132702052593231, 0.132563337683678, 0.132424667477608, 0.132286056876183, 0.132147461175919, 0.132008999586105, 0.131870552897453, 0.131732225418091, 0.131593897938728, 0.131455630064011, 0.131317496299744, 0.131179392337799, 0.131041318178177, 0.130903348326683, 0.130765423178673, 0.130627602338791, 0.130489781498909, 0.130352035164833, 0.130214393138885, 0.130076751112938, 0.129939258098602, 0.129801765084267, 0.129664316773415, 0.129526987671852, 0.129389718174934, 0.129252478480339, 0.129115298390388, 0.128978207707405, 0.128841206431389, 0.128704220056534, 0.128567278385162, 0.12843045592308, 0.128293678164482, 0.12815697491169, 0.128020286560059, 0.127883702516556, 0.127747148275375, 0.127610713243484, 0.127474308013916, 0.127337947487831, 0.127201676368713, 0.127065494656563, 0.126929342746735, 0.126793220639229, 0.126657202839851, 0.126521244645119, 0.126385360956192, 0.126249507069588, 0.126113742589951, 0.125978037714958, 0.125842407345772, 0.125706806778908, 0.125571250915527, 0.125435829162598, 0.125300452113152, 0.125165119767189, 0.125029817223549, 0.124894663691521, 0.124759495258331, 0.124624446034431, 0.124489419162273, 0.124354474246502, 0.124219588935375, 0.124084778130054, 0.123949982225895, 0.123815290629864, 0.123680680990219, 0.123546116054058, 0.123411595821381, 0.123277120292187, 0.123142778873444, 0.123008422553539, 0.122874192893505, 0.122739985585213, 0.122605875134468, 0.122471809387207, 0.122337833046913, 0.122203856706619, 0.122069999575615, 0.121936194598675, 0.121802441775799, 0.121668756008148, 0.121535107493401, 0.121401578187943, 0.121268063783646, 0.121134653687477, 0.121001243591309, 0.12086796015501, 0.120734728872776, 0.120601534843445, 0.120468392968178, 0.120335347950459, 0.120202355086803, 0.120069481432438, 0.11993657797575, 0.119803763926029, 0.119671061635017, 0.119538351893425, 0.119405776262283, 0.119273193180561, 0.119140736758709, 0.119008302688599, 0.118875965476036, 0.118743665516376, 0.118611395359039, 0.118479251861572, 0.118347153067589, 0.118215098977089, 0.118083097040653, 0.117951191961765, 0.117819346487522, 0.117687597870827, 0.11755583435297, 0.117424182593822, 0.117292560636997, 0.117161050438881, 0.117029570043087, 0.116898149251938, 0.116766810417175, 0.116635538637638, 0.116504289209843, 0.116373136639595, 0.116242066025734, 0.116111032664776, 0.115980058908463, 0.115849144756794, 0.115718305110931, 0.115587532520294, 0.115456812083721, 0.115326158702374, 0.115195542573929, 0.115065030753613, 0.114934615790844, 0.114804193377495, 0.114673838019371, 0.114543572068214, 0.114413388073444, 0.114283241331577, 0.114153124392033, 0.114023141562939, 0.113893158733845, 0.113763280212879, 0.113633461296558, 0.113503649830818, 0.113373972475529, 0.113244347274303, 0.113114766776562, 0.112985201179981, 0.112855806946754, 0.112726405262947, 0.112597092986107, 0.112467795610428, 0.112338609993458, 0.112209483981133, 0.112080425024033, 0.111951410770416, 0.111822426319122, 0.111693546175957, 0.111564785242081, 0.111436009407043, 0.11130728572607, 0.111178673803806, 0.111050128936768, 0.110921628773212, 0.11079315841198, 0.110664784908295, 0.110536493360996, 0.11040823161602, 0.11028004437685, 0.110151879489422, 0.110023841261864, 0.109895884990692, 0.10976792126894, 0.109640039503574, 0.109512254595757, 0.109384521842003, 0.109256833791733, 0.109129190444946, 0.109001658856869, 0.108874157071114, 0.108746722340584, 0.10861936211586, 0.108492031693459, 0.108364813029766, 0.10823766887188, 0.108110547065735, 0.107983462512493, 0.107856497168541, 0.107729583978653, 0.10760273039341, 0.107475928962231, 0.107349202036858, 0.107222527265549, 0.107095927000046, 0.106969371438026, 0.106842890381813, 0.106716461479664, 0.106590136885643, 0.106463819742203, 0.10633759945631, 0.106211431324482, 0.106085352599621, 0.105959318578243, 0.10583333671093, 0.105707406997681, 0.105581566691399, 0.105455793440342, 0.105330064892769, 0.10520438849926, 0.105078808963299, 0.104953318834305, 0.104827798902988, 0.104702405631542, 0.10457705706358, 0.104451805353165, 0.104326575994492, 0.104201391339302, 0.104076318442822, 0.103951275348663, 0.103826329112053, 0.103701435029507, 0.103576585650444, 0.103451810777187, 0.103327132761478, 0.103202439844608, 0.103077858686447, 0.102953366935253, 0.102828912436962, 0.102704495191574, 0.102580182254314, 0.102455914020538, 0.102331690490246, 0.102207586169243, 0.10208348184824, 0.101959444582462, 0.101835489273071, 0.101711638271809, 0.101587787270546, 0.101464033126831, 0.101340316236019, 0.101216711103916, 0.101093128323555, 0.100969605147839, 0.100846156477928, 0.100722774863243, 0.100599475204945, 0.10047622025013, 0.100352987647057, 0.100229874253273, 0.100106820464134, 0.0999838039278984, 0.0998608618974686, 0.0997379943728447, 0.0996151864528656, 0.0994924306869507, 0.0993697270750999, 0.0992471054196358, 0.0991245582699776, 0.0990020558238029, 0.0988796278834343, 0.0987572371959686, 0.0986349284648895, 0.0985126942396164, 0.0983904898166656, 0.0982683971524239, 0.0981463342905045, 0.0980243682861328, 0.0979024320840836, 0.0977805405855179, 0.0976587533950806, 0.0975370034575462, 0.0974153503775597, 0.0972936972975731, 0.0971721485257149, 0.0970506742596626, 0.0969292819499969, 0.0968078970909119, 0.0966865867376328, 0.0965653583407402, 0.096444196999073, 0.0963231027126312, 0.0962020084261894, 0.096081055700779, 0.0959601402282715, 0.0958392918109894, 0.0957185178995132, 0.0955977514386177, 0.0954770818352699, 0.0953565239906311, 0.0952359512448311, 0.09511549025774, 0.0949950441718102, 0.0948747470974922, 0.0947544649243355, 0.0946342125535011, 0.0945140495896339, 0.0943939387798309, 0.0942739248275757, 0.0941539630293846, 0.0940340384840965, 0.0939141735434532, 0.0937944352626801, 0.0936746895313263, 0.0935550332069397, 0.0934354439377785, 0.0933159440755844, 0.0931964889168739, 0.0930770486593246, 0.0929577201604843, 0.092838428914547, 0.092719241976738, 0.0926000997424126, 0.0924810245633125, 0.0923619568347931, 0.0922430530190468, 0.0921241194009781, 0.0920052900910378, 0.091886542737484, 0.091767817735672, 0.0916491821408272, 0.0915305763483047, 0.0914120748639107, 0.0912936106324196, 0.0911752358078957, 0.0910569056868553, 0.0909386798739433, 0.0908204391598701, 0.0907023325562477, 0.0905842185020447, 0.0904662311077118, 0.0903482735157013, 0.0902304127812386, 0.0901125892996788, 0.089994803071022, 0.089877113699913, 0.0897594764828682, 0.0896419286727905, 0.0895244032144547, 0.0894069895148277, 0.0892895832657814, 0.089172288775444, 0.0890550389885902, 0.0889378190040588, 0.088820718228817, 0.0887036770582199, 0.0885866731405258, 0.0884697064757347, 0.0883528143167496, 0.088236041367054, 0.0881192907691002, 0.0880025923252106, 0.0878859907388687, 0.0877694115042686, 0.0876529440283775, 0.0875364765524864, 0.0874201282858849, 0.0873038098216057, 0.0871875882148743, 0.0870713964104652, 0.0869552791118622, 0.0868392363190651, 0.0867232382297516, 0.0866073220968246, 0.0864914655685425, 0.0863756611943245, 0.0862599089741707, 0.0861442685127258, 0.0860286504030228, 0.0859130993485451, 0.0857976153492928, 0.085682213306427, 0.0855668485164642, 0.0854515507817268, 0.0853363052010536, 0.0852211713790894, 0.0851060599088669, 0.0849910080432892, 0.0848760381340981, 0.0847611054778099, 0.0846462622284889, 0.0845314711332321, 0.0844167694449425, 0.0843021124601364, 0.0841875076293945, 0.084072969853878, 0.0839584916830063, 0.0838440805673599, 0.0837297737598419, 0.0836154595017433, 0.0835012346506119, 0.0833870843052864, 0.0832729712128639, 0.0831589624285698, 0.0830449834465981, 0.0829310938715935, 0.0828172564506531, 0.0827034935355186, 0.082589790225029, 0.0824761092662811, 0.0823625475168228, 0.0822490304708481, 0.0821355655789375, 0.0820221528410912, 0.0819088071584702, 0.0817955359816551, 0.0816823616623878, 0.0815691947937012, 0.0814561024308205, 0.0813430920243263, 0.0812301486730576, 0.0811172798275948, 0.0810044035315514, 0.0808916687965393, 0.0807789862155914, 0.0806663185358047, 0.0805537402629852, 0.0804412364959717, 0.0803287625312805, 0.0802164301276207, 0.0801040753722191, 0.0799918100237846, 0.0798796489834785, 0.0797675177454948, 0.0796554461121559, 0.0795433819293976, 0.0794314742088318, 0.0793223083019257, 0.0792152211070061, 0.079108253121376, 0.0790013670921326, 0.0788945555686951, 0.0787878111004829, 0.0786811709403992, 0.0785745829343796, 0.0784681215882301, 0.0783617570996284, 0.0782553777098656, 0.0781490877270699, 0.0780429616570473, 0.0779369026422501, 0.0778308436274529, 0.0777249336242676, 0.0776190832257271, 0.0775133073329926, 0.077407605946064, 0.0773020014166832, 0.0771964341402054, 0.0770910084247589, 0.0769856721162796, 0.0768803581595421, 0.0767751634120941, 0.0766700208187103, 0.0765649825334549, 0.0764600187540054, 0.0763551220297813, 0.0762503072619438, 0.0761455744504929, 0.0760409384965897, 0.07593634724617, 0.0758318528532982, 0.0757274478673935, 0.0756231471896172, 0.0755188688635826, 0.0754146948456764, 0.0753105878829956, 0.0752066224813461, 0.0751026570796967, 0.0749988034367561, 0.0748950317502022, 0.0747913271188736, 0.074687771499157, 0.0745841935276985, 0.0744807198643684, 0.0743773654103279, 0.0742741078138351, 0.0741708874702454, 0.074067734181881, 0.0739647150039673, 0.0738617405295372, 0.0737588107585907, 0.0736559927463531, 0.0735532641410828, 0.0734505951404572, 0.0733480826020241, 0.073245570063591, 0.0731431543827057, 0.0730408057570457, 0.0729385688900948, 0.0728363767266273, 0.0727343186736107, 0.0726322531700134, 0.0725303515791893, 0.0724285095930099, 0.0723266899585724, 0.0722250118851662, 0.0721234455704689, 0.0720219016075134, 0.0719204246997833, 0.0718190222978592, 0.0717177540063858, 0.0716165378689766, 0.0715154036879539, 0.0714143738150597, 0.0713133439421654, 0.071212463080883, 0.0711116641759872, 0.0710109025239944, 0.0709102675318718, 0.0708097144961357, 0.0707092136144638, 0.0706087872385979, 0.0705084279179573, 0.0704081878066063, 0.0703080072999001, 0.0702079385519028, 0.0701079294085503, 0.0700079426169395, 0.0699081271886826, 0.0698083490133286, 0.0697086602449417, 0.069609023630619, 0.0695095285773277, 0.0694100335240364, 0.0693106725811958, 0.0692113563418388, 0.0691121444106102, 0.0690130293369293, 0.0689139440655708, 0.0688149929046631, 0.0687160566449165, 0.0686172470450401, 0.0685185417532921, 0.0684198960661888, 0.0683213248848915, 0.0682228207588196, 0.0681243985891342, 0.0680260434746742, 0.0679277628660202, 0.0678296163678169, 0.0677315518260002, 0.0676334723830223, 0.0675355643033981, 0.0674377009272575, 0.0673399120569229, 0.0672422423958778, 0.0671445950865746, 0.0670470967888832, 0.0669496357440948, 0.0668522343039513, 0.0667549520730972, 0.0666576772928238, 0.0665605738759041, 0.0664635524153709, 0.0663665533065796, 0.0662696659564972, 0.0661728605628014, 0.0660761073231697, 0.0659794434905052, 0.0658828318119049, 0.0657863840460777, 0.0656899809837341, 0.0655935779213905, 0.0654973536729813, 0.0654011517763138, 0.0653050467371941, 0.0652090385556221, 0.0651131123304367, 0.0650172531604767, 0.0649214684963226, 0.0648257732391357, 0.0647301524877548, 0.0646345987915993, 0.0645391643047333, 0.0644438192248344, 0.0643484443426132, 0.0642532557249069, 0.0641581043601036, 0.0640630349516869, 0.0639680773019791, 0.0638731569051743, 0.0637783780694008, 0.0636836141347885, 0.0635889172554016, 0.0634943842887878, 0.0633998513221741, 0.063305452466011, 0.063211128115654, 0.0631168708205223, 0.0630226582288742, 0.0629285424947739, 0.0628345310688019, 0.0627406165003777, 0.0626467317342758, 0.0625529736280441, 0.0624592788517475, 0.0623656213283539, 0.0622721090912819, 0.0621786266565323, 0.0620852187275887, 0.0619919709861279, 0.0618987530469894, 0.0618055537343025, 0.0617124959826469, 0.06161954626441, 0.0615266487002373, 0.0614337995648384, 0.0613410733640194, 0.0612484589219093, 0.0611558258533478, 0.0610633119940758, 0.0609709024429321, 0.0608785301446915, 0.0607863217592239, 0.0606941245496273, 0.0606019981205463, 0.0605099648237228, 0.0604180470108986, 0.0603262186050415, 0.0602343790233135, 0.0601427108049393, 0.0600511096417904, 0.0599595122039318, 0.0598680526018143, 0.059776671230793, 0.0596853867173195, 0.0595941618084908, 0.0595030188560486, 0.0594119541347027, 0.0593209117650986, 0.0592300593852997, 0.0591392517089844, 0.0590484961867332, 0.0589578151702881, 0.0588672570884228, 0.0587767362594604, 0.0586862973868847, 0.0585959292948246, 0.0585057027637959, 0.0584155283868313, 0.0583253912627697, 0.0582353956997395, 0.0581454336643219, 0.0580555647611618, 0.057965811342001, 0.0578760914504528, 0.0577864721417427, 0.0576969459652901, 0.0576074421405792, 0.0575180761516094, 0.0574287325143814, 0.0573395453393459, 0.0572504103183746, 0.0571613274514675, 0.0570723488926888, 0.0569834634661674, 0.0568945780396461, 0.0568058490753174, 0.056717187166214, 0.056628629565239, 0.0565400943160057, 0.0564516633749008, 0.0563633404672146, 0.0562750324606895, 0.0561868660151958, 0.0560987815260887, 0.0560107529163361, 0.0559227839112282, 0.0558349527418613, 0.0557471215724945, 0.0556594282388687, 0.0555718205869198, 0.0554842874407768, 0.0553967878222466, 0.0553093813359737, 0.0552221089601517, 0.0551348552107811, 0.0550477094948292, 0.0549606457352638, 0.0548736788332462, 0.0547867193818092, 0.0546999461948872, 0.0546131655573845, 0.0545264966785908, 0.0544399134814739, 0.0543534159660339, 0.0542670264840126, 0.0541806183755398, 0.0540943667292595, 0.0540081709623337, 0.053922064602375, 0.0538360588252544, 0.053750105202198, 0.0536641925573349, 0.0535784512758255, 0.0534927137196064, 0.0534071177244186, 0.0533215366303921, 0.0532360896468163, 0.0531507022678852, 0.0530653521418571, 0.0529801398515701, 0.0528949983417988, 0.0528099089860916, 0.0527249611914158, 0.0526400320231915, 0.0525551699101925, 0.0524704679846764, 0.0523857660591602, 0.0523012280464172, 0.052216649055481, 0.0521322600543499, 0.0520479120314121, 0.0519635751843452, 0.0518794395029545, 0.0517953149974346, 0.0517112985253334, 0.051627341657877, 0.0515434443950653, 0.0514596775174141, 0.0513759814202785, 0.0512923300266266, 0.0512087903916836, 0.0511253215372562, 0.0510419197380543, 0.0509586408734322, 0.0508753843605518, 0.0507922135293484, 0.0507091470062733, 0.050626166164875, 0.0505432821810246, 0.0504604056477547, 0.0503776930272579, 0.0502950139343739, 0.050212386995554, 0.0501299016177654, 0.0500474534928799, 0.0499650947749615, 0.0498828515410423, 0.0498006492853165, 0.0497185103595257, 0.0496364869177341, 0.0495545491576195, 0.0494727157056332, 0.0493908636271954, 0.0493091493844986, 0.0492275431752205, 0.0491459742188454, 0.0490645281970501, 0.0489830933511257, 0.0489018224179745, 0.0488205701112747, 0.0487394034862518, 0.0486583635210991, 0.0485773533582687, 0.0484964177012444, 0.048415619879961, 0.0483348593115807, 0.0482541508972645, 0.0481736026704311, 0.0480930842459202, 0.0480126217007637, 0.0479322485625744, 0.0478519983589649, 0.047771867364645, 0.0476916916668415, 0.0476116836071014, 0.0475317128002644, 0.0474518127739429, 0.0473720543086529, 0.047292310744524, 0.0472126640379429, 0.0471331477165222, 0.0470536686480045, 0.0469742491841316, 0.0468949303030968, 0.0468156971037388, 0.0467365905642509, 0.0466574616730213, 0.0465784929692745, 0.046499602496624, 0.0464207194745541, 0.0463419817388058, 0.0462632961571217, 0.0461847372353077, 0.0461061894893646, 0.0460277535021305, 0.0459494143724442, 0.0458711013197899, 0.0457929112017155, 0.0457148216664791, 0.0456367358565331, 0.0455588176846504, 0.0454809628427029, 0.0454031564295292, 0.0453254245221615, 0.0452477745711803, 0.0451702475547791, 0.0450927428901196, 0.0450153425335884, 0.0449380427598953, 0.044860765337944, 0.0447836443781853, 0.044706579297781, 0.0446295328438282, 0.0445526577532291, 0.0444758385419846, 0.0443990677595139, 0.0443223901093006, 0.044245757162571, 0.0441692695021629, 0.0440928190946579, 0.0440164431929588, 0.0439402014017105, 0.0438639782369137, 0.0437878631055355, 0.0437118299305439, 0.0436358563601971, 0.0435599833726883, 0.0434841997921467, 0.043408490717411, 0.043332863599062, 0.0432572737336159, 0.0431818068027496, 0.0431064441800117, 0.0430310517549515, 0.0429558493196964, 0.042880717664957, 0.0428056232631207, 0.0427306108176708, 0.0426556877791882, 0.0425808727741241, 0.0425060950219631, 0.042431402951479, 0.0423568300902843, 0.04228226095438, 0.0422078520059586, 0.0421335063874722, 0.0420591682195663, 0.0419850088655949, 0.0419109128415585, 0.0418368726968765, 0.0417628958821297, 0.0416890010237694, 0.041615217924118, 0.04154147580266, 0.0414678268134594, 0.0413942895829678, 0.0413208119571209, 0.04124740883708, 0.0411740988492966, 0.0411008521914482, 0.0410276725888252, 0.0409546196460724, 0.0408815965056419, 0.0408087112009525, 0.0407358035445213, 0.0406630784273148, 0.0405904240906239, 0.0405177734792233, 0.0404452830553055, 0.0403728224337101, 0.0403004847466946, 0.0402282066643238, 0.0401559770107269, 0.0400838702917099, 0.0400118306279182, 0.0399398505687714, 0.0398680046200752, 0.0397961437702179, 0.0397244431078434, 0.0396528318524361, 0.0395812168717384, 0.0395097434520721, 0.0394383408129215, 0.0393670424818993, 0.03929578140378, 0.0392246246337891, 0.0391535572707653, 0.0390825383365154, 0.039011612534523, 0.038940791040659, 0.0388699844479561, 0.0387993231415749, 0.0387287475168705, 0.03865822032094, 0.0385877527296543, 0.0385173670947552, 0.0384471118450165, 0.0383769050240517, 0.0383067689836025, 0.0382367372512817, 0.0381667949259281, 0.0380968675017357, 0.0380271002650261, 0.0379573553800583, 0.0378876924514771, 0.0378181710839272, 0.0377486832439899, 0.0376792550086975, 0.0376099087297916, 0.0375406853854656, 0.0374714992940426, 0.0374024212360382, 0.0373334437608719, 0.0372645370662212, 0.0371956527233124, 0.0371269062161446, 0.0370582118630409, 0.036989588290453, 0.0369210913777351, 0.0368526242673397, 0.0367842987179756, 0.0367160104215145, 0.0366477742791176, 0.0365796610713005, 0.0365115813910961, 0.0364436432719231, 0.036375779658556, 0.0363079644739628, 0.0362402349710464, 0.0361725650727749, 0.0361050143837929, 0.036037515848875, 0.0359701067209244, 0.0359028019011021, 0.0358355864882469, 0.035769559442997, 0.0357047505676746, 0.0356401056051254, 0.0355754010379314, 0.0355108231306076, 0.0354463532567024, 0.0353818647563457, 0.0353175178170204, 0.0352532342076302, 0.035188976675272, 0.0351248010993004, 0.0350607372820377, 0.034996721893549, 0.0349327251315117, 0.0348688699305058, 0.034805029630661, 0.0347412638366222, 0.0346775986254215, 0.0346139557659626, 0.0345504656434059, 0.0344869270920753, 0.0344235450029373, 0.0343602001667023, 0.0342968702316284, 0.0342337191104889, 0.0341705679893494, 0.0341075211763382, 0.034044474363327, 0.0339815840125084, 0.0339187122881413, 0.0338558778166771, 0.033793181180954, 0.0337305031716824, 0.0336679667234421, 0.0336053781211376, 0.0335429459810257, 0.0334805697202682, 0.033418208360672, 0.0333560071885586, 0.0332938209176064, 0.0332316868007183, 0.0331696420907974, 0.0331077016890049, 0.0330457463860512, 0.0329839140176773, 0.0329221710562706, 0.0328604765236378, 0.0327988006174564, 0.0327372513711452, 0.0326757691800594, 0.0326143205165863, 0.0325529463589191, 0.0324916802346706, 0.032430425286293, 0.0323692783713341, 0.0323081985116005, 0.0322471931576729, 0.0321862250566483, 0.0321253202855587, 0.0320645458996296, 0.0320037491619587, 0.0319431275129318, 0.0318824909627438, 0.031821995973587, 0.0317614674568176, 0.031701073050499, 0.0316407531499863, 0.0315804332494736, 0.0315202698111534, 0.0314601436257362, 0.0314000882208347, 0.0313400700688362, 0.0312801674008369, 0.0312202889472246, 0.0311604980379343, 0.031100807711482, 0.0310411378741264, 0.0309815742075443, 0.0309220459312201, 0.0308625884354115, 0.0308031998574734, 0.030743882060051, 0.0306846871972084, 0.030625494197011, 0.0305663701146841, 0.0305073689669371, 0.03044836781919, 0.0303894709795713, 0.0303306300193071, 0.0302718747407198, 0.0302132088690996, 0.0301545951515436, 0.0300959963351488, 0.0300375074148178, 0.0299790687859058, 0.0299207177013159, 0.0298624727874994, 0.0298042297363281, 0.0297460909932852, 0.0296880025416613, 0.0296300053596497, 0.0295720435678959, 0.0295141655951738, 0.0294563975185156, 0.0293986275792122, 0.0293409824371338, 0.0292833540588617, 0.0292257945984602, 0.02916837669909, 0.029110960662365, 0.0290536638349295, 0.0289963521063328, 0.0289391800761223, 0.028882060199976, 0.0288249775767326, 0.0287680178880692, 0.0287111084908247, 0.0286542903631926, 0.0285974703729153, 0.0285407733172178, 0.0284841284155846, 0.0284275040030479, 0.0283710360527039, 0.0283145867288113, 0.0282582584768534, 0.0282018966972828, 0.0281457100063562, 0.028089540079236, 0.0280334055423737, 0.0279773976653814, 0.0279214400798082, 0.0278655365109444, 0.0278097186237574, 0.027753971517086, 0.027698278427124, 0.0276426374912262, 0.0275871176272631, 0.0275316350162029, 0.0274761877954006, 0.0274208448827267, 0.0273656100034714, 0.0273103546351194, 0.0272552073001862, 0.0272001810371876, 0.0271451212465763, 0.0270902179181576, 0.027035353705287, 0.0269805360585451, 0.0269258301705122, 0.0268711727112532, 0.026816587895155, 0.0267620012164116, 0.0267075896263123, 0.0266531836241484, 0.0265988614410162, 0.026544626802206, 0.0264904275536537, 0.0264363326132298, 0.0263822581619024, 0.0263283252716064, 0.0262743886560202, 0.0262205433100462, 0.0261667668819427, 0.0261130798608065, 0.0260594431310892, 0.0260058417916298, 0.0259523652493954, 0.0258989594876766, 0.0258455704897642, 0.0257922485470772, 0.0257390383630991, 0.0256858747452497, 0.0256327670067549, 0.0255798026919365, 0.025526849552989, 0.0254739169031382, 0.0254211276769638, 0.025368370115757, 0.0253156665712595, 0.0252630524337292, 0.0252105444669724, 0.0251580849289894, 0.0251056458801031, 0.0250533279031515, 0.025001049041748, 0.0249488539993763, 0.024896714836359, 0.0248446799814701, 0.024792680516839, 0.0247406959533691, 0.0246888734400272, 0.0246370863169432, 0.0245853494852781, 0.0245337020605803, 0.0244821440428495, 0.0244306195527315, 0.024379126727581, 0.0243277791887522, 0.0242764484137297, 0.0242252219468355, 0.0241740327328444, 0.0241229645907879, 0.0240718778222799, 0.0240209009498358, 0.0239700265228748, 0.0239191353321075, 0.0238684192299843, 0.0238177217543125, 0.0237671472132206, 0.0237165354192257, 0.0236660335212946, 0.0236156340688467, 0.0235652346163988, 0.0235149916261435, 0.0234647542238235, 0.023414634168148, 0.023364519700408, 0.0233144704252481, 0.0232646018266678, 0.0232146587222815, 0.0231648776680231, 0.0231151450425386, 0.0230655036866665, 0.0230158418416977, 0.0229663047939539, 0.0229168571531773, 0.0228674616664648, 0.0228181332349777, 0.0227688774466515, 0.022719694301486, 0.0226705446839333, 0.0226214826107025, 0.0225725267082453, 0.0225235540419817, 0.0224747732281685, 0.0224259551614523, 0.0223772451281548, 0.0223286058753729, 0.0222800187766552, 0.0222315024584532, 0.0221830550581217, 0.0221347156912088, 0.0220863576978445, 0.0220381394028664, 0.021989993751049, 0.0219418983906507, 0.0218938551843166, 0.0218458846211433, 0.0217980183660984, 0.0217501539736986, 0.0217024274170399, 0.0216547213494778, 0.0216070841997862, 0.0215595345944166, 0.0215120743960142, 0.0214646644890308, 0.0214172750711441, 0.0213700421154499, 0.0213228072971106, 0.0212756637483835, 0.0212285723537207, 0.0211815871298313, 0.0211346726864576, 0.0210877563804388, 0.0210409983992577, 0.020994259044528, 0.0209475886076689, 0.0209009889513254, 0.0208544600754976, 0.0208079665899277, 0.0207615960389376, 0.0207153148949146, 0.020669050514698, 0.0206228364259005, 0.0205767117440701, 0.0205306950956583, 0.0204846914857626, 0.0204387623816729, 0.02039291895926, 0.0203472003340721, 0.0203014276921749, 0.0202558301389217, 0.0202102698385715, 0.0201647635549307, 0.02011932246387, 0.0200739204883575, 0.0200286749750376, 0.0199834313243628, 0.0199382565915585, 0.0198931712657213, 0.0198481529951096, 0.0198032073676586, 0.0197582971304655, 0.0197135098278522, 0.0196687243878841, 0.0196240600198507, 0.0195794310420752, 0.0195349249988794, 0.0194904357194901, 0.0194460172206163, 0.0194016713649035, 0.0193574111908674, 0.0193132236599922, 0.0192690510302782, 0.019225001335144, 0.0191810056567192, 0.01913708075881, 0.0190932080149651, 0.0190494060516357, 0.0190057102590799, 0.018962012603879, 0.0189184565097094, 0.0188749358057976, 0.0188314691185951, 0.0187880713492632, 0.0187447797507048, 0.018701558932662, 0.0186583530157804, 0.0186152551323175, 0.0185722261667252, 0.0185292158275843, 0.0184863284230232, 0.01844347640872, 0.0184007473289967, 0.0183580182492733, 0.0183154307305813, 0.0182728599756956, 0.0182303059846163, 0.0181879289448261, 0.018145551905036, 0.0181032977998257, 0.0180610436946154, 0.0180189292877913, 0.0179768148809671, 0.0179347731173038, 0.0178928524255753, 0.0178509689867496, 0.0178091730922461, 0.0177674107253551, 0.0177257712930441, 0.0176841150969267, 0.0176425650715828, 0.0176011547446251, 0.0175597462803125, 0.0175184067338705, 0.017477136105299, 0.0174359567463398, 0.0173947922885418, 0.0173537340015173, 0.01731276512146, 0.017271863296628, 0.0172310005873442, 0.0171902067959309, 0.0171495173126459, 0.0171088296920061, 0.0170682463794947, 0.0170277524739504, 0.0169873088598251, 0.0169469378888607, 0.0169066358357668, 0.01686642318964, 0.0168262086808681, 0.0167861189693213, 0.0167460981756449, 0.0167061313986778, 0.0166662354022264, 0.0166263896971941, 0.0165866687893867, 0.0165469292551279, 0.0165072977542877, 0.0164677873253822, 0.0164282601326704, 0.0163888726383448, 0.016349520534277, 0.0163102224469185, 0.0162709932774305, 0.0162318348884583, 0.0161928199231625, 0.0161537826061249, 0.0161148551851511, 0.0160759780555964, 0.0160371717065573, 0.0159984361380339, 0.0159597527235746, 0.0159211922436953, 0.015882633626461, 0.0158441942185163, 0.0158058293163776, 0.0157674793154001, 0.0157292187213898, 0.0156910102814436, 0.0156529247760773, 0.0156148411333561, 0.0155768794938922, 0.0155389690771699, 0.0155011489987373, 0.0154633447527885, 0.0154256299138069, 0.0153880203142762, 0.015350392088294, 0.0153129231184721, 0.0152754541486502, 0.0152381062507629, 0.0152008319273591, 0.015163591131568, 0.0151264201849699, 0.0150893377140164, 0.0150523083284497, 0.0150153329595923, 0.0149784255772829, 0.014941624365747, 0.0149048948660493, 0.0148681811988354, 0.0148315913975239, 0.0147950714454055, 0.0147585356608033, 0.0147221200168133, 0.0146858124062419, 0.0146495047956705, 0.0146133191883564, 0.0145771875977516, 0.0145411249250174, 0.0145051162689924, 0.014469176530838, 0.0144333438947797, 0.0143975103273988, 0.0143617996945977, 0.0143261421471834, 0.01429058983922, 0.0142550216987729, 0.0142195736989379, 0.0141842346638441, 0.0141488583758473, 0.0141136581078172, 0.0140784587711096, 0.0140433451160789, 0.0140082854777575, 0.0139732966199517, 0.0139383794739842, 0.0139035657048225, 0.0138688227161765, 0.0138341337442398, 0.0137994959950447, 0.0137649113312364, 0.0137304151430726, 0.013695971108973, 0.0136615987867117, 0.0136273484677076, 0.0135931335389614, 0.0135589707642794, 0.0135248806327581, 0.0134908575564623, 0.0134569061920047, 0.0134230079129338, 0.0133892158046365, 0.0133554767817259, 0.0133218234404922, 0.0132881728932261, 0.0132546601817012, 0.0132211660966277, 0.0131877604871988, 0.0131544787436724, 0.0131211774423718, 0.0130879832431674, 0.0130548598244786, 0.0130217708647251, 0.0129888048395514, 0.012955873273313, 0.0129230478778481, 0.0128902057185769, 0.0128575200214982, 0.0128248706459999, 0.0127922398969531, 0.0127597488462925, 0.0127273099496961, 0.0126949772238731, 0.0126626277342439, 0.0126304170116782, 0.0125982435420156, 0.0125660868361592, 0.012534087523818, 0.0125021068379283, 0.0124702490866184, 0.0124383736401796, 0.0124066565185785, 0.0123749580234289, 0.0123432762920856, 0.0123117519542575, 0.0122802648693323, 0.0122488643974066, 0.0122174806892872, 0.0121862208470702, 0.0121549973264337, 0.0121238445863128, 0.0120927942916751, 0.0120617635548115, 0.0120308203622699, 0.0119999479502439, 0.01196916308254, 0.0119383968412876, 0.011907871812582, 0.0118779484182596, 0.0118480790406466, 0.0118182795122266, 0.0117884892970324, 0.0117587856948376, 0.0117290653288364, 0.011699415743351, 0.0116698443889618, 0.0116402730345726, 0.011610790155828, 0.011581308208406, 0.0115518951788545, 0.011522525921464, 0.0114931762218475, 0.011463912203908, 0.0114346481859684, 0.0114054745063186, 0.0113763073459268, 0.0113472295925021, 0.0113181518390775, 0.0112891178578138, 0.0112601537257433, 0.0112312156707048, 0.0112023577094078, 0.0111734988167882, 0.01114472001791, 0.0111159663647413, 0.0110872397199273, 0.0110586006194353, 0.0110299801453948, 0.0110014220699668, 0.0109728798270226, 0.0109444344416261, 0.0109159713611007, 0.0108875893056393, 0.0108592314645648, 0.0108309183269739, 0.0108026834204793, 0.010774458758533, 0.0107462778687477, 0.0107181575149298, 0.0106900557875633, 0.0106620592996478, 0.0106340637430549, 0.0106061277911067, 0.0105782197788358, 0.0105503378435969, 0.010522561147809, 0.0104947751387954, 0.0104670515283942, 0.0104393716901541, 0.0104117626324296, 0.0103841722011566, 0.010356605052948, 0.0103291096165776, 0.0103016421198845, 0.0102742612361908, 0.0102468887344003, 0.0102195870131254, 0.0101923123002052, 0.0101650543510914, 0.0101378839462996, 0.010110723786056, 0.0100836595520377, 0.0100565869361162, 0.0100296009331942, 0.0100026167929173, 0.00997569318860769, 0.00994884874671698, 0.009921969845891, 0.00989522226154804, 0.00986847467720509, 0.00984181556850672, 0.0098151471465826, 0.00978849548846483, 0.00976196955889463, 0.00973545853048563, 0.00970899313688278, 0.00968256220221519, 0.00965618342161179, 0.00962982326745987, 0.0096035236492753, 0.00957729574292898, 0.00955108553171158, 0.0095249442383647, 0.00949880387634039, 0.00947275944054127, 0.00944673363119364, 0.0094207338988781, 0.0093948133289814, 0.00936891883611679, 0.00934307742863894, 0.00931727979332209, 0.00929153524339199, 0.00926579907536507, 0.00924012437462807, 0.00921451207250357, 0.0091889426112175, 0.00916342623531818, 0.0091379014775157, 0.00911249127238989, 0.00908707175403833, 0.00906170532107353, 0.00903642643243074, 0.00901113077998161, 0.00898593105375767, 0.00896074902266264, 0.00893563777208328, 0.00891054421663284, 0.00888547673821449, 0.00886050518602133, 0.00883554387837648, 0.00881066080182791, 0.00878576934337616, 0.00876095611602068, 0.00873618852347136, 0.00871144607663155, 0.00868678279221058, 0.00866212882101536, 0.00863753631711006, 0.00861298851668835, 0.00858848355710506, 0.00856402330100536, 0.00853960588574409, 0.00851523410528898, 0.00849089585244656, 0.00846661999821663, 0.00844237022101879, 0.00841819122433662, 0.0083940215408802, 0.0083699207752943, 0.00834589079022408, 0.00832185335457325, 0.00829789415001869, 0.00827396102249622, 0.00825008936226368, 0.00822624377906322, 0.0082024522125721, 0.0081787221133709, 0.00815499201416969, 0.00813136622309685, 0.00810773205012083, 0.00808419566601515, 0.0080606322735548, 0.00803715549409389, 0.00801375042647123, 0.0079903369769454, 0.00796701945364475, 0.00794368609786034, 0.00792044773697853, 0.00789724476635456, 0.00787405949085951, 0.0078509533777833, 0.00782786402851343, 0.00780484592542052, 0.00778185436502099, 0.00775893358513713, 0.00773602072149515, 0.00771313486620784, 0.00769036263227463, 0.00766758201643825, 0.00764488056302071, 0.00762219680473208, 0.00759958289563656, 0.00757698761299253, 0.00755442632362247, 0.00753195350989699, 0.00750949885696173, 0.00748710473999381, 0.00746471947059035, 0.00744240498170257, 0.00742012588307261, 0.00739789940416813, 0.00737572554498911, 0.00735357869416475, 0.00733151007443666, 0.00730945076793432, 0.00728742638602853, 0.00726549047976732, 0.00724354479461908, 0.00722170621156693, 0.00719986576586962, 0.00717811426147819, 0.00715633668005466, 0.00713466387242079, 0.00711301853880286, 0.00709139835089445, 0.00706985779106617, 0.00704832607880235, 0.00702689168974757, 0.00700544752180576, 0.00698409229516983, 0.00696273613721132, 0.0069414246827364, 0.0069202184677124, 0.00689898570999503, 0.00687786750495434, 0.0068567399866879, 0.00683565763756633, 0.00681464420631528, 0.00679366663098335, 0.00677274214103818, 0.0067518437281251, 0.00673102494329214, 0.00671019637957215, 0.00668942974880338, 0.00666876044124365, 0.00664806412532926, 0.00662746466696262, 0.00660686567425728, 0.00658636307343841, 0.00656587723642588, 0.00654540164396167, 0.00652503920719028, 0.00650467770174146, 0.00648437766358256, 0.00646410370245576, 0.0064439089037478, 0.00642369594424963, 0.00640356354415417, 0.00638350052759051, 0.00636347290128469, 0.00634348066523671, 0.00632351450622082, 0.00630363682284951, 0.00628375820815563, 0.00626392383128405, 0.00624416070058942, 0.00622443156316876, 0.00620477413758636, 0.00618512462824583, 0.00616557197645307, 0.00614596623927355, 0.00612645735964179, 0.00610701879486442, 0.00608760723844171, 0.00606826553121209, 0.00604888843372464, 0.00602965289726853, 0.00601041736081243, 0.00599119812250137, 0.00597208552062511, 0.00595294591039419, 0.00593390362337232, 0.00591488787904382, 0.00589595036581159, 0.00587701378390193, 0.00585811212658882, 0.00583928916603327, 0.00582050206139684, 0.00580177549272776, 0.00578305870294571, 0.00576442992314696, 0.00574579183012247, 0.00572722405195236, 0.00570872705429792, 0.0056902477517724, 0.00567182060331106, 0.0056534199975431, 0.0056350901722908, 0.00561679480597377, 0.00559853529557586, 0.00558032002300024, 0.00556214805692434, 0.00554405525326729, 0.00552596291527152, 0.00550796696916223, 0.00548994448035955, 0.0054720020852983, 0.00545412907376885, 0.00543626490980387, 0.00541848922148347, 0.00540069583803415, 0.00538299884647131, 0.00536532839760184, 0.00534766633063555, 0.00533009320497513, 0.00531256338581443, 0.00529507780447602, 0.00527762761339545, 0.00526024727150798, 0.00524287577718496, 0.00522552197799087, 0.00520830042660236, 0.00519104301929474, 0.00517390016466379, 0.00515674892812967, 0.00513965962454677, 0.00512260477989912, 0.00510559324175119, 0.00508865341544151, 0.005071721971035, 0.00505486037582159, 0.0050380346365273, 0.00502129644155502, 0.00500453170388937, 0.00498782936483622, 0.00497119640931487, 0.00495459046214819, 0.00493805482983589, 0.00492152804508805, 0.00490505341440439, 0.00488863186910748, 0.00487224571406841, 0.00485594756901264, 0.00483965827152133, 0.00482340389862657, 0.00480720214545727, 0.0047910800203681, 0.00477494858205318, 0.00475887954235077, 0.00474286219105124, 0.00472688069567084, 0.00471098674461246, 0.00469506671652198, 0.00467925239354372, 0.00466343807056546, 0.00464767636731267, 0.00463199382647872, 0.00461631081998348, 0.00460071628913283, 0.0045851212926209, 0.00456961477175355, 0.00455412594601512, 0.00453867204487324, 0.00452330615371466, 0.00450793141499162, 0.00449265306815505, 0.00447735749185085, 0.00446214992552996, 0.00444699497893453, 0.00443184049800038, 0.00441678240895271, 0.0044017331674695, 0.00438676262274384, 0.00437181023880839, 0.00435687555000186, 0.00434204610064626, 0.00432723388075829, 0.00431248359382153, 0.00429774215444922, 0.00428308034315705, 0.00426840875297785, 0.00425383495166898, 0.00423932168632746, 0.00422478280961514, 0.0042103580199182, 0.00419592391699553, 0.00418157828971744, 0.00416725035756826, 0.00415294850245118, 0.00413872627541423, 0.00412453012540936, 0.00411040429025888, 0.00409629615023732, 0.00408224947750568, 0.00406822934746742, 0.00405427068471909, 0.00404035579413176, 0.0040264674462378, 0.00401264987885952, 0.00399884069338441, 0.00398513721302152, 0.00397142488509417, 0.00395775632932782, 0.0039441934786737, 0.00393058685585856, 0.00391708547249436, 0.00390361063182354, 0.00389021495357156, 0.00387680134736001, 0.00386344105936587, 0.00385015970095992, 0.00383691349998116, 0.00382372876629233, 0.00381053565070033, 0.00379744754172862, 0.003784368513152, 0.00377132464200258, 0.00375838601030409, 0.00374542130157351, 0.00373253598809242, 0.00371967651881278, 0.00370688759721816, 0.00369412521831691, 0.0036813982296735, 0.00366874109022319, 0.00365610187873244, 0.00364355952478945, 0.0036309992428869, 0.00361852673813701, 0.0036060546990484, 0.00359365297481418, 0.00358131271786988, 0.0035689901560545, 0.00355673744343221, 0.00354450289160013, 0.00353235634975135, 0.00352019187994301, 0.00350811542011797, 0.00349605665542185, 0.0034840595908463, 0.00347212399356067, 0.0034601972438395, 0.00344836711883545, 0.00343651906587183, 0.00342471525073051, 0.00341301737353206, 0.00340130156837404, 0.00338969123549759, 0.00337808113545179, 0.00336653250269592, 0.00335502764210105, 0.0033435495570302, 0.00333215924911201, 0.00332076009362936, 0.00330944010056555, 0.00329814665019512, 0.0032869407441467, 0.0032757178414613, 0.00326455594040453, 0.00325346458703279, 0.00324240000918508, 0.00323140528053045, 0.00322042847983539, 0.0032095042988658, 0.00319861550815403, 0.00318775279447436, 0.00317699555307627, 0.00316623854450881, 0.0031555169261992, 0.00314485630951822, 0.00313427555374801, 0.00312368548475206, 0.00311314826831222, 0.0031026725191623, 0.00309222331270576, 0.00308187096379697, 0.00307150091975927, 0.00306120119057596, 0.00305093685165048, 0.00304071605205536, 0.00303056603297591, 0.00302045117132366, 0.00301038892939687, 0.00300032692030072, 0.00299036153592169, 0.00298039591871202, 0.00297050084918737, 0.00296064116992056, 0.00295082526281476, 0.0029410794377327, 0.00293134269304574, 0.00292164995335042, 0.0029120366089046, 0.00290242279879749, 0.00289293238893151, 0.00288342428393662, 0.00287396879866719, 0.00286453147418797, 0.00285517261363566, 0.0028458668384701, 0.00283657875843346, 0.00282736984081566, 0.00281816953793168, 0.002809057245031, 0.00279993610456586, 0.00279087666422129, 0.00278189615346491, 0.00277290702797472, 0.0027640238404274, 0.00275512225925922, 0.00274630915373564, 0.00273753982037306, 0.00272876187227666, 0.00272008054889739, 0.00271144323050976, 0.00270285014994442, 0.00269427429884672, 0.00268576014786959, 0.00267728115431964, 0.00266885524615645, 0.00266050803475082, 0.00265214336104691, 0.00264385808259249, 0.00263559864833951, 0.00262741860933602, 0.00261926534585655, 0.00261112069711089, 0.00260308152064681, 0.00259504234418273, 0.00258707348257303, 0.00257913977839053, 0.0025712763890624, 0.00256338668987155, 0.00255558523349464, 0.00254784501157701, 0.00254011363722384, 0.00253247004002333, 0.00252463645301759, 0.00251643476076424, 0.00250824168324471, 0.00250008818693459, 0.00249194330535829, 0.00248380750417709, 0.0024757154751569, 0.00246762344613671, 0.00245956657454371, 0.00245154066942632, 0.00244350149296224, 0.00243550189770758, 0.00242752861231565, 0.00241957302205265, 0.00241161743178964, 0.00240369699895382, 0.00239581172354519, 0.0023879308719188, 0.00238007633015513, 0.00237224833108485, 0.00236442452296615, 0.00235663587227464, 0.00234886514954269, 0.00234111165627837, 0.00233336724340916, 0.00232564471662045, 0.00231796596199274, 0.00231029186397791, 0.00230263988487422, 0.0022950095590204, 0.00228739692829549, 0.00227981503121555, 0.00227225967682898, 0.00226471293717623, 0.00225715758278966, 0.00224966369569302, 0.0022421742323786, 0.00223471107892692, 0.00222726562060416, 0.00221983343362808, 0.00221242755651474, 0.00220503914169967, 0.00219769030809402, 0.00219033728353679, 0.00218301499262452, 0.00217571877874434, 0.00216843630187213, 0.00216117547824979, 0.00215395423583686, 0.00214671087451279, 0.00213950732722878, 0.00213233451358974, 0.00212518800981343, 0.00211805035360157, 0.00211090827360749, 0.00210382789373398, 0.00209675193764269, 0.00208970229141414, 0.00208267895504832, 0.00207564677111804, 0.00206864974461496, 0.00206168368458748, 0.00205473531968892, 0.00204779556952417, 0.00204086885787547, 0.00203399523161352, 0.00202712137252092, 0.00202029151841998, 0.00201346166431904, 0.00200663204304874, 0.00199985061772168, 0.00199309107847512, 0.00198633596301079, 0.00197960739023983, 0.00197290093638003, 0.00196621590293944, 0.0019595401827246, 0.00195290392730385, 0.00194627640303224, 0.00193967088125646, 0.00193310063332319, 0.00192653900012374, 0.00191999517846853, 0.00191345997154713, 0.00190696876961738, 0.00190048641525209, 0.0018940216396004, 0.00188759644515812, 0.0018811757909134, 0.00187475921120495, 0.00186839117668569, 0.00186204514466226, 0.00185570807661861, 0.00184938835445791, 0.00184309505857527, 0.001836814917624, 0.00183056120295078, 0.00182434264570475, 0.00181810220237821, 0.00181191018782556, 0.00180574879050255, 0.00179959624074399, 0.00179346138611436, 0.00178735284134746, 0.00178127060644329, 0.00177519721910357, 0.00176916352938861, 0.00176313403062522, 0.00175710022449493, 0.00175111927092075, 0.00174516020342708, 0.001739218714647, 0.00173328618984669, 0.0017273798584938, 0.00172149122226983, 0.00171563343610615, 0.00170979311224073, 0.0017039836384356, 0.00169816520065069, 0.00169239519163966, 0.00168662972282618, 0.00168089068029076, 0.00167516467627138, 0.00166946079116315, 0.00166377879213542, 0.00165812333580106, 0.00165250280406326, 0.00164688238874078, 0.00164127070456743, 0.00163570768199861, 0.00163014885038137, 0.00162461190484464, 0.00161911023315042, 0.00161359098274261, 0.00160811573732644, 0.00160267564933747, 0.00159725314006209, 0.00159183505456895, 0.00158643443137407, 0.00158106908202171, 0.00157571712043136, 0.00157040008343756, 0.00156509201042354, 0.0015597838209942, 0.00155451078899205, 0.00154928187839687, 0.00154404842760414, 0.00153883709572256, 0.00153364322613925, 0.00152849778532982, 0.00152334349695593, 0.00151822448242456, 0.00151313177775592, 0.00150803034193814, 0.00150297733489424, 0.00149792863521725, 0.00149291509296745, 0.00148789281956851, 0.00148291885852814, 0.00147795805241913, 0.00147301505785435, 0.00146810698788613, 0.00146320345811546, 0.00145832635462284, 0.00145346240606159, 0.0014486467698589, 0.00144382694270462, 0.00143903749994934, 0.00143424840644002, 0.00142948550637811, 0.00142475788015872, 0.00142005214001983, 0.00141533778514713, 0.00141067616641521, 0.00140602327883244, 0.00140140554867685, 0.00139679224230349, 0.00139218778349459, 0.00138762721326202, 0.00138306664302945, 0.00137855450157076, 0.00137405109126121, 0.00136954779736698, 0.00136507966089994, 0.00136064668186009, 0.00135621812660247, 0.00135181134101003, 0.00134740921203047, 0.0013430641265586, 0.00133871485013515, 0.00133438734337687, 0.00133009511046112, 0.00132579833734781, 0.00132155022583902, 0.00131731946021318, 0.00131309754215181, 0.0013088887790218, 0.00130470213480294, 0.00130055053159595, 0.00129640777595341, 0.00129228259902447, 0.00128820585086942, 0.00128410290926695, 0.00128006120212376, 0.00127602403517812, 0.00127200875431299, 0.00126802432350814, 0.00126404431648552, 0.00126008619554341, 0.00125615473370999, 0.00125224934890866, 0.00124836177565157, 0.00124446966219693, 0.00124061724636704, 0.0012367955641821, 0.00123298715334386, 0.00122920935973525, 0.00122542271856219, 0.00122167146764696, 0.00121795968152583, 0.00121426116675138, 0.0012105714995414, 0.001206886023283, 0.00120325793977827, 0.00119962962344289, 0.00119601900223643, 0.00119244807865471, 0.00118887261487544, 0.00118532788474113, 0.00118181854486465, 0.00117830897215754, 0.00117484352085739, 0.00117137364577502, 0.00116793904453516, 0.00116451317444444, 0.00116110488306731, 0.00115774059668183, 0.0011543674627319, 0.00115102948620915, 0.00114772224333137, 0.00114442827180028, 0.00114114326424897, 0.00113789760507643, 0.00113466521725059, 0.00113144610077143, 0.00112826644908637, 0.00112507806625217, 0.00112192472442985, 0.00111878477036953, 0.00111568870488554, 0.00111259706318378, 0.0011095053050667, 0.00110646651592106, 0.00110345392022282, 0.0011004414409399, 0.0010974642354995, 0.00109447806607932, 0.00109153147786856, 0.00108861573971808, 0.00108571315649897, 0.00108282384462655, 0.00107993453275412, 0.00107711111195385, 0.00107428338378668, 0.0010714951204136, 0.00106870254967362, 0.00106594071257859, 0.00106319203041494, 0.00106048304587603, 0.00105778279248625, 0.00105510011781007, 0.00105243059806526, 0.00104979635216296, 0.00104717526119202, 0.00104457617271692, 0.00104201666545123, 0.00103943515568972, 0.00103691080585122, 0.00103439518716186, 0.00103191484231502, 0.00102943007368594, 0.0010269673075527, 0.00102453969884664, 0.00102211651392281, 0.00101974164135754, 0.0010173711925745, 0.00101500528398901, 0.00101267010904849, 0.00101036997511983, 0.00100808741990477, 0.00100583152379841, 0.00100356212351471, 0.00100133253727108, 0.000999124837107956, 0.000996947870589793, 0.000994788482785225, 0.000992620480246842, 0.000990500673651695, 0.000988402869552374, 0.00098632276058197, 0.000984260230325162, 0.00098221527878195, 0.000980183365754783, 0.000978199997916818, 0.000976212264504284, 0.000974233204033226, 0.000972289359197021, 0.000970389461144805, 0.000968480831943452, 0.000966607360169291, 0.000964760314673185, 0.000962913269177079, 0.000961096899118274, 0.000959293800406158, 0.000957530282903463, 0.000955779978539795, 0.000954029674176127, 0.000952318892814219, 0.000950625690165907, 0.000948945758864284, 0.000947292195633054, 0.000945660634897649, 0.000944042229093611, 0.000942463462706655, 0.000940902216825634, 0.000939336547162384, 0.000937819248065352, 0.000936306547373533, 0.000934811250772327, 0.000933359959162772, 0.00093189108883962, 0.00093046622350812, 0.000929063302464783, 0.000927691231481731, 0.000926323409657925, 0.000924951338674873, 0.000923645158763975, 0.000922352191992104, 0.000921063707210124, 0.000919810321647674, 0.000918548088520765, 0.000917329976800829, 0.000916142540518194, 0.000914959528017789, 0.000913798518013209, 0.000912641873583198, 0.000911538081709296, 0.00091044302098453, 0.000909365538973361, 0.000908323214389384, 0.000907267851289362, 0.000906243047211319, 0.000905262364540249, 0.000904286105651408, 0.000903336156625301, 0.000902394996955991, 0.000901475839782506, 0.000900587532669306, 0.000899725535418838, 0.000898881116881967, 0.000898027967195958, 0.000897209974937141, 0.000896435987669975, 0.000895675155334175, 0.000894918688572943, 0.000894184282515198, 0.000893476186320186, 0.000892785785254091, 0.000892139272764325, 0.000891483970917761, 0.000890855153556913, 0.000890248222276568, 0.000889676623046398, 0.000889104849193245, 0.000888555136043578, 0.000888027425389737, 0.000887530448380858, 0.000887051050085574, 0.000886598078068346, 0.000886153895407915, 0.000885714136529714, 0.00088533153757453, 0.000884953304193914, 0.000884601438883692, 0.000884240900631994, 0.000883937405887991, 0.000883638334926218, 0.000883374537806958, 0.000883115048054606, 0.000882873137015849, 0.000882648804690689, 0.000882464169990271, 0.000882292632013559, 0.000882134307175875, 0.000882015563547611, 0.000881892396137118, 0.000881795713212341, 0.000881729763932526, 0.000881694548297673, 0.000881641753949225, 0.000881641753949225, 0.000881654967088252, 0.000881681393366307, 0.000881738495081663, 0.00088180013699457, 0.000881901243701577, 0.000882019987329841, 0.000882160733453929, 0.000882314692717046, 0.000882468593772501, 0.000882666441611946, 0.000882895139511675, 0.000883128202985972, 0.000883400905877352, 0.000883664761204273, 0.000883954984601587, 0.000884284847415984, 0.000884636712726206, 0.000884992943610996, 0.000885357847437263, 0.000885771354660392, 0.000886189111042768, 0.000886637717485428, 0.000887099478859454, 0.000887574453372508, 0.000888071372173727, 0.000888612354174256, 0.000889153277967125, 0.000889720511622727, 0.000890296709258109, 0.000890912371687591, 0.000891536881681532, 0.000892183335963637, 0.000892873795237392, 0.000893537886440754, 0.000894250290002674, 0.000894975906703621, 0.000895736797247082, 0.000896510842721909, 0.000897302350495011, 0.000898102764040232, 0.000898942758794874, 0.000899809179827571, 0.000900693063158542, 0.000901568273548037, 0.000902478583157063, 0.0009034329559654, 0.00090436969185248, 0.000905346008948982, 0.000906348752323538, 0.000907373381778598, 0.000908402493223548, 0.00090946676209569, 0.000910552975255996, 0.000911630457267165, 0.000912765157409012, 0.000913904164917767, 0.000915069540496916, 0.000916256918571889, 0.000917448778636754, 0.000918680103495717, 0.000919911544770002, 0.000921186874620616, 0.000922449049539864, 0.000923759595025331, 0.000925100932363421, 0.000926451000850648, 0.000927823188249022, 0.000929195317439735, 0.000930611393414438, 0.000932031951379031, 0.000933491974137723, 0.000934974057599902, 0.00093646056484431, 0.000937955745030195, 0.000939508201554418, 0.000941042962949723, 0.00094262178754434, 0.000944205035921186, 0.000945823499932885, 0.00094745063688606, 0.000949099834542722, 0.000950788555201143, 0.000952464179135859, 0.000954183749854565, 0.000955938419792801, 0.000957684358581901, 0.000959469878580421, 0.000961277342867106, 0.000963089289143682, 0.00096492312150076, 0.000966796593274921, 0.000968674488831311, 0.00097055674996227, 0.00097247859230265, 0.000974426802713424, 0.000976392650045455, 0.000978367286734283, 0.000980377080850303, 0.00098239560611546, 0.000983103294856846, 0.000982452416792512, 0.000981801538728178, 0.000981159508228302, 0.000980526208877563, 0.000979910488240421, 0.000979294767603278, 0.000978696742095053, 0.000978098600171506, 0.000977518036961555, 0.000976946321316063, 0.000976401090156287, 0.00097584689501673, 0.000975301605649292, 0.000974765047430992, 0.000974246126133949, 0.000973727146629244, 0.000973225862253457, 0.000972733309026808, 0.000972249486949295, 0.000971765781287104, 0.000971299596130848, 0.000970859779044986, 0.000970411289017648, 0.000969980261288583, 0.00096954929176718, 0.000969127053394914, 0.000968722451943904, 0.000968326639849693, 0.00096793967531994, 0.000967561500146985, 0.000967192056123167, 0.000966831459663808, 0.000966488441918045, 0.00096615421352908, 0.000965819985140115, 0.000965503219049424, 0.000965195416938514, 0.00096489634597674, 0.000964597333222628, 0.000964315899182111, 0.000964043254498392, 0.000963788130320609, 0.000963524274993688, 0.000963286787737161, 0.000963049300480634, 0.000962838181294501, 0.000962627120316029, 0.000962424790486693, 0.000962231308221817, 0.000962046557106078, 0.000961870711762458, 0.000961703539360315, 0.000961545272730291, 0.000961395737249404, 0.000961263838689774, 0.000961131881922483, 0.000961017503868788, 0.000960912031587213, 0.00096083281096071, 0.00096074485918507, 0.000960665696766227, 0.000960595323704183, 0.000960533798206598, 0.000960489793214947, 0.000960454635787755, 0.000960410630796105, 0.000960393052082509, 0.000960384262725711, 0.000960384262725711, 0.000960410630796105, 0.000960428209509701, 0.000960454635787755, 0.000960489793214947, 0.000960542587563396, 0.000960595323704183, 0.000960665696766227, 0.00096074485918507, 0.00096083281096071, 0.000960920820944011, 0.000961043871939182, 0.000961158249992877, 0.000961281359195709, 0.000961422105319798, 0.000961562851443887, 0.000961712328717113, 0.000961879501119256, 0.000962055404670537, 0.000962240155786276, 0.000962424790486693, 0.000962627120316029, 0.000962838181294501, 0.000963075668551028, 0.000963313214015216, 0.000963550643064082, 0.000963805709034204, 0.000964069622568786, 0.000964342267252505, 0.000964614911936224, 0.00096489634597674, 0.000965195416938514, 0.000965512066613883, 0.000965828774496913, 0.00096615421352908, 0.000966497231274843, 0.000966857827734202, 0.000967218482401222, 0.000967587868217379, 0.000967966043390334, 0.000968353007920086, 0.000968748820014298, 0.00096914463210851, 0.000969558081123978, 0.000969989050645381, 0.000970420078374445, 0.000970868568401784, 0.000971325964201242, 0.000971809786278754, 0.00097227591322735, 0.000972759677097201, 0.000973260961472988, 0.000973762362264097, 0.000974272552412003, 0.000974800263065845, 0.000975319242570549, 0.000975864531937987, 0.000976418610662222, 0.000976972747594118, 0.000977562041953206, 0.000978151452727616, 0.000978740747086704, 0.000979338772594929, 0.000979945645667613, 0.000980570213869214, 0.000981194665655494, 0.000981827965006232, 0.000982478843070567, 0.000983129721134901, 0.000983815756626427, 0.000984493060968816, 0.000985187944024801, 0.000985882710665464, 0.000986586441285908, 0.000987307634204626, 0.000988028827123344, 0.000988758867606521, 0.000989506486803293, 0.000990262953564525, 0.000991028151474893, 0.00099180219694972, 0.000992602552287281, 0.000993394176475704, 0.000994194531813264, 0.000995012582279742, 0.000995839363895357, 0.000996666145510972, 0.000997510505840182, 0.000998354866169393, 0.000999216921627522, 0.00100008759181947, 0.00100096722599119, 0.00100186432246119, 0.00100276153534651, 0.00100368505809456, 0.00100460858084261, 0.00100554095115513, 0.00100647320505232, 0.00100742315407842, 0.00100839068181813, 0.00100935820955783, 0.00101032573729753, 0.00101131084375083, 0.00101230479776859, 0.00101331621408463, 0.00101433659438044, 0.00101535685826093, 0.00101641227956861, 0.00101745896972716, 0.00101851450745016, 0.00101957877632231, 0.00102065177634358, 0.00102173362392932, 0.00102282431907952, 0.00102393247652799, 0.00102504075039178, 0.00102616660296917, 0.00102731888182461, 0.0010284623131156, 0.00102961447555572, 0.0010307754855603, 0.00103194534312934, 0.00103312393184751, 0.00103431136813015, 0.00103551638312638, 0.00103672139812261, 0.00103794399183244, 0.00103919289540499, 0.00104043318424374, 0.0010416820878163, 0.00104293983895332, 0.00104420643765479, 0.00104549061506987, 0.00104676594492048, 0.00104806770104915, 0.00104936945717782, 0.00105068879202008, 0.00105201697442681, 0.00105335388798267, 0.00105469964910299, 0.00105607172008604, 0.00105743505991995, 0.00105881597846746, 0.00106019678059965, 0.00106159527786076, 0.00106300262268633, 0.00106440111994743, 0.0010658260434866, 0.00106725969817489, 0.00106870220042765, 0.001070162281394, 0.00107162236236036, 0.00107309129089117, 0.00107459526043385, 0.00107608176767826, 0.00107758573722094, 0.00107909867074341, 0.00108061148785055, 0.00108214188367128, 0.00108368112705648, 0.00108522910159081, 0.00108678604010493, 0.00108836044091731, 0.0010899348417297, 0.00109152682125568, 0.00109314522705972, 0.00109474605415016, 0.00109635561238974, 0.00109798286575824, 0.00109962758142501, 0.0011012724135071, 0.00110292597673833, 0.00110459711868316, 0.00110626826062799, 0.00110795709770173, 0.00110966339707375, 0.00111136969644576, 0.00111308484338224, 0.00111480883788317, 0.00111653271596879, 0.00111827428918332, 0.00112003344111145, 0.00112179247662425, 0.00112356920726597, 0.00112535478547215, 0.00112714024726301, 0.00112896098289639, 0.0011307728709653, 0.00113259360659868, 0.00113442307338119, 0.00113627011887729, 0.0011381171643734, 0.00113996432628483, 0.00114183768164366, 0.00114372000098228, 0.0011456023203209, 0.0011475021019578, 0.00114941073115915, 0.00115132820792496, 0.00115327199455351, 0.00115521589759737, 0.00115715968422592, 0.00115911231841892, 0.00116107380017638, 0.00116305274423212, 0.00116503180470318, 0.00116702844388783, 0.00116903381422162, 0.00117105676326901, 0.00117307982873172, 0.00117511150892824, 0.00117715215310454, 0.00117922783829272, 0.00118127721361816, 0.00118335301522166, 0.00118543766438961, 0.00118753092829138, 0.00118963315617293, 0.00119174411520362, 0.00119386380538344, 0.00119599234312773, 0.00119813845958561, 0.00120028457604349, 0.00120246584992856, 0.00120463839266449, 0.00120680220425129, 0.00120899232570082, 0.00121119117829949, 0.00121340760961175, 0.00121562415733933, 0.00121784943621606, 0.00122008356265724, 0.00122233526781201, 0.00122461328282952, 0.00122687371913344, 0.00122915173415095, 0.00123143871314824, 0.00123372545931488, 0.00123603001702577, 0.00123834318947047, 0.00124067405704409, 0.00124300480820239, 0.00124535337090492, 0.00124771054834127, 0.00125008542090654, 0.00125246029347181, 0.0012548437807709, 0.00125723611563444, 0.00125962856691331, 0.00126204744447023, 0.00126446620561182, 0.00126689381431788, 0.00126933900173753, 0.00127178418915719, 0.00127424683887511, 0.00127671845257282, 0.00127919891383499, 0.00128170556854457, 0.00128419464454055, 0.00128671026322991, 0.00128922576550394, 0.00129175011534244, 0.00129429204389453, 0.00129684282001108, 0.00129939359612763, 0.00130196183454245, 0.00130453903693706, 0.00130712485406548, 0.00130972848273814, 0.00131233187858015, 0.00131495296955109, 0.00131758290808648, 0.00132021284662187, 0.00132286036387086, 0.00132551661226898, 0.00132818159181625, 0.00133085553534329, 0.00133353809360415, 0.00133622961584479, 0.00133892986923456, 0.00134164770133793, 0.0013443831121549, 0.00134711852297187, 0.0013498452026397, 0.00135259830858558, 0.00135536002926528, 0.00135813059750944, 0.00136091001331806, 0.00136370700784028, 0.00136650411877781, 0.00136930984444916, 0.00137215084396303, 0.0013749742647633, 0.0013778064167127, 0.00138065626379102, 0.00138351472560316, 0.00138638215139508, 0.00138925842475146, 0.00139214331284165, 0.00139504577964544, 0.00139794836286455, 0.00140086852479726, 0.00140378868672997, 0.00140674400608987, 0.00140968186315149, 0.00141263706609607, 0.00141560123302042, 0.00141857424750924, 0.00142155587673187, 0.00142454646993428, 0.00142755440901965, 0.00143056258093566, 0.00143358833156526, 0.00143662269692868, 0.00143966602627188, 0.00144271808676422, 0.00144578772597015, 0.0014488574815914, 0.00145193596836179, 0.00145503191743046, 0.00145812798291445, 0.00146124162711203, 0.00146435527130961, 0.00146748661063612, 0.00147062668111175, 0.00147377536632121, 0.00147693301551044, 0.00148009951226413, 0.0014832658926025, 0.00148647627793252, 0.00148966908454895, 0.00149287946987897, 0.00149608985520899, 0.00149931793566793, 0.00150255463086069, 0.0015058001736179, 0.00150905456393957, 0.00151231768541038, 0.00151559850201011, 0.00151888816617429, 0.00152218644507229, 0.00152548484038562, 0.00152880081441253, 0.00153212551958859, 0.0015354590723291, 0.00153880135621876, 0.00154215248767287, 0.00154551235027611, 0.00154888117685914, 0.00155225861817598, 0.0015556626021862, 0.00155906635336578, 0.00156247918494046, 0.00156589190009981, 0.00156932219397277, 0.00157276121899486, 0.00157620920799673, 0.00157967465929687, 0.00158314011059701, 0.0015866142930463, 0.00159010617062449, 0.00159360689576715, 0.00159711623564363, 0.00160063442308456, 0.00160416157450527, 0.00160769745707512, 0.00161124195437878, 0.00161480426322669, 0.00161836645565927, 0.00162193749565631, 0.00162552611436695, 0.00162911473307759, 0.00163272093050182, 0.00163633585907519, 0.0016399510204792, 0.00164360110647976, 0.00164724257774651, 0.00165089266374707, 0.00165456044487655, 0.00165822822600603, 0.00166191358584911, 0.00166559894569218, 0.00166930188424885, 0.00167301367036998, 0.00167673418764025, 0.00168045470491052, 0.0016841929173097, 0.00168796617072076, 0.00169172196183354, 0.00169548648409545, 0.00169926846865565, 0.00170305941719562, 0.00170685921330005, 0.0017106676241383, 0.00171447615139186, 0.00171829352620989, 0.00172213721089065, 0.00172599847428501, 0.0017298508901149, 0.00173372100107372, 0.00173759984318167, 0.00174147868528962, 0.00174537522252649, 0.00174928037449718, 0.00175319437403232, 0.00175711733754724, 0.00176104891579598, 0.00176498049404472, 0.00176895619370043, 0.00177291419822723, 0.00177688978146762, 0.00178087421227247, 0.00178486749064177, 0.0017888693837449, 0.00179287139326334, 0.00179689994547516, 0.00180092826485634, 0.0018049655482173, 0.00180902017746121, 0.00181307492312044, 0.00181715609505773, 0.00182122853584588, 0.00182531855534762, 0.0018294173059985, 0.0018335246713832, 0.00183764123357832, 0.0018417751416564, 0.00184590904973447, 0.00185005180537701, 0.00185421202331781, 0.00185837247408926, 0.00186254153959453, 0.00186672830022871, 0.00187094125431031, 0.00187514559365809, 0.00187935878057033, 0.00188358931336552, 0.00188782007899135, 0.00189205957576632, 0.00189631665125489, 0.00190057384315878, 0.00190483964979649, 0.00190912315156311, 0.00191341526806355, 0.00191771646495908, 0.00192204385530204, 0.00192637136206031, 0.00193069863598794, 0.00193503499031067, 0.00193938880693167, 0.00194375147111714, 0.00194812275003642, 0.00195248541422188, 0.00195689196698368, 0.00196127220988274, 0.00196568761020899, 0.00197012070566416, 0.00197454495355487, 0.00197898666374385, 0.00198342837393284, 0.00198788777925074, 0.0019923560321331, 0.00199683289974928, 0.00200131884776056, 0.00200580433011055, 0.0020103077404201, 0.00201483746059239, 0.0020193497184664, 0.0020238971337676, 0.00202844431623816, 0.00203300057910383, 0.00203755660913885, 0.00204213033430278, 0.00204671290703118, 0.00205131294205785, 0.00205591320991516, 0.0020605307072401, 0.00206513074226677, 0.00206978362984955, 0.0020744102075696, 0.00207907194271684, 0.00208371598273516, 0.00208840402774513, 0.00209308345802128, 0.00209777150303125, 0.00210246816277504, 0.00210718275047839, 0.00211188825778663, 0.00211662915535271, 0.00212135259062052, 0.00212611979804933, 0.00213086046278477, 0.0021356453653425, 0.00214042118750513, 0.00214520609006286, 0.0021499996073544, 0.00215481105260551, 0.00215961341746151, 0.00216445093974471, 0.00216927076689899, 0.00217411736957729, 0.0021789725869894, 0.00218385411426425, 0.00218872679397464, 0.00219360832124949, 0.00219850754365325, 0.00220340653322637, 0.00220831483602524, 0.00221324036829174, 0.00221815705299377, 0.002223108895123, 0.00222805188968778, 0.00223301257938147, 0.00223798234947026, 0.00224296934902668, 0.00224797404371202, 0.00225297012366354, 0.0022579834330827, 0.0022629969753325, 0.00226802797988057, 0.00227306806482375, 0.00227809906937182, 0.00228315661661327, 0.00228822277858853, 0.00229330663569272, 0.00229840818792582, 0.00230349204503, 0.00230861105956137, 0.00231372122652829, 0.00231884908862412, 0.00232398579828441, 0.00232913112267852, 0.00233427667990327, 0.00233944854699075, 0.00234461156651378, 0.00234980974346399, 0.00235499022528529, 0.00236020609736443, 0.00236540427431464, 0.00237064645625651, 0.00237586232833564, 0.00238112197257578, 0.00238635553978384, 0.00239163287915289, 0.00239689275622368, 0.0024021789431572, 0.00240746513009071, 0.00241277739405632, 0.0024180724285543, 0.00242341123521328, 0.00242872396484017, 0.00243407161906362, 0.00243942812085152, 0.00244478462263942, 0.00245014135725796, 0.0024555241689086, 0.00246090721338987, 0.00246629863977432, 0.00247170799411833, 0.0024771261960268, 0.00248254416510463, 0.00248799775727093, 0.00249345088377595, 0.00249890424311161, 0.00250436621718109, 0.00250983703881502, 0.00251532532274723, 0.00252080522477627, 0.00252631120383739, 0.00253182626329362, 0.00253734993748367, 0.00254288222640753, 0.00254844105802476, 0.00255399104207754, 0.00255954987369478, 0.00256511755287647, 0.00257070269435644, 0.0025762792211026, 0.0025818906724453, 0.00258749350905418, 0.00259311380796134, 0.00259874318726361, 0.00260439864359796, 0.00261002779006958, 0.00261570117436349, 0.00262135663069785, 0.00262704747729003, 0.00263273832388222, 0.00263843778520823, 0.00264412863180041, 0.00264985440298915, 0.00265557179227471, 0.00266131502576172, 0.00266705872491002, 0.00267282873392105, 0.00267857196740806, 0.00268436851911247, 0.00269013829529285, 0.00269594346173108, 0.0027017486281693, 0.00270756264217198, 0.00271337619051337, 0.00271920789964497, 0.00272504799067974, 0.00273090600967407, 0.00273676379583776, 0.00274264835752547, 0.00274851499125361, 0.00275442562997341, 0.00276032742112875, 0.0027662378270179, 0.0027721575461328, 0.00277807703241706, 0.00278401398099959, 0.00278995977714658, 0.00279592326842248, 0.00280189560726285, 0.00280786771327257, 0.00281385751441121, 0.00281985593028367, 0.00282588112168014, 0.00283189746551216, 0.00283792219124734, 0.00284395599737763, 0.00284998980350792, 0.00285605899989605, 0.00286211003549397, 0.00286818784661591, 0.00287427450530231, 0.00288036977872252, 0.00288647413253784, 0.00289260456338525, 0.00289872637949884, 0.00290485681034625, 0.00291099608875811, 0.00291715329512954, 0.00292331003583968, 0.00292947585694492, 0.00293565937317908, 0.00294185127131641, 0.00294805224984884, 0.00295427930541337, 0.0029604802839458, 0.0029667338822037, 0.00297295255586505, 0.00297921523451805, 0.00298546859994531, 0.00299174012616277, 0.00299801118671894, 0.00300430017523468, 0.00301059754565358, 0.00301691284403205, 0.00302322814241052, 0.00302956998348236, 0.00303588528186083, 0.00304225319996476, 0.00304859480820596, 0.003054971806705, 0.00306133972480893, 0.00306772533804178, 0.00307411979883909, 0.00308052287437022, 0.0030869347974658, 0.0030933644156903, 0.00309979426674545, 0.00310625019483268, 0.003112688427791, 0.00311917066574097, 0.00312564452178776, 0.00313211791217327, 0.0031386180780828, 0.00314510916359723, 0.00315161794424057, 0.00315813533961773, 0.00316467066295445, 0.00317121436819434, 0.00317775830626488, 0.00318431993946433, 0.00319090764969587, 0.00319746928289533, 0.00320407492108643   }, 
   { 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 4.70609387912121e-15, 7.747279596515e-06, 2.35369716392597e-05, 3.93266673199832e-05, 5.51311204617377e-05, 7.09355663275346e-05, 8.67547787493095e-05, 0.000102573976619169, 0.000118393181764986, 0.00013422715710476, 0.000150061110616662, 0.000165895078680478, 0.000181743787834421, 0.000197592526092194, 0.000213441235246137, 0.000229304714594036, 0.000245160801569, 0.000261031673289835, 0.000276895152637735, 0.000292780780000612, 0.000308666378259659, 0.0003245446132496, 0.000340437603881583, 0.000356330565409735, 0.000372223556041718, 0.000388131331419572, 0.000404053833335638, 0.000419976335251704, 0.000435891444794834, 0.000451806612545624, 0.000467736477730796, 0.000483666372019798, 0.000499603629577905, 0.000515570398420095, 0.000531507655978203, 0.000547459640074521, 0.000563419074751437, 0.000579385843593627, 0.000595352612435818, 0.000611326715443283, 0.000627308327239007, 0.000643289764411747, 0.000659278710372746, 0.000675267656333745, 0.000691263936460018, 0.000707274943124503, 0.000723286066204309, 0.000739297072868794, 0.000755308079533279, 0.000771319144405425, 0.000787344994023442, 0.00080338551197201, 0.000819433422293514, 0.000835474056657404, 0.000851507240440696, 0.000867562484927475, 0.000883617845829576, 0.000899673148524016, 0.000915743235964328, 0.000931813265196979, 0.000947890686802566, 0.000963968166615814, 0.000980052980594337, 0.000996145186945796, 0.00101224484387785, 0.00102834438439459, 0.00104445137549192, 0.00106055091600865, 0.00107666524127126, 0.00109278701711446, 0.00110891612712294, 0.00112504512071609, 0.00114118168130517, 0.00115731067489833, 0.001173454686068, 0.00118959846440703, 0.00120574235916138, 0.00122191570699215, 0.00123808172065765, 0.00125424773432314, 0.00127040618099272, 0.00128658697940409, 0.00130276777781546, 0.00131895591039211, 0.0013351587112993, 0.00135134696029127, 0.00136754976119846, 0.00138375267852098, 0.00139996293000877, 0.00141618063207716, 0.0014324055518955, 0.00144863058812916, 0.0014648555079475, 0.00148109544534236, 0.0014973352663219, 0.00151356752030551, 0.0015298294601962, 0.0015460840659216, 0.00156234588939697, 0.00157860782928765, 0.00159486231859773, 0.00161113904323429, 0.00162741565145552, 0.0016437218291685, 0.00166000588797033, 0.00167629006318748, 0.00169258879031986, 0.00170888751745224, 0.00172519369516522, 0.00174150732345879, 0.00175783562008291, 0.00177415658254176, 0.00179047742858529, 0.00180681317579001, 0.00182314880657941, 0.00183949188794941, 0.0018558424199, 0.00187219271901995, 0.00188855070155114, 0.00190490111708641, 0.00192126631736755, 0.00193764618597925, 0.00195402628742158, 0.00197040615603328, 0.00198678602464497, 0.0020031735766679, 0.0020195608958602, 0.00203595543280244, 0.00205236510373652, 0.00206878921017051, 0.00208519888110459, 0.00210160808637738, 0.00211803242564201, 0.0021344639826566, 0.00215089577250183, 0.00216733478009701, 0.00218378845602274, 0.00220022746361792, 0.00221668113954365, 0.00223313481546938, 0.00224960339255631, 0.00226607918739319, 0.00228254776448011, 0.00229902379214764, 0.00231550680473447, 0.00233199028298259, 0.00234847329556942, 0.00236498634330928, 0.00238148425705731, 0.00239798962138593, 0.00241450243629515, 0.00243100780062377, 0.00244752806611359, 0.00246404809877276, 0.00248060515150428, 0.00249713286757469, 0.00251366780139506, 0.00253020995296538, 0.00254675932228565, 0.00256331660784781, 0.00257987366057932, 0.00259644538164139, 0.0026130098849535, 0.00262958160601556, 0.00264616077765822, 0.00266274739988148, 0.00267933402210474, 0.0026959350798279, 0.00271253660321236, 0.00272913789376616, 0.00274573895148933, 0.00276234047487378, 0.00277895643375814, 0.00279560219496489, 0.0028122253715992, 0.00282885646447539, 0.0028454945422709, 0.00286212540231645, 0.0028787711635232, 0.0028954241424799, 0.00291209178976715, 0.0029287519864738, 0.0029454124160111, 0.00296208006329834, 0.00297875516116619, 0.00299543770961463, 0.00301212002523243, 0.00302881747484207, 0.00304550724104047, 0.00306221190840006, 0.00307891657575965, 0.00309562124311924, 0.00311234034597874, 0.00312905991449952, 0.00314578670077026, 0.00316251325421035, 0.00317924749106169, 0.00319598172791302, 0.00321273040026426, 0.00322947930544615, 0.00324623542837799, 0.00326299178414047, 0.00327974790707231, 0.00329651194624603, 0.00331328273750842, 0.0033300758805126, 0.00334686157293618, 0.00336364004760981, 0.00338042574003339, 0.00339722633361816, 0.00341402692720294, 0.00343083473853767, 0.00344765023328364, 0.00346446526236832, 0.00348128797486424, 0.00349811092019081, 0.00351494085043669, 0.00353178544901311, 0.00354862306267023, 0.00356546766124666, 0.00358231249265373, 0.00359917199239135, 0.00361601682379842, 0.00363288400694728, 0.00364976562559605, 0.00366664724424481, 0.00368352164514363, 0.0037004032637924, 0.00371728488244116, 0.00373417395167053, 0.00375107047148049, 0.00376799656078219, 0.00378490751609206, 0.00380180403590202, 0.00381872267462313, 0.0038356410805136, 0.0038525671698153, 0.00386950792744756, 0.00388644868507981, 0.00390338920988142, 0.00392033020034432, 0.00393728539347649, 0.00395424105226994, 0.00397121114656329, 0.00398817425593734, 0.00400515180081129, 0.00402212189510465, 0.0040391068905592, 0.00405607698485255, 0.0040730619803071, 0.00409007677808404, 0.0041070762090385, 0.00412407610565424, 0.00414107600226998, 0.00415809033438563, 0.00417511211708188, 0.00419213436543941, 0.00420918548479676, 0.00422620726749301, 0.00424325140193105, 0.00426028808578849, 0.00427733967080712, 0.00429439079016447, 0.0043114572763443, 0.00432851584628224, 0.00434558186680079, 0.00436265533789992, 0.00437973625957966, 0.00439682463183999, 0.00441390555351973, 0.00443100137636065, 0.0044480967335403, 0.00446520000696182, 0.00448229536414146, 0.00449940608814359, 0.00451653869822621, 0.00453366385772824, 0.00455078156664968, 0.0045679141767323, 0.00458503933623433, 0.00460217939689755, 0.00461932644248009, 0.0046364888548851, 0.00465365033596754, 0.00467079784721136, 0.00468795979395509, 0.00470512919127941, 0.00472229905426502, 0.00473948335275054, 0.00475666718557477, 0.0047738584689796, 0.00479105021804571, 0.00480825686827302, 0.00482545606791973, 0.00484266923740506, 0.00485987542197108, 0.00487709697335958, 0.0048943255096674, 0.00491155404597521, 0.00492877466604114, 0.00494601065292954, 0.00496326852589846, 0.00498051196336746, 0.00499776285141706, 0.00501501327380538, 0.00503227859735489, 0.0050495439209044, 0.00506680924445391, 0.00508410390466452, 0.00510136969387531, 0.00511866435408592, 0.00513594457879663, 0.00515323970466852, 0.00517054880037904, 0.00518785882741213, 0.00520516838878393, 0.00522247841581702, 0.00523980241268873, 0.00525712687522173, 0.00527445878833532, 0.00529179070144892, 0.00530912959948182, 0.00532647594809532, 0.00534382229670882, 0.00536116911098361, 0.0053785303607583, 0.0053958841599524, 0.00541326776146889, 0.00543064391240478, 0.00544801214709878, 0.00546538829803467, 0.00548277888447046, 0.00550016993656754, 0.00551756843924522, 0.00553498836234212, 0.0055523868650198, 0.00556979235261679, 0.00558721274137497, 0.00560463266447186, 0.00562206050381064, 0.00563949579373002, 0.00565693061798811, 0.0056743728928268, 0.00569181516766548, 0.00570926582440734, 0.00572672998532653, 0.00574418716132641, 0.00576165923848748, 0.00577912386506796, 0.00579659594222903, 0.00581406801939011, 0.00583154708147049, 0.00584905594587326, 0.00586654990911484, 0.0058840517885983, 0.00590153830125928, 0.00591904670000076, 0.00593655603006482, 0.00595407979562879, 0.00597161799669266, 0.00598913384601474, 0.0060066650621593, 0.00602421117946506, 0.00604174938052893, 0.0060592950321734, 0.00607684766873717, 0.00609440868720412, 0.00611196924000978, 0.00612953677773476, 0.00614710478112102, 0.00616468023508787, 0.00618227012455463, 0.0061998600140214, 0.00621744990348816, 0.00623504025861621, 0.00625263759866357, 0.00627024192363024, 0.00628785416483879, 0.00630548130720854, 0.00632309354841709, 0.00634071277454495, 0.0063583473674953, 0.00637598196044564, 0.0063936160877347, 0.00641126465052366, 0.00642892858013511, 0.00644657015800476, 0.0064642271026969, 0.00648189056664705, 0.0064995544962585, 0.00651723286136985, 0.0065349112264812, 0.00655259750783443, 0.00657028332352638, 0.00658797705546021, 0.00660566985607147, 0.00662337802350521, 0.00664108619093895, 0.006658801343292, 0.00667651696130633, 0.00669424002990127, 0.00671195518225431, 0.00672968570142984, 0.00674743764102459, 0.00676517514511943, 0.00678292801603675, 0.0068006650544703, 0.00681841792538762, 0.00683618430048227, 0.00685394462198019, 0.00687171891331673, 0.00688949320465326, 0.0069072749465704, 0.00692506413906813, 0.00694284634664655, 0.00696064298972487, 0.0069784470833838, 0.00699625071138144, 0.00701406225562096, 0.00703187379986048, 0.0070496927946806, 0.00706750340759754, 0.00708535220474005, 0.00710317818447948, 0.0071210190653801, 0.00713885994628072, 0.00715670082718134, 0.00717455660924315, 0.00719241192564368, 0.0072102821432054, 0.00722815282642841, 0.00724601605907083, 0.00726389372721314, 0.00728177139535546, 0.00729965604841709, 0.00731754908338189, 0.00733546400442719, 0.00735334865748882, 0.00737125612795353, 0.00738916313275695, 0.00740707805380225, 0.00742499995976686, 0.00744293723255396, 0.00746086658909917, 0.00747879594564438, 0.0074967397376895, 0.00751467701047659, 0.00753261335194111, 0.00755058694630861, 0.00756854610517621, 0.0075865127146244, 0.00760447885841131, 0.00762244500219822, 0.00764042604714632, 0.00765839964151382, 0.00767640303820372, 0.00769439851865172, 0.00771238747984171, 0.00773039041087031, 0.00774840079247952, 0.00776640418916941, 0.00778442248702049, 0.0078024547547102, 0.00782048050314188, 0.00783851277083158, 0.00785654596984386, 0.00787458568811417, 0.00789264030754566, 0.00791068840771914, 0.00792874302715063, 0.00794680509716272, 0.00796486716717482, 0.00798292923718691, 0.00800102110952139, 0.00801909808069468, 0.00803718250244856, 0.00805528182536364, 0.00807335879653692, 0.0080914655700326, 0.00810956489294767, 0.00812769308686256, 0.00814579986035824, 0.00816390663385391, 0.0081820348277688, 0.00820016302168369, 0.00821829959750175, 0.00823643524199724, 0.0082545792683959, 0.00827272236347198, 0.00829088781028986, 0.00830903835594654, 0.00832720380276442, 0.00834536924958229, 0.00836354959756136, 0.00838172342628241, 0.0083999028429389, 0.00841809064149857, 0.00843627844005823, 0.0084544662386179, 0.00847268290817738, 0.00849088560789824, 0.00850489735603333, 0.00851445179432631, 0.00852405838668346, 0.00853367242962122, 0.00854337494820356, 0.0085530923679471, 0.00856283120810986, 0.00857262685894966, 0.0085824579000473, 0.00859235320240259, 0.00860225036740303, 0.00861217826604843, 0.00862220209091902, 0.00863219611346722, 0.0086423410102725, 0.00865242350846529, 0.00866254325956106, 0.00867278408259153, 0.0086829662322998, 0.00869326665997505, 0.00870354473590851, 0.00871387775987387, 0.00872430019080639, 0.00873471051454544, 0.00874520279467106, 0.00875569507479668, 0.00876625347882509, 0.0087768342345953, 0.00878745131194592, 0.0087981354445219, 0.00880881957709789, 0.00881954003125429, 0.00883037131279707, 0.00884115137159824, 0.00885204877704382, 0.00886295083910227, 0.00887385196983814, 0.00888488255441189, 0.00889587681740522, 0.00890696607530117, 0.00891805998980999, 0.00892918277531862, 0.00894039776176214, 0.00895158294588327, 0.00896289385855198, 0.00897414237260818, 0.00898548681288958, 0.00899688620120287, 0.00900828931480646, 0.00901976320892572, 0.00903126131743193, 0.00904279481619596, 0.00905438605695963, 0.00906597729772329, 0.00907766073942184, 0.0090893218293786, 0.00910104624927044, 0.00911285914480686, 0.0091246347874403, 0.00913654454052448, 0.00914838910102844, 0.00916029885411263, 0.00917232874780893, 0.00918430369347334, 0.00919639691710472, 0.00920846406370401, 0.00922059081494808, 0.00923277996480465, 0.00924497656524181, 0.00925723183900118, 0.00926951691508293, 0.0092818308621645, 0.00929424166679382, 0.00930661521852016, 0.00931908469647169, 0.00933156907558441, 0.00934407487511635, 0.00935667287558317, 0.00936923548579216, 0.00938193034380674, 0.00939459446817636, 0.00940728560090065, 0.00942010898143053, 0.00943286623805761, 0.00944577530026436, 0.00945859868079424, 0.00947151426225901, 0.00948454439640045, 0.0094975009560585, 0.00951059721410275, 0.00952363852411509, 0.0095367431640625, 0.00954993907362223, 0.00956313125789165, 0.00957636348903179, 0.00958965625613928, 0.00960291549563408, 0.00961633026599884, 0.00962971802800894, 0.00964315608143806, 0.00965664442628622, 0.0096701243892312, 0.00968373008072376, 0.00969730596989393, 0.00971096754074097, 0.00972460769116879, 0.00973830837756395, 0.00975213479250669, 0.00976589974015951, 0.00977974850684404, 0.00979360938072205, 0.00980749540030956, 0.00982147641479969, 0.00983545929193497, 0.00984950829297304, 0.00986358523368835, 0.00987766310572624, 0.00989186204969883, 0.00990603305399418, 0.00992027297616005, 0.00993453618139029, 0.00994880497455597, 0.00996322277933359, 0.00997758097946644, 0.00999203138053417, 0.0100064855068922, 0.0100209806114435, 0.0100355567410588, 0.0100501095876098, 0.0100647741928697, 0.0100794173777103, 0.0100940931588411, 0.0101088639348745, 0.0101236645132303, 0.0101384958252311, 0.0101533560082316, 0.0101682525128126, 0.0101832086220384, 0.0101981936022639, 0.010213216766715, 0.010228268802166, 0.010243353433907, 0.0102585274726152, 0.0102737033739686, 0.0102889407426119, 0.0103041874244809, 0.0103194620460272, 0.010334855876863, 0.0103501882404089, 0.0103655867278576, 0.0103810746222734, 0.010396565310657, 0.0104121565818787, 0.0104276826605201, 0.0104432962834835, 0.0104589713737369, 0.0104746539145708, 0.0104904249310493, 0.0105061708018184, 0.0105219865217805, 0.010537845082581, 0.01055374648422, 0.0105697093531489, 0.010585667565465, 0.0106016350910068, 0.0106177236884832, 0.0106337824836373, 0.0106499642133713, 0.0106661142781377, 0.010682332329452, 0.0106985792517662, 0.0107148569077253, 0.0107312593609095, 0.0107475686818361, 0.0107639748603106, 0.010780431330204, 0.010796925984323, 0.0108134653419256, 0.0108300251886249, 0.0108466483652592, 0.0108632938936353, 0.0108799543231726, 0.0108967302367091, 0.0109134772792459, 0.010930267162621, 0.0109471343457699, 0.010963979177177, 0.0109809497371316, 0.0109979165717959, 0.0110148871317506, 0.0110319489613175, 0.0110490154474974, 0.0110662002116442, 0.0110833244398236, 0.0111005157232285, 0.0111177656799555, 0.0111350249499083, 0.0111524006351829, 0.0111697465181351, 0.0111871222034097, 0.011204594746232, 0.011222030967474, 0.0112395947799087, 0.0112571362406015, 0.0112747047096491, 0.0112923951819539, 0.0113100204616785, 0.0113277770578861, 0.0113455289974809, 0.0113632865250111, 0.0113812005147338, 0.011399014852941, 0.0114169884473085, 0.0114349024370313, 0.0114528769627213, 0.0114709725603461, 0.0114889862015843, 0.0115071451291442, 0.0115252817049623, 0.0115434760227799, 0.0115617299452424, 0.0115799615159631, 0.0115983113646507, 0.0116166621446609, 0.011635048314929, 0.0116534912958741, 0.0116719342768192, 0.0116904750466347, 0.0117090130224824, 0.0117275658994913, 0.0117462566122413, 0.0117648597806692, 0.0117836194112897, 0.0118023464456201, 0.0118211088702083, 0.0118399895727634, 0.0118588199838996, 0.0118777677416801, 0.0118966856971383, 0.0119156409054995, 0.0119347106665373, 0.0119537571445107, 0.0119728930294514, 0.0119919991120696, 0.0120111675933003, 0.0120304329320788, 0.0120496619492769, 0.0120689924806356, 0.0120883202180266, 0.0121076768264174, 0.0121271600946784, 0.0121466126292944, 0.0121661210432649, 0.0121856369078159, 0.0122051928192377, 0.0122248604893684, 0.0122444713488221, 0.0122642014175653, 0.0122839091345668, 0.012303676456213, 0.012323560193181, 0.0123433712869883, 0.0123633183538914, 0.0123832141980529, 0.0124031696468592, 0.0124232163652778, 0.0124432668089867, 0.0124633796513081, 0.012483493424952, 0.0125036668032408, 0.0125239063054323, 0.0125441439449787, 0.0125644383952022, 0.0125847766175866, 0.0126051111146808, 0.0126255676150322, 0.0126459952443838, 0.0126665104180574, 0.0126870330423117, 0.0127075836062431, 0.0127282347530127, 0.0127488533034921, 0.0127695864066482, 0.0127902645617723, 0.0128110414370894, 0.0128318713977933, 0.0128527078777552, 0.0128736104816198, 0.0128945093601942, 0.0129154678434134, 0.0129364924505353, 0.0129575468599796, 0.0129786338657141, 0.0129997553303838, 0.0130208758637309, 0.0130421472713351, 0.0130633600056171, 0.0130846602842212, 0.013105976395309, 0.0131273148581386, 0.0131487790495157, 0.0131701799109578, 0.0131916683167219, 0.0132131651043892, 0.0132347214967012, 0.0132563812658191, 0.013277973048389, 0.0132996588945389, 0.013321366161108, 0.0133431423455477, 0.0133649539202452, 0.0133867980912328, 0.0134086366742849, 0.0134305721148849, 0.0134525382891297, 0.0134745398536325, 0.0134965693578124, 0.0135186305269599, 0.0135407838970423, 0.0135628813877702, 0.0135851288214326, 0.0136073483154178, 0.0136296013370156, 0.0136519381776452, 0.0136742573231459, 0.0136967245489359, 0.0137191042304039, 0.0137415705248713, 0.0137640973553061, 0.0137866297736764, 0.013809259980917, 0.0138318901881576, 0.0138545483350754, 0.0138772670179605, 0.0138999922201037, 0.0139228049665689, 0.0139456205070019, 0.0139684714376926, 0.0139914099127054, 0.0140143241733313, 0.0140373539179564, 0.0140603901818395, 0.0140833957120776, 0.0141065558418632, 0.0141296582296491, 0.0141529114916921, 0.0141761051490903, 0.0141993621364236, 0.014222645200789, 0.014245992526412, 0.0142694404348731, 0.0142928268760443, 0.0143162719905376, 0.0143397711217403, 0.0143633121624589, 0.0143869128078222, 0.0144105451181531, 0.0144341560080647, 0.0144579140469432, 0.0144816059619188, 0.0145054226741195, 0.0145292477682233, 0.0145530728623271, 0.0145770153030753, 0.0146009065210819, 0.0146249420940876, 0.0146489245817065, 0.0146729638800025, 0.0146971279755235, 0.0147212073206902, 0.0147454347461462, 0.0147696053609252, 0.0147938653826714, 0.0148181850090623, 0.0148424776270986, 0.0148669043555856, 0.0148912901058793, 0.0149157410487533, 0.0149402525275946, 0.0149647621437907, 0.0149893658235669, 0.0150139471516013, 0.0150385908782482, 0.0150633230805397, 0.0150879891589284, 0.0151128172874451, 0.0151376081630588, 0.0151624400168657, 0.0151873612776399, 0.0152122555300593, 0.0152372689917684, 0.0152622545138001, 0.0152873005717993, 0.0153124090284109, 0.0153374951332808, 0.0153626967221498, 0.0153878713026643, 0.0154131101444364, 0.0154384355992079, 0.015463731251657, 0.0154891218990088, 0.0155145255848765, 0.0155399208888412, 0.0155654652044177, 0.0155909508466721, 0.0156165594235063, 0.0156421456485987, 0.0156677290797234, 0.0156934726983309, 0.0157191790640354, 0.0157449431717396, 0.0157707445323467, 0.0157965514808893, 0.0158224757760763, 0.0158483739942312, 0.0158743970096111, 0.0159003250300884, 0.0159263778477907, 0.0159524921327829, 0.0159785784780979, 0.0160047300159931, 0.0160309392958879, 0.0160571523010731, 0.0160834547132254, 0.0161097589880228, 0.016136122867465, 0.0161625295877457, 0.0161889288574457, 0.0162154547870159, 0.016241917386651, 0.016268527135253, 0.0162950847297907, 0.0163217037916183, 0.0163484159857035, 0.0163750778883696, 0.0164018757641315, 0.0164286233484745, 0.0164554640650749, 0.0164823662489653, 0.0165092386305332, 0.0165362320840359, 0.0165631975978613, 0.0165902283042669, 0.0166173167526722, 0.0166444107890129, 0.0166715625673532, 0.0166987478733063, 0.0167259350419044, 0.0167532712221146, 0.0167805552482605, 0.0168078932911158, 0.0168352667242289, 0.0168626811355352, 0.0168902054429054, 0.0169176459312439, 0.0169452335685492, 0.0169727653264999, 0.0170003902167082, 0.0170281082391739, 0.0170557722449303, 0.0170835480093956, 0.0171113014221191, 0.0171391144394875, 0.0171670205891132, 0.0171948987990618, 0.0172227770090103, 0.0172508116811514, 0.0172787867486477, 0.0173069108277559, 0.0173349753022194, 0.0173631031066179, 0.0173912961035967, 0.0174194891005754, 0.0174478031694889, 0.0174760594964027, 0.0175043772906065, 0.017532778903842, 0.0175611898303032, 0.0175897032022476, 0.0176181476563215, 0.0176466833800077, 0.0176752787083387, 0.0177038460969925, 0.0177325382828712, 0.0177612323313951, 0.0177899338304996, 0.0178187470883131, 0.0178475379943848, 0.0178764164447784, 0.0179052986204624, 0.0179341845214367, 0.0179631970822811, 0.0179921705275774, 0.018021272495389, 0.018050342798233, 0.0180794503539801, 0.0181086454540491, 0.0181378424167633, 0.0181671008467674, 0.018196364864707, 0.0182237569242716, 0.0182490181177855, 0.0182744599878788, 0.0182999894022942, 0.0183256957679987, 0.0183513723313808, 0.0183773431926966, 0.0184032563120127, 0.0184294637292624, 0.0184557624161243, 0.0184821765869856, 0.0185087379068136, 0.0185353588312864, 0.0185620989650488, 0.0185890141874552, 0.0186160486191511, 0.0186432600021362, 0.0186705309897661, 0.01869797706604, 0.0187253952026367, 0.0187530498951674, 0.0187809094786644, 0.0188087727874517, 0.01883689686656, 0.0188650228083134, 0.0188933573663235, 0.0189216900616884, 0.0189501978456974, 0.0189788583666086, 0.0190077517181635, 0.0190366450697184, 0.0190657433122396, 0.0190948750823736, 0.0191240925341845, 0.0191535484045744, 0.0191830918192863, 0.0192128121852875, 0.0192426182329655, 0.0192725174129009, 0.01930264942348, 0.0193326957523823, 0.0193630643188953, 0.0193934328854084, 0.0194240100681782, 0.0194547902792692, 0.0194855723530054, 0.0195164456963539, 0.0195474624633789, 0.0195786599069834, 0.0196100622415543, 0.0196414925158024, 0.0196731016039848, 0.0197047702968121, 0.0197364389896393, 0.0197684299200773, 0.0198005121201277, 0.0198328290134668, 0.019865058362484, 0.0198975224047899, 0.0199301056563854, 0.0199627466499805, 0.0199956241995096, 0.0200285036116838, 0.0200616177171469, 0.0200948491692543, 0.0201281979680061, 0.0201616082340479, 0.0201951954513788, 0.0202288404107094, 0.0202627517282963, 0.0202966928482056, 0.0203308388590813, 0.0203649587929249, 0.020399309694767, 0.020433783531189, 0.0204683411866426, 0.0205030795186758, 0.0205379649996758, 0.0205728504806757, 0.0206080283969641, 0.0206431522965431, 0.0206785090267658, 0.0207139831036329, 0.0207495745271444, 0.0207852870225906, 0.020821176469326, 0.0208570621907711, 0.0208931863307953, 0.0209293700754642, 0.0209657903760672, 0.0210022404789925, 0.0210388358682394, 0.0210756417363882, 0.0211124140769243, 0.0211493652313948, 0.0211864914745092, 0.0212237387895584, 0.0212611611932516, 0.0212985873222351, 0.0213362462818623, 0.0213738456368446, 0.021411769092083, 0.0214497800916433, 0.0214878842234612, 0.0215261336416006, 0.0215645004063845, 0.0216030143201351, 0.0216415617614985, 0.0216802526265383, 0.0217191819101572, 0.0217582285404205, 0.021797301247716, 0.0218366738408804, 0.0218759272247553, 0.021915415301919, 0.0219550225883722, 0.0219948086887598, 0.022034740075469, 0.0220746695995331, 0.0221148673444986, 0.0221551228314638, 0.0221953820437193, 0.022235931828618, 0.0222765430808067, 0.0223173890262842, 0.0223582349717617, 0.0223992299288511, 0.0224403403699398, 0.0224815718829632, 0.0225229803472757, 0.0225644763559103, 0.0226061772555113, 0.0226479396224022, 0.02268978767097, 0.02273178845644, 0.0227739326655865, 0.0228162258863449, 0.0228586662560701, 0.0229011625051498, 0.0229438412934542, 0.0229866374284029, 0.0230293720960617, 0.0230724904686213, 0.0231156088411808, 0.0231589041650295, 0.0232022907584906, 0.0232458524405956, 0.0232894141227007, 0.0233332421630621, 0.0233771577477455, 0.0234211347997189, 0.0234653446823359, 0.0235096737742424, 0.0235540047287941, 0.0235986262559891, 0.0236431919038296, 0.023687994107604, 0.0237329434603453, 0.0237780082970858, 0.0238231364637613, 0.0238684397190809, 0.0239137727767229, 0.0239593405276537, 0.0240050554275513, 0.0240508299320936, 0.0240967553108931, 0.024142824113369, 0.0241889264434576, 0.0242352318018675, 0.0242816861718893, 0.0243281982839108, 0.0243749190121889, 0.0244217570871115, 0.0244686845690012, 0.0245156697928905, 0.0245627723634243, 0.024610111489892, 0.0246576275676489, 0.0247051455080509, 0.0247528962790966, 0.0248007085174322, 0.0248484630137682, 0.024896627292037, 0.024944793432951, 0.0249931067228317, 0.0250415690243244, 0.0250901486724615, 0.0251388754695654, 0.0251875706017017, 0.0252365041524172, 0.0252856127917767, 0.0253348145633936, 0.0253841895610094, 0.0254336260259151, 0.0254831202328205, 0.0255328211933374, 0.0255826395004988, 0.0256326347589493, 0.0256827510893345, 0.0257329810410738, 0.0257832705974579, 0.0258335899561644, 0.0258842650800943, 0.0259349979460239, 0.0259857624769211, 0.0260367337614298, 0.026087848469615, 0.0261391438543797, 0.0261903200298548, 0.0262417905032635, 0.0262933801859617, 0.0263451486825943, 0.0263969749212265, 0.0264489762485027, 0.0265009794384241, 0.0265531856566668, 0.026605486869812, 0.0266580507159233, 0.0267106425017118, 0.0267633534967899, 0.0268162414431572, 0.0268692467361689, 0.0269222836941481, 0.0269754976034164, 0.0270288549363613, 0.0270823631435633, 0.0271359328180552, 0.0271897036582232, 0.0272434204816818, 0.0272973999381065, 0.0273515582084656, 0.0274058002978563, 0.0274601653218269, 0.0275146774947643, 0.0275691896677017, 0.0276239346712828, 0.0276788007467985, 0.027733875438571, 0.0277890060096979, 0.0278441943228245, 0.027899619191885, 0.027955075725913, 0.0280106216669083, 0.0280664004385471, 0.0281222425401211, 0.0281782876700163, 0.0282343626022339, 0.028290644288063, 0.0283469259738922, 0.0284034740179777, 0.0284601412713528, 0.0285168066620827, 0.0285737682133913, 0.0286307279020548, 0.0286879241466522, 0.0287450924515724, 0.0288024377077818, 0.0288598723709583, 0.0289175380021334, 0.028975386172533, 0.0290333516895771, 0.0290913451462984, 0.0291493386030197, 0.0292075984179974, 0.029266033321619, 0.0293245315551758, 0.029383173212409, 0.0294419638812542, 0.0295009035617113, 0.0295598413795233, 0.0296190176159143, 0.0296781901270151, 0.0297376587986946, 0.0297971572726965, 0.0298568364232779, 0.0299165695905685, 0.0299764238297939, 0.0300364531576633, 0.0300966612994671, 0.0301569271832705, 0.0302173718810081, 0.0302777551114559, 0.0303383748978376, 0.0303992331027985, 0.0304601490497589, 0.0305212419480085, 0.0305823925882578, 0.0306436643004417, 0.0307051092386246, 0.0307664982974529, 0.0308282095938921, 0.0308899823576212, 0.0309519004076719, 0.031013997271657, 0.0310761854052544, 0.0311383660882711, 0.0312008187174797, 0.0312633290886879, 0.0313260145485401, 0.0313888788223267, 0.0314517430961132, 0.0315146930515766, 0.0315779708325863, 0.0316412188112736, 0.0317046716809273, 0.0317682139575481, 0.031831931322813, 0.0318956822156906, 0.0319596379995346, 0.0320235937833786, 0.0320878438651562, 0.0321521535515785, 0.032216552644968, 0.0322811268270016, 0.032345823943615, 0.0324105136096478, 0.0324755311012268, 0.0325405523180962, 0.0326057747006416, 0.032671120017767, 0.0327365808188915, 0.0328021571040154, 0.032867856323719, 0.0329335518181324, 0.0329994857311249, 0.0330656543374062, 0.0331318527460098, 0.0331980511546135, 0.0332646034657955, 0.0333310998976231, 0.0333977974951267, 0.033464677631855, 0.0335316136479378, 0.0335986688733101, 0.033665869385004, 0.0337332189083099, 0.0338005982339382, 0.0338681824505329, 0.0339358896017075, 0.0340037681162357, 0.0340717658400536, 0.0341398231685162, 0.0342079438269138, 0.03427629545331, 0.034344770014286, 0.034413356333971, 0.0344820953905582, 0.0345509760081768, 0.0346199199557304, 0.0346889533102512, 0.034758135676384, 0.0348275192081928, 0.0348969921469688, 0.0349666140973568, 0.0350363291800022, 0.0351062156260014, 0.0351760722696781, 0.0352461971342564, 0.0353164076805115, 0.0353867970407009, 0.0354572460055351, 0.0355279035866261, 0.0355985276401043, 0.0356693901121616, 0.0357404015958309, 0.0358114689588547, 0.0358827114105225, 0.0359541364014149, 0.0360256172716618, 0.0360972471535206, 0.0361688174307346, 0.036240741610527, 0.0363127812743187, 0.0363848581910133, 0.0364571027457714, 0.0365294702351093, 0.0366019234061241, 0.0366744995117188, 0.0367472507059574, 0.0368201211094856, 0.0368931964039803, 0.0369662679731846, 0.0370394624769688, 0.0371128357946873, 0.0371863506734371, 0.0372599884867668, 0.0373338013887405, 0.037407673895359, 0.0374816320836544, 0.0375558026134968, 0.0376299694180489, 0.0377043709158897, 0.0377788916230202, 0.0378535054624081, 0.0379282906651497, 0.0380031950771809, 0.0380781292915344, 0.0381532423198223, 0.0382285304367542, 0.0383038781583309, 0.038379430770874, 0.0384550467133522, 0.0385308973491192, 0.0386066846549511, 0.0386826805770397, 0.0387588329613209, 0.0388351455330849, 0.0389115884900093, 0.0389880575239658, 0.0390647351741791, 0.0391413494944572, 0.0392183214426041, 0.0392954088747501, 0.0393725000321865, 0.0394497662782669, 0.0395271517336369, 0.0396047718822956, 0.0396823361515999, 0.0397601313889027, 0.0398379899561405, 0.0399160198867321, 0.0399942584335804, 0.0400725305080414, 0.0401508286595345, 0.0402294248342514, 0.0403080172836781, 0.0403868779540062, 0.0404657982289791, 0.0405448898673058, 0.0406240150332451, 0.0407032035291195, 0.0407826565206051, 0.0408622771501541, 0.0409418530762196, 0.0410217121243477, 0.0411015748977661, 0.0411816760897636, 0.0412618070840836, 0.0413420796394348, 0.0414225347340107, 0.0415030494332314, 0.0415837652981281, 0.04166454449296, 0.0417454689741135, 0.0418264530599117, 0.0419077053666115, 0.0419889837503433, 0.0420704446732998, 0.042151901870966, 0.0422336831688881, 0.0423154644668102, 0.0423973947763443, 0.0424794107675552, 0.0425616353750229, 0.0426439493894577, 0.0427263751626015, 0.0428088717162609, 0.0428916811943054, 0.042974442243576, 0.0430574342608452, 0.0431403666734695, 0.043223649263382, 0.0433069691061974, 0.0433904007077217, 0.0434740446507931, 0.0435576848685741, 0.0436415039002895, 0.0437254421412945, 0.0438094362616539, 0.0438936948776245, 0.0439780130982399, 0.0440624803304672, 0.044147040694952, 0.0442317128181458, 0.0443165935575962, 0.044401504099369, 0.0444865934550762, 0.0445718243718147, 0.0446571484208107, 0.0447425916790962, 0.0448281802237034, 0.0449138581752777, 0.0449996814131737, 0.0450856536626816, 0.0451717786490917, 0.0452579855918884, 0.0453443080186844, 0.0454307869076729, 0.0455174371600151, 0.0456040874123573, 0.0456909760832787, 0.0457779206335545, 0.0458649881184101, 0.0459522269666195, 0.0460395887494087, 0.0461270660161972, 0.0462146028876305, 0.0463023744523525, 0.0463902056217194, 0.046478159725666, 0.0465705767273903, 0.0466680340468884, 0.0467658936977386, 0.0468637049198151, 0.0469617508351803, 0.0470600835978985, 0.0471584796905518, 0.047257237136364, 0.0473561622202396, 0.0474552102386951, 0.0475543774664402, 0.0476538389921188, 0.0477534756064415, 0.0478532910346985, 0.047953337430954, 0.0480535104870796, 0.048153854906559, 0.0482544973492622, 0.0483553148806095, 0.0484561920166016, 0.0485573634505272, 0.0486586540937424, 0.0487602353096008, 0.0488619394600391, 0.048963937908411, 0.0490660592913628, 0.049168411642313, 0.0492708832025528, 0.0493736453354359, 0.0494765304028988, 0.0495795905590057, 0.0496828891336918, 0.0497863590717316, 0.0498899556696415, 0.0499939620494843, 0.0500978492200375, 0.0502021498978138, 0.0503065660595894, 0.0504111647605896, 0.0505160503089428, 0.0506210625171661, 0.0507263094186783, 0.0508316718041897, 0.0509372130036354, 0.0510428696870804, 0.0511488802731037, 0.0512550137937069, 0.0513613745570183, 0.0514679811894894, 0.0515745803713799, 0.0516816601157188, 0.0517887361347675, 0.051896046847105, 0.052003588527441, 0.0521111935377121, 0.0522191561758518, 0.0523272342979908, 0.0524354316294193, 0.0525439232587814, 0.0526525937020779, 0.052761435508728, 0.0528705157339573, 0.0529797188937664, 0.0530890934169292, 0.053198765963316, 0.0533086732029915, 0.053418580442667, 0.0535287298262119, 0.0536392256617546, 0.0537497214972973, 0.0538604594767094, 0.0539714284241199, 0.0540825761854649, 0.0541938431560993, 0.0543054640293121, 0.0544171966612339, 0.0545290559530258, 0.054641205817461, 0.0547535344958305, 0.0548660419881344, 0.0549787245690823, 0.0550916381180286, 0.0552046746015549, 0.0553179495036602, 0.0554313994944096, 0.055545087903738, 0.0556589514017105, 0.0557728670537472, 0.0558871477842331, 0.0560016594827175, 0.0561162307858467, 0.0562310963869095, 0.0563458427786827, 0.0564611852169037, 0.0565764047205448, 0.0566920340061188, 0.0568077936768532, 0.0569238364696503, 0.0570398829877377, 0.0571562275290489, 0.0572728030383587, 0.0573895610868931, 0.0575064904987812, 0.0576235465705395, 0.0577408261597157, 0.0578583516180515, 0.0579760484397411, 0.0580938681960106, 0.0582119785249233, 0.0583303272724152, 0.0584487356245518, 0.0585673786699772, 0.0586862079799175, 0.0588052049279213, 0.0589244961738586, 0.0590438470244408, 0.0591634325683117, 0.0592832006514072, 0.0594032630324364, 0.05952338129282, 0.0596436224877834, 0.0597642697393894, 0.05988509953022, 0.0600059889256954, 0.0601271092891693, 0.0602484680712223, 0.0603700056672096, 0.0604917779564857, 0.0606136098504066, 0.0607357323169708, 0.0608579777181149, 0.0609805211424828, 0.0611032359302044, 0.0612260103225708, 0.0613491460680962, 0.0614723898470402, 0.0615958720445633, 0.0617194771766663, 0.0618432573974133, 0.0619673356413841, 0.0620915256440639, 0.0622159503400326, 0.0623404420912266, 0.0624652840197086, 0.0625901818275452, 0.0627154409885406, 0.0628408119082451, 0.0629663020372391, 0.0630921497941017, 0.0632180571556091, 0.0633441954851151, 0.0634705126285553, 0.063597060739994, 0.0637237355113029, 0.0638505220413208, 0.0639777854084969, 0.0641050487756729, 0.0642324835062027, 0.064360223710537, 0.064488023519516, 0.0646161064505577, 0.0647443681955338, 0.0648728087544441, 0.0650014281272888, 0.0651302263140678, 0.0652593225240707, 0.0653884708881378, 0.0655177384614944, 0.0656474232673645, 0.0657771676778793, 0.0659071430563927, 0.0660373494029045, 0.0661676824092865, 0.0662982538342476, 0.0664289966225624, 0.0665598586201668, 0.066691018640995, 0.066822350025177, 0.0669538676738739, 0.0670855566859245, 0.0672174841165543, 0.0673496350646019, 0.0674819797277451, 0.0676143765449524, 0.0677470117807388, 0.067879818379879, 0.0680129826068878, 0.0681461468338966, 0.0682796090841293, 0.0684132426977158, 0.0685471221804619, 0.0686810538172722, 0.0688151568174362, 0.0689496174454689, 0.0690842047333717, 0.0692189037799835, 0.0693539008498192, 0.0694890692830086, 0.0696244239807129, 0.0697600618004799, 0.0698957070708275, 0.070031650364399, 0.0701678171753883, 0.0703041180968285, 0.0704406425356865, 0.0705772936344147, 0.0707141757011414, 0.0708512365818024, 0.0709885954856873, 0.0711261257529259, 0.0712637156248093, 0.0714016035199165, 0.0715396031737328, 0.0716778486967087, 0.0718162655830383, 0.0719548016786575, 0.0720936954021454, 0.0722326412796974, 0.0723718255758286, 0.072511188685894, 0.0726507306098938, 0.0727905631065369, 0.0729305744171143, 0.073070764541626, 0.0732110738754272, 0.0733514949679375, 0.0734923332929611, 0.0736332312226295, 0.0737743079662323, 0.0739156752824783, 0.0740572214126587, 0.0741988867521286, 0.0743407905101776, 0.0744828656315804, 0.0746250599622726, 0.074767492711544, 0.0749102756381035, 0.0750531256198883, 0.0751960873603821, 0.0753393471240997, 0.0754827260971069, 0.075626328587532, 0.0757700651884079, 0.075914092361927, 0.0760582983493805, 0.0762026160955429, 0.0763472244143486, 0.0764920189976692, 0.0766369923949242, 0.0767821371555328, 0.0769275277853012, 0.0770730227231979, 0.0772187560796738, 0.0773646757006645, 0.077510766685009, 0.0776570960879326, 0.0778035447001457, 0.0779503434896469, 0.0780971497297287, 0.0782442316412926, 0.078391507267952, 0.0785389021039009, 0.0786865204572678, 0.0788343921303749, 0.0789824277162552, 0.0791305899620056, 0.0792790353298187, 0.079427607357502, 0.0795764178037643, 0.0797254592180252, 0.0798746794462204, 0.0800239518284798, 0.0801735296845436, 0.080323338508606, 0.0804732739925385, 0.0806234329938889, 0.0807737112045288, 0.0809242948889732, 0.0810749903321266, 0.0812259241938591, 0.0813770368695259, 0.0815283730626106, 0.0816797837615013, 0.0818314775824547, 0.0819834098219872, 0.0821354687213898, 0.0822875797748566, 0.082440048456192, 0.0825926959514618, 0.0827455669641495, 0.0828986838459969, 0.0830518081784248, 0.0832051560282707, 0.0833588615059853, 0.0835126787424088, 0.0836665108799934, 0.0838207453489304, 0.0839751586318016, 0.0841297581791878, 0.0842844620347023, 0.0844394043087959, 0.0845945253968239, 0.0847498252987862, 0.0849054232239723, 0.085061140358448, 0.0852170214056969, 0.0853731483221054, 0.0855294540524483, 0.0856858789920807, 0.0858425348997116, 0.0859994292259216, 0.0861564502120018, 0.0863136947154999, 0.0864711180329323, 0.0866287723183632, 0.086786612868309, 0.0869446247816086, 0.0871027559041977, 0.0872612521052361, 0.0874198600649834, 0.0875786319375038, 0.087737537920475, 0.0878966748714447, 0.0880561098456383, 0.0882156491279602, 0.0883753746747971, 0.0885353982448578, 0.0886955335736275, 0.0888558551669121, 0.0890162885189056, 0.0891770869493484, 0.0893379896879196, 0.0894990190863609, 0.0896602720022202, 0.0898217707872391, 0.0899833887815475, 0.0901452973484993, 0.0903072133660316, 0.0904695391654968, 0.0906320363283157, 0.0907946527004242, 0.0909575074911118, 0.0911204814910889, 0.0912836939096451, 0.0914470851421356, 0.0916106402873993, 0.0917744487524033, 0.0919383689761162, 0.0921025797724724, 0.0922669023275375, 0.092431478202343, 0.0925962775945663, 0.0927611961960793, 0.0929262936115265, 0.0930915698409081, 0.0932571366429329, 0.0934227779507637, 0.093588687479496, 0.093754805624485, 0.093920961022377, 0.0940875336527824, 0.0942542180418968, 0.0944210290908813, 0.094588078558445, 0.0947553068399429, 0.0949227660894394, 0.0950904041528702, 0.0952582135796547, 0.0954262018203735, 0.0955943688750267, 0.0957627147436142, 0.0959313586354256, 0.0961001142859459, 0.0962690412998199, 0.0964382141828537, 0.0966075733304024, 0.0967770963907242, 0.0969469174742699, 0.0971168503165245, 0.0972869023680687, 0.0974572524428368, 0.097627729177475, 0.0977984368801117, 0.0979692563414574, 0.0981403738260269, 0.0983116775751114, 0.0984830856323242, 0.0986547991633415, 0.098826564848423, 0.0989986285567284, 0.0991708785295486, 0.0993433445692062, 0.099515937268734, 0.099688708782196, 0.099861778318882, 0.100034900009632, 0.100208267569542, 0.100381918251514, 0.100555583834648, 0.100729584693909, 0.100903727114201, 0.101078145205975, 0.101252630352974, 0.101427413523197, 0.101602248847485, 0.10177743434906, 0.101952746510506, 0.102128230035305, 0.102303899824619, 0.102479740977287, 0.102655813097954, 0.102832071483135, 0.103008508682251, 0.103185176849365, 0.103361949324608, 0.10353909432888, 0.103716239333153, 0.103893667459488, 0.104071281850338, 0.104249194264412, 0.10442703962326, 0.104605294764042, 0.104783676564693, 0.10496224462986, 0.1051409766078, 0.105319939553738, 0.105499088764191, 0.105678409337997, 0.105858027935028, 0.106037713587284, 0.106217555701733, 0.106397710740566, 0.106578096747398, 0.106758423149586, 0.106939107179642, 0.107120022177696, 0.107301063835621, 0.107482336461544, 0.107663907110691, 0.107845462858677, 0.108027264475822, 0.108209244906902, 0.108391582965851, 0.108573913574219, 0.108756542205811, 0.108939290046692, 0.109122335910797, 0.109305500984192, 0.109488889575005, 0.109672412276268, 0.109856151044369, 0.11004014313221, 0.110224299132824, 0.110408581793308, 0.110593110322952, 0.110777862370014, 0.110962733626366, 0.111147835850716, 0.111333124339581, 0.111518643796444, 0.111704230308533, 0.11189016699791, 0.112076215445995, 0.112262509763241, 0.112448967993259, 0.112635560333729, 0.112822435796261, 0.113009430468082, 0.113196611404419, 0.113384015858173, 0.113571666181087, 0.113759361207485, 0.113947428762913, 0.114135608077049, 0.114323899149895, 0.114512503147125, 0.114701271057129, 0.114890210330486, 0.115079380571842, 0.11526857316494, 0.115458220243454, 0.115647822618484, 0.115837760269642, 0.116027764976025, 0.116218134760857, 0.116408549249172, 0.116599328815937, 0.116790108382702, 0.116981230676174, 0.117172539234161, 0.117363847792149, 0.117555558681488, 0.117747291922569, 0.117939241230488, 0.1181316152215, 0.118323922157288, 0.118516460061073, 0.118709251284599, 0.118902325630188, 0.119095578789711, 0.11929689347744, 0.119506619870663, 0.119716539978981, 0.119926527142525, 0.120136640965939, 0.120346948504448, 0.120557390153408, 0.120768077671528, 0.120978839695454, 0.121189795434475, 0.121400840580463, 0.121612191200256, 0.121823541820049, 0.12203511595726, 0.122246935963631, 0.122458808124065, 0.122670754790306, 0.122883036732674, 0.123095363378525, 0.123307883739471, 0.123520560562611, 0.123733259737492, 0.123946316540241, 0.124159522354603, 0.124372735619545, 0.124586269259453, 0.124799877405167, 0.125013619661331, 0.125227525830269, 0.125441491603851, 0.125655800104141, 0.125870183110237, 0.126084685325623, 0.126299425959587, 0.126514345407486, 0.126729384064674, 0.126944541931152, 0.127159804105759, 0.12737537920475, 0.127590999007225, 0.127806857228279, 0.128022715449333, 0.128238886594772, 0.128455117344856, 0.128671541810036, 0.128888115286827, 0.129104793071747, 0.129321753978729, 0.129538848996162, 0.129756018519402, 0.129973441362381, 0.130190894007683, 0.130408585071564, 0.130626454949379, 0.130844444036484, 0.131062552332878, 0.131280824542046, 0.131499290466309, 0.131717920303345, 0.131936758756638, 0.132155731320381, 0.132374718785286, 0.132594063878059, 0.132813468575478, 0.133032977581024, 0.133252799510956, 0.133472591638565, 0.133692637085915, 0.133912742137909, 0.134133160114288, 0.134353652596474, 0.134574323892593, 0.134795054793358, 0.135016143321991, 0.135237231850624, 0.13545848429203, 0.135679930448532, 0.135901510715485, 0.136123329401016, 0.136345162987709, 0.13656722009182, 0.13678951561451, 0.137011811137199, 0.137234345078468, 0.137457028031349, 0.137679934501648, 0.137902989983559, 0.138126030564308, 0.138349428772926, 0.138572961091995, 0.138796612620354, 0.139020323753357, 0.139244273304939, 0.139468342065811, 0.139692604541779, 0.139917060732841, 0.140141636133194, 0.140366315841675, 0.140591233968735, 0.140816286206245, 0.141041457653046, 0.141266882419586, 0.141492366790771, 0.141718029975891, 0.141943752765656, 0.142169818282127, 0.142395928502083, 0.142622217535973, 0.142848625779152, 0.143075287342072, 0.143302068114281, 0.143529042601585, 0.143756031990051, 0.14398330450058, 0.144210740923882, 0.144438281655312, 0.144665896892548, 0.144893854856491, 0.14512175321579, 0.145349979400635, 0.145578324794769, 0.145806849002838, 0.146035522222519, 0.146264210343361, 0.146493211388588, 0.146722331643105, 0.146951630711555, 0.147181019186974, 0.147410586476326, 0.147640317678452, 0.147870257496834, 0.148100301623344, 0.148330584168434, 0.148560836911201, 0.148791342973709, 0.149022072553635, 0.149253040552139, 0.14948396384716, 0.149715051054955, 0.149946376681328, 0.150177866220474, 0.15040947496891, 0.150641247630119, 0.150873094797134, 0.151105254888535, 0.151337474584579, 0.151569992303848, 0.151802495121956, 0.152035176753998, 0.152268126606941, 0.152501136064529, 0.15273429453373, 0.152967661619186, 0.153201133012772, 0.153434753417969, 0.153668537735939, 0.153902605175972, 0.154136762022972, 0.154370978474617, 0.154605373740196, 0.154840007424355, 0.155074819922447, 0.155309706926346, 0.155544742941856, 0.155780002474785, 0.156015381217003, 0.15625087916851, 0.156486541032791, 0.156722411513329, 0.156958416104317, 0.157194599509239, 0.157430931925774, 0.157667458057404, 0.157903999090195, 0.158140882849693, 0.158377766609192, 0.158614948391914, 0.158852130174637, 0.159089535474777, 0.159327119588852, 0.159564822912216, 0.159802705049515, 0.160040810704231, 0.160279020667076, 0.160517320036888, 0.160755828022957, 0.16099451482296, 0.161233335733414, 0.161472305655479, 0.161711439490318, 0.161950722336769, 0.162190154194832, 0.162429869174957, 0.162669509649277, 0.162909522652626, 0.163149580359459, 0.163389876484871, 0.163630232214928, 0.16387078166008, 0.164111450314522, 0.164352372288704, 0.164593353867531, 0.164834454655647, 0.165075808763504, 0.165317341685295, 0.165558949112892, 0.165800765156746, 0.166042789816856, 0.16628485918045, 0.166527152061462, 0.16676951944828, 0.167012110352516, 0.167254939675331, 0.167497798800468, 0.16774083673954, 0.167984038591385, 0.168227404356003, 0.168470919132233, 0.168714642524719, 0.168958455324173, 0.1692024320364, 0.169446587562561, 0.169690951704979, 0.169935375452042, 0.170179978013039, 0.17042487859726, 0.170669734477997, 0.170914843678474, 0.171160027384758, 0.171405509114265, 0.171651065349579, 0.171896725893021, 0.172142639756203, 0.17238861322403, 0.17263488471508, 0.172881171107292, 0.173127681016922, 0.173374339938164, 0.173621132969856, 0.173868060112, 0.174115240573883, 0.174362510442734, 0.174609944224358, 0.174857631325722, 0.175105303525925, 0.175353273749352, 0.17560125887394, 0.175849512219429, 0.176097929477692, 0.17634642124176, 0.176595211029053, 0.176844045519829, 0.177092984318733, 0.1773422062397, 0.177591413259506, 0.177840918302536, 0.178090527653694, 0.178340330719948, 0.178590312600136, 0.178840443491936, 0.179090678691864, 0.17934113740921, 0.179591655731201, 0.179842382669449, 0.180093184113503, 0.180344328284264, 0.180595517158508, 0.180846884846687, 0.181098431348801, 0.18135005235672, 0.181601896882057, 0.181853905320168, 0.182106047868729, 0.18235832452774, 0.182610765099525, 0.182863399386406, 0.183116212487221, 0.183369010686874, 0.183622136712074, 0.18387533724308, 0.184128746390343, 0.18438233435154, 0.184635981917381, 0.184889927506447, 0.185143902897835, 0.185398131608963, 0.185652479529381, 0.185906872153282, 0.186161532998085, 0.186416268348694, 0.186671271920204, 0.186926424503326, 0.187181696295738, 0.187437117099762, 0.187692761421204, 0.187948435544968, 0.188204392790794, 0.188460379838943, 0.188716679811478, 0.188973009586334, 0.189229533076286, 0.18948620557785, 0.189743012189865, 0.190000042319298, 0.190257161855698, 0.190514504909515, 0.1907719373703, 0.19102954864502, 0.191287308931351, 0.191545248031616, 0.191803365945816, 0.192061617970467, 0.192319974303246, 0.192578509449959, 0.192837357521057, 0.193096116185188, 0.193355187773705, 0.193614438176155, 0.19387374818325, 0.194133296608925, 0.194392919540405, 0.19465272128582, 0.19491271674633, 0.195172876119614, 0.195433080196381, 0.195693492889404, 0.195954099297523, 0.196214869618416, 0.196475818753242, 0.196736842393875, 0.196998059749603, 0.197259470820427, 0.197521045804024, 0.197782710194588, 0.198044627904892, 0.198306486010551, 0.198568746447563, 0.198831006884575, 0.199093490839005, 0.19935616850853, 0.199618950486183, 0.199881881475449, 0.200144991278648, 0.200408264994621, 0.200671717524529, 0.200935244560242, 0.201198950409889, 0.201462864875793, 0.201726913452148, 0.201991006731987, 0.202255442738533, 0.202519938349724, 0.202784657478333, 0.203049421310425, 0.203314438462257, 0.203579664230347, 0.203844860196114, 0.204110369086266, 0.204375952482224, 0.204641729593277, 0.204907655715942, 0.205173745751381, 0.205439925193787, 0.205706283450127, 0.205972895026207, 0.206239655613899, 0.206506446003914, 0.206773549318314, 0.207040697336197, 0.207308039069176, 0.207575485110283, 0.207843154668808, 0.208111003041267, 0.208378836512566, 0.20864699780941, 0.208915278315544, 0.209183692932129, 0.209452271461487, 0.209721028804779, 0.209989905357361, 0.210259005427361, 0.21052822470665, 0.210797592997551, 0.211067199707031, 0.211336731910706, 0.211606681346893, 0.211876600980759, 0.212146759033203, 0.212417125701904, 0.212687522172928, 0.212958142161369, 0.213228970766068, 0.213499873876572, 0.213770940899849, 0.214042246341705, 0.214313641190529, 0.214585155248642, 0.214856937527657, 0.215128749608994, 0.21540080010891, 0.215672984719276, 0.215945363044739, 0.216217815876007, 0.216490507125854, 0.216763243079185, 0.217036306858063, 0.217309460043907, 0.217582732439041, 0.217856213450432, 0.218129739165306, 0.218403562903404, 0.218677461147308, 0.218951478600502, 0.219225689768791, 0.219500035047531, 0.219774574041367, 0.220049262046814, 0.22032418847084, 0.220599114894867, 0.220874339342117, 0.221149668097496, 0.221425205469131, 0.221700817346573, 0.221976578235626, 0.222252517938614, 0.222528591752052, 0.222804844379425, 0.223081305623055, 0.223357871174812, 0.223634615540504, 0.223911479115486, 0.224188521504402, 0.22446571290493, 0.224743083119392, 0.225020721554756, 0.225298270583153, 0.225576162338257, 0.225854009389877, 0.226132214069366, 0.226410537958145, 0.226688995957375, 0.226967558264732, 0.227246284484863, 0.227525293827057, 0.227804362773895, 0.228083580732346, 0.228362992405891, 0.228642493486404, 0.228922188282013, 0.229202061891556, 0.229482084512711, 0.2297622859478, 0.230042651295662, 0.230323061347008, 0.230603769421577, 0.230884566903114, 0.231165558099747, 0.231446698307991, 0.231727942824364, 0.232009321451187, 0.232290953397751, 0.232572704553604, 0.232854589819908, 0.233136624097824, 0.233418792486191, 0.233701258897781, 0.233983725309372, 0.234266400337219, 0.234549328684807, 0.234832286834717, 0.235115438699722, 0.235398724675179, 0.235682189464569, 0.235965728759766, 0.236249625682831, 0.236533552408218, 0.236817643046379, 0.237101852893829, 0.237386226654053, 0.237670809030533, 0.237955585122108, 0.238240450620651, 0.238525480031967, 0.238810628652573, 0.239095941185951, 0.239381447434425, 0.239667132496834, 0.239952936768532, 0.240238875150681, 0.240525022149086, 0.240811422467232, 0.241097763180733, 0.241384387016296, 0.241671085357666, 0.241958066821098, 0.24224516749382, 0.242532357573509, 0.242819711565971, 0.243107214570045, 0.243394941091537, 0.243687704205513, 0.243984520435333, 0.244281426072121, 0.244578346610069, 0.244875192642212, 0.245172187685966, 0.245469063520432, 0.245766058564186, 0.246063083410263, 0.246360078454018, 0.246657088398933, 0.246954098343849, 0.24725116789341, 0.247548282146454, 0.247845396399498, 0.248142540454865, 0.248439684510231, 0.248736828565598, 0.24903404712677, 0.249331250786781, 0.249628484249115, 0.249925702810287, 0.25022304058075, 0.250520348548889, 0.250817656517029, 0.251114964485168, 0.251412361860275, 0.251709699630737, 0.252007126808167, 0.252304494380951, 0.252602010965347, 0.252899438142776, 0.25319692492485, 0.253494411706924, 0.253791928291321, 0.254089444875717, 0.254387050867081, 0.254684627056122, 0.254982233047485, 0.255279868841171, 0.255577504634857, 0.255875170230865, 0.256172865629196, 0.256470561027527, 0.256768316030502, 0.257066011428833, 0.257363826036453, 0.257661581039429, 0.257959425449371, 0.258257210254669, 0.258555084466934, 0.258852988481522, 0.259150832891464, 0.259448766708374, 0.259746700525284, 0.260044634342194, 0.260342657566071, 0.26064059138298, 0.260938674211502, 0.261236667633057, 0.261534720659256, 0.261832803487778, 0.262130886316299, 0.262429028749466, 0.262727200984955, 0.263025313615799, 0.26332351565361, 0.263621717691422, 0.263919949531555, 0.264218240976334, 0.264516443014145, 0.264814704656601, 0.265113055706024, 0.265411376953125, 0.265709757804871, 0.266008079051971, 0.266306489706039, 0.266604840755463, 0.266903281211853, 0.267201811075211, 0.267500191926956, 0.267798751592636, 0.268097251653671, 0.268395781517029, 0.268694311380386, 0.268992841243744, 0.269291490316391, 0.269590109586716, 0.26988872885704, 0.270187377929688, 0.270486027002335, 0.270784765481949, 0.271083474159241, 0.271382212638855, 0.271680980920792, 0.271979749202728, 0.272278547286987, 0.272577375173569, 0.27287620306015, 0.273175120353699, 0.27347394824028, 0.273772895336151, 0.274071782827377, 0.274370700120926, 0.274669677019119, 0.274968683719635, 0.275267660617828, 0.275566726922989, 0.275865703821182, 0.276164829730988, 0.27646392583847, 0.276763021945953, 0.277062147855759, 0.277361273765564, 0.277660459280014, 0.277959644794464, 0.278258830308914, 0.278558105230331, 0.278857320547104, 0.279156595468521, 0.279455900192261, 0.279755234718323, 0.280054569244385, 0.280353873968124, 0.280653268098831, 0.280952751636505, 0.281252086162567, 0.281551569700241, 0.281850963830948, 0.282150506973267, 0.282449990510941, 0.282749474048615, 0.283049046993256, 0.283348619937897, 0.283648163080215, 0.283947795629501, 0.284247428178787, 0.284547060728073, 0.284846752882004, 0.285146415233612, 0.285446107387543, 0.285745799541473, 0.286045581102371, 0.286345392465591, 0.286645144224167, 0.286944985389709, 0.287244737148285, 0.287544667720795, 0.28784453868866, 0.288144379854202, 0.288444340229034, 0.288744240999222, 0.289044201374054, 0.289344161748886, 0.289644151926041, 0.28994420170784, 0.290244191884995, 0.290544271469116, 0.290844351053238, 0.291144460439682, 0.291444569826126, 0.291744709014893, 0.292044878005981, 0.292345076799393, 0.292645245790482, 0.292945474386215, 0.293245762586594, 0.293545931577682, 0.293846279382706, 0.294146537780762, 0.294446885585785, 0.294747233390808, 0.295047581195831, 0.295347988605499, 0.295648396015167, 0.295948803424835, 0.296249240636826, 0.296549707651138, 0.296850204467773, 0.297150701284409, 0.297451287508011, 0.297751814126968, 0.298052400350571, 0.298352956771851, 0.29865363240242, 0.298954218626022, 0.299254834651947, 0.299555510282516, 0.299856215715408, 0.300156980752945, 0.300457686185837, 0.300758421421051, 0.30105921626091, 0.301360011100769, 0.301660865545273, 0.301961660385132, 0.302262544631958, 0.302563428878784, 0.30286431312561, 0.303165256977081, 0.303466200828552, 0.303767174482346, 0.304068118333817, 0.304369151592255, 0.30467015504837, 0.304971188306808, 0.305272281169891, 0.305573314428329, 0.305874466896057, 0.30617555975914, 0.30647674202919, 0.30677792429924, 0.30707910656929, 0.30738028883934, 0.307681560516357, 0.30798277258873, 0.308284044265747, 0.308585345745087, 0.308886647224426, 0.309188008308411, 0.30948930978775, 0.309790700674057, 0.310092121362686, 0.310393512248993, 0.310694962739944, 0.310996413230896, 0.311297923326492, 0.311599403619766, 0.31190088391304, 0.312202453613281, 0.3125039935112, 0.312805593013763, 0.313107192516327, 0.313408821821213, 0.313710451126099, 0.314012110233307, 0.314313799142838, 0.314615547657013, 0.314917236566544, 0.315219014883041, 0.315520763397217, 0.315822541713715, 0.316124320030212, 0.316426157951355, 0.31672802567482, 0.31702995300293, 0.31733176112175, 0.31763368844986, 0.317935615777969, 0.318237572908401, 0.318539559841156, 0.318841546773911, 0.319143533706665, 0.319445580244064, 0.319747596979141, 0.32004976272583, 0.320351809263229, 0.320653945207596, 0.320956021547318, 0.321258246898651, 0.32156041264534, 0.321862608194351, 0.322164833545685, 0.322467088699341, 0.322769343852997, 0.32307156920433, 0.323373824357986, 0.323676258325577, 0.3239786028862, 0.324280917644501, 0.324583321809769, 0.324885725975037, 0.325188130140305, 0.32549062371254, 0.32579305768013, 0.326095551252365, 0.326398015022278, 0.326700568199158, 0.327003091573715, 0.327305674552917, 0.327608287334442, 0.327910870313644, 0.328213512897491, 0.328516244888306, 0.328818798065186, 0.329121589660645, 0.329424262046814, 0.329727023839951, 0.330029755830765, 0.330332547426224, 0.330635339021683, 0.330938160419464, 0.331240952014923, 0.331543862819672, 0.331846684217453, 0.332149595022202, 0.332452565431595, 0.332755416631699, 0.333058446645737, 0.333361357450485, 0.333664417266846, 0.333967447280884, 0.334270536899567, 0.334573566913605, 0.334876596927643, 0.33517974615097, 0.335482895374298, 0.335785984992981, 0.336089164018631, 0.336392313241959, 0.336695551872253, 0.336998790502548, 0.337302029132843, 0.337605357170105, 0.337908565998077, 0.338211923837662, 0.338515251874924, 0.338818579912186, 0.339121967554092, 0.339425355195999, 0.339728802442551, 0.340032190084457, 0.340335637331009, 0.340639144182205, 0.340942680835724, 0.341246128082275, 0.341549694538116, 0.341853231191635, 0.342156887054443, 0.342460453510284, 0.342764049768448, 0.343067705631256, 0.343371361494064, 0.343675017356873, 0.343978762626648, 0.344282478094101, 0.344586223363876, 0.344889938831329, 0.345193713903427, 0.34549754858017, 0.345801383256912, 0.346105247735977, 0.346409112215042, 0.346713006496429, 0.347016900777817, 0.347320795059204, 0.347624748945236, 0.347928732633591, 0.348232746124268, 0.348536729812622, 0.348840773105621, 0.349144816398621, 0.349448889493942, 0.349752962589264, 0.350057125091553, 0.350361198186874, 0.350665390491486, 0.350969552993774, 0.351273775100708, 0.351577997207642, 0.351882219314575, 0.352186471223831, 0.352490782737732, 0.352795034646988, 0.353099405765533, 0.353403717279434, 0.35370808839798, 0.354012489318848, 0.354316890239716, 0.354621320962906, 0.354925751686096, 0.355230152606964, 0.355534702539444, 0.355839163064957, 0.356143712997437, 0.356448292732239, 0.356752783060074, 0.357057422399521, 0.357362031936646, 0.357666671276093, 0.357971340417862, 0.358275979757309, 0.358580708503723, 0.358885377645493, 0.359190106391907, 0.359494894742966, 0.359799653291702, 0.360104501247406, 0.360409259796143, 0.360714077949524, 0.36101895570755, 0.361323803663254, 0.361628711223602, 0.361933618783951, 0.362238585948944, 0.36254358291626, 0.362848460674286, 0.363153517246246, 0.363458514213562, 0.363763570785522, 0.364068657159805, 0.364373713731766, 0.364678829908371, 0.364984005689621, 0.365289062261581, 0.365594238042831, 0.365899443626404, 0.366204708814621, 0.366509884595871, 0.366815060377121, 0.367120414972305, 0.367425680160522, 0.367731004953384, 0.368036329746246, 0.368341654539108, 0.368647068738937, 0.368952393531799, 0.369257807731628, 0.369563281536102, 0.369868695735931, 0.370174199342728, 0.370479702949524, 0.370785236358643, 0.371090739965439, 0.37139630317688, 0.371701925992966, 0.372007459402084, 0.37231308221817, 0.372618734836578, 0.372924387454987, 0.373230040073395, 0.37353578209877, 0.373841464519501, 0.374147266149521, 0.374452948570251, 0.374758809804916, 0.375064611434937, 0.375370442867279, 0.375676304101944, 0.375982105731964, 0.376288026571274, 0.376593917608261, 0.376899838447571, 0.377205818891525, 0.377511709928513, 0.377817720174789, 0.378123790025711, 0.378429800271988, 0.378735840320587, 0.379041910171509, 0.379348009824753, 0.379654139280319, 0.379960268735886, 0.380266398191452, 0.380572617053986, 0.380878776311874, 0.381184965372086, 0.381491243839264, 0.381797522306442, 0.382103770971298, 0.382410049438477, 0.3827163875103, 0.383022725582123, 0.383329093456268, 0.383635461330414, 0.383941799402237, 0.384248286485672, 0.38455468416214, 0.384861171245575, 0.38516765832901, 0.38547420501709, 0.385780692100525, 0.386087208986282, 0.386393815279007, 0.386700421571732, 0.387006998062134, 0.387313604354858, 0.38762030005455, 0.387926936149597, 0.388233631849289, 0.388540327548981, 0.388847082853317, 0.389153838157654, 0.389460563659668, 0.389767408370972, 0.390074163675308, 0.390381038188934, 0.390687882900238, 0.390994757413864, 0.391301691532135, 0.391608566045761, 0.391915500164032, 0.392222493886948, 0.392529487609863, 0.392836451530457, 0.393143445253372, 0.393450498580933, 0.393757551908493, 0.394064605236053, 0.394371747970581, 0.394676238298416, 0.394977807998657, 0.395279347896576, 0.395580649375916, 0.39588189125061, 0.396182984113693, 0.396483957767487, 0.396784782409668, 0.39708548784256, 0.39738604426384, 0.397686541080475, 0.397986799478531, 0.398286998271942, 0.398587018251419, 0.398886978626251, 0.399186760187149, 0.399486422538757, 0.399785935878754, 0.400085359811783, 0.4003846347332, 0.400683790445328, 0.400982797145844, 0.401281654834747, 0.401580423116684, 0.401879042387009, 0.402177572250366, 0.402475923299789, 0.402774184942245, 0.40307229757309, 0.403370231389999, 0.403668105602264, 0.403965801000595, 0.404263406991959, 0.40456086397171, 0.404858201742172, 0.405155390501022, 0.40545243024826, 0.405749380588531, 0.406046211719513, 0.40634286403656, 0.40663942694664, 0.406935811042786, 0.407232135534286, 0.407528281211853, 0.40782430768013, 0.40812024474144, 0.408416002988815, 0.408711642026901, 0.409007161855698, 0.409302562475204, 0.409597754478455, 0.409892857074738, 0.410187900066376, 0.410482734441757, 0.410777479410172, 0.411072075366974, 0.411366552114487, 0.41166090965271, 0.411955118179321, 0.412249177694321, 0.412543147802353, 0.412836998701096, 0.413130640983582, 0.413424253463745, 0.413717657327652, 0.414010941982269, 0.414304137229919, 0.414597183465958, 0.414890110492706, 0.415182858705521, 0.415475517511368, 0.415768086910248, 0.416060447692871, 0.416352719068527, 0.416644841432571, 0.416936874389648, 0.417228728532791, 0.417520463466644, 0.417812079191208, 0.418103635311127, 0.418394923210144, 0.418686151504517, 0.4189772605896, 0.419268250465393, 0.419559061527252, 0.419849753379822, 0.420140355825424, 0.420430839061737, 0.420721173286438, 0.421011328697205, 0.421301364898682, 0.421591311693192, 0.421881109476089, 0.422170788049698, 0.422460377216339, 0.422749727964401, 0.423039019107819, 0.423328161239624, 0.423617213964462, 0.423906087875366, 0.424194812774658, 0.424483478069305, 0.424771994352341, 0.425060331821442, 0.425348609685898, 0.425636678934097, 0.425924688577652, 0.426212549209595, 0.426500290632248, 0.426787883043289, 0.427075326442719, 0.427362650632858, 0.427649885416031, 0.427936911582947, 0.42822390794754, 0.428510665893555, 0.428797364234924, 0.429083973169327, 0.42937034368515, 0.429656684398651, 0.429942756891251, 0.430228859186172, 0.430514812469482, 0.430800527334213, 0.431086182594299, 0.431371688842773, 0.431657075881958, 0.431942373514175, 0.432227462530136, 0.43251246213913, 0.432797342538834, 0.433082073926926, 0.433366715908051, 0.433651149272919, 0.43393549323082, 0.434219717979431, 0.434503793716431, 0.434787809848785, 0.435071587562561, 0.435355305671692, 0.435638904571533, 0.43592232465744, 0.43620565533638, 0.436488747596741, 0.436771899461746, 0.437054842710495, 0.437337577342987, 0.437620252370834, 0.437902748584747, 0.438185185194016, 0.438467472791672, 0.438749551773071, 0.439031600952148, 0.439313441514969, 0.439595222473145, 0.439876854419708, 0.440158367156982, 0.440439701080322, 0.440720975399017, 0.441002041101456, 0.441283017396927, 0.441563874483109, 0.441844582557678, 0.442125201225281, 0.442405641078949, 0.442685961723328, 0.442966163158417, 0.443246215581894, 0.443526178598404, 0.443805992603302, 0.444085627794266, 0.444365173578262, 0.444644570350647, 0.444923907518387, 0.44520303606987, 0.445482075214386, 0.44576096534729, 0.446039766073227, 0.446318358182907, 0.44659686088562, 0.446875244379044, 0.447153508663177, 0.447431623935699, 0.447709590196609, 0.447987467050552, 0.448265194892883, 0.448542803525925, 0.448820292949677, 0.449097633361816, 0.449374794960022, 0.449651896953583, 0.449928879737854, 0.450205683708191, 0.450482368469238, 0.450758904218674, 0.451035380363464, 0.451311677694321, 0.451587855815887, 0.451863884925842, 0.452139794826508, 0.452415555715561, 0.452691227197647, 0.452966719865799, 0.453242152929306, 0.453517407178879, 0.453792542219162, 0.454067558050156, 0.454342424869537, 0.454617142677307, 0.454891741275787, 0.455166280269623, 0.455440670251846, 0.455714821815491, 0.455988943576813, 0.456262946128845, 0.456536769866943, 0.456810414791107, 0.457084029912949, 0.457357466220856, 0.457630813121796, 0.457903981208801, 0.45817705988884, 0.458449929952621, 0.458722770214081, 0.458995431661606, 0.459267944097519, 0.459540396928787, 0.459812670946121, 0.460084825754166, 0.460356831550598, 0.460628658533096, 0.460900455713272, 0.461172074079514, 0.461443573236465, 0.461715012788773, 0.461986213922501, 0.462257295846939, 0.462528318166733, 0.46279913187027, 0.46306985616684, 0.463340431451797, 0.463610917329788, 0.463881283998489, 0.464151442050934, 0.464421540498734, 0.464691460132599, 0.464961290359497, 0.465231001377106, 0.465500503778458, 0.465769916772842, 0.466039210557938, 0.466308414936066, 0.466577410697937, 0.466846317052841, 0.467115134000778, 0.467383742332458, 0.467652261257172, 0.467920690774918, 0.468188881874084, 0.468457043170929, 0.468725025653839, 0.468992859125137, 0.469260662794113, 0.469528198242188, 0.469795703887939, 0.470063090324402, 0.470330238342285, 0.470597386360168, 0.470864295959473, 0.471131145954132, 0.471397876739502, 0.471664428710938, 0.471930891275406, 0.472197145223618, 0.472463339567184, 0.472729384899139, 0.472995311021805, 0.473261088132858, 0.473526746034622, 0.473792284727097, 0.474057734012604, 0.474322944879532, 0.474588096141815, 0.474853098392487, 0.475117981433868, 0.475382745265961, 0.475647360086441, 0.475911855697632, 0.476176172494888, 0.4764404296875, 0.4767045378685, 0.47696852684021, 0.477232336997986, 0.477496087551117, 0.477759629487991, 0.478023111820221, 0.478286445140839, 0.478549599647522, 0.478812724351883, 0.479075610637665, 0.479338437318802, 0.479601114988327, 0.47986364364624, 0.480126082897186, 0.48038837313652, 0.480650514364243, 0.480912506580353, 0.481174379587173, 0.481436192989349, 0.481697797775269, 0.481959342956543, 0.482220679521561, 0.482481956481934, 0.482743084430695, 0.483004003763199, 0.483264893293381, 0.483525633811951, 0.483786225318909, 0.4840467274189, 0.484307080507278, 0.484567254781723, 0.4848273396492, 0.485087275505066, 0.485347092151642, 0.485606729984283, 0.485866338014603, 0.486125767230988, 0.486385077238083, 0.486644238233566, 0.486903250217438, 0.487162202596664, 0.487421005964279, 0.48767963051796, 0.487938165664673, 0.488196551799774, 0.488454759120941, 0.488712966442108, 0.488970935344696, 0.489228814840317, 0.489486515522003, 0.489744186401367, 0.490001648664474, 0.490258991718292, 0.490516185760498, 0.490773320198059, 0.491030275821686, 0.491287142038345, 0.491543799638748, 0.491800397634506, 0.492056846618652, 0.492313146591187, 0.492569327354431, 0.492825359106064, 0.493081301450729, 0.493337094783783, 0.493592768907547, 0.493848294019699, 0.494103729724884, 0.494359016418457, 0.494614154100418, 0.494869142770767, 0.495124071836472, 0.495378792285919, 0.495633393526077, 0.495887905359268, 0.496142268180847, 0.496396511793137, 0.496650665998459, 0.496904611587524, 0.497158497571945, 0.497412204742432, 0.497665792703629, 0.497919231653214, 0.498172551393509, 0.498425781726837, 0.498678863048553, 0.498931735754013, 0.49918457865715, 0.499437272548676, 0.499689847230911, 0.499942243099213, 0.500194489955902, 0.500446736812592, 0.500698685646057, 0.500950574874878, 0.501202404499054, 0.501454055309296, 0.501705527305603, 0.501956939697266, 0.502208173274994, 0.502459287643433, 0.502710342407227, 0.502961158752441, 0.503211855888367, 0.503462493419647, 0.503712952136993, 0.503963351249695, 0.504213511943817, 0.504463672637939, 0.504713535308838, 0.504963397979736, 0.505213141441345, 0.505462646484375, 0.505712032318115, 0.505961358547211, 0.506210565567017, 0.506459593772888, 0.506708562374115, 0.506957352161407, 0.507205963134766, 0.507454514503479, 0.507702887058258, 0.507951200008392, 0.508199334144592, 0.508447349071503, 0.508695185184479, 0.50894296169281, 0.509190559387207, 0.509438037872314, 0.509685397148132, 0.509932577610016, 0.510179758071899, 0.510426700115204, 0.510673582553864, 0.510920286178589, 0.51116681098938, 0.511413276195526, 0.511659562587738, 0.511905789375305, 0.512151837348938, 0.512397825717926, 0.51264363527298, 0.512889266014099, 0.513134837150574, 0.513380229473114, 0.513625502586365, 0.513870656490326, 0.514115691184998, 0.514360547065735, 0.514605343341827, 0.51485002040863, 0.515094459056854, 0.515338897705078, 0.515583097934723, 0.515827238559723, 0.516071200370789, 0.516315042972565, 0.516558766365051, 0.516802370548248, 0.517045795917511, 0.517289161682129, 0.517532348632812, 0.517775416374207, 0.518018364906311, 0.518261253833771, 0.518503904342651, 0.518746495246887, 0.518988847732544, 0.519231200218201, 0.519473373889923, 0.519715368747711, 0.51995724439621, 0.520199060440063, 0.520440697669983, 0.520682275295258, 0.520923614501953, 0.521164894104004, 0.521406054496765, 0.521647036075592, 0.521887898445129, 0.522128641605377, 0.522369205951691, 0.522609710693359, 0.522850036621094, 0.523090302944183, 0.523330330848694, 0.52357029914856, 0.523810207843781, 0.524049818515778, 0.524289488792419, 0.524528861045837, 0.524768233299255, 0.525007426738739, 0.525246381759644, 0.525485336780548, 0.525724172592163, 0.525962829589844, 0.52620130777359, 0.526439785957336, 0.526677966117859, 0.526916205883026, 0.527154207229614, 0.527392089366913, 0.527629852294922, 0.527867436408997, 0.528104960918427, 0.528342306613922, 0.528579533100128, 0.528816699981689, 0.529053568840027, 0.52928501367569, 0.529510855674744, 0.529736697673798, 0.529962122440338, 0.530187487602234, 0.530412495136261, 0.530637383460999, 0.530861973762512, 0.531086444854736, 0.531310677528381, 0.531534612178802, 0.531758427619934, 0.531981945037842, 0.532205283641815, 0.532428383827209, 0.532651364803314, 0.53287410736084, 0.533096551895142, 0.533318758010864, 0.533540904521942, 0.533762693405151, 0.533984363079071, 0.534205734729767, 0.534426927566528, 0.534647881984711, 0.534868657588959, 0.535089135169983, 0.535309553146362, 0.535529613494873, 0.535749495029449, 0.535969197750092, 0.536188662052155, 0.536407947540283, 0.536626935005188, 0.536845743656158, 0.537064373493195, 0.537282705307007, 0.537500858306885, 0.537718892097473, 0.537936627864838, 0.538154065608978, 0.538371443748474, 0.538588523864746, 0.538805365562439, 0.539022028446198, 0.539238452911377, 0.539454638957977, 0.539670646190643, 0.539886474609375, 0.540102064609528, 0.540317475795746, 0.54053258895874, 0.540747463703156, 0.540962219238281, 0.541176736354828, 0.541390955448151, 0.541605055332184, 0.541818916797638, 0.542032539844513, 0.542245864868164, 0.542459070682526, 0.542672097682953, 0.542884886264801, 0.54309743642807, 0.543309807777405, 0.543521881103516, 0.543733835220337, 0.543945491313934, 0.544157028198242, 0.544368207454681, 0.544579267501831, 0.544790148735046, 0.545000731945038, 0.545211136341095, 0.545421302318573, 0.545631289482117, 0.545840978622437, 0.546050488948822, 0.546259880065918, 0.546468913555145, 0.546677827835083, 0.546886503696442, 0.547094881534576, 0.547303140163422, 0.547511219978333, 0.54771900177002, 0.547926604747772, 0.548133969306946, 0.548341155052185, 0.5485480427742, 0.548754751682281, 0.548961281776428, 0.549167573451996, 0.549373686313629, 0.549579560756683, 0.549785137176514, 0.54999053478241, 0.550195813179016, 0.550400793552399, 0.550605595111847, 0.550810158252716, 0.551014542579651, 0.551218688488007, 0.551422536373138, 0.551626265048981, 0.551829755306244, 0.552033007144928, 0.552236020565033, 0.552438914775848, 0.55264151096344, 0.552843928337097, 0.55304616689682, 0.553248107433319, 0.553449869155884, 0.553651392459869, 0.553852736949921, 0.554053843021393, 0.554254710674286, 0.554455399513245, 0.554655909538269, 0.55485612154007, 0.555056154727936, 0.555255949497223, 0.555455565452576, 0.555655002593994, 0.555854082107544, 0.556053102016449, 0.55625182390213, 0.556450366973877, 0.5566486120224, 0.556846737861633, 0.557044625282288, 0.557242274284363, 0.557439744472504, 0.557636976242065, 0.557833969593048, 0.558030784130096, 0.558227360248566, 0.558423697948456, 0.558619856834412, 0.558815717697144, 0.559011518955231, 0.559206962585449, 0.559402227401733, 0.559597313404083, 0.559792220592499, 0.55998682975769, 0.560181260108948, 0.560375452041626, 0.56056946516037, 0.56076318025589, 0.56095677614212, 0.561150074005127, 0.561343193054199, 0.561536073684692, 0.561728835105896, 0.561921298503876, 0.562113523483276, 0.562305629253387, 0.562497437000275, 0.562689065933228, 0.562880456447601, 0.563071608543396, 0.563262522220612, 0.563453316688538, 0.56364381313324, 0.563834130764008, 0.564024269580841, 0.564214169979095, 0.564403891563416, 0.564593255519867, 0.564782500267029, 0.564971506595612, 0.56516033411026, 0.565348923206329, 0.565537333488464, 0.56572550535202, 0.565913438796997, 0.566101133823395, 0.566288650035858, 0.566475987434387, 0.566663086414337, 0.566849887371063, 0.5670365691185, 0.567223012447357, 0.567409157752991, 0.567595243453979, 0.5677809715271, 0.56796658039093, 0.568151891231537, 0.568337023258209, 0.568521976470947, 0.568706691265106, 0.568891167640686, 0.569075405597687, 0.569259524345398, 0.569443345069885, 0.569626986980438, 0.569810330867767, 0.569993555545807, 0.570176541805267, 0.570359289646149, 0.570541858673096, 0.570724189281464, 0.570906281471252, 0.571088194847107, 0.571269929409027, 0.571451365947723, 0.571632564067841, 0.571813642978668, 0.571994483470917, 0.572175085544586, 0.572355449199677, 0.572535634040833, 0.572715580463409, 0.572895288467407, 0.573074817657471, 0.573254108428955, 0.573433220386505, 0.573612093925476, 0.573790788650513, 0.573969185352325, 0.574147403240204, 0.574325442314148, 0.574503242969513, 0.574680805206299, 0.57485818862915, 0.575035333633423, 0.575212299823761, 0.575388967990875, 0.575565457344055, 0.575741767883301, 0.575917840003967, 0.576093673706055, 0.576269328594208, 0.576444804668427, 0.576619982719421, 0.576794981956482, 0.576969683170319, 0.57714432477951, 0.577318608760834, 0.577492773532867, 0.577666699886322, 0.577840328216553, 0.578013837337494, 0.578187108039856, 0.578360140323639, 0.578532993793488, 0.578705608844757, 0.578877985477448, 0.579050183296204, 0.579222142696381, 0.579393863677979, 0.579565405845642, 0.579736709594727, 0.579907834529877, 0.580078780651093, 0.580249428749084, 0.580419898033142, 0.580590128898621, 0.580760180950165, 0.580929934978485, 0.581099569797516, 0.581268906593323, 0.581438064575195, 0.581606984138489, 0.581775784492493, 0.581944286823273, 0.582112550735474, 0.58228063583374, 0.582448542118073, 0.582616150379181, 0.582783579826355, 0.582950830459595, 0.583117842674255, 0.583284616470337, 0.583451211452484, 0.583617508411407, 0.583783686161041, 0.583949625492096, 0.584115326404572, 0.584280848503113, 0.58444607257843, 0.584611117839813, 0.584775984287262, 0.584940612316132, 0.585105061531067, 0.585269212722778, 0.5854332447052, 0.585596919059753, 0.585760474205017, 0.585923850536346, 0.586086988449097, 0.586249828338623, 0.58641254901886, 0.586575031280518, 0.586737275123596, 0.58689934015274, 0.587061107158661, 0.587222754955292, 0.587384104728699, 0.587545335292816, 0.58770626783371, 0.587866961956024, 0.588027536869049, 0.58818781375885, 0.588347971439362, 0.588507831096649, 0.588667452335358, 0.588826954364777, 0.588986098766327, 0.589145183563232, 0.589303970336914, 0.589462518692017, 0.58962094783783, 0.589779078960419, 0.589937031269073, 0.590094745159149, 0.590252280235291, 0.590409457683563, 0.590566575527191, 0.59072345495224, 0.59088009595871, 0.5910364985466, 0.591192722320557, 0.591348707675934, 0.591504454612732, 0.59166008234024, 0.59181535243988, 0.591970503330231, 0.592125415802002, 0.592280149459839, 0.592434644699097, 0.592588841915131, 0.592742919921875, 0.59289675951004, 0.593050360679626, 0.593203783035278, 0.593356966972351, 0.59350997209549, 0.593662679195404, 0.593815207481384, 0.59396755695343, 0.594119608402252, 0.594271540641785, 0.594423234462738, 0.594574689865112, 0.594725966453552, 0.594876945018768, 0.595027804374695, 0.595178365707397, 0.595328748226166, 0.595478892326355, 0.59562885761261, 0.595778584480286, 0.595928072929382, 0.596077382564545, 0.596226453781128, 0.596375346183777, 0.596524000167847, 0.596672475337982, 0.596820652484894, 0.596968650817871, 0.597116470336914, 0.597264051437378, 0.597411394119263, 0.597558498382568, 0.597705483436584, 0.597852230072021, 0.597998678684235, 0.598144948482513, 0.598290979862213, 0.598436832427979, 0.59858250617981, 0.598727941513062, 0.598873138427734, 0.599018096923828, 0.599162876605988, 0.599307417869568, 0.599451720714569, 0.599595904350281, 0.599739789962769, 0.599883496761322, 0.600026905536652, 0.600170195102692, 0.600313246250153, 0.600456058979034, 0.600598692893982, 0.600741028785706, 0.600883185863495, 0.601025223731995, 0.601166903972626, 0.601308465003967, 0.60144978761673, 0.601590871810913, 0.601731717586517, 0.601872444152832, 0.602012872695923, 0.602153062820435, 0.602293133735657, 0.602432906627655, 0.602572500705719, 0.602711915969849, 0.602851092815399, 0.602989971637726, 0.603128671646118, 0.603267192840576, 0.60340541601181, 0.6035435795784, 0.603681445121765, 0.603819072246552, 0.603956520557404, 0.604093670845032, 0.604230642318726, 0.604367554187775, 0.60450404882431, 0.604640424251556, 0.604776561260223, 0.604912400245667, 0.60504812002182, 0.605183601379395, 0.60531884431839, 0.605453908443451, 0.605588734149933, 0.605723440647125, 0.605857789516449, 0.605992019176483, 0.606126010417938, 0.606259703636169, 0.606393277645111, 0.606526553630829, 0.606659710407257, 0.606792628765106, 0.606925249099731, 0.607057750225067, 0.607190012931824, 0.607322037220001, 0.607453763484955, 0.607585430145264, 0.607716798782349, 0.607847988605499, 0.607978940010071, 0.608109652996063, 0.608240187168121, 0.6083704829216, 0.608500599861145, 0.608630418777466, 0.608760118484497, 0.608889520168304, 0.609018743038177, 0.609147727489471, 0.609276533126831, 0.609405100345612, 0.609533488750458, 0.60966157913208, 0.609789550304413, 0.609917223453522, 0.610044777393341, 0.610172033309937, 0.610299110412598, 0.61042594909668, 0.610552608966827, 0.610678970813751, 0.610805213451385, 0.610931217670441, 0.611056983470917, 0.611182510852814, 0.611307919025421, 0.61143296957016, 0.611557960510254, 0.611682593822479, 0.61180704832077, 0.611931324005127, 0.612055361270905, 0.612179219722748, 0.612302839756012, 0.612426280975342, 0.612549424171448, 0.612672328948975, 0.612795054912567, 0.612917602062225, 0.613039970397949, 0.613162040710449, 0.613283932209015, 0.613405585289001, 0.613527119159698, 0.613648235797882, 0.613769292831421, 0.613890111446381, 0.614010632038116, 0.614131033420563, 0.61425119638443, 0.614371120929718, 0.614490926265717, 0.614610433578491, 0.614729702472687, 0.614848732948303, 0.61496764421463, 0.615086317062378, 0.615204691886902, 0.615320384502411, 0.615433514118195, 0.615546345710754, 0.61565899848938, 0.615771293640137, 0.615883469581604, 0.615995347499847, 0.616106927394867, 0.616218268871307, 0.616329550743103, 0.61644047498703, 0.616551041603088, 0.616661548614502, 0.616771697998047, 0.616881728172302, 0.616991460323334, 0.617100954055786, 0.617210209369659, 0.617319226264954, 0.617427945137024, 0.61753648519516, 0.617644786834717, 0.61775279045105, 0.617860615253448, 0.617968201637268, 0.618075489997864, 0.61818265914917, 0.618289411067963, 0.618396043777466, 0.618502497673035, 0.61860853433609, 0.618714451789856, 0.618820130825043, 0.618925511837006, 0.619030714035034, 0.619135618209839, 0.619240343570709, 0.619344770908356, 0.619449019432068, 0.619552910327911, 0.619656682014465, 0.619760155677795, 0.619863390922546, 0.619966447353363, 0.620069205760956, 0.620171725749969, 0.620274066925049, 0.620376110076904, 0.620477974414825, 0.620579540729523, 0.620680868625641, 0.620782017707825, 0.62088280916214, 0.620983421802521, 0.621083855628967, 0.62118399143219, 0.621283888816833, 0.621383547782898, 0.621482908725739, 0.621582090854645, 0.621681034564972, 0.621779799461365, 0.621878206729889, 0.621976494789124, 0.62207442522049, 0.622172236442566, 0.622269749641418, 0.622366964817047, 0.622464001178741, 0.622560799121857, 0.622657358646393, 0.62275356054306, 0.622849643230438, 0.622945487499237, 0.623041093349457, 0.623136460781097, 0.623231530189514, 0.623326420783997, 0.6234210729599, 0.623515486717224, 0.623609602451324, 0.62370353937149, 0.623797118663788, 0.62389063835144, 0.623983800411224, 0.624076724052429, 0.6241694688797, 0.624261856079102, 0.624354124069214, 0.624446153640747, 0.624537885189056, 0.624629378318787, 0.624720752239227, 0.624811708927155, 0.624902546405792, 0.624993085861206, 0.625083386898041, 0.625173568725586, 0.625263333320618, 0.625352919101715, 0.625442266464233, 0.625531375408173, 0.625620186328888, 0.625708878040314, 0.625797271728516, 0.625885486602783, 0.625973343849182, 0.626061141490936, 0.626148521900177, 0.626235663890839, 0.626322627067566, 0.626409411430359, 0.626495838165283, 0.626582086086273, 0.626668035984039, 0.626753866672516, 0.626839399337769, 0.626924693584442, 0.627009749412537, 0.627094507217407, 0.627179026603699, 0.627263426780701, 0.627347528934479, 0.627431392669678, 0.627514958381653, 0.627598345279694, 0.62768143415451, 0.627764344215393, 0.627847015857697, 0.627929389476776, 0.628011524677277, 0.628093481063843, 0.62817519903183, 0.628256618976593, 0.628337860107422, 0.628418743610382, 0.628499567508698, 0.628580033779144, 0.628660321235657, 0.628740310668945, 0.628820061683655, 0.628899574279785, 0.628978848457336, 0.629057943820953, 0.629136741161346, 0.629215359687805, 0.62929368019104, 0.629371821880341, 0.629449665546417, 0.629527270793915, 0.629604637622833, 0.629681766033173, 0.629758656024933, 0.629835247993469, 0.629911661148071, 0.629987955093384, 0.630063772201538, 0.630139589309692, 0.630214989185333, 0.630290269851685, 0.630365252494812, 0.630439937114716, 0.630514442920685, 0.630588710308075, 0.630662739276886, 0.630736470222473, 0.630810022354126, 0.630883395671844, 0.630956411361694, 0.631029307842255, 0.631101846694946, 0.631174147129059, 0.631246328353882, 0.631318151950836, 0.631389796733856, 0.631461203098297, 0.631532251834869, 0.631603240966797, 0.631673872470856, 0.631744265556335, 0.631814479827881, 0.631884396076202, 0.63195413351059, 0.632023572921753, 0.632092833518982, 0.632161736488342, 0.632230520248413, 0.632299065589905, 0.632367432117462, 0.632435321807861, 0.632503151893616, 0.632570803165436, 0.632637977600098, 0.63270503282547, 0.632771968841553, 0.632838547229767, 0.632904887199402, 0.632971048355103, 0.63303679227829, 0.633102536201477, 0.633167922496796, 0.633233070373535, 0.633297979831696, 0.633362710475922, 0.633427083492279, 0.633491277694702, 0.633555293083191, 0.633619070053101, 0.633682429790497, 0.633745729923248, 0.633808672428131, 0.633871376514435, 0.633933961391449, 0.633996188640594, 0.634058237075806, 0.634120106697083, 0.634181618690491, 0.634242951869965, 0.634304046630859, 0.63436484336853, 0.634425461292267, 0.634485840797424, 0.634545981884003, 0.634605824947357, 0.634665429592133, 0.634724915027618, 0.63478410243988, 0.634842991828918, 0.634901702404022, 0.634960174560547, 0.635018348693848, 0.635076344013214, 0.635134100914001, 0.63519150018692, 0.635248839855194, 0.635305821895599, 0.635362565517426, 0.635419011116028, 0.635475337505341, 0.635531485080719, 0.635587215423584, 0.635642766952515, 0.635698139667511, 0.635753214359283, 0.635808110237122, 0.635862648487091, 0.635917067527771, 0.635971248149872, 0.636025071144104, 0.636078715324402, 0.636132180690765, 0.636185348033905, 0.636238217353821, 0.636290907859802, 0.636343359947205, 0.636395633220673, 0.636447608470917, 0.636499345302582, 0.636550903320312, 0.636602103710175, 0.636653125286102, 0.636703848838806, 0.636754393577576, 0.636804699897766, 0.636854767799377, 0.63690459728241, 0.636954188346863, 0.637003540992737, 0.637052595615387, 0.637101531028748, 0.63715010881424, 0.637198507785797, 0.63724672794342, 0.63729453086853, 0.637342214584351, 0.637389600276947, 0.637436866760254, 0.637483656406403, 0.637530505657196, 0.637576937675476, 0.637623131275177, 0.637669086456299, 0.637714922428131, 0.63776034116745, 0.637805700302124, 0.637850701808929, 0.637895524501801, 0.637940049171448, 0.637984335422516, 0.63802844285965, 0.63807225227356, 0.638115763664246, 0.638159096240997, 0.638202250003815, 0.638245165348053, 0.638287782669067, 0.638330161571503, 0.638372302055359, 0.638414204120636, 0.638455927371979, 0.638497352600098, 0.638538539409637, 0.638579487800598, 0.63862019777298, 0.638660609722137, 0.638700902462006, 0.63874089717865, 0.63878071308136, 0.638820171356201, 0.638859450817108, 0.638898491859436, 0.638937294483185, 0.638975858688354, 0.63901424407959, 0.639052271842957, 0.639090061187744, 0.639127671718597, 0.639165043830872, 0.639202237129211, 0.639239013195038, 0.639275670051575, 0.639312088489532, 0.639348268508911, 0.639384210109711, 0.639419794082642, 0.639455258846283, 0.639490485191345, 0.639525532722473, 0.639560103416443, 0.639594674110413, 0.639628887176514, 0.639662861824036, 0.639696717262268, 0.639730155467987, 0.639763474464417, 0.639796495437622, 0.639829337596893, 0.639861881732941, 0.639894247055054, 0.639926373958588, 0.639958202838898, 0.639989852905273, 0.640021145343781, 0.640052318572998, 0.640083193778992, 0.640113770961761, 0.640144228935242, 0.640174388885498, 0.64020437002182, 0.640233993530273, 0.640263497829437, 0.640292704105377, 0.640321671962738, 0.640350461006165, 0.640378892421722, 0.640407204627991, 0.640435099601746, 0.640462934970856, 0.640490472316742, 0.640517771244049, 0.640544772148132, 0.640571653842926, 0.640598177909851, 0.640624523162842, 0.640650629997253, 0.640676438808441, 0.640702128410339, 0.640727460384369, 0.640752613544464, 0.640777587890625, 0.640802204608917, 0.640826642513275, 0.640850841999054, 0.640874803066254, 0.640898406505585, 0.640921890735626, 0.640945196151733, 0.640968143939972, 0.640990853309631, 0.641013383865356, 0.641035676002502, 0.64105761051178, 0.641079485416412, 0.641101002693176, 0.641122281551361, 0.641143381595612, 0.641164183616638, 0.641184747219086, 0.641205132007599, 0.641225218772888, 0.641245067119598, 0.641264736652374, 0.641284048557281, 0.641303241252899, 0.641322195529938, 0.641340792179108, 0.641359210014343, 0.641377389431, 0.641395330429077, 0.64141309261322, 0.641430556774139, 0.641447782516479, 0.64146476984024, 0.641481518745422, 0.641498029232025, 0.641514360904694, 0.641530334949493, 0.641546130180359, 0.64156174659729, 0.641576945781708, 0.641592025756836, 0.641606986522675, 0.641621470451355, 0.641635835170746, 0.641649961471558, 0.64166384935379, 0.641677498817444, 0.641690909862518, 0.641704082489014, 0.641716957092285, 0.641729593276978, 0.64174211025238, 0.641754329204559, 0.641766250133514, 0.641777992248535, 0.641789436340332, 0.641800701618195, 0.641811609268188, 0.641822397708893, 0.641833007335663, 0.641843199729919, 0.641853272914886, 0.64186304807663, 0.641872644424438, 0.641882002353668, 0.641891062259674, 0.641899943351746, 0.641908526420593, 0.641916871070862, 0.641925036907196, 0.641932845115662, 0.641940534114838, 0.64194792509079, 0.641955077648163, 0.641962051391602, 0.641968727111816, 0.641975224018097, 0.641981363296509, 0.641987264156342, 0.64199310541153, 0.641998648643494, 0.642003834247589, 0.642008900642395, 0.642013609409332, 0.642018139362335, 0.642022430896759, 0.642026484012604, 0.642030298709869, 0.642033815383911, 0.642037153244019, 0.642040252685547, 0.642043113708496, 0.642045736312866, 0.642048180103302, 0.642050325870514, 0.642052173614502, 0.642053842544556, 0.64205527305603, 0.642056405544281, 0.642057359218597, 0.642058074474335, 0.642058491706848, 0.642058730125427, 0.642058670520782, 0.642058432102203, 0.642057955265045, 0.642057240009308, 0.642056226730347, 0.642054975032806, 0.642053544521332, 0.642051815986633, 0.642049908638, 0.642047762870789, 0.642045319080353, 0.642042696475983, 0.642039716243744, 0.64203667640686, 0.642033219337463, 0.642029643058777, 0.642025768756866, 0.642021656036377, 0.642017364501953, 0.642012774944305, 0.642007946968079, 0.642002940177917, 0.641997635364532, 0.641992032527924, 0.64198625087738, 0.641980290412903, 0.641974031925201, 0.641965866088867, 0.641955673694611, 0.641945362091064, 0.641934871673584, 0.64192396402359, 0.641912877559662, 0.641901671886444, 0.641890168190002, 0.641878485679626, 0.641866505146027, 0.641854286193848, 0.641841948032379, 0.641829311847687, 0.641816377639771, 0.641803324222565, 0.64178991317749, 0.641776382923126, 0.641762495040894, 0.641748607158661, 0.64173424243927, 0.64171975851059, 0.64170503616333, 0.641690135002136, 0.641674876213074, 0.641659557819366, 0.641643881797791, 0.64162802696228, 0.641611874103546, 0.641595602035522, 0.641579031944275, 0.641562223434448, 0.641545236110687, 0.641528010368347, 0.641510486602783, 0.641492784023285, 0.641474843025208, 0.641456604003906, 0.641438245773315, 0.641419529914856, 0.641400754451752, 0.641381621360779, 0.641362309455872, 0.641342759132385, 0.641323029994965, 0.64130300283432, 0.641282677650452, 0.641262292861938, 0.641241610050201, 0.64122062921524, 0.6411994099617, 0.641178071498871, 0.641156435012817, 0.64113461971283, 0.641112506389618, 0.641090154647827, 0.641067624092102, 0.641044855117798, 0.641021847724915, 0.640998601913452, 0.640975117683411, 0.64095139503479, 0.640927493572235, 0.640903413295746, 0.640878975391388, 0.64085441827774, 0.640829503536224, 0.640804409980774, 0.640779137611389, 0.640753567218781, 0.640727818012238, 0.640701770782471, 0.640675604343414, 0.640649080276489, 0.640622317790985, 0.640595436096191, 0.640568315982819, 0.640540897846222, 0.640513300895691, 0.640485525131226, 0.640457451343536, 0.640429139137268, 0.640400588512421, 0.640371859073639, 0.640342831611633, 0.640313625335693, 0.640284180641174, 0.640254497528076, 0.640224516391754, 0.640194416046143, 0.640164017677307, 0.640133440494537, 0.640102565288544, 0.64007157087326, 0.640040218830109, 0.640008807182312, 0.639976978302002, 0.639945030212402, 0.639912724494934, 0.639880299568176, 0.639847636222839, 0.639814734458923, 0.639781594276428, 0.639748275279999, 0.639714658260345, 0.639680802822113, 0.639646708965302, 0.6396124958992, 0.639577925205231, 0.639543175697327, 0.639508187770844, 0.639473021030426, 0.639437615871429, 0.639401853084564, 0.639365971088409, 0.63932991027832, 0.639293491840363, 0.639256954193115, 0.639220118522644, 0.639182984828949, 0.639145791530609, 0.639108300209045, 0.639070510864258, 0.639032542705536, 0.63899439573288, 0.638955891132355, 0.63891726732254, 0.638878345489502, 0.638839304447174, 0.638799846172333, 0.638760328292847, 0.638720512390137, 0.638680458068848, 0.638640224933624, 0.638599693775177, 0.638558924198151, 0.63851797580719, 0.63847678899765, 0.638435363769531, 0.638393640518188, 0.638351857662201, 0.638309717178345, 0.638267338275909, 0.63822478055954, 0.638181984424591, 0.638138949871063, 0.638095617294312, 0.638052225112915, 0.63800847530365, 0.637964487075806, 0.637920260429382, 0.637875914573669, 0.637831211090088, 0.637786269187927, 0.637741267681122, 0.637695968151093, 0.637650370597839, 0.637604594230652, 0.63755851984024, 0.637512266635895, 0.637465715408325, 0.637419044971466, 0.637372076511383, 0.63732498884201, 0.637277603149414, 0.637229919433594, 0.637181997299194, 0.637133955955505, 0.637085556983948, 0.637037038803101, 0.63698822259903, 0.636939227581024, 0.636889934539795, 0.636840403079987, 0.636790692806244, 0.636740803718567, 0.636690616607666, 0.636640191078186, 0.636589646339417, 0.636538803577423, 0.636487662792206, 0.636436343193054, 0.636384785175323, 0.636332988739014, 0.63628101348877, 0.636228740215302, 0.63617616891861, 0.636123538017273, 0.636070609092712, 0.636017501354218, 0.635964035987854, 0.635910511016846, 0.635856628417969, 0.635802507400513, 0.635748207569122, 0.635693609714508, 0.635638892650604, 0.635583877563477, 0.63552862405777, 0.635473191738129, 0.635417461395264, 0.635361552238464, 0.635305345058441, 0.635248959064484, 0.635192394256592, 0.635135531425476, 0.635078430175781, 0.635021150112152, 0.634963631629944, 0.634905874729156, 0.63484787940979, 0.634789526462555, 0.63473117351532, 0.634672403335571, 0.634613513946533, 0.634554445743561, 0.634494960308075, 0.6344353556633, 0.634375512599945, 0.634315431118011, 0.634255230426788, 0.634194612503052, 0.634133756160736, 0.63407289981842, 0.634011685848236, 0.633950233459473, 0.633888483047485, 0.633826553821564, 0.633764445781708, 0.633702039718628, 0.633639454841614, 0.633576631546021, 0.633513629436493, 0.633450269699097, 0.633386790752411, 0.633323073387146, 0.633258998394012, 0.633194804191589, 0.633130311965942, 0.633065700531006, 0.633000791072845, 0.632935583591461, 0.632870197296143, 0.632804751396179, 0.632738888263702, 0.632672846317291, 0.632606565952301, 0.632540047168732, 0.632473230361938, 0.632406234741211, 0.632339119911194, 0.632271647453308, 0.632203996181488, 0.632136046886444, 0.632067978382111, 0.631999552249908, 0.631930947303772, 0.631862163543701, 0.631793081760406, 0.631723880767822, 0.631654322147369, 0.631584525108337, 0.631514608860016, 0.63144439458847, 0.631374001502991, 0.631303369998932, 0.631232380867004, 0.631161332130432, 0.631089925765991, 0.631018400192261, 0.630946576595306, 0.630874514579773, 0.630802273750305, 0.630729734897614, 0.630657076835632, 0.630584120750427, 0.630510866641998, 0.63043749332428, 0.630363762378693, 0.630289852619171, 0.630215764045715, 0.630141377449036, 0.630066871643066, 0.629992008209229, 0.629916965961456, 0.62984174489975, 0.629766166210175, 0.629690527915955, 0.629614531993866, 0.629538416862488, 0.629462003707886, 0.62938529253006, 0.6293084025383, 0.629231333732605, 0.629153966903687, 0.629076480865479, 0.628998696804047, 0.628920555114746, 0.628842353820801, 0.628763854503632, 0.628685176372528, 0.628606200218201, 0.628527045249939, 0.628447651863098, 0.628367900848389, 0.628288090229034, 0.628207981586456, 0.628127634525299, 0.628047108650208, 0.627966284751892, 0.627885282039642, 0.627804100513458, 0.627722561359406, 0.627640843391418, 0.627558946609497, 0.627476751804352, 0.627394318580627, 0.627311766147614, 0.627228856086731, 0.627145707607269, 0.627062439918518, 0.626978814601898, 0.626895129680634, 0.6268110871315, 0.626726865768433, 0.626642346382141, 0.626557588577271, 0.62647271156311, 0.626387536525726, 0.626302123069763, 0.62621659040451, 0.626130640506744, 0.626044631004333, 0.625958263874054, 0.625871777534485, 0.625784933567047, 0.62569797039032, 0.625610709190369, 0.625523269176483, 0.625435531139374, 0.62534761428833, 0.625259459018707, 0.62517112493515, 0.625082492828369, 0.624993622303009, 0.624904572963715, 0.624815225601196, 0.624725699424744, 0.624635934829712, 0.624545931816101, 0.624455749988556, 0.624365270137787, 0.624274492263794, 0.624183654785156, 0.62409245967865, 0.624001085758209, 0.623909473419189, 0.623817682266235, 0.623725593090057, 0.6236332654953, 0.623540759086609, 0.623447954654694, 0.623354971408844, 0.623261868953705, 0.623168349266052, 0.623074650764465, 0.622980713844299, 0.622886598110199, 0.62279224395752, 0.622697591781616, 0.622602760791779, 0.622507691383362, 0.622412443161011, 0.622316837310791, 0.622221171855927, 0.622125208377838, 0.622028946876526, 0.621932506561279, 0.621835768222809, 0.621738910675049, 0.62164181470871, 0.621544480323792, 0.621446788311005, 0.621348977088928, 0.621250927448273, 0.621152639389038, 0.621054172515869, 0.620955348014832, 0.620856404304504, 0.620757162570953, 0.620657742023468, 0.620558083057404, 0.62045818567276, 0.620358049869537, 0.62025773525238, 0.620157122612, 0.62005627155304, 0.619955241680145, 0.619853973388672, 0.619752526283264, 0.619650721549988, 0.619548738002777, 0.619446575641632, 0.619344055652618, 0.61924147605896, 0.619138538837433, 0.619035422801971, 0.618932127952576, 0.618828475475311, 0.618724703788757, 0.618620693683624, 0.618516385555267, 0.618411839008331, 0.618307173252106, 0.618202269077301, 0.618097066879272, 0.617991626262665, 0.617885947227478, 0.617780089378357, 0.617673933506012, 0.617567598819733, 0.617461025714874, 0.617354273796082, 0.61724716424942, 0.617139995098114, 0.617032408714294, 0.616924703121185, 0.616816759109497, 0.616708517074585, 0.616600096225739, 0.616491556167603, 0.616382598876953, 0.616273522377014, 0.616164207458496, 0.616054654121399, 0.615944743156433, 0.615834772586823, 0.615724503993988, 0.615614116191864, 0.615503311157227, 0.6153923869133, 0.615281164646149, 0.615169823169708, 0.615058124065399, 0.614946246147156, 0.614834189414978, 0.614721834659576, 0.614609241485596, 0.614496529102325, 0.614383518695831, 0.614270329475403, 0.614156723022461, 0.614043116569519, 0.613929092884064, 0.613814890384674, 0.613700568675995, 0.613585889339447, 0.613471031188965, 0.613355875015259, 0.613240599632263, 0.613125085830688, 0.613009333610535, 0.612893283367157, 0.612777054309845, 0.612660586833954, 0.612543880939484, 0.612426996231079, 0.612309813499451, 0.612192392349243, 0.612074732780457, 0.611956894397736, 0.611838817596436, 0.611720502376556, 0.611601948738098, 0.611483097076416, 0.611364185810089, 0.611244916915894, 0.611125528812408, 0.61100572347641, 0.610885858535767, 0.610765755176544, 0.610645234584808, 0.610524654388428, 0.610403835773468, 0.610282778739929, 0.610161483287811, 0.610039889812469, 0.609918117523193, 0.609796166419983, 0.609673976898193, 0.609551429748535, 0.609428822994232, 0.609305858612061, 0.60918265581131, 0.60905933380127, 0.608935654163361, 0.608811795711517, 0.608687818050385, 0.608563482761383, 0.608438968658447, 0.608314216136932, 0.608185648918152, 0.608053386211395, 0.607920944690704, 0.607788264751434, 0.60765540599823, 0.607522308826447, 0.607389152050018, 0.607255697250366, 0.607122182846069, 0.606988489627838, 0.606854557991028, 0.606720447540283, 0.606586158275604, 0.606451749801636, 0.606317102909088, 0.606182277202606, 0.60604727268219, 0.605912148952484, 0.605776786804199, 0.605641305446625, 0.605505585670471, 0.605369687080383, 0.605233609676361, 0.605097413063049, 0.604960978031158, 0.604824364185333, 0.604687631130219, 0.604550659656525, 0.604413509368896, 0.604276239871979, 0.604138731956482, 0.604001045227051, 0.60386323928833, 0.603725135326385, 0.603586971759796, 0.603448569774628, 0.60331004858017, 0.603171348571777, 0.603032410144806, 0.6028932929039, 0.60275399684906, 0.602614521980286, 0.602474927902222, 0.602335095405579, 0.602195084095001, 0.602054953575134, 0.601914584636688, 0.601774096488953, 0.601633369922638, 0.601492464542389, 0.60135143995285, 0.601210176944733, 0.601068735122681, 0.600927174091339, 0.600785374641418, 0.600643455982208, 0.600501298904419, 0.60035902261734, 0.600216507911682, 0.60007381439209, 0.599930942058563, 0.599787890911102, 0.599644720554352, 0.599501371383667, 0.599357783794403, 0.599214017391205, 0.599070072174072, 0.59892600774765, 0.598781764507294, 0.598637282848358, 0.598492681980133, 0.598347842693329, 0.59820282459259, 0.598057627677917, 0.597912311553955, 0.597766757011414, 0.597621142864227, 0.597475171089172, 0.597329139709473, 0.597182869911194, 0.597036480903625, 0.596889913082123, 0.596743047237396, 0.596596121788025, 0.596449017524719, 0.596301674842834, 0.596154153347015, 0.596006512641907, 0.595858633518219, 0.595710635185242, 0.595562398433685, 0.595414042472839, 0.595265448093414, 0.595116674900055, 0.594967782497406, 0.594818711280823, 0.59466940164566, 0.594519913196564, 0.594370305538177, 0.594220519065857, 0.594070494174957, 0.593920290470123, 0.593769967556, 0.593619465827942, 0.593468725681305, 0.593317866325378, 0.593166768550873, 0.593015551567078, 0.592864096164703, 0.592712461948395, 0.592560708522797, 0.592408716678619, 0.592256605625153, 0.592104256153107, 0.591951787471771, 0.591799139976501, 0.591646254062653, 0.591493189334869, 0.591340065002441, 0.59118664264679, 0.591033041477203, 0.590879321098328, 0.590725362300873, 0.590571284294128, 0.59041690826416, 0.590262532234192, 0.590107917785645, 0.589953064918518, 0.589798092842102, 0.589642882347107, 0.589487493038177, 0.589331984519958, 0.589176177978516, 0.589020371437073, 0.588864266872406, 0.588707983493805, 0.588551580905914, 0.588394999504089, 0.58823823928833, 0.588081240653992, 0.587924122810364, 0.587766826152802, 0.587609350681305, 0.587451636791229, 0.587293803691864, 0.58713573217392, 0.586977541446686, 0.586819112300873, 0.586660504341125, 0.586501777172089, 0.586342871189117, 0.586183786392212, 0.586024522781372, 0.585865020751953, 0.585705399513245, 0.585545539855957, 0.58538556098938, 0.585225343704224, 0.585065007209778, 0.584904491901398, 0.584743678569794, 0.58458286523819, 0.584421813488007, 0.584260523319244, 0.584099054336548, 0.583937525749207, 0.583775699138641, 0.583613753318787, 0.583451569080353, 0.583289265632629, 0.583126783370972, 0.582964062690735, 0.582801222801208, 0.582638204097748, 0.582474946975708, 0.582311511039734, 0.582148015499115, 0.581984221935272, 0.581820249557495, 0.581656217575073, 0.581491887569427, 0.581327438354492, 0.581162810325623, 0.580997943878174, 0.580832958221436, 0.580667734146118, 0.580502450466156, 0.58033686876297, 0.58017110824585, 0.580005288124084, 0.579839110374451, 0.579672873020172, 0.579506516456604, 0.579339861869812, 0.57917308807373, 0.579006135463715, 0.57883894443512, 0.578671634197235, 0.578504145145416, 0.578336417675018, 0.578168570995331, 0.578000545501709, 0.577832341194153, 0.577663898468018, 0.577495336532593, 0.577326536178589, 0.577157616615295, 0.576988518238068, 0.576819241046906, 0.576649785041809, 0.576480090618134, 0.576310276985168, 0.576140284538269, 0.575970053672791, 0.575799703598022, 0.57562917470932, 0.575458467006683, 0.575287580490112, 0.575116515159607, 0.574945211410522, 0.574773788452148, 0.574602127075195, 0.574430406093597, 0.57425844669342, 0.574086248874664, 0.573913931846619, 0.573741436004639, 0.573568761348724, 0.573395848274231, 0.573222815990448, 0.573049604892731, 0.572876214981079, 0.572702646255493, 0.572528779506683, 0.572354853153229, 0.572180807590485, 0.572006464004517, 0.571832060813904, 0.571657419204712, 0.571482539176941, 0.57130753993988, 0.571132302284241, 0.570957005023956, 0.570781469345093, 0.57060569524765, 0.570429801940918, 0.570253729820251, 0.570077419281006, 0.569900989532471, 0.569724380970001, 0.569547653198242, 0.569370627403259, 0.569193422794342, 0.569016098976135, 0.568838596343994, 0.568660914897919, 0.568483054637909, 0.56830507516861, 0.568126797676086, 0.567948400974274, 0.567769765853882, 0.5675910115242, 0.567412078380585, 0.567232966423035, 0.56705367565155, 0.566874206066132, 0.566694557666779, 0.566514730453491, 0.566334664821625, 0.566154479980469, 0.565974116325378, 0.565793573856354, 0.565612852573395, 0.565431952476501, 0.565250873565674, 0.565069615840912, 0.564888179302216, 0.564706563949585, 0.564524710178375, 0.564342796802521, 0.564160585403442, 0.563978254795074, 0.563795745372772, 0.563613057136536, 0.563430190086365, 0.56324714422226, 0.56306391954422, 0.562880516052246, 0.562696933746338, 0.562513113021851, 0.562329232692719, 0.562145113945007, 0.561960756778717, 0.561776280403137, 0.561591625213623, 0.561406791210175, 0.561221778392792, 0.561036586761475, 0.560851216316223, 0.560665667057037, 0.560479938983917, 0.560294091701508, 0.560107946395874, 0.559921681880951, 0.559735238552094, 0.559548616409302, 0.559361815452576, 0.559174835681915, 0.558987677097321, 0.558800280094147, 0.558612823486328, 0.558425068855286, 0.558237254619598, 0.558049201965332, 0.557860910892487, 0.557672560214996, 0.557483971118927, 0.557295203208923, 0.557106256484985, 0.556917130947113, 0.556727826595306, 0.556538343429565, 0.55634868144989, 0.556158781051636, 0.555968761444092, 0.555778622627258, 0.555588185787201, 0.555397689342499, 0.555206954479218, 0.555016040802002, 0.554824948310852, 0.554633677005768, 0.554442226886749, 0.554250597953796, 0.554058790206909, 0.553866803646088, 0.553674638271332, 0.553482294082642, 0.553289771080017, 0.553097128868103, 0.552904188632965, 0.552711188793182, 0.552517950534821, 0.552324533462524, 0.552130877971649, 0.551937103271484, 0.551743149757385, 0.551549077033997, 0.551354765892029, 0.551160275936127, 0.55096560716629, 0.55077075958252, 0.550575733184814, 0.550380527973175, 0.550185143947601, 0.549989581108093, 0.549793899059296, 0.549597918987274, 0.549401819705963, 0.549205601215363, 0.549009084701538, 0.548812508583069, 0.548615634441376, 0.548418700695038, 0.548221588134766, 0.548024237155914, 0.547826707363129, 0.547628998756409, 0.547431111335754, 0.547233045101166, 0.547034800052643, 0.546836376190186, 0.546637833118439, 0.546438992023468, 0.546240031719208, 0.546040952205658, 0.545841634273529, 0.545642137527466, 0.545442461967468, 0.545242607593536, 0.545042634010315, 0.54484236240387, 0.54464203119278, 0.54444146156311, 0.544240713119507, 0.544039845466614, 0.543838679790497, 0.543637454509735, 0.543435990810394, 0.543234348297119, 0.543032586574554, 0.542830526828766, 0.542628407478333, 0.54242604970932, 0.542223513126373, 0.542020857334137, 0.541817903518677, 0.541614830493927, 0.541411638259888, 0.541208207607269, 0.541004598140717, 0.540800809860229, 0.540596842765808, 0.540392696857452, 0.540188431739807, 0.539983928203583, 0.539779245853424, 0.539574444293976, 0.539369344711304, 0.539164185523987, 0.538958847522736, 0.53875321149826, 0.538547515869141, 0.538341522216797, 0.538135468959808, 0.537929236888885, 0.537722706794739, 0.537516117095947, 0.537309288978577, 0.537102282047272, 0.536895096302032, 0.536687791347504, 0.536480247974396, 0.536272585391998, 0.536064684391022, 0.535856604576111, 0.535648345947266, 0.535439908504486, 0.535231292247772, 0.535022497177124, 0.534813582897186, 0.534604430198669, 0.534395098686218, 0.534185647964478, 0.533975958824158, 0.533766090869904, 0.53355610370636, 0.533345878124237, 0.53313547372818, 0.532924890518188, 0.532714188098907, 0.532503247261047, 0.532292127609253, 0.532080829143524, 0.531869411468506, 0.531657755374908, 0.531445980072021, 0.531233906745911, 0.5310218334198, 0.53080940246582, 0.530596911907196, 0.530384123325348, 0.530171275138855, 0.529958248138428, 0.529744982719421, 0.529531538486481, 0.529317915439606, 0.529104173183441, 0.528890252113342, 0.528676092624664, 0.528461813926697, 0.528247237205505, 0.528032600879669, 0.527817726135254, 0.527602672576904, 0.527387499809265, 0.527172088623047, 0.526956558227539, 0.526740849018097, 0.526524841785431, 0.526308715343475, 0.52609246969223, 0.525876045227051, 0.525659322738647, 0.525442540645599, 0.525225520133972, 0.525008380413055, 0.52479100227356, 0.524573504924774, 0.52435576915741, 0.524137854576111, 0.523919820785522, 0.523701548576355, 0.523483157157898, 0.523264527320862, 0.523045718669891, 0.522826790809631, 0.522607624530792, 0.522388339042664, 0.522168755531311, 0.521949112415314, 0.521729230880737, 0.521509230136871, 0.521288990974426, 0.521068632602692, 0.520848095417023, 0.52062726020813, 0.520406365394592, 0.52018529176712, 0.519963979721069, 0.519739925861359, 0.519513368606567, 0.519286692142487, 0.519059956073761, 0.518833160400391, 0.518606245517731, 0.518379330635071, 0.518152356147766, 0.517925202846527, 0.517698049545288, 0.51747077703476, 0.517243385314941, 0.517015993595123, 0.516788423061371, 0.516560852527618, 0.516333222389221, 0.516105473041534, 0.515877664089203, 0.515649676322937, 0.515421748161316, 0.515193700790405, 0.514965534210205, 0.51473730802536, 0.51450902223587, 0.514280676841736, 0.514052271842957, 0.513823688030243, 0.513595104217529, 0.513366401195526, 0.513137698173523, 0.512908816337585, 0.512679874897003, 0.512450933456421, 0.512221872806549, 0.511992692947388, 0.511763393878937, 0.511534154415131, 0.511304676532745, 0.511075258255005, 0.510845720767975, 0.510616064071655, 0.510386347770691, 0.510156631469727, 0.509926736354828, 0.509696841239929, 0.509466767311096, 0.509236693382263, 0.509006500244141, 0.508776247501373, 0.508545875549316, 0.50831550359726, 0.508085012435913, 0.507854402065277, 0.507623791694641, 0.507393062114716, 0.507162272930145, 0.506931364536285, 0.506700456142426, 0.506469368934631, 0.506238281726837, 0.506007015705109, 0.50577574968338, 0.505544483661652, 0.505312979221344, 0.505081474781036, 0.504849910736084, 0.504618227481842, 0.504386484622955, 0.504154622554779, 0.503922760486603, 0.503690779209137, 0.503458678722382, 0.503226578235626, 0.502994358539581, 0.502762079238892, 0.502529680728912, 0.502297222614288, 0.50206470489502, 0.501832127571106, 0.501599371433258, 0.501366674900055, 0.501133799552917, 0.50090080499649, 0.500667870044708, 0.500434815883636, 0.500201642513275, 0.499968379735947, 0.499735087156296, 0.499501615762711, 0.49926820397377, 0.49903467297554, 0.498801052570343, 0.498567312955856, 0.498333543539047, 0.498099684715271, 0.497865736484528, 0.497631698846817, 0.497397601604462, 0.497163444757462, 0.496929138898849, 0.49669486284256, 0.496460437774658, 0.496225923299789, 0.495991379022598, 0.495756685733795, 0.49552196264267, 0.495287179946899, 0.49505227804184, 0.49481737613678, 0.494582265615463, 0.494347155094147, 0.494111895561218, 0.493876665830612, 0.493641346693039, 0.493405878543854, 0.493170350790024, 0.492934733629227, 0.49269911646843, 0.492463380098343, 0.492227494716644, 0.491991579532623, 0.49175563454628, 0.491519600152969, 0.491283416748047, 0.491047233343124, 0.49081090092659, 0.490574538707733, 0.490338116884232, 0.490101546049118, 0.489864975214005, 0.489628255367279, 0.489391475915909, 0.489154636859894, 0.488917738199234, 0.488680690526962, 0.488443613052368, 0.488206446170807, 0.487969189882278, 0.487731873989105, 0.487494498491287, 0.48725700378418, 0.487019449472427, 0.48678183555603, 0.486544102430344, 0.486306309700012, 0.486068427562714, 0.48583048582077, 0.48559245467186, 0.485354363918304, 0.485116183757782, 0.484877943992615, 0.48463961482048, 0.484401196241379, 0.484162658452988, 0.483924120664597, 0.483685493469238, 0.483446717262268, 0.483207881450653, 0.482969015836716, 0.482730060815811, 0.482491046190262, 0.482251882553101, 0.482012689113617, 0.481773406267166, 0.481534004211426, 0.481294602155685, 0.481055110692978, 0.480815470218658, 0.480575829744339, 0.48033607006073, 0.480096250772476, 0.479856312274933, 0.479616343975067, 0.479376286268234, 0.479136139154434, 0.478895872831345, 0.478655606508255, 0.478415191173553, 0.478174775838852, 0.477934211492538, 0.47769358754158, 0.477452903985977, 0.477212160825729, 0.476971328258514, 0.476730346679688, 0.476489335298538, 0.476248264312744, 0.476007103919983, 0.475765854120255, 0.475524544715881, 0.475283145904541, 0.475041657686234, 0.474800080060959, 0.474558442831039, 0.474316745996475, 0.474074959754944, 0.473833113908768, 0.47359111905098, 0.473349124193192, 0.473106980323792, 0.472864806652069, 0.47262254357338, 0.472380191087723, 0.472137749195099, 0.47189524769783, 0.471652686595917, 0.471410095691681, 0.471167296171188, 0.470924466848373, 0.470681607723236, 0.470438659191132, 0.47019562125206, 0.469952464103699, 0.469709247350693, 0.46946594119072, 0.469222605228424, 0.468979150056839, 0.468735665082932, 0.468492031097412, 0.46824836730957, 0.468004643917084, 0.467760771512985, 0.467516869306564, 0.467272907495499, 0.467028826475143, 0.466784656047821, 0.466540455818176, 0.466296136379242, 0.466051787137985, 0.465807259082794, 0.465562760829926, 0.465318113565445, 0.465073436498642, 0.464828640222549, 0.464583784341812, 0.464338839054108, 0.464093834161758, 0.463848739862442, 0.463603585958481, 0.46335831284523, 0.463112980127335, 0.462867617607117, 0.462622135877609, 0.462376594543457, 0.462130934000015, 0.461885184049606, 0.461639434099197, 0.461393535137177, 0.461147606372833, 0.4609015583992, 0.460655450820923, 0.460409253835678, 0.460162997245789, 0.459916681051254, 0.45967024564743, 0.459423720836639, 0.459177166223526, 0.458930462598801, 0.458683729171753, 0.458436906337738, 0.458190053701401, 0.457943052053452, 0.457695990800858, 0.457448869943619, 0.45720162987709, 0.456954330205917, 0.456707030534744, 0.456459552049637, 0.456212043762207, 0.45596444606781, 0.455716758966446, 0.455468982458115, 0.455221146345139, 0.454973250627518, 0.45472526550293, 0.454477161169052, 0.454229027032852, 0.453980773687363, 0.453732490539551, 0.453484117984772, 0.453235626220703, 0.45298707485199, 0.452738493680954, 0.452489793300629, 0.452240973711014, 0.451992154121399, 0.451743215322495, 0.451494157314301, 0.451245129108429, 0.450995951890945, 0.450746685266495, 0.450497359037399, 0.450247913599014, 0.449998468160629, 0.449748903512955, 0.449499249458313, 0.449249565601349, 0.448999732732773, 0.448749840259552, 0.448499888181686, 0.448249876499176, 0.447999745607376, 0.447749525308609, 0.44749927520752, 0.447248935699463, 0.446998476982117, 0.446748018264771, 0.446497440338135, 0.446246743202209, 0.445996016263962, 0.445745199918747, 0.445494323968887, 0.445243328809738, 0.444992274045944, 0.444741159677505, 0.444489896297455, 0.444238632917404, 0.443987309932709, 0.443735808134079, 0.443484276533127, 0.443232655525208, 0.442980974912643, 0.442729234695435, 0.442477375268936, 0.442225456237793, 0.441973477602005, 0.441721379756927, 0.441469222307205, 0.441217005252838, 0.440964698791504, 0.440712302923203, 0.440459847450256, 0.440207332372665, 0.43995463848114, 0.439701974391937, 0.439449191093445, 0.439196318387985, 0.438943415880203, 0.438690364360809, 0.438437312841415, 0.43818411231041, 0.437930822372437, 0.437677472829819, 0.437424063682556, 0.437170594930649, 0.436917036771774, 0.436663389205933, 0.436409682035446, 0.43615585565567, 0.435901969671249, 0.435648053884506, 0.435393989086151, 0.435139894485474, 0.434885680675507, 0.434631407260895, 0.434377074241638, 0.434122651815414, 0.433868110179901, 0.433613508939743, 0.433358877897263, 0.43310409784317, 0.432849287986755, 0.432594388723373, 0.432339429855347, 0.432084321975708, 0.431829243898392, 0.431573987007141, 0.431318700313568, 0.43106335401535, 0.430807888507843, 0.430552363395691, 0.430296748876572, 0.430041074752808, 0.429785281419754, 0.429529428482056, 0.429273575544357, 0.429017543792725, 0.428761452436447, 0.428505301475525, 0.428249061107635, 0.427992761135101, 0.427736341953278, 0.427479863166809, 0.427223354578018, 0.426966696977615, 0.42671000957489, 0.426453202962875, 0.426196336746216, 0.425939440727234, 0.425682365894318, 0.425425320863724, 0.425168097019196, 0.424910813570023, 0.424653500318527, 0.424396097660065, 0.424138575792313, 0.423881053924561, 0.423623412847519, 0.42336568236351, 0.423107862472534, 0.422849953174591, 0.422592014074326, 0.422333955764771, 0.422075837850571, 0.421817660331726, 0.421559393405914, 0.421301007270813, 0.421042591333389, 0.420784056186676, 0.420525521039963, 0.420266836881638, 0.420008093118668, 0.419749230146408, 0.419490337371826, 0.419231325387955, 0.418972283601761, 0.4187131524086, 0.418453931808472, 0.418194621801376, 0.417935252189636, 0.417675793170929, 0.417416274547577, 0.41715669631958, 0.416896969079971, 0.41663721203804, 0.416377335786819, 0.416117459535599, 0.415857434272766, 0.415597349405289, 0.415337175130844, 0.415076941251755, 0.414816647768021, 0.414556235074997, 0.414295732975006, 0.414035201072693, 0.41377454996109, 0.413513869047165, 0.413253098726273, 0.412992179393768, 0.412731260061264, 0.412470281124115, 0.412209182977676, 0.411947995424271, 0.411686688661575, 0.41142538189888, 0.411163926124573, 0.410902470350266, 0.410640895366669, 0.410379230976105, 0.410117506980896, 0.40985569357872, 0.409593820571899, 0.409331858158112, 0.409069776535034, 0.408807665109634, 0.408545464277267, 0.408283174037933, 0.408020824193954, 0.407758355140686, 0.407495886087418, 0.40723329782486, 0.406970620155334, 0.406707853078842, 0.406445056200027, 0.406182140111923, 0.405919194221497, 0.405656069517136, 0.405392974615097, 0.405129700899124, 0.404866427183151, 0.404603034257889, 0.404339551925659, 0.404076039791107, 0.403812408447266, 0.403548687696457, 0.403284996747971, 0.403021097183228, 0.402757197618484, 0.40249314904213, 0.40222904086113, 0.40196493268013, 0.401700675487518, 0.401436388492584, 0.401171952486038, 0.400907456874847, 0.400642931461334, 0.400378316640854, 0.400113582611084, 0.399848788976669, 0.399583905935287, 0.399318963289261, 0.399053931236267, 0.398788839578629, 0.398523658514023, 0.39825838804245, 0.397993087768555, 0.397727608680725, 0.397462159395218, 0.397196590900421, 0.396930873394012, 0.396666347980499, 0.396403342485428, 0.396140307188034, 0.395877361297607, 0.395614445209503, 0.395351588726044, 0.395088642835617, 0.394825786352158, 0.394563049077988, 0.394300222396851, 0.394037544727325, 0.393774807453156, 0.39351212978363, 0.393249481916428, 0.392986834049225, 0.392724305391312, 0.392461687326431, 0.392199158668518, 0.39193668961525, 0.391674220561981, 0.391411811113358, 0.391149371862411, 0.39088699221611, 0.390624672174454, 0.390362352132797, 0.390100091695786, 0.389837861061096, 0.389575660228729, 0.38931342959404, 0.38905131816864, 0.388789147138596, 0.388527125120163, 0.388265043497086, 0.388002991676331, 0.387741029262543, 0.387478977441788, 0.387217104434967, 0.386955171823502, 0.386693328619003, 0.386431515216827, 0.386169642210007, 0.385907918214798, 0.385646134614944, 0.385384410619736, 0.385122716426849, 0.384861022233963, 0.384599477052689, 0.384337872266769, 0.384076297283173, 0.383814781904221, 0.383553236722946, 0.383291780948639, 0.383030354976654, 0.382768929004669, 0.382507562637329, 0.382246196269989, 0.381984919309616, 0.381723612546921, 0.381462335586548, 0.38120111823082, 0.380939960479736, 0.380678802728653, 0.38041764497757, 0.380156517028809, 0.379895508289337, 0.379634439945221, 0.379373490810394, 0.379112482070923, 0.378851532936096, 0.378590613603592, 0.378329753875732, 0.378068923950195, 0.377808064222336, 0.377547264099121, 0.377286523580551, 0.377025783061981, 0.376765102148056, 0.376504480838776, 0.376243859529495, 0.375983208417892, 0.375722646713257, 0.375462055206299, 0.375201612710953, 0.374941110610962, 0.374680697917938, 0.374420255422592, 0.374159872531891, 0.373899549245834, 0.3736392557621, 0.373378932476044, 0.373118698596954, 0.372858434915543, 0.372598320245743, 0.372338056564331, 0.372077971696854, 0.371817857027054, 0.371557801961899, 0.371297776699066, 0.371037751436234, 0.370777755975723, 0.370517790317535, 0.370257884263992, 0.369998008012772, 0.369738131761551, 0.369478344917297, 0.369218528270721, 0.36895877122879, 0.368699073791504, 0.368439316749573, 0.368179619312286, 0.36792004108429, 0.367660403251648, 0.367400854825974, 0.367141306400299, 0.366881757974625, 0.36662232875824, 0.36636283993721, 0.366103440523148, 0.365844070911407, 0.365584671497345, 0.36532536149025, 0.365066051483154, 0.364806771278381, 0.364547550678253, 0.364288330078125, 0.364029169082642, 0.363770037889481, 0.363510936498642, 0.363251835107803, 0.362992823123932, 0.362733781337738, 0.362474769353867, 0.362215787172318, 0.36195695400238, 0.361698001623154, 0.361439138650894, 0.361180335283279, 0.36092147231102, 0.36066272854805, 0.360404014587402, 0.360145330429077, 0.35988661646843, 0.359627962112427, 0.359369397163391, 0.359110802412033, 0.358852297067642, 0.358593732118607, 0.358335256576538, 0.358076810836792, 0.357818365097046, 0.357560008764267, 0.357301622629166, 0.357043266296387, 0.356784969568253, 0.356526702642441, 0.356268465518951, 0.356010258197784, 0.355752050876617, 0.355493932962418, 0.355235815048218, 0.354977667331696, 0.354719698429108, 0.354461640119553, 0.354203671216965, 0.353945702314377, 0.353687763214111, 0.353429853916168, 0.35317200422287, 0.352914243936539, 0.352656364440918, 0.352398574352264, 0.352140843868256, 0.351883113384247, 0.351625472307205, 0.351367771625519, 0.3511101603508, 0.350852578878403, 0.350594997406006, 0.350337505340576, 0.350079983472824, 0.349822521209717, 0.349565118551254, 0.349307686090469, 0.349050343036652, 0.348792940378189, 0.348535656929016, 0.348278403282166, 0.348021149635315, 0.347763925790787, 0.347506761550903, 0.347249627113342, 0.346992462873459, 0.346735388040543, 0.346478313207626, 0.346221327781677, 0.345964312553406, 0.345707386732101, 0.34545037150383, 0.345193445682526, 0.344936639070511, 0.344679772853851, 0.344422936439514, 0.344166219234467, 0.343909442424774, 0.343652784824371, 0.343396067619324, 0.343139410018921, 0.342882752418518, 0.342626184225082, 0.342369616031647, 0.342113077640533, 0.34185653924942, 0.341600090265274, 0.34134367108345, 0.341087251901627, 0.340830892324448, 0.340574532747269, 0.340318232774734, 0.3400619328022, 0.339805692434311, 0.339549452066422, 0.339293241500854, 0.339037090539932, 0.33878093957901, 0.338524878025055, 0.338268786668777, 0.338012725114822, 0.337756782770157, 0.337500810623169, 0.337244868278503, 0.336988925933838, 0.33673307299614, 0.336477220058441, 0.336221396923065, 0.335965633392334, 0.335709869861603, 0.335454136133194, 0.33519846200943, 0.334942758083344, 0.334687083959579, 0.334431529045105, 0.334175944328308, 0.333920449018478, 0.333664894104004, 0.333409398794174, 0.333153992891312, 0.332898586988449, 0.332643181085587, 0.332387834787369, 0.332132488489151, 0.331877261400223, 0.331621944904327, 0.331366777420044, 0.331111520528793, 0.33085635304451, 0.330601274967194, 0.330346137285233, 0.330091089010239, 0.329836010932922, 0.329581022262573, 0.329326033592224, 0.32907110452652, 0.328816175460815, 0.328561305999756, 0.328306436538696, 0.328051626682281, 0.327796846628189, 0.327542066574097, 0.327287375926971, 0.327032655477524, 0.326778024435043, 0.326523303985596, 0.326268702745438, 0.326014190912247, 0.325759619474411, 0.325505077838898, 0.325250625610352, 0.324996143579483, 0.324741721153259, 0.324487328529358, 0.324232995510101, 0.323978662490845, 0.323724329471588, 0.323470115661621, 0.323215842247009, 0.322961628437042, 0.32270747423172, 0.322453379631042, 0.322199285030365, 0.321945190429688, 0.32169109582901, 0.321437060832977, 0.321183055639267, 0.320929139852524, 0.320675224065781, 0.320421308279037, 0.320167481899261, 0.319913625717163, 0.319659858942032, 0.319406062364578, 0.319152295589447, 0.318898648023605, 0.318644970655441, 0.318391352891922, 0.31813770532608, 0.317884087562561, 0.317630559206009, 0.317377030849457, 0.317123621702194, 0.31687006354332, 0.316616654396057, 0.316363304853439, 0.316109895706177, 0.315856575965881, 0.315603286027908, 0.315349996089935, 0.315096765756607, 0.314843535423279, 0.314590394496918, 0.314337283372879, 0.314084142446518, 0.313831061124802, 0.313577950000763, 0.313324898481369, 0.313071995973587, 0.312819004058838, 0.312566101551056, 0.312313199043274, 0.31206026673317, 0.311807513237, 0.311554670333862, 0.31130188703537, 0.311049163341522, 0.310796439647675, 0.310543775558472, 0.310291111469269, 0.310038506984711, 0.309785902500153, 0.309533298015594, 0.309280812740326, 0.309028297662735, 0.308775901794434, 0.308523446321487, 0.308271050453186, 0.308018654584885, 0.307766288518906, 0.307513982057571, 0.307261675596237, 0.307009488344193, 0.306757271289825, 0.306505024433136, 0.306252926588058, 0.306000798940659, 0.305748671293259, 0.305496692657471, 0.305244594812393, 0.304992586374283, 0.30474066734314, 0.304488688707352, 0.304236799478531, 0.303984880447388, 0.303733050823212, 0.30348128080368, 0.303229540586472, 0.30297777056694, 0.302726030349731, 0.302474319934845, 0.302222698926926, 0.301971077919006, 0.301719456911087, 0.301467895507812, 0.30121636390686, 0.300964862108231, 0.300713390111923, 0.300461918115616, 0.300210565328598, 0.299959182739258, 0.299707859754562, 0.299456536769867, 0.299205243587494, 0.298954010009766, 0.298702776432037, 0.298451572656631, 0.29820042848587, 0.297949284315109, 0.297698229551315, 0.297447144985199, 0.297196120023727, 0.296945095062256, 0.296694099903107, 0.296443194150925, 0.29619225859642, 0.295941412448883, 0.295690506696701, 0.295439720153809, 0.295188933610916, 0.294938176870346, 0.294687449932098, 0.294436722993851, 0.29418608546257, 0.293935477733612, 0.293684840202332, 0.293434262275696, 0.293183743953705, 0.292933225631714, 0.292682737112045, 0.292432308197021, 0.292181879281998, 0.291931509971619, 0.29168114066124, 0.291430860757828, 0.291180551052094, 0.290930271148682, 0.290680080652237, 0.290429830551147, 0.290179699659348, 0.289929568767548, 0.289679437875748, 0.289429396390915, 0.289179354906082, 0.288929343223572, 0.288679361343384, 0.288429379463196, 0.288179486989975, 0.287929594516754, 0.287679702043533, 0.287429928779602, 0.287180125713348, 0.28693038225174, 0.286680638790131, 0.286430925130844, 0.28618124127388, 0.285931646823883, 0.285682022571564, 0.285432487726212, 0.285182923078537, 0.284933418035507, 0.284683912992477, 0.284434497356415, 0.28418505191803, 0.28393566608429, 0.283686339855194, 0.283436983823776, 0.283187687397003, 0.282938420772552, 0.282689183950424, 0.282439976930618, 0.282190799713135, 0.281941652297974, 0.281692564487457, 0.281443446874619, 0.281194448471069, 0.280945420265198, 0.280696392059326, 0.280447483062744, 0.28019854426384, 0.27994966506958, 0.27970078587532, 0.279451936483383, 0.279203176498413, 0.278954386711121, 0.278705686330795, 0.278456956148148, 0.278208255767822, 0.277959614992142, 0.277711004018784, 0.27746245265007, 0.277213871479034, 0.276965320110321, 0.276716887950897, 0.276468396186829, 0.276219993829727, 0.275971591472626, 0.275723218917847, 0.275474935770035, 0.275226593017578, 0.274978309869766, 0.274730086326599, 0.27448183298111, 0.27423369884491, 0.273985534906387, 0.273737400770187, 0.273489356040955, 0.273241281509399, 0.272993266582489, 0.272745311260223, 0.272497296333313, 0.272249341011047, 0.272001504898071, 0.271753638982773, 0.271505773067474, 0.271257966756821, 0.271010190248489, 0.270762473344803, 0.270514786243439, 0.270267099142075, 0.27001941204071, 0.269771844148636, 0.269524186849594, 0.269276678562164, 0.269032835960388, 0.268792539834976, 0.268552422523499, 0.268312364816666, 0.268072456121445, 0.267832577228546, 0.26759284734726, 0.267353266477585, 0.267113715410233, 0.266874253749847, 0.266634970903397, 0.266395747661591, 0.266156643629074, 0.26591756939888, 0.265678644180298, 0.265439808368683, 0.265201061964035, 0.264962494373322, 0.26472395658493, 0.264485508203506, 0.264247208833694, 0.264009028673172, 0.263770908117294, 0.263532876968384, 0.263294965028763, 0.263057172298431, 0.262819409370422, 0.262581795454025, 0.26234433054924, 0.262106895446777, 0.261869609355927, 0.26163238286972, 0.261395305395126, 0.261158257722855, 0.260921359062195, 0.260684579610825, 0.260447859764099, 0.260211259126663, 0.259974718093872, 0.259738385677338, 0.259502083063126, 0.259265899658203, 0.259029746055603, 0.25879380106926, 0.258557885885239, 0.25832211971283, 0.258086442947388, 0.257850825786591, 0.257615357637405, 0.257379949092865, 0.257144719362259, 0.256909519433975, 0.256674498319626, 0.256439477205276, 0.256204605102539, 0.255969822406769, 0.255735099315643, 0.255500555038452, 0.255266129970551, 0.255031734704971, 0.254797428846359, 0.254563301801682, 0.254329204559326, 0.25409522652626, 0.253861337900162, 0.253627568483353, 0.253393888473511, 0.253160357475281, 0.252926886081696, 0.2526935338974, 0.252460241317749, 0.25222709774971, 0.251994073390961, 0.251761138439178, 0.251528203487396, 0.251295417547226, 0.25106281042099, 0.250830292701721, 0.250597804784775, 0.250365495681763, 0.250133186578751, 0.249901115894318, 0.249669000506401, 0.24943707883358, 0.249205201864243, 0.248973473906517, 0.24874185025692, 0.248510301113129, 0.248278811573982, 0.248047530651093, 0.247816264629364, 0.247585147619247, 0.247354090213776, 0.247123137116432, 0.246892333030701, 0.246661558747292, 0.246430963277817, 0.246200412511826, 0.245969980955124, 0.245739683508873, 0.245509400963783, 0.24527932703495, 0.245049312710762, 0.244819387793541, 0.244589537382126, 0.244359835982323, 0.244130194187164, 0.24390073120594, 0.2436713129282, 0.243442013859749, 0.243212789297104, 0.242983654141426, 0.242754682898521, 0.242525726556778, 0.242296978831291, 0.242068201303482, 0.241839587688446, 0.241611123085022, 0.241382658481598, 0.241154447197914, 0.240926161408424, 0.240698024630547, 0.240470066666603, 0.240242153406143, 0.240014404058456, 0.239786699414253, 0.239559069275856, 0.239331603050232, 0.23910416662693, 0.238876909017563, 0.238649681210518, 0.238422602415085, 0.23819562792778, 0.237968698143959, 0.237741947174072, 0.237515240907669, 0.237288668751717, 0.23706217110157, 0.236835837364197, 0.236609518527985, 0.236383393406868, 0.236157238483429, 0.23593133687973, 0.23570542037487, 0.235479608178139, 0.235253989696503, 0.235028401017189, 0.234802931547165, 0.234577551484108, 0.234352260828018, 0.234127104282379, 0.233901992440224, 0.233677133917809, 0.233452185988426, 0.233227387070656, 0.23300276696682, 0.232778146862984, 0.232553750276566, 0.232329338788986, 0.232105046510696, 0.231880962848663, 0.231656864285469, 0.231432944536209, 0.231209084391594, 0.230985373258591, 0.23076169192791, 0.230538189411163, 0.2303147315979, 0.230091363191605, 0.229868113994598, 0.229644924402237, 0.229421958327293, 0.229198977351189, 0.228976145386696, 0.228753387928009, 0.228530779480934, 0.228308200836182, 0.228085786104202, 0.227863430976868, 0.227641195058823, 0.22741910815239, 0.227197051048279, 0.226975098252296, 0.226753279566765, 0.226531565189362, 0.226309910416603, 0.226088359951973, 0.22586689889431, 0.225645616650581, 0.225424349308014, 0.225203275680542, 0.22498220205307, 0.224761292338371, 0.22454047203064, 0.224319726228714, 0.224099203944206, 0.223878636956215, 0.223658248782158, 0.223437890410423, 0.223217725753784, 0.22299762070179, 0.222777619957924, 0.222557708621025, 0.222337931394577, 0.222118198871613, 0.221898570656776, 0.221679076552391, 0.221459671854973, 0.221240356564522, 0.22102116048336, 0.220802038908005, 0.220583021640778, 0.22036412358284, 0.22014531493187, 0.219926685094833, 0.219708055257797, 0.219489544630051, 0.219271138310432, 0.219052836298943, 0.218834683299065, 0.218616560101509, 0.218398630619049, 0.21818071603775, 0.217962950468063, 0.217745214700699, 0.217527702450752, 0.217310190200806, 0.217092841863632, 0.216875582933426, 0.216658368706703, 0.216441318392754, 0.216224268078804, 0.216007485985756, 0.215790659189224, 0.215574041008949, 0.215357422828674, 0.215140998363495, 0.214924603700638, 0.214708313345909, 0.214492201805115, 0.214276060461998, 0.214060053229332, 0.213844239711761, 0.213628470897675, 0.213412836194038, 0.213197261095047, 0.212981775403023, 0.212766483426094, 0.212551176548004, 0.212336018681526, 0.212120950222015, 0.211905986070633, 0.211691170930862, 0.211476385593414, 0.211261764168739, 0.211047187447548, 0.210832804441452, 0.210618406534195, 0.210404217243195, 0.210190027952194, 0.209976002573967, 0.209762051701546, 0.209548234939575, 0.209334477782249, 0.209120824933052, 0.208907335996628, 0.208693832159042, 0.208480536937714, 0.208267271518707, 0.208054140210152, 0.207841113209724, 0.207628175616264, 0.207415357232094, 0.20720262825489, 0.206989988684654, 0.206777453422546, 0.206565022468567, 0.206352725625038, 0.206140488386154, 0.20592837035656, 0.205716326832771, 0.205504402518272, 0.205292597413063, 0.205080911517143, 0.204869359731674, 0.204657778143883, 0.20444643497467, 0.204235047101974, 0.204023912549019, 0.203812777996063, 0.203601747751236, 0.203390836715698, 0.203180015087128, 0.202969342470169, 0.202758744359016, 0.202548235654831, 0.202337801456451, 0.2021274715662, 0.201917290687561, 0.201707199215889, 0.20149727165699, 0.20128732919693, 0.201077535748482, 0.20086781680584, 0.200658231973648, 0.200448781251907, 0.200239345431328, 0.200030043721199, 0.199820876121521, 0.199611768126488, 0.199402809143066, 0.199193879961967, 0.198985084891319, 0.198776453733444, 0.19856783747673, 0.198359414935112, 0.198150992393494, 0.19794274866581, 0.19773456454277, 0.197526499629021, 0.197318524122238, 0.197110682725906, 0.196902871131897, 0.196695253252983, 0.196487635374069, 0.196280181407928, 0.196072816848755, 0.195865482091904, 0.195658385753632, 0.195451289415359, 0.195244327187538, 0.195037484169006, 0.194830670952797, 0.194624081254005, 0.194417491555214, 0.19421099126339, 0.194004684686661, 0.193798407912254, 0.193592265248299, 0.193386167287827, 0.19318026304245, 0.192974433302879, 0.192768707871437, 0.192563071846962, 0.192357450723648, 0.192152082920074, 0.191946685314178, 0.191741436719894, 0.191536337137222, 0.191331207752228, 0.191126316785812, 0.190921515226364, 0.190716773271561, 0.190512090921402, 0.190307602286339, 0.190103143453598, 0.189898863434792, 0.189694583415985, 0.189490467309952, 0.189286455512047, 0.189082488417625, 0.188878670334816, 0.188674941658974, 0.18847131729126, 0.188267767429352, 0.188064366579056, 0.187861040234566, 0.187657818198204, 0.187454670667648, 0.187251687049866, 0.187048748135567, 0.186845913529396, 0.186643227934837, 0.186440601944923, 0.186238095164299, 0.186035662889481, 0.185833394527435, 0.185631141066551, 0.185429081320763, 0.185227036476135, 0.185025185346603, 0.184823378920555, 0.184621691703796, 0.184420049190521, 0.18421858549118, 0.18401712179184, 0.183815807104111, 0.183614671230316, 0.183413535356522, 0.183212578296661, 0.183011651039124, 0.182810857892036, 0.182610213756561, 0.182409569621086, 0.182209104299545, 0.182008698582649, 0.181808397173882, 0.181608244776726, 0.181408181786537, 0.181208193302155, 0.181008279323578, 0.180808484554291, 0.180608838796616, 0.18040931224823, 0.180209800601006, 0.180010423064232, 0.179811164736748, 0.17961198091507, 0.179412871599197, 0.17921394109726, 0.17901499569416, 0.178816258907318, 0.178617611527443, 0.178419023752213, 0.17822054028511, 0.178022235631943, 0.177823975682259, 0.177625775337219, 0.177427694201469, 0.177229821681976, 0.177031919360161, 0.176834151148796, 0.176636457443237, 0.176438882946968, 0.176241546869278, 0.176044121384621, 0.175846859812737, 0.175649702548981, 0.17545260488987, 0.175255715847015, 0.175058841705322, 0.17486210167408, 0.174665436148643, 0.17446893453598, 0.174272492527962, 0.17407613992691, 0.173879876732826, 0.173683747649193, 0.173487693071365, 0.173291802406311, 0.173095941543579, 0.172900259494781, 0.172704592347145, 0.172508999705315, 0.17231360077858, 0.17211826145649, 0.171923041343689, 0.171727895736694, 0.17153288424015, 0.171337932348251, 0.171143189072609, 0.170948430895805, 0.17075377702713, 0.170559242367744, 0.170364901423454, 0.170170530676842, 0.169976323843002, 0.169782191514969, 0.169588178396225, 0.169394314289093, 0.169200494885445, 0.169006764888763, 0.168813094496727, 0.168619632720947, 0.168426215648651, 0.168232902884483, 0.168039709329605, 0.16784656047821, 0.16765359044075, 0.167460665106773, 0.167267918586731, 0.167075157165527, 0.16688260436058, 0.166690081357956, 0.166497632861137, 0.166305392980576, 0.166113242506981, 0.16592113673687, 0.165729105472565, 0.165537178516388, 0.16534548997879, 0.165153801441193, 0.164962142705917, 0.164770618081093, 0.16457924246788, 0.16438801586628, 0.164196833968163, 0.16400571167469, 0.163814693689346, 0.163623794913292, 0.163433119654655, 0.163242429494858, 0.163051798939705, 0.162861317396164, 0.162670955061913, 0.162480726838112, 0.162290543317795, 0.162100434303284, 0.161910489201546, 0.161720588803291, 0.161534458398819, 0.161350175738335, 0.161166042089462, 0.160982087254524, 0.160798132419586, 0.160614311695099, 0.160430714488029, 0.160247176885605, 0.160063683986664, 0.159880414605141, 0.159697264432907, 0.159514233469963, 0.159331321716309, 0.159148454666138, 0.158965736627579, 0.158783197402954, 0.158600762486458, 0.158418402075768, 0.158236160874367, 0.158054038882256, 0.157872140407562, 0.157690361142159, 0.15750852227211, 0.157326906919479, 0.157145515084267, 0.156964123249054, 0.15678283572197, 0.156601756811142, 0.156420737504959, 0.156239897012711, 0.156059145927429, 0.155878499150276, 0.15569794178009, 0.155517593026161, 0.155337288975716, 0.155157119035721, 0.154977157711983, 0.154797241091728, 0.15461739897728, 0.154437735676765, 0.15425817668438, 0.15407882630825, 0.153899535536766, 0.153720319271088, 0.153541207313538, 0.153362274169922, 0.153183504939079, 0.153004735708237, 0.152826219797134, 0.152647703886032, 0.152469322085381, 0.15229120850563, 0.152113124728203, 0.151935085654259, 0.151757270097733, 0.15157949924469, 0.151401996612549, 0.151224449276924, 0.151047021150589, 0.150869801640511, 0.150692701339722, 0.150515660643578, 0.150338813662529, 0.150162056088448, 0.149985402822495, 0.149808883666992, 0.149632483720779, 0.149456143379211, 0.149280056357384, 0.149103999137878, 0.148928046226501, 0.14875216782093, 0.148576661944389, 0.148401021957397, 0.148225575685501, 0.148050293326378, 0.147875070571899, 0.147700086236, 0.147525131702423, 0.147350266575813, 0.147175475955009, 0.147000938653946, 0.146826520562172, 0.146652176976204, 0.146477922797203, 0.146303772926331, 0.146129831671715, 0.145955950021744, 0.145782172679901, 0.145608574151993, 0.145435124635696, 0.145261704921722, 0.145088493824005, 0.144915342330933, 0.144742369651794, 0.144569456577301, 0.144396677613258, 0.144223988056183, 0.144051536917686, 0.14387908577919, 0.143706768751144, 0.143534630537033, 0.143362551927567, 0.143190652132034, 0.143018901348114, 0.142847120761871, 0.142675578594208, 0.14250423014164, 0.142332851886749, 0.14216160774231, 0.141990557312965, 0.141819551587105, 0.141648784279823, 0.141478076577187, 0.141307458281517, 0.141136959195137, 0.140966668725014, 0.140796408057213, 0.140626236796379, 0.140456303954124, 0.140286475419998, 0.140116661787033, 0.139947071671486, 0.139777541160583, 0.139608144760132, 0.139438942074776, 0.13926973938942, 0.139100685715675, 0.138931840658188, 0.13876311480999, 0.138594388961792, 0.13842585682869, 0.138257369399071, 0.138089165091515, 0.137921005487442, 0.137752890586853, 0.137584939599037, 0.137417152523994, 0.137249484658241, 0.137081876397133, 0.136914446949959, 0.13674707710743, 0.136579886078835, 0.136412903666496, 0.136245906352997, 0.136078983545303, 0.135912284255028, 0.135745719075203, 0.135579198598862, 0.135412856936455, 0.135246574878693, 0.135080471634865, 0.134914487600327, 0.134748607873917, 0.134582817554474, 0.134417250752449, 0.134251683950424, 0.13408625125885, 0.133921042084694, 0.133755952119827, 0.133590877056122, 0.133425951004028, 0.133261114358902, 0.13309645652771, 0.132932007312775, 0.132767528295517, 0.13260318338871, 0.132439032196999, 0.13227504491806, 0.132111012935638, 0.13194727897644, 0.131783470511436, 0.131619900465012, 0.13145649433136, 0.131293132901192, 0.131129920482635, 0.130966812372208, 0.130803853273392, 0.130640968680382, 0.130478322505951, 0.130315646529198, 0.130153149366379, 0.129990816116333, 0.129828527569771, 0.129666462540627, 0.129504382610321, 0.129342526197433, 0.129180774092674, 0.129019156098366, 0.128857597708702, 0.128696233034134, 0.128534987568855, 0.128373742103577, 0.128212675452232, 0.12805187702179, 0.127891033887863, 0.127730295062065, 0.127569779753685, 0.127409309148788, 0.127249136567116, 0.127088874578476, 0.12692879140377, 0.126768782734871, 0.126608997583389, 0.126449301838875, 0.126289740204811, 0.126130253076553, 0.125970855355263, 0.125811651349068, 0.125652611255646, 0.125493600964546, 0.125334709882736, 0.125175997614861, 0.125017389655113, 0.124858908355236, 0.124700479209423, 0.124542281031609, 0.124384149909019, 0.124226108193398, 0.124068178236485, 0.123910434544086, 0.12375283241272, 0.123595282435417, 0.123437888920307, 0.12328052520752, 0.12312339246273, 0.12296637147665, 0.122809432446957, 0.122652567923069, 0.12249593436718, 0.122339427471161, 0.122182920575142, 0.122026614844799, 0.121870405972004, 0.121714323759079, 0.121558412909508, 0.12140254676342, 0.12124677747488, 0.121091268956661, 0.120935767889023, 0.120780371129513, 0.12062519043684, 0.120470069348812, 0.120315097272396, 0.120160207152367, 0.120005443692207, 0.119850784540176, 0.119696348905563, 0.119541935622692, 0.11938763409853, 0.119233570992947, 0.119079567492008, 0.118925631046295, 0.118771865963936, 0.118618160486221, 0.118464656174183, 0.118311285972595, 0.118157930672169, 0.118004694581032, 0.117851704359055, 0.117698818445206, 0.11754596978426, 0.117393292486668, 0.117240652441978, 0.117088206112385, 0.116935983300209, 0.11678372323513, 0.116631612181664, 0.116479612886906, 0.116327829658985, 0.116176106035709, 0.116024516522884, 0.115873001515865, 0.115721650421619, 0.115570448338985, 0.115419313311577, 0.115268267691135, 0.115117475390434, 0.114966668188572, 0.114816032350063, 0.114665515720844, 0.114515110850334, 0.114364884793758, 0.11421474814415, 0.114064678549767, 0.113914720714092, 0.113765031099319, 0.113615334033966, 0.113465756177902, 0.113316364586353, 0.113167025148869, 0.113017864525318, 0.11286886036396, 0.112719871103764, 0.112570971250534, 0.112422399222851, 0.112273775041103, 0.112125255167484, 0.111976951360703, 0.111828774213791, 0.111680664122105, 0.111532747745514, 0.111384846270084, 0.111237056553364, 0.111089549958706, 0.110942006111145, 0.110794611275196, 0.11064737290144, 0.110500283539295, 0.110353231430054, 0.110206380486488, 0.11005961149931, 0.109912991523743, 0.109766483306885, 0.109620064496994, 0.109473764896393, 0.109327673912048, 0.109181582927704, 0.109035611152649, 0.108889847993851, 0.108744166791439, 0.108598716557026, 0.108453251421452, 0.108307868242264, 0.108162693679333, 0.108017638325691, 0.107872687280178, 0.107727907598019, 0.107583172619343, 0.107438519597054, 0.107294112443924, 0.107149787247181, 0.107005521655083, 0.106861472129822, 0.106717474758625, 0.106573604047298, 0.106429807841778, 0.106286227703094, 0.10614275932312, 0.105999417603016, 0.105856120586395, 0.105712987482548, 0.105569995939732, 0.105427116155624, 0.105284333229065, 0.10514160245657, 0.104999117553234, 0.104856707155704, 0.104714460670948, 0.104572288691998, 0.104430191218853, 0.104288190603256, 0.104146525263786, 0.104004807770252, 0.103863328695297, 0.103721834719181, 0.103580489754677, 0.103439331054688, 0.103298224508762, 0.103157237172127, 0.103016421198845, 0.102875731885433, 0.102735139429569, 0.102594681084156, 0.102454282343388, 0.102314092218876, 0.102174028754234, 0.102034017443657, 0.101894065737724, 0.101754404604435, 0.101614743471146, 0.101475201547146, 0.101335845887661, 0.101196594536304, 0.101057447493076, 0.100918434560299, 0.100779511034489, 0.100640714168549, 0.100502111017704, 0.100363552570343, 0.100225105881691, 0.100086838006973, 0.0999486222863197, 0.0998106226325035, 0.0996726974844933, 0.0995348393917084, 0.0993971303105354, 0.0992596596479416, 0.0991221517324448, 0.0989848002791405, 0.0988476276397705, 0.0987105593085289, 0.0985735654830933, 0.0984367728233337, 0.098300002515316, 0.0981634110212326, 0.0980269685387611, 0.0978905335068703, 0.0977542921900749, 0.0976182147860527, 0.0974822118878365, 0.0973463281989098, 0.0972106084227562, 0.0970749631524086, 0.0969394519925117, 0.0968040749430656, 0.0966687873005867, 0.0965335890650749, 0.0963986814022064, 0.0962637215852737, 0.0961288958787918, 0.0959942638874054, 0.0958596765995026, 0.0957252681255341, 0.0955909863114357, 0.0954567939043045, 0.0953226760029793, 0.0951888114213943, 0.0950549617409706, 0.094921238720417, 0.0947876870632172, 0.0946541950106621, 0.0945208892226219, 0.0943877249956131, 0.0942545980215073, 0.0941215679049492, 0.0939888209104538, 0.0938560366630554, 0.093723438680172, 0.0935909524559975, 0.0934586077928543, 0.0933263003826141, 0.0931942239403725, 0.0930621847510338, 0.0929303541779518, 0.0927985981106758, 0.0926669090986252, 0.0925353392958641, 0.0924039781093597, 0.0922727659344673, 0.0921415686607361, 0.092010535299778, 0.0918795764446259, 0.0917487218976021, 0.0916181802749634, 0.0914875864982605, 0.0913571268320084, 0.091226801276207, 0.0910966470837593, 0.0909666493535042, 0.0908366739749908, 0.0907067656517029, 0.0905770882964134, 0.0904475301504135, 0.0903180837631226, 0.0901887267827988, 0.0900595188140869, 0.0899303928017616, 0.0898013636469841, 0.0896725654602051, 0.0895437970757484, 0.0894151777029037, 0.0892867371439934, 0.0891583263874054, 0.0890300944447517, 0.0889019668102264, 0.0887739136815071, 0.0886460021138191, 0.0885182395577431, 0.0883906111121178, 0.0882631167769432, 0.0881357118487358, 0.088008351624012, 0.0878811627626419, 0.0877542197704315, 0.0876272842288017, 0.0875004678964615, 0.0873737558722496, 0.0872472152113914, 0.0871208310127258, 0.0869944766163826, 0.0868682563304901, 0.0867422074079514, 0.0866162702441216, 0.0864903926849365, 0.0863646939396858, 0.0862390547990799, 0.0861136317253113, 0.0859883055090904, 0.0858630239963531, 0.0857379138469696, 0.0856129825115204, 0.0854880809783936, 0.0853633061051369, 0.0852386951446533, 0.0851142406463623, 0.0849898159503937, 0.0848655849695206, 0.0847413912415504, 0.0846173465251923, 0.0844950824975967, 0.0843741372227669, 0.0842532515525818, 0.0841324850916862, 0.0840118601918221, 0.0838912948966026, 0.0837709754705429, 0.0836505889892578, 0.0835303440690041, 0.0834103524684906, 0.0832903161644936, 0.0831704661250114, 0.0830506607890129, 0.0829309597611427, 0.0828114077448845, 0.08269202709198, 0.0825726613402367, 0.0824533700942993, 0.0823343470692635, 0.0822152569890022, 0.0820963457226753, 0.0819776132702827, 0.0818588584661484, 0.0817402973771095, 0.0816218331456184, 0.0815033912658691, 0.0813851654529572, 0.0812670215964317, 0.0811489969491959, 0.0810310021042824, 0.0809132158756256, 0.0807955116033554, 0.0806778073310852, 0.0805603861808777, 0.0804429426789284, 0.0803256332874298, 0.0802085176110268, 0.0800914168357849, 0.0799744203686714, 0.0798576027154922, 0.0797408521175385, 0.0796241909265518, 0.0795076638460159, 0.0793912336230278, 0.0792748555541039, 0.0791587308049202, 0.0790426209568977, 0.0789265781641006, 0.0788107365369797, 0.0786949247121811, 0.0785792320966721, 0.0784637480974197, 0.0783482640981674, 0.0782328844070435, 0.0781176686286926, 0.078002505004406, 0.0778874903917313, 0.0777725651860237, 0.0776577889919281, 0.0775430500507355, 0.0774285271763802, 0.0773140117526054, 0.0771995633840561, 0.077085368335247, 0.0769711956381798, 0.0768571496009827, 0.0767432004213333, 0.0766293108463287, 0.0765156149864197, 0.076402023434639, 0.0762885138392448, 0.0761751160025597, 0.0760618448257446, 0.0759486332535744, 0.0758354887366295, 0.0757225900888443, 0.0756097361445427, 0.0754969641566277, 0.0753843113780022, 0.0752717182040215, 0.0751592740416527, 0.0750470012426376, 0.0749348178505898, 0.0748226940631866, 0.0747106373310089, 0.0745987743139267, 0.0744870081543922, 0.074375331401825, 0.0742637664079666, 0.0741522386670113, 0.0740409195423126, 0.0739296823740005, 0.0738186240196228, 0.0737075582146645, 0.0735966488718987, 0.0734857991337776, 0.0733750686049461, 0.0732645094394684, 0.0731540024280548, 0.0730436593294144, 0.0729333385825157, 0.0728231072425842, 0.072713166475296, 0.0726031363010406, 0.0724934116005898, 0.0723835825920105, 0.0722739174962044, 0.0721645131707191, 0.0720550119876862, 0.0719457566738129, 0.0718365535140038, 0.0717274472117424, 0.0716184824705124, 0.0715096667408943, 0.071400873363018, 0.0712921842932701, 0.0711836591362953, 0.0710752308368683, 0.0709668546915054, 0.0708587169647217, 0.0707505494356155, 0.0706425607204437, 0.0705346837639809, 0.070426844060421, 0.0703191757202148, 0.0702116042375565, 0.070104144513607, 0.0699967443943024, 0.0698895528912544, 0.0697823911905289, 0.0696753188967705, 0.0695684477686882, 0.0694616064429283, 0.0693548619747162, 0.069248341023922, 0.0691417753696442, 0.0690354034304619, 0.0689291581511497, 0.0688229352235794, 0.0687168687582016, 0.0686109438538551, 0.0685050785541534, 0.0683993250131607, 0.0682937353849411, 0.0681882202625275, 0.0680827423930168, 0.0679774954915047, 0.0678722485899925, 0.0677671805024147, 0.067662201821804, 0.0675573125481606, 0.0674525424838066, 0.0673478841781616, 0.0672433450818062, 0.0671388655900955, 0.0670345947146416, 0.06693035364151, 0.0668261721730232, 0.0667222291231155, 0.0666182786226273, 0.0665144249796867, 0.0664108321070671, 0.0663072094321251, 0.0662037655711174, 0.0661004111170769, 0.0659971088171005, 0.0658939629793167, 0.0657909587025642, 0.0656880140304565, 0.0655851662158966, 0.0654825419187546, 0.065379835665226, 0.0652773082256317, 0.0651750117540359, 0.0650726929306984, 0.0649705156683922, 0.0648684576153755, 0.0647664591670036, 0.0646646097302437, 0.0645628720521927, 0.0644612610340118, 0.0643596798181534, 0.0642582625150681, 0.0641570091247559, 0.0640557482838631, 0.0639547184109688, 0.0638536959886551, 0.0637527629733086, 0.0636520609259605, 0.0635513290762901, 0.0634508058428764, 0.0633503720164299, 0.0632500275969505, 0.0631497725844383, 0.0630496591329575, 0.0629496425390244, 0.0628497079014778, 0.062749981880188, 0.0626501962542534, 0.0625506192445755, 0.0624512173235416, 0.0623517818748951, 0.0622525326907635, 0.0621534287929535, 0.0620543211698532, 0.0619554221630096, 0.0618565790355206, 0.0617578588426113, 0.0616591647267342, 0.0615607053041458, 0.0614623092114925, 0.0613640025258064, 0.0612658970057964, 0.0611677654087543, 0.0610698089003563, 0.0609719716012478, 0.0608741641044617, 0.0607765652239323, 0.0606790222227573, 0.0605816580355167, 0.0604843199253082, 0.0603870749473572, 0.0602899752557278, 0.0601929351687431, 0.06009616330266, 0.0599993281066418, 0.0599026419222355, 0.0598060972988605, 0.0597095638513565, 0.0596133507788181, 0.0595170482993126, 0.0594208613038063, 0.0593248568475246, 0.0592289678752422, 0.0591331981122494, 0.059037484228611, 0.0589418299496174, 0.0588463246822357, 0.0587509050965309, 0.0586557574570179, 0.0585605762898922, 0.058465514332056, 0.0583705678582191, 0.0582757145166397, 0.0581810623407364, 0.0580864101648331, 0.0579918809235096, 0.0578974969685078, 0.057803139090538, 0.0577089935541153, 0.0576149374246597, 0.057520966976881, 0.0574270524084568, 0.0573333203792572, 0.0572396963834763, 0.0571461133658886, 0.0570527613162994, 0.0569593533873558, 0.0568661205470562, 0.0567730627954006, 0.0566800683736801, 0.0565871596336365, 0.0564943999052048, 0.0564016662538052, 0.0563091114163399, 0.0562166757881641, 0.0561243295669556, 0.0560320392251015, 0.0559399873018265, 0.0558479093015194, 0.055755939334631, 0.0556641854345798, 0.0555724836885929, 0.0554808713495731, 0.0553893819451332, 0.0552979521453381, 0.055206723511219, 0.0551155619323254, 0.0550245083868504, 0.0549335181713104, 0.0548427030444145, 0.0547520071268082, 0.0546613149344921, 0.0545708872377872, 0.0544803999364376, 0.0543900579214096, 0.0542999543249607, 0.054209791123867, 0.0541198365390301, 0.0540299937129021, 0.053940188139677, 0.0538505502045155, 0.0537610091269016, 0.0536716096103191, 0.0535822175443172, 0.0534930825233459, 0.0534039251506329, 0.0533148534595966, 0.0532260462641716, 0.0531371794641018, 0.0530485548079014, 0.0529599823057652, 0.0528715029358864, 0.0527831427752972, 0.0526948980987072, 0.0526067689061165, 0.0525186993181705, 0.0524307787418365, 0.0523429773747921, 0.0522551983594894, 0.0521676912903786, 0.0520801544189453, 0.0519927367568016, 0.0519055277109146, 0.051818311214447, 0.0517312772572041, 0.0516442991793156, 0.0515574142336845, 0.0514706745743752, 0.0513840802013874, 0.0512975789606571, 0.0512111335992813, 0.0511248931288719, 0.0510386303067207, 0.0509525053203106, 0.0508665926754475, 0.0507806800305843, 0.0506949126720428, 0.0506092347204685, 0.050523679703474, 0.0504382364451885, 0.0503529459238052, 0.0502677336335182, 0.0501825325191021, 0.0500975623726845, 0.0500126481056213, 0.0499278865754604, 0.0498432144522667, 0.0497585982084274, 0.0496740713715553, 0.0495897829532623, 0.049505490809679, 0.0494213178753853, 0.0493373274803162, 0.0492534190416336, 0.0491695404052734, 0.0490858443081379, 0.0490022301673889, 0.0489186756312847, 0.048835389316082, 0.0487520471215248, 0.0486689060926437, 0.0485858246684074, 0.0485028587281704, 0.0484199896454811, 0.0483372583985329, 0.0482545979321003, 0.0481721311807632, 0.0480896420776844, 0.048007357865572, 0.0479251071810722, 0.0478430315852165, 0.0477610677480698, 0.0476791970431805, 0.0475974455475807, 0.0475157238543034, 0.0474341809749603, 0.0473527535796165, 0.0472713820636272, 0.0471901930868626, 0.04710903018713, 0.047028012573719, 0.0469471476972103, 0.0468662790954113, 0.046785619109869, 0.0467050485312939, 0.0466245673596859, 0.0465441718697548, 0.0464638955891132, 0.0463837683200836, 0.0463036932051182, 0.0462238006293774, 0.0461439676582813, 0.0460641942918301, 0.0459846556186676, 0.0459050871431828, 0.0458256974816322, 0.045746423304081, 0.0456672087311745, 0.0455881394445896, 0.0455091670155525, 0.0454303622245789, 0.0453515611588955, 0.0452729389071465, 0.045194435864687, 0.0451159290969372, 0.045037716627121, 0.0449594147503376, 0.0448813550174236, 0.0448033511638641, 0.0447254329919815, 0.0446476638317108, 0.04457001760602, 0.0444924794137478, 0.0444149784743786, 0.044337660074234, 0.0442604199051857, 0.0441832430660725, 0.0441062711179256, 0.0440293028950691, 0.0439524464309216, 0.0438758581876755, 0.0437992140650749, 0.0437227450311184, 0.0436463914811611, 0.0435700975358486, 0.0434939526021481, 0.0434178709983826, 0.0433419607579708, 0.0432660840451717, 0.0431904084980488, 0.0431147664785385, 0.0430391803383827, 0.0429638922214508, 0.0428885482251644, 0.0428133718669415, 0.0427382923662663, 0.0426632985472679, 0.0425884202122688, 0.042513694614172, 0.0424390845000744, 0.0423644743859768, 0.0422900430858135, 0.0422157570719719, 0.0421414971351624, 0.0420674793422222, 0.0419934317469597, 0.0419194996356964, 0.0418457426130772, 0.0417720228433609, 0.0416985079646111, 0.0416250452399254, 0.0415517017245293, 0.0414784513413906, 0.0414053164422512, 0.041332270950079, 0.0412593446671963, 0.0411865934729576, 0.0411138460040092, 0.0410411804914474, 0.0409687533974648, 0.0408963263034821, 0.0408240742981434, 0.0407519489526749, 0.0406798720359802, 0.0406078957021236, 0.0405360832810402, 0.0404643639922142, 0.0403926819562912, 0.0403212010860443, 0.0402497760951519, 0.040178444236517, 0.0401073098182678, 0.0400361828505993, 0.0399651788175106, 0.039894375950098, 0.0398235768079758, 0.0397529155015945, 0.0396824069321156, 0.0396119020879269, 0.0395415984094143, 0.0394713878631592, 0.0394012928009033, 0.0393312312662601, 0.0392614305019379, 0.0391915999352932, 0.0391218326985836, 0.0390523560345173, 0.0389828495681286, 0.038913581520319, 0.038844283670187, 0.0387750789523125, 0.0387060418725014, 0.0386371612548828, 0.0385683663189411, 0.038499690592289, 0.0384309776127338, 0.0383625328540802, 0.0382940694689751, 0.0382258892059326, 0.038157656788826, 0.0380895957350731, 0.0380216911435127, 0.0379537791013718, 0.0378861613571644, 0.0378184579312801, 0.0377509631216526, 0.0376834608614445, 0.0376161709427834, 0.0375490002334118, 0.0374819003045559, 0.0374164097011089, 0.0373508892953396, 0.037285428494215, 0.0372202023863792, 0.0371548607945442, 0.0370897799730301, 0.0370246171951294, 0.036959569901228, 0.0368947312235832, 0.0368298292160034, 0.0367650762200356, 0.0367003232240677, 0.0366357192397118, 0.0365712009370327, 0.0365067161619663, 0.0364423468708992, 0.0363780073821545, 0.0363138169050217, 0.036249652504921, 0.0361855216324329, 0.0361215621232986, 0.0360576100647449, 0.0359938032925129, 0.0359299927949905, 0.035866305232048, 0.0358027033507824, 0.0357391610741615, 0.0356757082045078, 0.0356123112142086, 0.0355489738285542, 0.0354857854545116, 0.0354226566851139, 0.0353595875203609, 0.0352965779602528, 0.0352336838841438, 0.0351708494126797, 0.0351080410182476, 0.0350454151630402, 0.0349827893078327, 0.0349202789366245, 0.034857802093029, 0.0347954668104649, 0.0347331948578358, 0.0346709489822388, 0.0346088521182537, 0.0345467589795589, 0.0344847775995731, 0.0344228595495224, 0.0343610271811485, 0.0342993177473545, 0.0342376343905926, 0.0341760404407978, 0.0341145358979702, 0.0340530872344971, 0.0339917577803135, 0.0339304879307747, 0.0338692478835583, 0.0338081531226635, 0.0337470918893814, 0.0336861163377762, 0.0336252599954605, 0.0335644036531448, 0.0335036925971508, 0.0334430150687695, 0.0333824530243874, 0.0333219803869724, 0.0332614742219448, 0.0332011766731739, 0.0331409126520157, 0.0330807641148567, 0.0330206193029881, 0.0329605862498283, 0.0329006463289261, 0.0328407324850559, 0.0327809378504753, 0.0327212028205395, 0.0326616168022156, 0.0326020270586014, 0.0325424708425999, 0.0324830897152424, 0.0324237681925297, 0.0323645323514938, 0.0323053300380707, 0.0322462134063244, 0.0321872159838676, 0.0321282483637333, 0.0320693999528885, 0.0320106372237206, 0.0319518744945526, 0.0318932607769966, 0.0318346470594406, 0.0317762717604637, 0.0317178331315517, 0.0316594876348972, 0.0316012836992741, 0.0315430574119091, 0.0314850322902203, 0.0314269177615643, 0.0313690453767776, 0.0313112288713455, 0.0312534086406231, 0.0311957113444805, 0.0311380699276924, 0.0310805812478065, 0.0310230888426304, 0.030965656042099, 0.0309083703905344, 0.0308511108160019, 0.0307939760386944, 0.030736867338419, 0.0306799057871103, 0.0306230057030916, 0.0305661000311375, 0.0305094067007303, 0.0304526500403881, 0.030396044254303, 0.0303395297378302, 0.0302830375730991, 0.0302267577499151, 0.0301703549921513, 0.0301141645759344, 0.0300580281764269, 0.0300019215792418, 0.0299459639936686, 0.0298900064080954, 0.0298342872411013, 0.0297784470021725, 0.0297227539122105, 0.0296671837568283, 0.0296116061508656, 0.0295562390238047, 0.0295008141547441, 0.0294455047696829, 0.0293903183192015, 0.0293351542204618, 0.0292802024632692, 0.0292251594364643, 0.0291702635586262, 0.0291154272854328, 0.0290606506168842, 0.0290060788393021, 0.028951482847333, 0.0288969110697508, 0.0288424864411354, 0.0287881512194872, 0.0287338476628065, 0.0286796316504478, 0.0286255944520235, 0.0285714939236641, 0.0285175144672394, 0.0284636225551367, 0.0284098498523235, 0.0283561069518328, 0.0283024795353413, 0.0282488241791725, 0.0281953439116478, 0.0281419269740582, 0.0280886255204678, 0.0280353259295225, 0.027982110157609, 0.0279290452599525, 0.0278760101646185, 0.0278230626136065, 0.0277701746672392, 0.0277173444628716, 0.0276646055281162, 0.0276119839400053, 0.0275594498962164, 0.0275069754570723, 0.0274545270949602, 0.0274021718651056, 0.0273499637842178, 0.0272977538406849, 0.0272456612437963, 0.0271936319768429, 0.0271417181938887, 0.0270898025482893, 0.0270380657166243, 0.0269863270223141, 0.026934739202261, 0.0268831476569176, 0.0268316175788641, 0.0267802942544222, 0.0267289392650127, 0.0266776774078608, 0.026626531034708, 0.0265753827989101, 0.0265244711190462, 0.0264734420925379, 0.0264226514846087, 0.0263718850910664, 0.0263211522251368, 0.0262705683708191, 0.0262199509888887, 0.0261695422232151, 0.0261191036552191, 0.026068814098835, 0.0260186120867729, 0.0259684380143881, 0.0259183831512928, 0.0258683282881975, 0.0258184522390366, 0.0257686022669077, 0.0257187858223915, 0.0256691724061966, 0.0256194993853569, 0.0255700051784515, 0.0255205128341913, 0.0254711378365755, 0.0254219081252813, 0.0253725927323103, 0.0253235399723053, 0.0252744294703007, 0.0252254363149405, 0.0251765344291925, 0.0251276604831219, 0.0250789616256952, 0.0250302646309137, 0.0249816589057446, 0.0249331369996071, 0.0248846746981144, 0.0248363334685564, 0.0247880183160305, 0.0247399117797613, 0.0246916878968477, 0.0246435794979334, 0.0245957095175982, 0.0245477799326181, 0.0244999974966049, 0.0244521535933018, 0.0244045499712229, 0.0243569444864988, 0.0243094004690647, 0.0242620296776295, 0.0242146607488394, 0.0241673495620489, 0.024120157584548, 0.0240730550140142, 0.0240260399878025, 0.0239790249615908, 0.0239321291446686, 0.023885378614068, 0.0238385703414679, 0.0237919688224792, 0.0237453673034906, 0.0236989427357912, 0.023652458563447, 0.0236060656607151, 0.0235598161816597, 0.023513687774539, 0.0234675854444504, 0.0234214868396521, 0.0233755633234978, 0.0233297310769558, 0.0232838951051235, 0.0232381504029036, 0.0231925211846828, 0.0231469534337521, 0.0231014713644981, 0.0230560507625341, 0.0230107493698597, 0.0229654721915722, 0.0229202602058649, 0.0228751935064793, 0.0228302162140608, 0.0227852370589972, 0.0227403473109007, 0.0226956326514482, 0.0226509217172861, 0.0226062387228012, 0.0225616712123156, 0.0225172266364098, 0.022472808137536, 0.0224285051226616, 0.022384176030755, 0.02234011515975, 0.0222959630191326, 0.022251958027482, 0.022208072245121, 0.0221641846001148, 0.0221204161643982, 0.0220766756683588, 0.0220331139862537, 0.0219895541667938, 0.0219460502266884, 0.0219026952981949, 0.0218593999743462, 0.0218161605298519, 0.0217729825526476, 0.0217298362404108, 0.0216869805008173, 0.0216439515352249, 0.0216011274605989, 0.0215583927929401, 0.0215157475322485, 0.0214730966836214, 0.0214305091649294, 0.0213881600648165, 0.0213457476347685, 0.0213034823536873, 0.021261190995574, 0.0212190747261047, 0.0211770180612803, 0.0211349911987782, 0.021093113347888, 0.0210512932389975, 0.0210094712674618, 0.0209678281098604, 0.0209262426942587, 0.0208847764879465, 0.0208432804793119, 0.0208018720149994, 0.0207606423646212, 0.0207193847745657, 0.0206783283501863, 0.0206371862441301, 0.0205962527543306, 0.0205553788691759, 0.0205144714564085, 0.0204738024622202, 0.0204331614077091, 0.020392581820488, 0.0203520003706217, 0.0203115940093994, 0.020271310582757, 0.0202309656888247, 0.0201907977461815, 0.0201506614685059, 0.0201105512678623, 0.020070618018508, 0.0200307164341211, 0.0199909936636686, 0.0199512057006359, 0.0199115108698606, 0.0198719929903746, 0.0198325049132109, 0.0197931043803692, 0.01975367218256, 0.0197144504636526, 0.0196752566844225, 0.0196361523121595, 0.0195971354842186, 0.0195581763982773, 0.0195193681865931, 0.0194804668426514, 0.0194417778402567, 0.0194031707942486, 0.0193645693361759, 0.0193261131644249, 0.0192877147346735, 0.019249377772212, 0.0192111283540726, 0.0191729087382555, 0.0191348642110825, 0.0190967917442322, 0.0190588384866714, 0.0190209727734327, 0.0189832262694836, 0.0189455077052116, 0.0189078487455845, 0.0188702773302794, 0.0188328549265862, 0.0187954306602478, 0.0187580976635218, 0.018720880150795, 0.0186836943030357, 0.0186466537415981, 0.0186096448451281, 0.0185726936906576, 0.0185358319431543, 0.0184990875422955, 0.0184624008834362, 0.0184257458895445, 0.0183892082422972, 0.0183527898043394, 0.0183163695037365, 0.0182800386101007, 0.0182437673211098, 0.0182077009230852, 0.0181716065853834, 0.0181356277316809, 0.0180996805429459, 0.018063822761178, 0.0180280823260546, 0.0179923698306084, 0.0179568063467741, 0.0179212726652622, 0.0178857371211052, 0.0178504101932049, 0.017815113067627, 0.0177798736840487, 0.0177447516471148, 0.017709631472826, 0.0176747459918261, 0.0176397431641817, 0.0176049191504717, 0.0175702106207609, 0.0175355616956949, 0.0175009425729513, 0.0174663532525301, 0.0174320284277201, 0.017397616058588, 0.0173633489757776, 0.0173291154205799, 0.0172949675470591, 0.017260966822505, 0.0172269381582737, 0.0171930883079767, 0.017159266397357, 0.0171254724264145, 0.0170918256044388, 0.0170582104474306, 0.017024802044034, 0.0169912744313478, 0.0169578939676285, 0.0169247519224882, 0.0168914906680584, 0.0168584045022726, 0.0168252903968096, 0.0167924128472805, 0.0167594756931067, 0.0167266577482224, 0.0166939552873373, 0.0166612844914198, 0.0166287608444691, 0.0165961775928736, 0.0165637731552124, 0.0165314842015505, 0.0164991673082113, 0.0164670273661613, 0.0164349153637886, 0.0164028648287058, 0.016370901837945, 0.016338998451829, 0.0163072999566793, 0.0162754841148853, 0.0162438750267029, 0.0162122957408428, 0.0161808636039495, 0.0161494333297014, 0.0161180309951305, 0.016086895018816, 0.0160556696355343, 0.016024561598897, 0.0159935429692268, 0.0159626137465239, 0.0159317702054977, 0.0159009303897619, 0.0158702358603477, 0.0158396307379007, 0.0158090554177761, 0.0157786272466183, 0.0157481674104929, 0.0157178863883018, 0.0156876351684332, 0.0156574733555317, 0.0156274288892746, 0.0155973844230175, 0.0155674573034048, 0.0155375599861145, 0.0155078405514359, 0.0154781201854348, 0.0154485180974007, 0.0154189448803663, 0.0153895206749439, 0.0153601253405213, 0.0153307886794209, 0.0153015702962875, 0.0152724115177989, 0.0152433700859547, 0.0152143286541104, 0.0151854651048779, 0.0151566304266453, 0.015127825550735, 0.0150991380214691, 0.0150705687701702, 0.0150420293211937, 0.0150135485455394, 0.014985186047852, 0.0149569418281317, 0.0149286380037665, 0.0149005120620131, 0.0148724736645818, 0.0148444948717952, 0.0148165756836534, 0.0147886862978339, 0.0147610316053033, 0.014733319170773, 0.014705752953887, 0.0146781578660011, 0.0146507695317268, 0.0146234100684524, 0.0145960515365005, 0.0145689295604825, 0.0145418057218194, 0.0145147424191236, 0.0144877666607499, 0.014460850507021, 0.0144341122359037, 0.0144072780385613, 0.0143802594393492, 0.0143533274531364, 0.0143263824284077, 0.0142994951456785, 0.0142726823687553, 0.0142459133639932, 0.0142191303893924, 0.0141924060881138, 0.0141657246276736, 0.0141391484066844, 0.0141125712543726, 0.0140859950333834, 0.0140595501288772, 0.0140331061556935, 0.0140066621825099, 0.0139802927151322, 0.0139540266245604, 0.0139277139678597, 0.0139014767482877, 0.0138752404600382, 0.0138491485267878, 0.0138230305165052, 0.0137969544157386, 0.0137709090486169, 0.0137449819594622, 0.0137190548703074, 0.0136931277811527, 0.013667332008481, 0.0136414924636483, 0.0136157870292664, 0.0135899912565947, 0.0135643444955349, 0.0135387275367975, 0.0135131096467376, 0.0134875802323222, 0.0134620955213904, 0.0134365810081363, 0.0134112583473325, 0.0133858481422067, 0.0133605543524027, 0.0133351869881153, 0.0133100273087621, 0.0132847931236029, 0.013259619474411, 0.0132345026358962, 0.0132094155997038, 0.0131844487041235, 0.0131593914702535, 0.013134466484189, 0.0131095871329308, 0.0130847524851561, 0.0130599020048976, 0.0130351390689611, 0.0130104217678308, 0.0129857631400228, 0.012961090542376, 0.0129364905878901, 0.0129119353368878, 0.0128874247893691, 0.0128629291430116, 0.0128385499119759, 0.0128141427412629, 0.0127898091450334, 0.0127655193209648, 0.0127412751317024, 0.0127170439809561, 0.0126928724348545, 0.0126687297597528, 0.0126446625217795, 0.0126206083223224, 0.0125966127961874, 0.0125727234408259, 0.0125487884506583, 0.0125248814001679, 0.0125010637566447, 0.0124773355200887, 0.0124535476788878, 0.0124298483133316, 0.0124062523245811, 0.0123826572671533, 0.012359045445919, 0.0123354941606522, 0.0123120602220297, 0.0122885974124074, 0.0122652379795909, 0.012241818010807, 0.0122185470536351, 0.012195304967463, 0.0121720489114523, 0.0121488803997636, 0.0121257705613971, 0.0121026923879981, 0.0120796132832766, 0.0120566068217158, 0.0120336599647999, 0.0120107280090451, 0.0119878407567739, 0.0119650410488248, 0.011942227371037, 0.0119194872677326, 0.0118967769667506, 0.011874140240252, 0.0118514886125922, 0.0118288956582546, 0.0118064060807228, 0.0117839174345136, 0.0117614576593041, 0.0117389969527721, 0.0117167290300131, 0.0116943586617708, 0.0116721205413342, 0.0116498377174139, 0.0116277039051056, 0.0116055682301521, 0.0115834027528763, 0.0115613853558898, 0.0115394135937095, 0.0115173812955618, 0.0114954374730587, 0.0114736119285226, 0.0114517444744706, 0.0114299478009343, 0.011408151127398, 0.0113864606246352, 0.0113647961989045, 0.0113431643694639, 0.0113215604797006, 0.0113000450655818, 0.0112785594537854, 0.0112570431083441, 0.0112356459721923, 0.0112142935395241, 0.0111929699778557, 0.0111716613173485, 0.0111504709348083, 0.0111292796209455, 0.0111080603674054, 0.011086986400187, 0.011065929196775, 0.0110448719933629, 0.0110239023342729, 0.0110029634088278, 0.0109820952638984, 0.0109612159430981, 0.010940408334136, 0.0109196752309799, 0.0108989560976624, 0.0108782388269901, 0.010857549495995, 0.0108370371162891, 0.0108164679259062, 0.0107959546148777, 0.0107754440978169, 0.0107550639659166, 0.0107346856966615, 0.0107143213972449, 0.0106940306723118, 0.0106737986207008, 0.0106535973027349, 0.0106333941221237, 0.0106132961809635, 0.0105932280421257, 0.0105731878429651, 0.0105531774461269, 0.0105332564562559, 0.0105133345350623, 0.0104934871196747, 0.0104736387729645, 0.0104539087042212, 0.0104341199621558, 0.0104144345968962, 0.0103947790339589, 0.010375197045505, 0.0103556290268898, 0.0103361057117581, 0.0103166569024324, 0.0102972369641066, 0.0102778458967805, 0.0102584855630994, 0.0102391839027405, 0.010219912044704, 0.0102006979286671, 0.0101815136149526, 0.0101624196395278, 0.0101432958617806, 0.0101242288947105, 0.0101052233949304, 0.010086334310472, 0.0100673707202077, 0.0100484536960721, 0.0100296977907419, 0.0100109130144119, 0.00999214127659798, 0.00997343100607395, 0.00995482224971056, 0.00993616972118616, 0.00991756096482277, 0.00989905651658773, 0.00988056696951389, 0.00986217893660069, 0.00984373316168785, 0.00982537586241961, 0.00980707816779613, 0.00978880934417248, 0.00977056939154863, 0.00975238997489214, 0.00973425339907408, 0.00971614755690098, 0.0096980556845665, 0.00968011096119881, 0.00966210849583149, 0.00964425224810839, 0.00962630845606327, 0.00960851181298494, 0.00959068536758423, 0.00957294832915068, 0.00955525413155556, 0.00953756086528301, 0.00951991230249405, 0.00950236618518829, 0.00948479119688272, 0.00946728978306055, 0.00944983214139938, 0.00943249370902777, 0.00941507983952761, 0.0093977265059948, 0.00938052032142878, 0.00936328433454037, 0.00934607814997435, 0.00932887196540833, 0.00931182783097029, 0.00929472409188747, 0.00927770975977182, 0.00926072522997856, 0.00924381334334612, 0.00922688841819763, 0.00921003613620996, 0.00919324345886707, 0.00917649362236261, 0.00915972981601954, 0.00914308521896601, 0.00912646856158972, 0.00910988170653582, 0.00909329485148191, 0.00907675269991159, 0.00906037352979183, 0.00904391892254353, 0.00902753975242376, 0.00901115965098143, 0.00899495650082827, 0.00897866580635309, 0.00896243378520012, 0.00894634798169136, 0.00893023423850536, 0.00891413353383541, 0.008898064494133, 0.00888209696859121, 0.00886615924537182, 0.00885025225579739, 0.00883438903838396, 0.00881858449429274, 0.00880279485136271, 0.00878706388175488, 0.00877139251679182, 0.00875575095415115, 0.00874013733118773, 0.00872456934303045, 0.00870906002819538, 0.0086936242878437, 0.00867814477533102, 0.00866275280714035, 0.00864746607840061, 0.00863211881369352, 0.00861688982695341, 0.0086016459390521, 0.00858652032911777, 0.00857135094702244, 0.00855626910924911, 0.00854124687612057, 0.00852625351399183, 0.00851129088550806, 0.00849632732570171, 0.00848154164850712, 0.00846669543534517, 0.00845187995582819, 0.00843712314963341, 0.0084224846214056, 0.00840778741985559, 0.0083931777626276, 0.008378597907722, 0.00836413633078337, 0.00834961608052254, 0.00833512470126152, 0.00832075159996748, 0.00830642320215702, 0.00829212367534637, 0.00827780924737453, 0.00826365873217583, 0.00824946165084839, 0.0082353251054883, 0.00822120346128941, 0.00820718333125114, 0.00819316506385803, 0.00817917566746473, 0.00816524587571621, 0.0081514036282897, 0.00813753250986338, 0.00812374986708164, 0.00811002589762211, 0.00809633173048496, 0.00808260776102543, 0.00806900206953287, 0.00805545505136251, 0.00804188009351492, 0.00802842155098915, 0.008014933206141, 0.00800156407058239, 0.00798818003386259, 0.0079748248681426, 0.00796155910938978, 0.00794836599379778, 0.00793517380952835, 0.00792198069393635, 0.00790892168879509, 0.00789587665349245, 0.00788281671702862, 0.00786981545388699, 0.0078569483011961, 0.00784402154386044, 0.00783121306449175, 0.00781834498047829, 0.00780563894659281, 0.00779290404170752, 0.00778021337464452, 0.00776758184656501, 0.00775505322962999, 0.00774249527603388, 0.00772995175793767, 0.00771752698346972, 0.00770510174334049, 0.00769275007769465, 0.007680369541049, 0.00766809191554785, 0.00765584362670779, 0.00764364004135132, 0.00763149559497833, 0.00761942425742745, 0.00760729378089309, 0.00759528204798698, 0.00758331455290318, 0.00757137639448047, 0.00755945267155766, 0.00754761788994074, 0.0075358129106462, 0.00752400700002909, 0.00751229096204042, 0.0075005735270679, 0.00748900463804603, 0.00747734680771828, 0.00746577698737383, 0.00745429657399654, 0.00744286039844155, 0.00743142329156399, 0.00742000201717019, 0.0074087125249207, 0.00739745376631618, 0.00738616473972797, 0.00737493485212326, 0.00736374920234084, 0.00735268136486411, 0.00734158465638757, 0.00733051681891084, 0.00731953792273998, 0.00730857346206903, 0.00729771330952644, 0.00728676375001669, 0.00727600557729602, 0.00726520409807563, 0.00725449062883854, 0.00724379206076264, 0.00723312329500914, 0.00722249783575535, 0.00721197668462992, 0.00720145553350449, 0.00719093298539519, 0.00718051521107554, 0.00717018591240048, 0.00715976720675826, 0.00714945187792182, 0.00713925529271364, 0.00712904334068298, 0.00711883185431361, 0.00710864970460534, 0.00709861563518643, 0.00708855083212256, 0.00707856053486466, 0.00706855580210686, 0.00705866934731603, 0.00704881129786372, 0.0070389392785728, 0.00702915573492646, 0.00701941596344113, 0.00700973579660058, 0.00700004026293755, 0.00699043367058039, 0.00698085688054562, 0.00697129406034946, 0.00696183554828167, 0.00695242080837488, 0.00694297673180699, 0.0069336355663836, 0.00692427949979901, 0.00691505614668131, 0.00690578948706388, 0.00689661037176847, 0.00688752066344023, 0.00687838578596711, 0.00686931051313877, 0.00686027947813272, 0.00685138162225485, 0.00684239435940981, 0.00683354027569294, 0.00682465685531497, 0.00681589124724269, 0.0068071112036705, 0.00679838983342052, 0.00678971316665411, 0.0067811394110322, 0.00677250698208809, 0.00676396302878857, 0.00675549218431115, 0.00674702227115631, 0.00673862546682358, 0.00673021376132965, 0.00672193523496389, 0.00671364273875952, 0.00670542242005467, 0.00669715879485011, 0.00668907258659601, 0.00668094120919704, 0.00667284009978175, 0.00666484143584967, 0.00665687257423997, 0.00664893398061395, 0.00664100982248783, 0.00663318857550621, 0.00662539666518569, 0.00661756098270416, 0.00660987244918942, 0.00660219974815845, 0.00659452611580491, 0.00658695586025715, 0.00657942984253168, 0.00657191919162869, 0.00656442204490304, 0.00655701430514455, 0.00654960656538606, 0.00654231663793325, 0.00653499737381935, 0.00652772188186646, 0.00652059447020292, 0.0065133785828948, 0.00650629540905356, 0.00649913866072893, 0.00649217376485467, 0.00648517860099673, 0.00647818436846137, 0.0064712930470705, 0.00646446039900184, 0.00645765755325556, 0.00645081046968699, 0.00644411100074649, 0.00643745576962829, 0.00643078563734889, 0.00642415974289179, 0.00641762232407928, 0.00641108537092805, 0.00640460662543774, 0.00639817304909229, 0.00639184284955263, 0.006385438144207, 0.00637913681566715, 0.0063728797249496, 0.00636666780337691, 0.00636048428714275, 0.00635434594005346, 0.00634829513728619, 0.00634226016700268, 0.00633623916655779, 0.00633026286959648, 0.00632437504827976, 0.00631848722696304, 0.00631265761330724, 0.0063068438321352, 0.00630114739760756, 0.00629540719091892, 0.00628975545987487, 0.0062841041944921, 0.00627861404791474, 0.00627092365175486, 0.00626121368259192, 0.00625159218907356, 0.00624191155657172, 0.00623231986537576, 0.00622272770851851, 0.00621316581964493, 0.00620366260409355, 0.00619415892288089, 0.00618468504399061, 0.00617518229410052, 0.00616582622751594, 0.00615641148760915, 0.00614699674770236, 0.00613764114677906, 0.00612837402150035, 0.00611904775723815, 0.00610978016629815, 0.00610054284334183, 0.00609133439138532, 0.00608215574175119, 0.00607297662645578, 0.00606382777914405, 0.0060547380708158, 0.00604567676782608, 0.00603661686182022, 0.0060275262221694, 0.00601858366280794, 0.00600961176678538, 0.00600063987076283, 0.00599169731140137, 0.00598278362303972, 0.00597395980730653, 0.00596507592126727, 0.00595625163987279, 0.00594745622947812, 0.00593872042372823, 0.00592995528131723, 0.00592124834656715, 0.00591254187747836, 0.00590392434969544, 0.00589527701959014, 0.00588662968948483, 0.00587804103270173, 0.00586948217824101, 0.0058610113337636, 0.00585245294496417, 0.00584398256614804, 0.00583557086065412, 0.00582715962082148, 0.00581871857866645, 0.0058103371411562, 0.00580201391130686, 0.00579366181045771, 0.00578539818525314, 0.00577710522338748, 0.00576884113252163, 0.00576066598296165, 0.00575246103107929, 0.00574431521818042, 0.00573614006862044, 0.00572808319702744, 0.00571996672078967, 0.00571188051253557, 0.00570385251194239, 0.00569585477933288, 0.00568788591772318, 0.00567994685843587, 0.00567200779914856, 0.00566412741318345, 0.00565624749287963, 0.00564839690923691, 0.00564054632559419, 0.00563278421759605, 0.00562502210959792, 0.00561728980392218, 0.00560952769592404, 0.00560188386589289, 0.00559418043121696, 0.0055865366011858, 0.00557895191013813, 0.00557133741676807, 0.00556381139904261, 0.00555625604465604, 0.00554875936359167, 0.00554129248484969, 0.00553385494276881, 0.00552641786634922, 0.00551898032426834, 0.00551166106015444, 0.00550425332039595, 0.00549699272960424, 0.00548964412882924, 0.00548238400369883, 0.00547518255189061, 0.0054679811000824, 0.00546075031161308, 0.00545357912778854, 0.00544646615162492, 0.00543935364112258, 0.00543227000162005, 0.00542518682777882, 0.00541819212958217, 0.00541116762906313, 0.00540414405986667, 0.00539720803499222, 0.00539027247577906, 0.00538342539221048, 0.00537651916965842, 0.00536964228376746, 0.00536282500252128, 0.00535609573125839, 0.00534927845001221, 0.00534254964441061, 0.00533585017547011, 0.00532909110188484, 0.00532248010858893, 0.00531583977863193, 0.00530919898301363, 0.00530264712870121, 0.00529609527438879, 0.00528957275673747, 0.00528302090242505, 0.00527658639475703, 0.00527009414508939, 0.00526365963742137, 0.00525725539773703, 0.00525093963369727, 0.00524456473067403, 0.00523821916431189, 0.00523190340027213, 0.00522564677521586, 0.0052194488234818, 0.00521322153508663, 0.00520699424669147, 0.00520088477060199, 0.00519474595785141, 0.00518860714510083, 0.00518249766901135, 0.00517647713422775, 0.00517042726278305, 0.00516440626233816, 0.00515844440087676, 0.00515248253941536, 0.00514655048027635, 0.00514064822345972, 0.00513477483764291, 0.0051289307884872, 0.00512311700731516, 0.00511733256280422, 0.0051115183159709, 0.00510579254478216, 0.00510006677359343, 0.00509440014138818, 0.00508870417252183, 0.00508306734263897, 0.00507745984941721, 0.00507194083184004, 0.00506633333861828, 0.00506078451871872, 0.00505529483780265, 0.00504983542487025, 0.00504437508061528, 0.00503894500434399, 0.00503354333341122, 0.00502817239612341, 0.00502283032983541, 0.00501745892688632, 0.00501214666292071, 0.0050069522112608, 0.00500166928395629, 0.00499644549563527, 0.00499125104397535, 0.00498614553362131, 0.00498095108196139, 0.00497584464028478, 0.00497076893225312, 0.00496566295623779, 0.00496067525818944, 0.0049556577578187, 0.00495064072310925, 0.00494574150070548, 0.00494081247597933, 0.00493591325357556, 0.0049309846945107, 0.00492620328441262, 0.00492133386433125, 0.00491655291989446, 0.00491177104413509, 0.00490707904100418, 0.00490232696756721, 0.00489763449877501, 0.00489297136664391, 0.00488827889785171, 0.00488373357802629, 0.00487912958487868, 0.00487452512606978, 0.00487000960856676, 0.00486555369570851, 0.0048610670492053, 0.00485658133402467, 0.00485218362882733, 0.0048477272503078, 0.00484338868409395, 0.00483902078121901, 0.00483468221500516, 0.00483043259009719, 0.00482615269720554, 0.00482190307229757, 0.0048176827840507, 0.00481352116912603, 0.00480933021754026, 0.00480519840493798, 0.00480103679001331, 0.00479702325537801, 0.00479295058175921, 0.00478887744247913, 0.00478486344218254, 0.00478087924420834, 0.00477698352187872, 0.00477299932390451, 0.0047691036015749, 0.00476523721590638, 0.00476140016689897, 0.00475756358355284, 0.0047537568025291, 0.00475000869482756, 0.00474626058712602, 0.00474254135042429, 0.00473882257938385, 0.0047351629473269, 0.00473156245425344, 0.00472790282219648, 0.00472433166578412, 0.00472076097503304, 0.00471727782860398, 0.00471373647451401, 0.00471025379374623, 0.00470680044963956, 0.00470331823453307, 0.00469998316839337, 0.00469658896327019, 0.004693194758147, 0.00468988949432969, 0.00468664290383458, 0.00468336697667837, 0.00468009104952216, 0.00467690359801054, 0.00467371614649892, 0.0046705286949873, 0.00466737104579806, 0.00466430140659213, 0.0046612024307251, 0.00465813279151917, 0.00465509295463562, 0.00465205311775208, 0.00464910175651312, 0.00464615086093545, 0.00464319903403521, 0.00464033614844084, 0.00463744392618537, 0.00463461084291339, 0.00463177775964141, 0.00462894421070814, 0.00462616980075836, 0.00462345452979207, 0.00462070992216468, 0.00461802445352077, 0.00461536785587668, 0.00461274152621627, 0.00461011473089457, 0.00460754707455635, 0.00460497941821814, 0.00460244109854102, 0.00459993258118629, 0.00459742359817028, 0.00459500402212143, 0.00459258351475, 0.00459013413637877, 0.00458774343132973, 0.00458541186526418, 0.00458308029919863, 0.00458083720877767, 0.0045785354450345, 0.00457626301795244, 0.00457407860085368, 0.00457186531275511, 0.00456971069797873, 0.00456758588552475, 0.00456546060740948, 0.00456333579495549, 0.0045613287948072, 0.0045592631213367, 0.0045572267845273, 0.00455530826002359, 0.0045533012598753, 0.00455138273537159, 0.00454952381551266, 0.00454760529100895, 0.00454574590548873, 0.004543945658952, 0.00454214541241527, 0.00454031536355615, 0.0045386329293251, 0.00453689182177186, 0.00453518005087972, 0.00453355675563216, 0.00453187478706241, 0.00453025149181485, 0.00452871667221189, 0.00452712271362543, 0.00452558835968375, 0.00452408287674189, 0.0045226076617837, 0.00452113198116422, 0.00451971497386694, 0.00451832776889205, 0.00451691122725606, 0.00451561296358705, 0.00451425509527326, 0.00451292702928185, 0.00451171677559614, 0.00451041851192713, 0.0045092673972249, 0.00450805714353919, 0.00450684735551476, 0.00450569624081254, 0.0045046042650938, 0.00450351228937507, 0.00450244965031743, 0.00450141681358218, 0.00450041331350803, 0.00449943961575627, 0.00449849525466561, 0.00449755042791367, 0.00449666520580649, 0.00449577951803803, 0.00449489429593086, 0.00449412688612938, 0.0044933008030057, 0.00449250359088182, 0.00449173618108034, 0.00449102791026235, 0.00449034897610545, 0.00448969984427094, 0.00448905071243644, 0.00448843091726303, 0.00448784045875072, 0.00448727980256081, 0.00448674848303199, 0.00448624696582556, 0.00448577478528023, 0.00448527280241251, 0.00448488909751177, 0.00448444671928883, 0.0044840625487268, 0.00448376778513193, 0.00448338408023119, 0.00448308885097504, 0.00448285276070237, 0.00448258733376861, 0.00448235124349594, 0.00448217429220676, 0.0044819968752563, 0.00448181992396712, 0.00448176078498363, 0.00448167230933905, 0.00448155403137207, 0.00448158383369446, 0.00448152469471097, 0.00448155403137207, 0.00448164297267795, 0.00448167230933905, 0.00448181992396712, 0.00448187859728932, 0.00448202667757869, 0.00448220362886786, 0.00448240991681814, 0.00448264600709081, 0.00448285276070237, 0.00448317732661963, 0.00448347255587578, 0.00448376778513193, 0.00448418082669377, 0.00448453519493341, 0.00448500737547874, 0.00448542041704059, 0.00448586326092482, 0.00448633544147015, 0.00448686676099896, 0.00448739808052778, 0.0044879587367177, 0.00448857853189111, 0.00448919832706451, 0.00448984745889902, 0.00449052639305592, 0.00449120486155152, 0.00449197227135301, 0.00449271034449339, 0.00449344795197248, 0.00449430383741856, 0.00449513038620353, 0.0044959569349885, 0.00449687195941806, 0.00449775718152523, 0.00449870154261589, 0.00449967524036765, 0.0045006494037807, 0.00450165290385485, 0.0045027150772512, 0.00450377771630883, 0.00450486969202757, 0.00450602080672979, 0.00450717192143202, 0.00450829323381186, 0.00450953282415867, 0.00451074307784438, 0.00451198266819119, 0.0045133107341826, 0.00451457966119051, 0.00451590772718191, 0.0045172655954957, 0.00451865280047059, 0.00452006934210658, 0.00452151568606496, 0.00452296156436205, 0.00452440790832043, 0.00452597206458449, 0.00452750641852617, 0.00452904123812914, 0.00453069433569908, 0.00453228782862425, 0.0045339111238718, 0.00453565223142505, 0.00453730532899499, 0.00453907577320933, 0.00454078754410148, 0.00454255845397711, 0.00454435870051384, 0.00454621808603406, 0.00454807747155428, 0.0045499075204134, 0.00455188471823931, 0.00455380324274302, 0.00455578044056892, 0.00455775810405612, 0.00455973530188203, 0.00456183077767491, 0.0045638969168067, 0.00456596259027719, 0.00456811720505357, 0.00457024201750755, 0.00457239663228393, 0.0045745805837214, 0.00457682367414236, 0.00457906629890203, 0.00458136852830648, 0.00458367075771093, 0.00458597298711538, 0.00458836322650313, 0.00459075393155217, 0.00459311483427882, 0.00459562335163355, 0.00459807319566607, 0.0046005230396986, 0.00460309069603682, 0.00460556987673044, 0.00460813706740737, 0.00461076386272907, 0.00461336132138968, 0.00461601745337248, 0.00461870338767767, 0.00462138885632157, 0.00462410412728786, 0.00462687807157636, 0.00462965248152614, 0.00463242689147592, 0.00463528977707028, 0.00463812286034226, 0.00464098574593663, 0.00464396644383669, 0.00464685913175344, 0.00464981002733111, 0.00465282052755356, 0.004655831027776, 0.00465884106233716, 0.00466194003820419, 0.00466503947973251, 0.00466810865327716, 0.00467129610478878, 0.0046744835563004, 0.00467764167115092, 0.00468091713264585, 0.00468413438647985, 0.00468741031363606, 0.00469071604311466, 0.00469405064359307, 0.00469744484871626, 0.00470077991485596, 0.00470420345664024, 0.00470762699842453, 0.0047111096791923, 0.00471459235996008, 0.00471807457506657, 0.00472164619714022, 0.00472518755123019, 0.00472881738096476, 0.00473244767636061, 0.00473604816943407, 0.0047397674061358, 0.00474345637485385, 0.00474714580923319, 0.00475095259025693, 0.00475470069795847, 0.0047584786079824, 0.00476231519132853, 0.00476618204265833, 0.00477004796266556, 0.00477397302165627, 0.00477792834863067, 0.0047818529419601, 0.00478586694225669, 0.00478988094255328, 0.00479389447718859, 0.00479799741879106, 0.00480209942907095, 0.00480617210268974, 0.00481036305427551, 0.00481449486687779, 0.00481868628412485, 0.00482293590903282, 0.00482718599960208, 0.00483146542683244, 0.00483577465638518, 0.00484011275693774, 0.00484445132315159, 0.00484884902834892, 0.00485324626788497, 0.0048576439730823, 0.00486215949058533, 0.00486661586910486, 0.00487110204994678, 0.0048757060430944, 0.00488022156059742, 0.00488482555374503, 0.00488945934921503, 0.00489409267902374, 0.00489875581115484, 0.00490347854793072, 0.00490820035338402, 0.00491289282217622, 0.00491773290559649, 0.00492254365235567, 0.00492732459679246, 0.00493222381919622, 0.00493706436827779, 0.00494202272966504, 0.00494692195206881, 0.00495188031345606, 0.0049569271504879, 0.00496188504621387, 0.00496693188324571, 0.00497197872027755, 0.00497711449861526, 0.00498222000896931, 0.00498732598498464, 0.00499254930764437, 0.00499768508598208, 0.00500296801328659, 0.00500822113826871, 0.00501344539225101, 0.00501881632953882, 0.00502409925684333, 0.00502944132313132, 0.00503487186506391, 0.005040243268013, 0.00504567380994558, 0.00505116302520037, 0.00505662336945534, 0.00506214192137122, 0.00506769074127078, 0.00507326843217015, 0.005078817717731, 0.00508448388427496, 0.00509012071415782, 0.00509575800970197, 0.0051015131175518, 0.00510718021541834, 0.00511293485760689, 0.00511874910444021, 0.00512453354895115, 0.00513034826144576, 0.00513622071594, 0.00514209410175681, 0.00514799682423472, 0.00515395868569613, 0.00515989074483514, 0.00516585260629654, 0.00517190247774124, 0.00517795328050852, 0.00518397381529212, 0.0051901126280427, 0.00519619230180979, 0.00520233111456037, 0.00520855840295553, 0.0052147270180285, 0.00522092403843999, 0.00522718112915754, 0.00523346802219748, 0.00523978378623724, 0.00524609955027699, 0.00525244465097785, 0.00525879021733999, 0.00526525359600782, 0.00527168763801455, 0.00527812168002129, 0.00528464373201132, 0.00529110711067915, 0.00529768876731396, 0.00530424108728766, 0.00531082227826118, 0.00531749241054058, 0.00532410340383649, 0.0053307437337935, 0.00533744320273399, 0.00534420227631927, 0.00535093108192086, 0.00535766035318375, 0.00536450743675232, 0.0053712953813374, 0.00537820160388947, 0.00538507802411914, 0.0053919549100101, 0.00539894960820675, 0.00540585583075881, 0.00541285052895546, 0.00541990390047431, 0.00542689859867096, 0.00543395197018981, 0.00544106541201472, 0.00544817745685577, 0.0054553197696805, 0.00546252168715, 0.00546969287097454, 0.00547689478844404, 0.00548418425023556, 0.00549144437536597, 0.00549873430281878, 0.00550608336925507, 0.00551340216770768, 0.00552078057080507, 0.00552824791520834, 0.00553562631830573, 0.00554309319704771, 0.00555058941245079, 0.00555811543017626, 0.00556564144790173, 0.00557322613894939, 0.00558078149333596, 0.00558836665004492, 0.00559606961905956, 0.00560374278575182, 0.00561138708144426, 0.0056191785261035, 0.00562688196077943, 0.00563464360311627, 0.005642494186759, 0.00565028563141823, 0.00565819535404444, 0.00566601613536477, 0.00567392585799098, 0.00568189425393939, 0.00568983377888799, 0.0056978315114975, 0.00570580037310719, 0.00571388704702258, 0.00572194438427687, 0.00573000172153115, 0.00573817687109113, 0.00574626354500651, 0.00575446803122759, 0.00576264364644885, 0.00577084813266993, 0.00577914109453559, 0.00578740518540144, 0.0057956981472671, 0.00580402137711644, 0.00581237347796559, 0.00582075491547585, 0.00582916615530849, 0.00583760719746351, 0.00584601843729615, 0.00585454795509577, 0.00586307793855667, 0.0058715776540339, 0.00588019518181682, 0.00588872469961643, 0.00589734269306064, 0.00590604869648814, 0.00591466715559363, 0.00592334382236004, 0.00593207962810993, 0.0059408457018435, 0.00594961084425449, 0.00595843559131026, 0.00596726033836603, 0.00597605528309941, 0.00598499737679958, 0.00599388126283884, 0.00600276468321681, 0.00601179571822286, 0.00602073827758431, 0.00602973997592926, 0.00603882968425751, 0.00604786118492484, 0.00605695089325309, 0.00606607086956501, 0.00607521971687675, 0.00608436949551105, 0.00609357701614499, 0.0061027854681015, 0.00611199392005801, 0.00612134952098131, 0.00613058684393764, 0.00613991310819983, 0.00614932831376791, 0.00615865411236882, 0.0061680693179369, 0.00617754273116589, 0.00618695793673396, 0.00619649048894644, 0.00620596436783671, 0.00621549738571048, 0.00622508907690644, 0.00623468123376369, 0.00624427292495966, 0.00625389441847801, 0.00626360438764095, 0.00627328455448151, 0.00628296518698335, 0.00629276316612959, 0.00630250293761492, 0.00631236052140594, 0.00632215896621346, 0.00633198674768209, 0.0063419328071177, 0.00635179039090872, 0.00636170664802194, 0.00637168204411864, 0.00638168724253774   }, 
   { 4.34938265243545e-05, 4.32198467024136e-05, 4.29474494012538e-05, 4.26758379035164e-05, 4.24034406023566e-05, 4.2132622183999e-05, 4.18641684518661e-05, 4.1595718357712e-05, 4.13272682635579e-05, 4.10603970522061e-05, 4.07935222028755e-05, 4.05290193157271e-05, 4.02629375457764e-05, 4.00000135414302e-05, 3.9736300095683e-05, 3.94725830119569e-05, 3.92120273318142e-05, 3.89506858482491e-05, 3.86909196095075e-05, 3.84319391741883e-05, 3.81729660148267e-05, 3.79163575416896e-05, 3.76589632651303e-05, 3.74023547919933e-05, 3.71481146430597e-05, 3.68930886907037e-05, 3.66396343451925e-05, 3.63861872756388e-05, 3.61343154509086e-05, 3.58840261469595e-05, 3.56321543222293e-05, 3.53842333424836e-05, 3.51347298419569e-05, 3.48860157828312e-05, 3.46396736858878e-05, 3.43925421475433e-05, 3.41485683748033e-05, 3.39022262778599e-05, 3.36574594257399e-05, 3.34158539772034e-05, 3.31726696458645e-05, 3.29310641973279e-05, 3.26902445522137e-05, 3.24494285450783e-05, 3.22117703035474e-05, 3.19717437378131e-05, 3.17356643790845e-05, 3.14980061375536e-05, 3.12619304168038e-05, 3.10266404994763e-05, 3.07921363855712e-05, 3.0559218430426e-05, 3.03255092148902e-05, 3.00933752441779e-05, 2.98628237942467e-05, 2.9632270525326e-05, 2.94025085167959e-05, 2.91735341306776e-05, 2.89453528239392e-05, 2.87187467620242e-05, 2.84913530776976e-05, 2.82671171589755e-05, 2.80413041764405e-05, 2.78170682577183e-05, 2.75944112217985e-05, 2.73709647444775e-05, 2.71490971499588e-05, 2.69280208158307e-05, 2.67077321041143e-05, 2.64898135355907e-05, 2.62711037066765e-05, 2.60523956967518e-05, 2.58368454524316e-05, 2.56197145063197e-05, 2.54065344051924e-05, 2.5190194719471e-05, 2.49762215389637e-05, 2.47646185016492e-05, 2.4552227841923e-05, 2.43414160649991e-05, 2.41306006500963e-05, 2.3919787054183e-05, 2.37113436014624e-05, 2.35028983297525e-05, 2.32968232012354e-05, 2.30899568123277e-05, 2.28830922424095e-05, 2.26793872570852e-05, 2.24748891923809e-05, 2.22727612708695e-05, 2.20690544665558e-05, 2.18669265450444e-05, 2.16671669477364e-05, 2.14658284676261e-05, 2.12676495721098e-05, 2.10686794162029e-05, 2.08712881430984e-05, 2.06738986889832e-05, 2.04780862986809e-05, 2.02830651687691e-05, 2.00888316612691e-05, 1.98938087123679e-05, 1.97019453480607e-05, 1.95092943613417e-05, 1.93182186194463e-05, 1.91271446965402e-05, 1.89376514754258e-05, 1.87497334991349e-05, 1.85602402780205e-05, 1.83739030035213e-05, 1.8187565729022e-05, 1.80012302735122e-05, 1.78164718818152e-05, 1.76317134901183e-05, 1.74501146830153e-05, 1.72661475517089e-05, 1.70837593032047e-05, 1.69045288203051e-05, 1.67237176356139e-05, 1.65444871527143e-05, 1.63660461112158e-05, 1.61876050697174e-05, 1.60123217938235e-05, 1.58346701937262e-05, 1.56601781782228e-05, 1.54856843437301e-05, 1.53111905092373e-05, 1.51390668179374e-05, 1.49661527757416e-05, 1.47956061482546e-05, 1.46250613397569e-05, 1.44545165312593e-05, 1.42863391374703e-05, 1.41181626531761e-05, 1.3950775610283e-05, 1.37841780087911e-05, 1.36175804072991e-05, 1.34541405714117e-05, 1.32883324113209e-05, 1.31248934849282e-05, 1.29630325318431e-05, 1.28011724882526e-05, 1.26408913274645e-05, 1.24798207252752e-05, 1.23203299153829e-05, 1.21632065201993e-05, 1.20037148008123e-05, 1.18481711979257e-05, 1.16918372441432e-05, 1.15347147584544e-05, 1.13815394797712e-05, 1.12275756691815e-05, 1.10759792733006e-05, 1.09220145532163e-05, 1.07704190668301e-05, 1.06211919046473e-05, 1.04711743915686e-05, 1.03219472293858e-05, 1.01742998595e-05, 1.00258612292237e-05, 9.87979274214013e-06, 9.73372334556188e-06, 9.59002318268176e-06, 9.4455335784005e-06, 9.3002536232234e-06, 9.15892178454669e-06, 9.01758994586999e-06, 8.87704845808912e-06, 8.73571661941241e-06, 8.59596366353799e-06, 8.45857994136168e-06, 8.31961733638309e-06, 8.18381249700906e-06, 8.04721821623389e-06, 7.91141428635456e-06, 7.7771883297828e-06, 7.64296328270575e-06, 7.51110565033741e-06, 7.37845948606264e-06, 7.24581286704051e-06, 7.11632446837029e-06, 6.98604708304629e-06, 6.85576924297493e-06, 6.72864962325548e-06, 6.60153000353603e-06, 6.4759897213662e-06, 6.3488696468994e-06, 6.22332981947693e-06, 6.10015786151052e-06, 5.97698635829147e-06, 5.8546038417262e-06, 5.73222177990829e-06, 5.61062961423886e-06, 5.49219475942664e-06, 5.37060259375721e-06, 5.25374753124197e-06, 5.13531267642975e-06, 5.01687827636488e-06, 4.9023919928004e-06, 4.7863263716863e-06, 4.67262952952296e-06, 4.55814279121114e-06, 4.4444459490478e-06, 4.33311743108789e-06, 4.22099992647418e-06, 4.11125074606389e-06, 4.00071166950511e-06, 3.89175238524331e-06, 3.78437175641011e-06, 3.67620191354945e-06, 3.5704003948922e-06, 3.46380943483382e-06, 3.35879781232507e-06, 3.25457563121745e-06, 3.15114289151097e-06, 3.04928926198045e-06, 2.94664641842246e-06, 2.84479278889194e-06, 2.74609737971332e-06, 2.64582308773242e-06, 2.54791734732862e-06, 2.44922216552368e-06, 2.35210609389469e-06, 2.25735857384279e-06, 2.16024227484013e-06, 2.06549475478823e-06, 1.97232657228597e-06, 1.87836849363521e-06, 1.78756886271003e-06, 1.6951901216089e-06, 1.60439049068373e-06, 1.51438041484653e-06, 1.42515989409731e-06, 1.33830792492518e-06, 1.25066662803874e-06, 1.1622356623775e-06, 1.07775247215613e-06, 9.92479726846796e-07, 9.08786148556828e-07, 8.24302958335466e-07, 7.41398935133475e-07, 6.60863634038833e-07, 5.787491090814e-07, 4.99792918162711e-07, 4.20047115312627e-07, 3.40301340884253e-07, 2.62924231719808e-07, 1.85547122555363e-07, 1.10538714181985e-07, 3.39511778690849e-08, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 3.78989888361048e-08, 1.14486525149005e-07, 1.8949494062781e-07, 2.68451174179063e-07, 3.45828283343508e-07, 4.2399491917422e-07, 5.03740693602595e-07, 5.83486496452679e-07, 6.65600964566693e-07, 7.47715432680707e-07, 8.29040402550163e-07, 9.13523535928107e-07, 9.97217171061493e-07, 1.08248980268399e-06, 1.16855221676815e-06, 1.25461440347863e-06, 1.34383492422785e-06, 1.43068677971314e-06, 1.52069696923718e-06, 1.61070704507438e-06, 1.70071712091158e-06, 1.79230630692473e-06, 1.8846851617127e-06, 1.97864301298978e-06, 2.07102175409091e-06, 2.1657692741428e-06, 2.26209590437065e-06, 2.35842230722483e-06, 2.45553860622749e-06, 2.55265467785648e-06, 2.65134985966142e-06, 2.75162460638967e-06, 2.85110922959575e-06, 2.9529626317526e-06, 3.0548164886568e-06, 3.15588022203883e-06, 3.26089207192126e-06, 3.36432481162774e-06, 3.47091577168612e-06, 3.57513772542006e-06, 3.68172868547845e-06, 3.79068865186127e-06, 3.89806882594712e-06, 4.00781755161006e-06, 4.11756673202035e-06, 4.22731591243064e-06, 4.34022331319284e-06, 4.45076238975162e-06, 4.56524912806344e-06, 4.67894597022678e-06, 4.79264281239011e-06, 4.90870843350422e-06, 5.02477405461832e-06, 5.14320845468319e-06, 5.26006397194578e-06, 5.37770847586216e-06, 5.4985116548778e-06, 5.61852493774495e-06, 5.74011755816173e-06, 5.86171017857851e-06, 5.98330279899528e-06, 6.10805363976397e-06, 6.23122514298302e-06, 6.35597643849906e-06, 6.48309560347116e-06, 6.60863588564098e-06, 6.73654494676157e-06, 6.86524390403065e-06, 6.99394240655238e-06, 7.12343035047525e-06, 7.2537081905466e-06, 7.38635526431608e-06, 7.51821153244236e-06, 7.650068255316e-06, 7.78508365328889e-06, 7.91930960986065e-06, 8.05511353973998e-06, 8.19091928860871e-06, 8.32751356938388e-06, 8.46647617436247e-06, 8.60385989653878e-06, 8.74440138431964e-06, 8.88415434019407e-06, 9.02548617887078e-06, 9.16760745894862e-06, 9.30972782953177e-06, 9.45421834330773e-06, 9.59791850618785e-06, 9.74161957856268e-06, 9.88847750704736e-06, 1.00353363450267e-05, 1.01829837149126e-05, 1.03306319942931e-05, 1.04790697150747e-05, 1.06298766695545e-05, 1.07791038317373e-05, 1.09322782009258e-05, 1.10838745968067e-05, 1.12362604340888e-05, 1.13910145955742e-05, 1.15449784061639e-05, 1.17013123599463e-05, 1.18568568723276e-05, 1.20131890071207e-05, 1.21718921946012e-05, 1.23305935630924e-05, 1.24900852824794e-05, 1.26495770018664e-05, 1.28106476040557e-05, 1.29732970890473e-05, 1.31351571326377e-05, 1.3297807527124e-05, 1.34628262458136e-05, 1.36270546136075e-05, 1.37936522150994e-05, 1.39602507260861e-05, 1.41268474180833e-05, 1.42958133437787e-05, 1.44639907375677e-05, 1.46353258969611e-05, 1.48050821735524e-05, 1.497562698205e-05, 1.51485410242458e-05, 1.53214550664416e-05, 1.54967383423354e-05, 1.56696532940259e-05, 1.58449347509304e-05, 1.60225863510277e-05, 1.61986590683227e-05, 1.63771001098212e-05, 1.65547517099185e-05, 1.67339821928181e-05, 1.69147933775093e-05, 1.70948114828207e-05, 1.72779909917153e-05, 1.74603792402195e-05, 1.76419780473225e-05, 1.78275258804206e-05, 1.80122824531281e-05, 1.81994109880179e-05, 1.83841675607255e-05, 1.85712924576364e-05, 1.87607893167296e-05, 1.89487036550418e-05, 1.91397775779478e-05, 1.93292726180516e-05, 1.95203465409577e-05, 1.97130011656554e-05, 1.99056539713638e-05, 2.01006751012756e-05, 2.02949086087756e-05, 2.04891402972862e-05, 2.06857421289897e-05, 2.08831315831048e-05, 2.10789439734071e-05, 2.12787035707152e-05, 2.14776719076326e-05, 2.16790103877429e-05, 2.18787699850509e-05, 2.20801084651612e-05, 2.22838152694749e-05, 2.24867326323874e-05, 2.26912288781023e-05, 2.28957251238171e-05, 2.31010126299225e-05, 2.33086666412419e-05, 2.35147435887484e-05, 2.37247659242712e-05, 2.39332111959811e-05, 2.41416546487017e-05, 2.43532576860161e-05, 2.45640712819295e-05, 2.47772532020463e-05, 2.49888544203714e-05, 2.52028276008787e-05, 2.54183760262094e-05, 2.56331386481179e-05, 2.58494783338392e-05, 2.60658180195605e-05, 2.62837365880841e-05, 2.65024464169983e-05, 2.67211562459124e-05, 2.69422325800406e-05, 2.71633107331581e-05, 2.73835976258852e-05, 2.76070441032061e-05, 2.78304887615377e-05, 2.8055514121661e-05, 2.82789624179713e-05, 2.85047754005063e-05, 2.8732169084833e-05, 2.89587733277585e-05, 2.91877477138769e-05, 2.94159308396047e-05, 2.96456946671242e-05, 2.9877037377446e-05, 3.0106799385976e-05, 3.03405086015118e-05, 3.05726389342453e-05, 3.08055605273694e-05, 3.10408504446968e-05, 3.12761367240455e-05, 3.1513009162154e-05, 3.17490885208827e-05, 3.19859573210124e-05, 3.22259838867467e-05, 3.24644315696787e-05, 3.27036686940119e-05, 3.29452741425484e-05, 3.31868832290638e-05, 3.34300639224239e-05, 3.36724588123616e-05, 3.39164362230804e-05, 3.41627783200238e-05, 3.44067520927638e-05, 3.46546767104883e-05, 3.49010188074317e-05, 3.51489397871774e-05, 3.53984432877041e-05, 3.56471573468298e-05, 3.58990255335812e-05, 3.61493184755091e-05, 3.64011903002393e-05, 3.66546373697929e-05, 3.69080880773254e-05, 3.71631140296813e-05, 3.74181436200161e-05, 3.76731732103508e-05, 3.79313569283113e-05, 3.81879654014483e-05, 3.84477352781687e-05, 3.87067084375303e-05, 3.89656852348708e-05, 3.92270339943934e-05, 3.94883754779585e-05, 3.97520889237057e-05, 4.00142234866507e-05, 4.02779405703768e-05, 4.05440223403275e-05, 4.08093146688771e-05, 4.10761858802289e-05, 4.13430570915807e-05, 4.16107213823125e-05, 4.18807503592689e-05, 4.2149200453423e-05, 4.24208119511604e-05, 4.2691630369518e-05, 4.29624524258543e-05, 4.32364286098164e-05, 4.35096153523773e-05, 4.37851740571205e-05, 4.40591538790613e-05, 4.43347089458257e-05, 4.46126359747723e-05, 4.48897735623177e-05, 4.51692758360878e-05, 4.54479959444143e-05, 4.57274982181843e-05, 4.60093724541366e-05, 4.62896641693078e-05, 4.65731172880623e-05, 4.68565704068169e-05, 4.71392340841703e-05, 4.74250555271283e-05, 4.77100875286851e-05, 4.79982772958465e-05, 4.82840987388045e-05, 4.85714990645647e-05, 4.88612713525072e-05, 4.91510400024708e-05, 4.94415980938356e-05, 4.97321598231792e-05, 5.00242967973463e-05, 5.03180126543157e-05, 5.06101532664616e-05, 5.09046585648321e-05, 5.12007427460048e-05, 5.14952480443753e-05, 5.17937041877303e-05, 5.2090581448283e-05, 5.23890339536592e-05, 5.26882795384154e-05, 5.29875251231715e-05, 5.32899248355534e-05, 5.35907493031118e-05, 5.38923595740926e-05, 5.41963418072555e-05, 5.45003240404185e-05, 5.48050957149826e-05, 5.51106568309478e-05, 5.54162143089343e-05, 5.57249331905041e-05, 5.60320731892716e-05, 5.63415851502214e-05, 5.66510898352135e-05, 5.69606017961632e-05, 5.72724748053588e-05, 5.7584355090512e-05, 5.78978106204886e-05, 5.82104767090641e-05, 5.85239322390407e-05, 5.88405455346219e-05, 5.9156369388802e-05, 5.94737757637631e-05, 5.97903890593443e-05, 6.01085885136854e-05, 6.04291453782935e-05, 6.07473411946557e-05, 6.10694842180237e-05, 6.13908341620117e-05, 6.17121841059998e-05, 6.203669909155e-05, 6.23596279183403e-05, 6.1415703385137e-05, 5.91085990890861e-05, 5.68204523005988e-05, 5.45465118193533e-05, 5.22780974279158e-05, 5.00231108162552e-05, 4.77815410704352e-05, 4.55462904938031e-05, 4.33311724918894e-05, 4.11219843954314e-05, 3.8919100916246e-05, 3.67304346582387e-05, 3.45662447216455e-05, 3.23973181366455e-05, 3.02406297123525e-05, 2.81092052318854e-05, 2.59730441030115e-05, 2.38554384850431e-05, 2.17516517295735e-05, 1.96533892449224e-05, 1.75685490830801e-05, 1.54912122525275e-05, 1.34261126731872e-05, 1.13811447590706e-05, 9.34209947445197e-06, 7.30937335902127e-06, 5.29717362951487e-06, 3.29721206071554e-06, 1.29843306240218e-06, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 6.25252578174695e-05, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 2.62931024508362e-07, 2.25143844545528e-06, 4.24547761213034e-06, 6.25886332272785e-06, 8.27975145512028e-06, 1.03124702945934e-05, 1.23598065329134e-05, 1.44189871207345e-05, 1.64789489645045e-05, 1.85582648555283e-05, 2.06565255211899e-05, 2.27496566367336e-05, 2.48617325269151e-05, 2.69927695626393e-05, 2.91245869448176e-05, 3.12698175548576e-05, 3.34340111294296e-05, 3.56045202352107e-05, 3.7782134313602e-05, 3.99668533646036e-05, 4.21827571699396e-05, 4.43876124336384e-05, 4.66106212115847e-05, 4.88470614072867e-05, 5.11028410983272e-05, 5.33590173290577e-05, 5.56222839804832e-05, 5.79167608520947e-05, 6.0212016251171e-05, 6.25080647296272e-05, 6.48356945021078e-05, 6.71641100780107e-05, 6.94925329298712e-05, 7.18462106306106e-05, 7.42137272027321e-05, 7.65812219469808e-05, 7.89684636401944e-05, 8.13683291198686e-05, 8.37745246826671e-05, 8.61949301906861e-05, 8.86145498952828e-05, 9.10602102521807e-05, 9.35129864956252e-05, 9.5978393801488e-05, 9.8451302619651e-05, 0.000100942372228019, 0.000103433842014056, 0.000105939507193398, 0.000108475978777278, 0.000110995082650334, 0.000113539048470557, 0.000116108283691574, 0.000118672782264184, 0.000121242803288624, 0.000123833364341408, 0.000126436149002984, 0.000129045263747685, 0.000131674503791146, 0.000134310073917732, 0.000136953123728745, 0.000139602096169256, 0.000142283068271354, 0.000144952573464252, 0.00014764656953048, 0.000150342137203552, 0.000153062559547834, 0.000155789719428867, 0.000158518043463118, 0.000161270858370699, 0.000164031560416333, 0.000166791855008341, 0.000169577833730727, 0.000172383530298248, 0.000175177003256977, 0.000177996553247795, 0.000180821603862569, 0.000183660085895099, 0.000186512756044976, 0.000189376893104054, 0.000192248931853101, 0.000195126893231645, 0.000198017485672608, 0.000200935304746963, 0.000203846037038602, 0.000206776865525171, 0.000209713645745069, 0.000212669794564135, 0.000215633393963799, 0.000218602945096791, 0.000221598951611668, 0.000224594929022714, 0.000227596843615174, 0.000230625621043146, 0.000233648053836077, 0.000236689447774552, 0.000239744651480578, 0.000242812107899226, 0.000245887058554217, 0.000248980533797294, 0.000252081168582663, 0.000255182560067624, 0.000258308835327625, 0.000261436303844675, 0.000264588627032936, 0.000267741328570992, 0.000270908290985972, 0.000274087040452287, 0.000277280050795525, 0.000280472246231511, 0.000283690518699586, 0.000286922149825841, 0.000290146766928956, 0.000293398567009717, 0.000296655896818265, 0.000299926672596484, 0.000303210865240544, 0.000306500965962186, 0.000309811613988131, 0.000313121447106823, 0.000316451012622565, 0.000319787708576769, 0.000323130720062181, 0.000320979161188006, 0.000313386728521436, 0.000305680587189272, 0.000298100814688951, 0.000290634721750394, 0.000283383385976776, 0.000276037259027362, 0.000268741714535281, 0.000261578825302422, 0.000254472746746615, 0.000247410876909271, 0.00024058909912128, 0.000233704107813537, 0.00022688860190101, 0.00022023732890375, 0.000213598686968908, 0.000207067438168451, 0.000200599344680086, 0.000194188090972602, 0.000187903176993132, 0.000181668787263334, 0.000175491266418248, 0.000169338993146084, 0.000163338321726769, 0.000157350266817957, 0.000151520158397034, 0.000145765807246789, 0.000140118878334761, 0.000134471905766986, 0.000128907093312591, 0.000123481222544797, 0.00011807429837063, 0.000112743175122887, 0.000107506799395196, 0.000102384117781185, 9.72677589743398e-05, 9.2284033598844e-05, 8.73508543008938e-05, 8.2468191976659e-05, 7.76676606619731e-05, 7.30692481738515e-05, 6.83697799104266e-05, 6.38029450783506e-05, 5.93308650422841e-05, 5.4978794651106e-05, 5.06393625983037e-05, 4.64641343569383e-05, 4.22952725784853e-05, 3.81769095838536e-05, 3.41343584295828e-05, 3.02623193420004e-05, 2.63776964857243e-05, 2.26193878916092e-05, 1.89305555977626e-05, 1.53364508150844e-05, 1.18118523459998e-05, 8.29355940368259e-06, 4.90160846311483e-06, 1.55385475864023e-06, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 0.000324775173794478, 1.22535993796191e-06, 4.63631295133382e-06, 8.00931866251631e-06, 1.14960539576714e-05, 1.49890956890886e-05, 1.85452518053353e-05, 2.22088328882819e-05, 2.60997603618307e-05, 2.98833783745067e-05, 3.37869751092512e-05, 3.77663527615368e-05, 4.18846866523381e-05, 4.60725532320794e-05, 5.03298397234175e-05, 5.45871844224166e-05, 5.89645060244948e-05, 6.34871466900222e-05, 6.79970617056824e-05, 7.26081489119679e-05, 7.7269745816011e-05, 8.20070636109449e-05, 8.6946616647765e-05, 9.19050362426788e-05, 9.68698150245473e-05, 0.000101897763670422, 0.000107039391878061, 0.000112231573439203, 0.000117556352051906, 0.000122982237371616, 0.000128408137243241, 0.000134010828332976, 0.000139632480568253, 0.000145342579344288, 0.000151128537254408, 0.000156927097123116, 0.000162832962814718, 0.000168890503118746, 0.000174966975464486, 0.000181125578819774, 0.00018726522102952, 0.000193581698113121, 0.000200018272153102, 0.000206549491849728, 0.000213049177546054, 0.000219611989450641, 0.000226332718739286, 0.000233066122746095, 0.000239957444136962, 0.000246873998548836, 0.000253847421845421, 0.000260972388787195, 0.000268122646957636, 0.000275418278761208, 0.000282682216493413, 0.000290059891995043, 0.000297500781016424, 0.000305105786537752, 0.00031271085026674, 0.000320398074109107, 0.000328129419358447, 0.0003359176334925, 0.000343876396073028, 0.000351911061443388, 0.000360034115146846, 0.000368176057236269, 0.000376387499272823, 0.000384655751986429, 0.000393126189010218, 0.000401565106585622, 0.000410079723224044, 0.000418733252445236, 0.000427456310717389, 0.000436255271779373, 0.00044509838335216, 0.000454010878456756, 0.000462936121039093, 0.000472019251901656, 0.000481260329252109, 0.000490463455207646, 0.000499742280226201, 0.000509116041939706, 0.000518603366799653, 0.00052816653624177, 0.000537824525963515, 0.000547501374967396, 0.00055724149569869, 0.000567145645618439, 0.000577056314796209, 0.000587023736443371, 0.000597117526922375, 0.00060720497276634, 0.000617513433098793, 0.000627885106950998, 0.000638269470073283, 0.000648660119622946, 0.000659214972984046, 0.000669832981657237, 0.000680615252349526, 0.00069129653275013, 0.000702141900546849, 0.000713119981810451, 0.000724085432011634, 0.000735221430659294, 0.00074637628858909, 0.000757581845391542, 0.000768900907132775, 0.000780340109486133, 0.000791785656474531, 0.000803338538389653, 0.000814948230981827, 0.000826589588541538, 0.000838470819871873, 0.000850326963700354, 0.000862239918205887, 0.00087421596981585, 0.000886255118530244, 0.000898401893209666, 0.000910617876797915, 0.000922991952393204, 0.000935365969780833, 0.000947872642427683, 0.000960423552896827, 0.000973043905105442, 0.000985721126198769, 0.000998518313281238, 0.00101142295170575, 0.00102433387655765, 0.00103732058778405, 0.0010504083475098, 0.00106349622365087, 0.00107672298327088, 0.00109009491279721, 0.00110357429366559, 0.00111696519888937, 0.00113048264756799, 0.0011441009119153, 0.00115778250619769, 0.00117162836249918, 0.0011854360345751, 0.00119940191507339, 0.00121342460624874, 0.00122752296738327, 0.00124166544992477, 0.00125592818949372, 0.00127020350191742, 0.00128454191144556, 0.00129909522365779, 0.00131364830303937, 0.00132827740162611, 0.00134290638379753, 0.00135769974440336, 0.00137256865855306, 0.00138758297543973, 0.00140255317091942, 0.00141759274993092, 0.0014327522367239, 0.00144801929127425, 0.00146333675365895, 0.00147873640526086, 0.00149423710536212, 0.00150978821329772, 0.00152542151045054, 0.00154115597251803, 0.00155689672101289, 0.00157270056661218, 0.0015886245528236, 0.00160460534971207, 0.00162080070003867, 0.00163690780755132, 0.0016531222499907, 0.00166944414377213, 0.00168587965890765, 0.00170239107683301, 0.00171889585908502, 0.00173552101477981, 0.0017522091511637, 0.00176905526313931, 0.00178586342372, 0.00180277903564274, 0.00181982724461704, 0.00183685659430921, 0.0018541133031249, 0.00187139504123479, 0.00188867084216326, 0.00190600333735347, 0.00192345562390983, 0.00194097147323191, 0.0019587017595768, 0.00197632471099496, 0.0019941374193877, 0.00201205094344914, 0.0020300152245909, 0.00204800465144217, 0.00206610118038952, 0.00208420446142554, 0.00210242113098502, 0.00212075165472925, 0.00213914504274726, 0.00215764623135328, 0.00217620399780571, 0.00219479342922568, 0.00221357261762023, 0.00223232619464397, 0.00225119362585247, 0.00227011158131063, 0.00228914944455028, 0.0023081935942173, 0.00232735159806907, 0.0023466229904443, 0.00236590136773884, 0.00238535599783063, 0.00240479805506766, 0.00242441729642451, 0.00244405516423285, 0.00246368674561381, 0.00248348899185658, 0.00250334828160703, 0.00252328300848603, 0.00254331878386438, 0.00256340531632304, 0.00258357403799891, 0.00260379957035184, 0.00262412591837347, 0.0026445786934346, 0.00266502518206835, 0.00268559181131423, 0.00270617101341486, 0.00272692064754665, 0.00274767028167844, 0.00276858429424465, 0.00278950436040759, 0.00281050056219101, 0.00283159129321575, 0.00285275164060295, 0.002874038182199, 0.0028953121509403, 0.00291670626029372, 0.00293815694749355, 0.00295974034816027, 0.00298136798664927, 0.00300310319289565, 0.00302486983127892, 0.00304672494530678, 0.00306869996711612, 0.00309070060029626, 0.00311279552988708, 0.00313500431366265, 0.00315722590312362, 0.00317952269688249, 0.00320191495120525, 0.00322436355054379, 0.00324695161543787, 0.0032695836853236, 0.00329231680370867, 0.00331513164564967, 0.00333794089965522, 0.00336086959578097, 0.00338391214609146, 0.00340696750208735, 0.00343012996017933, 0.00345345679670572, 0.00347678363323212, 0.00350019265897572, 0.00352359539829195, 0.00354716856963933, 0.00357076060026884, 0.00359449768438935, 0.00361835537478328, 0.00364216230809689, 0.00366610800847411, 0.0036900918930769, 0.00371418939903378, 0.00373841938562691, 0.0037626433186233, 0.00378697435371578, 0.00381138734519482, 0.00383583875373006, 0.00386035954579711, 0.00388503773137927, 0.00390974804759026, 0.00393455289304256, 0.0039593642577529, 0.00398440938442945, 0.00400934647768736, 0.00403444841504097, 0.00405962578952312, 0.00408484134823084, 0.0041101323440671, 0.00413563242182136, 0.00416110036894679, 0.00418662559241056, 0.00421230169013143, 0.00423794705420732, 0.00426381919533014, 0.0042896349914372, 0.00431556394323707, 0.00434162002056837, 0.00436766864731908, 0.00439388258382678, 0.00442010862752795, 0.00444646086543798, 0.00447285128757358, 0.00449936743825674, 0.00452595390379429, 0.00455253385007381, 0.00457922741770744, 0.00460605323314667, 0.00463286694139242, 0.00465990183874965, 0.00468683522194624, 0.0047140084207058, 0.0047411760315299, 0.00476834969595075, 0.0047957506030798, 0.00482309516519308, 0.00485061574727297, 0.00487818755209446, 0.00490582827478647, 0.00493348157033324, 0.00496134394779801, 0.00498917419463396, 0.00501710595563054, 0.00504519511014223, 0.00507325306534767, 0.0051014251075685, 0.0051296534948051, 0.00515800202265382, 0.00518636265769601, 0.00521482480689883, 0.00524345133453608, 0.00527208391577005, 0.0053007984533906, 0.00532960193231702, 0.00535842403769493, 0.00538737280294299, 0.00541641609743237, 0.00544552225619555, 0.00547470478340983, 0.00550393108278513, 0.00553327752277255, 0.00556267471984029, 0.0055921534076333, 0.00562168285250664, 0.00565136456862092, 0.00568107701838017, 0.00571083417162299, 0.00574071099981666, 0.00577070144936442, 0.00580070540308952, 0.00583080993965268, 0.00586098385974765, 0.00589127745479345, 0.00592156546190381, 0.00595196662470698, 0.00598243717104197, 0.00601302785798907, 0.00604361249133945, 0.00606919685378671, 0.00609006639569998, 0.00611154222860932, 0.00613296777009964, 0.00615469692274928, 0.00617682933807373, 0.00619891192764044, 0.00622129766270518, 0.00624403683468699, 0.00626687752082944, 0.0062899705953896, 0.00631336681544781, 0.00633681379258633, 0.00636066496372223, 0.00638471823185682, 0.00640897359699011, 0.00643322896212339, 0.00645788805559278, 0.00648285122588277, 0.00650806678459048, 0.00653358548879623, 0.00655895238742232, 0.00658477377146482, 0.00661094952374697, 0.00663727661594748, 0.0066638570278883, 0.00669053709134459, 0.00671736989170313, 0.00674460735172033, 0.00677209626883268, 0.00679978774860501, 0.00682758027687669, 0.00685557490214705, 0.00688397418707609, 0.00691247405484319, 0.00694132782518864, 0.00697018159553409, 0.00699938926845789, 0.00702889962121844, 0.00705866329371929, 0.00708862859755754, 0.00711864465847611, 0.00714896386489272, 0.00717958621680737, 0.00721046095713973, 0.00724153826013207, 0.00727276736870408, 0.00730419810861349, 0.00733603304252028, 0.00736786844208837, 0.00740015832707286, 0.0074325492605567, 0.0074650919996202, 0.00749793788418174, 0.00753108644858003, 0.00756448786705732, 0.00759778916835785, 0.00763179641216993, 0.00766550237312913, 0.00769996456801891, 0.00773432711139321, 0.0077689909376204, 0.00780375674366951, 0.00783892720937729, 0.00787440128624439, 0.00790997594594955, 0.00794575177133083, 0.00798163004219532, 0.00801791250705719, 0.00805449672043324, 0.00809128396213055, 0.00812817271798849, 0.00816516298800707, 0.00820255652070045, 0.00824025273323059, 0.00827820226550102, 0.00831610057502985, 0.0083545558154583, 0.00839295983314514, 0.00843186955899, 0.00847077928483486, 0.00850999262183905, 0.00854925625026226, 0.00858892314136028, 0.00862894486635923, 0.00866906810551882, 0.00870949309319258, 0.00874981749802828, 0.00879059638828039, 0.00883167888969183, 0.00887301377952099, 0.00891460198909044, 0.00895629078149796, 0.00899797957390547, 0.009040174074471, 0.00908262096345425, 0.00912516936659813, 0.00916812103241682, 0.00921107362955809, 0.00925442948937416, 0.00929778628051281, 0.0093416478484869, 0.00938561093062162, 0.00942967459559441, 0.00947414338588715, 0.00951886363327503, 0.00956378597766161, 0.00960871018469334, 0.00965413730591536, 0.00969956628978252, 0.0097454497590661, 0.0097915343940258, 0.00983777083456516, 0.00988405849784613, 0.00993075035512447, 0.00997779425233603, 0.0100248409435153, 0.0100722396746278, 0.0101196384057403, 0.0101675428450108, 0.0102155981585383, 0.0102639580145478, 0.0103125190362334, 0.0103610809892416, 0.0104099959135056, 0.0104593653231859, 0.0105087356641889, 0.0105583574622869, 0.0106082325801253, 0.0106582092121243, 0.0107086393982172, 0.0107591217383742, 0.0108099058270454, 0.0108607411384583, 0.0109120812267065, 0.0109634213149548, 0.011015267111361, 0.0110671641305089, 0.0111192120239139, 0.0111714107915759, 0.0112241674214602, 0.0112770237028599, 0.0113300820812583, 0.0113832419738173, 0.0114366039633751, 0.0114903692156076, 0.0115444390103221, 0.0115986093878746, 0.0116530824452639, 0.011707404628396, 0.0117623833939433, 0.0118174124509096, 0.0118727954104543, 0.0119281783699989, 0.0119840670377016, 0.0120399557054043, 0.0120962485671043, 0.0121526420116425, 0.0122093390673399, 0.012266187928617, 0.0123232370242476, 0.0123806418851018, 0.0124381985515356, 0.0124959563836455, 0.0125539675354958, 0.0126121798530221, 0.0126706957817078, 0.0127294147387147, 0.0127883348613977, 0.0128475073724985, 0.0129068326205015, 0.0129664605483413, 0.0130263408645988, 0.0130864223465323, 0.0131467068567872, 0.0132072446867824, 0.0132679836824536, 0.0133288251236081, 0.0133900688961148, 0.0134514151141047, 0.013513064943254, 0.013575118035078, 0.013637070544064, 0.0136994272470474, 0.0137619851157069, 0.0138247450813651, 0.0138877080753446, 0.013951126486063, 0.0140144936740398, 0.0140782138332725, 0.0141419861465693, 0.0142061617225409, 0.0142705887556076, 0.0143351182341576, 0.0144000016152859, 0.0144650368019938, 0.0145302228629589, 0.0145958140492439, 0.0146616566926241, 0.0147274490445852, 0.0147935450077057, 0.0148601969704032, 0.014926697127521, 0.0149934496730566, 0.0150607582181692, 0.0151278143748641, 0.015195376239717, 0.0152632901445031, 0.0153312059119344, 0.0153994243592024, 0.0154679454863071, 0.0155365681275725, 0.0156055428087711, 0.0156746208667755, 0.015743900090456, 0.015813585370779, 0.0158833190798759, 0.0159533564001322, 0.0160236954689026, 0.0160941872745752, 0.0161646790802479, 0.0162358302623034, 0.0163068789988756, 0.016378328204155, 0.0164499320089817, 0.0165218412876129, 0.0165936965495348, 0.0166662614792585, 0.0167387239634991, 0.0168113894760609, 0.0168845076113939, 0.0169576276093721, 0.0170312039554119, 0.0171047784388065, 0.0171785540878773, 0.0172528885304928, 0.0173270683735609, 0.0174015518277884, 0.0174764916300774, 0.0175515301525593, 0.0176265724003315, 0.0177021659910679, 0.0177778135985136, 0.0178539138287306, 0.0179300662130117, 0.0180063713341951, 0.0180829763412476, 0.0181596837937832, 0.0182366967201233, 0.0183142609894276, 0.0183916259557009, 0.0184693429619074, 0.0185473654419184, 0.0186254866421223, 0.0187039114534855, 0.0187826417386532, 0.018861573189497, 0.0189406052231789, 0.0190199911594391, 0.0190995801240206, 0.0191792175173759, 0.0192592609673738, 0.0193394534289837, 0.0194201543927193, 0.0195007529109716, 0.0195816531777382, 0.0196627583354712, 0.0197440646588802, 0.0198255218565464, 0.0199075844138861, 0.0199895463883877, 0.0200717132538557, 0.0201543848961592, 0.0202370025217533, 0.02032002620399, 0.0204031523317099, 0.020486680790782, 0.0205701589584351, 0.0206541437655687, 0.0207382813096046, 0.0208224672824144, 0.0209071077406406, 0.020991750061512, 0.0210768971592188, 0.0211621429771185, 0.0212474912405014, 0.0213332958519459, 0.0214191488921642, 0.0215051025152206, 0.021591717377305, 0.0216782279312611, 0.0217649396508932, 0.0218520574271679, 0.0219392236322165, 0.0220267456024885, 0.0221145190298557, 0.0222024470567703, 0.0222904719412327, 0.0223790071904659, 0.0224674865603447, 0.0225564744323492, 0.0226454585790634, 0.0227347500622272, 0.0228242930024862, 0.0229141376912594, 0.0230040345340967, 0.0230943858623505, 0.0231847874820232, 0.0232752915471792, 0.0233663488179445, 0.023457357659936, 0.0235487706959248, 0.0236403830349445, 0.0237320996820927, 0.023824118077755, 0.0239164922386408, 0.0240088645368814, 0.0241014380007982, 0.0241945199668407, 0.0242875963449478, 0.0243810322135687, 0.0244746673852205, 0.0245684552937746, 0.0246624443680048, 0.0247567873448133, 0.0248513836413622, 0.0249462332576513, 0.0250410288572311, 0.0251362342387438, 0.0252317376434803, 0.0253272950649261, 0.025423152372241, 0.0255192648619413, 0.025615680962801, 0.0257120952010155, 0.0258090160787106, 0.0259060356765985, 0.0260032620280981, 0.0261006858199835, 0.0261984169483185, 0.0262963958084583, 0.0263943783938885, 0.0264928136020899, 0.0265914518386126, 0.0266901943832636, 0.0267892349511385, 0.0268886815756559, 0.0269881282001734, 0.0270877797156572, 0.0271877832710743, 0.0272878855466843, 0.0273883957415819, 0.0274890549480915, 0.0275898650288582, 0.0276908278465271, 0.0277922973036766, 0.0278938636183739, 0.0279956869781017, 0.0280975084751844, 0.0281996838748455, 0.0283023659139872, 0.0284050479531288, 0.0285078287124634, 0.0286110136657953, 0.0287142507731915, 0.028817892074585, 0.0289218388497829, 0.0290257818996906, 0.0291299782693386, 0.0292345285415649, 0.0293391812592745, 0.0294441878795624, 0.0295493938028812, 0.0296547040343285, 0.0297603141516447, 0.0298662297427654, 0.0299722962081432, 0.0300785675644875, 0.0301851890981197, 0.0302919093519449, 0.0303989369422197, 0.0305061675608158, 0.0306134968996048, 0.0307212341576815, 0.0308290664106607, 0.0309371557086706, 0.0310456492006779, 0.0311541892588139, 0.0312629342079163, 0.0313720814883709, 0.0314811319112778, 0.0315906330943108, 0.0317004397511482, 0.0318102464079857, 0.0319204069674015, 0.0320309214293957, 0.0321414805948734, 0.0322523526847363, 0.0323634184896946, 0.0324745923280716, 0.0325861647725105, 0.0326979458332062, 0.0328100249171257, 0.0329221002757549, 0.0330344848334789, 0.0331471748650074, 0.0332600586116314, 0.0333732031285763, 0.0334865413606167, 0.033600140362978, 0.0337139368057251, 0.0338278859853745, 0.0339421406388283, 0.0340564958751202, 0.0341711565852165, 0.0342861637473106, 0.0344013758003712, 0.0345167405903339, 0.0346324108541012, 0.0347481779754162, 0.0348641499876976, 0.034980371594429, 0.0350970961153507, 0.0352137312293053, 0.0353306569159031, 0.035447895526886, 0.0355652272701263, 0.0356829203665257, 0.0358007065951824, 0.0359189547598362, 0.0360371991991997, 0.0361556448042393, 0.0362744964659214, 0.0363934487104416, 0.0365128070116043, 0.0366321615874767, 0.0367519222199917, 0.0368718840181828, 0.0369919501245022, 0.0371122658252716, 0.0372328907251358, 0.0373535566031933, 0.0374747291207314, 0.0375960096716881, 0.0377175398170948, 0.0378391705453396, 0.0379611514508724, 0.038083340972662, 0.0382057055830956, 0.0383284464478493, 0.0384512133896351, 0.0385742820799351, 0.0386976078152657, 0.0388211309909821, 0.038944911211729, 0.039068941026926, 0.0391930490732193, 0.0393176078796387, 0.0394422486424446, 0.0395670607686043, 0.0396922267973423, 0.0398174710571766, 0.0399432219564915, 0.0400689691305161, 0.0401951000094414, 0.0403212234377861, 0.0404478088021278, 0.0405744649469852, 0.0407014042139053, 0.0408285930752754, 0.0409558825194836, 0.0410835221409798, 0.0412114001810551, 0.0413394682109356, 0.041467797011137, 0.0415962003171444, 0.0417249798774719, 0.0418540611863136, 0.0419832728803158, 0.0421126373112202, 0.0422422736883163, 0.0423720665276051, 0.0425021611154079, 0.0426325835287571, 0.0427631586790085, 0.0428939126431942, 0.0430249646306038, 0.0431561693549156, 0.0432876572012901, 0.0434193946421146, 0.0435512326657772, 0.0436833463609219, 0.0438159219920635, 0.0439484380185604, 0.0440812110900879, 0.0442143641412258, 0.0443475656211376, 0.0444810725748539, 0.0446148812770844, 0.0447488129138947, 0.044886976480484, 0.0450293719768524, 0.0451717749238014, 0.0453149788081646, 0.0454582907259464, 0.0456019006669521, 0.0457461215555668, 0.0458905398845673, 0.0460355691611767, 0.0461809001863003, 0.0463266335427761, 0.0464725717902184, 0.0466189086437225, 0.0467659570276737, 0.0469129048287868, 0.0470608621835709, 0.0472087226808071, 0.0473572835326195, 0.0475058443844318, 0.0476552173495293, 0.0478046908974648, 0.047954473644495, 0.0481049530208111, 0.0482555404305458, 0.0484067313373089, 0.0485580265522003, 0.0487101264297962, 0.0488622300326824, 0.049014937132597, 0.0491678453981876, 0.0493213571608067, 0.0494750812649727, 0.0496292039752007, 0.0497837327420712, 0.0499386601150036, 0.0500940978527069, 0.0502496361732483, 0.0504058785736561, 0.0505623258650303, 0.050719078630209, 0.0508765354752541, 0.0510339923202991, 0.0511919558048248, 0.0513503216207027, 0.0515093989670277, 0.0516683720052242, 0.0518280528485775, 0.0519878342747688, 0.0521481223404408, 0.052308913320303, 0.0524700134992599, 0.0526316165924072, 0.0527934171259403, 0.052955623716116, 0.0531183369457722, 0.0532812550663948, 0.0534447729587555, 0.0536083951592445, 0.0537727251648903, 0.0539371594786644, 0.054102499037981, 0.0542675368487835, 0.0544333793222904, 0.0545994304120541, 0.0547658838331699, 0.054932739585638, 0.0551000013947487, 0.0552676655352116, 0.0554357320070267, 0.0556042082607746, 0.0557729862630367, 0.0559421665966511, 0.0561117492616177, 0.056281540542841, 0.0564521327614784, 0.0566227324306965, 0.0567939355969429, 0.0569653362035751, 0.0571374520659447, 0.0573095604777336, 0.0574822835624218, 0.0576553009450436, 0.057828526943922, 0.058002658188343, 0.0581765882670879, 0.0583513304591179, 0.0585262700915337, 0.0587015151977539, 0.0588773675262928, 0.0590534210205078, 0.0592299811542034, 0.0594069436192513, 0.0595842115581036, 0.0597618855535984, 0.0599400587379932, 0.0601183325052261, 0.060297217220068, 0.0604765042662621, 0.0606558956205845, 0.060835987329483, 0.0610163919627666, 0.0611970946192741, 0.0613781958818436, 0.0615597032010555, 0.0617416240274906, 0.0619238428771496, 0.0621066614985466, 0.0622895956039429, 0.0624731220304966, 0.0626570656895638, 0.0628413036465645, 0.0630257427692413, 0.0632108896970749, 0.0633962452411652, 0.063581794500351, 0.0637681633234024, 0.0639545246958733, 0.0641415864229202, 0.0643287599086761, 0.0645165368914604, 0.0647046193480492, 0.0648932009935379, 0.065081886947155, 0.0652710869908333, 0.0654606744647026, 0.0656507760286331, 0.0658411905169487, 0.0660317912697792, 0.0662232041358948, 0.0664146244525909, 0.0666064396500587, 0.0667988732457161, 0.0669914931058884, 0.0671846270561218, 0.0673779621720314, 0.0675720050930977, 0.067766048014164, 0.0679609030485153, 0.0681559592485428, 0.0683514103293419, 0.0685470700263977, 0.0687431395053864, 0.0689400136470795, 0.0691365823149681, 0.0693339630961418, 0.0695317462086678, 0.0697298273444176, 0.0699282139539719, 0.0701271072030067, 0.0703264102339745, 0.0705260038375854, 0.0707260146737099, 0.0709263235330582, 0.0711272358894348, 0.0713284537196159, 0.0715300813317299, 0.0717318952083588, 0.0719342306256294, 0.0721369683742523, 0.0723398998379707, 0.0725436508655548, 0.0727472901344299, 0.0729517415165901, 0.0731562972068787, 0.0733611509203911, 0.0735667198896408, 0.0737723782658577, 0.0739787593483925, 0.0741854384541512, 0.0743922144174576, 0.0745995938777924, 0.0748074799776077, 0.075015477836132, 0.0752237588167191, 0.0754327699542046, 0.075641967356205, 0.075851783156395, 0.0760617852210999, 0.0762722045183182, 0.076482929289341, 0.0766940489411354, 0.0769057720899582, 0.0771176069974899, 0.07733004540205, 0.077542781829834, 0.0777560323476791, 0.0779694765806198, 0.0781833305954933, 0.0783975794911385, 0.0786122381687164, 0.0788272991776466, 0.0790426656603813, 0.0792587473988533, 0.0794746205210686, 0.0796914026141167, 0.0799082890152931, 0.080125667154789, 0.0803434699773788, 0.0805613547563553, 0.080780066549778, 0.0809989646077156, 0.0812183767557144, 0.0814378932118416, 0.0816582068800926, 0.0818784311413765, 0.0820994079113007, 0.082320474088192, 0.0825421139597893, 0.0827641487121582, 0.0829864889383316, 0.083209291100502, 0.0834323912858963, 0.0836560502648354, 0.0838797017931938, 0.0841040089726448, 0.0843288227915764, 0.0845537409186363, 0.084779366850853, 0.085005097091198, 0.0852314829826355, 0.0854579582810402, 0.0856849998235703, 0.085912398993969, 0.0861400440335274, 0.0863682478666306, 0.0865967497229576, 0.0868257582187653, 0.087054930627346, 0.0872847959399223, 0.087514765560627, 0.0877452418208122, 0.0879761278629303, 0.0882071033120155, 0.0884388461709023, 0.0886708423495293, 0.0889033824205399, 0.089135929942131, 0.0893693938851357, 0.0896027535200119, 0.0898367688059807, 0.0900710225105286, 0.0903056487441063, 0.0905408263206482, 0.0907763093709946, 0.0910121351480484, 0.0912484228610992, 0.0914850607514381, 0.0917220190167427, 0.0919595658779144, 0.0921972095966339, 0.0924352183938026, 0.0926739871501923, 0.0929128080606461, 0.0931522250175476, 0.0933918505907059, 0.0936319753527641, 0.0938723534345627, 0.0941131860017776, 0.0943546295166016, 0.094596266746521, 0.0948382169008255, 0.0950806140899658, 0.0953236818313599, 0.0955666899681091, 0.0958102568984032, 0.0960541218519211, 0.0962984412908554, 0.0965431705117226, 0.0967882052063942, 0.0970338359475136, 0.0972795709967613, 0.0975260138511658, 0.0977725088596344, 0.0980193540453911, 0.0982670709490776, 0.0985146760940552, 0.0987630411982536, 0.0990115031599998, 0.0992606729269028, 0.0995097011327744, 0.0997596830129623, 0.10000966489315, 0.100260153412819, 0.10051104426384, 0.100762285292149, 0.101014085114002, 0.101266093552113, 0.101518496870995, 0.101771309971809, 0.102024376392365, 0.102278098464012, 0.102531872689724, 0.10278644412756, 0.103040918707848, 0.10329631716013, 0.103551656007767, 0.103807657957077, 0.104063950479031, 0.104320555925369, 0.104577496647835, 0.104835018515587, 0.105092935264111, 0.105351097881794, 0.105609729886055, 0.105868645012379, 0.106127932667732, 0.106387764215469, 0.106647752225399, 0.10690850019455, 0.107169337570667, 0.107430592179298, 0.107692256569862, 0.107954360544682, 0.108216717839241, 0.108479738235474, 0.108742758631706, 0.109006434679031, 0.109270468354225, 0.10953464359045, 0.109799586236477, 0.110064618289471, 0.110330268740654, 0.110596127808094, 0.110862426459789, 0.111129134893417, 0.111396238207817, 0.111663706600666, 0.111931376159191, 0.112199805676937, 0.112468272447586, 0.112737312912941, 0.113006703555584, 0.113276287913322, 0.113546743988991, 0.113817036151886, 0.11408818513155, 0.114359393715858, 0.114631198346615, 0.11490311473608, 0.115175738930702, 0.115448407828808, 0.11572153121233, 0.115995369851589, 0.116269245743752, 0.116543635725975, 0.116818524897099, 0.117093674838543, 0.117369174957275, 0.117644980549812, 0.117921441793442, 0.118197999894619, 0.118475273251534, 0.118752643465996, 0.119030512869358, 0.119308695197105, 0.119587533175945, 0.119866475462914, 0.120145916938782, 0.120425656437874, 0.120705805718899, 0.120986461639404, 0.121267266571522, 0.121548689901829, 0.121830351650715, 0.122112318873405, 0.12239483743906, 0.1226776689291, 0.122961051762104, 0.123244687914848, 0.123528659343719, 0.123812921345234, 0.12409795820713, 0.124382972717285, 0.124668627977371, 0.124954544007778, 0.125240847468376, 0.125527769327164, 0.125814691185951, 0.126102283596992, 0.126390144228935, 0.126678287982941, 0.126966923475266, 0.127256065607071, 0.127545461058617, 0.127835169434547, 0.128125488758087, 0.12841609120369, 0.128707095980644, 0.128998413681984, 0.129290178418159, 0.129582151770592, 0.129874691367149, 0.13016751408577, 0.13046070933342, 0.130754590034485, 0.131048545241356, 0.131342947483063, 0.131637752056122, 0.131932854652405, 0.132228553295135, 0.132524490356445, 0.132820799946785, 0.133117631077766, 0.1334148645401, 0.133712187409401, 0.134010136127472, 0.134308457374573, 0.134607046842575, 0.134906098246574, 0.135205551981926, 0.135505422949791, 0.135805577039719, 0.136106103658676, 0.136407166719437, 0.136708632111549, 0.137010306119919, 0.137312442064285, 0.137614876031876, 0.137917771935463, 0.138221174478531, 0.138524755835533, 0.138828694820404, 0.139133363962173, 0.139438182115555, 0.139743328094482, 0.140049055218697, 0.140355080366135, 0.140661343932152, 0.140968039631844, 0.141275152564049, 0.141582906246185, 0.141890689730644, 0.142198994755745, 0.142507687211037, 0.142816796898842, 0.143126145005226, 0.143435969948769, 0.143746182322502, 0.144056901335716, 0.144367828965187, 0.144679203629494, 0.144991040229797, 0.145303264260292, 0.145615711808205, 0.145928591489792, 0.146242052316666, 0.146555662155151, 0.146869674324989, 0.147184163331985, 0.147499144077301, 0.147814348340034, 0.148129969835281, 0.148445919156075, 0.148762345314026, 0.149079114198685, 0.14939621090889, 0.149713814258575, 0.150031760334969, 0.15035006403923, 0.1506687104702, 0.150987878441811, 0.151307284832001, 0.151627138257027, 0.151947379112244, 0.152267947793007, 0.152589112520218, 0.152910500764847, 0.153232201933861, 0.153554543852806, 0.153876930475235, 0.154199987649918, 0.154523238539696, 0.154846891760826, 0.155171155929565, 0.15549547970295, 0.155820339918137, 0.156145721673965, 0.15647129714489, 0.156797289848328, 0.157123729586601, 0.157450571656227, 0.157777711749077, 0.158105313777924, 0.158433213829994, 0.158761560916901, 0.159090369939804, 0.159419342875481, 0.159748867154121, 0.160078778862953, 0.160409048199654, 0.160739541053772, 0.161070764064789, 0.161402121186256, 0.161734059453011, 0.162066102027893, 0.162398651242256, 0.162731662392616, 0.163065031170845, 0.163398623466492, 0.163732945919037, 0.164079397916794, 0.16443757712841, 0.164796143770218, 0.165155127644539, 0.165514409542084, 0.165874391794205, 0.166234701871872, 0.166595295071602, 0.16695648431778, 0.167317792773247, 0.167680010199547, 0.168042123317719, 0.168405026197433, 0.168768063187599, 0.169131800532341, 0.169495925307274, 0.169860363006592, 0.170225203037262, 0.17059063911438, 0.170956298708916, 0.171322345733643, 0.171688795089722, 0.172055870294571, 0.172423541545868, 0.172791317105293, 0.173159390687943, 0.173528283834457, 0.17389714717865, 0.17426685988903, 0.174636647105217, 0.175006955862045, 0.17537784576416, 0.175749152898788, 0.176120549440384, 0.176492676138878, 0.176865100860596, 0.177238017320633, 0.177611276507378, 0.177984893321991, 0.178359240293503, 0.178733661770821, 0.179108619689941, 0.179484084248543, 0.179859921336174, 0.180236086249352, 0.180612862110138, 0.180989935994148, 0.181367307901382, 0.181745380163193, 0.182123571634293, 0.182502448558807, 0.182881534099579, 0.183261036872864, 0.183641150593758, 0.184021547436714, 0.18440255522728, 0.184783771634102, 0.185165390372276, 0.185547724366188, 0.185930252075195, 0.186312973499298, 0.186696514487267, 0.187080249190331, 0.187464490532875, 0.187849134206772, 0.188234195113182, 0.188619747757912, 0.189005717635155, 0.189391881227493, 0.189778760075569, 0.190165832638741, 0.190553620457649, 0.190941393375397, 0.191329881548882, 0.191718772053719, 0.192108079791069, 0.192497685551643, 0.192887887358665, 0.193278402090073, 0.193669408559799, 0.194060638546944, 0.194452568888664, 0.194844797253609, 0.195237427949905, 0.195630460977554, 0.196023911237717, 0.19641774892807, 0.196812197566032, 0.197206854820251, 0.197602018713951, 0.197997689247131, 0.198393747210503, 0.19879013299942, 0.199186995625496, 0.199584186077118, 0.199981868267059, 0.200379863381386, 0.20077845454216, 0.201177358627319, 0.201576665043831, 0.201976582407951, 0.202376782894135, 0.202777296304703, 0.203178539872169, 0.203579738736153, 0.203981786966324, 0.204384014010429, 0.204786658287048, 0.205189898610115, 0.205593541264534, 0.205997496843338, 0.206401869654655, 0.206806629896164, 0.207212090492249, 0.207617670297623, 0.208023741841316, 0.208430215716362, 0.208837196230888, 0.209244593977928, 0.209652379155159, 0.210060372948647, 0.210469186306, 0.210878282785416, 0.21128748357296, 0.211697518825531, 0.212107732892036, 0.212518662214279, 0.212929680943489, 0.213341221213341, 0.213753148913383, 0.214165598154068, 0.214578241109848, 0.214991688728333, 0.215405240654945, 0.215819299221039, 0.216233775019646, 0.216648936271667, 0.217064216732979, 0.217479884624481, 0.217896059155464, 0.218312859535217, 0.218729764223099, 0.21914704144001, 0.21956504881382, 0.21998342871666, 0.220401957631111, 0.220821171998978, 0.22124058008194, 0.221660703420639, 0.222081124782562, 0.222501844167709, 0.222922995686531, 0.223344832658768, 0.223766684532166, 0.224189326167107, 0.224612176418304, 0.225035548210144, 0.225459292531013, 0.225883364677429, 0.226308032870293, 0.226733103394508, 0.227158382534981, 0.227584451436996, 0.228010460734367, 0.22843724489212, 0.228864446282387, 0.229291945695877, 0.229719951748848, 0.230148464441299, 0.230577066540718, 0.231006294488907, 0.231435909867287, 0.23186594247818, 0.232296377420425, 0.232727393507957, 0.233158648014069, 0.233590602874756, 0.23402264714241, 0.234455212950706, 0.234888166189194, 0.235321521759033, 0.235755294561386, 0.236189767718315, 0.23662443459034, 0.237059623003006, 0.237495109438896, 0.237930998206139, 0.238367408514023, 0.23880410194397, 0.239241182804108, 0.239678904414177, 0.240117013454437, 0.240555629134178, 0.240994349122047, 0.241433665156364, 0.241873398423195, 0.242313548922539, 0.242754071950912, 0.243195131421089, 0.243636459112167, 0.244078427553177, 0.244520574808121, 0.244963243603706, 0.245406299829483, 0.24584986269474, 0.246293738484383, 0.246738091111183, 0.24718277156353, 0.247628182172775, 0.248073756694794, 0.24851967394352, 0.248966291546822, 0.249413073062897, 0.249860256910324, 0.250308126211166, 0.250756323337555, 0.251204609870911, 0.251653850078583, 0.252103090286255, 0.252553015947342, 0.253003180027008, 0.25345379114151, 0.25390487909317, 0.254356533288956, 0.254808276891708, 0.255260735750198, 0.255713403224945, 0.256166785955429, 0.256620228290558, 0.257074236869812, 0.257528752088547, 0.257983505725861, 0.258438795804977, 0.258894592523575, 0.259350806474686, 0.259807407855988, 0.260264217853546, 0.260721534490585, 0.261179476976395, 0.261637687683105, 0.262096226215363, 0.262555420398712, 0.263014853000641, 0.26347491145134, 0.263935148715973, 0.264396011829376, 0.264857053756714, 0.265318721532822, 0.265780597925186, 0.266243040561676, 0.266706019639969, 0.267169296741486, 0.267633020877838, 0.268097192049026, 0.268561571836472, 0.269026547670364, 0.269491881132126, 0.269957661628723, 0.270423948764801, 0.270890593528748, 0.271357595920563, 0.271825104951859, 0.272292971611023, 0.272761285305023, 0.273230016231537, 0.273699253797531, 0.274168908596039, 0.274638742208481, 0.275109231472015, 0.275580137968063, 0.276051431894302, 0.276522994041443, 0.276995062828064, 0.277467638254166, 0.277940690517426, 0.278413891792297, 0.278887689113617, 0.279361963272095, 0.279836565256119, 0.280311584472656, 0.280787110328674, 0.281262964010239, 0.281739383935928, 0.282216012477875, 0.282693117856979, 0.283170789480209, 0.283648788928986, 0.28412714600563, 0.284606009721756, 0.285085141658783, 0.285564988851547, 0.286044925451279, 0.28652548789978, 0.287006467580795, 0.287487715482712, 0.287969499826431, 0.288451761007309, 0.288934320211411, 0.28941735625267, 0.289900720119476, 0.290384590625763, 0.290869116783142, 0.291353732347488, 0.29183891415596, 0.2923244535923, 0.292810469865799, 0.293296664953232, 0.293783575296402, 0.294270843267441, 0.294758558273315, 0.295246601104736, 0.295735120773315, 0.296223998069763, 0.296713322401047, 0.297202974557877, 0.297693341970444, 0.298183917999268, 0.298675000667572, 0.299166470766068, 0.299658358097076, 0.300150543451309, 0.3006432056427, 0.301136404275894, 0.301629900932312, 0.3021240234375, 0.302618414163589, 0.303113132715225, 0.303608447313309, 0.304103940725327, 0.304600089788437, 0.305096596479416, 0.305593550205231, 0.306090891361237, 0.306588739156723, 0.307086735963821, 0.307585418224335, 0.308084458112717, 0.308583825826645, 0.309083670377731, 0.309583932161331, 0.310084700584412, 0.310585677623749, 0.311087191104889, 0.311589360237122, 0.312091529369354, 0.312594413757324, 0.31309762597084, 0.313601225614548, 0.314105331897736, 0.314609885215759, 0.315114676952362, 0.315620094537735, 0.316125810146332, 0.316631823778152, 0.317138582468033, 0.317645400762558, 0.318152964115143, 0.318660795688629, 0.319169044494629, 0.319677829742432, 0.320186972618103, 0.320696353912354, 0.321206301450729, 0.321716576814651, 0.322227567434311, 0.322738647460938, 0.323250204324722, 0.32376229763031, 0.324274927377701, 0.324787706136703, 0.325300991535187, 0.325814634561539, 0.32632902264595, 0.326843351125717, 0.327358365058899, 0.327873885631561, 0.32838961482048, 0.32890585064888, 0.32942271232605, 0.329939633607864, 0.330457180738449, 0.330975145101547, 0.331493496894836, 0.332012385129929, 0.332531422376633, 0.33305099606514, 0.333571165800095, 0.334091544151306, 0.334612429141998, 0.335133731365204, 0.335655450820923, 0.336177706718445, 0.336700111627579, 0.33722311258316, 0.337746649980545, 0.338270366191864, 0.338794589042664, 0.339319199323654, 0.339844405651093, 0.3403699696064, 0.340895771980286, 0.341422230005264, 0.341948986053467, 0.34247612953186, 0.343003779649734, 0.343531757593155, 0.344060212373734, 0.344589054584503, 0.345118343830109, 0.345648109912872, 0.346178233623505, 0.346708804368973, 0.347239792346954, 0.34777107834816, 0.348302990198135, 0.348835051059723, 0.349367648363113, 0.349900901317596, 0.350434303283691, 0.350968360900879, 0.351502656936646, 0.352037310600281, 0.352572411298752, 0.353108048439026, 0.353644102811813, 0.354180544614792, 0.354717284440994, 0.355254769325256, 0.355792433023453, 0.356330454349518, 0.356869071722031, 0.35740801692009, 0.357947289943695, 0.358487188816071, 0.35902738571167, 0.359568178653717, 0.360109180212021, 0.360650539398193, 0.361192494630814, 0.36173477768898, 0.36227747797966, 0.362820714712143, 0.363364309072495, 0.363908380270004, 0.364452689886093, 0.364997625350952, 0.365542858839035, 0.366088598966599, 0.366634458303452, 0.367181241512299, 0.36772808432579, 0.368275552988052, 0.368823319673538, 0.369371563196182, 0.369920134544373, 0.370469152927399, 0.371018528938293, 0.371568530797958, 0.372118800878525, 0.372669488191605, 0.373220682144165, 0.373772293329239, 0.374324202537537, 0.374876767396927, 0.375429451465607, 0.375982582569122, 0.376536518335342, 0.377090454101562, 0.377645075321198, 0.378200024366379, 0.378755390644073, 0.379311114549637, 0.379867166280746, 0.380423814058304, 0.380980968475342, 0.381538361310959, 0.382096350193024, 0.38265460729599, 0.38321328163147, 0.383772432804108, 0.384331971406937, 0.384891867637634, 0.385452389717102, 0.386013239622116, 0.386574506759644, 0.387136191129684, 0.387698262929916, 0.388260692358017, 0.388823688030243, 0.389386892318726, 0.389950752258301, 0.3905149102211, 0.391079485416412, 0.391644507646561, 0.392210006713867, 0.392775893211365, 0.393342137336731, 0.393908798694611, 0.394475877285004, 0.395043551921844, 0.395630747079849, 0.396238595247269, 0.396846532821655, 0.397454738616943, 0.398063093423843, 0.398671686649323, 0.399280518293381, 0.399889558553696, 0.400498658418655, 0.401108145713806, 0.401717752218246, 0.402327567338943, 0.40293762087822, 0.403547793626785, 0.404158234596252, 0.404769003391266, 0.405379623174667, 0.405990809202194, 0.406602025032043, 0.407213479280472, 0.407825082540512, 0.408437013626099, 0.409049034118652, 0.409661412239075, 0.410273849964142, 0.41088655591011, 0.411499291658401, 0.412112444639206, 0.412725687026978, 0.413339257240295, 0.413952887058258, 0.414566874504089, 0.41518098115921, 0.415795207023621, 0.416409730911255, 0.417024433612823, 0.417639374732971, 0.418254494667053, 0.418869823217392, 0.41948539018631, 0.420101195573807, 0.420716971158981, 0.421333283185959, 0.421949535608292, 0.422566086053848, 0.423182934522629, 0.423799842596054, 0.424416929483414, 0.425034523010254, 0.425651878118515, 0.426269799470901, 0.426887780427933, 0.427505940198898, 0.428124338388443, 0.428742945194244, 0.429361760616302, 0.429980784654617, 0.430599927902222, 0.431219398975372, 0.431839048862457, 0.432458907365799, 0.433078855276108, 0.433699160814285, 0.43431955575943, 0.434940248727798, 0.435561060905457, 0.436182081699371, 0.436803340911865, 0.437424778938293, 0.438046485185623, 0.43866840004921, 0.439290314912796, 0.439912796020508, 0.440535187721252, 0.441157877445221, 0.441780775785446, 0.442403882741928, 0.4430271089077, 0.443650633096695, 0.444274336099625, 0.444898158311844, 0.445522427558899, 0.446146607398987, 0.446771293878555, 0.447396039962769, 0.448020845651627, 0.448645949363708, 0.449271380901337, 0.449896842241287, 0.450522691011429, 0.451148569583893, 0.451774746179581, 0.452401161193848, 0.453027755022049, 0.453654438257217, 0.454281389713287, 0.454908549785614, 0.455536037683487, 0.456163555383682, 0.456791430711746, 0.457419395446777, 0.458047538995743, 0.458675980567932, 0.459304630756378, 0.459933310747147, 0.460562437772751, 0.461191654205322, 0.46182107925415, 0.46245077252388, 0.463080525398254, 0.463710486888885, 0.464340895414352, 0.464971214532852, 0.465601921081543, 0.466232776641846, 0.466863840818405, 0.467495083808899, 0.468126565217972, 0.468758225440979, 0.469390034675598, 0.470022112131119, 0.470654428005219, 0.47128689289093, 0.471919596195221, 0.472552567720413, 0.47318559885025, 0.473818928003311, 0.474452435970306, 0.475086063146591, 0.475720047950745, 0.476354241371155, 0.476988434791565, 0.477623134851456, 0.478257834911346, 0.478892713785172, 0.47952789068222, 0.480163156986237, 0.480798691511154, 0.48143458366394, 0.482070505619049, 0.482706725597382, 0.483343034982681, 0.48397958278656, 0.484616309404373, 0.485253483057022, 0.485890448093414, 0.486527979373932, 0.487165570259094, 0.487803399562836, 0.488441318273544, 0.489079535007477, 0.489717990159988, 0.490356683731079, 0.490995436906815, 0.491634517908096, 0.492273658514023, 0.492913156747818, 0.493552774190903, 0.494192600250244, 0.49483260512352, 0.495472848415375, 0.496113270521164, 0.49675390124321, 0.497394889593124, 0.498035877943039, 0.498677223920822, 0.499318689107895, 0.49996030330658, 0.500602185726166, 0.501244306564331, 0.501886546611786, 0.502529144287109, 0.503171741962433, 0.503814697265625, 0.504457831382751, 0.505101084709167, 0.505744636058807, 0.506388366222382, 0.507032215595245, 0.507676482200623, 0.508320868015289, 0.508965313434601, 0.509610116481781, 0.510254979133606, 0.51090008020401, 0.511545479297638, 0.5121910572052, 0.512836873531342, 0.513482868671417, 0.514129042625427, 0.514775335788727, 0.515421986579895, 0.516068696975708, 0.516715824604034, 0.517362833023071, 0.518010318279266, 0.518657922744751, 0.51930570602417, 0.519953727722168, 0.520601868629456, 0.521250307559967, 0.521898984909058, 0.522547721862793, 0.523196816444397, 0.523846089839935, 0.524495422840118, 0.52514511346817, 0.525795042514801, 0.526445031166077, 0.527095258235931, 0.52774578332901, 0.528396427631378, 0.52904736995697, 0.529698312282562, 0.530349671840668, 0.531001150608063, 0.531652808189392, 0.532304704189301, 0.532956779003143, 0.533609092235565, 0.534261643886566, 0.534914433956146, 0.535567343235016, 0.536220371723175, 0.536873698234558, 0.537527203559875, 0.538181126117706, 0.538834869861603, 0.539489090442657, 0.540143370628357, 0.54079794883728, 0.541452705860138, 0.542107582092285, 0.542762756347656, 0.543418228626251, 0.544073700904846, 0.544729471206665, 0.545385479927063, 0.546041548252106, 0.546698153018951, 0.547354638576508, 0.548011422157288, 0.548668444156647, 0.54932564496994, 0.549982964992523, 0.55064070224762, 0.551298379898071, 0.551956474781036, 0.552614629268646, 0.55327308177948, 0.553931653499603, 0.55459052324295, 0.555249631404877, 0.555908918380737, 0.556568264961243, 0.557228028774261, 0.557887852191925, 0.558547914028168, 0.55920821428299, 0.559868693351746, 0.560529232025146, 0.561190247535706, 0.561851263046265, 0.562512636184692, 0.563174068927765, 0.563835799694061, 0.564497709274292, 0.565159857273102, 0.565822005271912, 0.566484570503235, 0.567147314548492, 0.567810237407684, 0.568473339080811, 0.569136738777161, 0.569800198078156, 0.570464015007019, 0.571127772331238, 0.57179206609726, 0.572456479072571, 0.573120772838593, 0.573785722255707, 0.574450612068176, 0.575115859508514, 0.575781166553497, 0.576446771621704, 0.5771124958992, 0.577778577804565, 0.578444600105286, 0.579111099243164, 0.579777598381042, 0.580444514751434, 0.581111431121826, 0.581778585910797, 0.582446038722992, 0.583113849163055, 0.583781480789185, 0.584449708461761, 0.585117876529694, 0.58578622341156, 0.586454927921295, 0.587123811244965, 0.587792754173279, 0.588462114334106, 0.589131593704224, 0.58980119228363, 0.590471088886261, 0.591141104698181, 0.59181135892868, 0.592481970787048, 0.593152463436127, 0.593823492527008, 0.594494581222534, 0.595165908336639, 0.595837295055389, 0.596509039402008, 0.597180962562561, 0.597853064537048, 0.59852534532547, 0.599197864532471, 0.599870622158051, 0.60054349899292, 0.601216673851013, 0.601889967918396, 0.602563560009003, 0.603237271308899, 0.603911221027374, 0.604585349559784, 0.605259776115417, 0.605934202671051, 0.606609106063843, 0.607284069061279, 0.607959270477295, 0.6086345911026, 0.609310150146484, 0.609986007213593, 0.610662043094635, 0.611338257789612, 0.612014591693878, 0.612691223621368, 0.613368034362793, 0.614045023918152, 0.61472225189209, 0.615399658679962, 0.616077303886414, 0.616755068302155, 0.617433190345764, 0.618111431598663, 0.618789851665497, 0.619468450546265, 0.620147407054901, 0.620826303958893, 0.621505618095398, 0.622185111045837, 0.622864842414856, 0.623544633388519, 0.624224781990051, 0.624904990196228, 0.625585615634918, 0.626266181468964, 0.626947045326233, 0.627628147602081, 0.628309369087219, 0.628990948200226, 0.629672706127167, 0.630354583263397, 0.631036698818207, 0.631718993186951, 0.632401525974274, 0.633084356784821, 0.633767127990723, 0.634450376033783, 0.635133683681488, 0.635817229747772, 0.636501014232635, 0.637185037136078, 0.637869119644165, 0.638553619384766, 0.639238119125366, 0.639922857284546, 0.64060777425766, 0.641293048858643, 0.641978442668915, 0.642664074897766, 0.643349766731262, 0.644035875797272, 0.644722044467926, 0.645408451557159, 0.646094977855682, 0.646781861782074, 0.647468864917755, 0.648156106472015, 0.648843467235565, 0.649531245231628, 0.650219082832336, 0.650907099246979, 0.651595294475555, 0.652283728122711, 0.652972340583801, 0.65366131067276, 0.654350280761719, 0.655039608478546, 0.655729115009308, 0.656418681144714, 0.657108664512634, 0.657798707485199, 0.658488988876343, 0.659179508686066, 0.659870147705078, 0.66056102514267, 0.661252200603485, 0.661943435668945, 0.662635028362274, 0.663326799869537, 0.66401869058609, 0.664710700511932, 0.665403068065643, 0.666095674037933, 0.666788399219513, 0.667481362819672, 0.668174505233765, 0.668867886066437, 0.669561445713043, 0.670255124568939, 0.670949220657349, 0.671643316745758, 0.672337710857391, 0.673032283782959, 0.673727095127106, 0.674422085285187, 0.675117254257202, 0.675812542438507, 0.67650830745697, 0.677203953266144, 0.677900016307831, 0.678596317768097, 0.679292678833008, 0.679989278316498, 0.680686116218567, 0.68138313293457, 0.682080388069153, 0.68277770280838, 0.683475375175476, 0.684173285961151, 0.684871256351471, 0.685569584369659, 0.686268091201782, 0.686966776847839, 0.687665522098541, 0.688364505767822, 0.689063906669617, 0.689763486385345, 0.690463006496429, 0.691163003444672, 0.691863119602203, 0.692563354969025, 0.693263828754425, 0.693964600563049, 0.694665491580963, 0.695366621017456, 0.696067929267883, 0.69676947593689, 0.69747120141983, 0.698173105716705, 0.698875188827515, 0.699577629566193, 0.700280070304871, 0.700982868671417, 0.701685905456543, 0.702389001846313, 0.703092396259308, 0.703795909881592, 0.704499661922455, 0.705203771591187, 0.705907821655273, 0.706612288951874, 0.707316935062408, 0.708021700382233, 0.708726584911346, 0.709431767463684, 0.710137188434601, 0.710842788219452, 0.711548566818237, 0.712254583835602, 0.712960839271545, 0.713667213916779, 0.71437394618988, 0.715080678462982, 0.715787827968597, 0.716494977474213, 0.717202425003052, 0.717910170555115, 0.718618035316467, 0.719325959682465, 0.72003436088562, 0.720742762088776, 0.721451461315155, 0.722160279750824, 0.722869515419006, 0.723578572273254, 0.724288105964661, 0.725006341934204, 0.725734293460846, 0.726461946964264, 0.727189302444458, 0.727916419506073, 0.728643357753754, 0.729370057582855, 0.730096459388733, 0.730822682380676, 0.731548607349396, 0.732274234294891, 0.732999682426453, 0.73372483253479, 0.734449863433838, 0.735174596309662, 0.735899031162262, 0.736623167991638, 0.73734724521637, 0.738070964813232, 0.738794505596161, 0.739517629146576, 0.740240633487701, 0.740963459014893, 0.741685926914215, 0.742408215999603, 0.743130147457123, 0.743852019309998, 0.744573473930359, 0.745294809341431, 0.746015846729279, 0.746736645698547, 0.747457146644592, 0.748177528381348, 0.748897612094879, 0.749617457389832, 0.750336945056915, 0.751056373119354, 0.751775443553925, 0.752494335174561, 0.753212928771973, 0.753931283950806, 0.75464940071106, 0.755367338657379, 0.75608491897583, 0.756802320480347, 0.757519423961639, 0.758236289024353, 0.758953034877777, 0.759669423103333, 0.760385513305664, 0.761101543903351, 0.761817157268524, 0.762532532215118, 0.763247728347778, 0.763962745666504, 0.764677345752716, 0.765391945838928, 0.766106069087982, 0.766820073127747, 0.767533838748932, 0.768247246742249, 0.768960535526276, 0.769673466682434, 0.770386219024658, 0.771098673343658, 0.771811008453369, 0.772522926330566, 0.773234844207764, 0.773946285247803, 0.774657607078552, 0.775368571281433, 0.776079416275024, 0.776789963245392, 0.77750027179718, 0.778210282325745, 0.778920114040375, 0.779629647731781, 0.780339121818542, 0.781048119068146, 0.781756997108459, 0.782465577125549, 0.78317391872406, 0.783882021903992, 0.784589886665344, 0.785297453403473, 0.786004900932312, 0.786711990833282, 0.787418961524963, 0.788125514984131, 0.788832008838654, 0.789538085460663, 0.790243983268738, 0.790949702262878, 0.79165506362915, 0.792360305786133, 0.793065309524536, 0.793769896030426, 0.794474363327026, 0.795178592205048, 0.79588258266449, 0.796586275100708, 0.797289669513702, 0.797992944717407, 0.798695862293243, 0.799398601055145, 0.800101041793823, 0.800803422927856, 0.801505386829376, 0.802207171916962, 0.802908658981323, 0.80360996723175, 0.804310917854309, 0.805011808872223, 0.805712282657623, 0.806412637233734, 0.807112634181976, 0.807812452316284, 0.808512032032013, 0.809211373329163, 0.809910476207733, 0.81060928106308, 0.811307847499847, 0.812006294727325, 0.812704265117645, 0.81340217590332, 0.814099788665771, 0.814797163009644, 0.815494298934937, 0.816191136837006, 0.81688779592514, 0.817584216594696, 0.818280279636383, 0.818976283073425, 0.819671869277954, 0.820367336273193, 0.821062445640564, 0.821757435798645, 0.822452008724213, 0.823146522045135, 0.823840737342834, 0.824534714221954, 0.82522839307785, 0.825921773910522, 0.82661497592926, 0.827307939529419, 0.828000724315643, 0.828693151473999, 0.829385459423065, 0.830077409744263, 0.830769240856171, 0.83146071434021, 0.832152009010315, 0.832842946052551, 0.833533823490143, 0.834224283695221, 0.83491462469101, 0.835604608058929, 0.83629447221756, 0.836984038352966, 0.837673306465149, 0.838362395763397, 0.839051246643066, 0.839739739894867, 0.840428173542023, 0.841116189956665, 0.841804087162018, 0.842491626739502, 0.843178987503052, 0.843866109848022, 0.844553112983704, 0.845239639282227, 0.84592604637146, 0.846612155437469, 0.847298085689545, 0.847983717918396, 0.848669111728668, 0.849354267120361, 0.85003924369812, 0.85072386264801, 0.851408302783966, 0.852092444896698, 0.852776408195496, 0.853460073471069, 0.854143500328064, 0.854826748371124, 0.855509698390961, 0.856192409992218, 0.856874883174896, 0.85755717754364, 0.858239114284515, 0.858920931816101, 0.859602391719818, 0.860283613204956, 0.860964715480804, 0.861645460128784, 0.86232590675354, 0.863006234169006, 0.863686203956604, 0.864366054534912, 0.865045547485352, 0.865724921226501, 0.866403996944427, 0.86708277463913, 0.867761373519897, 0.868439733982086, 0.869117796421051, 0.869795620441437, 0.870473146438599, 0.871150612831116, 0.871827661991119, 0.872504532337189, 0.873181104660034, 0.873857498168945, 0.874533593654633, 0.87520956993103, 0.875885188579559, 0.876560568809509, 0.877235651016235, 0.877910673618317, 0.878585278987885, 0.879259765148163, 0.879933834075928, 0.880607843399048, 0.881281554698944, 0.881954967975616, 0.88262814283371, 0.883301019668579, 0.883973836898804, 0.88464617729187, 0.885318517684937, 0.88599044084549, 0.886662244796753, 0.887333691120148, 0.888004958629608, 0.888675928115845, 0.889346778392792, 0.89001727104187, 0.890687465667725, 0.891357481479645, 0.892027318477631, 0.892696797847748, 0.893366158008575, 0.894035220146179, 0.894704043865204, 0.89537250995636, 0.896040916442871, 0.896708905696869, 0.897376835346222, 0.898044407367706, 0.898711740970612, 0.899378776550293, 0.900045692920685, 0.900712251663208, 0.901378691196442, 0.902044713497162, 0.902710616588593, 0.903376221656799, 0.904041647911072, 0.904706835746765, 0.905371785163879, 0.90603643655777, 0.906700849533081, 0.907364845275879, 0.908028781414032, 0.908692538738251, 0.909355938434601, 0.910019218921661, 0.910682141780853, 0.911344826221466, 0.912007212638855, 0.91266942024231, 0.91333144903183, 0.913993179798126, 0.914654672145844, 0.915315985679626, 0.915976881980896, 0.916637599468231, 0.917298138141632, 0.917958438396454, 0.918618440628052, 0.919278264045715, 0.919937670230865, 0.920597016811371, 0.921256065368652, 0.921914935112, 0.922573387622833, 0.923231780529022, 0.923889815807343, 0.924547612667084, 0.925205171108246, 0.925862550735474, 0.926519632339478, 0.927176535129547, 0.927833080291748, 0.928489446640015, 0.929145514965057, 0.929801464080811, 0.93045699596405, 0.931112408638, 0.931767523288727, 0.932422459125519, 0.933077096939087, 0.933731496334076, 0.934385657310486, 0.935039460659027, 0.935693264007568, 0.936346650123596, 0.93699985742569, 0.937652766704559, 0.938305497169495, 0.938957870006561, 0.939610183238983, 0.940262138843536, 0.94091385602951, 0.941565215587616, 0.942216455936432, 0.942867517471313, 0.943518280982971, 0.944168746471405, 0.94481897354126, 0.945468902587891, 0.946118772029877, 0.946768283843994, 0.947417616844177, 0.948066532611847, 0.948715388774872, 0.949363887310028, 0.950012266635895, 0.950660228729248, 0.951308071613312, 0.951955616474152, 0.952602982521057, 0.953250050544739, 0.953896939754486, 0.954543471336365, 0.955189883708954, 0.955835938453674, 0.956481754779816, 0.957127451896667, 0.957772850990295, 0.958417892456055, 0.959062874317169, 0.95970743894577, 0.960351824760437, 0.960996031761169, 0.961639761924744, 0.962283551692963, 0.962926924228668, 0.963570117950439, 0.964213013648987, 0.964855790138245, 0.965498208999634, 0.966140389442444, 0.966782331466675, 0.967424035072327, 0.968065500259399, 0.968706727027893, 0.969347715377808, 0.969988465309143, 0.97062885761261, 0.971269190311432, 0.97190922498703, 0.972548961639404, 0.973188459873199, 0.973827719688416, 0.974466741085052, 0.97510552406311, 0.975744128227234, 0.976382434368134, 0.97702032327652, 0.977658212184906, 0.978295743465424, 0.978933036327362, 0.979570209980011, 0.980206966400146, 0.980843544006348, 0.981479823589325, 0.982115983963013, 0.982751786708832, 0.983387351036072, 0.984022796154022, 0.984657883644104, 0.985292792320251, 0.985927522182465, 0.986561715602875, 0.987195909023285, 0.987829864025116, 0.988463461399078, 0.989096879959106, 0.9897301197052, 0.99036306142807, 0.990995645523071, 0.991628110408783, 0.992260456085205, 0.992892324924469, 0.993523955345154, 0.994155406951904, 0.994786560535431, 0.995417654514313, 0.996048390865326, 0.99667876958847, 0.997309029102325, 0.997939050197601, 0.998568773269653, 0.999198198318481, 0.999827563762665, 1.00045645236969, 1.00108528137207, 1.00171387195587, 1.0023421049118, 1.00297009944916, 1.00359785556793, 1.00422549247742, 1.00485289096832, 1.00547993183136, 1.00610673427582, 1.0067332983017, 1.007359623909, 1.00798571109772, 1.00861144065857, 1.00923717021942, 1.00986242294312, 1.01048743724823, 1.01111245155334, 1.01173710823059, 1.01236140727997, 1.01298570632935, 1.01360952854156, 1.01423311233521, 1.01485657691956, 1.01547968387604, 1.01610267162323, 1.01672530174255, 1.01734757423401, 1.01796996593475, 1.01859176158905, 1.01921355724335, 1.01983487606049, 1.02045619487762, 1.0210770368576, 1.0216977596283, 1.0223183631897, 1.02293848991394, 1.02355861663818, 1.02417814731598, 1.02479767799377, 1.0254168510437, 1.02603590488434, 1.0266547203064, 1.02727329730988, 1.02789163589478, 1.02850961685181, 1.02912724018097, 1.02974486351013, 1.03036212921143, 1.03097927570343, 1.03159606456757, 1.03221261501312, 1.0328289270401, 1.0334450006485, 1.03406071662903, 1.03467655181885, 1.03529179096222, 1.03590679168701, 1.0365217924118, 1.03713643550873, 1.03775072097778, 1.03836488723755, 1.03897869586945, 1.03959226608276, 1.04020571708679, 1.04081892967224, 1.04143190383911, 1.04204452037811, 1.04265689849854, 1.04326903820038, 1.04388093948364, 1.04449272155762, 1.04510414600372, 1.04571533203125, 1.04632616043091, 1.04693698883057, 1.04754734039307, 1.04815757274628, 1.04876756668091, 1.04937744140625, 1.04998672008514, 1.05059599876404, 1.05120503902435, 1.05181384086609, 1.05242216587067, 1.05303061008453, 1.05363857746124, 1.05424630641937, 1.05485391616821, 1.05546128749847, 1.05606818199158, 1.05667495727539, 1.05728149414062, 1.05788803100586, 1.05847728252411, 1.05904912948608, 1.05962014198303, 1.06019067764282, 1.06076049804688, 1.06132972240448, 1.06189835071564, 1.06246638298035, 1.06303369998932, 1.06360054016113, 1.06416642665863, 1.06473195552826, 1.06529664993286, 1.06586086750031, 1.0664244890213, 1.06698739528656, 1.06754982471466, 1.06811130046844, 1.06867241859436, 1.06923282146454, 1.06979250907898, 1.07035171985626, 1.07091009616852, 1.07146811485291, 1.07202529907227, 1.07258176803589, 1.07313776016235, 1.07369303703308, 1.07424783706665, 1.07480192184448, 1.07535529136658, 1.07590818405151, 1.07646024227142, 1.07701182365417, 1.07756280899048, 1.07811307907104, 1.07866275310516, 1.07921183109283, 1.07976019382477, 1.08030796051025, 1.08085501194, 1.08140158653259, 1.08194744586945, 1.08249270915985, 1.08303737640381, 1.08358132839203, 1.0841246843338, 1.08466732501984, 1.08520948886871, 1.08575081825256, 1.08629167079926, 1.08683180809021, 1.08737134933472, 1.08791029453278, 1.08844864368439, 1.08898627758026, 1.08952331542969, 1.09005975723267, 1.09059548377991, 1.0911306142807, 1.09166502952576, 1.09219884872437, 1.09273219108582, 1.09326481819153, 1.09379684925079, 1.09432816505432, 1.09485876560211, 1.09538888931274, 1.09591829776764, 1.0964469909668, 1.09697532653809, 1.09750282764435, 1.09802973270416, 1.09855628013611, 1.09908175468445, 1.09960675239563, 1.10013115406036, 1.10065495967865, 1.1011780500412, 1.1017005443573, 1.10222256183624, 1.10274374485016, 1.10326421260834, 1.10378420352936, 1.10430359840393, 1.10482227802277, 1.10534036159515, 1.10585796833038, 1.10637474060059, 1.10689079761505, 1.10740649700165, 1.10792136192322, 1.10843563079834, 1.10894930362701, 1.10946226119995, 1.10997474193573, 1.11048638820648, 1.11099755764008, 1.11150813102722, 1.11201810836792, 1.11252725124359, 1.11303579807281, 1.11354374885559, 1.11405110359192, 1.11455798149109, 1.11506402492523, 1.11556923389435, 1.11607420444489, 1.11657845973969, 1.11708188056946, 1.11758482456207, 1.11808717250824, 1.11858880519867, 1.11908984184265, 1.11959028244019, 1.12009000778198, 1.12058925628662, 1.12108767032623, 1.1215854883194, 1.1220828294754, 1.12257945537567, 1.12307524681091, 1.12357068061829, 1.12406551837921, 1.12455952167511, 1.12505304813385, 1.12554585933685, 1.12603795528412, 1.12652969360352, 1.12702035903931, 1.12751078605652, 1.12800049781799, 1.12848937511444, 1.12897789478302, 1.12946569919586, 1.12995278835297, 1.13043928146362, 1.13092517852783, 1.1314103603363, 1.13189494609833, 1.13237905502319, 1.13286232948303, 1.13334500789642, 1.13382720947266, 1.13430857658386, 1.13478934764862, 1.13526964187622, 1.13574910163879, 1.13622808456421, 1.13670635223389, 1.13718402385712, 1.13766098022461, 1.13813745975494, 1.13861334323883, 1.13908839225769, 1.13956296443939, 1.14003694057465, 1.14051020145416, 1.14098262786865, 1.14145469665527, 1.14192593097687, 1.1423966884613, 1.14286673069, 1.14333629608154, 1.14380514621735, 1.14427328109741, 1.14474070072174, 1.1452077627182, 1.14567399024963, 1.14613962173462, 1.14660477638245, 1.14706921577454, 1.14753305912018, 1.14799606800079, 1.14845860004425, 1.14892053604126, 1.14938175678253, 1.14984238147736, 1.15030229091644, 1.15076172351837, 1.15122032165527, 1.15167856216431, 1.15213596820831, 1.15259265899658, 1.15304911136627, 1.15350449085236, 1.15395939350128, 1.15441381931305, 1.15486741065979, 1.15532040596008, 1.15577280521393, 1.15622460842133, 1.15667569637299, 1.1571261882782, 1.15757620334625, 1.15802538394928, 1.15847396850586, 1.15892195701599, 1.15936934947968, 1.15981602668762, 1.16026222705841, 1.16070759296417, 1.16115248203278, 1.16159665584564, 1.16204023361206, 1.16248321533203, 1.16292548179626, 1.16336715221405, 1.1638081073761, 1.16424858570099, 1.16468834877014, 1.16512739658356, 1.1655660867691, 1.16600406169891, 1.1664412021637, 1.16687786579132, 1.16731369495392, 1.16774904727936, 1.16818380355835, 1.16861796379089, 1.16905128955841, 1.16948425769806, 1.16991639137268, 1.17034804821014, 1.17077887058258, 1.17120921611786, 1.1716388463974, 1.17206788063049, 1.17249619960785, 1.17292404174805, 1.1733512878418, 1.17377781867981, 1.17420375347137, 1.17462885379791, 1.17505347728729, 1.17547750473022, 1.17590081691742, 1.17632353305817, 1.17674577236176, 1.17716705799103, 1.17758798599243, 1.1780081987381, 1.17842781543732, 1.1788467168808, 1.17926502227783, 1.17968261241913, 1.18009984493256, 1.18051612377167, 1.18093192577362, 1.18134701251984, 1.18176162242889, 1.18217539787292, 1.18258857727051, 1.18300139904022, 1.18341326713562, 1.18382465839386, 1.18423545360565, 1.18464541435242, 1.18505501747131, 1.18546390533447, 1.18587207794189, 1.18627953529358, 1.1866866350174, 1.1870926618576, 1.18749845027924, 1.18790352344513, 1.18830788135529, 1.18871164321899, 1.18911492824554, 1.18951737880707, 1.18991935253143, 1.19032049179077, 1.19072115421295, 1.19112110137939, 1.19152045249939, 1.19191920757294, 1.19231724739075, 1.1927148103714, 1.19311165809631, 1.19350790977478, 1.19390344619751, 1.19429838657379, 1.19469261169434, 1.19508624076843, 1.19547939300537, 1.19587171077728, 1.19626355171204, 1.19665467739105, 1.19704520702362, 1.19743514060974, 1.19782435894012, 1.19821298122406, 1.19860100746155, 1.1989883184433, 1.1993750333786, 1.19976115226746, 1.20014655590057, 1.20053148269653, 1.20091569423676, 1.20129919052124, 1.20168220996857, 1.20206451416016, 1.2024462223053, 1.2028272151947, 1.20320761203766, 1.20358741283417, 1.20396661758423, 1.20434510707855, 1.20472300052643, 1.20510017871857, 1.20547676086426, 1.20585286617279, 1.20622825622559, 1.20660293102264, 1.20697712898254, 1.20735049247742, 1.20772337913513, 1.2080956697464, 1.20846712589264, 1.20883810520172, 1.20920848846436, 1.20957803726196, 1.2099472284317, 1.21031546592712, 1.21068334579468, 1.21105051040649, 1.21141707897186, 1.21178293228149, 1.21214818954468, 1.21251273155212, 1.21287679672241, 1.21324014663696, 1.21360290050507, 1.21396493911743, 1.21432650089264, 1.21468722820282, 1.21504747867584, 1.21540701389313, 1.21576607227325, 1.21612429618835, 1.21648216247559, 1.2168390750885, 1.21719539165497, 1.21755123138428, 1.21790635585785, 1.21826088428497, 1.21861481666565, 1.21896815299988, 1.21932077407837, 1.21967279911041, 1.22002410888672, 1.22037482261658, 1.22072494029999, 1.22107434272766, 1.22142326831818, 1.22177147865295, 1.22211897373199, 1.22246599197388, 1.22281217575073, 1.22315800189972, 1.22350299358368, 1.22384738922119, 1.22419130802155, 1.22453439235687, 1.22487688064575, 1.22521889209747, 1.22555994987488, 1.2259007692337, 1.22624063491821, 1.22658002376556, 1.22691869735718, 1.22725677490234, 1.22759449481964, 1.22793126106262, 1.22826743125916, 1.22860288619995, 1.22893798351288, 1.22927224636078, 1.22960603237152, 1.22993910312653, 1.23027145862579, 1.23060321807861, 1.23093438148499, 1.23126494884491, 1.2315948009491, 1.23192393779755, 1.23225259780884, 1.23258078098297, 1.23290801048279, 1.23323476314545, 1.23356091976166, 1.23388636112213, 1.23421120643616, 1.23453545570374, 1.23485898971558, 1.23518192768097, 1.23550426959991, 1.23582601547241, 1.23614704608917, 1.23646759986877, 1.23678719997406, 1.23710632324219, 1.23742496967316, 1.2377427816391, 1.23806011676788, 1.23837661743164, 1.23869276046753, 1.23900806903839, 1.23932290077209, 1.23963689804077, 1.23995053768158, 1.24026322364807, 1.2405754327774, 1.24088704586029, 1.24119794368744, 1.24150824546814, 1.24181795120239, 1.2421270608902, 1.24243557453156, 1.24274325370789, 1.24305045604706, 1.24335694313049, 1.24366295337677, 1.24396812915802, 1.24427282810211, 1.24457681179047, 1.24488008022308, 1.24518287181854, 1.24548494815826, 1.24578654766083, 1.24608731269836, 1.24638760089874, 1.24668717384338, 1.24698603153229, 1.24728441238403, 1.24758207798004, 1.24787926673889, 1.24817562103271, 1.24847149848938, 1.24876654148102, 1.2490611076355, 1.24935495853424, 1.24964821338654, 1.24994087219238, 1.25023281574249, 1.25052416324615, 1.25081491470337, 1.25110507011414, 1.25139462947845, 1.25168347358704, 1.25197172164917, 1.25225925445557, 1.25254619121552, 1.25283253192902, 1.25311827659607, 1.25340330600739, 1.25368773937225, 1.25397157669067, 1.25425469875336, 1.25453722476959, 1.25481903553009, 1.25510036945343, 1.25538110733032, 1.25566101074219, 1.2559403181076, 1.25621914863586, 1.25649726390839, 1.25677466392517, 1.25705170631409, 1.25732779502869, 1.25760340690613, 1.25787842273712, 1.25815260410309, 1.2584263086319, 1.25869941711426, 1.25897181034088, 1.25924360752106, 1.25951480865479, 1.25978529453278, 1.26005518436432, 1.26032447814941, 1.26059317588806, 1.26086115837097, 1.26112842559814, 1.26139521598816, 1.26166141033173, 1.26192677021027, 1.26219177246094, 1.26245594024658, 1.26271939277649, 1.26298260688782, 1.26324474811554, 1.26350653171539, 1.26376760005951, 1.26402795314789, 1.26428782939911, 1.26454710960388, 1.26480555534363, 1.26506340503693, 1.26532065868378, 1.26556289196014, 1.26578974723816, 1.26601576805115, 1.26624095439911, 1.26646554470062, 1.26668918132782, 1.26691210269928, 1.267134308815, 1.2673556804657, 1.26757633686066, 1.26779639720917, 1.26801550388336, 1.26823389530182, 1.26845133304596, 1.26866817474365, 1.26888418197632, 1.26909959316254, 1.26931405067444, 1.26952767372131, 1.26974070072174, 1.26995289325714, 1.27016448974609, 1.27037513256073, 1.27058494091034, 1.2707941532135, 1.27100253105164, 1.27121019363403, 1.2714170217514, 1.27162301540375, 1.27182817459106, 1.27203273773193, 1.27223658561707, 1.27243959903717, 1.27264177799225, 1.27284336090088, 1.27304399013519, 1.27324390411377, 1.27344310283661, 1.27364146709442, 1.27383899688721, 1.27403593063354, 1.27423191070557, 1.27442717552185, 1.27462184429169, 1.27481555938721, 1.27500855922699, 1.27520096302032, 1.27539229393005, 1.27558302879333, 1.27577304840088, 1.2759622335434, 1.27615058422089, 1.27633833885193, 1.27652513980865, 1.27671122550964, 1.27689647674561, 1.27708113193512, 1.27726495265961, 1.27744805812836, 1.27763020992279, 1.27781176567078, 1.27799248695374, 1.27817237377167, 1.27835154533386, 1.27853012084961, 1.27870762348175, 1.27888453006744, 1.2790607213974, 1.27923607826233, 1.27941060066223, 1.2795844078064, 1.27975749969482, 1.27992975711823, 1.28010129928589, 1.28027212619781, 1.28044211864471, 1.28061127662659, 1.28077971935272, 1.28094732761383, 1.28111433982849, 1.28128039836884, 1.28144574165344, 1.28161036968231, 1.28177428245544, 1.28193712234497, 1.28209948539734, 1.28226113319397, 1.28242194652557, 1.28258180618286, 1.2827410697937, 1.28289949893951, 1.28305721282959, 1.28321409225464, 1.28337037563324, 1.28352570533752, 1.28368031978607, 1.28383421897888, 1.28398728370667, 1.28413951396942, 1.28429102897644, 1.28444182872772, 1.28459191322327, 1.28474116325378, 1.28488969802856, 1.28503727912903, 1.28518426418304, 1.28533041477203, 1.28547596931458, 1.2856205701828, 1.28576445579529, 1.28590738773346, 1.28604984283447, 1.28619146347046, 1.28633224964142, 1.28647220134735, 1.28661143779755, 1.28675007820129, 1.28688776493073, 1.28702473640442, 1.2871607542038, 1.28729617595673, 1.28743100166321, 1.28756487369537, 1.28769791126251, 1.28783023357391, 1.28796184062958, 1.2880927324295, 1.2882227897644, 1.28835201263428, 1.28848052024841, 1.28860819339752, 1.28873515129089, 1.28886139392853, 1.28898692131042, 1.28911149501801, 1.28923535346985, 1.28935849666595, 1.28948104381561, 1.28960251808167, 1.28972339630127, 1.28984355926514, 1.28996276855469, 1.2900812625885, 1.29019916057587, 1.29031610488892, 1.29043233394623, 1.2905478477478, 1.29066240787506, 1.29077637195587, 1.29088962078094, 1.2910019159317, 1.29111349582672, 1.29122447967529, 1.29133439064026, 1.29144370555878, 1.29155242443085, 1.29166007041931, 1.29176712036133, 1.29187333583832, 1.29197871685028, 1.2920835018158, 1.29218745231628, 1.29229056835175, 1.29239296913147, 1.29249465465546, 1.29259550571442, 1.29269576072693, 1.29279506206512, 1.29289364814758, 1.29299139976501, 1.29308843612671, 1.29318463802338, 1.29328012466431, 1.2933748960495, 1.29346871376038, 1.2935619354248, 1.2936544418335, 1.29374623298645, 1.29383707046509, 1.29392719268799, 1.29401648044586, 1.294105052948, 1.2941929101944, 1.29427981376648, 1.29436612129211, 1.29445171356201, 1.29453647136688, 1.29462039470673, 1.29470372200012, 1.29478597640991, 1.29486763477325, 1.29494869709015, 1.29502880573273, 1.29510819911957, 1.29518687725067, 1.29526460170746, 1.29534161090851, 1.29541790485382, 1.29549360275269, 1.29556822776794, 1.29564225673676, 1.29571545124054, 1.29578793048859, 1.2958596944809, 1.29593050479889, 1.29600071907043, 1.29607009887695, 1.29613864421844, 1.29620659351349, 1.29627358913422, 1.2963399887085, 1.29640543460846, 1.29647028446198, 1.29653429985046, 1.29659748077393, 1.29665994644165, 1.29672181606293, 1.29678273200989, 1.29684281349182, 1.29690229892731, 1.29696094989777, 1.29701888561249, 1.2970757484436, 1.29713213443756, 1.29718780517578, 1.29724252223969, 1.29729652404785, 1.29734992980957, 1.29740238189697, 1.29745399951935, 1.29750502109528, 1.29755520820618, 1.29760456085205, 1.29765319824219, 1.29770123958588, 1.29774820804596, 1.29779458045959, 1.29784023761749, 1.29788506031036, 1.29792904853821, 1.2979724407196, 1.29801499843597, 1.29805660247803, 1.29809761047363, 1.29813778400421, 1.29817736148834, 1.29821598529816, 1.29825377464294, 1.29829096794128, 1.2983273267746, 1.29836297035217, 1.29839777946472, 1.29843175411224, 1.29846525192261, 1.29849767684937, 1.29852938652039, 1.29856050014496, 1.29859066009521, 1.29862010478973, 1.29864883422852, 1.29867672920227, 1.29870390892029, 1.29873025417328, 1.29875576496124, 1.29878067970276, 1.29880475997925, 1.298828125, 1.29885053634644, 1.29887247085571, 1.29889345169067, 1.2989137172699, 1.29893314838409, 1.29895186424255, 1.29896986484528, 1.29898691177368, 1.29900336265564, 1.29901909828186, 1.29903388023376, 1.29904794692993, 1.29906141757965, 1.29907381534576, 1.29908573627472, 1.29909670352936, 1.29910707473755, 1.29911649227142, 1.29912531375885, 1.29913306236267, 1.29914033412933, 1.29914665222168, 1.29915237426758, 1.29915726184845, 1.29916131496429, 1.2991646528244, 1.29916739463806, 1.2991691827774, 1.29917025566101, 1.29917049407959, 1.29917001724243, 1.29916870594025, 1.29916679859161, 1.29916393756866, 1.29916036128998, 1.29915606975555, 1.29915082454681, 1.29914510250092, 1.2991384267807, 1.29913103580475, 1.29912281036377, 1.29911398887634, 1.2991042137146, 1.29909372329712, 1.29908263683319, 1.29907059669495, 1.29905772209167, 1.29904425144196, 1.29902994632721, 1.29901480674744, 1.29899883270264, 1.29898226261139, 1.2989649772644, 1.29894685745239, 1.29892802238464, 1.29890823364258, 1.29888772964478, 1.29886651039124, 1.29884457588196, 1.29882180690765, 1.29879820346832, 1.29877400398254, 1.29874885082245, 1.29872310161591, 1.29869651794434, 1.29866909980774, 1.29864096641541, 1.29861211776733, 1.29858243465424, 1.29855191707611, 1.29852080345154, 1.29848873615265, 1.29845607280731, 1.29842257499695, 1.29838824272156, 1.29835331439972, 1.29831743240356, 1.29828083515167, 1.29824364185333, 1.29820537567139, 1.29816663265228, 1.29812693595886, 1.29808640480042, 1.29804527759552, 1.2980033159256, 1.29796051979065, 1.29791712760925, 1.29787290096283, 1.29782783985138, 1.2977819442749, 1.29773545265198, 1.29768812656403, 1.29764008522034, 1.29759120941162, 1.29754149913788, 1.2974910736084, 1.29743993282318, 1.29738807678223, 1.29733526706696, 1.29728186130524, 1.29722762107849, 1.29717266559601, 1.2971168756485, 1.29706037044525, 1.29700291156769, 1.29694497585297, 1.29688596725464, 1.29682648181915, 1.29676604270935, 1.2967050075531, 1.29664301872253, 1.29658031463623, 1.2965167760849, 1.29645264148712, 1.29638767242432, 1.29632186889648, 1.29625523090363, 1.29618799686432, 1.29612004756927, 1.29605114459991, 1.29598152637482, 1.29591119289398, 1.29584014415741, 1.29576826095581, 1.29569554328918, 1.29562199115753, 1.29554784297943, 1.2954728603363, 1.29539716243744, 1.29532063007355, 1.29524338245392, 1.29516541957855, 1.29508650302887, 1.29500699043274, 1.29492664337158, 1.2948454618454, 1.29476356506348, 1.29468083381653, 1.29459762573242, 1.29451334476471, 1.29442834854126, 1.29434251785278, 1.29425621032715, 1.2941689491272, 1.29408085346222, 1.29399216175079, 1.29390251636505, 1.29381215572357, 1.29372107982635, 1.2936292886734, 1.29353654384613, 1.29344320297241, 1.29334902763367, 1.2932540178299, 1.29315841197968, 1.29306197166443, 1.29296469688416, 1.29286658763885, 1.29276788234711, 1.29266834259033, 1.29256808757782, 1.29246699810028, 1.29236507415771, 1.2922625541687, 1.29215908050537, 1.29205501079559, 1.2919499874115, 1.29184436798096, 1.29173803329468, 1.29163062572479, 1.29152262210846, 1.29141402244568, 1.29130446910858, 1.29119408130646, 1.29108309745789, 1.290971159935, 1.29085862636566, 1.2907452583313, 1.29063105583191, 1.29051625728607, 1.29040062427521, 1.29028415679932, 1.2901668548584, 1.29004895687103, 1.28993010520935, 1.28981077671051, 1.28969037532806, 1.28956937789917, 1.28944754600525, 1.2893248796463, 1.2892017364502, 1.28907752037048, 1.28895270824432, 1.28882694244385, 1.28870058059692, 1.28857338428497, 1.28844547271729, 1.28831660747528, 1.28818726539612, 1.28805696964264, 1.28792595863342, 1.28779411315918, 1.2876615524292, 1.28752815723419, 1.28739416599274, 1.28725922107697, 1.28712368011475, 1.28698718547821, 1.28685009479523, 1.28671216964722, 1.28657341003418, 1.28643393516541, 1.2862936258316, 1.28615272045135, 1.28601098060608, 1.28586840629578, 1.28572499752045, 1.28558111190796, 1.28543615341187, 1.28529047966003, 1.28514420986176, 1.28499698638916, 1.28484916687012, 1.28470039367676, 1.28455090522766, 1.28440082073212, 1.28424978256226, 1.28409802913666, 1.28394544124603, 1.28379225730896, 1.28363800048828, 1.28348314762115, 1.28332769870758, 1.28315615653992, 1.28296864032745, 1.28278064727783, 1.28259181976318, 1.28240251541138, 1.28221225738525, 1.28202152252197, 1.28183019161224, 1.28163802623749, 1.28144526481628, 1.28125178813934, 1.28105783462524, 1.28086292743683, 1.28066766262054, 1.28047144412994, 1.28027474880219, 1.2800772190094, 1.27987921237946, 1.27968049049377, 1.27948117256165, 1.2792809009552, 1.27908003330231, 1.27887880802155, 1.27867674827576, 1.27847397327423, 1.27827048301697, 1.27806639671326, 1.2778617143631, 1.2776563167572, 1.27745020389557, 1.2772433757782, 1.27703595161438, 1.27682793140411, 1.27661919593811, 1.27640986442566, 1.27619969844818, 1.27598893642426, 1.27577745914459, 1.27556526660919, 1.27535271644592, 1.27513909339905, 1.2749251127243, 1.27471041679382, 1.2744950056076, 1.27427899837494, 1.27406215667725, 1.27384471893311, 1.27362668514252, 1.27340793609619, 1.27318835258484, 1.27296841144562, 1.27274763584137, 1.27252626419067, 1.27230417728424, 1.27208137512207, 1.27185797691345, 1.27163398265839, 1.27140915393829, 1.27118372917175, 1.27095758914948, 1.27073097229004, 1.27050352096558, 1.27027547359467, 1.27004671096802, 1.26981723308563, 1.26958739757538, 1.26935648918152, 1.2691251039505, 1.26889300346375, 1.26866030693054, 1.2684268951416, 1.26819276809692, 1.2679580450058, 1.26772260665894, 1.26748657226562, 1.26724982261658, 1.26701247692108, 1.26677429676056, 1.26653563976288, 1.26629626750946, 1.26605618000031, 1.26581537723541, 1.26557397842407, 1.26533186435699, 1.26508927345276, 1.26484572887421, 1.2646017074585, 1.26435697078705, 1.26411151885986, 1.26386547088623, 1.26361870765686, 1.26337134838104, 1.26312327384949, 1.26287460327148, 1.26262509822845, 1.26237511634827, 1.26212430000305, 1.26187288761139, 1.26162087917328, 1.26136815547943, 1.26111483573914, 1.26086068153381, 1.26060605049133, 1.26035058498383, 1.26009452342987, 1.25983786582947, 1.25958037376404, 1.25932240486145, 1.25906348228455, 1.25880408287048, 1.25854420661926, 1.25828337669373, 1.25802195072174, 1.25775980949402, 1.25749719142914, 1.25723385810852, 1.25696980953217, 1.25670504570007, 1.25643956661224, 1.25617361068726, 1.25590693950653, 1.25563943386078, 1.25537145137787, 1.25510275363922, 1.25483334064484, 1.254563331604, 1.25429260730743, 1.25402116775513, 1.25374901294708, 1.25347638130188, 1.25320291519165, 1.25292897224426, 1.25265407562256, 1.2523787021637, 1.25210273265839, 1.25182592868805, 1.25154864788055, 1.25127065181732, 1.25099182128906, 1.25071251392365, 1.2504323720932, 1.25015163421631, 1.24987030029297, 1.24958825111389, 1.24930560588837, 1.24902212619781, 1.24873805046082, 1.24845349788666, 1.24816799163818, 1.24788200855255, 1.24759519100189, 1.24730789661407, 1.24701988697052, 1.24673104286194, 1.24644184112549, 1.24615168571472, 1.24586093425751, 1.24556946754456, 1.24527752399445, 1.24498474597931, 1.24469149112701, 1.24439740180969, 1.24410271644592, 1.24380731582642, 1.24351131916046, 1.24321460723877, 1.24291706085205, 1.24261915683746, 1.24232041835785, 1.2420209646225, 1.24172103404999, 1.24142026901245, 1.24111890792847, 1.24081695079803, 1.24051415920258, 1.24021089076996, 1.23990666866302, 1.23960208892822, 1.2392965555191, 1.23899066448212, 1.2386839389801, 1.23837661743164, 1.23806846141815, 1.2377598285675, 1.23745036125183, 1.23714029788971, 1.23682963848114, 1.23651826381683, 1.23620629310608, 1.2358934879303, 1.23558008670807, 1.23526608943939, 1.23495149612427, 1.23463606834412, 1.23432004451752, 1.23400342464447, 1.2336859703064, 1.23336791992188, 1.23304915428162, 1.23273003101349, 1.23240983486176, 1.23208916187286, 1.23176777362823, 1.23144567012787, 1.23112308979034, 1.23079979419708, 1.23047578334808, 1.23015093803406, 1.22982561588287, 1.22949957847595, 1.22917282581329, 1.22884547710419, 1.22851741313934, 1.22818875312805, 1.22785937786102, 1.22752940654755, 1.22719871997833, 1.22686731815338, 1.22653520107269, 1.22620260715485, 1.22586917877197, 1.22553515434265, 1.22520041465759, 1.22486519813538, 1.22452914714813, 1.22419238090515, 1.22385501861572, 1.22351694107056, 1.22317826747894, 1.22283899784088, 1.22249901294708, 1.22215831279755, 1.22181689739227, 1.22147488594055, 1.22113215923309, 1.22078883647919, 1.22044467926025, 1.22010016441345, 1.21975469589233, 1.21940886974335, 1.21906197071075, 1.21871471405029, 1.2183666229248, 1.21801793575287, 1.21766865253448, 1.21731865406036, 1.21696805953979, 1.21661651134491, 1.21626460552216, 1.21591186523438, 1.21555852890015, 1.21520447731018, 1.21484982967377, 1.21449446678162, 1.21413850784302, 1.21378171443939, 1.21342444419861, 1.2130663394928, 1.21270775794983, 1.21234834194183, 1.21198832988739, 1.2116277217865, 1.21126627922058, 1.2109043598175, 1.21054172515869, 1.21017825603485, 1.20981431007385, 1.20944952964783, 1.20908427238464, 1.20871829986572, 1.20835161209106, 1.20798420906067, 1.20761620998383, 1.20724749565125, 1.20687818527222, 1.20650804042816, 1.20613741874695, 1.20576620101929, 1.2053941488266, 1.20502150058746, 1.20464813709259, 1.20427405834198, 1.20389950275421, 1.20352411270142, 1.20314800739288, 1.20277142524719, 1.20239412784576, 1.2020161151886, 1.20163750648499, 1.20125806331635, 1.20087814331055, 1.20049738883972, 1.20011603832245, 1.19973397254944, 1.19935142993927, 1.19896793365479, 1.19858407974243, 1.19819927215576, 1.19781410694122, 1.19742810726166, 1.19704139232635, 1.1966540813446, 1.19626605510712, 1.19587731361389, 1.19548809528351, 1.1950980424881, 1.19470739364624, 1.19431602954865, 1.1939240694046, 1.19353127479553, 1.1931380033493, 1.19274401664734, 1.19234931468964, 1.19195401668549, 1.19155812263489, 1.19116139411926, 1.19076406955719, 1.19036602973938, 1.18996727466583, 1.18956816196442, 1.18916797637939, 1.1887674331665, 1.18836605548859, 1.18796396255493, 1.18756127357483, 1.18715822696686, 1.18675410747528, 1.18634939193726, 1.18594408035278, 1.18553817272186, 1.18513143062592, 1.18472409248352, 1.18431615829468, 1.1839075088501, 1.18349814414978, 1.18308806419373, 1.18267750740051, 1.18226623535156, 1.18185412883759, 1.18144154548645, 1.18102812767029, 1.18061423301697, 1.18019950389862, 1.17978405952454, 1.17936825752258, 1.1789516210556, 1.17853426933289, 1.17811632156372, 1.17769765853882, 1.17727828025818, 1.17685830593109, 1.17643761634827, 1.17601633071899, 1.17559432983398, 1.17517161369324, 1.17474842071533, 1.1743243932724, 1.17389976978302, 1.17347455024719, 1.17304837703705, 1.17262184619904, 1.17219436168671, 1.17176651954651, 1.17133784294128, 1.17090845108032, 1.1704785823822, 1.17004787921906, 1.16961658000946, 1.16918468475342, 1.16875195503235, 1.16831862926483, 1.16788470745087, 1.16744995117188, 1.16701471805573, 1.16657865047455, 1.16614198684692, 1.16570472717285, 1.16526675224304, 1.1648280620575, 1.1643887758255, 1.16394877433777, 1.16350817680359, 1.16306686401367, 1.16262495517731, 1.16218233108521, 1.16173887252808, 1.16129493713379, 1.16085028648376, 1.160404920578, 1.15995907783508, 1.15951251983643, 1.15906512737274, 1.15861713886261, 1.15816843509674, 1.15771925449371, 1.15726923942566, 1.15681862831116, 1.15636730194092, 1.15591537952423, 1.15546262264252, 1.15500938892365, 1.15455543994904, 1.1541006565094, 1.1536453962326, 1.15318953990936, 1.15273284912109, 1.15227556228638, 1.15181756019592, 1.15135884284973, 1.15089976787567, 1.15043962001801, 1.14997899532318, 1.14951765537262, 1.14905571937561, 1.14859318733215, 1.14812982082367, 1.14766585826874, 1.14720118045807, 1.14673590660095, 1.1462699174881, 1.14580345153809, 1.14533591270447, 1.14486801624298, 1.14439940452576, 1.1439300775528, 1.14346015453339, 1.14298951625824, 1.14251828193665, 1.14204621315002, 1.14157378673553, 1.14110028743744, 1.14062643051147, 1.14015173912048, 1.13967645168304, 1.13920044898987, 1.13872385025024, 1.13824653625488, 1.13776862621307, 1.13729000091553, 1.13681066036224, 1.13633072376251, 1.13585019111633, 1.13536882400513, 1.13488686084747, 1.13440430164337, 1.13392102718353, 1.13343703746796, 1.13295245170593, 1.13246703147888, 1.13198113441467, 1.13149452209473, 1.13100719451904, 1.13051927089691, 1.13003063201904, 1.12954139709473, 1.12905144691467, 1.12856090068817, 1.12806951999664, 1.12757754325867, 1.12708497047424, 1.12659168243408, 1.12609767913818, 1.12560307979584, 1.12510776519775, 1.12461185455322, 1.12411510944366, 1.12361788749695, 1.12312006950378, 1.12262141704559, 1.12212216854095, 1.12162220478058, 1.12112152576447, 1.12062013149261, 1.1201183795929, 1.11961579322815, 1.11911237239838, 1.11860859394073, 1.11810386180878, 1.11759841442108, 1.11709272861481, 1.11658608913422, 1.11607873439789, 1.1155709028244, 1.1150621175766, 1.11455285549164, 1.11404299736023, 1.11353242397308, 1.11302101612091, 1.11250901222229, 1.11199653148651, 1.11148321628571, 1.11096918582916, 1.11045467853546, 1.10993933677673, 1.10942339897156, 1.10890686511993, 1.10838961601257, 1.10787165164948, 1.10735297203064, 1.10683381557465, 1.10629487037659, 1.10573744773865, 1.10517966747284, 1.10462164878845, 1.10406303405762, 1.10350441932678, 1.10294532775879, 1.10238599777222, 1.10182654857635, 1.10126662254333, 1.10070645809174, 1.10014593601227, 1.09958517551422, 1.0990241765976, 1.0984628200531, 1.09790134429932, 1.09733927249908, 1.09677708148956, 1.09621453285217, 1.0956517457962, 1.09508860111237, 1.09452521800995, 1.09396147727966, 1.09339737892151, 1.09283328056335, 1.09226858615875, 1.09170377254486, 1.0911386013031, 1.09057307243347, 1.09000742435455, 1.08944129943848, 1.08887481689453, 1.0883082151413, 1.08774137496948, 1.08717405796051, 1.08660650253296, 1.08603870868683, 1.08547055721283, 1.08490228652954, 1.08433353900909, 1.08376455307007, 1.08319532871246, 1.0826256275177, 1.08205580711365, 1.08148574829102, 1.08091521263123, 1.08034431934357, 1.07977330684662, 1.0792019367218, 1.07863032817841, 1.07805836200714, 1.07748627662659, 1.07691359519958, 1.07634079456329, 1.07576763629913, 1.07519423961639, 1.07462060451508, 1.07404661178589, 1.07347238063812, 1.0728976726532, 1.07232296466827, 1.0717476606369, 1.07117223739624, 1.070596575737, 1.07002055644989, 1.06944406032562, 1.06886744499207, 1.06829047203064, 1.06771326065063, 1.06713581085205, 1.06655788421631, 1.06597971916199, 1.06540131568909, 1.0648227930069, 1.06424367427826, 1.06366443634033, 1.06308484077454, 1.06250500679016, 1.06192481517792, 1.06134438514709, 1.06076347827911, 1.06018257141113, 1.05960118770599, 1.05901956558228, 1.05843770503998, 1.05785536766052, 1.05727279186249, 1.05668997764587, 1.05610680580139, 1.05552351474762, 1.05493986606598, 1.05435574054718, 1.05377149581909, 1.05318689346313, 1.0526020526886, 1.0520167350769, 1.0514315366745, 1.05084574222565, 1.05025959014893, 1.04967331886292, 1.04908668994904, 1.04849970340729, 1.04791259765625, 1.04732501506805, 1.04673707485199, 1.04614901542664, 1.04556047916412, 1.0449720621109, 1.04438292980194, 1.04379367828369, 1.04320406913757, 1.04261422157288, 1.04202401638031, 1.04143345355988, 1.04084277153015, 1.04025185108185, 1.0396603345871, 1.03906881809235, 1.03847682476044, 1.03788459300995, 1.03729212284088, 1.03669917583466, 1.03610610961914, 1.03551268577576, 1.03491914272308, 1.03432500362396, 1.03373074531555, 1.03313624858856, 1.03254127502441, 1.03194618225098, 1.03135061264038, 1.0307549238205, 1.03015875816345, 1.02956247329712, 1.02896583080292, 1.02836894989014, 1.02777171134949, 1.02717411518097, 1.02657639980316, 1.0259782075882, 1.02537989616394, 1.02478122711182, 1.02418220043182, 1.02358293533325, 1.02298331260681, 1.02238345146179, 1.02178335189819, 1.02118277549744, 1.02058207988739, 1.01998102664948, 1.01937961578369, 1.01877796649933, 1.01817607879639, 1.01757383346558, 1.01697134971619, 1.01636850833893, 1.01576542854309, 1.01516211032867, 1.0145583152771, 1.01395428180695, 1.01335000991821, 1.01274538040161, 1.01214063167572, 1.01153528690338, 1.01092994213104, 1.01032412052155, 1.00971806049347, 1.0091118812561, 1.00850522518158, 1.00789821147919, 1.00729095935822, 1.00668346881866, 1.00607562065125, 1.00546753406525, 1.00485920906067, 1.00425052642822, 1.00364148616791, 1.00303220748901, 1.00242269039154, 1.00181269645691, 1.00120258331299, 1.00059199333191, 0.999981343746185, 0.999370336532593, 0.998759031295776, 0.998147308826447, 0.997535467147827, 0.996923208236694, 0.996310710906982, 0.995697855949402, 0.995084762573242, 0.994471311569214, 0.993857681751251, 0.993243515491486, 0.992629408836365, 0.992014706134796, 0.991400003433228, 0.990784704685211, 0.99016922712326, 0.989553511142731, 0.988937497138977, 0.98832106590271, 0.987704515457153, 0.987087547779083, 0.986470282077789, 0.985852837562561, 0.985235035419464, 0.984616994857788, 0.983998477458954, 0.983379721641541, 0.982760787010193, 0.982141554355621, 0.981522023677826, 0.980902016162872, 0.980281889438629, 0.979661405086517, 0.979040741920471, 0.978419661521912, 0.977798402309418, 0.977176666259766, 0.976554691791534, 0.975932538509369, 0.97530996799469, 0.974687218666077, 0.974064111709595, 0.973440766334534, 0.972816944122314, 0.972193002700806, 0.971568763256073, 0.970944106578827, 0.970319271087646, 0.969694077968597, 0.969068646430969, 0.968442857265472, 0.967816889286041, 0.967190444469452, 0.966563820838928, 0.965936899185181, 0.965309739112854, 0.964682161808014, 0.96405440568924, 0.963426291942596, 0.962797939777374, 0.962169170379639, 0.961540102958679, 0.96091091632843, 0.960281372070312, 0.959651470184326, 0.959021270275116, 0.958390772342682, 0.957760035991669, 0.957129120826721, 0.956497728824615, 0.955866158008575, 0.955234169960022, 0.954601943492889, 0.953969359397888, 0.953336536884308, 0.952703535556793, 0.95207005739212, 0.951436460018158, 0.950802445411682, 0.950168132781982, 0.949533522129059, 0.948898613452911, 0.94826352596283, 0.947628021240234, 0.946992337703705, 0.946356296539307, 0.945719957351685, 0.945083200931549, 0.944446384906769, 0.94380909204483, 0.943171679973602, 0.942533791065216, 0.941895663738251, 0.941257297992706, 0.940618634223938, 0.939979612827301, 0.93934029340744, 0.938700735569, 0.938060939311981, 0.937420666217804, 0.936780273914337, 0.936139523983002, 0.935498476028442, 0.934857130050659, 0.934215486049652, 0.933573544025421, 0.932931363582611, 0.932288765907288, 0.93164598941803, 0.931002855300903, 0.930359482765198, 0.929715812206268, 0.929071843624115, 0.928427517414093, 0.927783071994781, 0.927138030529022, 0.926492989063263, 0.92584753036499, 0.925201773643494, 0.924555718898773, 0.923909425735474, 0.923262715339661, 0.922615826129913, 0.921968460083008, 0.921321034431458, 0.920673191547394, 0.920025229454041, 0.91937667131424, 0.918728053569794, 0.918079078197479, 0.917429745197296, 0.916780173778534, 0.916130363941193, 0.915480136871338, 0.914829730987549, 0.914178967475891, 0.913527965545654, 0.912876665592194, 0.912224948406219, 0.911573112010956, 0.910920798778534, 0.910268366336823, 0.909615576267242, 0.908962428569794, 0.908308863639832, 0.907655358314514, 0.907001256942749, 0.906347036361694, 0.905692517757416, 0.905037641525269, 0.904382348060608, 0.903727054595947, 0.903071165084839, 0.902415215969086, 0.901758790016174, 0.901102244853973, 0.900445342063904, 0.899788081645966, 0.899130582809448, 0.898472785949707, 0.897814631462097, 0.897156238555908, 0.896497547626495, 0.895838618278503, 0.895179271697998, 0.894519686698914, 0.89385986328125, 0.893199741840363, 0.892539203166962, 0.891878545284271, 0.891217350959778, 0.890556156635284, 0.889894485473633, 0.889232575893402, 0.888570249080658, 0.887907803058624, 0.887245118618011, 0.886581838130951, 0.88591855764389, 0.885254919528961, 0.884590983390808, 0.883926510810852, 0.883262038230896, 0.882597088813782, 0.881932020187378, 0.881266534328461, 0.880600869655609, 0.879934668540955, 0.879268407821655, 0.878601729869843, 0.877934873104095, 0.877267599105835, 0.876600086688995, 0.875932335853577, 0.875264167785645, 0.874595820903778, 0.873927175998688, 0.873258173465729, 0.872588872909546, 0.871919214725494, 0.871249437332153, 0.870579242706299, 0.869908809661865, 0.869238018989563, 0.868566989898682, 0.867895603179932, 0.867224037647247, 0.86655205488205, 0.865879893302917, 0.865207314491272, 0.864534556865692, 0.863861441612244, 0.863188087940216, 0.862514436244965, 0.861840426921844, 0.8611661195755, 0.860491633415222, 0.85981673002243, 0.85914146900177, 0.858466148376465, 0.857790410518646, 0.857114315032959, 0.856438040733337, 0.855761349201202, 0.855084419250488, 0.854407250881195, 0.853729605674744, 0.853051900863647, 0.852373778820038, 0.851695358753204, 0.851016700267792, 0.85033768415451, 0.84965842962265, 0.848978936672211, 0.848298966884613, 0.847618818283081, 0.846938371658325, 0.84625768661499, 0.845576584339142, 0.844895303249359, 0.844213604927063, 0.843531727790833, 0.842849433422089, 0.842167019844055, 0.841484189033508, 0.840801060199738, 0.840117692947388, 0.839434027671814, 0.838750004768372, 0.838065803050995, 0.83738112449646, 0.836696326732635, 0.836011111736298, 0.835325717926025, 0.83463990688324, 0.833953857421875, 0.833267509937286, 0.832580924034119, 0.831894040107727, 0.831206798553467, 0.830519378185272, 0.829831540584564, 0.829143404960632, 0.828455030918121, 0.827766358852386, 0.827077329158783, 0.826388120651245, 0.825698494911194, 0.825008630752563, 0.824318468570709, 0.823628067970276, 0.822937309741974, 0.822246253490448, 0.821554958820343, 0.820863246917725, 0.820171296596527, 0.819479167461395, 0.818786680698395, 0.81809389591217, 0.817400693893433, 0.81670731306076, 0.816013634204865, 0.815319657325745, 0.814625322818756, 0.813930869102478, 0.813235878944397, 0.812540829181671, 0.811845302581787, 0.811149656772614, 0.810453534126282, 0.80975729227066, 0.809060513973236, 0.808363735675812, 0.807666480541229, 0.806968986988068, 0.806271135807037, 0.805573046207428, 0.80487471818924, 0.804176032543182, 0.803477048873901, 0.802777707576752, 0.802078247070312, 0.801378309726715, 0.800678193569183, 0.799977719783783, 0.799276947975159, 0.798575937747955, 0.797874629497528, 0.797172963619232, 0.796471118927002, 0.795768737792969, 0.795066297054291, 0.794363498687744, 0.793660461902618, 0.792957007884979, 0.792253375053406, 0.791549324989319, 0.7908536195755, 0.790167629718781, 0.78948187828064, 0.788796305656433, 0.788110792636871, 0.787425518035889, 0.786740362644196, 0.786055326461792, 0.785370528697968, 0.784685850143433, 0.784001290798187, 0.783316791057587, 0.782632648944855, 0.781948506832123, 0.781264662742615, 0.780580878257751, 0.779897272586823, 0.779213786125183, 0.778530538082123, 0.777847349643707, 0.777164399623871, 0.776481568813324, 0.775798916816711, 0.775116384029388, 0.774433970451355, 0.773751795291901, 0.773069679737091, 0.772387802600861, 0.77170604467392, 0.771024465560913, 0.770343005657196, 0.769661724567413, 0.76898056268692, 0.768299698829651, 0.767618656158447, 0.766938090324402, 0.766257584095001, 0.765577256679535, 0.764896988868713, 0.764216959476471, 0.763537049293518, 0.7628573179245, 0.762177705764771, 0.761498272418976, 0.760818958282471, 0.760139882564545, 0.759460866451263, 0.758782148361206, 0.758103370666504, 0.75742495059967, 0.756746530532837, 0.756068408489227, 0.755390286445618, 0.754712402820587, 0.754034638404846, 0.753357172012329, 0.752679646015167, 0.752002477645874, 0.751325249671936, 0.750648319721222, 0.749971568584442, 0.749294936656952, 0.748618423938751, 0.74794203042984, 0.747265875339508, 0.746589839458466, 0.745913982391357, 0.745238184928894, 0.74456262588501, 0.74388724565506, 0.743212044239044, 0.742536783218384, 0.741861939430237, 0.741187036037445, 0.740512490272522, 0.739837944507599, 0.7391636967659, 0.7384894490242, 0.73781543970108, 0.737141609191895, 0.736467838287354, 0.735794365406036, 0.735120832920074, 0.734447658061981, 0.733774542808533, 0.733101606369019, 0.732428908348083, 0.731756210327148, 0.731083750724792, 0.730411350727081, 0.729739248752594, 0.729067146778107, 0.728395402431488, 0.727723598480225, 0.72705203294754, 0.72638064622879, 0.725709497928619, 0.725038349628448, 0.724367380142212, 0.72369658946991, 0.723025977611542, 0.722355604171753, 0.721685230731964, 0.721015095710754, 0.720345079898834, 0.719675242900848, 0.719005525112152, 0.718336045742035, 0.717666566371918, 0.716997385025024, 0.716328263282776, 0.715659379959106, 0.714990615844727, 0.714321970939636, 0.71365350484848, 0.712985277175903, 0.712317049503326, 0.711649119853973, 0.710981130599976, 0.710313618183136, 0.709645986557007, 0.708978593349457, 0.708311438560486, 0.70764434337616, 0.706977427005768, 0.706310629844666, 0.705644071102142, 0.704977631568909, 0.704311311244965, 0.7036452293396, 0.702979207038879, 0.702313423156738, 0.701647639274597, 0.700982213020325, 0.700316786766052, 0.699651539325714, 0.698986530303955, 0.69832170009613, 0.697656869888306, 0.696992337703705, 0.696327865123749, 0.695663630962372, 0.694999516010284, 0.694335460662842, 0.693671762943268, 0.693007946014404, 0.692344546318054, 0.691681087017059, 0.691017985343933, 0.690354883670807, 0.68969190120697, 0.689029276371002, 0.688366711139679, 0.687704265117645, 0.687041938304901, 0.686379849910736, 0.685717880725861, 0.685056090354919, 0.684394419193268, 0.683732867240906, 0.683071613311768, 0.682410359382629, 0.68174934387207, 0.681088447570801, 0.680427730083466, 0.67976713180542, 0.679106771945953, 0.678446412086487, 0.677786350250244, 0.677126348018646, 0.676466584205627, 0.675806939601898, 0.675147473812103, 0.674488008022308, 0.673828959465027, 0.673169851303101, 0.672510981559753, 0.671852231025696, 0.671193718910217, 0.670535326004028, 0.669877052307129, 0.669218957424164, 0.668561041355133, 0.667903184890747, 0.667245626449585, 0.666588008403778, 0.66593074798584, 0.665273666381836, 0.664616644382477, 0.663959741592407, 0.663303017616272, 0.662646472454071, 0.66199004650116, 0.661333858966827, 0.66067773103714, 0.660021781921387, 0.659365952014923, 0.658710360527039, 0.658054828643799, 0.657399654388428, 0.656744420528412, 0.656089425086975, 0.655434489250183, 0.65477991104126, 0.654125332832336, 0.653470873832703, 0.652816653251648, 0.652162671089172, 0.651508688926697, 0.6508549451828, 0.650201320648193, 0.649547874927521, 0.648894488811493, 0.648241341114044, 0.64758837223053, 0.64693546295166, 0.64628279209137, 0.645630240440369, 0.644977927207947, 0.644325733184814, 0.643673539161682, 0.643021702766418, 0.642370045185089, 0.641718327999115, 0.641066908836365, 0.640415549278259, 0.639764428138733, 0.639113426208496, 0.638462603092194, 0.637811958789825, 0.637161374092102, 0.636510968208313, 0.635860860347748, 0.635210752487183, 0.634560883045197, 0.6339111328125, 0.633261501789093, 0.632611989974976, 0.631962776184082, 0.631313681602478, 0.630664646625519, 0.630015790462494, 0.629367172718048, 0.628718674182892, 0.62807023525238, 0.627422034740448, 0.626773953437805, 0.626126050949097, 0.625478386878967, 0.624830722808838, 0.624183356761932, 0.623536050319672, 0.622888922691345, 0.622241973876953, 0.62159526348114, 0.620948553085327, 0.620302021503448, 0.619655609130859, 0.619009494781494, 0.618363320827484, 0.617717564105988, 0.617071747779846, 0.616426169872284, 0.615780830383301, 0.615135550498962, 0.614490330219269, 0.613845407962799, 0.613200604915619, 0.612555980682373, 0.611911475658417, 0.61126708984375, 0.610623061656952, 0.609978854656219, 0.609335064888, 0.608691275119781, 0.608047783374786, 0.607404351234436, 0.60676109790802, 0.606117904186249, 0.605475068092346, 0.604832231998444, 0.60418963432312, 0.603547096252441, 0.602904856204987, 0.602262496948242, 0.601620554924011, 0.600978672504425, 0.600336909294128, 0.599695384502411, 0.599053978919983, 0.598412692546844, 0.597771644592285, 0.597130656242371, 0.59648996591568, 0.595849275588989, 0.595208764076233, 0.594568490982056, 0.593928337097168, 0.593288421630859, 0.592648446559906, 0.592008709907532, 0.591369271278381, 0.590729773044586, 0.590090572834015, 0.589451551437378, 0.588812589645386, 0.588173866271973, 0.587535202503204, 0.58689671754837, 0.586258411407471, 0.585620284080505, 0.584982216358185, 0.584344387054443, 0.583706676959991, 0.583069205284119, 0.582431733608246, 0.581794559955597, 0.581157386302948, 0.580520570278168, 0.579883754253387, 0.579247176647186, 0.57861065864563, 0.577974379062653, 0.57733827829361, 0.576702237129211, 0.576066434383392, 0.575430750846863, 0.574795186519623, 0.574159801006317, 0.573524594306946, 0.572889626026154, 0.572254598140717, 0.571619927883148, 0.570985198020935, 0.570350885391235, 0.569716453552246, 0.569082379341125, 0.568448424339294, 0.567814588546753, 0.567180871963501, 0.566547393798828, 0.5659139752388, 0.565280735492706, 0.564647674560547, 0.564014852046967, 0.563382208347321, 0.562749445438385, 0.562117159366608, 0.561484754085541, 0.560852706432343, 0.5602205991745, 0.559588968753815, 0.558957278728485, 0.55832576751709, 0.557694375514984, 0.557063162326813, 0.556432068347931, 0.555801272392273, 0.555170476436615, 0.554539918899536, 0.553909480571747, 0.553279161453247, 0.552649021148682, 0.552019059658051, 0.551389276981354, 0.550759553909302, 0.550130069255829, 0.549500823020935, 0.548871517181396, 0.548242628574371, 0.547613561153412, 0.546984970569611, 0.546356379985809, 0.545727908611298, 0.54509973526001, 0.544471561908722, 0.543843567371368, 0.543215870857239, 0.542588114738464, 0.541960656642914, 0.541333377361298, 0.540706157684326, 0.540079057216644, 0.539452254772186, 0.538825631141663, 0.538198947906494, 0.537572622299194, 0.536946296691895, 0.536320328712463, 0.535694301128387, 0.535068571567535, 0.534442901611328, 0.53381735086441, 0.533192038536072, 0.532566905021667, 0.531941831111908, 0.531316995620728, 0.530692279338837, 0.53006774187088, 0.529443323612213, 0.52881908416748, 0.528195023536682, 0.527571141719818, 0.526947200298309, 0.526323676109314, 0.525700151920319, 0.525076925754547, 0.524453639984131, 0.523830711841583, 0.523207902908325, 0.522585213184357, 0.521962642669678, 0.521340191364288, 0.520717978477478, 0.520095944404602, 0.519473969936371, 0.518852174282074, 0.518230617046356, 0.517609119415283, 0.516987800598145, 0.516366600990295, 0.515745639801025, 0.515124797821045, 0.514504253864288, 0.513883650302887, 0.51326322555542, 0.512643039226532, 0.512022972106934, 0.51140308380127, 0.510783314704895, 0.510163605213165, 0.509544193744659, 0.508924901485443, 0.508305728435516, 0.507686793804169, 0.507067978382111, 0.506449222564697, 0.505830883979797, 0.505212366580963, 0.504594206809998, 0.503976047039032, 0.50335830450058, 0.502740323543549, 0.502122819423676, 0.501505434513092, 0.500888109207153, 0.500271022319794, 0.499653995037079, 0.499037086963654, 0.49842044711113, 0.497804015874863, 0.497187584638596, 0.496571391820908, 0.495955407619476, 0.49533948302269, 0.494723707437515, 0.494108140468597, 0.493492692708969, 0.492877393960953, 0.492262423038483, 0.491647303104401, 0.491032600402832, 0.490417808294296, 0.489803433418274, 0.489189088344574, 0.488574862480164, 0.48796084523201, 0.487346947193146, 0.486733168363571, 0.486119627952576, 0.485506176948547, 0.484892874956131, 0.484279900789261, 0.483666807413101, 0.483054101467133, 0.482441306114197, 0.481828927993774, 0.481216460466385, 0.480604410171509, 0.479992389678955, 0.479380458593369, 0.478768765926361, 0.478157192468643, 0.477545768022537, 0.476934492588043, 0.476323336362839, 0.475712478160858, 0.475101679563522, 0.474491059780121, 0.473880499601364, 0.473270207643509, 0.472659975290298, 0.472049951553345, 0.471440076828003, 0.470830470323563, 0.470220774412155, 0.469611495733261, 0.469002157449722, 0.468393176794052, 0.467784106731415, 0.467196553945541, 0.466628611087799, 0.466060966253281, 0.465493589639664, 0.464926809072495, 0.46436020731926, 0.463793963193893, 0.463228106498718, 0.462662726640701, 0.462097674608231, 0.461532860994339, 0.460968673229218, 0.460404604673386, 0.459841102361679, 0.459277778863907, 0.458715051412582, 0.458152502775192, 0.45759043097496, 0.457028597593307, 0.45646721124649, 0.455906182527542, 0.455345630645752, 0.454785227775574, 0.454225450754166, 0.453665852546692, 0.453106552362442, 0.452547878026962, 0.451989412307739, 0.45143136382103, 0.450873792171478, 0.450316339731216, 0.449759483337402, 0.449202835559845, 0.448646664619446, 0.448090642690659, 0.447535365819931, 0.446980237960815, 0.446425437927246, 0.445871084928513, 0.445317029953003, 0.444763392210007, 0.444210201501846, 0.443657219409943, 0.443104654550552, 0.442552626132965, 0.442000776529312, 0.44144943356514, 0.440898209810257, 0.440347731113434, 0.439797192811966, 0.439247310161591, 0.438697785139084, 0.438148647546768, 0.437599688768387, 0.437051296234131, 0.436503142118454, 0.435955345630646, 0.435408085584641, 0.434861034154892, 0.434314370155334, 0.433768182992935, 0.433222204446793, 0.432676732540131, 0.432131588459015, 0.431586772203445, 0.431042343378067, 0.430498450994492, 0.429954648017883, 0.429411381483078, 0.428868472576141, 0.428325951099396, 0.427783608436584, 0.427241921424866, 0.426700353622437, 0.426159292459488, 0.425618648529053, 0.425078243017197, 0.424538224935532, 0.423998653888702, 0.423459410667419, 0.422920554876328, 0.422382056713104, 0.421843826770782, 0.421306073665619, 0.420768678188324, 0.420231759548187, 0.419695019721985, 0.419158726930618, 0.418622881174088, 0.418087214231491, 0.417552024126053, 0.417017310857773, 0.416482746601105, 0.415948629379272, 0.415414959192276, 0.414881646633148, 0.414348572492599, 0.413816094398499, 0.41328376531601, 0.412751853466034, 0.412220418453217, 0.411689341068268, 0.411158442497253, 0.410628199577332, 0.410098016262054, 0.40956848859787, 0.409039199352264, 0.40851029753685, 0.407981723546982, 0.407453566789627, 0.406925797462463, 0.406398296356201, 0.405871272087097, 0.405344516038895, 0.404818147420883, 0.40429225564003, 0.403766632080078, 0.403241366147995, 0.402716547250748, 0.402192026376724, 0.401667892932892, 0.401144176721573, 0.400620758533478, 0.400097817182541, 0.399575144052505, 0.399052947759628, 0.398531019687653, 0.398009359836578, 0.397488296031952, 0.396967530250549, 0.396446973085403, 0.395926982164383, 0.395407289266586, 0.394887834787369, 0.394369065761566, 0.393850386142731, 0.393332242965698, 0.392814368009567, 0.392296940088272, 0.391779631376266, 0.391263127326965, 0.390746593475342, 0.390230655670166, 0.389715135097504, 0.389199763536453, 0.388684868812561, 0.388170331716537, 0.387656152248383, 0.387142390012741, 0.386628985404968, 0.386115908622742, 0.385603159666061, 0.385090976953506, 0.384578973054886, 0.384067326784134, 0.383556216955185, 0.383045315742493, 0.382534801959991, 0.382024884223938, 0.381515026092529, 0.381005644798279, 0.380496680736542, 0.379988133907318, 0.379479736089706, 0.378971874713898, 0.378464460372925, 0.377957254648209, 0.377450495958328, 0.376944094896317, 0.376438081264496, 0.375932276248932, 0.37542712688446, 0.374922126531601, 0.374417662620544, 0.373913407325745, 0.373409599065781, 0.372905999422073, 0.372403025627136, 0.371900349855423, 0.371397942304611, 0.370895951986313, 0.370394349098206, 0.369893074035645, 0.369392305612564, 0.368891686201096, 0.368391543626785, 0.367891877889633, 0.367392420768738, 0.366893291473389, 0.366394728422165, 0.365896373987198, 0.365398436784744, 0.364900946617126, 0.364403784275055, 0.36390683054924, 0.363410592079163, 0.362914323806763, 0.362418711185455, 0.361923366785049, 0.361428409814835, 0.360933750867844, 0.360439598560333, 0.359945625066757, 0.359452158212662, 0.358959048986435, 0.358466267585754, 0.35797381401062, 0.357481807470322, 0.356990337371826, 0.356498926877975, 0.356008052825928, 0.355517446994781, 0.355027377605438, 0.35453736782074, 0.354048073291779, 0.353559076786041, 0.353070288896561, 0.352581948041916, 0.352094024419785, 0.351606339216232, 0.351119220256805, 0.350632339715958, 0.350145757198334, 0.349659740924835, 0.349173933267593, 0.348688542842865, 0.34820356965065, 0.347718924283981, 0.347234666347504, 0.346750766038895, 0.346267282962799, 0.345783978700638, 0.345301300287247, 0.344818770885468, 0.344336837530136, 0.343855142593384, 0.343373775482178, 0.34289276599884, 0.342412233352661, 0.341931998729706, 0.341452151536942, 0.340972691774368, 0.340493589639664, 0.340014815330505, 0.339536368846893, 0.339058607816696, 0.338580816984177, 0.338103592395782, 0.337626665830612, 0.337150275707245, 0.336674004793167, 0.33619812130928, 0.335722833871841, 0.335247755050659, 0.334773123264313, 0.334298610687256, 0.333824813365936, 0.333351254463196, 0.332878053188324, 0.332405269145966, 0.331932723522186, 0.33146059513092, 0.330988854169846, 0.330517560243607, 0.330046683549881, 0.329576015472412, 0.32910567522049, 0.32863575220108, 0.328166306018829, 0.327697247266769, 0.327228307723999, 0.326759964227676, 0.3262919485569, 0.32582426071167, 0.325356900691986, 0.324889987707138, 0.324423462152481, 0.32395726442337, 0.323491454124451, 0.32302588224411, 0.322560966014862, 0.322096109390259, 0.321631819009781, 0.321167796850204, 0.320704221725464, 0.320241063833237, 0.319778025150299, 0.319315642118454, 0.318853557109833, 0.318391770124435, 0.317930221557617, 0.31746917963028, 0.317008584737778, 0.316548258066177, 0.316088438034058, 0.315629005432129, 0.315169602632523, 0.314710885286331, 0.314252346754074, 0.313794374465942, 0.313336700201035, 0.312879234552383, 0.312422275543213, 0.311965703964233, 0.311509490013123, 0.311053514480591, 0.310598105192184, 0.310143053531647, 0.309688240289688, 0.309233874082565, 0.308779716491699, 0.308326154947281, 0.307872921228409, 0.307419985532761, 0.306967407464981, 0.306515336036682, 0.306063443422318, 0.305611908435822, 0.305160999298096, 0.304710328578949, 0.304259806871414, 0.303809940814972, 0.303360313177109, 0.302911192178726, 0.302462309598923, 0.302013754844666, 0.301565617322922, 0.301117897033691, 0.300670593976974, 0.300223618745804, 0.299776971340179, 0.299330651760101, 0.298884689807892, 0.298439204692841, 0.297994017601013, 0.297549307346344, 0.297104746103287, 0.296660751104355, 0.296217173337936, 0.295773804187775, 0.295330792665482, 0.294888138771057, 0.29444608092308, 0.294004261493683, 0.293562710285187, 0.293121576309204, 0.292680829763412, 0.292240530252457, 0.291800498962402, 0.291360914707184, 0.290921688079834, 0.290482640266418, 0.290044218301773, 0.289606034755707, 0.289168328046799, 0.288730829954147, 0.288293689489365, 0.28785702586174, 0.287420809268951, 0.286984920501709, 0.286549240350723, 0.286113977432251, 0.285679340362549, 0.285244733095169, 0.284810721874237, 0.284376859664917, 0.283943623304367, 0.283510595560074, 0.283077985048294, 0.282645851373672, 0.282213777303696, 0.281782299280167, 0.281351208686829, 0.280920475721359, 0.280490100383759, 0.280059963464737, 0.279630333185196, 0.279201030731201, 0.278772175312042, 0.278343558311462, 0.277915269136429, 0.277487605810165, 0.277060091495514, 0.276632934808731, 0.276206254959106, 0.275779962539673, 0.275353968143463, 0.274928390979767, 0.274503111839294, 0.274078249931335, 0.2736536860466, 0.273229479789734, 0.272805750370026, 0.272382438182831, 0.271959453821182, 0.27153667807579, 0.271114438772202, 0.270692586898804, 0.270271062850952, 0.269849807024002, 0.269428849220276, 0.269008487462997, 0.268588453531265, 0.268168717622757, 0.267749309539795, 0.267330497503281, 0.266911834478378, 0.266493707895279, 0.266075670719147, 0.265658289194107, 0.265240997076035, 0.26482430100441, 0.264408051967621, 0.263991981744766, 0.263576447963715, 0.263160914182663, 0.262746155261993, 0.262331664562225, 0.261917531490326, 0.261503577232361, 0.261090159416199, 0.26067715883255, 0.260264426469803, 0.259852051734924, 0.259440243244171, 0.259028494358063, 0.258617371320724, 0.258206456899643, 0.25779601931572, 0.257385909557343, 0.256976068019867, 0.256566733121872, 0.256157785654068, 0.255749225616455, 0.255340874195099, 0.254932940006256, 0.254525452852249, 0.254118323326111, 0.253711521625519, 0.253304988145828, 0.252898991107941, 0.252493172883987, 0.252088040113449, 0.251682907342911, 0.251278430223465, 0.250874280929565, 0.250470399856567, 0.250066936016083, 0.249663919210434, 0.249261185526848, 0.248858734965324, 0.248456686735153, 0.248055070638657, 0.247653871774673, 0.247252941131592, 0.246852546930313, 0.246452257037163, 0.246052592992783, 0.245653092861176, 0.245254099369049, 0.244855403900146, 0.244457095861435, 0.244059175252914, 0.243661627173424, 0.243264332413673, 0.242867365479469, 0.242471054196358, 0.24207504093647, 0.241679251194, 0.241283848881721, 0.240888848900795, 0.240494281053543, 0.240100085735321, 0.239706188440323, 0.239312544465065, 0.238919407129288, 0.23852676153183, 0.238134279847145, 0.237742304801941, 0.237350687384605, 0.236959278583527, 0.236568361520767, 0.23617784678936, 0.235787630081177, 0.235397815704346, 0.235008329153061, 0.234619274735451, 0.23423059284687, 0.233842238783836, 0.233454167842865, 0.233066573739052, 0.23267950117588, 0.232292532920837, 0.231906071305275, 0.231519997119904, 0.23113414645195, 0.230748683214188, 0.230363726615906, 0.229979172348976, 0.229594737291336, 0.229221269488335, 0.228856325149536, 0.228491887450218, 0.228127747774124, 0.227763831615448, 0.22740039229393, 0.227037221193314, 0.226674601435661, 0.226312041282654, 0.225950077176094, 0.225588262081146, 0.225226864218712, 0.224865809082985, 0.224505022168159, 0.224144726991653, 0.2237848341465, 0.223425149917603, 0.223065763711929, 0.222706839442253, 0.222348257899284, 0.221989944577217, 0.221631973981857, 0.221274465322495, 0.220917299389839, 0.220560401678085, 0.220203787088394, 0.219847694039345, 0.219491735100746, 0.219136297702789, 0.218781158328056, 0.218426272273064, 0.21807199716568, 0.21771776676178, 0.21736404299736, 0.217010617256165, 0.216657489538193, 0.216304779052734, 0.215952426195145, 0.215600565075874, 0.21524865925312, 0.214897364377975, 0.214546471834183, 0.214195787906647, 0.213845491409302, 0.213495507836342, 0.213146030902863, 0.212796792387962, 0.212447881698608, 0.212099254131317, 0.211751043796539, 0.211403176188469, 0.211055621504784, 0.210708469152451, 0.210361614823341, 0.210015162825584, 0.209669128060341, 0.209323227405548, 0.208977952599525, 0.208632722496986, 0.208287939429283, 0.207943454384804, 0.20759953558445, 0.207255929708481, 0.206912502646446, 0.206569597125053, 0.206226885318756, 0.205884575843811, 0.205542474985123, 0.205200880765915, 0.204859688878059, 0.204518705606461, 0.20417831838131, 0.203838035464287, 0.203498154878616, 0.203158587217331, 0.202819213271141, 0.202480435371399, 0.202142179012299, 0.201803922653198, 0.201466113328934, 0.201128616929054, 0.200791448354721, 0.200454756617546, 0.200118377804756, 0.199782341718674, 0.199446499347687, 0.199111178517342, 0.19877615571022, 0.198441416025162, 0.198107093572617, 0.197773188352585, 0.19743937253952, 0.197106167674065, 0.1967733502388, 0.196440652012825, 0.196108460426331, 0.195776551961899, 0.195444971323013, 0.195113778114319, 0.194782704114914, 0.194452315568924, 0.194122135639191, 0.193792417645454, 0.19346284866333, 0.193133726716042, 0.192804977297783, 0.192476525902748, 0.192148372530937, 0.191820710897446, 0.1914933770895, 0.191166326403618, 0.190839529037476, 0.190513208508492, 0.190187066793442, 0.189861580729485, 0.189536213874817, 0.189211338758469, 0.188886716961861, 0.188562363386154, 0.188238456845284, 0.187914833426476, 0.187591597437859, 0.187268689274788, 0.186946183443069, 0.186624109745026, 0.186302110552788, 0.185980662703514, 0.185659542679787, 0.1853386759758, 0.185018241405487, 0.184698089957237, 0.184378370642662, 0.184059098362923, 0.183739945292473, 0.183421090245247, 0.183102786540985, 0.182784780859947, 0.182466924190521, 0.182149708271027, 0.181832760572433, 0.181516140699387, 0.181199908256531, 0.180883824825287, 0.180568337440491, 0.180253028869629, 0.179938167333603, 0.179623395204544, 0.179309397935867, 0.178995579481125, 0.1786819845438, 0.178368791937828, 0.178056001663208, 0.177743494510651, 0.17743131518364, 0.177119538187981, 0.176808208227158, 0.176497086882591, 0.176186308264732, 0.175876051187515, 0.175565883517265, 0.175256133079529, 0.174946695566177, 0.17463780939579, 0.174329206347466, 0.174020901322365, 0.173712879419327, 0.173405274748802, 0.173097997903824, 0.172790959477425, 0.172484502196312, 0.172178313136101, 0.171872302889824, 0.171566769480705, 0.171261548995972, 0.170956760644913, 0.170652151107788, 0.17034800350666, 0.170044243335724, 0.169740855693817, 0.169437766075134, 0.169134974479675, 0.168832585215569, 0.168530613183975, 0.168228730559349, 0.16792730987072, 0.167626246809959, 0.167325779795647, 0.167025327682495, 0.166725412011147, 0.16642564535141, 0.16612634062767, 0.165827408432961, 0.165528699755669, 0.165230557322502, 0.164932787418365, 0.164635047316551, 0.164337933063507, 0.164041042327881, 0.163744419813156, 0.163448214530945, 0.163152486085892, 0.162856981158257, 0.162561878561974, 0.162267163395882, 0.161972671747208, 0.161678671836853, 0.161384895443916, 0.161091387271881, 0.160798251628876, 0.160505622625351, 0.160213351249695, 0.159921377897263, 0.159629657864571, 0.159338340163231, 0.159047365188599, 0.158756762742996, 0.158466398715973, 0.158176511526108, 0.157886952161789, 0.157597705721855, 0.157308652997017, 0.157020181417465, 0.156732007861137, 0.156444177031517, 0.156156733632088, 0.155869618058205, 0.155582800507545, 0.155296370387077, 0.155010119080544, 0.154724448919296, 0.154438897967339, 0.154153898358345, 0.153869196772575, 0.153584867715836, 0.153300821781158, 0.15301713347435, 0.152733713388443, 0.152450829744339, 0.152168110013008, 0.151885867118835, 0.151603847742081, 0.151322305202484, 0.151041030883789, 0.150760173797607, 0.150479570031166, 0.150199264287949, 0.149919480085373, 0.149639829993248, 0.149360731244087, 0.149081945419312, 0.148803487420082, 0.148525297641754, 0.148247465491295, 0.147970095276833, 0.147692874073982, 0.147416114807129, 0.14713990688324, 0.146863758563995, 0.146588146686554, 0.146312713623047, 0.14603765308857, 0.145763009786606, 0.145488724112511, 0.145214647054672, 0.144941166043282, 0.144667938351631, 0.144394919276237, 0.144122391939163, 0.143850177526474, 0.143578112125397, 0.143306657671928, 0.143035396933556, 0.142764583230019, 0.142494201660156, 0.142223954200745, 0.14195416867733, 0.141684621572495, 0.141415596008301, 0.141146868467331, 0.140878289937973, 0.140610411763191, 0.140342578291893, 0.140075191855431, 0.139808222651482, 0.139541402459145, 0.139275103807449, 0.139009103178978, 0.138743504881859, 0.138478219509125, 0.138213336467743, 0.137948647141457, 0.137684464454651, 0.13742034137249, 0.13715685904026, 0.136893585324287, 0.13663087785244, 0.136368304491043, 0.136106103658676, 0.135844230651855, 0.135582834482193, 0.135321572422981, 0.135060906410217, 0.13480032980442, 0.134540408849716, 0.134280577301979, 0.134021192789078, 0.133762016892433, 0.133503451943398, 0.133245125412941, 0.132986903190613, 0.132729277014732, 0.132472082972527, 0.1322151273489, 0.131958574056625, 0.131702125072479, 0.131446227431297, 0.131190478801727, 0.130935311317444, 0.13068051636219, 0.13042588531971, 0.130171775817871, 0.129917904734612, 0.129664361476898, 0.129411309957504, 0.129158407449722, 0.128905892372131, 0.128653794527054, 0.128402233123779, 0.128150671720505, 0.127899542450905, 0.127648904919624, 0.127398476004601, 0.127148434519768, 0.126898646354675, 0.126649469137192, 0.126400470733643, 0.126151785254478, 0.125903472304344, 0.125655561685562, 0.12540790438652, 0.125160604715347, 0.124913610517979, 0.124667257070541, 0.124420918524265, 0.124175190925598, 0.123929552733898, 0.123684354126453, 0.123439446091652, 0.123195007443428, 0.122950784862041, 0.12270712852478, 0.122463762760162, 0.122220553457737, 0.121977843344212, 0.121735438704491, 0.121493354439735, 0.121251657605171, 0.121010206639767, 0.120769329369068, 0.120528638362885, 0.12028831243515, 0.120048329234123, 0.119808711111546, 0.119569294154644, 0.119330428540707, 0.119091913104057, 0.118853658437729, 0.118615753948689, 0.118378154933453, 0.118141002953053, 0.117904111742973, 0.117667578160763, 0.117431432008743, 0.117195799946785, 0.116960272192955, 0.116725042462349, 0.116490177810192, 0.116255909204483, 0.116021789610386, 0.115788027644157, 0.115554578602314, 0.115321725606918, 0.11508896946907, 0.114856578409672, 0.114624686539173, 0.114393047988415, 0.114161714911461, 0.11393067240715, 0.113700047135353, 0.113469876348972, 0.113239899277687, 0.113010331988335, 0.112781122326851, 0.112552218139172, 0.112323708832264, 0.112095504999161, 0.11186771094799, 0.111640319228172, 0.111413173377514, 0.111186340451241, 0.110959805548191, 0.110733717679977, 0.110507898032665, 0.110282622277737, 0.110057659447193, 0.109832838177681, 0.109608523547649, 0.109384469687939, 0.109160758554935, 0.108937509357929, 0.108714506030083, 0.108491711318493, 0.108269520103931, 0.108047641813755, 0.107825949788094, 0.107604779303074, 0.107383899390697, 0.107163324952126, 0.106943160295486, 0.106723293662071, 0.106503836810589, 0.106284573674202, 0.10606587678194, 0.10584732145071, 0.105629123747349, 0.105411484837532, 0.105193994939327, 0.10497685521841, 0.104760274291039, 0.104543849825859, 0.104327827692032, 0.104112155735493, 0.103896737098694, 0.103681728243828, 0.103467009961605, 0.103252910077572, 0.103038862347603, 0.102825209498405, 0.102611906826496, 0.1023990213871, 0.102186433970928, 0.101974196732044, 0.101762369275093, 0.101550839841366, 0.101339772343636, 0.101128749549389, 0.100918382406235, 0.100708164274693, 0.100498303771019, 0.100288905203342, 0.100079759955406, 0.0998711511492729, 0.099662609398365, 0.0994546189904213, 0.0992469415068626, 0.0990394502878189, 0.0988325253129005, 0.0986257940530777, 0.0984195247292519, 0.0982136577367783, 0.098007895052433, 0.0978027284145355, 0.0975976213812828, 0.0973930656909943, 0.0971888676285744, 0.0969848185777664, 0.0967813283205032, 0.0965782329440117, 0.0963754057884216, 0.0961729139089584, 0.0959706380963326, 0.0957689210772514, 0.0955673009157181, 0.0953662768006325, 0.0951654687523842, 0.0949650481343269, 0.0947649478912354, 0.0945651978254318, 0.0943658426403999, 0.0941667929291725, 0.0939682051539421, 0.0937697216868401, 0.0935719385743141, 0.0933742076158524, 0.0931767299771309, 0.0929797515273094, 0.0927831307053566, 0.0925869196653366, 0.0923910066485405, 0.0921953916549683, 0.0920003429055214, 0.0918054431676865, 0.0916109383106232, 0.091416597366333, 0.091222807765007, 0.0910293683409691, 0.0908360853791237, 0.0906433090567589, 0.0904509350657463, 0.0902589038014412, 0.0900687426328659, 0.0898813679814339, 0.0896943062543869, 0.0895073786377907, 0.0893207713961601, 0.0891343057155609, 0.0889482945203781, 0.0887623354792595, 0.0885765329003334, 0.0883910804986954, 0.0882058814167976, 0.0880208313465118, 0.0878360942006111, 0.0876516923308372, 0.0874673575162888, 0.0872832685709, 0.0870993807911873, 0.0869157984852791, 0.0867323204874992, 0.0865491852164268, 0.0863663107156754, 0.0861837491393089, 0.0860012695193291, 0.0858191028237343, 0.0856370851397514, 0.0854553207755089, 0.0852737575769424, 0.0850925520062447, 0.0849114507436752, 0.0847307965159416, 0.0845501944422722, 0.0843698382377625, 0.0841896459460258, 0.0840099081397057, 0.0838302075862885, 0.0836507752537727, 0.0834715887904167, 0.0832927599549294, 0.0831140205264091, 0.082935594022274, 0.0827572643756866, 0.0825792998075485, 0.0824015215039253, 0.0822239518165588, 0.0820465832948685, 0.0818696245551109, 0.0816927626729012, 0.0815161541104317, 0.0813397392630577, 0.0811636298894882, 0.0809876918792725, 0.0808120369911194, 0.080636739730835, 0.0804614424705505, 0.0802864506840706, 0.0801116600632668, 0.0799371749162674, 0.0797629430890083, 0.079588808119297, 0.0794149786233902, 0.0792415961623192, 0.0790681764483452, 0.0788950622081757, 0.0787221863865852, 0.0785495117306709, 0.0783770978450775, 0.0782048925757408, 0.0780329257249832, 0.077861376106739, 0.0776898637413979, 0.0775186121463776, 0.0773476138710976, 0.0771767646074295, 0.0770062208175659, 0.076835922896862, 0.0766657292842865, 0.0764960497617722, 0.0763265118002892, 0.0761570781469345, 0.0759878978133202, 0.0758190229535103, 0.0756502971053123, 0.0754818767309189, 0.0753135979175568, 0.0751457288861275, 0.0749780684709549, 0.0748105049133301, 0.0746431946754456, 0.0744761303067207, 0.0743092820048332, 0.0741427168250084, 0.0739763751626015, 0.0738103166222572, 0.0736445263028145, 0.0734788328409195, 0.0733133852481842, 0.0731482058763504, 0.0729832127690315, 0.0728185325860977, 0.0726541504263878, 0.072489820420742, 0.0723259001970291, 0.0721620693802834, 0.0719985514879227, 0.0718351826071739, 0.0716720670461655, 0.0715092495083809, 0.0713466852903366, 0.0711842775344849, 0.0710222199559212, 0.07086031883955, 0.070698618888855, 0.0705371201038361, 0.0703758597373962, 0.0702148675918579, 0.0700542256236076, 0.0698936358094215, 0.0697334483265877, 0.0695733204483986, 0.0694135800004005, 0.0692539513111115, 0.0690945684909821, 0.0689353942871094, 0.0687766745686531, 0.0686179548501968, 0.0684596449136734, 0.0683013796806335, 0.0681434646248817, 0.0679857507348061, 0.0678281933069229, 0.0676709339022636, 0.067514032125473, 0.0673572868108749, 0.0672007352113724, 0.0670444443821907, 0.0668882951140404, 0.0667325109243393, 0.0665767639875412, 0.0664215907454491, 0.0662663504481316, 0.0661114677786827, 0.0659567937254906, 0.0658023208379745, 0.0656480938196182, 0.0654940754175186, 0.0653402581810951, 0.0651869401335716, 0.0650335699319839, 0.0648806095123291, 0.0647277012467384, 0.0645751953125, 0.0644227862358093, 0.0642706900835037, 0.0641186907887459, 0.0639671385288239, 0.063815750181675, 0.0636646598577499, 0.0635136216878891, 0.0633629336953163, 0.0632123947143555, 0.0630621165037155, 0.0629120394587517, 0.0627624094486237, 0.0626128390431404, 0.062463566660881, 0.0623144470155239, 0.0621655769646168, 0.0620169602334499, 0.0618685558438301, 0.0617203935980797, 0.0615725815296173, 0.0614248812198639, 0.0612774789333344, 0.061130229383707, 0.0609832778573036, 0.0608364343643188, 0.060689888894558, 0.0605437010526657, 0.0603976659476757, 0.0602517798542976, 0.0601062476634979, 0.0599608644843102, 0.059815738350153, 0.0596708618104458, 0.0595261417329311, 0.0593818686902523, 0.0592376515269279, 0.0590937845408916, 0.058950025588274, 0.0588065125048161, 0.0586632564663887, 0.0585201978683472, 0.0583773963153362, 0.0582349449396133, 0.0580925457179546, 0.0579505525529385, 0.0578086599707603, 0.0576670654118061, 0.0575256235897541, 0.057384442538023, 0.0572435036301613, 0.0571029260754585, 0.0569624528288841, 0.0568223260343075, 0.0566822476685047, 0.0565425753593445, 0.0564029589295387, 0.0562636405229568, 0.0561245791614056, 0.0559858679771423, 0.0558472089469433, 0.0557089522480965, 0.0555708482861519, 0.0554328970611095, 0.0552952438592911, 0.0551577508449554, 0.0550207570195198, 0.0548837147653103, 0.0547469258308411, 0.054610587656498, 0.0544743053615093, 0.0543382726609707, 0.054202388972044, 0.0540668666362762, 0.0539316907525063, 0.0537964664399624, 0.0536615960299969, 0.0535270310938358, 0.0533926673233509, 0.0532585009932518, 0.0531245432794094, 0.0529907830059528, 0.052857480943203, 0.052724227309227, 0.0525911785662174, 0.0524585321545601, 0.0523259863257408, 0.0521936938166618, 0.052061602473259, 0.0519297122955322, 0.0517982803285122, 0.0516668483614922, 0.0515357181429863, 0.0514048375189304, 0.0512742139399052, 0.0511437393724918, 0.051013570278883, 0.0508835501968861, 0.0507539361715317, 0.0506244190037251, 0.0504952594637871, 0.0503662042319775, 0.0502373985946178, 0.0501087941229343, 0.0499804951250553, 0.0498524941504002, 0.0497245974838734, 0.0495969578623772, 0.0494696125388145, 0.0493423715233803, 0.0492154881358147, 0.0490888059139252, 0.0489622727036476, 0.0488361455500126, 0.0487101674079895, 0.0485843941569328, 0.0484588705003262, 0.0483335554599762, 0.0482085905969143, 0.0480837225914001, 0.0479591079056263, 0.0478348024189472, 0.0477106459438801, 0.0475867390632629, 0.0474630892276764, 0.0473396368324757, 0.0472165457904339, 0.047093503177166, 0.046970758587122, 0.0468483678996563, 0.046726081520319, 0.0466039963066578, 0.046482264995575, 0.0463607832789421, 0.0462394058704376, 0.0461182296276093, 0.0459973588585854, 0.0458768419921398, 0.0457564741373062, 0.0456362590193748, 0.0455163978040218, 0.0453966818749905, 0.0452772229909897, 0.0451579205691814, 0.0450390689074993, 0.0449202209711075, 0.0448017194867134, 0.0446833744645119, 0.0445653311908245, 0.0444475933909416, 0.0443299524486065, 0.044212568551302, 0.0440954864025116, 0.0439786054193974, 0.0438619293272495, 0.0437453985214233, 0.0436292253434658, 0.0435134060680866, 0.0433976873755455, 0.0432820729911327, 0.04316695779562, 0.0430518463253975, 0.0429370887577534, 0.0428225845098495, 0.0427081808447838, 0.0425940789282322, 0.0424802266061306, 0.0423666350543499, 0.042253240942955, 0.0421401001513004, 0.0420271083712578, 0.0419144742190838, 0.0418019406497478, 0.0416898056864738, 0.0415777787566185, 0.0414659529924393, 0.0413545295596123, 0.0412431582808495, 0.041132140904665, 0.0410213731229305, 0.0409107059240341, 0.0408003963530064, 0.0406902357935905, 0.040580328553915, 0.0404706746339798, 0.0403612703084946, 0.0402520224452019, 0.0401431247591972, 0.040034431964159, 0.0399259366095066, 0.0398175977170467, 0.0397096648812294, 0.0396018251776695, 0.0394942425191402, 0.0393869131803513, 0.0392797850072384, 0.0391730144619942, 0.0390663407742977, 0.0389599166810513, 0.0388538502156734, 0.0387479327619076, 0.0386421717703342, 0.0385366640985012, 0.038431454449892, 0.0383264981210232, 0.0382217466831207, 0.0381172001361847, 0.0380130484700203, 0.0379089042544365, 0.0378049612045288, 0.0377013646066189, 0.0375980287790298, 0.037494994699955, 0.0373920127749443, 0.0372892804443836, 0.0371870547533035, 0.0370847769081593, 0.0369828045368195, 0.0368810817599297, 0.0367795638740063, 0.0366782993078232, 0.0365772843360901, 0.0364764742553234, 0.036376066505909, 0.0362756103277206, 0.0361754521727562, 0.0360756553709507, 0.0359759517014027, 0.0358766578137875, 0.0357774160802364, 0.0356786213815212, 0.0355798825621605, 0.0354813970625401, 0.0353831127285957, 0.0352851822972298, 0.0351873524487019, 0.0350898243486881, 0.0349926017224789, 0.0348955802619457, 0.0347987599670887, 0.0347020924091339, 0.0346056781709194, 0.0345095656812191, 0.0344136543571949, 0.0343180485069752, 0.0342225469648838, 0.0341274924576283, 0.0340324901044369, 0.0339377447962761, 0.0338431522250175, 0.0337490104138851, 0.0336550213396549, 0.0335610806941986, 0.0334675945341587, 0.0333742126822472, 0.0332812331616879, 0.0331883057951927, 0.0330956317484379, 0.0330031551420689, 0.0329111404716969, 0.0328191667795181, 0.0327274017035961, 0.0326360389590263, 0.0325447805225849, 0.0324538238346577, 0.0323629640042782, 0.0322724618017673, 0.0321821644902229, 0.0320920646190643, 0.0320023223757744, 0.0319126769900322, 0.0318233855068684, 0.0317341946065426, 0.0316452570259571, 0.0315565280616283, 0.0314681939780712, 0.0313800163567066, 0.0312921442091465, 0.0312043186277151, 0.031116746366024, 0.0310295280069113, 0.0309424139559269, 0.0308556444942951, 0.0307691860944033, 0.0306827779859304, 0.0305967200547457, 0.0305108670145273, 0.0304252151399851, 0.0303397662937641, 0.0302546191960573, 0.0301696248352528, 0.0300850328058004, 0.0300004929304123, 0.0299164075404406, 0.0298323724418879, 0.0297485403716564, 0.0296650622040033, 0.0295816343277693, 0.0294986106455326, 0.0294157881289721, 0.0293332207947969, 0.0292508527636528, 0.0291687399148941, 0.0290868245065212, 0.0290051158517599, 0.0289237089455128, 0.0288424529135227, 0.028761550784111, 0.0286809019744396, 0.0286004040390253, 0.0285200085490942, 0.0284399650990963, 0.0283601749688387, 0.0282806362956762, 0.0282013528048992, 0.0281221698969603, 0.0280433893203735, 0.0279647130519152, 0.0278863366693258, 0.0278081130236387, 0.02773024328053, 0.0276524741202593, 0.0275750085711479, 0.0274977460503578, 0.0274207852780819, 0.0273441281169653, 0.0272674709558487, 0.0271911174058914, 0.0271150674670935, 0.0270392689853907, 0.0269636735320091, 0.0268882792443037, 0.0268132388591766, 0.0267382990568876, 0.0266636144369841, 0.0265891291201115, 0.0265149492770433, 0.0264409184455872, 0.0263671949505806, 0.0262937191873789, 0.0262204986065626, 0.0261475313454866, 0.0260746125131845, 0.026002049446106, 0.0259296856820583, 0.0258575789630413, 0.0257857702672482, 0.0257142186164856, 0.0256428178399801, 0.0255715660750866, 0.025497680529952, 0.0254218075424433, 0.0253459326922894, 0.0252701882272959, 0.0251946896314621, 0.0251192972064018, 0.0250440053641796, 0.0249687097966671, 0.0248936209827662, 0.0248186811804771, 0.0247437935322523, 0.0246690828353167, 0.0245945733040571, 0.0245201382786036, 0.0244457591325045, 0.024371525272727, 0.0242973938584328, 0.0242234673351049, 0.0241496134549379, 0.0240759644657373, 0.0240022875368595, 0.0239288136363029, 0.0238554421812296, 0.0237822216004133, 0.023709075525403, 0.023636082187295, 0.023563290014863, 0.0234906021505594, 0.0234179850667715, 0.0233454722911119, 0.0232730619609356, 0.0232008006423712, 0.023128692060709, 0.0230566821992397, 0.0229847766458988, 0.022913096472621, 0.0228413920849562, 0.0227699894458055, 0.022698612883687, 0.0226273126900196, 0.0225561652332544, 0.0224851164966822, 0.0224142707884312, 0.0223435498774052, 0.0222728308290243, 0.0222023893147707, 0.0221320483833551, 0.0220617074519396, 0.0219915453344584, 0.0219215340912342, 0.021851621568203, 0.021781912073493, 0.0217122808098793, 0.0216427464038134, 0.0215733163058758, 0.0215039867907763, 0.0214348342269659, 0.0213657803833485, 0.0212969053536654, 0.0212281830608845, 0.0211595110595226, 0.0210908893495798, 0.021022466942668, 0.0209541469812393, 0.0208860579878092, 0.0208179652690887, 0.0207500234246254, 0.0206822864711285, 0.0206145737320185, 0.0205470118671656, 0.0204795747995377, 0.0204122681170702, 0.0203450843691826, 0.0202780291438103, 0.0202110260725021, 0.0201443210244179, 0.0200776197016239, 0.020011069253087, 0.0199446212500334, 0.0198783222585917, 0.0198121257126331, 0.0197459794580936, 0.0196800343692303, 0.019614215940237, 0.0195485781878233, 0.0194829348474741, 0.0194175206124783, 0.0193521585315466, 0.019286947324872, 0.0192218106240034, 0.0191569272428751, 0.0190920457243919, 0.0190274138003588, 0.0189627837389708, 0.0188982542604208, 0.0188339781016111, 0.0187697019428015, 0.018705552443862, 0.0186416544020176, 0.0185777805745602, 0.018514109775424, 0.0184504389762878, 0.0183869227766991, 0.0183236300945282, 0.0182603634893894, 0.0181972254067659, 0.0181343108415604, 0.0180714502930641, 0.0180086903274059, 0.0179460793733597, 0.0178835466504097, 0.017821216955781, 0.0177589356899261, 0.0176968071609735, 0.0176348518580198, 0.0175730027258396, 0.0175112020224333, 0.0174495540559292, 0.0173881072551012, 0.0173266846686602, 0.0172654148191214, 0.0172041952610016, 0.017143253237009, 0.0170824639499187, 0.0170216485857964, 0.0169609598815441, 0.016900448128581, 0.0168400350958109, 0.0167797263711691, 0.0167195945978165, 0.0166595615446568, 0.0165997315198183, 0.016539953649044, 0.0164803005754948, 0.0164206717163324, 0.0163613203912973, 0.0163019970059395, 0.0162429008632898, 0.016183802857995, 0.0161250084638596, 0.0160661637783051, 0.0160074960440397, 0.0159488804638386, 0.0158904902637005, 0.0158321745693684, 0.0157740376889706, 0.0157159268856049, 0.0156580433249474, 0.0156002333387733, 0.0155425276607275, 0.0154849719256163, 0.0154275419190526, 0.015370212495327, 0.0153131103143096, 0.0152559094130993, 0.0151991117745638, 0.0151422368362546, 0.0150855658575892, 0.0150289703160524, 0.0149725517258048, 0.0149161824956536, 0.0148599399253726, 0.0148038249462843, 0.0147479865700006, 0.0146921491250396, 0.0146364374086261, 0.0145808765664697, 0.0145253436639905, 0.0144699849188328, 0.0144148040562868, 0.0143597749993205, 0.0143047450110316, 0.0142499441280961, 0.014195192605257, 0.014140541665256, 0.0140860937535763, 0.0140317715704441, 0.0139775257557631, 0.0139235062524676, 0.0138695137575269, 0.0138156460598111, 0.0137618808075786, 0.0137082664296031, 0.0136547023430467, 0.013601366430521, 0.0135481553152204, 0.0134951220825315, 0.013442138209939, 0.0133891822770238, 0.0133364517241716, 0.0132838478311896, 0.0132312690839171, 0.0131789436563849, 0.0131266685202718, 0.0130745694041252, 0.0130225727334619, 0.0129707017913461, 0.0129189314320683, 0.0128673128783703, 0.0128157455474138, 0.0127643793821335, 0.0127131147310138, 0.0126620270311832, 0.0126109896227717, 0.0125601030886173, 0.0125093441456556, 0.012458635494113, 0.012408128939569, 0.0123576978221536, 0.0123074185103178, 0.0122573412954807, 0.0122072892263532, 0.0121574401855469, 0.012107590213418, 0.0120578911155462, 0.0120083205401897, 0.0119589501991868, 0.0119096301496029, 0.0118605634197593, 0.0118114724755287, 0.0117625575512648, 0.011713769286871, 0.0116650303825736, 0.0116164442151785, 0.0115680852904916, 0.0115197757259011, 0.0114716701209545, 0.0114235635846853, 0.0113756339997053, 0.0113278049975634, 0.0112801026552916, 0.0112325018271804, 0.0111851543188095, 0.0111378813162446, 0.0110906334593892, 0.011043512262404, 0.0109966434538364, 0.0109497746452689, 0.0109030595049262, 0.0108564179390669, 0.0108100296929479, 0.0107637923210859, 0.0107175055891275, 0.0106714712455869, 0.0106255123391747, 0.0105796800926328, 0.0105338972061872, 0.010488317348063, 0.0104428380727768, 0.0103975366801023, 0.0103523107245564, 0.0103072617202997, 0.0102623132988811, 0.0102174403145909, 0.0101725934073329, 0.0101280501112342, 0.0100835813209414, 0.0100393164902925, 0.00999504886567593, 0.00995093490928411, 0.00990692246705294, 0.00986303575336933, 0.0098192747682333, 0.00977569073438644, 0.00973220728337765, 0.0096889017149806, 0.00964564643800259, 0.00960246659815311, 0.00955948885530233, 0.00951661262661219, 0.0094738369807601, 0.00943118799477816, 0.00938874203711748, 0.0093464208766818, 0.00930412579327822, 0.00926198251545429, 0.00921996403485537, 0.00917804799973965, 0.00913630891591311, 0.00909464526921511, 0.00905308220535517, 0.00901179853826761, 0.00897051393985748, 0.00892932992428541, 0.00888832379132509, 0.00884744245558977, 0.00880661327391863, 0.00876596104353666, 0.00872548297047615, 0.00868505891412497, 0.00864480994641781, 0.00860466156154871, 0.0085645392537117, 0.00852469448000193, 0.00848482549190521, 0.00844515860080719, 0.0084057180210948, 0.00836630258709192, 0.00832701381295919, 0.0082878265529871, 0.00824868958443403, 0.00820977985858917, 0.00817097164690495, 0.00813226401805878, 0.0080938097089529, 0.008055429905653, 0.00801705103367567, 0.00797884818166494, 0.00794072262942791, 0.00790279824286699, 0.00786505080759525, 0.00782730244100094, 0.00778980832546949, 0.00775241479277611, 0.00771504640579224, 0.00767782935872674, 0.00764068868011236, 0.0076038003899157, 0.00756696285679936, 0.0075302510522306, 0.00749371666461229, 0.00745730753988028, 0.00742089981213212, 0.00738469325006008, 0.00734858866780996, 0.00731266010552645, 0.00727673200890422, 0.00724100554361939, 0.00720548210665584, 0.00717010954394937, 0.00713471183553338, 0.00709941517561674, 0.00706432107836008, 0.00702935270965099, 0.00699448585510254, 0.00695969443768263, 0.00692518102005124, 0.0068907430395484, 0.00685640703886747, 0.00682214647531509, 0.00678796181455255, 0.00675400393083692, 0.0067201224155724, 0.00668636709451675, 0.00665281340479851, 0.00661936169490218, 0.0065859598107636, 0.00655263382941484, 0.00651948526501656, 0.0064865630120039, 0.0064536165446043, 0.00642094714567065, 0.00638830382376909, 0.00635578623041511, 0.00632337015122175, 0.00629108026623726, 0.00625891704112291, 0.00622698059305549, 0.00619506929069757, 0.00616336101666093, 0.00613157590851188, 0.00610017077997327, 0.00606873957440257, 0.00603743502870202, 0.00600630789995193, 0.00597533164545894, 0.00594435539096594, 0.00591363152489066, 0.00588288297876716, 0.00585243757814169, 0.00582204246893525, 0.00579169811680913, 0.00576155539602041, 0.00573148904368281, 0.00570154888555408, 0.00567181082442403, 0.00564217381179333, 0.00561263784766197, 0.00558317778632045, 0.00555384391918778, 0.00552463671192527, 0.00549563113600016, 0.00546665117144585, 0.00543789844959974, 0.0054092719219625, 0.00538072129711509, 0.00535224657505751, 0.00532387290149927, 0.00529570179060102, 0.00526763079687953, 0.00523968692868948, 0.00521191954612732, 0.00518427835777402, 0.00515666231513023, 0.00512917339801788, 0.00510181020945311, 0.00507462443783879, 0.00504753878340125, 0.00502058025449514, 0.0049937223084271, 0.00496704131364822, 0.00494051212444901, 0.00491403322666883, 0.00488768145442009, 0.00486145494505763, 0.00483535509556532, 0.00480948248878121, 0.00478353444486856, 0.00475788954645395, 0.00473224418237805, 0.00470680184662342, 0.00468143448233604, 0.0046561686322093, 0.00463105412200093, 0.00460614170879126, 0.00458123022690415, 0.0045565445907414, 0.00453193532302976, 0.00450742756947875, 0.00448302086442709, 0.00445876503363252, 0.00443466147407889, 0.00441073486581445, 0.00438680779188871, 0.00436313357204199, 0.00433948496356606, 0.00431601284071803, 0.00429256586357951, 0.00426929583773017, 0.00424615200608969, 0.00422326102852821, 0.00420029414817691, 0.00417758012190461, 0.00415496714413166, 0.00413243006914854, 0.0041100443340838, 0.00408773403614759, 0.00406557600945234, 0.0040436452254653, 0.00402171397581697, 0.00399990985170007, 0.00397825660184026, 0.00395678076893091, 0.00393533008173108, 0.00391408102586865, 0.00389285758137703, 0.00387181132100523, 0.00385101744905114, 0.0038301981985569, 0.00380950514227152, 0.00378904002718627, 0.0037685742136091, 0.00374826043844223, 0.00372809823602438, 0.00370801170356572, 0.0036881526466459, 0.00366836949251592, 0.00364866177551448, 0.00362915662117302, 0.00360967637971044, 0.00359032256528735, 0.00357112055644393, 0.00355214579030871, 0.00353327230550349, 0.00351444887928665, 0.00349575211293995, 0.00347715616226196, 0.00345871201716363, 0.00344034354202449, 0.00342225353233516, 0.00340413767844439, 0.0033862239215523, 0.00336836115457118, 0.00335067487321794, 0.00333308964036405, 0.00331560545600951, 0.00329827307723463, 0.00328114279545844, 0.00326401251368225, 0.00324713485315442, 0.00323018128983676, 0.00321353110484779, 0.003196956589818, 0.00318043259903789, 0.00316406018100679, 0.00314778881147504, 0.00313174468465149, 0.0031158528290689, 0.00309998542070389, 0.00308427005074918, 0.0030687062535435, 0.00305314245633781, 0.00303778075613081, 0.00302249472588301, 0.00300741102546453, 0.00299252942204475, 0.00297764758579433, 0.00296291755512357, 0.00294828857295215, 0.00293378601782024, 0.00291806412860751, 0.00290097808465362, 0.00288391089998186, 0.00286688143387437, 0.00284990924410522, 0.00283298711292446, 0.0028160591609776, 0.00279924459755421, 0.00278244889341295, 0.00276567856781185, 0.00274901580996811, 0.00273234001360834, 0.00271571520715952, 0.00269914697855711, 0.00268260412849486, 0.00266613042913377, 0.00264970795251429, 0.00263333530165255, 0.00261697568930686, 0.00260069174692035, 0.00258439523167908, 0.00256823119707406, 0.00255204201675951, 0.00253594154492021, 0.00251989113166928, 0.00250387215055525, 0.0024878412950784, 0.00247188564389944, 0.00245603127405047, 0.00244016433134675, 0.00242441100999713, 0.00240862602367997, 0.00239286618307233, 0.00237722671590745, 0.00236161868087947, 0.00234603579156101, 0.00233054137788713, 0.00231504696421325, 0.00229960936121643, 0.00228423508815467, 0.00226883566938341, 0.00225351820699871, 0.00223828270100057, 0.00222307885996997, 0.00220793206244707, 0.00219281017780304, 0.00217767595313489, 0.00216264254413545, 0.0021476976107806, 0.00213273381814361, 0.00211787130683661, 0.00210301484912634, 0.00208817096427083, 0.00207342836074531, 0.00205871718935668, 0.00204403139650822, 0.00202943384647369, 0.00201484910212457, 0.00200030859559774, 0.0019858565647155, 0.00197135377675295, 0.00195693969726562, 0.00194262631703168, 0.00192832585889846, 0.00191407569218427, 0.00189986370969564, 0.0018856767565012, 0.0018715214682743, 0.0018574483692646, 0.0018434067023918, 0.00182939681690186, 0.00181548786349595, 0.00180154736153781, 0.00178770779166371, 0.0017738874303177, 0.00176011747680604, 0.0017464169068262, 0.00173275440465659, 0.00171911076176912, 0.00170550495386124, 0.00169196235947311, 0.0016784641193226, 0.0016650288598612, 0.00165162526536733, 0.00163828488439322, 0.00162498862482607, 0.00161170505452901, 0.00159847817849368, 0.0015852766809985, 0.00157213839702308, 0.00155905063729733, 0.00154605135321617, 0.00153300142847002, 0.00152005883865058, 0.00150715431664139, 0.00149429391603917, 0.00148149661254138, 0.00146873749326915, 0.00145599711686373, 0.00144329445902258, 0.00143064896110445, 0.00141804735176265, 0.00140554085373878, 0.00139304040931165, 0.00138059060554951, 0.00136820401530713, 0.00135579204652458, 0.00134348752908409, 0.0013312145601958, 0.00131897313985974, 0.00130681390874088, 0.00129469251260161, 0.00128259020857513, 0.00127047509886324, 0.00125851179473102, 0.00124656083062291, 0.0012346669100225, 0.0012227981351316, 0.00121091690380126, 0.00119916186667979, 0.00118743849452585, 0.00117575295735151, 0.00116414332296699, 0.00115253357216716, 0.00114098703488708, 0.00112949090544134, 0.00111798231955618, 0.00110658083576709, 0.00109523022547364, 0.00108389207161963, 0.00107265496626496, 0.00106141169089824, 0.00105020625051111, 0.00103901349939406, 0.00102795951534063, 0.00101690564770252, 0.00100591487716883, 0.000994949485175312, 0.00098403450101614, 0.000973132264334708, 0.000962312158662826, 0.000951523659750819, 0.000940817117225379, 0.000930110632907599, 0.000919467303901911, 0.000908855639863759, 0.00089829444186762, 0.000887783826328814, 0.000877336307894439, 0.000866920338012278, 0.000856567639857531, 0.00084623385919258, 0.000835937971714884, 0.000825673632789403, 0.000815485196653754, 0.000805340823717415, 0.000795215542893857, 0.00078520382521674, 0.000775192165747285, 0.00076518690912053, 0.000755269953515381, 0.000745378318242729, 0.000735568872187287, 0.000725790858268738, 0.000716044509317726, 0.00070633611176163, 0.000696722359862179, 0.000687070772983134, 0.000677526521030813, 0.00066800758941099, 0.000658520148135722, 0.000649095978587866, 0.000639747537206858, 0.000630386464763433, 0.000621101236902177, 0.000611847615800798, 0.000602675951085985, 0.000593510747421533, 0.000584402354434133, 0.000575325568206608, 0.000566305592656136, 0.000557342544198036, 0.000548436306416988, 0.000539529952220619, 0.000530737452208996, 0.000521894311532378, 0.00051313970470801, 0.000504460767842829, 0.00049578829202801, 0.000487197801703587, 0.000478613685118034, 0.0004701116704382, 0.000461597024695948, 0.000453208747785538, 0.000444788864115253, 0.000436463742516935, 0.000428170111263171, 0.000419933465309441, 0.000411721994169056, 0.000403567362809554, 0.000395425449823961, 0.000387359235901386, 0.000379356206394732, 0.000371397443814203, 0.000363451283192262, 0.000355543044861406, 0.000347710534697399, 0.000339878140948713, 0.00033215936855413, 0.000324440596159548, 0.000316784979077056, 0.000309160997858271, 0.000301619118545204, 0.00029405188979581, 0.000286598427919671, 0.000279170286376029, 0.0002717926108744, 0.000264433852862567, 0.000257144623901695, 0.000249868026003242, 0.000242648296989501, 0.000235485364100896, 0.000228404547669925, 0.000221304828301072, 0.000214280880754814, 0.00020729485549964, 0.000200334077817388, 0.000193461688468233, 0.000186589371878654, 0.000179830691195093, 0.000173097316292115, 0.000166363926837221, 0.000159643168444745, 0.00015306135173887, 0.000146479578688741, 0.000139948358992115, 0.000133454945171252, 0.000127043691463768, 0.000120607219287194, 0.000114284404844511, 0.000107961619505659, 0.000101720863312948, 9.54864735831507e-05, 8.93342221388593e-05, 8.31882789498195e-05, 7.71497070672922e-05, 7.10731837898493e-05, 6.50725560262799e-05, 5.9147656429559e-05, 5.32607045897748e-05, 4.74053376819938e-05, 4.15815011365339e-05, 3.58587822120171e-05, 3.00917527056299e-05, 2.4438566470053e-05, 1.88105477718636e-05, 1.32204195324448e-05, 7.68090740166372e-06, 2.22337189370592e-06, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 7.55674599365588e-15, 1.42752855936124e-06, 4.37101698480546e-06, 7.31450427338132e-06, 1.02706253528595e-05, 1.32520126499003e-05, 1.62333999469411e-05, 1.92400530067971e-05, 2.22467060666531e-05, 2.52659920079168e-05, 2.82979108305881e-05, 3.13424607156776e-05, 3.43996471201535e-05, 3.74315677618142e-05, 4.05392856919207e-05, 4.36091031588148e-05, 4.67168210889213e-05, 4.98245353810489e-05, 5.29448843735736e-05, 5.60904991289135e-05, 5.92361138842534e-05, 6.24070016783662e-05, 6.55778858345002e-05, 6.87613937770948e-05, 7.19575400580652e-05, 7.51663246774115e-05, 7.83751092967577e-05, 8.16091560409404e-05, 8.48558338475414e-05, 8.81151499925181e-05, 9.13744588615373e-05, 9.46464060689323e-05, 9.79436154011637e-05, 0.000101240832009353, 0.000104563303466421, 0.000107885789475404, 0.00011122089199489, 0.000114568640128709, 0.00011792901204899, 0.000121302036859561, 0.00012468766362872, 0.000128073312225752, 0.00013148422294762, 0.000134907750179991, 0.000138343937578611, 0.000141780110425316, 0.000145241545396857, 0.000148702994920313, 0.000152177075506188, 0.000155663787154481, 0.000159163115313277, 0.000162675089086406, 0.000166199693921953, 0.000169736929819919, 0.000173286811332218, 0.000176849309355021, 0.000180424452992156, 0.000183999582077377, 0.000187599987839349, 0.000191175116924569, 0.000194813430425711, 0.000198426467250101, 0.000202064780751243, 0.000205715696210973, 0.000209379271836951, 0.000213055478525348, 0.000216744301724248, 0.000220445785089396, 0.000224159870413132, 0.000227873970288783, 0.000231613346841186, 0.000235352723393589, 0.000239117362070829, 0.000242894617258571, 0.000246671872446314, 0.00025046180235222, 0.000254264305112883, 0.000258092099102214, 0.000261919893091545, 0.000265747716184705, 0.000269600772298872, 0.000273479090537876, 0.000277344806818292, 0.000281235756119713, 0.000285126705421135, 0.000289030314888805, 0.0002929717884399, 0.000296900689136237, 0.000300842162687331, 0.000304796296404675, 0.000308763061184436, 0.000312755088089034, 0.000316747085889801, 0.000320751743856817, 0.000324756401823834, 0.000328786351019517, 0.000332828902173787, 0.000336884084390476, 0.000340939295710996, 0.000345007108990103, 0.000349100184394047, 0.000353205949068069, 0.000357311655534431, 0.000361429993063211, 0.00036556099075824, 0.000369679357390851, 0.000373873510397971, 0.000378004508092999, 0.000382186000933871, 0.000386367551982403, 0.000390574336051941, 0.000394806382246315, 0.000399025826482102, 0.000403257843572646, 0.00040750254993327, 0.000411759858252481, 0.000416042457800359, 0.000420325028244406, 0.000424620258854702, 0.000428928120527416, 0.000433248613262549, 0.000437594339018688, 0.000441927462816238, 0.000446285848738626, 0.000450644234661013, 0.000455027882708237, 0.000459424161817878, 0.00046382044092752, 0.000468229351099581, 0.000472650892334059, 0.000477085093734786, 0.000481557159218937, 0.000486003962578252, 0.000490476028062403, 0.000494960811920464, 0.000499458168633282, 0.000503968098200858, 0.000508490717038512, 0.000513013335876167, 0.00051754858577624, 0.000522121728863567, 0.000526682182680815, 0.000531255325768143, 0.00053584115812555, 0.000540439563337713, 0.000545063230674714, 0.000549686956219375, 0.000554323254618794, 0.000558959553018212, 0.000563621113542467, 0.000568307936191559, 0.000572956865653396, 0.000577681639697403, 0.000582355831284076, 0.000587067974265665, 0.000591817952226847, 0.000596555299125612, 0.000601305335294455, 0.000606067944318056, 0.000610830611549318, 0.000615631171967834, 0.000620431732386351, 0.000625244865659624, 0.000630057998932898, 0.000634896452538669, 0.000639760168269277, 0.000644611252937466, 0.000649474968668073, 0.000654351257253438, 0.000659240293316543, 0.000664167164359242, 0.000669081404339522, 0.000673995586112142, 0.000678935088217258, 0.000683887221384794, 0.000688864674884826, 0.000693842070177197, 0.000698819465469569, 0.000703822122886777, 0.000708824780303985, 0.000713865330908448, 0.000718893308658153, 0.000723933859262615, 0.000728987040929496, 0.000734052853658795, 0.000739143928512931, 0.000744235061574727, 0.000749338767491281, 0.000754455162677914, 0.000759571557864547, 0.000764725788030773, 0.000769880076404661, 0.000775034306570888, 0.000780201226007193, 0.000785405980423093, 0.000790598103776574, 0.000795802916400135, 0.000801032991148531, 0.00080625043483451, 0.000811480509582907, 0.000816748477518559, 0.000822003814391792, 0.000827284413389862, 0.000832577585242689, 0.000837883446365595, 0.000843201938550919, 0.000848520430736244, 0.000853851553983986, 0.000859207939356565, 0.000864576955791563, 0.00086994597222656, 0.000875327677931637, 0.00088072195649147, 0.000886128866113722, 0.000891561037860811, 0.00089699326781556, 0.000902438070625067, 0.000907882873434573, 0.000913352996576577, 0.000918848323635757, 0.000924331019632518, 0.000929826404899359, 0.000935334421228617, 0.000940855010412633, 0.000946413550991565, 0.000951959402300417, 0.000957517884671688, 0.000963089114520699, 0.000968660227954388, 0.000974281865637749, 0.000979878241196275, 0.000985500053502619, 0.000991121749393642, 0.000996768590994179, 0.00100242823828012, 0.00100810045842081, 0.00101377267856151, 0.00101945747155696, 0.00102515507023782, 0.00103087769821286, 0.00103660044260323, 0.00104233587626368, 0.0010480711935088, 0.00105383188929409, 0.00105961773078889, 0.00106537842657417, 0.00107116438448429, 0.00107696291524917, 0.00108278670813888, 0.00108862319029868, 0.00109445955604315   }, 
}; 

// background map
float ReadLikelihoodPCA::fRefB[][10000] = 
{ 
   { 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 6.9545585e-08, 2.7818399e-07, 5.0855476e-07, 7.5196436e-07, 1.0388436e-06, 1.3648408e-06, 1.6995283e-06, 2.0646435e-06, 2.4645331e-06, 2.8731163e-06, 3.3208175e-06, 3.7989462e-06, 4.2770716e-06, 4.7986655e-06, 5.3593803e-06, 5.9287886e-06, 6.5286213e-06, 7.1675786e-06, 7.810876e-06, 8.5106822e-06, 9.1931006e-06, 9.9233312e-06, 1.0697033e-05, 1.1479425e-05, 1.2300935e-05, 1.3135485e-05, 1.400916e-05, 1.4900215e-05, 1.5813004e-05, 1.6756216e-05, 1.7725513e-05, 1.8712199e-05, 1.975104e-05, 2.0798579e-05, 2.1885227e-05, 2.2980583e-05, 2.4119394e-05, 2.5279945e-05, 2.6431795e-05, 2.7657541e-05, 2.8883287e-05, 3.0143809e-05, 3.1439104e-05, 3.2760472e-05, 3.409923e-05, 3.5477115e-05, 3.6859339e-05, 3.8267637e-05, 3.9719413e-05, 4.1192925e-05, 4.2701195e-05, 4.422685e-05, 4.5774254e-05, 4.7356418e-05, 4.8951639e-05, 5.057727e-05, 5.2242031e-05, 5.3911124e-05, 5.5628039e-05, 5.737539e-05, 5.913142e-05, 6.092657e-05, 6.2739105e-05, 6.4586427e-05, 6.6442437e-05, 6.8341906e-05, 7.0254413e-05, 7.2206043e-05, 7.4192445e-05, 7.6187556e-05, 7.8208737e-05, 8.0269034e-05, 8.2342369e-05, 8.4437437e-05, 8.6575979e-05, 8.8740599e-05, 9.0918256e-05, 9.3126342e-05, 9.5373536e-05, 9.7629425e-05, 9.9928788e-05, 0.00010224988, 0.00010456664, 0.00010694859, 0.00010934792, 0.00011176898, 0.00011422483, 0.00011669806, 0.00011920171, 0.00012172708, 0.00012426553, 0.00012684743, 0.00012946407, 0.00013208944, 0.00013476259, 0.00013745316, 0.00014015676, 0.00014290382, 0.00014566391, 0.00014844141, 0.00015125803, 0.0001541094, 0.00015697819, 0.00015987303, 0.000162807, 0.00016574965, 0.00016872709, 0.0001717393, 0.00017474715, 0.00017781151, 0.00018088458, 0.00018398807, 0.00018713503, 0.00019029502, 0.00019348977, 0.00019669758, 0.00019994019, 0.00020320015, 0.00020648619, 0.00020981571, 0.0002131626, 0.00021652688, 0.00021993462, 0.00022336411, 0.00022680662, 0.00023027958, 0.00023378296, 0.00023730371, 0.00024086794, 0.00024444956, 0.00024807462, 0.0002516997, 0.00025535957, 0.00025906292, 0.00026274883, 0.00026649563, 0.0002702685, 0.00027405872, 0.00027788812, 0.00028173486, 0.0002856077, 0.00028951533, 0.00029343599, 0.00029737398, 0.0003013555, 0.00030535873, 0.00030938373, 0.00031344779, 0.00031754232, 0.00032165422, 0.00032578784, 0.00032995627, 0.000334129, 0.00033834524, 0.00034258753, 0.00034685593, 0.0003511504, 0.00035547529, 0.00035983493, 0.00036421634, 0.00036858901, 0.0003730139, 0.00037747787, 0.00038195486, 0.00038646231, 0.00039100018, 0.00039555546, 0.00040015415, 0.00040475724, 0.00040937768, 0.00041404596, 0.0004187403, 0.0004234564, 0.00042819857, 0.00043297987, 0.00043777854, 0.00044258585, 0.00044744977, 0.0004523136, 0.00045721661, 0.00046213696, 0.00046709212, 0.00047207766, 0.00047708934, 0.00048213144, 0.00048718223, 0.00049227208, 0.00049737503, 0.00050250842, 0.00050768087, 0.00051287073, 0.00051808229, 0.0005233374, 0.00052861421, 0.0005339171, 0.00053921563, 0.00054457062, 0.00054995605, 0.000555359, 0.00056078791, 0.00056625588, 0.00057172397, 0.00057723548, 0.00058277743, 0.00058831932, 0.00059391779, 0.00059952494, 0.00060516247, 0.0006108348, 0.00061652897, 0.0006222665, 0.0006279996, 0.0006337763, 0.00063956168, 0.00064537744, 0.00065124105, 0.000657122, 0.00066301168, 0.00066895783, 0.00067491271, 0.0006809067, 0.00068690942, 0.00069292512, 0.00069900166, 0.00070508692, 0.00071119831, 0.00071734446, 0.00072350795, 0.00072971493, 0.00073593057, 0.00074216363, 0.00074843579, 0.0007547384, 0.00076106272, 0.00076742179, 0.00077380263, 0.00078020524, 0.00078664691, 0.00079310604, 0.00079958246, 0.00080608501, 0.00081262231, 0.00081919442, 0.00082577521, 0.00083239947, 0.00083904975, 0.00084571313, 0.00085241126, 0.00085911376, 0.00086586404, 0.0008726404, 0.00087944727, 0.00088627147, 0.0008931217, 0.00090001978, 0.00090691791, 0.00091385073, 0.00092080102, 0.00092779036, 0.00093480578, 0.0009418386, 0.00094890629, 0.00095599989, 0.00096311973, 0.0009702699, 0.00097741571, 0.00098460948, 0.00099184213, 0.00099908363, 0.0010063729, 0.0010136709, 0.0010209949, 0.0010283624, 0.0010357518, 0.0010431409, 0.0010505781, 0.0010580369, 0.0010655217, 0.0010730413, 0.0010805827, 0.0010881545, 0.0010957437, 0.0011033547, 0.0011109917, 0.0011186679, 0.0011263657, 0.001134094, 0.0011418441, 0.0011496157, 0.0011574222, 0.0011652461, 0.0011731136, 0.0011809811, 0.0011888961, 0.0011968244, 0.0012048004, 0.0012127808, 0.0012207874, 0.0012288416, 0.0012368959, 0.001244998, 0.0012531087, 0.0012612544, 0.0012694347, 0.0012776237, 0.001285865, 0.0012941104, 0.0013023908, 0.0013107015, 0.0013190167, 0.0013273751, 0.0013357599, 0.0013441748, 0.0013526028, 0.0013610702, 0.0013695634, 0.0013780742, 0.0013866196, 0.0013951781, 0.0014037756, 0.0014123952, 0.0014210404, 0.0014297294, 0.0014384183, 0.0014471506, 0.001455896, 0.0014646805, 0.001473478, 0.001482306, 0.0014911687, 0.0015000576, 0.0015089683, 0.0015179091, 0.0015268675, 0.0015358565, 0.0015448714, 0.0015539036, 0.0015629793, 0.0015720811, 0.0015812089, 0.0015903499, 0.0015995257, 0.0016087318, 0.0016179467, 0.0016272094, 0.0016364894, 0.0016457911, 0.001655132, 0.0016644902, 0.0016738789, 0.0016833025, 0.0016927347, 0.0017022016, 0.001711686, 0.0017212006, 0.0017307416, 0.0017403214, 0.0017499188, 0.0017595423, 0.001769183, 0.0017788499, 0.0017885688, 0.001798288, 0.0018080416, 0.0018178218, 0.0018276364, 0.0018374728, 0.0018473353, 0.001857228, 0.001867121, 0.0018770705, 0.0018870286, 0.0018970171, 0.001907049, 0.0019170855, 0.0019271652, 0.001937271, 0.0019473856, 0.0019575309, 0.0019677018, 0.0019779163, 0.0019881397, 0.0019983978, 0.0020086903, 0.0020189921, 0.0020293412, 0.0020396991, 0.0020500703, 0.002060489, 0.0020709296, 0.0020813921, 0.0020918935, 0.0021024123, 0.0021129572, 0.0021235368, 0.0021341296, 0.0021447658, 0.0021554062, 0.0021660901, 0.0021767917, 0.0021875191, 0.0021982815, 0.0022090697, 0.0022198753, 0.0022307027, 0.0022415735, 0.0022524488, 0.0022633763, 0.0022743212, 0.0022853008, 0.0022962932, 0.0023073119, 0.0023183699, 0.0023294233, 0.00234052, 0.0023516605, 0.002362805, 0.0023739892, 0.0023851988, 0.0023964264, 0.0024076928, 0.0024189807, 0.002430269, 0.0024416137, 0.0024529845, 0.0024643813, 0.002475787, 0.0024872357, 0.002498711, 0.0025101991, 0.0025217133, 0.0025332666, 0.0025448329, 0.0025564427, 0.0025680787, 0.0025797277, 0.0025914069, 0.0026031253, 0.0026148527, 0.0026265972, 0.0026383896, 0.0026501995, 0.0026620396, 0.0026739102, 0.0026858067, 0.0026977297, 0.0027096784, 0.0027216449, 0.0027336283, 0.0027456512, 0.0027577085, 0.0027697748, 0.0027818847, 0.0027940203, 0.0028061734, 0.0028183614, 0.0028305668, 0.0028427851, 0.0028550469, 0.0028673389, 0.0028796617, 0.0028919887, 0.0029043681, 0.00291676, 0.0029291785, 0.002941614, 0.0029540847, 0.0029665811, 0.0029791081, 0.0029916656, 0.003004249, 0.0030168453, 0.0030294855, 0.0030421428, 0.0030548088, 0.0030675184, 0.003080254, 0.0030930198, 0.003105812, 0.0031186303, 0.0031314746, 0.0031443362, 0.0031572415, 0.003170142, 0.003183095, 0.0031960742, 0.0032101353, 0.0032252963, 0.0032404833, 0.0032557487, 0.0032710314, 0.003286375, 0.0033017446, 0.0033171752, 0.0033326319, 0.003348158, 0.0033637187, 0.0033793317, 0.003394997, 0.0034106884, 0.0034264144, 0.0034421927, 0.0034580317, 0.0034739228, 0.0034898489, 0.0035058272, 0.0035218312, 0.0035378877, 0.0035539961, 0.0035701222, 0.0035863265, 0.0036025655, 0.003618848, 0.0036351737, 0.0036515519, 0.0036679734, 0.0036844299, 0.0037009555, 0.0037174902, 0.0037340769, 0.0037507333, 0.0037674154, 0.0037841587, 0.0038009365, 0.0038177755, 0.0038346231, 0.0038515402, 0.0038685007, 0.0038855043, 0.0039025608, 0.0039196601, 0.0039367769, 0.0039539724, 0.0039712028, 0.0039884932, 0.0040057926, 0.0040231529, 0.0040405565, 0.0040580132, 0.0040755211, 0.0040930728, 0.0041106595, 0.0041283066, 0.0041459715, 0.0041636797, 0.0041814572, 0.0041992785, 0.0042171343, 0.0042350511, 0.004252994, 0.004270989, 0.0042890357, 0.0043071266, 0.0043252432, 0.0043434207, 0.0043616416, 0.0043798974, 0.0043982142, 0.0044165831, 0.0044349865, 0.0044534337, 0.0044719158, 0.0044904407, 0.0045090187, 0.0045276568, 0.0045463294, 0.0045650462, 0.0045837974, 0.0046026097, 0.0046214652, 0.0046403562, 0.0046592983, 0.0046782931, 0.0046973052, 0.0047163954, 0.0047355294, 0.0047546895, 0.0047739102, 0.0047931746, 0.0048124474, 0.0048317984, 0.0048511932, 0.0048706313, 0.0048901299, 0.0049096639, 0.0049292236, 0.0049488437, 0.0049685081, 0.0049882075, 0.0050079669, 0.0050277701, 0.0050475905, 0.0050674807, 0.0050874315, 0.0051074172, 0.0051274467, 0.0051475107, 0.0051676007, 0.0051877694, 0.0052079721, 0.0052282275, 0.0052485177, 0.0052688597, 0.0052892365, 0.0053096744, 0.0053301295, 0.0053506456, 0.0053712311, 0.0053918343, 0.0054124808, 0.0054331883, 0.0054539302, 0.0054747243, 0.0054955706, 0.0055164346, 0.0055373418, 0.0055583185, 0.0055793389, 0.0056004021, 0.005621518, 0.0056426777, 0.0056638634, 0.0056850919, 0.0057063727, 0.0057277065, 0.0057490827, 0.0057705119, 0.0057919752, 0.0058134738, 0.0058350419, 0.0058566527, 0.0058782906, 0.0058999714, 0.0059217131, 0.0059434809, 0.0059653097, 0.0059871906, 0.0060091065, 0.0060310741, 0.0060530943, 0.0060751052, 0.0060972036, 0.0061193542, 0.0061415476, 0.0061637764, 0.0061860657, 0.0062083728, 0.0062307408, 0.0062531605, 0.0062756063, 0.006298122, 0.0063206544, 0.0063432395, 0.0063658766, 0.0063885753, 0.006411308, 0.0064340844, 0.0064569125, 0.0064797495, 0.0065026563, 0.0065256157, 0.0065486175, 0.0065716631, 0.0065947608, 0.0066178762, 0.0066410699, 0.0066642812, 0.0066875354, 0.0067108683, 0.0067342268, 0.0067576207, 0.0067810663, 0.006804564, 0.0068281139, 0.0068516987, 0.006875318, 0.0068989722, 0.0069226963, 0.0069464725, 0.0069702831, 0.0069941459, 0.0070180437, 0.0070419675, 0.0070659695, 0.0070899976, 0.0071140779, 0.007138202, 0.0071623782, 0.0071865711, 0.0072108423, 0.0072351578, 0.0072594988, 0.0072839092, 0.0073083374, 0.0073328172, 0.0073573496, 0.0073819165, 0.0074065449, 0.0074312161, 0.0074559315, 0.0074806809, 0.0075054737, 0.0075303097, 0.0075552077, 0.007580149, 0.007605142, 0.0076301442, 0.0076552145, 0.0076803472, 0.0077055055, 0.0077307071, 0.0077559524, 0.0077812406, 0.0078065908, 0.0078319749, 0.0078574196, 0.0078828996, 0.0079084132, 0.0079339808, 0.0079595735, 0.0079852454, 0.0080109425, 0.0080366991, 0.0080625024, 0.0080883214, 0.008114201, 0.0081401411, 0.0081661083, 0.0081921183, 0.0082181888, 0.008244277, 0.0082704443, 0.0082966452, 0.0083228899, 0.0083491793, 0.0083755283, 0.0084018949, 0.0084282961, 0.0084547764, 0.0084812893, 0.0085078487, 0.0085344575, 0.0085611111, 0.0085877823, 0.0086145401, 0.0086413147, 0.0086681331, 0.0086950222, 0.0087219365, 0.0087488946, 0.0087759132, 0.0088029578, 0.0088300547, 0.0088572195, 0.0088843871, 0.0089116227, 0.0089388937, 0.0089662243, 0.0089935996, 0.0090210186, 0.0090484889, 0.0090759769, 0.009103518, 0.0091311093, 0.0091587538, 0.0091864504, 0.009214174, 0.0092419395, 0.0092697665, 0.0092976382, 0.0093255341, 0.0093535092, 0.0093814926, 0.0094095282, 0.0094376327, 0.0094657643, 0.009493948, 0.0095221754, 0.0095504448, 0.0095787598, 0.0096071083, 0.0096355081, 0.0096639711, 0.0096924752, 0.009721024, 0.0097495904, 0.0097782249, 0.0098069049, 0.0098356362, 0.0098643936, 0.0098932115, 0.0099220462, 0.0099509517, 0.0099799009, 0.0100089, 0.010037945, 0.010067024, 0.010096137, 0.010125294, 0.01015453, 0.010183801, 0.010213105, 0.010242462, 0.010271844, 0.010301298, 0.010330768, 0.010360325, 0.010389891, 0.010419517, 0.01044917, 0.010478901, 0.010508649, 0.010538459, 0.010568311, 0.010598199, 0.010628129, 0.010658103, 0.010688148, 0.010718226, 0.010748347, 0.010778514, 0.010808714, 0.010838966, 0.010869245, 0.010899602, 0.010929993, 0.010960428, 0.010990907, 0.011021429, 0.011051994, 0.01108262, 0.011113273, 0.011143978, 0.011174734, 0.011205507, 0.01123636, 0.011267238, 0.011298169, 0.011329161, 0.011360178, 0.011391221, 0.011422344, 0.011453483, 0.011484691, 0.011515943, 0.011547239, 0.011578551, 0.011609944, 0.011641379, 0.011672839, 0.011704353, 0.011735908, 0.011767508, 0.01179916, 0.011830864, 0.011862612, 0.011894396, 0.01192623, 0.011958082, 0.011990012, 0.012021977, 0.012053985, 0.012086046, 0.012118159, 0.012150298, 0.012182498, 0.012214731, 0.012247002, 0.012279322, 0.012311714, 0.012344122, 0.012376574, 0.012409087, 0.012441644, 0.012474243, 0.012506885, 0.012539564, 0.012572285, 0.012605077, 0.012637901, 0.01267077, 0.012703683, 0.01273664, 0.012769648, 0.012802674, 0.012835786, 0.012868916, 0.012902098, 0.012935324, 0.012968602, 0.013001923, 0.013035287, 0.013068696, 0.013102138, 0.013135633, 0.013169172, 0.013202754, 0.013236405, 0.013270091, 0.013303821, 0.013337578, 0.013371385, 0.013405246, 0.01343914, 0.013473105, 0.013507104, 0.013541113, 0.013575215, 0.013609345, 0.013643536, 0.013677735, 0.013712004, 0.013746307, 0.013780654, 0.013815071, 0.013849513, 0.013884, 0.013918546, 0.01395312, 0.013987727, 0.014022404, 0.014057118, 0.014091881, 0.014126698, 0.014161538, 0.014196443, 0.014231372, 0.014266362, 0.014301396, 0.014336464, 0.014371586, 0.014406741, 0.014441958, 0.014477218, 0.014512529, 0.014547876, 0.014583277, 0.014618673, 0.014654159, 0.014689699, 0.014725271, 0.014760888, 0.014796554, 0.014832251, 0.014868014, 0.014903795, 0.014939629, 0.01497553, 0.015011461, 0.015047434, 0.015083467, 0.015119527, 0.015155646, 0.01519181, 0.01522799, 0.015264234, 0.015300528, 0.015336866, 0.015373264, 0.015409697, 0.015446173, 0.015482676, 0.01551924, 0.015555847, 0.015592499, 0.0156292, 0.01566595, 0.015702721, 0.015739555, 0.015776457, 0.015813384, 0.015850341, 0.015887348, 0.015924398, 0.0159615, 0.015998656, 0.016035847, 0.016073087, 0.01611039, 0.01614771, 0.016185056, 0.016222481, 0.016259959, 0.016297469, 0.016335033, 0.016372623, 0.016411664, 0.016452445, 0.016493257, 0.016534124, 0.016575027, 0.016615955, 0.016656933, 0.016697966, 0.016739042, 0.01678016, 0.016821314, 0.016862486, 0.016903745, 0.016945029, 0.016986364, 0.017027726, 0.017069159, 0.017110592, 0.017152084, 0.017193638, 0.017235225, 0.01727685, 0.017318534, 0.017360225, 0.017401988, 0.017443795, 0.017485643, 0.017527536, 0.017569473, 0.017611418, 0.017653432, 0.0176955, 0.01773761, 0.017779754, 0.017821943, 0.017864138, 0.017906431, 0.01794876, 0.017991113, 0.018033525, 0.018075965, 0.018118434, 0.018160962, 0.018203557, 0.018246181, 0.018288838, 0.018331539, 0.018374266, 0.018417062, 0.018459903, 0.018502779, 0.018545704, 0.018588677, 0.018631665, 0.018674713, 0.018717796, 0.018760933, 0.01880412, 0.018847326, 0.018890584, 0.018933877, 0.01897724, 0.019020634, 0.019064076, 0.019107549, 0.01915106, 0.019194612, 0.019238235, 0.019281885, 0.019325593, 0.019369312, 0.019413084, 0.019456897, 0.019500781, 0.01954468, 0.019588625, 0.01963263, 0.019676661, 0.019720728, 0.019764856, 0.019809008, 0.019853238, 0.019897468, 0.019941771, 0.019986099, 0.020030476, 0.020074915, 0.020119373, 0.020163875, 0.020208437, 0.020253014, 0.020297654, 0.020342346, 0.020387072, 0.020431826, 0.020476647, 0.020521488, 0.020566389, 0.020611333, 0.020656319, 0.020701341, 0.020746399, 0.020791501, 0.020836653, 0.020881874, 0.020927105, 0.020972371, 0.021017699, 0.021063069, 0.021108489, 0.021153938, 0.021199431, 0.021244975, 0.021290552, 0.021336183, 0.02138184, 0.021427557, 0.02147332, 0.021519115, 0.021564964, 0.021610821, 0.021656765, 0.021702724, 0.021748748, 0.021794805, 0.021840904, 0.02188703, 0.021933218, 0.021979468, 0.022025723, 0.02207204, 0.022118401, 0.02216479, 0.022211246, 0.022257736, 0.022304261, 0.022350824, 0.022397436, 0.022444086, 0.022490803, 0.022537529, 0.02258434, 0.022631148, 0.022678029, 0.022724947, 0.022771889, 0.022818903, 0.022865951, 0.022913033, 0.022960167, 0.02300732, 0.023054551, 0.023101816, 0.023149105, 0.023196468, 0.023243846, 0.023291267, 0.023338748, 0.023386275, 0.023433819, 0.023481423, 0.023529079, 0.023576753, 0.023624497, 0.023672283, 0.023720097, 0.023767943, 0.023815861, 0.023863794, 0.023911782, 0.023959821, 0.024007894, 0.024056012, 0.024104189, 0.024152376, 0.024200624, 0.024248924, 0.024297249, 0.024345627, 0.024394056, 0.024442513, 0.024491012, 0.024539566, 0.024588151, 0.024636798, 0.024685482, 0.024734197, 0.024782948, 0.024831761, 0.024880607, 0.024929492, 0.024978435, 0.02502742, 0.025076434, 0.025125513, 0.025174614, 0.025223749, 0.025272952, 0.025322201, 0.025371464, 0.025420789, 0.025470167, 0.02551957, 0.025569025, 0.025618527, 0.025668044, 0.025717627, 0.025767241, 0.025816923, 0.025866648, 0.025916383, 0.025966167, 0.026016016, 0.026065897, 0.026115814, 0.026165783, 0.026215795, 0.026265841, 0.02631595, 0.026366074, 0.026416253, 0.026466491, 0.026516773, 0.02656707, 0.026617432, 0.026667826, 0.026718248, 0.026768746, 0.026819279, 0.026869848, 0.026920443, 0.026971098, 0.027021788, 0.02707254, 0.027123334, 0.027174139, 0.027225003, 0.027275926, 0.027326886, 0.027377898, 0.027428929, 0.02748001, 0.027531143, 0.02758231, 0.027633533, 0.027684778, 0.027736077, 0.027787412, 0.027838796, 0.027890243, 0.027941708, 0.027993223, 0.028044775, 0.028096367, 0.028148014, 0.028199697, 0.028251447, 0.02830321, 0.028355028, 0.028406871, 0.028458763, 0.028510723, 0.028562699, 0.028614748, 0.028666826, 0.028718935, 0.028771078, 0.028823288, 0.028875535, 0.028927825, 0.028980156, 0.029032528, 0.02908494, 0.029137399, 0.029189901, 0.029242458, 0.029295051, 0.029347684, 0.029400345, 0.029453078, 0.029505827, 0.029558633, 0.029611498, 0.029664386, 0.029717302, 0.029770268, 0.029823288, 0.029876374, 0.02992947, 0.029982619, 0.030035794, 0.030089026, 0.030142298, 0.030195637, 0.030248998, 0.0303024, 0.030355845, 0.030409336, 0.030462887, 0.030516462, 0.030570073, 0.030623728, 0.030677425, 0.030731184, 0.030784989, 0.030838799, 0.030892704, 0.030946614, 0.031000571, 0.031054584, 0.031108636, 0.031162726, 0.031216869, 0.031271055, 0.031325255, 0.031379521, 0.031433836, 0.031488191, 0.031542595, 0.031597044, 0.031651497, 0.03170602, 0.031760585, 0.031815205, 0.031869855, 0.031924542, 0.031979274, 0.032034062, 0.032088887, 0.032143775, 0.032198664, 0.032253616, 0.032308597, 0.032363646, 0.032418728, 0.032473855, 0.032529034, 0.032584239, 0.032639481, 0.032694791, 0.032750111, 0.032805514, 0.032860935, 0.032916404, 0.032971919, 0.033027463, 0.033083063, 0.0331387, 0.033194385, 0.03325012, 0.033305872, 0.033361692, 0.033417556, 0.033473454, 0.033529408, 0.033585373, 0.033641402, 0.033697475, 0.033753589, 0.033809766, 0.033865947, 0.033922188, 0.033978462, 0.0340348, 0.034091182, 0.034147587, 0.034204055, 0.034260545, 0.034317087, 0.034373671, 0.034430292, 0.034486968, 0.034543682, 0.034600459, 0.034657244, 0.034714092, 0.03477098, 0.034827918, 0.034884889, 0.034941912, 0.034998957, 0.035056047, 0.035113204, 0.035170399, 0.035227634, 0.035284895, 0.035342216, 0.035399567, 0.03545697, 0.035514433, 0.03557191, 0.035629444, 0.035687018, 0.035744626, 0.03580229, 0.035859987, 0.035917737, 0.035975527, 0.036033377, 0.036091238, 0.03614914, 0.036207117, 0.036265127, 0.036323193, 0.036381271, 0.036439378, 0.036497567, 0.036555793, 0.036614049, 0.036672365, 0.036730703, 0.036789078, 0.036847521, 0.036906011, 0.036964525, 0.037023082, 0.0370817, 0.03714034, 0.037199035, 0.037257768, 0.037316542, 0.037375376, 0.037434246, 0.037493143, 0.037552092, 0.037611082, 0.037670113, 0.037729196, 0.03778832, 0.037847497, 0.037906691, 0.037965953, 0.038025238, 0.038084596, 0.038143974, 0.038203366, 0.038262844, 0.038322359, 0.038381912, 0.038441505, 0.038501151, 0.038560808, 0.038620532, 0.038680308, 0.038740136, 0.038799971, 0.038859878, 0.038919799, 0.038979795, 0.039039809, 0.039099883, 0.039159987, 0.039220151, 0.039280344, 0.039340597, 0.039400861, 0.039461177, 0.039521564, 0.039581973, 0.039642416, 0.039702911, 0.039763462, 0.039824046, 0.039884686, 0.039945349, 0.040006038, 0.040066805, 0.040127598, 0.040188447, 0.040249344, 0.040310267, 0.040371213, 0.040432245, 0.040493295, 0.040554408, 0.04061554, 0.040676732, 0.040737938, 0.040799227, 0.040860541, 0.040921893, 0.040983297, 0.041044742, 0.041106213, 0.041167762, 0.041229323, 0.041290935, 0.041352604, 0.041414309, 0.041476037, 0.04153781, 0.04159965, 0.041661516, 0.041723456, 0.041785412, 0.041847412, 0.041909438, 0.041971527, 0.042033669, 0.042095859, 0.042159423, 0.042224444, 0.042289499, 0.042354554, 0.042419646, 0.042484738, 0.042549852, 0.042614982, 0.042680137, 0.042745311, 0.042810485, 0.042875689, 0.042940903, 0.043006148, 0.043071397, 0.043136656, 0.043201961, 0.043267272, 0.043332588, 0.043397937, 0.043463286, 0.043528661, 0.043594062, 0.043659486, 0.043724902, 0.043790337, 0.043855812, 0.043921288, 0.043986794, 0.044052307, 0.044117827, 0.044183385, 0.044248965, 0.044314541, 0.044380143, 0.044445757, 0.044511393, 0.044577051, 0.044642728, 0.044708427, 0.044774115, 0.04483984, 0.044905573, 0.044971339, 0.045037124, 0.045102902, 0.045168716, 0.045234561, 0.045300405, 0.045366269, 0.045432135, 0.045498028, 0.045563955, 0.045629881, 0.045695845, 0.045761798, 0.045827795, 0.045893788, 0.045959812, 0.04602585, 0.046091899, 0.046157978, 0.046224076, 0.046290174, 0.046356305, 0.046422437, 0.046488591, 0.046554774, 0.046620969, 0.046687182, 0.046753403, 0.046819653, 0.046885915, 0.046952203, 0.047018502, 0.047084801, 0.047151137, 0.047217488, 0.047283862, 0.04735025, 0.047416646, 0.047483053, 0.047549505, 0.047615953, 0.047682431, 0.04774892, 0.047815427, 0.047881946, 0.047948498, 0.048015047, 0.048081625, 0.048148226, 0.048214823, 0.048281465, 0.048348118, 0.048414763, 0.048481442, 0.048548147, 0.048614867, 0.048681594, 0.048748333, 0.048815109, 0.048881896, 0.048948701, 0.049015522, 0.04908235, 0.049149211, 0.049216077, 0.049282975, 0.049349893, 0.049416799, 0.049483743, 0.049550712, 0.049617678, 0.049684681, 0.049751673, 0.049818709, 0.049885761, 0.049952827, 0.050019901, 0.050086994, 0.05015412, 0.050221242, 0.050288405, 0.050355565, 0.050422747, 0.050489951, 0.050557174, 0.050624412, 0.050691672, 0.050758936, 0.050826225, 0.05089353, 0.050960876, 0.051028207, 0.051095556, 0.051162932, 0.051230323, 0.05129775, 0.051365167, 0.051432598, 0.051500075, 0.051567554, 0.051635053, 0.051702578, 0.051770091, 0.051837645, 0.051905222, 0.051972803, 0.052040409, 0.05210802, 0.052175663, 0.052243318, 0.052311003, 0.052378688, 0.05244638, 0.052514102, 0.052581858, 0.05264961, 0.052717395, 0.052785177, 0.052852988, 0.052920826, 0.052988671, 0.053056542, 0.053124402, 0.05319231, 0.053260218, 0.053328171, 0.053396113, 0.053464074, 0.05353206, 0.053600065, 0.053668082, 0.053736132, 0.05380417, 0.05387225, 0.053940333, 0.054008439, 0.054076578, 0.05414471, 0.054212879, 0.054281041, 0.054349244, 0.05441745, 0.054485667, 0.054553915, 0.054622188, 0.054690477, 0.05475878, 0.054827083, 0.054895405, 0.054963764, 0.055032138, 0.055100523, 0.055168919, 0.055237345, 0.055305779, 0.055374235, 0.055442706, 0.055511184, 0.055579703, 0.055648223, 0.055716775, 0.055785332, 0.0558539, 0.055922482, 0.055991113, 0.056059737, 0.056128394, 0.056197044, 0.056265727, 0.056334425, 0.056403145, 0.056471881, 0.056540612, 0.056609388, 0.056678172, 0.056746986, 0.056815811, 0.056884639, 0.056953486, 0.057022378, 0.057091255, 0.057160173, 0.057229079, 0.057298023, 0.057366982, 0.057435967, 0.057504952, 0.057573959, 0.057642993, 0.057712033, 0.057781104, 0.057850193, 0.057919286, 0.05798839, 0.058057539, 0.058126688, 0.058195852, 0.058265042, 0.058334235, 0.058403462, 0.058472704, 0.058541946, 0.058611225, 0.058680508, 0.058749817, 0.058819145, 0.058888488, 0.058957838, 0.059027221, 0.059096627, 0.059166025, 0.059235454, 0.059304904, 0.059374347, 0.059443843, 0.059513342, 0.059582852, 0.059652388, 0.059721939, 0.059791509, 0.059861094, 0.059930697, 0.060000315, 0.060069945, 0.060139619, 0.060209282, 0.060278974, 0.060348675, 0.060418397, 0.060488146, 0.060557902, 0.060627684, 0.060697474, 0.060767282, 0.060837109, 0.060906962, 0.060976818, 0.061046708, 0.061116599, 0.061186533, 0.061256446, 0.061326396, 0.061396364, 0.061466351, 0.061536364, 0.061606377, 0.061676413, 0.061746474, 0.061816536, 0.061886624, 0.061956741, 0.062026862, 0.062096998, 0.062167153, 0.062237337, 0.062307533, 0.062377743, 0.062447965, 0.062518217, 0.062588491, 0.062658764, 0.062729068, 0.062799372, 0.062869705, 0.062940061, 0.063010432, 0.063080803, 0.063151218, 0.063221641, 0.063292064, 0.063362531, 0.063432999, 0.063503496, 0.063573994, 0.063644528, 0.06371507, 0.063785613, 0.063856199, 0.063926779, 0.063997403, 0.064068042, 0.064138681, 0.064209349, 0.064280018, 0.064350724, 0.064421445, 0.064492173, 0.064562924, 0.064633682, 0.064704485, 0.064775288, 0.064846098, 0.064916939, 0.064987786, 0.065058656, 0.065129563, 0.065200448, 0.065271385, 0.065342329, 0.065413274, 0.065484263, 0.065555252, 0.065626256, 0.06569729, 0.065768346, 0.065839402, 0.065910488, 0.065981597, 0.06605269, 0.066123828, 0.066194996, 0.066266142, 0.06633734, 0.066408537, 0.066479757, 0.066551007, 0.066622257, 0.066693522, 0.066764817, 0.066836119, 0.066907458, 0.066978782, 0.067050159, 0.067121521, 0.067192927, 0.067264326, 0.067335755, 0.067407206, 0.067478664, 0.067550153, 0.067621656, 0.067693166, 0.067764699, 0.067836247, 0.067907818, 0.067979395, 0.06805101, 0.068122618, 0.068194263, 0.068265915, 0.06833759, 0.068409279, 0.068480991, 0.06855271, 0.068624452, 0.068696216, 0.068767987, 0.068839781, 0.06891159, 0.068983421, 0.069055267, 0.069127128, 0.069199011, 0.069270909, 0.069342822, 0.069414757, 0.069486715, 0.069558688, 0.069630668, 0.06970267, 0.069774695, 0.069846727, 0.069918789, 0.069990851, 0.070062935, 0.07013505, 0.070207179, 0.070279323, 0.070351474, 0.070423648, 0.070495844, 0.070568055, 0.070640296, 0.070712537, 0.0707848, 0.070857085, 0.070929363, 0.071001686, 0.071074024, 0.071146376, 0.071218751, 0.071291134, 0.071363531, 0.071435951, 0.071508393, 0.071580842, 0.071653314, 0.071725808, 0.07179831, 0.071870841, 0.071943387, 0.072015934, 0.072088525, 0.072161108, 0.072233714, 0.07230635, 0.072378993, 0.072451659, 0.072524339, 0.072597042, 0.072669759, 0.072742485, 0.072815247, 0.072888002, 0.072960787, 0.073033608, 0.073106416, 0.07317926, 0.073252104, 0.073324986, 0.07339789, 0.073470779, 0.073543698, 0.073616639, 0.07368961, 0.073762581, 0.073835574, 0.073908597, 0.073981613, 0.074054666, 0.074127734, 0.074200809, 0.074273907, 0.074347027, 0.074420154, 0.074493311, 0.074566469, 0.074639656, 0.074712858, 0.074786089, 0.074859321, 0.074932568, 0.075005844, 0.075079121, 0.075152449, 0.07522577, 0.075299114, 0.07537248, 0.075445853, 0.075519249, 0.075592659, 0.075666085, 0.075739533, 0.075812995, 0.075886481, 0.075959973, 0.076033495, 0.076107018, 0.07618057, 0.076254137, 0.076327726, 0.076401331, 0.076474957, 0.076548584, 0.07662224, 0.076695919, 0.076769613, 0.076843679, 0.076918103, 0.076992519, 0.077066891, 0.077141248, 0.077215597, 0.077289909, 0.077364206, 0.077438474, 0.077512719, 0.077586949, 0.077661142, 0.077735327, 0.07780949, 0.077883616, 0.077957734, 0.07803183, 0.078105904, 0.078179948, 0.078253962, 0.078327976, 0.078401953, 0.078475915, 0.078549847, 0.078623757, 0.078697644, 0.078771509, 0.078845367, 0.078919195, 0.078992985, 0.079066768, 0.079140522, 0.079214253, 0.079287969, 0.079361662, 0.079435326, 0.07950896, 0.079582594, 0.079656199, 0.079729773, 0.079803333, 0.079876862, 0.07995037, 0.080023862, 0.080097325, 0.080170766, 0.080244191, 0.080317587, 0.080390975, 0.080464326, 0.080537654, 0.080610961, 0.080684252, 0.080757521, 0.08083076, 0.080903985, 0.080977179, 0.081050359, 0.081123509, 0.081196636, 0.081269749, 0.081342824, 0.081415892, 0.081488945, 0.081561953, 0.081634954, 0.081707925, 0.081780881, 0.081853807, 0.081926718, 0.081999607, 0.082072459, 0.082145311, 0.082218125, 0.082290925, 0.082363695, 0.08243645, 0.082509167, 0.082581885, 0.082654566, 0.082727239, 0.082799867, 0.08287248, 0.082945086, 0.083017647, 0.083090208, 0.083162732, 0.083235241, 0.083307728, 0.083380178, 0.08345262, 0.083525039, 0.083597422, 0.083669811, 0.083742149, 0.083814479, 0.083886772, 0.083959065, 0.084031329, 0.084103562, 0.084175773, 0.084247969, 0.084320143, 0.084392287, 0.084464416, 0.084536515, 0.0846086, 0.084680654, 0.084752701, 0.084824711, 0.084896699, 0.084968671, 0.085040614, 0.085112549, 0.08518444, 0.085256323, 0.085328184, 0.085400015, 0.085471831, 0.085543618, 0.085615389, 0.085687131, 0.085758857, 0.085830562, 0.085902236, 0.085973896, 0.086045526, 0.086117141, 0.086188734, 0.086260289, 0.086331844, 0.086403362, 0.086474866, 0.086546347, 0.08661779, 0.086689234, 0.08676064, 0.086832032, 0.086903401, 0.086974733, 0.087046057, 0.087117352, 0.087188639, 0.087259896, 0.087331131, 0.087402336, 0.087473527, 0.087544687, 0.08761584, 0.087686948, 0.087758049, 0.087829113, 0.087900177, 0.08797121, 0.088042222, 0.088113204, 0.088184163, 0.088255107, 0.088326044, 0.088396922, 0.088467799, 0.088538647, 0.088609479, 0.088680297, 0.088751078, 0.088821836, 0.088892579, 0.088963293, 0.089033991, 0.089104667, 0.089175321, 0.089245945, 0.089316562, 0.089387149, 0.089457698, 0.089528233, 0.089598753, 0.089669257, 0.089739725, 0.089810178, 0.089880601, 0.089951009, 0.090021387, 0.090091757, 0.090162084, 0.09023241, 0.090302691, 0.090372972, 0.090443216, 0.090513445, 0.090583652, 0.090653837, 0.090723999, 0.090794131, 0.090864249, 0.090934344, 0.091004401, 0.091074459, 0.091144487, 0.091214485, 0.091284469, 0.091354422, 0.091424361, 0.091494277, 0.091564164, 0.091634035, 0.091703892, 0.091773719, 0.091843508, 0.091913298, 0.09198305, 0.09205278, 0.092122495, 0.092192188, 0.092261851, 0.092331506, 0.092401125, 0.092470728, 0.092540309, 0.09260986, 0.092679396, 0.09274891, 0.092818402, 0.092887871, 0.09295731, 0.093026735, 0.09309613, 0.093165517, 0.093234867, 0.093304202, 0.093373515, 0.093442805, 0.093512073, 0.093581319, 0.093650535, 0.093719736, 0.093788907, 0.093858071, 0.093927205, 0.093996301, 0.094065398, 0.094134457, 0.094203509, 0.094272524, 0.094341516, 0.094410494, 0.094479442, 0.094548374, 0.0946173, 0.094686173, 0.094755046, 0.094823882, 0.094892703, 0.094961502, 0.095030271, 0.095099032, 0.095167749, 0.095236465, 0.095305152, 0.095373817, 0.095442452, 0.095511064, 0.095579661, 0.095648244, 0.095716782, 0.095785327, 0.095853828, 0.095922299, 0.09599077, 0.096059211, 0.096127629, 0.096196026, 0.096264392, 0.096332744, 0.096401073, 0.096469373, 0.096537657, 0.096605934, 0.096674167, 0.096742369, 0.096810579, 0.096878745, 0.096946895, 0.097015023, 0.097083122, 0.097151212, 0.097219259, 0.097287305, 0.097355321, 0.097423315, 0.097491279, 0.097559229, 0.097627155, 0.09769506, 0.097762942, 0.097830802, 0.097898632, 0.097966447, 0.098034248, 0.098102011, 0.098169759, 0.098237477, 0.098305181, 0.098372862, 0.09844052, 0.098508157, 0.098575763, 0.098643363, 0.098710939, 0.098778471, 0.098846003, 0.098913491, 0.098980978, 0.099048436, 0.099115871, 0.099183284, 0.099250667, 0.099318035, 0.099385388, 0.099452704, 0.099520013, 0.099587284, 0.09965454, 0.099721774, 0.099788986, 0.099856168, 0.099923342, 0.099990487, 0.10005762, 0.1001247, 0.10019178, 0.10025883, 0.10032587, 0.10039289, 0.10045986, 0.10052683, 0.10059378, 0.1006607, 0.1007276, 0.10079446, 0.10086133, 0.10092815, 0.10099496, 0.10106175, 0.10112851, 0.10119525, 0.10126197, 0.10132867, 0.10139535, 0.10146199, 0.10152862, 0.10159523, 0.10166182, 0.10172839, 0.10179493, 0.10186145, 0.10192794, 0.10199441, 0.10206086, 0.10212729, 0.1021937, 0.10226008, 0.10232645, 0.10239279, 0.1024591, 0.1025254, 0.10259167, 0.10265792, 0.10272415, 0.10279035, 0.10285654, 0.10292269, 0.10298884, 0.10305495, 0.10312104, 0.10318712, 0.10325316, 0.10331919, 0.1033852, 0.10345118, 0.10351714, 0.10358307, 0.10364899, 0.10371488, 0.10378075, 0.1038466, 0.10391243, 0.10397824, 0.10404401, 0.10410977, 0.10417552, 0.10424121, 0.10430691, 0.10437258, 0.10443823, 0.10450386, 0.10456946, 0.10463503, 0.1047006, 0.10476613, 0.10483164, 0.10489713, 0.1049626, 0.10502805, 0.10509346, 0.10515887, 0.10522425, 0.10528962, 0.10535495, 0.10542025, 0.10548555, 0.10555082, 0.10561606, 0.10568129, 0.10574648, 0.10581166, 0.10587681, 0.10594194, 0.10600706, 0.10607215, 0.10613722, 0.10620225, 0.10626727, 0.10633228, 0.10639726, 0.10646221, 0.10652713, 0.10659204, 0.10665695, 0.1067218, 0.10678665, 0.10685146, 0.10691626, 0.10698104, 0.10704579, 0.10711053, 0.10717523, 0.10723992, 0.10730459, 0.10736922, 0.10743385, 0.10749844, 0.10756303, 0.10762758, 0.1076921, 0.10775661, 0.10782109, 0.10788555, 0.10795, 0.10801441, 0.10807882, 0.10814318, 0.10820754, 0.10827187, 0.10833616, 0.10840046, 0.10846472, 0.10852896, 0.10859318, 0.10865737, 0.10872154, 0.10878569, 0.10884982, 0.10891394, 0.10897801, 0.10904208, 0.10910611, 0.10917013, 0.10923412, 0.10929809, 0.10936204, 0.10942596, 0.10948988, 0.10955375, 0.10961761, 0.10968145, 0.10974526, 0.10980906, 0.10987283, 0.10993658, 0.1100003, 0.110064, 0.11012769, 0.11019135, 0.11025497, 0.11031859, 0.11038218, 0.11044575, 0.11050931, 0.11057282, 0.11063633, 0.1106998, 0.11076327, 0.11082671, 0.11089011, 0.11095351, 0.11101688, 0.11108023, 0.11114356, 0.11120684, 0.11126909, 0.1113302, 0.11139128, 0.11145229, 0.11151323, 0.11157414, 0.11163497, 0.11169575, 0.11175648, 0.11181716, 0.11187777, 0.11193832, 0.11199883, 0.11205927, 0.11211966, 0.11217999, 0.11224025, 0.11230049, 0.11236064, 0.11242075, 0.11248079, 0.11254078, 0.11260071, 0.11266059, 0.11272041, 0.11278018, 0.11283989, 0.11289953, 0.11295913, 0.11301865, 0.11307815, 0.11313756, 0.11319694, 0.11325625, 0.11331549, 0.11337469, 0.11343383, 0.11349292, 0.11355195, 0.11361092, 0.11366984, 0.11372868, 0.1137875, 0.11384624, 0.11390492, 0.11396356, 0.11402214, 0.11408066, 0.11413912, 0.11419751, 0.11425587, 0.11431416, 0.11437239, 0.11443056, 0.11448868, 0.11454675, 0.11460476, 0.11466272, 0.11472061, 0.11477845, 0.11483623, 0.11489395, 0.11495163, 0.11500923, 0.11506679, 0.11512429, 0.11518173, 0.11523911, 0.11529645, 0.1153537, 0.11541092, 0.11546808, 0.11552519, 0.11558224, 0.11563922, 0.11569616, 0.11575302, 0.11580984, 0.11586662, 0.11592332, 0.11597995, 0.11603654, 0.11609309, 0.11614957, 0.11620598, 0.11626235, 0.11631866, 0.11637491, 0.11643111, 0.11648725, 0.11654333, 0.11659935, 0.11665532, 0.11671124, 0.11676709, 0.1168229, 0.11687863, 0.11693433, 0.11698995, 0.11704551, 0.11710104, 0.11715651, 0.1172119, 0.11726724, 0.11732253, 0.11737777, 0.11743294, 0.11748807, 0.11754312, 0.11759812, 0.11765309, 0.11770796, 0.1177628, 0.11781759, 0.11787229, 0.11792697, 0.11798159, 0.11803614, 0.11809063, 0.11814508, 0.11819946, 0.11825377, 0.11830804, 0.11836226, 0.11841642, 0.11847052, 0.11852457, 0.11857855, 0.11863248, 0.11868635, 0.11874017, 0.11879393, 0.11884762, 0.11890127, 0.11895487, 0.11900839, 0.11906186, 0.11911529, 0.11916866, 0.11922196, 0.11927522, 0.1193284, 0.11938153, 0.11943462, 0.11948764, 0.11954062, 0.11959352, 0.11964637, 0.11969917, 0.11975191, 0.11980459, 0.11985723, 0.11990978, 0.1199623, 0.12001475, 0.12006716, 0.1201195, 0.12017179, 0.12022402, 0.1202762, 0.12032832, 0.12038037, 0.12043238, 0.12048431, 0.12053622, 0.12058804, 0.12063983, 0.12069154, 0.1207432, 0.12079481, 0.12084637, 0.12089785, 0.1209493, 0.12100067, 0.121052, 0.12110327, 0.12115448, 0.12120564, 0.12125674, 0.12130777, 0.12135876, 0.12140968, 0.12146055, 0.12151136, 0.12156213, 0.12161282, 0.12166347, 0.12171406, 0.12176459, 0.12181505, 0.12186548, 0.12191584, 0.12196615, 0.12201639, 0.12206657, 0.12211671, 0.12216678, 0.12221681, 0.12226678, 0.12231668, 0.12236655, 0.12241634, 0.12246607, 0.12251575, 0.12256537, 0.12261494, 0.12266446, 0.12271391, 0.1227633, 0.12281264, 0.12286193, 0.12291116, 0.12296032, 0.12300944, 0.1230585, 0.12310751, 0.12315645, 0.12320533, 0.12325417, 0.12330294, 0.12335167, 0.12340032, 0.12344892, 0.12349747, 0.12354596, 0.1235944, 0.12364278, 0.1236911, 0.12373936, 0.12378758, 0.12383573, 0.12388381, 0.12393186, 0.12397983, 0.12402776, 0.12407564, 0.12412345, 0.12417122, 0.1242189, 0.12426654, 0.12431414, 0.12436166, 0.12440913, 0.12445655, 0.12450391, 0.12455121, 0.12459844, 0.12464564, 0.12469277, 0.12473986, 0.12478687, 0.12483383, 0.12488073, 0.12492759, 0.12497438, 0.12502111, 0.12506779, 0.12511441, 0.12516098, 0.12520748, 0.12525393, 0.12530032, 0.12534668, 0.12539294, 0.12543918, 0.12548535, 0.12553146, 0.12557751, 0.12562352, 0.12566946, 0.12571535, 0.12576117, 0.12580694, 0.12585266, 0.12589832, 0.12594391, 0.12598947, 0.12603496, 0.12608039, 0.12612575, 0.1261711, 0.12621634, 0.12626155, 0.12630671, 0.1263518, 0.12639683, 0.12644184, 0.12648673, 0.1265316, 0.12657641, 0.12662117, 0.12666586, 0.1267105, 0.12675507, 0.12679961, 0.12684408, 0.12688848, 0.12693284, 0.12697715, 0.12702139, 0.12706558, 0.12710971, 0.1271538, 0.1271978, 0.12724178, 0.12728566, 0.1273295, 0.12737329, 0.12741703, 0.1274607, 0.12750433, 0.12754789, 0.1275914, 0.12763484, 0.12767825, 0.12772158, 0.12776485, 0.12780808, 0.12785125, 0.12789434, 0.12793741, 0.12798041, 0.12802334, 0.12806624, 0.12810905, 0.12815183, 0.12819456, 0.1282372, 0.12827981, 0.12832235, 0.12836483, 0.12840727, 0.12844962, 0.12849195, 0.12853421, 0.12857643, 0.12861857, 0.12866065, 0.12870269, 0.12874466, 0.12878659, 0.12882845, 0.12887026, 0.128912, 0.1289537, 0.12899534, 0.12903693, 0.12907846, 0.12911992, 0.12916131, 0.12920268, 0.12924397, 0.12928523, 0.1293264, 0.12936753, 0.1294086, 0.12944961, 0.12949057, 0.12953147, 0.12957232, 0.1296131, 0.12965386, 0.12969452, 0.12973513, 0.12977569, 0.12981619, 0.12985663, 0.12989703, 0.12993737, 0.12997764, 0.13001788, 0.13005802, 0.13009813, 0.13013819, 0.13017818, 0.13021812, 0.13025801, 0.13029782, 0.1303376, 0.13037729, 0.13041697, 0.13045655, 0.1304961, 0.13053559, 0.13057502, 0.13061439, 0.13065369, 0.13069296, 0.13073215, 0.13077131, 0.13081039, 0.13084942, 0.13088842, 0.13092731, 0.13096617, 0.13100497, 0.13104373, 0.13108243, 0.13112105, 0.13115965, 0.13119817, 0.13123663, 0.13127503, 0.13131338, 0.13135168, 0.13138992, 0.13142811, 0.13146622, 0.13150431, 0.13154231, 0.13158026, 0.13161817, 0.13165601, 0.13169378, 0.13173151, 0.1317692, 0.13180681, 0.13184437, 0.13188186, 0.13191931, 0.13195671, 0.13199404, 0.13203132, 0.13206853, 0.13210571, 0.1321428, 0.13217986, 0.13221684, 0.13225378, 0.13229066, 0.13232748, 0.13236424, 0.13240096, 0.1324376, 0.13247421, 0.13251075, 0.13254721, 0.13258366, 0.13262002, 0.13265634, 0.13269259, 0.13272879, 0.13276494, 0.13280103, 0.13283704, 0.13287303, 0.13290893, 0.13294479, 0.1329806, 0.13301635, 0.13305204, 0.13308766, 0.13312325, 0.13315876, 0.13319422, 0.13322964, 0.13326499, 0.13330027, 0.13333552, 0.13337068, 0.13340582, 0.13344088, 0.1334759, 0.13351084, 0.13354574, 0.13358058, 0.13361536, 0.13365009, 0.13368475, 0.13371937, 0.13375393, 0.13378842, 0.13382287, 0.13385727, 0.1338916, 0.13392587, 0.13396008, 0.13399425, 0.13402836, 0.13406239, 0.1340964, 0.13413031, 0.1341642, 0.13419801, 0.13423178, 0.13426548, 0.13429913, 0.13433273, 0.13436626, 0.13439974, 0.13443318, 0.13446654, 0.13449985, 0.13453309, 0.13456631, 0.13459945, 0.13463253, 0.13466555, 0.13469853, 0.13473144, 0.13476309, 0.13479343, 0.13482371, 0.1348539, 0.13488401, 0.13491409, 0.13494407, 0.13497397, 0.13500381, 0.13503356, 0.13506326, 0.13509288, 0.13512242, 0.13515189, 0.13518129, 0.1352106, 0.13523987, 0.13526905, 0.13529815, 0.13532719, 0.13535616, 0.13538504, 0.13541386, 0.1354426, 0.13547127, 0.13549986, 0.1355284, 0.13555685, 0.13558522, 0.13561352, 0.13564175, 0.13566992, 0.13569801, 0.13572602, 0.13575396, 0.13578182, 0.13580965, 0.13583736, 0.13586502, 0.13589258, 0.13592009, 0.13594753, 0.13597488, 0.13600218, 0.13602938, 0.13605653, 0.1360836, 0.13611059, 0.13613752, 0.13616438, 0.13619114, 0.13621785, 0.13624448, 0.13627104, 0.13629754, 0.13632396, 0.13635029, 0.13637656, 0.13640276, 0.13642886, 0.13645492, 0.1364809, 0.13650681, 0.13653263, 0.1365584, 0.13658407, 0.13660969, 0.13663523, 0.13666071, 0.13668609, 0.13671143, 0.13673666, 0.13676183, 0.13678695, 0.13681196, 0.13683693, 0.13686183, 0.13688663, 0.13691136, 0.13693602, 0.13696064, 0.13698514, 0.13700959, 0.13703398, 0.13705827, 0.1370825, 0.13710666, 0.13713075, 0.13715476, 0.1371787, 0.13720256, 0.13722636, 0.13725008, 0.13727373, 0.1372973, 0.1373208, 0.13734424, 0.13736759, 0.13739088, 0.13741407, 0.13743722, 0.13746028, 0.13748327, 0.1375062, 0.13752903, 0.13755181, 0.13757452, 0.13759713, 0.1376197, 0.13764219, 0.13766459, 0.13768692, 0.1377092, 0.13773139, 0.1377535, 0.13777556, 0.13779753, 0.13781942, 0.13784125, 0.13786301, 0.13788468, 0.1379063, 0.13792783, 0.1379493, 0.1379707, 0.13799201, 0.13801326, 0.13803442, 0.13805553, 0.13807656, 0.13809751, 0.13811839, 0.13813919, 0.13815993, 0.1381806, 0.13820118, 0.1382217, 0.13824213, 0.13826253, 0.13828281, 0.13830304, 0.13832319, 0.13834329, 0.13836329, 0.13838322, 0.13840307, 0.13842286, 0.13844258, 0.13846225, 0.1384818, 0.13850129, 0.13852072, 0.13854007, 0.13855934, 0.13857856, 0.1385977, 0.13861676, 0.13863574, 0.13865465, 0.1386735, 0.13869227, 0.13871096, 0.13872959, 0.13874814, 0.13876663, 0.13878503, 0.13880336, 0.13882163, 0.13883983, 0.13885792, 0.13887596, 0.13889393, 0.13891183, 0.13892965, 0.1389474, 0.13896509, 0.13898268, 0.13900022, 0.13901767, 0.13903508, 0.13905239, 0.13906963, 0.1390868, 0.1391039, 0.13912091, 0.13913786, 0.13915473, 0.13917154, 0.13918827, 0.13920493, 0.13922153, 0.13923803, 0.13925448, 0.13927084, 0.13928714, 0.13930336, 0.13931952, 0.13933559, 0.13935159, 0.13936752, 0.13938338, 0.13939916, 0.13941489, 0.13943052, 0.13944609, 0.13946158, 0.139477, 0.13949235, 0.13950762, 0.13952282, 0.13953796, 0.13955303, 0.139568, 0.1395829, 0.13959774, 0.13961251, 0.1396272, 0.13964184, 0.13965638, 0.13967085, 0.13968526, 0.13969959, 0.13971384, 0.13972802, 0.13974215, 0.13975617, 0.13977015, 0.13978404, 0.13979785, 0.13981161, 0.13982528, 0.13983887, 0.1398524, 0.13986586, 0.13987924, 0.13989255, 0.1399058, 0.13991895, 0.13993205, 0.13994507, 0.13995801, 0.13997088, 0.1399837, 0.13999641, 0.14000908, 0.14002164, 0.14003415, 0.1400466, 0.14005898, 0.14007124, 0.14008348, 0.14009561, 0.14010769, 0.1401197, 0.14013162, 0.14014347, 0.14015526, 0.14016695, 0.14017861, 0.14019017, 0.14020164, 0.14021307, 0.1402244, 0.14023569, 0.14024688, 0.14025801, 0.14026907, 0.14028005, 0.14029096, 0.14030178, 0.14031255, 0.14032324, 0.14033386, 0.1403444, 0.14035487, 0.14036527, 0.1403756, 0.14038585, 0.14039601, 0.14040613, 0.14041616, 0.14042613, 0.14043601, 0.14044583, 0.14045557, 0.14046524, 0.14047486, 0.14048438, 0.14049384, 0.1405032, 0.1405125, 0.14052173, 0.1405309, 0.14053999, 0.140549, 0.14055796, 0.14056683, 0.14057563, 0.14058433, 0.14059301, 0.14060158, 0.14061008, 0.1406185, 0.14062688, 0.14063516, 0.14064337, 0.14065152, 0.14065959, 0.14066757, 0.1406755, 0.14068335, 0.14069113, 0.14069884, 0.14070646, 0.14071403, 0.1407215, 0.14072892, 0.14073627, 0.14074354, 0.14075074, 0.14075786, 0.14076489, 0.14077188, 0.14077879, 0.14078562, 0.14079237, 0.14079906, 0.14080568, 0.14081222, 0.14081867, 0.14082508, 0.1408314, 0.14083764, 0.14084382, 0.14084993, 0.14085595, 0.14086193, 0.1408678, 0.14087361, 0.14087935, 0.14088503, 0.14089061, 0.14089613, 0.14090158, 0.14090694, 0.14091226, 0.14091749, 0.14092265, 0.14092773, 0.14093274, 0.14093769, 0.14094254, 0.14094734, 0.14095205, 0.1409567, 0.14096127, 0.14096579, 0.1409702, 0.14097457, 0.14097884, 0.14098306, 0.1409872, 0.14099126, 0.14099525, 0.14099918, 0.14100301, 0.1410068, 0.14101049, 0.14101413, 0.14101768, 0.14102116, 0.14102457, 0.14102791, 0.14103118, 0.14103436, 0.14103748, 0.14104053, 0.1410435, 0.14104639, 0.14104924, 0.14105199, 0.14105466, 0.14105728, 0.14105982, 0.14106227, 0.14106466, 0.14106698, 0.14106923, 0.14107141, 0.14107351, 0.14107552, 0.14107749, 0.14107937, 0.14108117, 0.14108291, 0.14108457, 0.14108616, 0.14108768, 0.14108913, 0.1410905, 0.14109179, 0.14109302, 0.14109418, 0.14109525, 0.14109626, 0.1410972, 0.14109807, 0.14109884, 0.14109957, 0.14110021, 0.14110078, 0.14110127, 0.14110169, 0.14110205, 0.14110234, 0.14110252, 0.14110267, 0.14110275, 0.14110272, 0.14110263, 0.14110248, 0.14110225, 0.14110194, 0.14110158, 0.14110112, 0.14110059, 0.1411, 0.14109935, 0.1410986, 0.1410978, 0.1410969, 0.14109595, 0.14109491, 0.14109381, 0.14109263, 0.14109139, 0.14109008, 0.14108868, 0.1410872, 0.14108567, 0.14108405, 0.14108236, 0.1410806, 0.14107879, 0.14107686, 0.1410749, 0.14107284, 0.14107071, 0.14106853, 0.14106624, 0.1410639, 0.1410615, 0.14105901, 0.14105645, 0.14105383, 0.14105111, 0.14104833, 0.14104548, 0.14104256, 0.14103957, 0.1410365, 0.14103335, 0.14103015, 0.14102684, 0.1410235, 0.14102006, 0.14101656, 0.14101298, 0.14100933, 0.14100559, 0.14100181, 0.14099793, 0.140994, 0.14098997, 0.14098589, 0.14098173, 0.14097749, 0.1409732, 0.1409688, 0.14096437, 0.14095981, 0.14095524, 0.14095058, 0.14094581, 0.14094099, 0.14093611, 0.14093114, 0.14092612, 0.14092101, 0.14091583, 0.14091058, 0.14090525, 0.14089985, 0.14089438, 0.14088883, 0.14088322, 0.14087752, 0.14087176, 0.14086594, 0.14086002, 0.14085285, 0.14084442, 0.14083593, 0.14082736, 0.14081872, 0.14081001, 0.14080125, 0.14079238, 0.14078347, 0.14077449, 0.14076543, 0.14075631, 0.14074712, 0.14073783, 0.1407285, 0.14071912, 0.14070962, 0.14070009, 0.14069046, 0.14068079, 0.14067103, 0.14066121, 0.14065132, 0.14064136, 0.14063132, 0.14062123, 0.14061105, 0.14060082, 0.1405905, 0.14058012, 0.14056969, 0.14055917, 0.14054857, 0.1405379, 0.14052717, 0.14051637, 0.14050551, 0.14049457, 0.14048356, 0.14047249, 0.14046136, 0.14045013, 0.14043884, 0.14042749, 0.14041606, 0.14040457, 0.140393, 0.14038137, 0.14036967, 0.14035788, 0.14034605, 0.14033413, 0.14032213, 0.14031009, 0.14029799, 0.14028578, 0.14027351, 0.1402612, 0.14024879, 0.14023632, 0.14022379, 0.14021116, 0.14019848, 0.14018574, 0.14017293, 0.14016002, 0.14014708, 0.14013407, 0.14012095, 0.14010778, 0.14009455, 0.14008124, 0.14006788, 0.14005442, 0.1400409, 0.14002731, 0.14001365, 0.13999994, 0.13998614, 0.13997228, 0.13995835, 0.13994434, 0.13993028, 0.13991614, 0.13990191, 0.13988763, 0.1398733, 0.13985887, 0.13984437, 0.13982981, 0.13981517, 0.13980049, 0.13978572, 0.13977087, 0.13975598, 0.13974097, 0.13972592, 0.13971081, 0.13969563, 0.13968037, 0.13966504, 0.13964966, 0.13963419, 0.13961865, 0.13960305, 0.13958737, 0.13957162, 0.13955581, 0.13953993, 0.13952398, 0.13950795, 0.13949186, 0.1394757, 0.13945946, 0.13944316, 0.13942678, 0.13941035, 0.13939384, 0.13937724, 0.13936059, 0.13934387, 0.13932708, 0.13931021, 0.1392933, 0.1392763, 0.13925922, 0.13924208, 0.13922487, 0.13920762, 0.13919026, 0.13917284, 0.13915536, 0.13913779, 0.13912018, 0.13910247, 0.1390847, 0.13906687, 0.13904895, 0.13903099, 0.13901295, 0.13899484, 0.13897665, 0.13895839, 0.13894007, 0.13892168, 0.13890322, 0.13888468, 0.13886607, 0.13884741, 0.13882867, 0.13880986, 0.13879098, 0.13877203, 0.138753, 0.13873392, 0.13871476, 0.13869552, 0.13867624, 0.13865685, 0.13863744, 0.1386179, 0.13859835, 0.1385787, 0.13855898, 0.1385392, 0.13851933, 0.13849941, 0.13847943, 0.13845935, 0.13843922, 0.13841902, 0.13839874, 0.1383784, 0.13835798, 0.13833751, 0.13831696, 0.13829632, 0.13827562, 0.13825488, 0.13823403, 0.13821314, 0.13819216, 0.13817114, 0.13815002, 0.13812883, 0.13810758, 0.13808626, 0.13806488, 0.13804343, 0.13802189, 0.13800029, 0.13797861, 0.13795689, 0.13793509, 0.13791321, 0.13789126, 0.13786924, 0.13784716, 0.137825, 0.13780278, 0.13778047, 0.13775812, 0.13773568, 0.13771319, 0.1376906, 0.13766797, 0.13764524, 0.13762248, 0.13759962, 0.1375767, 0.13755371, 0.13753064, 0.13750753, 0.13748431, 0.13746105, 0.1374377, 0.13741431, 0.13739081, 0.13736726, 0.13734365, 0.13731995, 0.1372962, 0.13727237, 0.13724849, 0.13722451, 0.13720047, 0.13717636, 0.13715219, 0.13712795, 0.13710363, 0.13707924, 0.1370548, 0.13703027, 0.13700567, 0.136981, 0.13695627, 0.13693148, 0.13690661, 0.13688166, 0.13685665, 0.13683157, 0.13680643, 0.1367812, 0.13675591, 0.13673055, 0.1367051, 0.1366796, 0.13665403, 0.1366284, 0.13660268, 0.13657691, 0.13655107, 0.13652515, 0.13649917, 0.1364731, 0.13644698, 0.13642079, 0.13639453, 0.1363682, 0.13634178, 0.1363153, 0.13628876, 0.13626215, 0.13623546, 0.13620871, 0.13618189, 0.13615499, 0.13612802, 0.13610099, 0.1360739, 0.13604672, 0.13601947, 0.13599217, 0.1359648, 0.13593733, 0.13590983, 0.13588223, 0.13585457, 0.13582684, 0.13579904, 0.13577119, 0.13574323, 0.13571522, 0.13568716, 0.13565899, 0.13563079, 0.13560249, 0.13557415, 0.13554572, 0.13551721, 0.13548864, 0.13546002, 0.1354313, 0.13540253, 0.1353737, 0.13534479, 0.13531579, 0.13528673, 0.13525762, 0.13522844, 0.13519916, 0.13516983, 0.13514043, 0.13511096, 0.13508141, 0.13505182, 0.13502212, 0.13499238, 0.13496256, 0.13493267, 0.13490272, 0.13487267, 0.13484259, 0.13481241, 0.13478218, 0.13475187, 0.13472149, 0.13469104, 0.13466053, 0.13462994, 0.13459928, 0.13456857, 0.13453777, 0.1345069, 0.13447596, 0.13444497, 0.1344139, 0.13438275, 0.13435154, 0.13432024, 0.13428891, 0.13425747, 0.13422598, 0.13419443, 0.1341628, 0.13413109, 0.13409933, 0.13406749, 0.13403557, 0.13400358, 0.13397154, 0.13393943, 0.13390724, 0.13387498, 0.13384265, 0.13381027, 0.13377777, 0.13374525, 0.13371263, 0.13367997, 0.13364722, 0.13361441, 0.13358152, 0.13354857, 0.13351555, 0.13348246, 0.13344927, 0.13341606, 0.13338274, 0.13334936, 0.13331594, 0.13328242, 0.13324882, 0.13321519, 0.13318145, 0.13314767, 0.13311382, 0.13307987, 0.13304588, 0.1330118, 0.13297766, 0.13294347, 0.13290918, 0.13287483, 0.13284042, 0.13280591, 0.13277136, 0.13273674, 0.13270205, 0.13266727, 0.13263245, 0.13259754, 0.13256258, 0.13252752, 0.13249241, 0.13245723, 0.13242197, 0.13238665, 0.13235125, 0.13231578, 0.13228026, 0.13224465, 0.13220897, 0.13217324, 0.13213742, 0.13210154, 0.13206558, 0.13202956, 0.13199347, 0.13195731, 0.13192108, 0.1318848, 0.13184842, 0.13181198, 0.13177547, 0.13173889, 0.13170226, 0.13166551, 0.13162875, 0.13159187, 0.13155495, 0.13151798, 0.1314809, 0.13144377, 0.13140656, 0.13136926, 0.13133194, 0.13129453, 0.13125704, 0.13121949, 0.13118187, 0.13114417, 0.13110639, 0.13106859, 0.13103068, 0.1309927, 0.13095465, 0.13091655, 0.13087836, 0.13084011, 0.1308018, 0.1307634, 0.13072494, 0.13068642, 0.13064784, 0.13060915, 0.13057041, 0.13053161, 0.13049273, 0.1304538, 0.13041477, 0.13037568, 0.13033652, 0.13029729, 0.13025801, 0.13021864, 0.1301792, 0.13013971, 0.13010012, 0.13006048, 0.13002078, 0.12998097, 0.12994114, 0.1299012, 0.12986121, 0.12982115, 0.12978101, 0.12974083, 0.12970056, 0.1296602, 0.12961981, 0.12957932, 0.12953876, 0.12949815, 0.12945746, 0.1294167, 0.12937587, 0.12933499, 0.12929401, 0.12925299, 0.12921186, 0.12917069, 0.12912945, 0.12908813, 0.12904674, 0.12900527, 0.12896375, 0.12892216, 0.12888052, 0.12883876, 0.12879696, 0.12875509, 0.12871315, 0.12867112, 0.12862904, 0.1285869, 0.12854467, 0.1285024, 0.12846002, 0.1284176, 0.1283751, 0.12833253, 0.12828989, 0.12824719, 0.12820439, 0.12816155, 0.12811863, 0.12807563, 0.12803258, 0.12798946, 0.12794468, 0.12789832, 0.1278519, 0.12780544, 0.12775896, 0.1277124, 0.1276658, 0.12761918, 0.12757249, 0.12752578, 0.127479, 0.12743218, 0.12738533, 0.12733842, 0.1272915, 0.12724449, 0.12719746, 0.12715037, 0.12710325, 0.12705609, 0.12700887, 0.1269616, 0.12691431, 0.12686695, 0.12681957, 0.12677212, 0.12672465, 0.12667713, 0.12662956, 0.12658194, 0.12653428, 0.12648658, 0.12643883, 0.12639102, 0.12634319, 0.1262953, 0.12624738, 0.12619941, 0.1261514, 0.12610334, 0.12605524, 0.12600708, 0.1259589, 0.12591065, 0.12586237, 0.12581405, 0.12576567, 0.12571725, 0.12566879, 0.12562029, 0.12557174, 0.12552315, 0.12547451, 0.12542583, 0.12537709, 0.12532832, 0.1252795, 0.12523064, 0.12518175, 0.1251328, 0.12508379, 0.12503475, 0.12498567, 0.12493654, 0.12488736, 0.12483814, 0.12478889, 0.12473957, 0.12469023, 0.12464083, 0.1245914, 0.12454191, 0.12449237, 0.1244428, 0.12439318, 0.12434351, 0.1242938, 0.12424405, 0.12419426, 0.12414443, 0.12409454, 0.1240446, 0.12399463, 0.1239446, 0.12389455, 0.12384444, 0.12379428, 0.12374409, 0.12369385, 0.12364356, 0.12359322, 0.12354284, 0.12349243, 0.12344196, 0.12339145, 0.12334088, 0.12329029, 0.12323965, 0.12318897, 0.12313823, 0.12308745, 0.12303664, 0.12298578, 0.12293485, 0.12288392, 0.12283291, 0.12278186, 0.12273077, 0.12267964, 0.12262847, 0.12257723, 0.12252597, 0.12247468, 0.12242331, 0.12237191, 0.12232046, 0.12226897, 0.12221742, 0.12216587, 0.12211423, 0.12206256, 0.12201086, 0.1219591, 0.1219073, 0.12185545, 0.12180355, 0.12175163, 0.12169965, 0.12164763, 0.12159556, 0.12154345, 0.12149129, 0.12143908, 0.12138686, 0.12133455, 0.1212822, 0.12122984, 0.12117741, 0.12112495, 0.12107243, 0.12101987, 0.12096726, 0.12091462, 0.12086193, 0.12080919, 0.12075641, 0.12070359, 0.12065071, 0.12059779, 0.12054484, 0.12049184, 0.12043878, 0.12038568, 0.12033255, 0.12027937, 0.12022614, 0.12017287, 0.12011956, 0.1200662, 0.1200128, 0.11995935, 0.11990585, 0.11985233, 0.11979873, 0.1197451, 0.11969143, 0.11963772, 0.11958396, 0.11953016, 0.11947631, 0.11942241, 0.11936846, 0.11931448, 0.11926045, 0.11920639, 0.11915227, 0.1190981, 0.11904389, 0.11898965, 0.11893536, 0.11888102, 0.11882664, 0.1187722, 0.11871774, 0.11866322, 0.11860865, 0.11855404, 0.11849938, 0.1184447, 0.11838996, 0.11833517, 0.11828034, 0.11822548, 0.11817056, 0.11811558, 0.11806057, 0.11800553, 0.11795042, 0.11789529, 0.1178401, 0.11778487, 0.11772959, 0.11767426, 0.11761891, 0.11756351, 0.11750805, 0.11745254, 0.117397, 0.11734141, 0.1172858, 0.11723012, 0.11717439, 0.11711864, 0.11706282, 0.11700697, 0.11695106, 0.11689512, 0.11683915, 0.1167831, 0.11672702, 0.11667091, 0.11661474, 0.11655852, 0.11650227, 0.11644598, 0.11638962, 0.11633325, 0.11627681, 0.11622033, 0.11616381, 0.11610724, 0.11605064, 0.11599397, 0.11593728, 0.11588053, 0.11582375, 0.11576691, 0.11571004, 0.11565311, 0.11559614, 0.11553912, 0.11548208, 0.11542498, 0.11536783, 0.11531063, 0.1152534, 0.11519613, 0.1151388, 0.11508142, 0.11502402, 0.11496656, 0.11490905, 0.11485151, 0.11479393, 0.11473627, 0.1146786, 0.11462089, 0.1145631, 0.11450531, 0.11444744, 0.11438955, 0.11433159, 0.1142736, 0.11421556, 0.11415747, 0.11409935, 0.11404117, 0.11398298, 0.11392472, 0.11386641, 0.11380807, 0.11374966, 0.11369124, 0.11363275, 0.11357422, 0.11351565, 0.11345704, 0.11339838, 0.11333967, 0.11328094, 0.11322213, 0.11316329, 0.11310442, 0.11304549, 0.11298651, 0.11292749, 0.11286844, 0.11280933, 0.11275019, 0.11269099, 0.11263174, 0.11257246, 0.11251313, 0.11245377, 0.11239436, 0.11233488, 0.11227538, 0.11221584, 0.11215623, 0.1120966, 0.11203691, 0.11197718, 0.11191741, 0.11185759, 0.11179774, 0.11173782, 0.11167787, 0.11161788, 0.11155783, 0.11149775, 0.11143762, 0.11137745, 0.11131723, 0.11125696, 0.11119666, 0.11113631, 0.11107592, 0.11101547, 0.11095499, 0.11089446, 0.11083388, 0.11077326, 0.1107126, 0.11065189, 0.11059114, 0.11053034, 0.11046949, 0.11040861, 0.11034767, 0.11028671, 0.11022568, 0.11016461, 0.11010351, 0.11004236, 0.10998116, 0.1099199, 0.10985862, 0.10979729, 0.10973591, 0.1096745, 0.10961303, 0.10955152, 0.10948996, 0.10942835, 0.10936672, 0.10930502, 0.1092433, 0.10918152, 0.10911969, 0.10905784, 0.10899592, 0.10893397, 0.10887197, 0.10880992, 0.10874783, 0.1086857, 0.10862353, 0.1085613, 0.10849902, 0.10843672, 0.10837436, 0.10831197, 0.10824952, 0.10818703, 0.10812449, 0.10806191, 0.1079993, 0.10793662, 0.1078739, 0.10781115, 0.10774834, 0.10768551, 0.10762262, 0.10755967, 0.1074967, 0.10743367, 0.1073706, 0.10730749, 0.10724433, 0.10718112, 0.10711788, 0.1070546, 0.10699126, 0.10692788, 0.10686445, 0.10680098, 0.10673746, 0.10667391, 0.10661031, 0.10654666, 0.10648297, 0.10641923, 0.10635545, 0.10629161, 0.10622775, 0.10616384, 0.10609988, 0.10603587, 0.10597182, 0.10590773, 0.10584359, 0.10577941, 0.10571519, 0.10565091, 0.1055866, 0.10552224, 0.10545783, 0.10539339, 0.10532888, 0.10526434, 0.10519976, 0.10513514, 0.10507046, 0.10500575, 0.10494099, 0.10487618, 0.10481133, 0.10474644, 0.1046815, 0.10461651, 0.10455148, 0.10448641, 0.1044213, 0.10435612, 0.10429092, 0.10422567, 0.10416038, 0.10409503, 0.10402965, 0.10396422, 0.10389875, 0.10383324, 0.10376766, 0.10370205, 0.10363641, 0.10357071, 0.10350497, 0.10343918, 0.10337336, 0.10330748, 0.10324156, 0.1031756, 0.10310958, 0.10304353, 0.10297743, 0.1029113, 0.10284511, 0.10277888, 0.1027126, 0.10264628, 0.10257992, 0.10251351, 0.10244706, 0.10238055, 0.10231401, 0.10224742, 0.1021808, 0.10211412, 0.1020474, 0.10198063, 0.10191382, 0.10184697, 0.10178006, 0.10171313, 0.10164614, 0.10157911, 0.10151203, 0.1014449, 0.10137774, 0.10131054, 0.10124327, 0.10117598, 0.10110863, 0.10104124, 0.10097381, 0.10090633, 0.10083881, 0.10077124, 0.10070363, 0.10063598, 0.10056827, 0.10050053, 0.10043274, 0.1003649, 0.10029703, 0.1002291, 0.10016114, 0.10009312, 0.10002506, 0.099956959, 0.099888824, 0.099820629, 0.099752389, 0.099684112, 0.099615782, 0.099547416, 0.099479005, 0.099410549, 0.099342048, 0.099273495, 0.0992046, 0.099135399, 0.09906619, 0.09899696, 0.098927751, 0.098858528, 0.098789297, 0.098720059, 0.098650813, 0.098581582, 0.098512337, 0.098443091, 0.098373838, 0.09830457, 0.098235302, 0.098166034, 0.098096766, 0.098027483, 0.097958192, 0.097888917, 0.097819626, 0.097750328, 0.097681031, 0.097611718, 0.09754242, 0.097473092, 0.097403787, 0.097334467, 0.097265132, 0.097195812, 0.097126476, 0.097057134, 0.096987784, 0.096918434, 0.096849091, 0.096779719, 0.096710369, 0.096641004, 0.096571617, 0.096502252, 0.096432865, 0.096363477, 0.096294083, 0.096224695, 0.096155308, 0.096085891, 0.096016496, 0.095947079, 0.095877655, 0.095808238, 0.095738813, 0.095669396, 0.095599949, 0.095530517, 0.095461078, 0.095391624, 0.095322177, 0.095252723, 0.095183253, 0.095113799, 0.09504433, 0.094974861, 0.094905376, 0.094835892, 0.094766408, 0.094696909, 0.094627418, 0.094557919, 0.09448842, 0.094418906, 0.094349384, 0.094279878, 0.094210349, 0.094140813, 0.094071291, 0.094001755, 0.093932219, 0.093862668, 0.093793124, 0.093723573, 0.093654007, 0.093584448, 0.093514882, 0.093445309, 0.093375735, 0.093306154, 0.093236573, 0.09316697, 0.093097381, 0.093027785, 0.09295819, 0.092888579, 0.092818968, 0.09274935, 0.092679732, 0.092610098, 0.092540473, 0.092470832, 0.092401206, 0.092331558, 0.092261903, 0.092192262, 0.092122599, 0.092052937, 0.091983274, 0.091913603, 0.091843925, 0.091774255, 0.09170457, 0.091634884, 0.091565184, 0.091495499, 0.091425799, 0.091356091, 0.091286376, 0.091216661, 0.091146953, 0.091077231, 0.091007493, 0.090937771, 0.090868026, 0.090798289, 0.090728551, 0.090658791, 0.090589046, 0.090519279, 0.090449527, 0.090379745, 0.09030997, 0.090240203, 0.090170421, 0.090100639, 0.090030849, 0.089961052, 0.089891255, 0.08982145, 0.089751646, 0.089681834, 0.089612015, 0.089542203, 0.089472361, 0.089402542, 0.089332707, 0.089262865, 0.089193024, 0.089123167, 0.089053325, 0.088983461, 0.088913605, 0.088843748, 0.088773869, 0.088703997, 0.088634126, 0.088564239, 0.088494353, 0.088424452, 0.088354565, 0.088284656, 0.088214748, 0.088144854, 0.088074923, 0.088005006, 0.087935083, 0.087865151, 0.087795228, 0.087725289, 0.087655351, 0.087585405, 0.087515451, 0.087445498, 0.087375529, 0.087305576, 0.087235607, 0.087165631, 0.087095663, 0.08702568, 0.086955696, 0.086885706, 0.086815707, 0.086745702, 0.086675704, 0.086605698, 0.086535685, 0.086465664, 0.086395651, 0.086325623, 0.086255595, 0.08618556, 0.086115509, 0.086045481, 0.085975431, 0.085905381, 0.085835323, 0.08576525, 0.0856952, 0.08562512, 0.085555047, 0.085484974, 0.085414886, 0.085344791, 0.085274704, 0.085204601, 0.085134506, 0.085064404, 0.084994294, 0.084924169, 0.084854051, 0.084783942, 0.084713802, 0.084643677, 0.08457353, 0.084503397, 0.08443325, 0.084363103, 0.084292941, 0.084222786, 0.084152624, 0.084082462, 0.084012277, 0.083942108, 0.083871923, 0.083801739, 0.083731547, 0.083661348, 0.083591156, 0.083520949, 0.083450742, 0.08338052, 0.083310306, 0.083240092, 0.083169863, 0.083099641, 0.083029404, 0.08295916, 0.082888916, 0.082818665, 0.082748413, 0.082678169, 0.082607895, 0.082537636, 0.082467362, 0.082397088, 0.082326807, 0.082256518, 0.082186244, 0.082115941, 0.082045652, 0.081975348, 0.081905045, 0.081834733, 0.081764407, 0.081694096, 0.08162377, 0.081553444, 0.081483103, 0.081412777, 0.081342421, 0.081272081, 0.081201732, 0.081131376, 0.081061013, 0.080990657, 0.080920286, 0.080849908, 0.080779538, 0.080709152, 0.080638766, 0.080568373, 0.080497973, 0.080427587, 0.080357179, 0.080286771, 0.080216363, 0.08014594, 0.080075517, 0.080005087, 0.079934672, 0.079864234, 0.079793781, 0.079723343, 0.079652898, 0.079582438, 0.079511985, 0.079441525, 0.07937105, 0.079300582, 0.079230115, 0.07915964, 0.079089142, 0.07901866, 0.078948162, 0.078877673, 0.07880716, 0.078736655, 0.078666151, 0.078595631, 0.078525126, 0.078454591, 0.078384057, 0.078313529, 0.078242995, 0.078172445, 0.078101903, 0.078031346, 0.077960804, 0.077890232, 0.077819683, 0.077749103, 0.077678524, 0.077607952, 0.077537373, 0.077466786, 0.077396199, 0.077325605, 0.077254996, 0.077184394, 0.077113792, 0.077043176, 0.076972559, 0.076901935, 0.076831304, 0.076760679, 0.076690033, 0.076619402, 0.076548763, 0.076478109, 0.076407455, 0.076336801, 0.076266132, 0.076195471, 0.076124795, 0.076054126, 0.075983442, 0.075912751, 0.075842075, 0.075771376, 0.075700678, 0.075629972, 0.075559266, 0.07548856, 0.075417839, 0.075347126, 0.075276397, 0.075205661, 0.07513494, 0.075064197, 0.074993461, 0.074922718, 0.074851952, 0.074781209, 0.074710444, 0.074639685, 0.074568912, 0.074498139, 0.074427359, 0.074356571, 0.074285798, 0.074214995, 0.074144199, 0.074073412, 0.074002594, 0.073931791, 0.073860981, 0.073790148, 0.073719338, 0.073648505, 0.07357768, 0.07350684, 0.073435999, 0.073365159, 0.073294304, 0.073223457, 0.073152594, 0.073081739, 0.073010869, 0.072939999, 0.072869115, 0.072798237, 0.072727352, 0.072656468, 0.072585575, 0.072514683, 0.072443776, 0.072372861, 0.072301954, 0.072231032, 0.072160117, 0.072089188, 0.072018266, 0.071947329, 0.071876392, 0.071805447, 0.07173451, 0.071663551, 0.071592599, 0.071521632, 0.071450673, 0.071379699, 0.071308725, 0.071237743, 0.071166769, 0.07109578, 0.07102479, 0.070953786, 0.070882797, 0.070811786, 0.070740782, 0.070669763, 0.070598744, 0.070527732, 0.070456691, 0.070385672, 0.070314631, 0.070243582, 0.070172541, 0.0701015, 0.070030451, 0.069959387, 0.069888324, 0.06981726, 0.069746181, 0.069675103, 0.069604017, 0.069532938, 0.069461852, 0.069390759, 0.069319658, 0.069248557, 0.069177441, 0.06910634, 0.069035217, 0.068964101, 0.068892971, 0.068821847, 0.068750709, 0.068679571, 0.068608433, 0.06853728, 0.068466134, 0.068394966, 0.068323813, 0.068252653, 0.068181477, 0.06811031, 0.068039127, 0.067967944, 0.067896761, 0.067825563, 0.067754366, 0.067683168, 0.067611963, 0.067540757, 0.067469537, 0.067398317, 0.067327097, 0.06725587, 0.067184635, 0.067113407, 0.067042157, 0.066970915, 0.066899665, 0.066828415, 0.066757157, 0.066685893, 0.06661462, 0.066543348, 0.066472076, 0.066400796, 0.066329509, 0.066258222, 0.066186927, 0.066115625, 0.066044331, 0.065973006, 0.065901704, 0.065830395, 0.065759063, 0.065687746, 0.065616414, 0.065545075, 0.065473735, 0.065402403, 0.065331042, 0.065259695, 0.065188341, 0.065116972, 0.065045625, 0.064974241, 0.064902872, 0.064831488, 0.064760104, 0.064688727, 0.064617328, 0.064545922, 0.064474531, 0.064403124, 0.064331718, 0.064260297, 0.064188883, 0.064117461, 0.06404718, 0.063978188, 0.06390921, 0.063840255, 0.063771337, 0.063702442, 0.063633576, 0.063564725, 0.063495927, 0.063427143, 0.063358404, 0.063289687, 0.063220985, 0.063152313, 0.063083671, 0.063015074, 0.062946491, 0.062877938, 0.062809408, 0.062740922, 0.062672451, 0.06260401, 0.062535599, 0.062467221, 0.06239887, 0.06233054, 0.062262256, 0.062193982, 0.062125742, 0.062057536, 0.061989352, 0.061921213, 0.061853074, 0.061784975, 0.061716903, 0.061648879, 0.06158087, 0.06151288, 0.061444927, 0.061377004, 0.061309095, 0.061241239, 0.061173409, 0.061105594, 0.061037805, 0.060970057, 0.060902342, 0.060834628, 0.060766958, 0.060699336, 0.060631711, 0.060564142, 0.060496569, 0.060429048, 0.060361557, 0.060294088, 0.060226649, 0.060159236, 0.060091846, 0.060024492, 0.059957176, 0.059889879, 0.059822608, 0.059755355, 0.059688158, 0.059620962, 0.059553817, 0.059486687, 0.059419598, 0.059352521, 0.059285473, 0.059218477, 0.059151482, 0.059084527, 0.059017599, 0.058950711, 0.058883835, 0.058816988, 0.058750179, 0.058683392, 0.058616638, 0.058549907, 0.058483221, 0.058416534, 0.0583499, 0.058283288, 0.058216702, 0.058150154, 0.058083627, 0.058017131, 0.057950646, 0.057884213, 0.057817791, 0.057751421, 0.057685055, 0.057618726, 0.057552438, 0.057486154, 0.057419911, 0.057353701, 0.057287507, 0.057221361, 0.057155237, 0.057089124, 0.057023048, 0.056957006, 0.056891009, 0.056825019, 0.056759048, 0.056693126, 0.056627229, 0.056561347, 0.056495503, 0.056429695, 0.056363918, 0.056298144, 0.056232434, 0.056166723, 0.056101054, 0.056035399, 0.055969797, 0.055904217, 0.055838645, 0.055773117, 0.055707615, 0.055642143, 0.055576704, 0.055511285, 0.055445898, 0.055380557, 0.0553152, 0.055249907, 0.055184644, 0.055119399, 0.055054169, 0.054988984, 0.054923836, 0.054858692, 0.054793593, 0.054728523, 0.054663487, 0.054598462, 0.05453347, 0.054468516, 0.054403588, 0.054338682, 0.054273807, 0.054208968, 0.054144129, 0.054079354, 0.054014597, 0.053949863, 0.053885166, 0.053820487, 0.053755846, 0.05369122, 0.053626642, 0.053562082, 0.053497545, 0.053433038, 0.053368572, 0.053304132, 0.053239692, 0.053175315, 0.053110957, 0.053046625, 0.052982319, 0.052918047, 0.052853793, 0.052789576, 0.052725386, 0.052661229, 0.052597102, 0.052532978, 0.052468918, 0.052404869, 0.05234085, 0.052276857, 0.052212898, 0.052148972, 0.052085053, 0.052021198, 0.051957343, 0.051893521, 0.051829726, 0.051765971, 0.051702242, 0.051638529, 0.051574856, 0.051511202, 0.051447593, 0.051383995, 0.051320434, 0.051256899, 0.051193397, 0.051129922, 0.051066469, 0.051003054, 0.050939664, 0.050876282, 0.050812978, 0.050749674, 0.050686378, 0.050623134, 0.050559901, 0.050496727, 0.050433561, 0.050370421, 0.050307311, 0.050244242, 0.050181195, 0.050118178, 0.050055191, 0.049992204, 0.049929276, 0.049866389, 0.049803495, 0.049740646, 0.049677834, 0.049615033, 0.049552269, 0.049489535, 0.049426828, 0.049364153, 0.049301498, 0.04923889, 0.049176294, 0.049113717, 0.04905118, 0.048988681, 0.048926197, 0.048863754, 0.048801333, 0.04873893, 0.048676576, 0.048614249, 0.048551928, 0.04848966, 0.048427388, 0.048365168, 0.048302986, 0.048240811, 0.048178684, 0.048116572, 0.048054487, 0.047992442, 0.047930423, 0.047868431, 0.047806472, 0.047744524, 0.047682621, 0.047620747, 0.047558874, 0.04749706, 0.047435265, 0.047373496, 0.047311768, 0.047250059, 0.047188368, 0.047126722, 0.047065116, 0.047003508, 0.046941947, 0.046880402, 0.046818886, 0.046757422, 0.046695963, 0.04663454, 0.046573143, 0.046511769, 0.04645044, 0.046389129, 0.046327844, 0.046266597, 0.046205368, 0.046144184, 0.046083011, 0.046021879, 0.04596075, 0.045899674, 0.045838635, 0.045777597, 0.045716614, 0.045655634, 0.045594696, 0.045533799, 0.045472901, 0.045412052, 0.04535123, 0.045290425, 0.04522967, 0.045168936, 0.045108214, 0.045047525, 0.044986874, 0.044926256, 0.04486566, 0.044805098, 0.044744544, 0.044684038, 0.044623565, 0.044563103, 0.044502683, 0.044442274, 0.044381902, 0.044321574, 0.044261247, 0.044200975, 0.044140719, 0.044080488, 0.044020299, 0.043960139, 0.043899983, 0.043839876, 0.04377979, 0.043719739, 0.043659709, 0.043599714, 0.043539736, 0.043479796, 0.04341989, 0.043360002, 0.043300148, 0.043240312, 0.043180525, 0.043120764, 0.043061018, 0.043001305, 0.042941615, 0.042881951, 0.042822339, 0.042762734, 0.042703159, 0.042643622, 0.042584103, 0.042524625, 0.042465173, 0.042405736, 0.042346347, 0.04228697, 0.042227633, 0.042168316, 0.042109035, 0.042049766, 0.041990541, 0.041931357, 0.041872177, 0.041813035, 0.041753918, 0.041694824, 0.041635782, 0.041576743, 0.041517742, 0.041458782, 0.041399825, 0.041340925, 0.041282039, 0.041223165, 0.041164346, 0.041105546, 0.041046776, 0.040988036, 0.040929317, 0.040870629, 0.040811971, 0.04075335, 0.040694743, 0.040636174, 0.040577624, 0.040519103, 0.040460635, 0.040402159, 0.040343735, 0.040285341, 0.040226959, 0.040168617, 0.040110309, 0.040052019, 0.039993763, 0.039935522, 0.039877325, 0.039819162, 0.039761018, 0.039702885, 0.039644808, 0.039586741, 0.039528713, 0.039470706, 0.039412733, 0.039354794, 0.039296888, 0.039238997, 0.039181132, 0.039123293, 0.039065491, 0.039007735, 0.038949978, 0.038892262, 0.038834579, 0.038776908, 0.038719282, 0.038661681, 0.038604107, 0.038546555, 0.038489033, 0.038431555, 0.0383741, 0.038316663, 0.038259245, 0.038201883, 0.038144536, 0.038087226, 0.038029931, 0.037972677, 0.037915431, 0.037858244, 0.037801057, 0.037743915, 0.037686806, 0.037629701, 0.037572641, 0.037515625, 0.037458606, 0.037401631, 0.03734469, 0.037287764, 0.037230887, 0.037174013, 0.037117187, 0.037060376, 0.03700361, 0.036946852, 0.036890145, 0.036833432, 0.036776785, 0.036720168, 0.036663536, 0.036606964, 0.036550421, 0.03649389, 0.036437418, 0.036380947, 0.036324512, 0.036268111, 0.036211733, 0.036155384, 0.036099069, 0.036042772, 0.035986502, 0.035930272, 0.035874072, 0.035817895, 0.035761755, 0.035705622, 0.035649534, 0.03559348, 0.035537433, 0.035481431, 0.035425458, 0.035369489, 0.035313595, 0.035257693, 0.035201825, 0.035145998, 0.035090182, 0.035034418, 0.034978665, 0.034922935, 0.034867253, 0.034811575, 0.034755956, 0.034700345, 0.03464476, 0.034589209, 0.034533694, 0.034478199, 0.034422725, 0.034367301, 0.034311894, 0.034256503, 0.034201168, 0.034145854, 0.034090556, 0.03403528, 0.033980042, 0.033924848, 0.033869661, 0.033814505, 0.033759385, 0.033704288, 0.033649236, 0.033594191, 0.033539198, 0.033484206, 0.033429254, 0.033374339, 0.03331944, 0.033264577, 0.03320973, 0.03315492, 0.033101402, 0.033049159, 0.032996964, 0.032944832, 0.032892719, 0.032840662, 0.032788619, 0.032736648, 0.032684706, 0.032632805, 0.032580979, 0.032529153, 0.032477371, 0.032425646, 0.032373954, 0.032322317, 0.032270696, 0.032219131, 0.03216761, 0.032116152, 0.032064721, 0.032013319, 0.031961966, 0.031910639, 0.031859379, 0.031808157, 0.03175696, 0.031705812, 0.031654712, 0.031603672, 0.031552654, 0.031501666, 0.031450741, 0.031399835, 0.031348988, 0.031298187, 0.031247424, 0.031196691, 0.031146007, 0.031095363, 0.031044777, 0.030994209, 0.030943708, 0.030893221, 0.0308428, 0.030792411, 0.030742077, 0.030691763, 0.030641496, 0.030591249, 0.03054109, 0.030490965, 0.030440846, 0.030390801, 0.030340783, 0.030290812, 0.030240888, 0.030191004, 0.030141154, 0.030091355, 0.030041596, 0.029991888, 0.029942185, 0.029892556, 0.029842963, 0.029793423, 0.029743921, 0.029694455, 0.029645015, 0.02959564, 0.029546298, 0.029496999, 0.02944774, 0.029398529, 0.029349335, 0.029300207, 0.029251128, 0.029202068, 0.029153066, 0.029104089, 0.02905518, 0.029006299, 0.028957458, 0.028908649, 0.028859906, 0.028811188, 0.028762523, 0.028713893, 0.028665297, 0.028616745, 0.028568262, 0.028519791, 0.028471377, 0.028422983, 0.028374663, 0.028326359, 0.028278116, 0.02822989, 0.028181728, 0.028133586, 0.028085511, 0.028037472, 0.027989451, 0.027941508, 0.02789358, 0.027845718, 0.027797878, 0.02775009, 0.027702339, 0.027654639, 0.027606966, 0.027559353, 0.027511757, 0.027464213, 0.027416715, 0.027369276, 0.027321853, 0.027274484, 0.027227141, 0.027179867, 0.02713261, 0.027085397, 0.027038245, 0.026991127, 0.026944017, 0.026896996, 0.026850002, 0.026803041, 0.026756139, 0.026709268, 0.026662445, 0.026615649, 0.026568914, 0.026522206, 0.026475549, 0.026428927, 0.026382366, 0.026335806, 0.026289321, 0.026242858, 0.02619648, 0.0261501, 0.026103765, 0.026057474, 0.026011234, 0.025965055, 0.025918877, 0.025872758, 0.025826702, 0.025780655, 0.02573465, 0.025688723, 0.025642816, 0.025596958, 0.025551111, 0.02550534, 0.025459614, 0.025413912, 0.025368238, 0.025322642, 0.025277073, 0.025231536, 0.025186054, 0.025140606, 0.025095209, 0.025049858, 0.025004523, 0.024959249, 0.024914008, 0.024868812, 0.024823667, 0.024778541, 0.024733467, 0.024688445, 0.024643457, 0.024598513, 0.024553631, 0.024508746, 0.02446395, 0.024419162, 0.024374446, 0.024329744, 0.024285104, 0.02424049, 0.02419593, 0.024151394, 0.024106929, 0.024062479, 0.024018066, 0.02397372, 0.02392943, 0.023885129, 0.023840915, 0.023796709, 0.023752583, 0.023708474, 0.023664391, 0.023620384, 0.023576381, 0.023532443, 0.023488577, 0.02344472, 0.02340089, 0.023357134, 0.02331339, 0.023269707, 0.023226069, 0.023182472, 0.023138909, 0.023095382, 0.023051899, 0.023008484, 0.022965072, 0.022921726, 0.022878435, 0.022835169, 0.022791918, 0.02274875, 0.022705603, 0.022662511, 0.022619454, 0.022576412, 0.022533452, 0.022490516, 0.022447614, 0.022404792, 0.022361984, 0.022319205, 0.022276497, 0.022233803, 0.022191165, 0.022148583, 0.022106022, 0.022063505, 0.022021037, 0.021978596, 0.021936225, 0.021893864, 0.021851562, 0.021809306, 0.02176708, 0.02172491, 0.021682784, 0.021640671, 0.021598633, 0.021556627, 0.021514637, 0.021472728, 0.021430818, 0.02138897, 0.021347189, 0.021305436, 0.0212637, 0.021222033, 0.021180393, 0.021138813, 0.021097258, 0.021055758, 0.021014282, 0.020972859, 0.020931479, 0.020890152, 0.02084884, 0.020807583, 0.020766366, 0.020725198, 0.02068406, 0.020642975, 0.020601936, 0.020560937, 0.020519966, 0.020479031, 0.020438174, 0.020397313, 0.020356517, 0.020315781, 0.020275069, 0.020234376, 0.020193771, 0.020153163, 0.020112636, 0.020072136, 0.020031676, 0.019991262, 0.019950872, 0.019910544, 0.019870259, 0.019829992, 0.019789794, 0.019749615, 0.019709487, 0.019669402, 0.019629361, 0.019589363, 0.0195494, 0.019509498, 0.019469615, 0.019429808, 0.019389993, 0.019350247, 0.019310554, 0.019270878, 0.019231254, 0.019191682, 0.01915212, 0.019112645, 0.019073185, 0.019033762, 0.018994398, 0.018955071, 0.018915793, 0.018876562, 0.018837338, 0.018798174, 0.018759057, 0.01871996, 0.018680919, 0.018641932, 0.018602978, 0.018564073, 0.018525207, 0.018486375, 0.018447621, 0.018408855, 0.018370172, 0.018331503, 0.018292887, 0.018254306, 0.01821577, 0.018177269, 0.018138854, 0.01810042, 0.018062048, 0.018023737, 0.017985445, 0.017947219, 0.017909029, 0.017870849, 0.017832765, 0.017794671, 0.017756637, 0.017718658, 0.017680693, 0.01764279, 0.017604923, 0.017567115, 0.017529327, 0.017491607, 0.017453887, 0.017416254, 0.017378647, 0.017341083, 0.017303547, 0.017266061, 0.017228594, 0.01719122, 0.017153841, 0.017116528, 0.017079243, 0.017042018, 0.017004821, 0.016967675, 0.016930563, 0.016893514, 0.016856471, 0.016819488, 0.01678255, 0.01674564, 0.01670878, 0.016671965, 0.016635209, 0.016598456, 0.016561786, 0.016525118, 0.01648852, 0.016451957, 0.016415445, 0.01637896, 0.016342517, 0.016306102, 0.016269781, 0.016233442, 0.016197175, 0.016160959, 0.016124761, 0.016088614, 0.01605252, 0.016016459, 0.015980436, 0.015944455, 0.015908515, 0.015872637, 0.01583677, 0.015800955, 0.015765183, 0.015729479, 0.015693776, 0.015658149, 0.015622525, 0.015586979, 0.015551467, 0.015515981, 0.015480556, 0.015445158, 0.015409803, 0.015374533, 0.015339239, 0.015304022, 0.015268841, 0.015233685, 0.015198591, 0.01516354, 0.015128523, 0.015093551, 0.015058612, 0.015023726, 0.014988894, 0.014954068, 0.01491932, 0.014884601, 0.014849931, 0.014815271, 0.014780699, 0.014746126, 0.014711621, 0.014677144, 0.014642719, 0.014608329, 0.014573991, 0.014539669, 0.014505446, 0.014471218, 0.014437038, 0.014402908, 0.014368812, 0.014334753, 0.014300744, 0.014266772, 0.014232851, 0.014198964, 0.014165121, 0.014131339, 0.014097558, 0.014063855, 0.014030177, 0.013996559, 0.013962951, 0.01392943, 0.0138959, 0.013862458, 0.013829032, 0.013795642, 0.013762311, 0.013729008, 0.01369573, 0.013662548, 0.013629365, 0.013596245, 0.013563158, 0.013530106, 0.013497098, 0.013464143, 0.013431221, 0.013398334, 0.0133655, 0.01333271, 0.01329997, 0.01326724, 0.013234572, 0.013201954, 0.013169372, 0.013136816, 0.013104329, 0.013071859, 0.013039459, 0.013007078, 0.012974747, 0.012942461, 0.012910209, 0.012877991, 0.012845827, 0.012813714, 0.012781644, 0.012749584, 0.012717584, 0.012685645, 0.012653706, 0.012621837, 0.01259001, 0.01255822, 0.012526472, 0.012494776, 0.012463107, 0.012431507, 0.012399907, 0.012368386, 0.012336881, 0.012305437, 0.012274003, 0.012242637, 0.012212412, 0.012183088, 0.012153819, 0.012124575, 0.012095348, 0.01206619, 0.012037052, 0.012007955, 0.011978911, 0.011949901, 0.011920919, 0.011891953, 0.011863056, 0.011834177, 0.011805351, 0.011776558, 0.01174781, 0.011719069, 0.011690408, 0.011661747, 0.011633154, 0.011604571, 0.011576041, 0.011547535, 0.011519082, 0.011490655, 0.011462281, 0.01143394, 0.011405635, 0.011377348, 0.011349112, 0.011320919, 0.011292744, 0.011264632, 0.011236551, 0.011208507, 0.011180498, 0.011152523, 0.011124574, 0.011096686, 0.011068825, 0.011041023, 0.011013213, 0.010985482, 0.01095775, 0.010930098, 0.010902452, 0.010874843, 0.010847285, 0.010819762, 0.010792283, 0.010764831, 0.010737411, 0.010710046, 0.010682688, 0.010655391, 0.010628147, 0.010600911, 0.010573718, 0.01054656, 0.010519454, 0.010492376, 0.01046534, 0.01043833, 0.010411372, 0.01038444, 0.010357561, 0.010330698, 0.010303897, 0.010277105, 0.010250391, 0.010223676, 0.010197005, 0.010170378, 0.010143794, 0.010117237, 0.010090722, 0.010064242, 0.010037806, 0.010011386, 0.009985012, 0.0099586975, 0.0099323997, 0.009906156, 0.0098799374, 0.0098537523, 0.009827612, 0.0098015061, 0.0097754262, 0.0097494163, 0.009723423, 0.0096974745, 0.0096715428, 0.0096456716, 0.0096198171, 0.0095940325, 0.0095682489, 0.0095425257, 0.0095168287, 0.0094911754, 0.0094655557, 0.0094399629, 0.0094144307, 0.0093889162, 0.0093634361, 0.0093379999, 0.0093126157, 0.0092872493, 0.009261935, 0.0092366543, 0.0092114089, 0.009186198, 0.0091610318, 0.0091358991, 0.0091108019, 0.00908574, 0.00906072, 0.009035727, 0.0090108039, 0.0089858724, 0.0089610182, 0.0089361724, 0.0089113964, 0.0088866213, 0.0088618975, 0.0088372175, 0.0088125542, 0.0087879533, 0.0087633682, 0.008738853, 0.0087143388, 0.0086898925, 0.0086654564, 0.0086410716, 0.0086167129, 0.0085924156, 0.0085681435, 0.008543916, 0.0085197054, 0.0084955469, 0.0084714228, 0.0084473342, 0.0084232716, 0.0083992779, 0.0083752843, 0.0083513698, 0.0083274553, 0.0083036004, 0.0082797632, 0.0082559697, 0.0082322378, 0.0082084965, 0.0081848335, 0.0081611872, 0.0081375949, 0.0081140175, 0.008090511, 0.0080670053, 0.0080435509, 0.0080201393, 0.007996764, 0.0079734223, 0.0079501243, 0.0079268515, 0.0079036327, 0.0078804474, 0.0078572975, 0.0078341644, 0.0078111021, 0.0077880472, 0.0077650631, 0.007742078, 0.0077191615, 0.0076962556, 0.0076734098, 0.0076505984, 0.0076277959, 0.0076050814, 0.0075823483, 0.0075597018, 0.0075370572, 0.0075144805, 0.0074919122, 0.0074693966, 0.0074469168, 0.0074244784, 0.0074020675, 0.007379699, 0.007357358, 0.0073350687, 0.0073128231, 0.007290611, 0.0072684176, 0.0072462847, 0.0072241602, 0.0072021149, 0.0071800593, 0.007158075, 0.0071360893, 0.0071141999, 0.007092319, 0.0070704552, 0.0070486525, 0.0070268675, 0.0070051346, 0.0069834529, 0.0069617983, 0.006940152, 0.0069186017, 0.0068970425, 0.0068755443, 0.0068540545, 0.0068326257, 0.0068112141, 0.0067898636, 0.0067685391, 0.0067472756, 0.0067260121, 0.0067048091, 0.0066836234, 0.0066624903, 0.0066413921, 0.0066203368, 0.0065992991, 0.0065783309, 0.0065573803, 0.0065364558, 0.0065155835, 0.0064947368, 0.006473951, 0.006453183, 0.0064324671, 0.006411795, 0.0063911397, 0.0063705104, 0.0063499594, 0.0063294005, 0.00630891, 0.0062884293, 0.0062680081, 0.006247614, 0.0062272893, 0.0062069646, 0.006186692, 0.0061664283, 0.0061462335, 0.0061260825, 0.0061059492, 0.0060858675, 0.0060658297, 0.006045809, 0.0060258149, 0.0060058809, 0.005985965, 0.0059661097, 0.0059462716, 0.0059264861, 0.0059067346, 0.0058870274, 0.0058673369, 0.0058477162, 0.0058280956, 0.005808536, 0.0057889936, 0.0057695294, 0.005750048, 0.0057306448, 0.0057112677, 0.0056919162, 0.0056726085, 0.0056533357, 0.0056341062, 0.0056149117, 0.0055957776, 0.0055766352, 0.0055575795, 0.0055385241, 0.0055195121, 0.0055005434, 0.0054816091, 0.0054627103, 0.0054438547, 0.0054250425, 0.005406274, 0.0053875218, 0.0053688316, 0.0053501413, 0.0053315209, 0.0053129084, 0.0052943747, 0.0052758316, 0.0052573667, 0.0052389116, 0.0052205082, 0.0052021127, 0.0051837787, 0.0051654968, 0.0051472238, 0.0051290207, 0.0051108249, 0.0050926995, 0.005074583, 0.0050565097, 0.0050384626, 0.0050204764, 0.0050025163, 0.0049845907, 0.0049667, 0.0049488614, 0.0049310401, 0.0049132886, 0.0048955372, 0.0048778378, 0.004860173, 0.0048425691, 0.0048249653, 0.0048074401, 0.0047899145, 0.004772441, 0.0047549843, 0.0047375984, 0.0047202292, 0.0047028949, 0.0046856301, 0.0046683657, 0.0046511707, 0.0046339747, 0.004616858, 0.0045997496, 0.0045826766, 0.0045656548, 0.0045486768, 0.0045317165, 0.0045148167, 0.0044979174, 0.0044810958, 0.0044642743, 0.0044475314, 0.0044307793, 0.0044141142, 0.0043974579, 0.0043808278, 0.004364267, 0.0043477323, 0.0043312153, 0.0043147504, 0.0042983205, 0.0042819162, 0.0042655817, 0.0042492552, 0.0042329906, 0.0042167427, 0.0042005298, 0.0041843606, 0.0041682343, 0.0041521522, 0.0041360958, 0.0041200914, 0.0041041044, 0.0040881527, 0.004072261, 0.0040563871, 0.0040405565, 0.0040247524, 0.0040090182, 0.003993283, 0.0039776005, 0.0039619613, 0.0039463569, 0.0039307787, 0.0039152526, 0.0038997612, 0.0038842957, 0.0038688916, 0.0038535045, 0.0038381782, 0.0038228435, 0.0038075869, 0.003792339, 0.0037771517, 0.0037619909, 0.0037468735, 0.0037317991, 0.0037167598, 0.0037017381, 0.0036867769, 0.0036718417, 0.0036569419, 0.0036420678, 0.0036272716, 0.0036124671, 0.0035977236, 0.0035830233, 0.0035683315, 0.0035537095, 0.0035391136, 0.0035245612, 0.003510026, 0.0034955514, 0.0034810861, 0.003466699, 0.0034523204, 0.0034379764, 0.0034236673, 0.0034094106, 0.0033951884, 0.0033810011, 0.0033668657, 0.0033527566, 0.0033386736, 0.0033246512, 0.0033106464, 0.0032966766, 0.0032827412, 0.0032688756, 0.0032550099, 0.0032411963, 0.0032274262, 0.0032136822, 0.0031999815, 0.0031863158, 0.0031726849, 0.0031590972, 0.0031455706, 0.0031320353, 0.0031185781, 0.0031051298, 0.0030917334, 0.0030783545, 0.0030650275, 0.0030517357, 0.0030384872, 0.0030252822, 0.0030121033, 0.002998959, 0.0029858672, 0.0029727924, 0.0029597702, 0.0029467649, 0.0029338379, 0.0029208937, 0.0029080191, 0.0028951792, 0.0028823654, 0.0028696125, 0.0028568769, 0.0028441844, 0.0028315187, 0.002818922, 0.0028063254, 0.0027938073, 0.0027812892, 0.0027688318, 0.0027563917, 0.002743995, 0.0027316418, 0.0027193322, 0.0027070399, 0.0026948086, 0.0026825862, 0.0026704154, 0.0026582885, 0.0026462048, 0.00263413, 0.0026221334, 0.0026101451, 0.0025981921, 0.0025862998, 0.0025744073, 0.0025625848, 0.0025507878, 0.0025390259, 0.0025273073, 0.002515641, 0.0025039748, 0.0024923866, 0.0024807986, 0.00246928, 0.0024577701, 0.0024463213, 0.0024348807, 0.0024235188, 0.0024121741, 0.0024008641, 0.0023895802, 0.0023783487, 0.0023671431, 0.0023559812, 0.0023448537, 0.002333787, 0.0023227294, 0.0023117322, 0.0023007528, 0.0022897993, 0.0022789154, 0.0022680487, 0.0022572344, 0.002246429, 0.0022357013, 0.0022249827, 0.0022148634, 0.0022054312, 0.0021960146, 0.0021866171, 0.0021772501, 0.0021679006, 0.0021585685, 0.0021492711, 0.0021399888, 0.0021307021, 0.0021214569, 0.0021122291, 0.0021030121, 0.002093819, 0.0020846606, 0.0020754959, 0.0020663831, 0.0020572792, 0.0020481795, 0.0020391059, 0.0020300674, 0.0020210284, 0.0020120156, 0.0020030355, 0.0019940706, 0.0019851252, 0.0019761927, 0.0019672716, 0.0019583849, 0.0019495091, 0.0019406657, 0.0019318336, 0.0019230425, 0.0019142425, 0.0019054777, 0.0018967345, 0.0018879955, 0.0018792872, 0.0018705896, 0.0018619443, 0.0018532814, 0.0018446621, 0.0018360513, 0.0018274644, 0.0018188801, 0.0018103411, 0.0018018087, 0.0017932937, 0.0017848287, 0.0017763525, 0.0017679138, 0.0017594814, 0.0017510685, 0.0017426687, 0.0017343079, 0.0017259645, 0.0017176298, 0.0017093429, 0.0017010388, 0.0016927782, 0.001684526, 0.0016763, 0.0016680806, 0.0016598981, 0.0016517352, 0.0016435788, 0.0016354679, 0.0016273549, 0.0016192724, 0.001611192, 0.001603155, 0.0015951248, 0.0015871117, 0.0015791357, 0.0015711684, 0.001563227, 0.0015552945, 0.0015473925, 0.0015394901, 0.0015316206, 0.0015237816, 0.0015159554, 0.0015081597, 0.0015003707, 0.0014925902, 0.0014848554, 0.0014771292, 0.0014694097, 0.0014617292, 0.0014540748, 0.0014464139, 0.0014387964, 0.0014311963, 0.0014235963, 0.001416031, 0.0014084917, 0.0014009612, 0.0013934481, 0.0013859762, 0.001378511, 0.0013710653, 0.0013636433, 0.0013562236, 0.0013488453, 0.0013414668, 0.0013341254, 0.0013268014, 0.0013195099, 0.0013122229, 0.0013049553, 0.0012977138, 0.001290481, 0.0012832744, 0.0012760764, 0.0012689305, 0.0012617673, 0.0012546649, 0.0012475452, 0.0012404688, 0.0012333969, 0.0012263531, 0.0012193248, 0.0012123159, 0.0012053482, 0.0011983805, 0.0011914346, 0.0011845104, 0.0011776058, 0.0011707078, 0.0011638466, 0.0011570051, 0.0011501786, 0.0011433915, 0.0011366042, 0.0011298321, 0.0011230884, 0.0011163641, 0.0011096464, 0.0011029635, 0.0010963131, 0.0010896715, 0.0010830538, 0.0010764382, 0.0010698531, 0.0010632897, 0.0010567524, 0.0010502151, 0.0010437126, 0.0010372361, 0.001030777, 0.0010243353, 0.0010179023, 0.0010114997, 0.0010051145, 0.00099874684, 0.00099240709, 0.00098610029, 0.00097978686, 0.0009735059, 0.00096724031, 0.00096100068, 0.00095477636, 0.00094856939, 0.00094238197, 0.00093622931, 0.0009300941, 0.00092395884, 0.00091785833, 0.0009117666, 0.00090570742, 0.00089966343, 0.00089364767, 0.00088765583, 0.00088166411, 0.00087570044, 0.00086976303, 0.00086384069, 0.00085792935, 0.00085204182, 0.00084618042, 0.00084033859, 0.00083453144, 0.00082872441, 0.00082293904, 0.00081717107, 0.0008114379, 0.00080570468, 0.00080000627, 0.00079434039, 0.00078867027, 0.00078303268, 0.00077741465, 0.00077179883, 0.00076622004, 0.00076064758, 0.00075511215, 0.00074959418, 0.00074410654, 0.00073861465, 0.00073314877, 0.00072771765, 0.00072228658, 0.00071689021, 0.0007114982, 0.00070614973, 0.0007008033, 0.00069549831, 0.00069018238, 0.00068490341, 0.00067963533, 0.00067439978, 0.00066917518, 0.00066396577, 0.00065880193, 0.0006536491, 0.00064850046, 0.00064338016, 0.0006382729, 0.00063319167, 0.00062812789, 0.00062309013, 0.00061806111, 0.00061308639, 0.00060810521, 0.00060313044, 0.00059819489, 0.00059327448, 0.0005883628, 0.00058348814, 0.00057863723, 0.00057377992, 0.00056898344, 0.00056416739, 0.0005593861, 0.00055462873, 0.00054989738, 0.00054516608, 0.00054046966, 0.00053579907, 0.0005311374, 0.00052650174, 0.00052187475, 0.0005172739, 0.00051269471, 0.00050812424, 0.00050359068, 0.00049907243, 0.00049458229, 0.00049009878, 0.00048563478, 0.00048119688, 0.00047678509, 0.00047237976, 0.00046799189, 0.00046365397, 0.00045930079, 0.00045499764, 0.0004506945, 0.00044640873, 0.00044214688, 0.00043791544, 0.0004336905, 0.00042948301, 0.00042531893, 0.00042115702, 0.00041702122, 0.00041290934, 0.00040880396, 0.00040472468, 0.00040065838, 0.0003966247, 0.0003926041, 0.00038862042, 0.00038463675, 0.00038067481, 0.00037674111, 0.00037282263, 0.00036892155, 0.00036504434, 0.00036118671, 0.00035733997, 0.00035353666, 0.00034973121, 0.000345954, 0.00034219201, 0.00033845825, 0.0003347419, 0.0003310451, 0.00032737438, 0.00032371451, 0.00032008076, 0.00031645567, 0.00031285666, 0.00030927503, 0.00030571735, 0.00030218356, 0.00029866275, 0.00029517678, 0.00029170382, 0.00028823092, 0.00028480357, 0.00028138497, 0.00027798154, 0.00027460643, 0.00027126604, 0.00026790827, 0.00026460917, 0.0002613166, 0.00025802187, 0.00025477278, 0.00025153454, 0.00024831152, 0.00024511458, 0.00024196113, 0.00023879028, 0.00023566504, 0.00023254634, 0.00022943635, 0.00022636545, 0.00022329671, 0.00022027147, 0.00021725494, 0.0002142623, 0.00021128701, 0.0002083313, 0.00020540169, 0.00020248076, 0.00019958157, 0.00019669975, 0.00019386143, 0.00019100786, 0.0001882043, 0.00018540942, 0.00018262975, 0.00017986313, 0.00017713997, 0.00017442335, 0.00017171758, 0.00016906613, 0.00016639948, 0.00016376759, 0.00016115312, 0.00015855383, 0.00015597194, 0.00015341831, 0.00015088423, 0.00014836536, 0.00014588125, 0.00014340586, 0.00014095219, 0.00013851808, 0.00013610569, 0.00013369767, 0.00013132225, 0.00012897508, 0.00012663442, 0.00012433072, 0.00012203569, 0.00011976024, 0.00011750219, 0.00011527454, 0.00011305125, 0.00011085618, 0.00010868723, 0.00010653565, 0.00010440363, 0.00010228684, 0.00010018741, 9.8111901e-05, 9.6053773e-05, 9.4021729e-05, 9.2013601e-05, 9.0025023e-05, 8.8051653e-05, 8.608916e-05, 8.4161431e-05, 8.2248916e-05, 8.035596e-05, 7.8473873e-05, 7.6637429e-05, 7.4787946e-05, 7.2981929e-05, 7.1197632e-05, 6.9415524e-05, 6.7657311e-05, 6.5925182e-05, 6.4221305e-05, 6.2513092e-05, 6.0859194e-05, 5.9203128e-05, 5.7573161e-05, 5.5958382e-05, 5.4354477e-05, 5.2785348e-05, 5.1231436e-05, 4.9697075e-05, 4.8177939e-05, 4.670443e-05, 4.5222238e-05, 4.3766115e-05, 4.2338252e-05, 4.0925599e-05, 3.953468e-05, 3.8152455e-05, 3.681369e-05, 3.546842e-05, 3.4173132e-05, 3.2869131e-05, 3.1602103e-05, 3.0345929e-05, 2.9109315e-05, 2.7898775e-05, 2.6696944e-05, 2.5545092e-05, 2.4393223e-05, 2.3263106e-05, 2.2148204e-05, 2.1059375e-05, 1.9970546e-05, 1.8925186e-05, 1.7888513e-05, 1.6880093e-05, 1.5886893e-05, 1.492629e-05, 1.3983073e-05, 1.3037688e-05, 1.2129246e-05, 1.1251224e-05, 1.0364515e-05, 9.5082341e-06, 8.6823738e-06, 7.8804214e-06, 7.0762958e-06, 6.3091175e-06, 5.5615001e-06, 4.8225761e-06, 4.1097264e-06, 3.4316577e-06, 2.7557558e-06, 2.0950745e-06, 1.4800278e-06, 8.6932806e-07, 2.8252916e-07, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 8.8129638e-16, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.4731435e-05, 1.8690466e-07, 2.3949874e-06, 4.6161103e-06, 6.8415798e-06, 9.084436e-06, 1.1322944e-05, 1.3583187e-05, 1.5847776e-05, 1.8116711e-05, 2.0398687e-05, 2.268501e-05, 2.4980025e-05, 2.7292426e-05, 2.9622215e-05, 3.1934618e-05, 3.4281791e-05, 3.6620273e-05, 3.8976141e-05, 4.1332009e-05, 4.3705266e-05, 4.6087211e-05, 4.847785e-05, 5.0877185e-05, 5.3276519e-05, 5.5693243e-05, 5.8118654e-05, 6.0561451e-05, 6.2995568e-05, 6.5447057e-05, 6.7907247e-05, 7.0376125e-05, 7.2853698e-05, 7.5339965e-05, 7.7843622e-05, 8.033857e-05, 8.2859617e-05, 8.5380656e-05, 8.7910383e-05, 9.0448812e-05, 9.300463e-05, 9.5569136e-05, 9.8133634e-05, 0.00010070684, 0.00010328873, 0.00010588801, 0.00010848729, 0.00011110395, 0.00011372061, 0.00011635467, 0.00011898872, 0.00012164017, 0.00012429159, 0.00012696041, 0.00012963795, 0.00013231546, 0.00013501904, 0.00013771396, 0.00014042624, 0.00014314723, 0.00014587691, 0.00014860659, 0.00015136236, 0.00015411811, 0.00015687387, 0.0001596557, 0.00016242884, 0.00016522806, 0.0001680186, 0.00017083521, 0.00017365182, 0.00017647712, 0.00017931112, 0.0001821538, 0.00018501388, 0.00018787396, 0.00019075141, 0.00019362888, 0.00019651504, 0.00019940989, 0.00020232212, 0.00020523435, 0.00020816397, 0.00021110229, 0.0002140406, 0.0002169963, 0.00021995201, 0.0002229251, 0.00022589817, 0.00022888865, 0.00023188784, 0.000234887, 0.00023790356, 0.0002409288, 0.00024395404, 0.00024700537, 0.00025005668, 0.00025310801, 0.00025617672, 0.00025925413, 0.00026234894, 0.00026543502, 0.00026853851, 0.0002716594, 0.00027477156, 0.00027790983, 0.00028104809, 0.00028419506, 0.0002873507, 0.00029051505, 0.00029368806, 0.00029687851, 0.0003000689, 0.0003032767, 0.00030648452, 0.00030970102, 0.00031293492, 0.00031616876, 0.00031942007, 0.00032267135, 0.00032594, 0.00032920865, 0.0003324947, 0.00033578943, 0.00033908416, 0.00034239629, 0.00034570842, 0.0003490466, 0.00035237614, 0.00035572302, 0.00035906993, 0.00036244292, 0.00036580718, 0.00036919757, 0.0003725792, 0.0003759783, 0.00037939471, 0.00038280248, 0.00038623629, 0.00038966144, 0.00039311266, 0.00039656385, 0.0004000238, 0.00040349236, 0.00040696969, 0.00041046436, 0.00041395903, 0.00041745373, 0.00042097448, 0.00042450393, 0.00042803338, 0.00043158024, 0.00043512709, 0.00043868262, 0.00044224682, 0.00044583715, 0.00044942743, 0.00045301777, 0.00045662548, 0.00046023313, 0.00046385825, 0.0004674833, 0.00047113447, 0.00047476823, 0.00047843676, 0.00048210536, 0.00048577393, 0.00048945984, 0.00049315445, 0.0004968578, 0.00050056982, 0.00050429051, 0.00050801988, 0.00051175797, 0.00051549607, 0.00051926024, 0.00052303309, 0.00052679732, 0.00053058757, 0.00053437782, 0.00053816807, 0.00054198439, 0.00054580072, 0.00054962572, 0.00055346813, 0.00055731926, 0.00056117034, 0.00056503015, 0.00056889863, 0.00057279319, 0.00057667913, 0.00058057363, 0.00058447698, 0.00058840628, 0.00059232692, 0.00059626496, 0.00060020306, 0.00060415844, 0.00060812256, 0.00061208667, 0.00061606814, 0.00062005839, 0.00062405725, 0.00062806485, 0.00063208112, 0.00063610612, 0.00064013974, 0.00064417341, 0.00064822449, 0.00065229286, 0.00065636134, 0.00066043844, 0.00066452427, 0.0006686275, 0.000672722, 0.00067683391, 0.00068095454, 0.00068509247, 0.00068923918, 0.00069338584, 0.00069753255, 0.00070170528, 0.00070588675, 0.00071006821, 0.00071426702, 0.0007184745, 0.00072268205, 0.00072689826, 0.00073113188, 0.00073536549, 0.00073961646, 0.00074387621, 0.00074813585, 0.00075241295, 0.00075669872, 0.00076099322, 0.00076528761, 0.00076959952, 0.00077392871, 0.00077824923, 0.00078257849, 0.00078693382, 0.00079128915, 0.00079564448, 0.00080002582, 0.00080440717, 0.00080879725, 0.00081319606, 0.00081760355, 0.00082201971, 0.00082645327, 0.00083088683, 0.00083532906, 0.00083977997, 0.00084423961, 0.00084871665, 0.00085319369, 0.00085768808   }, 
   { 0.0062816157, 0.0062694573, 0.0062573352, 0.0062452126, 0.0062331627, 0.0062211482, 0.0062091337, 0.0061971918, 0.0061852494, 0.0061733071, 0.0061614364, 0.0061495658, 0.0061377673, 0.0061259689, 0.0061142067, 0.0061024437, 0.0060907532, 0.0060790633, 0.0060674087, 0.0060557895, 0.006044243, 0.0060326606, 0.0060211499, 0.0060096392, 0.0059981281, 0.0059866896, 0.0059752865, 0.0059638475, 0.005952517, 0.0059411861, 0.005929891, 0.0059186318, 0.0059074811, 0.0058962223, 0.0058850353, 0.0058738845, 0.0058627333, 0.0058516543, 0.0058406112, 0.0058296043, 0.005818597, 0.0058076256, 0.0057966909, 0.0057857912, 0.0057749283, 0.0057640653, 0.0057532731, 0.0057424824, 0.0057316911, 0.0057209721, 0.0057102884, 0.0056996047, 0.0056889215, 0.0056783818, 0.0056678066, 0.005657231, 0.005646727, 0.0056361877, 0.0056257206, 0.0056152889, 0.0056048571, 0.0055944617, 0.005584138, 0.0055738143, 0.0055635269, 0.0055532749, 0.0055430587, 0.0055328789, 0.0055226991, 0.0055125193, 0.0055024116, 0.0054923398, 0.0054823039, 0.0054723038, 0.0054623042, 0.0054523405, 0.0054424121, 0.0054325201, 0.0054226643, 0.0054128445, 0.0054030237, 0.0053932038, 0.0053834557, 0.0053737438, 0.0053640669, 0.0053543188, 0.0053447867, 0.0053351824, 0.005325614, 0.0053160461, 0.0053065135, 0.0052970177, 0.0052875574, 0.0052780965, 0.0052687083, 0.0052593197, 0.0052500037, 0.0052406867, 0.0052314065, 0.0052221618, 0.0052129528, 0.0052037803, 0.0051945718, 0.0051854355, 0.0051764064, 0.0051673059, 0.0051582414, 0.0051492485, 0.0051402557, 0.0051312991, 0.005122378, 0.0051135295, 0.0051046447, 0.0050958316, 0.0050869826, 0.0050782058, 0.0050694649, 0.0050606881, 0.0050520189, 0.0050434219, 0.0050348248, 0.0050262278, 0.0050176666, 0.0050090696, 0.0050005447, 0.0049920911, 0.0049836021, 0.0049751848, 0.0049668038, 0.0049584224, 0.0049501131, 0.0049418039, 0.0049335305, 0.0049252929, 0.0049170917, 0.0049088905, 0.0049007251, 0.0048926678, 0.0048845378, 0.0048764804, 0.0048684226, 0.0048604375, 0.0048524518, 0.0048445384, 0.0048366245, 0.0048287469, 0.0048208693, 0.0048130276, 0.0048052217, 0.0047974521, 0.0047896826, 0.0047819484, 0.0047743591, 0.0047666971, 0.0047591068, 0.0047515174, 0.0047438913, 0.0047363732, 0.0047288556, 0.0047213738, 0.0047139274, 0.0047065173, 0.0046991436, 0.0046918052, 0.0046844673, 0.0046771648, 0.0046698991, 0.0046626688, 0.0046554385, 0.0046483162, 0.004641158, 0.0046340358, 0.0046269498, 0.0046198992, 0.0046128491, 0.0046058707, 0.0045989281, 0.0045919856, 0.0045850794, 0.004578209, 0.0045713023, 0.0045645041, 0.0045577055, 0.0045509068, 0.0045441804, 0.0045375256, 0.0045308713, 0.0045242165, 0.0045176339, 0.0045109792, 0.0045044324, 0.0044978857, 0.0044913748, 0.0044849361, 0.0044784974, 0.0044720946, 0.0044657276, 0.0044593969, 0.0044530658, 0.004446771, 0.0044405479, 0.0044342889, 0.004428138, 0.0044219149, 0.0044157999, 0.0044096848, 0.0044036056, 0.0043975627, 0.0043915557, 0.004385584, 0.0043796129, 0.004373678, 0.0043677427, 0.0043618791, 0.0043560518, 0.0043501528, 0.0043443972, 0.0043386421, 0.0043329224, 0.0043273112, 0.0043216278, 0.0043159802, 0.0043103327, 0.0043047573, 0.004299182, 0.0042936783, 0.0042881747, 0.0042827432, 0.0042773113, 0.0042719161, 0.0042665564, 0.0042612324, 0.004255909, 0.004250621, 0.0042453692, 0.0042401897, 0.0042349738, 0.0042297938, 0.004224686, 0.0042195781, 0.0042145061, 0.00420947, 0.0042044702, 0.0041995062, 0.0041945423, 0.0041895784, 0.0041846861, 0.0041798302, 0.004174938, 0.0041701542, 0.00416537, 0.0041606217, 0.0041559814, 0.0041513052, 0.0041465932, 0.0041419524, 0.0041373484, 0.0041327444, 0.0041282116, 0.0041237152, 0.0041192188, 0.0041147945, 0.0041103703, 0.0041059814, 0.0041016289, 0.0040973127, 0.0040929602, 0.0040887157, 0.004084507, 0.0040802625, 0.0040760897, 0.0040719174, 0.0040678163, 0.0040637157, 0.0040596509, 0.004055622, 0.0040515936, 0.0040476369, 0.0040436438, 0.0040397588, 0.0040359101, 0.0040320256, 0.0040281764, 0.0040243994, 0.0040206225, 0.0040168813, 0.0040131765, 0.0040094713, 0.0040058387, 0.0040022051, 0.0039986083, 0.003995047, 0.0039915219, 0.0039880327, 0.0039845435, 0.0039810902, 0.003977709, 0.0039743278, 0.0039709467, 0.0039676013, 0.0039643282, 0.0039610905, 0.0039578169, 0.0039546154, 0.0039514499, 0.0039483206, 0.0039451914, 0.003942098, 0.00393904, 0.0039360188, 0.0039329971, 0.0039300113, 0.0039270618, 0.0039242199, 0.0039213062, 0.0039184648, 0.0039156228, 0.0039128531, 0.0039100833, 0.0039073499, 0.0039046519, 0.0039019543, 0.0038993284, 0.0038967025, 0.0038941484, 0.0038915945, 0.0038890406, 0.0038865586, 0.0038840764, 0.0038816666, 0.0038792565, 0.0038768821, 0.0038745082, 0.0038722062, 0.0038699398, 0.0038676378, 0.0038654075, 0.0038632313, 0.003861055, 0.0038588969, 0.0038567926, 0.0038547243, 0.0038526738, 0.0038506414, 0.003848627, 0.0038466665, 0.0038447604, 0.0038428537, 0.0038409831, 0.0038391489, 0.0038373321, 0.0038355517, 0.0038337712, 0.0038320622, 0.0038303537, 0.003828699, 0.0038270624, 0.003825462, 0.0038238792, 0.0038223325, 0.0038208035, 0.0038193287, 0.0038178719, 0.0038164333, 0.0038150481, 0.0038136635, 0.0038123142, 0.0038110195, 0.0038097424, 0.0038084835, 0.0038072604, 0.0038060735, 0.0038049042, 0.0038037715, 0.0038026741, 0.0038015952, 0.0038005519, 0.0037995088, 0.0037985735, 0.0037975842, 0.0037966671, 0.0037957679, 0.0037949043, 0.0037940771, 0.0037932678, 0.0037924764, 0.0037917388, 0.0037910196, 0.0037903001, 0.0037896347, 0.003789041, 0.0037884298, 0.0037878721, 0.0037873324, 0.0037868288, 0.0037863434, 0.0037858938, 0.00378548, 0.0037850665, 0.0037847068, 0.0037843829, 0.0037840772, 0.0037838072, 0.0037835557, 0.0037833399, 0.0037831599, 0.0037829981, 0.0037828721, 0.0037827822, 0.0037827103, 0.0037826563, 0.0037826921, 0.0037826921, 0.0037827464, 0.0037828183, 0.0037829441, 0.0037830879, 0.0037832318, 0.0037834477, 0.0037836637, 0.0037839334, 0.0037841853, 0.0037845087, 0.0037849045, 0.0037852642, 0.0037856777, 0.0037861096, 0.0037865774, 0.0037870808, 0.0037876023, 0.003788142, 0.0037887355, 0.0037893471, 0.0037899944, 0.003790678, 0.0037913793, 0.0037921169, 0.003792872, 0.0037936636, 0.0037944908, 0.003795336, 0.0037962175, 0.0037970988, 0.0037980699, 0.0037990769, 0.0038000485, 0.0038010734, 0.0038021344, 0.0038032318, 0.0038043468, 0.00380548, 0.0038066669, 0.0038078721, 0.0038091128, 0.003810354, 0.0038116488, 0.0038130339, 0.0038143466, 0.0038157317, 0.0038171525, 0.0038185914, 0.0038200843, 0.0038215769, 0.0038231057, 0.0038246703, 0.0038262531, 0.0038278897, 0.0038295444, 0.0038312173, 0.0038329258, 0.0038346704, 0.0038364329, 0.0038382316, 0.003840066, 0.0038419366, 0.003843789, 0.0038457315, 0.0038477101, 0.0038496521, 0.0038516668, 0.003853699, 0.0038557674, 0.0038578538, 0.003859994, 0.0038621521, 0.0038643284, 0.0038665407, 0.0038687529, 0.0038710372, 0.0038733932, 0.0038756952, 0.0038780693, 0.0038804614, 0.0038828717, 0.0038853353, 0.0038877996, 0.0038903174, 0.0038928534, 0.0038954255, 0.0038979976, 0.0039006593, 0.003903321, 0.0039060011, 0.0039087166, 0.0039114687, 0.0039142561, 0.0039170617, 0.0039199037, 0.0039227451, 0.0039256411, 0.0039286087, 0.0039315405, 0.0039345259, 0.0039375476, 0.0039405869, 0.0039436445, 0.003946756, 0.0039498853, 0.0039530508, 0.0039562522, 0.003959436, 0.0039626909, 0.0039660186, 0.0039693099, 0.0039726552, 0.0039760182, 0.003979418, 0.0039828531, 0.003986306, 0.0039897952, 0.0039933026, 0.0039968635, 0.0040004067, 0.0040040398, 0.0040076911, 0.0040113418, 0.0040150289, 0.0040187701, 0.0040225289, 0.0040263059, 0.0040301187, 0.0040339497, 0.0040378347, 0.0040417733, 0.0040456764, 0.0040496332, 0.0040536257, 0.0040576546, 0.0040617012, 0.0040657842, 0.0040698848, 0.0040740394, 0.004078194, 0.0040823668, 0.0040866472, 0.0040908917, 0.0040951725, 0.0040994887, 0.0041038413, 0.0041082297, 0.0041126362, 0.0041170605, 0.004121521, 0.0041260174, 0.0041305497, 0.0041350638, 0.0041396865, 0.0041442909, 0.0041489308, 0.0041536074, 0.0041583194, 0.0041630496, 0.0041678157, 0.004172618, 0.0041774199, 0.0041822763, 0.0041871322, 0.0041920785, 0.0041970061, 0.0042019882, 0.0042069699, 0.004212006, 0.0042170603, 0.00422215, 0.004227276, 0.0042324197, 0.0042375638, 0.0042428332, 0.0042480309, 0.0042533008, 0.0042586066, 0.00426393, 0.0042692902, 0.0042746495, 0.0042800633, 0.004285513, 0.0042909984, 0.0042964658, 0.0043020053, 0.0043075993, 0.0043131746, 0.004318804, 0.0043244516, 0.004330135, 0.0043358542, 0.0043415916, 0.0043473467, 0.0043531382, 0.0043589836, 0.0043648109, 0.004370728, 0.0043766457, 0.0043825987, 0.0043885699, 0.0043945769, 0.0044006021, 0.0044066813, 0.0044127782, 0.0044188751, 0.0044250442, 0.0044312673, 0.0044374545, 0.0044436953, 0.0044499724, 0.0044562672, 0.0044625979, 0.0044689467, 0.00447535, 0.0044817706, 0.0044882274, 0.0044946666, 0.004501177, 0.0045077777, 0.0045143245, 0.0045209252, 0.0045275437, 0.0045342166, 0.0045409072, 0.0045476155, 0.0045543602, 0.0045611225, 0.0045679393, 0.0045747375, 0.0045816442, 0.0045885504, 0.0045954571, 0.0046024173, 0.0046093957, 0.00461641, 0.0046234606, 0.0046305289, 0.0046375971, 0.0046447553, 0.0046519134, 0.0046591256, 0.0046663377, 0.0046735858, 0.0046808701, 0.0046881726, 0.0046955105, 0.0047028842, 0.0047102766, 0.0047177225, 0.0047251503, 0.0047326325, 0.0047402042, 0.0047477223, 0.004755294, 0.0047629019, 0.0047705458, 0.0047782077, 0.0047858874, 0.0047936211, 0.004801373, 0.0048091607, 0.0048169484, 0.004824826, 0.0048327036, 0.0048405994, 0.004848531, 0.0048564808, 0.0048644841, 0.0048725056, 0.0048805452, 0.0048886207, 0.004896732, 0.0049048797, 0.0049130451, 0.0049212463, 0.0049294834, 0.0049377391, 0.004946012, 0.0049543395, 0.0049626851, 0.0049710665, 0.0049794652, 0.0049878648, 0.0049963361, 0.0050048972, 0.0050133863, 0.0050219474, 0.0050305263, 0.0050391415, 0.0050477921, 0.0050564436, 0.0050651482, 0.0050738896, 0.0050826482, 0.0050914069, 0.0051002558, 0.005109123, 0.0051180078, 0.0051268926, 0.005135831, 0.0051448056, 0.0051537985, 0.0051628277, 0.0051718745, 0.0051809568, 0.0051900754, 0.0051992666, 0.0052084206, 0.0052176295, 0.0052268556, 0.0052361181, 0.0052454169, 0.0052547334, 0.0052640862, 0.0052734562, 0.0052828807, 0.0052923053, 0.0053018192, 0.0053113159, 0.005320848, 0.0053303982, 0.0053400025, 0.0053496072, 0.0053592655, 0.0053689415, 0.0053786356, 0.0053883656, 0.0053981501, 0.0054079699, 0.0054177898, 0.0054276465, 0.0054375203, 0.0054474482, 0.0054573943, 0.005467358, 0.0054773577, 0.005486344, 0.0054938891, 0.0055014431, 0.0055090412, 0.0055166939, 0.0055243834, 0.0055320989, 0.005539869, 0.0055476744, 0.0055555338, 0.0055633755, 0.0055712895, 0.0055792932, 0.0055872696, 0.0055953185, 0.0056034205, 0.0056115226, 0.0056196703, 0.0056278897, 0.0056361356, 0.0056443824, 0.005652728, 0.0056610727, 0.00566949, 0.0056779166, 0.0056863879, 0.0056949663, 0.0057034916, 0.0057120621, 0.0057207304, 0.0057294006, 0.0057381405, 0.0057468908, 0.005755668, 0.0057645254, 0.0057733925, 0.0057823225, 0.005791279, 0.005800263, 0.0058093187, 0.0058183922, 0.0058275019, 0.0058366833, 0.0058458382, 0.0058550742, 0.0058643902, 0.005873662, 0.005883032, 0.0058924658, 0.0059018722, 0.0059113321, 0.0059208646, 0.0059304237, 0.0059399833, 0.0059496504, 0.0059593092, 0.0059690387, 0.0059787687, 0.0059885802, 0.0059984452, 0.0060082916, 0.0060181846, 0.0060281665, 0.0060381484, 0.0060481839, 0.0060582734, 0.0060683549, 0.0060785254, 0.0060887053, 0.0060989573, 0.0061092265, 0.0061195409, 0.0061298655, 0.0061402787, 0.0061506927, 0.0061611957, 0.0061716815, 0.0061822119, 0.006192842, 0.0062034526, 0.0062141181, 0.0062248646, 0.006235593, 0.0062463665, 0.0062572113, 0.0062680752, 0.006278974, 0.0062899366, 0.0063009076, 0.0063119773, 0.00632302, 0.0063341269, 0.0063453135, 0.0063564735, 0.0063676783, 0.0063789822, 0.0063902596, 0.0064015999, 0.0064130113, 0.0064244228, 0.0064358977, 0.0064473995, 0.0064589642, 0.0064705559, 0.0064821648, 0.0064938199, 0.0065055373, 0.0065172818, 0.0065290988, 0.0065409061, 0.0065527493, 0.006564674, 0.0065766075, 0.0065885852, 0.0066006356, 0.006612686, 0.0066247634, 0.0066369483, 0.0066491067, 0.0066613369, 0.006673594, 0.006685887, 0.0066982522, 0.0067106173, 0.0067230547, 0.0067355363, 0.006748009, 0.0067605544, 0.0067731529, 0.0067857695, 0.0067984052, 0.0068111382, 0.0068238634, 0.0068366597, 0.0068494654, 0.0068623344, 0.0068752384, 0.006888188, 0.006901138, 0.0069141858, 0.0069272351, 0.0069403374, 0.0069534848, 0.00696665, 0.0069798869, 0.0069931331, 0.0070064338, 0.007019788, 0.0070331511, 0.0070465594, 0.0070600398, 0.0070735109, 0.0070870449, 0.0071006333, 0.0071142484, 0.0071279258, 0.0071415943, 0.0071553448, 0.0071691396, 0.0071829436, 0.0071967924, 0.007210704, 0.007224625, 0.0072385911, 0.0072526378, 0.0072666751, 0.007280767, 0.0072948947, 0.0073090852, 0.0073233387, 0.0073375646, 0.0073518362, 0.0073661981, 0.0073805591, 0.0073949839, 0.0074094264, 0.0074239047, 0.0074384636, 0.007453023, 0.0074676545, 0.0074823122, 0.0074969889, 0.0075117191, 0.0075265118, 0.0075413049, 0.0075561423, 0.0075710346, 0.0075859628, 0.0076009627, 0.0076159444, 0.0076310076, 0.0076461243, 0.0076612411, 0.0076763844, 0.0076916367, 0.0077068703, 0.007722131, 0.0077374997, 0.0077528502, 0.0077682817, 0.0077837049, 0.0077991812, 0.007814765, 0.0078303237, 0.0078459075, 0.0078615909, 0.0078772465, 0.007892984, 0.0079087662, 0.00792454, 0.0079404125, 0.0079562934, 0.00797222, 0.0079881912, 0.0080042072, 0.0080202501, 0.0080363387, 0.0080524432, 0.0080686128, 0.0080848262, 0.0081010582, 0.0081173535, 0.0081336936, 0.0081500513, 0.0081664808, 0.0081829196, 0.0081993761, 0.0082159229, 0.008232479, 0.0082490705, 0.0082657337, 0.0082824063, 0.0082991514, 0.0083158957, 0.008332721, 0.0083495826, 0.0083664348, 0.0083833411, 0.0084003368, 0.0084173158, 0.0084343664, 0.0084514609, 0.0084685739, 0.0084857419, 0.008502936, 0.0085201841, 0.0085374685, 0.008554779, 0.0085721444, 0.0085895453, 0.0086069731, 0.0086244456, 0.0086419908, 0.0086595267, 0.0086771166, 0.0086947782, 0.0087124584, 0.0087302011, 0.0087479521, 0.008765731, 0.0087836087, 0.0088014686, 0.0088193733, 0.0088373488, 0.0088553168, 0.0088734012, 0.0088914409, 0.0089095794, 0.0089277625, 0.0089459363, 0.0089641558, 0.0089824656, 0.0090007745, 0.0090191113, 0.0090375189, 0.0090559451, 0.0090744337, 0.0090929409, 0.0091114845, 0.0091301082, 0.0091487598, 0.0091674104, 0.0091861514, 0.0092048747, 0.0092236698, 0.0092425272, 0.009261366, 0.0092802877, 0.0092992615, 0.0093182363, 0.0093373014, 0.0093563665, 0.0093754577, 0.0093946308, 0.00941383, 0.0094330562, 0.0094523281, 0.0094716353, 0.0094910059, 0.0095103849, 0.0095298188, 0.0095493142, 0.0095688207, 0.0095883431, 0.0096079567, 0.0096275788, 0.0096472371, 0.0096669756, 0.009686715, 0.0097065074, 0.0097263278, 0.0097461846, 0.0097661475, 0.0097860666, 0.0098060574, 0.0098261023, 0.0098461565, 0.009866246, 0.0098864175, 0.0099065965, 0.0099268127, 0.009947109, 0.0099674147, 0.0099877743, 0.010008142, 0.010028566, 0.01004906, 0.010069554, 0.010090095, 0.010110678, 0.010131299, 0.010151999, 0.010172683, 0.010193438, 0.010214257, 0.010235057, 0.010255894, 0.010276837, 0.010297764, 0.010318735, 0.010339797, 0.01036082, 0.010381954, 0.010403096, 0.010424265, 0.010445541, 0.010466782, 0.010488068, 0.010509427, 0.010530801, 0.010552196, 0.010573697, 0.01059519, 0.0106167, 0.01063831, 0.010659938, 0.010681611, 0.010703319, 0.010725063, 0.010746844, 0.010768651, 0.010790512, 0.01081241, 0.010834334, 0.01085634, 0.010878363, 0.010900421, 0.010922544, 0.010944667, 0.010966825, 0.010989082, 0.011011339, 0.011033605, 0.01105597, 0.011078334, 0.01110078, 0.011123218, 0.0111457, 0.011168297, 0.011190852, 0.011213451, 0.01123613, 0.011258801, 0.011281535, 0.011304349, 0.011327155, 0.011349987, 0.011372893, 0.011395832, 0.011418836, 0.011441848, 0.011464889, 0.011487991, 0.011511129, 0.011534285, 0.011557522, 0.011580761, 0.01160405, 0.011627406, 0.011650777, 0.011674222, 0.011697656, 0.011721128, 0.011744688, 0.011768258, 0.011791864, 0.011815533, 0.011839203, 0.011862961, 0.01188672, 0.011910542, 0.011934427, 0.011958285, 0.011982205, 0.012006207, 0.012030218, 0.012054228, 0.012078365, 0.012102484, 0.012126628, 0.012150856, 0.012175109, 0.012199417, 0.01222376, 0.012248111, 0.012272545, 0.01229697, 0.012321457, 0.012345998, 0.012370547, 0.012395161, 0.012419829, 0.012444515, 0.01246927, 0.012494029, 0.012518813, 0.012543686, 0.01256855, 0.012593479, 0.012618469, 0.012643452, 0.012668524, 0.012693595, 0.012718731, 0.012743928, 0.012769134, 0.012794341, 0.012819656, 0.012844979, 0.012870329, 0.012895752, 0.012921192, 0.012946634, 0.012972191, 0.012997747, 0.013023386, 0.013049024, 0.013074699, 0.013100454, 0.013126192, 0.013151973, 0.013177846, 0.013203718, 0.013229636, 0.013255625, 0.013281614, 0.013307683, 0.013333753, 0.01335986, 0.013386046, 0.013412233, 0.013438473, 0.01346476, 0.013491072, 0.013517466, 0.013543851, 0.013570289, 0.0135968, 0.01362332, 0.013649848, 0.013676476, 0.013703113, 0.013729758, 0.013756521, 0.013783247, 0.013810072, 0.013836898, 0.013863767, 0.013890736, 0.013917672, 0.013944658, 0.013971726, 0.013998786, 0.014025889, 0.014053074, 0.014080259, 0.014107481, 0.014134783, 0.014162085, 0.014189477, 0.014217926, 0.014247242, 0.014276666, 0.014306091, 0.014335623, 0.014365174, 0.014394742, 0.014424436, 0.014454183, 0.014483896, 0.014513734, 0.014543609, 0.014573535, 0.014603518, 0.014633518, 0.014663589, 0.014693769, 0.014723931, 0.014754183, 0.014784451, 0.014814811, 0.014845243, 0.014875656, 0.014906142, 0.014936735, 0.01496731, 0.014997958, 0.015028697, 0.015059487, 0.015090276, 0.015121176, 0.015152075, 0.015183082, 0.015214089, 0.015245168, 0.015276302, 0.015307507, 0.01533873, 0.015370041, 0.015401337, 0.015432794, 0.015464251, 0.015495706, 0.01552729, 0.015558871, 0.015590545, 0.015622271, 0.015654033, 0.015685832, 0.015717737, 0.015749663, 0.015781622, 0.015813638, 0.01584574, 0.015877899, 0.015910057, 0.015942289, 0.015974624, 0.016006945, 0.016039301, 0.0160718, 0.016104318, 0.016136836, 0.016169446, 0.016202105, 0.016234856, 0.016267609, 0.016300414, 0.016333312, 0.016366223, 0.016399192, 0.016432229, 0.016465288, 0.016498454, 0.016531654, 0.016564872, 0.016598184, 0.016631529, 0.016664928, 0.016698381, 0.016731888, 0.016765447, 0.016799081, 0.016832696, 0.016866438, 0.016900195, 0.016934045, 0.01696793, 0.017001813, 0.01703579, 0.017069852, 0.017103918, 0.017138001, 0.017172227, 0.017206509, 0.017240752, 0.017275123, 0.017309545, 0.017344005, 0.017378485, 0.017413016, 0.017447658, 0.017482314, 0.01751701, 0.017551793, 0.017586578, 0.017621486, 0.017656432, 0.017691378, 0.017726414, 0.017761521, 0.017796649, 0.017831845, 0.017867062, 0.017902385, 0.017937725, 0.017973104, 0.018008571, 0.018044092, 0.01807965, 0.018115278, 0.018150909, 0.018186627, 0.01822242, 0.01825821, 0.018294074, 0.018330043, 0.018366015, 0.018402005, 0.018438118, 0.018474251, 0.018510457, 0.018546697, 0.018582974, 0.018619377, 0.018655743, 0.018692182, 0.018728692, 0.018765274, 0.018801859, 0.018838549, 0.018875238, 0.018912056, 0.018948855, 0.018985705, 0.019022649, 0.019059643, 0.019096658, 0.019133745, 0.019170867, 0.019208115, 0.019245327, 0.01928263, 0.019319985, 0.019357357, 0.019394804, 0.019432323, 0.019469876, 0.019507466, 0.019545181, 0.019582879, 0.019620648, 0.019658454, 0.019696349, 0.019734299, 0.019772248, 0.019810289, 0.019848417, 0.01988651, 0.019924695, 0.01996295, 0.020001259, 0.020039603, 0.02007802, 0.020116456, 0.020154981, 0.020193523, 0.020232119, 0.020270789, 0.020309547, 0.020348288, 0.020387135, 0.020425968, 0.020464942, 0.020503936, 0.020542929, 0.020582009, 0.020621181, 0.020660335, 0.020699602, 0.020738862, 0.020778248, 0.020817673, 0.020857116, 0.020896595, 0.0209362, 0.020975767, 0.021015443, 0.021055173, 0.021094956, 0.021134779, 0.021174634, 0.021214543, 0.02125456, 0.021294612, 0.021334667, 0.021374829, 0.021415027, 0.02145526, 0.021495549, 0.021535907, 0.021576321, 0.021616772, 0.021657273, 0.02169783, 0.02173846, 0.021779127, 0.021819847, 0.021860583, 0.021901447, 0.021942308, 0.021983227, 0.022024198, 0.022065258, 0.022106353, 0.02214749, 0.022188675, 0.02222988, 0.022271246, 0.022312557, 0.022353942, 0.022395436, 0.022436945, 0.022478528, 0.022520129, 0.022561764, 0.022603525, 0.022645293, 0.02268707, 0.022728959, 0.022770921, 0.022812914, 0.022854928, 0.022897014, 0.022939211, 0.02298137, 0.023023581, 0.023065899, 0.023108255, 0.023150647, 0.023193112, 0.023235612, 0.02327822, 0.023320809, 0.023363451, 0.023406185, 0.023448972, 0.023491779, 0.023534674, 0.023577571, 0.023620572, 0.023663629, 0.023706721, 0.023749819, 0.023793055, 0.023836292, 0.023879601, 0.023922946, 0.023966342, 0.024009833, 0.024053322, 0.024096847, 0.024140462, 0.024184167, 0.024227889, 0.024271665, 0.024315462, 0.024359381, 0.024403285, 0.024447242, 0.024491305, 0.024535386, 0.024579544, 0.024623733, 0.024667976, 0.024712311, 0.024756648, 0.024801016, 0.024845496, 0.024890026, 0.024934575, 0.02497918, 0.025023839, 0.025068585, 0.025113352, 0.025158156, 0.025203027, 0.025248028, 0.025292955, 0.025338026, 0.025383083, 0.02542826, 0.025473459, 0.025518691, 0.025563963, 0.025609341, 0.025654752, 0.025700221, 0.025745742, 0.025791299, 0.025836928, 0.025882574, 0.025928259, 0.025974084, 0.026019895, 0.026065776, 0.026111709, 0.0261577, 0.026203761, 0.02624982, 0.026295934, 0.026342176, 0.026388416, 0.026434693, 0.026481077, 0.026527481, 0.026573937, 0.026620449, 0.026666995, 0.026713595, 0.026760319, 0.02680701, 0.026853776, 0.026900608, 0.026947515, 0.026994439, 0.02704142, 0.02708843, 0.027135571, 0.027182676, 0.027229905, 0.027277134, 0.027324455, 0.027371829, 0.027419219, 0.027466632, 0.027514184, 0.027561756, 0.027609346, 0.027657025, 0.02770476, 0.027752547, 0.02780037, 0.027848212, 0.027896231, 0.027944166, 0.027992204, 0.028040295, 0.028088443, 0.028136609, 0.028184902, 0.028233174, 0.028281534, 0.028329972, 0.02837839, 0.028426914, 0.028475512, 0.028524125, 0.028572775, 0.028621498, 0.028670294, 0.028719125, 0.028767955, 0.028816912, 0.028865939, 0.028914951, 0.02896405, 0.02901317, 0.029062377, 0.029111622, 0.029160939, 0.029210271, 0.029259676, 0.029309157, 0.029358691, 0.029408241, 0.029457863, 0.029507572, 0.029557249, 0.029607017, 0.02965687, 0.029706744, 0.029756652, 0.029806692, 0.029856708, 0.029906798, 0.029956957, 0.030007139, 0.030057373, 0.030107731, 0.030158054, 0.03020847, 0.030258916, 0.030309422, 0.030360013, 0.030410608, 0.030461254, 0.030512046, 0.030562783, 0.030613627, 0.030664492, 0.030715445, 0.030766468, 0.030817477, 0.030868517, 0.03091974, 0.030970911, 0.031022189, 0.031073427, 0.031124849, 0.031176252, 0.031227687, 0.031279199, 0.031330802, 0.031382401, 0.031434055, 0.031485818, 0.031537618, 0.031589381, 0.031641286, 0.03169319, 0.03174524, 0.031797271, 0.03184934, 0.031901501, 0.031953711, 0.03200594, 0.03205828, 0.032110598, 0.03216299, 0.03221551, 0.032268006, 0.032320559, 0.032373153, 0.032425847, 0.032478601, 0.032531388, 0.032584175, 0.032637108, 0.032690018, 0.032743007, 0.032796044, 0.032849155, 0.032902323, 0.032955468, 0.033008721, 0.033062067, 0.033115394, 0.033168793, 0.033222266, 0.033275809, 0.033329334, 0.033383001, 0.033436634, 0.033490412, 0.033544187, 0.033598002, 0.033651907, 0.033705823, 0.033759799, 0.033813845, 0.033867925, 0.03392208, 0.033976309, 0.034030534, 0.034084868, 0.03413922, 0.03419359, 0.034248106, 0.0343026, 0.034357168, 0.034411792, 0.034466449, 0.034521196, 0.034576017, 0.034630802, 0.034685727, 0.034740619, 0.034795601, 0.034850691, 0.034905743, 0.034960888, 0.035016086, 0.035071373, 0.035126645, 0.035182003, 0.035237417, 0.035292938, 0.035348423, 0.035403963, 0.035460081, 0.035517257, 0.035574414, 0.03563166, 0.035688907, 0.035746284, 0.035803657, 0.035861101, 0.035918586, 0.035976157, 0.036033746, 0.036091372, 0.036149085, 0.036206875, 0.036264643, 0.036322523, 0.036380365, 0.036438406, 0.036496405, 0.036554463, 0.036612574, 0.036670741, 0.036728941, 0.036787234, 0.036845576, 0.036903974, 0.036962371, 0.037020843, 0.037079353, 0.037137985, 0.037196651, 0.037255324, 0.037314028, 0.037372872, 0.037431706, 0.037490588, 0.037549566, 0.037608556, 0.037667606, 0.037726685, 0.037785858, 0.037845101, 0.037904385, 0.037963662, 0.038023017, 0.038082477, 0.038141936, 0.038201466, 0.038261034, 0.038320638, 0.038380351, 0.038440082, 0.038499847, 0.03855972, 0.038619597, 0.038679522, 0.038739502, 0.038799558, 0.038859703, 0.03891981, 0.038979989, 0.039040241, 0.039100599, 0.039160941, 0.039221317, 0.039281767, 0.039342325, 0.039402883, 0.039463509, 0.039524175, 0.039584912, 0.039645668, 0.039706495, 0.039767358, 0.03982833, 0.039889298, 0.039950307, 0.040011406, 0.040072571, 0.040133759, 0.040194999, 0.040256258, 0.040317643, 0.040379047, 0.0404405, 0.040501993, 0.040563576, 0.040625162, 0.04068685, 0.040748537, 0.040810321, 0.040872138, 0.04093397, 0.040995874, 0.041057892, 0.041119941, 0.041182026, 0.041244093, 0.041306302, 0.041368518, 0.04143082, 0.041493155, 0.041555587, 0.041617997, 0.041680478, 0.041742995, 0.041805655, 0.041868281, 0.041930977, 0.04199373, 0.042056553, 0.04211941, 0.042182308, 0.042245291, 0.042308275, 0.042371374, 0.042434465, 0.042497668, 0.042560868, 0.042624176, 0.042687483, 0.042750865, 0.042814318, 0.04287779, 0.042941347, 0.043004893, 0.043068524, 0.043132249, 0.043196008, 0.043259803, 0.043323614, 0.043387517, 0.043451473, 0.043515481, 0.043579567, 0.043643702, 0.043707836, 0.043772031, 0.043836292, 0.043900639, 0.04396503, 0.044029403, 0.044093877, 0.044158429, 0.044223018, 0.044287615, 0.044352293, 0.044417076, 0.044481844, 0.044546682, 0.044611555, 0.044676539, 0.044741504, 0.044806521, 0.044871662, 0.044936839, 0.045002002, 0.045067273, 0.045132544, 0.045197919, 0.045263369, 0.045328818, 0.045394339, 0.045459878, 0.045525491, 0.045591176, 0.045656897, 0.045722701, 0.04578856, 0.04585439, 0.045920305, 0.045986298, 0.046052378, 0.046118472, 0.046184584, 0.046250757, 0.046317033, 0.046383325, 0.046449658, 0.046516076, 0.046582531, 0.046649061, 0.046715591, 0.046782207, 0.046848901, 0.046915572, 0.046982352, 0.047049168, 0.047116075, 0.047182977, 0.047249943, 0.047316935, 0.047384076, 0.047451194, 0.047518358, 0.047585603, 0.047652885, 0.047720224, 0.047787599, 0.047855083, 0.047922615, 0.047990117, 0.048057705, 0.048125345, 0.048193101, 0.048260834, 0.048328675, 0.048396479, 0.048464429, 0.048532393, 0.048600398, 0.048668455, 0.048736583, 0.04880479, 0.048873007, 0.048941262, 0.049009643, 0.049077988, 0.049146403, 0.049214911, 0.049283456, 0.049352054, 0.049420685, 0.049489349, 0.049558129, 0.049626939, 0.04969579, 0.049764678, 0.049833592, 0.04990264, 0.049971707, 0.050040804, 0.05010996, 0.050179202, 0.050248466, 0.050317783, 0.050387111, 0.050456576, 0.050526034, 0.050595585, 0.050665155, 0.050734811, 0.05080447, 0.050874196, 0.050943982, 0.051013872, 0.051083747, 0.05115366, 0.051223658, 0.051293727, 0.051363803, 0.051433995, 0.051504195, 0.051574484, 0.051644772, 0.051715128, 0.051785544, 0.051856011, 0.05192655, 0.051997107, 0.052067719, 0.052138399, 0.052209139, 0.05227989, 0.052350741, 0.052421659, 0.052492574, 0.052563541, 0.052634582, 0.052705683, 0.052776832, 0.052848022, 0.052919257, 0.052990589, 0.053061917, 0.053133324, 0.053204764, 0.053276271, 0.053347874, 0.053419456, 0.053491112, 0.053562816, 0.053634614, 0.053706411, 0.053778321, 0.053850226, 0.053922221, 0.053994216, 0.054066285, 0.054138441, 0.054210655, 0.054282866, 0.054355167, 0.05442749, 0.054499894, 0.05457234, 0.054644827, 0.054717418, 0.054790042, 0.054862645, 0.054935362, 0.055008113, 0.055080939, 0.055153813, 0.055226713, 0.055299677, 0.055372737, 0.055445753, 0.055518903, 0.055592045, 0.055665325, 0.055738594, 0.055811904, 0.055885285, 0.055958737, 0.056032207, 0.05610577, 0.056179348, 0.056253016, 0.056326721, 0.056400444, 0.056474224, 0.056548122, 0.056622028, 0.056695964, 0.056769975, 0.056844056, 0.056918155, 0.056992311, 0.057066504, 0.057140816, 0.057215132, 0.057289485, 0.057363909, 0.057438444, 0.057512943, 0.057587538, 0.057662148, 0.057736859, 0.057811607, 0.057886355, 0.057961188, 0.058036122, 0.058111064, 0.058186084, 0.0582611, 0.05833621, 0.058411367, 0.058486566, 0.058561854, 0.058637142, 0.058712535, 0.058787968, 0.058863394, 0.058938898, 0.059014492, 0.059090145, 0.059165802, 0.05924153, 0.059317317, 0.059393141, 0.059469003, 0.059544962, 0.059620962, 0.059697006, 0.059773088, 0.059849218, 0.059925422, 0.060001686, 0.06007801, 0.060154326, 0.06023078, 0.060307201, 0.060383715, 0.060460255, 0.06053691, 0.060613584, 0.060690295, 0.060767017, 0.060843885, 0.060920764, 0.060997669, 0.061074641, 0.061151713, 0.061228782, 0.061305899, 0.061383098, 0.061460324, 0.061537664, 0.061614979, 0.061692394, 0.061769836, 0.061847299, 0.061924871, 0.062002461, 0.062080126, 0.06215784, 0.062235612, 0.062313411, 0.062391251, 0.062469184, 0.062547185, 0.062625207, 0.062703244, 0.062781394, 0.062859565, 0.062937781, 0.06301605, 0.06309443, 0.063172795, 0.063251249, 0.063329704, 0.0634083, 0.063486859, 0.06356553, 0.063644215, 0.06372299, 0.063801788, 0.063880637, 0.063959517, 0.064038508, 0.064117543, 0.064196572, 0.064275667, 0.064354874, 0.064434066, 0.064513326, 0.064592659, 0.064672075, 0.064751491, 0.064830936, 0.064910486, 0.064990088, 0.06506969, 0.065149404, 0.065229155, 0.065308951, 0.065388769, 0.065468684, 0.065548606, 0.065628678, 0.065708682, 0.065788805, 0.065868936, 0.065949149, 0.0660294, 0.066109724, 0.066190116, 0.066270508, 0.066350974, 0.066431522, 0.066512093, 0.066592708, 0.066673383, 0.06675414, 0.066834897, 0.066915758, 0.066996619, 0.067077555, 0.067158528, 0.067239627, 0.067320704, 0.067401879, 0.067483038, 0.067564316, 0.067645617, 0.067726985, 0.067808382, 0.067889839, 0.067971349, 0.06805291, 0.068134494, 0.068216182, 0.06829793, 0.068379708, 0.068461508, 0.068543397, 0.068625316, 0.068707295, 0.068789341, 0.068871453, 0.068953559, 0.069035746, 0.069117978, 0.069200315, 0.069282599, 0.069365062, 0.069447473, 0.069529988, 0.06961254, 0.069695152, 0.069777794, 0.069860488, 0.069943279, 0.070026122, 0.070108965, 0.070191897, 0.07027486, 0.070357896, 0.070440955, 0.070524409, 0.070607178, 0.070689969, 0.070772819, 0.070855707, 0.070938662, 0.071021676, 0.071104713, 0.071187772, 0.071270898, 0.071354069, 0.071437307, 0.071520619, 0.071603924, 0.071687303, 0.071770705, 0.071854167, 0.071937695, 0.072021239, 0.072104856, 0.072188526, 0.072272226, 0.072355971, 0.07243976, 0.072523609, 0.072607532, 0.072691433, 0.072775424, 0.072859474, 0.072943538, 0.07302767, 0.073111847, 0.073196091, 0.073280349, 0.073364653, 0.073449053, 0.073533483, 0.073617905, 0.073702432, 0.073786981, 0.07387159, 0.073956229, 0.074040942, 0.074125685, 0.074210458, 0.074295312, 0.074380219, 0.074465163, 0.074550115, 0.074635148, 0.074720219, 0.074805371, 0.074890554, 0.074975751, 0.075061023, 0.075146347, 0.075231686, 0.0753171, 0.075402603, 0.075488091, 0.075573631, 0.075659238, 0.075744867, 0.075830571, 0.075916328, 0.076002128, 0.076087944, 0.076173805, 0.076259755, 0.076345727, 0.076431736, 0.07651785, 0.076603971, 0.076690115, 0.076776333, 0.076862596, 0.076948911, 0.077035308, 0.07712169, 0.077208139, 0.07729464, 0.077381194, 0.077467769, 0.077554427, 0.077641115, 0.077727862, 0.077814624, 0.07790146, 0.077988349, 0.078075267, 0.078162268, 0.078249261, 0.078336328, 0.07842347, 0.078510627, 0.078597844, 0.078685105, 0.078772403, 0.078859761, 0.078947157, 0.079034612, 0.079122096, 0.079209656, 0.079297259, 0.079384886, 0.079472579, 0.079560272, 0.079648063, 0.07973589, 0.07982377, 0.079911709, 0.0799997, 0.080087721, 0.08017578, 0.080263868, 0.080352016, 0.080440268, 0.080528505, 0.080616802, 0.080705144, 0.08079353, 0.080881983, 0.080970466, 0.081059046, 0.081147604, 0.081236236, 0.081324905, 0.081413642, 0.08150243, 0.081591263, 0.081680119, 0.081769072, 0.081858031, 0.081947014, 0.082036078, 0.082125187, 0.08221437, 0.082303554, 0.082392797, 0.082482092, 0.082571447, 0.082660839, 0.082750283, 0.082839772, 0.082929306, 0.083018877, 0.083108537, 0.08319819, 0.083287932, 0.083377682, 0.083467498, 0.08355739, 0.083647281, 0.083737254, 0.083827272, 0.083917327, 0.084007427, 0.084097572, 0.084187768, 0.084278032, 0.084368318, 0.084458664, 0.08454904, 0.08463949, 0.084729962, 0.084820516, 0.084911078, 0.085001722, 0.085092381, 0.085183084, 0.085273892, 0.085364684, 0.085455552, 0.085546486, 0.085637398, 0.085728429, 0.085819468, 0.085910559, 0.086001717, 0.086092904, 0.086184159, 0.086275451, 0.08636678, 0.086458169, 0.08654961, 0.086641066, 0.086732626, 0.086824171, 0.086915813, 0.08700747, 0.087099187, 0.087190948, 0.087282762, 0.087374613, 0.087466523, 0.087558478, 0.087650485, 0.08774253, 0.087834619, 0.087926775, 0.088018961, 0.088111207, 0.088203482, 0.088295817, 0.088388197, 0.088480629, 0.088573106, 0.088665612, 0.088758186, 0.088850796, 0.088943481, 0.089036174, 0.089128926, 0.089221746, 0.08931461, 0.089407489, 0.089500464, 0.089593455, 0.089686491, 0.089779586, 0.089872733, 0.089965925, 0.090059169, 0.090152428, 0.090245754, 0.090339139, 0.090432562, 0.090526044, 0.090619549, 0.090713114, 0.09080673, 0.090900376, 0.090994097, 0.091087855, 0.091181636, 0.091275498, 0.091369405, 0.091463357, 0.091557331, 0.091651365, 0.091745444, 0.091839582, 0.091933779, 0.092028014, 0.092122301, 0.092216626, 0.092310995, 0.092405409, 0.092499875, 0.092594393, 0.09268894, 0.092783548, 0.092878222, 0.092972904, 0.093067639, 0.093162462, 0.093257323, 0.093352214, 0.093447164, 0.093542136, 0.093637168, 0.093732245, 0.093827389, 0.093922555, 0.094017774, 0.094113074, 0.094208367, 0.094303735, 0.094399154, 0.094494611, 0.09459012, 0.094685689, 0.09478128, 0.094876923, 0.094972648, 0.095068388, 0.095164172, 0.095260024, 0.09535592, 0.095451862, 0.095547818, 0.095643871, 0.095739923, 0.095836066, 0.095932245, 0.09602847, 0.096124724, 0.09622106, 0.096317418, 0.096413784, 0.096510261, 0.096606761, 0.096703321, 0.096799947, 0.096896581, 0.096993268, 0.097090028, 0.097186811, 0.097283661, 0.097380526, 0.097477458, 0.09757445, 0.097671501, 0.09776853, 0.097865678, 0.097962812, 0.098060049, 0.098157324, 0.098254606, 0.098351978, 0.098449409, 0.098546848, 0.098644353, 0.098741911, 0.098839514, 0.098937154, 0.099034809, 0.099132583, 0.099230364, 0.099328183, 0.099426091, 0.099524014, 0.099621959, 0.099720009, 0.099818036, 0.099916175, 0.10001433, 0.10011255, 0.10021079, 0.10030913, 0.10040749, 0.1005059, 0.10060434, 0.10070284, 0.10080139, 0.10089996, 0.10099863, 0.10109731, 0.10119601, 0.10129479, 0.10139364, 0.1014925, 0.10159142, 0.1016904, 0.10178943, 0.10188849, 0.10198759, 0.10208676, 0.10218596, 0.10228525, 0.10238454, 0.1024839, 0.10258327, 0.10268273, 0.10278222, 0.10288174, 0.10298134, 0.10308097, 0.10318065, 0.10328041, 0.10338016, 0.10347999, 0.10357987, 0.10367977, 0.10377973, 0.10387977, 0.10397983, 0.10407995, 0.10418008, 0.10428032, 0.10438056, 0.10448086, 0.1045812, 0.1046816, 0.10478202, 0.10488254, 0.10498304, 0.10508364, 0.10518426, 0.10528494, 0.10538566, 0.10548644, 0.10558726, 0.10568812, 0.10578906, 0.10589, 0.10599101, 0.10609207, 0.10619316, 0.10629434, 0.10639551, 0.10649677, 0.10659809, 0.1066994, 0.10680078, 0.10690223, 0.10700371, 0.10710524, 0.10720681, 0.10730846, 0.10741013, 0.10751184, 0.10761362, 0.10771544, 0.10781731, 0.10791922, 0.10802119, 0.10812318, 0.10822525, 0.10832734, 0.10842945, 0.10853168, 0.10863392, 0.10873621, 0.10883853, 0.10894091, 0.10904336, 0.10914584, 0.10924836, 0.10935093, 0.10945355, 0.10955625, 0.10965896, 0.10976171, 0.10986453, 0.1099674, 0.11007028, 0.11017324, 0.11027624, 0.11037929, 0.11048239, 0.11058555, 0.11068872, 0.11079197, 0.11089526, 0.11099859, 0.11110196, 0.11120538, 0.11130886, 0.1114124, 0.11151596, 0.1116196, 0.11172326, 0.11182695, 0.11193073, 0.11203451, 0.11213837, 0.11224227, 0.11234622, 0.11245023, 0.11255427, 0.11265837, 0.1127625, 0.11286668, 0.11297093, 0.11307521, 0.11317954, 0.11328391, 0.11338834, 0.11349279, 0.11359734, 0.11370191, 0.11380652, 0.11391119, 0.11401588, 0.11412061, 0.11422543, 0.11433028, 0.11443517, 0.11454012, 0.11464512, 0.11475015, 0.11485521, 0.11496038, 0.11506557, 0.11517081, 0.11527608, 0.11538143, 0.11548678, 0.11559218, 0.11569765, 0.11580317, 0.11590873, 0.11601434, 0.11611998, 0.1162257, 0.11633144, 0.11643725, 0.1165431, 0.11664896, 0.11675493, 0.11686092, 0.11696694, 0.11707304, 0.11717917, 0.11728534, 0.11739159, 0.11749786, 0.11760419, 0.11771055, 0.11781673, 0.11792324, 0.11802977, 0.11813638, 0.11824301, 0.11834968, 0.11845643, 0.11856318, 0.11866997, 0.11877685, 0.11888376, 0.11899073, 0.11909772, 0.11920472, 0.11931181, 0.11941896, 0.11952612, 0.11963335, 0.11974057, 0.11984789, 0.11995523, 0.1200626, 0.12017007, 0.12027755, 0.12038503, 0.12049262, 0.12060022, 0.12070787, 0.12081557, 0.12092332, 0.12103113, 0.12113895, 0.12124684, 0.12135476, 0.1214627, 0.12157072, 0.12167876, 0.12178684, 0.12189503, 0.12200319, 0.12211139, 0.12221966, 0.122328, 0.12243637, 0.12254478, 0.12265322, 0.1227617, 0.12287024, 0.12297885, 0.12308748, 0.12319613, 0.12330487, 0.12341363, 0.12352242, 0.12363127, 0.12374016, 0.12384911, 0.12395807, 0.12406711, 0.12417617, 0.12428528, 0.12439446, 0.12450364, 0.12461288, 0.12472218, 0.12483153, 0.12494088, 0.12505032, 0.1251598, 0.12526932, 0.12537886, 0.12548847, 0.12559812, 0.12570779, 0.12581755, 0.12592731, 0.12603712, 0.12614697, 0.12625691, 0.12636684, 0.12647685, 0.1265869, 0.12669697, 0.12680708, 0.12691729, 0.12702751, 0.12713778, 0.12724809, 0.12735845, 0.12746884, 0.12757927, 0.12768978, 0.12780029, 0.12791085, 0.12802149, 0.12813216, 0.12824285, 0.12835361, 0.12846439, 0.12857524, 0.12868613, 0.12879702, 0.12890799, 0.12901902, 0.12913011, 0.1292412, 0.12935236, 0.12946354, 0.12957476, 0.12968603, 0.1297974, 0.12990877, 0.13002017, 0.13013163, 0.13024312, 0.13035467, 0.13046627, 0.13057791, 0.13068956, 0.13080128, 0.13091306, 0.13102485, 0.13113675, 0.13124864, 0.13136058, 0.13147257, 0.1315846, 0.13169669, 0.1318088, 0.13192096, 0.13203318, 0.13214543, 0.13225771, 0.13237007, 0.13248244, 0.13259487, 0.13270737, 0.13281989, 0.13293244, 0.13304506, 0.13315772, 0.1332704, 0.13338314, 0.13349597, 0.13360874, 0.13372163, 0.13383456, 0.13394752, 0.1340605, 0.13417357, 0.13428667, 0.13439979, 0.13451298, 0.13462622, 0.13473949, 0.13485277, 0.13496614, 0.13507956, 0.13519302, 0.13530651, 0.13542004, 0.1355336, 0.13564727, 0.13576093, 0.13587464, 0.13598838, 0.13610221, 0.13621603, 0.13632993, 0.13644385, 0.13655785, 0.13667186, 0.13678592, 0.13690005, 0.1370142, 0.13712838, 0.13724265, 0.13735692, 0.13747126, 0.13758565, 0.13770007, 0.13781451, 0.13792905, 0.1380436, 0.13815819, 0.13827287, 0.13838752, 0.13850224, 0.13861705, 0.13873185, 0.1388467, 0.13896161, 0.13907656, 0.13919155, 0.1393066, 0.1394217, 0.13953683, 0.139652, 0.13976721, 0.13988248, 0.13999778, 0.14011316, 0.14022852, 0.14034395, 0.14045943, 0.14057498, 0.14069055, 0.14080615, 0.14092182, 0.14103752, 0.14115326, 0.14126906, 0.14138488, 0.1415008, 0.1416167, 0.14173268, 0.14184871, 0.14196475, 0.14208087, 0.142197, 0.14231318, 0.14242944, 0.1425457, 0.142662, 0.14277838, 0.14289479, 0.14301124, 0.14312775, 0.1432443, 0.14336088, 0.14347751, 0.14359419, 0.14371094, 0.14382769, 0.1439445, 0.14406136, 0.14417826, 0.14429522, 0.14441219, 0.14452919, 0.14464626, 0.14476341, 0.14488058, 0.14499776, 0.14511502, 0.1452323, 0.14534965, 0.14546706, 0.14558448, 0.14570194, 0.14581947, 0.14593704, 0.14605464, 0.14617229, 0.14628997, 0.14640772, 0.14652549, 0.14664334, 0.14676121, 0.14687911, 0.14699708, 0.14711507, 0.14723313, 0.14735122, 0.14746936, 0.14758751, 0.14770573, 0.14782402, 0.14794235, 0.14806071, 0.14817911, 0.14829755, 0.14841603, 0.1485346, 0.14865316, 0.14877179, 0.14889044, 0.14900914, 0.1491279, 0.14924671, 0.14936554, 0.14948443, 0.14960335, 0.14972235, 0.14984138, 0.14996043, 0.15007955, 0.15019871, 0.15031791, 0.15043716, 0.15055645, 0.15067576, 0.15079512, 0.15091456, 0.151034, 0.15115353, 0.15127307, 0.15139267, 0.1515123, 0.151632, 0.15175173, 0.1518715, 0.15199132, 0.15211117, 0.15223108, 0.15235104, 0.15247104, 0.15259106, 0.15271114, 0.15283129, 0.15295145, 0.15307166, 0.15319191, 0.15331224, 0.15343256, 0.15355295, 0.15367341, 0.15379389, 0.15391439, 0.15403499, 0.15415558, 0.15427624, 0.15439695, 0.15451768, 0.15463847, 0.15475935, 0.15488021, 0.15500112, 0.15512207, 0.15524311, 0.15536417, 0.15548526, 0.1556064, 0.15572757, 0.1558488, 0.1559701, 0.15609142, 0.15621279, 0.15633419, 0.15645562, 0.15657713, 0.15669867, 0.15682028, 0.15694192, 0.15706356, 0.15718532, 0.15730706, 0.15742886, 0.15755074, 0.1576726, 0.15779454, 0.15791655, 0.15803857, 0.15816064, 0.15828276, 0.1584049, 0.15852712, 0.15864936, 0.15877168, 0.15889399, 0.15901639, 0.15913883, 0.15926129, 0.1593838, 0.15950637, 0.15962896, 0.15975162, 0.15987429, 0.15999705, 0.16011983, 0.16024262, 0.16036552, 0.16048843, 0.16061136, 0.1607344, 0.16085742, 0.16098051, 0.16110365, 0.16122685, 0.16135007, 0.16147332, 0.16159664, 0.16171999, 0.16184339, 0.16196685, 0.16209033, 0.16221385, 0.16233745, 0.16246106, 0.16258471, 0.16270842, 0.16283219, 0.16295598, 0.1630798, 0.16320372, 0.16332763, 0.16345161, 0.16357565, 0.1636997, 0.1638238, 0.16394797, 0.16407214, 0.16419639, 0.16432065, 0.16444501, 0.16456938, 0.16469379, 0.16481824, 0.16494274, 0.1650673, 0.16519189, 0.16531655, 0.1654412, 0.16556597, 0.16569073, 0.16581553, 0.16594039, 0.16606531, 0.16619022, 0.16631523, 0.16644029, 0.16656536, 0.16669045, 0.16681565, 0.16694085, 0.1670661, 0.16719143, 0.16731675, 0.16744214, 0.16756757, 0.16769305, 0.16781859, 0.16794418, 0.16806975, 0.16819541, 0.16832113, 0.16844688, 0.16857265, 0.16869846, 0.16882437, 0.16895029, 0.16907625, 0.16920225, 0.1693283, 0.16945441, 0.16958053, 0.16970675, 0.16983296, 0.16995922, 0.17008556, 0.17021191, 0.17033832, 0.17046477, 0.17059131, 0.17071782, 0.17084441, 0.17097102, 0.17109771, 0.17122442, 0.17135116, 0.17147799, 0.17160483, 0.17173174, 0.17185868, 0.17198563, 0.17211266, 0.17223975, 0.17236684, 0.17249401, 0.17262122, 0.17274846, 0.17287575, 0.17300311, 0.1731305, 0.1732579, 0.17338538, 0.17351289, 0.17364043, 0.17376806, 0.17389572, 0.17402336, 0.17415109, 0.1742789, 0.17440671, 0.17453459, 0.17466247, 0.17479043, 0.17491844, 0.17504649, 0.17517459, 0.17530271, 0.17543088, 0.1755591, 0.17568737, 0.17581567, 0.17594405, 0.17607243, 0.17620085, 0.17632937, 0.1764579, 0.17658959, 0.176725, 0.17686041, 0.17699586, 0.17713131, 0.17726682, 0.17740229, 0.17753777, 0.17767334, 0.17780887, 0.17794439, 0.17807995, 0.17821552, 0.17835107, 0.1784867, 0.17862232, 0.17875795, 0.17889355, 0.17902921, 0.17916487, 0.17930058, 0.17943625, 0.17957196, 0.17970768, 0.17984341, 0.17997918, 0.18011494, 0.18025069, 0.18038648, 0.18052228, 0.18065809, 0.18079391, 0.18092975, 0.1810656, 0.18120149, 0.18133737, 0.18147326, 0.18160917, 0.18174508, 0.18188101, 0.18201698, 0.18215293, 0.1822889, 0.18242487, 0.18256091, 0.18269689, 0.18283293, 0.18296899, 0.18310504, 0.18324111, 0.18337722, 0.1835133, 0.18364941, 0.18378553, 0.18392168, 0.18405783, 0.18419398, 0.18433018, 0.18446636, 0.18460254, 0.1847388, 0.18487503, 0.18501128, 0.18514755, 0.18528381, 0.18542007, 0.18555641, 0.18569271, 0.18582904, 0.18596539, 0.18610172, 0.18623811, 0.18637449, 0.18651088, 0.1866473, 0.18678373, 0.18692015, 0.1870566, 0.18719305, 0.18732953, 0.18746604, 0.18760253, 0.18773903, 0.18787558, 0.18801214, 0.18814868, 0.18828526, 0.18842185, 0.18855843, 0.18869506, 0.18883167, 0.1889683, 0.18910496, 0.18924163, 0.18937831, 0.18951499, 0.18965171, 0.18978845, 0.18992515, 0.1900619, 0.19019866, 0.19033545, 0.19047223, 0.19060904, 0.19074583, 0.19088264, 0.19101952, 0.19115636, 0.19129324, 0.19143012, 0.19156702, 0.19170392, 0.19184084, 0.1919778, 0.19211474, 0.19225171, 0.19238867, 0.19252567, 0.19266267, 0.1927997, 0.19293672, 0.19307375, 0.19321083, 0.1933479, 0.19348498, 0.19362208, 0.1937592, 0.19389631, 0.19403349, 0.19417064, 0.19430779, 0.19444494, 0.19458216, 0.19471936, 0.19485658, 0.19499384, 0.19513106, 0.19526832, 0.19540562, 0.19554289, 0.19568019, 0.19581752, 0.19595484, 0.19609217, 0.19622952, 0.19636689, 0.19650428, 0.19664168, 0.1967791, 0.19691651, 0.19705395, 0.19719142, 0.19732888, 0.19746633, 0.19760384, 0.19774133, 0.19787885, 0.19801638, 0.19815394, 0.19829148, 0.19842906, 0.19856665, 0.19870426, 0.19884187, 0.1989795, 0.19911714, 0.1992548, 0.19939245, 0.19953014, 0.19966783, 0.19980553, 0.19994326, 0.20008099, 0.20021872, 0.2003565, 0.20049427, 0.20063207, 0.20076987, 0.20090769, 0.20104551, 0.20118333, 0.20132123, 0.20145909, 0.20159698, 0.20173487, 0.2018728, 0.20201068, 0.20214865, 0.20228659, 0.20242453, 0.20256253, 0.20270054, 0.20283853, 0.20297654, 0.20311458, 0.20325263, 0.20339067, 0.20352876, 0.20366685, 0.20380494, 0.20394306, 0.20408118, 0.2042193, 0.20435748, 0.20449564, 0.20463383, 0.20477201, 0.20491025, 0.20504844, 0.20518668, 0.20532493, 0.2054632, 0.20560145, 0.20573977, 0.20587806, 0.20601638, 0.2061547, 0.20629306, 0.20643142, 0.20656976, 0.20670815, 0.20684658, 0.20698497, 0.2071234, 0.20726185, 0.20740028, 0.20753877, 0.20767723, 0.20781572, 0.20795424, 0.20809275, 0.20823129, 0.20836979, 0.20850839, 0.20864697, 0.20878555, 0.20892414, 0.20906276, 0.20920138, 0.20934004, 0.20947869, 0.20961736, 0.20975602, 0.20989472, 0.21003343, 0.21017216, 0.21031089, 0.21044964, 0.21058841, 0.21072719, 0.21086596, 0.21100478, 0.2111436, 0.21128243, 0.21142127, 0.21156012, 0.21169899, 0.21183789, 0.21197675, 0.21211569, 0.21225463, 0.21239355, 0.21253251, 0.21267147, 0.21281046, 0.21294944, 0.21308844, 0.21322745, 0.21336649, 0.21350555, 0.21364459, 0.21378368, 0.21392277, 0.21406187, 0.21420097, 0.21434011, 0.21447927, 0.2146184, 0.21475759, 0.21489675, 0.21503595, 0.21517515, 0.2153144, 0.21545361, 0.21559288, 0.21573213, 0.21587141, 0.21601069, 0.21615002, 0.21628933, 0.21642865, 0.21656801, 0.21670736, 0.21684672, 0.21698612, 0.21712551, 0.21726492, 0.21740434, 0.2175438, 0.21768326, 0.2178227, 0.21796219, 0.2181017, 0.21824118, 0.21838072, 0.21852024, 0.2186598, 0.21879935, 0.21893893, 0.21907851, 0.21921809, 0.21935774, 0.21949737, 0.21963701, 0.21977666, 0.21991633, 0.220056, 0.22019571, 0.22033541, 0.22047514, 0.22061487, 0.22075462, 0.2208944, 0.22103415, 0.22117396, 0.22131376, 0.22145356, 0.22159342, 0.22173324, 0.2218731, 0.22201297, 0.22215286, 0.22229277, 0.22243266, 0.22257262, 0.22271253, 0.2228525, 0.22299246, 0.22313245, 0.22327244, 0.22341245, 0.22355248, 0.22369249, 0.22383255, 0.22397262, 0.22411269, 0.22425276, 0.22439289, 0.22453299, 0.22467309, 0.22481327, 0.22495341, 0.22509359, 0.22523378, 0.22537397, 0.22551416, 0.22565441, 0.22579466, 0.22593489, 0.22607514, 0.22621544, 0.22635572, 0.22649603, 0.22663637, 0.22677669, 0.22691701, 0.22705738, 0.22719775, 0.22733814, 0.22747855, 0.22761895, 0.22775938, 0.22789983, 0.22804028, 0.22818074, 0.22832124, 0.22846171, 0.22860223, 0.22874275, 0.22888327, 0.22902383, 0.22916438, 0.22930495, 0.22944558, 0.22958617, 0.22972676, 0.2298674, 0.23000804, 0.2301487, 0.23028938, 0.23043005, 0.23057075, 0.23071148, 0.23085219, 0.23099294, 0.23113367, 0.23127443, 0.23141523, 0.23155601, 0.23169681, 0.23183763, 0.23197846, 0.23211931, 0.23226015, 0.23240104, 0.23254193, 0.23268284, 0.23282374, 0.23296466, 0.23310558, 0.23324658, 0.23338754, 0.23352852, 0.23366952, 0.23381053, 0.23395152, 0.23409259, 0.23423363, 0.23437469, 0.23451577, 0.23465684, 0.23479797, 0.23493907, 0.2350802, 0.23522134, 0.2353625, 0.23550367, 0.23564486, 0.23578605, 0.23592725, 0.23606847, 0.23620972, 0.23635098, 0.23649223, 0.23663352, 0.23677482, 0.23691611, 0.23705745, 0.23719877, 0.23734014, 0.23748147, 0.23762284, 0.23776425, 0.23790562, 0.23804706, 0.23818848, 0.23832992, 0.23847137, 0.23861283, 0.23875432, 0.23889583, 0.23903733, 0.23917888, 0.23932038, 0.23946193, 0.2396035, 0.23974507, 0.23988666, 0.24002828, 0.2401699, 0.24031152, 0.24045315, 0.24059482, 0.2407365, 0.24087818, 0.24101987, 0.24116157, 0.24130331, 0.24144505, 0.2415868, 0.24172856, 0.24187036, 0.24201216, 0.24215394, 0.24229577, 0.24243762, 0.24257945, 0.2427213, 0.24286319, 0.24300507, 0.24314699, 0.24328889, 0.24343081, 0.24357276, 0.24371471, 0.24385667, 0.24399868, 0.24414064, 0.24428266, 0.24442469, 0.24456672, 0.24470878, 0.24485084, 0.24499291, 0.24513502, 0.24527711, 0.24541923, 0.24556138, 0.2457035, 0.24584566, 0.24599051, 0.24613786, 0.24628514, 0.2464323, 0.24657947, 0.24672653, 0.24687353, 0.24702048, 0.24716735, 0.24731416, 0.24746089, 0.24760757, 0.24775417, 0.24790072, 0.2480472, 0.24819361, 0.24833997, 0.24848625, 0.24863246, 0.24877863, 0.24892472, 0.24907073, 0.24921668, 0.24936257, 0.24950841, 0.24965417, 0.24979985, 0.24994548, 0.25009105, 0.25023657, 0.25038201, 0.25052735, 0.25067267, 0.25081789, 0.25096306, 0.25110814, 0.25125319, 0.25139818, 0.2515431, 0.25168794, 0.25183272, 0.25197741, 0.25212207, 0.25226668, 0.25241116, 0.25255564, 0.25270003, 0.25284433, 0.25298861, 0.25313279, 0.25327691, 0.25342098, 0.25356495, 0.2537089, 0.25385275, 0.25399655, 0.25414032, 0.25428396, 0.25442758, 0.25457111, 0.25471458, 0.25485796, 0.25500131, 0.2551446, 0.2552878, 0.25543094, 0.25557402, 0.25571704, 0.25585997, 0.25600287, 0.25614569, 0.25628844, 0.25643113, 0.25657374, 0.25671631, 0.2568588, 0.25700122, 0.25714359, 0.25728586, 0.25742811, 0.25757027, 0.25771236, 0.25785437, 0.25799635, 0.25813827, 0.25828007, 0.25842187, 0.25856358, 0.2587052, 0.25884679, 0.25898829, 0.25912973, 0.25927112, 0.25941244, 0.2595537, 0.25969487, 0.25983596, 0.25997704, 0.26011801, 0.26025894, 0.26039979, 0.26054057, 0.26068133, 0.26082197, 0.26096255, 0.26110309, 0.26124355, 0.26138395, 0.26152429, 0.26166454, 0.26180476, 0.26194489, 0.26208496, 0.26222497, 0.26236489, 0.26250476, 0.26264459, 0.26278433, 0.26292399, 0.26306364, 0.26320314, 0.26334265, 0.26348203, 0.26362142, 0.26376069, 0.26389992, 0.2640391, 0.26417816, 0.26431718, 0.26445612, 0.26459503, 0.26473385, 0.26487261, 0.26501134, 0.26514995, 0.2652885, 0.26542702, 0.26556545, 0.26570383, 0.26584211, 0.26598039, 0.26611853, 0.26625663, 0.2663947, 0.26653266, 0.26667058, 0.26680842, 0.2669462, 0.26708394, 0.26722157, 0.26735914, 0.26749668, 0.26763412, 0.26777151, 0.26790884, 0.26804608, 0.26818329, 0.26832044, 0.26845747, 0.26859447, 0.26873142, 0.26886827, 0.26900509, 0.26914182, 0.26927847, 0.26941511, 0.2695516, 0.2696881, 0.26982448, 0.26996088, 0.27009714, 0.27023336, 0.2703695, 0.27050558, 0.27064157, 0.27077755, 0.27091342, 0.27104923, 0.27118498, 0.2713207, 0.2714563, 0.27159187, 0.27172735, 0.27186278, 0.27199814, 0.27213344, 0.27226865, 0.27240381, 0.27253893, 0.27267393, 0.27280894, 0.27294382, 0.27307868, 0.27321345, 0.27334812, 0.2734828, 0.27361736, 0.27375188, 0.27388632, 0.2740207, 0.27415502, 0.27428928, 0.27442345, 0.27455756, 0.27469161, 0.2748256, 0.27495953, 0.27509338, 0.27522719, 0.27536094, 0.27549458, 0.27562818, 0.27576172, 0.27589515, 0.27602857, 0.27616191, 0.27629516, 0.27642837, 0.27656153, 0.27669457, 0.27682757, 0.27696052, 0.27709341, 0.27722621, 0.27735895, 0.27749163, 0.27762425, 0.27775678, 0.27788928, 0.27802172, 0.27815405, 0.27828634, 0.27841857, 0.27855071, 0.2786828, 0.27881485, 0.27894682, 0.27907869, 0.27921051, 0.27934226, 0.27947396, 0.27960563, 0.2797372, 0.27986869, 0.28000012, 0.28013152, 0.2802628, 0.28039405, 0.28052521, 0.28065631, 0.28078735, 0.28091836, 0.28104928, 0.28118011, 0.28131089, 0.2814416, 0.28157225, 0.28170288, 0.28183338, 0.28196383, 0.28209421, 0.28222454, 0.2823548, 0.28248501, 0.28261515, 0.28274521, 0.28287521, 0.28300512, 0.283135, 0.28326479, 0.28339455, 0.28352422, 0.28365383, 0.28378338, 0.28391284, 0.28404224, 0.28417161, 0.28430086, 0.28443009, 0.28455925, 0.28468832, 0.28481734, 0.28494629, 0.28507516, 0.28520399, 0.28533274, 0.28546143, 0.28559005, 0.28571862, 0.2858471, 0.28597555, 0.2861039, 0.2862322, 0.28636041, 0.28648859, 0.28661668, 0.28674474, 0.28687268, 0.28700063, 0.28712845, 0.28725621, 0.28738394, 0.28751156, 0.28763917, 0.28776667, 0.28789413, 0.28802148, 0.28814882, 0.28827608, 0.28840327, 0.28853038, 0.28865743, 0.28878441, 0.28891134, 0.28903818, 0.28916502, 0.28929171, 0.28941837, 0.289545, 0.28967151, 0.28979799, 0.28992438, 0.29005072, 0.29017696, 0.2903032, 0.29042935, 0.29055542, 0.29068142, 0.29080737, 0.29093325, 0.29105905, 0.29118478, 0.29131049, 0.29143611, 0.29156163, 0.29168713, 0.29181254, 0.29193789, 0.29206318, 0.29218844, 0.29231358, 0.29243869, 0.29256368, 0.29268867, 0.29281357, 0.29293838, 0.29306316, 0.29318786, 0.29331249, 0.29343706, 0.29356155, 0.29368603, 0.29381037, 0.2939347, 0.29405892, 0.29418311, 0.29430723, 0.29443127, 0.29455525, 0.29467916, 0.29480299, 0.29492679, 0.2950505, 0.29517418, 0.29529777, 0.29542127, 0.29554474, 0.29566813, 0.29579148, 0.29591474, 0.29603791, 0.29616106, 0.29628411, 0.2964071, 0.29653007, 0.29665291, 0.29677573, 0.29689848, 0.29702115, 0.29714376, 0.29726627, 0.29738876, 0.29751116, 0.29763353, 0.29775578, 0.29787803, 0.29800019, 0.29812226, 0.29824427, 0.29836625, 0.29848814, 0.29860991, 0.29873168, 0.2988534, 0.29897502, 0.29909658, 0.29921806, 0.2993395, 0.29946086, 0.29958215, 0.29970342, 0.29982457, 0.29994568, 0.30006671, 0.30018768, 0.30030861, 0.30042943, 0.30055022, 0.30067092, 0.30079156, 0.30091214, 0.30103263, 0.30115312, 0.30127349, 0.30139384, 0.30151406, 0.30163425, 0.30175439, 0.30187443, 0.30199444, 0.30211434, 0.3022342, 0.30235401, 0.30247372, 0.30259341, 0.30271298, 0.30283257, 0.30295199, 0.30307141, 0.30319074, 0.30331001, 0.30342922, 0.30354834, 0.30366743, 0.30378646, 0.3039054, 0.30402428, 0.30414307, 0.30426186, 0.30438054, 0.30449915, 0.3046177, 0.3047362, 0.3048546, 0.30497295, 0.30509123, 0.30520949, 0.30532765, 0.30544576, 0.30556375, 0.30568174, 0.30579963, 0.30591747, 0.30603519, 0.30615294, 0.30627057, 0.30638814, 0.30650565, 0.30662307, 0.30674043, 0.30685779, 0.30697504, 0.30709219, 0.30720928, 0.30732635, 0.30744335, 0.30756024, 0.30767709, 0.30779389, 0.30791062, 0.30802727, 0.30814385, 0.30826038, 0.30837685, 0.30849323, 0.30860958, 0.3087258, 0.30884206, 0.30895817, 0.30907422, 0.30919024, 0.30930614, 0.30942205, 0.30953786, 0.30965355, 0.30976924, 0.30988488, 0.31000042, 0.31011587, 0.3102313, 0.31034666, 0.31046197, 0.31057715, 0.31069234, 0.31080738, 0.31092241, 0.31103733, 0.31115228, 0.31126711, 0.31138182, 0.31149337, 0.31160173, 0.31170997, 0.31181806, 0.31192598, 0.31203377, 0.31214145, 0.312249, 0.31235635, 0.31246358, 0.31257069, 0.31267765, 0.31278446, 0.31289116, 0.3129977, 0.31310409, 0.31321037, 0.31331649, 0.31342244, 0.3135283, 0.31363398, 0.31373954, 0.31384495, 0.31395021, 0.31405538, 0.31416038, 0.31426522, 0.31436992, 0.31447452, 0.31457892, 0.31468323, 0.31478739, 0.31489137, 0.31499526, 0.31509897, 0.31520259, 0.31530604, 0.3154093, 0.31551248, 0.31561553, 0.31571841, 0.31582117, 0.31592378, 0.31602624, 0.31612858, 0.31623074, 0.31633279, 0.31643471, 0.31653646, 0.31663808, 0.31673959, 0.31684089, 0.3169421, 0.31704319, 0.31714407, 0.31724486, 0.3173455, 0.31744599, 0.31754637, 0.31764659, 0.31774667, 0.3178466, 0.31794637, 0.31804603, 0.31814557, 0.31824496, 0.31834418, 0.31844327, 0.31854221, 0.31864104, 0.31873968, 0.31883824, 0.31893665, 0.3190349, 0.31913298, 0.31923097, 0.31932878, 0.31942651, 0.31952405, 0.31962144, 0.31971872, 0.31981584, 0.31991282, 0.32000965, 0.32010636, 0.32020292, 0.32029936, 0.32039565, 0.32049179, 0.32058781, 0.32068366, 0.32077938, 0.32087496, 0.32097042, 0.32106569, 0.32116085, 0.32125586, 0.32135075, 0.32144549, 0.32154012, 0.32163459, 0.32172889, 0.32182303, 0.32191712, 0.32201099, 0.32210475, 0.32219836, 0.32229185, 0.32238519, 0.32247835, 0.32257143, 0.32266435, 0.32275712, 0.32284975, 0.32294223, 0.32303458, 0.32312679, 0.32321885, 0.32331079, 0.32340258, 0.32349423, 0.32358575, 0.32367709, 0.32376835, 0.32385942, 0.32395038, 0.32404116, 0.32413188, 0.32422239, 0.32431275, 0.32440299, 0.32449311, 0.32458305, 0.32467288, 0.32476258, 0.32485211, 0.32494149, 0.32503077, 0.32511991, 0.32520887, 0.32529768, 0.32538643, 0.32547498, 0.3255634, 0.32565165, 0.32573974, 0.32582781, 0.32591569, 0.32600337, 0.3260909, 0.32617837, 0.32626569, 0.32635283, 0.32643983, 0.3265267, 0.32661343, 0.32670006, 0.32678652, 0.3268728, 0.32695895, 0.32704502, 0.32713094, 0.32721663, 0.3273022