// Class: ReadRuleFit
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : RuleFit::RuleFit
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:48:44 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 2000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "True" [Print method-specific help message]
GDTau: "-1.000000e+00" [Gradient-directed (GD) path: default fit cut-off]
GDTauPrec: "1.000000e-02" [GD path: precision of tau]
GDStep: "1.000000e-02" [GD path: step size]
GDNSteps: "10000" [GD path: number of steps]
GDErrScale: "1.020000e+00" [Stop scan when error > scale*errmin]
fEventsMin: "1.000000e-02" [Minimum fraction of events in a splittable node]
fEventsMax: "5.000000e-01" [Maximum fraction of events in a splittable node]
nTrees: "20" [Number of trees in forest.]
RuleMinDist: "1.000000e-03" [Minimum distance between rules]
MinImp: "1.000000e-03" [Minimum rule importance accepted]
Model: "modrulelinear" [Model to be used]
RuleFitModule: "rftmva" [Which RuleFit module to use]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
LinQuantile: "2.500000e-02" [Quantile of linear terms (removes outliers)]
GDPathEveFrac: "5.000000e-01" [Fraction of events used for the path search]
GDValidEveFrac: "5.000000e-01" [Fraction of events used for the validation]
ForestType: "adaboost" [Method to use for forest generation (AdaBoost or RandomForest)]
RFWorkDir: "./rulefit" [Friedman's RuleFit module (RFF): working dir]
RFNrules: "2000" [RFF: Mximum number of rules]
RFNendnodes: "4" [RFF: Average number of end nodes]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1+var2                     myvar1                        myvar1                        myvar1                                                          'F'    [-9.23118686676,7.07192516327]
var1-var2                     myvar2                        myvar2                        Expression 2                                                    'F'    [-3.70671987534,4.02912044525]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-5.15695810318,4.15070819855]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-6.31600189209,4.52105665207]
NSpec 2
var1*2                        spec1                         spec1                         Spectator 1                   units                             'F'    [-9.63254642487,9.05203056335]
var1*3                        spec2                         spec2                         Spectator 2                   units                             'F'    [-14.4488201141,13.578045845]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadRuleFit : public IClassifierReader {

 public:

   // constructor
   ReadRuleFit( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadRuleFit" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1+var2", "var1-var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadRuleFit() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   // not implemented for class: "ReadRuleFit"
};
void   ReadRuleFit::Initialize(){}
void   ReadRuleFit::Clear(){}
double ReadRuleFit::GetMvaValue__( const std::vector<double>& inputValues ) const {
   double rval=3.619441438;
   //
   // here follows all rules ordered in importance (most important first)
   // at the end of each line, the relative importance of the rule is given
   //
   if ((inputValues[1]<-0.0229863897)&&(inputValues[3]<-0.1233970076)) rval+=-0.6778870924;   // importance = 0.446
   if ((-0.6914615035<inputValues[0])&&(inputValues[3]<0.9626408815)) rval+=-0.4734510474;   // importance = 0.360
   if ((inputValues[0]<2.153033257)&&(inputValues[3]<-1.155497789)) rval+=-0.566681632;   // importance = 0.340
   if ((inputValues[3]<1.940804601)) rval+=-0.7781564598;   // importance = 0.334
   if ((1.246083617<inputValues[0])&&(-0.7247360349<inputValues[2])) rval+=-0.4853182091;   // importance = 0.325
   if ((inputValues[0]<1.61764431)&&(-0.0229863897<inputValues[1])&&(inputValues[3]<0.2452076524)) rval+=-0.460421955;   // importance = 0.321
   if ((-0.7247360349<inputValues[2])) rval+=-0.4506079075;   // importance = 0.311
   if ((-0.0229863897<inputValues[1])&&(inputValues[3]<-0.1233970076)) rval+=-0.4808301202;   // importance = 0.305
   if ((inputValues[2]<-0.7247360349)) rval+=-0.3452720747;   // importance = 0.239
   if ((-2.244138956<inputValues[0])) rval+=-0.4661373677;   // importance = 0.229
   if ((inputValues[1]<1.082133651)) rval+=-0.4028950606;   // importance = 0.221
   if ((1.082133651<inputValues[1])) rval+=-0.396094789;   // importance = 0.217
   if ((-0.3913597465<inputValues[1])&&(-0.28151384<inputValues[2])) rval+=-0.2526006264;   // importance = 0.190
   if ((-2.244138956<inputValues[0])&&(inputValues[0]<2.200624943)&&(inputValues[3]<1.158625007)) rval+=-0.2543072888;   // importance = 0.189
   if ((-0.6914615035<inputValues[0])&&(inputValues[2]<0.4522842467)&&(0.1944982558<inputValues[3])) rval+=0.3121599899;   // importance = 0.178
   if ((inputValues[1]<-0.0229863897)&&(-0.9146032929<inputValues[2])) rval+=-0.2225112534;   // importance = 0.173
   if ((0.510979116<inputValues[0])&&(inputValues[1]<-0.0229863897)) rval+=-0.2732425771;   // importance = 0.172
   if ((-0.0229863897<inputValues[1])&&(inputValues[2]<-0.28151384)) rval+=-0.2394081745;   // importance = 0.156
   if ((-1.155497789<inputValues[3])) rval+=-0.2318593898;   // importance = 0.139
   if ((-0.3625139594<inputValues[1])&&(inputValues[2]<0.764282167)&&(inputValues[3]<-1.155497789)) rval+=-0.2809247521;   // importance = 0.139
   if ((1.61764431<inputValues[0])&&(-0.0229863897<inputValues[1])) rval+=-0.3126152972;   // importance = 0.137
   if ((inputValues[0]<0.510979116)&&(inputValues[1]<-0.0229863897)&&(inputValues[3]<-0.5118201375)) rval+=-0.2104542304;   // importance = 0.124
   if ((-2.244138956<inputValues[0])&&(inputValues[0]<-0.1659156382)&&(-0.4970999062<inputValues[3])) rval+=0.2004680316;   // importance = 0.120
   if ((inputValues[0]<0.6233994365)&&(-0.2811155021<inputValues[1])&&(-0.4475024939<inputValues[3])) rval+=0.19805543;   // importance = 0.120
   if ((inputValues[1]<-0.3625139594)&&(inputValues[2]<0.764282167)&&(inputValues[3]<-1.155497789)) rval+=-0.2857568799;   // importance = 0.111
   if ((-1.46780014<inputValues[0])&&(-1.200075507<inputValues[1])&&(inputValues[1]<1.082133651)&&(inputValues[3]<1.188129187)) rval+=-0.1410472854;   // importance = 0.110
   if ((inputValues[0]<1.61764431)&&(-0.0229863897<inputValues[1])&&(inputValues[1]<0.5978314877)&&(0.2452076524<inputValues[3])) rval+=0.230411128;   // importance = 0.092
   if ((inputValues[2]<-1.127038121)&&(inputValues[3]<-1.671548247)) rval+=-0.2298627802;   // importance = 0.091
   if ((inputValues[0]<0.8612158298)&&(-0.3625139594<inputValues[1])) rval+=-0.1156069854;   // importance = 0.090
   if ((-0.0229863897<inputValues[1])&&(-0.28151384<inputValues[2])&&(inputValues[3]<1.031051874)) rval+=-0.1373441568;   // importance = 0.078
   if ((0.08091531694<inputValues[0])&&(inputValues[1]<-0.0229863897)&&(-0.9146032929<inputValues[2])) rval+=-0.1074082412;   // importance = 0.072
   if ((inputValues[0]<0.8612158298)&&(inputValues[1]<-0.3625139594)) rval+=0.1002632774;   // importance = 0.070
   if ((inputValues[0]<0.08091531694)&&(inputValues[1]<-0.0229863897)&&(-0.9146032929<inputValues[2])) rval+=-0.1127012477;   // importance = 0.068
   if ((-0.0229863897<inputValues[1])&&(-0.28151384<inputValues[2])&&(1.031051874<inputValues[3])) rval+=-0.1302844769;   // importance = 0.066
   if ((-1.46780014<inputValues[0])&&(-1.200075507<inputValues[1])&&(inputValues[1]<1.082133651)) rval+=-0.06727266032;   // importance = 0.053
   if ((-1.200075507<inputValues[1])&&(inputValues[1]<1.082133651)) rval+=-0.07272534909;   // importance = 0.052
   if ((-1.46780014<inputValues[0])&&(-1.200075507<inputValues[1])&&(inputValues[1]<1.082133651)&&(0.1081337929<inputValues[2])&&(1.188129187<inputValues[3])) rval+=0.08511793199;   // importance = 0.047
   if ((-1.46780014<inputValues[0])&&(-1.200075507<inputValues[1])&&(inputValues[1]<1.082133651)&&(1.188129187<inputValues[3])) rval+=0.07435749581;   // importance = 0.042
   if ((inputValues[0]<0.8612158298)) rval+=-0.04672915999;   // importance = 0.034
   if ((inputValues[1]<-0.0229863897)&&(inputValues[2]<-0.9146032929)) rval+=-0.06513113757;   // importance = 0.030
   if ((inputValues[0]<1.246083617)&&(-0.7247360349<inputValues[2])) rval+=0.03797624979;   // importance = 0.030
   if ((-2.244138956<inputValues[0])&&(1.158625007<inputValues[3])) rval+=-0.02505975051;   // importance = 0.016
   if ((inputValues[0]<0.08091531694)&&(inputValues[1]<-0.0229863897)&&(-0.9146032929<inputValues[2])&&(inputValues[2]<0.7529848218)) rval+=0.02625506466;   // importance = 0.015
   if ((inputValues[0]<-0.6914615035)&&(inputValues[1]<0.5923625827)&&(-0.4184372723<inputValues[3])) rval+=0.0338068639;   // importance = 0.012
   if ((-0.0229863897<inputValues[1])&&(inputValues[1]<0.751652956)&&(inputValues[2]<-0.28151384)) rval+=-0.02088464297;   // importance = 0.010
   if ((-2.322434187<inputValues[0])&&(inputValues[0]<-0.6914615035)&&(inputValues[1]<0.5923625827)&&(-0.4184372723<inputValues[3])) rval+=0.01933348684;   // importance = 0.007
   if ((-0.6914615035<inputValues[0])&&(0.4522842467<inputValues[2])&&(0.9626408815<inputValues[3])) rval+=0.004671952393;   // importance = 0.003
   if ((0.510979116<inputValues[0])&&(inputValues[1]<-0.0229863897)&&(inputValues[2]<0.9893216491)) rval+=-0.002071624867;   // importance = 0.001
   //
   // here follows all linear terms
   // at the end of each line, the relative importance of the term is given
   //
   rval+=-0.1919103324*std::min( double(3.380669355), std::max( double(inputValues[0]), double(-3.536707878)));   // importance = 0.534
   rval+=-0.03383091218*std::min( double(2.086761475), std::max( double(inputValues[1]), double(-2.052939415)));   // importance = 0.056
   rval+=0.01376273632*std::min( double(2.006258249), std::max( double(inputValues[2]), double(-2.172396898)));   // importance = 0.023
   rval+=0.4973132195*std::min( double(2.543531656), std::max( double(inputValues[3]), double(-2.378805399)));   // importance = 1.000
   return rval;
}
inline double ReadRuleFit::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
