// Class: ReadBDTG
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:49:17 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 4000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "1000" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
MinNodeSize: "5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-4.05916023254,3.26447582245]
var2                          var2                          var2                          Variable 2                                                      'F'    [-3.68905711174,3.78774046898]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-3.6296145916,3.91998791695]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-4.84856987,4.3625254631]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTGNode

#ifndef BDTGNode__def
#define BDTGNode__def

class BDTGNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTGNode ( BDTGNode* left,BDTGNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTGNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTGNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTGNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTGNode*   fLeft;     // pointer to the left daughter node
   BDTGNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTGNode::~BDTGNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTGNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTGNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG : public IClassifierReader {

 public:

   // constructor
   ReadBDTG( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   std::vector<double> GetMulticlassValues__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTGNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

std::vector<double> ReadBDTG::GetMulticlassValues__( const std::vector<double>& inputValues ) const
{
   uint nClasses = 4;
   std::vector<double> fMulticlassReturnVal;
   fMulticlassReturnVal.reserve(nClasses);

   std::vector<double> temp(nClasses);
   auto forestSize = fForest.size();
   // trees 0, nClasses, 2*nClasses, ... belong to class 0
   // trees 1, nClasses+1, 2*nClasses+1, ... belong to class 1 and so forth
   uint classOfTree = 0;
   for (uint itree = 0; itree < forestSize; ++itree) {
      BDTGNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTGNode*)current->GetRight();
         else current=(BDTGNode*)current->GetLeft();
      }
      temp[classOfTree] += current->GetResponse();
      if (++classOfTree == nClasses) classOfTree = 0; // cheap modulo
   }

   // we want to calculate sum of exp(temp[j] - temp[i]) for all i,j (i!=j)
   // first calculate exp(), then replace minus with division.
   std::transform(temp.begin(), temp.end(), temp.begin(), [](double d){return exp(d);});

   for(uint iClass=0; iClass<nClasses; iClass++){
      double norm = 0.0;
      for(uint j=0;j<nClasses;j++){
         if(iClass!=j)
            norm += temp[j] / temp[iClass];
      }
      fMulticlassReturnVal.push_back(1.0/(1.0+norm));
   }

   return fMulticlassReturnVal;
}
void ReadBDTG::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153724,-0.0385103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0415945,-0.0833622) , 
0, -0.300315, 1, 0, 0.100166,-0.149834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59375,0.1375) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283465,0.0133858) , 
1, 0.622372, 1, 0, 0.403382,0.153382) , 
3, 0.196496, 1, 0, 0.223477,-0.0265226)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342163,0.0368653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228856,-0.00845771) , 
3, -0.307088, 1, 0, 0.296885,-0.0969185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0576923,-0.0769231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115663,-0.0537349) , 
2, 0.100458, 1, 0, 0.104046,0.281792) , 
3, 0.766583, 1, 0, 0.247535,0)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323563,0.029425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315421,0.0261682) , 
1, 0.607092, 1, 0, 0.320913,-0.110076) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104396,-0.0582418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0890411,-0.0643836) , 
3, 1.78889, 1, 0, 0.101156,0.208092) , 
3, 0.496563, 1, 0, 0.245142,-0.000373692)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246973,-0.00121065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245,-0.002) , 
3, -1.15263, 1, 0, 0.245672,-0.11892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175127,-0.0299492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371658,0.0486631) , 
1, 1.05548, 1, 0, 0.270833,0.22526) , 
3, 0.334648, 1, 0, 0.255427,0.0145129)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182648,-0.0237135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0204082,-0.0900504) , 
1, 0.660051, 1, 0, 0.132492,-0.107192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193277,-0.0283914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579137,0.119514) , 
2, -0.169556, 1, 0, 0.511111,0.243783) , 
3, 0.521064, 1, 0, 0.264025,0.0147372)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337149,0.0308779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208754,-0.0148535) , 
3, -0.182678, 1, 0, 0.288103,-0.0820718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00980392,-0.093962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.086351,-0.0631074) , 
2, 0.0793695, 1, 0, 0.0694143,0.261058) , 
3, 0.934984, 1, 0, 0.238095,-0.00360816)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361927,0.0414867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235955,-0.00625658) , 
3, -0.321302, 1, 0, 0.313357,-0.104665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0423077,-0.08095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14375,-0.0391742) , 
1, 0.933129, 1, 0, 0.0982759,0.237092) , 
3, 0.744319, 1, 0, 0.249873,-0.00378994)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230224,-0.00752199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181586,-0.0271069) , 
3, -0.249961, 1, 0, 0.214863,-0.110084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342419,0.0351325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.101374) , 
3, 1.9347, 1, 0, 0.291727,0.205779) , 
3, 0.518766, 1, 0, 0.242346,0.00285294)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0589711,-0.0714175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249655,0.000861767) , 
3, -0.48025, 1, 0, 0.149803,-0.0858989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256637,-0.00883708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.620253,0.115866) , 
2, 0.350371, 1, 0, 0.53937,0.245563) , 
3, 0.873167, 1, 0, 0.247291,-0.00295186)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430233,0.0661727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108959,-0.0595109) , 
1, 0.615983, 1, 0, 0.326002,-0.0984705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154341,-0.0314381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141711,-0.0366571) , 
1, 0.915842, 1, 0, 0.147445,0.165728) , 
3, 0.414913, 1, 0, 0.263534,-0.00604158)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302655,0.0149123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388309,0.046932) , 
1, -0.0879733, 1, 0, 0.341954,-0.137183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10262,-0.0550262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212,-0.010371) , 
1, 0.714969, 1, 0, 0.159708,0.14226) , 
3, -0.097287, 1, 0, 0.254745,-0.0034636)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205479,-0.0908397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292798,0.0182172) , 
0, -0.966672, 1, 0, 0.223003,-0.126609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340393,0.0331357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10687,-0.056928) , 
3, 1.78536, 1, 0, 0.301768,0.140458) , 
3, 0.196496, 1, 0, 0.255308,-0.0170715)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759912,-0.061011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269142,0.0115434) , 
3, -0.222109, 1, 0, 0.138163,-0.0829874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169492,-0.037994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594737,0.0960667) , 
2, -0.0598791, 1, 0, 0.521802,0.212504) , 
3, 0.540694, 1, 0, 0.268377,0.0173078)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369919,0.0325323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335735,0.0247148) , 
0, -1.07655, 1, 0, 0.344681,-0.137897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189109,-0.0184156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,-0.0371768) , 
3, 1.85924, 1, 0, 0.183186,0.0870956) , 
3, -0.305034, 1, 0, 0.256522,-0.0150751)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321315,0.0223151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27095,-0.00141931) , 
1, 0.733964, 1, 0, 0.307456,-0.0765541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0971494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124528,-0.0399145) , 
2, 0.0571631, 1, 0, 0.0988024,0.182552) , 
3, 0.538396, 1, 0, 0.236668,0.0113499)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0791717,-0.0661403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579208,0.127614) , 
1, 0.607092, 1, 0, 0.244082,-0.105589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154054,-0.0389386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450617,0.0711763) , 
1, 1.05548, 1, 0, 0.292507,0.16691) , 
3, 0.436997, 1, 0, 0.261595,-0.00704048)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177305,-0.0152456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.034642,-0.0815396) , 
0, 0.151201, 1, 0, 0.129007,-0.0851811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.0545244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557348,0.0729966) , 
2, -0.202095, 1, 0, 0.491629,0.163682) , 
3, 0.540694, 1, 0, 0.252066,-0.00072717)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323485,0.0196261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172619,-0.0189716) , 
3, 0.395793, 1, 0, 0.281798,-0.0513628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0558659,-0.0687461) , 
3, 1.63045, 1, 0, 0.261608,-0.0133812)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310777,0.0138435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334012,0.0247185) , 
1, 0.428601, 1, 0, 0.319628,-0.0876813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135088,-0.0324502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.045045,-0.0743379) , 
3, 1.90404, 1, 0, 0.120411,0.1724) , 
3, 0.41381, 1, 0, 0.250761,0.00222483)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252907,0.0077166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197051,-0.0201409) , 
3, -1.30909, 1, 0, 0.214679,-0.106266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30798,0.017033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0829959) , 
3, 1.88034, 1, 0, 0.272826,0.117286) , 
3, 0.108015, 1, 0, 0.241294,-0.00394401)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107664,-0.0419083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.011396,-0.0870079) , 
2, -0.2064, 1, 0, 0.0700779,-0.123005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518389,0.079678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257895,-0.0130452) , 
1, 0.782307, 1, 0, 0.388256,0.0913327) , 
3, -0.343942, 1, 0, 0.248039,-0.00312301)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361884,0.025483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345382,0.0230214) , 
3, -1.1145, 1, 0, 0.353368,-0.129136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217391,-0.00923776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139045,-0.0335352) , 
1, 0.366441, 1, 0, 0.166818,0.0985722) , 
3, -0.27663, 1, 0, 0.253868,-0.00768431)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351261,0.0253126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295455,0.0102193) , 
3, -0.73565, 1, 0, 0.321016,-0.080741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709677,-0.0578768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148368,-0.0240356) , 
1, 0.95027, 1, 0, 0.111283,0.179358) , 
3, 0.540694, 1, 0, 0.251285,0.00573578)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.050505,-0.0742653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295875,0.020398) , 
0, -0.866767, 1, 0, 0.223,-0.107279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,-0.0277466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379377,0.0388705) , 
1, 0.801379, 1, 0, 0.280684,0.0919225) , 
3, -0.097287, 1, 0, 0.251755,-0.00797797)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205405,0.00692246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0529986,-0.0646647) , 
1, -1.02907, 1, 0, 0.0842572,-0.0982272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540146,0.0756301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255183,-0.012209) , 
1, 0.778239, 1, 0, 0.388085,0.0829235) , 
3, -0.306978, 1, 0, 0.256139,0.00425332)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367003,0.0216251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319536,0.0112977) , 
0, -0.878028, 1, 0, 0.335183,-0.0918423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217586,-0.00337876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104019,-0.0457254) , 
1, 1.06035, 1, 0, 0.173675,0.101125) , 
3, -0.322723, 1, 0, 0.246617,0.0139754)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411638,0.0440626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286701,0.000787647) , 
0, -0.623812, 1, 0, 0.342282,-0.106773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0997567,-0.0501538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203267,-0.00427054) , 
1, 0.60951, 1, 0, 0.159044,0.0867815) , 
3, -0.0727496, 1, 0, 0.254364,-0.0139055)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0749319,-0.0638111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475655,0.0792154) , 
1, 0.230585, 1, 0, 0.243691,-0.0737594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156334,-0.0331068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395028,0.0377659) , 
1, 1.05548, 1, 0, 0.274216,0.123144) , 
3, 0.436997, 1, 0, 0.254873,-0.00163033)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238183,0.0124997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103448,-0.0638098) , 
0, 0.276882, 1, 0, 0.189573,-0.0388721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435897,0.0275034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641414,0.0811362) , 
2, 0.768589, 1, 0, 0.565079,0.190214) , 
3, 1.29216, 1, 0, 0.248627,-0.00284501)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293706,0.00988893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243108,0.000347234) , 
0, 0.64063, 1, 0, 0.281732,-0.0387955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0322581,-0.0771991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.0316491) , 
2, 0.610368, 1, 0, 0.0897098,0.186669) , 
3, 1.19852, 1, 0, 0.246489,0.00258525)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288991,0.00926846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207207,-0.00617902) , 
0, 0.657373, 1, 0, 0.268265,-0.028347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670103,-0.059539) , 
3, 1.63045, 1, 0, 0.248201,0.00270363)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120956,-0.046199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647668,0.118003) , 
1, 1.17822, 1, 0, 0.233407,-0.0206868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403509,0.0511438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0971972) , 
3, 2.00636, 1, 0, 0.202643,0.266039) , 
3, 1.63045, 1, 0, 0.229975,0.0112969)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23813,0.00705675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1174,-0.0635853) , 
0, 0.653609, 1, 0, 0.206934,-0.0301523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.702381,0.0944254) , 
3, 1.69879, 1, 0, 0.248262,-0.00272363)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395181,0.0321076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33887,0.0150285) , 
3, -1.19286, 1, 0, 0.371508,-0.12719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167587,-0.0268487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224518,0.00616238) , 
0, 0.320733, 1, 0, 0.200158,0.0527361) , 
3, -0.609804, 1, 0, 0.261965,-0.0121642)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311724,0.0180471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20339,-0.0104384) , 
0, 0.810159, 1, 0, 0.290466,-0.0421575) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.061393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,-0.0467785) , 
3, 2.01744, 1, 0, 0.0714286,0.26085) , 
3, 1.64517, 1, 0, 0.267627,-0.0105628)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180812,-0.0124429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258824,0.0103783) , 
3, -1.53014, 1, 0, 0.231754,-0.125887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255499,-0.00564697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233618,-0.0101506) , 
0, 0.327589, 1, 0, 0.243619,0.0667005) , 
3, -0.502231, 1, 0, 0.239151,-0.00582157)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144654,-0.0211804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0255942,-0.076439) , 
0, -1.34779, 1, 0, 0.0524079,-0.119109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44086,0.0657426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300792,-0.00695666) , 
0, 0.207319, 1, 0, 0.360182,0.0602909) , 
3, -0.609804, 1, 0, 0.25272,-0.0023483)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416883,0.0412422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141429,-0.0422662) , 
1, 0.221805, 1, 0, 0.285714,-0.0445755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0657895,-0.0616863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126344,-0.0250183) , 
2, 0.459885, 1, 0, 0.108779,0.143374) , 
3, 0.786213, 1, 0, 0.239218,0.00481544)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259934,-0.0129214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337248,0.0194452) , 
1, -0.0700232, 1, 0, 0.298333,-0.0727808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730337,-0.0588991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202326,0.00954229) , 
0, 0.553751, 1, 0, 0.143766,0.103762) , 
3, 0.254389, 1, 0, 0.23716,-0.00291047)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217494,0.00263681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208451,-0.0142293) , 
3, -1.08103, 1, 0, 0.211827,-0.0790097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291951,0.00630506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0190476,-0.0862659) , 
3, 1.89553, 1, 0, 0.257757,0.107183) , 
3, 0.214106, 1, 0, 0.231355,0.000152818)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157783,-0.0112761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0257353,-0.0761622) , 
1, -0.24379, 1, 0, 0.0868707,-0.0844615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551471,0.064372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253259,-0.0190566) , 
1, 0.678798, 1, 0, 0.382011,0.0528091) , 
3, -0.097287, 1, 0, 0.229316,-0.0182099)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340686,0.0202634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121464,-0.0404001) , 
1, 0.844519, 1, 0, 0.268493,-0.0192717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0864198,-0.0438436) , 
3, 1.69879, 1, 0, 0.253649,0.00409393)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360494,0.0216305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298361,0.00114684) , 
3, -1.22913, 1, 0, 0.323153,-0.0845945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131012,-0.0355956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207143,0.0057925) , 
0, 0.761716, 1, 0, 0.162268,0.0566607) , 
3, -0.097287, 1, 0, 0.242395,-0.0136897)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875576,-0.0535978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496644,0.0701007) , 
1, 0.460069, 1, 0, 0.254098,-0.0416004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336986,0.0227176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.042735,-0.0748868) , 
3, 1.85949, 1, 0, 0.26556,0.160159) , 
3, 0.853537, 1, 0, 0.256937,0.00837275)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191932,0.00154153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512295,-0.0686638) , 
0, 0.0514282, 1, 0, 0.139357,-0.0486985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147826,-0.0496619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544041,0.0455065) , 
2, -0.200713, 1, 0, 0.478386,0.0971313) , 
3, 0.518766, 1, 0, 0.257,0.00190447)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496364,0.0545075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193676,-0.028784) , 
1, -0.0512315, 1, 0, 0.351326,-0.0794541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0250318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192982,-0.00282348) , 
0, 0.80216, 1, 0, 0.163561,0.0347896) , 
3, -0.0727496, 1, 0, 0.261622,-0.0248748)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496504,0.0637462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34874,0.0163123) , 
0, -1.5794, 1, 0, 0.382876,-0.11276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161238,-0.0348626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257336,0.0173466) , 
1, 0.365835, 1, 0, 0.218,0.0528953) , 
3, -0.931712, 1, 0, 0.266163,0.0045044)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188667,-0.0244901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506993,0.102243) , 
0, 0.984226, 1, 0, 0.238173,-0.0299965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201005,-0.0112618) , 
3, 1.64517, 1, 0, 0.234544,-0.00252719)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212121,-0.00084683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0831793,-0.0668353) , 
0, 0.385584, 1, 0, 0.170174,-0.0495516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42487,0.0143795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.823529,0.100066) , 
3, 1.93937, 1, 0, 0.562712,0.1427) , 
3, 1.35089, 1, 0, 0.229316,-0.0205861)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392435,0.0234223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,0.0074656) , 
3, -1.14825, 1, 0, 0.331456,-0.0710741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0820046,-0.0493483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182891,0.00146061) , 
0, 0.8676, 1, 0, 0.125964,0.083858) , 
3, 0.334648, 1, 0, 0.25235,-0.0114317)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292184,0.00921859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187739,-0.0163729) , 
0, 0.580642, 1, 0, 0.263353,-0.027246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892857,-0.0423439) , 
3, 1.75738, 1, 0, 0.24915,-0.000999314)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0556348,-0.0643744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423435,0.0482254) , 
1, 0.076786, 1, 0, 0.245868,-0.0467097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642857,0.114991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117801,-0.0524071) , 
2, 0.459885, 1, 0, 0.278182,0.134698) , 
3, 0.766583, 1, 0, 0.254745,0.00312749)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197213,-0.000182031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0615079,-0.0667357) , 
0, 0.155609, 1, 0, 0.149617,-0.0469835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150943,-0.0483456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.602299,0.0543426) , 
2, 0.0611828, 1, 0, 0.513863,0.113706) , 
3, 0.786213, 1, 0, 0.249242,-0.00303361)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469154,0.0429921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16113,-0.0302633) , 
1, 0.230585, 1, 0, 0.326405,-0.0708759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0502645,-0.0625849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167832,-0.00474812) , 
0, 0.828056, 1, 0, 0.100904,0.109597) , 
3, 0.490789, 1, 0, 0.250127,-0.0098294)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4329,0.0384408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347692,0.0171538) , 
0, -1.04957, 1, 0, 0.370034,-0.0781643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151042,-0.0253495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203327,-0.000381656) , 
1, 0.844635, 1, 0, 0.176365,0.0564197) , 
3, -0.27663, 1, 0, 0.261762,-0.00292387)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260965,0.0264892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269474,0.0118929) , 
3, -1.10603, 1, 0, 0.265306,-0.0779978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128874,-0.0430103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446009,0.0399153) , 
1, 1.02996, 1, 0, 0.258903,0.0599651) , 
3, -0.27663, 1, 0, 0.261929,-0.00523465)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200906,0.00866409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0495727,-0.0657078) , 
1, 0.076786, 1, 0, 0.129912,-0.0476818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634146,0.0682987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319355,-0.00736895) , 
1, 1.09711, 1, 0, 0.490427,0.106255) , 
3, 0.414913, 1, 0, 0.257009,0.00658775)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386831,0.0132191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329429,0.00565653) , 
0, -1.0843, 1, 0, 0.344492,-0.0710462) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216418,-0.0137952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139241,-0.0164605) , 
1, 0.289248, 1, 0, 0.165268,0.0528391) , 
3, -0.287516, 1, 0, 0.243626,-0.00132414)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391129,0.023472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315141,0.00480133) , 
0, -1.04534, 1, 0, 0.338235,-0.0799044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161501,-0.0224107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202822,-0.00112328) , 
1, 0.760935, 1, 0, 0.181356,0.0518402) , 
3, -0.462334, 1, 0, 0.245491,-0.00201931)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0874587,-0.0479414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12517,-0.0375553) , 
3, -0.611724, 1, 0, 0.108128,0.0445062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565485,0.0690857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204225,-0.0160969) , 
3, 1.59928, 1, 0, 0.500632,-0.0876764) , 
1, 0.810825, 1, 0, 0.253752,-0.0045353)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,-0.0250016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0203562,-0.0748902) , 
2, -1.00993, 1, 0, 0.053068,-0.0929984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450184,0.0571054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264312,-0.0141117) , 
1, 0.366441, 1, 0, 0.338225,0.0366025) , 
3, -0.691091, 1, 0, 0.250763,-0.00314795)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270211,0.00145024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221007,-0.00651657) , 
0, 0.695205, 1, 0, 0.257923,-0.0259694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0949721,-0.0301903) , 
3, 1.70652, 1, 0, 0.243405,-0.00735028)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55,0.0724388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326165,0.00658285) , 
0, -1.39107, 1, 0, 0.393484,-0.11032) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173841,-0.0301004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254289,0.0144983) , 
1, 0.255215, 1, 0, 0.223824,0.0138228) , 
3, -1.17518, 1, 0, 0.257773,-0.0110183)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192029,0.00265992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265714,0.0182414) , 
3, -1.51696, 1, 0, 0.233227,-0.0972035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134003,-0.0298435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394879,0.0237217) , 
1, 0.558921, 1, 0, 0.278566,0.0367108) , 
3, -0.738559, 1, 0, 0.264122,-0.00595098)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222733,0.00250756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104693,-0.0708375) , 
0, 0.988455, 1, 0, 0.204558,-0.0212933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.699454,0.0638638) , 
3, 1.70387, 1, 0, 0.250252,-0.000450359)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424908,0.0305199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281513,-0.0146959) , 
3, -1.51767, 1, 0, 0.358121,-0.102758) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141414,-0.0525483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229978,0.00548521) , 
0, -0.917883, 1, 0, 0.223973,0.036023) , 
3, -0.961157, 1, 0, 0.258752,4.28028e-05)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288706,0.0106725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175084,-0.0164895) , 
0, 1.01437, 1, 0, 0.270689,-0.0144087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0616438,-0.0529486) , 
3, 1.80375, 1, 0, 0.255572,0.00531662)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0077821,-0.0860667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27577,0.0121528) , 
0, -1.04087, 1, 0, 0.207171,-0.0682058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274406,-0.00172746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258621,-0.0032146) , 
0, 0.315313, 1, 0, 0.264503,0.0595029) , 
3, -0.097287, 1, 0, 0.236022,-0.00394071)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243849,0.0117386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105618,-0.0663194) , 
0, 0.722623, 1, 0, 0.210181,-0.0184713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.710059,0.0563091) , 
3, 1.77248, 1, 0, 0.252505,-0.00164023)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27825,0.00590931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149007,-0.0422393) , 
0, 1.04141, 1, 0, 0.256956,-0.0178853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0958084,-0.027369) , 
3, 1.73078, 1, 0, 0.2435,-0.0015406)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.489796,0.0441128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359036,0.0158505) , 
0, -1.64915, 1, 0, 0.384016,-0.0959981) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151067,-0.0346718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292994,0.0317007) , 
1, 0.409101, 1, 0, 0.23099,0.0230022) , 
3, -0.961157, 1, 0, 0.272155,-0.00900993)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0638298,-0.0542579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382582,0.0368025) , 
1, -0.187314, 1, 0, 0.247978,-0.0602938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292453,-0.0027565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262295,0.00841994) , 
0, 0.822589, 1, 0, 0.280134,0.0644995) , 
3, 0.159145, 1, 0, 0.26232,-0.00463685)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0231092,-0.073025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104348,-0.0206494) , 
3, -1.05906, 1, 0, 0.0389171,-0.0985959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378378,0.0467804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263294,-0.0191325) , 
0, 0.203597, 1, 0, 0.316632,0.026206) , 
3, -0.871513, 1, 0, 0.2357,-0.0101638)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393333,0.0178717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279661,-0.0160214) , 
3, -1.49068, 1, 0, 0.361244,-0.103952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232759,-0.0181774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214477,-0.00299559) , 
0, -0.917883, 1, 0, 0.215796,0.030283) , 
3, -1.13113, 1, 0, 0.245805,0.00258788)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443902,0.0309374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328257,0.00851708) , 
0, -1.06357, 1, 0, 0.35804,-0.0785276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185233,-0.0138484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237975,0.027498) , 
0, 0.83406, 1, 0, 0.203085,0.0520021) , 
3, -0.462334, 1, 0, 0.26592,-0.000927918)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0262295,-0.073031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345133,0.0366273) , 
1, -0.610897, 1, 0, 0.233333,-0.0567156) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279126,-0.00157726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223881,-0.0159904) , 
0, 0.288088, 1, 0, 0.244917,0.057591) , 
3, -0.27663, 1, 0, 0.239754,0.00664489)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283146,0.0231921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165217,-0.0326138) , 
1, 0.28414, 1, 0, 0.223204,-0.0111437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.880734,0.0967273) , 
3, 2.00929, 1, 0, 0.260552,0.00718003)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394161,0.0173397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316742,-0.000137952) , 
3, -1.15649, 1, 0, 0.367089,-0.087406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263687,0.00630274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0874317,-0.0387295) , 
1, 1.02285, 1, 0, 0.196676,0.0345258) , 
3, -0.765551, 1, 0, 0.248555,-0.00259411)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247423,-0.0233009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366133,0.0235147) , 
1, -0.784061, 1, 0, 0.336481,-0.0414763) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0954654,-0.0401876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165432,-0.0114777) , 
1, 0.936658, 1, 0, 0.129854,0.0673397) , 
3, 0.196496, 1, 0, 0.25088,0.00360387)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0163934,-0.0772231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287933,0.013881) , 
1, -0.883095, 1, 0, 0.226642,-0.0370413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265193,-0.00999342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282209,0.0104346) , 
0, 0.8676, 1, 0, 0.271577,0.0607801) , 
3, 0.109967, 1, 0, 0.246667,0.00655195)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174652,0.00364269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.051458,-0.0611641) , 
0, -0.313714, 1, 0, 0.11626,-0.0448146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537525,0.0586996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366864,-0.0128872) , 
0, 0.808877, 1, 0, 0.468111,0.0853014) , 
3, 0.21524, 1, 0, 0.258127,0.0076485)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430962,0.0281207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339806,0.0136802) , 
0, -1.09243, 1, 0, 0.360301,-0.0549494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118881,-0.0289007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227041,0.0243323) , 
0, 0.80216, 1, 0, 0.162863,0.0461791) , 
3, -0.0237104, 1, 0, 0.266404,-0.00685473)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374034,0.0174163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117764,-0.0376987) , 
3, -0.379388, 1, 0, 0.262195,0.0448907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29055,0.0149119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.0414698) , 
3, 1.48173, 1, 0, 0.25,-0.0571106) , 
1, 0.568008, 1, 0, 0.25689,0.000516115)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,-0.00716707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394904,0.033177) , 
2, 0.424249, 1, 0, 0.250205,-0.0500089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193694,-0.016094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41853,0.0248258) , 
1, 1.1924, 1, 0, 0.286658,0.0756706) , 
3, 0.334648, 1, 0, 0.26417,-0.00186146)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201087,0.0151296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0448505,-0.0602834) , 
1, -0.159794, 1, 0, 0.119584,-0.0345837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546845,0.0568955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351648,-0.0151287) , 
0, 0.879187, 1, 0, 0.466742,0.079527) , 
3, 0.15517, 1, 0, 0.270456,0.0150077)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579268,0.0596664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298122,-0.00949409) , 
1, -0.993154, 1, 0, 0.376271,-0.0849529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188571,-0.0225716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206605,-0.0020294) , 
0, -0.656486, 1, 0, 0.204277,0.0348045) , 
3, -0.869239, 1, 0, 0.256423,-0.00150426)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357759,0.00728701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384236,0.0178772) , 
1, -0.426269, 1, 0, 0.370115,-0.114235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161905,-0.0531531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220816,-0.00107902) , 
0, -0.980891, 1, 0, 0.216765,0.0240765) , 
3, -1.17385, 1, 0, 0.250765,-0.00658897)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0880759,-0.0464669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141856,-0.0301822) , 
3, -0.194819, 1, 0, 0.111536,0.0391765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606654,0.0684701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259067,-0.00874147) , 
3, 1.32658, 1, 0, 0.511364,-0.0675104) , 
1, 0.939437, 1, 0, 0.251366,0.00186524)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159798,-0.0135716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0228013,-0.0845306) , 
0, 0.615001, 1, 0, 0.131684,-0.0505477) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585799,0.0558439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387978,-0.0223025) , 
0, 1.14131, 1, 0, 0.516315,0.0842629) , 
3, 0.752409, 1, 0, 0.231036,-0.0157255)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370968,0.00136931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330551,0.00293162) , 
0, -1.16859, 1, 0, 0.340127,-0.0599932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157699,-0.0146709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251185,0.0227469) , 
0, 0.327589, 1, 0, 0.208191,0.0372859) , 
3, -0.435343, 1, 0, 0.261114,-0.0017351)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270218,0.00110335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185535,-0.0157328) , 
0, 1.02176, 1, 0, 0.255864,-0.0153229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.0563585) , 
3, 1.77248, 1, 0, 0.243,-0.0024583)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104972,-0.0270856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130162,-0.039106) , 
3, -1.17015, 1, 0, 0.123984,0.0270209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.645933,0.0706141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225,-0.0139441) , 
3, 1.37466, 1, 0, 0.529412,-0.0912677) , 
1, 1.16801, 1, 0, 0.238072,-0.0062658)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934579,-0.0298421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0103448,-0.0784722) , 
0, -1.54772, 1, 0, 0.0327456,-0.0903644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434579,0.0806759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304444,-0.000346177) , 
1, -0.577554, 1, 0, 0.322251,0.0246846) , 
3, -1.17255, 1, 0, 0.263641,0.0013932)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445344,0.0249302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328455,0.00177089) , 
0, -1.06357, 1, 0, 0.361949,-0.0750933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218524,-0.00248212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130221,-0.000707867) , 
1, 1.09981, 1, 0, 0.185792,0.0401231) , 
3, -0.306978, 1, 0, 0.263265,-0.0105486)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310461,0.0109494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177928,-0.0192553) , 
0, 0.563554, 1, 0, 0.266317,0.0501062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211155,-0.0100854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.080292,-0.0367913) , 
3, 1.64292, 1, 0, 0.183099,-0.0645503) , 
1, 1.03517, 1, 0, 0.239351,0.0129533)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0977273,-0.0315415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117127,-0.038174) , 
3, -0.969901, 1, 0, 0.110781,0.0367867) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597806,0.057039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215686,-0.00430902) , 
3, 1.64292, 1, 0, 0.514286,-0.0558739) , 
1, 0.939437, 1, 0, 0.2489,0.00506915)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190171,0.00221727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0573913,-0.0686859) , 
0, 0.118909, 1, 0, 0.139643,-0.0440919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.0265397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683761,0.0547738) , 
2, 0.253147, 1, 0, 0.584615,0.115279) , 
3, 0.873167, 1, 0, 0.242625,-0.00720807)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34996,0.0174207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0879121,-0.059522) , 
2, 0.795867, 1, 0, 0.30277,-0.0284237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0538462,-0.0579579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107226,-0.0203486) , 
2, 0.216608, 1, 0, 0.0948122,0.0881756) , 
3, 0.832675, 1, 0, 0.246747,0.00298791)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381313,0.0125823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302932,0.00106209) , 
0, -0.700762, 1, 0, 0.333663,-0.0458288) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149215,-0.0156706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,-0.000576865) , 
0, 1.17327, 1, 0, 0.151515,0.0713429) , 
3, -0.097287, 1, 0, 0.2435,0.0121712)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163134,-0.0299846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467866,0.0663649) , 
0, 0.414055, 1, 0, 0.243555,-0.0315182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597403,0.0979782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101227,-0.0560198) , 
2, 0.612441, 1, 0, 0.260417,0.0869899) , 
3, 0.873167, 1, 0, 0.247697,-0.00240672)    );
  // itree = 100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270025,0.0121627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11557,-0.0464097) , 
1, 0.921611, 1, 0, 0.217557,-0.0139904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851852,0.0746089) , 
3, 1.90896, 1, 0, 0.252832,-0.000481335)    );
  // itree = 101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44385,0.0162675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299566,0.0043638) , 
3, -0.973588, 1, 0, 0.350235,0.032624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13489,-0.0197936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09375,-0.0217871) , 
3, 1.60934, 1, 0, 0.12782,-0.0514503) , 
1, 0.549178, 1, 0, 0.246493,-0.00659101)    );
  // itree = 102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429577,0.0171562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335065,0.0066971) , 
0, -1.52658, 1, 0, 0.349781,-0.0649811) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130952,-0.0297326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212544,0.0122967) , 
1, 0.760935, 1, 0, 0.174397,0.0466732) , 
3, -0.347261, 1, 0, 0.254774,-0.00449699)    );
  // itree = 103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0158103,-0.0771968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318621,0.0329571) , 
0, -1.04957, 1, 0, 0.240286,-0.0480627) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131532,-0.030631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443975,0.021325) , 
1, 0.936658, 1, 0, 0.275292,0.041915) , 
3, -0.245873, 1, 0, 0.258225,-0.00195246)    );
  // itree = 104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236825,0.00938664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0948905,-0.0673212) , 
0, 1.04141, 1, 0, 0.215351,-0.00490434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.769784,0.0529461) , 
3, 1.73078, 1, 0, 0.254872,0.00707783)    );
  // itree = 105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477876,0.0212186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298193,-0.0108779) , 
3, -1.98284, 1, 0, 0.34382,-0.0949279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336252,0.00633676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130841,-0.0212692) , 
1, 0.109072, 1, 0, 0.202316,0.0355461) , 
3, -1.10169, 1, 0, 0.232502,0.00771249)    );
  // itree = 106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359756,0.00599405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313916,-0.00306862) , 
3, -1.33862, 1, 0, 0.33752,-0.0753226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195291,-0.0109182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187311,0.00142201) , 
0, 0.389104, 1, 0, 0.191474,0.0407001) , 
3, -0.736148, 1, 0, 0.237506,0.00413086)    );
  // itree = 107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00387597,-0.0869022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32058,0.0261032) , 
0, -0.957513, 1, 0, 0.240157,-0.0547435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277574,-0.00921343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258824,0.00469483) , 
0, 0.729549, 1, 0, 0.26935,0.0577792) , 
3, -0.0237104, 1, 0, 0.254408,0.000185707)    );
  // itree = 108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185102,0.0124008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.035473,-0.0620248) , 
1, -0.321551, 1, 0, 0.0995169,-0.0392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.50219,0.0466919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34375,-0.0205686) , 
0, 1.0178, 1, 0, 0.451741,0.0689998) , 
3, -0.0727496, 1, 0, 0.273039,0.0141043)    );
  // itree = 109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391876,0.00937811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16309,-0.0152601) , 
1, 0.257617, 1, 0, 0.28776,-0.0374506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0881852) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118421,-0.00665935) , 
2, 0.132938, 1, 0, 0.0924025,0.0726962) , 
3, 0.892407, 1, 0, 0.240732,-0.0109348)    );
  // itree = 110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382865,0.0181807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176166,-0.0133057) , 
3, -0.45652, 1, 0, 0.277814,0.0228735) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21,-0.00471958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.0114854) , 
3, 1.89073, 1, 0, 0.187251,-0.0756231) , 
0, 0.813325, 1, 0, 0.255319,-0.00159223)    );
  // itree = 111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0838041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329918,0.0456478) , 
0, -1.52658, 1, 0, 0.270134,-0.0783712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109677,-0.0313763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358726,0.00212293) , 
1, 0.485771, 1, 0, 0.243666,0.0461067) , 
3, -0.815817, 1, 0, 0.251806,0.00782552)    );
  // itree = 112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0868946,-0.0307358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475543,0.035024) , 
3, -0.364179, 1, 0, 0.285814,0.0263994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0712531,-0.0570471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466292,-0.000869891) , 
3, 1.3177, 1, 0, 0.191453,-0.0693983) , 
1, 1.13266, 1, 0, 0.258527,-0.00130283)    );
  // itree = 113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393316,0.000571333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297335,0.00549603) , 
3, -1.00586, 1, 0, 0.331216,0.0501912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126506,-0.0184144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101852,-0.00952072) , 
3, 1.41316, 1, 0, 0.120455,-0.0477344) , 
1, 0.583399, 1, 0, 0.237639,0.00671262)    );
  // itree = 114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294308,0.0127478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143345,-0.0342518) , 
0, 1.04141, 1, 0, 0.270256,-0.0213112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.038835,-0.0557929) , 
3, 1.90896, 1, 0, 0.257981,-0.00983745)    );
  // itree = 115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00321543,-0.0908743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382536,0.0612282) , 
0, 0.616994, 1, 0, 0.132249,0.0264122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635165,0.0552914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223214,0.00691518) , 
3, 1.6882, 1, 0, 0.553792,-0.0747241) , 
1, 1.09547, 1, 0, 0.252903,-0.00253496)    );
  // itree = 116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0298507,-0.0646658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389903,0.0325875) , 
3, -1.17015, 1, 0, 0.294629,0.0331321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0560166,-0.0610265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502703,0.00655328) , 
3, 1.38144, 1, 0, 0.17991,-0.0650958) , 
1, 0.946985, 1, 0, 0.255044,-0.000762395)    );
  // itree = 117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531561,0.0397904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33758,0.00932073) , 
3, -1.11178, 1, 0, 0.400431,0.0464121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123126,-0.0243555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158273,0.0352559) , 
3, 1.79566, 1, 0, 0.127679,-0.0527502) , 
1, 0.327816, 1, 0, 0.254246,-0.00673533)    );
  // itree = 118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430894,0.0173059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00962407) , 
0, -0.980628, 1, 0, 0.359649,-0.053219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122592,-0.0310073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193548,0.0156676) , 
0, 0.713759, 1, 0, 0.15444,0.0454138) , 
3, -0.207485, 1, 0, 0.250513,-0.000763369)    );
  // itree = 119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0771144,-0.0344436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134132,-0.0230926) , 
3, -0.969901, 1, 0, 0.115602,0.0337489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590317,0.0438895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289474,0.00930854) , 
3, 1.5258, 1, 0, 0.523948,-0.0680618) , 
1, 0.87565, 1, 0, 0.261682,-0.00267246)    );
  // itree = 120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0593824,-0.0440024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433333,0.0387573) , 
3, -0.969901, 1, 0, 0.29889,0.0387139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508167,-0.0625993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462838,0.00756971) , 
3, 1.01188, 1, 0, 0.194805,-0.054097) , 
1, 0.606857, 1, 0, 0.255203,-0.000240886)    );
  // itree = 121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409195,0.00298874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263905,-0.00170838) , 
3, -0.982678, 1, 0, 0.313281,0.0342506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0728346,-0.041997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104938,-0.003261) , 
3, 1.3817, 1, 0, 0.080597,-0.0599731) , 
1, 0.939437, 1, 0, 0.233333,0.0018763)    );
  // itree = 122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229016,-0.0264253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447761,0.0769489) , 
2, 0.302572, 1, 0, 0.300558,-0.0217154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0893934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124105,-0.00301549) , 
2, 0.0641834, 1, 0, 0.0994264,0.0783622) , 
3, 0.766583, 1, 0, 0.246806,0.00502992)    );
  // itree = 123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199427,-0.0157916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283133,-0.00546236) , 
3, 0.15125, 1, 0, 0.231893,5.85867e-06) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.722689,0.163845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131148,-0.0264312) , 
3, 1.44357, 1, 0, 0.423237,-0.115837) , 
0, 1.31913, 1, 0, 0.255504,-0.0142892)    );
  // itree = 124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764263,-0.0357029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464467,0.0305517) , 
3, -0.110956, 1, 0, 0.254514,0.010125) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0343137,-0.0934134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.48855,-0.0273421) , 
3, 1.46609, 1, 0, 0.21194,-0.148425) , 
0, 1.17225, 1, 0, 0.247563,-0.0157591)    );
  // itree = 125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269461,0.00420153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117904,-0.0568556) , 
0, 1.22249, 1, 0, 0.251185,-0.0134481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620155,-0.0372626) , 
3, 1.76021, 1, 0, 0.239152,-0.00390325)    );
  // itree = 126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328671,0.0162939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14561,-0.0326566) , 
1, 1.04452, 1, 0, 0.270436,0.0331214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178899,-0.0108566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,0.00180741) , 
3, 1.8907, 1, 0, 0.165154,-0.0771992) , 
0, 0.807511, 1, 0, 0.241704,0.00301414)    );
  // itree = 127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0771177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317554,0.0303496) , 
0, -1.02834, 1, 0, 0.222982,-0.0490217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964467,-0.0313263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320225,-0.00663931) , 
1, 0.220205, 1, 0, 0.251558,0.0380691) , 
3, -0.529222, 1, 0, 0.241191,0.00647437)    );
  // itree = 128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205619,-0.00599617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0669856,-0.0837034) , 
2, 1.36291, 1, 0, 0.190223,-0.0293117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724138,0.0366588) , 
3, 1.74551, 1, 0, 0.228416,-0.019262)    );
  // itree = 129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.484663,0.0183323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0520296) , 
3, -1.40831, 1, 0, 0.349823,0.099411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25036,0.00841859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167539,-0.0202591) , 
0, 1.07931, 1, 0, 0.232506,-0.0242985) , 
0, -1.03387, 1, 0, 0.248662,-0.00726207)    );
  // itree = 130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256502,-0.00656938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268293,0.0167004) , 
1, 0.529246, 1, 0, 0.261499,-0.0140978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117117,0.00598077) , 
3, 1.90896, 1, 0, 0.253666,-0.00525085)    );
  // itree = 131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152815,0.00470291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169257,-0.0193584) , 
3, -1.17015, 1, 0, 0.165251,0.0231695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.717391,0.075506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356589,-0.0196049) , 
0, -0.043874, 1, 0, 0.506787,-0.0669029) , 
1, 1.26505, 1, 0, 0.241764,0.00299106)    );
  // itree = 132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258246,0.0188739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161017,-0.0437803) , 
0, 0.755351, 1, 0, 0.234054,0.00473193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.872549,0.0693861) , 
3, 1.90896, 1, 0, 0.266633,0.0146561)    );
  // itree = 133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454054,0.00773301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.0479741) , 
3, -1.30007, 1, 0, 0.323171,0.0973256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311199,0.0123201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118616,-0.0100926) , 
3, 0.592662, 1, 0, 0.238861,-0.0248354) , 
0, -0.880473, 1, 0, 0.253086,-0.00422391)    );
  // itree = 134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466135,0.0292157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205674,-0.032893) , 
3, -1.22633, 1, 0, 0.32833,0.0661271) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242249,0.00538672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0216251) , 
3, 1.93106, 1, 0, 0.229847,-0.0322155) , 
0, -0.605694, 1, 0, 0.255654,-0.00644527)    );
  // itree = 135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00471698,-0.0874362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570858,0.0358999) , 
1, 1.03062, 1, 0, 0.186419,0.018033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494413,0.0638091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583333,-0.0523481) , 
3, 1.67974, 1, 0, 0.384937,-0.0645808) , 
0, 0.893748, 1, 0, 0.232957,-0.00133401)    );
  // itree = 136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115007,-0.0150836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58042,0.0433597) , 
3, -0.173564, 1, 0, 0.289842,0.03269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00930233,-0.0782747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38565,-0.005807) , 
3, 0.487166, 1, 0, 0.200913,-0.0507407) , 
1, 0.583399, 1, 0, 0.251239,-0.0035267)    );
  // itree = 137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344507,0.00639037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139496,-0.000868155) , 
3, 0.176524, 1, 0, 0.27142,0.00654795) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16,-0.0333489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194175,0.0635551) , 
3, 1.67974, 1, 0, 0.169972,-0.0916007) , 
0, 1.13453, 1, 0, 0.253709,-0.0105868)    );
  // itree = 138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364384,0.0150618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0869565,-0.0345449) , 
3, 0.347004, 1, 0, 0.28827,0.00595015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0957447,-0.0522231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280822,0.0514212) , 
2, 0.598975, 1, 0, 0.189895,-0.0775497) , 
1, 1.14418, 1, 0, 0.261162,-0.0170594)    );
  // itree = 139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583756,-0.047089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148472,-0.0124359) , 
3, 0.346213, 1, 0, 0.0786627,0.0271226) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462585,0.014731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232143,-0.0110094) , 
3, 1.2106, 1, 0, 0.408759,-0.0412673) , 
1, 0.432021, 1, 0, 0.238866,-0.00606861)    );
  // itree = 140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127846,-0.014442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534783,0.0364721) , 
3, 0.388589, 1, 0, 0.244694,0.0126827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0736434,-0.0652795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.524096,-0.00869828) , 
3, 1.38144, 1, 0, 0.25,-0.0807277) , 
0, 0.990143, 1, 0, 0.245805,-0.00686615)    );
  // itree = 141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468531,0.0113956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272189,-0.0114952) , 
3, -1.6809, 1, 0, 0.362179,0.105738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311721,0.00571285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154664,0.00585972) , 
3, 0.190584, 1, 0, 0.231049,-0.0125345) , 
0, -0.940853, 1, 0, 0.251912,0.00628293)    );
  // itree = 142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320536,0.00900187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252149,-0.000493561) , 
0, 0.568731, 1, 0, 0.304289,-0.0291461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.046986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156463,0.0156785) , 
0, 1.20559, 1, 0, 0.0917431,0.0888755) , 
3, 0.873167, 1, 0, 0.255643,-0.0021343)    );
  // itree = 143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0789628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.100081) , 
1, -0.599032, 1, 0, 0,0.121336) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28393,0.00679794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315978,0.0131857) , 
3, 0.711611, 1, 0, 0.294084,-0.0174713) , 
0, -1.2003, 1, 0, 0.263372,-0.00297537)    );
  // itree = 144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310078,-0.0614523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.517857,0.207269) , 
3, -1.63983, 1, 0, 0.257261,0.120841) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117705,-0.0226328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502841,0.019746) , 
3, 0.422349, 1, 0, 0.275802,0.00180134) , 
0, -1.08588, 1, 0, 0.273517,0.0164682)    );
  // itree = 145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327146,0.0155866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198847,-0.0191902) , 
0, 0.719916, 1, 0, 0.3,-0.0274207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.083682,-0.0263227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,0.00687425) , 
3, 1.89385, 1, 0, 0.0932945,0.0485402) , 
3, 1.30934, 1, 0, 0.264246,-0.0142818)    );
  // itree = 146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380107,0.00719593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178187,-0.0186433) , 
3, -0.660474, 1, 0, 0.271829,0.0449075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190252,-0.0104077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0733945,-0.0243117) , 
3, 1.81124, 1, 0, 0.173154,-0.0458685) , 
0, 0.353094, 1, 0, 0.234303,0.0103858)    );
  // itree = 147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143774,-0.0304403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420952,0.0512154) , 
0, -0.0256029, 1, 0, 0.255368,-0.0309069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156863,-0.012935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366947,-0.00928652) , 
1, 1.00788, 1, 0, 0.261905,0.0480462) , 
3, 0.413581, 1, 0, 0.257681,-0.00297204)    );
  // itree = 148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123366,-0.0174171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510949,0.0248257) , 
3, 0.433464, 1, 0, 0.243228,0.00255947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145631,-0.0755345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325397,-0.029445) , 
1, 0.349195, 1, 0, 0.244541,-0.110265) , 
0, 1.31913, 1, 0, 0.243378,-0.0103525)    );
  // itree = 149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433846,0.0144802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24936,0.00692383) , 
3, -1.20425, 1, 0, 0.289439,0.0152012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223844,0.00148511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135593,0.0124016) , 
3, 1.64518, 1, 0, 0.204159,-0.0650238) , 
0, 0.823264, 1, 0, 0.267161,-0.00575635)    );
  // itree = 150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444444,0.0258779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326861,-0.00335753) , 
3, -1.66881, 1, 0, 0.378623,-0.0609374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149068,-0.0530143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213953,0.00597083) , 
0, -0.743164, 1, 0, 0.206754,0.0152002) , 
3, -0.931712, 1, 0, 0.254119,-0.0057823)    );
  // itree = 151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0298507,-0.0511853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405263,0.0775959) , 
3, -1.84758, 1, 0, 0.25,-0.0768451) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0508475,-0.0691455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257458,-0.00526764) , 
0, -0.941517, 1, 0, 0.242771,0.0113922) , 
3, -1.33958, 1, 0, 0.243952,-0.00301749)    );
  // itree = 152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241843,0.00579687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0567686,-0.0777465) , 
0, 1.08526, 1, 0, 0.218192,-0.00860234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.770833,0.0388931) , 
3, 1.73078, 1, 0, 0.271673,0.00293197)    );
  // itree = 153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377297,0.00702448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129897,-0.0160344) , 
1, 0.302097, 1, 0, 0.25066,-0.012566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.00580297) , 
3, 1.90896, 1, 0, 0.242394,-0.00356839)    );
  // itree = 154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376368,0.00717388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.0342693) , 
3, -0.648085, 1, 0, 0.254218,0.0406777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0646766,-0.0718609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271773,0.0272428) , 
2, -0.505266, 1, 0, 0.235702,-0.029258) , 
1, 0.227361, 1, 0, 0.243759,0.00117411)    );
  // itree = 155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00740741,-0.0718857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927152,-0.0164513) , 
3, -1.35444, 1, 0, 0.0524476,0.106258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292279,0.00424228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0851084) , 
3, 1.93456, 1, 0, 0.274611,-0.0125542) , 
1, -0.840753, 1, 0, 0.243203,0.00424278)    );
  // itree = 156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533333,-0.0406085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553398,0.137569) , 
3, -1.42376, 1, 0, 0.256917,0.094589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148754,-0.0268506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554545,0.0144496) , 
3, 0.97184, 1, 0, 0.25232,-0.0243958) , 
0, -1.03387, 1, 0, 0.252908,-0.00916913)    );
  // itree = 157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357364,0.00500344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0847458,-0.0294297) , 
1, 0.892141, 1, 0, 0.268191,0.0218281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225,-0.00923333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119565,-0.00415671) , 
3, 1.38165, 1, 0, 0.189338,-0.0691922) , 
0, 0.759972, 1, 0, 0.246603,-0.00309138)    );
  // itree = 158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.0161562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115207,-0.0513772) , 
3, -1.05696, 1, 0, 0.217978,0.0628569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468468,0.0256459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235374,0.00875859) , 
0, -1.08588, 1, 0, 0.251739,-0.021057) , 
1, -0.512249, 1, 0, 0.244324,-0.00262573)    );
  // itree = 159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00423729,-0.0802154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30574,0.0174799) , 
0, -1.09728, 1, 0, 0.243433,-0.0327949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217899,-0.00297168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413889,0.0050766) , 
1, 1.20213, 1, 0, 0.298627,0.0235722) , 
3, 0.15517, 1, 0, 0.267361,-0.00835799)    );
  // itree = 160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105163,-0.0112307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52514,0.0553914) , 
3, -0.442236, 1, 0, 0.275823,0.0507017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.0335966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.783784,0.0387932) , 
3, 1.85051, 1, 0, 0.217631,-0.0428894) , 
1, 0.185608, 1, 0, 0.243655,-0.00103466)    );
  // itree = 161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636364,0.0496924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350649,-0.00791154) , 
3, -1.47095, 1, 0, 0.493506,0.109294) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228358,0.000631093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161765,-0.0120415) , 
0, 1.15958, 1, 0, 0.214881,-0.0284698) , 
1, -0.840753, 1, 0, 0.258048,-0.00712613)    );
  // itree = 162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178261,-0.0577145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507375,0.0509267) , 
2, -1.00216, 1, 0, 0.374341,-0.0577147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154,-0.0254084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247225,0.020166) , 
1, 0.158753, 1, 0, 0.215962,0.0355039) , 
3, -0.900958, 1, 0, 0.259709,0.00975565)    );
  // itree = 163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.059375,-0.0262513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106306,-0.0241469) , 
3, -1.10455, 1, 0, 0.0891429,0.0378608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394762,0.0087393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0837992) , 
3, 1.97658, 1, 0, 0.357018,-0.0439334) , 
1, 0.204761, 1, 0, 0.240695,-0.00841484)    );
  // itree = 164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306379,0.0238223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147766,-0.0293608) , 
1, 0.943531, 1, 0, 0.251917,0.014423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0519481,-0.0857612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644231,-0.0130128) , 
3, 1.64535, 1, 0, 0.290698,-0.115666) , 
0, 1.31913, 1, 0, 0.25704,-0.00276243)    );
  // itree = 165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366239,0.0104761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.08,-0.0264646) , 
1, 1.10729, 1, 0, 0.285209,0.0249231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215054,-0.00814103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119403,0.00656386) , 
3, 1.64518, 1, 0, 0.193656,-0.0707877) , 
0, 0.740359, 1, 0, 0.257952,-0.00357135)    );
  // itree = 166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45509,0.0309532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195704,-0.0101388) , 
3, -0.847455, 1, 0, 0.292756,0.0124112) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216312,0.00079344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648148,-0.0306581) , 
3, 1.97769, 1, 0, 0.191964,-0.0654743) , 
0, 0.556597, 1, 0, 0.259075,-0.0136152)    );
  // itree = 167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155351,-0.0218402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246599,-0.0175447) , 
3, -0.0905164, 1, 0, 0.192176,0.0273054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536517,0.060916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141176,-0.0137592) , 
3, 1.37265, 1, 0, 0.408745,-0.060904) , 
0, 0.823264, 1, 0, 0.249622,0.00390744)    );
  // itree = 168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0386905,-0.0516269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401015,0.0384921) , 
3, -1.11178, 1, 0, 0.269687,0.0347299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0504673,-0.052828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415771,0.00126719) , 
3, 0.438936, 1, 0, 0.236962,-0.0304245) , 
1, 0.222196, 1, 0, 0.25198,-0.00052444)    );
  // itree = 169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290574,0.00631009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212476,0.00166532) , 
0, 0.653609, 1, 0, 0.269751,-0.0122655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.0140989) , 
3, 2.00929, 1, 0, 0.260227,-0.00388092)    );
  // itree = 170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437209,0.0120814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190114,-0.0432547) , 
3, -1.341, 1, 0, 0.301255,0.0632349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239706,0.00369827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853659,-0.0101393) , 
3, 1.76043, 1, 0, 0.223097,-0.0212969) , 
0, -0.69773, 1, 0, 0.241758,-0.00111397)    );
  // itree = 171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0953307,-0.0292713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24594,-0.0139194) , 
3, -0.671955, 1, 0, 0.164021,0.0407866) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347193,0.0120668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0826475) , 
3, 1.97769, 1, 0, 0.311858,-0.0352726) , 
0, -0.0254439, 1, 0, 0.24256,0.000380164)    );
  // itree = 172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100299,-0.0192279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587699,0.0409111) , 
3, -0.226556, 1, 0, 0.293586,0.0286073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111717,-0.0364707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712121,0.0231888) , 
3, 1.74087, 1, 0, 0.203233,-0.0385994) , 
1, 0.568008, 1, 0, 0.253928,-0.000891422)    );
  // itree = 173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572327,0.029911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291469,-0.00651417) , 
1, -1.07897, 1, 0, 0.335992,-0.0335181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797721,-0.0382666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201562,0.0205546) , 
0, 0.180334, 1, 0, 0.158426,0.0272916) , 
3, -0.0727496, 1, 0, 0.247743,-0.00329625)    );
  // itree = 174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344358,0.0175736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178571,-0.0157482) , 
1, 1.05254, 1, 0, 0.291888,0.0261479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170588,-0.0239465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141463,0.010076) , 
3, 1.3079, 1, 0, 0.159633,-0.0641629) , 
0, 0.823264, 1, 0, 0.256711,0.00212677)    );
  // itree = 175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173438,-0.0015781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215247,-0.0256239) , 
3, -0.595038, 1, 0, 0.197781,0.0118403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.534954,0.0510806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100775,-0.0225142) , 
3, 1.59932, 1, 0, 0.412664,-0.0728966) , 
0, 0.896613, 1, 0, 0.247236,-0.00766198)    );
  // itree = 176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,0.0323513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127273,-0.0393785) , 
1, 1.17822, 1, 0, 0.258187,0.0250844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.045,-0.0713143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542969,0.00632343) , 
3, 1.01643, 1, 0, 0.239329,-0.0571961) , 
0, 0.563554, 1, 0, 0.251905,-0.00232852)    );
  // itree = 177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371429,-0.0110654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294063,-0.000798454) , 
0, -1.17805, 1, 0, 0.306677,-0.0202048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0430943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188482,0.0272906) , 
0, 0.594885, 1, 0, 0.12828,0.0478347) , 
3, 0.436997, 1, 0, 0.244681,0.00344014)    );
  // itree = 178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396419,0.0157795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780488,-0.0490802) , 
3, -0.121431, 1, 0, 0.286913,0.0241005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24918,0.00894838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.093617,-0.0188691) , 
3, 1.31588, 1, 0, 0.205917,-0.0477144) , 
0, 0.287957, 1, 0, 0.253314,-0.00569017)    );
  // itree = 179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,-0.037187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0912863,-0.0301526) , 
3, -1.03625, 1, 0, 0.0734177,0.0573114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445583,0.0203052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285347,0.000654167) , 
3, 0.895411, 1, 0, 0.392308,-0.0249864) , 
1, 0.0944271, 1, 0, 0.263775,0.00818462)    );
  // itree = 180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136774,-0.00612141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555785,0.0329241) , 
3, 0.0100223, 1, 0, 0.297855,0.0280878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0135747,-0.0825089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275626,-0.00739873) , 
2, 0.0478907, 1, 0, 0.187879,-0.0450994) , 
1, 0.927816, 1, 0, 0.260031,0.00291662)    );
  // itree = 181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289941,0.00843427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204678,-0.000364429) , 
0, 0.722623, 1, 0, 0.266488,-0.0186447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761905,-0.0246005) , 
3, 1.90896, 1, 0, 0.256345,-0.00900234)    );
  // itree = 182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356742,-0.00660193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15942,-0.0263945) , 
3, -1.06128, 1, 0, 0.236784,0.0383789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0569106,-0.0775559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305718,0.0359555) , 
2, -0.321337, 1, 0, 0.250227,-0.0354672) , 
1, 0.223549, 1, 0, 0.244157,-0.00212447)    );
  // itree = 183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154709,-0.0224253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27957,-0.0111786) , 
3, -0.0708865, 1, 0, 0.202759,0.014307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542751,0.0541735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175439,-0.000984822) , 
3, 1.32658, 1, 0, 0.4,-0.0699999) , 
0, 0.897583, 1, 0, 0.248677,-0.00531997)    );
  // itree = 184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0643564,-0.0285908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552381,0.128486) , 
3, -1.29168, 1, 0, 0.23127,0.0769737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1643,-0.0212071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634483,0.0260648) , 
3, 1.37713, 1, 0, 0.241379,-0.0181215) , 
0, -1.03521, 1, 0, 0.239884,-0.00405874)    );
  // itree = 185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543307,0.0240674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294972,-0.00657607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185484,0.018229) , 
3, -0.0592526, 1, 0, 0.237414,-0.0174923) , 
1, -1.22512, 1, 0, 0.256703,-0.00851925)    );
  // itree = 186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27897,-0.0163786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388949,0.0203788) , 
1, -0.958684, 1, 0, 0.366782,-0.0226555) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120594,-0.0179878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182796,0.0192598) , 
0, 0.828056, 1, 0, 0.145993,0.0453133) , 
3, 0.127977, 1, 0, 0.269473,0.00730077)    );
  // itree = 187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0143885,-0.0637434) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0876925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274928,-0.00247826) , 
0, -1.30211, 1, 0, 0.255901,-0.015838) , 
1, -1.19679, 1, 0, 0.239141,-0.00613736)    );
  // itree = 188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0944882,-0.0194914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537931,0.0310001) , 
3, -0.312713, 1, 0, 0.274766,0.0181415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0924855,-0.0547337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262561,-0.00638935) , 
0, -0.164472, 1, 0, 0.201454,-0.0393735) , 
1, 0.497684, 1, 0, 0.240039,-0.00910243)    );
  // itree = 189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389299,0.0017495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190657,-0.00345113) , 
3, -0.806856, 1, 0, 0.271364,0.0228808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254973,0.0108475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0272053) , 
3, 1.59951, 1, 0, 0.217021,-0.0466541) , 
0, 0.512761, 1, 0, 0.252575,-0.00116145)    );
  // itree = 190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315628,0.00270548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0221557) , 
1, 1.07565, 1, 0, 0.27181,0.0137492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212766,0.00114757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0844156,-0.0193247) , 
3, 1.59928, 1, 0, 0.183308,-0.0582739) , 
0, 0.596152, 1, 0, 0.242954,-0.00973354)    );
  // itree = 191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165992,-0.0151476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274619,-0.00858875) , 
3, -0.0441959, 1, 0, 0.21182,0.0170695) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.628272,0.076253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,-0.00163821) , 
3, 1.38165, 1, 0, 0.468227,-0.0792126) , 
0, 1.17201, 1, 0, 0.25,0.00273268)    );
  // itree = 192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875332,-0.0186346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493994,0.0307943) , 
3, -0.283561, 1, 0, 0.278169,0.0239613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00699301,-0.0860917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241294,-0.022997) , 
2, -0.215342, 1, 0, 0.179817,-0.0601478) , 
1, 1.2054, 1, 0, 0.250891,0.000633306)    );
  // itree = 193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519231,0.0177318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.045301) , 
3, -1.51166, 1, 0, 0.379845,0.0869214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324138,0.00446338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175556,0.0178847) , 
3, 0.1091, 1, 0, 0.248588,-0.0200192) , 
0, -1.09189, 1, 0, 0.265286,-0.00641432)    );
  // itree = 194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366864,-0.00101846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163079,-0.022368) , 
3, -0.969901, 1, 0, 0.223324,0.0118097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468085,0.104963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183486,0.0563757) , 
3, 1.37466, 1, 0, 0.344,-0.0888239) , 
2, 1.42243, 1, 0, 0.238677,-0.000993588)    );
  // itree = 195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161359,-0.0154391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276498,-0.00584894) , 
3, -0.0913266, 1, 0, 0.208412,0.014794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479714,0.0464294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.0645014) , 
0, 1.54935, 1, 0, 0.399621,-0.0666395) , 
0, 0.823646, 1, 0, 0.256011,-0.00547802)    );
  // itree = 196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0159236,-0.0678449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00917431,-0.0593435) , 
0, -0.275225, 1, 0, 0.0141844,-0.0600765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396226,0.0616937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293056,-0.00232788) , 
0, -0.76779, 1, 0, 0.303315,0.00922726) , 
3, -1.10169, 1, 0, 0.242829,-0.005271)    );
  // itree = 197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3674,0.000440045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123558,-0.0225159) , 
3, -0.212198, 1, 0, 0.260145,0.02344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269841,0.0128353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121457,-0.00289739) , 
3, 1.08333, 1, 0, 0.2112,-0.0626521) , 
0, 0.676581, 1, 0, 0.244888,-0.00339671)    );
  // itree = 198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502857,0.0287879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174757,-0.0578106) , 
3, -1.51166, 1, 0, 0.381295,0.0861983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311992,0.00704673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152742,0.0110976) , 
3, 0.381995, 1, 0, 0.242286,-0.0172959) , 
0, -1.03521, 1, 0, 0.261341,-0.0031088)    );
  // itree = 199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902439,-0.0221043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354515,0.0334343) , 
0, -0.671528, 1, 0, 0.247024,-0.0229137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273292,-0.0145741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244838,-0.0214239) , 
0, 0.901351, 1, 0, 0.263479,0.0528573) , 
3, -0.0727496, 1, 0, 0.255148,0.0144961)    );
  // itree = 200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482759,-0.0335669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59596,0.125167) , 
3, -1.51166, 1, 0, 0.270492,0.102229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115617,-0.0323114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51,0.00894708) , 
3, 0.784651, 1, 0, 0.234479,-0.025526) , 
0, -1.08926, 1, 0, 0.239096,-0.00914553)    );
  // itree = 201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475904,0.00148785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282209,-0.00616227) , 
3, -1.64337, 1, 0, 0.379939,0.0851037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336406,0.00559066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170594,0.00524619) , 
3, -0.192289, 1, 0, 0.233645,-0.00829904) , 
0, -0.940853, 1, 0, 0.257227,0.00675705)    );
  // itree = 202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377622,0.0106498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122241,-0.0157507) , 
3, -0.0325813, 1, 0, 0.27367,0.0326249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00641026,-0.0893952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250509,0.0207451) , 
2, -0.395212, 1, 0, 0.191654,-0.0548057) , 
1, 1.03517, 1, 0, 0.248329,0.00561077)    );
  // itree = 203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160584,-0.0154535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.0157995) , 
0, 0.155609, 1, 0, 0.233677,-0.0232971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305755,0.0151017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236364,-0.0074468) , 
0, 0.860642, 1, 0, 0.271248,0.0611181) , 
3, 0.744587, 1, 0, 0.244024,-4.9313e-05)    );
  // itree = 204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310559,-0.0519502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454545,0.0892886) , 
3, -1.37897, 1, 0, 0.27027,0.0850671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302469,0.0512734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251813,-0.00776825) , 
0, -1.00818, 1, 0, 0.2567,-0.00410641) , 
1, -0.71469, 1, 0, 0.259151,0.0119962)    );
  // itree = 205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367368,0.00662761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0850202,-0.028651) , 
1, 0.882344, 1, 0, 0.270776,0.0242826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18863,-0.0170633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123596,0.00137234) , 
3, 1.38144, 1, 0, 0.168142,-0.0443187) , 
0, 0.759972, 1, 0, 0.241911,0.00498956)    );
  // itree = 206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329528,0.00956826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056701,-0.0472944) , 
3, 0.659622, 1, 0, 0.267333,0.013012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136564,-0.028658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242718,0.0536235) , 
0, 1.57324, 1, 0, 0.169697,-0.0740418) , 
0, 1.17201, 1, 0, 0.251476,-0.00112569)    );
  // itree = 207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373444,-0.0362796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0470026) , 
3, -1.03007, 1, 0, 0.0487329,0.0724706) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348901,0.0189153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267176,-0.0145781) , 
3, 0.205652, 1, 0, 0.306473,-0.0224015) , 
1, -0.399001, 1, 0, 0.241243,0.00160907)    );
  // itree = 208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.09375,-0.0102452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443038,0.0310047) , 
3, -0.45652, 1, 0, 0.278447,0.0333789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.04947,-0.0646277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556075,0.00585185) , 
3, 1.08333, 1, 0, 0.267606,-0.0438911) , 
0, 0.823264, 1, 0, 0.275741,0.0140905)    );
  // itree = 209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39834,-0.00318102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181677,-0.0119389) , 
3, -0.860117, 1, 0, 0.274423,0.0257487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250896,0.0026353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.00840865) , 
3, 1.10033, 1, 0, 0.20331,-0.0432828) , 
0, 0.271819, 1, 0, 0.243915,-0.00386619)    );
  // itree = 210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380109,0.00550044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145833,-0.0200872) , 
3, -0.367494, 1, 0, 0.277099,0.0140692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2713,0.0218944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152416,0.0170603) , 
3, 1.08333, 1, 0, 0.226573,-0.0566935) , 
0, 0.474519, 1, 0, 0.259259,-0.0109162)    );
  // itree = 211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16118,-0.00908802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265597,-0.0178529) , 
3, -0.0913266, 1, 0, 0.201803,0.0184847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531034,0.0463842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,-0.0260325) , 
3, 1.08757, 1, 0, 0.368217,-0.0499719) , 
0, 0.759972, 1, 0, 0.245659,0.000444073)    );
  // itree = 212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125613,-0.0104477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487226,0.025265) , 
3, 0.148182, 1, 0, 0.252074,0.0127105) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,-0.0518871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736842,0.0123757) , 
3, 1.67978, 1, 0, 0.268456,-0.0575798) , 
0, 0.93821, 1, 0, 0.25571,-0.00289018)    );
  // itree = 213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392544,-0.00313327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156888,-0.024169) , 
3, -0.984945, 1, 0, 0.243548,0.0306463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216216,0.00954717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161572,-0.00987132) , 
0, 1.32374, 1, 0, 0.200255,-0.0557238) , 
0, 0.353094, 1, 0, 0.226779,-0.00280928)    );
  // itree = 214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294521,-0.0127819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0426357,-0.0630431) , 
3, -0.0230076, 1, 0, 0.201149,0.0163745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446316,0.0913619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0509554,-0.0435351) , 
3, 1.68403, 1, 0, 0.348101,-0.0449493) , 
2, 0.68168, 1, 0, 0.247036,-0.00277407)    );
  // itree = 215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0885653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102941,-0.0141776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327988,0.00646475) , 
1, -0.352835, 1, 0, 0.276405,-0.0207075) , 
0, -1.26434, 1, 0, 0.250765,-0.0102116)    );
  // itree = 216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0786325,-0.0165376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416045,0.0370781) , 
3, -0.730312, 1, 0, 0.239964,0.03113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109121,-0.0454424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.574394,0.0142602) , 
3, 1.01644, 1, 0, 0.258029,-0.0347942) , 
0, 0.130486, 1, 0, 0.248024,0.00171815)    );
  // itree = 217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376022,0.00621461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121339,-0.0173384) , 
3, -0.311466, 1, 0, 0.275578,0.0173938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260692,0.00691201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0912162,-0.0197099) , 
3, 1.08337, 1, 0, 0.19695,-0.0452677) , 
0, 0.353094, 1, 0, 0.244622,-0.00727581)    );
  // itree = 218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298246,-0.00645863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290672,0.00402439) , 
1, 0.174878, 1, 0, 0.294859,0.0121131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248399,0.0190624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.026087,-0.0625592) , 
3, 1.85129, 1, 0, 0.219866,-0.0559057) , 
0, 0.133846, 1, 0, 0.25999,-0.0195137)    );
  // itree = 219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0817098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349693,0.0557869) , 
0, 0.592869, 1, 0, 0.0741222,0.0190195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394589,0.00808134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0173751) , 
3, 1.05611, 1, 0, 0.36,-0.0484872) , 
1, -0.0220085, 1, 0, 0.249749,-0.0224528)    );
  // itree = 220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0559702,-0.0322292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435294,0.0593322) , 
3, -1.03488, 1, 0, 0.240918,0.0482042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0388979,-0.0531255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407449,0.00365467) , 
3, -0.0518645, 1, 0, 0.256154,-0.0171803) , 
1, -0.409525, 1, 0, 0.252221,-0.000301712)    );
  // itree = 221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355422,0.0107786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0822581,-0.0250921) , 
1, 0.940842, 1, 0, 0.260382,-0.00247562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0232057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165049,0.00915969) , 
2, 1.00933, 1, 0, 0.165854,-0.111509) , 
0, 1.35023, 1, 0, 0.250629,-0.0137247)    );
  // itree = 222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00381319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109034,-0.0190257) , 
3, 0.304231, 1, 0, 0.254256,0.0200252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190789,0.0124987) , 
0, 1.43206, 1, 0, 0.249366,0.00891986)    );
  // itree = 223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0640569,-0.0272948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130573,-0.00933439) , 
3, -0.314926, 1, 0, 0.0878995,0.0362713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399696,0.00482392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301339,0.00444291) , 
3, 0.761907, 1, 0, 0.359855,-0.0266788) , 
1, 0.149288, 1, 0, 0.239657,0.00114378)    );
  // itree = 224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584192,-0.0257897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431884,0.0438612) , 
3, -1.01241, 1, 0, 0.261006,0.0437261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316703,-0.00242864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173256,-0.0335488) , 
1, 0.641282, 1, 0, 0.223316,-0.0377967) , 
1, -0.148119, 1, 0, 0.235565,-0.0113028)    );
  // itree = 225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524476,0.010902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291332,0.00367259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101351,-0.00804533) , 
1, 1.07099, 1, 0, 0.230141,-0.00689854) , 
1, -1.26103, 1, 0, 0.251388,0.00192618)    );
  // itree = 226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285,-0.0355841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271901,0.00889225) , 
0, -1.16672, 1, 0, 0.273759,0.0354792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167832,-0.048715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195704,0.017617) , 
3, -0.263553, 1, 0, 0.188612,-0.0718685) , 
1, 1.10729, 1, 0, 0.249493,0.00488618)    );
  // itree = 227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0277778,-0.0731015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677033,0.0604491) , 
1, 1.19904, 1, 0, 0.204694,0.0189846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529248,0.0376594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535714,-0.035952) , 
3, 1.67974, 1, 0, 0.416136,-0.0626427) , 
0, 0.893748, 1, 0, 0.254364,-0.000190651)    );
  // itree = 228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210526,0.0856127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304762,0.0511754) , 
0, -1.54057, 1, 0, 0.255708,0.0955714) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994318,-0.025256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479508,0.0176912) , 
3, 0.321796, 1, 0, 0.255034,-0.00132734) , 
0, -1.12051, 1, 0, 0.255107,0.00924606)    );
  // itree = 229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384701,0.00680423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126095,-0.00367375) , 
1, 0.5496, 1, 0, 0.284453,0.0114983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264808,0.00577293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133065,0.00804671) , 
1, 0.703866, 1, 0, 0.203738,-0.0616494) , 
0, 0.759972, 1, 0, 0.262948,-0.00799072)    );
  // itree = 230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428309,0.0144081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180151,-0.0155532) , 
3, -0.806856, 1, 0, 0.271924,0.00710072) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150442,-0.0152171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206897,0.017583) , 
1, 0.877544, 1, 0, 0.171587,-0.053193) , 
0, 0.731558, 1, 0, 0.244908,-0.00913336)    );
  // itree = 231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0811352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276196,0.00623539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2625,0.00124098) , 
0, 1.47856, 1, 0, 0.275052,-0.0204278) , 
1, -1.31752, 1, 0, 0.257828,-0.012425)    );
  // itree = 232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274272,0.0207923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202434,-0.0158372) , 
1, 0.302097, 1, 0, 0.23669,0.00347335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0719697,-0.0649383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.678899,-0.00293459) , 
3, 1.70582, 1, 0, 0.24933,-0.0727915) , 
0, 1.13453, 1, 0, 0.238934,-0.0100663)    );
  // itree = 233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463108,0.0199656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169888,0.000604323) , 
1, -0.0220085, 1, 0, 0.285185,0.00396731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970874,-0.065606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201031,0.0353928) , 
3, 0.473579, 1, 0, 0.164983,-0.12959) , 
0, 1.17201, 1, 0, 0.266562,-0.0167247)    );
  // itree = 234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357143,-0.00689794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.043875) , 
3, -0.833228, 1, 0, 0.224368,0.0544163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266831,0.0132245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686275,-0.0217868) , 
3, 1.93593, 1, 0, 0.251515,-0.0197177) , 
1, -0.0851305, 1, 0, 0.242348,0.00531605)    );
  // itree = 235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0353535,-0.0194006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0546875,-0.0442568) , 
3, -1.1783, 1, 0, 0.0462555,0.0597818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30605,0.000946008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25886,-0.0147078) , 
3, 0.422986, 1, 0, 0.285523,-0.0181137) , 
1, -0.469325, 1, 0, 0.229702,5.92525e-05)    );
  // itree = 236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853485,-0.015833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455338,0.0278472) , 
3, -0.291836, 1, 0, 0.231497,0.0160129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0565302,-0.0630623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507092,-0.000910039) , 
3, 1.01644, 1, 0, 0.216352,-0.0540877) , 
0, 0.295952, 1, 0, 0.225345,-0.0124643)    );
  // itree = 237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397516,0.000668556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123077,-0.0169305) , 
3, -0.415035, 1, 0, 0.283894,0.018311) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.000591242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10177,-0.0117322) , 
3, 1.30808, 1, 0, 0.19695,-0.0431404) , 
0, 0.2269, 1, 0, 0.247614,-0.00733174)    );
  // itree = 238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307087,-0.0150436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.044455) , 
3, -1.3992, 1, 0, 0.225108,0.0767584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.525,0.0332264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232121,0.0018842) , 
0, -1.2692, 1, 0, 0.251977,-0.0214044) , 
1, -0.9788, 1, 0, 0.248876,-0.0100722)    );
  // itree = 239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0133333,-0.0494959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0723684,-0.0106926) , 
3, -1.44854, 1, 0, 0.0430464,0.0837382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28385,0.000438194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,-0.00221012) , 
3, 0.802894, 1, 0, 0.281069,-0.0115571) , 
1, -0.843018, 1, 0, 0.245553,0.0026619)    );
  // itree = 240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245522,0.0023253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164234,-0.0367683) , 
0, 0.653609, 1, 0, 0.221928,-0.0152419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0566056) , 
3, 1.90896, 1, 0, 0.25503,-0.007359)    );
  // itree = 241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327684,-0.0291739) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254723,0.00347033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165242,-0.00969563) , 
0, 1.12715, 1, 0, 0.23807,-0.00871058) , 
0, -1.37002, 1, 0, 0.245759,3.65085e-05)    );
  // itree = 242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338742,0.0045241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.073107,-0.0360613) , 
3, 0.344827, 1, 0, 0.264427,0.0223563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0129032,-0.086256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260341,0.021294) , 
2, -0.0959103, 1, 0, 0.19258,-0.0390166) , 
1, 1.05254, 1, 0, 0.243411,0.00440434)    );
  // itree = 243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0133883,-0.0734223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.590909,0.10346) , 
0, 1.16887, 1, 0, 0.111206,0.0340106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.825095,0.0921233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335727,-0.0153865) , 
2, 0.0462786, 1, 0, 0.492683,-0.0303411) , 
1, 0.634693, 1, 0, 0.268477,0.00748046)    );
  // itree = 244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243902,0.057752) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185022,0.012422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270096,-0.0160689) , 
0, -0.571715, 1, 0, 0.24735,-0.0170794) , 
1, -1.15023, 1, 0, 0.247046,-0.00800589)    );
  // itree = 245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585034,0.0288182) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228876,-0.00624748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175492,-0.0062236) , 
0, 0.646842, 1, 0, 0.210106,-0.0123554) , 
1, -1.19679, 1, 0, 0.237296,-0.00377991)    );
  // itree = 246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419512,0.0146951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1175,-0.0323374) , 
3, -0.415035, 1, 0, 0.300493,0.0334258) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242718,0.0161245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0672269,-0.0201553) , 
3, 1.89091, 1, 0, 0.220573,-0.0342257) , 
0, 0.125775, 1, 0, 0.262002,0.000843876)    );
  // itree = 247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0214286,-0.0269673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0580645,-0.0307121) , 
3, -1.54783, 1, 0, 0.040678,0.0844732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291475,0.016035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255754,-0.0228654) , 
3, 0.109967, 1, 0, 0.274545,-0.0129195) , 
1, -0.840753, 1, 0, 0.239075,0.00185217)    );
  // itree = 248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284404,0.0118994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158654,-0.0278549) , 
1, 0.939437, 1, 0, 0.238623,-0.00187724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0194175,-0.0707876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0501657) , 
3, 1.07865, 1, 0, 0.211538,-0.102156) , 
0, 1.35023, 1, 0, 0.235692,-0.0127295)    );
  // itree = 249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3311,-0.000150673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.075188,-0.0252995) , 
3, 0.299345, 1, 0, 0.260388,0.0261425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21564,0.00120407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12844,0.0179) , 
3, 1.64522, 1, 0, 0.19774,-0.0489737) , 
0, 0.676581, 1, 0, 0.243544,0.00594667)    );
  // itree = 250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282624,-0.00339871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283286,-0.0642952) , 
3, 0.844707, 1, 0, 0.232363,-0.00195128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425926,0.0593467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221154,0.0724362) , 
3, 1.37466, 1, 0, 0.325472,-0.0736104) , 
2, 1.52497, 1, 0, 0.242242,-0.00955475)    );
  // itree = 251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0189394,-0.062683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262811,-0.00617657) , 
0, -1.01475, 1, 0, 0.223313,0.000982101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452555,0.0315018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311927,0.00898101) , 
2, 1.49723, 1, 0, 0.412533,-0.0672416) , 
0, 1.07303, 1, 0, 0.259314,-0.0119984)    );
  // itree = 252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170732,0.0290847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0513766) , 
0, -1.27045, 1, 0, 0.0659841,-0.0361066) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42043,0.0168041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326087,-0.0390413) , 
0, 1.36275, 1, 0, 0.404847,0.0178145) , 
3, -0.182234, 1, 0, 0.255394,-0.00596705)    );
  // itree = 253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54,0.00665666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407407,0.00685982) , 
3, -1.69193, 1, 0, 0.449367,0.0565742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245679,-0.00325853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132,0.00425479) , 
3, 0.259739, 1, 0, 0.191026,-0.0184623) , 
1, -0.484715, 1, 0, 0.251229,-0.000975939)    );
  // itree = 254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437008,0.00494904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232727,-0.0248439) , 
3, -1.33948, 1, 0, 0.330813,0.0620127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281544,0.00758212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0886792,-0.0244478) , 
3, 0.764093, 1, 0, 0.217337,0.00184937) , 
0, -0.69773, 1, 0, 0.245639,0.0168547)    );
  // itree = 255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0765625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0979943) , 
2, -0.786685, 1, 0, 0,0.0958312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293027,0.00451651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263291,0.00330903) , 
3, 1.03516, 1, 0, 0.286288,-0.00854972) , 
0, -1.15327, 1, 0, 0.256819,0.00219459)    );
  // itree = 256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0216718,-0.0591685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428037,0.0358188) , 
3, -1.03039, 1, 0, 0.275058,0.0294101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0265957,-0.0615714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405797,0.000174953) , 
3, 0.363173, 1, 0, 0.214158,-0.0270415) , 
1, 0.227361, 1, 0, 0.240628,-0.00250479)    );
  // itree = 257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.634615,0.0299628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405405,0.000439266) , 
3, -1.30795, 1, 0, 0.516279,0.101409) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258545,-0.0032974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131537,0.00914405) , 
3, 0.57414, 1, 0, 0.213318,-0.00658688) , 
1, -0.95459, 1, 0, 0.2461,0.00509858)    );
  // itree = 258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335385,0.0120247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0564972,-0.0409171) , 
3, 0.765832, 1, 0, 0.275695,0.020549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207547,0.0119638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120536,-0.0288697) , 
0, 1.32584, 1, 0, 0.148485,-0.0610032) , 
0, 1.11463, 1, 0, 0.254536,0.00698437)    );
  // itree = 259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0774564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,-0.0091359) , 
3, -1.69439, 1, 0, 0.0531915,0.0632949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674286,0.101926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239693,-0.0171691) , 
2, -0.930394, 1, 0, 0.287049,-0.0133806) , 
1, -0.695692, 1, 0, 0.242684,0.00116532)    );
  // itree = 260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0545455,-0.0218368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512397,0.0928788) , 
3, -1.11758, 1, 0, 0.248252,0.0772349) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730012,-0.0352781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434293,0.0060294) , 
3, 0.216588, 1, 0, 0.246691,-0.0138507) , 
1, -0.796791, 1, 0, 0.24692,-0.000477736)    );
  // itree = 261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398964,-0.00119839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320889,0.00746604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0944272,-0.0122155) , 
1, 0.967289, 1, 0, 0.238283,-0.0233614) , 
0, -1.2692, 1, 0, 0.254073,-0.0146881)    );
  // itree = 262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408163,-0.00131699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207356,-0.0145954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303754,0.0471551) , 
2, 1.27955, 1, 0, 0.22246,-0.00844272) , 
0, -1.39419, 1, 0, 0.235994,-0.000415827)    );
  // itree = 263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0865989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0972447,-0.0144933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336642,-0.00393955) , 
1, 0.0100465, 1, 0, 0.25575,-0.0026156) , 
0, -1.2692, 1, 0, 0.230959,0.00643838)    );
  // itree = 264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038961,-0.0378556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0955546) , 
3, -1.47032, 1, 0, 0.222656,0.062307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0836237,-0.0267298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449819,0.0114746) , 
3, 0.157626, 1, 0, 0.263033,-0.00233231) , 
0, -1.03521, 1, 0, 0.257716,0.00617987)    );
  // itree = 265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357488,-0.0146324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293344,0.00911795) , 
0, -1.17805, 1, 0, 0.302201,-0.0166355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.018018,-0.0708787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0958904,-0.00938866) , 
2, 0.201207, 1, 0, 0.0777311,0.0530945) , 
3, 0.883159, 1, 0, 0.248101,0.000170307)    );
  // itree = 266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456376,0.0100112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226891,-0.0511176) , 
3, -1.63983, 1, 0, 0.354478,0.0519459) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0239521,-0.090505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249844,0.00890683) , 
2, -1.3126, 1, 0, 0.228507,-0.0256998) , 
0, -1.08742, 1, 0, 0.245088,-0.0154792)    );
  // itree = 267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137405,-0.0232337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.660714,0.0400412) , 
1, 1.2017, 1, 0, 0.236353,0.00681973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,0.0393469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240506,-0.0249994) , 
1, 1.1684, 1, 0, 0.267176,-0.0714593) , 
2, 1.40345, 1, 0, 0.240314,-0.00323868)    );
  // itree = 268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168224,0.0730955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283019,0.0471837) , 
1, -0.612765, 1, 0, 0.225352,0.0775404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.084989,-0.025657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448958,0.0149354) , 
3, -0.00379055, 1, 0, 0.27224,0.00400175) , 
0, -1.2692, 1, 0, 0.267436,0.011536)    );
  // itree = 269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551546,0.00738031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304094,-0.0205978) , 
3, -1.16926, 1, 0, 0.435616,0.0559435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194977,-0.00994481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217391,0.0273472) , 
0, 1.52075, 1, 0, 0.19656,-0.0238523) , 
1, -0.695692, 1, 0, 0.240341,-0.00923839)    );
  // itree = 270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41966,0.0131855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222999,0.00532624) , 
3, -0.922913, 1, 0, 0.280286,-0.00209189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154255,-0.0076188) , 
0, 1.40235, 1, 0, 0.268463,-0.00926504)    );
  // itree = 271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142222,-0.0213454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235479,-0.0212658) , 
3, -0.0905164, 1, 0, 0.180872,0.0201713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565891,0.0376396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,-0.0137321) , 
3, 1.0825, 1, 0, 0.401709,-0.0435227) , 
0, 0.893748, 1, 0, 0.232419,0.00530409)    );
  // itree = 272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.090216,-0.0105045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471295,0.0293885) , 
3, -0.302251, 1, 0, 0.276042,0.0277897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.0633107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277439,-0.0139281) , 
1, 0.060677, 1, 0, 0.232609,-0.0487185) , 
0, 0.886294, 1, 0, 0.266032,0.0101575)    );
  // itree = 273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490132,0.0166038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129944,-0.029921) , 
3, -0.858567, 1, 0, 0.357588,0.0408829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327485,0.0177708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112224,0.000424523) , 
3, 0.764093, 1, 0, 0.257049,-0.0189798) , 
0, -0.659236, 1, 0, 0.281157,-0.00462587)    );
  // itree = 274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334066,0.00893342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205505,-0.0146015) , 
1, 0.818867, 1, 0, 0.285911,0.00743454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120846,-0.0273582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224771,0.0211683) , 
1, 0.827478, 1, 0, 0.162113,-0.0526001) , 
0, 0.759972, 1, 0, 0.251996,-0.00901208)    );
  // itree = 275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0845693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291297,0.00986862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,-0.026505) , 
0, 1.50716, 1, 0, 0.284772,-0.0175441) , 
0, -1.24826, 1, 0, 0.257072,-0.00604077)    );
  // itree = 276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271028,0.0256346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17094,-0.0392085) , 
0, 0.936448, 1, 0, 0.255599,0.0241414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0631868,-0.0557878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305389,-0.00580619) , 
2, -0.0832119, 1, 0, 0.23186,-0.0294526) , 
1, -0.0304994, 1, 0, 0.241062,-0.00867741)    );
  // itree = 277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37384,0.00986481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119122,-0.00684496) , 
3, 0.793921, 1, 0, 0.319814,-0.00603815) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0633609,-0.0294955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159794,0.0402208) , 
0, 0.474582, 1, 0, 0.0969479,-0.064697) , 
1, 1.2017, 1, 0, 0.259583,-0.0218911)    );
  // itree = 278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345912,-0.020297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310703,0.00566795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0868217,-0.0248368) , 
3, 0.582202, 1, 0, 0.234581,-0.0207806) , 
0, -1.37002, 1, 0, 0.243191,-0.0129299)    );
  // itree = 279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135535,-0.0185075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267161,-0.00969831) , 
3, -0.0523685, 1, 0, 0.185603,0.0228495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425466,0.0537057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384615,-0.0119144) , 
1, 0.678798, 1, 0, 0.406723,-0.0385079) , 
0, 0.676581, 1, 0, 0.250994,0.0047045)    );
  // itree = 280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015015,-0.0627402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341051,0.0155549) , 
3, -1.2237, 1, 0, 0.266484,0.0114157) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.122563,-0.0421363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398551,-0.00387249) , 
0, 0.64517, 1, 0, 0.199195,-0.0497549) , 
1, 1.2017, 1, 0, 0.24936,-0.00415097)    );
  // itree = 281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481283,2.45888e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240404,-0.0126174) , 
3, -1.64472, 1, 0, 0.306452,0.0349789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217035,-0.00164241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0681818,-0.026679) , 
3, 1.812, 1, 0, 0.202513,-0.0123603) , 
0, -0.420972, 1, 0, 0.237346,0.00350472)    );
  // itree = 282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281768,-0.0151963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159624,-0.0171771) , 
0, -0.158742, 1, 0, 0.236522,0.0393806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354331,0.0190395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109712,-0.00651271) , 
3, 0.65682, 1, 0, 0.260208,-0.00892851) , 
1, -0.321883, 1, 0, 0.253465,0.00482285)    );
  // itree = 283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206005,-0.0046458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300578,0.00321152) , 
3, 0.312487, 1, 0, 0.240613,0.00615692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216667,-0.027024) , 
2, 1.7672, 1, 0, 0.239184,-0.00363445)    );
  // itree = 284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150177,-0.000705151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.596306,0.0341506) , 
3, 0.439416, 1, 0, 0.262078,0.020828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0252708,-0.0761363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537736,0.00497678) , 
3, 1.09821, 1, 0, 0.247444,-0.037992) , 
0, 0.813325, 1, 0, 0.2585,0.00644652)    );
  // itree = 285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35624,0.00643809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0704225,-0.0371793) , 
3, 0.827607, 1, 0, 0.303871,0.0138629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584958,-0.0357933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,0.045041) , 
3, 1.55289, 1, 0, 0.0803383,-0.059263) , 
1, 1.28112, 1, 0, 0.251607,-0.00323473)    );
  // itree = 286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531746,0.0350258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319672,-0.0142282) , 
3, -1.75451, 1, 0, 0.427419,0.0796115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236154,-0.00262284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182033,-0.00307571) , 
1, 1.29547, 1, 0, 0.222867,-0.00806151) , 
0, -1.08926, 1, 0, 0.248605,0.00296991)    );
  // itree = 287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.013597,-0.0736867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292722,0.00701897) , 
0, 0.14934, 1, 0, 0.136017,0.00876995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.7,0.057467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469169,0.00796134) , 
0, -0.282097, 1, 0, 0.538462,-0.033813) , 
1, 1.17026, 1, 0, 0.244681,-0.00272789)    );
  // itree = 288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0790598,-0.0150595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.494898,0.0342722) , 
3, -0.663668, 1, 0, 0.268605,0.0273724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162767,-0.0204367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.788321,0.0219175) , 
3, 1.85245, 1, 0, 0.239286,-0.0196993) , 
1, 0.223549, 1, 0, 0.25202,0.000745981)    );
  // itree = 289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335,-0.0230153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316038,0.00245148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125466,-0.00309493) , 
3, 0.263604, 1, 0, 0.23378,-0.00323337) , 
0, -1.26434, 1, 0, 0.243584,0.00775353)    );
  // itree = 290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308271,-0.00181837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176829,-0.00685822) , 
0, 0.0992237, 1, 0, 0.25814,0.0347086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28479,0.0140964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0628931,-0.0288854) , 
3, 1.74087, 1, 0, 0.252302,-0.0204594) , 
1, 0.149288, 1, 0, 0.254882,0.00392111)    );
  // itree = 291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211668,-0.00903773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358447,0.0151554) , 
3, 0.765832, 1, 0, 0.247887,0.00280546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519231,0.0415976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110294,-0.0327515) , 
3, 1.06287, 1, 0, 0.2875,-0.079477) , 
2, 1.41921, 1, 0, 0.252605,-0.00699493)    );
  // itree = 292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114094,-0.0111783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462751,0.0244671) , 
3, 0.0900133, 1, 0, 0.253877,0.0141776) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0166667,-0.0642083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348101,-0.0459566) , 
3, 0.850383, 1, 0, 0.205036,-0.0870122) , 
0, 1.24953, 1, 0, 0.247152,0.00024458)    );
  // itree = 293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328358,0.00785251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677201,-0.026608) , 
3, 0.662859, 1, 0, 0.263601,-0.00103356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,-0.016618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160714,0.0306748) , 
3, 1.40697, 1, 0, 0.168,-0.0651707) , 
0, 1.31913, 1, 0, 0.251845,-0.00892056)    );
  // itree = 294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353846,-0.0265905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26166,0.0044163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170915,-0.0176004) , 
1, 0.967289, 1, 0, 0.230331,-0.00712041) , 
0, -1.64945, 1, 0, 0.238118,0.000329623)    );
  // itree = 295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0803982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259488,0.00179042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261056,-0.0109835) , 
3, 0.385816, 1, 0, 0.260087,-0.00718049) , 
0, -1.26434, 1, 0, 0.23755,0.000550468)    );
  // itree = 296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0661765,0.000843799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460317,0.0683337) , 
3, -1.34839, 1, 0, 0.255725,0.0691379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137958,-0.0262594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531963,0.00503482) , 
3, 0.957916, 1, 0, 0.238234,-0.0232267) , 
1, -0.861031, 1, 0, 0.240545,-0.0110232)    );
  // itree = 297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436451,0.00806224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140221,-0.0141394) , 
3, 0.279349, 1, 0, 0.363801,0.0186138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157447,-0.00376411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0961857,-0.00715421) , 
1, 1.04322, 1, 0, 0.113365,-0.0404873) , 
1, 0.583399, 1, 0, 0.25579,-0.00687605)    );
  // itree = 298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370588,-0.0128884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309205,0.000273755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11828,-0.00101073) , 
3, 0.422349, 1, 0, 0.232958,-0.0170031) , 
0, -1.37002, 1, 0, 0.244466,-0.00861142)    );
  // itree = 299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0884163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.079831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312279,0.00770112) , 
1, -1.25764, 1, 0, 0.295036,-0.0300242) , 
0, -1.2692, 1, 0, 0.268256,-0.0193833)    );
  // itree = 300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286203,0.0280396) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106164,-0.0426615) , 
1, 1.2017, 1, 0, 0.241232,0.0183848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0674374,-0.0603348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576792,0.00983513) , 
3, 1.08356, 1, 0, 0.251232,-0.0389756) , 
0, 0.310699, 1, 0, 0.245331,-0.00512686)    );
  // itree = 301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.625,0.0218922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204724,-0.0570039) , 
3, -1.13945, 1, 0, 0.448845,0.0820459) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253669,-0.0111824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122853,-0.000603254) , 
3, 0.289634, 1, 0, 0.195792,-0.0104426) , 
1, -0.843018, 1, 0, 0.233863,0.00347202)    );
  // itree = 302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264571,-0.000181602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123393,-0.0356785) , 
1, 1.15617, 1, 0, 0.232132,0.0127781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,0.0414109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0723231) , 
0, 0.88427, 1, 0, 0.349206,-0.0820588) , 
2, 1.40517, 1, 0, 0.247301,0.000490747)    );
  // itree = 303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0791495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350877,0.0430562) , 
0, 0.441323, 1, 0, 0.0837989,0.0289132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413534,0.016387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250569,-0.0192657) , 
2, 0.968549, 1, 0, 0.355699,-0.0336964) , 
1, -0.0851305, 1, 0, 0.256016,-0.0107428)    );
  // itree = 304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203488,0.0551385) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0609453,-0.0335532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403651,0.00336343) , 
3, -0.109025, 1, 0, 0.249721,-0.0107825) , 
0, -1.35255, 1, 0, 0.245668,-0.00391729)    );
  // itree = 305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37426,-0.0037824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126649,-0.00945419) , 
3, -0.387124, 1, 0, 0.285308,0.00775131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273101,0.00292872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,0.0426833) , 
3, 0.785218, 1, 0, 0.228929,-0.0312282) , 
0, 0.130486, 1, 0, 0.2597,-0.0099538)    );
  // itree = 306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355685,0.00634344) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216949,0.00963377) , 
0, -0.0254439, 1, 0, 0.291536,0.0236798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0877154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251563,0.0103293) , 
2, -1.04144, 1, 0, 0.216398,-0.0417005) , 
1, 0.874157, 1, 0, 0.263861,-0.000400847)    );
  // itree = 307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0144928,-0.016503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,0.0125921) , 
3, -1.6674, 1, 0, 0.0691643,0.0545591) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339012,0.0467658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267098,-0.0155963) , 
3, -0.441677, 1, 0, 0.292391,-0.00846026) , 
1, -0.752382, 1, 0, 0.253968,0.00238683)    );
  // itree = 308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139202,-0.0097078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637363,0.029608) , 
3, 0.344827, 1, 0, 0.274422,0.00935518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0288809,-0.0759698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316109,-0.00173498) , 
2, 0.610172, 1, 0, 0.184818,-0.0395072) , 
1, 1.07236, 1, 0, 0.246533,-0.00585314)    );
  // itree = 309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.492386,0.0094989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274799,-0.000294873) , 
3, -0.969901, 1, 0, 0.35,0.0208961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.011505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133612,0.00524242) , 
0, 0.116353, 1, 0, 0.119678,-0.0303313) , 
1, 0.568008, 1, 0, 0.250373,-0.00126249)    );
  // itree = 310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413793,-0.00227761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265625,-0.0287148) , 
3, -1.5362, 1, 0, 0.344322,0.0735086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296045,-0.00745658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139208,0.00037635) , 
3, 0.155971, 1, 0, 0.222422,-0.0130639) , 
0, -0.997673, 1, 0, 0.239567,-0.000887546)    );
  // itree = 311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0873874,-0.0252039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.502423,0.0185253) , 
1, 0.627177, 1, 0, 0.235975,0.0104895) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420118,0.00664633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0560748,-0.0272679) , 
3, 1.68156, 1, 0, 0.278986,-0.0471904) , 
2, 1.40345, 1, 0, 0.241895,0.00254956)    );
  // itree = 312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237762,0.0859535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147353,-0.0170853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518443,0.0099622) , 
3, 0.883159, 1, 0, 0.243372,-0.0104101) , 
1, -1.19679, 1, 0, 0.242977,-0.00211976)    );
  // itree = 313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366158,-0.00216243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157447,-0.000105136) , 
3, -0.420143, 1, 0, 0.262973,0.0165979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190019,0.000536211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226891,0.0299339) , 
0, 1.53939, 1, 0, 0.196875,-0.0577441) , 
0, 0.676581, 1, 0, 0.242498,-0.00643158)    );
  // itree = 314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390306,0.00569247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114235,-0.0304405) , 
3, -0.286582, 1, 0, 0.274205,0.0289874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210024,-0.00281505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110169,-0.00139412) , 
3, 1.38144, 1, 0, 0.174046,-0.0248715) , 
0, 0.563554, 1, 0, 0.241534,0.0114188)    );
  // itree = 315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0443459,-0.018803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147692,0.00958636) , 
3, -0.648085, 1, 0, 0.0876289,0.0384358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370892,-0.00170545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2575,0.000668818) , 
3, 0.956155, 1, 0, 0.334665,-0.0253878) , 
1, -0.0304994, 1, 0, 0.240138,-0.000966131)    );
  // itree = 316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939227,0.0150588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484848,0.0630158) , 
3, -1.03556, 1, 0, 0.258786,0.0671707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119323,-0.0262431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504245,0.0100628) , 
3, 0.654549, 1, 0, 0.251752,-0.0123889) , 
1, -0.752382, 1, 0, 0.25284,-9.1521e-05)    );
  // itree = 317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421914,0.00780329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151111,0.0127868) , 
1, 0.402304, 1, 0, 0.297481,0.00403629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202952,-0.00443317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16185,0.0102699) , 
2, 1.16723, 1, 0, 0.186937,-0.0467976) , 
0, 0.886294, 1, 0, 0.271824,-0.00776206)    );
  // itree = 318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0766708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332669,-0.00184101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22889,0.011011) , 
0, -0.571715, 1, 0, 0.255814,-0.00829337) , 
1, -1.44651, 1, 0, 0.245742,-0.00234179)    );
  // itree = 319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0039801,-0.080276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569369,0.0303124) , 
1, 0.892141, 1, 0, 0.205128,0.0126469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543284,0.0322439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,0.010571) , 
3, 1.67954, 1, 0, 0.418803,-0.0453089) , 
0, 0.893748, 1, 0, 0.254438,-0.000727502)    );
  // itree = 320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22905,0.0557234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223341,-0.0038475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.81982,0.0297819) , 
3, 1.90818, 1, 0, 0.260145,-0.00122111) , 
0, -1.2692, 1, 0, 0.257331,0.00577978)    );
  // itree = 321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385714,-0.0116985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193059,0.00277601) , 
3, -0.757858, 1, 0, 0.292324,0.0265466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303972,0.0117242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153191,0.0202015) , 
3, 0.677438, 1, 0, 0.236416,-0.0276533) , 
0, -0.0107878, 1, 0, 0.263,-0.00188125)    );
  // itree = 322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451128,0.00966643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.03284) , 
3, -1.7172, 1, 0, 0.362869,0.0887709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206452,-0.0138167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245247,0.00705671) , 
1, -0.960884, 1, 0, 0.241777,-0.00482734) , 
0, -1.09189, 1, 0, 0.256345,0.00643296)    );
  // itree = 323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203438,0.00177179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291971,-0.00862784) , 
3, 0.0728438, 1, 0, 0.238453,0.00413628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398438,0.0463437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116505,-0.0737753) , 
1, 1.44684, 1, 0, 0.272727,-0.062421) , 
2, 1.45905, 1, 0, 0.242486,-0.00369598)    );
  // itree = 324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284689,0.0385575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239662,-0.00315319) , 
1, -0.428552, 1, 0, 0.252362,0.0144533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.087349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283293,-0.0128867) , 
2, -0.255482, 1, 0, 0.218807,-0.0433858) , 
0, 0.740359, 1, 0, 0.243243,-0.00126413)    );
  // itree = 325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41272,0.00277113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16091,-0.00159837) , 
1, -0.0220085, 1, 0, 0.257529,-0.00737305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284314,0.068552) , 
0, 1.54066, 1, 0, 0.258876,-0.0138645)    );
  // itree = 326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377264,0.0147544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.094703,-0.0286848) , 
3, 0.030245, 1, 0, 0.268398,0.0092887) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,0.0322506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403509,0.0904898) , 
2, 1.75178, 1, 0, 0.340299,-0.0517897) , 
2, 1.18512, 1, 0, 0.280738,-0.00119351)    );
  // itree = 327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217973,0.0118738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292398,-0.00974558) , 
3, -0.0638258, 1, 0, 0.251447,0.00061215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00806833) , 
0, 1.49754, 1, 0, 0.252935,-0.00654306)    );
  // itree = 328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724138,-0.0179758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0207101,-0.062077) , 
2, -0.747962, 1, 0, 0.044586,-0.0344764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39726,0.0367613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321029,-0.00729992) , 
0, -0.0769601, 1, 0, 0.346096,0.0150017) , 
3, -0.718083, 1, 0, 0.24949,-0.000851477)    );
  // itree = 329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308135,-0.000143558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116466,-0.000449082) , 
3, 0.644419, 1, 0, 0.257552,0.000346059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121951,0.00813477) , 
2, 1.77922, 1, 0, 0.249254,-0.00525884)    );
  // itree = 330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465798,0.0230621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208054,-0.0233994) , 
3, -0.996438, 1, 0, 0.338843,0.046426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23229,0.00422872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,-0.0433088) , 
3, 1.77277, 1, 0, 0.211257,-0.00955401) , 
0, -0.479386, 1, 0, 0.25038,0.00761169)    );
  // itree = 331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143064,-0.0113285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347826,0.0182939) , 
0, -0.235224, 1, 0, 0.233923,-0.0248593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279018,-0.0128907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300781,0.000718696) , 
0, 1.00622, 1, 0, 0.286932,0.033048) , 
3, 0.334648, 1, 0, 0.25308,-0.0039318)    );
  // itree = 332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0537634,-0.024392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551402,0.077774) , 
3, -1.24132, 1, 0, 0.235495,0.0517792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278846,0.0291329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250929,-0.0104001) , 
1, -1.12426, 1, 0, 0.252619,-0.0125887) , 
0, -0.940853, 1, 0, 0.250124,-0.00321042)    );
  // itree = 333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570796,0.0149114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282248,-0.00516909) , 
1, -0.867328, 1, 0, 0.346878,-0.0178967) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194215,-0.0129401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134008,0.00403055) , 
1, 0.155465, 1, 0, 0.148112,0.0230263) , 
3, -0.097287, 1, 0, 0.246327,0.00280529)    );
  // itree = 334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392405,-0.00754297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249235,0.00159602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184211,0.00906739) , 
0, 1.34217, 1, 0, 0.241268,-0.0166036) , 
0, -1.35255, 1, 0, 0.253096,-0.00822406)    );
  // itree = 335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285996,-0.0647049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.687861,0.0524702) , 
1, 1.21347, 1, 0, 0.196324,0.0112699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.443439,0.00800072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124352,-0.0161573) , 
3, 1.37284, 1, 0, 0.346457,-0.0328034) , 
0, 0.587803, 1, 0, 0.24411,-0.00275846)    );
  // itree = 336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209945,0.0454998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207257,-0.0156694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814815,0.0346047) , 
3, 1.87358, 1, 0, 0.245098,-0.0172658) , 
0, -1.24826, 1, 0, 0.241775,-0.0102269)    );
  // itree = 337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42,-0.00658792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351266,0.00280845) , 
0, -0.185624, 1, 0, 0.389665,0.0291027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.08,-0.0375013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149695,-0.00466399) , 
2, -0.849647, 1, 0, 0.141647,-0.0218819) , 
1, 0.0100465, 1, 0, 0.229777,-0.0037653)    );
  // itree = 338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308394,0.00389245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153203,-0.0212876) , 
1, 1.25988, 1, 0, 0.270103,0.0208269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159145,-0.013315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242424,0.0291739) , 
1, 1.15484, 1, 0, 0.179024,-0.0366432) , 
0, 0.759972, 1, 0, 0.24502,0.00499972)    );
  // itree = 339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0917246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30166,0.0145878) , 
0, -1.35255, 1, 0, 0.273909,0.0137246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.128176) , 
1, 1.65151, 1, 0, 0.261319,0.00751804)    );
  // itree = 340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286783,0.0142535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170306,-0.0413363) , 
0, 1.14349, 1, 0, 0.268156,0.0106626) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0520833,-0.0653668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255556,-0.010262) , 
0, -0.260302, 1, 0, 0.184783,-0.0397415) , 
1, 1.14418, 1, 0, 0.24496,-0.00336111)    );
  // itree = 341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328076,0.00585367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0366314) , 
3, 1.24904, 1, 0, 0.308084,0.00530644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0320513,-0.0690397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11674,-0.0149857) , 
0, -0.132109, 1, 0, 0.095082,-0.0467611) , 
2, 0.690799, 1, 0, 0.242562,-0.0107103)    );
  // itree = 342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192498,-0.0373172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0823669) , 
3, 0.9091, 1, 0, 0.172872,0.0231515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424512,0.0492955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111455,-0.00768069) , 
3, 0.970075, 1, 0, 0.310384,-0.018272) , 
2, 0.324939, 1, 0, 0.233366,0.00492843)    );
  // itree = 343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0771538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0258621,-0.066751) , 
3, -1.75582, 1, 0, 0.012,0.0787143) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320285,0.0272733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263216,-0.015716) , 
3, -0.00322609, 1, 0, 0.290691,0.00369108) , 
0, -1.03387, 1, 0, 0.255872,0.0130643)    );
  // itree = 344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104575,-0.00475194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511962,0.0508365) , 
3, -0.748137, 1, 0, 0.269903,0.0458759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259556,0.000780956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205556,-0.0295111) , 
1, 1.38, 1, 0, 0.246465,-0.0106421) , 
1, -0.363096, 1, 0, 0.2525,0.00391125)    );
  // itree = 345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,0.0304826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276853,-0.0191783) , 
1, -1.26616, 1, 0, 0.342965,-0.0233377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287037,0.0081278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171857,0.0242666) , 
1, 0.109299, 1, 0, 0.203191,0.020713) , 
3, -0.408719, 1, 0, 0.259185,0.0030661)    );
  // itree = 346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475728,0.0283088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,-0.00431206) , 
3, -2.11804, 1, 0, 0.241009,0.00299365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448,0.0968004) , 
2, 1.76296, 1, 0, 0.254024,-0.00291197)    );
  // itree = 347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250146,-0.00490776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403614,0.0149851) , 
2, 1.45905, 1, 0, 0.263719,-0.0114571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0798425) , 
3, 1.90896, 1, 0, 0.250253,-0.00489459)    );
  // itree = 348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151316,0.0237617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668693,-0.0397924) , 
2, -0.479639, 1, 0, 0.101436,-0.0119111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.588235,0.032793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313817,-0.00828521) , 
1, 1.00111, 1, 0, 0.46087,0.0329078) , 
3, 0.127977, 1, 0, 0.264012,0.00836093)    );
  // itree = 349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,-0.0212872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209302,-0.0314354) , 
3, -1.73692, 1, 0, 0.323843,0.0455548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295307,0.00371647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0859107,-0.00960219) , 
1, 1.09547, 1, 0, 0.228273,-0.0213677) , 
0, -1.03387, 1, 0, 0.241067,-0.0124086)    );
  // itree = 350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133758,-0.0618286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994152,-0.0642846) , 
1, -0.673256, 1, 0, 0.115854,-0.0565629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4125,0.0200112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170254,0.00118724) , 
3, -0.240211, 1, 0, 0.270379,0.0130997) , 
2, -1.07513, 1, 0, 0.245894,0.00206135)    );
  // itree = 351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00729927,-0.0599884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0883595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296494,0.00207934) , 
0, -1.37002, 1, 0, 0.279395,-0.0134904) , 
1, -1.19679, 1, 0, 0.26001,-0.00715717)    );
  // itree = 352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125885,-0.0116865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52669,0.0222419) , 
3, 0.46859, 1, 0, 0.248773,0.00564263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303448,-0.040048) , 
2, 1.76374, 1, 0, 0.252781,-0.000818043)    );
  // itree = 353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410468,0.000372517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197092,0.00171664) , 
3, -0.204472, 1, 0, 0.312268,0.0124334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0518293,-0.0370017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126074,0.0133755) , 
0, 0.127706, 1, 0, 0.0901034,-0.0325291) , 
1, 1.01701, 1, 0, 0.237883,-0.0026208)    );
  // itree = 354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329577,-0.00198702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271605,0.00886304) , 
0, -0.256057, 1, 0, 0.300208,0.0036663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0819888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118598,-0.00230685) , 
2, 0.10207, 1, 0, 0.0912863,0.0534981) , 
3, 0.873167, 1, 0, 0.247788,0.0161696)    );
  // itree = 355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0773477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0503145,-0.0305031) , 
3, -1.65584, 1, 0, 0.0273038,0.0652192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287958,-0.00404091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24846,-0.0104686) , 
3, 0.784651, 1, 0, 0.276179,-0.00689501) , 
0, -0.920459, 1, 0, 0.238318,0.00407563)    );
  // itree = 356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129696,-0.00590581) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.493253,0.0235531) , 
3, 0.267206, 1, 0, 0.265546,0.0146914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272059,-0.0275576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300752,-0.0387766) , 
2, 1.78095, 1, 0, 0.286245,-0.0607633) , 
2, 1.42243, 1, 0, 0.268257,0.0048096)    );
  // itree = 357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.74359,0.0469587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26506,-0.030593) , 
1, -1.15143, 1, 0, 0.389755,-0.0405044) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,-0.0131513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202929,-0.00361768) , 
0, -0.936748, 1, 0, 0.201942,0.0118405) , 
3, -1.15195, 1, 0, 0.244233,5.36783e-05)    );
  // itree = 358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.444444,0.0140799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247485,-0.0118623) , 
3, -1.2998, 1, 0, 0.316819,0.0314613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0946241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223867,0.00651862) , 
2, -0.94203, 1, 0, 0.193291,-0.0220027) , 
0, -0.293879, 1, 0, 0.240218,-0.00169222)    );
  // itree = 359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0759166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0421053,-0.0482032) , 
3, -1.93588, 1, 0, 0.0271186,0.0605882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280399,-0.00219997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291822,0.00147147) , 
3, 0.646818, 1, 0, 0.284146,-0.0120993) , 
0, -0.953749, 1, 0, 0.244961,-0.00101773)    );
  // itree = 360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0830816,-0.0167805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489796,0.0276254) , 
3, -0.387124, 1, 0, 0.221891,0.00979055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0456432,-0.0630026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434442,0.000100603) , 
3, 0.487109, 1, 0, 0.24572,-0.0296947) , 
0, 0.0296075, 1, 0, 0.233734,-0.00983349)    );
  // itree = 361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388466,0.00903274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119929,-0.00415948) , 
3, -0.0905164, 1, 0, 0.286003,0.00926958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184211,-0.0243939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181081,0.0040162) , 
2, -0.215426, 1, 0, 0.181818,-0.0382285) , 
0, 0.823264, 1, 0, 0.260406,-0.00240001)    );
  // itree = 362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271372,-0.00701075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372727,0.0645736) , 
2, 0.790814, 1, 0, 0.28956,0.0150941) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0865247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218571,-0.00780201) , 
2, -0.849647, 1, 0, 0.188192,-0.0198417) , 
1, 0.796579, 1, 0, 0.249142,0.00116431)    );
  // itree = 363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0781628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247379,0.0359988) , 
0, -1.56123, 1, 0, 0.201022,-0.0295496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113821,-0.0171704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356423,-0.00748567) , 
1, 0.409101, 1, 0, 0.250532,0.0101214) , 
3, -0.871513, 1, 0, 0.235972,-0.00154539)    );
  // itree = 364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.026087,-0.0522788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350649,0.0403058) , 
3, -1.78014, 1, 0, 0.242775,0.0340867) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0961145,-0.0275908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485904,0.00444938) , 
3, 0.530195, 1, 0, 0.244782,-0.0147328) , 
1, -0.754602, 1, 0, 0.244421,-0.00596705)    );
  // itree = 365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422096,0.00254662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00256084) , 
1, 0.223549, 1, 0, 0.276423,0.00796757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198925,-0.00666662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119266,-0.00923801) , 
3, 1.59528, 1, 0, 0.180873,-0.0441237) , 
0, 0.759972, 1, 0, 0.252938,-0.00483565)    );
  // itree = 366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475806,0.0304878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287449,-0.0269765) , 
3, -1.97412, 1, 0, 0.350404,-0.0433387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246051,0.00626911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0650406,-0.0340953) , 
3, 1.93314, 1, 0, 0.233465,0.00740747) , 
3, -1.30768, 1, 0, 0.253738,-0.00139011)    );
  // itree = 367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0839185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365915,0.0219724) , 
0, 0.581343, 1, 0, 0.112221,0.014891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.933333,0.0886665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390192,-0.00804544) , 
2, -0.219633, 1, 0, 0.540832,-0.0386834) , 
1, 0.939437, 1, 0, 0.254872,-0.00293964)    );
  // itree = 368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0131579,-0.065414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436364,0.0616416) , 
3, -1.64337, 1, 0, 0.233438,0.0390859) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246988,-0.00357555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318182,-0.0360818) , 
0, 1.46266, 1, 0, 0.253641,-0.0117152) , 
0, -0.940853, 1, 0, 0.250382,-0.00351982)    );
  // itree = 369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590643,0.00469746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329193,-0.0179688) , 
3, -1.16926, 1, 0, 0.463855,0.0549773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22351,-0.00747502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916844,-0.0103861) , 
3, 0.883159, 1, 0, 0.186643,-0.00513544) , 
1, -0.752382, 1, 0, 0.232454,0.00479858)    );
  // itree = 370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351351,0.00852459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268025,0.00924927) , 
0, 0.0539634, 1, 0, 0.315648,-0.021656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0813486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118734,-0.00584238) , 
2, 0.334969, 1, 0, 0.0905433,0.0241524) , 
3, 0.853537, 1, 0, 0.259315,-0.0101924)    );
  // itree = 371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235415,0.0149715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30713,-0.00586574) , 
2, 0.227491, 1, 0, 0.261155,-0.019078) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.658915,0.0656333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0997151,-0.0498384) , 
2, 0.411941, 1, 0, 0.25,0.0237332) , 
3, 0.839878, 1, 0, 0.258483,-0.00882378)    );
  // itree = 372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216495,-0.00204904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193548,-0.0403861) , 
2, 1.11585, 1, 0, 0.212864,-0.0130343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.803571,0.0303064) , 
3, 1.90896, 1, 0, 0.244809,-0.00818979)    );
  // itree = 373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381679,-0.00793603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329843,0.0145824) , 
0, -0.239866, 1, 0, 0.354603,0.0197085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0965732,-0.0104937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120658,-0.000131902) , 
0, -0.115543, 1, 0, 0.111751,-0.0415696) , 
1, 0.634693, 1, 0, 0.247328,-0.0073599)    );
  // itree = 374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272331,-0.00251782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175439,-0.00902953) , 
1, 1.29547, 1, 0, 0.250563,0.00242608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126126,-0.036293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20438,0.0359248) , 
3, 1.08356, 1, 0, 0.169355,-0.0782916) , 
0, 1.31913, 1, 0, 0.240613,-0.00746422)    );
  // itree = 375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0785173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315603,-0.00494089) , 
1, -0.0543295, 1, 0, 0.1875,0.0177734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446309,0.0181523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0800349) , 
3, 1.8907, 1, 0, 0.375176,-0.0423541) , 
0, 0.566352, 1, 0, 0.249883,-0.00221274)    );
  // itree = 376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0358744,-0.0344722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327217,0.011237) , 
3, -1.0756, 1, 0, 0.253136,0.00885951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258242,-0.0495354) , 
0, 1.44542, 1, 0, 0.253616,-0.000372612)    );
  // itree = 377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35792,0.00452647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761905,-0.019822) , 
3, 0.0598775, 1, 0, 0.28021,0.0204954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240838,0.00804653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0982906,-0.0159846) , 
3, 1.38144, 1, 0, 0.199504,-0.0195211) , 
0, 0.29569, 1, 0, 0.246793,0.0039262)    );
  // itree = 378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185841,-0.0477071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00862069,-0.0866495) , 
0, -0.589403, 1, 0, 0.0960699,-0.0503889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374891,0.0173488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130814,-0.00426646) , 
3, 0.429099, 1, 0, 0.283379,0.00307104) , 
2, -1.27243, 1, 0, 0.262597,-0.00286032)    );
  // itree = 379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17246,0.0117667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224352,-0.0298908) , 
3, -0.475388, 1, 0, 0.200612,0.0139654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561983,0.0675227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368613,0.00967182) , 
1, -0.0814273, 1, 0, 0.427848,-0.0500371) , 
0, 1.04529, 1, 0, 0.244828,0.00151174)    );
  // itree = 380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288136,0.0297931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150376,-0.0469745) , 
0, 0.55062, 1, 0, 0.257851,0.0196618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206761,-0.0155222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.836364,0.0363053) , 
3, 1.91071, 1, 0, 0.256874,-0.0139792) , 
1, -0.181481, 1, 0, 0.257172,-0.00373622)    );
  // itree = 381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359952,0.00412523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.03861,-0.0416909) , 
1, 1.2017, 1, 0, 0.284153,0.0133016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248062,0.0182237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158879,0.0335132) , 
3, 1.86397, 1, 0, 0.23723,-0.0414666) , 
0, 0.19327, 1, 0, 0.263264,-0.0110798)    );
  // itree = 382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340426,-0.00229741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102339,-0.016654) , 
3, -0.278415, 1, 0, 0.259,0.0178595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167598,-0.0264045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306839,0.024878) , 
2, 0.600876, 1, 0, 0.237477,-0.0195941) , 
1, 0.275303, 1, 0, 0.247834,-0.00157025)    );
  // itree = 383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0572792,-0.00406311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0144491) , 
3, -0.909406, 1, 0, 0.0897921,0.0159415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.850467,0.0793504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289747,-0.0186904) , 
2, -0.228688, 1, 0, 0.425028,-0.0258546) , 
1, 0.480056, 1, 0, 0.242674,-0.00311924)    );
  // itree = 384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0389222,-0.0426634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419295,0.0249937) , 
3, -1.01241, 1, 0, 0.273769,0.0170424) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168317,-0.0275441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377358,-0.000207727) , 
2, 0.877626, 1, 0, 0.252534,-0.0219917) , 
1, 0.149288, 1, 0, 0.261546,-0.00542548)    );
  // itree = 385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493433,0.0295085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161538,-0.0479857) , 
2, -0.369485, 1, 0, 0.329535,-0.0237343) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164653,0.00569668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113565,-0.00829446) , 
2, 1.11338, 1, 0, 0.14811,0.0181587) , 
3, -0.097287, 1, 0, 0.242126,-0.00355066)    );
  // itree = 386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447368,0.0113003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254658,-0.0324019) , 
3, -1.59934, 1, 0, 0.348243,0.0640683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301734,-0.00195387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120238,-0.0116745) , 
3, 0.229216, 1, 0, 0.212317,0.00513651) , 
0, -0.920459, 1, 0, 0.233399,0.0142771)    );
  // itree = 387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00641026,-0.0461609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.03,-0.0387604) , 
3, -1.11239, 1, 0, 0.015625,0.0624454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144621,-0.0224651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518919,0.0169637) , 
1, 1.09788, 1, 0, 0.267614,-0.0172742) , 
1, -0.902225, 1, 0, 0.234447,-0.00678156)    );
  // itree = 388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0384615,-0.0321247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540984,0.0737217) , 
3, -1.4415, 1, 0, 0.309735,0.0749225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286486,0.0277227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243952,-0.00793771) , 
0, -0.997673, 1, 0, 0.248655,-0.00571613) , 
1, -0.960884, 1, 0, 0.255924,0.00388067)    );
  // itree = 389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.552632,-0.0154928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386792,-0.0157099) , 
3, -1.5361, 1, 0, 0.472727,0.0653829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341424,-0.00274848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125324,-0.0111014) , 
1, 0.13822, 1, 0, 0.200563,-0.0177581) , 
1, -1.00949, 1, 0, 0.230576,-0.00858964)    );
  // itree = 390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292035,-0.0145913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217195,0.000294703) , 
0, -0.721902, 1, 0, 0.242515,0.0327969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446809,0.0224797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235849,0.00493954) , 
0, -0.835376, 1, 0, 0.258608,-0.0229666) , 
1, -0.0869251, 1, 0, 0.253165,-0.00410581)    );
  // itree = 391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0840872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292818,0.0255219) , 
0, -1.23727, 1, 0, 0.23348,-0.0204083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244138,-0.0151605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288018,-0.00927474) , 
0, 0.762734, 1, 0, 0.260569,0.0311079) , 
3, -0.287516, 1, 0, 0.24867,0.00847763)    );
  // itree = 392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229268,0.0044585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148837,-0.0307954) , 
0, 0.348533, 1, 0, 0.2016,-0.0101021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.766917,0.0267805) , 
3, 1.75738, 1, 0, 0.239044,-0.00500609)    );
  // itree = 393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.556886,0.0102672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227694,0.00112006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.00430458) , 
3, 1.94262, 1, 0, 0.220348,-0.00447162) , 
1, -1.11945, 1, 0, 0.248379,0.00323291)    );
  // itree = 394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393832,0.00992134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128788,-0.00593507) , 
3, 0.0167245, 1, 0, 0.291758,0.0180494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0678732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235566,-0.00208932) , 
2, 0.0478907, 1, 0, 0.167712,-0.0275426) , 
1, 1.01701, 1, 0, 0.252364,0.00357074)    );
  // itree = 395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0787302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305921,0.0249509) , 
0, 0.304973, 1, 0, 0.100432,0.0247676) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.882353,0.0827568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331367,3.92615e-05) , 
2, -0.768628, 1, 0, 0.396357,-0.0214215) , 
1, 0.227361, 1, 0, 0.26455,-0.000848534)    );
  // itree = 396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103448,0.00107367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514793,0.0414912) , 
3, -0.663668, 1, 0, 0.283312,0.0392342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24144,-0.0026888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253247,-0.0500189) , 
0, 1.33696, 1, 0, 0.242846,-0.0132428) , 
1, -0.0220085, 1, 0, 0.257986,0.00639165)    );
  // itree = 397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393342,0.00862099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0659026,-0.0328009) , 
3, -0.0728399, 1, 0, 0.294828,0.0238225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258317,0.00226061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.004088) , 
3, 0.83004, 1, 0, 0.197339,-0.030147) , 
0, 0.19327, 1, 0, 0.252182,0.000214124)    );
  // itree = 398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204301,-0.0354708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497154,0.038847) , 
2, -0.20892, 1, 0, 0.346544,-0.0226201) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0830189,-0.0117835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168539,0.00333413) , 
1, 0.351675, 1, 0, 0.143018,0.0239722) , 
3, 0.130099, 1, 0, 0.254942,-0.00165004)    );
  // itree = 399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0782228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377224,0.00392815) , 
1, 0.105579, 1, 0, 0.192377,0.0224619) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39094,0.00726635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205607,-0.0004736) , 
3, 1.08337, 1, 0, 0.326063,-0.020604) , 
0, 0.23336, 1, 0, 0.253096,0.00290198)    );
  // itree = 400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0553936,-0.0201592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34414,0.037631) , 
3, -1.0735, 1, 0, 0.211022,0.0294596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116732,-0.0377726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525751,0.0126327) , 
3, 0.787904, 1, 0, 0.270817,-0.0176854) , 
0, -0.299358, 1, 0, 0.248359,2.07445e-05)    );
  // itree = 401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535948,-0.0047777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272142,-0.000455298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113565,-0.00012032) , 
3, 0.576261, 1, 0, 0.21855,-0.0128638) , 
1, -1.22512, 1, 0, 0.242484,-0.00625477)    );
  // itree = 402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345766,0.00134255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111349,-0.0180025) , 
3, 0.196719, 1, 0, 0.270733,0.0165485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233618,0.00354479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,0.0127854) , 
3, 1.10041, 1, 0, 0.203936,-0.0329893) , 
1, 1.16729, 1, 0, 0.25223,0.00282619)    );
  // itree = 403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0838415,-0.000911309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141204,-0.00899513) , 
3, -0.182818, 1, 0, 0.106618,0.00457459) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501263,0.012739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,0.00717288) , 
3, 1.85051, 1, 0, 0.45262,-0.0286445) , 
1, 0.55924, 1, 0, 0.262972,-0.0104368)    );
  // itree = 404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110517,-0.0117885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609121,0.043151) , 
3, -0.298045, 1, 0, 0.286866,0.0256865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222581,-0.010459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287037,-0.0444656) , 
0, 1.33406, 1, 0, 0.229287,-0.0222529) , 
1, 0.227361, 1, 0, 0.255509,-0.000421075)    );
  // itree = 405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421769,-0.00190468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345006,0.00140639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164021,0.00259613) , 
3, -0.339199, 1, 0, 0.23727,-5.87883e-05) , 
0, -1.41794, 1, 0, 0.250487,0.00517838)    );
  // itree = 406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.587719,0.0441236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267606,-0.00674666) , 
0, -1.31382, 1, 0, 0.410156,-0.0477698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.0329503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237828,0.00786627) , 
0, -0.865908, 1, 0, 0.239082,0.0105479) , 
3, -1.54559, 1, 0, 0.260529,0.00323675)    );
  // itree = 407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20621,-0.00360122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386792,0.0131164) , 
2, 0.795867, 1, 0, 0.242694,-0.0148821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283871,-0.00616595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.0464203) , 
0, 1.17855, 1, 0, 0.284483,0.0361937) , 
3, 0.853537, 1, 0, 0.252208,-0.00325344)    );
  // itree = 408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0901639,0.000944625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.02657,-0.0577807) , 
2, -0.992951, 1, 0, 0.050152,-0.0259018) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437118,0.0199627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238189,-0.011887) , 
1, 1.0361, 1, 0, 0.360965,0.0170785) , 
3, -0.663226, 1, 0, 0.257935,0.00283115)    );
  // itree = 409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385892,-0.00998537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116592,0.0114077) , 
1, 0.699029, 1, 0, 0.300709,0.00830432) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280553,0.0214582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828025,-0.0220371) , 
3, 1.18629, 1, 0, 0.231076,-0.0312705) , 
0, -0.293879, 1, 0, 0.256122,-0.0170357)    );
  // itree = 410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178378,-0.0295515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535354,0.0276138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255661,0.00986694) , 
0, -1.35255, 1, 0, 0.271244,-0.00607254) , 
1, -1.17379, 1, 0, 0.262487,1.36225e-05)    );
  // itree = 411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629085,-0.052797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.669746,0.0457019) , 
1, 1.22294, 1, 0, 0.221485,0.0128141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.613208,0.0483804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302326,0.0203481) , 
2, 1.19222, 1, 0, 0.495601,-0.0377422) , 
0, 1.17201, 1, 0, 0.268268,0.00418563)    );
  // itree = 412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.025641,-0.0465098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585859,0.0877377) , 
3, -1.55664, 1, 0, 0.243137,0.056825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23139,-0.00739582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.855769,0.04378) , 
3, 1.98864, 1, 0, 0.269231,-0.00416888) , 
0, -1.03387, 1, 0, 0.265855,0.00372226)    );
  // itree = 413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467949,-0.00486295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223301,-0.00640811) , 
3, -1.42787, 1, 0, 0.370656,0.0352014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233933,0.00621277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206731,0.0115101) , 
0, 1.36577, 1, 0, 0.230726,-0.010772) , 
0, -1.08742, 1, 0, 0.248641,-0.00488615)    );
  // itree = 414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.0506509) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393665,0.00825478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175064,-0.00271349) , 
3, -0.412408, 1, 0, 0.254089,0.00338646) , 
1, -1.36088, 1, 0, 0.246901,0.00901789)    );
  // itree = 415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154535,-0.00910984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240589,-0.0290747) , 
3, -0.0905164, 1, 0, 0.189495,0.0166617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483974,0.0446888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,-0.0540816) , 
1, 1.0358, 1, 0, 0.400442,-0.055362) , 
0, 0.893748, 1, 0, 0.238241,1.81882e-05)    );
  // itree = 416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0612745,-0.0263228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39039,0.0261919) , 
3, -0.730312, 1, 0, 0.209177,0.0097501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0775862,-0.0448908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49543,0.00446916) , 
3, 0.536741, 1, 0, 0.261464,-0.0204647) , 
0, -0.305233, 1, 0, 0.241935,-0.00917985)    );
  // itree = 417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282671,0.00262859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682927,-0.0345346) , 
2, 1.36291, 1, 0, 0.260041,-0.00682147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0925926,-0.0122495) , 
3, 1.90896, 1, 0, 0.25122,-0.00137525)    );
  // itree = 418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138554,-0.0440549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343137,-0.0158079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226032,-0.000375933) , 
0, -1.03521, 1, 0, 0.23946,0.00160379) , 
1, -1.17379, 1, 0, 0.230848,0.00768699)    );
  // itree = 419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0552883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256267,0.0102244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256739,-0.0189823) , 
3, 0.259999, 1, 0, 0.256466,-0.00756488) , 
1, -1.36088, 1, 0, 0.242378,-0.00256579)    );
  // itree = 420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.0397595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412429,0.0616006) , 
3, -1.78014, 1, 0, 0.269504,0.0613455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124803,-0.0193959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515936,0.0102856) , 
3, 0.838384, 1, 0, 0.23586,-0.00917642) , 
1, -0.840753, 1, 0, 0.240488,0.000524646)    );
  // itree = 421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365828,-0.00243009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146138,-0.00616992) , 
3, 0.208261, 1, 0, 0.292394,0.00866047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670732,-0.00763466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121547,0.0107113) , 
0, 0.460404, 1, 0, 0.086444,-0.021553) , 
1, 1.2017, 1, 0, 0.238414,0.000741497)    );
  // itree = 422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402516,0.00675119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263755,0.00341759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195349,-0.00466796) , 
1, 0.967289, 1, 0, 0.239106,-0.00454957) , 
0, -1.37002, 1, 0, 0.252437,0.00221207)    );
  // itree = 423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0782835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253571,0.0115716) , 
0, 0.286126, 1, 0, 0.0788889,0.0166974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416327,-0.00289429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272109,0.0174907) , 
3, 1.2106, 1, 0, 0.375121,-0.0117575) , 
1, 0.262441, 1, 0, 0.23691,0.00151849)    );
  // itree = 424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23913,0.0535715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166546,-0.012069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.540541,0.0122547) , 
3, 0.883159, 1, 0, 0.268562,-0.00344461) , 
1, -1.19679, 1, 0, 0.266568,0.00109421)    );
  // itree = 425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359375,-0.0113772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314233,0.000316308) , 
0, -0.525496, 1, 0, 0.336182,-0.00900174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,-0.0236382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21322,0.0228881) , 
0, 0.665039, 1, 0, 0.150265,0.0267178) , 
3, -0.0237104, 1, 0, 0.248248,0.00789265)    );
  // itree = 426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246723,-0.00638221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0829968) , 
3, 1.18059, 1, 0, 0.229226,0.00639593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447977,0.038142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147826,-0.00122317) , 
3, 1.02663, 1, 0, 0.328125,-0.02394) , 
2, 0.684444, 1, 0, 0.258114,-0.00246487)    );
  // itree = 427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0956522,-0.00520293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313333,0.0262202) , 
0, -0.607418, 1, 0, 0.218868,-0.0150405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.862745,0.105656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199544,-0.0295812) , 
2, -0.760103, 1, 0, 0.268641,0.014114) , 
3, 0.00608752, 1, 0, 0.242766,-0.00104234)    );
  // itree = 428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0822981,-0.0220659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367432,0.0287343) , 
3, -0.386153, 1, 0, 0.203918,0.00965665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148862,-0.0456168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643411,0.0102802) , 
3, 1.26748, 1, 0, 0.302774,-0.0335967) , 
2, 0.349516, 1, 0, 0.245902,-0.00871274)    );
  // itree = 429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363636,-0.00592751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306859,-0.00166767) , 
0, -0.564389, 1, 0, 0.334267,-0.0129285) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703125,-0.0319277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186691,0.00637246) , 
0, 0.401514, 1, 0, 0.138378,0.0249439) , 
3, -0.0237104, 1, 0, 0.243487,0.0046226)    );
  // itree = 430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398936,0.00452221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212025,-0.00489514) , 
3, -1.02608, 1, 0, 0.265106,0.022774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0147059,-0.07017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26494,0.0131978) , 
2, -0.393144, 1, 0, 0.211599,-0.0231085) , 
1, 0.967289, 1, 0, 0.247706,0.00785399)    );
  // itree = 431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149055,-0.00375831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224771,0.000619828) , 
3, -0.0546649, 1, 0, 0.18094,0.00304469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.728261,0.0600842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22807,-0.0655383) , 
1, 1.53311, 1, 0, 0.536913,-0.0315927) , 
1, 1.29547, 1, 0, 0.2605,-0.00469677)    );
  // itree = 432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.027027,-0.0368603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314516,0.0451672) , 
3, -1.64328, 1, 0, 0.219031,0.0415207) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682451,-0.039172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43828,0.00146205) , 
3, 0.321796, 1, 0, 0.253648,-0.016968) , 
0, -0.571715, 1, 0, 0.243988,-0.000646263)    );
  // itree = 433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543011,-0.00982117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298569,0.00376652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132701,0.000621903) , 
3, 0.196496, 1, 0, 0.221734,-0.008914) , 
1, -1.17379, 1, 0, 0.251494,-0.00355212)    );
  // itree = 434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382763,0.00387237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150706,-0.00273263) , 
3, -0.236145, 1, 0, 0.279102,0.0128334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193416,-0.0111736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18648,-0.00108859) , 
0, -0.133691, 1, 0, 0.188988,-0.026367) , 
1, 1.01111, 1, 0, 0.250238,0.000277294)    );
  // itree = 435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0755974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482456,-0.0445583) , 
3, -2.06657, 1, 0, 0.0335366,0.0476562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311837,0.00391946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265625,-0.00370609) , 
3, 0.750697, 1, 0, 0.297445,-0.00786851) , 
0, -0.920459, 1, 0, 0.25355,0.00136684)    );
  // itree = 436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284055,0.0159951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12938,-0.0288785) , 
1, 1.02141, 1, 0, 0.240516,0.00667418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.024,-0.034274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307107,-0.033922) , 
3, 0.2518, 1, 0, 0.197205,-0.0477858) , 
0, 0.596152, 1, 0, 0.2263,-0.0112016)    );
  // itree = 437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320149,-0.00541465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.091354,-0.000947722) , 
1, 0.967289, 1, 0, 0.248336,-0.00635136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152381,0.0281463) , 
3, 1.98981, 1, 0, 0.24344,-0.000908473)    );
  // itree = 438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467641,0.0282038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165663,-0.0120126) , 
3, -0.757731, 1, 0, 0.292213,0.0188722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281553,0.0134401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118056,0.00445289) , 
3, 1.67954, 1, 0, 0.254335,-0.0378417) , 
1, 0.589589, 1, 0, 0.275896,-0.00555885)    );
  // itree = 439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00561798,-0.0660721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30506,0.0342627) , 
1, -0.993154, 1, 0, 0.242353,-0.0215267) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221298,-0.0233551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,-0.0165072) , 
0, 0.566045, 1, 0, 0.242769,0.00991289) , 
3, -0.412408, 1, 0, 0.242592,-0.00350932)    );
  // itree = 440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109623,-0.0133802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460212,0.0132234) , 
3, 0.191205, 1, 0, 0.245254,0.00225627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34188,-0.0381543) , 
2, 1.76296, 1, 0, 0.250726,-0.00206871)    );
  // itree = 441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393789,-0.00326223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174263,0.0137566) , 
1, 0.170313, 1, 0, 0.288201,0.00863667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0926829,-0.0313686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701107,-0.03087) , 
2, 1.45607, 1, 0, 0.0798319,-0.042156) , 
2, 1.04395, 1, 0, 0.23927,-0.00329096)    );
  // itree = 442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56701,0.0481813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405941,0.00417331) , 
3, -1.92992, 1, 0, 0.484848,0.052986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253036,0.000689526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187668,-0.0129261) , 
1, 0.778171, 1, 0, 0.224913,-0.0092556) , 
0, -1.16507, 1, 0, 0.251553,-0.0028768)    );
  // itree = 443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0774703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0258621,-0.0430755) , 
3, -1.63983, 1, 0, 0.0116279,0.0408993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262036,0.00141847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491961,0.0397016) , 
0, 1.17773, 1, 0, 0.30255,-0.0158125) , 
0, -1.11841, 1, 0, 0.265447,-0.00857988)    );
  // itree = 444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113122,-0.00586529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483734,0.0214143) , 
3, 0.191205, 1, 0, 0.257726,0.0131873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330935,-0.031745) , 
2, 1.76296, 1, 0, 0.262942,0.00779803)    );
  // itree = 445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421769,8.43197e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169374,-0.0151739) , 
3, -0.0241086, 1, 0, 0.328473,0.0121284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119883,0.00945489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107884,-0.00110675) , 
2, 0.448492, 1, 0, 0.112864,-0.028899) , 
1, 0.634693, 1, 0, 0.239196,-0.00485984)    );
  // itree = 446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294895,0.000763153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.023622,-0.0688043) , 
3, 1.23305, 1, 0, 0.258989,-0.0017092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391608,0.0775602) , 
1, 1.59889, 1, 0, 0.268186,-0.00675041)    );
  // itree = 447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100233,0.0038438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319287,0.0185991) , 
0, -0.606521, 1, 0, 0.229446,-0.010073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25117,-0.020792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303977,-0.00728793) , 
0, 1.01986, 1, 0, 0.269889,0.0373801) , 
3, -0.0237104, 1, 0, 0.249142,0.0130368)    );
  // itree = 448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0888626,-0.020472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.497297,0.0239376) , 
3, -0.0216656, 1, 0, 0.250894,0.00774111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0238095,-0.08012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309463,-0.0126565) , 
2, -0.0957714, 1, 0, 0.239845,-0.0349545) , 
0, 0.823264, 1, 0, 0.247912,-0.00377958)    );
  // itree = 449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356953,0.0124143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115578,-0.000949852) , 
3, 0.253475, 1, 0, 0.273465,0.0061786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113924,-0.033076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188679,0.0047855) , 
0, 1.56076, 1, 0, 0.143939,-0.0437805) , 
0, 1.31913, 1, 0, 0.256281,-0.000449132)    );
  // itree = 450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39759,0.00967446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207254,-0.00209158) , 
0, -0.571111, 1, 0, 0.2738,0.0217158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220698,-0.010214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0474826) , 
3, 1.84099, 1, 0, 0.200438,-0.0176672) , 
1, 0.583399, 1, 0, 0.241905,0.00459359)    );
  // itree = 451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0408805,0.0128121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109589,-0.00245097) , 
3, -1.06656, 1, 0, 0.0806878,0.0195438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377,0.00204403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20524,0.0173364) , 
3, 1.46145, 1, 0, 0.344996,-0.011241) , 
1, -0.0488099, 1, 0, 0.244332,0.000483609)    );
  // itree = 452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0979782,0.000375551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.569002,0.0293336) , 
3, -0.312713, 1, 0, 0.297127,0.0265252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0777778,-0.0583759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201794,-0.016666) , 
0, -0.544524, 1, 0, 0.175501,-0.0317777) , 
1, 0.606857, 1, 0, 0.244524,0.00130909)    );
  // itree = 453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353846,-0.0157092) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334243,-0.00412945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168787,0.00556332) , 
3, -0.390732, 1, 0, 0.232218,-0.00475674) , 
0, -1.50708, 1, 0, 0.239961,0.00140307)    );
  // itree = 454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340741,-0.00268297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12439,0.000162307) , 
3, 0.278674, 1, 0, 0.275277,-0.00136047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186312,-0.0179084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17931,-0.0106385) , 
0, -0.133691, 1, 0, 0.181948,-0.0338057) , 
1, 0.963355, 1, 0, 0.243546,-0.0123915)    );
  // itree = 455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0347826,-0.0350603) , 
3, -1.61628, 1, 0, 0.0150376,0.0569008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303805,0.00240385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0784043) , 
3, 1.94691, 1, 0, 0.285966,-0.0052447) , 
0, -0.98707, 1, 0, 0.249365,0.00315078)    );
  // itree = 456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203125,0.069079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.065513,-0.0258723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411361,0.00791035) , 
3, -0.18417, 1, 0, 0.25847,-0.00044195) , 
1, -1.34521, 1, 0, 0.254852,0.00469487)    );
  // itree = 457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403566,0.00323823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260943,-0.00798174) , 
0, -0.102838, 1, 0, 0.333609,0.0127426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992908,-0.00580996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133034,0.01886) , 
0, -0.60918, 1, 0, 0.12716,-0.0261485) , 
1, 0.670673, 1, 0, 0.250866,-0.00284465)    );
  // itree = 458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446483,0.0107869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209832,-0.00499073) , 
3, -1.27624, 1, 0, 0.276486,0.0127706) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191667,-0.033527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210287,-0.0037992) , 
0, -0.420859, 1, 0, 0.205327,-0.0232622) , 
1, 0.552807, 1, 0, 0.245393,-0.00297408)    );
  // itree = 459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0860284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280899,-0.00399126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18125,0.0268567) , 
3, 1.66048, 1, 0, 0.272285,-0.00567037) , 
0, -1.26434, 1, 0, 0.249012,5.8566e-05)    );
  // itree = 460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24359,0.000835132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101562,-0.0511625) , 
1, 1.29989, 1, 0, 0.215535,-0.0119577) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825243,0.0357055) , 
3, 2.01752, 1, 0, 0.246214,-0.00709816)    );
  // itree = 461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423687,0.0121565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143123,-0.0332814) , 
2, 0.211667, 1, 0, 0.312454,0.0132261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0174219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101408,0.00904093) , 
3, 0.487448, 1, 0, 0.0902141,-0.0353926) , 
1, 1.01701, 1, 0, 0.240179,-0.00258524)    );
  // itree = 462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282528,-0.0205929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,-0.0105716) , 
0, -0.600975, 1, 0, 0.227545,0.0216506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27865,0.00825467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.0284615) , 
3, 1.86511, 1, 0, 0.261905,-0.0156259) , 
1, -0.136427, 1, 0, 0.25073,-0.00350285)    );
  // itree = 463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0767124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203716,-0.0124367) , 
1, -1.35371, 1, 0, 0.189258,0.0141132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540052,0.0269701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0353982,-0.036798) , 
3, 1.81641, 1, 0, 0.426,-0.0439688) , 
0, 0.823264, 1, 0, 0.246609,4.29017e-05)    );
  // itree = 464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0566038,-0.00157683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434783,0.078222) , 
3, -2.0085, 1, 0, 0.253394,0.0675693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28988,0.0109923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233745,-0.0132954) , 
1, -0.00759721, 1, 0, 0.251947,-0.00703141) , 
0, -1.2692, 1, 0, 0.252105,0.00113439)    );
  // itree = 465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365455,0.00580126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0605505,-0.0254122) , 
1, 0.967289, 1, 0, 0.264438,0.00865584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202128,0.00895616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.0380612) , 
1, 0.78562, 1, 0, 0.198135,-0.0424033) , 
0, 1.00007, 1, 0, 0.250723,-0.00190558)    );
  // itree = 466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361564,-0.00357161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286778,-0.00178404) , 
0, -0.316849, 1, 0, 0.326672,-0.0128486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100703,-0.0153918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207373,0.0219641) , 
1, 0.940464, 1, 0, 0.154472,0.0294074) , 
3, 0.204118, 1, 0, 0.252982,0.00523414)    );
  // itree = 467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0763436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0151515,-0.0707363) , 
3, -1.61797, 1, 0, 0.00729927,0.03567) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28681,-0.0048523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257611,-5.50311e-05) , 
2, 0.971345, 1, 0, 0.279607,-0.00989033) , 
0, -1.08742, 1, 0, 0.242394,-0.00366413)    );
  // itree = 468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267943,0.052067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198691,-0.0136127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813953,0.0303083) , 
3, 1.83189, 1, 0, 0.242541,-0.0124851) , 
0, -1.16672, 1, 0, 0.245171,-0.00419486)    );
  // itree = 469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435028,0.0139362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327155,0.0101131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12336,0.000923047) , 
3, 0.312683, 1, 0, 0.242803,-0.00803063) , 
0, -1.38006, 1, 0, 0.259663,-0.00176521)    );
  // itree = 470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281857,-0.00514652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550129,0.0500694) , 
2, 0.321549, 1, 0, 0.361217,-0.00850323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0800029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131481,-0.00626141) , 
2, -0.312342, 1, 0, 0.107739,0.0407403) , 
3, 0.496563, 1, 0, 0.276596,0.00793623)    );
  // itree = 471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0533708,0.0176696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100196,-0.0159566) , 
3, -1.01241, 1, 0, 0.0809249,0.0203496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.759358,0.0613236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271459,-0.0212326) , 
2, -0.393144, 1, 0, 0.352994,-0.0199004) , 
1, 0.222196, 1, 0, 0.234375,-0.00235191)    );
  // itree = 472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103896,-0.0046474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587209,0.0450269) , 
3, -0.679984, 1, 0, 0.277083,0.0304344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192248,-0.00880364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.693252,0.0160732) , 
3, 1.66747, 1, 0, 0.248451,-0.00558754) , 
1, -0.414392, 1, 0, 0.255561,0.00335737)    );
  // itree = 473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401408,-0.00614274) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333755,-0.00746227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165766,0.00638423) , 
3, -0.337222, 1, 0, 0.235665,-0.0117957) , 
0, -1.50708, 1, 0, 0.247186,-0.00711255)    );
  // itree = 474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.089172,-0.0773612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445312,0.0160803) , 
2, -1.26272, 1, 0, 0.361734,-0.0237536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167257,-0.011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34466,0.0327049) , 
2, 1.53332, 1, 0, 0.194611,0.0245525) , 
3, -0.692859, 1, 0, 0.250374,0.00843442)    );
  // itree = 475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0815247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.593434,0.0316547) , 
1, 0.822487, 1, 0, 0.195345,0.0127442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420233,0.00446963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210714,-0.0102314) , 
3, 1.08337, 1, 0, 0.346348,-0.0227718) , 
0, 0.349172, 1, 0, 0.255383,-0.00137683)    );
  // itree = 476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223776,0.0678655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262295,0.00284771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249235,-0.0140991) , 
0, 0.58187, 1, 0, 0.257737,-0.00518002) , 
0, -1.43147, 1, 0, 0.25533,0.000790857)    );
  // itree = 477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393524,0.00805689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767196,-0.00724356) , 
1, 0.835395, 1, 0, 0.292125,0.0117857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406897,0.0220572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159527,-0.00353697) , 
1, -0.183049, 1, 0, 0.203163,-0.0234465) , 
0, 0.29569, 1, 0, 0.255617,-0.00267301)    );
  // itree = 478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434426,0.00806409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246305,-0.012603) , 
3, -1.32286, 1, 0, 0.316923,0.0241814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297483,0.0135822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964567,-0.015901) , 
3, 0.788668, 1, 0, 0.223589,-0.0160994) , 
0, -0.427027, 1, 0, 0.253445,-0.00321429)    );
  // itree = 479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189895,0.0126483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265568,0.00766849) , 
2, -0.212049, 1, 0, 0.226786,-0.0132337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182994,-0.0118305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435583,0.00508487) , 
1, 1.20213, 1, 0, 0.27797,0.0190986) , 
3, 0.159145, 1, 0, 0.249119,0.000874053)    );
  // itree = 480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241667,0.0588471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,-0.0208443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419679,0.00743451) , 
3, -0.109025, 1, 0, 0.2577,-0.00218449) , 
0, -1.50708, 1, 0, 0.25677,0.00198292)    );
  // itree = 481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369128,-0.00605279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305243,-0.00304317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117722,-0.00399312) , 
3, 0.273196, 1, 0, 0.225511,0.00764837) , 
0, -1.39419, 1, 0, 0.236173,0.0125183)    );
  // itree = 482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201465,-0.0363355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506903,0.0351929) , 
2, -0.212049, 1, 0, 0.348528,-0.0215862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.081066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,0.0073919) , 
2, -0.766625, 1, 0, 0.153846,0.0173879) , 
3, -0.0237104, 1, 0, 0.254287,-0.00271979)    );
  // itree = 483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178161,-0.000703016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264762,-0.00989348) , 
2, -0.00924307, 1, 0, 0.215397,-0.00269728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.852632,0.0971468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182292,-0.0252417) , 
2, -0.490075, 1, 0, 0.277198,0.0299908) , 
3, 0.46408, 1, 0, 0.237315,0.00889558)    );
  // itree = 484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0438871,-0.027632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271429,0.0377993) , 
3, -1.01515, 1, 0, 0.16293,0.02005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144391,-0.0261825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594883,0.00724304) , 
3, 0.759316, 1, 0, 0.306044,-0.0135037) , 
2, -0.394071, 1, 0, 0.257591,-0.00214367)    );
  // itree = 485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378109,0.00153308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182482,0.0151442) , 
3, -0.117183, 1, 0, 0.298817,0.0034875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00934579,-0.0763912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102484,-0.0167606) , 
0, 0.0685437, 1, 0, 0.0792541,-0.0401385) , 
2, 1.04095, 1, 0, 0.254365,-0.00534476)    );
  // itree = 486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32713,0.00362467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129794,-0.020715) , 
0, 0.823646, 1, 0, 0.277941,0.0130738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251037,0.00744148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0967742,-0.0143647) , 
3, 1.64518, 1, 0, 0.219472,-0.0283591) , 
1, 1.01701, 1, 0, 0.259919,0.000302539)    );
  // itree = 487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107066,-0.0176057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367397,0.0383095) , 
0, -0.502377, 1, 0, 0.228929,-0.0248439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.839286,0.0888627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211066,-0.0150247) , 
2, -0.860478, 1, 0, 0.275735,0.0111027) , 
3, -0.305034, 1, 0, 0.254832,-0.00495074)    );
  // itree = 488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923379,-0.0205673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437731,0.0163778) , 
3, -0.0297747, 1, 0, 0.245489,0.00305756) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261261,-0.0223974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32381,-0.0495741) , 
0, 1.06051, 1, 0, 0.291667,-0.0658916) , 
2, 1.5418, 1, 0, 0.250367,-0.0042251)    );
  // itree = 489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387879,0.00393989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191332,0.014414) , 
3, -0.357048, 1, 0, 0.282891,0.00303446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131148,-0.0285403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137615,-0.00678975) , 
2, 1.00933, 1, 0, 0.134199,-0.0511764) , 
0, 1.31913, 1, 0, 0.265734,-0.00322064)    );
  // itree = 490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413043,0.00995111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248645,0.00171266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.01,-0.0774337) , 
3, 1.9249, 1, 0, 0.235094,-0.00821788) , 
0, -1.26434, 1, 0, 0.251928,-0.00235236)    );
  // itree = 491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0785572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251042,0.0160907) , 
0, -1.63092, 1, 0, 0.222942,-0.0198618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15544,-0.0174079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427822,0.00482319) , 
1, 1.09844, 1, 0, 0.263542,0.0109984) , 
3, -0.0237104, 1, 0, 0.242038,-0.00534651)    );
  // itree = 492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248067,0.0154044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130522,-0.0341) , 
0, 0.695205, 1, 0, 0.217595,0.00475343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.761905,0.0219759) , 
3, 1.73078, 1, 0, 0.266351,0.00915301)    );
  // itree = 493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417323,-0.00153952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308588,0.0085579) , 
0, -0.318533, 1, 0, 0.354812,0.00924489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947712,0.00682843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117308,0.00110323) , 
0, -0.127877, 1, 0, 0.108959,-0.0165555) , 
1, 0.71227, 1, 0, 0.25433,-0.00129997)    );
  // itree = 494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389809,0.00688663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168498,-0.013393) , 
3, -0.439427, 1, 0, 0.276808,0.0041963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-7.31336e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212389,0.0279208) , 
0, 1.55477, 1, 0, 0.177062,-0.0481763) , 
0, 0.893748, 1, 0, 0.253213,-0.00819266)    );
  // itree = 495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226135,-0.00595731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.647887,0.0773067) , 
3, 1.01104, 1, 0, 0.26831,0.00801178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292271,-0.00656418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970874,-0.0147049) , 
3, 1.38367, 1, 0, 0.227419,-0.0434554) , 
2, 0.690799, 1, 0, 0.255882,-0.00763022)    );
  // itree = 496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262376,0.0484581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249264,-0.00233415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252427,-0.0236722) , 
0, 0.330568, 1, 0, 0.250678,-0.0172769) , 
0, -1.24826, 1, 0, 0.251834,-0.0094447)    );
  // itree = 497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.581395,0.00660541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295455,-0.000785969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150303,0.00840705) , 
3, 0.109967, 1, 0, 0.230267,-0.00865163) , 
1, -1.19679, 1, 0, 0.260329,-0.00294821)    );
  // itree = 498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305344,-0.00963179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283224,-0.0673352) , 
3, -0.33724, 1, 0, 0.191203,0.0183109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432177,0.0405538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135849,0.0085924) , 
3, 1.1807, 1, 0, 0.344828,-0.0183356) , 
2, 0.324939, 1, 0, 0.259811,0.00194469)    );
  // itree = 499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0809629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584615,0.0186884) , 
1, 0.853731, 1, 0, 0.194539,0.0097788) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394347,0.0107681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0431034,-0.0186464) , 
3, 1.864, 1, 0, 0.346915,-0.0302031) , 
0, 0.277782, 1, 0, 0.258986,-0.00713133)    );
  // itree = 500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130682,0.0194841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0511628,-0.0483333) , 
2, -0.747755, 1, 0, 0.0792377,-0.0195743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381688,0.00508862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.865979,0.0492263) , 
3, 1.95608, 1, 0, 0.43177,0.0204623) , 
3, -0.100579, 1, 0, 0.250129,-0.000166408)    );
  // itree = 501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596026,-0.00124491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,-0.0103208) , 
3, -1.56559, 1, 0, 0.450839,0.0459703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252886,0.000487106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122888,0.00551924) , 
3, 0.422986, 1, 0, 0.200125,-0.013157) , 
1, -0.598428, 1, 0, 0.251856,-0.000957065)    );
  // itree = 502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543046,0.0363786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262136,-0.0221067) , 
3, -1.64337, 1, 0, 0.380952,0.0178002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239556,0.00169952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,-0.00532553) , 
3, 1.86984, 1, 0, 0.230392,-0.0147706) , 
0, -0.805343, 1, 0, 0.257416,-0.00892458)    );
  // itree = 503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963705,-0.0139373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148707,-0.0119563) , 
3, 0.0388081, 1, 0, 0.115598,0.0118135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.657895,0.0377954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453089,0.00172645) , 
0, -0.0437222, 1, 0, 0.537112,-0.0327888) , 
1, 0.924475, 1, 0, 0.271457,-0.00467865)    );
  // itree = 504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0464135,-0.0301889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404788,0.0189954) , 
3, -0.875301, 1, 0, 0.282843,0.014705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,-0.0563505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,-0.000254098) , 
2, 0.324469, 1, 0, 0.185801,-0.0182754) , 
1, 1.01701, 1, 0, 0.251582,0.00408064)    );
  // itree = 505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490741,-0.00484964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231405,-0.0256042) , 
3, -1.885, 1, 0, 0.353712,0.0512025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264368,0.00572769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104575,-0.00669682) , 
2, 1.32298, 1, 0, 0.236975,-0.0133241) , 
0, -1.11841, 1, 0, 0.250248,-0.00598717)    );
  // itree = 506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325688,-0.00309848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251265,-0.000959693) , 
0, -0.0627038, 1, 0, 0.295563,-0.0143282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0792486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121065,-0.0104957) , 
2, 0.114779, 1, 0, 0.0943396,0.0129971) , 
3, 0.842503, 1, 0, 0.242105,-0.00706881)    );
  // itree = 507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201742,-0.0106311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337719,0.0261375) , 
2, 1.14071, 1, 0, 0.221046,-0.00591553) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576208,0.0506372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0606061,-0.0805945) , 
0, 1.65081, 1, 0, 0.4375,-0.038344) , 
0, 1.15958, 1, 0, 0.261398,-0.011961)    );
  // itree = 508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162963,0.0560879) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0935673,-0.0236342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.467254,0.00609134) , 
3, 0.196716, 1, 0, 0.256593,-0.00709162) , 
0, -1.61795, 1, 0, 0.250128,-0.00269506)    );
  // itree = 509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.516484,-0.0233163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420168,0.00713957) , 
3, -1.6889, 1, 0, 0.45269,0.0269469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22407,0.00424768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113164,0.00719592) , 
3, 0.883159, 1, 0, 0.191065,-0.0086874) , 
1, -0.363096, 1, 0, 0.261785,0.000944937)    );
  // itree = 510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389313,-0.00280566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209259,-0.00626516) , 
0, -1.09189, 1, 0, 0.234325,-0.00674374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401515,0.0570348) , 
2, 1.7672, 1, 0, 0.245283,-0.0122609)    );
  // itree = 511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118825,-0.0266907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375576,0.020427) , 
0, -0.0674897, 1, 0, 0.213018,-0.0124131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307914,-0.00823209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777205) , 
3, 1.95728, 1, 0, 0.26817,0.0311621) , 
3, 0.256333, 1, 0, 0.235235,0.00514016)    );
  // itree = 512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458015,-0.0227887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485149,0.0777884) , 
3, -1.7172, 1, 0, 0.237069,0.0520191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270154,0.00135948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173004,-0.0234387) , 
1, 1.13864, 1, 0, 0.239953,-0.0079561) , 
0, -1.09323, 1, 0, 0.239605,-0.000724169)    );
  // itree = 513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392857,0.00482789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0838323,-0.00230367) , 
1, 0.921611, 1, 0, 0.284211,0.000367498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205056,-0.00201035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.00179687) , 
3, 1.59951, 1, 0, 0.182,-0.0268204) , 
0, 0.803447, 1, 0, 0.257662,-0.0066943)    );
  // itree = 514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20839,-0.0283318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.505747,0.0380423) , 
2, -0.0309313, 1, 0, 0.331483,-0.0128614) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670996,-0.0403489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15748,0.0111147) , 
0, 0.990244, 1, 0, 0.099162,0.0237562) , 
3, 0.414913, 1, 0, 0.247344,0.000400232)    );
  // itree = 515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157212,0.0209687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216368,-0.0170191) , 
3, -0.601983, 1, 0, 0.19218,0.0143575) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555825,0.0382898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.078432) , 
3, 1.89073, 1, 0, 0.443798,-0.0517186) , 
0, 0.823264, 1, 0, 0.256296,-0.00247965)    );
  // itree = 516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216301,0.0213702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0995851,-0.0378419) , 
0, -0.326146, 1, 0, 0.154298,-0.00686264) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135922,-0.0317374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606195,0.0232444) , 
2, -0.312342, 1, 0, 0.518919,0.0325444) , 
3, 0.766583, 1, 0, 0.259916,0.00455223)    );
  // itree = 517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300313,0.00478894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.045977,-0.0504323) , 
2, 1.28926, 1, 0, 0.275297,-0.00460298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.000554836) , 
3, 1.61709, 1, 0, 0.258295,-0.0129942)    );
  // itree = 518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249226,-0.00755251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307018,0.00737469) , 
2, 1.32418, 1, 0, 0.253912,0.00779925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206349,-0.00162775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189076,-0.00427982) , 
0, -0.550681, 1, 0, 0.192691,-0.0303268) , 
1, 1.09808, 1, 0, 0.235558,-0.00363097)    );
  // itree = 519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163763,0.00617016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.00998167) , 
2, -0.334974, 1, 0, 0.219178,-0.00919845) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293447,-0.00948482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28866,-0.00529046) , 
0, 1.2583, 1, 0, 0.292411,0.0372896) , 
3, 0.174619, 1, 0, 0.250969,0.0109824)    );
  // itree = 520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116414,-0.0100908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495528,0.0220584) , 
3, -0.0909164, 1, 0, 0.265867,0.0103561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184035,-0.023587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306931,-0.0560367) , 
2, 1.69307, 1, 0, 0.206522,-0.043174) , 
0, 0.740359, 1, 0, 0.249239,-0.00464321)    );
  // itree = 521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366957,-0.00832076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22,0.00911809) , 
3, -0.826658, 1, 0, 0.268986,0.00295049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144144,0.0582858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165217,0.0420699) , 
3, 0.823116, 1, 0, 0.154867,-0.0492582) , 
1, 1.49547, 1, 0, 0.255766,-0.00309726)    );
  // itree = 522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,0.00503369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673077,-0.0541011) , 
3, -0.681687, 1, 0, 0.208654,0.0111223) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429091,0.0297002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.00162494) , 
3, 0.971008, 1, 0, 0.31377,-0.0361359) , 
2, 0.324939, 1, 0, 0.257009,-0.0106174)    );
  // itree = 523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133098,-0.0240692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510345,0.0443098) , 
0, 0.289115, 1, 0, 0.229148,-0.00816291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,-0.0100447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2843,-0.0138964) , 
1, 0.098775, 1, 0, 0.262202,0.0244323) , 
3, 0.15517, 1, 0, 0.243564,0.00605312)    );
  // itree = 524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230687,0.0210928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225676,-0.00672386) , 
0, 0.0295793, 1, 0, 0.228469,0.0114798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198347,-0.0773015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383621,0.000330722) , 
0, 0.258751, 1, 0, 0.320113,-0.0364158) , 
2, 1.16615, 1, 0, 0.244444,0.00313057)    );
  // itree = 525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.575758,-0.00119618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0743802,-0.074893) , 
1, -0.400748, 1, 0, 0.38558,-0.0394966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244618,0.00834729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.0237584) , 
3, 1.8332, 1, 0, 0.231321,6.94185e-05) , 
3, -1.36119, 1, 0, 0.256024,-0.00626671)    );
  // itree = 526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373016,-0.0132366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271726,0.00770452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0574163,-0.0308346) , 
3, 1.58497, 1, 0, 0.247423,-0.00443618) , 
0, -1.45662, 1, 0, 0.25546,0.000685587)    );
  // itree = 527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0782305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0222791) , 
1, -1.34315, 1, 0, 0.218954,-0.0202259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277718,-0.0193738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276596,-0.0119431) , 
0, 1.44922, 1, 0, 0.27757,0.0201014) , 
3, -0.227317, 1, 0, 0.250503,0.00147944)    );
  // itree = 528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00510204,-0.072691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325733,0.02477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247829,-0.0108585) , 
0, -0.720403, 1, 0, 0.261086,-0.00648971) , 
3, -1.7782, 1, 0, 0.236,-0.0105988)    );
  // itree = 529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291457,-0.0307773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34004,-0.0133456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204441,0.0101141) , 
3, -0.698741, 1, 0, 0.241819,-0.00969169) , 
0, -1.2692, 1, 0, 0.246753,-0.00424486)    );
  // itree = 530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318318,-0.00303005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254386,0.0102367) , 
0, 0.0942167, 1, 0, 0.292335,0.000563565) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0820038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126168,-0.00488382) , 
2, 0.646204, 1, 0, 0.0838509,-0.0836851) , 
3, 1.20529, 1, 0, 0.258853,-0.0129666)    );
  // itree = 531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0832589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292388,-0.00156287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0772648) , 
3, 1.94691, 1, 0, 0.275394,-0.00737251) , 
0, -1.2692, 1, 0, 0.250618,-0.0034971)    );
  // itree = 532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163529,0.00612478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0475059,-0.0586608) , 
2, 0.209914, 1, 0, 0.125098,-0.0106773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,-0.0373141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565934,0.0255527) , 
2, -0.128483, 1, 0, 0.495495,0.0341421) , 
3, 0.471159, 1, 0, 0.252452,0.004733)    );
  // itree = 533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557769,0.0261343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255435,-0.0209092) , 
2, -1.00915, 1, 0, 0.349938,-0.0216108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240152,0.00904957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109474,0.0126027) , 
1, 1.09668, 1, 0, 0.190967,0.0115185) , 
3, -0.435343, 1, 0, 0.252784,-0.00136422)    );
  // itree = 534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381182,0.0110455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123232,-0.00253265) , 
3, 0.0661164, 1, 0, 0.284743,0.0154375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21,-0.00718114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216625,0.0026794) , 
0, -0.0392497, 1, 0, 0.213773,-0.0408716) , 
1, 0.939437, 1, 0, 0.260267,-0.00398231)    );
  // itree = 535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802603,-0.0283819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205021,0.0224595) , 
2, 0.626163, 1, 0, 0.105943,0.00234528) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53125,0.0170651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376506,-0.00276853) , 
0, 0.440977, 1, 0, 0.470379,-0.0274712) , 
1, 0.645585, 1, 0, 0.259352,-0.0102059)    );
  // itree = 536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277311,0.0305699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252562,-0.00162931) , 
1, -0.368349, 1, 0, 0.258958,0.00988158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258065,-0.0498438) , 
0, 1.3944, 1, 0, 0.258876,0.00195666)    );
  // itree = 537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441368,-0.00511191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221978,-0.00391568) , 
3, -0.373137, 1, 0, 0.347989,0.0107556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106145,-6.54875e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148629,0.016665) , 
0, -0.491352, 1, 0, 0.139908,-0.0237456) , 
1, 0.552807, 1, 0, 0.254508,-0.00474414)    );
  // itree = 538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364119,0.0066734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118065,-0.0154986) , 
3, -0.0347222, 1, 0, 0.258967,-0.00484396) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248408,8.96154e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.0188517) , 
3, 0.513618, 1, 0, 0.220159,-0.0400919) , 
1, 1.35807, 1, 0, 0.251731,-0.0114159)    );
  // itree = 539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0831035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299194,0.0116915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0773097) , 
3, 1.9444, 1, 0, 0.281233,-0.00753668) , 
1, -1.22512, 1, 0, 0.258706,-0.00175165)    );
  // itree = 540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191304,0.0351694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0570292,-0.0267261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373656,0.00116013) , 
3, -0.339199, 1, 0, 0.245989,-0.00651761) , 
0, -1.64945, 1, 0, 0.242821,-0.00356839)    );
  // itree = 541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,-0.0149673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.363636,-0.00336357) , 
0, -1.33943, 1, 0, 0.362173,-0.0114848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0356547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217425,0.00576624) , 
0, -0.732095, 1, 0, 0.207857,0.0196947) , 
3, -0.900958, 1, 0, 0.248287,0.0115259)    );
  // itree = 542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405405,-0.0799921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28113,0.00234717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894309,-0.0108572) , 
3, 1.48456, 1, 0, 0.254989,-0.00372018) , 
2, -1.50013, 1, 0, 0.23873,-0.00796852)    );
  // itree = 543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0307167,-0.023833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286451,-0.00545068) , 
1, -0.774615, 1, 0, 0.241066,0.000354289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419811,0.0442318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366972,0.00893761) , 
3, 1.88014, 1, 0, 0.28972,-0.0524807) , 
3, 1.29216, 1, 0, 0.248986,-0.00824613)    );
  // itree = 544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0357143,-0.0634878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270718,0.0308153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26115,-3.6018e-05) , 
0, -1.16507, 1, 0, 0.262069,0.00424864) , 
2, -1.66646, 1, 0, 0.249374,0.000749103)    );
  // itree = 545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336996,-0.0230748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235495,0.00961685) , 
3, -0.884868, 1, 0, 0.267753,0.0128394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583942,-0.0377913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0150711) , 
2, 1.77955, 1, 0, 0.0826772,-0.0562732) , 
2, 1.42243, 1, 0, 0.243915,0.00393747)    );
  // itree = 546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22069,-0.00485296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234622,-0.00629178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32235,0.0211033) , 
2, 0.588675, 1, 0, 0.267974,-0.0197602) , 
1, -1.19679, 1, 0, 0.264513,-0.0155739)    );
  // itree = 547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236945,0.00226688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282967,0.00145529) , 
2, 1.04095, 1, 0, 0.245781,0.00515174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179487,-0.0361619) , 
0, 1.54393, 1, 0, 0.241927,0.000189956)    );
  // itree = 548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16,0.00545139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0542636,-0.0339328) , 
0, -0.502377, 1, 0, 0.106299,-0.00965764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.450075,0.0308469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409556,-0.011092) , 
2, 1.16198, 1, 0, 0.437759,0.0342613) , 
3, -0.0237104, 1, 0, 0.267677,0.0117251)    );
  // itree = 549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306851,0.00129201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.062645,-0.0324149) , 
3, 0.765832, 1, 0, 0.248475,0.00599814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180233,-0.00309132) , 
0, 1.42175, 1, 0, 0.242532,0.000938615)    );
  // itree = 550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465649,0.00257702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317829,0.00821878) , 
0, -1.2688, 1, 0, 0.392308,-0.0466077) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213713,-0.00682755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371681,0.0352348) , 
2, 1.11962, 1, 0, 0.245029,0.00589957) , 
3, -1.54559, 1, 0, 0.264467,-0.00103033)    );
  // itree = 551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242442,-0.00860044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430233,0.0630608) , 
3, 1.44833, 1, 0, 0.259514,-0.00227622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.07712) , 
3, 2.00929, 1, 0, 0.245132,0.00275414)    );
  // itree = 552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114811,-0.00947501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.02389) , 
3, -0.0719984, 1, 0, 0.26522,0.0124091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154362,-0.0628776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289125,0.00411355) , 
1, -0.0525078, 1, 0, 0.250951,-0.0220232) , 
0, 0.823264, 1, 0, 0.261381,0.00314498)    );
  // itree = 553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413613,-0.0115584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,0.00122167) , 
0, -1.06357, 1, 0, 0.386555,-0.0364297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305927,-0.00635823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157735,0.00836066) , 
1, 0.185608, 1, 0, 0.208995,0.0133345) , 
3, -1.04982, 1, 0, 0.251509,0.00141916)    );
  // itree = 554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358193,0.00699579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0733138,-0.0125109) , 
3, 0.364457, 1, 0, 0.283063,0.0115463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178037,-0.0159645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268293,0.0213816) , 
0, 1.04879, 1, 0, 0.19337,-0.0319521) , 
1, 0.895474, 1, 0, 0.250868,-0.00406741)    );
  // itree = 555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207883,-0.00403648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416667,0.0329327) , 
2, 0.795867, 1, 0, 0.245891,-0.00385499) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.582418,0.0410276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703364,-0.0553974) , 
2, 0.658312, 1, 0, 0.253438,0.0503692) , 
3, 0.948814, 1, 0, 0.247728,0.00934449)    );
  // itree = 556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279817,0.0748135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19802,-0.0107698) , 
0, -0.527912, 1, 0, 0.232246,0.0326122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237842,-0.00662434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299435,-0.0345845) , 
2, 1.61824, 1, 0, 0.245144,-0.0143478) , 
1, -0.369857, 1, 0, 0.241807,-0.00219979)    );
  // itree = 557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432494,-0.00855017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361624,0.000503598) , 
0, -0.0506934, 1, 0, 0.405367,0.019691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.0147224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155955,-0.000777454) , 
0, -0.564812, 1, 0, 0.158055,-0.0292096) , 
1, -0.0304994, 1, 0, 0.244565,-0.012104)    );
  // itree = 558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311909,0.00291306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139059,-0.0283597) , 
1, 1.03062, 1, 0, 0.257272,0.00576375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,-0.032763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202632,0.0170416) , 
1, -0.270867, 1, 0, 0.178423,-0.0225483) , 
0, 0.893748, 1, 0, 0.238541,-0.000961936)    );
  // itree = 559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0672414,-0.011686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126374,-0.0170864) , 
3, -0.298045, 1, 0, 0.0900424,0.025168) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488889,0.0342134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382212,-0.00584537) , 
0, -0.463595, 1, 0, 0.40492,-0.0120243) , 
1, 0.324332, 1, 0, 0.256372,0.0055217)    );
  // itree = 560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125683,-0.00417199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0337268,-0.0488133) , 
1, -0.993154, 1, 0, 0.0554124,-0.0252193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513245,0.0286825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322811,-0.00257543) , 
1, 0.0230727, 1, 0, 0.367601,0.0091898) , 
3, -0.550144, 1, 0, 0.25,-0.00377208)    );
  // itree = 561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445743,-0.00347005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209809,-0.0130096) , 
3, -0.245906, 1, 0, 0.356108,0.0208595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126984,0.000540497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132597,-0.00087967) , 
0, -0.590549, 1, 0, 0.131627,-0.0115946) , 
1, 0.324332, 1, 0, 0.236893,0.00362412)    );
  // itree = 562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226813,-0.0138993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.495349,0.0363733) , 
2, 0.500835, 1, 0, 0.298267,-0.0053058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0791003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143266,0.00418681) , 
2, 0.372936, 1, 0, 0.101215,0.0477746) , 
3, 0.853537, 1, 0, 0.252133,0.00712155)    );
  // itree = 563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0020141,-0.0787591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525661,0.0179428) , 
1, 0.749264, 1, 0, 0.207824,0.00726478) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550388,0.0491425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251462,-0.033109) , 
1, 0.715542, 1, 0, 0.431235,-0.0314618) , 
0, 0.982985, 1, 0, 0.254237,-0.00078059)    );
  // itree = 564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703518,-0.0446222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.013369,-0.0492214) , 
0, -1.09728, 1, 0, 0.0331588,-0.0307948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425926,0.0239288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239356,-0.0160741) , 
1, 0.389102, 1, 0, 0.315106,0.00330235) , 
3, -0.961157, 1, 0, 0.235756,-0.00629376)    );
  // itree = 565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397849,0.00392841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338308,0.00472249) , 
0, -1.23575, 1, 0, 0.349495,-0.0149076) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18287,-0.00420473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134831,0.0128558) , 
1, 0.65155, 1, 0, 0.154502,0.0179455) , 
3, -0.102347, 1, 0, 0.2489,0.00204107)    );
  // itree = 566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33179,0.00244671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0688073,-0.00771665) , 
3, 0.0691717, 1, 0, 0.265589,0.0139808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291566,0.00333739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234663,0.00328805) , 
0, -0.0640622, 1, 0, 0.256795,-0.0189211) , 
1, 0.240541, 1, 0, 0.260735,-0.00418077)    );
  // itree = 567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152091,0.0325955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30805,0.0394751) , 
2, -1.00974, 1, 0, 0.262926,-0.0190792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263682,-0.0210724) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196491,-0.0118085) , 
2, 1.18575, 1, 0, 0.246097,0.0150375) , 
3, -0.305034, 1, 0, 0.253754,-0.000484062)    );
  // itree = 568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167431,0.0117422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12945,-0.0419822) , 
2, 0.0201135, 1, 0, 0.151678,-0.0108514) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529412,-0.0173117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555283,0.0286325) , 
0, 0.0599833, 1, 0, 0.550098,0.0420755) , 
3, 0.853537, 1, 0, 0.253127,0.00262527)    );
  // itree = 569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517647,-0.0119636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29537,-0.00413795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102906,-0.0078711) , 
1, 0.71244, 1, 0, 0.211962,-0.0115185) , 
1, -1.19679, 1, 0, 0.236994,-0.00417817)    );
  // itree = 570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00239466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184282,0.00973147) , 
0, 0.349172, 1, 0, 0.280651,0.0209213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253623,0.01249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197425,-0.00910498) , 
0, 0.136562, 1, 0, 0.223864,-0.0212716) , 
1, 0.583399, 1, 0, 0.254678,0.0016231)    );
  // itree = 571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182309,-0.00232989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341227,0.0038511) , 
0, -0.0107878, 1, 0, 0.261853,-0.00820765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171171,-0.0170627) , 
2, 1.77922, 1, 0, 0.256736,-0.00471924)    );
  // itree = 572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0180913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0310559,-0.0440683) , 
0, -1.15122, 1, 0, 0.0738095,-0.0156733) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343109,0.00357422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.859813,0.0409586) , 
3, 1.89793, 1, 0, 0.392035,0.0138233) , 
3, -0.343942, 1, 0, 0.256345,0.00124606)    );
  // itree = 573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.52381,0.00474146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305804,-0.0116473) , 
3, -2.02958, 1, 0, 0.347197,-0.0242048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0144523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0651466,-0.0391534) , 
2, 1.23836, 1, 0, 0.210781,0.00145082) , 
3, -0.900958, 1, 0, 0.2485,-0.00564297)    );
  // itree = 574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0606061,-0.0753386) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354812,0.00998948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.0132139) , 
3, 0.6034, 1, 0, 0.275783,0.00437095) , 
2, -1.46199, 1, 0, 0.253968,-0.00108897)    );
  // itree = 575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629139,0.0362679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674797,0.0864696) , 
1, 0.11738, 1, 0, 0.24,-0.0285309) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216164,-0.0121851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36,0.0132852) , 
0, 0.689291, 1, 0, 0.269207,0.00741325) , 
3, -1.10169, 1, 0, 0.263158,-3.13288e-05)    );
  // itree = 576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109838,-0.00914409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472628,0.0189171) , 
3, 0.182088, 1, 0, 0.234483,0.00653739) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314815,-0.0399594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.393064,0.0100334) , 
2, 1.59524, 1, 0, 0.349614,-0.0261059) , 
2, 1.0466, 1, 0, 0.257056,0.000137061)    );
  // itree = 577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343066,-0.00570794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188391,0.00479045) , 
3, -0.515454, 1, 0, 0.25195,0.00831883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162921,-0.00219539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138614,-0.0018479) , 
3, 1.59947, 1, 0, 0.154122,-0.047425) , 
0, 1.24882, 1, 0, 0.237924,0.000326777)    );
  // itree = 578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163636,-0.0436885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0194175,-0.0694059) , 
0, -0.532494, 1, 0, 0.0938967,-0.0567655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273107,0.00158878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0340136,-0.0566129) , 
3, 1.79814, 1, 0, 0.253838,-0.0111035) , 
2, -1.43192, 1, 0, 0.237113,-0.0158782)    );
  // itree = 579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0306513,0.0430623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26975,-0.0126437) , 
1, -0.95459, 1, 0, 0.235424,0.00252607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288043,0.105812) , 
3, 1.65933, 1, 0, 0.24026,-0.00477702)    );
  // itree = 580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686695,-0.0147636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400943,0.0249313) , 
3, -1.01876, 1, 0, 0.226966,0.0144722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0406364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252063,-0.00804436) , 
1, -0.101579, 1, 0, 0.247607,-0.0168061) , 
1, -0.512249, 1, 0, 0.243042,-0.00988817)    );
  // itree = 581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504983,0.000292843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31358,0.0047662) , 
3, -1.19804, 1, 0, 0.365437,0.0106958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123153,0.00549461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0818182,-0.0220316) , 
3, 1.84099, 1, 0, 0.118221,-0.0237715) , 
1, 0.583399, 1, 0, 0.25332,-0.00493569)    );
  // itree = 582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.439655,0.00925956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334021,-0.00243411) , 
0, -1.08546, 1, 0, 0.368201,-0.0229778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0655738,-0.044188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189241,-0.00386788) , 
1, -0.339721, 1, 0, 0.170752,0.0231371) , 
3, -0.529222, 1, 0, 0.243689,0.00610241)    );
  // itree = 583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0745501,0.035685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108309,-0.014719) , 
3, -0.996892, 1, 0, 0.0959548,0.0169741) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515464,0.0282702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405844,0.00080862) , 
0, -0.206787, 1, 0, 0.441014,-0.0215347) , 
1, 0.529523, 1, 0, 0.254822,-0.000755589)    );
  // itree = 584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232258,0.0488545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224886,0.00476735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256995,-0.0174033) , 
0, 0.0715274, 1, 0, 0.241716,-0.010028) , 
1, -1.19679, 1, 0, 0.240982,-0.00448027)    );
  // itree = 585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359223,0.00334412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994065,0.00146189) , 
1, 0.863264, 1, 0, 0.262313,-0.00255387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183168,0.00714992) , 
0, 1.3944, 1, 0, 0.254355,-0.00806631)    );
  // itree = 586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.521739,0.0441446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291925,-0.0183691) , 
3, -1.96922, 1, 0, 0.387681,-0.0405472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208589,-0.0350079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231395,0.000239004) , 
0, -0.941517, 1, 0, 0.229285,0.0124361) , 
3, -1.52056, 1, 0, 0.250736,0.0052607)    );
  // itree = 587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108538,-0.0228267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37797,0.0194777) , 
0, -0.197188, 1, 0, 0.216638,-0.00719903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260504,-0.00683751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291005,-0.0020188) , 
0, 1.30332, 1, 0, 0.266888,0.035065) , 
3, 0.0619493, 1, 0, 0.238697,0.0113544)    );
  // itree = 588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319066,0.0185087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257373,-0.0181479) , 
0, 0.505827, 1, 0, 0.298951,0.00857387) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124756,-0.0436445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284507,0.013002) , 
0, 0.460404, 1, 0, 0.190092,-0.0227966) , 
1, 0.634693, 1, 0, 0.251988,-0.00495971)    );
  // itree = 589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478469,0.00685483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297297,-0.00945022) , 
3, -1.68166, 1, 0, 0.344569,-0.0211069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202639,0.0129178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103774,-0.00275075) , 
3, 1.84948, 1, 0, 0.193659,0.00522268) , 
3, -0.435343, 1, 0, 0.255081,-0.0054938)    );
  // itree = 590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355757,-0.00394913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277354,0.00228373) , 
0, 0.00456447, 1, 0, 0.329331,-0.014318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109405,-0.0165775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171875,0.00437335) , 
1, 1.23234, 1, 0, 0.133175,0.0134349) , 
3, 0.108015, 1, 0, 0.247135,-0.00268859)    );
  // itree = 591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0170616,-0.0639719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571192,0.0235806) , 
1, 0.939437, 1, 0, 0.218807,0.00682615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595041,0.0483735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356725,0.0139707) , 
1, 0.2216, 1, 0, 0.455479,-0.0372247) , 
0, 1.17201, 1, 0, 0.254229,0.000233196)    );
  // itree = 592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274691,0.019361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23427,-0.00369519) , 
1, -0.747966, 1, 0, 0.241474,0.00113028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.0288928) , 
2, 1.7672, 1, 0, 0.250257,-0.00283372)    );
  // itree = 593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416532,-0.000480798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243446,-5.62215e-06) , 
3, -0.596089, 1, 0, 0.318759,0.0190959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0864198,-0.00318911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172269,0.0630343) , 
3, 0.827626, 1, 0, 0.122776,-0.0336714) , 
1, 1.07236, 1, 0, 0.263131,0.00411849)    );
  // itree = 594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258211,-0.000528461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279279,0.032618) , 
1, 1.59889, 1, 0, 0.259457,-0.00395946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201613,0.0196259) , 
0, 1.52075, 1, 0, 0.255872,-0.0107379)    );
  // itree = 595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32659,0.0624968) , 
3, -2.08271, 1, 0, 0.248899,-0.0220014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37247,0.0242686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207018,-0.0143361) , 
2, -0.169712, 1, 0, 0.257038,0.00415387) , 
3, -1.04982, 1, 0, 0.255268,-0.00153314)    );
  // itree = 596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271008,0.0351286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16408,-0.0161436) , 
1, 0.0388392, 1, 0, 0.218986,0.0156283) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126344,-0.0378616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565359,0.00608276) , 
3, 1.09821, 1, 0, 0.254286,-0.0227962) , 
0, -0.0702116, 1, 0, 0.237734,-0.00477925)    );
  // itree = 597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0311501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282548,-0.0196695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21262,0.00114822) , 
3, -1.03164, 1, 0, 0.226498,-0.00133205) , 
2, -1.47259, 1, 0, 0.252364,-0.00679621)    );
  // itree = 598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423453,0.011049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169091,-0.0176707) , 
3, -1.12864, 1, 0, 0.26021,0.0152342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.00709463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253648,0.00963572) , 
0, -0.590549, 1, 0, 0.261074,-0.0176738) , 
1, 0.227361, 1, 0, 0.260688,-0.00296988)    );
  // itree = 599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.080315,-0.00639907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132075,-0.000885961) , 
3, -0.298045, 1, 0, 0.102518,0.0188461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527835,0.0116956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360577,-0.00448) , 
0, 0.370438, 1, 0, 0.45061,-0.0250374) , 
1, 0.568008, 1, 0, 0.258321,-0.00079571)    );
  // itree = 600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00701754,-0.0707803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.03125,-0.0264027) , 
3, -1.5266, 1, 0, 0.0145278,-0.0362275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528846,0.0494889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301639,0.00391856) , 
1, -0.960884, 1, 0, 0.316145,0.0121662) , 
3, -1.16568, 1, 0, 0.255142,0.00237847)    );
  // itree = 601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524164,0.0115583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267742,-0.0117356) , 
2, -0.994889, 1, 0, 0.345332,-0.0136372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686275,-0.0503178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17623,0.000334138) , 
2, -0.847876, 1, 0, 0.166048,0.0245679) , 
3, -0.280496, 1, 0, 0.247077,0.00730085)    );
  // itree = 602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217573,-0.0233893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473451,0.0198133) , 
2, -1.00915, 1, 0, 0.384949,-0.0292172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206157,-0.00527917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179412,0.0101062) , 
0, 1.06082, 1, 0, 0.199717,-0.000696862) , 
3, -0.691091, 1, 0, 0.26058,-0.010068)    );
  // itree = 603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318386,0.0502134) , 
3, -1.99637, 1, 0, 0.251773,-0.0263352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118129,-0.0272525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43686,-0.00239493) , 
1, 0.943919, 1, 0, 0.247745,0.0123814) , 
3, -0.871513, 1, 0, 0.248878,0.00149058)    );
  // itree = 604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0994152,-0.0117567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463077,0.0172818) , 
3, -0.223671, 1, 0, 0.256478,0.00770236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199005,-0.0427966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365854,0.0253114) , 
1, 1.16856, 1, 0, 0.238095,-0.0343194) , 
0, 0.759972, 1, 0, 0.251724,-0.00316533)    );
  // itree = 605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347245,0.0144141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0872818,-0.0384992) , 
2, 0.66231, 1, 0, 0.282051,-0.00925999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0263158,-0.0457184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892857,-0.0295364) , 
0, 0.784455, 1, 0, 0.0680473,0.0750804) , 
3, 1.29216, 1, 0, 0.244708,0.00545713)    );
  // itree = 606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353048,0.00721788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112211,-0.0138786) , 
3, 0.293753, 1, 0, 0.267449,-0.00464837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,-0.00183334) , 
0, 1.42175, 1, 0, 0.259893,-0.00847456)    );
  // itree = 607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153226,0.0228341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234188,0.00229291) , 
2, -1.00072, 1, 0, 0.210084,-0.0167245) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321429,-0.00208091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239636,-0.0157739) , 
0, -0.406633, 1, 0, 0.251513,0.022272) , 
3, -0.435343, 1, 0, 0.234171,0.00594835)    );
  // itree = 608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038674,-0.0469274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00699301,-0.0497843) , 
0, -0.292981, 1, 0, 0.029703,-0.0303439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364179,0.0240008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297528,-0.00687373) , 
0, -0.395089, 1, 0, 0.312334,0.000462053) , 
3, -0.961157, 1, 0, 0.241431,-0.00726622)    );
  // itree = 609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578431,0.0364745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271375,-0.00376187) , 
2, -0.904746, 1, 0, 0.355795,-0.0131559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108491,-0.0303493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170068,0.0141816) , 
2, -0.0826182, 1, 0, 0.156283,0.0199441) , 
3, 0.105894, 1, 0, 0.264078,0.00206045)    );
  // itree = 610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13245,-0.0386296) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256814,-0.0064153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0658683,-0.0200618) , 
3, 1.71142, 1, 0, 0.239274,-0.0119627) , 
1, -1.17379, 1, 0, 0.231082,-0.00725856)    );
  // itree = 611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189003,0.0350903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237576,-0.0001831) , 
2, -0.960694, 1, 0, 0.22491,-0.00848211) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26603,-0.0137429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313253,0.0257592) , 
0, 1.39163, 1, 0, 0.27475,0.0198215) , 
3, 0.105894, 1, 0, 0.247146,0.00414567)    );
  // itree = 612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123928,-0.00423727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510101,0.0267093) , 
3, 0.267206, 1, 0, 0.263542,0.0161219) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0519481,-0.0706903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644444,0.000394449) , 
3, 1.37713, 1, 0, 0.32872,-0.0349629) , 
2, 1.32298, 1, 0, 0.273292,0.00848033)    );
  // itree = 613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621849,0.00196765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301517,0.00176104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123741,-0.00273377) , 
3, 0.422986, 1, 0, 0.23348,-0.00830843) , 
1, -1.36088, 1, 0, 0.257364,-0.00504908)    );
  // itree = 614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.408889,0.00567067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323823,0.00397581) , 
0, -1.15122, 1, 0, 0.344492,-0.0178108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139332,-0.0176104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20765,0.0307118) , 
0, 0.887319, 1, 0, 0.163033,0.0194831) , 
3, -0.245873, 1, 0, 0.247855,0.00205041)    );
  // itree = 615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130584,0.00572983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110448,-0.0227385) , 
2, -0.16405, 1, 0, 0.119808,0.0159978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.81571,0.0489896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320442,0.000527109) , 
2, 0.610377, 1, 0, 0.556999,-0.0225616) , 
1, 0.939437, 1, 0, 0.275578,0.00225915)    );
  // itree = 616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231299,0.0140969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145863,-0.0247351) , 
0, 0.0992237, 1, 0, 0.196067,-0.000507133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482456,-0.00986048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.744444,0.0447313) , 
2, 0.939742, 1, 0, 0.642857,0.0579493) , 
3, 1.29216, 1, 0, 0.260999,0.00798827)    );
  // itree = 617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29104,0.00128557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,-0.0184917) , 
2, 1.29581, 1, 0, 0.266667,-0.00237349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547945,-0.0420331) , 
3, 1.74551, 1, 0, 0.251361,0.00283579)    );
  // itree = 618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215956,-0.0171544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255794,0.00124422) , 
1, -0.0220085, 1, 0, 0.240486,0.00671026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303571,0.0710956) , 
0, 1.54569, 1, 0, 0.244012,0.00182021)    );
  // itree = 619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894309,-0.0196467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725632,0.0207341) , 
1, 0.77313, 1, 0, 0.244288,0.0133515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289157,0.00182712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115942,-0.00724141) , 
3, 1.26109, 1, 0, 0.233372,-0.0253527) , 
2, 0.332, 1, 0, 0.239599,-0.00327482)    );
  // itree = 620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219697,0.0458304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229063,-0.00779177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0326519) , 
0, 1.52075, 1, 0, 0.235417,-0.0130493) , 
1, -1.36088, 1, 0, 0.234405,-0.00850945)    );
  // itree = 621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679245,0.0233133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227349,-0.00522214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.0875552) , 
1, 1.66065, 1, 0, 0.227775,-0.0120068) , 
1, -1.39679, 1, 0, 0.251619,-0.00980914)    );
  // itree = 622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267684,-0.00221701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217759,0.00950069) , 
0, 0.713975, 1, 0, 0.255352,-0.00701629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.088,-0.0247154) , 
3, 1.96727, 1, 0, 0.245098,-0.000746935)    );
  // itree = 623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.01,-0.0111926) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130154,-0.0135591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546003,0.0198917) , 
1, 0.991036, 1, 0, 0.275263,-0.0118527) , 
1, -1.40498, 1, 0, 0.262,-0.00766874)    );
  // itree = 624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0173913,-0.0587559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216771,-0.000206012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825397,0.0302635) , 
3, 1.87081, 1, 0, 0.257584,0.00411427) , 
3, -2.04064, 1, 0, 0.243731,0.00121413)    );
  // itree = 625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458065,-0.0244038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326667,-0.0123022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160031,0.00118672) , 
1, 0.00656281, 1, 0, 0.213184,0.00905381) , 
3, -1.82503, 1, 0, 0.231827,0.0056603)    );
  // itree = 626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236916,-0.00270254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446809,0.0186036) , 
2, 1.60682, 1, 0, 0.252346,-0.00177209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761905,-0.0255979) , 
3, 1.90896, 1, 0, 0.243203,0.00290134)    );
  // itree = 627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207466,-0.0133292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385246,0.0168568) , 
3, 0.752219, 1, 0, 0.244457,0.0110144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460784,0.0662558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265896,0.0352087) , 
2, 1.66064, 1, 0, 0.338182,-0.0456075) , 
2, 1.42243, 1, 0, 0.257129,0.00335904)    );
  // itree = 628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289673,0.0180044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146453,-0.0228689) , 
1, 0.757817, 1, 0, 0.23883,0.00657104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125806,-0.0342521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764706,0.0307887) , 
3, 1.67954, 1, 0, 0.252264,-0.0183291) , 
0, 0.474519, 1, 0, 0.244012,-0.00303366)    );
  // itree = 629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467066,-0.0109854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245402,0.00559885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0961538,-0.0109651) , 
3, 1.9197, 1, 0, 0.236985,0.0112697) , 
3, -1.82503, 1, 0, 0.256092,0.00662096)    );
  // itree = 630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353982,0.00415273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860077,-0.027672) , 
3, -0.181887, 1, 0, 0.229947,0.0110007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418182,0.0069765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292763,0.0215424) , 
0, 0.127706, 1, 0, 0.326087,-0.0421198) , 
2, 1.06564, 1, 0, 0.248927,0.000513428)    );
  // itree = 631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361582,0.085191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261062,0.011675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207326,-0.0128044) , 
2, -0.446078, 1, 0, 0.220693,0.0067338) , 
2, -1.47397, 1, 0, 0.2332,0.00238704)    );
  // itree = 632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.074,-0.0179527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42556,0.0181839) , 
3, -0.767167, 1, 0, 0.285941,0.0133167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934959,-0.00931215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477124,-0.0239193) , 
3, 1.3907, 1, 0, 0.184496,-0.0201176) , 
1, 0.939437, 1, 0, 0.251576,0.00199051)    );
  // itree = 633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432432,-0.00217707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218818,-0.00591921) , 
3, -0.204472, 1, 0, 0.345503,0.0080701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114983,0.0172925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131673,0.00441713) , 
0, -0.19926, 1, 0, 0.126031,-0.0159465) , 
1, 0.634378, 1, 0, 0.251014,-0.00226971)    );
  // itree = 634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376884,0.0084301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477477,0.018134) , 
1, -0.106805, 1, 0, 0.412903,-0.0322049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238245,-0.0103624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188251,-0.00048477) , 
0, 0.461212, 1, 0, 0.216295,-0.00433266) , 
0, -0.940853, 1, 0, 0.246528,-0.00861858)    );
  // itree = 635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209302,-0.0156176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.656716,0.0685927) , 
3, 1.11321, 1, 0, 0.25017,0.00636376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321508,0.0166428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0336134,-0.0315619) , 
3, 1.67099, 1, 0, 0.261404,-0.0257905) , 
2, 0.708843, 1, 0, 0.253314,-0.00263376)    );
  // itree = 636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263636,0.0836893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.064982,-0.0199472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418018,0.0127927) , 
3, -0.205876, 1, 0, 0.266873,0.00645754) , 
0, -1.58783, 1, 0, 0.266699,0.0112737)    );
  // itree = 637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359281,-0.0193681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335211,-0.0013877) , 
0, -1.30387, 1, 0, 0.339795,-0.0195093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15522,-0.00602758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219251,0.0141344) , 
0, 0.934794, 1, 0, 0.176951,0.0145365) , 
3, -0.27663, 1, 0, 0.249116,-0.000550991)    );
  // itree = 638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223553,-0.00615456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331797,0.0201077) , 
2, 0.920326, 1, 0, 0.237209,-0.00581054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325758,-0.00481761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,0.0225217) , 
1, 1.38528, 1, 0, 0.337302,-0.054767) , 
2, 1.40023, 1, 0, 0.25,-0.0120666)    );
  // itree = 639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00283554,-0.0783288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582143,0.0145805) , 
1, 0.943531, 1, 0, 0.203337,0.0107291) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.54902,0.0518731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330435,0.00941743) , 
1, 0.230954, 1, 0, 0.417755,-0.0445608) , 
0, 1.00007, 1, 0, 0.244378,0.000146347)    );
  // itree = 640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0810373,-0.0136348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314225,0.0163648) , 
3, -0.359068, 1, 0, 0.181985,0.00408768) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154622,-0.033111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.683721,0.014033) , 
3, 1.48484, 1, 0, 0.295062,-0.0195776) , 
2, 0.332, 1, 0, 0.230242,-0.00601185)    );
  // itree = 641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426357,0.0198952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306389,-0.014352) , 
0, -1.53075, 1, 0, 0.323661,-0.00506228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215124,0.00894361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0876133,-0.0183507) , 
2, 1.10887, 1, 0, 0.176685,0.025786) , 
3, -0.227317, 1, 0, 0.242728,0.0119244)    );
  // itree = 642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491525,0.0219334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29912,0.0053324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0941884,-0.0162408) , 
3, 0.8149, 1, 0, 0.24423,0.00193887) , 
3, -1.92288, 1, 0, 0.25896,-0.00158825)    );
  // itree = 643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152559,-0.0203532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310044,0.00914367) , 
3, 0.253475, 1, 0, 0.201493,0.00114826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481752,0.033608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385638,0.00258046) , 
1, -0.089683, 1, 0, 0.411306,-0.0231303) , 
0, 0.823264, 1, 0, 0.255662,-0.00511994)    );
  // itree = 644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00787402,-0.0704244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220273,0.0109501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304864,-0.0100907) , 
2, 0.349098, 1, 0, 0.258427,0.000562912) , 
3, -1.95723, 1, 0, 0.242485,-0.00283767)    );
  // itree = 645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27933,-0.00119907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0252101,-0.0628975) , 
3, 1.63849, 1, 0, 0.26185,0.00790135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458716,-0.0236882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202703,0.0522467) , 
0, 0.2287, 1, 0, 0.136187,-0.0652158) , 
1, 1.47236, 1, 0, 0.245596,-0.00155568)    );
  // itree = 646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273052,-0.00429923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0528455,-0.03403) , 
3, 1.15853, 1, 0, 0.24494,-0.0121622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28,0.0418093) , 
1, 1.58039, 1, 0, 0.247472,-0.00704783)    );
  // itree = 647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135593,0.0280493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279126,0.0443141) , 
2, -1.00072, 1, 0, 0.226852,-0.0210722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246243,-0.00787484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273438,-0.0157503) , 
0, 0.689291, 1, 0, 0.256354,0.0113731) , 
3, -0.729479, 1, 0, 0.246914,0.000990613)    );
  // itree = 648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211193,0.0112073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648649,-0.0494765) , 
0, 0.0801461, 1, 0, 0.157124,-0.006318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291429,-0.012456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632768,0.0326962) , 
2, 0.431507, 1, 0, 0.519849,0.0419212) , 
3, 0.752409, 1, 0, 0.2516,0.00624652)    );
  // itree = 649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320479,-0.0052691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28266,0.00245331) , 
0, -0.264766, 1, 0, 0.300502,-0.0115446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0518519,-0.0311986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0906593,-0.0158588) , 
2, 0.352213, 1, 0, 0.0801603,0.0372178) , 
3, 0.867657, 1, 0, 0.247969,8.10428e-05)    );
  // itree = 650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205029,-0.0297983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0130719,-0.0800761) , 
1, 0.595531, 1, 0, 0.161194,0.0176404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357143,0.0373369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295474,0.0119238) , 
1, -0.537111, 1, 0, 0.30206,-0.0131189) , 
2, -0.361538, 1, 0, 0.254417,-0.00271574)    );
  // itree = 651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204731,-0.00839707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371429,0.0188039) , 
2, 0.772043, 1, 0, 0.235724,-0.00935376) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606965,0.0476474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116216,-0.0312511) , 
2, 0.626657, 1, 0, 0.288967,0.0264535) , 
3, 0.832675, 1, 0, 0.250361,0.000490232)    );
  // itree = 652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132075,-0.000364919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.616901,0.0396431) , 
3, -0.10288, 1, 0, 0.296935,0.0236978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139503,-0.0049866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538889,-0.027659) , 
3, 1.54181, 1, 0, 0.219027,-0.0172122) , 
1, 0.480056, 1, 0, 0.26078,0.00471288)    );
  // itree = 653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327737,0.00514383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115163,-0.0118605) , 
2, 0.64668, 1, 0, 0.26917,0.00318449) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.00120659) , 
3, 1.62302, 1, 0, 0.254466,-0.00270409)    );
  // itree = 654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222715,-0.00774599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428058,0.0299586) , 
2, 0.375794, 1, 0, 0.290553,-0.0136165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.083501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0383514) , 
2, 0.901323, 1, 0, 0.0466667,0.0195227) , 
3, 1.30934, 1, 0, 0.253656,-0.00860303)    );
  // itree = 655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0131579,-0.00492138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559006,0.0654663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242891,-0.00521112) , 
2, -1.28254, 1, 0, 0.270416,-0.00611879) , 
1, -1.19679, 1, 0, 0.250875,-0.00212692)    );
  // itree = 656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133531,0.0275676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127805,-0.0237297) , 
2, -0.813142, 1, 0, 0.129222,-0.0108824) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553659,0.0319623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409266,-0.0102002) , 
0, 1.03211, 1, 0, 0.497758,0.0313141) , 
3, 0.490789, 1, 0, 0.250615,0.00301685)    );
  // itree = 657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356632,0.00570008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.077821,-0.0102473) , 
1, 0.990428, 1, 0, 0.275804,-0.00425771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283019,-0.0591369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0518519,-0.0390626) , 
1, 1.28138, 1, 0, 0.0414938,0.0302622) , 
2, 1.41921, 1, 0, 0.247766,-0.000126973)    );
  // itree = 658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4375,0.0155366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227094,-0.00715094) , 
3, -2.02208, 1, 0, 0.239556,0.009048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424779,0.0835896) , 
1, 1.65151, 1, 0, 0.25,0.00503363)    );
  // itree = 659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170732,0.0106253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315485,0.00250227) , 
3, -1.00395, 1, 0, 0.258319,0.0134577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276423,0.00307897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,-0.0100657) , 
2, 0.50125, 1, 0, 0.223572,-0.0151717) , 
2, 0.329467, 1, 0, 0.243766,0.00146683)    );
  // itree = 660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281475,0.00619111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123324,-0.0312421) , 
1, 1.2364, 1, 0, 0.241751,-0.00131406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.017094,-0.104169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258454,-0.0148711) , 
2, -0.256864, 1, 0, 0.205273,-0.031553) , 
0, 0.823646, 1, 0, 0.232143,-0.00927878)    );
  // itree = 661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490566,-0.0101515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236577,-0.0101585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214651,0.00178469) , 
0, -0.291291, 1, 0, 0.222034,0.0108231) , 
3, -1.82503, 1, 0, 0.244168,0.00646331)    );
  // itree = 662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305537,0.00446575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0528634,-0.0325673) , 
3, 0.765832, 1, 0, 0.245696,-0.00918814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425,0.0457961) , 
2, 1.77922, 1, 0, 0.256259,-0.0120922)    );
  // itree = 663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0557029,0.00202129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111332,-0.00989131) , 
3, -0.79515, 1, 0, 0.0875,0.0225218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479688,0.00560943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232432,-0.0106167) , 
2, 0.601911, 1, 0, 0.364854,-0.007902) , 
1, 0.185608, 1, 0, 0.247229,0.00500064)    );
  // itree = 664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0808101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0752841,-0.0146778) , 
3, -2.1346, 1, 0, 0.0653514,-0.0174919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39501,0.0176925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37788,-0.0274756) , 
2, 1.43622, 1, 0, 0.391858,0.0152527) , 
3, -0.462334, 1, 0, 0.258794,0.00190807)    );
  // itree = 665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333619,0.000866382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152062,0.00789493) , 
3, 0.191205, 1, 0, 0.261071,-0.00528742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12931,0.0184666) , 
2, 1.7672, 1, 0, 0.253644,-0.00903809)    );
  // itree = 666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427184,0.0162367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327869,-0.0234483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21911,-0.00919542) , 
0, -1.23266, 1, 0, 0.225939,0.00556464) , 
3, -2.18002, 1, 0, 0.23607,0.0020864)    );
  // itree = 667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206504,-0.0210415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367521,0.0190659) , 
2, 0.683145, 1, 0, 0.242252,-0.00921828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.690789,0.0676948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782918,-0.0353174) , 
2, 0.626657, 1, 0, 0.293303,0.0279945) , 
3, 1.00687, 1, 0, 0.253227,-0.00121773)    );
  // itree = 668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0544662,-0.03954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0217391,-0.000667354) , 
0, -0.282189, 1, 0, 0.0435414,-0.0211679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0530973,-0.0542701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38582,0.0171299) , 
2, -0.94265, 1, 0, 0.357466,0.0211602) , 
3, -0.657499, 1, 0, 0.250124,0.00668674)    );
  // itree = 669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.496296,0.00304532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281837,-0.00976787) , 
2, -1.00138, 1, 0, 0.359146,-0.0140085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159734,0.0124977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236246,0.0129116) , 
0, 0.320733, 1, 0, 0.198523,0.014457) , 
3, -0.502231, 1, 0, 0.259654,0.00362337)    );
  // itree = 670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294737,0.00723753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146552,-0.0103669) , 
0, -0.221527, 1, 0, 0.238562,0.0367697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321162,0.00437308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102506,-0.0126944) , 
3, 0.883159, 1, 0, 0.262774,-0.0093935) , 
1, -0.796791, 1, 0, 0.258974,-0.00214943)    );
  // itree = 671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.085914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275568,-0.00372364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0676692,0.00065001) , 
3, 1.80344, 1, 0, 0.260961,-0.0158782) , 
1, -1.34521, 1, 0, 0.246261,-0.0113512)    );
  // itree = 672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131352,-0.00216461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451673,0.0198698) , 
3, 0.182088, 1, 0, 0.240354,0.0105515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0628629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37751,-0.0139626) , 
0, 0.34163, 1, 0, 0.322917,-0.0413906) , 
2, 1.04395, 1, 0, 0.256489,0.000400964)    );
  // itree = 673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369119,0.0108859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271071,-0.00884378) , 
0, 0.0357757, 1, 0, 0.335173,-0.00934779) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0133812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182796,0.0152598) , 
0, 1.00944, 1, 0, 0.122363,0.0262762) , 
3, 0.414913, 1, 0, 0.258717,0.00345093)    );
  // itree = 674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211326,-0.0204698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478343,0.0300377) , 
2, -0.0547713, 1, 0, 0.324303,-0.00064632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0192308,-0.0644574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224832,0.0117572) , 
2, 0.897169, 1, 0, 0.111782,0.0307685) , 
3, 0.414913, 1, 0, 0.250913,0.0102022)    );
  // itree = 675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153565,-0.00160439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34236,0.00648063) , 
3, -0.681687, 1, 0, 0.245301,0.0133613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317293,0.0109266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153061,-0.0119159) , 
3, 0.937544, 1, 0, 0.256386,-0.0120051) , 
2, 0.138482, 1, 0, 0.250825,0.000719952)    );
  // itree = 676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17801,0.00388864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726744,-0.0539735) , 
2, 0.639185, 1, 0, 0.153691,-0.00682971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269565,-0.013775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.694006,0.0403369) , 
2, 0.358792, 1, 0, 0.581019,0.0612604) , 
3, 0.832675, 1, 0, 0.24974,0.00847462)    );
  // itree = 677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.435897,0.0097593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199501,-0.00292309) , 
3, -0.265468, 1, 0, 0.35289,0.00484994) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147564,-0.00696598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112745,0.00214653) , 
3, 1.5651, 1, 0, 0.13969,-0.0232192) , 
2, 0.333423, 1, 0, 0.258806,-0.00753675)    );
  // itree = 678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141593,-0.0327041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255215,0.00672822) , 
1, -1.37869, 1, 0, 0.247849,0.0107806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275591,-0.0083884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41,0.0282707) , 
1, 1.40652, 1, 0, 0.334802,-0.0329014) , 
2, 1.42243, 1, 0, 0.257868,0.00574723)    );
  // itree = 679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165274,-0.0184866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.427711,0.00881835) , 
0, 0.372902, 1, 0, 0.248254,0.00238143) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,-0.0365754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203209,0.0295327) , 
3, 1.60323, 1, 0, 0.207358,0.0528766) , 
3, 1.30934, 1, 0, 0.241729,0.010438)    );
  // itree = 680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.008,-0.0758006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274531,0.00945308) , 
2, -1.59844, 1, 0, 0.257349,0.00802687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321429,-0.04507) , 
0, 1.52075, 1, 0, 0.260848,0.0033289)    );
  // itree = 681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418764,0.0120294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0997625,0.0260568) , 
1, 0.943531, 1, 0, 0.315058,0.00221876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309278,-0.012219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148536,-0.00104859) , 
1, 0.0201337, 1, 0, 0.19494,-0.0352153) , 
0, 0.518813, 1, 0, 0.274021,-0.0105701)    );
  // itree = 682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429224,0.00890744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228,-0.0226872) , 
3, -1.32286, 1, 0, 0.321962,0.0303088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329513,0.007739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141827,-0.00128748) , 
3, 0.151821, 1, 0, 0.227451,-0.00546532) , 
0, -0.684728, 1, 0, 0.249625,0.0029279)    );
  // itree = 683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0806987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.027027,-0.0538714) , 
3, -1.55591, 1, 0, 0.0116279,0.0398765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325953,0.0142775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677966,-0.094632) , 
1, 1.63248, 1, 0, 0.308486,-0.00580655) , 
0, -1.04167, 1, 0, 0.27023,8.06808e-05)    );
  // itree = 684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299184,0.0143984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127139,-0.0253095) , 
1, 1.16835, 1, 0, 0.252645,0.00678128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162264,-0.0129288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343891,-0.0422514) , 
2, 0.882692, 1, 0, 0.244856,-0.0397755) , 
0, 0.893748, 1, 0, 0.250751,-0.00454335)    );
  // itree = 685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.00285441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0878187,0.0097862) , 
1, 0.866069, 1, 0, 0.281221,0.0116218) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282748,0.0106193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141618,0.0233954) , 
3, 1.08333, 1, 0, 0.23251,-0.0255568) , 
0, 0.19327, 1, 0, 0.258159,-0.00598058)    );
  // itree = 686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130769,-0.0326907) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331624,-0.00927419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210654,-0.00239762) , 
0, -0.361587, 1, 0, 0.249452,-0.00495267) , 
1, -1.36088, 1, 0, 0.241556,0.00188794)    );
  // itree = 687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229,0.000833486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267409,0.00239374) , 
2, 0.188465, 1, 0, 0.245052,-0.00811175) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603448,0.07485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056701,-0.0413951) , 
2, 0.885767, 1, 0, 0.26129,0.0411112) , 
3, 1.34716, 1, 0, 0.247535,-0.000587531)    );
  // itree = 688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227848,0.0256923) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224178,-0.00576813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442478,0.0357017) , 
2, 1.78038, 1, 0, 0.237755,-0.00237847) , 
1, -1.22512, 1, 0, 0.236962,0.000379328)    );
  // itree = 689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334873,0.00483774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15493,0.00739532) , 
3, 0.421906, 1, 0, 0.296252,0.00705289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776256,-0.0171025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104348,-0.00106863) , 
3, 1.87575, 1, 0, 0.0868263,-0.0437932) , 
3, 1.13793, 1, 0, 0.261066,-0.00148966)    );
  // itree = 690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300926,0.00704893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162393,0.00396032) , 
0, -0.275009, 1, 0, 0.252252,-0.0446654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387209,0.00939463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148402,0.000481168) , 
3, 0.134448, 1, 0, 0.266705,-0.00418239) , 
1, -0.750175, 1, 0, 0.264379,-0.010698)    );
  // itree = 691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0830635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.0450211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262618,-0.00620136) , 
3, -0.614474, 1, 0, 0.269995,0.00365416) , 
1, -1.3293, 1, 0, 0.252891,0.00995651)    );
  // itree = 692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236994,0.0456408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0986046,-0.0224004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439086,0.00724561) , 
3, 0.284239, 1, 0, 0.242619,-0.00503612) , 
1, -1.15014, 1, 0, 0.242141,5.20246e-05)    );
  // itree = 693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407246,-0.00121099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,0.00770448) , 
3, -0.354416, 1, 0, 0.335069,0.0234932) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109649,-0.0205145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14876,0.0173556) , 
1, 1.59164, 1, 0, 0.115528,-0.0182465) , 
2, 0.352049, 1, 0, 0.244762,0.00632383)    );
  // itree = 694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212285,-0.0137061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40894,0.0213683) , 
2, 0.351394, 1, 0, 0.281707,-0.0106808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0230124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0576923,-0.0407178) , 
3, 1.9019, 1, 0, 0.0692308,0.0500942) , 
3, 1.30934, 1, 0, 0.253678,-0.00266378)    );
  // itree = 695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0103627,-0.0550827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293238,0.00209692) , 
1, -1.0397, 1, 0, 0.259074,-0.000565425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365957,0.0291749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0763808) , 
3, 1.97732, 1, 0, 0.259036,0.0408628) , 
3, 1.22488, 1, 0, 0.259067,0.00656109)    );
  // itree = 696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0798226,-0.0150402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407631,0.0148665) , 
3, -0.29722, 1, 0, 0.251844,0.00790317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305556,-0.033077) , 
0, 1.54569, 1, 0, 0.254736,0.00416113)    );
  // itree = 697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.528409,0.0176734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269585,0.000427389) , 
3, -0.992937, 1, 0, 0.385496,0.0202671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20788,-0.00549485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131846,0.00504681) , 
3, 0.633339, 1, 0, 0.17738,-0.00952523) , 
2, -0.210175, 1, 0, 0.258561,0.00209599)    );
  // itree = 698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414545,0.0191967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249352,8.77094e-05) , 
3, -1.51227, 1, 0, 0.274327,0.0143238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162437,-0.00908744) , 
0, 1.3861, 1, 0, 0.263393,0.00881467)    );
  // itree = 699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0263158,-0.0189216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0965517,-0.017925) , 
3, -0.833228, 1, 0, 0.0585443,0.0157353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347678,0.00662134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287169,0.00542054) , 
3, 0.748409, 1, 0, 0.326055,-0.0156127) , 
1, -0.128677, 1, 0, 0.241775,-0.00573634)    );
  // itree = 700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0803678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0477137,-0.022756) , 
3, -1.96816, 1, 0, 0.0387722,-0.0217692) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376033,0.017319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297059,-0.00860245) , 
0, 0.389104, 1, 0, 0.337838,0.00743904) , 
3, -0.789658, 1, 0, 0.24642,-0.00148931)    );
  // itree = 701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268128,1.71385e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1875,0.007609) , 
0, 1.44542, 1, 0, 0.262716,-0.0129314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133858,0.00537447) , 
1, 1.65151, 1, 0, 0.254671,-0.00654014)    );
  // itree = 702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371025,0.0100956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0611702,-0.0342598) , 
3, 0.178242, 1, 0, 0.275918,0.00523484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157895,-0.00170444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278638,-0.00983511) , 
2, 0.8853, 1, 0, 0.209211,-0.018861) , 
1, 0.818867, 1, 0, 0.250378,-0.00399077)    );
  // itree = 703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220423,0.0216624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238671,-0.0203688) , 
3, -0.431883, 1, 0, 0.230512,-0.00110247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410526,0.0289391) , 
0, 1.34228, 1, 0, 0.247734,-0.00676925)    );
  // itree = 704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123367,-0.00983045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0168539,-0.0700457) , 
0, -0.201758, 1, 0, 0.0870813,-0.0186857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59322,0.0369593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367868,0.00144706) , 
0, 0.143757, 1, 0, 0.437045,0.0222466) , 
3, -0.0237104, 1, 0, 0.254736,0.000923455)    );
  // itree = 705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400955,-0.0157605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294707,0.0152275) , 
3, -0.996438, 1, 0, 0.334526,0.0139062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151713,-0.0085651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107407,0.00565012) , 
1, 1.28597, 1, 0, 0.138165,-0.0134957) , 
2, 0.324939, 1, 0, 0.247876,0.00181433)    );
  // itree = 706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24679,-0.00228689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373563,0.0501762) , 
2, 0.409177, 1, 0, 0.272,0.01095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0557621,-0.0490163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340244,0.0181363) , 
2, -0.22899, 1, 0, 0.269972,-0.0206417) , 
1, 0.196866, 1, 0, 0.270876,-0.00656698)    );
  // itree = 707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279365,0.0112642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252792,0.0141785) , 
2, 0.0196437, 1, 0, 0.265803,0.000421619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0185185,-0.104944) , 
1, 1.68097, 1, 0, 0.252699,0.00441005)    );
  // itree = 708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217742,0.0496448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.00496761) , 
0, -1.46616, 1, 0, 0.173196,0.0025337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111481,-0.0439845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.570605,-0.00295678) , 
3, 0.876563, 1, 0, 0.279536,-0.027966) , 
2, 0.182843, 1, 0, 0.225756,-0.0125412)    );
  // itree = 709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34026,0.000651324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133748,-0.00567308) , 
2, 0.40882, 1, 0, 0.266407,-0.0019807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.079096,-0.0223594) , 
3, 1.61709, 1, 0, 0.24962,0.00376982)    );
  // itree = 710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170611,-0.0242467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351351,0.0428441) , 
2, 0.171646, 1, 0, 0.193632,0.00220908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414763,0.0211845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0804598,-0.0256208) , 
3, 1.17305, 1, 0, 0.309639,-0.0218655) , 
2, 0.361887, 1, 0, 0.241968,-0.00782198)    );
  // itree = 711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155127,-0.0157615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418692,0.00432698) , 
0, 0.378298, 1, 0, 0.23926,0.00305083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382653,0.032931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0530303,-0.0317861) , 
2, 1.36547, 1, 0, 0.25,0.0770969) , 
3, 1.29216, 1, 0, 0.241018,0.0151701)    );
  // itree = 712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218769,0.00630977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0988372,-0.0589743) , 
2, 1.34665, 1, 0, 0.207187,0.00162299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475806,-0.0516068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.77451,0.00862805) , 
3, 2.00995, 1, 0, 0.610619,-0.0542938) , 
3, 1.63045, 1, 0, 0.252616,-0.00467357)    );
  // itree = 713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405705,-0.00318878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249689,0.0109219) , 
3, -0.525959, 1, 0, 0.318245,-0.000748326) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969529,0.0307898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133858,0.00822762) , 
0, 0.41996, 1, 0, 0.112195,-0.028482) , 
1, 1.09547, 1, 0, 0.25646,-0.00906438)    );
  // itree = 714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20122,0.000940234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269364,0.00245746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0534351,-0.0433788) , 
3, 1.8644, 1, 0, 0.254164,-0.0070933) , 
1, -1.18793, 1, 0, 0.249877,-0.00100603)    );
  // itree = 715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189873,-0.00471711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764706,0.0582336) , 
0, 0.804496, 1, 0, 0.279389,0.0109938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212996,-0.0163516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231589,0.00293304) , 
2, 0.016529, 1, 0, 0.227655,-0.0205227) , 
2, -0.396143, 1, 0, 0.244908,-0.0100118)    );
  // itree = 716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0361991,-0.0293455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0674847,-0.0589359) , 
3, -1.08869, 1, 0, 0.0446281,-0.0279176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462687,0.0484963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306883,-0.000325313) , 
1, -0.469325, 1, 0, 0.328691,0.0115525) , 
3, -0.814403, 1, 0, 0.244488,-0.000147393)    );
  // itree = 717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.389414,-0.0134088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,0.0161548) , 
1, 0.150194, 1, 0, 0.273081,0.028214) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283048,0.00492954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108359,-0.00205742) , 
3, 1.10011, 1, 0, 0.224638,-0.0117648) , 
0, 0.0941268, 1, 0, 0.249624,0.00885581)    );
  // itree = 718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179487,-0.00651325) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392971,0.0100115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190213,-0.00469656) , 
3, -0.541352, 1, 0, 0.257264,0.000342573) , 
1, -1.36088, 1, 0, 0.252736,0.00455255)    );
  // itree = 719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233704,0.0311512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258364,-0.0159758) , 
3, -0.708419, 1, 0, 0.249267,0.0084875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336283,0.0354716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281481,0.03745) , 
0, 0.907512, 1, 0, 0.306452,-0.0551772) , 
2, 1.42243, 1, 0, 0.256528,0.00040309)    );
  // itree = 720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0336538,-0.0247912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21021,0.027452) , 
3, -1.26221, 1, 0, 0.142329,0.0145755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306641,-0.0250138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258415,-0.00181311) , 
1, 0.224744, 1, 0, 0.275645,-0.0140471) , 
2, -0.546626, 1, 0, 0.239108,-0.0062027)    );
  // itree = 721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410256,-0.00390607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289529,0.000264471) , 
0, -1.41761, 1, 0, 0.301457,0.0039418) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0590062,-0.0420501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108844,-0.0012147) , 
3, 1.59927, 1, 0, 0.0746269,-0.027394) , 
2, 0.935005, 1, 0, 0.249512,-0.00323422)    );
  // itree = 722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219486,-0.00893547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401639,0.0239263) , 
2, 0.338122, 1, 0, 0.281997,0.0147748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,-0.00490672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226378,0.0188167) , 
1, -0.386809, 1, 0, 0.205457,-0.0299235) , 
0, 0.676581, 1, 0, 0.25868,0.00115767)    );
  // itree = 723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0706714,-0.0344629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282609,0.0640898) , 
2, 0.605787, 1, 0, 0.100304,0.0205345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,0.0298362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417455,0.00361258) , 
1, 0.491358, 1, 0, 0.391182,-0.01697) , 
1, 0.324332, 1, 0, 0.251339,0.00106067)    );
  // itree = 724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234536,0.0119144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0567164,-0.0379105) , 
1, 0.684977, 1, 0, 0.180918,0.0017259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285988,-0.0304969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316614,-0.000215956) , 
2, 1.17794, 1, 0, 0.297619,-0.0259996) , 
2, 0.322406, 1, 0, 0.231164,-0.0102113)    );
  // itree = 725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545455,-0.0136001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239005,0.00342734) , 
1, -1.26922, 1, 0, 0.262426,-0.0078899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0490196,-0.0407045) , 
2, 1.60695, 1, 0, 0.241446,-0.00436858)    );
  // itree = 726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,0.0111644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144552,-0.0258597) , 
3, -1.60413, 1, 0, 0.185185,0.00892279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36,0.0212631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354396,0.0196526) , 
2, 0.497821, 1, 0, 0.355217,-0.014554) , 
2, 0.324939, 1, 0, 0.2572,-0.00102046)    );
  // itree = 727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164384,-0.0111274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431718,0.0151011) , 
0, 0.403838, 1, 0, 0.259105,0.00461755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219101,0.0897757) , 
3, 1.69653, 1, 0, 0.255714,-0.00115794)    );
  // itree = 728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230083,0.00186524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104918,-0.0296374) , 
0, 1.04141, 1, 0, 0.209712,-0.00297605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.825243,0.0254943) , 
3, 1.95893, 1, 0, 0.24178,-5.41269e-05)    );
  // itree = 729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432526,-0.0108639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362998,-0.00499348) , 
0, -0.557972, 1, 0, 0.391061,0.0280302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172379,0.00389348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0785124,-0.0227215) , 
3, 1.41316, 1, 0, 0.153971,-0.00080582) , 
1, -0.0220085, 1, 0, 0.241026,0.00978216)    );
  // itree = 730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533981,0.0484643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225166,-0.0105267) , 
3, -2.19858, 1, 0, 0.241775,0.00262897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424242,0.034083) , 
2, 1.76296, 1, 0, 0.253542,-0.00267227)    );
  // itree = 731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242003,-0.000757226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0291386) , 
2, 0.876198, 1, 0, 0.2362,-0.000104874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.0432118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308824,0.0165952) , 
1, 1.19107, 1, 0, 0.289062,-0.0257493) , 
2, 1.09499, 1, 0, 0.246653,-0.00517565)    );
  // itree = 732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197345,-0.00697837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.637427,0.0170515) , 
3, 1.51791, 1, 0, 0.238512,-0.00372139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390476,-0.0265352) , 
0, 1.54569, 1, 0, 0.246767,-0.00620089)    );
  // itree = 733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371753,0.000780959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222405,0.00779632) , 
3, -0.814015, 1, 0, 0.272678,-0.0038677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0239085) , 
3, 1.64517, 1, 0, 0.254086,0.00134974)    );
  // itree = 734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273026,-0.000135495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0601504,0.0100084) , 
3, 1.48092, 1, 0, 0.255898,-0.00441157) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204545,-0.0231884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101695,-0.0219036) , 
3, 1.39819, 1, 0, 0.172775,0.030441) , 
1, 1.29989, 1, 0, 0.240295,0.00213078)    );
  // itree = 735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231602,0.0171802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273218,-0.00539937) , 
3, -0.221857, 1, 0, 0.252432,0.00727723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0406504,-0.102129) , 
1, 1.65151, 1, 0, 0.23923,0.00398721)    );
  // itree = 736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281955,0.0335082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170058,-0.0139495) , 
0, -1.01584, 1, 0, 0.188185,-0.00493067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495726,-0.0143315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.62963,0.0348404) , 
0, 0.749509, 1, 0, 0.582583,0.0391748) , 
3, 1.30934, 1, 0, 0.254684,0.00250585)    );
  // itree = 737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381074,0.0012649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679612,-0.0265204) , 
3, -0.0728399, 1, 0, 0.292392,0.00971476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240268,0.00665982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0751445,-0.0260522) , 
3, 1.54861, 1, 0, 0.20915,-0.0192229) , 
0, 0.130486, 1, 0, 0.254355,-0.00350814)    );
  // itree = 738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156716,-0.0326437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.404138,0.0109637) , 
2, -0.927039, 1, 0, 0.337362,-0.0135974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.077037,-0.0265524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281588,0.00375738) , 
2, 1.12108, 1, 0, 0.136555,0.0144164) , 
3, -0.0186245, 1, 0, 0.239075,0.000114271)    );
  // itree = 739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0789729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265876,0.00474051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283099,0.00187033) , 
3, 0.435533, 1, 0, 0.272343,-0.00478593) , 
0, -1.60655, 1, 0, 0.2575,-0.00169519)    );
  // itree = 740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158675,-0.0132999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.577844,0.016373) , 
3, 0.580855, 1, 0, 0.253207,-0.00375319) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0052356,-0.0423323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233533,-0.0412491) , 
3, 0.14224, 1, 0, 0.150476,-0.0500524) , 
1, 1.16801, 1, 0, 0.226321,-0.0158704)    );
  // itree = 741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270983,-0.00803819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0809524,-0.00699278) , 
2, 1.24906, 1, 0, 0.249734,0.00402147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10687,0.00581286) , 
2, 1.76296, 1, 0, 0.240418,-0.000972258)    );
  // itree = 742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356139,0.00849401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179278,0.00805914) , 
3, 0.0172453, 1, 0, 0.277259,0.00590019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184874,0.0307586) , 
0, 1.49754, 1, 0, 0.271883,0.00220503)    );
  // itree = 743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101942,0.0366347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356589,0.015599) , 
3, -1.62706, 1, 0, 0.283934,0.030026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252818,0.0144628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176724,-0.0180722) , 
3, 0.202791, 1, 0, 0.212604,-0.00250394) , 
2, -0.361538, 1, 0, 0.237862,0.00901474)    );
  // itree = 744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143845,-0.00570864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.443503,0.0209235) , 
3, 0.790316, 1, 0, 0.202778,0.00375933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624204,-0.0341018) , 
3, 1.73078, 1, 0, 0.236587,-0.00247392)    );
  // itree = 745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557143,-0.00698405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241563,0.00773599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234783,0.029508) , 
0, 1.52725, 1, 0, 0.241131,-0.00842307) , 
1, -1.22512, 1, 0, 0.263889,-0.00222465)    );
  // itree = 746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284558,0.00344647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0242915,-0.0497507) , 
3, 1.20855, 1, 0, 0.249865,0.00107981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330827,-0.00423212) , 
2, 1.6784, 1, 0, 0.255287,-0.00248594)    );
  // itree = 747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135429,-0.0289294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350877,0.00271482) , 
0, -0.111652, 1, 0, 0.237245,-0.00309885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477876,0.0545232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,-0.0302082) , 
0, 0.210851, 1, 0, 0.259259,0.0311137) , 
3, 0.951289, 1, 0, 0.242,0.00429107)    );
  // itree = 748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155172,0.023305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0928482,-0.0273948) , 
2, -0.582417, 1, 0, 0.115781,-0.00460013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509934,0.0202946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433526,-0.0127691) , 
2, 1.43778, 1, 0, 0.492922,0.0241387) , 
3, 0.356731, 1, 0, 0.259568,0.00635673)    );
  // itree = 749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308176,-0.0342206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281205,0.00443963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219124,0.0137194) , 
0, 0.854008, 1, 0, 0.264768,-0.000696246) , 
0, -1.50708, 1, 0, 0.268127,0.00531769)    );
  // itree = 750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,-0.0142451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289799,-0.00160205) , 
1, -1.35371, 1, 0, 0.280057,0.017595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149701,0.018726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204211,-0.000763034) , 
1, -0.089683, 1, 0, 0.190031,-0.0355738) , 
0, 0.646842, 1, 0, 0.251946,0.000992642)    );
  // itree = 751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134752,-0.00158786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23968,0.00882188) , 
2, -0.897218, 1, 0, 0.211036,-0.0159975) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271186,0.00405541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27897,-0.0109069) , 
0, 0.697294, 1, 0, 0.274824,0.0139511) , 
3, -0.0237104, 1, 0, 0.242365,-0.00128876)    );
  // itree = 752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143548,-0.00377078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0425139,-0.0532486) , 
0, -0.313714, 1, 0, 0.0964686,-0.0186028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463087,0.0135495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34127,-0.0237856) , 
0, 1.45787, 1, 0, 0.445465,0.0142447) , 
3, 0.21524, 1, 0, 0.246063,-0.00452301)    );
  // itree = 753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429907,0.00731783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243832,-0.00726054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0227338) , 
0, 1.43387, 1, 0, 0.241235,-0.00507229) , 
0, -1.70616, 1, 0, 0.251239,-0.000801086)    );
  // itree = 754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385066,0.00601868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122449,-0.0340051) , 
3, -0.413963, 1, 0, 0.275362,0.0105804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12069,-0.0154766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218346,0.0070418) , 
1, -0.486534, 1, 0, 0.205618,-0.0257633) , 
0, 0.201876, 1, 0, 0.245274,-0.00509866)    );
  // itree = 755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969977,-0.0335995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296296,0.0563468) , 
2, 1.32842, 1, 0, 0.112296,0.0209507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.652381,0.0211851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245399,-0.00293082) , 
2, 1.42545, 1, 0, 0.538593,-0.0183513) , 
1, 1.09547, 1, 0, 0.237186,0.00943655)    );
  // itree = 756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18932,0.015625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828516,-0.0413492) , 
2, 0.0727464, 1, 0, 0.148176,-0.00205174) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387097,-0.00695302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.594086,0.032067) , 
2, 0.610377, 1, 0, 0.51129,0.0318729) , 
3, 0.575226, 1, 0, 0.262863,0.00866312)    );
  // itree = 757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351542,-0.000510725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116139,0.0137825) , 
1, 0.835395, 1, 0, 0.264739,-0.00655978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0684932,-0.0302426) , 
3, 1.74551, 1, 0, 0.25,-0.0017617)    );
  // itree = 758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.0112165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0543478,-0.0293014) , 
3, 0.164912, 1, 0, 0.235182,0.0107759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265931,0.00561168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0930233,-0.0114476) , 
3, 1.5258, 1, 0, 0.23583,-0.0139139) , 
1, 0.453936, 1, 0, 0.235497,-0.001217)    );
  // itree = 759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307087,0.0879884) , 
0, -1.30387, 1, 0, 0.154762,-0.0349246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16129,-0.000666952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267987,-0.00658995) , 
0, -0.720403, 1, 0, 0.252978,0.0102792) , 
3, -1.56069, 1, 0, 0.240695,0.00462592)    );
  // itree = 760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0195531,-0.0469848) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218412,0.00859622) , 
3, -1.26572, 1, 0, 0.16985,0.00125803) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377841,-0.0251755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814433,0.0164248) , 
3, 1.90691, 1, 0, 0.47216,-0.0303021) , 
3, 0.920143, 1, 0, 0.240731,-0.0061417)    );
  // itree = 761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.523404,0.00581597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248239,-0.0195235) , 
2, -0.979329, 1, 0, 0.328767,-0.0178286) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245312,0.00185866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113821,0.0056187) , 
1, 0.936658, 1, 0, 0.188163,0.0152194) , 
3, -0.462334, 1, 0, 0.246512,0.00150489)    );
  // itree = 762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326165,-0.000675332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00932253) , 
2, -0.217362, 1, 0, 0.377834,-0.0179761) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197699,-0.0129593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241333,0.00613718) , 
1, 0.742097, 1, 0, 0.216882,0.0139303) , 
3, -1.22885, 1, 0, 0.247266,0.00790706)    );
  // itree = 763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,0.0357856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.811765,0.0502386) , 
1, -0.0571465, 1, 0, 0.357759,0.0206328) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275815,0.0135043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21256,-0.010327) , 
3, 0.04266, 1, 0, 0.242327,-0.0044431) , 
2, -0.744396, 1, 0, 0.268738,0.00129418)    );
  // itree = 764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241611,0.0572104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338235,-0.0454053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353175,0.0053895) , 
3, -0.506803, 1, 0, 0.241237,-0.00396958) , 
1, -1.19679, 1, 0, 0.241264,0.00110604)    );
  // itree = 765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398827,-0.0177907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214564,0.00100154) , 
3, -1.15048, 1, 0, 0.271171,0.0231274) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259259,0.00371675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111475,-0.00165357) , 
3, 1.09821, 1, 0, 0.204156,-0.0117756) , 
0, 0.29569, 1, 0, 0.242739,0.008319)    );
  // itree = 766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.537037,0.048887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233241,-0.00562239) , 
3, -2.11636, 1, 0, 0.250392,-0.000315417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0135374) , 
0, 1.55414, 1, 0, 0.248161,-0.00584994)    );
  // itree = 767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828402,-0.0151202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371348,0.00829389) , 
1, -0.102501, 1, 0, 0.259067,-0.00309508) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288462,0.024038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0765702) , 
3, 2.01585, 1, 0, 0.146341,0.0906151) , 
3, 1.61709, 1, 0, 0.247168,0.00679709)    );
  // itree = 768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0751174,-0.0106647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377358,0.00827514) , 
3, -0.439427, 1, 0, 0.24631,0.00402406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361905,-0.0372047) , 
0, 1.55414, 1, 0, 0.252174,0.000510432)    );
  // itree = 769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360223,-0.00337287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184823,0.0100548) , 
3, -0.449598, 1, 0, 0.266927,0.00942589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213178,-0.00151687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147059,0.00793673) , 
1, 0.763029, 1, 0, 0.183983,-0.0333899) , 
0, 0.823646, 1, 0, 0.247748,-0.00047446)    );
  // itree = 770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403548,0.0174321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216276,6.77329e-05) , 
3, -1.02394, 1, 0, 0.26281,-0.00676898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233871,0.0230717) , 
0, 1.52075, 1, 0, 0.260959,-0.00974595)    );
  // itree = 771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225422,-0.00402459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249668,-0.00848711) , 
2, 0.19482, 1, 0, 0.235795,-0.0102855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314961,-0.0105532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184211,0.0343919) , 
3, 1.65312, 1, 0, 0.236593,0.0302378) , 
3, 1.3043, 1, 0, 0.235917,-0.00410068)    );
  // itree = 772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244417,0.0176284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.053125,-0.0303406) , 
1, 0.77313, 1, 0, 0.190053,0.00977685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203252,-0.0590463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344648,-0.00324498) , 
2, 0.50343, 1, 0, 0.325084,-0.015444) , 
2, 0.332, 1, 0, 0.249628,-0.00135038)    );
  // itree = 773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394737,-0.0017316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199203,-0.00435635) , 
3, -0.956973, 1, 0, 0.263685,0.0124013) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174479,-0.0175815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195946,0.0533963) , 
3, 1.59928, 1, 0, 0.180451,-0.0403366) , 
0, 0.813325, 1, 0, 0.241872,-0.0014197)    );
  // itree = 774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19352,-0.0117549) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360996,0.00841707) , 
2, 0.33764, 1, 0, 0.258445,-0.0071279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0592105,-0.0341358) , 
3, 1.75738, 1, 0, 0.243431,-0.00268013)    );
  // itree = 775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0827201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297921,0.00441239) , 
0, -1.41761, 1, 0, 0.272727,-0.00521488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,-0.00723064) , 
2, 1.7595, 1, 0, 0.267884,-0.0022539)    );
  // itree = 776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186287,0.0121228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16726,-0.0263508) , 
2, -0.119811, 1, 0, 0.176361,-0.0071682) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.558333,-0.00765385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59204,0.0256595) , 
0, 0.779485, 1, 0, 0.579439,0.0288812) , 
3, 1.19852, 1, 0, 0.24316,-0.00119409)    );
  // itree = 777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508969,0.00401049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32,0.00610235) , 
3, -0.663668, 1, 0, 0.425879,0.00789318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173585,0.0267564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148707,0.00358107) , 
0, -0.562809, 1, 0, 0.154233,-0.0102955) , 
1, 0.0664722, 1, 0, 0.262946,-0.00301636)    );
  // itree = 778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256579,0.010935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352459,0.0370011) , 
2, -0.836736, 1, 0, 0.29927,-0.0316173) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303272,0.00126827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0762712,-0.0250328) , 
3, 0.957916, 1, 0, 0.241159,0.0146634) , 
1, -0.840753, 1, 0, 0.249125,0.00831981)    );
  // itree = 779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14542,-0.0175737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284507,0.00251164) , 
3, 0.299345, 1, 0, 0.180339,0.0172697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411429,0.0354223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359833,0.00502126) , 
1, -0.089683, 1, 0, 0.37366,-0.0279034) , 
0, 0.596152, 1, 0, 0.241413,0.00299874)    );
  // itree = 780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00980392,-0.0613022) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241519,0.0149085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317117,-0.0151416) , 
2, 0.798259, 1, 0, 0.264919,0.00567296) , 
3, -1.69011, 1, 0, 0.238858,0.00183592)    );
  // itree = 781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340517,0.00828007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317365,0.0167128) , 
0, -0.313714, 1, 0, 0.32789,-0.00231255) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104046,-0.00022937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955414,-0.0107654) , 
2, 0.642966, 1, 0, 0.0985626,0.0257558) , 
3, 0.832675, 1, 0, 0.272547,0.00446112)    );
  // itree = 782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285254,-0.00210535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220155,0.00304017) , 
0, 0.403838, 1, 0, 0.26299,0.00824154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0192308,-0.0690738) , 
3, 1.74551, 1, 0, 0.244368,0.0128167)    );
  // itree = 783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621118,0.0736287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0390625,-0.0100383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279551,-0.00530736) , 
1, -0.996791, 1, 0, 0.262637,0.00559208) , 
3, -1.82503, 1, 0, 0.24634,0.00196981)    );
  // itree = 784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202114,-0.00179505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103448,-0.0470342) , 
2, 1.34665, 1, 0, 0.191055,-0.00619609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.700565,0.0234884) , 
3, 1.63045, 1, 0, 0.236419,-0.00105906)    );
  // itree = 785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274184,-0.00198514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.03042) , 
1, 1.52775, 1, 0, 0.265809,0.00464965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122951,0.00468122) , 
2, 1.77922, 1, 0, 0.257042,9.51422e-05)    );
  // itree = 786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250149,-0.00754516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0406504,-0.0217855) , 
3, 1.65076, 1, 0, 0.23588,0.0023442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315,0.0306877) , 
1, 1.5317, 1, 0, 0.243769,0.0063441)    );
  // itree = 787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0863287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115764,-0.00436776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409901,0.012368) , 
1, 0.269773, 1, 0, 0.278814,-0.00669954) , 
0, -1.34233, 1, 0, 0.255791,-0.000472331)    );
  // itree = 788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0741379,-0.00340175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330404,0.0301551) , 
3, -0.663939, 1, 0, 0.201044,0.0198905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178423,-0.0330643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752747,0.0199491) , 
3, 1.57124, 1, 0, 0.293923,-0.0201401) , 
2, 0.329467, 1, 0, 0.241967,0.00225289)    );
  // itree = 789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287751,-0.00354368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0434783,-0.0311785) , 
3, 1.10265, 1, 0, 0.253341,0.0095395) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145299,-0.0234684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151515,-0.00193157) , 
3, 0.785477, 1, 0, 0.148936,-0.0405422) , 
0, 1.23273, 1, 0, 0.239172,0.00274304)    );
  // itree = 790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20362,-0.0182523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508982,0.0262474) , 
2, -1.00915, 1, 0, 0.387387,-0.0130375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,-0.0156883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233002,0.000667032) , 
1, -0.469325, 1, 0, 0.21659,0.01757) , 
3, -0.940747, 1, 0, 0.262295,0.00937949)    );
  // itree = 791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138012,-0.0162513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385762,0.0149139) , 
0, 0.0181242, 1, 0, 0.240576,-0.0117337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155378,-0.0228682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379562,-0.00788652) , 
1, 1.03334, 1, 0, 0.272381,0.0237242) , 
3, 0.766583, 1, 0, 0.248992,-0.00235094)    );
  // itree = 792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0318302,-0.0270846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341723,0.0179893) , 
3, -1.14729, 1, 0, 0.258865,0.0142119) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17,-0.0739423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259414,-0.0132292) , 
1, -0.286534, 1, 0, 0.243945,-0.0314507) , 
0, 0.676581, 1, 0, 0.254527,0.000935771)    );
  // itree = 793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47191,-0.0106522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244591,-0.00115094) , 
3, -1.77846, 1, 0, 0.277196,0.0205353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384146,0.00409371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136228,-0.0224529) , 
1, -0.290095, 1, 0, 0.185096,-0.00403635) , 
0, 0.310699, 1, 0, 0.240232,0.0106735)    );
  // itree = 794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306776,-0.00314236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0466321,-0.0378971) , 
3, 0.57483, 1, 0, 0.228408,0.0109513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419847,0.0432581) , 
2, 1.7595, 1, 0, 0.240623,0.00547059)    );
  // itree = 795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0765597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264637,0.0399972) , 
0, -1.54124, 1, 0, 0.20696,-0.0208823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237931,-0.0102337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251779,-0.00753285) , 
0, -0.395089, 1, 0, 0.248939,0.017583) , 
3, -0.900958, 1, 0, 0.237245,0.00686767)    );
  // itree = 796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253968,0.0663548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271991,0.00219497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,-0.0176887) , 
1, 0.389371, 1, 0, 0.237714,-0.00924094) , 
0, -1.61795, 1, 0, 0.238739,-0.0038651)    );
  // itree = 797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383033,0.00742103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173962,0.000381024) , 
3, -0.439427, 1, 0, 0.27142,0.00404284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194595,0.00770842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146465,-0.00928276) , 
0, 1.39574, 1, 0, 0.169713,-0.0297235) , 
0, 1.04529, 1, 0, 0.252437,-0.00225955)    );
  // itree = 798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371134,0.000934183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122892,-0.036361) , 
3, -0.413963, 1, 0, 0.276965,0.0267133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250765,0.0107251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996564,-0.0163481) , 
3, 1.08333, 1, 0, 0.204233,-0.00904234) , 
0, 0.130486, 1, 0, 0.243256,0.0101419)    );
  // itree = 799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00699301,-0.027893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0819209,0.0056134) , 
3, -1.6889, 1, 0, 0.0603622,0.0187525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141026,0.0268716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342709,0.00234234) , 
0, -0.920459, 1, 0, 0.321831,-0.00540572) , 
1, -0.450788, 1, 0, 0.256986,0.000585624)    );
  // itree = 800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0542636,-0.0142796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371369,0.02223) , 
3, -0.993233, 1, 0, 0.23015,0.0147212) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105053,-0.0348286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.573171,0.0167625) , 
3, 0.968069, 1, 0, 0.247222,-0.00993588) , 
0, -0.0702116, 1, 0, 0.23961,0.00105795)    );
  // itree = 801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337838,-0.00732777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334741,0.00101472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162891,0.00590731) , 
3, 0.00785522, 1, 0, 0.249733,-0.00770356) , 
0, -1.41761, 1, 0, 0.256182,-0.00415931)    );
  // itree = 802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.359316,0.00384785) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940439,-0.00111626) , 
3, -0.298045, 1, 0, 0.259172,0.0118658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27438,-0.0025357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212766,0.00273164) , 
0, 0.392209, 1, 0, 0.245989,-0.0163419) , 
1, 0.222196, 1, 0, 0.251652,-0.00422416)    );
  // itree = 803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133697,-0.0102085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287879,0.010601) , 
3, -0.262066, 1, 0, 0.193305,0.0162649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.376106,0.0033006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152047,0.01899) , 
3, 1.64518, 1, 0, 0.330978,-0.0199342) , 
0, 0.310699, 1, 0, 0.250489,0.00122917)    );
  // itree = 804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270154,0.00155011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150376,-0.0190282) , 
1, 0.840541, 1, 0, 0.226652,-0.00526196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.0324382) , 
0, 1.52075, 1, 0, 0.233693,-0.00824381)    );
  // itree = 805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511494,0.0333574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258009,-0.00049156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20202,-0.00541403) , 
0, 0.530412, 1, 0, 0.237013,-0.00126389) , 
2, -1.47397, 1, 0, 0.260633,-0.00520789)    );
  // itree = 806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183333,-0.0294586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0591398,-0.0448096) , 
1, 0.0925251, 1, 0, 0.145215,0.0260318) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317181,0.0351603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279788,0.00199159) , 
1, -0.310935, 1, 0, 0.286029,-0.0116922) , 
2, -0.514094, 1, 0, 0.242625,-6.41297e-05)    );
  // itree = 807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0757256) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340741,0.0146211) , 
3, -1.96741, 1, 0, 0.281776,0.0198438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146341,0.0662186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240476,-0.00242567) , 
0, -0.892205, 1, 0, 0.232104,-0.0117956) , 
2, -0.396143, 1, 0, 0.248035,-0.00164796)    );
  // itree = 808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257669,0.0416773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168959,-0.0109655) , 
0, -1.35745, 1, 0, 0.177515,-0.00454523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526316,0.0469673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650718,0.00386533) , 
3, 1.63797, 1, 0, 0.598338,0.0488287) , 
3, 1.19852, 1, 0, 0.251585,0.00484921)    );
  // itree = 809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396947,-0.00444814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334566,-0.0154385) , 
0, -1.52658, 1, 0, 0.346726,-0.0116773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140845,-0.0164914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195975,-0.00204238) , 
0, -0.483299, 1, 0, 0.187316,0.0190194) , 
3, -0.718083, 1, 0, 0.240138,0.00884773)    );
  // itree = 810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.487395,0.0252252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236842,-0.00199084) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249379,0.00425718) , 
1, 0.0668206, 1, 0, 0.244844,0.000126391) , 
3, -1.94621, 1, 0, 0.259204,-0.00259528)    );
  // itree = 811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0782888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377551,0.00969195) , 
1, 0.158753, 1, 0, 0.201871,0.0126515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419593,0.0161002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257862,0.0180584) , 
2, 1.41194, 1, 0, 0.382857,-0.0225553) , 
0, 0.50039, 1, 0, 0.265759,0.000223487)    );
  // itree = 812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255937,0.0346011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00923969) , 
0, -0.280691, 1, 0, 0.263752,0.0158716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180361,-0.0297656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288828,0.00226666) , 
0, -0.0144796, 1, 0, 0.244931,-0.0114127) , 
1, -0.0304994, 1, 0, 0.251802,-0.00145153)    );
  // itree = 813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289474,0.0015779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.0236249) , 
2, 1.12444, 1, 0, 0.255556,-0.00813884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103774,0.000211589) , 
3, 1.9923, 1, 0, 0.247495,-0.00454744)    );
  // itree = 814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346584,-0.00289764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110895,-0.0131069) , 
3, -0.0546649, 1, 0, 0.254738,0.0100801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204545,-0.0105953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195255,8.81215e-07) , 
0, -0.528422, 1, 0, 0.197059,-0.0160545) , 
1, 0.939437, 1, 0, 0.235118,0.0011899)    );
  // itree = 815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178295,0.0114458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281775,-0.0148668) , 
3, -0.839511, 1, 0, 0.242222,0.010067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296935,0.00686562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0600873) , 
3, 1.85283, 1, 0, 0.246057,-0.0161869) , 
2, 0.684444, 1, 0, 0.243448,0.00167743)    );
  // itree = 816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172494,0.00469955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336364,0.0505571) , 
2, -0.0543397, 1, 0, 0.205937,0.016848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146552,-0.058777) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3375,-0.00870088) , 
2, 0.493633, 1, 0, 0.311005,-0.0194908) , 
2, 0.322406, 1, 0, 0.251829,0.000975862)    );
  // itree = 817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399177,0.00648497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1247,-0.00522539) , 
3, -0.234193, 1, 0, 0.299302,0.0119908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273084,0.0101534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996785,-0.014143) , 
3, 0.967264, 1, 0, 0.207317,-0.0192299) , 
0, 0.349172, 1, 0, 0.260936,-0.00103105)    );
  // itree = 818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283567,-0.0110762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234604,0.00238605) , 
0, 0.0942167, 1, 0, 0.26369,-0.000247983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186916,0.00431311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109705,0.0036712) , 
3, 1.58485, 1, 0, 0.133721,-0.0581864) , 
3, 1.29216, 1, 0, 0.241601,-0.0100952)    );
  // itree = 819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253235,-0.00244552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284211,0.00210366) , 
2, 0.338122, 1, 0, 0.265026,-0.00196289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431373,0.0825995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.07,0.0277618) , 
2, 1.24042, 1, 0, 0.252475,-0.0655055) , 
3, 1.61709, 1, 0, 0.263725,-0.00854863)    );
  // itree = 820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131868,0.0295642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917197,-0.0265249) , 
2, -1.00266, 1, 0, 0.102079,-0.00834732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.611607,0.038957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367347,0.00245914) , 
1, 0.119953, 1, 0, 0.4244,0.0190486) , 
3, -0.0186245, 1, 0, 0.25533,0.0046783)    );
  // itree = 821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288119,-0.0100734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.00105008) , 
0, 0.085052, 1, 0, 0.257568,0.00510193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146853,0.0436065) , 
3, 1.76021, 1, 0, 0.249753,-0.000662435)    );
  // itree = 822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373272,0.00176439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36715,0.00829039) , 
3, -1.70193, 1, 0, 0.370283,-0.0159276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160291,-0.00920215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270195,0.0113792) , 
1, 0.101952, 1, 0, 0.233087,0.00967219) , 
3, -1.17385, 1, 0, 0.261463,0.00437741)    );
  // itree = 823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.073718,-0.0243957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.582796,0.0074642) , 
1, 0.546985, 1, 0, 0.242684,0.00331707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204188,0.0163193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265487,-0.00221407) , 
1, 0.504623, 1, 0, 0.247278,-0.0200554) , 
2, 0.688035, 1, 0, 0.244129,-0.00403544)    );
  // itree = 824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258929,0.0347193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178547,-0.00672839) , 
0, -1.1404, 1, 0, 0.189335,0.000100145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617391,0.0317179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556604,-0.0105137) , 
2, 1.48349, 1, 0, 0.598214,0.0370654) , 
3, 1.22488, 1, 0, 0.257855,0.00629481)    );
  // itree = 825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531915,0.00611066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231125,-0.00728335) , 
1, -0.408826, 1, 0, 0.341463,-0.0188176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10241,-0.00743422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210117,0.00765849) , 
0, 0.589006, 1, 0, 0.157115,0.0145932) , 
3, -0.0237104, 1, 0, 0.249877,-0.00221878)    );
  // itree = 826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345291,-0.00615808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219121,-0.00405269) , 
3, -1.0619, 1, 0, 0.249069,0.00294679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281818,0.0508955) , 
0, 1.55414, 1, 0, 0.25088,-0.000905994)    );
  // itree = 827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00192308,-0.0679809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491935,0.0439042) , 
0, 0.799897, 1, 0, 0.0962733,-0.0134915) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0255025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.551261,0.0172672) , 
1, 1.14185, 1, 0, 0.334556,0.0092198) , 
1, -0.181481, 1, 0, 0.258097,0.00193226)    );
  // itree = 828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.054007,-0.0333251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381295,0.0204497) , 
3, -0.663687, 1, 0, 0.247869,0.00806767) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229974,-0.04441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300469,0.0223532) , 
1, 0.878909, 1, 0, 0.255,-0.0262934) , 
0, 0.646842, 1, 0, 0.25,-0.00219958)    );
  // itree = 829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382386,0.00347371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122112,-0.00824657) , 
3, -0.0719984, 1, 0, 0.277445,0.00609142) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.0008622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178191,0.0129732) , 
1, -0.289683, 1, 0, 0.203782,-0.0378791) , 
0, 0.823264, 1, 0, 0.259727,-0.0044846)    );
  // itree = 830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312992,0.0158936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3725,0.00991101) , 
1, -0.159794, 1, 0, 0.349388,-0.00725686) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0665399,-0.0279938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,0.00453231) , 
1, 1.51324, 1, 0, 0.101208,0.0398338) , 
3, 0.575226, 1, 0, 0.26599,0.0085675)    );
  // itree = 831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144628,0.023479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241563,0.0212188) , 
2, -0.979329, 1, 0, 0.212422,-0.0191908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227129,-0.0129821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296236,-0.00229927) , 
0, 0.583198, 1, 0, 0.261044,0.0177163) , 
3, -0.462334, 1, 0, 0.241951,0.00322352)    );
  // itree = 832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290503,0.0269729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243082,-0.00936785) , 
0, -1.24826, 1, 0, 0.248681,-0.00560137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0838323,0.00748535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592593,0.0327709) , 
3, 1.37466, 1, 0, 0.208145,0.0233298) , 
1, 1.28112, 1, 0, 0.23953,0.000929565)    );
  // itree = 833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342742,-0.0130189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188742,-0.000627592) , 
3, -0.382409, 1, 0, 0.258182,0.00171816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273973,-0.056752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18,0.0586681) , 
3, 0.508884, 1, 0, 0.115607,-0.0483381) , 
1, 1.37683, 1, 0, 0.233467,-0.00695892)    );
  // itree = 834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382812,0.00197656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284024,-0.0331785) , 
1, -0.104333, 1, 0, 0.343529,-0.0124876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219448,-0.0152972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224747,0.0147694) , 
0, 0.258746, 1, 0, 0.222151,0.0221948) , 
3, -1.12835, 1, 0, 0.248231,0.0147429)    );
  // itree = 835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186312,-0.00173034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23913,0.00373225) , 
2, -1.00915, 1, 0, 0.225225,-0.0180097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314815,0.022692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209449,-0.0317789) , 
0, 0.263937, 1, 0, 0.245047,0.0134227) , 
3, -0.0592526, 1, 0, 0.234934,-0.00261454)    );
  // itree = 836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104089,0.00189658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0440252,-0.0404104) , 
2, -0.979921, 1, 0, 0.0618785,-0.0153405) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308577,-0.00021457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.818182,0.0369485) , 
3, 1.80798, 1, 0, 0.365831,0.00794614) , 
3, -0.322723, 1, 0, 0.227043,-0.00268675)    );
  // itree = 837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513726,0.00585101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254344,-0.0159714) , 
2, -0.994889, 1, 0, 0.328829,-0.00638573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26195,0.0137219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990291,-0.00542207) , 
3, 0.752543, 1, 0, 0.181118,0.0183798) , 
3, -0.209253, 1, 0, 0.249221,0.00696144)    );
  // itree = 838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383929,0.00362911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130719,-0.013877) , 
3, -0.373137, 1, 0, 0.26324,0.0171663) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230496,-0.00103021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923077,-0.00781257) , 
3, 1.64697, 1, 0, 0.204611,-0.011502) , 
1, 0.927816, 1, 0, 0.242669,0.00710777)    );
  // itree = 839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0778204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.00527211) , 
1, -1.47026, 1, 0, 0.257537,0.00155515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.103146) , 
1, 1.77534, 1, 0, 0.243361,-0.00156972)    );
  // itree = 840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0805936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312572,0.0211299) , 
3, -2.13952, 1, 0, 0.279094,0.0184798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189032,-0.0157904) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35023,0.0093878) , 
2, 1.43656, 1, 0, 0.221601,-0.00996108) , 
1, 0.302097, 1, 0, 0.2489,0.0035431)    );
  // itree = 841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379902,-0.00487754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230823,0.00121284) , 
3, -1.18507, 1, 0, 0.264079,0.0116318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183673,0.0431603) , 
1, 1.59889, 1, 0, 0.258097,0.00580837)    );
  // itree = 842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276995,0.00431639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302732,-0.00263821) , 
1, -0.927976, 1, 0, 0.297872,0.0159279) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230994,0.00552522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0886076,0.00729197) , 
3, 1.67978, 1, 0, 0.204276,-0.0214402) , 
0, 0.23336, 1, 0, 0.257868,-4.3653e-05)    );
  // itree = 843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12973,-0.0329678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.363415,-0.000908741) , 
3, -0.979297, 1, 0, 0.252564,0.0168569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231504,0.00865415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251557,-0.00174676) , 
0, -0.169725, 1, 0, 0.244681,-0.0111451) , 
2, -0.204072, 1, 0, 0.247752,-0.000235244)    );
  // itree = 844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285324,0.0162292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316176,-0.049392) , 
2, 1.01291, 1, 0, 0.288727,0.0121113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103571,-0.0628594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2607,0.012974) , 
0, -0.167338, 1, 0, 0.20529,-0.0123668) , 
1, 0.836849, 1, 0, 0.256043,0.00252296)    );
  // itree = 845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614815,0.0043278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318792,0.0032011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194067,-0.00912185) , 
2, -0.934841, 1, 0, 0.213466,-0.00364309) , 
1, -1.3293, 1, 0, 0.239883,0.000254948)    );
  // itree = 846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347734,-0.00154135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265136,0.00238665) , 
0, 0.155609, 1, 0, 0.320028,-0.0051098) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00900901,-0.0769249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113924,-0.0100452) , 
0, -0.122912, 1, 0, 0.0963855,0.0222308) , 
3, 0.540694, 1, 0, 0.249044,0.00356808)    );
  // itree = 847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208101,-0.00537858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.369963,0.0195521) , 
0, 0.713379, 1, 0, 0.234018,-0.00323206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651899,0.0229565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116438,-0.0497711) , 
3, 1.12892, 1, 0, 0.394737,0.0249284) , 
0, 1.21599, 1, 0, 0.258337,0.00102915)    );
  // itree = 848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0636364,-0.0114696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269022,0.0376586) , 
3, -1.01777, 1, 0, 0.17192,0.021069) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219087,-0.0196816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.866071,0.041052) , 
3, 1.88413, 1, 0, 0.274108,-0.014725) , 
2, -0.385597, 1, 0, 0.23871,-0.0023259)    );
  // itree = 849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299435,0.00493062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118421,0.013887) , 
3, 1.10696, 1, 0, 0.283668,-0.0033685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.029703,-0.0213966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163265,0.0224088) , 
0, 1.02551, 1, 0, 0.0954774,-0.0577827) , 
3, 1.60009, 1, 0, 0.264403,-0.00893868)    );
  // itree = 850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306006,0.00195138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196541,-0.00849008) , 
0, 0.230153, 1, 0, 0.264688,0.00194287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0344828,-0.0342595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150602,-0.00390089) , 
0, 1.12114, 1, 0, 0.096463,0.052952) , 
3, 1.33934, 1, 0, 0.238477,0.00989069)    );
  // itree = 851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175676,-0.00060245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34589,-0.000953275) , 
0, 0.0630802, 1, 0, 0.253661,-0.00829559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759494,-0.0115837) , 
3, 1.75738, 1, 0, 0.240097,-0.00326292)    );
  // itree = 852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123894,0.0362085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.095339,-0.0307527) , 
2, -1.17755, 1, 0, 0.100855,-0.0139828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651452,0.0300827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367188,-0.000197522) , 
1, 0.375695, 1, 0, 0.444949,0.0136806) , 
3, 0.108015, 1, 0, 0.248659,-0.00210009)    );
  // itree = 853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361809,-0.00511422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641791,0.0177358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20184,-0.00336875) , 
1, -1.06103, 1, 0, 0.233316,-7.90625e-05) , 
0, -1.20662, 1, 0, 0.245656,0.00421155)    );
  // itree = 854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.583333,0.0557275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392857,-0.0225713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224689,-0.00172096) , 
0, -1.30211, 1, 0, 0.236537,0.00275961) , 
3, -2.18002, 1, 0, 0.254415,0.000204709)    );
  // itree = 855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194051,0.00578999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225734,0.00603461) , 
2, 0.197041, 1, 0, 0.206266,0.00904908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428745,0.0236677) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0776918) , 
3, 1.89249, 1, 0, 0.38013,-0.016714) , 
0, 0.224301, 1, 0, 0.283855,-0.00244808)    );
  // itree = 856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242647,0.00472795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164855,-0.0310926) , 
0, 0.653609, 1, 0, 0.220188,-0.00611987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862745,0.0346739) , 
3, 2.00929, 1, 0, 0.252731,-0.00250346)    );
  // itree = 857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414883,0.00745239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139303,0.000670368) , 
3, 0.671929, 1, 0, 0.36802,-0.000213781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.0147453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147727,0.0243634) , 
0, -0.544524, 1, 0, 0.138381,-0.0202529) , 
1, 0.71227, 1, 0, 0.277721,-0.00809363)    );
  // itree = 858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252554,-0.00670188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0208333,-0.0551511) , 
3, 1.54521, 1, 0, 0.235047,-0.00411772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324176,0.0361831) , 
1, 1.5317, 1, 0, 0.242816,-1.6043e-05)    );
  // itree = 859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00288184,-0.0570308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255155,-0.00836436) , 
1, -0.652328, 1, 0, 0.19722,0.0328917) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522184,0.00980075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232227,0.00901702) , 
2, 0.949885, 1, 0, 0.400794,-0.0116127) , 
0, 0.828962, 1, 0, 0.248139,0.02176)    );
  // itree = 860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167832,0.0355836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0772414,-0.0307127) , 
2, -0.960694, 1, 0, 0.102868,-0.00565305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.604938,0.0368971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353425,0.00208865) , 
1, 0.181918, 1, 0, 0.416238,0.0189543) , 
3, -0.0186245, 1, 0, 0.256552,0.00641495)    );
  // itree = 861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335083,-0.00673607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113874,-0.00140792) , 
1, 0.616373, 1, 0, 0.24646,-0.00154258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219512,0.0418471) , 
1, 1.63248, 1, 0, 0.244828,-0.00634595)    );
  // itree = 862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304556,9.76836e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227041,0.00964319) , 
0, 0.668373, 1, 0, 0.286062,-0.00705137) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0181818,-0.0611874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159509,0.00944348) , 
0, 1.03355, 1, 0, 0.0884146,0.0288528) , 
3, 1.19852, 1, 0, 0.253171,-0.00107645)    );
  // itree = 863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0721649,0.0735221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282416,0.00190237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0761316) , 
3, 2.0373, 1, 0, 0.266629,0.0106688) , 
3, -1.74385, 1, 0, 0.247605,0.00622427)    );
  // itree = 864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214861,-0.000915059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159631,-0.0196292) , 
0, 0.213324, 1, 0, 0.192533,-0.00890327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677632,-0.0261372) , 
3, 1.73078, 1, 0, 0.22891,-0.0120666)    );
  // itree = 865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343195,-0.00851707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252679,0.00113761) , 
0, -1.41761, 1, 0, 0.260556,-0.0038686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192982,0.0360038) , 
1, 1.65151, 1, 0, 0.256809,-0.00706512)    );
  // itree = 866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35122,-0.00292004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191344,0.000986667) , 
3, -0.357048, 1, 0, 0.268551,0.00391631) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.075,-0.0223395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163265,-0.0079737) , 
1, 0.133884, 1, 0, 0.134247,-0.0352708) , 
0, 1.11463, 1, 0, 0.244789,-0.00301694)    );
  // itree = 867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.00101815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21262,-0.00848645) , 
3, -0.847893, 1, 0, 0.175654,0.0132161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373112,-0.00903393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132597,0.0094411) , 
3, 1.59928, 1, 0, 0.321471,-0.0120532) , 
0, 0.310699, 1, 0, 0.235123,0.00291031)    );
  // itree = 868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253388,0.00590717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277108,-0.0250734) , 
0, 1.35023, 1, 0, 0.255502,0.00274181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.491525,0.0486044) , 
1, 1.63248, 1, 0, 0.269561,0.00818031)    );
  // itree = 869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348263,0.00512648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110236,-0.00620909) , 
3, 0.292664, 1, 0, 0.272784,0.0137754) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164286,-0.0251151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202247,0.0244041) , 
2, 0.20549, 1, 0, 0.189189,-0.0256609) , 
0, 1.04529, 1, 0, 0.255849,0.00578609)    );
  // itree = 870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281818,-0.00396225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254296,0.0222055) , 
0, 0.451265, 1, 0, 0.272879,-0.0062702) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0364406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.0448781) , 
3, 2.00624, 1, 0, 0.0445545,0.0430852) , 
3, 1.63045, 1, 0, 0.249749,-0.0012703)    );
  // itree = 871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0836653,-0.040043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359401,0.0194589) , 
0, -0.525496, 1, 0, 0.233908,-0.00797706) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.638743,0.0542999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158462,-0.0320411) , 
2, -0.0446537, 1, 0, 0.267539,0.0141143) , 
3, 0.127977, 1, 0, 0.248457,0.00157997)    );
  // itree = 872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405797,-0.0431819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0174419,-0.0210183) , 
2, -0.223011, 1, 0, 0.032882,-0.0214935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44582,0.0229335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297227,0.00090519) , 
1, -0.141858, 1, 0, 0.329722,0.00903703) , 
3, -0.931712, 1, 0, 0.252758,0.00112114)    );
  // itree = 873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3799,0.0117779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.03125,-0.0430197) , 
3, 0.918355, 1, 0, 0.34016,-0.00928369) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969163,-0.0413275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144124,0.00757603) , 
3, 0.655072, 1, 0, 0.120442,0.0148808) , 
2, 0.349516, 1, 0, 0.24211,0.00149976)    );
  // itree = 874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421348,0.0110949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227623,-0.00601533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,0.0264946) , 
3, 1.93203, 1, 0, 0.221664,-0.00151576) , 
3, -1.79067, 1, 0, 0.239716,-0.00459148)    );
  // itree = 875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0358566,0.0174562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108417,-0.00339433) , 
3, -1.32117, 1, 0, 0.0892857,0.0113036) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430017,-0.0016533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00846927) , 
3, 0.696194, 1, 0, 0.389598,-0.0187515) , 
1, 0.327816, 1, 0, 0.244546,-0.00423481)    );
  // itree = 876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23622,0.0555829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709746,-0.0266433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382493,0.00410672) , 
3, -0.0884848, 1, 0, 0.235088,-0.0046546) , 
1, -1.36088, 1, 0, 0.235156,-0.000402099)    );
  // itree = 877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632353,0.0226626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270231,-0.0162144) , 
2, -1.26535, 1, 0, 0.352679,-0.0124224) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234824,0.010104) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102612,-0.0157657) , 
2, 0.678836, 1, 0, 0.173838,0.0219991) , 
3, -0.347261, 1, 0, 0.251701,0.00701286)    );
  // itree = 878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414966,-0.0097592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167539,-0.0143362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248945,0.00771161) , 
1, -0.960884, 1, 0, 0.240541,-0.00241084) , 
0, -1.43147, 1, 0, 0.25338,0.00107511)    );
  // itree = 879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0855263,-0.022833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.723214,0.0725347) , 
3, -1.06737, 1, 0, 0.356061,-0.0410688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221488,-0.00486505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244224,0.00311161) , 
3, 0.6034, 1, 0, 0.229075,0.00805985) , 
2, -1.23173, 1, 0, 0.245192,0.00182429)    );
  // itree = 880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117241,0.0163077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.02457,-0.0488767) , 
2, -1.2712, 1, 0, 0.048913,-0.0133792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379205,0.0364192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33301,0.00380947) , 
0, -0.282097, 1, 0, 0.344141,0.0164801) , 
3, -0.738559, 1, 0, 0.258774,0.00784612)    );
  // itree = 881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41129,-0.00741007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227679,0.00917355) , 
3, -1.13437, 1, 0, 0.324153,0.0291339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385475,0.0277818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211884,-0.00492843) , 
2, -1.00475, 1, 0, 0.233196,-0.00202583) , 
0, -0.659236, 1, 0, 0.25544,0.00559457)    );
  // itree = 882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345133,0.000703507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208856,-0.00122786) , 
0, -0.73078, 1, 0, 0.242944,-0.00692496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348837,0.0138791) , 
2, 1.77922, 1, 0, 0.25,-0.00290884)    );
  // itree = 883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186916,0.0496083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776699,0.194308) , 
2, -1.05991, 1, 0, 0.047619,-0.0413317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25608,-0.00918879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258503,1.83132e-05) , 
3, 0.887491, 1, 0, 0.256661,0.00377167) , 
1, -1.06103, 1, 0, 0.235237,-0.000850925)    );
  // itree = 884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133503,-0.00686046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483209,0.0158182) , 
3, 0.426007, 1, 0, 0.242991,0.0045669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0458015,-0.025574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542373,-0.0394192) , 
3, 1.32141, 1, 0, 0.281125,-0.0460669) , 
2, 1.36808, 1, 0, 0.247833,-0.00186238)    );
  // itree = 885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324773,0.00169575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0954654,-0.0143875) , 
2, 0.744613, 1, 0, 0.26965,-0.00578314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.080548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0572917,-0.0521003) , 
0, 0.843946, 1, 0, 0.0350318,0.0477954) , 
3, 1.30263, 1, 0, 0.233836,0.0023956)    );
  // itree = 886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201835,-0.0345013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0479452,-0.0271201) , 
0, -0.872006, 1, 0, 0.113725,-0.0354474) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486891,0.0297243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242647,0.00540104) , 
3, -1.20593, 1, 0, 0.279637,0.00180333) , 
2, -1.27601, 1, 0, 0.258672,-0.00290378)    );
  // itree = 887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0528736,-0.0237495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316216,0.00363691) , 
1, -0.545232, 1, 0, 0.256397,0.00172851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.103152) , 
1, 1.77534, 1, 0, 0.241872,-0.00171119)    );
  // itree = 888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0594937,-0.0310333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424419,0.0141254) , 
3, -0.357048, 1, 0, 0.249697,0.000702353) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171569,-0.0113723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293233,-0.0500576) , 
2, 1.19827, 1, 0, 0.219585,-0.0406507) , 
0, 1.13453, 1, 0, 0.24459,-0.00631122)    );
  // itree = 889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378295,0.00161711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238754,0.00792896) , 
3, -0.732641, 1, 0, 0.288728,-0.00522608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955414,-0.0112691) , 
3, 1.77248, 1, 0, 0.273238,-0.00796361)    );
  // itree = 890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290768,0.00110882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183702,-0.0106915) , 
1, 0.836849, 1, 0, 0.249602,-0.00645735) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163793,-0.00157402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16,0.00457373) , 
3, 1.08356, 1, 0, 0.161826,0.0513686) , 
0, 1.32355, 1, 0, 0.239642,0.000103881)    );
  // itree = 891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179655,-0.000359136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386364,0.000834774) , 
0, 0.403838, 1, 0, 0.245673,-0.00794865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132353,-0.00204623) , 
3, 1.73078, 1, 0, 0.237675,-0.0030307)    );
  // itree = 892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229961,0.0183066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207249,-0.01095) , 
0, -0.295264, 1, 0, 0.216658,0.00145061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.706806,0.0289804) , 
3, 1.63045, 1, 0, 0.262821,0.00677975)    );
  // itree = 893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437788,-0.00661309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284165,0.00184995) , 
3, -1.00161, 1, 0, 0.333333,0.00899049) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0728291,-0.015426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140893,0.0424381) , 
3, 0.785218, 1, 0, 0.103395,-0.0283832) , 
1, 1.01701, 1, 0, 0.258982,-0.00309442)    );
  // itree = 894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242604,-0.00412654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438163,0.0120783) , 
2, 1.14298, 1, 0, 0.273282,0.00173383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0607735,-0.0284027) , 
3, 1.65635, 1, 0, 0.253904,-0.0025327)    );
  // itree = 895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0271739,-0.0306854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291998,0.00537113) , 
0, -1.04815, 1, 0, 0.265239,0.00535802) , 
0, -1.70211, 1, 0, 0.250649,0.00936229)    );
  // itree = 896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146148,-0.00139855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476636,0.0261946) , 
3, 0.659999, 1, 0, 0.223996,0.0103243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.634518,-0.0296962) , 
3, 1.68133, 1, 0, 0.264151,0.00331815)    );
  // itree = 897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343803,0.00346338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992126,-0.0201777) , 
3, 0.253475, 1, 0, 0.258136,0.0103954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193939,0.0156338) , 
0, 1.40235, 1, 0, 0.252781,0.00564897)    );
  // itree = 898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25015,-0.00491567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398844,-0.00614051) , 
2, 1.36291, 1, 0, 0.26413,0.00161607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0528846,-0.0299922) , 
3, 1.61709, 1, 0, 0.242676,0.00715677)    );
  // itree = 899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255396,0.00221096) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.418719,0.0394938) , 
2, 1.35088, 1, 0, 0.273116,-0.00663467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0774624) , 
3, 1.90896, 1, 0, 0.257431,-0.00267927)    );
  // itree = 900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184783,-0.00295632) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.0727832) , 
0, -0.340194, 1, 0, 0.181818,-0.0351699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29595,0.0327665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254649,0.00180007) , 
1, -0.179059, 1, 0, 0.262362,0.00937616) , 
1, -0.840753, 1, 0, 0.250873,0.00302196)    );
  // itree = 901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.527523,0.0250134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198473,-0.017562) , 
3, -0.598009, 1, 0, 0.404011,0.0140191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198083,-0.0118414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122137,0.00559759) , 
3, 0.821959, 1, 0, 0.175676,-0.0106675) , 
2, -0.385597, 1, 0, 0.254187,-0.00217919)    );
  // itree = 902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338762,0.00895598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1575,-0.000793387) , 
0, 0.556597, 1, 0, 0.283876,0.00522202) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183333,-0.00528971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310606,0.0345728) , 
0, 0.911899, 1, 0, 0.210784,-0.0210227) , 
1, 1.03517, 1, 0, 0.260735,-0.00308722)    );
  // itree = 903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160207,-0.0129861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304348,0.00252045) , 
3, 0.677581, 1, 0, 0.185997,0.00541026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410579,0.0158043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397196,0.00616418) , 
1, 0.930416, 1, 0, 0.405892,-0.0201916) , 
0, 0.709543, 1, 0, 0.252346,-0.00231456)    );
  // itree = 904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12087,-0.00287832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43002,0.0170763) , 
3, 0.416016, 1, 0, 0.208766,0.00637404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.673469,-0.00305812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525773,-0.0366982) , 
1, 1.30246, 1, 0, 0.6,-0.0411698) , 
3, 1.64517, 1, 0, 0.248315,0.0015679)    );
  // itree = 905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458549,-0.0126564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168224,-0.00662289) , 
1, -0.321883, 1, 0, 0.258454,0.0195862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288235,0.025921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187192,-0.00624122) , 
0, 0.553871, 1, 0, 0.209243,-0.0174064) , 
0, 0.29569, 1, 0, 0.239485,0.00532729)    );
  // itree = 906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504065,0.035939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238418,-0.000343569) , 
3, -1.97613, 1, 0, 0.255679,-0.00685125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321678,0.0117476) , 
1, 1.59889, 1, 0, 0.260314,-0.00372498)    );
  // itree = 907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0861925,-0.0301293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122302,-0.0217141) , 
3, 1.15253, 1, 0, 0.089955,0.00774717) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659794,0.0389266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.460285,-0.00590555) , 
0, -0.282097, 1, 0, 0.516788,-0.024183) , 
1, 0.909404, 1, 0, 0.23477,-0.003086)    );
  // itree = 908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172174,0.0145126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860534,-0.0286071) , 
0, -0.420895, 1, 0, 0.125701,-0.004503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.737931,0.0622652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463415,0.0108242) , 
1, 0.0619297, 1, 0, 0.518776,0.035058) , 
3, 0.440469, 1, 0, 0.269309,0.00995045)    );
  // itree = 909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.584314,0.0251461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254111,-0.0122369) , 
2, -1.00216, 1, 0, 0.345238,-0.0114085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0960854,-0.00635187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229381,0.0176825) , 
0, -0.0438983, 1, 0, 0.193945,0.00786303) , 
3, -0.227317, 1, 0, 0.264513,-0.0011258)    );
  // itree = 910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201474,-0.0147214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188946,-0.00260525) , 
1, -0.492279, 1, 0, 0.193249,0.00673988) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313625,0.0176759) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261603,-0.0110392) , 
1, 0.75909, 1, 0, 0.285052,-0.0274482) , 
2, 0.324939, 1, 0, 0.231934,-0.00766653)    );
  // itree = 911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187888,-0.00933602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.862745,0.0920402) , 
3, 0.581229, 1, 0, 0.280161,0.00698611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236817,-0.00746894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191781,0.0435063) , 
3, 1.44312, 1, 0, 0.229002,-0.0290269) , 
2, -0.308659, 1, 0, 0.248008,-0.0156476)    );
  // itree = 912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0183824,-0.0471774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323675,0.015793) , 
3, -1.51227, 1, 0, 0.267568,0.011426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189125,-0.0313557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401709,0.0203246) , 
1, 1.22177, 1, 0, 0.235185,-0.0198142) , 
0, 0.759972, 1, 0, 0.258911,0.00307467)    );
  // itree = 913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279808,0.00242875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0772727,-0.0081548) , 
2, 1.31783, 1, 0, 0.25622,0.000249977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,0.000651724) , 
3, 1.91635, 1, 0, 0.249749,0.00463213)    );
  // itree = 914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352554,0.00808144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853659,-0.0310028) , 
3, -0.695211, 1, 0, 0.199019,0.0109233) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30303,0.0123087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326693,-0.00136975) , 
2, 1.45332, 1, 0, 0.31221,-0.0183356) , 
2, 0.68168, 1, 0, 0.23433,0.00179578)    );
  // itree = 915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236006,-0.00861119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313808,0.00848259) , 
2, 0.63064, 1, 0, 0.256667,0.00906546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265487,0.0789094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220588,0.000408934) , 
1, 1.19855, 1, 0, 0.240964,-0.0499365) , 
3, 1.46024, 1, 0, 0.254758,0.00189539)    );
  // itree = 916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228477,0.0139873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152318,-0.0245046) , 
0, -0.0223306, 1, 0, 0.193859,-0.0022464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403361,0.00695647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.75,0.0394242) , 
2, 0.885767, 1, 0, 0.617363,0.0568592) , 
3, 1.30263, 1, 0, 0.260649,0.00707502)    );
  // itree = 917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.452954,-0.00927603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186869,-0.00291765) , 
1, -0.542141, 1, 0, 0.252849,0.00237432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0294118,-0.0668803) , 
2, 1.7595, 1, 0, 0.237494,0.00730416)    );
  // itree = 918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283356,0.0109027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261633,0.000167904) , 
1, 0.013314, 1, 0, 0.270096,0.00375442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0459551) , 
3, 1.9923, 1, 0, 0.25813,0.00716859)    );
  // itree = 919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248545,-0.00344771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.011528) , 
3, 1.41422, 1, 0, 0.256284,-0.00482554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165605,0.0473185) , 
3, 1.73078, 1, 0, 0.249119,-0.00963662)    );
  // itree = 920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0273973,-0.0328978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387417,0.0371361) , 
3, -1.66191, 1, 0, 0.270089,0.0332347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261886,0.00741299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.01872) , 
2, 1.28335, 1, 0, 0.271684,0.00266875) , 
1, -0.484715, 1, 0, 0.271329,0.00946117)    );
  // itree = 921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513761,0.00366829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,-0.018083) , 
0, -0.0394809, 1, 0, 0.411043,-0.0210978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34127,-7.20217e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192922,-0.00524251) , 
2, -0.620557, 1, 0, 0.215003,0.00498469) , 
2, -1.10481, 1, 0, 0.246657,0.000773248)    );
  // itree = 922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298887,-0.0051443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430108,0.00503051) , 
2, 0.427651, 1, 0, 0.328834,-0.0180633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2287,0.000403446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213508,0.00748339) , 
0, 0.109437, 1, 0, 0.216477,0.00440199) , 
0, -0.22297, 1, 0, 0.263292,-0.00495853)    );
  // itree = 923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0766779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39521,0.0194378) , 
1, 0.00811052, 1, 0, 0.196721,0.00586004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332164,0.0134381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259953,-0.00709568) , 
3, 0.855556, 1, 0, 0.308112,-0.00919289) , 
0, -0.361587, 1, 0, 0.269841,-0.0040211)    );
  // itree = 924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.02309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344,0.030594) , 
3, -1.13268, 1, 0, 0.207048,0.0169351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0445969,-0.0411161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426952,-0.0021348) , 
3, 0.100021, 1, 0, 0.265069,-0.0114449) , 
0, -0.427027, 1, 0, 0.24587,-0.00205384)    );
  // itree = 925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448161,-0.00457723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19403,0.0130185) , 
1, -0.191146, 1, 0, 0.302425,0.0154687) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478571,-0.00471922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191919,0.00161345) , 
1, -0.767868, 1, 0, 0.222139,-0.00654003) , 
0, -0.364724, 1, 0, 0.249877,0.00106379)    );
  // itree = 926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233333,-0.0112484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0710383,-0.0347451) , 
1, 0.600425, 1, 0, 0.182823,0.00674461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401799,0.0174175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875,-0.00608592) , 
3, 1.59855, 1, 0, 0.340992,-0.0190059) , 
2, 0.352049, 1, 0, 0.248128,-0.00388728)    );
  // itree = 927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162611,0.000360691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255639,-0.0158977) , 
3, -0.0576269, 1, 0, 0.197075,0.0166914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438596,0.0164159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.425076,0.0153154) , 
1, 0.207092, 1, 0, 0.429719,-0.023079) , 
0, 0.823264, 1, 0, 0.25698,0.00645062)    );
  // itree = 928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168871,-0.0053667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780142,-0.0621541) , 
2, 0.400836, 1, 0, 0.141536,-0.0165422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0824742,-0.0727437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.599483,0.0148846) , 
2, -0.133096, 1, 0, 0.495868,0.0081616) , 
3, 0.802894, 1, 0, 0.232275,-0.0102159)    );
  // itree = 929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.658915,0.0443253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892857,-0.0409015) , 
3, -0.379303, 1, 0, 0.486486,-0.0329833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330144,0.00282683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179004,-0.00769526) , 
2, -0.551131, 1, 0, 0.19764,0.00722556) , 
2, -0.963671, 1, 0, 0.249395,2.10635e-05)    );
  // itree = 930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204152,0.000198697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257143,-0.00773685) , 
1, -0.838416, 1, 0, 0.224138,0.0215928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276306,0.00743363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273504,0.050918) , 
0, 1.55414, 1, 0, 0.27609,-0.0122285) , 
1, -0.451368, 1, 0, 0.263903,-0.00429467)    );
  // itree = 931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224622,-0.00505639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311628,0.000384415) , 
3, 0.793921, 1, 0, 0.24519,-8.15186e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0985044) , 
1, 1.7097, 1, 0, 0.232292,-0.00292285)    );
  // itree = 932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0168067,-0.0507839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240363,0.0306544) , 
3, -1.34141, 1, 0, 0.162003,0.0148167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297436,-0.0287042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273836,0.00262486) , 
1, 0.16286, 1, 0, 0.28096,-0.00956979) , 
2, -0.361538, 1, 0, 0.23998,-0.00116877)    );
  // itree = 933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448485,-0.0322068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542056,0.0168953) , 
0, -0.468488, 1, 0, 0.485294,0.0494558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2063,-0.00229778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135593,0.0279732) , 
2, 1.79476, 1, 0, 0.201497,-0.00666348) , 
1, -0.853765, 1, 0, 0.23992,0.000934541)    );
  // itree = 934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259107,-0.00323074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0168539,-0.0394559) , 
3, 1.4525, 1, 0, 0.23617,-0.0104078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.0044267) , 
2, 1.68193, 1, 0, 0.245375,-0.00661894)    );
  // itree = 935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250911,0.00326953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0165388) , 
1, 1.47936, 1, 0, 0.263742,-0.002781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18797,0.0063902) , 
2, 1.76296, 1, 0, 0.258532,-0.00563755)    );
  // itree = 936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221837,0.0208968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355263,-0.0157141) , 
2, -0.18058, 1, 0, 0.285843,0.00322147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.101849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20802,-0.0135331) , 
0, -0.76779, 1, 0, 0.193798,-0.0239022) , 
1, 0.606823, 1, 0, 0.244533,-0.00895183)    );
  // itree = 937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538043,0.0253922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259959,0.00047715) , 
2, -1.45854, 1, 0, 0.290691,0.00297735) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0478695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100478,-0.00887477) , 
0, 0.455044, 1, 0, 0.0722892,-0.032934) , 
2, 1.23898, 1, 0, 0.254382,-0.00299289)    );
  // itree = 938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282224,0.0138476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39645,-0.00810684) , 
2, 1.34665, 1, 0, 0.292913,-0.00762278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0639535,-0.0137572) , 
3, 1.73078, 1, 0, 0.273003,-0.00284846)    );
  // itree = 939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188272,0.00177423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2634,-0.00157811) , 
3, -0.0387591, 1, 0, 0.218462,0.0150058) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.576037,0.0438541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173333,-0.0536439) , 
1, 0.803354, 1, 0, 0.411444,-0.0143661) , 
0, 1.07303, 1, 0, 0.254016,0.00959441)    );
  // itree = 940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237288,0.041514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263205,0.00629814) , 
1, -0.791106, 1, 0, 0.25779,0.0145671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153979,-0.0267841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813084,0.0188322) , 
3, 1.91527, 1, 0, 0.256934,-0.0184466) , 
0, 0.643691, 1, 0, 0.257511,0.00378295)    );
  // itree = 941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377816,-0.00982634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221574,0.0156804) , 
3, -0.83982, 1, 0, 0.277709,0.012247) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253623,0.0206597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195767,0.0401635) , 
2, 0.882692, 1, 0, 0.230108,-0.0384507) , 
0, 0.896613, 1, 0, 0.267021,0.000863882)    );
  // itree = 942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212679,-0.013397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.00970642) , 
1, 0.774302, 1, 0, 0.164157,0.00985794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297114,0.0162472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281609,-0.0174582) , 
2, 1.66176, 1, 0, 0.295118,-0.0138934) , 
2, -0.38767, 1, 0, 0.251984,-0.00607051)    );
  // itree = 943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136774,-0.0221469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35034,0.0251219) , 
3, -0.04262, 1, 0, 0.19551,0.0152244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375652,0.00531774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198556,-0.0126459) , 
3, 1.08333, 1, 0, 0.318075,-0.00831016) , 
0, 0.133846, 1, 0, 0.24987,0.00478639)    );
  // itree = 944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0846938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247525,0.00918692) , 
2, -0.786685, 1, 0, 0.248756,0.0530531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195983,-0.00225501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509615,-0.0219877) , 
3, 1.26042, 1, 0, 0.251708,-0.00960703) , 
0, -1.2053, 1, 0, 0.251405,-0.00317132)    );
  // itree = 945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286925,0.0057372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392857,-0.0350925) , 
3, 1.15239, 1, 0, 0.251035,-0.00800279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193798,-0.000874526) , 
0, 1.52075, 1, 0, 0.247453,-0.00367846)    );
  // itree = 946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337584,0.00497006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0861244,-0.0208082) , 
3, 0.662859, 1, 0, 0.277556,0.000629234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940171,-0.0213149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245098,0.0387231) , 
1, 0.512998, 1, 0, 0.164384,-0.0305976) , 
0, 1.31913, 1, 0, 0.264975,-0.00284217)    );
  // itree = 947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157658,-0.0101647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440329,0.0585243) , 
2, -0.2064, 1, 0, 0.257642,-0.022805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128467,-0.011215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432647,0.00295236) , 
1, 0.764604, 1, 0, 0.274316,0.010789) , 
3, -0.691091, 1, 0, 0.268597,-0.000733262)    );
  // itree = 948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143868,0.00450265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0289116,-0.0603465) , 
1, -0.358201, 1, 0, 0.0770751,-0.0144364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.560784,0.0388066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405028,-0.000888804) , 
0, 0.0147032, 1, 0, 0.445932,0.016117) , 
3, -0.097287, 1, 0, 0.25769,0.000524436)    );
  // itree = 949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471014,0.0191626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163636,0.0205388) , 
1, 0.311663, 1, 0, 0.38342,-0.0304213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321534,-0.00189778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162556,0.00374975) , 
3, 0.0048822, 1, 0, 0.23121,0.0056384) , 
0, -0.845339, 1, 0, 0.261247,-0.00147767)    );
  // itree = 950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46,0.0256716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358696,0.00961248) , 
3, -1.99412, 1, 0, 0.394366,-0.018801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0379404,-0.0659912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276466,0.00786199) , 
2, -0.55078, 1, 0, 0.224138,0.0117739) , 
3, -1.43642, 1, 0, 0.248728,0.00735715)    );
  // itree = 951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219603,0.00469621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.883212,0.0992867) , 
3, 0.600431, 1, 0, 0.316013,-0.0110961) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184615,-0.037085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215909,-0.0119716) , 
2, 0.180583, 1, 0, 0.212204,0.0101281) , 
2, -0.00704753, 1, 0, 0.260167,0.000321926)    );
  // itree = 952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22314,0.052086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209834,-0.00830279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.764706,0.0172677) , 
3, 1.75412, 1, 0, 0.254469,-0.00533185) , 
0, -1.61795, 1, 0, 0.252595,-0.00175701)    );
  // itree = 953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424528,0.0111676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137313,-0.0122984) , 
2, 0.483066, 1, 0, 0.349884,0.00646195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121739,0.015741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0820106,-0.00939856) , 
2, 0.598975, 1, 0, 0.100968,-0.0206789) , 
1, 0.912495, 1, 0, 0.260437,-0.00329094)    );
  // itree = 954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456929,0.0100705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251889,-0.0190626) , 
3, -1.32999, 1, 0, 0.334337,0.0144984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261645,0.00535189) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894569,-0.0139489) , 
3, 1.20469, 1, 0, 0.220877,-0.00636426) , 
0, -0.419895, 1, 0, 0.258812,0.000610968)    );
  // itree = 955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0598086,0.00731682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.734848,0.0621654) , 
1, 0.492604, 1, 0, 0.221818,-0.0234007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635135,0.0643149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211652,-0.0107563) , 
2, -1.04608, 1, 0, 0.253324,0.00857557) , 
3, -0.961157, 1, 0, 0.244888,1.32836e-05)    );
  // itree = 956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707965,0.00122236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.01875,-0.0768917) , 
2, -1.00072, 1, 0, 0.040293,-0.0201587) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366486,0.0280444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26779,-0.0102156) , 
0, 0.689291, 1, 0, 0.330363,0.0193154) , 
3, -0.961157, 1, 0, 0.251372,0.00856582)    );
  // itree = 957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417355,0.00514818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10479,-0.0255275) , 
3, 0.344827, 1, 0, 0.337174,0.00976257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654206,-0.0211258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,0.0148854) , 
3, 0.580219, 1, 0, 0.0896226,-0.0291537) , 
1, 0.939437, 1, 0, 0.255934,-0.00300873)    );
  // itree = 958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445087,0.0239463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298077,-0.0404185) , 
1, -0.400748, 1, 0, 0.389892,-0.0189445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0301293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219298,-0.0058929) , 
0, -1.03008, 1, 0, 0.219512,0.0114186) , 
3, -1.54559, 1, 0, 0.243122,0.00721123)    );
  // itree = 959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168591,0.000996954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41791,0.0729419) , 
2, -0.190361, 1, 0, 0.247634,-0.0187203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417722,0.0103896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173077,-0.0202549) , 
2, -0.336826, 1, 0, 0.227983,0.0184865) , 
3, -0.900958, 1, 0, 0.234084,0.00693451)    );
  // itree = 960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162554,0.00369548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668103,0.0492953) , 
3, 0.101293, 1, 0, 0.289902,0.0226276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132716,-0.0549331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267516,0.00990794) , 
0, -0.172198, 1, 0, 0.221639,-0.00990314) , 
1, 0.352186, 1, 0, 0.255206,0.00609301)    );
  // itree = 961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410689,-0.00158856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211994,0.000755497) , 
3, -0.388717, 1, 0, 0.310924,0.0179087) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0513513,-0.0319496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143541,0.0431425) , 
3, 1.10016, 1, 0, 0.0846287,-0.0315624) , 
1, 1.14159, 1, 0, 0.24564,0.00363674)    );
  // itree = 962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153226,-0.0237958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441227,0.0118154) , 
2, -1.00974, 1, 0, 0.355689,-0.0149678) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159935,-0.0139574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192233,0.0139697) , 
0, 0.607299, 1, 0, 0.174603,0.0133675) , 
3, -0.412408, 1, 0, 0.251397,0.00135122)    );
  // itree = 963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0684211,0.0372357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0829694,-0.0307342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275925,-0.00178639) , 
0, -0.865908, 1, 0, 0.252396,0.0150769) , 
3, -1.7782, 1, 0, 0.235493,0.0117272)    );
  // itree = 964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256,0.0532434) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0898662,-0.0262755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464203,0.00941494) , 
3, 0.21524, 1, 0, 0.259414,-0.00288696) , 
1, -1.36088, 1, 0, 0.259205,0.00117327)    );
  // itree = 965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288162,-0.00966766) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259459,0.00422462) , 
0, -0.407171, 1, 0, 0.269977,0.00375976) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,0.0179289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131579,0.0079823) , 
2, 1.2622, 1, 0, 0.11215,-0.0536763) , 
3, 1.5479, 1, 0, 0.252798,-0.00249218)    );
  // itree = 966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297134,0.00057007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0327869,-0.04429) , 
3, 1.15253, 1, 0, 0.265076,0.00519332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217791,-0.00539798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178771,0.0191355) , 
3, 1.1051, 1, 0, 0.20396,-0.0288572) , 
1, 1.22653, 1, 0, 0.249752,-0.00334468)    );
  // itree = 967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159664,0.00490859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237473,-0.0058399) , 
3, -0.782318, 1, 0, 0.206874,0.0104854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471649,0.0223922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225225,-0.0354032) , 
1, 1.2094, 1, 0, 0.416834,-0.014602) , 
0, 0.823264, 1, 0, 0.258946,0.00426344)    );
  // itree = 968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0987654,-0.00989896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492063,0.0434031) , 
3, -0.491208, 1, 0, 0.208889,0.0124131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20367,-0.0205341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.689076,0.0208521) , 
3, 1.52047, 1, 0, 0.290663,-0.00899932) , 
0, -0.419895, 1, 0, 0.263105,-0.00178344)    );
  // itree = 969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266476,-0.00326526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22549,0.0583084) , 
1, 1.57624, 1, 0, 0.264212,-0.008306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582524,-0.0482687) , 
3, 1.96727, 1, 0, 0.253333,-0.00494838)    );
  // itree = 970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226523,-0.00477629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277657,-0.00890271) , 
2, 0.732633, 1, 0, 0.239224,8.10841e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322581,0.00338761) , 
2, 1.7595, 1, 0, 0.244444,0.00302059)    );
  // itree = 971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0852218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258749,-0.00201786) , 
1, -1.36088, 1, 0, 0.241564,0.00375838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303867,-0.0168281) , 
0, 1.42411, 1, 0, 0.24707,0.0086782)    );
  // itree = 972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281165,0.00334742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160121,-0.0186179) , 
1, 0.627177, 1, 0, 0.235662,-0.00449231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290598,-0.0705311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370629,0.00378277) , 
1, 1.1684, 1, 0, 0.334615,-0.0335864) , 
2, 1.40345, 1, 0, 0.248392,-0.00823524)    );
  // itree = 973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344724,-0.00545138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113343,-0.0155349) , 
3, 0.0172453, 1, 0, 0.249409,0.00303767) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172932,-0.00762525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164773,0.0113243) , 
2, 0.648876, 1, 0, 0.168285,-0.0340203) , 
0, 1.13453, 1, 0, 0.236882,-0.00268493)    );
  // itree = 974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172932,-0.0212317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00724638,-0.0559167) , 
1, 0.649282, 1, 0, 0.130354,0.0354355) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295302,0.00652573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263333,0.0056099) , 
1, 1.4094, 1, 0, 0.288874,-0.00639104) , 
2, -0.635384, 1, 0, 0.24692,0.00467888)    );
  // itree = 975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245362,-0.00401468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437811,0.0364724) , 
2, 1.25669, 1, 0, 0.266026,0.00538039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14375,0.0170309) , 
3, 1.68512, 1, 0, 0.256398,0.00999944)    );
  // itree = 976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146226,0.00376915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.046252,-0.0442089) , 
1, -0.364787, 1, 0, 0.0865842,-0.010175) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.467626,-0.0351095) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426683,0.0207078) , 
1, -0.147238, 1, 0, 0.432544,0.0202553) , 
3, -0.0237104, 1, 0, 0.25272,0.0044382)    );
  // itree = 977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.441718,-0.018807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274038,0.0151643) , 
3, -1.68098, 1, 0, 0.347709,0.028415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491736,0.0122144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186842,0.000915407) , 
1, -0.695692, 1, 0, 0.228717,-0.0153951) , 
0, -0.906156, 1, 0, 0.249414,-0.00777507)    );
  // itree = 978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442561,0.0136204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175292,-0.024305) , 
3, -0.746889, 1, 0, 0.300885,0.0134771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,0.0260148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222785,0.00449624) , 
1, -0.577554, 1, 0, 0.217344,-0.0249155) , 
0, 0.220084, 1, 0, 0.263596,-0.00365944)    );
  // itree = 979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.102244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.025,0.000139721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318622,0.00928871) , 
1, -1.12426, 1, 0, 0.29876,-0.0139109) , 
0, -1.26434, 1, 0, 0.272074,-0.00965201)    );
  // itree = 980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05125,-0.0283952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294054,0.00429464) , 
3, -0.50265, 1, 0, 0.181449,-0.00509083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.678832,0.00160592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426316,-0.0318195) , 
1, 1.01764, 1, 0, 0.53211,-0.0367737) , 
3, 1.21569, 1, 0, 0.237329,-0.0101397)    );
  // itree = 981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337331,0.00709486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.068323,-0.0175697) , 
3, 1.23305, 1, 0, 0.308361,0.00762505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0669456,-0.00958323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136187,0.0299745) , 
3, 0.523181, 1, 0, 0.102823,-0.0303663) , 
1, 1.2364, 1, 0, 0.257157,-0.00183938)    );
  // itree = 982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482517,0.0317413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319372,-0.0020449) , 
3, -1.84113, 1, 0, 0.389222,-0.0232823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23245,-0.00314997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,0.007438) , 
0, 1.33406, 1, 0, 0.226581,0.00442116) , 
3, -1.33958, 1, 0, 0.253183,-0.000110163)    );
  // itree = 983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0752406,-0.0452006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439024,0.0134072) , 
0, 0.886294, 1, 0, 0.171281,0.00752133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.669091,0.0170322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306878,0.0226548) , 
3, 1.08579, 1, 0, 0.521552,-0.0308559) , 
1, 1.29668, 1, 0, 0.251859,-0.00130714)    );
  // itree = 984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210938,0.00812429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.71564,0.0549682) , 
3, 0.57483, 1, 0, 0.307136,0.0246153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142336,-0.0260122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352518,0.0145144) , 
2, 1.11042, 1, 0, 0.213075,-0.00887026) , 
1, 0.606823, 1, 0, 0.266943,0.0103064)    );
  // itree = 985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.589928,0.0423457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225593,-0.00387846) , 
2, -1.53283, 1, 0, 0.251537,0.00270903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139344,0.00944209) , 
2, 1.85478, 1, 0, 0.244937,-0.000157887)    );
  // itree = 986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0801887,-0.0425626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207547,-0.00156383) , 
2, -1.34739, 1, 0, 0.122642,-0.03081) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258503,0.00307276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294118,0.000480433) , 
2, 1.28891, 1, 0, 0.26464,0.0108335) , 
2, -1.10481, 1, 0, 0.243075,0.00450939)    );
  // itree = 987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776398,0.0211049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0964467,-0.023586) , 
3, -1.14989, 1, 0, 0.090991,0.0158526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507519,0.0292169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379213,-0.0070011) , 
0, 0.446444, 1, 0, 0.456081,-0.0140797) , 
1, 0.583399, 1, 0, 0.253253,0.00254937)    );
  // itree = 988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269663,0.0239075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212157,-0.013787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.851485,0.02813) , 
3, 2.02642, 1, 0, 0.247792,-0.0107253) , 
0, -1.2692, 1, 0, 0.249749,-0.00722752)    );
  // itree = 989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.551402,0.00288459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263966,0.00248666) , 
3, -2.01383, 1, 0, 0.281682,-0.00176965) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813954,0.0197679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122807,-0.0115301) , 
0, 1.25097, 1, 0, 0.0979021,-0.0463604) , 
3, 1.30263, 1, 0, 0.255687,-0.00807674)    );
  // itree = 990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287695,0.000419529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258687,0.0101519) , 
0, 0.390886, 1, 0, 0.278708,0.00297073) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.029703,-0.0226758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130233,-0.00206015) , 
0, 0.590907, 1, 0, 0.0981013,-0.0535072) , 
3, 1.21569, 1, 0, 0.25,-0.00600664)    );
  // itree = 991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.082047) , 
3, -1.90152, 1, 0, 0,0.0277707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224242,0.117002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288679,-0.00559937) , 
0, -0.831508, 1, 0, 0.282621,-0.0153654) , 
0, -1.26434, 1, 0, 0.252932,-0.010834)    );
  // itree = 992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279895,0.015237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203532,-0.0134654) , 
1, 0.0518418, 1, 0, 0.235166,-0.00109491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513514,0.031261) , 
1, 1.65805, 1, 0, 0.251027,0.00214765)    );
  // itree = 993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430295,0.00576222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221667,0.00420308) , 
3, -0.221857, 1, 0, 0.337296,0.00958694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0300752,-0.0471558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0987903,0.000669392) , 
0, -0.478381, 1, 0, 0.0842607,-0.016866) , 
1, 1.01701, 1, 0, 0.256709,0.00116218)    );
  // itree = 994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309237,-0.00312615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0175439,-0.0556586) , 
3, 0.950531, 1, 0, 0.279279,0.014701) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216066,-0.0038895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0275272) , 
3, 1.38148, 1, 0, 0.176778,-0.0127826) , 
0, 0.133846, 1, 0, 0.231849,0.00198349)    );
  // itree = 995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17437,-0.0138955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38835,0.0150199) , 
3, -0.797175, 1, 0, 0.28557,0.00860308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191877,-0.00299505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27439,-0.00288364) , 
0, 0.814042, 1, 0, 0.21785,-0.0168894) , 
2, 0.138482, 1, 0, 0.250861,-0.00446294)    );
  // itree = 996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110849,-0.0193486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279738,0.0109874) , 
2, -0.780604, 1, 0, 0.236153,0.00513374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216495,-0.077916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368715,0.00186636) , 
2, 1.63477, 1, 0, 0.315217,-0.0306237) , 
2, 1.35088, 1, 0, 0.247525,-9.06716e-06)    );
  // itree = 997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286901,-0.0026636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0751174,-0.02099) , 
3, 1.10108, 1, 0, 0.26153,0.010253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939597,-0.00407115) , 
3, 1.73078, 1, 0, 0.248573,0.00509544)    );
  // itree = 998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253286,0.00250989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126437,-0.0261047) , 
1, 1.4556, 1, 0, 0.241342,-0.000607862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.462264,0.0742681) , 
1, 1.7097, 1, 0, 0.253327,-0.00446324)    );
  // itree = 999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996785,-0.0218619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.617021,0.00835293) , 
1, 0.943531, 1, 0, 0.24154,0.0131307) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304054,0.0187619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191667,0.0152415) , 
0, 1.06051, 1, 0, 0.253731,-0.0397198) , 
2, 1.35088, 1, 0, 0.243189,0.00598441)    );
  // itree = 1000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185127,0.00510395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725225,0.044827) , 
3, 0.827607, 1, 0, 0.265814,0.0153327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0514673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216895,0.0009885) , 
0, -0.282097, 1, 0, 0.175159,-0.0140805) , 
1, 1.03517, 1, 0, 0.238884,0.00659498)    );
  // itree = 1001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313576,0.00652103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405405,-0.0396395) , 
3, 1.00874, 1, 0, 0.270241,0.00316118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218579,0.0199227) , 
0, 1.44542, 1, 0, 0.265625,-0.00102649)    );
  // itree = 1002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267779,0.00528597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183453,-0.00140247) , 
1, 0.77683, 1, 0, 0.240118,-0.00147439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310606,0.00199978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365217,0.00308315) , 
1, 1.35328, 1, 0, 0.336032,0.038597) , 
2, 1.40023, 1, 0, 0.252317,0.00362224)    );
  // itree = 1003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219067,0.0042476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221694,-0.0100918) , 
2, -0.611326, 1, 0, 0.220855,-0.00216862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44898,0.0288446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198697,-0.0307599) , 
0, 0.367586, 1, 0, 0.279736,0.0281918) , 
3, 0.950308, 1, 0, 0.234234,0.00473008)    );
  // itree = 1004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227431,0.00887266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17552,-0.0231757) , 
0, 0.563554, 1, 0, 0.213249,-0.000277978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19403,0.00172546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.772727,0.0329723) , 
3, 1.65029, 1, 0, 0.385,0.0238558) , 
2, 1.06439, 1, 0, 0.247859,0.00458526)    );
  // itree = 1005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488722,-0.0149271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273543,0.00319772) , 
3, -1.9731, 1, 0, 0.290437,-0.00294958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0176991,-0.0463535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161572,0.0219374) , 
0, 0.784455, 1, 0, 0.114035,-0.0785227) , 
3, 1.19852, 1, 0, 0.260805,-0.0156441)    );
  // itree = 1006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24498,0.00827437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234944,-0.00232589) , 
1, -0.893135, 1, 0, 0.236512,0.00241132) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493274,0.0254528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0918367,-0.0259228) , 
3, 1.65602, 1, 0, 0.370717,-0.0407986) , 
2, 1.18512, 1, 0, 0.259008,-0.0048317)    );
  // itree = 1007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139939,-0.0113752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.586777,0.0177079) , 
1, 1.09547, 1, 0, 0.280228,0.00853447) , 
3, -2.20961, 1, 0, 0.265356,0.00579344)    );
  // itree = 1008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275862,0.0571415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214912,-0.00272216) , 
1, -0.380803, 1, 0, 0.245652,0.0315885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205607,-0.0572099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268111,0.00204573) , 
1, -0.985783, 1, 0, 0.263889,-0.00247527) , 
0, -0.659236, 1, 0, 0.259785,0.00519073)    );
  // itree = 1009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.692982,0.0436221) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266229,-0.00777837) , 
2, -1.6375, 1, 0, 0.29899,0.0149837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0760456,-0.00532935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10219,0.00883818) , 
2, 0.608291, 1, 0, 0.0893855,-0.0113138) , 
1, 1.16801, 1, 0, 0.243323,0.00799964)    );
  // itree = 1010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138996,-0.0378458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.023622,-0.0599414) , 
1, -0.0504285, 1, 0, 0.101036,0.0373653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.429836,0.0166422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157248,-0.00338308) , 
3, 0.0897645, 1, 0, 0.291589,0.00472479) , 
2, -0.91792, 1, 0, 0.254646,0.0110529)    );
  // itree = 1011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,0.0324996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191489,-0.0128664) , 
3, -1.29147, 1, 0, 0.129412,0.036154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257576,-0.00499213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296407,-0.00262129) , 
0, -0.422841, 1, 0, 0.292916,-0.00464526) , 
0, -0.587928, 1, 0, 0.250758,0.00587427)    );
  // itree = 1012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214493,0.0117026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234557,-0.0223794) , 
0, -0.293879, 1, 0, 0.226895,-0.00977047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488372,0.0316218) , 
1, 1.63248, 1, 0, 0.244318,-0.0050592)    );
  // itree = 1013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.503356,0.00860951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256637,-0.00630073) , 
3, -1.70993, 1, 0, 0.354667,0.0314855) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302326,-0.0109299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185671,0.00523524) , 
3, -0.234347, 1, 0, 0.229755,-0.0012018) , 
0, -0.855696, 1, 0, 0.253557,0.00502672)    );
  // itree = 1014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0363442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262633,0.00236292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0446429,-0.0431887) , 
3, 1.46822, 1, 0, 0.235906,-0.00201816) , 
0, -1.66344, 1, 0, 0.241486,0.000940353)    );
  // itree = 1015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280779,0.00976041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284211,0.0046589) , 
3, 1.14381, 1, 0, 0.2813,-0.00186665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.101118) , 
1, 1.67676, 1, 0, 0.267071,-0.00548433)    );
  // itree = 1016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236686,0.0418252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250597,0.00431888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278912,-0.0282069) , 
2, 1.69396, 1, 0, 0.25288,0.000852437) , 
0, -1.37002, 1, 0, 0.251506,0.00463505)    );
  // itree = 1017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649123,-0.0133985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387097,0.0059068) , 
2, -1.09705, 1, 0, 0.512605,0.0259356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238766,0.00904215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129139,-0.0153543) , 
0, 1.13453, 1, 0, 0.220301,-0.00554859) , 
1, -0.952616, 1, 0, 0.254554,-0.00185916)    );
  // itree = 1018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228367,-0.0056525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3769,0.00168041) , 
2, 0.952269, 1, 0, 0.254555,0.010023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0810811,0.0136829) , 
3, 1.65635, 1, 0, 0.238908,0.00445312)    );
  // itree = 1019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.010101,0.0436051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0288462,0.00406177) , 
1, -1.4103, 1, 0, 0.0197044,0.0389646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284327,0.011805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258065,-0.00728304) , 
3, -0.237153, 1, 0, 0.268922,-0.00741366) , 
1, -1.02829, 1, 0, 0.242938,-0.00257813)    );
  // itree = 1020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260563,0.0604034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185012,0.00618726) , 
1, -0.847043, 1, 0, 0.203866,0.019608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,-0.0463637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27753,0.0010806) , 
1, -1.01221, 1, 0, 0.272039,-0.00388185) , 
0, -0.555751, 1, 0, 0.252845,0.00273159)    );
  // itree = 1021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369787,0.00354282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14862,0.00814881) , 
2, 0.427651, 1, 0, 0.302581,-0.00272505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105556,0.0127326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105769,-0.0061294) , 
3, 1.90963, 1, 0, 0.105603,-0.0279944) , 
3, 0.951289, 1, 0, 0.2572,-0.00854679)    );
  // itree = 1022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364486,0.019462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0665281,-0.0502223) , 
3, -1.62695, 1, 0, 0.158273,0.019246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313196,0.0101806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654206,-0.0166884) , 
3, 1.89178, 1, 0, 0.293773,-0.0034948) , 
2, -0.363611, 1, 0, 0.248058,0.00417747)    );
  // itree = 1023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10929,0.0626583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266472,-0.00449984) , 
3, -1.7342, 1, 0, 0.251317,0.00307059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075877) , 
3, 1.98981, 1, 0, 0.238381,0.00678935)    );
  // itree = 1024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,0.00405331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0379061,-0.0491827) , 
2, -1.00993, 1, 0, 0.0660147,-0.0144687) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354508,0.026813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40638,0.00117972) , 
2, 0.262495, 1, 0, 0.385443,0.0155908) , 
3, -0.457491, 1, 0, 0.256537,0.00346022)    );
  // itree = 1025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362703,0.0010868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103858,-0.00646946) , 
2, 0.666113, 1, 0, 0.304781,-0.00393771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100775,-0.00781379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0895062,-0.0104868) , 
3, 1.19014, 1, 0, 0.0927152,0.0186677) , 
3, 0.853537, 1, 0, 0.255743,0.00128957)    );
  // itree = 1026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350446,-0.000700446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13886,-0.0125044) , 
3, -0.307226, 1, 0, 0.240731,0.00534361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396947,0.0223854) , 
2, 1.76296, 1, 0, 0.251004,0.00250433)    );
  // itree = 1027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.07536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254818,-0.00487822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234192,0.00134466) , 
2, 0.915963, 1, 0, 0.25,-0.00150801) , 
3, -2.21683, 1, 0, 0.237156,-0.0035263)    );
  // itree = 1028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180952,0.0552138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320988,0.00751823) , 
2, -1.34359, 1, 0, 0.265918,0.0302835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176087,-0.0144393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.628472,0.0125973) , 
3, 1.35397, 1, 0, 0.254197,-0.00614502) , 
1, -0.943262, 1, 0, 0.255814,-0.00111845)    );
  // itree = 1029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518519,0.00279234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355556,0.0195038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224189,0.000669578) , 
0, -1.06587, 1, 0, 0.2368,0.00232073) , 
3, -1.95723, 1, 0, 0.255721,-0.00132029)    );
  // itree = 1030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,0.00352312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0410959,-0.0409333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239103,-0.00274799) , 
2, -1.23016, 1, 0, 0.215342,0.00445174) , 
0, -1.2692, 1, 0, 0.234739,0.00860867)    );
  // itree = 1031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191027,-0.0097006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342767,0.0346039) , 
3, 0.874765, 1, 0, 0.219412,-0.00589791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.650888,0.0294159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0973451,-0.0293469) , 
3, 1.41063, 1, 0, 0.429078,0.0465229) , 
0, 1.17201, 1, 0, 0.249243,0.00156055)    );
  // itree = 1032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00546448,-0.0724903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27864,0.011351) , 
3, -1.76723, 1, 0, 0.251748,0.00746543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,-0.0517882) , 
2, 1.76374, 1, 0, 0.253904,0.00206428)    );
  // itree = 1033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.717949,0.0358534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282051,-0.0223328) , 
0, -0.813278, 1, 0, 0.468864,-0.0344601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220472,-0.00573606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875912,-0.0151871) , 
2, 1.73723, 1, 0, 0.210291,0.000584767) , 
2, -1.23173, 1, 0, 0.244541,-0.00405728)    );
  // itree = 1034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483333,0.0237778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0758514,-0.0521791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28975,0.00917442) , 
2, -0.223713, 1, 0, 0.216446,0.00958871) , 
3, -1.74385, 1, 0, 0.239709,0.00645029)    );
  // itree = 1035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335312,0.0666178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241125,0.00181939) , 
2, -1.02375, 1, 0, 0.25847,0.00597689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231481,-0.0162112) , 
0, 1.52075, 1, 0, 0.256966,0.00237228)    );
  // itree = 1036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213043,-0.00915009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327402,0.0340955) , 
2, 0.813987, 1, 0, 0.2355,-0.000671241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19,-0.0133608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351931,-0.0358719) , 
2, 0.875323, 1, 0, 0.260788,-0.030452) , 
0, 0.745404, 1, 0, 0.242363,-0.00875328)    );
  // itree = 1037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53871,0.00209418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323864,-0.00744773) , 
3, -0.998126, 1, 0, 0.424471,0.027268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232955,-0.000456118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128947,0.0213338) , 
1, 0.809254, 1, 0, 0.171584,-0.00594008) , 
1, -0.119724, 1, 0, 0.257436,0.00533364)    );
  // itree = 1038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.369338,-0.00153172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278246,0.0010413) , 
0, -0.982659, 1, 0, 0.295995,-0.0118825) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0785928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13388,-0.00469081) , 
2, 0.431507, 1, 0, 0.0949612,0.0202458) , 
3, 0.766583, 1, 0, 0.243841,-0.00354755)    );
  // itree = 1039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18698,-0.0111224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30791,0.00185985) , 
3, 0.765832, 1, 0, 0.212537,-0.000483816) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46729,-0.00394897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374449,0.0188431) , 
1, 0.0410322, 1, 0, 0.404192,-0.0243301) , 
0, 1.1334, 1, 0, 0.2444,-0.0044483)    );
  // itree = 1040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233058,0.0263596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267241,-0.0325466) , 
3, 1.16181, 1, 0, 0.236048,0.0196581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154839,-0.0668897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372845,-0.00886778) , 
0, -0.132109, 1, 0, 0.318255,-0.0253524) , 
2, 0.690799, 1, 0, 0.262211,0.00533344)    );
  // itree = 1041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.694444,0.00747624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,-0.0417328) , 
1, -0.508063, 1, 0, 0.411552,-0.0319362) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347051,0.00739093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143536,-0.0091566) , 
2, 0.0547149, 1, 0, 0.226839,-0.000998494) , 
2, -1.26941, 1, 0, 0.251701,-0.00516261)    );
  // itree = 1042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.437247,0.0220511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233822,-0.00799057) , 
3, -1.54171, 1, 0, 0.269559,0.0180693) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.000136789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17094,-0.00171969) , 
0, 1.09904, 1, 0, 0.183442,-0.0227266) , 
0, 0.646842, 1, 0, 0.243323,0.00564086)    );
  // itree = 1043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287411,0.0277835) , 
3, -2.07357, 1, 0, 0.229167,-0.0161268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295396,-0.0125543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226115,0.00931699) , 
2, 0.642438, 1, 0, 0.264539,0.0171384) , 
3, -0.961157, 1, 0, 0.254902,0.00807542)    );
  // itree = 1044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134466,-0.0128261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473896,0.0200478) , 
3, 0.753416, 1, 0, 0.185319,-0.00408435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414414,-0.066413) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,0.00990593) , 
0, 0.761369, 1, 0, 0.576052,-0.0290169) , 
3, 1.34716, 1, 0, 0.246575,-0.00799311)    );
  // itree = 1045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.55,0.00311142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276243,-0.00531082) , 
2, -1.00915, 1, 0, 0.344398,-0.00789774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686499,-0.0287106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188679,-0.00291389) , 
0, 0.391415, 1, 0, 0.134436,0.0172929) , 
3, -0.102347, 1, 0, 0.239254,0.00471717)    );
  // itree = 1046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257586,0.00856053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.430962,-0.00520013) , 
2, 1.12292, 1, 0, 0.281649,0.00476886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916667,0.0399332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0618557,-0.0165863) , 
3, 1.95234, 1, 0, 0.078341,-0.0579525) , 
3, 1.56271, 1, 0, 0.258896,-0.0022505)    );
  // itree = 1047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25393,0.022155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251701,-0.0180372) , 
3, -0.407088, 1, 0, 0.252779,-0.00308486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248731,0.0061343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278196,-0.0245034) , 
1, 1.33265, 1, 0, 0.260606,0.0408293) , 
3, 1.26976, 1, 0, 0.254046,0.00402239)    );
  // itree = 1048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211438,0.00383215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.509091,0.0351773) , 
3, 1.43023, 1, 0, 0.229223,0.00782188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664474,-0.0239739) , 
3, 1.74551, 1, 0, 0.262418,0.00377758)    );
  // itree = 1049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349794,-0.00389089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24953,0.00785121) , 
0, -1.08926, 1, 0, 0.262786,-0.00922462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168224,0.0141681) , 
1, 1.7097, 1, 0, 0.257584,-0.00701564)    );
  // itree = 1050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458333,0.0107727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32376,0.000778252) , 
3, -1.8985, 1, 0, 0.345055,-0.0152155) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.018648,-0.0653788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247813,0.00511169) , 
2, 0.282276, 1, 0, 0.159641,0.0203565) , 
3, -0.287516, 1, 0, 0.242963,0.00437104)    );
  // itree = 1051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522565,0.0217746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322536,0.0049971) , 
1, -0.626718, 1, 0, 0.261752,0.00988348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00925926,-0.0944563) , 
1, 1.67676, 1, 0, 0.24798,0.00601624)    );
  // itree = 1052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207604,-0.0052073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.067069) , 
0, 1.26294, 1, 0, 0.192877,-0.0099701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715278,0.0210228) , 
3, 1.73078, 1, 0, 0.231082,-0.00615544)    );
  // itree = 1053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40678,0.0107447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263711,-0.000185869) , 
0, -1.6245, 1, 0, 0.272926,-0.00113865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.076087,-0.00776599) , 
3, 1.62302, 1, 0, 0.25496,-0.00601415)    );
  // itree = 1054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.130435,-0.0345353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374473,0.00887411) , 
1, -1.32433, 1, 0, 0.348071,-0.000476445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0958188,-0.023594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197216,0.00774663) , 
1, 0.989581, 1, 0, 0.139303,0.0252275) , 
3, -0.0727496, 1, 0, 0.246615,0.0120151)    );
  // itree = 1055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266276,-0.000457065) , 
3, -2.08696, 1, 0, 0.251245,0.0029565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0901769) , 
1, 1.7097, 1, 0, 0.2372,-0.000242252)    );
  // itree = 1056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238367,0.00873042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187643,-0.0224511) , 
0, 0.563554, 1, 0, 0.22503,0.000520749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282895,-0.0653107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3125,-0.0102119) , 
2, 1.51197, 1, 0, 0.3,-0.0417179) , 
2, 1.16615, 1, 0, 0.238378,-0.00699949)    );
  // itree = 1057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318768,0.00633003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0615034,-0.0262516) , 
3, 0.714686, 1, 0, 0.257221,0.0124385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195876,0.00700736) , 
0, 1.54393, 1, 0, 0.254141,0.00923787)    );
  // itree = 1058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269134,0.00863136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19432,-0.00371029) , 
1, 0.684977, 1, 0, 0.242196,0.0126399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344262,-0.00151148) , 
2, 1.7672, 1, 0, 0.248485,0.0159559)    );
  // itree = 1059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0112994,-0.0341622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33121,0.0237935) , 
1, -0.886485, 1, 0, 0.243827,-0.0165042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272436,-0.00805552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0759319) , 
3, 1.96952, 1, 0, 0.251665,0.00493754) , 
3, -0.663226, 1, 0, 0.249125,-0.00201306)    );
  // itree = 1060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141304,-0.0468885) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0189189,-0.0485775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335215,0.0135403) , 
3, -0.990595, 1, 0, 0.269726,0.00915754) , 
1, -1.06103, 1, 0, 0.257737,0.00312781)    );
  // itree = 1061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.485149,-0.0169343) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260227,0.00275458) , 
3, -2.1524, 1, 0, 0.272434,-0.0014704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126126,0.0180596) , 
2, 1.79378, 1, 0, 0.264199,-0.00694798)    );
  // itree = 1062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186047,-0.0388217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.492063,0.0178324) , 
2, -0.845874, 1, 0, 0.337255,0.0429934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192308,0.0106892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230674,0.00421375) , 
1, -0.796791, 1, 0, 0.225824,-1.89266e-05) , 
0, -1.03387, 1, 0, 0.239316,0.00518912)    );
  // itree = 1063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414938,0.00911193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168103,0.00177305) , 
3, -1.41272, 1, 0, 0.103594,0.0103327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299262,-0.00257489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2818,-0.00406506) , 
3, 0.762149, 1, 0, 0.293151,-0.00956402) , 
0, -0.663709, 1, 0, 0.246767,-0.00469535)    );
  // itree = 1064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118774,0.0126009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782726,-0.0302657) , 
2, -0.972835, 1, 0, 0.0888224,-0.0109351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471429,-0.0211137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434932,0.0212027) , 
0, -0.391515, 1, 0, 0.439961,0.0232172) , 
3, -0.0727496, 1, 0, 0.26561,0.00625951)    );
  // itree = 1065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402706,0.000662919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104938,-0.0225503) , 
2, 0.794345, 1, 0, 0.359751,0.00722643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128205,0.0017998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0519481,-0.0361682) , 
2, 1.23437, 1, 0, 0.107602,-0.0209415) , 
1, 0.55924, 1, 0, 0.250758,-0.00494931)    );
  // itree = 1066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26635,0.00486668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0871836) , 
3, 1.49375, 1, 0, 0.245479,-0.00336149) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392857,-0.025012) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,-0.0333819) , 
3, 1.37886, 1, 0, 0.259259,0.0497625) , 
2, 1.54362, 1, 0, 0.246938,0.00226065)    );
  // itree = 1067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23011,0.00279117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496504,-0.00322546) , 
1, 1.47936, 1, 0, 0.251548,-0.00280667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579439,0.0629873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.00741312) , 
3, 1.0189, 1, 0, 0.344498,0.0433745) , 
2, 1.47108, 1, 0, 0.261329,0.00205329)    );
  // itree = 1068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0504202,-0.057101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0327511,-0.0237819) , 
1, -1.20383, 1, 0, 0.0363951,-0.0180515) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431212,0.0243392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210019,-0.0162368) , 
1, 1.09547, 1, 0, 0.35432,0.0136799) , 
3, -0.900958, 1, 0, 0.2657,0.00483495)    );
  // itree = 1069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679612,0.0537214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250588,-0.00245129) , 
2, -1.67265, 1, 0, 0.275097,0.00673255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0886699,-0.00922482) , 
2, 1.5087, 1, 0, 0.256231,0.00227654)    );
  // itree = 1070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.386957,-0.00652278) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23661,-0.00347666) , 
0, -1.13917, 1, 0, 0.256891,0.00453935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132075,-0.0256665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193548,0.0114876) , 
0, 1.42412, 1, 0, 0.165217,-0.0244182) , 
0, 1.11463, 1, 0, 0.241463,-0.000333991)    );
  // itree = 1071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188841,-0.017353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262473,0.00730868) , 
2, 0.643333, 1, 0, 0.209717,0.00760134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.501818,0.0203451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170543,-0.0589934) , 
1, 0.900427, 1, 0, 0.39604,-0.0154104) , 
0, 1.04529, 1, 0, 0.246798,0.00302166)    );
  // itree = 1072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108017,-0.00885275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326733,0.0296777) , 
3, 0.30492, 1, 0, 0.152554,0.00177664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536232,-0.0252745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521368,0.00261469) , 
0, 0.988348, 1, 0, 0.529412,-0.0204489) , 
3, 0.853537, 1, 0, 0.248749,-0.00389654)    );
  // itree = 1073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314465,-0.0193636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235429,-0.0125286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0649351,-0.0314382) , 
2, 1.68765, 1, 0, 0.221639,5.2038e-05) , 
0, -1.39419, 1, 0, 0.228793,0.00274721)    );
  // itree = 1074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481283,0.0137374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157895,0.00300213) , 
0, -0.752816, 1, 0, 0.358804,-0.0187227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197026,-0.033847) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221904,0.00171674) , 
0, -0.63552, 1, 0, 0.217887,0.00804552) , 
3, -1.39309, 1, 0, 0.239451,0.00394931)    );
  // itree = 1075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752621) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0877725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265461,-0.00172165) , 
1, -1.1756, 1, 0, 0.250827,0.00468859) , 
3, -1.92411, 1, 0, 0.233333,0.00133893)    );
  // itree = 1076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15544,-0.0137767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,-0.0721023) , 
3, 0.600431, 1, 0, 0.149667,-0.0226025) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849558,-0.0283285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.579035,0.0156461) , 
3, 0.401748, 1, 0, 0.339623,0.00629122) , 
2, -0.0267985, 1, 0, 0.25677,-0.00631135)    );
  // itree = 1077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384416,-0.0139296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261563,0.0112495) , 
3, -1.13442, 1, 0, 0.290421,0.00335091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0553506,-0.0244152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16,0.017577) , 
0, 1.2277, 1, 0, 0.0883838,-0.0277786) , 
2, 1.06564, 1, 0, 0.251106,-0.00270673)    );
  // itree = 1078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282388,0.00766029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113636,-0.0086521) , 
3, 1.1432, 1, 0, 0.266343,0.000960385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0609137,-0.00127151) , 
3, 1.65933, 1, 0, 0.246582,-0.00503232)    );
  // itree = 1079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0812438) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0989305,0.0269491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300819,-0.00205114) , 
1, -0.421658, 1, 0, 0.259783,-0.0044296) , 
1, -1.26922, 1, 0, 0.242025,-7.10295e-05)    );
  // itree = 1080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173399,-0.00462582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364286,0.0503792) , 
2, 0.134358, 1, 0, 0.196537,0.00298835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326772,-0.0378202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296758,-0.00158541) , 
1, 1.01148, 1, 0, 0.313531,-0.0256799) , 
2, 0.324939, 1, 0, 0.248062,-0.00963735)    );
  // itree = 1081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353066,-0.001891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28653,-0.0104424) , 
0, -0.633335, 1, 0, 0.309859,0.00466375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,0.00870362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160494,0.023045) , 
0, -0.237198, 1, 0, 0.143284,-0.0331519) , 
3, 0.537656, 1, 0, 0.254581,-0.00788526)    );
  // itree = 1082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246672,-0.0122247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0869786) , 
3, 0.947042, 1, 0, 0.215311,-0.00427906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507576,0.00890696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150376,-0.00419504) , 
3, 0.83004, 1, 0, 0.328302,0.0278416) , 
2, 0.823591, 1, 0, 0.245359,0.0042628)    );
  // itree = 1083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111628,0.0314074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297326,-0.0144598) , 
3, -1.63846, 1, 0, 0.262609,0.00773881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233333,0.0106813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323144,0.0279621) , 
0, 1.12138, 1, 0, 0.256468,-0.0230207) , 
2, 0.329467, 1, 0, 0.259931,-0.00567226)    );
  // itree = 1084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0501792,-0.00903054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298462,0.0463222) , 
3, -1.01502, 1, 0, 0.183775,0.0285173) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250746,-0.012292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850877,0.0172057) , 
3, 1.89178, 1, 0, 0.297799,-0.0100861) , 
2, -0.546425, 1, 0, 0.264334,0.00124352)    );
  // itree = 1085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.000407791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123711,-0.0127077) , 
3, -0.0719984, 1, 0, 0.27056,0.00415996) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139394,-0.0148964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209302,0.0168676) , 
1, 0.564507, 1, 0, 0.170068,-0.0416928) , 
0, 1.22394, 1, 0, 0.255578,-0.0026761)    );
  // itree = 1086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276224,-0.00230383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09375,-0.0324252) , 
0, -0.00315433, 1, 0, 0.219807,0.028708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396092,0.00289853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210575,0.00269312) , 
3, -0.400297, 1, 0, 0.274223,0.00397036) , 
1, -0.638236, 1, 0, 0.26326,0.00895401)    );
  // itree = 1087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121718,-0.0122276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182114,-0.0175471) , 
3, 0.0100223, 1, 0, 0.147281,0.0100947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.755906,0.0250219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334862,0.0251455) , 
2, 0.88807, 1, 0, 0.561441,-0.0304776) , 
1, 1.22922, 1, 0, 0.248831,0.000146547)    );
  // itree = 1088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0374332,-0.0522922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317016,0.0302129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26338,0.000228662) , 
1, -0.412797, 1, 0, 0.275825,0.00927044) , 
2, -1.46338, 1, 0, 0.253929,0.00524892)    );
  // itree = 1089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297475,0.000946397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23496,-0.00574725) , 
0, -0.0325551, 1, 0, 0.266741,0.00594986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0880503,0.00162791) , 
3, 1.63849, 1, 0, 0.252178,0.00156317)    );
  // itree = 1090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261364,0.00197391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0222222,-0.0588934) , 
3, 1.32638, 1, 0, 0.232999,-0.004555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428571,0.0380016) , 
2, 1.7672, 1, 0, 0.24518,-0.00855443)    );
  // itree = 1091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0765524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18883,0.0210467) , 
0, -0.407171, 1, 0, 0.0972603,0.0223992) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410101,0.0142268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208531,-0.00473749) , 
3, 1.4084, 1, 0, 0.374688,-0.00446405) , 
1, -0.0304994, 1, 0, 0.269808,0.00569139)    );
  // itree = 1092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281463,0.0114001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10628,-0.0222957) , 
1, 1.36913, 1, 0, 0.261538,0.00820954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0222303) , 
1, 1.58039, 1, 0, 0.267407,0.00457312)    );
  // itree = 1093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371951,-0.00565985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0788644,-0.00930988) , 
1, 0.77313, 1, 0, 0.276465,0.0193908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204943,-0.0072019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.021555) , 
3, 1.9058, 1, 0, 0.193519,-0.00656148) , 
0, -0.00477115, 1, 0, 0.23283,0.00573834)    );
  // itree = 1094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.343612,0.008817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207961,-0.00488613) , 
0, -0.413441, 1, 0, 0.256276,-0.0033365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0860927,0.00804414) , 
3, 1.76021, 1, 0, 0.24382,-0.00689869)    );
  // itree = 1095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0803524) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272472,-0.00265646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179104,0.0611904) , 
3, 1.74048, 1, 0, 0.265935,-0.00749262) , 
0, -1.64945, 1, 0, 0.25198,-0.00375153)    );
  // itree = 1096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0202532,-0.0358717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309271,0.0124423) , 
3, -1.15517, 1, 0, 0.242548,0.00879569) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287037,0.0103741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320312,-0.0498957) , 
0, 0.917724, 1, 0, 0.305085,-0.0326079) , 
2, 1.40023, 1, 0, 0.250128,0.00377708)    );
  // itree = 1097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415929,0.000107439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175279,0.0157846) , 
1, 0.101394, 1, 0, 0.290323,-0.00604237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,0.00612324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990991,-0.0169409) , 
0, 0.950778, 1, 0, 0.0735931,0.0389336) , 
2, 1.45481, 1, 0, 0.26673,-0.0011463)    );
  // itree = 1098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226891,-0.00138109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380309,0.00314845) , 
2, 0.664753, 1, 0, 0.270389,-0.000210888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0609756,-0.0100508) , 
3, 1.68398, 1, 0, 0.253139,0.00315964)    );
  // itree = 1099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0123457,-0.0210471) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235366,-0.00243994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.511416,0.0473856) , 
0, 1.32355, 1, 0, 0.267886,-0.0179591) , 
1, -1.17379, 1, 0, 0.247402,-0.0128808)    );
  // itree = 1100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0379747,-0.046107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,0.0481492) , 
2, -0.217362, 1, 0, 0.0350877,-0.0177637) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268156,0.029787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343363,0.00261724) , 
2, -0.370093, 1, 0, 0.325269,0.010937) , 
3, -0.931712, 1, 0, 0.244898,0.00298786)    );
  // itree = 1101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333861,0.00190323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0591716,-0.018766) , 
3, 0.662859, 1, 0, 0.275905,0.00922814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136126,-0.0219334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195349,0.0254978) , 
3, 0.827816, 1, 0, 0.167488,-0.0233559) , 
0, 1.00007, 1, 0, 0.253984,0.00263993)    );
  // itree = 1102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430052,0.0239962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18131,-0.00900649) , 
3, -1.70741, 1, 0, 0.214533,0.0129538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442308,-0.00744746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204013,0.0171979) , 
3, 0.791201, 1, 0, 0.325696,-0.0167987) , 
2, 0.778141, 1, 0, 0.247568,0.00411201)    );
  // itree = 1103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20798,-0.00414935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00108218) , 
2, 0.717597, 1, 0, 0.234228,-0.00420067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474074,0.0494439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190722,-0.0306553) , 
0, 0.136801, 1, 0, 0.263862,0.025329) , 
3, 0.883159, 1, 0, 0.241927,0.00347148)    );
  // itree = 1104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0250965,-0.0304172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148315,0.020002) , 
3, -1.05395, 1, 0, 0.0820353,0.000140974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267473,-0.0293326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.563934,-0.000885694) , 
3, 1.30264, 1, 0, 0.35367,-0.0272686) , 
3, -0.227317, 1, 0, 0.223658,-0.0141496)    );
  // itree = 1105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316775,0.00442298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100629,0.0173664) , 
3, 0.89504, 1, 0, 0.276508,-0.00746166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0176991,-0.0544241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992908,-0.0190203) , 
3, 1.09351, 1, 0, 0.0629921,0.0283518) , 
2, 1.40345, 1, 0, 0.248853,-0.00282289)    );
  // itree = 1106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289286,0.011884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364341,-0.00139169) , 
1, -0.867328, 1, 0, 0.344402,-0.00858877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996564,-0.0385543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179412,0.00381228) , 
0, 0.119135, 1, 0, 0.15551,0.0075212) , 
3, -0.097287, 1, 0, 0.253827,-0.000863943)    );
  // itree = 1107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234345,-0.00269212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334862,0.0122978) , 
3, 1.27244, 1, 0, 0.246746,-0.00416362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319588,0.000315693) , 
0, 1.40235, 1, 0, 0.253952,-0.00686281)    );
  // itree = 1108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21627,0.0188649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174877,-0.0112777) , 
1, -0.428552, 1, 0, 0.186992,-0.00138599) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406452,-0.0299975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.646154,0.00228498) , 
2, 1.23374, 1, 0, 0.515789,-0.03084) , 
3, 1.32707, 1, 0, 0.233682,-0.00556854)    );
  // itree = 1109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34139,0.00731983) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112745,-0.00691951) , 
3, 0.441796, 1, 0, 0.269112,0.0035091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0538131) , 
1, 1.67456, 1, 0, 0.267857,-0.00106942)    );
  // itree = 1110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436759,0.0164345) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0410256,-0.0749175) , 
3, -0.354416, 1, 0, 0.326676,0.0236356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123894,-0.0245599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23301,0.00933904) , 
1, -0.813663, 1, 0, 0.22387,-0.00625201) , 
0, -0.420972, 1, 0, 0.259024,0.00396809)    );
  // itree = 1111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0790432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260593,0.0131251) , 
0, 0.130486, 1, 0, 0.108084,-0.00691033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569343,0.00634623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322245,-0.0206926) , 
3, 0.487109, 1, 0, 0.436099,0.0188911) , 
1, 0.634693, 1, 0, 0.252217,0.00442706)    );
  // itree = 1112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105402,-0.00339596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533123,0.0327169) , 
3, -0.0439355, 1, 0, 0.231413,0.0136806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210145,-0.0644292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284605,-0.00982757) , 
1, -0.469325, 1, 0, 0.273326,-0.022961) , 
0, 0.201876, 1, 0, 0.250629,-0.00311881)    );
  // itree = 1113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.578616,-0.0122762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236129,-0.00427154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0953846,-0.0110505) , 
3, 1.33621, 1, 0, 0.211733,-0.0103757) , 
1, -1.31444, 1, 0, 0.240413,-0.00478417)    );
  // itree = 1114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357243,0.00858004) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231065,-0.00432236) , 
0, -0.313714, 1, 0, 0.291275,-0.000456009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.080482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.0101375) , 
2, 0.610368, 1, 0, 0.0811404,0.0201273) , 
3, 0.873167, 1, 0, 0.242035,0.00436721)    );
  // itree = 1115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0934071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288382,0.0186028) , 
0, -1.21316, 1, 0, 0.240693,-0.00703846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200393,0.0009044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365325,-0.0220142) , 
1, 1.22177, 1, 0, 0.264423,0.0186412) , 
3, 0.205652, 1, 0, 0.250629,0.00371418)    );
  // itree = 1116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120669,-0.00306891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592998,0.0166906) , 
3, 0.10721, 1, 0, 0.287481,0.00714688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0950226,-0.065754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210526,0.00764739) , 
0, -0.311511, 1, 0, 0.174825,-0.0138623) , 
1, 0.895474, 1, 0, 0.247387,-0.000330251)    );
  // itree = 1117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331361,-0.014304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264434,0.00817841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.075,-0.023137) , 
3, 1.74048, 1, 0, 0.25216,-0.012143) , 
0, -1.30994, 1, 0, 0.258783,-0.00702072)    );
  // itree = 1118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37766,-0.0304671) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.342391,-0.00554639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22565,0.00118086) , 
0, -0.831508, 1, 0, 0.237343,-0.00668849) , 
0, -1.26434, 1, 0, 0.25037,-0.00364414)    );
  // itree = 1119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231173,-0.00165742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348276,0.000207081) , 
2, 0.728426, 1, 0, 0.254888,-0.00907381) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196154,0.00947417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357639,0.00616336) , 
1, 1.00234, 1, 0, 0.281022,0.0109043) , 
3, 0.766583, 1, 0, 0.262121,-0.0035445)    );
  // itree = 1120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0491803,0.00624434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466165,0.0423415) , 
3, -1.59545, 1, 0, 0.266667,0.0358136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190367,-0.0200404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302617,0.0124295) , 
0, 0.124523, 1, 0, 0.246716,-0.00246617) , 
1, -0.902225, 1, 0, 0.249252,0.00239991)    );
  // itree = 1121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59375,-0.00941792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240807,0.00410289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.06,-0.025136) , 
2, 1.63131, 1, 0, 0.221633,-0.00325812) , 
1, -1.26491, 1, 0, 0.245283,-0.000127434)    );
  // itree = 1122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294312,0.00745654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0432099,-0.0411657) , 
3, 1.04434, 1, 0, 0.25,0.00161714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218487,0.0196008) , 
0, 1.55414, 1, 0, 0.248082,-0.00167311)    );
  // itree = 1123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0960789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917603,0.0113086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334137,-0.00136995) , 
1, -0.126961, 1, 0, 0.261383,-0.00564049) , 
0, -1.2692, 1, 0, 0.236521,-0.00260614)    );
  // itree = 1124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19802,0.0385272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213333,-0.0490472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256514,0.00157504) , 
1, -0.911357, 1, 0, 0.253063,-0.00309698) , 
1, -1.40737, 1, 0, 0.250253,-0.000868168)    );
  // itree = 1125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294009,0.0015881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210719,-0.00676592) , 
0, 0.140882, 1, 0, 0.258132,0.000640261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104046,-0.00233849) , 
3, 1.73078, 1, 0, 0.24531,-0.00422367)    );
  // itree = 1126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15625,-0.0139129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23467,-0.00196922) , 
1, -1.10886, 1, 0, 0.226695,0.00839937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496241,0.0470576) , 
2, 1.76296, 1, 0, 0.244433,0.00381841)    );
  // itree = 1127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19469,0.0154074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.724771,0.0476234) , 
0, 0.332697, 1, 0, 0.323661,-0.0173863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207746,-0.0235999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274238,0.0131134) , 
2, 0.584496, 1, 0, 0.238247,0.00684179) , 
2, -0.755418, 1, 0, 0.257171,0.00147374)    );
  // itree = 1128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226925,0.000925476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0301692) , 
2, 1.34665, 1, 0, 0.219803,-0.00243666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.884615,0.042108) , 
3, 1.96727, 1, 0, 0.253812,0.00149445)    );
  // itree = 1129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440476,-0.00525738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183206,-0.0222359) , 
3, -1.51166, 1, 0, 0.327759,0.0365496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246923,-0.00464866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0837838,-0.00622946) , 
2, 1.10516, 1, 0, 0.21245,-0.00606895) , 
0, -0.990861, 1, 0, 0.229268,0.000147129)    );
  // itree = 1130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300098,0.00359507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00840336,-0.0590308) , 
3, 0.928947, 1, 0, 0.269702,-0.00573689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313625,-0.00317464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132287,-0.0095278) , 
3, 0.52002, 1, 0, 0.216766,0.0242694) , 
1, 0.634693, 1, 0, 0.247344,0.00693647)    );
  // itree = 1131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00763359,-0.0215223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0920245,-0.0155116) , 
3, -1.64337, 1, 0, 0.0544218,0.0354184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1075,0.014592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342585,0.000873222) , 
1, -0.261018, 1, 0, 0.285972,-0.00790156) , 
0, -0.906156, 1, 0, 0.251151,-0.00138695)    );
  // itree = 1132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17,0.0442818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137825,-0.00322944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26639,-0.0152627) , 
2, -0.253397, 1, 0, 0.221206,-0.0123075) , 
0, -1.70616, 1, 0, 0.21859,-0.00961296)    );
  // itree = 1133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497409,-0.0138672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238911,0.00182646) , 
1, -0.95459, 1, 0, 0.281013,0.00865937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368984,0.00427695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152924,-0.00617406) , 
1, -0.203775, 1, 0, 0.200234,-0.0259348) , 
0, 0.310699, 1, 0, 0.24718,-0.00582982)    );
  // itree = 1134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24971,0.00165963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730337,-0.029407) , 
0, 1.36019, 1, 0, 0.233158,0.00877352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,0.00355113) , 
2, 1.76296, 1, 0, 0.24226,0.00541545)    );
  // itree = 1135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160285,-0.0202737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388273,-0.000436248) , 
0, 0.201494, 1, 0, 0.242303,-0.00418822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345133,0.0518987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153005,-0.0111323) , 
0, 0.970847, 1, 0, 0.226351,-0.0385046) , 
3, 1.35923, 1, 0, 0.24,-0.00914316)    );
  // itree = 1136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183853,0.000200552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.619672,0.0196312) , 
3, 0.765832, 1, 0, 0.26928,0.00643052) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215385,-0.0131303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31,-0.0445415) , 
1, 1.09678, 1, 0, 0.237647,-0.0266354) , 
0, 0.893748, 1, 0, 0.262494,-0.000663381)    );
  // itree = 1137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529412,-0.0113146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382643,-0.000328869) , 
3, -1.66876, 1, 0, 0.42219,0.0265167) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174157,0.00965325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136589,-0.0111469) , 
2, -0.702978, 1, 0, 0.141414,0.00414701) , 
1, -0.128677, 1, 0, 0.235096,0.0116107)    );
  // itree = 1138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114286,-0.0395523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25928,0.00528739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392638,0.0482302) , 
1, 1.52394, 1, 0, 0.270637,0.000200857) , 
1, -1.36088, 1, 0, 0.262506,0.0035588)    );
  // itree = 1139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0123457,0.00201394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486111,0.0406047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21532,-0.011927) , 
2, -0.978793, 1, 0, 0.255396,-0.00685625) , 
1, -1.22512, 1, 0, 0.236717,-0.00366257)    );
  // itree = 1140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154255,-0.0436652) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296667,0.0213213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241678,-0.006066) , 
1, -0.36714, 1, 0, 0.250832,-0.000811972) , 
1, -1.06103, 1, 0, 0.241709,-0.00519978)    );
  // itree = 1141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286311,-0.0027077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245098,-0.000329882) , 
0, 0.368799, 1, 0, 0.274005,0.00494394) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0288462,-0.0457297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122807,0.0135534) , 
2, 0.647487, 1, 0, 0.0933735,0.0550099) , 
3, 1.19852, 1, 0, 0.244608,0.0130919)    );
  // itree = 1142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.048615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471545,-0.00809069) , 
2, -1.06978, 1, 0, 0.325991,0.0533189) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258044,0.0044435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,0.00344291) , 
3, 1.47384, 1, 0, 0.232749,-0.00638486) , 
0, -1.16855, 1, 0, 0.243059,0.000216569)    );
  // itree = 1143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268775,0.000871555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239227,-0.00680341) , 
2, -0.611326, 1, 0, 0.2473,0.00184145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221311,-0.0239385) , 
0, 1.52075, 1, 0, 0.245694,-0.00230904)    );
  // itree = 1144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199134,0.00986011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162264,-0.0268558) , 
0, -0.0325551, 1, 0, 0.182083,-0.00541979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297297,-0.0538251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.658163,-0.00558338) , 
2, 0.920195, 1, 0, 0.527687,-0.0408438) , 
3, 1.30545, 1, 0, 0.234452,-0.0107876)    );
  // itree = 1145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291139,0.00431573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460526,-0.0298979) , 
3, 1.08629, 1, 0, 0.253184,0.00321338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.0439945) , 
0, 1.55414, 1, 0, 0.254836,0.000116441)    );
  // itree = 1146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172727,5.82728e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241135,0.00234537) , 
1, -1.41708, 1, 0, 0.211155,-0.0609879) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26151,0.00347919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.398058,0.0515426) , 
1, 1.65759, 1, 0, 0.26963,-0.00623357) , 
1, -1.00711, 1, 0, 0.262229,-0.0131641)    );
  // itree = 1147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260188,0.0133305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28481,0.0190736) , 
2, 0.683145, 1, 0, 0.266857,-0.0124563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227545,-0.0251412) , 
1, 1.52775, 1, 0, 0.263432,-0.00900581)    );
  // itree = 1148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176845,-0.00331636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703125,0.048485) , 
3, 0.416758, 1, 0, 0.280164,0.011654) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143564,-0.0392339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330416,0.00852892) , 
2, 0.858738, 1, 0, 0.223895,-0.0150961) , 
1, 0.275303, 1, 0, 0.250857,-0.00227811)    );
  // itree = 1149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457686,-0.000709633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24581,-0.00165616) , 
3, -0.278415, 1, 0, 0.376734,0.0088746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0939948,-0.00887814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141524,0.00091537) , 
0, -0.0398309, 1, 0, 0.123782,-0.0188309) , 
1, 0.282899, 1, 0, 0.244524,-0.00560624)    );
  // itree = 1150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373047,-0.000563887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226528,0.0188076) , 
0, -0.361587, 1, 0, 0.289941,-0.0105723) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192857,-0.00915265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451327,0.0426205) , 
1, 1.7103, 1, 0, 0.228782,0.0172243) , 
1, 0.670673, 1, 0, 0.26503,0.000749672)    );
  // itree = 1151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231707,0.0359805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279655,0.000707678) , 
3, -1.09087, 1, 0, 0.26874,0.00183154) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495238,0.0442309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0490196,-0.00321084) , 
3, 1.37466, 1, 0, 0.275362,-0.0254668) , 
2, 1.5418, 1, 0, 0.269422,-0.000982582)    );
  // itree = 1152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240232,0.00294538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22442,-0.0142546) , 
1, -0.111268, 1, 0, 0.230313,-0.00725832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431373,0.0358108) , 
1, 1.57624, 1, 0, 0.24564,-0.00231457)    );
  // itree = 1153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337398,-0.0047224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117211,0.00505742) , 
1, 0.731402, 1, 0, 0.259454,0.000226788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.028169,-0.0634292) , 
3, 1.73078, 1, 0, 0.243402,0.00505676)    );
  // itree = 1154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410828,0.00525246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,-0.0300779) , 
3, -0.196278, 1, 0, 0.320455,0.0141268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242537,-0.000130027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101983,-0.0145927) , 
3, 1.08333, 1, 0, 0.199654,-0.0139104) , 
0, -0.113851, 1, 0, 0.251841,-0.00179811)    );
  // itree = 1155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227038,0.000207815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330986,-0.0152832) , 
0, 0.970557, 1, 0, 0.235782,0.00800464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504587,0.0234281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350467,0.000587854) , 
0, 1.38253, 1, 0, 0.402477,-0.0323511) , 
0, 1.22394, 1, 0, 0.262556,0.00152284)    );
  // itree = 1156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206061,0.0236554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111724,-0.0260732) , 
0, -0.0256029, 1, 0, 0.161935,0.00270228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421053,-0.0277853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.629214,0.0345197) , 
0, 0.345313, 1, 0, 0.578723,0.0344863) , 
3, 0.948814, 1, 0, 0.258911,0.0100976)    );
  // itree = 1157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545872,-0.00860712) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26068,-0.00217881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122754,0.0102625) , 
3, 0.509973, 1, 0, 0.209917,0.00695108) , 
1, -1.06103, 1, 0, 0.245942,0.0101594)    );
  // itree = 1158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410364,0.0091202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0930233,-0.043245) , 
3, -0.310344, 1, 0, 0.298819,0.0169818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0238095,-0.0335533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200246,-0.00137294) , 
2, -0.812211, 1, 0, 0.176596,-0.00904699) , 
0, 0.125775, 1, 0, 0.242528,0.00499401)    );
  // itree = 1159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245012,-0.00637706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288793,0.00936139) , 
2, 0.648499, 1, 0, 0.256843,-0.00121597) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212121,-0.0340428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140187,-0.0235542) , 
1, 1.34952, 1, 0, 0.174757,0.0579707) , 
3, 1.59147, 1, 0, 0.24805,0.00512436)    );
  // itree = 1160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2219,-0.00492977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177515,-0.0517376) , 
2, 1.45481, 1, 0, 0.217942,-0.00898108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0452515) , 
3, 2.00929, 1, 0, 0.251128,-0.00453925)    );
  // itree = 1161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.546341,0.00184981) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274939,0.0048566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0705467,-0.0280099) , 
2, 0.775215, 1, 0, 0.210556,0.00385717) , 
1, -1.02829, 1, 0, 0.244888,-0.000318162)    );
  // itree = 1162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220114,-0.00391601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270802,-0.00310973) , 
1, -0.428552, 1, 0, 0.256355,-0.00247008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.027972,-0.0559558) , 
3, 1.73078, 1, 0, 0.23996,0.0022505)    );
  // itree = 1163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205435,-0.00712328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294533,0.0132848) , 
2, 0.154944, 1, 0, 0.239408,-0.00668337) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273885,-0.0159774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252033,-0.00359562) , 
0, 1.03211, 1, 0, 0.264286,0.0145307) , 
3, 0.752409, 1, 0, 0.246214,-0.0008798)    );
  // itree = 1164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240091,0.00200491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403509,0.0514303) , 
2, 1.65444, 1, 0, 0.25,0.00531506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432692,-0.0194964) , 
1, 1.8136, 1, 0, 0.259577,0.00298375)    );
  // itree = 1165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37625,-0.000662902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152087,-0.0118038) , 
2, -0.122647, 1, 0, 0.251384,0.00433331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.0388251) , 
3, 1.65635, 1, 0, 0.233569,0.00997786)    );
  // itree = 1166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49697,0.0174406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326812,-0.00227447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158325,-0.00876651) , 
3, -0.117537, 1, 0, 0.237554,0.0112851) , 
3, -1.91277, 1, 0, 0.258818,0.00738357)    );
  // itree = 1167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233553,0.00558188) , 
3, -2.09778, 1, 0, 0.2074,-0.00439568) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138833,-0.0169957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396694,-0.000432456) , 
1, 0.940464, 1, 0, 0.266055,0.0253074) , 
3, -0.0727496, 1, 0, 0.236056,0.0101156)    );
  // itree = 1168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0741483,-0.00741558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380319,0.0249564) , 
3, -0.671955, 1, 0, 0.205714,0.011489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233645,-0.0525843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284749,-0.000343464) , 
1, -0.767868, 1, 0, 0.279965,-0.0063386) , 
0, -0.140955, 1, 0, 0.24777,0.00139141)    );
  // itree = 1169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420168,-0.00898894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,0.0033544) , 
3, -1.21372, 1, 0, 0.282557,0.00546067) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253369,-0.00285444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154321,0.0142572) , 
1, 0.691101, 1, 0, 0.207194,-0.0196852) , 
0, 0.435422, 1, 0, 0.255861,-0.00344676)    );
  // itree = 1170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382609,-0.0234283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234015,-0.000623751) , 
0, -1.41761, 1, 0, 0.244193,-0.00443937) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141414,-0.021718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354167,0.00848137) , 
2, 1.17807, 1, 0, 0.246154,0.0490387) , 
1, 1.52775, 1, 0, 0.244397,0.00112532)    );
  // itree = 1171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22508,-0.001595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302632,-0.00502751) , 
3, 0.950796, 1, 0, 0.24031,0.00478386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.0057316) , 
0, 1.52075, 1, 0, 0.242218,0.000829924)    );
  // itree = 1172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182757,-0.00442764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606557,0.0202193) , 
3, 1.35652, 1, 0, 0.225137,0.000253974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35461,-0.0251319) , 
2, 1.7672, 1, 0, 0.234399,-0.00220617)    );
  // itree = 1173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559006,0.0347674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238491,-0.00109022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163673,-0.0119878) , 
0, 0.807511, 1, 0, 0.217963,0.00689748) , 
2, -1.47858, 1, 0, 0.245596,0.00398885)    );
  // itree = 1174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185897,-0.00281135) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239546,-0.00904592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342857,0.020798) , 
2, 1.83924, 1, 0, 0.245644,-0.0105783) , 
1, -1.19679, 1, 0, 0.240827,-0.00693252)    );
  // itree = 1175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00609756,-0.041821) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934579,0.00316529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349587,0.009808) , 
1, -0.220029, 1, 0, 0.287337,-0.00583775) , 
1, -1.17379, 1, 0, 0.263377,-0.0031703)    );
  // itree = 1176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0387097,-0.0174232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449704,0.0668167) , 
3, -1.64328, 1, 0, 0.253086,0.0468277) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224726,0.00140734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779817,-0.0336353) , 
3, 1.94691, 1, 0, 0.25928,-0.00194329) , 
0, -0.920459, 1, 0, 0.258313,0.00567204)    );
  // itree = 1177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569106,-0.0187893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244219,-0.00110564) , 
1, -1.41766, 1, 0, 0.265295,-0.00248768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0981595,0.00528397) , 
3, 1.73078, 1, 0, 0.252064,-0.0100978)    );
  // itree = 1178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36205,0.0031886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142098,-0.0215925) , 
3, -0.0905164, 1, 0, 0.262874,0.00421728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.0102982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142202,0.00505459) , 
3, 0.547361, 1, 0, 0.150307,-0.0470743) , 
0, 1.13798, 1, 0, 0.244489,-0.00416001)    );
  // itree = 1179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218274,0.00634767) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241379,-0.0149326) , 
3, -0.488132, 1, 0, 0.231746,0.00432998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319728,0.0183787) , 
0, 1.44542, 1, 0, 0.238095,-0.000985119)    );
  // itree = 1180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160714,0.0374019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0546218,-0.0544668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275586,0.0015226) , 
2, -1.11469, 1, 0, 0.247312,-0.00298284) , 
0, -1.74453, 1, 0, 0.242394,-0.00078276)    );
  // itree = 1181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325479,0.00974804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2227,-0.00411313) , 
0, -0.419895, 1, 0, 0.260586,0.00976583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233333,0.0605946) , 
1, 1.65151, 1, 0, 0.258919,0.00607599)    );
  // itree = 1182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334866,0.010508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853659,-0.0228368) , 
3, 0.659622, 1, 0, 0.275219,0.00833299) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15942,-0.00504944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138462,-0.0228782) , 
3, 1.2837, 1, 0, 0.149254,-0.033537) , 
0, 1.22394, 1, 0, 0.258195,0.0026743)    );
  // itree = 1183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015625,-0.0287986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105556,-0.00979383) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306086,-0.00221446) , 
1, -0.597967, 1, 0, 0.286638,-0.00142286) , 
1, -1.06103, 1, 0, 0.26123,-0.00472273)    );
  // itree = 1184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180897,0.013812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289062,-0.0122645) , 
2, -0.312107, 1, 0, 0.248508,-0.00326631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417582,0.0310511) , 
1, 1.55041, 1, 0, 0.263704,0.00135983)    );
  // itree = 1185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327303,0.00451579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143333,0.0244954) , 
3, 0.408715, 1, 0, 0.26652,-0.0104954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141844,-0.0197794) , 
0, 1.47114, 1, 0, 0.257537,-0.00697362)    );
  // itree = 1186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00982135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0401235,-0.0524028) , 
3, -1.33181, 1, 0, 0.155431,0.0307541) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384691,0.00747536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0972851,-0.00722859) , 
3, 0.835389, 1, 0, 0.297741,-0.00468913) , 
2, -0.611326, 1, 0, 0.259649,0.00479793)    );
  // itree = 1187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0795894) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260484,-0.00408412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165563,-0.0498552) , 
1, 1.55817, 1, 0, 0.252712,-0.00127654) , 
1, -1.26855, 1, 0, 0.237634,0.00207495)    );
  // itree = 1188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144262,-0.0100576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456897,0.0226781) , 
3, 0.826138, 1, 0, 0.202349,0.00062532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726115,-0.0182315) , 
3, 1.76965, 1, 0, 0.242857,-0.00201977)    );
  // itree = 1189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406626,-0.00951839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164502,-0.0116911) , 
3, -0.982158, 1, 0, 0.307282,0.0160105) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494048,0.0121041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201498,0.00526937) , 
1, -0.768694, 1, 0, 0.234198,-0.00916411) , 
0, -0.571715, 1, 0, 0.254114,-0.00230384)    );
  // itree = 1190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274673,-0.00168329) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0896226,-0.013125) , 
3, 1.0571, 1, 0, 0.25396,0.00700054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0653595,-7.54492e-05) , 
3, 1.68426, 1, 0, 0.239863,0.00345965)    );
  // itree = 1191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220408,-0.00175996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.725664,0.0563768) , 
3, 1.11321, 1, 0, 0.263079,-0.0125864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320755,-0.000992624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.04,-0.0510656) , 
3, 1.3817, 1, 0, 0.237814,0.0138215) , 
2, 0.619816, 1, 0, 0.254591,-0.00371388)    );
  // itree = 1192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24812,0.0590302) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193182,-0.0276609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266545,0.0011953) , 
1, -0.697619, 1, 0, 0.25641,-0.00322464) , 
1, -1.34521, 1, 0, 0.255871,0.000944753)    );
  // itree = 1193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291171,-0.00644563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254321,0.00904969) , 
0, 0.593869, 1, 0, 0.281744,0.0103822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.039823,-0.0382751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,0.0365035) , 
3, 1.32141, 1, 0, 0.0781671,-0.040666) , 
2, 1.09499, 1, 0, 0.243091,0.000689847)    );
  // itree = 1194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385051,0.0106486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131702,-0.00481997) , 
3, -0.226556, 1, 0, 0.260195,0.00622184) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291971,-0.0205052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308943,0.0329816) , 
0, 1.08552, 1, 0, 0.3,-0.0369624) , 
2, 1.40345, 1, 0, 0.265367,0.000610687)    );
  // itree = 1195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00657895,-0.0379746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289346,0.00362877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00730553) , 
3, 1.71142, 1, 0, 0.27381,-0.00926137) , 
1, -1.19679, 1, 0, 0.2535,-0.00570049)    );
  // itree = 1196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629771,-0.0396421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.402098,0.0179985) , 
3, -0.733003, 1, 0, 0.239964,0.000378704) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214876,-0.0476944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259604,-0.0193209) , 
1, -0.629534, 1, 0, 0.254082,-0.0253622) , 
0, 0.133846, 1, 0, 0.246628,-0.0117726)    );
  // itree = 1197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37963,-0.000693562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254227,0.00392775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180505,0.015817) , 
0, 1.2277, 1, 0, 0.24333,-0.00359853) , 
0, -1.66956, 1, 0, 0.250757,0.000797106)    );
  // itree = 1198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31348,-0.00109483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0610465,-0.0300641) , 
3, 0.765832, 1, 0, 0.259877,0.00565483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195946,-0.00265147) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151961,0.0185418) , 
3, 0.850383, 1, 0, 0.170455,-0.0416011) , 
0, 1.14349, 1, 0, 0.243915,-0.0027803)    );
  // itree = 1199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0789529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.00783914) , 
1, -1.3323, 1, 0, 0.242318,-0.0012605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371084,-0.0105758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152809,-0.0206856) , 
2, 0.616394, 1, 0, 0.25814,0.0210342) , 
3, 0.108015, 1, 0, 0.249125,0.008331)    );
  // itree = 1200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149682,-0.0398093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241314,-0.00513957) , 
1, -0.765782, 1, 0, 0.226147,-0.0111715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,-0.0495448) , 
1, 1.7097, 1, 0, 0.232384,-0.0154242)    );
  // itree = 1201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336046,-0.00268199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,0.00184813) , 
1, 0.72592, 1, 0, 0.254024,0.00161896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,0.0494501) , 
3, 1.76021, 1, 0, 0.245557,-0.0047663)    );
  // itree = 1202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282068,0.0043507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161404,-0.013272) , 
0, 0.984226, 1, 0, 0.262683,-0.00927754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0641711,-0.0128782) , 
3, 1.63045, 1, 0, 0.243753,-0.00576856)    );
  // itree = 1203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205072,-0.014068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352941,-0.0112778) , 
3, -0.0058314, 1, 0, 0.254758,0.00632852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296992,0.0121239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233618,-0.00451714) , 
0, 0.446444, 1, 0, 0.26094,-0.0255447) , 
2, 0.709315, 1, 0, 0.256682,-0.00358867)    );
  // itree = 1204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193401,-0.00228933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311594,0.0169842) , 
2, 0.227594, 1, 0, 0.239191,0.00626501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,-0.0379863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,0.0100952) , 
2, 1.78325, 1, 0, 0.333333,-0.0162527) , 
2, 1.42243, 1, 0, 0.251345,0.00335808)    );
  // itree = 1205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310764,-0.00780003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271277,0.00600207) , 
0, -0.427027, 1, 0, 0.28628,0.00360057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0166146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113269,0.00473655) , 
0, 0.4181, 1, 0, 0.090708,-0.0380096) , 
2, 1.04095, 1, 0, 0.241362,-0.00595623)    );
  // itree = 1206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127517,-0.0334683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,0.0102246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258537,0.00685777) , 
1, -0.622405, 1, 0, 0.265263,-0.00523625) , 
1, -1.26103, 1, 0, 0.255246,-0.00172177)    );
  // itree = 1207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0251256,0.0272111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277914,-0.00164085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205882,0.0261696) , 
3, 1.65933, 1, 0, 0.271111,-0.0076322) , 
1, -1.06103, 1, 0, 0.246623,-0.00108637)    );
  // itree = 1208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0881356,-0.0053165) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383033,0.0448752) , 
3, -0.376096, 1, 0, 0.205312,0.0203408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127726,-0.0322349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.636856,0.00937365) , 
3, 0.943451, 1, 0, 0.313551,-0.00875836) , 
2, 0.138482, 1, 0, 0.260302,0.00555726)    );
  // itree = 1209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375391,0.000157872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128788,0.00324484) , 
1, 0.77313, 1, 0, 0.303321,0.00809419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203883,0.0452408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0637523,-0.0298534) , 
2, 0.838917, 1, 0, 0.0858896,-0.0190689) , 
2, 0.684444, 1, 0, 0.232686,-0.000730078)    );
  // itree = 1210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219031,-0.0137353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267129,0.00176828) , 
1, -0.350114, 1, 0, 0.252694,-0.00355857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29078,0.000524241) , 
1, 1.58018, 1, 0, 0.255383,0.00121535)    );
  // itree = 1211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00518135,-0.0327164) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282815,-0.000536437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245968,0.0472692) , 
3, 1.47037, 1, 0, 0.277808,-0.00239877) , 
0, -1.16507, 1, 0, 0.251734,0.00157388)    );
  // itree = 1212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19,0.0735382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266187,0.0090417) , 
0, -1.71246, 1, 0, 0.261878,0.0130603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300885,-0.0147213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257426,-0.0513053) , 
0, 0.925018, 1, 0, 0.280374,-0.0410808) , 
2, 1.51294, 1, 0, 0.263875,0.00721455)    );
  // itree = 1213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269339,-0.0128967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0527523,-0.0273421) , 
1, 1.24559, 1, 0, 0.218515,0.0131823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223529,0.0280327) , 
0, 1.44177, 1, 0, 0.218935,0.00781267)    );
  // itree = 1214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30599,0.00391061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0218069,-0.0298114) , 
3, -0.0334047, 1, 0, 0.222222,0.00937342) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337719,0.0162885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354369,0.0101084) , 
1, 1.43133, 1, 0, 0.341573,-0.0245327) , 
2, 0.322406, 1, 0, 0.275897,-0.00587492)    );
  // itree = 1215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0770604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274809,0.0151109) , 
0, -1.63687, 1, 0, 0.229299,-0.0106412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312268,0.0089112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243612,-0.0105597) , 
0, -0.411661, 1, 0, 0.25641,0.0109991) , 
3, -0.71985, 1, 0, 0.248189,0.00443699)    );
  // itree = 1216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231884,0.0520574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245763,0.030477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244431,-0.0111366) , 
1, -1.19679, 1, 0, 0.244518,-0.00870122) , 
0, -1.41761, 1, 0, 0.243629,-0.00457525)    );
  // itree = 1217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374263,0.00387752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894526,-0.00718018) , 
1, 0.670673, 1, 0, 0.253537,-7.22407e-06) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113208,-0.0192117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268519,0.0251293) , 
0, 1.56863, 1, 0, 0.191589,-0.0283832) , 
0, 1.35023, 1, 0, 0.246845,-0.00307257)    );
  // itree = 1218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270637,-0.00222144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.037594,-0.0118578) , 
3, 1.63295, 1, 0, 0.253691,-0.00193105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.0190938) , 
0, 1.43784, 1, 0, 0.245844,0.00366001)    );
  // itree = 1219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185072,-0.0088586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288177,0.00528787) , 
3, 0.677581, 1, 0, 0.209424,0.00869736) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535088,0.0283805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270492,0.00347914) , 
0, 1.49107, 1, 0, 0.442857,-0.0234547) , 
0, 1.07303, 1, 0, 0.248913,0.00325839)    );
  // itree = 1220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206536,-0.0105845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.553571,-0.0310636) , 
3, 1.41822, 1, 0, 0.240872,-0.0139512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0169492,-0.062508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598131,0.0290336) , 
3, 1.33861, 1, 0, 0.293333,0.0167786) , 
0, 1.31913, 1, 0, 0.24701,-0.0103557)    );
  // itree = 1221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514634,0.00318988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309859,0.00336075) , 
3, -0.626002, 1, 0, 0.419608,0.0231099) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147273,0.0020512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196262,0.0383957) , 
1, 1.6045, 1, 0, 0.151616,-0.0114341) , 
1, 0.0664722, 1, 0, 0.255578,0.00196661)    );
  // itree = 1222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257353,-0.0138011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0900901,-0.0297791) , 
0, 0.421158, 1, 0, 0.22158,-0.0248227) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304551,0.00948357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185129,-0.00634524) , 
1, 1.01746, 1, 0, 0.252639,0.0017493) , 
1, -0.368349, 1, 0, 0.244717,-0.00502754)    );
  // itree = 1223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0269231,-0.00639065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996241,-0.00191822) , 
3, -1.33416, 1, 0, 0.0757576,0.0103958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156182,-0.014435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469543,0.0119532) , 
1, 0.701694, 1, 0, 0.353883,-0.010535) , 
1, -0.0254922, 1, 0, 0.245958,-0.00241292)    );
  // itree = 1224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.0421215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212389,-0.0288685) , 
0, 0.0514282, 1, 0, 0.256532,0.0252011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213483,-0.0421002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271284,0.00333103) , 
0, -0.920459, 1, 0, 0.264706,-0.00106376) , 
1, -0.571833, 1, 0, 0.262972,0.00450676)    );
  // itree = 1225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393939,0.023419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222051,-0.00824783) , 
0, -0.866633, 1, 0, 0.259639,0.00338548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184615,0.000922495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163842,0.0161992) , 
1, 0.2216, 1, 0, 0.172638,-0.0349186) , 
0, 1.13453, 1, 0, 0.24606,-0.00259283)    );
  // itree = 1226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157233,-0.00963537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25458,0.00309023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273469,-0.0252298) , 
2, 1.43055, 1, 0, 0.257112,-0.0166238) , 
1, -1.19679, 1, 0, 0.249119,-0.0124112)    );
  // itree = 1227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193122,0.0427548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220808,-0.00579622) , 
3, -1.2237, 1, 0, 0.214702,0.00934801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59893,0.00652008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205674,-0.0144601) , 
0, 0.365468, 1, 0, 0.429878,-0.0266717) , 
1, 1.39555, 1, 0, 0.249265,0.00356228)    );
  // itree = 1228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177804,-0.00531115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479675,0.0252135) , 
3, 1.41385, 1, 0, 0.197939,-0.000859988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664234,-0.023462) , 
3, 1.73078, 1, 0, 0.230187,-0.00406712)    );
  // itree = 1229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309859,-0.0249314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345821,-0.0159269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226891,0.00179846) , 
3, -0.978789, 1, 0, 0.250141,0.00437136) , 
0, -1.45364, 1, 0, 0.254564,0.0074992)    );
  // itree = 1230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319328,-0.00172602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522388,-0.0289817) , 
3, -0.363287, 1, 0, 0.246436,0.0254401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337148,0.0055404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894737,-0.00832848) , 
3, 1.00457, 1, 0, 0.275066,-0.0200276) , 
1, -0.428552, 1, 0, 0.268062,-0.0089042)    );
  // itree = 1231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0899471,0.0520203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0178571,-0.0655316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28687,-0.00488376) , 
0, -0.999272, 1, 0, 0.261408,0.00828018) , 
3, -1.74385, 1, 0, 0.244908,0.00503315)    );
  // itree = 1232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0261628,-0.0304603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330514,0.0221185) , 
3, -1.25079, 1, 0, 0.271129,0.0176795) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214876,-0.0513704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412844,-0.00590884) , 
1, 0.455018, 1, 0, 0.308696,-0.0329723) , 
0, 1.31913, 1, 0, 0.275464,0.0118341)    );
  // itree = 1233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305,0.00343484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235521,-0.00654498) , 
0, -0.201887, 1, 0, 0.277693,0.0135922) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210611,-0.00376441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.00419685) , 
2, 1.70437, 1, 0, 0.198347,-0.0175066) , 
0, 0.50039, 1, 0, 0.249511,0.00254631)    );
  // itree = 1234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274795,-0.00212655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170492,-0.0168525) , 
0, 1.05608, 1, 0, 0.257945,0.0106627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0431655,-0.0469337) , 
3, 1.74551, 1, 0, 0.243217,0.0143347)    );
  // itree = 1235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0294118,-0.0404519) , 
3, -1.73692, 1, 0, 0.0137931,0.0340564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324281,0.0246967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256295,-0.00628209) , 
3, -0.397029, 1, 0, 0.280783,0.00348074) , 
0, -1.07537, 1, 0, 0.242604,0.00785301)    );
  // itree = 1236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0853659,-0.0121775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572559,0.0316424) , 
3, -0.533946, 1, 0, 0.297359,0.0149893) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222096,-0.0153772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31383,0.0147572) , 
2, 1.49408, 1, 0, 0.238274,-0.00901012) , 
1, 0.204761, 1, 0, 0.264843,0.00178157)    );
  // itree = 1237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288943,0.00457091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0742358,-0.0174879) , 
3, 1.09607, 1, 0, 0.262594,-0.000685563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0872483,-0.0226681) , 
3, 1.73078, 1, 0, 0.249628,0.00239458)    );
  // itree = 1238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465116,0.00928443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709939,-0.0503007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308937,0.00925361) , 
2, -0.483104, 1, 0, 0.247649,0.00338984) , 
3, -1.91277, 1, 0, 0.26138,0.000849655)    );
  // itree = 1239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217772,0.00166887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220183,-0.0442922) , 
1, 1.56335, 1, 0, 0.217926,-0.00315151) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.605948,0.035792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673077,-0.108409) , 
1, 0.974233, 1, 0, 0.455764,0.0245738) , 
0, 1.13453, 1, 0, 0.260577,0.00182039)    );
  // itree = 1240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128596,-0.00651911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.536178,0.0158147) , 
3, 0.461419, 1, 0, 0.256246,0.0042004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211864,0.0085592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296,-0.0402344) , 
1, 0.447875, 1, 0, 0.255144,-0.0333767) , 
0, 1.29896, 1, 0, 0.25611,-0.000448902)    );
  // itree = 1241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53937,-0.0049529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27451,0.00562421) , 
2, -1.00072, 1, 0, 0.357055,-0.00631833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183559,0.00293671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197183,0.00243727) , 
0, 1.05667, 1, 0, 0.18686,0.0144175) , 
3, -0.462334, 1, 0, 0.256668,0.00591237)    );
  // itree = 1242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340361,0.000797306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31457,-0.00601874) , 
1, -0.095926, 1, 0, 0.328076,0.0121511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193078,0.00409239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214628,-0.00392697) , 
1, 0.240541, 1, 0, 0.206074,-0.015082) , 
0, -0.479386, 1, 0, 0.244422,-0.0065219)    );
  // itree = 1243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0257732,0.0646038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259225,-0.00408549) , 
1, -1.03391, 1, 0, 0.223787,0.0105542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.640777,0.105647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269814,0.00515511) , 
0, -0.304418, 1, 0, 0.324713,-0.0207378) , 
3, 0.521064, 1, 0, 0.259372,-0.000478859)    );
  // itree = 1244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00961538,-0.0664269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147059,0.0353652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280335,-0.0057962) , 
2, -1.00475, 1, 0, 0.261697,-0.00176508) , 
3, -2.21683, 1, 0, 0.248902,-0.0038005)    );
  // itree = 1245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381457,0.0103542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188517,-0.00404608) , 
3, -0.521418, 1, 0, 0.269444,-8.75196e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.00408191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.0277799) , 
2, 0.921086, 1, 0, 0.104265,0.0320961) , 
1, 1.5027, 1, 0, 0.252113,0.00328928)    );
  // itree = 1246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272327,0.004406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0768043) , 
3, 1.6047, 1, 0, 0.255006,-0.00988641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426573,-0.00160395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,0.015796) , 
3, 1.37466, 1, 0, 0.330677,0.0174525) , 
2, 1.35605, 1, 0, 0.264751,-0.0063656)    );
  // itree = 1247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115709,-0.0230328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230241,-0.00560511) , 
3, 0.761046, 1, 0, 0.138305,0.0156837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683099,0.0281404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191304,-0.0505874) , 
0, 0.778171, 1, 0, 0.578558,-0.0175203) , 
1, 1.16801, 1, 0, 0.256448,0.00677329)    );
  // itree = 1248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,0.0483258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221831,-0.0107667) , 
0, -1.5224, 1, 0, 0.221366,-0.00695218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390411,0.0252224) , 
2, 1.7595, 1, 0, 0.233945,-0.00371955)    );
  // itree = 1249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513158,-0.000242473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565217,0.0202135) , 
0, -0.468488, 1, 0, 0.535581,0.0349164) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284464,0.00715832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153285,0.0098851) , 
3, 0.192484, 1, 0, 0.22235,-0.00648872) , 
1, -0.840753, 1, 0, 0.264104,-0.00096942)    );
  // itree = 1250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40625,-0.0236523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227142,-0.00483243) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0194943) , 
3, 1.9061, 1, 0, 0.218192,0.00247703) , 
0, -1.61795, 1, 0, 0.23038,0.00676788)    );
  // itree = 1251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146577,-0.0124002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565789,-0.00759576) , 
1, 1.46259, 1, 0, 0.200168,0.0203618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377358,0.044025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358086,0.000130255) , 
1, -0.321013, 1, 0, 0.360955,-0.0146214) , 
0, 0.379193, 1, 0, 0.260389,0.00725916)    );
  // itree = 1252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258475,0.0508708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242647,-0.00911465) , 
0, -0.221527, 1, 0, 0.252688,0.0310709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22777,-0.008839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325,0.0126075) , 
2, 1.43353, 1, 0, 0.241481,-0.00548073) , 
1, -0.71469, 1, 0, 0.243491,0.00107531)    );
  // itree = 1253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416031,0.0160075) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288439,0.00864462) , 
0, -1.07107, 1, 0, 0.318801,0.00510588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259307,0.0138105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0978261,-0.0132153) , 
3, 1.64522, 1, 0, 0.228453,-0.0202985) , 
0, 0.125775, 1, 0, 0.276647,-0.00674703)    );
  // itree = 1254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373724,0.00935812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.0346991) , 
3, -0.077033, 1, 0, 0.288043,0.00979954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202788,0.0040054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224138,0.0230909) , 
0, 1.56834, 1, 0, 0.205525,-0.015012) , 
0, 0.130486, 1, 0, 0.250871,-0.00137741)    );
  // itree = 1255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00495049,-0.0600915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0996564,-0.0128647) , 
3, -1.37293, 1, 0, 0.0608519,0.031414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108434,0.0170931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335075,-0.00193326) , 
0, -0.920459, 1, 0, 0.310093,-0.00163983) , 
1, -0.449147, 1, 0, 0.248624,0.00651202)    );
  // itree = 1256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251121,0.0334765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1368,-0.0218442) , 
1, -0.888724, 1, 0, 0.154107,-0.00838775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382716,-0.0117186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623134,0.0297558) , 
2, 0.885767, 1, 0, 0.508806,0.0215235) , 
3, 0.832675, 1, 0, 0.245464,-0.000683786)    );
  // itree = 1257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287611,-0.00214098) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119601,0.0264563) , 
2, 0.944998, 1, 0, 0.260754,-0.00679261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735294,-0.0124127) , 
2, 1.609, 1, 0, 0.242453,-0.00280255)    );
  // itree = 1258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25453,0.00117109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414365,-0.00367687) , 
2, 0.683145, 1, 0, 0.291244,-0.00361603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0384615,-0.019473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146789,-0.0313657) , 
1, 1.55125, 1, 0, 0.0665083,0.0270501) , 
3, 1.00373, 1, 0, 0.243866,0.00284888)    );
  // itree = 1259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2086,-0.00605789) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342857,0.0171996) , 
2, 0.587679, 1, 0, 0.238636,-0.00661882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.635135,0.0437293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123684,-0.0186895) , 
2, 0.352213, 1, 0, 0.267045,0.0306706) , 
3, 0.766583, 1, 0, 0.246384,0.00355103)    );
  // itree = 1260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.00638576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196319,-0.0531768) , 
0, -0.527912, 1, 0, 0.193353,-0.0238625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0519878,-0.00916666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384023,0.0129723) , 
3, -0.27663, 1, 0, 0.255759,0.00905381) , 
1, -0.796791, 1, 0, 0.245553,0.00367076)    );
  // itree = 1261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455621,0.0178807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175182,-0.0102951) , 
3, -0.858567, 1, 0, 0.374737,0.0348833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221587,-0.0079041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0295568) , 
3, 1.62876, 1, 0, 0.203927,0.00513867) , 
0, -0.69773, 1, 0, 0.243427,0.0120173)    );
  // itree = 1262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169604,-0.0181845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299909,0.00942146) , 
2, -0.624804, 1, 0, 0.261767,0.00343959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208861,-0.00637373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157025,0.0119438) , 
3, 1.38642, 1, 0, 0.194508,-0.022975) , 
1, 1.24559, 1, 0, 0.246982,-0.00236684)    );
  // itree = 1263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109827,0.0259985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13884,-0.0170995) , 
3, -1.2237, 1, 0, 0.132075,0.0142518) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.730435,0.0223055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464164,0.0327984) , 
3, 0.487166, 1, 0, 0.581262,-0.0254276) , 
1, 1.16729, 1, 0, 0.249128,0.00391181)    );
  // itree = 1264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0902022,0.00451335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473348,0.0312954) , 
3, -0.413963, 1, 0, 0.251799,0.0203138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245174,-0.024136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283854,0.0114649) , 
1, 0.863264, 1, 0, 0.261641,-0.00963249) , 
0, 0.23336, 1, 0, 0.256207,0.0069019)    );
  // itree = 1265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319256,0.00293987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184116,0.0282438) , 
3, 0.620697, 1, 0, 0.296894,-0.00975948) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.084507,-0.00660402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124224,0.0284879) , 
3, 1.77588, 1, 0, 0.101604,0.0190539) , 
3, 1.19852, 1, 0, 0.26123,-0.00449767)    );
  // itree = 1266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189024,-0.0114002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256198,-0.0216473) , 
2, 0.56542, 1, 0, 0.194696,0.0132097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363834,0.00974698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0648148,-0.0302727) , 
3, 1.9041, 1, 0, 0.306878,-0.00737991) , 
2, 0.77689, 1, 0, 0.2265,0.00737252)    );
  // itree = 1267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162537,-0.00394619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376101,0.0104548) , 
0, 0.125775, 1, 0, 0.256652,-8.91154e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188172,-0.0510554) , 
1, 1.51722, 1, 0, 0.250251,0.00428471)    );
  // itree = 1268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0361174,-0.0205175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311902,0.0253674) , 
3, -1.00222, 1, 0, 0.207836,0.015229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361257,0.0146158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282477,-0.0172908) , 
1, 0.254315, 1, 0, 0.300117,-0.0134548) , 
2, 0.324939, 1, 0, 0.24667,0.0031583)    );
  // itree = 1269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278449,-0.0061361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0747126,-0.0106962) , 
3, 1.00866, 1, 0, 0.258157,-0.00800461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0521739,-0.0347934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,-0.0132024) , 
1, 1.22327, 1, 0, 0.0826087,0.0285712) , 
3, 1.52344, 1, 0, 0.237734,-0.00374946)    );
  // itree = 1270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218919,0.00265798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308979,0.00176394) , 
1, -0.652927, 1, 0, 0.286853,-0.00547536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0792064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134731,0.00263919) , 
2, 0.635399, 1, 0, 0.0907258,0.0158465) , 
3, 0.853537, 1, 0, 0.238262,-0.000192814)    );
  // itree = 1271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678466,-0.00688124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223629,-0.0102959) , 
0, -0.863368, 1, 0, 0.182595,0.00524659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.364865,0.00880024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364865,-0.00457003) , 
1, 0.792843, 1, 0, 0.364865,-0.0187878) , 
0, 0.566352, 1, 0, 0.244752,-0.00294945)    );
  // itree = 1272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232484,0.0196175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221877,-0.00452199) , 
0, -0.478807, 1, 0, 0.225352,0.00316154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.859813,0.0274912) , 
3, 1.93088, 1, 0, 0.258893,0.00543983)    );
  // itree = 1273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.290931,0.00448339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0639098,-0.0150923) , 
3, 1.22082, 1, 0, 0.259298,0.00359155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115702,0.0113433) , 
2, 1.76296, 1, 0, 0.250739,0.00112594)    );
  // itree = 1274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27017,0.00433118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31875,0.00638316) , 
2, 1.13903, 1, 0, 0.275314,0.00970091) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161826,-0.0151358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0956522,-0.0127201) , 
3, 1.67958, 1, 0, 0.149079,-0.0212695) , 
1, 1.16835, 1, 0, 0.239564,0.000929885)    );
  // itree = 1275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962672,-0.0147493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.423767,0.00789579) , 
1, 0.568008, 1, 0, 0.249215,-0.00691815) , 
0, -1.7478, 1, 0, 0.236228,-0.00328607)    );
  // itree = 1276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,0.0521178) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214703,-0.00873932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279614,0.00995081) , 
0, 0.474519, 1, 0, 0.23921,-0.00125096) , 
1, -1.45172, 1, 0, 0.238777,0.00150123)    );
  // itree = 1277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337808,0.00542045) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.015625,-0.0721028) , 
3, 1.24904, 1, 0, 0.309735,0.00492809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0342466,-0.0442284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15736,0.0122741) , 
0, 1.00948, 1, 0, 0.0838446,-0.0197978) , 
2, 0.845279, 1, 0, 0.25332,-0.00124706)    );
  // itree = 1278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344444,-0.0198577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228402,0.000187385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342857,0.0331198) , 
1, 1.59889, 1, 0, 0.237158,-0.00394215) , 
0, -1.26434, 1, 0, 0.246766,0.000569734)    );
  // itree = 1279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00510204,-0.0700417) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923913,0.00431599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290067,-0.00066116) , 
1, -0.723755, 1, 0, 0.270137,-0.00403489) , 
1, -1.15014, 1, 0, 0.244433,-0.000841479)    );
  // itree = 1280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249221,0.0375919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.0393489) , 
1, 0.640844, 1, 0, 0.20892,0.0215133) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171406,-0.0243465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.65233,0.0146772) , 
3, 1.37049, 1, 0, 0.258252,-0.0118144) , 
0, -0.728092, 1, 0, 0.24759,-0.00461113)    );
  // itree = 1281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526042,-0.0164294) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431298,0.0136332) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175497,-0.00417772) , 
1, -0.486457, 1, 0, 0.213318,0.00200917) , 
1, -1.08132, 1, 0, 0.24389,0.0054895)    );
  // itree = 1282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285088,-0.000468933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0166667,-0.0192139) , 
3, 1.50532, 1, 0, 0.266317,0.00835945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0852018,-0.00415563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267717,0.00802266) , 
2, 1.16723, 1, 0, 0.151429,-0.031063) , 
0, 1.11463, 1, 0, 0.246854,0.00168092)    );
  // itree = 1283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0900823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280379,0.0042036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195876,-0.0576315) , 
1, 1.52343, 1, 0, 0.271664,-0.00716337) , 
1, -1.36088, 1, 0, 0.257431,-0.00312021)    );
  // itree = 1284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0826206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380597,0.0512681) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243847,-0.0046624) , 
0, -1.13223, 1, 0, 0.253589,0.000404003) , 
3, -2.21683, 1, 0, 0.240787,-0.00235992)    );
  // itree = 1285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304979,-0.000698894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1261,0.0111412) , 
3, 0.746277, 1, 0, 0.270845,0.00341943) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0867052,0.0114605) , 
3, 1.68426, 1, 0, 0.254592,-0.00132927)    );
  // itree = 1286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462687,0.0030143) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,0.00655475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252189,0.00211833) , 
1, -1.19679, 1, 0, 0.2452,-0.0130925) , 
0, -1.42158, 1, 0, 0.260092,-0.00956953)    );
  // itree = 1287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209949,0.000841272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303448,-0.00222172) , 
3, 0.422166, 1, 0, 0.240657,0.00465646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245161,-0.00495355) , 
1, 1.55041, 1, 0, 0.24102,0.000865714)    );
  // itree = 1288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223404,0.0239158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0578106,-0.0280696) , 
1, -0.993154, 1, 0, 0.0889111,-0.00641118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514706,0.0558744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407407,0.0117563) , 
0, -0.365067, 1, 0, 0.422405,0.0252438) , 
3, -0.102347, 1, 0, 0.253293,0.00919182)    );
  // itree = 1289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.502618,-0.00869938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220862,0.000192191) , 
1, -1.06932, 1, 0, 0.249082,-0.000868597) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293103,0.0578319) , 
0, 1.55414, 1, 0, 0.251607,-0.0043658)    );
  // itree = 1290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347973,-0.00607965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204893,-0.00800468) , 
3, -1.4692, 1, 0, 0.226825,0.00294131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322785,0.0210471) , 
1, 1.59889, 1, 0, 0.234083,-0.001203)    );
  // itree = 1291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249625,0.00331378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302714,0.00277318) , 
2, 0.683145, 1, 0, 0.263651,-0.00870302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175879,0.0114376) , 
3, 1.58812, 1, 0, 0.25497,-0.00473791)    );
  // itree = 1292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116484,0.012813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397671,0.0296867) , 
3, -0.100392, 1, 0, 0.228326,0.0220126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140584,-0.0365564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.765517,0.0138343) , 
3, 1.60377, 1, 0, 0.314176,-0.0160107) , 
2, 0.823591, 1, 0, 0.250369,0.0122496)    );
  // itree = 1293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291667,-0.024216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327599,0.0106397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.063745,-0.0292462) , 
1, 1.17822, 1, 0, 0.257775,-0.000370773) , 
0, -1.66956, 1, 0, 0.259792,0.00291029)    );
  // itree = 1294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421488,-0.00522554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415094,0.0102743) , 
0, -1.53777, 1, 0, 0.418502,-0.0340552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244135,-0.0052667) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198731,0.0219731) , 
0, 0.96906, 1, 0, 0.232444,-0.000898401) , 
0, -1.11841, 1, 0, 0.252907,-0.004545)    );
  // itree = 1295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236948,-0.00976534) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332553,0.00119243) , 
2, 0.683145, 1, 0, 0.261364,0.000190805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273504,0.0570229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,-0.0352981) , 
1, 0.882841, 1, 0, 0.281437,0.0230995) , 
3, 1.30263, 1, 0, 0.264706,0.00400512)    );
  // itree = 1296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121771,-0.0170666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429864,0.0142554) , 
3, 0.561522, 1, 0, 0.197551,-0.00368623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.607527,-0.019232) , 
3, 1.61709, 1, 0, 0.236006,-0.00679696)    );
  // itree = 1297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550847,-0.00563496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372907,0.00415099) , 
3, -1.98093, 1, 0, 0.4,0.00715108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170364,-0.00283903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1125,-0.00194909) , 
3, 1.74087, 1, 0, 0.16317,-0.0185834) , 
2, -0.204072, 1, 0, 0.252182,-0.00891112)    );
  // itree = 1298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415929,0.0129024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232335,0.0107142) , 
0, -0.69773, 1, 0, 0.285349,0.0145742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16358,-0.0130117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312139,-0.0198016) , 
2, 1.49322, 1, 0, 0.194884,-0.0213987) , 
1, 0.634693, 1, 0, 0.24812,-0.000229708)    );
  // itree = 1299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813215,-0.0129714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413628,0.0105559) , 
1, 0.122583, 1, 0, 0.27064,-0.00629639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0322581,-0.0681835) , 
1, 1.65151, 1, 0, 0.255504,-0.0102079)    );
  // itree = 1300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0257732,-0.03238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318337,0.00848891) , 
3, -1.22457, 1, 0, 0.257143,0.00485605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.413462,-0.0216968) , 
1, 1.65151, 1, 0, 0.265442,0.00261816)    );
  // itree = 1301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356361,0.0122623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132682,-0.0075918) , 
3, 0.186325, 1, 0, 0.272202,-0.0018696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101449,-0.0101601) , 
3, 1.76021, 1, 0, 0.260657,-0.0052492)    );
  // itree = 1302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34799,0.0118134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0630915,-0.0328618) , 
3, -0.342716, 1, 0, 0.221678,0.0123775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328657,0.00391894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268657,0.0263277) , 
0, 1.32765, 1, 0, 0.315956,-0.0159833) , 
2, 0.70608, 1, 0, 0.250606,0.00367539)    );
  // itree = 1303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0898204,-0.00920805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139498,-0.0169418) , 
3, -0.388717, 1, 0, 0.114089,0.0185501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.629191,0.0134949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294118,0.0163099) , 
3, 1.31285, 1, 0, 0.538905,-0.0298758) , 
1, 0.939437, 1, 0, 0.2615,0.00174627)    );
  // itree = 1304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151578,-0.0164141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53653,0.0176061) , 
3, 0.765832, 1, 0, 0.240506,-0.00308526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328467,-0.0447843) , 
2, 1.76296, 1, 0, 0.246434,-0.00765774)    );
  // itree = 1305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466498,0.0151651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148936,-0.00270718) , 
2, 0.626163, 1, 0, 0.418455,-0.0122964) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153215,0.00249606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0887574,-0.00431829) , 
3, 1.02973, 1, 0, 0.132834,0.00390623) , 
1, 0.292035, 1, 0, 0.265867,-0.00364042)    );
  // itree = 1306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354348,0.00377881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259259,0.0132423) , 
3, -0.226603, 1, 0, 0.325283,0.00679531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0229008,-0.0452342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109541,-0.0069208) , 
0, -0.0840682, 1, 0, 0.0932568,-0.0258572) , 
3, 0.538396, 1, 0, 0.245302,-0.00446027)    );
  // itree = 1307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199029,-0.019641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336842,-0.00835916) , 
3, 0.53774, 1, 0, 0.231436,0.0101088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273356,-0.00327046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0176326) , 
0, 1.25827, 1, 0, 0.246851,-0.0344547) , 
2, 1.06564, 1, 0, 0.234476,0.00132009)    );
  // itree = 1308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25261,0.0276486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12351,-0.00101864) , 
1, -0.441576, 1, 0, 0.167618,0.00981726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390244,-0.0498043) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.457854,-0.0118628) , 
0, -0.0304193, 1, 0, 0.444961,-0.0319001) , 
3, 0.613245, 1, 0, 0.255007,-0.00332767)    );
  // itree = 1309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440449,-0.00284301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178357,0.00503713) , 
3, -0.908112, 1, 0, 0.301907,0.0131837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229117,-0.000617001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183036,0.00732276) , 
0, 1.31954, 1, 0, 0.219397,-0.0114398) , 
0, -0.0968335, 1, 0, 0.258225,0.000147729)    );
  // itree = 1310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381503,0.0102451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139785,0.00122865) , 
3, -0.226556, 1, 0, 0.284356,0.00752636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133909,-0.0133041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298368,-0.0048442) , 
2, 0.729966, 1, 0, 0.213004,-0.0115561) , 
1, 0.552807, 1, 0, 0.253294,-0.000780877)    );
  // itree = 1311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195455,-0.0128068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0119933) , 
0, 0.657373, 1, 0, 0.263529,0.00979338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.421488,0.0345982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139785,-0.00957549) , 
0, 0.762336, 1, 0, 0.250814,-0.0220477) , 
3, 1.28958, 1, 0, 0.261584,0.00492283)    );
  // itree = 1312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0170455,-0.0484697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438596,0.045423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262831,0.00111427) , 
0, -1.20427, 1, 0, 0.27345,0.00500801) , 
3, -1.82503, 1, 0, 0.251575,0.00248846)    );
  // itree = 1313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683333,0.0188327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231808,-0.00140837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0613208,-0.0254365) , 
2, 1.54989, 1, 0, 0.212944,-0.000822778) , 
1, -1.34521, 1, 0, 0.240668,0.00205362)    );
  // itree = 1314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183128,-0.0134455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216216,0.0164848) , 
2, 0.0715435, 1, 0, 0.186519,0.0134865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436261,0.0216801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.0181171) , 
3, 1.1807, 1, 0, 0.342799,-0.0108802) , 
2, 0.231303, 1, 0, 0.260996,0.0018743)    );
  // itree = 1315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189693,-0.00506948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496212,0.00244103) , 
3, 0.245103, 1, 0, 0.258503,0.00765861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353933,0.0196678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177011,0.00497854) , 
3, 0.476249, 1, 0, 0.256637,-0.0295688) , 
2, 0.352049, 1, 0, 0.257753,-0.00731185)    );
  // itree = 1316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0266667,-0.0401635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322064,0.0278299) , 
3, -1.75753, 1, 0, 0.259831,0.0210998) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238636,-0.0154284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218391,0.0159018) , 
1, 1.2928, 1, 0, 0.231939,-0.00381954) , 
1, -0.111799, 1, 0, 0.241737,0.00493359)    );
  // itree = 1317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372569,-0.00996316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136476,0.0124438) , 
1, 0.813541, 1, 0, 0.303623,0.00961476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921788,0.019499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186813,0.0341479) , 
0, 0.76068, 1, 0, 0.133122,-0.0308061) , 
2, 0.688035, 1, 0, 0.250124,-0.00306825)    );
  // itree = 1318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445748,0.0206164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228054,-0.00637118) , 
3, -1.17428, 1, 0, 0.279391,0.0150682) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171642,-0.00794308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15748,-0.0116859) , 
0, 1.29579, 1, 0, 0.164751,-0.0128169) , 
0, 0.828962, 1, 0, 0.248984,0.00767189)    );
  // itree = 1319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261318,0.00488333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359606,0.0345052) , 
3, 1.45598, 1, 0, 0.271561,-0.00226773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00869565,-0.0868933) , 
1, 1.67456, 1, 0, 0.256907,2.92341e-05)    );
  // itree = 1320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289291,0.0200011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226437,-0.0102626) , 
1, 0.125734, 1, 0, 0.254877,0.00403397) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103774,-0.0724761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284946,-0.00506357) , 
1, -0.215086, 1, 0, 0.24477,-0.0229435) , 
0, 0.896613, 1, 0, 0.25254,-0.00220465)    );
  // itree = 1321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26943,-0.0129159) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254878,0.013734) , 
0, 0.0415839, 1, 0, 0.262745,-0.00233335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,-0.0157085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,-0.0148312) , 
3, 1.71599, 1, 0, 0.14486,0.030642) , 
0, 1.3861, 1, 0, 0.250125,0.00119677)    );
  // itree = 1322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301818,-0.00475821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22547,-0.0239422) , 
1, 0.221805, 1, 0, 0.266278,0.0104942) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219481,0.011022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0072523) , 
3, 1.85126, 1, 0, 0.20202,-0.0239624) , 
0, 0.201876, 1, 0, 0.236458,-0.00549578)    );
  // itree = 1323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0289241) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320381,-0.00628403) , 
1, -0.451368, 1, 0, 0.241557,-0.00414878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324324,-0.0234169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.088,0.0177307) , 
2, 1.43656, 1, 0, 0.229032,0.0297595) , 
3, 1.29216, 1, 0, 0.239669,0.00096137)    );
  // itree = 1324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405904,-0.0344997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275618,0.048171) , 
3, -1.01777, 1, 0, 0.16065,0.0153379) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269426,-0.015595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406114,0.0150712) , 
2, 1.45206, 1, 0, 0.291578,-0.0100636) , 
2, -0.632281, 1, 0, 0.254703,-0.00290936)    );
  // itree = 1325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34967,0.00147019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216327,-0.00392267) , 
3, -0.0665735, 1, 0, 0.307544,-0.00873001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102767,-0.000739991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0895522,-0.0142313) , 
2, 0.901102, 1, 0, 0.0959693,0.0188905) , 
3, 0.832675, 1, 0, 0.254344,-0.00178488)    );
  // itree = 1326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272237,-0.0136173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302583,0.00296622) , 
1, -0.174847, 1, 0, 0.290252,0.0114476) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271895,0.0155111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107884,0.00875496) , 
3, 1.38144, 1, 0, 0.232604,-0.0103555) , 
0, -0.0107878, 1, 0, 0.260031,1.77436e-05)    );
  // itree = 1327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236493,0.0247578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313483,0.00856337) , 
3, -0.0546649, 1, 0, 0.273116,0.00165237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0241935,-0.0772217) , 
1, 1.65151, 1, 0, 0.257644,-0.00174116)    );
  // itree = 1328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232143,0.0557567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722477,-0.0270561) , 
0, -1.59677, 1, 0, 0.0904472,-0.00783667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.519608,0.0291488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35623,-0.00563518) , 
0, 0.315313, 1, 0, 0.420696,0.0126617) , 
3, -0.097287, 1, 0, 0.259663,0.00266648)    );
  // itree = 1329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358974,0.00282283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368056,0.0165971) , 
0, -1.16688, 1, 0, 0.362832,-0.0200745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3093,0.00518176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103611,-0.00989457) , 
2, 0.566681, 1, 0, 0.227102,-0.00199858) , 
0, -0.828905, 1, 0, 0.250905,-0.00516864)    );
  // itree = 1330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289395,-0.00145246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229961,0.00865227) , 
0, 0.0774312, 1, 0, 0.263842,0.00773748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0552764,-0.00988051) , 
3, 1.64517, 1, 0, 0.242763,0.00275986)    );
  // itree = 1331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244151,-0.00128372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351111,-0.0151265) , 
3, 1.14439, 1, 0, 0.256871,-0.000162073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138365,0.058355) , 
3, 1.77248, 1, 0, 0.247684,-0.0041139)    );
  // itree = 1332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226481,0.020609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201263,-0.00525216) , 
0, -0.557972, 1, 0, 0.209125,0.0028448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462963,-0.039477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.745455,0.00358161) , 
2, 1.1929, 1, 0, 0.605505,-0.0310908) , 
3, 1.61777, 1, 0, 0.251093,-0.000748185)    );
  // itree = 1333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324523,-0.00195823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269321,0.000416595) , 
0, -0.406361, 1, 0, 0.293811,0.00139562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129199,0.0269862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990991,-0.0165867) , 
2, 1.60427, 1, 0, 0.12249,-0.0355521) , 
3, 0.832675, 1, 0, 0.251845,-0.00765503)    );
  // itree = 1334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.426573,-0.012742) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307407,0.00115674) , 
0, -1.44337, 1, 0, 0.348668,-0.0163881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267681,0.00648229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934959,-0.00584402) , 
3, 0.764093, 1, 0, 0.214419,0.0118114) , 
0, -0.784322, 1, 0, 0.24184,0.00605158)    );
  // itree = 1335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22954,-0.00216865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256506,-0.0105098) , 
3, 1.15253, 1, 0, 0.233497,0.00255499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12766,-0.0422189) , 
1, 1.56335, 1, 0, 0.225937,-0.00289633)    );
  // itree = 1336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134565,-0.00164452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36631,0.0319176) , 
3, -0.0186823, 1, 0, 0.211131,0.0119716) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330357,-0.0515949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366013,-0.00494105) , 
1, -0.104697, 1, 0, 0.36146,-0.0121283) , 
2, 0.352049, 1, 0, 0.276755,0.00145116)    );
  // itree = 1337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447581,0.0126273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0743802,-0.00720309) , 
3, 0.593619, 1, 0, 0.395376,-0.0190398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181102,-0.0365587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137787,0.000101297) , 
1, -0.367669, 1, 0, 0.142857,0.00378347) , 
2, -0.0368688, 1, 0, 0.254872,-0.00634069)    );
  // itree = 1338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280702,-0.0108265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605839,0.0277861) , 
2, -0.522901, 1, 0, 0.425325,-0.0504261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381057,0.0250178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206661,0.00989113) , 
3, -0.487322, 1, 0, 0.255385,-0.00154642) , 
0, -0.920459, 1, 0, 0.282463,-0.0093348)    );
  // itree = 1339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668151,-0.0234428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322835,0.0032872) , 
0, -0.700762, 1, 0, 0.21679,-0.00887689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140244,-0.00233793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385057,0.000332098) , 
1, 0.837686, 1, 0, 0.266272,0.0139042) , 
3, -0.0237104, 1, 0, 0.240705,0.00213361)    );
  // itree = 1340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226616,0.00383828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.066838,-0.0462966) , 
0, 0.676908, 1, 0, 0.190141,-0.00356617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.659686,0.0354733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476562,-0.00396931) , 
1, 1.40824, 1, 0, 0.586207,0.0356697) , 
3, 1.30263, 1, 0, 0.252595,0.00262081)    );
  // itree = 1341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.455738,0.000302812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201701,0.00753447) , 
1, -0.0633655, 1, 0, 0.309839,0.0043259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103659,0.000361217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990566,-0.0226883) , 
2, 0.334576, 1, 0, 0.10034,0.0398764) , 
3, 0.647058, 1, 0, 0.248887,0.0146691)    );
  // itree = 1342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3376,0.00541299) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0879765,-0.0124194) , 
3, 0.29573, 1, 0, 0.249482,0.00961474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373832,0.0312499) , 
1, 1.65151, 1, 0, 0.256008,0.00513761)    );
  // itree = 1343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242012,0.00185151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359649,0.0480101) , 
3, 1.59734, 1, 0, 0.249446,0.00430323) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.495652,0.0216274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.002414) , 
3, 1.14697, 1, 0, 0.26749,-0.0301965) , 
2, 1.40345, 1, 0, 0.251588,0.000207759)    );
  // itree = 1344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215543,-0.00330206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0414938,-0.0548324) , 
1, 0.649358, 1, 0, 0.170098,-0.0110314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38835,0.0428151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323413,0.00131615) , 
1, -0.418722, 1, 0, 0.329433,0.00589059) , 
2, -0.0368688, 1, 0, 0.257129,-0.00178838)    );
  // itree = 1345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316598,-0.0118693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1682,-0.00962815) , 
3, -0.133169, 1, 0, 0.251583,0.00831633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0897436,0.0242901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,0.0138853) , 
1, 1.36355, 1, 0, 0.099631,-0.0430809) , 
3, 1.34451, 1, 0, 0.231076,0.00137974)    );
  // itree = 1346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259542,-0.00010355) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32897,0.00337819) , 
1, -0.546258, 1, 0, 0.311241,-0.00806683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0795627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151724,0.00128148) , 
2, 0.627338, 1, 0, 0.0993228,0.0334166) , 
3, 0.907161, 1, 0, 0.263875,0.00120519)    );
  // itree = 1347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0759865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0973154,0.0172773) , 
3, -1.6889, 1, 0, 0.0672854,0.036773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320453,-0.0019119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0875599) , 
1, 1.74221, 1, 0, 0.299688,-0.00359353) , 
1, -0.512249, 1, 0, 0.250491,0.00495165)    );
  // itree = 1348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247478,0.01399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962025,-0.0232275) , 
0, 0.810159, 1, 0, 0.215728,0.00652578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.711864,0.0204986) , 
3, 1.65667, 1, 0, 0.258378,0.00929348)    );
  // itree = 1349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385176,0.00551657) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137888,-0.0132447) , 
3, -0.267162, 1, 0, 0.262899,0.00967124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140244,-0.0271595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228426,0.043064) , 
1, 0.447875, 1, 0, 0.188366,-0.0312092) , 
0, 1.07303, 1, 0, 0.249372,0.00225152)    );
  // itree = 1350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.084507,-0.0302478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271257,0.00177361) , 
2, -1.30736, 1, 0, 0.250133,0.000417284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371429,0.0297294) , 
1, 1.65151, 1, 0, 0.258527,-0.00350175)    );
  // itree = 1351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0591549,-0.00203638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377315,0.0112785) , 
1, -0.576444, 1, 0, 0.28466,0.0148643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184783,0.0222862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280899,0.00341998) , 
1, 0.289943, 1, 0, 0.256267,-0.0178688) , 
2, 0.505436, 1, 0, 0.274135,0.00273091)    );
  // itree = 1352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159639,0.00857747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373832,-0.041876) , 
1, -0.513925, 1, 0, 0.0790554,-0.00696463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.400524,0.0349945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441083,0.00516985) , 
2, 0.336812, 1, 0, 0.425743,0.0226361) , 
3, -0.097287, 1, 0, 0.255544,0.00810431)    );
  // itree = 1353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363395,-0.00150605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761589,-0.0187194) , 
1, 1.07456, 1, 0, 0.302861,0.00684033) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129477,0.0262378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.079096,-0.00378629) , 
2, 1.55186, 1, 0, 0.112963,-0.0229439) , 
2, 0.77689, 1, 0, 0.250887,-0.00131146)    );
  // itree = 1354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268676,0.00551238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0808949) , 
3, 0.287606, 1, 0, 0.212876,0.00428582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.371257,0.0421008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30711,0.00568503) , 
2, 0.584476, 1, 0, 0.328643,-0.0172833) , 
2, 0.098966, 1, 0, 0.271706,-0.006675)    );
  // itree = 1355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263838,0.00202719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30131,0.00224191) , 
3, 1.36253, 1, 0, 0.268464,0.00188242) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0283019,-0.064714) , 
2, 1.88154, 1, 0, 0.255482,-0.000754742)    );
  // itree = 1356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140657,-0.00809133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575163,0.0231437) , 
3, 0.158612, 1, 0, 0.279833,0.00645442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113433,-0.0438559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294821,0.0057476) , 
0, 0.40446, 1, 0, 0.191126,-0.0224768) , 
1, 1.14159, 1, 0, 0.254086,-0.00194265)    );
  // itree = 1357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.728395,0.0258314) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198347,-0.0124968) , 
1, -0.512723, 1, 0, 0.501767,-0.0258884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303462,-0.00997896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172104,0.00836738) , 
1, -0.147238, 1, 0, 0.209668,0.00151333) , 
2, -1.11469, 1, 0, 0.251,-0.00236402)    );
  // itree = 1358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233979,-0.00692139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424157,0.00164876) , 
2, 0.725636, 1, 0, 0.273852,0.00029562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707071,0.00309353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0931677,-0.0314368) , 
0, 1.20402, 1, 0, 0.0807799,0.026178) , 
3, 1.19852, 1, 0, 0.240156,0.00481277)    );
  // itree = 1359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.097561,-0.016192) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5664,0.0190941) , 
1, 0.939437, 1, 0, 0.255526,-0.00578929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278571,-0.00861833) , 
0, 1.47557, 1, 0, 0.257143,-0.00146991)    );
  // itree = 1360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0908033,-0.0021139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378571,0.0273186) , 
3, -0.217629, 1, 0, 0.204369,0.013372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33945,-0.0709433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324125,0.00253307) , 
1, 0.215914, 1, 0, 0.326687,-0.00943263) , 
2, 0.708843, 1, 0, 0.242878,0.00619259)    );
  // itree = 1361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32242,0.00246971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100917,0.00947502) , 
2, 0.812445, 1, 0, 0.269962,0.00105412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0880503,-0.0212142) , 
3, 1.73078, 1, 0, 0.2555,0.00436435)    );
  // itree = 1362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255396,0.000462267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0239551) , 
0, 1.34228, 1, 0, 0.239651,-0.00960015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436508,0.0326079) , 
2, 1.76296, 1, 0, 0.252294,-0.0124111)    );
  // itree = 1363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125945,-0.0119903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11007,-0.00340347) , 
2, -0.657336, 1, 0, 0.115108,0.00824059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.636752,0.0229352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.455645,0.00690427) , 
0, -0.200429, 1, 0, 0.513699,-0.0107061) , 
1, 0.879105, 1, 0, 0.261989,0.00125872)    );
  // itree = 1364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22626,0.00194513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24183,-0.0482238) , 
1, 1.52775, 1, 0, 0.227542,-0.00311361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528302,0.0406098) , 
0, 1.52075, 1, 0, 0.243766,0.00140419)    );
  // itree = 1365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332623,0.00121862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116327,0.00863229) , 
2, 0.66231, 1, 0, 0.276753,0.00136834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,0.0384426) , 
3, 1.73078, 1, 0, 0.266243,-0.00426991)    );
  // itree = 1366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20935,-0.00399367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278169,0.00660869) , 
1, -0.390145, 1, 0, 0.26046,-0.00105668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395161,0.0405133) , 
1, 1.65151, 1, 0, 0.268664,-0.00518338)    );
  // itree = 1367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0478088,0.0690358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267053,-0.00388809) , 
1, -0.967115, 1, 0, 0.236565,-0.000290237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350785,0.00619659) , 
0, 1.3861, 1, 0, 0.247495,0.00319136)    );
  // itree = 1368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,0.00955304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153098,-0.019879) , 
2, -0.282286, 1, 0, 0.16205,-0.00501305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283333,-0.0163017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.677812,0.0276045) , 
2, 0.427554, 1, 0, 0.572383,0.0329566) , 
3, 0.892407, 1, 0, 0.259377,0.00399295)    );
  // itree = 1369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.490196,-0.0214616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227841,-0.00570258) , 
3, -2.02012, 1, 0, 0.242213,0.000871535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140625,0.0360283) , 
3, 1.76021, 1, 0, 0.235678,-0.00240703)    );
  // itree = 1370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326055,-0.0115966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200669,-0.00199254) , 
1, 0.839382, 1, 0, 0.288032,0.00644093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173184,0.000158448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,-0.0145515) , 
1, 0.303859, 1, 0, 0.183384,-0.0191436) , 
0, 0.0715274, 1, 0, 0.235682,-0.00635781)    );
  // itree = 1371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.173601,-0.0137289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454139,0.0127078) , 
0, 0.687556, 1, 0, 0.241716,0.00452667) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165049,-0.0169164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268519,-0.0125931) , 
1, 1.22878, 1, 0, 0.218009,0.0566677) , 
3, 1.52344, 1, 0, 0.239279,0.00988816)    );
  // itree = 1372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108169,-0.0110732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410667,0.0171053) , 
3, 0.41387, 1, 0, 0.175015,-0.000826466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574324,-0.0417121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490196,0.00363698) , 
1, 1.24849, 1, 0, 0.531561,-0.0317597) , 
3, 1.29216, 1, 0, 0.228729,-0.00548658)    );
  // itree = 1373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315481,0.00574763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0168067,-0.0391413) , 
3, 1.08457, 1, 0, 0.288432,-0.0190367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224449,-0.00547264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113514,-0.00344669) , 
1, 1.20229, 1, 0, 0.194444,0.00739609) , 
0, 0.474519, 1, 0, 0.256256,-0.00998766)    );
  // itree = 1374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56,0.030983) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348214,-0.0148654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222096,-0.00716707) , 
0, -1.1709, 1, 0, 0.229657,-0.00175466) , 
3, -1.97217, 1, 0, 0.250376,-0.00399307)    );
  // itree = 1375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174658,-0.00567659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253147,0.0114298) , 
2, -0.919272, 1, 0, 0.230387,-0.00297356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179289,-0.0124112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396601,-0.00121358) , 
1, 1.22177, 1, 0, 0.256,0.0218177) , 
3, -0.097287, 1, 0, 0.243149,0.00937885)    );
  // itree = 1376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223881,-0.0048209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223729,0.0285141) , 
0, 0.854922, 1, 0, 0.223852,0.00160495) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295455,-0.0762753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318644,-0.0100293) , 
1, 0.744027, 1, 0, 0.311475,-0.0301017) , 
2, 1.04095, 1, 0, 0.242607,-0.00518138)    );
  // itree = 1377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374291,-0.00537466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110276,0.0029877) , 
1, 0.836753, 1, 0, 0.30199,0.00697504) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0709534,-0.0192179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141791,-0.000428646) , 
0, 1.31004, 1, 0, 0.0871795,-0.0256705) , 
2, 0.708843, 1, 0, 0.240451,-0.00237737)    );
  // itree = 1378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232227,-0.00550471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401235,0.000252645) , 
2, 1.45481, 1, 0, 0.247027,-0.0135025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.06,-0.0269727) , 
3, 1.90896, 1, 0, 0.237436,-0.0103628)    );
  // itree = 1379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0780308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247012,-0.000963992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329923,0.0267531) , 
3, 1.05359, 1, 0, 0.264101,-0.00446675) , 
0, -1.71246, 1, 0, 0.2505,-0.000937338)    );
  // itree = 1380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144737,-0.0410365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244866,0.0166145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279108,-0.00617114) , 
0, -0.30663, 1, 0, 0.267354,0.00087515) , 
1, -1.22512, 1, 0, 0.258016,-0.00263193)    );
  // itree = 1381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344156,-0.00447743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269764,0.0080393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0479273) , 
0, 1.13303, 1, 0, 0.237658,-0.00732732) , 
0, -1.37002, 1, 0, 0.246308,-0.00225382)    );
  // itree = 1382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305389,0.00884062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,-0.00766484) , 
0, -0.327102, 1, 0, 0.238806,-0.0402176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245516,-0.00754436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0594059,-0.0177293) , 
3, 1.94262, 1, 0, 0.234575,0.0102556) , 
1, -0.897857, 1, 0, 0.235146,0.00344455)    );
  // itree = 1383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20597,-0.0119815) , 
3, -1.9638, 1, 0, 0.176471,0.00846193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182232,0.00286485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378747,0.00214026) , 
1, 0.240541, 1, 0, 0.3052,-0.0160492) , 
0, -0.22297, 1, 0, 0.253708,-0.00624474)    );
  // itree = 1384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0441767,-0.0190987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.435714,0.0323966) , 
3, -1.1783, 1, 0, 0.251418,0.0204802) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227049,-0.00980029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275109,-0.0282849) , 
0, 1.30901, 1, 0, 0.234645,-0.0137043) , 
1, -0.319929, 1, 0, 0.23913,-0.00456193)    );
  // itree = 1385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286935,-0.00179515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,0.0426013) , 
3, 1.59734, 1, 0, 0.275429,0.00201097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0218713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0469519) , 
3, 1.38367, 1, 0, 0.0452675,0.0376506) , 
2, 1.40345, 1, 0, 0.247366,0.00635639)    );
  // itree = 1386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268939,-0.00627711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127119,0.00241959) , 
0, 0.0433204, 1, 0, 0.225131,-0.0366634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34347,0.0056366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104396,-0.0126356) , 
3, 0.68606, 1, 0, 0.265024,0.00719062) , 
1, -0.579326, 1, 0, 0.257576,-0.000997186)    );
  // itree = 1387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287145,0.00529916) , 
3, -2.02208, 1, 0, 0.271151,0.00548774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0615385,-0.0542945) , 
1, 1.65151, 1, 0, 0.257747,0.00120191)    );
  // itree = 1388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101362,-0.0171957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513333,0.0311146) , 
3, -0.191269, 1, 0, 0.229969,0.00544574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25711,-0.00906052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27907,-0.0444422) , 
2, 1.53332, 1, 0, 0.260704,-0.0166867) , 
0, 0.0546526, 1, 0, 0.246024,-0.00611547)    );
  // itree = 1389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.448276,-0.0449639) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240385,-0.00120839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0441176,-0.0485373) , 
3, 1.33934, 1, 0, 0.21281,0.00524716) , 
1, -1.18793, 1, 0, 0.229217,0.00992633)    );
  // itree = 1390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33425,0.00484262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267788,0.00749574) , 
0, -0.182027, 1, 0, 0.3,-0.0128683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0408163,-0.0105511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148936,0.0124212) , 
0, 0.163875, 1, 0, 0.124122,0.0263441) , 
3, 0.961447, 1, 0, 0.261028,-0.00417931)    );
  // itree = 1391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229454,-0.000607694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0196926) , 
3, 1.1391, 1, 0, 0.243305,0.00879974) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283582,0.0134791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220588,0.0125237) , 
1, 1.27045, 1, 0, 0.251852,-0.0158629) , 
2, 1.42243, 1, 0, 0.244444,0.0055114)    );
  // itree = 1392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226087,0.0567096) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225806,-0.0333515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255589,0.00292991) , 
1, -0.701515, 1, 0, 0.251708,-0.00215095) , 
1, -1.35223, 1, 0, 0.250248,0.00129052)    );
  // itree = 1393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354839,-0.0164747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286974,0.000751976) , 
3, -1.59093, 1, 0, 0.300236,0.00345542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152034,0.0165391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0657277,-0.0252853) , 
3, 1.50846, 1, 0, 0.125,-0.0115921) , 
3, 0.424493, 1, 0, 0.239097,-0.00179461)    );
  // itree = 1394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348008,-0.00291817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621118,-0.0189076) , 
3, 0.441796, 1, 0, 0.275862,0.00283065) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137767,0.0179215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.00290069) , 
2, 0.877626, 1, 0, 0.203938,-0.0205267) , 
1, 0.927816, 1, 0, 0.250126,-0.0055272)    );
  // itree = 1395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0111732,-0.00324897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13245,0.0093149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300671,0.00113503) , 
0, -0.788795, 1, 0, 0.272321,-0.000268883) , 
1, -1.12426, 1, 0, 0.248605,0.0024945)    );
  // itree = 1396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.018018,-0.0451505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312779,0.00826082) , 
3, -1.16154, 1, 0, 0.254318,0.00347911) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0272109,-0.0117018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390533,-0.0372532) , 
3, 1.08356, 1, 0, 0.221519,-0.0420353) , 
0, 1.17225, 1, 0, 0.249123,-0.00373018)    );
  // itree = 1397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26262,-0.0033806) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138408,-0.016467) , 
0, 0.984739, 1, 0, 0.243258,-0.0041886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284483,0.0483829) , 
0, 1.52075, 1, 0, 0.245685,-0.0097175)    );
  // itree = 1398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215649,-0.0109574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31,0.00146084) , 
2, 0.409177, 1, 0, 0.230769,0.0128904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2525,-0.00381699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178571,-0.0059166) , 
0, 1.49804, 1, 0, 0.246189,-0.0147988) , 
1, -0.128677, 1, 0, 0.241219,-0.00587416)    );
  // itree = 1399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172721,-0.00543731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437262,0.0139401) , 
0, 0.676581, 1, 0, 0.246933,-0.005401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.039725) , 
1, 1.5317, 1, 0, 0.241076,-0.000466868)    );
  // itree = 1400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282723,0.0218361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18069,-0.0276512) , 
0, -1.28458, 1, 0, 0.201965,-0.0151703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269539,0.0113135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376147,-0.0311307) , 
1, 1.65181, 1, 0, 0.280036,0.00398802) , 
0, -0.113851, 1, 0, 0.244686,-0.00468672)    );
  // itree = 1401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330579,0.00502266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136986,0.00665379) , 
3, 0.544367, 1, 0, 0.282646,-0.00646786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0571429,-0.0267795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.0217917) , 
2, 1.46561, 1, 0, 0.0772947,0.0334324) , 
3, 1.56271, 1, 0, 0.261134,-0.00228802)    );
  // itree = 1402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264448,0.00568813) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237557,-0.00148675) , 
1, -0.304512, 1, 0, 0.245651,0.00056295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42735,0.0237783) , 
2, 1.77577, 1, 0, 0.256207,0.00351968)    );
  // itree = 1403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16036,-0.0184154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352792,0.0055593) , 
0, 0.190775, 1, 0, 0.240253,0.00189551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211864,-0.0382837) , 
0, 1.52075, 1, 0, 0.238591,0.00472473)    );
  // itree = 1404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,0.0534309) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189908,-0.0114743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353448,0.0084782) , 
2, 0.381932, 1, 0, 0.259727,-0.00202549) , 
0, -1.53825, 1, 0, 0.260612,0.00166473)    );
  // itree = 1405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.393865,0.00426435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330144,0.0226331) , 
2, -0.142807, 1, 0, 0.380859,-0.00383472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161585,-0.0240959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0879865,-0.0110654) , 
2, 0.718076, 1, 0, 0.114255,0.0171959) , 
2, 0.182843, 1, 0, 0.254761,0.00611234)    );
  // itree = 1406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238235,0.00346089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282523,0.00634209) , 
1, -0.687172, 1, 0, 0.268847,0.0109744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234899,-0.0027003) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213573,-0.0056462) , 
0, -0.118555, 1, 0, 0.221527,-0.0100149) , 
1, 0.71227, 1, 0, 0.248947,0.00214788)    );
  // itree = 1407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268928,-0.001714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124224,0.0147658) , 
3, 1.67934, 1, 0, 0.256071,-0.000338111) , 
3, -1.91277, 1, 0, 0.238806,-0.00312133)    );
  // itree = 1408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136691,-0.0123839) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216216,-0.0486634) , 
0, -0.596685, 1, 0, 0.172,-0.0328529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276953,0.0138169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284024,-0.0277881) , 
1, 1.54809, 1, 0, 0.277648,0.00814404) , 
1, -0.917455, 1, 0, 0.264228,0.0029361)    );
  // itree = 1409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390935,-0.00894359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276068,0.00565857) , 
3, -1.15318, 1, 0, 0.305882,0.00279303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,-3.28524e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.00596229) , 
2, 1.30602, 1, 0, 0.093415,-0.0174898) , 
2, 0.690799, 1, 0, 0.23696,-0.00378654)    );
  // itree = 1410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111481,-0.0271426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337442,0.0100035) , 
2, -0.570484, 1, 0, 0.265929,-0.00126536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.088,0.0175275) , 
3, 1.87344, 1, 0, 0.254941,-0.00703928)    );
  // itree = 1411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038674,0.0481684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0914286,-0.00867469) , 
3, -1.1783, 1, 0, 0.0646067,0.0179784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0865538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331321,0.00962164) , 
0, -1.2692, 1, 0, 0.306832,-0.0105811) , 
1, -0.652328, 1, 0, 0.262971,-0.00540959)    );
  // itree = 1412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0162602,-0.041491) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364835,0.0262465) , 
3, -1.27608, 1, 0, 0.242511,0.0151002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139241,0.0432247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290161,-0.0135854) , 
2, -0.651101, 1, 0, 0.261152,-0.00563246) , 
0, -0.293879, 1, 0, 0.254395,0.00188234)    );
  // itree = 1413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515695,-0.00312362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390476,0.00414227) , 
1, -0.971078, 1, 0, 0.454965,0.0213745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264516,0.0120492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179941,0.00573565) , 
0, -0.920459, 1, 0, 0.188617,-0.0113944) , 
1, -0.469325, 1, 0, 0.247942,-0.00409556)    );
  // itree = 1414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29435,-0.00592993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108527,-0.0230218) , 
0, 0.511632, 1, 0, 0.247301,0.0188006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262172,-0.00110598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204929,-0.00776941) , 
0, -0.435358, 1, 0, 0.219653,-0.00200652) , 
1, 0.389371, 1, 0, 0.23335,0.00830094)    );
  // itree = 1415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0388889,0.0324445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103586,0.0209349) , 
3, -1.24704, 1, 0, 0.0765661,0.0186507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397004,0.00968306) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223577,-0.0115355) , 
2, 0.404467, 1, 0, 0.31384,-0.00656681) , 
1, -0.484715, 1, 0, 0.261929,-0.00104968)    );
  // itree = 1416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182037,0.00259483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695971,0.0342741) , 
3, 0.838384, 1, 0, 0.274342,0.0117969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0765306,-0.0516029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271186,-0.00704436) , 
0, -0.055588, 1, 0, 0.193483,-0.0251539) , 
1, 1.16801, 1, 0, 0.2546,0.00277509)    );
  // itree = 1417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00284059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312789,0.00601725) , 
0, -0.313714, 1, 0, 0.323331,-0.000470248) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894495,0.00494268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225694,0.026556) , 
0, 0.897465, 1, 0, 0.143646,-0.0264718) , 
3, 0.414913, 1, 0, 0.260088,-0.00962199)    );
  // itree = 1418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464865,0.00528522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241611,-0.0270063) , 
3, -1.61638, 1, 0, 0.365269,0.0177618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209476,0.00759287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236919,-0.000551283) , 
1, -0.269578, 1, 0, 0.230726,-0.00544429) , 
0, -0.940853, 1, 0, 0.252013,-0.00177265)    );
  // itree = 1419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136424,-0.0150675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349306,0.0147413) , 
0, -0.313714, 1, 0, 0.245478,-0.0032368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298969,-0.0255173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270758,0.00205262) , 
3, 1.38069, 1, 0, 0.282378,0.025043) , 
3, 0.873167, 1, 0, 0.254086,0.00336042)    );
  // itree = 1420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167431,0.0114636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780142,-0.0253142) , 
2, -0.629671, 1, 0, 0.112182,-0.00453688) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.500719,0.0201568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.431034,-0.0155699) , 
2, 1.43778, 1, 0, 0.486766,0.0197551) , 
3, 0.105894, 1, 0, 0.274129,0.00596546)    );
  // itree = 1421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.540541,-0.0214808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244604,0.0015468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101227,0.00828081) , 
3, 1.33621, 1, 0, 0.219407,-0.00353265) , 
1, -1.17379, 1, 0, 0.243135,0.00113113)    );
  // itree = 1422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242894,-0.00696611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34,-6.13518e-05) , 
1, -0.538548, 1, 0, 0.311892,-0.00591512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797267,-0.00804532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173913,-0.0133632) , 
1, 1.24878, 1, 0, 0.116084,0.0264659) , 
3, 0.436997, 1, 0, 0.243665,0.00536773)    );
  // itree = 1423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134446,-0.0254648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412892,0.00412462) , 
0, 0.593038, 1, 0, 0.227804,0.00123179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.644444,0.0225958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258278,0.0232987) , 
2, 0.897169, 1, 0, 0.440559,-0.0459826) , 
1, 1.4515, 1, 0, 0.258258,-0.00552663)    );
  // itree = 1424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250774,0.0378328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189041,-0.0134561) , 
1, -0.192813, 1, 0, 0.218023,0.0123625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202331,-0.0178536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.808,0.0244917) , 
3, 1.79152, 1, 0, 0.259427,-0.0118917) , 
0, -0.419895, 1, 0, 0.245283,-0.00360625)    );
  // itree = 1425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281946,0.00306148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654206,-0.0087513) , 
3, 1.32008, 1, 0, 0.269167,-0.000149848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00961538,-0.0606103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,0.00713955) , 
0, 1.17936, 1, 0, 0.0873786,0.0375167) , 
3, 1.63045, 1, 0, 0.250619,0.00369329)    );
  // itree = 1426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196783,-0.0164434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0760697) , 
3, 0.913747, 1, 0, 0.174497,-0.00969019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459459,0.00720608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15748,-0.00385559) , 
3, 0.786612, 1, 0, 0.325986,0.007321) , 
2, 0.322406, 1, 0, 0.238072,-0.00255112)    );
  // itree = 1427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0869868) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241266,0.00781635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298541,-0.00177522) , 
0, 0.193446, 1, 0, 0.269507,3.65077e-06) , 
0, -1.34233, 1, 0, 0.245217,-0.00398359)    );
  // itree = 1428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215108,-0.0013884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299419,-0.0304743) , 
2, 0.766077, 1, 0, 0.231834,-0.00789507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280374,0.0514788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350515,0.00121813) , 
0, 0.934794, 1, 0, 0.313726,0.0248616) , 
2, 1.5087, 1, 0, 0.240454,-0.004447)    );
  // itree = 1429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277596,0.00276942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178273,-0.00504496) , 
0, 0.982985, 1, 0, 0.25873,-0.0013518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677966,-0.0236954) , 
2, 1.77922, 1, 0, 0.24751,-0.00463667)    );
  // itree = 1430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135036,-0.0136064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405333,0.00888865) , 
2, -1.00266, 1, 0, 0.333008,-0.00352651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0774271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175786,-0.0080995) , 
2, -0.751061, 1, 0, 0.15519,0.021645) , 
3, -0.097287, 1, 0, 0.24637,0.00873783)    );
  // itree = 1431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0770292) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104449,-0.0180425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450736,0.00291831) , 
1, 0.566547, 1, 0, 0.263954,-0.00471086) , 
0, -1.69913, 1, 0, 0.249877,-0.000828685)    );
  // itree = 1432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0972222,0.0456089) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240214,-0.00951318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309179,0.028091) , 
2, 1.60665, 1, 0, 0.247755,-0.00462212) , 
2, -1.57429, 1, 0, 0.237113,-0.00240886)    );
  // itree = 1433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457661,-0.00835968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0218579,-0.0639796) , 
1, 0.518515, 1, 0, 0.340206,-0.0133109) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235043,-0.0218194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192903,0.0141673) , 
1, -0.339721, 1, 0, 0.2003,0.00845239) , 
3, -0.71985, 1, 0, 0.247515,0.00110783)    );
  // itree = 1434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251497,0.000418173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46988,0.000421488) , 
2, 0.712159, 1, 0, 0.2998,-0.00936094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.058642,-0.0131664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190244,0.0196044) , 
0, 1.19527, 1, 0, 0.109641,0.0157473) , 
3, 0.853537, 1, 0, 0.250246,-0.00281795)    );
  // itree = 1435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188235,0.0412835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259781,0.0205749) , 
2, -1.23866, 1, 0, 0.244747,-0.012844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,-0.0318377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288416,-0.00119336) , 
1, 0.0813332, 1, 0, 0.236475,0.00534) , 
3, -0.435343, 1, 0, 0.239898,-0.00218472)    );
  // itree = 1436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12931,-0.0476387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325397,-0.0212368) , 
2, -0.949172, 1, 0, 0.231405,-0.0347633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244058,0.00147185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434783,0.0223555) , 
0, 1.55441, 1, 0, 0.255978,0.00366089) , 
0, -1.08742, 1, 0, 0.253122,-0.000805318)    );
  // itree = 1437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340708,-0.0171056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277049,-0.0183644) , 
0, -1.04534, 1, 0, 0.294258,-0.0120035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237785,-0.011822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146054,-0.00243749) , 
1, 0.0813332, 1, 0, 0.170415,0.0144118) , 
3, -0.435343, 1, 0, 0.22239,0.00332583)    );
  // itree = 1438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281599,0.00233348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163793,-0.0194459) , 
0, 1.1677, 1, 0, 0.26746,0.000429579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0710059,0.00996744) , 
3, 1.77248, 1, 0, 0.251665,-0.00208008)    );
  // itree = 1439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.076275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0183486,-0.0599482) , 
3, -1.50707, 1, 0, 0.0075188,0.0301864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277116,-0.00412537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275641,-0.0123002) , 
0, 1.46025, 1, 0, 0.276985,-0.00951475) , 
0, -1.04167, 1, 0, 0.241448,-0.00427901)    );
  // itree = 1440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254888,0.00593034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865604,-0.0235976) , 
1, 1.14353, 1, 0, 0.214286,-0.000195425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650685,-0.0174504) , 
3, 1.71724, 1, 0, 0.246694,-0.00273135)    );
  // itree = 1441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385641,0.0123275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148649,-0.0206717) , 
2, 0.0515129, 1, 0, 0.283382,0.00630648) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0305344,-0.0198852) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123967,0.0129611) , 
0, 0.517206, 1, 0, 0.0911528,-0.0250681) , 
2, 1.18512, 1, 0, 0.249042,0.000701725)    );
  // itree = 1442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49505,0.0319038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210896,-0.00922705) , 
3, -2.04825, 1, 0, 0.253731,0.0207252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294185,0.00894508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184549,-0.00624306) , 
1, 1.26753, 1, 0, 0.256143,0.000818312) , 
1, -0.150587, 1, 0, 0.25534,0.00744406)    );
  // itree = 1443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239745,0.00626338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00230421) , 
3, 0.0948215, 1, 0, 0.277928,-0.00184516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758309) , 
3, 2.02035, 1, 0, 0.263427,0.00344967)    );
  // itree = 1444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216557,-0.00206046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279188,-0.0481965) , 
2, 1.24584, 1, 0, 0.223176,-0.00716938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.439024,0.0406742) , 
2, 1.7595, 1, 0, 0.236537,-0.00311174)    );
  // itree = 1445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348444,-0.0031947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111773,-0.00682826) , 
2, 0.357823, 1, 0, 0.260022,-0.0018486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106383,-0.0209777) , 
1, 1.55041, 1, 0, 0.248838,0.00174788)    );
  // itree = 1446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230572,0.000292183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243506,-0.0122215) , 
2, 1.01801, 1, 0, 0.232708,-0.00355255) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.419847,0.0157272) , 
2, 1.79378, 1, 0, 0.24499,-0.00724051)    );
  // itree = 1447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.069378,0.00847254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105477,-0.00916156) , 
3, -0.833228, 1, 0, 0.0889133,0.00264007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451306,0.0353946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350415,-0.000655637) , 
0, -0.100011, 1, 0, 0.387577,-0.0175842) , 
1, 0.227361, 1, 0, 0.255112,-0.00861424)    );
  // itree = 1448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00826446,-0.0741455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122449,-0.019093) , 
2, -1.7054, 1, 0, 0.0788644,-0.0267055) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245501,0.00755933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.679688,-0.0329442) , 
3, 1.81632, 1, 0, 0.278504,0.00219219) , 
2, -1.10319, 1, 0, 0.246877,-0.0023858)    );
  // itree = 1449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307208,0.000902641) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132911,-0.0195722) , 
3, 0.674122, 1, 0, 0.289855,-0.00235324) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0288462,-0.0406111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107362,-0.00347619) , 
2, 0.336812, 1, 0, 0.0883721,0.0159186) , 
3, 0.948814, 1, 0, 0.246901,0.00154208)    );
  // itree = 1450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262783,-0.000566851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251142,-0.0105516) , 
1, 1.46055, 1, 0, 0.261338,-0.00530286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155405,-0.0155038) , 
0, 1.42175, 1, 0, 0.253138,-0.00188606)    );
  // itree = 1451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225947,-0.0113521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.424658,0.0198229) , 
2, 1.28378, 1, 0, 0.249727,-0.0104107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186869,-0.0136106) , 
3, 1.61709, 1, 0, 0.24359,-0.00365165)    );
  // itree = 1452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0581867,-0.0156617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841122,-0.0594392) , 
3, -0.570561, 1, 0, 0.0614657,-0.0127801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.331725,0.0145116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,-0.00935962) , 
3, 1.13881, 1, 0, 0.382278,0.00654376) , 
3, -0.404141, 1, 0, 0.248646,-0.00150547)    );
  // itree = 1453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464752,0.0131853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00808465) , 
0, -0.699965, 1, 0, 0.378114,-0.00654461) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104012,-0.00890404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147208,-0.00387491) , 
0, 1.18216, 1, 0, 0.113793,0.0145647) , 
2, 0.324939, 1, 0, 0.262788,0.00266555)    );
  // itree = 1454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440367,-0.0010033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249577,0.000460408) , 
3, -2.06324, 1, 0, 0.260616,0.00638475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0421691) , 
0, 1.55414, 1, 0, 0.25998,0.00326658)    );
  // itree = 1455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0764862) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262355,-0.000513036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241509,-0.0110433) , 
3, 0.801649, 1, 0, 0.256558,-0.000712845) , 
0, -1.58783, 1, 0, 0.242319,-0.00283093)    );
  // itree = 1456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.057047,-0.0194614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356322,0.014201) , 
3, -0.78374, 1, 0, 0.257993,0.00811543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308725,-0.0366562) , 
1, 1.56335, 1, 0, 0.261844,0.00351344)    );
  // itree = 1457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.480263,-0.0173298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291417,-0.00852549) , 
3, -1.84777, 1, 0, 0.316291,0.0107625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106529,-0.0101542) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109091,0.0148868) , 
3, 0.895411, 1, 0, 0.107456,-0.0156431) , 
1, 0.606857, 1, 0, 0.224105,-0.000893786)    );
  // itree = 1458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33251,0.0068264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137391,-0.00370436) , 
3, 0.395576, 1, 0, 0.269832,0.00384959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0891089,0.0290562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0782609,-0.00659813) , 
3, 1.87802, 1, 0, 0.0833333,-0.0318988) , 
3, 1.63045, 1, 0, 0.249751,3.07888e-07)    );
  // itree = 1459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104558,-0.000112298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.606362,0.00965406) , 
1, 0.77313, 1, 0, 0.260173,-0.00640403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202247,-0.0264129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324201,0.0204015) , 
2, 1.45951, 1, 0, 0.269521,0.0121918) , 
2, 1.0149, 1, 0, 0.262011,-0.00274749)    );
  // itree = 1460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251634,-0.00450824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185065,-0.0331079) , 
0, 1.04529, 1, 0, 0.238251,-0.00988833) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0289855,-0.0475414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34058,0.0327154) , 
2, 0.612441, 1, 0, 0.207039,0.0139922) , 
1, 1.26505, 1, 0, 0.230769,-0.00416412)    );
  // itree = 1461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311304,0.00438367) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,0.0549322) , 
3, 1.06212, 1, 0, 0.289705,-0.00991535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191153,-0.00870063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138462,-0.0316109) , 
0, 1.47317, 1, 0, 0.182176,0.0152799) , 
0, 0.428962, 1, 0, 0.249008,-0.000379663)    );
  // itree = 1462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305632,0.0103081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212121,-0.00524815) , 
1, 1.2364, 1, 0, 0.285637,-0.000353074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813397,-0.0113929) , 
3, 1.64517, 1, 0, 0.26492,0.00471569)    );
  // itree = 1463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161025,-0.00716651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361225,-0.00873295) , 
0, 0.343988, 1, 0, 0.222994,-0.00874234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.652542,0.0396746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726496,-0.0291462) , 
2, 0.697743, 1, 0, 0.267045,0.0139949) , 
3, 1.21569, 1, 0, 0.231008,-0.00460616)    );
  // itree = 1464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154726,-0.00546857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542299,0.0147566) , 
3, 0.672289, 1, 0, 0.255499,0.00315079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292994,-0.0326943) , 
0, 1.43206, 1, 0, 0.258549,-0.00129768)    );
  // itree = 1465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316579,0.000405247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120141,0.00460156) , 
3, 0.529955, 1, 0, 0.258031,-0.00818803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583333,-0.0339989) , 
2, 1.79731, 1, 0, 0.246161,-0.00564404)    );
  // itree = 1466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349693,0.00249843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121951,0.00196309) , 
3, -1.33122, 1, 0, 0.235474,-0.0263769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.115183,0.00801461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27058,-0.0027583) , 
2, -0.92671, 1, 0, 0.251889,-0.000724003) , 
1, -0.768694, 1, 0, 0.249086,-0.00510442)    );
  // itree = 1467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229399,0.0287734) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234211,-0.0113711) , 
3, -1.02601, 1, 0, 0.232851,0.00957183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31962,0.0180373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.101272) , 
2, 1.87256, 1, 0, 0.239336,-0.0232346) , 
2, 1.0496, 1, 0, 0.234212,0.00268754)    );
  // itree = 1468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0190217,-0.034894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231678,0.0195629) , 
3, -1.30899, 1, 0, 0.183873,0.0108153) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328205,-0.0516059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.781818,0.0109974) , 
3, 1.89115, 1, 0, 0.491803,-0.0557095) , 
3, 1.30934, 1, 0, 0.232235,0.000367236)    );
  // itree = 1469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543689,0.015846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0255593) , 
3, -0.512539, 1, 0, 0.410367,-0.0246933) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20786,-0.00997678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0960187,0.00523988) , 
1, 1.2057, 1, 0, 0.177481,0.0027481) , 
2, -0.755418, 1, 0, 0.230467,-0.00349534)    );
  // itree = 1470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293701,0.00030989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245714,0.00469449) , 
0, 0.505827, 1, 0, 0.279666,0.00459744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,0.0131119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.09,-0.0363023) , 
1, 1.36663, 1, 0, 0.0585366,0.0493072) , 
3, 1.64517, 1, 0, 0.257,0.00918019)    );
  // itree = 1471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00214133,-0.0693796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.533445,0.00733701) , 
1, 0.757817, 1, 0, 0.20953,0.00870777) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479853,0.0222926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281915,-0.0444218) , 
1, 0.827478, 1, 0, 0.399132,-0.0208783) , 
0, 0.893748, 1, 0, 0.253387,0.00186422)    );
  // itree = 1472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190041,-0.000828123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.414286,0.0637792) , 
2, 0.476716, 1, 0, 0.213383,0.00586971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239686,-0.0262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.813725,0.0183976) , 
3, 1.91542, 1, 0, 0.335516,-0.0179494) , 
2, 0.684444, 1, 0, 0.251534,-0.00157073)    );
  // itree = 1473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401869,-0.00884512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262357,0.00792041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0634921,-0.0322878) , 
3, 1.87074, 1, 0, 0.249619,-0.0077003) , 
0, -1.71246, 1, 0, 0.257473,-0.00280751)    );
  // itree = 1474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30492,0.00225913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0390625,-0.0242187) , 
3, 0.780555, 1, 0, 0.249042,0.00150016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362903,0.0121532) , 
2, 1.76296, 1, 0, 0.256279,0.00571052)    );
  // itree = 1475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927948,-0.00713402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448732,0.0129826) , 
1, 0.313429, 1, 0, 0.269885,-0.00906258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240506,0.00403744) , 
2, 1.68391, 1, 0, 0.267542,-0.00595839)    );
  // itree = 1476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104803,-0.03175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231725,0.00202996) , 
2, -0.731473, 1, 0, 0.19989,-0.00479345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.574074,0.0243762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.850467,0.0376032) , 
3, 1.92042, 1, 0, 0.711628,0.057432) , 
3, 1.61278, 1, 0, 0.253797,0.00176142)    );
  // itree = 1477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297954,0.00182274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101562,0.00888662) , 
3, 1.01335, 1, 0, 0.283097,-0.00269604) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828025,-0.00739151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0882353,-0.00573709) , 
3, 1.74846, 1, 0, 0.0853242,0.0481581) , 
3, 1.30934, 1, 0, 0.253904,0.00481039)    );
  // itree = 1478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.0413473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22475,-0.000878211) , 
0, -1.42158, 1, 0, 0.233693,0.007495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433962,0.0425235) , 
1, 1.7097, 1, 0, 0.244033,0.00418822)    );
  // itree = 1479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143617,0.00502139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336266,0.00733462) , 
0, -0.458926, 1, 0, 0.267801,-0.00247403) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.457746,0.0151426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.029703,-0.0656739) , 
2, 0.991384, 1, 0, 0.206395,0.0369505) , 
3, 1.29216, 1, 0, 0.256862,0.0045493)    );
  // itree = 1480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227273,0.0444876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295918,0.052985) , 
1, -0.459504, 1, 0, 0.259615,0.0492188) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227387,-0.00444843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358333,-0.0370998) , 
0, 1.53192, 1, 0, 0.236565,-0.00770831) , 
0, -1.16507, 1, 0, 0.239063,-0.0015412)    );
  // itree = 1481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263123,-0.00972883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193146,-0.000195203) , 
0, 0.972367, 1, 0, 0.250949,-0.00801437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112676,0.0303287) , 
3, 1.75738, 1, 0, 0.241067,-0.0118118)    );
  // itree = 1482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294631,0.00286969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0173913,-0.0539092) , 
3, 1.41815, 1, 0, 0.274766,0.000272186) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139535,-0.0146126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141361,-0.0109087) , 
0, 1.39829, 1, 0, 0.140496,-0.0224523) , 
0, 1.04529, 1, 0, 0.25,-0.00391937)    );
  // itree = 1483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.0214151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510638,0.0346067) , 
3, 0.633839, 1, 0, 0.244412,0.0046622) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385827,0.0103771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0883392,-0.0412385) , 
3, 0.796332, 1, 0, 0.22905,0.0394581) , 
2, 0.823591, 1, 0, 0.240125,0.0143739)    );
  // itree = 1484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169972,0.0326905) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124733,-0.0173259) , 
2, -0.853629, 1, 0, 0.137103,-0.000789902) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397059,-0.0517797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459813,-0.00624724) , 
0, -0.122912, 1, 0, 0.447094,-0.0255808) , 
3, 0.518766, 1, 0, 0.243119,-0.00926834)    );
  // itree = 1485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419922,-0.0130373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196681,0.00265417) , 
1, -0.37681, 1, 0, 0.26325,-0.0043516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.0233647) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113475,0.0149794) , 
2, 1.77886, 1, 0, 0.0842912,0.0249526) , 
2, 1.41921, 1, 0, 0.239636,-0.000484864)    );
  // itree = 1486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377581,0.00265887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238816,0.000685823) , 
0, -0.824269, 1, 0, 0.265067,-0.00204924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0827586,-0.00763955) , 
3, 1.73078, 1, 0, 0.25142,0.000565263)    );
  // itree = 1487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.0875814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0929739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261835,-0.00521455) , 
0, -1.11185, 1, 0, 0.243743,-0.00626579) , 
3, -1.82503, 1, 0, 0.234107,-0.00845768)    );
  // itree = 1488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220275,0.033693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.394495,-0.0346951) , 
3, 0.63463, 1, 0, 0.241189,0.0181363) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293333,-0.0275172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291908,0.014092) , 
1, 0.269773, 1, 0, 0.292469,-0.0032248) , 
0, -0.075678, 1, 0, 0.269756,0.0062366)    );
  // itree = 1489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270154,0.00171173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176678,0.0166256) , 
0, 1.1677, 1, 0, 0.256289,-0.000500694) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150442,0.000716521) , 
1, 1.67061, 1, 0, 0.250371,0.00251855)    );
  // itree = 1490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179245,-0.0039518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319691,0.00371405) , 
1, -1.02391, 1, 0, 0.299934,0.00461474) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0313726,-0.0542432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113281,-0.00565377) , 
0, 0.843946, 1, 0, 0.072407,-0.0290162) , 
3, 0.832675, 1, 0, 0.242319,-0.00390133)    );
  // itree = 1491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535714,0.00517948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,-0.0162271) , 
3, -0.987872, 1, 0, 0.0841996,0.0170129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434543,0.00986604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145985,0.00264084) , 
2, 1.70437, 1, 0, 0.39675,-0.0112942) , 
1, 0.310824, 1, 0, 0.247012,0.00226727)    );
  // itree = 1492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197668,0.00501944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.571429,-0.0349275) , 
3, 1.43959, 1, 0, 0.237226,-0.00195845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375691,0.0196562) , 
0, 1.44542, 1, 0, 0.249166,0.000805782)    );
  // itree = 1493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513793,0.00922437) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210668,0.00176262) , 
1, -0.754602, 1, 0, 0.260305,-0.00345533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,0.0209793) , 
2, 1.77922, 1, 0, 0.25053,-0.00820227)    );
  // itree = 1494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416393,0.0089515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132768,-0.0267212) , 
3, -0.49035, 1, 0, 0.312241,0.00939726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153226,-0.00117336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234354,0.00193106) , 
1, -0.183049, 1, 0, 0.214214,-0.0128401) , 
0, -0.0702116, 1, 0, 0.262354,-0.00191967)    );
  // itree = 1495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205761,-0.045828) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270852,0.00477173) , 
1, -0.958684, 1, 0, 0.226068,-0.00651061) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347709,-0.00641716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134426,-0.0206686) , 
2, 0.889391, 1, 0, 0.251479,0.0107646) , 
3, 0.422986, 1, 0, 0.234513,-0.000769207)    );
  // itree = 1496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185785,-0.0050528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42029,0.0472781) , 
2, 0.610442, 1, 0, 0.206543,0.00117063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213793,-0.0612553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373684,-0.00965814) , 
0, 0.0617895, 1, 0, 0.329524,-0.0263082) , 
2, 0.823591, 1, 0, 0.237524,-0.00575182)    );
  // itree = 1497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267563,-0.00102963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150215,-0.00957288) , 
0, 1.15465, 1, 0, 0.252941,0.00360959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.08,-0.020559) , 
3, 2.00929, 1, 0, 0.244162,0.00656908)    );
  // itree = 1498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209375,-0.0244907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145455,0.0200295) , 
0, 0.25, 1, 0, 0.193023,-0.0176952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299807,0.00197088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238325,0.0198398) , 
1, 1.08228, 1, 0, 0.276737,0.00280072) , 
1, -0.579326, 1, 0, 0.259472,-0.00142625)    );
  // itree = 1499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237586,-0.0153225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173228,-0.00604597) , 
2, 0.51295, 1, 0, 0.231894,0.0138147) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219219,0.0165817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301887,-0.00432114) , 
1, 1.23475, 1, 0, 0.251376,-0.00845808) , 
2, 0.714721, 1, 0, 0.237254,0.00768716)    );
  // itree = 1500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233546,0.00536714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111562,-0.0252376) , 
0, 0.653609, 1, 0, 0.201994,-0.00202915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.615385,-0.0368954) , 
3, 1.75738, 1, 0, 0.230844,-0.00633709)    );
  // itree = 1501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00286633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29266,0.00122016) , 
3, -1.85556, 1, 0, 0.316145,-0.000417489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154822,0.0216713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110795,0.00659082) , 
2, 0.861698, 1, 0, 0.134048,-0.0212989) , 
3, 0.366892, 1, 0, 0.245723,-0.00849295)    );
  // itree = 1502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215517,-0.00404561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329243,-0.00328329) , 
2, 0.687627, 1, 0, 0.245082,0.00105357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0146279) , 
1, 1.67676, 1, 0, 0.249874,0.00601499)    );
  // itree = 1503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179856,0.0203881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280749,0.0401451) , 
2, -1.23866, 1, 0, 0.253411,-0.0100782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230971,-0.00961408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26935,-0.00784112) , 
0, 0.397691, 1, 0, 0.24858,0.00960031) , 
3, -0.961157, 1, 0, 0.24987,0.00434519)    );
  // itree = 1504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288235,0.0305955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260163,-0.0134197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256144,0.00781405) , 
1, 0.240902, 1, 0, 0.257795,-0.00114872) , 
1, -1.19679, 1, 0, 0.260427,0.00211656)    );
  // itree = 1505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.545455,0.00476876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272229,0.00234265) , 
3, -2.19416, 1, 0, 0.287766,0.00111492) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00806452,-0.0651331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145631,0.0273869) , 
3, 1.06715, 1, 0, 0.0704846,-0.0325458) , 
2, 1.45481, 1, 0, 0.262703,-0.0027677)    );
  // itree = 1506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200913,-0.0061585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325758,0.0152869) , 
2, 0.0462821, 1, 0, 0.229825,0.0140873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18429,0.0019052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310096,-0.00327163) , 
2, 0.277797, 1, 0, 0.254351,-0.00692254) , 
1, -0.392457, 1, 0, 0.247578,-0.0011204)    );
  // itree = 1507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165154,-0.00326671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25692,-0.00787106) , 
0, -0.525105, 1, 0, 0.227299,-0.00705946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647059,0.0151791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183673,-0.0014763) , 
3, 1.32678, 1, 0, 0.437788,0.0276454) , 
0, 1.32355, 1, 0, 0.25104,-0.00314524)    );
  // itree = 1508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116,0.00363805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.420168,-0.0467652) , 
3, -0.748137, 1, 0, 0.214092,-0.0222062) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185944,-0.00376489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592105,0.0138981) , 
3, 1.29583, 1, 0, 0.25988,0.00251012) , 
1, -0.71469, 1, 0, 0.251594,-0.00196283)    );
  // itree = 1509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345833,-0.0224729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434713,0.0193534) , 
0, -0.884998, 1, 0, 0.410138,-0.0114883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105584,-0.0184202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189655,0.0231716) , 
0, 1.33696, 1, 0, 0.114441,0.01253) , 
1, 0.204761, 1, 0, 0.244794,0.00194196)    );
  // itree = 1510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.419847,-0.0102394) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373057,0.0205067) , 
3, -2.01747, 1, 0, 0.391975,-0.0165321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108333,-0.0180286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2334,-0.0042547) , 
1, -0.917455, 1, 0, 0.224084,0.0125576) , 
3, -1.36119, 1, 0, 0.252196,0.00768679)    );
  // itree = 1511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0456432,0.0247746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0983264,-0.0163222) , 
3, -1.28005, 1, 0, 0.0806676,0.0220517) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302198,0.00823269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35534,0.00239192) , 
0, -0.71519, 1, 0, 0.34736,-0.0047108) , 
1, -0.0744646, 1, 0, 0.248058,0.00525411)    );
  // itree = 1512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259259,0.0271028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234003,-0.00411203) , 
1, -1.08398, 1, 0, 0.23668,-0.000788676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288344,-0.0451457) , 
2, 1.66799, 1, 0, 0.241007,-0.00521577)    );
  // itree = 1513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387692,0.00277821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163063,-0.00572992) , 
2, -0.361538, 1, 0, 0.246023,-0.00436512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149533,-0.00993977) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894309,-0.0376331) , 
3, 1.37284, 1, 0, 0.117391,0.0499584) , 
0, 1.34228, 1, 0, 0.231156,0.00191348)    );
  // itree = 1514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282173,0.000608228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0120482,-0.0680269) , 
3, 0.2559, 1, 0, 0.205601,0.000270401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352542,0.00565809) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311615,-0.0093346) , 
2, 1.19349, 1, 0, 0.330247,-0.0227261) , 
2, 0.688794, 1, 0, 0.243845,-0.00678534)    );
  // itree = 1515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249686,0.00474947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429864,0.0186178) , 
3, 1.01278, 1, 0, 0.271625,0.000393239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191257,-0.00566883) , 
3, 1.63045, 1, 0, 0.264264,0.00512741)    );
  // itree = 1516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12749,0.0212452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.034081) , 
2, -1.00072, 1, 0, 0.07034,-0.00569918) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.563291,0.0335879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262295,-0.000661156) , 
1, 0.57708, 1, 0, 0.3869,0.0176697) , 
3, -0.404141, 1, 0, 0.251752,0.00769289)    );
  // itree = 1517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.653465,-0.0181458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466019,0.0153283) , 
2, -1.28575, 1, 0, 0.558824,-0.03839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212868,-0.00779107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.00638318) , 
3, 1.8644, 1, 0, 0.205702,0.00812277) , 
1, -1.04302, 1, 0, 0.241846,0.0033618)    );
  // itree = 1518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294436,0.00634239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159836,-0.000702161) , 
1, 1.0791, 1, 0, 0.257576,0.00129292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33758,-0.00304757) , 
2, 1.68744, 1, 0, 0.264054,0.00548556)    );
  // itree = 1519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0889713) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110661,-0.0103364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392213,0.000962206) , 
1, 0.227361, 1, 0, 0.27592,-8.47214e-05) , 
0, -1.39419, 1, 0, 0.253586,-0.00471706)    );
  // itree = 1520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0415607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175919,0.000105655) , 
1, -1.13409, 1, 0, 0.185353,0.00429447) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413793,-0.048318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.562016,0.00346306) , 
0, 0.553824, 1, 0, 0.508685,-0.0232593) , 
3, 1.05247, 1, 0, 0.252312,-0.00141168)    );
  // itree = 1521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335938,0.00133168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100985,0.00260616) , 
2, 0.643333, 1, 0, 0.279359,-0.00875905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,0.0112142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0935961,-0.00633524) , 
2, 0.885767, 1, 0, 0.0873239,0.0437609) , 
3, 1.3043, 1, 0, 0.245958,0.000375975)    );
  // itree = 1522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.433962,-0.0107448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390476,0.0143649) , 
3, -1.7469, 1, 0, 0.412322,0.037083) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304536,-0.00166233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158637,0.0126797) , 
3, 0.192175, 1, 0, 0.234665,-0.0049631) , 
0, -1.11841, 1, 0, 0.253521,-0.000500455)    );
  // itree = 1523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174746,0.0039787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20098,-0.0164705) , 
0, -0.0919192, 1, 0, 0.179652,0.0105006) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378272,0.0129768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0835773) , 
3, 1.89087, 1, 0, 0.331803,-0.0280294) , 
0, 0.226627, 1, 0, 0.247197,-0.0066042)    );
  // itree = 1524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160839,-0.00589996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479798,-0.0184322) , 
3, 0.761495, 1, 0, 0.230011,-0.0104111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.405556,0.0264139) , 
1, 1.55041, 1, 0, 0.245763,-0.00573766)    );
  // itree = 1525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.379162,0.0105596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161464,-0.00214639) , 
3, -0.204472, 1, 0, 0.27043,0.0002781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0576923,-0.0281783) , 
2, 1.77922, 1, 0, 0.259165,-0.00227647)    );
  // itree = 1526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321703,0.00676016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219917,0.0150466) , 
0, 0.984226, 1, 0, 0.307049,-0.00777128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0347222,-0.042296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118919,-0.0239568) , 
0, 1.03994, 1, 0, 0.0820669,0.0407321) , 
3, 1.24456, 1, 0, 0.270095,0.000195582)    );
  // itree = 1527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204209,-0.00524633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317324,0.00817608) , 
3, 0.496394, 1, 0, 0.23955,-0.0018774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279503,-0.00963438) , 
0, 1.44874, 1, 0, 0.242723,-0.00518817)    );
  // itree = 1528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242424,0.0292187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152866,-0.0178954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548851,0.00930006) , 
3, 1.04902, 1, 0, 0.231119,-0.00778738) , 
0, -1.37002, 1, 0, 0.232087,-0.0042901)    );
  // itree = 1529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351421,0.00514388) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2506,0.00994189) , 
0, -0.810277, 1, 0, 0.27445,0.00145549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159184,-0.0100009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191358,0.0244631) , 
1, 0.76635, 1, 0, 0.17199,-0.0244171) , 
0, 1.07303, 1, 0, 0.254038,-0.00369876)    );
  // itree = 1530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253713,-0.00795365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0815153) , 
3, 1.31412, 1, 0, 0.225771,-0.00196164) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396396,0.00594016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295238,-0.00140551) , 
0, 0.934794, 1, 0, 0.347222,-0.0424739) , 
2, 1.5087, 1, 0, 0.238681,-0.00626807)    );
  // itree = 1531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0893366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289186,0.00889396) , 
0, -1.29891, 1, 0, 0.258134,-0.00153426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156977,0.0460927) , 
3, 1.74551, 1, 0, 0.249504,-0.00536075)    );
  // itree = 1532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107383,0.0149017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0518053,-0.0286411) , 
2, -1.2949, 1, 0, 0.062341,-0.0077959) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335793,0.0625663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.400424,0.00595029) , 
2, -0.219633, 1, 0, 0.386008,0.0205394) , 
3, -0.462334, 1, 0, 0.258871,0.00940922)    );
  // itree = 1533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3804,0.00884812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164384,0.00506208) , 
2, 0.0193387, 1, 0, 0.276712,-0.00625348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0585366,-0.0257712) , 
2, 1.53077, 1, 0, 0.25468,-0.00109241)    );
  // itree = 1534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281145,-0.00150152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195683,-0.00240463) , 
1, 0.754333, 1, 0, 0.249602,0.010077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386139,0.0225613) , 
1, 1.67676, 1, 0, 0.256552,0.00739397)    );
  // itree = 1535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.104628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239006,-0.00858206) , 
1, -1.11252, 1, 0, 0.203252,-0.0110231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.8,0.0678186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157191,-0.0270204) , 
2, -0.13309, 1, 0, 0.282638,0.0321524) , 
3, 0.414913, 1, 0, 0.233147,0.00523611)    );
  // itree = 1536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209948,-0.00975274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.640719,0.0189617) , 
3, 1.51791, 1, 0, 0.24789,-0.00505216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342105,-0.0268742) , 
0, 1.52075, 1, 0, 0.253234,-0.00739322)    );
  // itree = 1537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.00544543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271236,-0.00763459) , 
0, -0.982659, 1, 0, 0.293313,-0.00394195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0438596,-0.0216408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148984,-0.00583037) , 
0, 0.441152, 1, 0, 0.113264,0.0248802) , 
3, 0.525776, 1, 0, 0.232511,0.00579114)    );
  // itree = 1538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26476,-0.00122642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128964,-0.0161157) , 
1, 0.70809, 1, 0, 0.223507,-0.000822993) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.471042,0.00263305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143713,-0.00282763) , 
3, 1.31285, 1, 0, 0.342723,-0.0343593) , 
2, 1.01972, 1, 0, 0.249117,-0.00802746)    );
  // itree = 1539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244945,0.00343402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383495,0.0230384) , 
2, 1.36291, 1, 0, 0.25968,-0.0088498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,-0.0336397) , 
0, 1.52075, 1, 0, 0.252801,-0.00644431)    );
  // itree = 1540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23029,0.0265007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0854569) , 
1, 0.636139, 1, 0, 0.17236,0.0132914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300766,-0.0313849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289911,0.0135174) , 
1, 0.42178, 1, 0, 0.294253,-0.0038169) , 
2, -0.394071, 1, 0, 0.253976,0.00183611)    );
  // itree = 1541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.507194,0.00966845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,-0.0639425) , 
0, 0.126711, 1, 0, 0.425693,0.0220513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243827,0.0096323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0668693,-0.0114434) , 
2, 1.18953, 1, 0, 0.208,-0.00555461) , 
1, -0.579326, 1, 0, 0.250742,-0.00013447)    );
  // itree = 1542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354296,0.00539506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185022,0.00788364) , 
3, 0.124315, 1, 0, 0.290608,0.00509144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0509554,-0.0166727) , 
3, 1.68426, 1, 0, 0.271479,-0.000542471)    );
  // itree = 1543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142438,-0.0134028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365854,0.0223208) , 
3, -0.0439355, 1, 0, 0.201726,0.0103531) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366082,0.0109052) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115385,0.000748125) , 
3, 1.68156, 1, 0, 0.327399,-0.0124245) , 
0, -0.00477115, 1, 0, 0.267286,-0.00152937)    );
  // itree = 1544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0178042,-0.0433101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276282,0.00992311) , 
3, -1.2831, 1, 0, 0.230364,0.00540312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.902913,0.0487577) , 
3, 2.01752, 1, 0, 0.265,0.00933337)    );
  // itree = 1545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.514599,0.00192031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219355,0.00958121) , 
1, -0.709224, 1, 0, 0.278882,0.00389097) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202041,-0.00297337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108911,-0.00799351) , 
2, 1.74663, 1, 0, 0.186125,-0.0244496) , 
0, 0.676581, 1, 0, 0.250769,-0.00469841)    );
  // itree = 1546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245455,-0.0273323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46729,0.000311411) , 
1, -0.715188, 1, 0, 0.354839,0.0551883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295694,-0.00654102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137976,0.00295009) , 
3, 0.381995, 1, 0, 0.229236,-0.0157655) , 
0, -1.11837, 1, 0, 0.242709,-0.00815457)    );
  // itree = 1547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273622,-0.00503172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231725,-0.0109753) , 
2, -0.635384, 1, 0, 0.24307,0.00389416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192661,-0.0016949) , 
0, 1.52075, 1, 0, 0.240302,0.00118234)    );
  // itree = 1548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21063,-0.00688181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546763,-0.0323531) , 
3, 1.4084, 1, 0, 0.238725,-0.00931496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0108688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675862,0.0281057) , 
3, 1.3968, 1, 0, 0.332308,0.0232127) , 
0, 1.17201, 1, 0, 0.254024,-0.00399731)    );
  // itree = 1549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383701,-0.00390616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294627,-0.000758124) , 
0, -0.0968335, 1, 0, 0.339623,0.00810912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121622,0.0242254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132246,0.00940644) , 
0, -0.133691, 1, 0, 0.128538,-0.016629) , 
1, 0.634693, 1, 0, 0.250745,-0.00230692)    );
  // itree = 1550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255348,-0.00293321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287478,0.00468499) , 
1, -0.00759721, 1, 0, 0.274708,0.00290036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0457516,-0.0545521) , 
3, 1.71142, 1, 0, 0.257494,-0.00201334)    );
  // itree = 1551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214646,-0.00144426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371875,0.00557189) , 
2, 0.721834, 1, 0, 0.248011,-0.00430874) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.621795,0.0290196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0856164,-0.0380035) , 
2, 0.68264, 1, 0, 0.272321,0.0418927) , 
3, 0.934112, 1, 0, 0.253579,0.00627317)    );
  // itree = 1552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191876,0.00805493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.627907,0.0202148) , 
3, 0.793509, 1, 0, 0.281893,0.0118479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0747331,-0.0485305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242857,0.00184541) , 
0, 0.257319, 1, 0, 0.158645,-0.0164907) , 
1, 1.2054, 1, 0, 0.247647,0.00397371)    );
  // itree = 1553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293444,-0.00927334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226626,0.00944808) , 
0, -0.0571561, 1, 0, 0.25964,-0.00349214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163462,-0.0214972) , 
0, 1.54569, 1, 0, 0.254758,-0.000417827)    );
  // itree = 1554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310023,-0.00482673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214984,0.0136679) , 
0, -0.178224, 1, 0, 0.284979,0.0085216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134615,-0.00828877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32526,0.0140268) , 
2, 0.949885, 1, 0, 0.202719,-0.0125817) , 
0, 0.23336, 1, 0, 0.251266,-0.00012711)    );
  // itree = 1555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00649351,-0.00822527) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0763889,-0.0144167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303448,0.00254095) , 
0, -0.872949, 1, 0, 0.26872,-0.000991663) , 
1, -1.26491, 1, 0, 0.248895,-0.00357869)    );
  // itree = 1556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195422,-0.00628768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568807,0.051085) , 
3, 1.43614, 1, 0, 0.216842,0.000207432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.630435,-0.0350399) , 
3, 1.76021, 1, 0, 0.244848,-0.00409855)    );
  // itree = 1557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374745,0.00122062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230978,0.0038418) , 
0, 0.761572, 1, 0, 0.335556,0.00540699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0794979,-0.00613501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158798,0.019489) , 
0, 0.593225, 1, 0, 0.105485,-0.0216578) , 
1, 0.939437, 1, 0, 0.256186,-0.00392977)    );
  // itree = 1558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440678,0.0115683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175805,-0.00952011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310769,-0.00174259) , 
2, 0.620804, 1, 0, 0.224569,0.0055009) , 
3, -1.75726, 1, 0, 0.243927,0.00236742)    );
  // itree = 1559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156863,-0.00656871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429245,0.0125886) , 
0, 0.138838, 1, 0, 0.246321,0.00612951) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.543478,0.0599928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2393,-0.00891821) , 
0, 0.0509573, 1, 0, 0.303681,-0.0283828) , 
3, 0.523655, 1, 0, 0.265569,-0.00545158)    );
  // itree = 1560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.101542,0.00114956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503254,0.0207951) , 
3, -0.242713, 1, 0, 0.251009,0.0117206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.123333,-0.0375683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.703226,0.00878715) , 
3, 1.59947, 1, 0, 0.242384,-0.022794) , 
0, 0.353094, 1, 0, 0.247743,-0.00134783)    );
  // itree = 1561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.647059,0.00455837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398693,0.00699158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16716,-0.0020023) , 
1, -0.259297, 1, 0, 0.225842,0.00190666) , 
1, -1.34521, 1, 0, 0.248301,0.00407456)    );
  // itree = 1562
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423077,0.0204399) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317204,0.000143035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224417,5.2257e-05) , 
0, -0.941517, 1, 0, 0.23371,0.00727631) , 
3, -1.7782, 1, 0, 0.252784,0.00350348)    );
  // itree = 1563
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00574713,0.103858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0658683,-0.047832) , 
3, -1.61628, 1, 0, 0.0351906,0.0276535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314223,0.00288121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271505,0.00456207) , 
3, 1.10049, 1, 0, 0.305143,-0.000641283) , 
0, -0.940853, 1, 0, 0.261119,0.00397303)    );
  // itree = 1564
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,0.0399526) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2375,-0.00813389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367232,0.0248414) , 
1, 1.54222, 1, 0, 0.249865,-0.00297605) , 
1, -1.31444, 1, 0, 0.24924,-5.06316e-05)    );
  // itree = 1565
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298701,0.00567001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135,-0.0246592) , 
0, 1.1649, 1, 0, 0.279885,0.00325558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0196078,-0.0516482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.083871,-0.00449288) , 
1, 1.1684, 1, 0, 0.0583658,-0.0242658) , 
2, 1.42243, 1, 0, 0.251377,-0.000286231)    );
  // itree = 1566
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21142,-0.0148771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.021645,-0.0110511) , 
3, -0.0362322, 1, 0, 0.161547,-0.0151727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305202,0.0116719) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341085,-0.00872752) , 
2, 1.47824, 1, 0, 0.313446,0.0140242) , 
2, -0.0267985, 1, 0, 0.246753,0.00120494)    );
  // itree = 1567
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125257,-0.0248606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313743,0.00568022) , 
0, -0.595941, 1, 0, 0.256121,-0.00430309) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357955,-0.0220695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0649351,0.0132614) , 
2, 1.21277, 1, 0, 0.221212,0.0372689) , 
3, 1.21569, 1, 0, 0.25013,0.00283096)    );
  // itree = 1568
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227082,-0.0147937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276334,0.00621582) , 
0, 0.353094, 1, 0, 0.245833,-0.00540173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.0292699) , 
1, 1.65805, 1, 0, 0.251473,-0.00801816)    );
  // itree = 1569
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374613,-0.00553613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223214,0.0166825) , 
3, -0.759503, 1, 0, 0.275293,-0.0169988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210227,0.0100154) , 
0, 1.44542, 1, 0, 0.269718,-0.0137161)    );
  // itree = 1570
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208968,0.000362861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344,0.00806943) , 
2, 0.502296, 1, 0, 0.221882,0.00234705) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422619,0.0321835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255814,-0.00898703) , 
1, 1.16927, 1, 0, 0.343799,-0.017317) , 
2, 0.70608, 1, 0, 0.261831,-0.00409637)    );
  // itree = 1571
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248765,-0.00105466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285124,0.0082484) , 
3, 1.20855, 1, 0, 0.253491,0.00312811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104,-0.0244035) , 
2, 1.79779, 1, 0, 0.244087,-0.00218551)    );
  // itree = 1572
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146965,0.00497419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0299401,-0.0804873) , 
1, -0.0305584, 1, 0, 0.10625,-0.00840126) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249822,0.0115073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.861111,0.042033) , 
3, 1.8426, 1, 0, 0.293457,0.0158539) , 
2, -0.755418, 1, 0, 0.248369,0.0100122)    );
  // itree = 1573
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279123,0.00149249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0636364,-0.0263972) , 
3, 1.36727, 1, 0, 0.266269,-0.0018173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107345,0.0175225) , 
3, 1.69879, 1, 0, 0.25235,-0.00857223)    );
  // itree = 1574
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326967,0.00379015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108607,-0.0184942) , 
3, 0.566396, 1, 0, 0.267668,0.010108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0717949,-0.0125727) , 
3, 1.61709, 1, 0, 0.248494,0.00623988)    );
  // itree = 1575
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300917,-0.00232502) , 
3, -1.96974, 1, 0, 0.272879,0.0102284) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214844,-0.00246885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270195,0.00487967) , 
2, 1.18674, 1, 0, 0.237658,-0.0139845) , 
2, 0.332, 1, 0, 0.25808,5.50371e-05)    );
  // itree = 1576
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235412,-0.000661519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54386,-0.0474497) , 
3, 1.54501, 1, 0, 0.257321,-0.00597892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0888031,0.00264275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601852,0.0513659) , 
3, 1.37466, 1, 0, 0.239782,0.0278663) , 
1, 1.35807, 1, 0, 0.254057,0.000319857)    );
  // itree = 1577
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.735849,0.0382783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246622,-0.0288331) , 
2, -1.4503, 1, 0, 0.375622,-0.0127204) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235515,-0.00339722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730897,-0.00377574) , 
2, 1.31596, 1, 0, 0.205521,0.0175623) , 
3, -1.17518, 1, 0, 0.239173,0.0115713)    );
  // itree = 1578
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296654,0.00229984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107843,0.031409) , 
3, 0.988059, 1, 0, 0.285024,0.00852863) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0301205,-0.0137362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145455,-0.00152817) , 
0, 1.03994, 1, 0, 0.0876133,-0.0505017) , 
3, 1.29216, 1, 0, 0.252139,-0.00130481)    );
  // itree = 1579
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275676,0.0249009) , 
3, -2.11366, 1, 0, 0.231118,-0.0105001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2277,-0.0102902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295019,0.00691263) , 
0, 0.650501, 1, 0, 0.253275,0.00632806) , 
3, -0.789658, 1, 0, 0.246071,0.000856428)    );
  // itree = 1580
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291139,0.00486779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175141,-0.0432933) , 
1, 0.556996, 1, 0, 0.263014,-0.0052038) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.040625,-0.00718493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.428016,0.0296648) , 
3, 0.791652, 1, 0, 0.213172,0.0222401) , 
1, 1.16801, 1, 0, 0.248895,0.00256996)    );
  // itree = 1581
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372549,0.00653382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275633,0.00809255) , 
0, -1.32017, 1, 0, 0.286251,-0.00364229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691489,-0.0121888) , 
3, 1.63045, 1, 0, 0.266341,-0.0007634)    );
  // itree = 1582
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344681,0.00312169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271091,0.00437603) , 
0, -0.313714, 1, 0, 0.303639,0.000306408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.048951,0.00781916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159468,0.023829) , 
0, 0.453012, 1, 0, 0.123874,-0.0349425) , 
3, 0.934112, 1, 0, 0.264475,-0.00737294)    );
  // itree = 1583
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376712,0.0672963) , 
0, -1.30513, 1, 0, 0.20073,-0.028963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110872,-0.00871901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.433294,-0.00575622) , 
1, 0.619684, 1, 0, 0.26464,0.00832361) , 
3, -1.55126, 1, 0, 0.256098,0.00333994)    );
  // itree = 1584
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194673,0.00431917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604839,0.0419027) , 
3, 1.44225, 1, 0, 0.224574,0.00896374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701754,-0.0131099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.557522,-0.0487262) , 
3, 1.31712, 1, 0, 0.312775,-0.0463013) , 
2, 1.41921, 1, 0, 0.234958,0.00245692)    );
  // itree = 1585
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352342,-0.00725917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155906,-0.00322725) , 
3, 0.0743685, 1, 0, 0.275201,0.016272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.023622,-0.0288531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0895522,-0.00789271) , 
0, 0.264704, 1, 0, 0.0683544,-0.0131548) , 
2, 1.17109, 1, 0, 0.234592,0.0104949)    );
  // itree = 1586
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329897,0.000670532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0710383,-0.0189881) , 
3, 0.422166, 1, 0, 0.246935,0.00764593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.0275198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162791,-0.00933938) , 
3, 1.09126, 1, 0, 0.268482,-0.0297014) , 
1, 1.47236, 1, 0, 0.249746,0.00277372)    );
  // itree = 1587
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584192,-0.00682883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375862,0.0136696) , 
1, -0.15064, 1, 0, 0.248623,-1.49432e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349099,-0.000119739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0762962) , 
3, 1.91877, 1, 0, 0.283883,0.0258709) , 
3, 0.766583, 1, 0, 0.258258,0.00705898)    );
  // itree = 1588
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0165289,-0.0576467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242594,-0.00371067) , 
3, -2.02208, 1, 0, 0.228272,-0.00549486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387387,-0.0392823) , 
1, 1.7097, 1, 0, 0.237011,-0.008933)    );
  // itree = 1589
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291457,-0.00144968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0918367,-0.0016283) , 
3, 1.0283, 1, 0, 0.269575,0.00288615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.05,-0.021795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146789,0.027468) , 
1, 1.22071, 1, 0, 0.100478,-0.0501651) , 
3, 1.64517, 1, 0, 0.251878,-0.00266604)    );
  // itree = 1590
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312253,0.00440163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,-0.0074241) , 
3, -0.694628, 1, 0, 0.247956,-0.0286421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264822,-3.34084e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237229,-0.00190708) , 
1, 0.143049, 1, 0, 0.245635,-0.00521913) , 
1, -0.71469, 1, 0, 0.246055,-0.0094579)    );
  // itree = 1591
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240183,-0.00270931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371429,0.0198967) , 
3, 1.08185, 1, 0, 0.262615,0.00201502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,0.0166381) , 
2, 1.77922, 1, 0, 0.256646,-0.000969079)    );
  // itree = 1592
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.014754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154066,-0.0214268) , 
0, 0.201494, 1, 0, 0.21207,0.000757793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.695906,0.0191977) , 
3, 1.64517, 1, 0, 0.25463,0.00369005)    );
  // itree = 1593
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348302,-0.00124069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241739,0.000831315) , 
3, -0.234742, 1, 0, 0.307124,0.00350928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0597826,0.0281176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.14,0.00592746) , 
0, 0.552777, 1, 0, 0.109504,-0.0287993) , 
3, 0.853537, 1, 0, 0.258621,-0.00442041)    );
  // itree = 1594
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30398,-0.00258184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0181818,-0.0681807) , 
3, 1.08457, 1, 0, 0.279628,-0.00980378) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225869,0.00706775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0863636,-0.0165577) , 
3, 1.37269, 1, 0, 0.184282,0.0139861) , 
0, 0.42569, 1, 0, 0.244948,-0.00115078)    );
  // itree = 1595
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016129,-0.0153108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703125,0.075854) , 
2, -1.11797, 1, 0, 0.0436508,-0.0396127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0393258,0.0417361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291454,-0.0060678) , 
0, -1.04167, 1, 0, 0.26575,0.00210568) , 
1, -0.943262, 1, 0, 0.237738,-0.0031561)    );
  // itree = 1596
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171875,-0.00941203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0285714,-0.091502) , 
0, 0.73447, 1, 0, 0.14978,-0.0173191) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133005,-0.00175616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.604701,0.0106762) , 
3, 0.759316, 1, 0, 0.305469,0.00621314) , 
2, -0.394071, 1, 0, 0.251402,-0.00195894)    );
  // itree = 1597
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325097,-0.000760595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0977918,-0.00268959) , 
3, 0.729342, 1, 0, 0.280397,0.00954763) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0825688,0.0831604) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.091954,-0.00512851) , 
0, 0.134849, 1, 0, 0.0891892,-0.0268575) , 
2, 1.04395, 1, 0, 0.244702,0.00275152)    );
  // itree = 1598
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22138,-0.00526842) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392453,0.0067451) , 
2, 0.624991, 1, 0, 0.270416,-0.00408618) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0373832,0.0457565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0747664,-0.0377014) , 
1, 1.32536, 1, 0, 0.0560748,-0.0554364) , 
3, 1.62085, 1, 0, 0.248182,-0.00941287)    );
  // itree = 1599
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.023166,0.00614913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283828,-0.00628017) , 
0, -1.01584, 1, 0, 0.245772,0.00153809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367089,0.0725224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22449,-0.00795224) , 
1, 1.28102, 1, 0, 0.298361,-0.0468864) , 
3, 1.36188, 1, 0, 0.253487,-0.00556603)    );
  // itree = 1600
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12963,-0.0344167) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0478395,-0.0198106) , 
1, -1.32889, 1, 0, 0.0595238,-0.012883) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325758,0.0477087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.3918,-0.000465866) , 
2, -0.200279, 1, 0, 0.376532,0.00984207) , 
3, -0.502231, 1, 0, 0.250263,0.000790336)    );
  // itree = 1601
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273367,-0.00729475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,-0.00250039) , 
0, 0.0264293, 1, 0, 0.256535,0.0172516) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141732,-0.0175279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201681,0.0224988) , 
1, 0.85611, 1, 0, 0.160858,-0.0203131) , 
0, 1.07303, 1, 0, 0.23885,0.0103082)    );
  // itree = 1602
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380645,-0.00109022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249842,0.00459456) , 
0, -0.871305, 1, 0, 0.271285,-0.00366611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0268319) , 
3, 1.94262, 1, 0, 0.25963,-0.000841891)    );
  // itree = 1603
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107438,0.0339492) , 
3, -1.59545, 1, 0, 0.0555556,0.0467216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237454,0.0112501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296493,-0.00800003) , 
0, 0.125775, 1, 0, 0.269056,-0.00753973) , 
1, -0.95459, 1, 0, 0.243976,-0.00116566)    );
  // itree = 1604
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213115,0.0498237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249303,-0.00595291) , 
0, -1.66831, 1, 0, 0.246997,-0.00214132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.367925,-0.0457181) , 
0, 1.52075, 1, 0, 0.25334,-0.00589727)    );
  // itree = 1605
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494949,0.0120961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179487,-0.00905184) , 
1, -0.106805, 1, 0, 0.377778,-0.0321057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298293,0.00374555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828283,-0.0100502) , 
3, 0.797722, 1, 0, 0.231965,0.00429308) , 
0, -0.920459, 1, 0, 0.25585,-0.00166929)    );
  // itree = 1606
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250873,-0.00681711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.0393829) , 
0, 1.27798, 1, 0, 0.240043,0.000144472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207547,0.0246988) , 
0, 1.54569, 1, 0, 0.238289,-0.00383157)    );
  // itree = 1607
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262769,-0.0019772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306358,0.00141066) , 
3, 1.52423, 1, 0, 0.266963,0.00781361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707965,-0.0398707) , 
2, 1.77922, 1, 0, 0.255364,0.00297091)    );
  // itree = 1608
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263441,0.0512878) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.145266,-0.00658666) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338933,0.0101732) , 
2, 0.0672606, 1, 0, 0.255188,0.00412779) , 
0, -1.2692, 1, 0, 0.255967,0.00815116)    );
  // itree = 1609
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294501,0.0020322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258929,0.0113655) , 
0, 0.572991, 1, 0, 0.287544,-0.0129905) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.00919975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169811,0.00234448) , 
0, 1.37684, 1, 0, 0.155063,0.0148238) , 
0, 1.17225, 1, 0, 0.266962,-0.00866934)    );
  // itree = 1610
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285091,0.00179582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291262,-0.0198407) , 
3, 0.777645, 1, 0, 0.238124,0.0081828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396226,-0.0137132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180723,0.0145642) , 
3, 1.28552, 1, 0, 0.301587,-0.0339499) , 
2, 1.16615, 1, 0, 0.249758,0.000459155)    );
  // itree = 1611
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170191,-0.00709829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17094,-0.0464139) , 
0, 0.0110066, 1, 0, 0.170334,0.010192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268293,0.00382236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373913,0.011042) , 
1, -0.47763, 1, 0, 0.357934,-0.0148677) , 
0, 0.349172, 1, 0, 0.245098,0.00020501)    );
  // itree = 1612
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0291545,-0.0181638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345455,0.0218468) , 
3, -1.25079, 1, 0, 0.275596,0.0168849) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222997,-0.0352164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365079,0.00612427) , 
0, 1.39879, 1, 0, 0.279412,-0.0211999) , 
0, 0.896613, 1, 0, 0.276491,0.0079503)    );
  // itree = 1613
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603774,0.00171543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39895,-0.0124385) , 
3, -1.97622, 1, 0, 0.443532,0.0290616) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207063,0.00912499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547264,-0.0225761) , 
2, 1.46036, 1, 0, 0.185902,0.00151922) , 
1, -0.392457, 1, 0, 0.250776,0.00845466)    );
  // itree = 1614
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384106,0.0273793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963855,-0.0225341) , 
3, -1.34839, 1, 0, 0.233438,-0.0443628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235826,0.00668747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362256,0.0122862) , 
2, 0.950298, 1, 0, 0.27056,0.00513811) , 
1, -0.791059, 1, 0, 0.264662,-0.00272745)    );
  // itree = 1615
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0811922,-0.0176188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483607,0.0203328) , 
1, 0.383535, 1, 0, 0.253959,-0.00899797) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.477012,0.0220968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730337,-0.0358291) , 
3, 1.10743, 1, 0, 0.272727,0.0237108) , 
2, 1.20206, 1, 0, 0.257171,-0.00340075)    );
  // itree = 1616
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184874,-0.0364351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216,0.00723997) , 
0, -1.05854, 1, 0, 0.211738,0.000245137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.661538,-0.0283281) , 
3, 1.74551, 1, 0, 0.243041,-0.0033541)    );
  // itree = 1617
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.597122,0.0195862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238806,-0.00542415) , 
3, -1.97613, 1, 0, 0.266262,0.00839611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109375,-0.0125895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0211961) , 
2, 1.18061, 1, 0, 0.125506,-0.0366141) , 
1, 1.49547, 1, 0, 0.249393,0.00300188)    );
  // itree = 1618
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220842,-0.00233041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40404,0.0289472) , 
2, 0.867221, 1, 0, 0.232558,0.00198664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316832,-0.0131796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290221,-0.00157846) , 
0, 0.0685437, 1, 0, 0.296651,-0.0193042) , 
2, 1.06219, 1, 0, 0.246185,-0.0025401)    );
  // itree = 1619
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188755,0.0460138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192926,-0.000126828) , 
2, -0.946297, 1, 0, 0.191734,0.0149935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348421,0.00713472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0571429,-0.0439046) , 
3, 1.7703, 1, 0, 0.311009,-0.00977667) , 
0, -0.0968335, 1, 0, 0.258032,0.00122526)    );
  // itree = 1620
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224427,-0.00174753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326316,0.0417523) , 
2, 1.25448, 1, 0, 0.235164,0.00282079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243243,-0.046077) , 
2, 1.77577, 1, 0, 0.235632,-0.000843352)    );
  // itree = 1621
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297354,-0.00541284) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.08,-0.0355748) , 
2, 0.824293, 1, 0, 0.283203,0.0144641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0622568,-0.0118033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0816327,-0.00249377) , 
1, 1.28776, 1, 0, 0.0706402,-0.0191727) , 
2, 1.0466, 1, 0, 0.234791,0.00680321)    );
  // itree = 1622
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326376,-0.0128898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280822,0.00660749) , 
0, -0.556642, 1, 0, 0.29632,0.00431197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0812973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137584,-0.00697601) , 
2, 0.731596, 1, 0, 0.0843621,-0.0195133) , 
3, 0.873167, 1, 0, 0.2457,-0.001378)    );
  // itree = 1623
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191469,-0.000276743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335274,0.00472303) , 
0, 0.124523, 1, 0, 0.256008,-0.00408959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0172414,-0.0716876) , 
1, 1.65151, 1, 0, 0.242365,-0.00819422)    );
  // itree = 1624
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134259,0.0380067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,-0.0187937) , 
2, -1.19505, 1, 0, 0.103382,-0.00245906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351171,0.0405701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.456908,0.00622435) , 
2, 0.0999935, 1, 0, 0.426214,0.0198082) , 
3, -0.0727496, 1, 0, 0.264407,0.00864759)    );
  // itree = 1625
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557047,0.0186442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251017,0.000164788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0971429,-0.000769936) , 
3, 1.67449, 1, 0, 0.236814,0.00288082) , 
3, -1.91277, 1, 0, 0.260147,7.98822e-05)    );
  // itree = 1626
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314241,-0.00190494) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189553,-0.00949359) , 
0, -0.419895, 1, 0, 0.233497,0.00630195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448529,0.0475882) , 
1, 1.63248, 1, 0, 0.248349,0.00323793)    );
  // itree = 1627
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584416,0.0793635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00775194,-0.0717418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289598,0.00525385) , 
0, -1.14127, 1, 0, 0.269632,0.0041489) , 
3, -1.82503, 1, 0, 0.253165,0.00157241)    );
  // itree = 1628
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109091,0.0653345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196733,-0.00634212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588235,0.0115425) , 
3, 1.04553, 1, 0, 0.287507,0.00131926) , 
2, -1.47397, 1, 0, 0.272773,0.00438599)    );
  // itree = 1629
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511628,0.00445457) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305769,0.00526491) , 
3, -1.42401, 1, 0, 0.346687,0.0090759) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116883,0.00452504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0819277,-0.00703259) , 
2, 0.598975, 1, 0, 0.0968188,-0.00795999) , 
1, 0.879105, 1, 0, 0.257298,0.00298142)    );
  // itree = 1630
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233743,-0.000786969) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284314,-0.0114376) , 
2, 1.40345, 1, 0, 0.239142,0.00251327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239316,0.00801462) , 
0, 1.49754, 1, 0, 0.239152,-0.000377604)    );
  // itree = 1631
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193959,-0.00750017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.585987,0.035536) , 
3, 1.01104, 1, 0, 0.237456,-0.00381486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381081,0.0195589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.092,-0.0300799) , 
3, 1.08579, 1, 0, 0.264516,0.020481) , 
2, 0.68168, 1, 0, 0.2457,0.00358732)    );
  // itree = 1632
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232143,0.00353062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188811,0.0580919) , 
1, 1.3237, 1, 0, 0.225029,0.0112164) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233945,-0.0456099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279043,-0.00149867) , 
1, -0.224086, 1, 0, 0.270073,-0.0104431) , 
0, -0.113851, 1, 0, 0.250127,-0.000852141)    );
  // itree = 1633
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00182774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0900901,-0.0557307) , 
2, 0.283278, 1, 0, 0.432392,0.0136681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18797,0.00803699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156107,0.00274108) , 
0, -0.54731, 1, 0, 0.162362,-0.00862581) , 
1, -0.141858, 1, 0, 0.251972,-0.00122749)    );
  // itree = 1634
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276471,0.0137062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0148148,-0.0641966) , 
3, -1.34853, 1, 0, 0.115909,-0.0282244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366899,0.00662928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963597,-0.0167854) , 
3, 0.765816, 1, 0, 0.280952,0.0131945) , 
2, -0.755418, 1, 0, 0.242932,0.00365296)    );
  // itree = 1635
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751443) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261154,-0.00495188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267281,0.0313856) , 
3, 1.59535, 1, 0, 0.261855,0.00501686) , 
3, -2.04064, 1, 0, 0.246161,0.00245558)    );
  // itree = 1636
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184307,0.00587029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641304,0.0423966) , 
3, 0.0252697, 1, 0, 0.29918,0.0197535) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180312,-0.00924418) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572864,-0.0205378) , 
3, 1.65392, 1, 0, 0.244082,-0.0125518) , 
1, -0.0220085, 1, 0, 0.264691,-0.000468257)    );
  // itree = 1637
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42132,-0.0109141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.351967,0.0043555) , 
0, -0.407171, 1, 0, 0.383124,0.00610452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320261,0.0673844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119601,-0.0028311) , 
1, 0.522092, 1, 0, 0.148674,-0.0113468) , 
1, 0.240541, 1, 0, 0.255044,-0.00342916)    );
  // itree = 1638
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423656,0.0199308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139847,-0.0075889) , 
3, -0.663668, 1, 0, 0.273556,0.0096237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298592,-0.00899468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178512,0.00844488) , 
3, 0.0298939, 1, 0, 0.222917,-0.012652) , 
1, 0.389371, 1, 0, 0.248588,-0.0013597)    );
  // itree = 1639
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23715,-0.00158892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40796,-0.00270292) , 
0, 1.32355, 1, 0, 0.255097,0.00074628) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00990099,-0.078494) , 
1, 1.67456, 1, 0, 0.2428,0.00308373)    );
  // itree = 1640
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281775,0.00991626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215152,-0.0132992) , 
1, 0.240541, 1, 0, 0.245614,-0.00203455) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.453782,0.0315948) , 
0, 1.52075, 1, 0, 0.258363,0.00128185)    );
  // itree = 1641
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30914,-0.0137421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260031,-0.00169048) , 
0, -0.808981, 1, 0, 0.270983,0.00177502) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.038835,0.0317387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178138,0.0485754) , 
0, 0.594413, 1, 0, 0.137143,-0.0564389) , 
3, 1.26976, 1, 0, 0.24777,-0.00832155)    );
  // itree = 1642
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,0.00160796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197452,-0.00564776) , 
1, 0.786452, 1, 0, 0.343915,-0.024206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22982,0.00480039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167959,-0.0183945) , 
1, 1.29989, 1, 0, 0.213194,0.000651732) , 
0, -0.571715, 1, 0, 0.250125,-0.00637087)    );
  // itree = 1643
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253529,0.00877579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.334802,-0.0218087) , 
3, 1.13037, 1, 0, 0.263103,0.00508561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,0.0890624) , 
3, 1.76021, 1, 0, 0.257831,-0.00115074)    );
  // itree = 1644
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19839,0.000310471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.49537,-0.0251778) , 
3, 1.38893, 1, 0, 0.231202,-0.00442145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.490446,0.0280712) , 
0, 1.52075, 1, 0, 0.250473,-0.000462275)    );
  // itree = 1645
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598684,0.0251096) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33234,-0.0110864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141228,-0.00371869) , 
1, 0.0671948, 1, 0, 0.212038,0.0141316) , 
1, -1.22512, 1, 0, 0.241977,0.00986501)    );
  // itree = 1646
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258957,-0.0036163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116279,-0.0127444) , 
0, 1.13453, 1, 0, 0.239048,0.00548078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233945,0.00986192) , 
1, 1.49547, 1, 0, 0.23851,0.00110491)    );
  // itree = 1647
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204643,-0.0076063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359012,0.00898476) , 
0, 0.524523, 1, 0, 0.262021,0.00866673) , 
3, -2.16403, 1, 0, 0.248082,0.00540624)    );
  // itree = 1648
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182659,-0.00719025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36036,-0.0476571) , 
3, 1.32008, 1, 0, 0.193373,-0.0109074) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708738,0.0254295) , 
3, 1.63045, 1, 0, 0.245237,-0.00516065)    );
  // itree = 1649
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497462,0.00840786) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394118,-0.000641524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186109,0.00616091) , 
1, -0.426967, 1, 0, 0.224904,0.0103453) , 
3, -1.74385, 1, 0, 0.251485,0.00671983)    );
  // itree = 1650
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275362,-0.00386883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.485714,0.02561) , 
2, -0.485057, 1, 0, 0.346154,-0.0138669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195122,-0.032006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21648,-0.00531021) , 
0, -0.865908, 1, 0, 0.214791,0.0153502) , 
3, -1.16568, 1, 0, 0.242516,0.00918362)    );
  // itree = 1651
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28324,0.0123661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373134,-0.00987493) , 
1, 1.52775, 1, 0, 0.289501,0.00405264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15748,0.00435095) , 
2, 1.76296, 1, 0, 0.281326,0.00150405)    );
  // itree = 1652
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167388,0.00672373) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111898,-0.0199667) , 
2, -0.203737, 1, 0, 0.139385,-0.0030886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.0485497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58891,0.0215061) , 
2, -0.217026, 1, 0, 0.503165,0.0241218) , 
3, 0.576261, 1, 0, 0.252585,0.00537865)    );
  // itree = 1653
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314725,-0.011613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103876,-0.00595107) , 
3, 0.321408, 1, 0, 0.242424,0.0128291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219512,0.0142205) , 
0, 1.52075, 1, 0, 0.241018,0.00836388)    );
  // itree = 1654
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319413,-0.00278866) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296435,0.0122962) , 
0, 0.0357757, 1, 0, 0.310782,0.00241084) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0176991,-0.0595273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123552,0.0131345) , 
0, -0.134719, 1, 0, 0.104596,-0.0254306) , 
3, 0.611124, 1, 0, 0.247317,-0.0061589)    );
  // itree = 1655
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0142349,-0.0885163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274611,0.00247534) , 
1, -0.868191, 1, 0, 0.215891,-0.0112021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417284,-0.00430784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155488,-0.000533078) , 
2, 0.886178, 1, 0, 0.300136,0.0210744) , 
3, 0.440469, 1, 0, 0.247094,0.000752768)    );
  // itree = 1656
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00581395,-0.0732246) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181255,0.0110382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.482692,-0.00645483) , 
3, 0.766893, 1, 0, 0.267808,0.00310673) , 
3, -1.82503, 1, 0, 0.245083,-0.000769994)    );
  // itree = 1657
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.511628,0.00299548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331939,0.00749545) , 
3, -1.60413, 1, 0, 0.373391,0.00636805) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163017,0.00016707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111969,0.00458063) , 
3, 1.2116, 1, 0, 0.150786,-0.0189217) , 
2, -0.00474452, 1, 0, 0.25385,-0.00721279)    );
  // itree = 1658
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16129,-0.0173539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265823,-0.00147533) , 
1, -1.26816, 1, 0, 0.229917,-0.0374413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291793,2.70489e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108197,0.0138639) , 
3, 1.24456, 1, 0, 0.257249,-0.00714895) , 
1, -0.695692, 1, 0, 0.25227,-0.0126664)    );
  // itree = 1659
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252247,-0.00126691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27381,-0.0322443) , 
3, 1.17405, 1, 0, 0.254219,-0.0014751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225275,0.0428577) , 
3, 1.68512, 1, 0, 0.25161,-0.00588017)    );
  // itree = 1660
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242647,0.0337674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231579,0.00101464) , 
1, -1.31625, 1, 0, 0.232677,0.00473877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278351,-0.0518369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.309577,-0.0119566) , 
2, 1.01594, 1, 0, 0.300156,-0.0260963) , 
2, 0.708843, 1, 0, 0.25422,-0.00510578)    );
  // itree = 1661
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535714,0.0111012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430769,0.00128793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186281,-0.00272305) , 
1, -0.603775, 1, 0, 0.222667,0.00584826) , 
3, -1.74385, 1, 0, 0.250131,0.00290457)    );
  // itree = 1662
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.340974,-0.0068593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0350877,-0.0516318) , 
3, 0.299253, 1, 0, 0.29803,-0.013111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259211,-0.00372846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940367,-0.0276689) , 
3, 0.788668, 1, 0, 0.198997,0.0116334) , 
0, -0.22297, 1, 0, 0.239044,0.00162722)    );
  // itree = 1663
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226148,-0.00279132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.655629,0.035533) , 
0, 1.28559, 1, 0, 0.261222,0.0025616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,-0.0517634) , 
0, 1.55414, 1, 0, 0.25435,0.000356998)    );
  // itree = 1664
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247604,-0.00640011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280603,0.015405) , 
0, 0.396663, 1, 0, 0.257431,0.000368708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353448,0.0743669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386792,-0.000303607) , 
1, 0.441409, 1, 0, 0.369369,0.044693) , 
0, 1.32355, 1, 0, 0.269825,0.00527644)    );
  // itree = 1665
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4375,0.010829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.097561,-2.76324e-05) , 
1, 0.792147, 1, 0, 0.348726,-0.0179641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22,-0.00557059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203704,0.00532049) , 
0, 0.583742, 1, 0, 0.212446,0.00481271) , 
0, -0.49228, 1, 0, 0.254689,-0.00224743)    );
  // itree = 1666
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277022,-0.000913145) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.171141,-0.00306587) , 
1, 1.01701, 1, 0, 0.242818,0.00178571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254386,0.042283) , 
0, 1.52725, 1, 0, 0.243492,-0.00241201)    );
  // itree = 1667
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0405797,-0.036018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154545,-0.00908567) , 
2, -0.0193346, 1, 0, 0.0681319,0.0334367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128086,0.00710458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410504,-0.0088615) , 
1, 0.534111, 1, 0, 0.29475,-0.00559034) , 
1, -0.484715, 1, 0, 0.244106,0.00313133)    );
  // itree = 1668
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247423,0.00144129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19084,0.0446266) , 
0, 1.35023, 1, 0, 0.243018,0.00414035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305699,-0.0426623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.00423161) , 
1, 1.28455, 1, 0, 0.310145,-0.0224112) , 
2, 1.17109, 1, 0, 0.254438,-0.000376553)    );
  // itree = 1669
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.625,0.00224113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269883,0.00457333) , 
2, -1.72057, 1, 0, 0.29243,-0.00186818) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0821918,-0.013487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.078125,-0.0130746) , 
2, 1.44929, 1, 0, 0.0806916,0.0362602) , 
3, 1.19258, 1, 0, 0.255416,0.00479709)    );
  // itree = 1670
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318852,-0.00410786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144898,0.00616699) , 
3, 0.415836, 1, 0, 0.270939,-0.0147151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0894737,0.00400144) , 
3, 1.64517, 1, 0, 0.253428,-0.00942512)    );
  // itree = 1671
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15884,0.00431125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.349091,0.00811914) , 
0, -0.313714, 1, 0, 0.260168,-0.00473251) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238908,0.000123234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26971,-0.0350759) , 
1, 1.24765, 1, 0, 0.252809,0.0136837) , 
3, 0.853537, 1, 0, 0.258281,-1.13148e-05)    );
  // itree = 1672
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19382,0.0250952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315457,-0.0127749) , 
2, -0.454447, 1, 0, 0.251114,0.00687653) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161987,-0.039031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251462,-0.00174401) , 
0, -0.183158, 1, 0, 0.22003,-0.0130609) , 
1, -0.102501, 1, 0, 0.230537,-0.00632162)    );
  // itree = 1673
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308271,-0.00536814) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11332,0.00522273) , 
2, 0.64668, 1, 0, 0.254774,-0.00825253) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122449,0.0218032) , 
3, 1.96727, 1, 0, 0.248058,-0.00528603)    );
  // itree = 1674
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193651,-0.0114379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284232,0.00517273) , 
1, -0.774615, 1, 0, 0.26803,-0.00783966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0325203,-0.0568825) , 
3, 1.76021, 1, 0, 0.252654,-0.00311372)    );
  // itree = 1675
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146601,-0.0143277) , 
3, -2.10809, 1, 0, 0.134789,0.00991952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784768,0.0307738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312883,0.00159442) , 
2, 0.608291, 1, 0, 0.539809,-0.0249033) , 
1, 1.01701, 1, 0, 0.264826,-0.00126081)    );
  // itree = 1676
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0228625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175389,-0.0143245) , 
0, -1.01708, 1, 0, 0.188014,-0.00553194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411215,0.00708228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.84874,0.0369373) , 
3, 1.87723, 1, 0, 0.567568,0.0322186) , 
3, 1.29216, 1, 0, 0.250123,0.000645424)    );
  // itree = 1677
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454855,-0.00427141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.166914,-0.0053978) , 
1, -0.273757, 1, 0, 0.254264,0.0014382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.0126064) , 
1, 1.7097, 1, 0, 0.25098,-0.00170396)    );
  // itree = 1678
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195122,0.00636109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27003,-0.0089381) , 
2, -0.670941, 1, 0, 0.233083,-0.0202193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346774,0.0174896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238418,0.0154789) , 
0, -0.153245, 1, 0, 0.277335,0.0111428) , 
1, -0.128677, 1, 0, 0.262952,0.000949394)    );
  // itree = 1679
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751475) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0946262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289157,0.00163596) , 
0, -1.16792, 1, 0, 0.267232,0.00636997) , 
3, -2.18002, 1, 0, 0.253776,0.00343623)    );
  // itree = 1680
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200825,-0.00702482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.644737,0.0358656) , 
3, 1.24229, 1, 0, 0.242839,0.000617562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184,-0.0122271) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306122,-0.0412933) , 
2, 1.23533, 1, 0, 0.229219,-0.029789) , 
0, 1.03784, 1, 0, 0.24014,-0.0054091)    );
  // itree = 1681
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.506494,-0.00916907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.534392,0.0166209) , 
0, -0.527912, 1, 0, 0.521866,-0.0275057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209068,-0.000207833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117808,-0.0195886) , 
0, 0.95698, 1, 0, 0.187661,0.00437315) , 
1, -0.740821, 1, 0, 0.248025,-0.00138486)    );
  // itree = 1682
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352535,-0.0016768) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189076,-0.00185272) , 
0, -0.502209, 1, 0, 0.250871,0.00696244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261006,0.00131917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213793,-0.00279097) , 
0, -0.159503, 1, 0, 0.230512,-0.0193224) , 
1, 0.5496, 1, 0, 0.241935,-0.0045741)    );
  // itree = 1683
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00694444,-0.0158099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802469,-0.0201327) , 
1, -1.22072, 1, 0, 0.0457516,0.0180658) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301754,-0.00504524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234783,-0.00423551) , 
2, 1.4115, 1, 0, 0.292447,-0.0040525) , 
1, -0.764674, 1, 0, 0.253952,-0.000601095)    );
  // itree = 1684
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20597,0.00289566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802239,-0.0430361) , 
0, 0.138838, 1, 0, 0.162232,-0.00839105) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.474926,-0.0125643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446281,-0.0497608) , 
2, 1.4946, 1, 0, 0.467391,-0.0380936) , 
3, 0.892407, 1, 0, 0.232384,-0.0152192)    );
  // itree = 1685
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425175,0.0169479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268293,0.0158696) , 
0, 0.687556, 1, 0, 0.395904,-0.0192249) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.098434,-0.017935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159824,-0.00968514) , 
0, 0.129734, 1, 0, 0.135518,0.0226432) , 
2, -0.0267985, 1, 0, 0.249502,0.00431552)    );
  // itree = 1686
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198198,0.0126779) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306077,-0.00226324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195946,-0.00222237) , 
0, -0.0233042, 1, 0, 0.247295,-0.00123663) , 
1, -1.40498, 1, 0, 0.244639,-0.00387304)    );
  // itree = 1687
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261958,-0.00758056) , 
3, -2.09383, 1, 0, 0.245312,0.0028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,-0.0188435) , 
0, 1.55414, 1, 0, 0.241176,-0.000451589)    );
  // itree = 1688
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0830502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.013192) , 
3, -2.00367, 1, 0, 0.247718,0.00878598) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229167,-0.0453932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390244,0.00354118) , 
0, 0.78952, 1, 0, 0.312343,-0.020098) , 
2, 1.04395, 1, 0, 0.261005,0.00284765)    );
  // itree = 1689
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350207,-0.000433793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0711864,-0.015943) , 
2, 0.717597, 1, 0, 0.295333,-0.000930236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0904255,0.00407879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111821,0.0125692) , 
2, 0.626657, 1, 0, 0.103792,0.0230048) , 
3, 0.853537, 1, 0, 0.247376,0.00506251)    );
  // itree = 1690
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334572,0.0066815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.385915,0.00644931) , 
1, -0.494012, 1, 0, 0.363782,-0.0148166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.187234,-0.0193796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224893,0.00798615) , 
0, -0.483299, 1, 0, 0.218571,0.0167901) , 
3, -0.736148, 1, 0, 0.26334,0.00704575)    );
  // itree = 1691
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108567,-0.0287427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.843003,0.0463488) , 
1, 1.10642, 1, 0, 0.254755,0.00979734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20303,-0.00814097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330065,0.014626) , 
1, 1.213, 1, 0, 0.264151,-0.00787036) , 
2, 0.683145, 1, 0, 0.25759,0.00446686)    );
  // itree = 1692
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214041,0.00527085) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0430367) , 
0, 0.0942167, 1, 0, 0.169683,-0.00576158) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701754,0.00329671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519481,0.0259782) , 
3, 0.117203, 1, 0, 0.341166,0.024026) , 
2, -0.0368688, 1, 0, 0.266601,0.0110736)    );
  // itree = 1693
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329923,-0.00361688) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138748,-0.00718048) , 
3, 0.186669, 1, 0, 0.265873,0.00510499) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0298507,-0.0115965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130435,-0.00166735) , 
0, 1.03994, 1, 0, 0.0847458,-0.0264138) , 
3, 1.36188, 1, 0, 0.239922,0.000589188)    );
  // itree = 1694
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373444,-0.0103128) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315346,0.00615407) , 
0, -1.02604, 1, 0, 0.332134,-0.0110295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102767,-0.0163281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313869,0.00711618) , 
2, 0.921493, 1, 0, 0.176923,0.0146826) , 
3, -0.404141, 1, 0, 0.241517,0.00398203)    );
  // itree = 1695
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266773,-0.00842138) , 
3, -1.93842, 1, 0, 0.239598,0.00865511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234807,-0.0069509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242678,0.00519539) , 
0, 0.901351, 1, 0, 0.237937,-0.0211571) , 
2, 0.688794, 1, 0, 0.239098,-0.000325904)    );
  // itree = 1696
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259223,0.0230381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111285,-0.00766057) , 
0, 0.271021, 1, 0, 0.202638,0.0103822) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.649123,-0.031188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463519,-0.00528326) , 
1, 0.785813, 1, 0, 0.524496,-0.0255184) , 
3, 1.29216, 1, 0, 0.258065,0.0041998)    );
  // itree = 1697
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307482,0.0018101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0142857,-0.0514963) , 
3, 0.874531, 1, 0, 0.274272,-0.00894813) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228111,-0.00990536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0989761,-0.0124803) , 
3, 1.01649, 1, 0, 0.176066,0.0270659) , 
0, 0.435422, 1, 0, 0.237901,0.00438972)    );
  // itree = 1698
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259355,-0.00228576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.024,-0.0270637) , 
3, 1.5433, 1, 0, 0.241791,-0.000239483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128713,0.00264362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356061,0.00936836) , 
2, 0.906669, 1, 0, 0.257511,-0.0243364) , 
1, 1.47236, 1, 0, 0.243711,-0.00318214)    );
  // itree = 1699
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143411,0.0685211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262525,-0.00512556) , 
3, -1.58681, 1, 0, 0.245014,0.000386596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267016,0.0382013) , 
3, 1.65393, 1, 0, 0.247174,-0.00692303)    );
  // itree = 1700
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148981,-0.0142555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537037,0.0223481) , 
3, 0.75573, 1, 0, 0.239353,0.000203229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0290136) , 
0, 1.52075, 1, 0, 0.245331,-0.00297487)    );
  // itree = 1701
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.693069,0.0230518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315152,-0.0318964) , 
2, -1.7054, 1, 0, 0.458647,-0.0209329) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309252,-0.00233183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149438,0.0105989) , 
1, 0.365835, 1, 0, 0.224538,0.0071976) , 
2, -1.10481, 1, 0, 0.256555,0.00335044)    );
  // itree = 1702
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220588,0.00223333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.376563,0.00301231) , 
1, -1.22888, 1, 0, 0.349227,-0.0124093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163024,-0.00819083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330882,0.0023846) , 
1, 1.58643, 1, 0, 0.181524,0.016257) , 
3, -0.462334, 1, 0, 0.246269,0.00518979)    );
  // itree = 1703
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244755,0.0414895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217116,-0.0183828) , 
3, -0.93854, 1, 0, 0.230258,-0.00874969) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272328,-0.0147871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,0.0456316) , 
3, 1.55886, 1, 0, 0.262626,0.0163968) , 
3, 0.15517, 1, 0, 0.244031,0.00195017)    );
  // itree = 1704
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19845,0.0101915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136209,-0.0188167) , 
0, -0.374506, 1, 0, 0.162516,-0.0042338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366972,-0.0283678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589286,-0.00112014) , 
3, 1.48548, 1, 0, 0.491968,-0.0217941) , 
3, 0.934112, 1, 0, 0.243577,-0.00855446)    );
  // itree = 1705
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598726,0.0303877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255238,0.00112423) , 
2, -1.49314, 1, 0, 0.286374,-0.0064601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10559,0.0268676) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.08125,-0.017582) , 
3, 1.77349, 1, 0, 0.0934579,-0.0414926) , 
3, 1.3043, 1, 0, 0.25621,-0.0119377)    );
  // itree = 1706
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283729,0.00971011) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188006,-0.00295108) , 
1, 0.837042, 1, 0, 0.25163,-0.00567612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.35,-0.0162528) , 
2, 1.7595, 1, 0, 0.257653,-0.00342087)    );
  // itree = 1707
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0832352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.645161,0.0243614) , 
1, 0.939522, 1, 0, 0.163666,0.0181564) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.641221,0.0758515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259536,8.45162e-05) , 
2, -1.14352, 1, 0, 0.296933,-0.00674385) , 
0, -0.420972, 1, 0, 0.255133,0.00106625)    );
  // itree = 1708
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118367,-0.0115359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41806,0.029586) , 
3, 0.383196, 1, 0, 0.177165,0.00112402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356125,-0.0252792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87037,0.0351789) , 
3, 1.89841, 1, 0, 0.477124,-0.0200486) , 
3, 0.934112, 1, 0, 0.246596,-0.00377676)    );
  // itree = 1709
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288859,0.00413453) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.055409,-0.0142096) , 
2, 1.04095, 1, 0, 0.241747,0.00073432) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290323,0.0508473) , 
0, 1.52725, 1, 0, 0.244755,-0.00690697)    );
  // itree = 1710
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.539062,0.0325783) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.362832,0.00109243) , 
3, -1.61797, 1, 0, 0.456432,0.0355836) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176776,0.000531132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321244,2.35405e-06) , 
2, 0.703085, 1, 0, 0.225043,-0.00239285) , 
0, -1.09323, 1, 0, 0.253293,0.00224359)    );
  // itree = 1711
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114688,-0.00785208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274276,-0.000922693) , 
3, -0.730312, 1, 0, 0.201107,0.0114594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.399679,0.0149365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266234,0.00949966) , 
2, 1.13634, 1, 0, 0.355532,-0.00912886) , 
0, 0.18018, 1, 0, 0.272457,0.00194692)    );
  // itree = 1712
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176344,0.0181208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104271,-0.0227609) , 
2, -0.582417, 1, 0, 0.130849,-0.00187028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47557,0.0203854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.446154,-0.017306) , 
2, 1.72325, 1, 0, 0.47043,0.0202484) , 
3, 0.436997, 1, 0, 0.256858,0.00633735)    );
  // itree = 1713
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280681,0.00561591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193182,0.0139917) , 
0, 1.31913, 1, 0, 0.272485,-0.000559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,0.00625496) , 
2, 1.85125, 1, 0, 0.26478,-0.00315646)    );
  // itree = 1714
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191821,-0.00304353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282759,-0.00993498) , 
2, 0.186436, 1, 0, 0.218878,-0.00419522) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470852,-0.0146439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202128,0.0165258) , 
3, 0.727705, 1, 0, 0.320792,0.0209007) , 
2, 0.823591, 1, 0, 0.245043,0.00224782)    );
  // itree = 1715
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0548523,0.0204952) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189655,0.016439) , 
3, -0.980133, 1, 0, 0.0991501,-0.0343947) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0673077,0.0354903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317089,-0.00297197) , 
1, -1.06932, 1, 0, 0.300874,-0.00393644) , 
0, -0.828905, 1, 0, 0.26445,-0.00943606)    );
  // itree = 1716
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535117,-0.0196845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356958,0.0130762) , 
3, -0.797987, 1, 0, 0.253561,0.00633582) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340708,-0.0236515) , 
3, 0.43388, 1, 0, 0.229851,-0.0279433) , 
0, 1.11463, 1, 0, 0.249761,0.000841324)    );
  // itree = 1717
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358258,0.00628877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.085034,0.00118094) , 
1, 0.943531, 1, 0, 0.269252,0.00367439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23913,0.025395) , 
0, 1.43206, 1, 0, 0.266466,-4.99878e-06)    );
  // itree = 1718
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.454874,0.0256015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299338,-0.000845103) , 
0, -0.998506, 1, 0, 0.341085,-0.000231235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141243,-0.0172108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178707,0.00261688) , 
0, 1.17327, 1, 0, 0.15139,0.0263514) , 
3, -0.0237104, 1, 0, 0.249126,0.0126553)    );
  // itree = 1719
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247435,-0.00388991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323529,-0.0239062) , 
3, 1.13906, 1, 0, 0.254516,0.00236729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198953,0.0131359) , 
3, 1.65635, 1, 0, 0.249257,-0.00100386)    );
  // itree = 1720
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236051,-0.0162802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241729,0.00555705) , 
1, -0.512249, 1, 0, 0.24037,-0.000491313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315385,-0.0285158) , 
0, 1.52075, 1, 0, 0.245065,-0.00309796)    );
  // itree = 1721
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486726,-0.0271489) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316384,-0.0294031) , 
3, -2.17417, 1, 0, 0.382759,-0.022075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.339326,-0.012515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179276,0.00599005) , 
1, -0.15863, 1, 0, 0.222155,0.0137391) , 
3, -1.54418, 1, 0, 0.246028,0.00841561)    );
  // itree = 1722
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406417,0.0016699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237787,0.00119267) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254902,0.032569) , 
0, 1.54068, 1, 0, 0.238756,4.11357e-05) , 
0, -1.26434, 1, 0, 0.254527,0.00329043)    );
  // itree = 1723
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,-0.0360414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282692,-0.00691354) , 
0, -0.856757, 1, 0, 0.255853,0.00564366) , 
3, -1.94621, 1, 0, 0.240692,0.00283702)    );
  // itree = 1724
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169168,0.0140607) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11522,-0.0328907) , 
2, -0.0987701, 1, 0, 0.142758,-0.00218831) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415842,-0.0332811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58465,0.0224604) , 
0, -0.136007, 1, 0, 0.553309,0.021841) , 
3, 0.752409, 1, 0, 0.255556,0.00441368)    );
  // itree = 1725
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341973,-0.00429127) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109817,0.003192) , 
1, 0.834927, 1, 0, 0.264329,0.000174264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0679012,-0.0217498) , 
3, 1.69879, 1, 0, 0.248086,0.00489871)    );
  // itree = 1726
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.286256,0.00335762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23871,-0.00774468) , 
1, 0.529246, 1, 0, 0.26612,-0.00807865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0844156,0.0360288) , 
3, 1.73078, 1, 0, 0.252016,-0.0138589)    );
  // itree = 1727
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166189,-0.0132123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.459016,0.000903018) , 
0, 0.719916, 1, 0, 0.227015,-0.000637578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220126,-0.0149426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245455,0.0144307) , 
1, 1.33085, 1, 0, 0.230483,0.0408499) , 
3, 1.34716, 1, 0, 0.227474,0.00485731)    );
  // itree = 1728
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117284,-0.0493117) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147147,-0.00890528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528716,0.00935764) , 
3, 0.747335, 1, 0, 0.264553,0.000713038) , 
0, -1.41794, 1, 0, 0.253116,-0.00309677)    );
  // itree = 1729
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.567839,-0.00483623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313202,0.0055455) , 
1, -1.02412, 1, 0, 0.368825,-0.00671242) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119266,-0.0108853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155864,-0.00904902) , 
0, 0.10578, 1, 0, 0.141144,0.0167266) , 
2, -0.0368688, 1, 0, 0.245113,0.00602339)    );
  // itree = 1730
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254494,-0.00201867) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135802,0.00745058) , 
0, 1.35023, 1, 0, 0.244593,-0.00770716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.454545,0.045008) , 
1, 1.68097, 1, 0, 0.255848,-0.0107866)    );
  // itree = 1731
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29572,0.0114219) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246931,-0.000801609) , 
2, -0.632281, 1, 0, 0.260137,0.00380296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0220588,-0.0765628) , 
1, 1.65151, 1, 0, 0.244226,0.000311055)    );
  // itree = 1732
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.0117229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46952,0.0161605) , 
3, 0.148182, 1, 0, 0.259401,0.00556274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280822,-0.0329603) , 
0, 1.44547, 1, 0, 0.260979,0.00193759)    );
  // itree = 1733
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346154,0.0112872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302709,0.0151681) , 
0, -0.420895, 1, 0, 0.320663,-0.0041577) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0294118,-0.015617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125698,0.00643065) , 
0, 0.0611916, 1, 0, 0.104348,0.0199007) , 
3, 0.853537, 1, 0, 0.268485,0.00164559)    );
  // itree = 1734
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315068,-0.0168679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.395973,-0.017362) , 
1, -0.0985653, 1, 0, 0.347826,-0.0293757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142647,0.00296325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318519,0.00900358) , 
2, 0.0738772, 1, 0, 0.244923,0.00371863) , 
0, -0.828905, 1, 0, 0.263924,-0.00239211)    );
  // itree = 1735
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156489,0.0113385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268519,0.0117435) , 
2, -0.994889, 1, 0, 0.239686,-0.00978573) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257468,-0.0122138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337539,0.00253496) , 
0, 1.00944, 1, 0, 0.282353,0.0140507) , 
3, -0.097287, 1, 0, 0.26104,0.00214416)    );
  // itree = 1736
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0817501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299692,0.00653032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159292,-0.0184453) , 
1, 1.09547, 1, 0, 0.257112,-0.000824661) , 
3, -2.07588, 1, 0, 0.243394,-0.00297962)    );
  // itree = 1737
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451429,-5.36223e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204654,-0.00203731) , 
2, -0.940365, 1, 0, 0.252347,0.00562733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209302,0.0137278) , 
0, 1.43206, 1, 0, 0.248613,0.00141447)    );
  // itree = 1738
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1375,-0.0195492) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0802159) , 
3, -1.00297, 1, 0, 0.0774648,-0.0286194) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30746,0.00829233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234456,-0.00131277) , 
1, 0.662232, 1, 0, 0.27551,-0.00533336) , 
2, -1.22185, 1, 0, 0.248047,-0.00856248)    );
  // itree = 1739
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158228,-0.00372709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.592593,0.01712) , 
1, 1.22922, 1, 0, 0.264221,-2.94552e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,-0.0289437) , 
0, 1.55414, 1, 0, 0.257644,-0.00396794)    );
  // itree = 1740
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0138249,-0.0495895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295983,0.0275209) , 
3, -1.55464, 1, 0, 0.207246,0.0119856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193576,-0.016589) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.688442,0.0167779) , 
3, 1.54247, 1, 0, 0.266469,-0.00684783) , 
0, -0.420972, 1, 0, 0.246448,-0.000480833)    );
  // itree = 1741
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330739,-0.00752523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.127273,-0.00229703) , 
2, 0.216717, 1, 0, 0.240151,0.00131863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0597015,-0.025431) , 
2, 1.76296, 1, 0, 0.227982,0.00399863)    );
  // itree = 1742
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19697,-0.00523014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284599,0.00130698) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228117,0.0105785) , 
1, 1.35424, 1, 0, 0.272676,0.0134353) , 
1, -1.05293, 1, 0, 0.265121,0.00924568)    );
  // itree = 1743
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181908,-0.00985077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0144912) , 
0, 0.505827, 1, 0, 0.256217,-0.0130415) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.166667,-0.0131078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247692,0.00151934) , 
2, 0.682565, 1, 0, 0.236148,0.00924425) , 
2, 0.52005, 1, 0, 0.248921,-0.00493953)    );
  // itree = 1744
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193948,-0.0113565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298077,0.0181504) , 
0, -0.326542, 1, 0, 0.257616,0.00691406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273585,-0.0429331) , 
0, 1.54569, 1, 0, 0.258472,0.00322338)    );
  // itree = 1745
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350694,-0.0122436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2784,-0.0024741) , 
0, -0.96833, 1, 0, 0.291938,0.011281) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110092,0.0385226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104167,-0.000760365) , 
1, 0.457361, 1, 0, 0.105477,-0.0357521) , 
3, 0.892407, 1, 0, 0.246677,-0.000135669)    );
  // itree = 1746
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352941,-0.00745129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278922,-0.00737209) , 
0, -0.564389, 1, 0, 0.311388,-0.00275783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.120499,-0.0213713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164286,-0.0237513) , 
0, 1.42089, 1, 0, 0.12761,0.0275713) , 
3, 0.174619, 1, 0, 0.231621,0.0104062)    );
  // itree = 1747
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0773656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276471,0.00186514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139394,-0.022986) , 
1, 1.55041, 1, 0, 0.264343,0.00691215) , 
0, -1.37002, 1, 0, 0.243697,0.00343857)    );
  // itree = 1748
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171429,0.0280931) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159747,-0.000529939) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.487585,-0.0121275) , 
3, 0.928597, 1, 0, 0.237661,-0.00491438) , 
0, -1.7478, 1, 0, 0.234129,-0.0032278)    );
  // itree = 1749
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,0.00649168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125786,-0.0305903) , 
0, 1.22655, 1, 0, 0.296717,0.00422636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0271739,-0.0346391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107477,0.0108334) , 
3, 0.758778, 1, 0, 0.0703518,-0.0294002) , 
2, 1.09499, 1, 0, 0.251261,-0.0025261)    );
  // itree = 1750
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.354467,-0.0126642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243922,-0.00141322) , 
0, -0.820681, 1, 0, 0.267571,-0.00768723) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0412371,-0.0298678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177033,0.0127395) , 
0, 0.784455, 1, 0, 0.133987,-0.0348547) , 
3, 1.29216, 1, 0, 0.246369,-0.0119991)    );
  // itree = 1751
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227189,-0.00450174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380952,0.027634) , 
3, 1.59734, 1, 0, 0.238204,0.00211411) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463235,0.0216125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366972,-0.0297879) , 
3, 1.38485, 1, 0, 0.273469,0.0252903) , 
2, 1.47108, 1, 0, 0.242515,0.00494752)    );
  // itree = 1752
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0450704,-0.0431661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00520833,-0.0267128) , 
1, -0.136383, 1, 0, 0.0310786,-0.01846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255696,0.0285488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333636,0.000307336) , 
2, -0.253051, 1, 0, 0.313043,0.00756791) , 
3, -0.961157, 1, 0, 0.237512,0.000595695)    );
  // itree = 1753
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.358108,0.0059795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277487,-0.00579738) , 
0, -0.738, 1, 0, 0.3,0.0104804) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0629921,-0.0201732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135338,0.024597) , 
1, 1.42713, 1, 0, 0.0878553,-0.030273) , 
2, 1.0496, 1, 0, 0.258472,0.00250287)    );
  // itree = 1754
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131579,-0.0217932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923913,-0.0086456) , 
1, -0.852814, 1, 0, 0.107383,-0.0172192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304837,-0.00186132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220681,0.00495982) , 
0, 0.226627, 1, 0, 0.265161,0.00992157) , 
2, -1.11308, 1, 0, 0.241414,0.00583675)    );
  // itree = 1755
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274346,0.00432844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271028,-0.0260502) , 
1, 1.55119, 1, 0, 0.27416,-0.010773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126761,-0.0353484) , 
3, 1.60174, 1, 0, 0.259329,-0.00591764)    );
  // itree = 1756
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226277,0.048802) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161134,-0.0155953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550971,0.012153) , 
3, 1.00886, 1, 0, 0.247578,-0.00379633) , 
0, -1.41761, 1, 0, 0.246115,-0.000542506)    );
  // itree = 1757
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373913,0.000572358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.391172,0.00260887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168842,-0.00350566) , 
2, -0.285962, 1, 0, 0.246415,0.00312355) , 
0, -1.61795, 1, 0, 0.253754,0.00696324)    );
  // itree = 1758
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348214,0.0230479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12381,-0.0228507) , 
3, -1.62801, 1, 0, 0.239631,0.0302775) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329966,-0.0220794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233443,0.00416982) , 
0, -0.784322, 1, 0, 0.249177,0.00156905) , 
1, -0.943262, 1, 0, 0.248161,0.00462434)    );
  // itree = 1759
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00534759,-0.070844) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0984252,-0.0165718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32073,0.00460894) , 
1, -0.474289, 1, 0, 0.28915,-0.00117232) , 
1, -1.08065, 1, 0, 0.262278,-0.00508069)    );
  // itree = 1760
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21838,0.0258507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222368,-0.0197933) , 
2, 0.297714, 1, 0, 0.220011,0.00515108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.733333,0.029775) , 
3, 1.73078, 1, 0, 0.261858,0.00925149)    );
  // itree = 1761
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420428,-0.00118744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178357,0.00256007) , 
3, 0.0388081, 1, 0, 0.33035,0.00967488) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0592784,-0.016718) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111969,-0.010074) , 
0, 0.460404, 1, 0, 0.0803709,-0.0200105) , 
1, 0.967289, 1, 0, 0.248994,1.36835e-05)    );
  // itree = 1762
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334806,0.00123679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13557,-0.00144994) , 
3, 0.0746927, 1, 0, 0.255727,-0.00102239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283333,-0.0194035) , 
1, 1.64811, 1, 0, 0.257386,0.00275473)    );
  // itree = 1763
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.260786,0.00532034) , 
3, -2.20433, 1, 0, 0.244418,-0.00260886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.422727,0.0355649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255034,0.00108254) , 
0, 1.16454, 1, 0, 0.355014,-0.0457048) , 
3, 1.13793, 1, 0, 0.264561,-0.010458)    );
  // itree = 1764
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252941,0.0609187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307628,0.0130121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195531,-0.007954) , 
1, 0.863264, 1, 0, 0.265584,0.00479769) , 
0, -1.33315, 1, 0, 0.26455,0.00867364)    );
  // itree = 1765
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465347,-0.0427785) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329897,0.0132028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22299,-0.00577596) , 
0, -0.794046, 1, 0, 0.239511,0.00781896) , 
3, -2.18002, 1, 0, 0.251008,0.00507683)    );
  // itree = 1766
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312808,0.00035879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221071,0.0073479) , 
0, -0.114305, 1, 0, 0.274623,-0.0114511) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156522,-0.0275302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107807,-0.0255065) , 
3, 0.725019, 1, 0, 0.130261,0.0223667) , 
0, 0.828962, 1, 0, 0.236508,-0.00252251)    );
  // itree = 1767
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0788213) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538462,0.00487989) , 
1, 0.792147, 1, 0, 0.144082,-0.0140054) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368039,0.0226463) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251813,-0.0104726) , 
3, -0.277258, 1, 0, 0.286647,0.0179402) , 
0, -0.534386, 1, 0, 0.244263,0.00844287)    );
  // itree = 1768
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102804,0.052579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767196,-0.0272151) , 
2, -1.49281, 1, 0, 0.0799536,-0.00915019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146552,-0.0276558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436159,0.0207823) , 
2, -0.861399, 1, 0, 0.405479,0.0231275) , 
3, -0.36221, 1, 0, 0.262002,0.00890093)    );
  // itree = 1769
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407855,-0.0168202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.0076011) , 
3, -1.03657, 1, 0, 0.301775,0.0149856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.438144,0.00779558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177561,0.00325943) , 
1, -0.469325, 1, 0, 0.219032,-0.0130357) , 
0, -0.361587, 1, 0, 0.248549,-0.00303971)    );
  // itree = 1770
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0659898,-0.0400122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346971,0.00724638) , 
2, -1.30736, 1, 0, 0.309264,-0.000993408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0788382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129747,-0.0083713) , 
2, 0.626657, 1, 0, 0.0883621,-0.0310705) , 
3, 0.867657, 1, 0, 0.256211,-0.0082169)    );
  // itree = 1771
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.039801,0.0606562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568182,-0.0303038) , 
3, -1.08103, 1, 0, 0.0477454,0.0354957) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298999,-0.00529594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267606,0.00414196) , 
2, 1.49537, 1, 0, 0.294848,-0.00308395) , 
1, -0.626967, 1, 0, 0.247988,0.00423221)    );
  // itree = 1772
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254058,-0.00851509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192982,-0.04122) , 
0, 1.22394, 1, 0, 0.245593,-0.0122746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16895,0.0354216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302632,-0.0071854) , 
2, 1.17807, 1, 0, 0.22372,0.0143655) , 
1, 1.35807, 1, 0, 0.241567,-0.00737207)    );
  // itree = 1773
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307799,-0.0120171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270096,-0.0111957) , 
0, -0.218833, 1, 0, 0.290299,0.00708173) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169014,0.00757402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131907,0.0174472) , 
1, 0.0694733, 1, 0, 0.139403,-0.0304911) , 
3, 0.506049, 1, 0, 0.238375,-0.00584716)    );
  // itree = 1774
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380744,0.00564642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283708,0.00803938) , 
0, -0.720184, 1, 0, 0.312787,0.00538028) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826446,-0.00603402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232143,0.0368701) , 
0, 1.45153, 1, 0, 0.117895,-0.0209268) , 
3, 0.934112, 1, 0, 0.2665,-0.000867646)    );
  // itree = 1775
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0377524,-0.0300605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.537234,0.0342835) , 
0, 1.31913, 1, 0, 0.108515,0.0164919) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569444,0.0116772) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452632,-0.0168342) , 
0, -0.528422, 1, 0, 0.47619,-0.00804841) , 
1, 0.895474, 1, 0, 0.237139,0.00790703)    );
  // itree = 1776
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0573477,-0.041561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268097,0.00211733) , 
2, -1.20234, 1, 0, 0.234896,-0.00243278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228571,-0.0797886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396825,-0.00473763) , 
0, 0.923283, 1, 0, 0.320346,-0.0349645) , 
2, 1.45905, 1, 0, 0.244755,-0.00618643)    );
  // itree = 1777
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529915,0.00682531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337748,0.0348996) , 
1, -0.747739, 1, 0, 0.421642,-0.0342927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256307,0.00111738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202033,0.0012747) , 
0, 0.423781, 1, 0, 0.232283,-0.0053237) , 
0, -1.08742, 1, 0, 0.257087,-0.00911827)    );
  // itree = 1778
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0788382,-0.0278087) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264245,0.000210905) , 
2, -1.27135, 1, 0, 0.239935,0.00640857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328671,0.0138178) , 
1, 1.58039, 1, 0, 0.24634,0.00182523)    );
  // itree = 1779
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256213,0.00531496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338462,0.0041752) , 
0, 1.44542, 1, 0, 0.262088,0.000403846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.047619,-0.0563955) , 
1, 1.65151, 1, 0, 0.248201,-0.00436033)    );
  // itree = 1780
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284658,0.0351063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289733,-0.00212024) , 
0, -0.305233, 1, 0, 0.28754,0.0128664) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0497512,-0.0692717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207039,0.00315726) , 
0, -0.31859, 1, 0, 0.160819,-0.0129029) , 
1, 0.946985, 1, 0, 0.242769,0.00376193)    );
  // itree = 1781
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.602837,0.040787) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237323,-0.00959262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216527,-0.000141878) , 
0, 0.0546526, 1, 0, 0.227085,0.00546597) , 
2, -1.59584, 1, 0, 0.25252,0.00239341)    );
  // itree = 1782
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275943,-0.000881674) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0761905,-0.0218677) , 
3, 1.43289, 1, 0, 0.264298,-0.0168782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584795,-0.0113192) , 
3, 1.74551, 1, 0, 0.24645,-0.012278)    );
  // itree = 1783
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23012,-0.00292053) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364807,0.029001) , 
3, 1.31412, 1, 0, 0.246698,-0.00635754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243421,0.00132504) , 
2, 1.68193, 1, 0, 0.246455,-0.00354355)    );
  // itree = 1784
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0687419,-0.0237456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388195,0.0051365) , 
3, -0.42962, 1, 0, 0.239104,-0.00241121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230089,0.0953081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348837,0.014302) , 
0, -0.0472355, 1, 0, 0.301754,0.0455765) , 
1, 1.44028, 1, 0, 0.248322,0.00464945)    );
  // itree = 1785
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26971,0.00517469) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215517,0.0955698) , 
1, 1.59213, 1, 0, 0.266223,-0.0124769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138095,-0.0141189) , 
0, 1.34352, 1, 0, 0.252856,-0.00889492)    );
  // itree = 1786
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253659,0.000520752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360731,0.00597477) , 
1, -0.955531, 1, 0, 0.340426,-0.0107128) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124016,0.00405386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177898,-0.00584186) , 
1, 1.11704, 1, 0, 0.146758,0.00773555) , 
3, 0.130099, 1, 0, 0.253571,-0.0024393)    );
  // itree = 1787
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.103068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272664,0.000157513) , 
1, -1.05665, 1, 0, 0.242706,-0.00548228) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305882,-0.00808116) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107843,-0.0325015) , 
1, 1.47448, 1, 0, 0.2493,0.057493) , 
3, 1.1828, 1, 0, 0.243902,0.00594159)    );
  // itree = 1788
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165075,0.00630009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387013,-0.0197175) , 
3, 0.704285, 1, 0, 0.211237,-0.00255197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.741667,0.0307706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.653846,0.0187173) , 
1, 1.40824, 1, 0, 0.700893,0.0451846) , 
3, 1.63045, 1, 0, 0.264096,0.00260128)    );
  // itree = 1789
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483146,-0.0137422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.504951,0.00992229) , 
0, -0.286712, 1, 0, 0.491039,-0.0181107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243566,-0.00320507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111486,-0.00338879) , 
3, 0.612679, 1, 0, 0.197024,0.00361963) , 
1, -0.840753, 1, 0, 0.238897,0.00052481)    );
  // itree = 1790
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217195,0.00215559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360952,0.0108378) , 
1, -0.958684, 1, 0, 0.335956,0.0126848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0808795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160643,-0.00279779) , 
2, 0.336812, 1, 0, 0.120846,-0.016666) , 
3, 0.436997, 1, 0, 0.262287,0.00263293)    );
  // itree = 1791
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.019802,-0.0190621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29913,0.018254) , 
1, -0.89073, 1, 0, 0.226512,0.00347624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248958,0.00174325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315126,-0.00847496) , 
0, 1.14273, 1, 0, 0.262103,-0.0211994) , 
3, -0.408719, 1, 0, 0.248101,-0.0114916)    );
  // itree = 1792
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156366,-0.00746505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466165,0.0226028) , 
3, 0.704285, 1, 0, 0.227325,0.00364844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613636,-0.0266646) , 
3, 1.63045, 1, 0, 0.262774,-0.000849392)    );
  // itree = 1793
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29557,0.00448115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0857143,-0.00748015) , 
3, 1.01278, 1, 0, 0.267397,0.00136441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138122,0.0558223) , 
3, 1.63045, 1, 0, 0.255733,-0.0050217)    );
  // itree = 1794
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287931,-0.000712334) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.07,-0.0368412) , 
3, 1.39349, 1, 0, 0.276087,-0.000280529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0215762) , 
3, 1.71106, 1, 0, 0.259557,0.00269042)    );
  // itree = 1795
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.16442,-0.00816414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.544872,0.0513717) , 
3, 0.874531, 1, 0, 0.21119,-0.0141252) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279539,-0.00201497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426396,0.0107255) , 
0, 1.02002, 1, 0, 0.357625,0.00673034) , 
0, 0.435422, 1, 0, 0.265174,-0.00643666)    );
  // itree = 1796
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260417,0.02595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203814,-0.0108408) , 
1, -1.41766, 1, 0, 0.206877,-0.0076602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.632353,-0.03346) , 
3, 1.76021, 1, 0, 0.237173,-0.0111818)    );
  // itree = 1797
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296741,-0.00684426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0321101,-0.0271586) , 
2, 0.947327, 1, 0, 0.255058,0.0136946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225564,0.00710026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185759,0.00119513) , 
0, 1.11524, 1, 0, 0.203735,-0.0176491) , 
0, 0.563554, 1, 0, 0.239736,0.00433756)    );
  // itree = 1798
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289086,0.00484643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0673053) , 
3, -0.601003, 1, 0, 0.211382,0.0232799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306176,0.0054279) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.193666,-0.008754) , 
1, 0.737463, 1, 0, 0.247788,-0.0033021) , 
1, -0.484715, 1, 0, 0.239151,0.00300376)    );
  // itree = 1799
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359795,0.0342771) , 
0, -1.38913, 1, 0, 0.302151,-0.0170973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223577,-0.0138288) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,-0.0572349) , 
2, 1.85294, 1, 0, 0.205667,0.0103063) , 
2, -0.0267985, 1, 0, 0.25,-0.00228526)    );
  // itree = 1800
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203822,-0.0267588) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24886,0.000944324) , 
1, -0.754602, 1, 0, 0.241211,-0.00381082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.463636,0.0244767) , 
2, 1.77922, 1, 0, 0.253701,-0.00131174)    );
  // itree = 1801
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.310858,-0.0026798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.19375,0.0175079) , 
3, 0.302781, 1, 0, 0.285226,0.000218359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0403226,-0.0568857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.112805,0.00313728) , 
3, 1.28063, 1, 0, 0.0929204,0.0357553) , 
3, 0.953956, 1, 0, 0.239812,0.00861058)    );
  // itree = 1802
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245365,-0.00408028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332016,0.00986828) , 
1, 0.234612, 1, 0, 0.264103,0.0108856) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108173,-0.00759878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319613,0.00229691) , 
2, 0.600085, 1, 0, 0.21351,-0.0128916) , 
1, 0.627177, 1, 0, 0.243122,0.00102503)    );
  // itree = 1803
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215405,0.00307729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.473282,0.00837362) , 
0, 0.886294, 1, 0, 0.268052,-0.00335046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188976,0.0364122) , 
2, 1.7672, 1, 0, 0.263158,-0.000817811)    );
  // itree = 1804
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201581,-0.0232062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27672,0.0141712) , 
0, -1.03521, 1, 0, 0.264978,0.00740216) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00925926,0.0117092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2607,-0.041337) , 
3, 0.217548, 1, 0, 0.186301,-0.0485413) , 
1, 1.37313, 1, 0, 0.250504,-0.00288986)    );
  // itree = 1805
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.579882,-0.00805912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.474576,0.0138789) , 
1, -1.17636, 1, 0, 0.536585,-0.0198221) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427273,-0.00677238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185961,-0.00182719) , 
1, -0.619815, 1, 0, 0.201269,0.00858887) , 
1, -0.843018, 1, 0, 0.248887,0.00455427)    );
  // itree = 1806
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.476015,0.032035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219605,-0.0130542) , 
3, -1.5305, 1, 0, 0.26339,0.00166163) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194286,-0.000668728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189091,-0.00142157) , 
3, 0.31475, 1, 0, 0.191111,-0.0260142) , 
1, 1.29547, 1, 0, 0.247423,-0.00445232)    );
  // itree = 1807
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0695187,0.0326543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294677,-0.00532017) , 
0, -0.870944, 1, 0, 0.251537,-0.00421639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.000234947) , 
0, 1.52075, 1, 0, 0.24867,-0.00168708)    );
  // itree = 1808
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217949,-0.00363298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286645,-0.0349297) , 
2, 0.989236, 1, 0, 0.229245,-0.00845501) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4375,0.0357917) , 
2, 1.7595, 1, 0, 0.245683,-0.00388617)    );
  // itree = 1809
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.533597,0.00294735) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228171,-0.0034168) , 
2, -1.30736, 1, 0, 0.270582,0.00514069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109524,-0.0146055) , 
1, 1.47236, 1, 0, 0.253937,0.000702547)    );
  // itree = 1810
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378486,-0.0145594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237573,0.007055) , 
0, -1.09189, 1, 0, 0.257222,0.000361677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184466,0.0063855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40566,0.0185414) , 
1, 1.65998, 1, 0, 0.296651,-0.0455) , 
1, 1.5027, 1, 0, 0.261324,-0.00440939)    );
  // itree = 1811
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245989,-0.0136286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416185,0.041189) , 
3, 1.35449, 1, 0, 0.261853,-0.00566536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0768934) , 
3, 1.90896, 1, 0, 0.24645,-0.00297845)    );
  // itree = 1812
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.029703,-0.0322409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341584,0.0444162) , 
3, -2.04485, 1, 0, 0.237624,0.0276118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236754,-0.00993586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339744,0.0267117) , 
2, 1.69069, 1, 0, 0.246509,-0.00520318) , 
0, -0.940853, 1, 0, 0.245128,-0.000104234)    );
  // itree = 1813
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482927,-0.0160695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229767,-0.000964799) , 
1, -1.05293, 1, 0, 0.260974,-0.003809) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0725806,0.0163528) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,0.00619429) , 
2, 0.977242, 1, 0, 0.0996785,-0.043236) , 
3, 1.29216, 1, 0, 0.235562,-0.0100207)    );
  // itree = 1814
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168317,0.00042385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230769,-0.0130459) , 
2, -1.08812, 1, 0, 0.2,-0.0397225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281768,-0.00115601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269499,0.00605733) , 
1, -0.559459, 1, 0, 0.270762,0.00424346) , 
1, -0.952616, 1, 0, 0.263372,-0.000347985)    );
  // itree = 1815
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276527,0.00554737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255363,0.00369513) , 
2, 0.0194114, 1, 0, 0.26569,0.00265442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00806452,-0.0758919) , 
1, 1.65151, 1, 0, 0.25,0.00628317)    );
  // itree = 1816
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216953,0.000236106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.674074,0.0313414) , 
3, 1.61197, 1, 0, 0.250823,0.00396209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268571,-0.0216402) , 
1, 1.52775, 1, 0, 0.252379,0.00134654)    );
  // itree = 1817
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402229,-0.000451294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0927536,-0.0269174) , 
3, 0.441796, 1, 0, 0.322072,0.0235421) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0748663,-0.00787276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.096,-0.0320746) , 
1, 1.57761, 1, 0, 0.0787172,-0.0122409) , 
1, 0.943531, 1, 0, 0.239346,0.011378)    );
  // itree = 1818
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12381,-0.021886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.440433,0.000821349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23286,0.00205088) , 
0, -0.919971, 1, 0, 0.263186,-0.000675911) , 
1, -1.40498, 1, 0, 0.255872,-0.00357793)    );
  // itree = 1819
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248359,-0.004953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,-0.0110533) , 
2, 1.68391, 1, 0, 0.249353,-0.0041359) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0824035) , 
1, 1.67676, 1, 0, 0.235928,-0.00639011)    );
  // itree = 1820
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0447761,-0.0705746) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275229,-0.042787) , 
1, -0.657299, 1, 0, 0.037037,-0.0359898) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.300885,0.0545548) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274847,-0.00056002) , 
0, -1.2923, 1, 0, 0.276535,0.00299851) , 
2, -1.29506, 1, 0, 0.247231,-0.00177196)    );
  // itree = 1821
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451991,0.00271275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207223,-0.00174719) , 
2, -0.624804, 1, 0, 0.272956,-0.00177556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0777778,-0.0203691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670103,-0.0324116) , 
2, 0.889251, 1, 0, 0.0721925,0.0222614) , 
1, 1.35807, 1, 0, 0.234725,0.00280175)    );
  // itree = 1822
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.390071,0.029392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11039,-0.0242715) , 
3, -1.62801, 1, 0, 0.244068,0.0430571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150555,-0.0113461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318744,0.00451638) , 
2, -0.0200118, 1, 0, 0.255648,0.00368008) , 
1, -0.796791, 1, 0, 0.25392,0.00955576)    );
  // itree = 1823
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0897044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110169,0.0281928) , 
1, -1.34263, 1, 0, 0.0822785,-0.0120867) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317378,0.00291389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326797,0.00235712) , 
0, 1.44547, 1, 0, 0.318332,0.00766801) , 
1, -0.469325, 1, 0, 0.261965,0.00295076)    );
  // itree = 1824
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.0325408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188206,-0.0274568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261261,-0.00415009) , 
0, -0.0272391, 1, 0, 0.228842,-0.0126041) , 
0, -1.44702, 1, 0, 0.232308,-0.00907198)    );
  // itree = 1825
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651515,0.0112321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406091,-0.012565) , 
1, -1.31384, 1, 0, 0.504559,-0.0244847) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195638,0.0021254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264957,0.0256984) , 
0, 1.54569, 1, 0, 0.200477,0.000694647) , 
1, -0.754602, 1, 0, 0.250374,-0.00343703)    );
  // itree = 1826
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216374,-0.0195982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129412,-0.0224518) , 
0, -0.59403, 1, 0, 0.173021,0.0294537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209677,-0.00132885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31773,-0.00036312) , 
2, 0.501102, 1, 0, 0.256269,-0.00450266) , 
1, -0.71469, 1, 0, 0.241903,0.00135723)    );
  // itree = 1827
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0803455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294333,0.00822068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0393701,-0.0568971) , 
1, 1.63248, 1, 0, 0.276018,-0.00727328) , 
0, -1.27591, 1, 0, 0.24898,-0.00373538)    );
  // itree = 1828
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0251572,-0.0373214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249763,0.0266567) , 
3, -1.10404, 1, 0, 0.179739,0.0119005) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.603604,-0.0529046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.46049,-0.0102893) , 
1, 0.386018, 1, 0, 0.493724,-0.03016) , 
3, 0.887378, 1, 0, 0.254482,0.00188809)    );
  // itree = 1829
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404494,-0.0261464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212951,-0.00648681) , 
3, -1.71965, 1, 0, 0.232063,0.00697102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00499056) , 
1, 1.54903, 1, 0, 0.224679,0.00407208)    );
  // itree = 1830
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201681,0.00385875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340016,0.00565554) , 
1, -0.948609, 1, 0, 0.317845,0.0043572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.047486,-0.0533763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144509,-0.0196841) , 
0, 1.26026, 1, 0, 0.079096,0.0372363) , 
3, 0.832675, 1, 0, 0.25496,0.0130173)    );
  // itree = 1831
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2494,-0.00441156) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32948,0.0194574) , 
3, 1.31412, 1, 0, 0.256926,-0.00577927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,0.00949263) , 
2, 1.76296, 1, 0, 0.252041,-0.00372048)    );
  // itree = 1832
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143836,0.011058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238342,-0.0593747) , 
2, -1.05511, 1, 0, 0.19764,-0.0266101) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218206,0.00827601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712121,0.0292986) , 
3, 1.60934, 1, 0, 0.276005,0.0119846) , 
1, -0.79453, 1, 0, 0.262925,0.00554264)    );
  // itree = 1833
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.44334,0.0047086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236264,-0.0263466) , 
0, 0.137679, 1, 0, 0.388321,0.00911297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184423,0.00449682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0774648,-0.0257972) , 
3, 1.65392, 1, 0, 0.172359,-0.00753488) , 
2, -0.361538, 1, 0, 0.248457,-0.00166874)    );
  // itree = 1834
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309061,0.0104119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293542,0.00635093) , 
1, -0.102501, 1, 0, 0.29939,-0.00364331) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,-0.00244316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963855,-0.0220995) , 
3, 1.41219, 1, 0, 0.144893,0.0407357) , 
0, 1.00007, 1, 0, 0.267831,0.00542197)    );
  // itree = 1835
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334821,0.0502829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237126,-0.00479556) , 
2, -1.26941, 1, 0, 0.24868,0.00204482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172727,-0.0409276) , 
0, 1.52669, 1, 0, 0.244511,0.00759205)    );
  // itree = 1836
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276224,0.0209708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271701,-0.000664363) , 
1, -0.859567, 1, 0, 0.272601,0.004136) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0445682,0.00285523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0237251) , 
3, 1.09351, 1, 0, 0.1777,-0.0156473) , 
1, 1.16801, 1, 0, 0.245527,-0.00150794)    );
  // itree = 1837
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.334228,0.0139392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547619,-0.0152667) , 
1, 1.14215, 1, 0, 0.272775,0.0117155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247706,0.0370904) , 
1, 1.65151, 1, 0, 0.271421,0.00799226)    );
  // itree = 1838
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283375,0.000612557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0553633,-0.0091834) , 
3, 1.12933, 1, 0, 0.248269,-0.00515758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318841,-0.0017369) , 
1, 1.59889, 1, 0, 0.253102,-0.00344831)    );
  // itree = 1839
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0473373,0.0229898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134783,-0.0562518) , 
3, -1.60933, 1, 0, 0.0977444,0.0201782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3292,0.0043573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236167,0.00320609) , 
2, 0.43377, 1, 0, 0.286855,-0.00171327) , 
0, -0.757221, 1, 0, 0.24963,0.00259591)    );
  // itree = 1840
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22549,0.0402365) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121753,-0.0167746) , 
0, -1.75427, 1, 0, 0.129685,-0.00650903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213483,-0.00258033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.589015,0.025587) , 
2, 0.0587752, 1, 0, 0.494334,0.0325252) , 
3, 0.459355, 1, 0, 0.255882,0.00699989)    );
  // itree = 1841
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24986,-0.00558786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0584416,-0.00538527) , 
3, 1.63849, 1, 0, 0.234689,0.00316073) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212963,0.00849198) , 
1, 1.75883, 1, 0, 0.233545,0.000307683)    );
  // itree = 1842
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384058,0.00415068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13253,-0.0188376) , 
3, -0.388717, 1, 0, 0.260709,0.00716314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141243,-0.0154148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305556,-0.0035529) , 
2, 1.35139, 1, 0, 0.182841,-0.00874333) , 
1, 0.946985, 1, 0, 0.233898,0.00168638)    );
  // itree = 1843
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0509259,0.037346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18429,0.00642071) , 
3, -1.32286, 1, 0, 0.131627,0.0273305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154028,0.0174723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360039,-0.000528198) , 
1, -0.0304994, 1, 0, 0.300412,-0.00488395) , 
0, -0.571715, 1, 0, 0.254364,0.00390472)    );
  // itree = 1844
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129827,0.0181736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434109,-0.00486824) , 
3, 0.342084, 1, 0, 0.235231,0.00461148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.422764,0.04925) , 
0, 1.52075, 1, 0, 0.246851,0.00880166)    );
  // itree = 1845
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6,0.0164377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421818,0.00548421) , 
3, -1.10986, 1, 0, 0.504854,0.0227435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189822,0.00605938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.179724,0.00731439) , 
0, 1.31913, 1, 0, 0.188316,-0.0080116) , 
1, -0.414392, 1, 0, 0.271066,2.84458e-05)    );
  // itree = 1846
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333056,0.0032197) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0535055,-0.0253687) , 
3, 0.413315, 1, 0, 0.246127,-0.0141437) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47205,0.00554407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,-0.033312) , 
3, 1.68403, 1, 0, 0.318519,0.0377187) , 
2, 1.4084, 1, 0, 0.255837,-0.00718752)    );
  // itree = 1847
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0682927,0.0294321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138047,0.00204296) , 
3, -0.648085, 1, 0, 0.0975955,-0.020187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0683761,-0.025885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.382253,0.00655872) , 
1, 0.0691391, 1, 0, 0.353763,0.00357532) , 
1, -0.0869251, 1, 0, 0.263026,-0.00484149)    );
  // itree = 1848
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167883,0.0505934) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13706,0.0032045) , 
2, -1.02455, 1, 0, 0.143167,0.00911774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33237,-0.040961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.552288,-0.001662) , 
3, 1.34365, 1, 0, 0.435583,-0.0309572) , 
3, 0.616701, 1, 0, 0.236855,-0.00372201)    );
  // itree = 1849
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319838,-0.00977557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0626398,-0.0132355) , 
1, 1.05254, 1, 0, 0.239721,0.0114317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348571,0.0263963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114943,-0.0273049) , 
1, 0.039416, 1, 0, 0.181967,-0.016986) , 
0, 0.587803, 1, 0, 0.222494,0.00295504)    );
  // itree = 1850
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319638,-0.0012285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120513,-0.00380929) , 
3, 0.756568, 1, 0, 0.277108,0.00733958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0969697,0.0214313) , 
3, 1.69879, 1, 0, 0.26218,0.00388513)    );
  // itree = 1851
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0439771,-0.014398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426941,0.00806214) , 
1, -0.0512315, 1, 0, 0.218522,-0.0117617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135714,-0.0218653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346445,-0.000667309) , 
1, 0.365835, 1, 0, 0.283741,0.0191255) , 
3, -0.0237104, 1, 0, 0.250789,0.00351948)    );
  // itree = 1852
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0451613,-0.00275911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441667,0.0565246) , 
3, -1.61486, 1, 0, 0.218182,0.0310352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254512,0.00481015) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.017366) , 
1, 1.63248, 1, 0, 0.259346,0.00250806) , 
0, -1.03521, 1, 0, 0.253649,0.0064562)    );
  // itree = 1853
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.384298,0.0090536) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138352,-0.0127587) , 
2, -0.0101308, 1, 0, 0.260379,0.00381593) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120968,0.014907) , 
2, 1.77577, 1, 0, 0.252048,2.4965e-05)    );
  // itree = 1854
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.396584,-0.00342397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202341,-0.0116606) , 
3, -0.730312, 1, 0, 0.293333,0.0148425) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0877193,-0.012962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271248,0.00571795) , 
2, 0.330474, 1, 0, 0.201117,-0.0141481) , 
0, 0.2269, 1, 0, 0.252475,0.00199766)    );
  // itree = 1855
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198192,-0.0161026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464286,0.000904689) , 
0, 0.982985, 1, 0, 0.245623,0.00296654) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146154,0.0155526) , 
2, 1.7672, 1, 0, 0.239206,-0.00358693)    );
  // itree = 1856
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269841,0.0205212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136923,-0.0125197) , 
1, -0.95654, 1, 0, 0.158505,-0.00333374) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.623616,0.0432107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445026,-0.00778102) , 
0, 0.999707, 1, 0, 0.549784,0.0333285) , 
3, 0.830113, 1, 0, 0.248262,0.00507636)    );
  // itree = 1857
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347977,-0.000256072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237192,0.00529403) , 
0, 0.423255, 1, 0, 0.306034,-0.00925746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0868486,-0.00284615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,-0.0196098) , 
2, 1.43502, 1, 0, 0.0836299,0.0153001) , 
1, 1.07236, 1, 0, 0.242068,-0.00219434)    );
  // itree = 1858
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283163,-0.00300246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282258,-0.00463283) , 
1, -0.411745, 1, 0, 0.282514,0.00348696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,0.0103517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280303,0.00656759) , 
1, 1.26733, 1, 0, 0.202922,-0.0142195) , 
0, 0.596152, 1, 0, 0.258,-0.00196662)    );
  // itree = 1859
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171088,0.0193745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223386,-0.00842168) , 
0, -0.389285, 1, 0, 0.19367,-0.00942491) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378862,0.00345439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135922,-0.02491) , 
2, 1.71105, 1, 0, 0.344011,0.00774583) , 
0, 0.474519, 1, 0, 0.246455,-0.00339626)    );
  // itree = 1860
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0401235,-0.0438283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332261,0.00879055) , 
3, -0.718234, 1, 0, 0.232152,-0.000897348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338583,-0.0328622) , 
1, 1.65151, 1, 0, 0.23885,-0.00418515)    );
  // itree = 1861
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.425234,0.00166164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22449,0.0189895) , 
1, 0.0771925, 1, 0, 0.362179,-0.0305457) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297634,-0.0100911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104067,-0.00608135) , 
2, 0.349098, 1, 0, 0.198902,0.000997723) , 
0, -0.953749, 1, 0, 0.225013,-0.00404664)    );
  // itree = 1862
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372222,-0.00570532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240042,0.00125151) , 
3, -1.16379, 1, 0, 0.276256,0.00811865) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196923,0.00204283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23192,0.00294598) , 
0, 0.0934825, 1, 0, 0.216253,-0.0127756) , 
1, 0.840541, 1, 0, 0.254902,0.000682739)    );
  // itree = 1863
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234217,-0.00363119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265432,0.00749905) , 
3, 1.41822, 1, 0, 0.237113,-0.0062171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.705357,0.049692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.092437,-0.0104332) , 
3, 1.41219, 1, 0, 0.38961,0.0378096) , 
0, 1.31913, 1, 0, 0.254932,-0.00107286)    );
  // itree = 1864
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0075188,-0.0641151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146,-0.00880239) , 
3, -1.55863, 1, 0, 0.116904,-0.00952094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141509,-0.032624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565705,0.0214635) , 
2, -0.318729, 1, 0, 0.50411,0.0256926) , 
3, 0.471159, 1, 0, 0.258517,0.00335776)    );
  // itree = 1865
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.445946,-0.0203831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233689,0.00636615) , 
3, -1.84129, 1, 0, 0.250818,-0.00114711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,-0.0468942) , 
2, 1.79731, 1, 0, 0.239198,0.00369234)    );
  // itree = 1866
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34127,-0.00528421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28013,0.00413554) , 
0, -0.420895, 1, 0, 0.304965,-0.00617043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875,-0.00965478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0810811,0.0255574) , 
3, 1.75402, 1, 0, 0.0857664,0.0112941) , 
3, 0.766583, 1, 0, 0.247737,-0.00161085)    );
  // itree = 1867
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121693,-0.00624216) , 
0, -0.494884, 1, 0, 0.0603675,0.01371) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547893,0.0424349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.00828238) , 
2, -0.760303, 1, 0, 0.298807,-0.00725142) , 
1, -0.652328, 1, 0, 0.252786,-0.00320568)    );
  // itree = 1868
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255187,0.020591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175224,-0.00846579) , 
1, -0.411745, 1, 0, 0.197776,0.00130235) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.536458,-0.0174805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.538462,-0.0385032) , 
2, 1.43933, 1, 0, 0.537217,-0.0488657) , 
3, 1.26976, 1, 0, 0.249752,-0.00637947)    );
  // itree = 1869
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287892,-0.00274223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21262,0.000954198) , 
0, 0.213324, 1, 0, 0.258134,0.00114928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119403,0.0275116) , 
3, 1.75738, 1, 0, 0.248736,-0.00271184)    );
  // itree = 1870
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260576,0.000120477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0876289,-0.0216694) , 
0, 1.31913, 1, 0, 0.242192,0.00234115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.412844,0.0128528) , 
1, 1.65151, 1, 0, 0.25181,-0.00180042)    );
  // itree = 1871
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266722,0.0123298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190184,-0.00893754) , 
2, 0.499342, 1, 0, 0.257642,-0.00409886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183761,0.016066) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274699,0.00786332) , 
1, 0.648629, 1, 0, 0.241911,-0.0301476) , 
2, 0.704833, 1, 0, 0.252595,-0.0124556)    );
  // itree = 1872
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220903,-0.0185649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26306,0.0144804) , 
0, 0.518813, 1, 0, 0.233463,-0.00675508) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217054,-0.0841229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.381356,0.000626565) , 
1, 1.36731, 1, 0, 0.295547,-0.0363927) , 
2, 1.40023, 1, 0, 0.240958,-0.010333)    );
  // itree = 1873
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.411451,0.00274319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325688,0.0101153) , 
0, 0.657373, 1, 0, 0.392157,0.0113463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126214,0.00606039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147287,-0.012271) , 
1, 1.64509, 1, 0, 0.128788,-0.00842185) , 
1, 0.324332, 1, 0, 0.254815,0.00103756)    );
  // itree = 1874
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4375,-0.0108021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218837,-0.000507026) , 
0, -1.69913, 1, 0, 0.234576,-0.0116328) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330275,-0.00622177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265403,-0.0278344) , 
1, 1.16504, 1, 0, 0.298368,0.0139925) , 
2, 1.0466, 1, 0, 0.248363,-0.00609467)    );
  // itree = 1875
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214992,-0.00212539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550459,0.0213535) , 
3, 0.893392, 1, 0, 0.266061,-0.0109139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356322,0.00144862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115274,-0.00920212) , 
3, 0.827865, 1, 0, 0.235971,0.0109002) , 
2, 0.708843, 1, 0, 0.256229,-0.0037861)    );
  // itree = 1876
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241915,0.00663353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724138,-0.0342174) , 
0, 1.04141, 1, 0, 0.215142,0.000706322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.68,-0.0287718) , 
3, 1.73078, 1, 0, 0.255594,-0.00367344)    );
  // itree = 1877
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318909,0.00455318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916031,0.036229) , 
2, 0.785757, 1, 0, 0.273962,-0.00486966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232727,-0.00244302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130952,-0.0172889) , 
3, 0.433655, 1, 0, 0.171223,0.0198534) , 
0, 0.512761, 1, 0, 0.238614,0.00363653)    );
  // itree = 1878
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212598,-0.033106) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.548077,0.00514268) , 
2, -0.813796, 1, 0, 0.363636,-0.0396486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30333,0.000504223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102102,-0.0124974) , 
3, 0.45656, 1, 0, 0.227912,-0.00859729) , 
0, -1.11841, 1, 0, 0.243526,-0.0121694)    );
  // itree = 1879
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112481,-0.0345123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.358696,0.0163259) , 
0, -0.374506, 1, 0, 0.225645,0.00440908) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651376,0.0924495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243641,-0.0131928) , 
0, -0.30206, 1, 0, 0.295561,-0.0312982) , 
3, 0.116919, 1, 0, 0.25474,-0.0104502)    );
  // itree = 1880
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0305344,-0.0369758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00854701,0.000769416) , 
0, -1.13101, 1, 0, 0.0201613,-0.0116602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410256,0.0380143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311096,0.0126476) , 
1, -0.512346, 1, 0, 0.327048,0.0195872) , 
3, -1.54418, 1, 0, 0.287918,0.0156029)    );
  // itree = 1881
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31831,0.00324379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268053,0.00470063) , 
0, -0.313714, 1, 0, 0.290025,-0.00731293) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0654762,-0.00225274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137615,0.017626) , 
1, 1.34952, 1, 0, 0.0938628,0.0275631) , 
3, 1.29216, 1, 0, 0.261441,-0.00223104)    );
  // itree = 1882
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329287,-0.00519062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272175,0.00379855) , 
0, -0.329323, 1, 0, 0.297571,0.00316789) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0457143,0.0117176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0971787,-0.0313813) , 
1, 0.785813, 1, 0, 0.0789474,-0.0245614) , 
3, 0.839878, 1, 0, 0.242915,-0.00376442)    );
  // itree = 1883
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0748032,0.00535887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321244,-0.00438498) , 
1, -0.426085, 1, 0, 0.2539,0.0044445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253012,0.0197211) , 
2, 1.68193, 1, 0, 0.253827,0.00141334)    );
  // itree = 1884
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252502,-0.00407695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259259,-0.0684109) , 
2, 1.36247, 1, 0, 0.253021,-0.00759605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0114504,-0.0511386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.397351,0.0364925) , 
3, 0.436508, 1, 0, 0.218085,0.0283275) , 
1, 1.14418, 1, 0, 0.243024,0.00268345)    );
  // itree = 1885
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.642202,-0.00326638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236978,-0.00065496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0628931,-0.0196889) , 
2, 1.6544, 1, 0, 0.222455,-0.00749388) , 
1, -1.40737, 1, 0, 0.245161,-0.00509588)    );
  // itree = 1886
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374118,0.00376173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252372,-0.0079571) , 
0, -0.720184, 1, 0, 0.287356,-0.00876004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0330882,-0.0162229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154867,-0.00391738) , 
1, 1.17101, 1, 0, 0.0883534,0.00955643) , 
3, 0.873167, 1, 0, 0.237228,-0.00414618)    );
  // itree = 1887
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0676056,-0.0436078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210059,-0.00630332) , 
3, -0.980252, 1, 0, 0.137085,0.0145697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301181,0.00361505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231928,-0.019595) , 
3, 1.17437, 1, 0, 0.284125,-0.00576329) , 
0, -0.419895, 1, 0, 0.234199,0.00114055)    );
  // itree = 1888
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195079,0.0202961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.027027,-0.0496059) , 
0, 0.544993, 1, 0, 0.160391,0.00939685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314898,-0.0153234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232323,-0.0353044) , 
1, 1.19854, 1, 0, 0.289392,-0.0223139) , 
2, -0.365855, 1, 0, 0.243122,-0.0109399)    );
  // itree = 1889
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283986,0.0044659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225225,0.0685432) , 
1, 1.52775, 1, 0, 0.280455,-0.000365662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841122,-0.00205148) , 
2, 1.7672, 1, 0, 0.269703,0.0028892)    );
  // itree = 1890
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288934,-0.011622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216741,0.00263754) , 
0, -0.659236, 1, 0, 0.236035,-0.00043442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136364,-0.0228891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.478261,0.0578852) , 
1, 1.69516, 1, 0, 0.282528,-0.0472043) , 
1, 1.47236, 1, 0, 0.242005,-0.00643971)    );
  // itree = 1891
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.073913,0.0415368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76,0.0562758) , 
1, -0.252807, 1, 0, 0.37037,-0.0296563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206388,-0.019368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.00452328) , 
2, 0.383986, 1, 0, 0.228691,0.00123169) , 
2, -0.88918, 1, 0, 0.256398,-0.00480871)    );
  // itree = 1892
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.097561,-0.0556018) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271404,0.010938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286624,-0.0225182) , 
1, 1.56185, 1, 0, 0.272679,0.00662143) , 
1, -1.40737, 1, 0, 0.261893,0.00317733)    );
  // itree = 1893
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.51634,0.0129351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269565,0.0155587) , 
1, -0.391749, 1, 0, 0.410448,-0.045057) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227031,-0.00488758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16,-0.00686436) , 
1, 1.58663, 1, 0, 0.221881,0.0069956) , 
0, -1.04167, 1, 0, 0.248549,-0.000365932)    );
  // itree = 1894
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.0144237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.265267,-0.00189929) , 
2, -1.28922, 1, 0, 0.233728,0.0042724) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295168,-0.00876471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116418,0.0114435) , 
3, 1.10627, 1, 0, 0.24864,-0.0178243) , 
1, -0.111799, 1, 0, 0.243505,-0.0102148)    );
  // itree = 1895
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257772,0.00911369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342432,0.00285129) , 
3, 0.838384, 1, 0, 0.275295,-0.0036669) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0280374,-0.051351) , 
1, 1.68097, 1, 0, 0.262415,-0.00552428)    );
  // itree = 1896
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0845361,-0.0353966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0188679,0.0176559) , 
2, -0.212049, 1, 0, 0.0613333,-0.0147952) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479508,0.0336058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371002,0.00322901) , 
0, -0.258102, 1, 0, 0.393401,0.011195) , 
3, -0.502231, 1, 0, 0.264493,0.00110568)    );
  // itree = 1897
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273369,-0.0274397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318818,0.00874353) , 
0, -0.437286, 1, 0, 0.297521,0.0114138) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0263158,-0.0268372) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115702,-0.0136556) , 
0, -0.0269407, 1, 0, 0.0977543,0.0368303) , 
3, 0.436997, 1, 0, 0.220641,0.0211953)    );
  // itree = 1898
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246904,0.000289613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306061,-0.00866515) , 
2, 0.85871, 1, 0, 0.25894,0.00651317) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253968,-0.00231103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13986,-0.0207507) , 
3, 1.3101, 1, 0, 0.212658,-0.036457) , 
1, 1.35807, 1, 0, 0.249876,-0.0019019)    );
  // itree = 1899
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232283,0.0122856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.735043,-0.00290176) , 
0, 1.20262, 1, 0, 0.284201,-0.0021742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280775,0.00236823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0769231,0.00353145) , 
3, 1.62708, 1, 0, 0.239779,-0.0214649) , 
2, 0.324939, 1, 0, 0.264475,-0.0107405)    );
  // itree = 1900
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167286,-0.00313612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484163,0.0291746) , 
3, 1.01253, 1, 0, 0.20545,0.00335801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643192,-0.0217902) , 
3, 1.63045, 1, 0, 0.250977,-0.00094182)    );
  // itree = 1901
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287621,0.00222001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0408163,-0.0194216) , 
3, 1.41822, 1, 0, 0.261388,-0.00399138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.160428,-0.0109887) , 
0, 1.44542, 1, 0, 0.252093,-6.8181e-05)    );
  // itree = 1902
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387838,0.00145796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120283,-0.0284183) , 
3, -0.180603, 1, 0, 0.290378,0.0139853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137421,0.0103798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290909,0.00444943) , 
2, 0.857977, 1, 0, 0.200498,-0.00857348) , 
0, 0.310699, 1, 0, 0.253686,0.00477602)    );
  // itree = 1903
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0517241,-0.0861017) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216346,0.00184934) , 
3, -1.00222, 1, 0, 0.120482,0.0135864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146699,0.00688139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339587,-0.00896918) , 
1, -0.111799, 1, 0, 0.286102,-0.00272132) , 
0, -0.617366, 1, 0, 0.244298,0.00139487)    );
  // itree = 1904
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00925926,-0.0653039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255096,0.00896866) , 
3, -2.19858, 1, 0, 0.24129,0.00551102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345865,-0.0150744) , 
2, 1.7595, 1, 0, 0.248054,0.00390495)    );
  // itree = 1905
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319746,0.00980725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198667,-0.00202286) , 
0, 0.201876, 1, 0, 0.270766,-0.00107865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0810811,-0.00285926) , 
2, 1.80356, 1, 0, 0.260051,-0.00295163)    );
  // itree = 1906
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2713,0.0107861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00371747,-0.0687551) , 
3, 0.237879, 1, 0, 0.209302,-0.000874814) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323204,0.0108995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307692,0.00327502) , 
2, 0.839323, 1, 0, 0.314252,-0.0198685) , 
2, 0.324939, 1, 0, 0.253842,-0.00893558)    );
  // itree = 1907
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150943,-0.0171985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247405,0.00526626) , 
2, -1.00266, 1, 0, 0.217082,-0.000266534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352041,0.0322054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247599,-0.00851921) , 
0, -0.280211, 1, 0, 0.265666,-0.0268505) , 
3, -0.332711, 1, 0, 0.244939,-0.0155092)    );
  // itree = 1908
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256757,0.0468215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22429,-0.000788571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239078,-0.0206067) , 
0, 0.306642, 1, 0, 0.230894,-0.0089174) , 
0, -1.35255, 1, 0, 0.232815,-0.00484655)    );
  // itree = 1909
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.458824,-0.024339) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.43617,0.00485571) , 
1, -0.891157, 1, 0, 0.44921,0.0261298) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,0.00531216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00645228) , 
0, 1.24882, 1, 0, 0.181457,-0.00422957) , 
1, -0.512249, 1, 0, 0.242191,0.00265687)    );
  // itree = 1910
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.021962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173469,0.019496) , 
0, -0.340194, 1, 0, 0.22449,0.0224674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27095,-0.000636477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.046729,-0.0381741) , 
3, 1.56271, 1, 0, 0.241798,-0.00860423) , 
1, -0.843018, 1, 0, 0.239175,-0.00389543)    );
  // itree = 1911
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152338,-0.0111988) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297659,0.00837941) , 
0, -0.394757, 1, 0, 0.235897,-0.00644358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154185,-0.0371283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378601,-0.00161942) , 
1, 1.15104, 1, 0, 0.270213,0.0420865) , 
3, 0.892407, 1, 0, 0.243842,0.00479245)    );
  // itree = 1912
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107855,-0.010328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314286,-0.0320551) , 
3, 0.0028948, 1, 0, 0.179664,-0.0178876) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347902,0.0154665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346821,-0.0141749) , 
0, 1.16219, 1, 0, 0.347651,0.00537606) , 
2, 0.533411, 1, 0, 0.240623,-0.00944559)    );
  // itree = 1913
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.59375,0.00501335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336562,0.0101274) , 
2, -0.7143, 1, 0, 0.442225,-0.0094963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168955,-0.00640827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.087766,-0.00123238) , 
3, 1.02973, 1, 0, 0.145881,0.0101477) , 
1, -0.102501, 1, 0, 0.248518,0.00334415)    );
  // itree = 1914
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344595,-0.0309217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370143,0.00967981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189411,-0.0161405) , 
3, -0.807652, 1, 0, 0.237705,-0.00121942) , 
0, -1.43147, 1, 0, 0.245703,0.00200305)    );
  // itree = 1915
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015,0.0667643) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267218,0.00927704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259411,-0.00312148) , 
3, -0.933534, 1, 0, 0.260965,0.0122514) , 
1, -1.04302, 1, 0, 0.23666,0.00878422)    );
  // itree = 1916
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208038,-0.0108539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.528302,-0.0455035) , 
3, 1.62178, 1, 0, 0.226919,-0.0125282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39,0.0169908) , 
2, 1.53858, 1, 0, 0.243243,-0.00905752)    );
  // itree = 1917
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.483516,-0.00514181) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735294,0.00616817) , 
1, 0.915844, 1, 0, 0.40176,0.0177544) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242775,0.00559646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122785,0.000109306) , 
1, 0.459525, 1, 0, 0.170359,-0.0121247) , 
2, -0.385597, 1, 0, 0.249623,-0.00188989)    );
  // itree = 1918
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259179,0.00510326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0145773,-0.058397) , 
3, -0.667266, 1, 0, 0.155087,0.00410646) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335766,0.0012001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0992908,0.00457593) , 
3, 1.71573, 1, 0, 0.308812,-0.00882561) , 
2, -0.204072, 1, 0, 0.248164,-0.00372368)    );
  // itree = 1919
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206006,-0.00816575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409471,0.00809701) , 
0, 0.70993, 1, 0, 0.24679,-0.00504331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329897,-0.0134984) , 
0, 1.3861, 1, 0, 0.254912,-0.00144015)    );
  // itree = 1920
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194863,-0.011831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.357271,0.0218295) , 
2, 0.506638, 1, 0, 0.248517,6.70358e-06) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275229,0.124177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.51497,0.0328676) , 
3, 0.761923, 1, 0, 0.322464,0.0436668) , 
0, 1.24882, 1, 0, 0.258919,0.0061485)    );
  // itree = 1921
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30791,-0.00440315) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286616,0.00206094) , 
0, -0.264766, 1, 0, 0.296667,0.00692707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,0.00740582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111498,-0.000304793) , 
2, 0.736615, 1, 0, 0.109015,0.0305134) , 
3, 0.883159, 1, 0, 0.251391,0.0126179)    );
  // itree = 1922
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.466667,0.027889) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105431,-0.0239856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312351,0.0103459) , 
2, -0.364449, 1, 0, 0.243488,0.0046665) , 
3, -2.16651, 1, 0, 0.255287,0.00248642)    );
  // itree = 1923
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0111732,-0.0288673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.132,0.0413673) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302505,-0.00156074) , 
1, -0.470955, 1, 0, 0.278915,0.00628016) , 
1, -1.07868, 1, 0, 0.254783,0.00311141)    );
  // itree = 1924
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00699301,-0.0656361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151461,0.00283298) , 
3, -1.83918, 1, 0, 0.13522,-0.00167354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473002,-0.0265108) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401639,0.00215385) , 
0, 1.00347, 1, 0, 0.448373,-0.0237709) , 
3, 0.422166, 1, 0, 0.247094,-0.00956785)    );
  // itree = 1925
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431053,0.00757049) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.16129,0.00647473) , 
3, 0.255371, 1, 0, 0.373824,-0.00185955) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112971,-0.00349304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0196681) , 
0, 1.45406, 1, 0, 0.116788,-0.0250157) , 
2, 0.324939, 1, 0, 0.267705,-0.0114197)    );
  // itree = 1926
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378417,0.00824391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206259,0.0141382) , 
0, -0.075678, 1, 0, 0.291846,-0.0102928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196937,-0.00977303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0797546,-0.02166) , 
3, 1.38144, 1, 0, 0.166129,0.0167058) , 
1, 1.03062, 1, 0, 0.253221,-0.00199788)    );
  // itree = 1927
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0774569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280114,0.00901814) , 
0, -1.54036, 1, 0, 0.256527,-0.00145416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.203008,-0.001609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283069,-0.0247834) , 
1, 0.537667, 1, 0, 0.262231,0.0235508) , 
3, 0.853537, 1, 0, 0.257954,0.00480014)    );
  // itree = 1928
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.045045,-0.0178849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.415094,0.0319302) , 
3, -1.59545, 1, 0, 0.225806,0.0196766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181509,-0.0168514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.611888,0.00697968) , 
3, 1.2614, 1, 0, 0.251565,-0.00898099) , 
1, -1.02829, 1, 0, 0.248734,-0.00583068)    );
  // itree = 1929
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28432,-0.00158162) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0590551,-0.0235201) , 
3, 1.20855, 1, 0, 0.254094,0.00340233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105769,0.0174027) , 
2, 1.76296, 1, 0, 0.24637,-0.000175104)    );
  // itree = 1930
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416058,-0.00191314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242009,-0.00447291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0544413,-0.0286465) , 
3, 1.20628, 1, 0, 0.207226,0.00793304) , 
0, -1.39419, 1, 0, 0.221397,0.0107006)    );
  // itree = 1931
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0129032,0.00990377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277714,-0.000780416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0327869,-0.0528785) , 
1, 1.6523, 1, 0, 0.261752,-0.012762) , 
1, -1.19679, 1, 0, 0.242723,-0.00840622)    );
  // itree = 1932
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167257,0.0130949) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.507389,-0.0194815) , 
3, 0.821581, 1, 0, 0.243258,0.000630488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.379085,0.0291458) , 
1, 1.54903, 1, 0, 0.253807,0.00373782)    );
  // itree = 1933
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285093,0.00473985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168421,0.0037843) , 
0, 1.25722, 1, 0, 0.272778,-0.00170689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0583333,-0.0192138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.059322,-0.0456534) , 
2, 1.30497, 1, 0, 0.0588235,0.0298778) , 
3, 1.55447, 1, 0, 0.247792,0.00198161)    );
  // itree = 1934
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,0.0024186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109244,0.0407682) , 
3, 1.44183, 1, 0, 0.262251,-0.00759261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.056962,-0.0174558) , 
3, 1.76021, 1, 0, 0.246154,-0.00416324)    );
  // itree = 1935
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.077353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271012,-0.00452945) , 
1, -1.45434, 1, 0, 0.255663,-0.000871957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162651,0.0452896) , 
3, 1.74551, 1, 0, 0.24802,-0.00587692)    );
  // itree = 1936
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156463,-0.0305912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172932,-0.0674568) , 
1, -0.366698, 1, 0, 0.164286,-0.0410463) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247382,0.0113239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256989,-0.0142023) , 
0, 0.119488, 1, 0, 0.252656,-0.00335571) , 
0, -0.98707, 1, 0, 0.240122,-0.0087019)    );
  // itree = 1937
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370968,0.00256873) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.491304,0.022349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174963,-0.000628446) , 
1, -0.363096, 1, 0, 0.254655,0.00343891) , 
0, -1.41342, 1, 0, 0.262051,0.00708164)    );
  // itree = 1938
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.404959,-0.0202731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238662,-0.00451635) , 
0, -1.45648, 1, 0, 0.252387,0.00561608) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183486,0.0198537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164706,-0.00289142) , 
0, 1.44559, 1, 0, 0.177062,-0.0159986) , 
0, 0.823646, 1, 0, 0.233316,0.00014359)    );
  // itree = 1939
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0168067,0.0975042) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,0.130272) , 
2, -1.08812, 1, 0, 0.0606061,-0.0399774) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112245,-0.00966506) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310868,-0.00427908) , 
1, -0.59222, 1, 0, 0.289745,0.00134326) , 
1, -0.996791, 1, 0, 0.264224,-0.003259)    );
  // itree = 1940
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165899,0.0169987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0938547,-0.0207494) , 
1, -0.445508, 1, 0, 0.117381,-0.00279556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.681818,0.0406624) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449462,0.00613717) , 
1, 0.363169, 1, 0, 0.50727,0.0216461) , 
3, 0.600992, 1, 0, 0.241273,0.00497107)    );
  // itree = 1941
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424812,-0.0149582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22924,0.000815661) , 
3, -1.54559, 1, 0, 0.255567,0.00999605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,0.00585286) , 
1, 1.7097, 1, 0, 0.25144,0.00555689)    );
  // itree = 1942
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304397,0.00137599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0450607,-0.0362631) , 
3, -0.103537, 1, 0, 0.202186,0.00479563) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544715,0.00346281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189911,0.0100091) , 
3, 0.523181, 1, 0, 0.339623,-0.0260891) , 
2, 0.70608, 1, 0, 0.241329,-0.00400055)    );
  // itree = 1943
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0568182,-0.017726) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162055,-0.00509203) , 
3, 0.0281018, 1, 0, 0.0846395,0.0232609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459906,0.0106389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239024,0.001202) , 
2, 1.43078, 1, 0, 0.416904,-0.00366785) , 
1, 0.324332, 1, 0, 0.258706,0.00915344)    );
  // itree = 1944
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219758,0.000962289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0433071,-0.0417339) , 
0, 1.11449, 1, 0, 0.19403,-0.00286703) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.632075,-0.00506553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.72,0.0264655) , 
0, 1.17936, 1, 0, 0.674757,0.023389) , 
3, 1.61709, 1, 0, 0.244867,-9.04716e-05)    );
  // itree = 1945
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.559524,-0.00164208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.383178,-0.01559) , 
3, -1.37897, 1, 0, 0.460733,0.028257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236264,0.00467424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0685714,-0.00757255) , 
2, 1.18953, 1, 0, 0.200123,-0.000760559) , 
1, -0.652328, 1, 0, 0.249751,0.00476522)    );
  // itree = 1946
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231669,0.00592573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313008,-0.000752677) , 
2, 0.688794, 1, 0, 0.254228,0.000723304) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116505,0.019862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371901,0.0106123) , 
2, 0.899472, 1, 0, 0.254464,-0.037067) , 
1, 1.47236, 1, 0, 0.254254,-0.00351345)    );
  // itree = 1947
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274286,-0.00481704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246858,-0.000868056) , 
2, -0.327083, 1, 0, 0.257442,-0.0016335) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232558,-0.00566213) , 
1, 1.52775, 1, 0, 0.255287,0.00376665)    );
  // itree = 1948
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207746,0.0362236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198083,-0.00679576) , 
0, -1.01584, 1, 0, 0.199567,0.000177398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.778481,0.0428071) , 
3, 1.73078, 1, 0, 0.245142,0.00623773)    );
  // itree = 1949
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.407767,0.00885852) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403101,0.00807092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231585,-0.00281711) , 
0, -1.21167, 1, 0, 0.243103,-0.00262571) , 
0, -1.66956, 1, 0, 0.251482,-0.000336581)    );
  // itree = 1950
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197391,-0.00311569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.42959,0.00594175) , 
2, 0.375794, 1, 0, 0.273524,0.00513999) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0306514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116959,-0.00708055) , 
0, 0.991211, 1, 0, 0.0782313,0.0411925) , 
3, 1.30934, 1, 0, 0.244888,0.0104265)    );
  // itree = 1951
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190871,-0.0140269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40884,0.00181934) , 
3, 0.190601, 1, 0, 0.250377,0.0113453) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442478,0.0301635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225681,-0.000697288) , 
0, -0.395089, 1, 0, 0.264753,-0.0121039) , 
2, 0.68168, 1, 0, 0.254992,0.00381705)    );
  // itree = 1952
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0677966,0.000605414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305556,-0.0542485) , 
3, -1.06355, 1, 0, 0.157895,-0.0270142) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172353,0.00603103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561866,0.0193553) , 
3, 0.802894, 1, 0, 0.289731,0.0116609) , 
1, -0.843018, 1, 0, 0.270172,0.00592303)    );
  // itree = 1953
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.535714,-0.00212997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312034,-0.00210858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.117647,-0.000484687) , 
1, 0.554769, 1, 0, 0.21594,0.0106762) , 
1, -1.0512, 1, 0, 0.246469,0.00747782)    );
  // itree = 1954
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.370968,0.0238364) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0862069,-0.0274007) , 
3, -1.59105, 1, 0, 0.204698,0.0489625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2447,-0.00229434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312057,0.00999192) , 
1, 1.58625, 1, 0, 0.25,0.00228281) , 
1, -0.840753, 1, 0, 0.243541,0.00893858)    );
  // itree = 1955
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231539,0.0190327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266219,-0.00235717) , 
3, -0.463203, 1, 0, 0.249852,0.00575482) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37788,0.0399447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0884956,-0.0163132) , 
1, 1.45641, 1, 0, 0.278788,-0.0237225) , 
3, 1.29216, 1, 0, 0.254572,0.000946354)    );
  // itree = 1956
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0485437,-0.014519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38959,0.0131921) , 
3, -1.07173, 1, 0, 0.277837,0.00820593) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252336,-0.0447621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192575,-0.00812904) , 
1, 0.493548, 1, 0, 0.199174,-0.0113356) , 
1, 0.324332, 1, 0, 0.237971,-0.00169769)    );
  // itree = 1957
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481343,-0.0193888) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.00681394) , 
2, -1.02455, 1, 0, 0.29454,-0.0019487) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0227273,-0.0323101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114894,-0.0119193) , 
0, 0.0591131, 1, 0, 0.0946844,0.0182345) , 
3, 0.613245, 1, 0, 0.234203,0.00414472)    );
  // itree = 1958
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.329258,0.00577068) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2846,0.00748541) , 
1, 0.752854, 1, 0, 0.31544,0.010765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.062069,-0.00194366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.148148,0.0200603) , 
0, 1.22905, 1, 0, 0.0929204,-0.0296608) , 
3, 0.951289, 1, 0, 0.267773,0.0021051)    );
  // itree = 1959
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.231076,0.0435961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276801,-0.00382775) , 
3, -0.974305, 1, 0, 0.262805,-0.000500972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.462687,0.0833608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.156757,-0.0145483) , 
0, 0.785341, 1, 0, 0.285266,-0.0347852) , 
3, 1.20529, 1, 0, 0.266462,-0.00608376)    );
  // itree = 1960
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238636,-0.00561923) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264151,-0.0508806) , 
2, 1.38147, 1, 0, 0.240423,-0.00764404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0342466,-0.0539103) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.347826,0.0474348) , 
2, 0.348714, 1, 0, 0.233083,0.0255498) , 
1, 1.29547, 1, 0, 0.238892,-0.000720698)    );
  // itree = 1961
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37201,0.00589902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209135,0.00157911) , 
3, -0.416743, 1, 0, 0.290767,0.00338129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,0.0101444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204678,0.0507303) , 
0, 1.04074, 1, 0, 0.122024,-0.0463439) , 
3, 1.26976, 1, 0, 0.262475,-0.00495587)    );
  // itree = 1962
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205052,-0.00543248) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390977,0.0139881) , 
2, 0.683145, 1, 0, 0.257721,-0.00315227) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0636364,-0.0163532) , 
3, 1.98947, 1, 0, 0.246982,0.000395875)    );
  // itree = 1963
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0235849,-0.0511059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.437901,0.00428205) , 
1, 0.388902, 1, 0, 0.240741,-0.00982684) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.784314,0.0392788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165468,-0.0408417) , 
3, 0.854644, 1, 0, 0.427386,0.0454962) , 
0, 1.32355, 1, 0, 0.262976,-0.0032362)    );
  // itree = 1964
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0121951,-0.0503849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348792,0.0205644) , 
3, -1.51898, 1, 0, 0.284153,0.0130483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0956679,-0.00795105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476744,-0.0452527) , 
3, 1.44553, 1, 0, 0.18595,-0.0251467) , 
1, 0.879105, 1, 0, 0.24863,-0.000768142)    );
  // itree = 1965
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.427012,0.00290262) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178038,0.0111929) , 
2, -0.122647, 1, 0, 0.287253,-0.00614633) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179592,0.00355414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940171,-0.0309151) , 
3, 1.67974, 1, 0, 0.151934,0.0180751) , 
0, 1.11463, 1, 0, 0.263158,-0.00183341)    );
  // itree = 1966
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261948,-0.00418807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0268817,0.00567418) , 
3, 1.44064, 1, 0, 0.238173,0.00909913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452991,0.026572) , 
2, 1.7672, 1, 0, 0.251022,0.00630056)    );
  // itree = 1967
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152104,-0.0272562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.337793,0.0316817) , 
3, 0.688387, 1, 0, 0.188274,-0.00832358) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.715026,0.044591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261128,-0.00901009) , 
3, 0.43388, 1, 0, 0.426415,0.0173918) , 
0, 0.807511, 1, 0, 0.249395,-0.00172351)    );
  // itree = 1968
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.147666,-0.00522496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361345,0.0254186) , 
3, 0.519696, 1, 0, 0.191544,0.00294392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284404,-0.0347112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36253,0.000369871) , 
2, 1.01615, 1, 0, 0.322314,-0.019914) , 
2, 0.332, 1, 0, 0.24676,-0.00670748)    );
  // itree = 1969
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553398,-0.0280281) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45098,-0.0147805) , 
3, -1.6674, 1, 0, 0.502439,0.0297559) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.23957,0.0104155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120773,-0.00829168) , 
0, 1.32355, 1, 0, 0.225824,-0.00345888) , 
1, -1.08065, 1, 0, 0.254263,-4.4124e-05)    );
  // itree = 1970
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.42471,0.00327505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291777,-0.00492413) , 
0, -1.06098, 1, 0, 0.345912,0.00687848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119266,-0.00759576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229902,0.0025951) , 
1, -0.970395, 1, 0, 0.221528,-0.00914137) , 
0, -0.479386, 1, 0, 0.259634,-0.00423355)    );
  // itree = 1971
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.00133031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.715596,0.0233663) , 
1, -0.0735198, 1, 0, 0.33218,0.013161) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.116099,0.0126505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.345818,0.00146256) , 
1, 0.519178, 1, 0, 0.243262,-0.00971601) , 
2, -0.570484, 1, 0, 0.268642,-0.00318616)    );
  // itree = 1972
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168697,-0.0119882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0386608) , 
3, 1.12826, 1, 0, 0.182981,-0.0130336) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.642487,0.0098303) , 
3, 1.65635, 1, 0, 0.227524,-0.010199)    );
  // itree = 1973
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.363958,0.00286544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258824,0.00130373) , 
3, -0.374511, 1, 0, 0.328885,2.70386e-05) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221402,0.0249056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0754717,-0.00715297) , 
3, 0.976894, 1, 0, 0.132374,-0.0203394) , 
3, 0.422986, 1, 0, 0.259523,-0.00716174)    );
  // itree = 1974
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287089,0.000477006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18018,-0.014477) , 
0, 0.381303, 1, 0, 0.278351,-0.00687602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232381,0.00997812) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0923077,0.0398049) , 
3, 1.64518, 1, 0, 0.20458,-0.0222671) , 
0, 0.559892, 1, 0, 0.254347,-0.0118841)    );
  // itree = 1975
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0752275) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,0.0654576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282852,-0.000366781) , 
1, -1.0067, 1, 0, 0.266055,0.000995398) , 
3, -1.92411, 1, 0, 0.246994,-0.000984368)    );
  // itree = 1976
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240484,-0.00682892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826446,-0.0695082) , 
0, 0.78201, 1, 0, 0.213162,-0.0159359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0692913,-0.0109005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.465753,0.0206515) , 
3, 0.369845, 1, 0, 0.259229,0.0113418) , 
1, -0.0488099, 1, 0, 0.24244,0.00140065)    );
  // itree = 1977
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397075,-0.0032224) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106719,-0.0337167) , 
3, 0.235708, 1, 0, 0.33275,0.0156408) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12528,0.0237532) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122596,-0.0128539) , 
0, 0.541772, 1, 0, 0.123986,-0.0117613) , 
2, 0.339778, 1, 0, 0.242893,0.00384629)    );
  // itree = 1978
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312303,0.00425713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0674847,-0.0243839) , 
3, -0.601003, 1, 0, 0.229167,0.0204454) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43128,0.00675211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208267,-0.00249652) , 
0, -0.794046, 1, 0, 0.2403,0.00234375) , 
1, -0.409525, 1, 0, 0.237558,0.00680181)    );
  // itree = 1979
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217933,-0.000812041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29,-0.0260746) , 
3, 1.59407, 1, 0, 0.222157,0.00749694) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688525,0.00463823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25625,0.0053447) , 
2, 0.609584, 1, 0, 0.443262,-0.0278196) , 
0, 1.22394, 1, 0, 0.253521,0.00248726)    );
  // itree = 1980
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19697,0.0229229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0697941,-0.0218479) , 
1, -0.955531, 1, 0, 0.099297,-0.00262897) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423926,0.0164508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407407,-0.0202091) , 
0, 1.56834, 1, 0, 0.422085,0.0146137) , 
3, -0.0186245, 1, 0, 0.247746,0.00530083)    );
  // itree = 1981
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410364,-0.00205191) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195548,-0.0133005) , 
3, -0.24606, 1, 0, 0.309754,0.0198322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0926641,-0.00694356) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0963855,0.000425677) , 
3, 1.38678, 1, 0, 0.0935673,-0.00126444) , 
1, 0.921611, 1, 0, 0.236803,0.0127132)    );
  // itree = 1982
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323851,0.000530168) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165644,-0.00109548) , 
0, -0.291744, 1, 0, 0.242072,0.00904172) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230465,-0.00561169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,0.0308361) , 
1, 1.62505, 1, 0, 0.246708,-0.00970401) , 
1, 0.22651, 1, 0, 0.244604,-0.00119875)    );
  // itree = 1983
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158965,-0.0245048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391952,0.011109) , 
0, 0.271021, 1, 0, 0.248146,-0.00248888) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319672,-0.0492021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123894,-0.0152687) , 
0, 1.17936, 1, 0, 0.225532,0.043953) , 
3, 1.52344, 1, 0, 0.245473,0.00300098)    );
  // itree = 1984
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277228,0.0619458) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.307116,0.0134298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22723,-0.00778431) , 
1, 0.302097, 1, 0, 0.261522,0.00190874) , 
0, -1.2692, 1, 0, 0.263056,0.00762)    );
  // itree = 1985
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.394231,-0.00307562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280822,-0.0059608) , 
0, -1.75427, 1, 0, 0.28914,0.00288472) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0651042,-0.0132917) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141791,-0.0104454) , 
0, 1.34902, 1, 0, 0.0849421,0.0336628) , 
3, 0.766583, 1, 0, 0.234504,0.0111197)    );
  // itree = 1986
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140741,-0.0288097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258373,0.0166954) , 
2, -0.549525, 1, 0, 0.192067,0.0153392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.304622,0.00361611) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152642,-0.0238217) , 
1, 1.2149, 1, 0, 0.251538,-0.0112368) , 
1, -0.363096, 1, 0, 0.236869,-0.00468175)    );
  // itree = 1987
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217257,0.0153454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20438,-0.017321) , 
3, -0.731741, 1, 0, 0.210645,0.00728082) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.368715,0.0216793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,-0.077401) , 
1, 1.54097, 1, 0, 0.313756,-0.0267513) , 
3, 0.525776, 1, 0, 0.244321,-0.00383416)    );
  // itree = 1988
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186747,-0.0374503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2661,0.00444894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235119,-0.0169054) , 
1, 1.36335, 1, 0, 0.260149,-0.000291098) , 
0, -1.39419, 1, 0, 0.253786,-0.00304573)    );
  // itree = 1989
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.31557,0.00424762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0275229,0.0022746) , 
3, 1.09438, 1, 0, 0.291603,-0.00779114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200772,-0.0144689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205703,0.0113318) , 
0, 0.874323, 1, 0, 0.204,0.0162039) , 
0, 0.474519, 1, 0, 0.259709,0.000944924)    );
  // itree = 1990
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299483,0.00167193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100806,-0.00498171) , 
3, 0.770619, 1, 0, 0.272018,0.00155234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0878614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147929,0.0372665) , 
2, 0.88807, 1, 0, 0.0902527,-0.0298129) , 
3, 1.36188, 1, 0, 0.247706,-0.00264281)    );
  // itree = 1991
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00704225,0.0122726) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208827,-0.0150616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328236,0.00650027) , 
0, 0.105344, 1, 0, 0.270157,0.00740918) , 
1, -1.26922, 1, 0, 0.251949,0.0109577)    );
  // itree = 1992
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188166,-0.00134521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613636,0.0194485) , 
3, 1.34913, 1, 0, 0.237173,0.00290701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.384615,-0.0386302) , 
1, 1.65151, 1, 0, 0.244787,-0.000525953)    );
  // itree = 1993
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434343,0.0135259) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252205,0.00527637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.019469) , 
3, 1.80979, 1, 0, 0.238928,-0.0138012) , 
0, -1.26434, 1, 0, 0.258017,-0.0101549)    );
  // itree = 1994
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.417085,0.0044896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322751,0.0155015) , 
0, -1.17984, 1, 0, 0.371134,-0.0189238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249042,0.00413441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0416667,-0.0524277) , 
3, 1.43517, 1, 0, 0.214149,0.00782075) , 
0, -0.784322, 1, 0, 0.245273,0.0025183)    );
  // itree = 1995
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0755887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215586,-0.00305865) , 
0, -1.7049, 1, 0, 0.201224,0.0158494) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.53268,0.00818872) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204969,0.0330647) , 
3, 1.38144, 1, 0, 0.4197,-0.0200447) , 
0, 0.886294, 1, 0, 0.25387,0.00719999)    );
  // itree = 1996
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0245902,-0.0273397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2469,0.0162315) , 
3, -1.41696, 1, 0, 0.198939,0.00899257) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218989,-0.0211142) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.752874,0.00858895) , 
3, 1.59035, 1, 0, 0.331318,-0.0112841) , 
2, 0.349516, 1, 0, 0.254852,0.000428313)    );
  // itree = 1997
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.570175,0.00177747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296828,0.00341726) , 
3, -1.95182, 1, 0, 0.318498,0.00300551) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0812808,-0.000148815) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139706,0.0512952) , 
3, 1.69174, 1, 0, 0.095941,-0.0189723) , 
2, 0.845279, 1, 0, 0.257576,-0.00301063)    );
  // itree = 1998
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330661,0.00814028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0593607,-0.031881) , 
3, -0.195422, 1, 0, 0.247911,0.0200215) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308442,-0.00518056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239482,0.00113226) , 
1, 0.450386, 1, 0, 0.25668,-0.00183954) , 
1, -0.0028156, 1, 0, 0.253456,0.00619743)    );
  // itree = 1999
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212819,-0.0105999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292308,0.0501025) , 
3, 1.35364, 1, 0, 0.221421,-0.00109026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,-0.0204142) , 
0, 1.44547, 1, 0, 0.228762,0.00283576)    );
  // itree = 2000
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117794,-0.00826354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.567376,0.0217057) , 
3, -0.147545, 1, 0, 0.303965,0.00851108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0586907,-0.000765914) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.401639,-0.0322794) , 
3, 0.95146, 1, 0, 0.180495,-0.0216783) , 
1, 0.924475, 1, 0, 0.262567,-0.00161097)    );
  // itree = 2001
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420918,-0.0166313) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279012,0.00481251) , 
3, -0.996892, 1, 0, 0.325291,0.0153398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105498,0.00212679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18705,0.00630585) , 
0, 1.0879, 1, 0, 0.119458,-0.00834216) , 
1, 0.770164, 1, 0, 0.242304,0.00579174)    );
  // itree = 2002
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158879,-0.01621) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314576,0.00335832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0831354,-0.00891373) , 
3, 0.953956, 1, 0, 0.263186,-0.00303182) , 
1, -1.36088, 1, 0, 0.257614,-5.5142e-06)    );
  // itree = 2003
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229885,0.00941435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302521,-0.00577069) , 
3, -0.204472, 1, 0, 0.267838,0.0158845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107438,-0.00427383) , 
2, 1.77922, 1, 0, 0.257849,0.012779)    );
  // itree = 2004
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0268456,-0.0675921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302041,0.0560803) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253999,-0.00294788) , 
0, -0.942351, 1, 0, 0.260509,0.00409034) , 
2, -1.55518, 1, 0, 0.242718,0.00158752)    );
  // itree = 2005
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32153,0.00193871) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.11418,-0.00357768) , 
3, 0.54378, 1, 0, 0.263939,0.00290601) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104762,-0.000748769) , 
2, 1.85125, 1, 0, 0.255825,-0.000796501)    );
  // itree = 2006
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349662,0.00926023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.030888,-0.0622092) , 
3, -0.166602, 1, 0, 0.252644,0.00594192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.29148,0.00335118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0805687,-0.00231857) , 
3, 1.60402, 1, 0, 0.251133,-0.0116601) , 
1, 0.150194, 1, 0, 0.251791,-0.00399412)    );
  // itree = 2007
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228234,-0.00689928) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.409449,0.0326631) , 
3, 1.48092, 1, 0, 0.241499,-0.000833942) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.468085,0.0167739) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0461538,-0.0437319) , 
3, 1.32461, 1, 0, 0.265683,0.0301378) , 
2, 1.40023, 1, 0, 0.244766,0.00335018)    );
  // itree = 2008
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.00977579) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54321,0.0348604) , 
3, -0.404194, 1, 0, 0.248996,0.0107423) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3,-0.0535377) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214596,-0.0105834) , 
1, 0.125034, 1, 0, 0.221423,-0.0115679) , 
1, -0.0276337, 1, 0, 0.231732,-0.00322673)    );
  // itree = 2009
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299663,0.00838436) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.00640521) , 
0, 1.22394, 1, 0, 0.276063,-0.000589204) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126667,-0.018325) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110429,0.0239243) , 
2, 0.986397, 1, 0, 0.118211,-0.0388822) , 
1, 1.41904, 1, 0, 0.251724,-0.0064935)    );
  // itree = 2010
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.155172,-0.00135146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292574,0.00720922) , 
1, -1.35371, 1, 0, 0.283075,0.000523413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0965517,-0.0294935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0544218,-0.0266143) , 
3, 1.73843, 1, 0, 0.0753425,0.0417632) , 
3, 1.29216, 1, 0, 0.252284,0.00663611)    );
  // itree = 2011
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235821,0.00609223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.481328,0.00228138) , 
0, 1.22394, 1, 0, 0.266701,0.00584328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0819613) , 
1, 1.7097, 1, 0, 0.25272,0.00191464)    );
  // itree = 2012
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241279,0.0272881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241107,-0.00330838) , 
0, -0.908075, 1, 0, 0.241139,0.00221788) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342593,-0.0533606) , 
0, 1.54066, 1, 0, 0.246701,-0.00292855)    );
  // itree = 2013
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403361,0.0114387) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305085,0.0175133) , 
0, -1.07547, 1, 0, 0.333333,-0.0181779) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238037,-0.00544793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0862069,-0.0149418) , 
3, 1.0479, 1, 0, 0.192605,0.0144147) , 
0, -0.179217, 1, 0, 0.25113,0.000860373)    );
  // itree = 2014
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701754,-0.0405895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284314,0.00594163) , 
2, -1.6481, 1, 0, 0.270332,0.011276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209877,-0.00303646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176166,-0.00909814) , 
3, 0.561328, 1, 0, 0.191549,-0.0186742) , 
1, 1.35807, 1, 0, 0.25702,0.00621541)    );
  // itree = 2015
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388379,0.0454326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263415,0.00515517) , 
2, -1.06262, 1, 0, 0.340226,0.00987645) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218543,-0.00883039) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232747,-0.00854757) , 
2, 0.505396, 1, 0, 0.225569,-0.0100305) , 
2, -0.632281, 1, 0, 0.255676,-0.00480319)    );
  // itree = 2016
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214575,0.00780188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192661,-0.0609808) , 
0, -0.073369, 1, 0, 0.207865,-0.0160107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221585,0.0213263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321252,-0.0050476) , 
2, 0.718852, 1, 0, 0.258162,0.00940666) , 
1, -0.695692, 1, 0, 0.249254,0.00490488)    );
  // itree = 2017
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432653,0.000847479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,0.0551933) , 
3, -1.00234, 1, 0, 0.385269,-0.0338613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259542,-0.00360046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222548,0.00272998) , 
0, -0.531907, 1, 0, 0.228501,1.74559e-05) , 
0, -0.906156, 1, 0, 0.256436,-0.0060195)    );
  // itree = 2018
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256643,-0.00561984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0176471,-0.00532016) , 
3, 1.52423, 1, 0, 0.234392,0.00537876) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304,-0.0305394) , 
2, 1.76374, 1, 0, 0.238852,0.0101218)    );
  // itree = 2019
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0507042,-0.0302395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.151515,0.0109688) , 
2, -0.0193346, 1, 0, 0.0726872,0.017485) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.108911,-0.0198918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335735,0.00533732) , 
1, -0.266043, 1, 0, 0.320349,-0.00133607) , 
1, -0.469325, 1, 0, 0.262481,0.00306166)    );
  // itree = 2020
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0208333,-0.0356169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.57377,0.0547742) , 
3, -1.64496, 1, 0, 0.274436,0.0297334) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767544,-0.0257896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449649,0.00662982) , 
3, 0.229216, 1, 0, 0.257078,-0.00234089) , 
0, -1.09323, 1, 0, 0.25935,0.00185782)    );
  // itree = 2021
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.328921,0.0121444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582524,-0.0145153) , 
3, 1.44734, 1, 0, 0.311648,0.00725725) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.00690318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109756,-0.00810549) , 
0, 1.00618, 1, 0, 0.0789474,-0.0224147) , 
2, 1.092, 1, 0, 0.267302,0.00160263)    );
  // itree = 2022
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453782,0.0128562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262843,0.00269854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.00881586) , 
3, 1.62295, 1, 0, 0.240977,0.00861414) , 
3, -1.95723, 1, 0, 0.25362,0.00687242)    );
  // itree = 2023
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255083,0.0312715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194495,-0.01189) , 
3, -0.949957, 1, 0, 0.224678,-0.00510843) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279693,-0.0164796) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218935,-0.00319469) , 
1, 1.49503, 1, 0, 0.268908,0.0237313) , 
3, -0.0237104, 1, 0, 0.245339,0.0083633)    );
  // itree = 2024
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185304,-0.00489937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.565891,0.0166044) , 
3, 0.75573, 1, 0, 0.250331,0.00132359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0352941,-0.0614427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.342949,-0.00180891) , 
2, 0.299405, 1, 0, 0.23444,-0.0159345) , 
0, 0.886294, 1, 0, 0.246486,-0.00285232)    );
  // itree = 2025
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38313,-0.00156903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0447761,-0.0395813) , 
3, 0.774901, 1, 0, 0.342576,-0.00247625) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184615,-0.0141228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103311,-0.00154143) , 
2, 0.49759, 1, 0, 0.115254,0.0128485) , 
2, 0.322406, 1, 0, 0.242137,0.00429479)    );
  // itree = 2026
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185393,0.00417997) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321663,-0.0167892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244412,0.00803645) , 
0, -0.635056, 1, 0, 0.263557,-0.00131152) , 
1, -1.19679, 1, 0, 0.256677,0.0038688)    );
  // itree = 2027
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0128755,-0.0745292) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274194,0.00286112) , 
1, -0.89073, 1, 0, 0.22449,-0.0042609) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27593,-0.0120648) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253012,0.0140844) , 
3, 1.46134, 1, 0, 0.268421,0.0188092) , 
3, 0.356731, 1, 0, 0.24131,0.00457198)    );
  // itree = 2028
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13488,-0.00772082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488372,0.012722) , 
3, 0.423202, 1, 0, 0.230238,0.00104496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259615,-0.0422393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344633,0.00412196) , 
2, 1.59156, 1, 0, 0.298701,-0.017789) , 
2, 1.03387, 1, 0, 0.243557,-0.00261905)    );
  // itree = 2029
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00809471) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318966,0.0446601) , 
3, -1.61797, 1, 0, 0.419847,-0.0304341) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227328,-0.00809254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167702,-0.00890141) , 
0, 1.44734, 1, 0, 0.221974,0.00399244) , 
0, -1.07672, 1, 0, 0.247202,-0.000396737)    );
  // itree = 2030
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284621,0.0103107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.0230762) , 
1, 0.965567, 1, 0, 0.284727,-0.00857581) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239554,0.0291562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107914,0.00017692) , 
3, 1.38642, 1, 0, 0.202811,0.00764647) , 
1, 1.2054, 1, 0, 0.263753,-0.00442224)    );
  // itree = 2031
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0727273,-0.00226502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249084,0.00250894) , 
3, -0.980133, 1, 0, 0.15257,0.0187413) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237879,0.00797379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316981,-0.0101914) , 
0, 0.343147, 1, 0, 0.2811,-0.00446492) , 
0, -0.571715, 1, 0, 0.24344,0.00233458)    );
  // itree = 2032
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184246,0.0116821) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.406667,-0.0432724) , 
3, 0.313975, 1, 0, 0.221357,-0.00244757) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144772,0.0060845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.601744,0.0227181) , 
3, 1.08579, 1, 0, 0.288991,0.0151159) , 
0, -0.0968335, 1, 0, 0.258421,0.00717744)    );
  // itree = 2033
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.515748,-0.00183659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330561,-0.00599327) , 
3, -1.33448, 1, 0, 0.394558,0.0214176) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201557,0.00330434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.052356,-0.0405194) , 
3, 1.53007, 1, 0, 0.180401,-0.00146582) , 
2, -0.361538, 1, 0, 0.256004,0.00661263)    );
  // itree = 2034
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21659,-0.00877679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348416,-0.00369114) , 
2, -0.391676, 1, 0, 0.296263,-0.0151282) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266247,0.00637511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118519,-0.0208169) , 
3, 0.725019, 1, 0, 0.198413,0.0147565) , 
0, 0.23336, 1, 0, 0.252653,-0.0018092)    );
  // itree = 2035
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.261651,0.00930533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.325658,0.0133485) , 
2, 1.00881, 1, 0, 0.272425,0.00121183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204918,0.0349132) , 
2, 1.77577, 1, 0, 0.268154,-0.00243457)    );
  // itree = 2036
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209877,0.0249153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146199,-0.0130729) , 
1, -0.535694, 1, 0, 0.164221,0.00051892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.569767,0.0274564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.464646,-0.0179399) , 
1, 1.63292, 1, 0, 0.550095,0.0273579) , 
3, 0.786213, 1, 0, 0.268367,0.0077627)    );
  // itree = 2037
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.350449,-0.00340967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0631579,-0.0151886) , 
3, -0.0157802, 1, 0, 0.273496,0.0232431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24453,0.00451664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0437158,-0.0505212) , 
3, 1.54878, 1, 0, 0.20625,-0.00342011) , 
0, 0.125775, 1, 0, 0.241601,0.0105965)    );
  // itree = 2038
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121406,0.012675) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116279,-0.041349) , 
2, -1.03006, 1, 0, 0.11991,-0.0238134) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19697,-0.00171289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298111,0.00350216) , 
2, -0.525234, 1, 0, 0.289558,0.0073578) , 
2, -0.755418, 1, 0, 0.252122,0.000479275)    );
  // itree = 2039
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267442,0.00474419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277778,0.0056569) , 
2, 0.735514, 1, 0, 0.270213,0.00356771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184615,0.0210559) , 
2, 1.76296, 1, 0, 0.264677,0.000521162)    );
  // itree = 2040
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.201807,0.0414705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0884956,-0.0351125) , 
2, -0.897218, 1, 0, 0.121995,-0.00143351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37931,0.0456566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484642,0.00310016) , 
2, 0.198971, 1, 0, 0.452184,0.018031) , 
3, 0.130099, 1, 0, 0.263959,0.00693525)    );
  // itree = 2041
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434524,-0.0257244) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.219512,-0.0177774) , 
3, -1.6809, 1, 0, 0.292339,0.0259848) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251351,0.00147019) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213463,-0.000476671) , 
0, -0.153469, 1, 0, 0.222815,0.00149025) , 
0, -0.659236, 1, 0, 0.2401,0.00758012)    );
  // itree = 2042
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309278,-0.00812476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230108,-0.0175427) , 
1, 0.498076, 1, 0, 0.277098,0.0150222) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165957,-0.00384117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202128,-0.00875186) , 
1, 0.811675, 1, 0, 0.182033,-0.013262) , 
0, 0.23336, 1, 0, 0.236683,0.00299789)    );
  // itree = 2043
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1575,-0.00110366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.340113,0.0011538) , 
0, -0.183218, 1, 0, 0.253412,0.000534548) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.555556,0.044612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.120536,-0.0318952) , 
3, 0.564567, 1, 0, 0.269795,0.0252588) , 
2, 1.18512, 1, 0, 0.25617,0.00469593)    );
  // itree = 2044
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151786,-0.0115618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101562,-0.0536489) , 
3, 0.608617, 1, 0, 0.144737,-0.0139303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.35084,0.019606) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326425,-0.00514405) , 
0, 0.25575, 1, 0, 0.337441,0.0053448) , 
2, -0.0345658, 1, 0, 0.248094,-0.00359211)    );
  // itree = 2045
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453083,0.0048838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140845,-0.0127407) , 
3, -0.860423, 1, 0, 0.318113,0.0105027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237896,0.0054846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264706,0.039986) , 
0, 1.53443, 1, 0, 0.24,-0.00837782) , 
0, -0.419895, 1, 0, 0.266224,-0.00203928)    );
  // itree = 2046
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218803,-0.00542154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36,-0.00446881) , 
2, -0.151845, 1, 0, 0.283871,0.00517392) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242718,0.00394422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223001,0.0150292) , 
0, 0.425831, 1, 0, 0.227421,-0.0121399) , 
0, 0.125775, 1, 0, 0.257984,-0.0027659)    );
  // itree = 2047
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143126,0.000420319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.306996,0.00667378) , 
0, -0.528477, 1, 0, 0.257159,0.00375956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.356021,0.00562447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189189,0.0515205) , 
0, 1.34812, 1, 0, 0.294702,-0.0253519) , 
3, 1.36188, 1, 0, 0.262695,-0.000533237)    );
  // itree = 2048
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875912,-0.0137585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352442,0.0253111) , 
3, -0.491208, 1, 0, 0.195502,0.00697537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219048,-0.0477663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.00118597) , 
2, 0.50343, 1, 0, 0.319249,-0.00727136) , 
2, 0.332, 1, 0, 0.248008,0.000930446)    );
  // itree = 2049
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341421,-0.00388014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.122024,0.0101122) , 
1, 0.778171, 1, 0, 0.260679,-0.00474615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0704225,-0.0248729) , 
3, 1.76965, 1, 0, 0.246951,-0.00191564)    );
  // itree = 2050
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32378,0.00797921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0348259,-0.0324361) , 
3, 1.06924, 1, 0, 0.284853,0.00784395) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193732,-0.00579287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182243,0.0114646) , 
3, 1.0189, 1, 0, 0.189381,-0.0185776) , 
1, 1.16801, 1, 0, 0.258629,0.000586701)    );
  // itree = 2051
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0765182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135922,-0.011522) , 
1, 0.0771925, 1, 0, 0.0424242,-0.0288419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225708,-0.0129533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.32746,-0.00500463) , 
0, 0.461212, 1, 0, 0.267226,0.00293299) , 
0, -0.940853, 1, 0, 0.230115,-0.00231248)    );
  // itree = 2052
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199222,0.00332552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305503,0.0241445) , 
2, 0.684444, 1, 0, 0.230132,0.00812692) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251256,-0.0253135) , 
0, 1.36019, 1, 0, 0.232223,0.00412932)    );
  // itree = 2053
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.383838,-0.00322753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345238,0.00836153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224189,-0.00475574) , 
0, -1.04295, 1, 0, 0.235105,-0.00329501) , 
0, -1.69913, 1, 0, 0.24261,-0.00112263)    );
  // itree = 2054
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,0.0214752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368146,0.00345763) , 
1, -1.22888, 1, 0, 0.348811,-0.0109746) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.025,-0.0477906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174002,-0.0143805) , 
1, -0.403775, 1, 0, 0.157703,0.0108011) , 
3, -0.305034, 1, 0, 0.242929,0.00109)    );
  // itree = 2055
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.136132,-0.0193319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310897,0.00575776) , 
3, -0.0728399, 1, 0, 0.185792,0.00773127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273084,0.015022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436754,0.00768812) , 
1, 0.838733, 1, 0, 0.346983,-0.0083538) , 
0, 0.125775, 1, 0, 0.259625,0.000363576)    );
  // itree = 2056
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.117497,0.000783551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.508434,0.0295979) , 
3, -0.205224, 1, 0, 0.252922,0.0140857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.265805,0.00389382) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289474,-0.0428641) , 
1, 1.47709, 1, 0, 0.269136,-0.00550713) , 
0, 0.310699, 1, 0, 0.259462,0.00618219)    );
  // itree = 2057
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346011,-0.00265903) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.154412,-0.00405988) , 
3, 0.0694702, 1, 0, 0.281751,0.000827419) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0327869,0.00920113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110092,-0.000763129) , 
0, 0.761369, 1, 0, 0.0823529,-0.0244703) , 
3, 1.21569, 1, 0, 0.247197,-0.00355648)    );
  // itree = 2058
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296875,-0.00635077) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0563063,-0.0215079) , 
3, -1.33517, 1, 0, 0.128931,0.01795) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0155032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307884,0.00781232) , 
1, -0.44637, 1, 0, 0.311239,-0.00980218) , 
2, -0.396143, 1, 0, 0.253953,-0.00108165)    );
  // itree = 2059
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227304,-0.00513337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310526,-0.0201027) , 
3, 0.844783, 1, 0, 0.244444,0.00721409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190476,0.000904333) , 
1, 1.55041, 1, 0, 0.240462,0.004589)    );
  // itree = 2060
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192686,0.0151047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.472492,-0.0104345) , 
3, 0.907971, 1, 0, 0.242634,0.00603607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.057971,-0.0233112) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.572727,-0.0739091) , 
3, 1.38642, 1, 0, 0.28629,-0.0611484) , 
2, 1.40345, 1, 0, 0.248105,-0.00238321)    );
  // itree = 2061
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335294,-0.0131027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293377,0.0135695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.058997,-0.0257143) , 
3, 1.22272, 1, 0, 0.250406,-0.0120943) , 
0, -1.35255, 1, 0, 0.257553,-0.00878615)    );
  // itree = 2062
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234857,-0.00895652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214912,-0.0069786) , 
1, 0.362756, 1, 0, 0.22504,0.000420368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330709,-0.00803183) , 
1, 1.63248, 1, 0, 0.231818,0.00432663)    );
  // itree = 2063
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256996,0.00402089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.518325,0.025262) , 
0, 1.35023, 1, 0, 0.282698,-0.00577752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0802114) , 
1, 1.7097, 1, 0, 0.267674,-0.00245965)    );
  // itree = 2064
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0619579,-0.00730505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331081,0.0172702) , 
3, -0.468305, 1, 0, 0.213239,0.00932234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.650602,-0.0345473) , 
3, 1.73078, 1, 0, 0.249378,0.00401868)    );
  // itree = 2065
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285082,-0.00293823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,0.000611591) , 
2, 1.5418, 1, 0, 0.267647,-0.00121367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151163,-0.00992404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18617,0.0198174) , 
3, 0.785477, 1, 0, 0.169444,-0.0421752) , 
0, 1.10784, 1, 0, 0.250485,-0.008372)    );
  // itree = 2066
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.32503,9.07861e-07) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135647,-0.0149083) , 
1, 1.05254, 1, 0, 0.273276,0.000321963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119565,0.00191894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353698,0.0139577) , 
2, 0.855674, 1, 0, 0.214008,-0.0194884) , 
0, 0.353094, 1, 0, 0.249612,-0.00758782)    );
  // itree = 2067
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327928,0.0418573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218935,-0.00519152) , 
2, -0.670073, 1, 0, 0.302486,0.00902414) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189364,-0.0122246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.295833,0.0181556) , 
0, 0.580183, 1, 0, 0.230216,-0.0147784) , 
2, -0.363611, 1, 0, 0.256709,-0.0060528)    );
  // itree = 2068
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0684932,-0.0248263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230366,0.0216151) , 
2, -1.15801, 1, 0, 0.160237,0.00389344) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24375,0.00709316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301619,-0.0248298) , 
0, -0.392104, 1, 0, 0.287462,-0.018256) , 
2, -0.38767, 1, 0, 0.244198,-0.0107239)    );
  // itree = 2069
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.406375,-0.0151655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.178306,0.00462358) , 
1, -0.363096, 1, 0, 0.24026,0.00425059) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161616,-0.013463) , 
0, 1.52075, 1, 0, 0.236261,0.0088983)    );
  // itree = 2070
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318996,0.00576658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0419162,-0.0487393) , 
3, 0.874531, 1, 0, 0.282931,0.00806051) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135922,0.0112275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214112,-0.00580695) , 
1, 0.464134, 1, 0, 0.180556,-0.0192257) , 
0, 0.474519, 1, 0, 0.246131,-0.00174783)    );
  // itree = 2071
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175637,-0.00446899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225055,-0.0199592) , 
3, -0.431883, 1, 0, 0.203358,0.0134751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538922,0.0108088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273333,-0.0214992) , 
1, 0.564507, 1, 0, 0.413249,-0.0177593) , 
0, 1.16351, 1, 0, 0.237922,0.00833157)    );
  // itree = 2072
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141975,0.0792434) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324503,0.0169824) , 
2, -1.37714, 1, 0, 0.300246,0.0222095) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104126,-0.0520202) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.371901,0.0140102) , 
2, 1.16074, 1, 0, 0.190413,-0.022626) , 
1, 0.819028, 1, 0, 0.258376,0.0051174)    );
  // itree = 2073
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.33538,0.000760232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110294,0.008228) , 
2, 0.643333, 1, 0, 0.281707,0.00146533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0464135,-0.00552061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169643,0.00958908) , 
0, 1.38715, 1, 0, 0.0859599,0.02017) , 
3, 1.29216, 1, 0, 0.248544,0.00463423)    );
  // itree = 2074
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.36215,0.0038151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290182,0.00953308) , 
0, -0.750936, 1, 0, 0.30969,-0.00508588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0436681,-0.0277342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126904,-0.0194938) , 
0, 0.969961, 1, 0, 0.0821596,0.0318101) , 
3, 0.873167, 1, 0, 0.261347,0.00275336)    );
  // itree = 2075
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133795,-0.0268956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.326531,0.0231718) , 
3, -0.0728399, 1, 0, 0.20339,-0.00455041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.680272,0.0071701) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288848,-0.00155894) , 
2, -0.330391, 1, 0, 0.371758,0.0167837) , 
0, 0.474519, 1, 0, 0.260361,0.00266845)    );
  // itree = 2076
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232227,-0.003464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22716,-0.0438917) , 
0, 0.422984, 1, 0, 0.230999,-0.0115075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0178571,-0.04277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50625,0.0184177) , 
3, 0.861407, 1, 0, 0.305147,0.0142509) , 
0, 1.17201, 1, 0, 0.241379,-0.00790163)    );
  // itree = 2077
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341121,-0.0105176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252549,0.00248666) , 
0, -1.21861, 1, 0, 0.262626,-0.0030799) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185185,0.0254811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.158879,-0.00838423) , 
1, 0.447875, 1, 0, 0.172093,0.0387686) , 
0, 1.32355, 1, 0, 0.25334,0.00121276)    );
  // itree = 2078
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225549,-0.00463561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261745,0.00497261) , 
1, -0.395086, 1, 0, 0.2519,0.00752664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365079,0.00320306) , 
1, 1.63248, 1, 0, 0.259146,0.0110145)    );
  // itree = 2079
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110345,-0.0144565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651316,0.0595711) , 
3, -1.34368, 1, 0, 0.387205,-0.0163501) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.221542,-0.0126862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22449,0.00609516) , 
2, 0.325824, 1, 0, 0.223072,0.0075129) , 
2, -1.11308, 1, 0, 0.247495,0.00396215)    );
  // itree = 2080
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262926,-0.000520353) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.226374,-0.0365338) , 
1, 0.35485, 1, 0, 0.250733,-0.0104426) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0366972,-0.0661114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261261,0.0310133) , 
0, -0.516495, 1, 0, 0.216998,0.01832) , 
1, 1.16801, 1, 0, 0.241002,-0.00214538)    );
  // itree = 2081
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.686957,0.0179831) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387476,-0.00742512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176724,0.00500257) , 
1, -0.16355, 1, 0, 0.233316,-0.00151927) , 
1, -1.40737, 1, 0, 0.259167,-0.00382022)    );
  // itree = 2082
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232406,0.0016933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273592,-0.00311765) , 
1, -0.273481, 1, 0, 0.26015,-5.57453e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0727273,0.0099938) , 
3, 1.76021, 1, 0, 0.244968,-0.00562508)    );
  // itree = 2083
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015748,0.122286) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0753968,-0.00968621) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300803,0.00317557) , 
1, -0.69047, 1, 0, 0.270444,-0.00477166) , 
1, -1.36088, 1, 0, 0.254254,-0.000283065)    );
  // itree = 2084
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182482,0.0107636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138015,-0.0151362) , 
0, -0.329323, 1, 0, 0.158173,-0.00191721) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518033,0.0333448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.63587,-0.00746029) , 
3, 1.70524, 1, 0, 0.562372,0.0284776) , 
3, 0.873167, 1, 0, 0.257,0.00551432)    );
  // itree = 2085
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.48374,-0.0187927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232513,0.000502203) , 
2, -1.26941, 1, 0, 0.267039,0.000885398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152047,0.00375208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155039,0.0164547) , 
3, 1.42193, 1, 0, 0.153333,0.0264294) , 
0, 1.23273, 1, 0, 0.250718,0.004552)    );
  // itree = 2086
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301096,0.00536605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0231481,-0.0352928) , 
3, 1.23305, 1, 0, 0.267119,0.00491468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185714,-0.0107312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.364486,0.0378257) , 
0, 0.469257, 1, 0, 0.246057,-0.0221326) , 
1, 1.40475, 1, 0, 0.263916,0.000800486)    );
  // itree = 2087
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0751693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133901,-0.0178904) , 
0, -1.36791, 1, 0, 0.118656,0.00308966) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.700599,0.0303111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355649,0.00791641) , 
3, 1.01649, 1, 0, 0.556719,-0.0245659) , 
1, 1.09547, 1, 0, 0.242245,-0.00471272)    );
  // itree = 2088
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.182927,-0.0356691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189119,-0.00474175) , 
1, -1.27094, 1, 0, 0.188525,-0.00644185) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4689,0.025338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.768,-0.0122292) , 
3, 1.89377, 1, 0, 0.580838,0.0194406) , 
3, 1.30934, 1, 0, 0.252693,-0.00220839)    );
  // itree = 2089
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375494,0.00265006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.281513,-0.00332966) , 
0, -1.03921, 1, 0, 0.329939,0.0148035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306778,0.00448169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147152,0.019146) , 
3, 0.480163, 1, 0, 0.238289,-0.017019) , 
0, -0.659236, 1, 0, 0.261202,-0.00906335)    );
  // itree = 2090
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240741,0.000502567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0138889,-0.00718122) , 
3, 0.261652, 1, 0, 0.192982,-0.00412427) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293255,0.000948307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320552,0.00333608) , 
2, 0.608151, 1, 0, 0.311178,0.0242699) , 
2, 0.126076, 1, 0, 0.251114,0.00984076)    );
  // itree = 2091
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248162,-0.00349414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353591,0.00542806) , 
2, 1.29165, 1, 0, 0.258687,0.00686054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0200762) , 
2, 1.80124, 1, 0, 0.252346,0.00368047)    );
  // itree = 2092
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192469,0.0235446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0814815,-0.0308811) , 
1, -0.89073, 1, 0, 0.106768,-0.00693001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.353434,0.028586) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.550122,-0.00664455) , 
3, 1.02195, 1, 0, 0.4334,0.0125999) , 
3, -0.0237104, 1, 0, 0.266667,0.00263061)    );
  // itree = 2093
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.365354,0.0100567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0899123,0.00493253) , 
2, 0.725636, 1, 0, 0.292584,-0.00598666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0710383,-0.00319141) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0343968) , 
2, 1.53385, 1, 0, 0.0721649,0.023508) , 
3, 1.36188, 1, 0, 0.260783,-0.00173136)    );
  // itree = 2094
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156352,-0.00836126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.468793,0.0163764) , 
2, -0.960694, 1, 0, 0.375486,-0.0106276) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263636,0.000182512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133244,-0.000648399) , 
3, 0.314334, 1, 0, 0.163032,0.00610003) , 
3, -0.097287, 1, 0, 0.272727,-0.00253683)    );
  // itree = 2095
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104032,-0.0188913) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.600358,0.0121807) , 
1, 0.946985, 1, 0, 0.258065,0.00107941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180328,0.0126087) , 
2, 1.7672, 1, 0, 0.253125,-0.00403071)    );
  // itree = 2096
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.146967,0.0163716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.360308,-0.0287811) , 
3, 0.474485, 1, 0, 0.20831,-0.00427307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.767742,0.0336775) , 
3, 1.73078, 1, 0, 0.252551,0.000669431)    );
  // itree = 2097
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.542484,-0.015513) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23488,-0.00195251) , 
2, -1.57544, 1, 0, 0.260237,0.0060092) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0887097,-0.00155477) , 
2, 1.76296, 1, 0, 0.249495,0.00341642)    );
  // itree = 2098
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237705,-0.00234236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163793,-0.0313489) , 
1, 1.5317, 1, 0, 0.233004,0.0127479) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378788,0.0130107) , 
2, 1.77577, 1, 0, 0.242843,0.0107035)    );
  // itree = 2099
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0252525,-0.00983623) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276355,-0.0018505) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0797466) , 
1, 1.712, 1, 0, 0.260528,0.00721671) , 
1, -1.06103, 1, 0, 0.236988,0.00328782)    );
  // itree = 2100
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.19402,0.0163493) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378882,-0.0375447) , 
3, 1.13923, 1, 0, 0.211194,0.00408751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705263,0.0248282) , 
3, 1.65635, 1, 0, 0.26001,0.0078004)    );
  // itree = 2101
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.299797,0.00967769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159322,-0.0186574) , 
0, 0.963844, 1, 0, 0.276464,0.000470875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0333333,-0.0533329) , 
3, 1.64517, 1, 0, 0.25409,0.00566642)    );
  // itree = 2102
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247002,-0.00619948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.046875,0.0561085) , 
3, 1.65076, 1, 0, 0.232739,-0.00529825) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284153,-0.0379967) , 
1, 1.55119, 1, 0, 0.237494,-0.00199594)    );
  // itree = 2103
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272894,-0.0103907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239291,0.00785838) , 
2, -0.611326, 1, 0, 0.248947,0.000446143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27933,-0.0140532) , 
0, 1.44542, 1, 0, 0.251563,0.00557576)    );
  // itree = 2104
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.105691,-0.0229424) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.452381,-0.0508342) , 
3, -0.645793, 1, 0, 0.223118,-0.0347085) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258659,-0.00729713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276753,0.0233866) , 
0, 1.17201, 1, 0, 0.261671,-0.00106494) , 
1, -0.652328, 1, 0, 0.2545,-0.00732265)    );
  // itree = 2105
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3875,-0.00696973) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218973,-0.00288302) , 
3, -1.17015, 1, 0, 0.256382,0.0098918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.119403,-0.0102298) , 
1, 1.49547, 1, 0, 0.242636,0.00526383)    );
  // itree = 2106
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305531,7.36443e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286713,0.0121273) , 
0, 0.307155, 1, 0, 0.300383,-0.00518512) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0461538,0.00772111) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134529,-0.0117323) , 
1, 1.08977, 1, 0, 0.0869565,0.0248613) , 
3, 0.827607, 1, 0, 0.250122,0.00189066)    );
  // itree = 2107
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.134768,-0.0111076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.230874,-0.00934204) , 
3, -0.211068, 1, 0, 0.178328,0.0016963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.531532,0.00674037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141509,0.0526353) , 
3, 1.67954, 1, 0, 0.437358,-0.0233202) , 
0, 0.982985, 1, 0, 0.23369,-0.00365046)    );
  // itree = 2108
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.040881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.274126,0.0169443) , 
3, -1.62316, 1, 0, 0.217724,0.0091731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269596,-0.0080792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289062,-0.0374128) , 
1, 1.48476, 1, 0, 0.272165,-0.0125924) , 
0, -0.0162542, 1, 0, 0.245754,-0.00203312)    );
  // itree = 2109
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30869,0.00327285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0614754,-0.0274822) , 
3, 1.01253, 1, 0, 0.274916,0.000874977) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0192308,-0.0182285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190909,0.0585652) , 
0, 1.19527, 1, 0, 0.107477,-0.0323268) , 
3, 1.63045, 1, 0, 0.257,-0.00267762)    );
  // itree = 2110
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.335755,0.00269633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0429688,-0.00293582) , 
3, 0.827607, 1, 0, 0.285619,0.0106169) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154696,-0.000883415) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194805,-0.015861) , 
1, 1.34908, 1, 0, 0.181979,-0.0131529) , 
1, 1.14418, 1, 0, 0.257157,0.00408913)    );
  // itree = 2111
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0655738,-0.013211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.143791,-0.00697438) , 
2, 0.443106, 1, 0, 0.079096,0.0129166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409091,0.0116921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315789,0.0120131) , 
0, 1.33696, 1, 0, 0.398458,-0.00984154) , 
1, 0.152908, 1, 0, 0.260721,-2.62392e-05)    );
  // itree = 2112
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212963,0.0540032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245184,0.00329693) , 
0, -1.66344, 1, 0, 0.243273,0.00552091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271028,-0.0495447) , 
2, 1.76296, 1, 0, 0.244813,0.00203065)    );
  // itree = 2113
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296552,-0.0186627) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.241082,-0.00129054) , 
0, -1.44603, 1, 0, 0.245353,-0.000522337) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313726,0.0531804) , 
1, 1.7097, 1, 0, 0.248866,-0.00466793)    );
  // itree = 2114
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317012,3.33485e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0352941,-0.0345298) , 
3, 1.03029, 1, 0, 0.282182,0.00231053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.157377,-0.0261709) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161137,0.0326671) , 
3, 1.05793, 1, 0, 0.158915,-0.0218842) , 
0, 0.813325, 1, 0, 0.248546,-0.00429152)    );
  // itree = 2115
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0818908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270006,-0.00572704) , 
1, -1.40059, 1, 0, 0.254753,0.00573021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0575091) , 
1, 1.65151, 1, 0, 0.242689,0.00250108)    );
  // itree = 2116
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257566,0.00189879) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168182,-0.0489319) , 
0, 1.22394, 1, 0, 0.246873,-0.00427097) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323741,-0.0483859) , 
2, 1.76296, 1, 0, 0.252275,-0.00912604)    );
  // itree = 2117
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.568965,0.0145575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212325,-0.00598155) , 
1, -1.07773, 1, 0, 0.246553,0.011425) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110345,0.0339068) , 
2, 1.76374, 1, 0, 0.236466,0.00878006)    );
  // itree = 2118
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259494,-0.0120302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118056,0.00280898) , 
0, -0.587665, 1, 0, 0.192053,-0.0381715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382445,-0.00391776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239251,0.000914061) , 
0, -0.769488, 1, 0, 0.26519,-0.00850122) , 
1, -0.843018, 1, 0, 0.254484,-0.0128446)    );
  // itree = 2119
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325123,0.0853195) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.102054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247081,-0.0103699) , 
0, -1.16507, 1, 0, 0.227247,0.00609438) , 
2, -1.46199, 1, 0, 0.237323,0.00161398)    );
  // itree = 2120
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0968343,-0.00294951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.471396,0.0291744) , 
3, -0.54823, 1, 0, 0.264887,0.0143452) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196056,-0.0148475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34188,0.0293561) , 
2, 1.44652, 1, 0, 0.22719,-0.00336457) , 
1, 0.302097, 1, 0, 0.244928,0.00496843)    );
  // itree = 2121
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.763636,0.0239907) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239726,-0.0275294) , 
1, -0.777979, 1, 0, 0.464844,-0.0178697) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246281,-0.0174945) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.182601,-0.0026217) , 
3, -0.482199, 1, 0, 0.204417,0.0112684) , 
2, -1.23016, 1, 0, 0.237389,0.00757931)    );
  // itree = 2122
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.229651,5.23649e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.338164,-0.00517494) , 
2, 0.829754, 1, 0, 0.254749,-0.00755357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162304,-0.0151083) , 
0, 1.37323, 1, 0, 0.245835,-0.000828598)    );
  // itree = 2123
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233907,0.00468976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.503623,0.00863802) , 
0, 1.17201, 1, 0, 0.274255,-0.00214129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0840336,-0.018686) , 
1, 1.59889, 1, 0, 0.262729,0.00101888)    );
  // itree = 2124
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245734,0.0573865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285714,0.00457602) , 
0, -0.584373, 1, 0, 0.268786,0.0238638) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309179,-0.0248833) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.218103,0.00450718) , 
1, 0.536929, 1, 0, 0.246431,-0.00450311) , 
1, -0.0869251, 1, 0, 0.254078,0.00520025)    );
  // itree = 2125
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.612676,0.021318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202186,-0.0238319) , 
1, -0.610897, 1, 0, 0.342137,-0.0136234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213058,-0.0128419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167679,0.00959733) , 
1, 0.0813332, 1, 0, 0.179533,0.00877969) , 
3, -0.343942, 1, 0, 0.249101,-0.000805194)    );
  // itree = 2126
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244234,0.000259686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.407216,-0.00327475) , 
2, 1.27955, 1, 0, 0.261008,-0.00996069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.10625,0.0417512) , 
3, 1.73078, 1, 0, 0.2489,-0.0071237)    );
  // itree = 2127
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178704,-0.0122626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.331976,0.00142313) , 
0, 0.501049, 1, 0, 0.219738,-0.00717539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.372549,0.00799604) , 
0, 1.37323, 1, 0, 0.235034,-0.00334203)    );
  // itree = 2128
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24766,0.00838051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1536,-0.02332) , 
0, 0.370505, 1, 0, 0.215,-0.00237892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.771242,0.0309124) , 
3, 1.73078, 1, 0, 0.258577,0.00181323)    );
  // itree = 2129
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664,0.025991) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213542,0.000856891) , 
2, -1.03996, 1, 0, 0.391167,-0.0306145) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259934,-0.00522419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0760369,-0.0194325) , 
1, 1.27218, 1, 0, 0.211328,-0.000424873) , 
0, -0.940853, 1, 0, 0.240429,-0.00531007)    );
  // itree = 2130
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291815,0.00251585) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.224796,0.0050592) , 
0, 0.240225, 1, 0, 0.265339,-0.0110653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0555556,-0.0353481) , 
3, 1.75738, 1, 0, 0.25025,-0.00614043)    );
  // itree = 2131
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0412979,-0.0330014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321383,0.00741426) , 
1, -0.754602, 1, 0, 0.271436,-0.00177483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135802,-0.03331) , 
3, 1.73078, 1, 0, 0.260785,0.00189374)    );
  // itree = 2132
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24635,0.0108109) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175753,-0.0196782) , 
1, -0.33754, 1, 0, 0.197524,-0.00679635) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.61165,-0.00109942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743802,0.0279538) , 
2, 1.24042, 1, 0, 0.683036,0.0285338) , 
3, 1.59147, 1, 0, 0.251874,-0.00284135)    );
  // itree = 2133
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3775,0.00360633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0108465) , 
3, 0.92787, 1, 0, 0.333099,0.00944108) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678733,-0.00952618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206704,0.0130593) , 
1, 1.5456, 1, 0, 0.107891,-0.0215614) , 
1, 1.01701, 1, 0, 0.264576,8.18657e-06)    );
  // itree = 2134
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322681,-0.00066831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0691318,-0.00783149) , 
3, 0.391539, 1, 0, 0.239895,0.000692716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.370079,0.00359647) , 
2, 1.77922, 1, 0, 0.248031,-0.00232374)    );
  // itree = 2135
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.251432,-0.00137459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.284314,0.0641052) , 
3, 1.7091, 1, 0, 0.253247,-0.00426622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00165367) , 
2, 1.76374, 1, 0, 0.246201,-0.00077651)    );
  // itree = 2136
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176796,-0.0297074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106383,0.155081) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,5.36405e-05) , 
2, -1.42274, 1, 0, 0.256866,0.0045289) , 
1, -1.06932, 1, 0, 0.249755,0.00129144)    );
  // itree = 2137
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302521,0.000224745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0820046,-0.00487624) , 
3, 0.804405, 1, 0, 0.25067,0.00346931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181818,0.0122378) , 
1, 1.59889, 1, 0, 0.246123,0.00114838)    );
  // itree = 2138
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.195918,-0.00865041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285169,0.00487063) , 
1, -1.00711, 1, 0, 0.273128,-0.00377268) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0865385,-0.0530652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202797,0.0216658) , 
3, 0.83381, 1, 0, 0.153846,-0.0379975) , 
0, 1.31913, 1, 0, 0.258846,-0.00787036)    );
  // itree = 2139
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185855,-0.060751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.626168,0.0251622) , 
3, -0.0418421, 1, 0, 0.300487,0.0126505) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.100592,-0.016153) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390558,0.0016974) , 
1, 0.971558, 1, 0, 0.218914,-0.0046689) , 
2, -0.156898, 1, 0, 0.253055,0.00257985)    );
  // itree = 2140
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.180344,-0.0028236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138889,-0.0800222) , 
3, 0.936989, 1, 0, 0.176471,-0.00969768) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.351575,0.0232038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.289902,-0.00779259) , 
1, 1.26387, 1, 0, 0.330769,0.0103096) , 
2, 0.352049, 1, 0, 0.244434,-0.000885157)    );
  // itree = 2141
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297859,0.0107884) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.042328,-0.0154205) , 
3, 1.38893, 1, 0, 0.271382,0.000837276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257732,0.0225775) , 
0, 1.55414, 1, 0, 0.270692,-0.00370609)    );
  // itree = 2142
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220238,-0.00163161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330337,-0.0116511) , 
1, -1.13721, 1, 0, 0.312854,-0.00588592) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512821,-0.0506679) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180285,-0.00473017) , 
0, -0.256276, 1, 0, 0.158576,0.0301158) , 
3, 0.000826949, 1, 0, 0.240806,0.010927)    );
  // itree = 2143
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191087,-0.00814838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4375,0.0251741) , 
3, 1.30696, 1, 0, 0.212923,-0.00921938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.674157,0.0292523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208696,-0.0360074) , 
3, 0.760057, 1, 0, 0.411765,0.024238) , 
0, 1.00007, 1, 0, 0.252828,-0.00250486)    );
  // itree = 2144
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0735931,-0.0119158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211679,-0.0469523) , 
3, -0.25513, 1, 0, 0.0914232,-0.00983274) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337331,0.00201101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.60443,0.0201315) , 
3, 1.23099, 1, 0, 0.423194,0.0128443) , 
3, -0.0237104, 1, 0, 0.250978,0.00107308)    );
  // itree = 2145
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380153,-0.00342298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108586,-6.83022e-05) , 
1, 0.549555, 1, 0, 0.277831,-0.0107831) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211765,-0.032683) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.199737,0.003555) , 
2, -0.636561, 1, 0, 0.201933,0.00483004) , 
0, 0.133846, 1, 0, 0.24218,-0.00344916)    );
  // itree = 2146
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309659,0.00705507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0230769,-0.0387051) , 
3, 0.393454, 1, 0, 0.232365,0.0012043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395018,0.0107947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344482,0.0263302) , 
0, 0.501351, 1, 0, 0.368966,-0.025875) , 
2, 0.798578, 1, 0, 0.271471,-0.00654792)    );
  // itree = 2147
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0934305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266124,-0.00107794) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136646,-0.0102773) , 
1, 1.55896, 1, 0, 0.255048,0.00764651) , 
1, -1.26491, 1, 0, 0.238332,0.0112875)    );
  // itree = 2148
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183071,0.0164722) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145669,-0.0246923) , 
2, -0.611326, 1, 0, 0.158136,-0.00525602) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.606796,0.028198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.450893,-0.0052515) , 
0, 0.922431, 1, 0, 0.525581,0.013048) , 
3, 0.934112, 1, 0, 0.238997,-0.00122801)    );
  // itree = 2149
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.313158,0.00449663) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0828877,-0.00127941) , 
1, 1.28677, 1, 0, 0.267687,-0.00499515) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0729927,-0.0347963) , 
3, 1.76021, 1, 0, 0.254554,-0.000881961)    );
  // itree = 2150
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267706,-0.00557706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0163934,-0.0352054) , 
3, 1.1149, 1, 0, 0.233315,0.0049971) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.518519,0.0247282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248062,0.0578612) , 
3, 1.31712, 1, 0, 0.386364,-0.0473646) , 
2, 1.40345, 1, 0, 0.253053,-0.00175595)    );
  // itree = 2151
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306557,0.031065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.240757,-0.00479704) , 
2, -0.398726, 1, 0, 0.263395,-0.0102953) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243902,0.0296995) , 
1, 1.55041, 1, 0, 0.261745,-0.00672509)    );
  // itree = 2152
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.0860829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22955,-0.00987973) , 
2, -1.51586, 1, 0, 0.219075,-0.00331636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.0101531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.47486,0.0300782) , 
3, 0.826048, 1, 0, 0.285246,0.0325461) , 
0, 1.17201, 1, 0, 0.228993,0.00205861)    );
  // itree = 2153
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557047,-0.018134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285343,-0.000628271) , 
2, -1.43846, 1, 0, 0.316436,-0.00293886) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0806754,-0.0146175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183486,-0.00900733) , 
0, 1.44338, 1, 0, 0.0981308,0.0290288) , 
3, 0.479711, 1, 0, 0.244342,0.00761835)    );
  // itree = 2154
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.225322,0.00190543) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298272,0.00995606) , 
1, -0.450788, 1, 0, 0.279354,-0.0073451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0837989,6.3967e-05) , 
3, 1.63045, 1, 0, 0.26164,-0.00133638)    );
  // itree = 2155
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0827558) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278916,-0.00475519) , 
0, -1.33995, 1, 0, 0.251357,0.0037254) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137255,0.0359815) , 
3, 1.74551, 1, 0, 0.242607,-0.000437228)    );
  // itree = 2156
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194631,0.018477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0572988,-0.034059) , 
1, -0.715188, 1, 0, 0.0969932,-0.00503949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40201,0.0370402) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.440252,-0.00339871) , 
2, 0.334576, 1, 0, 0.425532,0.0129247) , 
3, -0.0237104, 1, 0, 0.261501,0.00395566)    );
  // itree = 2157
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.464865,0.0058055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206751,-0.0100302) , 
2, -0.332235, 1, 0, 0.319905,-0.00177662) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12931,-0.00285661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109565,-0.00197793) , 
1, -0.0130795, 1, 0, 0.11288,0.0163104) , 
3, 0.496563, 1, 0, 0.246806,0.00460974)    );
  // itree = 2158
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241477,0.00515238) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227451,-0.00769204) , 
1, -0.67474, 1, 0, 0.230074,0.00517587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.421875,0.020826) , 
2, 1.80124, 1, 0, 0.242289,0.00220459)    );
  // itree = 2159
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253669,-0.00321441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308707,0.0103809) , 
2, 0.995466, 1, 0, 0.265193,-0.00107786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184466,-0.0097176) , 
0, 1.55414, 1, 0, 0.260847,0.00232942)    );
  // itree = 2160
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158301,0.0028482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.545205,0.0252128) , 
3, 0.312606, 1, 0, 0.259101,0.0103751) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189781,-0.0542177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272366,0.00195576) , 
1, -0.203775, 1, 0, 0.254687,-0.0126404) , 
0, 0.596152, 1, 0, 0.257717,0.00315806)    );
  // itree = 2161
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.614943,0.0115662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211443,-0.00307602) , 
1, -1.12426, 1, 0, 0.250842,-0.00193379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.162791,-0.00249413) , 
0, 1.44542, 1, 0, 0.243091,0.00155347)    );
  // itree = 2162
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302707,-0.00756749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0409357,-0.027263) , 
3, 0.975023, 1, 0, 0.270504,-0.0113603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.14433,0.00950358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299363,0.00460194) , 
2, 1.41194, 1, 0, 0.182243,0.020766) , 
0, 0.646842, 1, 0, 0.242618,-0.00121016)    );
  // itree = 2163
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750496) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.095342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.296379,0.00806047) , 
0, -1.16792, 1, 0, 0.271845,0.00288027) , 
3, -2.21683, 1, 0, 0.257627,0.000442459)    );
  // itree = 2164
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178209,-0.0253609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.316594,-0.000823075) , 
2, 0.490565, 1, 0, 0.219338,-0.0145416) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0187414) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.651429,0.0293085) , 
3, 1.3079, 1, 0, 0.294931,0.0174401) , 
0, 0.905585, 1, 0, 0.235949,-0.00751374)    );
  // itree = 2165
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.41844,0.0163397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25648,0.000339173) , 
0, -1.41932, 1, 0, 0.270691,-0.00799011) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164179,-0.027902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101604,-0.0203639) , 
3, 1.0581, 1, 0, 0.134021,0.0259206) , 
0, 0.982985, 1, 0, 0.24411,-0.00139493)    );
  // itree = 2166
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.479452,0.00671755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327434,-0.00970132) , 
3, -1.66402, 1, 0, 0.413127,-0.0373053) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163158,-0.00739091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356913,0.00767407) , 
2, 0.708576, 1, 0, 0.231555,0.00972824) , 
0, -1.08742, 1, 0, 0.254824,0.00370069)    );
  // itree = 2167
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138716,-0.00379929) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581818,0.0675235) , 
3, 0.642441, 1, 0, 0.20336,-0.0144562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447427,-0.00904846) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206388,-0.00180628) , 
2, 0.608291, 1, 0, 0.332553,0.0134689) , 
0, 0.23336, 1, 0, 0.258942,-0.00244206)    );
  // itree = 2168
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0818834) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.403846,0.0535933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269188,0.00609319) , 
0, -1.12753, 1, 0, 0.279939,0.010059) , 
3, -2.18002, 1, 0, 0.265921,0.00756211)    );
  // itree = 2169
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28388,-0.00232525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235135,0.00617034) , 
0, -0.33367, 1, 0, 0.254003,-0.00506056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205128,0.0262319) , 
0, 1.42411, 1, 0, 0.250127,-0.00865122)    );
  // itree = 2170
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320093,0.00972781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141643,-0.00479341) , 
0, -0.0107878, 1, 0, 0.239437,-0.0161114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.522388,0.00454155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223443,-0.0116463) , 
3, 0.445639, 1, 0, 0.321867,0.0323117) , 
2, 1.06264, 1, 0, 0.256475,-0.00610217)    );
  // itree = 2171
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160494,0.000562263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515385,0.0452223) , 
3, 1.03029, 1, 0, 0.196994,-0.0115234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418288,-0.011102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104575,-0.0335801) , 
3, 1.64288, 1, 0, 0.346327,0.0134666) , 
0, 0.563554, 1, 0, 0.248576,-0.00289145)    );
  // itree = 2172
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.305195,0.036426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206936,0.00477312) , 
1, -1.16173, 1, 0, 0.214968,0.00679511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.598765,-0.0387977) , 
3, 1.73078, 1, 0, 0.245357,0.00119139)    );
  // itree = 2173
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497382,0.013041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18254,-0.00152329) , 
1, -0.157278, 1, 0, 0.37224,-0.0235899) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263158,-0.00805538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.223496,0.00549451) , 
0, 0.0266811, 1, 0, 0.23863,0.00429251) , 
0, -0.906156, 1, 0, 0.259701,-0.000104864)    );
  // itree = 2174
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284211,7.73148e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826446,-0.0147379) , 
3, 1.43289, 1, 0, 0.27089,0.0064233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0675676,-0.0297095) , 
3, 1.74551, 1, 0, 0.255685,0.00350161)    );
  // itree = 2175
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.028169,-0.0302682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.329032,0.0198086) , 
1, -0.633707, 1, 0, 0.234513,-0.00546068) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.554795,0.0736808) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228216,-0.0166491) , 
0, -0.216836, 1, 0, 0.283084,-0.0212949) , 
3, 0.159145, 1, 0, 0.255628,-0.0123441)    );
  // itree = 2176
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18309,-0.00153374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.389381,-0.0268573) , 
3, 1.33055, 1, 0, 0.195842,-0.00408452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737143,0.0261376) , 
3, 1.64517, 1, 0, 0.243135,-0.000106211)    );
  // itree = 2177
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385965,0.00770673) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39823,0.0196802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238824,0.00188063) , 
0, -1.12379, 1, 0, 0.248759,0.00364802) , 
0, -1.54575, 1, 0, 0.256876,0.00130121)    );
  // itree = 2178
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291779,0.00170653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.181319,0.00726487) , 
0, 1.16406, 1, 0, 0.279712,-0.00451781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00555556,-0.0610776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,-0.0269775) , 
2, 1.4479, 1, 0, 0.0612245,0.0456337) , 
3, 1.36188, 1, 0, 0.246939,0.00300492)    );
  // itree = 2179
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.160061,-0.00562573) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303261,-0.00203442) , 
0, -0.398922, 1, 0, 0.243655,-0.0104571) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.680556,0.021276) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0836502,-0.0324735) , 
2, 0.639502, 1, 0, 0.29484,0.0253206) , 
3, 0.970157, 1, 0, 0.25416,-0.00311393)    );
  // itree = 2180
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970149,-0.0614121) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242812,-0.00981329) , 
0, -1.03372, 1, 0, 0.199105,-0.0216489) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349398,0.0288035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234165,-0.00188366) , 
1, 0.333696, 1, 0, 0.271429,0.00690472) , 
1, -0.484715, 1, 0, 0.255159,0.000481232)    );
  // itree = 2181
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.405594,0.0048044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249565,-0.00304687) , 
0, -1.50888, 1, 0, 0.261522,0.00098056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0794702,-0.00185865) , 
3, 1.74551, 1, 0, 0.247893,0.00431668)    );
  // itree = 2182
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332516,0.00187578) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.050193,-0.0306634) , 
3, 0.752365, 1, 0, 0.28321,0.00402017) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135135,0.0049032) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201635,0.00284652) , 
1, -0.193159, 1, 0, 0.186192,-0.018142) , 
0, 0.823264, 1, 0, 0.259561,-0.00138192)    );
  // itree = 2183
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202941,0.0231951) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.308167,0.0074871) , 
0, -0.632583, 1, 0, 0.288258,-0.000447718) , 
0, -1.44702, 1, 0, 0.267286,-0.00325111)    );
  // itree = 2184
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.204762,-0.0273668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114932,0.000684567) , 
0, -1.24931, 1, 0, 0.129278,-0.00358203) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447433,0.0432547) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.506622,-0.00153113) , 
2, 0.885767, 1, 0, 0.472574,0.0289942) , 
3, 0.414913, 1, 0, 0.249753,0.00785022)    );
  // itree = 2185
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.688679,-0.00356884) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227477,0.00117721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.17757,-0.0141472) , 
1, 1.65968, 1, 0, 0.224642,-0.00144211) , 
1, -1.39679, 1, 0, 0.249372,0.00186078)    );
  // itree = 2186
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.39823,-0.0199112) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0550459,0.0203644) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247541,-0.00355624) , 
2, -1.59958, 1, 0, 0.23672,0.00292207) , 
0, -1.58783, 1, 0, 0.245614,0.000462099)    );
  // itree = 2187
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235023,0.0140612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277972,-0.0122113) , 
3, 0.0449846, 1, 0, 0.249849,0.000798928) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330472,-0.0274873) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194915,0.00416019) , 
1, 1.4333, 1, 0, 0.2849,0.0286098) , 
3, 1.19852, 1, 0, 0.255976,0.00566029)    );
  // itree = 2188
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103306,0.0347047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.258993,-0.00739504) , 
2, -1.3005, 1, 0, 0.239267,-0.00307199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.477477,0.0219255) , 
0, 1.54569, 1, 0, 0.25235,-0.000957135)    );
  // itree = 2189
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288732,-0.00132875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0409836,0.0280976) , 
3, 1.51442, 1, 0, 0.270784,0.00119812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1125,-0.0216741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180952,0.0154177) , 
1, 0.900427, 1, 0, 0.133333,-0.0358389) , 
0, 1.13453, 1, 0, 0.247413,-0.00509946)    );
  // itree = 2190
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.189655,0.00893965) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283546,0.00603942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0466667,-0.00200563) , 
3, 1.7145, 1, 0, 0.263773,-0.0104009) , 
1, -1.19679, 1, 0, 0.25723,-0.00732143)    );
  // itree = 2191
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202552,-0.00955062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354037,0.0164227) , 
3, 0.536064, 1, 0, 0.244675,-0.00933851) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360656,-0.00401715) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173077,0.00284888) , 
2, 1.76614, 1, 0, 0.274336,0.019428) , 
2, 1.40517, 1, 0, 0.24809,-0.00602662)    );
  // itree = 2192
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215554,-0.000560055) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546219,-0.0324196) , 
3, 1.58712, 1, 0, 0.238014,-0.00335578) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38,0.0558061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41,0.0312426) , 
0, 1.07589, 1, 0, 0.395,0.042925) , 
2, 1.5087, 1, 0, 0.254098,0.00138611)    );
  // itree = 2193
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323529,0.00277235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131387,0.00222243) , 
1, 0.935798, 1, 0, 0.305537,-0.0101715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0378378,-0.0395029) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0995025,-0.00666975) , 
0, -0.242211, 1, 0, 0.0800681,0.0237556) , 
1, 1.14159, 1, 0, 0.240976,-0.000456753)    );
  // itree = 2194
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.447712,0.0128239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236984,-0.025002) , 
3, -1.21959, 1, 0, 0.311703,0.0138668) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208159,-0.0057512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952381,0.0311345) , 
3, 1.81375, 1, 0, 0.195009,-0.00960002) , 
0, -0.113851, 1, 0, 0.246787,0.000812247)    );
  // itree = 2195
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.112908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.145038,0.0631236) , 
0, -1.13765, 1, 0, 0.0539773,-0.021881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319564,-0.00400485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27027,-0.0152844) , 
3, 1.12722, 1, 0, 0.30853,0.0120851) , 
0, -0.906156, 1, 0, 0.26384,0.006122)    );
  // itree = 2196
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0457921,-0.0289338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343023,0.0122793) , 
3, -0.443037, 1, 0, 0.2125,0.00232618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641975,-0.0205747) , 
3, 1.76021, 1, 0, 0.247253,-0.00048465)    );
  // itree = 2197
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.453488,0.0173849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0433901) , 
1, 0.683403, 1, 0, 0.341667,-0.0243731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298491,-0.00373857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0799289,-0.0148164) , 
1, 0.939437, 1, 0, 0.215962,0.00991665) , 
0, -0.659236, 1, 0, 0.246575,0.00156602)    );
  // itree = 2198
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.190244,-0.00725601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253741,0.000875863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322807,-0.00436472) , 
2, 1.30804, 1, 0, 0.264544,-0.00839426) , 
1, -1.06103, 1, 0, 0.25703,-0.00262347)    );
  // itree = 2199
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112825,-0.00513265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.147335,-0.000467388) , 
2, 0.614134, 1, 0, 0.120944,0.000981338) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.683453,0.00838264) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,-0.00223714) , 
3, 0.360657, 1, 0, 0.527607,-0.0380884) , 
1, 0.967289, 1, 0, 0.252988,-0.0117047)    );
  // itree = 2200
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0971074,-0.0394389) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.018648,-0.0126842) , 
1, -0.0644085, 1, 0, 0.060241,-0.0154588) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.387244,0.0279862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396285,-0.0105314) , 
2, 0.352213, 1, 0, 0.392627,0.0048849) , 
3, -0.287516, 1, 0, 0.240741,-0.00441128)    );
  // itree = 2201
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.572864,0.0252645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121212,-0.0311454) , 
2, -0.516546, 1, 0, 0.392749,-0.0348406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26346,0.00466805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109091,-0.00291563) , 
1, 1.44028, 1, 0, 0.23801,-0.00350695) , 
0, -0.920459, 1, 0, 0.263632,-0.00869527)    );
  // itree = 2202
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268647,-0.00759062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0255474,-0.0282796) , 
3, 1.20855, 1, 0, 0.231414,0.00114617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410256,0.0197282) , 
2, 1.7672, 1, 0, 0.242392,-0.00289027)    );
  // itree = 2203
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.226779,-0.00753338) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50519,0.00365281) , 
0, 1.10198, 1, 0, 0.268105,0.00381247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0782811) , 
3, 1.90896, 1, 0, 0.254386,0.000869816)    );
  // itree = 2204
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208738,0.0508533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27974,0.00685958) , 
1, -1.07602, 1, 0, 0.270559,0.0106973) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00178302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254717,-0.0374157) , 
0, 0.166829, 1, 0, 0.196388,-0.018861) , 
1, 1.29989, 1, 0, 0.25442,0.00426588)    );
  // itree = 2205
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.596386,-0.0074129) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287703,0.00180083) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0655172,-0.0221281) , 
2, 0.777748, 1, 0, 0.2189,-0.000388714) , 
1, -1.19679, 1, 0, 0.249632,0.00245359)    );
  // itree = 2206
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213904,0.0170619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.311111,0.0175271) , 
1, -1.11116, 1, 0, 0.26158,0.0307002) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.279588,-0.00187263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163673,-0.00775006) , 
1, 1.21502, 1, 0, 0.244751,0.00424796) , 
1, -0.71469, 1, 0, 0.247788,0.0090208)    );
  // itree = 2207
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232958,-0.00494625) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318493,-0.00924304) , 
3, 1.03029, 1, 0, 0.246811,0.00536454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256637,0.0102204) , 
0, 1.52725, 1, 0, 0.24739,0.00198206)    );
  // itree = 2208
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.179209,0.00413915) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380488,-0.0281075) , 
3, 1.10108, 1, 0, 0.202482,-0.00278974) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.726776,0.0168062) , 
3, 1.73078, 1, 0, 0.251534,6.37162e-05)    );
  // itree = 2209
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577586,-0.0105297) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237308,0.0016396) , 
1, -1.35223, 1, 0, 0.259116,-0.00214898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0940171,0.00871763) , 
2, 1.77922, 1, 0, 0.249092,-0.00574765)    );
  // itree = 2210
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274368,0.00255774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186701,-0.00536206) , 
1, 1.2364, 1, 0, 0.255068,-0.00116689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.075188,-0.0129506) , 
3, 1.75738, 1, 0, 0.242535,0.00125494)    );
  // itree = 2211
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218147,0.00889911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,-0.000868469) , 
3, -0.0874066, 1, 0, 0.221713,-0.00110289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.169192,-0.00886268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399351,0.00702473) , 
1, 1.09711, 1, 0, 0.269886,-0.028197) , 
3, 0.414913, 1, 0, 0.238569,-0.0105831)    );
  // itree = 2212
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.264901,0.044359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193465,-0.0130658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332253,0.0131914) , 
2, 0.655055, 1, 0, 0.241573,-0.00253208) , 
1, -1.19679, 1, 0, 0.243397,0.000776705)    );
  // itree = 2213
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318996,-0.00290985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282456,-0.00365279) , 
0, -0.0934985, 1, 0, 0.304193,-0.0021124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0522876,0.0333308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126953,0.00477988) , 
0, -0.0840682, 1, 0, 0.109774,-0.0305505) , 
3, 0.518766, 1, 0, 0.241795,-0.0112395)    );
  // itree = 2214
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216837,-0.00317636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317757,-0.0041246) , 
2, 0.925215, 1, 0, 0.228956,-0.00508763) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347107,-0.00287124) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313609,0.0064843) , 
1, 1.16504, 1, 0, 0.327586,0.0259668) , 
2, 1.40517, 1, 0, 0.242761,-0.000741207)    );
  // itree = 2215
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150638,-0.0172568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.501441,0.011106) , 
0, 0.55062, 1, 0, 0.230618,0.00609549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21374,0.0227236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335196,0.00664532) , 
1, 0.49663, 1, 0, 0.302658,-0.028177) , 
3, 0.853537, 1, 0, 0.248135,-0.00223831)    );
  // itree = 2216
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.197584,-0.00181303) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0421687,-0.0598135) , 
2, 0.66287, 1, 0, 0.162978,-0.00672104) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.478006,0.0281702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.641618,-0.00855081) , 
3, 1.67371, 1, 0, 0.533074,0.0227005) , 
3, 0.832675, 1, 0, 0.257855,0.000821452)    );
  // itree = 2217
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565,0.00658146) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.377358,0.0210961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202312,0.00205554) , 
2, -1.03426, 1, 0, 0.22329,0.0069431) , 
1, -1.02829, 1, 0, 0.257999,0.00217733)    );
  // itree = 2218
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.326964,0.00682517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.141593,-0.0102352) , 
3, 0.606984, 1, 0, 0.313237,-0.00580359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0646067,0.010446) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.155172,-0.034633) , 
1, 1.4089, 1, 0, 0.0943396,0.0321673) , 
3, 0.832675, 1, 0, 0.256809,0.00398463)    );
  // itree = 2219
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26009,-0.000862619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221122,-0.00786611) , 
2, -0.0295634, 1, 0, 0.240422,-0.00833637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203822,0.0184093) , 
3, 1.71106, 1, 0, 0.237487,-0.0122186)    );
  // itree = 2220
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223902,0.0055005) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.348837,-0.0250787) , 
2, 0.778102, 1, 0, 0.248702,-0.00164791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.41,0.0329649) , 
2, 1.51294, 1, 0, 0.265391,0.00254324)    );
  // itree = 2221
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.352291,0.0071326) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0917431,0.00603812) , 
3, 0.804405, 1, 0, 0.298807,-0.0104807) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0634146,-0.0321938) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105263,-0.017174) , 
3, 1.10235, 1, 0, 0.0798817,0.0237483) , 
1, 1.35702, 1, 0, 0.260487,-0.00448929)    );
  // itree = 2222
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247174,-0.00601629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0125,-0.0019628) , 
3, 0.893392, 1, 0, 0.211232,0.000935321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434251,0.0020622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157068,0.0148525) , 
3, 1.38642, 1, 0, 0.332046,0.0256875) , 
2, 0.845279, 1, 0, 0.241247,0.00708479)    );
  // itree = 2223
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.193939,0.0133135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242342,0.00344698) , 
2, -1.4356, 1, 0, 0.236078,-0.00577335) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.768116,0.0718113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165766,-0.0249693) , 
2, -0.217026, 1, 0, 0.285714,0.016431) , 
3, 0.422986, 1, 0, 0.253557,0.00204555)    );
  // itree = 2224
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183486,0.0418959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233645,-0.000994201) , 
0, -1.7119, 1, 0, 0.208333,0.014632) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15,-0.0495445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252421,-0.0104534) , 
0, -0.829529, 1, 0, 0.241758,-0.0120226) , 
0, -1.26434, 1, 0, 0.238046,-0.00906253)    );
  // itree = 2225
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593137,0.00301562) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243094,-3.54933e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200651,0.00762806) , 
0, 0.125775, 1, 0, 0.221675,0.00251747) , 
1, -1.0512, 1, 0, 0.258986,-0.00156607)    );
  // itree = 2226
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.096,-0.00418665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264458,0.00374453) , 
2, -1.28133, 1, 0, 0.242408,0.00847459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52381,0.0526626) , 
2, 1.85125, 1, 0, 0.257072,0.00363893)    );
  // itree = 2227
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2313,0.00578635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293436,-0.0057514) , 
3, -0.306978, 1, 0, 0.265092,0.000142302) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0797894) , 
1, 1.7097, 1, 0, 0.250745,-0.00326637)    );
  // itree = 2228
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0314685,-0.0251433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.366577,0.0350931) , 
3, -1.13268, 1, 0, 0.2207,0.0153745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149123,0.0177201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282629,-0.021309) , 
2, -0.38916, 1, 0, 0.250178,-0.0145816) , 
0, -0.427027, 1, 0, 0.240795,-0.00504613)    );
  // itree = 2229
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.664286,0.0174751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245892,0.00169817) , 
1, -1.28651, 1, 0, 0.277657,-0.00134919) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126263,0.0554552) , 
3, 1.65362, 1, 0, 0.262977,-0.00734877)    );
  // itree = 2230
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268342,0.00183154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.00449682) , 
0, 1.13604, 1, 0, 0.248206,-0.0031366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.431373,-0.017102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245509,-0.0166595) , 
3, 0.791201, 1, 0, 0.315985,0.014572) , 
2, 1.41921, 1, 0, 0.257599,-0.00068239)    );
  // itree = 2231
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208865,-0.0109635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.488372,0.0115567) , 
0, 1.19707, 1, 0, 0.246719,0.00224172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.080639) , 
1, 1.69326, 1, 0, 0.232673,0.0048757)    );
  // itree = 2232
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165202,-0.0161893) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434426,-0.067618) , 
3, 0.194863, 1, 0, 0.212735,-0.0272364) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211903,0.0184071) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.643979,-0.00997031) , 
3, 1.67152, 1, 0, 0.275385,0.0095451) , 
1, -0.045758, 1, 0, 0.253641,-0.00322034)    );
  // itree = 2233
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254854,-0.010312) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.201878,0.0235681) , 
0, 1.23273, 1, 0, 0.248791,-0.00130591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0347826,-0.0556747) , 
2, 1.76296, 1, 0, 0.236336,0.00167804)    );
  // itree = 2234
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143599,-0.00550592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236715,-0.00717453) , 
2, -0.584743, 1, 0, 0.191827,-0.00638014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.529101,0.00953452) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13242,-0.010774) , 
3, 0.572427, 1, 0, 0.316176,0.0148379) , 
2, 0.352049, 1, 0, 0.242184,0.00221237)    );
  // itree = 2235
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0838253,-0.0078204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.429158,0.0015131) , 
1, 0.259727, 1, 0, 0.268534,-0.00324006) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0758794) , 
3, 1.94262, 1, 0, 0.25482,-0.000668789)    );
  // itree = 2236
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0185759,-0.0420773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248786,0.0148905) , 
3, -1.29821, 1, 0, 0.183958,0.00513796) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196676,-0.0351762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.737705,0.00571402) , 
3, 1.56721, 1, 0, 0.306077,-0.0211042) , 
2, 0.324939, 1, 0, 0.237817,-0.00643571)    );
  // itree = 2237
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.275636,-0.00650285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196547,-0.00688208) , 
0, 0.353094, 1, 0, 0.245436,0.00212947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.12931,-0.0188921) , 
1, 1.63248, 1, 0, 0.238985,0.00526142)    );
  // itree = 2238
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.465347,0.00402373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.15411,-0.00123459) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319212,0.00827853) , 
2, 0.0640996, 1, 0, 0.242729,0.002308) , 
0, -1.64945, 1, 0, 0.254016,0.00462965)    );
  // itree = 2239
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0188679,0.0630354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301719,-0.00025216) , 
0, -1.04167, 1, 0, 0.26332,0.00224311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152,0.0129198) , 
2, 1.76296, 1, 0, 0.25662,-0.000229227)    );
  // itree = 2240
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0669516,0.00710151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.173112,-0.0203245) , 
3, -0.654116, 1, 0, 0.113253,-0.0048682) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.549618,0.0275687) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37741,-0.00396544) , 
0, 0.682861, 1, 0, 0.466931,0.0167634) , 
3, 0.334648, 1, 0, 0.246877,0.00330444)    );
  // itree = 2241
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.658537,-0.0118819) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228342,-0.00284999) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172131,0.00476319) , 
1, 1.65968, 1, 0, 0.224665,0.00169371) , 
1, -1.39679, 1, 0, 0.251509,0.0049288)    );
  // itree = 2242
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159664,-0.0241912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314365,0.000896562) , 
1, -1.27364, 1, 0, 0.302564,-0.00187733) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113043,0.00109022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0869565,0.0428197) , 
3, 1.44745, 1, 0, 0.100686,-0.03732) , 
3, 0.908449, 1, 0, 0.258388,-0.00963318)    );
  // itree = 2243
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278269,0.00493046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220915,0.00180478) , 
2, 0.216717, 1, 0, 0.253648,-0.00291899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.146154,0.0157739) , 
2, 1.7595, 1, 0, 0.246339,0.000283702)    );
  // itree = 2244
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.199519,0.0117984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0432331,-0.0307623) , 
1, 0.388562, 1, 0, 0.138563,0.00164584) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397059,-0.0150472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.561587,0.0244986) , 
0, -0.0269407, 1, 0, 0.525203,0.026451) , 
3, 0.57414, 1, 0, 0.258717,0.00935436)    );
  // itree = 2245
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.338208,0.00122037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.130711,-8.6692e-06) , 
2, 0.224734, 1, 0, 0.251328,-0.00468707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0472441,-0.0312272) , 
2, 1.76374, 1, 0, 0.238427,-0.000703874)    );
  // itree = 2246
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348348,0.00106824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28734,-0.00010525) , 
0, -0.313714, 1, 0, 0.31702,-0.00953365) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0153846,-0.0558572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.110266,-0.0224228) , 
0, -0.105775, 1, 0, 0.0914634,0.0136977) , 
3, 0.540694, 1, 0, 0.243951,-0.00200785)    );
  // itree = 2247
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.140351,0.000178058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.396996,0.00409966) , 
3, -0.992937, 1, 0, 0.288366,0.0132278) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207885,0.000409713) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225137,-0.00505407) , 
0, -0.392104, 1, 0, 0.221106,-0.00881123) , 
2, -0.210175, 1, 0, 0.248252,8.36507e-05)    );
  // itree = 2248
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200806,-0.00427921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.714286,0.0313539) , 
3, 1.63849, 1, 0, 0.237306,0.000384286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.322314,-0.031291) , 
1, 1.65151, 1, 0, 0.24247,-0.00274174)    );
  // itree = 2249
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.312724,-0.00372731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.217949,0.00635154) , 
3, 0.20459, 1, 0, 0.296296,-0.00195699) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.11811,-0.0127412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.121495,0.0188209) , 
1, 0.219477, 1, 0, 0.120846,-0.021198) , 
3, 0.613245, 1, 0, 0.238569,-0.00828779)    );
  // itree = 2250
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315476,-0.024832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153748,-0.0064517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314501,0.00435388) , 
2, 0.0738772, 1, 0, 0.246079,0.00399399) , 
0, -1.34233, 1, 0, 0.251859,5.42218e-05)    );
  // itree = 2251
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.007523) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212824,0.00721439) , 
2, -1.498, 1, 0, 0.20355,-0.012812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152344,-0.00989173) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0193578) , 
1, 1.20213, 1, 0, 0.232865,0.0205004) , 
3, -0.322723, 1, 0, 0.220373,0.00630526)    );
  // itree = 2252
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.031477,-0.0300711) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,0.0410607) , 
3, -1.15203, 1, 0, 0.0956221,0.00776935) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414081,-0.0134636) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327138,0.0120096) , 
0, 1.12503, 1, 0, 0.392954,-0.00843396) , 
3, -0.300133, 1, 0, 0.262278,-0.00131271)    );
  // itree = 2253
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303107,-0.0102247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165913,0.0111605) , 
3, 0.161664, 1, 0, 0.254045,-0.00870631) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0714286,-0.0142887) , 
3, 1.73078, 1, 0, 0.238872,-0.00478264)    );
  // itree = 2254
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.24894,0.0042837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.449102,-0.00347747) , 
2, 1.44138, 1, 0, 0.267327,-0.00123218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722222,-0.0241009) , 
3, 1.73078, 1, 0, 0.24975,0.00153101)    );
  // itree = 2255
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00343643,-0.00105257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.236885,-0.0105101) , 
1, -0.768694, 1, 0, 0.191926,0.00144896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.505495,0.036603) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416404,0.0307544) , 
1, 0.289248, 1, 0, 0.448898,-0.0242258) , 
0, 0.813325, 1, 0, 0.255721,-0.00492502)    );
  // itree = 2256
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.274675,0.00984966) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261538,0.0547096) , 
1, 0.934027, 1, 0, 0.273486,0.0120891) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0138889,0.0461838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305921,-0.0220011) , 
3, 0.440552, 1, 0, 0.184615,-0.0175321) , 
1, 1.16835, 1, 0, 0.249872,0.00421838)    );
  // itree = 2257
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.550847,-0.00146539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323155,-0.015836) , 
3, -1.24704, 1, 0, 0.408585,0.0185743) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.214286,-0.00292009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172131,0.00517024) , 
0, -0.960612, 1, 0, 0.176471,-0.0159926) , 
1, -0.207271, 1, 0, 0.249874,-0.0050612)    );
  // itree = 2258
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.388571,-0.00362798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232573,0.00725605) , 
0, -1.35255, 1, 0, 0.248146,-0.00427892) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361345,0.0159651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.299145,0.0147743) , 
0, 0.934794, 1, 0, 0.330508,-0.0409196) , 
2, 1.40345, 1, 0, 0.257919,-0.00862644)    );
  // itree = 2259
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168874,0.00355308) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.293706,-0.00128211) , 
3, -0.695211, 1, 0, 0.242134,0.00793482) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238506,0.00261282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290566,0.0220115) , 
2, 1.3506, 1, 0, 0.261011,-0.0230137) , 
2, 0.741869, 1, 0, 0.247711,-0.00120804)    );
  // itree = 2260
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126634,0.00870082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.388167,-0.0131486) , 
3, 0.327885, 1, 0, 0.221179,-0.00318496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90099,0.0641195) , 
3, 2.00929, 1, 0, 0.255203,0.00236581)    );
  // itree = 2261
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.451389,0.0180771) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.538462,0.0114031) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202668,-0.00460326) , 
1, -0.840753, 1, 0, 0.248215,-0.000251952) , 
0, -1.43147, 1, 0, 0.263104,-0.00367709)    );
  // itree = 2262
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301736,0.0108916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.131148,0.00326649) , 
1, 1.13902, 1, 0, 0.263896,-0.00378163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483871,0.0300543) , 
1, 1.65151, 1, 0, 0.277208,-0.0065496)    );
  // itree = 2263
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0712121,-0.0054149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387779,0.000637003) , 
1, -0.0635997, 1, 0, 0.249504,-0.00471767) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.330097,-0.00794354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00970874,-0.0849425) , 
2, 1.85701, 1, 0, 0.266019,0.0394384) , 
3, 0.832675, 1, 0, 0.253702,0.00650659)    );
  // itree = 2264
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218845,-0.0223819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318694,0.0114068) , 
1, -0.70998, 1, 0, 0.291701,0.00185749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.06875,-0.0853576) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207178,-0.0157564) , 
0, -0.524943, 1, 0, 0.178525,-0.0273418) , 
1, 0.757817, 1, 0, 0.247739,-0.00948476)    );
  // itree = 2265
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.268927,-0.00177863) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0239609) , 
3, 1.43023, 1, 0, 0.256247,-0.00197807) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108434,0.0286642) , 
3, 1.74551, 1, 0, 0.24426,-0.00652665)    );
  // itree = 2266
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267606,-0.00120362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.100304,0.0212619) , 
0, -1.03976, 1, 0, 0.150743,-0.0154792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282723,-0.00278756) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29646,0.00174209) , 
1, 1.45114, 1, 0, 0.284709,0.0056106) , 
2, -0.746238, 1, 0, 0.253687,0.000726979)    );
  // itree = 2267
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0274725,-0.0108127) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0921053,-0.0175882) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300738,-0.000384205) , 
1, -0.6635, 1, 0, 0.282902,-0.00123103) , 
1, -1.06389, 1, 0, 0.259184,-0.00400299)    );
  // itree = 2268
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242899,0.00767921) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229592,-0.0223565) , 
1, 1.49217, 1, 0, 0.241541,0.00376868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255474,-0.0566308) , 
0, 1.49754, 1, 0, 0.242468,-0.00171165)    );
  // itree = 2269
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349781,0.00728562) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.190352,-0.000105014) , 
3, -0.181981, 1, 0, 0.276951,0.0006019) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512821,0.0124054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153153,-0.000896192) , 
0, 1.38852, 1, 0, 0.0882353,-0.0373148) , 
3, 1.29216, 1, 0, 0.247859,-0.0052432)    );
  // itree = 2270
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244063,0.00216458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.28,-0.00570892) , 
1, -0.0320835, 1, 0, 0.265723,0.00689366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0675676,-0.0197632) , 
3, 1.73078, 1, 0, 0.251459,0.00368972)    );
  // itree = 2271
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233412,0.000880114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.27933,-0.0414208) , 
3, 1.16937, 1, 0, 0.237815,-0.0067947) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191083,0.0264288) , 
3, 1.68512, 1, 0, 0.23419,-0.00971082)    );
  // itree = 2272
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.119502,0.00471786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.436909,-0.0177414) , 
3, 0.324194, 1, 0, 0.228929,-0.00670444) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39604,0.0407375) , 
0, 1.52669, 1, 0, 0.237629,-0.00321995)    );
  // itree = 2273
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367839,-0.00108228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.168142,-0.00547971) , 
2, 0.14754, 1, 0, 0.295513,-0.0103429) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0686275,0.0174062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0941704,-0.00699283) , 
3, 0.837766, 1, 0, 0.0819672,0.0171237) , 
2, 1.04095, 1, 0, 0.249623,-0.00444039)    );
  // itree = 2274
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280088,-0.00474665) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.204239,0.00398047) , 
1, 1.05373, 1, 0, 0.259259,-0.00011761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0467836,-0.0346299) , 
3, 1.63344, 1, 0, 0.24163,-0.00388585)    );
  // itree = 2275
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232975,0.0260411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.249097,0.00582192) , 
3, -0.367008, 1, 0, 0.236984,0.00962666) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.293578,0.00337583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165517,-0.018554) , 
1, 1.51486, 1, 0, 0.273128,-0.00909012) , 
3, 0.108015, 1, 0, 0.253215,0.0012217)    );
  // itree = 2276
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,0.0746465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137097,-0.0352645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269923,-0.00123329) , 
2, -0.825547, 1, 0, 0.251663,-0.00483441) , 
2, -1.5637, 1, 0, 0.239308,-0.00140014)    );
  // itree = 2277
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.414404,0.0041544) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124607,-0.00113021) , 
1, 0.240541, 1, 0, 0.260821,0.000709446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0909091,-0.0282993) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23301,0.0380234) , 
1, 0.447875, 1, 0, 0.15625,-0.0391333) , 
0, 1.31913, 1, 0, 0.24926,-0.00369568)    );
  // itree = 2278
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163793,0.00308406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.26699,-0.00278249) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268647,0.00165214) , 
1, -0.697782, 1, 0, 0.268456,-0.00653377) , 
1, -1.3631, 1, 0, 0.26208,-0.003508)    );
  // itree = 2279
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0767888,0.031559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305577,-0.0118116) , 
1, -0.256427, 1, 0, 0.235919,0.00270537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.377049,0.0193317) , 
0, 1.42411, 1, 0, 0.248426,-0.00116915)    );
  // itree = 2280
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192308,0.0112366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.416667,-0.049188) , 
3, 0.636073, 1, 0, 0.220418,-0.00309285) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.143596,0.00150517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.605263,0.0210991) , 
3, 1.09821, 1, 0, 0.285202,0.011862) , 
0, -0.113851, 1, 0, 0.256955,0.00534148)    );
  // itree = 2281
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.504762,-0.00437317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.324074,0.000472313) , 
3, -0.679984, 1, 0, 0.431262,0.0208029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247021,0.0151857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0620155,-0.0319451) , 
2, 0.844178, 1, 0, 0.180681,-0.00370273) , 
1, -0.286194, 1, 0, 0.248223,0.0029026)    );
  // itree = 2282
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248043,0.000700277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0144928,-0.000815572) , 
3, 1.5462, 1, 0, 0.230128,-0.0086146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313131,-0.0136367) , 
2, 1.54698, 1, 0, 0.238358,-0.00480118)    );
  // itree = 2283
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262032,-0.000300322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.479592,0.0361864) , 
3, 1.4209, 1, 0, 0.274003,-0.00420591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00587349) , 
3, 1.74551, 1, 0, 0.264446,0.000750377)    );
  // itree = 2284
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.319588,0.0271837) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15812,-0.0116725) , 
1, 1.05373, 1, 0, 0.267038,0.0133727) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149184,-0.0206231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.69697,-0.0652641) , 
3, 1.9179, 1, 0, 0.251894,-0.0331943) , 
0, 0.823264, 1, 0, 0.262971,0.000866395)    );
  // itree = 2285
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372549,0.00972384) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0387938) , 
1, 1.25949, 1, 0, 0.321267,0.0129198) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262931,0.00855406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0833333,-0.0104381) , 
3, 1.49319, 1, 0, 0.234738,-0.00802009) , 
0, -0.427027, 1, 0, 0.262874,-0.00121128)    );
  // itree = 2286
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.228853,-0.00579034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251908,0.0206857) , 
1, 1.5317, 1, 0, 0.230479,-0.00332634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.336134,-0.0156143) , 
2, 1.76296, 1, 0, 0.236842,0.000246075)    );
  // itree = 2287
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207868,-0.00657539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514706,0.0300735) , 
0, 1.09998, 1, 0, 0.23056,0.000464476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417085,0.00532144) , 
0, 1.36019, 1, 0, 0.248773,0.00408179)    );
  // itree = 2288
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.078853,-0.0336385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934579,-0.0800548) , 
2, -1.13956, 1, 0, 0.0829016,-0.0388014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164875,-0.00417134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.568507,0.0143569) , 
3, 0.762638, 1, 0, 0.28785,0.00555662) , 
2, -0.889903, 1, 0, 0.248117,-0.00304319)    );
  // itree = 2289
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314615,-0.00471557) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0793201,-0.0261879) , 
2, 0.68415, 1, 0, 0.266935,0.00126205) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0276827) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0962963,0.010889) , 
3, 1.3286, 1, 0, 0.0620155,-0.0294657) , 
2, 1.40345, 1, 0, 0.2405,-0.00270184)    );
  // itree = 2290
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137546,-0.0197002) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0536585,-0.0180826) , 
1, -0.293124, 1, 0, 0.101266,-0.0213513) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.301672,0.00138522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.072,-0.0212223) , 
3, 1.88413, 1, 0, 0.283951,0.0108174) , 
2, -0.753576, 1, 0, 0.242598,0.00353568)    );
  // itree = 2291
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.00180461) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254083,-0.00517204) , 
3, 0.0607132, 1, 0, 0.190039,0.0130144) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526786,0.0157131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.302013,0.0046585) , 
0, 1.49863, 1, 0, 0.457732,-0.0108583) , 
0, 0.896613, 1, 0, 0.2546,0.00725692)    );
  // itree = 2292
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186869,-0.00643201) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161905,-0.0865821) , 
0, -1.29224, 1, 0, 0.178218,-0.0288596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.273632,0.0134148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242739,-0.0149812) , 
0, 0.86965, 1, 0, 0.26481,0.00353076) , 
0, -0.953749, 1, 0, 0.251632,-0.00139856)    );
  // itree = 2293
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.498507,-0.0135022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390244,0.0403897) , 
3, -0.699614, 1, 0, 0.457407,-0.0240253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.250896,0.00573887) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0660522,-0.0253015) , 
1, 1.03174, 1, 0, 0.170027,0.00571087) , 
1, -0.363096, 1, 0, 0.246548,-0.00220706)    );
  // itree = 2294
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470899,0.0161883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.191057,-0.0242954) , 
3, -0.860159, 1, 0, 0.360577,0.0141749) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.216334,-0.00106982) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.159236,-0.00410989) , 
0, 1.47686, 1, 0, 0.20948,-0.0042361) , 
0, -0.49228, 1, 0, 0.258282,0.0017103)    );
  // itree = 2295
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0762283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278643,-0.00179243) , 
0, -1.7478, 1, 0, 0.263407,0.00685758) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0234375,-0.0738773) , 
1, 1.65151, 1, 0, 0.248276,0.00287932)    );
  // itree = 2296
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227717,0.000689927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111801,-0.039246) , 
1, 1.5027, 1, 0, 0.217895,-0.00243407) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.847619,0.0285606) , 
3, 1.9923, 1, 0, 0.250873,0.000142909)    );
  // itree = 2297
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.508475,-0.0171296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.411765,-0.0337849) , 
0, -0.435131, 1, 0, 0.469595,0.0333035) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281796,0.0207406) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0824561,-0.00760887) , 
1, 1.1441, 1, 0, 0.21771,-0.0103629) , 
1, -0.847039, 1, 0, 0.253746,-0.00411579)    );
  // itree = 2298
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344988,-0.010226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210602,0.000243166) , 
0, -0.784322, 1, 0, 0.242192,0.0040263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305344,-0.019302) , 
1, 1.59889, 1, 0, 0.246421,7.46596e-05)    );
  // itree = 2299
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0812111) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0454545,0.018422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276914,-0.00464403) , 
0, -1.00506, 1, 0, 0.263129,0.00641104) , 
0, -1.41761, 1, 0, 0.243976,0.00331801)    );
  // itree = 2300
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2224,0.0182346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167792,-0.0193747) , 
0, -0.407171, 1, 0, 0.188327,-0.00336037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423077,0.0666749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.73301,0.012694) , 
2, 0.697743, 1, 0, 0.629032,0.0499791) , 
3, 1.2983, 1, 0, 0.257606,0.00502464)    );
  // itree = 2301
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.367164,-0.0184143) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.149606,0.0292554) , 
3, -0.663939, 1, 0, 0.307359,-0.027655) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278846,0.00154174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0740741,-0.0146096) , 
3, 1.03634, 1, 0, 0.225307,0.00751629) , 
0, -0.69773, 1, 0, 0.244157,-0.000563837)    );
  // itree = 2302
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.232877,-0.00483186) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270049,-0.000853252) , 
1, -0.774615, 1, 0, 0.26288,-0.00385529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.188119,-0.0032044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128527,-0.00924011) , 
3, 0.512323, 1, 0, 0.151631,0.0271664) , 
0, 0.854922, 1, 0, 0.234398,0.00408687)    );
  // itree = 2303
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181275,-0.0314642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701219,0.0388034) , 
3, -0.0575706, 1, 0, 0.309309,0.00773798) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0955631,-0.00672232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280669,0.010312) , 
1, -0.0960606, 1, 0, 0.241052,-0.00997986) , 
2, -0.394071, 1, 0, 0.263391,-0.0041813)    );
  // itree = 2304
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0252101,-0.0386509) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.0554858) , 
3, -1.778, 1, 0, 0.155378,-0.0471493) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.316611,0.0249247) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188108,-0.00342874) , 
1, 0.616188, 1, 0, 0.251372,0.00962552) , 
1, -0.95459, 1, 0, 0.239749,0.00275119)    );
  // itree = 2305
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.43038,0.00104942) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359455,0.00409489) , 
0, -0.643879, 1, 0, 0.384275,0.012659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162228,0.0277877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125193,-0.00106218) , 
0, -0.0398309, 1, 0, 0.139623,-0.0107751) , 
1, 0.319042, 1, 0, 0.252165,4.80107e-06)    );
  // itree = 2306
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184739,0.0134968) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.40617,0.00392984) , 
2, -1.00072, 1, 0, 0.352483,-0.00380401) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148,-0.0141269) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,0.0166938) , 
0, 1.12159, 1, 0, 0.15534,0.0188682) , 
3, -0.107593, 1, 0, 0.253768,0.00754863)    );
  // itree = 2307
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750689) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136464,-0.0155547) , 
3, -2.14245, 1, 0, 0.126445,0.00551075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.675325,0.0265626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.328,0.0678362) , 
3, 1.38148, 1, 0, 0.590196,-0.0284293) , 
1, 1.14159, 1, 0, 0.245835,-0.00322697)    );
  // itree = 2308
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230207,0.000667416) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353933,0.029572) , 
2, 1.01984, 1, 0, 0.252252,0.00498747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408333,-0.0349694) , 
0, 1.55414, 1, 0, 0.261095,0.00156073)    );
  // itree = 2309
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366142,0.000617229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0724638,0.0322078) , 
3, 0.313975, 1, 0, 0.321111,-0.0129064) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276817,-0.00164199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.114815,-0.00712259) , 
3, 0.536741, 1, 0, 0.198569,0.00681446) , 
0, -0.0968335, 1, 0, 0.253221,-0.00198079)    );
  // itree = 2310
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410584,0.0268488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.257467,-0.00617795) , 
3, -0.87897, 1, 0, 0.312706,0.00706406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0464548,0.00791535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175439,-0.0544514) , 
1, 1.53605, 1, 0, 0.0745698,-0.0280062) , 
3, 0.839878, 1, 0, 0.251714,-0.00191818)    );
  // itree = 2311
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0763574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288004,0.00166867) , 
0, -1.70211, 1, 0, 0.272632,0.00577732) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.039604,-0.0472223) , 
1, 1.65151, 1, 0, 0.260934,0.00131995)    );
  // itree = 2312
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288231,0.00817273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116477,-0.032619) , 
1, 1.2017, 1, 0, 0.254094,0.000868542) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217822,-0.0944646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318182,-0.0420888) , 
1, 1.35328, 1, 0, 0.270142,-0.06761) , 
2, 1.52497, 1, 0, 0.255802,-0.00642155)    );
  // itree = 2313
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355601,0.000292487) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0842825,-0.0168515) , 
3, 0.104753, 1, 0, 0.271246,0.0144665) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218875,0.00652629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0826446,-0.0147672) , 
3, 1.694, 1, 0, 0.192246,-0.011026) , 
0, 0.646842, 1, 0, 0.247169,0.00669698)    );
  // itree = 2314
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272009,0.00644972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0538462,-0.052159) , 
0, 1.43206, 1, 0, 0.257098,-0.00409466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.426471,0.0295549) , 
2, 1.7595, 1, 0, 0.2684,-0.00831016)    );
  // itree = 2315
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447293,0.0156932) , 
0, -1.11383, 1, 0, 0.334043,0.00676347) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.091623,-0.0090792) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269333,-0.00175625) , 
1, -0.0854569, 1, 0, 0.224287,-0.0134269) , 
2, -0.670628, 1, 0, 0.250379,-0.00862698)    );
  // itree = 2316
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.248634,0.0252874) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165072,-0.0142913) , 
1, -0.691095, 1, 0, 0.183951,-0.00148604) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.46789,0.0434322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.624413,0.00533347) , 
3, 1.4881, 1, 0, 0.571429,0.0279041) , 
3, 1.19852, 1, 0, 0.248198,0.00338709)    );
  // itree = 2317
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398649,0.00696358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.297478,0.00116535) , 
0, -1.42592, 1, 0, 0.307487,-0.00629596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0643564,-0.0131374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0824742,-0.0210115) , 
2, 0.626657, 1, 0, 0.0750507,0.0269866) , 
3, 0.786213, 1, 0, 0.249874,0.00195356)    );
  // itree = 2318
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.333032,0.00198708) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0993464,-0.0223892) , 
3, 0.158612, 1, 0, 0.237587,0.00879324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.461538,0.0282542) , 
2, 1.76296, 1, 0, 0.250754,0.00468569)    );
  // itree = 2319
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0894575) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.109804,0.0338773) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.271366,-0.0111645) , 
1, -0.682618, 1, 0, 0.249193,-0.0107711) , 
1, -1.36088, 1, 0, 0.233957,-0.00701505)    );
  // itree = 2320
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.075431,-0.00996524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.408389,0.0304764) , 
3, -0.708228, 1, 0, 0.239913,0.0134001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.260323,-0.0295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.304933,0.00430045) , 
0, 0.956945, 1, 0, 0.28016,-0.011782) , 
0, 0.0296075, 1, 0, 0.260938,0.000245061)    );
  // itree = 2321
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.469697,-0.000805637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276596,-0.0188024) , 
0, 0.752298, 1, 0, 0.428999,-0.0187375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162378,-0.00757175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0792683,0.0112957) , 
2, 1.67036, 1, 0, 0.15182,0.0101558) , 
1, -0.128677, 1, 0, 0.246429,0.000293736)    );
  // itree = 2322
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0683761,-0.0262136) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0314505) , 
2, -1.57181, 1, 0, 0.104803,-0.019745) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176471,0.0163617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268393,-0.00439451) , 
2, -0.990554, 1, 0, 0.263187,0.00347513) , 
2, -1.22185, 1, 0, 0.24532,0.000855713)    );
  // itree = 2323
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0693431,-0.011662) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256684,0.0249914) , 
3, 0.636714, 1, 0, 0.104063,0.00708232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.446602,0.0173516) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.194595,-0.0187064) , 
3, 1.61778, 1, 0, 0.400396,-0.0135376) , 
1, 0.389371, 1, 0, 0.25223,-0.00322762)    );
  // itree = 2324
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200131,0.00711041) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515337,-0.0116576) , 
3, 1.00911, 1, 0, 0.255526,0.00107531) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355263,0.0248543) , 
0, 1.47941, 1, 0, 0.263079,0.00336992)    );
  // itree = 2325
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296204,0.00497567) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0597015,0.033729) , 
3, 1.44179, 1, 0, 0.278001,0.00523012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.1,-0.0165198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.2,0.0148121) , 
1, 0.447875, 1, 0, 0.145455,-0.0206779) , 
0, 1.34228, 1, 0, 0.263131,0.00232357)    );
  // itree = 2326
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298593,-0.00203304) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150794,0.0351189) , 
3, 0.907767, 1, 0, 0.287574,0.00332927) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0264901,-0.0321114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139535,-0.0138794) , 
1, 1.12083, 1, 0, 0.0866873,0.0331365) , 
3, 1.19852, 1, 0, 0.25534,0.00811206)    );
  // itree = 2327
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209709,-0.00924875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.282313,-0.00897485) , 
3, -0.0737106, 1, 0, 0.243201,0.0054878) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212389,-0.00162198) , 
0, 1.55414, 1, 0, 0.241481,0.00922859)    );
  // itree = 2328
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253381,0.0106025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228448,-0.0140521) , 
0, 0.813325, 1, 0, 0.247191,0.00349208) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268817,-0.0331144) , 
1, 1.52775, 1, 0, 0.249148,-0.000859258)    );
  // itree = 2329
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.341805,0.00693898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129129,-0.00582358) , 
3, 0.185723, 1, 0, 0.26342,0.00315122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,0.0430958) , 
3, 1.76021, 1, 0, 0.251135,-0.00186219)    );
  // itree = 2330
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.20186,-0.00204659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276504,-0.0110327) , 
2, 0.357823, 1, 0, 0.231246,-0.00443273) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198347,-0.00122933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-5.97345e-05) , 
0, 0.415864, 1, 0, 0.233766,0.0334053) , 
1, 1.47236, 1, 0, 0.231537,-7.11633e-05)    );
  // itree = 2331
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381657,0.0627386) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.321678,0.0208338) , 
2, -1.03006, 1, 0, 0.363825,-0.019151) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219432,-0.00404371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238764,0.00602501) , 
2, 0.579195, 1, 0, 0.227887,0.0024405) , 
2, -0.755418, 1, 0, 0.25889,-0.00248387)    );
  // itree = 2332
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124352,0.0179612) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.531532,0.061059) , 
3, -0.897801, 1, 0, 0.273026,0.0382595) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.249839,0.000969445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317073,-0.0323375) , 
2, 1.80088, 1, 0, 0.254762,-0.00205461) , 
1, -0.764674, 1, 0, 0.25756,0.00412255)    );
  // itree = 2333
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.436441,-0.0136285) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.442804,-0.000202366) , 
0, -0.63215, 1, 0, 0.439842,0.0221696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.218456,-0.0015752) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0788091,-0.0146603) , 
2, 0.825502, 1, 0, 0.169626,0.00287474) , 
1, -0.426085, 1, 0, 0.233645,0.00744599)    );
  // itree = 2334
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150943,-0.0105132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0482785) , 
1, -1.4103, 1, 0, 0.241706,-0.040539) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311552,0.00914568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.246842,-0.00513997) , 
1, 0.418108, 1, 0, 0.276246,0.0034324) , 
1, -1.02829, 1, 0, 0.272771,-0.000992)    );
  // itree = 2335
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.084425,-0.00104568) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113527,0.00327681) , 
2, 0.0521533, 1, 0, 0.0953678,-0.0126523) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.561753,0.0166118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.434295,-0.000665371) , 
0, -0.268402, 1, 0, 0.470857,0.0206899) , 
1, 0.568008, 1, 0, 0.26164,0.0021121)    );
  // itree = 2336
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135449,-0.00999835) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.512698,0.0203275) , 
3, 0.408715, 1, 0, 0.259105,0.00485371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.346457,-0.0359433) , 
0, 1.52075, 1, 0, 0.264519,0.00105402)    );
  // itree = 2337
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517241,-0.00106347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.242329,-0.00479144) , 
2, -1.26936, 1, 0, 0.28019,0.000209613) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00869565,-0.0628175) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109785,-0.000920001) , 
0, 0.135593, 1, 0, 0.088015,0.0390882) , 
3, 0.832675, 1, 0, 0.229084,0.0105488)    );
  // itree = 2338
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.385185,-0.000820529) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325255,-0.00417234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175,0.000138105) , 
3, -0.31339, 1, 0, 0.238197,0.00585974) , 
0, -1.54277, 1, 0, 0.248124,0.00911464)    );
  // itree = 2339
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0864198,-0.0241561) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291585,-0.00187474) , 
0, -0.715752, 1, 0, 0.233357,-0.00263781) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.565217,0.0673072) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253589,0.000993755) , 
0, 0.139168, 1, 0, 0.320826,-0.01862) , 
3, 0.766583, 1, 0, 0.257143,-0.00698398)    );
  // itree = 2340
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254237,0.0457822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248738,-0.0273836) , 
0, -1.65909, 1, 0, 0.249169,-0.017384) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0762943,0.0057475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613793,0.0382957) , 
3, 1.38367, 1, 0, 0.228516,0.0212107) , 
1, 1.22922, 1, 0, 0.243927,-0.00758703)    );
  // itree = 2341
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357556,-0.00280347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111546,-0.00504296) , 
1, 0.834927, 1, 0, 0.284553,-0.00323046) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.104348,0.0263266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0432692,-0.0315156) , 
3, 1.58809, 1, 0, 0.0650155,0.0274231) , 
3, 1.29216, 1, 0, 0.249878,0.00161115)    );
  // itree = 2342
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240481,-0.000150485) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273345,-0.00138727) , 
1, -0.428552, 1, 0, 0.263566,0.00212681) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0163934,-0.0644633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.107843,-0.0484298) , 
1, 0.990141, 1, 0, 0.0736196,0.032687) , 
3, 1.22488, 1, 0, 0.232651,0.00710066)    );
  // itree = 2343
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0319635,0.0768187) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283657,-0.00126762) , 
1, -1.0067, 1, 0, 0.253304,-0.00355197) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247525,-0.0385571) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0850277) , 
0, 1.20402, 1, 0, 0.142857,0.0340192) , 
3, 1.64517, 1, 0, 0.242199,0.000225619)    );
  // itree = 2344
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207273,0.0165554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0708861,-0.0433625) , 
1, -0.89073, 1, 0, 0.106103,-0.0107188) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381223,0.0209541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.609959,-0.0144441) , 
3, 1.43952, 1, 0, 0.439619,0.0104154) , 
3, -0.0237104, 1, 0, 0.262817,-0.000788153)    );
  // itree = 2345
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381919,-0.00721744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.261029,0.00611617) , 
3, -0.901814, 1, 0, 0.301227,0.00712963) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0440529,-0.0175028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.157895,0.0578558) , 
3, 1.10315, 1, 0, 0.0986239,-0.0298395) , 
2, 1.04395, 1, 0, 0.25847,-0.000672176)    );
  // itree = 2346
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.459397,0.0177844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.129921,-0.0353567) , 
3, -0.609321, 1, 0, 0.337226,0.02607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.184953,0.00982721) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252665,0.0126097) , 
1, -0.141858, 1, 0, 0.235481,-0.00528728) , 
0, -0.369693, 1, 0, 0.27137,0.00577335)    );
  // itree = 2347
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227392,-0.00506992) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.019576) , 
3, 0.807669, 1, 0, 0.250657,-0.000369216) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128,0.00685757) , 
3, 1.75738, 1, 0, 0.243097,-0.00289271)    );
  // itree = 2348
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0670391,-0.0148851) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.374843,0.0173466) , 
3, -0.76076, 1, 0, 0.250751,0.00841445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.246875,-0.0374499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266667,0.00572178) , 
1, 0.811675, 1, 0, 0.255652,-0.0187988) , 
0, 0.646842, 1, 0, 0.252229,0.0002091)    );
  // itree = 2349
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380567,0.00753553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152,0.0097051) , 
3, -0.0905164, 1, 0, 0.281933,0.00190263) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.186275,-0.00388152) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232,0.0434809) , 
2, 0.689787, 1, 0, 0.211454,-0.0405129) , 
0, 1.31913, 1, 0, 0.273791,-0.00299728)    );
  // itree = 2350
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271186,-0.0173511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101852,-0.0237721) , 
3, -1.03956, 1, 0, 0.190265,0.0357503) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235294,-0.021362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259628,0.00500185) , 
1, -0.280539, 1, 0, 0.257846,-0.000331751) , 
1, -0.484715, 1, 0, 0.243139,0.00752048)    );
  // itree = 2351
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.159618,-0.0160272) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.542125,0.0173372) , 
1, 1.39796, 1, 0, 0.219666,0.00280114) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.651899,0.0264778) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.290323,0.0222462) , 
0, 1.4769, 1, 0, 0.472843,-0.022334) , 
0, 1.17201, 1, 0, 0.258285,-0.00103282)    );
  // itree = 2352
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0500835,-0.0179747) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327806,0.0191871) , 
3, -0.695211, 1, 0, 0.20752,0.00796603) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.112022,-0.045349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.657143,0.00358012) , 
3, 1.08881, 1, 0, 0.330606,-0.0109864) , 
2, 0.741869, 1, 0, 0.245236,0.00215864)    );
  // itree = 2353
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.360931,-0.00610047) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180976,0.00875432) , 
2, -0.256896, 1, 0, 0.251912,-0.00962856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.180952,-0.00500732) , 
1, 1.69404, 1, 0, 0.248306,-0.00701733)    );
  // itree = 2354
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288809,-0.00248379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.268817,0.0160639) , 
0, 0.271021, 1, 0, 0.282113,-0.00177719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00934579,-0.0474932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.126437,-0.0225604) , 
0, 0.574506, 1, 0, 0.0923913,0.0257485) , 
3, 1.19852, 1, 0, 0.247788,0.00320288)    );
  // itree = 2355
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.213523,-0.00306889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417808,0.0278925) , 
3, 0.968818, 1, 0, 0.248674,-0.0125782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.577982,0.0257) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0578512,-0.0313675) , 
3, 1.0189, 1, 0, 0.304348,0.0388473) , 
2, 1.40517, 1, 0, 0.255319,-0.00644025)    );
  // itree = 2356
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.103896,0.0842535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.255609,0.0112746) , 
2, -1.56538, 1, 0, 0.238944,0.0136707) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.311164,-0.0373512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.36413,0.0198203) , 
2, 1.61391, 1, 0, 0.327273,-0.0167691) , 
2, 0.690799, 1, 0, 0.26557,0.00449477)    );
  // itree = 2357
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.269253,-0.000297754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0333333,-0.0310448) , 
3, 1.53018, 1, 0, 0.247284,-0.00311554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.300971,0.0411062) , 
0, 1.55414, 1, 0, 0.25,-0.00610215)    );
  // itree = 2358
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257766,-0.00791464) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.163793,-0.0145834) , 
0, 0.927157, 1, 0, 0.251074,0.00590354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0757576,-0.0376478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.18018,-0.0373111) , 
1, 0.760663, 1, 0, 0.113269,-0.0303348) , 
0, 1.1334, 1, 0, 0.229102,0.000125599)    );
  // itree = 2359
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219788,-0.00667926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.417625,0.00785007) , 
2, 1.07501, 1, 0, 0.24901,0.00238377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.595041,0.0495258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0892857,-0.0118269) , 
2, 0.88807, 1, 0, 0.301038,-0.045804) , 
3, 1.34716, 1, 0, 0.256323,-0.0043897)    );
  // itree = 2360
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198795,-0.0291624) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245564,-0.0054584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23565,-0.0180009) , 
0, 1.13303, 1, 0, 0.243678,-0.00713084) , 
0, -1.37002, 1, 0, 0.239769,-0.00894459)    );
  // itree = 2361
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.509485,-0.00388176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.294643,-0.00765614) , 
0, 0.391062, 1, 0, 0.459459,0.0292956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258503,0.000869875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169383,-0.00322883) , 
0, -1.03387, 1, 0, 0.177792,0.0036608) , 
1, -0.512249, 1, 0, 0.244237,0.00970806)    );
  // itree = 2362
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.418033,-0.0127047) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208861,0.00486841) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237721,-0.00110679) , 
1, -0.71469, 1, 0, 0.232773,-0.00275819) , 
0, -1.66344, 1, 0, 0.244275,0.000345397)    );
  // itree = 2363
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.230722,-0.00642352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.232143,-0.0330011) , 
2, 1.17834, 1, 0, 0.230813,-0.00541455) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314286,-0.00734541) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243697,-0.00481169) , 
0, 0.912589, 1, 0, 0.276786,-0.0403724) , 
2, 1.42243, 1, 0, 0.236041,-0.00938945)    );
  // itree = 2364
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.211679,0.021038) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.320388,0.0724825) , 
1, -1.31414, 1, 0, 0.258333,0.0389389) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241667,-0.00329805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34375,-0.0265613) , 
1, 1.61465, 1, 0, 0.249408,-0.00572654) , 
1, -0.943262, 1, 0, 0.250519,-0.000166526)    );
  // itree = 2365
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.284977,0.00226182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0851064,0.0453864) , 
3, 1.4084, 1, 0, 0.268322,-0.000289615) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113402,-0.029445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.118056,-0.0356776) , 
3, 1.08356, 1, 0, 0.116183,0.0564133) , 
0, 1.32355, 1, 0, 0.249353,0.00677991)    );
  // itree = 2366
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.34,0.0110465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.515152,0.0152721) , 
1, -0.513925, 1, 0, 0.421986,-0.0313731) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234987,-0.000401565) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.229232,0.00382092) , 
1, 0.392123, 1, 0, 0.2318,-0.00227906) , 
0, -1.03387, 1, 0, 0.258629,-0.00638337)    );
  // itree = 2367
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777244) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.288184,-0.00466287) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238739,-0.00937272) , 
2, 0.915963, 1, 0, 0.276201,-0.00592664) , 
1, -1.26922, 1, 0, 0.254912,-0.00878941)    );
  // itree = 2368
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233218,0.000110811) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875,-0.0408299) , 
1, 1.5027, 1, 0, 0.220869,-0.00291889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748466,0.0320814) , 
3, 1.73078, 1, 0, 0.262799,0.00173517)    );
  // itree = 2369
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.64,0.000885864) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387597,-0.00950293) , 
1, -1.31963, 1, 0, 0.511811,-0.0236934) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27563,0.00807615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.183288,0.00639575) , 
3, -0.485803, 1, 0, 0.215457,0.00555987) , 
1, -0.952616, 1, 0, 0.253823,0.00177275)    );
  // itree = 2370
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337423,-0.00423844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.00377431) , 
1, 0.48432, 1, 0, 0.304598,-0.00686468) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.124138,-0.00310504) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208582,-0.00119417) , 
1, -0.425837, 1, 0, 0.196138,0.0136449) , 
0, 0.0296075, 1, 0, 0.251972,0.0030867)    );
  // itree = 2371
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0780669,-0.0105009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237288,0.0258653) , 
3, 0.936736, 1, 0, 0.100559,-0.00972896) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.617647,0.0190442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.150943,-0.0664051) , 
0, 1.08649, 1, 0, 0.545322,0.0151715) , 
1, 0.949714, 1, 0, 0.257615,-0.000936029)    );
  // itree = 2372
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0542636,-0.0122802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330935,-0.0458677) , 
3, -1.37293, 1, 0, 0.197761,-0.0378131) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0722291,-0.0240671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.410959,0.0134098) , 
3, -0.0236163, 1, 0, 0.255708,0.00425018) , 
1, -0.843018, 1, 0, 0.24802,-0.00133049)    );
  // itree = 2373
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.366038,0.00126707) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.243022,-0.00613564) , 
0, -1.01708, 1, 0, 0.261822,0.00251722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.017094,-0.0395699) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0934579,-0.033763) , 
0, 1.22261, 1, 0, 0.0535714,0.0292453) , 
3, 1.61709, 1, 0, 0.237998,0.00557498)    );
  // itree = 2374
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270936,0.00640172) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0804388) , 
3, 1.31412, 1, 0, 0.242826,0.00332945) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.428571,-0.0118354) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,0.0215623) , 
3, 1.31712, 1, 0, 0.317992,-0.0264346) , 
2, 1.42243, 1, 0, 0.251585,-0.000138905)    );
  // itree = 2375
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0578512,0.0868426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0849057,-0.0330102) , 
1, -0.949672, 1, 0, 0.066092,0.0325659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257705,0.0034933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.392694,0.00259914) , 
0, 0.823264, 1, 0, 0.294521,-0.00395745) , 
1, -0.72175, 1, 0, 0.253838,0.00254722)    );
  // itree = 2376
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.150794,-0.0408088) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.263554,0.00687139) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237013,-0.011023) , 
0, 0.677828, 1, 0, 0.255144,0.000387876) , 
0, -1.51272, 1, 0, 0.248792,-0.00194129)    );
  // itree = 2377
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287446,0.000179899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228893,0.00623696) , 
0, 0.580642, 1, 0, 0.271318,0.00581497) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0492958,-0.0355494) , 
3, 1.73078, 1, 0, 0.256139,0.0104565)    );
  // itree = 2378
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281325,0.00138296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0707071,-0.00217874) , 
3, 1.3077, 1, 0, 0.269471,-0.00590324) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.076555,-0.000500896) , 
3, 1.56809, 1, 0, 0.248984,-0.0084862)    );
  // itree = 2379
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00649351,0.162435) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.34186,0.043317) , 
1, -1.07649, 1, 0, 0.253425,-0.0146661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0958904,-0.0406936) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.239095,-0.0191494) , 
1, -0.656859, 1, 0, 0.223988,0.0109195) , 
3, -0.871513, 1, 0, 0.232724,0.00332706)    );
  // itree = 2380
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.0544148) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0194175,-0.0443039) , 
1, -0.619129, 1, 0, 0.0445344,-0.0305001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.209967,0.00690906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.591346,-0.0203145) , 
3, 1.48262, 1, 0, 0.256276,0.000620976) , 
2, -1.31038, 1, 0, 0.229592,-0.00330092)    );
  // itree = 2381
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.372774,0.0009321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.185223,0.00379328) , 
3, -0.409799, 1, 0, 0.26832,0.00646442) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137255,-0.00123849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186992,0.00552324) , 
1, 0.325602, 1, 0, 0.164444,-0.0283369) , 
0, 1.32355, 1, 0, 0.256628,0.00254731)    );
  // itree = 2382
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324693,0.00821378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.094086,-0.00217444) , 
3, 0.80919, 1, 0, 0.27802,7.70648e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0610687,-0.00987653) , 
3, 1.76021, 1, 0, 0.263586,-0.00327824)    );
  // itree = 2383
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.135493,-0.0132309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.29375,0.0301149) , 
3, 1.28709, 1, 0, 0.152174,-0.0124644) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.711806,-0.00397346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.312195,0.0121003) , 
1, 1.50441, 1, 0, 0.545639,0.0116275) , 
1, 1.22294, 1, 0, 0.248633,-0.00655827)    );
  // itree = 2384
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.28092,0.00382404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.280374,-0.0627865) , 
2, 1.07178, 1, 0, 0.28087,-0.00167456) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0976909,0.000326007) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.510549,0.028247) , 
3, 1.17283, 1, 0, 0.22,0.0151791) , 
1, 0.66404, 1, 0, 0.255897,0.00523975)    );
  // itree = 2385
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.695946,0.0145511) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196581,0.0122775) , 
3, -1.06737, 1, 0, 0.475472,0.0128256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.337547,0.010401) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.1439,-0.00227132) , 
1, 0.333453, 1, 0, 0.231429,-0.00921861) , 
2, -1.2086, 1, 0, 0.263524,-0.00631949)    );
  // itree = 2386
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244318,0.0136985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.239575,0.00126714) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31203,-0.00715368) , 
2, 0.808191, 1, 0, 0.261538,-0.000522386) , 
1, -1.06103, 1, 0, 0.259969,-0.0034552)    );
  // itree = 2387
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0207254,-0.00527187) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947867,0.0204044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288438,-8.21496e-05) , 
1, -0.676083, 1, 0, 0.266195,0.00793894) , 
1, -1.08065, 1, 0, 0.242857,0.00316542)    );
  // itree = 2388
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236364,0.0615639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.256158,0.0208082) , 
0, -0.848785, 1, 0, 0.249201,0.0332179) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238817,-0.00939439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.245614,0.0165867) , 
0, 1.24997, 1, 0, 0.239777,-0.00372603) , 
1, -0.796791, 1, 0, 0.241308,0.00227472)    );
  // itree = 2389
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.470779,-0.00120296) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231579,0.00137203) , 
3, -0.298045, 1, 0, 0.379518,-0.0114106) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127865,-0.0010403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128028,-0.00231822) , 
0, 0.909224, 1, 0, 0.127907,0.0112681) , 
1, 0.240541, 1, 0, 0.246452,0.00058313)    );
  // itree = 2390
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212911,-0.00484368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317784,0.00661202) , 
2, 0.957735, 1, 0, 0.23132,-0.00016634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.352381,0.00575708) , 
2, 1.86316, 1, 0, 0.237494,0.0036489)    );
  // itree = 2391
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243366,0.00430574) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247863,-0.01742) , 
2, 0.693276, 1, 0, 0.244544,0.00657368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197452,-0.0191581) , 
1, 1.55041, 1, 0, 0.240741,0.00412573)    );
  // itree = 2392
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.126872,-0.0052637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451554,-0.0176301) , 
3, 0.484971, 1, 0, 0.22467,-0.00973018) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.0121269) , 
1, 1.5317, 1, 0, 0.235498,-0.00716199)    );
  // itree = 2393
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.382872,-0.00428154) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.235418,-0.00258996) , 
3, -1.22637, 1, 0, 0.267582,0.00300971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0742574,-0.00875828) , 
3, 1.56271, 1, 0, 0.248269,0.000385333)    );
  // itree = 2394
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148387,-0.0220445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278302,0.00257421) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.210811,-0.00588947) , 
1, 1.36114, 1, 0, 0.264833,0.000184729) , 
1, -1.22512, 1, 0, 0.255849,-0.00348893)    );
  // itree = 2395
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0726073,-0.0162203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0883978,-0.023893) , 
2, -0.160018, 1, 0, 0.0800696,-0.0162636) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.562852,0.00708234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.227528,-0.0184687) , 
2, 0.885048, 1, 0, 0.428571,0.0165548) , 
1, 0.570927, 1, 0, 0.23209,-0.00194782)    );
  // itree = 2396
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.296875,0.103779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30198,0.0135749) , 
0, -0.883925, 1, 0, 0.3,0.0425718) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.278075,-0.00679626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.234234,0.0113182) , 
1, 0.517322, 1, 0, 0.254279,0.00252674) , 
1, -0.796791, 1, 0, 0.261953,0.00924843)    );
  // itree = 2397
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.289389,0.00123298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0333333,-0.0273882) , 
2, 1.38493, 1, 0, 0.266862,-0.00157484) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.042933) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.209091,0.0180626) , 
0, 0.319696, 1, 0, 0.123457,0.0324102) , 
1, 1.47131, 1, 0, 0.248973,0.00266456)    );
  // itree = 2398
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241107,-0.0106858) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286442,-0.0011191) , 
1, -0.754602, 1, 0, 0.277148,-0.0124979) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165261,0.00275782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448276,0.0247725) , 
2, 1.68383, 1, 0, 0.211566,0.00903579) , 
0, 0.435422, 1, 0, 0.253217,-0.00464026)    );
  // itree = 2399
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0550847,-0.00438856) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113586,-0.0118516) , 
3, -1.50856, 1, 0, 0.101411,0.00765186) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.524217,0.00836754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38343,0.000843922) , 
0, -0.0392497, 1, 0, 0.44023,-0.0150173) , 
1, 0.568008, 1, 0, 0.248503,-0.00218955)    );
  // itree = 2400
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.217687,0.032784) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.214841,-0.0048398) , 
0, -0.711503, 1, 0, 0.215517,0.00326555) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.575,-0.0270469) , 
3, 1.65635, 1, 0, 0.250486,-0.00144398)    );
  // itree = 2401
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.585106,-0.0131652) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00943396,-0.0696347) , 
1, 0.14836, 1, 0, 0.377551,0.0252357) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259358,0.0118512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0806452,-0.00644305) , 
3, 1.53289, 1, 0, 0.233945,-0.00355449) , 
2, -1.10481, 1, 0, 0.254661,0.000598754)    );
  // itree = 2402
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.107143,-0.011035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.359596,-0.00392577) , 
2, -1.2712, 1, 0, 0.317875,-0.00979103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00862069,-0.0650076) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135854,-0.0112446) , 
0, -0.325607, 1, 0, 0.118072,0.0158351) , 
3, 0.15517, 1, 0, 0.235615,0.00075943)    );
  // itree = 2403
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165414,0.0837511) , 
0, -0.443026, 1, 0, 0.0774648,-0.034183) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292127,0.013771) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221184,-0.0253539) , 
3, 1.2983, 1, 0, 0.278571,0.00190685) , 
1, -0.840753, 1, 0, 0.249491,-0.00331184)    );
  // itree = 2404
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137405,-0.04474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.104046,-0.0137361) , 
0, -1.06586, 1, 0, 0.113208,-0.0192352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.2901,0.00551496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252381,-0.0204346) , 
1, 1.49547, 1, 0, 0.284865,0.000793774) , 
2, -0.753576, 1, 0, 0.243719,-0.00400714)    );
  // itree = 2405
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.593909,0.00863031) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295124,0.000827448) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.128276,0.00380771) , 
3, 0.436904, 1, 0, 0.231257,0.00381199) , 
1, -1.07868, 1, 0, 0.265423,0.000858188)    );
  // itree = 2406
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0625,-0.0490499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,0.00390637) , 
2, -1.5265, 1, 0, 0.348711,-0.0119572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170762,-0.0172427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.203046,0.00713164) , 
0, 0.90545, 1, 0, 0.181291,0.0135303) , 
3, -0.502231, 1, 0, 0.24473,0.00387258)    );
  // itree = 2407
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.279245,0.0621952) , 
3, -2.17896, 1, 0, 0.200542,-0.0120679) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0413223,-0.0779138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264892,-0.00474145) , 
0, -0.977212, 1, 0, 0.24897,0.017082) , 
3, -1.33958, 1, 0, 0.240329,0.0118807)    );
  // itree = 2408
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247619,0.0577149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189624,-0.00975811) , 
0, -1.6245, 1, 0, 0.193042,-0.00379309) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.541284,-0.00248293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.707692,0.0421722) , 
0, 1.02804, 1, 0, 0.631799,0.0434034) , 
3, 1.52344, 1, 0, 0.244928,0.00178829)    );
  // itree = 2409
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475066,0.000841727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24639,0.0056929) , 
1, -0.556218, 1, 0, 0.304903,-0.0100001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0547264,-0.0403342) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627063,-0.0107033) , 
2, 1.33545, 1, 0, 0.0595238,0.0183186) , 
2, 0.901093, 1, 0, 0.24285,-0.00283873)    );
  // itree = 2410
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282248,2.46407e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174603,0.00581814) , 
0, 0.931031, 1, 0, 0.267327,-0.00177391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.213115,0.0282256) , 
0, 1.3861, 1, 0, 0.262369,-0.00517697)    );
  // itree = 2411
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0777949) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271754,0.00760575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262987,0.00686294) , 
2, 1.31998, 1, 0, 0.270255,-0.000622048) , 
0, -1.43147, 1, 0, 0.250128,-0.00474392)    );
  // itree = 2412
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.236111,0.0134538) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259804,-0.0406366) , 
2, 1.34665, 1, 0, 0.238814,0.00487243) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0357143,0.0352086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.587719,0.0521636) , 
3, 1.12787, 1, 0, 0.314159,0.0551127) , 
0, 1.2914, 1, 0, 0.247269,0.0105101)    );
  // itree = 2413
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.481172,0.00603617) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.233016,-0.000888929) , 
2, -1.30495, 1, 0, 0.265711,0.000400212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.187135,0.0321037) , 
1, 1.5441, 1, 0, 0.258942,-0.00480629)    );
  // itree = 2414
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320524,-0.00281352) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215827,0.000547038) , 
3, 0.227243, 1, 0, 0.30919,-0.0157166) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0827998) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.221675,0.0300191) , 
2, 0.612441, 1, 0, 0.138675,0.0161413) , 
3, 0.478985, 1, 0, 0.25194,-0.00502037)    );
  // itree = 2415
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0575916,-0.00182054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.095,-0.0234171) , 
3, -1.00129, 1, 0, 0.0829103,0.0159807) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557252,0.0223341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222772,-0.0124225) , 
2, 1.44513, 1, 0, 0.478413,-0.00746238) , 
1, 0.647048, 1, 0, 0.249142,0.00612748)    );
  // itree = 2416
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151261,-0.0173362) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.514493,-0.0474254) , 
3, 0.0519956, 1, 0, 0.219645,-0.0233936) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0952941,-0.0282805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.520629,0.0149733) , 
3, 0.757751, 1, 0, 0.254599,0.000518456) , 
1, -0.128677, 1, 0, 0.242352,-0.00785989)    );
  // itree = 2417
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.56051,0.0101965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.288918,0.00454136) , 
2, -0.952927, 1, 0, 0.36847,-0.0141765) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,-0.0254744) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15512,0.00266749) , 
2, 0.0571631, 1, 0, 0.148577,0.00669077) , 
3, -0.0237104, 1, 0, 0.265215,-0.00437787)    );
  // itree = 2418
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.158301,-0.0165638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.38207,0.0103717) , 
2, -0.129708, 1, 0, 0.28063,-0.00672827) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0196078,-0.0191643) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0776699,-0.0443168) , 
1, 1.12926, 1, 0, 0.0487805,0.0474638) , 
3, 1.59147, 1, 0, 0.255862,-0.00093912)    );
  // itree = 2419
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208669,-0.00691056) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584746,-0.00113019) , 
0, 1.2809, 1, 0, 0.234276,-0.0086791) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149533,-0.0327924) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.283582,-0.0266688) , 
1, 0.844499, 1, 0, 0.237013,0.0263562) , 
3, 1.28958, 1, 0, 0.234689,-0.00339206)    );
  // itree = 2420
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.183544,0.00856166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.286385,0.0467202) , 
2, -0.207498, 1, 0, 0.232222,0.0216063) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.283315,0.00423069) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.273973,-0.0281071) , 
1, 1.49547, 1, 0, 0.282002,-0.00199726) , 
0, -0.0968335, 1, 0, 0.258896,0.00895851)    );
  // itree = 2421
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345614,-0.0131819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.222308,0.0119531) , 
3, -0.855601, 1, 0, 0.259893,-0.00694826) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.062069,-0.0251516) , 
2, 1.7595, 1, 0, 0.245658,-0.00405208)    );
  // itree = 2422
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.277677,0.0081014) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0832764) , 
3, 1.43969, 1, 0, 0.252059,-0.0100433) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.401709,-0.0340392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172662,-0.0283393) , 
3, 0.787904, 1, 0, 0.277344,0.0243319) , 
2, 1.40345, 1, 0, 0.255176,-0.00580643)    );
  // itree = 2423
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.200403,-0.000816909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613065,-0.00977164) , 
3, 0.608617, 1, 0, 0.269295,0.00605181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.325459,0.0195716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.176707,0.00269181) , 
3, 0.401748, 1, 0, 0.241183,-0.0189151) , 
2, 0.349516, 1, 0, 0.257364,-0.00454494)    );
  // itree = 2424
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171429,0.00205486) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152439,-0.0786771) , 
2, -0.942111, 1, 0, 0.161184,-0.0360193) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242647,-0.0329622) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250321,0.00189725) , 
1, -0.897857, 1, 0, 0.249705,-0.00138405) , 
0, -0.920459, 1, 0, 0.236236,-0.00665388)    );
  // itree = 2425
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.473904,0.00414447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.318519,0.00176499) , 
0, 0.655412, 1, 0, 0.439739,-0.0241649) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.154582,-0.0121978) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.184615,0.00233803) , 
1, 1.61442, 1, 0, 0.157401,0.00404359) , 
1, -0.236469, 1, 0, 0.244122,-0.00462076)    );
  // itree = 2426
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361423,0.000604563) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206311,-0.00116347) , 
3, -0.813001, 1, 0, 0.267305,0.00454041) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220183,-0.0200137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.140476,-0.0143401) , 
0, 0.968331, 1, 0, 0.167712,-0.0135564) , 
0, 0.585609, 1, 0, 0.235471,-0.00124405)    );
  // itree = 2427
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0220588,-0.0102834) , 
1, -0.715188, 1, 0, 0.0122449,-0.0256289) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133736,-0.0179975) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.58319,0.014676) , 
1, 1.07565, 1, 0, 0.284156,0.00769926) , 
0, -1.08742, 1, 0, 0.250629,0.00358985)    );
  // itree = 2428
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242991,0.0753131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.228267,0.00796499) , 
1, -1.40758, 1, 0, 0.229101,0.00947682) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.613333,-0.0307177) , 
3, 1.74313, 1, 0, 0.257353,0.00524055)    );
  // itree = 2429
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302379,-0.00622761) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132716,-0.0118892) , 
3, 0.571252, 1, 0, 0.268593,0.00725764) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0612245,-0.00881537) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.065,-0.0291047) , 
1, 0.757008, 1, 0, 0.0637584,-0.0411981) , 
3, 1.2983, 1, 0, 0.236883,-0.000243559)    );
  // itree = 2430
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.395402,0.00476126) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.310976,0.0159429) , 
1, 0.600425, 1, 0, 0.372287,0.00960237) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.294408,0.00323736) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.144854,0.00248634) , 
3, 0.151821, 1, 0, 0.210036,-0.00794849) , 
0, -0.534386, 1, 0, 0.258776,-0.00267619)    );
  // itree = 2431
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750385) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0896686,0.00165504) , 
0, -1.1588, 1, 0, 0.0719875,0.0262617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381995,0.0128592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.132867,0.0653628) , 
3, 1.75426, 1, 0, 0.356105,-0.0040305) , 
1, -0.181481, 1, 0, 0.266005,0.0055758)    );
  // itree = 2432
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237524,0.00136776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.368421,0.055042) , 
0, 0.970856, 1, 0, 0.246317,0.00504449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0730337,0.0522981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.469697,-0.0465143) , 
3, 1.40697, 1, 0, 0.241935,-0.0268934) , 
0, 1.17225, 1, 0, 0.24564,0.000111381)    );
  // itree = 2433
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.302326,0.00504218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0185185,-0.0272461) , 
2, 1.45817, 1, 0, 0.281671,-0.00101262) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.282609,0.0142439) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133127,-0.00798594) , 
0, 1.11584, 1, 0, 0.187377,-0.0271148) , 
0, 0.813325, 1, 0, 0.257659,-0.00765943)    );
  // itree = 2434
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194131,0.00455843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390274,0.00779121) , 
2, 0.046754, 1, 0, 0.287322,0.00562181) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0793857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135417,-0.00452256) , 
2, 0.750689, 1, 0, 0.0887372,-0.0475759) , 
3, 1.30263, 1, 0, 0.257951,-0.0022464)    );
  // itree = 2435
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.254132,0.000598664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238051,0.000929285) , 
2, -0.643858, 1, 0, 0.243069,-0.00498086) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240876,0.0328693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272152,-0.0395986) , 
1, 0.732998, 1, 0, 0.262693,0.0199482) , 
3, 0.892407, 1, 0, 0.247505,0.000654311)    );
  // itree = 2436
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127517,-0.052029) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.303571,0.0462642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254266,-0.0064948) , 
0, -1.07724, 1, 0, 0.257219,-0.00287956) , 
0, -1.50708, 1, 0, 0.247647,-0.00572931)    );
  // itree = 2437
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.409953,0.00323322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.102985,-0.0100228) , 
1, 0.522871, 1, 0, 0.274108,0.00105521) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191176,-0.00720566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167665,0.0392146) , 
3, 1.41219, 1, 0, 0.182232,-0.030829) , 
0, 0.893748, 1, 0, 0.253456,-0.0061118)    );
  // itree = 2438
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327448,-0.0122733) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189873,0.0112995) , 
1, 0.886747, 1, 0, 0.289535,-0.0162982) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.137931,0.0176994) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.205441,0.00201508) , 
1, -0.696186, 1, 0, 0.198816,0.000516024) , 
0, -0.179916, 1, 0, 0.237023,-0.00656537)    );
  // itree = 2439
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.118123,-0.0256036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.305122,0.00132343) , 
0, -0.420895, 1, 0, 0.228892,0.00132854) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517241,0.0225022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.196809,-0.0325681) , 
0, 0.139178, 1, 0, 0.272358,0.0208958) , 
3, 0.867657, 1, 0, 0.239542,0.00612291)    );
  // itree = 2440
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,0.0138195) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115854,-0.0309346) , 
0, 1.04529, 1, 0, 0.197406,0.00657753) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194175,-0.101996) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365714,-0.00217784) , 
2, 0.838709, 1, 0, 0.33758,-0.016828) , 
2, 0.684444, 1, 0, 0.241071,-0.000713488)    );
  // itree = 2441
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.589286,-0.008158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276139,-0.000890485) , 
2, -1.49723, 1, 0, 0.30463,0.00125944) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.151515,0.00204693) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.136442,0.0135905) , 
1, 0.100405, 1, 0, 0.139241,-0.0170965) , 
3, 0.356731, 1, 0, 0.244078,-0.00546098)    );
  // itree = 2442
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0676692,-0.020322) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.297017,0.00860898) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264398,0.00246477) , 
1, 0.16599, 1, 0, 0.277517,0.0045767) , 
2, -1.59958, 1, 0, 0.263902,0.00258692)    );
  // itree = 2443
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257527,-0.00262283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20197,-0.0120017) , 
2, 0.925215, 1, 0, 0.251134,-0.00539272) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315385,0.0240686) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.216981,0.0151215) , 
0, 1.11704, 1, 0, 0.271186,0.0338904) , 
2, 1.4084, 1, 0, 0.2535,-0.000757309)    );
  // itree = 2444
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215269,-0.00329997) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.525773,-0.080304) , 
3, 1.64983, 1, 0, 0.233038,-0.00852372) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291667,-0.0131228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489796,0.0455581) , 
0, 1.01427, 1, 0, 0.391753,0.0260015) , 
2, 1.51294, 1, 0, 0.249338,-0.00497799)    );
  // itree = 2445
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.40884,0.00512183) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142125,-0.0101708) , 
2, 0.0267049, 1, 0, 0.285291,-0.000890882) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0674157,0.00389403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.115108,-0.0097435) , 
1, 1.36969, 1, 0, 0.0883281,0.0365152) , 
3, 1.30934, 1, 0, 0.254119,0.0050291)    );
  // itree = 2446
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.380952,0.0040149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0759494,-0.0211912) , 
3, -0.295296, 1, 0, 0.263415,0.00988561) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240977,-0.00152286) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.207317,0.0261745) , 
0, 1.21232, 1, 0, 0.235986,-0.00956294) , 
1, 0.324332, 1, 0, 0.249179,-0.00020829)    );
  // itree = 2447
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164384,-0.00872801) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.343826,0.00237682) , 
0, -0.235508, 1, 0, 0.25964,0.00102238) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.374517,0.0238659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0753937) , 
3, 2.0288, 1, 0, 0.270195,-0.0405117) , 
3, 1.13793, 1, 0, 0.261619,-0.00676391)    );
  // itree = 2448
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.141123,0.00113366) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496051,0.0219525) , 
3, 0.441796, 1, 0, 0.256279,0.00980731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.339623,-0.0276469) , 
1, 1.7097, 1, 0, 0.260574,0.00714999)    );
  // itree = 2449
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.413598,-0.00247948) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.134701,-0.00258412) , 
1, -0.0220085, 1, 0, 0.242474,0.00474782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.276423,0.0351571) , 
0, 1.54569, 1, 0, 0.244615,-0.000967026)    );
  // itree = 2450
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.185484,0.00282939) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.321212,0.0129376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177806,-0.0203646) , 
1, 0.664566, 1, 0, 0.257431,0.00789875) , 
1, -1.31444, 1, 0, 0.252753,0.00495597)    );
  // itree = 2451
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0369128,-0.0082793) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0972973,-0.031598) , 
3, -1.06355, 1, 0, 0.0703593,0.0270448) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.410354,0.013894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.220149,-0.00738605) , 
2, 0.729131, 1, 0, 0.333584,0.000705486) , 
1, -0.166244, 1, 0, 0.245491,0.00952045)    );
  // itree = 2452
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.165685,0.000874214) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.581301,0.0318525) , 
3, 0.63263, 1, 0, 0.236934,0.00828059) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.177936,-0.0448301) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.267797,0.000933918) , 
1, 0.525356, 1, 0, 0.223958,-0.0200815) , 
0, 0.676581, 1, 0, 0.233217,0.000156979)    );
  // itree = 2453
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.320435,0.00331594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177028,-0.0254375) , 
0, -0.109009, 1, 0, 0.243806,0.00279729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0916667,-0.0201079) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15625,0.0152597) , 
3, 1.06311, 1, 0, 0.125,-0.0229422) , 
1, 1.47236, 1, 0, 0.229249,-0.000356557)    );
  // itree = 2454
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.373626,0.00748823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.000872553) , 
3, -1.51434, 1, 0, 0.291724,0.00443824) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0776925) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139373,0.0120818) , 
2, 0.612441, 1, 0, 0.0952381,-0.0319133) , 
3, 0.951289, 1, 0, 0.247594,-0.00372629)    );
  // itree = 2455
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.247701,0.00343177) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.390244,-0.019747) , 
1, 1.51115, 1, 0, 0.257697,-0.00278234) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.306452,-0.0205318) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0363636,-0.0311587) , 
2, 1.4946, 1, 0, 0.206081,0.0245767) , 
3, 1.36188, 1, 0, 0.250244,0.00116803)    );
  // itree = 2456
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22546,0.0108946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161205,-0.0188838) , 
1, -0.176509, 1, 0, 0.184728,-0.00360402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.598425,0.0363129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.675214,0.0107199) , 
2, 1.23712, 1, 0, 0.635246,0.0373081) , 
3, 1.35923, 1, 0, 0.239012,0.00132565)    );
  // itree = 2457
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.420082,-0.0122333) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21902,0.00862581) , 
1, -0.465459, 1, 0, 0.271322,-0.00883428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0928962,-0.00170485) , 
3, 1.61197, 1, 0, 0.255464,-0.0054207)    );
  // itree = 2458
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.153846,-0.00185203) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0788611) , 
3, -1.06737, 1, 0, 0.0876494,-0.0286391) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.314726,0.00590556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.20558,-0.0118689) , 
1, 0.781379, 1, 0, 0.271512,-0.000617628) , 
2, -1.25688, 1, 0, 0.248097,-0.00418607)    );
  // itree = 2459
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00574713,-0.0595731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.253155,-0.00555422) , 
1, -1.14237, 1, 0, 0.223301,-0.00407709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308017,-0.00901737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.307895,0.0167701) , 
3, 1.10393, 1, 0, 0.307942,0.0183636) , 
3, 0.647058, 1, 0, 0.248664,0.00264748)    );
  // itree = 2460
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128413,-0.00707829) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.445242,0.0100359) , 
3, 0.49827, 1, 0, 0.220711,0.000936614) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.546584,-0.0612333) , 
3, 1.75738, 1, 0, 0.24602,-0.00748177)    );
  // itree = 2461
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.424779,0.00679361) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.315409,0.0036122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0943396,-0.0103642) , 
2, 0.568731, 1, 0, 0.236693,-0.00271674) , 
0, -1.61795, 1, 0, 0.24707,9.7657e-05)    );
  // itree = 2462
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.181025,-0.00313051) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.354595,0.0141225) , 
2, 0.0267049, 1, 0, 0.268187,-0.000467519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0526316,-0.0369324) , 
3, 1.74551, 1, 0, 0.251755,0.00262282)    );
  // itree = 2463
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,-0.0216634) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.188679,-0.028856) , 
3, -1.00222, 1, 0, 0.0956522,0.0185857) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0914634,0.0384599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330764,0.00426518) , 
1, -0.826967, 1, 0, 0.306097,0.00245187) , 
0, -0.747863, 1, 0, 0.258898,0.00607037)    );
  // itree = 2464
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.056701,-0.0522382) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253012,0.0529529) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.287015,0.00822395) , 
0, -1.15162, 1, 0, 0.283903,0.0109684) , 
2, -1.46199, 1, 0, 0.261952,0.0072392)    );
  // itree = 2465
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.000400498) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.357955,0.0187653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21628,-0.000439115) , 
0, -0.831508, 1, 0, 0.229693,-0.00622405) , 
0, -1.2692, 1, 0, 0.245862,-0.00369027)    );
  // itree = 2466
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298327,0.00271762) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.21875,-0.00352739) , 
0, 0.154098, 1, 0, 0.284615,0.00371124) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.114144,0.00176696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.254967,-0.0258755) , 
2, 0.857977, 1, 0, 0.174468,-0.0225036) , 
0, 0.518813, 1, 0, 0.245885,-0.00550644)    );
  // itree = 2467
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.245902,0.00277799) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,0.0226772) , 
1, 1.59889, 1, 0, 0.246136,8.72771e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.373737,0.0288343) , 
0, 1.3861, 1, 0, 0.259126,-0.00382576)    );
  // itree = 2468
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.178838,0.00121008) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.319672,-0.0556404) , 
3, 0.313975, 1, 0, 0.200504,-0.0100165) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0490909,-0.00931946) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.476943,0.0178286) , 
3, 0.217925, 1, 0, 0.297173,0.0120438) , 
0, -0.293879, 1, 0, 0.260704,0.00372132)    );
  // itree = 2469
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.627027,0.0258354) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.242003,-0.00787149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0935961,0.00533021) , 
3, 1.04553, 1, 0, 0.209328,0.0094653) , 
1, -1.19679, 1, 0, 0.247413,0.00581057)    );
  // itree = 2470
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.482143,0.016139) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.243106,0.00187499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270968,-0.0145744) , 
1, 1.55404, 1, 0, 0.245342,-0.00441) , 
0, -1.69913, 1, 0, 0.258317,-0.000880934)    );
  // itree = 2471
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,-0.00983902) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291925,0.0133) , 
2, -0.218131, 1, 0, 0.219632,-0.00995838) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322635,-0.0157398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152,-0.0208873) , 
2, 0.545541, 1, 0, 0.235004,0.0222618) , 
3, -0.459082, 1, 0, 0.228839,0.00933883)    );
  // itree = 2472
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.162331,-0.0119408) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.576923,0.0198449) , 
3, 0.38655, 1, 0, 0.250614,-0.00113008) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244275,-0.069787) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.26183,-0.0145912) , 
0, 0.548419, 1, 0, 0.258824,-0.0228024) , 
0, 0.32087, 1, 0, 0.253776,-0.00947817)    );
  // itree = 2473
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.622807,-0.0149427) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555556,0.0501963) , 
3, -1.69439, 1, 0, 0.591549,-0.0346192) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223849,-0.00400431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135036,0.0143223) , 
1, 1.44665, 1, 0, 0.209602,-0.00185788) , 
1, -1.02829, 1, 0, 0.251952,-0.00549044)    );
  // itree = 2474
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253093,-0.00359062) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.139073,0.00518532) , 
0, 1.3861, 1, 0, 0.244168,-0.00211664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.356522,0.00288343) , 
1, 1.63248, 1, 0, 0.250489,0.00126052)    );
  // itree = 2475
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0070922,0.0832838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0254237,-0.0676592) , 
2, -0.786685, 1, 0, 0.015444,-0.0445755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.215396,0.00374323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.513636,0.000277318) , 
1, 1.29547, 1, 0, 0.288666,0.00111499) , 
0, -1.03387, 1, 0, 0.254146,-0.00465762)    );
  // itree = 2476
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.205161,0.0134331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.708661,0.0444356) , 
3, 0.60954, 1, 0, 0.276053,0.0171914) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.161043,-0.0266391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.341584,0.0158794) , 
2, 0.848909, 1, 0, 0.230114,-0.00620398) , 
1, 0.302097, 1, 0, 0.251277,0.00457367)    );
  // itree = 2477
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.392453,-0.000903566) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.303055,0.00774854) , 
0, -1.04167, 1, 0, 0.318754,-0.00951769) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00671141,-0.0668316) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101124,-0.00730538) , 
3, 0.0174641, 1, 0, 0.0732673,0.0214344) , 
1, 1.22294, 1, 0, 0.2572,-0.0017566)    );
  // itree = 2478
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256146,-0.000491115) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0212766,0.00950126) , 
3, 1.63849, 1, 0, 0.238624,0.00807763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.387097,-0.0111817) , 
1, 1.63248, 1, 0, 0.247766,0.0114487)    );
  // itree = 2479
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0459184,-0.0304518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.332222,0.0143242) , 
1, -0.538548, 1, 0, 0.245356,-0.00999669) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.17757,-0.0268702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.259322,-0.0253099) , 
1, -0.0130795, 1, 0, 0.246772,0.0184853) , 
3, 0.459355, 1, 0, 0.245852,-1.58121e-05)    );
  // itree = 2480
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.271357,0.0259755) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.186335,-0.00392933) , 
0, -1.24931, 1, 0, 0.196602,0.000713266) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397059,-0.0283696) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831776,0.00580268) , 
3, 1.8974, 1, 0, 0.546624,-0.0294637) , 
3, 1.29583, 1, 0, 0.252169,-0.00407747)    );
  // itree = 2481
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375,-0.000649653) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.244591,-0.00457203) , 
0, -1.57522, 1, 0, 0.252262,-0.00454762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0384615,-0.0231725) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.105769,-0.0148306) , 
1, 1.21795, 1, 0, 0.0721154,0.0255237) , 
3, 1.59147, 1, 0, 0.2333,-0.00138221)    );
  // itree = 2482
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.430508,0.00308163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.198157,-0.00759394) , 
3, -0.980252, 1, 0, 0.332031,0.0163674) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.208302,-0.00497488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.252033,0.0742663) , 
0, 1.55581, 1, 0, 0.211957,-0.0110731) , 
0, -0.587928, 1, 0, 0.242944,-0.00399166)    );
  // itree = 2483
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.262601,-0.00480419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.0495407) , 
2, 1.46116, 1, 0, 0.281875,-0.00512215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.174157,-0.0270436) , 
3, 1.64517, 1, 0, 0.271925,0.000115213)    );
  // itree = 2484
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.210337,0.0157765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.135908,-0.0244239) , 
0, -0.111652, 1, 0, 0.176355,-0.000792881) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.526786,-0.0333729) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484,-0.0111406) , 
0, 0.862332, 1, 0, 0.504219,-0.0326639) , 
3, 0.897545, 1, 0, 0.253865,-0.00832748)    );
  // itree = 2485
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.381188,-0.00957596) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.263926,-0.00264675) , 
3, -0.712374, 1, 0, 0.316176,0.00724107) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0945378,0.0117763) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.133333,-0.00751277) , 
1, 1.66319, 1, 0, 0.101549,-0.0169701) , 
2, 0.708843, 1, 0, 0.251932,-6.07637e-06)    );
  // itree = 2486
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0267857,-0.0717861) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269508,-0.00566541) , 
2, -1.72057, 1, 0, 0.254218,-0.00263409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.101604,0.0439386) , 
3, 1.63045, 1, 0, 0.239695,-0.00650512)    );
  // itree = 2487
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0631229,0.00364251) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.298013,0.000177966) , 
0, -0.876498, 1, 0, 0.258973,-0.00305885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.170732,0.0387009) , 
2, 1.76296, 1, 0, 0.253361,-0.00700768)    );
  // itree = 2488
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0650888,-0.034685) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.116505,-0.0802276) , 
3, -0.918291, 1, 0, 0.0845588,-0.036732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0381818,-0.0214395) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.399487,0.0128191) , 
3, -0.526516, 1, 0, 0.283886,0.00819408) , 
2, -1.10481, 1, 0, 0.256655,0.00205651)    );
  // itree = 2489
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.287271,0.0109398) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0733945,-0.0014344) , 
3, 1.44505, 1, 0, 0.27469,-0.011417) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109489,0.00415529) , 
3, 1.76021, 1, 0, 0.263317,-0.00633134)    );
  // itree = 2490
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.336093,0.00505499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0990753,-0.00757289) , 
3, 0.178242, 1, 0, 0.244784,0.00273556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.353383,-0.0045174) , 
2, 1.76296, 1, 0, 0.251668,-0.000390791)    );
  // itree = 2491
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.227181,0.0382786) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.22235,-0.0153632) , 
3, -0.986276, 1, 0, 0.2241,0.00212606) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.332692,-0.0110931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0588235,-0.0693495) , 
3, 1.79489, 1, 0, 0.275915,0.0353108) , 
3, 0.540694, 1, 0, 0.240952,0.0129189)    );
  // itree = 2492
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.202982,0.0022265) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.54375,-0.0250129) , 
3, 1.51156, 1, 0, 0.231618,-0.00204691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.475728,0.0363076) , 
1, 1.68097, 1, 0, 0.244145,0.000752407)    );
  // itree = 2493
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322242,-0.00327268) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.202206,0.0124255) , 
3, 0.253431, 1, 0, 0.299151,0.00802722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.194175,0.0588508) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109792,0.0137495) , 
3, 1.27952, 1, 0, 0.141805,-0.0305324) , 
3, 0.786213, 1, 0, 0.255493,-0.00267175)    );
  // itree = 2494
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0142572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207951,0.00885044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247359,0.000697922) , 
1, -0.752382, 1, 0, 0.240702,0.000470165) , 
0, -1.72119, 1, 0, 0.248898,0.0037621)    );
  // itree = 2495
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.18847,0.00320868) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.391304,-0.0272423) , 
3, 1.3735, 1, 0, 0.20436,0.00919984) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.513834,0.0162774) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.378641,0.0238689) , 
1, 0.724639, 1, 0, 0.453159,-0.0151357) , 
0, 0.873363, 1, 0, 0.263622,0.00340325)    );
  // itree = 2496
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0393996,-0.0415411) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.344173,0.0133618) , 
3, -0.83982, 1, 0, 0.245122,0.00326118) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207018,-0.0180619) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.292453,-0.0453437) , 
2, 1.52027, 1, 0, 0.230179,-0.0279705) , 
0, 1.04529, 1, 0, 0.242245,-0.00275143)    );
  // itree = 2497
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.346635,-0.00321776) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0201879) , 
2, 0.48402, 1, 0, 0.327427,0.00929734) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.045977,-0.0139225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124051,4.01727e-06) , 
0, -0.0437222, 1, 0, 0.100176,-0.0144699) , 
2, 0.690799, 1, 0, 0.262121,0.00246725)    );
  // itree = 2498
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.38007,0.000783151) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.123232,-0.000748815) , 
3, 0.0167245, 1, 0, 0.286451,0.00621839) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21673,-0.0165941) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.195402,0.0174733) , 
3, 0.14224, 1, 0, 0.203438,-0.0177466) , 
1, 0.967289, 1, 0, 0.258268,-0.00191757)    );
  // itree = 2499
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.09327) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.266478,0.00513152) , 
0, -1.16533, 1, 0, 0.222135,-0.0050001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.266491,-0.0202229) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.484663,0.0160811) , 
0, 1.119, 1, 0, 0.367376,0.0147327) , 
0, 0.446909, 1, 0, 0.273876,0.00202953)    );
  // itree = 2500
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.233607,-0.00809282) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.24282,0.0200174) , 
0, 0.90836, 1, 0, 0.235517,-0.00135118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.386364,-0.0461907) , 
2, 1.77922, 1, 0, 0.245579,-0.00499686)    );
  // itree = 2501
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318182,-0.00816605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.264076,0.00620024) , 
0, -0.711503, 1, 0, 0.277546,0.0037231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10687,0.00700114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0540541,-0.0266169) , 
3, 1.62611, 1, 0, 0.0759494,0.0444956) , 
3, 1.25656, 1, 0, 0.245614,0.0101813)    );
  // itree = 2502
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.361905,0.026138) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125,-0.016897) , 
0, -0.791451, 1, 0, 0.23176,-0.0290004) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.252212,-0.00912556) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.251263,-0.000347282) , 
1, -0.524667, 1, 0, 0.251381,0.00195177) , 
1, -0.9788, 1, 0, 0.249143,-0.00157826)    );
  // itree = 2503
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.257002,0.00925419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192733,-0.0193547) , 
2, 0.494221, 1, 0, 0.234976,-0.00373995) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.169231,0.0135473) , 
2, 1.77577, 1, 0, 0.230653,0.0011154)    );
  // itree = 2504
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.220528,0.00123926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556452,-0.0299912) , 
3, 1.65076, 1, 0, 0.243302,-0.00164816) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.554622,0.0260755) , 
1, 1.63248, 1, 0, 0.26232,0.00113317)    );
  // itree = 2505
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.324708,-0.00273592) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.124654,0.0182397) , 
3, 0.717073, 1, 0, 0.278384,-0.00705939) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0465116,0.0028795) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0982143,-0.00538699) , 
3, 0.787904, 1, 0, 0.0757576,0.0163616) , 
2, 1.04095, 1, 0, 0.23734,-0.00231529)    );
  // itree = 2506
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.327103,-0.00802743) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.403509,0.003335) , 
1, -0.867328, 1, 0, 0.382653,-0.0181026) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267157,-0.0022646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0133736) , 
3, 1.03634, 1, 0, 0.221877,0.0107508) , 
0, -0.805343, 1, 0, 0.253373,0.00509836)    );
  // itree = 2507
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,0.187597) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13253,-0.00574503) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.50565,-0.00729477) , 
1, 0.94048, 1, 0, 0.273797,-0.0054477) , 
1, -1.19679, 1, 0, 0.252817,-0.00905144)    );
  // itree = 2508
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.176796,0.013445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212397,-0.0173688) , 
2, -0.635384, 1, 0, 0.20061,-0.00508332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.475862,0.0298779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.668571,-0.00112259) , 
3, 1.68055, 1, 0, 0.58125,0.0198865) , 
3, 1.22488, 1, 0, 0.262755,-0.00100661)    );
  // itree = 2509
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.378378,0.00270475) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.152422,0.00538415) , 
3, -0.0905164, 1, 0, 0.280885,-0.000128846) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.131783,-0.0255608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.208333,0.0308804) , 
3, 0.785477, 1, 0, 0.17757,-0.0293853) , 
0, 1.10784, 1, 0, 0.26386,-0.00494985)    );
  // itree = 2510
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.259894,0.0136405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.350949,0.0216145) , 
1, -0.0488431, 1, 0, 0.304813,-0.00462171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.206997,0.00701454) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15814,0.00787983) , 
3, 0.998243, 1, 0, 0.188172,-0.0320026) , 
1, 1.16801, 1, 0, 0.273126,-0.0120602)    );
  // itree = 2511
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.139535,-0.00207626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165835,-0.0226422) , 
2, -1.01281, 1, 0, 0.159434,-0.0182381) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.323651,-0.01476) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.212435,0.00843753) , 
2, 1.44202, 1, 0, 0.300218,0.00541822) , 
0, 0.133846, 1, 0, 0.224696,-0.0072719)    );
  // itree = 2512
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.167724,-0.00587428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.496429,0.0139522) , 
3, 0.881124, 1, 0, 0.221895,-0.000113007) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285088,-0.0565798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.33908,0.0165269) , 
2, 1.6856, 1, 0, 0.308458,-0.0237127) , 
2, 1.12079, 1, 0, 0.238458,-0.00462851)    );
  // itree = 2513
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.402299,-0.0234554) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.380597,-0.00356504) , 
0, -0.711503, 1, 0, 0.38914,0.018071) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.152866,-0.00150438) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161667,0.000984326) , 
0, 0.348088, 1, 0, 0.156679,-0.00118118) , 
1, -0.136427, 1, 0, 0.231934,0.00505135)    );
  // itree = 2514
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285221,0.000577393) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215686,0.011875) , 
0, 0.896416, 1, 0, 0.271468,-0.000708133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.109677,0.0095046) , 
3, 1.74551, 1, 0, 0.258673,0.00233176)    );
  // itree = 2515
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0768196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.234347,0.00422176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.272606,0.0128046) , 
3, 0.385816, 1, 0, 0.249733,-0.00804571) , 
0, -1.44603, 1, 0, 0.230049,-0.0114187)    );
  // itree = 2516
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171527,-0.00453035) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.432432,-0.0391227) , 
3, 0.145273, 1, 0, 0.213256,-0.0109784) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.398374,0.0503025) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.231561,-0.00147833) , 
1, 0.0587742, 1, 0, 0.247479,0.00304122) , 
1, -0.128677, 1, 0, 0.235502,-0.00186528)    );
  // itree = 2517
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292394,0.00367507) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0245902,-0.0412018) , 
3, 1.51442, 1, 0, 0.273465,-0.00052465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138614,-0.0150637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0810811,-0.0499599) , 
3, 1.37, 1, 0, 0.108491,0.0390531) , 
0, 1.32355, 1, 0, 0.255418,0.0038048)    );
  // itree = 2518
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.292758,0.00357932) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.175879,-0.00771851) , 
0, 0.50039, 1, 0, 0.255937,-0.00264521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365217,0.0235002) , 
1, 1.65151, 1, 0, 0.262189,-0.00674482)    );
  // itree = 2519
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128788,-0.0160594) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.237609,-0.00566525) , 
3, -0.786189, 1, 0, 0.19028,0.0177828) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.517986,0.00817298) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.247368,0.0207467) , 
2, 0.136903, 1, 0, 0.336085,-0.00825418) , 
0, 0.310699, 1, 0, 0.250242,0.00707504)    );
  // itree = 2520
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235955,-0.00579775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.278146,0.0573831) , 
0, -0.221527, 1, 0, 0.251196,0.0138229) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.168357,0.0056972) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.285846,-0.015226) , 
2, -0.151253, 1, 0, 0.249209,-0.00884614) , 
1, -0.512249, 1, 0, 0.249625,-0.00410594)    );
  // itree = 2521
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322394,0.00219857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.225806,-0.00135144) , 
0, -0.597457, 1, 0, 0.258274,0.004255) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.127168,-0.0249134) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.164502,0.0105166) , 
3, 0.861407, 1, 0, 0.148515,-0.0299537) , 
0, 1.07303, 1, 0, 0.235476,-0.00285056)    );
  // itree = 2522
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.30527,0.00568875) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.113379,-0.00487993) , 
1, 1.19492, 1, 0, 0.260778,-0.000431616) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.330579,0.0027025) , 
1, 1.6541, 1, 0, 0.264953,0.00399649)    );
  // itree = 2523
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10176,-0.0135802) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.365385,-0.0271883) , 
0, 1.45434, 1, 0, 0.121191,0.00416946) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.679612,0.0269838) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.275862,0.096377) , 
3, 1.67958, 1, 0, 0.605388,-0.0280429) , 
1, 1.09547, 1, 0, 0.270813,-0.00578452)    );
  // itree = 2524
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00757576,-0.0680125) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.248521,-0.000647303) , 
3, -1.96389, 1, 0, 0.209158,-0.00587121) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.347458,0.0889099) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.301616,0.00785251) , 
1, -0.796791, 1, 0, 0.306006,0.0153047) , 
0, -0.22297, 1, 0, 0.267647,0.00691736)    );
  // itree = 2525
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.493333,-0.0157303) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.472362,-0.000714971) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.215867,0.00354023) , 
1, -0.796791, 1, 0, 0.243836,-1.64476e-05) , 
3, -1.91277, 1, 0, 0.262785,-0.00270611)    );
  // itree = 2526
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,-0.0232522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0764706,-0.0202326) , 
1, -0.746373, 1, 0, 0.0905923,0.0244027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.416107,-0.0087419) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.250329,0.000103854) , 
0, -1.07672, 1, 0, 0.265111,-0.00610352) , 
2, -1.10481, 1, 0, 0.23953,-0.00163198)    );
  // itree = 2527
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.075171) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.277643,0.00693678) , 
3, -2.07268, 1, 0, 0.260845,-0.0047877) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.45,0.0679374) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0701754,0.0566333) , 
2, 1.24378, 1, 0, 0.247664,-0.0405457) , 
3, 1.63045, 1, 0, 0.25941,-0.00867997)    );
  // itree = 2528
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.149341,0.0057623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.270398,-0.0127178) , 
2, -0.30434, 1, 0, 0.222798,-0.00515677) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.036036,-0.0429684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.521739,0.0474584) , 
3, 0.805318, 1, 0, 0.305221,0.0398673) , 
1, 1.47131, 1, 0, 0.233132,0.000488242)    );
  // itree = 2529
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.349587,-0.00279551) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106977,-0.00851686) , 
1, 0.78171, 1, 0, 0.265229,0.0015094) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0580645,0.00428291) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.103774,-0.0111919) , 
3, 1.68156, 1, 0, 0.0766283,0.0376517) , 
2, 1.40517, 1, 0, 0.241966,0.00596741)    );
  // itree = 2530
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.432961,-0.00110608) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,-0.0220809) , 
3, -0.662186, 1, 0, 0.356077,-0.0300269) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267468,0.00424447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0875912,-0.0027778) , 
3, 1.37407, 1, 0, 0.23676,0.0024072) , 
0, -0.762191, 1, 0, 0.263742,-0.00492723)    );
  // itree = 2531
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.237649,0.00936613) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.30602,-0.00950661) , 
3, 0.230457, 1, 0, 0.260722,0.00968297) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.240385,0.0108623) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.211538,0.00311767) , 
1, 1.29807, 1, 0, 0.225962,-0.0318144) , 
3, 1.52344, 1, 0, 0.257071,0.00532365)    );
  // itree = 2532
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192171,-0.000696656) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206349,0.0335545) , 
2, 0.375794, 1, 0, 0.196925,0.00637295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.494318,-0.044252) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.555556,0.0117334) , 
0, 1.17855, 1, 0, 0.523669,-0.0195925) , 
3, 1.29216, 1, 0, 0.251355,0.0020475)    );
  // itree = 2533
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.412463,-0.00563753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.167084,0.0150185) , 
1, -0.0851305, 1, 0, 0.255478,-0.00623009) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.189781,-0.0127268) , 
0, 1.49754, 1, 0, 0.250996,-0.00247312)    );
  // itree = 2534
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.27221,0.00132048) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.125767,0.00280924) , 
0, 0.872706, 1, 0, 0.244662,-0.00219352) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.442308,-0.00441498) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206612,-0.00737019) , 
3, 1.37466, 1, 0, 0.33935,0.0307561) , 
2, 1.40023, 1, 0, 0.257711,0.00234729)    );
  // itree = 2535
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0750564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0186916,-0.052158) , 
1, -0.358201, 1, 0, 0.00840336,-0.032375) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308452,0.00382205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192547,-0.0327959) , 
3, 1.6825, 1, 0, 0.29798,0.00259753) , 
0, -1.11841, 1, 0, 0.263861,-0.001523)    );
  // itree = 2536
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0839695,0.0295723) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0582524,-0.0249844) , 
2, -1.53324, 1, 0, 0.0622066,-0.00562683) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.553684,0.0409818) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.291101,0.00429213) , 
1, 0.578905, 1, 0, 0.400703,0.0219504) , 
3, -0.404141, 1, 0, 0.255779,0.0101435)    );
  // itree = 2537
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.590414,0.0256137) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.238938,0.00864249) , 
1, -0.14908, 1, 0, 0.416026,-0.0167075) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170552,-0.00901661) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0576923,-0.0154782) , 
2, 1.28582, 1, 0, 0.139308,0.00360799) , 
2, -0.0345658, 1, 0, 0.263003,-0.00547319)    );
  // itree = 2538
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.267626,-0.0048478) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00819037) , 
1, 1.0331, 1, 0, 0.236148,-0.00656626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.335079,0.0159469) , 
1, 1.5317, 1, 0, 0.245366,-0.00404101)    );
  // itree = 2539
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0517483,-0.0138328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37757,0.00273283) , 
1, 0.0100465, 1, 0, 0.247059,0.000567223) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.317365,0.0143886) , 
0, 1.42411, 1, 0, 0.253074,0.00466403)    );
  // itree = 2540
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.148011,-0.0168474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.327586,-0.0482469) , 
3, 0.600431, 1, 0, 0.179741,-0.0202314) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.090625,-0.00337091) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.666667,0.0167529) , 
3, 1.0189, 1, 0, 0.363487,0.012376) , 
2, 0.708843, 1, 0, 0.237897,-0.00991107)    );
  // itree = 2541
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.497006,-0.00308853) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.161538,-0.0356866) , 
3, -1.61797, 1, 0, 0.350168,0.0210534) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.258896,0.0105021) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0970874,0.00140388) , 
3, 1.95123, 1, 0, 0.249279,-0.00648077) , 
0, -1.03521, 1, 0, 0.264039,-0.00245237)    );
  // itree = 2542
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.281477,0.00462239) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.200772,0.00289027) , 
0, 1.08526, 1, 0, 0.269707,-0.00471435) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0809054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.106796,-0.0144226) , 
2, 1.42001, 1, 0, 0.0539216,0.0318063) , 
3, 1.63045, 1, 0, 0.247475,-0.000951609)    );
  // itree = 2543
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.219794,-0.00247451) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.549107,0.0284825) , 
1, 1.45677, 1, 0, 0.25922,-0.0100211) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.13253,-0.0389862) , 
3, 1.73078, 1, 0, 0.248895,-0.00726021)    );
  // itree = 2544
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0938697,-0.0156034) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.45098,0.0361592) , 
3, -0.354416, 1, 0, 0.194215,0.00507755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.238994,-0.0376976) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.262126,-0.0121597) , 
1, -0.129923, 1, 0, 0.25641,-0.0165124) , 
0, -0.304327, 1, 0, 0.233979,-0.00872586)    );
  // itree = 2545
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.463855,-0.0268445) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.285068,-0.000483237) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.23167,0.00333465) , 
0, -0.865908, 1, 0, 0.238069,0.00697563) , 
3, -1.79067, 1, 0, 0.256716,0.00442882)    );
  // itree = 2546
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.362245,-0.00838609) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.197464,0.0023664) , 
0, -0.458926, 1, 0, 0.26589,-0.00982287) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.223744,0.00850678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.489362,0.0432353) , 
2, 1.70794, 1, 0, 0.26057,0.0140792) , 
1, 0.227361, 1, 0, 0.263131,0.00257303)    );
  // itree = 2547
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.128748,-0.0149664) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.313518,0.00847789) , 
0, -0.557972, 1, 0, 0.255153,-0.00676958) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.557377,0.0477088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0827586,-0.00749031) , 
2, 1.1637, 1, 0, 0.299625,-0.0442065) , 
3, 1.38245, 1, 0, 0.260912,-0.0116171)    );
  // itree = 2548
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.270123,0.00286472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.323308,-0.0676307) , 
2, 0.609897, 1, 0, 0.278291,-0.0075685) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0404412,-0.0282132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.451977,0.020203) , 
3, 0.363173, 1, 0, 0.243721,0.00972384) , 
1, 0.227361, 1, 0, 0.259145,0.00200866)    );
  // itree = 2549
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.510563,0.00310615) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.192786,-0.00694641) , 
1, -0.837147, 1, 0, 0.240486,0.00164886) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.137405,-0.0166779) , 
1, 1.64556, 1, 0, 0.233811,0.00518229)    );
  // itree = 2550
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171123,-0.00578156) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.253127,0.00533133) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,-0.0228253) , 
1, 1.57625, 1, 0, 0.259096,0.00332305) , 
1, -1.04302, 1, 0, 0.250875,-0.00125556)    );
  // itree = 2551
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016,0.192987) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.00724638,-0.0341987) , 
2, -0.806735, 1, 0, 0.0114068,-0.0285938) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318071,0.00556646) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0192308,-0.0731769) , 
2, 1.86194, 1, 0, 0.30023,0.00285533) , 
0, -1.09323, 1, 0, 0.262344,-0.00126993)    );
  // itree = 2552
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0678392,-7.18216e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.438957,0.0249799) , 
3, -0.909406, 1, 0, 0.307897,0.0177449) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.212996,-0.00920753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.466667,0.0233214) , 
1, 1.722, 1, 0, 0.241453,-0.00274361) , 
1, 0.529523, 1, 0, 0.277751,0.00844912)    );
  // itree = 2553
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.47181,-0.0111404) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206765,-0.00385053) , 
1, -0.754602, 1, 0, 0.253676,-4.0637e-05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0446429,-0.0449529) , 
3, 1.90896, 1, 0, 0.242063,0.00401787)    );
  // itree = 2554
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.235605,-0.0115899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0810169) , 
3, 1.58712, 1, 0, 0.219126,0.00681483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.39196,0.00711434) , 
2, 1.65497, 1, 0, 0.236077,0.00319057)    );
  // itree = 2555
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0813008,-0.0103028) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0271524) , 
3, 0.0388081, 1, 0, 0.103423,0.0122446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.618421,0.000302481) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,0.0173894) , 
3, 0.725019, 1, 0, 0.509601,-0.0133672) , 
1, 0.939437, 1, 0, 0.239485,0.00366508)    );
  // itree = 2556
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.129693,0.021022) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0681818,-0.0327621) , 
2, -0.960694, 1, 0, 0.0854947,-0.00632545) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.355204,0.045957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.519126,0.00469252) , 
3, 0.790057, 1, 0, 0.446014,0.0221772) , 
3, -0.0186245, 1, 0, 0.261319,0.00757521)    );
  // itree = 2557
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.49537,0.000884962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.314402,0.00776128) , 
3, -0.79515, 1, 0, 0.398919,0.0104241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.255906,0.0260804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.138889,0.0162325) , 
1, 0.646236, 1, 0, 0.164645,-0.010098) , 
1, 0.22651, 1, 0, 0.268879,-0.000967158)    );
  // itree = 2558
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.291785,0.00670113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.355172,0.0100904) , 
1, -0.00662875, 1, 0, 0.326777,-0.00136253) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0703364,0.0193844) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.15528,0.0029971) , 
0, 1.23665, 1, 0, 0.0983607,-0.0344727) , 
3, 0.934112, 1, 0, 0.272771,-0.00919091)    );
  // itree = 2559
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0147059,0.143629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0897436,0.0307052) , 
1, -1.19287, 1, 0, 0.0547945,-0.0239525) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0486111,-0.00127832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.31068,0.000275461) , 
0, -1.06289, 1, 0, 0.288336,0.00562811) , 
1, -0.774615, 1, 0, 0.253912,0.00126792)    );
  // itree = 2560
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0119403,-0.0565598) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153631,0.0325951) , 
3, -1.25956, 1, 0, 0.108468,0.0072722) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.224719,0.0205346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.447958,-0.016593) , 
2, -0.209504, 1, 0, 0.40555,-0.0159775) , 
3, 0.0482632, 1, 0, 0.248491,-0.00368604)    );
  // itree = 2561
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.460938,-0.0027113) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.165049,0.00958874) , 
1, 0.0666833, 1, 0, 0.329004,0.00579985) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.170904,0.0106467) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0942408,0.0109055) , 
3, 1.69879, 1, 0, 0.154616,-0.0109566) , 
3, 0.105894, 1, 0, 0.252678,-0.00153416)    