// Class: ReadMLP
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : MLP::MLP
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:49:30 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 4000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
NCycles: "1000" [Number of training cycles]
HiddenLayers: "N+5,5" [Specification of hidden layer architecture]
NeuronType: "tanh" [Neuron activation function type]
EstimatorType: "MSE" [MSE (Mean Square Estimator) for Gaussian Likelihood or CE(Cross-Entropy) for Bernoulli Likelihood]
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
TestRate: "5" [Test for overtraining performed at each #th epochs]
# Default:
RandomSeed: "1" [Random seed for initial synapse weights (0 means unique seed for each run; default value '1')]
NeuronInputType: "sum" [Neuron input function type]
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
TrainingMethod: "BP" [Train with Back-Propagation (BP), BFGS Algorithm (BFGS), or Genetic Algorithm (GA - slower and worse)]
LearningRate: "2.000000e-02" [ANN learning rate parameter]
DecayRate: "1.000000e-02" [Decay rate for learning parameter]
EpochMonitoring: "False" [Provide epoch-wise monitoring plots according to TestRate (caution: causes big ROOT output file!)]
Sampling: "1.000000e+00" [Only 'Sampling' (randomly selected) events are trained each epoch]
SamplingEpoch: "1.000000e+00" [Sampling is used for the first 'SamplingEpoch' epochs, afterwards, all events are taken for training]
SamplingImportance: "1.000000e+00" [ The sampling weights of events in epochs which successful (worse estimator than before) are multiplied with SamplingImportance, else they are divided.]
SamplingTraining: "True" [The training sample is sampled]
SamplingTesting: "False" [The testing sample is sampled]
ResetStep: "50" [How often BFGS should reset history]
Tau: "3.000000e+00" [LineSearch "size step"]
BPMode: "sequential" [Back-propagation learning mode: sequential or batch]
BatchSize: "-1" [Batch size: number of events/batch, only set if in Batch Mode, -1 for BatchSize=number_of_events]
ConvergenceImprove: "1.000000e-30" [Minimum improvement which counts as improvement (<0 means automatic convergence check is turned off)]
ConvergenceTests: "-1" [Number of steps (without improvement) required for convergence (<0 means automatic convergence check is turned off)]
UseRegulator: "False" [Use regulator to avoid over-training]
UpdateLimit: "10000" [Maximum times of regulator update]
CalculateErrors: "False" [Calculates inverse Hessian matrix at the end of the training to be able to calculate the uncertainties of an MVA value]
WeightRange: "1.000000e+00" [Take the events for the estimator calculations from small deviations from the desired value to large deviations only over the weight range]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-4.05916023254,3.26447582245]
var2                          var2                          var2                          Variable 2                                                      'F'    [-3.68905711174,3.78774046898]
var3                          var3                          var3                          Variable 3                    units                             'F'    [-3.6296145916,3.91998791695]
var4                          var4                          var4                          Variable 4                    units                             'F'    [-4.84856987,4.3625254631]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadMLP : public IClassifierReader {

 public:

   // constructor
   ReadMLP( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadMLP" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadMLP() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   std::vector<double> GetMulticlassValues( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   std::vector<double> GetMulticlassValues__( const std::vector<double>& inputValues ) const;

   // private members (method specific)

   double ActivationFnc(double x) const;
   double OutputActivationFnc(double x) const;

   double fWeightMatrix0to1[10][5];   // weight matrix from layer 0 to 1
   double fWeightMatrix1to2[6][10];   // weight matrix from layer 1 to 2
   double fWeightMatrix2to3[4][6];   // weight matrix from layer 2 to 3

};

inline void ReadMLP::Initialize()
{
   // build network structure
   // weight matrix from layer 0 to 1
   fWeightMatrix0to1[0][0] = 2.04587196239265;
   fWeightMatrix0to1[1][0] = 1.71845525694682;
   fWeightMatrix0to1[2][0] = 0.293516801945705;
   fWeightMatrix0to1[3][0] = 0.299905309446127;
   fWeightMatrix0to1[4][0] = -2.08055527765304;
   fWeightMatrix0to1[5][0] = -3.53270980852744;
   fWeightMatrix0to1[6][0] = -0.205002184993567;
   fWeightMatrix0to1[7][0] = 0.902233419328004;
   fWeightMatrix0to1[8][0] = -0.401386711694769;
   fWeightMatrix0to1[0][1] = -0.402641296947942;
   fWeightMatrix0to1[1][1] = 1.22156743373207;
   fWeightMatrix0to1[2][1] = 0.271253032982178;
   fWeightMatrix0to1[3][1] = -1.70274506310031;
   fWeightMatrix0to1[4][1] = -1.59224030893539;
   fWeightMatrix0to1[5][1] = 0.587008249856216;
   fWeightMatrix0to1[6][1] = -0.362140320493813;
   fWeightMatrix0to1[7][1] = -0.499628836972288;
   fWeightMatrix0to1[8][1] = 3.58334943574686;
   fWeightMatrix0to1[0][2] = 0.944305711713027;
   fWeightMatrix0to1[1][2] = 0.658601185810656;
   fWeightMatrix0to1[2][2] = -1.19120482669958;
   fWeightMatrix0to1[3][2] = -0.429170556377646;
   fWeightMatrix0to1[4][2] = -0.919374675971254;
   fWeightMatrix0to1[5][2] = -0.13623052808747;
   fWeightMatrix0to1[6][2] = -1.53616163432243;
   fWeightMatrix0to1[7][2] = 0.105405855269568;
   fWeightMatrix0to1[8][2] = -0.291862968331549;
   fWeightMatrix0to1[0][3] = -3.04832090505541;
   fWeightMatrix0to1[1][3] = -2.89942635067547;
   fWeightMatrix0to1[2][3] = 0.124298345709327;
   fWeightMatrix0to1[3][3] = 3.19007177877028;
   fWeightMatrix0to1[4][3] = 3.55587275728066;
   fWeightMatrix0to1[5][3] = 0.192524965044879;
   fWeightMatrix0to1[6][3] = 1.20682884606569;
   fWeightMatrix0to1[7][3] = 0.642406217170045;
   fWeightMatrix0to1[8][3] = 0.125639905845066;
   fWeightMatrix0to1[0][4] = -1.60675486916378;
   fWeightMatrix0to1[1][4] = 1.95689895800091;
   fWeightMatrix0to1[2][4] = -1.47171296244333;
   fWeightMatrix0to1[3][4] = -0.187124018155133;
   fWeightMatrix0to1[4][4] = 2.06268786422996;
   fWeightMatrix0to1[5][4] = 2.61598908248358;
   fWeightMatrix0to1[6][4] = 1.2146698712673;
   fWeightMatrix0to1[7][4] = -0.568344112759895;
   fWeightMatrix0to1[8][4] = -3.23034696337309;
   // weight matrix from layer 1 to 2
   fWeightMatrix1to2[0][0] = -0.248438727134266;
   fWeightMatrix1to2[1][0] = 0.969621731607658;
   fWeightMatrix1to2[2][0] = 0.113348760525219;
   fWeightMatrix1to2[3][0] = 0.511889799449219;
   fWeightMatrix1to2[4][0] = -0.203581280563917;
   fWeightMatrix1to2[0][1] = 0.107789952450907;
   fWeightMatrix1to2[1][1] = -0.968919093567256;
   fWeightMatrix1to2[2][1] = 0.420868391156519;
   fWeightMatrix1to2[3][1] = 1.16089638755755;
   fWeightMatrix1to2[4][1] = -1.75455588239414;
   fWeightMatrix1to2[0][2] = -0.876910136366252;
   fWeightMatrix1to2[1][2] = 0.909324017987117;
   fWeightMatrix1to2[2][2] = -0.565968834909649;
   fWeightMatrix1to2[3][2] = -0.184426757071504;
   fWeightMatrix1to2[4][2] = -0.108250022926591;
   fWeightMatrix1to2[0][3] = -0.344016303090541;
   fWeightMatrix1to2[1][3] = -1.29034278088007;
   fWeightMatrix1to2[2][3] = 0.122790953748671;
   fWeightMatrix1to2[3][3] = 0.4791767506514;
   fWeightMatrix1to2[4][3] = 0.472408893207927;
   fWeightMatrix1to2[0][4] = 0.0512308201115088;
   fWeightMatrix1to2[1][4] = -1.55755396070646;
   fWeightMatrix1to2[2][4] = -0.587222208120546;
   fWeightMatrix1to2[3][4] = -0.13209987606571;
   fWeightMatrix1to2[4][4] = 3.08948618510028;
   fWeightMatrix1to2[0][5] = -0.36468067498088;
   fWeightMatrix1to2[1][5] = -1.40210136765057;
   fWeightMatrix1to2[2][5] = 0.0340530236600003;
   fWeightMatrix1to2[3][5] = 3.96933309690381;
   fWeightMatrix1to2[4][5] = 0.052920107957706;
   fWeightMatrix1to2[0][6] = -0.300011734970937;
   fWeightMatrix1to2[1][6] = -1.27899801836992;
   fWeightMatrix1to2[2][6] = -0.695014857348039;
   fWeightMatrix1to2[3][6] = 0.83142377769854;
   fWeightMatrix1to2[4][6] = -0.0850448850881524;
   fWeightMatrix1to2[0][7] = 0.465535906155113;
   fWeightMatrix1to2[1][7] = -1.98064520432604;
   fWeightMatrix1to2[2][7] = -0.456006394132623;
   fWeightMatrix1to2[3][7] = -0.16905347251643;
   fWeightMatrix1to2[4][7] = -0.59238918928438;
   fWeightMatrix1to2[0][8] = 0.389825288951925;
   fWeightMatrix1to2[1][8] = -0.479084197498235;
   fWeightMatrix1to2[2][8] = -0.443853758947046;
   fWeightMatrix1to2[3][8] = -3.92067440556908;
   fWeightMatrix1to2[4][8] = 0.00150309561891695;
   fWeightMatrix1to2[0][9] = -0.637245382109261;
   fWeightMatrix1to2[1][9] = -3.03803439399895;
   fWeightMatrix1to2[2][9] = -0.518147136066915;
   fWeightMatrix1to2[3][9] = -2.87353063749442;
   fWeightMatrix1to2[4][9] = -1.8225358189904;
   // weight matrix from layer 2 to 3
   fWeightMatrix2to3[0][0] = 1.31936433339789;
   fWeightMatrix2to3[1][0] = -0.08745252407372;
   fWeightMatrix2to3[2][0] = 1.07188612104759;
   fWeightMatrix2to3[3][0] = -4.5411397012736;
   fWeightMatrix2to3[0][1] = -1.77363882568194;
   fWeightMatrix2to3[1][1] = -3.26706638308017;
   fWeightMatrix2to3[2][1] = -0.621775684607199;
   fWeightMatrix2to3[3][1] = 2.88898040243601;
   fWeightMatrix2to3[0][2] = -1.5556570076505;
   fWeightMatrix2to3[1][2] = -1.31568684239599;
   fWeightMatrix2to3[2][2] = 2.56811260346992;
   fWeightMatrix2to3[3][2] = 1.52116917799482;
   fWeightMatrix2to3[0][3] = 1.47881040524469;
   fWeightMatrix2to3[1][3] = 1.42052296877071;
   fWeightMatrix2to3[2][3] = 1.0141212441654;
   fWeightMatrix2to3[3][3] = -6.20043486064983;
   fWeightMatrix2to3[0][4] = 2.84714637647541;
   fWeightMatrix2to3[1][4] = -1.60032554918206;
   fWeightMatrix2to3[2][4] = -1.95535516282708;
   fWeightMatrix2to3[3][4] = 0.31132043879695;
   fWeightMatrix2to3[0][5] = 0.614772476001606;
   fWeightMatrix2to3[1][5] = -1.06567251259999;
   fWeightMatrix2to3[2][5] = 0.359269953903062;
   fWeightMatrix2to3[3][5] = 2.11794423882533;
}

inline double ReadMLP::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   if (inputValues.size() != (unsigned int)4) {
      std::cout << "Input vector needs to be of size " << 4 << std::endl;
      return 0;
   }

   std::array<double, 10> fWeights1 {{}};
   std::array<double, 6> fWeights2 {{}};
   std::array<double, 4> fWeights3 {{}};
   fWeights1.back() = 1.;
   fWeights2.back() = 1.;

   // layer 0 to 1
   for (int o=0; o<9; o++) {
      std::array<double, 5> buffer; // no need to initialise
      for (int i = 0; i<5 - 1; i++) {
         buffer[i] = fWeightMatrix0to1[o][i] * inputValues[i];
      } // loop over i
      buffer.back() = fWeightMatrix0to1[o][4];
      for (int i=0; i<5; i++) {
         fWeights1[o] += buffer[i];
      } // loop over i
    } // loop over o
   for (int o=0; o<9; o++) {
      fWeights1[o] = ActivationFnc(fWeights1[o]);
   } // loop over o
   // layer 1 to 2
   for (int o=0; o<5; o++) {
      std::array<double, 10> buffer; // no need to initialise
      for (int i=0; i<10; i++) {
         buffer[i] = fWeightMatrix1to2[o][i] * fWeights1[i];
      } // loop over i
      for (int i=0; i<10; i++) {
         fWeights2[o] += buffer[i];
      } // loop over i
    } // loop over o
   for (int o=0; o<5; o++) {
      fWeights2[o] = ActivationFnc(fWeights2[o]);
   } // loop over o
   // layer 2 to 3
   for (int o=0; o<4; o++) {
      std::array<double, 6> buffer; // no need to initialise
      for (int i=0; i<6; i++) {
         buffer[i] = fWeightMatrix2to3[o][i] * fWeights2[i];
      } // loop over i
      for (int i=0; i<6; i++) {
         fWeights3[o] += buffer[i];
      } // loop over i
    } // loop over o
   for (int o=0; o<4; o++) {
      fWeights3[o] = OutputActivationFnc(fWeights3[o]);
   } // loop over o

   return fWeights3[0];
}

double ReadMLP::ActivationFnc(double x) const {
   // hyperbolic tan
   return tanh(x);
}
double ReadMLP::OutputActivationFnc(double x) const {
   // identity
   return x;
}

// Clean up
inline void ReadMLP::Clear()
{
}
inline std::vector<double> ReadMLP::GetMulticlassValues( const std::vector<double>& inputValues ) const
{
   // classifier response value
   std::vector<double> retval;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMulticlassValues__( inputValues );
   }

   return retval;
}
