// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:57:05 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 1600
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
NTrees: "400" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "16" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 256
vars                          vars[0]                       vars                          [0]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[1]                       vars                          [1]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[2]                       vars                          [2]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[3]                       vars                          [3]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[4]                       vars                          [4]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[5]                       vars                          [5]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[6]                       vars                          [6]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[7]                       vars                          [7]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[8]                       vars                          [8]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[9]                       vars                          [9]                                                             'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[10]                      vars                          [10]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[11]                      vars                          [11]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[12]                      vars                          [12]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[13]                      vars                          [13]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[14]                      vars                          [14]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[15]                      vars                          [15]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[16]                      vars                          [16]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[17]                      vars                          [17]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[18]                      vars                          [18]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[19]                      vars                          [19]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[20]                      vars                          [20]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[21]                      vars                          [21]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[22]                      vars                          [22]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[23]                      vars                          [23]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[24]                      vars                          [24]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[25]                      vars                          [25]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[26]                      vars                          [26]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[27]                      vars                          [27]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[28]                      vars                          [28]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[29]                      vars                          [29]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[30]                      vars                          [30]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[31]                      vars                          [31]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[32]                      vars                          [32]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[33]                      vars                          [33]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[34]                      vars                          [34]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[35]                      vars                          [35]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[36]                      vars                          [36]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[37]                      vars                          [37]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[38]                      vars                          [38]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[39]                      vars                          [39]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[40]                      vars                          [40]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[41]                      vars                          [41]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[42]                      vars                          [42]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[43]                      vars                          [43]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[44]                      vars                          [44]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[45]                      vars                          [45]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[46]                      vars                          [46]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[47]                      vars                          [47]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[48]                      vars                          [48]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[49]                      vars                          [49]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[50]                      vars                          [50]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[51]                      vars                          [51]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[52]                      vars                          [52]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[53]                      vars                          [53]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[54]                      vars                          [54]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[55]                      vars                          [55]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[56]                      vars                          [56]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[57]                      vars                          [57]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[58]                      vars                          [58]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[59]                      vars                          [59]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[60]                      vars                          [60]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[61]                      vars                          [61]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[62]                      vars                          [62]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[63]                      vars                          [63]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[64]                      vars                          [64]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[65]                      vars                          [65]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[66]                      vars                          [66]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[67]                      vars                          [67]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[68]                      vars                          [68]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[69]                      vars                          [69]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[70]                      vars                          [70]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[71]                      vars                          [71]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[72]                      vars                          [72]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[73]                      vars                          [73]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[74]                      vars                          [74]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[75]                      vars                          [75]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[76]                      vars                          [76]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[77]                      vars                          [77]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[78]                      vars                          [78]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[79]                      vars                          [79]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[80]                      vars                          [80]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[81]                      vars                          [81]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[82]                      vars                          [82]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[83]                      vars                          [83]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[84]                      vars                          [84]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[85]                      vars                          [85]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[86]                      vars                          [86]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[87]                      vars                          [87]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[88]                      vars                          [88]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[89]                      vars                          [89]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[90]                      vars                          [90]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[91]                      vars                          [91]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[92]                      vars                          [92]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[93]                      vars                          [93]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[94]                      vars                          [94]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[95]                      vars                          [95]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[96]                      vars                          [96]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[97]                      vars                          [97]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[98]                      vars                          [98]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[99]                      vars                          [99]                                                            'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[100]                     vars                          [100]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[101]                     vars                          [101]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[102]                     vars                          [102]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[103]                     vars                          [103]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[104]                     vars                          [104]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[105]                     vars                          [105]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[106]                     vars                          [106]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[107]                     vars                          [107]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[108]                     vars                          [108]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[109]                     vars                          [109]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[110]                     vars                          [110]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[111]                     vars                          [111]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[112]                     vars                          [112]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[113]                     vars                          [113]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[114]                     vars                          [114]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[115]                     vars                          [115]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[116]                     vars                          [116]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[117]                     vars                          [117]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[118]                     vars                          [118]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[119]                     vars                          [119]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[120]                     vars                          [120]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[121]                     vars                          [121]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[122]                     vars                          [122]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[123]                     vars                          [123]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[124]                     vars                          [124]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[125]                     vars                          [125]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[126]                     vars                          [126]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[127]                     vars                          [127]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[128]                     vars                          [128]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[129]                     vars                          [129]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[130]                     vars                          [130]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[131]                     vars                          [131]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[132]                     vars                          [132]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[133]                     vars                          [133]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[134]                     vars                          [134]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[135]                     vars                          [135]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[136]                     vars                          [136]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[137]                     vars                          [137]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[138]                     vars                          [138]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[139]                     vars                          [139]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[140]                     vars                          [140]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[141]                     vars                          [141]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[142]                     vars                          [142]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[143]                     vars                          [143]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[144]                     vars                          [144]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[145]                     vars                          [145]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[146]                     vars                          [146]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[147]                     vars                          [147]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[148]                     vars                          [148]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[149]                     vars                          [149]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[150]                     vars                          [150]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[151]                     vars                          [151]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[152]                     vars                          [152]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[153]                     vars                          [153]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[154]                     vars                          [154]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[155]                     vars                          [155]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[156]                     vars                          [156]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[157]                     vars                          [157]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[158]                     vars                          [158]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[159]                     vars                          [159]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[160]                     vars                          [160]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[161]                     vars                          [161]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[162]                     vars                          [162]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[163]                     vars                          [163]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[164]                     vars                          [164]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[165]                     vars                          [165]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[166]                     vars                          [166]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[167]                     vars                          [167]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[168]                     vars                          [168]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[169]                     vars                          [169]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[170]                     vars                          [170]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[171]                     vars                          [171]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[172]                     vars                          [172]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[173]                     vars                          [173]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[174]                     vars                          [174]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[175]                     vars                          [175]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[176]                     vars                          [176]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[177]                     vars                          [177]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[178]                     vars                          [178]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[179]                     vars                          [179]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[180]                     vars                          [180]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[181]                     vars                          [181]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[182]                     vars                          [182]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[183]                     vars                          [183]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[184]                     vars                          [184]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[185]                     vars                          [185]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[186]                     vars                          [186]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[187]                     vars                          [187]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[188]                     vars                          [188]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[189]                     vars                          [189]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[190]                     vars                          [190]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[191]                     vars                          [191]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[192]                     vars                          [192]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[193]                     vars                          [193]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[194]                     vars                          [194]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[195]                     vars                          [195]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[196]                     vars                          [196]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[197]                     vars                          [197]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[198]                     vars                          [198]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[199]                     vars                          [199]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[200]                     vars                          [200]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[201]                     vars                          [201]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[202]                     vars                          [202]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[203]                     vars                          [203]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[204]                     vars                          [204]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[205]                     vars                          [205]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[206]                     vars                          [206]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[207]                     vars                          [207]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[208]                     vars                          [208]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[209]                     vars                          [209]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[210]                     vars                          [210]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[211]                     vars                          [211]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[212]                     vars                          [212]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[213]                     vars                          [213]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[214]                     vars                          [214]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[215]                     vars                          [215]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[216]                     vars                          [216]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[217]                     vars                          [217]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[218]                     vars                          [218]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[219]                     vars                          [219]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[220]                     vars                          [220]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[221]                     vars                          [221]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[222]                     vars                          [222]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[223]                     vars                          [223]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[224]                     vars                          [224]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[225]                     vars                          [225]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[226]                     vars                          [226]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[227]                     vars                          [227]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[228]                     vars                          [228]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[229]                     vars                          [229]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[230]                     vars                          [230]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[231]                     vars                          [231]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[232]                     vars                          [232]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[233]                     vars                          [233]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[234]                     vars                          [234]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[235]                     vars                          [235]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[236]                     vars                          [236]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[237]                     vars                          [237]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[238]                     vars                          [238]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[239]                     vars                          [239]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[240]                     vars                          [240]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[241]                     vars                          [241]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[242]                     vars                          [242]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[243]                     vars                          [243]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[244]                     vars                          [244]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[245]                     vars                          [245]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[246]                     vars                          [246]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[247]                     vars                          [247]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[248]                     vars                          [248]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[249]                     vars                          [249]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[250]                     vars                          [250]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[251]                     vars                          [251]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[252]                     vars                          [252]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[253]                     vars                          [253]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[254]                     vars                          [254]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
vars                          vars[255]                     vars                          [255]                                                           'F'    [3.40282346639e+38,-3.40282346639e+38]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 256 )
   {
      // the training input variables
      const char* inputVars[] = { "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars", "vars" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;
      fVmin[7] = 0;
      fVmax[7] = 0;
      fVmin[8] = 0;
      fVmax[8] = 0;
      fVmin[9] = 0;
      fVmax[9] = 0;
      fVmin[10] = 0;
      fVmax[10] = 0;
      fVmin[11] = 0;
      fVmax[11] = 0;
      fVmin[12] = 0;
      fVmax[12] = 0;
      fVmin[13] = 0;
      fVmax[13] = 0;
      fVmin[14] = 0;
      fVmax[14] = 0;
      fVmin[15] = 0;
      fVmax[15] = 0;
      fVmin[16] = 0;
      fVmax[16] = 0;
      fVmin[17] = 0;
      fVmax[17] = 0;
      fVmin[18] = 0;
      fVmax[18] = 0;
      fVmin[19] = 0;
      fVmax[19] = 0;
      fVmin[20] = 0;
      fVmax[20] = 0;
      fVmin[21] = 0;
      fVmax[21] = 0;
      fVmin[22] = 0;
      fVmax[22] = 0;
      fVmin[23] = 0;
      fVmax[23] = 0;
      fVmin[24] = 0;
      fVmax[24] = 0;
      fVmin[25] = 0;
      fVmax[25] = 0;
      fVmin[26] = 0;
      fVmax[26] = 0;
      fVmin[27] = 0;
      fVmax[27] = 0;
      fVmin[28] = 0;
      fVmax[28] = 0;
      fVmin[29] = 0;
      fVmax[29] = 0;
      fVmin[30] = 0;
      fVmax[30] = 0;
      fVmin[31] = 0;
      fVmax[31] = 0;
      fVmin[32] = 0;
      fVmax[32] = 0;
      fVmin[33] = 0;
      fVmax[33] = 0;
      fVmin[34] = 0;
      fVmax[34] = 0;
      fVmin[35] = 0;
      fVmax[35] = 0;
      fVmin[36] = 0;
      fVmax[36] = 0;
      fVmin[37] = 0;
      fVmax[37] = 0;
      fVmin[38] = 0;
      fVmax[38] = 0;
      fVmin[39] = 0;
      fVmax[39] = 0;
      fVmin[40] = 0;
      fVmax[40] = 0;
      fVmin[41] = 0;
      fVmax[41] = 0;
      fVmin[42] = 0;
      fVmax[42] = 0;
      fVmin[43] = 0;
      fVmax[43] = 0;
      fVmin[44] = 0;
      fVmax[44] = 0;
      fVmin[45] = 0;
      fVmax[45] = 0;
      fVmin[46] = 0;
      fVmax[46] = 0;
      fVmin[47] = 0;
      fVmax[47] = 0;
      fVmin[48] = 0;
      fVmax[48] = 0;
      fVmin[49] = 0;
      fVmax[49] = 0;
      fVmin[50] = 0;
      fVmax[50] = 0;
      fVmin[51] = 0;
      fVmax[51] = 0;
      fVmin[52] = 0;
      fVmax[52] = 0;
      fVmin[53] = 0;
      fVmax[53] = 0;
      fVmin[54] = 0;
      fVmax[54] = 0;
      fVmin[55] = 0;
      fVmax[55] = 0;
      fVmin[56] = 0;
      fVmax[56] = 0;
      fVmin[57] = 0;
      fVmax[57] = 0;
      fVmin[58] = 0;
      fVmax[58] = 0;
      fVmin[59] = 0;
      fVmax[59] = 0;
      fVmin[60] = 0;
      fVmax[60] = 0;
      fVmin[61] = 0;
      fVmax[61] = 0;
      fVmin[62] = 0;
      fVmax[62] = 0;
      fVmin[63] = 0;
      fVmax[63] = 0;
      fVmin[64] = 0;
      fVmax[64] = 0;
      fVmin[65] = 0;
      fVmax[65] = 0;
      fVmin[66] = 0;
      fVmax[66] = 0;
      fVmin[67] = 0;
      fVmax[67] = 0;
      fVmin[68] = 0;
      fVmax[68] = 0;
      fVmin[69] = 0;
      fVmax[69] = 0;
      fVmin[70] = 0;
      fVmax[70] = 0;
      fVmin[71] = 0;
      fVmax[71] = 0;
      fVmin[72] = 0;
      fVmax[72] = 0;
      fVmin[73] = 0;
      fVmax[73] = 0;
      fVmin[74] = 0;
      fVmax[74] = 0;
      fVmin[75] = 0;
      fVmax[75] = 0;
      fVmin[76] = 0;
      fVmax[76] = 0;
      fVmin[77] = 0;
      fVmax[77] = 0;
      fVmin[78] = 0;
      fVmax[78] = 0;
      fVmin[79] = 0;
      fVmax[79] = 0;
      fVmin[80] = 0;
      fVmax[80] = 0;
      fVmin[81] = 0;
      fVmax[81] = 0;
      fVmin[82] = 0;
      fVmax[82] = 0;
      fVmin[83] = 0;
      fVmax[83] = 0;
      fVmin[84] = 0;
      fVmax[84] = 0;
      fVmin[85] = 0;
      fVmax[85] = 0;
      fVmin[86] = 0;
      fVmax[86] = 0;
      fVmin[87] = 0;
      fVmax[87] = 0;
      fVmin[88] = 0;
      fVmax[88] = 0;
      fVmin[89] = 0;
      fVmax[89] = 0;
      fVmin[90] = 0;
      fVmax[90] = 0;
      fVmin[91] = 0;
      fVmax[91] = 0;
      fVmin[92] = 0;
      fVmax[92] = 0;
      fVmin[93] = 0;
      fVmax[93] = 0;
      fVmin[94] = 0;
      fVmax[94] = 0;
      fVmin[95] = 0;
      fVmax[95] = 0;
      fVmin[96] = 0;
      fVmax[96] = 0;
      fVmin[97] = 0;
      fVmax[97] = 0;
      fVmin[98] = 0;
      fVmax[98] = 0;
      fVmin[99] = 0;
      fVmax[99] = 0;
      fVmin[100] = 0;
      fVmax[100] = 0;
      fVmin[101] = 0;
      fVmax[101] = 0;
      fVmin[102] = 0;
      fVmax[102] = 0;
      fVmin[103] = 0;
      fVmax[103] = 0;
      fVmin[104] = 0;
      fVmax[104] = 0;
      fVmin[105] = 0;
      fVmax[105] = 0;
      fVmin[106] = 0;
      fVmax[106] = 0;
      fVmin[107] = 0;
      fVmax[107] = 0;
      fVmin[108] = 0;
      fVmax[108] = 0;
      fVmin[109] = 0;
      fVmax[109] = 0;
      fVmin[110] = 0;
      fVmax[110] = 0;
      fVmin[111] = 0;
      fVmax[111] = 0;
      fVmin[112] = 0;
      fVmax[112] = 0;
      fVmin[113] = 0;
      fVmax[113] = 0;
      fVmin[114] = 0;
      fVmax[114] = 0;
      fVmin[115] = 0;
      fVmax[115] = 0;
      fVmin[116] = 0;
      fVmax[116] = 0;
      fVmin[117] = 0;
      fVmax[117] = 0;
      fVmin[118] = 0;
      fVmax[118] = 0;
      fVmin[119] = 0;
      fVmax[119] = 0;
      fVmin[120] = 0;
      fVmax[120] = 0;
      fVmin[121] = 0;
      fVmax[121] = 0;
      fVmin[122] = 0;
      fVmax[122] = 0;
      fVmin[123] = 0;
      fVmax[123] = 0;
      fVmin[124] = 0;
      fVmax[124] = 0;
      fVmin[125] = 0;
      fVmax[125] = 0;
      fVmin[126] = 0;
      fVmax[126] = 0;
      fVmin[127] = 0;
      fVmax[127] = 0;
      fVmin[128] = 0;
      fVmax[128] = 0;
      fVmin[129] = 0;
      fVmax[129] = 0;
      fVmin[130] = 0;
      fVmax[130] = 0;
      fVmin[131] = 0;
      fVmax[131] = 0;
      fVmin[132] = 0;
      fVmax[132] = 0;
      fVmin[133] = 0;
      fVmax[133] = 0;
      fVmin[134] = 0;
      fVmax[134] = 0;
      fVmin[135] = 0;
      fVmax[135] = 0;
      fVmin[136] = 0;
      fVmax[136] = 0;
      fVmin[137] = 0;
      fVmax[137] = 0;
      fVmin[138] = 0;
      fVmax[138] = 0;
      fVmin[139] = 0;
      fVmax[139] = 0;
      fVmin[140] = 0;
      fVmax[140] = 0;
      fVmin[141] = 0;
      fVmax[141] = 0;
      fVmin[142] = 0;
      fVmax[142] = 0;
      fVmin[143] = 0;
      fVmax[143] = 0;
      fVmin[144] = 0;
      fVmax[144] = 0;
      fVmin[145] = 0;
      fVmax[145] = 0;
      fVmin[146] = 0;
      fVmax[146] = 0;
      fVmin[147] = 0;
      fVmax[147] = 0;
      fVmin[148] = 0;
      fVmax[148] = 0;
      fVmin[149] = 0;
      fVmax[149] = 0;
      fVmin[150] = 0;
      fVmax[150] = 0;
      fVmin[151] = 0;
      fVmax[151] = 0;
      fVmin[152] = 0;
      fVmax[152] = 0;
      fVmin[153] = 0;
      fVmax[153] = 0;
      fVmin[154] = 0;
      fVmax[154] = 0;
      fVmin[155] = 0;
      fVmax[155] = 0;
      fVmin[156] = 0;
      fVmax[156] = 0;
      fVmin[157] = 0;
      fVmax[157] = 0;
      fVmin[158] = 0;
      fVmax[158] = 0;
      fVmin[159] = 0;
      fVmax[159] = 0;
      fVmin[160] = 0;
      fVmax[160] = 0;
      fVmin[161] = 0;
      fVmax[161] = 0;
      fVmin[162] = 0;
      fVmax[162] = 0;
      fVmin[163] = 0;
      fVmax[163] = 0;
      fVmin[164] = 0;
      fVmax[164] = 0;
      fVmin[165] = 0;
      fVmax[165] = 0;
      fVmin[166] = 0;
      fVmax[166] = 0;
      fVmin[167] = 0;
      fVmax[167] = 0;
      fVmin[168] = 0;
      fVmax[168] = 0;
      fVmin[169] = 0;
      fVmax[169] = 0;
      fVmin[170] = 0;
      fVmax[170] = 0;
      fVmin[171] = 0;
      fVmax[171] = 0;
      fVmin[172] = 0;
      fVmax[172] = 0;
      fVmin[173] = 0;
      fVmax[173] = 0;
      fVmin[174] = 0;
      fVmax[174] = 0;
      fVmin[175] = 0;
      fVmax[175] = 0;
      fVmin[176] = 0;
      fVmax[176] = 0;
      fVmin[177] = 0;
      fVmax[177] = 0;
      fVmin[178] = 0;
      fVmax[178] = 0;
      fVmin[179] = 0;
      fVmax[179] = 0;
      fVmin[180] = 0;
      fVmax[180] = 0;
      fVmin[181] = 0;
      fVmax[181] = 0;
      fVmin[182] = 0;
      fVmax[182] = 0;
      fVmin[183] = 0;
      fVmax[183] = 0;
      fVmin[184] = 0;
      fVmax[184] = 0;
      fVmin[185] = 0;
      fVmax[185] = 0;
      fVmin[186] = 0;
      fVmax[186] = 0;
      fVmin[187] = 0;
      fVmax[187] = 0;
      fVmin[188] = 0;
      fVmax[188] = 0;
      fVmin[189] = 0;
      fVmax[189] = 0;
      fVmin[190] = 0;
      fVmax[190] = 0;
      fVmin[191] = 0;
      fVmax[191] = 0;
      fVmin[192] = 0;
      fVmax[192] = 0;
      fVmin[193] = 0;
      fVmax[193] = 0;
      fVmin[194] = 0;
      fVmax[194] = 0;
      fVmin[195] = 0;
      fVmax[195] = 0;
      fVmin[196] = 0;
      fVmax[196] = 0;
      fVmin[197] = 0;
      fVmax[197] = 0;
      fVmin[198] = 0;
      fVmax[198] = 0;
      fVmin[199] = 0;
      fVmax[199] = 0;
      fVmin[200] = 0;
      fVmax[200] = 0;
      fVmin[201] = 0;
      fVmax[201] = 0;
      fVmin[202] = 0;
      fVmax[202] = 0;
      fVmin[203] = 0;
      fVmax[203] = 0;
      fVmin[204] = 0;
      fVmax[204] = 0;
      fVmin[205] = 0;
      fVmax[205] = 0;
      fVmin[206] = 0;
      fVmax[206] = 0;
      fVmin[207] = 0;
      fVmax[207] = 0;
      fVmin[208] = 0;
      fVmax[208] = 0;
      fVmin[209] = 0;
      fVmax[209] = 0;
      fVmin[210] = 0;
      fVmax[210] = 0;
      fVmin[211] = 0;
      fVmax[211] = 0;
      fVmin[212] = 0;
      fVmax[212] = 0;
      fVmin[213] = 0;
      fVmax[213] = 0;
      fVmin[214] = 0;
      fVmax[214] = 0;
      fVmin[215] = 0;
      fVmax[215] = 0;
      fVmin[216] = 0;
      fVmax[216] = 0;
      fVmin[217] = 0;
      fVmax[217] = 0;
      fVmin[218] = 0;
      fVmax[218] = 0;
      fVmin[219] = 0;
      fVmax[219] = 0;
      fVmin[220] = 0;
      fVmax[220] = 0;
      fVmin[221] = 0;
      fVmax[221] = 0;
      fVmin[222] = 0;
      fVmax[222] = 0;
      fVmin[223] = 0;
      fVmax[223] = 0;
      fVmin[224] = 0;
      fVmax[224] = 0;
      fVmin[225] = 0;
      fVmax[225] = 0;
      fVmin[226] = 0;
      fVmax[226] = 0;
      fVmin[227] = 0;
      fVmax[227] = 0;
      fVmin[228] = 0;
      fVmax[228] = 0;
      fVmin[229] = 0;
      fVmax[229] = 0;
      fVmin[230] = 0;
      fVmax[230] = 0;
      fVmin[231] = 0;
      fVmax[231] = 0;
      fVmin[232] = 0;
      fVmax[232] = 0;
      fVmin[233] = 0;
      fVmax[233] = 0;
      fVmin[234] = 0;
      fVmax[234] = 0;
      fVmin[235] = 0;
      fVmax[235] = 0;
      fVmin[236] = 0;
      fVmax[236] = 0;
      fVmin[237] = 0;
      fVmax[237] = 0;
      fVmin[238] = 0;
      fVmax[238] = 0;
      fVmin[239] = 0;
      fVmax[239] = 0;
      fVmin[240] = 0;
      fVmax[240] = 0;
      fVmin[241] = 0;
      fVmax[241] = 0;
      fVmin[242] = 0;
      fVmax[242] = 0;
      fVmin[243] = 0;
      fVmax[243] = 0;
      fVmin[244] = 0;
      fVmax[244] = 0;
      fVmin[245] = 0;
      fVmax[245] = 0;
      fVmin[246] = 0;
      fVmax[246] = 0;
      fVmin[247] = 0;
      fVmax[247] = 0;
      fVmin[248] = 0;
      fVmax[248] = 0;
      fVmin[249] = 0;
      fVmax[249] = 0;
      fVmin[250] = 0;
      fVmax[250] = 0;
      fVmin[251] = 0;
      fVmax[251] = 0;
      fVmin[252] = 0;
      fVmax[252] = 0;
      fVmin[253] = 0;
      fVmax[253] = 0;
      fVmin[254] = 0;
      fVmax[254] = 0;
      fVmin[255] = 0;
      fVmax[255] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';
      fType[7] = 'F';
      fType[8] = 'F';
      fType[9] = 'F';
      fType[10] = 'F';
      fType[11] = 'F';
      fType[12] = 'F';
      fType[13] = 'F';
      fType[14] = 'F';
      fType[15] = 'F';
      fType[16] = 'F';
      fType[17] = 'F';
      fType[18] = 'F';
      fType[19] = 'F';
      fType[20] = 'F';
      fType[21] = 'F';
      fType[22] = 'F';
      fType[23] = 'F';
      fType[24] = 'F';
      fType[25] = 'F';
      fType[26] = 'F';
      fType[27] = 'F';
      fType[28] = 'F';
      fType[29] = 'F';
      fType[30] = 'F';
      fType[31] = 'F';
      fType[32] = 'F';
      fType[33] = 'F';
      fType[34] = 'F';
      fType[35] = 'F';
      fType[36] = 'F';
      fType[37] = 'F';
      fType[38] = 'F';
      fType[39] = 'F';
      fType[40] = 'F';
      fType[41] = 'F';
      fType[42] = 'F';
      fType[43] = 'F';
      fType[44] = 'F';
      fType[45] = 'F';
      fType[46] = 'F';
      fType[47] = 'F';
      fType[48] = 'F';
      fType[49] = 'F';
      fType[50] = 'F';
      fType[51] = 'F';
      fType[52] = 'F';
      fType[53] = 'F';
      fType[54] = 'F';
      fType[55] = 'F';
      fType[56] = 'F';
      fType[57] = 'F';
      fType[58] = 'F';
      fType[59] = 'F';
      fType[60] = 'F';
      fType[61] = 'F';
      fType[62] = 'F';
      fType[63] = 'F';
      fType[64] = 'F';
      fType[65] = 'F';
      fType[66] = 'F';
      fType[67] = 'F';
      fType[68] = 'F';
      fType[69] = 'F';
      fType[70] = 'F';
      fType[71] = 'F';
      fType[72] = 'F';
      fType[73] = 'F';
      fType[74] = 'F';
      fType[75] = 'F';
      fType[76] = 'F';
      fType[77] = 'F';
      fType[78] = 'F';
      fType[79] = 'F';
      fType[80] = 'F';
      fType[81] = 'F';
      fType[82] = 'F';
      fType[83] = 'F';
      fType[84] = 'F';
      fType[85] = 'F';
      fType[86] = 'F';
      fType[87] = 'F';
      fType[88] = 'F';
      fType[89] = 'F';
      fType[90] = 'F';
      fType[91] = 'F';
      fType[92] = 'F';
      fType[93] = 'F';
      fType[94] = 'F';
      fType[95] = 'F';
      fType[96] = 'F';
      fType[97] = 'F';
      fType[98] = 'F';
      fType[99] = 'F';
      fType[100] = 'F';
      fType[101] = 'F';
      fType[102] = 'F';
      fType[103] = 'F';
      fType[104] = 'F';
      fType[105] = 'F';
      fType[106] = 'F';
      fType[107] = 'F';
      fType[108] = 'F';
      fType[109] = 'F';
      fType[110] = 'F';
      fType[111] = 'F';
      fType[112] = 'F';
      fType[113] = 'F';
      fType[114] = 'F';
      fType[115] = 'F';
      fType[116] = 'F';
      fType[117] = 'F';
      fType[118] = 'F';
      fType[119] = 'F';
      fType[120] = 'F';
      fType[121] = 'F';
      fType[122] = 'F';
      fType[123] = 'F';
      fType[124] = 'F';
      fType[125] = 'F';
      fType[126] = 'F';
      fType[127] = 'F';
      fType[128] = 'F';
      fType[129] = 'F';
      fType[130] = 'F';
      fType[131] = 'F';
      fType[132] = 'F';
      fType[133] = 'F';
      fType[134] = 'F';
      fType[135] = 'F';
      fType[136] = 'F';
      fType[137] = 'F';
      fType[138] = 'F';
      fType[139] = 'F';
      fType[140] = 'F';
      fType[141] = 'F';
      fType[142] = 'F';
      fType[143] = 'F';
      fType[144] = 'F';
      fType[145] = 'F';
      fType[146] = 'F';
      fType[147] = 'F';
      fType[148] = 'F';
      fType[149] = 'F';
      fType[150] = 'F';
      fType[151] = 'F';
      fType[152] = 'F';
      fType[153] = 'F';
      fType[154] = 'F';
      fType[155] = 'F';
      fType[156] = 'F';
      fType[157] = 'F';
      fType[158] = 'F';
      fType[159] = 'F';
      fType[160] = 'F';
      fType[161] = 'F';
      fType[162] = 'F';
      fType[163] = 'F';
      fType[164] = 'F';
      fType[165] = 'F';
      fType[166] = 'F';
      fType[167] = 'F';
      fType[168] = 'F';
      fType[169] = 'F';
      fType[170] = 'F';
      fType[171] = 'F';
      fType[172] = 'F';
      fType[173] = 'F';
      fType[174] = 'F';
      fType[175] = 'F';
      fType[176] = 'F';
      fType[177] = 'F';
      fType[178] = 'F';
      fType[179] = 'F';
      fType[180] = 'F';
      fType[181] = 'F';
      fType[182] = 'F';
      fType[183] = 'F';
      fType[184] = 'F';
      fType[185] = 'F';
      fType[186] = 'F';
      fType[187] = 'F';
      fType[188] = 'F';
      fType[189] = 'F';
      fType[190] = 'F';
      fType[191] = 'F';
      fType[192] = 'F';
      fType[193] = 'F';
      fType[194] = 'F';
      fType[195] = 'F';
      fType[196] = 'F';
      fType[197] = 'F';
      fType[198] = 'F';
      fType[199] = 'F';
      fType[200] = 'F';
      fType[201] = 'F';
      fType[202] = 'F';
      fType[203] = 'F';
      fType[204] = 'F';
      fType[205] = 'F';
      fType[206] = 'F';
      fType[207] = 'F';
      fType[208] = 'F';
      fType[209] = 'F';
      fType[210] = 'F';
      fType[211] = 'F';
      fType[212] = 'F';
      fType[213] = 'F';
      fType[214] = 'F';
      fType[215] = 'F';
      fType[216] = 'F';
      fType[217] = 'F';
      fType[218] = 'F';
      fType[219] = 'F';
      fType[220] = 'F';
      fType[221] = 'F';
      fType[222] = 'F';
      fType[223] = 'F';
      fType[224] = 'F';
      fType[225] = 'F';
      fType[226] = 'F';
      fType[227] = 'F';
      fType[228] = 'F';
      fType[229] = 'F';
      fType[230] = 'F';
      fType[231] = 'F';
      fType[232] = 'F';
      fType[233] = 'F';
      fType[234] = 'F';
      fType[235] = 'F';
      fType[236] = 'F';
      fType[237] = 'F';
      fType[238] = 'F';
      fType[239] = 'F';
      fType[240] = 'F';
      fType[241] = 'F';
      fType[242] = 'F';
      fType[243] = 'F';
      fType[244] = 'F';
      fType[245] = 'F';
      fType[246] = 'F';
      fType[247] = 'F';
      fType[248] = 'F';
      fType[249] = 'F';
      fType[250] = 'F';
      fType[251] = 'F';
      fType[252] = 'F';
      fType[253] = 'F';
      fType[254] = 'F';
      fType[255] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[256];
   double fVmax[256];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[256];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.225567572470676);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 53.4172, 1, 1, 0.679245,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403654,-99) , 
129, 15.6987, 1, 0, 0.439499,-99) , 
125, 18.3814, 1, 0, 0.470303,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.22738);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37392,-99) , 
135, 86.218, 1, 0, 0.561376,-99) , 
NN(
0, 
0, 
-1, 22.8338, 0, -1, 0.401857,-99) , 
103, 80.2909, 1, 0, 0.508963,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.217546);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418696,-99) , 
43, 18.1177, 0, 0, 0.572881,-99) , 
NN(
0, 
0, 
-1, 26.6496, 0, -1, 0.411317,-99) , 
199, 42.4118, 0, 0, 0.518818,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.261644);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 28.6058, 1, 1, 0.620046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341429,-99) , 
142, 16.0208, 1, 0, 0.438237,-99) , 
64, 20.0754, 1, 0, 0.536884,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.174557);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 41.9653, 1, 1, 0.772376,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373519,-99) , 
160, 33.9041, 1, 0, 0.519665,-99) , 
196, 78.2971, 0, 0, 0.5386,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.0944507);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821624,-99) , 
NN(
0, 
0, 
-1, 1.74299, 0, -1, 0.467005,-99) , 
235, 62.2463, 0, 0, 0.484317,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.299763);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 39.8346, 1, 1, 0.624613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.688826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339281,-99) , 
100, 32.8642, 1, 0, 0.385223,-99) , 
127, 22.3226, 1, 0, 0.498695,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.0938911);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 14.8456, 1, 1, 0.529816,-99) , 
NN(
0, 
0, 
-1, 35.5838, 1, -1, 0.243309,-99) , 
88, 42.2681, 0, 0, 0.508357,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.209424);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416318,-99) , 
227, 20.8121, 0, 0, 0.497832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.137816,-99) , 
153, 90.7286, 0, 0, 0.251439,-99) , 
21, 10.5473, 0, 0, 0.471671,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.188102);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489516,-99) , 
109, 29.4597, 1, 0, 0.549314,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225303,-99) , 
226, 34.7873, 0, 0, 0.364906,-99) , 
161, 40.4525, 1, 0, 0.49168,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.291174);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460013,-99) , 
170, 64.4456, 1, 0, 0.586902,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291113,-99) , 
190, 9.93608, 1, 0, 0.365217,-99) , 
161, 37.2682, 1, 0, 0.506373,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.182004);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407506,-99) , 
251, 14.1175, 0, 0, 0.519745,-99) , 
NN(
0, 
0, 
-1, 18.7822, 1, -1, 0.232227,-99) , 
49, 53.291, 1, 0, 0.497092,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.101939);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 12.6679, 1, 1, 0.743016,-99) , 
NN(
0, 
0, 
-1, 35.6325, 0, -1, 0.460347,-99) , 
200, 84.7687, 0, 0, 0.475831,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.169855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458536,-99) , 
169, 76.504, 0, 0, 0.509087,-99) , 
NN(
0, 
0, 
-1, 28.9673, 1, -1, 0.204946,-99) , 
23, 10.5249, 0, 0, 0.489024,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.174366);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 75.054, 0, 1, 0.814588,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357194,-99) , 
18, 13.0814, 0, 0, 0.471215,-99) , 
131, 24.6085, 1, 0, 0.496675,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.196336);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233367,-99) , 
250, 5.31249, 0, 0, 0.516362,-99) , 
NN(
0, 
0, 
-1, 47.6327, 0, -1, 0.2724,-99) , 
70, 38.1397, 0, 0, 0.473264,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.130714);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.927687,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425596,-99) , 
214, 21.7984, 0, 0, 0.762613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501035,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283978,-99) , 
103, 60.1297, 0, 0, 0.460744,-99) , 
129, 10.9632, 1, 0, 0.487569,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.25698);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327799,-99) , 
198, 25.7026, 0, 0, 0.561264,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694397,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381936,-99) , 
121, 51.9563, 1, 0, 0.417991,-99) , 
192, 14.0055, 1, 0, 0.480056,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.174885);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289721,-99) , 
170, 43.3606, 0, 0, 0.657394,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273311,-99) , 
226, 11.516, 0, 0, 0.461886,-99) , 
44, 42.3354, 0, 0, 0.506488,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.206944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337457,-99) , 
11, 6.85011, 0, 0, 0.524737,-99) , 
NN(
0, 
0, 
-1, 24.1143, 0, -1, 0.257266,-99) , 
101, 92.1487, 1, 0, 0.498884,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.278825);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367201,-99) , 
68, 39.0448, 0, 0, 0.669576,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355084,-99) , 
216, 55.5634, 0, 0, 0.411139,-99) , 
120, 61.3245, 1, 0, 0.437968,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.183102);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464857,-99) , 
144, 13.7116, 1, 0, 0.513921,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0921294,-99) , 
81, 9.93603, 1, 0, 0.232018,-99) , 
86, 42.1556, 0, 0, 0.486791,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.101613);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.719497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495376,-99) , 
128, 7.56892, 1, 0, 0.521291,-99) , 
NN(
0, 
0, 
-1, 7.59316, 1, -1, 0.192021,-99) , 
96, 51.291, 1, 0, 0.496271,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.282212);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401323,-99) , 
184, 36.6611, 0, 0, 0.605117,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387533,-99) , 
214, 79.1945, 0, 0, 0.414867,-99) , 
25, 32.538, 0, 0, 0.502359,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.206141);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340291,-99) , 
59, 35.5539, 0, 0, 0.616035,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.187955,-99) , 
127, 28.4572, 1, 0, 0.43379,-99) , 
112, 14.373, 1, 0, 0.484407,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.245853);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205489,-99) , 
144, 55.0033, 1, 0, 0.627786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423142,-99) , 
142, 15.3728, 1, 0, 0.456011,-99) , 
212, 45.8879, 0, 0, 0.500287,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.179059);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468715,-99) , 
106, 74.8689, 0, 0, 0.527086,-99) , 
NN(
0, 
0, 
-1, 15.6809, 0, -1, 0.345826,-99) , 
119, 67.7932, 0, 0, 0.48897,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.0838034);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 17.5926, 0, 1, 0.838835,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 1,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496262,-99) , 
80, -0.191435, 1, 0, 0.511353,-99) , 
239, -1.90503, 1, 0, 0.535078,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.208389);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 48.6381, 0, 1, 0.651588,-99) , 
NN(
0, 
0, 
-1, 35.5774, 1, -1, 0.429068,-99) , 
189, 26.0114, 1, 0, 0.516745,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.268074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.684671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432191,-99) , 
62, 34.3266, 1, 0, 0.586066,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390095,-99) , 
28, 31.6713, 0, 0, 0.421207,-99) , 
161, 27.4091, 1, 0, 0.500278,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.147142);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 79.2629, 0, 1, 0.855597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19546,-99) , 
21, 8.83133, 0, 0, 0.516753,-99) , 
129, 10.0898, 1, 0, 0.540713,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.196795);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.411303,-99) , 
137, 72.2846, 1, 0, 0.682262,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.902385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457848,-99) , 
217, 82.2142, 0, 0, 0.482173,-99) , 
133, 83.9172, 0, 0, 0.525167,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.174682);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 15.381, 1, 1, 0.782459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62341,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463682,-99) , 
243, 23.4163, 0, 0, 0.518571,-99) , 
58, 82.4042, 0, 0, 0.543246,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.141086);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 23.84, 0, 1, 0.806014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483672,-99) , 
137, 60.5447, 1, 0, 0.525393,-99) , 
84, 29.6475, 1, 0, 0.547149,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.240498);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599757,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334462,-99) , 
112, 47.2503, 1, 0, 0.578698,-99) , 
NN(
0, 
0, 
-1, 14.746, 1, -1, 0.325556,-99) , 
193, 39.1668, 1, 0, 0.531307,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.264212);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36476,-99) , 
119, 69.7534, 0, 0, 0.653105,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45245,-99) , 
100, 31.4143, 1, 0, 0.493934,-99) , 
175, 17.0914, 1, 0, 0.560149,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.189);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 31.0716, 0, 1, 0.856416,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338502,-99) , 
191, 32.4595, 1, 0, 0.524393,-99) , 
114, 15.7179, 1, 0, 0.546699,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.120737);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 15.5173, 0, 1, 0.824492,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.966238,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485598,-99) , 
238, -3.18851, 1, 0, 0.505092,-99) , 
114, 18.1159, 1, 0, 0.535032,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.150485);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 15.8142, 1, 1, 0.559881,-99) , 
NN(
0, 
0, 
-1, 15.6627, 1, -1, 0.18028,-99) , 
81, 64.7521, 1, 0, 0.538262,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.240733);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433006,-99) , 
222, 32.2876, 1, 0, 0.608082,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354708,-99) , 
22, 40.9527, 0, 0, 0.469303,-99) , 
252, 21.1219, 0, 0, 0.52416,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.218427);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 16.3453, 1, 1, 0.700706,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437254,-99) , 
77, 9.35774, 1, 0, 0.463504,-99) , 
1, 3.26276, 1, 0, 0.516666,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.168141);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 75.6733, 0, 1, 0.569926,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146951,-99) , 
143, 24.4746, 1, 0, 0.379859,-99) , 
233, 17.579, 0, 0, 0.532638,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.161167);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.723219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492943,-99) , 
143, 11.3518, 1, 0, 0.538109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181399,-99) , 
79, 4.28084, 1, 0, 0.265027,-99) , 
25, 13.7407, 0, 0, 0.499651,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.139479);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.72548, 0, 1, 0.817529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.308091,-99) , 
103, 58.7838, 0, 0, 0.503,-99) , 
153, 96.654, 0, 0, 0.521765,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.180052);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345638,-99) , 
37, 24.2647, 0, 0, 0.484021,-99) , 
NN(
0, 
0, 
-1, 71.6042, 1, -1, 0.219745,-99) , 
201, 21.0695, 0, 0, 0.462448,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.277577);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 21.886, 0, 1, 0.607045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345959,-99) , 
42, 69.7272, 0, 0, 0.399752,-99) , 
232, 32.9709, 0, 0, 0.496417,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.180615);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320538,-99) , 
23, 15.1135, 0, 0, 0.531882,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0366727,-99) , 
43, 7.7671, 0, 0, 0.513458,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.186016);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669779,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449752,-99) , 
187, 58.5733, 0, 0, 0.503473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.185941,-99) , 
6, 4.39461, 0, 0, 0.486531,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.166347);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.277863,-99) , 
251, 4.76629, 0, 0, 0.522055,-99) , 
NN(
0, 
0, 
-1, 70.0263, 0, -1, 0.186617,-99) , 
245, 3.78371, 0, 0, 0.501351,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.193043);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.8358, 0, 1, 0.81072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806439,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428183,-99) , 
137, 49.098, 1, 0, 0.443176,-99) , 
129, 9.49987, 1, 0, 0.465945,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.163842);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 19.4406, 0, 1, 0.657651,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.865244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444667,-99) , 
218, 9.94956, 1, 0, 0.461357,-99) , 
246, 44.5907, 0, 0, 0.490936,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.223032);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469623,-99) , 
201, 36.6462, 0, 0, 0.62739,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42858,-99) , 
133, 94.8415, 0, 0, 0.455763,-99) , 
56, 62.3795, 0, 0, 0.511725,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.21633);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 87.4247, 0, 1, 0.578144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366827,-99) , 
131, 38.7103, 1, 0, 0.413264,-99) , 
135, 73.6283, 1, 0, 0.482418,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.297371);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370116,-99) , 
182, 36.4421, 0, 0, 0.603997,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.770333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400512,-99) , 
225, 39.7777, 0, 0, 0.459388,-99) , 
8, 25.9545, 0, 0, 0.528584,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.23428);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.5822, 1, 1, 0.614335,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.828262,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405896,-99) , 
114, 15.331, 1, 0, 0.445641,-99) , 
47, 14.7906, 1, 0, 0.548086,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.129197);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495319,-99) , 
137, 64.8535, 1, 0, 0.542132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0405012,-99) , 
170, 32.76, 1, 0, 0.23223,-99) , 
32, 37.3193, 1, 0, 0.520825,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.202824);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778006,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401143,-99) , 
49, 19.2976, 1, 0, 0.711597,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.349355,-99) , 
55, 66.3646, 1, 0, 0.487149,-99) , 
133, 50.3279, 1, 0, 0.525185,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.318141);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624272,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320531,-99) , 
11, 8.88933, 0, 0, 0.586903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307328,-99) , 
117, 92.448, 0, 0, 0.354838,-99) , 
96, 26.7702, 1, 0, 0.487306,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.227841);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591098,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398789,-99) , 
233, 17.8599, 0, 0, 0.546988,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599985,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.141303,-99) , 
29, 4.4193, 1, 0, 0.280413,-99) , 
47, 0.808334, 0, 0, 0.520487,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.214449);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 56.6288, 0, 1, 0.57589,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.313406,-99) , 
216, 67.1437, 0, 0, 0.406465,-99) , 
6, 18.2969, 0, 0, 0.511113,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.19117);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542684,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327234,-99) , 
22, 16.4763, 0, 0, 0.511801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18944,-99) , 
122, 39.5026, 1, 0, 0.274099,-99) , 
144, 44.0083, 1, 0, 0.47645,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.255402);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.625286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423044,-99) , 
185, 68.7094, 1, 0, 0.535883,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29688,-99) , 
189, 6.58744, 1, 0, 0.341331,-99) , 
250, 11.7189, 0, 0, 0.493285,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.17624);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351969,-99) , 
9, 11.8605, 0, 0, 0.516869,-99) , 
NN(
0, 
0, 
-1, 13.9782, 0, -1, 0.205172,-99) , 
104, 96.292, 1, 0, 0.493786,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.163816);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 16.8429, 0, 1, 0.677845,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284431,-99) , 
19, 17.4825, 0, 0, 0.44192,-99) , 
251, 35.219, 0, 0, 0.481388,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.215788);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.65499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.457541,-99) , 
120, 83.8571, 0, 0, 0.511671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.626369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184526,-99) , 
250, 16.8946, 0, 0, 0.27243,-99) , 
254, 1.67822, 0, 0, 0.473143,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.216701);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.57108, 1, 1, 0.790346,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41945,-99) , 
114, 15.7179, 1, 0, 0.434384,-99) , 
191, 44.7272, 0, 0, 0.463822,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.151956);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.803513,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488973,-99) , 
216, 20.9983, 1, 0, 0.516049,-99) , 
NN(
0, 
0, 
-1, 20.9655, 0, -1, 0.277116,-99) , 
231, 17.3394, 0, 0, 0.465885,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.244632);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771883,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.152296,-99) , 
57, 20.8388, 0, 0, 0.672963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608573,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418949,-99) , 
114, 29.4485, 1, 0, 0.471646,-99) , 
229, 53.5549, 0, 0, 0.503843,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.183581);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 78.2488, 0, 1, 0.800283,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259917,-99) , 
171, 35.3452, 0, 0, 0.491712,-99) , 
5, 56.5748, 0, 0, 0.515677,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.1801);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488819,-99) , 
128, 21.7751, 1, 0, 0.546177,-99) , 
NN(
0, 
0, 
-1, 12.1046, 0, -1, 0.381969,-99) , 
142, 30.5984, 1, 0, 0.472123,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.26798);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.16526,-99) , 
36, 31.6857, 0, 0, 0.621801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657392,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41064,-99) , 
249, 44.885, 0, 0, 0.458843,-99) , 
221, 15.1208, 1, 0, 0.511472,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.249853);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673968,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468351,-99) , 
6, 18.9957, 0, 0, 0.578889,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167632,-99) , 
165, 52.4445, 0, 0, 0.341638,-99) , 
249, 11.5177, 0, 0, 0.528659,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.303686);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681115,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.238543,-99) , 
194, 69.7821, 1, 0, 0.631564,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609979,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363623,-99) , 
137, 58.9261, 1, 0, 0.41548,-99) , 
231, 48.0526, 0, 0, 0.475692,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.182826);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 21.2708, 0, 1, 0.621855,-99) , 
NN(
0, 
0, 
-1, 40.2656, 1, -1, 0.433374,-99) , 
214, 45.1793, 0, 0, 0.514535,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.251756);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.700751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.30572,-99) , 
189, 29.1837, 1, 0, 0.658812,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564771,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364957,-99) , 
253, 12.619, 0, 0, 0.486116,-99) , 
175, 12.0499, 1, 0, 0.535618,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.133939);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.907832,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311288,-99) , 
39, 24.8231, 0, 0, 0.501912,-99) , 
235, 65.4607, 0, 0, 0.517648,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.219955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.682192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476225,-99) , 
21, 21.3681, 0, 0, 0.587939,-99) , 
NN(
0, 
0, 
-1, 51.0537, 0, -1, 0.394437,-99) , 
185, 48.8802, 0, 0, 0.51958,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.235946);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.665956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275352,-99) , 
198, 21.4867, 0, 0, 0.615672,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.873667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437916,-99) , 
241, 38.966, 0, 0, 0.462743,-99) , 
144, 16.6479, 1, 0, 0.521507,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.180683);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.92515, 1, 1, 0.741113,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536796,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337783,-99) , 
252, 10.1971, 0, 0, 0.487615,-99) , 
157, 18.8195, 1, 0, 0.519177,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.213413);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493697,-99) , 
92, 37.9653, 0, 0, 0.583984,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217759,-99) , 
10, 21.2168, 0, 0, 0.410505,-99) , 
94, 31.5772, 1, 0, 0.518329,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.261333);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458493,-99) , 
80, 33.5565, 1, 0, 0.600641,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27948,-99) , 
145, 22.3939, 1, 0, 0.436454,-99) , 
143, 24.3421, 1, 0, 0.524551,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.243381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.67112,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408832,-99) , 
86, 90.6606, 1, 0, 0.630256,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242264,-99) , 
118, 75.8114, 1, 0, 0.4473,-99) , 
175, 17.7074, 1, 0, 0.521904,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.192575);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.2968, 1, 1, 0.804292,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301351,-99) , 
174, 34.6921, 1, 0, 0.449982,-99) , 
100, 30.4928, 1, 0, 0.478729,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.183634);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806777,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491561,-99) , 
111, 14.0295, 1, 0, 0.562313,-99) , 
NN(
0, 
0, 
-1, 38.863, 0, -1, 0.39715,-99) , 
56, 57.4771, 0, 0, 0.469674,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.164239);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 56.9437, 1, 1, 0.552888,-99) , 
NN(
0, 
0, 
-1, 35.651, 0, -1, 0.388794,-99) , 
3, 16.1423, 0, 0, 0.472692,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.193874);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.887244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458961,-99) , 
88, 73.7344, 0, 0, 0.77071,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.934976,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442342,-99) , 
246, 62.8343, 0, 0, 0.463238,-99) , 
6, 50.1794, 0, 0, 0.494182,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.199022);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 19.3876, 1, 1, 0.573201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260122,-99) , 
243, 6.83859, 1, 0, 0.377173,-99) , 
226, 9.78299, 0, 0, 0.530544,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.260851);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399879,-99) , 
235, 12.407, 0, 0, 0.638248,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.767959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417199,-99) , 
107, 97.6697, 0, 0, 0.443106,-99) , 
127, 15.2302, 1, 0, 0.502258,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.256482);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.261096,-99) , 
12, 4.73846, 0, 0, 0.676757,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550206,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365935,-99) , 
158, 21.7668, 1, 0, 0.445499,-99) , 
236, 38.4028, 0, 0, 0.487927,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.283249);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199897,-99) , 
136, 94.71, 1, 0, 0.563196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.710003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.223369,-99) , 
172, 21.1408, 1, 0, 0.313704,-99) , 
160, 37.5796, 1, 0, 0.50781,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.198549);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.713505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472949,-99) , 
252, 19.4158, 0, 0, 0.546837,-99) , 
NN(
0, 
0, 
-1, 63.6038, 0, -1, 0.362491,-99) , 
22, 19.7241, 0, 0, 0.499462,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.133523);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 66.2614, 0, 1, 0.790762,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214135,-99) , 
53, 25.2574, 0, 0, 0.488227,-99) , 
100, 31.1781, 1, 0, 0.510515,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.145109);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 20.5734, 0, 1, 0.602991,-99) , 
NN(
0, 
0, 
-1, 0.635113, 0, -1, 0.447551,-99) , 
10, 24.6427, 0, 0, 0.507831,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.208304);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.768088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330881,-99) , 
79, 10.8129, 1, 0, 0.653742,-99) , 
NN(
0, 
0, 
-1, 20.8595, 1, -1, 0.421339,-99) , 
143, 9.48756, 1, 0, 0.455458,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.199957);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569907,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.233564,-99) , 
198, 23.1954, 0, 0, 0.547212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0829592,-99) , 
248, 4.43278, 0, 0, 0.525661,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.217426);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.698289,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483848,-99) , 
40, 34.3244, 0, 0, 0.575964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53482,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.242949,-99) , 
39, 54.7707, 0, 0, 0.417874,-99) , 
233, 27.9331, 0, 0, 0.50816,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.228071);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498443,-99) , 
112, 24.9839, 1, 0, 0.574467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56608,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26749,-99) , 
215, 48.4683, 0, 0, 0.367242,-99) , 
126, 39.4762, 1, 0, 0.501226,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.248432);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.706575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359175,-99) , 
168, 88.6237, 1, 0, 0.625816,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419488,-99) , 
5, 58.7828, 0, 0, 0.442485,-99) , 
169, 75.7498, 0, 0, 0.493991,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.214382);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 30.689, 1, 1, 0.725349,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766339,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449222,-99) , 
81, 7.37503, 1, 0, 0.477747,-99) , 
143, 11.5575, 1, 0, 0.534246,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.241938);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623965,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42873,-99) , 
127, 32.4377, 1, 0, 0.557138,-99) , 
NN(
0, 
0, 
-1, 23.92, 1, -1, 0.208074,-99) , 
145, 62.9196, 1, 0, 0.533239,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.234112);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78791,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445322,-99) , 
226, 6.79204, 0, 0, 0.691618,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556894,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.210287,-99) , 
175, 35.4181, 1, 0, 0.511013,-99) , 
112, 11.9167, 1, 0, 0.547566,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.11008);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 10.3595, 1, 1, 0.544566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0783191,-99) , 
38, 12.2789, 0, 0, 0.531889,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.221138);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491848,-99) , 
70, 45.8619, 0, 0, 0.687178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397324,-99) , 
113, 16.6215, 1, 0, 0.435134,-99) , 
227, 45.831, 0, 0, 0.468022,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.108119);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.846032,-99) , 
NN(
0, 
0, 
-1, 14.3778, 0, -1, 0.463832,-99) , 
128, 4.19646, 1, 0, 0.485641,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.230121);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446724,-99) , 
161, 40.973, 1, 0, 0.576035,-99) , 
NN(
0, 
0, 
-1, 34.862, 0, -1, 0.402583,-99) , 
243, 15.1264, 0, 0, 0.506732,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.276309);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47036,-99) , 
17, 9.42139, 0, 0, 0.624178,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.797702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402171,-99) , 
128, 7.805, 1, 0, 0.448567,-99) , 
199, 60.9942, 0, 0, 0.51753,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.201369);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 53.2757, 1, 1, 0.865232,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325634,-99) , 
97, 54.1614, 1, 0, 0.531215,-99) , 
110, 7.85563, 1, 0, 0.5517,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.180212);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 72.6444, 0, 1, 0.83324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354611,-99) , 
14, 16.5802, 1, 0, 0.505657,-99) , 
128, 4.09209, 1, 0, 0.527049,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.228125);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.378055,-99) , 
135, 85.177, 1, 0, 0.544389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.137788,-99) , 
70, 100.558, 1, 0, 0.526982,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.133774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.714329,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492654,-99) , 
154, 51.6738, 1, 0, 0.540593,-99) , 
NN(
0, 
0, 
-1, 12.2029, 1, -1, 0.178356,-99) , 
49, 54.5796, 1, 0, 0.521263,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.155531);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 14.1271, 0, 1, 0.650186,-99) , 
NN(
0, 
0, 
-1, 40.5604, 1, -1, 0.465732,-99) , 
189, 25.0093, 1, 0, 0.533959,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.207121);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.863015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570261,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371959,-99) , 
41, 28.6957, 0, 0, 0.510855,-99) , 
64, 1.20292, 1, 0, 0.529438,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.184);
  fForest.push_back( 
NN(
0, 
0, 
-1, 78.4646, 0, 1, 0.590976,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.206938);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447162,-99) , 
121, 67.9419, 1, 0, 0.519908,-99) , 
NN(
0, 
0, 
-1, 21.3489, 0, -1, 0.162465,-99) , 
16, 33.3164, 1, 0, 0.496794,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.218636);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 86.8689, 0, 1, 0.658181,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.301041,-99) , 
139, 57.7683, 1, 0, 0.443314,-99) , 
32, 9.61068, 1, 0, 0.526767,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.264655);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724528,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466204,-99) , 
10, 19.7996, 0, 0, 0.549505,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253165,-99) , 
22, 56.2053, 0, 0, 0.361413,-99) , 
247, 19.1179, 0, 0, 0.473313,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.243776);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693328,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294782,-99) , 
8, 13.1807, 0, 0, 0.615453,-99) , 
NN(
0, 
0, 
-1, 19.6955, 0, -1, 0.40868,-99) , 
128, 14.6707, 1, 0, 0.464588,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.205244);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 91.3167, 0, 1, 0.567605,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673337,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316952,-99) , 
7, 54.8574, 0, 0, 0.37924,-99) , 
32, 19.6107, 1, 0, 0.511963,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.175148);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.138261,-99) , 
138, 100.939, 1, 0, 0.530615,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572023,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.134687,-99) , 
170, 56.8909, 0, 0, 0.259889,-99) , 
229, 12.3499, 0, 0, 0.497838,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.204338);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 65.193, 0, 1, 0.73673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365922,-99) , 
8, 24.8727, 0, 0, 0.454608,-99) , 
103, 52.2636, 1, 0, 0.476793,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.246023);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.730285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458004,-99) , 
223, 7.1331, 1, 0, 0.505962,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.268864,-99) , 
3, 44.8223, 0, 0, 0.323229,-99) , 
250, 16.2779, 0, 0, 0.445823,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.216282);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.209848,-99) , 
138, 94.8707, 1, 0, 0.546634,-99) , 
NN(
0, 
0, 
-1, 71.5496, 0, -1, 0.329664,-99) , 
97, 47.5735, 1, 0, 0.498699,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.193858);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.692078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456461,-99) , 
38, 53.3874, 0, 0, 0.498173,-99) , 
NN(
0, 
0, 
-1, 35.9879, 0, -1, 0.274691,-99) , 
184, 41.1708, 0, 0, 0.460947,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.236774);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 19.0527, 1, 1, 0.583848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225174,-99) , 
71, 85.6299, 0, 0, 0.322349,-99) , 
231, 19.3122, 0, 0, 0.526063,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.181233);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456453,-99) , 
27, 26.7257, 0, 0, 0.528369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169789,-99) , 
215, 15.7322, 0, 0, 0.513349,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.32716);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.734157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182256,-99) , 
57, 20.3167, 0, 0, 0.673453,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375023,-99) , 
67, 21.44, 1, 0, 0.405651,-99) , 
248, 40.2388, 0, 0, 0.478935,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.216362);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276348,-99) , 
169, 91.1678, 1, 0, 0.550534,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143052,-99) , 
151, 66.6737, 0, 0, 0.245781,-99) , 
233, 13.1817, 0, 0, 0.517866,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.117467);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.947777,-99) , 
NN(
0, 
0, 
-1, 50.8894, 0, -1, 0.453124,-99) , 
141, 11.6422, 1, 0, 0.467423,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.253769);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.845291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465298,-99) , 
14, 5.80966, 0, 0, 0.739998,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398212,-99) , 
61, 18.4879, 1, 0, 0.463608,-99) , 
251, 39.1509, 0, 0, 0.496519,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.342696);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693163,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258615,-99) , 
88, 44.1356, 0, 0, 0.662494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33543,-99) , 
79, 12.6921, 1, 0, 0.492905,-99) , 
138, 71.0132, 0, 0, 0.572114,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.159397);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.844543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376737,-99) , 
105, 49.6506, 0, 0, 0.721289,-99) , 
NN(
0, 
0, 
-1, 8.02697, 0, -1, 0.448778,-99) , 
248, 49.8951, 0, 0, 0.481022,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.113149);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.082489,-99) , 
201, 17.1131, 0, 0, 0.502982,-99) , 
NN(
0, 
0, 
-1, 43.3462, 0, -1, 0.158039,-99) , 
24, 10.9563, 0, 0, 0.479653,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.277134);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.199046,-99) , 
65, 5.64025, 0, 0, 0.581743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.812351,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.354477,-99) , 
143, 6.36016, 1, 0, 0.40692,-99) , 
119, 81.2324, 1, 0, 0.523162,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.16324);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.769385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455005,-99) , 
235, 57.5966, 0, 0, 0.478553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.123938,-99) , 
193, 1.48674, 0, 0, 0.457,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.195229);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 16.3061, 0, 1, 0.621191,-99) , 
NN(
0, 
0, 
-1, 53.6301, 1, -1, 0.421415,-99) , 
40, 48.8489, 0, 0, 0.504915,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.16532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364151,-99) , 
75, 17.89, 0, 0, 0.685764,-99) , 
NN(
0, 
0, 
-1, 72.5894, 1, -1, 0.451003,-99) , 
109, 20.9411, 1, 0, 0.490732,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.272629);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445318,-99) , 
6, 17.7985, 0, 0, 0.549154,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.743039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26116,-99) , 
80, 11.2372, 1, 0, 0.320613,-99) , 
216, 27.8989, 0, 0, 0.496686,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.2061);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250527,-99) , 
228, 58.8955, 1, 0, 0.550893,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.104758,-99) , 
211, 3.08243, 0, 0, 0.530811,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.25737);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296695,-99) , 
182, 36.2788, 0, 0, 0.570077,-99) , 
NN(
0, 
0, 
-1, 77.4416, 1, -1, 0.301884,-99) , 
23, 13.6202, 0, 0, 0.543972,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.124277);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 4.43114, 1, 1, 0.530514,-99) , 
NN(
0, 
0, 
-1, 34.0094, 0, -1, 0.354884,-99) , 
249, 14.6118, 0, 0, 0.482536,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.137134);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 11.6984, 0, 1, 0.799091,-99) , 
NN(
0, 
0, 
-1, 31.375, 1, -1, 0.447363,-99) , 
29, 45.506, 0, 0, 0.469488,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.265439);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345676,-99) , 
70, 43.7202, 0, 0, 0.506701,-99) , 
NN(
0, 
0, 
-1, 84.0136, 1, -1, 0.237343,-99) , 
65, 46.2834, 1, 0, 0.458259,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.171708);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877135,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463697,-99) , 
212, 51.7493, 0, 0, 0.766647,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.245398,-99) , 
12, 6.66843, 0, 0, 0.473888,-99) , 
231, 59.4576, 0, 0, 0.508722,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.241742);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.715721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262415,-99) , 
14, -0.810502, 0, 0, 0.654192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273984,-99) , 
148, 66.4472, 1, 0, 0.436229,-99) , 
199, 62.5314, 0, 0, 0.508196,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.239538);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.267518,-99) , 
232, 42.2477, 0, 0, 0.582322,-99) , 
NN(
0, 
0, 
-1, 22.3523, 0, -1, 0.406285,-99) , 
216, 53.1526, 0, 0, 0.459355,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.238931);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461797,-99) , 
161, 32.542, 1, 0, 0.558736,-99) , 
NN(
0, 
0, 
-1, 87.9303, 1, -1, 0.364186,-99) , 
240, 7.73134, 0, 0, 0.471445,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.116021);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.882152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45684,-99) , 
160, 36.3668, 0, 0, 0.758189,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518066,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219794,-99) , 
25, 11.8079, 0, 0, 0.498302,-99) , 
141, 16.7295, 1, 0, 0.521696,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.163625);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 5.96839, 1, 1, 0.879461,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765471,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453174,-99) , 
137, 51.843, 1, 0, 0.476948,-99) , 
248, 57.9622, 0, 0, 0.499393,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.112544);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.948895,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470581,-99) , 
136, 75.9572, 0, 0, 0.778648,-99) , 
NN(
0, 
0, 
-1, 1.55066, 0, -1, 0.46827,-99) , 
249, 53.2513, 0, 0, 0.496434,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.13547);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 66.5653, 1, 1, 0.554646,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.111056,-99) , 
57, 18.9289, 0, 0, 0.537824,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.211937);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488167,-99) , 
25, 43.3554, 0, 0, 0.53573,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.818575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226185,-99) , 
249, 4.32676, 1, 0, 0.330471,-99) , 
249, 11.4736, 0, 0, 0.490877,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.253939);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193598,-99) , 
184, 33.4626, 0, 0, 0.586265,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197556,-99) , 
32, 12.0211, 1, 0, 0.386716,-99) , 
94, 32.1451, 1, 0, 0.51502,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.280162);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638072,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214659,-99) , 
145, 68.5652, 1, 0, 0.602457,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704042,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382259,-99) , 
130, 19.0818, 1, 0, 0.427813,-99) , 
137, 66.6637, 1, 0, 0.483773,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.279835);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 42.2531, 0, 1, 0.683852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628306,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377421,-99) , 
72, 76.6646, 0, 0, 0.443751,-99) , 
251, 35.1728, 0, 0, 0.493101,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.16304);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.941776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28272,-99) , 
57, 21.292, 0, 0, 0.750401,-99) , 
NN(
0, 
0, 
-1, 47.9457, 1, -1, 0.452014,-99) , 
246, 52.5443, 0, 0, 0.481815,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.231545);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495118,-99) , 
166, 84.9801, 1, 0, 0.669811,-99) , 
NN(
0, 
0, 
-1, 47.2381, 1, -1, 0.434511,-99) , 
109, 33.3836, 1, 0, 0.540149,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.208377);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.275817,-99) , 
67, 69.005, 1, 0, 0.526682,-99) , 
NN(
0, 
0, 
-1, 20.9595, 1, -1, 0.135935,-99) , 
45, 55.9616, 1, 0, 0.500464,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.257849);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 4.86302, 1, 1, 0.60311,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.285771,-99) , 
9, 49.6785, 0, 0, 0.368574,-99) , 
198, 37.9551, 0, 0, 0.533142,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.21031);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4128,-99) , 
57, 39.0458, 0, 0, 0.540152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507226,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0796995,-99) , 
1, 4.36784, 1, 0, 0.239057,-99) , 
143, 52.4442, 1, 0, 0.516809,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.260271);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428519,-99) , 
74, 48.9576, 0, 0, 0.514718,-99) , 
NN(
0, 
0, 
-1, 11.7445, 1, -1, 0.303746,-99) , 
60, 45.5432, 1, 0, 0.453458,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.317955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479083,-99) , 
217, 30.4706, 0, 0, 0.61906,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351242,-99) , 
129, 11.2549, 1, 0, 0.425028,-99) , 
143, 24.1945, 1, 0, 0.534983,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.231008);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773349,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499328,-99) , 
119, 82.544, 0, 0, 0.580908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303186,-99) , 
52, 68.1454, 0, 0, 0.398497,-99) , 
152, 65.4605, 0, 0, 0.530598,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.206182);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.874672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487808,-99) , 
159, 47.9911, 1, 0, 0.741318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555015,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19497,-99) , 
72, 32.9808, 0, 0, 0.532029,-99) , 
80, 8.63921, 1, 0, 0.567949,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.176821);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813281,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327438,-99) , 
114, 65.7196, 1, 0, 0.737439,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260116,-99) , 
57, 75.5142, 1, 0, 0.485795,-99) , 
213, 62.7835, 0, 0, 0.528048,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.167666);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.909929,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370829,-99) , 
43, 18.1601, 0, 0, 0.708333,-99) , 
NN(
0, 
0, 
-1, 77.1059, 1, -1, 0.441538,-99) , 
125, 18.5982, 1, 0, 0.468159,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.227808);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657188,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32861,-99) , 
219, 17.7425, 0, 0, 0.601838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.283574,-99) , 
243, 17.3543, 0, 0, 0.420284,-99) , 
225, 9.84208, 1, 0, 0.487258,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.293654);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.654469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.1685,-99) , 
80, 27.1745, 1, 0, 0.615262,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28143,-99) , 
169, 60.2255, 1, 0, 0.380852,-99) , 
145, 27.4804, 1, 0, 0.477546,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.217484);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.842186,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531473,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36794,-99) , 
4, 26.6413, 0, 0, 0.42357,-99) , 
102, 45.7203, 1, 0, 0.439359,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.146776);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 36.4267, 1, 1, 0.727945,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.19431,-99) , 
10, 10.7892, 0, 0, 0.475348,-99) , 
213, 64.6013, 0, 0, 0.507423,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.24402);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570169,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.384186,-99) , 
189, 27.7136, 1, 0, 0.448867,-99) , 
NN(
0, 
0, 
-1, 77.5821, 0, -1, 0.128315,-99) , 
65, 60.0948, 1, 0, 0.425623,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.183104);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.884483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392356,-99) , 
195, 57.4637, 1, 0, 0.631701,-99) , 
NN(
0, 
0, 
-1, 20.8017, 0, -1, 0.438919,-99) , 
213, 62.5311, 0, 0, 0.470262,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.163439);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 7.23634, 0, 1, 0.836655,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.75293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470683,-99) , 
128, 7.54098, 1, 0, 0.502304,-99) , 
213, 72.3637, 0, 0, 0.533846,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.227927);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66325,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357371,-99) , 
2, 0.515811, 0, 0, 0.611832,-99) , 
NN(
0, 
0, 
-1, 47.2572, 1, -1, 0.412486,-99) , 
233, 39.128, 0, 0, 0.48011,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.145255);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 23.082, 0, 1, 0.60982,-99) , 
NN(
0, 
0, 
-1, 17.6363, 0, -1, 0.46032,-99) , 
72, 66.4138, 0, 0, 0.529466,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.213845);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 40.6555, 1, 1, 0.641043,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345113,-99) , 
111, 19.1536, 1, 0, 0.445118,-99) , 
112, 11.3176, 1, 0, 0.486767,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.252621);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.653129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451916,-99) , 
242, 15.019, 1, 0, 0.564046,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.157124,-99) , 
208, 2.89853, 1, 0, 0.261306,-99) , 
231, 15.0784, 0, 0, 0.530882,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.31162);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400372,-99) , 
175, 37.909, 1, 0, 0.620602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.28553,-99) , 
133, 73.7232, 0, 0, 0.438776,-99) , 
83, 49.315, 1, 0, 0.539539,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.254733);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443898,-99) , 
126, 31.9877, 1, 0, 0.54806,-99) , 
NN(
0, 
0, 
-1, 41.782, 1, -1, 0.351162,-99) , 
128, 35.0683, 1, 0, 0.49714,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.129326);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783252,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488896,-99) , 
202, 76.8809, 0, 0, 0.516957,-99) , 
NN(
0, 
0, 
-1, 19.257, 0, -1, 0.135652,-99) , 
17, 39.8861, 1, 0, 0.485202,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.208642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342432,-99) , 
200, 34.0351, 0, 0, 0.527926,-99) , 
NN(
0, 
0, 
-1, 32.6432, 0, -1, 0.27156,-99) , 
240, 23.6219, 1, 0, 0.501836,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.244941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.804785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440175,-99) , 
168, 55.518, 0, 0, 0.631525,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.680805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420413,-99) , 
163, 25.3774, 1, 0, 0.46164,-99) , 
169, 52.3056, 1, 0, 0.506444,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.303971);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.717254,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446256,-99) , 
126, 51.1982, 1, 0, 0.638993,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.731789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406156,-99) , 
252, 1.55737, 1, 0, 0.464568,-99) , 
222, 15.1365, 0, 0, 0.562494,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.248962);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.741179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443318,-99) , 
161, 57.4646, 1, 0, 0.668772,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.589699,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409423,-99) , 
174, 25.9889, 1, 0, 0.484089,-99) , 
121, 65.7399, 1, 0, 0.53936,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.215136);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.939683,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492483,-99) , 
161, 59.0353, 1, 0, 0.807443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451656,-99) , 
130, 24.6565, 1, 0, 0.502699,-99) , 
210, 49.9593, 0, 0, 0.539929,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.164522);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 5.97955, 1, 1, 0.72935,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.722718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459845,-99) , 
229, 56.4637, 0, 0, 0.489072,-99) , 
192, 3.70551, 1, 0, 0.519052,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.208296);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.958987,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487221,-99) , 
119, 72.9239, 0, 0, 0.82097,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458495,-99) , 
160, 15.2002, 1, 0, 0.528819,-99) , 
109, 13.6046, 1, 0, 0.554863,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.3418);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316738,-99) , 
101, 93.225, 1, 0, 0.625494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146228,-99) , 
214, 69.5848, 0, 0, 0.358579,-99) , 
7, 8.45681, 0, 0, 0.590999,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.223763);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 16.5519, 0, 1, 0.590109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258753,-99) , 
243, 13.2752, 0, 0, 0.424306,-99) , 
252, 11.0651, 0, 0, 0.532934,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.187922);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 46.0914, 0, 1, 0.7673,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.348561,-99) , 
32, 14.678, 1, 0, 0.464838,-99) , 
142, 10.4612, 1, 0, 0.487946,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.225555);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324814,-99) , 
233, 13.3701, 0, 0, 0.547538,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.651692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214304,-99) , 
123, 79.6017, 0, 0, 0.341953,-99) , 
2, 3.25178, 0, 0, 0.520449,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.207794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580881,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415534,-99) , 
83, 56.0462, 1, 0, 0.523957,-99) , 
NN(
0, 
0, 
-1, 42.2941, 1, -1, 0.226278,-99) , 
86, 42.1556, 0, 0, 0.492401,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.200913);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.947481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375405,-99) , 
164, 90.9919, 1, 0, 0.761737,-99) , 
NN(
0, 
0, 
-1, 27.7837, 1, -1, 0.421603,-99) , 
91, 24.4198, 1, 0, 0.448285,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.24489);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.669924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.334187,-99) , 
45, 47.5685, 1, 0, 0.611623,-99) , 
NN(
0, 
0, 
-1, 23.1341, 0, -1, 0.422315,-99) , 
167, 68.3923, 1, 0, 0.509951,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.274462);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674141,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468338,-99) , 
54, 44.4172, 0, 0, 0.565898,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.643103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.294154,-99) , 
72, 88.0888, 0, 0, 0.362487,-99) , 
244, 13.7897, 0, 0, 0.491131,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.203142);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 11.4901, 0, 1, 0.844248,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357503,-99) , 
14, 17.213, 1, 0, 0.516072,-99) , 
129, 12.1244, 1, 0, 0.537294,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.243377);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 19.3068, 0, 1, 0.655777,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368559,-99) , 
231, 40.463, 0, 0, 0.480433,-99) , 
39, 54.9178, 0, 0, 0.535723,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.204605);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 52.9304, 1, 1, 0.711523,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433967,-99) , 
129, 11.3475, 1, 0, 0.467969,-99) , 
125, 19.8337, 1, 0, 0.498576,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.172971);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 33.3032, 0, 1, 0.555448,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.705491,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289896,-99) , 
129, 13.6795, 1, 0, 0.369024,-99) , 
20, 13.3932, 0, 0, 0.518854,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.119368);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.85816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483871,-99) , 
139, 30.2898, 1, 0, 0.507688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0436981,-99) , 
190, 3.92389, 0, 0, 0.483835,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.22525);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393024,-99) , 
197, 37.141, 0, 0, 0.524984,-99) , 
NN(
0, 
0, 
-1, 77.402, 1, -1, 0.228693,-99) , 
23, 12.9439, 0, 0, 0.497984,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.220314);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425837,-99) , 
103, 72.438, 1, 0, 0.514133,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.069728,-99) , 
248, 39.2201, 0, 0, 0.243032,-99) , 
158, 58.6799, 1, 0, 0.489741,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.213585);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.790831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497314,-99) , 
233, 36.524, 0, 0, 0.56879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64001,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.358863,-99) , 
143, 10.8496, 1, 0, 0.424191,-99) , 
26, 26.508, 0, 0, 0.500033,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.179163);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.917554,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.153044,-99) , 
159, 49.7978, 1, 0, 0.517043,-99) , 
66, 9.18176, 1, 0, 0.536761,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.245522);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 61.0937, 0, 1, 0.642477,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507515,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.282213,-99) , 
53, 56.2401, 0, 0, 0.400833,-99) , 
86, 61.3407, 1, 0, 0.491442,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.170193);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.150995,-99) , 
241, -3.75254, 0, 0, 0.5077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.60363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.229267,-99) , 
102, 91.6612, 0, 0, 0.303012,-99) , 
86, 82.939, 1, 0, 0.468626,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.163364);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541007,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.101391,-99) , 
150, 97.438, 1, 0, 0.524843,-99) , 
NN(
0, 
0, 
-1, 52.038, 1, -1, 0.279932,-99) , 
112, 46.1082, 1, 0, 0.485271,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.189313);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 75.6703, 1, 1, 0.704956,-99) , 
NN(
0, 
0, 
-1, 27.142, 0, -1, 0.423318,-99) , 
211, 12.0288, 1, 0, 0.460335,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.191808);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456015,-99) , 
220, 25.6048, 0, 0, 0.544225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.12557,-99) , 
127, 55.0389, 1, 0, 0.52958,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.162532);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.862041,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.890897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444855,-99) , 
165, 31.1601, 1, 0, 0.460096,-99) , 
129, 71.9698, 0, 0, 0.479064,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.181701);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675532,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477235,-99) , 
121, 64.9646, 1, 0, 0.529174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.68147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.183504,-99) , 
50, 25.3252, 0, 0, 0.293673,-99) , 
6, 8.12997, 0, 0, 0.500677,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.266721);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.778954,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48169,-99) , 
185, 56.9162, 0, 0, 0.570423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325081,-99) , 
129, 15.9208, 1, 0, 0.402439,-99) , 
54, 43.5561, 0, 0, 0.496733,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.206835);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 30.0875, 1, 1, 0.618049,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.106532,-99) , 
97, 26.8679, 1, 0, 0.44861,-99) , 
142, 33.3869, 1, 0, 0.545897,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.164065);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.808917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477609,-99) , 
76, 20.8051, 0, 0, 0.673821,-99) , 
NN(
0, 
0, 
-1, 39.0915, 1, -1, 0.439138,-99) , 
126, 14.3407, 1, 0, 0.475699,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.1476);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484774,-99) , 
249, 32.4811, 0, 0, 0.528164,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504495,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.143023,-99) , 
88, 46.285, 1, 0, 0.243496,-99) , 
9, 8.15785, 0, 0, 0.498496,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.197298);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 17.6604, 1, 1, 0.666141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.201647,-99) , 
183, 56.0753, 0, 0, 0.467019,-99) , 
8, 33.5474, 0, 0, 0.536141,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.287531);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78617,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43504,-99) , 
233, 15.8655, 0, 0, 0.641609,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.704277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392401,-99) , 
214, 69.1389, 0, 0, 0.437697,-99) , 
40, 58.3919, 0, 0, 0.488469,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.287144);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801735,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493935,-99) , 
251, 11.9106, 0, 0, 0.664145,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382739,-99) , 
175, 7.12003, 1, 0, 0.42962,-99) , 
11, 28.638, 0, 0, 0.499825,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.240484);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.751977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.355843,-99) , 
63, 41.6538, 1, 0, 0.693116,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.62988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437303,-99) , 
150, 83.9705, 0, 0, 0.501103,-99) , 
194, 15.8081, 1, 0, 0.543093,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.262687);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 60.546, 0, 1, 0.623548,-99) , 
NN(
0, 
0, 
-1, 10.5753, 0, -1, 0.343839,-99) , 
9, 10.6518, 0, 0, 0.581907,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.23921);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583732,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.258182,-99) , 
31, -1.40642, 0, 0, 0.559374,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595584,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.140032,-99) , 
128, 7.73668, 1, 0, 0.315853,-99) , 
158, 52.1686, 1, 0, 0.526657,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.34976);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.64303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20231,-99) , 
251, 1.14768, 0, 0, 0.611771,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605109,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.240073,-99) , 
248, 44.4619, 0, 0, 0.396658,-99) , 
3, 12.5972, 0, 0, 0.535116,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.154407);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483707,-99) , 
109, 26.5295, 1, 0, 0.523837,-99) , 
NN(
0, 
0, 
-1, 14.3383, 0, -1, 0.342446,-99) , 
192, 27.2975, 1, 0, 0.481222,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.202695);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 28.851, 0, 1, 0.843396,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379145,-99) , 
79, 13.642, 1, 0, 0.455032,-99) , 
136, 54.6874, 1, 0, 0.476424,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.222045);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 15.0952, 0, 1, 0.875528,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388731,-99) , 
234, 34.3584, 0, 0, 0.456685,-99) , 
129, 9.39712, 1, 0, 0.480166,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.284107);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35619,-99) , 
159, 45.8334, 1, 0, 0.625055,-99) , 
NN(
0, 
0, 
-1, 29.798, 0, -1, 0.402042,-99) , 
147, 53.941, 1, 0, 0.519455,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.285599);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497057,-99) , 
235, 24.8771, 0, 0, 0.59453,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.868148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.326126,-99) , 
100, 29.3987, 1, 0, 0.408515,-99) , 
18, 13.0814, 0, 0, 0.522528,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.190053);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 15.1295, 1, 1, 0.546423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.689673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.219555,-99) , 
22, 10.5172, 1, 0, 0.301894,-99) , 
8, 13.4076, 0, 0, 0.493199,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.156747);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528084,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318459,-99) , 
160, 38.8491, 1, 0, 0.488458,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0607045,-99) , 
75, 91.7154, 1, 0, 0.465352,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.214998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.690941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3385,-99) , 
227, 25.0605, 1, 0, 0.630501,-99) , 
NN(
0, 
0, 
-1, 75.1517, 1, -1, 0.434322,-99) , 
193, 16.4607, 1, 0, 0.499916,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.287004);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.259175,-99) , 
11, 2.87355, 0, 0, 0.637104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.851204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395637,-99) , 
127, 5.32041, 1, 0, 0.421212,-99) , 
165, 75.7095, 0, 0, 0.473489,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.192545);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.8053,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486368,-99) , 
96, 49.7019, 1, 0, 0.691644,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226863,-99) , 
161, 39.5889, 1, 0, 0.464449,-99) , 
123, 41.8007, 1, 0, 0.515767,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.266216);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 21.1132, 1, 1, 0.578487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.811018,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328567,-99) , 
114, 14.9882, 1, 0, 0.373467,-99) , 
142, 30.5984, 1, 0, 0.478696,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.160681);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.906353,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523145,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319487,-99) , 
0, 13.8267, 1, 0, 0.470231,-99) , 
165, 31.0385, 1, 0, 0.490137,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.197702);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 60.1884, 1, 1, 0.669142,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.311339,-99) , 
142, 32.8614, 1, 0, 0.460985,-99) , 
81, 13.8683, 1, 0, 0.508881,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.227426);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.742045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484991,-99) , 
240, 12.0744, 0, 0, 0.538946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660553,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197297,-99) , 
229, 51.1348, 0, 0, 0.337023,-99) , 
192, 25.9727, 1, 0, 0.488631,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.127302);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.947274,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484891,-99) , 
87, 74.1266, 1, 0, 0.795841,-99) , 
NN(
0, 
0, 
-1, 28.8703, 1, -1, 0.468181,-99) , 
91, 80.866, 0, 0, 0.505849,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.159995);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.673363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464294,-99) , 
136, 66.3604, 1, 0, 0.508354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161605,-99) , 
212, 9.98867, 0, 0, 0.48985,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.170537);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 37.9387, 0, 1, 0.569907,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523956,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.104597,-99) , 
250, 38.3151, 0, 0, 0.308248,-99) , 
7, 8.45681, 0, 0, 0.54368,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.209647);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 32.535, 1, 1, 0.63801,-99) , 
NN(
0, 
0, 
-1, 25.6519, 1, -1, 0.407093,-99) , 
112, 13.496, 1, 0, 0.460379,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.217074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.915759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342815,-99) , 
177, 57.5763, 1, 0, 0.762405,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43954,-99) , 
148, 40.6618, 1, 0, 0.481339,-99) , 
109, 15.937, 1, 0, 0.511825,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.310493);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.664409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.398141,-99) , 
193, 39.7258, 1, 0, 0.571805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.256311,-99) , 
80, 11.383, 1, 0, 0.373093,-99) , 
126, 30.7792, 1, 0, 0.470361,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.195933);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 62.9332, 0, 1, 0.559239,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.780633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.35325,-99) , 
91, 20.9105, 1, 0, 0.384002,-99) , 
26, 23.2835, 0, 0, 0.491606,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.206847);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.913032,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585973,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420428,-99) , 
208, 16.8436, 1, 0, 0.52823,-99) , 
69, 92.8178, 0, 0, 0.549536,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.266867);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.644108,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451504,-99) , 
191, 9.52886, 0, 0, 0.582611,-99) , 
NN(
0, 
0, 
-1, 16.0898, 1, -1, 0.309801,-99) , 
140, 73.3113, 1, 0, 0.522886,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.276259);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579275,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.17148,-99) , 
106, 37.8515, 0, 0, 0.543788,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.70999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320199,-99) , 
146, 17.7912, 1, 0, 0.386114,-99) , 
47, 14.6137, 1, 0, 0.480384,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.0938886);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.878685,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.109865,-99) , 
63, -0.339125, 0, 0, 0.491399,-99) , 
111, 1.31444, 1, 0, 0.508996,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.271222);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.415656,-99) , 
188, 32.3703, 1, 0, 0.690016,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381859,-99) , 
216, 53.3757, 0, 0, 0.448552,-99) , 
126, 17.1069, 1, 0, 0.493069,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.261437);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61296,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41834,-99) , 
6, 17.3316, 0, 0, 0.531606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574283,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.128105,-99) , 
56, 76.9313, 0, 0, 0.27795,-99) , 
200, 31.9586, 0, 0, 0.490413,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.24388);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.634524,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176783,-99) , 
47, 39.5078, 1, 0, 0.585768,-99) , 
NN(
0, 
0, 
-1, 20.0094, 0, -1, 0.40368,-99) , 
193, 18.1966, 1, 0, 0.47632,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.302034);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269798,-99) , 
31, 8.96274, 1, 0, 0.6235,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361377,-99) , 
35, 19.4248, 1, 0, 0.432702,-99) , 
242, 21.5985, 0, 0, 0.483948,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.141854);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 51.9982, 0, 1, 0.558183,-99) , 
NN(
0, 
0, 
-1, 7.99874, 0, -1, 0.217869,-99) , 
215, 15.3809, 0, 0, 0.539535,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.299537);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417531,-99) , 
144, 36.9061, 1, 0, 0.547834,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.638878,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.252216,-99) , 
128, 4.25694, 1, 0, 0.310226,-99) , 
141, 52.0478, 1, 0, 0.472239,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.28031);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.586481,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.145526,-99) , 
193, 3.43671, 0, 0, 0.5495,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0997015,-99) , 
30, 9.47995, 0, 0, 0.226881,-99) , 
38, 18.4122, 0, 0, 0.505223,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.223109);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88932,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387134,-99) , 
46, 11.4705, 1, 0, 0.764176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.771345,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428831,-99) , 
120, 97.1458, 0, 0, 0.448989,-99) , 
141, 18.3625, 1, 0, 0.484544,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.213256);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488073,-99) , 
252, 18.0605, 0, 0, 0.56412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.764672,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.325362,-99) , 
179, 24.6918, 1, 0, 0.381981,-99) , 
185, 73.6355, 1, 0, 0.520166,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.217952);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465903,-99) , 
198, 49.5289, 0, 0, 0.550076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0701109,-99) , 
85, 45.7856, 1, 0, 0.203131,-99) , 
7, 5.77778, 0, 0, 0.517281,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.34881);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.645605,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.13803,-99) , 
215, 14.0196, 0, 0, 0.608451,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613267,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.307951,-99) , 
175, 14.1535, 1, 0, 0.379104,-99) , 
22, 29.7953, 0, 0, 0.49201,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.219435);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.773144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437533,-99) , 
100, 79.1233, 1, 0, 0.618749,-99) , 
NN(
0, 
0, 
-1, 39.5361, 1, -1, 0.41685,-99) , 
189, 20.2253, 1, 0, 0.470735,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.251844);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435334,-99) , 
26, 17.8728, 0, 0, 0.645139,-99) , 
NN(
0, 
0, 
-1, 24.1674, 1, -1, 0.412741,-99) , 
64, 14.761, 1, 0, 0.510038,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.294962);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.161676,-99) , 
110, 59.4636, 1, 0, 0.594722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.324469,-99) , 
172, 67.6737, 0, 0, 0.38335,-99) , 
244, 15.1323, 0, 0, 0.522663,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.214918);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 25.5696, 1, 1, 0.810881,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563118,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.368625,-99) , 
175, 21.203, 1, 0, 0.475451,-99) , 
67, 13.6187, 1, 0, 0.493922,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.199215);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 88.8579, 1, 1, 0.821688,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709666,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43452,-99) , 
131, 27.9161, 1, 0, 0.465432,-99) , 
66, 70.8165, 0, 0, 0.490118,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.257579);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 27.9177, 1, 1, 0.789746,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403728,-99) , 
167, 71.9152, 0, 0, 0.507529,-99) , 
25, 56.8209, 0, 0, 0.545128,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.260534);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.296279,-99) , 
250, 6.85385, 0, 0, 0.697005,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.758565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431475,-99) , 
126, 10.1948, 1, 0, 0.460267,-99) , 
41, 59.1013, 0, 0, 0.509414,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.248731);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 49.3225, 1, 1, 0.600403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330014,-99) , 
249, 47.5622, 0, 0, 0.417263,-99) , 
25, 25.4354, 0, 0, 0.533612,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.283648);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421892,-99) , 
144, 49.8398, 1, 0, 0.712252,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353812,-99) , 
10, 21.6682, 0, 0, 0.468815,-99) , 
121, 62.0295, 1, 0, 0.523833,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.261512);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.726742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317941,-99) , 
156, 89.3828, 1, 0, 0.675721,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.29994,-99) , 
127, 23.6952, 1, 0, 0.466607,-99) , 
128, 15.1657, 1, 0, 0.526994,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.191052);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.895987,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556152,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397327,-99) , 
231, 39.9495, 0, 0, 0.46112,-99) , 
129, 5.64071, 1, 0, 0.475606,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.19601);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.671416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469136,-99) , 
68, 58.0654, 0, 0, 0.527705,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572817,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.130938,-99) , 
165, 84.1759, 0, 0, 0.281168,-99) , 
131, 79.1529, 1, 0, 0.496124,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.17508);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.772905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480222,-99) , 
197, 67.7778, 0, 0, 0.523684,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536012,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.106165,-99) , 
219, 40.9639, 0, 0, 0.285247,-99) , 
57, 28.7407, 0, 0, 0.486416,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.200475);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.279202,-99) , 
21, 9.62005, 0, 0, 0.539067,-99) , 
NN(
0, 
0, 
-1, 5.93735, 1, -1, 0.214534,-99) , 
198, 24.1644, 0, 0, 0.518778,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.181415);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350748,-99) , 
160, 41.7153, 1, 0, 0.523838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.197661,-99) , 
212, 9.33, 0, 0, 0.506444,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.134416);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 23.1592, 0, 1, 0.845611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.837604,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465721,-99) , 
125, 14.0554, 1, 0, 0.485751,-99) , 
108, 84.171, 0, 0, 0.5055,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.240094);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579324,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.159758,-99) , 
89, 95.1095, 1, 0, 0.556379,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581033,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.203232,-99) , 
246, 49.5006, 0, 0, 0.283449,-99) , 
12, 6.15831, 0, 0, 0.51441,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.127722);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.801873,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474991,-99) , 
108, 23.1656, 1, 0, 0.498374,-99) , 
NN(
0, 
0, 
-1, 70.2024, 0, -1, 0.198502,-99) , 
37, 71.8289, 1, 0, 0.476524,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.359455);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.628858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.184461,-99) , 
146, 67.1655, 1, 0, 0.588599,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.306418,-99) , 
154, 44.2568, 1, 0, 0.407491,-99) , 
236, 19.1408, 0, 0, 0.501347,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.237422);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 37.2886, 1, 1, 0.570318,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.24631,-99) , 
175, 11.7207, 1, 0, 0.400423,-99) , 
161, 30.1108, 1, 0, 0.491302,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.225936);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.981825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437377,-99) , 
37, 33.6881, 1, 0, 0.76804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552068,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356076,-99) , 
143, 22.2177, 1, 0, 0.459467,-99) , 
129, 9.49987, 1, 0, 0.481198,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.301349);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.791916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425278,-99) , 
83, 33.5952, 1, 0, 0.475186,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641664,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.260895,-99) , 
128, 7.11945, 1, 0, 0.293562,-99) , 
70, 48.3659, 0, 0, 0.414883,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.223373);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 76.8601, 0, 1, 0.577171,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571676,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266184,-99) , 
80, 10.3584, 1, 0, 0.383653,-99) , 
154, 71.8226, 1, 0, 0.510077,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.203102);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607668,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433095,-99) , 
113, 29, 1, 0, 0.505928,-99) , 
NN(
0, 
0, 
-1, 68.5997, 1, -1, 0.165522,-99) , 
239, 32.2438, 1, 0, 0.483831,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.17877);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 23.7718, 1, 1, 0.676065,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303173,-99) , 
134, 68.5617, 0, 0, 0.463318,-99) , 
81, 15.5947, 1, 0, 0.504351,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.272731);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.78819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413553,-99) , 
145, 58.8199, 1, 0, 0.673222,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413088,-99) , 
134, 51.3643, 1, 0, 0.436998,-99) , 
149, 79.4721, 0, 0, 0.499429,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.27735);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.77475,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397723,-99) , 
247, 11.7743, 0, 0, 0.664565,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.338702,-99) , 
167, 75.8606, 0, 0, 0.432751,-99) , 
39, 54.3786, 0, 0, 0.494802,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.109253);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 35.9797, 1, 1, 0.809854,-99) , 
NN(
0, 
0, 
-1, 81.6719, 1, -1, 0.462711,-99) , 
8, 55.7749, 0, 0, 0.484517,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.157698);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 41.6368, 1, 1, 0.725805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176241,-99) , 
144, 43.6039, 1, 0, 0.482503,-99) , 
125, 18.5982, 1, 0, 0.51375,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.245647);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.66803,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369509,-99) , 
91, 46.8084, 1, 0, 0.590313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262004,-99) , 
112, 22.7698, 1, 0, 0.429956,-99) , 
133, 74.1352, 0, 0, 0.492273,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.130624);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.679492,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484136,-99) , 
144, 12.365, 1, 0, 0.524318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.146258,-99) , 
6, 4.31972, 0, 0, 0.505152,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.170495);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549531,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0656448,-99) , 
139, 95.7921, 1, 0, 0.531248,-99) , 
NN(
0, 
0, 
-1, 11.3029, 0, -1, 0.28048,-99) , 
25, 13.8932, 0, 0, 0.498404,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.185298);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.815075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318525,-99) , 
218, 45.2943, 0, 0, 0.699407,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.27284,-99) , 
193, 29.0227, 1, 0, 0.447914,-99) , 
213, 62.2818, 0, 0, 0.482857,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.19636);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 46.9935, 0, 1, 0.746324,-99) , 
NN(
0, 
0, 
-1, 28.8818, 0, -1, 0.4123,-99) , 
142, 9.59872, 1, 0, 0.431752,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.289829);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.727868,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.427771,-99) , 
79, 10.6396, 1, 0, 0.629544,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.31859,-99) , 
161, 20.8171, 1, 0, 0.421506,-99) , 
125, 27.684, 1, 0, 0.488254,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.257345);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.160994,-99) , 
185, 87.7134, 1, 0, 0.581182,-99) , 
NN(
0, 
0, 
-1, 59.589, 1, -1, 0.376158,-99) , 
77, 24.3266, 1, 0, 0.455468,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.296441);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.903679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474749,-99) , 
92, 34.3255, 0, 0, 0.618742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641266,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360544,-99) , 
144, 10.9718, 1, 0, 0.428643,-99) , 
93, 24.059, 1, 0, 0.492007,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.182973);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.826737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492458,-99) , 
221, 10.9716, 1, 0, 0.538968,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.632737,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.263276,-99) , 
241, 16.7689, 0, 0, 0.32907,-99) , 
170, 45.0214, 0, 0, 0.490328,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.340358);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 18.6809, 0, 1, 0.651146,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.34016,-99) , 
24, 57.078, 0, 0, 0.452478,-99) , 
215, 41.9343, 0, 0, 0.556517,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.273926);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.617628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371841,-99) , 
160, 37.5071, 1, 0, 0.555928,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214312,-99) , 
49, 12.4677, 1, 0, 0.383371,-99) , 
127, 32.6331, 1, 0, 0.506537,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.319167);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660399,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422645,-99) , 
192, 27.3639, 1, 0, 0.592884,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.832297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.320923,-99) , 
218, 10.1567, 1, 0, 0.37995,-99) , 
247, 16.8269, 0, 0, 0.530511,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.185574);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551243,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.244247,-99) , 
167, 93.3115, 1, 0, 0.526914,-99) , 
NN(
0, 
0, 
-1, 51.234, 0, -1, 0.209359,-99) , 
140, 78.9342, 1, 0, 0.492359,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.192135);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 62.2121, 0, 1, 0.810504,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.919061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433738,-99) , 
234, 72.1635, 0, 0, 0.450654,-99) , 
109, 13.6761, 1, 0, 0.476011,-99)    );
  // itree = 300
  fBoostWeights.push_back(0.150236);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904002,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463868,-99) , 
76, 18.1512, 0, 0, 0.74917,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512579,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289193,-99) , 
39, 25.2972, 0, 0, 0.473067,-99) , 
126, 11.7767, 1, 0, 0.505814,-99)    );
  // itree = 301
  fBoostWeights.push_back(0.318922);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672241,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.164429,-99) , 
253, 1.90637, 0, 0, 0.613558,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.783765,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.37672,-99) , 
232, 66.2395, 0, 0, 0.414827,-99) , 
12, 21.5726, 0, 0, 0.47489,-99)    );
  // itree = 302
  fBoostWeights.push_back(0.123023);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.870677,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438964,-99) , 
183, 80.592, 1, 0, 0.729142,-99) , 
NN(
0, 
0, 
-1, 60.9584, 1, -1, 0.460593,-99) , 
180, 76.7784, 0, 0, 0.486069,-99)    );
  // itree = 303
  fBoostWeights.push_back(0.209114);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 102.116, 0, 1, 0.563076,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.781739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287378,-99) , 
115, 23.458, 1, 0, 0.346651,-99) , 
224, 3.30911, 0, 0, 0.508249,-99)    );
  // itree = 304
  fBoostWeights.push_back(0.253502);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.703186,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472273,-99) , 
21, 33.5785, 0, 0, 0.58112,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.205418,-99) , 
131, 34.0154, 1, 0, 0.363483,-99) , 
126, 38.1285, 1, 0, 0.5057,-99)    );
  // itree = 305
  fBoostWeights.push_back(0.184201);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.904282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543721,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332655,-99) , 
135, 84.0653, 1, 0, 0.489685,-99) , 
127, 2.30652, 1, 0, 0.509477,-99)    );
  // itree = 306
  fBoostWeights.push_back(0.235748);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437734,-99) , 
167, 85.1613, 1, 0, 0.616263,-99) , 
NN(
0, 
0, 
-1, 22.4437, 0, -1, 0.417052,-99) , 
196, 42.5403, 0, 0, 0.51015,-99)    );
  // itree = 307
  fBoostWeights.push_back(0.201553);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71452,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295356,-99) , 
141, 37.1876, 1, 0, 0.642642,-99) , 
NN(
0, 
0, 
-1, 41.5687, 1, -1, 0.436596,-99) , 
195, 50.204, 0, 0, 0.486279,-99)    );
  // itree = 308
  fBoostWeights.push_back(0.19681);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.750941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481484,-99) , 
234, 31.9679, 0, 0, 0.54753,-99) , 
NN(
0, 
0, 
-1, 45.5966, 0, -1, 0.360504,-99) , 
10, 16.5161, 0, 0, 0.484218,-99)    );
  // itree = 309
  fBoostWeights.push_back(0.269228);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0903785,-99) , 
190, 1.85022, 0, 0, 0.574109,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69984,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.253569,-99) , 
115, 52.6231, 0, 0, 0.341743,-99) , 
137, 86.0424, 1, 0, 0.53324,-99)    );
  // itree = 310
  fBoostWeights.push_back(0.201747);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 31.9005, 0, 1, 0.568443,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.668488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.200861,-99) , 
105, 86.6614, 0, 0, 0.349605,-99) , 
199, 32.3519, 0, 0, 0.532479,-99)    );
  // itree = 311
  fBoostWeights.push_back(0.242815);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.167933,-99) , 
219, 9.68343, 0, 0, 0.55522,-99) , 
NN(
0, 
0, 
-1, 29.7337, 0, -1, 0.385658,-99) , 
23, 30.0407, 0, 0, 0.47798,-99)    );
  // itree = 312
  fBoostWeights.push_back(0.269443);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.834812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472977,-99) , 
38, 23.9245, 0, 0, 0.685782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.319063,-99) , 
8, 25.2266, 0, 0, 0.444183,-99) , 
213, 54.7284, 0, 0, 0.49469,-99)    );
  // itree = 313
  fBoostWeights.push_back(0.284102);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.807548,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463234,-99) , 
158, 30.7707, 1, 0, 0.547276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549686,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287771,-99) , 
125, 21.2414, 1, 0, 0.356581,-99) , 
65, 23.1894, 1, 0, 0.445762,-99)    );
  // itree = 314
  fBoostWeights.push_back(0.271835);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612562,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405245,-99) , 
14, 3.89927, 0, 0, 0.570646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.133827,-99) , 
53, 85.0877, 0, 0, 0.225064,-99) , 
233, 14.6081, 0, 0, 0.526236,-99)    );
  // itree = 315
  fBoostWeights.push_back(0.256326);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.813963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479519,-99) , 
101, 62.3348, 0, 0, 0.596122,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560647,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350786,-99) , 
254, 12.0963, 0, 0, 0.403968,-99) , 
234, 34.7652, 0, 0, 0.468974,-99)    );
  // itree = 316
  fBoostWeights.push_back(0.319583);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.646864,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317631,-99) , 
21, 10.578, 0, 0, 0.595996,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.71834,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351116,-99) , 
252, 1.59188, 1, 0, 0.401609,-99) , 
185, 50.5198, 0, 0, 0.525231,-99)    );
  // itree = 317
  fBoostWeights.push_back(0.22294);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459223,-99) , 
187, 58.5752, 0, 0, 0.520367,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581566,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0960734,-99) , 
124, 71.0167, 1, 0, 0.231824,-99) , 
159, 45.6353, 1, 0, 0.486885,-99)    );
  // itree = 318
  fBoostWeights.push_back(0.168257);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.74712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476204,-99) , 
222, 6.53042, 1, 0, 0.522805,-99) , 
NN(
0, 
0, 
-1, 18.1217, 1, -1, 0.150676,-99) , 
182, 31.8428, 0, 0, 0.495414,-99)    );
  // itree = 319
  fBoostWeights.push_back(0.0800377);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 49.0213, 1, 1, 0.792994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.135629,-99) , 
61, 69.5055, 1, 0, 0.48539,-99) , 
153, 91.1889, 0, 0, 0.51249,-99)    );
  // itree = 320
  fBoostWeights.push_back(0.157908);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 41.2809, 1, 1, 0.70026,-99) , 
NN(
0, 
0, 
-1, 87.9045, 1, -1, 0.446133,-99) , 
248, 45.1926, 0, 0, 0.488555,-99)    );
  // itree = 321
  fBoostWeights.push_back(0.321451);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.69621,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409367,-99) , 
223, 4.32114, 0, 0, 0.627575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.875184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38504,-99) , 
85, 27.4836, 1, 0, 0.425924,-99) , 
170, 63.2949, 1, 0, 0.536176,-99)    );
  // itree = 322
  fBoostWeights.push_back(0.307972);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.225563,-99) , 
104, 94.1127, 1, 0, 0.581463,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.776429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.220507,-99) , 
153, 90.1669, 0, 0, 0.327641,-99) , 
22, 17.1623, 0, 0, 0.540398,-99)    );
  // itree = 323
  fBoostWeights.push_back(0.190842);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 30.279, 1, 1, 0.631505,-99) , 
NN(
0, 
0, 
-1, 32.7599, 0, -1, 0.433617,-99) , 
196, 42.5403, 0, 0, 0.518387,-99)    );
  // itree = 324
  fBoostWeights.push_back(0.104789);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.932978,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0666412,-99) , 
160, 55.7314, 1, 0, 0.509531,-99) , 
148, 26.8427, 1, 0, 0.526444,-99)    );
  // itree = 325
  fBoostWeights.push_back(0.29749);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594719,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0,-99) , 
215, 14.0735, 0, 0, 0.571711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.662546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.262863,-99) , 
247, 58.4015, 0, 0, 0.309007,-99) , 
209, 26.031, 1, 0, 0.495856,-99)    );
  // itree = 326
  fBoostWeights.push_back(0.179149);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.681136,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450018,-99) , 
143, 9.48756, 1, 0, 0.491971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0565473,-99) , 
249, 3.49079, 0, 0, 0.474493,-99)    );
  // itree = 327
  fBoostWeights.push_back(0.0849088);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.875812,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495777,-99) , 
181, 26.0688, 1, 0, 0.515245,-99) , 
NN(
0, 
0, 
-1, 88.1877, 1, -1, 0.192532,-99) , 
111, 54.8887, 1, 0, 0.493565,-99)    );
  // itree = 328
  fBoostWeights.push_back(0.197797);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.720711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.345493,-99) , 
119, 72.0077, 0, 0, 0.630229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.273859,-99) , 
9, 11.8605, 0, 0, 0.469303,-99) , 
134, 81.5666, 0, 0, 0.521663,-99)    );
  // itree = 329
  fBoostWeights.push_back(0.320147);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 70.8726, 0, 1, 0.624467,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.224807,-99) , 
221, 21.1377, 0, 0, 0.346387,-99) , 
215, 26.4322, 0, 0, 0.560532,-99)    );
  // itree = 330
  fBoostWeights.push_back(0.0998351);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.827074,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51017,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.271032,-99) , 
111, 42.5072, 1, 0, 0.480646,-99) , 
33, 0.295275, 1, 0, 0.495667,-99)    );
  // itree = 331
  fBoostWeights.push_back(0.311719);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.151142,-99) , 
118, 58.7397, 0, 0, 0.62324,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36153,-99) , 
120, 90.618, 0, 0, 0.392022,-99) , 
245, 32.8331, 0, 0, 0.445487,-99)    );
  // itree = 332
  fBoostWeights.push_back(0.313077);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.694545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381197,-99) , 
141, 64.0745, 1, 0, 0.579472,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.883036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374008,-99) , 
153, 41.9267, 1, 0, 0.403338,-99) , 
128, 22.4453, 1, 0, 0.476804,-99)    );
  // itree = 333
  fBoostWeights.push_back(0.272882);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6483,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423896,-99) , 
143, 25.4699, 1, 0, 0.534236,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.18738,-99) , 
242, 21.4926, 0, 0, 0.290229,-99) , 
97, 56.1395, 1, 0, 0.497599,-99)    );
  // itree = 334
  fBoostWeights.push_back(0.187626);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.81894,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.674896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440642,-99) , 
64, 7.78198, 1, 0, 0.484209,-99) , 
5, 52.5718, 0, 0, 0.500913,-99)    );
  // itree = 335
  fBoostWeights.push_back(0.28172);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 45.5006, 0, 1, 0.615325,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.821547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365626,-99) , 
91, 24.5036, 1, 0, 0.408304,-99) , 
10, 26.0099, 0, 0, 0.491217,-99)    );
  // itree = 336
  fBoostWeights.push_back(0.209941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.59507,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429407,-99) , 
94, 30.1086, 1, 0, 0.520962,-99) , 
NN(
0, 
0, 
-1, 12.8184, 0, -1, 0.155977,-99) , 
97, 66.4248, 1, 0, 0.493809,-99)    );
  // itree = 337
  fBoostWeights.push_back(0.162066);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.93282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.695744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465235,-99) , 
123, 41.6301, 1, 0, 0.508045,-99) , 
80, -0.260815, 1, 0, 0.526124,-99)    );
  // itree = 338
  fBoostWeights.push_back(0.251298);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.806992,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401745,-99) , 
103, 57.7007, 0, 0, 0.702722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.670842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418362,-99) , 
120, 89.6, 0, 0, 0.453156,-99) , 
169, 82.9782, 0, 0, 0.49879,-99)    );
  // itree = 339
  fBoostWeights.push_back(0.306596);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.691633,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414647,-99) , 
205, 52.8552, 1, 0, 0.627132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.707652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38361,-99) , 
186, 31.0433, 1, 0, 0.451351,-99) , 
83, 40.582, 1, 0, 0.52521,-99)    );
  // itree = 340
  fBoostWeights.push_back(0.35565);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.297777,-99) , 
242, 2.88848, 0, 0, 0.595397,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.6916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.214515,-99) , 
156, 26.126, 1, 0, 0.352234,-99) , 
161, 48.1789, 1, 0, 0.549678,-99)    );
  // itree = 341
  fBoostWeights.push_back(0.132841);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.942192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524877,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291603,-99) , 
8, 10.1162, 0, 0, 0.49317,-99) , 
76, 84.2962, 0, 0, 0.511723,-99)    );
  // itree = 342
  fBoostWeights.push_back(0.175919);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552764,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.26603,-99) , 
182, 85.076, 1, 0, 0.524678,-99) , 
NN(
0, 
0, 
-1, 12.4319, 0, -1, 0.238988,-99) , 
233, 10.1664, 0, 0, 0.499858,-99)    );
  // itree = 343
  fBoostWeights.push_back(0.297531);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.733669,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.318734,-99) , 
185, 46.9079, 0, 0, 0.630009,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.633603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.389963,-99) , 
169, 51.4726, 1, 0, 0.448157,-99) , 
146, 28.2846, 1, 0, 0.498182,-99)    );
  // itree = 344
  fBoostWeights.push_back(0.254292);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 22.8002, 0, 1, 0.592712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.843688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.360605,-99) , 
54, 89.0225, 0, 0, 0.402808,-99) , 
233, 30.6111, 0, 0, 0.49924,-99)    );
  // itree = 345
  fBoostWeights.push_back(0.267612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.289075,-99) , 
57, 23.4523, 0, 0, 0.58851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516755,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.176178,-99) , 
162, 29.0943, 1, 0, 0.396468,-99) , 
47, 16.0236, 1, 0, 0.51901,-99)    );
  // itree = 346
  fBoostWeights.push_back(0.273607);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404485,-99) , 
56, 58.7153, 0, 0, 0.47423,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601294,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.106388,-99) , 
95, 41.9782, 1, 0, 0.209477,-99) , 
111, 48.5655, 1, 0, 0.439853,-99)    );
  // itree = 347
  fBoostWeights.push_back(0.317485);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.685511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.286008,-99) , 
143, 55.0534, 1, 0, 0.610095,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.779953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379821,-99) , 
88, 93.9755, 0, 0, 0.413382,-99) , 
238, 18.8758, 0, 0, 0.482155,-99)    );
  // itree = 348
  fBoostWeights.push_back(0.298458);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.747805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.382833,-99) , 
7, 11.7028, 0, 0, 0.640943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.88678,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404745,-99) , 
114, 15.4847, 1, 0, 0.429311,-99) , 
226, 24.2168, 0, 0, 0.503453,-99)    );
  // itree = 349
  fBoostWeights.push_back(0.269988);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.856499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484782,-99) , 
132, 79.4428, 0, 0, 0.722642,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578323,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.365747,-99) , 
144, 12.6295, 1, 0, 0.421924,-99) , 
127, 6.87615, 1, 0, 0.454424,-99)    );
  // itree = 350
  fBoostWeights.push_back(0.168502);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.794363,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410658,-99) , 
38, 25.7131, 0, 0, 0.706674,-99) , 
NN(
0, 
0, 
-1, 21.499, 0, -1, 0.462528,-99) , 
77, 17.7887, 1, 0, 0.515988,-99)    );
  // itree = 351
  fBoostWeights.push_back(0.241089);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 8.98654, 1, 1, 0.80302,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588429,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370906,-99) , 
143, 28.2309, 1, 0, 0.525856,-99) , 
147, 23.1495, 1, 0, 0.55063,-99)    );
  // itree = 352
  fBoostWeights.push_back(0.284708);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 82.2841, 0, 1, 0.66064,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362252,-99) , 
11, 27.8667, 0, 0, 0.460903,-99) , 
167, 74.8782, 0, 0, 0.541101,-99)    );
  // itree = 353
  fBoostWeights.push_back(0.123003);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.952385,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.716233,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479485,-99) , 
141, 17.9893, 1, 0, 0.507734,-99) , 
7, 61.955, 0, 0, 0.526592,-99)    );
  // itree = 354
  fBoostWeights.push_back(0.301772);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 32.4614, 0, 1, 0.673217,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.736899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402067,-99) , 
42, 15.499, 1, 0, 0.46371,-99) , 
59, 39.7822, 0, 0, 0.560452,-99)    );
  // itree = 355
  fBoostWeights.push_back(0.273928);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.759488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.20479,-99) , 
30, -2.26993, 0, 0, 0.70138,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.693356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439565,-99) , 
81, 15.8862, 1, 0, 0.487124,-99) , 
215, 59.8964, 0, 0, 0.545292,-99)    );
  // itree = 356
  fBoostWeights.push_back(0.204687);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 75.47, 0, 1, 0.864884,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554937,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.329753,-99) , 
247, 14.9507, 0, 0, 0.506975,-99) , 
42, 70.883, 0, 0, 0.533863,-99)    );
  // itree = 357
  fBoostWeights.push_back(0.228595);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.32906,-99) , 
143, 41.9381, 1, 0, 0.52777,-99) , 
NN(
0, 
0, 
-1, 68.0552, 1, -1, 0.133459,-99) , 
112, 53.9302, 1, 0, 0.504142,-99)    );
  // itree = 358
  fBoostWeights.push_back(0.258863);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 36.708, 1, 1, 0.65748,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.753499,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403425,-99) , 
100, 31.6683, 1, 0, 0.449439,-99) , 
133, 81.9602, 0, 0, 0.498066,-99)    );
  // itree = 359
  fBoostWeights.push_back(0.246256);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.640248,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444078,-99) , 
208, 16.5185, 1, 0, 0.561266,-99) , 
NN(
0, 
0, 
-1, 21.1898, 0, -1, 0.143825,-99) , 
198, 24.2019, 0, 0, 0.537207,-99)    );
  // itree = 360
  fBoostWeights.push_back(0.352632);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.666599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.193153,-99) , 
23, 14.4036, 0, 0, 0.61956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.299611,-99) , 
80, 9.88487, 1, 0, 0.399452,-99) , 
126, 30.3907, 1, 0, 0.509959,-99)    );
  // itree = 361
  fBoostWeights.push_back(0.181347);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 10.036, 0, 1, 0.827694,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351382,-99) , 
126, 34.8036, 1, 0, 0.469429,-99) , 
95, 50.2429, 0, 0, 0.490322,-99)    );
  // itree = 362
  fBoostWeights.push_back(0.199437);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304943,-99) , 
8, 11.8607, 0, 0, 0.509353,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0483131,-99) , 
65, 68.8629, 1, 0, 0.489429,-99)    );
  // itree = 363
  fBoostWeights.push_back(0.243591);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.829414,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399788,-99) , 
15, -0.74082, 1, 0, 0.432843,-99) , 
117, 43.3641, 1, 0, 0.450712,-99)    );
  // itree = 364
  fBoostWeights.push_back(0.222802);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.944709,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.577752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356607,-99) , 
197, 36.456, 0, 0, 0.517022,-99) , 
128, 3.87806, 1, 0, 0.533956,-99)    );
  // itree = 365
  fBoostWeights.push_back(0.158856);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 73.5988, 1, 1, 0.727508,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.169478,-99) , 
80, 44.1311, 1, 0, 0.487548,-99) , 
142, 15.6462, 1, 0, 0.528883,-99)    );
  // itree = 366
  fBoostWeights.push_back(0.197289);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.76977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453528,-99) , 
244, 34.8977, 1, 0, 0.616671,-99) , 
NN(
0, 
0, 
-1, 15.4412, 1, -1, 0.432496,-99) , 
230, 42.3586, 0, 0, 0.49094,-99)    );
  // itree = 367
  fBoostWeights.push_back(0.322071);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.765867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423351,-99) , 
250, 11.7365, 0, 0, 0.609963,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.678192,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369838,-99) , 
251, 42.4055, 0, 0, 0.417143,-99) , 
6, 26.7311, 0, 0, 0.500096,-99)    );
  // itree = 368
  fBoostWeights.push_back(0.265399);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.732505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483686,-99) , 
65, 22.432, 1, 0, 0.546927,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.766529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.276264,-99) , 
145, 6.91344, 1, 0, 0.317575,-99) , 
126, 35.7756, 1, 0, 0.461101,-99)    );
  // itree = 369
  fBoostWeights.push_back(0.208025);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458174,-99) , 
24, 36.1383, 0, 0, 0.538923,-99) , 
NN(
0, 
0, 
-1, 79.3597, 0, -1, 0.223842,-99) , 
112, 52.465, 1, 0, 0.511564,-99)    );
  // itree = 370
  fBoostWeights.push_back(0.176083);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.881143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537964,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.327675,-99) , 
164, 69.0209, 1, 0, 0.486682,-99) , 
91, 23.6305, 1, 0, 0.507539,-99)    );
  // itree = 371
  fBoostWeights.push_back(0.279247);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.2129,-99) , 
255, 23.9812, 1, 0, 0.584465,-99) , 
NN(
0, 
0, 
-1, 51.9373, 1, -1, 0.294628,-99) , 
23, 15.1135, 0, 0, 0.544085,-99)    );
  // itree = 372
  fBoostWeights.push_back(0.254441);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.636195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.250736,-99) , 
194, 17.365, 0, 0, 0.598072,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.303272,-99) , 
152, 76.2647, 0, 0, 0.425969,-99) , 
100, 60.9962, 0, 0, 0.508429,-99)    );
  // itree = 373
  fBoostWeights.push_back(0.108344);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 18.1645, 1, 1, 0.529803,-99) , 
NN(
0, 
0, 
-1, 58.3706, 1, -1, 0.0819364,-99) , 
32, 43.2666, 1, 0, 0.501935,-99)    );
  // itree = 374
  fBoostWeights.push_back(0.158449);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369349,-99) , 
101, 56.5269, 0, 0, 0.47941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0430452,-99) , 
51, 83.5358, 1, 0, 0.463168,-99)    );
  // itree = 375
  fBoostWeights.push_back(0.300016);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.835089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498003,-99) , 
140, 68.2028, 1, 0, 0.63426,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.616005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340421,-99) , 
102, 84.954, 0, 0, 0.411747,-99) , 
115, 36.4941, 1, 0, 0.462077,-99)    );
  // itree = 376
  fBoostWeights.push_back(0.199452);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.735208,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.291277,-99) , 
135, 85.6718, 1, 0, 0.668372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500431,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.280841,-99) , 
18, 12.1809, 0, 0, 0.438562,-99) , 
83, 29.8173, 1, 0, 0.487966,-99)    );
  // itree = 377
  fBoostWeights.push_back(0.231345);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396708,-99) , 
125, 54.2169, 1, 0, 0.516201,-99) , 
NN(
0, 
0, 
-1, 59.8074, 1, -1, 0.267549,-99) , 
33, 35.719, 1, 0, 0.470203,-99)    );
  // itree = 378
  fBoostWeights.push_back(0.100835);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.899366,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483451,-99) , 
66, 71.1405, 0, 0, 0.500564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0843345,-99) , 
32, 41.4945, 1, 0, 0.481078,-99)    );
  // itree = 379
  fBoostWeights.push_back(0.167934);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.920015,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339528,-99) , 
112, 38.5831, 1, 0, 0.498175,-99) , 
63, -2.91631, 1, 0, 0.513585,-99)    );
  // itree = 380
  fBoostWeights.push_back(0.191865);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 50.8056, 1, 1, 0.802229,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.858352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441697,-99) , 
196, 76.4405, 0, 0, 0.465812,-99) , 
133, 44.0686, 1, 0, 0.494178,-99)    );
  // itree = 381
  fBoostWeights.push_back(0.241524);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.5719, 1, 1, 0.573818,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.701718,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.236253,-99) , 
69, 95.2647, 0, 0, 0.284903,-99) , 
170, 45.4565, 0, 0, 0.503499,-99)    );
  // itree = 382
  fBoostWeights.push_back(0.248065);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.686763,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.332697,-99) , 
24, 10.5073, 0, 0, 0.626796,-99) , 
NN(
0, 
0, 
-1, 58.8055, 0, -1, 0.421452,-99) , 
231, 40.7505, 0, 0, 0.505612,-99)    );
  // itree = 383
  fBoostWeights.push_back(0.26349);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.317069,-99) , 
242, 3.31473, 0, 0, 0.537525,-99) , 
NN(
0, 
0, 
-1, 30.778, 1, -1, 0.356687,-99) , 
192, 17.3052, 1, 0, 0.450134,-99)    );
  // itree = 384
  fBoostWeights.push_back(0.166612);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.877744,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494641,-99) , 
113, 18.1568, 1, 0, 0.529522,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.266016,-99) , 
148, 30.9885, 1, 0, 0.331988,-99) , 
126, 46.412, 1, 0, 0.481624,-99)    );
  // itree = 385
  fBoostWeights.push_back(0.263411);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 10.789, 0, 1, 0.694174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3652,-99) , 
130, 34.3716, 1, 0, 0.44684,-99) , 
125, 19.8337, 1, 0, 0.489039,-99)    );
  // itree = 386
  fBoostWeights.push_back(0.257369);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.897612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.295651,-99) , 
194, 64.6167, 1, 0, 0.76676,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576247,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.385436,-99) , 
8, 26.9414, 0, 0, 0.485928,-99) , 
213, 67.4107, 0, 0, 0.519829,-99)    );
  // itree = 387
  fBoostWeights.push_back(0.176831);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.709587,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461879,-99) , 
137, 61.1317, 1, 0, 0.505819,-99) , 
NN(
0, 
0, 
-1, 3.50262, 1, -1, 0.204397,-99) , 
171, 24.7217, 0, 0, 0.480639,-99)    );
  // itree = 388
  fBoostWeights.push_back(0.216703);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 66.6637, 1, 1, 0.588703,-99) , 
NN(
0, 
0, 
-1, 17.3904, 0, -1, 0.238475,-99) , 
214, 19.6891, 0, 0, 0.552258,-99)    );
  // itree = 389
  fBoostWeights.push_back(0.233519);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 13.5218, 1, 1, 0.567267,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613742,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.331989,-99) , 
208, 1.79328, 1, 0, 0.376586,-99) , 
15, 7.26014, 1, 0, 0.469156,-99)    );
  // itree = 390
  fBoostWeights.push_back(0.217864);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.886785,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.359833,-99) , 
25, 25.6102, 0, 0, 0.490709,-99) , 
247, 61.0228, 0, 0, 0.510599,-99)    );
  // itree = 391
  fBoostWeights.push_back(0.270218);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.728384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419814,-99) , 
214, 46.5679, 0, 0, 0.614487,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.339728,-99) , 
189, 19.2549, 1, 0, 0.419539,-99) , 
169, 77.8057, 0, 0, 0.472783,-99)    );
  // itree = 392
  fBoostWeights.push_back(0.296896);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.125259,-99) , 
30, -2.28382, 0, 0, 0.573707,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.226439,-99) , 
130, 25.4075, 1, 0, 0.326665,-99) , 
244, 13.242, 0, 0, 0.490542,-99)    );
  // itree = 393
  fBoostWeights.push_back(0.256046);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.676638,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447267,-99) , 
235, 28.0805, 0, 0, 0.529827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523361,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.182547,-99) , 
54, 37.6129, 0, 0, 0.288226,-99) , 
9, 11.8605, 0, 0, 0.477423,-99)    );
  // itree = 394
  fBoostWeights.push_back(0.184019);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 41.0689, 0, 1, 0.55663,-99) , 
NN(
0, 
0, 
-1, 58.9701, 0, -1, 0.36468,-99) , 
213, 34.6642, 0, 0, 0.472827,-99)    );
  // itree = 395
  fBoostWeights.push_back(0.213324);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.762905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.217918,-99) , 
17, 45.6974, 1, 0, 0.68286,-99) , 
NN(
0, 
0, 
-1, 65.557, 1, -1, 0.432678,-99) , 
137, 60.6382, 1, 0, 0.480281,-99)    );
  // itree = 396
  fBoostWeights.push_back(0.222826);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.927946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590227,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394414,-99) , 
98, 44.2122, 1, 0, 0.502323,-99) , 
110, 6.52993, 1, 0, 0.518383,-99)    );
  // itree = 397
  fBoostWeights.push_back(0.130692);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.724925,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483605,-99) , 
109, 19.3876, 1, 0, 0.519032,-99) , 
NN(
0, 
0, 
-1, 9.64517, 1, -1, 0.140501,-99) , 
112, 56.1129, 1, 0, 0.497267,-99)    );
  // itree = 398
  fBoostWeights.push_back(0.150462);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.697447,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491748,-99) , 
56, 62.1648, 0, 0, 0.547485,-99) , 
NN(
0, 
0, 
-1, 50.1244, 0, -1, 0.151657,-99) , 
28, 50.6266, 1, 0, 0.526722,-99)    );
  // itree = 399
  fBoostWeights.push_back(0.186487);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.761898,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470681,-99) , 
31, 11.025, 1, 0, 0.610484,-99) , 
NN(
0, 
0, 
-1, 33.7209, 0, -1, 0.432687,-99) , 
37, 46.2757, 0, 0, 0.492705,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
