// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:57:05 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 14000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
NTrees: "200" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
UseBaggedBoost: "True" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
BaggedSampleFraction: "5.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
SeparationType: "giniindex" [Separation criterion for node splitting]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
H: "False" [Print method-specific help message]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "3" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "5.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 7
m_jj                          m_jj                          m_jj                          m_jj                                                            'F'    [0.146605730057,13.0981254578]
m_jjj                         m_jjj                         m_jjj                         m_jjj                                                           'F'    [0.34201452136,7.39196777344]
m_lv                          m_lv                          m_lv                          m_lv                                                            'F'    [0.26678776741,3.68225979805]
m_jlv                         m_jlv                         m_jlv                         m_jlv                                                           'F'    [0.384410560131,6.58312129974]
m_bb                          m_bb                          m_bb                          m_bb                                                            'F'    [0.0934824943542,7.85979413986]
m_wbb                         m_wbb                         m_wbb                         m_wbb                                                           'F'    [0.385025799274,4.54251241684]
m_wwbb                        m_wwbb                        m_wwbb                        m_wwbb                                                          'F'    [0.432279825211,4.07281732559]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 7 )
   {
      // the training input variables
      const char* inputVars[] = { "m_jj", "m_jjj", "m_lv", "m_jlv", "m_bb", "m_wbb", "m_wwbb" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[7];
   double fVmax[7];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[7];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.2773041331024);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.611278,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401575,-99) , 
4, 0.64637, 0, 0, 0.549759,-99) , 
NN(
0, 
0, 
-1, 2.2031, 1, -1, 0.28748,-99) , 
4, 1.1448, 1, 0, 0.480584,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.195093);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573594,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402238,-99) , 
5, 0.752259, 0, 0, 0.540991,-99) , 
NN(
0, 
0, 
-1, 1.85556, 1, -1, 0.337223,-99) , 
4, 1.22339, 1, 0, 0.497303,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.204284);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609089,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446504,-99) , 
5, 0.772951, 0, 0, 0.56669,-99) , 
NN(
0, 
0, 
-1, 1.06594, 0, -1, 0.387689,-99) , 
6, 0.976812, 1, 0, 0.504533,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.195201);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585679,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416775,-99) , 
4, 0.972888, 1, 0, 0.539878,-99) , 
NN(
0, 
0, 
-1, 1.16947, 0, -1, 0.38781,-99) , 
6, 0.926754, 1, 0, 0.47628,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.134325);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422727,-99) , 
5, 0.792642, 0, 0, 0.515037,-99) , 
NN(
0, 
0, 
-1, 1.8822, 1, -1, 0.28771,-99) , 
4, 1.58274, 1, 0, 0.492083,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.143513);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559443,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439901,-99) , 
5, 0.789514, 0, 0, 0.527148,-99) , 
NN(
0, 
0, 
-1, 1.06555, 0, -1, 0.386899,-99) , 
4, 1.19259, 1, 0, 0.496602,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.188529);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.660969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468022,-99) , 
5, 0.878188, 0, 0, 0.540395,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562119,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374581,-99) , 
1, 1.20679, 0, 0, 0.427269,-99) , 
6, 0.891364, 1, 0, 0.487293,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.139475);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550175,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418065,-99) , 
4, 0.570712, 0, 0, 0.523134,-99) , 
NN(
0, 
0, 
-1, 2.11012, 1, -1, 0.341326,-99) , 
4, 1.48384, 1, 0, 0.500651,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.161447);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461363,-99) , 
5, 0.833883, 0, 0, 0.534176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521497,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.351,-99) , 
3, 1.08579, 0, 0, 0.434518,-99) , 
6, 0.879621, 1, 0, 0.484574,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.133556);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.765724, 0, 1, 0.540054,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.341588,-99) , 
1, 1.12886, 0, 0, 0.376881,-99) , 
4, 1.03552, 1, 0, 0.488372,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.128015);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.623822,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490561,-99) , 
5, 0.883639, 0, 0, 0.536404,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380512,-99) , 
1, 1.10731, 0, 0, 0.42594,-99) , 
6, 0.880883, 1, 0, 0.483253,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.115467);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.16726, 0, 1, 0.587313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520091,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433257,-99) , 
6, 0.851808, 1, 0, 0.464634,-99) , 
3, 0.738926, 1, 0, 0.48952,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.131869);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46943,-99) , 
1, 0.993837, 0, 0, 0.511871,-99) , 
NN(
0, 
0, 
-1, 1.0332, 0, -1, 0.374223,-99) , 
6, 1.14588, 1, 0, 0.486173,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.0945833);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471549,-99) , 
3, 0.733538, 1, 0, 0.494239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.287101,-99) , 
4, 1.9426, 1, 0, 0.485493,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.11548);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540494,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436496,-99) , 
4, 0.991475, 1, 0, 0.522006,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588144,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387061,-99) , 
3, 1.27988, 0, 0, 0.443679,-99) , 
4, 1.20296, 1, 0, 0.505543,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.129185);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439486,-99) , 
4, 0.985813, 1, 0, 0.536821,-99) , 
NN(
0, 
0, 
-1, 0.952495, 0, -1, 0.441318,-99) , 
6, 0.90624, 1, 0, 0.49496,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.0730378);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479185,-99) , 
3, 1.0568, 0, 0, 0.502701,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.284596,-99) , 
4, 2.12069, 1, 0, 0.496102,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.0594721);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.739783, 1, 1, 0.517455,-99) , 
NN(
0, 
0, 
-1, 1.00156, 0, -1, 0.423868,-99) , 
6, 1.11174, 1, 0, 0.497923,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.113281);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.890174, 1, 1, 0.570121,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454746,-99) , 
1, 0.755671, 1, 0, 0.47563,-99) , 
1, 1.06594, 0, 0, 0.500514,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.119038);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.599564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483644,-99) , 
3, 1.99135, 1, 0, 0.577327,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529816,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406049,-99) , 
6, 0.882922, 1, 0, 0.482516,-99) , 
3, 1.29496, 0, 0, 0.498429,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.130557);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46211,-99) , 
0, 1.47821, 1, 0, 0.538494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438527,-99) , 
1, 0.72566, 1, 0, 0.461862,-99) , 
1, 1.01344, 0, 0, 0.489253,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.074122);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496794,-99) , 
3, 0.701864, 1, 0, 0.513699,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370676,-99) , 
1, 1.50399, 0, 0, 0.41957,-99) , 
6, 1.11174, 1, 0, 0.494237,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.107556);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.554545,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449758,-99) , 
4, 0.664272, 0, 0, 0.53969,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552187,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446008,-99) , 
3, 0.748909, 1, 0, 0.480633,-99) , 
3, 1.08237, 0, 0, 0.499329,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.0765654);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525425,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451246,-99) , 
5, 0.836993, 0, 0, 0.506908,-99) , 
NN(
0, 
0, 
-1, 0.339905, 1, -1, 0.403081,-99) , 
4, 0.463307, 0, 0, 0.495904,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.065416);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524595,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467725,-99) , 
4, 0.944722, 1, 0, 0.503416,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357055,-99) , 
4, 1.87252, 1, 0, 0.496818,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.0721111);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558438,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483515,-99) , 
1, 1.01344, 0, 0, 0.508673,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.337006,-99) , 
4, 1.9255, 1, 0, 0.501646,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.092533);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.21319, 0, 1, 0.534437,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407577,-99) , 
1, 1.65342, 0, 0, 0.443115,-99) , 
6, 1.09158, 1, 0, 0.515541,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.0491097);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508448,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442269,-99) , 
4, 0.621571, 0, 0, 0.494022,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.350637,-99) , 
4, 1.9426, 1, 0, 0.488135,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.0896241);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.832313, 0, 1, 0.569442,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621844,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46542,-99) , 
0, 0.551967, 1, 0, 0.471825,-99) , 
1, 0.824629, 1, 0, 0.492228,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.06321);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.596942,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441471,-99) , 
6, 1.34193, 1, 0, 0.553584,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408603,-99) , 
6, 1.05014, 1, 0, 0.488584,-99) , 
3, 1.3074, 0, 0, 0.4995,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.0787756);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557123,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488689,-99) , 
5, 0.900731, 0, 0, 0.520294,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.357082,-99) , 
3, 1.06854, 0, 0, 0.447403,-99) , 
6, 1.039, 1, 0, 0.50049,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.0927975);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.600527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492104,-99) , 
5, 0.858513, 0, 0, 0.53574,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50989,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392567,-99) , 
3, 0.998511, 0, 0, 0.464749,-99) , 
6, 0.879621, 1, 0, 0.501287,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.0521084);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527805,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482245,-99) , 
1, 1.01344, 0, 0, 0.497551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.366257,-99) , 
4, 1.9255, 1, 0, 0.491838,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.0521683);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.663241, 1, 1, 0.551092,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462998,-99) , 
3, 1.01162, 0, 0, 0.481937,-99) , 
3, 0.733014, 1, 0, 0.495808,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.0599657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539924,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481232,-99) , 
2, 1.01579, 0, 0, 0.49651,-99) , 
NN(
0, 
0, 
-1, 1.31005, 1, -1, 0.380307,-99) , 
3, 1.69285, 1, 0, 0.489602,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.0622632);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544239,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497631,-99) , 
6, 0.840137, 1, 0, 0.523172,-99) , 
NN(
0, 
0, 
-1, 0.973311, 0, -1, 0.448996,-99) , 
6, 1.09158, 1, 0, 0.506491,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.0720922);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.859078, 0, 1, 0.567779,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594503,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475417,-99) , 
3, 0.646098, 1, 0, 0.48673,-99) , 
1, 0.769549, 1, 0, 0.49728,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.0783295);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556196,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455208,-99) , 
3, 1.48084, 1, 0, 0.543393,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509466,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403548,-99) , 
4, 1.08208, 1, 0, 0.482473,-99) , 
1, 1.02615, 0, 0, 0.502108,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.0590873);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536715,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48077,-99) , 
1, 1.06512, 0, 0, 0.494647,-99) , 
NN(
0, 
0, 
-1, 1.07737, 0, -1, 0.407977,-99) , 
4, 1.57723, 1, 0, 0.487124,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.0561851);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518229,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467237,-99) , 
4, 0.737501, 0, 0, 0.500865,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.330926,-99) , 
4, 2.02059, 1, 0, 0.495175,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.0557756);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.690768, 1, 1, 0.511183,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432857,-99) , 
1, 1.91983, 0, 0, 0.451421,-99) , 
6, 1.03903, 1, 0, 0.494344,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.0529983);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515611,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461195,-99) , 
4, 0.733465, 0, 0, 0.497106,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.3856,-99) , 
4, 2.01692, 1, 0, 0.493456,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.0468796);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488944,-99) , 
3, 1.33342, 0, 0, 0.499778,-99) , 
NN(
0, 
0, 
-1, 1.10353, 0, -1, 0.414169,-99) , 
6, 1.43028, 1, 0, 0.494231,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.0620657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466075,-99) , 
4, 0.620806, 0, 0, 0.512758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386599,-99) , 
4, 1.9426, 1, 0, 0.508113,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.0439747);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55327,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483716,-99) , 
3, 0.618203, 1, 0, 0.488914,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388864,-99) , 
4, 2.01692, 1, 0, 0.485735,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.0836283);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488723,-99) , 
6, 0.850152, 1, 0, 0.534087,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467459,-99) , 
3, 1.26994, 0, 0, 0.491274,-99) , 
4, 0.898238, 1, 0, 0.514142,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.0569148);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525768,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488673,-99) , 
4, 0.942511, 1, 0, 0.514094,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.387515,-99) , 
1, 1.15018, 0, 0, 0.421913,-99) , 
4, 1.46737, 1, 0, 0.503514,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.0662274);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559221,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45999,-99) , 
3, 1.23502, 1, 0, 0.533279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439422,-99) , 
4, 1.07762, 1, 0, 0.495355,-99) , 
1, 1.08405, 0, 0, 0.50502,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.0686722);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417479,-99) , 
4, 0.664159, 0, 0, 0.514312,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509309,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.369016,-99) , 
4, 0.94423, 1, 0, 0.480375,-99) , 
5, 0.935875, 0, 0, 0.497742,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.0803674);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.849788, 1, 1, 0.544265,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465561,-99) , 
1, 0.798618, 1, 0, 0.485634,-99) , 
1, 1.08339, 0, 0, 0.500374,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.0579774);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515962,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470306,-99) , 
4, 0.724549, 0, 0, 0.500827,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383551,-99) , 
1, 1.79373, 0, 0, 0.43975,-99) , 
6, 1.29907, 1, 0, 0.494277,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.0617258);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490151,-99) , 
6, 0.85968, 1, 0, 0.519853,-99) , 
NN(
0, 
0, 
-1, 2.09551, 1, -1, 0.465106,-99) , 
4, 0.917813, 1, 0, 0.496391,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.0588477);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545219,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479911,-99) , 
3, 1.16215, 0, 0, 0.494129,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.364356,-99) , 
3, 1.87041, 1, 0, 0.489614,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.0893463);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458486,-99) , 
3, 1.77603, 1, 0, 0.543257,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451878,-99) , 
3, 0.749839, 1, 0, 0.480332,-99) , 
3, 0.974764, 0, 0, 0.507342,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.0238376);
  fForest.push_back( 
NN(
0, 
0, 
-1, 1.43028, 1, -1, 0.488083,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.0268122);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443337,-99) , 
6, 1.30873, 1, 0, 0.499814,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.346521,-99) , 
4, 2.1249, 1, 0, 0.495622,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.0519654);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547234,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464859,-99) , 
0, 1.14819, 1, 0, 0.523878,-99) , 
NN(
0, 
0, 
-1, 0.856303, 1, -1, 0.478047,-99) , 
3, 1.26994, 0, 0, 0.48645,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.0596157);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.40774, 0, 1, 0.529689,-99) , 
NN(
0, 
0, 
-1, 1.00156, 0, -1, 0.470011,-99) , 
6, 1.02873, 1, 0, 0.513008,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.0453504);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.580039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470318,-99) , 
2, 1.03558, 1, 0, 0.552702,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50343,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437042,-99) , 
0, 0.676683, 0, 0, 0.494554,-99) , 
1, 1.12886, 0, 0, 0.506234,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.0834342);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416568,-99) , 
3, 1.53564, 1, 0, 0.529824,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464356,-99) , 
0, 1.01374, 0, 0, 0.478485,-99) , 
1, 1.01344, 0, 0, 0.496518,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.0602764);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.569958,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479223,-99) , 
5, 0.865854, 0, 0, 0.511635,-99) , 
NN(
0, 
0, 
-1, 0.930919, 0, -1, 0.477574,-99) , 
6, 0.870018, 1, 0, 0.493996,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.0589644);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.587717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47817,-99) , 
3, 1.85488, 1, 0, 0.553863,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523613,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475385,-99) , 
3, 0.783062, 1, 0, 0.490232,-99) , 
3, 1.43116, 0, 0, 0.497831,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.0728237);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523105,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45038,-99) , 
4, 0.667344, 0, 0, 0.510282,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.381972,-99) , 
4, 0.690012, 1, 0, 0.464775,-99) , 
5, 0.811381, 0, 0, 0.498638,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.0430836);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588003,-99) , 
NN(
0, 
0, 
-1, 1.13598, 1, -1, 0.480461,-99) , 
5, 1.90048, 0, 0, 0.483585,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.061173);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43833,-99) , 
3, 1.7286, 1, 0, 0.521365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510986,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425026,-99) , 
4, 0.921371, 1, 0, 0.48986,-99) , 
5, 0.952451, 0, 0, 0.50478,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.0433005);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566776,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49722,-99) , 
6, 0.825917, 1, 0, 0.5128,-99) , 
NN(
0, 
0, 
-1, 0.806113, 1, -1, 0.46481,-99) , 
5, 0.818232, 0, 0, 0.500795,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.0417946);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.45564, 1, 1, 0.593557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506087,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.367452,-99) , 
4, 1.74214, 1, 0, 0.499106,-99) , 
3, 1.50274, 0, 0, 0.508923,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.0451109);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514286,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475876,-99) , 
5, 0.952451, 0, 0, 0.49389,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.361622,-99) , 
4, 2.19062, 1, 0, 0.490519,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.0354424);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.897246, 1, 1, 0.567743,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506977,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478081,-99) , 
3, 0.881073, 0, 0, 0.49405,-99) , 
3, 1.60625, 0, 0, 0.499572,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.0654842);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553727,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477911,-99) , 
6, 0.984564, 1, 0, 0.512166,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50794,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406803,-99) , 
6, 0.823674, 1, 0, 0.483561,-99) , 
5, 0.925622, 0, 0, 0.498798,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.0631712);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446749,-99) , 
3, 1.82465, 1, 0, 0.534713,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556138,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476896,-99) , 
2, 1.26092, 0, 0, 0.483154,-99) , 
3, 1.3035, 0, 0, 0.491517,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.0788278);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.595269,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468086,-99) , 
0, 0.731123, 0, 0, 0.548804,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450553,-99) , 
6, 0.847428, 1, 0, 0.47543,-99) , 
1, 0.786098, 1, 0, 0.487514,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.0651998);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530488,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484608,-99) , 
4, 0.838109, 0, 0, 0.513721,-99) , 
NN(
0, 
0, 
-1, 0.740533, 1, -1, 0.43633,-99) , 
5, 0.780977, 0, 0, 0.498557,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.0410322);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481972,-99) , 
6, 0.85968, 1, 0, 0.499003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.402515,-99) , 
4, 1.9468, 1, 0, 0.495363,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.0505808);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519825,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477131,-99) , 
5, 0.935875, 0, 0, 0.497603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.372713,-99) , 
4, 1.9426, 1, 0, 0.49305,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.0561404);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515705,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433687,-99) , 
0, 0.648804, 0, 0, 0.507295,-99) , 
NN(
0, 
0, 
-1, 1.07972, 1, -1, 0.423335,-99) , 
4, 1.40207, 1, 0, 0.496537,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.0658404);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429125,-99) , 
6, 1.68078, 1, 0, 0.528432,-99) , 
NN(
0, 
0, 
-1, 0.965547, 1, -1, 0.471238,-99) , 
5, 0.94942, 0, 0, 0.498931,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.0454471);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.563648,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475913,-99) , 
4, 0.812088, 1, 0, 0.531186,-99) , 
NN(
0, 
0, 
-1, 0.475027, 0, -1, 0.488935,-99) , 
6, 0.784461, 1, 0, 0.501899,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.083854);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536128,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43836,-99) , 
5, 0.702278, 0, 0, 0.519967,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567974,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460314,-99) , 
5, 1.48694, 0, 0, 0.475978,-99) , 
4, 0.917813, 1, 0, 0.501081,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.0303424);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.613027,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467466,-99) , 
0, 0.651557, 0, 0, 0.570719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501961,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418149,-99) , 
3, 1.72482, 1, 0, 0.497844,-99) , 
1, 0.751364, 1, 0, 0.50592,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.0561977);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.583917,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542988,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478894,-99) , 
5, 1.2295, 0, 0, 0.491521,-99) , 
1, 0.678158, 1, 0, 0.495711,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.0619428);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47599,-99) , 
5, 0.724048, 0, 0, 0.517493,-99) , 
NN(
0, 
0, 
-1, 1.64168, 0, -1, 0.424611,-99) , 
6, 1.26606, 1, 0, 0.505898,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.0463443);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482347,-99) , 
1, 0.686707, 1, 0, 0.487657,-99) , 
1, 1.78986, 0, 0, 0.491118,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.0312002);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497788,-99) , 
1, 0.753472, 1, 0, 0.506165,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510159,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388188,-99) , 
5, 1.86794, 0, 0, 0.435317,-99) , 
6, 1.34475, 1, 0, 0.499879,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.0394585);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.610924,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423552,-99) , 
0, 2.07107, 1, 0, 0.51136,-99) , 
1, 1.9157, 0, 0, 0.514084,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.0358544);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.779892, 1, 1, 0.533418,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501606,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447487,-99) , 
4, 0.657449, 0, 0, 0.491517,-99) , 
6, 0.790466, 1, 0, 0.504323,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.0426581);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604754,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499495,-99) , 
5, 0.949429, 0, 0, 0.512751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464004,-99) , 
5, 1.45656, 0, 0, 0.471896,-99) , 
6, 0.877649, 1, 0, 0.492883,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.0508184);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481537,-99) , 
0, 0.845158, 0, 0, 0.508387,-99) , 
NN(
0, 
0, 
-1, 1.5474, 0, -1, 0.422621,-99) , 
6, 1.48453, 1, 0, 0.503353,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.0468291);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535054,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49177,-99) , 
1, 0.91414, 0, 0, 0.517013,-99) , 
NN(
0, 
0, 
-1, 1.14003, 1, -1, 0.477865,-99) , 
3, 1.12934, 1, 0, 0.506288,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.0592728);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490328,-99) , 
4, 0.933315, 1, 0, 0.537275,-99) , 
NN(
0, 
0, 
-1, 0.928768, 0, -1, 0.476634,-99) , 
6, 0.80153, 1, 0, 0.496997,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.0618155);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528183,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478408,-99) , 
5, 0.903593, 0, 0, 0.503287,-99) , 
NN(
0, 
0, 
-1, 1.2498, 1, -1, 0.43804,-99) , 
6, 1.16635, 1, 0, 0.492759,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.0357394);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590372,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508959,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.370805,-99) , 
6, 1.31985, 1, 0, 0.503269,-99) , 
5, 1.67034, 0, 0, 0.507769,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.0458559);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.668413, 1, 1, 0.538787,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506555,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429643,-99) , 
5, 0.869142, 0, 0, 0.492358,-99) , 
6, 0.753039, 1, 0, 0.502752,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.0378941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.562622,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496773,-99) , 
5, 0.810415, 0, 0, 0.519649,-99) , 
NN(
0, 
0, 
-1, 0.88681, 0, -1, 0.48343,-99) , 
6, 0.794416, 1, 0, 0.495192,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.0506846);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.873926, 1, 1, 0.566113,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553797,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483387,-99) , 
1, 1.34878, 0, 0, 0.490177,-99) , 
3, 1.47117, 0, 0, 0.498648,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.0216867);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.1062, 0, 1, 0.508714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434884,-99) , 
2, 1.42676, 1, 0, 0.505928,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.0721796);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530798,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.431552,-99) , 
4, 0.993998, 1, 0, 0.519201,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44879,-99) , 
0, 0.914866, 0, 0, 0.482262,-99) , 
4, 1.08759, 1, 0, 0.508774,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.0436722);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44235,-99) , 
1, 1.03977, 1, 0, 0.525644,-99) , 
NN(
0, 
0, 
-1, 0.883372, 0, -1, 0.486846,-99) , 
6, 0.784461, 1, 0, 0.498482,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.0378451);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.631826,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477253,-99) , 
1, 1.01344, 1, 0, 0.564911,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489789,-99) , 
6, 0.635215, 1, 0, 0.494194,-99) , 
3, 1.56512, 0, 0, 0.499618,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.0468763);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544569,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481588,-99) , 
3, 1.56512, 0, 0, 0.486576,-99) , 
2, 1.38149, 0, 0, 0.490917,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.0516302);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556333,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458894,-99) , 
5, 0.956847, 0, 0, 0.544577,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511884,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453253,-99) , 
5, 1.09876, 1, 0, 0.501374,-99) , 
3, 1.21756, 0, 0, 0.510473,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.0350649);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520511,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49216,-99) , 
6, 0.886299, 1, 0, 0.50664,-99) , 
4, 0.328991, 1, 0, 0.510254,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.0356603);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511843,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409914,-99) , 
6, 1.33645, 1, 0, 0.506996,-99) , 
5, 1.8025, 0, 0, 0.509591,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.0650403);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478512,-99) , 
3, 1.01518, 1, 0, 0.54352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470057,-99) , 
3, 1.13387, 0, 0, 0.483694,-99) , 
1, 1.30672, 0, 0, 0.490458,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.0736511);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454339,-99) , 
4, 1.50239, 1, 0, 0.511953,-99) , 
NN(
0, 
0, 
-1, 1.72126, 1, -1, 0.454468,-99) , 
4, 0.833131, 0, 0, 0.485839,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.0598868);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476905,-99) , 
4, 0.991597, 1, 0, 0.513712,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575354,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443341,-99) , 
1, 0.806803, 1, 0, 0.460644,-99) , 
4, 1.20296, 1, 0, 0.502375,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.0517084);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531657,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491256,-99) , 
6, 0.90773, 1, 0, 0.508399,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441679,-99) , 
4, 0.478157, 1, 0, 0.467484,-99) , 
5, 0.8087, 0, 0, 0.498407,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.0367201);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.940432, 1, 1, 0.572131,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446737,-99) , 
2, 1.15391, 1, 0, 0.50726,-99) , 
2, 1.26987, 0, 0, 0.511925,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.0707603);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468588,-99) , 
2, 1.15375, 1, 0, 0.562173,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531981,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476992,-99) , 
1, 0.809505, 1, 0, 0.488943,-99) , 
5, 1.17693, 0, 0, 0.505666,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.0649651);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440093,-99) , 
2, 1.183, 1, 0, 0.513242,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463199,-99) , 
6, 0.677293, 1, 0, 0.475016,-99) , 
5, 0.993138, 0, 0, 0.49083,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.0364443);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.376788,-99) , 
6, 1.10339, 1, 0, 0.5051,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438122,-99) , 
1, 1.50653, 0, 0, 0.459289,-99) , 
6, 1.13497, 1, 0, 0.496924,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.0533277);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465133,-99) , 
6, 1.00194, 1, 0, 0.498213,-99) , 
NN(
0, 
0, 
-1, 0.947063, 1, -1, 0.460066,-99) , 
5, 0.77249, 0, 0, 0.490785,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.0378631);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515391,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487928,-99) , 
6, 0.982614, 1, 0, 0.505857,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514762,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.400158,-99) , 
3, 0.789487, 0, 0, 0.461999,-99) , 
4, 0.475027, 0, 0, 0.500682,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.0444155);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.880842, 0, 1, 0.577031,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475129,-99) , 
0, 0.959704, 0, 0, 0.486495,-99) , 
2, 1.29035, 0, 0, 0.492723,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.0330751);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508589,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442924,-99) , 
5, 0.705428, 0, 0, 0.501827,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.39269,-99) , 
0, 2.50027, 1, 0, 0.498393,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.0291903);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.694044, 1, 1, 0.510422,-99) , 
NN(
0, 
0, 
-1, 1.09914, 0, -1, 0.447091,-99) , 
6, 1.31681, 1, 0, 0.504207,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.0477112);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.89571, 1, 1, 0.558357,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479911,-99) , 
5, 1.24731, 0, 0, 0.485699,-99) , 
4, 1.5913, 0, 0, 0.492734,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.0661116);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.578374,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472087,-99) , 
0, 1.21808, 1, 0, 0.522365,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473606,-99) , 
1, 0.641761, 1, 0, 0.477386,-99) , 
1, 1.12886, 0, 0, 0.486737,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.0396245);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593785,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482665,-99) , 
3, 1.02685, 1, 0, 0.532822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584432,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486511,-99) , 
4, 1.93449, 0, 0, 0.490454,-99) , 
1, 1.34954, 0, 0, 0.494579,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.0589501);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.8011, 1, 1, 0.525048,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419715,-99) , 
1, 0.857554, 0, 0, 0.468004,-99) , 
0, 0.763345, 0, 0, 0.513046,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.0437809);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.8559, 1, 1, 0.559875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483588,-99) , 
1, 0.709242, 1, 0, 0.488371,-99) , 
5, 1.57288, 0, 0, 0.493613,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.034498);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.307696, 1, 1, 0.512865,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525748,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363296,-99) , 
4, 1.25782, 0, 0, 0.437421,-99) , 
6, 1.49022, 1, 0, 0.508355,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.0653514);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538342,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449763,-99) , 
0, 2.07867, 1, 0, 0.52412,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573861,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473782,-99) , 
3, 1.58667, 0, 0, 0.480199,-99) , 
1, 1.0392, 0, 0, 0.493627,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.0294742);
  fForest.push_back( 
NN(
0, 
0, 
-1, 0.679587, 1, 1, 0.514733,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.0301331);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564747,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492436,-99) , 
3, 1.40404, 0, 0, 0.498971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416586,-99) , 
3, 1.89359, 1, 0, 0.496255,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.0601389);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5847,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473427,-99) , 
1, 1.33594, 0, 0, 0.480527,-99) , 
1, 0.656959, 1, 0, 0.484067,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.0246974);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.598805,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433684,-99) , 
2, 1.45996, 1, 0, 0.503895,-99) , 
6, 0.635215, 1, 0, 0.50868,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.056217);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.1473, 0, 1, 0.518956,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445004,-99) , 
5, 1.88095, 0, 0, 0.455336,-99) , 
6, 1.02619, 1, 0, 0.501561,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.0348424);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.991341, 0, 1, 0.509141,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461418,-99) , 
4, 1.15925, 0, 0, 0.480604,-99) , 
0, 1.03385, 1, 0, 0.501364,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.0507413);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537377,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49042,-99) , 
3, 0.758089, 1, 0, 0.504752,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526557,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44614,-99) , 
4, 1.52856, 0, 0, 0.461623,-99) , 
3, 1.16947, 1, 0, 0.494464,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.0449762);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475412,-99) , 
4, 1.06283, 1, 0, 0.542102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508886,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477984,-99) , 
4, 0.82339, 0, 0, 0.495514,-99) , 
2, 1.08, 0, 0, 0.504161,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.0176464);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.61508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494753,-99) , 
1, 1.51011, 0, 0, 0.552562,-99) , 
NN(
0, 
0, 
-1, 2.01064, 1, -1, 0.494724,-99) , 
5, 1.57556, 0, 0, 0.498612,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.0493765);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519704,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42673,-99) , 
4, 0.996615, 1, 0, 0.514205,-99) , 
NN(
0, 
0, 
-1, 1.17417, 1, -1, 0.471319,-99) , 
4, 1.04201, 1, 0, 0.500942,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.018568);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606497,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502498,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418183,-99) , 
6, 1.47243, 1, 0, 0.498889,-99) , 
3, 1.99837, 0, 0, 0.502515,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.0527758);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.640071, 1, 1, 0.52717,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479738,-99) , 
2, 1.0769, 0, 0, 0.492994,-99) , 
6, 0.983134, 0, 0, 0.50437,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.0358276);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513769,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470932,-99) , 
0, 1.22494, 1, 0, 0.507479,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422569,-99) , 
0, 2.6352, 1, 0, 0.504866,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.0565939);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.2307, 0, 1, 0.529804,-99) , 
NN(
0, 
0, 
-1, 1.06644, 1, -1, 0.474083,-99) , 
4, 0.936348, 1, 0, 0.507771,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.0475413);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514527,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463369,-99) , 
4, 0.662601, 0, 0, 0.505418,-99) , 
NN(
0, 
0, 
-1, 1.02453, 1, -1, 0.455041,-99) , 
5, 0.780977, 0, 0, 0.49536,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.0492051);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561142,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482132,-99) , 
1, 0.653752, 1, 0, 0.48454,-99) , 
NN(
0, 
0, 
-1, 1.21149, 1, -1, 0.402824,-99) , 
6, 1.42123, 1, 0, 0.478887,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.056469);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.734962, 1, 1, 0.550471,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478638,-99) , 
3, 1.00039, 0, 0, 0.501347,-99) , 
3, 0.721209, 1, 0, 0.51025,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.0407924);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540179,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491016,-99) , 
1, 0.825039, 1, 0, 0.501863,-99) , 
NN(
0, 
0, 
-1, 1.11967, 0, -1, 0.425997,-99) , 
3, 1.56512, 1, 0, 0.495968,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.0371616);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413746,-99) , 
3, 0.56877, 0, 0, 0.50811,-99) , 
NN(
0, 
0, 
-1, 1.13992, 0, -1, 0.427696,-99) , 
3, 1.67512, 1, 0, 0.503246,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.0461019);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516344,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475076,-99) , 
0, 0.92987, 1, 0, 0.498069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424978,-99) , 
0, 0.547726, 0, 0, 0.494218,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.0633432);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.424081,-99) , 
6, 1.5748, 1, 0, 0.517152,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524011,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465614,-99) , 
0, 0.934912, 0, 0, 0.48304,-99) , 
1, 1.01344, 0, 0, 0.495265,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.0322045);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508048,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478448,-99) , 
5, 0.872967, 0, 0, 0.496646,-99) , 
3, 1.95454, 0, 0, 0.500104,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.0433027);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496072,-99) , 
3, 1.56512, 0, 0, 0.502099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506919,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420917,-99) , 
4, 1.22297, 0, 0, 0.437457,-99) , 
0, 1.10217, 1, 0, 0.487923,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.0330287);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417019,-99) , 
4, 1.95908, 1, 0, 0.506626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.356668,-99) , 
0, 2.57051, 1, 0, 0.502,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.0446321);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.417389,-99) , 
5, 0.620683, 0, 0, 0.509545,-99) , 
NN(
0, 
0, 
-1, 1.07627, 0, -1, 0.454525,-99) , 
6, 1.13598, 1, 0, 0.499616,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.0452118);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528575,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493173,-99) , 
0, 0.945437, 0, 0, 0.50628,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428233,-99) , 
3, 1.83073, 0, 0, 0.458469,-99) , 
3, 1.32952, 1, 0, 0.49926,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.040449);
  fForest.push_back( 
NN(
0, 
0, 
-1, 1.58274, 1, -1, 0.479787,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.0595786);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428125,-99) , 
6, 0.994181, 1, 0, 0.510199,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556025,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470942,-99) , 
4, 0.428516, 1, 0, 0.47618,-99) , 
3, 0.851995, 1, 0, 0.489087,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.0426049);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.568352,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435435,-99) , 
2, 1.14003, 1, 0, 0.544567,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505037,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403906,-99) , 
3, 1.1876, 1, 0, 0.496846,-99) , 
3, 1.3135, 0, 0, 0.504512,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.0621174);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482831,-99) , 
0, 0.908988, 0, 0, 0.51149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425764,-99) , 
6, 0.908662, 0, 0, 0.473644,-99) , 
1, 1.01344, 1, 0, 0.497803,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.0445698);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.555978, 0, 1, 0.547686,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.605751,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484659,-99) , 
1, 0.712348, 1, 0, 0.490547,-99) , 
0, 0.62439, 1, 0, 0.495726,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.045301);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508596,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.403605,-99) , 
3, 1.69434, 1, 0, 0.504156,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445292,-99) , 
5, 0.885959, 1, 0, 0.454797,-99) , 
4, 1.09052, 1, 0, 0.491219,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.0218157);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.602604, 1, 1, 0.506238,-99) , 
NN(
0, 
0, 
-1, 1.52743, 0, -1, 0.424581,-99) , 
6, 1.42123, 1, 0, 0.500728,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.0357043);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.22783, 0, 1, 0.509765,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548003,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405351,-99) , 
5, 1.79036, 0, 0, 0.455041,-99) , 
5, 1.36211, 1, 0, 0.503323,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.0425578);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.02663, 0, 1, 0.518848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478808,-99) , 
5, 1.63711, 0, 0, 0.481898,-99) , 
4, 0.48509, 1, 0, 0.486671,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.0326498);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575063,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48068,-99) , 
3, 1.11289, 1, 0, 0.539761,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456661,-99) , 
1, 1.12924, 1, 0, 0.491567,-99) , 
2, 1.13102, 0, 0, 0.499007,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.0384903);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507941,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.396745,-99) , 
5, 0.682223, 0, 0, 0.50271,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377742,-99) , 
5, 0.742559, 1, 0, 0.446498,-99) , 
4, 0.463307, 0, 0, 0.496293,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.0493519);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49202,-99) , 
3, 1.32421, 0, 0, 0.505255,-99) , 
NN(
0, 
0, 
-1, 0.584126, 0, -1, 0.468858,-99) , 
4, 0.878633, 0, 0, 0.486301,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.0370941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549623,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486519,-99) , 
1, 1.43808, 0, 0, 0.490731,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380483,-99) , 
4, 2.11729, 1, 0, 0.487917,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.0475995);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.679587, 1, 1, 0.513521,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515809,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.340066,-99) , 
4, 0.657832, 1, 0, 0.448454,-99) , 
5, 0.763309, 0, 0, 0.501916,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.0154513);
  fForest.push_back( 
NN(
0, 
0, 
-1, 2.61356, 1, -1, 0.492275,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.0449352);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.36034, 0, 1, 0.535149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510921,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476069,-99) , 
2, 1.02744, 0, 0, 0.4842,-99) , 
5, 1.41064, 0, 0, 0.489764,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.0235412);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.56224,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495003,-99) , 
0, 1.49744, 0, 0, 0.500244,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421082,-99) , 
0, 2.50601, 1, 0, 0.497612,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.0434747);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553671,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496569,-99) , 
5, 1.36731, 1, 0, 0.537304,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487072,-99) , 
4, 0.787846, 0, 0, 0.503614,-99) , 
4, 1.20549, 0, 0, 0.510901,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.0295868);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.38743, 1, 1, 0.534598,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502734,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445407,-99) , 
5, 1.08094, 1, 0, 0.494206,-99) , 
5, 1.2295, 0, 0, 0.501466,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.0361482);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52198,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487003,-99) , 
6, 0.758605, 1, 0, 0.495485,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423141,-99) , 
2, 1.38091, 1, 0, 0.492094,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.0152657);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419489,-99) , 
0, 2.61717, 1, 0, 0.498368,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.33998,-99) , 
3, 1.91325, 1, 0, 0.49372,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.0344482);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.624386,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475051,-99) , 
3, 1.07358, 1, 0, 0.552952,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491218,-99) , 
4, 1.48562, 0, 0, 0.497051,-99) , 
2, 1.27591, 0, 0, 0.501159,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.0477139);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513461,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472998,-99) , 
4, 0.866064, 0, 0, 0.493547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363135,-99) , 
0, 2.55506, 1, 0, 0.489398,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.0393954);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540356,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491106,-99) , 
5, 1.20112, 0, 0, 0.498512,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518923,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.405356,-99) , 
5, 1.54147, 0, 0, 0.439637,-99) , 
4, 1.47156, 1, 0, 0.492376,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.0448855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53991,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49725,-99) , 
4, 0.922528, 1, 0, 0.51798,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500659,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393593,-99) , 
6, 0.746647, 1, 0, 0.472525,-99) , 
5, 0.784373, 0, 0, 0.508337,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.0518161);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523384,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48762,-99) , 
2, 1.01379, 1, 0, 0.514102,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.386949,-99) , 
4, 0.334139, 1, 0, 0.450368,-99) , 
4, 0.475027, 0, 0, 0.506191,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.0362244);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466281,-99) , 
3, 1.31884, 1, 0, 0.505602,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407371,-99) , 
6, 1.64579, 1, 0, 0.502128,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.0350902);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483647,-99) , 
6, 0.85063, 1, 0, 0.496706,-99) , 
NN(
0, 
0, 
-1, 1.26126, 1, -1, 0.427703,-99) , 
1, 1.45373, 1, 0, 0.491733,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.0562194);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480815,-99) , 
1, 1.11452, 1, 0, 0.523241,-99) , 
NN(
0, 
0, 
-1, 1.16684, 1, -1, 0.47743,-99) , 
3, 0.891536, 0, 0, 0.50205,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.048688);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532535,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481842,-99) , 
3, 1.12397, 0, 0, 0.493902,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393662,-99) , 
3, 1.89359, 1, 0, 0.490654,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.0278237);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497528,-99) , 
6, 0.714962, 1, 0, 0.505884,-99) , 
NN(
0, 
0, 
-1, 1.02313, 0, -1, 0.466514,-99) , 
3, 1.26994, 1, 0, 0.499191,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.0397296);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604149,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49451,-99) , 
2, 1.03328, 0, 0, 0.519434,-99) , 
NN(
0, 
0, 
-1, 1.31599, 1, -1, 0.488018,-99) , 
4, 0.857125, 1, 0, 0.503536,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.0645929);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525714,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462977,-99) , 
0, 0.96553, 1, 0, 0.515914,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449332,-99) , 
5, 0.827687, 1, 0, 0.465092,-99) , 
0, 1.10217, 1, 0, 0.505336,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.0209636);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.03614, 0, 1, 0.5527,-99) , 
NN(
0, 
0, 
-1, 1.6005, 1, -1, 0.49293,-99) , 
2, 1.27374, 0, 0, 0.497396,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.0394021);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.863223, 1, 1, 0.513144,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531639,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452898,-99) , 
5, 0.756505, 0, 0, 0.484965,-99) , 
6, 0.756321, 0, 0, 0.506475,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.0551616);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.675266, 1, 1, 0.521227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5544,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444962,-99) , 
0, 1.39356, 0, 0, 0.480213,-99) , 
6, 1.11174, 1, 0, 0.513507,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.0250325);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534445,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498017,-99) , 
2, 1.01909, 0, 0, 0.506876,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.407757,-99) , 
3, 1.89901, 1, 0, 0.503704,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.0593145);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518311,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.419731,-99) , 
0, 1.70347, 1, 0, 0.511983,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.391053,-99) , 
1, 1.83688, 0, 0, 0.446273,-99) , 
6, 1.32081, 1, 0, 0.505888,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.0564237);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.440421, 1, 1, 0.542551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512073,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469774,-99) , 
5, 1.1396, 0, 0, 0.48298,-99) , 
5, 0.780977, 1, 0, 0.494979,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.0505288);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.33492, 0, 1, 0.526939,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472031,-99) , 
5, 1.09915, 0, 0, 0.479726,-99) , 
1, 1.06555, 0, 0, 0.493025,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.0174449);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574069,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501454,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.36559,-99) , 
0, 0.45224, 0, 0, 0.496904,-99) , 
1, 1.74745, 0, 0, 0.50009,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.0270289);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47285,-99) , 
5, 0.814608, 0, 0, 0.4972,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.408126,-99) , 
6, 1.64579, 1, 0, 0.494603,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.0457087);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487236,-99) , 
0, 1.00475, 0, 0, 0.499515,-99) , 
NN(
0, 
0, 
-1, 1.22149, 1, -1, 0.462064,-99) , 
6, 1.09158, 1, 0, 0.491849,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.0449647);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561804,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.373571,-99) , 
4, 0.599966, 0, 0, 0.534936,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.555618,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492305,-99) , 
5, 1.77085, 0, 0, 0.495033,-99) , 
0, 0.763345, 1, 0, 0.503309,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.0431902);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484658,-99) , 
1, 1.02798, 0, 0, 0.495251,-99) , 
NN(
0, 
0, 
-1, 1.42865, 1, -1, 0.409415,-99) , 
5, 1.57288, 1, 0, 0.489894,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.0427855);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514117,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.399465,-99) , 
0, 0.510475, 0, 0, 0.508402,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.371782,-99) , 
6, 1.3561, 0, 0, 0.435018,-99) , 
0, 2.05774, 1, 0, 0.503974,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.0468017);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602131,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489345,-99) , 
6, 1.00813, 1, 0, 0.563358,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531116,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484237,-99) , 
4, 0.571803, 1, 0, 0.493275,-99) , 
2, 1.24264, 0, 0, 0.499562,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.0741105);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450425,-99) , 
6, 1.16317, 1, 0, 0.548606,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508257,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440992,-99) , 
2, 1.10052, 1, 0, 0.494522,-99) , 
3, 0.907786, 1, 0, 0.521019,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.0307253);
  fForest.push_back( 
NN(
0, 
0, 
-1, 0.335854, 0, -1, 0.484642,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.0193363);
  fForest.push_back( 
NN(
0, 
0, 
-1, 0.618203, 1, 1, 0.509667,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.0456328);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.807095, 1, 1, 0.518158,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406012,-99) , 
4, 0.345103, 1, 0, 0.471751,-99) , 
4, 0.468546, 0, 0, 0.513253,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
