// Class: ReadLikelihood
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : Likelihood::Likelihood
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:57:05 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 14000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "True" [Print method-specific help message]
TransformOutput: "True" [Transform likelihood output by inverse sigmoid function]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 7
m_jj                          m_jj                          m_jj                          m_jj                                                            'F'    [0.146605730057,13.0981254578]
m_jjj                         m_jjj                         m_jjj                         m_jjj                                                           'F'    [0.34201452136,7.39196777344]
m_lv                          m_lv                          m_lv                          m_lv                                                            'F'    [0.26678776741,3.68225979805]
m_jlv                         m_jlv                         m_jlv                         m_jlv                                                           'F'    [0.384410560131,6.58312129974]
m_bb                          m_bb                          m_bb                          m_bb                                                            'F'    [0.0934824943542,7.85979413986]
m_wbb                         m_wbb                         m_wbb                         m_wbb                                                           'F'    [0.385025799274,4.54251241684]
m_wwbb                        m_wwbb                        m_wwbb                        m_wwbb                                                          'F'    [0.432279825211,4.07281732559]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <cmath>
#include <cstdlib>
#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadLikelihood : public IClassifierReader {

 public:

   // constructor
   ReadLikelihood( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadLikelihood" ),
        fNvars( 7 )
   {
      // the training input variables
      const char* inputVars[] = { "m_jj", "m_jjj", "m_lv", "m_jlv", "m_bb", "m_wbb", "m_wwbb" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;
      fVmin[4] = 0;
      fVmax[4] = 0;
      fVmin[5] = 0;
      fVmax[5] = 0;
      fVmin[6] = 0;
      fVmax[6] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';
      fType[4] = 'F';
      fType[5] = 'F';
      fType[6] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadLikelihood() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[7];
   double fVmax[7];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[7];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   double       fEpsilon;
   static float fRefS[][10000]; // signal reference vector [nvars][max_nbins]
   static float fRefB[][10000]; // backgr reference vector [nvars][max_nbins]

// if a variable has its PDF encoded as a spline0 --> treat it like an Integer valued one
   bool    fHasDiscretPDF[7]; 
   int    fNbin[7]; // number of bins (discrete variables may have less bins)
   double    fHistMin[7]; 
   double    fHistMax[7]; 
   double TransformLikelihoodOutput( double, double ) const;
};

inline void ReadLikelihood::Initialize() 
{
   fEpsilon = 2.2250738585072e-305;
   fNbin[0] = 10000;
   fHistMin[0] = 0.146605730056763;
   fHistMax[0] = 13.0981254577637;
   fNbin[1] = 10000;
   fHistMin[1] = 0.342014521360397;
   fHistMax[1] = 7.3919677734375;
   fNbin[2] = 10000;
   fHistMin[2] = 0.266787767410278;
   fHistMax[2] = 3.68225979804993;
   fNbin[3] = 10000;
   fHistMin[3] = 0.384410560131073;
   fHistMax[3] = 6.58312129974365;
   fNbin[4] = 10000;
   fHistMin[4] = 0.093482494354248;
   fHistMax[4] = 7.85979413986206;
   fNbin[5] = 10000;
   fHistMin[5] = 0.385025799274445;
   fHistMax[5] = 4.5425124168396;
   fNbin[6] = 10000;
   fHistMin[6] = 0.432279825210571;
   fHistMax[6] = 4.07281732559204;
   fHasDiscretPDF[0] = false; 
   fHasDiscretPDF[1] = false; 
   fHasDiscretPDF[2] = false; 
   fHasDiscretPDF[3] = false; 
   fHasDiscretPDF[4] = false; 
   fHasDiscretPDF[5] = false; 
   fHasDiscretPDF[6] = false; 
}

inline double ReadLikelihood::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double ps(1), pb(1);
   std::vector<double> inputValuesSig = inputValues;
   std::vector<double> inputValuesBgd = inputValues;
   for (size_t ivar = 0; ivar < GetNvar(); ivar++) {

      // dummy at present... will be used for variable transforms
      double x[2] = { inputValuesSig[ivar], inputValuesBgd[ivar] };

      for (int itype=0; itype < 2; itype++) {

         // interpolate linearly between adjacent bins
         // this is not useful for discrete variables (or forced Spline0)
         int bin = int((x[itype] - fHistMin[ivar])/(fHistMax[ivar] - fHistMin[ivar])*fNbin[ivar]) + 0;

         // since the test data sample is in general different from the training sample
         // it can happen that the min/max of the training sample are trespassed --> correct this
         if      (bin < 0) {
            bin = 0;
            x[itype] = fHistMin[ivar];
         }
         else if (bin >= fNbin[ivar]) {
            bin = fNbin[ivar]-1;
            x[itype] = fHistMax[ivar];
         }

         // find corresponding histogram from cached indices
         float ref = (itype == 0) ? fRefS[ivar][bin] : fRefB[ivar][bin];

         // sanity check
         if (ref < 0) {
            std::cout << "Fatal error in ReadLikelihood: bin entry < 0 ==> abort" << std::endl;
            std::exit(1);
         }

         double p = ref;

         if (GetType(ivar) != 'I' && !fHasDiscretPDF[ivar]) {
            float bincenter = (bin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];
            int nextbin = bin;
            if ((x[itype] > bincenter && bin != fNbin[ivar]-1) || bin == 0) 
               nextbin++;
            else
               nextbin--;  

            double refnext      = (itype == 0) ? fRefS[ivar][nextbin] : fRefB[ivar][nextbin];
            float nextbincenter = (nextbin + 0.5)/fNbin[ivar]*(fHistMax[ivar] - fHistMin[ivar]) + fHistMin[ivar];

            double dx = bincenter - nextbincenter;
            double dy = ref - refnext;
            p += (x[itype] - bincenter) * dy/dx;
         }

         if (p < fEpsilon) p = fEpsilon; // avoid zero response

         if (itype == 0) ps *= p;
         else            pb *= p;
      }            
   }     

   // the likelihood ratio (transform it ?)
   return TransformLikelihoodOutput( ps, pb );   
}

inline double ReadLikelihood::TransformLikelihoodOutput( double ps, double pb ) const
{
   // returns transformed or non-transformed output
   if (ps < fEpsilon) ps = fEpsilon;
   if (pb < fEpsilon) pb = fEpsilon;
   double r = ps/(ps + pb);
   if (r >= 1.0) r = 1. - 1.e-15;

   if (true) {
      // inverse Fermi function

      // sanity check
      if      (r <= 0.0) r = fEpsilon;
      else if (r >= 1.0) r = 1. - 1.e-15;

      double tau = 15.0;
      r = - log(1.0/r - 1.0)/tau;
   }

   return r;
}

// Clean up
inline void ReadLikelihood::Clear() 
{
   // nothing to clear
}

// signal map
float ReadLikelihood::fRefS[][10000] = 
{ 
   { 0.0310873873531818, 0.0305064059793949, 0.0299385096877813, 0.0293837208300829, 0.0288420040160418, 0.0283133909106255, 0.0277978982776403, 0.0272955112159252, 0.0268061961978674, 0.0263299848884344, 0.0258668623864651, 0.0254168789833784, 0.0249799471348524, 0.024556141346693, 0.024145420640707, 0.0237477887421846, 0.0233632959425449, 0.0229918733239174, 0.0226335562765598, 0.0222883094102144, 0.0219561867415905, 0.0216371845453978, 0.0213312525302172, 0.0210384260863066, 0.0207586884498596, 0.0204920526593924, 0.0202385429292917, 0.0199981033802032, 0.0197707675397396, 0.0195565354079008, 0.0193553771823645, 0.0191673394292593, 0.018992405384779, 0.0188305787742138, 0.0186818204820156, 0.0185461696237326, 0.0184236578643322, 0.0183141641318798, 0.0182178262621164, 0.0181345958262682, 0.0180644169449806, 0.0180073790252209, 0.0179634094238281, 0.0179325640201569, 0.0179147887974977, 0.0179101545363665, 0.0179186053574085, 0.0179401282221079, 0.0179747547954321, 0.0180225055664778, 0.0180833078920841, 0.0181572511792183, 0.0182442981749773, 0.0183444358408451, 0.0184576418250799, 0.0185839701443911, 0.0187234189361334, 0.0188759062439203, 0.0190415326505899, 0.0192202646285295, 0.0194120667874813, 0.0196169912815094, 0.0198350213468075, 0.0200661029666662, 0.0203103423118591, 0.0205676518380642, 0.0208380855619907, 0.0211215522140265, 0.0214181784540415, 0.021727891638875, 0.0220506750047207, 0.0223865807056427, 0.0227355901151896, 0.0230976734310389, 0.0234728753566742, 0.023861201480031, 0.0242625828832388, 0.0246770661324263, 0.0251046735793352, 0.0255453679710627, 0.0259991511702538, 0.0264660380780697, 0.0269459970295429, 0.0274390932172537, 0.0279452949762344, 0.0284645687788725, 0.0289969649165869, 0.0295424312353134, 0.0301010180264711, 0.0306727141141891, 0.0312574580311775, 0.0318553261458874, 0.0324663184583187, 0.0330903604626656, 0.0337275490164757, 0.0343778021633625, 0.035041194409132, 0.0357176437973976, 0.0364072285592556, 0.0371098890900612, 0.0378256179392338, 0.0385544821619987, 0.0392964594066143, 0.0400515012443066, 0.0408196859061718, 0.0416009053587914, 0.0423952601850033, 0.0431494973599911, 0.0438243560492992, 0.0445164926350117, 0.0452258810400963, 0.0459525473415852, 0.046696525067091, 0.0474577583372593, 0.0482363104820251, 0.049032062292099, 0.0498451553285122, 0.0506755337119102, 0.0515231341123581, 0.0523880682885647, 0.0532702654600143, 0.054169736802578, 0.0550864674150944, 0.0560204721987247, 0.0569718144834042, 0.057940412312746, 0.0589262172579765, 0.0599293671548367, 0.0609497837722301, 0.0619874708354473, 0.063042476773262, 0.0641147419810295, 0.0652042925357819, 0.0663110613822937, 0.0674351751804352, 0.0685765370726585, 0.069735161960125, 0.0709110647439957, 0.0721042528748512, 0.073314756155014, 0.0745425075292587, 0.0757875442504883, 0.0770499110221863, 0.0783294886350632, 0.0796263739466667, 0.0809405446052551, 0.0822719261050224, 0.083620660007, 0.0849865898489952, 0.0863698571920395, 0.0877704173326492, 0.0891882479190826, 0.0906234011054039, 0.0920757502317429, 0.0935453698039055, 0.0950323417782784, 0.0965365469455719, 0.0980580449104309, 0.0995968207716942, 0.101152844727039, 0.102726168930531, 0.104316771030426, 0.105924658477306, 0.107549905776978, 0.109192296862602, 0.110852010548115, 0.112529002130032, 0.114223286509514, 0.115934863686562, 0.117663696408272, 0.119409807026386, 0.121173225343227, 0.122953847050667, 0.124751776456833, 0.126567035913467, 0.128399521112442, 0.130249351263046, 0.132116407155991, 0.13400074839592, 0.136034369468689, 0.138099774718285, 0.140186950564384, 0.142295822501183, 0.144426316022873, 0.146578624844551, 0.14875265955925, 0.150948390364647, 0.153165832161903, 0.15540499985218, 0.157665863633156, 0.159948393702507, 0.162252709269524, 0.164578661322594, 0.166926398873329, 0.169295728206635, 0.171686843037605, 0.174099683761597, 0.176534280180931, 0.178990557789803, 0.181468576192856, 0.183968275785446, 0.186489656567574, 0.189032793045044, 0.191597655415535, 0.194184124469757, 0.196792364120483, 0.199422270059586, 0.202073976397514, 0.204747378826141, 0.207442447543144, 0.210159301757812, 0.21289786696434, 0.215658128261566, 0.218440026044846, 0.221243739128113, 0.224069178104401, 0.226916164159775, 0.229784995317459, 0.23267550766468, 0.2355877161026, 0.238521724939346, 0.241477340459824, 0.244454726576805, 0.247453853487968, 0.250474631786346, 0.253517121076584, 0.256581336259842, 0.259667187929153, 0.26277482509613, 0.265904247760773, 0.269055187702179, 0.272228091955185, 0.275422602891922, 0.278638780117035, 0.281876742839813, 0.285136431455612, 0.288417756557465, 0.291720807552338, 0.295045495033264, 0.298392057418823, 0.301760137081146, 0.305150061845779, 0.308561772108078, 0.31199511885643, 0.315450191497803, 0.318926960229874, 0.322425454854965, 0.32594558596611, 0.329487353563309, 0.33305099606514, 0.336739331483841, 0.340547353029251, 0.34437170624733, 0.348212748765945, 0.352070063352585, 0.355943828821182, 0.359834015369415, 0.363740742206573, 0.367663830518723, 0.371603399515152, 0.375559359788895, 0.379531860351562, 0.383520752191544, 0.38752606511116, 0.391547858715057, 0.395586252212524, 0.399640917778015, 0.403712034225464, 0.407799631357193, 0.411903589963913, 0.41602411866188, 0.420161038637161, 0.424314379692078, 0.428484231233597, 0.432670503854752, 0.436873346567154, 0.441092371940613, 0.445328086614609, 0.449580043554306, 0.453848600387573, 0.458133548498154, 0.462434858083725, 0.466752707958221, 0.471086949110031, 0.475437700748444, 0.479804873466492, 0.484188497066498, 0.488588631153107, 0.493005067110062, 0.497438013553619, 0.501887440681458, 0.506353259086609, 0.510835647583008, 0.51533454656601, 0.519849836826324, 0.524381399154663, 0.528929471969604, 0.533493936061859, 0.538074970245361, 0.542672336101532, 0.547286331653595, 0.551916539669037, 0.556563317775726, 0.561226606369019, 0.56590610742569, 0.570602297782898, 0.575314819812775, 0.580043852329254, 0.584789216518402, 0.589551210403442, 0.594329595565796, 0.599124252796173, 0.603935480117798, 0.608763158321381, 0.613607227802277, 0.618468046188354, 0.623345077037811, 0.628238558769226, 0.633148550987244, 0.63807487487793, 0.643017590045929, 0.647995233535767, 0.653168737888336, 0.658341526985168, 0.663514316082001, 0.66868668794632, 0.673858344554901, 0.679029643535614, 0.684200823307037, 0.689371287822723, 0.694541752338409, 0.699711441993713, 0.704880952835083, 0.710049867630005, 0.715218722820282, 0.720386803150177, 0.725554585456848, 0.73072212934494, 0.735889256000519, 0.741056084632874, 0.746222198009491, 0.751387894153595, 0.756553530693054, 0.761718392372131, 0.766883313655853, 0.772047400474548, 0.777211308479309, 0.782374680042267, 0.787537693977356, 0.792700409889221, 0.797862470149994, 0.803024530410767, 0.808185636997223, 0.813347041606903, 0.818507373332977, 0.823667883872986, 0.828827500343323, 0.833986759185791, 0.839146018028259, 0.84430456161499, 0.849463284015656, 0.85462099313736, 0.859778523445129, 0.864935457706451, 0.870091915130615, 0.875248432159424, 0.880404114723206, 0.885559737682343, 0.890714645385742, 0.895869374275208, 0.901023507118225, 0.906177222728729, 0.911330938339233, 0.916483759880066, 0.921636641025543, 0.926788628101349, 0.93194055557251, 0.937091886997223, 0.942242920398712, 0.947393596172333, 0.95254385471344, 0.957693696022034, 0.962843179702759, 0.96799248456955, 0.973141193389893, 0.978289246559143, 0.983437359333038, 0.988584399223328, 0.993731737136841, 0.998878180980682, 1.00402474403381, 1.00917017459869, 1.01431560516357, 1.01941967010498, 1.02449905872345, 1.02955675125122, 1.03459215164185, 1.03960585594177, 1.04459822177887, 1.0495685338974, 1.05451643466949, 1.05944228172302, 1.06434643268585, 1.06922829151154, 1.07408905029297, 1.0789281129837, 1.083744764328, 1.08853948116302, 1.09331178665161, 1.09806287288666, 1.1027911901474, 1.10749840736389, 1.11218333244324, 1.11684715747833, 1.12148797512054, 1.12610685825348, 1.13070428371429, 1.13527953624725, 1.1398332118988, 1.14436483383179, 1.14887499809265, 1.15336239337921, 1.15782821178436, 1.16227209568024, 1.16669404506683, 1.17109429836273, 1.17547214031219, 1.17982912063599, 1.18416321277618, 1.18847548961639, 1.1927661895752, 1.19703435897827, 1.2012814283371, 1.20550584793091, 1.20970892906189, 1.21388983726501, 1.21804869174957, 1.22218596935272, 1.22630095481873, 1.23039436340332, 1.23446524143219, 1.23851466178894, 1.24254250526428, 1.24654817581177, 1.25053155422211, 1.25449299812317, 1.25843322277069, 1.2623507976532, 1.26624655723572, 1.27012085914612, 1.27397334575653, 1.2778035402298, 1.28161156177521, 1.2853981256485, 1.28916251659393, 1.2929048538208, 1.29662537574768, 1.30032444000244, 1.30400097370148, 1.3076559305191, 1.31128883361816, 1.31489944458008, 1.31848859786987, 1.3220556974411, 1.32554817199707, 1.32881879806519, 1.33205437660217, 1.33525407314301, 1.3384176492691, 1.34154641628265, 1.34463953971863, 1.3476973772049, 1.35072028636932, 1.35370683670044, 1.35665774345398, 1.35957336425781, 1.36245405673981, 1.36529874801636, 1.36810767650604, 1.37088179588318, 1.37361991405487, 1.37632262706757, 1.3789895772934, 1.38162100315094, 1.38421702384949, 1.38677775859833, 1.38930308818817, 1.39179313182831, 1.39424705505371, 1.39666569232941, 1.39904820919037, 1.40139591693878, 1.40370845794678, 1.4059853553772, 1.40822601318359, 1.41043186187744, 1.41260242462158, 1.41473710536957, 1.41683554649353, 1.41889894008636, 1.42092716693878, 1.42291975021362, 1.42487752437592, 1.42679882049561, 1.4286847114563, 1.430535197258, 1.43235003948212, 1.43413007259369, 1.4358743429184, 1.43758237361908, 1.43925535678864, 1.44089257717133, 1.44249534606934, 1.44406199455261, 1.44559216499329, 1.44708776473999, 1.4485479593277, 1.44997322559357, 1.45136177539825, 1.45271527767181, 1.4540331363678, 1.45531499385834, 1.45656251907349, 1.45777428150177, 1.45895040035248, 1.46009087562561, 1.4611953496933, 1.46226513385773, 1.46329879760742, 1.4642972946167, 1.46525943279266, 1.46618747711182, 1.46707999706268, 1.46793603897095, 1.46875667572021, 1.4695417881012, 1.47015726566315, 1.47067534923553, 1.47115671634674, 1.47160089015961, 1.472008228302, 1.47237849235535, 1.47271251678467, 1.47300922870636, 1.47326910495758, 1.47349190711975, 1.47367811203003, 1.47382807731628, 1.47394061088562, 1.47401630878448, 1.47405505180359, 1.4740571975708, 1.47402262687683, 1.47395098209381, 1.4738427400589, 1.47369730472565, 1.4735152721405, 1.47329699993134, 1.47304093837738, 1.47274851799011, 1.47241902351379, 1.47205281257629, 1.47164988517761, 1.47121012210846, 1.4707328081131, 1.47021925449371, 1.46966874599457, 1.46908211708069, 1.46845781803131, 1.46779680252075, 1.4670991897583, 1.46636438369751, 1.4655933380127, 1.46478497982025, 1.46394026279449, 1.46305823326111, 1.46213960647583, 1.46118450164795, 1.46019184589386, 1.45916247367859, 1.45809638500214, 1.45699369907379, 1.45585429668427, 1.45467793941498, 1.45346331596375, 1.45221328735352, 1.45092606544495, 1.44960308074951, 1.4482421875, 1.44684445858002, 1.44540989398956, 1.44393813610077, 1.4424307346344, 1.44088518619537, 1.43930339813232, 1.4376847743988, 1.43602991104126, 1.43433785438538, 1.43260860443115, 1.43084275722504, 1.42903995513916, 1.42719995975494, 1.42532444000244, 1.42341101169586, 1.4214608669281, 1.419473528862, 1.41745007038116, 1.41532278060913, 1.41304278373718, 1.41073536872864, 1.40840101242065, 1.40603911876678, 1.40364968776703, 1.40123283863068, 1.39878916740417, 1.39631807804108, 1.39381921291351, 1.39129328727722, 1.38873946666718, 1.38615882396698, 1.38355016708374, 1.38091421127319, 1.3782514333725, 1.37556076049805, 1.372842669487, 1.37009835243225, 1.36732566356659, 1.36452615261078, 1.36169791221619, 1.35884392261505, 1.35596215724945, 1.35305225849152, 1.35011553764343, 1.34715127944946, 1.34416031837463, 1.34114193916321, 1.33809554576874, 1.33502149581909, 1.33192086219788, 1.32879257202148, 1.32563662528992, 1.32245397567749, 1.31924319267273, 1.31600534915924, 1.31273972988129, 1.30944764614105, 1.30612730979919, 1.30277955532074, 1.29940557479858, 1.29600346088409, 1.29257345199585, 1.28911697864532, 1.28563392162323, 1.28212118148804, 1.27858304977417, 1.27501702308655, 1.27142262458801, 1.26780200004578, 1.26415312290192, 1.26047790050507, 1.25677502155304, 1.25304388999939, 1.24928617477417, 1.24550104141235, 1.24168837070465, 1.23784780502319, 1.23398125171661, 1.23008608818054, 1.22616338729858, 1.22221422195435, 1.21823763847351, 1.21423351764679, 1.21020221710205, 1.20614373683929, 1.2020571231842, 1.19794321060181, 1.19380211830139, 1.1896333694458, 1.18543791770935, 1.18110573291779, 1.17676448822021, 1.17241358757019, 1.16805303096771, 1.16368365287781, 1.15930533409119, 1.15491676330566, 1.15051996707916, 1.14611315727234, 1.14169716835022, 1.13727188110352, 1.13283681869507, 1.12839329242706, 1.1239401102066, 1.11947786808014, 1.11500597000122, 1.11052453517914, 1.10603415966034, 1.10153460502625, 1.0970253944397, 1.09250771999359, 1.08797991275787, 1.08344268798828, 1.07889640331268, 1.07434129714966, 1.0697762966156, 1.06520247459412, 1.06061851978302, 1.05602550506592, 1.05142331123352, 1.04681193828583, 1.04219198226929, 1.03756177425385, 1.03292298316956, 1.02827394008636, 1.02361607551575, 1.01894879341125, 1.01427257061005, 1.00958657264709, 1.00489223003387, 1.00018739700317, 0.995473504066467, 0.99075049161911, 0.986018419265747, 0.98127681016922, 0.976525843143463, 0.971765398979187, 0.966995775699615, 0.962217032909393, 0.9574294090271, 0.952631771564484, 0.947825312614441, 0.943009257316589, 0.938183069229126, 0.933348655700684, 0.928504824638367, 0.92365175485611, 0.918789029121399, 0.913917541503906, 0.909036338329315, 0.904145896434784, 0.899246096611023, 0.894336819648743, 0.889418423175812, 0.88449102640152, 0.879554033279419, 0.874607384204865, 0.869651734828949, 0.864686906337738, 0.859712839126587, 0.854729831218719, 0.849788427352905, 0.844899654388428, 0.840020179748535, 0.835150063037872, 0.830289483070374, 0.825438380241394, 0.820597171783447, 0.815764129161835, 0.810941219329834, 0.806126832962036, 0.801322877407074, 0.796528339385986, 0.791742444038391, 0.786967039108276, 0.782199263572693, 0.777442574501038, 0.77269458770752, 0.767955958843231, 0.763227105140686, 0.758506596088409, 0.753796398639679, 0.74909520149231, 0.744403660297394, 0.739721536636353, 0.735048472881317, 0.730385005474091, 0.725730240345001, 0.721085906028748, 0.716450154781342, 0.711824178695679, 0.70720773935318, 0.702600419521332, 0.698002636432648, 0.693413853645325, 0.688834607601166, 0.68426525592804, 0.679705202579498, 0.675154566764832, 0.670612454414368, 0.666081070899963, 0.661557137966156, 0.657044351100922, 0.652539312839508, 0.648045599460602, 0.643559753894806, 0.639083921909332, 0.634617865085602, 0.630160987377167, 0.625712811946869, 0.621274650096893, 0.616845607757568, 0.612425863742828, 0.608015537261963, 0.603614509105682, 0.5992231965065, 0.594841003417969, 0.590468347072601, 0.586104929447174, 0.581752061843872, 0.577406525611877, 0.573071718215942, 0.568745672702789, 0.564429342746735, 0.560122549533844, 0.555825173854828, 0.551536917686462, 0.54725855588913, 0.542988538742065, 0.538728773593903, 0.534477412700653, 0.530236423015594, 0.526013970375061, 0.521988213062286, 0.517981469631195, 0.513996362686157, 0.510031342506409, 0.506084799766541, 0.502159953117371, 0.498253464698792, 0.494368761777878, 0.490504175424576, 0.486659109592438, 0.48283463716507, 0.479030758142471, 0.47524482011795, 0.471481114625931, 0.467736393213272, 0.464011162519455, 0.460306614637375, 0.456622093915939, 0.452957153320312, 0.449313372373581, 0.445687979459763, 0.442085444927216, 0.438501924276352, 0.434936225414276, 0.431392818689346, 0.427868366241455, 0.424365103244781, 0.42088195681572, 0.417417734861374, 0.413974165916443, 0.410551756620407, 0.407148331403732, 0.40376552939415, 0.400402277708054, 0.397057950496674, 0.393735408782959, 0.390432327985764, 0.387149333953857, 0.383887588977814, 0.380643635988235, 0.377421438694, 0.374218791723251, 0.371036201715469, 0.36787423491478, 0.364732354879379, 0.36160883307457, 0.35850715637207, 0.355424344539642, 0.352362215518951, 0.349321275949478, 0.346298158168793, 0.343297898769379, 0.340316653251648, 0.337354898452759, 0.334413766860962, 0.331492155790329, 0.328590631484985, 0.325709760189056, 0.322847217321396, 0.320006519556046, 0.317185819149017, 0.314384132623672, 0.311603605747223, 0.308843731880188, 0.306101709604263, 0.303381383419037, 0.300680071115494, 0.298000484704971, 0.29533988237381, 0.29269877076149, 0.290078848600388, 0.28759753704071, 0.285207390785217, 0.282837867736816, 0.280488967895508, 0.278158485889435, 0.275849223136902, 0.273558884859085, 0.271290302276611, 0.269041240215302, 0.26681113243103, 0.26460337638855, 0.262415617704391, 0.260245203971863, 0.258097618818283, 0.255967915058136, 0.253859400749207, 0.251771479845047, 0.249704226851463, 0.247656479477882, 0.245628282427788, 0.243619546294212, 0.241632044315338, 0.239665135741234, 0.237716674804688, 0.235789388418198, 0.233881622552872, 0.231995597481728, 0.230129107832909, 0.228281557559967, 0.226454645395279, 0.22464781999588, 0.222860515117645, 0.221095502376556, 0.219349443912506, 0.217622369527817, 0.215916469693184, 0.214230090379715, 0.212563782930374, 0.210918128490448, 0.209292531013489, 0.207688122987747, 0.206102147698402, 0.204535648226738, 0.202991485595703, 0.201465710997581, 0.199960008263588, 0.198477178812027, 0.197011649608612, 0.195566728711128, 0.194142460823059, 0.192737713456154, 0.191353023052216, 0.189989537000656, 0.188645005226135, 0.187321677803993, 0.18601730465889, 0.184733539819717, 0.183470442891121, 0.182226300239563, 0.181002780795097, 0.179799899458885, 0.178615421056747, 0.177454367280006, 0.176311150193214, 0.175187453627586, 0.174084395170212, 0.173001408576965, 0.171939060091972, 0.170896768569946, 0.169875144958496, 0.168873578310013, 0.167922243475914, 0.167052567005157, 0.166194155812263, 0.165347903966904, 0.164514064788818, 0.163692474365234, 0.162883162498474, 0.162085995078087, 0.161300241947174, 0.160526618361473, 0.159764990210533, 0.159016191959381, 0.158278539776802, 0.157553002238274, 0.156841292977333, 0.156140446662903, 0.155451729893684, 0.154774725437164, 0.15411040186882, 0.153457388281822, 0.152816623449326, 0.152189806103706, 0.151573032140732, 0.15096852183342, 0.150376826524734, 0.149797022342682, 0.149228751659393, 0.148672759532928, 0.148129045963287, 0.147598281502724, 0.147078797221184, 0.146571040153503, 0.14607572555542, 0.145592212677002, 0.145120993256569, 0.144661620259285, 0.144214496016502, 0.143780916929245, 0.143357798457146, 0.142946928739548, 0.142548471689224, 0.14216160774231, 0.141787141561508, 0.141424790024757, 0.141075417399406, 0.140737056732178, 0.140410542488098, 0.140096977353096, 0.139795169234276, 0.139504745602608, 0.139227449893951, 0.138961583375931, 0.138708546757698, 0.138467073440552, 0.138237446546555, 0.138020232319832, 0.137814894318581, 0.137621656060219, 0.137440279126167, 0.13727268576622, 0.137115851044655, 0.136970862746239, 0.136837869882584, 0.136717259883881, 0.136609211564064, 0.136512026190758, 0.136428251862526, 0.136356860399246, 0.136296510696411, 0.136248543858528, 0.136212706565857, 0.136188164353371, 0.136118456721306, 0.136041030287743, 0.135967314243317, 0.135896220803261, 0.135828450322151, 0.135764107108116, 0.135702818632126, 0.135644748806953, 0.135590076446533, 0.135538339614868, 0.135489732027054, 0.135444462299347, 0.135402396321297, 0.135363325476646, 0.135327577590942, 0.135295018553734, 0.135265618562698, 0.13523942232132, 0.135216400027275, 0.135196536779404, 0.135179832577705, 0.135166361927986, 0.135155871510506, 0.135149002075195, 0.135144740343094, 0.135144218802452, 0.135146751999855, 0.135152295231819, 0.135161161422729, 0.135173201560974, 0.135188430547714, 0.135206669569016, 0.135228529572487, 0.13525328040123, 0.135281175374985, 0.135312020778656, 0.135346278548241, 0.135384023189545, 0.135424643754959, 0.135468453168869, 0.135515421628952, 0.135565862059593, 0.135619461536407, 0.135675981640816, 0.135735660791397, 0.135799080133438, 0.135865122079849, 0.135934337973595, 0.136006727814674, 0.136082857847214, 0.136161863803864, 0.136243775486946, 0.136328861117363, 0.13641768693924, 0.13650943338871, 0.13660404086113, 0.136701837182045, 0.136802792549133, 0.136907815933228, 0.137015402317047, 0.137125909328461, 0.137239873409271, 0.13735756278038, 0.137477859854698, 0.13760107755661, 0.137727722525597, 0.137857839465141, 0.137990862131119, 0.138127043843269, 0.138266414403915, 0.13840951025486, 0.138517171144485, 0.138567090034485, 0.138615697622299, 0.138663172721863, 0.138709515333176, 0.138754561543465, 0.138798460364342, 0.138841137290001, 0.138882607221603, 0.138922929763794, 0.138962045311928, 0.138999938964844, 0.139036685228348, 0.13907228410244, 0.139106601476669, 0.139139756560326, 0.139171734452248, 0.139202445745468, 0.139231994748116, 0.139260366559029, 0.139287501573563, 0.139313459396362, 0.139338180422783, 0.13936185836792, 0.139384210109711, 0.139405384659767, 0.139425382018089, 0.139444321393967, 0.139461949467659, 0.13947831094265, 0.13949353992939, 0.139507532119751, 0.139520391821861, 0.139531970024109, 0.139542460441589, 0.139551669359207, 0.139559715986252, 0.13956655561924, 0.139572218060493, 0.139576703310013, 0.139580115675926, 0.13958215713501, 0.139583066105843, 0.13958266377449, 0.139581248164177, 0.139578491449356, 0.139574602246284, 0.139569535851479, 0.139563202857971, 0.139555737376213, 0.139547064900398, 0.139537170529366, 0.139526262879372, 0.139514029026031, 0.139500558376312, 0.139485865831375, 0.139470040798187, 0.139452993869781, 0.139434814453125, 0.139415323734283, 0.139394700527191, 0.139372885227203, 0.13934987783432, 0.139325693249702, 0.139300271868706, 0.139273777604103, 0.139246001839638, 0.139217019081116, 0.139186814427376, 0.139155447483063, 0.139122888445854, 0.139089092612267, 0.139021396636963, 0.138949945569038, 0.138876467943192, 0.138801112771034, 0.138723731040955, 0.138644471764565, 0.138563483953476, 0.138480186462402, 0.138395205140114, 0.138308003544807, 0.138219118118286, 0.138128146529198, 0.138035148382187, 0.137940421700478, 0.137843742966652, 0.137744888663292, 0.137644320726395, 0.137541621923447, 0.137437283992767, 0.13733084499836, 0.137222215533257, 0.137112021446228, 0.136999443173409, 0.13688525557518, 0.136769130825996, 0.136650830507278, 0.136530861258507, 0.136408731341362, 0.136284723877907, 0.13615882396698, 0.136030837893486, 0.135901182889938, 0.135769441723824, 0.135635688900948, 0.135499879717827, 0.135362401604652, 0.135222867131233, 0.135081365704536, 0.134937822818756, 0.134792476892471, 0.134645119309425, 0.134495869278908, 0.134344533085823, 0.134191587567329, 0.13403657078743, 0.133879452943802, 0.133720442652702, 0.133559346199036, 0.133396655321121, 0.133231654763222, 0.133064910769463, 0.132896214723587, 0.132725432515144, 0.132552906870842, 0.132378339767456, 0.13220177590847, 0.132023543119431, 0.131843075156212, 0.131660714745522, 0.131476402282715, 0.131290137767792, 0.131101995706558, 0.130911827087402, 0.130719795823097, 0.13052587211132, 0.130329847335815, 0.130131945014, 0.129932031035423, 0.129730492830276, 0.129526734352112, 0.129321023821831, 0.129103496670723, 0.128878265619278, 0.128651887178421, 0.128423988819122, 0.128195017576218, 0.127964749932289, 0.127733185887337, 0.127500340342522, 0.127266258001328, 0.127030685544014, 0.126794099807739, 0.126555979251862, 0.126316800713539, 0.126076206564903, 0.125834420323372, 0.1255913823843, 0.125346928834915, 0.125101268291473, 0.124854408204556, 0.124606162309647, 0.124356627464294, 0.124105840921402, 0.123853914439678, 0.12360043078661, 0.123345859348774, 0.123090043663979, 0.122832834720612, 0.122574351727962, 0.122314609587193, 0.122053638100624, 0.121791422367096, 0.121527694165707, 0.121262922883034, 0.120996922254562, 0.120729342103004, 0.120460771024227, 0.120190687477589, 0.119919516146183, 0.119646914303303, 0.119373187422752, 0.119098104536533, 0.118821687996387, 0.118544176220894, 0.118265241384506, 0.11798495054245, 0.117703497409821, 0.117420725524426, 0.117136739194393, 0.116851322352886, 0.116564750671387, 0.116276986896992, 0.115987777709961, 0.115697331726551, 0.115405529737473, 0.11511255055666, 0.114818342030048, 0.114522688090801, 0.114226005971432, 0.113927900791168, 0.113628402352333, 0.113327786326408, 0.113025806844234, 0.112722650170326, 0.11241802573204, 0.112112313508987, 0.111805289983749, 0.111496828496456, 0.111187256872654, 0.110876321792603, 0.110564202070236, 0.110250800848007, 0.109930597245693, 0.109610915184021, 0.109291240572929, 0.108971446752548, 0.108651623129845, 0.108331777155399, 0.108011983335018, 0.107692055404186, 0.107372172176838, 0.107052139937878, 0.106732182204723, 0.10641211271286, 0.106092013418674, 0.105771914124489, 0.10545177012682, 0.105131603777409, 0.104811370372772, 0.104491092264652, 0.104170888662338, 0.103850513696671, 0.103530094027519, 0.103209719061852, 0.102889269590378, 0.102568857371807, 0.102248333394527, 0.101927816867828, 0.10160730779171, 0.101286612451077, 0.100966021418571, 0.100645296275616, 0.100324705243111, 0.100003868341446, 0.0996831804513931, 0.0993622466921806, 0.0990414544939995, 0.0987205505371094, 0.0983996465802193, 0.0980786085128784, 0.0977577343583107, 0.0974365919828415, 0.097115658223629, 0.0967944413423538, 0.096473328769207, 0.0961521789431572, 0.095830999314785, 0.0955096781253815, 0.0951884388923645, 0.0948671102523804, 0.0945457965135574, 0.0942244008183479, 0.093903012573719, 0.0935815945267677, 0.0932601317763329, 0.0929385647177696, 0.0926169380545616, 0.0922953635454178, 0.0919736996293068, 0.0916520282626152, 0.0913304015994072, 0.0910086259245872, 0.0906868502497673, 0.090365044772625, 0.090043269097805, 0.0897213667631149, 0.0893994122743607, 0.0890774354338646, 0.0887554883956909, 0.0884334370493889, 0.0881114155054092, 0.0877893641591072, 0.0874672010540962, 0.0871450528502464, 0.086831770837307, 0.0865233093500137, 0.0862157568335533, 0.0859093889594078, 0.0856037884950638, 0.0852992981672287, 0.0849957913160324, 0.0846930518746376, 0.0843914896249771, 0.08409084379673, 0.0837912335991859, 0.0834924727678299, 0.0831946805119514, 0.0828980654478073, 0.0826022252440453, 0.0823075026273727, 0.0820136815309525, 0.0817209035158157, 0.0814291089773178, 0.0811382830142975, 0.0808484479784966, 0.0805594995617867, 0.0802715346217155, 0.0799846202135086, 0.0796986743807793, 0.0794135630130768, 0.0791296511888504, 0.0788465589284897, 0.0785646662116051, 0.0782835260033607, 0.0780035108327866, 0.0777243301272392, 0.0774461925029755, 0.0771691054105759, 0.0768929272890091, 0.0766177177429199, 0.076343409717083, 0.0760701596736908, 0.0757980197668076, 0.0755264312028885, 0.0752562507987022, 0.0749869644641876, 0.0747184455394745, 0.0744511783123016, 0.0741846933960915, 0.0739191770553589, 0.0736548379063606, 0.0733914151787758, 0.0731288939714432, 0.0728673413395882, 0.0726067796349525, 0.0723473206162453, 0.0720888525247574, 0.0718310698866844, 0.0715745389461517, 0.0713188573718071, 0.0710642859339714, 0.0708104074001312, 0.0705578476190567, 0.0703061297535896, 0.0700552612543106, 0.0698055624961853, 0.0695566982030869, 0.0693088248372078, 0.0690620541572571, 0.0688161924481392, 0.0685711652040482, 0.0683273375034332, 0.0680844634771347, 0.0678423717617989, 0.0676014646887779, 0.0673681572079659, 0.067144401371479, 0.066922165453434, 0.0667011290788651, 0.0664812624454498, 0.0662624463438988, 0.0660450309514999, 0.06582872569561, 0.0656138136982918, 0.0653997510671616, 0.0651871412992477, 0.0649757757782936, 0.0647654011845589, 0.0645563527941704, 0.0643486157059669, 0.0641421377658844, 0.0639365687966347, 0.0637323930859566, 0.0635294765233994, 0.0633276700973511, 0.0631271228194237, 0.0629278272390366, 0.0627295151352882, 0.0625326558947563, 0.0623369850218296, 0.0621423535048962, 0.0619491301476955, 0.0617570094764233, 0.0615660175681114, 0.0613763406872749, 0.0611879900097847, 0.061000682413578, 0.0608146265149117, 0.0606296956539154, 0.0604461506009102, 0.0602635890245438, 0.0600824244320393, 0.0599025078117847, 0.0597237683832645, 0.0595460124313831, 0.0593697242438793, 0.0591946914792061, 0.0590207651257515, 0.0588478893041611, 0.0586764775216579, 0.058506041765213, 0.0583369322121143, 0.0581690073013306, 0.0580022670328617, 0.0578367784619331, 0.0576722659170628, 0.057509358972311, 0.0573474280536175, 0.0571868866682053, 0.0570273995399475, 0.0568691603839397, 0.0567121058702469, 0.0565563105046749, 0.0564016290009022, 0.0562482699751854, 0.0560961663722992, 0.0559451803565025, 0.0557952411472797, 0.0556468330323696, 0.0554995387792587, 0.0553534291684628, 0.0552083663642406, 0.0550646297633648, 0.0549221448600292, 0.0547807812690735, 0.0546406656503677, 0.0545018762350082, 0.0543666258454323, 0.0542356483638287, 0.054105743765831, 0.0539767183363438, 0.0538484156131744, 0.0537209212779999, 0.0535943321883678, 0.0534686148166656, 0.0533437319099903, 0.0532196536660194, 0.0530963391065598, 0.0529739633202553, 0.0528524629771709, 0.052731592208147, 0.0526117272675037, 0.0524928048253059, 0.0523744784295559, 0.0522570908069611, 0.0521406419575214, 0.0520249642431736, 0.051909975707531, 0.0517961084842682, 0.0516828335821629, 0.0515705347061157, 0.0514589995145798, 0.051348339766264, 0.0512385815382004, 0.0511296652257442, 0.0510214455425739, 0.0509141646325588, 0.0508077889680862, 0.0507020056247711, 0.0505973398685455, 0.0504933372139931, 0.0503903068602085, 0.0502879768610001, 0.0501865521073341, 0.0500860288739204, 0.0499863512814045, 0.0498872958123684, 0.0497892834246159, 0.0496921464800835, 0.0495958104729652, 0.0495001338422298, 0.0494055077433586, 0.0493115745484829, 0.0492186211049557, 0.0491263940930367, 0.0490350462496281, 0.0489445626735687, 0.0488548837602139, 0.0487660393118858, 0.0486781373620033, 0.0485910028219223, 0.0485045649111271, 0.0484191700816154, 0.0483346171677113, 0.0482507199048996, 0.0481677353382111, 0.048085693269968, 0.0480044446885586, 0.0479240715503693, 0.0478443242609501, 0.0477655939757824, 0.0476877950131893, 0.047610629349947, 0.0475343354046345, 0.0474590510129929, 0.0473844259977341, 0.0473106428980827, 0.0472378320991993, 0.0471641160547733, 0.0470892861485481, 0.0470150150358677, 0.0469410009682178, 0.0468674749135971, 0.0467942468822002, 0.0467214696109295, 0.0466489903628826, 0.0465769283473492, 0.0465052500367165, 0.0464339926838875, 0.0463630817830563, 0.0462925732135773, 0.0462225154042244, 0.0461527891457081, 0.0460834465920925, 0.0460145063698292, 0.0459458753466606, 0.0458776876330376, 0.0458098948001862, 0.0457425080239773, 0.0456754304468632, 0.0456088408827782, 0.0455425307154655, 0.0454767420887947, 0.0454112179577351, 0.0453461445868015, 0.0452814064919949, 0.0452170819044113, 0.045153122395277, 0.0450896024703979, 0.0450264103710651, 0.0449636019766331, 0.0449012666940689, 0.0448392108082771, 0.0447776392102242, 0.0447163693606853, 0.0446555279195309, 0.0445950552821159, 0.0445349663496017, 0.0444752462208271, 0.0444159619510174, 0.0443570353090763, 0.0442984849214554, 0.0442403629422188, 0.0441826283931732, 0.0441252589225769, 0.0440682731568813, 0.0440115854144096, 0.0439553968608379, 0.0438995435833931, 0.0438441447913647, 0.0437890216708183, 0.0437343865633011, 0.0436800494790077, 0.0436261482536793, 0.0435727201402187, 0.0435195118188858, 0.0434667952358723, 0.0434144623577595, 0.0433624424040318, 0.0433109067380428, 0.0432596765458584, 0.0432088561356068, 0.043158408254385, 0.0431083925068378, 0.0430586896836758, 0.0430095084011555, 0.0429605953395367, 0.0429121106863022, 0.0428639613091946, 0.0428162626922131, 0.0427666343748569, 0.0427155904471874, 0.0426646694540977, 0.0426139049232006, 0.042563259601593, 0.0425127409398556, 0.0424623265862465, 0.0424120277166367, 0.0423618853092194, 0.0423118472099304, 0.0422619469463825, 0.0422121770679951, 0.0421624928712845, 0.042112972587347, 0.0420635789632797, 0.0420142896473408, 0.0419651307165623, 0.0419160760939121, 0.0418671891093254, 0.0418184101581573, 0.0417697392404079, 0.0417212210595608, 0.0416728295385838, 0.0416245199739933, 0.0415763519704342, 0.0415283218026161, 0.0414804182946682, 0.041432648897171, 0.0413849502801895, 0.0413374304771423, 0.0412900187075138, 0.0412427447736263, 0.0411955900490284, 0.0411485359072685, 0.0411016158759594, 0.0410548485815525, 0.0410081967711449, 0.0409616678953171, 0.0409152582287788, 0.0408689193427563, 0.0408227704465389, 0.0407767593860626, 0.0407308302819729, 0.0406850315630436, 0.0406393520534039, 0.0405938327312469, 0.0405484288930893, 0.04050312936306, 0.0404579900205135, 0.040412925183773, 0.0403680168092251, 0.0403232388198376, 0.0402785614132881, 0.0402340367436409, 0.040189616382122, 0.0401453077793121, 0.0401011556386948, 0.0400571338832378, 0.0400131978094578, 0.0399693995714188, 0.0399257354438305, 0.039882205426693, 0.0398387722671032, 0.039795495569706, 0.039752297103405, 0.0397092774510384, 0.0396663546562195, 0.0396235696971416, 0.0395809076726437, 0.0395383350551128, 0.039495911449194, 0.0394529737532139, 0.0394097901880741, 0.0393665917217731, 0.0393233858048916, 0.0392801761627197, 0.0392369478940964, 0.0391937159001827, 0.0391504801809788, 0.0391072407364845, 0.0390639938414097, 0.0390207171440125, 0.0389774478971958, 0.0389341823756695, 0.0388908945024014, 0.038847591727972, 0.0388042889535427, 0.0387609824538231, 0.0387176722288132, 0.0386743359267712, 0.0386310070753098, 0.0385876782238483, 0.0385443195700645, 0.0385009683668613, 0.0384576022624969, 0.0384142361581326, 0.0383708588778973, 0.0383274704217911, 0.0382840745151043, 0.038240659981966, 0.0381972566246986, 0.0381538383662701, 0.0381104163825512, 0.0380669869482517, 0.0380235351622105, 0.0379800908267498, 0.0379366315901279, 0.0378931649029255, 0.0378496870398521, 0.0378062054514885, 0.0377627201378345, 0.0377192236483097, 0.0376757122576237, 0.0376321971416473, 0.037588682025671, 0.0375451520085335, 0.0375016108155251, 0.0374580733478069, 0.0374145284295082, 0.0373709686100483, 0.0373274087905884, 0.037283830344677, 0.0372402369976044, 0.0371966436505318, 0.0371530465781689, 0.0371094383299351, 0.0370658300817013, 0.0370221920311451, 0.0369785726070404, 0.0369349345564842, 0.0368913002312183, 0.0368476249277592, 0.0368039645254612, 0.0367603115737438, 0.0367166176438332, 0.0366729348897934, 0.0366292484104633, 0.0365855507552624, 0.0365418419241905, 0.0364981181919575, 0.036454401910305, 0.0364106632769108, 0.0363686457276344, 0.0363238006830215, 0.0362788364291191, 0.0362337939441204, 0.0361886695027351, 0.0361434631049633, 0.036098163574934, 0.0360527895390987, 0.0360073186457157, 0.0359617583453655, 0.0359161160886288, 0.0358703956007957, 0.0358245857059956, 0.03577870875597, 0.0357327349483967, 0.035686656832695, 0.0356405042111874, 0.0355942733585835, 0.0355479530990124, 0.0355015397071838, 0.035455048084259, 0.035408478230238, 0.0353618077933788, 0.0353150516748428, 0.0352682173252106, 0.0352213196456432, 0.0351743176579475, 0.0351272225379944, 0.0350800454616547, 0.0350327901542187, 0.0349854342639446, 0.0349380001425743, 0.0348904803395271, 0.0348428785800934, 0.0347951911389828, 0.0347474180161953, 0.0346995703876019, 0.0346516296267509, 0.0346035957336426, 0.0345554761588573, 0.0345072783529758, 0.0344589836895466, 0.0344106033444405, 0.0343621522188187, 0.0343136116862297, 0.0342649929225445, 0.0342162773013115, 0.0341674759984016, 0.0341186039149761, 0.0340696349740028, 0.0340205803513527, 0.0339714400470257, 0.0339222140610218, 0.033872913569212, 0.0338234975934029, 0.033774022012949, 0.0337244607508183, 0.0336748026311398, 0.0336250513792038, 0.0335752293467522, 0.0335253402590752, 0.0334753431379795, 0.033425260335207, 0.0333750955760479, 0.0333248488605022, 0.0332745015621185, 0.0332240834832191, 0.0331735797226429, 0.0331229865550995, 0.0330723002552986, 0.0330215431749821, 0.0329707004129887, 0.0329189337790012, 0.0328663662075996, 0.0328137166798115, 0.0327609814703465, 0.032708153128624, 0.0326552279293537, 0.0326022244989872, 0.0325491204857826, 0.0324959345161915, 0.0324426405131817, 0.0323892794549465, 0.0323358364403248, 0.032282292842865, 0.0322286412119865, 0.0321749188005924, 0.0321210995316505, 0.0320671834051609, 0.0320131927728653, 0.031959094107151, 0.0319049283862114, 0.0318506509065628, 0.0317962951958179, 0.031741838902235, 0.0316873267292976, 0.0316326878964901, 0.0315779745578766, 0.0315231755375862, 0.0314682684838772, 0.0314132869243622, 0.0313582085072994, 0.0313030257821083, 0.0312477722764015, 0.031192421913147, 0.0311369951814413, 0.0310814920812845, 0.0310258604586124, 0.0309701580554247, 0.030914356932044, 0.0308584775775671, 0.0308024846017361, 0.0307464301586151, 0.0306902751326561, 0.030634019523859, 0.0305776838213205, 0.0305212587118149, 0.0304647423326969, 0.0304081551730633, 0.0303514413535595, 0.0302946623414755, 0.030237790197134, 0.0301808211952448, 0.0301237646490335, 0.0300666224211454, 0.0300093833357096, 0.0299520567059517, 0.029894633218646, 0.0298371259123087, 0.0297795478254557, 0.0297218393534422, 0.0296640917658806, 0.0296062249690294, 0.0295482631772757, 0.0294902138411999, 0.0294320788234472, 0.0293738637119532, 0.0293155461549759, 0.02925712056458, 0.0291986335068941, 0.0291400533169508, 0.029081404209137, 0.0290226303040981, 0.0289590042084455, 0.0288989506661892, 0.0288388729095459, 0.0287787653505802, 0.0287186522036791, 0.0286585204303265, 0.0285983607172966, 0.0285381861031055, 0.028477992862463, 0.028417780995369, 0.0283575542271137, 0.0282972995191813, 0.0282370392233133, 0.0281767416745424, 0.0281164348125458, 0.0280561186373234, 0.0279957689344883, 0.0279354117810726, 0.0278750266879797, 0.0278146341443062, 0.0277542062103748, 0.0276937857270241, 0.0276333037763834, 0.0275728423148394, 0.0275123529136181, 0.0274518374353647, 0.027391305193305, 0.0273307543247938, 0.0272701866924763, 0.0272095929831266, 0.0271489825099707, 0.0270883720368147, 0.0270277168601751, 0.0269670523703098, 0.0269063729792833, 0.0268456675112247, 0.0267849490046501, 0.0267242081463337, 0.0266634672880173, 0.0266026705503464, 0.0265418868511915, 0.0264810752123594, 0.0264202449470758, 0.0263593923300505, 0.026298526674509, 0.0262376293540001, 0.0261767227202654, 0.0261157862842083, 0.0260548535734415, 0.0259938668459654, 0.0259329080581665, 0.0258718952536583, 0.0258108749985695, 0.0257498379796743, 0.025688773021102, 0.0256277080625296, 0.0255666021257639, 0.0255054850131273, 0.0254443492740393, 0.0253832079470158, 0.0253220219165087, 0.0252608358860016, 0.0251996237784624, 0.0251384116709232, 0.0250771641731262, 0.0250158812850714, 0.0249546002596617, 0.0248933006078005, 0.0248319748789072, 0.0247706491500139, 0.0247092880308628, 0.0246479101479053, 0.0245880000293255, 0.024526646360755, 0.0244653653353453, 0.0244041197001934, 0.0243430193513632, 0.024282006546855, 0.0242210403084755, 0.0241601914167404, 0.0240994058549404, 0.0240387339144945, 0.023978166282177, 0.0239176228642464, 0.023857232183218, 0.023796908557415, 0.0237366519868374, 0.0236765034496784, 0.0236164163798094, 0.0235564671456814, 0.0234965868294239, 0.0234367605298758, 0.0233770459890366, 0.0233174469321966, 0.0232578814029694, 0.0231984276324511, 0.0231390725821257, 0.023079801350832, 0.0230206195265055, 0.0229615084826946, 0.0229025091975927, 0.0228436123579741, 0.0227847266942263, 0.0227260086685419, 0.0226673204451799, 0.0226087756454945, 0.0225502904504538, 0.0224918834865093, 0.022433590143919, 0.0223753843456507, 0.0223172307014465, 0.0222591813653708, 0.0222012177109718, 0.0221433583647013, 0.0220855735242367, 0.0220278706401587, 0.0219702739268541, 0.0219128001481295, 0.0218553245067596, 0.0217979997396469, 0.021740734577179, 0.0216835644096136, 0.0216265078634024, 0.0215695053339005, 0.0215126238763332, 0.0214558113366365, 0.021399050951004, 0.0213424395769835, 0.0212858803570271, 0.0212294012308121, 0.0211730487644672, 0.021116741001606, 0.0210605580359697, 0.0210044588893652, 0.0209484230726957, 0.0208924915641546, 0.020836628973484, 0.0207808781415224, 0.0207252353429794, 0.0206696260720491, 0.0206141378730536, 0.02055873721838, 0.0205033961683512, 0.0204492080956697, 0.0203949399292469, 0.0203409157693386, 0.0202870480716228, 0.0202332697808743, 0.0201797336339951, 0.0201263893395662, 0.0200731847435236, 0.0200201701372862, 0.0199672784656286, 0.0199146494269371, 0.0198621768504381, 0.0198098085820675, 0.0197576154023409, 0.0197056829929352, 0.0196538548916578, 0.0196022521704435, 0.0195507723838091, 0.0194994863122702, 0.0194484423846006, 0.0193974673748016, 0.019346684217453, 0.0192961283028126, 0.0192457307130098, 0.019195506349206, 0.0191454030573368, 0.0190955437719822, 0.0190458782017231, 0.0189963318407536, 0.018946960568428, 0.0188977997750044, 0.0188487432897091, 0.0187999121844769, 0.0187512207776308, 0.018702756613493, 0.0186544489115477, 0.0186062958091497, 0.0185583736747503, 0.018510589376092, 0.0184629261493683, 0.0184155236929655, 0.0183682441711426, 0.018321106210351, 0.0182742420583963, 0.0182274673134089, 0.0181809030473232, 0.0181345473974943, 0.0180883146822453, 0.0180422551929951, 0.0179963503032923, 0.0179506931453943, 0.0179051365703344, 0.0178598091006279, 0.0178146567195654, 0.0177696608006954, 0.0177248194813728, 0.0176801551133394, 0.0176356807351112, 0.0175913628190756, 0.0175472740083933, 0.0175032876431942, 0.017459511756897, 0.0174159407615662, 0.017372515052557, 0.0173292607069016, 0.0172861106693745, 0.0172432418912649, 0.0172005295753479, 0.0171579513698816, 0.0171156227588654, 0.0170733463019133, 0.0170313287526369, 0.0169885810464621, 0.0169480107724667, 0.016907649114728, 0.016867496073246, 0.0168275181204081, 0.0167878195643425, 0.016748258844018, 0.0167089458554983, 0.0166697688400745, 0.016630906611681, 0.0165921486914158, 0.0165537390857935, 0.016515402123332, 0.0164774097502232, 0.0164394192397594, 0.0164017770439386, 0.016364274546504, 0.0163270831108093, 0.0162900350987911, 0.016253262758255, 0.0162165984511375, 0.01618024520576, 0.0161439273506403, 0.0161079913377762, 0.0160721596330404, 0.01603664457798, 0.0160013008862734, 0.0159661360085011, 0.0159311071038246, 0.0158963575959206, 0.0158618874847889, 0.0158275533467531, 0.0157933980226517, 0.0157594513148069, 0.0157258175313473, 0.015692250803113, 0.0156589318066835, 0.0156258530914783, 0.0155930574983358, 0.0155603988096118, 0.0155279487371445, 0.0154957110062242, 0.015463643707335, 0.0154317514970899, 0.0154002094641328, 0.0153687363490462, 0.0153375752270222, 0.0153064848855138, 0.0152757801115513, 0.0152451442554593, 0.0152147868648171, 0.0151846008375287, 0.0151546625420451, 0.01512486115098, 0.0150953410193324, 0.0150659587234259, 0.0150369247421622, 0.0150079252198339, 0.0149793112650514, 0.0149507662281394, 0.0149224642664194, 0.0148943373933434, 0.0148664880543947, 0.0148388491943479, 0.0148113844916224, 0.0147841293364763, 0.0147571507841349, 0.0147302793338895, 0.014703581109643, 0.0146771604195237, 0.014651020988822, 0.0146282510831952, 0.0146034341305494, 0.0145788798108697, 0.0145543599501252, 0.0145301185548306, 0.0145060699433088, 0.0144822113215923, 0.0144585287198424, 0.0144349494948983, 0.0144116850569844, 0.0143884550780058, 0.0143655557185411, 0.0143427439033985, 0.0143201574683189, 0.0142977647483349, 0.0142755443230271, 0.0142535176128149, 0.0142315933480859, 0.0142099149525166, 0.0141883930191398, 0.0141671318560839, 0.0141460103914142, 0.0141250109300017, 0.0141042899340391, 0.0140836909413338, 0.0140633014962077, 0.0140431206673384, 0.0140230804681778, 0.0140032833442092, 0.0139835383743048, 0.013964107260108, 0.0139447804540396, 0.0139256808906794, 0.0139067899435759, 0.0138880554586649, 0.0138694951310754, 0.0138510577380657, 0.0138328997418284, 0.0138148972764611, 0.0137971034273505, 0.0137794679030776, 0.0137620409950614, 0.0137447360903025, 0.0137276574969292, 0.0137107009068131, 0.0136940060183406, 0.0136774675920606, 0.013661103323102, 0.0136450016871095, 0.0136289158836007, 0.0136131448671222, 0.0135975126177073, 0.0135821420699358, 0.0135668748989701, 0.0135518014431, 0.0135369189083576, 0.01352215744555, 0.0135076940059662, 0.0134932985529304, 0.0134792001917958, 0.0134652415290475, 0.0134514383971691, 0.0134378802031279, 0.0134244104847312, 0.0134112173691392, 0.013398147188127, 0.0133852865546942, 0.013372634537518, 0.0133600868284702, 0.0133478185161948, 0.0133356545120478, 0.0133244218304753, 0.0133133223280311, 0.0133022908121347, 0.013291441835463, 0.0132806375622749, 0.0132700158283114, 0.0132594285532832, 0.0132489986717701, 0.0132386647164822, 0.0132284611463547, 0.0132183441892266, 0.0132083240896463, 0.0131984604522586, 0.013188648968935, 0.013179037719965, 0.0131694441661239, 0.0131600508466363, 0.013150691986084, 0.0131414653733373, 0.0131323337554932, 0.0131233669817448, 0.013114470988512, 0.0131056606769562, 0.0130970347672701, 0.0130884433165193, 0.0130800260230899, 0.0130716869607568, 0.0130634792149067, 0.0130553673952818, 0.0130473850294948, 0.0130394641309977, 0.0130317267030478, 0.0130240330472589, 0.0130164613947272, 0.0130090452730656, 0.0130016915500164, 0.0129944765940309, 0.0129873408004642, 0.0129803689196706, 0.0129734519869089, 0.0129667073488235, 0.0129600241780281, 0.012953489087522, 0.0129470322281122, 0.0129407234489918, 0.0129344761371613, 0.0129283592104912, 0.0129223642870784, 0.0129164475947618, 0.0129107050597668, 0.0129050072282553, 0.0128994742408395, 0.0128940185531974, 0.0128887034952641, 0.0128834415227175, 0.012878387235105, 0.0128733590245247, 0.0128684537485242, 0.0128636956214905, 0.0128589905798435, 0.0128544690087438, 0.0128500079736114, 0.0128456773236394, 0.0128414249047637, 0.0128373550251126, 0.0128333289176226, 0.0128294611349702, 0.0128256790339947, 0.0128220096230507, 0.0128184547647834, 0.0128149874508381, 0.0128116672858596, 0.0128068532794714, 0.0128034902736545, 0.0128001263365149, 0.0127968117594719, 0.0127934981137514, 0.0127902198582888, 0.0127869779244065, 0.0127837350592017, 0.0127805406227708, 0.0127773443236947, 0.012774184346199, 0.0127710429951549, 0.0127679305151105, 0.0127648310735822, 0.0127617632970214, 0.0127587094902992, 0.0127556966617703, 0.0127526950091124, 0.0127497259527445, 0.012746780179441, 0.0127438381314278, 0.0127409463748336, 0.0127380536869168, 0.0127352066338062, 0.0127323633059859, 0.012729556299746, 0.0127267567440867, 0.0127240009605885, 0.0127212479710579, 0.0127185434103012, 0.0127158584073186, 0.0127131808549166, 0.0127105368301272, 0.0127079030498862, 0.0127053102478385, 0.0127027267590165, 0.0127001833170652, 0.0126976342871785, 0.0126951364800334, 0.012692647986114, 0.0126901930198073, 0.0126877725124359, 0.0126853436231613, 0.0126829594373703, 0.0126805892214179, 0.0126782562583685, 0.0126759288832545, 0.0126736303791404, 0.0126713495701551, 0.0126691088080406, 0.0126668661832809, 0.0126646803691983, 0.0126625075936317, 0.0126603338867426, 0.0126582253724337, 0.0126561038196087, 0.012654016725719, 0.0126519491896033, 0.0126499189063907, 0.0126478932797909, 0.0126459086313844, 0.012643925845623, 0.0126419942826033, 0.0126400617882609, 0.0126381730660796, 0.0126363020390272, 0.012634439393878, 0.0126326289027929, 0.0126308081671596, 0.0126290321350098, 0.0126272654160857, 0.0126244248822331, 0.0126218721270561, 0.0126193193718791, 0.0126167004927993, 0.012614032253623, 0.012611348181963, 0.0126086343079805, 0.0126058692112565, 0.0126030594110489, 0.0126002198085189, 0.0125973494723439, 0.0125944335013628, 0.0125914644449949, 0.012588488869369, 0.0125854592770338, 0.012582384981215, 0.0125792874023318, 0.0125761413946748, 0.0125729525461793, 0.0125697385519743, 0.0125664845108986, 0.012563182041049, 0.0125598451122642, 0.0125564727932215, 0.0125530725345016, 0.01254962105304, 0.0125461369752884, 0.0125426119193435, 0.0125390524044633, 0.012535460293293, 0.0125318244099617, 0.0125281475484371, 0.0125244334340096, 0.0125206811353564, 0.012516894377768, 0.0125130703672767, 0.0125092063099146, 0.0125053068622947, 0.0125013599172235, 0.0124973887577653, 0.0124933747574687, 0.0124893244355917, 0.0124852322041988, 0.0124810971319675, 0.012476927600801, 0.0124727208167315, 0.0124684860929847, 0.0124642057344317, 0.0124598918482661, 0.0124555230140686, 0.0124511374160647, 0.0124467005953193, 0.0124422367662191, 0.0124377254396677, 0.0124331815168262, 0.0124285919591784, 0.0124239679425955, 0.0124193131923676, 0.0124146183952689, 0.0124098835512996, 0.0124050993472338, 0.0124002918601036, 0.0123954489827156, 0.0123905623331666, 0.0123856384307146, 0.0123806688934565, 0.0123756676912308, 0.012370633892715, 0.0123655535280704, 0.0123604433611035, 0.0123552903532982, 0.0123501066118479, 0.0123439785093069, 0.0123380357399583, 0.0123320240527391, 0.0123259508982301, 0.0123198349028826, 0.0123136295005679, 0.0123073998838663, 0.0123010827228427, 0.0122947292402387, 0.0122883077710867, 0.0122818164527416, 0.0122752729803324, 0.0122686680406332, 0.0122620109468699, 0.0122553016990423, 0.0122485142201185, 0.0122416904196143, 0.012234790250659, 0.0122278453782201, 0.0122208315879107, 0.0122137553989887, 0.0122066363692284, 0.012199429795146, 0.0121921980753541, 0.0121848881244659, 0.0121775167062879, 0.0121701005846262, 0.0121626071631908, 0.0121550783514977, 0.0121474722400308, 0.0121398037299514, 0.0121321016922593, 0.0121243204921484, 0.0121164955198765, 0.0121085923165083, 0.0121006462723017, 0.0120926378294826, 0.0120845604687929, 0.0120764309540391, 0.0120682222768664, 0.0120599800720811, 0.0120516931638122, 0.012043310329318, 0.0120349107310176, 0.0120264235883951, 0.0120178842917085, 0.0120092760771513, 0.0120006147772074, 0.0119919097051024, 0.0119831273332238, 0.0119743086397648, 0.0119654024019837, 0.0119564281776547, 0.0119474362581968, 0.0119383484125137, 0.0119292242452502, 0.0119200404733419, 0.0119107868522406, 0.0119014903903008, 0.0118921222165227, 0.0118827121332288, 0.011873222887516, 0.0118636908009648, 0.011854087933898, 0.0118444245308638, 0.0118347089737654, 0.0118249244987965, 0.0118150860071182, 0.011805197224021, 0.0117952367290854, 0.0117852343246341, 0.011775828897953, 0.0117652928456664, 0.0117547251284122, 0.0117440847679973, 0.0117334108799696, 0.0117226848378778, 0.0117119057103992, 0.0117010744288564, 0.011690191924572, 0.0116792656481266, 0.0116682685911655, 0.0116572454571724, 0.0116461794823408, 0.011635035276413, 0.0116238743066788, 0.0116126416251063, 0.011601367034018, 0.0115900384262204, 0.011578650213778, 0.0115672359243035, 0.0115557508543134, 0.0115442415699363, 0.0115326605737209, 0.0115210097283125, 0.0115093514323235, 0.0114976149052382, 0.0114858597517014, 0.0114740272983909, 0.0114621501415968, 0.0114502310752869, 0.0114382412284613, 0.0114262336865067, 0.011414147913456, 0.0114020360633731, 0.0113898543640971, 0.0113776288926601, 0.0113653521984816, 0.0113530224189162, 0.0113406404852867, 0.0113282324746251, 0.0113157546147704, 0.0113032413646579, 0.0112906601279974, 0.0112780425697565, 0.0112653728574514, 0.0112526435405016, 0.0112398769706488, 0.0112270507961512, 0.0112141817808151, 0.0112012503668666, 0.011188275180757, 0.0111752664670348, 0.0111621879041195, 0.0111490730196238, 0.0111358985304832, 0.0111226625740528, 0.011109409853816, 0.0110960872843862, 0.0110827200114727, 0.0110692922025919, 0.0110558392480016, 0.011042314581573, 0.0110287312418222, 0.01101512927562, 0.0110014406964183, 0.0109877167269588, 0.0109739666804671, 0.0109601384028792, 0.0109462756663561, 0.0109323607757688, 0.010918409563601, 0.0109043717384338, 0.0108875120058656, 0.0108732050284743, 0.0108588607981801, 0.0108444942161441, 0.0108301090076566, 0.0108157014474273, 0.0108012678101659, 0.0107868118211627, 0.0107723353430629, 0.0107578309252858, 0.0107433144003153, 0.0107287699356675, 0.0107141928747296, 0.0106996074318886, 0.0106850014999509, 0.0106703657656908, 0.0106557011604309, 0.0106410253793001, 0.0106263142079115, 0.0106115862727165, 0.0105968425050378, 0.0105820773169398, 0.0105672739446163, 0.0105524584650993, 0.0105376224964857, 0.0105227595195174, 0.0105078751221299, 0.0104929693043232, 0.0104780271649361, 0.0104630803689361, 0.010448107495904, 0.0104331113398075, 0.0104180881753564, 0.0104030445218086, 0.010387971997261, 0.0103728864341974, 0.0103577738627791, 0.0103426417335868, 0.0103274947032332, 0.0103123113512993, 0.010297117754817, 0.0102818850427866, 0.0102666411548853, 0.0102513777092099, 0.0102360751479864, 0.010220761410892, 0.0102054262533784, 0.0101900650188327, 0.0101746823638678, 0.0101592782884836, 0.010143855586648, 0.0101283928379416, 0.0101129300892353, 0.0100974282249808, 0.0100819058716297, 0.010066363029182, 0.0100508099421859, 0.0100352158769965, 0.0100196059793234, 0.010003974661231, 0.00998832192271948, 0.00997263938188553, 0.00995693821460009, 0.00994121469557285, 0.0099254734814167, 0.00990970060229301, 0.00989391934126616, 0.00987809803336859, 0.00986226741224527, 0.00984640512615442, 0.00983052328228951, 0.00981529336422682, 0.00979956332594156, 0.00978383887559175, 0.00976812466979027, 0.00975241139531136, 0.00973670557141304, 0.00972101278603077, 0.00970531906932592, 0.0096896318718791, 0.0096739623695612, 0.00965828821063042, 0.00964262150228024, 0.00962696503847837, 0.00961131229996681, 0.00959566980600357, 0.00958002731204033, 0.00956440344452858, 0.00954877492040396, 0.00953315198421478, 0.00951754115521908, 0.00950194429606199, 0.00948633905500174, 0.00947074592113495, 0.00945516675710678, 0.00943958479911089, 0.0094240065664053, 0.00940844882279634, 0.00939288828521967, 0.00937733426690102, 0.00936178956180811, 0.00934624671936035, 0.00933070946484804, 0.00931518245488405, 0.00929966848343611, 0.00928415078669786, 0.00926864240318537, 0.00925314333289862, 0.00923764891922474, 0.00922216288745403, 0.00920667685568333, 0.00919120851904154, 0.00917573925107718, 0.00916027557104826, 0.00914481747895479, 0.00912937242537737, 0.00911392737179995, 0.00909849628806114, 0.00908306986093521, 0.00906764529645443, 0.0090522263199091, 0.00903682224452496, 0.00902142189443111, 0.00900601875036955, 0.00899063795804977, 0.00897525250911713, 0.00895986892282963, 0.00894450023770332, 0.00892914645373821, 0.00891378708183765, 0.00889842864125967, 0.00888309255242348, 0.00886775273829699, 0.00885242410004139, 0.00883709918707609, 0.00882178172469139, 0.00880647078156471, 0.00879116263240576, 0.00877586752176285, 0.00876057520508766, 0.00874529127031565, 0.00873001292347908, 0.00871755182743073, 0.00870203878730536, 0.00868653599172831, 0.0086710611358285, 0.00865565985441208, 0.00864026788622141, 0.00862494856119156, 0.00860962644219398, 0.00859436951577663, 0.00857916846871376, 0.00856396369636059, 0.00854883249849081, 0.00853371806442738, 0.0085186529904604, 0.00850363168865442, 0.00848864484578371, 0.0084737129509449, 0.00845878664404154, 0.0084439218044281, 0.00842909887433052, 0.00841430481523275, 0.00839955266565084, 0.00838484428822994, 0.00837015267461538, 0.00835553091019392, 0.00834092311561108, 0.00832637585699558, 0.00831185933202505, 0.00829736888408661, 0.00828293059021235, 0.00826854817569256, 0.00825418438762426, 0.00823986809700727, 0.00822559185326099, 0.00821133982390165, 0.00819711945950985, 0.00818296521902084, 0.00816883984953165, 0.00815473310649395, 0.00814070366322994, 0.0081267012283206, 0.00811272859573364, 0.0080987960100174, 0.00808490719646215, 0.0080710519105196, 0.00805721990764141, 0.00804347824305296, 0.00802973285317421, 0.00801603961735964, 0.00800239015370607, 0.0079887667670846, 0.00797518528997898, 0.00796165037900209, 0.00794814340770245, 0.0079346988350153, 0.00792125333100557, 0.00790789630264044, 0.00789453368633986, 0.00788122788071632, 0.00786796677857637, 0.00785473547875881, 0.00784158147871494, 0.00782842002809048, 0.00781529303640127, 0.00780224893242121, 0.00778919225558639, 0.00777622545138001, 0.00776327308267355, 0.0077503421343863, 0.00773748150095344, 0.00772464647889137, 0.00771184638142586, 0.00769838178530335, 0.00768571300432086, 0.00767316576093435, 0.00766067067161202, 0.00764829758554697, 0.00763595895841718, 0.00762367295101285, 0.00761156063526869, 0.00759944971650839, 0.00758747616782784, 0.00757550494745374, 0.00756365340203047, 0.00755190849304199, 0.00754017988219857, 0.00752860819920897, 0.00751707144081593, 0.00750562269240618, 0.00749422423541546, 0.00748291425406933, 0.00747174397110939, 0.00746057368814945, 0.0074495249427855, 0.00743854511529207, 0.00742763606831431, 0.00741681363433599, 0.00740604382008314, 0.00739539600908756, 0.00738481804728508, 0.00737427454441786, 0.00736387073993683, 0.00735351862385869, 0.00734325451776385, 0.00733304256573319, 0.00732296938076615, 0.00731293158605695, 0.00730294594541192, 0.00729308230802417, 0.00728327082470059, 0.00727358134463429, 0.00726392678916454, 0.0072543416172266, 0.0072448612190783, 0.00723548606038094, 0.00722616259008646, 0.00721690850332379, 0.00720775965601206, 0.00719862803816795, 0.00718963565304875, 0.00718071265146136, 0.00717185996472836, 0.00716309389099479, 0.0071543981321156, 0.00714577175676823, 0.00713725015521049, 0.00712876301258802, 0.00712041510269046, 0.00711210258305073, 0.00710387714207172, 0.00709575600922108, 0.0070876874960959, 0.00707970606163144, 0.00707177631556988, 0.00706396950408816, 0.00705621391534805, 0.00704852864146233, 0.00704100076109171, 0.00703343749046326, 0.00702601345255971, 0.00701871141791344, 0.00701139168813825, 0.00700421212241054, 0.00699748517945409, 0.00699169933795929, 0.00698598334565759, 0.00698037166148424, 0.00697481306269765, 0.00696934061124921, 0.00696393847465515, 0.00695865787565708, 0.00695348251610994, 0.00694834114983678, 0.00694328779354692, 0.0069383205845952, 0.00693342369049788, 0.00692863063886762, 0.00692389067262411, 0.00691925548017025, 0.00691472413018346, 0.00691028032451868, 0.006905906368047, 0.00690161902457476, 0.0068974019959569, 0.00689325435087085, 0.00688917655497789, 0.00688522029668093, 0.00688138650730252, 0.00687755271792412, 0.00687382323667407, 0.00687019806355238, 0.00686662597581744, 0.00686314003542066, 0.00685977702960372, 0.00685644848272204, 0.00685325916856527, 0.00685012200847268, 0.00684705562889576, 0.00684410985559225, 0.00684123439714313, 0.0068384287878871, 0.00683571025729179, 0.00683306157588959, 0.00683051673695445, 0.00682804267853498, 0.00682561984285712, 0.00682333670556545, 0.00682112388312817, 0.00681896321475506, 0.00681690638884902, 0.00681493757292628, 0.00681303814053535, 0.00681122532114387, 0.0068094995804131, 0.00680789677426219, 0.0068063628859818, 0.00680484669283032, 0.00680347019806504, 0.00680216355249286, 0.00680094351992011, 0.00679979333654046, 0.00679873023182154, 0.00679777190089226, 0.00679684849455953, 0.00679606385529041, 0.00679531460627913, 0.00679468689486384, 0.00679411180317402, 0.00679360656067729, 0.00679324008524418, 0.00679292669519782, 0.00679271807894111, 0.00679254345595837, 0.00679250853136182, 0.00679254345595837, 0.00679297931492329, 0.00679349387064576, 0.00679401634261012, 0.00679461751133204, 0.00679522287100554, 0.00679591158404946, 0.00679660867899656, 0.00679736211895943, 0.00679817236959934, 0.0067989956587553, 0.00679988507181406, 0.00680079543963075, 0.00680174911394715, 0.00680278614163399, 0.00680382782593369, 0.00680491235107183, 0.00680607557296753, 0.0068072653375566, 0.00680848956108093, 0.00680974870920181, 0.00681105116382241, 0.00681239319965243, 0.00681378273293376, 0.00681521650403738, 0.00681668845936656, 0.00681820930913091, 0.00681975157931447, 0.00682136788964272, 0.00682301446795464, 0.00682470528408885, 0.00682642636820674, 0.00682820379734039, 0.00683000730350614, 0.00683185458183289, 0.00683379778638482, 0.0068357321433723, 0.0068377279676497, 0.00683973170816898, 0.0068418188020587, 0.00684392731636763, 0.00684607960283756, 0.00684827100485563, 0.00685049314051867, 0.00685279350727797, 0.00685509806498885, 0.00685748131945729, 0.00685987714678049, 0.00686233025044203, 0.00686481827870011, 0.00686734076589346, 0.00686992425471544, 0.00687253382056952, 0.00687520438805223, 0.00687793642282486, 0.0068806940689683, 0.00688347825780511, 0.00688630156219006, 0.00688916770741343, 0.00689209159463644, 0.00689506717026234, 0.00689804693683982, 0.00690110540017486, 0.00690417736768723, 0.00690728751942515, 0.00691047729924321, 0.00691367918625474, 0.00691693788394332, 0.00692022312432528, 0.00692359544336796, 0.00692696729674935, 0.00693041831254959, 0.00693442160263658, 0.00693758064880967, 0.00694071687757969, 0.00694388011470437, 0.00694702984765172, 0.00695017958059907, 0.00695333397015929, 0.00695650186389685, 0.00695965113118291, 0.006962810177356, 0.00696596456691623, 0.00696912314742804, 0.00697227800264955, 0.00697543611750007, 0.006978590041399, 0.00698175374418497, 0.00698490347713232, 0.00698807928711176, 0.00699123786762357, 0.00699439691379666, 0.00699755549430847, 0.00700072292238474, 0.00700387312099338, 0.00700704474002123, 0.00701020332053304, 0.00701337028294802, 0.00701652886345983, 0.00701970513910055, 0.00702286371961236, 0.0070260358043015, 0.00702919438481331, 0.00703236600384116, 0.00703552924096584, 0.00703869620338082, 0.0070418594405055, 0.00704503525048494, 0.00704819802194834, 0.00705138314515352, 0.0070545463822782, 0.00705771800130606, 0.00706088542938232, 0.00706405658274889, 0.00706722447648644, 0.00707040494307876, 0.00707357190549374, 0.00707674818113446, 0.00707991514354944, 0.0070831049233675, 0.00708627654239535, 0.00708945654332638, 0.00709262397140265, 0.00709580909460783, 0.00709898117929697, 0.00710215652361512, 0.00710532860830426, 0.00710850907489657, 0.00711168115958571, 0.00711487419903278, 0.00711805047467351, 0.00712123513221741, 0.00712441094219685, 0.00712759606540203, 0.00713077187538147, 0.00713395653292537, 0.00713714631274343, 0.00714032631367445, 0.00714350678026676, 0.00714670075103641, 0.00714988075196743, 0.00715306121855974, 0.00715624634176493, 0.007159439381212, 0.00716304546222091, 0.00716642150655389, 0.00716980686411262, 0.00717314006760716, 0.00717640249058604, 0.00717963557690382, 0.00718282954767346, 0.00718599231913686, 0.00718915136530995, 0.00719221355393529, 0.00719525897875428, 0.00719824759289622, 0.0072012054733932, 0.00720412936061621, 0.00720699597150087, 0.00720987189561129, 0.00721266446635127, 0.00721542211249471, 0.00721812341362238, 0.00722081121057272, 0.00722343847155571, 0.00722607411444187, 0.00722861848771572, 0.00723114563152194, 0.00723363365978003, 0.00723604671657085, 0.00723846023902297, 0.00724085234105587, 0.00724315689876676, 0.0072454484179616, 0.0072476789355278, 0.00724987080320716, 0.00725201889872551, 0.00725417956709862, 0.00725624477490783, 0.00725829694420099, 0.00726029649376869, 0.00726224388927221, 0.00726416567340493, 0.00726608652621508, 0.00726792123168707, 0.00726970704272389, 0.00727145420387387, 0.00727319251745939, 0.00727484794333577, 0.00727652106434107, 0.00727813690900803, 0.00727968430146575, 0.0072812088765204, 0.00728268548846245, 0.00728413183242083, 0.00728555303066969, 0.00728692067787051, 0.00728823198005557, 0.0072895041666925, 0.00729072839021683, 0.00729194423183799, 0.00729313306510448, 0.00729425251483917, 0.00729533331468701, 0.0072963573038578, 0.00729736778885126, 0.00729832658544183, 0.00729927606880665, 0.00730015663430095, 0.00730099715292454, 0.00730179017409682, 0.00730254827067256, 0.00730326259508729, 0.00730398204177618, 0.00730461766943336, 0.00730339577421546, 0.00730360485613346, 0.00730370916426182, 0.00730374455451965, 0.007303761318326, 0.00730363931506872, 0.00730343023315072, 0.00730315176770091, 0.00730280298739672, 0.00730238435789943, 0.00730187958106399, 0.00730130402371287, 0.00730064231902361, 0.0072998576797545, 0.00729907350614667, 0.00729813287034631, 0.00729717360809445, 0.00729616358876228, 0.00729499571025372, 0.00729375798255205, 0.00729245133697987, 0.00729105668142438, 0.00728964572772384, 0.00728811183944345, 0.00728649133816361, 0.00728476606309414, 0.00728304078802466, 0.007281175814569, 0.00727927638217807, 0.00727725494652987, 0.0072751808911562, 0.00727298529818654, 0.00727073708549142, 0.00726840179413557, 0.00726601481437683, 0.00726355705410242, 0.00726096099242568, 0.00725832907482982, 0.0072555928491056, 0.00725282216444612, 0.00724992901086807, 0.00724700186401606, 0.00724396947771311, 0.00724086724221706, 0.00723766069859266, 0.0072343498468399, 0.00723102083429694, 0.00722764013335109, 0.00722410250455141, 0.00722047733142972, 0.00721681769937277, 0.00721305375918746, 0.00720927212387323, 0.00720536801964045, 0.00720136007294059, 0.00719729997217655, 0.00719318678602576, 0.00718895206227899, 0.00718461256474257, 0.00718027353286743, 0.00717584742233157, 0.00717128114774823, 0.00716664548963308, 0.00716195721179247, 0.00715720001608133, 0.00715233804658055, 0.00714744068682194, 0.00714238686487079, 0.00713729811832309, 0.00713215675204992, 0.00712687661871314, 0.00712255528196692, 0.00711607234552503, 0.00710951955989003, 0.0071028801612556, 0.00709615368396044, 0.00708935689181089, 0.00708250794559717, 0.00707555422559381, 0.00706846173852682, 0.00706135155633092, 0.00705424090847373, 0.00704693933948874, 0.00703960284590721, 0.00703214388340712, 0.00702463230118155, 0.00701710442081094, 0.00700940145179629, 0.00700168125331402, 0.00699383905157447, 0.00698596239089966, 0.00697796326130629, 0.00696989428251982, 0.00696177314966917, 0.00695354770869017, 0.00694525241851807, 0.00693685282021761, 0.00692838337272406, 0.00691987900063396, 0.00691128708422184, 0.00690259085968137, 0.00689379032701254, 0.006884990260005, 0.00687601463869214, 0.00686698779463768, 0.0068579432554543, 0.0068487417884171, 0.00683953985571861, 0.00683018146082759, 0.00682077091187239, 0.00681129051372409, 0.00680175796151161, 0.00679212156683207, 0.00678236223757267, 0.00677256798371673, 0.00676268711686134, 0.00675275363028049, 0.00674271536991, 0.00673257280141115, 0.00672241300344467, 0.006712113507092, 0.00670174416154623, 0.00669134082272649, 0.00668081501498818, 0.00667025381699204, 0.00665953615680337, 0.00664881849661469, 0.00663797836750746, 0.00662705162540078, 0.00661612488329411, 0.00660500722005963, 0.0065938881598413, 0.00658264802768826, 0.00657135527580976, 0.00655995821580291, 0.00654849084094167, 0.00653695408254862, 0.00652534840628505, 0.00651363702490926, 0.00650183903053403, 0.0064900228753686, 0.00647810334339738, 0.00646604364737868, 0.00645414181053638, 0.00644188234582543, 0.00642961310222745, 0.00641730986535549, 0.00640489347279072, 0.00639248546212912, 0.00637999875470996, 0.00636748643592, 0.00635490380227566, 0.00634233094751835, 0.00632967846468091, 0.00631693936884403, 0.00630420912057161, 0.0062914090231061, 0.00627858284860849, 0.00626569520682096, 0.00625274702906609, 0.00623978115618229, 0.00622673705220222, 0.00621367618441582, 0.00620052684098482, 0.00618739565834403, 0.0061742034740746, 0.00616089813411236, 0.00614760164171457, 0.0061342348344624, 0.00612085964530706, 0.00610744953155518, 0.0060939434915781, 0.00608039414510131, 0.00606679264456034, 0.00605317344889045, 0.006039475556463, 0.00602579535916448, 0.00601204577833414, 0.00599819142371416, 0.00598435429856181, 0.00597042124718428, 0.00595648819580674, 0.00594251183792949, 0.00592843955382705, 0.00591435050591826, 0.00590019952505827, 0.00588601361960173, 0.00587176764383912, 0.00585752911865711, 0.00584320444613695, 0.00582880992442369, 0.00581438932567835, 0.00579991610720754, 0.00578541681170464, 0.00577087374404073, 0.00575627898797393, 0.00574163999408484, 0.0057269143871963, 0.00571219716221094, 0.00569738447666168, 0.00568257132545114, 0.00566770602017641, 0.00565277133136988, 0.00563778402283788, 0.0056227445602417, 0.00560770463198423, 0.00559261301532388, 0.00557744316756725, 0.00556225515902042, 0.00554696330800653, 0.0055316798388958, 0.0055163181386888, 0.00550096482038498, 0.0054855328053236, 0.00546834524720907, 0.00545286992564797, 0.00543740345165133, 0.00542192393913865, 0.00540644396096468, 0.00539093418046832, 0.00537542393431067, 0.00535987457260489, 0.00534434337168932, 0.00532878935337067, 0.00531322229653597, 0.00529765617102385, 0.00528206722810864, 0.00526647036895156, 0.00525083346292377, 0.00523521471768618, 0.00521958293393254, 0.00520394183695316, 0.00518827931955457, 0.00517262099310756, 0.00515691516920924, 0.0051412214525044, 0.00512552028521895, 0.00510979257524014, 0.00509406439960003, 0.00507831899449229, 0.00506256055086851, 0.00504678906872869, 0.00503101758658886, 0.00501522421836853, 0.0049994271248579, 0.00498360767960548, 0.00496777892112732, 0.00495192920789123, 0.00493607530370355, 0.00492022559046745, 0.00490434933453798, 0.00488846842199564, 0.00487256236374378, 0.00485664745792747, 0.00484071904793382, 0.00482479529455304, 0.00480884918943048, 0.00479289470240474, 0.00477692252025008, 0.00476092891767621, 0.00474493997171521, 0.00472891563549638, 0.00471291318535805, 0.00469687581062317, 0.00468084355816245, 0.00466477544978261, 0.00464871199801564, 0.00463263085111976, 0.00461655482649803, 0.00460044760257006, 0.00458434084430337, 0.00456821685656905, 0.00455205282196403, 0.00453591533005238, 0.00451974757015705, 0.00450357981026173, 0.00448739901185036, 0.00447120890021324, 0.00445497967302799, 0.00443875975906849, 0.00442253053188324, 0.00440628873184323, 0.00439003389328718, 0.00437377439811826, 0.00435747113078833, 0.00434118136763573, 0.00432739639654756, 0.00431079743430018, 0.00429421570152044, 0.0042776339687407, 0.00426113000139594, 0.00424460973590612, 0.00422815792262554, 0.00421172892674804, 0.00419529527425766, 0.00417892215773463, 0.00416262401267886, 0.00414628582075238, 0.00413000956177711, 0.00411375006660819, 0.00409754691645503, 0.00408136146143079, 0.00406517181545496, 0.00404908275231719, 0.00403300579637289, 0.00401691673323512, 0.00400090124458075, 0.00398488529026508, 0.00396893080323935, 0.0039530242793262, 0.00393708329647779, 0.00392121588811278, 0.00390540109947324, 0.00388955976814032, 0.00387378805316985, 0.00385805149562657, 0.00384234124794602, 0.00382666103541851, 0.003810980822891, 0.0037953625433147, 0.00377977779135108, 0.0037641937378794, 0.00374868791550398, 0.00373321305960417, 0.00371772469952703, 0.00370229291729629, 0.00368689186871052, 0.00367149943485856, 0.00365617661736906, 0.00364085822366178, 0.00362557917833328, 0.00361035251989961, 0.00359510793350637, 0.0035799378529191, 0.00356478476896882, 0.00354963215067983, 0.00353457499295473, 0.00351948314346373, 0.00350446556694806, 0.00348948244936764, 0.00347448233515024, 0.00345955579541624, 0.00344462972134352, 0.00342979514971375, 0.00341496430337429, 0.00340011669322848, 0.00338536035269499, 0.003370625898242, 0.00335587398149073, 0.00334122637286782, 0.00332654407247901, 0.00331193604506552, 0.00329734943807125, 0.00328276725485921, 0.00326823303475976, 0.00325377751141787, 0.00323928683064878, 0.0032248969655484, 0.00321088568307459, 0.00319710071198642, 0.00318333366885781, 0.00316953146830201, 0.00315597304143012, 0.00314239761792123, 0.00312885688617826, 0.00311549054458737, 0.00310215866193175, 0.00308884447440505, 0.0030756697524339, 0.00306247756816447, 0.00304945977404714, 0.00303651113063097, 0.00302351079881191, 0.00301070208661258, 0.00299792806617916, 0.00298522366210818, 0.00297262403182685, 0.00296005932614207, 0.00294754654169083, 0.00293517322279513, 0.00292283529415727, 0.00291053159162402, 0.00289840251207352, 0.00288625597022474, 0.00287416181527078, 0.00286222412250936, 0.00285035627894104, 0.00283847120590508, 0.00282670790329576, 0.00281506683677435, 0.0028034255374223, 0.0027918538544327, 0.00278042210265994, 0.00276900734752417, 0.00275766220875084, 0.00274636968970299, 0.00273519870825112, 0.00272411527112126, 0.00271306675858796, 0.00270207016728818, 0.00269121304154396, 0.00268037361092865, 0.0026696037966758, 0.00265897321514785, 0.002648307941854, 0.00263779959641397, 0.00262736086733639, 0.00261688698083162, 0.00260664010420442, 0.00259641045704484, 0.00258616334758699, 0.00257609062828124, 0.0025660702958703, 0.00255610211752355, 0.00254620332270861, 0.00253644422627985, 0.00252666766755283, 0.0025169956497848, 0.00250742840580642, 0.0024978609289974, 0.0024883805308491, 0.00247905729338527, 0.00246971612796187, 0.00246049743145704, 0.00245127850212157, 0.00244223396293819, 0.00243320688605309, 0.00242428411729634, 0.00241537904366851, 0.0024053156375885, 0.00239721196703613, 0.0023893523029983, 0.00238149287179112, 0.00237366789951921, 0.00236598262563348, 0.00235840165987611, 0.00235082115978003, 0.00234337989240885, 0.00233604316599667, 0.00232875836081803, 0.00232156133279204, 0.00231441599316895, 0.00230735819786787, 0.00230037001892924, 0.00229352107271552, 0.00228668935596943, 0.00228001503273845, 0.00227332301437855, 0.00226675299927592, 0.00226030498743057, 0.00225390936248004, 0.00224753096699715, 0.00224132719449699, 0.00223517511039972, 0.00222907587885857, 0.00222308095544577, 0.00221712072379887, 0.00221131788566709, 0.00220558419823647, 0.00219981581903994, 0.00219427398405969, 0.00218880176544189, 0.00218331231735647, 0.00217799725942314, 0.00217273412272334, 0.00216752337291837, 0.00216239993460476, 0.00215739849954844, 0.00215239683166146, 0.00214760447852314, 0.00214277696795762, 0.00213805446401238, 0.00213345349766314, 0.00212892261333764, 0.00212444365024567, 0.00212006969377398, 0.00211576512083411, 0.00211151293478906, 0.00210738275200129, 0.00210337433964014, 0.00209934893064201, 0.00209546275436878, 0.00209168111905456, 0.00208788178861141, 0.00208427454344928, 0.00208064983598888, 0.00207718159072101, 0.00207376596517861, 0.00207047234289348, 0.00206712633371353, 0.00206398940645158, 0.00206086994148791, 0.00205792486667633, 0.0020549448672682, 0.00205208687111735, 0.00204933318309486, 0.00204668450169265, 0.00204403535462916, 0.00204154336825013, 0.00203906861133873, 0.00203659432008862, 0.0020343461073935, 0.0020321502815932, 0.0020300589967519, 0.0020280028693378, 0.0020260508172214, 0.00202408153563738, 0.00202230410650373, 0.00202050898224115, 0.00201880093663931, 0.00201714551076293, 0.00201559462584555, 0.00201407843269408, 0.00201264931820333, 0.00201129005290568, 0.00201000063680112, 0.0020087631419301, 0.00200759572908282, 0.00200648023746908, 0.00200550421141088, 0.00200452841818333, 0.00200367462821305, 0.00200285553000867, 0.00200208858586848, 0.00200142641551793, 0.00200081639923155, 0.00200025876984, 0.0019997707568109, 0.00199940497986972, 0.0019990389700979, 0.00199881219305098, 0.00199858588166535, 0.00199849857017398, 0.00199839426204562, 0.0019984117243439, 0.00199846364557743, 0.00199860334396362, 0.00199884711764753, 0.00199910858646035, 0.00199949205853045, 0.0019998752977699, 0.002000363310799, 0.00200090347789228, 0.00200153095647693, 0.00200224528089166, 0.00200301222503185, 0.00200379639863968, 0.00200470280833542, 0.00200567860156298, 0.002006707014516, 0.0020078222732991, 0.00200902437791228, 0.00201020948588848, 0.0020115515217185, 0.00201291078701615, 0.00201439205557108, 0.00201583839952946, 0.00201745936647058, 0.00201909733004868, 0.00202080537565053, 0.002022635191679, 0.00202446477487683, 0.00202641682699323, 0.00202836864627898, 0.00203045993112028, 0.00203256844542921, 0.00203479919582605, 0.00203704740852118, 0.00203938246704638, 0.00204175268299878, 0.0020442446693778, 0.00204843655228615, 0.00205110292881727, 0.00205385638400912, 0.00205662730149925, 0.00205946783535182, 0.00206234329380095, 0.00206525344401598, 0.00206826836802065, 0.00207126582972705, 0.00207438552752137, 0.00207753968425095, 0.00208074622787535, 0.00208397023379803, 0.00208731624297798, 0.00209064478985965, 0.00209407764486969, 0.00209754589013755, 0.00210104859434068, 0.00210460368543863, 0.00210821093060076, 0.00211194041185081, 0.00211565243080258, 0.00211945152841508, 0.00212330278009176, 0.00212718918919563, 0.00213116244412959, 0.00213513593189418, 0.00213921372778714, 0.00214325683191419, 0.00214743916876614, 0.00215163920074701, 0.00215590884909034, 0.00216023065149784, 0.00216458737850189, 0.00216904864646494, 0.00217349245212972, 0.00217805849388242, 0.0021826068405062, 0.00218724249862134, 0.0021919128485024, 0.00219665304757655, 0.00220146286301315, 0.00220629037357867, 0.0022112219594419, 0.00221618870273232, 0.00222120760008693, 0.00222626165486872, 0.00223136763088405, 0.0022365259937942, 0.0022417192813009, 0.0022470171097666, 0.00225233216769993, 0.00225773453712463, 0.00226317183114588, 0.00226866127923131, 0.0022742033470422, 0.00227977964095771, 0.00228544347919524, 0.00229108985513449, 0.00229687546379864, 0.00230266153812408, 0.00230853422544897, 0.0023144418373704, 0.00232043699361384, 0.002326431684196, 0.00233247876167297, 0.0023386653047055, 0.0023448346182704, 0.00235103839077055, 0.00235731224529445, 0.00236367294564843, 0.0023700341116637, 0.00237701181322336, 0.00238387798890471, 0.00239077932201326, 0.00239770207554102, 0.0024046425241977, 0.00241161952726543, 0.0024186025839299, 0.00242560380138457, 0.00243264203891158, 0.00243971450254321, 0.00244680931791663, 0.00245392392389476, 0.00246105925180018, 0.00246824463829398, 0.00247541908174753, 0.00248263077810407, 0.00248984317295253, 0.00249710935167968, 0.00250439485535026, 0.00251171970739961, 0.00251904665492475, 0.00252642692066729, 0.00253381044603884, 0.00254121399484575, 0.00254865316674113, 0.00255611166357994, 0.00256357272155583, 0.00257107289507985, 0.00257860776036978, 0.00258616241626441, 0.00259375618770719, 0.00260136974975467, 0.00260900286957622, 0.00261665135622025, 0.00262434082105756, 0.00263203284703195, 0.00263974186964333, 0.00264749070629478, 0.00265527376905084, 0.00266307895071805, 0.00267090578563511, 0.00267876544967294, 0.00268664699979126, 0.00269454577937722, 0.00270246830768883, 0.0027104236651212, 0.00271835108287632, 0.00272636534646153, 0.0027343793772161, 0.00274243322201073, 0.00275050615891814, 0.00275861844420433, 0.00276673072949052, 0.00277488003484905, 0.00278304889798164, 0.00279123964719474, 0.00279943039640784, 0.00280767539516091, 0.00281594018451869, 0.00282424432225525, 0.00283256568945944, 0.00284090894274414, 0.0028492717538029, 0.0028576694894582, 0.00286608655005693, 0.00287452549673617, 0.00288294930942357, 0.00289144506677985, 0.00289995805360377, 0.00290849315933883, 0.00291706505231559, 0.00292351329699159, 0.00293210474774241, 0.00294071575626731, 0.00294926390051842, 0.00295781181193888, 0.00296636181883514, 0.00297487922944129, 0.00298339896835387, 0.00299186632037163, 0.00300035555846989, 0.00300879683345556, 0.00301727512851357, 0.00302568357437849, 0.00303410924971104, 0.00304248975589871, 0.00305087002925575, 0.00305921724066138, 0.00306754978373647, 0.00307590398006141, 0.0030841906554997, 0.00309251202270389, 0.00310078542679548, 0.00310905883088708, 0.00311728427186608, 0.00312552764080465, 0.00313373771496117, 0.00314195244573057, 0.00315011688508093, 0.00315828155726194, 0.00316643295809627, 0.00317456922493875, 0.0031826903577894, 0.00319077633321285, 0.00319888442754745, 0.00320694455876946, 0.00321502168662846, 0.00322304898872972, 0.00323107652366161, 0.00323907542042434, 0.00324707455001771, 0.00325503875501454, 0.00326300715096295, 0.00327092781662941, 0.00327885057777166, 0.00328677101060748, 0.00329464604146779, 0.00330253806896508, 0.00331038050353527, 0.00331824226304889, 0.00332605605944991, 0.003333889413625, 0.00334168830886483, 0.00334947137162089, 0.00335722439922392, 0.0033649445977062, 0.00337269948795438, 0.00338038709014654, 0.00338811590336263, 0.00339579279534519, 0.00340346922166646, 0.0034111151471734, 0.00341874407604337, 0.00342635973356664, 0.00343397748656571, 0.00344154518097639, 0.00344909750856459, 0.0034566696267575, 0.00346418935805559, 0.00347173330374062, 0.00347922439686954, 0.00348672037944198, 0.00349417678080499, 0.00350188137963414, 0.00350893917493522, 0.00351599720306695, 0.00352300284430385, 0.00352993863634765, 0.0035368399694562, 0.00354370614513755, 0.00355048524215817, 0.00355724664404988, 0.00356393889524043, 0.00357056106440723, 0.00357720092870295, 0.00358371855691075, 0.00359025341458619, 0.00359670142643154, 0.00360313220880926, 0.00360949290916324, 0.00361578399315476, 0.00362205761484802, 0.00362824415788054, 0.00363443093374372, 0.0036405127029866, 0.00364659493789077, 0.00365260732360184, 0.003658602014184, 0.00366447493433952, 0.0036703827790916, 0.00367618585005403, 0.00368197145871818, 0.00368767022155225, 0.00369336898438632, 0.00369898020289838, 0.00370455719530582, 0.0037101162597537, 0.00371555308811367, 0.00372102530673146, 0.00372637575492263, 0.00373169081285596, 0.00373698910698295, 0.00374223431572318, 0.00374742737039924, 0.00375258573330939, 0.00375763978809118, 0.00376271060667932, 0.00376769504509866, 0.00377264455892146, 0.00377748883329332, 0.00378233357332647, 0.00378714362159371, 0.00379188382066786, 0.00379662355408072, 0.0038012417498976, 0.00380587787367404, 0.00381042622029781, 0.00381490518338978, 0.00381936621852219, 0.0038237227126956, 0.00382811459712684, 0.00383241847157478, 0.00383667112328112, 0.00384087092243135, 0.0038450884167105, 0.00384916621260345, 0.00385324424132705, 0.003857217496261, 0.00386120821349323, 0.00386511185206473, 0.00386898079887033, 0.0038727973587811, 0.00387657852843404, 0.00388030800968409, 0.00388562097214162, 0.00388893228955567, 0.00389217352494597, 0.00389531045220792, 0.00389849906787276, 0.00390147953294218, 0.00390449445694685, 0.00390737038105726, 0.00391029752790928, 0.00391306867823005, 0.00391571782529354, 0.00391843589022756, 0.00392103241756558, 0.00392352463677526, 0.00392601639032364, 0.0039284392260015, 0.00393077451735735, 0.0039330399595201, 0.00393525324761868, 0.00393739668652415, 0.0039394530467689, 0.00394152710214257, 0.0039434963837266, 0.00394530827179551, 0.00394717324525118, 0.00394895067438483, 0.00395064102485776, 0.00395219260826707, 0.0039538131095469, 0.00395531207323074, 0.00395672349259257, 0.00395815214142203, 0.00395944248884916, 0.00396066159009933, 0.00396188162267208, 0.00396290980279446, 0.00396397337317467, 0.00396496616303921, 0.00396595988422632, 0.00396677851676941, 0.00396751053631306, 0.0039683124050498, 0.00396895688027143, 0.00396951474249363, 0.00397007213905454, 0.00397056061774492, 0.00397092616185546, 0.00397127494215965, 0.00397158833220601, 0.00397176248952746, 0.00397190218791366, 0.00397205911576748, 0.00397205911576748, 0.00397195434197783, 0.00397183233872056, 0.0039717280305922, 0.00397148448973894, 0.00397110031917691, 0.00397078692913055, 0.00397035153582692, 0.00396986305713654, 0.003969288431108, 0.00396866071969271, 0.00396796362474561, 0.0039671971462667, 0.00396639527752995, 0.00396548956632614, 0.00396453030407429, 0.00396351981908083, 0.00396249163895845, 0.00396134192124009, 0.0039600869640708, 0.00395646225661039, 0.00395487621426582, 0.00395322032272816, 0.00395158212631941, 0.00394987454637885, 0.0039480272680521, 0.00394614553079009, 0.00394422840327024, 0.00394220696762204, 0.00394011521711946, 0.00393802393227816, 0.00393579341471195, 0.0039335279725492, 0.00393115822225809, 0.00392882293090224, 0.00392631301656365, 0.00392376910895109, 0.00392118981108069, 0.00391850620508194, 0.00391578720882535, 0.00391303421929479, 0.003910175524652, 0.00390721298754215, 0.00390428537502885, 0.00390114868059754, 0.00389804667793214, 0.0038948399014771, 0.00389159866608679, 0.00388832204043865, 0.00388487195596099, 0.00388149078935385, 0.00387790123932064, 0.00387431099079549, 0.00387072120793164, 0.0038669912610203, 0.00386319239623845, 0.0038592885248363, 0.0038554547354579, 0.00385148148052394, 0.00384736876003444, 0.00384332588873804, 0.00383910839445889, 0.00383492582477629, 0.00383053417317569, 0.00382621237076819, 0.00382171594537795, 0.00381725491024554, 0.0038126886356622, 0.00380808813497424, 0.00380334793590009, 0.00379857327789068, 0.00379376322962344, 0.00378884887322783, 0.00378386443480849, 0.00377888046205044, 0.00377372186630964, 0.00376859842799604, 0.00376337068155408, 0.00375817669555545, 0.00375270540826023, 0.00374730303883553, 0.00374183082021773, 0.00373628875240684, 0.00373060721904039, 0.00372503092512488, 0.00371924508363008, 0.00371342455036938, 0.00370749947614968, 0.00370160909369588, 0.00369557924568653, 0.00368947954848409, 0.00368191953748465, 0.00367554114200175, 0.00366897112689912, 0.00366245373152196, 0.00365574425086379, 0.00364919169805944, 0.0036423949059099, 0.00363566842861474, 0.00362874963320792, 0.00362191861495376, 0.00361493020318449, 0.00360797694884241, 0.00360088399611413, 0.00359382596798241, 0.00358659378252923, 0.0035794663708657, 0.00357216433621943, 0.00356491468846798, 0.00355745595879853, 0.0035500843077898, 0.00354257319122553, 0.00353507976979017, 0.00352741195820272, 0.00351983122527599, 0.00351211102679372, 0.00350440805777907, 0.00349654862657189, 0.0034887760411948, 0.00348077737726271, 0.00347288302145898, 0.00346477935090661, 0.00345676275901496, 0.00344858970493078, 0.00344048603437841, 0.00343220843933523, 0.00342398299835622, 0.00341558293439448, 0.00340725271962583, 0.0033987311180681, 0.00339027890004218, 0.0033817223738879, 0.00337307853624225, 0.00336441723629832, 0.00335573870688677, 0.00334692071191967, 0.00333811994642019, 0.00332926702685654, 0.00332027487456799, 0.00331135233864188, 0.00330232502892613, 0.00329319341108203, 0.00328406132757664, 0.00327486009337008, 0.00326564116403461, 0.00325630023144186, 0.00324688968248665, 0.00323753175325692, 0.0032281035091728, 0.00321855349466205, 0.00320900371298194, 0.003199314000085, 0.00318967713974416, 0.00317990034818649, 0.00317010655999184, 0.00316031253896654, 0.00315043167211115, 0.00314048072323203, 0.00313047738745809, 0.00312040490098298, 0.00311029702425003, 0.00310013722628355, 0.00309726502746344, 0.00308674783445895, 0.00307615660130978, 0.00306556094437838, 0.00305493036285043, 0.00304430862888694, 0.00303359958343208, 0.00302291684783995, 0.00301218195818365, 0.00300145545043051, 0.00299063767306507, 0.00297985482029617, 0.0029690193478018, 0.00295815360732377, 0.00294726621359587, 0.0029363741632551, 0.00292539945803583, 0.00291446410119534, 0.00290345889516175, 0.00289244926534593, 0.00288139609619975, 0.0028703473508358, 0.00285923341289163, 0.00284811900928617, 0.00283696572296321, 0.00282581266947091, 0.0028145806863904, 0.00280337524600327, 0.00279211741872132, 0.00278083793818951, 0.0027695233002305, 0.00275821750983596, 0.00274683767929673, 0.00273545365780592, 0.00272405170835555, 0.00271264580078423, 0.00270114373415709, 0.00268967263400555, 0.00267814891412854, 0.002666634041816, 0.00265502766706049, 0.0026434559840709, 0.00263183214701712, 0.00262019550427794, 0.00260850181803107, 0.00259682117030025, 0.00258507556281984, 0.0025733383372426, 0.002561557572335, 0.00254975957795978, 0.00253792246803641, 0.00252608046866953, 0.00251416489481926, 0.00250227958895266, 0.00249033351428807, 0.00247840886004269, 0.00246638851240277, 0.00245439866557717, 0.00244235224090517, 0.00243028393015265, 0.00241818092763424, 0.00240608653984964, 0.00239393580704927, 0.00238176272250712, 0.00236955541186035, 0.0023573562502861, 0.00234508770518005, 0.00233282777480781, 0.00232051126658916, 0.00230821198783815, 0.00229582143947482, 0.00228347419761121, 0.00226250127889216, 0.00225007976405323, 0.00223766732960939, 0.0022253030911088, 0.0022129078861326, 0.0022005217615515, 0.00218814425170422, 0.00217578397132456, 0.00216343277134001, 0.00215110299177468, 0.00213876483030617, 0.00212648743763566, 0.00211415765807033, 0.00210186303593218, 0.00208957679569721, 0.00207728613168001, 0.00206502643413842, 0.00205277954228222, 0.00204053265042603, 0.00202827295288444, 0.0020160477142781, 0.00200382270850241, 0.00199166289530694, 0.00197945977561176, 0.00196726946160197, 0.00195509660989046, 0.00194293691311032, 0.00193075113929808, 0.00191861751955003, 0.00190647528506815, 0.00189435039646924, 0.00188223866280168, 0.00187011796515435, 0.00185806734953076, 0.00184595980681479, 0.00183388288132846, 0.00182181468699127, 0.00180976383853704, 0.00179770437534899, 0.00178568833507597, 0.00177365506533533, 0.00176163902506232, 0.00174964917823672, 0.00173766387160867, 0.00172566971741617, 0.0017136886017397, 0.00170172052457929, 0.00168976990971714, 0.00167782814241946, 0.0016658817185089, 0.00165394868236035, 0.00164203287567943, 0.00163016503211111, 0.00161827111151069, 0.00160639022942632, 0.00159450492355973, 0.00158264150377363, 0.00157078250776976, 0.00155891897156835, 0.00154708605259657, 0.00153527478687465, 0.00152345059905201, 0.00151164387352765, 0.00149986741598696, 0.00148809980601072, 0.00147631473373622, 0.00146454281639308, 0.00145279709249735, 0.00144105544313788, 0.00142930529545993, 0.00141758553218096, 0.00140653131529689, 0.00139513402245939, 0.00138378911651671, 0.0013724616728723, 0.00136116880457848, 0.00134992855601013, 0.00133874034509063, 0.0013275349047035, 0.00131641642656177, 0.00130535021889955, 0.00129428412765265, 0.00128328765276819, 0.00127232621889561, 0.00126141693908721, 0.00125049019698054, 0.00123966799583286, 0.00122884591110051, 0.00121804117225111, 0.0012073409743607, 0.00119660596828908, 0.0011859581572935, 0.00117532757576555, 0.00116473203524947, 0.00115427596028894, 0.00114373245742172, 0.00113324145786464, 0.00112285499926656, 0.00111245107837021, 0.00110213423613459, 0.00109181751031429, 0.00108155305497348, 0.00107132340781391, 0.00106114614754915, 0.00105102092493325, 0.001040895935148, 0.00103082309942693, 0.00102080253418535, 0.00101081689354032, 0.00100086617749184, 0.000990950269624591, 0.00098105170764029, 0.000971222878433764, 0.000961463723797351, 0.000951722089666873, 0.000941997801419348, 0.00093230843776837, 0.000922688690479845, 0.000913069059606642, 0.00090346671640873, 0.000893986492883414, 0.00088447134476155, 0.000875078258104622, 0.000865632784552872, 0.000856309314258397, 0.000847003364469856, 0.000837679952383041, 0.000828461023047566, 0.000819242210127413, 0.000810058147180825, 0.000800926412921399, 0.000791829545050859, 0.000782802351750433, 0.000773757812567055, 0.000764852564316243, 0.000755895103793591, 0.000747007376048714, 0.000738154456485063, 0.000729301536921412, 0.000720553216524422, 0.000711804896127433, 0.000703108846209943, 0.000694430200383067, 0.000693073496222496, 0.000684882805217057, 0.000676692114211619, 0.000668623426463455, 0.00066055468050763, 0.000652573071420193, 0.000644574116449803, 0.000636731914710253, 0.000628854846581817, 0.000621030107140541, 0.00061332737095654, 0.000605589768383652, 0.000597974110860378, 0.000590393377933651, 0.000582812586799264, 0.000575336453039199, 0.000567860144656152, 0.0005605059559457, 0.000553116900846362, 0.000545815040823072, 0.000538617605343461, 0.000531402823980898, 0.000524292583577335, 0.000517164939083159, 0.000510141835547984, 0.000503118732012808, 0.000496165303047746, 0.000489316531457007, 0.000482450268464163, 0.000475618813652545, 0.000468874583020806, 0.00046219999785535, 0.000455542933195829, 0.000448955484898761, 0.000442385498899966, 0.00043590264976956, 0.000429454608820379, 0.000423076300648972, 0.00041676772525534, 0.000410459149861708, 0.000404202844947577, 0.000398033647798002, 0.000391881912946701, 0.000385799881769344, 0.000379752716980875, 0.000373810064047575, 0.000367850007023662, 0.000361907383194193, 0.000356121629010886, 0.000350318412529305, 0.000344619795214385, 0.000338886282406747, 0.000333257339661941, 0.000327715533785522, 0.000322121486533433, 0.000316701654810458, 0.000311229552607983, 0.000305827183183283, 0.000300494488328695, 0.000295214093057439, 0.000289951130980626, 0.000284740439383313, 0.000279669184237719, 0.000274545600404963, 0.000269526615738869, 0.000264542497461662, 0.000259645486949012, 0.000254696205956861, 0.000249903765507042, 0.000245111354161054, 0.000240388617385179, 0.00022984528914094, 0.000225505966227502, 0.000221306021558121, 0.000217001550481655, 0.000212801634916104, 0.000208688841667026, 0.00020455862977542, 0.000200498136109672, 0.000196472479728982, 0.000192516556126066, 0.000188578036613762, 0.000184622083907016, 0.000180770715815015, 0.000176989051396959, 0.000173189953784458, 0.00016947797848843, 0.000165818302775733, 0.000162141193868592, 0.000158533803187311, 0.000154996116179973, 0.000151493281009607, 0.000148042716318741, 0.000144539881148376, 0.000141193901072256, 0.00013786532508675, 0.000134519330458716, 0.000131260472699068, 0.000128106170450337, 0.000124847327242605, 0.000121710443636402, 0.000118678151920903, 0.000115628412459046, 0.000112613532110117, 0.000109668362711091, 0.000106723193312064, 0.000103865153505467, 0.000100954835943412, 9.82362180366181e-05, 9.54827482928522e-05, 9.27292785490863e-05, 9.00977975106798e-05, 8.74663019203581e-05, 8.48174022394232e-05, 8.23253285489045e-05, 7.98681139713153e-05, 7.73411957197823e-05, 7.49362661736086e-05, 7.25661884644069e-05, 7.02309625921771e-05, 6.79828735883348e-05, 6.56824995530769e-05, 6.35215474176221e-05, 6.13431766396388e-05, 5.92170763411559e-05, 5.71606833545957e-05, 5.51565717614722e-05, 5.31350378878415e-05, 5.11832076881547e-05, 4.93185143568553e-05, 4.7418969188584e-05, 4.55891276942566e-05, 4.38115712313447e-05, 4.20688666054048e-05, 4.03958765673451e-05, 3.86880237783771e-05, 3.71544410882052e-05, 3.55163028871175e-05, 3.40175756718963e-05, 3.25711334880907e-05, 3.11246913042851e-05, 2.9695673219976e-05, 2.8336364266579e-05, 2.92947479465511e-05, 2.81968477793271e-05, 2.71272692771163e-05, 2.60337255895138e-05, 2.5001176254591e-05, 2.40034823946189e-05, 2.29796460189391e-05, 2.20080946746748e-05, 2.10343605431262e-05, 2.00867689272854e-05, 1.91936360351974e-05, 1.82678286364535e-05, 1.73790522239869e-05, 1.65469136845786e-05, 1.56799233081983e-05, 1.48564986375277e-05, 1.40809979711776e-05, 1.32619297801284e-05, 1.25103915706859e-05, 1.17871713882778e-05, 1.10443461380783e-05, 1.03538022813154e-05, 9.63929596764501e-06, 8.98796315595973e-06, 8.36494837130886e-06, 7.70272345107514e-06, 7.12109795131255e-06, 6.55254325465648e-06, 5.95566916672396e-06, 5.43068108527223e-06, 4.9274776756647e-06, 4.39377618022263e-06, 3.9276046663872e-06, 3.47232480635284e-06, 2.99308317153191e-06, 2.59226226262399e-06, 2.15658815250208e-06, 1.77755146069103e-06, 1.43336865221499e-06, 1.06740185401577e-06, 7.45003205793182e-07, 4.66171513835434e-07, 1.52485554849591e-07, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 2.2655071063582e-07, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 6.97079158840097e-08, 6.5351164479921e-09, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 6.5351164479921e-09, 7.18862835924483e-08, 4.48744657433053e-07, 3.26755838386816e-07, 2.39620931097306e-07, 1.65556301112701e-07, 8.71349286057921e-08, 3.26756222079894e-08, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 4.35675318044559e-08, 1.06740380090287e-07, 1.80804974547755e-07, 2.72296716730125e-07, 3.72501801848557e-07, 4.79242089568288e-07, 6.05587558766274e-07, 7.36289848646265e-07, 8.73527312705846e-07, 1.02165654425335e-06, 1.18939146886987e-06, 1.3549476989283e-06, 1.54228769133624e-06, 1.7405194512321e-06, 1.95182155948714e-06, 2.15876707443385e-06, 2.38967459154082e-06, 2.64018740381289e-06, 2.8906997613376e-06, 3.12160727844457e-06, 3.39608232025057e-06, 3.67927077604691e-06, 3.97335088564432e-06, 4.27396616942133e-06, 4.57893838756718e-06, 4.90787260787329e-06, 5.23462858836865e-06, 5.57663270228659e-06, 5.93388631386915e-06, 6.29985242994735e-06, 6.68106758894282e-06, 7.06446144249639e-06, 7.45438956073485e-06, 7.86610235081753e-06, 8.28652810014319e-06, 8.71348765940638e-06, 9.15569762582891e-06, 9.58919372351374e-06, 1.00488314274116e-05, 1.05215367511846e-05, 1.10160281110439e-05, 1.15105176519137e-05, 1.20006525321514e-05, 1.25169262901181e-05, 1.30419148263172e-05, 1.35799718918861e-05, 1.41245654958766e-05, 1.46713373396778e-05, 1.52398915815866e-05, 1.58280527102761e-05, 1.64140346896602e-05, 1.70130861079087e-05, 1.76426347024972e-05, 1.8263472156832e-05, 1.88973790500313e-05, 1.79411345015978e-05, 1.8690496290219e-05, 1.95095672097523e-05, 2.03460640477715e-05, 2.11738479265478e-05, 2.20277725020424e-05, 2.28816988965264e-05, 2.37879048654577e-05, 2.47376774495933e-05, 2.5661311156e-05, 2.6645937396097e-05, 2.76479931926588e-05, 2.86326194327557e-05, 2.96869566227542e-05, 3.07238660752773e-05, 3.1795625545783e-05, 3.28935311699752e-05, 3.40262886311393e-05, 3.51590460923035e-05, 3.63266590284184e-05, 3.74942683265544e-05, 3.8722875615349e-05, 3.99514829041436e-05, 4.11539476772305e-05, 4.24348399974406e-05, 4.3750576878665e-05, 4.50314655608963e-05, 4.63820651930291e-05, 4.77239409519825e-05, 4.91181053803302e-05, 5.0512269808678e-05, 5.19238637934905e-05, 5.33615930180531e-05, 5.48341777175665e-05, 5.63154790143017e-05, 5.78141989535652e-05, 5.93390686844941e-05, 6.0890077293152e-05, 6.2475934100803e-05, 6.40966463834047e-05, 6.56825068290345e-05, 6.73206595820375e-05, 6.89413718646392e-05, 7.06317950971425e-05, 7.23396442481317e-05, 7.40474861231633e-05, 7.57902016630396e-05, 7.75677544879727e-05, 7.93278886703774e-05, 8.1157726526726e-05, 8.29701457405463e-05, 8.48174167913385e-05, 8.66995251271874e-05, 8.85816552909091e-05, 9.04812040971592e-05, 9.24504565773532e-05, 9.43848572205752e-05, 9.63715428952128e-05, 9.83408026513644e-05, 0.00010037976608146, 0.000102436155430041, 0.000104509970697109, 0.00010656636004569, 0.000108675041701645, 0.000110766282887198, 0.000112944660941139, 0.00011512303899508, 0.000117301417049021, 0.000119532094686292, 0.000121762750495691, 0.000123993420857005, 0.000126276354421861, 0.000131191292894073, 0.000133700799779035, 0.000136262591695413, 0.000138789531774819, 0.000141386146424338, 0.000144000237924047, 0.000146579433931038, 0.000149263214552775, 0.000151894710143097, 0.000154630761244334, 0.000157366826897487, 0.000160085444804281, 0.000162873795488849, 0.000165696983458474, 0.000168485319591127, 0.000171325940755196, 0.000174201428308152, 0.000177094319951721, 0.000180022077984177, 0.000182932402822189, 0.000185895012691617, 0.000188892459846102, 0.000191889936104417, 0.000194957101484761, 0.00019802428141702, 0.00020107401360292, 0.000204210911761038, 0.000207312928978354, 0.000210484664421529, 0.000213673818507232, 0.000216880405787379, 0.000220087007619441, 0.000223345879931003, 0.000226622170885094, 0.000229915880481713, 0.000233261918765493, 0.000236555628362112, 0.000239953908021562, 0.000243352216784842, 0.000246785348281264, 0.000250218465225771, 0.000253686477662995, 0.000257189298281446, 0.000260674743913114, 0.000264212460024282, 0.000267785013420507, 0.000271392433205619, 0.000274982390692458, 0.0002786421100609, 0.000282266933936626, 0.000285978894680738, 0.000289673480438069, 0.000293402845272794, 0.000297149701509625, 0.000300931365927681, 0.000304730492644012, 0.000308564456645399, 0.000312450691126287, 0.000316267251037061, 0.00032020578510128, 0.000324126856867224, 0.000328047957736999, 0.000332038762280717, 0.000336029566824436, 0.000340055237757042, 0.000344115745974705, 0.00034814141690731, 0.000352254224708304, 0.00035638443659991, 0.000360497244400904, 0.000364662322681397, 0.000367423112038523, 0.000371814734535292, 0.000376197625882924, 0.000380632816813886, 0.000385050574550405, 0.000389503198675811, 0.000393973226891831, 0.00039844328421168, 0.000402965553803369, 0.000407470448408276, 0.000411992776207626, 0.000416549941292033, 0.00042110713548027, 0.00042568170465529, 0.000430291169323027, 0.000434909365139902, 0.000439527531852946, 0.000444180535851046, 0.000448824837803841, 0.000453503977041692, 0.00045819187653251, 0.000462914613308385, 0.00046763735008426, 0.000472394953249022, 0.00047713506501168, 0.000481927505461499, 0.000486702541820705, 0.000491512357257307, 0.000496339693199843, 0.000501158297993243, 0.000506037846207619, 0.000510908721480519, 0.000515797000844032, 0.000520711357239634, 0.000525625830050558, 0.000530548975802958, 0.000535533123183995, 0.000540491077117622, 0.000545484013855457, 0.00055047677597031, 0.000555521924979985, 0.000560549611691386, 0.000565559952519834, 0.000570666044950485, 0.000575746002141386, 0.000580843421630561, 0.00058595824521035, 0.000591107935179025, 0.000596240221057087, 0.000601389911025763, 0.000606591871473938, 0.000611776427831501, 0.000617013254668564, 0.000622241350356489, 0.000627469446044415, 0.000632758601568639, 0.000638030294794589, 0.000643328123260289, 0.00064865208696574, 0.00065394991543144, 0.000659317418467253, 0.00066467619035393, 0.000670061155688018, 0.000675446121022105, 0.000680848548654467, 0.000686277053318918, 0.00069173175143078, 0.000697186391334981, 0.000702649762388319, 0.000708174135070294, 0.000713672314304858, 0.000720152456779033, 0.000725746445823461, 0.000731357897166163, 0.000736960675567389, 0.000742572185117751, 0.000748175021726638, 0.000753777741920203, 0.000759389251470566, 0.000765000702813268, 0.000770620943512768, 0.000776223721913993, 0.000781843962613493, 0.000787464086897671, 0.000793075596448034, 0.000798713241238147, 0.000804333423729986, 0.000809953606221825, 0.000815591251011938, 0.000821211433503777, 0.000826840347144753, 0.000832477991934866, 0.000838106847368181, 0.000843727088067681, 0.000849382195156068, 0.000855019723530859, 0.000860657426528633, 0.000866312417201698, 0.000871932657901198, 0.000877579033840448, 0.000883225293364376, 0.000888880458660424, 0.000894535449333489, 0.000900173094123602, 0.000905828084796667, 0.000911491923034191, 0.000917129567824304, 0.000922801962587982, 0.000928465742617846, 0.000934103329200298, 0.000939784571528435, 0.000945448409765959, 0.000951112131588161, 0.000956784700974822, 0.000962457153946161, 0.000968112144619226, 0.000973793386947364, 0.000979474512860179, 0.000985155696980655, 0.000990819535218179, 0.000996500602923334, 0.00100219936575741, 0.00100788043346256, 0.00101355300284922, 0.00101924291811883, 0.00102493283338845, 0.00103062263224274, 0.00103632139507681, 0.00104200257919729, 0.00104769237805158, 0.00105339987203479, 0.0010590897873044, 0.00106478820089251, 0.00107048696372658, 0.00107620295602828, 0.00108191033359617, 0.00108760024886578, 0.00109331624116749, 0.00109902350232005, 0.0011047397274524, 0.00111044698860496, 0.00111615436617285, 0.00112187908962369, 0.0011274948483333, 0.00113308895379305, 0.00113868317566812, 0.00114424235653132, 0.00114980153739452, 0.001155378180556, 0.0011609373614192, 0.00116646173410118, 0.00117199483793229, 0.00117746705655009, 0.00118296511936933, 0.00118844595272094, 0.00119392678607255, 0.00119939888827503, 0.00120485352817923, 0.0012102733599022, 0.00121567584574223, 0.00122111290693283, 0.00122648046817631, 0.00123189156875014, 0.00123729393817484, 0.00124260049778968, 0.00124797679018229, 0.00125330069568008, 0.00125865079462528, 0.00126396608538926, 0.00126926379743963, 0.00127455301117152, 0.00127980730030686, 0.0012850877828896, 0.00129033322446048, 0.00129559612832963, 0.00130081560928375, 0.00130604370497167, 0.00131124560721219, 0.00131645635701716, 0.00132161471992731, 0.00132679054513574, 0.00133196648675948, 0.00133709865622222, 0.00134224840439856, 0.00134737195912749, 0.00135247805155814, 0.00135754921939224, 0.00136263796593994, 0.00136770936660469, 0.00137278053443879, 0.00137783435638994, 0.00138287071604282, 0.0013878985773772, 0.00139287393540144, 0.0013979016803205, 0.00140287715476006, 0.00140786985866725, 0.00141282787080854, 0.00141779461409897, 0.00142269162461162, 0.00142764078918844, 0.00143255526199937, 0.00143746973481029, 0.00144236674532294, 0.00144725502468646, 0.00145209103357047, 0.00145695311948657, 0.00146180659066886, 0.00146663386840373, 0.00147146987728775, 0.00147629715502262, 0.00148103735409677, 0.00148584716953337, 0.0014906048309058, 0.00149086629971862, 0.0014954669168219, 0.00150006776675582, 0.00150459865108132, 0.00150914723053575, 0.00151369569357485, 0.00151815707795322, 0.00152267061639577, 0.0015271493466571, 0.00153157580643892, 0.00153601972851902, 0.00154037645552307, 0.0015448029153049, 0.00154915975872427, 0.00155351648572832, 0.00155785586684942, 0.0015621951315552, 0.0015664822421968, 0.00157073442824185, 0.00157502153888345, 0.00157922133803368, 0.00158345606178045, 0.0015876735560596, 0.0015918385470286, 0.00159598630852997, 0.00160016864538193, 0.00160428148228675, 0.0016083768568933, 0.00161247223149985, 0.00161651521921158, 0.00162059324793518, 0.00162461888976395, 0.00162857468239963, 0.0016325656324625, 0.00163655623327941, 0.001640529721044, 0.00164446828421205, 0.00164837180636823, 0.00165224063675851, 0.00165614439174533, 0.00165999575983733, 0.0016638645902276, 0.00166769849602133, 0.00167146266903728, 0.00167524430435151, 0.00167900859378278, 0.00168273807503283, 0.00168646732345223, 0.00169019680470228, 0.00169389136135578, 0.00169753364752978, 0.00170121074188501, 0.00170480064116418, 0.00170842546503991, 0.00171203294303268, 0.00171558803413063, 0.00171914324164391, 0.00172264606226236, 0.00172616622876376, 0.00172970397397876, 0.00173313694540411, 0.00173662253655493, 0.00174009043257684, 0.00174352352041751, 0.00174688710831106, 0.00175028527155519, 0.00175361381843686, 0.00175697728991508, 0.00176032318267971, 0.00176359957549721, 0.00176692812237889, 0.00177020439878106, 0.00177862541750073, 0.00178176211193204, 0.00178491638507694, 0.00178801838774234, 0.00179110292810947, 0.00179418758489192, 0.00179725466296077, 0.00180028693284839, 0.0018032668158412, 0.00180628173984587, 0.00180924439337105, 0.00181217212229967, 0.00181513465940952, 0.00181806238833815, 0.00182093784678727, 0.00182383065111935, 0.00182667118497193, 0.00182951171882451, 0.00183233502320945, 0.00183517555706203, 0.00183789420407265, 0.00184064754284918, 0.00184340111445636, 0.00184613710734993, 0.00184883817564696, 0.00185153947677463, 0.00185415346641093, 0.00185680238064378, 0.00185945129487664, 0.00186199578456581, 0.00186459231190383, 0.00186717126052827, 0.00186969828791916, 0.00187220773659647, 0.00187471730168909, 0.00187720928806812, 0.00187971885316074, 0.00188210618216544, 0.00188452855218202, 0.00188698584679514, 0.00188933848403394, 0.00189169112127274, 0.00189406122080982, 0.00189637881703675, 0.00189869676250964, 0.0019009622046724, 0.00190321041736752, 0.00190547585953027, 0.00190768879838288, 0.001909937011078, 0.00191211549099535, 0.00191427627578378, 0.00191643729340285, 0.00191854604054242, 0.0019206372089684, 0.0019227631855756, 0.0019248544704169, 0.00192687590606511, 0.00192891492042691, 0.00193093658890575, 0.00193292298354208, 0.00193489214871079, 0.00193686166312546, 0.00193881336599588, 0.00194067810662091, 0.00194256007671356, 0.00194445974193513, 0.00194634171202779, 0.00194813695270568, 0.00194994919002056, 0.00195179646834731, 0.00195271021220833, 0.00195441790856421, 0.00195616064593196, 0.00195792084559798, 0.00195961119607091, 0.00196130177937448, 0.00196299189701676, 0.00196463009342551, 0.00196625082753599, 0.00196783663704991, 0.00196942267939448, 0.00197102571837604, 0.00197261176072061, 0.00197411025874317, 0.00197564414702356, 0.00197717756964266, 0.00197865883819759, 0.00198010518215597, 0.00198158668354154, 0.00198301579803228, 0.00198442721739411, 0.00198583886958659, 0.00198718067258596, 0.00198857486248016, 0.00198989920318127, 0.00199120654724538, 0.00199254811741412, 0.00199387245811522, 0.00199507502838969, 0.00199634721502662, 0.00199761963449419, 0.00199882173910737, 0.00200000684708357, 0.00200122664682567, 0.00200235960073769, 0.00200354470871389, 0.00200464227236807, 0.00200575753115118, 0.00200687325559556, 0.00200791889801621, 0.00200898153707385, 0.00201002764515579, 0.00201105535961688, 0.00201204884797335, 0.00201302510686219, 0.00201401812955737, 0.00201495946384966, 0.00201586540788412, 0.00201682397164404, 0.00201767776161432, 0.0020186014007777, 0.00201945542357862, 0.00202027428895235, 0.00202112831175327, 0.00202193018049002, 0.00202271435409784, 0.00202346360310912, 0.00202423054724932, 0.00202496256679296, 0.0020256768912077, 0.00202639121562243, 0.00202707108110189, 0.00202775071375072, 0.00202837819233537, 0.00202900543808937, 0.00202963291667402, 0.00203017308376729, 0.00203076563775539, 0.00203135795891285, 0.00203189835883677, 0.00203238613903522, 0.00203287415206432, 0.00203116470947862, 0.00203161803074181, 0.00203210581094027, 0.00203257636167109, 0.00203299452550709, 0.00203344761393964, 0.00203384854830801, 0.00203424948267639, 0.00203463272191584, 0.00203492888249457, 0.00203529489226639, 0.00203564343973994, 0.00203592237085104, 0.00203623599372804, 0.00203653238713741, 0.00203679362311959, 0.00203700270503759, 0.00203726417385042, 0.00203747348859906, 0.00203763018362224, 0.00203782180324197, 0.00203794380649924, 0.00203810073435307, 0.00203820527531207, 0.00203832727856934, 0.00203843181952834, 0.00203848397359252, 0.00203855382278562, 0.00203858874738216, 0.00203860620968044, 0.00203860620968044, 0.00203860620968044, 0.00203857128508389, 0.00203848397359252, 0.00203846651129425, 0.00203837966546416, 0.00203825766220689, 0.00203820527531207, 0.00203806604258716, 0.00203787419013679, 0.00203769979998469, 0.00203757779672742, 0.00203735125251114, 0.00203712494112551, 0.00203693308867514, 0.00203667161986232, 0.00203637545928359, 0.00203613145276904, 0.00203580036759377, 0.00203548651188612, 0.00203513819724321, 0.00203480711206794, 0.00203444110229611, 0.00203407509252429, 0.00203367415815592, 0.00203325599431992, 0.00203280267305672, 0.00203231489285827, 0.00203189649619162, 0.00203142617829144, 0.00203086854889989, 0.00203039799816906, 0.00202985759824514, 0.00202928250655532, 0.00202874233946204, 0.00202816724777222, 0.00202753976918757, 0.00202691252343357, 0.00202630250714719, 0.00202560541220009, 0.00202496070414782, 0.00202647875994444, 0.00202576396986842, 0.00202501472085714, 0.00202430016361177, 0.00202360306866467, 0.0020227839704603, 0.00202203472144902, 0.00202123285271227, 0.00202041398733854, 0.00201959488913417, 0.00201877579092979, 0.00201790453866124, 0.00201703328639269, 0.00201614433899522, 0.00201522069983184, 0.00201427959837019, 0.00201335619203746, 0.00201241485774517, 0.00201142160221934, 0.00201041088439524, 0.00200941739603877, 0.00200838944874704, 0.00200734380632639, 0.00200629816390574, 0.00200521759688854, 0.00200410233810544, 0.00200298707932234, 0.00200185412541032, 0.00200068671256304, 0.00199951883405447, 0.00199835165403783, 0.00199716654606164, 0.00199592905119061, 0.00199472671374679, 0.00199348921887577, 0.00199218210764229, 0.00199089269153774, 0.00198962050490081, 0.00198829616419971, 0.00198697159066796, 0.00198564724996686, 0.00198425282724202, 0.00198285887017846, 0.00198148214258254, 0.00198003579862416, 0.00197862391360104, 0.00197716034017503, 0.00197571399621665, 0.00197421503253281, 0.00197269883938134, 0.00197120034135878, 0.00196966691873968, 0.00196809810586274, 0.00196656468324363, 0.00196492648683488, 0.00196332321502268, 0.00196168501861393, 0.00196008174680173, 0.00195844378322363, 0.00195675319992006, 0.00195508031174541, 0.00195335480384529, 0.00195162976160645, 0.00194990437012166, 0.00194816163275391, 0.00194638408720493, 0.00194457161705941, 0.00194279430434108, 0.00194094702601433, 0.00193911709357053, 0.0019372875103727, 0.0019344815518707, 0.00193261681124568, 0.00193073484115303, 0.00192878290545195, 0.00192690070252866, 0.00192498380783945, 0.00192297948524356, 0.00192097551189363, 0.0019189891172573, 0.00191700225695968, 0.00191496324259788, 0.00191290688235313, 0.00191085052210838, 0.00190872454550117, 0.00190663314424455, 0.00190455932170153, 0.00190238107461482, 0.00190025486517698, 0.001898059155792, 0.00189584586769342, 0.00189363269601017, 0.00189143687020987, 0.00188920623622835, 0.00188690598588437, 0.00188464054372162, 0.00188233994413167, 0.00188000476919115, 0.00187772186473012, 0.00187531695701182, 0.00187298166565597, 0.0018705592956394, 0.00186818942893296, 0.00186571467202157, 0.00186327483970672, 0.00186083500739187, 0.00185832567512989, 0.00185585091821849, 0.00185332412365824, 0.00185077986679971, 0.00184827018529177, 0.00184569112025201, 0.00184309447649866, 0.00184048048686236, 0.00183786626439542, 0.00183523481246084, 0.00183258589822799, 0.00182991975452751, 0.00182721845339984, 0.00182451726868749, 0.00182176369708031, 0.00181904528290033, 0.00181629171129316, 0.00181348610203713, 0.00181071506813169, 0.00180787453427911, 0.00180501653812826, 0.00180221069604158, 0.00179931789170951, 0.00179642508737743, 0.0017934973584488, 0.00179056962952018, 0.00178764178417623, 0.00178469659294933, 0.00178171670995653, 0.00177870178595185, 0.00177570420783013, 0.00177265459205955, 0.00176960485987365, 0.00176658993586898, 0.0017634880496189, 0.0017603860469535, 0.00175726658198982, 0.00175757647957653, 0.0017543873982504, 0.00175112846773118, 0.00174793926998973, 0.00174464553128928, 0.0017413692548871, 0.00173812790308148, 0.00173479923978448, 0.00173145323060453, 0.00172812468372285, 0.0017247786745429, 0.00172136293258518, 0.00171798199880868, 0.00171460118144751, 0.00171111582312733, 0.00170770008116961, 0.00170419726055115, 0.00170071178581566, 0.00169724377337843, 0.00169367121998221, 0.00169013347476721, 0.00168659584596753, 0.00168302329257131, 0.00167939835228026, 0.00167579110711813, 0.00167218374554068, 0.00166848907247186, 0.00166486413218081, 0.00166115234605968, 0.00165747513528913, 0.00165372830815613, 0.00164998148102313, 0.00164621719159186, 0.00164245301857591, 0.00163863645866513, 0.00163485482335091, 0.00163100333884358, 0.00162715185433626, 0.00162328302394599, 0.00161941430997103, 0.00161547586321831, 0.00161158957052976, 0.00160765100736171, 0.00160369509831071, 0.00159972172696143, 0.00159573077689856, 0.00159170525148511, 0.00158769707195461, 0.00158360158093274, 0.00157955859322101, 0.00157548056449741, 0.00157135038170964, 0.00156725500710309, 0.00156312470789999, 0.00155897706281394, 0.00155474222265184, 0.00155059457756579, 0.00154637743253261, 0.00154212513007224, 0.00153792509809136, 0.00153363810386509, 0.00152935099322349, 0.00152506399899721, 0.00152074208017439, 0.00151640269905329, 0.00151206331793219, 0.00150767166633159, 0.00150326266884804, 0.00149888847954571, 0.00149442721158266, 0.00148996582720429, 0.0014827917329967, 0.00147813884541392, 0.00147348584141582, 0.00146884156856686, 0.00146416248753667, 0.00145944836549461, 0.00145477789919823, 0.00145004654768854, 0.00144533242564648, 0.00144058372825384, 0.00143582618329674, 0.00143108598422259, 0.00142627616878599, 0.0014214925467968, 0.00141670007724315, 0.0014119076076895, 0.0014070455217734, 0.00140220951288939, 0.00139739096630365, 0.00139250268694013, 0.00138760567642748, 0.00138273497577757, 0.00137784669641405, 0.00137289729900658, 0.00136798294261098, 0.0013630511239171, 0.00135810184292495, 0.00135314383078367, 0.00134815962519497, 0.00134315819013864, 0.00133815652225167, 0.0013331463560462, 0.00132814480457455, 0.00132306490559131, 0.00131801108364016, 0.00131294864695519, 0.00130790343973786, 0.00130277115385979, 0.00129766517784446, 0.00129256781656295, 0.00128746160771698, 0.00128229451365769, 0.00127713615074754, 0.00127197767142206, 0.00126679323147982, 0.00126159121282399, 0.00125640677288175, 0.00125122221652418, 0.00124595931265503, 0.00124072236940265, 0.00123548565898091, 0.00123020529281348, 0.0012249075807631, 0.00121964444406331, 0.00121433800086379, 0.00120897928718477, 0.00120368145871907, 0.00119834870565683, 0.00119297241326421, 0.0011876136995852, 0.00118224625475705, 0.0011768612312153, 0.00117141532246023, 0.0011660042218864, 0.00116059323772788, 0.00115513848140836, 0.00114966637920588, 0.001144211855717, 0.00113874848466367, 0.00113323284313083, 0.0011277433950454, 0.00112223636824638, 0.00111457717139274, 0.00110891333315521, 0.00110327580478042, 0.0010976119665429, 0.00109197443816811, 0.001086336793378, 0.00108069053385407, 0.00107502669561654, 0.00106938905082643, 0.00106374267488718, 0.00105810503009707, 0.00105245877057314, 0.00104682112578303, 0.00104118336457759, 0.00103555445093662, 0.00102991692256182, 0.00102428789250553, 0.00101864151656628, 0.00101302145048976, 0.00100739253684878, 0.00100172008387744, 0.000996108516119421, 0.000990470987744629, 0.000984859419986606, 0.000979213044047356, 0.000973601592704654, 0.000967972737271339, 0.000962335034273565, 0.000956697505898774, 0.000951077265199274, 0.000945465755648911, 0.000939845514949411, 0.000934225390665233, 0.000928596477024257, 0.000922984967473894, 0.000917373457923532, 0.000911753333639354, 0.000906133092939854, 0.000900521583389491, 0.000894901342689991, 0.000889281218405813, 0.000883660977706313, 0.000878058199305087, 0.000872438016813248, 0.000866852700710297, 0.000861223787069321, 0.000855612277518958, 0.000849992036819458, 0.000844389258418232, 0.000838786596432328, 0.000833175086881965, 0.000827572250273079, 0.00082197820302099, 0.000816375424619764, 0.000810763973277062, 0.00080515252193436, 0.000799558416474611, 0.000793981773313135, 0.000788370263762772, 0.000782776216510683, 0.000777182169258595, 0.000771596794947982, 0.000765985401812941, 0.000760400027502328, 0.000754814711399376, 0.000749211932998151, 0.000743626558687538, 0.000738023780286312, 0.000732447137124836, 0.000726861762814224, 0.000721276446711272, 0.000724959187209606, 0.000719478353857994, 0.000714006193447858, 0.000708525301888585, 0.000703096797224134, 0.000697624695021659, 0.000692204863298684, 0.000686793762724847, 0.000681417470332235, 0.000676067313179374, 0.000670708483085036, 0.00066534971119836, 0.000659990822896361, 0.000654692994430661, 0.000649403897114098, 0.000644132203888148, 0.000638869183603674, 0.000633641029708087, 0.000628369394689798, 0.000623149971943349, 0.000617956684436649, 0.0006127895321697, 0.000607613648753613, 0.000602455285843462, 0.000597331672906876, 0.00059220811817795, 0.000587128160987049, 0.000582030683290213, 0.000576976803131402, 0.000571879383642226, 0.000566851638723165, 0.000561823893804103, 0.00055683107348159, 0.000551838194951415, 0.000546871451660991, 0.000541904766578227, 0.000536938023287803, 0.000532032281626016, 0.000527100404724479, 0.000522220798302442, 0.000517341250088066, 0.000512461643666029, 0.000507608230691403, 0.000502789567690343, 0.00049797969404608, 0.000493204686790705, 0.000488394754938781, 0.000483637180877849, 0.000478853413369507, 0.000474130676593632, 0.000469407939817756, 0.000464720098534599, 0.000460040901089087, 0.000455370434792712, 0.000450699968496338, 0.000446055637439713, 0.000441446143668145, 0.000436827976955101, 0.000432244647527114, 0.000427652586949989, 0.000423104123910889, 0.000418555660871789, 0.000414042064221576, 0.000409528409363702, 0.000405023485654965, 0.000400544755393639, 0.000396074698073789, 0.000391639507142827, 0.000387195555958897, 0.000382803962565958, 0.000378403579816222, 0.000374038092559204, 0.000361871265340596, 0.000357671349775046, 0.000353558600181714, 0.000349463254678994, 0.000345350505085662, 0.000341324863256887, 0.000337264384143054, 0.000333238742314279, 0.000329247966874391, 0.000325309491017833, 0.000321388390148059, 0.000317484751576558, 0.000313581113005057, 0.000309712311718613, 0.000305878376821056, 0.000302061875117943, 0.000298262777505443, 0.000294533441774547, 0.000290751806460321, 0.000287022383417934, 0.000283327914075926, 0.0002796508197207, 0.000276008533546701, 0.000272383767878637, 0.000268793810391799, 0.000265221256995574, 0.000261596433119848, 0.000258076179306954, 0.000254538521403447, 0.000251070538070053, 0.000247602554736659, 0.000244169466895983, 0.000240771216340363, 0.000237390384427272, 0.000234026956604794, 0.000230715842917562, 0.000227369862841442, 0.000224076182348654, 0.000220799905946478, 0.000217575885471888, 0.000214386760490015, 0.000211162769119255, 0.000208025914616883, 0.000204836775083095, 0.000201717339223251, 0.000198615351109765, 0.00019556563347578, 0.000192550753126852, 0.000189448765013367, 0.000186416451469995, 0.000183488737093285, 0.000180456452653743, 0.000177528694621287, 0.000174635817529634, 0.000171760373632424, 0.000168902348377742, 0.00016604432312306, 0.000163273434736766, 0.0001604676945135, 0.000157714224769734, 0.000154978188220412, 0.000152259599417448, 0.000149540981510654, 0.000146892081829719, 0.000144278033985756, 0.000141663971589878, 0.000139032519655302, 0.000136488160933368, 0.000133908964926377, 0.000131382053950801, 0.000128907442558557, 0.000122563971672207, 0.000120315904496238, 0.000118067830044311, 0.000115750037366524, 0.000113571659312584, 0.000111375862616114, 0.000109232350951061, 0.000107088832010049, 0.000104962746263482, 0.000102888930996414, 0.000100762845249847, 9.87413150141947e-05, 9.67023588600568e-05, 9.46982618188486e-05, 9.2694150225725e-05, 9.07423309399746e-05, 8.87905116542242e-05, 8.68561255629174e-05, 8.49217249196954e-05, 8.30396165838465e-05, 8.11749196145684e-05, 7.93799481471069e-05, 7.75501175667159e-05, 7.57377129048109e-05, 7.39601673558354e-05, 7.22174663678743e-05, 7.04747653799132e-05, 6.87669235048816e-05, 6.69893706799485e-05, 6.53338138363324e-05, 6.36782497167587e-05, 6.20749560766853e-05, 6.045425470802e-05, 5.88858274568338e-05, 5.73348261241335e-05, 5.58012507099193e-05, 5.4267675295705e-05, 5.27515294379555e-05, 5.12876649736427e-05, 4.98586559842806e-05, 4.8412213800475e-05, 4.70180530101061e-05, 4.56413217762019e-05, 4.42471646238118e-05, 4.28878593083937e-05, 4.15459799114615e-05, 4.02738151024096e-05, 3.89842170989141e-05, 3.77469004888553e-05, 3.65095875167754e-05, 3.53071263816673e-05, 3.40175283781718e-05, 3.28499190800358e-05, 3.17345948133152e-05, 3.05669855151791e-05, 2.94516576104797e-05, 2.83537610812346e-05, 2.72907127509825e-05, 2.62450921582058e-05, 2.52343288593693e-05, 2.42584155785153e-05, 2.32650763791753e-05, 2.22717389988247e-05, 2.13306811929215e-05, 2.04419047804549e-05, 1.95182747120271e-05, 1.86469242180465e-05, 1.7827856936492e-05, 1.70087860169588e-05, 1.61897187354043e-05, 1.54055032908218e-05, 2.03592244361062e-05, 1.97187764570117e-05, 1.91131857718574e-05, 1.84988784894813e-05, 1.78845730260946e-05, 1.72833370015724e-05, 1.67082416737685e-05, 1.61244333867216e-05, 1.55754805746255e-05, 1.49960287672002e-05, 1.44645027830848e-05, 1.39242611112422e-05, 1.34145202537184e-05, 1.28917063193512e-05, 1.23993904708186e-05, 1.19332144095097e-05, 1.14539689093363e-05, 1.0952939192066e-05, 1.04954788184841e-05, 1.0051086974272e-05, 9.61105160968145e-06, 9.18844489206094e-06, 8.80940478964476e-06, 8.39115455164574e-06, 8.01211444922956e-06, 7.62871786719188e-06, 7.25403560863924e-06, 6.89242278895108e-06, 6.50902666166076e-06, 6.16484066995326e-06, 5.84679628445883e-06, 5.55053520656656e-06, 5.23684684594627e-06, 4.9449431571702e-06, 4.65303901364678e-06, 4.34370758739533e-06, 4.10844177167746e-06, 3.85574821848422e-06, 3.60741228178085e-06, 3.37650317305815e-06, 3.1455936095881e-06, 2.93211155621975e-06, 2.74041349257459e-06, 2.57049919127894e-06, 2.38315783462895e-06, 2.21760001295479e-06, 2.03461536329996e-06, 1.88648482435383e-06, 1.76449509581289e-06, 1.65557571563113e-06, 1.53358587340335e-06, 1.42466649322159e-06, 1.33317405470734e-06, 1.25910878523428e-06, 1.15454622573452e-06, 1.09355141830747e-06, 1.04998355254793e-06, 1.01077262115723e-06, 9.8898863143404e-07, 9.71561462392856e-07, 9.67204755397688e-07, 9.36707237997325e-07, 9.75918283074861e-07, 9.88988517747202e-07, 1.02384285582957e-06, 1.07612413557945e-06, 1.12840552901616e-06, 1.18940033644321e-06, 1.27653595427546e-06, 1.37674180678005e-06, 1.48130447996664e-06, 1.5902238601484e-06, 6.09948926921788e-08, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 5.66381146427375e-08, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15, 1.85187300302152e-15   }, 
   { 0.0106641910970211, 0.0102505898103118, 0.00984347239136696, 0.00944292079657316, 0.0090487701818347, 0.00866093579679728, 0.00827975105494261, 0.00790496729314327, 0.00753666553646326, 0.00717493100091815, 0.00681967986747622, 0.0064706620760262, 0.00612829392775893, 0.00579240918159485, 0.00546300830319524, 0.00514009036123753, 0.004823655821383, 0.00451345462352037, 0.00420998688787222, 0.00391300162300467, 0.00362233398482203, 0.00333823263645172, 0.00306069757789373, 0.00278939655981958, 0.00252474518492818, 0.00226657697930932, 0.00201480905525386, 0.00176960742101073, 0.00153080595191568, 0.00129848776850849, 0.00107256998308003, 0.00085321837104857, 0.000640350161120296, 0.000433965236879885, 0.000233980492339469, 4.05621613026597e-05, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 0.00302722421474755, 8.53633973747492e-05, 0.000280361011391506, 0.000481841911096126, 0.00068980612559244, 0.000904253567568958, 0.00112501811236143, 0.00135234906338155, 0.00158624642062932, 0.00182662706356496, 0.00207340810447931, 0.00232667196542025, 0.00258625345304608, 0.00285248411819339, 0.00312158232554793, 0.00338876899331808, 0.00366281275637448, 0.00394367286935449, 0.00423134816810489, 0.00452563166618347, 0.00482693873345852, 0.00513506168499589, 0.00545004196465015, 0.00577179621905088, 0.00610032491385937, 0.00643562711775303, 0.00677778711542487, 0.00712684635072947, 0.00748267956078053, 0.00784532818943262, 0.00821479316800833, 0.00859103258699179, 0.00897412840276957, 0.00936399959027767, 0.00976076908409595, 0.010164313018322, 0.0105747552588582, 0.010991889052093, 0.0114158792421222, 0.0118467286229134, 0.0122843086719513, 0.012728787958622, 0.0131800435483456, 0.0136380698531866, 0.0141029981896281, 0.0145747819915414, 0.0150532582774758, 0.0155385909602046, 0.0160308238118887, 0.0165298283100128, 0.0170356091111898, 0.0175483282655478, 0.0180676989257336, 0.0185938850045204, 0.019127095118165, 0.0196669958531857, 0.0202135872095823, 0.0207672864198685, 0.0213275514543056, 0.0218946728855371, 0.0224686115980148, 0.0230494886636734, 0.0236371420323849, 0.0242315251380205, 0.0248328931629658, 0.0254408698529005, 0.0260556600987911, 0.0266774352639914, 0.0273060239851475, 0.0279413443058729, 0.0285834819078445, 0.0292325168848038, 0.0298883281648159, 0.0305508710443974, 0.0312203522771597, 0.0318965278565884, 0.0325796008110046, 0.0332694910466671, 0.0339662358164787, 0.034669678658247, 0.0353800132870674, 0.036097165197134, 0.0368212163448334, 0.0375519990921021, 0.0382895991206169, 0.039034016430378, 0.0397301390767097, 0.0404304154217243, 0.041140004992485, 0.0418587364256382, 0.0425866097211838, 0.0433237962424755, 0.0440702885389328, 0.044825840741396, 0.0455906204879284, 0.0463646315038204, 0.0471480265259743, 0.0479405634105206, 0.0487422496080399, 0.0495529174804688, 0.0503730475902557, 0.0512024946510792, 0.0520410016179085, 0.0528888218104839, 0.0537458583712578, 0.0546122081577778, 0.0554874576628208, 0.056372094899416, 0.0572658777236938, 0.0581691302359104, 0.0590814426541328, 0.0600029081106186, 0.060933593660593, 0.0618736706674099, 0.0628227293491364, 0.0637810900807381, 0.0647487640380859, 0.0657256543636322, 0.0667116194963455, 0.0677068084478378, 0.0687112212181091, 0.069724939763546, 0.070747971534729, 0.0717799812555313, 0.0728213042020798, 0.0738718435168266, 0.074931688606739, 0.0760007724165916, 0.0770788267254829, 0.0781661868095398, 0.0792627856135368, 0.0803687646985054, 0.0814839005470276, 0.082608163356781, 0.0837414935231209, 0.0848844647407532, 0.0860362499952316, 0.0871975049376488, 0.0883678197860718, 0.0895474553108215, 0.0907362997531891, 0.0919343084096909, 0.093141533434391, 0.0943581461906433, 0.0955836549401283, 0.0968185514211655, 0.0980625078082085, 0.0993161201477051, 0.100578539073467, 0.101850256323814, 0.103131130337715, 0.104421302676201, 0.105720862746239, 0.107029497623444, 0.108347348868847, 0.109674423933029, 0.111010901629925, 0.112330920994282, 0.113650679588318, 0.114985585212708, 0.116334781050682, 0.117698088288307, 0.119076035916805, 0.120468288660049, 0.121875159442425, 0.123296499252319, 0.124732136726379, 0.126181900501251, 0.127647131681442, 0.129125982522964, 0.130619466304779, 0.132127404212952, 0.13364964723587, 0.135186374187469, 0.136737868189812, 0.138303339481354, 0.139883428812027, 0.141478002071381, 0.143087014555931, 0.144710332155228, 0.146348610520363, 0.148000851273537, 0.14966756105423, 0.151348724961281, 0.153044357895851, 0.154754787683487, 0.156479343771935, 0.15821835398674, 0.159971684217453, 0.161739617586136, 0.163521692156792, 0.165318727493286, 0.167130053043365, 0.168955534696579, 0.170795798301697, 0.172650516033173, 0.174519523978233, 0.176402673125267, 0.178300619125366, 0.180213034152985, 0.182140067219734, 0.184081077575684, 0.186036512255669, 0.188006788492203, 0.189991667866707, 0.191990196704865, 0.194003999233246, 0.1960319429636, 0.198074176907539, 0.200130879878998, 0.202202022075653, 0.204287827014923, 0.20638807117939, 0.208502307534218, 0.210631147027016, 0.21277479827404, 0.21493273973465, 0.217105150222778, 0.219291687011719, 0.221493020653725, 0.223708614706993, 0.225938886404037, 0.228183433413506, 0.230442121624947, 0.232715591788292, 0.235003858804703, 0.23730543255806, 0.239622622728348, 0.241980388760567, 0.24453330039978, 0.247102022171021, 0.249685376882553, 0.252283662557602, 0.254896938800812, 0.25752517580986, 0.260168194770813, 0.262826681137085, 0.265499949455261, 0.268188178539276, 0.270891219377518, 0.27360936999321, 0.276342183351517, 0.279090940952301, 0.281853646039963, 0.284631490707397, 0.287424802780151, 0.29023289680481, 0.293055444955826, 0.29589381814003, 0.298746466636658, 0.301614582538605, 0.30449765920639, 0.307395339012146, 0.310308158397675, 0.313235610723495, 0.316178381443024, 0.319136083126068, 0.322109431028366, 0.325096905231476, 0.32809966802597, 0.331117242574692, 0.334149897098541, 0.337197214365005, 0.340259999036789, 0.343337923288345, 0.346429914236069, 0.349537760019302, 0.352660566568375, 0.355797648429871, 0.358950018882751, 0.362117379903793, 0.365299642086029, 0.368497759103775, 0.37170997262001, 0.374936997890472, 0.378179490566254, 0.381436407566071, 0.384708315134048, 0.387996166944504, 0.391298204660416, 0.394615650177002, 0.397947907447815, 0.401294410228729, 0.404656916856766, 0.40803387761116, 0.411425828933716, 0.414833009243011, 0.418254882097244, 0.421691983938217, 0.425143957138062, 0.42861071228981, 0.432092726230621, 0.435589522123337, 0.439101487398148, 0.442628592252731, 0.446170300245285, 0.449726939201355, 0.453298956155777, 0.456885874271393, 0.460487276315689, 0.464216470718384, 0.467978954315186, 0.471747696399689, 0.475521683692932, 0.479301601648331, 0.483087360858917, 0.486878752708435, 0.490675657987595, 0.494478672742844, 0.498287230730057, 0.502101361751556, 0.505921721458435, 0.50974714756012, 0.51357901096344, 0.51741623878479, 0.521259367465973, 0.525108098983765, 0.528962671756744, 0.532822608947754, 0.536688923835754, 0.540560126304626, 0.5444375872612, 0.548321127891541, 0.552210092544556, 0.556104719638824, 0.560004830360413, 0.563910961151123, 0.567823052406311, 0.571740448474884, 0.575663864612579, 0.579592883586884, 0.583527743816376, 0.587467908859253, 0.591414451599121, 0.595366239547729, 0.59932404756546, 0.603287696838379, 0.607256591320038, 0.611231982707977, 0.615212082862854, 0.619198501110077, 0.623190939426422, 0.627188742160797, 0.631192088127136, 0.635201930999756, 0.639216899871826, 0.643237769603729, 0.647264003753662, 0.651296317577362, 0.65533459186554, 0.659378290176392, 0.663427531719208, 0.667483270168304, 0.671543657779694, 0.675610363483429, 0.679683148860931, 0.683761358261108, 0.687845289707184, 0.691934943199158, 0.69603019952774, 0.700131297111511, 0.704238057136536, 0.708350658416748, 0.712469220161438, 0.716593265533447, 0.720722794532776, 0.724858641624451, 0.728999972343445, 0.733146667480469, 0.73729944229126, 0.741457760334015, 0.745562553405762, 0.749554634094238, 0.753544509410858, 0.757531702518463, 0.76151579618454, 0.765497505664825, 0.769476652145386, 0.77345335483551, 0.777426898479462, 0.781398236751556, 0.785366415977478, 0.789331912994385, 0.793295085430145, 0.797255516052246, 0.801213443279266, 0.805168330669403, 0.809120953083038, 0.81307053565979, 0.817017793655396, 0.820961773395538, 0.824903607368469, 0.82884293794632, 0.832779169082642, 0.836713314056396, 0.840644240379333, 0.844572246074677, 0.848498106002808, 0.852421164512634, 0.85634171962738, 0.860259294509888, 0.864174604415894, 0.868086636066437, 0.871996581554413, 0.87590354681015, 0.879808068275452, 0.883709669113159, 0.887609004974365, 0.891505420207977, 0.89539909362793, 0.899289906024933, 0.903178036212921, 0.907064199447632, 0.910947024822235, 0.914827585220337, 0.918705344200134, 0.92258083820343, 0.92645251750946, 0.930322110652924, 0.934189438819885, 0.938053607940674, 0.941915571689606, 0.945774376392365, 0.949631094932556, 0.95348447561264, 0.957335472106934, 0.961184203624725, 0.965029776096344, 0.968873023986816, 0.97271317243576, 0.976551234722137, 0.980385899543762, 0.984218060970306, 0.988047957420349, 0.991874933242798, 0.995699405670166, 0.999521255493164, 1.00334060192108, 1.0071564912796, 1.01097059249878, 1.01478147506714, 1.01858973503113, 1.02239573001862, 1.02603924274445, 1.02964794635773, 1.03325521945953, 1.0368617773056, 1.04046726226807, 1.04407238960266, 1.04767644405365, 1.05127954483032, 1.05488228797913, 1.05848383903503, 1.06208419799805, 1.06568443775177, 1.06928384304047, 1.07288217544556, 1.07647931575775, 1.08007645606995, 1.08367228507996, 1.08726739883423, 1.09086132049561, 1.09445512294769, 1.09804737567902, 1.10163938999176, 1.10523056983948, 1.10882031917572, 1.1124095916748, 1.11599791049957, 1.11958587169647, 1.12317264080048, 1.12675893306732, 1.13034403324127, 1.13392877578735, 1.13751173019409, 1.14109468460083, 1.14467692375183, 1.14825749397278, 1.1518383026123, 1.15541768074036, 1.15899658203125, 1.16257381439209, 1.16615092754364, 1.16972744464874, 1.17330276966095, 1.176877617836, 1.18045103549957, 1.18402433395386, 1.18759608268738, 1.19116747379303, 1.19473803043365, 1.19830763339996, 1.20187616348267, 1.20544421672821, 1.20901167392731, 1.21257758140564, 1.21614348888397, 1.21970784664154, 1.22327172756195, 1.2268351316452, 1.23039734363556, 1.23395919799805, 1.2375191450119, 1.24107909202576, 1.24463784694672, 1.24819624423981, 1.25175344944, 1.25531017780304, 1.25886595249176, 1.26242029666901, 1.26597487926483, 1.26952791213989, 1.27308022975922, 1.27663207054138, 1.28022146224976, 1.2839241027832, 1.28762865066528, 1.29133570194244, 1.29504525661469, 1.29875671863556, 1.30247068405151, 1.30618691444397, 1.30990540981293, 1.31362593173981, 1.31734871864319, 1.32107412815094, 1.32480180263519, 1.32853174209595, 1.33226406574249, 1.33599829673767, 1.33973467350006, 1.34347367286682, 1.34721505641937, 1.35095858573914, 1.3547043800354, 1.35845243930817, 1.36220276355743, 1.36595547199249, 1.36971008777618, 1.37346732616425, 1.37722671031952, 1.38098847866058, 1.38475251197815, 1.38851881027222, 1.39228749275208, 1.39605808258057, 1.39983117580414, 1.4036066532135, 1.40738427639008, 1.41116428375244, 1.41494643688202, 1.41873097419739, 1.42251765727997, 1.42630684375763, 1.43009793758392, 1.43389165401459, 1.43768763542175, 1.44148588180542, 1.44528639316559, 1.4490886926651, 1.45289373397827, 1.45670104026794, 1.4605108499527, 1.46432244777679, 1.46813654899597, 1.47195303440094, 1.47577142715454, 1.47959232330322, 1.48341572284698, 1.48724126815796, 1.49106907844543, 1.49489903450012, 1.49873161315918, 1.502565741539, 1.50640261173248, 1.51024198532104, 1.51408338546753, 1.5179271697998, 1.52177309989929, 1.52562153339386, 1.52947163581848, 1.53332448005676, 1.53717982769012, 1.54103708267212, 1.5448967218399, 1.54875874519348, 1.55290865898132, 1.55712354183197, 1.56132900714874, 1.56552529335022, 1.56971311569214, 1.57389104366302, 1.57806003093719, 1.58222186565399, 1.58637225627899, 1.59051525592804, 1.59464848041534, 1.59877228736877, 1.60288786888123, 1.60699439048767, 1.61109101772308, 1.61517989635468, 1.61925899982452, 1.62332987785339, 1.62739074230194, 1.63144218921661, 1.63548564910889, 1.63952016830444, 1.64354574680328, 1.64756119251251, 1.6515679359436, 1.65556645393372, 1.65955531597137, 1.66353476047516, 1.66750645637512, 1.6714676618576, 1.67542147636414, 1.67936456203461, 1.68329906463623, 1.68722605705261, 1.69114255905151, 1.6950501203537, 1.69894957542419, 1.7028386592865, 1.70671987533569, 1.7105907201767, 1.71445333957672, 1.71830797195435, 1.72215235233307, 1.72598874568939, 1.7298139333725, 1.73363149166107, 1.73744130134583, 1.74124014377594, 1.74503028392792, 1.74881291389465, 1.75258493423462, 1.75634896755219, 1.76010286808014, 1.76384747028351, 1.76758515834808, 1.77131223678589, 1.77503085136414, 1.77874004840851, 1.78243887424469, 1.7861316204071, 1.78981328010559, 1.79348707199097, 1.7971510887146, 1.80080604553223, 1.80445325374603, 1.80808961391449, 1.81171643733978, 1.81533718109131, 1.81894659996033, 1.82254803180695, 1.8261399269104, 1.829665184021, 1.83313572406769, 1.83657872676849, 1.83999335765839, 1.84337937831879, 1.8467378616333, 1.85006868839264, 1.85337030887604, 1.85664248466492, 1.8598895072937, 1.86310660839081, 1.86629557609558, 1.8694566488266, 1.87258923053741, 1.87569403648376, 1.87876963615417, 1.88181948661804, 1.88483846187592, 1.88783001899719, 1.8907949924469, 1.89372956752777, 1.89663732051849, 1.89951992034912, 1.90236937999725, 1.90519404411316, 1.90798819065094, 1.91075372695923, 1.91349470615387, 1.91620373725891, 1.91888558864594, 1.92153930664062, 1.92416441440582, 1.92676389217377, 1.92933201789856, 1.93187260627747, 1.93438684940338, 1.93686974048615, 1.93932807445526, 1.94175720214844, 1.94415509700775, 1.94652879238129, 1.94887351989746, 1.95118749141693, 1.95347571372986, 1.95573377609253, 1.95796537399292, 1.96016836166382, 1.9623441696167, 1.9644912481308, 1.96660923957825, 1.96869909763336, 1.97076046466827, 1.97279465198517, 1.97480261325836, 1.97678017616272, 1.97872734069824, 1.98065102100372, 1.98254418373108, 1.98441123962402, 1.98624789714813, 1.98805713653564, 1.98983597755432, 1.99159002304077, 1.99331378936768, 1.9950098991394, 1.99667620658875, 1.99831676483154, 1.99992656707764, 2.00151062011719, 2.00306725502014, 2.00459384918213, 2.00616788864136, 2.007248878479, 2.00829815864563, 2.00930762290955, 2.01028776168823, 2.01123332977295, 2.01214170455933, 2.0130181312561, 2.01386117935181, 2.01466846466064, 2.01543998718262, 2.01618075370789, 2.01688671112061, 2.01755595207214, 2.0181941986084, 2.01879930496216, 2.01936841011047, 2.01990175247192, 2.02040314674377, 2.02086997032166, 2.02129936218262, 2.02169847488403, 2.02206134796143, 2.02239274978638, 2.0226879119873, 2.02294707298279, 2.02317452430725, 2.02336883544922, 2.02352452278137, 2.02364921569824, 2.0237410068512, 2.02379703521729, 2.02381682395935, 2.02380514144897, 2.02375984191895, 2.02367734909058, 2.02356314659119, 2.02341389656067, 2.02323174476624, 2.02301239967346, 2.02276372909546, 2.02247762680054, 2.02215576171875, 2.02180075645447, 2.02141380310059, 2.02099061012268, 2.02053332328796, 2.02004265785217, 2.01951861381531, 2.01896405220032, 2.01836967468262, 2.01774191856384, 2.01708102226257, 2.01638555526733, 2.01565527915955, 2.01489186286926, 2.01409530639648, 2.01326155662537, 2.01239418983459, 2.01149272918701, 2.01055908203125, 2.00958824157715, 2.00858688354492, 2.00754952430725, 2.00647640228271, 2.00537109375, 2.00423145294189, 2.00305843353271, 2.0018482208252, 2.00060606002808, 1.99933063983917, 1.99801802635193, 1.99673068523407, 1.99534106254578, 1.99392187595367, 1.99247097969055, 1.99099481105804, 1.98948931694031, 1.98795318603516, 1.98639070987701, 1.98479616641998, 1.98317492008209, 1.98152446746826, 1.9798436164856, 1.97813594341278, 1.97640037536621, 1.97463285923004, 1.97283494472504, 1.97101163864136, 1.96916031837463, 1.96727728843689, 1.96536755561829, 1.96342980861664, 1.96146142482758, 1.95946264266968, 1.95743989944458, 1.95538508892059, 1.95329988002777, 1.9511878490448, 1.94904828071594, 1.94687640666962, 1.94467675685883, 1.94244909286499, 1.94019365310669, 1.93790626525879, 1.9355936050415, 1.9332515001297, 1.93088161945343, 1.92848122119904, 1.92605018615723, 1.92359364032745, 1.92110550403595, 1.91858804225922, 1.91604506969452, 1.9134703874588, 1.91086637973785, 1.90823602676392, 1.90557610988617, 1.90288829803467, 1.90017151832581, 1.89742243289948, 1.89464831352234, 1.89184486865997, 1.88901090621948, 1.88614881038666, 1.88325893878937, 1.88033711910248, 1.87738871574402, 1.8744124174118, 1.87140417098999, 1.8683705329895, 1.86530661582947, 1.86221444606781, 1.8590931892395, 1.85594403743744, 1.85276281833649, 1.84955644607544, 1.84632086753845, 1.84305191040039, 1.83975756168365, 1.83643543720245, 1.83308160305023, 1.82970082759857, 1.82613790035248, 1.8226261138916, 1.81909322738647, 1.81553983688354, 1.81196618080139, 1.80837154388428, 1.80475544929504, 1.80111825466156, 1.79746162891388, 1.79378247261047, 1.79008328914642, 1.78636419773102, 1.78262448310852, 1.77886152267456, 1.77508056163788, 1.77127707004547, 1.76745355129242, 1.7636102437973, 1.75974416732788, 1.75585889816284, 1.75195157527924, 1.74802374839783, 1.74407517910004, 1.74010539054871, 1.73611569404602, 1.73210537433624, 1.72807371616364, 1.72402226924896, 1.7199479341507, 1.71585321426392, 1.71173977851868, 1.70760452747345, 1.70344853401184, 1.69927132129669, 1.6950740814209, 1.69085359573364, 1.68661463260651, 1.68235409259796, 1.67807447910309, 1.6737722158432, 1.66945016384125, 1.66510665416718, 1.66074204444885, 1.65635788440704, 1.65195178985596, 1.64752519130707, 1.64307880401611, 1.63860964775085, 1.63412249088287, 1.62961065769196, 1.6250809431076, 1.62053072452545, 1.61595869064331, 1.61136567592621, 1.60675179958344, 1.60211825370789, 1.59746277332306, 1.59278702735901, 1.58808970451355, 1.58337318897247, 1.57863545417786, 1.57387554645538, 1.56909549236298, 1.5642956495285, 1.55947411060333, 1.55463266372681, 1.54976904392242, 1.54488563537598, 1.53998100757599, 1.53505706787109, 1.53011035919189, 1.52514255046844, 1.51991283893585, 1.5146005153656, 1.50929069519043, 1.50397634506226, 1.4986606836319, 1.49334383010864, 1.48802626132965, 1.48270857334137, 1.4773862361908, 1.47206461429596, 1.46674370765686, 1.46141612529755, 1.4560923576355, 1.450763463974, 1.44543588161469, 1.44010639190674, 1.43477475643158, 1.42944383621216, 1.42410755157471, 1.41877329349518, 1.41343629360199, 1.4080982208252, 1.40275847911835, 1.39741957187653, 1.39207601547241, 1.38673460483551, 1.38138628005981, 1.37604069709778, 1.37069451808929, 1.36534559726715, 1.35999608039856, 1.35464322566986, 1.34929096698761, 1.34393751621246, 1.33858263492584, 1.33322370052338, 1.32786679267883, 1.32250666618347, 1.31714582443237, 1.31178164482117, 1.30641865730286, 1.30105459690094, 1.29568636417389, 1.2903208732605, 1.28494942188263, 1.27958118915558, 1.27420973777771, 1.26883554458618, 1.26346218585968, 1.25808393955231, 1.25270771980286, 1.24733030796051, 1.24194884300232, 1.23656868934631, 1.23118662834167, 1.22579967975616, 1.22041499614716, 1.21502888202667, 1.20964074134827, 1.20425403118134, 1.19886064529419, 1.19347047805786, 1.18807566165924, 1.18268156051636, 1.1772848367691, 1.17188668251038, 1.16648936271667, 1.16108989715576, 1.15568721294403, 1.15028429031372, 1.14487838745117, 1.13971877098083, 1.13469052314758, 1.12967669963837, 1.12468421459198, 1.11970520019531, 1.11474454402924, 1.10980129241943, 1.10487532615662, 1.09996259212494, 1.09507262706757, 1.09019720554352, 1.08533775806427, 1.08049821853638, 1.07567453384399, 1.0708669424057, 1.06607675552368, 1.06130635738373, 1.05654919147491, 1.05181086063385, 1.04709112644196, 1.04238855838776, 1.03770053386688, 1.03302991390228, 1.02837789058685, 1.02374196052551, 1.01912319660187, 1.01452159881592, 1.00993609428406, 1.00536918640137, 1.00081825256348, 0.996288657188416, 0.99177223443985, 0.987273216247559, 0.982791423797607, 0.978326916694641, 0.973879754543304, 0.969449758529663, 0.965038597583771, 0.960641801357269, 0.956262528896332, 0.951900482177734, 0.947556972503662, 0.943228125572205, 0.938917875289917, 0.934625029563904, 0.930350601673126, 0.926092386245728, 0.921851217746735, 0.917626142501831, 0.913416981697083, 0.909227788448334, 0.90505188703537, 0.900897264480591, 0.896757245063782, 0.892638444900513, 0.888533174991608, 0.884446263313293, 0.880372881889343, 0.876320600509644, 0.872284352779388, 0.868264079093933, 0.864261031150818, 0.860277950763702, 0.856309533119202, 0.852361083030701, 0.848425805568695, 0.844507992267609, 0.840609967708588, 0.836726665496826, 0.832860708236694, 0.829011917114258, 0.825185775756836, 0.821725368499756, 0.818330109119415, 0.814946234226227, 0.811578214168549, 0.808223485946655, 0.804883480072021, 0.801557421684265, 0.798247277736664, 0.794950425624847, 0.791665554046631, 0.788395941257477, 0.785142362117767, 0.781900107860565, 0.778672397136688, 0.775459289550781, 0.772263526916504, 0.769079089164734, 0.765907287597656, 0.762752175331116, 0.759610176086426, 0.756480276584625, 0.753368258476257, 0.750268340110779, 0.747180938720703, 0.744112133979797, 0.741056680679321, 0.738013863563538, 0.734983026981354, 0.731968820095062, 0.728967189788818, 0.725980222225189, 0.72301059961319, 0.720052897930145, 0.717107117176056, 0.714177310466766, 0.711262166500092, 0.708359003067017, 0.705470442771912, 0.702597856521606, 0.699738562107086, 0.696891248226166, 0.694062530994415, 0.69124710559845, 0.688442349433899, 0.685653567314148, 0.682879388332367, 0.680119156837463, 0.677372217178345, 0.674641311168671, 0.671924293041229, 0.66921991109848, 0.666529536247253, 0.663855075836182, 0.661191284656525, 0.658543407917023, 0.655911564826965, 0.653292298316956, 0.65068906545639, 0.648096978664398, 0.64552104473114, 0.642958283424377, 0.640409529209137, 0.637876033782959, 0.635354518890381, 0.632848381996155, 0.630358159542084, 0.627881109714508, 0.625416815280914, 0.622967123985291, 0.620533466339111, 0.618111670017242, 0.61555141210556, 0.612852334976196, 0.610163986682892, 0.607480823993683, 0.604807078838348, 0.602142572402954, 0.599486112594604, 0.596837639808655, 0.594197750091553, 0.591565191745758, 0.588939249515533, 0.586323380470276, 0.583716750144958, 0.581116795539856, 0.578525424003601, 0.575943470001221, 0.573368728160858, 0.57080203294754, 0.568241953849792, 0.565692543983459, 0.563149094581604, 0.560616254806519, 0.558091402053833, 0.555573284626007, 0.553063035011292, 0.550562858581543, 0.548069298267365, 0.545584321022034, 0.54310804605484, 0.540641069412231, 0.5381800532341, 0.535728454589844, 0.533286035060883, 0.530849635601044, 0.528421938419342, 0.526002109050751, 0.523592293262482, 0.521189153194427, 0.518794655799866, 0.516409516334534, 0.514030933380127, 0.511660397052765, 0.509299159049988, 0.506946563720703, 0.504600584506989, 0.502263307571411, 0.499935954809189, 0.497614592313766, 0.495301902294159, 0.492998480796814, 0.490701735019684, 0.488413602113724, 0.486133515834808, 0.48386338353157, 0.48159983754158, 0.479343682527542, 0.477098137140274, 0.474859893321991, 0.472628951072693, 0.470407396554947, 0.468192398548126, 0.465986758470535, 0.463787764310837, 0.461600035429001, 0.459418296813965, 0.457244575023651, 0.455080837011337, 0.452923715114594, 0.450775295495987, 0.44863548874855, 0.446502953767776, 0.444334536790848, 0.442208021879196, 0.440092802047729, 0.43799090385437, 0.435899585485458, 0.433816283941269, 0.431745618581772, 0.429685592651367, 0.427637577056885, 0.425596803426743, 0.423571318387985, 0.421555876731873, 0.419550389051437, 0.417556881904602, 0.415573298931122, 0.413602411746979, 0.411638110876083, 0.409691095352173, 0.407750129699707, 0.405822455883026, 0.4039067029953, 0.401998251676559, 0.400105148553848, 0.398219347000122, 0.396347522735596, 0.394482284784317, 0.392633050680161, 0.390793800354004, 0.388962537050247, 0.387145847082138, 0.385337233543396, 0.383542507886887, 0.38175442814827, 0.379980325698853, 0.378214865922928, 0.376464754343033, 0.3747239112854, 0.372991651296616, 0.37127274274826, 0.369563162326813, 0.367865562438965, 0.366179883480072, 0.364503532648087, 0.362837851047516, 0.3611840903759, 0.359542995691299, 0.357907861471176, 0.356289386749268, 0.354677528142929, 0.353080302476883, 0.351489752531052, 0.34991380572319, 0.348349153995514, 0.346791177988052, 0.345249801874161, 0.343714445829391, 0.342194378376007, 0.340680927038193, 0.339181452989578, 0.337690621614456, 0.336213767528534, 0.334746211767197, 0.333289951086044, 0.331844359636307, 0.330410063266754, 0.328985750675201, 0.327572017908096, 0.326172977685928, 0.324782580137253, 0.323400765657425, 0.322032332420349, 0.320675134658813, 0.319451630115509, 0.318357765674591, 0.317272424697876, 0.316193014383316, 0.315123081207275, 0.314058870077133, 0.313000917434692, 0.311952114105225, 0.310909122228622, 0.309875130653381, 0.308844774961472, 0.307824552059174, 0.306811690330505, 0.305803954601288, 0.304804861545563, 0.303810596466064, 0.302826464176178, 0.301846325397491, 0.300875961780548, 0.299910306930542, 0.29895406961441, 0.298004865646362, 0.297060638666153, 0.296126872301102, 0.295197606086731, 0.294277310371399, 0.293363332748413, 0.292455315589905, 0.291553646326065, 0.290662288665771, 0.289778232574463, 0.288897663354874, 0.288027256727219, 0.287162154912949, 0.286305367946625, 0.28545355796814, 0.284612387418747, 0.283776849508286, 0.282946348190308, 0.282126277685165, 0.281310707330704, 0.280505269765854, 0.279703885316849, 0.278912246227264, 0.278124272823334, 0.277346581220627, 0.276576101779938, 0.275810718536377, 0.275054007768631, 0.274302423000336, 0.273560851812363, 0.272822767496109, 0.272096455097198, 0.271374672651291, 0.2706578373909, 0.269952833652496, 0.269250959157944, 0.26855942606926, 0.267871677875519, 0.267193585634232, 0.26652067899704, 0.265856683254242, 0.265200048685074, 0.264548242092133, 0.263906538486481, 0.263268858194351, 0.262640833854675, 0.262017756700516, 0.261405169963837, 0.260798424482346, 0.260196626186371, 0.259592294692993, 0.258850872516632, 0.258110046386719, 0.257370233535767, 0.256630420684814, 0.255891442298889, 0.255153149366379, 0.254415303468704, 0.253677934408188, 0.252941429615021, 0.252205282449722, 0.251469522714615, 0.2507344186306, 0.250000417232513, 0.249266400933266, 0.248532921075821, 0.247800424695015, 0.24706819653511, 0.246336624026299, 0.245605826377869, 0.244875192642212, 0.244145333766937, 0.243416264653206, 0.242687433958054, 0.241959229111671, 0.241231694817543, 0.240504592657089, 0.239778220653534, 0.239052638411522, 0.238327175378799, 0.237602233886719, 0.236878082156181, 0.23615474998951, 0.235431551933289, 0.234709084033966, 0.233987405896187, 0.233265981078148, 0.23254506289959, 0.231825083494186, 0.23110543191433, 0.230386316776276, 0.229668155312538, 0.228950083255768, 0.228232756257057, 0.227516204118729, 0.226800069212914, 0.226084291934967, 0.225368991494179, 0.224654823541641, 0.223940819501877, 0.223227486014366, 0.222514808177948, 0.221802562475204, 0.221090793609619, 0.220379874110222, 0.219669416546822, 0.218959495425224, 0.218250349164009, 0.217541396617889, 0.216833174228668, 0.216125801205635, 0.215418785810471, 0.214712128043175, 0.214005991816521, 0.213300943374634, 0.212595984339714, 0.211891785264015, 0.211188271641731, 0.210485205054283, 0.209782496094704, 0.20908097922802, 0.208379462361336, 0.207596227526665, 0.20677886903286, 0.205962926149368, 0.205148875713348, 0.204335913062096, 0.20352466404438, 0.20271509885788, 0.201906830072403, 0.201100334525108, 0.200295239686966, 0.199491783976555, 0.198689937591553, 0.197889611124992, 0.197090551257133, 0.19629280269146, 0.195497155189514, 0.19470289349556, 0.193910270929337, 0.193118944764137, 0.192328408360481, 0.191540226340294, 0.190753668546677, 0.189968511462212, 0.189185082912445, 0.188403010368347, 0.187622517347336, 0.186843574047089, 0.186066180467606, 0.185290142893791, 0.184515908360481, 0.183742970228195, 0.182971701025963, 0.182202115654945, 0.181433588266373, 0.1806670576334, 0.179901868104935, 0.179138123989105, 0.178376376628876, 0.17761567234993, 0.176856219768524, 0.176098629832268, 0.17534264922142, 0.174588352441788, 0.173835411667824, 0.173084184527397, 0.172334611415863, 0.17158605158329, 0.170839220285416, 0.170094415545464, 0.16935059428215, 0.168608218431473, 0.167867794632912, 0.167128771543503, 0.166391387581825, 0.1656554043293, 0.164920881390572, 0.164187893271446, 0.163456693291664, 0.162726819515228, 0.161997944116592, 0.161271080374718, 0.160545945167542, 0.159822568297386, 0.15910017490387, 0.15837936103344, 0.157660663127899, 0.156943023204803, 0.156226649880409, 0.155512377619743, 0.154799580574036, 0.154088288545609, 0.153404757380486, 0.152776390314102, 0.15215165913105, 0.151530921459198, 0.150913178920746, 0.15029875934124, 0.149688675999641, 0.14908155798912, 0.148478120565414, 0.147879004478455, 0.14728319644928, 0.146691396832466, 0.146102905273438, 0.145518079400063, 0.144937247037888, 0.144359737634659, 0.143784537911415, 0.143214672803879, 0.14264814555645, 0.142084926366806, 0.141525715589523, 0.140969797968864, 0.140417888760567, 0.139869302511215, 0.139324367046356, 0.138783097267151, 0.138245165348053, 0.137710526585579, 0.137179896235466, 0.136653244495392, 0.136129945516586, 0.135610938072205, 0.135094940662384, 0.134582594037056, 0.13407389819622, 0.133569195866585, 0.133067488670349, 0.132569774985313, 0.132075384259224, 0.131585299968719, 0.131098568439484, 0.130615144968033, 0.130135715007782, 0.129659608006477, 0.129187479615211, 0.128719016909599, 0.128253236413002, 0.127791091799736, 0.127333596348763, 0.126879438757896, 0.126428931951523, 0.125982075929642, 0.125538885593414, 0.125099018216133, 0.124663144350052, 0.124230921268463, 0.123802036046982, 0.123376123607159, 0.122955210506916, 0.122537292540073, 0.122123025357723, 0.121712416410446, 0.121305122971535, 0.120902508497238, 0.1205028668046, 0.120106220245361, 0.119713231921196, 0.119323901832104, 0.118938557803631, 0.118557214736938, 0.118179187178612, 0.117805153131485, 0.117441415786743, 0.117093980312347, 0.116750530898571, 0.116410411894321, 0.116072945296764, 0.115737810730934, 0.115405663847923, 0.115077175199986, 0.114750683307648, 0.114427849650383, 0.114107675850391, 0.113791167736053, 0.113476298749447, 0.113165102899075, 0.112856574356556, 0.112551361322403, 0.112248472869396, 0.111949235200882, 0.111652337014675, 0.111358426511288, 0.111067838966846, 0.110780246555805, 0.110495314002037, 0.110213376581669, 0.109934762120247, 0.109658472239971, 0.109384179115295, 0.109114214777946, 0.108847230672836, 0.108582906424999, 0.108321256935596, 0.108062580227852, 0.107807248830795, 0.107554562389851, 0.107305213809013, 0.107058838009834, 0.106814131140709, 0.10657275468111, 0.106334365904331, 0.106100298464298, 0.105867572128773, 0.105638489127159, 0.105412073433399, 0.105188988149166, 0.104968562722206, 0.104751124978065, 0.104537010192871, 0.104324877262115, 0.104116410017014, 0.103909954428673, 0.103706806898117, 0.103507660329342, 0.103310830891132, 0.103116661310196, 0.10292549431324, 0.102737300097942, 0.102552108466625, 0.102369584143162, 0.102190382778645, 0.102014169096947, 0.101840279996395, 0.101669378578663, 0.101501494646072, 0.101337246596813, 0.101175658404827, 0.101017065346241, 0.100861467421055, 0.100708201527596, 0.100557580590248, 0.100410640239716, 0.100266672670841, 0.100125528872013, 0.0999792367219925, 0.0998354479670525, 0.0996934771537781, 0.0995535030961037, 0.0994148701429367, 0.0992782115936279, 0.0991433933377266, 0.0990097299218178, 0.0988787412643433, 0.0987494066357613, 0.0986220687627792, 0.0984955579042435, 0.0983715504407883, 0.0982491970062256, 0.0981291756033897, 0.0980104804039001, 0.0978937819600105, 0.0977787524461746, 0.0976648703217506, 0.097553662955761, 0.0974442809820175, 0.0973363816738129, 0.0972301661968231, 0.0971264243125916, 0.097023531794548, 0.0969231128692627, 0.0968243703246117, 0.09672761708498, 0.0966323688626289, 0.0965387672185898, 0.0964465141296387, 0.0963572412729263, 0.096268966794014, 0.0961828604340553, 0.0960987359285355, 0.0960162878036499, 0.0959358140826225, 0.0958563685417175, 0.0957790687680244, 0.0957041010260582, 0.0956301167607307, 0.0955581292510033, 0.0954884886741638, 0.0954201519489288, 0.0953541621565819, 0.0952894911170006, 0.0952266603708267, 0.0951661467552185, 0.0951064601540565, 0.0950489491224289, 0.09499341994524, 0.0949402302503586, 0.0948883593082428, 0.0948376506567001, 0.094789445400238, 0.0947432294487953, 0.0946986824274063, 0.0946552976965904, 0.0946145728230476, 0.0945753306150436, 0.0945371016860008, 0.0945018529891968, 0.094467781484127, 0.0944356918334961, 0.0944057703018188, 0.094377338886261, 0.0943505838513374, 0.0943254753947258, 0.0943026915192604, 0.0942810848355293, 0.0942476764321327, 0.094232939183712, 0.0942184403538704, 0.0942052006721497, 0.0941922590136528, 0.0941805317997932, 0.0941694229841232, 0.0941589027643204, 0.0941493064165115, 0.0941406190395355, 0.0941321849822998, 0.0941250547766685, 0.0941184461116791, 0.0941122993826866, 0.0941074043512344, 0.0941031128168106, 0.0940992683172226, 0.0940964594483376, 0.0940944701433182, 0.0940930172801018, 0.09409249573946, 0.0940927565097809, 0.0940935909748077, 0.0940953865647316, 0.0940978974103928, 0.0941009968519211, 0.0941050574183464, 0.0941095128655434, 0.0941151008009911, 0.0941215604543686, 0.0941282734274864, 0.094135969877243, 0.0941447094082832, 0.0941537469625473, 0.0941638350486755, 0.0941747277975082, 0.094186007976532, 0.0941985100507736, 0.0942115187644958, 0.0942252427339554, 0.0942399054765701, 0.0942549705505371, 0.09427110850811, 0.0942880660295486, 0.0943054035305977, 0.0943238735198975, 0.0943430587649345, 0.0943626686930656, 0.0943834036588669, 0.0944048836827278, 0.0944267958402634, 0.09444959461689, 0.0944735258817673, 0.0944977179169655, 0.0945229455828667, 0.0945486724376678, 0.0945752710103989, 0.0946030169725418, 0.0946307778358459, 0.0946599915623665, 0.0946896374225616, 0.0947198793292046, 0.0947512462735176, 0.0947831347584724, 0.09481580555439, 0.0948492810130119, 0.0948834270238876, 0.0949184224009514, 0.0949542671442032, 0.0949905514717102, 0.0950278267264366, 0.0950659662485123, 0.095113530755043, 0.0951606631278992, 0.0952069014310837, 0.0952529162168503, 0.0952978506684303, 0.0953423753380775, 0.0953861922025681, 0.0954295769333839, 0.0954718813300133, 0.0955139398574829, 0.095555305480957, 0.0955958664417267, 0.0956359282135963, 0.0956751853227615, 0.0957140624523163, 0.0957522317767143, 0.0957896113395691, 0.0958264768123627, 0.0958625823259354, 0.0958982333540916, 0.0959328860044479, 0.0959672480821609, 0.0960007682442665, 0.0960338115692139, 0.0960662886500359, 0.0960977375507355, 0.0961290821433067, 0.0961592346429825, 0.0961891040205956, 0.096218079328537, 0.0962467938661575, 0.0962747856974602, 0.0963017418980598, 0.0963285639882088, 0.096354216337204, 0.0963797345757484, 0.0964042097330093, 0.0964282974600792, 0.0964517742395401, 0.096474401652813, 0.0964965522289276, 0.0965178087353706, 0.0965388789772987, 0.0965588539838791, 0.0965785905718803, 0.0965972319245338, 0.0966156870126724, 0.0966333672404289, 0.0966502800583839, 0.0966666713356972, 0.0966821238398552, 0.0966973826289177, 0.0967117100954056, 0.0967255979776382, 0.0967387929558754, 0.0967510566115379, 0.0967629626393318, 0.096774086356163, 0.0967847928404808, 0.0967944636940956, 0.0968038737773895, 0.0968123972415924, 0.0968206748366356, 0.0968282222747803, 0.0968346744775772, 0.0968408957123756, 0.0968462377786636, 0.0968511328101158, 0.0968551337718964, 0.0968587622046471, 0.0968617722392082, 0.0968652591109276, 0.096860446035862, 0.0968523025512695, 0.0968431532382965, 0.096831850707531, 0.0968177244067192, 0.0968024283647537, 0.096783809363842, 0.0967636927962303, 0.0967414230108261, 0.0967173203825951, 0.0966902077198029, 0.0966614559292793, 0.0966311916708946, 0.0965976193547249, 0.0965630486607552, 0.0965253114700317, 0.0964865759015083, 0.0964446887373924, 0.0964011251926422, 0.0963554158806801, 0.0963082015514374, 0.0962576568126678, 0.0962054654955864, 0.0961516052484512, 0.0960947498679161, 0.0960367321968079, 0.0959762260317802, 0.0959127098321915, 0.0958485528826714, 0.0957817211747169, 0.0957120731472969, 0.0956409201025963, 0.0955677703022957, 0.0954916402697563, 0.0954145044088364, 0.0953348651528358, 0.0952527523040771, 0.0951689705252647, 0.0950825288891792, 0.0949942544102669, 0.0949036553502083, 0.0948115512728691, 0.0947164669632912, 0.0946197137236595, 0.0945204794406891, 0.0944195613265038, 0.0943169966340065, 0.0942109376192093, 0.0941037088632584, 0.0939943268895149, 0.093882292509079, 0.0937687382102013, 0.0936530455946922, 0.0935341790318489, 0.0934139862656593, 0.0932921394705772, 0.0931672900915146, 0.0930407866835594, 0.0929124504327774, 0.0927809551358223, 0.0926484614610672, 0.0925131514668465, 0.0923758372664452, 0.0922365188598633, 0.0920953899621964, 0.0919507592916489, 0.0918054655194283, 0.0916578471660614, 0.0915075689554214, 0.0913554653525352, 0.0912011936306953, 0.0909925624728203, 0.0907713025808334, 0.0905485451221466, 0.0903231203556061, 0.0900966227054596, 0.0898677110671997, 0.0896381363272667, 0.089406818151474, 0.0891739204525948, 0.0889381840825081, 0.0887018814682961, 0.0884634926915169, 0.0882236957550049, 0.0879822373390198, 0.0877382829785347, 0.0874936655163765, 0.0872470438480377, 0.0869985967874527, 0.0867487490177155, 0.0864968970417976, 0.0862433835864067, 0.0859883725643158, 0.0857319533824921, 0.0854730308055878, 0.0852133706212044, 0.0849516317248344, 0.0846878886222839, 0.0844230726361275, 0.0841565132141113, 0.0838876217603683, 0.0836176425218582, 0.0833461806178093, 0.0830721333622932, 0.0827973410487175, 0.0825200602412224, 0.0822416916489601, 0.0819615796208382, 0.0816803053021431, 0.0813962891697884, 0.0811113566160202, 0.0808239281177521, 0.080535426735878, 0.080245666205883, 0.0799534171819687, 0.0796600952744484, 0.0793652758002281, 0.0790673717856407, 0.0787692293524742, 0.0784692466259003, 0.0781668573617935, 0.0778633877635002, 0.0775580927729607, 0.0772505477070808, 0.0769425928592682, 0.076632484793663, 0.0763197764754295, 0.0760063380002975, 0.0756910741329193, 0.0753740519285202, 0.0750554576516151, 0.0747350305318832, 0.0744128599762917, 0.074088953435421, 0.0737633779644966, 0.0734366327524185, 0.0731078088283539, 0.0727779045701027, 0.0724449306726456, 0.0721114575862885, 0.0717755705118179, 0.0714387744665146, 0.0710931643843651, 0.0707351714372635, 0.0703777596354485, 0.0700223371386528, 0.069667175412178, 0.0693144127726555, 0.0689614936709404, 0.0686097294092178, 0.0682598799467087, 0.0679106190800667, 0.0675632655620575, 0.0672160685062408, 0.0668703019618988, 0.066525436937809, 0.0661827325820923, 0.0658397823572159, 0.0654989182949066, 0.0651580393314362, 0.0648185834288597, 0.0644816234707832, 0.0641442388296127, 0.0638089403510094, 0.0634741261601448, 0.0631410703063011, 0.0628085136413574, 0.0624774470925331, 0.0621471330523491, 0.0618178099393845, 0.0614901557564735, 0.0611634142696857, 0.0608377531170845, 0.0605129227042198, 0.060189675539732, 0.0598672591149807, 0.0595465786755085, 0.0592261590063572, 0.0589077286422253, 0.0585895515978336, 0.0582723654806614, 0.057957511395216, 0.05764240026474, 0.057329460978508, 0.0570170171558857, 0.0567060671746731, 0.0563955344259739, 0.0560872443020344, 0.0557792112231255, 0.0554721653461456, 0.0551670342683792, 0.0548621490597725, 0.0545594319701195, 0.0542569570243359, 0.0539563186466694, 0.0536559261381626, 0.0533572807908058, 0.053059458732605, 0.0527632236480713, 0.0524673238396645, 0.0521727502346039, 0.0518796667456627, 0.0515874214470387, 0.0512968376278877, 0.0510065034031868, 0.0507181622087955, 0.0504299849271774, 0.0501440577208996, 0.0498582944273949, 0.0495736114680767, 0.0492908395826817, 0.0490086488425732, 0.0487277917563915, 0.0484476797282696, 0.0482437014579773, 0.0480488687753677, 0.0478577017784119, 0.0476681850850582, 0.0474810041487217, 0.0472954772412777, 0.0471126213669777, 0.0469314195215702, 0.0467528812587261, 0.0465766675770283, 0.0464021153748035, 0.0462305545806885, 0.0460599921643734, 0.0458920933306217, 0.0457258597016335, 0.0455622784793377, 0.045401357114315, 0.0452421009540558, 0.0450851731002331, 0.0449299067258835, 0.044777300208807, 0.0446266904473305, 0.0444787368178368, 0.0443321168422699, 0.044187817722559, 0.0440458506345749, 0.0439058803021908, 0.0437685661017895, 0.0436329133808613, 0.0435005910694599, 0.0433692634105682, 0.0432402603328228, 0.0431129224598408, 0.0429882407188416, 0.0428658910095692, 0.0427458696067333, 0.0426275059580803, 0.0425111390650272, 0.0423977635800838, 0.0422860532999039, 0.0421769991517067, 0.0420696102082729, 0.0419648811221123, 0.0418618135154247, 0.0417607389390469, 0.041661661118269, 0.0415649116039276, 0.0414711534976959, 0.0413793884217739, 0.0412889532744884, 0.0412011817097664, 0.0411157347261906, 0.0410322844982147, 0.0409511588513851, 0.0408716946840286, 0.0407942272722721, 0.0407190881669521, 0.0406466089189053, 0.0405767895281315, 0.0405079685151577, 0.0404421389102936, 0.0403779707849026, 0.0403167940676212, 0.0402562841773033, 0.0401987619698048, 0.0401435717940331, 0.040090374648571, 0.0400398410856724, 0.0399903021752834, 0.0399434231221676, 0.039898868650198, 0.0398700498044491, 0.0398362204432487, 0.0398026816546917, 0.0397700555622578, 0.0397373512387276, 0.0397059097886086, 0.0396757796406746, 0.039645854383707, 0.0396158695220947, 0.0395874828100204, 0.039559680968523, 0.039532482624054, 0.0395058840513229, 0.039480198174715, 0.0394551195204258, 0.0394306592643261, 0.0394064299762249, 0.0393834672868252, 0.0393610894680023, 0.0393396429717541, 0.0393188036978245, 0.0392982065677643, 0.0392788834869862, 0.0392601601779461, 0.0392420217394829, 0.0392248183488846, 0.039208211004734, 0.0391921922564507, 0.0391761064529419, 0.0391612686216831, 0.0391474105417728, 0.0391344204545021, 0.0391220599412918, 0.0391102768480778, 0.0390990972518921, 0.0390882082283497, 0.0390785448253155, 0.0390697978436947, 0.0390613414347172, 0.0390531308948994, 0.0390465036034584, 0.0390401445329189, 0.0390347205102444, 0.0390298999845982, 0.0390259921550751, 0.0390220247209072, 0.0390196554362774, 0.0390168726444244, 0.0390156880021095, 0.0390154160559177, 0.0390154160559177, 0.039015356451273, 0.0390168726444244, 0.0390189923346043, 0.0390220247209072, 0.0390256606042385, 0.0390298999845982, 0.0390350744128227, 0.0390404984354973, 0.0390465259552002, 0.0390534624457359, 0.0390610247850418, 0.0390695072710514, 0.0390785858035088, 0.0390882678329945, 0.0390985161066055, 0.0391100496053696, 0.0391218103468418, 0.0391345247626305, 0.039147824048996, 0.0391620621085167, 0.039180513471365, 0.0391636453568935, 0.039146676659584, 0.0391296185553074, 0.0391124859452248, 0.0390952602028847, 0.0390779376029968, 0.039060540497303, 0.0390430800616741, 0.0390254966914654, 0.0390078462660313, 0.0389900766313076, 0.0389722362160683, 0.038954321295023, 0.0389362946152687, 0.03891821205616, 0.0389000065624714, 0.0388817526400089, 0.0388633906841278, 0.0388449244201183, 0.0388264320790768, 0.0388078019022942, 0.0387891009449959, 0.0387703068554401, 0.0387514419853687, 0.0387324541807175, 0.0387133993208408, 0.0386942587792873, 0.0386750102043152, 0.0386556833982468, 0.038636289536953, 0.0386167876422405, 0.0385972112417221, 0.0385775417089462, 0.0385577790439129, 0.0385379418730736, 0.0385179966688156, 0.0384979695081711, 0.0384778678417206, 0.0384576916694641, 0.0384374223649502, 0.038417037576437, 0.0383966043591499, 0.0383760556578636, 0.0383554100990295, 0.0383346863090992, 0.0383138880133629, 0.0382930003106594, 0.0382720120251179, 0.038250956684351, 0.0382297895848751, 0.0382086150348186, 0.0381872840225697, 0.0381658896803856, 0.0381443835794926, 0.0381227731704712, 0.0381010696291924, 0.0380793213844299, 0.0380574874579906, 0.0380355343222618, 0.0380135104060173, 0.0379914157092571, 0.0379692055284977, 0.0379469245672226, 0.0379245355725288, 0.0379020757973194, 0.0378795266151428, 0.0378568805754185, 0.0378341600298882, 0.037811353802681, 0.0377884656190872, 0.0377654805779457, 0.0377389751374722, 0.0377177372574806, 0.0376964695751667, 0.037675179541111, 0.0376538410782814, 0.0376324653625488, 0.0376110561192036, 0.0375896319746971, 0.0375681556761265, 0.0375466383993626, 0.0375251099467278, 0.0375035293400288, 0.037481926381588, 0.0374602675437927, 0.0374385789036751, 0.0374168790876865, 0.0373951233923435, 0.0373733229935169, 0.0373515151441097, 0.0373296551406384, 0.0373077504336834, 0.0372858196496964, 0.0372638776898384, 0.0372418724000454, 0.0372198335826397, 0.0371977873146534, 0.037175677716732, 0.0371535383164883, 0.0371313542127609, 0.037109162658453, 0.0370869189500809, 0.0370646305382252, 0.0370423346757889, 0.0370199866592884, 0.0369976051151752, 0.0369751863181591, 0.0369527526199818, 0.0369302593171597, 0.0369077324867249, 0.0368851870298386, 0.036862600594759, 0.0368399694561958, 0.0368173085153103, 0.0367946065962315, 0.0367718860507011, 0.0367491208016872, 0.036726325750351, 0.0367035008966923, 0.03668063133955, 0.0366577208042145, 0.0366347692906857, 0.0366118066012859, 0.0365887954831123, 0.036565750837326, 0.036542683839798, 0.0365195572376251, 0.0364964082837105, 0.0364732183516026, 0.0364500172436237, 0.0364267565310001, 0.0364034622907639, 0.0363801494240761, 0.0363567918539047, 0.0363333895802498, 0.0363099537789822, 0.0362865030765533, 0.0362630002200603, 0.036239467561245, 0.0362159125506878, 0.0361923165619373, 0.0361686833202839, 0.0361435487866402, 0.0361204370856285, 0.0360972955822945, 0.0360740907490253, 0.0360508374869823, 0.0360275357961655, 0.0360041633248329, 0.0359807722270489, 0.0359573028981686, 0.0359337814152241, 0.035910215228796, 0.0358865931630135, 0.0358629263937473, 0.0358391925692558, 0.0358154103159904, 0.0357915796339512, 0.035767700523138, 0.035743772983551, 0.0357197783887386, 0.035695742815733, 0.0356716513633728, 0.0356474928557873, 0.0356233082711697, 0.035599060356617, 0.0355747602880001, 0.0355504006147385, 0.0355260111391544, 0.0355015322566032, 0.03547702729702, 0.0354524701833725, 0.03542784973979, 0.0354031957685947, 0.035378459841013, 0.0353536829352379, 0.0353288762271404, 0.0353039987385273, 0.0352790653705597, 0.035254068672657, 0.0352290421724319, 0.0352039709687233, 0.0351788140833378, 0.0351536311209202, 0.0351283773779869, 0.0351030826568604, 0.0350777469575405, 0.0350523553788662, 0.0350268930196762, 0.0350013710558414, 0.0349757969379425, 0.0349502228200436, 0.0349245518445969, 0.034898828715086, 0.0348730608820915, 0.0348472371697426, 0.0348213836550713, 0.0347954444587231, 0.0347694791853428, 0.0347434654831886, 0.0347173735499382, 0.0346912257373333, 0.034665048122406, 0.0346388332545757, 0.0346125140786171, 0.0345861651003361, 0.0345597751438618, 0.0345333218574524, 0.0345068387687206, 0.0344802923500538, 0.0344536751508713, 0.0344270057976246, 0.0344002954661846, 0.0343735553324223, 0.0343457460403442, 0.0343182347714901, 0.03429064899683, 0.0342629924416542, 0.0342353023588657, 0.0342074893414974, 0.0341796241700649, 0.0341516807675362, 0.034123670309782, 0.0340956300497055, 0.0340674705803394, 0.0340392738580704, 0.0340109914541245, 0.0339826382696629, 0.0339541919529438, 0.0339257121086121, 0.0338971614837646, 0.0338685251772404, 0.0338398180902004, 0.0338110588490963, 0.0337822176516056, 0.0337533131241798, 0.0337243229150772, 0.0336952768266201, 0.0336661525070667, 0.0336369536817074, 0.0336077176034451, 0.0335783660411835, 0.0335489623248577, 0.0335195064544678, 0.0334899686276913, 0.0334603786468506, 0.0334306955337524, 0.0334009155631065, 0.0333711057901382, 0.0333412066102028, 0.0333112739026546, 0.0332812443375587, 0.0332511365413666, 0.0332209952175617, 0.0331907719373703, 0.0331604406237602, 0.0331300608813763, 0.0330996178090572, 0.0330691039562225, 0.0330385267734528, 0.0330078639090061, 0.0329771302640438, 0.0329463556408882, 0.0329154655337334, 0.0328845344483852, 0.0328535325825214, 0.0328224450349808, 0.0327913276851177, 0.0327601172029972, 0.032728835940361, 0.0326974578201771, 0.032666027545929, 0.0326345637440681, 0.0326030030846596, 0.0325713641941547, 0.0325396545231342, 0.0325078591704369, 0.0324760340154171, 0.0324441306293011, 0.0324121490120888, 0.0323800966143608, 0.0323479697108269, 0.0323157832026482, 0.0322835221886635, 0.0322512052953243, 0.0322250686585903, 0.0321871340274811, 0.0321492925286293, 0.032111544162035, 0.032073862850666, 0.0320362932980061, 0.0319988019764423, 0.0319613628089428, 0.0319240614771843, 0.03188681229949, 0.0318495780229568, 0.0318125374615192, 0.0317755565047264, 0.031738642603159, 0.0317018516361713, 0.0316651314496994, 0.0316285192966461, 0.0315919779241085, 0.0315555073320866, 0.0315191969275475, 0.0314828641712666, 0.0314465723931789, 0.0314105302095413, 0.0313744954764843, 0.0313385501503944, 0.031302735209465, 0.0312670134007931, 0.0312313344329596, 0.0311956666409969, 0.0311601832509041, 0.0311247874051332, 0.0310894288122654, 0.031054237857461, 0.0310191009193659, 0.0309840235859156, 0.030949043110013, 0.0309141725301743, 0.0308793559670448, 0.0308446642011404, 0.0308100767433643, 0.0307754352688789, 0.0307410154491663, 0.0307066235691309, 0.0306723788380623, 0.0306382048875093, 0.0306040979921818, 0.0305700916796923, 0.0305361580103636, 0.0305023174732924, 0.0304685737937689, 0.0304349176585674, 0.0304012335836887, 0.03036779910326, 0.0303344167768955, 0.0303011164069176, 0.0302678812295198, 0.0302347671240568, 0.0302016958594322, 0.0301686152815819, 0.0301357731223106, 0.0301029812544584, 0.0300702750682831, 0.0300377011299133, 0.0300051718950272, 0.029972679913044, 0.029940377920866, 0.029908075928688, 0.0298759005963802, 0.0298438165336847, 0.0298118349164724, 0.0297797936946154, 0.0297479815781116, 0.0297203212976456, 0.029694551602006, 0.0296689495444298, 0.0296435989439487, 0.0296184979379177, 0.0295936465263367, 0.0295690428465605, 0.0295446887612343, 0.0295205824077129, 0.029496643692255, 0.029473040252924, 0.0294496826827526, 0.0294265765696764, 0.0294036362320185, 0.0293810293078423, 0.0293586682528257, 0.0293363910168409, 0.0293145347386599, 0.0292928405106068, 0.0292713101953268, 0.0292501971125603, 0.0292292535305023, 0.0292085539549589, 0.0291881915181875, 0.0291679929941893, 0.0291479621082544, 0.0291283465921879, 0.0291088130325079, 0.0290894452482462, 0.0290704946964979, 0.0290517956018448, 0.0290333405137062, 0.0290150530636311, 0.0289971008896828, 0.0289793964475393, 0.0289618577808142, 0.0289445705711842, 0.028927531093359, 0.0289107412099838, 0.0288941990584135, 0.0288778264075518, 0.028861865401268, 0.0288459919393063, 0.0288303662091494, 0.0288151558488607, 0.0288000255823135, 0.0287851486355066, 0.0287706013768911, 0.0287563074380159, 0.0287421755492687, 0.0287283770740032, 0.0287146642804146, 0.0287012811750174, 0.0286882314831018, 0.0286753494292498, 0.0286627132445574, 0.028650414198637, 0.0286381933838129, 0.0286262258887291, 0.0286146719008684, 0.0286031179130077, 0.0285920631140471, 0.0285810902714729, 0.0285704527050257, 0.0285600628703833, 0.028549836948514, 0.0285398662090302, 0.0285301376134157, 0.0285207480192184, 0.0285115204751492, 0.0285025425255299, 0.0284859407693148, 0.0284817013889551, 0.028477543964982, 0.0284735970199108, 0.0284696482121944, 0.0284658670425415, 0.028462290763855, 0.0284587573260069, 0.0284553952515125, 0.0284521505236626, 0.0284489933401346, 0.028446001932025, 0.0284431353211403, 0.0284402649849653, 0.0284376069903374, 0.0284351129084826, 0.0284327007830143, 0.0284304190427065, 0.0284282993525267, 0.0284262169152498, 0.0284243486821651, 0.0284225605428219, 0.0284207742661238, 0.0284192785620689, 0.0284178648144007, 0.0284165777266026, 0.0284153707325459, 0.0284143332391977, 0.0284132938832045, 0.0284125041216612, 0.0284118372946978, 0.0284112561494112, 0.0284107998013496, 0.0284105092287064, 0.0284102596342564, 0.0284101758152246, 0.0284102596342564, 0.0284103434532881, 0.0284105930477381, 0.0284110493957996, 0.0284115504473448, 0.0284121688455343, 0.028413001447916, 0.0284138768911362, 0.028414873406291, 0.0284160766750574, 0.0284172426909208, 0.0284186154603958, 0.0284201521426439, 0.0284217726439238, 0.028423560783267, 0.0284253861755133, 0.02842734195292, 0.0284294616430998, 0.0284317471086979, 0.0284340754151344, 0.0284365676343441, 0.0284391846507788, 0.0284418873488903, 0.028444753959775, 0.0284477490931749, 0.0284507367759943, 0.0284539386630058, 0.0284573063254356, 0.028460755944252, 0.0284643284976482, 0.0284680668264627, 0.0284718926995993, 0.0284758415073156, 0.0284799542278051, 0.0284840278327465, 0.0284926909953356, 0.0285000894218683, 0.0285073202103376, 0.0285141374915838, 0.028520867228508, 0.0285275187343359, 0.0285337511450052, 0.0285397376865149, 0.0285458043217659, 0.0285514574497938, 0.0285569429397583, 0.0285620968788862, 0.028567248955369, 0.0285719875246286, 0.0285766422748566, 0.0285812150686979, 0.028585284948349, 0.0285893622785807, 0.0285931825637817, 0.0285966768860817, 0.0285999998450279, 0.0286033228039742, 0.0286062322556973, 0.0286088921129704, 0.0286116357892752, 0.02861388027668, 0.0286158751696348, 0.0286180358380079, 0.0286196134984493, 0.028621194884181, 0.0286224409937859, 0.0286235213279724, 0.0286244340240955, 0.0286250151693821, 0.0286254342645407, 0.0286257658153772, 0.0286257658153772, 0.0286254342645407, 0.0286251846700907, 0.0286246035248041, 0.028623852878809, 0.0286227706819773, 0.0286216083914042, 0.0286200307309628, 0.0286184512078762, 0.0286166220903397, 0.0286145433783531, 0.0286122187972069, 0.0286098048090935, 0.0286070629954338, 0.0286040715873241, 0.028601162135601, 0.0285977553576231, 0.02859409712255, 0.0285906065255404, 0.028586532920599, 0.0285822935402393, 0.028577970340848, 0.0285734012722969, 0.0285685807466507, 0.0285636764019728, 0.0285584405064583, 0.0285529512912035, 0.0285473838448524, 0.0285414829850197, 0.0285354964435101, 0.0285291820764542, 0.028522863984108, 0.0285161305218935, 0.0285091511905193, 0.0285021681338549, 0.0284948535263538, 0.0284901801496744, 0.0284841954708099, 0.0284779574722052, 0.0284708924591541, 0.0284627471119165, 0.0284541063010693, 0.028444878757, 0.0284348204731941, 0.0284239314496517, 0.0284130442887545, 0.0284006595611572, 0.02838777564466, 0.0283746421337128, 0.0283600110560656, 0.0283451341092587, 0.02832992374897, 0.02831338532269, 0.028296260163188, 0.0282787252217531, 0.0282609350979328, 0.0282419007271528, 0.0282223708927631, 0.0282016713172197, 0.0281803086400032, 0.0281586982309818, 0.028136171400547, 0.028112817555666, 0.0280889626592398, 0.0280643571168184, 0.0280388426035643, 0.0280126594007015, 0.0279860589653254, 0.0279585476964712, 0.0279304552823305, 0.0279016084969044, 0.0278720185160637, 0.0278416816145182, 0.0278109274804592, 0.0277790930122137, 0.0277467612177134, 0.0277136787772179, 0.0276808459311724, 0.0276463534682989, 0.0276112742722034, 0.0275754518806934, 0.0275390446186066, 0.02750164270401, 0.0274639073759317, 0.0274251718074083, 0.0273856911808252, 0.0273457914590836, 0.0273048989474773, 0.027263754978776, 0.0272214487195015, 0.027178643271327, 0.027135418727994, 0.0270909499377012, 0.0270461477339268, 0.0270005986094475, 0.0269541349261999, 0.0269070900976658, 0.0268596280366182, 0.0268110875040293, 0.0267621297389269, 0.0267127584666014, 0.0266623049974442, 0.0266113542020321, 0.0265593193471432, 0.0265068728476763, 0.0264536757022142, 0.0263996478170156, 0.0263502635061741, 0.0262699313461781, 0.0261892210692167, 0.0261077210307121, 0.0260261856019497, 0.0259436052292585, 0.0258606113493443, 0.0257772449404001, 0.0256930831819773, 0.0256081763654947, 0.0255228988826275, 0.0254372023046017, 0.0253508016467094, 0.0252640228718519, 0.0251764580607414, 0.0250891447067261, 0.0250004567205906, 0.0249113496392965, 0.0248215422034264, 0.0247316472232342, 0.0246406756341457, 0.0245493277907372, 0.02445756085217, 0.0243647210299969, 0.024271834641695, 0.024178160354495, 0.0240841098129749, 0.0239893570542336, 0.02389414049685, 0.0237982235848904, 0.0237019285559654, 0.0236048884689808, 0.0235074311494827, 0.0234092250466347, 0.0233109779655933, 0.0232116542756557, 0.023111579939723, 0.0230121687054634, 0.0229113027453423, 0.0228096880018711, 0.0227079931646585, 0.0226052608340979, 0.0225021094083786, 0.0223985854536295, 0.0222943108528852, 0.022189624607563, 0.0220842286944389, 0.0219784192740917, 0.0218718592077494, 0.0217648856341839, 0.0216575376689434, 0.0215491093695164, 0.0214405972510576, 0.0213313791900873, 0.021221412345767, 0.0211110729724169, 0.0210003163665533, 0.0208888128399849, 0.0207768939435482, 0.0206642691046, 0.0205508936196566, 0.0204374361783266, 0.0203229393810034, 0.0202083606272936, 0.0200936980545521, 0.0199776645749807, 0.0198608823120594, 0.0197440162301064, 0.0196264460682869, 0.0195080824196339, 0.0193894319236279, 0.0192702803760767, 0.0191278830170631, 0.0190039537847042, 0.0188803132623434, 0.0187568813562393, 0.0186341125518084, 0.018511513248086, 0.0183896198868752, 0.0182679314166307, 0.0181468687951565, 0.0180260147899389, 0.0179057829082012, 0.0177854672074318, 0.0176661070436239, 0.0175469964742661, 0.0174284689128399, 0.0173098593950272, 0.0171922445297241, 0.0170749220997095, 0.0169577654451132, 0.0168412327766418, 0.0167249497026205, 0.0166095793247223, 0.0164942108094692, 0.0163790490478277, 0.0162648409605026, 0.0161505118012428, 0.0160368476063013, 0.0159236807376146, 0.015810888260603, 0.0156982615590096, 0.0155872963368893, 0.0154756251722574, 0.015364496037364, 0.0152539890259504, 0.0151433562859893, 0.0150333484634757, 0.0149239227175713, 0.0148151190951467, 0.0147061906754971, 0.0145979300141335, 0.0144905801862478, 0.0143831912428141, 0.014275967143476, 0.0141694089397788, 0.0140634309500456, 0.0139577444642782, 0.0138525571674109, 0.0137474117800593, 0.0136430971324444, 0.0135391978546977, 0.0134354243054986, 0.0133322719484568, 0.0132297044619918, 0.0131271351128817, 0.0130253974348307, 0.012923700734973, 0.0128225022926927, 0.0127223031595349, 0.0126219382509589, 0.0125219449400902, 0.012422451749444, 0.0123236235231161, 0.0122250011190772, 0.0121270464733243, 0.0120289660990238, 0.0119318412616849, 0.0118349641561508, 0.0117383385077119, 0.0116422949358821, 0.0115465838462114, 0.0114513700827956, 0.0113526238128543, 0.0112861292436719, 0.0112204644829035, 0.0111551322042942, 0.0110907973721623, 0.0110272942110896, 0.0109644560143352, 0.0109024494886398, 0.0108407745137811, 0.010780761949718, 0.0107209160923958, 0.0106617351993918, 0.0106033850461245, 0.0105461990460753, 0.0104891797527671, 0.0104333227500319, 0.0103786299005151, 0.0103239379823208, 0.0102702425792813, 0.010217378847301, 0.0101651791483164, 0.01011464279145, 0.0100642722100019, 0.0100144008174539, 0.00996519345790148, 0.00991715118288994, 0.00986960623413324, 0.0098227271810174, 0.00977734383195639, 0.00973179470747709, 0.00968757458031178, 0.00964352115988731, 0.00960096437484026, 0.00955857336521149, 0.0095178447663784, 0.00947678368538618, 0.00943738501518965, 0.00939831882715225, 0.00935975182801485, 0.00932218227535486, 0.00928577501326799, 0.00924986787140369, 0.00921479146927595, 0.00918004754930735, 0.00914646778255701, 0.00911321956664324, 0.00908163376152515, 0.00905038136988878, 0.00901946052908897, 0.00898986961692572, 0.00896094460040331, 0.00893235113471746, 0.00890508852899075, 0.00887848995625973, 0.00885222479701042, 0.00882728863507509, 0.0088026849552989, 0.00877891294658184, 0.00875597167760134, 0.00873352959752083, 0.00871258322149515, 0.00869197025895119, 0.00867185462266207, 0.00865290313959122, 0.00863461755216122, 0.00861699599772692, 0.00860087014734745, 0.00858441367745399, 0.00856911949813366, 0.00855465605854988, 0.00854085851460695, 0.00852805841714144, 0.00853700470179319, 0.00852752849459648, 0.00851805228739977, 0.00850907620042562, 0.00850009918212891, 0.00849178712815046, 0.00848347507417202, 0.00847599469125271, 0.00846818182617426, 0.00846086721867323, 0.00845371838659048, 0.00844690203666687, 0.00844025332480669, 0.00843443442136049, 0.00842828489840031, 0.00842279847711325, 0.00841714628040791, 0.00841215904802084, 0.00840717181563377, 0.00840301625430584, 0.00839852727949619, 0.00839453749358654, 0.00839071441441774, 0.00838738959282637, 0.00838406477123499, 0.00838157068938017, 0.00837874505668879, 0.0083765834569931, 0.00837442278862, 0.00837276037782431, 0.00837109796702862, 0.00836993381381035, 0.00836910307407379, 0.00836860481649637, 0.00836810562759638, 0.00836810562759638, 0.00836810562759638, 0.00836860481649637, 0.00836960226297379, 0.00837059877812862, 0.00837176293134689, 0.0083732595667243, 0.00837525352835655, 0.00837724842131138, 0.0083797425031662, 0.00838256813585758, 0.0083855614066124, 0.00838871952146292, 0.00839237682521343, 0.00839619990438223, 0.00840018969029188, 0.00840484444051981, 0.00840949919074774, 0.00841415394097567, 0.00841947365552187, 0.00842479337006807, 0.00843077711760998, 0.00843692850321531, 0.00844341237097979, 0.00844972860068083, 0.00845671165734529, 0.00846385862678289, 0.00847133994102478, 0.00847882125526667, 0.00848729815334082, 0.00849544443190098, 0.00850408896803856, 0.00851273350417614, 0.008522043004632, 0.008531185798347, 0.00854132696986198, 0.00854993984103203, 0.00855384767055511, 0.00855767074972391, 0.00856141094118357, 0.0085649024695158, 0.00856839213520288, 0.00857180077582598, 0.00857504270970821, 0.00857820082455873, 0.00858119316399097, 0.00858410261571407, 0.00858692824840546, 0.00858950428664684, 0.00859216507524252, 0.00859457440674305, 0.00859690178185701, 0.00859931297600269, 0.0086014736443758, 0.00860346853733063, 0.00860538147389889, 0.00860712584108114, 0.00860878825187683, 0.00861028395593166, 0.00861178059130907, 0.00861302670091391, 0.00861427467316389, 0.00861535407602787, 0.00861635245382786, 0.00861718319356441, 0.00861793197691441, 0.00861859694123268, 0.0086190951988101, 0.00861959345638752, 0.00861984305083752, 0.00862017553299665, 0.0086202584207058, 0.00862017553299665, 0.00862000975757837, 0.00861976016312838, 0.00861942768096924, 0.00861892849206924, 0.00861826445907354, 0.00861759856343269, 0.00861676782369614, 0.00861585326492786, 0.00861477293074131, 0.00861352682113647, 0.00861227978020906, 0.0086108660325408, 0.00860936939716339, 0.00860770791769028, 0.00860596261918545, 0.0086041335016489, 0.00860230531543493, 0.00860022753477097, 0.00859806686639786, 0.00859573949128389, 0.00859332829713821, 0.00859075225889683, 0.00858817435801029, 0.00858534872531891, 0.00858244020491838, 0.00857944693416357, 0.00857637263834476, 0.00857313070446253, 0.00856988877058029, 0.00856639817357063, 0.00856282375752926, 0.00855916645377874, 0.00855534337460995, 0.00855168607085943, 0.00854315515607595, 0.00853700470179319, 0.00853043794631958, 0.00852370541542768, 0.00851663947105408, 0.00850949250161648, 0.00850167870521545, 0.008493865840137, 0.00848555378615856, 0.00847724266350269, 0.00846834760159254, 0.0084593715146184, 0.00845006201416254, 0.00844033621251583, 0.00843044556677341, 0.00842022150754929, 0.00840983260422945, 0.00839902646839619, 0.00838813837617636, 0.00837683398276567, 0.00836519710719585, 0.00835322868078947, 0.00834109168499708, 0.00832854118198156, 0.00831607356667519, 0.00830277428030968, 0.00828964170068502, 0.00827601086348295, 0.00826212950050831, 0.0082479165866971, 0.00823345314711332, 0.00821865815669298, 0.00820369645953178, 0.00818831939250231, 0.00817277561873198, 0.00815673358738422, 0.00814094208180904, 0.00812423415482044, 0.00810769479721785, 0.00809048768132925, 0.00807336624711752, 0.00805557798594236, 0.00803779065608978, 0.00801967084407806, 0.00800113566219807, 0.00798243284225464, 0.00796331558376551, 0.00794411543756723, 0.00792441610246897, 0.00790479965507984, 0.00788443628698587, 0.00786407198756933, 0.0078432084992528, 0.00782251171767712, 0.00780098466202617, 0.00777954002842307, 0.00775767909362912, 0.00773548660799861, 0.00771304406225681, 0.00769026903435588, 0.00766724487766623, 0.00764388917014003, 0.00762036582455039, 0.00759642757475376, 0.00757232354953885, 0.00754805281758308, 0.00752320000901818, 0.00749826477840543, 0.0074728294275701, 0.0074473125860095, 0.00742137897759676, 0.00739536248147488, 0.00735856732353568, 0.00732066389173269, 0.00728267943486571, 0.00724444445222616, 0.00720629282295704, 0.00716814026236534, 0.00712998863309622, 0.00709125539287925, 0.00705301994457841, 0.00701436912640929, 0.00697588548064232, 0.00693690218031406, 0.00689833471551538, 0.00685918517410755, 0.00682036858052015, 0.00678130239248276, 0.00674215285107493, 0.0067030037753284, 0.00666377134621143, 0.00662445602938533, 0.00658480823040009, 0.00654532574117184, 0.00650584464892745, 0.00646611349657178, 0.00642621610313654, 0.00638648495078087, 0.00634642131626606, 0.00630644103512168, 0.00626646028831601, 0.00622606417164207, 0.00618583429604769, 0.00614560535177588, 0.00610504206269979, 0.00606464594602585, 0.00602400116622448, 0.00598352169618011, 0.00594246061518788, 0.00590173155069351, 0.00586075382307172, 0.00581985944882035, 0.00577871548011899, 0.00573757058009505, 0.00569617748260498, 0.00565503351390362, 0.00561364041641355, 0.0055719967931509, 0.00553060369566083, 0.00548879476264119, 0.00544723495841026, 0.0054053426720202, 0.00536353373900056, 0.0053213918581605, 0.00527950003743172, 0.00523735815659165, 0.00519488379359245, 0.00515274237841368, 0.00511035183444619, 0.00506796035915613, 0.00502523733302951, 0.00498259672895074, 0.00494012283161283, 0.00489731645211577, 0.00485434336587787, 0.00481128785759211, 0.00476831523701549, 0.00472517590969801, 0.00468203704804182, 0.00463873147964478, 0.00459542591124773, 0.00455195503309369, 0.0045085665769875, 0.00446815462782979, 0.00442642858251929, 0.00438503548502922, 0.00434405775740743, 0.00430332915857434, 0.00426301639527082, 0.00422303611412644, 0.00418355455622077, 0.00414440548047423, 0.00410583801567554, 0.00406743725761771, 0.00402978388592601, 0.00399221433326602, 0.00395497726276517, 0.00391823844984174, 0.00388208171352744, 0.00384634011425078, 0.00381076498888433, 0.00377568928524852, 0.00374119472689927, 0.00370686617679894, 0.00367320328950882, 0.00363929034210742, 0.00360645819455385, 0.00357387564145029, 0.00354154244996607, 0.00350979110226035, 0.00347845489159226, 0.00344745139591396, 0.00341644790023565, 0.00338619272224605, 0.00335660204291344, 0.00332709518261254, 0.00329833594150841, 0.00326941045932472, 0.00324081699363887, 0.00321313855238259, 0.00318570923991501, 0.0031587784178555, 0.00313218077644706, 0.00310599803924561, 0.00308023090474308, 0.00305463024415076, 0.00302944518625736, 0.00300492509268224, 0.00298065412789583, 0.00295679899863899, 0.00293344259262085, 0.00291066779755056, 0.0028879763558507, 0.00286570028401911, 0.0028435904532671, 0.00282247853465378, 0.00280136591754854, 0.00278091873042285, 0.00276055443100631, 0.00274085532873869, 0.00272157159633934, 0.00270237098447978, 0.00268358597531915, 0.00266546616330743, 0.00264776172116399, 0.00263038952834904, 0.00261343340389431, 0.00259672640822828, 0.00258035189472139, 0.00256455922499299, 0.00254943151958287, 0.00253413757309318, 0.00251992419362068, 0.0025056276936084, 0.00249166344292462, 0.00249132211320102, 0.00249348324723542, 0.00249572726897895, 0.00249838712625206, 0.00250162882730365, 0.00250536925159395, 0.0025093590375036, 0.00251409667544067, 0.0025185018312186, 0.00252390466630459, 0.00252963998354971, 0.00253604026511312, 0.00254244008101523, 0.00254967156797647, 0.00255715218372643, 0.00256463303230703, 0.00257319444790483, 0.00258175539784133, 0.00259106489829719, 0.00260062352754176, 0.0026108471211046, 0.00262123695574701, 0.00263195927254856, 0.00264318031258881, 0.00265514943748713, 0.00266720168292522, 0.0026799188926816, 0.00269288546405733, 0.00270651699975133, 0.0027200651820749, 0.00273452792316675, 0.0027489906642586, 0.00276436796411872, 0.00277991103939712, 0.00279603595845401, 0.00281241023913026, 0.00282944971695542, 0.0028464060742408, 0.00286419340409338, 0.00288239656947553, 0.00290101510472596, 0.00291988323442638, 0.00293933274224401, 0.00295928143896163, 0.0029792299028486, 0.00300017581321299, 0.00302112218923867, 0.00304289907217026, 0.0030648426618427, 0.00308753363788128, 0.003110391786322, 0.003133415710181, 0.00315693812444806, 0.00318129220977426, 0.00320589542388916, 0.00323099712841213, 0.00325626553967595, 0.00328236445784569, 0.00330829783342779, 0.00333531107753515, 0.00336207542568445, 0.00338983698748052, 0.00341768190264702, 0.003446358256042, 0.00347511726431549, 0.0035044583491981, 0.00353379920125008, 0.00356388837099075, 0.00359464227221906, 0.00362547906115651, 0.00365698104724288, 0.00369338737800717, 0.00372796505689621, 0.00376220978796482, 0.00379670411348343, 0.0038308659568429, 0.00386527739465237, 0.00389960547909141, 0.00393385021016002, 0.00396809540688992, 0.00400234013795853, 0.00403633574023843, 0.00407049804925919, 0.00410465942695737, 0.00413865549489856, 0.00417265063151717, 0.00420664669945836, 0.00424055894836783, 0.00427447119727731, 0.00430813431739807, 0.00434212991967797, 0.00437579303979874, 0.00440962286666036, 0.00444336887449026, 0.00447694910690188, 0.00451061222702265, 0.00454435823485255, 0.00457785557955503, 0.00461143534630537, 0.00464501557871699, 0.00467834621667862, 0.00471192598342896, 0.00474533997476101, 0.00477867061272264, 0.00481200125068426, 0.00484524900093675, 0.00487857963889837, 0.00491191027686, 0.00494499132037163, 0.00497823907062411, 0.00501132011413574, 0.00504431826993823, 0.00507756602019072, 0.0051105641759932, 0.00514347944408655, 0.00517647713422775, 0.0052093924023211, 0.00524239102378488, 0.00527522247284651, 0.00530797149986029, 0.00534063717350364, 0.00537330331280828, 0.00540605187416077, 0.00543880043551326, 0.00547130033373833, 0.00550404889509082, 0.00553671456873417, 0.00556913111358881, 0.00560163054615259, 0.00563412997871637, 0.00566646317020059, 0.00569896260276437, 0.00573146203532815, 0.00576362898573279, 0.00579596171155572, 0.00582812912762165, 0.00586037896573544, 0.00589262973517179, 0.00592471333220601, 0.00595688028261065, 0.00598904769867659, 0.00602104840800166, 0.00605304911732674, 0.00607493193820119, 0.00609579402953386, 0.00611657369881868, 0.00613668886944652, 0.00615680404007435, 0.00617675203830004, 0.00619611842557788, 0.00621565245091915, 0.00623443676158786, 0.00625322200357914, 0.00627184053882957, 0.00628987746313214, 0.00630791438743472, 0.00632570125162601, 0.00634290790185332, 0.00636003026738763, 0.0063768201507628, 0.00639344425871968, 0.00640973495319486, 0.00642594322562218, 0.00644156988710165, 0.00645702984184027, 0.00647240737453103, 0.00648720283061266, 0.00650208070874214, 0.00651637697592378, 0.00653059035539627, 0.00654447125270963, 0.00655793724581599, 0.00657140230759978, 0.00658428575843573, 0.00659725209698081, 0.00660980306565762, 0.00662193866446614, 0.00663407379761338, 0.0066457106731832, 0.00665709748864174, 0.00666831946000457, 0.00667937425896525, 0.00668984744697809, 0.00670023635029793, 0.00671029416844249, 0.00672010239213705, 0.00672974344342947, 0.00673888670280576, 0.00674786418676376, 0.00675684073939919, 0.00676515232771635, 0.00677354820072651, 0.00678136153146625, 0.00678900768980384, 0.00679632229730487, 0.00680338777601719, 0.00681028654798865, 0.00681677041575313, 0.00682300329208374, 0.00682907132431865, 0.00683480687439442, 0.00684037571772933, 0.00684561161324382, 0.00685051595792174, 0.00685517070814967, 0.00685974210500717, 0.00686381524428725, 0.00686763878911734, 0.00687137898057699, 0.00687453802675009, 0.00687777949497104, 0.00688052223995328, 0.00688284961506724, 0.00688534323126078, 0.00688331108540297, 0.00688261445611715, 0.0068816589191556, 0.00688075460493565, 0.00687943492084742, 0.00687802210450172, 0.00687674432992935, 0.00687511311843991, 0.00687347212806344, 0.00687158107757568, 0.00686959596350789, 0.0068675703369081, 0.00686530489474535, 0.00686303013935685, 0.00686046341434121, 0.00685783475637436, 0.00685516465455294, 0.0068521611392498, 0.00684919022023678, 0.00684598973020911, 0.00684276921674609, 0.00683927768841386, 0.00683570327237248, 0.00683211954310536, 0.00682816049084067, 0.00682421261444688, 0.00681998487561941, 0.0068157552741468, 0.006811433006078, 0.00680688256397843, 0.00680236238986254, 0.00679749017581344, 0.00679267989471555, 0.00678760977461934, 0.00678237248212099, 0.0067771770991385, 0.00677165063098073, 0.00676618469879031, 0.00676037697121501, 0.00675447611138225, 0.00674861576408148, 0.00674243411049247, 0.00673632463440299, 0.00672985101118684, 0.0067234723828733, 0.00671680178493261, 0.00670979917049408, 0.00670302426442504, 0.0066959080286324, 0.00668878015130758, 0.00668146507814527, 0.00667387060821056, 0.00666645262390375, 0.00665867002680898, 0.00665088789537549, 0.00664282543584704, 0.00663485610857606, 0.00662653427571058, 0.00661809649318457, 0.0066096605733037, 0.00660096434876323, 0.00659223692491651, 0.00658323895186186, 0.00657414784654975, 0.00656505627557635, 0.00655570579692721, 0.00654631340876222, 0.00653668167069554, 0.00652704061940312, 0.0065171173773706, 0.00650710193440318, 0.00650159269571304, 0.00649619987234473, 0.00649064127355814, 0.00648510362952948, 0.00647947238758206, 0.00647385139018297, 0.00646814750507474, 0.00646233931183815, 0.00645646918565035, 0.00645064050331712, 0.00644470751285553, 0.00643866090103984, 0.00643254164606333, 0.00642645265907049, 0.00642025005072355, 0.00641400506719947, 0.00640763668343425, 0.00640127807855606, 0.00639493996277452, 0.00638844631612301, 0.00638188002631068, 0.00637523038312793, 0.00636863242834806, 0.00636193156242371, 0.00635509425774217, 0.00634828908368945, 0.00634138006716967, 0.0063344812951982, 0.00632749870419502, 0.00632040295749903, 0.00631331652402878, 0.00630610669031739, 0.00629886472597718, 0.00629156036302447, 0.00628418335691094, 0.00627681752666831, 0.00626932550221682, 0.00626178272068501, 0.00625419849529862, 0.00624658307060599, 0.00623889407142997, 0.00623110216110945, 0.00622323667630553, 0.00621537119150162, 0.00620749592781067, 0.00619950611144304, 0.00619143294170499, 0.00618327734991908, 0.00617516227066517, 0.0061669647693634, 0.00615861173719168, 0.00615025823935866, 0.00614192523062229, 0.00613344740122557, 0.00612492766231298, 0.0061163455247879, 0.00610769027844071, 0.00609902525320649, 0.00609026663005352, 0.00608142511919141, 0.00607259338721633, 0.00606367876753211, 0.00605467101559043, 0.00604562181979418, 0.00603649858385324, 0.00602743914350867, 0.00601819204166532, 0.00600889325141907, 0.00599953159689903, 0.00599019136279821, 0.0059807263314724, 0.00597119843587279, 0.0059550516307354, 0.00594441266730428, 0.00593369081616402, 0.00592280179262161, 0.00591182988137007, 0.00590077508240938, 0.0058897202834487, 0.0058784163556993, 0.00586711196228862, 0.00585564179345965, 0.0058441711589694, 0.00583270052447915, 0.0058210645802319, 0.0058092619292438, 0.0057974592782557, 0.00578557280823588, 0.00577352102845907, 0.00576138449832797, 0.00574924983084202, 0.00573694799095392, 0.00572464661672711, 0.00571217900142074, 0.00569962756708264, 0.00568707706406713, 0.00567435938864946, 0.00566164217889309, 0.00564867584034801, 0.00563570950180292, 0.00562265980988741, 0.00560952723026276, 0.00559622794389725, 0.00558301154524088, 0.00556962983682752, 0.0055560814216733, 0.00554253300651908, 0.00552873546257615, 0.0055151036940515, 0.00550130615010858, 0.00548734189942479, 0.00547329522669315, 0.0054591647349298, 0.00544511759653687, 0.00543082132935524, 0.00541635835543275, 0.00540197920054197, 0.00538743287324905, 0.00537280458956957, 0.00535809248685837, 0.00534329703077674, 0.00532841915264726, 0.00531345745548606, 0.00529841287061572, 0.00528320204466581, 0.00526807457208633, 0.00525261461734772, 0.00523732043802738, 0.00522177712991834, 0.00520623428747058, 0.00519052473828197, 0.00517473230138421, 0.00515893939882517, 0.00514298072084785, 0.00512702157720923, 0.00511089665815234, 0.00509460549801588, 0.00507831433787942, 0.0050621060654521, 0.00504556531086564, 0.00502902455627918, 0.00501240091398358, 0.00499561103060842, 0.00497680250555277, 0.00495581468567252, 0.0049349102191627, 0.00491421343758702, 0.00489339232444763, 0.00487261218950152, 0.0048519573174417, 0.00483113573864102, 0.0048104808665812, 0.00479003321379423, 0.00476921163499355, 0.00474868156015873, 0.00472806766629219, 0.00470745470374823, 0.00468700751662254, 0.00466647651046515, 0.00464615412056446, 0.00462562358006835, 0.0046052597463131, 0.00458497833460569, 0.00456444779410958, 0.00454416684806347, 0.0045238439925015, 0.00450339680537581, 0.00448328210040927, 0.00446304259821773, 0.00444267829880118, 0.00442260503768921, 0.00440248986706138, 0.00438233371824026, 0.00436230190098286, 0.00434202095493674, 0.00432198913767934, 0.00430216547101736, 0.00428205030038953, 0.00426214374601841, 0.00424215290695429, 0.00422232924029231, 0.00420229742303491, 0.00418259855359793, 0.00416273297742009, 0.00414282595738769, 0.00412304326891899, 0.00410326104611158, 0.00408352026715875, 0.00406386284157634, 0.00404420495033264, 0.00402442226186395, 0.00400484818965197, 0.00398531509563327, 0.003965615760535, 0.0039460826665163, 0.00392659148201346, 0.00390697503462434, 0.00388764985837042, 0.00386828323826194, 0.00384866679087281, 0.00382938352413476, 0.00381010002456605, 0.0037906498182565, 0.0037713663186878, 0.00375212426297367, 0.00373271596617997, 0.00371364015154541, 0.00369435641914606, 0.00367511413060129, 0.00365595542825758, 0.00363687961362302, 0.00361776235513389, 0.00359864486381412, 0.00357961049303412, 0.00356053467839956, 0.0035508640576154, 0.00353623507544398, 0.00352135673165321, 0.00350697664543986, 0.00349268037825823, 0.00347821763716638, 0.0034642533864826, 0.00345037272199988, 0.00343657471239567, 0.0034227769356221, 0.00340947788208723, 0.0033960125874728, 0.00338271330110729, 0.00336966360919178, 0.00335669727064669, 0.00334397959522903, 0.00333126215264201, 0.00331854494288564, 0.00330632645636797, 0.00329394149594009, 0.00328172324225307, 0.00326991989277303, 0.00325795100070536, 0.00324623100459576, 0.0032347603701055, 0.0032232899684459, 0.00321198580786586, 0.00320093100890517, 0.00318987620994449, 0.00317915366031229, 0.00316826510243118, 0.00315770879387856, 0.0031473187264055, 0.00313667976297438, 0.00312670529820025, 0.00311673083342612, 0.00310675660148263, 0.00309694861061871, 0.00308755598962307, 0.00307783111929893, 0.00306868809275329, 0.00305921235121787, 0.00305040157400072, 0.00304159126244485, 0.00303261401131749, 0.00302396970801055, 0.00301565788686275, 0.00300701335072517, 0.00299903354607522, 0.00299105443991721, 0.00298307510092854, 0.0029750952962786, 0.00296753155998886, 0.00295996759086847, 0.0029525700956583, 0.00294550484977663, 0.00293827336281538, 0.00293129123747349, 0.00292464182712138, 0.00291790929622948, 0.00291117606684566, 0.00290494225919247, 0.00289862556383014, 0.00289247464388609, 0.00288648996502161, 0.00288058840669692, 0.00287485308945179, 0.00286945072002709, 0.00286396476440132, 0.00285864528268576, 0.00285357469692826, 0.00284722680225968, 0.00284439022652805, 0.00284150172956288, 0.00283888378180563, 0.00283634848892689, 0.00283375103026628, 0.00283141317777336, 0.00282908603549004, 0.00282676890492439, 0.00282452465035021, 0.00282239471562207, 0.00282036862336099, 0.00281850877217948, 0.00281650363467634, 0.00281484122388065, 0.0028131790459156, 0.00281146448105574, 0.00280997878871858, 0.00280860741622746, 0.00280708004720509, 0.00280590588226914, 0.00280464882962406, 0.0028034953866154, 0.00280242529697716, 0.00280163553543389, 0.0028005966451019, 0.00279979663901031, 0.00279903807677329, 0.00279844575561583, 0.00279794726520777, 0.00279738614335656, 0.00279700173996389, 0.00279679382219911, 0.00279640965163708, 0.00279638869687915, 0.0027962950989604, 0.00279622245579958, 0.00279639917425811, 0.00279659638181329, 0.00279672117903829, 0.00279717822559178, 0.00279764598235488, 0.00279805110767484, 0.00279863295145333, 0.00279939151369035, 0.00279999384656549, 0.00280086672864854, 0.00280183320865035, 0.00280271610245109, 0.00280387979000807, 0.00280502275563776, 0.00280619692057371, 0.00280754757113755, 0.00280900206416845, 0.00281037343665957, 0.00281201512552798, 0.0028135736938566, 0.00281530898064375, 0.00281698163598776, 0.00281899725086987, 0.00282094022259116, 0.00282298680394888, 0.00282511673867702, 0.00282743386924267, 0.00282959477044642, 0.00283198454417288, 0.0028344988822937, 0.0028369405772537, 0.00283955899067223, 0.00284236413426697, 0.00284500303678215, 0.00284799560904503, 0.00284940865822136, 0.00285026081837714, 0.00285113323479891, 0.00285206828266382, 0.00285296188667417, 0.00285393837839365, 0.00285493605770171, 0.00285593350417912, 0.0028569723945111, 0.00285802176222205, 0.002859071129933, 0.00286018312908709, 0.00286127370782197, 0.00286243786104023, 0.00286362203769386, 0.00286480644717813, 0.00286602228879929, 0.00286724790930748, 0.00286850519478321, 0.00286977272480726, 0.00287109264172614, 0.00287241186015308, 0.0028737832326442, 0.00287516484968364, 0.00287656765431166, 0.00287800165824592, 0.00287940446287394, 0.00288086920045316, 0.0028823756147176, 0.00288389250636101, 0.00288544059731066, 0.00288700964301825, 0.00288859917782247, 0.00289020990021527, 0.00289180967956781, 0.00289347185753286, 0.00289514497853816, 0.00289685954339802, 0.00289858411997557, 0.00290033989585936, 0.00290211639367044, 0.00290387240238488, 0.00290570105426013, 0.00290755042806268, 0.00290942052379251, 0.00291131134144962, 0.00291323382407427, 0.0029151663184166, 0.00291710905730724, 0.00291910395026207, 0.00292108836583793, 0.00292311445809901, 0.00292518176138401, 0.0029272495303303, 0.00292935874313116, 0.00293148867785931, 0.00293360813520849, 0.0029357795137912, 0.00293796136975288, 0.00294017442502081, 0.00294241891242564, 0.00294468365609646, 0.00294696935452521, 0.00294928648509085, 0.00295158242806792, 0.0029539514798671, 0.00295632053166628, 0.00295870983973145, 0.00296115153469145, 0.00296361395157874, 0.00296605541370809, 0.00296733388677239, 0.00297324568964541, 0.00297891837544739, 0.00298444577492774, 0.00298998411744833, 0.00299535528756678, 0.00300092436373234, 0.00300622312352061, 0.00301138730719686, 0.00301656126976013, 0.00302183954045177, 0.0030268682166934, 0.00303183449432254, 0.00303672812879086, 0.00304143456742167, 0.00304635940119624, 0.0030510351061821, 0.0030556374695152, 0.0030601778998971, 0.00306462519802153, 0.00306918611750007, 0.00307350838556886, 0.00307765416800976, 0.00308191380463541, 0.00308601791039109, 0.00309021561406553, 0.00309418421238661, 0.00309808040037751, 0.00310189346782863, 0.00310578965581954, 0.00310946791432798, 0.00311306281946599, 0.00311668892391026, 0.00312014878727496, 0.00312370178289711, 0.00312701635994017, 0.00313033093698323, 0.003133499994874, 0.00313661643303931, 0.00313989981077611, 0.0031428502406925, 0.00314583233557642, 0.00314864818938076, 0.00315147405490279, 0.00315430038608611, 0.00315689784474671, 0.0031595160253346, 0.00316197844222188, 0.00316444085910916, 0.00316693470813334, 0.00316926185041666, 0.00317151634953916, 0.00317368772812188, 0.00317589030601084, 0.0031778437551111, 0.003179817693308, 0.00318163586780429, 0.00318371411412954, 0.00318536581471562, 0.00318705919198692, 0.00318866991437972, 0.00319013511762023, 0.00319177657365799, 0.00319316890090704, 0.00319449882954359, 0.00319575564935803, 0.00319691910408437, 0.00319819734431803, 0.00319924671202898, 0.00320021295920014, 0.00320103368721902, 0.00320109724998474, 0.00319951772689819, 0.00319760595448315, 0.00319536193273962, 0.00319303455762565, 0.00319045782089233, 0.00318779842928052, 0.00318505545146763, 0.00318189663812518, 0.00317865516990423, 0.00317499786615372, 0.00317150680348277, 0.00316760037094355, 0.00316352723166347, 0.00315928808413446, 0.00315496581606567, 0.00315047753974795, 0.00314573966898024, 0.00314083555713296, 0.00313576543703675, 0.00313052861019969, 0.00312487711198628, 0.00311914132907987, 0.00311340624466538, 0.00310742156580091, 0.00310118729248643, 0.00309470435604453, 0.00308805471286178, 0.0030812390614301, 0.00307442340999842, 0.00306727481074631, 0.0030598770827055, 0.00305231334641576, 0.00304450024850667, 0.00303660379722714, 0.00302837486378849, 0.00302006304264069, 0.00301175098866224, 0.00300294044427574, 0.00299421278759837, 0.00298515288159251, 0.00297600962221622, 0.00296645076014102, 0.00295714172534645, 0.00294716749340296, 0.00293719302862883, 0.00292713544331491, 0.0029167456086725, 0.00290635554119945, 0.0028956332243979, 0.00288466131314635, 0.00287352339364588, 0.0028622190002352, 0.00285108131356537, 0.00283936131745577, 0.00282747508026659, 0.0028154228348285, 0.0028033705893904, 0.00279098586179316, 0.00277826841920614, 0.00276546785607934, 0.00275250151753426, 0.00273953471332788, 0.00272615253925323, 0.00271260412409902, 0.00269880634732544, 0.00268509145826101, 0.00267112744040787, 0.00265683094039559, 0.00264245108701289, 0.00262773898430169, 0.00261311000213027, 0.00260495487600565, 0.00258276215754449, 0.00256065255962312, 0.00253879209049046, 0.0025165993720293, 0.00249432353302836, 0.00247204769402742, 0.00244985474273562, 0.00242732954211533, 0.00240513659082353, 0.00238294387236238, 0.0023603355512023, 0.002337810350582, 0.00231536803767085, 0.00229284260421991, 0.00227023428305984, 0.00224754284135997, 0.00222518388181925, 0.00220232596620917, 0.00217980076558888, 0.00215710909105837, 0.00213441764935851, 0.00211139372549951, 0.00208878517150879, 0.00206576124764979, 0.00204290333203971, 0.00202004564926028, 0.00199718796648085, 0.00197399780154228, 0.00195105688180774, 0.00192794960457832, 0.00190475932322443, 0.00188173539936543, 0.00185862835496664, 0.00183543795719743, 0.00181216467171907, 0.00178864202462137, 0.00176536850631237, 0.00174192897975445, 0.00171865569427609, 0.00169529893901199, 0.00167177629191428, 0.00164825364481658, 0.00162473088130355, 0.0016012912383303, 0.00157751911319792, 0.00155399646610022, 0.0015303905820474, 0.00150678493082523, 0.00148284644819796, 0.00145907420665026, 0.00143538531847298, 0.00141161330975592, 0.00138767494354397, 0.00136373657733202, 0.00133979821112007, 0.00131594308186322, 0.0012918384745717, 0.00126773398369551, 0.00124362925998867, 0.00121960788965225, 0.00119525392074138, 0.00117106619291008, 0.00114696170203388, 0.00112277397420257, 0.00109833688475192, 0.00107398291584104, 0.00104962906334549, 0.00102544133551419, 0.00100083800498396, 0.000976400973740965, 0.000955783994868398, 0.000932011986151338, 0.000908406276721507, 0.000884883629623801, 0.000861693464685231, 0.000838835665490478, 0.000816476705949754, 0.000794284045696259, 0.000772257510107011, 0.000750729697756469, 0.000729451247025281, 0.0007086715195328, 0.000687725550960749, 0.000667610845994204, 0.000647246721200645, 0.000627630681265146, 0.000608263944741338, 0.000589063507504761, 0.000570029253140092, 0.000551992503460497, 0.000533955695573241, 0.000515170802827924, 0.000497632718179375, 0.000480427115689963, 0.00046338772517629, 0.000446514633949846, 0.000430306448834017, 0.000414347625337541, 0.000398471893277019, 0.00038301179301925, 0.000368050416000187, 0.000353089009877294, 0.000338460056809708, 0.000324246735544875, 0.000310615228954703, 0.000296734389849007, 0.000283518485957757, 0.000270635064225644, 0.000258416606811807, 0.0002460319083184, 0.00023414587485604, 0.000222010537981987, 0.000210207639611326, 0.000199069720110856, 0.000188098027138039, 0.000177625042852014, 0.000167401420185342, 0.000157593400217593, 0.000148034727317281, 0.000138642295496538, 0.000129748572362587, 0.000121104196296073, 0.000112542962597217, 0.000104729791928548, 9.71659683273174e-05, 8.93527976586483e-05, 8.25370516395196e-05, 7.56381778046489e-05, 6.93211477482691e-05, 6.27547560725361e-05, 5.69364310649689e-05, 5.1367467676755e-05, 4.61309718957637e-05, 4.13932029914577e-05, 3.6655426811194e-05, 3.2499483495485e-05, 2.84266570815817e-05, 2.44369512074627e-05, 2.06134809559444e-05, 1.75380828295602e-05, 1.50445175677305e-05, 1.25509513964062e-05, 3.82346252081334e-06, 1.14704398583854e-05, 1.96161308849696e-05, 2.82605378743028e-05, 3.70711823052261e-05, 4.6546778321499e-05, 5.63548528589308e-05, 6.64954059175216e-05, 7.69684338592924e-05, 8.77739221323282e-05, 9.92443892755546e-05, 0.000110714841866866, 0.000122850251500495, 0.000135318128741346, 0.000147786020534113, 0.00016091886209324, 0.000174384156707674, 0.000188181962585077, 0.000202644703676924, 0.000216941203689203, 0.00023206889454741, 0.000247362826485187, 0.000263487978372723, 0.000278948136838153, 0.000295405741780996, 0.000312362040858716, 0.000329318369040266, 0.000347105873515829, 0.000365225889254361, 0.00038367829984054, 0.000402463250793517, 0.000421248201746494, 0.000440864328993484, 0.000460979150375351, 0.000481093971757218, 0.000501873786561191, 0.000522653572261333, 0.00054426456335932, 0.000565875554457307, 0.000587985268794, 0.000610427465289831, 0.000633534567896277, 0.000656807911582291, 0.000680081313475966, 0.000704518286511302, 0.000728622952010483, 0.00075272744288668, 0.000777829438447952, 0.000803430215455592, 0.000829529541078955, 0.00085546268383041, 0.000882559572346509, 0.000909656402654946, 0.000937085773330182, 0.000964681268669665, 0.000992941786535084, 0.00102136854548007, 0.00105046026874334, 0.0010795519920066, 0.00110930867958814, 0.00113923149183393, 0.00116965314373374, 0.00120040727779269, 0.00123149377759546, 0.00126324535813183, 0.00129532930441201, 0.00132724700961262, 0.00135949731338769, 0.00139224622398615, 0.00142599258106202, 0.00145973893813789, 0.00148185400757939, 0.00152258248999715, 0.00156331108883023, 0.00160453817807138, 0.00164526677690446, 0.00168616184964776, 0.00172705645672977, 0.00176811753772199, 0.00180884613655508, 0.00184924202039838, 0.00188997061923146, 0.00193119794130325, 0.0019715940579772, 0.00201248866505921, 0.00205321726389229, 0.00209411210380495, 0.00213467446155846, 0.00217507057823241, 0.00221579894423485, 0.00225652754306793, 0.00229758862406015, 0.00233798450790346, 0.00237887958064675, 0.00241910922341049, 0.00245983758941293, 0.00250023370608687, 0.00254112854599953, 0.00258152466267347, 0.00262208702042699, 0.0026626493781805, 0.00270321173593402, 0.00274377386085689, 0.00278416997753084, 0.00282473233528435, 0.0028651284519583, 0.00290552456863225, 0.00294575421139598, 0.00298598408699036, 0.00302687869407237, 0.00306677585467696, 0.00310767092742026, 0.00314773456193507, 0.00318829691968858, 0.00322869303636253, 0.00326875667087734, 0.00330948503687978, 0.00334938219748437, 0.00338994478806853, 0.00343000842258334, 0.00347057078033686, 0.00351063394919038, 0.0035508640576154, 0.00359142618253827, 0.00363132357597351, 0.00367188616655767, 0.00371178332716227, 0.00375184672884643, 0.00379191036336124, 0.00383214023895562, 0.00387220410630107, 0.00391243398189545, 0.00395283009856939, 0.00399272702634335, 0.00403262441977859, 0.00407268805429339, 0.0041127516888082, 0.00415264908224344, 0.00419287895783782, 0.00423277635127306, 0.00427283952012658, 0.00431273737922311, 0.00435246806591749, 0.00439218385145068, 0.00442327000200748, 0.00445485487580299, 0.00448560947552323, 0.00451586488634348, 0.00454562110826373, 0.00457554450258613, 0.00460480246692896, 0.00463339500129223, 0.0046618222258985, 0.00469024851918221, 0.00471817655488849, 0.00474510760977864, 0.00477270316332579, 0.00479913502931595, 0.0048250681720674, 0.00485116755589843, 0.00487710069864988, 0.00490236934274435, 0.00492647336795926, 0.00495174154639244, 0.00497567979618907, 0.00499961851164699, 0.00502289179712534, 0.00504550011828542, 0.00506827514618635, 0.00509088300168514, 0.00511232763528824, 0.00513360649347305, 0.00515455240383744, 0.00517616327852011, 0.00519594550132751, 0.00521606067195535, 0.00523600913584232, 0.00525529310107231, 0.00527424411848187, 0.00529236439615488, 0.00531131494790316, 0.00532877026125789, 0.00534639181569219, 0.00536301545798779, 0.00538030406460166, 0.00539642944931984, 0.00541255436837673, 0.00542884552851319, 0.00544330896809697, 0.00545827019959688, 0.00547240022569895, 0.00548736145719886, 0.0055004945024848, 0.00551412627100945, 0.0055272588506341, 0.00553972646594048, 0.005551862064749, 0.00556432968005538, 0.00557546829804778, 0.00558660598471761, 0.00559791037812829, 0.00560838310047984, 0.00561835709959269, 0.0056278333067894, 0.0056374748237431, 0.00564661808311939, 0.00565476389601827, 0.00566357420757413, 0.00567105505615473, 0.00567853543907404, 0.00568568427115679, 0.00569266639649868, 0.00569914933294058, 0.00570463528856635, 0.00572564452886581, 0.00572348292917013, 0.00572015857324004, 0.00571641838178039, 0.00571342557668686, 0.0057091866619885, 0.00570494728162885, 0.00570037635043263, 0.00569572113454342, 0.00569040141999722, 0.00568566378206015, 0.00568009447306395, 0.00567394401878119, 0.00566779309883714, 0.00566214136779308, 0.00565507588908076, 0.00564809376373887, 0.00564161082729697, 0.00563371414318681, 0.0056259841658175, 0.00561800505965948, 0.00561027508229017, 0.00560171389952302, 0.00559257064014673, 0.0055833444930613, 0.00557445082813501, 0.00556505797430873, 0.00555508397519588, 0.00554527621716261, 0.00553472014144063, 0.00552383111789823, 0.00551261054351926, 0.005501804407686, 0.00549016846343875, 0.00547819910570979, 0.0054668951779604, 0.00545401172712445, 0.00544237485155463, 0.00542907556518912, 0.0054157767444849, 0.00540256081148982, 0.00538951111957431, 0.00537538109347224, 0.00536083523184061, 0.00534653896465898, 0.00533190974965692, 0.00531661650165915, 0.00530132185667753, 0.00528627773746848, 0.0052704019472003, 0.00525435991585255, 0.00523781916126609, 0.00522152800112963, 0.00520465476438403, 0.00518728327006102, 0.00516974460333586, 0.00515262270346284, 0.00513450242578983, 0.00511629972606897, 0.0050982628017664, 0.00507939467206597, 0.00506027741357684, 0.00504074431955814, 0.00502171041443944, 0.0050010965205729, 0.0049815634265542, 0.00496119959279895, 0.00494008744135499, 0.0049191415309906, 0.00489869434386492, 0.00487708300352097, 0.00484533188864589, 0.00482463510707021, 0.00480402214452624, 0.00478349160403013, 0.00476287817582488, 0.0047424309886992, 0.00472181756049395, 0.00470153614878654, 0.00468100607395172, 0.00466047553345561, 0.00464036036282778, 0.00461983028799295, 0.0045994664542377, 0.00457935128360987, 0.00455898744985461, 0.00453878939151764, 0.00451867468655109, 0.00449839374050498, 0.00447811279445887, 0.00445799808949232, 0.00443804915994406, 0.0044179349206388, 0.0043979031033814, 0.00437787128612399, 0.00435775658115745, 0.00433797435835004, 0.00431794254109263, 0.00429791118949652, 0.00427821138873696, 0.00425826339051127, 0.00423839781433344, 0.00421869847923517, 0.00419883336871862, 0.00417913449928164, 0.00415943469852209, 0.00413965247571468, 0.0041199536062777, 0.00410025427117944, 0.00408072117716074, 0.00406110566109419, 0.00404148874804378, 0.00402212236076593, 0.0040025063790381, 0.0039829732850194, 0.00396377313882113, 0.00394424051046371, 0.00392479030415416, 0.00390550680458546, 0.00388605706393719, 0.0038666904438287, 0.0038474895991385, 0.0038282060995698, 0.00380900572054088, 0.00378972198814154, 0.0037706047296524, 0.00375140458345413, 0.00373228685930371, 0.00371325295418501, 0.00369405210949481, 0.00367518444545567, 0.00365606672130525, 0.00363703304901719, 0.00361816468648612, 0.00359913078136742, 0.003580262651667, 0.00356147764250636, 0.0035425266250968, 0.00352365872822702, 0.00350487371906638, 0.00348608894273639, 0.00346738705411553, 0.00344851892441511, 0.00342800095677376, 0.00341495126485825, 0.0034020678140223, 0.00338918436318636, 0.00337655050680041, 0.00336399953812361, 0.00335169769823551, 0.00333931273780763, 0.00332726072520018, 0.00331545784138143, 0.00330348871648312, 0.00329185207374394, 0.0032802983187139, 0.0032688279170543, 0.00325760710984468, 0.003246302716434, 0.00323541392572224, 0.00322460848838091, 0.00321372016333044, 0.00320324674248695, 0.00319285690784454, 0.00318246730603278, 0.00317232683300972, 0.00316210277378559, 0.00315229478292167, 0.00314256991259754, 0.0031328450422734, 0.00312353577464819, 0.00311414315365255, 0.00310483388602734, 0.00309585710056126, 0.00308679696172476, 0.00307806953787804, 0.00306934188120067, 0.00306078069843352, 0.00305238575674593, 0.00304415682330728, 0.00303601124323905, 0.00302786543034017, 0.00302013545297086, 0.00301240547560155, 0.00300484150648117, 0.00299744377844036, 0.00299021229147911, 0.00298298103734851, 0.00297599891200662, 0.00296901701949537, 0.00296236760914326, 0.0029557179659605, 0.0029493176843971, 0.00294300098903477, 0.00293693318963051, 0.0029307825025171, 0.00292479759082198, 0.00291897915303707, 0.00291341030970216, 0.00290792435407639, 0.00290252198465168, 0.00289728539064527, 0.00289229792542756, 0.00288731092587113, 0.00288248970173299, 0.00287800165824592, 0.00287343002855778, 0.00286885839886963, 0.00286461971700191, 0.00286062969826162, 0.00285655679181218, 0.00285273347981274, 0.00284907617606223, 0.00284541887231171, 0.00285108131356537, 0.00284891994670033, 0.00284709129482508, 0.00284517975524068, 0.00284318486228585, 0.00284152245149016, 0.00283977692015469, 0.00283794826827943, 0.00283645209856331, 0.00283470656722784, 0.00283329351805151, 0.00283188046887517, 0.00283038429915905, 0.00282913749106228, 0.00282789068296552, 0.00282664387486875, 0.00282548018731177, 0.002824233379215, 0.00282331905327737, 0.0028223218396306, 0.00282140751369298, 0.00282057630829513, 0.0028196619823575, 0.00281899701803923, 0.00281824893318117, 0.00281758396886289, 0.00281708524562418, 0.00281650340184569, 0.00281600467860699, 0.00281567219644785, 0.00281525659374893, 0.00281500723212957, 0.00281484099105, 0.00281459162943065, 0.00281450850889087, 0.0028143422678113, 0.00281442538835108, 0.00281459162943065, 0.00281459162943065, 0.00281475787051022, 0.0028150905855, 0.00281525659374893, 0.00281575531698763, 0.00281600467860699, 0.00281650340184569, 0.00281708524562418, 0.00281758396886289, 0.00281833205372095, 0.00281891389749944, 0.00281974510289729, 0.00282049318775535, 0.00282132439315319, 0.00282240496017039, 0.00282323616556823, 0.00282439985312521, 0.0028255635406822, 0.00282656075432897, 0.00282789068296552, 0.0028290543705225, 0.00283046765252948, 0.0028319638222456, 0.00283321039751172, 0.00283487280830741, 0.00283645209856331, 0.00283803138881922, 0.00283977692015469, 0.00284135621041059, 0.00284326774999499, 0.00284517975524068, 0.00284700840711594, 0.0028490861877799, 0.00285108131356537, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284866034053266, 0.00284732040017843, 0.00284989690408111, 0.00285222427919507, 0.00285446853376925, 0.00285662990063429, 0.00285895704291761, 0.00286095170304179, 0.00286294659599662, 0.00286477524787188, 0.00286668702028692, 0.0028685990255326, 0.00287034432403743, 0.00287192338146269, 0.0028735026717186, 0.0028750819619745, 0.00287657813169062, 0.00287782493978739, 0.00287915486842394, 0.00288048479706049, 0.00288164848461747, 0.00288264593109488, 0.00288389273919165, 0.0028847239445895, 0.00288563827052712, 0.00288638612255454, 0.00288730044849217, 0.00288796541281044, 0.00288854725658894, 0.00288904597982764, 0.00288962782360613, 0.00288996030576527, 0.00289029278792441, 0.00289054214954376, 0.0028908746317029, 0.00289095775224268, 0.00289095775224268, 0.00289095775224268, 0.00289095775224268, 0.00289079174399376, 0.00289054214954376, 0.00289020943455398, 0.00288996030576527, 0.00288954493589699, 0.0028889630921185, 0.00288838124834001, 0.00288779917173088, 0.00288705108687282, 0.00288622011430562, 0.00288538890890777, 0.00288455747067928, 0.00288356025703251, 0.00288239656947553, 0.00288123264908791, 0.00288015231490135, 0.00287890550680459, 0.00287749245762825, 0.00287607964128256, 0.00287466635927558, 0.00287308730185032, 0.00287142465822399, 0.00286976248025894, 0.00286810006946325, 0.002866271417588, 0.00286427652463317, 0.00286228186450899, 0.00286037009209394, 0.00285820872522891, 0.00285596470348537, 0.00285372044891119, 0.00285147642716765, 0.00284914905205369, 0.00284657231532037, 0.00283443694934249, 0.00282961595803499, 0.00282479519955814, 0.0028196417260915, 0.0028145716059953, 0.00280908565036952, 0.00280351680703461, 0.0027976983692497, 0.00279196328483522, 0.00278581236489117, 0.00277982791885734, 0.00277351075783372, 0.00276711047627032, 0.00276046106591821, 0.00275372853502631, 0.00274674640968442, 0.00273976451717317, 0.00273261638358235, 0.00272521865554154, 0.00271773803979158, 0.00271017430350184, 0.00270236097276211, 0.00269421539269388, 0.00268615270033479, 0.00267792399972677, 0.00266944570466876, 0.00266080140136182, 0.00265207421034575, 0.00264342967420816, 0.0026343697682023, 0.00262514338828623, 0.00261583412066102, 0.00260627549141645, 0.00259671686217189, 0.0025867426302284, 0.00257693463936448, 0.00256696040742099, 0.00255681970156729, 0.00254626362584531, 0.00253579067066312, 0.00252506835386157, 0.0025141800288111, 0.00250320811755955, 0.00249190395697951, 0.00248076603747904, 0.002469461876899, 0.00245782523415983, 0.00244618882425129, 0.00243413634598255, 0.00242200098000467, 0.00240969937294722, 0.00239756400696933, 0.00238492991775274, 0.00237246230244637, 0.00235949549823999, 0.00234669540077448, 0.0023334794677794, 0.00232018041424453, 0.0023067151196301, 0.00229316670447588, 0.0022796185221523, 0.00226565450429916, 0.00225169048644602, 0.00223747710697353, 0.00222326372750103, 0.00220880098640919, 0.00219408888369799, 0.00217921077273786, 0.00216424930840731, 0.0021492880769074, 0.00213407725095749, 0.00211346382275224, 0.00209176982752979, 0.00206932774744928, 0.0020475503988564, 0.00202535768039525, 0.00200349744409323, 0.00198155408725142, 0.00195952737703919, 0.00193758413661271, 0.00191589014139026, 0.00189378054346889, 0.00187208643183112, 0.00185014307498932, 0.00182819983456284, 0.00180609023664147, 0.00178456236608326, 0.00176253588870168, 0.00174092489760369, 0.0017188984202221, 0.00169720430858433, 0.00167526106815785, 0.00165365007705986, 0.00163203908596188, 0.0016100958455354, 0.00158848485443741, 0.00156662461813539, 0.00154517986811697, 0.00152323662769049, 0.00150179187767208, 0.00147968216333538, 0.0014581544091925, 0.00143646041397005, 0.00141493265982717, 0.00139307242352515, 0.00137187703512609, 0.0013498505577445, 0.00132848904468119, 0.00130671192891896, 0.00128526729531586, 0.00126349006313831, 0.00124187907204032, 0.00122035143431276, 0.00119890668429434, 0.00117746193427593, 0.00115593418013304, 0.00113448954652995, 0.00111296179238707, 0.00109126779716462, 0.00106990616768599, 0.00104846153408289, 0.00102709990460426, 0.00100548902992159, 0.000984293757937849, 0.000963015307206661, 0.00094148755306378, 0.000920209102332592, 0.000898847647476941, 0.000877569196745753, 0.000855791964568198, 0.000834596634376794, 0.000813318183645606, 0.000792122911661863, 0.000770678278058767, 0.000749482947867364, 0.000728038256056607, 0.000706842925865203, 0.000685398292262107, 0.000664369144942611, 0.0006430076318793, 0.000621978600975126, 0.000600700150243938, 0.000588818336836994, 0.000571861979551613, 0.000555071805138141, 0.000538447930011898, 0.00052248896099627, 0.000506363750901073, 0.000491069746203721, 0.00047560952953063, 0.000460315553937107, 0.000445021578343585, 0.000430558749940246, 0.000415929709561169, 0.000402131874579936, 0.000388334039598703, 0.000374037481378764, 0.000360738369636238, 0.000347439257893711, 0.0003348050522618, 0.000322004634654149, 0.000309702969389036, 0.000297068821964785, 0.000285265850834548, 0.000273130397545174, 0.000261992361629382, 0.000250688113737851, 0.000239716333453543, 0.00022891080880072, 0.00021827151067555, 0.000207798453629948, 0.000197824105271138, 0.000188016027095728, 0.000178540387423709, 0.000169064791407436, 0.000160087874974124, 0.000151110958540812, 0.000142632765346207, 0.000134154601255432, 0.000126341357827187, 0.000118361902423203, 0.000110881148430053, 0.000103067912277766, 9.62521226028912e-05, 8.92700918484479e-05, 8.26205359771848e-05, 7.66359371482395e-05, 7.03188561601564e-05, 6.41680162516423e-05, 5.85159032198135e-05, 5.3196261433186e-05, 4.78766196465585e-05, 4.32219385402277e-05, 3.8401016354328e-05, 3.39125654136296e-05, 2.97566002700478e-05, 2.57668743870454e-05, 2.21096270252019e-05, 1.87848545465386e-05, 1.5460085705854e-05, 1.26340319184237e-05, 9.64174250839278e-06, 7.14816405888996e-06, 4.82083123642951e-06, 2.99221301247599e-06, 1.32983586809132e-06, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.39385772147216e-05, 2.97569840768119e-05, 3.5824745282298e-05, 4.21418735641055e-05, 4.8375874030171e-05, 5.51917255506851e-05, 6.19244456174783e-05, 6.84909318806604e-05, 7.58055030019023e-05, 8.32863079267554e-05, 9.10164671950042e-05, 9.89960026345216e-05, 0.000107058644061908, 0.000114955044409726, 0.000123516409075819, 0.000132327128085308, 0.00014147034380585, 0.000150696680066176, 0.000160255469381809, 0.000169481805642135, 0.000179373106220737, 0.000189596859854646, 0.00019990376313217, 0.000210459998925216, 0.000221265610889532, 0.000232154343393631, 0.0002431261818856, 0.000254513637628406, 0.000266316696070135, 0.000278202845947817, 0.000290255266008899, 0.000302473898045719, 0.000314858800265938, 0.000327576155541465, 0.000340625992976129, 0.000353925221133977, 0.000367473781807348, 0.000380939251044765, 0.000394570961361751, 0.000408535124734044, 0.000422914861701429, 0.000437377777416259, 0.00045242250780575, 0.000467384088551626, 0.000482511968584731, 0.000497806060593575, 0.000513183244038373, 0.000529142329469323, 0.000545267597772181, 0.000561559165362269, 0.000577850674744695, 0.000594807148445398, 0.000611597439274192, 0.000628553912974894, 0.000646258529741317, 0.000663713726680726, 0.000681667646858841, 0.000699621567036957, 0.00071790796937421, 0.000736277550458908, 0.000755228917114437, 0.000773930980358273, 0.000793214770965278, 0.000812664802651852, 0.000832281191833317, 0.000851897522807121, 0.000871929456479847, 0.00089229381410405, 0.000912658288143575, 0.000933355186134577, 0.000954384566284716, 0.000980394310317934, 0.00100516376551241, 0.0010294346138835, 0.00105412106495351, 0.00107830879278481, 0.00110274588223547, 0.00112701673060656, 0.00115120445843786, 0.00117555842734873, 0.00119982927571982, 0.00122385087888688, 0.00124795536976308, 0.0012721432140097, 0.00129616470076144, 0.00132026930805296, 0.00134454015642405, 0.00136814604047686, 0.00139216752722859, 0.00141610589344054, 0.00143996113911271, 0.00146389950532466, 0.00148758862633258, 0.00151119451038539, 0.00153513299301267, 0.00155857263598591, 0.00158226152416319, 0.00160620012320578, 0.00162947364151478, 0.00165324576664716, 0.00167651905212551, 0.00170020817313343, 0.00172356457915157, 0.00174683809746057, 0.00177052721846849, 0.00179380050394684, 0.00181724026333541, 0.00184018129948527, 0.00186345470137894, 0.00188664498273283, 0.00190991850104183, 0.00193327502347529, 0.00195604981854558, 0.00197932333685458, 0.00200243038125336, 0.00202512205578387, 0.00204839557409286, 0.00207108748145401, 0.00209377892315388, 0.00211696932092309, 0.00213949475437403, 0.00216226931661367, 0.00218529347330332, 0.00220790202729404, 0.00223075971007347, 0.00225328514352441, 0.00227581057697535, 0.00229841913096607, 0.00232086167670786, 0.00234355288557708, 0.00236591207794845, 0.0023886039853096, 0.00241063046269119, 0.00243315589614213, 0.00245543220080435, 0.00247779116034508, 0.00250023370608687, 0.00252209394238889, 0.00254461937583983, 0.00256664608605206, 0.00258850655518472, 0.00261094910092652, 0.00263264309614897, 0.0026228993665427, 0.00263752834871411, 0.00265215709805489, 0.00266612111590803, 0.00268075009807944, 0.00269454787485301, 0.00270834565162659, 0.00272214319556952, 0.00273544224910438, 0.00274874153546989, 0.0027615416329354, 0.0027746744453907, 0.00278714229352772, 0.00280010863207281, 0.00281174527481198, 0.00282404688186944, 0.00283584999851882, 0.00284781912341714, 0.00285912305116653, 0.0028705932199955, 0.00288189761340618, 0.0028930357657373, 0.00290350872091949, 0.00291448016650975, 0.00292495358735323, 0.00293476157821715, 0.00294523453339934, 0.00295487628318369, 0.00296485028229654, 0.00297399354167283, 0.00298346905037761, 0.00299244583584368, 0.00300142262130976, 0.00301023316569626, 0.00301887770183384, 0.00302735599689186, 0.00303533533588052, 0.00304348091594875, 0.00305146048776805, 0.00305894087068737, 0.0030662554781884, 0.00307373586110771, 0.00308055197820067, 0.0030878665857017, 0.00309418328106403, 0.00310116563923657, 0.00310715031810105, 0.00311330053955317, 0.00311945145949721, 0.00312510342337191, 0.00313042313791811, 0.00313624157570302, 0.00314156105741858, 0.00314638204872608, 0.00315136928111315, 0.00315585732460022, 0.00316067831590772, 0.00316450209356844, 0.00316882436163723, 0.00317264744080603, 0.00317663769237697, 0.00317996204830706, 0.00318328686989844, 0.00318677816540003, 0.00318943755701184, 0.00319209764711559, 0.00319492351263762, 0.00319741712883115, 0.00319974427111447, 0.00320207164622843, 0.00320373382419348, 0.00319619104266167, 0.00319513119757175, 0.00319440383464098, 0.00319319870322943, 0.00319220148958266, 0.00319078820757568, 0.00318981171585619, 0.00318814930506051, 0.00318700633943081, 0.00318553089164197, 0.00318424263969064, 0.00318260118365288, 0.00318083493039012, 0.00317923491820693, 0.00317715690471232, 0.00317557761445642, 0.0031734996009618, 0.00317162950523198, 0.0031692604534328, 0.00316739035770297, 0.00316489674150944, 0.00316273584030569, 0.00316022126935422, 0.00315808062441647, 0.00315544195473194, 0.00315282377414405, 0.00315039255656302, 0.00314762885682285, 0.00314486515708268, 0.00314178969711065, 0.00313906744122505, 0.00313601340167224, 0.0031329789198935, 0.00312979985028505, 0.00312676606699824, 0.00312310876324773, 0.00311995018273592, 0.00311648030765355, 0.00311317620798945, 0.0031093736179173, 0.00310592399910092, 0.00310253677889705, 0.00309842242859304, 0.00309488968923688, 0.00309081701561809, 0.00308709754608572, 0.00308271311223507, 0.00307886861264706, 0.00307452585548162, 0.00307034887373447, 0.0030658608302474, 0.00306170503608882, 0.00305707077495754, 0.00305262417532504, 0.00304784462787211, 0.00304341851733625, 0.00303882639855146, 0.00303373509086668, 0.00302918418310583, 0.0030241347849369, 0.00301908561959863, 0.00301391142420471, 0.00300888274796307, 0.00300354207865894, 0.00299838907085359, 0.00299290311522782, 0.0029876041226089, 0.00298182759433985, 0.00297636236064136, 0.00297058559954166, 0.00296501675620675, 0.00295942695811391, 0.00297000375576317, 0.0029701073653996, 0.00296994158998132, 0.00296969199553132, 0.00296962982974946, 0.00296931806951761, 0.00296894367784262, 0.00296865310519934, 0.00296823773533106, 0.00296767661347985, 0.00296738534234464, 0.00296686589717865, 0.00296626333147287, 0.0029656607657671, 0.00296497531235218, 0.00296416459605098, 0.00296354130841792, 0.00296256458386779, 0.00296171265654266, 0.0029608397744596, 0.00295990472659469, 0.00295907375402749, 0.00295793078839779, 0.00295678782276809, 0.00295566557906568, 0.0029544394928962, 0.00295327580533922, 0.00295200827531517, 0.00295059545896947, 0.00294920359738171, 0.00294789392501116, 0.00294639798812568, 0.00294479774311185, 0.00294342660345137, 0.0029416810721159, 0.00294001842848957, 0.00293835625052452, 0.00293661095201969, 0.00293490686453879, 0.00293303653597832, 0.00293110427446663, 0.00292908842675388, 0.00292730145156384, 0.00292526511475444, 0.00292322877794504, 0.00292110908776522, 0.00291882338933647, 0.00291664176620543, 0.00291443872265518, 0.00291211158037186, 0.00290986709296703, 0.00290739466436207, 0.00290494225919247, 0.00290249031968415, 0.00289993453770876, 0.00289733707904816, 0.00289476034231484, 0.00289201736450195, 0.00288929557427764, 0.00288665643893182, 0.00288368458859622, 0.00288100400939584, 0.00287807430140674, 0.00287499884143472, 0.00287200650200248, 0.00286903511732817, 0.002865876769647, 0.0028628425206989, 0.00285964272916317, 0.00285638007335365, 0.00285297259688377, 0.00283343950286508, 0.00282778753899038, 0.00282213534228504, 0.00281631690450013, 0.00281033245846629, 0.0028040986508131, 0.00279819709248841, 0.00279188016429543, 0.00278539676219225, 0.00277883023954928, 0.00277209794148803, 0.00276519893668592, 0.00275846617296338, 0.00275140115991235, 0.00274425279349089, 0.00273668905720115, 0.00272920844145119, 0.00272189406678081, 0.00271408073604107, 0.00270635052584112, 0.0026983714196831, 0.00269014248624444, 0.00268183066509664, 0.00267368485219777, 0.0026652067899704, 0.00265656248666346, 0.00264775194227695, 0.00263877515681088, 0.00262971501797438, 0.00262090424075723, 0.00261167832650244, 0.00260228593833745, 0.00259272730909288, 0.00258316844701767, 0.00257336045615375, 0.00256346934475005, 0.00255341199226677, 0.00254327151924372, 0.00253296480514109, 0.00252265785820782, 0.00251218490302563, 0.00250146258622408, 0.00249074026942253, 0.00247985171154141, 0.00246871379204094, 0.00245765899308026, 0.00244627171196043, 0.00243488443084061, 0.002423414029181, 0.00241177738644183, 0.0023998913820833, 0.00238800537772477, 0.00237586977891624, 0.002363734645769, 0.00235134991817176, 0.00233896519057453, 0.00232633133418858, 0.00231361389160156, 0.00230081379413605, 0.0022879303433001, 0.00227471441030502, 0.00226174760609865, 0.00224819942377508, 0.00223481724970043, 0.00222110259346664, 0.0022073881700635, 0.00219367328099906, 0.00217970949597657, 0.00216549634933472, 0.00215119961649179, 0.00213682022877038, 0.00211196765303612, 0.0020920189563185, 0.00207215361297131, 0.00205212202854455, 0.00203225668519735, 0.00201230798847973, 0.00199260888621211, 0.001972327940166, 0.00195229623932391, 0.00193234765902162, 0.00191239907871932, 0.00189253373537213, 0.0018727513961494, 0.00185263657476753, 0.00183277123142034, 0.00181282276753336, 0.00179287430364639, 0.00177292560692877, 0.00175281090196222, 0.00173286232165992, 0.00171291385777295, 0.00169296527747065, 0.00167301681358367, 0.00165323459077626, 0.00163328601047397, 0.00161333743017167, 0.00159338884986937, 0.00157344026956707, 0.00155365793034434, 0.00153337710071355, 0.00151342852041125, 0.00149347994010895, 0.0014735315926373, 0.00145374925341457, 0.00143380067311227, 0.00141385209280998, 0.00139390351250768, 0.0013739550486207, 0.00135400658473372, 0.001334224245511, 0.00131427578162402, 0.00129399460274726, 0.00127404613886029, 0.00125409767497331, 0.00123414909467101, 0.0012143668718636, 0.00119441829156131, 0.00117446971125901, 0.00115452124737203, 0.00113457266706973, 0.00111462420318276, 0.00109484186396003, 0.00107456091791391, 0.00105461233761162, 0.00103466387372464, 0.00101471529342234, 0.000994932954199612, 0.000974984432104975, 0.000955035910010338, 0.000935087387915701, 0.000915138865821064, 0.000895356584805995, 0.000875408004503697, 0.000855127000249922, 0.000835178536362946, 0.000815229956060648, 0.00079544767504558, 0.000775499094743282, 0.000755550572648644, 0.000735602050554007, 0.000715653586667031, 0.000695705006364733, 0.000705679296515882, 0.000691050372552127, 0.000675756484270096, 0.00066112756030634, 0.000646831118501723, 0.000632867158856243, 0.000618903199210763, 0.000604606699198484, 0.000590975221712142, 0.0005773437442258, 0.000564044690690935, 0.000550413213204592, 0.000537114159669727, 0.000523815164342523, 0.000510516169015318, 0.000497882079798728, 0.000485247990582138, 0.000472613959573209, 0.000460312323411927, 0.000448010745458305, 0.00043604162055999, 0.000424072495661676, 0.000412103399867192, 0.000400799239287153, 0.000389162567444146, 0.000377525924704969, 0.000365889311069623, 0.000354585121385753, 0.000343613442964852, 0.000332974217599258, 0.000322002539178357, 0.0003116957959719, 0.000301056599710137, 0.000291082309558988, 0.000280775566352531, 0.000270801334409043, 0.000260494562098756, 0.000250852783210576, 0.000240878522163257, 0.000231569181778468, 0.000222259885049425, 0.000213283055927604, 0.000203973715542816, 0.000195329354028217, 0.000186352524906397, 0.000178040630999021, 0.000169396284036338, 0.00016075192252174, 0.000152440028614365, 0.000144793084473349, 0.000136481205117889, 0.000128501778817736, 0.000120854849228635, 0.000113540394522715, 0.00010622592526488, 9.891147055896e-05, 9.19294761843048e-05, 8.49474890856072e-05, 7.79655092628673e-05, 7.09835221641697e-05, 6.466649210779e-05, 5.83494511374738e-05, 5.16999425599352e-05, 4.57153837487567e-05, 3.97308212995995e-05, 3.37462661263999e-05, 2.84266570815817e-05, 2.27745731535833e-05, 1.74549659277545e-05, 1.18028810902615e-05, 6.81574783811811e-06, 6.98198573445552e-06, 4.48841956313117e-06, 2.16109083339688e-06, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 1.99485316443315e-06, 4.48841956313117e-06, 6.98198573445552e-06, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15, 2.84915223094332e-15   }, 
   { 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.01524792626151e-05, 4.15969625464641e-05, 7.40989999030717e-05, 0.000107306070276536, 0.000141429685754701, 0.000176328831003048, 0.000212215018109418, 0.000248876749537885, 0.000286419788608328, 0.000324808817822486, 0.000364114443073049, 0.000404195568989962, 0.000445228506578133, 0.000487072247778997, 0.000529797282069921, 0.000573368277400732, 0.000617785495705903, 0.000663119019009173, 0.000709263433236629, 0.000756324443500489, 0.000804196228273213, 0.00085298455087468, 0.000902548374142498, 0.000952993577811867, 0.001004355144687, 0.00105659815017134, 0.00110961659811437, 0.00116351642645895, 0.00121829751878977, 0.00127403042279184, 0.00133050361182541, 0.0013878580648452, 0.00144605850800872, 0.001505246036686, 0.00156517385039479, 0.00162598304450512, 0.00168760295491666, 0.00175017467699945, 0.00181362766306847, 0.00187785620801151, 0.00194293074309826, 0.00200895708985627, 0.00207579415291548, 0.00214351247996092, 0.00221207737922668, 0.00228148768655956, 0.00235181488096714, 0.00242302310653031, 0.00249500689096749, 0.00256780162453651, 0.00264161895029247, 0.00271624629385769, 0.00279172044247389, 0.00286796968430281, 0.00294517073780298, 0.00302328844554722, 0.00310221710242331, 0.00318188592791557, 0.00326254148967564, 0.00334411393851042, 0.00342646148055792, 0.00350965559482574, 0.00359373074024916, 0.00367861683480442, 0.0037645255215466, 0.00385117391124368, 0.00393873918801546, 0.00402700901031494, 0.0041162665002048, 0.00420644041150808, 0.00429745996370912, 0.0043892553076148, 0.00451178988441825, 0.00463495962321758, 0.00475809350609779, 0.00488115707412362, 0.00500425603240728, 0.00512735452502966, 0.00525045348331332, 0.00537355244159698, 0.00549665046855807, 0.00561974989250302, 0.00574291869997978, 0.00586601812392473, 0.00598908169195056, 0.00611221510916948, 0.00623531453311443, 0.00635848334059119, 0.00648151198402047, 0.00660468125715852, 0.00672774482518435, 0.00685094902291894, 0.00697397720068693, 0.00709714693948627, 0.00722021050751209, 0.00734341517090797, 0.00746647920459509, 0.00758961262181401, 0.007712640799582, 0.00783584546297789, 0.00795894395560026, 0.00808207876980305, 0.00820517726242542, 0.00832831114530563, 0.00845137424767017, 0.00857454445213079, 0.0086975721642375, 0.00882074236869812, 0.00894380547106266, 0.00906690396368504, 0.00919003784656525, 0.0093131372705102, 0.00943627115339041, 0.00955937057733536, 0.0096824336796999, 0.00980560295283794, 0.00992870237678289, 0.0100518008694053, 0.0101748993620276, 0.0102979987859726, 0.0104211671277881, 0.010544266551733, 0.0106673650443554, 0.0107904290780425, 0.0109135629609227, 0.0110367313027382, 0.0111598307266831, 0.0112829292193055, 0.0114059932529926, 0.0115291988477111, 0.0116522954776883, 0.0117753958329558, 0.0118984952569008, 0.0120215583592653, 0.0121446559205651, 0.0122677553445101, 0.0123908892273903, 0.0125139523297548, 0.0126370871439576, 0.0127602219581604, 0.0128833195194602, 0.0130064198747277, 0.0131295882165432, 0.013237539678812, 0.0133290179073811, 0.0134195797145367, 0.0135094011202455, 0.0135982343927026, 0.0136862928047776, 0.0137734711170197, 0.0138598009943962, 0.0139451809227467, 0.0140297841280699, 0.0141135435551405, 0.01419638376683, 0.0142783783376217, 0.0143595281988382, 0.0144397616386414, 0.0145191475749016, 0.0145976878702641, 0.0146753825247288, 0.0147521598264575, 0.0148281622678041, 0.0149031784385443, 0.0149774886667728, 0.0150508116930723, 0.0151233589276671, 0.0151949916034937, 0.0152658466249704, 0.0153357153758407, 0.0154048083350062, 0.015472985804081, 0.0155403157696128, 0.0156068000942469, 0.0156724378466606, 0.0157371610403061, 0.0158010721206665, 0.0158641003072262, 0.0159263201057911, 0.0159875880926847, 0.0160480793565512, 0.016107689589262, 0.0161664187908173, 0.0162242669612169, 0.0162813030183315, 0.01633738912642, 0.0163927339017391, 0.016447126865387, 0.0165007095783949, 0.0165533758699894, 0.0166051965206861, 0.0166560634970665, 0.0167061928659678, 0.0167554020881653, 0.0168038737028837, 0.0168513935059309, 0.0168980322778225, 0.0169437862932682, 0.0169887319207191, 0.0170327983796597, 0.0170760862529278, 0.017118388786912, 0.0171599145978689, 0.0172005258500576, 0.0172402877360582, 0.0172791704535484, 0.0173172429203987, 0.0173543617129326, 0.0173907075077295, 0.0174261704087257, 0.0174607876688242, 0.0174944885075092, 0.0175273772329092, 0.0175593867897987, 0.0175875704735518, 0.0176027286797762, 0.0176174305379391, 0.0176317058503628, 0.0176455602049828, 0.0176590252667665, 0.0176719985902309, 0.0176845137029886, 0.017696674913168, 0.0177082717418671, 0.0177195891737938, 0.0177304446697235, 0.017740810289979, 0.0177507866173983, 0.0177603401243687, 0.0177694708108902, 0.0177781414240599, 0.017786355689168, 0.0177942160516977, 0.0178016182035208, 0.0178085621446371, 0.0178151205182076, 0.0178211834281683, 0.0178268235176802, 0.0178320072591305, 0.0178368352353573, 0.0178412068635225, 0.0178451184183359, 0.0178486444056034, 0.0178517457097769, 0.0178543906658888, 0.0178565755486488, 0.0178584083914757, 0.017859747633338, 0.0178606994450092, 0.0178611949086189, 0.0178612638264894, 0.0178608763962984, 0.0178600307554007, 0.0178587958216667, 0.0178571399301291, 0.0178550239652395, 0.017852520570159, 0.0178495962172747, 0.0178461764007807, 0.0178424064069986, 0.0178381390869617, 0.0178334508091211, 0.0178283397108316, 0.0178228411823511, 0.017816849052906, 0.0178104303777218, 0.0178036279976368, 0.0177964009344578, 0.0177886802703142, 0.0177806094288826, 0.0177720077335835, 0.0177629832178354, 0.0177535358816385, 0.0177437346428633, 0.0177334435284138, 0.0177226569503546, 0.0177115872502327, 0.0177000239491463, 0.017688037827611, 0.0176755599677563, 0.0176627282053232, 0.0176494736224413, 0.0176357254385948, 0.0176215544342995, 0.0176069606095552, 0.017591942101717, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175870060920715, 0.0175908468663692, 0.0176033955067396, 0.0176156293600798, 0.0176274720579386, 0.0176389310508966, 0.017650069668889, 0.0176608227193356, 0.0176712907850742, 0.0176813378930092, 0.0176910310983658, 0.0177003387361765, 0.0177093613892794, 0.0177179649472237, 0.0177262481302023, 0.0177341103553772, 0.0177416168153286, 0.0177488438785076, 0.0177556481212378, 0.0177620984613895, 0.0177681986242533, 0.0177739784121513, 0.0177793372422457, 0.0177844148129225, 0.0177890304476023, 0.017793333157897, 0.0177973173558712, 0.0178008768707514, 0.017804155126214, 0.0178069733083248, 0.0178095120936632, 0.0178116634488106, 0.0178134962916374, 0.0178149063140154, 0.0178159642964602, 0.0178167037665844, 0.0178170576691628, 0.0178170911967754, 0.0178166683763266, 0.017815999686718, 0.0178149063140154, 0.0178134962916374, 0.0178116988390684, 0.0178094767034054, 0.0178070105612278, 0.017804117873311, 0.0178009103983641, 0.0177973173558712, 0.0177933666855097, 0.0177890677005053, 0.0177844148129225, 0.0177793726325035, 0.0177740156650543, 0.0177682340145111, 0.0177620984613895, 0.0177556835114956, 0.0177488438785076, 0.0177416540682316, 0.0177341103553772, 0.0177262481302023, 0.0177179649472237, 0.0177093986421824, 0.0177003722637892, 0.0176910310983658, 0.0176813378930092, 0.0176712907850742, 0.0176608916372061, 0.0176501050591469, 0.0176390018314123, 0.0176274720579386, 0.0176156628876925, 0.0176034662872553, 0.0175908468663692, 0.0175695158541203, 0.0175470262765884, 0.0175238288938999, 0.0174996480345726, 0.0174747593700886, 0.0174488853663206, 0.0174221638590097, 0.0173947382718325, 0.0173663962632418, 0.0173373483121395, 0.0173073131591082, 0.0172765050083399, 0.0172447767108679, 0.017212275415659, 0.0171788576990366, 0.0171448029577732, 0.0171098336577415, 0.0170739479362965, 0.0170372854918242, 0.0169995669275522, 0.0169613528996706, 0.0169220138341188, 0.0168819669634104, 0.0168411452323198, 0.0167995467782021, 0.0167568940669298, 0.0167134627699852, 0.016669187694788, 0.0166240651160479, 0.0165783073753119, 0.016531566157937, 0.0164839755743742, 0.0164356101304293, 0.0163861867040396, 0.0163360591977835, 0.0162852257490158, 0.0162333361804485, 0.0161809511482716, 0.0161274392157793, 0.0160730816423893, 0.0160178765654564, 0.0159619674086571, 0.0159050710499287, 0.0158475413918495, 0.0157890226691961, 0.0157297998666763, 0.0156695898622274, 0.0156084643676877, 0.0155467735603452, 0.0154840964823961, 0.0154205728322268, 0.0153562733903527, 0.0152910575270653, 0.0152250677347183, 0.0151580888777971, 0.0150904757902026, 0.0150219462811947, 0.0149524295702577, 0.0148824201896787, 0.0148113537579775, 0.0147396512329578, 0.014666679315269, 0.0145930740982294, 0.0145188337191939, 0.0144435372203588, 0.0143675338476896, 0.014290614053607, 0.0142128495499492, 0.0141341676935554, 0.0140547808259726, 0.0139744784682989, 0.0138817401602864, 0.0137662561610341, 0.013650631532073, 0.0135349342599511, 0.0134187452495098, 0.01330297999084, 0.0131867909803987, 0.0130705302581191, 0.0129542695358396, 0.012837728485465, 0.0127213271334767, 0.0126043623313308, 0.0124875390902162, 0.0123705742880702, 0.0122536104172468, 0.0121364332735538, 0.0120191155001521, 0.0119017977267504, 0.0117839872837067, 0.0116663165390491, 0.0115486476570368, 0.0114307655021548, 0.0113126719370484, 0.0111945094540715, 0.0110762743279338, 0.0109578296542168, 0.010839244350791, 0.0107207279652357, 0.0106019992381334, 0.010483130812645, 0.0103641217574477, 0.0102450409904122, 0.0101257506757975, 0.0100063178688288, 0.00988695584237576, 0.0097673824056983, 0.00964752584695816, 0.00952788256108761, 0.00940795708447695, 0.00928781926631927, 0.00916753988713026, 0.00904719159007072, 0.00892691314220428, 0.00880628172308207, 0.00868572108447552, 0.00856494903564453, 0.0084440354257822, 0.00832291040569544, 0.00820178631693125, 0.00808066222816706, 0.00795911438763142, 0.00783777888864279, 0.00771608948707581, 0.00759425992146134, 0.00747242989018559, 0.00735031813383102, 0.00722841825336218, 0.00710623618215322, 0.00698370113968849, 0.00686144875362515, 0.00673863245174289, 0.0066159563139081, 0.00649321032688022, 0.00637025199830532, 0.00624729413539171, 0.0061239842325449, 0.00600081495940685, 0.0058772936463356, 0.00575377140194178, 0.00563010899350047, 0.00550630548968911, 0.00538257183507085, 0.00526855885982513, 0.00515504833310843, 0.00504294782876968, 0.00493197655305266, 0.00482248514890671, 0.00471433345228434, 0.00460737990215421, 0.0045016254298389, 0.00439735129475594, 0.00429441640153527, 0.00419275090098381, 0.00409207260236144, 0.00399322714656591, 0.00389550975523889, 0.00379892042838037, 0.0037039527669549, 0.00361018348485231, 0.00351775414310396, 0.00342652294784784, 0.00333677232265472, 0.00324822054244578, 0.00316079659387469, 0.00307506462559104, 0.00299046118743718, 0.00290712667629123, 0.00282534305006266, 0.00274475757032633, 0.00266537093557417, 0.0025874653365463, 0.00251075765118003, 0.00243560131639242, 0.00236136163584888, 0.00228846142999828, 0.00221711210906506, 0.00214703194797039, 0.00207857345230877, 0.0020109610632062, 0.00194468803238124, 0.00188003666698933, 0.00181658379733562, 0.00175432953983545, 0.00169341487344354, 0.00163405120838434, 0.00157581560779363, 0.00151842611376196, 0.00146315165329725, 0.00140879361424595, 0.00135584583040327, 0.00130430795252323, 0.00125382782425731, 0.0012049691285938, 0.00115702697075903, 0.00111091788858175, 0.00106579589191824, 0.00102173152845353, 0.000979500124230981, 0.000938255805522203, 0.00089849199866876, 0.000860067782923579, 0.000823053647764027, 0.000787097029387951, 0.000752479943912476, 0.000719343486707658, 0.000687476131133735, 0.000656595744658262, 0.000627477944362909, 0.000599347171373665, 0.00057283800560981, 0.000547668372746557, 0.000523626746144146, 0.000500854279380292, 0.000498104665894061, 0.000521088717505336, 0.000544918759260327, 0.000570229371078312, 0.000597091042436659, 0.000624939857516438, 0.000653916562441736, 0.000684444443322718, 0.000716664420906454, 0.000749589351471514, 0.000784276868216693, 0.000820233544800431, 0.000857388600707054, 0.00089574238518253, 0.000935717660468072, 0.000976820942014456, 0.00101919332519174, 0.00106283475179225, 0.00110795674845576, 0.00115441833622754, 0.00120186689309776, 0.00125128962099552, 0.00130155845545232, 0.00135309621691704, 0.00140611443202943, 0.00146047247108072, 0.0015159584581852, 0.00157278403639793, 0.00163116061594337, 0.00169052428100258, 0.00175150949507952, 0.00181383418384939, 0.0018772870535031, 0.00194193841889501, 0.00200828188098967, 0.00207582395523787, 0.00214449386112392, 0.00221457425504923, 0.00228578224778175, 0.0023585413582623, 0.0024325696285814, 0.00250800792127848, 0.00258464482612908, 0.00266269198618829, 0.00274207862094045, 0.00282266363501549, 0.00290458812378347, 0.00298778200522065, 0.00307252677157521, 0.00315825850702822, 0.00324525940231979, 0.00333395251072943, 0.00342370290309191, 0.00351493409834802, 0.00360736344009638, 0.00370127381756902, 0.00379631179384887, 0.00389276025816798, 0.00399061851203442, 0.00408946396782994, 0.00418986054137349, 0.00429152604192495, 0.00439460156485438, 0.00449873460456729, 0.0046044890768826, 0.00471144262701273, 0.00481973588466644, 0.00492929760366678, 0.00504040997475386, 0.00515272188931704, 0.00526594929397106, 0.00538454530760646, 0.00550856115296483, 0.00563236512243748, 0.0057559572160244, 0.00587947899475694, 0.0060029299929738, 0.00612631114199758, 0.00624933931976557, 0.00637243781238794, 0.00649553630501032, 0.00661814212799072, 0.00674095842987299, 0.00686335237696767, 0.00698602804914117, 0.00710835121572018, 0.00723046297207475, 0.00735250394791365, 0.00747461570426822, 0.00759644573554397, 0.00771813420578837, 0.00783996470272541, 0.00796137098222971, 0.00808263570070267, 0.00820397213101387, 0.00832516793161631, 0.00844600982964039, 0.00856706406921148, 0.00868804752826691, 0.00880860816687346, 0.00892909802496433, 0.00904923584312201, 0.00916979555040598, 0.00929000414907932, 0.00940993055701256, 0.00953006837517023, 0.00964985322207212, 0.00976949743926525, 0.00988921150565147, 0.0100087150931358, 0.0101278647780418, 0.010247016325593, 0.0103663774207234, 0.0104853175580502, 0.0106039745733142, 0.010722772218287, 0.0108417114242911, 0.0109600154682994, 0.0110783902928233, 0.0111965546384454, 0.0113149285316467, 0.0114328805357218, 0.0115508325397968, 0.0116687845438719, 0.0117863127961755, 0.0119038419798017, 0.0120213003829122, 0.0121386181563139, 0.0122558651492, 0.0123727591708302, 0.012489864602685, 0.0126066189259291, 0.0127233024686575, 0.012839843519032, 0.0129563855007291, 0.0130728576332331, 0.013188905082643, 0.0133050950244069, 0.0134212132543325, 0.0135369803756475, 0.0136526040732861, 0.0137685826048255, 0.0138839967548847, 0.0139650478959084, 0.0140303680673242, 0.0140953557565808, 0.0141599550843239, 0.0142240943387151, 0.0142878824844956, 0.0143511593341827, 0.0144139425829053, 0.0144765498116612, 0.0145387696102262, 0.0146005125716329, 0.014661761932075, 0.014722659252584, 0.0147832054644823, 0.0148431146517396, 0.014902813360095, 0.0149621590971947, 0.0150210298597813, 0.015079265460372, 0.0151374135166407, 0.0151950679719448, 0.015252404846251, 0.0153090720996261, 0.0153655260801315, 0.0154213830828667, 0.0154770109802485, 0.0155321443453431, 0.0155870653688908, 0.0156415123492479, 0.0156952887773514, 0.0157488882541656, 0.0158021189272404, 0.0158547144383192, 0.015907134860754, 0.0159593056887388, 0.0160107035189867, 0.0160616245120764, 0.0161126330494881, 0.0161629728972912, 0.0162126962095499, 0.016262348741293, 0.0163113828748465, 0.0163600295782089, 0.0164082180708647, 0.0164561793208122, 0.0165036637336016, 0.0165507942438126, 0.0165972728282213, 0.0166435595601797, 0.0166894923895597, 0.0167347732931376, 0.0167798604816198, 0.0168244540691376, 0.0168687123805285, 0.0169124417006969, 0.0169558543711901, 0.0169987380504608, 0.0170412864536047, 0.0170835182070732, 0.0171252209693193, 0.0171665716916323, 0.0172074288129807, 0.0172479841858149, 0.0172882787883282, 0.0173279363662004, 0.0173671171069145, 0.0174060892313719, 0.0174448657780886, 0.0174827091395855, 0.0175203401595354, 0.0175578817725182, 0.0175996944308281, 0.0176435131579638, 0.0176880527287722, 0.0177330337464809, 0.0177785269916058, 0.0178245473653078, 0.0178710781037807, 0.0179180167615414, 0.0179654825478792, 0.0180135667324066, 0.0180620029568672, 0.0181108452379704, 0.0181603729724884, 0.0182103775441647, 0.0182609092444181, 0.0183118842542171, 0.0183634385466576, 0.0184154342859983, 0.0184680316597223, 0.0185208562761545, 0.0185743682086468, 0.0186284091323614, 0.0186829958111048, 0.018738005310297, 0.0187934897840023, 0.0188495945185423, 0.0189062263816595, 0.0189630705863237, 0.0190205294638872, 0.0190786588937044, 0.0191373005509377, 0.0191962588578463, 0.0192558001726866, 0.0193159561604261, 0.0193764660507441, 0.019437450915575, 0.019498948007822, 0.0195609554648399, 0.0196235962212086, 0.0196867696940899, 0.0197502393275499, 0.0198143068701029, 0.0198789946734905, 0.0199440345168114, 0.0200095307081938, 0.0200755596160889, 0.020142238587141, 0.0202092677354813, 0.0202768798917532, 0.0203450229018927, 0.0204136557877064, 0.0204827487468719, 0.0205523353070021, 0.0206223987042904, 0.0206930264830589, 0.0207640752196312, 0.0208357255905867, 0.0209077782928944, 0.0209805201739073, 0.0210536140948534, 0.0211272183805704, 0.0212013367563486, 0.0212759114801884, 0.0213510692119598, 0.021426647901535, 0.0215028095990419, 0.0215795338153839, 0.0216566622257233, 0.021734269335866, 0.0218124408274889, 0.021891051903367, 0.0219701565802097, 0.0220905374735594, 0.0222138464450836, 0.0223368033766747, 0.0224600434303284, 0.0225832127034664, 0.0227064527571201, 0.0228291284292936, 0.0229524374008179, 0.0230756048113108, 0.0231985654681921, 0.023321732878685, 0.0234449729323387, 0.0235682129859924, 0.023691238835454, 0.0238144788891077, 0.0239372961223125, 0.0240606069564819, 0.0241835620254278, 0.0243068020790815, 0.0244299694895744, 0.0245527867227793, 0.0246760975569487, 0.0247993376106024, 0.0249223634600639, 0.0250451806932688, 0.0251684915274382, 0.0252917315810919, 0.0254146885126829, 0.0255379285663366, 0.0256610251963139, 0.0257842671126127, 0.0259072221815586, 0.0260303225368261, 0.0261532794684172, 0.0262766592204571, 0.0263996161520481, 0.0265228562057018, 0.026645814999938, 0.0267691947519779, 0.026892151683569, 0.0270153917372227, 0.0271382089704275, 0.0272614490240812, 0.0273845456540585, 0.0275077857077122, 0.0276307426393032, 0.0277539826929569, 0.0278772208839655, 0.0280003193765879, 0.0281231384724379, 0.0282463766634464, 0.0283693335950375, 0.0284925736486912, 0.0286156721413136, 0.0287389103323221, 0.0288618691265583, 0.028985109180212, 0.0291080661118031, 0.0292313043028116, 0.0293542630970478, 0.0294775031507015, 0.0296007413417101, 0.0297238398343325, 0.0298467967659235, 0.0299700368195772, 0.0300932768732309, 0.030216233804822, 0.0303391925990582, 0.0304624307900667, 0.0305856689810753, 0.0307086277753115, 0.0308121275156736, 0.0309040620923042, 0.0309948716312647, 0.031084269285202, 0.0311736650764942, 0.0312616527080536, 0.0313493609428406, 0.0314353741705418, 0.0315211080014706, 0.031605426222086, 0.0316894687712193, 0.0317726619541645, 0.0318547300994396, 0.031935665756464, 0.0320163182914257, 0.0320958495140076, 0.0321745313704014, 0.0322520807385445, 0.0323293544352055, 0.032405212521553, 0.0324805155396461, 0.0325546823441982, 0.0326285697519779, 0.0327007658779621, 0.032772958278656, 0.0328434631228447, 0.0329139642417431, 0.0329824946820736, 0.0330513082444668, 0.0331187061965466, 0.0331855453550816, 0.0332509689033031, 0.03331583365798, 0.0333798490464687, 0.0334433056414127, 0.0335053466260433, 0.0335668250918388, 0.0336274579167366, 0.0336872413754463, 0.0337459035217762, 0.0338039956986904, 0.0338612459599972, 0.0339173674583435, 0.0339726395905018, 0.0340273529291153, 0.0340809337794781, 0.0341339521110058, 0.0341855622828007, 0.0342368893325329, 0.0342870838940144, 0.0343364402651787, 0.0343849435448647, 0.0344323217868805, 0.0344794169068336, 0.0345253832638264, 0.0345705077052116, 0.0346144996583462, 0.0346579328179359, 0.0347005128860474, 0.0347419716417789, 0.0347825810313225, 0.0348226279020309, 0.0348618291318417, 0.0348998978734016, 0.0349368415772915, 0.0349735021591187, 0.0350090377032757, 0.0350440070033073, 0.0350775681436062, 0.0351105630397797, 0.0351427122950554, 0.0351740159094334, 0.0351926907896996, 0.035214688628912, 0.0352362655103207, 0.035257413983345, 0.0352772958576679, 0.0352967530488968, 0.0353160016238689, 0.0353339798748493, 0.0353517457842827, 0.0353686660528183, 0.0353851653635502, 0.0354006066918373, 0.0354158356785774, 0.0354304276406765, 0.0354441776871681, 0.0354570783674717, 0.0354695580899715, 0.0354816131293774, 0.0354926139116287, 0.035502977669239, 0.0355129167437553, 0.0355224385857582, 0.035530898720026, 0.0355387218296528, 0.0355459116399288, 0.0355528965592384, 0.035558607429266, 0.0355643145740032, 0.035568755120039, 0.035572562366724, 0.035576157271862, 0.035579327493906, 0.0355810225009918, 0.0355822890996933, 0.0355833508074284, 0.0355837754905224, 0.0355829261243343, 0.0355818681418896, 0.0355803892016411, 0.0355780608952045, 0.0355746783316135, 0.0355712957680225, 0.0355668514966965, 0.0355619862675667, 0.0355560667812824, 0.0355499312281609, 0.0355429500341415, 0.0355357639491558, 0.0355270877480507, 0.0355184189975262, 0.0355086885392666, 0.03549874573946, 0.0354879610240459, 0.0354765392839909, 0.0354642681777477, 0.0354517921805382, 0.0354382544755936, 0.0354242920875549, 0.0354094915091991, 0.035394262522459, 0.0353779755532742, 0.0353616885840893, 0.0353441312909126, 0.0353265777230263, 0.0353075377643108, 0.035288717597723, 0.0352686271071434, 0.0352485291659832, 0.0352269560098648, 0.0352053828537464, 0.0351827517151833, 0.0351607464253902, 0.0351448841392994, 0.0351288095116615, 0.0351119600236416, 0.0350948981940746, 0.0350774116814137, 0.0350593626499176, 0.0350408889353275, 0.0350222773849964, 0.0350029580295086, 0.0349831506609917, 0.0349630527198315, 0.0349424704909325, 0.0349213853478432, 0.0349000953137875, 0.0348782390356064, 0.0348558910191059, 0.0348331183195114, 0.0348101332783699, 0.0347865857183933, 0.0347625426948071, 0.0347380079329014, 0.0347131192684174, 0.0346877388656139, 0.0346622169017792, 0.0346360616385937, 0.0346093401312828, 0.0345825478434563, 0.0345550514757633, 0.0345269925892353, 0.0344986505806446, 0.0344698838889599, 0.0344408378005028, 0.034411083906889, 0.0343811921775341, 0.0343505926430225, 0.0343198515474796, 0.0342884100973606, 0.0342567525804043, 0.0342243909835815, 0.0341918878257275, 0.0341587513685226, 0.0341251939535141, 0.0340912826359272, 0.0340570881962776, 0.034022256731987, 0.0339870750904083, 0.0339513309299946, 0.0339153036475182, 0.0338787846267223, 0.0338419117033482, 0.0338045470416546, 0.033766683191061, 0.0337284691631794, 0.0336897633969784, 0.0336508452892303, 0.0336112231016159, 0.0335712470114231, 0.0335308499634266, 0.0334901697933674, 0.0334487855434418, 0.0334071852266788, 0.0333650261163712, 0.0333226546645164, 0.033279575407505, 0.0332362167537212, 0.0331922918558121, 0.0331482291221619, 0.0331033878028393, 0.0330583341419697, 0.0330126509070396, 0.0328255444765091, 0.0316382721066475, 0.030495697632432, 0.0293711721897125, 0.028282392770052, 0.0272206161171198, 0.0262125618755817, 0.0252224858850241, 0.0242592021822929, 0.0233319438993931, 0.0224313382059336, 0.0215577334165573, 0.0207469463348389, 0.0199451129883528, 0.0191700719296932, 0.0184309873729944, 0.017727579921484, 0.0170693621039391, 0.0164197441190481, 0.0158150400966406, 0.0152372671291232, 0.0146864261478186, 0.0141713293269277, 0.0137011436745524, 0.0132489372044802, 0.0128323324024677, 0.0124428737908602, 0.0120890885591507, 0.0117804268375039, 0.0114893894642591, 0.0112343784421682, 0.0110061597079039, 0.0108048738911748, 0.0106573812663555, 0.010518841445446, 0.0104160495102406, 0.0103583065792918, 0.0103182615712285, 0.0103051466867328, 0.0103549221530557, 0.0104136513546109, 0.0104991002008319, 0.0106294602155685, 0.0107777286320925, 0.0109617430716753, 0.0111999018117785, 0.0114467339590192, 0.0117204254493117, 0.0120479837059975, 0.0123845655471087, 0.0127838952466846, 0.0131921088322997, 0.0136271826922894, 0.0141072375699878, 0.0146140148863196, 0.0151477232575417, 0.0157262720167637, 0.0163318235427141, 0.0169640947133303, 0.017632395029068, 0.0183273442089558, 0.0190672744065523, 0.0198251139372587, 0.0206189081072807, 0.0214483048766851, 0.0223048478364944, 0.0232061613351107, 0.0241252388805151, 0.0250713210552931, 0.0260532163083553, 0.027080025523901, 0.0281245987862349, 0.0285261329263449, 0.0293293036520481, 0.0302768666297197, 0.0313056483864784, 0.0324517488479614, 0.0337332114577293, 0.0350778475403786, 0.0365578532218933, 0.0381100475788116, 0.0398066379129887, 0.0415934696793556, 0.0434976182878017, 0.045501034706831, 0.0475946925580502, 0.0498237200081348, 0.0521339699625969, 0.0545976273715496, 0.0571605563163757, 0.0597866624593735, 0.0625391006469727, 0.0653817877173424, 0.0683688670396805, 0.0714371651411057, 0.0746137574315071, 0.0779076591134071, 0.0812827795743942, 0.0847842544317245, 0.0884030386805534, 0.0921120643615723, 0.0959293842315674, 0.0998459756374359, 0.103925012052059, 0.108049161732197, 0.112326726317406, 0.116667456924915, 0.121125511825085, 0.125691875815392, 0.130339428782463, 0.135158464312553, 0.140031635761261, 0.145031169056892, 0.150129944086075, 0.155318960547447, 0.16065239906311, 0.166076064109802, 0.171617045998573, 0.177275344729424, 0.183023884892464, 0.188853651285172, 0.194818779826164, 0.200892195105553, 0.207055866718292, 0.213345885276794, 0.219717115163803, 0.226214662194252, 0.232811510562897, 0.239525675773621, 0.246330067515373, 0.253242760896683, 0.260281801223755, 0.26739302277565, 0.27466669678688, 0.282030612230301, 0.289466708898544, 0.297038167715073, 0.304699867963791, 0.312478959560394, 0.320357233285904, 0.328334808349609, 0.3364477455616, 0.344623863697052, 0.354054361581802, 0.365497261285782, 0.377048522233963, 0.388689965009689, 0.400448799133301, 0.412315875291824, 0.424327343702316, 0.436420083045959, 0.448593974113464, 0.46088519692421, 0.473302811384201, 0.485792547464371, 0.498435765504837, 0.511160135269165, 0.524001896381378, 0.536924839019775, 0.550001204013824, 0.563140749931335, 0.576406538486481, 0.589789807796478, 0.603263199329376, 0.616862952709198, 0.630589067935944, 0.644378423690796, 0.658275961875916, 0.672317922115326, 0.686450064182281, 0.700672626495361, 0.715030372142792, 0.729469478130341, 0.744016826152802, 0.758690476417542, 0.773454368114471, 0.788335621356964, 0.803325116634369, 0.818404912948608, 0.833647191524506, 0.848943471908569, 0.864393293857574, 0.879915237426758, 0.895527422428131, 0.911302089691162, 0.927103817462921, 0.943077027797699, 0.959167540073395, 0.975303173065186, 0.991601228713989, 1.00797152519226, 1.02445912361145, 1.04107296466827, 1.05775904655457, 1.07458961009979, 1.09152841567993, 1.10858452320099, 1.12571287155151, 1.14297652244568, 1.16033041477203, 1.17775654792786, 1.19533598423004, 1.21302390098572, 1.23078393936157, 1.2487154006958, 1.26668298244476, 1.28477704524994, 1.30302441120148, 1.32133483886719, 1.33977174758911, 1.35832583904266, 1.37697923183441, 1.39572298526764, 1.4145929813385, 1.43356227874756, 1.45585525035858, 1.47643089294434, 1.4970246553421, 1.51755511760712, 1.53809475898743, 1.55857110023499, 1.57906556129456, 1.59952390193939, 1.61993718147278, 1.64040458202362, 1.66076374053955, 1.68116784095764, 1.70153594017029, 1.72183203697205, 1.74217295646667, 1.76246893405914, 1.78276491165161, 1.80301558971405, 1.82329332828522, 1.84348094463348, 1.86369574069977, 1.88388335704803, 1.90400791168213, 1.92418646812439, 1.94428384304047, 1.96439921855927, 1.98447871208191, 2.00455784797668, 2.02457404136658, 2.04462647438049, 2.06460642814636, 2.08455944061279, 2.10454845428467, 2.12448334693909, 2.14440941810608, 2.16431713104248, 2.18420696258545, 2.20405173301697, 2.22389626502991, 2.24372315406799, 2.26351356506348, 2.28331327438354, 2.30305862426758, 2.32280397415161, 2.34252238273621, 2.36222267150879, 2.38192296028137, 2.40155982971191, 2.42122435569763, 2.44082522392273, 2.46045351028442, 2.4800271987915, 2.49961948394775, 2.51912117004395, 2.53863215446472, 2.55816078186035, 2.57761740684509, 2.59710121154785, 2.61654877662659, 2.63597846031189, 2.65537166595459, 2.67478322982788, 2.69410467147827, 2.71347093582153, 2.73280143737793, 2.75207757949829, 2.77138090133667, 2.79062986373901, 2.80987882614136, 2.82910108566284, 2.84828686714172, 2.8670756816864, 2.88427591323853, 2.9014585018158, 2.91842484474182, 2.93528199195862, 2.95199537277222, 2.96860027313232, 2.98498868942261, 3.00128674507141, 3.01745843887329, 3.03339552879333, 3.04927849769592, 3.06499886512756, 3.08059334754944, 3.09602499008179, 3.11138463020325, 3.12645554542542, 3.14148998260498, 3.15645265579224, 3.17112636566162, 3.18574571609497, 3.20020270347595, 3.21447944641113, 3.2286479473114, 3.24269008636475, 3.25660562515259, 3.27034068107605, 3.2839674949646, 3.29735970497131, 3.31069779396057, 3.32389140129089, 3.33688688278198, 3.34980940818787, 3.36258816719055, 3.37524056434631, 3.3876039981842, 3.40003943443298, 3.41216850280762, 3.42424297332764, 3.43617343902588, 3.44795942306519, 3.45949244499207, 3.4710259437561, 3.48236036300659, 3.49358701705933, 3.50466871261597, 3.51553416252136, 3.5263454914093, 3.53697609901428, 3.54746246337891, 3.55776834487915, 3.56800198554993, 3.57810950279236, 3.58805441856384, 3.59783673286438, 3.60749292373657, 3.61696839332581, 3.62633585929871, 3.63559508323669, 3.64469170570374, 3.65355348587036, 3.66239738464355, 3.67106103897095, 3.67957997322083, 3.6880087852478, 3.69616675376892, 3.70427060127258, 3.7122483253479, 3.72006368637085, 3.72768020629883, 3.73526072502136, 3.74266052246094, 3.74613738059998, 3.7504870891571, 3.75463843345642, 3.75877141952515, 3.76274251937866, 3.76656866073608, 3.77017831802368, 3.77373385429382, 3.77718114852905, 3.78044819831848, 3.78358864784241, 3.78656649589539, 3.78943634033203, 3.79217982292175, 3.79481506347656, 3.79717946052551, 3.79959797859192, 3.8018000125885, 3.80376720428467, 3.80577063560486, 3.80750322341919, 3.80912756919861, 3.81068015098572, 3.81208777427673, 3.81327891349792, 3.81441617012024, 3.81539058685303, 3.81618452072144, 3.81692481040955, 3.81746625900269, 3.81788158416748, 3.81818819046021, 3.81842279434204, 3.81836843490601, 3.81824231147766, 3.81802558898926, 3.81762862205505, 3.81714129447937, 3.81650972366333, 3.81566143035889, 3.81474089622498, 3.81373023986816, 3.81252098083496, 3.81114912033081, 3.80968713760376, 3.80809903144836, 3.80634808540344, 3.8045072555542, 3.80244946479797, 3.80031967163086, 3.79808187484741, 3.79566311836243, 3.7930281162262, 3.79039311408997, 3.78757739067078, 3.78463554382324, 3.78154897689819, 3.77828240394592, 3.77490711212158, 3.77144145965576, 3.76783204078674, 3.76400589942932, 3.76010704040527, 3.75608229637146, 3.75191307067871, 3.74759936332703, 3.74308729171753, 3.73853874206543, 3.73384594917297, 3.72900915145874, 3.72397351264954, 3.71783685684204, 3.71214246749878, 3.70642566680908, 3.70066785812378, 3.69482922554016, 3.6890172958374, 3.68312454223633, 3.67718625068665, 3.67123460769653, 3.66524696350098, 3.65922331809998, 3.65314507484436, 3.64704036712646, 3.64090800285339, 3.63471269607544, 3.62849926948547, 3.62221384048462, 3.61592388153076, 3.60961604118347, 3.60323548316956, 3.59682369232178, 3.59038019180298, 3.58387804031372, 3.57738971710205, 3.57081961631775, 3.56420469284058, 3.55761694908142, 3.55093002319336, 3.5442066192627, 3.5374653339386, 3.53068351745605, 3.52387022972107, 3.51701593399048, 3.510094165802, 3.50318622589111, 3.49622392654419, 3.48921155929565, 3.4821457862854, 3.47505688667297, 3.46798157691956, 3.46080279350281, 3.45360589027405, 3.44637703895569, 3.43910336494446, 3.43180274963379, 3.42445230484009, 3.41704320907593, 3.40966153144836, 3.40220737457275, 3.3946807384491, 3.38714528083801, 3.37958717346191, 3.37197971343994, 3.36432719230652, 3.35666990280151, 3.34894061088562, 3.34119296073914, 3.33337783813477, 3.32552194595337, 3.31769800186157, 3.3097836971283, 3.30179667472839, 3.2938597202301, 3.28583741188049, 3.27776455879211, 3.26966977119446, 3.26152992248535, 3.25336265563965, 3.24515509605408, 3.23691582679749, 3.22863602638245, 3.22042369842529, 3.21415162086487, 3.20789766311646, 3.20165729522705, 3.19544863700867, 3.18924903869629, 3.18306708335876, 3.17689871788025, 3.17075300216675, 3.16462564468384, 3.15850710868835, 3.15242004394531, 3.14635109901428, 3.14028215408325, 3.13424038887024, 3.12822103500366, 3.12221050262451, 3.11622786521912, 3.11026215553284, 3.1043062210083, 3.0983726978302, 3.09245276451111, 3.08655953407288, 3.08067107200623, 3.07481455802917, 3.0689754486084, 3.06314134597778, 3.05733418464661, 3.05154013633728, 3.04575562477112, 3.04000234603882, 3.03427219390869, 3.02854180335999, 3.02283811569214, 3.01715755462646, 3.01149463653564, 3.00582695007324, 3.00020027160645, 2.99459600448608, 2.9889919757843, 2.98341488838196, 2.97785592079163, 2.97230124473572, 2.96678280830383, 2.96127796173096, 2.95578193664551, 2.95031332969666, 2.94485783576965, 2.93940734863281, 2.93399262428284, 2.92859601974487, 2.92322659492493, 2.9178478717804, 2.91250085830688, 2.90717649459839, 2.90184760093689, 2.89655470848083, 2.89128446578979, 2.88602781295776, 2.88077545166016, 2.87555480003357, 2.87034320831299, 2.86515855789185, 2.85998296737671, 2.85483932495117, 2.84969997406006, 2.84458756446838, 2.83947062492371, 2.83438992500305, 2.82933139801025, 2.8242871761322, 2.819256067276, 2.81467700004578, 2.80974984169006, 2.80482459068298, 2.7999267578125, 2.79503989219666, 2.79015111923218, 2.78528881072998, 2.78044295310974, 2.77559900283813, 2.77077770233154, 2.76597237586975, 2.76118063926697, 2.75638818740845, 2.7516233921051, 2.74687004089355, 2.74212288856506, 2.73739647865295, 2.73269033432007, 2.7279839515686, 2.72329354286194, 2.71862578392029, 2.71395778656006, 2.70931029319763, 2.70468306541443, 2.70005583763123, 2.69545555114746, 2.6908643245697, 2.68629145622253, 2.68171811103821, 2.67716789245605, 2.67263746261597, 2.66810059547424, 2.66359710693359, 2.65910077095032, 2.65461325645447, 2.65014624595642, 2.64569282531738, 2.64123940467834, 2.63681268692017, 2.63239741325378, 2.62799835205078, 2.62360787391663, 2.61923551559448, 2.61486983299255, 2.61051821708679, 2.6061840057373, 2.6018705368042, 2.59755659103394, 2.59326791763306, 2.58898544311523, 2.58471274375916, 2.58046460151672, 2.57622504234314, 2.57199048995972, 2.56778502464294, 2.56359124183655, 2.559410572052, 2.55522775650024, 2.5510721206665, 2.54692983627319, 2.54279661178589, 2.53867936134338, 2.53457760810852, 2.53048276901245, 2.52640819549561, 2.52234745025635, 2.51828861236572, 2.51425695419312, 2.51023888587952, 2.50622510910034, 2.50223183631897, 2.49718952178955, 2.49325942993164, 2.48933935165405, 2.48542499542236, 2.48151659965515, 2.47761225700378, 2.47371697425842, 2.46982526779175, 2.46594262123108, 2.46206641197205, 2.45819282531738, 2.45432806015015, 2.45046901702881, 2.44661664962769, 2.44277358055115, 2.43893361091614, 2.43509960174561, 2.43126845359802, 2.42744922637939, 2.42363047599792, 2.41982674598694, 2.41602396965027, 2.4122269153595, 2.40843915939331, 2.40465331077576, 2.40087676048279, 2.39710474014282, 2.39334011077881, 2.38958239555359, 2.38582611083984, 2.38208103179932, 2.37834048271179, 2.37460780143738, 2.37087726593018, 2.3671567440033, 2.36344313621521, 2.35973334312439, 2.35603213310242, 2.35233426094055, 2.3486430644989, 2.3449592590332, 2.34128165245056, 2.3376133441925, 2.33394479751587, 2.33029007911682, 2.32663512229919, 2.32298684120178, 2.31934809684753, 2.31571340560913, 2.31208467483521, 2.30846786499023, 2.30485463142395, 2.30124282836914, 2.29763984680176, 2.29404330253601, 2.29045176506042, 2.28687262535095, 2.28329229354858, 2.27972173690796, 2.27615714073181, 2.27259707450867, 2.26904344558716, 2.26549696922302, 2.26195597648621, 2.25842380523682, 2.25489544868469, 2.25137376785278, 2.24785661697388, 2.2443482875824, 2.24084687232971, 2.23735213279724, 2.23385953903198, 2.23019456863403, 2.22667860984802, 2.22316241264343, 2.21964406967163, 2.21612453460693, 2.21260404586792, 2.20907974243164, 2.20555806159973, 2.20203065872192, 2.19850325584412, 2.19497466087341, 2.19144153594971, 2.18790984153748, 2.18437552452087, 2.18083906173706, 2.17730259895325, 2.17376399040222, 2.17022395133972, 2.16668319702148, 2.16313672065735, 2.15959334373474, 2.15604567527771, 2.15249562263489, 2.14894580841064, 2.14539241790771, 2.14183902740479, 2.13828587532043, 2.1347279548645, 2.13117003440857, 2.12760877609253, 2.12404632568359, 2.12048387527466, 2.1169171333313, 2.11335229873657, 2.10978555679321, 2.10621619224548, 2.10264492034912, 2.09907245635986, 2.09549641609192, 2.09192276000977, 2.0883412361145, 2.08476424217224, 2.08118152618408, 2.07760000228882, 2.07401609420776, 2.0704300403595, 2.06684184074402, 2.06325340270996, 2.0596616268158, 2.05607008934021, 2.05247616767883, 2.04887986183167, 2.0452835559845, 2.04168629646301, 2.03808426856995, 2.03448247909546, 2.03087830543518, 2.02727437019348, 2.02366781234741, 2.02005696296692, 2.01644849777222, 2.01283621788025, 2.00922322273254, 2.00560784339905, 2.00199007987976, 1.99837255477905, 1.99475479125977, 1.99113154411316, 1.98750817775726, 1.98388493061066, 1.98025715351105, 1.97669982910156, 1.9725034236908, 1.96831595897675, 1.96414458751678, 1.95996391773224, 1.95580017566681, 1.95164453983307, 1.94748532772064, 1.94334661960602, 1.93921339511871, 1.93508470058441, 1.93095600605011, 1.92684423923492, 1.92273807525635, 1.91864442825317, 1.9145439863205, 1.91046488285065, 1.90637910366058, 1.90231132507324, 1.89825475215912, 1.89419507980347, 1.89014410972595, 1.88610458374023, 1.88206839561462, 1.87804567813873, 1.87402296066284, 1.87001502513885, 1.86600255966187, 1.8620080947876, 1.85801827907562, 1.85404300689697, 1.85005760192871, 1.84609591960907, 1.84213519096375, 1.83818376064301, 1.83423542976379, 1.83030188083649, 1.82637059688568, 1.82243835926056, 1.81852269172668, 1.814617395401, 1.81072235107422, 1.80681812763214, 1.80293536186218, 1.79905140399933, 1.79517650604248, 1.79131865501404, 1.7874596118927, 1.78360056877136, 1.77976059913635, 1.77592527866364, 1.77209877967834, 1.76827239990234, 1.76446413993835, 1.76066040992737, 1.75685214996338, 1.75306284427643, 1.74928390979767, 1.7455050945282, 1.74173057079315, 1.73796844482422, 1.73421657085419, 1.73047268390656, 1.72672522068024, 1.72299242019653, 1.71926081180573, 1.71554267406464, 1.71184039115906, 1.70813488960266, 1.70442914962769, 1.70074272155762, 1.69706189632416, 1.69445717334747, 1.69148361682892, 1.68852591514587, 1.68557715415955, 1.68263506889343, 1.67971575260162, 1.67681217193604, 1.67392206192017, 1.6710296869278, 1.66816222667694, 1.66530156135559, 1.66246330738068, 1.65963649749756, 1.65681850910187, 1.65400731563568, 1.65121877193451, 1.64844608306885, 1.64568686485291, 1.64292752742767, 1.64019322395325, 1.63747012615204, 1.63475370407104, 1.63205993175507, 1.62937748432159, 1.62670850753784, 1.62404179573059, 1.62139534950256, 1.61876237392426, 1.61614990234375, 1.61354196071625, 1.61094963550568, 1.60836184024811, 1.60579442977905, 1.60324716567993, 1.60070908069611, 1.59817326068878, 1.5956597328186, 1.59316003322601, 1.59067392349243, 1.58820128440857, 1.58574199676514, 1.58329403400421, 1.58084845542908, 1.57842767238617, 1.57602715492249, 1.5736335515976, 1.57124197483063, 1.56887078285217, 1.56650865077972, 1.56417369842529, 1.56184315681458, 1.55952596664429, 1.55721807479858, 1.55492579936981, 1.55265629291534, 1.5503933429718, 1.54813277721405, 1.54589462280273, 1.54366338253021, 1.54145920276642, 1.53926157951355, 1.53707766532898, 1.5349006652832, 1.53273940086365, 1.53059601783752, 1.52846848964691, 1.5263409614563, 1.5242383480072, 1.52214455604553, 1.52005779743195, 1.5179957151413, 1.51599788665771, 1.51389062404633, 1.51178467273712, 1.50968420505524, 1.50757813453674, 1.50547993183136, 1.50337743759155, 1.50128018856049, 1.49917984008789, 1.49708271026611, 1.49498915672302, 1.49289309978485, 1.49080288410187, 1.48870801925659, 1.4866189956665, 1.48453104496002, 1.48244297504425, 1.48035478591919, 1.47827255725861, 1.47618782520294, 1.47410655021667, 1.47202551364899, 1.46994650363922, 1.46786630153656, 1.4657895565033, 1.46371388435364, 1.46163725852966, 1.45956611633301, 1.45749378204346, 1.45542168617249, 1.45335268974304, 1.45128500461578, 1.44921731948853, 1.44715523719788, 1.44508874416351, 1.44302332401276, 1.44096457958221, 1.43890130519867, 1.43684267997742, 1.43478381633759, 1.43273091316223, 1.43067216873169, 1.42862260341644, 1.42656826972961, 1.42451751232147, 1.42246568202972, 1.4204193353653, 1.41836965084076, 1.41632568836212, 1.41427934169769, 1.41223537921906, 1.41019248962402, 1.4081529378891, 1.40611231327057, 1.40407168865204, 1.40203666687012, 1.4000016450882, 1.39796662330627, 1.39593279361725, 1.39390003681183, 1.39186954498291, 1.38984358310699, 1.38781297206879, 1.38578379154205, 1.38376104831696, 1.38173627853394, 1.37971246242523, 1.37769103050232, 1.37567412853241, 1.373650431633, 1.3716367483139, 1.36941576004028, 1.36705923080444, 1.36470603942871, 1.36235415935516, 1.36000216007233, 1.35764670372009, 1.35529589653015, 1.35294282436371, 1.35059523582458, 1.34824109077454, 1.34589016437531, 1.34354162216187, 1.34119296073914, 1.33884108066559, 1.33649587631226, 1.33414602279663, 1.33179986476898, 1.32945215702057, 1.32710587978363, 1.3247584104538, 1.32240986824036, 1.32006680965424, 1.31772065162659, 1.31537544727325, 1.31303238868713, 1.3106894493103, 1.30834305286407, 1.30600118637085, 1.30365931987762, 1.30131757259369, 1.29897463321686, 1.29663395881653, 1.29429090023041, 1.29194903373718, 1.28961074352264, 1.28726994991302, 1.2849338054657, 1.28259205818176, 1.28025567531586, 1.27792072296143, 1.27558326721191, 1.27324485778809, 1.27090978622437, 1.26857376098633, 1.26623630523682, 1.26390016078949, 1.26156282424927, 1.25923109054565, 1.25689613819122, 1.25456547737122, 1.2522304058075, 1.24990105628967, 1.24756705760956, 1.24523544311523, 1.24290490150452, 1.2405743598938, 1.23824274539948, 1.23591542243958, 1.23358154296875, 1.23125100135803, 1.22892379760742, 1.22659552097321, 1.2242659330368, 1.22193908691406, 1.21961295604706, 1.21728694438934, 1.21495974063873, 1.21263372898102, 1.21030747890472, 1.2079838514328, 1.20565903186798, 1.20333397388458, 1.20121777057648, 1.1990270614624, 1.19684100151062, 1.19465482234955, 1.19247984886169, 1.19030272960663, 1.18813920021057, 1.18598234653473, 1.1838231086731, 1.18167757987976, 1.17952990531921, 1.1773933172226, 1.17525911331177, 1.17313170433044, 1.17101299762726, 1.16889452934265, 1.16678738594055, 1.16467797756195, 1.16258203983307, 1.16049063205719, 1.15840137004852, 1.15631926059723, 1.15424346923828, 1.15217256546021, 1.15010809898376, 1.14804601669312, 1.14599299430847, 1.14394223690033, 1.14190483093262, 1.13986313343048, 1.13783490657806, 1.13580894470215, 1.13378751277924, 1.13177275657654, 1.12976264953613, 1.12775921821594, 1.12576031684875, 1.12376809120178, 1.12178730964661, 1.11980187892914, 1.11782550811768, 1.11585140228271, 1.11389088630676, 1.11193263530731, 1.10997664928436, 1.10803186893463, 1.10608923435211, 1.10415363311768, 1.10222232341766, 1.10029566287994, 1.09837794303894, 1.09646260738373, 1.09455382823944, 1.09264743328094, 1.09075450897217, 1.08886396884918, 1.0869756937027, 1.08509635925293, 1.08321917057037, 1.08135342597961, 1.07948756217957, 1.07763087749481, 1.07578086853027, 1.07392859458923, 1.0720921754837, 1.07025110721588, 1.06842362880707, 1.06660294532776, 1.06477785110474, 1.06296849250793, 1.06115901470184, 1.05923402309418, 1.05762708187103, 1.05602180957794, 1.05441999435425, 1.05281591415405, 1.05121862888336, 1.04961955547333, 1.04802513122559, 1.04643511772156, 1.04484057426453, 1.04325234889984, 1.04166400432587, 1.0400801897049, 1.03849923610687, 1.03691375255585, 1.03533720970154, 1.03375685214996, 1.0321831703186, 1.03060507774353, 1.02903652191162, 1.02746915817261, 1.0258971452713, 1.02433145046234, 1.02276742458344, 1.02120733261108, 1.01964724063873, 1.01808762550354, 1.01653265953064, 1.01497483253479, 1.01342308521271, 1.01187205314636, 1.01032555103302, 1.00877892971039, 1.0072329044342, 1.00569140911102, 1.00414764881134, 1.00261187553406, 1.00107598304749, 0.999538481235504, 0.998007774353027, 0.996475279331207, 0.994945108890533, 0.993417143821716, 0.991894781589508, 0.990372538566589, 0.988847315311432, 0.987332403659821, 0.985808908939362, 0.984295666217804, 0.982783436775208, 0.981270253658295, 0.97976142168045, 0.978251516819, 0.976747930049896, 0.975241303443909, 0.973741590976715, 0.972242951393127, 0.970741450786591, 0.969246864318848, 0.967751026153564, 0.966259181499481, 0.964771807193756, 0.963281095027924, 0.961796045303345, 0.960308194160461, 0.958826959133148, 0.957344174385071, 0.955866456031799, 0.954392611980438, 0.95291543006897, 0.951442718505859, 0.949969530105591, 0.947934508323669, 0.946211934089661, 0.944488883018494, 0.942764580249786, 0.941040933132172, 0.939317941665649, 0.937593042850494, 0.935870587825775, 0.934144616127014, 0.932421445846558, 0.930700063705444, 0.928974211215973, 0.927251636981964, 0.925527989864349, 0.923804342746735, 0.922080636024475, 0.920355916023254, 0.918633282184601, 0.916909635066986, 0.915184855461121, 0.913462281227112, 0.911739826202393, 0.910014927387238, 0.908291339874268, 0.906568765640259, 0.904842853546143, 0.903120279312134, 0.901395499706268, 0.899671792984009, 0.897950410842896, 0.896226763725281, 0.894501924514771, 0.892778337001801, 0.89105349779129, 0.889330983161926, 0.887606143951416, 0.885883629322052, 0.884161055088043, 0.882435202598572, 0.880712628364563, 0.878990054130554, 0.877265274524689, 0.875541567802429, 0.873819053173065, 0.8720942735672, 0.87037056684494, 0.868645846843719, 0.866923272609711, 0.865200757980347, 0.863476037979126, 0.861753404140472, 0.860029757022858, 0.858303785324097, 0.856582403182983, 0.854857623577118, 0.853133976459503, 0.85141259431839, 0.849686622619629, 0.847962975502014, 0.846240401268005, 0.844516754150391, 0.84279191493988, 0.841068267822266, 0.839344561100006, 0.837622106075287, 0.835896134376526, 0.834174752235413, 0.832452178001404, 0.830726265907288, 0.829003751277924, 0.827280104160309, 0.825406730175018, 0.823614299297333, 0.821828603744507, 0.820057511329651, 0.818290948867798, 0.816523313522339, 0.814772546291351, 0.813028633594513, 0.811282336711884, 0.80955308675766, 0.807830572128296, 0.806102395057678, 0.80439680814743, 0.80269455909729, 0.800999104976654, 0.799305856227875, 0.797623932361603, 0.795951128005981, 0.794279336929321, 0.792619943618774, 0.790968477725983, 0.789312481880188, 0.787682414054871, 0.786053597927094, 0.784428000450134, 0.782805919647217, 0.781203031539917, 0.779594302177429, 0.777993679046631, 0.776414394378662, 0.774831771850586, 0.773253619670868, 0.77168333530426, 0.770131170749664, 0.768583476543427, 0.767031192779541, 0.765494823455811, 0.76396518945694, 0.762434482574463, 0.760920643806458, 0.759415805339813, 0.757904171943665, 0.756416320800781, 0.754928410053253, 0.753452897071838, 0.751974105834961, 0.750512063503265, 0.749054610729218, 0.747597217559814, 0.746153295040131, 0.744720637798309, 0.74328351020813, 0.741863310337067, 0.74045330286026, 0.739047765731812, 0.737639904022217, 0.736247897148132, 0.73486715555191, 0.73348194360733, 0.732109069824219, 0.730749785900116, 0.729394972324371, 0.728039085865021, 0.726696670055389, 0.725364506244659, 0.724031150341034, 0.722710132598877, 0.721399366855621, 0.720082938671112, 0.718789100646973, 0.71749746799469, 0.716214835643768, 0.715867400169373, 0.71490067243576, 0.713945269584656, 0.712992072105408, 0.71205347776413, 0.711121737957001, 0.710191071033478, 0.709273934364319, 0.708366990089417, 0.707465708255768, 0.706571161746979, 0.705683410167694, 0.704806864261627, 0.703932642936707, 0.703073084354401, 0.70222020149231, 0.701369643211365, 0.700530529022217, 0.699705839157104, 0.698890268802643, 0.698066830635071, 0.697262465953827, 0.696467220783234, 0.695667445659637, 0.694889068603516, 0.694115221500397, 0.693348109722137, 0.69259238243103, 0.691843271255493, 0.691099941730499, 0.690359950065613, 0.689634561538696, 0.688920557498932, 0.688204228878021, 0.687503695487976, 0.686813354492188, 0.686116218566895, 0.68543940782547, 0.684773862361908, 0.684115052223206, 0.683452904224396, 0.682807624340057, 0.682172536849976, 0.681536316871643, 0.680914759635925, 0.680299937725067, 0.679690837860107, 0.67909300327301, 0.678501844406128, 0.677922070026398, 0.677344501018524, 0.676778256893158, 0.676222085952759, 0.675663709640503, 0.675125598907471, 0.674588739871979, 0.674055099487305, 0.673538506031036, 0.673030912876129, 0.672534465789795, 0.672025740146637, 0.671541810035706, 0.671064615249634, 0.670588612556458, 0.670129537582397, 0.669676005840302, 0.669230401515961, 0.668787121772766, 0.668353915214539, 0.667933106422424, 0.6675124168396, 0.666783690452576, 0.666294097900391, 0.665806233882904, 0.665321707725525, 0.664838969707489, 0.664359509944916, 0.663881778717041, 0.663409113883972, 0.662937104701996, 0.662468910217285, 0.66200190782547, 0.661538243293762, 0.661075711250305, 0.660615503787994, 0.660158634185791, 0.659705221652985, 0.659254491329193, 0.658806622028351, 0.658361673355103, 0.657916665077209, 0.657476186752319, 0.657037317752838, 0.656601369380951, 0.656168758869171, 0.655737817287445, 0.65531200170517, 0.6548872590065, 0.654462039470673, 0.654042363166809, 0.653623878955841, 0.653208792209625, 0.652799248695374, 0.652388691902161, 0.65198141336441, 0.651577532291412, 0.651174902915955, 0.650775551795959, 0.650378465652466, 0.649984180927277, 0.649591684341431, 0.649203062057495, 0.648816645145416, 0.648432612419128, 0.648052394390106, 0.647673368453979, 0.647297739982605, 0.646924912929535, 0.64655214548111, 0.646184325218201, 0.645818889141083, 0.645454525947571, 0.645094633102417, 0.644737064838409, 0.644380629062653, 0.644027531147003, 0.643677294254303, 0.64333039522171, 0.642985224723816, 0.642642259597778, 0.642301559448242, 0.641964375972748, 0.641628742218018, 0.641296565532684, 0.640967130661011, 0.640640556812286, 0.640316247940063, 0.639993607997894, 0.639674305915833, 0.639357388019562, 0.639044880867004, 0.63873416185379, 0.638559997081757, 0.638307332992554, 0.638047814369202, 0.637790679931641, 0.637532889842987, 0.637268364429474, 0.636999845504761, 0.636736452579498, 0.636465132236481, 0.636193871498108, 0.635923743247986, 0.635649621486664, 0.635370373725891, 0.635094583034515, 0.634813129901886, 0.634529411792755, 0.634248495101929, 0.633959770202637, 0.633675515651703, 0.633383333683014, 0.633090615272522, 0.632798969745636, 0.632501244544983, 0.632203936576843, 0.631906688213348, 0.631604373455048, 0.631297528743744, 0.630995273590088, 0.630685031414032, 0.630379319190979, 0.630065739154816, 0.629752159118652, 0.629435122013092, 0.629120409488678, 0.628799974918365, 0.628481924533844, 0.628158211708069, 0.627832174301147, 0.627506732940674, 0.627177894115448, 0.626848518848419, 0.626515746116638, 0.626179039478302, 0.62584114074707, 0.625504970550537, 0.625163197517395, 0.624824225902557, 0.624478995800018, 0.62413215637207, 0.623785853385925, 0.623435020446777, 0.623080849647522, 0.622728824615479, 0.622373521327972, 0.622011423110962, 0.62165492773056, 0.621291697025299, 0.620930731296539, 0.620564103126526, 0.620194137096405, 0.619824707508087, 0.619455277919769, 0.619082450866699, 0.618708491325378, 0.618329405784607, 0.617946445941925, 0.617568612098694, 0.617184460163116, 0.616803169250488, 0.616415143013, 0.616023659706116, 0.615632295608521, 0.615534126758575, 0.615098655223846, 0.614670038223267, 0.614227831363678, 0.613769829273224, 0.613325357437134, 0.612853825092316, 0.612384557723999, 0.611913084983826, 0.611421167850494, 0.610922634601593, 0.610433042049408, 0.609920918941498, 0.609415590763092, 0.608883082866669, 0.608355164527893, 0.607818186283112, 0.607279062271118, 0.606726288795471, 0.606178045272827, 0.605605006217957, 0.605031907558441, 0.604458868503571, 0.603870093822479, 0.603269875049591, 0.602674245834351, 0.602065145969391, 0.601449191570282, 0.600835621356964, 0.600199341773987, 0.599560856819153, 0.598920166492462, 0.598265826702118, 0.597611606121063, 0.596946060657501, 0.596269190311432, 0.595587849617004, 0.594906508922577, 0.594204843044281, 0.593512177467346, 0.592797100543976, 0.59207284450531, 0.591359972953796, 0.590626657009125, 0.589895725250244, 0.589148938655853, 0.588390827178955, 0.587628304958344, 0.58687025308609, 0.586087346076965, 0.585318088531494, 0.584526181221008, 0.583718419075012, 0.582928836345673, 0.58211213350296, 0.581295371055603, 0.580480933189392, 0.579639494419098, 0.578802406787872, 0.577960908412933, 0.577101349830627, 0.576237201690674, 0.575375378131866, 0.574497699737549, 0.573613345623016, 0.572726666927338, 0.571828722953796, 0.570933103561401, 0.570014894008636, 0.569092154502869, 0.568173885345459, 0.566615045070648, 0.565377652645111, 0.564145803451538, 0.562902688980103, 0.561656177043915, 0.560415327548981, 0.559164345264435, 0.55790764093399, 0.556652128696442, 0.555389881134033, 0.554128706455231, 0.552858531475067, 0.551581561565399, 0.55030232667923, 0.549032211303711, 0.547747313976288, 0.546465873718262, 0.545177638530731, 0.543877005577087, 0.542586445808411, 0.541289210319519, 0.539982974529266, 0.538682281970978, 0.537369251251221, 0.536051690578461, 0.534742057323456, 0.533419966697693, 0.532099008560181, 0.530771255493164, 0.529434561729431, 0.528103470802307, 0.526770114898682, 0.5254265666008, 0.524091005325317, 0.522738456726074, 0.521382570266724, 0.520037889480591, 0.518671810626984, 0.517310261726379, 0.515950977802277, 0.514579236507416, 0.513206422328949, 0.51183694601059, 0.510456264019012, 0.509072124958038, 0.507689118385315, 0.50629711151123, 0.50491189956665, 0.50351083278656, 0.502109825611115, 0.500712156295776, 0.499305486679077, 0.497895419597626, 0.496486455202103, 0.495065122842789, 0.493644893169403, 0.492221295833588, 0.490795463323593, 0.489366203546524, 0.487934708595276, 0.486494183540344, 0.485051423311234, 0.483612030744553, 0.48216250538826, 0.480712950229645, 0.479256629943848, 0.477796941995621, 0.476345121860504, 0.474878698587418, 0.473405450582504, 0.471940100193024, 0.470460087060928, 0.469391852617264, 0.468013375997543, 0.466640502214432, 0.465268790721893, 0.463919699192047, 0.462563723325729, 0.46121346950531, 0.459878981113434, 0.458541125059128, 0.457208871841431, 0.45588231086731, 0.454571515321732, 0.453260719776154, 0.451953321695328, 0.450654953718185, 0.449362188577652, 0.44807505607605, 0.446793586015701, 0.44552344083786, 0.444253236055374, 0.44298529624939, 0.441737681627274, 0.440485507249832, 0.439239054918289, 0.437999337911606, 0.436768621206284, 0.435543537139893, 0.434316247701645, 0.433108121156693, 0.431899964809418, 0.430697441101074, 0.429497212171555, 0.4283127784729, 0.427123785018921, 0.425946146249771, 0.424778580665588, 0.423612147569656, 0.422445774078369, 0.421290636062622, 0.420149028301239, 0.41900634765625, 0.417868137359619, 0.416732221841812, 0.415619939565659, 0.414495259523392, 0.413380771875381, 0.412282049655914, 0.411178797483444, 0.41008460521698, 0.408993750810623, 0.407917618751526, 0.406842589378357, 0.405768692493439, 0.404709428548813, 0.403647929430008, 0.402596592903137, 0.40155765414238, 0.400517582893372, 0.399483203887939, 0.398449867963791, 0.397436887025833, 0.396419405937195, 0.395404130220413, 0.394408077001572, 0.393408626317978, 0.392417103052139, 0.391430020332336, 0.390456527471542, 0.389480769634247, 0.388509511947632, 0.387545019388199, 0.387005835771561, 0.386303067207336, 0.38560476899147, 0.384918928146362, 0.384234189987183, 0.383549481630325, 0.382876038551331, 0.382214993238449, 0.381553947925568, 0.380897432565689, 0.380252152681351, 0.379606932401657, 0.378970742225647, 0.378339022397995, 0.377720862627029, 0.377094775438309, 0.376486718654633, 0.375886619091034, 0.375281989574432, 0.374685257673264, 0.374105453491211, 0.373522222042084, 0.37294128537178, 0.372367113828659, 0.371810972690582, 0.371252566576004, 0.370697617530823, 0.370146006345749, 0.369613528251648, 0.369073241949081, 0.368550926446915, 0.3680320084095, 0.367514222860336, 0.367002099752426, 0.36649563908577, 0.366006016731262, 0.365511953830719, 0.365022391080856, 0.364539563655853, 0.364073693752289, 0.363606691360474, 0.363140821456909, 0.362689554691315, 0.362240582704544, 0.361795008182526, 0.361357361078262, 0.360928684473038, 0.360502302646637, 0.360079258680344, 0.359674274921417, 0.359264820814133, 0.358856439590454, 0.358468383550644, 0.358079224824905, 0.357697933912277, 0.35731440782547, 0.356948912143707, 0.356585681438446, 0.356220215559006, 0.355877250432968, 0.355526447296143, 0.355185747146606, 0.354848504066467, 0.354524731636047, 0.35420098900795, 0.353879511356354, 0.35356816649437, 0.353269189596176, 0.352964639663696, 0.352670222520828, 0.352391600608826, 0.352109581232071, 0.351399064064026, 0.351121574640274, 0.35084068775177, 0.350563198328018, 0.350283443927765, 0.35000142455101, 0.349718272686005, 0.349432855844498, 0.349148601293564, 0.348865449428558, 0.348578959703445, 0.348292410373688, 0.34800136089325, 0.347719371318817, 0.347428351640701, 0.347135037183762, 0.346845149993896, 0.346555203199387, 0.346258550882339, 0.345967501401901, 0.345670789480209, 0.345374137163162, 0.345078587532043, 0.344784170389175, 0.344486355781555, 0.344186305999756, 0.343883991241455, 0.343586176633835, 0.343282729387283, 0.342982649803162, 0.342676967382431, 0.342374682426453, 0.342070072889328, 0.341760993003845, 0.341454178094864, 0.34114733338356, 0.340842753648758, 0.340531408786774, 0.340220093727112, 0.339909851551056, 0.339598506689072, 0.339287161827087, 0.338970184326172, 0.338655471801758, 0.338339596986771, 0.338028252124786, 0.337709039449692, 0.337389767169952, 0.337069392204285, 0.336752414703369, 0.336434334516525, 0.336112797260284, 0.335787922143936, 0.335464179515839, 0.335140436887741, 0.334817796945572, 0.334491819143295, 0.334164679050446, 0.333834141492844, 0.333511501550674, 0.333182156085968, 0.332850456237793, 0.332518845796585, 0.332188278436661, 0.331853300333023, 0.331521600484848, 0.331187695264816, 0.330850452184677, 0.330515384674072, 0.33017697930336, 0.329841941595078, 0.329669386148453, 0.329174131155014, 0.328680098056793, 0.328179180622101, 0.327678352594376, 0.327171832323074, 0.326664239168167, 0.326148718595505, 0.325628668069839, 0.325107514858246, 0.324589759111404, 0.324058383703232, 0.323527097702026, 0.322991251945496, 0.322454333305359, 0.321913987398148, 0.321369171142578, 0.320819765329361, 0.320262521505356, 0.31970751285553, 0.319153666496277, 0.318587362766266, 0.318019926548004, 0.317446887493134, 0.316871583461761, 0.31630077958107, 0.315717577934265, 0.315133273601532, 0.314543306827545, 0.313951045274734, 0.313359975814819, 0.312760919332504, 0.312156319618225, 0.311549425125122, 0.310936897993088, 0.310332268476486, 0.30971297621727, 0.30909138917923, 0.308468729257584, 0.307838141918182, 0.307208657264709, 0.306576937437057, 0.305937349796295, 0.305294364690781, 0.304648011922836, 0.304006099700928, 0.303352981805801, 0.302696466445923, 0.302036553621292, 0.30137100815773, 0.300704300403595, 0.300038784742355, 0.299363076686859, 0.298685103654861, 0.298004865646362, 0.297325789928436, 0.296636551618576, 0.295943915843964, 0.295249044895172, 0.294548511505127, 0.293846875429153, 0.293144106864929, 0.292433440685272, 0.291719347238541, 0.291004180908203, 0.290290117263794, 0.289560258388519, 0.288836061954498, 0.288106203079224, 0.287370711565018, 0.286632984876633, 0.285902053117752, 0.285084187984467, 0.284265220165253, 0.283451944589615, 0.282632976770401, 0.281811743974686, 0.280997306108475, 0.280178338289261, 0.279360502958298, 0.278541535139084, 0.277723699808121, 0.276906996965408, 0.276092559099197, 0.275273591279984, 0.274457991123199, 0.273641288280487, 0.272823452949524, 0.272003352642059, 0.271190017461777, 0.270373344421387, 0.269554376602173, 0.268736511468887, 0.267922073602676, 0.267106503248215, 0.266290903091431, 0.265471935272217, 0.264656364917755, 0.263839662075043, 0.263025224208832, 0.262206256389618, 0.261389523744583, 0.260575085878372, 0.25976175069809, 0.258943945169449, 0.258129447698593, 0.257312774658203, 0.25649830698967, 0.255679339170456, 0.254867136478424, 0.254051566123962, 0.253235995769501, 0.252420425415039, 0.251604825258255, 0.250792622566223, 0.249977052211761, 0.249160349369049, 0.248344764113426, 0.247530296444893, 0.246718108654022, 0.24590028822422, 0.245085805654526, 0.244272500276566, 0.243459179997444, 0.242644712328911, 0.241829127073288, 0.241015821695328, 0.240201368927956, 0.239384651184082, 0.238572463393211, 0.23775914311409, 0.236946940422058, 0.236131355166435, 0.235316917300224, 0.234504729509354, 0.233691394329071, 0.232875823974609, 0.232062488794327, 0.231249153614044, 0.230438098311424, 0.2296202480793, 0.22881144285202, 0.227998122572899, 0.227211877703667, 0.226538985967636, 0.225868344306946, 0.225201681256294, 0.224535003304482, 0.223869457840919, 0.223205596208572, 0.222544565796852, 0.221886903047562, 0.221228674054146, 0.220573842525482, 0.219922408461571, 0.219271510839462, 0.218620076775551, 0.21797314286232, 0.217329576611519, 0.216686591506004, 0.216044723987579, 0.215405121445656, 0.214767783880234, 0.214131578803062, 0.213497042655945, 0.212865322828293, 0.212236449122429, 0.211609244346619, 0.210982039570808, 0.210358813405037, 0.209737256169319, 0.209118515253067, 0.208496943116188, 0.207882717251778, 0.207269087433815, 0.206655979156494, 0.2060457020998, 0.205437675118446, 0.204832479357719, 0.204226732254028, 0.203622072935104, 0.203023657202721, 0.20242466032505, 0.201830178499222, 0.201233446598053, 0.20064178109169, 0.200050115585327, 0.19946126639843, 0.198873564600945, 0.198289230465889, 0.197705447673798, 0.197126775979996, 0.196545824408531, 0.195969954133034, 0.195392966270447, 0.19482159614563, 0.194247424602509, 0.193678885698318, 0.193112596869469, 0.192547455430031, 0.191981181502342, 0.191421642899513, 0.190861016511917, 0.190305456519127, 0.18974594771862, 0.189194336533546, 0.188642144203186, 0.188093349337578, 0.18754455447197, 0.186998009681702, 0.186454281210899, 0.185912266373634, 0.185369104146957, 0.184833288192749, 0.184291809797287, 0.183714836835861, 0.183139503002167, 0.182566449046135, 0.181992292404175, 0.181420922279358, 0.180850133299828, 0.180281609296799, 0.179711952805519, 0.179145634174347, 0.178577676415443, 0.178013101220131, 0.177448496222496, 0.176885604858398, 0.176323264837265, 0.175763189792633, 0.17520309984684, 0.174645289778709, 0.174086898565292, 0.173530220985413, 0.172975778579712, 0.172420784831047, 0.171868607401848, 0.171315848827362, 0.170765921473503, 0.170214876532555, 0.169666066765785, 0.169118419289589, 0.168572440743446, 0.168026462197304, 0.167483299970627, 0.16693902015686, 0.16639755666256, 0.165857210755348, 0.165315762162209, 0.164777666330338, 0.164239034056664, 0.163703754544258, 0.163167953491211, 0.162634387612343, 0.162099123001099, 0.161567822098732, 0.161035358905792, 0.160506322979927, 0.15997725725174, 0.159449890255928, 0.158922538161278, 0.158397987484932, 0.157872885465622, 0.157349482178688, 0.156827747821808, 0.156306028366089, 0.155785977840424, 0.155266523361206, 0.154749304056168, 0.15423209965229, 0.153716027736664, 0.153201058506966, 0.152687802910805, 0.152175098657608, 0.151665225625038, 0.151154205203056, 0.150645449757576, 0.150137275457382, 0.149630218744278, 0.14912486076355, 0.148620039224625, 0.148117512464523, 0.147614404559135, 0.147112965583801, 0.146612107753754, 0.146112963557243, 0.145485743880272, 0.144924536347389, 0.144370093941689, 0.143814533948898, 0.143265709280968, 0.142723679542542, 0.142177134752274, 0.141639068722725, 0.14110042154789, 0.140565723180771, 0.14003723859787, 0.139508739113808, 0.138988703489304, 0.138465851545334, 0.137946933507919, 0.137434244155884, 0.136921539902687, 0.136416167020798, 0.135909110307693, 0.135410517454147, 0.134910777211189, 0.134416699409485, 0.133926555514336, 0.133435860276222, 0.132953599095345, 0.132470801472664, 0.131991937756538, 0.131519287824631, 0.131044372916222, 0.130577921867371, 0.130110338330269, 0.129647269845009, 0.129190981388092, 0.128733560442924, 0.128282323479652, 0.127830550074577, 0.127384394407272, 0.12694163620472, 0.126501128077507, 0.126066833734512, 0.125633656978607, 0.125201061367989, 0.124776348471642, 0.124351061880589, 0.123934246599674, 0.123515173792839, 0.123104564845562, 0.122692815959454, 0.122283346951008, 0.121882311999798, 0.121480733156204, 0.121084220707417, 0.120687708258629, 0.120296835899353, 0.119909912347794, 0.119522988796234, 0.119144529104233, 0.118764936923981, 0.11838760972023, 0.118019297719002, 0.117647610604763, 0.117286629974842, 0.11692114174366, 0.116561852395535, 0.116207644343376, 0.115853995084763, 0.115508243441582, 0.115160800516605, 0.114817880094051, 0.114481717348099, 0.114144437015057, 0.113816171884537, 0.113598458468914, 0.113385252654552, 0.113177694380283, 0.112973503768444, 0.112774968147278, 0.112576432526112, 0.112386919558048, 0.112197406589985, 0.112012408673763, 0.111834168434143, 0.111658200621605, 0.111488990485668, 0.111317522823811, 0.111152827739716, 0.110996030271053, 0.11083810031414, 0.110690325498581, 0.11053804308176, 0.110395900905132, 0.110258273780346, 0.110122926533222, 0.109995454549789, 0.109863460063934, 0.109737120568752, 0.109622061252594, 0.109508126974106, 0.109397582709789, 0.109288156032562, 0.109185509383678, 0.109083980321884, 0.108989223837852, 0.108902357518673, 0.108814366161823, 0.108734279870987, 0.1086530610919, 0.108576349914074, 0.108507551252842, 0.108439855277538, 0.108380071818829, 0.108320288360119, 0.108262754976749, 0.108216494321823, 0.108170256018639, 0.108127385377884, 0.108090169727802, 0.10805406421423, 0.108026996254921, 0.10799653083086, 0.107976227998734, 0.107958182692528, 0.107941262423992, 0.10793448984623, 0.107928849756718, 0.107927724719048, 0.107927724719048, 0.107931114733219, 0.107944652438164, 0.107955925166607, 0.107979618012905, 0.108001053333282, 0.10802698135376, 0.108057446777821, 0.108091287314892, 0.108133040368557, 0.10817252099514, 0.108222149312496, 0.108270652592182, 0.10832479596138, 0.108384594321251, 0.108448885381222, 0.108516573905945, 0.108493611216545, 0.108588360249996, 0.108684249222279, 0.108779564499855, 0.108877144753933, 0.108976416289806, 0.109075680375099, 0.109173819422722, 0.109275914728642, 0.109379693865776, 0.10948122292757, 0.109587259590626, 0.109691604971886, 0.109799332916737, 0.109905928373337, 0.110014781355858, 0.1101258918643, 0.110232494771481, 0.110347002744675, 0.110460370779037, 0.11057486385107, 0.110687673091888, 0.110805548727512, 0.110923431813717, 0.111040182411671, 0.11115749925375, 0.111279338598251, 0.111401721835136, 0.111521862447262, 0.111647069454193, 0.11177060008049, 0.111895807087421, 0.112022712826729, 0.112150751054287, 0.112279914319515, 0.112407386302948, 0.112538233399391, 0.112671352922916, 0.112802758812904, 0.112937562167645, 0.11307293176651, 0.113209426403046, 0.113345354795456, 0.113481283187866, 0.113622292876244, 0.11376103758812, 0.113903179764748, 0.114046990871429, 0.114189140498638, 0.114331841468811, 0.114477910101414, 0.114625692367554, 0.114771209657192, 0.114920109510422, 0.115071274340153, 0.115219049155712, 0.115371890366077, 0.115525312721729, 0.115679860115051, 0.115833267569542, 0.115988947451115, 0.116146303713322, 0.116304785013199, 0.116462722420692, 0.116624593734741, 0.116786472499371, 0.116945527493954, 0.117108531296253, 0.117273226380348, 0.117440186440945, 0.117604300379753, 0.117778591811657, 0.117884628474712, 0.117990672588348, 0.118093885481358, 0.118197090923786, 0.11829861998558, 0.11840184032917, 0.118501670658588, 0.118601508438587, 0.118700213730335, 0.118797779083252, 0.118894800543785, 0.118991248309612, 0.119085446000099, 0.11918019503355, 0.119272693991661, 0.119365192949772, 0.119456000626087, 0.119546242058277, 0.119637057185173, 0.119726173579693, 0.119812466204166, 0.11989875882864, 0.11998675018549, 0.120070792734623, 0.120154827833176, 0.120237745344639, 0.120320081710815, 0.120401315391064, 0.120481967926025, 0.120561487972736, 0.120640456676483, 0.120717726647854, 0.120794996619225, 0.120870016515255, 0.12094559520483, 0.121020600199699, 0.121093362569809, 0.121165566146374, 0.121237196028233, 0.121307700872421, 0.121376514434814, 0.121445886790752, 0.12151300907135, 0.121579565107822, 0.121644422411919, 0.121710404753685, 0.121773585677147, 0.121837876737118, 0.121899925172329, 0.12196196615696, 0.122021183371544, 0.12208267301321, 0.122140757739544, 0.122198849916458, 0.122254699468613, 0.122311666607857, 0.122365243732929, 0.122419953346252, 0.12247297167778, 0.122525431215763, 0.122576750814915, 0.122628077864647, 0.122676581144333, 0.122723966836929, 0.122772470116615, 0.122819848358631, 0.122866094112396, 0.122909523546696, 0.122955776751041, 0.12299807369709, 0.1231469810009, 0.123165033757687, 0.123183079063892, 0.123199440538883, 0.123217485845089, 0.123232714831829, 0.123249627649784, 0.123263739049435, 0.123278968036175, 0.123293071985245, 0.123306609690189, 0.123319573700428, 0.123332552611828, 0.123343825340271, 0.123356238007545, 0.123366385698318, 0.123376548290253, 0.12338725477457, 0.123396277427673, 0.123405866324902, 0.123413763940334, 0.123421669006348, 0.123428992927074, 0.123436324298382, 0.123441971838474, 0.123448178172112, 0.123453252017498, 0.123458884656429, 0.123462274670601, 0.123466223478317, 0.123469047248363, 0.123472429811954, 0.123473562300205, 0.123476378619671, 0.123476378619671, 0.123476937413216, 0.123477503657341, 0.123476378619671, 0.123476378619671, 0.123474113643169, 0.123472988605499, 0.123469598591328, 0.123466782271862, 0.123463399708271, 0.123459450900555, 0.123454369604588, 0.123449862003326, 0.123443655669689, 0.123438589274883, 0.123430691659451, 0.123423919081688, 0.123416021466255, 0.123408131301403, 0.123398534953594, 0.123390637338161, 0.123379930853844, 0.123370341956615, 0.123359054327011, 0.123347774147987, 0.123335935175419, 0.123323522508144, 0.1233099848032, 0.123297587037086, 0.123282916843891, 0.123268246650696, 0.123253591358662, 0.123237229883671, 0.123222000896931, 0.12320451438427, 0.123188160359859, 0.123170115053654, 0.123152062296867, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123111344873905, 0.123075239360332, 0.123105697333813, 0.123133897781372, 0.123163230717182, 0.12318916618824, 0.12321849912405, 0.123244449496269, 0.123269259929657, 0.123292952775955, 0.123315513134003, 0.12333694845438, 0.123359508812428, 0.123380944132805, 0.123400114476681, 0.123419292271137, 0.123437345027924, 0.12345539778471, 0.123470053076744, 0.123484723269939, 0.123500511050224, 0.123515173792839, 0.123527586460114, 0.123539999127388, 0.123550146818161, 0.123561434447765, 0.123570457100868, 0.123578354716301, 0.123586244881153, 0.123594135046005, 0.123600915074348, 0.12360542267561, 0.123608805239201, 0.123612187802792, 0.123614445328712, 0.123616702854633, 0.123618960380554, 0.123617835342884, 0.123617835342884, 0.123615570366383, 0.123612187802792, 0.123608805239201, 0.12360654771328, 0.123599782586098, 0.123594135046005, 0.123587377369404, 0.123579479753971, 0.123570457100868, 0.123560301959515, 0.123550146818161, 0.123539999127388, 0.123527586460114, 0.123515173792839, 0.123500511050224, 0.12348585575819, 0.123470053076744, 0.123454265296459, 0.123436219990253, 0.123419292271137, 0.123400114476681, 0.123379819095135, 0.123358383774757, 0.12333694845438, 0.123314388096333, 0.123291827738285, 0.123269259929657, 0.123243324458599, 0.12321737408638, 0.123190298676491, 0.123162098228931, 0.123133897781372, 0.123105697333813, 0.123075239360332, 0.123021766543388, 0.122956350445747, 0.122889786958694, 0.122822098433971, 0.12275442481041, 0.122682228684425, 0.122612282633781, 0.122537843883038, 0.122460000216961, 0.122383289039135, 0.122303202748299, 0.122224234044552, 0.122140757739544, 0.122055031359196, 0.121970430016518, 0.121882438659668, 0.121793329715729, 0.121700830757618, 0.121607191860676, 0.121513560414314, 0.121415428817272, 0.12131841480732, 0.121218018233776, 0.121117614209652, 0.121013842523098, 0.120907805860043, 0.120799511671066, 0.120692349970341, 0.120580665767193, 0.120470121502876, 0.120358444750309, 0.120242260396481, 0.1201226785779, 0.120005361735821, 0.1198835298419, 0.1197639554739, 0.119639873504639, 0.119511283934116, 0.119386054575443, 0.119256339967251, 0.119123235344887, 0.118988983333111, 0.118859268724918, 0.118721641600132, 0.118582889437675, 0.118443012237549, 0.118299752473831, 0.118157617747784, 0.118014357984066, 0.117867715656757, 0.117721065878868, 0.117568776011467, 0.117416486144066, 0.117263071238995, 0.117108531296253, 0.116951733827591, 0.116794928908348, 0.116632491350174, 0.116472311317921, 0.116307616233826, 0.116144046187401, 0.115975961089134, 0.115806765854359, 0.115634173154831, 0.115463830530643, 0.115288980305195, 0.115113012492657, 0.114938169717789, 0.114756546914577, 0.114576056599617, 0.114392191171646, 0.114183485507965, 0.113952249288559, 0.113722123205662, 0.113489173352718, 0.113255672156811, 0.113022163510323, 0.112787529826164, 0.112556278705597, 0.112323336303234, 0.112088143825531, 0.111852943897247, 0.111616611480713, 0.111379727721214, 0.11114340275526, 0.110905945301056, 0.110670745372772, 0.110433295369148, 0.110194712877274, 0.109956130385399, 0.109716415405273, 0.109478399157524, 0.10923869907856, 0.108997292816639, 0.108755886554718, 0.108515046536922, 0.108273640275002, 0.108032234013081, 0.10779083520174, 0.107547171413898, 0.107304081320763, 0.107059866189957, 0.106814503669739, 0.106572546064854, 0.106323808431625, 0.106081277132034, 0.105835929512978, 0.105588316917419, 0.105341836810112, 0.10509479790926, 0.104847192764282, 0.104599580168724, 0.104351408779621, 0.104100987315178, 0.103851675987244, 0.103602387011051, 0.103350825607777, 0.103103794157505, 0.10285110026598, 0.102598421275616, 0.102346867322922, 0.102094747126102, 0.101842068135738, 0.101587124168873, 0.101335003972054, 0.101082876324654, 0.100826814770699, 0.100571870803833, 0.100316375494003, 0.100061997771263, 0.0998053699731827, 0.0995476096868515, 0.0992898494005203, 0.0990337878465652, 0.0987754538655281, 0.0985165759921074, 0.0982605069875717, 0.0979999229311943, 0.0977393463253975, 0.0974798947572708, 0.0972181856632233, 0.096958726644516, 0.0966953337192535, 0.0965509414672852, 0.0963377431035042, 0.0961239784955978, 0.0959124639630318, 0.0957015156745911, 0.0954900160431862, 0.0952796339988708, 0.0950703844428062, 0.0948616862297058, 0.0946541279554367, 0.0944493860006332, 0.0942435190081596, 0.0940382033586502, 0.0938345938920975, 0.0936326831579208, 0.0934296324849129, 0.0932282730937004, 0.0930274799466133, 0.0928272530436516, 0.0926292762160301, 0.0924324244260788, 0.0922350212931633, 0.092038169503212, 0.0918430238962173, 0.0916484296321869, 0.0914555490016937, 0.0912632122635841, 0.0910703092813492, 0.0908791124820709, 0.0906890258193016, 0.0905012115836143, 0.0903128236532211, 0.0901244431734085, 0.0899383127689362, 0.0897521823644638, 0.0895666107535362, 0.0893833115696907, 0.0892000049352646, 0.0890166983008385, 0.0888356417417526, 0.0886562913656235, 0.0884763598442078, 0.0882975682616234, 0.0881193354725838, 0.0879416614770889, 0.0877651274204254, 0.0875902771949768, 0.0874148681759834, 0.0872422680258751, 0.0870691165328026, 0.0868970900774002, 0.0867267474532127, 0.0865558534860611, 0.0863860845565796, 0.0862174332141876, 0.0860493630170822, 0.0858829766511917, 0.0857165828347206, 0.0855530202388763, 0.0853883251547813, 0.0852247551083565, 0.0850623175501823, 0.0849009975790977, 0.0847402587532997, 0.0845795124769211, 0.0844198986887932, 0.0842613950371742, 0.0841062963008881, 0.0839494988322258, 0.0837932601571083, 0.0836387202143669, 0.0835030972957611, 0.0833801403641701, 0.0832577422261238, 0.0831336602568626, 0.0830112621188164, 0.0828860476613045, 0.0827636495232582, 0.0826418250799179, 0.0825188681483269, 0.0823953449726105, 0.0822718217968941, 0.082148864865303, 0.0820264667272568, 0.081902951002121, 0.0817805454134941, 0.0816559121012688, 0.0815335065126419, 0.0814099907875061, 0.0812881588935852, 0.0811646357178688, 0.0810416787862778, 0.0809175968170166, 0.0807951986789703, 0.0806716829538345, 0.0805492773652077, 0.0804263204336166, 0.0803016796708107, 0.0801792815327644, 0.0800568908452988, 0.0799333676695824, 0.0798104107379913, 0.0796868875622749, 0.0795633643865585, 0.0794409736990929, 0.0793185755610466, 0.0791950523853302, 0.079070970416069, 0.0789485722780228, 0.078825056552887, 0.0787032172083855, 0.0785797089338303, 0.0784561783075333, 0.0783326625823975, 0.0782091319561005, 0.0780873075127602, 0.0779643505811691, 0.0778397023677826, 0.0777172967791557, 0.0775937885046005, 0.0774708241224289, 0.0773473009467125, 0.0772254765033722, 0.0771013796329498, 0.0769784227013588, 0.0768554732203484, 0.0767336413264275, 0.0766089931130409, 0.0764860287308693, 0.0763630717992783, 0.0762401148676872, 0.0761160328984261, 0.0759947672486305, 0.0758718103170395, 0.0757471546530724, 0.0756247639656067, 0.0755006745457649, 0.0753782764077187, 0.0752553269267082, 0.0751323699951172, 0.0750094056129456, 0.0748858898878098, 0.074765183031559, 0.0746117755770683, 0.0744538456201553, 0.0742992982268333, 0.0741425007581711, 0.0739851370453835, 0.073825515806675, 0.0736664608120918, 0.0735068395733833, 0.0733438357710838, 0.0731830969452858, 0.0730206519365311, 0.0728548243641853, 0.0726912617683411, 0.0725260004401207, 0.0723584741353989, 0.072191521525383, 0.072023443877697, 0.0718536749482155, 0.071683906018734, 0.0715141370892525, 0.0713420957326889, 0.0711689442396164, 0.0709963515400887, 0.0708231925964355, 0.0706477835774422, 0.0704706832766533, 0.0702958330512047, 0.0701164677739143, 0.06993767619133, 0.069758877158165, 0.0695783868432045, 0.0693979039788246, 0.0692151561379433, 0.0690335407853127, 0.0688496679067612, 0.0686641037464142, 0.0684796646237373, 0.068293534219265, 0.0681057125329971, 0.0679184570908546, 0.0677283778786659, 0.0675399973988533, 0.0673487931489944, 0.0671564564108849, 0.0669658184051514, 0.0667717903852463, 0.0665777698159218, 0.0663831755518913, 0.0661874562501907, 0.0659900456666946, 0.0657932013273239, 0.0655952319502831, 0.0653961300849915, 0.0651953369379044, 0.064995102584362, 0.0647920519113541, 0.0645901337265968, 0.0643876492977142, 0.0641828998923302, 0.0639764741063118, 0.063771165907383, 0.063564732670784, 0.0633554756641388, 0.0631473511457443, 0.0629386603832245, 0.0627277120947838, 0.0625167712569237, 0.0623052567243576, 0.0620903633534908, 0.0618771649897099, 0.0616639629006386, 0.0614640675485134, 0.0612034909427166, 0.060941219329834, 0.0606812052428722, 0.0604223161935806, 0.0601622983813286, 0.0599062331020832, 0.0596467778086662, 0.0593878962099552, 0.0591312609612942, 0.0588723756372929, 0.0586163066327572, 0.0583602376282215, 0.0581030435860157, 0.0578486695885658, 0.0575920380651951, 0.0573393553495407, 0.0570844151079655, 0.0568311661481857, 0.0565784834325314, 0.0563224144279957, 0.0560719892382622, 0.0558209978044033, 0.0555671863257885, 0.0553173273801804, 0.0550657734274864, 0.0548153407871723, 0.0545666068792343, 0.0543167479336262, 0.054069135338068, 0.0538175813853741, 0.0535705387592316, 0.053322933614254, 0.0530753247439861, 0.0528299771249294, 0.0525812394917011, 0.0523364543914795, 0.0520911030471325, 0.0518457517027855, 0.0516015253961086, 0.0513556115329266, 0.0511130802333355, 0.0508694238960743, 0.0506257638335228, 0.0503843612968922, 0.0501401424407959, 0.0498998649418354, 0.0496612787246704, 0.0494176261126995, 0.0491773523390293, 0.0489359460771084, 0.0486967973411083, 0.048458781093359, 0.0482190698385239, 0.0479821786284447, 0.0477419048547745, 0.0475061424076557, 0.0472686849534512, 0.0470323599874973, 0.0467977225780487, 0.0465597100555897, 0.0463256351649761, 0.0460926927626133, 0.0458563677966595, 0.0456245541572571, 0.0453871004283428, 0.0451564118266106, 0.0449234694242477, 0.0446905307471752, 0.044460404664278, 0.0442263334989548, 0.0439319163560867, 0.0437649637460709, 0.0435963198542595, 0.0434316210448742, 0.0432669296860695, 0.04310392588377, 0.0429397933185101, 0.0427801758050919, 0.0426228120923042, 0.0424620658159256, 0.0423069596290588, 0.0421529822051525, 0.041996743530035, 0.0418455824255943, 0.0416921712458134, 0.0415427051484585, 0.0413932390511036, 0.0412437692284584, 0.0410999469459057, 0.0409544259309769, 0.0408100336790085, 0.0406695902347565, 0.0405274592339993, 0.0403870157897472, 0.0402482636272907, 0.0401106476783752, 0.0399741530418396, 0.0398399159312248, 0.0397062376141548, 0.0395742543041706, 0.0394434034824371, 0.0393148027360439, 0.0391856469213963, 0.0390598699450493, 0.0389323979616165, 0.038808312267065, 0.0386870466172695, 0.0385640859603882, 0.038443386554718, 0.0383226834237576, 0.0382064953446388, 0.0380903072655201, 0.0379741191864014, 0.0378601849079132, 0.0377468205988407, 0.0376357026398182, 0.0375262834131718, 0.0374174229800701, 0.0373096950352192, 0.0372014045715332, 0.0370987504720688, 0.0369955375790596, 0.0368923172354698, 0.0367902256548405, 0.0366909578442574, 0.0365922525525093, 0.0364958122372627, 0.0363993607461452, 0.0363051667809486, 0.0362098477780819, 0.0361190363764763, 0.0360299199819565, 0.0359385535120964, 0.0358511283993721, 0.0357625782489777, 0.0356785356998444, 0.0355944968760014, 0.035509891808033, 0.035429235547781, 0.0353480167686939, 0.0352696180343628, 0.0351895242929459, 0.0351150743663311, 0.0350530333817005, 0.0349909886717796, 0.0349300764501095, 0.0348680317401886, 0.0348071157932281, 0.0347450748085976, 0.0346841588616371, 0.0346221141517162, 0.0345600731670856, 0.0344980321824551, 0.0344371162354946, 0.0343762002885342, 0.0343141593039036, 0.0342532433569431, 0.0341912023723125, 0.0341291576623917, 0.0340671129524708, 0.0340073294937611, 0.0339452885091305, 0.0338832437992096, 0.0338223278522491, 0.0337602868676186, 0.0336982421576977, 0.0336373299360275, 0.0335764139890671, 0.0335143730044365, 0.0334523282945156, 0.0333914160728455, 0.0333293713629246, 0.0332673266530037, 0.0332064144313335, 0.0331454984843731, 0.0330834537744522, 0.0330214127898216, 0.0329605005681515, 0.0328984558582306, 0.0328364148736, 0.0327754989266396, 0.0327145829796791, 0.0326525419950485, 0.0325904972851276, 0.0325284525752068, 0.0324675403535366, 0.0324054956436157, 0.0323445796966553, 0.0322836674749851, 0.0322216264903545, 0.0321595817804337, 0.0320975407958031, 0.0320366248488426, 0.0319757126271725, 0.0319136679172516, 0.031851626932621, 0.0317907109856606, 0.0317286662757397, 0.0316666252911091, 0.0316057130694389, 0.0315447933971882, 0.0314827524125576, 0.031420711427927, 0.0313597954809666, 0.031297754496336, 0.0312357097864151, 0.0311747938394547, 0.0311138797551394, 0.0310507118701935, 0.0309897940605879, 0.0309288799762726, 0.0308668371289968, 0.0308047942817211, 0.0307592228055, 0.0306356996297836, 0.030511612072587, 0.030388655140996, 0.03026626072824, 0.030143303796649, 0.0300186518579721, 0.0298968236893415, 0.0297733023762703, 0.0296497773379087, 0.0295273847877979, 0.0294038634747267, 0.0292809046804905, 0.0291579458862543, 0.0290349889546633, 0.0289109032601118, 0.0287890732288361, 0.0286661144345999, 0.0285420287400484, 0.0284190699458122, 0.0282972417771816, 0.0281708985567093, 0.0280485060065985, 0.0279272384941578, 0.0278042815625668, 0.0276801940053701, 0.027556674554944, 0.0274348426610231, 0.0273113213479519, 0.0271883625537157, 0.0270654056221247, 0.0269413217902184, 0.0268189255148172, 0.0266965311020613, 0.0265718828886747, 0.0264489222317934, 0.026327658444643, 0.0262024439871311, 0.0260800495743752, 0.025957090780139, 0.0258335713297129, 0.0257100500166416, 0.0255870912224054, 0.0254646968096495, 0.0253417380154133, 0.0252176523208618, 0.0250952579081059, 0.024972865357995, 0.0248493421822786, 0.0247258227318525, 0.0246028639376163, 0.0244799070060253, 0.0243563838303089, 0.0242328606545925, 0.0241099037230015, 0.0239869467914104, 0.0238639879971743, 0.0237410292029381, 0.0236180741339922, 0.023495115339756, 0.0233721546828747, 0.0232480689883232, 0.0231251139193773, 0.0230027195066214, 0.0228803250938654, 0.0227556750178337, 0.0226332824677229, 0.0225103236734867, 0.022385673597455, 0.0222632810473442, 0.0221414510160685, 0.0220179297029972, 0.0218944866210222, 0.0218031145632267, 0.0217139981687069, 0.0216260086745024, 0.0215357653796673, 0.0214477740228176, 0.0213609132915735, 0.0212751813232899, 0.0211894493550062, 0.0211071018129587, 0.0210236255079508, 0.0209401492029428, 0.0208577997982502, 0.020778838545084, 0.0206987448036671, 0.0206186529248953, 0.0205408148467541, 0.0204629804939032, 0.0203862711787224, 0.0203118212521076, 0.0202362406998873, 0.0201629176735878, 0.0200907215476036, 0.0200185254216194, 0.0199463292956352, 0.0198763906955719, 0.0198064502328634, 0.0197376385331154, 0.0196699555963278, 0.0196022726595402, 0.0195368453860283, 0.0194714181125164, 0.0194071177393198, 0.0193439461290836, 0.0192807745188475, 0.0192187316715717, 0.0191578157246113, 0.0190980304032564, 0.0190404988825321, 0.0189807116985321, 0.018923182040453, 0.0188656505197287, 0.0188103746622801, 0.0187562294304371, 0.0187020804733038, 0.0186490621417761, 0.0185960438102484, 0.0185452811419964, 0.0184956472367048, 0.0184448827058077, 0.0183963775634766, 0.0183478705585003, 0.018299363553524, 0.0182531122118235, 0.0182091183960438, 0.0181639958173037, 0.0181211307644844, 0.0180771369487047, 0.0180353987962008, 0.0179947875440121, 0.0179541781544685, 0.0179158244282007, 0.0178763419389725, 0.0178379882127047, 0.0178007632493973, 0.0177657939493656, 0.0177319496870041, 0.017695851624012, 0.0176631398499012, 0.0176315549761057, 0.0175988394767046, 0.017537796869874, 0.0175225678831339, 0.0175084657967091, 0.0174938030540943, 0.0174802653491497, 0.0174672920256853, 0.0174543205648661, 0.0174419097602367, 0.0174300670623779, 0.0174193494021893, 0.0174080692231655, 0.0173962246626616, 0.0173866357654333, 0.0173770468682051, 0.017367459833622, 0.017358435317874, 0.0173505377024412, 0.0173420775681734, 0.0173341799527407, 0.0173274129629135, 0.0173200815916061, 0.0173144415020943, 0.0173087995499372, 0.0173025969415903, 0.0172980837523937, 0.0172924418002367, 0.0172884948551655, 0.0172851104289293, 0.0172817260026932, 0.0172794703394175, 0.0172760859131813, 0.0172743946313858, 0.0172732658684254, 0.0172721389681101, 0.0172704458236694, 0.0172704458236694, 0.0172698814421892, 0.0172710102051497, 0.0172727014869452, 0.0172738302499056, 0.0172755215317011, 0.0172772146761417, 0.0172805991023779, 0.017283983528614, 0.017287366092205, 0.0172907505184412, 0.0172952637076378, 0.0173009037971497, 0.0173054151237011, 0.017311055213213, 0.0173178240656853, 0.0173240285366774, 0.0173307973891497, 0.0173386931419373, 0.01734659075737, 0.0173550490289927, 0.0173635110259056, 0.0173725355416536, 0.0173826869577169, 0.0173917133361101, 0.0174024291336536, 0.0174137093126774, 0.0174249894917011, 0.0174362696707249, 0.0174481142312288, 0.0174616519361734, 0.017475189641118, 0.0174881611019373, 0.0175016988068819, 0.0175157990306616, 0.0175304636359215, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175816621631384, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175841748714447, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175864323973656, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175840463489294, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175884310156107, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0175863020122051, 0.0176450908184052, 0.0176586247980595, 0.0176744200289249, 0.0176879558712244, 0.0177014917135239, 0.0177161600440741, 0.0177285671234131, 0.0177421011030674, 0.0177533831447363, 0.0177646651864052, 0.0177759453654289, 0.0177872236818075, 0.017797376960516, 0.0178075321018696, 0.0178176835179329, 0.0178255792707205, 0.0178346037864685, 0.0178425014019012, 0.0178515259176493, 0.0178582929074764, 0.0178639329969883, 0.0178729575127363, 0.0178774707019329, 0.0178842376917601, 0.0178887527436018, 0.0178943909704685, 0.0178989041596651, 0.0179011598229408, 0.017904544249177, 0.0179090555757284, 0.0179113112390041, 0.0179135669022799, 0.0179158225655556, 0.017916951328516, 0.017916951328516, 0.017916951328516, 0.0179192088544369, 0.0179180800914764, 0.017916951328516, 0.0179146956652403, 0.0179146956652403, 0.0179124381393194, 0.0179090555757284, 0.017907926812768, 0.0179034154862165, 0.0178989041596651, 0.0178943909704685, 0.0178910084068775, 0.0178853664547205, 0.0178797263652086, 0.0178729575127363, 0.0178684443235397, 0.0178605485707521, 0.0178526528179646, 0.0178470145910978, 0.0178379882127047, 0.0178289618343115, 0.0178199391812086, 0.017812043428421, 0.0178007632493973, 0.0177906099706888, 0.0177793279290199, 0.0177691765129566, 0.017757898196578, 0.0177443586289883, 0.017734207212925, 0.0177206713706255, 0.0177060049027205, 0.0176924671977758, 0.0176800601184368, 0.0176653955131769, 0.0176484733819962, 0.0175198744982481, 0.0174905471503735, 0.0174589604139328, 0.0174251198768616, 0.0173912774771452, 0.0173551794141531, 0.017319081351161, 0.0172807276248932, 0.0172446295619011, 0.0172062758356333, 0.0171656664460897, 0.0171250551939011, 0.0170867014676332, 0.0170415788888931, 0.0169987119734287, 0.0169535893946886, 0.0169129800051451, 0.0168656017631292, 0.0168182235211134, 0.0167708452790976, 0.0167234670370817, 0.0166760869324207, 0.0166241973638535, 0.016572305932641, 0.0165226720273495, 0.0164685267955065, 0.0164143778383732, 0.0163624882698059, 0.0163083411753178, 0.0162496827542782, 0.0161932799965143, 0.016139131039381, 0.0160782169550657, 0.0160173028707504, 0.0159586425870657, 0.0158999841660261, 0.0158368125557899, 0.0157713852822781, 0.0157104693353176, 0.0156450420618057, 0.0155796147882938, 0.0155119309201837, 0.0154442479833961, 0.0153788207098842, 0.0153088811784983, 0.0152411982417107, 0.0151690011844039, 0.0150968059897423, 0.0150246107950807, 0.0149524137377739, 0.0148779628798366, 0.0148035101592541, 0.014726803638041, 0.0146500943228602, 0.0145733878016472, 0.0144944228231907, 0.0144177153706551, 0.0143364956602454, 0.0142530184239149, 0.014174054376781, 0.0140905771404505, 0.0140071017667651, 0.0139236263930798, 0.0138356368988752, 0.0137521615251899, 0.0136641729623079, 0.0135761834681034, 0.0134904505684972, 0.0133979497477412, 0.0133077055215836, 0.0132174612954259, 0.013003034517169, 0.0128789488226175, 0.0127548640593886, 0.0126330349594355, 0.0125089501962066, 0.0123848645016551, 0.0122607778757811, 0.0121412053704262, 0.0120171206071973, 0.0118930339813232, 0.0117689492180943, 0.0116471191868186, 0.0115241622552276, 0.0113989496603608, 0.0112782483920455, 0.0111552905291319, 0.0110323326662183, 0.0109082479029894, 0.0107864188030362, 0.0106623331084847, 0.0105382474139333, 0.0104164183139801, 0.0102945892140269, 0.0101705035194755, 0.010046417824924, 0.0099223330616951, 0.00980163179337978, 0.00967641826719046, 0.00955571606755257, 0.00943050347268581, 0.0093098022043705, 0.00918458867818117, 0.00906162988394499, 0.00893754512071609, 0.00881458818912506, 0.00869163032621145, 0.0085698002949357, 0.00844571553170681, 0.00832388550043106, 0.00819980073720217, 0.0080757150426507, 0.00795162934809923, 0.00782980024814606, 0.00770797021687031, 0.00758388498798013, 0.00746205542236567, 0.00733909802511334, 0.00721388449892402, 0.00708979880437255, 0.00696909707039595, 0.00684613967314363, 0.00672205397859216, 0.0065979678183794, 0.00647613871842623, 0.00635318085551262, 0.00622909562662244, 0.00610613822937012, 0.00598205206915736, 0.00586022296920419, 0.00573726557195187, 0.00561205158010125, 0.00549134938046336, 0.00536726415157318, 0.00524205062538385, 0.00511909276247025, 0.00499951932579279, 0.00487543409690261, 0.00475134793668985, 0.00462726224213839, 0.00450543267652392, 0.00438247481361032, 0.00425726128742099, 0.00424030981957912, 0.00414893822744489, 0.00405756663531065, 0.00396732334047556, 0.00387820811010897, 0.00379134877584875, 0.00370448967441916, 0.00361763057298958, 0.00353415543213487, 0.00344842416234314, 0.00336494902148843, 0.00328373000957072, 0.003200254868716, 0.00311903585679829, 0.00303894514217973, 0.00296111009083688, 0.00288214720785618, 0.00280656828545034, 0.00272873346693814, 0.0026531545445323, 0.0025775758549571, 0.00250199693255126, 0.00242980243638158, 0.00235986383631825, 0.00228766887448728, 0.00221773027442396, 0.00214666360989213, 0.00207785330712795, 0.00200904277153313, 0.00194248824845999, 0.00187931780237705, 0.00181163521483541, 0.00174620887264609, 0.00168303854297847, 0.00161986821331084, 0.00155895389616489, 0.00149691163096577, 0.00143825344275683, 0.00137846719007939, 0.00131868093740195, 0.00126115093007684, 0.00120587681885809, 0.00114947464317083, 0.0010942006483674, 0.00103892665356398, 0.000987036735750735, 0.000934018695261329, 0.000881000712979585, 0.000832494930364192, 0.000781733135227114, 0.000732099171727896, 0.00068246538285166, 0.000637343677226454, 0.000589965959079564, 0.00054597231792286, 0.000500850612297654, 0.000456856971140951, 0.00041399136534892, 0.000369997724192217, 0.000329388247337192, 0.000291034841211513, 0.0002515533415135, 0.000212071870919317, 0.000173718464793637, 0.000136493079480715, 9.92676941677928e-05, 6.54264295008034e-05, 3.38412573910318e-05, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14, 1.75872127462524e-14   }, 
   { 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.00324364029802382, 0.000291785749141127, 0.000822735601104796, 0.00137039076071233, 0.00193586479872465, 0.00251887948252261, 0.00311859953217208, 0.00373613834381104, 0.00437093945220113, 0.00502244615927339, 0.00569177092984319, 0.00637863716110587, 0.00708220805972815, 0.00780331995338202, 0.00854141544550657, 0.00929760839790106, 0.0100707849487662, 0.0108606675639749, 0.0116686457768083, 0.0124930515885353, 0.0133355557918549, 0.0141950426623225, 0.0150715131312609, 0.0159660819917917, 0.0168779119849205, 0.0178061705082655, 0.018752247095108, 0.0197153054177761, 0.0206964649260044, 0.0216946043074131, 0.0227097291499376, 0.0237426739186049, 0.0247923228889704, 0.025859234854579, 0.0269439648836851, 0.0280456785112619, 0.0291652102023363, 0.0303014479577541, 0.0314549505710602, 0.0326259918510914, 0.0338148511946201, 0.0350201390683651, 0.0362429656088352, 0.0374830551445484, 0.0387409627437592, 0.0400158539414406, 0.041307732462883, 0.0426171496510506, 0.0439441055059433, 0.0452880449593067, 0.0466498024761677, 0.0480279885232449, 0.0494239963591099, 0.0508375428617001, 0.0522680729627609, 0.053716141730547, 0.055181197822094, 0.0566635131835938, 0.0581633746623993, 0.059680487960577, 0.0612151511013508, 0.0627667903900146, 0.0643354207277298, 0.0659221410751343, 0.0675261244177818, 0.0691465437412262, 0.0707853361964226, 0.0724405497312546, 0.0741133019328117, 0.0758038759231567, 0.0775108858942986, 0.0792359784245491, 0.0809777826070786, 0.0827371329069138, 0.0845140144228935, 0.0863078907132149, 0.0881192982196808, 0.0899482518434525, 0.091851070523262, 0.093891903758049, 0.0959449112415314, 0.098010241985321, 0.100087821483612, 0.102177172899246, 0.104279108345509, 0.106393441557884, 0.108519606292248, 0.110657945275307, 0.112808763980865, 0.114971674978733, 0.117146760225296, 0.119334191083908, 0.121533714234829, 0.123745493590832, 0.125969395041466, 0.12820565700531, 0.130453705787659, 0.132714495062828, 0.13498717546463, 0.13727231323719, 0.139569640159607, 0.141879081726074, 0.14420048892498, 0.146534711122513, 0.148880198597908, 0.151238709688187, 0.153609380125999, 0.155991837382317, 0.158386811614037, 0.160793840885162, 0.163213059306145, 0.165644645690918, 0.168088272213936, 0.170544028282166, 0.173012226819992, 0.175492331385612, 0.177985191345215, 0.180489718914032, 0.18300673365593, 0.185536116361618, 0.188077464699745, 0.19063101708889, 0.193196997046471, 0.195774585008621, 0.198364928364754, 0.200967535376549, 0.203582063317299, 0.206208974123001, 0.20884770154953, 0.21149905025959, 0.214162766933441, 0.216838270425797, 0.219526439905167, 0.222226142883301, 0.224938362836838, 0.227663055062294, 0.230399757623672, 0.233148828148842, 0.235910043120384, 0.238683193922043, 0.241468876600266, 0.244266450405121, 0.247076496481895, 0.249898642301559, 0.252732813358307, 0.255579620599747, 0.258438676595688, 0.261309385299683, 0.26419273018837, 0.267087817192078, 0.269830495119095, 0.272564589977264, 0.275305479764938, 0.278053373098373, 0.280808508396149, 0.283570408821106, 0.286339610815048, 0.289115607738495, 0.29189857840538, 0.294688701629639, 0.297485649585724, 0.300289958715439, 0.303101122379303, 0.305918961763382, 0.308744251728058, 0.311576336622238, 0.314415335655212, 0.317261695861816, 0.320115178823471, 0.322975277900696, 0.32584223151207, 0.328716605901718, 0.331597834825516, 0.334485918283463, 0.337381333112717, 0.340283751487732, 0.343192905187607, 0.346109092235565, 0.349032640457153, 0.351963043212891, 0.354900121688843, 0.357844561338425, 0.360796242952347, 0.363754391670227, 0.366719752550125, 0.369692146778107, 0.372671544551849, 0.375657826662064, 0.378651529550552, 0.381652235984802, 0.384659588336945, 0.387673765420914, 0.390695631504059, 0.393724024295807, 0.396759361028671, 0.399801939725876, 0.402851641178131, 0.405908286571503, 0.408972054719925, 0.412042617797852, 0.415120154619217, 0.418204516172409, 0.421296387910843, 0.424394935369492, 0.427500277757645, 0.430613309144974, 0.433732867240906, 0.436859995126724, 0.439993351697922, 0.443134367465973, 0.446282029151917, 0.449436515569687, 0.452598452568054, 0.455767303705215, 0.458942949771881, 0.462125718593597, 0.465315610170364, 0.468512624502182, 0.47171625494957, 0.474927127361298, 0.478145241737366, 0.481377929449081, 0.48460990190506, 0.487848728895187, 0.491094648838043, 0.494346857070923, 0.497606128454208, 0.500872194766998, 0.504145324230194, 0.507424533367157, 0.510711193084717, 0.514004647731781, 0.517304599285126, 0.520611584186554, 0.523925423622131, 0.527246177196503, 0.530573129653931, 0.5339075922966, 0.537248492240906, 0.540596008300781, 0.543950378894806, 0.547311961650848, 0.550680160522461, 0.554054796695709, 0.557436764240265, 0.560825288295746, 0.564220607280731, 0.56762284040451, 0.571031868457794, 0.574447393417358, 0.57787024974823, 0.581299424171448, 0.584735989570618, 0.588178694248199, 0.591628611087799, 0.595085144042969, 0.598548352718353, 0.602018713951111, 0.605495810508728, 0.608979821205139, 0.612470269203186, 0.615967810153961, 0.619472146034241, 0.622983157634735, 0.626500725746155, 0.630025565624237, 0.633557319641113, 0.637095093727112, 0.640640258789062, 0.644192337989807, 0.647750735282898, 0.651316165924072, 0.654888689517975, 0.658467710018158, 0.662053644657135, 0.665646374225616, 0.669246137142181, 0.672852039337158, 0.676465392112732, 0.680085301399231, 0.683712065219879, 0.687345266342163, 0.690985679626465, 0.694633007049561, 0.698286592960358, 0.701947689056396, 0.705615043640137, 0.709289371967316, 0.712970614433289, 0.7166588306427, 0.720353424549103, 0.724054992198944, 0.727768659591675, 0.731770396232605, 0.735770463943481, 0.739768862724304, 0.743765890598297, 0.74776166677475, 0.751754939556122, 0.755747199058533, 0.759738445281982, 0.763726651668549, 0.767714500427246, 0.771700739860535, 0.775685250759125, 0.779667377471924, 0.783648788928986, 0.787629008293152, 0.791606366634369, 0.795583188533783, 0.799558341503143, 0.80353170633316, 0.807503283023834, 0.811473548412323, 0.815442442893982, 0.819409489631653, 0.823374807834625, 0.827339172363281, 0.831301629543304, 0.835262060165405, 0.839221298694611, 0.843179404735565, 0.847135365009308, 0.851089835166931, 0.85504275560379, 0.858994543552399, 0.86294412612915, 0.866892218589783, 0.870839238166809, 0.874784290790558, 0.878727614879608, 0.882669925689697, 0.886610209941864, 0.89054936170578, 0.894486308097839, 0.898422479629517, 0.902356326580048, 0.906289219856262, 0.910219728946686, 0.914149284362793, 0.918077409267426, 0.922003567218781, 0.925928473472595, 0.929851353168488, 0.933773458003998, 0.937692999839783, 0.941611349582672, 0.945528507232666, 0.949444055557251, 0.953357577323914, 0.957269549369812, 0.96118038892746, 0.96508914232254, 0.968996584415436, 0.972902774810791, 0.976807355880737, 0.980709612369537, 0.984610736370087, 0.98851090669632, 0.99240905046463, 0.99630481004715, 1.00020015239716, 1.00409364700317, 1.00798511505127, 1.01172542572021, 1.01540577411652, 1.01907646656036, 1.0227313041687, 1.02637422084808, 1.03000485897064, 1.0336240530014, 1.03722810745239, 1.04082119464874, 1.04440116882324, 1.04796886444092, 1.05152308940887, 1.05506491661072, 1.05859482288361, 1.06211149692535, 1.06561577320099, 1.06910717487335, 1.07258582115173, 1.07605230808258, 1.07950568199158, 1.08294725418091, 1.08637511730194, 1.08979070186615, 1.09319317340851, 1.09658455848694, 1.09996211528778, 1.10332679748535, 1.10667848587036, 1.11001896858215, 1.11334645748138, 1.11666059494019, 1.11996304988861, 1.12325143814087, 1.12652850151062, 1.12979221343994, 1.13304388523102, 1.1362818479538, 1.13950800895691, 1.14272153377533, 1.14592230319977, 1.14911019802094, 1.15228521823883, 1.15544676780701, 1.15859818458557, 1.16173601150513, 1.16485965251923, 1.16797244548798, 1.17107200622559, 1.1741589307785, 1.17723298072815, 1.18029463291168, 1.18334352970123, 1.18637943267822, 1.18940281867981, 1.19241499900818, 1.19541251659393, 1.19839823246002, 1.20137178897858, 1.20433151721954, 1.20727968215942, 1.21021485328674, 1.21313774585724, 1.21604692935944, 1.21894419193268, 1.22182810306549, 1.22470116615295, 1.22756004333496, 1.23040640354156, 1.23323965072632, 1.23606181144714, 1.2388699054718, 1.24165022373199, 1.24431478977203, 1.24696469306946, 1.24960029125214, 1.25221955776215, 1.25482511520386, 1.25741505622864, 1.25998985767365, 1.26254975795746, 1.26509499549866, 1.26762425899506, 1.27013945579529, 1.27264022827148, 1.27512431144714, 1.27759504318237, 1.28005003929138, 1.28248965740204, 1.28491473197937, 1.28732359409332, 1.28971970081329, 1.29210031032562, 1.29446399211884, 1.2968133687973, 1.2991498708725, 1.30146908760071, 1.30377340316772, 1.30606520175934, 1.3083393573761, 1.31059908866882, 1.31284427642822, 1.31507444381714, 1.31728959083557, 1.31948912143707, 1.32167303562164, 1.32384419441223, 1.32599914073944, 1.32813847064972, 1.33026349544525, 1.33237445354462, 1.33446872234344, 1.33654856681824, 1.33861434459686, 1.34066474437714, 1.34269881248474, 1.34471797943115, 1.34672427177429, 1.34871399402618, 1.35068845748901, 1.35264849662781, 1.35459458827972, 1.35652315616608, 1.35843801498413, 1.36033964157104, 1.36222338676453, 1.36409330368042, 1.36594879627228, 1.36778914928436, 1.36961388587952, 1.37142419815063, 1.37321782112122, 1.37499904632568, 1.37676429748535, 1.37851333618164, 1.3802490234375, 1.38196921348572, 1.38367307186127, 1.38536369800568, 1.38703918457031, 1.38869857788086, 1.39034354686737, 1.39197444915771, 1.39358818531036, 1.39516794681549, 1.39672160148621, 1.39826238155365, 1.39979088306427, 1.40130436420441, 1.40280556678772, 1.4042946100235, 1.40576863288879, 1.40723192691803, 1.40868091583252, 1.41011536121368, 1.41153860092163, 1.41294741630554, 1.41434288024902, 1.41572713851929, 1.41709756851196, 1.41845345497131, 1.41979706287384, 1.42112791538239, 1.42244446277618, 1.42374849319458, 1.42504036426544, 1.42631721496582, 1.42758190631866, 1.42883408069611, 1.43007266521454, 1.43129754066467, 1.43251049518585, 1.43370831012726, 1.43489372730255, 1.43606758117676, 1.43722629547119, 1.43837285041809, 1.43950498104095, 1.44062578678131, 1.44173216819763, 1.44282591342926, 1.44390618801117, 1.4449747800827, 1.44602835178375, 1.44706964492798, 1.44809818267822, 1.44911158084869, 1.45011389255524, 1.4511022567749, 1.45207786560059, 1.45303952693939, 1.45398890972137, 1.45492398738861, 1.45584714412689, 1.45675766468048, 1.45765292644501, 1.45853614807129, 1.4594064950943, 1.46026349067688, 1.46110761165619, 1.46193742752075, 1.46275532245636, 1.46355998516083, 1.46435022354126, 1.46512913703918, 1.46589481830597, 1.46664547920227, 1.46738433837891, 1.4681099653244, 1.46882104873657, 1.46952092647552, 1.47020697593689, 1.47087967395782, 1.47153949737549, 1.47218656539917, 1.47285604476929, 1.47340190410614, 1.4739396572113, 1.47446954250336, 1.47499072551727, 1.47550392150879, 1.47600817680359, 1.47650492191315, 1.47699356079102, 1.47747349739075, 1.47794604301453, 1.47841084003448, 1.47886645793915, 1.47931432723999, 1.47975420951843, 1.480184674263, 1.48060858249664, 1.48102390766144, 1.48142957687378, 1.48182928562164, 1.48222076892853, 1.48260295391083, 1.48297619819641, 1.48334324359894, 1.48370099067688, 1.48405003547668, 1.48439264297485, 1.48472535610199, 1.48505055904388, 1.4853675365448, 1.48567759990692, 1.48597729206085, 1.4862699508667, 1.4865550994873, 1.48683094978333, 1.48709964752197, 1.48735952377319, 1.48761057853699, 1.48785412311554, 1.48809015750885, 1.48831641674042, 1.48853659629822, 1.4887478351593, 1.4889509677887, 1.48914432525635, 1.48933124542236, 1.48950958251953, 1.48967945575714, 1.48984122276306, 1.48999607563019, 1.49014115333557, 1.49027872085571, 1.49040830135345, 1.49052822589874, 1.49064218997955, 1.49074685573578, 1.49084413051605, 1.49093210697174, 1.49101281166077, 1.49108529090881, 1.49114859104156, 1.4912041425705, 1.49125242233276, 1.49129140377045, 1.49132323265076, 1.49134683609009, 1.4913614988327, 1.49136829376221, 1.49136698246002, 1.49135768413544, 1.49133884906769, 1.49131417274475, 1.4914186000824, 1.49158024787903, 1.49173450469971, 1.49188327789307, 1.49202489852905, 1.49216043949127, 1.49228847026825, 1.49241042137146, 1.49252593517303, 1.49263381958008, 1.49273645877838, 1.49283158779144, 1.49292016029358, 1.49300241470337, 1.49307787418365, 1.49314725399017, 1.49320900440216, 1.49326479434967, 1.49331426620483, 1.49335622787476, 1.49339234828949, 1.49342143535614, 1.49344396591187, 1.49346005916595, 1.49346947669983, 1.49347257614136, 1.49346816539764, 1.49345803260803, 1.49344086647034, 1.49341678619385, 1.49338674545288, 1.49334990978241, 1.49330604076385, 1.49325597286224, 1.49319922924042, 1.49313592910767, 1.49306571483612, 1.49298918247223, 1.49290645122528, 1.4928160905838, 1.49272000789642, 1.49261689186096, 1.49250650405884, 1.49239039421082, 1.492267370224, 1.4921373128891, 1.49200177192688, 1.491858959198, 1.49170994758606, 1.49155354499817, 1.49139130115509, 1.49122202396393, 1.49104583263397, 1.49086272716522, 1.49067425727844, 1.49047827720642, 1.49027621746063, 1.49006748199463, 1.48985147476196, 1.48962914943695, 1.48940050601959, 1.48916506767273, 1.48892283439636, 1.48867475986481, 1.4884192943573, 1.48815727233887, 1.4878888130188, 1.48761415481567, 1.48733186721802, 1.48704385757446, 1.4867490530014, 1.48638272285461, 1.48608875274658, 1.48578453063965, 1.48546731472015, 1.48513972759247, 1.4848016500473, 1.48445188999176, 1.48408997058868, 1.48371720314026, 1.48333370685577, 1.48293840885162, 1.48253297805786, 1.48211574554443, 1.48168742656708, 1.48124647140503, 1.48079538345337, 1.48033320903778, 1.47985970973969, 1.4793746471405, 1.47887897491455, 1.47837209701538, 1.47785222530365, 1.47732317447662, 1.47678136825562, 1.47622931003571, 1.47566628456116, 1.47509050369263, 1.47450423240662, 1.47390782833099, 1.47329914569855, 1.47267949581146, 1.47204875946045, 1.47140502929688, 1.47075200080872, 1.47008645534515, 1.46941125392914, 1.46872472763062, 1.46802568435669, 1.46731615066528, 1.46659481525421, 1.46586179733276, 1.46511852741241, 1.46436440944672, 1.46359813213348, 1.46282136440277, 1.46203172206879, 1.46123266220093, 1.46042108535767, 1.45959889888763, 1.45876634120941, 1.45792055130005, 1.45706450939178, 1.45619797706604, 1.45531952381134, 1.45442998409271, 1.45352959632874, 1.45261752605438, 1.45169281959534, 1.45075869560242, 1.44981241226196, 1.44885540008545, 1.44788730144501, 1.44690811634064, 1.44591581821442, 1.44491469860077, 1.44390034675598, 1.44287598133087, 1.44184029102325, 1.44079339504242, 1.43973529338837, 1.43866443634033, 1.43764925003052, 1.43620002269745, 1.43474352359772, 1.43328142166138, 1.43181347846985, 1.43033730983734, 1.42885649204254, 1.42736911773682, 1.42587530612946, 1.42437529563904, 1.42286789417267, 1.42135488986969, 1.41983664035797, 1.4183109998703, 1.41677927970886, 1.41524136066437, 1.41369581222534, 1.41214525699615, 1.41058826446533, 1.40902483463287, 1.40745615959167, 1.40587949752808, 1.40429747104645, 1.40270841121674, 1.40111339092255, 1.39951205253601, 1.39790511131287, 1.39629089832306, 1.39467108249664, 1.39304351806641, 1.39141070842743, 1.38977217674255, 1.38812589645386, 1.38647472858429, 1.38481545448303, 1.38315105438232, 1.3814811706543, 1.37980389595032, 1.37812054157257, 1.37643098831177, 1.37473547458649, 1.37303149700165, 1.37132346630096, 1.36960852146149, 1.36788773536682, 1.36616015434265, 1.36442577838898, 1.36268472671509, 1.3609391450882, 1.35918569564819, 1.35742688179016, 1.35566127300262, 1.35388958454132, 1.35211038589478, 1.35032570362091, 1.34853577613831, 1.3467390537262, 1.34493494033813, 1.34312582015991, 1.3413097858429, 1.33948624134064, 1.33765816688538, 1.33582317829132, 1.33398151397705, 1.33213436603546, 1.33027935028076, 1.32841897010803, 1.3265528678894, 1.32468008995056, 1.32280123233795, 1.32091593742371, 1.31902265548706, 1.31731832027435, 1.31559455394745, 1.31387317180634, 1.31215691566467, 1.3104442358017, 1.30873584747314, 1.30703103542328, 1.30533087253571, 1.30363404750824, 1.30194103717804, 1.30025315284729, 1.29856812953949, 1.29688775539398, 1.29521131515503, 1.29353880882263, 1.2918701171875, 1.2902055978775, 1.28854477405548, 1.2868880033493, 1.28523504734039, 1.28358674049377, 1.28194224834442, 1.28030145168304, 1.27866530418396, 1.27703201770782, 1.27540373802185, 1.2737785577774, 1.2721586227417, 1.2705409526825, 1.26892864704132, 1.26732075214386, 1.26571547985077, 1.26411378383636, 1.26251816749573, 1.26092457771301, 1.25933587551117, 1.25775229930878, 1.25617003440857, 1.25459289550781, 1.25302124023438, 1.25145208835602, 1.2498881816864, 1.24832677841187, 1.24677073955536, 1.24521744251251, 1.24366807937622, 1.2421236038208, 1.24058282375336, 1.23904573917389, 1.23751258850098, 1.23598408699036, 1.23445880413055, 1.23293936252594, 1.2314213514328, 1.22990918159485, 1.22840011119843, 1.22689473628998, 1.22539401054382, 1.22389698028564, 1.22240459918976, 1.22091543674469, 1.2194299697876, 1.21794903278351, 1.21647226810455, 1.21499872207642, 1.21353125572205, 1.21206593513489, 1.21060538291931, 1.2091475725174, 1.20769476890564, 1.20624613761902, 1.20482432842255, 1.20372629165649, 1.20262849330902, 1.20153057575226, 1.20043277740479, 1.1993350982666, 1.19823610782623, 1.19713854789734, 1.19604015350342, 1.19494116306305, 1.19384336471558, 1.19274425506592, 1.19164502620697, 1.19054663181305, 1.18944716453552, 1.18834757804871, 1.18724954128265, 1.18614947795868, 1.18505024909973, 1.18395113945007, 1.18285155296326, 1.18175184726715, 1.18065118789673, 1.17955148220062, 1.17845189571381, 1.17735135555267, 1.17625081539154, 1.17515158653259, 1.17405009269714, 1.17295122146606, 1.17184996604919, 1.17074882984161, 1.16964745521545, 1.16854679584503, 1.16744685173035, 1.16634511947632, 1.16524410247803, 1.16414225101471, 1.16304183006287, 1.16193997859955, 1.1608384847641, 1.15973615646362, 1.15863525867462, 1.1575334072113, 1.15643131732941, 1.15532851219177, 1.1542261838913, 1.15312469005585, 1.15202236175537, 1.15091967582703, 1.14981687068939, 1.1487147808075, 1.14761185646057, 1.14650928974152, 1.14540612697601, 1.14430356025696, 1.14320051670074, 1.14209616184235, 1.14099252223969, 1.13988888263702, 1.13878691196442, 1.13768267631531, 1.1365784406662, 1.13547480106354, 1.13437163829803, 1.13326740264893, 1.13216328620911, 1.13105845451355, 1.12995421886444, 1.12885057926178, 1.12774574756622, 1.12664043903351, 1.12522971630096, 1.12383306026459, 1.12242960929871, 1.12102079391479, 1.11960697174072, 1.11818587779999, 1.11675930023193, 1.11532652378082, 1.11388850212097, 1.11244463920593, 1.11099410057068, 1.10953736305237, 1.1080756187439, 1.10660803318024, 1.10513389110565, 1.10365426540375, 1.1021683216095, 1.10067713260651, 1.09917950630188, 1.0976756811142, 1.09616613388062, 1.09465062618256, 1.09313058853149, 1.09160304069519, 1.09006929397583, 1.08853018283844, 1.0869859457016, 1.0854344367981, 1.08387804031372, 1.08231520652771, 1.08074688911438, 1.07917201519012, 1.07759177684784, 1.0760053396225, 1.0744127035141, 1.07281529903412, 1.07121062278748, 1.06960082054138, 1.06798481941223, 1.06636297702789, 1.06473481655121, 1.06310105323792, 1.06146204471588, 1.05981588363647, 1.05816411972046, 1.0565071105957, 1.05484402179718, 1.05317425727844, 1.05149924755096, 1.04981780052185, 1.04813122749329, 1.04643785953522, 1.04473912715912, 1.04303443431854, 1.04132378101349, 1.03960752487183, 1.03788471221924, 1.03615665435791, 1.03442227840424, 1.03268218040466, 1.03093540668488, 1.02918267250061, 1.02742493152618, 1.02566146850586, 1.0238915681839, 1.02211558818817, 1.02033388614655, 1.01854658126831, 1.01675319671631, 1.0149530172348, 1.01314747333527, 1.01132607460022, 1.00940883159637, 1.00748991966248, 1.00556993484497, 1.00365054607391, 1.00172877311707, 0.999807417392731, 0.99788498878479, 0.995961308479309, 0.994037508964539, 0.99211186170578, 0.99018520116806, 0.988258004188538, 0.98633074760437, 0.984402716159821, 0.982473015785217, 0.980542659759521, 0.978611290454865, 0.976679563522339, 0.974746525287628, 0.972812592983246, 0.970878720283508, 0.968943119049072, 0.967007339000702, 0.965070247650146, 0.96313214302063, 0.961192965507507, 0.959253787994385, 0.957314014434814, 0.955372095108032, 0.95343029499054, 0.951487183570862, 0.949544131755829, 0.947599351406097, 0.945653438568115, 0.943707883358002, 0.941760301589966, 0.93981271982193, 0.937863230705261, 0.935913980007172, 0.933963894844055, 0.932012498378754, 0.930060207843781, 0.928107082843781, 0.926153182983398, 0.924199163913727, 0.922243356704712, 0.920286536216736, 0.918329536914825, 0.916371941566467, 0.914413213729858, 0.912452816963196, 0.910492300987244, 0.908530712127686, 0.906568765640259, 0.904605865478516, 0.902641654014587, 0.90067732334137, 0.898711383342743, 0.896745204925537, 0.894777297973633, 0.892809450626373, 0.890840947628021, 0.888870894908905, 0.886900246143341, 0.884928405284882, 0.882956385612488, 0.880982637405396, 0.879008948802948, 0.877034306526184, 0.875058114528656, 0.873082518577576, 0.8711878657341, 0.869346976280212, 0.867509067058563, 0.865674614906311, 0.86384516954422, 0.862017512321472, 0.860194444656372, 0.858373284339905, 0.856557428836823, 0.854743480682373, 0.852933168411255, 0.851128160953522, 0.849325180053711, 0.8475261926651, 0.845730543136597, 0.843938827514648, 0.842150509357452, 0.840364694595337, 0.838583409786224, 0.836804747581482, 0.835030734539032, 0.833260238170624, 0.831491887569427, 0.8297278881073, 0.827967405319214, 0.826210558414459, 0.824457347393036, 0.822707176208496, 0.820960640907288, 0.819217145442963, 0.817478477954865, 0.815742194652557, 0.814010381698608, 0.812281668186188, 0.810555219650269, 0.808833718299866, 0.807115018367767, 0.805399656295776, 0.803688228130341, 0.801981747150421, 0.8002769947052, 0.79857611656189, 0.796878576278687, 0.795184671878815, 0.793495237827301, 0.791808247566223, 0.790124416351318, 0.788444340229034, 0.786768853664398, 0.785096108913422, 0.783426105976105, 0.781760275363922, 0.780098676681519, 0.778439521789551, 0.776784360408783, 0.775132775306702, 0.773484766483307, 0.771839618682861, 0.770198583602905, 0.768561184406281, 0.76692658662796, 0.765296101570129, 0.763668715953827, 0.762045562267303, 0.760425686836243, 0.75880891084671, 0.757196605205536, 0.75558614730835, 0.75398051738739, 0.752378463745117, 0.750778675079346, 0.749193727970123, 0.747569441795349, 0.745950102806091, 0.744334697723389, 0.742726504802704, 0.741122305393219, 0.739522993564606, 0.737929880619049, 0.736341834068298, 0.734757542610168, 0.733180046081543, 0.731606423854828, 0.730037748813629, 0.728476345539093, 0.726917743682861, 0.725365221500397, 0.723818361759186, 0.722276389598846, 0.720738410949707, 0.719207644462585, 0.717680752277374, 0.716158926486969, 0.714643239974976, 0.713131368160248, 0.711624562740326, 0.71012556552887, 0.70862877368927, 0.707138657569885, 0.705653011798859, 0.704173445701599, 0.702697813510895, 0.701228260993958, 0.699763774871826, 0.698303759098053, 0.69685035943985, 0.695399284362793, 0.693955898284912, 0.692517042160034, 0.691083192825317, 0.689654290676117, 0.688231527805328, 0.686812162399292, 0.685400009155273, 0.683992266654968, 0.682588458061218, 0.681190192699432, 0.679799258708954, 0.67841100692749, 0.677028954029083, 0.675651907920837, 0.674279808998108, 0.672914445400238, 0.671552419662476, 0.670195937156677, 0.668843328952789, 0.667499125003815, 0.666157126426697, 0.664821267127991, 0.663490951061249, 0.662165105342865, 0.660844326019287, 0.659530162811279, 0.658219337463379, 0.65691465139389, 0.655615508556366, 0.654321372509003, 0.653032302856445, 0.651747703552246, 0.650468051433563, 0.649194538593292, 0.647925496101379, 0.646713078022003, 0.645521938800812, 0.644335329532623, 0.64315539598465, 0.641981542110443, 0.640815556049347, 0.639652252197266, 0.638497948646545, 0.637345850467682, 0.636202096939087, 0.635064482688904, 0.633932411670685, 0.63280588388443, 0.631685018539429, 0.630569636821747, 0.62946093082428, 0.628359496593475, 0.627262532711029, 0.626171112060547, 0.625085830688477, 0.62400609254837, 0.622933089733124, 0.621866166591644, 0.620804250240326, 0.619749009609222, 0.618699967861176, 0.617655873298645, 0.616616785526276, 0.61558610200882, 0.614559829235077, 0.613539695739746, 0.612525701522827, 0.611516118049622, 0.610513269901276, 0.60951817035675, 0.608527004718781, 0.607542514801025, 0.606564104557037, 0.605590164661407, 0.604622960090637, 0.603662371635437, 0.602706849575043, 0.601758062839508, 0.600815296173096, 0.599876463413239, 0.598945379257202, 0.598019897937775, 0.597100019454956, 0.596185743808746, 0.595279157161713, 0.59437483549118, 0.593478858470917, 0.592589020729065, 0.591705322265625, 0.590826034545898, 0.589955151081085, 0.589086472988129, 0.588225603103638, 0.587371945381165, 0.586522817611694, 0.585679709911346, 0.584842801094055, 0.584011435508728, 0.583185017108917, 0.582367062568665, 0.581552982330322, 0.580746114253998, 0.579944789409637, 0.579148471355438, 0.578356683254242, 0.57757431268692, 0.576795816421509, 0.576023519039154, 0.575336039066315, 0.574650645256042, 0.573966681957245, 0.573287010192871, 0.572608768939972, 0.571933627128601, 0.5712611079216, 0.570590674877167, 0.569921731948853, 0.56925642490387, 0.568593680858612, 0.567933022975922, 0.567274987697601, 0.566620051860809, 0.565966069698334, 0.565315127372742, 0.564667403697968, 0.564021706581116, 0.563378632068634, 0.562738120555878, 0.562099099159241, 0.561463177204132, 0.560829877853394, 0.560199201107025, 0.559571623802185, 0.558945536613464, 0.558321475982666, 0.557700574398041, 0.557082235813141, 0.556466460227966, 0.555852711200714, 0.555242240428925, 0.554632604122162, 0.55402672290802, 0.553423345088959, 0.552822530269623, 0.552223742008209, 0.551628232002258, 0.551033616065979, 0.550442576408386, 0.549853682518005, 0.549267888069153, 0.548684120178223, 0.548102915287018, 0.547523260116577, 0.54694676399231, 0.54637336730957, 0.545801997184753, 0.545233726501465, 0.544667601585388, 0.544102251529694, 0.543540716171265, 0.542981743812561, 0.542425870895386, 0.541872084140778, 0.541320323944092, 0.540770649909973, 0.540224015712738, 0.539679944515228, 0.539138615131378, 0.538599193096161, 0.538062989711761, 0.537527680397034, 0.536996066570282, 0.536466956138611, 0.535940587520599, 0.53541624546051, 0.534894347190857, 0.534373998641968, 0.533857405185699, 0.533337593078613, 0.532737851142883, 0.532137393951416, 0.531536221504211, 0.530933976173401, 0.530330955982208, 0.52972686290741, 0.529122114181519, 0.528516173362732, 0.527909815311432, 0.527302384376526, 0.526694178581238, 0.526084780693054, 0.525474607944489, 0.52486389875412, 0.524251878261566, 0.523639559745789, 0.523025989532471, 0.522411406040192, 0.52179628610611, 0.521180093288422, 0.520562827587128, 0.519945025444031, 0.519326329231262, 0.518706858158112, 0.518086194992065, 0.517464697360992, 0.516842663288116, 0.516219437122345, 0.515595316886902, 0.514970600605011, 0.514344811439514, 0.513718485832214, 0.513090670108795, 0.512462317943573, 0.511833369731903, 0.511203169822693, 0.51057231426239, 0.509940326213837, 0.509307563304901, 0.508674204349518, 0.508039653301239, 0.507404446601868, 0.50676828622818, 0.506131052970886, 0.50549328327179, 0.504854381084442, 0.504214942455292, 0.503574252128601, 0.502932727336884, 0.502290725708008, 0.501647353172302, 0.501003682613373, 0.500358521938324, 0.499712646007538, 0.499066174030304, 0.498418539762497, 0.49777016043663, 0.497121244668961, 0.496470838785172, 0.495820045471191, 0.495168119668961, 0.494515240192413, 0.493861764669418, 0.493207305669785, 0.492551952600479, 0.49189567565918, 0.491238474845886, 0.490580767393112, 0.489921808242798, 0.489261895418167, 0.48860165476799, 0.487953215837479, 0.487276405096054, 0.486598521471024, 0.485918760299683, 0.485238015651703, 0.484555304050446, 0.483871400356293, 0.483186364173889, 0.482499331235886, 0.481811463832855, 0.481121718883514, 0.480430275201797, 0.479737550020218, 0.479043751955032, 0.47834837436676, 0.477651178836823, 0.476953029632568, 0.476253241300583, 0.475551754236221, 0.474848985671997, 0.474144846200943, 0.473439246416092, 0.472732424736023, 0.472023725509644, 0.471313565969467, 0.470602065324783, 0.469889491796494, 0.469175040721893, 0.468459069728851, 0.467741996049881, 0.467023372650146, 0.466302812099457, 0.465581178665161, 0.464858531951904, 0.46413391828537, 0.463408201932907, 0.462680727243423, 0.461951643228531, 0.46122145652771, 0.460489839315414, 0.459756821393967, 0.459022134542465, 0.458285570144653, 0.457548409700394, 0.456809043884277, 0.456068634986877, 0.45532700419426, 0.454583346843719, 0.453838735818863, 0.453092664480209, 0.452344983816147, 0.45159575343132, 0.450844824314117, 0.450093120336533, 0.449339509010315, 0.448584884405136, 0.447828263044357, 0.447070419788361, 0.446311175823212, 0.445550113916397, 0.444788038730621, 0.444024443626404, 0.443259090185165, 0.44249302148819, 0.441724717617035, 0.440955281257629, 0.440184623003006, 0.439411997795105, 0.438638031482697, 0.43786284327507, 0.437086194753647, 0.436358064413071, 0.435576409101486, 0.434793531894684, 0.434008747339249, 0.433222383260727, 0.43243482708931, 0.431645214557648, 0.43085378408432, 0.430061310529709, 0.429267108440399, 0.428470969200134, 0.427673548460007, 0.426874786615372, 0.426073849201202, 0.42527174949646, 0.424467831850052, 0.423662304878235, 0.422855079174042, 0.42204624414444, 0.421236157417297, 0.420424312353134, 0.419610649347305, 0.418795824050903, 0.417979061603546, 0.417160630226135, 0.416340678930283, 0.415519446134567, 0.414696484804153, 0.413871645927429, 0.413045585155487, 0.412217676639557, 0.411388009786606, 0.410556733608246, 0.409724563360214, 0.408890128135681, 0.408053874969482, 0.407216966152191, 0.406377792358398, 0.405536949634552, 0.404695153236389, 0.403851121664047, 0.403005540370941, 0.402158588171005, 0.401309818029404, 0.40045952796936, 0.399607568979263, 0.398754358291626, 0.397899299860001, 0.397042602300644, 0.396184504032135, 0.395324617624283, 0.394463032484055, 0.393599778413773, 0.392735540866852, 0.391869246959686, 0.391001105308533, 0.390132039785385, 0.389260858297348, 0.388388156890869, 0.387513905763626, 0.386637717485428, 0.385760396718979, 0.384881287813187, 0.384000778198242, 0.383118450641632, 0.382234483957291, 0.381349086761475, 0.380462169647217, 0.379573464393616, 0.378683477640152, 0.377791404724121, 0.376898229122162, 0.375846326351166, 0.374833554029465, 0.373822182416916, 0.372812211513519, 0.37180432677269, 0.370798230171204, 0.369793564081192, 0.368790417909622, 0.367790728807449, 0.366791665554047, 0.365793764591217, 0.364797174930573, 0.363803207874298, 0.362810075283051, 0.361818879842758, 0.360830217599869, 0.359842389822006, 0.358856081962585, 0.357872277498245, 0.356889575719833, 0.355908572673798, 0.354929506778717, 0.353951126337051, 0.35297554731369, 0.352001786231995, 0.351029813289642, 0.350059360265732, 0.349091023206711, 0.348122656345367, 0.347157508134842, 0.346193224191666, 0.345231264829636, 0.344269901514053, 0.343311429023743, 0.342353373765945, 0.341398388147354, 0.340444535017014, 0.339492470026016, 0.338541805744171, 0.33759281039238, 0.33664533495903, 0.335700482130051, 0.334756791591644, 0.333814203739166, 0.332874000072479, 0.33193638920784, 0.330999076366425, 0.330064028501511, 0.329130619764328, 0.328198194503784, 0.32726839184761, 0.326339989900589, 0.325413256883621, 0.324487805366516, 0.323564559221268, 0.322642028331757, 0.321722537279129, 0.32080402970314, 0.319887310266495, 0.318972140550613, 0.318058907985687, 0.317146807909012, 0.316237062215805, 0.315329164266586, 0.314423710107803, 0.313518017530441, 0.312615364789963, 0.311713010072708, 0.310813724994659, 0.30991593003273, 0.309018701314926, 0.308130204677582, 0.307343393564224, 0.306562155485153, 0.305787593126297, 0.305017471313477, 0.304253488779068, 0.303495615720749, 0.302741080522537, 0.301993817090988, 0.301250964403152, 0.300514250993729, 0.299783706665039, 0.299057573080063, 0.298338145017624, 0.297622591257095, 0.296914845705032, 0.296210438013077, 0.295510470867157, 0.294818341732025, 0.294130623340607, 0.293447405099869, 0.292771369218826, 0.292100369930267, 0.291434943675995, 0.290773987770081, 0.290119677782059, 0.289470940828323, 0.288826674222946, 0.288188546895981, 0.287554860115051, 0.286928981542587, 0.286307007074356, 0.285689443349838, 0.285080790519714, 0.284474968910217, 0.28387525677681, 0.283280521631241, 0.282690823078156, 0.282107263803482, 0.281529247760773, 0.280956268310547, 0.280389964580536, 0.279827535152435, 0.279272377490997, 0.278720557689667, 0.278176516294479, 0.277636915445328, 0.277101248502731, 0.276573359966278, 0.276049375534058, 0.27553203701973, 0.275019228458405, 0.274513602256775, 0.274011880159378, 0.273515731096268, 0.273024022579193, 0.272540122270584, 0.272060126066208, 0.271587371826172, 0.27111741900444, 0.270655781030655, 0.270198076963425, 0.269744247198105, 0.269298195838928, 0.268856644630432, 0.268421739339828, 0.267991274595261, 0.267565876245499, 0.267146557569504, 0.266731709241867, 0.266325205564499, 0.26599445939064, 0.265776693820953, 0.26556122303009, 0.265345722436905, 0.265130788087845, 0.264919191598892, 0.264705896377563, 0.264497071504593, 0.264287710189819, 0.264082252979279, 0.263873964548111, 0.263669043779373, 0.263465255498886, 0.263262003660202, 0.263062655925751, 0.262862175703049, 0.262662261724472, 0.262465178966522, 0.262269139289856, 0.262074828147888, 0.261881023645401, 0.261688381433487, 0.261496812105179, 0.261306911706924, 0.261118710041046, 0.260932147502899, 0.2607461810112, 0.260560214519501, 0.260376423597336, 0.260196030139923, 0.260014474391937, 0.259833544492722, 0.259655863046646, 0.259477704763412, 0.259303957223892, 0.259128540754318, 0.258955359458923, 0.258782744407654, 0.258612364530563, 0.258443653583527, 0.258274346590042, 0.258108973503113, 0.257942467927933, 0.257777661085129, 0.257614493370056, 0.257453560829163, 0.257292628288269, 0.257133394479752, 0.256973564624786, 0.256818741559982, 0.256663382053375, 0.256508022546768, 0.256356030702591, 0.256202906370163, 0.256054222583771, 0.255903840065002, 0.255757391452789, 0.255610406398773, 0.25546395778656, 0.255320280790329, 0.255178302526474, 0.255036860704422, 0.254895985126495, 0.254756778478622, 0.254619240760803, 0.254482805728912, 0.254348069429398, 0.254214406013489, 0.25408074259758, 0.253949910402298, 0.253820151090622, 0.253690421581268, 0.253403663635254, 0.25313138961792, 0.252855777740479, 0.252575665712357, 0.252292782068253, 0.252005457878113, 0.251711994409561, 0.251415729522705, 0.251114517450333, 0.250811010599136, 0.250501990318298, 0.250189572572708, 0.24987331032753, 0.249551445245743, 0.249225676059723, 0.248897165060043, 0.248563051223755, 0.248226135969162, 0.24788424372673, 0.247537329792976, 0.247187063097954, 0.246833473443985, 0.246475979685783, 0.246112942695618, 0.245745971798897, 0.245375111699104, 0.245000377297401, 0.244622260332108, 0.244239702820778, 0.243851587176323, 0.243460118770599, 0.243064761161804, 0.242665514349937, 0.242261245846748, 0.241853088140488, 0.241440460085869, 0.241025060415268, 0.240604639053345, 0.240180894732475, 0.239752665162086, 0.239318907260895, 0.238882318139076, 0.238440752029419, 0.237997516989708, 0.237546473741531, 0.23709374666214, 0.236636027693748, 0.236174941062927, 0.235709443688393, 0.235239997506142, 0.234764456748962, 0.234286695718765, 0.233804479241371, 0.233318343758583, 0.232827767729759, 0.232332170009613, 0.23183436691761, 0.231330960988998, 0.230824813246727, 0.230312526226044, 0.229798525571823, 0.229278445243835, 0.22875502705574, 0.228226572275162, 0.227695360779762, 0.227159649133682, 0.226618975400925, 0.226073801517487, 0.225526452064514, 0.224973499774933, 0.224417209625244, 0.223918125033379, 0.223216488957405, 0.222510978579521, 0.221804901957512, 0.221097156405449, 0.220387727022171, 0.219676107168198, 0.218962207436562, 0.218248054385185, 0.2175302952528, 0.216812536120415, 0.216090857982635, 0.215370029211044, 0.214645579457283, 0.213920846581459, 0.213193327188492, 0.212464973330498, 0.211733311414719, 0.211001887917519, 0.210266575217247, 0.20953181385994, 0.208794549107552, 0.208054512739182, 0.207315042614937, 0.206571385264397, 0.205827161669731, 0.205080419778824, 0.204332858324051, 0.20358307659626, 0.20283217728138, 0.202078774571419, 0.201323971152306, 0.200566932559013, 0.199809357523918, 0.199048161506653, 0.198287785053253, 0.19752325117588, 0.196758702397346, 0.195993050932884, 0.195223763585091, 0.19445338845253, 0.193680763244629, 0.192907854914665, 0.192131623625755, 0.191354557871819, 0.190574407577515, 0.189795106649399, 0.189011916518211, 0.188227877020836, 0.187441617250443, 0.186654806137085, 0.185864359140396, 0.185073643922806, 0.184280708432198, 0.183486640453339, 0.182690650224686, 0.181892424821854, 0.181092798709869, 0.180290937423706, 0.179487973451614, 0.178682491183281, 0.177875638008118, 0.177067369222641, 0.176257729530334, 0.175445035099983, 0.17463231086731, 0.173816829919815, 0.172999933362007, 0.172180533409119, 0.171361148357391, 0.17053784430027, 0.169714003801346, 0.168969571590424, 0.168227866292, 0.16748920083046, 0.166752770543098, 0.166017457842827, 0.165286049246788, 0.164556860923767, 0.163828790187836, 0.16310378909111, 0.162381559610367, 0.161661833524704, 0.160942956805229, 0.160227686166763, 0.159514933824539, 0.158802732825279, 0.158094421029091, 0.157388344407082, 0.156683102250099, 0.155981212854385, 0.15528292953968, 0.154584631323814, 0.153889983892441, 0.153197810053825, 0.152507051825523, 0.151819080114365, 0.151134431362152, 0.150450348854065, 0.149769619107246, 0.14909166097641, 0.148416206240654, 0.147741317749023, 0.147070035338402, 0.146401271224022, 0.145733624696732, 0.145069032907486, 0.144407495856285, 0.143746256828308, 0.143088608980179, 0.142434045672417, 0.141780585050583, 0.141130208969116, 0.14048258960247, 0.139836370944977, 0.139191821217537, 0.138551458716393, 0.137912765145302, 0.137275174260139, 0.136641770601273, 0.136009752750397, 0.135378569364548, 0.134752124547958, 0.13412706553936, 0.133504778146744, 0.132883906364441, 0.132265523076057, 0.131650224328041, 0.131036296486855, 0.130425170063972, 0.129816547036171, 0.129209294915199, 0.128605961799622, 0.128003731369972, 0.127403736114502, 0.126807346940041, 0.126212924718857, 0.1256193369627, 0.125029355287552, 0.124442167580128, 0.123856097459793, 0.123272798955441, 0.122692294418812, 0.122011803090572, 0.121460512280464, 0.120912030339241, 0.120369106531143, 0.11982674151659, 0.119290500879288, 0.118755370378494, 0.118224695324898, 0.117697358131409, 0.117173932492733, 0.116653837263584, 0.116137087345123, 0.11562368273735, 0.115114167332649, 0.114606335759163, 0.11410403996706, 0.113604560494423, 0.113107852637768, 0.112615041434765, 0.112126708030701, 0.111638896167278, 0.11115724593401, 0.1106783375144, 0.110203914344311, 0.109730035066605, 0.10926228761673, 0.108796775341034, 0.108334600925446, 0.107876308262348, 0.107421927154064, 0.106968648731709, 0.106522053480148, 0.106077149510384, 0.105636119842529, 0.105197891592979, 0.104763552546501, 0.104331992566586, 0.103904880583286, 0.103481136262417, 0.103059597313404, 0.102643080055714, 0.102229908108711, 0.101818956434727, 0.101412460207939, 0.101009860634804, 0.100609488785267, 0.100211903452873, 0.0998193249106407, 0.0994300916790962, 0.0990425273776054, 0.0986610949039459, 0.0982818827033043, 0.0979054570198059, 0.0975323691964149, 0.0971642956137657, 0.0967984423041344, 0.0964359417557716, 0.0960773378610611, 0.0957226306200027, 0.0953701436519623, 0.0950215607881546, 0.0946763157844543, 0.0943349674344063, 0.0939964130520821, 0.0936623066663742, 0.0933304205536842, 0.0930035561323166, 0.0926783606410027, 0.0923576205968857, 0.0920396596193314, 0.0917267128825188, 0.0914154350757599, 0.0911783128976822, 0.0909124240279198, 0.0906507074832916, 0.0903920531272888, 0.0901359096169472, 0.0898817032575607, 0.0896319672465324, 0.0893830507993698, 0.0891383141279221, 0.0888958126306534, 0.0886558145284653, 0.0884183198213577, 0.088184729218483, 0.0879528000950813, 0.0877242237329483, 0.0874978601932526, 0.0872748419642448, 0.0870537757873535, 0.086836613714695, 0.0866205543279648, 0.0864097848534584, 0.0861992985010147, 0.0859929993748665, 0.085787795484066, 0.0855876132845879, 0.0853890925645828, 0.0851933658123016, 0.0850006937980652, 0.0848099812865257, 0.0846226066350937, 0.0844371765851974, 0.0842556431889534, 0.0840757861733437, 0.0839001014828682, 0.0837255269289017, 0.0835545733571053, 0.0833858475089073, 0.0832207500934601, 0.0830578729510307, 0.0828986167907715, 0.0827401950955391, 0.0825865045189857, 0.0824339315295219, 0.0822849720716476, 0.0821385234594345, 0.0819954127073288, 0.0818537026643753, 0.0817161574959755, 0.0815805643796921, 0.0814477652311325, 0.0813180133700371, 0.0811910629272461, 0.0810666009783745, 0.0809457674622536, 0.0808266028761864, 0.0807099416851997, 0.0805966258049011, 0.0804866477847099, 0.0803777873516083, 0.0802736580371857, 0.0801703631877899, 0.0800715237855911, 0.0799737945199013, 0.0798805207014084, 0.0797883719205856, 0.0797009468078613, 0.0796137973666191, 0.0795313939452171, 0.0794506445527077, 0.0793729573488235, 0.0792977884411812, 0.0792258679866791, 0.0791611969470978, 0.0790970921516418, 0.0790345221757889, 0.0789720863103867, 0.0789100006222725, 0.0788497254252434, 0.078789509832859, 0.078729934990406, 0.0786717385053635, 0.0786137580871582, 0.0785561203956604, 0.0785003080964088, 0.078444205224514, 0.0783892795443535, 0.0783357545733452, 0.0782819539308548, 0.078229121863842, 0.0781772658228874, 0.0781261101365089, 0.07807557284832, 0.0780261531472206, 0.0779771506786346, 0.0779287070035934, 0.0778815820813179, 0.0778345242142677, 0.077788382768631, 0.0777435526251793, 0.0776989385485649, 0.0776548087596893, 0.0776122137904167, 0.077569954097271, 0.0775277838110924, 0.077487550675869, 0.0774472504854202, 0.0774079263210297, 0.0773694887757301, 0.0773315578699112, 0.0772942453622818, 0.07725840061903, 0.0772225558757782, 0.0771874114871025, 0.0771539285778999, 0.0771201029419899, 0.0770875215530396, 0.0770555734634399, 0.0770242512226105, 0.0769937708973885, 0.0769646093249321, 0.0769352987408638, 0.0769069716334343, 0.0768801718950272, 0.0768528208136559, 0.0768267139792442, 0.0768020078539848, 0.0767772197723389, 0.0767534151673317, 0.0767307952046394, 0.0767085254192352, 0.0766865313053131, 0.0766661316156387, 0.0766458734869957, 0.0766265317797661, 0.0766083598136902, 0.0765902698040009, 0.0765732824802399, 0.0765570625662804, 0.0765412002801895, 0.0765262991189957, 0.0765125900506973, 0.0764992237091064, 0.0764858722686768, 0.0764434859156609, 0.0764006078243256, 0.0763571038842201, 0.0763130411505699, 0.0762684941291809, 0.0762229785323143, 0.0761769637465477, 0.0761304721236229, 0.0760829970240593, 0.0760351791977882, 0.0759865939617157, 0.0759375169873238, 0.0758877545595169, 0.0758373513817787, 0.0757862627506256, 0.0757346227765083, 0.0756823495030403, 0.0756293833255768, 0.0755760669708252, 0.0755217671394348, 0.0754669904708862, 0.0754115805029869, 0.0753553435206413, 0.075298473238945, 0.0752414688467979, 0.0751834139227867, 0.0751249492168427, 0.0750657171010971, 0.0750057101249695, 0.0749453008174896, 0.0748840421438217, 0.0748226568102837, 0.0747602134943008, 0.0746970847249031, 0.0746335387229919, 0.0745692923665047, 0.0745044201612473, 0.0744389891624451, 0.0743728652596474, 0.0743060410022736, 0.074238657951355, 0.0741706565022469, 0.0741018876433372, 0.0740324929356575, 0.0739629566669464, 0.0738923028111458, 0.073821172118187, 0.073749266564846, 0.0736767426133156, 0.0736037865281105, 0.0735300034284592, 0.073455810546875, 0.0733809173107147, 0.073305256664753, 0.0732291042804718, 0.0731522589921951, 0.0730747207999229, 0.0729965493083, 0.0729181095957756, 0.0728387609124184, 0.072758711874485, 0.0726779699325562, 0.0725968852639198, 0.0725150257349014, 0.0724323987960815, 0.0723494365811348, 0.072265699505806, 0.0721812695264816, 0.0720962733030319, 0.0720107406377792, 0.0719242170453072, 0.0718574002385139, 0.0717673227190971, 0.0716758668422699, 0.0715828761458397, 0.071489043533802, 0.0713942423462868, 0.0712980479001999, 0.0712011605501175, 0.0711034312844276, 0.0710040330886841, 0.0709035247564316, 0.0708017572760582, 0.0706991627812386, 0.0705955922603607, 0.0704910457134247, 0.0703849643468857, 0.0702780485153198, 0.0701698809862137, 0.0700604617595673, 0.069950208067894, 0.0698391199111938, 0.0697263553738594, 0.0696126222610474, 0.0694980472326279, 0.0693820863962173, 0.0692651495337486, 0.0691469609737396, 0.0690279379487038, 0.0689079314470291, 0.0687862634658813, 0.0686639025807381, 0.0685399994254112, 0.0684151276946068, 0.0682895630598068, 0.068162739276886, 0.0680347979068756, 0.0679056122899055, 0.0677751749753952, 0.0676437541842461, 0.0675112381577492, 0.067377857863903, 0.0672431141138077, 0.0671075209975243, 0.0669705346226692, 0.066832572221756, 0.0666933655738831, 0.0665536001324654, 0.0664120241999626, 0.0662697479128838, 0.0661264955997467, 0.0659815818071365, 0.0658359602093697, 0.0656891018152237, 0.065541110932827, 0.0653921589255333, 0.0652416720986366, 0.0650909096002579, 0.0649383291602135, 0.0647849217057228, 0.0646299794316292, 0.06447434425354, 0.0643177330493927, 0.0641597211360931, 0.0640008822083473, 0.0638406500220299, 0.0636793076992035, 0.0635173991322517, 0.0633536949753761, 0.0631892830133438, 0.0630236268043518, 0.062856987118721, 0.062648743391037, 0.0624332427978516, 0.0622171945869923, 0.0620014108717442, 0.0617850795388222, 0.0615687482059002, 0.0613526925444603, 0.0611355192959309, 0.060918353497982, 0.0607014633715153, 0.0604842975735664, 0.0602665655314922, 0.0600482858717442, 0.059831116348505, 0.0596125572919846, 0.0593942776322365, 0.0591757111251354, 0.058957152068615, 0.0587380342185497, 0.0585189126431942, 0.0582997985184193, 0.0580804012715816, 0.0578610002994537, 0.0576413348317146, 0.0574208274483681, 0.0572008639574051, 0.0569806396961212, 0.0567601323127747, 0.0565393380820751, 0.0563185513019562, 0.056096650660038, 0.0558755844831467, 0.0556539595127106, 0.0554326139390469, 0.0552107095718384, 0.054988257586956, 0.0547657944262028, 0.0545433312654495, 0.0543205961585045, 0.0540978610515594, 0.053874846547842, 0.0536518320441246, 0.0534276999533176, 0.0532041266560555, 0.0529802739620209, 0.0527561493217945, 0.0525317378342152, 0.0523078888654709, 0.0520826503634453, 0.0518576800823212, 0.0516335517168045, 0.0514083094894886, 0.0511825084686279, 0.0509569868445396, 0.0507314689457417, 0.0505051054060459, 0.0502793081104755, 0.0500529557466507, 0.0498257614672184, 0.0495991259813309, 0.0493722148239613, 0.0491455756127834, 0.048918105661869, 0.0486906357109547, 0.0484626069664955, 0.0482348576188087, 0.0480068325996399, 0.0477785244584084, 0.0475499406456947, 0.0473219156265259, 0.0470922142267227, 0.0468630753457546, 0.0466714315116405, 0.0464698523283005, 0.0462688319385052, 0.0460711494088173, 0.0458729192614555, 0.0456766299903393, 0.0454822927713394, 0.0452887900173664, 0.0450958423316479, 0.0449051223695278, 0.0447155199944973, 0.0445273071527481, 0.0443402081727982, 0.0441545024514198, 0.0439704656600952, 0.0437875427305698, 0.0436054542660713, 0.0434258729219437, 0.0432465746998787, 0.0430686622858047, 0.0428915843367577, 0.0427170135080814, 0.04254300147295, 0.0423698239028454, 0.0421999841928482, 0.0420298725366592, 0.0418608710169792, 0.0416935384273529, 0.0415284372866154, 0.0413633324205875, 0.0411999002099037, 0.0410386957228184, 0.0408777631819248, 0.0407185070216656, 0.0405603647232056, 0.0404036156833172, 0.0402482561767101, 0.0400942899286747, 0.0399417132139206, 0.039790254086256, 0.0396401844918728, 0.0394915081560612, 0.0393439456820488, 0.0391980521380901, 0.0390529930591583, 0.0389093309640884, 0.038767334073782, 0.0386267341673374, 0.038486685603857, 0.0383488684892654, 0.0382121652364731, 0.0380765721201897, 0.0379420928657055, 0.0378098450601101, 0.0376775972545147, 0.0375470146536827, 0.0374183841049671, 0.0372900329530239, 0.0371641889214516, 0.0370394550263882, 0.0369155555963516, 0.0367927737534046, 0.0366719402372837, 0.0365522168576717, 0.0364336110651493, 0.0363166742026806, 0.0362002961337566, 0.0360867008566856, 0.0359736606478691, 0.035860899835825, 0.0357514806091785, 0.0356845557689667, 0.035618469119072, 0.0355534888803959, 0.035489659756422, 0.0354261845350266, 0.0353641286492348, 0.0353030152618885, 0.0352424904704094, 0.0351828783750534, 0.0351241640746593, 0.0350666008889675, 0.0350096970796585, 0.0349536649882793, 0.034898467361927, 0.0348453968763351, 0.0347920395433903, 0.0347395576536655, 0.0346885360777378, 0.0346381440758705, 0.034588448703289, 0.0345397926867008, 0.0344923548400402, 0.03444554656744, 0.0343998856842518, 0.0343554802238941, 0.0343110710382462, 0.0342677757143974, 0.0342255271971226, 0.0341846309602261, 0.0341443307697773, 0.0341046899557114, 0.0340667553246021, 0.0340289585292339, 0.0339922048151493, 0.0339561179280281, 0.033921767026186, 0.0338877625763416, 0.0338544249534607, 0.0338227488100529, 0.0337914302945137, 0.0337613262236118, 0.0337317772209644, 0.0337036922574043, 0.0336759202182293, 0.0336490869522095, 0.0336231924593449, 0.0335989706218243, 0.0335747487843037, 0.0335514657199383, 0.0335302725434303, 0.0335087962448597, 0.0334884747862816, 0.0334690548479557, 0.0334511287510395, 0.033433485776186, 0.033416498452425, 0.033401221036911, 0.0333862565457821, 0.0333728566765785, 0.0333597026765347, 0.0333479382097721, 0.0333365947008133, 0.0333264656364918, 0.0333174541592598, 0.0333090648055077, 0.033301267772913, 0.0332946553826332, 0.0332897827029228, 0.0332849770784378, 0.0332810468971729, 0.0332782976329327, 0.0332765206694603, 0.0332246646285057, 0.0332052446901798, 0.0331858620047569, 0.0331659130752087, 0.0331461131572723, 0.0331258252263069, 0.0331056080758572, 0.0330851413309574, 0.0330643951892853, 0.0330437570810318, 0.0330224931240082, 0.0330011621117592, 0.0329799652099609, 0.0329583548009396, 0.0329367779195309, 0.0329146757721901, 0.0328928902745247, 0.0328703746199608, 0.0328477844595909, 0.0328252650797367, 0.0328023992478848, 0.0327796414494514, 0.0327562913298607, 0.032732866704464, 0.0327094085514545, 0.0326856374740601, 0.0326618663966656, 0.0326378531754017, 0.0326135270297527, 0.0325892679393291, 0.0325644575059414, 0.0325398817658424, 0.0325146540999413, 0.0324897691607475, 0.0324644334614277, 0.0324388556182384, 0.0324132367968559, 0.0323872081935406, 0.0323611348867416, 0.0323350727558136, 0.0323085188865662, 0.0322821699082851, 0.0322553366422653, 0.0322285369038582, 0.0322013944387436, 0.032173864543438, 0.0321465469896793, 0.032118946313858, 0.032091312110424, 0.0320631936192513, 0.0320348292589188, 0.03200663626194, 0.0319780260324478, 0.0319494567811489, 0.031920500099659, 0.0318913012742996, 0.0318621695041656, 0.0318325906991959, 0.0318032130599022, 0.0317731760442257, 0.0317434221506119, 0.0317132510244846, 0.0316828340291977, 0.0316524840891361, 0.0316216833889484, 0.0315906368196011, 0.0315597727894783, 0.0315285548567772, 0.0314973369240761, 0.0314656943082809, 0.0314340628683567, 0.0313810929656029, 0.0313251279294491, 0.0312695130705833, 0.0312136225402355, 0.0311576575040817, 0.0311014167964458, 0.0310449656099081, 0.0309888646006584, 0.0309322066605091, 0.0308759659528732, 0.0308190286159515, 0.0307621601969004, 0.0307052228599787, 0.0306479372084141, 0.0305910687893629, 0.0305336434394121, 0.0304762180894613, 0.0304188672453165, 0.030361095443368, 0.0303035266697407, 0.0302455481141806, 0.0301874969154596, 0.0301295146346092, 0.0300715360790491, 0.0300133433192968, 0.0299548041075468, 0.0298963356763124, 0.0298376586288214, 0.0297786332666874, 0.029720026999712, 0.0296611376106739, 0.0296021159738302, 0.0295428782701492, 0.0294832997024059, 0.0294239930808544, 0.029364550486207, 0.0293051768094301, 0.0292452462017536, 0.0291852466762066, 0.0291253868490458, 0.0290651060640812, 0.0290052499622107, 0.0289446897804737, 0.0288842059671879, 0.0288238544017076, 0.0287629514932632, 0.0287024639546871, 0.0286414194852114, 0.0285803060978651, 0.0285193994641304, 0.0284582171589136, 0.0283968932926655, 0.0283353626728058, 0.028274042531848, 0.0282120238989592, 0.0281502828001976, 0.028088541701436, 0.0280265230685472, 0.0279645752161741, 0.0279022771865129, 0.0278396345674992, 0.0277774073183537, 0.0277147609740496, 0.0276521854102612, 0.0275894720107317, 0.027526268735528, 0.0274634137749672, 0.0274002142250538, 0.0273370817303658, 0.0272735338658094, 0.0272100511938334, 0.0271657817065716, 0.0271114893257618, 0.0270572658628225, 0.0270035322755575, 0.0269502140581608, 0.0268971752375364, 0.0268447604030371, 0.0267926249653101, 0.0267404206097126, 0.0266891233623028, 0.0266376156359911, 0.0265872180461884, 0.0265368279069662, 0.0264867078512907, 0.0264370813965797, 0.0263875909149647, 0.0263385195285082, 0.0262901429086924, 0.0262417681515217, 0.026193879544735, 0.026146687567234, 0.0260993558913469, 0.0260524414479733, 0.0260061528533697, 0.0259600728750229, 0.0259144157171249, 0.025869170203805, 0.0258241351693869, 0.0257793795317411, 0.0257353894412518, 0.0256913267076015, 0.0256478954106569, 0.0256046690046787, 0.0255620703101158, 0.0255196113139391, 0.0254776403307915, 0.0254358053207397, 0.0253945998847485, 0.0253536719828844, 0.0253130905330181, 0.0252729989588261, 0.0252329055219889, 0.0251933708786964, 0.0251543913036585, 0.0251154806464911, 0.0250773392617702, 0.0250391252338886, 0.0250014662742615, 0.024964090436697, 0.0249274075031281, 0.0248906556516886, 0.0248544607311487, 0.0248184762895107, 0.0247831866145134, 0.0247481036931276, 0.024713022634387, 0.0246789157390594, 0.0246449485421181, 0.0246111210435629, 0.0245779193937778, 0.02454499527812, 0.0245121419429779, 0.0244801212102175, 0.0244481060653925, 0.0244166422635317, 0.0243858080357313, 0.0243549011647701, 0.0243244841694832, 0.0242946241050959, 0.0242647640407085, 0.0242356676608324, 0.0242067817598581, 0.0241865254938602, 0.0241726040840149, 0.024158788844943, 0.0241449736058712, 0.0241317469626665, 0.0241183489561081, 0.0241054017096758, 0.0240926276892424, 0.0240797530859709, 0.024067360907793, 0.0240552164614201, 0.0240427553653717, 0.0240310616791248, 0.0240194741636515, 0.0240077786147594, 0.0239962581545115, 0.0239851921796799, 0.0239740554243326, 0.0239634066820145, 0.0239525120705366, 0.0239421762526035, 0.0239321179687977, 0.0239216778427362, 0.0239118281751871, 0.0239022579044104, 0.0238926522433758, 0.0238833948969841, 0.0238742753863335, 0.0238650534301996, 0.0238565262407064, 0.0238479655236006, 0.0238392986357212, 0.0238312594592571, 0.0238230116665363, 0.0238152164965868, 0.0238075945526361, 0.0238000433892012, 0.0237928722053766, 0.0237858407199383, 0.023778673261404, 0.0237721651792526, 0.0237655863165855, 0.0237589050084352, 0.0237529184669256, 0.0237470380961895, 0.0237411558628082, 0.0237354822456837, 0.0237298458814621, 0.023724589496851, 0.0237196814268827, 0.0237146709114313, 0.0237100757658482, 0.0237057600170374, 0.0237012021243572, 0.0236969199031591, 0.0236930921673775, 0.023689229041338, 0.0236858539283276, 0.023682339116931, 0.0236789975315332, 0.0236761774867773, 0.0236730109900236, 0.0236704368144274, 0.0236681047827005, 0.0236656330525875, 0.0236636493355036, 0.0236618053168058, 0.0236599612981081, 0.0236584283411503, 0.0236571077257395, 0.023655854165554, 0.0236473716795444, 0.0236404463648796, 0.0236330665647984, 0.0236256532371044, 0.0236178580671549, 0.0236100275069475, 0.0236018151044846, 0.0235932879149914, 0.023584796115756, 0.0235758870840073, 0.0235667675733566, 0.0235572662204504, 0.0235477667301893, 0.0235381256788969, 0.0235279276967049, 0.023517731577158, 0.0235071871429682, 0.0234964676201344, 0.0234855394810438, 0.0234742984175682, 0.0234629865735769, 0.0234512239694595, 0.0234393551945686, 0.0234271734952927, 0.023414820432663, 0.0234023593366146, 0.0233894139528275, 0.0233763977885246, 0.0233630333095789, 0.0233496688306332, 0.0233358163386583, 0.0233218632638454, 0.0233076978474855, 0.0232931151986122, 0.0232785679399967, 0.0232635326683521, 0.0232484973967075, 0.023233151063323, 0.0232174191623926, 0.0232017580419779, 0.0231856442987919, 0.0231692530214787, 0.0231528952717781, 0.0231360513716936, 0.0231190677732229, 0.023101769387722, 0.0230843685567379, 0.0230666194111109, 0.023048834875226, 0.0230306331068277, 0.0230122935026884, 0.0229936391115189, 0.0229748450219631, 0.0229557380080223, 0.0229363534599543, 0.0229167938232422, 0.0228972006589174, 0.0228770151734352, 0.0228568986058235, 0.0228362958878279, 0.0228157974779606, 0.0227947421371937, 0.0227735470980406, 0.0227523166686296, 0.0227304622530937, 0.0227086413651705, 0.0226865410804749, 0.0226642321795225, 0.0226418189704418, 0.0226190593093634, 0.022595776244998, 0.0225725974887609, 0.022543653845787, 0.0225137919187546, 0.0224835854023695, 0.0224527511745691, 0.0224219150841236, 0.0223906617611647, 0.0223592687398195, 0.0223271809518337, 0.0222952328622341, 0.0222628675401211, 0.0222300831228495, 0.0221969522535801, 0.0221636816859245, 0.022129712626338, 0.0220958851277828, 0.0220614317804575, 0.0220270473510027, 0.0219919644296169, 0.0219567455351353, 0.021921107545495, 0.0218852590769529, 0.0218492057174444, 0.0218123849481344, 0.0217756330966949, 0.0217386726289988, 0.0217012949287891, 0.0216636378318071, 0.0216252859681845, 0.0215867944061756, 0.0215483028441668, 0.021509462967515, 0.0214698575437069, 0.0214303936809301, 0.0213905088603497, 0.0213502775877714, 0.0213097669184208, 0.0212686993181705, 0.0212276335805655, 0.0211861487478018, 0.0211443156003952, 0.0211025513708591, 0.0210598148405552, 0.0210170783102512, 0.0209739934653044, 0.0209309067577124, 0.0208872631192207, 0.0208429265767336, 0.0207988657057285, 0.020754249766469, 0.0207094233483076, 0.0206639710813761, 0.0206185895949602, 0.0205727200955153, 0.0205266419798136, 0.0204801447689533, 0.0204332303255796, 0.0203862488269806, 0.0203389171510935, 0.020291306078434, 0.0202432796359062, 0.0201947651803493, 0.0201461799442768, 0.020097317174077, 0.0200481079518795, 0.0199984777718782, 0.0199485011398792, 0.0198983866721392, 0.0198479928076267, 0.0197971109300852, 0.0197459515184164, 0.0196943748742342, 0.0196411367505789, 0.0195853486657143, 0.019529627636075, 0.0194738060235977, 0.0194177031517029, 0.0193615332245827, 0.01930539496243, 0.0192489810287952, 0.019192460924387, 0.0191358383744955, 0.0190791953355074, 0.0190225355327129, 0.0189655125141144, 0.0189084708690643, 0.0188514646142721, 0.0187941454350948, 0.0187366846948862, 0.0186791382730007, 0.0186217855662107, 0.0185639951378107, 0.0185061190277338, 0.0184483118355274, 0.018390191718936, 0.0183320362120867, 0.0182737242430449, 0.0182153265923262, 0.0181569792330265, 0.018098333850503, 0.0180395543575287, 0.0179808083921671, 0.0179218165576458, 0.0178627204149961, 0.0178034901618958, 0.0177443232387304, 0.0176848452538252, 0.0176253505051136, 0.017565855756402, 0.0175061002373695, 0.017446169629693, 0.0173862390220165, 0.0173261016607285, 0.0172659959644079, 0.01720573566854, 0.0171452648937702, 0.0170848313719034, 0.0170241873711348, 0.0169633533805609, 0.016902431845665, 0.0168415606021881, 0.0167803950607777, 0.0167192295193672, 0.0166580118238926, 0.0165966376662254, 0.0165351051837206, 0.0164733324199915, 0.0164115745574236, 0.016349783167243, 0.0162877812981606, 0.0162256248295307, 0.0161635726690292, 0.0161012038588524, 0.0160386823117733, 0.0159761421382427, 0.0159135330468416, 0.0158507488667965, 0.0157878249883652, 0.0157248843461275, 0.0156618915498257, 0.0155986035242677, 0.0155352279543877, 0.0154717126861215, 0.0154082337394357, 0.0153602678328753, 0.01529445592314, 0.0152292000129819, 0.0151642765849829, 0.0150993866845965, 0.0150347407907248, 0.0149701638147235, 0.0149062480777502, 0.0148425437510014, 0.0147790964692831, 0.0147157022729516, 0.0146526070311666, 0.0145896300673485, 0.0145272817462683, 0.01446517650038, 0.0144030004739761, 0.0143413655459881, 0.0142800593748689, 0.0142184579744935, 0.014157623052597, 0.0140967890620232, 0.0140363704413176, 0.0139764230698347, 0.0139165800064802, 0.0138565450906754, 0.0137973455712199, 0.0137380072847009, 0.0136792603880167, 0.0136206345632672, 0.013562218286097, 0.0135042015463114, 0.0134459584951401, 0.0133885173127055, 0.0133313024416566, 0.0132742412388325, 0.013217288069427, 0.0131608201190829, 0.0131041957065463, 0.0130483200773597, 0.0129925664514303, 0.0129368649795651, 0.0128817539662123, 0.0128269055858254, 0.012771968729794, 0.0127174155786633, 0.012663071975112, 0.0126091269776225, 0.0125555312260985, 0.0125020742416382, 0.0124487560242414, 0.0123957693576813, 0.0123428860679269, 0.0122906295582652, 0.0122385127469897, 0.0121864303946495, 0.0121349049732089, 0.0120836924761534, 0.012032219208777, 0.0119814425706863, 0.0119305951520801, 0.0118803922086954, 0.0118304155766964, 0.0117805954068899, 0.0117307398468256, 0.0116815119981766, 0.0116322655230761, 0.0115836290642619, 0.0115350969135761, 0.0114866504445672, 0.0114387283101678, 0.0113908741623163, 0.0113433329388499, 0.0113068604841828, 0.0112708043307066, 0.0112351663410664, 0.0112000843510032, 0.0111651439219713, 0.0111304791644216, 0.0110963732004166, 0.011062266305089, 0.0110292732715607, 0.0109964199364185, 0.0109638432040811, 0.0109316864982247, 0.0108998063951731, 0.0108684841543436, 0.0108378585427999, 0.0108069535344839, 0.0107773002237082, 0.0107473703101277, 0.0107182757928967, 0.010688902810216, 0.0106605030596256, 0.0106321033090353, 0.0106046795845032, 0.0105773946270347, 0.0105502484366298, 0.0105236591771245, 0.0104974871501327, 0.0104717332869768, 0.010446535423398, 0.0104213384911418, 0.0103966975584626, 0.0103726144880056, 0.0103485304862261, 0.0103254215791821, 0.0103024514392018, 0.0102798994630575, 0.0102577647194266, 0.0102360490709543, 0.0102143324911594, 0.0101937288418412, 0.0101727079600096, 0.0101528009399772, 0.0101330326870084, 0.0101135428994894, 0.0100944712758064, 0.0100758168846369, 0.0100574409589171, 0.010039621964097, 0.0100226383656263, 0.0100052375346422, 0.00998894870281219, 0.00997238233685493, 0.00995665229856968, 0.00994119979441166, 0.00992616545408964, 0.00991154834628105, 0.00989748723804951, 0.00988328736275434, 0.00987006258219481, 0.00985683780163527, 0.00984430871903896, 0.00983191933482885, 0.00982050411403179, 0.00980867072939873, 0.00979781243950129, 0.00978681445121765, 0.00977651309221983, 0.00976704619824886, 0.00975716207176447, 0.00974839273840189, 0.00973029434680939, 0.00972486566752195, 0.00971929728984833, 0.00971428584307432, 0.00970899499952793, 0.00970426201820374, 0.0096992515027523, 0.00969479605555534, 0.00969020184129477, 0.00968602579087019, 0.00968171004205942, 0.00967795215547085, 0.00967391487210989, 0.00967029482126236, 0.0096666757017374, 0.0096634728834033, 0.00966013222932816, 0.00965707004070282, 0.00965428538620472, 0.00965150166302919, 0.00964899640530348, 0.00964649021625519, 0.0096444021910429, 0.00964217353612185, 0.00964036397635937, 0.00963841564953327, 0.00963688362389803, 0.00963535252958536, 0.0096342395991087, 0.00963298603892326, 0.00963215157389641, 0.00963117647916079, 0.00963048078119755, 0.00963006354868412, 0.0096295066177845, 0.0096295066177845, 0.00962936691939831, 0.00962964538484812, 0.00962992385029793, 0.00963034201413393, 0.00963089801371098, 0.0096318731084466, 0.00963270757347345, 0.00963396113365889, 0.00963493529707193, 0.00963660608977079, 0.00963799748569727, 0.00963980704545975, 0.00964161660522223, 0.00964384526014328, 0.00964593328535557, 0.00964843854308128, 0.00965066626667976, 0.00965358968824148, 0.00965623464435339, 0.00965915806591511, 0.00966249871999025, 0.00966556090861559, 0.00966932065784931, 0.00967280101031065, 0.00967669859528542, 0.00968045741319656, 0.00968477223068476, 0.00968894828110933, 0.00969354342669249, 0.00969785917550325, 0.00970287062227726, 0.00970760360360146, 0.0097128925845027, 0.00971790496259928, 0.00972333457320929, 0.00972876325249672, 0.00973321776837111, 0.00973607134073973, 0.00973871722817421, 0.00974122248589993, 0.00974386837333441, 0.00974623486399651, 0.0097486013546586, 0.00975082814693451, 0.00975305587053299, 0.00975514389574528, 0.00975709222257137, 0.00975918024778366, 0.00976105965673923, 0.00976280029863119, 0.00976461078971624, 0.00976621080189943, 0.00976767390966415, 0.00976927392184734, 0.0097705963999033, 0.00977191887795925, 0.00977310258895159, 0.00977435521781445, 0.00977539923042059, 0.00977630447596312, 0.00977734848856926, 0.00977818295359612, 0.00977887958288193, 0.00977964513003826, 0.00978020206093788, 0.00978068914264441, 0.00978124607354403, 0.00978152453899384, 0.00978180300444365, 0.00978194177150726, 0.00978215038776398, 0.00978215038776398, 0.00978208053857088, 0.00978208053857088, 0.00978187192231417, 0.00978152453899384, 0.00978117622435093, 0.00978082790970802, 0.0097802709788084, 0.00977957528084517, 0.00977901834994555, 0.00977825280278921, 0.00977741740643978, 0.00977658294141293, 0.00977553892880678, 0.00977442506700754, 0.0097733810544014, 0.00977212842553854, 0.00977080594748259, 0.00976934377104044, 0.00976795237511396, 0.00976635050028563, 0.00976467970758677, 0.009763078764081, 0.00976126920431852, 0.00975938979536295, 0.00975758023560047, 0.00975549221038818, 0.0097533343359828, 0.00975110661238432, 0.00974894966930151, 0.00974658317863941, 0.00974414683878422, 0.00974171049892902, 0.00973906554281712, 0.00973641965538263, 0.00973377469927073, 0.0097286244854331, 0.00972291734069586, 0.00971693079918623, 0.0097109442576766, 0.00970454048365355, 0.00969799794256687, 0.00969159416854382, 0.00968491192907095, 0.00967781245708466, 0.00967085268348455, 0.00966361258178949, 0.00965623464435339, 0.00964871793985367, 0.00964106060564518, 0.00963312573730946, 0.00962519086897373, 0.00961697660386562, 0.00960862450301647, 0.00959999393671751, 0.00959150120615959, 0.00958273187279701, 0.00957368221133947, 0.00956463348120451, 0.00955530721694231, 0.00954583939164877, 0.00953623466193676, 0.00952635053545237, 0.00951660610735416, 0.00950644444674253, 0.00949614122509956, 0.00948584079742432, 0.00947512034326792, 0.00946454145014286, 0.00945382192730904, 0.00944268517196178, 0.00943140871822834, 0.00941999349743128, 0.00940857827663422, 0.00939688459038734, 0.00938505120575428, 0.00937321875244379, 0.0093609681352973, 0.00934857781976461, 0.0093361884355545, 0.00932352058589458, 0.00931085180491209, 0.00929776672273874, 0.00928467977792025, 0.00927131623029709, 0.00925795175135136, 0.00924458727240562, 0.00923066679388285, 0.00921688508242369, 0.00920268520712852, 0.00918848533183336, 0.00917414762079716, 0.00915952958166599, 0.0091449124738574, 0.0091301565989852, 0.0091151213273406, 0.00909994728863239, 0.00908449478447437, 0.00906904228031635, 0.00905345100909472, 0.00903772003948689, 0.00902171060442924, 0.00900556240230799, 0.00898927450180054, 0.00897298660129309, 0.00895628146827221, 0.00893957633525133, 0.00892273150384426, 0.00890146661549807, 0.00887870509177446, 0.00885601341724396, 0.00883339159190655, 0.00881056115031242, 0.00878794025629759, 0.00876524858176708, 0.00874248798936605, 0.00871986616402864, 0.00869710557162762, 0.00867441389709711, 0.0086517222225666, 0.00862910039722919, 0.00860633980482817, 0.00858350936323404, 0.00856095738708973, 0.00853812787681818, 0.00851550605148077, 0.00849281437695026, 0.00847012270241976, 0.00844743102788925, 0.00842453073710203, 0.00840197876095772, 0.00837914831936359, 0.00835652742534876, 0.00833376683294773, 0.00831107515841722, 0.00828845333307981, 0.00826576165854931, 0.00824307091534138, 0.00822023954242468, 0.00819747895002365, 0.00817485805600882, 0.00815209653228521, 0.0081294747069478, 0.0081067830324173, 0.00808409228920937, 0.00806126184761524, 0.00803870987147093, 0.00801594834774733, 0.00799325667321682, 0.00797049701213837, 0.00794780533760786, 0.00792511366307735, 0.0079023540019989, 0.00787973217666149, 0.00785690080374479, 0.00783421006053686, 0.00781151792034507, 0.00778889609500766, 0.00776620488613844, 0.00774330459535122, 0.0077208224684, 0.00769799202680588, 0.00767530035227537, 0.00765274837613106, 0.00762991840019822, 0.00760729657486081, 0.00758439628407359, 0.00756184384226799, 0.00753908278420568, 0.00751639157533646, 0.00749383913353086, 0.00747100869193673, 0.0074482480995357, 0.00742562627419829, 0.00740293506532907, 0.00738010508939624, 0.00735748326405883, 0.00733479158952832, 0.00731203053146601, 0.00729278987273574, 0.00727573595941067, 0.00725910160690546, 0.00724239554256201, 0.00722603918984532, 0.00720995990559459, 0.00719367200508714, 0.00717780273407698, 0.00716193206608295, 0.0071464111097157, 0.00713088875636458, 0.00711557501927018, 0.00710061052814126, 0.00708536664023995, 0.00707068061456084, 0.00705599319189787, 0.00704151624813676, 0.0070271072909236, 0.0070129088126123, 0.00699891755357385, 0.00698506692424417, 0.00697135413065553, 0.00695778196677566, 0.00694434717297554, 0.00693105347454548, 0.00691796699538827, 0.00690516037866473, 0.00689242174848914, 0.00687982421368361, 0.00686729419976473, 0.006854975130409, 0.00684279343113303, 0.00683096097782254, 0.00681919697672129, 0.00680750422179699, 0.00679595023393631, 0.00678467331454158, 0.00677360687404871, 0.00676239933818579, 0.00675168074667454, 0.00674096262082458, 0.00673038139939308, 0.00672015035524964, 0.00670970836654305, 0.00669982517138124, 0.00668973289430141, 0.00668012630194426, 0.00667066080495715, 0.00666105560958385, 0.0066518671810627, 0.00664267968386412, 0.00663384050130844, 0.00662499945610762, 0.00661636888980865, 0.0066080167889595, 0.00659959344193339, 0.00659145042300224, 0.00658344617113471, 0.00657564913854003, 0.0065679932013154, 0.00656047603115439, 0.00655316794291139, 0.00654585845768452, 0.00653889821842313, 0.00653200782835484, 0.00652518682181835, 0.00651857350021601, 0.00651217019185424, 0.00650604534894228, 0.00649998988956213, 0.00649400288239121, 0.00648829527199268, 0.00648442422971129, 0.0064817788079381, 0.0064791333861649, 0.00647648889571428, 0.00647412240505219, 0.00647161668166518, 0.00646932004019618, 0.00646716170012951, 0.00646493444219232, 0.00646291580051184, 0.00646075839176774, 0.00645887898281217, 0.0064571388065815, 0.00645525939762592, 0.00645365845412016, 0.00645191827788949, 0.00645045656710863, 0.00644906423985958, 0.00644760299474001, 0.00644634990021586, 0.00644502742215991, 0.00644398340955377, 0.00644300924614072, 0.00644196476787329, 0.00644105998799205, 0.00644015520811081, 0.00643952889367938, 0.00643890211358666, 0.00643827533349395, 0.00643778825178742, 0.0064373011700809, 0.00643702270463109, 0.00643681408837438, 0.00643653562292457, 0.00643646577373147, 0.00643639639019966, 0.00643653562292457, 0.00643667485564947, 0.00643681408837438, 0.006437161937356, 0.00643744040280581, 0.00643799686804414, 0.00643855379894376, 0.00643911119550467, 0.0064398068934679, 0.00644057290628552, 0.00644140783697367, 0.00644231308251619, 0.00644335709512234, 0.00644454034045339, 0.00644558435305953, 0.00644690683111548, 0.00644815945997834, 0.0064496211707592, 0.00645115226507187, 0.00645261444151402, 0.00645428476855159, 0.00645595556125045, 0.00645783497020602, 0.00645978376269341, 0.00646166317164898, 0.00646375119686127, 0.00646583922207355, 0.00646806648001075, 0.00647036405280232, 0.00647266069427133, 0.00647516641765833, 0.00647760229185224, 0.00648024771362543, 0.00648296251893044, 0.00648567685857415, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648890482261777, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648779096081853, 0.00648368475958705, 0.00648639909923077, 0.00648911343887448, 0.00649168901145458, 0.00649426411837339, 0.00649677030742168, 0.00649920664727688, 0.00650143437087536, 0.00650373147800565, 0.00650574965402484, 0.00650790752843022, 0.00650985632091761, 0.00651180511340499, 0.00651354528963566, 0.00651535484939814, 0.00651695532724261, 0.00651862658560276, 0.00652001891285181, 0.00652161939069629, 0.00652287248522043, 0.00652419496327639, 0.00652530929073691, 0.00652649253606796, 0.00652746669948101, 0.00652851071208715, 0.00652927625924349, 0.00653011165559292, 0.00653080781921744, 0.00653150351718068, 0.0065319212153554, 0.00653247814625502, 0.00653289584442973, 0.00653331307694316, 0.00653345230966806, 0.00653366139158607, 0.00653366139158607, 0.00653373077511787, 0.00653352215886116, 0.00653345230966806, 0.00653317430987954, 0.00653289584442973, 0.00653240829706192, 0.00653199106454849, 0.00653136428445578, 0.00653087720274925, 0.00653011165559292, 0.00652934610843658, 0.00652844132855535, 0.00652753654867411, 0.00652642268687487, 0.00652537867426872, 0.00652405573055148, 0.00652287248522043, 0.00652148015797138, 0.00652008829638362, 0.00651848735287786, 0.00651695532724261, 0.00651521561667323, 0.00651361467316747, 0.00651173526421189, 0.00650985632091761, 0.00650783767923713, 0.00650581950321794, 0.00650359224528074, 0.00650143437087536, 0.00649899756535888, 0.00649670092388988, 0.0064941942691803, 0.00649168901145458, 0.00648897420614958, 0.00648632971569896, 0.00648361491039395, 0.00648180488497019, 0.00647595804184675, 0.0064699724316597, 0.00646370789036155, 0.00645730458199978, 0.00645076110959053, 0.00644407887011766, 0.00643725786358118, 0.0064302971586585, 0.00642305845394731, 0.00641581928357482, 0.00640830164775252, 0.00640078447759151, 0.00639298837631941, 0.00638505350798368, 0.00637697940692306, 0.00636862637475133, 0.00636013504117727, 0.00635164324194193, 0.00634287251159549, 0.00633396301418543, 0.00632491428405046, 0.00631558755412698, 0.0063062603585422, 0.00629665469750762, 0.00628718780353665, 0.00627730414271355, 0.00626728124916553, 0.00625711865723133, 0.0062466780655086, 0.00623623700812459, 0.00622551748529077, 0.00621465919539332, 0.00620366167277098, 0.00619252445176244, 0.00618138769641519, 0.00616983324289322, 0.00615827878937125, 0.00614658510312438, 0.0061347521841526, 0.00612264079973102, 0.00611039018258452, 0.00609800033271313, 0.00608533201739192, 0.00607280293479562, 0.00605971738696098, 0.00604677060618997, 0.00603340659290552, 0.00602046027779579, 0.00600667810067534, 0.0059930351562798, 0.00597925344482064, 0.0059654712677002, 0.0059511330910027, 0.00593693368136883, 0.00592231610789895, 0.00590783776715398, 0.00589280342683196, 0.00587804708629847, 0.00586273381486535, 0.00584755977615714, 0.00583224650472403, 0.00581679400056601, 0.00580078456550837, 0.00578519329428673, 0.00576890539377928, 0.00575289595872164, 0.00573633052408695, 0.00571990292519331, 0.00570305855944753, 0.00568635342642665, 0.00566906854510307, 0.00564623810350895, 0.00562347704544663, 0.00560099491849542, 0.00557816401124001, 0.00555547280237079, 0.00553278159350157, 0.00551008991897106, 0.00548739917576313, 0.00546470750123262, 0.0054418770596385, 0.00541932508349419, 0.00539649417623878, 0.00537380343303084, 0.00535111222416162, 0.00532842054963112, 0.0053057293407619, 0.00528317736461759, 0.00526020769029856, 0.00523765571415424, 0.00521489465609193, 0.00519213359802961, 0.0051695117726922, 0.00514675118029118, 0.00512405997142196, 0.00510136829689145, 0.00507867708802223, 0.00505584664642811, 0.00503336451947689, 0.00501053361222148, 0.00498805101960897, 0.00496522057801485, 0.00494252936914563, 0.00491983816027641, 0.00489714695140719, 0.00487431604415178, 0.00485176406800747, 0.00482893362641335, 0.00480617256835103, 0.00478348135948181, 0.00476079015061259, 0.00473795970901847, 0.00471540726721287, 0.00469264667481184, 0.00467009469866753, 0.00464733364060521, 0.00462464196607471, 0.00460188137367368, 0.00457919016480446, 0.00455642910674214, 0.00453387713059783, 0.00451104622334242, 0.00448828563094139, 0.00446566427126527, 0.00444290321320295, 0.00442014215514064, 0.00439758971333504, 0.00437475880607963, 0.0043522072955966, 0.00432937638834119, 0.00430668564513326, 0.00428399397060275, 0.00426130229607224, 0.00423847185447812, 0.00421592034399509, 0.00419308990240097, 0.00417053746059537, 0.00414770655333996, 0.00412501534447074, 0.00410239351913333, 0.0040796329267323, 0.00405687186866999, 0.00403381651267409, 0.00401704153046012, 0.00400033593177795, 0.00398397911339998, 0.00396755244582891, 0.00395126501098275, 0.00393546419218183, 0.00391952460631728, 0.00390407233498991, 0.00388841144740582, 0.00387288955971599, 0.00385785498656332, 0.00384268094785511, 0.00382792460732162, 0.00381316803395748, 0.00379841192625463, 0.00378407328389585, 0.00376987410709262, 0.00375581393018365, 0.00374182336963713, 0.00372797180898488, 0.00371439894661307, 0.00370103470049798, 0.00368753145448864, 0.0036743760574609, 0.00366149912588298, 0.00364869181066751, 0.0036359541118145, 0.00362349464558065, 0.0036111744120717, 0.0035989242605865, 0.00358702219091356, 0.00357505003921688, 0.00356335635297, 0.00355187128297985, 0.00354024721309543, 0.00352911022491753, 0.00351797370240092, 0.00350697641260922, 0.00349639635533094, 0.00348567706532776, 0.00347509677521884, 0.00346507434733212, 0.00345491175539792, 0.00344502762891352, 0.00343514350242913, 0.00342539953999221, 0.0034160721115768, 0.00340660568326712, 0.00339741795323789, 0.00338850868865848, 0.00337945972569287, 0.00337082915939391, 0.00336233712732792, 0.00335398432798684, 0.00334570161066949, 0.00333769689314067, 0.00332983140833676, 0.00332203577272594, 0.00331437936984003, 0.00330700119957328, 0.00329976202920079, 0.00329259317368269, 0.00328563223592937, 0.00327888084575534, 0.00327226798981428, 0.00326572544872761, 0.00325959990732372, 0.0032532662153244, 0.00324714090675116, 0.00324157252907753, 0.00323991500772536, 0.003237200435251, 0.00323448586277664, 0.00323184067383409, 0.00322926556691527, 0.00322682922706008, 0.00322439312003553, 0.00322223547846079, 0.0032199383713305, 0.00321791972965002, 0.00321583170443773, 0.00321381306275725, 0.00321207288652658, 0.00321019371040165, 0.00320859276689589, 0.00320685259066522, 0.00320525164715946, 0.00320385955274105, 0.00320225884206593, 0.00320107559673488, 0.00319975288584828, 0.00319856940768659, 0.00319752539508045, 0.0031964813824743, 0.00319550698623061, 0.00319474143907428, 0.00319397589191794, 0.00319334934465587, 0.00319258356466889, 0.00319209648296237, 0.00319174816831946, 0.00319119147025049, 0.00319098262116313, 0.00319070415571332, 0.00319056492298841, 0.00319056492298841, 0.00319056492298841, 0.00319077377207577, 0.00319091300480068, 0.00319112185388803, 0.00319153931923211, 0.00319181778468192, 0.00319230533204973, 0.00319300126284361, 0.00319355796091259, 0.00319439335726202, 0.00319515913724899, 0.00319599430076778, 0.00319703831337392, 0.00319808232598007, 0.00319933542050421, 0.00320044904947281, 0.00320170191116631, 0.00320323323830962, 0.00320448586717248, 0.00320615665987134, 0.0032077576033771, 0.00320928893052042, 0.00321116810664535, 0.00321297789923847, 0.00321499654091895, 0.00321694533340633, 0.00321903359144926, 0.0032212610822171, 0.00322348810732365, 0.00322578498162329, 0.00322829093784094, 0.00323058781214058, 0.00323330261744559, 0.00323587795719504, 0.00323852268047631, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.00324306031689048, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.00324389548040926, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.0032436172477901, 0.00324466126039624, 0.00324751483276486, 0.00325009040534496, 0.00325280521064997, 0.00325531093403697, 0.00325781665742397, 0.00326011376455426, 0.00326234102249146, 0.0032647077459842, 0.00326672615483403, 0.00326888379640877, 0.00327076320536435, 0.00327271223068237, 0.00327445263974369, 0.00327626243233681, 0.00327786314301193, 0.00327946408651769, 0.00328085594810545, 0.00328238727524877, 0.00328370998613536, 0.00328496284782887, 0.00328621617518365, 0.00328739918768406, 0.00328830420039594, 0.00328934821300209, 0.00329011376015842, 0.00329094892367721, 0.00329157523810863, 0.00329227140173316, 0.00329268886707723, 0.00329324579797685, 0.00329366326332092, 0.00329394172877073, 0.00329408096149564, 0.0032944290433079, 0.0032944290433079, 0.00329449865967035, 0.003294289810583, 0.00329415057785809, 0.00329387211240828, 0.00329345464706421, 0.00329310656525195, 0.00329254986718297, 0.00329199293628335, 0.00329129700548947, 0.0032906704582274, 0.00328976567834616, 0.00328900013118982, 0.00328802573494613, 0.00328705133870244, 0.0032858676277101, 0.00328468438237906, 0.00328336213715374, 0.0032820391934365, 0.00328050809912384, 0.00327904638834298, 0.0032773760613054, 0.00327577511779964, 0.00327403470873833, 0.0032721555326134, 0.00327020627446473, 0.00326839671470225, 0.00326623907312751, 0.00326408143155277, 0.00326178409159184, 0.00325955706648529, 0.003257050877437, 0.00325461500324309, 0.00325203966349363, 0.00324946409091353, 0.00324661005288363, 0.00324403471313417, 0.00323559949174523, 0.00322954379953444, 0.00322369718924165, 0.00321736303158104, 0.00321109849028289, 0.00320434686727822, 0.00319794309325516, 0.00319084338843822, 0.0031840221490711, 0.00317664397880435, 0.00316926604136825, 0.00316174863837659, 0.0031542310025543, 0.00314643536694348, 0.0031384308822453, 0.00313035654835403, 0.0031220733653754, 0.00311365118250251, 0.00310508976690471, 0.00309631950221956, 0.0030874100048095, 0.00307829165831208, 0.0030690343119204, 0.00305942865088582, 0.00305003207176924, 0.00304028717800975, 0.00303054274991155, 0.00302038015797734, 0.00301035703159869, 0.00299991643987596, 0.00298940576612949, 0.00297868670895696, 0.00296789803542197, 0.00295683066360652, 0.00294569367542863, 0.00293434807099402, 0.00292286346666515, 0.00291123939678073, 0.00289940624497831, 0.00288771255873144, 0.00287546217441559, 0.00286328117363155, 0.00285068247467279, 0.00283836247399449, 0.00282548554241657, 0.0028126782272011, 0.00279945321381092, 0.00278636743314564, 0.00277286395430565, 0.00275943032465875, 0.0027455787640065, 0.0027319360524416, 0.00271787587553263, 0.00270367646589875, 0.00268933759070933, 0.00267485971562564, 0.00266031222417951, 0.00264534703455865, 0.00263045146130025, 0.00261527788825333, 0.00260010384954512, 0.0025845121126622, 0.00256905984133482, 0.00255318987183273, 0.00253731990233064, 0.00252131070010364, 0.00250502303242683, 0.00248859636485577, 0.00247202999889851, 0.00245532486587763, 0.00243848050013185, 0.00241487426683307, 0.00239197420887649, 0.00236921361647546, 0.00234652240760624, 0.00232383096590638, 0.00230120960623026, 0.00227851839736104, 0.00225568795576692, 0.00223285751417279, 0.00221016630530357, 0.00218768371269107, 0.00216499250382185, 0.00214209244586527, 0.0021195407025516, 0.00209677964448929, 0.00207401881925762, 0.00205118861049414, 0.00202884525060654, 0.00200601480901241, 0.00198325421661139, 0.00196042354218662, 0.00193780206609517, 0.00191518059000373, 0.00189234991557896, 0.00186972843948752, 0.00184675888158381, 0.00182441552169621, 0.0018014459637925, 0.00177896348759532, 0.00175620266236365, 0.0017335811862722, 0.00171068089548498, 0.00168798980303109, 0.0016655073268339, 0.00164260726887733, 0.0016198466764763, 0.00159708573482931, 0.00157439452596009, 0.00155184254981577, 0.00152915134094656, 0.00150632089935243, 0.00148369930684566, 0.00146093848161399, 0.00143817765638232, 0.0014154864475131, 0.00139300397131592, 0.00137017364613712, 0.00134741270449013, 0.00132472161203623, 0.0013018911704421, 0.00127947831060737, 0.0012565782526508, 0.00123388704378158, 0.00121105671860278, 0.00118864385876805, 0.00116567418444902, 0.00114326144102961, 0.00112043099943548, 0.00109773979056627, 0.00107490934897214, 0.00105221825651824, 0.00102966616395861, 0.00100683572236449, 0.000984144513495266, 0.000961314130108804, 0.000938622863031924, 0.000916070770472288, 0.00089337961981073, 0.000870688410941511, 0.000847997143864632, 0.000825166702270508, 0.00080602866364643, 0.000788766541518271, 0.000772478932049125, 0.000755773682612926, 0.000739207665901631, 0.000722780823707581, 0.000706493156030774, 0.000691040826495737, 0.00067503162426874, 0.000659300829283893, 0.000643570034299046, 0.000628535286523402, 0.000613222189713269, 0.000597908976487815, 0.00058343110140413, 0.000568674819078296, 0.000553918536752462, 0.000539440603461117, 0.000525519601069391, 0.000511598540470004, 0.000497538247145712, 0.000483756419271231, 0.000469835358671844, 0.000456610403489321, 0.000443385360995308, 0.000430160405812785, 0.000417353032389656, 0.000404406455345452, 0.000391599081922323, 0.000379070144845173, 0.000366958818631247, 0.000354986725142226, 0.0003428753989283, 0.000330903334543109, 0.000319070444675162, 0.00030765516567044, 0.000296518323011696, 0.000284963869489729, 0.000273827055934817, 0.000263107824139297, 0.000252249388722703, 0.000241530186031014, 0.000231367841479369, 0.000221205467823893, 0.000211182297789492, 0.000201159156858921, 0.000190996783203445, 0.000181530471309088, 0.000172342595760711, 0.000162876283866353, 0.000153549175593071, 0.000144918129080907, 0.000135730238980614, 0.000127377614262514, 0.000118746553198434, 0.000110393935756292, 0.000102319725556299, 9.3967086286284e-05, 8.63105160533451e-05, 7.85147276474163e-05, 7.09973683115095e-05, 6.34800016996451e-05, 5.62410532438662e-05, 4.91413156851195e-05, 4.21807926613837e-05, 3.57771095877979e-05, 2.89557992800837e-05, 2.26913271035301e-05, 1.62876458489336e-05, 9.88396368484246e-06, 4.17633373217541e-06, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15, 3.24364046195159e-15   }, 
   { 0.0112878596410155, 0.0120161166414618, 0.0127475429326296, 0.013482135720551, 0.014219906181097, 0.0149608412757516, 0.0157049614936113, 0.0164522472769022, 0.0172027051448822, 0.0179563406854868, 0.0187131408601999, 0.0194731131196022, 0.0202362630516291, 0.0210025869309902, 0.0217720717191696, 0.0225447379052639, 0.0233205761760473, 0.0240995790809393, 0.0248817671090364, 0.0256671197712421, 0.0264556352049112, 0.0272473450750113, 0.0280422139912844, 0.0288402494043112, 0.0296414606273174, 0.0304458513855934, 0.0312534049153328, 0.0320641361176968, 0.0328780487179756, 0.0336951166391373, 0.0345153622329235, 0.0353387892246246, 0.0361653678119183, 0.0369951389729977, 0.0378280840814114, 0.0386641845107079, 0.0395034663379192, 0.0403459183871746, 0.0411915443837643, 0.0420403368771076, 0.0428923144936562, 0.0437474586069584, 0.044605765491724, 0.0454672500491142, 0.046331912279129, 0.0471997447311878, 0.0480707511305809, 0.0489449203014374, 0.049822274595499, 0.0507027730345726, 0.0515864789485931, 0.0524733439087868, 0.0533633828163147, 0.0542565956711769, 0.0551529787480831, 0.0560525096952915, 0.0569552518427372, 0.057861153036356, 0.0587702207267284, 0.0596824623644352, 0.0605978742241859, 0.0615164488554001, 0.0624382123351097, 0.0633631572127342, 0.0642912536859512, 0.0652225241065025, 0.0661569833755493, 0.067094586789608, 0.0680353790521622, 0.0689793452620506, 0.069926492869854, 0.070876806974411, 0.0718302801251411, 0.0727869272232056, 0.0737467408180237, 0.0747097432613373, 0.0756759196519852, 0.0766452699899673, 0.0776177868247032, 0.0785934627056122, 0.0795723050832748, 0.0805543437600136, 0.0815395414829254, 0.0825279355049133, 0.0835194960236549, 0.0845141932368279, 0.0855120792984962, 0.0865131542086601, 0.0875173881649971, 0.088524803519249, 0.0895353853702545, 0.0905491262674332, 0.0915660560131073, 0.0925861522555351, 0.0936094149947166, 0.0946358665823936, 0.0956654846668243, 0.0966982543468475, 0.0977342203259468, 0.0987733602523804, 0.0998156666755676, 0.100861124694347, 0.101909793913364, 0.102961592376232, 0.104016587138176, 0.105074763298035, 0.106136105954647, 0.107241585850716, 0.108422614634037, 0.10960353910923, 0.110784411430359, 0.111965201795101, 0.113145887851715, 0.114326544106007, 0.115507073700428, 0.116687528789043, 0.117867901921272, 0.119048237800598, 0.120228454470634, 0.121408604085445, 0.122588664293289, 0.123768642544746, 0.124948553740978, 0.126128390431404, 0.127308145165443, 0.128487825393677, 0.129667401313782, 0.130846902728081, 0.132026329636574, 0.133205696940422, 0.134384974837303, 0.135564193129539, 0.136743292212486, 0.137922331690788, 0.139101281762123, 0.140280157327652, 0.141458988189697, 0.142637684941292, 0.143816322088242, 0.144994899630547, 0.146173372864723, 0.147351771593094, 0.14853011071682, 0.149708345532417, 0.15088652074337, 0.152064606547356, 0.153242588043213, 0.154420524835587, 0.155598387122154, 0.156776145100594, 0.157953843474388, 0.159131422638893, 0.160308957099915, 0.161486402153969, 0.162663787603378, 0.163841083645821, 0.165018320083618, 0.166195407509804, 0.167372465133667, 0.168549448251724, 0.169726341962814, 0.170903161168098, 0.172079920768738, 0.173256561160088, 0.174433127045631, 0.175609648227692, 0.176786065101624, 0.177962392568588, 0.179138660430908, 0.180314838886261, 0.181490927934647, 0.18266698718071, 0.183842927217484, 0.185018807649612, 0.186194583773613, 0.187370255589485, 0.188545882701874, 0.189721435308456, 0.190896913409233, 0.192033603787422, 0.193162158131599, 0.19428513944149, 0.1954026222229, 0.196514695882797, 0.197621241211891, 0.198722288012505, 0.199817806482315, 0.200907960534096, 0.201992496848106, 0.203071653842926, 0.204145237803459, 0.205213367938995, 0.206275999546051, 0.207333207130432, 0.208384841680527, 0.209431052207947, 0.210471704602242, 0.211506918072701, 0.212536618113518, 0.213560909032822, 0.214579626917839, 0.215592801570892, 0.216600641608238, 0.217602849006653, 0.218599647283554, 0.219590961933136, 0.220576792955399, 0.221557065844536, 0.22253192961216, 0.223501294851303, 0.224465176463127, 0.225423499941826, 0.226376384496689, 0.227323845028877, 0.228265732526779, 0.229202091693878, 0.230133071541786, 0.231058478355408, 0.231978476047516, 0.232892870903015, 0.233801916241646, 0.234705403447151, 0.235603332519531, 0.236495852470398, 0.237382933497429, 0.238264486193657, 0.23914048075676, 0.24001108109951, 0.240876138210297, 0.241735711693764, 0.242589816451073, 0.243438452482224, 0.244281589984894, 0.245119154453278, 0.245951309800148, 0.24677799642086, 0.247599214315414, 0.248414844274521, 0.249225035309792, 0.250029772520065, 0.250829011201859, 0.251622706651688, 0.252411007881165, 0.253193706274033, 0.253970980644226, 0.2547427713871, 0.255509048700333, 0.256269901990891, 0.257025122642517, 0.257775008678436, 0.258411258459091, 0.258933275938034, 0.259451597929001, 0.259966224431992, 0.260477215051651, 0.260984510183334, 0.261488080024719, 0.261988043785095, 0.262484282255173, 0.262976884841919, 0.263465702533722, 0.263950943946838, 0.264432489871979, 0.264910340309143, 0.265384465456009, 0.265854984521866, 0.266321837902069, 0.266784876585007, 0.267244338989258, 0.267700135707855, 0.268152236938477, 0.268600612878799, 0.269045382738113, 0.269486427307129, 0.269923835992813, 0.270357459783554, 0.270787477493286, 0.271213829517365, 0.271636515855789, 0.272055417299271, 0.272470742464066, 0.272882342338562, 0.273290246725082, 0.273694545030594, 0.274095118045807, 0.274492025375366, 0.274885177612305, 0.275274753570557, 0.27566060423851, 0.27604278922081, 0.276421248912811, 0.276796072721481, 0.277167230844498, 0.277534693479538, 0.277898460626602, 0.278258562088013, 0.27861499786377, 0.27896773815155, 0.27931672334671, 0.279662102460861, 0.280003845691681, 0.280341804027557, 0.280676156282425, 0.281006842851639, 0.281333833932877, 0.281657099723816, 0.281976759433746, 0.282292693853378, 0.282604873180389, 0.282913476228714, 0.283218383789062, 0.283519595861435, 0.283817112445831, 0.284110993146896, 0.284401208162308, 0.284687697887421, 0.284970492124557, 0.285249680280685, 0.285525113344193, 0.285796910524368, 0.286064982414246, 0.286333203315735, 0.286650866270065, 0.2869713306427, 0.287294507026672, 0.287620425224304, 0.287949115037918, 0.288280606269836, 0.288614839315414, 0.28895178437233, 0.289291620254517, 0.289634078741074, 0.289979338645935, 0.290327399969101, 0.290678173303604, 0.291031718254089, 0.291388005018234, 0.291747063398361, 0.29210889339447, 0.292473465204239, 0.292840868234634, 0.293210953474045, 0.293583810329437, 0.293959438800812, 0.294337868690491, 0.294718950986862, 0.29510286450386, 0.295489490032196, 0.295878946781158, 0.296271115541458, 0.296666085720062, 0.297063797712326, 0.297464281320572, 0.297867506742477, 0.298273473978043, 0.298682183027267, 0.299093693494797, 0.299507975578308, 0.299924969673157, 0.300344794988632, 0.300767332315445, 0.30119264125824, 0.301620721817017, 0.302051514387131, 0.302485138177872, 0.302921414375305, 0.303360521793365, 0.303802400827408, 0.30424702167511, 0.304694414138794, 0.305144548416138, 0.305597424507141, 0.306053131818771, 0.306511461734772, 0.306972682476044, 0.307436645030975, 0.307903349399567, 0.308372795581818, 0.308845013380051, 0.309319972991943, 0.309797734022141, 0.310278236865997, 0.310761451721191, 0.311247527599335, 0.311736255884171, 0.312227815389633, 0.312722116708755, 0.31321918964386, 0.313719004392624, 0.314221620559692, 0.314726918935776, 0.315235018730164, 0.315745830535889, 0.316289961338043, 0.316856443881989, 0.317429333925247, 0.318008661270142, 0.318594396114349, 0.319186508655548, 0.319785088300705, 0.320390105247498, 0.321001470088959, 0.321619302034378, 0.322243541479111, 0.322874277830124, 0.323511302471161, 0.324154883623123, 0.324804872274399, 0.325461268424988, 0.326124042272568, 0.326793313026428, 0.327468872070312, 0.328150987625122, 0.328839480876923, 0.329534411430359, 0.330235719680786, 0.330943554639816, 0.331657737493515, 0.332378357648849, 0.333105355501175, 0.333838850259781, 0.334578782320023, 0.335325002670288, 0.336077779531479, 0.336836993694305, 0.337602496147156, 0.338374555110931, 0.33915302157402, 0.3399378657341, 0.340729087591171, 0.341526746749878, 0.342330902814865, 0.343141496181488, 0.343958407640457, 0.344781875610352, 0.345611661672592, 0.346447914838791, 0.347290605306625, 0.348139673471451, 0.348995178937912, 0.349857062101364, 0.350725442171097, 0.351600289344788, 0.352481514215469, 0.353369176387787, 0.354263186454773, 0.35516369342804, 0.356070548295975, 0.356983810663223, 0.357903629541397, 0.358829736709595, 0.359762459993362, 0.360701471567154, 0.361646890640259, 0.362598776817322, 0.363557010889053, 0.364521831274033, 0.365492939949036, 0.366470485925674, 0.367454528808594, 0.368444889783859, 0.36944168806076, 0.370444923639297, 0.37145471572876, 0.37247309088707, 0.373514026403427, 0.374563276767731, 0.375620752573013, 0.376686573028564, 0.377760648727417, 0.37884321808815, 0.379934072494507, 0.381033182144165, 0.382140755653381, 0.383256703615189, 0.384380847215652, 0.385513246059418, 0.386654108762741, 0.387803226709366, 0.388960719108582, 0.390126436948776, 0.391300648450851, 0.392482936382294, 0.393673777580261, 0.394872903823853, 0.396080374717712, 0.397296100854874, 0.398520261049271, 0.399752557277679, 0.400993227958679, 0.402242332696915, 0.403499752283096, 0.404765456914902, 0.406039625406265, 0.407321989536285, 0.408612638711929, 0.409911572933197, 0.411218911409378, 0.412534654140472, 0.413858681917191, 0.415190994739532, 0.416531711816788, 0.417880535125732, 0.41923800110817, 0.420603603124619, 0.421977609395981, 0.423359960317612, 0.424750566482544, 0.4261494576931, 0.427556663751602, 0.428972274065018, 0.430396288633347, 0.431828498840332, 0.433269172906876, 0.434718132019043, 0.436175316572189, 0.437640756368637, 0.439114660024643, 0.44059693813324, 0.442087590694427, 0.443586349487305, 0.44509357213974, 0.446609169244766, 0.448132961988449, 0.449665069580078, 0.451205641031265, 0.452754497528076, 0.454311639070511, 0.455877184867859, 0.457450956106186, 0.459033310413361, 0.460623472929001, 0.462222397327423, 0.463829636573792, 0.465445071458817, 0.467068731784821, 0.468689113855362, 0.470315158367157, 0.471950978040695, 0.473597347736359, 0.475254118442535, 0.476920872926712, 0.478598088026047, 0.480285137891769, 0.481982558965683, 0.483690440654755, 0.48540848493576, 0.48713681101799, 0.488874822854996, 0.490623712539673, 0.492382735013962, 0.494151622056961, 0.495931148529053, 0.497720748186111, 0.499520480632782, 0.501330614089966, 0.503150820732117, 0.504981517791748, 0.506821930408478, 0.508672893047333, 0.510534226894379, 0.512405633926392, 0.514287173748016, 0.516179025173187, 0.518081307411194, 0.519993603229523, 0.521916270256042, 0.52384877204895, 0.525791823863983, 0.527745306491852, 0.529708981513977, 0.53168261051178, 0.533666372299194, 0.535660743713379, 0.537665247917175, 0.539679765701294, 0.541704595088959, 0.543739676475525, 0.545785248279572, 0.547840595245361, 0.549906551837921, 0.551982700824738, 0.554068624973297, 0.556165277957916, 0.558272004127502, 0.560389041900635, 0.562516093254089, 0.56465345621109, 0.566801190376282, 0.568958938121796, 0.57112729549408, 0.573305547237396, 0.575493991374969, 0.577692747116089, 0.579901933670044, 0.5821213722229, 0.58435046672821, 0.586590230464935, 0.588840544223785, 0.5911003947258, 0.593370974063873, 0.595651388168335, 0.597942531108856, 0.600243508815765, 0.60255491733551, 0.604876458644867, 0.60720819234848, 0.60956072807312, 0.611941397190094, 0.614333391189575, 0.616737306118011, 0.619153141975403, 0.621581077575684, 0.624020397663116, 0.626471996307373, 0.628935217857361, 0.631410121917725, 0.633897542953491, 0.636396467685699, 0.638907432556152, 0.641429841518402, 0.643964290618896, 0.646510660648346, 0.649068892002106, 0.651639223098755, 0.654221057891846, 0.656815111637115, 0.659420609474182, 0.662038147449493, 0.664667725563049, 0.667308628559113, 0.669961929321289, 0.67262727022171, 0.675303995609283, 0.677992522716522, 0.680693209171295, 0.683405756950378, 0.686129808425903, 0.688866555690765, 0.691614508628845, 0.694373965263367, 0.697146117687225, 0.699929893016815, 0.702725350856781, 0.705532431602478, 0.708351969718933, 0.711182951927185, 0.714026033878326, 0.716880857944489, 0.719747483730316, 0.722626209259033, 0.725516498088837, 0.728418827056885, 0.731333374977112, 0.734258890151978, 0.737196922302246, 0.740146994590759, 0.743108630180359, 0.74608188867569, 0.749067306518555, 0.752064526081085, 0.755073249340057, 0.758094608783722, 0.761127352714539, 0.764171779155731, 0.767228305339813, 0.77029687166214, 0.773377001285553, 0.776469111442566, 0.779573023319244, 0.782689094543457, 0.785816669464111, 0.788956582546234, 0.792107701301575, 0.795271337032318, 0.798446178436279, 0.801633298397064, 0.804832518100739, 0.808042764663696, 0.811318814754486, 0.814610183238983, 0.817912101745605, 0.821225225925446, 0.824549794197083, 0.827885389328003, 0.831232070922852, 0.834589838981628, 0.837958812713623, 0.841338813304901, 0.844729900360107, 0.84813266992569, 0.851546049118042, 0.854970633983612, 0.858406662940979, 0.861853659152985, 0.865311443805695, 0.868780791759491, 0.872261345386505, 0.875752925872803, 0.879255354404449, 0.882769286632538, 0.886294543743134, 0.889830350875854, 0.893377482891083, 0.896935880184174, 0.900505423545837, 0.904086112976074, 0.907677888870239, 0.911281168460846, 0.914894938468933, 0.918520212173462, 0.922156631946564, 0.925804376602173, 0.929462850093842, 0.933132588863373, 0.936813652515411, 0.940505743026733, 0.944208920001984, 0.947923421859741, 0.951648950576782, 0.955385625362396, 0.959133386611938, 0.962892413139343, 0.966662168502808, 0.970443606376648, 0.974235892295837, 0.97803920507431, 0.981854259967804, 0.985680162906647, 0.989517092704773, 0.993365108966827, 0.997224152088165, 1.00109446048737, 1.00497615337372, 1.00886881351471, 1.01277267932892, 1.01668775081635, 1.02061367034912, 1.02455079555511, 1.02849924564362, 1.03245854377747, 1.03642928600311, 1.04041147232056, 1.04440402984619, 1.0484082698822, 1.05242371559143, 1.05644989013672, 1.06048703193665, 1.06453597545624, 1.06859576702118, 1.07268738746643, 1.07680225372314, 1.08092498779297, 1.0850555896759, 1.08919382095337, 1.09333980083466, 1.09749376773834, 1.10165524482727, 1.10582482814789, 1.11000227928162, 1.11418747901917, 1.11838018894196, 1.12258088588715, 1.12678956985474, 1.13100516796112, 1.13522934913635, 1.13946139812469, 1.14370107650757, 1.14794826507568, 1.15220403671265, 1.15646696090698, 1.16073775291443, 1.16501653194427, 1.16930294036865, 1.17359673976898, 1.17789912223816, 1.18220889568329, 1.18652677536011, 1.19085204601288, 1.19518530368805, 1.19952642917633, 1.20387506484985, 1.20823192596436, 1.21259653568268, 1.21696877479553, 1.22134864330292, 1.22573673725128, 1.23013234138489, 1.23453569412231, 1.23894691467285, 1.24336612224579, 1.24779295921326, 1.25222730636597, 1.25666975975037, 1.26112020015717, 1.2655782699585, 1.27004408836365, 1.2745178937912, 1.27899885177612, 1.2834883928299, 1.2879855632782, 1.29249048233032, 1.29700303077698, 1.30152344703674, 1.3060519695282, 1.31058788299561, 1.31513178348541, 1.31968367099762, 1.32424318790436, 1.32880985736847, 1.33338522911072, 1.3379682302475, 1.34255826473236, 1.34715700149536, 1.35176336765289, 1.35637760162354, 1.36099898815155, 1.36562860012054, 1.37026631832123, 1.37491118907928, 1.37956464290619, 1.38425779342651, 1.38936281204224, 1.39445781707764, 1.39954304695129, 1.40462040901184, 1.40968763828278, 1.4147469997406, 1.41979849338531, 1.42483806610107, 1.42987048625946, 1.43489336967468, 1.4399071931839, 1.44491279125214, 1.44990861415863, 1.45489549636841, 1.45987236499786, 1.4648425579071, 1.46980166435242, 1.47475290298462, 1.47969496250153, 1.48462724685669, 1.48955154418945, 1.49446594715118, 1.4993724822998, 1.5042690038681, 1.50915575027466, 1.51403522491455, 1.51890504360199, 1.52376592159271, 1.52861678600311, 1.5334597826004, 1.53829371929169, 1.54311764240265, 1.54793393611908, 1.55274021625519, 1.55753767490387, 1.56232583522797, 1.56710612773895, 1.57187676429749, 1.57663714885712, 1.58139073848724, 1.58613348007202, 1.59086835384369, 1.59559392929077, 1.6003098487854, 1.60501766204834, 1.60971570014954, 1.61440551280975, 1.6190859079361, 1.62375700473785, 1.6284202337265, 1.63307249546051, 1.6377170085907, 1.64235150814056, 1.64697802066803, 1.6515965461731, 1.65620315074921, 1.66080367565155, 1.6653927564621, 1.66997444629669, 1.67454636096954, 1.67910945415497, 1.68366420269012, 1.68820917606354, 1.6927444934845, 1.69727182388306, 1.70178925991058, 1.70629835128784, 1.71079885959625, 1.71529030799866, 1.71977090835571, 1.72424459457397, 1.72864103317261, 1.73304963111877, 1.73742032051086, 1.74174773693085, 1.74604439735413, 1.75030112266541, 1.75451803207397, 1.75869798660278, 1.76284003257751, 1.76694309711456, 1.77101016044617, 1.77503728866577, 1.77902925014496, 1.78298318386078, 1.7868971824646, 1.790771484375, 1.79461252689362, 1.79841434955597, 1.80217671394348, 1.80590176582336, 1.80958724021912, 1.81323909759521, 1.8168511390686, 1.82042443752289, 1.8239598274231, 1.82745885848999, 1.83091747760773, 1.83434057235718, 1.83772575855255, 1.84107112884521, 1.84438133239746, 1.84764897823334, 1.85088407993317, 1.85407853126526, 1.85723674297333, 1.86035418510437, 1.86343467235565, 1.86648106575012, 1.8694863319397, 1.87245297431946, 1.8753833770752, 1.87827479839325, 1.88112831115723, 1.88394582271576, 1.88672256469727, 1.88946306705475, 1.89216637611389, 1.89482915401459, 1.89745569229126, 1.90004336833954, 1.90259504318237, 1.90510952472687, 1.90758168697357, 1.91002011299133, 1.91242158412933, 1.91477966308594, 1.9171050786972, 1.91939091682434, 1.92163681983948, 1.92384934425354, 1.92602014541626, 1.92815220355988, 1.93025088310242, 1.93230772018433, 1.93432581424713, 1.93631148338318, 1.93825447559357, 1.94016134738922, 1.94203293323517, 1.94386029243469, 1.94565236568451, 1.94731509685516, 1.94871830940247, 1.950070977211, 1.95135676860809, 1.95258808135986, 1.95376181602478, 1.95487582683563, 1.95593178272247, 1.9569354057312, 1.95787572860718, 1.95875823497772, 1.95958280563354, 1.96034598350525, 1.96105670928955, 1.96170949935913, 1.9623007774353, 1.96283614635468, 1.96331691741943, 1.96373283863068, 1.96409642696381, 1.96439290046692, 1.96464252471924, 1.96483063697815, 1.96495723724365, 1.96502768993378, 1.9650422334671, 1.96499514579773, 1.96489012241364, 1.96473479270935, 1.96451246738434, 1.96423745155334, 1.9638956785202, 1.96350681781769, 1.96305656433105, 1.9625449180603, 1.96197879314423, 1.96135318279266, 1.9606659412384, 1.95992457866669, 1.95912885665894, 1.95826828479767, 1.95735669136047, 1.95638203620911, 1.95534944534302, 1.95425713062286, 1.95311260223389, 1.95190811157227, 1.95064425468445, 1.94931876659393, 1.94794070720673, 1.94650495052338, 1.94500589370728, 1.94345605373383, 1.94184494018555, 1.94017231464386, 1.93844521045685, 1.93665850162506, 1.93481409549713, 1.93291342258453, 1.93095171451569, 1.92893517017365, 1.92686104774475, 1.92472171783447, 1.92253363132477, 1.92028605937958, 1.91797482967377, 1.91560781002045, 1.91318643093109, 1.91070187091827, 1.90816640853882, 1.90556263923645, 1.90290975570679, 1.89960300922394, 1.89606690406799, 1.89248096942902, 1.88884711265564, 1.88516438007355, 1.88143563270569, 1.87765979766846, 1.87383151054382, 1.86996173858643, 1.86603677272797, 1.86206829547882, 1.85805201530457, 1.85398602485657, 1.84987020492554, 1.84570932388306, 1.84150052070618, 1.83724093437195, 1.83293509483337, 1.82858169078827, 1.8241810798645, 1.81972897052765, 1.8152334690094, 1.81068468093872, 1.80609428882599, 1.80144929885864, 1.79676139354706, 1.79202258586884, 1.78723692893982, 1.78240156173706, 1.77751529216766, 1.77258944511414, 1.76760756969452, 1.76258563995361, 1.75750780105591, 1.75238752365112, 1.74721479415894, 1.74199962615967, 1.73673021793365, 1.73141813278198, 1.72605288028717, 1.72064054012299, 1.71518385410309, 1.70967662334442, 1.7041232585907, 1.6985182762146, 1.69286906719208, 1.68716740608215, 1.68142056465149, 1.67562484741211, 1.66978573799133, 1.66389405727386, 1.65795564651489, 1.65196633338928, 1.64592921733856, 1.63984608650208, 1.63371574878693, 1.62753772735596, 1.6213071346283, 1.61503565311432, 1.60871016979218, 1.60233950614929, 1.5959198474884, 1.58945417404175, 1.58293616771698, 1.57637083530426, 1.56975877285004, 1.56310141086578, 1.55639433860779, 1.54964017868042, 1.54283344745636, 1.53597986698151, 1.52882254123688, 1.52127349376678, 1.51372826099396, 1.50618135929108, 1.49864065647125, 1.49109899997711, 1.48356008529663, 1.47601926326752, 1.46848571300507, 1.46094870567322, 1.45341956615448, 1.44588434696198, 1.43835628032684, 1.43082821369171, 1.42330634593964, 1.41577839851379, 1.40825843811035, 1.40073657035828, 1.39321851730347, 1.38569939136505, 1.37818670272827, 1.37067306041718, 1.36315953731537, 1.35564780235291, 1.34814214706421, 1.34063220024109, 1.33312940597534, 1.32562398910522, 1.31812298297882, 1.3106210231781, 1.30312466621399, 1.29562997817993, 1.28813445568085, 1.28063809871674, 1.27314972877502, 1.2656614780426, 1.25817131996155, 1.25068390369415, 1.24319922924042, 1.235720038414, 1.22823715209961, 1.22075605392456, 1.21327948570251, 1.2058002948761, 1.19833087921143, 1.19085621833801, 1.18338513374329, 1.17591309547424, 1.16844820976257, 1.16098523139954, 1.15352046489716, 1.14605748653412, 1.13859534263611, 1.13113963603973, 1.12368202209473, 1.11622905731201, 1.108771443367, 1.10132205486298, 1.09387183189392, 1.08642327785492, 1.07897651195526, 1.07153069972992, 1.06408667564392, 1.0566463470459, 1.04920589923859, 1.04176557064056, 1.03433156013489, 1.0268965959549, 1.01946520805359, 1.01203298568726, 1.00460255146027, 0.997176587581635, 0.990908145904541, 0.984651386737823, 0.978437900543213, 0.972262501716614, 0.966123223304749, 0.96002197265625, 0.953958511352539, 0.94793689250946, 0.941949486732483, 0.936001896858215, 0.930094122886658, 0.924218773841858, 0.918388724327087, 0.912593066692352, 0.906835377216339, 0.901115596294403, 0.895439326763153, 0.88979184627533, 0.884187877178192, 0.878623604774475, 0.873090207576752, 0.867605447769165, 0.862151503562927, 0.856737434864044, 0.851361274719238, 0.84602302312851, 0.840724647045135, 0.83546245098114, 0.830238163471222, 0.825053632259369, 0.819907248020172, 0.814800441265106, 0.809729933738708, 0.804697275161743, 0.799700915813446, 0.794746160507202, 0.789827466011047, 0.784946739673615, 0.780107736587524, 0.775301098823547, 0.770534336566925, 0.765811026096344, 0.761118352413177, 0.756469190120697, 0.751856088638306, 0.747281074523926, 0.742747664451599, 0.73824667930603, 0.733783721923828, 0.729365944862366, 0.724980771541595, 0.720631718635559, 0.716327965259552, 0.712054789066315, 0.707825183868408, 0.703631579875946, 0.699476063251495, 0.695362150669098, 0.691280782222748, 0.687237322330475, 0.683239102363586, 0.679271638393402, 0.675347566604614, 0.67145961523056, 0.66760790348053, 0.663797795772552, 0.660022020339966, 0.6562859416008, 0.652591526508331, 0.648933291435242, 0.645307600498199, 0.642059922218323, 0.639115035533905, 0.63619863986969, 0.633313477039337, 0.630447268486023, 0.627609550952911, 0.624802112579346, 0.622015476226807, 0.619256854057312, 0.616522192955017, 0.613817393779755, 0.611133873462677, 0.608480095863342, 0.605851292610168, 0.603246808052063, 0.600671291351318, 0.598118364810944, 0.595590353012085, 0.593095302581787, 0.590619266033173, 0.588173449039459, 0.58575028181076, 0.583357453346252, 0.580986261367798, 0.578640818595886, 0.576326191425323, 0.574033677577972, 0.571769177913666, 0.569529116153717, 0.567317545413971, 0.565126717090607, 0.562964916229248, 0.560831546783447, 0.558718979358673, 0.55663937330246, 0.554579198360443, 0.552544414997101, 0.550541698932648, 0.548560678958893, 0.546607196331024, 0.54467910528183, 0.542779445648193, 0.540900111198425, 0.539050221443176, 0.537228763103485, 0.535428106784821, 0.533659994602203, 0.531910836696625, 0.530192971229553, 0.528497219085693, 0.526827216148376, 0.525187075138092, 0.523569524288177, 0.521978676319122, 0.520416259765625, 0.518874168395996, 0.517365992069244, 0.515876412391663, 0.514418423175812, 0.512984037399292, 0.511572599411011, 0.51019150018692, 0.508834779262543, 0.507506132125854, 0.506198704242706, 0.504924237728119, 0.503668367862701, 0.502439141273499, 0.501243829727173, 0.500065743923187, 0.498917877674103, 0.497729063034058, 0.496229946613312, 0.494740128517151, 0.493257254362106, 0.491780787706375, 0.490313529968262, 0.488852620124817, 0.487399876117706, 0.485954582691193, 0.484515309333801, 0.483084917068481, 0.481662720441818, 0.480246782302856, 0.478838294744492, 0.477438002824783, 0.47604513168335, 0.474658787250519, 0.473280370235443, 0.471909880638123, 0.470546871423721, 0.46919110417366, 0.467842489480972, 0.466502070426941, 0.465169131755829, 0.463842481374741, 0.462524890899658, 0.4612135887146, 0.459910035133362, 0.458614826202393, 0.457325905561447, 0.456045210361481, 0.454772114753723, 0.45350581407547, 0.452246993780136, 0.450996279716492, 0.449752867221832, 0.448517292737961, 0.447288334369659, 0.446067482233047, 0.444853633642197, 0.443647921085358, 0.442449241876602, 0.441258460283279, 0.440074652433395, 0.438898086547852, 0.437729716300964, 0.436568289995193, 0.435415238142014, 0.434269219636917, 0.433130443096161, 0.431998878717422, 0.430875658988953, 0.429758995771408, 0.428651183843613, 0.427549242973328, 0.426455855369568, 0.425370395183563, 0.424291282892227, 0.42321965098381, 0.422156095504761, 0.421100050210953, 0.420050501823425, 0.419009357690811, 0.417975932359695, 0.416948765516281, 0.415930211544037, 0.414918720722198, 0.41391509771347, 0.41291868686676, 0.411929070949554, 0.410948276519775, 0.409974724054337, 0.408964335918427, 0.407889246940613, 0.406817406415939, 0.405748426914215, 0.404682397842407, 0.403619349002838, 0.402559667825699, 0.401502966880798, 0.400449126958847, 0.399398267269135, 0.398350566625595, 0.397306263446808, 0.396264433860779, 0.395226210355759, 0.394190460443497, 0.393158137798309, 0.392128556966782, 0.391102075576782, 0.390079259872437, 0.389058440923691, 0.388041496276855, 0.387027472257614, 0.386016815900803, 0.385008692741394, 0.384003520011902, 0.383001923561096, 0.382002770900726, 0.381006866693497, 0.380013853311539, 0.379023998975754, 0.378037333488464, 0.377053409814835, 0.37607279419899, 0.375095427036285, 0.374120742082596, 0.373149216175079, 0.372180849313736, 0.371215462684631, 0.370253175497055, 0.369293630123138, 0.368337213993073, 0.367383807897568, 0.36643373966217, 0.365486621856689, 0.364542454481125, 0.36360165476799, 0.362663418054581, 0.361728489398956, 0.360796540975571, 0.359867721796036, 0.358941614627838, 0.358018696308136, 0.357099175453186, 0.356182336807251, 0.355268657207489, 0.354357928037643, 0.353450626134872, 0.352546006441116, 0.351644515991211, 0.350746273994446, 0.349850684404373, 0.348958253860474, 0.348069250583649, 0.347182720899582, 0.346299588680267, 0.345419377088547, 0.344542324542999, 0.343668222427368, 0.342797100543976, 0.341929048299789, 0.341064691543579, 0.340175986289978, 0.339277476072311, 0.338382363319397, 0.33748996257782, 0.336600035429001, 0.335713505744934, 0.334829211235046, 0.333948135375977, 0.333069503307343, 0.332193821668625, 0.331321060657501, 0.330451041460037, 0.329583495855331, 0.328719317913055, 0.327857881784439, 0.326998949050903, 0.326142907142639, 0.325289845466614, 0.324439465999603, 0.323591589927673, 0.322747349739075, 0.321905106306076, 0.321065843105316, 0.320229470729828, 0.319396078586578, 0.318564891815186, 0.31773716211319, 0.316912561655045, 0.316089749336243, 0.315270602703094, 0.314453661441803, 0.313639938831329, 0.312828660011292, 0.312020361423492, 0.311214745044708, 0.310412287712097, 0.309612095355988, 0.30881530046463, 0.308021008968353, 0.30722963809967, 0.306441426277161, 0.305655479431152, 0.30487272143364, 0.304092198610306, 0.303314834833145, 0.302539944648743, 0.301768720149994, 0.300999253988266, 0.300233453512192, 0.299469411373138, 0.298709481954575, 0.297951102256775, 0.297196567058563, 0.296444773674011, 0.295695006847382, 0.294948846101761, 0.294204711914062, 0.293464422225952, 0.292725712060928, 0.291991084814072, 0.291258007287979, 0.29052859544754, 0.289801418781281, 0.289077401161194, 0.288356125354767, 0.287637770175934, 0.286922574043274, 0.286209404468536, 0.28549987077713, 0.284792333841324, 0.284088253974915, 0.283386141061783, 0.282721370458603, 0.282061338424683, 0.281404227018356, 0.280749171972275, 0.280097723007202, 0.279447853565216, 0.278801381587982, 0.278157591819763, 0.277515858411789, 0.27687731385231, 0.27624100446701, 0.275607854127884, 0.274976968765259, 0.27434903383255, 0.273723125457764, 0.27310037612915, 0.272480130195618, 0.271862804889679, 0.271247506141663, 0.270635634660721, 0.270026206970215, 0.269418865442276, 0.268814831972122, 0.268213361501694, 0.267614126205444, 0.267017602920532, 0.266424268484116, 0.265832930803299, 0.265244543552399, 0.264658421278, 0.264075934886932, 0.263495415449142, 0.262917429208755, 0.262342393398285, 0.261769831180573, 0.261199980974197, 0.260632365942001, 0.260068446397781, 0.259506046772003, 0.258947044610977, 0.25839027762413, 0.257836490869522, 0.257284939289093, 0.25673633813858, 0.256190448999405, 0.25564706325531, 0.255106151103973, 0.254568159580231, 0.254032671451569, 0.253499895334244, 0.252969801425934, 0.252442002296448, 0.251917570829391, 0.251395225524902, 0.250875562429428, 0.250358372926712, 0.249844819307327, 0.249333262443542, 0.248824015259743, 0.248317882418633, 0.247814044356346, 0.247313126921654, 0.246814504265785, 0.246319234371185, 0.245826035737991, 0.245335504412651, 0.24484771490097, 0.244362860918045, 0.243880018591881, 0.243400603532791, 0.242923423647881, 0.242440775036812, 0.241978451609612, 0.241517394781113, 0.241056933999062, 0.240598484873772, 0.24014051258564, 0.239684134721756, 0.239228814840317, 0.238774716854095, 0.238321736454964, 0.237869918346405, 0.237419247627258, 0.236969500780106, 0.236521378159523, 0.236074537038803, 0.235628381371498, 0.235183790326118, 0.234740033745766, 0.23429761826992, 0.233856096863747, 0.233416169881821, 0.232977345585823, 0.23253969848156, 0.232103139162064, 0.23166786134243, 0.23123362660408, 0.230800360441208, 0.230368673801422, 0.229938074946404, 0.22950841486454, 0.229080304503441, 0.228652805089951, 0.228227198123932, 0.227802187204361, 0.227378532290459, 0.226956367492676, 0.226534947752953, 0.226114675402641, 0.225695550441742, 0.225277975201607, 0.224861279129982, 0.224446058273315, 0.224031865596771, 0.223618671298027, 0.223206862807274, 0.222795993089676, 0.222386479377747, 0.221977889537811, 0.221570745110512, 0.221164986491203, 0.220759853720665, 0.220356225967407, 0.219953820109367, 0.219552516937256, 0.219152197241783, 0.218753233551979, 0.218355521559715, 0.217958584427834, 0.217563465237617, 0.217168852686882, 0.216775760054588, 0.216383710503578, 0.215993210673332, 0.215603694319725, 0.215215235948563, 0.214827850461006, 0.214441448450089, 0.214056819677353, 0.213673010468483, 0.21329054236412, 0.212909266352654, 0.212529003620148, 0.212106823921204, 0.211685016751289, 0.211263909935951, 0.210843309760094, 0.210423544049263, 0.210004240274429, 0.20958548784256, 0.209167316555977, 0.208749815821648, 0.208332940936089, 0.207916632294655, 0.207501009106636, 0.207085818052292, 0.206671267747879, 0.206257373094559, 0.205844163894653, 0.205431371927261, 0.205019399523735, 0.204607963562012, 0.204196959733963, 0.203786686062813, 0.203377097845078, 0.202967911958694, 0.202559396624565, 0.202151566743851, 0.201744422316551, 0.201337710022926, 0.20093184709549, 0.200526162981987, 0.200121253728867, 0.199717089533806, 0.19931361079216, 0.198910355567932, 0.198507890105247, 0.198106110095978, 0.197704821825027, 0.197304338216782, 0.196904227137566, 0.196504786610603, 0.196105927228928, 0.195707693696022, 0.195310086011887, 0.194912925362587, 0.194516733288765, 0.194120839238167, 0.193725660443306, 0.193331196904182, 0.192937046289444, 0.19254344701767, 0.192150920629501, 0.191758513450623, 0.191367015242577, 0.190976291894913, 0.1905857026577, 0.190195947885513, 0.189806774258614, 0.189418211579323, 0.189030081033707, 0.188642770051956, 0.18825601041317, 0.187869802117348, 0.187484189867973, 0.187099367380142, 0.186714857816696, 0.186331257224083, 0.185947954654694, 0.185565561056137, 0.185183420777321, 0.184802338480949, 0.184421345591545, 0.184041246771812, 0.18367001414299, 0.183285623788834, 0.182902500033379, 0.182521268725395, 0.182140827178955, 0.181762129068375, 0.181385189294815, 0.18100905418396, 0.180634498596191, 0.18026165664196, 0.179889932274818, 0.179519563913345, 0.17915078997612, 0.178783684968948, 0.178417265415192, 0.17805290222168, 0.177689641714096, 0.17732797563076, 0.176967889070511, 0.176608711481094, 0.176251113414764, 0.175895109772682, 0.175540328025818, 0.175186693668365, 0.174835205078125, 0.174484848976135, 0.174135506153107, 0.173787727952003, 0.173441752791405, 0.173096939921379, 0.172753348946571, 0.172411367297173, 0.172070950269699, 0.171731650829315, 0.17139407992363, 0.171057716012001, 0.170722723007202, 0.170389428734779, 0.170057147741318, 0.169726446270943, 0.169397220015526, 0.16906912624836, 0.168742388486862, 0.168417423963547, 0.168093755841255, 0.167771875858307, 0.167451128363609, 0.16713173687458, 0.166813254356384, 0.166497007012367, 0.166181683540344, 0.165868043899536, 0.165555313229561, 0.165244847536087, 0.164935275912285, 0.164627075195312, 0.164320230484009, 0.16401506960392, 0.163711279630661, 0.16340871155262, 0.163107633590698, 0.162807777523994, 0.162509635090828, 0.16221284866333, 0.16191740334034, 0.16162334382534, 0.161330834031105, 0.161039352416992, 0.160749688744545, 0.160461708903313, 0.160174638032913, 0.159896329045296, 0.15966372191906, 0.159431993961334, 0.159200742840767, 0.158971071243286, 0.158741846680641, 0.158513978123665, 0.158286586403847, 0.158060729503632, 0.157835125923157, 0.15761111676693, 0.157387763261795, 0.157165080308914, 0.156943783164024, 0.156723394989967, 0.156504318118095, 0.156285285949707, 0.156068041920662, 0.155850782990456, 0.155635342001915, 0.155420631170273, 0.155206993222237, 0.154993817210197, 0.154782220721245, 0.154570862650871, 0.154361292719841, 0.154152199625969, 0.15394401550293, 0.153736710548401, 0.153530761599541, 0.153325513005257, 0.153121143579483, 0.15291790664196, 0.152715593576431, 0.152514189481735, 0.152313426136971, 0.152114048600197, 0.151915341615677, 0.151717990636826, 0.151521310210228, 0.151325568556786, 0.151130467653275, 0.150936961174011, 0.150744363665581, 0.150551989674568, 0.150361180305481, 0.150170832872391, 0.149982318282127, 0.149793773889542, 0.149606809020042, 0.14942030608654, 0.149235382676125, 0.149050697684288, 0.148867592215538, 0.148685157299042, 0.148503854870796, 0.148323476314545, 0.148143753409386, 0.147965371608734, 0.147787466645241, 0.147610917687416, 0.147435069084167, 0.147260546684265, 0.147086471319199, 0.146913751959801, 0.146741718053818, 0.146570816636086, 0.146401032805443, 0.146231725811958, 0.146063536405563, 0.145896479487419, 0.145730301737785, 0.145541340112686, 0.145361736416817, 0.145181313157082, 0.145000487565994, 0.14481920003891, 0.144637197256088, 0.144454762339592, 0.144271776080132, 0.144087865948677, 0.143903970718384, 0.14371894299984, 0.143533557653427, 0.14334774017334, 0.143161252140999, 0.142974182963371, 0.142786309123039, 0.142598122358322, 0.14240936934948, 0.142220035195351, 0.142030149698257, 0.141839697957039, 0.141648665070534, 0.141456738114357, 0.141264602541924, 0.141071870923042, 0.140878483653069, 0.140684634447098, 0.140490099787712, 0.140294775366783, 0.140099242329597, 0.139903023838997, 0.139706254005432, 0.13950902223587, 0.139311105012894, 0.139112621545792, 0.138913348317146, 0.138713851571083, 0.138513565063477, 0.138312816619873, 0.138111516833305, 0.137909531593323, 0.137707188725471, 0.137503981590271, 0.137300282716751, 0.137096062302589, 0.136891350150108, 0.136685967445374, 0.136480152606964, 0.13627353310585, 0.136066451668739, 0.135858803987503, 0.135650619864464, 0.135441869497299, 0.135232523083687, 0.13502262532711, 0.13481193780899, 0.134601026773453, 0.134389325976372, 0.134177178144455, 0.133964449167252, 0.133751034736633, 0.13353718817234, 0.133322536945343, 0.133107557892799, 0.132891908288002, 0.132675796747208, 0.132458999752998, 0.132241770625114, 0.132023841142654, 0.131805121898651, 0.131586194038391, 0.131370574235916, 0.13110277056694, 0.130834862589836, 0.13056655228138, 0.130297660827637, 0.130028516054153, 0.129759013652802, 0.129489123821259, 0.129218772053719, 0.128948032855988, 0.128677055239677, 0.128405421972275, 0.128133550286293, 0.127861395478249, 0.127589017152786, 0.127316012978554, 0.12704262137413, 0.126768946647644, 0.126494631171227, 0.126220121979713, 0.12594535946846, 0.125670149922371, 0.125394493341446, 0.125118613243103, 0.124841876327991, 0.12456513941288, 0.124288015067577, 0.124010547995567, 0.123732641339302, 0.123454384505749, 0.123175717890263, 0.122896514832973, 0.122617125511169, 0.122337281703949, 0.122057229280472, 0.121776588261127, 0.121495738625526, 0.121214427053928, 0.120932437479496, 0.120650336146355, 0.120367892086506, 0.12008511275053, 0.119801893830299, 0.1195183172822, 0.119234077632427, 0.118949718773365, 0.118665009737015, 0.1183797493577, 0.118094369769096, 0.117808550596237, 0.117522217333317, 0.117235422134399, 0.116948343813419, 0.116660930216312, 0.11637307703495, 0.116085037589073, 0.115796335041523, 0.115507505834103, 0.115217939019203, 0.114928215742111, 0.114638090133667, 0.114347860217094, 0.114056937396526, 0.113765679299831, 0.113473877310753, 0.113181926310062, 0.112889721989632, 0.112596824765205, 0.112303763628006, 0.11201024800539, 0.111716344952583, 0.111421927809715, 0.111128494143486, 0.110852845013142, 0.110577873885632, 0.11030350625515, 0.110029883682728, 0.109756715595722, 0.109484277665615, 0.109212294220924, 0.108941271901131, 0.108670763671398, 0.108400754630566, 0.108131535351276, 0.107862778007984, 0.107594922184944, 0.107327573001385, 0.107060775160789, 0.106794513761997, 0.106528967618942, 0.106264218688011, 0.106000304222107, 0.105736523866653, 0.105473637580872, 0.105211369693279, 0.104949675500393, 0.104688487946987, 0.104428417980671, 0.104168586432934, 0.103909313678741, 0.103650838136673, 0.103392869234085, 0.103135861456394, 0.102879367768764, 0.102623261511326, 0.10236794501543, 0.102113083004951, 0.101859301328659, 0.101605840027332, 0.101353026926517, 0.10110092908144, 0.100849293172359, 0.100598379969597, 0.100348331034184, 0.100098721683025, 0.0998496264219284, 0.0996010974049568, 0.0993534624576569, 0.0991064012050629, 0.0988601297140121, 0.0986142009496689, 0.0983689352869987, 0.098124586045742, 0.0978806465864182, 0.0976372435688972, 0.0973949357867241, 0.0971528440713882, 0.0969114899635315, 0.0966706350445747, 0.0964306518435478, 0.0961911603808403, 0.0959523990750313, 0.0957142040133476, 0.095476470887661, 0.0952395796775818, 0.0950034111738205, 0.0947677120566368, 0.0945326238870621, 0.0942982286214828, 0.0940644517540932, 0.0938312858343124, 0.0935990288853645, 0.0933669954538345, 0.0931329727172852, 0.0929140448570251, 0.0926958099007607, 0.0924784690141678, 0.0922618061304092, 0.0920461639761925, 0.0918309763073921, 0.0916169062256813, 0.0914036333560944, 0.0911908224225044, 0.0909794718027115, 0.090768575668335, 0.0905585959553719, 0.0903491601347923, 0.090141087770462, 0.0899333581328392, 0.0897268652915955, 0.0895209386944771, 0.0893158093094826, 0.0891114622354507, 0.0889083668589592, 0.0887057259678841, 0.0885037630796432, 0.0883029103279114, 0.0881026461720467, 0.0879035070538521, 0.0877050459384918, 0.0875074788928032, 0.087310366332531, 0.0871147364377975, 0.0869193151593208, 0.0867250263690948, 0.0865316614508629, 0.0863388404250145, 0.0861468240618706, 0.0859558135271072, 0.0857656076550484, 0.0855760648846626, 0.0853877738118172, 0.0851999372243881, 0.0850129947066307, 0.0848267525434494, 0.0846418440341949, 0.0844573974609375, 0.0842738449573517, 0.0840908661484718, 0.0839089080691338, 0.0837277323007584, 0.0835476890206337, 0.0833677649497986, 0.0831891819834709, 0.0830114111304283, 0.0828341916203499, 0.0826581045985222, 0.0824826955795288, 0.0823082998394966, 0.0821344777941704, 0.0819617882370949, 0.0817893072962761, 0.0816181972622871, 0.0814478769898415, 0.0812783464789391, 0.081109382212162, 0.0809414312243462, 0.0807743892073631, 0.0806079059839249, 0.0804427862167358, 0.0802778899669647, 0.0801141262054443, 0.0799509212374687, 0.0797890722751617, 0.0796277970075607, 0.0794780924916267, 0.0793268904089928, 0.0791761800646782, 0.0790258049964905, 0.0788760557770729, 0.0787265822291374, 0.0785775408148766, 0.0784292295575142, 0.0782809108495712, 0.0781333968043327, 0.0779861882328987, 0.0778395980596542, 0.0776931792497635, 0.0775474905967712, 0.0774020105600357, 0.0772570893168449, 0.0771125108003616, 0.0769684314727783, 0.0768246725201607, 0.0766815021634102, 0.0765388682484627, 0.0763963758945465, 0.0762546509504318, 0.0761131197214127, 0.0759723260998726, 0.0758316665887833, 0.0756914690136909, 0.0755519941449165, 0.0754128694534302, 0.0752741023898125, 0.0751358568668365, 0.0749979764223099, 0.0748605951666832, 0.0747236683964729, 0.0745869725942612, 0.0744510367512703, 0.0743153244256973, 0.0741800963878632, 0.0740452110767365, 0.0739109367132187, 0.0737771764397621, 0.0736438408493996, 0.0735107287764549, 0.0733783841133118, 0.0732460916042328, 0.0731145888566971, 0.0729833766818047, 0.0728524699807167, 0.0727222412824631, 0.0725923180580139, 0.0724629983305931, 0.0723339840769768, 0.0722055062651634, 0.0720774531364441, 0.0719496011734009, 0.0718225091695786, 0.0716958418488503, 0.071569487452507, 0.0714436620473862, 0.0713180974125862, 0.0711930692195892, 0.0710686892271042, 0.0709444209933281, 0.0708209499716759, 0.070697695016861, 0.0705749541521072, 0.0704525336623192, 0.0703306049108505, 0.0702093318104744, 0.0700884610414505, 0.0699678659439087, 0.0698493495583534, 0.0697202533483505, 0.0695912465453148, 0.0694622695446014, 0.0693333819508553, 0.069204568862915, 0.0690757930278778, 0.0689470171928406, 0.0688183605670929, 0.0686898157000542, 0.068561278283596, 0.0684328451752663, 0.0683044716715813, 0.0681760981678963, 0.0680478289723396, 0.0679196193814278, 0.0677914842963219, 0.0676634162664413, 0.0675354227423668, 0.0674074664711952, 0.067279540002346, 0.0671517327427864, 0.0670239999890327, 0.0668963044881821, 0.0667686760425568, 0.0666410848498344, 0.0665135607123375, 0.0663861408829689, 0.0662587210536003, 0.0661314353346825, 0.0660042017698288, 0.0658770129084587, 0.0657498762011528, 0.0656228139996529, 0.0654957890510559, 0.0653688982129097, 0.0652420222759247, 0.0651152059435844, 0.0649884715676308, 0.0648617893457413, 0.0647351369261742, 0.0646086037158966, 0.0644820928573608, 0.0643557012081146, 0.0642293244600296, 0.0641030371189117, 0.0639767497777939, 0.0638505816459656, 0.063724510371685, 0.0635984763503075, 0.0634724125266075, 0.0633465647697449, 0.063220702111721, 0.063094861805439, 0.0629691630601883, 0.0628435090184212, 0.0627178996801376, 0.0625923499464989, 0.06246692314744, 0.0623414255678654, 0.062216117978096, 0.0620908513665199, 0.0619656331837177, 0.0618404224514961, 0.0617153234779835, 0.0615903660655022, 0.0614653490483761, 0.0613404586911201, 0.0612156428396702, 0.0610908567905426, 0.0609660930931568, 0.0608535781502724, 0.0607133917510509, 0.0605735518038273, 0.0604340508580208, 0.0602948740124702, 0.0601561702787876, 0.0600177906453609, 0.0598798803985119, 0.0597423017024994, 0.0596051700413227, 0.0594683736562729, 0.0593319125473499, 0.0591957941651344, 0.0590601377189159, 0.0589246973395348, 0.0587897337973118, 0.0586551986634731, 0.0585210025310516, 0.0583872571587563, 0.0582537390291691, 0.0581207983195782, 0.0579883083701134, 0.0578559152781963, 0.057723980396986, 0.0575925000011921, 0.0574614591896534, 0.0573306791484356, 0.0572003275156021, 0.0570702143013477, 0.0569406487047672, 0.0568114258348942, 0.0566825345158577, 0.0565541163086891, 0.0564260222017765, 0.0562983825802803, 0.0561710894107819, 0.0560442507266998, 0.0559176281094551, 0.0557914525270462, 0.0556657500565052, 0.0555403679609299, 0.0554149858653545, 0.0552905201911926, 0.0551662668585777, 0.05504235252738, 0.0549186840653419, 0.0547955594956875, 0.0546729080379009, 0.0545505732297897, 0.0544285923242569, 0.0543069392442703, 0.0541857555508614, 0.0540648996829987, 0.0539442636072636, 0.0538241900503635, 0.0537045821547508, 0.0535851940512657, 0.0534662678837776, 0.0533477924764156, 0.0532296486198902, 0.0531118363142014, 0.0529943630099297, 0.0528774708509445, 0.0527607947587967, 0.0526444688439369, 0.0525285750627518, 0.0524129197001457, 0.0522977076470852, 0.0521829575300217, 0.0520686693489552, 0.0519547164440155, 0.0518409721553326, 0.0517335496842861, 0.0516500845551491, 0.0515668988227844, 0.051484115421772, 0.0514016225934029, 0.0513194985687733, 0.0512376315891743, 0.0511558279395103, 0.0510745383799076, 0.0509936213493347, 0.0509129762649536, 0.0508327446877956, 0.0507527701556683, 0.0506731867790222, 0.0505937673151493, 0.0505147390067577, 0.0504361316561699, 0.0503577515482903, 0.050279650837183, 0.0502017103135586, 0.0501242913305759, 0.0500471703708172, 0.0499702878296375, 0.0498938001692295, 0.049817580729723, 0.0497417412698269, 0.0496663488447666, 0.0495910607278347, 0.0495161861181259, 0.0494415760040283, 0.0493673495948315, 0.0492934361100197, 0.0492195188999176, 0.0491462536156178, 0.0490732416510582, 0.0490006245672703, 0.0489282831549644, 0.048856258392334, 0.0487845614552498, 0.0487131737172604, 0.04864202439785, 0.048571303486824, 0.0485008619725704, 0.0484306737780571, 0.0483607761561871, 0.0482911206781864, 0.0482219979166985, 0.0481531694531441, 0.0480844639241695, 0.0480161570012569, 0.0479482524096966, 0.0478807017207146, 0.0478134863078594, 0.0477465055882931, 0.04767981544137, 0.0476134978234768, 0.0475474484264851, 0.0474817976355553, 0.0474164299666882, 0.0473511293530464, 0.0472864247858524, 0.0472219809889793, 0.0471579656004906, 0.0470940917730331, 0.0470306947827339, 0.0469674803316593, 0.0469046458601952, 0.046841986477375, 0.0467799678444862, 0.0467178337275982, 0.0466563403606415, 0.0465962216258049, 0.0465262904763222, 0.0464560948312283, 0.0463854819536209, 0.0463146045804024, 0.0462434031069279, 0.0461717881262302, 0.0460999235510826, 0.0460275486111641, 0.0459550321102142, 0.0458820872008801, 0.0458088479936123, 0.0457353144884109, 0.0456613749265671, 0.0455871857702732, 0.0455126352608204, 0.0454377382993698, 0.0453624911606312, 0.0452868826687336, 0.045210987329483, 0.0451346561312675, 0.0450580678880215, 0.0449811555445194, 0.0449039787054062, 0.0448263883590698, 0.0447485186159611, 0.0446702726185322, 0.0445916764438152, 0.044512826949358, 0.0444335751235485, 0.0443540215492249, 0.0442740619182587, 0.0441937744617462, 0.0441132672131062, 0.0440323352813721, 0.0439510531723499, 0.0438695214688778, 0.0437876246869564, 0.0437053963541985, 0.0436228401958942, 0.0435399226844311, 0.0434567257761955, 0.0433730483055115, 0.0432891435921192, 0.0432049036026001, 0.0431203655898571, 0.0430355072021484, 0.0429502688348293, 0.0428646951913834, 0.0427788682281971, 0.0426925644278526, 0.0426060333848, 0.0425190776586533, 0.0424317680299282, 0.0423442646861076, 0.0422563664615154, 0.0421681515872478, 0.042079571634531, 0.0419906973838806, 0.0419014357030392, 0.0418118834495544, 0.0417220629751682, 0.0416318140923977, 0.0415412560105324, 0.041450273245573, 0.0413590371608734, 0.0412674471735954, 0.0411755628883839, 0.0410833358764648, 0.0409908443689346, 0.0408979430794716, 0.0408047400414944, 0.040696769952774, 0.0405777581036091, 0.0404587462544441, 0.0403397344052792, 0.0402203872799873, 0.0401013754308224, 0.0399822518229485, 0.0398632399737835, 0.0397438891232014, 0.0396246537566185, 0.0395053029060364, 0.0393859520554543, 0.0392666012048721, 0.0391474813222885, 0.0390280149877071, 0.0389084368944168, 0.038788978010416, 0.0386695116758347, 0.0385498255491257, 0.0384303592145443, 0.0383107848465443, 0.038191094994545, 0.038071408867836, 0.0379517190158367, 0.0378321409225464, 0.0377122238278389, 0.0375925339758396, 0.0374726206064224, 0.0373528189957142, 0.037232905626297, 0.0371129885315895, 0.0369931869208813, 0.0368730463087559, 0.0367531292140484, 0.0366331040859222, 0.0365129597485065, 0.0363928191363811, 0.0362727902829647, 0.0361524261534214, 0.036032285541296, 0.0359121412038803, 0.035791777074337, 0.0356715209782124, 0.0355511531233788, 0.0354307889938354, 0.0353105328977108, 0.0351900532841682, 0.0350695736706257, 0.0349490903317928, 0.0348284989595413, 0.0347080193459988, 0.0345874279737473, 0.0344668328762054, 0.0343460142612457, 0.0342255346477032, 0.0341047123074532, 0.0339840091764927, 0.0338634178042412, 0.0337423719465733, 0.0336217768490314, 0.0335006155073643, 0.0333797968924046, 0.0332587510347366, 0.0331379361450672, 0.0330171175301075, 0.0328958444297314, 0.0327749103307724, 0.0326537527143955, 0.0325327068567276, 0.0324116609990597, 0.0322903916239738, 0.0321804508566856, 0.0320830568671227, 0.0319865085184574, 0.0318897888064384, 0.0317936390638351, 0.0316978804767132, 0.0316021777689457, 0.0315069854259491, 0.0314119942486286, 0.031317338347435, 0.0312229376286268, 0.0311291310936213, 0.0310355219990015, 0.0309420824050903, 0.030849177390337, 0.0307561606168747, 0.0306639950722456, 0.0305717401206493, 0.0304800532758236, 0.0303886476904154, 0.0302974097430706, 0.0302067417651415, 0.0301161799579859, 0.0300260484218597, 0.0299359988421202, 0.0298466831445694, 0.0297573693096638, 0.0296684205532074, 0.029580008238554, 0.0294915158301592, 0.0294035859405994, 0.0293160490691662, 0.0292286574840546, 0.0291417725384235, 0.0290548857301474, 0.0289686229079962, 0.0288824457675219, 0.0287967175245285, 0.0287114717066288, 0.0286263395100832, 0.0285415463149548, 0.028456948697567, 0.0283729489892721, 0.0282888598740101, 0.0282055623829365, 0.0281223822385073, 0.0280393678694963, 0.027956947684288, 0.0278745274990797, 0.0277926158159971, 0.0277108997106552, 0.0276297237724066, 0.0275488570332527, 0.0274680461734533, 0.0273878015577793, 0.0273076426237822, 0.0272280480712652, 0.0271486192941666, 0.0270695928484201, 0.0269908457994461, 0.0269122924655676, 0.0268343109637499, 0.0267564691603184, 0.0266789346933365, 0.0266019385308027, 0.02652483060956, 0.0264484323561192, 0.0263721402734518, 0.0262963883578777, 0.0262205805629492, 0.0261453073471785, 0.0260704886168242, 0.0259840022772551, 0.0259059444069862, 0.0258280038833618, 0.0257502198219299, 0.0256724171340466, 0.0255947876721621, 0.0255171414464712, 0.0254397355020046, 0.0253623183816671, 0.0252850688993931, 0.0252078883349895, 0.025130782276392, 0.0250538419932127, 0.0249769296497107, 0.0249001048505306, 0.0248234067112207, 0.0247468519955873, 0.0246702786535025, 0.0245938766747713, 0.0245175883173943, 0.0244413260370493, 0.024365209043026, 0.0242891442030668, 0.0242132227867842, 0.024137357249856, 0.0240615792572498, 0.023985967040062, 0.0239103697240353, 0.023834889754653, 0.0237595606595278, 0.023684261366725, 0.0236091036349535, 0.0235339999198914, 0.0234589949250221, 0.0233841333538294, 0.0233093146234751, 0.0232345797121525, 0.0231600143015385, 0.0230855066329241, 0.023011052981019, 0.0229367576539516, 0.0228624865412712, 0.0227883607149124, 0.0227142889052629, 0.0226403586566448, 0.0225665308535099, 0.0224928241223097, 0.0224190801382065, 0.0223455596715212, 0.0222721267491579, 0.0221986901015043, 0.0221254527568817, 0.0220522712916136, 0.0219791755080223, 0.0219061654061079, 0.0218332521617413, 0.0217604823410511, 0.0216877516359091, 0.0216151233762503, 0.0215426478534937, 0.0214701890945435, 0.0213978551328182, 0.0213256627321243, 0.021253501996398, 0.0211814921349287, 0.0211095381528139, 0.0210376568138599, 0.0209659468382597, 0.0208942648023367, 0.0208226665854454, 0.0207512080669403, 0.0206676293164492, 0.0205856207758188, 0.0205041877925396, 0.0204227566719055, 0.020341707393527, 0.0202609822154045, 0.0201804134994745, 0.0201000701636076, 0.0200201943516731, 0.0199404563754797, 0.0198608338832855, 0.0197819452732801, 0.0197029151022434, 0.0196241401135921, 0.0195459593087435, 0.0194678902626038, 0.0193899478763342, 0.0193124730139971, 0.0192351378500462, 0.0191580168902874, 0.0190814305096865, 0.0190049298107624, 0.0189288966357708, 0.0188528746366501, 0.0187770798802376, 0.0187017805874348, 0.0186265930533409, 0.0185516607016325, 0.0184772089123726, 0.0184027552604675, 0.0183286722749472, 0.0182551518082619, 0.0181815326213837, 0.0181081537157297, 0.0180352553725243, 0.0179625991731882, 0.017890052869916, 0.0178181007504463, 0.0177461933344603, 0.0176742672920227, 0.0176031365990639, 0.0175320450216532, 0.0174610838294029, 0.0173907987773418, 0.0173204448074102, 0.0172501746565104, 0.0171806383877993, 0.0171111300587654, 0.0170419327914715, 0.0169731322675943, 0.01690430380404, 0.016835855320096, 0.0167678594589233, 0.016700018197298, 0.0166323892772198, 0.016565129160881, 0.0164979938417673, 0.0164312552660704, 0.0163648277521133, 0.0162985287606716, 0.016232818365097, 0.0161668993532658, 0.0161014478653669, 0.0160364601761103, 0.0159714892506599, 0.0159068685024977, 0.015842517837882, 0.0157783925533295, 0.0157146062701941, 0.0156511887907982, 0.0155878970399499, 0.0155355399474502, 0.0154882976785302, 0.0154410833492875, 0.0153943197801709, 0.0153480665758252, 0.0153018422424793, 0.0152558712288737, 0.0152104925364256, 0.0151652852073312, 0.0151204438880086, 0.01507602725178, 0.0150316385552287, 0.014987587928772, 0.0149442739784718, 0.0149008743464947, 0.0148578975349665, 0.0148154590278864, 0.0147729627788067, 0.0147308055311441, 0.0146893281489611, 0.0146479327231646, 0.0146068222820759, 0.0145660787820816, 0.01452561840415, 0.0144854942336679, 0.0144458524882793, 0.0144062964245677, 0.0143671343103051, 0.014328284189105, 0.014289659447968, 0.0142514565959573, 0.0142137091606855, 0.0141761293634772, 0.0141389463096857, 0.0141020156443119, 0.0140652284026146, 0.0140291461721063, 0.013993120752275, 0.0139572378247976, 0.0139221446588635, 0.0138870794326067, 0.0138522693887353, 0.0138180246576667, 0.01378383487463, 0.0137499589473009, 0.0137167014181614, 0.0136834736913443, 0.0136506138369441, 0.0136183453723788, 0.0135860219597816, 0.0135540645569563, 0.0135227590799332, 0.0134913669899106, 0.0134604275226593, 0.0134299686178565, 0.0133995953947306, 0.0133696440607309, 0.0133400894701481, 0.0133107323199511, 0.0132816294208169, 0.0132530629634857, 0.0132246678695083, 0.013196524232626, 0.0131689189001918, 0.0131414551287889, 0.0131142167374492, 0.013087572529912, 0.0130610130727291, 0.0130348773673177, 0.0130092212930322, 0.0129835940897465, 0.0129585331305861, 0.0129294134676456, 0.0129023175686598, 0.0128751350566745, 0.0128479264676571, 0.0128207160159945, 0.012793536297977, 0.0127663258463144, 0.0127391153946519, 0.0127119617536664, 0.0126847801730037, 0.0126575147733092, 0.0126303611323237, 0.0126031516119838, 0.0125759690999985, 0.0125487875193357, 0.0125215500593185, 0.0124943973496556, 0.0124671868979931, 0.0124400053173304, 0.0124128237366676, 0.0123856998980045, 0.0123584615066648, 0.0123312789946795, 0.0123040694743395, 0.0122768888249993, 0.0122497351840138, 0.0122225256636739, 0.0121952584013343, 0.0121681345626712, 0.0121409241110086, 0.0121137425303459, 0.0120865339413285, 0.012059380300343, 0.0120321419090033, 0.0120049603283405, 0.011977749876678, 0.0119505692273378, 0.0119233867153525, 0.0118961790576577, 0.0118690244853497, 0.0118418429046869, 0.0118146324530244, 0.011787480674684, 0.0117602702230215, 0.011733116582036, 0.0117058511823416, 0.0116786677390337, 0.0116514880210161, 0.0116243343800306, 0.0115971239283681, 0.0115698864683509, 0.0115426769480109, 0.0115155233070254, 0.0114883426576853, 0.0114611601457, 0.01143395062536, 0.0114067122340202, 0.0113795585930347, 0.0113524356856942, 0.0113251963630319, 0.0112980436533689, 0.0112708900123835, 0.0112436516210437, 0.0112164411693811, 0.0111892325803638, 0.0111620789393783, 0.0111349252983928, 0.011107686907053, 0.011080477386713, 0.0110532678663731, 0.0110260862857103, 0.0109969275072217, 0.010960703715682, 0.0109243951737881, 0.0108881434425712, 0.0108519224449992, 0.0108156707137823, 0.0107794469222426, 0.010743223130703, 0.0107069434598088, 0.0106706358492374, 0.0106344409286976, 0.010598162189126, 0.0105618815869093, 0.0105256866663694, 0.0104894069954753, 0.0104531273245811, 0.0104168755933642, 0.0103805959224701, 0.0103443451225758, 0.0103081502020359, 0.0102718416601419, 0.0102355629205704, 0.0101993391290307, 0.0101630594581366, 0.0101268077269197, 0.0100905280560255, 0.0100543620064855, 0.0100180534645915, 0.00998183060437441, 0.00994557980448008, 0.00990930013358593, 0.00987310521304607, 0.00983682554215193, 0.00980051700025797, 0.00976432301104069, 0.00972804240882397, 0.00969176273792982, 0.00965553987771273, 0.00961931608617306, 0.00958298053592443, 0.00954675767570734, 0.00951047800481319, 0.00947419833391905, 0.00943800341337919, 0.00940172374248505, 0.00936549995094538, 0.00932922028005123, 0.0092929694801569, 0.00925674568861723, 0.00922052189707756, 0.00918424222618341, 0.00914796255528927, 0.00911171175539494, 0.00907546002417803, 0.00903918035328388, 0.00900295749306679, 0.00896667689085007, 0.00893039721995592, 0.00889414642006159, 0.00885789468884468, 0.00882161594927311, 0.00878539215773344, 0.00874916929751635, 0.00871288869529963, 0.00867672264575958, 0.0086404150351882, 0.00860413536429405, 0.00856788363307714, 0.00853166077286005, 0.0084953811019659, 0.00845915731042624, 0.00842284969985485, 0.00838945340365171, 0.00835797656327486, 0.00832647271454334, 0.00829519424587488, 0.00826405733823776, 0.00823300424963236, 0.00820200890302658, 0.00817115418612957, 0.00814058165997267, 0.00811001006513834, 0.00807966385036707, 0.00804931856691837, 0.00801908504217863, 0.00798913463950157, 0.00795921310782433, 0.00792940333485603, 0.00789973605424166, 0.00787029322236776, 0.00784082338213921, 0.00781146669760346, 0.00778242014348507, 0.00775337452068925, 0.00772455427795649, 0.00769573403522372, 0.00766705442219973, 0.00763857364654541, 0.00761014921590686, 0.00758195063099265, 0.00755372317507863, 0.00752580771222711, 0.00749786291271448, 0.00747014489024878, 0.00744248274713755, 0.00741496309638023, 0.00738766836002469, 0.0073604304343462, 0.00733324838802218, 0.00730629311874509, 0.00727945053949952, 0.00725266523659229, 0.00722602056339383, 0.00719960173591971, 0.00717318337410688, 0.00714701879769564, 0.00712091149762273, 0.00709494482725859, 0.00706909177824855, 0.00704335095360875, 0.00701778056100011, 0.00699220923706889, 0.00696694944053888, 0.0069417180493474, 0.00691665522754192, 0.00689167762175202, 0.00686681363731623, 0.00684214709326625, 0.00681756436824799, 0.00679312413558364, 0.00676876772195101, 0.00674460968002677, 0.00672050751745701, 0.0066964915022254, 0.00667272880673409, 0.00664899405092001, 0.00662548653781414, 0.00660203443840146, 0.00657869596034288, 0.00655558286234736, 0.00653247023001313, 0.00650955503806472, 0.00648669758811593, 0.00646637380123138, 0.00644379807636142, 0.00642133550718427, 0.00639912625774741, 0.00637691840529442, 0.00635490706190467, 0.00633295346051455, 0.00631119683384895, 0.00628949655219913, 0.00626796530559659, 0.00624657701700926, 0.00622527208179235, 0.00620416551828384, 0.00618314370512962, 0.00616223551332951, 0.00614143861457705, 0.00612075626850128, 0.00610030023381114, 0.00607990007847548, 0.00605958374217153, 0.00603943783789873, 0.00601946096867323, 0.00599959818646312, 0.00597981968894601, 0.00596018182113767, 0.00594065757468343, 0.00592130282893777, 0.00590208917856216, 0.00588298868387938, 0.00586391659453511, 0.00584504241123796, 0.00582630932331085, 0.00580771686509252, 0.00578926643356681, 0.00577087234705687, 0.00575264729559422, 0.0057344795204699, 0.00571656599640846, 0.00569867994636297, 0.00568096432834864, 0.00566336093470454, 0.00564587116241455, 0.00562855042517185, 0.00561125809326768, 0.00559422047808766, 0.00557726761326194, 0.00556034222245216, 0.00554372882470489, 0.00552708609029651, 0.00551064126193523, 0.00549431005492806, 0.00547811994329095, 0.00546204252168536, 0.00544605031609535, 0.00543028395622969, 0.00541454553604126, 0.0053989770822227, 0.00538354972377419, 0.00536817917600274, 0.00535303400829434, 0.005337945651263, 0.005323083139956, 0.00530822109431028, 0.00529352808371186, 0.00527897756546736, 0.00526453880593181, 0.00525029795244336, 0.0052360575646162, 0.00522204302251339, 0.00520814163610339, 0.00519429612904787, 0.00518067693337798, 0.00516748195514083, 0.00515355216339231, 0.0051397355273366, 0.00512608839198947, 0.00511261075735092, 0.00509913265705109, 0.0050859097391367, 0.00507285539060831, 0.00505985785275698, 0.00504700187593699, 0.00503431493416429, 0.00502185476943851, 0.00500947888940573, 0.00499721616506577, 0.00498512294143438, 0.00497314287349582, 0.00496130390092731, 0.0049496628344059, 0.00493816286325455, 0.00492674764245749, 0.00491550238803029, 0.00490439776331186, 0.00489343516528606, 0.00488261319696903, 0.00487193278968334, 0.00486144982278347, 0.00485105207189918, 0.00484079541638494, 0.00483067985624075, 0.00482067791745067, 0.00481090135872364, 0.00480121001601219, 0.00479177245870233, 0.00478230696171522, 0.00477301143109798, 0.00476399809122086, 0.00475498428568244, 0.00474619679152966, 0.00473746610805392, 0.00472896173596382, 0.00472062593325973, 0.00471229059621692, 0.0047042379155755, 0.00469624157994986, 0.00468838680535555, 0.00468081468716264, 0.00467318529263139, 0.00466589583083987, 0.00465857749804854, 0.0046514286659658, 0.0046445345506072, 0.00463766884058714, 0.00463102851063013, 0.00462447386234999, 0.0046181445941329, 0.00461184326559305, 0.00460568349808455, 0.0045997784473002, 0.00459395814687014, 0.00458830688148737, 0.00458271242678165, 0.00457737222313881, 0.00457208836451173, 0.00456697400659323, 0.00456205802038312, 0.00455722631886601, 0.00455259252339602, 0.00454798666760325, 0.00454363552853465, 0.00453934073448181, 0.00453524384647608, 0.00453029852360487, 0.00452922470867634, 0.00452832086011767, 0.00452741654589772, 0.00452665379270911, 0.00452605308964849, 0.00452545285224915, 0.00452502211555839, 0.00452462630346417, 0.00452436506748199, 0.00452418113127351, 0.00452404003590345, 0.00452409638091922, 0.00452416017651558, 0.00452442141249776, 0.00452471803873777, 0.00452510640025139, 0.00452555157244205, 0.00452611688524485, 0.00452682329341769, 0.0045275860466063, 0.00452845497056842, 0.00452942261472344, 0.00453047500923276, 0.00453162658959627, 0.00453286990523338, 0.0045342119410634, 0.00453565316274762, 0.00453720707446337, 0.00453879637643695, 0.00454057659953833, 0.00454234937205911, 0.00454422831535339, 0.00454628420993686, 0.00454834662377834, 0.00455060694366693, 0.004552838858217, 0.00455526215955615, 0.00455772737041116, 0.00456027733162045, 0.00456301076337695, 0.00456574466079473, 0.00456865504384041, 0.0045715793967247, 0.0045746099203825, 0.00457777408882976, 0.00458100251853466, 0.00458436459302902, 0.00458781188353896, 0.00459132250398397, 0.00459495326504111, 0.00459868274629116, 0.00460249744355679, 0.0046063894405961, 0.00461040204390883, 0.00461451290175319, 0.00461872294545174, 0.00462296837940812, 0.00462736189365387, 0.00463186157867312, 0.00463643902912736, 0.00464112916961312, 0.00464588310569525, 0.00465077115222812, 0.00465565919876099, 0.00466072419658303, 0.00466590886935592, 0.00467112194746733, 0.00467650452628732, 0.00468189409002662, 0.00468746060505509, 0.00469399429857731, 0.00469851540401578, 0.00470306444913149, 0.00470758508890867, 0.00471212016418576, 0.00471664080396295, 0.00472118984907866, 0.00472572492435575, 0.00473024556413293, 0.00473478063941002, 0.0047393161803484, 0.0047438507899642, 0.00474837142974138, 0.00475290650501847, 0.00475744158029556, 0.00476197665557265, 0.00476651126518846, 0.00477103190496564, 0.00477556698024273, 0.00478010205551982, 0.00478463713079691, 0.00478915777057409, 0.00479369284585118, 0.00479822745546699, 0.00480276253074408, 0.00480729760602117, 0.00481181871145964, 0.00481635378673673, 0.00482087442651391, 0.00482542347162962, 0.0048299441114068, 0.00483447918668389, 0.00483899982646108, 0.00484354887157679, 0.00484808394685388, 0.00485260458663106, 0.00485713966190815, 0.00486166030168533, 0.00486620934680104, 0.00487072998657823, 0.00487526506185532, 0.00487978616729379, 0.0048843352124095, 0.0048888698220253, 0.00489339092746377, 0.00489792600274086, 0.00490244664251804, 0.00490699568763375, 0.00491151679307222, 0.00491605186834931, 0.0049205725081265, 0.00492512155324221, 0.00492965616285801, 0.00493417726829648, 0.00493871234357357, 0.00494324695318937, 0.00494778202846646, 0.00495230313390493, 0.00495683774352074, 0.00496137281879783, 0.00496590742841363, 0.00497044250369072, 0.00497496360912919, 0.00497949821874499, 0.00498403329402208, 0.00498856836929917, 0.00499308947473764, 0.00499762408435345, 0.00500215915963054, 0.00500669376924634, 0.00501122931018472, 0.0050157499499619, 0.00501975510269403, 0.00502312416210771, 0.00502646528184414, 0.00502975704148412, 0.00503300642594695, 0.00503624184057117, 0.00503946980461478, 0.00504263443872333, 0.00504576368257403, 0.00504887197166681, 0.00505195185542107, 0.0050550103187561, 0.00505801942199469, 0.00506099313497543, 0.00506394589319825, 0.00506687024608254, 0.00506975222378969, 0.00507261324673891, 0.00507542444393039, 0.00507823564112186, 0.00508099049329758, 0.00508371042087674, 0.00508640892803669, 0.00508906459435821, 0.00509172072634101, 0.00509432004764676, 0.00509687699377537, 0.00509940600022674, 0.0051019350066781, 0.00510440720245242, 0.00510685099288821, 0.00510925287380815, 0.00511162634938955, 0.00511397188529372, 0.0051163025200367, 0.00511859124526381, 0.00512083759531379, 0.00512305554002523, 0.00512523856014013, 0.00512740714475513, 0.00512953335419297, 0.0051316237077117, 0.00513367960229516, 0.00513571361079812, 0.00513770570978522, 0.00513965543359518, 0.00514161912724376, 0.00514351949095726, 0.00514539144933224, 0.00514721404761076, 0.00514903618022799, 0.00515082338824868, 0.00515256077051163, 0.00515427067875862, 0.00515594473108649, 0.00515759736299515, 0.00515920808538795, 0.00516079738736153, 0.00516235828399658, 0.00516387727111578, 0.00516536785289645, 0.00516682304441929, 0.00516827078536153, 0.00516965519636869, 0.00517102563753724, 0.00517235370352864, 0.0051736393943429, 0.00517491810023785, 0.00517616840079427, 0.00517736887559295, 0.00517854141071439, 0.00517911650240421, 0.00517968134954572, 0.00518021825700998, 0.00518074817955494, 0.00518125621601939, 0.00518173631280661, 0.0051822243258357, 0.00518267601728439, 0.00518311467021704, 0.00518355239182711, 0.00518396170809865, 0.00518436403945088, 0.00518473889678717, 0.00518509885296226, 0.00518545228987932, 0.00518579920753837, 0.00518610887229443, 0.00518640596419573, 0.00518668862059712, 0.0051869498565793, 0.0051872250624001, 0.00518745882436633, 0.00518767721951008, 0.00518787559121847, 0.00518805859610438, 0.00518824253231287, 0.00518841203302145, 0.00518854660913348, 0.00518867373466492, 0.00518877990543842, 0.00518887862563133, 0.00518896337598562, 0.0051890267059207, 0.00518906861543655, 0.00518909702077508, 0.00518911797553301, 0.00518911145627499, 0.00518909050151706, 0.00518906861543655, 0.0051890267059207, 0.00518895639106631, 0.00518887862563133, 0.00518877990543842, 0.00518867373466492, 0.00518855405971408, 0.00518840504810214, 0.00518824253231287, 0.00518805859610438, 0.00518786860629916, 0.00518768467009068, 0.00518745137378573, 0.00518721155822277, 0.0051869498565793, 0.0051866821013391, 0.00518641294911504, 0.00518610887229443, 0.00518578430637717, 0.00518544530496001, 0.00518509233370423, 0.00518473237752914, 0.00518436403945088, 0.00518396170809865, 0.0051835454069078, 0.00518312118947506, 0.00518267601728439, 0.0051822098903358, 0.0051817437633872, 0.00518124923110008, 0.00518074119463563, 0.00518021825700998, 0.00517967436462641, 0.00517912348732352, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.00517951883375645, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.0051795020699501, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517906667664647, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517884083092213, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517859822139144, 0.00517940567806363, 0.00518166599795222, 0.00518381362780929, 0.0051859044469893, 0.00518788211047649, 0.00518986023962498, 0.00519161205738783, 0.00519359018653631, 0.00519522884860635, 0.0051969806663692, 0.00519856298342347, 0.00520008895546198, 0.0052016144618392, 0.00520313996821642, 0.00520444009453058, 0.00520568294450641, 0.00520703941583633, 0.00520811323076487, 0.00520929973572493, 0.00521031720563769, 0.00521133420988917, 0.00521223852410913, 0.00521314237266779, 0.00521387718617916, 0.00521455518901348, 0.00521529000252485, 0.00521585531532764, 0.00521647650748491, 0.00521687231957912, 0.00521738082170486, 0.00521771982312202, 0.00521805882453918, 0.005218171980232, 0.00521839782595634, 0.0052184546366334, 0.00521851098164916, 0.00521851098164916, 0.00521834148094058, 0.00521822879090905, 0.00521794613450766, 0.00521777663379908, 0.00521738082170486, 0.00521704228594899, 0.00521647650748491, 0.00521596847102046, 0.00521540269255638, 0.0052147819660604, 0.00521399034187198, 0.00521314237266779, 0.00521240802481771, 0.00521139102056623, 0.00521048670634627, 0.00520941289141774, 0.00520833907648921, 0.00520715257152915, 0.00520596606656909, 0.00520460959523916, 0.00520330993458629, 0.00520184030756354, 0.00520031480118632, 0.0051987892948091, 0.00519715016707778, 0.00519551150500774, 0.0051937592215836, 0.00519200786948204, 0.00519008608534932, 0.00518822157755494, 0.00518613075837493, 0.00518409628421068, 0.00518200499936938, 0.00517980149015784, 0.00517381122335792, 0.00516912061721087, 0.00516448682174087, 0.00515951449051499, 0.00515454122796655, 0.00514939893037081, 0.00514414347708225, 0.00513877440243959, 0.00513323675841093, 0.00512764230370522, 0.00512187834829092, 0.00511588808149099, 0.00510995462536812, 0.00510379485785961, 0.00509752240031958, 0.00509113632142544, 0.00508458167314529, 0.00507796974852681, 0.00507118832319975, 0.00506429420784116, 0.00505717378109694, 0.00505005335435271, 0.00504282023757696, 0.00503536080941558, 0.00502778869122267, 0.00502010295167565, 0.00501241767778993, 0.00500439293682575, 0.00499642500653863, 0.00498811807483435, 0.00497998064383864, 0.00497144740074873, 0.0049629146233201, 0.00495421187952161, 0.00494528328999877, 0.00493652420118451, 0.00492742611095309, 0.00491827121004462, 0.00490877730771899, 0.00489956606179476, 0.00488984631374478, 0.00488018291071057, 0.00487035047262907, 0.00486029172316194, 0.00485034612938762, 0.00484006060287356, 0.00482988869771361, 0.00481926510110497, 0.00480881053954363, 0.00479796063154936, 0.00478728022426367, 0.00477620400488377, 0.00476524094119668, 0.00475393887609243, 0.00474258000031114, 0.0047311089001596, 0.00471935467794538, 0.00470771314576268, 0.0046959025785327, 0.00468392251059413, 0.00467177294194698, 0.00465956656262279, 0.00464724702760577, 0.00463475845754147, 0.00462209992110729, 0.00460927234962583, 0.0045965570025146, 0.00458344677463174, 0.00457033654674888, 0.0045571131631732, 0.00454371981322765, 0.00453021423891187, 0.00451313331723213, 0.00449505029246211, 0.0044769668020308, 0.00445888377726078, 0.00444068713113666, 0.00442249095067382, 0.0044044079259038, 0.00438621127977967, 0.00436824141070247, 0.00435004523023963, 0.00433196173980832, 0.00431376555934548, 0.00429556937888265, 0.00427748542279005, 0.00425940239802003, 0.00424131937325001, 0.00422312319278717, 0.00420503970235586, 0.00418684352189302, 0.00416864734143019, 0.00415067700669169, 0.00413248082622886, 0.00411439733579755, 0.00409620068967342, 0.0040781176649034, 0.00406003464013338, 0.00404195114970207, 0.00402375496923923, 0.0040055587887764, 0.00398747529834509, 0.00396927911788225, 0.00395119562745094, 0.00393311260268092, 0.00391502911224961, 0.00389683316461742, 0.00387863651849329, 0.00386055326089263, 0.00384247023612261, 0.0038243867456913, 0.00380619056522846, 0.0037881073076278, 0.00376991089433432, 0.00375171448104084, 0.00373363145627081, 0.00371554819867015, 0.00369746470823884, 0.003679268527776, 0.00366118527017534, 0.00364298885688186, 0.00362501875497401, 0.00360682234168053, 0.00358862592838705, 0.00357054290361702, 0.00355234672315419, 0.00353426299989223, 0.00351606705226004, 0.00349809695035219, 0.00347990030422807, 0.00346170412376523, 0.00344362063333392, 0.00342542445287108, 0.00340745435096323, 0.0033892581705004, 0.00337117444723845, 0.00335297826677561, 0.00333478231914341, 0.00331669882871211, 0.00329861557111144, 0.00328053231351078, 0.00326233613304794, 0.00324425264261663, 0.00323182065039873, 0.00321837118826807, 0.00320503464899957, 0.00319181103259325, 0.00317870080471039, 0.00316570373252034, 0.00315281911753118, 0.00314004789106548, 0.00312761543318629, 0.00311512663029134, 0.00310280756093562, 0.00309048825874925, 0.00307839503511786, 0.00306635862216353, 0.0030545478221029, 0.00304296356625855, 0.00303137861192226, 0.00301990727894008, 0.00300849205814302, 0.00299730291590095, 0.00298622692935169, 0.00297532021068037, 0.00296447076834738, 0.00295379012823105, 0.00294322287663817, 0.00293271173723042, 0.0029224269092083, 0.00291225500404835, 0.00290219648741186, 0.00289230677299201, 0.00288247410207987, 0.00287281116470695, 0.00286326045170426, 0.00285382359288633, 0.00284449919126928, 0.00283545767888427, 0.00282624666579068, 0.00281737418845296, 0.00280855875462294, 0.0027999693993479, 0.00279137957841158, 0.00278301606886089, 0.00277470913715661, 0.0027665151283145, 0.00275860377587378, 0.00275063584558666, 0.00274278060533106, 0.00273509533144534, 0.0027276361361146, 0.00272028986364603, 0.00271299993619323, 0.0027058229316026, 0.00269881612621248, 0.0026919215451926, 0.00268508377484977, 0.00267852889373899, 0.00267203012481332, 0.00266570108942688, 0.0026594283990562, 0.0026533252093941, 0.00264722225256264, 0.00264128833077848, 0.00263575022108853, 0.00263004307635128, 0.00262450496666133, 0.00261919293552637, 0.00261393748223782, 0.0026086822617799, 0.00260370899923146, 0.0025990754365921, 0.00259432848542929, 0.00258963811211288, 0.00258749071508646, 0.00258528674021363, 0.00258313957601786, 0.00258110486902297, 0.00257918355055153, 0.0025772622320801, 0.00257539749145508, 0.00257358909584582, 0.00257183751091361, 0.00257014203816652, 0.00256850314326584, 0.0025670905597508, 0.00256562139838934, 0.00256415200419724, 0.00256279576569796, 0.00256149587221444, 0.00256025278940797, 0.00255917920731008, 0.00255810562521219, 0.00255703181028366, 0.00255601457320154, 0.00255511025898159, 0.00255426275543869, 0.00255358451977372, 0.00255284993909299, 0.00255217170342803, 0.00255155027844012, 0.00255098496563733, 0.00255053304135799, 0.00255013746209443, 0.00254985480569303, 0.00254957238212228, 0.00254934653639793, 0.00254923338070512, 0.00254906364716589, 0.00254906364716589, 0.0025491202250123, 0.00254928972572088, 0.00254945945926011, 0.00254968530498445, 0.0025499677285552, 0.00255030719563365, 0.00255070254206657, 0.00255121104419231, 0.00255183270201087, 0.00255245435982943, 0.00255307601764798, 0.00255381059832871, 0.00255465833470225, 0.00255550583824515, 0.00255641015246511, 0.00255748373456299, 0.00255855754949152, 0.00255963113158941, 0.00256081786938012, 0.00256206118501723, 0.0025633042678237, 0.00256471708416939, 0.00256624282337725, 0.00256776856258512, 0.00256923795677722, 0.00257087685167789, 0.00257257209159434, 0.00257432367652655, 0.00257613207213581, 0.00257805339060724, 0.00258003128692508, 0.00258200918324292, 0.00258410023525357, 0.00258624739944935, 0.00258839502930641, 0.00259055057540536, 0.00259275431744754, 0.00259490171447396, 0.00259693642146885, 0.00259891431778669, 0.00260083563625813, 0.00260275695472956, 0.00260456535033882, 0.00260637351311743, 0.00260806875303388, 0.00260970764793456, 0.00261123361997306, 0.00261281570419669, 0.00261422852054238, 0.00261558475904167, 0.00261694123037159, 0.00261818431317806, 0.00261931447312236, 0.00262050121091306, 0.00262157479301095, 0.00262247887440026, 0.00262338318862021, 0.00262428727000952, 0.00262513500638306, 0.00262586981989443, 0.00262654782272875, 0.0026271129027009, 0.00262773456051946, 0.0026282430626452, 0.00262863887473941, 0.00262897764332592, 0.00262937345542014, 0.00262959953397512, 0.0026297690346837, 0.00262988195754588, 0.00262988195754588, 0.00262982537969947, 0.0026297124568373, 0.00262959953397512, 0.00262937345542014, 0.00262909079901874, 0.00262880814261734, 0.00262841279618442, 0.00262796063907444, 0.0026273955591023, 0.00262688682414591, 0.00262620858848095, 0.00262547400780022, 0.00262473965995014, 0.00262383534573019, 0.00262287468649447, 0.00262202695012093, 0.00262089679017663, 0.00261976663023233, 0.00261857965961099, 0.00261744949966669, 0.00261615007184446, 0.00261479360051453, 0.00261338101699948, 0.00261191138997674, 0.00261038588359952, 0.00260880356654525, 0.00260710809379816, 0.00260535627603531, 0.00260366103611887, 0.00260179629549384, 0.00259976205416024, 0.00259772734716535, 0.00259580602869391, 0.00259365863166749, 0.00259145488962531, 0.0025913983117789, 0.00258676428347826, 0.00258207391016185, 0.0025771576911211, 0.0025721846614033, 0.00256709870882332, 0.00256178667768836, 0.00255653122439981, 0.00255104992538691, 0.00254539866000414, 0.00253969128243625, 0.00253381417132914, 0.00252771098166704, 0.00252160779200494, 0.00251539167948067, 0.00250900606624782, 0.00250250729732215, 0.00249583902768791, 0.00248917075805366, 0.00248216348700225, 0.00247515621595085, 0.00246803602203727, 0.00246080267243087, 0.00245339958928525, 0.00244588381610811, 0.00243825512006879, 0.00243051303550601, 0.00242265802808106, 0.00241452059708536, 0.00240638316608965, 0.00239818915724754, 0.00238965591415763, 0.00238117948174477, 0.0023723638150841, 0.00236360472626984, 0.00235473271459341, 0.00234563439153135, 0.00233653630129993, 0.00232726847752929, 0.00231783138588071, 0.00230833771638572, 0.00229867431335151, 0.00228889798745513, 0.00227895216085017, 0.00226889341138303, 0.00225860835053027, 0.00224826694466174, 0.00223781261593103, 0.00222718855366111, 0.00221656449139118, 0.00220571458339691, 0.00219480809755623, 0.00218378868885338, 0.00217248639091849, 0.00216118455864489, 0.00214976933784783, 0.00213824119418859, 0.00212648697197437, 0.00211467640474439, 0.00210275268182158, 0.0020906594581902, 0.00207834015600383, 0.00206590793095529, 0.00205347547307611, 0.00204081716947258, 0.00202815909869969, 0.0020153874065727, 0.00200239010155201, 0.00198927987366915, 0.00197605625726283, 0.00196271995082498, 0.00194927037227899, 0.00193191552534699, 0.00191383215133101, 0.00189574889373034, 0.00187755271326751, 0.00185946933925152, 0.00184127304237336, 0.00182318978477269, 0.00180499337147921, 0.00178691034670919, 0.0017688269726932, 0.00175063055939972, 0.00173254741821438, 0.00171446404419839, 0.00169626763090491, 0.00167818460613489, 0.0016601012321189, 0.00164190493524075, 0.00162382167764008, 0.00160573830362409, 0.00158754212316126, 0.0015693458262831, 0.00155126245226711, 0.00153317931108177, 0.00151498301420361, 0.00149689975660294, 0.00147881649900228, 0.0014606200857088, 0.00144253682810813, 0.00142445357050747, 0.00140625715721399, 0.00138817389961332, 0.00137009075842798, 0.00135189446154982, 0.00133369804825634, 0.00131561490707099, 0.00129741861019284, 0.00127933523617685, 0.00126125197857618, 0.00124305579811335, 0.00122497242409736, 0.00120688905008137, 0.00118869286961854, 0.00117060961201787, 0.00115252623800188, 0.00113432994112372, 0.00111624668352306, 0.00109816354233772, 0.00107996712904423, 0.00106177083216608, 0.00104368757456541, 0.00102560431696475, 0.00100740802008659, 0.000989324762485921, 0.000971241504885256, 0.000953045149799436, 0.000934961892198771, 0.000916878634598106, 0.000898682221304625, 0.000880599021911621, 0.000862515764310956, 0.000844319525640458, 0.000826236151624471, 0.000808039912953973, 0.000789956655353308, 0.000771760242059827, 0.000753677042666823, 0.000735593785066158, 0.000717397488187999, 0.000699314114172012, 0.000681230914779007, 0.000663034676108509, 0.000645462016109377, 0.000631956034339964, 0.000618506514001638, 0.000605283072218299, 0.000592172669712454, 0.000579118728637695, 0.000566403905395418, 0.000553576042875648, 0.000540861219633371, 0.000528428936377168, 0.000516109634190798, 0.000503846909850836, 0.000491753628011793, 0.000479716953122988, 0.000467962789116427, 0.000456208596006036, 0.000444567442173138, 0.000433152366895229, 0.000421737262513489, 0.000410435168305412, 0.000399472162825987, 0.000388452608603984, 0.000377546122763306, 0.000366922176908702, 0.000356298201950267, 0.000345900247339159, 0.000335558841470629, 0.000325330503983423, 0.000315271638100967, 0.000305325811496004, 0.000295549485599622, 0.000285829679341987, 0.000276166421826929, 0.000266785675194114, 0.000257517967838794, 0.000248193769948557, 0.000239265122218058, 0.000230279969400726, 0.00022146433184389, 0.000212874743738212, 0.000204228650545701, 0.000195752101717517, 0.000187501558684744, 0.000179307549842633, 0.000171226565726101, 0.000163371631060727, 0.000155516681843437, 0.000147774757351726, 0.000140371877932921, 0.000133025532704778, 0.000125566148199141, 0.000118445845146198, 0.000111495064629707, 0.000104431259387638, 9.77630261331797e-05, 9.12078176042996e-05, 8.45960967126302e-05, 7.80974078224972e-05, 7.19377712812275e-05, 6.57781347399577e-05, 5.97880280110985e-05, 5.39109496457968e-05, 4.80903763673268e-05, 4.2382820538478e-05, 3.70143316104077e-05, 3.16458390443586e-05, 2.62208432104671e-05, 2.11914157262072e-05, 1.62750075105578e-05, 1.13020914795925e-05, 6.55521625958499e-06, 1.9778724436037e-06, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.8255297479518e-07, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519e-15, 2.5895724197519