// Class: ReadBDTG_fold1
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG_fold1
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:57:48 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 998
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "100" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "False" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 2
x                             x                             x                             x                                                               'F'    [-4.10750675201,4.09692668915]
y                             y                             y                             y                                                               'F'    [-4.85200452805,4.07606744766]
NSpec 1
eventID                       eventID                       eventID                       I                                                               'F'    [1,1000]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTG_fold1Node

#ifndef BDTG_fold1Node__def
#define BDTG_fold1Node__def

class BDTG_fold1Node {

public:

   // constructor of an essentially "empty" node floating in space
   BDTG_fold1Node ( BDTG_fold1Node* left,BDTG_fold1Node* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTG_fold1Node();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTG_fold1Node* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTG_fold1Node* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTG_fold1Node*   fLeft;     // pointer to the left daughter node
   BDTG_fold1Node*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTG_fold1Node::~BDTG_fold1Node()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTG_fold1Node::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTG_fold1Node::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG_fold1 : public IClassifierReader {

 public:

   // constructor
   ReadBDTG_fold1( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG_fold1" ),
        fNvars( 2 )
   {
      // the training input variables
      const char* inputVars[] = { "x", "y" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG_fold1() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[2];
   double fVmax[2];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[2];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTG_fold1Node*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTG_fold1::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTG_fold1Node *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTG_fold1Node*)current->GetRight();
         else current=(BDTG_fold1Node*)current->GetLeft();
      }
      myMVA += current->GetResponse();
   }
   return 2.0/(1.0+exp(-2.0*myMVA))-1.0;
}

void ReadBDTG_fold1::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.0803922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730435,0.046087) , 
0, 0.450256, 1, 0, 0.224739,-0.275261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.05) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9375,0.0875) , 
0, -1.00961, 1, 0, 0.872642,0.372642) , 
1, 0.249751, 1, 0, 0.5,0)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0687023,-0.0787443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623529,0.0211928) , 
0, 0.342803, 1, 0, 0.167364,-0.302829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241379,-0.0478259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919169,0.0769702) , 
0, -0.669172, 1, 0, 0.805769,0.278378) , 
1, -0.175395, 1, 0, 0.5,4.14646e-06)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0980392,-0.067348) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.730435,0.0378899) , 
0, 0.450256, 1, 0, 0.224739,-0.225537) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.25,-0.0406349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9375,0.0735082) , 
0, -1.00961, 1, 0, 0.872642,0.30532) , 
1, 0.249751, 1, 0, 0.5,-3.04408e-06)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0687023,-0.0673295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623529,0.0163127) , 
0, 0.342803, 1, 0, 0.167364,-0.248719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.344828,-0.0266849) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.938119,0.0697651) , 
0, -0.328736, 1, 0, 0.805769,0.22866) , 
1, -0.175395, 1, 0, 0.5,1.5536e-05)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.111842,-0.0580117) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.753247,0.0418327) , 
1, 0.674897, 1, 0, 0.204503,-0.201556) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.486957,-0.00241323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954286,0.0678575) , 
1, -0.208424, 1, 0, 0.83871,0.231084) , 
0, 0.137197, 1, 0, 0.5,2.48172e-05)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0687023,-0.0595064) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623529,0.0148849) , 
0, 0.342803, 1, 0, 0.167364,-0.204236) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.241379,-0.0366651) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.919169,0.0586949) , 
0, -0.669172, 1, 0, 0.805769,0.187883) , 
1, -0.175395, 1, 0, 0.5,7.42417e-05)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.144531,-0.0468033) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.887097,0.0579404) , 
0, 1.10239, 1, 0, 0.224739,-0.153507) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0540094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924242,0.0566546) , 
0, -1.35004, 1, 0, 0.872642,0.207954) , 
1, 0.249751, 1, 0, 0.5,5.96835e-05)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985222,-0.0523149) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736842,0.0402374) , 
1, 0.979613, 1, 0, 0.153153,-0.184709) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174603,-0.0501236) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.855397,0.0470392) , 
1, -1.01904, 1, 0, 0.777978,0.148253) , 
0, -0.222778, 1, 0, 0.5,0.000121679)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.058474) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0154481) , 
0, 0.635523, 1, 0, 0.107438,-0.200574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171171,-0.0375161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841603,0.0429544) , 
0, -0.884462, 1, 0, 0.724409,0.11477) , 
1, -0.600542, 1, 0, 0.5,7.07409e-05)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198291,-0.0366429) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931818,0.056251) , 
0, 1.12615, 1, 0, 0.294205,-0.0969077) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.00838293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97651,0.0602233) , 
0, -0.948032, 1, 0, 0.926154,0.20059) , 
1, 0.674897, 1, 0, 0.5,-2.71741e-05)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.0540328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0131114) , 
0, 0.635523, 1, 0, 0.107438,-0.169402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244898,-0.0240088) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868852,0.0419209) , 
0, -0.528649, 1, 0, 0.724409,0.0970448) , 
1, -0.600542, 1, 0, 0.5,0.000130817)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198291,-0.0328781) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931818,0.0514213) , 
0, 1.12615, 1, 0, 0.294205,-0.0821574) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.00522779) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97651,0.0566971) , 
0, -0.948032, 1, 0, 0.926154,0.170312) , 
1, 0.674897, 1, 0, 0.5,5.96789e-05)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.0502204) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0111445) , 
0, 0.635523, 1, 0, 0.107438,-0.143439) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.171171,-0.0294174) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.841603,0.0354107) , 
0, -0.884462, 1, 0, 0.724409,0.082309) , 
1, -0.600542, 1, 0, 0.5,0.000198373)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133595,-0.0355889) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.792683,0.0235817) , 
0, 0.470622, 1, 0, 0.294205,-0.0700295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37037,-0.00181706) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.97651,0.0536405) , 
0, -0.948032, 1, 0, 0.926154,0.14532) , 
1, 0.674897, 1, 0, 0.5,9.94464e-05)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0460123,-0.0467965) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.648649,0.0078029) , 
0, 0.635523, 1, 0, 0.107438,-0.121617) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244898,-0.0183526) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.868852,0.0348143) , 
0, -0.528649, 1, 0, 0.724409,0.0697768) , 
1, -0.600542, 1, 0, 0.5,0.000161439)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.198291,-0.0272712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.931818,0.0448301) , 
0, 1.12615, 1, 0, 0.294205,-0.059859) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859873,0.0275964) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988095,0.0604787) , 
1, 1.48642, 1, 0, 0.926154,0.124245) , 
1, 0.674897, 1, 0, 0.5,9.45921e-05)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163603,-0.0290927) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906977,0.0473673) , 
1, 1.10004, 1, 0, 0.265079,-0.0598793) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.461538,-0.0176817) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.935673,0.0411934) , 
1, -0.878737, 1, 0, 0.902174,0.103009) , 
0, 0.497173, 1, 0, 0.5,0.000183824)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.052819) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.177419,-0.018794) , 
1, -1.41424, 1, 0, 0.107438,-0.0971103) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0784314,-0.0457363) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.780822,0.0246837) , 
0, -1.59609, 1, 0, 0.724409,0.0558669) , 
1, -0.600542, 1, 0, 0.5,0.000224885)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0985222,-0.0334533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.736842,0.0289216) , 
1, 0.979613, 1, 0, 0.153153,-0.0765812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.174603,-0.0308906) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.855397,0.029039) , 
1, -1.01904, 1, 0, 0.777978,0.0616091) , 
0, -0.222778, 1, 0, 0.5,0.000129643)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.22459,-0.0216602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.968254,0.0533101) , 
0, 1.45392, 1, 0, 0.294205,-0.044651) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.859873,0.0217026) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988095,0.0569798) , 
1, 1.48642, 1, 0, 0.926154,0.0927498) , 
1, 0.674897, 1, 0, 0.5,9.37671e-05)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.0439496) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0132741) , 
0, -1.06724, 1, 0, 0.0693431,-0.0997904) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0476101) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748031,0.0214284) , 
1, -1.41602, 1, 0, 0.662983,0.0380091) , 
0, -0.942729, 1, 0, 0.5,0.000176357)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164151,-0.0231638) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954545,0.0500209) , 
0, 1.42846, 1, 0, 0.224739,-0.0483981) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0360295) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.924242,0.0341512) , 
0, -1.35004, 1, 0, 0.872642,0.065696) , 
1, 0.249751, 1, 0, 0.5,7.4721e-05)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.0173582) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0507781) , 
0, 1.45392, 1, 0, 0.354414,-0.0294728) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0338433) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0578439) , 
1, 1.67412, 1, 0, 0.962343,0.0940616) , 
1, 1.10004, 1, 0, 0.5,0.000111094)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0502918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00949804) , 
0, -1.4123, 1, 0, 0.040201,-0.102488) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0295399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779801,0.0215586) , 
1, -0.83435, 1, 0, 0.614518,0.0257691) , 
0, -1.3027, 1, 0, 0.5,0.000194797)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.163603,-0.0212522) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.906977,0.0385917) , 
1, 1.10004, 1, 0, 0.265079,-0.0356794) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00196716) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0422169) , 
1, -0.207307, 1, 0, 0.902174,0.061375) , 
0, 0.497173, 1, 0, 0.5,0.000108231)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0486078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.0075949) , 
0, -1.4123, 1, 0, 0.040201,-0.0896861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0265691) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779801,0.0194601) , 
1, -0.83435, 1, 0, 0.614518,0.0225317) , 
0, -1.3027, 1, 0, 0.5,0.000155604)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.0148892) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0485868) , 
0, 1.45392, 1, 0, 0.354414,-0.023016) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0294166) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0565201) , 
1, 1.67412, 1, 0, 0.962343,0.0734314) , 
1, 1.10004, 1, 0, 0.5,8.11537e-05)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.0372119) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0134775) , 
0, -1.06724, 1, 0, 0.0693431,-0.0648042) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0417798) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748031,0.0165989) , 
1, -1.41602, 1, 0, 0.662983,0.0247318) , 
0, -0.942729, 1, 0, 0.5,0.000149746)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.0135524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0468974) , 
0, 1.45392, 1, 0, 0.354414,-0.0204074) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.934959,0.0308063) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.991379,0.0561813) , 
1, 1.81541, 1, 0, 0.962343,0.0651392) , 
1, 1.10004, 1, 0, 0.5,7.91787e-05)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0460753) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00246373) , 
0, -1.4123, 1, 0, 0.040201,-0.0713755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.0230275) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779801,0.0165065) , 
1, -0.83435, 1, 0, 0.614518,0.0179484) , 
0, -1.3027, 1, 0, 0.5,0.000137331)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.0123428) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.045352) , 
0, 1.45392, 1, 0, 0.354414,-0.0180861) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0259102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.055214) , 
1, 1.67412, 1, 0, 0.962343,0.0577532) , 
1, 1.10004, 1, 0, 0.5,7.58542e-05)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0447058) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,-0.00185992) , 
0, -1.4123, 1, 0, 0.040201,-0.0636941) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738255,-0.02897) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738462,0.0138409) , 
1, -1.21207, 1, 0, 0.614518,0.0160246) , 
0, -1.3027, 1, 0, 0.5,0.000128799)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0483871,-0.0323857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.269231,0.0120657) , 
0, -1.06724, 1, 0, 0.0693431,-0.0471015) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0561798,-0.0371232) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.748031,0.0130763) , 
1, -1.41602, 1, 0, 0.662983,0.0179181) , 
0, -0.942729, 1, 0, 0.5,6.70148e-05)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.0113309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0438164) , 
0, 1.45392, 1, 0, 0.354414,-0.0160225) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.0167745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0469194) , 
1, 1.39154, 1, 0, 0.962343,0.0509736) , 
1, 1.10004, 1, 0, 0.5,2.16501e-05)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.196864,-0.0130832) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0484973) , 
1, 1.52519, 1, 0, 0.265079,-0.0199241) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00380769) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0350516) , 
1, -0.207307, 1, 0, 0.902174,0.0342964) , 
0, 0.497173, 1, 0, 0.5,6.90075e-05)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0422207) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00285346) , 
0, -1.4123, 1, 0, 0.040201,-0.0507826) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016129,-0.051989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664858,0.00959426) , 
1, -1.96752, 1, 0, 0.614518,0.0127758) , 
0, -1.3027, 1, 0, 0.5,0.000102336)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00982228) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0416942) , 
0, 1.45392, 1, 0, 0.354414,-0.0133546) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944444,0.0277649) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.989474,0.0542997) , 
1, 1.9567, 1, 0, 0.962343,0.0425945) , 
1, 1.10004, 1, 0, 0.5,4.40524e-05)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0409804) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0027363) , 
0, -1.4123, 1, 0, 0.040201,-0.0457538) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0738255,-0.0241105) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.738462,0.0106916) , 
1, -1.21207, 1, 0, 0.614518,0.0114954) , 
0, -1.3027, 1, 0, 0.5,7.99959e-05)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00897909) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0401808) , 
0, 1.45392, 1, 0, 0.354414,-0.012012) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.0122024) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0439615) , 
1, 1.39154, 1, 0, 0.962343,0.0383056) , 
1, 1.10004, 1, 0, 0.5,3.80013e-05)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0397961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00278582) , 
0, -1.4123, 1, 0, 0.040201,-0.0413469) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016129,-0.0500899) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664858,0.00817511) , 
1, -1.96752, 1, 0, 0.614518,0.0103849) , 
0, -1.3027, 1, 0, 0.5,6.96325e-05)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00820361) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.038432) , 
0, 1.45392, 1, 0, 0.354414,-0.0108864) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.011164) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0429083) , 
1, 1.39154, 1, 0, 0.962343,0.0346734) , 
1, 1.10004, 1, 0, 0.5,2.42437e-05)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0386341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00278947) , 
0, -1.4123, 1, 0, 0.040201,-0.0374735) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102564,-0.015552) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.779801,0.0100987) , 
1, -0.83435, 1, 0, 0.614518,0.00939912) , 
0, -1.3027, 1, 0, 0.5,5.27804e-05)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00750118) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0368931) , 
0, 1.45392, 1, 0, 0.354414,-0.00981715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.0171524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.052564) , 
1, 1.67412, 1, 0, 0.962343,0.0312761) , 
1, 1.10004, 1, 0, 0.5,2.38252e-05)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0692102) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0265649) , 
1, -2.74756, 1, 0, 0.035503,-0.0382837) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0947368,-0.0146671) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.743349,0.00869001) , 
0, -0.942729, 1, 0, 0.594692,0.00786765) , 
1, -1.45083, 1, 0, 0.5,5.24318e-05)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0366146) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00439405) , 
0, -1.4123, 1, 0, 0.040201,-0.0318332) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.064984) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00598424) , 
1, -2.34525, 1, 0, 0.614518,0.00796176) , 
0, -1.3027, 1, 0, 0.5,2.66962e-05)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.272727,-0.00693559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977273,0.0355122) , 
0, 1.45392, 1, 0, 0.354414,-0.00893812) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00853218) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0414026) , 
1, 1.39154, 1, 0, 0.962343,0.0283642) , 
1, 1.10004, 1, 0, 0.5,-4.99451e-06)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0685717) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.0244919) , 
1, -2.74756, 1, 0, 0.035503,-0.0324656) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.056338,-0.0200527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.705968,0.00661257) , 
0, -1.3027, 1, 0, 0.594692,0.00664156) , 
1, -1.45083, 1, 0, 0.5,1.92005e-05)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.244019,-0.00677381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.978261,0.0401614) , 
0, 1.78168, 1, 0, 0.294205,-0.0100377) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.875,0.00794445) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992908,0.0517985) , 
1, 1.64828, 1, 0, 0.926154,0.0207809) , 
1, 0.674897, 1, 0, 0.5,-1.57533e-06)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0716612,-0.0199765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.448916,0.00258429) , 
0, -0.823586, 1, 0, 0.265079,-0.0103558) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00539193) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0275127) , 
1, -0.207307, 1, 0, 0.902174,0.0177874) , 
0, 0.497173, 1, 0, 0.5,2.16614e-05)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0215885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53178,0.00179338) , 
1, -0.884476, 1, 0, 0.354414,-0.00718634) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00648431) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0386779) , 
1, 1.39154, 1, 0, 0.962343,0.022933) , 
1, 1.10004, 1, 0, 0.5,2.66012e-05)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0344569) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0088239) , 
0, -1.4123, 1, 0, 0.040201,-0.0249402) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0648575) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00492561) , 
1, -2.34525, 1, 0, 0.614518,0.0062428) , 
0, -1.3027, 1, 0, 0.5,2.49475e-05)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295389,-0.00532169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0414064) , 
0, 1.78168, 1, 0, 0.354414,-0.00662171) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944444,0.0176824) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.989474,0.0503138) , 
1, 1.9567, 1, 0, 0.962343,0.0210276) , 
1, 1.10004, 1, 0, 0.5,-2.76157e-07)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0333135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00784484) , 
0, -1.4123, 1, 0, 0.040201,-0.0228925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0652132) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00454037) , 
1, -2.34525, 1, 0, 0.614518,0.00572421) , 
0, -1.3027, 1, 0, 0.5,1.80694e-05)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.133072,-0.00832834) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.831933,0.0129243) , 
1, 0.674897, 1, 0, 0.265079,-0.00837801) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00460618) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0245423) , 
1, -0.207307, 1, 0, 0.902174,0.0143319) , 
0, 0.497173, 1, 0, 0.5,-4.00636e-06)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.298146,-0.0047655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.979592,0.040192) , 
1, 1.52519, 1, 0, 0.381727,-0.00512404) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.851852,-0.0041488) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994186,0.042698) , 
1, -0.207307, 1, 0, 0.974874,0.0206104) , 
0, 1.21712, 1, 0, 0.5,7.38401e-06)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0320456) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00747722) , 
0, -1.4123, 1, 0, 0.040201,-0.0206351) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.016129,-0.0410712) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.664858,0.00459344) , 
1, -1.96752, 1, 0, 0.614518,0.00517503) , 
0, -1.3027, 1, 0, 0.5,2.85142e-05)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295389,-0.00448231) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0400355) , 
0, 1.78168, 1, 0, 0.354414,-0.00530913) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00225309) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.035633) , 
1, 1.39154, 1, 0, 0.962343,0.0168973) , 
1, 1.10004, 1, 0, 0.5,8.84599e-06)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0517922) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,-0.00175859) , 
1, -0.579652, 1, 0, 0.040201,-0.0190465) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0652094) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00390092) , 
1, -2.34525, 1, 0, 0.614518,0.00477058) , 
0, -1.3027, 1, 0, 0.5,2.14795e-05)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0718954,-0.0156023) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614828,0.00244496) , 
0, -0.824458, 1, 0, 0.42142,-0.00349729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.971429,0.0216305) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0532117) , 
0, 2.05754, 1, 0, 0.985611,0.0215813) , 
0, 1.5771, 1, 0, 0.5,-4.37342e-06)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.068728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.041958,-0.01736) , 
1, -2.74756, 1, 0, 0.035503,-0.0190368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.488515,-0.000118067) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.988636,0.0416102) , 
1, 1.44501, 1, 0, 0.594692,0.00388206) , 
1, -1.45083, 1, 0, 0.5,1.01195e-06)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.029705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.010951) , 
0, -1.4123, 1, 0, 0.040201,-0.0160589) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.064093) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.0033068) , 
1, -2.34525, 1, 0, 0.614518,0.00400324) , 
0, -1.3027, 1, 0, 0.5,2.88e-06)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295389,-0.00386235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0389357) , 
0, 1.78168, 1, 0, 0.354414,-0.00444792) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.00175559) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0332326) , 
1, 1.39154, 1, 0, 0.962343,0.0140791) , 
1, 1.10004, 1, 0, 0.5,-1.10824e-05)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0287194) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00989485) , 
0, -1.4123, 1, 0, 0.040201,-0.0149305) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0644215) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00307565) , 
1, -2.34525, 1, 0, 0.614518,0.00371926) , 
0, -1.3027, 1, 0, 0.5,5.2488e-07)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0158321) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53178,0.00138062) , 
1, -0.884476, 1, 0, 0.354414,-0.00412628) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944099,0.0124595) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.061267) , 
1, 2.09799, 1, 0, 0.962343,0.0130548) , 
1, 1.10004, 1, 0, 0.5,-1.17643e-05)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0448266) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483266,0.000379859) , 
0, -1.78377, 1, 0, 0.42142,-0.00291808) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.978022,0.0295188) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0505796) , 
1, 1.47127, 1, 0, 0.985611,0.017983) , 
0, 1.5771, 1, 0, 0.5,-7.00772e-06)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295389,-0.00331519) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0370317) , 
0, 1.78168, 1, 0, 0.354414,-0.00374552) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,0.000279926) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.0313332) , 
1, 1.39154, 1, 0, 0.962343,0.0118553) , 
1, 1.10004, 1, 0, 0.5,-9.46312e-06)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0382346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.00792534) , 
0, 0.0523864, 1, 0, 0.035503,-0.0144732) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106195,-0.00851629) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671788,0.00306178) , 
1, -0.922934, 1, 0, 0.594692,0.00295022) , 
1, -1.45083, 1, 0, 0.5,-2.3604e-07)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0265307) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.00946286) , 
0, -1.4123, 1, 0, 0.040201,-0.0123543) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0659123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00264153) , 
1, -2.34525, 1, 0, 0.614518,0.00306356) , 
0, -1.3027, 1, 0, 0.5,-1.07399e-05)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295389,-0.00306572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.984615,0.0359307) , 
0, 1.78168, 1, 0, 0.354414,-0.00344641) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92233,0.00559294) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992647,0.0454961) , 
1, 1.67412, 1, 0, 0.962343,0.010863) , 
1, 1.10004, 1, 0, 0.5,-1.96096e-05)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0514521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.00200533) , 
1, -0.579652, 1, 0, 0.040201,-0.0114737) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0661482) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.64183,0.00245693) , 
1, -2.34525, 1, 0, 0.614518,0.0028479) , 
0, -1.3027, 1, 0, 0.5,-7.80415e-06)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0718954,-0.0120545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.614828,0.00185252) , 
0, -0.824458, 1, 0, 0.42142,-0.00226295) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.972973,0.0108037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.990196,0.037329) , 
0, 1.81761, 1, 0, 0.985611,0.0138204) , 
0, 1.5771, 1, 0, 0.5,-2.28816e-05)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0130178) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53178,0.00105036) , 
1, -0.884476, 1, 0, 0.354414,-0.00309345) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.914894,-0.000914443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.973958,0.02862) , 
1, 1.39154, 1, 0, 0.962343,0.00974741) , 
1, 1.10004, 1, 0, 0.5,-1.83385e-05)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00892857,-0.0433855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.483266,0.000530286) , 
0, -1.78377, 1, 0, 0.42142,-0.00204333) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.971429,0.0140441) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0523691) , 
0, 2.05754, 1, 0, 0.985611,0.0125095) , 
0, 1.5771, 1, 0, 0.5,-1.64381e-05)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0627178,-0.0120323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.53178,0.000919775) , 
1, -0.884476, 1, 0, 0.354414,-0.00284001) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.944099,0.00853823) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0608471) , 
1, 2.09799, 1, 0, 0.962343,0.00895023) , 
1, 1.10004, 1, 0, 0.5,-1.64976e-05)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0694359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434574,-0.00091323) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0363694) , 
0, 1.5771, 1, 0, 0.513903,0.000780206) , 
1, -2.72627, 1, 0, 0.5,-1.14972e-05)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.345646,-0.00218397) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.986842,0.0346908) , 
0, 1.78168, 1, 0, 0.404077,-0.00203009) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945946,0.0207184) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0504683) , 
0, 0.117368, 1, 0, 0.987805,0.0102805) , 
1, 1.52519, 1, 0, 0.5,-7.10322e-06)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0238961) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0119647) , 
0, -1.4123, 1, 0, 0.040201,-0.00892755) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192453,0.00635465) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82397,-0.0013366) , 
1, -0.456626, 1, 0, 0.614518,0.00222639) , 
0, -1.3027, 1, 0, 0.5,2.31038e-06)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0349319) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.00945652) , 
0, 0.0523864, 1, 0, 0.035503,-0.00997762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.456053,-0.000302642) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.964602,0.0194831) , 
1, 1.18191, 1, 0, 0.594692,0.00203092) , 
1, -1.45083, 1, 0, 0.5,-2.59168e-06)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0702356) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434574,-0.000689963) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0336624) , 
0, 1.5771, 1, 0, 0.513903,0.000725865) , 
1, -2.72627, 1, 0, 0.5,-7.46398e-06)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0227144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0110229) , 
0, -1.4123, 1, 0, 0.040201,-0.00817536) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192453,0.00603956) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82397,-0.00133975) , 
1, -0.456626, 1, 0, 0.614518,0.00203039) , 
0, -1.3027, 1, 0, 0.5,-4.6224e-06)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0482759,-0.00963322) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.59375,0.000937128) , 
0, -0.840437, 1, 0, 0.404077,-0.00181772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.945946,0.0202144) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0504069) , 
0, 0.117368, 1, 0, 0.987805,0.00919381) , 
1, 1.52519, 1, 0, 0.5,-8.20738e-06)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0688691) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375505,-0.000921703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.964912,0.0182963) , 
1, 1.16271, 1, 0, 0.513903,0.000661599) , 
1, -2.72627, 1, 0, 0.5,-4.37347e-06)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0333442) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.00970646) , 
0, 0.0523864, 1, 0, 0.035503,-0.00841605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106195,-0.00621894) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671788,0.00194735) , 
1, -0.922934, 1, 0, 0.594692,0.00170976) , 
1, -1.45083, 1, 0, 0.5,-4.92924e-06)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0216447) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0110387) , 
0, -1.4123, 1, 0, 0.040201,-0.00726842) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192453,0.00599122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82397,-0.00152791) , 
1, -0.456626, 1, 0, 0.614518,0.00179708) , 
0, -1.3027, 1, 0, 0.5,-1.05681e-05)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0679918) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434574,-0.000621499) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0315646) , 
0, 1.5771, 1, 0, 0.513903,0.000592503) , 
1, -2.72627, 1, 0, 0.5,-1.30751e-05)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37831,-0.00160857) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954545,0.020301) , 
1, 1.28719, 1, 0, 0.448505,-0.0011696) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.961538,0.0336054) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0502428) , 
0, 0.285969, 1, 0, 0.989474,0.0110116) , 
1, 1.95034, 1, 0, 0.5,-1.00688e-05)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0512462) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.0037017) , 
1, -0.579652, 1, 0, 0.040201,-0.00699672) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3241,0.00403078) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853881,-0.0026262) , 
0, 0.240462, 1, 0, 0.614518,0.00173506) , 
0, -1.3027, 1, 0, 0.5,-6.04298e-06)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0316605) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.0089928) , 
0, 0.0523864, 1, 0, 0.035503,-0.00722661) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.106195,-0.00578518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.671788,0.00171183) , 
1, -0.922934, 1, 0, 0.594692,0.00145639) , 
1, -1.45083, 1, 0, 0.5,-1.39772e-05)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0667744) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434574,-0.000563639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0300403) , 
0, 1.5771, 1, 0, 0.513903,0.000525576) , 
1, -2.72627, 1, 0, 0.5,-1.76969e-05)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.025641,-0.0148985) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.564972,0.000529451) , 
0, -1.3027, 1, 0, 0.448505,-0.00104483) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.961538,0.0306545) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0502187) , 
0, 0.285969, 1, 0, 0.989474,0.00977845) , 
1, 1.95034, 1, 0, 0.5,-1.45595e-05)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0652213) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.375505,-0.000730233) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.964912,0.0148539) , 
1, 1.16271, 1, 0, 0.513903,0.000478203) , 
1, -2.72627, 1, 0, 0.5,-1.27607e-05)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0207259) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0130682) , 
0, -1.4123, 1, 0, 0.040201,-0.00592711) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192453,0.00592065) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82397,-0.00179147) , 
1, -0.456626, 1, 0, 0.614518,0.00146067) , 
0, -1.3027, 1, 0, 0.5,-1.24459e-05)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37831,-0.00136423) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954545,0.0186111) , 
1, 1.28719, 1, 0, 0.448505,-0.000935217) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.961538,0.0284163) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0501928) , 
0, 0.285969, 1, 0, 0.989474,0.00873871) , 
1, 1.95034, 1, 0, 0.5,-1.4352e-05)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0201037) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0114287) , 
0, -1.4123, 1, 0, 0.040201,-0.00578522) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.192453,0.00544274) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.82397,-0.00157854) , 
1, -0.456626, 1, 0, 0.614518,0.00142761) , 
0, -1.3027, 1, 0, 0.5,-1.06221e-05)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00714286,-0.0302695) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.172414,0.00858848) , 
0, 0.0523864, 1, 0, 0.035503,-0.00635823) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.156627,0.0044258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.782759,-0.000626128) , 
0, -0.582754, 1, 0, 0.594692,0.00128134) , 
1, -1.45083, 1, 0, 0.5,-1.23322e-05)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0643972) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.434574,-0.000502422) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992754,0.0279822) , 
0, 1.5771, 1, 0, 0.513903,0.000435191) , 
1, -2.72627, 1, 0, 0.5,-1.56088e-05)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0233918,-0.0187057) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.142857,0.0101737) , 
0, -1.4123, 1, 0, 0.040201,-0.00527467) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3241,0.00375235) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853881,-0.00290343) , 
0, 0.240462, 1, 0, 0.614518,0.00129747) , 
0, -1.3027, 1, 0, 0.5,-1.30047e-05)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.37831,-0.00131409) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.954545,0.0185337) , 
1, 1.28719, 1, 0, 0.448505,-0.000893742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.961538,0.0283392) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0501754) , 
0, 0.285969, 1, 0, 0.989474,0.00835115) , 
1, 1.95034, 1, 0, 0.5,-1.37171e-05)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0841584,0.00370123) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.588496,-0.00640057) , 
1, -0.175395, 1, 0, 0.265079,-0.00206533) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.616438,-0.00730016) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.972881,0.0149294) , 
1, -0.207307, 1, 0, 0.902174,0.00350799) , 
0, 0.497173, 1, 0, 0.5,-1.02384e-05)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0511751) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.108108,0.00439909) , 
1, -0.579652, 1, 0, 0.040201,-0.00502446) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.3241,0.003584) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.853881,-0.0027964) , 
0, 0.240462, 1, 0, 0.614518,0.00124407) , 
0, -1.3027, 1, 0, 0.5,-5.87006e-06)    );
   return;
};

// Clean up
inline void ReadBDTG_fold1::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTG_fold1::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
