// Class: ReadBDTG_fold2
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDTG_fold2
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:57:48 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 1000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "100" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
MinNodeSize: "2.5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "Grad" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
Shrinkage: "1.000000e-01" [Learning rate for BoostType=Grad algorithm]
NegWeightTreatment: "pray" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "False" [Use only a random subsample of all events for growing the trees in each boost iteration.]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 2
x                             x                             x                             x                                                               'F'    [-4.10750675201,4.09692668915]
y                             y                             y                             y                                                               'F'    [-4.85200452805,4.07606744766]
NSpec 1
eventID                       eventID                       eventID                       I                                                               'F'    [1,1000]


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTG_fold2Node

#ifndef BDTG_fold2Node__def
#define BDTG_fold2Node__def

class BDTG_fold2Node {

public:

   // constructor of an essentially "empty" node floating in space
   BDTG_fold2Node ( BDTG_fold2Node* left,BDTG_fold2Node* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTG_fold2Node();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTG_fold2Node* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTG_fold2Node* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTG_fold2Node*   fLeft;     // pointer to the left daughter node
   BDTG_fold2Node*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTG_fold2Node::~BDTG_fold2Node()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTG_fold2Node::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTG_fold2Node::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDTG_fold2 : public IClassifierReader {

 public:

   // constructor
   ReadBDTG_fold2( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDTG_fold2" ),
        fNvars( 2 )
   {
      // the training input variables
      const char* inputVars[] = { "x", "y" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDTG_fold2() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[2];
   double fVmax[2];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[2];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTG_fold2Node*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDTG_fold2::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTG_fold2Node *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTG_fold2Node*)current->GetRight();
         else current=(BDTG_fold2Node*)current->GetLeft();
      }
      myMVA += current->GetResponse();
   }
   return 2.0/(1.0+exp(-2.0*myMVA))-1.0;
}

void ReadBDTG_fold2::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0415584,-0.0916883) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0) , 
1, 0.210646, 1, 0, 0.129979,-0.370021) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0382979) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.95338,0.090676) , 
1, -0.491026, 1, 0, 0.837476,0.337476) , 
0, -0.130818, 1, 0, 0.5,0)    );
  // itree = 1
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.062201,-0.0797525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610169,0.0220339) , 
1, 0.520028, 1, 0, 0.129979,-0.333122) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0345205) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.95338,0.0823062) , 
1, -0.491026, 1, 0, 0.837476,0.303828) , 
0, -0.130818, 1, 0, 0.5,2.95421e-06)    );
  // itree = 2
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0415584,-0.0769277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,0.00144556) , 
1, 0.210646, 1, 0, 0.129979,-0.300113) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0311937) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.95338,0.0757711) , 
1, -0.491026, 1, 0, 0.837476,0.273762) , 
0, -0.130818, 1, 0, 0.5,2.34821e-05)    );
  // itree = 3
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0689655,-0.0683741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623077,0.0185239) , 
1, 0.221947, 1, 0, 0.19646,-0.227783) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423729,-0.00494347) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.968085,0.0736161) , 
1, -0.491026, 1, 0, 0.894253,0.295938) , 
0, 0.230699, 1, 0, 0.5,3.58523e-05)    );
  // itree = 4
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0766358) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.0485792) , 
0, -1.18567, 1, 0, 0.0717949,-0.298367) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0482957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90239,0.0615102) , 
1, -0.733781, 1, 0, 0.773771,0.190859) , 
0, -0.492335, 1, 0, 0.5,6.09817e-05)    );
  // itree = 5
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0342857,-0.0664391) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.4,-0.0169306) , 
1, 0.464914, 1, 0, 0.0717949,-0.269093) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.044381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90239,0.0572914) , 
1, -0.733781, 1, 0, 0.773771,0.172096) , 
0, -0.492335, 1, 0, 0.5,3.21229e-05)    );
  // itree = 6
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0689655,-0.0584466) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623077,0.0152768) , 
1, 0.221947, 1, 0, 0.19646,-0.173412) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.423729,-0.00032399) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.968085,0.0629826) , 
1, -0.491026, 1, 0, 0.894253,0.225195) , 
0, 0.230699, 1, 0, 0.5,-1.82886e-05)    );
  // itree = 7
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0678426) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.0381401) , 
0, -1.18567, 1, 0, 0.0717949,-0.224048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.038495) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90239,0.051513) , 
1, -0.733781, 1, 0, 0.773771,0.143265) , 
0, -0.492335, 1, 0, 0.5,1.27929e-05)    );
  // itree = 8
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0689655,-0.0534678) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.623077,0.013853) , 
1, 0.221947, 1, 0, 0.19646,-0.144261) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830258,0.0336869) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0731497) , 
0, 1.47334, 1, 0, 0.894253,0.187328) , 
0, 0.230699, 1, 0, 0.5,-2.0172e-05)    );
  // itree = 9
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.062201,-0.0516122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.610169,0.0159945) , 
1, 0.520028, 1, 0, 0.129979,-0.156719) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308511,-0.0184668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.95338,0.0532373) , 
1, -0.491026, 1, 0, 0.837476,0.142859) , 
0, -0.130818, 1, 0, 0.5,-3.94331e-05)    );
  // itree = 10
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0625986) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.0304594) , 
0, -1.18567, 1, 0, 0.0717949,-0.171231) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0332731) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90239,0.0451692) , 
1, -0.733781, 1, 0, 0.773771,0.109463) , 
0, -0.492335, 1, 0, 0.5,-7.60771e-06)    );
  // itree = 11
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113248,-0.0454805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0988587) , 
0, 1.47472, 1, 0, 0.159919,-0.12766) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.191781,-0.0348341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.939954,0.0503953) , 
0, -0.624038, 1, 0, 0.832016,0.12455) , 
1, -0.0417414, 1, 0, 0.5,-4.13133e-05)    );
  // itree = 12
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.10251,-0.0411881) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.712644,0.0208468) , 
1, 0.560482, 1, 0, 0.19646,-0.100916) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830258,0.0256908) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0676363) , 
0, 1.47334, 1, 0, 0.894253,0.131108) , 
0, 0.230699, 1, 0, 0.5,1.43892e-05)    );
  // itree = 13
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.113248,-0.0414539) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0874493) , 
0, 1.47472, 1, 0, 0.159919,-0.107715) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.12,-0.0469891) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.910088,0.0438577) , 
0, -0.966404, 1, 0, 0.832016,0.105234) , 
1, -0.0417414, 1, 0, 0.5,3.72857e-05)    );
  // itree = 14
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.057311) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.0227868) , 
0, -1.18567, 1, 0, 0.0717949,-0.122048) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0274524) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90239,0.0385521) , 
1, -0.733781, 1, 0, 0.773771,0.0781213) , 
0, -0.492335, 1, 0, 0.5,5.53541e-05)    );
  // itree = 15
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164815,-0.0333351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0791727) , 
0, 1.47472, 1, 0, 0.215652,-0.0771398) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0323797) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963158,0.0488521) , 
0, -0.624038, 1, 0, 0.884706,0.104399) , 
1, 0.304278, 1, 0, 0.5,1.40802e-05)    );
  // itree = 16
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621762,-0.0447583) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0653214) , 
0, 1.12583, 1, 0, 0.111922,-0.0991742) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0429484) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875,0.0357126) , 
0, -0.966404, 1, 0, 0.770798,0.0693973) , 
1, -0.387761, 1, 0, 0.5,0.000114418)    );
  // itree = 17
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0512821,-0.0416748) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.52,0.00393126) , 
1, -0.116588, 1, 0, 0.19646,-0.0671956) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830258,0.019764) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0621353) , 
0, 1.47334, 1, 0, 0.894253,0.0873965) , 
0, 0.230699, 1, 0, 0.5,5.19486e-05)    );
  // itree = 18
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0533317) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.0165367) , 
0, -1.18567, 1, 0, 0.0717949,-0.0877256) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.175926,-0.0229405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.90239,0.0327819) , 
1, -0.733781, 1, 0, 0.773771,0.0561603) , 
0, -0.492335, 1, 0, 0.5,4.4762e-05)    );
  // itree = 19
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164815,-0.0283645) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0718376) , 
0, 1.47472, 1, 0, 0.215652,-0.0564417) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0260738) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963158,0.0436817) , 
0, -0.624038, 1, 0, 0.884706,0.0763738) , 
1, 0.304278, 1, 0, 0.5,4.90088e-06)    );
  // itree = 20
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621762,-0.0393704) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0550145) , 
0, 1.12583, 1, 0, 0.111922,-0.0727321) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.036226) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875,0.0303192) , 
0, -0.966404, 1, 0, 0.770798,0.0508993) , 
1, -0.387761, 1, 0, 0.5,8.68404e-05)    );
  // itree = 21
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.097561,-0.0304745) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.692308,0.0317416) , 
1, 1.13879, 1, 0, 0.129979,-0.0585206) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207547,-0.018046) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.908511,0.0304091) , 
1, -1.14572, 1, 0, 0.837476,0.0534514) , 
0, -0.130818, 1, 0, 0.5,4.07493e-05)    );
  // itree = 22
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621762,-0.0367587) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0504771) , 
0, 1.12583, 1, 0, 0.111922,-0.0622198) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.033082) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875,0.0276057) , 
0, -0.966404, 1, 0, 0.770798,0.0434816) , 
1, -0.387761, 1, 0, 0.5,3.83526e-05)    );
  // itree = 23
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.21875,-0.0208705) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0639783) , 
0, 1.47472, 1, 0, 0.274809,-0.0352829) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.879808,0.017782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0609001) , 
1, 1.69496, 1, 0, 0.927536,0.0669943) , 
1, 0.650298, 1, 0, 0.5,2.73951e-06)    );
  // itree = 24
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0112782,-0.0484521) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.361204,-0.00155777) , 
1, -0.793658, 1, 0, 0.19646,-0.0398037) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.830258,0.0130658) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.058172) , 
0, 1.47334, 1, 0, 0.894253,0.0518774) , 
0, 0.230699, 1, 0, 0.5,7.76014e-05)    );
  // itree = 25
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205479,-0.0432225) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.00562255) , 
0, 0.428049, 1, 0, 0.0644172,-0.0602596) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0666667,-0.0306261) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.829525,0.0213517) , 
0, -0.966404, 1, 0, 0.710683,0.0292293) , 
1, -0.733781, 1, 0, 0.5,5.59333e-05)    );
  // itree = 26
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.256173,-0.0170514) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.961538,0.0423064) , 
0, 1.31525, 1, 0, 0.331956,-0.0246995) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.893939,0.0216633) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992958,0.0555999) , 
1, 1.65988, 1, 0, 0.945255,0.0654124) , 
1, 0.996317, 1, 0, 0.5,-8.83454e-06)    );
  // itree = 27
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0132159,-0.0471845) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.153374,-0.00698813) , 
0, -1.18567, 1, 0, 0.0717949,-0.0460611) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0606061,-0.044369) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.814558,0.0183284) , 
1, -1.77184, 1, 0, 0.773771,0.0295346) , 
0, -0.492335, 1, 0, 0.5,5.22711e-05)    );
  // itree = 28
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280415,-0.0144527) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0588405) , 
0, 1.67677, 1, 0, 0.331956,-0.0216152) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.903226,0.021749) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0588497) , 
1, 1.79142, 1, 0, 0.945255,0.0572611) , 
1, 0.996317, 1, 0, 0.5,-3.05319e-06)    );
  // itree = 29
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205479,-0.0402981) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.0040797) , 
0, 0.428049, 1, 0, 0.0644172,-0.0484209) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.207921,-0.00969877) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.925847,0.0251279) , 
0, -0.281672, 1, 0, 0.710683,0.0235074) , 
1, -0.733781, 1, 0, 0.5,5.87649e-05)    );
  // itree = 30
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.164815,-0.0181458) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0608528) , 
0, 1.47472, 1, 0, 0.215652,-0.026422) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.222222,-0.0195477) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.963158,0.0330214) , 
0, -0.624038, 1, 0, 0.884706,0.0358199) , 
1, 0.304278, 1, 0, 0.5,3.08151e-05)    );
  // itree = 31
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205479,-0.0382572) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.00320468) , 
0, 0.428049, 1, 0, 0.0644172,-0.0418853) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.037037,-0.0349535) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.802698,0.015855) , 
0, -1.30877, 1, 0, 0.710683,0.0203658) , 
1, -0.733781, 1, 0, 0.5,7.19558e-05)    );
  // itree = 32
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280415,-0.0121089) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0571188) , 
0, 1.67677, 1, 0, 0.331956,-0.0165832) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.893939,0.014944) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.992958,0.0534304) , 
1, 1.65988, 1, 0, 0.945255,0.0440074) , 
1, 0.996317, 1, 0, 0.5,1.85881e-05)    );
  // itree = 33
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0410217) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0595938) , 
0, -1.35424, 1, 0, 0.0133929,-0.0490594) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.110526,-0.0176135) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.812287,0.0154086) , 
1, -0.733781, 1, 0, 0.640464,0.0142456) , 
0, -1.21537, 1, 0, 0.5,6.52973e-05)    );
  // itree = 34
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0802752,-0.02283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.701342,0.00736208) , 
1, -0.116588, 1, 0, 0.332425,-0.0145906) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861111,0.0353185) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.978261,0.0318039) , 
1, -0.19392, 1, 0, 0.962406,0.0403481) , 
0, 0.953734, 1, 0, 0.5,2.31106e-05)    );
  // itree = 35
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0394293) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.058921) , 
0, -1.35424, 1, 0, 0.0133929,-0.0431875) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0425599) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690377,0.0104639) , 
1, -1.77184, 1, 0, 0.640464,0.0124986) , 
0, -1.21537, 1, 0, 0.5,2.49068e-05)    );
  // itree = 36
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102397,-0.0182684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.760116,0.00685927) , 
0, -0.130818, 1, 0, 0.385093,-0.0107802) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878788,0.0322289) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993827,0.0449046) , 
0, 0.231515, 1, 0, 0.974359,0.0444009) , 
1, 1.34234, 1, 0, 0.5,-1.98807e-05)    );
  // itree = 37
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.295977,-0.00976916) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0645899) , 
1, 1.91462, 1, 0, 0.332425,-0.0121313) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.861111,0.0320843) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.978261,0.0288349) , 
1, -0.19392, 1, 0, 0.962406,0.033468) , 
0, 0.953734, 1, 0, 0.5,-1.86997e-06)    );
  // itree = 38
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0559591) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.016972) , 
1, -2.05366, 1, 0, 0.0644172,-0.0283986) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00429212) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950237,0.0222993) , 
0, 0.0606942, 1, 0, 0.710683,0.0137765) , 
1, -0.733781, 1, 0, 0.5,2.74194e-05)    );
  // itree = 39
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0367001) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0576963) , 
0, -1.35424, 1, 0, 0.0133929,-0.0352903) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.039468) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690377,0.00898029) , 
1, -1.77184, 1, 0, 0.640464,0.0102149) , 
0, -1.21537, 1, 0, 0.5,2.17167e-05)    );
  // itree = 40
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.280415,-0.00930962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0559232) , 
0, 1.67677, 1, 0, 0.331956,-0.0109466) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.903226,0.0115341) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0573207) , 
1, 1.79142, 1, 0, 0.945255,0.0289535) , 
1, 0.996317, 1, 0, 0.5,-1.39623e-05)    );
  // itree = 41
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0350273) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0571304) , 
0, -1.35424, 1, 0, 0.0133929,-0.0312912) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544118,0.000187161) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0557741) , 
0, 1.4735, 1, 0, 0.640464,0.0090629) , 
0, -1.21537, 1, 0, 0.5,2.35747e-05)    );
  // itree = 42
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621762,-0.0201637) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0287501) , 
0, 1.12583, 1, 0, 0.111922,-0.019772) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0779221,-0.0144357) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.875,0.012515) , 
0, -0.966404, 1, 0, 0.770798,0.0138462) , 
1, -0.387761, 1, 0, 0.5,2.91105e-05)    );
  // itree = 43
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0551854) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0142769) , 
1, -2.05366, 1, 0, 0.0644172,-0.0218424) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00332412) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950237,0.0187264) , 
0, 0.0606942, 1, 0, 0.710683,0.0105937) , 
1, -0.733781, 1, 0, 0.5,1.95345e-05)    );
  // itree = 44
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.322845,-0.00720912) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0539463) , 
0, 1.67677, 1, 0, 0.385093,-0.00717359) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.878788,0.0264791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993827,0.0409544) , 
0, 0.231515, 1, 0, 0.974359,0.0296819) , 
1, 1.34234, 1, 0, 0.5,1.32203e-05)    );
  // itree = 45
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0322027) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0562272) , 
0, -1.35424, 1, 0, 0.0133929,-0.025659) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0356129) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690377,0.00710659) , 
1, -1.77184, 1, 0, 0.640464,0.00745869) , 
0, -1.21537, 1, 0, 0.5,4.03354e-05)    );
  // itree = 46
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.318681,-0.00688061) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.977444,0.0327923) , 
0, 1.31525, 1, 0, 0.420441,-0.00536312) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0439655) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0513225) , 
0, 0.28608, 1, 0, 0.992806,0.0333139) , 
1, 1.68836, 1, 0, 0.5,1.29905e-05)    );
  // itree = 47
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0205479,-0.0274859) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.441176,0.00492017) , 
0, 0.428049, 1, 0, 0.0644172,-0.0180773) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655477,0.00227376) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0573899) , 
1, 1.83911, 1, 0, 0.710683,0.00879877) , 
1, -0.733781, 1, 0, 0.5,3.71581e-05)    );
  // itree = 48
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0174419,-0.0271277) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0541923) , 
0, -1.4919, 1, 0, 0.0133929,-0.022079) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544118,-4.98951e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0551642) , 
0, 1.4735, 1, 0, 0.640464,0.00641838) , 
0, -1.21537, 1, 0, 0.5,3.49738e-05)    );
  // itree = 49
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.05473) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.0113564) , 
1, -2.05366, 1, 0, 0.0644172,-0.0162339) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.0022855) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950237,0.0149903) , 
0, 0.0606942, 1, 0, 0.710683,0.00790908) , 
1, -0.733781, 1, 0, 0.5,3.8476e-05)    );
  // itree = 50
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348564,-0.00523443) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0527031) , 
0, 1.67677, 1, 0, 0.420441,-0.00423978) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0398381) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.051055) , 
0, 0.28608, 1, 0, 0.992806,0.026474) , 
1, 1.68836, 1, 0, 0.5,2.94293e-05)    );
  // itree = 51
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0512155) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00260628) , 
1, 0.21655, 1, 0, 0.0133929,-0.0190782) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0321258) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690377,0.00565161) , 
1, -1.77184, 1, 0, 0.640464,0.00557382) , 
0, -1.21537, 1, 0, 0.5,5.17634e-05)    );
  // itree = 52
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0621762,-0.0140196) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.88,0.0229859) , 
0, 1.12583, 1, 0, 0.111922,-0.0114549) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.712766,0.00199659) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0564579) , 
1, 1.78923, 1, 0, 0.770798,0.00802999) , 
1, -0.387761, 1, 0, 0.5,2.17145e-05)    );
  // itree = 53
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0510831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00212935) , 
1, 0.21655, 1, 0, 0.0133929,-0.01698) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544118,-0.000162728) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0549247) , 
0, 1.4735, 1, 0, 0.640464,0.00494018) , 
0, -1.21537, 1, 0, 0.5,3.00724e-05)    );
  // itree = 54
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00854701,-0.0347114) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206522,0.000420068) , 
0, -0.269729, 1, 0, 0.0644172,-0.0122921) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655477,0.00147483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0565558) , 
1, 1.83911, 1, 0, 0.710683,0.00598512) , 
1, -0.733781, 1, 0, 0.5,2.67427e-05)    );
  // itree = 55
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0150754,-0.0239831) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0555584) , 
0, -1.35424, 1, 0, 0.0133929,-0.014806) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0302967) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690377,0.00464178) , 
1, -1.77184, 1, 0, 0.640464,0.00430361) , 
0, -1.21537, 1, 0, 0.5,2.30603e-05)    );
  // itree = 56
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348564,-0.00405198) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.052062) , 
0, 1.67677, 1, 0, 0.420441,-0.00304954) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0331179) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0507968) , 
0, 0.28608, 1, 0, 0.992806,0.0189507) , 
1, 1.68836, 1, 0, 0.5,8.49406e-06)    );
  // itree = 57
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0541517) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0789474,-0.007499) , 
1, -2.05366, 1, 0, 0.0644172,-0.0104373) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.309524,-0.00207349) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.950237,0.0112892) , 
0, 0.0606942, 1, 0, 0.710683,0.00508756) , 
1, -0.733781, 1, 0, 0.5,2.64586e-05)    );
  // itree = 58
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.050895) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00555778) , 
1, 0.21655, 1, 0, 0.0133929,-0.0128479) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544118,-0.000394672) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.054921) , 
0, 1.4735, 1, 0, 0.640464,0.00373344) , 
0, -1.21537, 1, 0, 0.5,1.92067e-05)    );
  // itree = 59
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348564,-0.00347668) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0517158) , 
0, 1.67677, 1, 0, 0.420441,-0.00266406) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.03122) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0507016) , 
0, 0.28608, 1, 0, 0.992806,0.0166261) , 
1, 1.68836, 1, 0, 0.5,1.72774e-05)    );
  // itree = 60
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.00854701,-0.0316378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.206522,0.00116807) , 
0, -0.269729, 1, 0, 0.0644172,-0.00915835) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.655477,0.00110157) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0559216) , 
1, 1.83911, 1, 0, 0.710683,0.00447617) , 
1, -0.733781, 1, 0, 0.5,3.13157e-05)    );
  // itree = 61
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.050791) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00521294) , 
1, 0.21655, 1, 0, 0.0133929,-0.0110748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0338983,-0.0266959) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.690377,0.0036518) , 
1, -1.77184, 1, 0, 0.640464,0.00323289) , 
0, -1.21537, 1, 0, 0.5,2.79664e-05)    );
  // itree = 62
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348564,-0.00298263) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0515397) , 
0, 1.67677, 1, 0, 0.420441,-0.00216708) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.02697) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0505959) , 
0, 0.28608, 1, 0, 0.992806,0.013493) , 
1, 1.68836, 1, 0, 0.5,9.66962e-06)    );
  // itree = 63
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0507107) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00497232) , 
1, 0.21655, 1, 0, 0.0133929,-0.00989607) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.276873,-0.00302368) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.878465,0.00810127) , 
0, 0.132933, 1, 0, 0.640464,0.00288508) , 
0, -1.21537, 1, 0, 0.5,2.2098e-05)    );
  // itree = 64
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680473,-0.0131525) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315068,0.00843073) , 
1, -0.69136, 1, 0, 0.111922,-0.00621762) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.5,-0.00103472) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.976119,0.0151492) , 
0, 0.40306, 1, 0, 0.770798,0.00435433) , 
1, -0.387761, 1, 0, 0.5,9.25798e-06)    );
  // itree = 65
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0540283) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0125117) , 
1, -2.10647, 1, 0, 0.0192308,-0.0141123) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0528935) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584507,0.00221471) , 
0, -2.14632, 1, 0, 0.555804,0.00164831) , 
1, -1.77184, 1, 0, 0.5,9.20726e-06)    );
  // itree = 66
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348564,-0.0026805) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0514159) , 
0, 1.67677, 1, 0, 0.420441,-0.00191601) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0252741) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0505124) , 
0, 0.28608, 1, 0, 0.992806,0.0118596) , 
1, 1.68836, 1, 0, 0.5,-1.1923e-06)    );
  // itree = 67
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0174419,-0.0108245) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0543378) , 
0, -1.4919, 1, 0, 0.0133929,-0.00826308) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.544118,-0.000543546) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.055402) , 
0, 1.4735, 1, 0, 0.640464,0.00239889) , 
0, -1.21537, 1, 0, 0.5,1.06103e-05)    );
  // itree = 68
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0680473,-0.0119754) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.315068,0.0077301) , 
1, -0.69136, 1, 0, 0.111922,-0.00532605) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547414,0.00593635) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915966,-0.00144974) , 
1, 0.604081, 1, 0, 0.770798,0.00374175) , 
1, -0.387761, 1, 0, 0.5,1.48866e-05)    );
  // itree = 69
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.348564,-0.00231564) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.051185) , 
0, 1.67677, 1, 0, 0.420441,-0.00169939) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.964286,0.0237199) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0504649) , 
0, 0.28608, 1, 0, 0.992806,0.0106052) , 
1, 1.68836, 1, 0, 0.5,1.09493e-05)    );
  // itree = 70
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0536044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0392157,-0.0105322) , 
1, -2.10647, 1, 0, 0.0192308,-0.0119989) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0525703) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584507,0.00195203) , 
0, -2.14632, 1, 0, 0.555804,0.00141482) , 
1, -1.77184, 1, 0, 0.5,1.97937e-05)    );
  // itree = 71
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397077,-0.000425626) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0235261) , 
1, 1.43312, 1, 0, 0.420441,-0.00152629) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,0.00109044) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.055874) , 
1, 1.88734, 1, 0, 0.992806,0.00952294) , 
1, 1.68836, 1, 0, 0.5,9.54935e-06)    );
  // itree = 72
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0173611,-0.019351) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.333333,0.00397015) , 
0, -0.269729, 1, 0, 0.111922,-0.0044557) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.547414,0.00551502) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915966,-0.00200453) , 
1, 0.604081, 1, 0, 0.770798,0.00313525) , 
1, -0.387761, 1, 0, 0.5,1.53712e-05)    );
  // itree = 73
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13215,0.000415379) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00574361) , 
0, 0.230699, 1, 0, 0.331956,-0.00226738) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791045,-0.00522036) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.995169,0.03607) , 
0, 0.292796, 1, 0, 0.945255,0.0060414) , 
1, 0.996317, 1, 0, 0.5,9.22757e-06)    );
  // itree = 74
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.050246) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0539539) , 
0, -1.25421, 1, 0, 0,-0.015464) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415686,-0.000985931) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.0362807) , 
0, 1.37285, 1, 0, 0.527426,0.000865515) , 
1, -2.11786, 1, 0, 0.5,1.63789e-05)    );
  // itree = 75
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0505822) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00896959) , 
1, 0.21655, 1, 0, 0.0133929,-0.00662521) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138298,0.0125403) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709677,-0.000383386) , 
0, -0.760779, 1, 0, 0.640464,0.00193377) , 
0, -1.21537, 1, 0, 0.5,1.6562e-05)    );
  // itree = 76
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397077,-0.000317765) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0218935) , 
1, 1.43312, 1, 0, 0.420441,-0.00132431) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.000179346) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0554963) , 
1, 1.88734, 1, 0, 0.992806,0.00823419) , 
1, 1.68836, 1, 0, 0.5,4.31768e-06)    );
  // itree = 77
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.0131013) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.0334135) , 
1, -2.02438, 1, 0, 0.0192308,-0.00968327) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0524512) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.584507,0.00162531) , 
0, -2.14632, 1, 0, 0.555804,0.00113492) , 
1, -1.77184, 1, 0, 0.5,9.83042e-06)    );
  // itree = 78
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501957) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0535085) , 
0, -1.25421, 1, 0, 0,-0.0134689) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415686,-0.000930918) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.0348737) , 
0, 1.37285, 1, 0, 0.527426,0.000742669) , 
1, -2.11786, 1, 0, 0.5,3.66807e-06)    );
  // itree = 79
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13215,0.000787836) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00555531) , 
0, 0.230699, 1, 0, 0.331956,-0.00184196) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791045,-0.00502727) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.995169,0.0342345) , 
0, 0.292796, 1, 0, 0.945255,0.00489836) , 
1, 0.996317, 1, 0, 0.5,4.88765e-06)    );
  // itree = 80
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0505182) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00902595) , 
1, 0.21655, 1, 0, 0.0133929,-0.00557366) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138298,0.011158) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709677,-0.000444004) , 
0, -0.760779, 1, 0, 0.640464,0.00162308) , 
0, -1.21537, 1, 0, 0.5,1.10085e-05)    );
  // itree = 81
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397077,-0.000208865) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.020707) , 
1, 1.43312, 1, 0, 0.420441,-0.00114014) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.00149989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0550943) , 
1, 1.88734, 1, 0, 0.992806,0.00706715) , 
1, 1.68836, 1, 0, 0.5,6.72112e-07)    );
  // itree = 82
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501602) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0531409) , 
0, -1.25421, 1, 0, 0,-0.0119925) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415686,-0.000824371) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.0332374) , 
0, 1.37285, 1, 0, 0.527426,0.000663975) , 
1, -2.11786, 1, 0, 0.5,5.84044e-06)    );
  // itree = 83
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0504684) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00826081) , 
1, 0.21655, 1, 0, 0.0133929,-0.00495682) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138298,0.00996518) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709677,-0.000417717) , 
0, -0.760779, 1, 0, 0.640464,0.00143916) , 
0, -1.21537, 1, 0, 0.5,6.45985e-06)    );
  // itree = 84
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397077,-0.000167176) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0186752) , 
1, 1.43312, 1, 0, 0.420441,-0.00101467) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.00181901) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0545823) , 
1, 1.88734, 1, 0, 0.992806,0.00626796) , 
1, 1.68836, 1, 0, 0.5,-2.38086e-06)    );
  // itree = 85
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.050131) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0528491) , 
0, -1.25421, 1, 0, 0,-0.0107301) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.0943396,-0.00347989) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.805893,0.00282954) , 
0, -0.386733, 1, 0, 0.527426,0.000591223) , 
1, -2.11786, 1, 0, 0.5,2.51552e-06)    );
  // itree = 86
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102041,-0.00572405) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757576,0.00312692) , 
0, -0.252917, 1, 0, 0.425287,-0.000950748) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0514885) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0502537) , 
1, 0.232057, 1, 0, 1,0.00635968) , 
0, 1.67677, 1, 0, 0.5,-3.91945e-07)    );
  // itree = 87
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13215,0.00130206) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00575177) , 
0, 0.230699, 1, 0, 0.331956,-0.001486) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.6,-0.00567702) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.987705,0.0182893) , 
0, -0.223382, 1, 0, 0.945255,0.00394875) , 
1, 0.996317, 1, 0, 0.5,3.12509e-06)    );
  // itree = 88
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.015873,-0.00382328) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.0243902,-0.03254) , 
1, -2.02438, 1, 0, 0.0192308,-0.00674115) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.317254,0.00252222) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.915966,-0.00433699) , 
1, 0.606954, 1, 0, 0.555804,0.000788858) , 
1, -1.77184, 1, 0, 0.5,5.73762e-06)    );
  // itree = 89
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.308908,0.000616862) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.87156,-0.0121526) , 
1, 0.877037, 1, 0, 0.385093,-0.00116043) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.92,0.0138331) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.993103,0.00543231) , 
0, 0.473204, 1, 0, 0.974359,0.00481111) , 
1, 1.34234, 1, 0, 0.5,4.01646e-06)    );
  // itree = 90
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13215,0.00102639) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00517958) , 
0, 0.230699, 1, 0, 0.331956,-0.00146729) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.791045,-0.00441553) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.995169,0.0318241) , 
0, 0.292796, 1, 0, 0.945255,0.00390646) , 
1, 0.996317, 1, 0, 0.5,5.11429e-06)    );
  // itree = 91
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0501169) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0525295) , 
0, -1.25421, 1, 0, 0,-0.00957506) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.415686,-0.000706962) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.994536,0.030832) , 
0, 1.37285, 1, 0, 0.527426,0.000535426) , 
1, -2.11786, 1, 0, 0.5,9.68113e-06)    );
  // itree = 92
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0504209) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.111111,0.00919645) , 
1, 0.21655, 1, 0, 0.0133929,-0.00401232) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.138298,0.00975757) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.709677,-0.000621283) , 
0, -0.760779, 1, 0, 0.640464,0.00117049) , 
0, -1.21537, 1, 0, 0.5,9.53924e-06)    );
  // itree = 93
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.397077,-4.57898e-06) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.9,-0.0193727) , 
1, 1.43312, 1, 0, 0.420441,-0.000826572) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.97619,-0.00423782) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0543905) , 
1, 1.88734, 1, 0, 0.992806,0.00512854) , 
1, 1.68836, 1, 0, 0.5,1.18865e-06)    );
  // itree = 94
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13215,0.00104378) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00475891) , 
0, 0.230699, 1, 0, 0.331956,-0.00126274) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.864865,-0.00330234) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0512099) , 
0, 0.808974, 1, 0, 0.945255,0.0033648) , 
1, 0.996317, 1, 0, 0.5,5.20531e-06)    );
  // itree = 95
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0500958) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0522643) , 
0, -1.25421, 1, 0, 0,-0.00855027) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0523483) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.556174,0.000971073) , 
0, -2.14632, 1, 0, 0.527426,0.000481204) , 
1, -2.11786, 1, 0, 0.5,1.15676e-05)    );
  // itree = 96
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102041,-0.00520737) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757576,0.00299343) , 
0, -0.252917, 1, 0, 0.425287,-0.000761778) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0512954) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0501945) , 
1, 0.232057, 1, 0, 1,0.00514104) , 
0, 1.67677, 1, 0, 0.5,5.58852e-06)    );
  // itree = 97
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.13215,0.00119533) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.794521,-0.00475226) , 
0, 0.230699, 1, 0, 0.331956,-0.00113198) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.902439,0.0140955) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.95279,0.000987782) , 
1, 1.13373, 1, 0, 0.945255,0.00302802) , 
1, 0.996317, 1, 0, 0.5,7.8565e-06)    );
  // itree = 98
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.050086) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0,-0.0520501) , 
0, -1.25421, 1, 0, 0,-0.00771141) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.121469,-0.00317911) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.76936,0.00205459) , 
1, -0.431239, 1, 0, 0.527426,0.000431167) , 
1, -2.11786, 1, 0, 0.5,7.75315e-06)    );
  // itree = 99
  fBoostWeights.push_back(1);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 0.102041,-0.00492775) , 
NN(
0, 
0, 
-1, 0, 1, -99, 0.757576,0.00286821) , 
0, -0.252917, 1, 0, 0.425287,-0.000692368) , 
NN(
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0511896) , 
NN(
0, 
0, 
-1, 0, 1, -99, 1,0.0501749) , 
1, 0.232057, 1, 0, 1,0.00467197) , 
0, 1.67677, 1, 0, 0.5,4.99567e-06)    );
   return;
};

// Clean up
inline void ReadBDTG_fold2::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDTG_fold2::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
