//Code generated automatically by TMVA for Inference of Model file [encoder] at [Sun Nov 16 02:57:26 2025] 

#ifndef ROOT_TMVA_SOFIE_ENCODER
#define ROOT_TMVA_SOFIE_ENCODER

#include <cmath>
#include <algorithm>
#include <vector>
#include "TMVA/SOFIE_common.hxx"
#include <fstream>

namespace TMVA_SOFIE_encoder{
namespace BLAS{
	extern "C" void sgemm_(const char * transa, const char * transb, const int * m, const int * n, const int * k,
	                       const float * alpha, const float * A, const int * lda, const float * B, const int * ldb,
	                       const float * beta, float * C, const int * ldc);
}//BLAS


namespace Edge_Update{
struct Session {

//--------- GNN_Update_Function---edge_update
// initialized tensors
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0w0 = std::vector<float>(400);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0.data();

// --- Positioning intermediate tensor memory --//--- declare the dynamic tensors
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast = nullptr;
std::vector<float> fTensor_edge_updateGemm2;
float * tensor_edge_updateGemm2 = nullptr;
std::vector<float> fTensor_edge_updateRelu1;
float * tensor_edge_updateRelu1 = nullptr;
std::vector<float> fTensor_edge_updateRelu4;
float * tensor_edge_updateRelu4 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast = nullptr;
std::vector<float> fTensor_edge_updateGemm4;
float * tensor_edge_updateGemm4 = nullptr;
std::vector<float> fTensor_edge_updateRelu2;
float * tensor_edge_updateRelu2 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast = nullptr;
std::vector<float> fTensor_edge_updateRelu0;
float * tensor_edge_updateRelu0 = nullptr;
std::vector<float> fTensor_edge_updateGemm0;
float * tensor_edge_updateGemm0 = nullptr;
std::vector<float> fTensor_edge_updateGemm1;
float * tensor_edge_updateGemm1 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast = nullptr;


Session(std::string filename ="encoder.dat",
        size_t num_edges = 300) {

//--- reading weights from file
   std::ifstream f;
   f.open(filename);
   if (!f.is_open()) {
      throw std::runtime_error("tmva-sofie failed to open file " + filename + " for input weights");
   }
   f.seekg(0);
   using TMVA::Experimental::SOFIE::ReadTensorFromStream;
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0w0", 400);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0", 100);
   f.close();

   if (num_edges * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast.resize(num_edges * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateGemm2.resize(num_edges * 100);
      tensor_edge_updateGemm2 = fTensor_edge_updateGemm2.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateRelu1.resize(num_edges * 100);
      tensor_edge_updateRelu1 = fTensor_edge_updateRelu1.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateRelu4.resize(num_edges * 100);
      tensor_edge_updateRelu4 = fTensor_edge_updateRelu4.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast.resize(num_edges * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateGemm4.resize(num_edges * 100);
      tensor_edge_updateGemm4 = fTensor_edge_updateGemm4.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateRelu2.resize(num_edges * 100);
      tensor_edge_updateRelu2 = fTensor_edge_updateRelu2.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast.resize(num_edges * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateRelu0.resize(num_edges * 100);
      tensor_edge_updateRelu0 = fTensor_edge_updateRelu0.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateGemm0.resize(num_edges * 100);
      tensor_edge_updateGemm0 = fTensor_edge_updateGemm0.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_edge_updateGemm1.resize(num_edges * 100);
      tensor_edge_updateGemm1 = fTensor_edge_updateGemm1.data();
   }
   if (num_edges * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast.resize(num_edges * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast.data();
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0,{ 100 }, { num_edges , 100 });
      std::copy(data, data + num_edges * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast);
      delete [] data;
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0,{ 100 }, { num_edges , 100 });
      std::copy(data, data + num_edges * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast);
      delete [] data;
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0,{ 100 }, { num_edges , 100 });
      std::copy(data, data + num_edges * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast);
      delete [] data;
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0,{ 100 }, { num_edges , 100 });
      std::copy(data, data + num_edges * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast);
      delete [] data;
   }
}

void doInfer(size_t num_edges,float const* tensor_edge,  std::vector<float> &output_tensor_edge_updateRelu4 ){


//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_edge_updateGemm0, false, false, 100, num_edges, 4, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0w0, tensor_edge, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_0b0bcast);

//------ RELU
   for (int id = 0; id < num_edges * 100 ; id++){
      tensor_edge_updateRelu0[id] = ((tensor_edge_updateGemm0[id] > 0 )? tensor_edge_updateGemm0[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_edge_updateGemm1, false, false, 100, num_edges, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1w0, tensor_edge_updateRelu0, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_1b0bcast);

//------ RELU
   for (int id = 0; id < num_edges * 100 ; id++){
      tensor_edge_updateRelu1[id] = ((tensor_edge_updateGemm1[id] > 0 )? tensor_edge_updateGemm1[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_edge_updateGemm2, false, false, 100, num_edges, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2w0, tensor_edge_updateRelu1, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_2b0bcast);

//------ RELU
   for (int id = 0; id < num_edges * 100 ; id++){
      tensor_edge_updateRelu2[id] = ((tensor_edge_updateGemm2[id] > 0 )? tensor_edge_updateGemm2[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_edge_updateGemm4, false, false, 100, num_edges, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3w0, tensor_edge_updateRelu2, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentedge_modelmlplinear_3b0bcast);

//------ RELU
   for (int id = 0; id < num_edges * 100 ; id++){
      tensor_edge_updateRelu4[id] = ((tensor_edge_updateGemm4[id] > 0 )? tensor_edge_updateGemm4[id] : 0);
   }
   using TMVA::Experimental::SOFIE::UTILITY::FillOutput;

   FillOutput(tensor_edge_updateRelu4, output_tensor_edge_updateRelu4, num_edges * 100);
}



std::vector<float> infer(size_t num_edges,float const* tensor_edge){
   std::vector<float > output_tensor_edge_updateRelu4;
   doInfer(num_edges,tensor_edge, output_tensor_edge_updateRelu4 );
   return {output_tensor_edge_updateRelu4};
}
};
}


namespace Node_Update{
struct Session {

//--------- GNN_Update_Function---node_update
// initialized tensors
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0w0 = std::vector<float>(400);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0.data();

// --- Positioning intermediate tensor memory --//--- declare the dynamic tensors
std::vector<float> fTensor_node_updateGemm4;
float * tensor_node_updateGemm4 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast = nullptr;
std::vector<float> fTensor_node_updateRelu2;
float * tensor_node_updateRelu2 = nullptr;
std::vector<float> fTensor_node_updateRelu4;
float * tensor_node_updateRelu4 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast = nullptr;
std::vector<float> fTensor_node_updateGemm2;
float * tensor_node_updateGemm2 = nullptr;
std::vector<float> fTensor_node_updateGemm1;
float * tensor_node_updateGemm1 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast = nullptr;
std::vector<float> fTensor_node_updateRelu0;
float * tensor_node_updateRelu0 = nullptr;
std::vector<float> fTensor_node_updateRelu1;
float * tensor_node_updateRelu1 = nullptr;
std::vector<float> fTensor_node_updateGemm0;
float * tensor_node_updateGemm0 = nullptr;
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast;
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast = nullptr;


Session(std::string filename ="encoder.dat",
        size_t num_nodes = 100) {

//--- reading weights from file
   std::ifstream f;
   f.open(filename);
   if (!f.is_open()) {
      throw std::runtime_error("tmva-sofie failed to open file " + filename + " for input weights");
   }
   f.seekg(402257);
   using TMVA::Experimental::SOFIE::ReadTensorFromStream;
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0w0", 400);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0", 100);
   f.close();

   if (num_nodes * 100 > 0) {
      fTensor_node_updateGemm4.resize(num_nodes * 100);
      tensor_node_updateGemm4 = fTensor_node_updateGemm4.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast.resize(num_nodes * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateRelu2.resize(num_nodes * 100);
      tensor_node_updateRelu2 = fTensor_node_updateRelu2.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateRelu4.resize(num_nodes * 100);
      tensor_node_updateRelu4 = fTensor_node_updateRelu4.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast.resize(num_nodes * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateGemm2.resize(num_nodes * 100);
      tensor_node_updateGemm2 = fTensor_node_updateGemm2.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateGemm1.resize(num_nodes * 100);
      tensor_node_updateGemm1 = fTensor_node_updateGemm1.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast.resize(num_nodes * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateRelu0.resize(num_nodes * 100);
      tensor_node_updateRelu0 = fTensor_node_updateRelu0.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateRelu1.resize(num_nodes * 100);
      tensor_node_updateRelu1 = fTensor_node_updateRelu1.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_node_updateGemm0.resize(num_nodes * 100);
      tensor_node_updateGemm0 = fTensor_node_updateGemm0.data();
   }
   if (num_nodes * 100 > 0) {
      fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast.resize(num_nodes * 100);
      tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast.data();
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0,{ 100 }, { num_nodes , 100 });
      std::copy(data, data + num_nodes * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast);
      delete [] data;
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0,{ 100 }, { num_nodes , 100 });
      std::copy(data, data + num_nodes * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast);
      delete [] data;
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0,{ 100 }, { num_nodes , 100 });
      std::copy(data, data + num_nodes * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast);
      delete [] data;
   }
//--- broadcast bias tensor EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0for Gemm op
   {
      float * data = TMVA::Experimental::SOFIE::UTILITY::UnidirectionalBroadcast<float>(tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0,{ 100 }, { num_nodes , 100 });
      std::copy(data, data + num_nodes * 100, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast);
      delete [] data;
   }
}

void doInfer(size_t num_nodes,float const* tensor_node,  std::vector<float> &output_tensor_node_updateRelu4 ){


//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_node_updateGemm0, false, false, 100, num_nodes, 4, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0w0, tensor_node, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_0b0bcast);

//------ RELU
   for (int id = 0; id < num_nodes * 100 ; id++){
      tensor_node_updateRelu0[id] = ((tensor_node_updateGemm0[id] > 0 )? tensor_node_updateGemm0[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_node_updateGemm1, false, false, 100, num_nodes, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1w0, tensor_node_updateRelu0, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_1b0bcast);

//------ RELU
   for (int id = 0; id < num_nodes * 100 ; id++){
      tensor_node_updateRelu1[id] = ((tensor_node_updateGemm1[id] > 0 )? tensor_node_updateGemm1[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_node_updateGemm2, false, false, 100, num_nodes, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2w0, tensor_node_updateRelu1, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_2b0bcast);

//------ RELU
   for (int id = 0; id < num_nodes * 100 ; id++){
      tensor_node_updateRelu2[id] = ((tensor_node_updateGemm2[id] > 0 )? tensor_node_updateGemm2[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_node_updateGemm4, false, false, 100, num_nodes, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3w0, tensor_node_updateRelu2, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentnode_modelmlplinear_3b0bcast);

//------ RELU
   for (int id = 0; id < num_nodes * 100 ; id++){
      tensor_node_updateRelu4[id] = ((tensor_node_updateGemm4[id] > 0 )? tensor_node_updateGemm4[id] : 0);
   }
   using TMVA::Experimental::SOFIE::UTILITY::FillOutput;

   FillOutput(tensor_node_updateRelu4, output_tensor_node_updateRelu4, num_nodes * 100);
}



std::vector<float> infer(size_t num_nodes,float const* tensor_node){
   std::vector<float > output_tensor_node_updateRelu4;
   doInfer(num_nodes,tensor_node, output_tensor_node_updateRelu4 );
   return {output_tensor_node_updateRelu4};
}
};
}


namespace Global_Update{
struct Session {

//--------- GNN_Update_Function---global_update
// initialized tensors
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1w0 = std::vector<float>(10000);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3b0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0w0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0w0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0w0.data();
std::vector<float> fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0b0 = std::vector<float>(100);
float * tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0b0 = fTensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0b0.data();

//--- Allocating session memory pool to be used for allocating intermediate tensors
std::vector<char> fIntermediateMemoryPool = std::vector<char>(3200);


// --- Positioning intermediate tensor memory --
 // Allocating memory for intermediate tensor global_updateGemm0 with size 400 bytes
float* tensor_global_updateGemm0 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 0);

 // Allocating memory for intermediate tensor global_updateRelu0 with size 400 bytes
float* tensor_global_updateRelu0 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 400);

 // Allocating memory for intermediate tensor global_updateGemm1 with size 400 bytes
float* tensor_global_updateGemm1 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 800);

 // Allocating memory for intermediate tensor global_updateRelu1 with size 400 bytes
float* tensor_global_updateRelu1 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 1200);

 // Allocating memory for intermediate tensor global_updateGemm2 with size 400 bytes
float* tensor_global_updateGemm2 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 1600);

 // Allocating memory for intermediate tensor global_updateRelu2 with size 400 bytes
float* tensor_global_updateRelu2 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 2000);

 // Allocating memory for intermediate tensor global_updateGemm4 with size 400 bytes
float* tensor_global_updateGemm4 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 2400);

 // Allocating memory for intermediate tensor global_updateRelu4 with size 400 bytes
float* tensor_global_updateRelu4 = reinterpret_cast<float*>(fIntermediateMemoryPool.data() + 2800);


Session(std::string filename ="encoder.dat") {

//--- reading weights from file
   std::ifstream f;
   f.open(filename);
   if (!f.is_open()) {
      throw std::runtime_error("tmva-sofie failed to open file " + filename + " for input weights");
   }
   f.seekg(804758);
   using TMVA::Experimental::SOFIE::ReadTensorFromStream;
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1w0", 10000);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3b0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0w0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0w0", 100);
   ReadTensorFromStream(f, tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0b0, "tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0b0", 100);
   f.close();

}

void doInfer(float const* tensor_global,  std::vector<float> &output_tensor_global_updateRelu4 ){


//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_global_updateGemm0, false, false, 100, 1, 1, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0w0, tensor_global, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_0b0);

//------ RELU
   for (int id = 0; id < 100 ; id++){
      tensor_global_updateRelu0[id] = ((tensor_global_updateGemm0[id] > 0 )? tensor_global_updateGemm0[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_global_updateGemm1, false, false, 100, 1, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1w0, tensor_global_updateRelu0, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_1b0);

//------ RELU
   for (int id = 0; id < 100 ; id++){
      tensor_global_updateRelu1[id] = ((tensor_global_updateGemm1[id] > 0 )? tensor_global_updateGemm1[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_global_updateGemm2, false, false, 100, 1, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2w0, tensor_global_updateRelu1, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_2b0);

//------ RELU
   for (int id = 0; id < 100 ; id++){
      tensor_global_updateRelu2[id] = ((tensor_global_updateGemm2[id] > 0 )? tensor_global_updateGemm2[id] : 0);
   }

//--------- Gemm
   TMVA::Experimental::SOFIE::Gemm_Call(tensor_global_updateGemm4, false, false, 100, 1, 100, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3w0, tensor_global_updateRelu2, 1,tensor_EncodeProcessDecodeMLPGraphIndependentgraph_independentglobal_modelmlplinear_3b0);

//------ RELU
   for (int id = 0; id < 100 ; id++){
      tensor_global_updateRelu4[id] = ((tensor_global_updateGemm4[id] > 0 )? tensor_global_updateGemm4[id] : 0);
   }
   using TMVA::Experimental::SOFIE::UTILITY::FillOutput;

   FillOutput(tensor_global_updateRelu4, output_tensor_global_updateRelu4, 100);
}



std::vector<float> infer(float const* tensor_global){
   std::vector<float > output_tensor_global_updateRelu4;
   doInfer(tensor_global, output_tensor_global_updateRelu4 );
   return {output_tensor_global_updateRelu4};
}
};
}
struct Session {

// Instantiating session objects for graph components
Edge_Update::Session edge_update;
std::vector<float> fEdgeInputs = std::vector<float>(300*4);
Node_Update::Session node_update;
std::vector<float> fNodeInputs = std::vector<float>(100*4);
Global_Update::Session global_update;


void infer(TMVA::Experimental::SOFIE::GNN_Data& input_graph){

// --- Edge Update ---
size_t n_edges = input_graph.edge_data.GetShape()[0];
for (size_t k = 0; k < n_edges; k++) { 
   std::copy(input_graph.edge_data.GetData() + k * 4, input_graph.edge_data.GetData() + (k + 1) * 4, fEdgeInputs.begin() + k * 4);
}
auto edgeUpdates = edge_update.infer(n_edges,fEdgeInputs.data());

//  resize edge graph data since output feature size is not equal to input size
input_graph.edge_data = input_graph.edge_data.Resize({ n_edges, 100});

for (size_t k = 0; k < n_edges; k++) { 
   std::copy(edgeUpdates.begin()+ k * 100, edgeUpdates.begin()+ (k+1) * 100,input_graph.edge_data.GetData() + k * 100);
}


// --- Node Update ---
size_t n_nodes = input_graph.node_data.GetShape()[0];
for (size_t k = 0; k < n_nodes; k++) { 
   std::copy(input_graph.node_data.GetData() + k * 4, input_graph.node_data.GetData() + (k + 1) * 4, fNodeInputs.begin() + k * 4);
}
auto nodeUpdates = node_update.infer(n_nodes,fNodeInputs.data());

//  resize node graph data since output feature size is not equal to input size
input_graph.node_data = input_graph.node_data.Resize({ n_nodes, 100});

for (size_t k = 0; k < n_nodes; k++) { 
   std::copy(nodeUpdates.begin()+ k * 100, nodeUpdates.begin() + (k+1) * 100,input_graph.node_data.GetData() + k * 100);
}


// --- Global Update ---
std::vector<float> Global_Data = global_update.infer(input_graph.global_data.GetData());

//  resize global graph data since output feature size is not equal to input size
input_graph.global_data = input_graph.global_data.Resize({100});

std::copy(Global_Data.begin(), Global_Data.end(), input_graph.global_data.GetData());
}
};
} //TMVA_SOFIE_encoder

#endif  // TMVA_SOFIE_ROOT_TMVA_SOFIE_ENCODER
