// -*- mode: c++ -*-
// 
// File pca.C generated by TPrincipal::MakeCode
// on Sun Nov 16 04:00:08 2025
// ROOT version 6.37.99
//
// This file contains the functions 
//
//    void  X2P(Double_t *x, Double_t *p); 
//    void  P2X(Double_t *p, Double_t *x, Int_t nTest);
//
// The first for transforming original data x in 
// pattern space, to principal components p in 
// feature space. The second function is for the
// inverse transformation, but using only nTest
// of the principal components in the expansion
// 
// See TPrincipal class documentation for more information 
// 
#include <Rtypes.h> // needed for Double_t etc
//
// Static data variables
//
static Int_t    gNVariables = 10;

// Assignment of eigenvector matrix.
// Elements are stored row-wise, that is
//    M[i][j] = e[i * nVariables + j] 
// where i and j are zero-based
static Double_t gEigenVectors[] = {
  0.105952,
  -0.0412338,
  -0.163932,
  0.506955,
  -0.293327,
  -0.45912,
  0.611921,
  0.0384342,
  0.129259,
  -0.117186,
  0.299103,
  0.114816,
  -0.423035,
  0.173049,
  0.129852,
  -0.264772,
  -0.58561,
  0.109388,
  0.367886,
  -0.333525,
  0.196631,
  0.182178,
  0.334538,
  0.0979602,
  -0.695575,
  0.431875,
  -0.124202,
  0.0747925,
  0.251537,
  -0.228043,
  0.0946521,
  0.0513485,
  0.107011,
  0.552681,
  0.561861,
  0.539862,
  0.180077,
  0.0384417,
  0.129284,
  -0.117209,
  0.294184,
  0.179444,
  0.157981,
  -0.594249,
  0.257622,
  -0.0673251,
  0.421439,
  0.108562,
  0.365107,
  -0.331006,
  0.135669,
  -0.895902,
  -0.0723783,
  -0.0912176,
  -0.0511243,
  0.155245,
  0.0072091,
  -0.0672496,
  0.358401,
  0.0751904,
  0.0393664,
  -0.129504,
  0.791462,
  0.188712,
  0.167449,
  -0.456201,
  -0.235961,
  -0.14376,
  0.0761992,
  -0.0366798,
  0.501306,
  -0.134663,
  0.0961035,
  0.0147716,
  0.015782,
  -0.0347285,
  -0.0292305,
  0.730756,
  -0.387333,
  0.186449,
  0.503961,
  -0.111486,
  -0.060855,
  -0.0228244,
  -0.0175214,
  0.0561781,
  0.0175518,
  -0.543542,
  -0.538041,
  -0.375064,
  0.4898,
  0.259068,
  -0.0353844,
  0.0139158,
  0.00266293,
  -0.00485772,
  0.0160046,
  -0.336256,
  0.246763,
  0.719227};

// Assignment to eigen value vector. Zero-based.
static Double_t gEigenValues[] = {
  0.385122,
  0.110703,
  0.103572,
  0.101548,
  0.100795,
  0.0996221,
  0.0986388,
  6.48061e-16,
  2.20158e-16,
  5.49744e-16
};

// Assignment to mean value vector. Zero-based.
static Double_t gMeanValues[] = {
  5.0082,
  7.9976,
  1.96735,
  5.0162,
  8.0087,
  2.01253,
  4.99247,
  35.0031,
  30.0106,
  27.9981
};

// Assignment to sigma value vector. Zero-based.
static Double_t gSigmaValues[] = {
  1.00507,
  2.86056,
  1.95587,
  1.00527,
  2.83895,
  1.97263,
  1.01426,
  5.15563,
  5.04925,
  4.64883
};

// 
// The function   void X2P(Double_t *x, Double_t *p)
// 
void X2P(Double_t *x, Double_t *p) {
  for (Int_t i = 0; i < gNVariables; i++) {
    p[i] = 0;
    for (Int_t j = 0; j < gNVariables; j++)
      p[i] += (x[j] - gMeanValues[j]) 
        * gEigenVectors[j *  gNVariables + i] / gSigmaValues[j];

  }
}

// 
// The function   void P2X(Double_t *p, Double_t *x, Int_t nTest)
// 
void P2X(Double_t *p, Double_t *x, Int_t nTest) {
  for (Int_t i = 0; i < gNVariables; i++) {
    x[i] = gMeanValues[i];
    for (Int_t j = 0; j < nTest; j++)
      x[i] += p[j] * gSigmaValues[i] 
        * gEigenVectors[i *  gNVariables + j];
  }
}

// EOF for pca.C
