// Class: ReadBDT
// Automatically generated by MethodBase::MakeClass
//

/* configuration options =====================================================

#GEN -*-*-*-*-*-*-*-*-*-*-*- general info -*-*-*-*-*-*-*-*-*-*-*-

Method         : BDT::BDT
TMVA Release   : 4.2.1         [262657]
ROOT Release   : 6.37/99       [402787]
Creator        : root
Date           : Sun Nov 16 03:56:47 2025
Host           : Linux 683b1b94d702 4.18.0-553.50.1.el8_10.x86_64 #1 SMP Tue Apr 15 08:09:22 EDT 2025 x86_64 x86_64 x86_64 GNU/Linux
Dir            : /github/home/v6-38-00-patches/notebooks
Training events: 6000
Analysis type  : [Classification]


#OPT -*-*-*-*-*-*-*-*-*-*-*-*- options -*-*-*-*-*-*-*-*-*-*-*-*-

# Set by User:
V: "False" [Verbose output (short form of "VerbosityLevel" below - overrides the latter one)]
H: "False" [Print method-specific help message]
NTrees: "300" [Number of trees in the forest]
MaxDepth: "2" [Max depth of the decision tree allowed]
# Default:
VerbosityLevel: "Default" [Verbosity level]
VarTransform: "None" [List of variable transformations performed before training, e.g., "D_Background,P_Signal,G,N_AllClasses" for: "Decorrelation, PCA-transformation, Gaussianisation, Normalisation, each for the given class of events ('AllClasses' denotes all events of all classes, if no class indication is given, 'All' is assumed)"]
CreateMVAPdfs: "False" [Create PDFs for classifier outputs (signal and background)]
IgnoreNegWeightsInTraining: "False" [Events with negative weights are ignored in the training (but are included for testing and performance evaluation)]
MinNodeSize: "5%" [Minimum percentage of training events required in a leaf node (default: Classification: 5%, Regression: 0.2%)]
nCuts: "20" [Number of grid points in variable range used in finding optimal cut in node splitting]
BoostType: "AdaBoost" [Boosting type for the trees in the forest (note: AdaCost is still experimental)]
AdaBoostR2Loss: "quadratic" [Type of Loss function in AdaBoostR2]
UseBaggedBoost: "False" [Use only a random subsample of all events for growing the trees in each boost iteration.]
Shrinkage: "1.000000e+00" [Learning rate for BoostType=Grad algorithm]
AdaBoostBeta: "5.000000e-01" [Learning rate  for AdaBoost algorithm]
UseRandomisedTrees: "False" [Determine at each node splitting the cut variable only as the best out of a random subset of variables (like in RandomForests)]
UseNvars: "2" [Size of the subset of variables used with RandomisedTree option]
UsePoissonNvars: "True" [Interpret "UseNvars" not as fixed number but as mean of a Poisson distribution in each split with RandomisedTree option]
BaggedSampleFraction: "6.000000e-01" [Relative size of bagged event sample to original size of the data sample (used whenever bagging is used (i.e. UseBaggedBoost, Bagging,)]
UseYesNoLeaf: "True" [Use Sig or Bkg categories, or the purity=S/(S+B) as classification of the leaf node -> Real-AdaBoost]
NegWeightTreatment: "inverseboostnegweights" [How to treat events with negative weights in the BDT training (particular the boosting) : IgnoreInTraining;  Boost With inverse boostweight; Pair events with negative and positive weights in training sample and *annihilate* them (experimental!)]
Css: "1.000000e+00" [AdaCost: cost of true signal selected signal]
Cts_sb: "1.000000e+00" [AdaCost: cost of true signal selected bkg]
Ctb_ss: "1.000000e+00" [AdaCost: cost of true bkg    selected signal]
Cbb: "1.000000e+00" [AdaCost: cost of true bkg    selected bkg ]
NodePurityLimit: "5.000000e-01" [In boosting/pruning, nodes with purity > NodePurityLimit are signal; background otherwise.]
SeparationType: "giniindex" [Separation criterion for node splitting]
RegressionLossFunctionBDTG: "huber" [Loss function for BDTG regression.]
HuberQuantile: "7.000000e-01" [In the Huber loss function this is the quantile that separates the core from the tails in the residuals distribution.]
DoBoostMonitor: "False" [Create control plot with ROC integral vs tree number]
UseFisherCuts: "False" [Use multivariate splits using the Fisher criterion]
MinLinCorrForFisher: "8.000000e-01" [The minimum linear correlation between two variables demanded for use in Fisher criterion in node splitting]
UseExclusiveVars: "False" [Variables already used in fisher criterion are not anymore analysed individually for node splitting]
DoPreselection: "False" [and and apply automatic pre-selection for 100% efficient signal (bkg) cuts prior to training]
SigToBkgFraction: "1.000000e+00" [Sig to Bkg ratio used in Training (similar to NodePurityLimit, which cannot be used in real adaboost]
PruneMethod: "nopruning" [Note: for BDTs use small trees (e.g.MaxDepth=3) and NoPruning:  Pruning: Method used for pruning (removal) of statistically insignificant branches ]
PruneStrength: "0.000000e+00" [Pruning strength]
PruningValFraction: "5.000000e-01" [Fraction of events to use for optimizing automatic pruning.]
SkipNormalization: "False" [Skip normalization at initialization, to keep expectation value of BDT output according to the fraction of events]
nEventsMin: "0" [deprecated: Use MinNodeSize (in % of training events) instead]
UseBaggedGrad: "False" [deprecated: Use *UseBaggedBoost* instead:  Use only a random subsample of all events for growing the trees in each iteration.]
GradBaggingFraction: "6.000000e-01" [deprecated: Use *BaggedSampleFraction* instead: Defines the fraction of events to be used in each iteration, e.g. when UseBaggedGrad=kTRUE. ]
UseNTrainEvents: "0" [deprecated: Use *BaggedSampleFraction* instead: Number of randomly picked training events used in randomised (and bagged) trees]
NNodesMax: "0" [deprecated: Use MaxDepth instead to limit the tree size]
##


#VAR -*-*-*-*-*-*-*-*-*-*-*-* variables *-*-*-*-*-*-*-*-*-*-*-*-

NVar 4
var1                          var1                          var1                          var1                                                            'F'    [-4.8874464035,4.76391029358]
var2                          var2                          var2                          var2                                                            'F'    [-5.24066734314,4.52414560318]
var3                          var3                          var3                          var3                                                            'F'    [-5.3562874794,4.64297914505]
var4                          var4                          var4                          var4                                                            'F'    [-6.31600189209,4.96000480652]
NSpec 0


============================================================================ */

#include <array>
#include <vector>
#include <cmath>
#include <string>
#include <iostream>

#include <algorithm>
#include <limits>

#define NN new BDTNode

#ifndef BDTNode__def
#define BDTNode__def

class BDTNode {

public:

   // constructor of an essentially "empty" node floating in space
   BDTNode ( BDTNode* left,BDTNode* right,
                          int selector, double cutValue, bool cutType, 
                          int nodeType, double purity, double response ) :
   fLeft         ( left         ),
   fRight        ( right        ),
   fSelector     ( selector     ),
   fCutValue     ( cutValue     ),
   fCutType      ( cutType      ),
   fNodeType     ( nodeType     ),
   fPurity       ( purity       ),
   fResponse     ( response     ){
   }

   virtual ~BDTNode();

   // test event if it descends the tree at this node to the right
   virtual bool GoesRight( const std::vector<double>& inputValues ) const;
   BDTNode* GetRight( void )  {return fRight; };

   // test event if it descends the tree at this node to the left 
   virtual bool GoesLeft ( const std::vector<double>& inputValues ) const;
   BDTNode* GetLeft( void ) { return fLeft; };   

   // return  S/(S+B) (purity) at this node (from  training)

   double GetPurity( void ) const { return fPurity; } 
   // return the node type
   int    GetNodeType( void ) const { return fNodeType; }
   double GetResponse(void) const {return fResponse;}

private:

   BDTNode*   fLeft;     // pointer to the left daughter node
   BDTNode*   fRight;    // pointer to the right daughter node
   int                     fSelector; // index of variable used in node selection (decision tree)   
   double                  fCutValue; // cut value applied on this node to discriminate bkg against sig
   bool                    fCutType;  // true: if event variable > cutValue ==> signal , false otherwise
   int                     fNodeType; // Type of node: -1 == Bkg-leaf, 1 == Signal-leaf, 0 = internal 
   double                  fPurity;   // Purity of node from training
   double                  fResponse; // Regression response value of node
}; 

//_______________________________________________________________________
   BDTNode::~BDTNode()
{
   if (fLeft  != NULL) delete fLeft;
   if (fRight != NULL) delete fRight;
}; 

//_______________________________________________________________________
bool BDTNode::GoesRight( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the right
   bool result;
     result = (inputValues[fSelector] >= fCutValue );
   if (fCutType == true) return result; //the cuts are selecting Signal ;
   else return !result;
}

//_______________________________________________________________________
bool BDTNode::GoesLeft( const std::vector<double>& inputValues ) const
{
   // test event if it descends the tree at this node to the left
   if (!this->GoesRight(inputValues)) return true;
   else return false;
}

#endif

#ifndef IClassifierReader__def
#define IClassifierReader__def

class IClassifierReader {

 public:

   // constructor
   IClassifierReader() : fStatusIsClean( true ) {}
   virtual ~IClassifierReader() {}

   // return classifier response
   virtual double GetMvaValue( const std::vector<double>& inputValues ) const = 0;

   // returns classifier status
   bool IsStatusClean() const { return fStatusIsClean; }

 protected:

   bool fStatusIsClean;
};

#endif

class ReadBDT : public IClassifierReader {

 public:

   // constructor
   ReadBDT( std::vector<std::string>& theInputVars )
      : IClassifierReader(),
        fClassName( "ReadBDT" ),
        fNvars( 4 )
   {
      // the training input variables
      const char* inputVars[] = { "var1", "var2", "var3", "var4" };

      // sanity checks
      if (theInputVars.size() <= 0) {
         std::cout << "Problem in class \"" << fClassName << "\": empty input vector" << std::endl;
         fStatusIsClean = false;
      }

      if (theInputVars.size() != fNvars) {
         std::cout << "Problem in class \"" << fClassName << "\": mismatch in number of input values: "
                   << theInputVars.size() << " != " << fNvars << std::endl;
         fStatusIsClean = false;
      }

      // validate input variables
      for (size_t ivar = 0; ivar < theInputVars.size(); ivar++) {
         if (theInputVars[ivar] != inputVars[ivar]) {
            std::cout << "Problem in class \"" << fClassName << "\": mismatch in input variable names" << std::endl
                      << " for variable [" << ivar << "]: " << theInputVars[ivar].c_str() << " != " << inputVars[ivar] << std::endl;
            fStatusIsClean = false;
         }
      }

      // initialize min and max vectors (for normalisation)
      fVmin[0] = 0;
      fVmax[0] = 0;
      fVmin[1] = 0;
      fVmax[1] = 0;
      fVmin[2] = 0;
      fVmax[2] = 0;
      fVmin[3] = 0;
      fVmax[3] = 0;

      // initialize input variable types
      fType[0] = 'F';
      fType[1] = 'F';
      fType[2] = 'F';
      fType[3] = 'F';

      // initialize constants
      Initialize();

   }

   // destructor
   virtual ~ReadBDT() {
      Clear(); // method-specific
   }

   // the classifier response
   // "inputValues" is a vector of input values in the same order as the
   // variables given to the constructor
   double GetMvaValue( const std::vector<double>& inputValues ) const override;

 private:

   // method-specific destructor
   void Clear();

   // common member variables
   const char* fClassName;

   const size_t fNvars;
   size_t GetNvar()           const { return fNvars; }
   char   GetType( int ivar ) const { return fType[ivar]; }

   // normalisation of input variables
   double fVmin[4];
   double fVmax[4];
   double NormVariable( double x, double xmin, double xmax ) const {
      // normalise to output range: [-1, 1]
      return 2*(x - xmin)/(xmax - xmin) - 1.0;
   }

   // type of input variable: 'F' or 'I'
   char   fType[4];

   // initialize internal variables
   void Initialize();
   double GetMvaValue__( const std::vector<double>& inputValues ) const;

   // private members (method specific)
   std::vector<BDTNode*> fForest;       // i.e. root nodes of decision trees
   std::vector<double>                fBoostWeights; // the weights applied in the individual boosts
};

double ReadBDT::GetMvaValue__( const std::vector<double>& inputValues ) const
{
   double myMVA = 0;
   double norm  = 0;
   for (unsigned int itree=0; itree<fForest.size(); itree++){
      BDTNode *current = fForest[itree];
      while (current->GetNodeType() == 0) { //intermediate node
         if (current->GoesRight(inputValues)) current=(BDTNode*)current->GetRight();
         else current=(BDTNode*)current->GetLeft();
      }
      myMVA += fBoostWeights[itree] *  current->GetNodeType();
      norm  += fBoostWeights[itree];
   }
   return myMVA /= norm;
}

void ReadBDT::Initialize()
{
  double inf = std::numeric_limits<double>::infinity();
  double nan = std::numeric_limits<double>::quiet_NaN();
  // itree = 0
  fBoostWeights.push_back(0.630408351651232);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.72268,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.227651,-99) , 
0, 1.58695, 1, 0, 0.62185,-99) , 
NN(
0, 
0, 
-1, -2.17688, 0, -1, 0.0493344,-99) , 
3, -1.48343, 0, 0, 0.5,-99)    );
  // itree = 1
  fBoostWeights.push_back(0.398833);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609083,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.22339,-99) , 
0, 2.0583, 1, 0, 0.559121,-99) , 
NN(
0, 
0, 
-1, -2.22557, 0, -1, 0.132497,-99) , 
3, -0.946475, 0, 0, 0.453346,-99)    );
  // itree = 2
  fBoostWeights.push_back(0.183659);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.221079,-99) , 
1, 1.92566, 1, 0, 0.473046,-99) , 
NN(
0, 
0, 
-1, -3.24792, 0, -1, 0.0391649,-99) , 
3, -2.02038, 0, 0, 0.416697,-99)    );
  // itree = 3
  fBoostWeights.push_back(0.223857);
  fForest.push_back( 
NN(
0, 
0, 
-1, -2.02038, 0, -1, 0.389905,-99)    );
  // itree = 4
  fBoostWeights.push_back(0.149054);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51096,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.222434,-99) , 
2, 2.40709, 1, 0, 0.492746,-99) , 
NN(
0, 
0, 
-1, -3.45246, 0, -1, 0.0577304,-99) , 
3, -2.02038, 0, 0, 0.444268,-99)    );
  // itree = 5
  fBoostWeights.push_back(0.169996);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.362562,-99) , 
3, -0.0223343, 0, 0, 0.460082,-99) , 
NN(
0, 
0, 
-1, -3.45246, 0, -1, 0.0663937,-99) , 
3, -2.02038, 0, 0, 0.418641,-99)    );
  // itree = 6
  fBoostWeights.push_back(0.213952);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363964,-99) , 
0, 0.418263, 1, 0, 0.438371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0266994,-99) , 
3, -2.55733, 0, 0, 0.406746,-99)    );
  // itree = 7
  fBoostWeights.push_back(0.184214);
  fForest.push_back( 
NN(
0, 
0, 
-1, -2.02038, 0, -1, 0.408921,-99)    );
  // itree = 8
  fBoostWeights.push_back(0.150273);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377707,-99) , 
3, -0.35449, 0, 0, 0.489132,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0936598,-99) , 
3, -2.02038, 0, 0, 0.454076,-99)    );
  // itree = 9
  fBoostWeights.push_back(0.125891);
  fForest.push_back( 
NN(
0, 
0, 
-1, -2.55733, 0, -1, 0.437385,-99)    );
  // itree = 10
  fBoostWeights.push_back(0.0961072);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.269132,-99) , 
0, 2.39356, 1, 0, 0.494637,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0510902,-99) , 
3, -2.55733, 0, 0, 0.468569,-99)    );
  // itree = 11
  fBoostWeights.push_back(0.154291);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.639916,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454975,-99) , 
0, -1.16197, 1, 0, 0.473506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.0559556,-99) , 
3, -2.55733, 0, 0, 0.449915,-99)    );
  // itree = 12
  fBoostWeights.push_back(0.134545);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.342033,-99) , 
1, 1.92566, 1, 0, 0.510245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.123825,-99) , 
3, -2.02038, 0, 0, 0.480908,-99)    );
  // itree = 13
  fBoostWeights.push_back(0.141419);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416745,-99) , 
3, 0.309822, 0, 0, 0.483202,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.139176,-99) , 
3, -2.02038, 0, 0, 0.458179,-99)    );
  // itree = 14
  fBoostWeights.push_back(0.174948);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.619675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443868,-99) , 
0, -0.66003, 1, 0, 0.474975,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.156998,-99) , 
3, -2.02038, 0, 0, 0.452805,-99)    );
  // itree = 15
  fBoostWeights.push_back(0.131391);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549681,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455213,-99) , 
1, 0.440807, 1, 0, 0.503201,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.181564,-99) , 
3, -2.02038, 0, 0, 0.481794,-99)    );
  // itree = 16
  fBoostWeights.push_back(0.13302);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.711607,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499956,-99) , 
0, -0.20167, 1, 0, 0.533231,-99) , 
NN(
0, 
0, 
-1, -2.37927, 0, -1, 0.338781,-99) , 
3, -0.409522, 0, 0, 0.483346,-99)    );
  // itree = 17
  fBoostWeights.push_back(0.180163);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.649265,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486813,-99) , 
0, 0.998456, 1, 0, 0.571464,-99) , 
NN(
0, 
0, 
-1, -1.71399, 0, -1, 0.40233,-99) , 
3, 0.127431, 0, 0, 0.508868,-99)    );
  // itree = 18
  fBoostWeights.push_back(0.125532);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.602464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491746,-99) , 
3, 0.974133, 0, 0, 0.541837,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.257078,-99) , 
3, -2.02038, 0, 0, 0.524694,-99)    );
  // itree = 19
  fBoostWeights.push_back(0.111037);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.02163, 1, 1, 0.545107,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.281774,-99) , 
3, -2.02038, 0, 0, 0.529616,-99)    );
  // itree = 20
  fBoostWeights.push_back(0.0555185);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.02163, 1, 1, 0.517464,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.304779,-99) , 
3, -2.02038, 0, 0, 0.505179,-99)    );
  // itree = 21
  fBoostWeights.push_back(0.0727028);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.648171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486728,-99) , 
0, -1.02163, 1, 0, 0.503591,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.316669,-99) , 
3, -2.02038, 0, 0, 0.492895,-99)    );
  // itree = 22
  fBoostWeights.push_back(0.0858048);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.667086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498107,-99) , 
0, -0.309114, 1, 0, 0.528577,-99) , 
NN(
0, 
0, 
-1, -1.19616, 1, -1, 0.401033,-99) , 
3, -0.946475, 0, 0, 0.507505,-99)    );
  // itree = 23
  fBoostWeights.push_back(0.113161);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.110104, 1, 1, 0.55088,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508778,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.353306,-99) , 
0, -1.06785, 1, 0, 0.436431,-99) , 
3, -0.409522, 0, 0, 0.522572,-99)    );
  // itree = 24
  fBoostWeights.push_back(0.100863);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474749,-99) , 
1, 0.0695945, 1, 0, 0.511258,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.328214,-99) , 
3, -2.02038, 0, 0, 0.500822,-99)    );
  // itree = 25
  fBoostWeights.push_back(0.130806);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658418,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482565,-99) , 
2, 1.1255, 1, 0, 0.55903,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.333046,-99) , 
0, 0.017922, 1, 0, 0.457379,-99) , 
3, 0.664383, 0, 0, 0.508327,-99)    );
  // itree = 26
  fBoostWeights.push_back(0.109779);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.532708, 1, 1, 0.538687,-99) , 
NN(
0, 
0, 
-1, -1.25449, 0, -1, 0.397383,-99) , 
3, -0.409522, 0, 0, 0.50336,-99)    );
  // itree = 27
  fBoostWeights.push_back(0.125939);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.612051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448365,-99) , 
2, 1.79156, 1, 0, 0.552173,-99) , 
NN(
0, 
0, 
-1, 0.447973, 1, -1, 0.453229,-99) , 
3, 1.20134, 0, 0, 0.489589,-99)    );
  // itree = 28
  fBoostWeights.push_back(0.0588509);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.658842,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499719,-99) , 
1, -0.52572, 1, 0, 0.521224,-99) , 
NN(
0, 
0, 
-1, -1.19616, 1, -1, 0.431935,-99) , 
3, -0.946475, 0, 0, 0.506427,-99)    );
  // itree = 29
  fBoostWeights.push_back(0.123507);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.659599,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49535,-99) , 
0, 0.903249, 1, 0, 0.553099,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539453,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.401856,-99) , 
0, -0.309103, 1, 0, 0.48246,-99) , 
3, 0.664383, 0, 0, 0.51785,-99)    );
  // itree = 30
  fBoostWeights.push_back(0.103686);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.307507, 1, 1, 0.555391,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50297,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.388149,-99) , 
3, -1.10038, 0, 0, 0.458454,-99) , 
3, 0.127431, 0, 0, 0.519946,-99)    );
  // itree = 31
  fBoostWeights.push_back(0.100695);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.47376, 1, 1, 0.573255,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516486,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.41132,-99) , 
1, 0.355892, 1, 0, 0.47824,-99) , 
3, 1.73829, 0, 0, 0.501398,-99)    );
  // itree = 32
  fBoostWeights.push_back(0.0830634);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.677161,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498091,-99) , 
0, 0.0570923, 1, 0, 0.523256,-99) , 
NN(
0, 
0, 
-1, -0.362446, 1, -1, 0.432982,-99) , 
3, 0.127431, 0, 0, 0.490031,-99)    );
  // itree = 33
  fBoostWeights.push_back(0.0827785);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.307507, 1, 1, 0.538261,-99) , 
NN(
0, 
0, 
-1, -0.362446, 1, -1, 0.453477,-99) , 
3, 0.127431, 0, 0, 0.507123,-99)    );
  // itree = 34
  fBoostWeights.push_back(0.0692336);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615546,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487189,-99) , 
3, 1.9408, 0, 0, 0.508405,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.379043,-99) , 
0, 2.46597, 1, 0, 0.501638,-99)    );
  // itree = 35
  fBoostWeights.push_back(0.0695242);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.24327, 0, 1, 0.530896,-99) , 
NN(
0, 
0, 
-1, 2.10976, 0, -1, 0.451706,-99) , 
1, 1.26921, 1, 0, 0.513551,-99)    );
  // itree = 36
  fBoostWeights.push_back(0.0796486);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.01891, 1, 1, 0.541033,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513706,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.375131,-99) , 
0, 0.447973, 1, 0, 0.482187,-99) , 
3, 1.20134, 0, 0, 0.503797,-99)    );
  // itree = 37
  fBoostWeights.push_back(0.093959);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.606866,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471344,-99) , 
0, 0.903249, 1, 0, 0.517763,-99) , 
NN(
0, 
0, 
-1, 0.354839, 1, -1, 0.461681,-99) , 
3, 0.664383, 0, 0, 0.489591,-99)    );
  // itree = 38
  fBoostWeights.push_back(0.135426);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.603441,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.430302,-99) , 
3, -1.30185, 0, 0, 0.547097,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536698,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429817,-99) , 
3, 1.35211, 0, 0, 0.482389,-99) , 
1, -0.125765, 1, 0, 0.505084,-99)    );
  // itree = 39
  fBoostWeights.push_back(0.10396);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477408,-99) , 
3, -0.153293, 0, 0, 0.527971,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510998,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.40686,-99) , 
3, 2.14511, 0, 0, 0.452099,-99) , 
1, 0.804217, 1, 0, 0.501313,-99)    );
  // itree = 40
  fBoostWeights.push_back(0.0841265);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.572121, 0, 1, 0.537401,-99) , 
NN(
0, 
0, 
-1, 1.29838, 0, -1, 0.451828,-99) , 
0, 0.627615, 1, 0, 0.501146,-99)    );
  // itree = 41
  fBoostWeights.push_back(0.0595081);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.672147,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.450678,-99) , 
2, -1.77783, 0, 0, 0.585531,-99) , 
NN(
0, 
0, 
-1, -0.669664, 0, -1, 0.484621,-99) , 
0, -1.21074, 1, 0, 0.49793,-99)    );
  // itree = 42
  fBoostWeights.push_back(0.0478118);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.34362, 0, 1, 0.518285,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.390667,-99) , 
1, 2.19919, 1, 0, 0.510432,-99)    );
  // itree = 43
  fBoostWeights.push_back(0.0515098);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.582395,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491898,-99) , 
3, 1.9408, 0, 0, 0.506792,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.377732,-99) , 
0, 2.46597, 1, 0, 0.499952,-99)    );
  // itree = 44
  fBoostWeights.push_back(0.0532869);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.566038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497715,-99) , 
0, -0.466244, 1, 0, 0.517472,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397357,-99) , 
2, 2.2622, 1, 0, 0.508825,-99)    );
  // itree = 45
  fBoostWeights.push_back(0.0729481);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491421,-99) , 
3, 0.640926, 0, 0, 0.523114,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.410184,-99) , 
2, 2.2622, 1, 0, 0.515017,-99)    );
  // itree = 46
  fBoostWeights.push_back(0.0917734);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.177214, 0, 1, 0.553369,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514628,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392254,-99) , 
3, 1.05906, 0, 0, 0.48328,-99) , 
2, 0.357579, 1, 0, 0.517539,-99)    );
  // itree = 47
  fBoostWeights.push_back(0.0778404);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492696,-99) , 
3, 0.492622, 0, 0, 0.526266,-99) , 
NN(
0, 
0, 
-1, 1.67671, 0, -1, 0.457517,-99) , 
2, 0.833735, 1, 0, 0.500619,-99)    );
  // itree = 48
  fBoostWeights.push_back(0.0795519);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.534355,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.409846,-99) , 
3, 2.22116, 0, 0, 0.462434,-99) , 
0, 1.0872, 1, 0, 0.513099,-99)    );
  // itree = 49
  fBoostWeights.push_back(0.0580362);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497061,-99) , 
3, 1.24327, 0, 0, 0.515689,-99) , 
NN(
0, 
0, 
-1, 1.12248, 1, -1, 0.440354,-99) , 
1, 1.26921, 1, 0, 0.499082,-99)    );
  // itree = 50
  fBoostWeights.push_back(0.0986511);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.614547,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423438,-99) , 
3, -1.96005, 0, 0, 0.567719,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471042,-99) , 
0, 0.0232047, 1, 0, 0.490776,-99) , 
1, -0.590756, 1, 0, 0.508791,-99)    );
  // itree = 51
  fBoostWeights.push_back(0.0833067);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.641835,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476029,-99) , 
2, -1.77783, 0, 0, 0.576786,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521088,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.363777,-99) , 
3, -0.669664, 0, 0, 0.504359,-99) , 
0, -1.21074, 1, 0, 0.513926,-99)    );
  // itree = 52
  fBoostWeights.push_back(0.0683001);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494032,-99) , 
3, -1.16806, 0, 0, 0.555132,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505496,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.414032,-99) , 
3, 0.274711, 0, 0, 0.482228,-99) , 
1, -0.590756, 1, 0, 0.499108,-99)    );
  // itree = 53
  fBoostWeights.push_back(0.0839447);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.14897, 0, 1, 0.565792,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512251,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449806,-99) , 
1, 0.305969, 1, 0, 0.47369,-99) , 
0, -0.751151, 1, 0, 0.492633,-99)    );
  // itree = 54
  fBoostWeights.push_back(0.0517831);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.621371,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496872,-99) , 
3, -1.99385, 0, 0, 0.567351,-99) , 
NN(
0, 
0, 
-1, -0.669664, 0, -1, 0.480826,-99) , 
0, -1.21074, 1, 0, 0.492207,-99)    );
  // itree = 55
  fBoostWeights.push_back(0.050316);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.19742, 0, 1, 0.565879,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507122,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.380185,-99) , 
3, -0.669664, 0, 0, 0.493762,-99) , 
0, -1.21074, 1, 0, 0.503227,-99)    );
  // itree = 56
  fBoostWeights.push_back(0.0560955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.585264,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489862,-99) , 
3, -1.16806, 0, 0, 0.537551,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.416032,-99) , 
3, 0.274711, 0, 0, 0.479596,-99) , 
1, -0.590756, 1, 0, 0.492941,-99)    );
  // itree = 57
  fBoostWeights.push_back(0.0689773);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.630428,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496134,-99) , 
3, -1.14897, 0, 0, 0.551607,-99) , 
NN(
0, 
0, 
-1, 0.113618, 0, -1, 0.471146,-99) , 
0, -0.751151, 1, 0, 0.487598,-99)    );
  // itree = 58
  fBoostWeights.push_back(0.0584735);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.19742, 0, 1, 0.575227,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443638,-99) , 
3, 0.134574, 0, 0, 0.490844,-99) , 
0, -1.21074, 1, 0, 0.501928,-99)    );
  // itree = 59
  fBoostWeights.push_back(0.0699152);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.609101,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499375,-99) , 
3, 0.177214, 0, 0, 0.527908,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502808,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394013,-99) , 
3, 1.3377, 0, 0, 0.462977,-99) , 
2, 0.357579, 1, 0, 0.494377,-99)    );
  // itree = 60
  fBoostWeights.push_back(0.0798348);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.590727, 0, 1, 0.557131,-99) , 
NN(
0, 
0, 
-1, 0.28042, 0, -1, 0.468072,-99) , 
0, -0.291562, 1, 0, 0.496006,-99)    );
  // itree = 61
  fBoostWeights.push_back(0.0551207);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471326,-99) , 
3, -1.96005, 0, 0, 0.560033,-99) , 
NN(
0, 
0, 
-1, -0.506171, 0, -1, 0.486481,-99) , 
1, -0.590756, 1, 0, 0.503451,-99)    );
  // itree = 62
  fBoostWeights.push_back(0.0726362);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.530317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433402,-99) , 
3, 2.47014, 0, 0, 0.470703,-99) , 
0, 1.0872, 1, 0, 0.512466,-99)    );
  // itree = 63
  fBoostWeights.push_back(0.0437644);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.571885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494469,-99) , 
3, 1.9408, 0, 0, 0.507378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.38656,-99) , 
0, 2.46597, 1, 0, 0.5008,-99)    );
  // itree = 64
  fBoostWeights.push_back(0.0432197);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.34362, 0, 1, 0.515949,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.394129,-99) , 
1, 2.19919, 1, 0, 0.508298,-99)    );
  // itree = 65
  fBoostWeights.push_back(0.0551579);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574074,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495891,-99) , 
3, 1.24327, 0, 0, 0.512722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512969,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426184,-99) , 
1, 1.57961, 1, 0, 0.450556,-99) , 
1, 1.26921, 1, 0, 0.498851,-99)    );
  // itree = 66
  fBoostWeights.push_back(0.071794);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.557256,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493415,-99) , 
3, -0.153293, 0, 0, 0.527722,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507346,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435048,-99) , 
3, 2.14511, 0, 0, 0.466927,-99) , 
1, 0.804217, 1, 0, 0.506307,-99)    );
  // itree = 67
  fBoostWeights.push_back(0.0705169);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.572121, 0, 1, 0.536022,-99) , 
NN(
0, 
0, 
-1, 1.29838, 0, -1, 0.46591,-99) , 
0, 0.627615, 1, 0, 0.506201,-99)    );
  // itree = 68
  fBoostWeights.push_back(0.0302786);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.45686, 0, 1, 0.509892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393227,-99) , 
0, 2.46597, 1, 0, 0.503578,-99)    );
  // itree = 69
  fBoostWeights.push_back(0.0519412);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.642172,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458362,-99) , 
3, -1.69951, 0, 0, 0.554388,-99) , 
NN(
0, 
0, 
-1, -0.559873, 0, -1, 0.486404,-99) , 
2, -1.07089, 1, 0, 0.496827,-99)    );
  // itree = 70
  fBoostWeights.push_back(0.0443785);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.591954,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.374367,-99) , 
3, -1.26873, 0, 0, 0.500926,-99) , 
0, -1.67033, 1, 0, 0.50774,-99)    );
  // itree = 71
  fBoostWeights.push_back(0.0284044);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.581192,-99) , 
NN(
0, 
0, 
-1, -1.26873, 0, -1, 0.491204,-99) , 
0, -1.67033, 1, 0, 0.49792,-99)    );
  // itree = 72
  fBoostWeights.push_back(0.0433716);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.565292,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495781,-99) , 
3, 1.63477, 0, 0, 0.510506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421255,-99) , 
2, 2.2622, 1, 0, 0.503962,-99)    );
  // itree = 73
  fBoostWeights.push_back(0.0680082);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.918161, 0, 1, 0.531279,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413232,-99) , 
3, 1.67671, 0, 0, 0.476057,-99) , 
2, 0.833735, 1, 0, 0.510557,-99)    );
  // itree = 74
  fBoostWeights.push_back(0.0546744);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517999,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463153,-99) , 
2, 1.15446, 1, 0, 0.504155,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.393414,-99) , 
0, 2.46597, 1, 0, 0.49814,-99)    );
  // itree = 75
  fBoostWeights.push_back(0.0644516);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524304,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466267,-99) , 
3, 0.392653, 0, 0, 0.497385,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.406535,-99) , 
0, 2.46597, 1, 0, 0.492471,-99)    );
  // itree = 76
  fBoostWeights.push_back(0.0584349);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561911,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47229,-99) , 
3, -1.96005, 0, 0, 0.53939,-99) , 
NN(
0, 
0, 
-1, -0.506171, 0, -1, 0.478062,-99) , 
1, -0.590756, 1, 0, 0.492224,-99)    );
  // itree = 77
  fBoostWeights.push_back(0.0303264);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579862,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502885,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.383308,-99) , 
3, -1.26873, 0, 0, 0.495478,-99) , 
0, -1.67033, 1, 0, 0.501781,-99)    );
  // itree = 78
  fBoostWeights.push_back(0.0635473);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.607512,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495357,-99) , 
3, -1.14897, 0, 0, 0.541332,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509614,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447516,-99) , 
3, 0.859216, 0, 0, 0.483187,-99) , 
0, -0.751151, 1, 0, 0.495067,-99)    );
  // itree = 79
  fBoostWeights.push_back(0.0614005);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.58304, 0, 1, 0.525197,-99) , 
NN(
0, 
0, 
-1, 1.3377, 0, -1, 0.464201,-99) , 
2, 0.357579, 1, 0, 0.493758,-99)    );
  // itree = 80
  fBoostWeights.push_back(0.0326235);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57053,-99) , 
NN(
0, 
0, 
-1, -0.823823, 0, -1, 0.488067,-99) , 
0, -1.67033, 1, 0, 0.494221,-99)    );
  // itree = 81
  fBoostWeights.push_back(0.0502016);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.675271,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499306,-99) , 
3, 1.49054, 0, 0, 0.514498,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435563,-99) , 
3, 2.47014, 0, 0, 0.469929,-99) , 
0, 1.0872, 1, 0, 0.501159,-99)    );
  // itree = 82
  fBoostWeights.push_back(0.0623057);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49603,-99) , 
3, 0.235364, 0, 0, 0.522097,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517164,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433513,-99) , 
0, 1.12248, 1, 0, 0.464082,-99) , 
1, 1.26921, 1, 0, 0.509175,-99)    );
  // itree = 83
  fBoostWeights.push_back(0.0755638);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.308464, 0, 1, 0.544737,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513245,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439099,-99) , 
3, 1.28854, 0, 0, 0.483666,-99) , 
0, 0.168026, 1, 0, 0.510353,-99)    );
  // itree = 84
  fBoostWeights.push_back(0.0549993);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0483097, 0, 1, 0.537864,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501212,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445092,-99) , 
0, 1.20838, 1, 0, 0.479598,-99) , 
1, -0.125765, 1, 0, 0.499953,-99)    );
  // itree = 85
  fBoostWeights.push_back(0.063996);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4952,-99) , 
3, -0.0483097, 0, 0, 0.524167,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461021,-99) , 
3, 2.07369, 0, 0, 0.476412,-99) , 
1, -0.125765, 1, 0, 0.493085,-99)    );
  // itree = 86
  fBoostWeights.push_back(0.047393);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.53994, 1, 1, 0.515892,-99) , 
NN(
0, 
0, 
-1, 2.0223, 0, -1, 0.452293,-99) , 
2, 1.30989, 1, 0, 0.500326,-99)    );
  // itree = 87
  fBoostWeights.push_back(0.044597);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.534165,-99) , 
NN(
0, 
0, 
-1, 0.214585, 0, -1, 0.481516,-99) , 
2, -0.594732, 1, 0, 0.494272,-99)    );
  // itree = 88
  fBoostWeights.push_back(0.0320845);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5857,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49622,-99) , 
3, 2.34362, 0, 0, 0.505157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.42248,-99) , 
1, 2.19919, 1, 0, 0.500018,-99)    );
  // itree = 89
  fBoostWeights.push_back(0.0513966);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524194,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481086,-99) , 
3, -0.352921, 0, 0, 0.512071,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.437072,-99) , 
2, 2.2622, 1, 0, 0.506539,-99)    );
  // itree = 90
  fBoostWeights.push_back(0.0647785);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.629983,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443467,-99) , 
3, -1.91074, 0, 0, 0.560352,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.592717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484813,-99) , 
0, -1.18465, 1, 0, 0.492899,-99) , 
1, -1.05575, 1, 0, 0.502283,-99)    );
  // itree = 91
  fBoostWeights.push_back(0.077);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.618049,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438108,-99) , 
1, -1.55155, 0, 0, 0.555943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51854,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.392623,-99) , 
3, -0.559873, 0, 0, 0.505886,-99) , 
2, -1.07089, 1, 0, 0.513589,-99)    );
  // itree = 92
  fBoostWeights.push_back(0.0594392);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.615157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465169,-99) , 
3, -1.91074, 0, 0, 0.559578,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.573193,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483425,-99) , 
0, -1.18465, 1, 0, 0.490072,-99) , 
1, -1.05575, 1, 0, 0.499663,-99)    );
  // itree = 93
  fBoostWeights.push_back(0.0588811);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.590727, 0, 1, 0.538052,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513869,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.421936,-99) , 
3, 0.28042, 0, 0, 0.497273,-99) , 
0, -0.291562, 1, 0, 0.510059,-99)    );
  // itree = 94
  fBoostWeights.push_back(0.0472094);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.512581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.525506,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439484,-99) , 
3, 2.71913, 0, 0, 0.467429,-99) , 
0, 1.0872, 1, 0, 0.498989,-99)    );
  // itree = 95
  fBoostWeights.push_back(0.0514311);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524539,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481622,-99) , 
3, 0.739315, 0, 0, 0.499347,-99) , 
NN(
0, 
0, 
-1, 2.26616, 1, -1, 0.441901,-99) , 
1, 1.7342, 1, 0, 0.491976,-99)    );
  // itree = 96
  fBoostWeights.push_back(0.0644731);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480156,-99) , 
3, -0.634438, 0, 0, 0.519851,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500185,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.425668,-99) , 
3, 1.3377, 0, 0, 0.472864,-99) , 
2, 0.357579, 1, 0, 0.495569,-99)    );
  // itree = 97
  fBoostWeights.push_back(0.0540405);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.4735, 1, 1, 0.516942,-99) , 
NN(
0, 
0, 
-1, 1.58005, 0, -1, 0.459534,-99) , 
0, 0.627615, 1, 0, 0.492412,-99)    );
  // itree = 98
  fBoostWeights.push_back(0.051737);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594521,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469012,-99) , 
3, -1.91074, 0, 0, 0.547571,-99) , 
NN(
0, 
0, 
-1, -0.568123, 0, -1, 0.481319,-99) , 
1, -1.05575, 1, 0, 0.490434,-99)    );
  // itree = 99
  fBoostWeights.push_back(0.0264184);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575045,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501858,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.395624,-99) , 
3, -1.26873, 0, 0, 0.495226,-99) , 
0, -1.67033, 1, 0, 0.501139,-99)    );
  // itree = 100
  fBoostWeights.push_back(0.0414239);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.6033, 1, 1, 0.510652,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435336,-99) , 
3, 2.14511, 0, 0, 0.467195,-99) , 
1, 0.804217, 1, 0, 0.495297,-99)    );
  // itree = 101
  fBoostWeights.push_back(0.0393076);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558544,-99) , 
NN(
0, 
0, 
-1, -1.26873, 0, -1, 0.483457,-99) , 
0, -1.67033, 1, 0, 0.489001,-99)    );
  // itree = 102
  fBoostWeights.push_back(0.029739);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575739,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494718,-99) , 
3, 2.45686, 0, 0, 0.501644,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423781,-99) , 
0, 2.46597, 1, 0, 0.497374,-99)    );
  // itree = 103
  fBoostWeights.push_back(0.0425787);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53651,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493461,-99) , 
3, 0.908704, 0, 0, 0.509918,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45178,-99) , 
0, 2.00638, 1, 0, 0.503608,-99)    );
  // itree = 104
  fBoostWeights.push_back(0.0428269);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.308464, 0, 1, 0.530468,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502041,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.435908,-99) , 
3, 0.676629, 0, 0, 0.488875,-99) , 
0, 0.168026, 1, 0, 0.507003,-99)    );
  // itree = 105
  fBoostWeights.push_back(0.0560323);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548692,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490638,-99) , 
3, 0.0670827, 0, 0, 0.515557,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501571,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.434285,-99) , 
3, 1.92927, 0, 0, 0.470838,-99) , 
2, 0.833735, 1, 0, 0.498702,-99)    );
  // itree = 106
  fBoostWeights.push_back(0.0523971);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.0483097, 0, 1, 0.53691,-99) , 
NN(
0, 
0, 
-1, 1.20838, 1, -1, 0.479543,-99) , 
1, -0.125765, 1, 0, 0.499479,-99)    );
  // itree = 107
  fBoostWeights.push_back(0.0515515);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.518192,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526675,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451549,-99) , 
3, 2.96812, 0, 0, 0.46935,-99) , 
0, 1.0872, 1, 0, 0.503478,-99)    );
  // itree = 108
  fBoostWeights.push_back(0.0298288);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560892,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495113,-99) , 
3, 2.34362, 0, 0, 0.501695,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.418953,-99) , 
1, 2.19919, 1, 0, 0.496512,-99)    );
  // itree = 109
  fBoostWeights.push_back(0.0337983);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.53994, 1, 1, 0.511349,-99) , 
NN(
0, 
0, 
-1, 2.77932, 0, -1, 0.449756,-99) , 
2, 1.78605, 1, 0, 0.502571,-99)    );
  // itree = 110
  fBoostWeights.push_back(0.039585);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494546,-99) , 
3, 1.24327, 0, 0, 0.506211,-99) , 
NN(
0, 
0, 
-1, 1.85064, 0, -1, 0.462792,-99) , 
1, 1.26921, 1, 0, 0.496529,-99)    );
  // itree = 111
  fBoostWeights.push_back(0.0484905);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.575559,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483401,-99) , 
3, -0.972412, 0, 0, 0.529413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503195,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436039,-99) , 
3, 0.28042, 0, 0, 0.49104,-99) , 
0, -0.291562, 1, 0, 0.50313,-99)    );
  // itree = 112
  fBoostWeights.push_back(0.0634329);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.541648,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462794,-99) , 
0, 0.494743, 1, 0, 0.483863,-99) , 
2, -0.594732, 1, 0, 0.497837,-99)    );
  // itree = 113
  fBoostWeights.push_back(0.0407607);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604434,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463432,-99) , 
3, -1.69951, 0, 0, 0.53685,-99) , 
NN(
0, 
0, 
-1, -0.559873, 0, -1, 0.489022,-99) , 
2, -1.07089, 1, 0, 0.496394,-99)    );
  // itree = 114
  fBoostWeights.push_back(0.0320911);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559603,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506982,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.404127,-99) , 
3, -1.26873, 0, 0, 0.500555,-99) , 
0, -1.67033, 1, 0, 0.504952,-99)    );
  // itree = 115
  fBoostWeights.push_back(0.0331345);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.57693,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47001,-99) , 
3, -1.91074, 0, 0, 0.536494,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500829,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429582,-99) , 
3, -0.568123, 0, 0, 0.491687,-99) , 
1, -1.05575, 1, 0, 0.497856,-99)    );
  // itree = 116
  fBoostWeights.push_back(0.0482136);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.588616,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482832,-99) , 
0, -1.53918, 1, 0, 0.530757,-99) , 
NN(
0, 
0, 
-1, 0.486417, 0, -1, 0.48242,-99) , 
0, -0.751151, 1, 0, 0.492264,-99)    );
  // itree = 117
  fBoostWeights.push_back(0.0466705);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.529545,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454373,-99) , 
3, 0.553544, 0, 0, 0.493395,-99) , 
2, -0.594732, 1, 0, 0.502094,-99)    );
  // itree = 118
  fBoostWeights.push_back(0.0527955);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522124,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46191,-99) , 
3, -1.1014, 0, 0, 0.508683,-99) , 
NN(
0, 
0, 
-1, 1.51957, 0, -1, 0.472372,-99) , 
1, 0.804217, 1, 0, 0.495851,-99)    );
  // itree = 119
  fBoostWeights.push_back(0.0565715);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.779898, 0, 1, 0.531668,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520409,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46896,-99) , 
3, 1.60481, 0, 0, 0.486642,-99) , 
0, -0.751151, 1, 0, 0.495785,-99)    );
  // itree = 120
  fBoostWeights.push_back(0.0270775);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.561537,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495005,-99) , 
3, 2.45686, 0, 0, 0.500708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.423297,-99) , 
0, 2.46597, 1, 0, 0.496431,-99)    );
  // itree = 121
  fBoostWeights.push_back(0.0416028);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.552279,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497603,-99) , 
3, 0.90766, 0, 0, 0.512802,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502903,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.397419,-99) , 
3, 2.0223, 0, 0, 0.469284,-99) , 
2, 1.30989, 1, 0, 0.502104,-99)    );
  // itree = 122
  fBoostWeights.push_back(0.049476);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532568,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492225,-99) , 
1, 0.248028, 1, 0, 0.512655,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.439509,-99) , 
0, 2.00638, 1, 0, 0.504664,-99)    );
  // itree = 123
  fBoostWeights.push_back(0.0541305);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528504,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483046,-99) , 
3, -0.123397, 0, 0, 0.512509,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451731,-99) , 
0, 2.00638, 1, 0, 0.505881,-99)    );
  // itree = 124
  fBoostWeights.push_back(0.0434336);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.58304, 0, 1, 0.523741,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503946,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452742,-99) , 
3, 1.3377, 0, 0, 0.485199,-99) , 
2, 0.357579, 1, 0, 0.503791,-99)    );
  // itree = 125
  fBoostWeights.push_back(0.0413385);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.51037,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522551,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.448813,-99) , 
3, 2.96812, 0, 0, 0.466301,-99) , 
0, 1.0872, 1, 0, 0.497046,-99)    );
  // itree = 126
  fBoostWeights.push_back(0.0363414);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551231,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490073,-99) , 
3, 2.34362, 0, 0, 0.496209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420759,-99) , 
1, 2.19919, 1, 0, 0.491472,-99)    );
  // itree = 127
  fBoostWeights.push_back(0.0291327);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.572426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499156,-99) , 
0, -1.53994, 1, 0, 0.507072,-99) , 
NN(
0, 
0, 
-1, 2.77932, 0, -1, 0.449603,-99) , 
2, 1.78605, 1, 0, 0.498847,-99)    );
  // itree = 128
  fBoostWeights.push_back(0.0469424);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519871,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479039,-99) , 
2, 1.17191, 1, 0, 0.510402,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.43546,-99) , 
2, 2.2622, 1, 0, 0.504784,-99)    );
  // itree = 129
  fBoostWeights.push_back(0.0445948);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.657832,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498715,-99) , 
0, -0.532708, 1, 0, 0.50981,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52636,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.428571,-99) , 
0, -1.34068, 1, 0, 0.47025,-99) , 
3, -0.409522, 0, 0, 0.499844,-99)    );
  // itree = 130
  fBoostWeights.push_back(0.0491739);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.298885, 1, 1, 0.519413,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510478,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.422687,-99) , 
2, -1.09695, 1, 0, 0.471829,-99) , 
3, -0.409522, 0, 0, 0.507441,-99)    );
  // itree = 131
  fBoostWeights.push_back(0.0374229);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.604723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495105,-99) , 
0, -0.647315, 1, 0, 0.50524,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502736,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.413775,-99) , 
0, -1.45982, 1, 0, 0.461951,-99) , 
3, -0.946475, 0, 0, 0.49787,-99)    );
  // itree = 132
  fBoostWeights.push_back(0.0386318);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.298885, 1, 1, 0.515607,-99) , 
NN(
0, 
0, 
-1, -1.09695, 1, -1, 0.469664,-99) , 
3, -0.409522, 0, 0, 0.504067,-99)    );
  // itree = 133
  fBoostWeights.push_back(0.0325395);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539745,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493944,-99) , 
3, 1.63477, 0, 0, 0.503615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445603,-99) , 
2, 2.2622, 1, 0, 0.499261,-99)    );
  // itree = 134
  fBoostWeights.push_back(0.0447028);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.455654,-99) , 
3, -1.22211, 0, 0, 0.508092,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.446202,-99) , 
1, 2.19919, 1, 0, 0.50422,-99)    );
  // itree = 135
  fBoostWeights.push_back(0.0560449);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.593665,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.445877,-99) , 
3, -1.91074, 0, 0, 0.537575,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515713,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47796,-99) , 
0, 0.0900432, 1, 0, 0.490861,-99) , 
1, -1.05575, 1, 0, 0.49731,-99)    );
  // itree = 136
  fBoostWeights.push_back(0.0282544);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546289,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.420587,-99) , 
2, 1.65617, 1, 0, 0.496158,-99) , 
3, 2.81219, 0, 0, 0.500667,-99)    );
  // itree = 137
  fBoostWeights.push_back(0.0267992);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539277,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449861,-99) , 
0, 1.20934, 1, 0, 0.490407,-99) , 
3, 2.81219, 0, 0, 0.494799,-99)    );
  // itree = 138
  fBoostWeights.push_back(0.0575423);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546652,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478415,-99) , 
2, 1.1255, 1, 0, 0.506665,-99) , 
NN(
0, 
0, 
-1, -0.317059, 1, -1, 0.474486,-99) , 
3, 0.664383, 0, 0, 0.490581,-99)    );
  // itree = 139
  fBoostWeights.push_back(0.0277447);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546524,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459821,-99) , 
0, 1.20934, 1, 0, 0.494298,-99) , 
3, 2.81219, 0, 0, 0.499005,-99)    );
  // itree = 140
  fBoostWeights.push_back(0.038719);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.608426,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494232,-99) , 
0, 1.39762, 1, 0, 0.524021,-99) , 
NN(
0, 
0, 
-1, 1.1554, 1, -1, 0.484984,-99) , 
3, 1.73829, 0, 0, 0.494633,-99)    );
  // itree = 141
  fBoostWeights.push_back(0.0355537);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.584702,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449197,-99) , 
0, 2.42304, 1, 0, 0.537989,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502362,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.426455,-99) , 
1, 1.55515, 1, 0, 0.496689,-99) , 
3, 2.27524, 0, 0, 0.503066,-99)    );
  // itree = 142
  fBoostWeights.push_back(0.0488171);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39762, 1, 1, 0.525745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522624,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475654,-99) , 
1, -0.843371, 1, 0, 0.486584,-99) , 
3, 1.73829, 0, 0, 0.496245,-99)    );
  // itree = 143
  fBoostWeights.push_back(0.0460152);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494251,-99) , 
2, -0.298885, 1, 0, 0.50674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440174,-99) , 
0, -1.34068, 1, 0, 0.472607,-99) , 
3, -0.409522, 0, 0, 0.498147,-99)    );
  // itree = 144
  fBoostWeights.push_back(0.0382566);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.532708, 1, 1, 0.515582,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503444,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436846,-99) , 
2, -1.09695, 1, 0, 0.474222,-99) , 
3, -0.409522, 0, 0, 0.505177,-99)    );
  // itree = 145
  fBoostWeights.push_back(0.0322055);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.590917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496246,-99) , 
0, -0.647315, 1, 0, 0.504919,-99) , 
NN(
0, 
0, 
-1, -1.45982, 1, -1, 0.462678,-99) , 
3, -0.946475, 0, 0, 0.497724,-99)    );
  // itree = 146
  fBoostWeights.push_back(0.0336834);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.37088, 1, 1, 0.516313,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443254,-99) , 
0, -0.362446, 1, 0, 0.484502,-99) , 
3, 0.127431, 0, 0, 0.504553,-99)    );
  // itree = 147
  fBoostWeights.push_back(0.0267642);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.574899,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498062,-99) , 
0, -0.647315, 1, 0, 0.505069,-99) , 
NN(
0, 
0, 
-1, -1.45982, 1, -1, 0.463311,-99) , 
3, -0.946475, 0, 0, 0.497954,-99)    );
  // itree = 148
  fBoostWeights.push_back(0.0304663);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.298885, 1, 1, 0.512594,-99) , 
NN(
0, 
0, 
-1, -0.812998, 1, -1, 0.476918,-99) , 
3, -0.409522, 0, 0, 0.503634,-99)    );
  // itree = 149
  fBoostWeights.push_back(0.0211704);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502293,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.436273,-99) , 
2, 1.65617, 1, 0, 0.496179,-99) , 
3, 2.81219, 0, 0, 0.499844,-99)    );
  // itree = 150
  fBoostWeights.push_back(0.0204944);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531565,-99) , 
NN(
0, 
0, 
-1, 1.65617, 1, -1, 0.491865,-99) , 
3, 2.81219, 0, 0, 0.495442,-99)    );
  // itree = 151
  fBoostWeights.push_back(0.0395462);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530694,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488876,-99) , 
3, 1.13785, 0, 0, 0.503162,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456045,-99) , 
2, 2.2622, 1, 0, 0.499642,-99)    );
  // itree = 152
  fBoostWeights.push_back(0.0326986);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545558,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466156,-99) , 
2, -1.96246, 0, 0, 0.528123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.429489,-99) , 
3, -0.506171, 0, 0, 0.495891,-99) , 
1, -0.590756, 1, 0, 0.50328,-99)    );
  // itree = 153
  fBoostWeights.push_back(0.0363433);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576823,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488691,-99) , 
3, -1.04414, 0, 0, 0.524928,-99) , 
NN(
0, 
0, 
-1, 0.214585, 0, -1, 0.488205,-99) , 
2, -0.594732, 1, 0, 0.497047,-99)    );
  // itree = 154
  fBoostWeights.push_back(0.046277);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.58758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.458993,-99) , 
3, -1.91074, 0, 0, 0.538613,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519051,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486447,-99) , 
1, 0.273634, 1, 0, 0.49885,-99) , 
1, -1.05575, 1, 0, 0.504336,-99)    );
  // itree = 155
  fBoostWeights.push_back(0.0494767);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.576322,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470504,-99) , 
3, -1.91074, 0, 0, 0.535972,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5154,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472312,-99) , 
3, 0.282359, 0, 0, 0.501618,-99) , 
1, -1.05575, 1, 0, 0.506347,-99)    );
  // itree = 156
  fBoostWeights.push_back(0.0349855);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.572121, 0, 1, 0.515176,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503585,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.433962,-99) , 
3, 1.29838, 0, 0, 0.48465,-99) , 
0, 0.627615, 1, 0, 0.502104,-99)    );
  // itree = 157
  fBoostWeights.push_back(0.0236278);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537696,-99) , 
NN(
0, 
0, 
-1, -1.06743, 0, -1, 0.490923,-99) , 
2, -1.54704, 1, 0, 0.495392,-99)    );
  // itree = 158
  fBoostWeights.push_back(0.0187374);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498054,-99) , 
3, 2.45686, 0, 0, 0.503273,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447717,-99) , 
0, 2.46597, 1, 0, 0.50017,-99)    );
  // itree = 159
  fBoostWeights.push_back(0.0227698);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.948423, 1, 1, 0.508691,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466725,-99) , 
0, 2.00638, 1, 0, 0.504095,-99)    );
  // itree = 160
  fBoostWeights.push_back(0.0305952);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527319,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494049,-99) , 
0, -0.404846, 1, 0, 0.50577,-99) , 
NN(
0, 
0, 
-1, 1.85064, 0, -1, 0.478416,-99) , 
1, 1.26921, 1, 0, 0.49965,-99)    );
  // itree = 161
  fBoostWeights.push_back(0.0269343);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.647315, 1, 1, 0.507848,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519148,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432981,-99) , 
0, -1.45982, 1, 0, 0.480011,-99) , 
3, -0.946475, 0, 0, 0.503116,-99)    );
  // itree = 162
  fBoostWeights.push_back(0.0277025);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507534,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463519,-99) , 
3, -1.27649, 0, 0, 0.501285,-99) , 
NN(
0, 
0, 
-1, 2.00348, 1, -1, 0.47119,-99) , 
1, 1.7342, 1, 0, 0.497422,-99)    );
  // itree = 163
  fBoostWeights.push_back(0.0243504);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531106,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500375,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451063,-99) , 
0, 1.20934, 1, 0, 0.490303,-99) , 
3, 2.81219, 0, 0, 0.493986,-99)    );
  // itree = 164
  fBoostWeights.push_back(0.0455996);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55632,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.442584,-99) , 
0, 2.42304, 1, 0, 0.516747,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501674,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463907,-99) , 
0, 0.321149, 1, 0, 0.485304,-99) , 
3, 2.27524, 0, 0, 0.490158,-99)    );
  // itree = 165
  fBoostWeights.push_back(0.0566806);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533427,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48095,-99) , 
2, 1.1255, 1, 0, 0.502674,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45713,-99) , 
0, -0.963152, 1, 0, 0.473964,-99) , 
3, 0.664383, 0, 0, 0.488328,-99)    );
  // itree = 166
  fBoostWeights.push_back(0.0435437);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.579287,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49147,-99) , 
2, -0.298885, 1, 0, 0.501627,-99) , 
NN(
0, 
0, 
-1, -1.38091, 1, -1, 0.463207,-99) , 
3, -0.409522, 0, 0, 0.491977,-99)    );
  // itree = 167
  fBoostWeights.push_back(0.0370122);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0570923, 1, 1, 0.513408,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509724,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46313,-99) , 
1, -1.04667, 1, 0, 0.479738,-99) , 
3, 0.127431, 0, 0, 0.500976,-99)    );
  // itree = 168
  fBoostWeights.push_back(0.0224181);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54049,-99) , 
NN(
0, 
0, 
-1, -1.10022, 0, -1, 0.491705,-99) , 
3, 2.81219, 0, 0, 0.496118,-99)    );
  // itree = 169
  fBoostWeights.push_back(0.0203583);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.647315, 1, 1, 0.506529,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500277,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438683,-99) , 
0, -1.45982, 1, 0, 0.472349,-99) , 
3, -0.946475, 0, 0, 0.500709,-99)    );
  // itree = 170
  fBoostWeights.push_back(0.0253206);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560733,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495582,-99) , 
0, -0.647315, 1, 0, 0.50144,-99) , 
NN(
0, 
0, 
-1, -1.35224, 1, -1, 0.471859,-99) , 
3, -0.946475, 0, 0, 0.496405,-99)    );
  // itree = 171
  fBoostWeights.push_back(0.0239503);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.594005,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496776,-99) , 
0, 1.39762, 1, 0, 0.521994,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501249,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443104,-99) , 
1, 1.1554, 1, 0, 0.495136,-99) , 
3, 1.73829, 0, 0, 0.501791,-99)    );
  // itree = 172
  fBoostWeights.push_back(0.0267722);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39762, 1, 1, 0.524891,-99) , 
NN(
0, 
0, 
-1, -1.71389, 0, -1, 0.490406,-99) , 
3, 1.73829, 0, 0, 0.498947,-99)    );
  // itree = 173
  fBoostWeights.push_back(0.0224034);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.298885, 1, 1, 0.508793,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443624,-99) , 
2, -0.812998, 1, 0, 0.48302,-99) , 
3, -0.409522, 0, 0, 0.502326,-99)    );
  // itree = 174
  fBoostWeights.push_back(0.0367505);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529406,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489506,-99) , 
1, 0.147596, 1, 0, 0.502196,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502529,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444988,-99) , 
3, -1.71426, 0, 0, 0.475239,-99) , 
3, -0.946475, 0, 0, 0.497606,-99)    );
  // itree = 175
  fBoostWeights.push_back(0.0344584);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537592,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484681,-99) , 
2, 1.79156, 1, 0, 0.517682,-99) , 
NN(
0, 
0, 
-1, 0.803668, 1, -1, 0.48993,-99) , 
3, 1.20134, 0, 0, 0.500299,-99)    );
  // itree = 176
  fBoostWeights.push_back(0.0317344);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543742,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508862,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470442,-99) , 
0, 1.20934, 1, 0, 0.501028,-99) , 
3, 2.81219, 0, 0, 0.504901,-99)    );
  // itree = 177
  fBoostWeights.push_back(0.03108);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564517,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467578,-99) , 
0, 2.42304, 1, 0, 0.530877,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501761,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461739,-99) , 
3, -0.999794, 0, 0, 0.494246,-99) , 
3, 2.27524, 0, 0, 0.49991,-99)    );
  // itree = 178
  fBoostWeights.push_back(0.0333831);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.558625,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467598,-99) , 
1, 2.19611, 1, 0, 0.528547,-99) , 
NN(
0, 
0, 
-1, 0.72181, 1, -1, 0.489392,-99) , 
3, 2.27524, 0, 0, 0.495438,-99)    );
  // itree = 179
  fBoostWeights.push_back(0.0223429);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534448,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542752,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494497,-99) , 
0, -1.63583, 1, 0, 0.498843,-99) , 
3, 2.81219, 0, 0, 0.502059,-99)    );
  // itree = 180
  fBoostWeights.push_back(0.0200045);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.540373,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499657,-99) , 
3, 1.63477, 0, 0, 0.508225,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47472,-99) , 
2, 2.2622, 1, 0, 0.505721,-99)    );
  // itree = 181
  fBoostWeights.push_back(0.0488846);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.597052,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.456344,-99) , 
3, -1.69951, 0, 0, 0.529049,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511597,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.444506,-99) , 
3, -0.559873, 0, 0, 0.505072,-99) , 
2, -1.07089, 1, 0, 0.508777,-99)    );
  // itree = 182
  fBoostWeights.push_back(0.0268899);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.523801,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501997,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459235,-99) , 
3, 0.214585, 0, 0, 0.492988,-99) , 
2, -0.594732, 1, 0, 0.500393,-99)    );
  // itree = 183
  fBoostWeights.push_back(0.028416);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.58304, 0, 1, 0.509631,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501184,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452006,-99) , 
3, 1.3377, 0, 0, 0.483069,-99) , 
2, 0.357579, 1, 0, 0.495821,-99)    );
  // itree = 184
  fBoostWeights.push_back(0.0456493);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491201,-99) , 
3, 0.572121, 0, 0, 0.502123,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.527819,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466755,-99) , 
1, 0.110104, 1, 0, 0.477182,-99) , 
0, 0.627615, 1, 0, 0.491435,-99)    );
  // itree = 185
  fBoostWeights.push_back(0.0423086);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443896,-99) , 
3, -2.11747, 0, 0, 0.518024,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475851,-99) , 
3, 1.36032, 0, 0, 0.489141,-99) , 
0, -0.291562, 1, 0, 0.498177,-99)    );
  // itree = 186
  fBoostWeights.push_back(0.0395367);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515756,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485699,-99) , 
2, 0.395668, 1, 0, 0.504368,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506218,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.452765,-99) , 
1, 1.57961, 1, 0, 0.467995,-99) , 
1, 1.26921, 1, 0, 0.496227,-99)    );
  // itree = 187
  fBoostWeights.push_back(0.0346384);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516467,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48783,-99) , 
3, 0.235364, 0, 0, 0.501975,-99) , 
NN(
0, 
0, 
-1, 1.85064, 0, -1, 0.472207,-99) , 
1, 1.26921, 1, 0, 0.495317,-99)    );
  // itree = 188
  fBoostWeights.push_back(0.0388921);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543061,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491989,-99) , 
0, -0.619111, 1, 0, 0.521415,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.539412,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.485375,-99) , 
3, 3.0078, 0, 0, 0.490206,-99) , 
1, -0.590756, 1, 0, 0.497333,-99)    );
  // itree = 189
  fBoostWeights.push_back(0.0338289);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475662,-99) , 
3, -1.1555, 0, 0, 0.507514,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467724,-99) , 
0, 2.00638, 1, 0, 0.503158,-99)    );
  // itree = 190
  fBoostWeights.push_back(0.016451);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537135,-99) , 
NN(
0, 
0, 
-1, -1.06743, 0, -1, 0.494831,-99) , 
2, -1.54704, 1, 0, 0.498874,-99)    );
  // itree = 191
  fBoostWeights.push_back(0.0180264);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.944317, 0, 1, 0.521362,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501038,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.449975,-99) , 
3, -0.506171, 0, 0, 0.496534,-99) , 
1, -0.590756, 1, 0, 0.502201,-99)    );
  // itree = 192
  fBoostWeights.push_back(0.0378577);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515095,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480883,-99) , 
3, -1.26471, 0, 0, 0.507594,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508723,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.462881,-99) , 
3, 1.86171, 0, 0, 0.485927,-99) , 
0, 0.627615, 1, 0, 0.498308,-99)    );
  // itree = 193
  fBoostWeights.push_back(0.0231723);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535707,-99) , 
NN(
0, 
0, 
-1, -1.06743, 0, -1, 0.490967,-99) , 
2, -1.54704, 1, 0, 0.495246,-99)    );
  // itree = 194
  fBoostWeights.push_back(0.0295099);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514619,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48949,-99) , 
0, 0.417996, 1, 0, 0.503134,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460525,-99) , 
2, 2.2622, 1, 0, 0.499931,-99)    );
  // itree = 195
  fBoostWeights.push_back(0.0274198);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52146,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492614,-99) , 
3, 1.13785, 0, 0, 0.502501,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467864,-99) , 
2, 2.2622, 1, 0, 0.4999,-99)    );
  // itree = 196
  fBoostWeights.push_back(0.0294365);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512189,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472136,-99) , 
1, 0.95754, 1, 0, 0.507868,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500788,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.447133,-99) , 
3, 1.85064, 0, 0, 0.483456,-99) , 
1, 1.26921, 1, 0, 0.502409,-99)    );
  // itree = 197
  fBoostWeights.push_back(0.0288233);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518931,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492962,-99) , 
3, 0.739315, 0, 0, 0.502097,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5102,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467686,-99) , 
3, 2.8871, 0, 0, 0.480841,-99) , 
1, 1.26921, 1, 0, 0.497345,-99)    );
  // itree = 198
  fBoostWeights.push_back(0.0314787);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.550347,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49899,-99) , 
2, -0.944317, 0, 0, 0.520174,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483758,-99) , 
2, 0.427482, 1, 0, 0.493531,-99) , 
1, -0.590756, 1, 0, 0.499617,-99)    );
  // itree = 199
  fBoostWeights.push_back(0.0280109);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560435,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480488,-99) , 
3, -1.91074, 0, 0, 0.529619,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542126,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493495,-99) , 
0, -1.18465, 1, 0, 0.497069,-99) , 
1, -1.05575, 1, 0, 0.501538,-99)    );
  // itree = 200
  fBoostWeights.push_back(0.0297833);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537062,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508468,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.432037,-99) , 
3, -1.06743, 0, 0, 0.503237,-99) , 
2, -1.54704, 1, 0, 0.506473,-99)    );
  // itree = 201
  fBoostWeights.push_back(0.0381545);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567603,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.438152,-99) , 
1, -1.55155, 0, 0, 0.522611,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50394,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459508,-99) , 
3, -0.165596, 0, 0, 0.495831,-99) , 
2, -1.07089, 1, 0, 0.49995,-99)    );
  // itree = 202
  fBoostWeights.push_back(0.0328323);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54111,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487137,-99) , 
0, -0.619111, 1, 0, 0.518217,-99) , 
NN(
0, 
0, 
-1, -0.506171, 0, -1, 0.487341,-99) , 
1, -0.590756, 1, 0, 0.494374,-99)    );
  // itree = 203
  fBoostWeights.push_back(0.0291458);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553295,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47655,-99) , 
3, -1.91074, 0, 0, 0.52378,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475112,-99) , 
0, 1.36473, 1, 0, 0.496722,-99) , 
1, -1.05575, 1, 0, 0.500428,-99)    );
  // itree = 204
  fBoostWeights.push_back(0.0371581);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546081,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483825,-99) , 
3, -1.91074, 0, 0, 0.522125,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520045,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4852,-99) , 
3, 1.98332, 0, 0, 0.493393,-99) , 
1, -1.05575, 1, 0, 0.497325,-99)    );
  // itree = 205
  fBoostWeights.push_back(0.014536);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.55104,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499906,-99) , 
0, -1.60493, 1, 0, 0.504716,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473434,-99) , 
0, 2.00638, 1, 0, 0.50128,-99)    );
  // itree = 206
  fBoostWeights.push_back(0.0284764);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520348,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494374,-99) , 
3, 0.392653, 0, 0, 0.507667,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477059,-99) , 
0, 2.00638, 1, 0, 0.504306,-99)    );
  // itree = 207
  fBoostWeights.push_back(0.0343359);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.638611, 0, 1, 0.525013,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516708,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48665,-99) , 
0, 0.494743, 1, 0, 0.498613,-99) , 
2, -0.594732, 1, 0, 0.504941,-99)    );
  // itree = 208
  fBoostWeights.push_back(0.0294772);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.549746,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472582,-99) , 
0, 2.42304, 1, 0, 0.522838,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505896,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.45799,-99) , 
2, 1.38254, 1, 0, 0.5008,-99) , 
3, 2.27524, 0, 0, 0.504217,-99)    );
  // itree = 209
  fBoostWeights.push_back(0.0272992);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528683,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.545403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491133,-99) , 
0, -1.63583, 1, 0, 0.495999,-99) , 
3, 2.81219, 0, 0, 0.49897,-99)    );
  // itree = 210
  fBoostWeights.push_back(0.0283956);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531407,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494613,-99) , 
3, 1.32484, 0, 0, 0.50564,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470834,-99) , 
1, 2.19919, 1, 0, 0.503442,-99)    );
  // itree = 211
  fBoostWeights.push_back(0.0204955);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.466244, 1, 1, 0.509086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475498,-99) , 
2, 2.2622, 1, 0, 0.506557,-99)    );
  // itree = 212
  fBoostWeights.push_back(0.0131865);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546612,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49907,-99) , 
3, 2.34362, 0, 0, 0.503859,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47765,-99) , 
1, 2.19919, 1, 0, 0.502205,-99)    );
  // itree = 213
  fBoostWeights.push_back(0.0317074);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51383,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481142,-99) , 
3, -1.27649, 0, 0, 0.508656,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520711,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480153,-99) , 
1, 1.57961, 1, 0, 0.491766,-99) , 
1, 1.26921, 1, 0, 0.50488,-99)    );
  // itree = 214
  fBoostWeights.push_back(0.0176613);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528833,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502831,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.440119,-99) , 
3, -1.06743, 0, 0, 0.49855,-99) , 
2, -1.54704, 1, 0, 0.501432,-99)    );
  // itree = 215
  fBoostWeights.push_back(0.02979);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.559076,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499871,-99) , 
3, -0.638611, 0, 0, 0.5143,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50615,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472025,-99) , 
3, 0.892502, 0, 0, 0.492288,-99) , 
2, -0.594732, 1, 0, 0.497562,-99)    );
  // itree = 216
  fBoostWeights.push_back(0.0366125);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.541316,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490385,-99) , 
0, -0.619111, 1, 0, 0.519725,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486469,-99) , 
3, 3.0078, 0, 0, 0.490835,-99) , 
1, -0.590756, 1, 0, 0.497413,-99)    );
  // itree = 217
  fBoostWeights.push_back(0.0213738);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.49054, 0, 1, 0.509767,-99) , 
NN(
0, 
0, 
-1, 2.48786, 1, -1, 0.487218,-99) , 
0, 1.0872, 1, 0, 0.5029,-99)    );
  // itree = 218
  fBoostWeights.push_back(0.0201645);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520574,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496062,-99) , 
0, -0.466244, 1, 0, 0.503078,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472909,-99) , 
2, 2.2622, 1, 0, 0.500812,-99)    );
  // itree = 219
  fBoostWeights.push_back(0.0271047);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.567948,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499754,-99) , 
2, -0.298885, 1, 0, 0.507646,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522945,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464663,-99) , 
0, -1.34068, 1, 0, 0.489761,-99) , 
3, -0.409522, 0, 0, 0.503184,-99)    );
  // itree = 220
  fBoostWeights.push_back(0.0314714);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.532708, 1, 1, 0.512856,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.52284,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474854,-99) , 
0, -1.61351, 1, 0, 0.490694,-99) , 
3, -0.409522, 0, 0, 0.50733,-99)    );
  // itree = 221
  fBoostWeights.push_back(0.014096);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523446,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498989,-99) , 
3, 1.63477, 0, 0, 0.504143,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476848,-99) , 
2, 2.2622, 1, 0, 0.502092,-99)    );
  // itree = 222
  fBoostWeights.push_back(0.0276573);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511215,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464747,-99) , 
3, -1.67155, 0, 0, 0.506793,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483553,-99) , 
0, 2.00638, 1, 0, 0.504243,-99)    );
  // itree = 223
  fBoostWeights.push_back(0.0289241);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.556465,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494614,-99) , 
3, -0.0483097, 0, 0, 0.510177,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543474,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490303,-99) , 
3, 3.15606, 0, 0, 0.494657,-99) , 
1, -0.125765, 1, 0, 0.500018,-99)    );
  // itree = 224
  fBoostWeights.push_back(0.0278103);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551158,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480417,-99) , 
3, -1.91074, 0, 0, 0.523885,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512577,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492563,-99) , 
1, 0.539291, 1, 0, 0.502261,-99) , 
1, -1.05575, 1, 0, 0.505218,-99)    );
  // itree = 225
  fBoostWeights.push_back(0.0313757);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551204,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476299,-99) , 
0, 2.42304, 1, 0, 0.525038,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520166,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493204,-99) , 
0, -0.480173, 1, 0, 0.501552,-99) , 
3, 2.27524, 0, 0, 0.505188,-99)    );
  // itree = 226
  fBoostWeights.push_back(0.0299219);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0570923, 1, 1, 0.513822,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518493,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483974,-99) , 
1, -1.04667, 1, 0, 0.496246,-99) , 
3, 0.127431, 0, 0, 0.50735,-99)    );
  // itree = 227
  fBoostWeights.push_back(0.0178941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.519484,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497943,-99) , 
3, 1.13785, 0, 0, 0.505336,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479879,-99) , 
2, 2.2622, 1, 0, 0.503422,-99)    );
  // itree = 228
  fBoostWeights.push_back(0.0225849);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.53994, 1, 1, 0.507943,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518024,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.453666,-99) , 
3, 2.77932, 0, 0, 0.487775,-99) , 
2, 1.78605, 1, 0, 0.505056,-99)    );
  // itree = 229
  fBoostWeights.push_back(0.028758);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.601069,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495757,-99) , 
3, 1.49054, 0, 0, 0.504233,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.522255,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481081,-99) , 
3, 2.96812, 0, 0, 0.490897,-99) , 
0, 1.0872, 1, 0, 0.50017,-99)    );
  // itree = 230
  fBoostWeights.push_back(0.0243044);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51759,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496155,-99) , 
0, 0.417996, 1, 0, 0.507789,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47743,-99) , 
2, 2.2622, 1, 0, 0.505512,-99)    );
  // itree = 231
  fBoostWeights.push_back(0.0230304);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -0.647315, 1, 1, 0.508776,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512963,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.460265,-99) , 
0, -1.45982, 1, 0, 0.489322,-99) , 
3, -0.946475, 0, 0, 0.505489,-99)    );
  // itree = 232
  fBoostWeights.push_back(0.0231126);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507508,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469178,-99) , 
3, -1.22211, 0, 0, 0.502303,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475373,-99) , 
1, 2.19919, 1, 0, 0.500605,-99)    );
  // itree = 233
  fBoostWeights.push_back(0.0256944);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.546743,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497811,-99) , 
3, -0.638611, 0, 0, 0.509708,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504905,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.47569,-99) , 
3, 0.892502, 0, 0, 0.493036,-99) , 
2, -0.594732, 1, 0, 0.497025,-99)    );
  // itree = 234
  fBoostWeights.push_back(0.0451283);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560396,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.441341,-99) , 
1, -1.55155, 0, 0, 0.518897,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.531237,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486705,-99) , 
1, -0.524783, 1, 0, 0.492907,-99) , 
2, -1.07089, 1, 0, 0.496898,-99)    );
  // itree = 235
  fBoostWeights.push_back(0.0203204);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523331,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.505338,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.44408,-99) , 
3, -1.06743, 0, 0, 0.501167,-99) , 
2, -1.54704, 1, 0, 0.503265,-99)    );
  // itree = 236
  fBoostWeights.push_back(0.0148149);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503766,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474636,-99) , 
0, 1.74436, 1, 0, 0.500635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476358,-99) , 
2, 2.2622, 1, 0, 0.498811,-99)    );
  // itree = 237
  fBoostWeights.push_back(0.0256821);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534626,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469067,-99) , 
0, 2.42304, 1, 0, 0.511602,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502093,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478011,-99) , 
2, 0.589735, 1, 0, 0.493621,-99) , 
3, 2.27524, 0, 0, 0.4964,-99)    );
  // itree = 238
  fBoostWeights.push_back(0.0334816);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551561,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492162,-99) , 
0, 0.0570923, 1, 0, 0.499925,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.515685,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.475806,-99) , 
1, -1.39617, 1, 0, 0.485177,-99) , 
3, 0.127431, 0, 0, 0.494494,-99)    );
  // itree = 239
  fBoostWeights.push_back(0.0185492);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.543334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499979,-99) , 
2, -0.298885, 1, 0, 0.504976,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508419,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.467533,-99) , 
0, -1.34068, 1, 0, 0.485128,-99) , 
3, -0.409522, 0, 0, 0.500033,-99)    );
  // itree = 240
  fBoostWeights.push_back(0.0213854);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.903249, 1, 1, 0.512747,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500938,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.454118,-99) , 
3, -1.6627, 0, 0, 0.492933,-99) , 
3, 0.664383, 0, 0, 0.502874,-99)    );
  // itree = 241
  fBoostWeights.push_back(0.0314291);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.530802,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496009,-99) , 
0, 0.903249, 1, 0, 0.507403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.512378,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478284,-99) , 
0, -0.963152, 1, 0, 0.489413,-99) , 
3, 0.664383, 0, 0, 0.498438,-99)    );
  // itree = 242
  fBoostWeights.push_back(0.0197635);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.1715, 0, 1, 0.507349,-99) , 
NN(
0, 
0, 
-1, -1.25449, 0, -1, 0.482484,-99) , 
3, -0.409522, 0, 0, 0.501158,-99)    );
  // itree = 243
  fBoostWeights.push_back(0.018398);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537863,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483827,-99) , 
1, 2.19611, 1, 0, 0.519946,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500032,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.471749,-99) , 
3, -0.999794, 0, 0, 0.494785,-99) , 
3, 2.27524, 0, 0, 0.498677,-99)    );
  // itree = 244
  fBoostWeights.push_back(0.022906);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537075,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483881,-99) , 
0, 2.42304, 1, 0, 0.518407,-99) , 
NN(
0, 
0, 
-1, 1.38254, 1, -1, 0.491891,-99) , 
3, 2.27524, 0, 0, 0.495992,-99)    );
  // itree = 245
  fBoostWeights.push_back(0.0122989);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.551021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498755,-99) , 
3, 3.17148, 0, 0, 0.516711,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4705,-99) , 
2, 1.38254, 1, 0, 0.497617,-99) , 
3, 2.27524, 0, 0, 0.500569,-99)    );
  // itree = 246
  fBoostWeights.push_back(0.0246656);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537065,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491492,-99) , 
1, 1.96331, 1, 0, 0.517677,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508469,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489274,-99) , 
0, -0.480173, 1, 0, 0.495199,-99) , 
3, 2.27524, 0, 0, 0.498673,-99)    );
  // itree = 247
  fBoostWeights.push_back(0.0155446);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0.0570923, 1, 1, 0.506565,-99) , 
NN(
0, 
0, 
-1, -1.71399, 0, -1, 0.490157,-99) , 
3, 0.127431, 0, 0, 0.500526,-99)    );
  // itree = 248
  fBoostWeights.push_back(0.0278941);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.564457,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491167,-99) , 
0, 1.39762, 1, 0, 0.509797,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.514039,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490062,-99) , 
3, 0.970679, 0, 0, 0.496114,-99) , 
3, 1.73829, 0, 0, 0.4995,-99)    );
  // itree = 249
  fBoostWeights.push_back(0.0162368);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.547056,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49705,-99) , 
3, 3.04373, 0, 0, 0.518317,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503121,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.463275,-99) , 
1, 1.55515, 1, 0, 0.50014,-99) , 
3, 2.27524, 0, 0, 0.502949,-99)    );
  // itree = 250
  fBoostWeights.push_back(0.0218478);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.53543,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488451,-99) , 
0, 2.42304, 1, 0, 0.51893,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5036,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.483962,-99) , 
2, 0.589735, 1, 0, 0.496688,-99) , 
3, 2.27524, 0, 0, 0.500124,-99)    );
  // itree = 251
  fBoostWeights.push_back(0.0181589);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.560332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497999,-99) , 
0, 1.39762, 1, 0, 0.513832,-99) , 
NN(
0, 
0, 
-1, -1.71389, 0, -1, 0.493466,-99) , 
3, 1.73829, 0, 0, 0.498505,-99)    );
  // itree = 252
  fBoostWeights.push_back(0.0178224);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.17148, 0, 1, 0.520852,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50359,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479486,-99) , 
3, -0.999794, 0, 0, 0.499118,-99) , 
3, 2.27524, 0, 0, 0.502474,-99)    );
  // itree = 253
  fBoostWeights.push_back(0.020806);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54953,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499041,-99) , 
3, 3.17148, 0, 0, 0.516403,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508729,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490769,-99) , 
0, -0.480173, 1, 0, 0.496315,-99) , 
3, 2.27524, 0, 0, 0.499417,-99)    );
  // itree = 254
  fBoostWeights.push_back(0.0128696);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.39762, 1, 1, 0.51459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468441,-99) , 
3, -1.71389, 0, 0, 0.496998,-99) , 
3, 1.73829, 0, 0, 0.501349,-99)    );
  // itree = 255
  fBoostWeights.push_back(0.0160878);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.553313,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.497109,-99) , 
0, 1.39762, 1, 0, 0.511375,-99) , 
NN(
0, 
0, 
-1, 1.1554, 1, -1, 0.494469,-99) , 
3, 1.73829, 0, 0, 0.49865,-99)    );
  // itree = 256
  fBoostWeights.push_back(0.019798);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.533291,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487023,-99) , 
1, 2.19611, 1, 0, 0.517955,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.517214,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.495392,-99) , 
3, 1.45384, 0, 0, 0.499286,-99) , 
3, 2.27524, 0, 0, 0.502168,-99)    );
  // itree = 257
  fBoostWeights.push_back(0.023179);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524244,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507317,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469115,-99) , 
3, -0.665601, 0, 0, 0.502545,-99) , 
2, -1.54704, 1, 0, 0.504603,-99)    );
  // itree = 258
  fBoostWeights.push_back(0.0285763);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.570915,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.459333,-99) , 
3, -1.69951, 0, 0, 0.516964,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502282,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.473626,-99) , 
3, -0.165596, 0, 0, 0.497065,-99) , 
2, -1.07089, 1, 0, 0.500119,-99)    );
  // itree = 259
  fBoostWeights.push_back(0.0327525);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523572,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476391,-99) , 
2, -1.95591, 0, 0, 0.513299,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.507642,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482757,-99) , 
1, 0.301517, 1, 0, 0.490882,-99) , 
2, -0.594732, 1, 0, 0.496236,-99)    );
  // itree = 260
  fBoostWeights.push_back(0.0207562);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.521782,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50332,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482365,-99) , 
3, 0.539886, 0, 0, 0.494734,-99) , 
2, -1.54704, 1, 0, 0.497293,-99)    );
  // itree = 261
  fBoostWeights.push_back(0.0296864);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534009,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494917,-99) , 
0, -1.4404, 1, 0, 0.509665,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510897,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484124,-99) , 
3, 1.90938, 0, 0, 0.491652,-99) , 
2, -0.594732, 1, 0, 0.495953,-99)    );
  // itree = 262
  fBoostWeights.push_back(0.0165191);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.538222,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49856,-99) , 
0, -1.53994, 1, 0, 0.502871,-99) , 
NN(
0, 
0, 
-1, 2.77932, 0, -1, 0.474882,-99) , 
2, 1.78605, 1, 0, 0.49886,-99)    );
  // itree = 263
  fBoostWeights.push_back(0.017596);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 1.84943, 0, 1, 0.506104,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50369,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.451303,-99) , 
3, 2.77932, 0, 0, 0.479003,-99) , 
2, 1.78605, 1, 0, 0.50222,-99)    );
  // itree = 264
  fBoostWeights.push_back(0.023247);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510021,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489948,-99) , 
0, 0.417996, 1, 0, 0.500818,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.46888,-99) , 
2, 2.2622, 1, 0, 0.498415,-99)    );
  // itree = 265
  fBoostWeights.push_back(0.0147764);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.503588,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.477983,-99) , 
3, -1.34677, 0, 0, 0.500335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474673,-99) , 
2, 2.2622, 1, 0, 0.498406,-99)    );
  // itree = 266
  fBoostWeights.push_back(0.0184784);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506712,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490612,-99) , 
2, 0.0838743, 1, 0, 0.49758,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.478359,-99) , 
2, 2.2622, 1, 0, 0.496135,-99)    );
  // itree = 267
  fBoostWeights.push_back(0.0181442);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532099,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496295,-99) , 
2, -0.298885, 1, 0, 0.500422,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502299,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.4717,-99) , 
3, -1.25449, 0, 0, 0.486885,-99) , 
3, -0.409522, 0, 0, 0.497056,-99)    );
  // itree = 268
  fBoostWeights.push_back(0.0144864);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.1715, 0, 1, 0.503913,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506209,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.476975,-99) , 
2, -1.66486, 1, 0, 0.486915,-99) , 
3, -0.409522, 0, 0, 0.499687,-99)    );
  // itree = 269
  fBoostWeights.push_back(0.015052);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.536364,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49242,-99) , 
3, 3.04373, 0, 0, 0.511111,-99) , 
NN(
0, 
0, 
-1, -0.999794, 0, -1, 0.494722,-99) , 
3, 2.27524, 0, 0, 0.497254,-99)    );
  // itree = 270
  fBoostWeights.push_back(0.0128044);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.54173,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498773,-99) , 
0, 0.0570923, 1, 0, 0.504378,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500064,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.461919,-99) , 
2, -1.85737, 0, 0, 0.493896,-99) , 
3, 0.127431, 0, 0, 0.500522,-99)    );
  // itree = 271
  fBoostWeights.push_back(0.0278406);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510576,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.464926,-99) , 
3, 0.357995, 0, 0, 0.506745,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.516689,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48405,-99) , 
1, -1.39617, 1, 0, 0.49173,-99) , 
3, 0.127431, 0, 0, 0.501221,-99)    );
  // itree = 272
  fBoostWeights.push_back(0.0155452);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.51717,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496087,-99) , 
3, 1.63477, 0, 0, 0.500526,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.479085,-99) , 
2, 2.2622, 1, 0, 0.498915,-99)    );
  // itree = 273
  fBoostWeights.push_back(0.0229112);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508601,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482337,-99) , 
3, -1.27649, 0, 0, 0.50448,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511565,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481623,-99) , 
1, 1.57961, 1, 0, 0.490188,-99) , 
1, 1.26921, 1, 0, 0.501288,-99)    );
  // itree = 274
  fBoostWeights.push_back(0.0230135);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.537403,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.469603,-99) , 
3, -1.91074, 0, 0, 0.511284,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532103,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494049,-99) , 
0, -1.18465, 1, 0, 0.496813,-99) , 
1, -1.05575, 1, 0, 0.498783,-99)    );
  // itree = 275
  fBoostWeights.push_back(0.0186194);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.544848,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.498716,-99) , 
3, 3.17148, 0, 0, 0.514616,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506153,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487384,-99) , 
0, 0.72181, 1, 0, 0.500701,-99) , 
3, 2.27524, 0, 0, 0.502852,-99)    );
  // itree = 276
  fBoostWeights.push_back(0.0179242);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.532581,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.48572,-99) , 
0, 2.42304, 1, 0, 0.516067,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502806,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.480886,-99) , 
3, -0.999794, 0, 0, 0.498751,-99) , 
3, 2.27524, 0, 0, 0.501426,-99)    );
  // itree = 277
  fBoostWeights.push_back(0.019605);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.17148, 0, 1, 0.514751,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511688,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491829,-99) , 
0, -0.880834, 1, 0, 0.495927,-99) , 
3, 2.27524, 0, 0, 0.498835,-99)    );
  // itree = 278
  fBoostWeights.push_back(0.0250403);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510335,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.486386,-99) , 
0, 1.45352, 1, 0, 0.503459,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511904,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.481571,-99) , 
0, -1.61351, 1, 0, 0.491597,-99) , 
3, -0.409522, 0, 0, 0.500512,-99)    );
  // itree = 279
  fBoostWeights.push_back(0.019381);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.542635,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499717,-99) , 
3, 3.17148, 0, 0, 0.514502,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.513874,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492373,-99) , 
3, 1.45384, 0, 0, 0.496209,-99) , 
3, 2.27524, 0, 0, 0.499035,-99)    );
  // itree = 280
  fBoostWeights.push_back(0.015801);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529944,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49043,-99) , 
0, 2.42304, 1, 0, 0.516014,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502525,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.472641,-99) , 
2, 1.38254, 1, 0, 0.499325,-99) , 
3, 2.27524, 0, 0, 0.501903,-99)    );
  // itree = 281
  fBoostWeights.push_back(0.0112017);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535783,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499378,-99) , 
3, 3.04373, 0, 0, 0.514854,-99) , 
NN(
0, 
0, 
-1, 1.1554, 1, -1, 0.49622,-99) , 
3, 2.27524, 0, 0, 0.499099,-99)    );
  // itree = 282
  fBoostWeights.push_back(0.0142507);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.528421,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488714,-99) , 
1, 2.19611, 1, 0, 0.515276,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501928,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482069,-99) , 
1, 1.1554, 1, 0, 0.499021,-99) , 
3, 2.27524, 0, 0, 0.501531,-99)    );
  // itree = 283
  fBoostWeights.push_back(0.0188146);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.526334,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491589,-99) , 
0, 2.42304, 1, 0, 0.514077,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.511133,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.493326,-99) , 
3, 1.45384, 0, 0, 0.496501,-99) , 
3, 2.27524, 0, 0, 0.499215,-99)    );
  // itree = 284
  fBoostWeights.push_back(0.00776753);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 2.1317, 0, 1, 0.502943,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484527,-99) , 
2, 2.2622, 1, 0, 0.50156,-99)    );
  // itree = 285
  fBoostWeights.push_back(0.0141054);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534462,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49614,-99) , 
3, 3.04373, 0, 0, 0.512425,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501838,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.482236,-99) , 
2, 0.986136, 1, 0, 0.497625,-99) , 
3, 2.27524, 0, 0, 0.49991,-99)    );
  // itree = 286
  fBoostWeights.push_back(0.0135187);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.524456,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489724,-99) , 
1, 2.19611, 1, 0, 0.512957,-99) , 
NN(
0, 
0, 
-1, -0.999794, 0, -1, 0.495614,-99) , 
3, 2.27524, 0, 0, 0.498291,-99)    );
  // itree = 287
  fBoostWeights.push_back(0.0115157);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535157,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499554,-99) , 
3, 3.17148, 0, 0, 0.511819,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.502171,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.484992,-99) , 
3, -0.999794, 0, 0, 0.498994,-99) , 
3, 2.27524, 0, 0, 0.500973,-99)    );
  // itree = 288
  fBoostWeights.push_back(0.0187897);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.523917,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492024,-99) , 
2, 2.42036, 1, 0, 0.512716,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508026,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492351,-99) , 
0, -0.480173, 1, 0, 0.49718,-99) , 
3, 2.27524, 0, 0, 0.499577,-99)    );
  // itree = 289
  fBoostWeights.push_back(0.0193475);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510046,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470407,-99) , 
2, 2.47838, 1, 0, 0.505875,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501867,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.466661,-99) , 
3, -1.6627, 0, 0, 0.495869,-99) , 
3, 0.664383, 0, 0, 0.500887,-99)    );
  // itree = 290
  fBoostWeights.push_back(0.0142891);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.535388,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.496002,-99) , 
3, 3.17148, 0, 0, 0.509581,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500841,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.488607,-99) , 
3, 0.227023, 0, 0, 0.495156,-99) , 
3, 2.27524, 0, 0, 0.497381,-99)    );
  // itree = 291
  fBoostWeights.push_back(0.0345178);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.548598,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.443371,-99) , 
1, -1.55155, 0, 0, 0.511671,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.520971,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.490525,-99) , 
1, -0.524783, 1, 0, 0.494744,-99) , 
2, -1.07089, 1, 0, 0.497339,-99)    );
  // itree = 292
  fBoostWeights.push_back(0.0166249);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.04373, 0, 1, 0.519314,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.50505,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.492252,-99) , 
3, 0.227023, 0, 0, 0.499107,-99) , 
3, 2.27524, 0, 0, 0.502227,-99)    );
  // itree = 293
  fBoostWeights.push_back(0.0148522);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 3.04373, 0, 1, 0.515163,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.5034,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.487608,-99) , 
0, 0.72181, 1, 0, 0.498811,-99) , 
3, 2.27524, 0, 0, 0.501335,-99)    );
  // itree = 294
  fBoostWeights.push_back(0.014829);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.529582,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.49804,-99) , 
3, 3.04373, 0, 0, 0.511453,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.509872,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.494517,-99) , 
3, 1.45384, 0, 0, 0.497256,-99) , 
3, 2.27524, 0, 0, 0.499447,-99)    );
  // itree = 295
  fBoostWeights.push_back(0.0217319);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.518149,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.510125,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.489913,-99) , 
3, 0.941715, 0, 0, 0.49982,-99) , 
2, -1.54704, 1, 0, 0.501549,-99)    );
  // itree = 296
  fBoostWeights.push_back(0.0129272);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.534833,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.499581,-99) , 
3, 1.84943, 0, 0, 0.503681,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.504318,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.465211,-99) , 
3, 2.77932, 0, 0, 0.485896,-99) , 
2, 1.78605, 1, 0, 0.501134,-99)    );
  // itree = 297
  fBoostWeights.push_back(0.0149824);
  fForest.push_back( 
NN(
NN(
0, 
0, 
-1, -1.53994, 1, 1, 0.506162,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.501086,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.468429,-99) , 
3, 2.77932, 0, 0, 0.485706,-99) , 
2, 1.78605, 1, 0, 0.503232,-99)    );
  // itree = 298
  fBoostWeights.push_back(0.0192271);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.506824,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.474573,-99) , 
1, 0.95754, 1, 0, 0.503347,-99) , 
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.500541,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.470435,-99) , 
2, 1.95073, 1, 0, 0.488302,-99) , 
1, 1.26921, 1, 0, 0.499992,-99)    );
  // itree = 299
  fBoostWeights.push_back(0.0189137);
  fForest.push_back( 
NN(
NN(
NN(
0, 
0, 
-1, 0, 1, 1, 0.508305,-99) , 
NN(
0, 
0, 
-1, 0, 1, -1, 0.491208,-99) , 
0, 0.0434145, 1, 0, 0.499577,-99) , 
NN(
0, 
0, 
-1, 1.41228, 0, -1, 0.487401,-99) , 
1, 1.26921, 1, 0, 0.496861,-99)    );
   return;
};

// Clean up
inline void ReadBDT::Clear() 
{
   for (unsigned int itree=0; itree<fForest.size(); itree++) { 
      delete fForest[itree]; 
   }
}

inline double ReadBDT::GetMvaValue( const std::vector<double>& inputValues ) const
{
   // classifier response value
   double retval = 0;

   // classifier response, sanity check first
   if (!IsStatusClean()) {
      std::cout << "Problem in class \"" << fClassName << "\": cannot return classifier response"
                << " because status is dirty" << std::endl;
   }
   else {
         retval = GetMvaValue__( inputValues );
   }

   return retval;
}
