ace.define("ace/snippets",[],function(r,a,b){"use strict";var d=r("./lib/dom");var o=r("./lib/oop");var E=r("./lib/event_emitter").EventEmitter;var l=r("./lib/lang");var R=r("./range").Range;var f=r("./range_list").RangeList;var H=r("./keyboard/hash_handler").HashHandler;var T=r("./tokenizer").Tokenizer;var g=r("./clipboard");var V={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange());},SELECTION:function(e,c,i){var t=e.session.getTextRange();if(i)return t.replace(/\n\r?([ \t]*\S)/g,"\n"+i+"$1");return t;},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row);},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1);},LINE_INDEX:function(e){return e.getCursorPosition().row;},LINE_NUMBER:function(e){return e.getCursorPosition().row+1;},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO";},TAB_SIZE:function(e){return e.session.getTabSize();},CLIPBOARD:function(e){return g.getText&&g.getText();},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0];},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"");},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"");},FILEPATH:function(e){return"/not implemented.txt";},WORKSPACE_NAME:function(){return"Unknown";},FULLNAME:function(){return"Unknown";},BLOCK_COMMENT_START:function(e){var m=e.session.$mode||{};return m.blockComment&&m.blockComment.start||"";},BLOCK_COMMENT_END:function(e){var m=e.session.$mode||{};return m.blockComment&&m.blockComment.end||"";},LINE_COMMENT:function(e){var m=e.session.$mode||{};return m.lineCommentStart||"";},CURRENT_YEAR:h.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:h.bind(null,{year:"2-digit"}),CURRENT_MONTH:h.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:h.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:h.bind(null,{month:"short"}),CURRENT_DATE:h.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:h.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:h.bind(null,{weekday:"short"}),CURRENT_HOUR:h.bind(null,{hour:"2-digit",hour12:false}),CURRENT_MINUTE:h.bind(null,{minute:"2-digit"}),CURRENT_SECOND:h.bind(null,{second:"2-digit"})};V.SELECTED_TEXT=V.SELECTION;function h(c){var s=new Date().toLocaleString("en-us",c);return s.length==1?"0"+s:s;}var S=function(){this.snippetMap={};this.snippetNameMap={};};(function(){o.implement(this,E);this.getTokenizer=function(){return S.$tokenizer||this.createTokenizer();};this.createTokenizer=function(){function c(s){s=s.substr(1);if(/^\d+$/.test(s))return[{tabstopId:parseInt(s,10)}];return[{text:s}];}function e(j){return"(?:[^\\\\"+j+"]|\\\\.)";}var i={regex:"/("+e("/")+"+)/",onMatch:function(v,s,j){var t=j[0];t.fmtString=true;t.guard=v.slice(1,-1);t.flag="";return"";},next:"formatString"};S.$tokenizer=new T({start:[{regex:/\\./,onMatch:function(v,s,j){var m=v[1];if(m=="}"&&j.length){v=m;}else if("`$\\".indexOf(m)!=-1){v=m;}return[v];}},{regex:/}/,onMatch:function(v,s,j){return[j.length?j.shift():v];}},{regex:/\$(?:\d+|\w+)/,onMatch:c},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(s,j,m){var t=c(s.substr(1));m.unshift(t[0]);return t;},next:"snippetVar"},{regex:/\n/,token:"newline",merge:false}],snippetVar:[{regex:"\\|"+e("\\|")+"*\\|",onMatch:function(v,s,j){var m=v.slice(1,-1).replace(/\\[,|\\]|,/g,function(p){return p.length==2?p[1]:"\x00";}).split("\x00").map(function(p){return{value:p};});j[0].choices=m;return[m[0]];},next:"start"},i,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(v,s,j){if(j.length&&j[0].expectElse){j[0].expectElse=false;j[0].ifEnd={elseEnd:j[0]};return[j[0].ifEnd];}return":";}},{regex:/\\./,onMatch:function(v,s,j){var m=v[1];if(m=="}"&&j.length)v=m;else if("`$\\".indexOf(m)!=-1)v=m;else if(m=="n")v="\n";else if(m=="t")v="\t";else if("ulULE".indexOf(m)!=-1)v={changeCase:m,local:m>"a"};return[v];}},{regex:"/\\w*}",onMatch:function(v,s,j){var m=j.shift();if(m)m.flag=v.slice(1,-1);this.next=m&&m.tabstopId?"start":"";return[m||v];},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(v,s,j){return[{text:v.slice(1)}];}},{regex:/\${\w+/,onMatch:function(v,s,j){var t={text:v.slice(2)};j.unshift(t);return[t];},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:false},{regex:/}/,onMatch:function(v,s,j){var m=j.shift();this.next=m&&m.tabstopId?"start":"";return[m||v];},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(v,s,j){var t=j[0];t.formatFunction=v.slice(2,-1);return[j.shift()];},next:"formatString"},i,{regex:/:[\?\-+]?/,onMatch:function(v,s,j){if(v[1]=="+")j[0].ifEnd=j[0];if(v[1]=="?")j[0].expectElse=true;},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]});return S.$tokenizer;};this.tokenizeTmSnippet=function(s,c){return this.getTokenizer().getLineTokens(s,c).tokens.map(function(x){return x.value||x;});};this.getVariableValue=function(e,c,i){if(/^\d+$/.test(c))return(this.variables.__||{})[c]||"";if(/^[A-Z]\d+$/.test(c))return(this.variables[c[0]+"__"]||{})[c.substr(1)]||"";c=c.replace(/^TM_/,"");if(!this.variables.hasOwnProperty(c))return"";var v=this.variables[c];if(typeof v=="function")v=this.variables[c](e,c,i);return v==null?"":v;};this.variables=V;this.tmStrFormat=function(s,c,e){if(!c.fmt)return s;var j=c.flag||"";var m=c.guard;m=new RegExp(m,j.replace(/[^gim]/g,""));var p=typeof c.fmt=="string"?this.tokenizeTmSnippet(c.fmt,"formatString"):c.fmt;var _=this;var t=s.replace(m,function(){var v=_.variables.__;_.variables.__=[].slice.call(arguments);var w=_.resolveVariables(p,e);var x="E";for(var i=0;i<w.length;i++){var c=w[i];if(typeof c=="object"){w[i]="";if(c.changeCase&&c.local){var y=w[i+1];if(y&&typeof y=="string"){if(c.changeCase=="u")w[i]=y[0].toUpperCase();else w[i]=y[0].toLowerCase();w[i+1]=y.substr(1);}}else if(c.changeCase){x=c.changeCase;}}else if(x=="U"){w[i]=c.toUpperCase();}else if(x=="L"){w[i]=c.toLowerCase();}}_.variables.__=v;return w.join("");});return t;};this.tmFormatFunction=function(s,c,e){if(c.formatFunction=="upcase")return s.toUpperCase();if(c.formatFunction=="downcase")return s.toLowerCase();return s;};this.resolveVariables=function(s,e){var c=[];var m="";var p=true;for(var i=0;i<s.length;i++){var t=s[i];if(typeof t=="string"){c.push(t);if(t=="\n"){p=true;m="";}else if(p){m=/^\t*/.exec(t)[0];p=/\S/.test(t);}continue;}if(!t)continue;p=false;if(t.fmtString){var j=s.indexOf(t,i+1);if(j==-1)j=s.length;t.fmt=s.slice(i+1,j);i=j;}if(t.text){var v=this.getVariableValue(e,t.text,m)+"";if(t.fmtString)v=this.tmStrFormat(v,t,e);if(t.formatFunction)v=this.tmFormatFunction(v,t,e);if(v&&!t.ifEnd){c.push(v);w(t);}else if(!v&&t.ifEnd){w(t.ifEnd);}}else if(t.elseEnd){w(t.elseEnd);}else if(t.tabstopId!=null){c.push(t);}else if(t.changeCase!=null){c.push(t);}}function w(t){var x=s.indexOf(t,i+1);if(x!=-1)i=x;}return c;};this.insertSnippetForSelection=function(e,s){var c=e.getCursorPosition();var m=e.session.getLine(c.row);var v=e.session.getTabString();var w=m.match(/^\s*/)[0];if(c.column<w.length)w=w.slice(0,c.column);s=s.replace(/\r/g,"");var y=this.tokenizeTmSnippet(s);y=this.resolveVariables(y,e);y=y.map(function(x){if(x=="\n")return x+w;if(typeof x=="string")return x.replace(/\t/g,v);return x;});var z=[];y.forEach(function(p,i){if(typeof p!="object")return;var C=p.tabstopId;var D=z[C];if(!D){D=z[C]=[];D.index=C;D.value="";D.parents={};}if(D.indexOf(p)!==-1)return;if(p.choices&&!D.choices)D.choices=p.choices;D.push(p);var F=y.indexOf(p,i+1);if(F===-1)return;var G=y.slice(i+1,F);var j=G.some(function(t){return typeof t==="object";});if(j&&!D.value){D.value=G;}else if(G.length&&(!D.value||typeof D.value!=="string")){D.value=G.join("");}});z.forEach(function(D){D.length=0;});var A={};function B(t){var x=[];for(var i=0;i<t.length;i++){var p=t[i];if(typeof p=="object"){if(A[p.tabstopId])continue;var j=t.lastIndexOf(p,i-1);p=x[j]||{tabstopId:p.tabstopId};}x[i]=p;}return x;}for(var i=0;i<y.length;i++){var p=y[i];if(typeof p!="object")continue;var C=p.tabstopId;var D=z[C];var F=y.indexOf(p,i+1);if(A[C]){if(A[C]===p){delete A[C];Object.keys(A).forEach(function(j){D.parents[j]=true;});}continue;}A[C]=p;var G=D.value;if(typeof G!=="string")G=B(G);else if(p.fmt)G=this.tmStrFormat(G,p,e);y.splice.apply(y,[i+1,Math.max(0,F-i)].concat(G,p));if(D.indexOf(p)===-1)D.push(p);}var I=0,J=0;var K="";y.forEach(function(t){if(typeof t==="string"){var j=t.split("\n");if(j.length>1){J=j[j.length-1].length;I+=j.length-1;}else J+=t.length;K+=t;}else if(t){if(!t.start)t.start={row:I,column:J};else t.end={row:I,column:J};}});var L=e.getSelectionRange();var M=e.session.replace(L,K);var N=new k(e);var O=e.inVirtualSelectionMode&&e.selection.index;N.addTabstops(z,L.start,M,O);};this.insertSnippet=function(e,s){var c=this;if(e.inVirtualSelectionMode)return c.insertSnippetForSelection(e,s);e.forEachSelection(function(){c.insertSnippetForSelection(e,s);},null,{keepOrder:true});if(e.tabstopManager)e.tabstopManager.tabNext();};this.$getScope=function(e){var s=e.session.$mode.$id||"";s=s.split("/").pop();if(s==="html"||s==="php"){if(s==="php"&&!e.session.$mode.inlinePhp)s="html";var c=e.getCursorPosition();var i=e.session.getState(c.row);if(typeof i==="object"){i=i[0];}if(i.substring){if(i.substring(0,3)=="js-")s="javascript";else if(i.substring(0,4)=="css-")s="css";else if(i.substring(0,4)=="php-")s="php";}}return s;};this.getActiveScopes=function(e){var s=this.$getScope(e);var c=[s];var i=this.snippetMap;if(i[s]&&i[s].includeScopes){c.push.apply(c,i[s].includeScopes);}c.push("_");return c;};this.expandWithTab=function(e,c){var s=this;var i=e.forEachSelection(function(){return s.expandSnippetForSelection(e,c);},null,{keepOrder:true});if(i&&e.tabstopManager)e.tabstopManager.tabNext();return i;};this.expandSnippetForSelection=function(e,c){var i=e.getCursorPosition();var j=e.session.getLine(i.row);var m=j.substring(0,i.column);var p=j.substr(i.column);var s=this.snippetMap;var t;this.getActiveScopes(e).some(function(v){var w=s[v];if(w)t=this.findMatchingSnippet(w,m,p);return!!t;},this);if(!t)return false;if(c&&c.dryRun)return true;e.session.doc.removeInLine(i.row,i.column-t.replaceBefore.length,i.column+t.replaceAfter.length);this.variables.M__=t.matchBefore;this.variables.T__=t.matchAfter;this.insertSnippetForSelection(e,t.content);this.variables.M__=this.variables.T__=null;return true;};this.findMatchingSnippet=function(c,e,j){for(var i=c.length;i--;){var s=c[i];if(s.startRe&&!s.startRe.test(e))continue;if(s.endRe&&!s.endRe.test(j))continue;if(!s.startRe&&!s.endRe)continue;s.matchBefore=s.startRe?s.startRe.exec(e):[""];s.matchAfter=s.endRe?s.endRe.exec(j):[""];s.replaceBefore=s.triggerRe?s.triggerRe.exec(e)[0]:"";s.replaceAfter=s.endTriggerRe?s.endTriggerRe.exec(j)[0]:"";return s;}};this.snippetMap={};this.snippetNameMap={};this.register=function(c,e){var i=this.snippetMap;var j=this.snippetNameMap;var m=this;if(!c)c=[];function w(s){if(s&&!/^\^?\(.*\)\$?$|^\\b$/.test(s))s="(?:"+s+")";return s||"";}function p(s,v,x){s=w(s);v=w(v);if(x){s=v+s;if(s&&s[s.length-1]!="$")s=s+"$";}else{s=s+v;if(s&&s[0]!="^")s="^"+s;}return new RegExp(s);}function t(s){if(!s.scope)s.scope=e||"_";e=s.scope;if(!i[e]){i[e]=[];j[e]={};}var v=j[e];if(s.name){var x=v[s.name];if(x)m.unregister(x);v[s.name]=s;}i[e].push(s);if(s.prefix)s.tabTrigger=s.prefix;if(!s.content&&s.body)s.content=Array.isArray(s.body)?s.body.join("\n"):s.body;if(s.tabTrigger&&!s.trigger){if(!s.guard&&/^\w/.test(s.tabTrigger))s.guard="\\b";s.trigger=l.escapeRegExp(s.tabTrigger);}if(!s.trigger&&!s.guard&&!s.endTrigger&&!s.endGuard)return;s.startRe=p(s.trigger,s.guard,true);s.triggerRe=new RegExp(s.trigger);s.endRe=p(s.endTrigger,s.endGuard,true);s.endTriggerRe=new RegExp(s.endTrigger);}if(Array.isArray(c)){c.forEach(t);}else{Object.keys(c).forEach(function(s){t(c[s]);});}this._signal("registerSnippets",{scope:e});};this.unregister=function(c,e){var j=this.snippetMap;var m=this.snippetNameMap;function p(s){var t=m[s.scope||e];if(t&&t[s.name]){delete t[s.name];var v=j[s.scope||e];var i=v&&v.indexOf(s);if(i>=0)v.splice(i,1);}}if(c.content)p(c);else if(Array.isArray(c))c.forEach(p);};this.parseSnippetFile=function(s){s=s.replace(/\r/g,"");var c=[],i={};var j=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;var m;while(m=j.exec(s)){if(m[1]){try{i=JSON.parse(m[1]);c.push(i);}catch(e){}}if(m[4]){i.content=m[4].replace(/^\t/gm,"");c.push(i);i={};}else{var p=m[2],v=m[3];if(p=="regex"){var t=/\/((?:[^\/\\]|\\.)*)|$/g;i.guard=t.exec(v)[1];i.trigger=t.exec(v)[1];i.endTrigger=t.exec(v)[1];i.endGuard=t.exec(v)[1];}else if(p=="snippet"){i.tabTrigger=v.match(/^\S*/)[0];if(!i.name)i.name=v;}else if(p){i[p]=v;}}}return c;};this.getSnippetByName=function(c,e){var s=this.snippetNameMap;var i;this.getActiveScopes(e).some(function(j){var m=s[j];if(m)i=m[c];return!!i;},this);return i;};}).call(S.prototype);var k=function(e){if(e.tabstopManager)return e.tabstopManager;e.tabstopManager=this;this.$onChange=this.onChange.bind(this);this.$onChangeSelection=l.delayedCall(this.onChangeSelection.bind(this)).schedule;this.$onChangeSession=this.onChangeSession.bind(this);this.$onAfterExec=this.onAfterExec.bind(this);this.attach(e);};(function(){this.attach=function(e){this.index=0;this.ranges=[];this.tabstops=[];this.$openTabstops=null;this.selectedTabstop=null;this.editor=e;this.editor.on("change",this.$onChange);this.editor.on("changeSelection",this.$onChangeSelection);this.editor.on("changeSession",this.$onChangeSession);this.editor.commands.on("afterExec",this.$onAfterExec);this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler);};this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this);this.ranges=null;this.tabstops=null;this.selectedTabstop=null;this.editor.removeListener("change",this.$onChange);this.editor.removeListener("changeSelection",this.$onChangeSelection);this.editor.removeListener("changeSession",this.$onChangeSession);this.editor.commands.removeListener("afterExec",this.$onAfterExec);this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);this.editor.tabstopManager=null;this.editor=null;};this.onChange=function(c){var e=c.action[0]=="r";var s=this.selectedTabstop||{};var p=s.parents||{};var t=(this.tabstops||[]).slice();for(var i=0;i<t.length;i++){var m=t[i];var v=m==s||p[m.index];m.rangeList.$bias=v?0:1;if(c.action=="remove"&&m!==s){var w=m.parents&&m.parents[s.index];var x=m.rangeList.pointIndex(c.start,w);x=x<0?-x-1:x+1;var y=m.rangeList.pointIndex(c.end,w);y=y<0?-y-1:y-1;var z=m.rangeList.ranges.slice(x,y);for(var j=0;j<z.length;j++)this.removeRange(z[j]);}m.rangeList.$onChange(c);}var A=this.editor.session;if(!this.$inChange&&e&&A.getLength()==1&&!A.getValue())this.detach();};this.updateLinkedFields=function(){var t=this.selectedTabstop;if(!t||!t.hasLinkedRanges||!t.firstNonLinked)return;this.$inChange=true;var s=this.editor.session;var c=s.getTextRange(t.firstNonLinked);for(var i=0;i<t.length;i++){var e=t[i];if(!e.linked)continue;var j=e.original;var m=a.snippetManager.tmStrFormat(c,j,this.editor);s.replace(e,m);}this.$inChange=false;};this.onAfterExec=function(e){if(e.command&&!e.command.readOnly)this.updateLinkedFields();};this.onChangeSelection=function(){if(!this.editor)return;var c=this.editor.selection.lead;var e=this.editor.selection.anchor;var j=this.editor.selection.isEmpty();for(var i=0;i<this.ranges.length;i++){if(this.ranges[i].linked)continue;var m=this.ranges[i].contains(c.row,c.column);var p=j||this.ranges[i].contains(e.row,e.column);if(m&&p)return;}this.detach();};this.onChangeSession=function(){this.detach();};this.tabNext=function(c){var m=this.tabstops.length;var i=this.index+(c||1);i=Math.min(Math.max(i,1),m);if(i==m)i=0;this.selectTabstop(i);if(i===0)this.detach();};this.selectTabstop=function(c){this.$openTabstops=null;var t=this.tabstops[this.index];if(t)this.addTabstopMarkers(t);this.index=c;t=this.tabstops[this.index];if(!t||!t.length)return;this.selectedTabstop=t;var e=t.firstNonLinked||t;if(t.choices)e.cursor=e.start;if(!this.editor.inVirtualSelectionMode){var s=this.editor.multiSelect;s.toSingleRange(e);for(var i=0;i<t.length;i++){if(t.hasLinkedRanges&&t[i].linked)continue;s.addRange(t[i].clone(),true);}}else{this.editor.selection.fromOrientedRange(e);}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler);if(this.selectedTabstop&&this.selectedTabstop.choices)this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices});};this.addTabstops=function(t,s,e){var c=this.useLink||!this.editor.getOption("enableMultiselect");if(!this.$openTabstops)this.$openTabstops=[];if(!t[0]){var p=R.fromPoints(e,e);q(p.start,s);q(p.end,s);t[0]=[p];t[0].index=0;}var i=this.index;var j=[i+1,0];var m=this.ranges;t.forEach(function(v,w){var x=this.$openTabstops[w]||v;for(var i=0;i<v.length;i++){var p=v[i];var y=R.fromPoints(p.start,p.end||p.start);n(y.start,s);n(y.end,s);y.original=p;y.tabstop=x;m.push(y);if(x!=v)x.unshift(y);else x[i]=y;if(p.fmtString||(x.firstNonLinked&&c)){y.linked=true;x.hasLinkedRanges=true;}else if(!x.firstNonLinked)x.firstNonLinked=y;}if(!x.firstNonLinked)x.hasLinkedRanges=false;if(x===v){j.push(x);this.$openTabstops[w]=x;}this.addTabstopMarkers(x);x.rangeList=x.rangeList||new f();x.rangeList.$bias=0;x.rangeList.addList(x);},this);if(j.length>2){if(this.tabstops.length)j.push(j.splice(2,1)[0]);this.tabstops.splice.apply(this.tabstops,j);}};this.addTabstopMarkers=function(t){var s=this.editor.session;t.forEach(function(c){if(!c.markerId)c.markerId=s.addMarker(c,"ace_snippet-marker","text");});};this.removeTabstopMarkers=function(t){var s=this.editor.session;t.forEach(function(c){s.removeMarker(c.markerId);c.markerId=null;});};this.removeRange=function(c){var i=c.tabstop.indexOf(c);if(i!=-1)c.tabstop.splice(i,1);i=this.ranges.indexOf(c);if(i!=-1)this.ranges.splice(i,1);i=c.tabstop.rangeList.ranges.indexOf(c);if(i!=-1)c.tabstop.splice(i,1);this.editor.session.removeMarker(c.markerId);if(!c.tabstop.length){i=this.tabstops.indexOf(c.tabstop);if(i!=-1)this.tabstops.splice(i,1);if(!this.tabstops.length)this.detach();}};this.keyboardHandler=new H();this.keyboardHandler.bindKeys({"Tab":function(e){if(a.snippetManager&&a.snippetManager.expandWithTab(e))return;e.tabstopManager.tabNext(1);e.renderer.scrollCursorIntoView();},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1);e.renderer.scrollCursorIntoView();},"Esc":function(e){e.tabstopManager.detach();}});}).call(k.prototype);var n=function(p,c){if(p.row==0)p.column+=c.column;p.row+=c.row;};var q=function(p,s){if(p.row==s.row)p.column-=s.column;p.row-=s.row;};d.importCssString(".ace_snippet-marker {    -moz-box-sizing: border-box;    box-sizing: border-box;    background: rgba(194, 193, 208, 0.09);    border: 1px dotted rgba(211, 208, 235, 0.62);    position: absolute;}","snippets.css",false);a.snippetManager=new S();var u=r("./editor").Editor;(function(){this.insertSnippet=function(c,e){return a.snippetManager.insertSnippet(this,c,e);};this.expandSnippet=function(c){return a.snippetManager.expandWithTab(this,c);};}).call(u.prototype);});ace.define("ace/autocomplete/popup",[],function(r,a,m){"use strict";var R=r("../virtual_renderer").VirtualRenderer;var E=r("../editor").Editor;var b=r("../range").Range;var c=r("../lib/event");var l=r("../lib/lang");var d=r("../lib/dom");var $=function(e){var f=new R(e);f.$maxLines=4;var g=new E(f);g.setHighlightActiveLine(false);g.setShowPrintMargin(false);g.renderer.setShowGutter(false);g.renderer.setHighlightGutterLine(false);g.$mouseHandler.$focusTimeout=0;g.$highlightTagPending=true;return g;};var A=function(p){var f=d.createElement("div");var g=new $(f);if(p)p.appendChild(f);f.style.display="none";g.renderer.content.style.cursor="default";g.renderer.setStyle("ace_autocomplete");g.setOption("displayIndentGuides",false);g.setOption("dragDelay",150);var n=function(){};g.focus=n;g.$isFocused=true;g.renderer.$cursorLayer.restartTimer=n;g.renderer.$cursorLayer.element.style.opacity=0;g.renderer.$maxLines=8;g.renderer.$keepTextAreaAtCursor=false;g.setHighlightActiveLine(false);g.session.highlight("");g.session.$searchHighlight.clazz="ace_highlight-marker";g.on("mousedown",function(e){var i=e.getDocumentPosition();g.selection.moveToPosition(i);s.start.row=s.end.row=i.row;e.stop();});var h;var j=new b(-1,0,-1,Infinity);var s=new b(-1,0,-1,Infinity);s.id=g.session.addMarker(s,"ace_active-line","fullLine");g.setSelectOnHover=function(v){if(!v){j.id=g.session.addMarker(j,"ace_line-hover","fullLine");}else if(j.id){g.session.removeMarker(j.id);j.id=null;}};g.setSelectOnHover(false);g.on("mousemove",function(e){if(!h){h=e;return;}if(h.x==e.x&&h.y==e.y){return;}h=e;h.scrollTop=g.renderer.scrollTop;var i=h.getDocumentPosition().row;if(j.start.row!=i){if(!j.id)g.setRow(i);o(i);}});g.renderer.on("beforeRender",function(){if(h&&j.start.row!=-1){h.$pos=null;var e=h.getDocumentPosition().row;if(!j.id)g.setRow(e);o(e,true);}});g.renderer.on("afterRender",function(){var e=g.getRow();var t=g.renderer.$textLayer;var i=t.element.childNodes[e-t.config.firstRow];if(i!==t.selectedNode&&t.selectedNode)d.removeCssClass(t.selectedNode,"ace_selected");t.selectedNode=i;if(i)d.addCssClass(i,"ace_selected");});var k=function(){o(-1);};var o=function(e,i){if(e!==j.start.row){j.start.row=j.end.row=e;if(!i)g.session._emit("changeBackMarker");g._emit("changeHoverMarker");}};g.getHoveredRow=function(){return j.start.row;};c.addListener(g.container,"mouseout",k);g.on("hide",k);g.on("changeSelection",k);g.session.doc.getLength=function(){return g.data.length;};g.session.doc.getLine=function(i){var e=g.data[i];if(typeof e=="string")return e;return(e&&e.value)||"";};var q=g.session.bgTokenizer;q.$tokenizeRow=function(e){var t=g.data[e];var u=[];if(!t)return u;if(typeof t=="string")t={value:t};var v=t.caption||t.value||t.name;function w(F,G){F&&u.push({type:(t.className||"")+(G||""),value:F});}var x=v.toLowerCase();var y=(g.filterText||"").toLowerCase();var z=0;var B=0;for(var i=0;i<=y.length;i++){if(i!=B&&(t.matchMask&(1<<i)||i==y.length)){var C=y.slice(B,i);B=i;var D=x.indexOf(C,z);if(D==-1)continue;w(v.slice(z,D),"");z=D+C.length;w(v.slice(D,z),"completion-highlight");}}w(v.slice(z,v.length),"");if(t.meta)u.push({type:"completion-meta",value:t.meta});if(t.message)u.push({type:"completion-message",value:t.message});return u;};q.$updateOnChange=n;q.start=n;g.session.$computeWidth=function(){return this.screenWidth=0;};g.isOpen=false;g.isTopdown=false;g.autoSelect=true;g.filterText="";g.data=[];g.setData=function(e,i){g.filterText=i||"";g.setValue(l.stringRepeat("\n",e.length),-1);g.data=e||[];g.setRow(0);};g.getData=function(e){return g.data[e];};g.getRow=function(){return s.start.row;};g.setRow=function(e){e=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,e));if(s.start.row!=e){g.selection.clearSelection();s.start.row=s.end.row=e||0;g.session._emit("changeBackMarker");g.moveCursorTo(e||0,0);if(g.isOpen)g._signal("select");}};g.on("changeSelection",function(){if(g.isOpen)g.setRow(g.selection.lead.row);g.renderer.scrollCursorIntoView();});g.hide=function(){this.container.style.display="none";this._signal("hide");g.isOpen=false;};g.show=function(e,i,t){var f=this.container;var u=window.innerHeight;var v=window.innerWidth;var w=this.renderer;var x=w.$maxLines*i*1.4;var y=e.top+this.$borderSize;var z=y>u/2&&!t;if(z&&y+i+x>u){w.$maxPixelHeight=y-2*this.$borderSize;f.style.top="";f.style.bottom=u-y+"px";g.isTopdown=false;}else{y+=i;w.$maxPixelHeight=u-y-0.2*i;f.style.top=y+"px";f.style.bottom="";g.isTopdown=true;}f.style.display="";var B=e.left;if(B+f.offsetWidth>v)B=v-f.offsetWidth;f.style.left=B+"px";this._signal("show");h=null;g.isOpen=true;};g.goTo=function(w){var e=this.getRow();var i=this.session.getLength()-1;switch(w){case"up":e=e<=0?i:e-1;break;case"down":e=e>=i?-1:e+1;break;case"start":e=0;break;case"end":e=i;break;}this.setRow(e);};g.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize;};g.$imageSize=0;g.$borderSize=1;return g;};d.importCssString(".ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {    background-color: #CAD6FA;    z-index: 1;}.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {    background-color: #3a674e;}.ace_editor.ace_autocomplete .ace_line-hover {    border: 1px solid #abbffe;    margin-top: -1px;    background: rgba(233,233,253,0.4);    position: absolute;    z-index: 2;}.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {    border: 1px solid rgba(109, 150, 13, 0.8);    background: rgba(58, 103, 78, 0.62);}.ace_completion-meta {    opacity: 0.5;    margin: 0.9em;}.ace_completion-message {    color: blue;}.ace_editor.ace_autocomplete .ace_completion-highlight{    color: #2d69c7;}.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{    color: #93ca12;}.ace_editor.ace_autocomplete {    width: 300px;    z-index: 200000;    border: 1px lightgray solid;    position: fixed;    box-shadow: 2px 3px 5px rgba(0,0,0,.2);    line-height: 1.4;    background: #fefefe;    color: #111;}.ace_dark.ace_editor.ace_autocomplete {    border: 1px #484747 solid;    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);    line-height: 1.4;    background: #25282c;    color: #c1c1c1;}","autocompletion.css",false);a.AcePopup=A;a.$singleLineEditor=$;});ace.define("ace/autocomplete/util",[],function(r,e,m){"use strict";e.parForEach=function(a,f,c){var b=0;var d=a.length;if(d===0)c();for(var i=0;i<d;i++){f(a[i],function(g,h){b++;if(b===d)c(g,h);});}};var I=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;e.retrievePrecedingIdentifier=function(t,p,a){a=a||I;var b=[];for(var i=p-1;i>=0;i--){if(a.test(t[i]))b.push(t[i]);else break;}return b.reverse().join("");};e.retrieveFollowingIdentifier=function(t,p,a){a=a||I;var b=[];for(var i=p;i<t.length;i++){if(a.test(t[i]))b.push(t[i]);else break;}return b;};e.getCompletionPrefix=function(a){var p=a.getCursorPosition();var l=a.session.getLine(p.row);var b;a.completers.forEach(function(c){if(c.identifierRegexps){c.identifierRegexps.forEach(function(i){if(!b&&i)b=this.retrievePrecedingIdentifier(l,p.column,i);}.bind(this));}}.bind(this));return b||this.retrievePrecedingIdentifier(l,p.column);};});ace.define("ace/autocomplete",[],function(r,c,m){"use strict";var H=r("./keyboard/hash_handler").HashHandler;var A=r("./autocomplete/popup").AcePopup;var u=r("./autocomplete/util");var l=r("./lib/lang");var d=r("./lib/dom");var s=r("./snippets").snippetManager;var f=r("./config");var g=function(){this.autoInsert=false;this.autoSelect=true;this.exactMatch=false;this.gatherCompletionsId=0;this.keyboardHandler=new H();this.keyboardHandler.bindKeys(this.commands);this.blurListener=this.blurListener.bind(this);this.changeListener=this.changeListener.bind(this);this.mousedownListener=this.mousedownListener.bind(this);this.mousewheelListener=this.mousewheelListener.bind(this);this.changeTimer=l.delayedCall(function(){this.updateCompletions(true);}.bind(this));this.tooltipTimer=l.delayedCall(this.updateDocTooltip.bind(this),50);};(function(){this.$init=function(){this.popup=new A(document.body||document.documentElement);this.popup.on("click",function(e){this.insertMatch();e.stop();}.bind(this));this.popup.focus=this.editor.focus.bind(this.editor);this.popup.on("show",this.tooltipTimer.bind(null,null));this.popup.on("select",this.tooltipTimer.bind(null,null));this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null));return this.popup;};this.getPopup=function(){return this.popup||this.$init();};this.openPopup=function(e,p,k){if(!this.popup)this.$init();this.popup.autoSelect=this.autoSelect;this.popup.setData(this.completions.filtered,this.completions.filterText);e.keyBinding.addKeyboardHandler(this.keyboardHandler);var a=e.renderer;this.popup.setRow(this.autoSelect?0:-1);if(!k){this.popup.setTheme(e.getTheme());this.popup.setFontSize(e.getFontSize());var b=a.layerConfig.lineHeight;var h=a.$cursorLayer.getPixelPosition(this.base,true);h.left-=this.popup.getTextLeftOffset();var i=e.container.getBoundingClientRect();h.top+=i.top-a.layerConfig.offset;h.left+=i.left-e.renderer.scrollLeft;h.left+=a.gutterWidth;this.popup.show(h,b);}else if(k&&!p){this.detach();}this.changeTimer.cancel();};this.detach=function(){this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);this.editor.off("changeSelection",this.changeListener);this.editor.off("blur",this.blurListener);this.editor.off("mousedown",this.mousedownListener);this.editor.off("mousewheel",this.mousewheelListener);this.changeTimer.cancel();this.hideDocTooltip();this.gatherCompletionsId+=1;if(this.popup&&this.popup.isOpen)this.popup.hide();if(this.base)this.base.detach();this.activated=false;this.completions=this.base=null;};this.changeListener=function(e){var a=this.editor.selection.lead;if(a.row!=this.base.row||a.column<this.base.column){this.detach();}if(this.activated)this.changeTimer.schedule();else this.detach();};this.blurListener=function(e){var a=document.activeElement;var t=this.editor.textInput.getElement();var b=e.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(e.relatedTarget);var h=this.popup&&this.popup.container;if(a!=t&&a.parentNode!=h&&!b&&a!=this.tooltipNode&&e.relatedTarget!=t){this.detach();}};this.mousedownListener=function(e){this.detach();};this.mousewheelListener=function(e){this.detach();};this.goTo=function(w){this.popup.goTo(w);};this.insertMatch=function(a,o){if(!a)a=this.popup.getData(this.popup.getRow());if(!a)return false;var b=this.completions;this.editor.startOperation({command:{name:"insertMatch"}});if(a.completer&&a.completer.insertMatch){a.completer.insertMatch(this.editor,a);}else{if(b.filterText){var e=this.editor.selection.getAllRanges();for(var i=0,h;h=e[i];i++){h.start.column-=b.filterText.length;this.editor.session.remove(h);}}if(a.snippet)s.insertSnippet(this.editor,a.snippet);else this.editor.execCommand("insertstring",a.value||a);}if(this.completions==b)this.detach();this.editor.endOperation();};this.commands={"Up":function(e){e.completer.goTo("up");},"Down":function(e){e.completer.goTo("down");},"Ctrl-Up|Ctrl-Home":function(e){e.completer.goTo("start");},"Ctrl-Down|Ctrl-End":function(e){e.completer.goTo("end");},"Esc":function(e){e.completer.detach();},"Return":function(e){return e.completer.insertMatch();},"Shift-Return":function(e){e.completer.insertMatch(null,{deleteSuffix:true});},"Tab":function(e){var a=e.completer.insertMatch();if(!a&&!e.tabstopManager)e.completer.goTo("down");else return a;},"PageUp":function(e){e.completer.popup.gotoPageUp();},"PageDown":function(e){e.completer.popup.gotoPageDown();}};this.gatherCompletions=function(e,a){var b=e.getSession();var p=e.getCursorPosition();var h=u.getCompletionPrefix(e);this.base=b.doc.createAnchor(p.row,p.column-h.length);this.base.$insertRight=true;var j=[];var t=e.completers.length;e.completers.forEach(function(k,i){k.getCompletions(e,b,p,h,function(n,o){if(!n&&o)j=j.concat(o);a(null,{prefix:u.getCompletionPrefix(e),matches:j,finished:(--t===0)});});});return true;};this.showPopup=function(e,o){if(this.editor)this.detach();this.activated=true;this.editor=e;if(e.completer!=this){if(e.completer)e.completer.detach();e.completer=this;}e.on("changeSelection",this.changeListener);e.on("blur",this.blurListener);e.on("mousedown",this.mousedownListener);e.on("mousewheel",this.mousewheelListener);this.updateCompletions(false,o);};this.updateCompletions=function(k,o){if(k&&this.base&&this.completions){var p=this.editor.getCursorPosition();var a=this.editor.session.getTextRange({start:this.base,end:p});if(a==this.completions.filterText)return;this.completions.setFilter(a);if(!this.completions.filtered.length)return this.detach();if(this.completions.filtered.length==1&&this.completions.filtered[0].value==a&&!this.completions.filtered[0].snippet)return this.detach();this.openPopup(this.editor,a,k);return;}if(o&&o.matches){var p=this.editor.getSelectionRange().start;this.base=this.editor.session.doc.createAnchor(p.row,p.column);this.base.$insertRight=true;this.completions=new F(o.matches);return this.openPopup(this.editor,"",k);}var _=this.gatherCompletionsId;var b=function(j){if(!j.finished)return;return this.detach();}.bind(this);var e=function(j){var a=j.prefix;var n=j.matches;this.completions=new F(n);if(this.exactMatch)this.completions.exactMatch=true;this.completions.setFilter(a);var q=this.completions.filtered;if(!q.length)return b(j);if(q.length==1&&q[0].value==a&&!q[0].snippet)return b(j);if(this.autoInsert&&q.length==1&&j.finished)return this.insertMatch(q[0]);this.openPopup(this.editor,a,k);}.bind(this);var i=true;var h=null;this.gatherCompletions(this.editor,function(n,j){var a=j.prefix;var q=j&&j.matches;if(!q||!q.length)return b(j);if(a.indexOf(j.prefix)!==0||_!=this.gatherCompletionsId)return;if(i){h=j;return;}e(j);}.bind(this));i=false;if(h){var j=h;h=null;e(j);}};this.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu();};this.updateDocTooltip=function(){var p=this.popup;var a=p.data;var b=a&&(a[p.getHoveredRow()]||a[p.getRow()]);var e=null;if(!b||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();this.editor.completers.some(function(h){if(h.getDocTooltip)e=h.getDocTooltip(b);return e;});if(!e&&typeof b!="string")e=b;if(typeof e=="string")e={docText:e};if(!e||!(e.docHTML||e.docText))return this.hideDocTooltip();this.showDocTooltip(e);};this.showDocTooltip=function(i){if(!this.tooltipNode){this.tooltipNode=d.createElement("div");this.tooltipNode.className="ace_tooltip ace_doc-tooltip";this.tooltipNode.style.margin=0;this.tooltipNode.style.pointerEvents="auto";this.tooltipNode.tabIndex=-1;this.tooltipNode.onblur=this.blurListener.bind(this);this.tooltipNode.onclick=this.onTooltipClick.bind(this);}var t=this.tooltipNode;if(i.docHTML){t.innerHTML=i.docHTML;}else if(i.docText){t.textContent=i.docText;}if(!t.parentNode)document.body.appendChild(t);var p=this.popup;var a=p.container.getBoundingClientRect();t.style.top=p.container.style.top;t.style.bottom=p.container.style.bottom;t.style.display="block";if(window.innerWidth-a.right<320){if(a.left<320){if(p.isTopdown){t.style.top=a.bottom+"px";t.style.left=a.left+"px";t.style.right="";t.style.bottom="";}else{t.style.top=p.container.offsetTop-t.offsetHeight+"px";t.style.left=a.left+"px";t.style.right="";t.style.bottom="";}}else{t.style.right=window.innerWidth-a.left+"px";t.style.left="";}}else{t.style.left=(a.right+1)+"px";t.style.right="";}};this.hideDocTooltip=function(){this.tooltipTimer.cancel();if(!this.tooltipNode)return;var e=this.tooltipNode;if(!this.editor.isFocused()&&document.activeElement==e)this.editor.focus();this.tooltipNode=null;if(e.parentNode)e.parentNode.removeChild(e);};this.onTooltipClick=function(e){var a=e.target;while(a&&a!=this.tooltipNode){if(a.nodeName=="A"&&a.href){a.rel="noreferrer";a.target="_blank";break;}a=a.parentNode;}};this.destroy=function(){this.detach();if(this.popup){this.popup.destroy();var e=this.popup.container;if(e&&e.parentNode)e.parentNode.removeChild(e);}if(this.editor&&this.editor.completer==this)this.editor.completer==null;this.popup=null;};}).call(g.prototype);g.for=function(a){if(a.completer){return a.completer;}if(f.get("sharedPopups")){if(!g.$shared)g.$sharedInstance=new g();a.completer=g.$sharedInstance;}else{a.completer=new g();a.once("destroy",function(e,a){a.completer.destroy();});}return a.completer;};g.startCommand={name:"startAutocomplete",exec:function(e,o){var a=g.for(e);a.autoInsert=false;a.autoSelect=true;a.showPopup(e,o);a.cancelContextMenu();},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var F=function(a,b){this.all=a;this.filtered=a;this.filterText=b||"";this.exactMatch=false;};(function(){this.setFilter=function(e){if(e.length>this.filterText&&e.lastIndexOf(this.filterText,0)===0)var h=this.filtered;else var h=this.all;this.filterText=e;h=this.filterCompletions(h,this.filterText);h=h.sort(function(a,b){return b.exactMatch-a.exactMatch||b.$score-a.$score||(a.caption||a.value).localeCompare(b.caption||b.value);});var p=null;h=h.filter(function(i){var a=i.snippet||i.caption||i.value;if(a===p)return false;p=a;return true;});this.filtered=h;};this.filterCompletions=function(a,n){var b=[];var e=n.toUpperCase();var h=n.toLowerCase();loop:for(var i=0,k;k=a[i];i++){var o=k.caption||k.value||k.snippet;if(!o)continue;var p=-1;var q=0;var t=0;var v,w;if(this.exactMatch){if(n!==o.substr(0,n.length))continue loop;}else{var x=o.toLowerCase().indexOf(h);if(x>-1){t=x;}else{for(var j=0;j<n.length;j++){var y=o.indexOf(h[j],p+1);var z=o.indexOf(e[j],p+1);v=(y>=0)?((z<0||y<z)?y:z):z;if(v<0)continue loop;w=v-p-1;if(w>0){if(p===-1)t+=10;t+=w;q=q|(1<<j);}p=v;}}}k.matchMask=q;k.exactMatch=t?0:1;k.$score=(k.score||0)-t;b.push(k);}return b;};}).call(F.prototype);c.Autocomplete=g;c.FilteredList=F;});ace.define("ace/autocomplete/text_completer",[],function(r,e,m){var R=r("../range").Range;var s=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;function g(d,p){var t=d.getTextRange(R.fromPoints({row:0,column:0},p));return t.split(s).length-1;}function w(d,p){var a=g(d,p);var b=d.getValue().split(s);var c=Object.create(null);var f=b[a];b.forEach(function(h,i){if(!h||h===f)return;var j=Math.abs(a-i);var k=b.length-j;if(c[h]){c[h]=Math.max(k,c[h]);}else{c[h]=k;}});return c;}e.getCompletions=function(a,b,p,c,d){var f=w(b,p);var h=Object.keys(f);d(null,h.map(function(i){return{caption:i,value:i,score:f[i],meta:"local"};}));};});ace.define("ace/ext/language_tools",[],function(r,a,b){"use strict";var c=r("../snippets").snippetManager;var A=r("../autocomplete").Autocomplete;var d=r("../config");var l=r("../lib/lang");var u=r("../autocomplete/util");var t=r("../autocomplete/text_completer");var k={getCompletions:function(e,s,i,m,q){if(s.$mode.completer){return s.$mode.completer.getCompletions(e,s,i,m,q);}var v=e.session.getState(i.row);var w=s.$mode.getCompletions(v,s,i,m);q(null,w);}};var f={getCompletions:function(e,m,q,v,w){var x=[];var y=m.getTokenAt(q.row,q.column);if(y&&y.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/))x.push('html-tag');else x=c.getActiveScopes(e);var z=c.snippetMap;var B=[];x.forEach(function(C){var D=z[C]||[];for(var i=D.length;i--;){var s=D[i];var F=s.name||s.tabTrigger;if(!F)continue;B.push({caption:F,snippet:s.content,meta:s.tabTrigger&&!s.name?s.tabTrigger+"\u21E5 ":"snippet",type:"snippet"});}},this);w(null,B);},getDocTooltip:function(i){if(i.type=="snippet"&&!i.docHTML){i.docHTML=["<b>",l.escapeHTML(i.caption),"</b>","<hr></hr>",l.escapeHTML(i.snippet)].join("");}}};var g=[f,t,k];a.setCompleters=function(v){g.length=0;if(v)g.push.apply(g,v);};a.addCompleter=function(e){g.push(e);};a.textCompleter=t;a.keyWordCompleter=k;a.snippetCompleter=f;var h={name:"expandSnippet",exec:function(e){return c.expandWithTab(e);},bindKey:"Tab"};var o=function(e,i){j(i.session.$mode);};var j=function(m){if(typeof m=="string")m=d.$modes[m];if(!m)return;if(!c.files)c.files={};n(m.$id,m.snippetFileId);if(m.modes)m.modes.forEach(j);};var n=function(i,s){if(!s||!i||c.files[i])return;c.files[i]={};d.loadModule(s,function(m){if(!m)return;c.files[i]=m;if(!m.snippets&&m.snippetText)m.snippets=c.parseSnippetFile(m.snippetText);c.register(m.snippets||[],m.scope);if(m.includeScopes){c.snippetMap[m.scope].includeScopes=m.includeScopes;m.includeScopes.forEach(function(x){j("ace/mode/"+x);});}});};var p=function(e){var i=e.editor;var m=i.completer&&i.completer.activated;if(e.command.name==="backspace"){if(m&&!u.getCompletionPrefix(i))i.completer.detach();}else if(e.command.name==="insertstring"){var q=u.getCompletionPrefix(i);if(q&&!m){var s=A.for(i);s.autoInsert=false;s.showPopup(i);}}};var E=r("../editor").Editor;r("../config").defineOptions(E.prototype,"editor",{enableBasicAutocompletion:{set:function(v){if(v){if(!this.completers)this.completers=Array.isArray(v)?v:g;this.commands.addCommand(A.startCommand);}else{this.commands.removeCommand(A.startCommand);}},value:false},enableLiveAutocompletion:{set:function(v){if(v){if(!this.completers)this.completers=Array.isArray(v)?v:g;this.commands.on('afterExec',p);}else{this.commands.removeListener('afterExec',p);}},value:false},enableSnippets:{set:function(v){if(v){this.commands.addCommand(h);this.on("changeMode",o);o(null,this);}else{this.commands.removeCommand(h);this.off("changeMode",o);}},value:false}});});(function(){ace.require(["ace/ext/language_tools"],function(m){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=m;}});})();
