/* Copyright (c) 2000-2010 Wolfgang Hoermann and Josef Leydold */
/* Department of Statistics and Mathematics, WU Wien, Austria  */

#include "cephes_source.h"
#include <utils/unur_fp_source.h>
#include <utils/umath.h>
static double P[] = {
  1.60119522476751861407E-4,
  1.19135147006586384913E-3,
  1.04213797561761569935E-2,
  4.76367800457137231464E-2,
  2.07448227648435975150E-1,
  4.94214826801497100753E-1,
  9.99999999999999996796E-1
};
static double Q[] = {
-2.31581873324120129819E-5,
 5.39605580493303397842E-4,
-4.45641913851797240494E-3,
 1.18139785222060435552E-2,
 3.58236398605498653373E-2,
-2.34591795718243348568E-1,
 7.14304917030273074085E-2,
 1.00000000000000000320E0
};
#define LOGPI   M_LNPI            
static double STIR[5] = {
 7.87311395793093628397E-4,
-2.29549961613378126380E-4,
-2.68132617805781232825E-3,
 3.47222221605458667310E-3,
 8.33333333333482257126E-2,
};
#define SQTPI   M_SQRT2PI        
static double stirf ( double );
static double stirf( double x)
{
double y, w, v;
w = 1.0/x;
w = 1.0 + w * _unur_cephes_polevl( w, STIR, 4 );
y = exp(x);
if( x > MAXSTIR )
	{ 
	v = pow( x, 0.5 * x - 0.25 );
	y = v * (v / y);
	}
else
	{
	y = pow( x, x - 0.5 ) / y;
	}
y = SQTPI * y * w;
return( y );
}
double _unur_cephes_gamma( double x )
{
double p, q, z;
int i;
int sgngam = 1;
if (!_unur_isfinite(x))
	return(x);
q = fabs(x);
if( q > 33.0 )
	{
	if( x < 0.0 )
		{
		p = floor(q);
		if( _unur_FP_same(p,q) )
			{
			return( sgngam * INFINITY);
			}
		i = (int) p;
		if( (i & 1) == 0 )
			sgngam = -1;
		z = q - p;
		if( z > 0.5 )
			{
			p += 1.0;
			z = q - p;
			}
		z = q * sin( PI * z );
		if( _unur_iszero(z) )
			{
			return( sgngam * INFINITY);
			}
		z = fabs(z);
		z = PI/(z * stirf(q) );
		}
	else
		{
		z = stirf(x);
		}
	return( sgngam * z );
	}
z = 1.0;
while( x >= 3.0 )
	{
	x -= 1.0;
	z *= x;
	}
while( x < 0.0 )
	{
	if( x > -1.E-9 )
		goto small;
	z /= x;
	x += 1.0;
	}
while( x < 2.0 )
	{
	if( x < 1.e-9 )
		goto small;
	z /= x;
	x += 1.0;
	}
if( _unur_isfsame(x, 2.0) )
	return(z);
x -= 2.0;
p = _unur_cephes_polevl( x, P, 6 );
q = _unur_cephes_polevl( x, Q, 7 );
return( z * p / q );
small:
if( _unur_iszero(x) )
	return( INFINITY );
else
	return( z/((1.0 + 0.5772156649015329 * x) * x) );
}
static double A[] = {
 8.11614167470508450300E-4,
-5.95061904284301438324E-4,
 7.93650340457716943945E-4,
-2.77777777730099687205E-3,
 8.33333333333331927722E-2
};
static double B[] = {
-1.37825152569120859100E3,
-3.88016315134637840924E4,
-3.31612992738871184744E5,
-1.16237097492762307383E6,
-1.72173700820839662146E6,
-8.53555664245765465627E5
};
static double C[] = {
-3.51815701436523470549E2,
-1.70642106651881159223E4,
-2.20528590553854454839E5,
-1.13933444367982507207E6,
-2.53252307177582951285E6,
-2.01889141433532773231E6
};
static double LS2PI  =  0.91893853320467274178;
#define MAXLGM 2.556348e305
double _unur_cephes_lgam( double x )
{
double p, q, u, w, z;
int i;
int sgngam = 1;
if (!_unur_isfinite(x))
	return(INFINITY);
if( x < -34.0 )
	{
	q = -x;
	w = _unur_cephes_lgam(q); 
	p = floor(q);
	if( _unur_FP_same(p,q) )
		return (INFINITY);
	i = (int) p;
	if( (i & 1) == 0 )
		sgngam = -1;
	else
		sgngam = 1;
	z = q - p;
	if( z > 0.5 )
		{
		p += 1.0;
		z = p - q;
		}
	z = q * sin( PI * z );
	if( _unur_iszero(z) )
		return (INFINITY);
	z = LOGPI - log( z ) - w;
	return( z );
	}
if( x < 13.0 )
	{
	z = 1.0;
	p = 0.0;
	u = x;
	while( u >= 3.0 )
		{
		p -= 1.0;
		u = x + p;
		z *= u;
		}
	while( u < 2.0 )
		{
		if( _unur_iszero(u) )
		       return (INFINITY);
		z /= u;
		p += 1.0;
		u = x + p;
		}
	if( z < 0.0 )
		{
		sgngam = -1;
		z = -z;
		}
	else
		sgngam = 1;
	if( _unur_isfsame(u, 2.0) )
		return( log(z) );
	p -= 2.0;
	x = x + p;
	p = x * _unur_cephes_polevl( x, B, 5 ) / _unur_cephes_p1evl( x, C, 6);
	return( log(z) + p );
	}
if( x > MAXLGM )
	return( sgngam * INFINITY );
q = ( x - 0.5 ) * log(x) - x + LS2PI;
if( x > 1.0e8 )
	return( q );
p = 1.0/(x*x);
if( x >= 1000.0 )
	q += ((   7.9365079365079365079365e-4 * p
		- 2.7777777777777777777778e-3) *p
		+ 0.0833333333333333333333) / x;
else
	q += _unur_cephes_polevl( p, A, 4 ) / x;
return( q );
}
