//@ui5-bundle sap/ui/unified/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2022 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/unified/Calendar',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/YearRangePicker','./calendar/CalendarDate',"sap/ui/core/date/UniversalDate",'./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale','sap/ui/events/KeyCodes',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log"],function(C,L,a,D,b,H,M,c,Y,d,e,U,l,f,g,R,h,K,j,k,m,n){"use strict";var o=sap.ui.getCore(),p=sap.ui.core.CalendarType;
var q=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},showCurrentDateButton:{type:"boolean",group:"Behavior",defaultValue:false},_currentPicker:{type:"string",group:"Appearance",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},yearRangePicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});
var r={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};
q.prototype.init=function(){this._iBreakPointTablet=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iColumns=1;this.setProperty("_currentPicker",r.MONTH_PICKER);this._oYearFormat=g.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var F=this._createMonth(this.getId()+"--Month0");F.attachEvent("focus",this._handleFocus,this);F.attachEvent("select",y,this);F.attachEvent("_renderMonth",x,this);F.attachEvent("_bindMousemove",z,this);F.attachEvent("_unbindMousemove",A,this);F._bNoThemeChange=true;this.addAggregation("month",F);this._initializeMonthPicker();this._initializeYearPicker();this._initializeYearRangePicker();this._resizeProxy=s.bind(this);this._oSelectedMonth;this._bSkipCancelButtonRendering=false;this._bActionTriggeredFromSecondHeader=false;};
q.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._afterHeaderRenderAdjustCSS){this.removeDelegate(this._afterHeaderRenderAdjustCSS);this._afterHeaderRenderAdjustCSS=null;}if(this._afterSecondHeaderRenderAdjustCSS){this.removeDelegate(this._afterSecondHeaderRenderAdjustCSS);this._afterSecondHeaderRenderAdjustCSS=null;}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};
q.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressCurrentDate",this._handleCurrentDate,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(i);i.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",i);};
q.prototype._createOnAfterRenderingDelegate=function(i){return{onAfterRendering:function(){if(i.getVisible()&&!i.getVisibleButton1()){i.$().find(".sapUiCalHeadB2").addClass("sapUiCalSingleYearButton");}if(i.getVisible()&&!i._getVisibleButton3()){this._isTwoMonthsInTwoColumns()&&i.$().find(".sapUiCalHeadB4").addClass("sapUiCalSingleYearButton");}}.bind(this)};};
q.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead",{visible:false});S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this._afterSecondHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(S);S.addDelegate(this._afterSecondHeaderRenderAdjustCSS);this.setAggregation("secondMonthHeader",S);};
q.prototype._initializeMonthPicker=function(){var i=new c(this.getId()+"--MP");i._bCalendar=true;i.attachEvent("select",this._selectMonth,this);i.attachEvent("pageChange",B,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);i._setSelectedDatesControlOrigin(this);};
q.prototype._initializeYearPicker=function(){var i=new Y(this.getId()+"--YP");i._bCalendar=true;i.attachEvent("select",this._selectYear,this);i.attachEvent("pageChange",E,this);this.setAggregation("yearPicker",i);i._setSelectedDatesControlOrigin(this);};
q.prototype._initializeYearRangePicker=function(){var i=new d(this.getId()+"--YRP");i.attachEvent("select",this._selectYearRange,this);i.setPrimaryCalendarType(this.getPrimaryCalendarType());this.setAggregation("yearRangePicker",i);};
q.prototype._createMonth=function(i){var F=new M(i,{width:"100%"});F._bCalendar=true;F.attachEvent("datehovered",this._handleDateHovered,this);F.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return F;};
q.prototype._handleWeekNumberSelect=function(i){var W=i.getParameter("weekDays"),F=this.fireWeekNumberSelect({weekNumber:i.getParameter("weekNumber"),weekDays:W});this._focusDate(e.fromLocalJSDate(W.getStartDate(),this.getPrimaryCalendarType()),true,false,false);if(!F){i.preventDefault();}return this;};
q.prototype._handleDateHovered=function(F){var G=this.getAggregation("month"),I=F.getParameter("date1"),J=F.getParameter("date2"),i;for(i=0;i<G.length;i++){G[i]._markDatesBetweenStartAndHoveredDate(I,J);}};
q.prototype.onBeforeRendering=function(){var F=this.getAggregation("month"),G,I=F[0].getDate(),J=this._getFocusedDate();if(F.length>1&&I){G=e.fromLocalJSDate(I,this.getPrimaryCalendarType());}else if(F.length>1){G=t.call(this,this._getFocusedDate());}else{G=J;}for(var i=0;i<F.length;i++){I=new e(G);if(i>0){I.setMonth(I.getMonth()+i,1);}var N=I;if(J.getYear()===I.getYear()&&J.getMonth()===I.getMonth()){N=J;}F[i].displayDate(N.toLocalJSDate());F[i].setShowWeekNumbers(this.getShowWeekNumbers());}if(this._getMonthPicker()){this._setDisabledMonths(J.getYear(),this._getMonthPicker());}this._updateHeader(G);this._updateHeadersButtons();};
q.prototype.onAfterRendering=function(i){if(!this._getSucessorsPickerPopup()){u.call(this);}if(w.call(this)>1||this._bInitMonth){i.size={width:this.getDomRef().offsetWidth};s.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};
q.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};
q.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};
q.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
q.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};
q.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
q.prototype._setSpecialDatesControlOrigin=function(i){this._oSpecialDatesControlOrigin=i;};
q.prototype.getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin.getSpecialDates();}if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
q.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};
q.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
q.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();this._toggleTwoMonthsInTwoColumnsCSS();}return this;};
q.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
q.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};
q.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new e(i,this.getPrimaryCalendarType());};
q.prototype.focusDate=function(i){v.call(this,i,false);this._addMonthFocusDelegate();return this;};
q.prototype.displayDate=function(i){v.call(this,i,true);return this;};
q.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=e.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new e(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};
q.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};
q.prototype.setMonths=function(F){this._bDateRangeChanged=undefined;this.setProperty("months",F,false);F=w.call(this);var G=this.getAggregation("month");var i=0;var I;if(G.length<F){for(i=G.length;i<F;i++){I=this._createMonth(this.getId()+"--Month"+i);I.attachEvent("focus",this._handleFocus,this);I.attachEvent("select",y,this);I.attachEvent("_renderMonth",x,this);I.attachEvent("_bindMousemove",z,this);I.attachEvent("_unbindMousemove",A,this);I._bNoThemeChange=true;this.addAggregation("month",I);}}else if(G.length>F){for(i=G.length;i>F;i--){I=this.removeAggregation("month",i-1);I.destroy();}if(F==1){this._bInitMonth=true;}}if(F>1&&G[0].getDate()){G[0].setProperty("date",null,true);}return this;};
q.prototype.setPrimaryCalendarType=function(F){var G=this.getAggregation("month"),I,J,N,O,i;this.setProperty("primaryCalendarType",F);this._adjustYearRangeDisplay();this._oYearFormat=g.getDateInstance({format:"y",calendarType:F});if(this._oFocusedDate){this._oFocusedDate=new e(this._oFocusedDate,F);}this._oMinDate=new e(this._oMinDate,F);this._oMaxDate=new e(this._oMaxDate,F);for(i=0;i<G.length;i++){I=G[i];I.setPrimaryCalendarType(F);}if(!this._getSucessorsPickerPopup()){J=this._getMonthPicker();J.setPrimaryCalendarType(F);N=this._getYearPicker();N.setPrimaryCalendarType(F);O=this.getAggregation("yearRangePicker");O.setPrimaryCalendarType(F);}return this;};
q.prototype.setSecondaryCalendarType=function(F){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",F);this._oYearFormatSecondary=g.getDateInstance({format:"y",calendarType:F});var G=this.getAggregation("month");for(var i=0;i<G.length;i++){var I=G[i];I.setSecondaryCalendarType(F);}return this;};
q.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
q.prototype._getActiveHeaderAggregation=function(){if(this._bActionTriggeredFromSecondHeader&&this._isTwoMonthsInOneColumn()){return this.getAggregation("secondMonthHeader");}else{return this.getAggregation("header");}};
q.prototype._saveTriggeredHeader=function(i){if(i.getSource().sParentAggregationName==="secondMonthHeader"||i.sId==="pressButton3"||i.sId==="pressButton4"){this._bActionTriggeredFromSecondHeader=true;}else{this._bActionTriggeredFromSecondHeader=false;}};
q.prototype.setMinDate=function(i){var P=this.getPrimaryCalendarType(),F;if(m(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(P);}else{a._checkJSDateObject(i);this._oMinDate=e.fromLocalJSDate(i,P);var G=this._oMinDate.getYear();a._checkYearInValidRange(G);if(this._oMaxDate.isBefore(this._oMinDate)){n.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=e.fromLocalJSDate(i,P);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(e.fromLocalJSDate(i,P));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMinDate.getYear();this._getYearPicker()._oMinDate.setYear(F);this.getAggregation("yearRangePicker")._oMinDate.setYear(F);}return this;};
q.prototype.setMaxDate=function(i){var P,F;if(m(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(P);}else{a._checkJSDateObject(i);this._oMaxDate=e.fromLocalJSDate(i,P);var G=this._oMaxDate.getYear();a._checkYearInValidRange(G);if(this._oMinDate.isAfter(this._oMaxDate)){n.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=e.fromLocalJSDate(i,P);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(e.fromLocalJSDate(i,P));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){F=this._oMaxDate.getYear();this._getYearPicker()._oMaxDate.setYear(F);this.getAggregation("yearRangePicker")._oMaxDate.setYear(F);}return this;};
q.prototype.setShowCurrentDateButton=function(S){this.getAggregation("header").setVisibleCurrentDateButton(S);return this.setProperty("showCurrentDateButton",S);};
q.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){n.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};
q.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var F=new h(i);this._oLocaleData=L.getInstance(F);}return this._oLocaleData;};
q.prototype._getShowMonthHeader=function(){var i=w.call(this);if(i>2){return true;}else{return false;}};
q.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker");};
q.prototype._getYearPicker=function(){return this.getAggregation("yearPicker");};
q.prototype._getYearRangePicker=function(){return this.getAggregation("yearRangePicker");};
q.prototype.onclick=function(i){var F=i.target;if(i.isMarked("delayedMouseEvent")){return;}if(F.id==this.getId()+"-cancel"){this.onsapescape(i);}};
q.prototype.onmousedown=function(i){if(i.cancelable){i.preventDefault();}i.setMark("cancelAutoClose");};
q.prototype.onsapescape=function(i){this.fireCancel();this._closePickers();this._addMonthFocusDelegate();if(!this._getSucessorsPickerPopup()){this._setHeaderText(this._getFocusedDate());}};
q.prototype.onsapshow=function(i){var F=i.which||i.keyCode;if(this._bPoupupMode&&F!==K.F4){this._closePickers();this._addMonthFocusDelegate();this.fireCancel();i.preventDefault();}};
q.prototype.onkeydown=function(i){var F=i.which||i.keyCode,S=i.shiftKey;if(F!==K.F4){return;}i.preventDefault();switch(this._iMode){case 0:if(S){this._showYearPicker();}else{this._showMonthPicker();}break;case 1:if(S){this._showYearPicker();}break;case 2:if(S){this._showYearRangePicker();}break;default:}};
q.prototype.onsaphide=q.prototype.onsapshow;
q.prototype.onsaptabnext=function(i){var F=this.getAggregation("header");if(k(this.getDomRef("content"),i.target)){if(F.getVisibleButton1()){F.getDomRef("B1").focus();i.preventDefault();}else if(F.getVisibleButton2()){F.getDomRef("B2").focus();i.preventDefault();}else if(F.getVisibleCurrentDateButton()){F.getDomRef("today").focus();i.preventDefault();}else if(!this._bPoupupMode){this._clearTabindex0();}else{this._clearTabindex0();i.preventDefault();}}else if(i.target.id===F.getId()+"-B1"){F.getVisibleButton2()&&F.getDomRef("B2").focus();i.preventDefault();}else if(i.target.id===F.getId()+"-B2"){if(F.getVisibleCurrentDateButton()){F.getDomRef("today").focus();i.preventDefault();}else{this._tabNextFinalize(this._bPoupupMode,i);}}else if(i.target.id===F.getId()+"-today"){this._tabNextFinalize(this._bPoupupMode,i);}};
q.prototype._tabNextFinalize=function(P,i){if(P){this._moveFocusToCalContent();i.preventDefault();}else{this._clearTabindex0();}};
q.prototype.onsaptabprevious=function(i){var F=this.getAggregation("header");if(k(this.getDomRef("content"),i.target)){if(this._bPoupupMode){if(F.getVisibleCurrentDateButton()){F.getDomRef("today").focus();}else if(F.getVisibleButton2()){F.getDomRef("B2").focus();}else{F.getVisibleButton1()&&F.getDomRef("B1").focus();}i.preventDefault();}else{this._clearTabindex0();}}else if(i.target.id===F.getId()+"-B1"){this._moveFocusToCalContent();i.preventDefault();}else if(i.target.id===F.getId()+"-B2"){if(F.getVisibleButton1()){F.getDomRef("B1").focus();}else{this._moveFocusToCalContent();}i.preventDefault();}else if(i.target.id===F.getId()+"-today"){if(F.getVisibleButton2()){F.getDomRef("B2").focus();}else if(F.getVisibleButton1()){F.getDomRef("B1").focus();}else{this._moveFocusToCalContent();}i.preventDefault();}};
q.prototype._clearTabindex0=function(){var F=this.getAggregation("month"),G=this._getMonthPicker(),I=this.getAggregation("yearPicker"),J=this.getAggregation("yearRangePicker"),N,i;for(i=0;i<F.length;i++){N=F[i];N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}if(!this._getSucessorsPickerPopup()){if(G.getDomRef()){G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}if(I.getDomRef()){I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}if(J.getDomRef()){J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","-1");}}};
q.prototype._moveFocusToCalContent=function(){var F=this.getAggregation("yearPicker"),G=this.getAggregation("yearRangePicker"),I=this._getMonthPicker(),J=this.getAggregation("month"),N,O,P,i;switch(this._iMode){case 0:P=this._getFocusedDate();for(i=0;i<J.length;i++){N=J[i];O=e.fromLocalJSDate(N.getDate(),this.getPrimaryCalendarType());if(P.isSame(O)){N.focus();}else{N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){I.focus();}break;case 2:if(!this._getSucessorsPickerPopup()){F.focus();}break;case 3:if(!this._getSucessorsPickerPopup()){G.focus();}break;}};
q.prototype.onfocusin=function(i){if(i.target.id==this.getId()+"-end"){this._focusOnShiftTab();if(!this._bPoupupMode){this._clearTabindex0();}}this.$("end").attr("tabindex","-1");};
q.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header"),F=i.getDomRef("B2"),G=i.getDomRef("today");if(G){G.focus();}else if(F){F.focus();}else{this.focus();}};
q.prototype.onsapfocusleave=function(F){var G,I,J,N;if(!F.relatedControlId||!k(this.getDomRef(),sap.ui.getCore().byId(F.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){G=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<G.length;i++){I=G[i];if(I._oItemNavigation){I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){J=this._getMonthPicker();J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){N=this._getYearPicker();N._oItemNavigation.getItemDomRefs()[N._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}break;}}}};
q.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0],F=this._getMonthPicker(),G=this._getYearPicker(),I=this._getYearRangePicker();switch(this._iMode){case 0:return i.getFocusDomRef();case 1:return F.getFocusDomRef();case 2:return G.getFocusDomRef();case 3:return I.getFocusDomRef();default:return;}};
q.prototype.onThemeChanged=function(){var F,G=arguments;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){var I={onAfterRendering:function(){F.onThemeChanged(G);F._bNoThemeChange=true;u.call(this);this._bLongMonth=F._bLongMonth;this._closePickers();F.removeEventDelegate(I);}};F=this._getMonthPicker();this._showMonthPicker(true);F._bNoThemeChange=false;F.addEventDelegate(I,this);}var J=this.getAggregation("month");for(var i=0;i<J.length;i++){var N=J[i];N._bNoThemeChange=false;N.onThemeChanged(arguments);N._bNoThemeChange=true;}var O;if(J.length>1){O=e.fromLocalJSDate(J[0].getDate(),this.getPrimaryCalendarType());}else{O=this._getFocusedDate();}this._setHeaderText(O);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();};
q.prototype._updateHeader=function(i){this._setHeaderText(i);switch(this._iMode){case 0:this._togglePrevNext(i,true);break;case 1:this._togglePrevNext(i,false);break;case 2:case 3:this._togglePrevNexYearPicker();break;}};
q.prototype._togglePrevNext=function(i,F){var G=this._oMaxDate.getYear();var I=this._oMinDate.getYear();var J=this._oMaxDate.getMonth();var N=this._oMinDate.getMonth();var O=this.getAggregation("header");var P=w.call(this);var Q=new e(i,this.getPrimaryCalendarType());if(this._iMode===1&&P>1){Q=t.call(this,i);Q.setMonth(Q.getMonth()+P-1);Q.setDate(a._daysInMonth(Q));}else{Q.setDate(a._daysInMonth(Q));}var S=Q.getYear();var T=Q.getMonth();if((this._iMode===0||this._iMode===1)&&P>1){T+=P-1;}if(S>G||(S===G&&(!F||T>=J))||((this._iMode===0||this._iMode===1)&&this._getSucessorsPickerPopup())){O.setEnabledNext(false);}else{O.setEnabledNext(true);}if(this._iMode===1&&P>1){Q.setMonth(Q.getMonth()-P+1,1);}else{Q.setDate(1);}S=Q.getYear();T=Q.getMonth();if(S<I||(S==I&&(!F||T<=N))||(this._iMode==1&&this._getSucessorsPickerPopup())){O.setEnabledPrevious(false);}else{O.setEnabledPrevious(true);}};
q.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearRangePicker"),F=this._getYearPicker(),P=this.getPrimaryCalendarType(),G=new e(this._oMinDate,P),I=new e(this._oMaxDate,P),J=this.getAggregation("header"),N=1,O,Q,S,T;if(this._iMode===3){S=i.getYears();N=i.getRangeSize();O=new e(i.getProperty("_middleDate"));Q=new e(O);O.setYear(O.getYear()-(N*S)/2);Q.setYear(Q.getYear()+(N*S)/2-1);}else{S=F.getYears();T=F.getProperty("_middleDate")?F.getProperty("_middleDate"):e.fromLocalJSDate(new Date());O=new e(T);Q=new e(T);O.setYear(O.getYear()-(S/2));Q.setYear(Q.getYear()+(S/2)-1);}J.setEnabledNext(Q.getYear()<I.getYear());J.setEnabledPrevious(O.getYear()>G.getYear());};
q.prototype._handlePrevious=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J,S=false;switch(this._iMode){case 0:if(G>1){I=e.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setDate(1);this._setFocusedDate(I);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,false);this._addMonthFocusDelegate();break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var N=this._getSecondaryCalendarType();if(N){J=new e(F,N);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());var O=this._getMonthPicker();O._setYear(F.getYear());O.invalidate();this.setProperty("_currentPicker",r.MONTH_PICKER);break;case 2:this._getYearPicker().previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").previousPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};
q.prototype._handleNext=function(i){var F=this._getFocusedDate(),G=w.call(this),I,J;switch(this._iMode){case 0:if(G>1){I=e.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());I.setMonth(I.getMonth(),1);this._setFocusedDate(I);F=this._getFocusedDate();}F.setMonth(F.getMonth()+1,1);this._renderMonth(false,false);this._addMonthFocusDelegate();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){J=new e(F,S);J.setMonth(0,1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(J.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());var N=this._getMonthPicker();N._setYear(F.getYear());N.invalidate();this.setProperty("_currentPicker",r.MONTH_PICKER);break;case 2:this._getYearPicker().nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;case 3:this.getAggregation("yearRangePicker").nextPage();this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());break;}};
q.prototype._handleCurrentDate=function(){var N=new Date(),i=this.getMaxDate(),F=this.getMinDate();this.setProperty("_currentPicker",r.MONTH);if(i&&i.getTime()<N.getTime()){this.focusDate(i);}else if(F&&F.getTime()>N.getTime()){this.focusDate(F);}else{this.focusDate(N);}};
q.prototype._getYearString=function(){var i=this._getYearPicker(),F=i.getDomRef(),G=this._getFocusedDate();if(i&&F&&F.style.display===""){G=i.getProperty("_middleDate");G.setDate(1);}return this._oYearFormat.format(U.getInstance(G.toUTCJSDate(),G.getCalendarType()),true);};
q.prototype._getDisplayedMonths=function(F){var G=[];var I=F.getMonth();var J=w.call(this);if(J>1){for(var i=0;i<J;i++){G.push((I+i)%12);}}else{G.push(I);}return G;};
q.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=e.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new e(F,S);var G=F.getMonth();var I=e.fromLocalJSDate(i[i.length-1].getDate(),P);I.setDate(a._daysInMonth(I));I=new e(I,S);var J=I.getMonth();return{start:G,end:J};};
q.prototype._closePickers=function(){this.setProperty("_currentPicker",r.MONTH);this._togglePrevNext(this._getFocusedDate(),true);};
q.prototype._setDisabledMonths=function(i,F){var G=0;var I=11;if(i===this._oMinDate.getYear()){G=this._oMinDate.getMonth();}if(i===this._oMaxDate.getYear()){I=this._oMaxDate.getMonth();}if(!F){F=this._getMonthPicker();}F.setMinMax(G,I);};
q.prototype._handleFocus=function(i){var F=e.fromLocalJSDate(i.getParameter("date"),this.getPrimaryCalendarType()),O=i.getParameter("otherMonth"),G=i.getParameter("restoreOldDate");if(this.getIntervalSelection()){this.getAggregation("month").forEach(function(I){I.setProperty("_focusedDate",F);});}if(G){if(!m(this._getFocusedDate(),F)){this._renderMonth(false,true);}}else{this._focusDate(F,O,false,true);}};
q.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};
q.prototype._renderMonth=function(S,N){var F=this._getFocusedDate(),G=this.getAggregation("month"),I,J,O=t.call(this,new e(F,this.getPrimaryCalendarType())),i=0,P=G[0].checkDateFocusable(F.toLocalJSDate()),Q=!N&&!P;for(i=0;i<G.length;i++){I=G[i];J=new e(O,this.getPrimaryCalendarType());J.setMonth(O.getMonth()+i);if(!S&&a._isSameMonthAndYear(J,F)){I.setDate(F.toLocalJSDate());}else{I.displayDate(J.toLocalJSDate());}}this._updateHeader(O);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(Q){this.fireStartDateChange();}};
q.prototype._updateMonthButtonVisibility=function(){var i=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?i.setVisibleButton1(!i.getVisibleButton1()):i._setVisibleButton3(!i._getVisibleButton3());}else{i.setVisibleButton1(false);}return this;};
q.prototype._showMonthPicker=function(S){var i=this._getFocusedDate(),F=this._getMonthPicker(),G=new e(this._getFocusedDate());this._updateActiveHeaderYearButtonVisibility();this._updateMonthButtonVisibility();this.setProperty("_currentPicker",r.MONTH_PICKER);if(this._bActionTriggeredFromSecondHeader){G.setDate(1);G.setMonth(G.getMonth()+1);F._setYear(G.getYear());}else{F._setYear(i.getYear());}if(!S&&this._bActionTriggeredFromSecondHeader){F.setMonth(G.getMonth());this._setDisabledMonths(G.getYear(),F);}else if(!S){F.setMonth(i.getMonth());this._setDisabledMonths(i.getYear(),F);}this._togglePrevNext(i,true);this._setHeaderText(this._getFocusedDate());};
q.prototype._showYearPicker=function(){var i=this._getFocusedDate(),F=this._getYearPicker();this.setProperty("_currentPicker",r.YEAR_PICKER);F.setDate(i.toLocalJSDate());this._togglePrevNexYearPicker();if(this._isTwoMonthsInOneColumn()){this._updateActiveHeaderYearButtonVisibility();}else{this._updateActiveHeaderYearButtonVisibility();}if(this._bActionTriggeredFromSecondHeader&&this.getAggregation("month")[1].getDate().getFullYear()>this._getFocusedDate().getYear()){var S=i.toLocalJSDate();S.setFullYear(S.getFullYear()+1);F.setDate(S);this._updateHeadersYearPrimaryText(this._getYearString());}else{F.setDate(i.toLocalJSDate());this._updateHeadersYearPrimaryText(this._getYearString());}};
q.prototype._focusDate=function(F,O,N,G){var I,J=false,P=false,Q=this.getAggregation("month"),i;if(F.isBefore(this._oMinDate)){I=this._oMinDate;J=true;}else if(F.isAfter(this._oMaxDate)){I=this._oMaxDate;J=true;}else{I=F;}if(this._focusDateExtend){P=this._focusDateExtend(F,O,N);}this._setFocusedDate(I);if(G&&!this._focusDateExtend){for(i=0;i<Q.length;++i){if(Q[i].checkDateFocusable(I.toLocalJSDate())){Q[i].setDate(I.toLocalJSDate());Q[i]._focusDate(I);return;}}}if(J||O){this._renderMonth(false,N);this._addMonthFocusDelegate();}if(P){this.fireStartDateChange();}};
q.prototype._setHeaderText=function(i){var F=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var G=this._getLocaleData();var I=[];var J=[];var N=[];var O=[];var P;var Q=false;var T;var V;var W;var X;var Z;var $=this.getPrimaryCalendarType();var a1=this._getSecondaryCalendarType();var b1="";if(this._bLongMonth||!this._bNamesLengthChecked){I=G.getMonthsStandAlone("wide",$);}else{Q=true;I=G.getMonthsStandAlone("abbreviated",$);J=G.getMonthsStandAlone("wide",$);}if(a1){N=G.getMonthsStandAlone("abbreviated",a1);O=G.getMonthsStandAlone("wide",a1);var c1=this._getDisplayedSecondaryMonths($,a1);if(c1.start==c1.end){W=N[c1.start];b1=O[c1.start];}else{Z=G.getIntervalPattern();W=Z.replace(/\{0\}/,N[c1.start]).replace(/\{1\}/,N[c1.end]);b1=Z.replace(/\{0\}/,O[c1.start]).replace(/\{1\}/,O[c1.end]);}}F.setAdditionalTextButton1(W);F._setAdditionalTextButton3(W);S.setAdditionalTextButton1(W);var d1=this._getDisplayedMonths(i);this._sFirstMonthName=T=I[d1[0]];V=I[d1[d1.length-1]];if(d1.length>1&&!this._bShowOneMonth){if(!Z){Z=G.getIntervalPattern();}W=Z.replace(/\{0\}/,T).replace(/\{1\}/,V);P=J.length?Z.replace(/\{0\}/,J[d1[0]]).replace(/\{1\}/,J[d1[d1.length-1]]):W;if(this._isTwoMonthsInTwoColumns()||this._isTwoMonthsInOneColumn()){W=T;}}else{W=T;P=J[d1[0]]||W;}if(!this._getSucessorsPickerPopup()&&b1){P+=", "+b1;}F.setTextButton1(W);F.setAriaLabelButton1(P);F._setTextButton3(V);F._setAriaLabelButton3(V);S.setTextButton1(V);S.setAriaLabelButton1(V);var e1=new e(i,$);e1.setDate(1);X=this._oYearFormat.format(e1.toUTCJSDate(),true);if(e1.getMonth()===11){this._updateHeadersYearPrimaryText(X,(parseInt(X)+1).toString());}else{this._updateHeadersYearPrimaryText(X,X);}if(a1){e1=new e(e1,a1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(e1.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:W,sYear:X,sAriaLabel:P,bShort:Q};};
q.prototype._handleButton1=function(i){if(this._iMode!=1){this._saveTriggeredHeader(i);this._showMonthPicker();}else{this.setProperty("_currentPicker",r.MONTH);this._addMonthFocusDelegate();}};
q.prototype._addMonthFocusDelegate=function(){var F=this.getAggregation("month"),G=F[0].getDate(),I=this._getFocusedDate(),J={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(J);}},N,O;if(F.length>1&&N){G=e.fromLocalJSDate(N,this.getPrimaryCalendarType());}else if(F.length>1){G=t.call(this,this._getFocusedDate());}else{G=I;}for(var i=0;i<F.length;i++){N=new e(G);if(i>0){N.setMonth(N.getMonth()+i,1);}if(I.getYear()===N.getYear()&&I.getMonth()===N.getMonth()){O=this.getAggregation("month")[i];O.addDelegate(J,O);}}};
q.prototype._handleButton2=function(i){if(this._iMode<=1){this._saveTriggeredHeader(i);this._showYearPicker();}else{this._showYearRangePicker();}};
q.prototype._selectMonth=function(){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this._getMonthPicker(),G=i.getProperty("_focusedMonth"),I=(G||G===0)?G:i.getMonth(),S=i._iYear?new e(i._iYear,I-1,1):new e(this._getFocusedDate().getYear(),I-1,1);if(w.call(this)>1){if(this._bActionTriggeredFromSecondHeader&&S.getYear()>=a._minDate().getYear()){F.setYear(S.getYear());I=S.getMonth();}else if(F.getYear()===a._maxDate().getYear()&&I===11){I-=1;}}F.setMonth(I);if(I!=F.getMonth()){F.setDate(0);}this._focusDate(F,true,false,false);this._closePickers();this._addMonthFocusDelegate();};
q.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};
q.prototype._selectYear=function(){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType()),i=F.getMonth(),G=this._getYearPicker(),I=e.fromLocalJSDate(G.getDate(),this.getPrimaryCalendarType());if(!this._bActionTriggeredFromSecondHeader){I.setMonth(i,F.getDate());}else{I.setYear(i===11?I.getYear()-1:I.getYear());I.setMonth(i,F.getDate());}F=I;this._focusDate(F,true,false,false);this._togglePrevNext(this._getFocusedDate(),true);this.setProperty("_currentPicker",r.MONTH);this._addMonthFocusDelegate();this._setHeaderText(this._getFocusedDate());};
q.prototype.setProperty=function(){var P=arguments[0],i=arguments[1];C.prototype.setProperty.apply(this,arguments);if(P==="_currentPicker"){switch(i){case"month":this._iMode=0;break;case"monthPicker":this._iMode=1;break;case"yearPicker":this._iMode=2;break;case"yearRangePicker":this._iMode=3;break;default:return;}}return this;};
q.prototype._selectYearRange=function(){var i=this.getAggregation("yearRangePicker"),F=this.getAggregation("header"),G=i.getRangeSize(),P=this.getPrimaryCalendarType(),S=e.fromLocalJSDate(i.getDate(),P),I=new e(S.getYear()+G-1,0,1,P),J=this._getFocusedDate(),N,O;J.setYear(S.getYear()+G/2);S.setMonth(0,1);this._setFocusedDate(J);this._showYearPicker();N=this._oYearFormat.format(U.getInstance(S.toUTCJSDate(),S.getCalendarType()),true);O=this._oYearFormat.format(U.getInstance(I.toUTCJSDate(),I.getCalendarType()),true);F.setTextButton2(N+" - "+O);F._setTextButton4(N+" - "+O);};
q.prototype._showYearRangePicker=function(){var i=this.getAggregation("yearRangePicker"),F=this._getYearPicker(),G=e.fromLocalJSDate(F.getFirstRenderedDate(),this.getPrimaryCalendarType());this.setProperty("_currentPicker",r.YEAR_RANGE_PICKER);G.setYear(G.getYear()+Math.floor(i.getRangeSize()/2));i.setDate(G.toLocalJSDate());this._togglePrevNexYearPicker();};
q.prototype._setColumns=function(i){this._iColumns=i;return this;};
q.prototype._getColumns=function(){return this._iColumns;};
q.prototype._updateActiveHeaderYearButtonVisibility=function(){var i=this._getActiveHeaderAggregation();if(this._bActionTriggeredFromSecondHeader){this._isTwoMonthsInOneColumn()?i.setVisibleButton1(!i.getVisibleButton1()):i._setVisibleButton3(!i._getVisibleButton3());}else{i.setVisibleButton1(!i.getVisibleButton1());}return this;};
q.prototype._updateHeadersButtonsHelper=function(i,F,G,I){var J=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");J.setVisibleButton1(i);J.setVisibleButton2(F);J._setVisibleButton3(G);J._setVisibleButton4(I);if(S.getVisible()){S.setVisibleButton1(i);S.setVisibleButton2(F);S._setVisibleButton3(G);S._setVisibleButton4(I);}};
q.prototype._updateHeadersButtons=function(){var S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);if(this._iMode===2){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else if(this._iMode===1){this._bActionTriggeredFromSecondHeader?this._updateHeadersButtonsHelper(true,true,false,true):this._updateHeadersButtonsHelper(false,true,true,true);}else{this._updateHeadersButtonsHelper(true,true,true,true);}}else{S.setVisible(false);if(this._iMode===1){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===2){this._updateHeadersButtonsHelper(false,true,false,false);}else if(this._iMode===3){this._updateHeadersButtonsHelper(false,false,false,false);}else{this._updateHeadersButtonsHelper(true,true,false,false);}}if(this._getSucessorsPickerPopup()){this.getAggregation("header").setVisibleButton2(false);}};
q.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};
q.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(o.getConfiguration().getLocale().getLanguage().toLowerCase()==="ja"||o.getConfiguration().getLocale().getLanguage().toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}};
q.prototype._isTwoMonthsInOneColumn=function(){var i=w.call(this);return this._getColumns()===1&&i===2;};
q.prototype._isTwoMonthsInTwoColumns=function(){var i=w.call(this);return this._getColumns()===2&&i===2;};
q.prototype._updateHeadersYearPrimaryText=function(F,S){var i=this._getYearPicker(),G=this.getAggregation("header"),I=this.getAggregation("secondMonthHeader"),J=F,N=S||F,P=this.getPrimaryCalendarType();if(this._iMode===2&&i){var O=i.getProperty("_middleDate")?i.getProperty("_middleDate"):i._getDate(),Q=new e(O,P),T,V,W;Q.setDate(1);Q.setYear(Q.getYear()-Math.floor(i.getYears()/2));Q=i._checkFirstDate(Q);T=new e(Q,P);T.setYear(T.getYear()+i.getYears()-1);V=this._oYearFormat.format(U.getInstance(Q.toUTCJSDate(),Q.getCalendarType()),true);W=this._oYearFormat.format(U.getInstance(T.toUTCJSDate(),T.getCalendarType()),true);if(this._bActionTriggeredFromSecondHeader){N=V+" - "+W;}else{J=V+" - "+W;}}G._setTextButton4(N);G._setAriaLabelButton4(N);I.setTextButton2(N);G.setTextButton2(J);};
q.prototype._updateHeadersYearAdditionalText=function(i){var F=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");F.setAdditionalTextButton2(i);F._setAdditionalTextButton4(i);S.setAdditionalTextButton2(i);};
q.prototype._adjustYearRangeDisplay=function(){var i=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case p.Japanese:i.setColumns(1);i.setYears(4);break;case p.Gregorian:i.setColumns(3);i.setYears(9);break;default:i.setColumns(2);i.setYears(8);}}};
q.prototype._getSpecialDates=function(){var P=this.getParent();if(this._oSpecialDatesControlOrigin){return this._oSpecialDatesControlOrigin._getSpecialDates();}if(P&&P._getSpecialDates){return P._getSpecialDates();}else{var F=this.getSpecialDates();for(var i=0;i<F.length;i++){var N=F[i].getSecondaryType()===l.CalendarDayType.NonWorking&&F[i].getType()!==l.CalendarDayType.NonWorking;if(N){var G=new b();G.setType(F[i].getSecondaryType());G.setStartDate(F[i].getStartDate());if(F[i].getEndDate()){G.setEndDate(F[i].getEndDate());}F.push(G);}}return F;}};
function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=e.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=e.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new e(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new e(this._oMaxDate,i);}}
function s(F){var W=F.size.width;if(W<=0){return;}if(W===this._iPrevWidth){return;}this._iPrevWidth=W;var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var G=w.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(G<this._getColumns()){this._setColumns(G);}if(this._getColumns()>2&&G>this._getColumns()){var I=this._getColumns();var J=0.0;var N=this._getColumns();while(I>=2){var P=G%I;if(P==0){N=I;break;}else{var Q=P/I;if(Q>J){J=Q;N=I;}}I--;}this._setColumns(N);}var S;var T=this.getAggregation("month");if(this._getColumns()>1){S=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{S="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<T.length;i++){var V=T[i];V.setWidth(S);}this.invalidate();}this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}
function t(i){var F=new e(i,this.getPrimaryCalendarType());F.setDate(1);var G=w.call(this);if(G<=12){var I=i.getMonth();if(12%G>0&&I+G>11){I=12-G;}F.setMonth(I);}return F;}
function u(){var i,F,G;if(!this._bNamesLengthChecked){i=this._getMonthPicker();this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;this.setProperty("_currentPicker",r.MONTH);if(!this._bLongMonth){F=this.getAggregation("month");G;if(F.length>1){G=e.fromLocalJSDate(F[0].getDate(),this.getPrimaryCalendarType());}else{G=this._getFocusedDate();}this._setHeaderText(G);this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}}
function v(i,S){var F,G;if(!i){return;}F=e.fromLocalJSDate(i,this.getPrimaryCalendarType());G=F.getYear();a._checkYearInValidRange(G);if(a._isOutside(F,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(F);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,true);}}
function w(){if(f.system.phone){return 1;}else{return this.getMonths();}}
function x(i){this.fireEvent("_renderMonth",{days:i.getParameter("days")});}
function y(i){this._oSelectedMonth=i.oSource;this.fireSelect();}
function z(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._bindMousemove();}}}}
function A(F){var G,I,i;if(w.call(this)>1){G=this.getAggregation("month");for(i=0;i<G.length;i++){I=G[i];if(I.getId()!=F.oSource.getId()){I._unbindMousemove();}}}}
function B(i){var O=i.getParameter("offset");if(O>0){this._handleNext(i);}if(O<0){this._handlePrevious(i);}}
function E(){this._updateHeadersYearPrimaryText(this._getYearString());}
return q;});
sap.ui.predefine('sap/ui/unified/CalendarAppointment',['./DateTypeRange','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/LocaleData','./library',"sap/base/Log"],function(D,a,N,L,l,b){"use strict";
var C=D.extend("sap.ui.unified.CalendarAppointment",{metadata:{library:"sap.ui.unified",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},description:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},tentative:{type:"boolean",group:"Data",defaultValue:false},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}},aggregations:{customContent:{type:"sap.ui.core.Control",multiple:true}}}});
C.prototype.init=function(){this._sAppointmentPartSuffix=null;};
C.prototype.applyFocusInfo=function(f){var p=this.getParent();if(p){p.applyFocusInfo(f);}return this;};
C.prototype._getDateRangeIntersectionText=function(c){var s=this.getStartDate(),e=this.getEndDate()?this.getEndDate():new Date(864000000000000),f,S,o=new Date(c.getFullYear(),c.getMonth(),c.getDate(),0,0,0),n=new Date(o.getFullYear(),o.getMonth(),o.getDate()+1),t=a.getTimeInstance({pattern:"HH:mm"}),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),h=N.getUnitInstance({allowedUnits:["duration-hour"]},sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),m=N.getUnitInstance({allowedUnits:["duration-minute"]},sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),H,M,d,g;if(s.getTime()>=n.getTime()||e.getTime()<=o.getTime()){f="";}else if(s.getTime()<=o.getTime()&&e.getTime()>=n.getTime()){f=r.getText("PLANNINGCALENDAR_ALLDAY");}else if(s.getTime()<o.getTime()){f=r.getText("PLANNINGCALENDAR_UNTIL");S=t.format(e);}else if(e.getTime()>n.getTime()){f=r.getText("PLANNINGCALENDAR_FROM");S=t.format(s);}else{f=t.format(s);if(e.getTime()-s.getTime()<3600000){M=(e.getTime()-s.getTime())/60000;S=m.format(M,"duration-minute");}else if(((e.getTime()-s.getTime())%3600000)===0){H=(e.getTime()-s.getTime())/3600000;S=h.format(H,"duration-hour");}else{H=Math.floor((e.getTime()-s.getTime())/3600000);d=h.format(H,"duration-hour");M=(e.getTime()-s.getTime())/60000%60;g=m.format(M,"duration-minute");S=r.getText("PLANNINGCALENDAR_APP_DURATION",[d,g]);}}return{start:f,end:S};};
C._getComparer=function(d){var O=24*60*60*1000,c=new Date(d.getFullYear(),d.getMonth(),d.getDate(),0,0,0).getTime(),n=c+O;return function(A,o){var s=A.appointment.getStartDate().getTime(),S=o.appointment.getStartDate().getTime(),e=A.appointment.getEndDate()?A.appointment.getEndDate().getTime():864000000000000,E=o.appointment.getEndDate()?o.appointment.getEndDate().getTime():864000000000000,w=s<=c&&e>=n,W=S<=c&&E>=n,r;if((w&&W)||(!w&&!W)){r=s-S;if(r===0){r=E-e;}}else if(w){r=-1;}else{r=1;}return r;};};
C.prototype.setColor=function(c){if(c&&!c.match(/^#[0-9a-f]{6}$/i)){b.warning("setColor accepts only full hex color value with pound symbol, but value is '"+c+"'");}return this.setProperty("color",c);};
C.prototype._getCSSColorForBackground=function(h){return"rgba("+[parseInt(h.substr(1,2),16),parseInt(h.substr(3,2),16),parseInt(h.substr(5,2),16)].join(",")+", 0.2)";};
C.prototype._setAppointmentPartSuffix=function(s){this._sAppointmentPartSuffix=s;return this;};
C.prototype.getDomRef=function(s){if(document.getElementById(this.getId())){return document.getElementById(s?this.getId()+"-"+s:this.getId());}else if(this._sAppointmentPartSuffix){return document.getElementById(s?this.getId()+"-"+this._sAppointmentPartSuffix+"-"+s:this.getId()+"-"+this._sAppointmentPartSuffix);}var A=document.querySelectorAll(".sapUiCalendarRowApps[id^='"+this.getId()+"']");return A.length>0?A[0]:null;};
return C;});
sap.ui.predefine('sap/ui/unified/CalendarDateInterval',['./calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','./calendar/YearRangePicker','./calendar/CalendarDate','./library','sap/ui/Device',"./CalendarDateIntervalRenderer","sap/base/util/deepEqual","sap/m/Popover","sap/ui/core/Core","sap/base/Log","sap/ui/thirdparty/jquery","./DateRange"],function(C,a,D,M,Y,b,c,l,d,e,f,P,g,L,q,h){"use strict";var j=sap.ui.core.CalendarType;
var k=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},designtime:"sap/ui/unified/designtime/CalendarDateInterval.designtime"}});
k.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};
k.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._bPoupupMode=this.getPickerPopup();if(this._getSucessorsPickerPopup()){this.setProperty("_currentPicker","month");}};
k.prototype._selectYearRange=function(){a.prototype._selectYearRange.apply(this,arguments);this.getAggregation("month")[0].setStartDate(this._getFocusedDate().toLocalJSDate());};
k.prototype.exit=function(){a.prototype.exit.apply(this,arguments);if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null;}};
k.prototype._initializeMonthPicker=function(){var o=this._createMonthPicker();o._bCalendar=true;this.setAggregation("monthPicker",o);o._setSelectedDatesControlOrigin(this);};
k.prototype._initializeYearPicker=function(){var y=this._createYearPicker();y._bCalendar=true;this.setAggregation("yearPicker",y);y._setSelectedDatesControlOrigin(this);};
k.prototype._initializeYearRangePicker=function(){this.setAggregation("yearRangePicker",this._createYearRangePicker());};
k.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p);var H=this.getAggregation("header"),o,y;if(p){if(this._getMonthPicker()){this._getMonthPicker().destroy();}if(this._getYearPicker()){this._getYearPicker().destroy();}H.setVisibleButton2(false);H.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker());}o=this._getMonthPicker();y=this._getYearPicker();o.setColumns(0);o.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());H.setVisibleButton2(true);H.detachEvent("pressButton2",this._handleButton2,this);H.attachEvent("pressButton2",this._handleButton2,this);}return this;};
k.prototype._createMonthPicker=function(){var o=new M(this.getId()+"--MP");o.attachEvent("select",this._selectMonth,this);o._bNoThemeChange=true;o.setColumns(0);o.setMonths(3);o.attachEvent("pageChange",_,this);return o;};
k.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",m,this);return y;};
k.prototype._createYearRangePicker=function(){var y=new b(this.getId()+"--YRP");y.attachEvent("select",this._selectYearRange,this);y.setPrimaryCalendarType(this.getPrimaryCalendarType());y.setYears(6);y.setRangeSize(this._getYearPicker().getYears());return y;};
k.prototype._adjustYearRangeDisplay=function(){var y=this.getAggregation("yearRangePicker");if(!this._getSucessorsPickerPopup()){switch(this.getPrimaryCalendarType()){case j.Gregorian:y.setColumns(3);y.setYears(3);break;default:y.setColumns(2);y.setYears(2);}}else{a.prototype._adjustYearRangeDisplay.call(this,arguments);}};
k.prototype._getCalendar=function(){var o;if(!this._oCalendar){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker(true);var i=this.getAggregation("header").getDomRef("B1");if(i){i.focus();}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus();}};o.addDelegate(this._oFocusCalendarDelegate,o);this._oCalendar=o;}return this._oCalendar;};
k.prototype._setAriaRole=function(r){var o=this.getAggregation("month")[0];o._setAriaRole(r);o.invalidate();return this;};
k.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();this._showOverlay();}else{this._showMonthPicker();}};
k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
k.prototype._setHeaderText=function(o){var t;if(this.getStartDate()){t=a.prototype._setHeaderText.apply(this,[c.fromLocalJSDate(this.getStartDate(),this.getPrimaryCalendarType())]);}else{t=a.prototype._setHeaderText.apply(this,arguments);}var T,A=t.sAriaLabel,H=this.getAggregation("header");var i=this._getLocaleData();var E=c.fromLocalJSDate(new Date(o.toLocalJSDate().getTime()+(this._getDays()-1)*24*60*60*1000),this.getPrimaryCalendarType());E.setDate(1);var s=i.getIntervalPattern().replace("{0}","").replace("{1}","");var n=this._oYearFormat.format(E.toUTCJSDate(),true);var p=t.sMonth;if(this.getPickerPopup()){if(i.oLocale.sLanguage.toLowerCase()==="ja"||i.oLocale.sLanguage.toLowerCase()==="zh"){if(n!=t.sYear){p=p.replace(s,s+n+" ");A=A.replace(s,s+n+" ");}T=t.sYear+" "+p;A=t.sYear+" "+A;}else{if(n!=t.sYear){p=p.replace(s," "+t.sYear+s);A=A.replace(s," "+t.sYear+s);}T=p+" "+n;A=A+" "+n;}H.setTextButton1(T,true);H.setAriaLabelButton1(A);}};
k.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendar(),S=new h(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);};
k.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendar(),s=o.getSelectedDates()[0].getStartDate(),n=c.fromLocalJSDate(s);this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};
k.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}if(!s){this._renderMonth();var n=this.getAggregation("month");for(var i=0;i<n.length;i++){var o=n[i];o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()].setAttribute("tabindex","0");}}this._getCalendar()._closePickers();};
k.prototype._getDaysLarge=function(){return 10;};
k.prototype._createMonth=function(i){var o=new D(i);o._bCalendar=true;return o;};
k.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(f(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=c.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var i=this.getMinDate();if(i&&s.getTime()<i.getTime()){L.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(i.getTime());}var n=this.getMaxDate();if(n&&s.getTime()>n.getTime()){L.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(n.getTime());}this.setProperty("startDate",s,true);o=c.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var p=this.getAggregation("month")[0];p.setStartDate(s);this._updateHeader(o);var r=this._getFocusedDate(true).toLocalJSDate();if(!p.checkDateFocusable(r)){this._setFocusedDate(o);p.displayDate(s);}return this;};
k.prototype.getStartDate=function(){return this.getProperty("startDate");};
k.prototype.setDays=function(i){var y=this.getAggregation("yearRangePicker");this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var n=this._getMonthPicker();var p=Math.ceil(i/3);if(p>12){p=12;}n.setMonths(p);var r=this._getYearPicker();var s=Math.floor(i/2);if(s>20){s=20;}r.setYears(s);y.setRangeSize(s);}var S=this._getStartDate();this._updateHeader(S);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
k.prototype._getDays=function(){var i=this.getDays();if(d.system.phone&&i>8){return 8;}else{return i;}};
k.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};
k.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};
k.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=c.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};
k.prototype.setMonths=function(i){if(i==1){return this.setProperty("months",i,false);}else{throw new Error("Property months not supported "+this);}};
k.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
k.prototype.focusDate=function(o){var i=this.getAggregation("month")[0];if(!i.checkDateFocusable(o)){this._focusDateExtend(c.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};
k.prototype._focusOnShiftTab=function(){var H=this.getAggregation("header");if(this.getPickerPopup()&&H.getDomRef("B1")){H.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&H.getDomRef("B2")){H.getDomRef("B2").focus();}};
k.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closePickers();}this._updateHeadersButtons();this._setHeaderText(this._getFocusedDate());};
k.prototype._focusDateExtend=function(o,O,n){if(O){var i=this._getFocusedDate(),p=this._getStartDate(),r=C._daysBetween(i,p),N=new c(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-r);this._setStartDate(N,false,true);if(!n){return true;}}return false;};
k.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){L.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new c(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new c(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){L.warning("end date > maxDate -> start date will be changed",this);var s=new c(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};
k.prototype._updateHeader=function(o){this._setHeaderText(o);switch(this._iMode){case 0:this._togglePrevNext(o,true);break;case 1:this._togglePrevNext(o);break;case 2:case 3:this._togglePrevNexYearPicker();break;}};
k.prototype._togglePrevNext=function(o,i){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var n=this._oMinDate.getYear();var p=this._oMaxDate.getMonth();var r=this._oMinDate.getMonth();var s=this._oMinDate.getDate();var t=this._oMaxDate.getDate();var H=this.getAggregation("header");var u=this._getDays();var v;var S;var E;var w;var x;if(this._iMode==1&&!i){var z=this._getMonthPicker();var A=z.getMonths();var B=z.getProperty("_firstMonth");var F=B+A-1;v=o.getYear();if(B==0||(v==n&&B<=r)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(F>10||(v==y&&F>=p)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}S=this._getStartDate();E=new c(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+u-1);if(C._isOutside(o,S,E)){S=new c(o,this.getPrimaryCalendarType());E=new c(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+u-1);}v=S.getYear();w=S.getMonth();x=S.getDate();if(v<n||(v==n&&(!i||w<r||(w==r&&x<=s)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}v=E.getYear();w=E.getMonth();x=E.getDate();if(v>y||(v==y&&(!i||w>p||(w==p&&x>=t)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};
k.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};
k.prototype._handlePrevious=function(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),o,s,i;switch(this._iMode){case 0:s=new c(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,(i*-1));this._addMonthFocusDelegate();break;case 1:if(!this.getPickerPopup()){o=this._getMonthPicker();if(o.getMonths()<12){o.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var n=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(n){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){this._getYearPicker().previousPage();m.call(this);}break;case 3:if(!this.getPickerPopup()){this.getAggregation("yearRangePicker").previousPage();m.call(this);}break;}};
k.prototype._handleNext=function(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),o,s,i;switch(this._iMode){case 0:s=new c(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,F,i);this._addMonthFocusDelegate();break;case 1:if(!this.getPickerPopup()){o=this._getMonthPicker();if(o.getMonths()<12){o.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var n=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(n){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){this._getYearPicker().nextPage();m.call(this);}break;case 3:if(!this.getPickerPopup()){this.getAggregation("yearRangePicker").nextPage();m.call(this);}break;}};
k.prototype._getDisplayedMonths=function(o){var i=[];var n=o.getMonth();var p=this._getDays();i.push(n);if(p>this._getDaysLarge()){var E=new c(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+p-1);var r=E.getMonth();while(n!=r){n=(n+1)%12;i.push(n);}}return i;};
k.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new c(this._getStartDate(),s);var n=S.getMonth();var E=new c(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new c(E,s);var o=E.getMonth();return{start:n,end:o};};
k.prototype._openPickerPopup=function(p){if(!this._oPopup){var o=new P({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});o.oPopup.setDurations(0,0);o.addEventDelegate({onsapescape:function(E){this._oCalendar.onsapescape(E);this._hideOverlay();}},this);this._oPopup=o;}this._oPopup.addContent(p);this._oPopup.attachAfterClose(function(){this._closeCalendarPicker(true);this._hideOverlay();},this);this._oPopup.attachAfterOpen(function(){var B=H.$("B1");var $=this._oPopup.$();var O=Math.floor(($.width()-B.width())/2);this._oPopup.setOffsetX(g.getConfiguration().getRTL()?O:-O);var i=B.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?i:-i);},this);var H=this.getAggregation("header");this._oPopup.openBy(H.getDomRef("B1"));};
k.prototype._getMaxDateAlignedToMinDate=function(o,i){var n=new c(o,this.getPrimaryCalendarType());if(n.isBefore(i)){n=new c(i);n.setDate(n.getDate()+this._getDays()-1);}return n;};
k.prototype._getStartDateAlignedToMinAndMaxDate=function(o,i,s){var n=new c(s,this.getPrimaryCalendarType());if(n.isBefore(i)){n=new c(i,this.getPrimaryCalendarType());}else if(n.isAfter(o)){n=o;}return n;};
k.prototype._calculateStartDate=function(o,i,s){var n=new c(o,this.getPrimaryCalendarType());n.setDate(n.getDate()-this._getDays()+1);n=this._getMaxDateAlignedToMinDate(n,i);s=this._getStartDateAlignedToMinAndMaxDate(n,i,s);return s;};
k.prototype._setStartDate=function(s,S,n){s=this._calculateStartDate(this._oMaxDate,this._oMinDate,s);var o=s.toLocalJSDate();this.setProperty("startDate",o,true);this._oStartDate=s;var i=this.getAggregation("month")[0];i.setStartDate(o);this._updateHeader(s);if(S){var p=this._getFocusedDate().toLocalJSDate();if(!i.checkDateFocusable(p)){this._setFocusedDate(s);i.setDate(o);}else{i.setDate(p);}}if(!n){this.fireStartDateChange();}};
k.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};
function _(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}
function m(E){this._togglePrevNexYearPicker();this._updateHeadersYearPrimaryText(this._getYearString());}
return k;});
sap.ui.predefine('sap/ui/unified/CalendarDateIntervalRenderer',['sap/ui/core/Renderer','./CalendarRenderer'],function(R,C){"use strict";var a=R.extend(C);a.apiVersion=2;
a.renderCalContentOverlay=function(){};
a.renderCalContentAndArrowsOverlay=function(r,c,i){if(c.getPickerPopup()){r.openStart("div",i+"-contentOver");r.class("sapUiCalContentOver");if(!c._oPopup||!c._oPopup.isOpen()){r.style("display","none");}r.openEnd();r.close("div");}};
a.addAttributes=function(r,c){r.class("sapUiCalInt");r.class("sapUiCalDateInt");var d=c._getDays();if(d>c._getDaysLarge()){r.class("sapUiCalIntLarge");}if(d>c._iDaysMonthHead){r.class("sapUiCalIntHead");}if(c.getShowDayNamesLine()){r.class("sapUiCalWithDayNamesLine");}if(c.getShowWeekNumbers()){r.class("sapUiCalWithWeekNumbers");}};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegend',['sap/ui/core/Control','./library','sap/ui/Device','./CalendarLegendRenderer',"sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarLegendItem"],function(C,l,D,a,L,q,b){"use strict";var c=l.CalendarDayType;var S=l.StandardCalendarLegendItem;
var d=C.extend("sap.ui.unified.CalendarLegend",{
metadata:{library:"sap.ui.unified",properties:{standardItems:{type:"string[]",group:"Misc",defaultValue:['Today','Selected','WorkingDay','NonWorkingDay']},columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'120px'}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},_standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarLegend.designtime"},
constructor:function(i,s){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){s=i;}if(!s||(s&&!s.standardItems)){this._addStandardItems(this.getStandardItems());}this._bShouldRenderStandardItems=true;}
});
d.prototype.setStandardItems=function(v){var i;if(v&&v.length===1&&v[0]===""){v=[];}if(v&&v.length){v=this.validateProperty("standardItems",v);for(i=0;i<v.length;i++){if(!S[v[i]]){throw new Error("Invalid value '"+v[i]+"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.");}}}this.setProperty("standardItems",v);this._addStandardItems(this.getStandardItems(),true);return this;};
d.prototype._addStandardItems=function(s,r){var i,e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),I=this.getId();if(r){this.destroyAggregation("_standardItems");}for(i=0;i<s.length;i++){var o=new b(I+"-"+s[i],{text:e.getText(d._Standard_Items_TextKeys[s[i]])});this.addAggregation("_standardItems",o);}};
d._Standard_Items_TextKeys={"Today":"LEGEND_TODAY","Selected":"LEGEND_SELECTED","WorkingDay":"LEGEND_NORMAL_DAY","NonWorkingDay":"LEGEND_NON_WORKING_DAY"};
d.prototype._getItemType=function(i,I){var t=i.getType(),n,f;if(t&&t!==c.None){return t;}f=this._getUnusedItemTypes(I);n=I.filter(function(e){return!e.getType()||e.getType()===c.None;}).indexOf(i);if(n<0){L.error('Legend item is not in the legend',this);return t;}if(f[n]){t=f[n];}else{t="Type"+(Object.keys(c).length+n-f.length-1);}return t;};
d.prototype._getItemByType=function(t){var I,e=this.getItems(),i;for(i=0;i<e.length;i++){if(this._getItemType(e[i],e)===t){I=e[i];break;}}return I;};
d.prototype._getUnusedItemTypes=function(I){var f=q.extend({},c),t,i;delete f[c.None];delete f[c.NonWorking];for(i=0;i<I.length;i++){t=I[i].getType();if(f[t]){delete f[t];}}return Object.keys(f);};
return d;});
sap.ui.predefine('sap/ui/unified/CalendarLegendItem',['sap/ui/core/Element','./library'],function(E,l){"use strict";var C=l.CalendarDayType;
var a=E.extend("sap.ui.unified.CalendarLegendItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/ui/unified/CalendarLegendRenderer',['sap/ui/core/InvisibleText'],function(I){"use strict";var C={apiVersion:2};
C.render=function(r,l){var s=l.getAggregation("_standardItems"),c=l.getItems(),a=this.defineItemsLength(l,c.length),i,b,d;r.openStart("div",l);r.class("sapUiUnifiedLegend");r.openEnd();this.renderItemsHeader(r,l);if(s||c){r.openStart("div");r.class("sapUiUnifiedLegendItems");d=l.getColumnWidth();r.style("column-width",d);r.style("-moz-column-width",d);r.style("-webkit-column-width",d);r.openEnd();if(s){b=l.getId().length+1;for(i=0;i<s.length;++i){var e="sapUiUnifiedLegend"+s[i].getId().slice(b);this.renderLegendItem(r,e,s[i],["sapUiUnifiedLegendSquareColor"]);}}if(c){for(i=0;i<a;i++){this.renderLegendItem(r,"sapUiCalLegDayType"+l._getItemType(c[i],c).slice(4),c[i],["sapUiUnifiedLegendSquareColor"]);}}this.renderAdditionalItems(r,l);r.close("div");}this.renderAdditionalContent(r,l);r.close("div");};
C.renderLegendItem=function(r,c,i,a){var t=i.getText();var T=i.getTooltip_AsString();r.openStart("div",i);if(T){r.attr('title',T);}r.class("sapUiUnifiedLegendItem");r.class(c);r.openEnd();r.openStart("div");r.class("sapUiUnifiedLegendSquare");r.openEnd();this.renderColor(r,i.getColor(),a);r.close("div");r.openStart("div",i.getId()+"-Text");r.class("sapUiUnifiedLegendDescription");r.openEnd();r.text(t);r.close("div");r.close("div");};
C.renderItemsHeader=function(r,l){};
C.renderAdditionalContent=function(r,l){};
C.defineItemsLength=function(l,c){return c;};
C.renderAdditionalItems=function(r,l){};
C.renderColor=function(r,c,a){r.openStart("div");for(var i=0;i<a.length;i++){r.class(a[i]);}if(c){r.style("background-color",c);}r.openEnd();r.close("div");};
C.addCalendarTypeAccInfo=function(a,t,l){var T,s;if(l){var L=l._getItemByType(t);if(L){T=L.getText();}}if(T){a["label"]=a["label"]?a["label"]+"; "+T:T;}else{s=C.getTypeAriaText(t);if(s){a["describedby"]=a["describedby"]?a["describedby"]+" "+s.getId():s.getId();}}};
C.typeARIATexts={};
C.getTypeAriaText=function(t){var r,T;if(t.indexOf("Type")!==0){return;}if(!C.typeARIATexts[t]){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");T=r.getText("LEGEND_UNNAMED_TYPE",parseInt(t.slice(4)).toString());C.typeARIATexts[t]=new I({text:T});C.typeARIATexts[t].toStatic();}return C.typeARIATexts[t];};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarMonthInterval',['sap/m/Popover','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Core','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/ui/core/Renderer','sap/ui/core/format/DateFormat','./calendar/CalendarUtils','./calendar/CustomYearPicker','./calendar/Header','./calendar/MonthsRow','./calendar/YearPicker','./calendar/CalendarDate','./CalendarMonthIntervalRenderer',"sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(P,D,C,a,L,b,R,c,d,e,H,M,Y,f,g,h,i,j,q,k){"use strict";
var l=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"monthsRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
var m={MONTHS_ROW:"monthsRow",YEAR_PICKER:"yearPicker"};
l.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=c.getDateInstance({format:"y"});this._oMinDate=d._minDate();this._oMaxDate=d._maxDate();this._initializeHeader();this._initializeMonthsRow();this._initilizeYearPicker();this._iDaysMonthsHead=15;};
l.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}if(this._oCustomYearPicker){this._oCustomYearPicker.removeDelegate(this._oFocusCYPDelegate);this._oCustomYearPicker.destroy();this._oCustomYearPicker=null;}};
l.prototype.onBeforeRendering=function(){var O=this.getAggregation("monthsRow");var Q=this._getFocusedDate();t.call(this);O.displayDate(Q.toLocalJSDate());};
l.prototype._setAriaRole=function(O){var Q=this.getAggregation("monthsRow");Q._setAriaRole(O);Q.invalidate();return this;};
l.prototype._initializeHeader=function(){var O=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});O.attachEvent("pressPrevious",this._handlePrevious,this);O.attachEvent("pressNext",this._handleNext,this);O.attachEvent("pressButton2",z,this);this.setAggregation("header",O);};
l.prototype._initializeMonthsRow=function(){var O=new M(this.getId()+"--MonthsRow");O.attachEvent("focus",E,this);O.attachEvent("select",B,this);O._bNoThemeChange=true;this.setAggregation("monthsRow",O);};
l.prototype._initilizeYearPicker=function(){var O=this._createYearPicker();this.setAggregation("yearPicker",O);O._setSelectedDatesControlOrigin(this);};
l.prototype._createYearPicker=function(){var O=new Y(this.getId()+"--YP",{columns:0,years:6});O.attachEvent("select",G,this);O.attachEvent("pageChange",N,this);O._oMinDate.setYear(this._oMinDate.getYear());O._oMaxDate.setYear(this._oMaxDate.getYear());return O;};
l.prototype._getCalendarPicker=function(){var O;if(!this._oCustomYearPicker){O=new e(this.getId()+"--Cal");O.setPopupMode(true);O.attachEvent("select",F,this);O.attachEvent("cancel",function(Q){this._oPopup.close();var S=this.getAggregation("header").getDomRef("B2");if(S){S.focus();}},this);this._oFocusCYPDelegate={onAfterRendering:function(){this.focus();}};O.addDelegate(this._oFocusCYPDelegate,O);this._oCustomYearPicker=O;}return this._oCustomYearPicker;};
l.prototype.setStartDate=function(S){d._checkJSDateObject(S);if(i(this.getStartDate(),S)){return this;}var O=S.getFullYear();d._checkYearInValidRange(O);this.setProperty("startDate",S,true);this._oStartDate=f.fromLocalJSDate(S);this._oStartDate.setDate(1);var Q=this.getAggregation("monthsRow");Q.setStartDate(S);t.call(this);var T=this._getFocusedDate().toLocalJSDate();if(!Q.checkDateFocusable(T)){this._setFocusedDate(this._oStartDate);Q.displayDate(S);}return this;};
l.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof k))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(I.bind(this),0);}};
l.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("selectedDates");return O;};
l.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("selectedDates");return O;};
l.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var O=this.removeAllAggregation("specialDates");return O;};
l.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var O=this.destroyAggregation("specialDates");return O;};
l.prototype.setLocale=function(O){if(this._sLocale!=O){this._sLocale=O;this._oLocaleData=undefined;this.invalidate();}return this;};
l.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
l.prototype._getFocusedDate=function(){if(!this._oFocusedDate){p.call(this);}return this._oFocusedDate;};
l.prototype._setFocusedDate=function(O){d._checkCalendarDate(O);this._oFocusedDate=new f(O);};
l.prototype.focusDate=function(O){var Q=false;var S=this.getAggregation("monthsRow");if(O&&!S.checkDateFocusable(O)){J.call(this,f.fromLocalJSDate(O));Q=true;}y.call(this,O,false);if(Q){this.fireStartDateChange();}return this;};
l.prototype.displayDate=function(O){y.call(this,O,true);return this;};
l.prototype.setMonths=function(O){this.setProperty("months",O,true);O=this._getMonths();var Q=this.getAggregation("monthsRow");Q.setMonths(O);if(!Q.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=n.call(this);this._setFocusedDate(this._oStartDate);Q.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var T=this.getAggregation("yearPicker");var U=Math.floor(O/2);if(U>20){U=20;}T.setYears(U);}t.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
l.prototype._getMonths=function(){var O=this.getMonths();if(D.system.phone&&O>6){return 6;}else{return O;}};
l.prototype._getLocaleData=function(){if(!this._oLocaleData){var O=this.getLocale();var Q=new L(O);this._oLocaleData=b.getInstance(Q);}return this._oLocaleData;};
l.prototype.setPickerPopup=function(O){var Q;this.setProperty("pickerPopup",O,true);if(O){if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}Q=this.getAggregation("yearPicker");Q.setColumns(0);Q.setYears(6);}return this;};
l.prototype.setMinDate=function(O){if(i(O,this.getMinDate())){return this;}if(!O){this._oMinDate=d._minDate();}else{d._checkJSDateObject(O);this._oMinDate=f.fromLocalJSDate(O);this._oMinDate.setDate(1);var Q=this._oMinDate.getYear();d._checkYearInValidRange(Q);if(this._oMaxDate.isBefore(this._oMinDate)){j.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=f.fromLocalJSDate(O);this._oMaxDate.setDate(d._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){j.warning("focused date < minDate -> minDate focused",this);this.focusDate(O);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){j.warning("start date < minDate -> minDate set as start date",this);_.call(this,new f(this._oMinDate),true,true);}}this.setProperty("minDate",O,false);if(this.getPickerPopup()){var S=this._getCalendarPicker();S.setMinDate(O);}else{var T=this.getAggregation("yearPicker");T._oMinDate.setYear(this._oMinDate.getYear());}return this;};
l.prototype.setMaxDate=function(O){if(i(O,this.getMaxDate())){return this;}if(!O){this._oMaxDate=d._maxDate();}else{d._checkJSDateObject(O);this._oMaxDate=f.fromLocalJSDate(O);this._oMaxDate.setDate(d._daysInMonth(this._oMaxDate));var Q=this._oMaxDate.getYear();d._checkYearInValidRange(Q);if(this._oMinDate.isAfter(this._oMaxDate)){j.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=f.fromLocalJSDate(O);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){j.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(O);}}if(this._oStartDate){var S=new f(this._oStartDate);S.setDate(1);S.setMonth(S.getMonth()+this._getMonths());S.setDate(0);if(S.isAfter(this._oMaxDate)){var T=new f(this._oMaxDate);T.setDate(1);T.setMonth(T.getMonth()-this._getMonths()+1);if(T.isSameOrAfter(this._oMinDate)){j.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,T,true,true);}}}}this.setProperty("maxDate",O,false);if(this.getPickerPopup()){var U=this._getCalendarPicker();U.setMaxDate(O);}else{var V=this.getAggregation("yearPicker");V._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};
l.prototype.onclick=function(O){if(O.isMarked("delayedMouseEvent")){return;}if(O.target.id==this.getId()+"-cancel"){this.onsapescape(O);}};
l.prototype.onmousedown=function(O){O.preventDefault();O.setMark("cancelAutoClose");};
l.prototype.onsapescape=function(O){if(this.getPickerPopup()){A.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:s.call(this);break;}}};
l.prototype.onsaptabnext=function(O){var Q=this.getAggregation("header"),S,T;if(h(this.getDomRef("content"),O.target)){if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}if(!this._bPoupupMode){T=this.getAggregation("monthsRow");q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");if(S.getDomRef()){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}O.preventDefault();}};
l.prototype.onsaptabprevious=function(O){var Q=this.getAggregation("header"),S,T;if(h(this.getDomRef("content"),O.target)){if(this._bPoupupMode){if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}O.preventDefault();}}else if(O.target.id==Q.getId()+"-B2"){switch(this._iMode){case 0:S=this.getAggregation("monthsRow");S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());break;case 1:if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");T._oItemNavigation.focusItem(T._oItemNavigation.getFocusedIndex());}break;}O.preventDefault();}};
l.prototype.onfocusin=function(O){if(O.target.id==this.getId()+"-end"){var Q=this.getAggregation("header"),S,T;if(Q.getDomRef("B2")){Q.getDomRef("B2").focus();}if(!this._bPoupupMode){S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){T=this.getAggregation("yearPicker");if(T.getDomRef()){q(T._oItemNavigation.getItemDomRefs()[T._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
l.prototype.onsapfocusleave=function(O){var Q,S;if(!O.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(O.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){switch(this._iMode){case 0:Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:if(!this.getPickerPopup()){S=this.getAggregation("yearPicker");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
l.prototype._handlePrevious=function(O){var Q,S,T,U;switch(this._iMode){case 0:Q=this._getFocusedDate();S=this._getMonths();T=new f(n.call(this));T.setMonth(T.getMonth()-S);Q.setMonth(Q.getMonth()-S);this._setFocusedDate(Q);_.call(this,T,true);break;case 1:if(!this.getPickerPopup()){U=this.getAggregation("yearPicker");U.previousPage();v.call(this);}break;}};
l.prototype._handleNext=function(O){var Q,S,T,U;switch(this._iMode){case 0:Q=this._getFocusedDate();S=this._getMonths();T=new f(n.call(this));T.setMonth(T.getMonth()+S);Q.setMonth(Q.getMonth()+S);this._setFocusedDate(Q);_.call(this,T,true);break;case 1:if(!this.getPickerPopup()){U=this.getAggregation("yearPicker");U.nextPage();v.call(this);}break;}};
l.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
l.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
l.prototype._getShowItemHeader=function(){var O=this.getMonths();if(O>this._iDaysMonthsHead){return true;}else{return false;}};
function _(S,O,Q){var T=new f(this._oMaxDate);T.setDate(1);T.setMonth(T.getMonth()-this._getMonths()+1);if(T.isBefore(this._oMinDate)){T=new f(this._oMinDate);T.setMonth(T.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new f(this._oMinDate);}else if(S.isAfter(T)){S=T;}S.setDate(1);var U=S.toLocalJSDate();this.setProperty("startDate",U,true);this._oStartDate=S;var V=this.getAggregation("monthsRow");V.setStartDate(U);t.call(this);if(O){var W=this._getFocusedDate().toLocalJSDate();if(!V.checkDateFocusable(W)){this._setFocusedDate(S);V.setDate(U);}else{V.setDate(W);}}if(!Q){this.fireStartDateChange();}}
function n(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}
function o(O){var Q=this._getFocusedDate();var S=this.getAggregation("monthsRow");if(!O){S.setDate(Q.toLocalJSDate());}else{S.displayDate(Q.toLocalJSDate());}t.call(this);}
function p(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=f.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new f();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new f(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new f(this._oMaxDate);}}
function r(){var O=this._getFocusedDate();var Q=this.getAggregation("yearPicker");this.setProperty("_currentPicker",m.YEAR_PICKER);this._showOverlay();Q.setDate(O.toLocalJSDate());if(this._iMode==0){var S=this.getAggregation("monthsRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}v.call(this);this._iMode=1;}
function s(O){this._iMode=0;this.setProperty("_currentPicker",m.MONTHS_ROW);this._hideOverlay();if(!O){o.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function t(){w.call(this);u.call(this);}
function u(){var O=new f(n.call(this));var Q=this._getMonths();var S=O.getYear();var T=this._oMaxDate.getYear();var U=this._oMinDate.getYear();var V=O.getMonth();var W=this._oMaxDate.getMonth();var X=this._oMinDate.getMonth();var Z=this.getAggregation("header");if(S<U||(S==U&&V<=X)){Z.setEnabledPrevious(false);}else{Z.setEnabledPrevious(true);}O.setMonth(O.getMonth()+Q-1);S=O.getYear();V=O.getMonth();if(S>T||(S==T&&V>=W)){Z.setEnabledNext(false);}else{Z.setEnabledNext(true);}}
function v(){var O=this.getAggregation("yearPicker");var Q=O.getYears();var S=new f(O.getProperty("_middleDate"));S.setYear(S.getYear()+Math.floor(Q/2));var T=this.getAggregation("header");var U=new f(this._oMaxDate);U.setYear(U.getYear()-Math.ceil(Q/2));U.setMonth(11,31);var V=new f(this._oMinDate);V.setYear(V.getYear()+Math.floor(Q/2)+1);V.setMonth(0,1);T.setEnabledNext(!S.isAfter(U));T.setEnabledPrevious(!S.isBefore(V));}
function w(){var T;var S=n.call(this);var O=this._oYearFormat.format(S.toUTCJSDate(),true);var Q=new f(S);Q.setMonth(Q.getMonth()+this._getMonths()-1);var U=this._oYearFormat.format(Q.toUTCJSDate(),true);if(O!=U){var V=this._getLocaleData();var W=V.getIntervalPattern();T=W.replace(/\{0\}/,O).replace(/\{1\}/,U);}else{T=O;}var X=this.getAggregation("header");X.setTextButton2(T);}
function x(O,Q){var S;var T=false;if(O.isBefore(this._oMinDate)){S=this._oMinDate;T=true;}else if(O.isAfter(this._oMaxDate)){S=this._oMaxDate;T=true;}else{S=O;}this._setFocusedDate(S);if(T||Q){J.call(this,S);o.call(this,false);this.fireStartDateChange();}}
function y(O,S){if(!O){return;}var Q=f.fromLocalJSDate(O);if(this._oFocusedDate&&this._oFocusedDate.isSame(Q)){return;}var T=Q.getYear();d._checkYearInValidRange(T);if(d._isOutside(Q,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(Q);if(this.getDomRef()&&this._iMode==0){o.call(this,S);}}
function z(O){var Q;if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){Q=function(){var S=this.getAggregation("yearPicker");S.focus();S.removeDelegate(Q);};r.call(this);this.getAggregation("yearPicker").addDelegate({onAfterRendering:Q},this);}else{s.call(this);}}}
l.prototype._showCalendarPicker=function(){var O=this._getFocusedDate(true).toLocalJSDate();var Q=this._getCalendarPicker();var S=new k({startDate:O});var T=f.fromLocalJSDate(O);Q.displayDate(O,false);T.setMonth(0,1);Q._getYearPicker().setProperty("_middleDate",T);Q.removeAllSelectedDates();Q.addSelectedDate(S);Q.setMinDate(this.getMinDate());Q.setMaxDate(this.getMaxDate());K.call(this,Q);this._showOverlay();};
function A(O){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!O){o.call(this);var Q=this.getAggregation("monthsRow");q(Q._oItemNavigation.getItemDomRefs()[Q._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function B(O){this.fireSelect();}
function E(O){var Q=f.fromLocalJSDate(O.getParameter("date"));var S=O.getParameter("notVisible");x.call(this,Q,S);}
function F(O){var Q=new f(this._getFocusedDate());var S=this._getCalendarPicker();var T=S.getSelectedDates()[0].getStartDate();var U=f.fromLocalJSDate(T);U.setMonth(Q.getMonth());U.setDate(Q.getDate());x.call(this,U,true);A.call(this);}
function G(O){var Q=new f(this._getFocusedDate());var S=this.getAggregation("yearPicker");var T=f.fromLocalJSDate(S.getDate());var U={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(U);}};var V=this.getAggregation("monthsRow");T.setMonth(Q.getMonth());T.setDate(Q.getDate());Q=T;x.call(this,Q,true);s.call(this);V.addDelegate(U,V);}
function I(){this._sInvalidateContent=undefined;var O=this.getAggregation("monthsRow");if(O){O._bDateRangeChanged=true;O._bInvalidateSync=true;O.invalidate();O._bInvalidateSync=undefined;}this._bDateRangeChanged=undefined;}
function J(O){var Q=this.getAggregation("monthsRow");var S=n.call(this);var T=Q._oItemNavigation.getFocusedIndex();S=new f(O);S.setMonth(S.getMonth()-T);_.call(this,S,false,true);}
function K(O){if(!this._oPopup){var Q=new P({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});Q.oPopup.setDurations(0,0);Q.addEventDelegate({onsapescape:function(T){this._oCustomYearPicker.onsapescape(T);this._hideOverlay();}},this);this._oPopup=Q;}this._oPopup.addContent(O);this._oPopup.attachAfterClose(function(){this._hideOverlay();},this);this._oPopup.attachAfterOpen(function(){var $=S.$("B2");var T=this._oPopup.$();var U=Math.floor((T.width()-$.width())/2);this._oPopup.setOffsetX(a.getConfiguration().getRTL()?U:-U);var V=$.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?V:-V);},this);var S=this.getAggregation("header");this._oPopup.openBy(S.getDomRef("B2"));}
function N(O){v.call(this);}
return l;});
sap.ui.predefine('sap/ui/unified/CalendarMonthIntervalRenderer',[],function(){"use strict";var C={apiVersion:2};
C.render=function(r,c){var i=c.getId();var t=c.getTooltip_AsString();r.openStart("div",c);r.class("sapUiCal");r.class("sapUiCalInt");r.class("sapUiCalMonthInt");if(c._getShowItemHeader()){r.class("sapUiCalIntHead");}var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.accessibilityState(c,A);if(t){r.attr('title',t);}var w=c.getWidth();if(w&&w!=''){r.style("width",w);}r.openEnd();var h=c.getAggregation("header");r.renderControl(h);r.openStart("div",i+"-content");r.class("sapUiCalContent");r.openEnd();r.renderControl(c.getAggregation(c.getProperty("_currentPicker")));r.close("div");r.openStart("button",i+"-cancel");r.class("sapUiCalCancel");r.attr("tabindex","-1");r.openEnd();r.text(a.getText("CALENDAR_CANCEL"));r.close("button");r.openStart("div",i+"-end");r.attr("tabindex","0");r.style("width","0");r.style("height","0");r.style("position","absolute");r.style("right","0");r.style("bottom","0");r.openEnd();r.close("div");if(c.getPickerPopup()){r.openStart("div",i+"-contentOver");r.class("sapUiCalContentOver");if(!c._oPopup||!c._oPopup.isOpen()){r.style("display","none");}r.openEnd();r.close("div");}r.close("div");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarOneMonthInterval',['sap/ui/unified/calendar/CustomMonthPicker','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/Calendar','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/calendar/OneMonthDatesRow',"sap/ui/unified/DateRange","./CalendarOneMonthIntervalRenderer"],function(C,a,b,c,l,d,O,D,e){"use strict";
var f=d.extend("sap.ui.unified.CalendarOneMonthInterval",{});
f.prototype.init=function(){d.prototype.init.apply(this,arguments);this._bShowOneMonth=true;};
f.prototype._getCalendar=function(){var o;if(!this._oCalendar){o=new C(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",function(){var g=this._getCalendar(),h=g._getFocusedDate(),n=a._getFirstDateOfMonth(h);var i=this.getAggregation("month")[0];this._setStartDate(n);if(i.getMode()<2){n=this._getStartDate();}this._adjustSelectedDate(n);this._oFocusDateOneMonth=n;this._closeCalendarPicker(true);this._focusDate(h,false,true);},this);o.attachEvent("cancel",function(E){var g=this._getCalendar(),h=g._getFocusedDate();this._closeCalendarPicker(true);this._oFocusDateOneMonth=h;this._focusDate(h,true);var i=this.getAggregation("header").getDomRef("B1");if(i){i.focus();}},this);this._oCalendar=o;}return this._oCalendar;};
f.prototype._createMonth=function(i){return new O(i);};
f.prototype._handleFocus=function(E){var o=!!E.getParameter("_outsideBorder"),g=E.getParameter("date"),h=b.fromLocalJSDate(g),i=b.fromLocalJSDate(this.getStartDate()),I=!a._isSameMonthAndYear(h,i),j,F,s;if(o||I){if(a._isLastDateInMonth(h)){this._oFocusDateOneMonth=h;}else{this._oFocusDateOneMonth=a._getFirstDateOfMonth(h);}j=h.isBefore(i)?-1:1;F=new b(this._getFocusedDate(),this.getPrimaryCalendarType());s=new b(this._getStartDate(),this.getPrimaryCalendarType());d.prototype._shiftStartFocusDates.call(this,F,s,j);}return d.prototype._handleFocus.apply(this,arguments);};
f.prototype._focusDateExtend=function(o,g,n){var h,L;if(!this._oFocusDateOneMonth){return d.prototype._focusDateExtend.apply(this,arguments);}h=this.getAggregation("month")[0];L=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);h._bNoRangeCheck=true;h.setDate(L);h._bNoRangeCheck=false;this._oFocusDateOneMonth=null;return!n;};
f.prototype._setDisplayMode=function(m){this.getAggregation("month")[0].setMode(m);};
f.prototype._shiftStartFocusDates=function(s,F,i){var S=i,o=this.getAggregation("month")[0],L,g;if(S!==0){S=S>0?1:-1;}s.setMonth(s.getMonth()+S);F.setYear(s.getYear());F.setMonth(s.getMonth(),s.getDate());this._setFocusedDate(F);this._setStartDate(s,true);L=this.getStartDate();g=b.fromLocalJSDate(L,this.getPrimaryCalendarType());if(this.getMinDate()&&this.getMinDate().getTime()>L.getTime()){g=b.fromLocalJSDate(this.getMinDate(),this.getPrimaryCalendarType());}if(this.getMaxDate()&&this.getMaxDate().getTime()<L.getTime()){g=b.fromLocalJSDate(this.getMaxDate(),this.getPrimaryCalendarType());}o.selectDate(g.toLocalJSDate());if(o.getMode()<2){this.fireSelect();}};
f.prototype._adjustSelectedDate=function(s){var m=this.getAggregation("month")[0];if(m.getMode&&m.getMode()<2){this._selectDate(s);}};
f.prototype._selectDate=function(o){var m=this.getAggregation("month")[0],L=o.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new D({startDate:L}));m.selectDate(L);this._bDateRangeChanged=undefined;};
f.prototype._dateMatchesVisibleRange=function(o){return a._isSameMonthAndYear(b.fromLocalJSDate(this.getStartDate()),b.fromLocalJSDate(o));};
f.prototype._togglePrevNext=function(o,g){var h=this.getAggregation("header");var y=this._oMaxDate.getYear();var Y=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var M=this._oMinDate.getMonth();var F=a._getFirstDateOfMonth(o);var i=new b(F),j,k;i.setMonth(i.getMonth()+1);j=F.getYear();k=F.getMonth();if(j<Y||(j==Y&&(!g||k<=M))){h.setEnabledPrevious(false);}else{h.setEnabledPrevious(true);}j=i.getYear();k=i.getMonth();if(j>y||(j==y&&(!g||k>m))){h.setEnabledNext(false);}else{h.setEnabledNext(true);}};
f.prototype._setMinMaxDateExtend=function(o){return c.prototype._setMinMaxDateExtend.apply(this,arguments);};
return f;});
sap.ui.predefine('sap/ui/unified/CalendarOneMonthIntervalRenderer',['sap/ui/core/Renderer','./CalendarDateIntervalRenderer'],function(R,C){"use strict";var a=R.extend(C);a.apiVersion=2;
a.addAttributes=function(r,c){C.addAttributes.apply(this,arguments);r.class("sapUiCalOneMonthInt");};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarRenderer',[],function(){"use strict";var C={apiVersion:2};var a={MONTH:"month",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker",YEAR_RANGE_PICKER:"yearRangePicker"};
C.render=function(r,c){var i=c.getId(),t=c.getTooltip_AsString(),m=c.getAggregation("month"),s=c.getProperty("_currentPicker"),w=c.getWidth(),b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),A={labelledby:{value:"",append:false}};r.openStart("div",c);r.class("sapUiCal");if(m.length>1){r.class("sapUiCalMulti");}r.accessibilityState(c,A);if(t){r.attr("title",t);}if(w){r.class("sapUiCalWidth");r.style("width",w);}if(c._getSecondaryCalendarType()){r.class("sapUiCalSecType");}if(this.addAttributes){this.addAttributes(r,c);}r.openEnd();var h=c.getAggregation("header");r.renderControl(h);r.openStart("div",i+"-content");r.class("sapUiCalContent");r.openEnd();if(c.getMonths()>1){switch(s){case a.MONTH_PICKER:case a.YEAR_PICKER:case a.YEAR_RANGE_PICKER:this.renderMonths(r,c,m);this.renderCalContentOverlay(r,c,i);break;}}switch(s){case a.MONTH:this.renderMonths(r,c,m);break;case a.MONTH_PICKER:r.renderControl(c._getMonthPicker());break;case a.YEAR_PICKER:r.renderControl(c._getYearPicker());break;case a.YEAR_RANGE_PICKER:r.renderControl(c._getYearRangePicker());break;}r.close("div");if(!c._bSkipCancelButtonRendering){r.openStart("button",i+"-cancel");r.class("sapUiCalCancel");r.attr("tabindex","-1");r.openEnd();r.text(b.getText("CALENDAR_CANCEL"));r.close("button");}r.openStart("div",i+"-end");r.attr("tabindex","0");r.style("position","absolute");r.style("width","0");r.style("height","0");r.style("right","0");r.style("bottom","0");r.openEnd();r.close("div");this.renderCalContentAndArrowsOverlay(r,c,i);r.close("div");};
C.renderMonths=function(r,c,m){m.forEach(function(M,i){r.renderControl(M);if(m.length===2&&i===0){r.renderControl(c.getAggregation("secondMonthHeader"));}});};
C.renderCalContentOverlay=function(r,c,i){r.openStart("div",i+"-contentOver");r.class("sapUiCalContentOver");r.openEnd();r.close("div");};
C.renderCalContentAndArrowsOverlay=function(r,c,i){};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarRow',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/checkMouseEnterOrLeave","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarAppointment"],function(C,D,L,a,U,l,I,b,R,c,d,e,f,q,g){"use strict";var h=l.CalendarDayType;var m=l.CalendarAppointmentVisualization;var G=l.GroupAppointmentsMode;var n=l.CalendarIntervalType;var o=l.CalendarAppointmentHeight;var r=l.CalendarAppointmentRoundWidth;
var s=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalSize:{type:"int",group:"Appearance",defaultValue:1},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:n.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:m.Standard},appointmentHeight:{type:"sap.ui.unified.CalendarAppointmentHeight",group:"Appearance",defaultValue:o.Regular},appointmentRoundWidth:{type:"sap.ui.unified.CalendarAppointmentRoundWidth",group:"Appearance",defaultValue:r.None},multipleAppointmentsSelection:{type:"boolean",group:"Data",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});
s.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAria=b.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+u.call(this).getTimePattern("medium")});this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);this.aSelectedAppointments=[];this._fnCustomSortedAppointments=undefined;};
s.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._fnCustomSortedAppointments=undefined;};
s.prototype.onBeforeRendering=function(){this._aVisibleAppointments=[];v.call(this);y.call(this);E.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(!this.getAppointments().length){this.aSelectedAppointments=[];}else{this.getAppointments().forEach(function(i){this._updateSelectedAppointmentsArray(i);}.bind(this));}};
s.prototype.onAfterRendering=function(){F.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}};
s.prototype.onThemeChanged=function(j){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var k=this._aVisibleAppointments[i];k.level=-1;}this.handleResize(j);}};
s.prototype.invalidate=function(j){if(j&&j instanceof g){var k=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==j){k=true;break;}}if(k){this._aVisibleAppointments=[];}this._updateSelectedAppointmentsArray(j);}C.prototype.invalidate.apply(this,arguments);};
s.prototype.setStartDate=function(i){if(!i){i=new Date();}a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);this._oUTCStartDate=a._createUniversalUTCDate(i,undefined,true);this.setProperty("startDate",i);return this;};
s.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};
s.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};
s.prototype._getAppointmentReducedHeight=function(i){var j=!D.system.phone&&this.getAppointmentsReducedHeight()&&i.size===o.Regular;return j;};
s.prototype.onfocusin=function(j){if(q(j.target).hasClass("sapUiCalendarApp")){N.call(this,j.target.id);}else{var V=this._getVisibleAppointments();var k=false;var p;for(var i=0;i<V.length;i++){p=V[i].appointment;if(e(p.getDomRef(),j.target)){k=true;p.focus();break;}}if(!k){p=this.getFocusedAppointment();if(p){p.focus();}}}};
s.prototype.applyFocusInfo=function(i){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};
s.prototype.onsapleft=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){O.call(this,this._bRTL,1);}i.preventDefault();i.stopPropagation();};
s.prototype.onsapright=function(i){if(q(i.target).hasClass("sapUiCalendarApp")){O.call(this,!this._bRTL,1);}i.preventDefault();i.stopPropagation();};
s.prototype.onsapup=function(i){this.fireLeaveRow({type:i.type});};
s.prototype.onsapdown=function(i){this.fireLeaveRow({type:i.type});};
s.prototype.onsaphome=function(i){P.call(this,i);i.preventDefault();i.stopPropagation();};
s.prototype.onsapend=function(i){P.call(this,i);i.preventDefault();i.stopPropagation();};
s.prototype.onsapselect=function(j){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var k=V[i].appointment;if(e(k.getDomRef(),j.target)){var p=!(this.getMultipleAppointmentsSelection()||j.ctrlKey||j.metaKey);H.call(this,k,p);break;}}j.stopPropagation();j.preventDefault();};
s.prototype.ontap=function(i){var j=this.$("Apps").children(".sapUiCalendarRowAppsInt");var k=0;var p=false;for(k=0;k<j.length;k++){var T=j[k];if(!this._isOneMonthsRowOnSmallSizes()&&e(T,i.target)){p=true;break;}}if(p){Q.call(this,k,i.target);}else{this.onsapselect(i);}};
s.prototype.onsapselectmodifiers=function(i){this.onsapselect(i);};
s.prototype.handleResize=function(i){if(i&&i.size&&i.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");F.call(this);return this;};
s.prototype.updateCurrentTimeVisualization=function(){var $=this.$("Now");var i=a._createUniversalUTCDate(new Date(),undefined,true);var j=this.getIntervals();var k=this.getIntervalType();var p=this._getStartDate();var T=p.getTime();var V=this._oUTCEndDate;var W=V.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=W&&i.getTime()>=T){var X=A.call(this,k,j,p,V,T,i);var Y=0;if(this._bRTL){$.css("right",X+"%");}else{$.css("left",X+"%");}$.css("display","");if(this.getUpdateCurrentTime()){switch(k){case n.Hour:Y=60000;break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":Y=1800000;break;default:Y=-1;break;}if(Y>0){this._sUpdateCurrentTime=setTimeout(this.updateCurrentTimeVisualization.bind(this),Y);}}}else{$.css("display","none");}return this;};
s.prototype.getFocusedAppointment=function(){var j=this._getAppointmentsSorted();var k=this.getAggregation("groupAppointments",[]);var p;var i=0;for(i=0;i<k.length;i++){if(k[i].getId()==this._sFocusedAppointmentId){p=k[i];break;}}if(!p){for(i=0;i<j.length;i++){if(j[i].getId()==this._sFocusedAppointmentId){p=j[i];break;}}}return p;};
s.prototype.focusAppointment=function(i){if(!i||!(i instanceof g)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var j=i.getId();if(this._sFocusedAppointmentId!=j){N.call(this,j);}else{i.focus();}return this;};
s.prototype.focusNearestAppointment=function(j){a._checkJSDateObject(j);var k=this._getAppointmentsSorted();var p;var T;var V;for(var i=0;i<k.length;i++){p=k[i];if(p.getStartDate()>j){if(i>0){T=k[i-1];}else{T=p;}break;}}if(p){if(T&&Math.abs(p.getStartDate()-j)>=Math.abs(T.getStartDate()-j)){V=T;}else{V=p;}this.focusAppointment(V);}return this;};
s.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
s.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};
s.prototype._getNonWorkingDays=function(){if(this.getIntervalSize()!==1){return[];}var j=this.getNonWorkingDays();if(!j){var k=u.call(this);var W=k.getWeekendStart();var p=k.getWeekendEnd();j=[];for(var i=0;i<=6;i++){if((W<=p&&i>=W&&i<=p)||(W>p&&(i>=W||i<=p))){j.push(i);}}}else if(!Array.isArray(j)){j=[];}return j;};
s.prototype._isOneMonthsRowOnSmallSizes=function(){return(this.getIntervalType()===n.OneMonth||this.getIntervalType()==="OneMonth")&&this.getIntervals()===1;};
s.prototype._getAppointmentsSorted=function(){var i=this.getAppointments(),j=S;i.sort(this._fnCustomSortedAppointments?this._fnCustomSortedAppointments:j);return i;};
s.prototype._setCustomAppointmentsSorterCallback=function(i){this._fnCustomSortedAppointments=i;this.invalidate();};
s.prototype._calculateAppoitnmentVisualCue=function(i){if(_(this,i)){return{appTimeUnitsDifRowStart:0,appTimeUnitsDifRowEnd:0};}var j=i.getStartDate(),k=i.getEndDate(),p=new U(j.getFullYear(),j.getMonth(),j.getDate(),j.getHours(),j.getMinutes()),T=new U(k.getFullYear(),k.getMonth(),k.getDate(),k.getHours(),k.getMinutes()),V=this.getIntervalType(),W=this.getStartDate(),X=V==="Hour"?new U(W.getFullYear(),W.getMonth(),W.getDate(),W.getHours()):new U(W.getFullYear(),W.getMonth(),W.getDate()),Y=this.getIntervals(),Z;switch(V){case"Hour":Z=new U(W.getFullYear(),W.getMonth(),W.getDate(),W.getHours()+Y);break;case"Day":case"Week":case"One Month":Z=new U(W.getFullYear(),W.getMonth(),W.getDate()+Y);break;case"Month":Z=new U(W.getFullYear(),W.getMonth()+Y,W.getDate());break;default:break;}return{appTimeUnitsDifRowStart:X.getTime()-p.getTime(),appTimeUnitsDifRowEnd:T.getTime()-Z.getTime()};};
s.prototype._updateSelectedAppointmentsArray=function(i){if(i.getSelected()){if(this.aSelectedAppointments.indexOf(i.getId())===-1){this.aSelectedAppointments.push(i.getId());}}else{this.aSelectedAppointments=this.aSelectedAppointments.filter(function(j){return j!==i.getId();});}};
function _(j,k){var p=j.getAggregation("groupAppointments",[]);var i;for(i=0;i<p.length;++i){if(k===p[i]){return true;}}return false;}
function t(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
function u(){if(!this._oLocaleData){var i=t.call(this);var j=new c(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}
function v(){var i=this.getStartDate();var j;var k=this.getIntervals();var p=this.getIntervalType();this._oUTCStartDate=w.call(this,i);switch(p){case n.Hour:j=new U(this._oUTCStartDate.getTime());j.setUTCHours(j.getUTCHours()+k);break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":j=new U(this._oUTCStartDate.getTime());j.setUTCDate(j.getUTCDate()+k*this.getIntervalSize());break;case n.Month:j=new U(this._oUTCStartDate.getTime());j.setUTCMonth(j.getUTCMonth()+k);break;default:throw new Error("Unknown IntervalType: "+p+"; "+this);}j.setUTCMilliseconds(-1);this._iRowSize=j.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/k);this._oUTCEndDate=j;}
function w(i){var j=this.getIntervalType();var k=a._createUniversalUTCDate(i,undefined,true);switch(j){case n.Hour:k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;case n.Month:k.setUTCDate(1);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+j+"; "+this);}return k;}
function x(){return D.system.phone||(this.getGroupAppointmentsMode()===G.Collapsed);}
function y(){var p=this._getAppointmentsSorted();var T;var V;var W;var X=this.getIntervals();var Y=this.getIntervalType();var Z=this._getStartDate();var $=Z.getTime();var a1=this._oUTCEndDate;var b1=a1.getTime();var c1=[];var d1=false;var i=0;var j=0;var e1=x.call(this);var f1=this._needAppointmentHorizontalFit();this.destroyAggregation("groupAppointments",true);for(i=0;i<p.length;i++){T=p[i];var g1=a._createUniversalUTCDate(T.getStartDate(),undefined,true);var h1=g1.getTime();g1.setUTCSeconds(0);g1.setUTCMilliseconds(0);var i1=T.getEndDate()?a._createUniversalUTCDate(T.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);var j1=i1.getTime();i1.setUTCSeconds(0);i1.setUTCMilliseconds(0);var k1=false;if(g1.getTime()<$&&i1.getTime()>=$){g1=new U($);k1=true;}if(i1.getTime()>b1&&g1.getTime()<=b1){i1=new U(b1);k1=true;}var l1=(i1.getTime()-g1.getTime())/60000;if(k1&&l1==0){continue;}var m1=0;var n1=0;var o1=-1;V=undefined;W=undefined;if(g1&&g1.getTime()<=b1&&i1&&i1.getTime()>=$&&h1<=j1){if(e1&&(Y==n.Month)&&((i1.getTime()-g1.getTime())<604800000)){V=z.call(this,g1,T,Y,X,Z,a1,$,c1);var p1=a._createUniversalUTCDate(V.getEndDate(),undefined,true);if(i1.getTime()>p1.getTime()){W=z.call(this,i1,T,Y,X,Z,a1,$,c1);}}if(f1){this._setHorizontalRoundingWidth(T,g1,i1);}m1=A.call(this,Y,X,Z,a1,$,g1);n1=B.call(this,Y,X,Z,a1,$,i1);if(V){V._iBegin=m1;V._iEnd=n1;V._iLevel=o1;if(W){W._iBegin=m1;W._iEnd=n1;W._iLevel=o1;}continue;}c1.push({appointment:T,begin:m1,end:n1,calculatedEnd:n1,level:o1,size:this.getProperty("appointmentHeight")});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==T.getId()){d1=true;}}}var q1=this.getAggregation("groupAppointments",[]);if(q1.length>0){for(i=0;i<c1.length;i++){T=c1[i];if(T.appointment._aAppointments&&T.appointment._aAppointments.length<=1){V=T.appointment;var r1=false;if(V._aAppointments.length==0){r1=true;}else{for(j=0;j<c1.length;j++){if(c1[j].appointment==V._aAppointments[0]){r1=true;break;}}}if(!r1){for(j=0;j<q1.length;j++){W=q1[j];if(V!=W){for(var k=0;k<W._aAppointments.length;k++){if(V._aAppointments[0]==W._aAppointments[k]){W._aAppointments.splice(k,1);if(W._aAppointments.length==1){this.removeAggregation("groupAppointments",W);W.destroy();q1=this.getAggregation("groupAppointments",[]);}else{W.setProperty("title",W._aAppointments.length,true);}break;}}}}T.begin=V._iBegin;T.end=V._iEnd;T.calculatedEnd=V._iEnd;T.level=V._iLevel;T.appointment=V._aAppointments[0];}else{c1.splice(i,1);i--;}this.removeAggregation("groupAppointments",V);V.destroy();q1=this.getAggregation("groupAppointments",[]);}}}if(!d1){if(c1.length>0){this._sFocusedAppointmentId=c1[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=c1;return this._aVisibleAppointments;}
function z(i,k,p,T,V,W,X,Y){var Z=this.getAggregation("groupAppointments",[]);var $;var a1=u.call(this);var b1=a1.getFirstDayOfWeek();var c1=i.getUTCDay();var d1=new U(i.getTime());d1.setUTCHours(0);d1.setUTCMinutes(0);d1.setUTCSeconds(0);d1.setUTCMilliseconds(0);if(b1<=c1){d1.setDate(d1.getDate()-(c1-b1));}else{d1.setDate(d1.getDate()-(7-c1-b1));}for(var j=0;j<Z.length;j++){$=Z[j];var e1=a._createUniversalUTCDate($.getStartDate(),undefined,true);if(e1.getTime()==d1.getTime()){break;}$=undefined;}if(!$){var f1=new U(d1.getTime());f1.setDate(f1.getDate()+7);f1.setMilliseconds(-1);$=new g(this.getId()+"-Group"+Z.length,{type:k.getType(),startDate:a._createLocalDate(new Date(d1.getTime()),true),endDate:a._createLocalDate(new Date(f1.getTime()),true)});$._aAppointments=[];this.addAggregation("groupAppointments",$,true);var g1=A.call(this,p,T,V,W,X,d1);var h1=B.call(this,p,T,V,W,X,f1);Y.push({appointment:$,begin:g1,end:h1,calculatedEnd:h1,level:-1,size:this.getProperty("appointmentHeight")});}$._aAppointments.push(k);if($.getType()!=h.None&&$.getType()!=k.getType()){$.setType(h.None);}$.setProperty("title",$._aAppointments.length,true);return $;}
function A(i,j,k,p,T,V){var W=0;if(i!=n.Month){W=100*(V.getTime()-T)/this._iRowSize;}else{var X=new U(V.getTime());X.setUTCDate(1);X.setUTCHours(0);X.setUTCMinutes(0);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=new U(X.getTime());Y.setUTCMonth(Y.getUTCMonth()+1);Y.setMilliseconds(-1);var Z=Y.getTime()-X.getTime();var $=(X.getUTCFullYear()-k.getUTCFullYear())*12+X.getUTCMonth()-k.getUTCMonth();W=(100*$/j)+(100*(V.getTime()-X.getTime())/Z)/j;}if(W<0){W=0;}W=Math.round(W*100000)/100000;return W;}
function B(i,j,k,p,T,V){var W=0;if(i!=n.Month){W=100-(100*(V.getTime()-T)/this._iRowSize);}else{var X=new U(V.getTime());X.setUTCDate(1);X.setUTCHours(0);X.setUTCMinutes(0);X.setUTCSeconds(0);X.setUTCMilliseconds(0);var Y=new U(X.getTime());Y.setUTCMonth(Y.getUTCMonth()+1);Y.setMilliseconds(-1);var Z=Y.getTime()-X.getTime();var $=(X.getUTCFullYear()-k.getUTCFullYear())*12+X.getUTCMonth()-k.getUTCMonth();W=100-((100*$/j)+(100*(V.getTime()-X.getTime())/Z)/j);}if(W<0){W=0;}W=Math.round(W*100000)/100000;return W;}
function E(){var V=[];if(this.getShowIntervalHeaders()){var k=this.getIntervalHeaders();var p;var T=this.getIntervals();var W=this.getIntervalType();var X=this._getStartDate();var Y=X.getTime();var Z=this._oUTCEndDate;var $=Z.getTime();var i=0;var j=0;for(i=0;i<k.length;i++){p=k[i];var a1=a._createUniversalUTCDate(p.getStartDate(),undefined,true);a1.setUTCSeconds(0);a1.setUTCMilliseconds(0);var b1=p.getEndDate()?a._createUniversalUTCDate(p.getEndDate(),undefined,true):a._createUniversalUTCDate(new Date(864000000000000),undefined,true);b1.setUTCSeconds(0);b1.setUTCMilliseconds(0);if(a1&&a1.getTime()<=$&&b1&&b1.getTime()>=Y){var c1=new U(X.getTime());var d1=new U(X.getTime());d1.setUTCMinutes(d1.getUTCMinutes()-1);var e1=-1;var f1=-1;for(j=0;j<T;j++){switch(W){case n.Hour:d1.setUTCHours(d1.getUTCHours()+1);if(j>0){c1.setUTCHours(c1.getUTCHours()+1);}break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":d1.setUTCDate(d1.getUTCDate()+1);if(j>0){c1.setUTCDate(c1.getUTCDate()+1);}break;case n.Month:d1.setUTCDate(1);d1.setUTCMonth(d1.getUTCMonth()+2);d1.setUTCDate(0);if(j>0){c1.setUTCMonth(c1.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+W+"; "+this);}if(a1&&a1.getTime()<=c1.getTime()&&b1&&b1.getTime()>=d1.getTime()){if(e1<0){e1=j;}f1=j;}}if(e1>=0){V.push({interval:e1,appointment:p,last:f1});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}
function F(){if(this._isOneMonthsRowOnSmallSizes()){return;}var $=this.$("Apps");var k=$.innerWidth();if(k<=0){return;}var p=this.$("DummyApp");var T=p.outerHeight(true);if(T<=0){return;}var V=4;var W=p.outerWidth();var X=W/k*100;var Y=Math.ceil(1000*X)/1000;var Z;var a1;var b1=0;var c1=0;var i=0;var d1=false;var e1;var f1=this._needAppointmentHorizontalFit();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){b1=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);d1=true;}for(i=0;i<this._aVisibleAppointments.length;i++){Z=this._aVisibleAppointments[i];a1=Z.appointment.$();var g1=Math.floor(1000*(100-Z.calculatedEnd-Z.begin))/1000;var h1=false;if(g1<Y){Z.end=100-Z.begin-X;if(Z.end<0){Z.end=0;}h1=true;a1.addClass("sapUiCalendarAppSmall");}else if(a1.hasClass("sapUiCalendarAppSmall")){Z.end=Z.calculatedEnd;h1=true;a1.removeClass("sapUiCalendarAppSmall");}if(h1){Z.level=-1;}if(h1&&!f1){if(this._bRTL){a1.css("left",Z.end+"%");}else{a1.css("right",Z.end+"%");}}if(f1){Z.end=Z.calculatedEnd;}}for(i=0;i<this._aVisibleAppointments.length;i++){Z=this._aVisibleAppointments[i];a1=Z.appointment.$();var i1={};if(Z.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var j1=this._aVisibleAppointments[j];if(Z!=j1&&Z.begin<(Math.floor(1000*(100-j1.end))/1000)&&(Math.floor(1000*(100-Z.end))/1000)>j1.begin&&j1.level>=0){this._setBlockedLevelsForAppointment(j1,i1);}}Z.level=this._getAppointmetLevel(i1,Z);a1.attr("data-sap-level",Z.level);}e1=T*Z.level+b1;if(!d1){e1+=V;}a1.css("top",e1+"px");var k1=Z.level;k1+=this._getAppointmentRowCount(Z)-1;if(c1<k1){c1=k1;}}c1++;T=T*c1+b1;if(!d1){T+=V;}if(!this.getHeight()){$.outerHeight(T);}else{var l1=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<l1.length;i++){var m1=q(l1[i]);m1.outerHeight(T);}}p.css("display","none");}
function H(j,k){var i=0;var p;var T;var V;var W;var X=I.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");var Y=!j.getSelected();if(k){var Z=this.getAppointments();var $=this.getAggregation("groupAppointments",[]);q.merge(Z,$);for(i=0;i<Z.length;i++){p=Z[i];if(p.getId()!==j.getId()&&p.getSelected()){p.setProperty("selected",false,true);p.$().removeClass("sapUiCalendarAppSel");for(var i=0;i<this.aSelectedAppointments.length;i++){if(this.aSelectedAppointments[i]!==p.getId()){this.aSelectedAppointments.splice(i);}}T=p.$().attr("aria-labelledby");V=T?T.replace(X,""):"";p.$().attr("aria-labelledby",V);}}}W=j.$().attr("aria-labelledby")+" "+X;V=j.$().attr("aria-labelledby").replace(X,"").trim();if(j.getSelected()){j.setProperty("selected",false,true);j.$().removeClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",V);K(this,k);}else{j.setProperty("selected",true,true);j.$().addClass("sapUiCalendarAppSel");j.$().attr("aria-labelledby",W);K(this,k);}this._updateSelectedAppointmentsArray(j);if(j._aAppointments){for(i=0;i<j._aAppointments.length;i++){p=j._aAppointments[i];p.setProperty("selected",Y,true);W=p.$().attr("aria-labelledby")+" "+X;p.$().attr("aria-labelledby",W);}this.fireSelect({appointments:j._aAppointments,multiSelect:!k,domRefId:j.getId()});}else{this.fireSelect({appointment:j,multiSelect:!k,domRefId:j.getId()});}}
function J(i){var p=this._getPlanningCalendar();if(p){p["_onRow"+i]();}}
s.prototype._needAppointmentHorizontalFit=function(){var p=this._getPlanningCalendar(),k,V,i;if(!p||this.getAppointmentRoundWidth()===r.None){return false;}k=p.getViewKey();V=p._getView(k);i=p._getIntervals(V);return i>=20;};
s.prototype._setHorizontalRoundingWidth=function(i,j,k){var p;switch(this.getAppointmentRoundWidth()){case r.HalfColumn:p=12;break;}this._roundAppointment(i,j,k,p);};
s.prototype._roundAppointment=function(i,j,k,p){var T,V;T=i.getStartDate().getHours()-i.getStartDate().getHours()%p;j.setUTCHours(T);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);V=i.getEndDate().getHours()-i.getEndDate().getHours()%p+p;k.setUTCHours(V);k.setUTCMinutes(0);k.setUTCSeconds(0);k.setUTCMilliseconds(0);};
s.prototype._setBlockedLevelsForAppointment=function(V,i){var j=this._getAppointmentRowCount(V);for(var k=0;k<j;k++){i[V.level+k]=true;}return i;};
s.prototype._getAppointmentRowCount=function(V){var i,j=this._getAppointmentReducedHeight(V);switch(V.size){case o.HalfSize:i=1;break;case o.Regular:i=2;if(j&&!V.appointment.getText()&&!V.appointment.getDescription()){i=1;}break;case o.Large:i=3;break;case o.Automatic:i=1;if(V.appointment.getText()){i+=1;}if(V.appointment.getDescription()){i+=1;}break;}return i;};
s.prototype._getAppointmetLevel=function(i,j){var k=0;var p=this._getAppointmentRowCount(j);var T=true;while(T){T=this._isPosibleToPositionAppointment(k,i,p);if(!T){T=true;k+=1;}else{T=false;}}return k;};
s.prototype._isPosibleToPositionAppointment=function(i,j,k){for(var p=i;p<k+i;p++){if(j[p]){return false;}}return true;};
s.prototype._getPlanningCalendar=function(){var p=this;while(p.getParent()!==null){if(p.isA("sap.m.PlanningCalendar")){return p;}p=p.getParent();}};
function K(i,j){if(j){J.call(i,"DeselectAppointment");}}
function M(k){var p=this.getAggregation("groupAppointments",[]);var T;var V=false;for(var i=0;i<p.length;i++){var W=p[i]._aAppointments;for(var j=0;j<W.length;j++){if(W[j].getId()==k){T=p[i];V=true;break;}}if(V){break;}}return T;}
function N(j){if(this._sFocusedAppointmentId!=j){var k=this._getAppointmentsSorted();var V=this._aVisibleAppointments;var p;var i=0;p=M.call(this,j);if(p){j=p.getId();p=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==j){p=V[i].appointment;break;}}if(p){var $=this.getFocusedAppointment().$();var T=p.$();this._sFocusedAppointmentId=p.getId();$.attr("tabindex","-1");T.attr("tabindex","0");T.trigger("focus");}else{for(i=0;i<k.length;i++){if(k[i].getId()==j){p=k[i];break;}}if(p){this._sFocusedAppointmentId=p.getId();var W=w.call(this,p.getStartDate());this.setStartDate(a._createLocalDate(W,true));if(!e(this.getDomRef(),document.activeElement)){setTimeout(function(){this.getFocusedAppointment().focus();}.bind(this),0);}this.fireStartDateChange();}}}}
function O(j,k){var p=this._sFocusedAppointmentId;var T=this._getAppointmentsSorted();var V=this.getAggregation("groupAppointments",[]);var W;var X=0;var i=0;for(i=0;i<V.length;i++){if(V[i].getId()==p){var Y=V[i]._aAppointments;if(j){p=Y[Y.length-1].getId();}else{p=Y[0].getId();}break;}}for(i=0;i<T.length;i++){if(T[i].getId()==p){X=i;break;}}if(j){X=X+k;}else{X=X-k;}if(X<0){X=0;}else if(X>=T.length){X=T.length-1;}W=T[X];N.call(this,W.getId());}
function P(j){var k=this._getAppointmentsSorted();var p;var T=new U(this._getStartDate());var V=new U(this._oUTCEndDate);var W=this.getIntervalType();var X;var Y;T.setUTCHours(0);V.setUTCHours(0);V.setUTCMinutes(0);V.setUTCSeconds(0);switch(W){case n.Hour:V.setUTCDate(V.getUTCDate()+1);V.setUTCMilliseconds(-1);break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":T.setUTCDate(1);V.setUTCMonth(V.getUTCMonth()+1);V.setUTCDate(1);V.setUTCMilliseconds(-1);break;case n.Month:T.setUTCMonth(0);T.setUTCDate(1);V.setUTCFullYear(V.getUTCFullYear()+1);V.setUTCMonth(1);V.setUTCDate(1);V.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+W+"; "+this);}var Z=a._createLocalDate(T,true);var $=a._createLocalDate(V,true);for(var i=0;i<k.length;i++){if(k[i].getStartDate()>=Z&&k[i].getStartDate()<=$){p=k[i];X=p.getId();if(j.type=="saphome"){break;}}else if(k[i].getStartDate()>$){break;}}Y=M.call(this,X);if(Y){p=Y;X=p.getId();}if(X&&X!=this._sFocusedAppointmentId){N.call(this,X);}else if(j._bPlanningCalendar&&p){p.focus();}else{this.fireLeaveRow({type:j.type});}}
function Q(i,j){var k=this.getIntervalType();var p=this._getStartDate();var T=new U(p.getTime());var V;var W=false;var X=0;var Y=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){W=true;var Z=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");Y=Z.length;for(X=0;X<Y;X++){var $=Z[X];if($==j){break;}}}switch(k){case n.Hour:T.setUTCHours(T.getUTCHours()+i);if(W){T.setUTCMinutes(T.getUTCMinutes()+X*60/Y);V=new U(T.getTime());V.setUTCMinutes(V.getUTCMinutes()+60/Y);}else{V=new U(T.getTime());V.setUTCHours(V.getUTCHours()+1);}break;case n.Day:case n.Week:case n.OneMonth:case"OneMonth":T.setUTCDate(T.getUTCDate()+i);if(W){T.setUTCHours(T.getUTCHours()+X*24/Y);V=new U(T.getTime());V.setUTCHours(V.getUTCHours()+24/Y);}else{V=new U(T.getTime());V.setUTCDate(V.getUTCDate()+1);}break;case n.Month:T.setUTCMonth(T.getUTCMonth()+i);if(W){T.setUTCDate(T.getUTCDate()+X);V=new U(T.getTime());V.setUTCDate(V.getUTCDate()+1);}else{V=new U(T.getTime());V.setUTCMonth(V.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+k+"; "+this);}V.setUTCMilliseconds(V.getUTCMilliseconds()-1);T=a._createLocalDate(T,true);V=a._createLocalDate(V,true);this.fireIntervalSelect({startDate:T,endDate:V,subInterval:W});}
function S(i,j){var k=i.getStartDate()-j.getStartDate();if(k==0){k=j.getEndDate()-i.getEndDate();}return k;}
return s;});
sap.ui.predefine('sap/ui/unified/CalendarRowRenderer',['sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarLegendRenderer','sap/ui/Device','sap/ui/unified/library','sap/ui/core/IconPool','sap/ui/core/InvisibleText',"sap/base/Log"],function(U,C,a,D,l,I,b,L){"use strict";var c=l.CalendarDayType;var d=l.CalendarIntervalType;var e=l.CalendarAppointmentVisualization;var f=l.CalendarAppointmentHeight;var g={apiVersion:2};
g.render=function(r,R){var t=R.getTooltip_AsString();var v=R.getAppointmentsVisualization();var T=this.getLegendItems(R);r.openStart("div",R);r.class("sapUiCalendarRow");if(!D.system.phone&&R.getAppointmentsReducedHeight()){r.class("sapUiCalendarRowAppsRedHeight");}if(v!=e.Standard){r.class("sapUiCalendarRowVis"+v);}if(t){r.attr("title",t);}var w=R.getWidth();if(w){r.style("width",w);}var h=R.getHeight();if(h){r.style("height",h);}r.accessibilityState(R);r.openEnd();this.renderAppointmentsRow(r,R,T);r.close("div");};
g.renderAppointmentsRow=function(r,R,t){var i=R.getId();r.openStart("div",i+"-Apps");r.class("sapUiCalendarRowApps");r.openEnd();this.renderBeforeAppointments(r,R);this.renderAppointments(r,R,t);this.renderAfterAppointments(r,R);r.close("div");};
g.renderBeforeAppointments=function(r,R){};
g.renderAfterAppointments=function(r,R){};
g.renderResizeHandle=function(r,R,A){};
g.renderAppointments=function(r,R,t){var A=R._getVisibleAppointments();var h=R._getVisibleIntervalHeaders();var s=R._getStartDate();var n=[];var S=0;var N=0;var j=[];var k=0;var m=0;var o=R.getIntervals();var p=R.getIntervalType();var w=100/o;var i=0;var q=new U(s);var F=false;var u=false;switch(p){case d.Hour:n=R.getNonWorkingHours()||[];S=s.getUTCHours();N=24;break;case d.Day:case d.Week:case d.OneMonth:case"OneMonth":n=R._getNonWorkingDays();S=s.getUTCDay();N=7;j=R.getNonWorkingHours()||[];k=s.getUTCHours();m=24;break;case d.Month:j=R._getNonWorkingDays();k=s.getUTCDay();m=7;break;default:break;}if(R._isOneMonthsRowOnSmallSizes()){this.renderSingleDayInterval(r,R,A,t,h,n,S,N,j,k,m,true,true);}else{for(i=0;i<o;i++){if(u){F=true;}else{F=false;}u=false;switch(p){case d.Hour:q.setUTCHours(q.getUTCHours()+1);if(q.getUTCHours()==0){u=true;}break;case d.Day:case d.Week:case d.OneMonth:case"OneMonth":q.setUTCDate(q.getUTCDate()+1);if(q.getUTCDate()==1){u=true;}break;case d.Month:k=q.getUTCDay();q.setUTCMonth(q.getUTCMonth()+1);if(q.getUTCMonth()==0){u=true;}break;default:break;}this.renderInterval(r,R,i,w,h,n,S,N,j,k,m,F,u);}this.renderIntervalHeaders(r,R,w,h,o);if(!(R._getRelativeInfo&&R._getRelativeInfo().bIsRelative)){r.openStart("div",R.getId()+"-Now");r.class("sapUiCalendarRowNow");r.openEnd();r.close("div");}for(i=0;i<A.length;i++){var v=A[i];this.renderAppointment(r,R,v,t);}r.openStart("div",R.getId()+"-DummyApp");r.class("sapUiCalendarApp");r.class("sapUiCalendarAppTitleOnly");r.class("sapUiCalendarAppDummy");r.class("sapUiCalendarAppHeight1");r.openEnd();r.close("div");}};
g.writeCustomAttributes=function(r,R){};
g.renderInterval=function(r,R,h,w,k,n,s,N,m,S,o,F,p,A){var q=R.getId()+"-AppsInt"+h;var i;var t=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||k.length>0);var M=R.getStartDate().getMonth();var u=new Date(R.getStartDate().getFullYear(),M+1,0).getDate();r.openStart("div",q);r.class("sapUiCalendarRowAppsInt");if(A){r.class(A);}r.style("width",w+"%");if(h>=u&&(R.getIntervalType()===d.OneMonth||R.getIntervalType()==="OneMonth")){r.class("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((h+s)%N==n[i]){r.class("sapUiCalendarRowAppsNoWork");break;}}if(!t){r.class("sapUiCalendarRowAppsIntNoHead");}if(F){r.class("sapUiCalendarRowAppsIntFirst");}if(p){r.class("sapUiCalendarRowAppsIntLast");}this.writeCustomAttributes(r,R);r.openEnd();if(t){r.openStart("div");r.class("sapUiCalendarRowAppsIntHead");r.openEnd();r.close("div");}if(R.getShowSubIntervals()){var v=R.getIntervalType();var x=0;switch(v){case d.Hour:x=4;break;case d.Day:case d.Week:case d.OneMonth:case"OneMonth":x=24;break;case d.Month:var y=R._getStartDate();var z=new U(y);z.setUTCMonth(z.getUTCMonth()+h+1,0);x=z.getUTCDate();z.setUTCDate(1);s=z.getUTCDay();break;default:break;}var B=100/x;for(i=0;i<x;i++){r.openStart("div");r.class("sapUiCalendarRowAppsSubInt");r.style("width",B+"%");for(var j=0;j<m.length;j++){if((i+S)%o==m[j]){r.class("sapUiCalendarRowAppsNoWork");break;}}r.openEnd();r.close("div");}}r.close("div");};
g.renderIntervalHeaders=function(r,R,w,h,j){var s=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||h.length>0);if(s){for(var i=0;i<h.length;i++){var o=h[i],k,m;if(R._bRTL){m=w*o.interval;k=w*(j-o.last-1);}else{k=w*o.interval;m=w*(j-o.last-1);}this.renderIntervalHeader(r,R,o,R._bRTL,k,m);}}};
g.renderIntervalHeader=function(r,R,i,h,j,k){var s=i.appointment.getId(),A={labelledby:{value:s+"-Descr",append:true}},S;var o=R._calculateAppoitnmentVisualCue(i.appointment);r.openStart("div",i.appointment);r.class("sapUiCalendarRowAppsIntHead");if(j!==undefined){r.style("left",j+"%");}if(k!==undefined){r.style("right",k+"%");}r.class("sapUiCalendarRowAppsIntHeadFirst");if(i.appointment.getSelected()){r.class("sapUiCalendarRowAppsIntHeadSel");}if(i.appointment.getTentative()){r.class("sapUiCalendarRowAppsIntHeadTent");}var t=i.appointment.getTooltip_AsString();if(t){r.attr("title",t);}var T=i.appointment.getType();var m=i.appointment.getColor();if(!m&&T&&T!=c.None){r.class("sapUiCalendarRowAppsIntHead"+T);}if(m){if(h){r.style("border-right-color",m);}else{r.style("border-left-color",m);}}r.accessibilityState(i.appointment,A);r.openEnd();r.openStart("div");r.class("sapUiCalendarIntervalHeaderCont");if(m){r.style("background-color",i.appointment._getCSSColorForBackground(m));}r.openEnd();if(o.appTimeUnitsDifRowStart>0){r.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"});}var n=i.appointment.getIcon();if(n){var p=["sapUiCalendarRowAppsIntHeadIcon"];var q={};q["id"]=s+"-Icon";q["title"]=null;q["role"]="img";r.icon(n,p,q);}var u=i.appointment.getTitle();if(u){r.openStart("span",s+"-Title");r.class("sapUiCalendarRowAppsIntHeadTitle");r.openEnd();r.text(u);r.close("span");}var v=i.appointment.getText();if(v){r.openStart("span",s+"-Text");r.class("sapUiCalendarRowAppsIntHeadText");r.openEnd();r.text(v);r.close("span");}if(o.appTimeUnitsDifRowEnd>0){r.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"});}S=R._oRb.getText("CALENDAR_START_TIME")+": "+R._oFormatAria.format(i.appointment.getStartDate())+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+R._oFormatAria.format(i.appointment.getEndDate());if(T&&T!==c.None){S+="; "+this.getAriaTextForType(T,this.getLegendItems(R));}r.openStart("span",s+"-Descr");r.class("sapUiInvisibleText");r.openEnd();r.text(S);r.close("span");r.close("div");r.close("div");};
g.renderAppointment=function(r,R,A,t,h){var o=A.appointment;var T=o.getTooltip_AsString();var s=o.getType();var i=o.getColor();var j=o.getTitle();var k=o.getText();var m=o.getDescription();var n=o.getIcon();var p=o.getId();var q=R._getAppointmentReducedHeight(A);var u={labelledby:{value:b.getStaticId("sap.ui.unified","APPOINTMENT")+" "+p+"-Descr",append:true},selected:null};var v=R._getAppointmentRowCount(A,q);var w=R.getAriaLabelledBy();var x=R._calculateAppoitnmentVisualCue(o);if(w.length>0){u["labelledby"].value=u["labelledby"].value+" "+w.join(" ");}if(j){u["labelledby"].value=u["labelledby"].value+" "+p+"-Title";}if(k){u["labelledby"].value=u["labelledby"].value+" "+p+"-Text";}r.openStart("div",o);r.class("sapUiCalendarApp");r.class("sapUiCalendarAppHeight"+v);if(o.getSelected()){r.class("sapUiCalendarAppSel");u["labelledby"].value=u["labelledby"].value+" "+b.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED");}if(o.getTentative()){r.class("sapUiCalendarAppTent");u["labelledby"].value=u["labelledby"].value+" "+b.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE");}if(v===1){r.class("sapUiCalendarAppTitleOnly");}if(n){r.class("sapUiCalendarAppWithIcon");}if(!h){if(R._bRTL){r.style("right",A.begin+"%");r.style("left",A.end+"%");}else{r.style("left",A.begin+"%");r.style("right",A.end+"%");}}r.attr("data-sap-level",A.level);if(R._sFocusedAppointmentId==p){r.attr("tabindex","0");}else{r.attr("tabindex","-1");}if(T){r.attr("title",T);}if(!i&&s&&s!=c.None){r.class("sapUiCalendarApp"+s);}if(i){if(R._bRTL){r.style("border-right-color",i);}else{r.style("border-left-color",i);}}r.accessibilityState(o,u);r.openEnd();r.openStart("div");r.class("sapUiCalendarAppCont");if(i&&R.getAppointmentsVisualization()===e.Filled){r.style("background-color",o._getCSSColorForBackground(i));}r.openEnd();if(o.getCustomContent().length){o.getCustomContent().forEach(function(F){r.renderControl(F);});}else{if(x.appTimeUnitsDifRowStart>0){r.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"});}if(n){var y=["sapUiCalendarAppIcon"];var z={};z["id"]=p+"-Icon";z["title"]=null;z["role"]="img";r.icon(n,y,z);}r.openStart("div");r.class("sapUiCalendarAppTitleWrapper");r.openEnd();if(j){r.openStart("span",p+"-Title");r.class("sapUiCalendarAppTitle");r.openEnd();r.text(j);r.close("span");}if(k&&A.size!==f.HalfSize){r.openStart("span",p+"-Text");r.class("sapUiCalendarAppText");r.openEnd();r.text(k);r.close("span");}if(m&&A.size!==f.HalfSize&&(A.size!==f.Regular||!k)){r.openStart("span",p+"-Info");r.class("sapUiCalendarAppDescription");r.openEnd();r.text(m);r.close("span");}r.close("div");if(x.appTimeUnitsDifRowEnd>0){r.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"});}}var B=R._oRb.getText("CALENDAR_START_TIME")+": "+R._oFormatAria.format(o.getStartDate());B=B+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+R._oFormatAria.format(o.getEndDate());if(R._getRelativeInfo&&R._getRelativeInfo().bIsRelative){var E=R._getRelativeInfo();B=R._oRb.getText("CALENDAR_START_TIME")+": "+E.intervalLabelFormatter(E._getIndexFromDate(o.getStartDate()));B=B+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+E.intervalLabelFormatter(E._getIndexFromDate(o.getEndDate()));}if(s&&s!=c.None){B=B+"; "+this.getAriaTextForType(s,t);}r.openStart("span",p+"-Descr");r.class("sapUiInvisibleText");r.openEnd();r.text(B);r.close("span");r.close("div");this.renderResizeHandle(r,R,o);r.close("div");};
g.renderSingleDayInterval=function(r,R,A,t,h,n,s,N,k,S,m,F,o){var p=1,w=100,q=R.getId()+"-AppsInt"+p,i,u=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||h.length>0),v=new Date(R.getStartDate()),M=v.getMonth(),x=new Date(v.getFullYear(),M+1,0).getDate(),y,P=R._getPlanningCalendar(),z,B,E=[];v.setHours(0,0,0,0);z=A.concat(R.getIntervalHeaders().filter(function(W){var X=W.getStartDate().getTime(),Y=W.getEndDate().getTime(),Z=v.getTime(),$=Z+1000*60*60*24;return!(X>=$||Y<=Z);}).map(function(W){return{appointment:W,isHeader:true};})).sort(C._getComparer(v));if(P){E=P._getSelectedDates();}r.openStart("div",q);r.class("sapUiCalendarRowAppsInt");r.class("sapUiCalendarMonthRowAppsS");r.style("width",w+"%");if(p>=x&&(R.getIntervalType()===d.OneMonth||R.getIntervalType()==="OneMonth")){r.class("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((p+s)%N==n[i]){r.class("sapUiCalendarRowAppsNoWork");break;}}if(!u){r.class("sapUiCalendarRowAppsIntNoHead");}if(F){r.class("sapUiCalendarRowAppsIntFirst");}if(o){r.class("sapUiCalendarRowAppsIntLast");}r.openEnd();if(u){r.openStart("div");r.class("sapUiCalendarRowAppsIntHead");r.openEnd();r.close("div");}if(E.length>0){var G=0,H=z.length;if(P.getRows()[0]._calculateVisibleAppointments){var J=P.getRows()[0]._calculateVisibleAppointments(E,z);G=J.iStart;H=J.iEnd;}for(i=G;i<H;i++){B=z[i];r.openStart("div");r.class("sapUiCalendarAppContainer");r.openEnd();r.openStart("div");r.class("sapUiCalendarAppContainerLeft");r.openEnd();r.openStart("div");r.class("sapUiCalendarAppStart");r.openEnd();r.text(B.appointment._getDateRangeIntersectionText(v).start);r.close("div");r.openStart("div");r.class("sapUiCalendarAppEnd");r.openEnd();r.text(B.appointment._getDateRangeIntersectionText(v).end);r.close("div");r.close("div");r.openStart("div");r.class("sapUiCalendarAppContainerRight");r.openEnd();if(B.isHeader){this.renderIntervalHeader(r,R,B);}else{this.renderAppointment(r,R,B,t,true);}r.close("div");r.close("div");}}if(A.length===0||E.length===0){r.openStart("div");r.class("sapUiCalendarNoApps");r.openEnd();var K=sap.ui.getCore().byId(R.getAssociation("row"));y=K.getNoAppointmentsText()?K.getNoAppointmentsText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");r.text(y);r.close("div");}if(!(R._getRelativeInfo&&R._getRelativeInfo().bIsRelative)){r.openStart("div",R.getId()+"-Now");r.class("sapUiCalendarRowNow");r.openEnd();}r.close("div");r.openStart("div",R.getId()+"-DummyApp");r.class("sapUiCalendarApp");r.class("sapUiCalendarAppTitleOnly");r.class("sapUiCalendarAppDummy");r.style("margin","0");r.style("height","0px");r.openEnd();r.close("div");if(R.getShowSubIntervals()){var O=R.getIntervalType();var Q=0;switch(O){case d.Hour:Q=4;break;case d.Day:case d.Week:case d.OneMonth:case"OneMonth":Q=24;break;case d.Month:var T=new U(v);T.setUTCMonth(T.getUTCMonth()+p+1,0);Q=T.getUTCDate();T.setUTCDate(1);s=T.getUTCDay();break;default:break;}var V=100/Q;for(i=0;i<Q;i++){r.openStart("div");r.class("sapUiCalendarRowAppsSubInt");r.style("width",V+"%");for(var j=0;j<k.length;j++){if((i+S)%m==k[j]){r.class("sapUiCalendarRowAppsNoWork");break;}}r.openEnd();r.close("div");}}r.close("div");};
g.getLegendItems=function(o){var r=[],h,s=o.getLegend();if(s){h=sap.ui.getCore().byId(s);if(h){r=h.getItems();}else{L.error("CalendarLegend with id '"+s+"' does not exist!",o);}}return r;};
g.getAriaTextForType=function(t,h){var T,s,o,i;if(h&&h.length){for(var i=0;i<h.length;i++){o=h[i];if(o.getType()===t){T=o.getText();break;}}}if(!T){s=a.getTypeAriaText(t);if(s){T=s.getText();}}return T;};
return g;},true);
sap.ui.predefine('sap/ui/unified/CalendarTimeInterval',["sap/m/Popover","sap/ui/core/Core",'sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange","sap/ui/unified/Calendar"],function(P,C,a,L,b,H,T,D,M,Y,U,l,c,d,e,f,g,h,i,j,k,q,m,n){"use strict";
var o=a.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},_currentPicker:{type:"string",group:"Appearance",defaultValue:"timesRow",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
var p={TIMES_ROW:"timesRow",DATES_ROW:"datesRow",MONTH_PICKER:"monthPicker",YEAR_PICKER:"yearPicker"};
o.prototype.init=function(){this._iMode=0;this._oYearFormat=c.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initializeMonthPicker();this._initializeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};
o.prototype._initializeHeader=function(){var c1=new H(this.getId()+"--Head");c1.attachEvent("pressPrevious",this._handlePrevious,this);c1.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",c1);};
o.prototype._initializeTimesRow=function(){var c1=new T(this.getId()+"--TimesRow");c1.attachEvent("focus",N,this);c1.attachEvent("select",K,this);c1._bNoThemeChange=true;this.setAggregation("timesRow",c1);};
o.prototype._initializeMonthPicker=function(){var c1=this._createMonthPicker();this.setAggregation("monthPicker",c1);c1._setSelectedDatesControlOrigin(this);};
o.prototype._initializeYearPicker=function(){var c1=this._createYearPicker();this.setAggregation("yearPicker",c1);c1._setSelectedDatesControlOrigin(this);};
o.prototype._createDatesRow=function(){var c1=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new m(this.getId()+"--Range")]});c1.attachEvent("focus",R,this);c1.attachEvent("select",Q,this);c1._bNoThemeChange=true;c1.getIntervalSelection=function(){return this.getProperty("intervalSelection");};c1.getSingleSelection=function(){return this.getProperty("singleSelection");};c1.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};c1.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};c1.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return c1;};
o.prototype._createMonthPicker=function(){var c1=new M(this.getId()+"--MP",{columns:0,months:6});c1.attachEvent("select",S,this);c1._bNoThemeChange=true;c1.attachEvent("pageChange",a1,this);return c1;};
o.prototype._createYearPicker=function(){var c1=new Y(this.getId()+"--YP",{columns:0,years:6});c1.attachEvent("select",V,this);c1.attachEvent("pageChange",b1,this);c1._oMinDate.setYear(this._oMinDate.getUTCFullYear());c1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return c1;};
o.prototype.exit=function(){if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}if(this._oCalendar){this._oCalendar.removeDelegate(this._oFocusCalendarDelegate);this._oCalendar.destroy();this._oCalendar=null;}if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};
o.prototype.onBeforeRendering=function(){var c1=this.getAggregation("timesRow");var d1=this._getFocusedDate();y.call(this);c1.displayDate(b._createLocalDate(d1,true));};
o.prototype._setAriaRole=function(c1){var d1=this.getAggregation("timesRow");d1._setAriaRole(c1);d1.invalidate();return this;};
o.prototype._getCalendar=function(){var c1;if(!this._oCalendar){c1=new n(this.getId()+"--Cal",{});c1.setPopupMode(true);c1.attachEvent("select",O,this);c1.attachEvent("cancel",function(d1){this._oPopup.close();var e1=this.getAggregation("header").getDomRef("B1");if(e1){e1.focus();}},this);this._oFocusCalendarDelegate={onAfterRendering:function(){this.focus();}};c1.addDelegate(this._oFocusCalendarDelegate,c1);this._oCalendar=c1;}return this._oCalendar;};
o.prototype._getMonthPicker=function(){return this.getAggregation("monthPicker");};
o.prototype._getYearPicker=function(){return this.getAggregation("yearPicker");};
o.prototype.setStartDate=function(c1){b._checkJSDateObject(c1);if(i(this.getStartDate(),c1)){return this;}var d1=c1.getFullYear();b._checkYearInValidRange(d1);var e1=this.getMinDate();if(e1&&c1.getTime()<e1.getTime()){k.warning("startDate < minDate -> minDate as startDate set",this);c1=new Date(e1);}var f1=this.getMaxDate();if(f1&&c1.getTime()>f1.getTime()){k.warning("startDate > maxDate -> maxDate as startDate set",this);c1=new Date(f1);}this.setProperty("startDate",c1);var g1=this.getAggregation("timesRow");g1.setStartDate(c1);this._oUTCStartDate=new U(g1._getStartDate().getTime());y.call(this);var h1=b._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(h1)){this._setFocusedDate(this._oUTCStartDate);g1.displayDate(c1);}return this;};
o.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("selectedDates");return c1;};
o.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("selectedDates");return c1;};
o.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var c1=this.removeAllAggregation("specialDates");return c1;};
o.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var c1=this.destroyAggregation("specialDates");return c1;};
o.prototype.setIntervalMinutes=function(c1){if(c1>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%c1>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",c1);var d1=this.getAggregation("timesRow");var e1=b._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=r.call(this);this._setFocusedDate(f1);d1.setDate(b._createLocalDate(f1,true));}return this;};
o.prototype.setLocale=function(c1){if(this._sLocale!=c1){this._sLocale=c1;this._oLocaleData=undefined;this.invalidate();}return this;};
o.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=C.getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
o.prototype._getFocusedDate=function(){if(!this._oFocusedDate){t.call(this);}return this._oFocusedDate;};
o.prototype._setFocusedDate=function(c1){if(!(c1 instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(c1.getTime());};
o.prototype.focusDate=function(c1){var d1=false;var e1=this.getAggregation("timesRow");if(!e1.checkDateFocusable(c1)){var f1=b._createUniversalUTCDate(c1,undefined,true);W.call(this,f1);d1=true;}F.call(this,c1,false);if(d1){this.fireStartDateChange();}return this;};
o.prototype.displayDate=function(c1){F.call(this,c1,true);return this;};
o.prototype.setItems=function(c1){this.setProperty("items",c1);c1=this._getItems();var d1=this.getAggregation("timesRow");d1.setItems(c1);var e1=b._createLocalDate(this._getFocusedDate(),true);if(!d1.checkDateFocusable(e1)){var f1=r.call(this);this._setFocusedDate(f1);d1.setDate(b._createLocalDate(f1,true));}if(!this.getPickerPopup()){var g1=this.getAggregation("datesRow");var h1=Math.floor(c1*1.5);if(h1>31){h1=31;}g1.setDays(h1);var i1=this._getMonthPicker();var j1=Math.floor(c1/2);if(j1>12){j1=12;}i1.setMonths(j1);var k1=this._getYearPicker();var l1=Math.floor(c1/2);if(l1>20){l1=20;}k1.setYears(l1);}y.call(this);return this;};
o.prototype._getItems=function(){var c1=this.getItems();if(d.system.phone&&c1>6){return 6;}else{return c1;}};
o.prototype._getLocaleData=function(){if(!this._oLocaleData){var c1=this.getLocale();var d1=new e(c1);this._oLocaleData=L.getInstance(d1);}return this._oLocaleData;};
o.prototype.setPickerPopup=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;this.setProperty("pickerPopup",c1);if(e1){e1.destroy();}if(c1){d1.setVisibleButton0(false);d1.setVisibleButton1(true);d1.setVisibleButton2(false);d1.detachEvent("pressButton1",I,this);d1.attachEvent("pressButton1",I,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this._getMonthPicker()){this._getMonthPicker().destroy();}if(this._getYearPicker()){this._getYearPicker().destroy();}}else{d1.setVisibleButton0(true);d1.setVisibleButton1(true);d1.setVisibleButton2(true);d1.detachEvent("pressButton0",G,this);d1.attachEvent("pressButton0",G,this);d1.detachEvent("pressButton1",I,this);d1.attachEvent("pressButton1",I,this);d1.detachEvent("pressButton2",J,this);d1.attachEvent("pressButton2",J,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this._getYearPicker()){this.setAggregation("yearPicker",this._createYearPicker());}if(!this._getMonthPicker()){this.setAggregation("monthPicker",this._createMonthPicker());}f1=this._getMonthPicker();g1=this._getYearPicker();f1.setColumns(0);f1.setMonths(6);g1.setColumns(0);g1.setYears(6);}return this;};
o.prototype.setMinDate=function(c1){var d1,e1,f1,g1;if(i(c1,this.getMinDate())){return this;}if(!c1){b._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{b._checkJSDateObject(c1);this._oMinDate=b._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMinDate=d1._getIntervalStart(this._oMinDate);e1=this._oMinDate.getUTCFullYear();b._checkYearInValidRange(e1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=b._createUniversalUTCDate(c1,undefined,true);b._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",b._createLocalDate(this._oMaxDate,true));}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){k.warning("focused date < minDate -> minDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){k.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",c1);if(this.getPickerPopup()){g1=this._getCalendar();g1.setMinDate(c1);}else{f1=this._getYearPicker();f1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};
o.prototype.setMaxDate=function(c1){var d1,e1,f1,g1,h1,i1;if(i(c1,this.getMaxDate())){return this;}if(!c1){b._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{b._checkJSDateObject(c1);this._oMaxDate=b._createUniversalUTCDate(c1,undefined,true);d1=this.getAggregation("timesRow");this._oMaxDate=d1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);e1=this._oMaxDate.getUTCFullYear();b._checkYearInValidRange(e1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=b._createUniversalUTCDate(c1,undefined,true);b._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",b._createLocalDate(this._oMinDate,true));}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){k.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(c1);}}if(this._oUTCStartDate){f1=new U(this._oUTCStartDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()>this._oMaxDate.getTime()){g1=new U(this._oMaxDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()>=this._oMinDate.getTime()){k.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,g1,true,true);}}}}this.setProperty("maxDate",c1);if(this.getPickerPopup()){i1=this._getCalendar();i1.setMaxDate(c1);}else{h1=this._getYearPicker();h1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};
o.prototype.onclick=function(c1){if(c1.isMarked("delayedMouseEvent")){return;}if(c1.target.id==this.getId()+"-cancel"){this.onsapescape(c1);}};
o.prototype.onmousedown=function(c1){c1.preventDefault();c1.setMark("cancelAutoClose");};
o.prototype.onsapescape=function(c1){if(this.getPickerPopup()){u.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:case 2:case 3:this.setProperty("_currentPicker",p.TIMES_ROW);break;}}};
o.prototype.onsaptabnext=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(h(this.getDomRef("content"),c1.target)){if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B0")){d1.getDomRef("B0").focus();}if(!this._bPoupupMode){g1=this.getAggregation("timesRow");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){e1=this._getMonthPicker();f1=this._getYearPicker();if(e1.getDomRef()){q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B0"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(!this.getPickerPopup()&&(c1.target.id==d1.getId()+"-B1")){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}};
o.prototype.onsaptabprevious=function(c1){var d1=this.getAggregation("header"),e1,f1,g1;if(h(this.getDomRef("content"),c1.target)){if(this._bPoupupMode){if(d1.getDomRef("B2")){d1.getDomRef("B2").focus();}c1.preventDefault();}}else if(c1.target.id==d1.getId()+"-B0"){g1=this.getAggregation("timesRow");switch(this._iMode){case 0:g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){e1=this._getMonthPicker();e1._oItemNavigation.focusItem(e1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){f1=this._getYearPicker();f1._oItemNavigation.focusItem(f1._oItemNavigation.getFocusedIndex());}break;}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B2"){if(d1.getDomRef("B1")){d1.getDomRef("B1").focus();}c1.preventDefault();}else if(c1.target.id==d1.getId()+"-B1"){if(!this.getPickerPopup()){if(d1.getDomRef("B0")){d1.getDomRef("B0").focus();}}else{g1=this.getAggregation("timesRow");g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());}c1.preventDefault();}};
o.prototype.onfocusin=function(c1){if(c1.target.id==this.getId()+"-end"){var d1=this.getAggregation("header"),e1,f1,g1;if(this.getPickerPopup()&&d1.getDomRef("B1")){d1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&d1.getDomRef("B2")){d1.getDomRef("B2").focus();}if(!this._bPoupupMode){e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){f1=this._getMonthPicker();g1=this._getYearPicker();if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};
o.prototype.onsapfocusleave=function(c1){if(!c1.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(c1.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var d1,e1,f1;switch(this._iMode){case 0:d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){e1=this._getMonthPicker();q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){f1=this._getYearPicker();q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};
o.prototype.setProperty=function(){var c1=arguments[0],d1=arguments[1];a.prototype.setProperty.apply(this,arguments);if(c1==="_currentPicker"){switch(d1){case"timesRow":this._iMode=0;break;case"datesRow":this._iMode=1;break;case"monthPicker":this._iMode=2;break;case"yearPicker":this._iMode=3;break;default:return;}}return this;};
o.prototype._handlePrevious=function(c1){var d1=this._getFocusedDate(),e1,f1,g1,h1,i1,j1,k1,l1;switch(this._iMode){case 0:e1=this._getItems();f1=new U(r.call(this).getTime());g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()-e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()-e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){h1=this.getAggregation("datesRow");i1=b._createUniversalUTCDate(h1.getDate());j1=h1.getDays();if(i1.getUTCDate()<=j1){i1.setUTCDate(1);}else{i1.setUTCDate(i1.getUTCDate()-j1);}X.call(this,i1);}break;case 2:if(!this.getPickerPopup()){k1=this._getMonthPicker();if(k1.getMonths()<12){k1.previousPage();z.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()-1);W.call(this,d1);this._setFocusedDate(d1);y.call(this);$.call(this,d1.getUTCFullYear(),k1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){l1=this._getYearPicker();l1.previousPage();A.call(this);}break;}};
o.prototype._handleNext=function(c1){var d1=this._getFocusedDate();switch(this._iMode){case 0:var e1=this._getItems();var f1=new U(r.call(this).getTime());var g1=this.getIntervalMinutes();f1.setUTCMinutes(f1.getUTCMinutes()+e1*g1);d1.setUTCMinutes(d1.getUTCMinutes()+e1*g1);this._setFocusedDate(d1);_.call(this,f1,true);break;case 1:if(!this.getPickerPopup()){var h1=this.getAggregation("datesRow");var i1=b._createUniversalUTCDate(h1.getDate());var j1=new U(i1.getTime());j1.setUTCDate(1);j1.setUTCMonth(j1.getUTCMonth()+1);j1.setUTCDate(0);var k1=h1.getDays();if(i1.getUTCDate()+k1>j1.getUTCDate()){i1.setUTCDate(j1.getUTCDate());}else{i1.setUTCDate(i1.getUTCDate()+k1);}X.call(this,i1);}break;case 2:if(!this.getPickerPopup()){var l1=this._getMonthPicker();if(l1.getMonths()<12){l1.nextPage();z.call(this);}else{d1.setUTCFullYear(d1.getUTCFullYear()+1);W.call(this,d1);this._setFocusedDate(d1);y.call(this);$.call(this,d1.getUTCFullYear(),l1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var m1=this._getYearPicker();m1.nextPage();A.call(this);}break;}};
o.prototype._getShowItemHeader=function(){var c1=this.getItems();if(c1>this._iItemsHead){return true;}else{return false;}};
function _(c1,d1,e1){var f1=new U(this._oMaxDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(f1.getTime()<this._oMinDate.getTime()){f1=new U(this._oMinDate.getTime());f1.setUTCMinutes(f1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(c1.getTime()<this._oMinDate.getTime()){c1=new U(this._oMinDate.getTime());}else if(c1.getTime()>f1.getTime()){c1=f1;}var g1=this.getAggregation("timesRow");var h1=b._createLocalDate(c1,true);g1.setStartDate(h1);this._oUTCStartDate=new U(g1._getStartDate().getTime());h1=b._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",h1);y.call(this);if(d1){var i1=b._createLocalDate(this._getFocusedDate(),true);if(!g1.checkDateFocusable(i1)){this._setFocusedDate(c1);g1.setDate(h1);}else{g1.setDate(i1);}}if(!e1){this.fireStartDateChange();}}
function r(){if(!this._oUTCStartDate){var c1=this.getAggregation("timesRow");c1.setStartDate(b._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(c1._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}
function s(c1){var d1=this._getFocusedDate();var e1=this.getAggregation("timesRow");if(!c1){e1.setDate(b._createLocalDate(d1,true));}else{e1.displayDate(b._createLocalDate(d1,true));}y.call(this);}
function t(){var c1=this.getSelectedDates();if(c1&&c1[0]&&c1[0].getStartDate()){this._oFocusedDate=b._createUniversalUTCDate(c1[0].getStartDate(),undefined,true);}else{var d1=new Date();this._oFocusedDate=b._createUniversalUTCDate(d1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}
o.prototype._showCalendarPicker=function(){var c1=b._createLocalDate(this._getFocusedDate(),true);var d1=this._getCalendar();var e1=new m({startDate:c1});d1.displayDate(c1,false);d1.removeAllSelectedDates();d1.addSelectedDate(e1);d1.setMinDate(this.getMinDate());d1.setMaxDate(this.getMaxDate());Z.call(this,d1);this._showOverlay();};
o.prototype._showOverlay=function(){this.$("contentOver").css("display","");};
o.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};
function u(c1){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!c1){s.call(this);var d1=this.getAggregation("timesRow");q(d1._oItemNavigation.getItemDomRefs()[d1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}this._getCalendar()._closePickers();}
function v(){var c1=this._getFocusedDate();var d1=this._getItems();var e1=this.getAggregation("datesRow");var f1=e1.getSelectedDates()[0];f1.setStartDate(b._createLocalDate(c1,true));var g1=new U(c1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=g1.getUTCDate();var i1=Math.floor(d1*1.5);if(i1>h1){i1=h1;}e1.setDays(i1);this.setProperty("_currentPicker",p.DATES_ROW);this._showOverlay();X.call(this,c1);if(this._iMode==0){var j1=this.getAggregation("timesRow");q(j1._oItemNavigation.getItemDomRefs()[j1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}
function w(){var c1=this._getFocusedDate();var d1=this._getMonthPicker();this.setProperty("_currentPicker",p.MONTH_PICKER);this._showOverlay();d1.setMonth(c1.getUTCMonth());$.call(this,c1.getUTCFullYear(),d1);if(this._iMode==0){var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;z.call(this);}
function x(){var c1=this._getFocusedDate();var d1=this._getYearPicker();this.setProperty("_currentPicker",p.YEAR_PICKER);this._showOverlay();d1.setDate(c1.getJSDate());if(this._iMode==0){var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}A.call(this);this._iMode=3;}
function y(){B.call(this);z.call(this);}
function z(c1){var d1=new U(r.call(this).getTime());var e1=this._getItems();var f1=d1.getJSDate().getUTCFullYear();var g1=this._oMaxDate.getJSDate().getUTCFullYear();var h1=this._oMinDate.getJSDate().getUTCFullYear();var i1=d1.getJSDate().getUTCMonth();var j1=this._oMaxDate.getJSDate().getUTCMonth();var k1=this._oMinDate.getJSDate().getUTCMonth();var l1=d1.getJSDate().getUTCDate();var m1=this._oMaxDate.getJSDate().getUTCDate();var n1=this._oMinDate.getJSDate().getUTCDate();var o1=d1.getJSDate().getUTCHours();var p1=this._oMaxDate.getJSDate().getUTCHours();var q1=this._oMinDate.getJSDate().getUTCHours();var r1=d1.getJSDate().getUTCMinutes();var s1=this._oMaxDate.getJSDate().getUTCMinutes();var t1=this._oMinDate.getJSDate().getUTCMinutes();var u1=this.getAggregation("header");if(this._iMode==2&&!c1){var v1=this._getMonthPicker();var w1=v1.getMonths();var x1=v1.getStartMonth();var y1=x1+w1-1;if(x1==0||(f1==h1&&x1<=k1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if(y1>10||(f1==g1&&y1>=j1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}return;}if((f1<h1||(f1==h1&&(c1||(i1<k1||(i1==k1&&(l1<n1||(l1==n1&&(o1<q1||(o1==q1&&r1<=t1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}d1.setUTCMinutes(d1.getUTCMinutes()+(e1)*this.getIntervalMinutes()-1);f1=d1.getJSDate().getUTCFullYear();i1=d1.getJSDate().getUTCMonth();l1=d1.getJSDate().getUTCDate();o1=d1.getJSDate().getUTCHours();r1=d1.getJSDate().getUTCMinutes();if((f1>g1||(f1==g1&&(!c1||(i1>j1||(i1==j1&&(l1>m1||(l1==m1&&(o1>p1||(o1==p1&&r1>=s1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}if(this._iMode===1){var z1=new U(d1.getTime());z1.setUTCDate(1);z1.setUTCMonth(z1.getUTCMonth()+1);z1.setUTCDate(0);var A1=this.getAggregation("datesRow").getDays();d1.setUTCDate(1+(Math.ceil(d1.getUTCDate()/A1)-1)*A1);if(z1.getUTCDate()-d1.getUTCDate()<A1){d1.setUTCDate(z1.getUTCDate()-A1+1);}l1=d1.getUTCDate();if(l1<=1||(f1==h1&&i1==k1&&l1<=n1)){u1.setEnabledPrevious(false);}else{u1.setEnabledPrevious(true);}if((l1+A1)>=z1.getUTCDate()||(f1==g1&&i1==j1&&l1>=m1)){u1.setEnabledNext(false);}else{u1.setEnabledNext(true);}}}
function A(){var c1=this._getYearPicker();var d1=c1.getYears();var e1=b._createUniversalUTCDate(c1.getProperty("_middleDate").toLocalJSDate());e1.setUTCFullYear(e1.getUTCFullYear()+Math.floor(d1/2));var f1=this.getAggregation("header");var g1=new U(this._oMaxDate);g1.setUTCFullYear(g1.getUTCFullYear()-Math.ceil(d1/2));g1.setUTCMonth(11,31);var h1=new U(this._oMinDate);h1.setUTCFullYear(h1.getUTCFullYear()+Math.floor(d1/2)+1);h1.setUTCMonth(0,1);if(e1.getTime()>g1.getTime()){f1.setEnabledNext(false);}else{f1.setEnabledNext(true);}if(e1.getTime()<h1.getTime()){f1.setEnabledPrevious(false);}else{f1.setEnabledPrevious(true);}}
function B(){var c1=this.getAggregation("header");var d1;var e1=r.call(this);var f1;var g1=this._getLocaleData();var h1=[];var i1=[];var j1;var k1=false;var l1;var m1=false;if(g1.oLocale.sLanguage.toLowerCase()==="ja"||g1.oLocale.sLanguage.toLowerCase()==="zh"){l1=c.getDateInstance({format:"d"}).format(e1,true);}else{l1=(e1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){h1=g1.getMonthsStandAlone("wide");}else{k1=true;h1=g1.getMonthsStandAlone("abbreviated");i1=g1.getMonthsStandAlone("wide");}var n1=e1.getUTCMonth();d1=h1[n1];if(k1){j1=i1[h1[n1]];}if(!this.getPickerPopup()){c1.setTextButton0(l1);c1.setTextButton1(d1);c1.setTextButton2(this._oYearFormat.format(e1,true));}else{f1=c.getInstance({style:"long",strictParsing:true,relative:m1},g1.oLocale);j1=l1=f1.format(b._createLocalDate(e1,true));c1.setTextButton1(l1);}if(k1){c1.setAriaLabelButton1(j1);}}
function E(c1,d1){var e1;var f1=false;if(c1.getTime()<this._oMinDate.getTime()){e1=this._oMinDate;f1=true;}else if(c1.getTime()>this._oMaxDate.getTime()){e1=this._oMaxDate;f1=true;}else{e1=c1;}this._setFocusedDate(e1);if(f1||d1){W.call(this,e1);s.call(this,false);this.fireStartDateChange();}}
function F(c1,d1){if(c1&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=c1.getTime())){b._checkJSDateObject(c1);c1=b._createUniversalUTCDate(c1,undefined,true);var e1=c1.getUTCFullYear();b._checkYearInValidRange(e1);if(c1.getTime()<this._oMinDate.getTime()||c1.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(c1);if(this.getDomRef()&&this._iMode==0){s.call(this,d1);}}}
function G(c1){if(this._iMode!=1){v.call(this);}else{this.setProperty("_currentPicker",p.TIMES_ROW);}}
function I(c1){var d1;if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){d1=function(){var e1=this._getMonthPicker();e1._oItemNavigation.focusItem(e1.getProperty("_focusedMonth"));e1.removeDelegate(d1);};w.call(this);this._getMonthPicker().addDelegate({onAfterRendering:d1},this);}else{this.setProperty("_currentPicker",p.TIMES_ROW);}}}
function J(c1){var d1;if(this._iMode!=3){d1=function(){var e1=this._getYearPicker();e1.focus();e1.removeDelegate(d1);};x.call(this);this._getYearPicker().addDelegate({onAfterRendering:d1},this);}else{this.setProperty("_currentPicker",p.TIMES_ROW);}}
function K(c1){this.fireSelect();}
function N(c1){var d1=b._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var e1=c1.getParameter("notVisible");E.call(this,d1,e1);}
function O(c1){var d1=c1.getSource(),e1=d1.getSelectedDates()[0].getStartDate();var f1=new U(this._getFocusedDate().getTime());var g1=b._createUniversalUTCDate(e1);f1.setUTCFullYear(g1.getUTCFullYear());f1.setUTCMonth(g1.getUTCMonth(),g1.getUTCDate());E.call(this,f1,true);u.call(this);}
function Q(c1){var d1=new U(this._getFocusedDate().getTime());var e1=c1.oSource;var f1=e1.getSelectedDates()[0];var g1=b._createUniversalUTCDate(f1.getStartDate());if(!this.getPickerPopup()||g1.getUTCMonth()==d1.getUTCMonth()){d1.setUTCDate(g1.getUTCDate());d1.setUTCMonth(g1.getUTCMonth());d1.setUTCFullYear(g1.getUTCFullYear());E.call(this,d1,true);this.setProperty("_currentPicker",p.TIMES_ROW);}this._addTimesRowFocusDelegate();}
function R(c1){var d1=new U(this._getFocusedDate().getTime());var e1=b._createUniversalUTCDate(c1.getParameter("date"),undefined,true);var f1=c1.getParameter("otherMonth");if(f1&&e1.getUTCMonth()==d1.getUTCMonth()&&e1.getUTCFullYear()==d1.getUTCFullYear()){X.call(this,e1);}}
function S(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this._getMonthPicker();var f1=e1.getMonth();d1.setUTCMonth(f1);if(f1!=d1.getUTCMonth()){d1.setUTCDate(0);}E.call(this,d1,true);this.setProperty("_currentPicker",p.TIMES_ROW);this._addTimesRowFocusDelegate();}
function V(c1){var d1=new U(this._getFocusedDate().getTime());var e1=this._getYearPicker();var f1=b._createUniversalUTCDate(e1.getDate());var g1=d1.getUTCMonth();f1.setUTCMonth(d1.getUTCMonth(),d1.getUTCDate());f1.setUTCHours(d1.getUTCHours());f1.setUTCMinutes(d1.getUTCMinutes());d1=f1;if(g1!=d1.getUTCMonth()){d1.setUTCDate(0);}E.call(this,d1,true);this.setProperty("_currentPicker",p.TIMES_ROW);this._addTimesRowFocusDelegate();}
o.prototype._addTimesRowFocusDelegate=function(){var c1={onAfterRendering:function(){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());this.removeDelegate(c1);}},d1=this.getAggregation("timesRow");d1.addDelegate(c1,d1);};
function W(c1){var d1=this.getAggregation("timesRow");var e1=r.call(this);var f1=d1._oItemNavigation.getFocusedIndex();e1=new U(c1.getTime());e1.setUTCMinutes(e1.getUTCMinutes()-f1*this.getIntervalMinutes());_.call(this,e1,false,true);}
function X(c1){var d1=this.getAggregation("datesRow");var e1=this.getAggregation("header");if(!this.getPickerPopup()){var f1=new U(c1.getTime());f1.setUTCDate(1);f1.setUTCMonth(f1.getUTCMonth()+1);f1.setUTCDate(0);var g1=d1.getDays();var h1=new U(c1.getTime());h1.setUTCDate(1+(Math.ceil(c1.getUTCDate()/g1)-1)*g1);if(f1.getUTCDate()-h1.getUTCDate()<g1){h1.setUTCDate(f1.getUTCDate()-g1+1);}d1.setStartDate(b._createLocalDate(h1,true));var i1=h1.getJSDate().getUTCFullYear();var j1=this._oMaxDate.getJSDate().getUTCFullYear();var k1=this._oMinDate.getJSDate().getUTCFullYear();var l1=h1.getJSDate().getUTCMonth();var m1=this._oMaxDate.getJSDate().getUTCMonth();var n1=this._oMinDate.getJSDate().getUTCMonth();var o1=h1.getJSDate().getUTCDate();var p1=this._oMaxDate.getJSDate().getUTCDate();var q1=this._oMinDate.getJSDate().getUTCDate();if(o1<=1||(i1==k1&&l1==n1&&o1<=q1)){e1.setEnabledPrevious(false);}else{e1.setEnabledPrevious(true);}if((o1+g1)>=f1.getUTCDate()||(i1==j1&&l1==m1&&o1>=p1)){e1.setEnabledNext(false);}else{e1.setEnabledNext(true);}if(!this._oFocusDatesRowDelegate){this._oFocusDatesRowDelegate={onAfterRendering:function(){this.focus();}};d1.addDelegate(this._oFocusDatesRowDelegate,d1);}}else{e1.setEnabledPrevious(false);e1.setEnabledNext(false);}d1.setDate(b._createLocalDate(c1,true));}
function Z(c1){if(!this._oPopup){var d1=new P({placement:"VerticalPreferredBottom",showHeader:false,showArrow:false,verticalScrolling:false});d1.oPopup.setDurations(0,0);d1.addEventDelegate({onsapescape:this._oCalendar.onsapescape},this._oCalendar);this._oPopup=d1;}this._oPopup.addContent(c1);this._oPopup.attachAfterClose(function(){this._hideOverlay();this._addTimesRowFocusDelegate();},this);this._oPopup.attachAfterOpen(function(){var f1=e1.$("B1");var g1=this._oPopup.$();var h1=Math.floor((g1.width()-f1.width())/2);this._oPopup.setOffsetX(C.getConfiguration().getRTL()?h1:-h1);var i1=f1.height();this._oPopup.setOffsetY(this._oPopup._getCalculatedPlacement()==="Top"?i1:-i1);},this);var e1=this.getAggregation("header");this._oPopup.openBy(e1.getDomRef("B1"));}
function $(c1,d1){var e1=0;var f1=11;if(c1==this._oMinDate.getUTCFullYear()){e1=this._oMinDate.getUTCMonth();}if(c1==this._oMaxDate.getUTCFullYear()){f1=this._oMaxDate.getUTCMonth();}d1.setMinMax(e1,f1);}
function a1(c1){z.call(this);}
function b1(c1){A.call(this);}
return o;});
sap.ui.predefine('sap/ui/unified/CalendarTimeIntervalRenderer',[],function(){"use strict";var C={apiVersion:2};
C.render=function(r,c){var i=c.getId();var t=c.getTooltip_AsString();r.openStart("div",c);r.class("sapUiCal");r.class("sapUiCalInt");r.class("sapUiCalTimeInt");if(c._getShowItemHeader()){r.class("sapUiCalIntHead");}if(c.getPickerPopup()){r.class("sapUiCalIntLarge");}var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.accessibilityState(c,A);if(t){r.attr('title',t);}var w=c.getWidth();if(w&&w!=''){r.style("width",w);}r.openEnd();var h=c.getAggregation("header");r.renderControl(h);r.openStart("div",i+"-content");r.class("sapUiCalContent");r.openEnd();r.renderControl(c.getAggregation(c.getProperty("_currentPicker")));r.close("div");r.openStart("button",i+"-cancel");r.class("sapUiCalCancel");r.attr("tabindex","-1");r.openEnd();r.text(a.getText("CALENDAR_CANCEL"));r.close("button");r.openStart("div",i+"-end");r.style("width","0");r.style("height","0");r.style("position","absolute");r.style("right","0");r.style("bottom","0");r.attr("tabindex","0");r.openEnd();r.close("div");if(c.getPickerPopup()){r.openStart("div",i+"-contentOver");r.class("sapUiCalContentOver");if(!c._oPopup||!c._oPopup.isOpen()){r.style("display","none");}r.openEnd();r.close("div");}r.close("div");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarWeekInterval',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer',"sap/ui/unified/DateRange"],function(C,a,l,b,c,D){"use strict";
var d=b.extend("sap.ui.unified.CalendarWeekInterval",{renderer:c});
d.prototype._getDaysLarge=function(){return 6;};
d.prototype._handleFocus=function(e){var o=!!e.getParameter("_outsideBorder"),f,F,g;if(o){f=e.getParameter("date");this._oFocusDateWeek=a.fromLocalJSDate(f);F=C._getFirstDateOfWeek(this._oFocusDateWeek);g=this.getAggregation("month")[0];if(g.getDomRef()){this._setStartDate(F,false,true);}}return b.prototype._handleFocus.apply(this,arguments);};
d.prototype._focusDateExtend=function(o,O,n){var e,L;if(!this._oFocusDateWeek){return b.prototype._focusDateExtend.apply(this,arguments);}e=this.getAggregation("month")[0];L=this._oFocusDateWeek.toLocalJSDate();this._setFocusedDate(this._oFocusDateWeek);e.setDate(L);this._oFocusDateWeek=null;return!n;};
d.prototype._dateMatchesVisibleRange=function(o){var i=this.getDays(),e=a.fromLocalJSDate(o),s=a.fromLocalJSDate(this.getStartDate()),E=a.fromLocalJSDate(this.getStartDate());E.setDate(E.getDate()+i);return e.isSameOrAfter(s)&&e.isBefore(E);};
d.prototype._showCalendarPicker=function(){var o=this._getFocusedDate(),e=this._getStartDate(),f=this._getCalendar(),s=new D(),g;g=new a(e);g.setDate(g.getDate()+this._getDays()-1);s.setStartDate(e.toLocalJSDate());s.setEndDate(g.toLocalJSDate());f.displayDate(o.toLocalJSDate(),false);f.removeAllSelectedDates();f.addSelectedDate(s);f.setMinDate(this.getMinDate());f.setMaxDate(this.getMaxDate());this._openPickerPopup(f);};
d.prototype._handleCalendarPickerDateSelect=function(e){var o=this._getCalendar(),s=o.getSelectedDates()[0].getStartDate(),f=a.fromLocalJSDate(s),F;if(this._dateMatchesVisibleRange(f.toLocalJSDate())){this._oFocusDateWeek=f;this._focusDate(this._oFocusDateWeek,false,true);}else{F=C._getFirstDateOfWeek(f);this._setStartDate(F);this._oFocusDateWeek=f;this._focusDate(this._oFocusDateWeek,false,true);}this._closeCalendarPicker(true);};
d.prototype._calculateStartDate=function(m,M,s){var m=new a(this._oMaxDate,this.getPrimaryCalendarType());m=this._getMaxDateAlignedToMinDate(m,this._oMinDate);s=this._getStartDateAlignedToMinAndMaxDate(m,this._oMinDate,s);return s;};
return d;});
sap.ui.predefine('sap/ui/unified/ColorPicker',["./library","sap/ui/core/Control","sap/ui/core/HTML","sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/Icon","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText","sap/ui/Device","sap/ui/core/library","./ColorPickerRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/Global"],function(L,a,H,R,G,b,V,c,I,P,e,D,f,g,h,q){"use strict";var j=f.ValueState,k=L.ColorPickerMode,l=L.ColorPickerDisplayMode;
var m=a.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:k.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:l.Default}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"},_oCPBox:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oSlider:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaSlider:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oHexField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oRedField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oGreenField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oBlueField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oHueField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oSatField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oLitField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oValField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaField:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oAlphaField2:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oRGBorHSLRBUnifiedGroup:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"},_oButton:{type:"sap.ui.core.Control",group:"Appearance",multiple:false,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});
var B="",s=sap.ui.resource('sap.ui.unified','img/ColorPicker/Alphaslider_BG.png'),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),n={};Object.defineProperties(n,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},Colors:{value:{aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',grey:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32',transparent:'00000000'}}});
m.prototype.init=function(){if(D.browser.firefox){B="-moz-linear-gradient";}else if(D.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=L.ColorPickerHelper.isResponsive();var C=this.bResponsive?"_sap_ui_unified_ColorPicker_CircleSize":"_sap_ui_unified_ColorPicker_commonsCircleSize";this._iCPCursorSize=0;var d=P.get({name:C,callback:function(_){this._iCPCursorSize=parseInt(_);}.bind(this)});if(d){this._iCPCursorSize=parseInt(d);}this._processChanges=this._processHSVChanges;this._bHSLMode=false;this.bPressed=false;};
var o=a.extend("sap.ui.unified._ColorPickerBox",{
metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},
init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();},
exit:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
getWidth:function(){return this.$().width();},
getOffset:function(){return this.$().offset();},
onBeforeRendering:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
onAfterRendering:function(){this._handle=this.$().find("> div."+n.CPCircleClass);this._sResizeListener=R.register(this.getDomRef(),this.handleResize.bind(this));},
handleResize:function(E){this.fireResize({size:E.size.width});},
getHandle:function(){return this._handle;},
ontouchstart:function(E){this.handleTouch(E);},
ontouchend:function(E){this.handleTouch(E);},
ontouchmove:function(E){this.handleTouch(E);},
handleTouch:function(E){var v=this.calculateValuesFromEvent(E);if(v){this.fireSelect(v);}},
calculateValuesFromEvent:function(E){var x=E.offsetX,y=E.offsetY,i,d=i=this.getWidth(),p,O;E.preventDefault&&E.preventDefault();if(!x){p=E.targetTouches?E.targetTouches[0]:E;if(!p||!p.pageX){p=E;if((!p||!p.pageX)&&E.changedTouches){p=E.changedTouches[0];}}if(!p.pageX){return false;}O=this.getOffset();x=p.pageX-O.left;y=p.pageY-O.top;}x=Math.min(Math.max(x,0),d);y=Math.min(Math.max(y,0),i);if(this.bRtl){x=d-x;}return{value:x/d*100,saturation:(1-y/i)*100};},
renderer:function(d,C){d.write("<div");d.addClass(n.CPBoxClass);d.writeControlData(C);d.writeClasses();d.write(">");d.write("<div");d.writeAttribute("id",C.getId()+"-cpCur");d.addClass(n.CPCircleClass);d.writeClasses();d.write("></div>");d.write("</div>");}
});
m.prototype._createRowFromInput=function(i,t,d,u){var T=r.getText(t),p;p=new c({content:[L.ColorPickerHelper.factory.createLabel({text:d,tooltip:T,labelFor:i}).addStyleClass(n.LabelClass),i.setTooltip(T)]});if(u){p.addContent(L.ColorPickerHelper.factory.createLabel({text:u,labelFor:i}).addStyleClass(n.UnitLabelClass).addStyleClass(n.LabelClass));}return p;};
m.prototype._updateColorStringProperty=function(F,d){var i=this._getCSSColorString();this.setProperty('colorString',i,true);if(d){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:i});}if(F){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:i});}};
m.prototype._handleCPBoxSelectEvent=function(E){var v=E.getParameter("value"),d=E.getParameter("saturation");this.oSatField.setValue(d);if(this._bHSLMode){this.oLitField.setValue(v);}else{this.oValField.setValue(v);}this._processChanges();this._updateColorStringProperty(false,true);};
m.prototype._handleCPBoxResizeEvent=function(E){this._iCPBoxSize=E.getParameter("size");this._updateCursorPosition();};
m.prototype._handleCPBoxTouchEndEvent=function(E){this._updateColorStringProperty(true,false);};
m.prototype._createInteractionControls=function(){var i=this.getId();this.oCPBox=new o(i+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=L.ColorPickerHelper.factory.createInput(i+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_HEX")}).addStyleClass(n.HEXClass);this.oRedField=L.ColorPickerHelper.factory.createInput(i+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_RED")}).addStyleClass(n.LeftColumnInputClass);this.oGreenField=L.ColorPickerHelper.factory.createInput(i+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_GREEN")}).addStyleClass(n.LeftColumnInputClass);this.oBlueField=L.ColorPickerHelper.factory.createInput(i+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_BLUE")}).addStyleClass(n.LeftColumnInputClass);this.oHueField=L.ColorPickerHelper.factory.createInput(i+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_HUE")}).addStyleClass(n.RightColumnInputClass);this.oSatField=L.ColorPickerHelper.factory.createInput(i+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_SAT")+" "+e.getStaticId("sap.ui.unified","COLORPICKER_PERCENTAGE")}).addStyleClass(n.RightColumnInputClass);this.oLitField=L.ColorPickerHelper.factory.createInput(i+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_LIGHTNESS")+" "+e.getStaticId("sap.ui.unified","COLORPICKER_PERCENTAGE")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSVClass);this.oAlphaField=L.ColorPickerHelper.factory.createInput(i+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_ALPHA")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSVClass).addStyleClass("sapUnifiedA");this.oAlphaField2=L.ColorPickerHelper.factory.createInput(i+"-aF2",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_ALPHA")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSVClass).addStyleClass("sapUnifiedA");this.oValField=L.ColorPickerHelper.factory.createInput(i+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this),ariaLabelledBy:e.getStaticId("sap.ui.unified","COLORPICKER_VALUE")}).addStyleClass(n.RightColumnInputClass).addStyleClass(n.HideForHSLClass);this.oRGBorHSLRBGroup=L.ColorPickerHelper.factory.createRadioButtonGroup({columns:2,buttons:[L.ColorPickerHelper.factory.createRadioButtonItem({text:n.RGB}),L.ColorPickerHelper.factory.createRadioButtonItem({text:L.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)}).addStyleClass(n.OutputSelectorClass);this.oHueInvisibleText=new e({text:r.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",this.oHueInvisibleText,true);this.oSlider=L.ColorPickerHelper.factory.createSlider(i+"-hSLD",{max:360,step:1,tooltip:r.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue())}).addStyleClass(n.SliderClass).addAriaLabelledBy(this.oHueInvisibleText);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));this.oAlphaInvisibleText=new e({text:r.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",this.oAlphaInvisibleText,true);this.oAlphaSlider=L.ColorPickerHelper.factory.createSlider(i+"-aSLD",{max:1,value:1,step:0.01,tooltip:r.getText("COLORPICKER_ALPHA")}).addStyleClass(n.AlphaSliderClass).addAriaLabelledBy(this.oAlphaInvisibleText);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this));};
m.prototype._createLayout=function(){var i=this.getId(),d;if(this._bLayoutControlsCreated){return;}this._createInteractionControls();if(this.getDisplayMode()===l.Large){this._toggleInputsEnabled(this.Color.formatHSL);}this.oCPBoxGD=new b({span:"L6 M6 S12"});this.icOne=new b({span:"L3 M3 S6"});this.icTwo=new b({span:"L3 M3 S6"});this.swatches=new b({span:"L3 M3 S12"});this.rbg=new b({span:"L6 M8 S12"});if(this.bResponsive){this._createUnifiedColorPicker(i);}else{d=this._createCommonsColorPicker(d,i);this.setAggregation("_grid",d,true);}this._bLayoutControlsCreated=true;if(!this.bResponsive){this._adaptControlToLibrary();}};
m.prototype._adaptControlToLibrary=function(){var d;if(!this._bLayoutControlsCreated){return;}d=this.getAggregation("_grid");if(this.bResponsive){if(!D.system.phone&&!q('html').hasClass("sapUiMedia-Std-Phone")){d._setBreakPointTablet(400);}d.addStyleClass(n.CPResponsiveClass);}else{d.setProperty("hSpacing",0,true);d.setProperty("vSpacing",0,true);this.oCPBoxGD.setSpanS(5);this.icOne.setSpanS(4);this.icTwo.setSpanS(3);this.rbg.setSpanS(8);}};
m.prototype._updateControlVisualState=function(){var d=this.getAggregation("_grid");if(!d){return;}if(this.bResponsive){if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanM(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanM(3).setLinebreak(false);}}else{if(this._bHSLMode){d.addStyleClass(n.HSLClass);this.swatches.setSpanS(4).setLinebreak(true);}else{d.removeStyleClass(n.HSLClass);this.swatches.setSpanS(3).setLinebreak(false);}}};
m.prototype._processChanges=function(){};
m.prototype.setMode=function(M,S){this._bLayoutControlsCreated=false;switch(M){case L.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case L.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:h.error("Control must have a valid mode set to work correct");break;}this._bHSLMode=M===L.ColorPickerMode.HSL;return this.setProperty("mode",M,S);};
m.prototype.setDisplayMode=function(d){this._bLayoutControlsCreated=false;return this.setProperty("displayMode",d,false);};
m.prototype._cleanup=function(){var C=[this.getAggregation("_grid"),this.getAggregation("_oCPBox"),this.getAggregation("_oHexField"),this.getAggregation("_oRedField"),this.getAggregation("_oGreenField"),this.getAggregation("_oBlueField"),this.getAggregation("_oHueField"),this.getAggregation("_oSatField"),this.getAggregation("_oLitField"),this.getAggregation("_oAlphaField"),this.getAggregation("_oAlphaField2"),this.getAggregation("_oValField"),this.getAggregation("_oSlider"),this.getAggregation("_oAlphaSlider"),this.oRGBorHSLRBUnifiedGroup,this.oCPBoxGD,this.icOne,this.icTwo,this.rbg,this.swatches,this.oAlphaInvisibleText,this.oHueInvisibleText,this.getAggregation("_oButton"),this.getAggregation("_oRGBorHSLRBUnifiedGroup"),this.oRGBorHSLRBGroup];C.forEach(function(d){if(d){d.destroy();}},this);this._bLayoutControlsCreated=false;};
m.prototype.exit=function(){this._cleanup();};
m.prototype.onBeforeRendering=function(){this._cleanup();this._createLayout();this._updateControlVisualState();this._updateColorString();};
m.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);if(this.bResponsive){this.oRGBorHSLRBUnifiedGroup.setSelectedIndex(this.Color.formatHSL?1:0);}else{this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);}}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);}this._updateColorStringProperty(false,false);};
m.prototype.isColor=function(C){return this._parseColorString(C,true);};
m.prototype._handleSliderChange=function(E,d){var i=parseInt(this.oSlider.getValue());this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(d==="change",d==="liveChange");};
m.prototype._handleAlphaSliderChange=function(E,d){this.Color.a=this.oAlphaSlider.getValue();this.oAlphaField.setValue(this.Color.a);this.oAlphaField2.setValue(this.Color.a);this._updateSelColorBackground();this._updateColorStringProperty(d==="change",d==="liveChange");};
m.prototype._getValueInRange=function(v,M,i){if(isNaN(v)){v=0;}return Math.min(Math.max(v,M),i);};
m.prototype._handleAlphaValueChange=function(E){var d=(E.getParameter("id")=="cp-aF2")?parseFloat(this.oAlphaField2.getValue(),10):parseFloat(this.oAlphaField.getValue(),10);d=this._getValueInRange(d,0,1);this.Color.a=d;this.oAlphaField.setValue(d);this.oAlphaField2.setValue(d);this.oAlphaSlider.setValue(d);if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(true,true);};
m.prototype._handleRGBorHSLValueChange=function(E){this.Color.formatHSL=E.getParameter("selectedIndex")===1;this._toggleInputsEnabled(this.Color.formatHSL);this._updateColorStringProperty(true,true);};
m.prototype._toggleInputsEnabled=function(d){this.oRedField.setEnabled(!d);this.oGreenField.setEnabled(!d);this.oBlueField.setEnabled(!d);this.oHueField.setEnabled(!!d);this.oSatField.setEnabled(!!d);this.oLitField.setEnabled(!!d);this.oValField.setEnabled(!!d);};
m.prototype._handleHueValueChange=function(){var d=parseInt(this.oHueField.getValue());d=this._getValueInRange(d,0,360);this.oHueField.setValue(d);this.oSlider.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleSatValueChange=function(){var d=parseInt(this.oSatField.getValue());d=this._getValueInRange(d,0,100);this.oSatField.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleValValueChange=function(){var v=parseInt(this.oValField.getValue());v=this._getValueInRange(v,0,100);this.oValField.setValue(v);this._processHSVChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleLitValueChange=function(){var d=parseInt(this.oLitField.getValue());d=this._getValueInRange(d,0,100);this.oLitField.setValue(d);this._processHSLChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleRedValueChange=function(){var d=parseInt(this.oRedField.getValue());d=this._getValueInRange(d,0,255);this.oRedField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleGreenValueChange=function(){var d=parseInt(this.oGreenField.getValue());d=this._getValueInRange(d,0,255);this.oGreenField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._handleBlueValueChange=function(){var d=parseInt(this.oBlueField.getValue());d=this._getValueInRange(d,0,255);this.oBlueField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
m.prototype._processHSVChanges=function(){var d=parseInt(this.oHueField.getValue());var i=parseInt(this.oSatField.getValue());var v=parseInt(this.oValField.getValue());this._calculateRGB(d,i,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=d;this.Color.s=i;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
m.prototype._processHSLChanges=function(){var i=parseInt(this.oHueField.getValue()),S=parseInt(this.oSatField.getValue()),d=parseInt(this.oLitField.getValue());if(i>360){i%=360;}this._calculateRGB(i,S,d);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=i;this.Color.s=S;this.Color.l=d;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};
m.prototype._processRGBChanges=function(){var d=Math.round(parseInt(this.oRedField.getValue())),i=Math.round(parseInt(this.oGreenField.getValue())),p=Math.round(parseInt(this.oBlueField.getValue())),t=(d+i+p)===765;this._calculateHEX(d,i,p);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(d,i,p);this.oLitField.setValue(this.Color.l);}else{if(!t){this._calculateHSV(d,i,p);}this.oValField.setValue(this.Color.v);}if(!t){this.oHueField.setValue(this.Color.h);}this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue()));this.Color.r=d;this.Color.g=i;this.Color.b=p;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};
m.prototype._handleHexValueChange=function(){var d=this.oHexField.getValue().toLowerCase(),i=1,p;if(d.substr(0,1)==='#'){d=d.substr(1);}p=/^([0-9a-fA-F]{8})$/;if(p.test(d)!==false){i=Number((parseInt(d.substr(6,2),16)/255).toFixed(2));d=d.substr(0,6);}p=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(p.test(d)===false){this.oHexField.setValueState(j.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);this.oAlphaField.setEnabled(false);this.oAlphaField2.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false);}else{this.oValField.setEnabled(false);}return;}else if(this.oHexField.getValueState()===j.Error){this.oHexField.setValueState(j.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);this.oAlphaField.setEnabled(true);this.oAlphaField2.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(d.length===3){d=d.charAt(0)+d.charAt(0)+d.charAt(1)+d.charAt(1)+d.charAt(2)+d.charAt(2);}this._processHexChanges(d);this.oHexField.setValue(d);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);this.oAlphaField2.setValue(1);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue()));this.oAlphaSlider.setValue(i);this.Color.a=i;if(this._bHSLMode){this.oAlphaField.setValue(i);this.oAlphaField2.setValue(i);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();this._updateColorStringProperty(true,true);};
m.prototype._processHexChanges=function(d){this._convertRGB(d);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+d.toLowerCase();};
m.prototype._updateAlphaBackground=function(){var d=[this.Color.r,this.Color.g,this.Color.b].join(","),i=B+"(left,rgba("+d+",0),rgba("+d+",1)),url("+s+")";this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",i);};
m.prototype._updateCursorPosition=function(){var x,y;if(!this._iCPBoxSize){return;}if(this._bHSLMode){x=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100.0);}else{x=Math.round(this.oValField.getValue()*this._iCPBoxSize/100.0);}if(sap.ui.getCore().getConfiguration().getRTL()){x=this._iCPBoxSize-x;}y=Math.round((1-this.oSatField.getValue()/100.0)*this._iCPBoxSize);x=Math.round(Math.max(x,0)-this._iCPCursorSize/2.0-1.0);y=Math.round(Math.max(y,0)-this._iCPCursorSize/2.0-1.0);this.$CPCur.css("left",x).css("top",y);};
m.prototype._calculateRGB=function(d,S,v){var p,t,u,M,x,C,i;if(this._bHSLMode){this._calculateRGBAdvanced(d,S,v);return;}d%=360;d/=60;S/=100;v/=100;C=v*S;x=C*(1-Math.abs(d%2-1));M=v-C;p=0;t=0;u=0;i=Math.floor(d);switch(i){case 0:p=C;t=x;break;case 1:p=x;t=C;break;case 2:t=C;u=x;break;case 3:t=x;u=C;break;case 4:p=x;u=C;break;case 5:p=C;u=x;break;default:p=0;u=0;t=0;break;}this.RGB.r=Math.floor((p+M)*255);this.RGB.g=Math.floor((t+M)*255);this.RGB.b=Math.floor((u+M)*255);};
m.prototype._calculateRGBAdvanced=function(d,S,p){var t,u,v,M,w,x,y,z,i;d=this._getValueInRange(d,0,360);d%=360;if(S>100){S=1;}else if(S<0){S=0;}else{S=S/100;}if(p>100){p=1;}else if(p<0){p=0;}else{p=p/100;}z=S*(1-Math.abs(2*p-1));y=255*(p-0.5*z);x=z*(1-Math.abs((d/60)%2-1));i=Math.floor(d/60);w=y+255*x;M=y+255*z;switch(i){case 0:t=M;u=w;v=y;break;case 1:t=w;u=M;v=y;break;case 2:t=y;u=M;v=w;break;case 3:t=y;u=w;v=M;break;case 4:t=w;u=y;v=M;break;case 5:t=M;u=y;v=w;break;default:t=0;u=0;v=0;break;}this.RGB.r=Math.round(t);this.RGB.g=Math.round(u);this.RGB.b=Math.round(v);};
m.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};
m.prototype._calculateHEX=function(i,d,p){var t=i.toString(16),u=d.toString(16),v=p.toString(16);if(t.length===1){t='0'+t;}if(u.length===1){u='0'+u;}if(v.length===1){v='0'+v;}this.sHexString=(t+u+v).toLowerCase();};
m.prototype._calculateHSV=function(i,d,p){var t=Math.max(Math.max(i,d),p),u=Math.min(Math.min(i,d),p),v=t-u,w=Math.round(t*100/255),x=t===0.0?0:(100*v/t),y=0;if(x===0){y=0;}else if(i===t){y=60.0*(d-p)/v;}else if(d===t){y=120.0+60.0*(p-i)/v;}else if(p===t){y=240.0+60.0*(i-d)/v;}if(y<0.0){y+=359.9;}y=Math.round(y);x=Math.round(x);this.Color.h=y;this.Color.s=x;this.Color.v=w;};
m.prototype._calculateHSL=function(i,p,t){var u=Math.max(i,p,t),v=Math.min(i,p,t),d=(u-v)/255,w=(u+v)/510,x=1-Math.abs(2*w-1),y=(w===0.0)?0:d/x,z=(x!==0)?y:0,A=0;w=Math.round(w*100);z=Math.round(z*100);if(w===0||z===0||(i+p+t===765)){A=0;}else{var C=u-v;if(u===i){A=((p-t)/C)%6;}if(u===p){A=(t-i)/C+2;}if(u===t){A=(i-p)/C+4;}if(C===0){A=0;}A*=60;if(A<0){A+=360;}}if(A!==0||this.Color.h!==360){this.Color.h=Math.round(A);}this.Color.s=z;this.Color.l=w;};
m.prototype._convertRGB=function(d){this.Color.r=parseInt(d.substr(0,2),16);this.Color.g=parseInt(d.substr(2,2),16);this.Color.b=parseInt(d.substr(4,2),16);};
m.prototype._updateGradientBoxBackground=function(i){if(this._bHSLMode){this._calculateRGBAdvanced(i,100,50);}else{this._calculateRGB(i,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css('background-color','rgb('+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+')');};
m.prototype._updateSelColorBackground=function(){this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',this._getCSSColorString());};
m.prototype._parseColorString=function(C,d){var i;if(C.substr(0,1)==='#'){C=C.substr(1);}C=C.trim().toLowerCase();i=this._parseColorName(C);if(i){if(d){return true;}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6);}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(C)){if(d){return true;}if(C.length===3){i=C[0]+C[0]+C[1]+C[1]+C[2]+C[2];}else{i=C;}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(C.substr(0,3)==='rgb'){return this._parseRGB(C,d);}if(this._bHSLMode){return this._parseHSL(C,d);}else if(C.substr(0,3)==='hsv'){return this._parseHSV(C,d);}return false;};
m.prototype._parseHSV=function(C,d){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,p,t,S,v;C=C.substr(3).replace("(",'').replace(")",'').split(' ').join('');if(i.test(C)===true){if(d){return true;}p=C.split(",");t=parseInt(p[0]);S=parseInt(p[1]);v=parseInt(p[2]);this._calculateRGB(t,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=t;this.Color.s=S;this.Color.v=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true;}return false;};
m.prototype._parseHSL=function(C,d){var i,p=C.substr(0,4),t,u,S,v,A;if(p==="hsla"){t=true;}else if(p==="hsl("){t=false;}else{return false;}C=C.substr(t?4:3).replace("(",'').replace(")",'').split(' ').join('');i=C.split(",");u=parseInt(i[0]);S=parseFloat(i[1]);v=parseFloat(i[2]);if(t){A=parseFloat(i[3]);}else{if(i[3]&&parseFloat(i[3])>=0){return false;}A=1;}S=(S<1&&S>0)?S*100:S;v=(v<1&&v>0)?v*100:v;if((u>=0&&u<=360)&&(S>=0&&S<=100)&&(v>=0&&v<=100)&&(A>=0&&A<=1)){if(d){return true;}this._calculateRGB(u,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=u;this.Color.s=S;this.Color.l=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=A;this.Color.formatHSL=true;}else{return false;}return true;};
m.prototype._parseRGB=function(C,d){var v,i,p,t;i=C.substring(0,4);if(i==="rgba"){t=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;p=true;}else if(i.substring(0,3)==="rgb"){t=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;p=false;}else{return false;}C=C.substr(p?4:3).replace("(",'').replace(")",'').split(' ').join('');if(t.test(C)){if(d){return true;}v=C.split(",");this._calculateHEX(parseInt(v[0]),parseInt(v[1]),parseInt(v[2]));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(p){this.Color.a=this.Color.oldA=parseFloat(v[3]);}return true;}if(this._bHSLMode){this.Color.formatHSL=false;}return false;};
m.prototype._parseColorName=function(C){return n.Colors[C];};
m.prototype.onAfterRendering=function(){var d=this._getCSSColorString(),p=this.getParent();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$().find(".sapUiColorPicker-ColorPickerNewColor").css('background-color',d);this.$().find(".sapUiColorPicker-ColorPickerOldColor").css('background-color',d);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();this._updateAlphaBackground();this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);if(p&&p.getMetadata().getName()==="sap.m.Dialog"){p.addStyleClass("sapUiCPDialog");}this.addStyleClass("sapUiCPDisplayRGB");if(D.system.phone){this._toggleFields();}};
m.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};
m.prototype._getConstants=function(){return n;};
m.prototype._createCommonsColorPicker=function(d,i){d=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this.oCPBoxGD),new V({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this.icOne}),new V({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oAlphaField2,"COLORPICKER_ALPHA","A:").addStyleClass(n.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(n.HideForHSLClass)],layoutData:this.icTwo}).addStyleClass(n.LastColumnClass),new c({content:[new H({content:["<div id='",i,"-ocBox' class='",n.OldColorClass,"'></div>"].join("")}),new H({content:["<div id='",i,"-ncBox' class='",n.NewColorClass,"'></div>"].join("")})],layoutData:this.swatches}).addStyleClass(n.SwatchesClass),new c({content:[L.ColorPickerHelper.factory.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this.rbg}).addStyleClass(n.HideForHSVClass).addStyleClass(n.OutputSelectorRowClass),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12"}))]}).addStyleClass(n.CPMatrixClass);return d;};
m.prototype._createUnifiedColorPicker=function(i){var t=this;this.oRbRGB=L.ColorPickerHelper.factory.createRadioButtonItem({tooltip:r.getText("COLORPICKER_SELECT_RGB_TOOLTIP")});this.oRbRGB.addStyleClass("sapUiCPRB");this.oRbHSLV=L.ColorPickerHelper.factory.createRadioButtonItem({tooltip:r.getText("COLORPICKER_SELECT_HSL_TOOLTIP")});this.oRbHSLV.addStyleClass("sapUiCPRB");this.oButton=L.ColorPickerHelper.factory.createButton(i+"-toggleMode",{type:D.system.phone?"Default":"Transparent",tooltip:r.getText("COLORPICKER_TOGGLE_BTN_TOOLTIP"),icon:"sap-icon://source-code",press:function(E){t._toggleFields();}});this.setAggregation("_oButton",this.oButton,true);this.oRGBorHSLRBUnifiedGroup=L.ColorPickerHelper.factory.createRadioButtonGroup({select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)});this.oRGBorHSLRBUnifiedGroup.addButton(this.oRbRGB);this.oRGBorHSLRBUnifiedGroup.addButton(this.oRbHSLV);this.setAggregation("_oRGBorHSLRBUnifiedGroup",this.oRGBorHSLRBUnifiedGroup,true);this.setAggregation("_oCPBox",this.oCPBox,true);this.setAggregation("_oHexField",this.oHexField,true);this.setAggregation("_oRedField",this.oRedField,true);this.setAggregation("_oGreenField",this.oGreenField,true);this.setAggregation("_oBlueField",this.oBlueField,true);this.setAggregation("_oHueField",this.oHueField,true);this.setAggregation("_oSatField",this.oSatField,true);this.setAggregation("_oLitField",this.oLitField,true);this.setAggregation("_oAlphaField",this.oAlphaField,true);this.setAggregation("_oAlphaField2",this.oAlphaField2,true);this.setAggregation("_oValField",this.oValField,true);this.setAggregation("_oSlider",this.oSlider,true);this.setAggregation("_oAlphaSlider",this.oAlphaSlider,true);};
m.prototype._toggleFields=function(){if(!D.system.phone){this.toggleStyleClass("sapUiCPDisplayRGB",this.bPressed);this.bPressed=!this.bPressed;}else{switch(this.sVisibleFiled){case"HSL":this.removeStyleClass("sapUiCPHexVisible");this.toggleStyleClass("sapUiCPDisplayRGB",false);this.addStyleClass("sapUiCPHideHex");this.sVisibleFiled="RGB";break;case"RGB":this.removeStyleClass("sapUiCPHexVisible");this.addStyleClass("sapUiCPHideHex");this.toggleStyleClass("sapUiCPDisplayRGB",true);this.sVisibleFiled="Hex";break;case"Hex":default:this.addStyleClass("sapUiCPHexVisible");this.removeStyleClass("sapUiCPHideHex");this.sVisibleFiled="HSL";break;}}};
return m;});
sap.ui.predefine('sap/ui/unified/ColorPickerDisplayMode',[],function(){"use strict";var C={Default:"Default",Large:"Large",Simplified:"Simplified"};return C;});
sap.ui.predefine('sap/ui/unified/ColorPickerPopover',['sap/ui/core/Control','sap/ui/Device','sap/m/Button','sap/m/ResponsivePopover','./ColorPicker','./library','sap/m/library',"sap/ui/thirdparty/jquery"],function(C,D,B,R,a,l,L,q){"use strict";var P=L.PlacementType;var b=l.ColorPickerMode,c=l.ColorPickerDisplayMode;var d=L.ButtonType;
var e=C.extend("sap.ui.unified.ColorPickerPopover",{
metadata:{library:"sap.ui.unified",publicMethods:["openBy","close"],properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:b.HSV},displayMode:{type:"sap.ui.unified.ColorPickerDisplayMode",group:"Appearance",defaultValue:c.Default}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}},
renderer:{apiVersion:2}
});
var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var F={COLOR_PICKER_PROPS:{colorString:"setColorString",mode:"setMode",displayMode:"setDisplayMode"},POPOVER_METHODS:{getDomRef:"",close:""}};
e.prototype.init=function(){this._oPopover=null;this._bPopoverDestroying=null;};
e.prototype.exit=function(){this._bPopoverDestroying=true;if(this._oPopover){this._oPopover.removeDelegate(this._oPopover._onAfterRenderingDelegate);this._oPopover.destroy();this._oPopover=null;}};
e.prototype.openBy=function(f){return R.prototype.openBy.apply(this._ensurePopover(),arguments);};
e.prototype._getColorPicker=function(){return this._ensurePopover().getContent()[0];};
e.prototype._ensurePopover=function(){if(!this._oPopover){this._oPopover=this._createPopover();}return this._oPopover;};
e.prototype._createPopover=function(){var p,f=this._createColorPicker(),g,t=this;p=new R(this.getId()+"-colorPickerPopover",{showHeader:D.system.phone,placement:P.VerticalPreferredBottom,showArrow:false,showCloseButton:false,beginButton:new B({text:o.getText("COLOR_PICKER_SUBMIT"),type:d.Emphasized,press:function(){t.fireChange(t._oLastChangeCPParams);p.close();}}),endButton:new B({text:o.getText("COLOR_PICKER_CANCEL"),press:function(){p.close();}}),title:o.getText("COLOR_PICKER_TITLE"),content:f});f.attachChange(function(E){this._handleChange(E);}.bind(this));f.attachLiveChange(function(E){this.fireLiveChange(E.getParameters());}.bind(this));g={onAfterRendering:function(){var $=this.$();$.attr("aria-modal","true");$.attr("aria-label",this.getTitle());}};p.addEventDelegate(g,p);p._onAfterRenderingDelegate=g;return p;};
e.prototype._handleChange=function(E){var t={};this._oLastChangeCPParams=q.extend(t,E.getParameters());delete this._oLastChangeCPParams.id;return this;};
e.prototype._createColorPicker=function(){var f=new a(this.getId()+"-color_picker");return f;};
e.prototype.setProperty=function(p,v,s){var t;if(F.COLOR_PICKER_PROPS[p]!==undefined){t=F.COLOR_PICKER_PROPS[p]||p;a.prototype[t].call(this._getColorPicker(),v);}return C.prototype.setProperty.apply(this,arguments);};
Object.keys(F.POPOVER_METHODS).forEach(function(s){var t=F.POPOVER_METHODS[s]||s;e.prototype[s]=function(){if(this._bPopoverDestroying){return null;}var p=this._ensurePopover();return p[t].apply(p,arguments);};});return e;});
sap.ui.predefine('sap/ui/unified/ColorPickerRenderer',['./ColorPickerDisplayMode',"sap/ui/Device"],function(C,D){"use strict";var a={apiVersion:2};
a.render=function(r,c){var d=c.getDisplayMode(),R=c.bResponsive;r.openStart("div",c);r.accessibilityState(c,{role:"group",roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("COLOR_PICKER_TITLE")});if(R){r.class("sapUiColorPicker-ColorPickerMatrix");r.class("sapUiColorPicker-"+d);r.class("sapUnifiedColorPicker");if(c._bHSLMode){r.class("sapUiColorPickerHSL");}}if(D.system.phone){r.class("sapUiCPPhone");}r.openEnd();if(!R){r.renderControl(c.getAggregation("_grid"));}else{switch(d){case C.Default:this.renderDefaultColorPicker(r,c);break;case C.Large:this.renderLargeColorPicker(r,c);break;case C.Simplified:this.renderSimplifiedColorPicker(r,c);}}r.close("div");};
a.renderDefaultColorPicker=function(r,c){r.renderControl(c.getAggregation("_oCPBox"));if(D.system.phone){r.openStart("div");r.class("sapUiCPPhoneContent");r.openEnd();r.openStart("div");r.class("sapUiCPSlidersPhone");r.openEnd();r.renderControl(c.getAggregation("_oSlider"));r.renderControl(c.getAggregation("_oAlphaSlider"));r.close("div");this.renderMobileSwatches(r,c);r.close("div");}else{r.renderControl(c.getAggregation("_oSlider"));r.renderControl(c.getAggregation("_oAlphaSlider"));this.renderDesktopSwatchesAndHexFields(r,c);}r.openStart("div");r.class("sapUiCPDefaultWrapper");r.openEnd();if(D.system.phone){r.renderControl(c.getAggregation("_oHexField"));r.openStart("div");r.class("sapUiCPHexText");r.openEnd();r.text("Hex");r.close("div");}r.openStart("div");r.class("sapUiCPDefaultRGB");r.openEnd();r.renderControl(c.getAggregation("_oRedField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oGreenField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oBlueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oAlphaField"));r.close("div");r.openStart("div");r.class("sapUiCPDefaultHSLV");r.openEnd();r.renderControl(c.getAggregation("_oHueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oSatField"));r.openStart("div");r.class("sapUiCPPercentSymbol");r.openEnd();r.text("%");r.close("div");r.renderControl(c.getAggregation("_oLitField"));r.renderControl(c.getAggregation("_oValField"));if(c.getMode()==="HSL"){r.openStart("div");r.class("sapUiCPPercentSymbol");r.openEnd();r.text("%");r.close("div");}else{this.renderEmptyDiv(r);}r.renderControl(c.getAggregation("_oAlphaField2"));r.close("div");r.renderControl(c.getAggregation("_oButton"));this.renderRGBLabel(r,c);this.renderHSLVLabel(r,c);r.close("div");};
a.renderLargeColorPicker=function(r,c){r.renderControl(c.getAggregation("_oCPBox"));r.renderControl(c.getAggregation("_oSlider"));r.renderControl(c.getAggregation("_oAlphaSlider"));this.renderDesktopSwatchesAndHexFields(r,c);r.renderControl(c.oRGBorHSLRBUnifiedGroup);r.openStart("div");r.class("sapUiCPRGBA");r.openEnd();r.renderControl(c.getAggregation("_oRedField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oGreenField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oBlueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oAlphaField"));r.close("div");this.renderRGBLabel(r,c);r.openStart("div");r.class("sapUiCPHSLV");r.openEnd();r.renderControl(c.getAggregation("_oHueField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oSatField"));r.openStart("div");r.class("sapUiCPPercentSymbol");r.openEnd();r.text("%");r.close("div");c.getMode()==="HSL"?this.renderLFirst(r,c):this.renderVFirst(r,c);r.close("div");this.renderHSLVLabel(r,c);};
a.renderSimplifiedColorPicker=function(r,c){r.renderControl(c.getAggregation("_oCPBox"));if(D.system.phone){r.openStart("div");r.class("sapUiCPPhoneContent");r.openEnd();r.openStart("div");r.class("sapUiCPSlidersPhone");r.openEnd();r.renderControl(c.getAggregation("_oSlider"));r.close("div");r.renderControl(c.getAggregation("_oHexField"));this.renderMobileSwatches(r,c);r.openStart("div");r.class("sapUiCPHexWrapper");r.openEnd();r.openStart("div");r.class("sapUiCPHexText");r.openEnd();r.text("Hex");r.close("div");r.close("div");r.close("div");}else{r.renderControl(c.getAggregation("_oSlider"));this.renderDesktopSwatchesAndHexFields(r,c);}};
a.renderDesktopSwatchesAndHexFields=function(r,c){r.openStart("div");r.class("sapUiCPComparisonWrapper");r.openEnd();r.openStart("div",c.getId()+"-ocBox");r.class("sapUiColorPicker-ColorPickerOldColor");r.openEnd();r.close("div");r.openStart("div",c.getId()+"-ncBox");r.class("sapUiColorPicker-ColorPickerNewColor");r.openEnd();r.close("div");r.close("div");r.openStart("div");r.class("sapUiCPHexWrapper");r.openEnd();r.openStart("span");r.class("sapUiCPHexText");r.openEnd();r.text("Hex");r.close("span");r.close("div");r.renderControl(c.getAggregation("_oHexField"));};
a.renderMobileSwatches=function(r,c){r.openStart("div");r.class("sapUiCPComparisonWrapper");r.class("sapUiCPComparisonWrapperPhone");r.openEnd();r.openStart("div",c.getId()+"-ocBox");r.class("sapUiColorPicker-ColorPickerOldColor");r.openEnd();r.close("div");r.openStart("div",c.getId()+"-ncBox");r.class("sapUiColorPicker-ColorPickerNewColor");r.openEnd();r.close("div");r.close("div");};
a.renderLFirst=function(r,c){r.renderControl(c.getAggregation("_oLitField"));r.openStart("div");r.class("sapUiCPPercentSymbol");r.openEnd();r.text("%");r.close("div");r.renderControl(c.getAggregation("_oValField"));};
a.renderVFirst=function(r,c){r.renderControl(c.getAggregation("_oValField"));this.renderEmptyDiv(r);r.renderControl(c.getAggregation("_oLitField"));};
a.renderEmptyDiv=function(r){r.openStart("div");r.class("sapUiCPEmptyDiv");r.openEnd();r.close("div");};
a.renderRGBLabel=function(r,c){r.openStart("div");r.class("sapUiCPRGBText");r.openEnd();r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("R");r.close("span");this.renderEmptyDiv(r);r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("G");r.close("span");this.renderEmptyDiv(r);r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("B");r.close("span");this.renderEmptyDiv(r);if(c.getDisplayMode()==="Default"){r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("A");r.close("span");}else{r.openStart("span");r.class("sapUiCPText");r.openEnd();r.close("span");}r.close("div");};
a.renderHSLVLabel=function(r,c){r.openStart("div");r.class("sapUiCPHSLVText");r.openEnd();r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("H");r.close("span");this.renderEmptyDiv(r);r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("S");r.close("span");this.renderEmptyDiv(r);if(c.getMode()==="HSL"){r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("L");r.close("span");}else{r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("V");r.close("span");}this.renderEmptyDiv(r);r.openStart("span");r.class("sapUiCPText");r.openEnd();r.text("A");r.close("span");r.close("div");};
return a;},true);
sap.ui.predefine('sap/ui/unified/ContentSwitcher',['sap/ui/core/Control','./library',"./ContentSwitcherRenderer","sap/base/Log"],function(C,l,a,L){"use strict";var b=l.ContentSwitcherAnimation;
var c=C.extend("sap.ui.unified.ContentSwitcher",{metadata:{deprecated:true,library:"sap.ui.unified",properties:{animation:{type:"string",group:"Appearance",defaultValue:'None'},activeContent:{type:"int",group:"Behavior",defaultValue:1}},aggregations:{content1:{type:"sap.ui.core.Control",multiple:true,singularName:"content1"},content2:{type:"sap.ui.core.Control",multiple:true,singularName:"content2"}}}});
(function(w){
c.prototype.init=function(){};
c.prototype.switchContent=function(){this.setActiveContent(this.getActiveContent()==1?2:1);return this;};
c.prototype.onAfterRendering=function(){this._$Contents=[this.$("content1"),this.$("content2")];};
c.prototype._showActiveContent=function(n){if(this._$Contents){this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible",n===1);this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible",n===2);}};
c.prototype.setActiveContent=function(n){n=parseInt(n);if(isNaN(n)||n<1){n=1;L.warning("setActiveContent argument must be either 1 or 2. Active content set to 1.");}else if(n>2){n=2;L.warning("setActiveContent argument must be either 1 or 2. Active content set to 2.");}this.setProperty("activeContent",n,true);this._showActiveContent(n);return this;};
c.prototype.setAnimation=function(A,s){if(typeof(A)!=="string"){A=b.None;L.warning("setAnimation argument must be a string. Animation was set to \""+b.None+"\".");}A=A.replace(/[^a-zA-Z0-9]/g,"");var d=this.getProperty("animation");if(A===d){return this;}var D=this.$();if(D[0]){D.toggleClass("sapUiUfdCSwitcherAnimation"+d,false);D.toggleClass("sapUiUfdCSwitcherAnimation"+A,true);}return this.setProperty("animation",A,s);};
})(window);return c;});
sap.ui.predefine('sap/ui/unified/ContentSwitcherRenderer',['sap/ui/unified/library',"sap/base/security/encodeXML"],function(l,e){"use strict";var C=l.ContentSwitcherAnimation;var a={};
a.render=function(r,c){var i=c.getId();var A=c.getAnimation();if(!sap.ui.getCore().getConfiguration().getAnimation()){A=C.None;}var b=c.getActiveContent();r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdCSwitcher");r.addClass("sapUiUfdCSwitcherAnimation"+e(A));r.writeClasses();r.write(">");r.write("<section id=\""+i+"-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1"+(b==1?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent1());r.write("</section>");r.write("<section id=\""+i+"-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2"+(b==2?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent2());r.write("</section>");r.write("</div>");};
a.renderContent=function(r,c){for(var i=0;i<c.length;++i){r.renderControl(c[i]);}};
return a;},true);
sap.ui.predefine('sap/ui/unified/Currency',['sap/ui/core/Control','sap/m/library','sap/ui/core/format/NumberFormat',"./CurrencyRenderer"],function(C,l,N,a){"use strict";var E=l.EmptyIndicatorMode;
var b=C.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},stringValue:{type:"string",group:"Appearance",defaultValue:null},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance"},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true},emptyIndicatorMode:{type:"sap.m.EmptyIndicatorMode",group:"Appearance",defaultValue:E.Off}},designtime:"sap/ui/unified/designtime/Currency.designtime",dnd:{draggable:true,droppable:false}}});
b.FIGURE_SPACE='\u2007';b.PUNCTUATION_SPACE='\u2008';
b.prototype.init=function(){this._oFormat=N.getCurrencyInstance({showMeasure:false});};
b.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null;};
b.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency");}};
b.prototype.setValue=function(v){if(this.isBound("value")){this._bRenderNoValClass=v==null;}this.setProperty("value",v,true);this._renderValue();return this;};
b.prototype.unbindProperty=function(p){C.prototype.unbindProperty.apply(this,arguments);if(p==="value"){this._bRenderNoValClass=false;}};
b.prototype.setCurrency=function(v){var c,r;this.setProperty("currency",v,true);this._renderCurrency();c=this._oFormat.oLocaleData.getCurrencyDigits(v);if(this._iLastCurrencyDigits!=null&&this._iLastCurrencyDigits!==c){r=true;}else if(this._oFormat.oLocaleData.getCurrencyDigits()!==c){r=true;}this._iLastCurrencyDigits=c;if(this._sLastCurrency==="*"||v==="*"){r=true;}this._sLastCurrency=v;if(r){this._renderValue();}return this;};
b.prototype.setUseSymbol=function(v){this.setProperty("useSymbol",v,true);this._renderCurrency();return this;};
b.prototype.setMaxPrecision=function(v){this.setProperty("maxPrecision",v,true);this._renderValue();return this;};
b.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue());}};
b.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency());}};
b.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency();};
b.prototype.getFormattedValue=function(){var c=this.getCurrency(),p,i,f,m=this.getMaxPrecision(),M=!m&&m!==0;if(c==="*"){return"";}i=this._oFormat.oLocaleData.getCurrencyDigits(c);if(M){m=i;}m=(m<=0&&i>0?m-1:m);p=m-i;f=this._oFormat.format(this.getStringValue()||this.getValue(),c);if(p==m&&m>0){f+=b.PUNCTUATION_SPACE;}if(p>0){f=f.padEnd(f.length+p,b.FIGURE_SPACE);}else if(p<0){f=f.substr(0,f.length+p);}return f;};
b.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());};
b.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{};}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()};};
return b;});
sap.ui.predefine('sap/ui/unified/CurrencyRenderer',["sap/m/library","sap/ui/core/Core"],function(m,C){"use strict";var a={apiVersion:2};var E=m.EmptyIndicatorMode;var r=C.getLibraryResourceBundle("sap.m");
a.render=function(R,c){var t=c.getTooltip_AsString();R.openStart("div",c);if(t){R.attr("title",t);}R.class("sapUiUfdCurrency");if(c.getEmptyIndicatorMode()!==E.Off&&!c.getValue()){R.openEnd();this.renderEmptyIndicator(R,c);}else{R.openEnd();R.openStart("div");R.class("sapUiUfdCurrencyAlign");R.openEnd();R.openStart("span");R.attr("dir","ltr");R.class("sapUiUfdCurrencyValue");R.openEnd();R.text(c.getFormattedValue());R.close("span");R.openStart("span");R.class("sapUiUfdCurrencyCurrency");R.openEnd();R.text(c._getCurrency());R.close("span");R.close("div");}R.close("div");};
a.renderEmptyIndicator=function(R,c){R.openStart("span");R.class("sapMEmptyIndicator");if(c.getEmptyIndicatorMode()===E.Auto){R.class("sapMEmptyIndicatorAuto");}R.openEnd();R.openStart("span");R.attr("aria-hidden",true);R.openEnd();R.text(r.getText("EMPTY_INDICATOR"));R.close("span");R.openStart("span");R.class("sapUiPseudoInvisibleText");R.openEnd();R.text(r.getText("EMPTY_INDICATOR_TEXT"));R.close("span");R.close("span");};
return a;},true);
sap.ui.predefine('sap/ui/unified/DateRange',['sap/ui/core/Element','./library','sap/ui/unified/calendar/CalendarUtils'],function(E,l,C){"use strict";
var D=E.extend("sap.ui.unified.DateRange",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc",defaultValue:null},endDate:{type:"object",group:"Misc",defaultValue:null}}}});
D.prototype.setStartDate=function(d,i){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("startDate",d,i);return this;};
D.prototype.setEndDate=function(d,i){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("endDate",d,i);return this;};
return D;});
sap.ui.predefine('sap/ui/unified/DateTypeRange',['./DateRange','./library'],function(D,l){"use strict";var C=l.CalendarDayType;
var a=D.extend("sap.ui.unified.DateTypeRange",{metadata:{library:"sap.ui.unified",properties:{type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.Type01},secondaryType:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:C.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
return a;});
sap.ui.predefine('sap/ui/unified/FileUploader',['sap/ui/core/Control','./library','sap/ui/core/LabelEnablement','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','./FileUploaderRenderer','sap/ui/dom/containsOrEquals','sap/ui/events/KeyCodes','sap/base/Log','sap/base/security/encodeXML',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Aria'],function(C,a,L,I,c,D,F,b,K,d,f,q){var V=c.ValueState;var H=a.FileUploaderHttpRequestMethod;
var g=C.extend("sap.ui.unified.FileUploader",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.unified.IProcessableBlobs"],library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/FileUploader.designtime",properties:{value:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:''},name:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:''},uploadOnChange:{type:"boolean",group:"Behavior",defaultValue:false},additionalData:{type:"string",group:"Data",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},buttonText:{type:"string",group:"Misc",defaultValue:null},fileType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},sendXHR:{type:"boolean",group:"Behavior",defaultValue:false},httpRequestMethod:{type:"sap.ui.unified.FileUploaderHttpRequestMethod",group:"Behavior",defaultValue:H.Post},placeholder:{type:"string",group:"Appearance",defaultValue:null},style:{type:"string",group:"Appearance",defaultValue:null},buttonOnly:{type:"boolean",group:"Appearance",defaultValue:false},useMultipart:{type:"boolean",group:"Behavior",defaultValue:true},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{parameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},headerParameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"},xhrSettings:{type:"sap.ui.unified.FileUploaderXHRSettings",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{newValue:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{fileName:{type:"string"},response:{type:"string"},readyStateXHR:{type:"string"},status:{type:"string"},responseRaw:{type:"string"},headers:{type:"object"},requestHeaders:{type:"object[]"}}},typeMissmatch:{parameters:{fileName:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},fileSizeExceed:{parameters:{fileName:{type:"string"},fileSize:{type:"string"}}},fileEmpty:{parameters:{fileName:{type:"string"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:"boolean"},loaded:{type:"float"},total:{type:"float"},fileName:{type:"string"},requestHeaders:{type:"object[]"}}},uploadAborted:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},filenameLengthExceed:{parameters:{fileName:{type:"string"}}},uploadStart:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}}}}});
g.prototype.init=function(){var t=this;this.oFilePath=a.FileUploaderHelper.createTextField(this.getId()+"-fu_input").addEventDelegate({onAfterRendering:function(){if(t.getWidth()){t._resizeDomElements();}}});this.oBrowse=a.FileUploaderHelper.createButton(this.getId()+"-fu_button");this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.bMobileLib=this.oBrowse.getMetadata().getName()=="sap.m.Button";if(sap.ui.getCore().getConfiguration().getAccessibility()){if(!g.prototype._sAccText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");g.prototype._sAccText=r.getText("FILEUPLOAD_ACC");}if(this.oBrowse.addAriaDescribedBy){this.oBrowse.addAriaDescribedBy(this.getId()+"-AccDescr");}if(this.oFilePath){this.oFilePath.addAriaLabelledBy(I.getStaticId("sap.ui.unified","FILEUPLOAD_FILENAME"));}}this._submitAfterRendering=false;};
g.prototype.setIcon=function(i){this.oBrowse.setIcon(i);this.setProperty("icon",i,false);return this;};
g.prototype.setIconHovered=function(i){this.setProperty("iconHovered",i,false);if(this.oBrowse.setIconHovered){this.oBrowse.setIconHovered(i);}return this;};
g.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,false);if(this.oBrowse.setIconSelected){this.oBrowse.setIconSelected(i);}else{this.oBrowse.setActiveIcon(i);}return this;};
g.prototype.setIconFirst=function(i){this.oBrowse.setIconFirst(i);this.setProperty("iconFirst",i,false);return this;};
g.prototype.getIdForLabel=function(){return this.oBrowse.getId();};
g.prototype._ensureBackwardsReference=function(){var i=this.oBrowse,e=i.getAriaLabelledBy(),r=L.getReferencingLabels(this);if(e){r.forEach(function(l){if(e.indexOf(l)===-1){i.addAriaLabelledBy(l);}});}return this;};
g.prototype.setFileType=function(t){var T=this._convertTypesToArray(t);this.setProperty("fileType",T,false);this._rerenderInputField();return this;};
g.prototype.setMimeType=function(t){var T=this._convertTypesToArray(t);this.setProperty("mimeType",T,false);this._rerenderInputField();return this;};
g.prototype.setMultiple=function(m){this.setProperty("multiple",m,false);this._rerenderInputField();return this;};
g.prototype._rerenderInputField=function(){if(this.oFileUpload){var e=this.oFileUpload.files;this._clearInputField();this._prepareFileUpload();q(this.oFileUpload).on("change",this.handlechange.bind(this));this.oFileUpload.files=e;}};
g.prototype.setTooltip=function(t){var T;C.prototype.setTooltip.call(this,t);if(this.oFileUpload){T=this.getTooltip_AsString();if(T){this.oFileUpload.setAttribute("title",T);}else{this.oFileUpload.removeAttribute("title");}}return this;};
g.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i);this.oBrowse.addAriaLabelledBy(i);return this;};
g.prototype.removeAriaLabelledBy=function(i){var l=this.removeAssociation("ariaLabelledBy",i);this.oBrowse.removeAriaLabelledBy(l);return l;};
g.prototype.removeAllAriaLabelledBy=function(){var l=this.removeAllAssociation("ariaLabelledBy"),B=this.oBrowse.getAriaLabelledBy();l.forEach(function(s){if(B.indexOf(s)>=0){this.oBrowse.removeAriaLabelledBy(s);}}.bind(this));return l;};
g.prototype.addAriaDescribedBy=function(i){this.addAssociation("ariaDescribedBy",i);this.oBrowse.addAriaDescribedBy(i);return this;};
g.prototype.removeAriaDescribedBy=function(i){var s=this.removeAssociation("ariaDescribedBy",i);this.oBrowse.removeAriaDescribedBy(s);return s;};
g.prototype.removeAllAriaDescribedBy=function(){var e=this.removeAllAssociation("ariaDescribedBy"),B=this.oBrowse.getAriaDescribedBy();e.forEach(function(l){if(B.indexOf(l)>=0){this.oBrowse.removeAriaDescribedBy(l);}}.bind(this));return e;};
g.prototype._generateAccDescriptionText=function(){var t=this.getTooltip_AsString(),p=this.getPlaceholder(),v=this.getValue(),i=L.isRequired(this),A="";if(i){A+=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("FILEUPLOAD_REQUIRED")+" ";}if(t){A+=t+" ";}if(v){A+=v+" ";}else if(p){A+=p+" ";}A+=this._sAccText;return A;};
g.prototype._convertTypesToArray=function(t){if(typeof t==="string"){if(t===""){return[];}else{return t.split(",").map(function(T){return T.trim();});}}return t;};
g.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){q(this.oIFrameRef).off();sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);this.oIFrameRef=null;}if(this.oFileUpload){this._clearInputField();}if(this.FUEl){this.FUEl=null;}if(this.FUDataEl){this.FUDataEl=null;}};
g.prototype._clearInputField=function(){q(this.oFileUpload).off();this.oFileUpload.parentElement.removeChild(this.oFileUpload);this.oFileUpload=null;};
g.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();q(this.oFileUpload).appendTo(s);if(!this.getName()){d.warning("Name property is not set. Id would be used instead to identify the control on the server.",this);}q(this.oFileUpload).off();if(this.getIconOnly()&&this.getButtonOnly()){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getTooltip_AsString()||this.getBrowseText());}else if(this.getIconOnly()){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getBrowseText());}else{this.oBrowse.setText(this.getButtonText()||this.getBrowseText());this.oBrowse.setTooltip("");}this.oFilePath.setPlaceholder(this.getPlaceholder());};
g.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();this._cacheDOMEls();this._addLabelFeaturesToBrowse();q(this.oFileUpload).on("change",this.handlechange.bind(this));if(!this.bMobileLib){this.oFilePath.$().attr("tabindex","-1");}else{this.oFilePath.$().find('input').attr("tabindex","-1");}setTimeout(this._recalculateWidth.bind(this),0);this.oFilePath.$().find('input').removeAttr("role").attr("aria-live","polite");if(this._submitAfterRendering){this._submitAndResetValue();this._submitAfterRendering=false;}};
g.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef("fu");this.FUDataEl=this.getDomRef("fu_data");};
g.prototype.onfocusin=function(e){if(!this.oFilePath.shouldValueStateMessageBeOpened||this.oFilePath.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
g.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!b(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this.closeValueStateMessage();}};
g.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()&&this.oBrowse.getDomRef()){this.oBrowse.getDomRef().style.width=this.getWidth();}this._resizeDomElements();}};
g.prototype.getFocusDomRef=function(){return this.$("fu").get(0);};
g.prototype._resizeDomElements=function(){var i=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var $=q(this._oBrowseDomRef);var _=$.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var o=this._oFilePathDomRef;var w=this.getWidth();if(w.substr(-1)=="%"&&o){while(o.id!=i){o.style.width="100%";o=o.parentNode;}o.style.width=w;}else{if(o){o.style.width=w;var e=q(this._oFilePathDomRef);var h=e.outerWidth()-_;if(h<0){this.oFilePath.getDomRef().style.width="0px";if(this.oFileUpload){this.oFileUpload.style.width=$.outerWidth(true);}}else{this.oFilePath.getDomRef().style.width=h+"px";}}}};
g.prototype.onresize=function(){this._recalculateWidth();};
g.prototype.onThemeChanged=function(){this._recalculateWidth();};
g.prototype.setEnabled=function(e){var $=q(this.oFileUpload);this.setProperty("enabled",e);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);e?$.removeAttr('disabled'):$.attr('disabled','disabled');return this;};
g.prototype.setValueState=function(v){this.setProperty("valueState",v,true);if(this.oFilePath.setValueState){this.oFilePath.setValueState(v);}else{d.warning("Setting the valueState property with the combination of libraries used is not supported.",this);}var e=b(this.getDomRef(),document.activeElement);switch(v){case V.Error:case V.Warning:case V.Success:this.oBrowse.addAssociation("ariaDescribedBy",this.oFilePath.getId()+"-message-sr");if(e){this.openValueStateMessage();}break;default:this.oBrowse.removeAssociation("ariaDescribedBy",this.oFilePath.getId()+"-message-sr");if(e){this.closeValueStateMessage();}}return this;};
g.prototype.setValueStateText=function(v){if(this.oFilePath.setValueStateText){this.oFilePath.setValueStateText(v);}else{d.warning("Setting the valueStateText property with the combination of libraries used is not supported.",this);}return this.setProperty("valueStateText",v,true);};
g.prototype.setStyle=function(s){this.setProperty("style",s,true);if(s){if(s=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true);}else{this.oBrowse.setType("Transparent");}}else{if(this.oBrowse.setType){this.oBrowse.setType(s);}else{if(s=="Emphasized"){s="Emph";}this.oBrowse.setStyle(s);}}}return this;};
g.prototype.setValue=function(v,e,s){var o=this.getValue();var h;if((o!=v)||this.getSameFilenameAllowed()){var u=this.getUploadOnChange()&&v;this.setProperty("value",v,u);if(this.oFilePath){this.oFilePath.setValue(v);if(this.oBrowse.getDomRef()&&!s&&b(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}}var i=this.getDomRef("fu_form"),j=this.getDomRef("fu_input-inner");if(this.oFileUpload&&i&&!v){i.reset();this.getDomRef("fu_input").value="";if(j){j.value="";}q(this.FUDataEl).val(this.getAdditionalData());}if(e){if(window.File){h=this.FUEl.files;}if(!this.getSameFilenameAllowed()||v){this.fireChange({id:this.getId(),newValue:v,files:h});}}if(u){this.upload();}}return this;};
g.prototype.clear=function(){var u=this.getDomRef("fu_form");if(u){u.reset();}return this.setValue("",false,true);};
g.prototype.onmousedown=function(e){if(!this.bMobileLib){this.oBrowse.onmousedown(e);}};
g.prototype.onmouseup=function(e){if(!this.bMobileLib){this.oBrowse.onmouseup(e);}};
g.prototype.onmouseover=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');this.oBrowse.onmouseover(e);}};
g.prototype.onmouseout=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');this.oBrowse.onmouseout(e);}};
g.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);var o=this.FUDataEl;if(o){A=this.getAdditionalData()||"";o.value=A;}return this;};
g.prototype.sendFiles=function(x,e){var t=this;var A=true;for(var i=0;i<x.length;i++){if(!x[i].bPosted){A=false;break;}}if(A){if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){t.setValue("",true);}return;}var X=x[e];var s=X.file.name?X.file.name:"MultipartFile";var r=X.requestHeaders;var p=function(P){var o={lengthComputable:!!P.lengthComputable,loaded:P.loaded,total:P.total};t.fireUploadProgress({"lengthComputable":o.lengthComputable,"loaded":o.loaded,"total":o.total,"fileName":s,"requestHeaders":r});};X.xhr.upload.addEventListener("progress",p);X.xhr.onreadystatechange=function(){var R;var h;var m={};var P;var j;var k;var l;l=X.xhr.readyState;var S=X.xhr.status;if(X.xhr.readyState==4){if(X.xhr.responseXML){R=X.xhr.responseXML.documentElement.textContent;}h=X.xhr.response;P=X.xhr.getAllResponseHeaders();if(P){j=P.split("\u000d\u000a");for(var i=0;i<j.length;i++){if(j[i]){k=j[i].indexOf("\u003a\u0020");m[j[i].substring(0,k)]=j[i].substring(k+2);}}}t.fireUploadComplete({"fileName":s,"headers":m,"response":R,"responseRaw":h,"readyStateXHR":l,"status":S,"requestHeaders":r});}t._bUploading=false;};if(X.xhr.readyState===0||X.bPosted){e++;t.sendFiles(x,e);}else{X.xhr.send(X.file);X.bPosted=true;e++;t.sendFiles(x,e);}};
g.prototype.upload=function(p){var u,A;if(!this.getEnabled()){return;}u=this.getDomRef("fu_form");try{this._bUploading=true;if(this.getSendXHR()&&window.File){var e=this.FUEl.files;if(p){this._sendProcessedFilesWithXHR(e);}else{this._sendFilesWithXHR(e);}}else if(u){A=u.getAttribute("action");if(A!==this.getUploadUrl()){this._submitAfterRendering=true;}else{this._submitAndResetValue();}}}catch(E){d.error("File upload failed:\n"+E.message);}};
g.prototype._submitAndResetValue=function(){var u=this.getDomRef("fu_form");u.submit();this.fireUploadStart();this._resetValueAfterUploadStart();};
g.prototype.abort=function(h,s){if(!this.getUseMultipart()){var S=this._aXhr.length-1;for(var i=S;i>-1;i--){if(h&&s){for(var j=0;j<this._aXhr[i].requestHeaders.length;j++){var e=this._aXhr[i].requestHeaders[j].name;var v=this._aXhr[i].requestHeaders[j].value;if(e==h&&v==s){this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);d.info("File upload aborted.");break;}}}else{this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);d.info("File upload aborted.");}}}else if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort();this.fireUploadAborted({"fileName":null,"requestHeaders":null});d.info("File upload aborted.");}};
g.prototype.onclick=function(e){if(this.getSameFilenameAllowed()&&this.getEnabled()){this.setValue("",true);}if(this.oBrowse.getDomRef()&&(D.browser.safari||b(this.getDomRef(),document.activeElement))){this.oBrowse.focus();}};
g.prototype.onkeydown=function(e){if(!this.getEnabled()){return;}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true);}var k=e.keyCode;if(k===K.ENTER){if(this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation();}}this.oBrowse._bPressedSpace=false;};
g.prototype.onkeyup=function(e){if(!this.getEnabled()){return;}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true);}var k=e.keyCode,h=K;if(k===h.DELETE||k===h.BACKSPACE){if(this.oFileUpload){this.setValue("",true);}}else if(k===h.SPACE){this.oFileUpload.click();e.preventDefault();e.stopPropagation();}else if(k!==h.TAB&&k!==h.SHIFT&&k!==h.F6&&k!==h.PAGE_UP&&k!==h.PAGE_DOWN&&k!==h.ESCAPE&&k!==h.END&&k!==h.HOME&&k!==h.ARROW_LEFT&&k!==h.ARROW_UP&&k!==h.ARROW_RIGHT&&k!==h.ARROW_DOWN){e.preventDefault();e.stopPropagation();}this.oBrowse._bPressedSpace=false;};
g.prototype._isFilenameTooLong=function(s){var m=this.getMaximumFilenameLength();if(m!==0&&s.length>m){d.info("The filename of "+s+" ("+s.length+" characters)  is longer than the maximum of "+m+" characters.");return true;}return false;};
g.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var h=this.getFileType();var s='';var w,n,i,j;var u=this.getDomRef("fu_form");if(window.File){var k=e.target.files;if(this._areFilesAllowed(k)){this.fireFileAllowed();s=this._generateInputValue(k);}else{u.reset();this.setValue("",true,true);return;}}else if(h&&h.length>0){w=true;n=this.oFileUpload.value||"";i=n.lastIndexOf(".");j=(i===-1)?"":n.substring(i+1);for(var l=0;l<h.length;l++){if(j==h[l]){w=false;}}if(w){d.info("File: "+n+" is of type "+j+". Allowed types are: "+h+".");this.fireTypeMissmatch({fileName:n,fileType:j});u.reset();this.setValue("",true,true);return;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});u.reset();this.setValue("",true,true);return;}if(n){this.fireFileAllowed();}}var v=this.oFileUpload.value||"";var m=v.lastIndexOf("\\");if(m>=0){v=v.substring(m+1);}if(this.getMultiple()){v=s;}if(v||D.browser.chrome){this.setValue(v,true);}}};
g.prototype._sendFilesWithXHR=function(e){var h,s,v,x,X=this.getXhrSettings();if(e.length>0){if(this.getUseMultipart()){h=1;}else{h=e.length;}this._aXhr=this._aXhr||[];for(var j=0;j<h;j++){this._uploadXHR=new window.XMLHttpRequest();x={xhr:this._uploadXHR,requestHeaders:[]};this._aXhr.push(x);x.xhr.open(this.getHttpRequestMethod(),this.getUploadUrl(),true);if(X){x.xhr.withCredentials=X.getWithCredentials();}if(this.getHeaderParameters()){var n=this.getHeaderParameters();for(var i=0;i<n.length;i++){s=n[i].getName();v=n[i].getValue();x.requestHeaders.push({name:s,value:v});}}var o=e[j].name;var r=x.requestHeaders;x.fileName=o;x.file=e[j];this.fireUploadStart({"fileName":o,"requestHeaders":r});for(var k=0;k<r.length;k++){if(x.xhr.readyState===0){break;}s=r[k].name;v=r[k].value;x.xhr.setRequestHeader(s,v);}}if(this.getUseMultipart()){var p=new window.FormData();var t=this.FUEl.name;for(var l=0;l<e.length;l++){this._appendFileToFormData(p,t,e[l]);}p.append("_charset_","UTF-8");var u=this.FUDataEl.name;if(this.getAdditionalData()){var w=this.getAdditionalData();p.append(u,w);}else{p.append(u,"");}if(this.getParameters()){var P=this.getParameters();for(var m=0;m<P.length;m++){var N=P[m].getName();v=P[m].getValue();p.append(N,v);}}x.file=p;this.sendFiles(this._aXhr,0);}else{this.sendFiles(this._aXhr,0);}this._bUploading=false;this._resetValueAfterUploadStart();}return this;};
g.prototype._appendFileToFormData=function(o,s,e){if(e instanceof window.Blob&&e.name){o.append(s,e,e.name);}else{o.append(s,e);}};
g.prototype._sendProcessedFilesWithXHR=function(e){this.getProcessedBlobsFromArray(e).then(function(B){this._sendFilesWithXHR(B);}.bind(this)).catch(function(r){d.error("File upload failed: "+r&&r.message?r.message:"no details available");});return this;};
g.prototype._areFilesAllowed=function(e){var n,w,h,s,t,m=this.getMaximumFileSize(),M=this.getMimeType(),l=this.getFileType();for(var i=0;i<e.length;i++){n=e[i].name;t=e[i].type||"unknown";var S=((e[i].size/1024)/1024);if(m&&(S>m)){d.info("File: "+n+" is of size "+S+" MB which exceeds the file size limit of "+m+" MB.");this.fireFileSizeExceed({fileName:n,fileSize:S});return false;}if(S===0){d.info("File: "+n+" is empty!");this.fireFileEmpty({fileName:n});}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return false;}if(M&&M.length>0){var W=true;for(var j=0;j<M.length;j++){if(t==M[j]||M[j]=="*/*"||t.match(M[j])){W=false;}}if(W&&t!=="unknown"){d.info("File: "+n+" is of type "+t+". Allowed types are: "+M+".");this.fireTypeMissmatch({fileName:n,mimeType:t});return false;}}if(l&&l.length>0){w=true;h=n.lastIndexOf(".");s=(h===-1)?"":n.substring(h+1);for(var k=0;k<l.length;k++){if(s.toLowerCase()==l[k].toLowerCase()){w=false;}}if(w){d.info("File: "+n+" is of type "+s+". Allowed types are: "+l+".");this.fireTypeMissmatch({fileName:n,fileType:s});return false;}}}return true;};
g.prototype._sendFilesFromDragAndDrop=function(e){if(this._areFilesAllowed(e)){this._sendFilesWithXHR(e);}return this;};
g.prototype._generateInputValue=function(e){var s="";for(var i=0;i<e.length;i++){s=s+'"'+e[i].name+'" ';}return s;};
g.prototype.getBrowseText=function(){if(!g.prototype._sBrowseText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");g.prototype._sBrowseText=r.getText("FILEUPLOAD_BROWSE");}return g.prototype._sBrowseText?g.prototype._sBrowseText:"Browse...";};
g.prototype.getShortenValue=function(){return this.getValue();};
g.prototype.prepareFileUploadAndIFrame=function(){this._prepareFileUpload();if(!this.oIFrameRef){var i=document.createElement("iframe");i.style.display="none";i.id=this.getId()+"-frame";sap.ui.getCore().getStaticAreaRef().appendChild(i);i.contentWindow.name=this.getId()+"-frame";this._bUploading=false;q(i).on("load",function(e){if(this._bUploading){d.info("File uploaded to "+this.getUploadUrl());var r;try{r=this.oIFrameRef.contentWindow.document.body.innerHTML;}catch(h){}this.fireUploadComplete({"response":r});this._bUploading=false;}}.bind(this));this.oIFrameRef=i;}};
g.prototype._prepareFileUpload=function(){if(!this.oFileUpload){var e=[];e.push('<input ');e.push('type="file" ');e.push('aria-hidden="true" ');if(this.getName()){if(this.getMultiple()){e.push('name="'+f(this.getName())+'[]" ');}else{e.push('name="'+f(this.getName())+'" ');}}else{if(this.getMultiple()){e.push('name="'+this.getId()+'[]" ');}else{e.push('name="'+this.getId()+'" ');}}e.push('id="'+this.getId()+'-fu" ');e.push('tabindex="-1" ');e.push('size="1" ');if(this.getTooltip_AsString()){e.push('title="'+f(this.getTooltip_AsString())+'" ');}else if(this.getValue()!==""){e.push('title="'+f(this.getValue())+'" ');}if(!this.getEnabled()){e.push('disabled="disabled" ');}if(this.getMultiple()){e.push('multiple ');}if((this.getMimeType()||this.getFileType())&&window.File){var A=this._getAcceptedTypes();e.push('accept="'+f(A)+'" ');}e.push('>');this.oFileUpload=q(e.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);}else{q(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));}};
g.prototype.openValueStateMessage=function(){if(this.oFilePath.openValueStateMessage){this.oFilePath.openValueStateMessage();}};
g.prototype.closeValueStateMessage=function(){if(this.oFilePath.closeValueStateMessage){this.oFilePath.closeValueStateMessage();}};
g.prototype._getAcceptedTypes=function(){var m=this.getMimeType()||[],e=this.getFileType()||[];e=e.map(function(i){return i.indexOf(".")===0?i:"."+i;});return e.concat(m).join(",");};
g.prototype._resetValueAfterUploadStart=function(){d.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()){this.setValue("",true);}};
g.prototype._addLabelFeaturesToBrowse=function(){var $;if(this.oBrowse&&this.oBrowse.$().length){$=this.oBrowse.$();$.attr("type', 'button");$.off("click").on("click",function(e){e.preventDefault();this.FUEl.click();}.bind(this));}};
g.prototype.getProcessedBlobsFromArray=function(B){return new Promise(function(r){r(B);});};
g.prototype.checkFileReadable=function(){return new Promise(function(r,e){var R;if(window.File&&this.FUEl&&this.FUEl.files.length){var R=new FileReader();R.readAsArrayBuffer(this.FUEl.files[0].slice(0,1));R.onload=function(){r();};R.onerror=function(){e(R.error);};}else{r();}}.bind(this));};
return g;});
sap.ui.predefine('sap/ui/unified/FileUploaderHttpRequestMethod',[],function(){"use strict";var F={Post:"POST",Put:"PUT"};return F;});
sap.ui.predefine('sap/ui/unified/FileUploaderParameter',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderParameter",{metadata:{library:"sap.ui.unified",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
return F;});
sap.ui.predefine('sap/ui/unified/FileUploaderRenderer',['sap/ui/unified/library',"sap/ui/thirdparty/jquery"],function(l,q){"use strict";var F=function(){};F.apiVersion=2;
F.render=function(r,f){var e=f.getEnabled(),t=f.getTooltip_AsString();r.openStart("div",f);r.class("sapUiFup");if(f.getButtonOnly()){r.class("sapUiFupButtonOnly");}var c=l.FileUploaderHelper.addFormClass();if(c){r.class(c);}if(!e){r.class("sapUiFupDisabled");}r.openEnd();r.openStart("form",f.getId()+"-fu_form");r.style("display","inline-block");r.attr("enctype","multipart/form-data");r.attr("method",f.getHttpRequestMethod().toLowerCase());r.attr('action',f.getUploadUrl());r.attr('target',f.getId()+'-frame');r.openEnd();r.openStart("div");if(!f.bMobileLib){r.class("sapUiFupInp");}r.openEnd();r.openStart("div");r.class("sapUiFupGroup");r.style("border","0");r.style("cellPadding","0");r.style("cellSpacing","0");r.openEnd();r.openStart("div");r.openEnd();r.openStart("div");if(f.getButtonOnly()){r.style("display","none");}r.openEnd();r.renderControl(f.oFilePath);r.close("div");r.openStart("div");r.openEnd();f._ensureBackwardsReference();r.renderControl(f.oBrowse);r.openStart("span",f.getId()+"-AccDescr");r.class("sapUiInvisibleText");r.attr("aria-hidden","true");r.openEnd();r.text(f._generateAccDescriptionText());r.close("span");r.close("div");r.close("div");r.close("div");var n=f.getName()||f.getId();r.openStart("div");r.class("sapUiFupInputMask");if(t&&t.length){r.attr('title',t);}r.openEnd();r.voidStart("input");r.attr("type","hidden");r.attr("name","_charset_");r.attr("aria-hidden","true");r.voidEnd();r.voidStart("input",f.getId()+"-fu_data");r.attr("type","hidden");r.attr("aria-hidden","true");r.attr('name',n+'-data');r.attr('value',f.getAdditionalData()||"");r.voidEnd();q.each(f.getParameters(),function(i,p){r.voidStart("input");r.attr("type","hidden");r.attr("aria-hidden","true");r.attr('name',p.getName()||"");r.attr('value',p.getValue()||"");r.voidEnd();});r.close("div");r.close("div");r.close("form");r.close("div");};
return F;},true);
sap.ui.predefine('sap/ui/unified/FileUploaderXHRSettings',['sap/ui/core/Element','./library'],function(E){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderXHRSettings",{metadata:{library:"sap.ui.unified",properties:{withCredentials:{type:"boolean",group:"Data",defaultValue:false}}}});
return F;});
sap.ui.predefine('sap/ui/unified/Menu',['sap/ui/core/Element','sap/ui/core/Control','sap/ui/Device','sap/ui/core/Popup','./MenuItemBase','./library','sap/ui/core/library','sap/ui/unified/MenuRenderer',"sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/events/ControlEvents","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave"],function(E,C,D,P,M,l,c,a,b,q,K,L,d,f,g){"use strict";var h=P.Dock;var O=c.OpenState;
var j=C.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null,deprecated:true},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
(function(w){j.prototype.bCozySupported=true;j._DELAY_SUBMENU_TIMER=300;j._DELAY_SUBMENU_TIMER_EXT=400;
j.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this._bOpenedAsContextMenu=false;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};
j.prototype._setCustomEnhanceAccStateFunction=function(e){this._fnCustomEnhanceAccStateFunction=e;};
j.prototype.enhanceAccessibilityState=function(e,A){var i=typeof this._fnCustomEnhanceAccStateFunction==="function";if(i){this._fnCustomEnhanceAccStateFunction(e,A);}};
j.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();this._detachResizeHandler();};
j.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};
j.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();this.$().off("mousemove");};
j.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){L.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove();}var I=this.getItems();for(var i=0;i<I.length;i++){if(I[i].onAfterRendering&&I[i].getDomRef()){I[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}m(this);this.$().on("mousemove",this._focusMenuItem.bind(this));};
j.prototype._focusMenuItem=function(e){if(!D.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i){return;}if(this.oOpenedSubMenu&&b(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);i&&i.focus(this);this._openSubMenuDelayed(i);};
j.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===O.OPEN){m(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};
j.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};
j.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};
j.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=setTimeout(function(){var o=this.getDomRef();if(o){var r=sap.ui.getCore().createRenderManager();a.renderItems(r,this);r.flush(o);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}}.bind(this),0);};
j.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){clearTimeout(this._itemRerenderTimer);delete this._itemRerenderTimer;}};
j.prototype._detachResizeHandler=function(){if(this._hasResizeListener){D.resize.detachHandler(this._handleResizeChange,this);this._hasResizeListener=false;}};
j.prototype.open=function(W,o,e,i,n,p,r){var N;if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,e,i,n,p||"0 0",r||"flipfit flipfit",function(t){var u=this.getPopup()._getOfDom(n);if(!u||!q(u).is(":visible")||!_(u)){this.close();}else{this.getPopup()._applyPosition(t.lastPosition);}}.bind(this));this.bOpen=true;D.resize.attachHandler(this._handleResizeChange,this);this._hasResizeListener=true;if(W||this.getRootMenu().getId()===this.getId()){N=this.getNextSelectableItem(-1);this.setHoveredItem(N);N&&N.focus(this);}d.bindAnyEvent(this.fAnyEventHandlerProxy);if(D.support.orientation&&this.getRootMenu()===this){q(w).on("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};
j.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition);};
j.prototype.openAsContextMenu=function(e,o){var i,n,r,p,t;o=o instanceof E?o.getDomRef():o;if(e instanceof q.Event){t=q(o).offset();i=e.pageX-t.left;n=e.pageY-t.top;this._iX=e.clientX;this._iY=e.clientY;}else{i=e.offsetX||0;n=e.offsetY||0;this._iX=e.left||0;this._iY=e.top||0;}r=sap.ui.getCore().getConfiguration().getRTL();p=h;if(r){i=o.clientWidth-i;}this._bOpenedAsContextMenu=true;this.open(true,o,p.BeginTop,p.BeginTop,o,i+" "+n,'fit');};
j.prototype._handleOpened=function(){var $,W,i,e,r,B,R,n,o,p;if(!this._bOpenedAsContextMenu){return;}$=this.$();W=q(w);i=this._iX;e=this._iY;r=W.scrollLeft()+W.width();B=W.scrollTop()+W.height();R=sap.ui.getCore().getConfiguration().getRTL();n=false;o=$.width();p=$.height();if(e+p>B){e=e-p;n=true;}if(R){if((r-i)+o>r){i=r-(i+o);n=true;}else{i=r-i;n=true;}}else{if(i+o>r){i=i-o;n=true;}}this._bOpenedAsContextMenu=false;n&&this.oPopup.setPosition("begin top","begin top",W,i+" "+e,"flipfit");};
j.prototype.close=function(W){if(!this.bOpen||j._dbg){return;}this._discardOpenSubMenuDelayed();s(this,false);delete this._bFixed;d.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).off("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();if(!W){this.bIgnoreOpenerDOMRef=true;}this.getPopup().close(0);this._detachResizeHandler();this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};
j.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){L.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};
j.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};
j.prototype.onsapnext=function(e){var i,n,S=this.oHoveredItem?this.oHoveredItem.getSubmenu():undefined;if(e.keyCode!=K.ARROW_DOWN){if(S&&this.checkEnabled(this.oHoveredItem)){if(S.bOpen){n=S.getNextSelectableItem(-1);S.setHoveredItem(n);n&&n.focus(this);}else{this.openSubmenu(this.oHoveredItem,true);}}return;}if(S&&S.bOpen){this.closeSubmenu(false,true);}i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;n=this.getNextSelectableItem(i);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapnextmodifiers=j.prototype.onsapnext;
j.prototype.onsapprevious=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,p=this.getPreviousSelectableItem(i),S=this.oHoveredItem?this.oHoveredItem.getSubmenu():null;if(e.keyCode!=K.ARROW_UP){if(this.isSubMenu()){this.close(true);}e.preventDefault();e.stopPropagation();return;}if(S&&S.bOpen){this.closeSubmenu(false,true);}this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappreviousmodifiers=j.prototype.onsapprevious;
j.prototype.onsaphome=function(e){var n=this.getNextSelectableItem(-1);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapend=function(e){var p=this.getPreviousSelectableItem(this.getItems().length);this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappagedown=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,n;if(this.getPageSize()<1){this.onsapend(e);return;}i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}n=this.getNextSelectableItem(i-1);this.setHoveredItem(n);n&&n.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsappageup=function(e){var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1,p;if(this.getPageSize()<1){this.onsaphome(e);return;}i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}p=this.getPreviousSelectableItem(i+1);this.setHoveredItem(p);p&&p.focus(this);e.preventDefault();e.stopPropagation();};
j.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};
j.prototype.onkeyup=function(e){if(this.oHoveredItem&&(q(e.target).prop("tagName")!="INPUT")){var o=this.oHoveredItem.getDomRef();q(o).trigger("focus");}if(!this._sapSelectOnKeyDown&&(e.key!==K.Space||(!D.os.macintosh&&w.navigator.maxTouchPoints<=1))){return;}else{this._sapSelectOnKeyDown=false;}if(!f.events.sapselect.fnCheck(e)&&e.key!=="Enter"){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};
j.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};
j.prototype.onsapbackspacemodifiers=j.prototype.onsapbackspace;
j.prototype.onsapescape=function(e){this.close(true);e.preventDefault();e.stopPropagation();};
j.prototype.onsaptabnext=function(e){if(this.isSubMenu()){e.preventDefault();}this.close(true);e.stopPropagation();};
j.prototype.onsaptabprevious=j.prototype.onsaptabnext;
j.prototype._openSubMenuDelayed=function(i){if(!i){return;}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=setTimeout(function(){this.checkEnabled(i)&&this.closeSubmenu(false,true);if(this.checkEnabled(i)&&i.getSubmenu()){this.setHoveredItem(i);i&&i.focus(this);this.openSubmenu(i,false,true);}}.bind(this),i.getSubmenu()&&this.checkEnabled(i)?j._DELAY_SUBMENU_TIMER:j._DELAY_SUBMENU_TIMER_EXT);};
j.prototype._discardOpenSubMenuDelayed=function(i){if(this._delayedSubMenuTimer){clearTimeout(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null;}};
j.prototype.onmouseout=function(e){if(!D.system.desktop){return;}if(g(e,this.getDomRef())){this.setHoveredItem(null);if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(this.oHoveredItem);}this._discardOpenSubMenuDelayed();}};
j.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};
j.prototype.handleOuterEvent=function(o,e){var i=false,t=D.support.touch||D.system.combi;this.bIgnoreOpenerDOMRef=false;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var n=this;while(n&&!i){if(b(n.getDomRef(),e.target)){i=true;}n=n.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var n=this;while(n&&!i){if((n.oOpenedSubMenu&&n.oOpenedSubMenu.getId()==e.relatedControlId)||b(n.getDomRef(),q(document.getElementById(e.relatedControlId)).get(0))){i=true;}n=n.oOpenedSubMenu;}}if(!i){this.bIgnoreOpenerDOMRef=true;}}if(!i){this.close();}};
j.prototype.getItemByDomRef=function(o){var I=this.getItems(),e=I.length;for(var i=0;i<e;i++){var n=I[i],p=n.getDomRef();if(b(p,o)){return n;}}return null;};
j.prototype.selectItem=function(i,W,e){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close(true);}else{if(!D.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:e});this.getRootMenu().fireItemSelect({item:i});};
j.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof j;};
j.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};
j.prototype.getMenuLevel=function(){var i=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();i++;}return i;};
j.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);this.oPopup.attachOpened(this._handleOpened,this);}return this.oPopup;};
j.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;return;}this.oHoveredItem=i;i.hover(true,this);this.scrollToItem(this.oHoveredItem);};
j.prototype.openSubmenu=function(i,W,e){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(e&&this.oOpenedSubMenu._bFixed)||(!e&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var n=P.Dock;S.open(W,i,n.BeginTop,n.EndTop,i,"-4 4");}};
j.prototype.closeSubmenu=function(i,I){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(I){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};
j.prototype.scrollToItem=function(i){var o=this.getDomRef(),I=i?i.getDomRef():null;if(!I||!o){return;}var e=o.scrollTop,n=I.offsetTop,p=q(o).height(),r=q(I).height();if(e>n){o.scrollTop=n;}else if((n+r)>(e+p)){o.scrollTop=Math.ceil(n+r-p);}};
j.prototype._bringToFront=function(){q(document.getElementById(this.getPopup().getId())).mousedown();};
j.prototype.checkEnabled=function(i){return i&&i.getEnabled()&&this.getEnabled();};
j.prototype.getNextSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=I;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.getPreviousSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=I;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
j.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;j.rerenderMenu(this.getRootMenu());};
j.rerenderMenu=function(o){var I=o.getItems();for(var i=0;i<I.length;i++){var S=I[i].getSubmenu();if(S){j.rerenderMenu(S);}}o.invalidate();o.rerender();};
j.prototype.focus=function(){if(this.bOpen){C.prototype.focus.apply(this,arguments);}};
j.prototype.isCozy=function(){if(!this.bCozySupported){return false;}if(this.hasStyleClass("sapUiSizeCozy")){return true;}if(k(this.oOpenerRef)){return true;}if(k(this.getParent())){return true;}return false;};
function k(r){if(!r){return false;}r=r.$?r.$():q(r);return r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy");}
function s(o,e){var p=o.getParent();if(p&&p instanceof M){p.onSubmenuToggle(e);}}
function m(o){var e=o.getMaxVisibleItems(),n=document.documentElement.clientHeight-10,$=o.$();if(e>0){var I=o.getItems();for(var i=0;i<I.length;i++){if(I[i].getDomRef()){n=Math.min(n,I[i].$().outerHeight(true)*e);break;}}}if($.outerHeight(true)>n){$.css("max-height",n+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}
function _(o){var r;if(!o){return false;}if(o instanceof q){o=o.get(0);}r=o.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(w.innerHeight||document.documentElement.clientHeight)&&r.right<=(w.innerWidth||document.documentElement.clientWidth));}
})(window);return j;});
sap.ui.predefine('sap/ui/unified/MenuItem',['sap/ui/core/IconPool','./MenuItemBase','./library','sap/ui/core/library'],function(I,M,l,c){"use strict";
var a=M.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
I.insertFontFaceStyle();
a.prototype.render=function(r,i,m,o){var b=r,s=i.getSubmenu(),d=i.getEnabled();b.openStart("li",i);if(i.getVisible()&&d){b.attr("tabindex","0");}b.class("sapUiMnuItm");if(o.iItemNo==1){b.class("sapUiMnuItmFirst");}else if(o.iItemNo==o.iTotalItems){b.class("sapUiMnuItmLast");}if(!m.checkEnabled(i)){b.class("sapUiMnuItmDsbl");}if(i.getStartsSection()){b.class("sapUiMnuItmSepBefore");}if(!d){b.attr("disabled","disabled");}if(i.getTooltip_AsString()){b.attr("title",i.getTooltip_AsString());}if(o.bAccessible){b.accessibilityState(i,{role:"menuitem",disabled:null,posinset:o.iItemNo,setsize:o.iTotalItems,labelledby:{value:this.getId()+"-txt",append:true}});if(s){b.attr("aria-haspopup",c.aria.HasPopup.Menu.toLowerCase());b.attr("aria-owns",s.getId());}}b.openEnd();b.openStart("div");b.class("sapUiMnuItmL");b.openEnd();b.close("div");if(i.getIcon()){b.openStart("div");b.class("sapUiMnuItmIco");b.openEnd();b.icon(i.getIcon(),null,{title:null});b.close("div");}b.openStart("div",this.getId()+"-txt");b.class("sapUiMnuItmTxt");b.openEnd();b.text(i.getText());b.close("div");b.openStart("div",this.getId()+"-scuttxt");b.class("sapUiMnuItmSCut");b.openEnd();b.close("div");b.openStart("div");b.class("sapUiMnuItmSbMnu");b.openEnd();if(s){b.openStart("div");b.class("sapUiIconMirrorInRTL");b.openEnd();b.close("div");}b.close("div");b.openStart("div");b.class("sapUiMnuItmR");b.openEnd();b.close("div");b.close("li");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);};
a.prototype.focus=function(m){if(this.getEnabled()&&this.getVisible()){this.$().trigger("focus");}else{m.focus();}};
return a;});
sap.ui.predefine('sap/ui/unified/MenuItemBase',['sap/ui/core/Element','./library'],function(E,l){"use strict";
var M=E.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
M.prototype.init=function(){};
M.prototype.render=function(r,i,m){var a=r;a.openStart("li",i);a.openEnd();a.openStart("div",this.getId()+"-txt");a.style("white-space","nowrap");a.style("display","inline-block");a.style("padding","1px");a.style("color","black");a.openEnd();a.text(i.getId());if(this.getSubmenu()){a.text("&nbsp;&nbsp;->");}a.close("div");a.close("li");};
M.prototype.hover=function(h,m){this.$("txt").attr("style",h?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;");};
M.prototype.focus=function(){};
M.prototype.onSubmenuToggle=function(o){this.$().toggleClass("sapUiMnuItmSubMnuOpen",o);};
M.prototype.onAfterRendering=function(){};
M.prototype.onsapshow=function(e){if(this.getParent()&&this.getParent().close){this.getParent().close(true);}e.preventDefault();};
M.prototype.onsaphide=M.prototype.onsapshow;return M;});
sap.ui.predefine('sap/ui/unified/MenuRenderer',[],function(){"use strict";var M={apiVersion:2};
M.render=function(r,m){var a=sap.ui.getCore().getConfiguration().getAccessibility(),R=m.getRootMenu();if(m.oHoveredItem&&m.indexOfItem(m.oHoveredItem)<0){m.oHoveredItem=null;}r.openStart("div",m);r.attr("tabindex",-1);r.attr("hideFocus",true);if(m.getTooltip_AsString()){r.attr("title",m.getTooltip_AsString());}if(a){r.accessibilityState(m,{disabled:null});}r.class("sapUiMnu");if(m.isSubMenu()){r.class("sapUiSubmenu");}if(R.bUseTopStyle){r.class("sapUiMnuTop");}if(R.isCozy()){r.class("sapUiSizeCozy");}if(m.bCozySupported){r.class("sapUiMnuCozySupport");}r.openEnd();M.renderItems(r,m);r.close("div");};
M.renderItems=function(r,m){var I=m.getItems(),a=sap.ui.getCore().getConfiguration().getAccessibility(),h=false,H=false,n=0,b=0,i,o;r.openStart("ul");r.attr("role","menu");r.class("sapUiMnuLst");for(i=0;i<I.length;i++){if(I[i].getIcon&&I[i].getIcon()){h=true;}if(I[i].getSubmenu()){H=true;}}if(!h){r.class("sapUiMnuNoIco");}if(!H){r.class("sapUiMnuNoSbMnu");}r.openEnd();n=0;for(i=0;i<I.length;i++){if(I[i].getVisible()&&I[i].render){n++;}}for(i=0;i<I.length;i++){o=I[i];if(o.getVisible()&&o.render){b++;if(o.getStartsSection()){r.openStart("li");if(a){r.attr("role","separator");}r.class("sapUiMnuDiv");r.openEnd();r.openStart("div");r.class("sapUiMnuDivL");r.openEnd();r.close("div");r.voidStart("hr").voidEnd();r.openStart("div");r.class("sapUiMnuDivR");r.openEnd();r.close("div");r.close("li");}o.render(r,o,m,{bAccessible:a,iItemNo:b,iTotalItems:n});}}r.close("ul");};
return M;},true);
sap.ui.predefine('sap/ui/unified/MenuTextFieldItem',['sap/ui/core/ValueStateSupport','./MenuItemBase','./library','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/Device','sap/base/Log','sap/ui/events/PseudoEvents','sap/ui/core/InvisibleText','sap/ui/core/Core','sap/ui/dom/jquery/cursorPos'],function(V,M,l,I,c,D,L,P,a,C){"use strict";var b=c.ValueState;
var d=M.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:b.None}}}});
(function(){
d.prototype.render=function(r,i,m,o){var e=r,f=m.checkEnabled(i),g=i.getId();e.openStart("li",i);e.class("sapUiMnuItm").class("sapUiMnuTfItm");if(o.iItemNo==1){e.class("sapUiMnuItmFirst");}else if(o.iItemNo==o.iTotalItems){e.class("sapUiMnuItmLast");}if(!m.checkEnabled(i)){e.class("sapUiMnuItmDsbl");}if(i.getStartsSection()){e.class("sapUiMnuItmSepBefore");}if(!f){e.attr("disabled","disabled");}if(o.bAccessible){e.attr("role","menuitem");e.attr("aria-posinset",o.iItemNo);e.attr("aria-setsize",o.iTotalItems);}e.openEnd();e.openStart("div").class("sapUiMnuItmL").openEnd().close("div");e.openStart("div").class("sapUiMnuItmIco").openEnd();if(i.getIcon()){e.icon(i.getIcon(),null,{title:null});}e.close("div");e.openStart("div",g+"-txt").class("sapUiMnuItmTxt").openEnd();e.openStart("label",g+"-lbl").class("sapUiMnuTfItemLbl").openEnd();e.text(i.getLabel());e.close("label");e.openStart("div",g+"-str").class("sapUiMnuTfItmStretch").openEnd().close("div");e.openStart("div").class("sapUiMnuTfItemWrppr").openEnd();e.voidStart("input",g+"-tf").attr("tabindex","-1");if(i.getValue()){e.attr("value",i.getValue());}e.class("sapUiMnuTfItemTf").class(f?"sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTfDsbl");if(!f){e.attr("disabled","disabled");}if(o.bAccessible){e.accessibilityState(i,{role:"textbox",disabled:null,multiline:false,autocomplete:"none",describedby:g+"-lbl "+i._fnInvisibleCountInformationFactory(o).getId()});}e.voidEnd().close("div").close("div");e.openStart("div").class("sapUiMnuItmR").openEnd().close("div");e.close("li");};
d.prototype.exit=function(){if(this._invisibleCountInformation){this._fnInvisibleCountInformationFactory().destroy();this._invisibleCountInformation=null;}};
d.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);if(h&&m.checkEnabled(this)){m.closeSubmenu(false,true);}};
d.prototype.focus=function(m){if(this.getEnabled()&&this.getVisible()){this.$("tf").get(0).focus();}else{m.focus();}};
d.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState());};
d.prototype.onsapup=function(e){this.getParent().onsapprevious(e);};
d.prototype.onsapdown=function(e){this.getParent().onsapnext(e);};
d.prototype.onsaphome=function(e){if(this._checkCursorPosForNav(false)){this.getParent().onsaphome(e);}};
d.prototype.onsapend=function(e){if(this._checkCursorPosForNav(true)){this.getParent().onsapend(e);}};
d.prototype.onsappageup=function(e){this.getParent().onsappageup(e);};
d.prototype.onsappagedown=function(e){this.getParent().onsappagedown(e);};
d.prototype.onsapescape=function(e){this.getParent().onsapescape(e);};
d.prototype.onkeydown=function(e){e.stopPropagation();};
d.prototype.onclick=function(e){this.getParent().closeSubmenu(false,true);if(!D.system.desktop&&this.getParent().checkEnabled(this)){this.focus();}e.stopPropagation();};
d.prototype.onkeyup=function(e){if(!P.events.sapenter.fnCheck(e)&&e.key!=="Enter"){return;}var v=this.$("tf").val();this.setValue(v);this.getParent().selectItem(this);e.preventDefault();e.stopPropagation();};
d.prototype.setSubmenu=function(m){L.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this;};
d.prototype.setLabel=function(s){this.setProperty("label",s,true);this.$("lbl").text(s);this._adaptSizes();return this;};
d.prototype.setValue=function(v){this.setProperty("value",v,true);this.$("tf").val(v);return this;};
d.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var $=this.$("tf");$.toggleClass("sapUiMnuTfItemTfErr",v==b.Error);$.toggleClass("sapUiMnuTfItemTfWarn",v==b.Warning);var t=V.enrichTooltip(this,this.getTooltip_AsString());if(t){this.$().attr("title",t);}return this;};
d.prototype.getFocusDomRef=function(){var f=this.$("tf");return f.length?f.get(0):null;};
d.prototype._adaptSizes=function(){var $=this.$("tf");var e=this.$("lbl");var o=e.length?e.get(0).offsetLeft:0;if(C.getConfiguration().getRTL()){$.parent().css({"width":"auto","right":(this.$().outerWidth(true)-o+(e.outerWidth(true)-e.outerWidth()))+"px"});}else{$.parent().css({"width":"auto","left":(o+e.outerWidth(true))+"px"});}};
d.prototype._checkCursorPosForNav=function(f){var r=sap.ui.getCore().getConfiguration().getRTL();var B=f?r:!r;var $=this.$("tf");var p=$.cursorPos();var i=$.val().length;if(r){p=i-p;}if((!B&&p!=i)||(B&&p!=0)){return false;}return true;};
d.prototype._fnInvisibleCountInformationFactory=function(i){if(!this._invisibleCountInformation){this._invisibleCountInformation=new a({text:C.getLibraryResourceBundle("sap.ui.unified").getText("UNIFIED_MENU_ITEM_COUNT_TEXT",[i.iItemNo,i.iTotalItems])}).toStatic();}return this._invisibleCountInformation;};
}());return d;});
sap.ui.predefine('sap/ui/unified/Shell',['./ShellHeader','./ShellLayout','./library','./ShellRenderer'],function(S,a,l,b){"use strict";
var c=a.extend("sap.ui.unified.Shell",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showCurtain:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},showCurtainPane:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},searchVisible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{curtainContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainContent"},curtainPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainPaneContent"},headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headItem",forwarding:{idSuffix:"-header",aggregation:"headItems"}},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headEndItem",forwarding:{idSuffix:"-header",aggregation:"headEndItems"}},search:{type:"sap.ui.core.Control",multiple:false,forwarding:{idSuffix:"-header",aggregation:"search"}},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false,forwarding:{idSuffix:"-header",aggregation:"user"}}}}});
c.prototype.init=function(){a.prototype.init.apply(this,arguments);this._header=new S(this.getId()+"-header");this.setHeader(this._header);};
c.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._header.destroy();delete this._header;};
c.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var s=this._header.$("hdr-center").children();if(s.length){return s.width();}}return-1;};
c.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._header.setLogo(i);return this;};
c.prototype.getIcon=function(){return this._header.getLogo();};
c.prototype.setSearchVisible=function(s){this.setProperty("searchVisible",s,true);this._header.setSearchVisible(s);return this;};
c.prototype.getSearchVisible=function(){return this._header.getSearchVisible();};
c.prototype.setHeader=function(h){return a.prototype.setHeader.apply(this,[h?h:this._header]);};
c.prototype.destroyHeader=function(){if(this.getHeader()===this._header){return this;}return a.prototype.destroyHeader.apply(this,[]);};
return c;});
sap.ui.predefine('sap/ui/unified/ShellHeadItem',['sap/ui/core/Element','sap/ui/core/IconPool','./library',"sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(E,I,l,e,q){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadItem",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{startsSection:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},showSeparator:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Appearance",defaultValue:false},toggleEnabled:{type:"boolean",group:"Appearance",defaultValue:true},showMarker:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
S.prototype.onclick=function(o){this.firePress();o.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setStartsSection=function(s){s=!!s;this.setProperty("startsSection",s,true);this.$().toggleClass("sapUiUfdShellHeadItmDelim",s);return this;};
S.prototype.setShowSeparator=function(s){s=!!s;this.setProperty("showSeparator",s,true);this.$().toggleClass("sapUiUfdShellHeadItmSep",s);return this;};
function _(){var t=this.$(),T=this.getToggleEnabled(),s=this.getSelected();if(!t.length){return;}if(T){t.toggleClass("sapUiUfdShellHeadItmSel",s);t.attr("aria-pressed",s);}else{t.removeClass("sapUiUfdShellHeadItmSel");t.removeAttr("aria-pressed");}}
S.prototype.setToggleEnabled=function(b){this.setProperty("toggleEnabled",!!b,true);_.apply(this);return this;};
S.prototype.setSelected=function(s){this.setProperty("selected",!!s,true);_.apply(this);return this;};
S.prototype.setVisible=function(v){this.setProperty("visible",!!v);return this;};
S.prototype.setShowMarker=function(m){m=!!m;this.setProperty("showMarker",m,true);this.$().toggleClass("sapUiUfdShellHeadItmMark",m);return this;};
S.prototype.setIcon=function(i){this.setProperty("icon",i,true);if(this.getDomRef()){this._refreshIcon();}return this;};
S.prototype._refreshIcon=function(){var i=q(this.$().children()[0]);var s=this.getIcon();if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").attr("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.attr("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+e(s)+"'>");}}};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeadUserItem',['sap/ui/core/Element','sap/ui/core/IconPool','./library',"sap/base/security/encodeXML"],function(E,I,l,e){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadUserItem",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{username:{type:"string",group:"Appearance",defaultValue:''},showPopupIndicator:{type:"boolean",group:"Accessibility",defaultValue:true},image:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
I.insertFontFaceStyle();
S.prototype.onclick=function(o){this.firePress();o.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setImage=function(i){this.setProperty("image",i,true);if(this.getDomRef()){this._refreshImage();}return this;};
S.prototype._refreshImage=function(){var i=this.$("img");var s=this.getImage();if(!s){i.html("").attr("style","").css("display","none");}else if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").attr("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.attr("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+e(s)+"'>");}}};
S.prototype._checkAndAdaptWidth=function(s){if(!this.getDomRef()){return false;}var r=this.$(),n=this.$("name");var b=r.width();r.toggleClass("sapUiUfdShellHeadUsrItmLimit",false);var m=240;if(s){m=Math.min(m,0.5*document.documentElement.clientWidth-225);}if(m<n.width()){r.toggleClass("sapUiUfdShellHeadUsrItmLimit",true);}return b!=r.width();};
return S;});
sap.ui.predefine('sap/ui/unified/ShellHeader',['./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/theming/Parameters',"sap/ui/thirdparty/jquery"],function(l,C,D,P,q){"use strict";
var S=C.extend("sap.ui.unified.ShellHeader",{
metadata:{properties:{logo:{type:"sap.ui.core.URI",defaultValue:""},searchVisible:{type:"boolean",defaultValue:true}},aggregations:{headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}},
renderer:{render:function(r,h){var i=h.getId();r.write("<div");r.writeControlData(h);r.writeAttribute("class","sapUiUfdShellHeader");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write(">");r.write("<div id='",i,"-hdr-begin' class='sapUiUfdShellHeadBegin'>");this.renderHeaderItems(r,h,true);r.write("</div>");r.write("<div id='",i,"-hdr-center' class='sapUiUfdShellHeadCenter'>");this.renderSearch(r,h);r.write("</div>");r.write("<div id='",i,"-hdr-end' class='sapUiUfdShellHeadEnd'>");this.renderHeaderItems(r,h,false);r.write("</div>");r.write("</div>");},renderSearch:function(r,h){var s=h.getSearch();r.write("<div id='",h.getId(),"-hdr-search'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","search");}r.writeAttribute("class","sapUiUfdShellSearch"+(h.getSearchVisible()?"":" sapUiUfdShellHidden"));r.write("><div>");if(s){r.renderControl(s);}r.write("</div></div>");},renderHeaderItems:function(r,h,b){r.write("<div class='sapUiUfdShellHeadContainer'>");var I=b?h.getHeadItems():h.getHeadEndItems();for(var i=0;i<I.length;i++){r.write("<div tabindex='0'");r.writeElementData(I[i]);r.addClass("sapUiUfdShellHeadItm");if(I[i].getStartsSection()){r.addClass("sapUiUfdShellHeadItmDelim");}if(I[i].getShowSeparator()){r.addClass("sapUiUfdShellHeadItmSep");}if(!I[i].getVisible()){r.addClass("sapUiUfdShellHidden");}if(I[i].getSelected()&&I[i].getToggleEnabled()){r.addClass("sapUiUfdShellHeadItmSel");}if(I[i].getShowMarker()){r.addClass("sapUiUfdShellHeadItmMark");}r.writeClasses();var t=I[i].getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(I[i],{role:"button",selected:null,pressed:I[i].getToggleEnabled()?I[i].getSelected():null});}r.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>");}var u=h.getUser();if(!b&&u){r.write("<div tabindex='0'");r.writeElementData(u);r.addClass("sapUiUfdShellHeadUsrItm");if(!u.getShowPopupIndicator()){r.addClass("sapUiUfdShellHeadUsrItmWithoutPopup");}r.writeClasses();var t=u.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(u,{role:"button"});if(u.getShowPopupIndicator()){r.writeAttribute("aria-haspopup","true");}}r.write("><span id='",u.getId(),"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>");r.write("<span id='"+u.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");var U=u.getUsername()||"";r.writeAttributeEscaped("title",U);r.write(">");r.writeEscaped(U);r.write("</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>");}r.write("</div>");if(b){this._renderLogo(r,h);}},_renderLogo:function(r,h){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),L=a.getText("SHELL_LOGO_TOOLTIP"),i=h._getLogo();r.write("<div class='sapUiUfdShellIco'>");r.write("<img id='",h.getId(),"-icon'");r.writeAttributeEscaped("title",L);r.writeAttributeEscaped("alt",L);r.write("src='");r.writeEscaped(i);r.write("'");if(!i){r.addStyle("display","none");r.writeStyles();}r.write(">");r.write("</div>");}}
});
S.prototype.init=function(){var t=this;this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._handleMediaChange=function(p){if(!t.getDomRef()){return;}t._refresh();};D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);this._handleResizeChange=function(p){if(!t.getDomRef()||!t.getUser()){return;}var u=this.getUser();var c=u._checkAndAdaptWidth(!t.$("hdr-search").hasClass("sapUiUfdShellHidden")&&!!t.getSearch());if(c){t._refresh();}};D.resize.attachHandler(this._handleResizeChange,this);this.data("sap-ui-fastnavgroup","true",true);};
S.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);delete this._handleMediaChange;D.resize.detachHandler(this._handleResizeChange,this);delete this._handleResizeChange;};
S.prototype.onAfterRendering=function(){this._refresh();this.$("hdr-center").toggleClass("sapUiUfdShellAnim",!this._noHeadCenterAnim);};
S.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
S.prototype._getLogo=function(){var i=this.getLogo();if(!i){i=P._getThemeImage(null,true);}return i;};
S.prototype._refresh=function(){function u(I){for(var i=0;i<I.length;i++){I[i]._refreshIcon();}}u(this.getHeadItems());u(this.getHeadEndItems());var U=this.getUser(),a=q("html").hasClass("sapUiMedia-Std-Phone"),s=!this.$("hdr-search").hasClass("sapUiUfdShellHidden"),$=this.$("icon");if(U){U._refreshImage();U._checkAndAdaptWidth(s&&!!this.getSearch());}$.parent().toggleClass("sapUiUfdShellHidden",a&&s&&!!this.getSearch());var w=this.$("hdr-end").outerWidth(),b=this.$("hdr-begin").outerWidth(),c=Math.max(w,b),d=(a&&s?b:c)+"px",e=(a&&s?w:c)+"px";this.$("hdr-center").css({"left":this._rtl?e:d,"right":this._rtl?d:e});};
return S;});
sap.ui.predefine('sap/ui/unified/ShellLayout',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./SplitContainer','./library','./ShellLayoutRenderer','sap/ui/dom/containsOrEquals','sap/base/Log',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Focusable'],function(D,C,P,a,S,l,b,c,L,q){"use strict";
var d=C.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",forwarding:{idSuffix:"-container",aggregation:"content"}},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent",forwarding:{idSuffix:"-container",aggregation:"secondaryContent"}},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}}});
d._SIDEPANE_WIDTH_PHONE=208;d._SIDEPANE_WIDTH_TABLET=208;d._SIDEPANE_WIDTH_DESKTOP=240;d._HEADER_ALWAYS_VISIBLE=true;d._HEADER_AUTO_CLOSE=true;d._HEADER_TOUCH_TRESHOLD=15;if(D.browser.chrome&&D.browser.version<36){d._HEADER_TOUCH_TRESHOLD=10;}
d.prototype.init=function(){this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3000;this._useStrongBG=false;this._cont=new S(this.getId()+"-container");this._cont._bRootContent=true;if(sap.ui.getCore().getConfiguration().getAccessibility()){var t=this;this._cont.addEventDelegate({onAfterRendering:function(){t._cont.$("canvas").attr("role","main");t._cont.$("pane").attr("role","complementary");}});}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new S(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.attachHandler(this._handleResizeChange,this);};
d.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont;};
d.prototype.onAfterRendering=function(){var t=this;function h(B){var e=q.event.fix(B);if(c(t.getDomRef("hdr"),e.target)){t._timedHideHeader(e.type==="focus");}}if(window.addEventListener&&!d._HEADER_ALWAYS_VISIBLE){var H=this.getDomRef("hdr");H.addEventListener("focus",h,true);H.addEventListener("blur",h,true);}this._refreshAfterRendering();};
d.prototype.onThemeChanged=function(){this._refreshAfterRendering();};
d.prototype.onfocusin=function(e){var i=this.getId();if(e.target.id===i+"-curt-focusDummyOut"&&this.$("hdrcntnt").firstFocusableDomRef()){this.$("hdrcntnt").firstFocusableDomRef().focus();}else if(e.target.id===i+"-main-focusDummyOut"&&this.$("curtcntnt").firstFocusableDomRef()){this.$("curtcntnt").firstFocusableDomRef().focus();}};
(function(){
function _(s){if(s._startY===undefined||s._currY===undefined){return;}var y=s._currY-s._startY;if(Math.abs(y)>d._HEADER_TOUCH_TRESHOLD){s._doShowHeader(y>0);s._startY=s._currY;}}
if(D.support.touch){d._HEADER_ALWAYS_VISIBLE=false;d.prototype.ontouchstart=function(e){this._startY=e.touches[0].pageY;if(this._startY>2*48){this._startY=undefined;}this._currY=this._startY;};d.prototype.ontouchend=function(e){_(this);this._startY=undefined;this._currY=undefined;};d.prototype.ontouchcancel=d.prototype.ontouchend;d.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY;_(this);};}})();
d.prototype.setHeaderHiding=function(e){e=!!e;return this._mod(function(r){return this.setProperty("headerHiding",e,r);},function(){this._doShowHeader(!e?true:this._showHeader);});};
d.prototype.setHeaderHidingDelay=function(i){this._iHeaderHidingDelay=i;return this;};
d.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay;};
d.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent();};
d.prototype.setShowPane=function(s){this._cont.setShowSecondaryContent(s);this.setProperty("showPane",!!s,true);return this;};
d.prototype.setShowCurtainPane=function(s){this._curtCont.setShowSecondaryContent(s);return this;};
d.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent();};
d.prototype.setHeaderVisible=function(h){h=!!h;this.setProperty("headerVisible",h,true);this.$().toggleClass("sapUiUfdShellNoHead",!h);return this;};
d.prototype.setShowCurtain=function(s){s=!!s;return this._mod(function(r){this._showCurtain=s;return this;},function(){this.$("main-focusDummyOut").attr("tabindex",s?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!s).toggleClass("sapUiUfdShellCurtainVisible",s);if(s){var z=P.getNextZIndex();this.$("curt").css("z-index",z+1);this.$("hdr").css("z-index",z+3);this.$("brand").css("z-index",z+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false);}this._timedCurtainClosed(s);this._doShowHeader(true);});};
d.prototype.getShowCurtain=function(){return this._showCurtain;};
d.prototype.setHeader=function(h){this.setAggregation("header",h,true);h=this.getHeader();if(this.getDomRef()){if(!h){this.$("hdrcntnt").html("");}else{var r=sap.ui.getCore().createRenderManager();r.renderControl(h);r.flush(this.getDomRef("hdrcntnt"));r.destroy();}}return this;};
d.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this;};
d.prototype.getCurtainContent=function(){return this._curtCont.getContent();};
d.prototype.insertCurtainContent=function(o,i){this._curtCont.insertContent(o,i);return this;};
d.prototype.addCurtainContent=function(o){this._curtCont.addContent(o);return this;};
d.prototype.removeCurtainContent=function(i){return this._curtCont.removeContent(i);};
d.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent();};
d.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this;};
d.prototype.indexOfCurtainContent=function(o){return this._curtCont.indexOfCurtainContent(o);};
d.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent();};
d.prototype.insertCurtainPaneContent=function(o,i){this._curtCont.insertSecondaryContent(o,i);return this;};
d.prototype.addCurtainPaneContent=function(o){this._curtCont.addSecondaryContent(o);return this;};
d.prototype.removeCurtainPaneContent=function(i){return this._curtCont.removeSecondaryContent(i);};
d.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent();};
d.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this;};
d.prototype.indexOfCurtainPaneContent=function(o){return this._curtCont.indexOfSecondaryContent(o);};
d.prototype._setStrongBackground=function(u){this._useStrongBG=!!u;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG);};
d.prototype._mod=function(m,o){var r=!!this.getDomRef();var e=m.apply(this,[r]);if(r&&o){if(o instanceof l._ContentRenderer){o.render();}else{o.apply(this);}}return e;};
d.prototype._doShowHeader=function(s){var w=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!s:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader();}if(w!=this._showHeader&&this._isHeaderHidingActive()){setTimeout(function(){try{var r=document.createEvent("UIEvents");r.initUIEvent("resize",true,false,window,0);window.dispatchEvent(r);}catch(e){L.error(e);}},500);}};
d.prototype._timedHideHeader=function(e){if(this._headerHidingTimer){clearTimeout(this._headerHidingTimer);this._headerHidingTimer=null;}if(e||!d._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return;}this._headerHidingTimer=setTimeout(function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!c(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false);}}.bind(this),this._iHeaderHidingDelay);};
d.prototype._timedCurtainClosed=function(e){if(this._curtainClosedTimer){clearTimeout(this._curtainClosedTimer);this._curtainClosedTimer=null;}if(e){return;}var f=parseInt(a.get("_sap_ui_unified_ShellLayout_AnimDuration"));if(!this._animation){f=0;}this._curtainClosedTimer=setTimeout(function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true);}.bind(this),f);};
d.prototype._isHeaderHidingActive=function(){if(d._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||l._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false;}return true;};
d.prototype._setSidePaneWidth=function(r){if(!r){r=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD).name;}var w=d["_SIDEPANE_WIDTH_"+r.toUpperCase()]+"px";this._cont.setSecondaryContentSize(w);this._curtCont.setSecondaryContentSize(w);};
d.prototype._handleMediaChange=function(p){if(!this.getDomRef()){return false;}this._setSidePaneWidth(p.name);};
d.prototype._handleResizeChange=function(p){};
d.prototype._refreshAfterRendering=function(){var o=this.getDomRef();if(!o){return false;}this._timedHideHeader();return true;};
d.prototype._getSearchWidth=function(){return-1;};
return d;});
sap.ui.predefine('sap/ui/unified/ShellLayoutRenderer',[],function(){"use strict";var S={};
S.render=function(r,s){var i=s.getId();r.write("<div");r.writeControlData(s);r.addClass("sapUiUfdShell");if(s._animation){r.addClass("sapUiUfdShellAnim");}if(!s.getHeaderVisible()){r.addClass("sapUiUfdShellNoHead");}r.addClass("sapUiUfdShellHead"+(s._showHeader?"Visible":"Hidden"));if(s.getShowCurtain()){r.addClass("sapUiUfdShellCurtainVisible");}else{r.addClass("sapUiUfdShellCurtainHidden");r.addClass("sapUiUfdShellCurtainClosed");}r.writeClasses();r.write(">");r.write("<hr id='",i,"-brand' class='sapUiUfdShellBrand'>");r.write("<header id='",i,"-hdr'  class='sapUiUfdShellHead'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","banner");}r.write("><div><div id='",i,"-hdrcntnt' class='sapUiUfdShellCntnt'>");if(s.getHeader()){r.renderControl(s.getHeader());}r.write("</div>","</div>","</header>");r.write("<section id='",i,"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");r.write("<div id='",i,"-curtcntnt' class='sapUiUfdShellCntnt'>");r.renderControl(s._curtCont);r.write("</div>");r.write("<span id='",i,"-curt-focusDummyOut' tabindex='0'></span>");r.write("</section>");r.write("<div id='",i,"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>");r.write("<div id='",i,"-strgbg' class='sapUiUfdShellBG"+(s._useStrongBG?" sapUiStrongBackgroundColor":"")+"'></div>");r.write("<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>");r.renderControl(s._cont);r.write("</div>");r.write("<span id='",i,"-main-focusDummyOut' tabindex='"+(s.getShowCurtain()?0:-1)+"'></span>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellOverlay',['sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./library','sap/ui/core/theming/Parameters','./ShellOverlayRenderer',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/rect','sap/ui/dom/jquery/Selectors'],function(D,C,P,l,a,S,q){"use strict";
var b=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",deprecated:true,defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});
b.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){setTimeout(function(){q(document.getElementById("sap-ui-blocklayer-popup")).toggleClass("sapUiUfdShellOvrlyBlyTp",false);},50);}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);}.bind(this),this._getAnimDuration(true));};
b.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();setTimeout(function(){var B=q(document.getElementById("sap-ui-blocklayer-popup"));if(P.blStack.length==1&&this._getAnimActive()&&B.hasClass("sapUiUfdShellOvrlyBly")){B.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}}.bind(this),Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0));setTimeout(function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();}.bind(this),this._getAnimDuration(false));};
b.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};
b.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(this.getDomRef()){this._headRenderer.render();}return this;};
b.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(this.getDomRef()){this._contentRenderer.render();}return r;};
b.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new l._ContentRenderer(this,this.getId()+"-hdr-center",function(r){S.renderSearch(r,t);});this._contentRenderer=new l._ContentRenderer(this,this.getId()+"-cntnt",function(r){S.renderContent(r,t);});};
b.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};
b.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}setTimeout(function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");}.bind(this),10);};
b.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};
b.prototype.onsapspace=b.prototype.onclick;
b.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};
b.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){d.focus();}};
b.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(a.get(p));if(!this._getAnimActive()&&c){v=0;}return v;};
b.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};
b.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};
b.prototype._getAnimActive=function(){if(!this._animation){return false;}return true;};
b.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){l._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){l._iNumberOfOpenedShellOverlays--;});}return this._popup;};
b.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};
b.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};
b.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};
b.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};
return b;});
sap.ui.predefine('sap/ui/unified/ShellOverlayRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdShellOvrly");if(c._opening){r.addClass("sapUiUfdShellOvrlyCntntHidden");r.addClass("sapUiUfdShellOvrlyOpening");}if(c._getAnimActive()){r.addClass("sapUiUfdShellOvrlyAnim");}r.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(c,{role:"dialog"});}r.write("><span id='",c.getId(),"-focfirst' tabindex='0'></span><div id='",c.getId(),"-inner'>");r.write("<header class='sapUiUfdShellOvrlyHead'>");r.write("<hr class='sapUiUfdShellOvrlyBrand'>");r.write("<div class='sapUiUfdShellOvrlyHeadCntnt'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write("><div id='"+c.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");S.renderSearch(r,c);r.write("</div>");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),C=a.getText("SHELL_OVERLAY_CLOSE");r.write("<a tabindex='0' href='#' id='"+c.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");r.writeAttributeEscaped("title",C);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","button");}r.write(">");r.writeEscaped(C);r.write("</a></div></header>");r.write("<div id='"+c.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");S.renderContent(r,c);r.write("</div>");r.write("</div><span id='",c.getId(),"-foclast' tabindex='0'></span></div>");};
S.renderSearch=function(r,c){var w=c._getSearchWidth();r.write("<div id='"+c.getId()+"-search' class='sapUiUfdShellOvrlySearch' ");if(w>0&&c._opening){r.addStyle("width",w+"px'");r.writeStyles();}r.write("><div>");var s=c.getSearch();if(s){r.renderControl(s);}r.write("</div></div>");};
S.renderContent=function(r,c){r.write("<div>");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellRenderer',['sap/ui/core/Renderer','./ShellLayoutRenderer'],function(R,S){"use strict";var a=R.extend(S);return a;},true);
sap.ui.predefine('sap/ui/unified/SplitContainer',['sap/ui/core/Control','sap/ui/core/theming/Parameters','./library','sap/ui/core/library','./SplitContainerRenderer',"sap/base/Log"],function(C,P,l,c,S,L){"use strict";var O=c.Orientation;
var a=C.extend("sap.ui.unified.SplitContainer",{metadata:{library:"sap.ui.unified",deprecated:true,properties:{showSecondaryContent:{type:"boolean",group:"Appearance",defaultValue:null},secondaryContentSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px'},secondaryContentWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px',deprecated:true},orientation:{type:"sap.ui.core.Orientation",group:"Appearance",defaultValue:O.Horizontal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},secondaryContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondaryContent"}}}});
(function(w){
a.prototype.init=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._paneRenderer=new l._ContentRenderer(this,this.getId()+"-panecntnt","secondaryContent");this._canvasRenderer=new l._ContentRenderer(this,this.getId()+"-canvascntnt","content");this._moveContent=true;};
a.prototype.exit=function(){this._paneRenderer.destroy();delete this._paneRenderer;this._canvasRenderer.destroy();delete this._canvasRenderer;if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId;}delete this._contentContainer;delete this._secondaryContentContainer;};
a.prototype.onAfterRendering=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._contentContainer=this.$("canvas");this._secondaryContentContainer=this.$("pane");this._applySecondaryContentSize();};
a.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var v=this.getOrientation()==O.Vertical;var s,o;var d,b;var e=this.getSecondaryContentSize();var f=this.getShowSecondaryContent();if(v){s="height";o="width";d="top";b=this.bRtl?"right":"left";}else{s="width";o="height";d=this.bRtl?"right":"left";b="top";}if(this._closeContentDelayId){clearTimeout(this._closeContentDelayId);delete this._closeContentDelayId;}this._secondaryContentContainer.css(s,e);this._secondaryContentContainer.css(o,"");this._secondaryContentContainer.css(d,f?"0":"-"+e);this._secondaryContentContainer.css(b,"");if(this._moveContent){this._contentContainer.css(d,f?e:"0");}else{this._contentContainer.css(d,"0");}if(!f){var h=parseInt(P.get("_sap_ui_unified_SplitContainer_AnimationDuration"));this._closeContentDelayId=setTimeout(function(){this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",true);}.bind(this),h);}else{this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",false);}}};
a.prototype._mod=function(m,d){var r=!!this.getDomRef();var b=m.apply(this,[r]);if(r&&d){d.render();}return b;};
a.prototype.setShowSecondaryContent=function(s){var r=this.getDomRef();this.setProperty("showSecondaryContent",!!s,r);this._applySecondaryContentSize();return this;};
a.prototype.setSecondaryContentSize=function(s){this.setProperty("secondaryContentSize",s,true);this._applySecondaryContentSize();return this;};
a.prototype.getSecondaryContentWidth=function(){L.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.getSecondaryContentSize.apply(this,arguments);};
a.prototype.setSecondaryContentWidth=function(){L.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.setSecondaryContentSize.apply(this,arguments);};
a.prototype.insertContent=function(o,i){return this._mod(function(r){return this.insertAggregation("content",o,i,r);},this._canvasRenderer);};
a.prototype.addContent=function(o){return this._mod(function(r){return this.addAggregation("content",o,r);},this._canvasRenderer);};
a.prototype.removeContent=function(i){return this._mod(function(r){return this.removeAggregation("content",i,r);},this._canvasRenderer);};
a.prototype.removeAllContent=function(){return this._mod(function(r){return this.removeAllAggregation("content",r);},this._canvasRenderer);};
a.prototype.destroyContent=function(){return this._mod(function(r){return this.destroyAggregation("content",r);},this._canvasRenderer);};
a.prototype.insertSecondaryContent=function(o,i){return this._mod(function(r){return this.insertAggregation("secondaryContent",o,i,r);},this._paneRenderer);};
a.prototype.addSecondaryContent=function(o){return this._mod(function(r){return this.addAggregation("secondaryContent",o,r);},this._paneRenderer);};
a.prototype.removeSecondaryContent=function(i){return this._mod(function(r){return this.removeAggregation("secondaryContent",i,r);},this._paneRenderer);};
a.prototype.removeAllSecondaryContent=function(){return this._mod(function(r){return this.removeAllAggregation("secondaryContent",r);},this._paneRenderer);};
a.prototype.destroySecondaryContent=function(){return this._mod(function(r){return this.destroyAggregation("secondaryContent",r);},this._paneRenderer);};
})(window);return a;});
sap.ui.predefine('sap/ui/unified/SplitContainerRenderer',["sap/ui/core/library"],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var i=C.getId();var v=C.getOrientation()==O.Vertical;r.write("<div");r.writeControlData(C);r.addClass("sapUiUfdSpltCont");r.addClass("sapUiUfdSpltCont"+(v?"V":"H"));if(sap.ui.getCore().getConfiguration().getAnimation()){r.addClass("sapUiUfdSpltContAnim");}if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSpltContPaneHidden");}r.writeClasses();r.write(">");var s=i+"-canvas";r.write("<section id='",s,"' class='sapUiUfdSpltContCanvas'>");this.renderContent(r,s,C.getContent(),C._bRootContent);r.write("</section>");var a=i+"-pane";var w=C.getShowSecondaryContent()?C.getSecondaryContentSize():"0";r.write("<aside id='",a);r.write("'");r.addStyle("width",w);r.writeStyles();r.addClass("sapUiUfdSpltContPane");if(!C.getShowSecondaryContent()){r.addClass("sapUiUfdSplitContSecondClosed");}r.writeClasses();r.write(">");this.renderContent(r,a,C.getSecondaryContent(),C._bRootContent);r.write("</aside>");r.write("</div>");};
S.renderContent=function(r,I,C,R){r.write("<div id='",I,"cntnt' class='sapUiUfdSpltContCntnt'");if(R){r.writeAttribute("data-sap-ui-root-content","true");}r.write(">");for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/calendar/CalendarDate',['sap/ui/base/Object','sap/ui/core/date/UniversalDate',"sap/ui/thirdparty/jquery"],function(B,U,q){"use strict";
var C=B.extend("sap.ui.unified.calendar.CalendarDate",{constructor:function(){var A=arguments,j,n,s;switch(A.length){case 0:n=new Date();return C.call(this,n.getFullYear(),n.getMonth(),n.getDate());case 1:case 2:if(!(A[0]instanceof C)){throw"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate.";}s=A[1]?A[1]:A[0]._oUDate.sCalendarType;j=new Date(A[0].valueOf());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());j.setHours(j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());this._oUDate=c(j,s);break;case 3:case 4:d(A[0],"Invalid year: "+A[0]);d(A[1],"Invalid month: "+A[1]);d(A[2],"Invalid date: "+A[2]);j=new Date(0,0,1);j.setFullYear(A[0],A[1],A[2]);if(A[3]){s=A[3];}this._oUDate=c(j,s);break;default:throw"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarType"+"or 2) year, month, date, (optional) calendarType"+A;}}});
C.prototype.getYear=function(){return this._oUDate.getUTCFullYear();};
C.prototype.setYear=function(y){d(y,"Invalid year: "+y);this._oUDate.setUTCFullYear(y);return this;};
C.prototype.getMonth=function(){return this._oUDate.getUTCMonth();};
C.prototype.setMonth=function(m,e){d(m,"Invalid month: "+m);if(e||e===0){d(e,"Invalid date: "+e);this._oUDate.setUTCMonth(m,e);}else{this._oUDate.setUTCMonth(m);}return this;};
C.prototype.getDate=function(){return this._oUDate.getUTCDate();};
C.prototype.setDate=function(e){d(e,"Invalid date: "+e);this._oUDate.setUTCDate(e);return this;};
C.prototype.getDay=function(){return this._oUDate.getUTCDay();};
C.prototype.getCalendarType=function(){return this._oUDate.sCalendarType;};
C.prototype.getEra=function(){return this._oUDate.getUTCEra();};
C.prototype.isBefore=function(o){b(o);return this.valueOf()<o.valueOf();};
C.prototype.isAfter=function(o){b(o);return this.valueOf()>o.valueOf();};
C.prototype.isSameOrBefore=function(o){b(o);return this.valueOf()<=o.valueOf();};
C.prototype.isSameOrAfter=function(o){b(o);return this.valueOf()>=o.valueOf();};
C.prototype.isSame=function(o){b(o);return this.valueOf()===o.valueOf();};
C.prototype.toLocalJSDate=function(){var l=new Date(this._oUDate.getTime());l.setFullYear(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());l.setHours(0,0,0,0);return l;};
C.prototype.toUTCJSDate=function(){var u=new Date(this._oUDate.getTime());u.setUTCHours(0,0,0,0);return u;};
C.prototype.toString=function(){return this._oUDate.sCalendarType+": "+this.getYear()+"/"+(this.getMonth()+1)+"/"+this.getDate();};
C.prototype.valueOf=function(){return this._oUDate.getTime();};
C.fromLocalJSDate=function(j,s){if(!j||Object.prototype.toString.call(j)!=="[object Date]"||isNaN(j)){throw new Error("Date parameter must be a JavaScript Date object: ["+j+"].");}return new C(j.getFullYear(),j.getMonth(),j.getDate(),s);};
function c(D,s){if(s){return U.getInstance(a(D),s);}else{return new U(a(D).getTime());}}
function a(D){var u=new Date(Date.UTC(0,0,1));u.setUTCFullYear(D.getFullYear(),D.getMonth(),D.getDate());return u;}
function b(o){if(!(o instanceof C)){throw"Invalid calendar date: ["+o+"]. Expected: sap.ui.unified.calendar.CalendarDate";}}
function d(v,m){if(v==undefined||v===Infinity||isNaN(v)){throw m;}}
return C;});
sap.ui.predefine('sap/ui/unified/calendar/CalendarUtils',['sap/ui/core/date/UniversalDate','./CalendarDate','sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/ui/thirdparty/jquery"],function(U,C,L,a,q){"use strict";var b={};b.MAX_MILLISECONDS=8640000000000000;b.HOURS24=1000*3600*24;
b._createLocalDate=function(d,t){var l;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}l=new Date(m.getUTCFullYear(),m.getUTCMonth(),m.getUTCDate());if(m.getFullYear()<1000){l.setFullYear(m.getFullYear());}if(t){l.setHours(m.getUTCHours());l.setMinutes(m.getUTCMinutes());l.setSeconds(m.getUTCSeconds());l.setMilliseconds(m.getUTCMilliseconds());}}return l;};
b._createUTCDate=function(d,t){var u;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}u=new Date(Date.UTC(m.getFullYear(),m.getMonth(),m.getDate()));if(m.getFullYear()<1000){u.setUTCFullYear(m.getFullYear());}if(t){u.setUTCHours(m.getHours());u.setUTCMinutes(m.getMinutes());u.setUTCSeconds(m.getSeconds());u.setUTCMilliseconds(m.getMilliseconds());}}return u;};
b._createUniversalUTCDate=function(d,c,t){var u;if(c){u=U.getInstance(this._createUTCDate(d,t),c);}else{u=new U(this._createUTCDate(d,t).getTime());}return u;};
b.calculateWeekNumber=function(d,y,l,o){var w=0;var W=0;var f=o.getFirstDayOfWeek();var c=new L(l);if(c&&c.getLanguage()==="en"&&(c.getRegion()==="US"||!c.getRegion())){var j=new U(d.getTime());j.setUTCFullYear(y,0,1);W=j.getUTCDay();var e=new U(d.getTime());e.setUTCDate(e.getUTCDate()-e.getUTCDay()+W);w=Math.round((e.getTime()-j.getTime())/86400000/7)+1;}else{var t=new U(d.getTime());t.setUTCDate(t.getUTCDate()-f);W=t.getUTCDay();t.setUTCDate(t.getUTCDate()-W+4);var F=new U(t.getTime());F.setUTCMonth(0,1);W=F.getUTCDay();var A=0;if(W>4){A=7;}var g=new U(F.getTime());g.setUTCDate(1-W+4+A);w=Math.round((t.getTime()-g.getTime())/86400000/7)+1;}return w;};
b.getFirstDateOfWeek=function(d){var u=new U(d.getTime()),f,F,l=a.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),c=l.getFirstDayOfWeek(),w;w=U.getWeekByDate(u.getCalendarType(),u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate());f=U.getFirstDateOfWeek(u.getCalendarType(),w.year,w.week);F=new U(U.UTC(f.year,f.month,f.day));while(F.getUTCDay()!==c){F.setUTCDate(F.getUTCDate()-1);}return new U(U.UTC(F.getUTCFullYear(),F.getUTCMonth(),F.getUTCDate(),d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds())).getJSDate();};
b.getFirstDateOfMonth=function(d){var n=new U(d.getTime());n.setUTCDate(1);return n;};
b._getNumberOfWeeksForYear=function(y){var l=sap.ui.getCore().getConfiguration().getFormatLocale(),o=a.getInstance(new L(l)),c=new Date(Date.UTC(y,0,1)),i=c.getUTCDay(),n=52;if(o.getFirstDayOfWeek()===0){if(i===5||i===6){n=53;}}else{if(i===3||i===4){n=53;}}return n;};
b.monthsDiffer=function(d,D){return(d.getMonth()!==D.getMonth()||d.getFullYear()!==D.getFullYear());};
b.isDateLastInMonth=function(d){var n=new Date(d.getTime()+24*60*60*1000);return n.getUTCDate()<d.getUTCDate();};
b._updateUTCDate=function(d,y,m,D,h,M,s,i){if(y!=null){d.setUTCFullYear(y);}if(m!=null){d.setUTCMonth(m);}if(D!=null){d.setUTCDate(D);}if(h!=null){d.setUTCHours(h);}if(M!=null){d.setUTCMinutes(M);}if(s!=null){d.setUTCSeconds(s);}if(i!=null){d.setUTCMilliseconds(i);}};
b._checkJSDateObject=function(d){if(!d||Object.prototype.toString.call(d)!=="[object Date]"||isNaN(d)){throw new Error("Date must be a JavaScript date object.");}};
b._checkYearInValidRange=function(y){if(typeof y!=="number"||y<1||y>9999){throw new Error("Year must be in valid range (between year 0001 and year 9999).");}};
b._isNextMonth=function(d,D){return(d.getMonth()>D.getMonth()&&d.getFullYear()===D.getFullYear())||d.getFullYear()>D.getFullYear();};
b._minutesBetween=function(f,s){var m=(s.getTime()-f.getTime())/1000;m=m/60;return Math.abs(Math.round(m));};
b._areCurrentMinutesLessThan=function(m){var c=new Date().getMinutes();return m>=c;};
b._areCurrentMinutesMoreThan=function(m){var c=new Date().getMinutes();return m<=c;};
b._monthsBetween=function(f,s,d){var u=new Date(Date.UTC(f.getUTCFullYear(),f.getUTCMonth(),f.getUTCDate())),o=new Date(Date.UTC(s.getUTCFullYear(),s.getUTCMonth(),s.getUTCDate())),m;u.setUTCFullYear(f.getUTCFullYear());o.setUTCFullYear(s.getUTCFullYear());m=(o.getUTCFullYear()*12+o.getUTCMonth())-(u.getUTCFullYear()*12+u.getUTCMonth());if(!d){m=Math.abs(m);}return m;};
b._hoursBetween=function(f,s){var n=new Date(Date.UTC(f.getUTCFullYear(),f.getUTCMonth(),f.getUTCDate(),f.getUTCHours()));var N=new Date(Date.UTC(s.getUTCFullYear(),s.getUTCMonth(),s.getUTCDate(),s.getUTCHours()));n.setUTCFullYear(f.getUTCFullYear());N.setUTCFullYear(s.getUTCFullYear());return Math.abs((n.getTime()-N.getTime())/(1000*60*60));};
b._isMidnight=function(d){return d.getHours()===0&&d.getMinutes()===0&&d.getSeconds()===0&&d.getMilliseconds()===0;};
b._daysInMonth=function(c){this._checkCalendarDate(c);c=new C(c);c.setDate(1);c.setMonth(c.getMonth()+1);c.setDate(0);return c.getDate();};
b._isLastDateInMonth=function(c){return c.getDate()===b._daysInMonth(c);};
b._getFirstDateOfWeek=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfWeek(c.toUTCJSDate());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._getFirstDateOfMonth=function(c){this._checkCalendarDate(c);var j=b.getFirstDateOfMonth(c.toUTCJSDate()).getJSDate();j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
b._minDate=function(c){var o=new C(1,0,1,c);o.setYear(1);o.setMonth(0);o.setDate(1);return o;};
b._maxDate=function(c){var o=new C(9999,11,1,c);o.setYear(9999);o.setMonth(11);o.setDate(this._daysInMonth(o));return new C(o);};
b._isBetween=function(d,s,e,i){this._checkCalendarDate(d);this._checkCalendarDate(s);this._checkCalendarDate(e);if(i){return d.isSameOrAfter(s)&&d.isSameOrBefore(e);}else{return d.isAfter(s)&&d.isBefore(e);}};
b._daysBetween=function(f,s){this._checkCalendarDate(f);this._checkCalendarDate(s);return Math.ceil((f.valueOf()-s.valueOf())/(this.HOURS24));};
b._isOutside=function(c,s,e){return!this._isBetween(c,s,e,true);};
b._isSameMonthAndYear=function(c,o){this._checkCalendarDate(c);this._checkCalendarDate(o);return c.getEra()===o.getEra()&&c.getYear()===o.getYear()&&c.getMonth()===o.getMonth();};
b._checkCalendarDate=function(c){if(!c||!(c instanceof C)){throw"Invalid calendar date: ["+c+"]. Expected: sap.ui.unified.calendar.CalendarDate";}};
b._getWeek=function(c){this._checkCalendarDate(c);return U.getWeekByDate(c.getCalendarType(),c.getYear(),c.getMonth(),c.getDate());};
b._isWeekend=function(c,l){var d=c.getDay();return d===l.getWeekendStart()||d===l.getWeekendEnd();};
return b;},true);
sap.ui.predefine('sap/ui/unified/calendar/CustomMonthPicker',["sap/ui/core/Renderer","sap/ui/unified/Calendar",'sap/ui/unified/CalendarRenderer',"sap/ui/unified/calendar/Header","sap/ui/unified/DateRange"],function(R,C,a,H,D){"use strict";var b=R.extend(a);b.apiVersion=2;
var c=C.extend("sap.ui.unified.internal.CustomMonthPicker",{
metadata:{library:"sap.ui.unified"},
renderer:b
});
c.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);h.attachEvent("pressButton2",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(h);h.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",h);};
c.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setProperty("_currentPicker","monthPicker");this._bNamesLengthChecked=true;};
c.prototype.onBeforeRendering=function(){var s=this.getSelectedDates(),y=this._getYearPicker().getDate(),m,S;C.prototype.onBeforeRendering.apply(this,arguments);if(this._iMode===1){if(s.length&&s[0].getStartDate()&&(!y||(s[0].getStartDate().getFullYear()===y.getFullYear()))){m=this._getMonthPicker();S=s[0].getStartDate();m.setMonth(S.getMonth());m._iYear=S.getFullYear();}}};
c.prototype._closePickers=function(){this.setProperty("_currentPicker","monthPicker");this._togglePrevNext(this._getFocusedDate(),true);};
c.prototype._selectYear=function(){var m=this._getMonthPicker(),y=this._getYearPicker(),f=this._getFocusedDate();f.setYear(y.getYear());m._setYear(f.getYear());this._focusDate(f,true);this._showMonthPicker();};
c.prototype._selectMonth=function(){var m=this._getMonthPicker(),s=this.getSelectedDates()[0],f=this._getFocusedDate();if(!s){s=new D();}if(!m.getIntervalSelection()){f.setMonth(m.getMonth(),1);s.setStartDate(f.toLocalJSDate());this.addSelectedDate(s);}this.fireSelect();};
c.prototype.onsapescape=function(e){this.fireCancel();};
c.prototype._hideMonthPicker=function(){this._hideOverlay();this._togglePrevNext(this._getFocusedDate(),true);this._bActionTriggeredFromSecondHeader=false;};
c.prototype.setShowCurrentDateButton=function(s){return this;};
return c;});
sap.ui.predefine('sap/ui/unified/calendar/CustomYearPicker',["sap/ui/core/Renderer","sap/ui/unified/Calendar","sap/ui/unified/CalendarRenderer","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/Header","sap/ui/unified/DateRange"],function(R,C,a,b,H,D){"use strict";var c=R.extend(a);c.apiVersion=2;
var d=C.extend("sap.ui.unified.internal.CustomYearPicker",{
metadata:{library:"sap.ui.unified"},
renderer:c
});
d.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setProperty("_currentPicker","yearPicker");this._bNamesLengthChecked=true;};
d.prototype.onBeforeRendering=function(){var s=this.getSelectedDates(),f=s.length?s[0].getStartDate():undefined,y=this._getYearPicker(),o,F;if(f){o=b.fromLocalJSDate(f);o.setMonth(0,1);F=new b(this._getFocusedDate());F.setMonth(0,1);if(F.isSame(o)){y.setDate(f);}}else{y.setProperty("_middleDate",this._getFocusedDate());y.setDate(this._getFocusedDate().toLocalJSDate());}C.prototype.onBeforeRendering.call(this,arguments);};
d.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this._fnYPDelegate){this.getAggregation("yearPicker").removeDelegate(this._fnYPDelegate);}};
d.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);h.attachEvent("pressButton2",this._handleButton2,this);this._afterHeaderRenderAdjustCSS=this._createOnAfterRenderingDelegate(h);h.addDelegate(this._afterHeaderRenderAdjustCSS);this.setAggregation("header",h);};
d.prototype._closePickers=function(){this.setProperty("_currentPicker","yearPicker");this._togglePrevNexYearPicker();};
d.prototype._selectYear=function(){var o=this.getSelectedDates()[0],y=this._getYearPicker();if(!o){o=new D();}if(!y.getIntervalSelection()){o.setStartDate(this._getYearPicker().getDate());this.addSelectedDate(o);}this.fireSelect();};
d.prototype.onsapescape=function(e){this.fireCancel();};
d.prototype.setShowCurrentDateButton=function(s){return this;};
return d;});
sap.ui.predefine('sap/ui/unified/calendar/DatesRow',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/Month','sap/ui/unified/library',"./DatesRowRenderer","sap/ui/thirdparty/jquery"],function(C,a,M,l,D,q){"use strict";
var b=M.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true}}}});
b.prototype.init=function(){M.prototype.init.apply(this,arguments);this._iColumns=1;this._aWeekNumbers=[];this._bAlwaysShowSpecialDates=true;};
b.prototype._setAriaRole=function(r){this._ariaRole=r;return this;};
b.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};
b.prototype.setStartDate=function(s){C._checkJSDateObject(s);var y=s.getFullYear();C._checkYearInValidRange(y);this.setProperty("startDate",s);this._oStartDate=a.fromLocalJSDate(s,this.getPrimaryCalendarType());if(this.getDomRef()){var o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(s);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.displayDate(o);}}return this;};
b.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=a.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oStartDate;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.setDate.apply(this,arguments);return this;};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.displayDate.apply(this,arguments);return this;};
b.prototype._setTopPosition=function(t){this._iTopPosition=t;};
b.prototype.setPrimaryCalendarType=function(c){M.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new a(this._oStartDate,c);}return this;};
b.prototype._handleBorderReached=function(c){var e=c.getParameter("event");var d=this._getRelativeInfo?this.getDays()*this._getRelativeInfo().iIntervalSize:this.getDays();var s=this._getRelativeInfo?this._getRelativeInfo().iIntervalSize:1;var o=this._getDate();var f=new a(o,this.getPrimaryCalendarType());if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":f.setDate(f.getDate()+s);break;case"sapprevious":case"sappreviousmodifiers":f.setDate(f.getDate()-s);break;case"sappagedown":f.setDate(f.getDate()+d);break;case"sappageup":f.setDate(f.getDate()-d);break;default:break;}this.fireFocus({date:f.toLocalJSDate(),otherMonth:true,_outsideBorder:true});}};
b.prototype.checkDateFocusable=function(d){C._checkJSDateObject(d);if(this._bNoRangeCheck){return false;}var s=this._getStartDate();var e=new a(s,this.getPrimaryCalendarType());var A=this.getDays();if(this._getRelativeInfo&&this._getRelativeInfo().bIsRelative){A=this.getDays()*this._getRelativeInfo().iIntervalSize;}e.setDate(e.getDate()+A);var c=a.fromLocalJSDate(d,this.getPrimaryCalendarType());return c.isSameOrAfter(s)&&c.isBefore(e);};
b.prototype._renderHeader=function(){var s=this._getStartDate();var S=s.getDay();var L=this._getLocaleData();var w=this.$("Names").children();var W=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){W=L.getDaysStandAlone("abbreviated");}else{W=L.getDaysStandAlone("narrow");}var c=L.getDaysStandAlone("wide");var i=0;for(i=0;i<w.length;i++){var $=q(w[i]);$.text(W[(i+S)%7]);$.attr("aria-label",c[(i+S)%7]);}if(this._getShowHeader()){var d=this.$("Head");if(d.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(r,this,L,s);r.flush(d[0]);r.destroy();}}};
b.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay();};
b.prototype.getWeekNumbers=function(){var d=this.getDays(),L=this._getLocale(),o=this._getLocaleData(),c=this.getPrimaryCalendarType(),s=this._getStartDate(),e=new a(s,c),E=new a(s,c).setDate(e.getDate()+d),f=[];while(e.isBefore(E)){f.push(new a(e,c));e.setDate(e.getDate()+1);}this._aWeekNumbers=f.reduce(function(w,g){var W=C.calculateWeekNumber(g.toUTCJSDate(),g.getYear(),L,o);if(!w.length||w[w.length-1].number!==W){w.push({len:0,number:W});}w[w.length-1].len++;return w;},[]);return this._aWeekNumbers;};
b.prototype._getCachedWeekNumbers=function(){return this._aWeekNumbers;};
return b;});
sap.ui.predefine('sap/ui/unified/calendar/DatesRowRenderer',['sap/ui/core/Renderer','sap/ui/unified/calendar/CalendarDate','./MonthRenderer',"sap/ui/core/CalendarType"],function(R,C,M,a){"use strict";var D=R.extend(M);D.apiVersion=2;
D.getStartDate=function(d){return d._getStartDate();};
D.getClass=function(r,d){var c=["sapUiCalDatesRow","sapUiCalRow"];if(!d.getShowDayNamesLine()){c.push("sapUiCalNoNameLine");}return c;};
D.addWrapperAdditionalStyles=function(r,d){if(d._iTopPosition){r.style("top",d._iTopPosition+"px");}};
D.renderMonth=function(r,d,o){if(d.isRelative&&d.isRelative()){D.renderCustomIntervals(r,d);}else{M.renderMonth.apply(this,arguments);this.renderWeekNumbers(r,d);}};
D.renderCustomIntervals=function(r,d){var i;r.openStart("div",d.getId()+"-customintervals");r.openEnd();var I=d.getDays();i=100/I;var s=d._getRelativeInfo()._getIndexFromDate(d.getStartDate());for(var j=0;j<I;j++){r.openStart("div");r.class('sapUiCalItem');if(d._getRelativeInfo&&d._getRelativeInfo().bIsRelative){r.class('sapUiRelativeCalItem');r.attr("data-sap-ui-index",s+j);r.attr("tabindex","-1");var A=d._getRelativeInfo()._getDateFromIndex(s+j+1);r.attr("data-sap-day",d._oFormatYyyymmdd.format(A,true));}r.style("width",i+"%");r.openEnd();r.openStart("span");r.class("sapUiCalItemText");r.openEnd();r.text(d._getRelativeInfo?d._getRelativeInfo().intervalLabelFormatter(s+j):(s+j));r.close("span");r.close("div");}r.close("div");};
D.renderWeekNumbers=function(r,d){var o,i,b,w;if(d.getShowWeekNumbers()&&d.getPrimaryCalendarType()===a.Gregorian){o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");r.openStart("div",d.getId()+"-weeks");r.class("sapUiCalRowWeekNumbers");r.openEnd();i=d.getDays();b=100/i;w=d.getWeekNumbers();w.forEach(function(W){r.openStart("div");r.class('sapUiCalRowWeekNumber');r.style("width",W.len*b+"%");r.attr("data-sap-ui-week",W.number);r.openEnd();r.text(o.getText('CALENDAR_DATES_ROW_WEEK_NUMBER',[W.number]));r.close("div");});r.close("div");}};
D.renderDummyCell=function(){};
D.renderHeader=function(r,d,o){var l=d._getLocaleData();var i=d.getId();var b=d.getDays();var w="";if(d._getShowHeader()){r.openStart("div",i+"-Head");r.openEnd();this.renderHeaderLine(r,d,l,o);r.close("div");}w=(100/b)+"%";if(d.getShowDayNamesLine()){r.openStart("div",i+"-Names");r.style("display","inline");r.openEnd();this.renderDayNames(r,d,l,o.getDay(),b,false,w);r.close("div");}};
D.renderHeaderLine=function(r,d,l,o){var I=d.getId();var b=d.getDays();var c=new C(o,d.getPrimaryCalendarType());var w="";var m=0;var e=[];var i=0;for(i=0;i<b;i++){m=c.getMonth();if(e.length>0&&e[e.length-1].iMonth==m){e[e.length-1].iDays++;}else{e.push({iMonth:m,iDays:1});}c.setDate(c.getDate()+1);}var f=l.getMonthsStandAlone("wide");for(i=0;i<e.length;i++){var g=e[i];w=(100/b*g.iDays)+"%";r.openStart("div",I+"-Head"+i);r.class("sapUiCalHeadText");r.style("width",w);r.openEnd();r.text(f[g.iMonth]);r.close("div");}};
D.renderDays=function(r,d,o){var b=d.getDays();var w=(100/b)+"%";var s=d.getShowDayNamesLine();if(!o){o=d._getFocusedDate();}var h=this.getDayHelper(d,o);if(!s){if(d._bLongWeekDays||!d._bNamesLengthChecked){h.aWeekDays=h.oLocaleData.getDaysStandAlone("abbreviated");}else{h.aWeekDays=h.oLocaleData.getDaysStandAlone("narrow");}h.aWeekDaysWide=h.oLocaleData.getDaysStandAlone("wide");}var c=new C(o,d.getPrimaryCalendarType());for(var i=0;i<b;i++){this.renderDay(r,d,c,h,false,false,i,w,!s);c.setDate(c.getDate()+1);}};
return D;},true);
sap.ui.predefine('sap/ui/unified/calendar/Header',['sap/ui/core/Control','sap/ui/unified/library',"./HeaderRenderer","sap/ui/dom/containsOrEquals"],function(C,l,H,c){"use strict";
var a=C.extend("sap.ui.unified.calendar.Header",{metadata:{library:"sap.ui.unified",properties:{textButton0:{type:"string",group:"Appearance"},additionalTextButton0:{type:"string",group:"Appearance"},ariaLabelButton0:{type:"string",group:"Misc"},visibleButton0:{type:"boolean",group:"Appearance",defaultValue:false},textButton1:{type:"string",group:"Appearance"},additionalTextButton1:{type:"string",group:"Appearance"},ariaLabelButton1:{type:"string",group:"Misc"},visibleButton1:{type:"boolean",group:"Appearance",defaultValue:true},textButton2:{type:"string",group:"Appearance"},additionalTextButton2:{type:"string",group:"Appearance"},ariaLabelButton2:{type:"string",group:"Misc"},visibleButton2:{type:"boolean",group:"Appearance",defaultValue:true},enabledPrevious:{type:"boolean",group:"Behavior",defaultValue:true},enabledNext:{type:"boolean",group:"Behavior",defaultValue:true},visibleCurrentDateButton:{type:"boolean",group:"Appearance",defaultValue:false}},events:{pressPrevious:{},pressNext:{},pressCurrentDate:{},pressButton0:{},pressButton1:{},pressButton2:{}}}});
a.prototype._setVisibleButton3=function(v){this._visibleButton3=v;this.invalidate();return this;};
a.prototype._getVisibleButton3=function(){return this._visibleButton3;};
a.prototype._setTextButton3=function(t){_.call(this,3,t);return this;};
a.prototype._getTextButton3=function(){return this._textButton3;};
a.prototype._setAdditionalTextButton3=function(t){b.call(this,3,t);return this;};
a.prototype._getAdditionalTextButton3=function(){return this._additionalTextButton3;};
a.prototype._setAriaLabelButton3=function(t){d.call(this,3,t);return this;};
a.prototype._getAriaLabelButton3=function(){return this._ariaLabelButton3;};
a.prototype._setVisibleButton4=function(v){this._visibleButton4=v;this.invalidate();return this;};
a.prototype._getVisibleButton4=function(){return this._visibleButton4;};
a.prototype._setTextButton4=function(t){_.call(this,4,t);return this;};
a.prototype._getTextButton4=function(){return this._textButton4;};
a.prototype._setAdditionalTextButton4=function(t){b.call(this,4,t);return this;};
a.prototype._getAdditionalTextButton4=function(){return this._additionalTextButton4;};
a.prototype._setAriaLabelButton4=function(t){d.call(this,4,t);return this;};
a.prototype._getAriaLabelButton4=function(){return this._ariaLabelButton4;};
a.prototype.onclick=function(e){if(e.isMarked("delayedMouseEvent")){return;}if(c(this.getDomRef("prev"),e.target)&&this.getEnabledPrevious()){this.firePressPrevious();}else if(c(this.getDomRef("next"),e.target)&&this.getEnabledNext()){this.firePressNext();}else if(c(this.getDomRef("today"),e.target)&&this.getVisibleCurrentDateButton()){this.firePressCurrentDate();}else if(c(this.getDomRef("B0"),e.target)){this.firePressButton0();}else if(c(this.getDomRef("B1"),e.target)){this.firePressButton1();}else if(c(this.getDomRef("B2"),e.target)){this.firePressButton2();}else if(c(this.getDomRef("B3"),e.target)){this.fireEvent("pressButton3");}else if(c(this.getDomRef("B4"),e.target)){this.fireEvent("pressButton4");}};
a.prototype.onsapnext=function(e){e.preventDefault();};
function _(B,t){this["_textButton"+B]=t;if(this.isActive()&&this["_getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function b(B,t){var r=false;var o=this["_getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this["_additionalTextButton"+B]=t;if(!r&&this.isActive()&&this["_getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}if(r){this.invalidate();}}
function d(B,t){this["_ariaLabelButton"+B]=t;if(this.isActive()&&this["_getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
return a;});
sap.ui.predefine('sap/ui/unified/calendar/HeaderRenderer',["sap/base/security/encodeXML"],function(e){"use strict";var M=5;var H={apiVersion:2};
H.render=function(r,h){var l=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var t=h.getTooltip_AsString();var I=h.getId();var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var L=R.getText("CALENDAR_BTN_NEXT");var s=R.getText("CALENDAR_BTN_PREV");var a=R.getText("CALENDAR_BTN_TODAY");r.openStart("div",h);r.class("sapUiCalHead");if(h.getVisibleCurrentDateButton()){r.class("sapUiCalHeaderWithTodayButton");}if(t){r.attr('title',t);}r.accessibilityState(h);r.openEnd();r.openStart("button",I+'-prev');r.attr("title",s);r.accessibilityState(null,{label:s});r.class("sapUiCalHeadPrev");if(!h.getEnabledPrevious()){r.class("sapUiCalDsbl");r.attr('disabled',"disabled");}r.attr('tabindex',"-1");r.openEnd();r.icon("sap-icon://slim-arrow-left",null,{title:null});r.close("button");var f=-1;var b=-1;var i=0;var B;for(i=0;i<M;i++){if(this.getVisibleButton(h,i)){if(f<0){f=i;}b=i;}}for(i=0;i<M;i++){if(l.toLowerCase()==="ja"||l.toLowerCase()==="zh"){B=M-1-i;if(this._isTwoMonthsCalendar(h)){switch(i){case 0:B=2;break;case 2:B=4;break;case 1:B=1;break;case 3:B=3;break;}}}else{B=i;}if(this._isTwoMonthsCalendar(h)){f=2;b=3;}this.renderCalendarButtons(r,h,I,f,b,B);}if(!h.getVisibleButton0()&&!h.getVisibleButton1()&&!h.getVisibleButton2()&&!h._getVisibleButton3()&&!h._getVisibleButton4()){r.openStart("div",I+'-B'+"-Placeholder");r.class("sapUiCalHeadBPlaceholder");r.openEnd();r.close("span");}r.openStart("button",I+'-next');r.attr("title",L);r.accessibilityState(null,{label:L});r.class("sapUiCalHeadNext");if(!h.getEnabledNext()){r.class("sapUiCalDsbl");r.attr('disabled',"disabled");}r.attr('tabindex',"-1");r.openEnd();r.icon("sap-icon://slim-arrow-right",null,{title:null});r.close("button");if(h.getVisibleCurrentDateButton()){r.openStart("button",I+'-today');r.attr("title",a);r.accessibilityState(null,{label:a});r.class("sapUiCalHeadB");r.class("sapUiCalHeadToday");r.attr('tabindex',"-1");r.openEnd();r.icon("sap-icon://appointment",null,{title:null});r.close("button");}r.close("div");};
H.renderCalendarButtons=function(r,h,I,f,l,i){var a={};if(this.getVisibleButton(h,i)){r.openStart("button",I+'-B'+i);r.class("sapUiCalHeadB");r.class("sapUiCalHeadB"+i);if(f===i){r.class("sapUiCalHeadBFirst");}if(l===i){r.class("sapUiCalHeadBLast");}r.attr('tabindex',"-1");if(this.getAriaLabelButton(h,i)){a["label"]=this.getAriaLabelButton(h,i);}r.accessibilityState(null,a);a={};r.openEnd();var t=this.getTextButton(h,i)||"";var A=this.getAdditionalTextButton(h,i)||"";if(A){r.openStart("span",I+'-B'+i+"-Text");r.class("sapUiCalHeadBText");r.openEnd();r.text(t);r.close("span");r.openStart("span",I+'-B'+i+"-AddText");r.class("sapUiCalHeadBAddText");r.openEnd();r.text(A);r.close("span");}else{r.text(t);}r.close("button");}};
H.getVisibleButton=function(h,b){var v=false;if(h["getVisibleButton"+b]){v=h["getVisibleButton"+b]();}else if(h["_getVisibleButton"+b]){v=h["_getVisibleButton"+b]();}return v;};
H.getAriaLabelButton=function(h,b){var a;if(h["getAriaLabelButton"+b]){a=h["getAriaLabelButton"+b]();}else if(h["_getAriaLabelButton"+b]){a=h["_getAriaLabelButton"+b]();}return a;};
H.getTextButton=function(h,b){var t;if(h["getTextButton"+b]){t=h["getTextButton"+b]();}else if(h["_getTextButton"+b]){t=h["_getTextButton"+b]();}return t;};
H.getAdditionalTextButton=function(h,b){var t;if(h["getAdditionalTextButton"+b]){t=h["getAdditionalTextButton"+b]();}else if(h["_getAdditionalTextButton"+b]){t=h["_getAdditionalTextButton"+b]();}return t;};
H._isTwoMonthsCalendar=function(h){return(h.getParent()instanceof sap.ui.unified.Calendar&&(h.getParent().getMonths()>=2));};
return H;},true);
sap.ui.predefine('sap/ui/unified/calendar/IndexPicker',["sap/ui/core/Control","sap/ui/unified/calendar/Header","sap/ui/unified/calendar/IndexPickerRenderer",'sap/ui/core/delegate/ItemNavigation',"sap/ui/events/KeyCodes"],function(C,H,I,a,K){"use strict";
var b=C.extend("sap.ui.unified.calendar.IndexPicker",{metadata:{library:"sap.ui.unified",properties:{startIndex:{type:"int",group:"Data",defaultValue:0},selectedIndex:{type:"int",group:"Data",defaultValue:0},formatter:{type:"object",group:"Data"},rows:{type:"int",group:"Data",defaultValue:4},columns:{type:"int",group:"Data",defaultValue:3},periodSize:{type:"int",group:"Data",defaultValue:1}},aggregations:{header:{type:"sap.ui.unified.calendar.Header",multiple:false}},events:{select:{},focus:{}}}});
b.prototype.init=function(){this._initializeHeader();this.iCurrentIndex=0;};
b.prototype.onBeforeRendering=function(){this.getHeader().setEnabledPrevious(this.getStartIndex()>0);};
b.prototype.onAfterRendering=function(){_.call(this);};
b.prototype._initializeHeader=function(){var h=new H(this.getId()+"--Head",{visibleButton1:false,visibleButton2:false});h.attachEvent("pressPrevious",this._handlePrevious,this);h.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",h);};
b.prototype._handlePrevious=function(){this.goToPreviousPage();};
b.prototype.goToPreviousPage=function(){var n=this.getStartIndex()-this.getRows()*this.getColumns();n=Math.max(0,n);this.setStartIndex(n);};
b.prototype._handleNext=function(){this.goToNextPage();};
b.prototype.goToNextPage=function(){var n=this.getStartIndex()+this.getRows()*this.getColumns();this.setStartIndex(n);};
b.prototype.onmouseup=function(e){var i=e.target.getAttribute("data-sap-ui-index");if(!i){return;}this._selectIndex(parseInt(i));};
b.prototype.onkeydown=function(e){if(e.keyCode===K.ENTER){var i=e.target.getAttribute("data-sap-ui-index");if(!i){return;}this._selectIndex(parseInt(i));}};
b.prototype.onkeyup=function(e){if(e.keyCode===K.SPACE){e.preventDefault();var i=e.target.getAttribute("data-sap-ui-index");if(!i){return;}this._selectIndex(parseInt(i));}};
b.prototype._selectIndex=function(i){this.setSelectedIndex(i);this.iCurrentIndex=0;this.fireSelect({index:i});};
b.prototype._getFormatter=function(){return this.getFormatter()||d;};
function d(i){return(i+1).toString();}
function _(){var e=0,s=false,r=this.getDomRef(),D=r.querySelectorAll(".sapMIPItem"),f=this.getColumns();for(var i=0;i<D.length;i++){if(D[i].getAttribute("data-sap-ui-index")===this.getSelectedIndex()){e=i;s=true;break;}}if(!this._oItemNavigation){this._oItemNavigation=new a();this._oItemNavigation.attachEvent(a.Events.AfterFocus,c,this);this._oItemNavigation.attachEvent(a.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(f>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(f,true);}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(D);if(!s){e=this.iCurrentIndex%D.length;}this._oItemNavigation.setFocusedIndex(e);this._oItemNavigation.focusItem(e);this._oItemNavigation.setPageSize(D.length);}
function c(o){var i=o.getParameter("index");var e=o.getParameter("event");if(!e){return;}var f=o.getParameter("index");var D=this._oItemNavigation.getItemDomRefs();var $=jQuery(D[i]);this.iCurrentIndex=f;f=$.attr("data-sap-ui-index");this.fireFocus({index:f});}
b.prototype._handleBorderReached=function(o){var e=o.getParameter("event");var f=parseInt(e.target.getAttribute("data-sap-ui-index"));var i=o.getParameter("index");if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":if(e.keyCode===K.ARROW_DOWN){f+=this.getColumns();i+=this.getColumns();}else{f+=1;i+=1;}this.goToNextPage();break;case"sapprevious":case"sappreviousmodifiers":if(e.keyCode===K.ARROW_UP){f-=this.getColumns();i-=this.getColumns();}else{f-=1;i-=1;}this.goToPreviousPage();break;default:break;}var D=this._oItemNavigation.getItemDomRefs();i=Math.abs(D.length-Math.abs(i));this.iCurrentIndex=i;this._oItemNavigation.focusItem(D[i]);this.fireFocus({index:f});}};
return b;});
sap.ui.predefine('sap/ui/unified/calendar/IndexPickerRenderer',[],function(){"use strict";var I={apiVersion:2};
I.render=function(r,p){var c,a={role:"gridcell",selected:false,label:"",describedby:""};r.openStart("div",p);r.class("sapMIP");r.openEnd();var h=p.getAggregation("header");r.renderControl(h);r.openStart("div");r.class("sapMIPContent");r.attr("role","grid");r.openEnd();for(var i=0;i<p.getRows();i++){r.openStart("div",p.getId()+"-"+i);r.class("sapMIPRow");r.attr("role","row");r.openEnd();var s=p.getSelectedIndex()+p.getPeriodSize()-1;for(var j=0;j<p.getColumns();j++){c=p.getStartIndex()+p.getColumns()*i+j;r.openStart("div");r.class("sapMIPItem");if(c===p.getSelectedIndex()){r.class("sapUiCalItemSel");r.class("sapUiCalItemSelStart");a["selected"]=true;a["describedby"]=a["describedby"]+" "+p.sId+"-Start";}else if(c===s){r.class("sapUiCalItemSel");r.class("sapUiCalItemSelEnd");a["selected"]=true;a["describedby"]=a["describedby"]+" "+p.sId+"-End";}else if(c>p.getSelectedIndex()&&c<s){r.class("sapUiCalItemSel");r.class("sapUiCalItemSelBetween");a["selected"]=true;}else{a["selected"]=false;}r.accessibilityState(null,a);r.class('sapUiCalItem');r.class("customWidth");r.attr("tabindex","-1");r.attr("data-sap-ui-index",c);r.openEnd();r.text(p._getFormatter()(c));r.close("div");}r.close("div");}r.close("div");r.close("div");};
return I;},true);
sap.ui.predefine('sap/ui/unified/calendar/Month',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/DateTypeRange','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthRenderer","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,L,I,a,b,c,d,l,e,f,g,M,h,K,q){"use strict";var j=f.CalendarType;var k=l.CalendarDayType;
var m=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true},_focusedDate:{type:"object",group:"Data",visibility:"hidden",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});
m.prototype.init=function(){var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._oFormatYyyymmdd=e.getInstance({pattern:"yyyyMMdd",calendarType:j.Gregorian});this._oFormatLong=e.getInstance({style:"long",calendarType:i});this._mouseMoveProxy=this._handleMouseMove.bind(this);this._iColumns=7;this._aVisibleDays=[];this._bAlwaysShowSpecialDates=false;};
m.prototype._getAriaRole=function(){return"gridcell";};
m.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}this._aVisibleDays=null;this._bAlwaysShowSpecialDates=null;};
m.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()];};
m.prototype.onAfterRendering=function(){this.bSpaceButtonPressed=false;_.call(this);s.call(this);};
m.prototype.onmouseover=function(E){var t=q(E.target),S=this.getSelectedDates()[0],i,u;if(!this._isMarkingUnfinishedRangeAllowed()){return;}if(!t.hasClass('sapUiCalItemText')&&!t.hasClass('sapUiCalItem')){return;}if(t.hasClass('sapUiCalItemText')){t=t.parent();}i=parseInt(this._oFormatYyyymmdd.format(S.getStartDate()));u=t.data("sapDay");if(this.hasListeners("datehovered")){this.fireEvent("datehovered",{date1:i,date2:u});}else{this._markDatesBetweenStartAndHoveredDate(i,u);}};
m.prototype._markDatesBetweenStartAndHoveredDate=function(t,u){var v,$,w,i;v=this.$().find(".sapUiCalItem");if(t>u){t=t+u;u=t-u;t=t-u;}for(i=0;i<v.length;i++){$=q(v[i]);w=$.data('sapDay');if(w>t&&w<u){$.addClass('sapUiCalItemSelBetween');}else{$.removeClass('sapUiCalItemSelBetween');if(w!=t&&w!=u){$.removeClass('sapUiCalItemSel');}}}};
m.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var S=this._selectDay(this._getDate());if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;r.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;r.call(this);}}};
m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};
m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
m.prototype.setDate=function(i){if(i){var t=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.call(this,t);}return this.setProperty("date",i);};
m.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};
m.prototype.displayDate=function(i){var t=b.fromLocalJSDate(i,this.getPrimaryCalendarType());p.call(this,t);return this;};
m.prototype.setPrimaryCalendarType=function(i){this.setProperty("primaryCalendarType",i);this._oFormatLong=e.getInstance({style:"long",calendarType:i});if(this._oDate){this._oDate=new b(this._oDate,i);}return this;};
m.prototype.setSecondaryCalendarType=function(i){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",i);this._oFormatSecondaryLong=e.getInstance({style:"long",calendarType:i});return this;};
m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S===P){S=undefined;}}return S;};
m.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
m.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var t=new g(i);this._oLocaleData=L.getInstance(t);}return this._oLocaleData;};
m.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!==i){var t=new g(i);this._oFormatLong=e.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},t);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=e.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},t);}}return this._oFormatLong;};
m.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
m.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
m.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
m.prototype.getDisabledDates=function(){var P=this.getParent();if(P&&P.getDisabledDates){return P.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};
m.prototype.getPrimaryCalendarType=function(){var P=this.getParent();if(P&&P.getPrimaryCalendarType){return P.getPrimaryCalendarType();}return this.getProperty("primaryCalendarType");};
m.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowMonthHeader){return P._getShowMonthHeader();}else{return this.getProperty("showHeader");}};
m.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
m.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("legend",[]);}};
m.prototype._getFirstDayOfWeek=function(){var P=this.getParent();var F=0;if(P&&P.getFirstDayOfWeek){F=P.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};
m.prototype._getNonWorkingDays=function(){var P=this.getParent();var N;if(P&&P.getNonWorkingDays){N=P.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!Array.isArray(N)){N=[];}return N;};
m.prototype._isSpecialDateMarkerEnabled=function(i){var t;if(this.getStartDate){t=this.getStartDate();}else if(this.getDate()){t=this.getDate();}else{t=new Date();}return this._bAlwaysShowSpecialDates||a._isSameMonthAndYear(i,b.fromLocalJSDate(t));};
m.prototype._checkDateSelected=function(t){a._checkCalendarDate(t);var S=0,u=this.getSelectedDates(),v=this.getPrimaryCalendarType(),i=0,F=this.getProperty("_focusedDate"),w=false,A;for(i=0;i<u.length;i++){var R=u[i],x=R.getStartDate()?b.fromLocalJSDate(R.getStartDate(),v):undefined,E=R.getEndDate()?b.fromLocalJSDate(R.getEndDate(),v):undefined;if(x&&E){A=this._arrangeStartAndEndDates(x,E);x=A.startDate;E=A.endDate;}w=this._isMarkingUnfinishedRangeAllowed()&&F&&(a._isBetween(t,x,F,true)||a._isBetween(t,F,x,true));if(x&&!E&&t.isSame(x)){S=1;break;}else if(E&&t.isSame(x)){S=2;if(t.isSame(E)){S=5;}break;}else if(E&&t.isSame(E)){S=3;break;}else if((E&&t.isAfter(x)&&t.isBefore(E))||w){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
m.prototype._getDateTypes=function(t){a._checkCalendarDate(t);var T,u,N,v=[];var S=this._getSpecialDates();var w=t.toUTCJSDate().getTime();var U=new Date(Date.UTC(0,0,1));for(var i=0;i<S.length;i++){var R=S[i];var x=R.getStartDate();var y=a.MAX_MILLISECONDS;if(x){U.setUTCFullYear(x.getFullYear(),x.getMonth(),x.getDate());y=U.getTime();}var E=R.getEndDate();var z=-a.MAX_MILLISECONDS;if(E){U.setUTCFullYear(E.getFullYear(),E.getMonth(),E.getDate());z=U.getTime();}N=R.getType()===k.NonWorking;if((w===y&&!E)||(w>=y&&w<=z)){if(!N&&!T){T={type:R.getType(),tooltip:R.getTooltip_AsString(),color:R.getColor()};v.push(T);}else if(N&&!u){u={type:R.getType(),tooltip:R.getTooltip_AsString()};v.push(u);}if(T&&u){break;}}}return v;};
m.prototype._checkDateEnabled=function(t){a._checkCalendarDate(t);var E=true;var u=this.getDisabledDates();var T=t.toUTCJSDate().getTime();var v=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(T<P._oMinDate.valueOf()||T>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<u.length;i++){var R=u[i];var S=R.getStartDate();var w=0;if(S){S=b.fromLocalJSDate(S,v);w=S.toUTCJSDate().getTime();}var x=R.getEndDate();var y=0;if(x){x=b.fromLocalJSDate(x,v);y=x.toUTCJSDate().getTime();}if(x){if(T>w&&T<y){E=false;break;}}else if(T===w){E=false;break;}}return E;};
m.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalItemText")){t=t.parent();}if(this._sLastTargetId&&this._sLastTargetId===t.attr("id")){return;}this._sLastTargetId=t.attr("id");if(t.hasClass("sapUiCalItem")){var O=this._getDate();if(h(this.getDomRef(),E.target)){var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(t.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F.isSame(O)){if(t.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._oDate=F;var S=this._selectDay(F,true);if(S){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};
m.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};if(E.button||D.support.touch||!this._isWeekSelectionAllowed()||!E.target.classList.contains("sapUiCalWeekNum")){return;}var $=q(E.target),i=$.siblings().eq(0).attr("data-sap-day"),P=this._oFormatYyyymmdd.parse(i),F=b.fromLocalJSDate(P,this.getPrimaryCalendarType());this._handleWeekSelection(F,true);};
m.prototype.onmouseup=function(E){var N=E.button!==2;if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var t=this._oItemNavigation.getItemDomRefs();for(var i=0;i<t.length;i++){var $=q(t[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")===this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.trigger("focus");break;}}}if(this._bMoveChange){var S=this._selectDay(F);if(!S&&this._oMoveSelectedDate){this._selectDay(this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;r.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;r.call(this);}else if(D.support.touch&&N&&this._areMouseEventCoordinatesInThreshold(E.clientX,E.clientY,10)){var u=E.target.classList,v=(u.contains("sapUiCalItemText")||u.contains("sapUiCalDayName")),w=u.contains("sapUiCalWeekNum"),x=this._getSelectedDateFromEvent(E);if(w&&this._isWeekSelectionAllowed()){this._handleWeekSelection(x,true);}else if(v&&E.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(x);}else if(v){this._selectDay(x,false,false);r.call(this);}}};
m.prototype.onsapselect=function(E){if(this.bSpaceButtonPressed){return;}var S=this._selectDay(this._getSelectedDateFromEvent(E));if(S){r.call(this);}E.stopPropagation();E.preventDefault();};
m.prototype.onkeydown=function(E){if(E.which===K.SPACE){this.bSpaceButtonPressed=true;}};
m.prototype.onkeyup=function(E){if(E.which===K.SPACE){this.bSpaceButtonPressed=false;}};
m.prototype.onsapselectmodifiers=function(E){var S=this._getSelectedDateFromEvent(E),F;if(this._isWeekSelectionAllowed()&&E.shiftKey&&E.keyCode===K.SPACE){F=a._getFirstDateOfWeek(S);this._handleWeekSelection(F,false);}else if(this._isConsecutiveDaysSelectionAllowed()&&E.shiftKey&&E.keyCode===K.ENTER){this._handleConsecutiveDaysSelection(S);}E.preventDefault();};
m.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
m.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
m.prototype._isValueInThreshold=function(R,v,t){var i=R-t,u=R+t;return v>=i&&v<=u;};
m.prototype._areMouseEventCoordinatesInThreshold=function(i,t,T){return this._oMousedownPosition&&this._isValueInThreshold(this._oMousedownPosition.clientX,i,T)&&this._isValueInThreshold(this._oMousedownPosition.clientY,t,T)?true:false;};
m.prototype._bindMousemove=function(F){q(window.document).on('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};
m.prototype._unbindMousemove=function(F){q(window.document).off('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};
m.prototype.onThemeChanged=function(){if(this._bNoThemeChange||!this.getDomRef()){return;}var w=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),t=this._getLocaleData(),S=this._getFirstWeekDay(),u=t.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType()),W,i;this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;for(i=0;i<w.length;i++){W=w[i];W.textContent=u[(i+S)%7];}s.call(this);};
m.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var t=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode===K.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode===K.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":t=F.getMonth()+1;F.setMonth(t);if(t%12!==F.getMonth()){while(t!==F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":t=F.getMonth()-1;F.setMonth(t);if(t<0){t=11;}if(t!==F.getMonth()){while(t!==F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}};
m.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var t=this._getDate();var u=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(u,t);};
m.prototype.applyFocusInfo=function(i){return this;};
m.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};
m.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};
m.prototype._getVisibleDays=function(S,i){var N,t,u,v,F,w,y;if(!S){return this._aVisibleDays;}this._aVisibleDays=[];w=this._getFirstDayOfWeek();F=new b(S,this.getPrimaryCalendarType());F.setDate(1);v=F.getDay()-w;if(v<0){v=7+v;}if(v>0){F.setDate(1-v);}t=new b(F);N=(S.getMonth()+1)%12;do{y=t.getYear();u=new b(t,this.getPrimaryCalendarType());if(i&&y<1){u._bBeforeFirstYear=true;this._aVisibleDays.push(u);}else if(y>0&&y<10000){this._aVisibleDays.push(u);}t.setDate(t.getDate()+1);}while(t.getMonth()!==N||t.getDay()!==w);return this._aVisibleDays;};
m.prototype._handleMousedown=function(E,F){var w=E.target.classList.contains("sapUiCalWeekNum"),i=!E.button,S=this._getSelectedDateFromEvent(E);if(!i||D.support.touch){return this;}if(w){this._isWeekSelectionAllowed()&&this._handleWeekSelection(S,true);return this;}else if(E.shiftKey&&this._isConsecutiveDaysSelectionAllowed()){this._handleConsecutiveDaysSelection(S);return this;}var t=this._selectDay(F);if(t){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(t&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");};
m.prototype._getSelectedDateFromEvent=function(E){var t=E.target,i,P;if(t.classList.contains("sapUiCalWeekNum")){i=t.nextSibling.getAttribute("data-sap-day");}else{i=t.getAttribute("data-sap-day")||t.parentNode.getAttribute("data-sap-day");}P=this._oFormatYyyymmdd.parse(i);return P?b.fromLocalJSDate(P,this.getPrimaryCalendarType()):null;};
m.prototype._handleWeekSelection=function(S,F){var i=this._calculateWeekNumber(S),E=this._getLastWeekDate(S),t=this.getSingleSelection(),u=this.getIntervalSelection();if(!t&&!u){this._handleWeekSelectionByMultipleDays(i,S,E);}else if(t&&u){this._handleWeekSelectionBySingleInterval(i,S,E);}F&&this._focusDate(S);return this;};
m.prototype._handleConsecutiveDaysSelection=function(E){var S=this.getSelectedDates(),i=S.length&&S[S.length-1].getStartDate(),t=i?b.fromLocalJSDate(i):E,u;u=this._areAllDaysBetweenSelected(t,E);this._toggleDaysBetween(t,E,!u);return this;};
m.prototype._calculateWeekNumber=function(i){var E=this._getLastWeekDate(i);var t=new g(this._getLocale());var u=this._getLocaleData();var v=e.getInstance({pattern:"w",calendarType:this.getPrimaryCalendarType()},t);var w;var x=u.firstDayStartsFirstWeek();if(i.getMonth()===11&&E.getMonth()===0&&x){w=1;}else{w=v.format(i.toLocalJSDate());}return w;};
m.prototype._isWeekSelectionAllowed=function(){var S=this.getSingleSelection(),i=this.getIntervalSelection(),t=this.getPrimaryCalendarType(),u=this.getFirstDayOfWeek()!==-1,v=!S&&!i,w=S&&i,A=w||v;return t===j.Gregorian&&!u&&A;};
m.prototype._isConsecutiveDaysSelectionAllowed=function(){var S=this.getSingleSelection(),i=this.getIntervalSelection();return!S&&!i;};
m.prototype._isMarkingUnfinishedRangeAllowed=function(){var S=this.getSelectedDates()[0],v=!!(S&&S.getStartDate()&&!S.getEndDate());return(this.getIntervalSelection()&&v);};
m.prototype._handleWeekSelectionByMultipleDays=function(w,S,E){var i,t,u;i=this._areAllDaysBetweenSelected(S,E)?new c({startDate:S.toLocalJSDate()}):new c({startDate:S.toLocalJSDate(),endDate:E.toLocalJSDate()});t=this.fireWeekNumberSelect({weekNumber:w,weekDays:i});u=i.getEndDate()?true:false;if(t){this._toggleDaysBetween(S,E,u);}return this;};
m.prototype._handleWeekSelectionBySingleInterval=function(w,S,E){var i=new c({startDate:S.toLocalJSDate(),endDate:E.toLocalJSDate()}),t=this.getParent(),A=this,u;if(t&&t.getSelectedDates){A=t;}if(this._isIntervalSelected(i)){i=null;}u=this.fireWeekNumberSelect({weekNumber:w,weekDays:i});if(u){A.removeAllSelectedDates();A.addSelectedDate(i);}return this;};
m.prototype._isIntervalSelected=function(i){var S=this.getSelectedDates(),t=S.length&&S[0],u=t&&t.getEndDate();return t&&t.getStartDate()&&t.getStartDate().getTime()===i.getStartDate().getTime()&&u&&t.getEndDate()&&t.getEndDate().getTime()===i.getEndDate().getTime();};
m.prototype._getLastWeekDate=function(w){return new b(w).setDate(w.getDate()+6);};
m.prototype._toggleDaysBetween=function(S,E,i){var A=this._arrangeStartAndEndDates(S,E),t=new b(A.startDate),u;do{u=this._checkDateSelected(t);if((!u&&i)||(u&&!i)){this._selectDay(t);r.call(this);}t.setDate(t.getDate()+1);}while(t.isSameOrBefore(A.endDate));return this;};
m.prototype._areAllDaysBetweenSelected=function(S,E){var A=this._arrangeStartAndEndDates(S,E),i=new b(A.startDate),t=true;do{if(!this._checkDateSelected(i)){t=false;break;}i.setDate(i.getDate()+1);}while(i.isSameOrBefore(A.endDate));return t;};
m.prototype._arrangeStartAndEndDates=function(S,E){var A=S.isSameOrBefore(E);return{startDate:A?S:E,endDate:A?E:S};};
m.prototype._selectDay=function(t,u){if(!this._checkDateEnabled(t)){return false;}var S=this.getSelectedDates();var v;var w=this._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=this.getParent();var A=this;var x;var z=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){v=S[0];x=v.getStartDate();if(x){x=b.fromLocalJSDate(x,z);}}else{v=new c();A.addAggregation("selectedDates",v,true);}if(this.getIntervalSelection()&&(!v.getEndDate()||u)&&x){var E;if(t.isBefore(x)){E=x;x=t;if(!u){v.setProperty("startDate",x.toLocalJSDate());v.setProperty("endDate",E.toLocalJSDate());}}else if(t.isSameOrAfter(x)){E=t;if(!u){v.setProperty("endDate",E.toLocalJSDate());}}}else{v.setProperty("startDate",t.toLocalJSDate());v.setProperty("endDate",undefined);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var B=this._checkDateSelected(t);if(B>0){for(i=0;i<S.length;i++){x=S[i].getStartDate();if(x&&t.isSame(b.fromLocalJSDate(x,z))){A.removeAggregation("selectedDates",i,true);break;}}}else{v=new c({startDate:t.toLocalJSDate()});A.addAggregation("selectedDates",v,true);}y=this._oFormatYyyymmdd.format(t.toUTCJSDate(),true);for(i=0;i<w.length;i++){$=q(w[i]);if($.attr("data-sap-day")===y){if(B>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;};
m.prototype._getSpecialDates=function(){var P=this.getParent();if(P&&P._getSpecialDates){return P._getSpecialDates();}else{var t=this.getSpecialDates();for(var i=0;i<t.length;i++){var N=t[i].getSecondaryType()===l.CalendarDayType.NonWorking&&t[i].getType()!==l.CalendarDayType.NonWorking;if(N){var u=new d();u.setType(l.CalendarDayType.NonWorking);u.setStartDate(t[i].getStartDate());if(t[i].getEndDate()){u.setEndDate(t[i].getEndDate());}t.push(u);}}return t;}};
function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true),t=0,R=this.getDomRef(),u=R.querySelectorAll(".sapUiCalItem");for(var i=0;i<u.length;i++){if(u[i].getAttribute("data-sap-day")===y){t=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,n,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,o,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(u);this._oItemNavigation.setFocusedIndex(t);this._oItemNavigation.setPageSize(u.length);}
function n(t){var u=t.getParameter("index"),E=t.getParameter("event"),O=this._getDate(),F=new b(O,this.getPrimaryCalendarType()),v=false,w=true,x=this._oItemNavigation.getItemDomRefs(),y=x[u],z=y.getAttribute("data-sap-day"),A;if(!E){return;}if(y.classList.contains("sapUiCalItemOtherMonth")||y.classList.contains("sapUiCalItemDsbl")){if(E.type==="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){for(var i=0;i<x.length;++i){A=x[i];if(!(A.classList.contains("sapUiCalItemOtherMonth")||A.classList.contains("sapUiCalItemDsbl"))){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(A.getAttribute("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else if(E.type==="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(var i=x.length-1;i>0;--i){A=x[i];if(!(A.classList.contains("sapUiCalItemOtherMonth")||A.classList.contains("sapUiCalItemDsbl"))){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(A.getAttribute("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{v=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(z),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type==="mousedown"||(this._sTouchstartYyyyMMdd&&E.type==="focusin"&&this._sTouchstartYyyyMMdd===z)||y.classList.contains("sapUiCalItemDsbl")){w=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}this._sTouchstartYyyyMMdd=E.originalEvent&&(E.originalEvent.type==="touchstart")?z:undefined;}}else{if(E.target.classList.contains("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(z),this.getPrimaryCalendarType());this._oDate=F;}this._sTouchstartYyyyMMdd=undefined;}if(E.type==="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=y.id;}if(w){this.fireFocus({date:F.toLocalJSDate(),otherMonth:v});}if(E.type==="mousedown"){this._handleMousedown(E,F,u);}}
function o(i){var t=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type==="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var u=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=u[t].id;}this._handleMousedown(E,F,t);}}
function p(i){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var t=new b(i);this.setProperty("date",i.toLocalJSDate());this._oDate=t;}else{this.invalidate();}}
m.prototype._focusDate=function(t,S,u){if(!S){this.setDate(t.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(t.toUTCJSDate(),true),v=this._oItemNavigation.getItemDomRefs(),w;for(var i=0;i<v.length;i++){w=v[i];if(w.getAttribute("data-sap-day")===y){if(document.activeElement!==v[i]){if(u||D.system.phone){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};
function r(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}
function s(){if(!this._bNamesLengthChecked){var w,W=this.getDomRef().querySelectorAll(".sapUiCalWH:not(.sapUiCalDummy)"),t=this._isMonthNameLong(W),u,S,v,i;if(t){this._bLongWeekDays=false;u=this._getLocaleData();S=this._getFirstWeekDay();v=u.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];w.textContent=v[(i+S)%7];}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}
return m;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPicker',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/library','sap/ui/core/Locale',"./MonthPickerRenderer","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/ui/unified/DateRange",'sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate'],function(C,D,L,I,l,a,M,q,K,c,d,e){"use strict";var f=12,g=2,O={OneYearBackward:-1,OneYearForward:1};
var h=C.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},_firstMonth:{type:"int",group:"Data",visibility:"hidden",defaultValue:0},_focusedMonth:{type:"int",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{},pageChange:{}}}});
h.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._iMinMonth=0;this._iMaxMonth=11;};
h.prototype.onAfterRendering=function(){_.call(this);m.call(this);var F=this.getProperty("_focusedMonth")%this.getMonths(),p=parseInt(12/this.getMonths()),i=p*this.getMonths();if(this.getProperty("_focusedMonth")>=i){F=12-i+1+F;}this._oItemNavigation.focusItem(F);};
h.prototype.setMonth=function(i){var F=Math.floor(i/this.getMonths())*this.getMonths();if(F+this.getMonths()>12){F=12-this.getMonths();}this.setProperty("month",i);this.setProperty("_focusedMonth",i);this.setProperty("_firstMonth",F);i=this.getProperty("month");if(i<0||i>11){throw new Error("Property month must be between 0 and 11; "+this);}if(this.getIntervalSelection()){this._oItemNavigation&&this._oItemNavigation.focusItem(i);return this;}if(this.getDomRef()){if(this.getMonths()<12){var s=this.getStartMonth();if(i>=s&&i<=s+this.getMonths()-1){this._selectMonth(i,true);this._oItemNavigation.focusItem(i-s);}else{n.call(this,i);}}else{this._selectMonth(i,true);this._oItemNavigation.focusItem(i);}}return this;};
h.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates();}return this.getAggregation("selectedDates");};
h.prototype._getSelectedDates=function(){var s=this.getSelectedDates(),o;if(s){return s;}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new c()];o=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());o.setMonth(this.getMonth(),1);this._iYear&&o.setYear(this._iYear);this._aMPSelectedDates[0].setStartDate(o.toLocalJSDate());return this._aMPSelectedDates;}else{return this._aMPSelectedDates;}};
h.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(o){o.destroy();});this._aMPSelectedDates=undefined;}};
h.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._oItemNavigation.getFocusedIndex()];};
h.prototype._setSelectedDatesControlOrigin=function(o){this._oSelectedDatesControlOrigin=o;};
h.prototype._setYear=function(y){this._iYear=y;};
h.prototype._getLocale=function(){var p=this.getParent();if(p&&p._getLocale){return p._getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new a(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};
h.prototype.onsapspace=function(E){E.preventDefault();};
h.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var b=i+this.getStartMonth();if(b>=this._iMinMonth&&b<=this._iMaxMonth){this._selectMonth(b);this.fireSelect();}};
h.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
h.prototype.onmouseup=function(E){var t=E.target,s=this._getSelectedDates()[0],S,o,i;if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&t.classList.contains("sapUiCalItem")&&s){S=e.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());o=s.getEndDate();i=this._extractMonth(t);if(i!==S.getMonth()&&!o){this._selectMonth(i);this._oItemNavigation.focusItem(i);}}this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){i=this._oItemNavigation.getFocusedIndex()+this.getStartMonth();if(i>=this._iMinMonth&&i<=this._iMaxMonth){this._selectMonth(i);this.fireSelect();}}};
h.prototype.onmouseover=function(E){var t=E.target,s=this._getSelectedDates()[0],S,F;if(!s){return;}if(s.getStartDate()){S=e.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setDate(1);}if(t.classList.contains("sapUiCalItem")){F=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());F.setMonth(this._extractMonth(t),1);this._iYear&&F.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(S,F);}}};
h.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}if(!this.getDomRef()){return;}var b=this._oItemNavigation.getItemDomRefs(),o=this._getLocaleData(),p=o.getMonthsStandAlone("wide",this.getPrimaryCalendarType()),i,$;this._bNamesLengthChecked=undefined;this._bLongMonth=false;for(i=0;i<b.length;i++){$=q(b[i]);$.text(p[i]);}m.call(this);};
h.prototype.nextPage=function(){var s=this.getStartMonth(),i=this._oItemNavigation.getFocusedIndex(),b=i+s,o=this.getMonths();b=b+o;if(b>f-1){b=f-1;}n.call(this,b);var F=Math.floor(this.getStartMonth()+this.getMonths())%f;if(F+this.getMonths()>12){F=12-this.getMonths();}this.setProperty("_firstMonth",F);return this;};
h.prototype.previousPage=function(){var s=this.getStartMonth(),i=this._oItemNavigation.getFocusedIndex(),b=i+s,o=this.getMonths();b=b-o;if(b<0){b=0;}n.call(this,b);var F=Math.floor(this.getStartMonth()-this.getMonths())%f;if(F<0){F=0;}this.setProperty("_firstMonth",F);return this;};
h.prototype.setMinMax=function(b,o){var p,$,r,i;if(b==this._iMinMonth&&o==this._iMaxMonth){return this;}b=parseInt(b);if(isNaN(b)||b<0||b>11){b=0;}o=parseInt(o);if(isNaN(o)||o<0||o>11){o=11;}if(b<=o){this._iMinMonth=b;this._iMaxMonth=o;}else{this._iMaxMonth=b;this._iMinMonth=o;}if(this.getDomRef()){p=this._oItemNavigation.getItemDomRefs();for(i=0;i<p.length;i++){$=q(p[i]);r=this._extractMonth(p[i]);if(r<this._iMinMonth||r>this._iMaxMonth){$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}else{$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}}}return this;};
h.prototype.getStartMonth=function(){return this.getProperty("_firstMonth");};
h.prototype._isValueInThreshold=function(r,v,t){var i=r-t,u=r+t;return v>=i&&v<=u;};
function _(){var r=this.getDomRef(),b=this.$().find(".sapUiCalItem"),i=this.getColumns();if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._handleAfterFocus,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(b);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(i,true);var o=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(o);this._oItemNavigation.setPageSize(b.length);}
h.prototype._handleAfterFocus=function(o){var i=o.getParameter("index"),E=o.getParameter("event"),t=this._oItemNavigation.aItemDomRefs[i],s=this._getSelectedDates()[0],S,F;if(!E){return;}if(E.type==="mousedown"){this._handleMousedown(E,i);}else if(E.type==="sapnext"||E.type==="sapprevious"){if(!s){return;}if(s.getStartDate()){S=e.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setDate(1);}F=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());F.setMonth(this._extractMonth(t),1);this._iYear&&F.setYear(this._iYear);if(this._isSelectionInProgress()){this._markInterval(S,F);}}};
function j(o){this._handleAfterFocus(o);}
h.prototype._isSelectionInProgress=function(){var s=this._getSelectedDates()[0];if(!s){return false;}return this.getIntervalSelection()&&s.getStartDate()&&!s.getEndDate();};
h.prototype._extractMonth=function(o){var i=this.getId().length+g;return parseInt(o.id.slice(i));};
h.prototype._markInterval=function(s,E){var b=this._oItemNavigation.getItemDomRefs(),o=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType()),i;if(s.isAfter(E)){E=[s,s=E][0];}if(this._bMousedownChange){q(b[E.getMonth()]).addClass("sapUiCalItemSel");q(b[s.getMonth()]).addClass("sapUiCalItemSel");}for(i=0;i<b.length;++i){o.setMonth(this._extractMonth(b[i]),1);this._iYear&&o.setYear(this._iYear);if(d._isBetween(o,s,E)){q(b[i]).addClass("sapUiCalItemSelBetween");}else{q(b[i]).removeClass("sapUiCalItemSelBetween");}if(this._bMousedownChange&&!o.isSame(s)&&!o.isSame(E)){q(b[i]).removeClass("sapUiCalItemSel");}}};
h.prototype._handleMousedown=function(E,i){if(E.button||D.support.touch&&!D.system.combi){return;}var b=i+this.getStartMonth();if(b>=this._iMinMonth&&b<=this._iMaxMonth){this._selectMonth(b);this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");};
function k(o){var E=o.getParameter("event"),i=this._oItemNavigation.getFocusedIndex()+this.getStartMonth(),b=this.getMonths(),p=this.getColumns(),s=this._getSelectedDates()[0],S,F=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());this._iYear&&F.setYear(this._iYear);if(s&&s.getStartDate()){S=e.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setDate(1);}if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode===K.ARROW_DOWN&&p<=b){if(i<f-b){n.call(this,i+p,false,O.OneYearForward);}else if(b===f){this.firePageChange({offset:O.OneYearForward});this._oItemNavigation.focusItem(i%p);F.setMonth(i%p,1);this.setProperty("_focusedMonth",i%p);this._isSelectionInProgress()&&this._markInterval(S,F);}else{n.call(this,i%p,true,O.OneYearForward);}}else{if(i<f-b){n.call(this,i+1,false,O.OneYearForward);}else if(b===f){this.firePageChange({offset:O.OneYearForward});this._oItemNavigation.focusItem(0);F.setMonth(0,1);this._isSelectionInProgress()&&this._markInterval(S,F);}else{n.call(this,0,true,O.OneYearForward);}}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode===K.ARROW_UP&&p<=b){if(i>=b){n.call(this,i-p,false,O.OneYearBackward);}else if(b===f){this.firePageChange({offset:O.OneYearBackward});this._oItemNavigation.focusItem(b-p+i);F.setMonth(b-p+i,1);this.setProperty("_focusedMonth",b-p+i);this._isSelectionInProgress()&&this._markInterval(S,F);}else{n.call(this,f-p+i,true,O.OneYearBackward);}}else{if(i>=b){n.call(this,i-1,false,O.OneYearBackward);}else if(b===f){this.firePageChange({offset:O.OneYearBackward});this._oItemNavigation.focusItem(b-1);F.setMonth(b-1,1);this._isSelectionInProgress()&&this._markInterval(S,F);}else{n.call(this,f-1,true,O.OneYearBackward);}}break;case"sappagedown":if(i<f-b){n.call(this,i+b,false,O.OneYearForward);}else if(b===f){this.firePageChange({offset:O.OneYearForward});}else{n.call(this,i,true,O.OneYearForward);}break;case"sappageup":if(i>b){n.call(this,i-b,false,O.OneYearBackward);}else if(b===f){this.firePageChange({offset:O.OneYearBackward});}else{n.call(this,i,true,O.OneYearBackward);}break;default:break;}}}
h.prototype._selectMonth=function(i,b){var s=this._getSelectedDates()[0],o=this.getAggregation("selectedDates"),S,F;this.setProperty("_focusedMonth",i);if(!s){return;}!b&&this.setProperty("month",i);F=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());F.setMonth(i,1);this._iYear&&F.setYear(this._iYear);if(!this._oSelectedDatesControlOrigin){if(!o||!o.length){this.addAggregation("selectedDates",s,true);}!this.getIntervalSelection()&&s.setStartDate(F.toLocalJSDate());}if(this.getIntervalSelection()&&!b){if(!s.getStartDate()){s.setStartDate(F.toLocalJSDate());}else if(!s.getEndDate()){S=e.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());if(F.isBefore(S)){s.setEndDate(S.toLocalJSDate());s.setStartDate(F.toLocalJSDate());}else{s.setEndDate(F.toLocalJSDate());}}else{s.setStartDate(F.toLocalJSDate());s.setEndDate(undefined);}}};
function m(){if(!this._bNamesLengthChecked){var i=0,o=this._oItemNavigation.getItemDomRefs(),t=false,p=this.getMonths(),B=Math.ceil(f/p),r=p-1;for(var b=0;b<B;b++){if(p<f){n.call(this,r);r=r+p;if(r>f-1){r=f-1;}}for(i=0;i<o.length;i++){var s=o[i];if(Math.abs(s.clientWidth-s.scrollWidth)>1){t=true;break;}}if(t){break;}}if(p<f){r=this.getMonth();n.call(this,r);}if(t){this._bLongMonth=false;var u=this._getLocaleData(),v=this.getPrimaryCalendarType(),w=u.getMonthsStandAlone("abbreviated",v),x=u.getMonthsStandAlone("wide",v);for(i=0;i<o.length;i++){var $=q(o[i]);$.text(w[i]);$.attr("aria-label",x[i]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function n(i,F,o){var s=this._getSelectedDates()[0],S,b;this.setProperty("_focusedMonth",i);if(s&&s.getStartDate()){S=e.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setDate(1);}if(s&&s.getEndDate()){b=e.fromLocalJSDate(s.getEndDate(),this.getPrimaryCalendarType());b.setDate(1);}else{b=e.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());this._iYear&&b.setYear(this._iYear);b.setMonth(i,1);}this._isSelectionInProgress()&&this._markInterval(S,b);if(F){this.firePageChange({offset:o});}}
h.prototype._fnShouldApplySelection=function(o){var s=this._getSelectedDates()[0],S,E;if(!s){return false;}S=s.getStartDate();E=s.getEndDate();if(S){S=e.fromLocalJSDate(S,this.getPrimaryCalendarType());S.setDate(1);}if(this.getIntervalSelection()&&S&&E){E=e.fromLocalJSDate(E,this.getPrimaryCalendarType());E.setDate(1);if(o.isSame(S)||o.isSame(E)){return true;}}else if(S&&o.isSame(S)){return true;}return false;};
h.prototype._fnShouldApplySelectionBetween=function(o){var s=this._getSelectedDates()[0],S,E;if(!s){return false;}S=s.getStartDate();E=s.getEndDate();if(this.getIntervalSelection()&&S&&E){S=e.fromLocalJSDate(S,this.getPrimaryCalendarType());S.setDate(1);E=e.fromLocalJSDate(E,this.getPrimaryCalendarType());E.setDate(1);if(d._isBetween(o,S,E)){return true;}}return false;};
return h;});
sap.ui.predefine('sap/ui/unified/calendar/MonthPickerRenderer',["sap/ui/unified/calendar/CalendarDate",'sap/ui/core/InvisibleText'],function(C,I){"use strict";var M={apiVersion:2};
M.render=function(r,m){var a=(m.getProperty("_firstMonth")!==undefined)?m.getProperty("_firstMonth"):m.getMonth(),b=m.getMonths(),s=0,c=m.getColumns(),t=m.getTooltip_AsString(),l=m._getLocaleData(),d=m.getId(),w="",e=[],f=[],g=m.getPrimaryCalendarType(),i,A,h;if(m._bLongMonth||!m._bNamesLengthChecked){e=l.getMonthsStandAlone("wide",g);}else{e=l.getMonthsStandAlone("abbreviated",g);f=l.getMonthsStandAlone("wide",g);}r.openStart("div",m);r.class("sapUiCalMonthPicker");if(t){r.attr("tooltip",t);}r.accessibilityState(m,{role:"grid",readonly:"true",multiselectable:m.getIntervalSelection(),roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("MONTH_PICKER"),describedby:m._bCalendar?I.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT"):""});r.openEnd();var j;if(b>12){b=12;}else if(b<12){s=a;}if(c>0){w=(100/c)+"%";}else{w=(100/b)+"%";}for(i=0;i<b;i++){var k=i+s,o=C.fromLocalJSDate(new Date(),m.getPrimaryCalendarType());o.setMonth(k,1);m._iYear&&o.setYear(m._iYear);j={role:"gridcell"};if(!m._bLongMonth&&m._bNamesLengthChecked){j["label"]=f[k];}if(c>0&&i%c===0){r.openStart("div");r.accessibilityState(null,{role:"row"});r.openEnd();}r.openStart("div",d+"-m"+(k));r.class("sapUiCalItem");A=m._fnShouldApplySelection(o);h=m._fnShouldApplySelectionBetween(o);if(A){r.class("sapUiCalItemSel");j["selected"]=true;}if(h){r.class("sapUiCalItemSelBetween");j["selected"]=true;}if(!A&&!h){j["selected"]=false;}if(k<m._iMinMonth||k>m._iMaxMonth){r.class("sapUiCalItemDsbl");j["disabled"]=true;}r.attr("tabindex","-1");r.style("width",w);r.accessibilityState(null,j);r.openEnd();r.text(e[k]);r.close("div");if(c>0&&((i+1)%c===0)){r.close("div");}}r.close("div");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library',"sap/base/Log",'sap/ui/core/InvisibleText',"sap/ui/core/format/DateFormat","sap/ui/core/Locale"],function(C,a,b,c,d,l,L,I,D,e){"use strict";var f=l.CalendarDayType;var g=d.CalendarType;var M={apiVersion:2};
M.render=function(r,m){var o=this.getStartDate(m),t=m.getTooltip_AsString(),h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),i=m.getId(),A={value:"",append:true},s="",w=m.getWidth();r.openStart("div",m);this.getClass(r,m).forEach(function(j){r.class(j);});if(m._getSecondaryCalendarType()){r.class("sapUiCalMonthSecType");}this.addWrapperAdditionalStyles(r,m);if(t){r.attr("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(m._bCalendar){s+=" "+I.getStaticId("sap.ui.unified","CALENDAR_MONTH_PICKER_OPEN_HINT")+" "+I.getStaticId("sap.ui.unified","CALENDAR_YEAR_PICKER_OPEN_HINT");}if(w){r.style("width",w);}r.accessibilityState(m,{role:"grid",roledescription:h.getText("CALENDAR_DIALOG"),multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A,describedby:s});r.openEnd();if(m.getIntervalSelection()){r.openStart("span",i+"-Start");r.style("display","none");r.openEnd();r.text(h.getText("CALENDAR_START_DATE"));r.close("span");r.openStart("span",i+"-End");r.style("display","none");r.openEnd();r.text(h.getText("CALENDAR_END_DATE"));r.close("span");}this.renderMonth(r,m,o);r.close("div");};
M.addWrapperAdditionalStyles=function(){};
M.getStartDate=function(m){return m._getDate();};
M.getClass=function(r,m){var h=["sapUiCalMonthView"],s=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(s===g.Islamic||!S){h.push("sapUiCalNoWeekNum");}return h;};
M.renderMonth=function(r,m,o){this.renderHeader(r,m,o);this.renderDays(r,m,o);};
M.renderHeader=function(r,m,o){var h=m._getLocaleData();var F=m._getFirstDayOfWeek();this.renderHeaderLine(r,m,h,o);r.openStart("div");r.accessibilityState(null,{role:"row"});r.style("overflow","hidden");r.openEnd();this.renderDayNames(r,m,h,F,7,true,undefined);r.close("div");};
M.renderHeaderLine=function(r,m,o,h){C._checkCalendarDate(h);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var j=o.getMonthsStandAlone("wide",s);r.openStart("div",i+"-Head");r.class("sapUiCalHeadText");r.openEnd();r.text(j[h.getMonth()]);r.close("div");}};
M.renderDayNames=function(r,m,o,s,h,j,w){var F=m._getFirstDayOfWeek();var k=m.getId();var n="";var p=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated",p);}else{W=o.getDaysStandAlone("narrow",p);}var q=o.getDaysStandAlone("wide",p);if(m.getShowWeekNumbers()&&p!==g.Islamic){this.renderDummyCell(r,"sapUiCalWH",true,"columnheader");}for(var i=0;i<h;i++){if(j){n=k+"-WH"+((i+F)%7);}else{n=k+"-WH"+i;}r.openStart("div",n);r.class("sapUiCalWH");if(i===0){r.class("sapUiCalFirstWDay");}if(w){r.style("width",w);}r.accessibilityState(null,{role:"columnheader",label:q[(i+s)%7]});r.openEnd();r.text(W[(i+s)%7]);r.close("div");}};
M.renderDays=function(r,m,o){var w,h,j,H,i,t,s;C._checkCalendarDate(o);if(!o){o=m._getFocusedDate();}t=o.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}H=this.getDayHelper(m,o);h=m._getVisibleDays(o,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==g.Islamic&&s;j=h.length;for(i=0;i<j;i++){if(i%7===0){r.openStart("div");r.attr("role","row");r.openEnd();if(w){this._renderWeekNumber(r,h[i],H,m);}}this.renderDay(r,m,h[i],H,true,w,-1);if(i%7===6||i===j-1){r.close("div");}}if(j===28){this.renderDummyCell(r,"sapUiCalItem",false,"");}};
M.renderDummyCell=function(r,s,v,R){r.openStart("div");r.class(s);r.class("sapUiCalDummy");r.style("visibility",v?"visible":"hidden");r.attr("role",R);r.attr("aria-label",sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_WEEK"));r.openEnd();r.close('div');};
M.getDayHelper=function(m,o){var h,s,i=m._getLocaleData(),H={sLocale:m._getLocale(),oLocaleData:i,iMonth:o.getMonth(),iYear:o.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:i.getWeekendStart(),iWeekendEnd:i.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:i.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sPrimaryCalendarType:m.getPrimaryCalendarType(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){h=sap.ui.getCore().byId(s);if(h){if(!(h instanceof b)){throw new Error(h+" is not an sap.ui.unified.CalendarLegend. "+m);}H.oLegend=h;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return H;};
M.renderDay=function(r,m,o,h,O,w,n,W,j){C._checkCalendarDate(o);var s=new a(o,h.sSecondaryCalendarType),A={role:m._getAriaRole(),selected:false,label:"",describedby:""},B=o._bBeforeFirstYear,k="",p=h.oLegend,N;var y=m._oFormatYyyymmdd.format(o.toUTCJSDate(),true);var q=o.getDay();var S=m._checkDateSelected(o);var t=m._getDateTypes(o);var E=m._checkDateEnabled(o);var i=0;var u=m._isSpecialDateMarkerEnabled(o);if(B){E=false;}r.openStart("div",h.sId+"-"+y);r.class("sapUiCalItem");r.class("sapUiCalWDay"+q);if(W){r.style("width",W);}if(q===h.iFirstDayOfWeek){r.class("sapUiCalFirstWDay");}if(O&&h.iMonth!==o.getMonth()){r.class("sapUiCalItemOtherMonth");A["disabled"]=true;}if(o.isSame(h.oToday)){r.class("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.class("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S===2){r.class("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S===3){r.class("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S===4){r.class("sapUiCalItemSelBetween");}else if(S===5){r.class("sapUiCalItemSelStart");r.class("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(u){t.forEach(function(v){if(v.type!==f.None){if(v.type===f.NonWorking){r.class("sapUiCalItemWeekEnd");N=this._addNonWorkingDayText(A);return;}r.class("sapUiCalItem"+v.type);k=v.type;if(v.tooltip){r.attr('title',v.tooltip);}}}.bind(this));}if(!N){if(h.aNonWorkingDays){h.aNonWorkingDays.forEach(function(v){if(o.getDay()===v){this._addNonWorkingDayText(A);}}.bind(this));}else if(o.getDay()===h.iWeekendStart||o.getDay()===h.iWeekendEnd){this._addNonWorkingDayText(A);}}if(((m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval")||(m.getMetadata().getName()==="sap.ui.unified.calendar.OneMonthDatesRow"))&&m.getStartDate()&&o.getMonth()!==m.getStartDate().getMonth()){r.class("sapUiCalItemOtherMonth");}if(!E){r.class("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(q===h.aNonWorkingDays[i]){r.class("sapUiCalItemWeekEnd");break;}}}else if((q>=h.iWeekendStart&&q<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(q>=h.iWeekendStart||q<=h.iWeekendEnd))){r.class("sapUiCalItemWeekEnd");}r.attr("tabindex","-1");r.attr("data-sap-day",y);if(j){A["label"]=A["label"]+h.aWeekDaysWide[q]+" ";}A["label"]=A["label"]+h.oFormatLong.format(o.toUTCJSDate(),true);if(k!==""){c.addCalendarTypeAccInfo(A,k,p);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.accessibilityState(null,A);r.openEnd();if(t[0]&&u){r.openStart("div");r.class("sapUiCalSpecialDate");if(t[0].color){r.style("background-color",t[0].color);}r.openEnd();r.close("div");}r.openStart("span");r.class("sapUiCalItemText");if(t[0]&&t[0].color){r.class("sapUiCalItemTextCustomColor");}r.openEnd();if(!B){r.text(o.getDate());}r.close("span");if(j){r.openStart("span");r.class("sapUiCalDayName");r.openEnd();r.text(h.aWeekDays[q]);r.close("span");}if(h.sSecondaryCalendarType){r.openStart("span");r.class("sapUiCalItemSecText");r.openEnd();r.text(s.getDate());r.close("span");}r.close("div");};
M._addNonWorkingDayText=function(A){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("LEGEND_NON_WORKING_DAY")+" ";A["label"]+=t;return t;};
M._renderWeekNumber=function(r,o,h,m){var w=m._calculateWeekNumber(o);var i=h.sId+"-WNum-"+w;r.openStart("div",i);r.class("sapUiCalWeekNum");r.accessibilityState(null,{role:"rowheader",labelledby:I.getStaticId("sap.ui.unified","CALENDAR_WEEK")+" "+i});r.openEnd();r.text(w);r.close("div");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthsRow',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./MonthsRowRenderer","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(C,L,I,a,c,l,D,d,e,M,f,q,g){"use strict";var h=d.CalendarType;
var j=C.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
j.prototype.init=function(){this._oFormatYyyymm=D.getInstance({pattern:"yyyyMMdd",calendarType:h.Gregorian});this._oFormatLong=D.getInstance({pattern:"MMMM y"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
j.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonths){clearTimeout(this._sInvalidateMonths);}};
j.prototype.onAfterRendering=function(){_.call(this);u.call(this);};
j.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!f(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){w.call(this,true);s.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;t.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}}};
j.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
j.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("selectedDates");return b;};
j.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
j.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("specialDates");return b;};
j.prototype.setDate=function(b){if(b){var i=c.fromLocalJSDate(b);this._oDate=i;p.call(this,i,false);}return this.setProperty("date",b);};
j.prototype._getDate=function(){if(!this._oDate){this._oDate=new c();}return this._oDate;};
j.prototype.setStartDate=function(S){a._checkJSDateObject(S);var b,y,O;y=S.getFullYear();a._checkYearInValidRange(y);b=c.fromLocalJSDate(S);this.setProperty("startDate",S,true);this._oStartDate=b;this._oStartDate.setDate(1);if(this.getDomRef()){O=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.setDate(O);}}return this;};
j.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=new c();this._oStartDate.setDate(1);}return this._oStartDate;};
j.prototype.displayDate=function(b){p.call(this,c.fromLocalJSDate(b),true);return this;};
j.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
j.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var b=this._getLocale();var i=new e(b);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};
j.prototype._getFormatLong=function(){var b=this._getLocale();if(this._oFormatLong.oLocale.toString()!=b){var i=new e(b);this._oFormatLong=D.getInstance({style:"long"},i);}return this._oFormatLong;};
j.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
j.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
j.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
j.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
j.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
j.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
j.prototype._setLegendControlOrigin=function(b){this._oLegendControlOrigin=b;};
j.prototype.getLegend=function(){var P=this.getParent();if(this._oLegendControlOrigin){return this._oLegendControlOrigin.getLegend();}if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
j.prototype._setAriaRole=function(R){this._ariaRole=R;return this;};
j.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};
j.prototype._checkDateSelected=function(b){var R,S,E,T,x=0,y=0,z=0,i,A,B;a._checkCalendarDate(b);A=this.getSelectedDates();B=new c(b);B.setDate(1);T=B.toUTCJSDate().getTime();for(i=0;i<A.length;i++){R=A[i];S=R.getStartDate();x=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);x=S.toUTCJSDate().getTime();}E=R.getEndDate();y=0;if(E){E=c.fromLocalJSDate(E);E.setDate(1);y=E.toUTCJSDate().getTime();}if(T==x&&!E){z=1;break;}else if(T==x&&E){z=2;if(E&&T==y){z=5;}break;}else if(E&&T==y){z=3;break;}else if(E&&T>x&&T<y){z=4;break;}if(this.getSingleSelection()){break;}}return z;};
j.prototype._getDateType=function(b){a._checkCalendarDate(b);var T,R,i,S,x=0,E,y=0,z,A=this.getSpecialDates(),B=new c(b);B.setDate(1);z=B.toUTCJSDate().getTime();for(i=0;i<A.length;i++){R=A[i];S=R.getStartDate();x=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);x=S.toUTCJSDate().getTime();}E=R.getEndDate();y=0;if(E){E=c.fromLocalJSDate(E);E.setDate(a._daysInMonth(E));y=E.toUTCJSDate().getTime();}if((z==x&&!E)||(z>=x&&z<=y)){T={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return T;};
j.prototype._checkMonthEnabled=function(b){a._checkCalendarDate(b);var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(a._isOutside(b,P._oMinDate,P._oMaxDate)){return false;}}return true;};
j.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){w.call(this,true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){var O=this._getDate();var F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);if(!F.isSame(O)){this.setDate(F.toLocalJSDate());s.call(this,F,true);this._bMoveChange=true;}}};
j.prototype.onmouseup=function(E){if(this._bMouseMove){w.call(this,true);var F=this._getDate();var b=this._oItemNavigation.getItemDomRefs();for(var i=0;i<b.length;i++){var $=q(b[i]);if($.attr("data-sap-month")==this._oFormatYyyymm.format(F.toUTCJSDate(),true)){$.trigger("focus");break;}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);}s.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;t.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}};
j.prototype.onsapselect=function(E){var S=s.call(this,this._getDate());if(S){t.call(this);}E.stopPropagation();E.preventDefault();};
j.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
j.prototype.onsappageupmodifiers=function(E){var F=new c(this._getDate());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{var i=this.getMonths();if(i<=12){F.setYear(y-1);}else{F.setMonth(F.getMonth()-i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
j.prototype.onsappagedownmodifiers=function(E){var F=new c(this._getDate());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{var i=this.getMonths();if(i<=12){F.setYear(y+1);}else{F.setMonth(F.getMonth()+i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
j.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var b=this._getLocaleData();var x=b.getMonthsStandAlone("wide");var y=this.$("months").children();var z=this._getStartDate().getMonth();for(var i=0;i<y.length;i++){var $=q(q(y[i]).children(".sapUiCalItemText"));$.text(x[(i+z)%12]);}u.call(this);};
j.prototype.checkDateFocusable=function(b){a._checkJSDateObject(b);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new c(S);E.setDate(1);E.setMonth(E.getMonth()+this.getMonths());var i=c.fromLocalJSDate(b);return i.isSameOrAfter(S)&&i.isBefore(E);};
j.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
function _(){var b=this._getDate();var y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var x=0;var R=this.$("months").get(0);var z=this.$("months").children(".sapUiCalItem");for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-month")===y){x=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,k,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,m,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,n,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(z);this._oItemNavigation.setFocusedIndex(x);this._oItemNavigation.setPageSize(z.length);}
function k(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}var O=this._getDate();var F=new c(O);var x=this._oItemNavigation.getItemDomRefs();var $=q(x[i]);F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);this.setDate(F.toLocalJSDate());this.fireFocus({date:F.toLocalJSDate(),notVisible:false});if(E.type=="mousedown"){o.call(this,E,F,i);}}
function m(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();o.call(this,E,F,i);}}
function n(b){var E=b.getParameter("event");var i=this.getMonths();var O=this._getDate();var F=new c(O);if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setMonth(F.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":F.setMonth(F.getMonth()-1);break;case"sappagedown":F.setMonth(F.getMonth()+i);break;case"sappageup":F.setMonth(F.getMonth()-i);break;default:break;}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});}}
function o(E,F,i){if(E.button){return;}var S=s.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){w.call(this,true);this._bMoveChange=false;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){v.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function p(b,N){a._checkCalendarDate(b);var y=b.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!b.isSame(c.fromLocalJSDate(this.getDate()))){var i=new c(b);i.setDate(1);F=this.checkDateFocusable(b.toLocalJSDate());if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",b.toLocalJSDate());this._oDate=i;}if(this.getDomRef()){if(F){r.call(this,this._oDate,N);}}}
function r(b,N){var y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var x=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-month")==y){if(document.activeElement!=x[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function s(b,x){if(!this._checkMonthEnabled(b)){return false;}var S=this.getSelectedDates();var y;var i=0;var P=this.getParent();var A=this;var z;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){y=S[0];z=y.getStartDate();if(z){z=c.fromLocalJSDate(z);z.setDate(1);}}else{y=new g();A.addAggregation("selectedDates",y);}if(this.getIntervalSelection()&&(!y.getEndDate()||x)&&z){var E;if(b.isBefore(z)){E=z;z=b;if(!x){y.setProperty("startDate",z.toLocalJSDate());y.setProperty("endDate",E.toLocalJSDate());}}else if(b.isSameOrAfter(z)){E=b;if(!x){y.setProperty("endDate",E.toLocalJSDate());}}}else{y.setProperty("startDate",b.toLocalJSDate());y.setProperty("endDate",undefined);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var B=this._checkDateSelected(b);if(B>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z){z=c.fromLocalJSDate(z);z.setDate(1);if(b.isSame(z)){A.removeAggregation("selectedDates",i);break;}}}}else{y=new g({startDate:b.toLocalJSDate()});A.addAggregation("selectedDates",y);}}}return true;}
function t(){if(this._bMouseMove){w.call(this,true);}this.fireSelect();}
function u(){if(!this._bNamesLengthChecked){var i=0;var x=this.$("months").children();var T=false;var y=this.getMonths();var B=Math.ceil(12/y);var z=0;var A=this._getLocaleData();var E=A.getMonthsStandAlone("wide");var $;for(var b=0;b<B;b++){if(y<12){for(i=0;i<x.length;i++){$=q(q(x[i]).children(".sapUiCalItemText"));$.text(E[(i+z)%12]);}z=z+y;if(z>11){z=11;}}for(i=0;i<x.length;i++){var F=x[i];if(Math.abs(F.clientWidth-F.scrollWidth)>1){T=true;break;}}if(T){break;}}if(y<12){z=this._getStartDate().getMonth();for(i=0;i<x.length;i++){$=q(q(x[i]).children(".sapUiCalItemText"));$.text(E[(i+z)%12]);}}if(T){this._bLongMonth=false;var G=A.getMonthsStandAlone("abbreviated");z=this._getStartDate().getMonth();for(i=0;i<x.length;i++){$=q(q(x[i]).children(".sapUiCalItemText"));$.text(G[(i+z)%12]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function v(){q(window.document).on('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function w(){q(window.document).off('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return j;});
sap.ui.predefine('sap/ui/unified/calendar/MonthsRowRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library',"sap/base/Log"],function(C,a,b,l,L){"use strict";var c=l.CalendarDayType;var M={apiVersion:2};
M.render=function(r,m){var d=m._getStartDate();var t=m.getTooltip_AsString();var i=m.getId();var A={value:i+"-Descr",append:true};r.openStart("div",m);r.class("sapUiCalMonthsRow");r.class("sapUiCalRow");if(t){r.attr("title",t);}r.accessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.openEnd();r.openStart("span",i+"-Descr");r.style("display","none");r.openEnd();r.text(m._rb.getText("CALENDAR_DIALOG"));r.close("span");if(m.getIntervalSelection()){r.openStart("span",i+"-Start");r.style("display","none");r.openEnd();r.text(m._rb.getText("CALENDAR_START_MONTH"));r.close("span");r.openStart("span",i+"-End");r.style("display","none");r.openEnd();r.text(m._rb.getText("CALENDAR_END_MONTH"));r.close("span");}this.renderRow(r,m,d);r.close("div");};
M.renderRow=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.openStart("div",i+"-months");r.class("sapUiCalItems");r.attr("role","row");r.openEnd();this.renderMonths(r,m,d);r.close("div");};
M.renderHeader=function(r,m,d){C._checkCalendarDate(d);if(m._getShowHeader()){var o=m._getLocaleData();var i=m.getId();r.openStart("div",i+"-Head");r.openEnd();this.renderHeaderLine(r,m,o,d);r.close("div");}};
M.renderHeaderLine=function(r,m,o,d){C._checkCalendarDate(d);var I=m.getId();var e=m.getMonths();var f=new a(d);var w="";var y=0;var Y=[];var i=0;for(i=0;i<e;i++){y=f.getYear();if(Y.length>0&&Y[Y.length-1].iYear==y){Y[Y.length-1].iMonths++;}else{Y.push({iYear:y,iMonths:1});}f.setMonth(f.getMonth()+1);}for(i=0;i<Y.length;i++){var g=Y[i];w=(100/e*g.iMonths)+"%";r.openStart("div",I+"-Head"+i);r.class("sapUiCalHeadText");r.style("width",w);r.openEnd();r.text(g.iYear);r.close("div");}};
M.renderMonths=function(r,m,d){var h=this.getHelper(m,d);var e=m.getMonths();var w=(100/e)+"%";var o=new a(d);o.setDate(1);for(var i=0;i<e;i++){this.renderMonth(r,m,o,h,w);o.setMonth(o.getMonth()+1);}};
M.getHelper=function(m,d){C._checkCalendarDate(d);var h={};h.sLocale=m._getLocale();h.oLocaleData=m._getLocaleData();h.oToday=new a();h.sCurrentMonth=m._rb.getText("CALENDAR_CURRENT_MONTH");h.sId=m.getId();h.oFormatLong=m._getFormatLong();if(m._bLongMonth||!m._bNamesLengthChecked){h.aMonthNames=h.oLocaleData.getMonthsStandAlone("wide");}else{h.aMonthNames=h.oLocaleData.getMonthsStandAlone("abbreviated");h.aMonthNamesWide=h.oLocaleData.getMonthsStandAlone("wide");}var s=m.getLegend();if(s){var o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};
M.renderMonth=function(r,m,d,h,w){C._checkCalendarDate(d);var A={role:m._getAriaRole(),selected:false,label:"",describedby:""};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=h.aMonthNamesWide[d.getMonth()];}var y=m._oFormatYyyymm.format(d.toUTCJSDate(),true);var s=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkMonthEnabled(d);r.openStart("div",h.sId+"-"+y);r.class("sapUiCalItem");if(w){r.style("width",w);}if(C._isSameMonthAndYear(d,h.oToday)){r.class("sapUiCalItemNow");A["label"]=h.sCurrentMonth+" ";}if(s>0){r.class("sapUiCalItemSel");A["selected"]=true;}if(s==2){r.class("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.class("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(s==4){r.class("sapUiCalItemSelBetween");}else if(s==5){r.class("sapUiCalItemSelStart");r.class("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=c.None){r.class("sapUiCalItem"+t.type);if(t.tooltip){r.attr('title',t.tooltip);}}if(!e){r.class("sapUiCalItemDsbl");A["disabled"]=true;}r.attr("tabindex","-1");r.attr("data-sap-month",y);A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=c.None){b.addCalendarTypeAccInfo(A,t.type,h.oLegend);}r.accessibilityState(null,A);r.openEnd();r.openStart("span");r.class("sapUiCalItemText");r.openEnd();r.text(h.aMonthNames[d.getMonth()]);r.close("span");r.close("div");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRow',['sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library',"./OneMonthDatesRowRenderer"],function(D,C,a,l,O){"use strict";
var b=D.extend("sap.ui.unified.calendar.OneMonthDatesRow",{metadata:{library:"sap.ui.unified"}});
b.apiVersion=2;
b.prototype.init=function(){D.prototype.init.apply(this,arguments);this.iMode=2;};
b.prototype.setMode=function(m){var s=this.getSelectedDates(),S,c=this.iMode!==m;this.iMode=m;if(c&&s.length){if(this.iMode<2){S=this.getStartDate();}s[0].setProperty('startDate',S);}this.iMode<2?this._bAlwaysShowSpecialDates=false:this._bAlwaysShowSpecialDates=true;return this;};
b.prototype.getMode=function(){return this.iMode;};
b.prototype.selectDate=function(d){if(this.iMode<2&&this.getSelectedDates().length){this.getSelectedDates()[0].setStartDate(d);}return this;};
b.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.setDate.apply(this,arguments);return this;};
b.prototype.getDays=function(){if(this.iMode===2){return 31;}else{return C._daysInMonth(a.fromLocalJSDate(this.getStartDate()));}};
b.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.displayDate.apply(this,arguments);return this;};
b.prototype.onsaphome=function(e){var c=a.fromLocalJSDate(this.getStartDate());i(e);this.setDate(c.toLocalJSDate());this._focusDate(c);this.fireFocus({date:c.toLocalJSDate(),otherMonth:false});};
b.prototype.onsapend=function(e){var s=this.getStartDate(),L;L=a.fromLocalJSDate(s);L.setDate(C._daysInMonth(L));i(e);this.setDate(L.toLocalJSDate());this._focusDate(L);this.fireFocus({date:L.toLocalJSDate(),otherMonth:false});};
function i(e){e.stopPropagation();e.preventDefault();e.stopImmediatePropagation(true);}
return b;});
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRowRenderer',['sap/ui/core/Renderer','./MonthRenderer','./DatesRowRenderer'],function(R,M,D){"use strict";var O=R.extend(D);O.apiVersion=2;["getClass","renderMonth","renderDays","renderHeader"].forEach(function(h){O[h]=function(r,d){if(d.iMode<2){return M[h].apply(M,arguments);}else{if(h==="getClass"){var c=["sapUiCalDatesRow","sapUiCalRow","sapUiCalOneMonthDatesRow"];if(!d.getShowDayNamesLine()){c.push("sapUiCalNoNameLine");}return c;}return D[h].apply(D,arguments);}};});return O;},true);
sap.ui.predefine('sap/ui/unified/calendar/TimesRow',['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/thirdparty/jquery","sap/ui/unified/DateRange"],function(C,L,I,a,U,l,D,c,b,T,d,e,q,f){"use strict";var g=c.CalendarType;
var h=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
h.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:g.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
h.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
h.prototype.onAfterRendering=function(){_.call(this);};
h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!d(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){u.call(this,true);r.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;s.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}}};
h.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
h.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
h.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
h.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
h.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};
h.prototype.setDate=function(i){o.call(this,i,false);return this.setProperty("date",i);};
h.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};
h.prototype.setStartDate=function(S){a._checkJSDateObject(S);var y=S.getFullYear();a._checkYearInValidRange(y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};
h.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};
h.prototype.displayDate=function(i){o.call(this,i,true);return this;};
h.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
h.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var w=new b(i);this._oLocaleData=L.getInstance(w);}return this._oLocaleData;};
h.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var w=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},w);}return this._oFormatLong;};
h.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var w=new b(i);var x=this.getIntervalMinutes();var y=this._getLocaleData();var P;var z=y.getTimePattern("short");this._oFormatTimeAmPm=undefined;if(x%60==0){P=v(z);if(z.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},w);}}else{P=z;P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},w);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},w);}return this._oFormatTime;};
h.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var w=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},w);}return this._oFormatDate;};
h.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
h.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
h.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
h.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
h.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
h.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};
h.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype._setLegendControlOrigin=function(i){this._oLegendControlOrigin=i;};
h.prototype.getLegend=function(){var P=this.getParent();if(this._oLegendControlOrigin){return this._oLegendControlOrigin.getLegend();}if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
h.prototype._checkDateSelected=function(w){if(!(w instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var x=this.getSelectedDates();var M=new U(w.getTime());M=this._getIntervalStart(M);var y=M.getTime();for(var i=0;i<x.length;i++){var R=x[i];var z=R.getStartDate();var A=0;if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);A=z.getTime();}var E=R.getEndDate();var B=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);B=E.getTime();}if(y==A&&!E){S=1;break;}else if(y==A&&E){S=2;if(E&&y==B){S=5;}break;}else if(E&&y==B){S=3;break;}else if(E&&y>A&&y<B){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
h.prototype._getDateType=function(w){if(!(w instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var x;var S=this.getSpecialDates();var M=new U(w.getTime());M=this._getIntervalStart(M);var y=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var z=R.getStartDate();var A=0;if(z){z=a._createUniversalUTCDate(z,undefined,true);z=this._getIntervalStart(z);A=z.getTime();}var E=R.getEndDate();var B=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);E.setUTCMinutes(E.getUTCMinutes()+this.getIntervalMinutes()-1);B=E.getTime();}else if(z.getUTCHours()==0&&z.getUTCMinutes()==0&&z.getUTCSeconds()==0&&z.getUTCMilliseconds()==0){E=new U(z.getTime());E.setUTCDate(E.getUTCDate()+1);B=E.getTime();}if((y==A&&!E)||(y>=A&&y<=B)){x={type:R.getType(),tooltip:R.getTooltip_AsString(),color:R.getColor()};break;}}return x;};
h.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var w=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(w<P._oMinDate.getTime()||w>P._oMaxDate.getTime()){return false;}}return true;};
h.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){u.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._oUTCDate=F;r.call(this,F,true);this._bMoveChange=true;}}};
h.prototype.onmouseup=function(E){if(this._bMouseMove){u.call(this,true);var F=this._getDate();var w=this._oItemNavigation.getItemDomRefs();for(var i=0;i<w.length;i++){var $=q(w[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.trigger("focus");break;}}if(this._bMoveChange){var x=q(E.target);if(x.hasClass("sapUiCalItemText")){x=x.parent();}if(x.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(x.attr("data-sap-time"),true).getTime());}r.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;s.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;s.call(this);}};
h.prototype.onsapselect=function(E){var S=r.call(this,this._getDate());if(S){s.call(this);}E.stopPropagation();E.preventDefault();};
h.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
h.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
h.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
h.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var w=a._createUniversalUTCDate(i,undefined,true);if(w.getTime()>=S.getTime()&&w.getTime()<E.getTime()){return true;}else{return false;}};
h.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
h.prototype._getIntervalStart=function(i){var w=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=w){S.setUTCMinutes(S.getUTCMinutes()+M);}var x=new U(S.getTime());x.setUTCMinutes(x.getUTCMinutes()-M);return x;};
h.prototype._setAriaRole=function(R){this._ariaRole=R;return this;};
h.prototype._getAriaRole=function(){return this._ariaRole?this._ariaRole:"gridcell";};
h.prototype._updateItemARIASelected=function($,S){var R=this._getAriaRole();if(R==="gridcell"){$.attr("aria-selected",S);}return this;};
function _(){var w=this._getDate();var y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);var x=0;var R=this.$("times").get(0);var z=this.$("times").children(".sapUiCalItem");for(var i=0;i<z.length;i++){var $=q(z[i]);if($.attr("data-sap-time")===y){x=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,j,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,k,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,m,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(z);this._oItemNavigation.setFocusedIndex(x);this._oItemNavigation.setPageSize(z.length);}
function j(i){var w=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var x=this._oItemNavigation.getItemDomRefs();var $=q(x[w]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._oUTCDate=F;this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){n.call(this,E,F,w);}}
function k(i){var w=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();n.call(this,E,F,w);}}
function m(i){var E=i.getParameter("event");var w=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*w);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*w);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}
function n(E,F,i){if(E.button){return;}var S=r.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){u.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){t.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function o(i,N){a._checkJSDateObject(i);var y=i.getFullYear();a._checkYearInValidRange(y);var F=true;if(!e(this.getDate(),i)){var w=a._createUniversalUTCDate(i,undefined,true);w=this._getIntervalStart(w);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i);this._oUTCDate=w;}if(this.getDomRef()){if(F){p.call(this,this._oUTCDate,N);}else{this.setDate(i);}}}
function p(w,N){var y=this._oFormatYyyyMMddHHmm.format(w.getJSDate(),true);var x=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<x.length;i++){$=q(x[i]);if($.attr("data-sap-time")==y){if(document.activeElement!=x[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function r(w,M){if(!this._checkTimeEnabled(w)){return false;}var S=this.getSelectedDates();var x;var i=0;var P=this.getParent();var A=this;var y;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){x=S[0];y=x.getStartDate();if(y){y=a._createUniversalUTCDate(y,undefined,true);y=this._getIntervalStart(y);}}else{x=new f();A.addAggregation("selectedDates",x);}if(this.getIntervalSelection()&&(!x.getEndDate()||M)&&y){var E;if(w.getTime()<y.getTime()){E=y;y=w;if(!M){x.setProperty("startDate",a._createLocalDate(new Date(y.getTime()),true));x.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true));}}else if(w.getTime()>=y.getTime()){E=w;if(!M){x.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true));}}}else{x.setProperty("startDate",a._createLocalDate(new Date(w.getTime()),true));x.setProperty("endDate",undefined);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var z=this._checkDateSelected(w);if(z>0){for(i=0;i<S.length;i++){y=S[i].getStartDate();if(y){y=a._createUniversalUTCDate(y,undefined,true);y=this._getIntervalStart(y);if(w.getTime()==y.getTime()){A.removeAggregation("selectedDates",i);break;}}}}else{x=new f({startDate:a._createLocalDate(new Date(w.getTime()),true)});A.addAggregation("selectedDates",x);}}}return true;}
function s(){if(this._bMouseMove){u.call(this,true);}this.fireSelect();}
function t(){q(window.document).on('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function u(){q(window.document).off('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
function v(i){var P;if(i.toUpperCase().indexOf("K")>-1){P=i.indexOf("k")>-1?"k":"K";}else{P=i.indexOf("h")>-1?"h":"H";}return P;}
return h;});
sap.ui.predefine('sap/ui/unified/calendar/TimesRowRenderer',['sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarLegendRenderer','sap/ui/unified/library',"sap/base/Log"],function(C,U,a,l,L){"use strict";var b=l.CalendarDayType;var T={apiVersion:2};
T.render=function(r,t){var d=t._getStartDate();var s=t.getTooltip_AsString();var i=t.getId();var A={value:i+"-Descr",append:true};r.openStart("div",t);r.class("sapUiCalTimesRow");r.class("sapUiCalRow");if(s){r.attr("title",s);}if(t._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.accessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:A});r.openEnd();r.openStart("span",i+"-Descr");r.style("display","none");r.openEnd();r.text(t._rb.getText("CALENDAR_DIALOG"));r.close("span");if(t.getIntervalSelection()){r.openStart("span",i+"-Start");r.style("display","none");r.openEnd();r.text(t._rb.getText("CALENDAR_START_TIME"));r.close("span");r.openStart("span",i+"-End");r.style("display","none");r.openEnd();r.text(t._rb.getText("CALENDAR_END_TIME"));r.close("span");}this.renderRow(r,t,d);r.close("div");};
T.renderRow=function(r,t,d){var i=t.getId();this.renderHeader(r,t,d);r.openStart("div",i+"-times");r.class("sapUiCalItems");r.attr("role","row");r.openEnd();this.renderTimes(r,t,d);r.close("div");};
T.renderHeader=function(r,t,d){if(t._getShowHeader()){var o=t._getLocaleData();var i=t.getId();r.openStart("div",i+"-Head");r.openEnd();this.renderHeaderLine(r,t,o,d);r.close("div");}};
T.renderHeaderLine=function(r,t,o,d){var f=t._getFormatDate();var I=t.getId();var c=t.getItems();var e=t._getIntervalStart(d);var m=t.getIntervalMinutes();var w="";var D=0;var g=[];var i=0;for(i=0;i<c;i++){D=f.format(e,true);if(g.length>0&&g[g.length-1].sDay==D){g[g.length-1].iItems++;}else{g.push({sDay:D,iItems:1});}e.setUTCMinutes(e.getUTCMinutes()+m);}for(i=0;i<g.length;i++){var h=g[i];w=(100/c*h.iItems)+"%";r.openStart("div",I+"-Head"+i);r.class("sapUiCalHeadText");r.style("width",w);r.openEnd();r.text(h.sDay);r.close("div");}};
T.renderTimes=function(r,t,d){var h=this.getHelper(t,d);var I=t.getItems();var w=(100/I)+"%";var o=t._getIntervalStart(d);var O="";var A="";for(var i=0;i<I;i++){if(h.oFormatTimeAmPm){A=h.oFormatTimeAmPm.format(o,true);if(O==A){A="";}else{O=A;}}this.renderTime(r,t,o,h,w,A);o.setUTCMinutes(o.getUTCMinutes()+h.iMinutes);}};
T.getHelper=function(t,d){var h={};h.sLocale=t._getLocale();h.oLocaleData=t._getLocaleData();h.oNow=C._createUniversalUTCDate(new Date(),undefined,true);h.sCurrentTime=t._rb.getText("CALENDAR_CURRENT_TIME");h.sId=t.getId();h.oFormatLong=t._getFormatLong();h.oFormatTime=t._getFormatTime();h.oFormatTimeAmPm=t._oFormatTimeAmPm;h.iMinutes=t.getIntervalMinutes();var s=t.getLegend();if(s){var o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof sap.ui.unified.CalendarLegend)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+t);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",t);}}return h;};
T.renderTime=function(r,t,d,h,w,A){var R=t._getAriaRole();var m={role:R,selected:R!=="gridcell"?null:false,label:"",describedby:""};var y=t._oFormatYyyyMMddHHmm.format(d.getJSDate(),true);var s=t._checkDateSelected(d);var o=t._getDateType(d);var e=t._checkTimeEnabled(d);r.openStart("div",h.sId+"-"+y);r.class("sapUiCalItem");if(w){r.style("width",w);}var n=new U(d.getTime());n.setUTCMinutes(n.getUTCMinutes()+h.iMinutes);if(d.getTime()<=h.oNow.getTime()&&n.getTime()>h.oNow.getTime()){r.class("sapUiCalItemNow");m["label"]=h.sCurrentTime+" ";}if(s>0){r.class("sapUiCalItemSel");if(R==="gridcell"){m["selected"]=true;}}if(s==2){r.class("sapUiCalItemSelStart");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.class("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-End";}else if(s==4){r.class("sapUiCalItemSelBetween");}else if(s==5){r.class("sapUiCalItemSelStart");r.class("sapUiCalItemSelEnd");m["describedby"]=m["describedby"]+" "+h.sId+"-Start";m["describedby"]=m["describedby"]+" "+h.sId+"-End";}if(o&&o.type!=b.None){r.class("sapUiCalItem"+o.type);if(o.tooltip){r.attr('title',o.tooltip);}}if(!e){r.class("sapUiCalItemDsbl");m["disabled"]=true;}r.attr("tabindex","-1");r.attr("data-sap-time",y);m["label"]=m["label"]+h.oFormatLong.format(d,true);if(o&&o.type!=b.None){a.addCalendarTypeAccInfo(m,o.type,h.oLegend);}r.accessibilityState(null,m);r.openEnd();if(o&&o.type!=b.None){r.openStart("div");r.class("sapUiCalSpecialDate");if(o.color){r.style("background-color",o.color);}r.openEnd();r.close("div");}r.openStart("span");r.class("sapUiCalItemText");r.openEnd();r.text(h.oFormatTime.format(d,true));if(A){r.openStart("span");r.class("sapUiCalItemTextAmPm");r.openEnd();r.text(A);r.close("span");}r.close("span");r.close("div");};
return T;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearPicker',['sap/ui/core/Control','sap/ui/Device','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate',"sap/ui/unified/DateRange",'sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library',"./YearPickerRenderer","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(C,D,I,a,b,U,c,l,d,e,Y,K,q){"use strict";var f=e.CalendarType;
var g=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000,deprecated:true},years:{type:"int",group:"Appearance",defaultValue:20},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},_middleDate:{type:"object",group:"Data",visibility:"hidden"}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},events:{select:{},pageChange:{}}}});
g.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=d.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=d.getInstance({pattern:"yyyyMMdd",calendarType:f.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};
g.prototype.onAfterRendering=function(){_.call(this);this.focus();};
g.prototype.exit=function(){if(this._aMPSelectedDates&&this._aMPSelectedDates.length){this._aMPSelectedDates.forEach(function(o){o.destroy();});this._aMPSelectedDates=undefined;}};
g.prototype.getFocusDomRef=function(){return this.getDomRef()&&this._oItemNavigation.getItemDomRefs()[this._iSelectedIndex];};
g.prototype.setYear=function(y){this.setProperty("year",y);y=this.getProperty("year");var o=new b(y,0,1,this.getPrimaryCalendarType()),s=this._getSelectedDates()[0],i=this.getAggregation("selectedDates");if(!s||this.getIntervalSelection()){return this;}if(!this._oSelectedDatesControlOrigin){if(!i||!i.length){this.addAggregation("selectedDates",s);}!this.getIntervalSelection()&&s.setStartDate(o.toLocalJSDate());}this.setDate(o.toLocalJSDate());return this;};
g.prototype.setDate=function(o){var i,y,m,H;o&&a._checkJSDateObject(o);y=o.getFullYear();a._checkYearInValidRange(y);i=b.fromLocalJSDate(o,this.getPrimaryCalendarType());i.setMonth(0,1);this.setProperty("date",o);this.setProperty("year",i.getYear());this._oDate=i;m=this.getYears();H=Math.floor(m/2);this._iSelectedIndex=H;this.setProperty("_middleDate",i);return this;};
g.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};
g.prototype._setSelectedDatesControlOrigin=function(o){this._oSelectedDatesControlOrigin=o;};
g.prototype.getSelectedDates=function(){if(this._oSelectedDatesControlOrigin){return this._oSelectedDatesControlOrigin.getSelectedDates();}return this.getAggregation("selectedDates");};
g.prototype._getSelectedDates=function(){var s=this.getSelectedDates();if(s){return s;}else if(!this._aMPSelectedDates||!this._aMPSelectedDates.length){this._aMPSelectedDates=[new c()];this._aMPSelectedDates[0].setStartDate(this._getDate().toLocalJSDate());return this._aMPSelectedDates;}else{return this._aMPSelectedDates;}};
g.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=d.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0,1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};
g.prototype.nextPage=function(){this._updatePage(true,this._oItemNavigation.getFocusedIndex());return this;};
g.prototype.previousPage=function(){this._updatePage(false,this._oItemNavigation.getFocusedIndex());return this;};
g.prototype.onsapspace=function(E){E.preventDefault();};
g.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=this._selectYear(i);if(s){this.fireSelect();}};
g.prototype.onmouseover=function(E){var t=E.target,s=this._getSelectedDates()[0],S,F,y;if(!s){return;}if(s.getStartDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);}if(t.classList.contains("sapUiCalItem")){y=t.getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(S,F);}}};
g.prototype.onmousedown=function(E){this._oMousedownPosition={clientX:E.clientX,clientY:E.clientY};};
g.prototype.onmouseup=function(E){var t=E.target,s=this._getSelectedDates()[0],i,y,S,F,$=this._oItemNavigation.getItemDomRefs();if(this._bMousedownChange){this._bMousedownChange=false;if(this.getIntervalSelection()&&t.classList.contains("sapUiCalItem")&&s){y=t.getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);if(!F.isSame(S)&&!s.getEndDate()){i=$.index(t);this._selectYear.call(this,i);this._oItemNavigation.focusItem(i);}}this.fireSelect();}else if(D.support.touch&&this._isValueInThreshold(this._oMousedownPosition.clientX,E.clientX,10)&&this._isValueInThreshold(this._oMousedownPosition.clientY,E.clientY,10)){i=this._oItemNavigation.getFocusedIndex();if(!$[i].classList.contains("sapUiCalItemDsbl")){this._selectYear(i);this.fireSelect();}}};
g.prototype._markInterval=function(s,E){var m=this._oItemNavigation.getItemDomRefs(),F,y,i;if(s.isAfter(E)){E=[s,s=E][0];}for(i=0;i<m.length;++i){y=m[i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(this._bMousedownChange){if(F.isSame(s)||F.isSame(E)){q(m[i]).addClass("sapUiCalItemSel");}else{q(m[i]).removeClass("sapUiCalItemSel");}}if(a._isBetween(F,s,E)){q(m[i]).addClass("sapUiCalItemSelBetween");}else{q(m[i]).removeClass("sapUiCalItemSelBetween");}}};
g.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"));}return F;};
g.prototype._isValueInThreshold=function(r,v,t){var L=r-t,u=r+t;return v>=L&&v<=u;};
g.prototype._checkFirstDate=function(o){var y=this.getYears(),m=new b(this._oMaxDate,this.getPrimaryCalendarType());if(!m.isSame(a._maxDate(this.getPrimaryCalendarType()))){return o;}m.setYear(m.getYear()-y+1);if(o.isAfter(m)&&o.getYear()!=m.getYear()){o=new b(m,this.getPrimaryCalendarType());o.setMonth(0,1);}else if(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear()){o=new b(this._oMinDate,this.getPrimaryCalendarType());o.setMonth(0,1);}return o;};
g.prototype._checkDateEnabled=function(o){var E=true;if((o.isAfter(this._oMaxDate)&&o.getYear()!=this._oMaxDate.getYear())||(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear())){E=false;}return E;};
g.prototype._updatePage=function(F,s,i){var m=this._oItemNavigation.getItemDomRefs();var o=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(m[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var M=new b(this._oMaxDate,this.getPrimaryCalendarType());M.setYear(M.getYear()-y+1);if(o.isBefore(M)){o.setYear(o.getYear()+y);if(o.isAfter(M)){s=s+(o.getYear()-M.getYear());if(s>y-1){s=y-1;}o=new b(this._oMaxDate,this.getPrimaryCalendarType());this._oDate.setMonth(0,1);}}else{return;}}else{if(o.isAfter(this._oMinDate)){o.setYear(o.getYear()-y);if(o.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-o.getYear());if(s<0){s=0;}o=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}o.setYear(o.getYear()+Math.floor(y/2));this._iSelectedIndex=s;this.setProperty("_middleDate",o);if(i){this.firePageChange();}};
g.prototype._selectYear=function(m){var n=this._oItemNavigation.getItemDomRefs(),$=q(n[m]),y=$.attr("data-sap-year-start"),F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType()),s=this._getSelectedDates()[0],o=this.getAggregation("selectedDates"),S;if($.hasClass("sapUiCalItemDsbl")){return false;}if(!this._isSelectionInProgress()){var p=true;}this.setProperty("year",F.getYear(),p);this.setProperty("date",F.toLocalJSDate(),p);if(!s){return true;}if(!this._oSelectedDatesControlOrigin){if(!o||!o.length){this.addAggregation("selectedDates",s);}!this.getIntervalSelection()&&s.setStartDate(F.toLocalJSDate(),p);}if(this.getIntervalSelection()){if(!s.getStartDate()){s.setStartDate(F.toLocalJSDate(),p);}else if(!s.getEndDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());if(F.isBefore(S)){s.setEndDate(S.toLocalJSDate(),p);s.setStartDate(F.toLocalJSDate(),p);}else{s.setEndDate(F.toLocalJSDate(),p);}}else{s.setStartDate(F.toLocalJSDate(),p);s.setEndDate(undefined,p);}}if(p){for(var i=0;i<n.length;i++){$=q(n[i]);y=$.attr("data-sap-year-start");var r=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());var A=this._fnShouldApplySelection(r);var t=this._fnShouldApplySelectionBetween(r);if(A){$.addClass("sapUiCalItemSel");$.removeClass("sapUiCalItemSelBetween");$.attr("aria-selected","true");}if(t){$.addClass("sapUiCalItemSelBetween");$.attr("aria-selected","true");}if(!A&&!t){$.removeClass("sapUiCalItemSel");$.removeClass("sapUiCalItemSelBetween");$.attr("aria-selected","false");}}}return true;};
g.prototype._isSelectionInProgress=function(){var s=this._getSelectedDates()[0];if(!s){return false;}return this.getIntervalSelection()&&s.getStartDate()&&!s.getEndDate();};
function _(){var F=this.getDate()?b.fromLocalJSDate(this.getDate(),this.getPrimaryCalendarType()):this._getDate(),r=this.getDomRef(),m=this.$().find(".sapUiCalItem"),n,y,o,i;for(i=0;i<m.length;++i){y=m[i].getAttribute("data-sap-year-start");o=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(o.isSame(F)){n=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,h,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,j,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,k,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(m);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);if(a._isBetween(F,this._oMinDate,this._oMaxDate,true)){this._oItemNavigation.setFocusedIndex(n);}this._oItemNavigation.setPageSize(m.length);}
function h(o){var i=o.getParameter("index"),E=o.getParameter("event"),t=this._oItemNavigation.aItemDomRefs[i],s=this._getSelectedDates()[0],S,F,y;if(!E){return;}if(E.type==="mousedown"){this._handleMousedown(E,i);}else if(E.type==="sapnext"||E.type==="sapprevious"){if(!s){return;}if(s.getStartDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);}y=t.getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(this._isSelectionInProgress()){this._markInterval(S,F);}}}
function j(o){h.call(this,o);}
g.prototype._handleMousedown=function(E,i){if(E.button||D.support.touch&&!D.system.combi){return;}var s=this._selectYear(i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");};
function k(o){var E=o.getParameter("event"),i=this._oItemNavigation.getFocusedIndex(),y=this.getYears(),m=this.getColumns(),s=this._getSelectedDates()[0],n=this._oItemNavigation.getItemDomRefs(),S,F,p;if(s&&s.getStartDate()){S=b.fromLocalJSDate(s.getStartDate(),this.getPrimaryCalendarType());S.setMonth(0,1);}if(E.type){if(m===0){m=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode===K.ARROW_DOWN&&m<y){p=n[i-y+m].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(true,i-y+m,true);this._iSelectedIndex=i-y+m;}else{p=n[0].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode===K.ARROW_UP&&m<y){p=n[y-m+i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(false,y-m+i,true);this._iSelectedIndex=y-m+i;}else{p=n[y-1].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(false,y-1,true);}break;case"sappagedown":p=n[i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(true,i,true);break;case"sappageup":p=n[i].getAttribute("data-sap-year-start");F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(p),this.getPrimaryCalendarType());this._updatePage(false,i,true);break;default:break;}}this._isSelectionInProgress()&&this._markInterval(S,F);}
g.prototype._fnShouldApplySelection=function(o){var s=this._getSelectedDates()[0],S,E;if(!s){return false;}S=s.getStartDate();E=s.getEndDate();if(S){S=b.fromLocalJSDate(S,this.getPrimaryCalendarType());S.setMonth(0,1);}if(this.getIntervalSelection()&&S&&E){E=b.fromLocalJSDate(E,this.getPrimaryCalendarType());E.setMonth(0,1);if(o.isSame(S)||o.isSame(E)){return true;}}else if(S&&o.isSame(S)){return true;}return false;};
g.prototype._fnShouldApplySelectionBetween=function(o){var s=this._getSelectedDates()[0],S,E;if(!s){return false;}S=s.getStartDate();E=s.getEndDate();if(this.getIntervalSelection()&&S&&E){S=b.fromLocalJSDate(S,this.getPrimaryCalendarType());S.setMonth(0,1);E=b.fromLocalJSDate(E,this.getPrimaryCalendarType());E.setMonth(0,1);if(a._isBetween(o,S,E)){return true;}}return false;};
return g;});
sap.ui.predefine('sap/ui/unified/calendar/YearPickerRenderer',['sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate','sap/ui/core/InvisibleText'],function(C,U,I){"use strict";var Y={apiVersion:2};
Y.render=function(r,y){var t=y.getTooltip_AsString();r.openStart("div",y);r.class("sapUiCalYearPicker");if(t){r.attr('title',t);}r.accessibilityState(y,this.getAccessibilityState(y));r.openEnd();this.renderCells(r,y);r.close("div");};
Y.getAccessibilityState=function(y){return{role:"grid",readonly:"true",multiselectable:y.getIntervalSelection(),roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("YEAR_PICKER"),describedby:y._bCalendar?I.getStaticId("sap.ui.unified","CALENDAR_YEAR_RANGE_PICKER_OPEN_HINT"):""};};
Y.renderCells=function(r,y){var d=y.getProperty("_middleDate")?y.getProperty("_middleDate"):y._getDate(),c=new C(d,y.getPrimaryCalendarType()),a=y.getYears(),s=y.getId(),b=y.getColumns(),w="",e=false,o,A,f,m,g,i;c.setYear(c.getYear()-Math.floor(a/2));o=y._checkFirstDate(c);if(!o.isSame(c)){c=o;}if(b>0){w=(100/b)+"%";}else{w=(100/a)+"%";}for(i=0;i<a;i++){g=y._oFormatYyyymmdd.format(c.toUTCJSDate(),true);m={role:"gridcell"};e=y._checkDateEnabled(c);if(b>0&&i%b==0){r.openStart("div");r.accessibilityState(null,{role:"row"});r.openEnd();}r.openStart("div",s+"-y"+g);r.class("sapUiCalItem");A=y._fnShouldApplySelection(c);f=y._fnShouldApplySelectionBetween(c);if(A){r.class("sapUiCalItemSel");m["selected"]=true;}if(f){r.class("sapUiCalItemSelBetween");m["selected"]=true;}if(!A&&!f){m["selected"]=false;}if(!e){r.class("sapUiCalItemDsbl");m["disabled"]=true;}r.attr("tabindex","-1");r.attr("data-sap-year-start",g);r.style("width",w);r.accessibilityState(null,m);r.openEnd();r.text(y._oYearFormat.format(U.getInstance(c.toUTCJSDate(),c.getCalendarType()),true));r.close("div");c.setYear(c.getYear()+1);if(b>0&&((i+1)%b==0)){r.close("div");}}};
return Y;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearRangePicker',["sap/ui/core/Renderer","./YearPicker","./YearRangePickerRenderer","./CalendarDate","sap/ui/core/date/UniversalDate","./CalendarUtils","sap/ui/thirdparty/jquery"],function(R,Y,a,C,U,b,q){"use strict";
var c=Y.extend("sap.ui.unified.calendar.YearRangePicker",{metadata:{library:"sap.ui.unified",properties:{years:{type:"int",group:"Appearance",defaultValue:9},columns:{type:"int",group:"Appearance",defaultValue:3},rangeSize:{type:"int",group:"Appearance",defaultValue:20}}}});
c.prototype.setDate=function(r){var o,y,i,f,h;r&&b._checkJSDateObject(r);y=r.getFullYear();b._checkYearInValidRange(y);o=C.fromLocalJSDate(r,this.getPrimaryCalendarType());o.setMonth(0,1);this.setProperty("date",r);this.setProperty("year",o.getYear());this._oDate=o;i=this.getYears();h=Math.floor(i/2);f=new C(this._oDate,this.getPrimaryCalendarType());f=this._checkFirstDate(f);this._iSelectedIndex=h;this.setProperty("_middleDate",f);return this;};
c.prototype._checkFirstDate=function(d){var y=this.getYears();var m=new C(this._oMaxDate,this.getPrimaryCalendarType());if(!m.isSame(b._maxDate(this.getPrimaryCalendarType()))){return d;}m.setYear(m.getYear()-Math.floor(y/2)*this.getRangeSize()+1-Math.floor(this.getRangeSize()/2));if(d.isAfter(m)&&d.getYear()!=m.getYear()){d=new C(m,this.getPrimaryCalendarType());d.setMonth(0,1);}else if(d.isBefore(this._oMinDate)&&d.getYear()!=this._oMinDate.getYear()){d=new C(this._oMinDate,this.getPrimaryCalendarType());d.setMonth(0,1);}return d;};
c.prototype._updatePage=function(f,s,F){var d=this._oItemNavigation.getItemDomRefs(),o=C.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(d[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType()),y=this.getYears(),i=this.getRangeSize();if(f){var m=new C(this._oMaxDate,this.getPrimaryCalendarType());m.setYear(m.getYear()-y*i+1);if(o.isBefore(m)){o.setYear(o.getYear()+y*i+Math.floor(i/2)+Math.floor(y/2)*i);o=this._checkFirstDate(o);}else{return;}}else{if(o.isAfter(this._oMinDate)){o.setYear(o.getYear()-y*i);if(o.isBefore(this._oMinDate)){o=new C(this._oMinDate,this.getPrimaryCalendarType());}o.setYear(o.getYear()+Math.floor(y/2)*i+Math.floor(i/2));o=this._checkFirstDate(o);}else{return;}}this._iSelectedIndex=s;this.setProperty("_middleDate",o);if(F){this.firePageChange();}};
c.prototype._checkDateEnabled=function(f,s){if(b._isBetween(this._oMinDate,f,s,true)||b._isBetween(this._oMaxDate,f,s,true)||this._oMinDate.isBefore(f)&&this._oMaxDate.isAfter(s)){return true;}return false;};
c.prototype._selectYear=function(i){var d=this._oItemNavigation.getItemDomRefs(),D=q(d[i]),y=D.attr("data-sap-year-start"),o=C.fromLocalJSDate(this._oFormatYyyymmdd.parse(y),this.getPrimaryCalendarType());if(D.hasClass("sapUiCalItemDsbl")){return false;}this.setProperty("date",o.toLocalJSDate());this.setProperty("year",o.getYear());return true;};
return c;});
sap.ui.predefine('sap/ui/unified/calendar/YearRangePickerRenderer',["sap/ui/core/Renderer","./YearPickerRenderer","./CalendarDate","sap/ui/core/date/UniversalDate","sap/ui/unified/calendar/CalendarUtils"],function(R,Y,C,U,a){"use strict";var b=R.extend(Y);b.apiVersion=2;
b.getAccessibilityState=function(){return{role:"grid",readonly:"true",multiselectable:false,roledescription:sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("YEAR_RANGE_PICKER")};};
b.renderCells=function(r,y){var d=y.getProperty("_middleDate")?y.getProperty("_middleDate"):y._getDate(),s=new C(d,y.getPrimaryCalendarType()),f=new C(s,y.getPrimaryCalendarType()),S,F="",c="",I=y.getId(),e=y.getColumns(),g=y.getYears(),w="",A,h,i;f.setYear(f.getYear()-Math.floor(y.getRangeSize()/2));f.setYear(f.getYear()-Math.floor(g/2)*y.getRangeSize());f=y._checkFirstDate(f);S=new C(f,y.getPrimaryCalendarType());S.setYear(S.getYear()+y.getRangeSize()-1);if(e>0){w=(100/e)+"%";}else{w=(100/g)+"%";}for(i=0;i<g;i++){h=y._oFormatYyyymmdd.format(f.toUTCJSDate(),true);A={role:"gridcell"};if(e>0&&i%e==0){r.openStart("div");r.accessibilityState(null,{role:"row"});r.openEnd();}r.openStart("div",I+"-y"+h);r.class("sapUiCalItem");if(!y._checkDateEnabled(f,S)){r.class("sapUiCalItemDsbl");A["disabled"]=true;}r.attr("tabindex","-1");r.attr("data-sap-year-start",h);r.style("width",w);r.accessibilityState(null,A);r.openEnd();if(a._isBetween(y._oDate,f,S,true)){y._iSelectedIndex=i;}F=y._oYearFormat.format(U.getInstance(f.toUTCJSDate(),f.getCalendarType()),true);c=y._oYearFormat.format(U.getInstance(S.toUTCJSDate(),S.getCalendarType()),true);r.text(F+" - "+c);r.close("div");if(e>0&&((i+1)%e==0)){r.close("div");}f.setYear(S.getYear()+1);S.setYear(S.getYear()+y.getRangeSize());}};
return b;},true);
sap.ui.predefine('sap/ui/unified/library',['sap/ui/core/Core','sap/ui/base/Object',"./ColorPickerDisplayMode","./FileUploaderHttpRequestMethod",'sap/ui/core/library'],function(C,B,a,F){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.unified",version:"1.98.0",dependencies:["sap.ui.core"],designtime:"sap/ui/unified/designtime/library.designtime",types:["sap.ui.unified.CalendarAppointmentVisualization","sap.ui.unified.CalendarDayType","sap.ui.unified.CalendarIntervalType","sap.ui.unifief.CalendarAppointmentHeight","sap.ui.unifief.CalendarAppointmentRoundWidth","sap.ui.unified.ColorPickerDisplayMode","sap.ui.unified.ColorPickerMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.FileUploaderHttpRequestMethod","sap.ui.unified.StandardCalendarLegendItem"],interfaces:["sap.ui.unified.IProcessableBlobs"],controls:["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.calendar.YearRangePicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.ColorPickerPopover","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],elements:["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],extensions:{"sap.ui.support":{publicRules:true}}});var t=sap.ui.unified;t.CalendarDayType={None:"None",NonWorking:"NonWorking",Type01:"Type01",Type02:"Type02",Type03:"Type03",Type04:"Type04",Type05:"Type05",Type06:"Type06",Type07:"Type07",Type08:"Type08",Type09:"Type09",Type10:"Type10",Type11:"Type11",Type12:"Type12",Type13:"Type13",Type14:"Type14",Type15:"Type15",Type16:"Type16",Type17:"Type17",Type18:"Type18",Type19:"Type19",Type20:"Type20"};t.StandardCalendarLegendItem={Today:"Today",WorkingDay:"WorkingDay",NonWorkingDay:"NonWorkingDay",Selected:"Selected"};t.CalendarIntervalType={Hour:"Hour",Day:"Day",Month:"Month",Week:"Week",OneMonth:"One Month"};t.CalendarAppointmentHeight={HalfSize:"HalfSize",Regular:"Regular",Large:"Large",Automatic:"Automatic"};t.CalendarAppointmentRoundWidth={HalfColumn:"HalfColumn",None:"None"};t.GroupAppointmentsMode={Collapsed:"Collapsed",Expanded:"Expanded"};t.FileUploaderHttpRequestMethod=F;t.CalendarAppointmentVisualization={Standard:"Standard",Filled:"Filled"};t.ContentSwitcherAnimation={None:"None",Fade:"Fade",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",Rotate:"Rotate",SlideRight:"SlideRight",SlideOver:"SlideOver"};t.ColorPickerMode={HSV:"HSV",HSL:"HSL"};t.ColorPickerDisplayMode=a;t._ContentRenderer=B.extend("sap.ui.unified._ContentRenderer",{constructor:function(c,s,o,A){B.apply(this);this._id=s;this._cntnt=o;this._ctrl=c;this._rm=sap.ui.getCore().createRenderManager();this._cb=A||function(){};},destroy:function(){this._rm.destroy();delete this._rm;delete this._id;delete this._cntnt;delete this._cb;delete this._ctrl;if(this._rerenderTimer){clearTimeout(this._rerenderTimer);delete this._rerenderTimer;}B.prototype.destroy.apply(this,arguments);},render:function(){if(!this._rm){return;}if(this._rerenderTimer){clearTimeout(this._rerenderTimer);}this._rerenderTimer=setTimeout(function(){var c=document.getElementById(this._id);if(c){if(typeof(this._cntnt)==="string"){var b=this._ctrl.getAggregation(this._cntnt,[]);for(var i=0;i<b.length;i++){this._rm.renderControl(b[i]);}}else{this._cntnt(this._rm);}this._rm.flush(c);}this._cb(!!c);}.bind(this),0);}});t._iNumberOfOpenedShellOverlays=0;if(!t.ColorPickerHelper){t.ColorPickerHelper={isResponsive:function(){return false;},factory:{createLabel:function(){throw new Error("no Label control available");},createInput:function(){throw new Error("no Input control available");},createSlider:function(){throw new Error("no Slider control available");},createRadioButtonGroup:function(){throw new Error("no RadioButtonGroup control available");},createRadioButtonItem:function(){throw new Error("no RadioButtonItem control available");}},bFinal:false};}if(!t.FileUploaderHelper){t.FileUploaderHelper={createTextField:function(i){throw new Error("no TextField control available!");},setTextFieldContent:function(T,w){throw new Error("no TextField control available!");},createButton:function(i){throw new Error("no Button control available!");},addFormClass:function(){return null;},bFinal:false};}t.calendar=t.calendar||{};return t;});
sap.ui.require.preload({
	"sap/ui/unified/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.unified","type":"library","embeds":[],"applicationVersion":{"version":"1.98.0"},"title":"Unified controls intended for both, mobile and desktop scenarios","description":"Unified controls intended for both, mobile and desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.98","libs":{"sap.ui.core":{"minVersion":"1.98.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.calendar.YearRangePicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.ColorPickerPopover","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],"elements":["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.FileUploaderXHRSettings","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"],"types":["sap.ui.unified.CalendarAppointmentVisualization","sap.ui.unified.CalendarDayType","sap.ui.unified.CalendarIntervalType","sap.ui.unifief.CalendarAppointmentHeight","sap.ui.unifief.CalendarAppointmentRoundWidth","sap.ui.unified.ColorPickerDisplayMode","sap.ui.unified.ColorPickerMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.FileUploaderHttpRequestMethod","sap.ui.unified.StandardCalendarLegendItem"],"interfaces":["sap.ui.unified.IProcessableBlobs"]}}}}'
},"sap/ui/unified/library-preload"
);
//# sourceMappingURL=library-preload.js.map