ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(e,t,i){"use strict";var n=e("./lib/dom");var r=e("./lib/oop");var o=e("./lib/event_emitter").EventEmitter;var s=e("./lib/lang");var a=e("./range").Range;var l=e("./range_list").RangeList;var c=e("./keyboard/hash_handler").HashHandler;var p=e("./tokenizer").Tokenizer;var h=e("./clipboard");var u={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,i){var n=e.session.getTextRange();if(i)return n.replace(/\n\r?([ \t]*\S)/g,"\n"+i+"$1");return n},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return h.getText&&h.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.start||""},BLOCK_COMMENT_END:function(e){var t=e.session.$mode||{};return t.blockComment&&t.blockComment.end||""},LINE_COMMENT:function(e){var t=e.session.$mode||{};return t.lineCommentStart||""},CURRENT_YEAR:f.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:f.bind(null,{year:"2-digit"}),CURRENT_MONTH:f.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:f.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:f.bind(null,{month:"short"}),CURRENT_DATE:f.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:f.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:f.bind(null,{weekday:"short"}),CURRENT_HOUR:f.bind(null,{hour:"2-digit",hour12:false}),CURRENT_MINUTE:f.bind(null,{minute:"2-digit"}),CURRENT_SECOND:f.bind(null,{second:"2-digit"})};u.SELECTED_TEXT=u.SELECTION;function f(e){var t=(new Date).toLocaleString("en-us",e);return t.length==1?"0"+t:t}var d=function(){function e(){this.snippetMap={};this.snippetNameMap={};this.variables=u}e.prototype.getTokenizer=function(){return e.$tokenizer||this.createTokenizer()};e.prototype.createTokenizer=function(){function t(e){e=e.substr(1);if(/^\d+$/.test(e))return[{tabstopId:parseInt(e,10)}];return[{text:e}]}function i(e){return"(?:[^\\\\"+e+"]|\\\\.)"}var n={regex:"/("+i("/")+"+)/",onMatch:function(e,t,i){var n=i[0];n.fmtString=true;n.guard=e.slice(1,-1);n.flag="";return""},next:"formatString"};e.$tokenizer=new p({start:[{regex:/\\./,onMatch:function(e,t,i){var n=e[1];if(n=="}"&&i.length){e=n}else if("`$\\".indexOf(n)!=-1){e=n}return[e]}},{regex:/}/,onMatch:function(e,t,i){return[i.length?i.shift():e]}},{regex:/\$(?:\d+|\w+)/,onMatch:t},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(e,i,n){var r=t(e.substr(1));n.unshift(r[0]);return r},next:"snippetVar"},{regex:/\n/,token:"newline",merge:false}],snippetVar:[{regex:"\\|"+i("\\|")+"*\\|",onMatch:function(e,t,i){var n=e.slice(1,-1).replace(/\\[,|\\]|,/g,function(e){return e.length==2?e[1]:"\0"}).split("\0").map(function(e){return{value:e}});i[0].choices=n;return[n[0]]},next:"start"},n,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(e,t,i){if(i.length&&i[0].expectElse){i[0].expectElse=false;i[0].ifEnd={elseEnd:i[0]};return[i[0].ifEnd]}return":"}},{regex:/\\./,onMatch:function(e,t,i){var n=e[1];if(n=="}"&&i.length)e=n;else if("`$\\".indexOf(n)!=-1)e=n;else if(n=="n")e="\n";else if(n=="t")e="\t";else if("ulULE".indexOf(n)!=-1)e={changeCase:n,local:n>"a"};return[e]}},{regex:"/\\w*}",onMatch:function(e,t,i){var n=i.shift();if(n)n.flag=e.slice(1,-1);this.next=n&&n.tabstopId?"start":"";return[n||e]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(e,t,i){return[{text:e.slice(1)}]}},{regex:/\${\w+/,onMatch:function(e,t,i){var n={text:e.slice(2)};i.unshift(n);return[n]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:false},{regex:/}/,onMatch:function(e,t,i){var n=i.shift();this.next=n&&n.tabstopId?"start":"";return[n||e]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(e,t,i){var n=i[0];n.formatFunction=e.slice(2,-1);return[i.shift()]},next:"formatString"},n,{regex:/:[\?\-+]?/,onMatch:function(e,t,i){if(e[1]=="+")i[0].ifEnd=i[0];if(e[1]=="?")i[0].expectElse=true},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]});return e.$tokenizer};e.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(e){return e.value||e})};e.prototype.getVariableValue=function(e,t,i){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";t=t.replace(/^TM_/,"");if(!this.variables.hasOwnProperty(t))return"";var n=this.variables[t];if(typeof n=="function")n=this.variables[t](e,t,i);return n==null?"":n};e.prototype.tmStrFormat=function(e,t,i){if(!t.fmt)return e;var n=t.flag||"";var r=t.guard;r=new RegExp(r,n.replace(/[^gim]/g,""));var o=typeof t.fmt=="string"?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt;var s=this;var a=e.replace(r,function(){var e=s.variables.__;s.variables.__=[].slice.call(arguments);var t=s.resolveVariables(o,i);var n="E";for(var r=0;r<t.length;r++){var a=t[r];if(typeof a=="object"){t[r]="";if(a.changeCase&&a.local){var l=t[r+1];if(l&&typeof l=="string"){if(a.changeCase=="u")t[r]=l[0].toUpperCase();else t[r]=l[0].toLowerCase();t[r+1]=l.substr(1)}}else if(a.changeCase){n=a.changeCase}}else if(n=="U"){t[r]=a.toUpperCase()}else if(n=="L"){t[r]=a.toLowerCase()}}s.variables.__=e;return t.join("")});return a};e.prototype.tmFormatFunction=function(e,t,i){if(t.formatFunction=="upcase")return e.toUpperCase();if(t.formatFunction=="downcase")return e.toLowerCase();return e};e.prototype.resolveVariables=function(e,t){var i=[];var n="";var r=true;for(var o=0;o<e.length;o++){var s=e[o];if(typeof s=="string"){i.push(s);if(s=="\n"){r=true;n=""}else if(r){n=/^\t*/.exec(s)[0];r=/\S/.test(s)}continue}if(!s)continue;r=false;if(s.fmtString){var a=e.indexOf(s,o+1);if(a==-1)a=e.length;s.fmt=e.slice(o+1,a);o=a}if(s.text){var l=this.getVariableValue(t,s.text,n)+"";if(s.fmtString)l=this.tmStrFormat(l,s,t);if(s.formatFunction)l=this.tmFormatFunction(l,s,t);if(l&&!s.ifEnd){i.push(l);c(s)}else if(!l&&s.ifEnd){c(s.ifEnd)}}else if(s.elseEnd){c(s.elseEnd)}else if(s.tabstopId!=null){i.push(s)}else if(s.changeCase!=null){i.push(s)}}function c(t){var i=e.indexOf(t,o+1);if(i!=-1)o=i}return i};e.prototype.getDisplayTextForSnippet=function(e,t){var i=g.call(this,e,t);return i.text};e.prototype.insertSnippetForSelection=function(e,t,i){if(i===void 0){i={}}var n=g.call(this,e,t,i);var r=e.getSelectionRange();var o=e.session.replace(r,n.text);var s=new m(e);var a=e.inVirtualSelectionMode&&e.selection.index;s.addTabstops(n.tabstops,r.start,o,a)};e.prototype.insertSnippet=function(e,t,i){if(i===void 0){i={}}var n=this;if(e.inVirtualSelectionMode)return n.insertSnippetForSelection(e,t,i);e.forEachSelection(function(){n.insertSnippetForSelection(e,t,i)},null,{keepOrder:true});if(e.tabstopManager)e.tabstopManager.tabNext()};e.prototype.$getScope=function(e){var t=e.session.$mode.$id||"";t=t.split("/").pop();if(t==="html"||t==="php"){if(t==="php"&&!e.session.$mode.inlinePhp)t="html";var i=e.getCursorPosition();var n=e.session.getState(i.row);if(typeof n==="object"){n=n[0]}if(n.substring){if(n.substring(0,3)=="js-")t="javascript";else if(n.substring(0,4)=="css-")t="css";else if(n.substring(0,4)=="php-")t="php"}}return t};e.prototype.getActiveScopes=function(e){var t=this.$getScope(e);var i=[t];var n=this.snippetMap;if(n[t]&&n[t].includeScopes){i.push.apply(i,n[t].includeScopes)}i.push("_");return i};e.prototype.expandWithTab=function(e,t){var i=this;var n=e.forEachSelection(function(){return i.expandSnippetForSelection(e,t)},null,{keepOrder:true});if(n&&e.tabstopManager)e.tabstopManager.tabNext();return n};e.prototype.expandSnippetForSelection=function(e,t){var i=e.getCursorPosition();var n=e.session.getLine(i.row);var r=n.substring(0,i.column);var o=n.substr(i.column);var s=this.snippetMap;var a;this.getActiveScopes(e).some(function(e){var t=s[e];if(t)a=this.findMatchingSnippet(t,r,o);return!!a},this);if(!a)return false;if(t&&t.dryRun)return true;e.session.doc.removeInLine(i.row,i.column-a.replaceBefore.length,i.column+a.replaceAfter.length);this.variables.M__=a.matchBefore;this.variables.T__=a.matchAfter;this.insertSnippetForSelection(e,a.content);this.variables.M__=this.variables.T__=null;return true};e.prototype.findMatchingSnippet=function(e,t,i){for(var n=e.length;n--;){var r=e[n];if(r.startRe&&!r.startRe.test(t))continue;if(r.endRe&&!r.endRe.test(i))continue;if(!r.startRe&&!r.endRe)continue;r.matchBefore=r.startRe?r.startRe.exec(t):[""];r.matchAfter=r.endRe?r.endRe.exec(i):[""];r.replaceBefore=r.triggerRe?r.triggerRe.exec(t)[0]:"";r.replaceAfter=r.endTriggerRe?r.endTriggerRe.exec(i)[0]:"";return r}};e.prototype.register=function(e,t){var i=this.snippetMap;var n=this.snippetNameMap;var r=this;if(!e)e=[];function o(e){if(e&&!/^\^?\(.*\)\$?$|^\\b$/.test(e))e="(?:"+e+")";return e||""}function a(e,t,i){e=o(e);t=o(t);if(i){e=t+e;if(e&&e[e.length-1]!="$")e=e+"$"}else{e=e+t;if(e&&e[0]!="^")e="^"+e}return new RegExp(e)}function l(e){if(!e.scope)e.scope=t||"_";t=e.scope;if(!i[t]){i[t]=[];n[t]={}}var o=n[t];if(e.name){var l=o[e.name];if(l)r.unregister(l);o[e.name]=e}i[t].push(e);if(e.prefix)e.tabTrigger=e.prefix;if(!e.content&&e.body)e.content=Array.isArray(e.body)?e.body.join("\n"):e.body;if(e.tabTrigger&&!e.trigger){if(!e.guard&&/^\w/.test(e.tabTrigger))e.guard="\\b";e.trigger=s.escapeRegExp(e.tabTrigger)}if(!e.trigger&&!e.guard&&!e.endTrigger&&!e.endGuard)return;e.startRe=a(e.trigger,e.guard,true);e.triggerRe=new RegExp(e.trigger);e.endRe=a(e.endTrigger,e.endGuard,true);e.endTriggerRe=new RegExp(e.endTrigger)}if(Array.isArray(e)){e.forEach(l)}else{Object.keys(e).forEach(function(t){l(e[t])})}this._signal("registerSnippets",{scope:t})};e.prototype.unregister=function(e,t){var i=this.snippetMap;var n=this.snippetNameMap;function r(e){var r=n[e.scope||t];if(r&&r[e.name]){delete r[e.name];var o=i[e.scope||t];var s=o&&o.indexOf(e);if(s>=0)o.splice(s,1)}}if(e.content)r(e);else if(Array.isArray(e))e.forEach(r)};e.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");var t=[],i={};var n=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;var r;while(r=n.exec(e)){if(r[1]){try{i=JSON.parse(r[1]);t.push(i)}catch(e){}}if(r[4]){i.content=r[4].replace(/^\t/gm,"");t.push(i);i={}}else{var o=r[2],s=r[3];if(o=="regex"){var a=/\/((?:[^\/\\]|\\.)*)|$/g;i.guard=a.exec(s)[1];i.trigger=a.exec(s)[1];i.endTrigger=a.exec(s)[1];i.endGuard=a.exec(s)[1]}else if(o=="snippet"){i.tabTrigger=s.match(/^\S*/)[0];if(!i.name)i.name=s}else if(o){i[o]=s}}}return t};e.prototype.getSnippetByName=function(e,t){var i=this.snippetNameMap;var n;this.getActiveScopes(t).some(function(t){var r=i[t];if(r)n=r[e];return!!n},this);return n};return e}();r.implement(d.prototype,o);var g=function(e,t,i){if(i===void 0){i={}}var n=e.getCursorPosition();var r=e.session.getLine(n.row);var o=e.session.getTabString();var s=r.match(/^\s*/)[0];if(n.column<s.length)s=s.slice(0,n.column);t=t.replace(/\r/g,"");var a=this.tokenizeTmSnippet(t);a=this.resolveVariables(a,e);a=a.map(function(e){if(e=="\n"&&!i.excludeExtraIndent)return e+s;if(typeof e=="string")return e.replace(/\t/g,o);return e});var l=[];a.forEach(function(e,t){if(typeof e!="object")return;var i=e.tabstopId;var n=l[i];if(!n){n=l[i]=[];n.index=i;n.value="";n.parents={}}if(n.indexOf(e)!==-1)return;if(e.choices&&!n.choices)n.choices=e.choices;n.push(e);var r=a.indexOf(e,t+1);if(r===-1)return;var o=a.slice(t+1,r);var s=o.some(function(e){return typeof e==="object"});if(s&&!n.value){n.value=o}else if(o.length&&(!n.value||typeof n.value!=="string")){n.value=o.join("")}});l.forEach(function(e){e.length=0});var c={};function p(e){var t=[];for(var i=0;i<e.length;i++){var n=e[i];if(typeof n=="object"){if(c[n.tabstopId])continue;var r=e.lastIndexOf(n,i-1);n=t[r]||{tabstopId:n.tabstopId}}t[i]=n}return t}for(var h=0;h<a.length;h++){var u=a[h];if(typeof u!="object")continue;var f=u.tabstopId;var d=l[f];var g=a.indexOf(u,h+1);if(c[f]){if(c[f]===u){delete c[f];Object.keys(c).forEach(function(e){d.parents[e]=true})}continue}c[f]=u;var m=d.value;if(typeof m!=="string")m=p(m);else if(u.fmt)m=this.tmStrFormat(m,u,e);a.splice.apply(a,[h+1,Math.max(0,g-h)].concat(m,u));if(d.indexOf(u)===-1)d.push(u)}var v=0,b=0;var y="";a.forEach(function(e){if(typeof e==="string"){var t=e.split("\n");if(t.length>1){b=t[t.length-1].length;v+=t.length-1}else b+=e.length;y+=e}else if(e){if(!e.start)e.start={row:v,column:b};else e.end={row:v,column:b}}});return{text:y,tabstops:l,tokens:a}};var m=function(){function e(e){this.index=0;this.ranges=[];this.tabstops=[];if(e.tabstopManager)return e.tabstopManager;e.tabstopManager=this;this.$onChange=this.onChange.bind(this);this.$onChangeSelection=s.delayedCall(this.onChangeSelection.bind(this)).schedule;this.$onChangeSession=this.onChangeSession.bind(this);this.$onAfterExec=this.onAfterExec.bind(this);this.attach(e)}e.prototype.attach=function(e){this.$openTabstops=null;this.selectedTabstop=null;this.editor=e;this.session=e.session;this.editor.on("change",this.$onChange);this.editor.on("changeSelection",this.$onChangeSelection);this.editor.on("changeSession",this.$onChangeSession);this.editor.commands.on("afterExec",this.$onAfterExec);this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)};e.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this);this.ranges.length=0;this.tabstops.length=0;this.selectedTabstop=null;this.editor.off("change",this.$onChange);this.editor.off("changeSelection",this.$onChangeSelection);this.editor.off("changeSession",this.$onChangeSession);this.editor.commands.off("afterExec",this.$onAfterExec);this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);this.editor.tabstopManager=null;this.session=null;this.editor=null};e.prototype.onChange=function(e){var t=e.action[0]=="r";var i=this.selectedTabstop||{};var n=i.parents||{};var r=this.tabstops.slice();for(var o=0;o<r.length;o++){var s=r[o];var a=s==i||n[s.index];s.rangeList.$bias=a?0:1;if(e.action=="remove"&&s!==i){var l=s.parents&&s.parents[i.index];var c=s.rangeList.pointIndex(e.start,l);c=c<0?-c-1:c+1;var p=s.rangeList.pointIndex(e.end,l);p=p<0?-p-1:p-1;var h=s.rangeList.ranges.slice(c,p);for(var u=0;u<h.length;u++)this.removeRange(h[u])}s.rangeList.$onChange(e)}var f=this.session;if(!this.$inChange&&t&&f.getLength()==1&&!f.getValue())this.detach()};e.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(!e||!e.hasLinkedRanges||!e.firstNonLinked)return;this.$inChange=true;var i=this.session;var n=i.getTextRange(e.firstNonLinked);for(var r=0;r<e.length;r++){var o=e[r];if(!o.linked)continue;var s=o.original;var a=t.snippetManager.tmStrFormat(n,s,this.editor);i.replace(o,a)}this.$inChange=false};e.prototype.onAfterExec=function(e){if(e.command&&!e.command.readOnly)this.updateLinkedFields()};e.prototype.onChangeSelection=function(){if(!this.editor)return;var e=this.editor.selection.lead;var t=this.editor.selection.anchor;var i=this.editor.selection.isEmpty();for(var n=0;n<this.ranges.length;n++){if(this.ranges[n].linked)continue;var r=this.ranges[n].contains(e.row,e.column);var o=i||this.ranges[n].contains(t.row,t.column);if(r&&o)return}this.detach()};e.prototype.onChangeSession=function(){this.detach()};e.prototype.tabNext=function(e){var t=this.tabstops.length;var i=this.index+(e||1);i=Math.min(Math.max(i,1),t);if(i==t)i=0;this.selectTabstop(i);if(i===0)this.detach()};e.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t)this.addTabstopMarkers(t);this.index=e;t=this.tabstops[this.index];if(!t||!t.length)return;this.selectedTabstop=t;var i=t.firstNonLinked||t;if(t.choices)i.cursor=i.start;if(!this.editor.inVirtualSelectionMode){var n=this.editor.multiSelect;n.toSingleRange(i);for(var r=0;r<t.length;r++){if(t.hasLinkedRanges&&t[r].linked)continue;n.addRange(t[r].clone(),true)}}else{this.editor.selection.fromOrientedRange(i)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler);if(this.selectedTabstop&&this.selectedTabstop.choices)this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})};e.prototype.addTabstops=function(e,t,i){var n=this.useLink||!this.editor.getOption("enableMultiselect");if(!this.$openTabstops)this.$openTabstops=[];if(!e[0]){var r=a.fromPoints(i,i);b(r.start,t);b(r.end,t);e[0]=[r];e[0].index=0}var o=this.index;var s=[o+1,0];var c=this.ranges;e.forEach(function(e,i){var r=this.$openTabstops[i]||e;for(var o=0;o<e.length;o++){var p=e[o];var h=a.fromPoints(p.start,p.end||p.start);v(h.start,t);v(h.end,t);h.original=p;h.tabstop=r;c.push(h);if(r!=e)r.unshift(h);else r[o]=h;if(p.fmtString||r.firstNonLinked&&n){h.linked=true;r.hasLinkedRanges=true}else if(!r.firstNonLinked)r.firstNonLinked=h}if(!r.firstNonLinked)r.hasLinkedRanges=false;if(r===e){s.push(r);this.$openTabstops[i]=r}this.addTabstopMarkers(r);r.rangeList=r.rangeList||new l;r.rangeList.$bias=0;r.rangeList.addList(r)},this);if(s.length>2){if(this.tabstops.length)s.push(s.splice(2,1)[0]);this.tabstops.splice.apply(this.tabstops,s)}};e.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){if(!e.markerId)e.markerId=t.addMarker(e,"ace_snippet-marker","text")})};e.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(e){t.removeMarker(e.markerId);e.markerId=null})};e.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);if(t!=-1)e.tabstop.splice(t,1);t=this.ranges.indexOf(e);if(t!=-1)this.ranges.splice(t,1);t=e.tabstop.rangeList.ranges.indexOf(e);if(t!=-1)e.tabstop.splice(t,1);this.session.removeMarker(e.markerId);if(!e.tabstop.length){t=this.tabstops.indexOf(e.tabstop);if(t!=-1)this.tabstops.splice(t,1);if(!this.tabstops.length)this.detach()}};return e}();m.prototype.keyboardHandler=new c;m.prototype.keyboardHandler.bindKeys({Tab:function(e){if(t.snippetManager&&t.snippetManager.expandWithTab(e))return;e.tabstopManager.tabNext(1);e.renderer.scrollCursorIntoView()},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1);e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var v=function(e,t){if(e.row==0)e.column+=t.column;e.row+=t.row};var b=function(e,t){if(e.row==t.row)e.column-=t.column;e.row-=t.row};n.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",false);t.snippetManager=new d;var y=e("./editor").Editor;(function(){this.insertSnippet=function(e,i){return t.snippetManager.insertSnippet(this,e,i)};this.expandSnippet=function(e){return t.snippetManager.expandWithTab(this,e)}}).call(y.prototype)});ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config"],function(e,t,i){"use strict";var n=e("../virtual_renderer").VirtualRenderer;var r=e("../editor").Editor;var o=e("../range").Range;var s=e("../lib/event");var a=e("../lib/lang");var l=e("../lib/dom");var c=e("../config").nls;var p=function(e){return"suggest-aria-id:".concat(e)};var h=function(e){var t=new n(e);t.$maxLines=4;var i=new r(t);i.setHighlightActiveLine(false);i.setShowPrintMargin(false);i.renderer.setShowGutter(false);i.renderer.setHighlightGutterLine(false);i.$mouseHandler.$focusTimeout=0;i.$highlightTagPending=true;return i};var u=function(){function e(e){var t=l.createElement("div");var i=new h(t);if(e){e.appendChild(t)}t.style.display="none";i.renderer.content.style.cursor="default";i.renderer.setStyle("ace_autocomplete");i.renderer.$textLayer.element.setAttribute("role","listbox");i.renderer.$textLayer.element.setAttribute("aria-label",c("Autocomplete suggestions"));i.renderer.textarea.setAttribute("aria-hidden","true");i.setOption("displayIndentGuides",false);i.setOption("dragDelay",150);var n=function(){};i.focus=n;i.$isFocused=true;i.renderer.$cursorLayer.restartTimer=n;i.renderer.$cursorLayer.element.style.opacity=0;i.renderer.$maxLines=8;i.renderer.$keepTextAreaAtCursor=false;i.setHighlightActiveLine(false);i.session.highlight("");i.session.$searchHighlight.clazz="ace_highlight-marker";i.on("mousedown",function(e){var t=e.getDocumentPosition();i.selection.moveToPosition(t);f.start.row=f.end.row=t.row;e.stop()});var r;var u=new o(-1,0,-1,Infinity);var f=new o(-1,0,-1,Infinity);f.id=i.session.addMarker(f,"ace_active-line","fullLine");i.setSelectOnHover=function(e){if(!e){u.id=i.session.addMarker(u,"ace_line-hover","fullLine")}else if(u.id){i.session.removeMarker(u.id);u.id=null}};i.setSelectOnHover(false);i.on("mousemove",function(e){if(!r){r=e;return}if(r.x==e.x&&r.y==e.y){return}r=e;r.scrollTop=i.renderer.scrollTop;i.isMouseOver=true;var t=r.getDocumentPosition().row;if(u.start.row!=t){if(!u.id)i.setRow(t);g(t)}});i.renderer.on("beforeRender",function(){if(r&&u.start.row!=-1){r.$pos=null;var e=r.getDocumentPosition().row;if(!u.id)i.setRow(e);g(e,true)}});i.renderer.on("afterRender",function(){var e=i.getRow();var t=i.renderer.$textLayer;var n=t.element.childNodes[e-t.config.firstRow];var r=document.activeElement;if(n!==t.selectedNode&&t.selectedNode){l.removeCssClass(t.selectedNode,"ace_selected");r.removeAttribute("aria-activedescendant");t.selectedNode.removeAttribute("id")}t.selectedNode=n;if(n){l.addCssClass(n,"ace_selected");var o=p(e);n.id=o;t.element.setAttribute("aria-activedescendant",o);r.setAttribute("aria-activedescendant",o);n.setAttribute("role","option");n.setAttribute("aria-label",i.getData(e).value);n.setAttribute("aria-setsize",i.data.length);n.setAttribute("aria-posinset",e+1);n.setAttribute("aria-describedby","doc-tooltip")}});var d=function(){g(-1)};var g=function(e,t){if(e!==u.start.row){u.start.row=u.end.row=e;if(!t)i.session._emit("changeBackMarker");i._emit("changeHoverMarker")}};i.getHoveredRow=function(){return u.start.row};s.addListener(i.container,"mouseout",function(){i.isMouseOver=false;d()});i.on("hide",d);i.on("changeSelection",d);i.session.doc.getLength=function(){return i.data.length};i.session.doc.getLine=function(e){var t=i.data[e];if(typeof t=="string")return t;return t&&t.value||""};var m=i.session.bgTokenizer;m.$tokenizeRow=function(e){var t=i.data[e];var n=[];if(!t)return n;if(typeof t=="string")t={value:t};var r=t.caption||t.value||t.name;function o(e,i){e&&n.push({type:(t.className||"")+(i||""),value:e})}var s=r.toLowerCase();var a=(i.filterText||"").toLowerCase();var l=0;var c=0;for(var p=0;p<=a.length;p++){if(p!=c&&(t.matchMask&1<<p||p==a.length)){var h=a.slice(c,p);c=p;var u=s.indexOf(h,l);if(u==-1)continue;o(r.slice(l,u),"");l=u+h.length;o(r.slice(u,l),"completion-highlight")}}o(r.slice(l,r.length),"");n.push({type:"completion-spacer",value:" "});if(t.meta)n.push({type:"completion-meta",value:t.meta});if(t.message)n.push({type:"completion-message",value:t.message});return n};m.$updateOnChange=n;m.start=n;i.session.$computeWidth=function(){return this.screenWidth=0};i.isOpen=false;i.isTopdown=false;i.autoSelect=true;i.filterText="";i.isMouseOver=false;i.data=[];i.setData=function(e,t){i.filterText=t||"";i.setValue(a.stringRepeat("\n",e.length),-1);i.data=e||[];i.setRow(0)};i.getData=function(e){return i.data[e]};i.getRow=function(){return f.start.row};i.setRow=function(e){e=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,e));if(f.start.row!=e){i.selection.clearSelection();f.start.row=f.end.row=e||0;i.session._emit("changeBackMarker");i.moveCursorTo(e||0,0);if(i.isOpen)i._signal("select")}};i.on("changeSelection",function(){if(i.isOpen)i.setRow(i.selection.lead.row);i.renderer.scrollCursorIntoView()});i.hide=function(){this.container.style.display="none";i.anchorPos=null;i.anchor=null;if(i.isOpen){i.isOpen=false;this._signal("hide")}};i.tryShow=function(e,t,n,o){if(!o&&i.isOpen&&i.anchorPos&&i.anchor&&i.anchorPos.top===e.top&&i.anchorPos.left===e.left&&i.anchor===n){return true}var s=this.container;var a=window.innerHeight;var l=window.innerWidth;var c=this.renderer;var p=c.$maxLines*t*1.4;var h={top:0,bottom:0,left:0};var u=a-e.top-3*this.$borderSize-t;var f=e.top-3*this.$borderSize;if(!n){if(f<=u||u>=p){n="bottom"}else{n="top"}}if(n==="top"){h.bottom=e.top-this.$borderSize;h.top=h.bottom-p}else if(n==="bottom"){h.top=e.top+t+this.$borderSize;h.bottom=h.top+p}var d=h.top>=0&&h.bottom<=a;if(!o&&!d){return false}if(!d){if(n==="top"){c.$maxPixelHeight=f}else{c.$maxPixelHeight=u}}else{c.$maxPixelHeight=null}if(n==="top"){s.style.top="";s.style.bottom=a-h.bottom+"px";i.isTopdown=false}else{s.style.top=h.top+"px";s.style.bottom="";i.isTopdown=true}s.style.display="";var g=e.left;if(g+s.offsetWidth>l)g=l-s.offsetWidth;s.style.left=g+"px";s.style.right="";if(!i.isOpen){i.isOpen=true;this._signal("show");r=null}i.anchorPos=e;i.anchor=n;return true};i.show=function(e,t,i){this.tryShow(e,t,i?"bottom":undefined,true)};i.goTo=function(e){var t=this.getRow();var i=this.session.getLength()-1;switch(e){case"up":t=t<=0?i:t-1;break;case"down":t=t>=i?-1:t+1;break;case"start":t=0;break;case"end":t=i;break}this.setRow(t)};i.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize};i.$imageSize=0;i.$borderSize=1;return i}return e}();l.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",false);t.AcePopup=u;t.$singleLineEditor=h;t.getAriaId=p});ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(e,t,i){"use strict";var n=function(){function e(e){this.editor=e;this.screenReaderDiv=document.createElement("div");this.screenReaderDiv.classList.add("ace_screenreader-only");this.editor.container.appendChild(this.screenReaderDiv)}e.prototype.setScreenReaderContent=function(e){if(!this.popup&&this.editor.completer&&this.editor.completer.popup){this.popup=this.editor.completer.popup;this.popup.renderer.on("afterRender",function(){var e=this.popup.getRow();var t=this.popup.renderer.$textLayer;var i=t.element.childNodes[e-t.config.firstRow];if(i){var n="doc-tooltip ";for(var r=0;r<this._lines.length;r++){n+="ace-inline-screenreader-line-".concat(r," ")}i.setAttribute("aria-describedby",n)}}.bind(this))}while(this.screenReaderDiv.firstChild){this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild)}this._lines=e.split(/\r\n|\r|\n/);var t=this.createCodeBlock();this.screenReaderDiv.appendChild(t)};e.prototype.destroy=function(){this.screenReaderDiv.remove()};e.prototype.createCodeBlock=function(){var e=document.createElement("pre");e.setAttribute("id","ace-inline-screenreader");for(var t=0;t<this._lines.length;t++){var i=document.createElement("code");i.setAttribute("id","ace-inline-screenreader-line-".concat(t));var n=document.createTextNode(this._lines[t]);i.appendChild(n);e.appendChild(i)}return e};return e}();t.AceInlineScreenReader=n});ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(e,t,i){"use strict";var n=e("../snippets").snippetManager;var r=e("./inline_screenreader").AceInlineScreenReader;var o=function(){function e(){this.editor=null}e.prototype.show=function(e,t,i){i=i||"";if(e&&this.editor&&this.editor!==e){this.hide();this.editor=null;this.inlineScreenReader=null}if(!e||!t){return false}if(!this.inlineScreenReader){this.inlineScreenReader=new r(e)}var o=t.snippet?n.getDisplayTextForSnippet(e,t.snippet):t.value;if(t.hideInlinePreview||!o||!o.startsWith(i)){return false}this.editor=e;this.inlineScreenReader.setScreenReaderContent(o);o=o.slice(i.length);if(o===""){e.removeGhostText()}else{e.setGhostText(o)}return true};e.prototype.isOpen=function(){if(!this.editor){return false}return!!this.editor.renderer.$ghostText};e.prototype.hide=function(){if(!this.editor){return false}this.editor.removeGhostText();return true};e.prototype.destroy=function(){this.hide();this.editor=null;if(this.inlineScreenReader){this.inlineScreenReader.destroy();this.inlineScreenReader=null}};return e}();t.AceInline=o});ace.define("ace/autocomplete/util",["require","exports","module"],function(e,t,i){"use strict";t.parForEach=function(e,t,i){var n=0;var r=e.length;if(r===0)i();for(var o=0;o<r;o++){t(e[o],function(e,t){n++;if(n===r)i(e,t)})}};var n=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;t.retrievePrecedingIdentifier=function(e,t,i){i=i||n;var r=[];for(var o=t-1;o>=0;o--){if(i.test(e[o]))r.push(e[o]);else break}return r.reverse().join("")};t.retrieveFollowingIdentifier=function(e,t,i){i=i||n;var r=[];for(var o=t;o<e.length;o++){if(i.test(e[o]))r.push(e[o]);else break}return r};t.getCompletionPrefix=function(e){var t=e.getCursorPosition();var i=e.session.getLine(t.row);var n;e.completers.forEach(function(e){if(e.identifierRegexps){e.identifierRegexps.forEach(function(e){if(!n&&e)n=this.retrievePrecedingIdentifier(i,t.column,e)}.bind(this))}}.bind(this));return n||this.retrievePrecedingIdentifier(i,t.column)};t.triggerAutocomplete=function(e){var t=e.getCursorPosition();var i=e.session.getLine(t.row);var n=t.column===0?0:t.column-1;var r=i[n];return e.completers.some(function(e){if(e.triggerCharacters&&Array.isArray(e.triggerCharacters)){return e.triggerCharacters.includes(r)}})}});ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event"],function(e,t,i){"use strict";var n=e("./keyboard/hash_handler").HashHandler;var r=e("./autocomplete/popup").AcePopup;var o=e("./autocomplete/inline").AceInline;var s=e("./autocomplete/popup").getAriaId;var a=e("./autocomplete/util");var l=e("./lib/lang");var c=e("./lib/dom");var p=e("./snippets").snippetManager;var h=e("./config");var u=e("./lib/event");var f=function(e,t){t.completer&&t.completer.destroy()};var d=function(){function e(){this.autoInsert=false;this.autoSelect=true;this.autoShown=false;this.exactMatch=false;this.inlineEnabled=false;this.keyboardHandler=new n;this.keyboardHandler.bindKeys(this.commands);this.parentNode=null;this.setSelectOnHover=false;this.stickySelectionDelay=500;this.blurListener=this.blurListener.bind(this);this.changeListener=this.changeListener.bind(this);this.mousedownListener=this.mousedownListener.bind(this);this.mousewheelListener=this.mousewheelListener.bind(this);this.onLayoutChange=this.onLayoutChange.bind(this);this.changeTimer=l.delayedCall(function(){this.updateCompletions(true)}.bind(this));this.tooltipTimer=l.delayedCall(this.updateDocTooltip.bind(this),50);this.stickySelectionTimer=l.delayedCall(function(){this.stickySelection=true}.bind(this),this.stickySelectionDelay);this.$firstOpenTimer=l.delayedCall(function(){var e=this.completionProvider&&this.completionProvider.initialPosition;if(this.autoShown||this.popup&&this.popup.isOpen||!e)return;var t=[{caption:h.nls("Loading..."),value:""}];this.completions=new m(t);this.openPopup(this.editor,e.prefix,false);this.popup.renderer.setStyle("ace_loading",true)}.bind(this),this.stickySelectionDelay)}e.prototype.$init=function(){this.popup=new r(this.parentNode||document.body||document.documentElement);this.popup.on("click",function(e){this.insertMatch();e.stop()}.bind(this));this.popup.focus=this.editor.focus.bind(this.editor);this.popup.on("show",this.$onPopupShow.bind(this));this.popup.on("hide",this.$onHidePopup.bind(this));this.popup.on("select",this.$onPopupChange.bind(this));u.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this));this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null));return this.popup};e.prototype.$initInline=function(){if(!this.inlineEnabled||this.inlineRenderer)return;this.inlineRenderer=new o;return this.inlineRenderer};e.prototype.getPopup=function(){return this.popup||this.$init()};e.prototype.$onHidePopup=function(){if(this.inlineRenderer){this.inlineRenderer.hide()}this.hideDocTooltip();this.stickySelectionTimer.cancel();this.stickySelection=false};e.prototype.$onPopupChange=function(e){if(this.inlineRenderer&&this.inlineEnabled){var t=e?null:this.popup.getData(this.popup.getRow());var i=a.getCompletionPrefix(this.editor);if(!this.inlineRenderer.show(this.editor,t,i)){this.inlineRenderer.hide()}if(this.popup.isMouseOver&&this.setSelectOnHover){this.tooltipTimer.call(null,null);return}}this.$updatePopupPosition();this.tooltipTimer.call(null,null)};e.prototype.$onPopupShow=function(e){this.$onPopupChange(e);this.stickySelection=false;if(this.stickySelectionDelay>=0)this.stickySelectionTimer.schedule(this.stickySelectionDelay)};e.prototype.observeLayoutChanges=function(){if(this.$elements||!this.editor)return;window.addEventListener("resize",this.onLayoutChange,{passive:true});window.addEventListener("wheel",this.mousewheelListener);var e=this.editor.container.parentNode;var t=[];while(e){t.push(e);e.addEventListener("scroll",this.onLayoutChange,{passive:true});e=e.parentNode}this.$elements=t};e.prototype.unObserveLayoutChanges=function(){var e=this;window.removeEventListener("resize",this.onLayoutChange,{passive:true});window.removeEventListener("wheel",this.mousewheelListener);this.$elements&&this.$elements.forEach(function(t){t.removeEventListener("scroll",e.onLayoutChange,{passive:true})});this.$elements=null};e.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition();this.updateDocTooltip()};e.prototype.$updatePopupPosition=function(){var e=this.editor;var t=e.renderer;var i=t.layerConfig.lineHeight;var n=t.$cursorLayer.getPixelPosition(this.base,true);n.left-=this.popup.getTextLeftOffset();var r=e.container.getBoundingClientRect();n.top+=r.top-t.layerConfig.offset;n.left+=r.left-e.renderer.scrollLeft;n.left+=t.gutterWidth;var o={top:n.top,left:n.left};if(t.$ghostText&&t.$ghostTextWidget){if(this.base.row===t.$ghostText.position.row){o.top+=t.$ghostTextWidget.el.offsetHeight}}if(this.popup.tryShow(o,i,"bottom")){return}if(this.popup.tryShow(n,i,"top")){return}this.popup.show(n,i)};e.prototype.openPopup=function(e,t,i){this.$firstOpenTimer.cancel();if(!this.popup)this.$init();if(this.inlineEnabled&&!this.inlineRenderer)this.$initInline();this.popup.autoSelect=this.autoSelect;this.popup.setSelectOnHover(this.setSelectOnHover);var n=this.popup.data[this.popup.getRow()];this.popup.setData(this.completions.filtered,this.completions.filterText);if(this.editor.textInput.setAriaOptions){this.editor.textInput.setAriaOptions({activeDescendant:s(this.popup.getRow()),inline:this.inlineEnabled})}e.keyBinding.addKeyboardHandler(this.keyboardHandler);var r=this.popup.data.indexOf(n);if(r&&this.stickySelection)this.popup.setRow(this.autoSelect?r:-1);else this.popup.setRow(this.autoSelect?0:-1);if(!i){this.popup.setTheme(e.getTheme());this.popup.setFontSize(e.getFontSize());this.$updatePopupPosition();if(this.tooltipNode){this.updateDocTooltip()}}else if(i&&!t){this.detach()}this.changeTimer.cancel();this.observeLayoutChanges()};e.prototype.detach=function(){if(this.editor){this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler);this.editor.off("changeSelection",this.changeListener);this.editor.off("blur",this.blurListener);this.editor.off("mousedown",this.mousedownListener);this.editor.off("mousewheel",this.mousewheelListener)}this.$firstOpenTimer.cancel();this.changeTimer.cancel();this.hideDocTooltip();if(this.completionProvider){this.completionProvider.detach()}if(this.popup&&this.popup.isOpen)this.popup.hide();if(this.base)this.base.detach();this.activated=false;this.completionProvider=this.completions=this.base=null;this.unObserveLayoutChanges()};e.prototype.changeListener=function(e){var t=this.editor.selection.lead;if(t.row!=this.base.row||t.column<this.base.column){this.detach()}if(this.activated)this.changeTimer.schedule();else this.detach()};e.prototype.blurListener=function(e){var t=document.activeElement;var i=this.editor.textInput.getElement();var n=e.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(e.relatedTarget);var r=this.popup&&this.popup.container;if(t!=i&&t.parentNode!=r&&!n&&t!=this.tooltipNode&&e.relatedTarget!=i){this.detach()}};e.prototype.mousedownListener=function(e){this.detach()};e.prototype.mousewheelListener=function(e){if(!this.popup.isMouseOver)this.detach()};e.prototype.mouseOutListener=function(e){if(this.popup.isOpen)this.$updatePopupPosition()};e.prototype.goTo=function(e){this.popup.goTo(e)};e.prototype.insertMatch=function(e,t){if(!e)e=this.popup.getData(this.popup.getRow());if(!e)return false;if(e.value==="")return this.detach();var i=this.completions;var n=this.getCompletionProvider().insertMatch(this.editor,e,i.filterText,t);if(this.completions==i)this.detach();return n};e.prototype.showPopup=function(e,t){if(this.editor)this.detach();this.activated=true;this.editor=e;if(e.completer!=this){if(e.completer)e.completer.detach();e.completer=this}e.on("changeSelection",this.changeListener);e.on("blur",this.blurListener);e.on("mousedown",this.mousedownListener);e.on("mousewheel",this.mousewheelListener);this.updateCompletions(false,t)};e.prototype.getCompletionProvider=function(e){if(!this.completionProvider)this.completionProvider=new g(e);return this.completionProvider};e.prototype.gatherCompletions=function(e,t){return this.getCompletionProvider().gatherCompletions(e,t)};e.prototype.updateCompletions=function(e,t){if(e&&this.base&&this.completions){var i=this.editor.getCursorPosition();var n=this.editor.session.getTextRange({start:this.base,end:i});if(n==this.completions.filterText)return;this.completions.setFilter(n);if(!this.completions.filtered.length)return this.detach();if(this.completions.filtered.length==1&&this.completions.filtered[0].value==n&&!this.completions.filtered[0].snippet)return this.detach();this.openPopup(this.editor,n,e);return}if(t&&t.matches){var i=this.editor.getSelectionRange().start;this.base=this.editor.session.doc.createAnchor(i.row,i.column);this.base.$insertRight=true;this.completions=new m(t.matches);return this.openPopup(this.editor,"",e)}var r=this.editor.getSession();var i=this.editor.getCursorPosition();var n=a.getCompletionPrefix(this.editor);this.base=r.doc.createAnchor(i.row,i.column-n.length);this.base.$insertRight=true;var o={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:n,pos:i}).provideCompletions(this.editor,o,function(t,i,n){var r=i.filtered;var o=a.getCompletionPrefix(this.editor);this.$firstOpenTimer.cancel();if(n){if(!r.length){var s=!this.autoShown&&this.emptyMessage;if(typeof s=="function")s=this.emptyMessage(o);if(s){var l=[{caption:s,value:""}];this.completions=new m(l);this.openPopup(this.editor,o,e);return}return this.detach()}if(r.length==1&&r[0].value==o&&!r[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&r.length==1)return this.insertMatch(r[0])}this.completions=i;this.openPopup(this.editor,o,e);this.popup.renderer.setStyle("ace_loading",!n)}.bind(this));if(!this.autoShown&&!(this.popup&&this.popup.isOpen)){this.$firstOpenTimer.delay(this.stickySelectionDelay/2)}};e.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()};e.prototype.updateDocTooltip=function(){var e=this.popup;var t=this.completions.filtered;var i=t&&(t[e.getHoveredRow()]||t[e.getRow()]);var n=null;if(!i||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();var r=this.editor.completers.length;for(var o=0;o<r;o++){var s=this.editor.completers[o];if(s.getDocTooltip&&i.completerId===s.id){n=s.getDocTooltip(i);break}}if(!n&&typeof i!="string")n=i;if(typeof n=="string")n={docText:n};if(!n||!(n.docHTML||n.docText))return this.hideDocTooltip();this.showDocTooltip(n)};e.prototype.showDocTooltip=function(e){if(!this.tooltipNode){this.tooltipNode=c.createElement("div");this.tooltipNode.style.margin=0;this.tooltipNode.style.pointerEvents="auto";this.tooltipNode.tabIndex=-1;this.tooltipNode.onblur=this.blurListener.bind(this);this.tooltipNode.onclick=this.onTooltipClick.bind(this);this.tooltipNode.id="doc-tooltip";this.tooltipNode.setAttribute("role","tooltip")}var t=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(t.isDark?"ace_dark ":"")+(t.cssClass||"");var i=this.tooltipNode;if(e.docHTML){i.innerHTML=e.docHTML}else if(e.docText){i.textContent=e.docText}if(!i.parentNode)this.popup.container.appendChild(this.tooltipNode);var n=this.popup;var r=n.container.getBoundingClientRect();i.style.top=n.container.style.top;i.style.bottom=n.container.style.bottom;i.style.display="block";if(window.innerWidth-r.right<320){if(r.left<320){if(n.isTopdown){i.style.top=r.bottom+"px";i.style.left=r.left+"px";i.style.right="";i.style.bottom=""}else{i.style.top=n.container.offsetTop-i.offsetHeight+"px";i.style.left=r.left+"px";i.style.right="";i.style.bottom=""}}else{i.style.right=window.innerWidth-r.left+"px";i.style.left=""}}else{i.style.left=r.right+1+"px";i.style.right=""}};e.prototype.hideDocTooltip=function(){this.tooltipTimer.cancel();if(!this.tooltipNode)return;var e=this.tooltipNode;if(!this.editor.isFocused()&&document.activeElement==e)this.editor.focus();this.tooltipNode=null;if(e.parentNode)e.parentNode.removeChild(e)};e.prototype.onTooltipClick=function(e){var t=e.target;while(t&&t!=this.tooltipNode){if(t.nodeName=="A"&&t.href){t.rel="noreferrer";t.target="_blank";break}t=t.parentNode}};e.prototype.destroy=function(){this.detach();if(this.popup){this.popup.destroy();var e=this.popup.container;if(e&&e.parentNode)e.parentNode.removeChild(e)}if(this.editor&&this.editor.completer==this){this.editor.off("destroy",f);this.editor.completer=null}this.inlineRenderer=this.popup=this.editor=null};return e}();d.prototype.commands={Up:function(e){e.completer.goTo("up")},Down:function(e){e.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(e){e.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(e){e.completer.goTo("end")},Esc:function(e){e.completer.detach()},Return:function(e){return e.completer.insertMatch()},"Shift-Return":function(e){e.completer.insertMatch(null,{deleteSuffix:true})},Tab:function(e){var t=e.completer.insertMatch();if(!t&&!e.tabstopManager)e.completer.goTo("down");else return t},PageUp:function(e){e.completer.popup.gotoPageUp()},PageDown:function(e){e.completer.popup.gotoPageDown()}};d.for=function(e){if(e.completer instanceof d){return e.completer}if(e.completer){e.completer.destroy();e.completer=null}if(h.get("sharedPopups")){if(!d.$sharedInstance)d.$sharedInstance=new d;e.completer=d.$sharedInstance}else{e.completer=new d;e.once("destroy",f)}return e.completer};d.startCommand={name:"startAutocomplete",exec:function(e,t){var i=d.for(e);i.autoInsert=false;i.autoSelect=true;i.autoShown=false;i.showPopup(e,t);i.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var g=function(){function e(e){this.initialPosition=e;this.active=true}e.prototype.insertByIndex=function(e,t,i){if(!this.completions||!this.completions.filtered){return false}return this.insertMatch(e,this.completions.filtered[t],i)};e.prototype.insertMatch=function(e,t,i){if(!t)return false;e.startOperation({command:{name:"insertMatch"}});if(t.completer&&t.completer.insertMatch){t.completer.insertMatch(e,t)}else{if(!this.completions)return false;var n=this.completions.filterText.length;var r=0;if(t.range&&t.range.start.row===t.range.end.row){n-=this.initialPosition.prefix.length;n+=this.initialPosition.pos.column-t.range.start.column;r+=t.range.end.column-this.initialPosition.pos.column}if(n||r){var o;if(e.selection.getAllRanges){o=e.selection.getAllRanges()}else{o=[e.getSelectionRange()]}for(var s=0,a;a=o[s];s++){a.start.column-=n;a.end.column+=r;e.session.remove(a)}}if(t.snippet){p.insertSnippet(e,t.snippet)}else{this.$insertString(e,t)}if(t.command&&t.command==="startAutocomplete"){e.execCommand(t.command)}}e.endOperation();return true};e.prototype.$insertString=function(e,t){var i=t.value||t;e.execCommand("insertstring",i)};e.prototype.gatherCompletions=function(e,t){var i=e.getSession();var n=e.getCursorPosition();var r=a.getCompletionPrefix(e);var o=[];this.completers=e.completers;var s=e.completers.length;e.completers.forEach(function(l,c){l.getCompletions(e,i,n,r,function(i,n){if(l.hideInlinePreview)n=n.map(function(e){return Object.assign(e,{hideInlinePreview:l.hideInlinePreview})});if(!i&&n)o=o.concat(n);t(null,{prefix:a.getCompletionPrefix(e),matches:o,finished:--s===0})})});return true};e.prototype.provideCompletions=function(e,t,i){var n=function(e){var n=e.prefix;var r=e.matches;this.completions=new m(r);if(t.exactMatch)this.completions.exactMatch=true;if(t.ignoreCaption)this.completions.ignoreCaption=true;this.completions.setFilter(n);if(e.finished||this.completions.filtered.length)i(null,this.completions,e.finished)}.bind(this);var r=true;var o=null;this.gatherCompletions(e,function(e,t){if(!this.active){return}if(e){i(e,[],true);this.detach()}var s=t.prefix;if(s.indexOf(t.prefix)!==0)return;if(r){o=t;return}n(t)}.bind(this));r=false;if(o){var s=o;o=null;n(s)}};e.prototype.detach=function(){this.active=false;this.completers&&this.completers.forEach(function(e){if(typeof e.cancel==="function"){e.cancel()}})};return e}();var m=function(){function e(e,t){this.all=e;this.filtered=e;this.filterText=t||"";this.exactMatch=false;this.ignoreCaption=false}e.prototype.setFilter=function(e){if(e.length>this.filterText&&e.lastIndexOf(this.filterText,0)===0)var t=this.filtered;else var t=this.all;this.filterText=e;t=this.filterCompletions(t,this.filterText);t=t.sort(function(e,t){return t.exactMatch-e.exactMatch||t.$score-e.$score||(e.caption||e.value).localeCompare(t.caption||t.value)});var i=null;t=t.filter(function(e){var t=e.snippet||e.caption||e.value;if(t===i)return false;i=t;return true});this.filtered=t};e.prototype.filterCompletions=function(e,t){var i=[];var n=t.toUpperCase();var r=t.toLowerCase();e:for(var o=0,s;s=e[o];o++){var a=!this.ignoreCaption&&s.caption||s.value||s.snippet;if(!a)continue;var l=-1;var c=0;var p=0;var h,u;if(this.exactMatch){if(t!==a.substr(0,t.length))continue e}else{var f=a.toLowerCase().indexOf(r);if(f>-1){p=f}else{for(var d=0;d<t.length;d++){var g=a.indexOf(r[d],l+1);var m=a.indexOf(n[d],l+1);h=g>=0?m<0||g<m?g:m:m;if(h<0)continue e;u=h-l-1;if(u>0){if(l===-1)p+=10;p+=u;c=c|1<<d}l=h}}}s.matchMask=c;s.exactMatch=p?0:1;s.$score=(s.score||0)-p;i.push(s)}return i};return e}();t.Autocomplete=d;t.CompletionProvider=g;t.FilteredList=m});ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(e,t,i){var n=e("../range").Range;var r=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;function o(e,t){var i=e.getTextRange(n.fromPoints({row:0,column:0},t));return i.split(r).length-1}function s(e,t){var i=o(e,t);var n=e.getValue().split(r);var s=Object.create(null);var a=n[i];n.forEach(function(e,t){if(!e||e===a)return;var r=Math.abs(i-t);var o=n.length-r;if(s[e]){s[e]=Math.max(o,s[e])}else{s[e]=o}});return s}t.getCompletions=function(e,t,i,n,r){var o=s(t,i);var a=Object.keys(o);r(null,a.map(function(e){return{caption:e,value:e,score:o[e],meta:"local"}}))}});ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(e,t,i){"use strict";var n=e("../snippets").snippetManager;var r=e("../autocomplete").Autocomplete;var o=e("../config");var s=e("../lib/lang");var a=e("../autocomplete/util");var l=e("../autocomplete/text_completer");var c={getCompletions:function(e,t,i,n,r){if(t.$mode.completer){return t.$mode.completer.getCompletions(e,t,i,n,r)}var o=e.session.getState(i.row);var s=t.$mode.getCompletions(o,t,i,n);s=s.map(function(e){e.completerId=c.id;return e});r(null,s)},id:"keywordCompleter"};var p=function(e){var t={};return e.replace(/\${(\d+)(:(.*?))?}/g,function(e,i,n,r){return t[i]=r||""}).replace(/\$(\d+?)/g,function(e,i){return t[i]})};var h={getCompletions:function(e,t,i,r,o){var s=[];var a=t.getTokenAt(i.row,i.column);if(a&&a.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/))s.push("html-tag");else s=n.getActiveScopes(e);var l=n.snippetMap;var c=[];s.forEach(function(e){var t=l[e]||[];for(var i=t.length;i--;){var n=t[i];var r=n.name||n.tabTrigger;if(!r)continue;c.push({caption:r,snippet:n.content,meta:n.tabTrigger&&!n.name?n.tabTrigger+"⇥ ":"snippet",completerId:h.id})}},this);o(null,c)},getDocTooltip:function(e){if(e.snippet&&!e.docHTML){e.docHTML=["<b>",s.escapeHTML(e.caption),"</b>","<hr></hr>",s.escapeHTML(p(e.snippet))].join("")}},id:"snippetCompleter"};var u=[h,l,c];t.setCompleters=function(e){u.length=0;if(e)u.push.apply(u,e)};t.addCompleter=function(e){u.push(e)};t.textCompleter=l;t.keyWordCompleter=c;t.snippetCompleter=h;var f={name:"expandSnippet",exec:function(e){return n.expandWithTab(e)},bindKey:"Tab"};var d=function(e,t){g(t.session.$mode)};var g=function(e){if(typeof e=="string")e=o.$modes[e];if(!e)return;if(!n.files)n.files={};m(e.$id,e.snippetFileId);if(e.modes)e.modes.forEach(g)};var m=function(e,t){if(!t||!e||n.files[e])return;n.files[e]={};o.loadModule(t,function(t){if(!t)return;n.files[e]=t;if(!t.snippets&&t.snippetText)t.snippets=n.parseSnippetFile(t.snippetText);n.register(t.snippets||[],t.scope);if(t.includeScopes){n.snippetMap[t.scope].includeScopes=t.includeScopes;t.includeScopes.forEach(function(e){g("ace/mode/"+e)})}})};var v=function(e){var t=e.editor;var i=t.completer&&t.completer.activated;if(e.command.name==="backspace"){if(i&&!a.getCompletionPrefix(t))t.completer.detach()}else if(e.command.name==="insertstring"&&!i){b=e;var n=e.editor.$liveAutocompletionDelay;if(n){y.delay(n)}else{x(e)}}};var b;var y=s.delayedCall(function(){x(b)},0);var x=function(e){var t=e.editor;var i=a.getCompletionPrefix(t);var n=a.triggerAutocomplete(t);if(i&&i.length>=t.$liveAutocompletionThreshold||n){var o=r.for(t);o.autoShown=true;o.showPopup(t)}};var w=e("../editor").Editor;e("../config").defineOptions(w.prototype,"editor",{enableBasicAutocompletion:{set:function(e){if(e){if(!this.completers)this.completers=Array.isArray(e)?e:u;this.commands.addCommand(r.startCommand)}else{this.commands.removeCommand(r.startCommand)}},value:false},enableLiveAutocompletion:{set:function(e){if(e){if(!this.completers)this.completers=Array.isArray(e)?e:u;this.commands.on("afterExec",v)}else{this.commands.off("afterExec",v)}},value:false},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(e){if(e){this.commands.addCommand(f);this.on("changeMode",d);d(null,this)}else{this.commands.removeCommand(f);this.off("changeMode",d)}},value:false}})});(function(){ace.require(["ace/ext/language_tools"],function(e){if(typeof module=="object"&&typeof exports=="object"&&module){module.exports=e}})})();
//# sourceMappingURL=ext-language_tools.js.map