
/*
 * This file is part of AdaptiveCpp, an implementation of SYCL and C++ standard
 * parallelism for CPUs and GPUs.
 *
 * Copyright The AdaptiveCpp Contributors
 *
 * AdaptiveCpp is released under the BSD 2-Clause "Simplified" License.
 * See file LICENSE in the project root for full license details.
 */
// SPDX-License-Identifier: BSD-2-Clause

#ifndef ACPP_PCUDA_CUDA_PREFIXED_RUNTIME_HPP
#define ACPP_PCUDA_CUDA_PREFIXED_RUNTIME_HPP

#include "../pcuda.hpp"

#define CUDA_KERNEL_NAME(...) PCUDA_KERNEL_NAME(__VA_ARGS__)
#define CUDA_SYMBOL(...) PCUDA_SYMBOL(__VA_ARGS__)
#define cudaLaunchKernelGGL(...) pcudaLaunchKernelGGL(__VA_ARGS__)

#define cudaMalloc pcudaMalloc

#define cudaSuccess pcudaSuccess
#define cudaErrorMissingConfiguration pcudaErrorMissingConfiguration
#define cudaErrorMemoryAllocation pcudaErrorMemoryAllocation
#define cudaErrorInitializationError pcudaErrorInitializationError
#define cudaErrorLaunchFailure pcudaErrorLaunchFailure
#define cudaErrorPriorLaunchFailure pcudaErrorPriorLaunchFailure
#define cudaErrorLaunchTimeout pcudaErrorLaunchTimeout
#define cudaErrorLaunchOutOfResources pcudaErrorLaunchOutOfResources
#define cudaErrorInvalidDeviceFunction pcudaErrorInvalidDeviceFunction
#define cudaErrorInvalidConfiguration pcudaErrorInvalidConfiguration
#define cudaErrorInvalidDevice pcudaErrorInvalidDevice
#define cudaErrorInvalidValue pcudaErrorInvalidValue
#define cudaErrorInvalidPitchValue pcudaErrorInvalidPitchValue
#define cudaErrorInvalidSymbol pcudaErrorInvalidSymbol
#define cudaErrorMapBufferObjectFailed pcudaErrorMapBufferObjectFailed
#define cudaErrorUnmapBufferObjectFailed pcudaErrorUnmapBufferObjectFailed
#define cudaErrorInvalidHostPointer pcudaErrorInvalidHostPointer
#define cudaErrorInvalidDevicePointer pcudaErrorInvalidDevicePointer
#define cudaErrorInvalidTexture pcudaErrorInvalidTexture
#define cudaErrorInvalidTextureBinding pcudaErrorInvalidTextureBinding
#define cudaErrorInvalidChannelDescriptor pcudaErrorInvalidChannelDescriptor
#define cudaErrorInvalidMemcpyDirection pcudaErrorInvalidMemcpyDirection
#define cudaErrorAddressOfConstant pcudaErrorAddressOfConstant
#define cudaErrorTextureFetchFailed pcudaErrorTextureFetchFailed
#define cudaErrorTextureNotBound pcudaErrorTextureNotBound
#define cudaErrorSynchronizationError pcudaErrorSynchronizationError
#define cudaErrorInvalidFilterSetting pcudaErrorInvalidFilterSetting
#define cudaErrorInvalidNormSetting pcudaErrorInvalidNormSetting
#define cudaErrorMixedDeviceExecution pcudaErrorMixedDeviceExecution
#define cudaErrorCudartUnloading pcudaErrorCudartUnloading
#define cudaErrorUnknown pcudaErrorUnknown
#define cudaErrorNotYetImplemented pcudaErrorNotYetImplemented
#define cudaErrorMemoryValueTooLarge pcudaErrorMemoryValueTooLarge
#define cudaErrorInvalidResourceHandle pcudaErrorInvalidResourceHandle
#define cudaErrorNotReady pcudaErrorNotReady
#define cudaErrorInsufficientDriver pcudaErrorInsufficientDriver
#define cudaErrorSetOnActiveProcess pcudaErrorSetOnActiveProcess
#define cudaErrorInvalidSurface pcudaErrorInvalidSurface
#define cudaErrorNoDevice pcudaErrorNoDevice
#define cudaErrorECCUncorrectable pcudaErrorECCUncorrectable
#define cudaErrorSharedObjectSymbolNotFound pcudaErrorSharedObjectSymbolNotFound
#define cudaErrorSharedObjectInitFailed pcudaErrorSharedObjectInitFailed
#define cudaErrorUnsupportedLimit pcudaErrorUnsupportedLimit
#define cudaErrorDuplicateVariableName pcudaErrorDuplicateVariableName
#define cudaErrorDuplicateTextureName pcudaErrorDuplicateTextureName
#define cudaErrorDuplicateSurfaceName pcudaErrorDuplicateSurfaceName
#define cudaErrorDevicesUnavailable pcudaErrorDevicesUnavailable
#define cudaErrorInvalidKernelImage pcudaErrorInvalidKernelImage
#define cudaErrorNoKernelImageForDevice pcudaErrorNoKernelImageForDevice
#define cudaErrorIncompatibleDriverContext pcudaErrorIncompatibleDriverContext
#define cudaErrorPeerAccessAlreadyEnabled pcudaErrorPeerAccessAlreadyEnabled
#define cudaErrorPeerAccessNotEnabled pcudaErrorPeerAccessNotEnabled
#define cudaErrorDeviceAlreadyInUse pcudaErrorDeviceAlreadyInUse
#define cudaErrorProfilerDisabled pcudaErrorProfilerDisabled
#define cudaErrorProfilerNotInitialized pcudaErrorProfilerNotInitialized
#define cudaErrorProfilerAlreadyStarted pcudaErrorProfilerAlreadyStarted
#define cudaErrorProfilerAlreadyStopped pcudaErrorProfilerAlreadyStopped
#define cudaErrorStartupFailure pcudaErrorStartupFailure
#define cudaErrorApiFailureBase pcudaErrorApiFailureBase

#define cudaError pcudaError
#define cudaError_t pcudaError_t
#define cudaStream_t pcudaStream_t

#define cudaDriverGetVersion pcudaDriverGetVersion

#define cudaGetDeviceCount pcudaGetDeviceCount
#define cudaGetDevice pcudaGetDevice
#define cudaSetDevice pcudaSetDevice

// Getters/setters for platforms are pcuda extensions and therefore not aliased

#define cudaGetLastError pcudaGetLastError
#define cudaPeekAtLastError pcudaPeekAtLastError
#define cudaGetErrorName pcudaGetErrorName
#define cudaGetErrorString pcudaGetErrorString

#define cudaDeviceSynchronize pcudaDeviceSynchronize
#define cudaThreadSynchronize pcudaThreadSynchronize

#define cudaMalloc pcudaMalloc
#define cudaMallocHost pcudaMallocHost
#define cudaHostAlloc pcudaHostAlloc

#define cudaHostAllocDefault pcudaHostAllocDefault
#define cudaHostAllocMapped pcudaHostAllocMapped
#define cudaHostAllocPortable pcudaHostAllocPortable
#define cudaHostAllocWriteCombined pcudaHostAllocWriteCombined

#define cudaMemAttachGlobal pcudaMemAttachGlobal
#define cudaMemAttachHost pcudaMemAttachHost
#define cudaMemAttachSingle pcudaMemAttachSingle
#define cudaMallocManaged pcudaMallocManaged

#define cudaFree pcudaFree
#define cudaFreeHost pcudaFreeHost

#define cudaStreamDefault pcudaStreamDefault
#define cudaStreamNonBlocking pcudaStreamNonBlocking

#define cudaStreamCreate pcudaStreamCreate
#define cudaStreamCreateWithFlags pcudaStreamCreateWithFlags
#define cudaStreamCreateWithPriority pcudaStreamCreateWithPriority
#define cudaStreamDestroy pcudaStreamDestroy
#define cudaStreamSynchronize pcudaStreamSynchronize
#define cudaStreamWaitEvent pcudaStreamWaitEvent

#define cudaMemcpyKind pcudaMemcpyKind
#define cudaMemcpyHostToHost pcudaMemcpyHostToHost
#define cudaMemcpyHostToDevice pcudaMemcpyHostToDevice
#define cudaMemcpyDeviceToHost pcudaMemcpyDeviceToHost
#define cudaMemcpyDeviceToDevice pcudaMemcpyDeviceToDevice
#define cudaMemcpyDefault pcudaMemcpyDefault
#define cudaMemcpy pcudaMemcpy
#define cudaMemcpyAsync pcudaMemcpyAsync
#define cudaMemset pcudaMemset
#define cudaMemsetAsync pcudaMemsetAsync


#define cudaEvent_t pcudaEvent_t
#define cudaEventCreate pcudaEventCreate
#define cudaEventCreateWithFlags pcudaEventCreateWithFlags
#define cudaEventBlockingSync pcudaEventBlockingSync
#define cudaEventDefault pcudaEventDefault
#define cudaEventDisableTiming pcudaEventDisableTiming
#define cudaEventInterprocess pcudaEventInterprocess
#define cudaEventRecordDefault pcudaEventRecordDefault
#define cudaEventRecordExternal pcudaEventRecordExternal
#define cudaEventWaitDefault pcudaEventWaitDefault
#define cudaEventWaitExternal pcudaEventWaitExternal

#define cudaEventDestroy pcudaEventDestroy
#define cudaEventQuery pcudaEventQuery
#define cudaEventRecord pcudaEventRecord
#define cudaEventRecordWithFlags pcudaEventRecordWithFlags
#define cudaEventSynchronize pcudaEventSynchronize

#define cudaComputeMode pcudaComputeMode
#define cudaComputeModeDefault pcudaComputeModeDefault
#define cudaComputeModeExclusive pcudaComputeModeExclusive
#define cudaComputeModeProhibited pcudaComputeModeProhibited
#define cudaComputeModeExclusiveProcess pcudaComputeModeExclusiveProcess

#define cudaDeviceProp pcudaDeviceProp
#define cudaGetDeviceProperties pcudaGetDeviceProperties


#endif
