/*
 * This file is part of AdaptiveCpp, an implementation of SYCL and C++ standard
 * parallelism for CPUs and GPUs.
 *
 * Copyright The AdaptiveCpp Contributors
 *
 * AdaptiveCpp is released under the BSD 2-Clause "Simplified" License.
 * See file LICENSE in the project root for full license details.
 */
// SPDX-License-Identifier: BSD-2-Clause
#ifndef HIPSYCL_SSCP_PTX_LIBDEVICE_INTERFACE_HPP
#define HIPSYCL_SSCP_PTX_LIBDEVICE_INTERFACE_HPP

#include "../builtin_config.hpp"

extern "C" __acpp_int32 __nv_clz (__acpp_int32);
extern "C" __acpp_int32 __nv_clzll (__acpp_int64);
extern "C" __acpp_int32 __nv_popc (__acpp_int32);
extern "C" __acpp_int32 __nv_popcll (__acpp_int64);
extern "C" __acpp_int32 __nv_byte_perm (__acpp_int32, __acpp_int32, __acpp_int32);
extern "C" __acpp_int32 __nv_min (__acpp_int32, __acpp_int32);
extern "C" __acpp_uint32 __nv_umin (__acpp_uint32, __acpp_uint32);
extern "C" __acpp_int64 __nv_llmin (__acpp_int64, __acpp_int64);
extern "C" __acpp_uint64 __nv_ullmin (__acpp_uint64, __acpp_uint64);
extern "C" __acpp_int32 __nv_max (__acpp_int32, __acpp_int32);
extern "C" __acpp_uint32 __nv_umax (__acpp_uint32, __acpp_uint32);
extern "C" __acpp_int64 __nv_llmax (__acpp_int64, __acpp_int64);
extern "C" __acpp_uint64 __nv_ullmax (__acpp_uint64, __acpp_uint64);
extern "C" __acpp_int32 __nv_mulhi (__acpp_int32, __acpp_int32);
extern "C" __acpp_uint32 __nv_umulhi (__acpp_uint32, __acpp_uint32);
extern "C" __acpp_int64 __nv_mul64hi (__acpp_int64, __acpp_int64);
extern "C" __acpp_uint64 __nv_umul64hi (__acpp_uint64, __acpp_uint64);
extern "C" __acpp_int32 __nv_mul24 (__acpp_int32, __acpp_int32);
extern "C" __acpp_uint32 __nv_umul24 (__acpp_uint32, __acpp_uint32);
extern "C" __acpp_int32 __nv_brev (__acpp_int32);
extern "C" __acpp_int64 __nv_brevll (__acpp_int64);
extern "C" __acpp_int32 __nv_sad (__acpp_int32, __acpp_int32, __acpp_int32);
extern "C" __acpp_uint32 __nv_usad (__acpp_uint32, __acpp_uint32, __acpp_uint32);
extern "C" __acpp_int32 __nv_abs (__acpp_int32);
extern "C" __acpp_int64 __nv_llabs (__acpp_int64);
extern "C" float __nv_floorf (float);
extern "C" double __nv_floor (double);
extern "C" float __nv_fabsf (float);
extern "C" double __nv_fabs (double);
extern "C" double __nv_rcp64h (double);
extern "C" float __nv_fminf (float, float);
extern "C" float __nv_fmaxf (float, float);
extern "C" float __nv_rsqrtf (float);
extern "C" double __nv_fmin (double, double);
extern "C" double __nv_fmax (double, double);
extern "C" double __nv_rsqrt (double);
extern "C" double __nv_ceil (double);
extern "C" double __nv_trunc (double);
extern "C" float __nv_exp2f (float);
extern "C" float __nv_truncf (float);
extern "C" float __nv_ceilf (float);
extern "C" float __nv_saturatef (float);
extern "C" float __nv_fmaf_rn (float, float, float);
extern "C" float __nv_fmaf_rz (float, float, float);
extern "C" float __nv_fmaf_rd (float, float, float);
extern "C" float __nv_fmaf_ru (float, float, float);
extern "C" float __nv_fmaf_ieee_rn (float, float, float);
extern "C" float __nv_fmaf_ieee_rz (float, float, float);
extern "C" float __nv_fmaf_ieee_rd (float, float, float);
extern "C" float __nv_fmaf_ieee_ru (float, float, float);
extern "C" double __nv_fma_rn (double, double, double);
extern "C" double __nv_fma_rz (double, double, double);
extern "C" double __nv_fma_rd (double, double, double);
extern "C" double __nv_fma_ru (double, double, double);
extern "C" float __nv_fast_fdividef (float, float);
extern "C" float __nv_fdiv_rn (float, float);
extern "C" float __nv_fdiv_rz (float, float);
extern "C" float __nv_fdiv_rd (float, float);
extern "C" float __nv_fdiv_ru (float, float);
extern "C" float __nv_frcp_rn (float);
extern "C" float __nv_frcp_rz (float);
extern "C" float __nv_frcp_rd (float);
extern "C" float __nv_frcp_ru (float);
extern "C" float __nv_fsqrt_rn (float);
extern "C" float __nv_fsqrt_rz (float);
extern "C" float __nv_fsqrt_rd (float);
extern "C" float __nv_fsqrt_ru (float);
extern "C" double __nv_ddiv_rn (double, double);
extern "C" double __nv_ddiv_rz (double, double);
extern "C" double __nv_ddiv_rd (double, double);
extern "C" double __nv_ddiv_ru (double, double);
extern "C" double __nv_drcp_rn (double);
extern "C" double __nv_drcp_rz (double);
extern "C" double __nv_drcp_rd (double);
extern "C" double __nv_drcp_ru (double);
extern "C" double __nv_dsqrt_rn (double);
extern "C" double __nv_dsqrt_rz (double);
extern "C" double __nv_dsqrt_rd (double);
extern "C" double __nv_dsqrt_ru (double);
extern "C" float __nv_sqrtf (float);
extern "C" double __nv_sqrt (double);
extern "C" double __nv_dadd_rn (double, double);
extern "C" double __nv_dadd_rz (double, double);
extern "C" double __nv_dadd_rd (double, double);
extern "C" double __nv_dadd_ru (double, double);
extern "C" double __nv_dmul_rn (double, double);
extern "C" double __nv_dmul_rz (double, double);
extern "C" double __nv_dmul_rd (double, double);
extern "C" double __nv_dmul_ru (double, double);
extern "C" float __nv_fadd_rd (float, float);
extern "C" float __nv_fadd_ru (float, float);
extern "C" float __nv_fmul_rd (float, float);
extern "C" float __nv_fmul_ru (float, float);
extern "C" float __nv_fadd_rn (float, float);
extern "C" float __nv_fadd_rz (float, float);
extern "C" float __nv_fmul_rn (float, float);
extern "C" float __nv_fmul_rz (float, float);
extern "C" float __nv_double2float_rn (double);
extern "C" float __nv_double2float_rz (double);
extern "C" float __nv_double2float_rd (double);
extern "C" float __nv_double2float_ru (double);
extern "C" __acpp_int32 __nv_double2int_rn (double);
extern "C" __acpp_int32 __nv_double2int_rz (double);
extern "C" __acpp_int32 __nv_double2int_rd (double);
extern "C" __acpp_int32 __nv_double2int_ru (double);
extern "C" __acpp_int32 __nv_double2uint_rn (double);
extern "C" __acpp_int32 __nv_double2uint_rz (double);
extern "C" __acpp_int32 __nv_double2uint_rd (double);
extern "C" __acpp_int32 __nv_double2uint_ru (double);
extern "C" double __nv_int2double_rn (__acpp_int32);
extern "C" double __nv_uint2double_rn (__acpp_uint32);
extern "C" __acpp_int32 __nv_float2int_rn (float);
extern "C" __acpp_int32 __nv_float2int_rz (float);
extern "C" __acpp_int32 __nv_float2int_rd (float);
extern "C" __acpp_int32 __nv_float2int_ru (float);
extern "C" __acpp_uint32 __nv_float2uint_rn (float);
extern "C" __acpp_uint32 __nv_float2uint_rz (float);
extern "C" __acpp_uint32 __nv_float2uint_rd (float);
extern "C" __acpp_uint32 __nv_float2uint_ru (float);
extern "C" float __nv_int2float_rn (__acpp_int32);
extern "C" float __nv_int2float_rz (__acpp_int32);
extern "C" float __nv_int2float_rd (__acpp_int32);
extern "C" float __nv_int2float_ru (__acpp_int32);
extern "C" float __nv_uint2float_rn (__acpp_uint32);
extern "C" float __nv_uint2float_rz (__acpp_uint32);
extern "C" float __nv_uint2float_rd (__acpp_uint32);
extern "C" float __nv_uint2float_ru (__acpp_uint32);
extern "C" double __nv_hiloint2double (__acpp_int32, __acpp_int32);
extern "C" __acpp_int32 __nv_double2loint (double);
extern "C" __acpp_int32 __nv_double2hiint (double);
extern "C" __acpp_int64 __nv_float2ll_rn (float);
extern "C" __acpp_int64 __nv_float2ll_rz (float);
extern "C" __acpp_int64 __nv_float2ll_rd (float);
extern "C" __acpp_int64 __nv_float2ll_ru (float);
extern "C" __acpp_uint64 __nv_float2ull_rn (float);
extern "C" __acpp_uint64 __nv_float2ull_rz (float);
extern "C" __acpp_uint64 __nv_float2ull_rd (float);
extern "C" __acpp_uint64 __nv_float2ull_ru (float);
extern "C" __acpp_int64 __nv_double2ll_rn (double);
extern "C" __acpp_int64 __nv_double2ll_rz (double);
extern "C" __acpp_int64 __nv_double2ll_rd (double);
extern "C" __acpp_int64 __nv_double2ll_ru (double);
extern "C" __acpp_uint64 __nv_double2ull_rn (double);
extern "C" __acpp_uint64 __nv_double2ull_rz (double);
extern "C" __acpp_uint64 __nv_double2ull_rd (double);
extern "C" __acpp_uint64 __nv_double2ull_ru (double);
extern "C" float __nv_ll2float_rn (__acpp_int64);
extern "C" float __nv_ll2float_rz (__acpp_int64);
extern "C" float __nv_ll2float_rd (__acpp_int64);
extern "C" float __nv_ll2float_ru (__acpp_int64);
extern "C" float __nv_ull2float_rn (__acpp_uint64);
extern "C" float __nv_ull2float_rz (__acpp_uint64);
extern "C" float __nv_ull2float_rd (__acpp_uint64);
extern "C" float __nv_ull2float_ru (__acpp_uint64);
extern "C" double __nv_ll2double_rn (__acpp_int64);
extern "C" double __nv_ll2double_rz (__acpp_int64);
extern "C" double __nv_ll2double_rd (__acpp_int64);
extern "C" double __nv_ll2double_ru (__acpp_int64);
extern "C" double __nv_ull2double_rn (__acpp_uint64);
extern "C" double __nv_ull2double_rz (__acpp_uint64);
extern "C" double __nv_ull2double_rd (__acpp_uint64);
extern "C" double __nv_ull2double_ru (__acpp_uint64);
extern "C" __acpp_int16 __nv_float2half_rn(float);
extern "C" float __nv_half2float (__acpp_int16);
extern "C" float __nv_int_as_float (__acpp_int32);
extern "C" __acpp_int32 __nv_float_as_int (float);
extern "C" float __nv_uint_as_float (__acpp_uint32);
extern "C" __acpp_uint32 __nv_float_as_uint (float);
extern "C" double __nv_longlong_as_double (__acpp_int64);
extern "C" __acpp_int64 __nv_double_as_longlong (double);
extern "C" float __nv_fast_sinf (float);
extern "C" float __nv_fast_cosf (float);
extern "C" float __nv_fast_log2f (float);
extern "C" float __nv_fast_logf (float);
extern "C" float __nv_fast_expf (float);
extern "C" float __nv_fast_tanf (float);
extern "C" void __nv_fast_sincosf (float, float*, float*);
extern "C" float __nv_fast_exp10f (float);
extern "C" float __nv_fast_log10f (float);
extern "C" float __nv_fast_powf (float, float);
extern "C" __acpp_int32 __nv_hadd (__acpp_int32, __acpp_int32);
extern "C" __acpp_int32 __nv_rhadd (__acpp_int32, __acpp_int32);
extern "C" __acpp_uint32 __nv_uhadd (__acpp_uint32, __acpp_uint32);
extern "C" __acpp_uint32 __nv_urhadd (__acpp_uint32, __acpp_uint32);
extern "C" float __nv_fsub_rn (float, float);
extern "C" float __nv_fsub_rz (float, float);
extern "C" float __nv_fsub_rd (float, float);
extern "C" float __nv_fsub_ru (float, float);
extern "C" float __nv_frsqrt_rn (float);
extern "C" __acpp_int32 __nv_ffs (__acpp_int32);
extern "C" __acpp_int32 __nv_ffsll (__acpp_int64);
extern "C" float __nv_rintf (float);
extern "C" __acpp_int64 __nv_llrintf (float);
extern "C" float __nv_nearbyintf (float);
extern "C" __acpp_int32 __nv_isnanf (float);
extern "C" __acpp_int32 __nv_signbitf (float);
extern "C" float __nv_copysignf (float, float);
extern "C" __acpp_int32 __nv_finitef (float);
extern "C" __acpp_int32 __nv_isinff (float);
extern "C" float __nv_nextafterf (float, float);
extern "C" float __nv_nanf (__acpp_int8*);
extern "C" float __nv_sinf (float);
extern "C" float __nv_cosf (float);
extern "C" void __nv_sincosf (float, float*, float*);
extern "C" float __nv_sinpif (float);
extern "C" float __nv_cospif (float);
extern "C" void __nv_sincospif (float, float*, float*);
extern "C" float __nv_tanf (float);
extern "C" float __nv_log2f (float);
extern "C" float __nv_expf (float);
extern "C" float __nv_exp10f (float);
extern "C" float __nv_coshf (float);
extern "C" float __nv_sinhf (float);
extern "C" float __nv_tanhf (float);
extern "C" float __nv_atan2f (float, float);
extern "C" float __nv_atanf (float);
extern "C" float __nv_asinf (float);
extern "C" float __nv_acosf (float);
extern "C" float __nv_logf (float);
extern "C" float __nv_log10f (float);
extern "C" float __nv_log1pf (float);
extern "C" float __nv_acoshf (float);
extern "C" float __nv_asinhf (float);
extern "C" float __nv_atanhf (float);
extern "C" float __nv_expm1f (float);
extern "C" float __nv_hypotf (float, float);
extern "C" float __nv_rhypotf (float, float);
extern "C" float __nv_norm3df (float, float, float);
extern "C" float __nv_rnorm3df (float, float, float);
extern "C" float __nv_norm4df (float, float, float, float);
extern "C" float __nv_rnorm4df (float, float, float, float);
extern "C" float __nv_normf (__acpp_int32, float*);
extern "C" float __nv_rnormf (__acpp_int32, float*);
extern "C" float __nv_cbrtf (float);
extern "C" float __nv_rcbrtf (float);
extern "C" float __nv_j0f (float);
extern "C" float __nv_j1f (float);
extern "C" float __nv_y0f (float);
extern "C" float __nv_y1f (float);
extern "C" float __nv_ynf (__acpp_int32, float);
extern "C" float __nv_jnf (__acpp_int32, float);
extern "C" float __nv_cyl_bessel_i0f (float);
extern "C" float __nv_cyl_bessel_i1f (float);
extern "C" float __nv_erff (float);
extern "C" float __nv_erfinvf (float);
extern "C" float __nv_erfcf (float);
extern "C" float __nv_erfcxf (float);
extern "C" float __nv_erfcinvf (float);
extern "C" float __nv_normcdfinvf (float);
extern "C" float __nv_normcdff (float);
extern "C" float __nv_lgammaf (float);
extern "C" float __nv_ldexpf (float, __acpp_int32);
extern "C" float __nv_scalbnf (float, __acpp_int32);
extern "C" float __nv_frexpf (float, __acpp_int32*);
extern "C" float __nv_modff (float, float*);
extern "C" float __nv_fmodf (float, float);
extern "C" float __nv_remainderf (float, float);
extern "C" float __nv_remquof (float, float, __acpp_int32*);
extern "C" float __nv_fmaf (float, float, float);
extern "C" float __nv_powif (float, __acpp_int32);
extern "C" double __nv_powi (double, __acpp_int32);
extern "C" float __nv_powf (float, float);
extern "C" float __nv_tgammaf (float);
extern "C" float __nv_roundf (float);
extern "C" __acpp_int64 __nv_llroundf (float);
extern "C" float __nv_fdimf (float, float);
extern "C" __acpp_int32 __nv_ilogbf (float);
extern "C" float __nv_logbf (float);
extern "C" double __nv_rint (double);
extern "C" __acpp_int64 __nv_llrint (double);
extern "C" double __nv_nearbyint (double);
extern "C" __acpp_int32 __nv_signbitd (double);
extern "C" __acpp_int32 __nv_isfinited (double);
extern "C" __acpp_int32 __nv_isinfd (double);
extern "C" __acpp_int32 __nv_isnand (double);
extern "C" double __nv_copysign (double, double);
extern "C" void __nv_sincos (double, double*, double*);
extern "C" void __nv_sincospi (double, double*, double*);
extern "C" double __nv_sin (double);
extern "C" double __nv_cos (double);
extern "C" double __nv_sinpi (double);
extern "C" double __nv_cospi (double);
extern "C" double __nv_tan (double);
extern "C" double __nv_log (double);
extern "C" double __nv_log2 (double);
extern "C" double __nv_log10 (double);
extern "C" double __nv_log1p (double);
extern "C" double __nv_exp (double);
extern "C" double __nv_exp2 (double);
extern "C" double __nv_exp10 (double);
extern "C" double __nv_expm1 (double);
extern "C" double __nv_cosh (double);
extern "C" double __nv_sinh (double);
extern "C" double __nv_tanh (double);
extern "C" double __nv_atan2 (double, double);
extern "C" double __nv_atan (double);
extern "C" double __nv_asin (double);
extern "C" double __nv_acos (double);
extern "C" double __nv_acosh (double);
extern "C" double __nv_asinh (double);
extern "C" double __nv_atanh (double);
extern "C" double __nv_hypot (double, double);
extern "C" double __nv_rhypot (double, double);
extern "C" double __nv_norm3d (double, double, double);
extern "C" double __nv_rnorm3d (double, double, double);
extern "C" double __nv_norm4d (double, double, double, double);
extern "C" double __nv_rnorm4d (double, double, double, double);
extern "C" double __nv_norm (__acpp_int32, double*);
extern "C" double __nv_rnorm (__acpp_int32, double*);
extern "C" double __nv_cbrt (double);
extern "C" double __nv_rcbrt (double);
extern "C" double __nv_pow (double, double);
extern "C" double __nv_j0 (double);
extern "C" double __nv_j1 (double);
extern "C" double __nv_y0 (double);
extern "C" double __nv_y1 (double);
extern "C" double __nv_yn (__acpp_int32, double);
extern "C" double __nv_jn (__acpp_int32, double);
extern "C" double __nv_cyl_bessel_i0 (double);
extern "C" double __nv_cyl_bessel_i1 (double);
extern "C" double __nv_erf (double);
extern "C" double __nv_erfinv (double);
extern "C" double __nv_erfcinv (double);
extern "C" double __nv_normcdfinv (double);
extern "C" double __nv_erfc (double);
extern "C" double __nv_erfcx (double);
extern "C" double __nv_normcdf (double);
extern "C" double __nv_tgamma (double);
extern "C" double __nv_lgamma (double);
extern "C" double __nv_ldexp (double, __acpp_int32);
extern "C" double __nv_scalbn (double, __acpp_int32);
extern "C" double __nv_frexp (double, __acpp_int32*);
extern "C" double __nv_modf (double, double*);
extern "C" double __nv_fmod (double, double);
extern "C" double __nv_remainder (double, double);
extern "C" double __nv_remquo (double, double, __acpp_int32*);
extern "C" double __nv_nextafter (double, double);
extern "C" double __nv_nan (__acpp_int8*);
extern "C" double __nv_round (double);
extern "C" __acpp_int64 __nv_llround (double);
extern "C" double __nv_fdim (double, double);
extern "C" __acpp_int32 __nv_ilogb (double);
extern "C" double __nv_logb (double);
extern "C" double __nv_fma (double, double, double);
extern "C" double __nv_dsub_rn (double, double);
extern "C" double __nv_dsub_rz (double, double);
extern "C" double __nv_dsub_ru (double, double);
extern "C" double __nv_dsub_rd (double, double);

#endif
