//#include "LinkDef.h"

#include <vector>
#include <TLorentzVector.h>
#include <TROOT.h>
#include <TChain.h>
#include <TFile.h>
#include <TSelector.h>
#include <TObjArray.h>
#include <TH1F.h>
#include <TFile.h>
#include <TString.h>
#include <iostream> 

using namespace std;

void run( int EvtMax, TChain* fChain, int m_repeat, bool m_verbose, TString OutputFileName){

  cout << "verbose:"<< m_verbose << endl;

  TH1F h_Zmass("Zmass","",30,0,150);
  TH1F h_El_pT("El_tight_pt","",30,0,150);
  TH1F h_El_N("El_N","",10,0,10);
  TObjArray OutputList;
  OutputList.Add((TObject*)&h_Zmass);
  OutputList.Add((TObject*)&h_El_pT);
  OutputList.Add((TObject*)&h_El_N);
  TObjArray ElectronContainer;

  Int_t           El_N;
  vector<double>  *El_E;
  vector<double>  *El_p_T;
  vector<double>  *El_phi;
  vector<double>  *El_eta;
  vector<double>  *El_charge;
  vector<int>     *El_IsEM;
  vector<int>     *El_author;

  TBranch        *b_El_N;   
  TBranch        *b_El_E;   
  TBranch        *b_El_p_T; 
  TBranch        *b_El_phi; 
  TBranch        *b_El_eta; 
  TBranch        *b_El_charge; 
  TBranch        *b_El_IsEM;  
  TBranch        *b_El_author; 

  El_E = 0;
  El_p_T = 0;
  El_phi = 0;
  El_eta = 0;
  El_charge = 0;
  El_IsEM = 0;
  El_author = 0;

  fChain->SetBranchAddress("El_N", &El_N, &b_El_N);
  fChain->SetBranchAddress("El_E", &El_E, &b_El_E);
  fChain->SetBranchAddress("El_p_T", &El_p_T, &b_El_p_T);
  fChain->SetBranchAddress("El_phi", &El_phi, &b_El_phi);
  fChain->SetBranchAddress("El_eta", &El_eta, &b_El_eta);
  fChain->SetBranchAddress("El_charge", &El_charge, &b_El_charge);
  fChain->SetBranchAddress("El_IsEM", &El_IsEM, &b_El_IsEM);
  fChain->SetBranchAddress("El_author", &El_author, &b_El_author);

  fChain->GetEntry(0) ;
  TLorentzVector *elec, *el1, *el2;;
  TLorentzVector zboson;
  for(int entry=0; entry<EvtMax; entry++){
    if(entry%100000==0) cout << entry << endl;
    Long64_t ientry = fChain->LoadTree(entry);
    b_El_N->GetEntry(ientry);
    b_El_E->GetEntry(ientry);
    b_El_p_T->GetEntry(ientry);
    b_El_phi->GetEntry(ientry);
    b_El_eta->GetEntry(ientry);
    b_El_IsEM->GetEntry(ientry);

    for(int repeat=0; repeat<m_repeat; ++repeat){
      int elcounter=0;
      ElectronContainer.Clear();
      h_El_N.Fill(El_N);
      for( Int_t i = 0; i < El_N; ++i ) {
        h_El_pT.Fill((( * El_p_T )[ i ])/1000.);
        if (!( (*El_IsEM)[i] & 933875)==0) continue;
        if (!( (*El_p_T)[i] < 25000)==0) continue;
        elec = new TLorentzVector();
        elec->SetPtEtaPhiE((( * El_p_T )[ i ]),(( * El_eta )[ i ]),  (( * El_phi )[ i ]), (( * El_E )[ i ]) ) ;
        ElectronContainer.Add( elec);
        elcounter++;
      }

      if( elcounter==2 ) {
        if(m_verbose) cout << "found 2 good elec" << endl;
        el1=(TLorentzVector *) ElectronContainer.At(0);;
        el2=(TLorentzVector *) ElectronContainer.At(1);;
        zboson = *el1 + *el2 ;
        h_Zmass.Fill( zboson.M()/1000. );
      }
      ElectronContainer.Clear();
    }
  }

  TFile f(OutputFileName, "recreate");
  f.cd();
  OutputList.Write();
  f.Close();
}
