#define TSelector_Ntuple_Zee_cxx

#include "TSelector_Ntuple_Zee.h"
#include <TH2.h>
#include <TStyle.h>
#include <iostream>
   TLorentzVector zboson;
   TLorentzVector *elec, *el1,*el2;

void TSelector_Ntuple_Zee::Begin(TTree * /*tree*/)
{
   TString options(GetOption());
   cout<< "option" << options  << endl;
   if( options.Index('t')>0 &&  options.Index('t') < options.Index(":")) {
    options.Replace(options.Index("t"), 1 , "");
    cout<< "doTrack, remaining option " << options << endl;
   }
   if(options.Index('v') >0 &&  options.Index('v') < options.Index(":") ) {
    options.Replace(options.Index("v"), 1 , "");
    cout<< "verbose, remaining option " << options << endl;
    m_verbose=true;
   }
    cout<< "remaining option " << options << endl;
   if( options.Index(':') !=kNPOS) {
     options.Replace(0, 1,"");
     OutputFileName=TString(options(0, options.Index(":")));
     options.Replace(0, options.Index(":")+1, "");
   }
   m_repeat=10; //OPtions.Atoi();
   ElectronContainer = new TObjArray();
   cout<< "repeat: " << m_repeat  << endl;
   newFile = new TFile("junk1.root","RECREATE");

}

void TSelector_Ntuple_Zee::SlaveBegin(TTree * /*tree*/)
{
   TString options(GetOption());
   cout<< "option" << options  << endl;
   if( options.Index('t')>0 &&  options.Index('t') < options.Index(":")) {
    options.Replace(options.Index("t"), 1 , "");
    cout<< "doTrack, remaining option " << options << endl;
   }
   if(options.Index('v') >0 &&  options.Index('v') < options.Index(":") ) {
    options.Replace(options.Index("v"), 1 , "");
    cout<< "verbose, remaining option " << options << endl;
    m_verbose=true;
   }
    cout<< "remaining option " << options << endl;
   if( options.Index(':') !=kNPOS) {
     options.Replace(0, 1,"");
     OutputFileName=TString(options(0, options.Index(":")));
     options.Replace(0, options.Index(":")+1, "");
   }
   m_repeat=10; //options.Atoi();
   cout<< "repeat: " << m_repeat  << endl;

   TString option = GetOption();
   h_Zmass  = new TH1F("Zmass","",30,0,150);
   h_El_N   = new TH1F("El_N","",10,0,10);
   h_El_pt  = new TH1F("El_pt","",30,0,150);
   fOutput->Add(h_Zmass);
   fOutput->Add(h_El_N);
   fOutput->Add(h_El_pt);

}

Bool_t TSelector_Ntuple_Zee::Process(Long64_t entry)
{
  // entry is the entry number in the current TTree
  Long64_t chain_entry = fChain->GetChainEntryNumber(entry);
  if ( chain_entry%100000==0) cout << chain_entry<<endl;
  b_El_N->GetEntry(entry);
  b_El_E->GetEntry(entry);
  b_El_p_T->GetEntry(entry);
  b_El_phi->GetEntry(entry);
  b_El_eta->GetEntry(entry);
  b_El_IsEM->GetEntry(entry);
   for(int repeat=0; repeat<m_repeat; ++repeat){
     int elcounter=0;
     h_El_N->Fill(El_N);
     for( Int_t i = 0; i < El_N; ++i ) {
       h_El_pt->Fill(( * El_p_T )[ i ]/1000.);
       if (!( (*El_IsEM)[i] & 933875)==0) continue;
       if (!( (*El_p_T)[i] < 25000)==0) continue;
       elec = new TLorentzVector();
       elec->SetPtEtaPhiE((( * El_p_T )[ i ]),(( * El_eta )[ i ]),  (( * El_phi )[ i ]), (( * El_E )[ i ]) ) ;
     
       ElectronContainer->Add( elec);
       elcounter++;
      }

     if( elcounter==2 ) {
        if (m_verbose) cout <<"found pair"<<endl;
        el1=(TLorentzVector *) ElectronContainer->At(0);;
        el2=(TLorentzVector *) ElectronContainer->At(1);;
        zboson = *el1 + *el2 ;
        h_Zmass->Fill( zboson.M()/1000. );
     }
     ElectronContainer->Clear();
   }
   return kTRUE;
}

void TSelector_Ntuple_Zee::SlaveTerminate()
{

}

void TSelector_Ntuple_Zee::Terminate()
{
   newFile->cd();
   GetOutputList()->Write();
   newFile->Close();
}
