
#ifndef TSelector_Ntuple_Zee_h
#define TSelector_Ntuple_Zee_h

#include <TROOT.h>
#include <TChain.h>
#include <TFile.h>
#include <TSelector.h>
#include <TObjArray.h>
#include <TH1F.h>
#include <vector>
#include <iostream>
#include <TLorentzVector.h>

#if defined (__MAKECINT__)
//#pragma link C++ class vector<Double_t>+;
//#pragma link C++ class vector<double>+;
//#pragma link C++ class vector<vector<double> >+;
//#pragma link C++ class vector<int>+;
//#pragma link C++ class vector<float>+;
//#pragma link C++ class vector<long>+;
#endif 

using namespace std;
class TSelector_Ntuple_Zee : public TSelector {
public :
   TTree          *fChain;   //!pointer to the analyzed TTree or TChain
   TFile *newFile;

   TH1F * h_Zmass;
   TH1F * h_El_N;
   TH1F * h_El_pt;
   TObjArray *ElectronContainer;
   TString OutputFileName;

   // Declaration of leaf types
   Int_t           El_N;
   vector<double>  *El_E;
   vector<double>  *El_p_T;
   vector<double>  *El_phi;
   vector<double>  *El_eta;
   vector<int>     *El_IsEM;
   vector<int>     *El_author;
   vector<double>  *El_charge;

   TBranch        *b_El_N;   //!
   TBranch        *b_El_E;   //!
   TBranch        *b_El_p_T;   //!
   TBranch        *b_El_phi;   //!
   TBranch        *b_El_eta;   //!
   TBranch        *b_El_IsEM;   //!
   TBranch        *b_El_author;   //!
   TBranch        *b_El_charge;   //!

   TSelector_Ntuple_Zee(TTree * /*tree*/ =0) { 
     m_verbose=false;
     m_repeat=1;
   }
   virtual ~TSelector_Ntuple_Zee() { }
   virtual Int_t   Version() const { return 2; }
   virtual void    Begin(TTree *tree);
   virtual void    SlaveBegin(TTree *tree);
   virtual void    Init(TTree *tree);
   virtual Bool_t  Notify();
   virtual Bool_t  Process(Long64_t entry);
   virtual void    SetOption(const char *option) { fOption = option; }
   virtual void    SetObject(TObject *obj) { fObject = obj; }
   virtual void    SetInputList(TList *input) { fInput = input; }
   virtual TList  *GetOutputList() const { return fOutput; }
   virtual void    SlaveTerminate();
   virtual void    Terminate();

   Bool_t m_verbose;
   Int_t m_repeat;

   ClassDef(TSelector_Ntuple_Zee,0);
};

#endif

#ifdef TSelector_Ntuple_Zee_cxx
void TSelector_Ntuple_Zee::Init(TTree *tree)
{
   using namespace std;
   // Set object pointer
   El_E = 0;
   El_p_T = 0;
   El_phi = 0;
   El_eta = 0;
   El_IsEM = 0;
   El_author = 0;

   El_charge = 0;
   // Set branch addresses and branch pointers
   if (!tree) return;
   fChain = tree;
   //fChain->SetMakeClass(1);

   fChain->SetBranchAddress("El_N", &El_N, &b_El_N);
   fChain->SetBranchAddress("El_E", &El_E, &b_El_E);
   fChain->SetBranchAddress("El_p_T", &El_p_T, &b_El_p_T);
   fChain->SetBranchAddress("El_phi", &El_phi, &b_El_phi);
   fChain->SetBranchAddress("El_eta", &El_eta, &b_El_eta);
   fChain->SetBranchAddress("El_IsEM", &El_IsEM, &b_El_IsEM);
   fChain->SetBranchAddress("El_author", &El_author, &b_El_author);
   fChain->SetBranchAddress("El_charge", &El_charge, &b_El_charge);
}

Bool_t TSelector_Ntuple_Zee::Notify()
{

   //Info("Notify","processing file: %s",fChain->GetCurrentFile()->GetName());
   return kTRUE;
}

#endif // #ifdef TSelector_Ntuple_Zee_cxx
