#define MySelector_cxx
// The class definition in MySelector.h has been generated automatically
// by the ROOT utility TTree::MakeSelector(). This class is derived
// from the ROOT class TSelector. For more information on the TSelector
// framework see $ROOTSYS/README/README.SELECTOR or the ROOT User Manual.

// The following methods are defined in this file:
//    Begin():        called everytime a loop on the tree starts,
//                    a convenient place to create your histograms.
//    SlaveBegin():   called after Begin(), when on PROOF called only on the
//                    slave servers.
//    Process():      called for each event, in this function you decide what
//                    to read and fill your histograms.
//    SlaveTerminate: called at the end of the loop on the tree, when on PROOF
//                    called only on the slave servers.
//    Terminate():    called at the end of the loop on the tree,
//                    a convenient place to draw/fit your histograms.
//
// To use this file, try the following session on your Tree T:
//
// Root > T->Process("MySelector.C")
// Root > T->Process("MySelector.C","some options")
// Root > T->Process("MySelector.C+")
//
#include "Bytes.h"

#include "MySelector.h"
#include <TH2.h>
#include <TStyle.h>

//#include "/home/ganis/local/root/test/isidro/prooftrial/MyCounter.h"
#include "MyCounter.h"
#include <iostream>
using std::cout;
using std::endl;


///////// COUNTER
MyCounter* myc = 0;
///////// COUNTER

void MySelector::Begin(TTree *tree)
{
  // The Begin() function is called at the start of the query.
  // When running with PROOF Begin() is only called on the client.
  // The tree argument is deprecated (on PROOF 0 is passed).
  
  cout << "==> Begin(" << tree << ")" << endl;

  TString option = GetOption();
  cout << "    * Option = \"" << option << "\"" << endl;
  
  cout << "<== Begin(" << tree << ")" << endl;
}

void MySelector::SlaveBegin(TTree *tree)
{
  // The SlaveBegin() function is called after the Begin() function.
  // When running with PROOF SlaveBegin() is called on each slave server.
  // The tree argument is deprecated (on PROOF 0 is passed).
  cout << "==> SlaveBegin(TTree*)" << endl;
  
  Init(tree);
  
  TString option = GetOption();
  cout << "    * Option = \"" << option << "\"" << endl;

  ///////// COUNTER
  myc = new MyCounter;
  fOutput->Add(myc);
  ///////// COUNTE

  cout << "    * List of objects in fOutput: " << endl;
  for (int i = 0; i < fOutput->GetEntries(); i++)
    cout << "      + fOutput[" << i << "] = " 
	 << fOutput->At(i)->GetName() << endl;
  cout << "<== SlaveBegin(TTree*)" << endl;
}

Bool_t MySelector::Process(Long64_t entry)
{
   // The Process() function is called for each entry in the tree (or possibly
   // keyed object in the case of PROOF) to be processed. The entry argument
   // specifies which entry in the currently loaded tree is to be processed.
   // It can be passed to either TTree::GetEntry() or TBranch::GetEntry()
   // to read either all or the required parts of the data. When processing
   // keyed objects with PROOF, the object is already loaded and is available
   // via the fObject pointer.
   //
   // This function should contain the "body" of the analysis. It can contain
   // simple or elaborate selection criteria, run algorithms on the data
   // of the event and typically fill histograms.

   // WARNING when a selector is used with a TChain, you must use
   //  the pointer to the current TTree to call GetEntry(entry).
   //  The entry is always the local entry number in the current tree.
   //  Assuming that fChain is the pointer to the TChain being processed,
   //  use fChain->GetTree()->GetEntry(entry).
  cout << "==> Process(" << entry << ")" << endl;


  ///////// COUNTER
  cout << "    + Incrementing counter from " << myc->GetValue();
  myc->Increment();
  cout << " to " << myc->GetValue() << endl;
  ///////// COUNTER

  cout << "<== Process(" << entry << ")" << endl;
   return kTRUE;
}

void MySelector::SlaveTerminate()
{
   // The SlaveTerminate() function is called after all entries or objects
   // have been processed. When running with PROOF SlaveTerminate() is called
   // on each slave server.

  cout << "==> SlaveTerminate()" << endl;
  cout << (int *)myc<<": counter is: " << myc->GetValue() << endl;

}

void MySelector::Terminate()
{
   // The Terminate() function is the last function to be called during
   // a query. It always runs on the client, it can be used to present
   // the results graphically or save the results to file.

  cout << "==> Terminate()" << endl;

  ///////// COUNTER
  //
  // This should work, but it does not because of a bug being fixed
  // myc = dynamic_cast<MyCounter*>(fOutput->FindObject("MyCounter"));
  //
  Int_t nout = 0;
  TIter no(fOutput);
  TObject *ob = 0;
  while ((ob = no())) {
     cout << ob->GetName() << endl;
     if (!strcmp(ob->GetName(),"MyCounter")) {
        myc = (MyCounter *)ob;
        cout << "Number of events = " << myc->GetValue() << endl;
        nout++;
     }
  }
  if (nout > 0) {
     cout << "Number of MyCounter objects = " << nout << endl;
  } else {
    Error("Terminate", "Unable to retrieve any MyCounter object!");
    cerr << "    * List of objects in fOutput: " << endl;
    for (int i = 0; i < fOutput->GetEntries(); i++)
      cerr << "      + fOutput[" << i << "] = " 
	   << fOutput->At(i)->GetName() << endl;
  }
  ///////// COUNTER

  cout << "<== Terminate()" << endl;
}
