//Using of matrixRoot :
 
void matrixRoot()
{
  gSystem->Load("matrixRoot"); // to load matrixRoot
  matrixRoot a("alpha.txt");   // to read the ascii file
  a.Print();

  Float_t value[3] = {21, 22, 23}; // And other type of constructor
  TVector vb(3, value);            // using TVector
  matrixRoot b(vb);
  b.PrintAscii();

  // Print Number of lines, colomn and elements of the matrixRoot
  cout << "Number of lines :" << a.GetNRow() << endl;
  cout << "Number of columns :" << a.GetNCol() << endl;
  cout << "Number of elements:" << a.GetNelt() << endl;
  cout << endl;

  // Print two elements of the matrixRoot
  cout << "elt col=2, row=0 :" << a(0,2) << endl;  
  cout << "elt col=1, row=3 :" << a(3,1) << endl;  

  // Change a value of the matrixRoot
  a(3,1) = 200.;
  cout << "a(3,1) =200 ? ---->  " << a(3,1) << endl << endl;

  // Sort by the colomn 0 the matrixRoot
  a.SortByCol(0);
  cout << "matrixRoot sort by the colomn 0 : " << endl;
  a.Print();

  // Get just a colomn (=TVector)
  TVector colo0(a.GetNRow());
  colo0 = a.GetCol(0);         // colo is the colomn 0
  cout << "colonne 0 : ";
  for(int i=0; i < a.GetNRow() ; i++) cout << colo0(i) << "  ";
  cout << endl << endl;


  // Multiplication of the matrixRoot by a value 
  cout << "Multiplication of the matrixRoot by 2.3" << endl;
  matrixRoot w;
  w = a*2.3;
  w.Print();

  //Addition of a new Row
  TVector vect(4); 
  vect(0) = 30.0; vect(1) = 530.0; vect(2) = 0.6; vect(3)=15.0;
  a.AddRow(vect);
  cout << "Addition d'une ligne supplementaire : " << endl;
  a.Print();
  
  // Draw a colomn as a function of an other 
  // The first one is x values, the 2nd is y values, 
  // the 3rd is errors on x, and the 4rd is errors on y
  TGraphErrors *gr = a.GetTGraphErrors(0,1,2,3);
  //TGraphErrors *gr = a.GetTGraphErrors(0,1,2);
  //TGraph *gr = a.GetTGraph(0,1);
  gr->Print();

  gr->Draw("A*");

  // Select a part of the matrixRoot (just value of the colomn 0 where x > 15)
  matrixRoot aselect;
  aselect = a.Select(0,"x>15");
  aselect.PrintAscii(); cout << endl;

  // Execution of a formula on all the components of the matrixRoot :
  matrixRoot aselect_modified = aselect.Execute("sqrt(x)");
  aselect_modified.PrintAscii();

  // Elimination of the colomn 1 
  aselect.DeleteCol(1);
  cout << "On elimine la colonne 1 : " << endl;
  aselect.Print();

  // Create a TNtuple from the matrixRoot
  TNtuple *nt = a.GetTNtuple("ntFromTMatrix");
  nt->Print();
  //nt->Draw("c1:c3");  //---> OK It works
}

