// $Id: matrixRoot.h,v 1.20 2004/11/18 14:05:28 roberfro Exp $
// Class matrix : to create a new matrix from a file
// Author: V.Roberfroid <mailto:roberfroid@fynu.ucl.ac.be>
#ifndef MATRIX_H
#define MATRIX_H

#include <fstream>
#include <stdlib.h>
#include <vector>
#include <iostream>
#include "TObject.h"
#include "TMatrixD.h"
#include "TVector.h"
#include "TGraph.h"
#include "TNtuple.h"
#include "TFormula.h"
#include "TGraphErrors.h"
#include "TString.h"

class matrixRoot : public TObject
{
  private :
    int NRow;
    int NCol;
    int Nelt;
    TMatrixD fIndex;

  public :
    matrixRoot();
    matrixRoot(char *filename);
    matrixRoot(int nr,int nc);
    matrixRoot(const matrixRoot &m);
    matrixRoot(const TVector &v);
    virtual ~matrixRoot();
    void Fill(char *filename);
    void Print();
    void PrintAscii();
    void PrintAscii(char *fileName);
    void AddRow(TVector v);
    void AddCol(TVector v);
    void Delete();
    void DeleteRow(int nrow);
    void DeleteCol(int ncol);
    int IsEmpty();
    int GetNRow(){return NRow;}
    int GetNCol(){return NCol;}
    int GetNelt(){return Nelt;}
    TVector  GetRow(int numrow);
    TVector  GetRow(int numrow, int collw, int colup);
    TVector  GetCol(int numcol);
    TVector  GetCol(int numcol, int rowlw, int rowup);
    double   GetSumCol(int ncol);
    double&  operator() (unsigned row, unsigned col);
    double   operator() (unsigned row, unsigned col) const;
    void     SortByCol(int ncol, int nrowmin, int nrowmax);
    void     SortByCol(int ncol); 
    TGraph*  GetTGraph(int ncolX, int ncolY);
    TGraph*  GetTGraph(int ncolX, int ncolY, int nrowmin, int nrowmax);
    TGraphErrors* GetTGraphErrors(int ncolX, int ncolY, int ncolDX, 
		                  int ncolDY);
    TGraphErrors* GetTGraphErrors(int ncolX, int ncolY, int ncolDY);    
    TNtuple* GetTNtuple(char *NtupleName);
    matrixRoot Execute(TString formula);

    matrixRoot& operator=(const matrixRoot& a);
    matrixRoot& operator=(const TVector& v);
    
    matrixRoot Select(int ncol,char *condition);
    matrixRoot operator+(const matrixRoot&);
    matrixRoot operator+(const double&);
    //matrixRoot operator+(matrixRoot, double);
    matrixRoot operator-(const matrixRoot&);
    //matrixRoot operator-(const double&);
    //matrixRoot operator-(matrixRoot, double);
    matrixRoot operator*(const double&);
    matrixRoot operator*(const matrixRoot& a);
    //matrixRoot operator*(matrixRoot, double);
    matrixRoot operator/(const  double&);
    matrixRoot operator/(const matrixRoot&);
    //matrixRoot operator/(double, matrixRoot);

    ClassDef(matrixRoot,1)
};
#endif
