#define pippo_cxx
// To use this file, try the following session on your Tree T:
//
// Root > T->Process("pippo.C")
// Root > T->Process("pippo.C","some options")
// Root > T->Process("pippo.C+")
//

#include "pippo.h"
#include <TH2.h>
#include <TStyle.h>


double gete25 (double mtr [11][21]) 
{
   double energy = 0. ;
   for (int e = 3 ; e < 8 ; ++e)
     for (int p = 8 ; p < 13 ; ++p)
       energy += mtr[e][p] ;
   return energy ;
}


//PG ====================================================================================


void pippo::Begin(TTree *tree)
{
   TString option = GetOption();

   Pout = new TH1F ("Pout","Pout",1000,0,250) ;
   Pin = new TH1F ("Pin","Pin",1000,0,250) ;
   Ptrue = new TH1F ("Ptrue","Ptrue",1000,0,250) ;
   PoutOPin = new TH1F ("PoutOPin","PoutOPin",1000,0,5) ;
   Pin_l_Pout = new TH1F ("Pin-Pout","Pin-Pout",1000,0,250) ;
   Ptrue_l_Pin = new TH1F ("Ptrue-Pin","Ptrue-Pin",1000,0,250) ;
   Ptrue_l_Pout = new TH1F ("Ptrue-Pout","Ptrue-Pout",1000,0,250) ;

   Doi_ptrue = new TH2F ("Doi_ptrue","Doi_ptrue",
                         1000,0,250,1000,0,250) ;
   //Doi_ebrem_cut = new TH2F ("Doi_ebrem_cut","Doi_ebrem_cut",
   //                      1000,0,400,1000,0,250) ;
   Roi_ptrue = new TH2F ("Roi_ptrue","Roi_ptrue",
                         1000,0,250,1000,0,5) ;
   //Roi_ebrem_cut = new TH2F ("Roi_ebrem_cut","Roi_ebrem_cut",
   //                      1000,0,400,1000,0,5) ;

   Dot_ptrue = new TH2F ("Dot_ptrue","Dot_ptrue",
                         1000,0,250,1000,0,250) ;
   //Dot_ebrem_cut = new TH2F ("Dot_ebrem_cut","Dot_ebrem_cut",
   //                      1000,0,400,1000,0,250) ;
   Rot_ptrue = new TH2F ("Rot_ptrue","Rot_ptrue",
                         1000,0,250,1000,0,5) ;
   //Rot_ebrem_cut = new TH2F ("Rot_ebrem_cut","Rot_ebrem_cut",
   //                      1000,0,400,1000,0,5) ;

   char nome[120] ;
   for (int taglio = 0 ; taglio < 20 ; ++taglio)
     {
       sprintf (nome,"Doi_ptrue_cut_%d",taglio) ;
       Doi_ptrue_cut[taglio] = new TH2F (nome,nome,
                                        1000,0,250,1000,0,250) ;
       sprintf (nome,"Doi_ebrem_cut_%d",taglio) ;
       Doi_ebrem_cut[taglio] = new TH2F (nome,nome,
                                         1000,0,400,1000,0,250) ;
       sprintf (nome,"Roi_ptrue_cut_%d",taglio) ;
       Roi_ptrue_cut[taglio] = new TH2F (nome,nome,
                                         1000,0,250,1000,0,5) ;
       sprintf (nome,"Roi_ebrem_cut_%d",taglio) ;
       Roi_ebrem_cut[taglio] = new TH2F (nome,nome,
                                         1000,0,400,1000,0,5) ;

       sprintf (nome,"Doi_ptrue_stdcut_%d",taglio) ;
       Doi_ptrue_stdcut[taglio] = new TH2F (nome,nome,
                                            1000,0,250,1000,0,250) ;
       sprintf (nome,"Doi_ebrem_stdcut_%d",taglio) ;
       Doi_ebrem_stdcut[taglio] = new TH2F (nome,nome,
                                            1000,0,400,1000,0,250) ;
       sprintf (nome,"Roi_ptrue_stdcut_%d",taglio) ;
       Roi_ptrue_stdcut[taglio] = new TH2F (nome,nome,
                                            1000,0,250,1000,0,5) ;
       sprintf (nome,"Roi_ebrem_stdcut_%d",taglio) ;
       Roi_ebrem_stdcut[taglio] = new TH2F (nome,nome,
                                            1000,0,400,1000,0,5) ;
     }

   e25oPin_eta = new TH2F ("e25oPin_eta","e25oPin_eta",
                           85,0,1.49,1000,0,250) ;
   for (int taglio = 0 ; taglio < 20 ; ++taglio)
     {
       sprintf (nome,"e25oPin_eta_cut_%d",taglio) ;
       e25oPin_eta_cut[taglio] = new TH2F (nome,nome,
                                           85,0,1.49,1000,0,250) ;
       sprintf (nome,"e25oPin_eta_stdcut_%d",taglio) ;
       e25oPin_eta_stdcut[taglio] = new TH2F (nome,nome,
                                              85,0,1.49,1000,0,250) ;
     }

}


//PG ====================================================================================


Bool_t pippo::Process(Long64_t entry)
{
   // WARNING when a selector is used with a TChain, you must use
   //  the pointer to the current TTree to call GetEntry(entry).
   //  The entry is always the local entry number in the current tree.
   //  Assuming that fChain is the pointer to the TChain being processed,
   fChain->GetTree()->GetEntry(entry).
   //PG att che questo potrebbe portare a girare soltanto sul primo albero
   //PG nel qual caso, come si faccia a girare sugli altri alberi devo indagare

   //Pout->Fill (EGCO_electron_Tr_Out_Pmag_[0]) ;
   //Pin->Fill (EGCO_electron_Tr_Pmag_[0]) ;
   //Ptrue->Fill (EGEle_electron_Tr_Mc_Pmag_[0]) ;
   //if (EGCO_electron_Tr_Pmag_[0]) 
   //  PoutOPin->Fill (EGCO_electron_Tr_Out_Pmag_[0] / EGCO_electron_Tr_Pmag_[0]) ;
   //Pin_l_Pout->Fill (EGCO_electron_Tr_Pmag_[0] - EGCO_electron_Tr_Out_Pmag_[0]) ;
   //Ptrue_l_Pin->Fill (EGEle_electron_Tr_Mc_Pmag_[0] - EGCO_electron_Tr_Pmag_[0]) ;
   //Ptrue_l_Pout->Fill (EGEle_electron_Tr_Mc_Pmag_[0] - EGCO_electron_Tr_Out_Pmag_[0]) ;

   //Doi_ptrue->Fill (EGEle_electron_Tr_Mc_Pmag_[0] ,
   //                 EGCO_electron_Tr_Pmag_[0] - EGCO_electron_Tr_Out_Pmag_[0]) ; 
   //Doi_ebrem->Fill (EGEle_mc_ebrem_[0],
   //                 EGCO_electron_Tr_Pmag_[0] - EGCO_electron_Tr_Out_Pmag_[0]) ;
   if (EGCO_electron_Tr_Pmag_[0]) 
     {
       Roi_ptrue->Fill (EGEle_electron_Tr_Mc_Pmag_[0] ,
                        EGCO_electron_Tr_Out_Pmag_[0] / EGCO_electron_Tr_Pmag_[0]) ; 
       Roi_ebrem->Fill (EGEle_mc_ebrem_[0],
                        EGCO_electron_Tr_Out_Pmag_[0] / EGCO_electron_Tr_Pmag_[0]) ;
     }
  
   Dot_ptrue->Fill (EGEle_electron_Tr_Mc_Pmag_[0] ,
                    EGEle_electron_Tr_Mc_Pmag_[0] - EGCO_electron_Tr_Out_Pmag_[0]) ; 
   Dot_ebrem->Fill (EGEle_mc_ebrem_[0],
                    EGEle_electron_Tr_Mc_Pmag_[0] - EGCO_electron_Tr_Out_Pmag_[0]) ;
   if (EGCO_electron_Tr_Pmag_[0]) 
     {
       Rot_ptrue->Fill (EGEle_electron_Tr_Mc_Pmag_[0] ,
                        EGCO_electron_Tr_Out_Pmag_[0] / EGEle_electron_Tr_Mc_Pmag_[0]) ; 
       Rot_ebrem->Fill (EGEle_mc_ebrem_[0],
                        EGCO_electron_Tr_Out_Pmag_[0] / EGEle_electron_Tr_Mc_Pmag_[0]) ;
     }
  
   //PG get the energy of hte 5x5 matrix
   double E25 = gete25 (EGCO_myCalibrationMap) ;

   if (EGCO_electron_Tr_Pmag_[0]) 
     e25oPin_eta->Fill (EGCO_electron_Tr_Peta_[0] ,
                        E25/EGCO_electron_Tr_Pmag_[0]) ;
  
  //PG MANCANO I TAGLI VARI!! FIXME
  
  
   return kTRUE;
}


//PG ====================================================================================


void pippo::Terminate()
{
  TFile salvo ("histos.root","RECREATE") ;
  salvo.cd () ;

  Pout->Write () ;
  Pin->Write () ;
  Ptrue->Write () ;
  PoutOPin->Write () ;
  Pin_l_Pout->Write () ;
  Ptrue_l_Pin->Write () ;
  Ptrue_l_Pout->Write () ;

  Doi_ptrue->Write () ; 
  Doi_ebrem->Write () ;
  Roi_ptrue->Write () ;
  Roi_ebrem->Write () ;
  
  Dot_ptrue->Write () ;
  Dot_ebrem->Write () ;
  Rot_ptrue->Write () ;
  Rot_ebrem->Write () ;

   for (int taglio = 0 ; taglio < tagli ; ++taglio)
     {
       Doi_ptrue_cut[taglio]->Write () ; 
       Doi_ebrem_cut[taglio]->Write () ;
       Roi_ptrue_cut[taglio]->Write () ;
       Roi_ebrem_cut[taglio]->Write () ;

       Doi_ptrue_stdcut[taglio]->Write () ;
       Doi_ebrem_stdcut[taglio]->Write () ;
       Roi_ptrue_stdcut[taglio]->Write () ; 
       Roi_ebrem_stdcut[taglio]->Write () ;
    }

  e25oPin_eta->Write () ;

   for (int taglio = 0 ; taglio < tagli ; ++taglio)
     {
       e25oPin_eta_cut[taglio]->Write () ;
       e25oPin_eta_stdcut[taglio]->Write () ;
     }

  salvo.Close () ;

}
