//**********************************************************************
//* test code demonstrating ROOT problem                               *
//**********************************************************************
#include "Decoder.h"

// data structs to write to ROOT TTree
#include "Channel.h"
#include "Event.h"

// system includes
#include <iostream>

//ROOT includes
#include "TROOT.h"
#include "TFile.h"
#include "TTree.h"

using namespace std;

Decoder::Decoder(bool verbose=false) :
  fVerbose(verbose)
{
  fData = new Event();

  cout << "Size of Event: " << sizeof(Event) << endl;

};

Decoder::~Decoder() {
  delete fData;

  if (fRootFile && fRootFile->IsOpen()) {
    fRootFile->Close();
    delete fRootFile;
    fRootFile = NULL;
  };

}

void Decoder::BookTree(char* rootFileName) {

  fRootFile = new TFile(rootFileName,"RECREATE");
  fTree = new TTree("EventTree","Tree for TFB output");
 
  fTree->Branch("evt","Event", &fData, 64000, 1);
}

int Decoder::ReadData(char* rootFileName) {
  if (!fRootFile)
    this->BookTree(rootFileName);
 
  // this is a mock tree filling loop
  Int_t event = 0;
  for (UInt_t i=0; i<5; ++i) {
    fTree->Fill(); // make one tree entry per cycle	    
    event++;
  }
  return event;
}

void Decoder::WriteAll() {
  if (!fRootFile) {
    cout << "Output file not opened! Returning without writing."
	 << endl;
    return;
  }

  fRootFile->Write();
}   
