//system includes
#include <iostream> 
#include <unistd.h> // using getopt
#include <string>

// this is where all the work is done
#include "Decoder.h"

using namespace std;
void PrintUsage() {
  cout << endl 
       << "USAGE:\t" << "readTFBFile [-h] [-v]"
       << " [-o outfile] infile"
       << endl << endl;
}

void PrintHelp() {

  cout << "-h \t\t display this help message" << endl
       << "-v \t\t verbose mode (print ADC values to screen)" << endl
       << "-o <outfile>\t output (ROOT) file name;" 
       << " default is <infile>.root" << endl
       << "infile\t\t name of input file (TFB data)"
       << endl << endl;
}

int main(int argc, char* argv[]) {

  char* filename = new char[100];
  char* outfile = new char[100];
  outfile = NULL;
  bool verbose = false;
  
  int c = -1;

  // deal with command line arguments
  while ((c = getopt(argc, argv, "ho:v")) != -1) {
    switch(c) {
    case 'h':
      PrintUsage();
      PrintHelp();
      exit(1);
      break;
    case 'o':
      outfile = optarg;
      cout << "Output file name is " << outfile << endl;
      break;
    case ':':
      printf("-%c without file name\n", optopt);
      PrintUsage();    
      exit(1);
      break;
    case 'v':
      cout << "Verbose output selected." << endl;
      verbose = true;
      break;
    case '?':
      printf("Unknown option %c\n",optopt);
      PrintUsage();
      exit(1);
      break;
    }
  }
  // check minimum number of command line arguments
  if ( argc<2 || (optind == argc) ) {
    cout << "Too few command line arguments. Did you secify the input file?"
	 << endl;
    PrintUsage();
    exit(1);
  }
  
  // read input file name
  if ( optind < argc ) {
    filename = argv[optind++];
    cout << "Input file name is: " << filename << endl;
  }
   
  // make Decoder
  Decoder decode(verbose);
  
  // book tree for output
  // if outfile hasn't been set by command line option, set it here
  string rootFileName(filename);
  rootFileName += ".root";
  if (!outfile)
    outfile = (char*)rootFileName.c_str();

  decode.BookTree(outfile);
  
  // now read the binary data from file
  int events = decode.ReadData(filename);

  // write TTree and histograms to file
  decode.WriteAll();

  cout << "Reached end of file!  "<< endl;
  cout << "Total number of events: " << dec << events << endl;

  exit(0); 
}
