// $Id: Ex03RunConfiguration.cxx,v 1.1.1.1 2002/09/27 10:00:03 rdm Exp $
// Category: run
//
// Author: I. Hrivnacova
//
// Class Ex03RunConfiguration
// --------------------------
// See the class description in the header file.

#include "Ex03RunConfiguration.h"
#include "TG4DetConstruction.h"
#include "TG4SDConstruction.h"
#include "TG4PrimaryGeneratorAction.h"
#include "TG4RunAction.h"
#include "TG4EventAction.h"
#include "TG4TrackingAction.h"
#include "TG4SteppingAction.h"
#include "TG4Globals.h"

#include <G4RunManager.hh>
#include <ExN03PhysicsList.hh>

//_____________________________________________________________________________
Ex03RunConfiguration::Ex03RunConfiguration()
  : TG4VRunConfiguration() {
//

  CreateUserConfiguration();
}

//_____________________________________________________________________________
Ex03RunConfiguration::~Ex03RunConfiguration(){
//
}

//
// protected methods
//


//_____________________________________________________________________________
void Ex03RunConfiguration::CreateUserConfiguration()
{
// Creates the mandatory Geant4 classes and 
// the other user action classes. 
// ---

  // create mandatory Geant4 classes
  fDetectorConstruction = new TG4DetConstruction();
  fSDConstruction = new TG4SDConstruction();
  fPhysicsList = new ExN03PhysicsList();
  fPrimaryGenerator = new TG4PrimaryGeneratorAction();

  // create the other user action classes
  fRunAction  = new TG4RunAction();
  fEventAction  = new TG4EventAction();
  fTrackingAction = new TG4TrackingAction();
  fSteppingAction = new TG4SteppingAction();
}
